private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "__CIpow_pentium4"
		size = 2912
		refs = "0023 SIGMASK 002b ONEMASK 005c rcp_t1 0070 log2_t1 00ab HALFSIG 00d7 rcp_t2 00eb log2_t2 011d LHN 0133 rcp_t3 0145 log2_t3 022e clv 0289 Shifter 02ad exp2_tbl 02b5 cev 0371 ABSVALMASK 042f NEG_ZERO 0642 NEG_INF 06be sNaN 06c6 QIND 07a9 INF 0844 ___libm_error_support 0a7d EMIN 0aaa NEG_BIG 0ab2 POS_BIG"
	strings:
		$1 = { 55 8B EC 83 EC 10 83 E4 F0 D9 C9 DD 1C 24 DD 5C 24 08 E8 02 00 00 00 C9 C3 66 0F 12 44 24 04 66 0F 12 3D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 66 0F 54 F8 F2 0F 10 E0 66 0F 73 D0 2C 66 0F C5 C0 00 66 0F 56 FA 66 0F C5 CC 03 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 3C 85 ?? ?? ?? ?? 66 0F 12 2C 85 ?? ?? ?? ?? 03 C0 66 0F 28 34 85 ?? ?? ?? ?? BA EF 7F 00 00 2B D1 83 E9 10 0B CA 81 F9 00 00 00 80 0F 83 DB 02 00 00 B9 00 00 00 00 BA 7F FE 03 00 66 0F 6E CA 66 0F FB C1 66 0F 73 D0 08 F3 0F E6 C0 66 0F 12 0D ?? ?? ?? ?? F2 0F 10 DF 66 0F 73 D7 26 66 0F C5 C7 00 66 0F 54 25 ?? ?? ?? ?? 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 1C 85 ?? ?? ?? ?? F2 0F 59 2C 85 ?? ?? ?? ?? 03 C0 66 0F 58 34 85 ?? ?? ?? ?? 66 0F 56 25 ?? ?? ?? ?? F2 0F 58 F0 66 0F 54 CC F2 0F 10 D3 66 0F 73 D3 1F 66 0F C5 C3 00 66 0F 12 05 ?? ?? ?? ?? F2 0F 5C E1 66 0F 12 3D ?? ?? ?? ?? 25 FF 01 00 00 83 C0 01 25 FE 03 00 00 F2 0F 59 2C 85 ?? ?? ?? ?? F2 0F 59 14 85 ?? ?? ?? ?? 66 0F 58 34 C5 ?? ?? ?? ?? 66 0F 54 C5 F2 0F 5C E8 F2 0F 58 FA F2 0F 10 D8 F2 0F 59 C1 F2 0F 59 CD F2 0F 59 DC F2 0F 5C D0 F2 0F 59 E5 F2 0F 10 C6 F2 0F 5C D1 F2 0F 58 F7 66 0F 12 4C 24 0C 66 0F C5 C1 03 F2 0F 5C D3 F2 0F 5C C6 66 0F 12 1D ?? ?? ?? ?? 66 0F C5 D6 03 F2 0F 5C D4 F2 0F 10 E6 F2 0F 58 C7 F2 0F 5C FA F2 0F 5C F2 66 0F 14 FF 25 F0 7F 00 00 3D F0 7F 00 00 0F 83 17 05 00 00 81 E2 F0 7F 00 00 2D F0 3F 00 00 03 C2 BA A0 40 00 00 2B D0 2D 70 3C 00 00 0B D0 81 FA 00 00 00 80 0F 83 E4 08 00 00 F2 0F 5C E6 F2 0F 5C D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 54 D9 66 0F 54 E6 F2 0F 5C C2 66 0F 57 D2 BA 60 40 00 00 66 0F C4 D2 03 F2 0F 10 EB F2 0F 59 DC F2 0F 5C F4 F2 0F 5C CD F2 0F 59 DA F2 0F 59 EE 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 2D C3 F2 0F 59 F1 66 0F 28 0D ?? ?? ?? ?? F2 0F 58 EC 66 0F 70 E6 EE F2 0F 58 EE BA 7F FF 01 00 2B D0 05 FF E1 01 00 0B D0 2D FF E1 01 00 83 FA 00 0F 8E E1 05 00 00 03 C8 83 E0 7F 83 E1 80 81 C1 80 FF 01 00 F2 0F 58 E0 F2 0F 10 C3 F2 0F 58 1D ?? ?? ?? ?? 66 0F 59 D7 F2 0F 5C 1D ?? ?? ?? ?? 66 0F 59 FF F2 0F 5C C3 03 C0 03 C0 03 C0 03 C0 66 0F 28 98 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 CF 66 0F 58 D1 66 0F 70 CA EE F2 0F 59 D7 66 0F 57 FF BA 80 3F 00 00 F2 0F 58 D1 66 0F C4 FA 03 F2 0F 58 D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 6E C9 F2 0F 59 54 24 0C F2 0F 59 C7 66 0F 73 F1 2D 66 0F 70 C9 44 66 0F 28 3D ?? ?? ?? ?? F2 0F 58 EA 66 0F 59 D9 F2 0F 58 C5 66 0F 14 C0 66 0F 59 F0 F2 0F 59 E0 66 0F 59 C0 66 0F 58 FE 66 0F 59 F8 F2 0F 59 C3 66 0F 70 F7 EE F2 0F 59 C7 66 0F 70 EB EE F2 0F 59 F3 F2 0F 59 E3 F2 0F 58 C5 83 EC 10 F2 0F 58 C6 F2 0F 58 C4 F2 0F 58 C3 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 4C 24 0C 66 0F 12 1D ?? ?? ?? ?? 66 0F 7E C8 F2 0F 10 D1 66 0F 54 CB 66 0F 73 D1 20 66 0F 7E C9 81 F9 00 00 F0 7F 0F 83 DA 00 00 00 0B C1 83 F8 00 0F 84 1C 04 00 00 83 FA 00 0F 8D 05 01 00 00 F7 DA 81 C2 EF 7F 00 00 66 0F 73 F3 34 66 0F 56 D3 B9 F3 03 00 00 66 0F 6E D9 66 0F 73 D1 14 66 0F FA CB 66 0F EF DB 66 0F EE CB 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 8B CA 81 E2 FF 7F 00 00 81 FA F0 7F 00 00 0F 83 A3 01 00 00 25 FF 00 00 00 3D FF 00 00 00 0F 85 8C 02 00 00 66 0F 12 4C 24 0C 66 0F 12 54 24 0C B9 F4 03 00 00 66 0F 6E D9 66 0F 54 0D ?? ?? ?? ?? 66 0F 73 D1 34 66 0F FA CB 66 0F 12 1D ?? ?? ?? ?? 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 25 FF 00 00 00 B9 01 FF 03 00 03 C8 81 E1 00 00 04 00 83 FA 10 72 5E BA 7F FE 0B 00 66 0F 12 1D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? E9 26 FC FF FF 66 0F 12 7C 24 04 66 0F 12 64 24 04 66 0F 7E FA 66 0F 73 D7 20 66 0F 7E F8 8B C8 25 FF FF FF 7F 3D 00 00 F0 7F 0F 82 9A 02 00 00 0F 87 DE 01 00 00 83 FA 00 0F 87 D5 01 00 00 E9 86 02 00 00 B9 00 00 00 00 66 0F 57 C0 B8 F0 43 00 00 66 0F C4 C0 03 66 0F 12 3D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? F2 0F 59 C4 66 0F 7E E2 66 0F 73 D4 20 66 0F 7E E0 83 FA 00 74 52 66 0F 54 F8 F2 0F 10 E0 66 0F 54 05 ?? ?? ?? ?? 66 0F 73 D0 2C 66 0F C5 C0 00 66 0F 56 FA 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 3C 85 ?? ?? ?? ?? 66 0F 12 2C 85 ?? ?? ?? ?? 03 C0 66 0F 28 34 85 ?? ?? ?? ?? BA 7F 3E 04 00 E9 5C FB FF FF 8B D0 81 E2 FF FF FF 7F 83 FA 00 75 A1 8B 54 24 10 81 E2 00 00 00 80 83 FA 00 74 31 C1 E1 0D 23 C1 BA 00 00 F0 7F 0B D0 66 0F 6E C2 66 0F 73 F0 20 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 54 24 04 F2 0F 5E CA BA 1B 00 00 00 E9 99 02 00 00 C1 E1 0D 23 C1 83 F8 00 0F 85 A4 00 00 00 D9 EE C3 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 C9 66 0F 54 DC 66 0F 76 CB 66 0F D7 C9 81 E1 FF 00 00 00 81 F9 FF 00 00 00 0F 85 BD 00 00 00 66 0F C5 CC 03 81 E1 00 80 00 00 83 F9 00 0F 84 8D 00 00 00 25 FF 00 00 00 3D FF 00 00 00 75 65 66 0F 12 4C 24 0C 66 0F 12 54 24 0C B9 F4 03 00 00 66 0F 6E D9 66 0F 54 0D ?? ?? ?? ?? 66 0F 73 D1 34 66 0F FA CB 66 0F EF DB 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 25 FF 00 00 00 3D FF 00 00 00 74 23 66 0F 12 4C 24 0C 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 74 07 DD 05 ?? ?? ?? ?? C3 DD 05 ?? ?? ?? ?? C3 66 0F 12 4C 24 0C 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 47 01 00 00 D9 EE C3 66 0F 12 4C 24 0C 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 2B 01 00 00 D9 EE C3 F2 0F 58 E4 F2 0F 10 C4 BA EE 03 00 00 E9 8F 01 00 00 66 0F 12 54 24 04 66 0F 7E D0 66 0F 73 D2 20 66 0F 7E D2 81 E2 FF FF FF 7F 0B C2 B9 00 00 00 00 83 F8 00 0F 84 80 FE FF FF 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 C9 BA 1C 00 00 00 E9 48 01 00 00 66 0F 12 64 24 04 66 0F 12 54 24 0C 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 C9 66 0F 54 DA 66 0F 76 CB 66 0F D7 C1 25 FF 00 00 00 3D FF 00 00 00 0F 85 A2 00 00 00 66 0F 7E E0 83 F8 00 75 20 66 0F 73 D4 20 66 0F 7E E2 81 FA 00 00 F0 3F 0F 84 E9 00 00 00 81 FA 00 00 F0 BF 75 03 D9 E8 C3 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 C9 66 0F 54 DA 66 0F 76 CB 66 0F D7 C1 25 FF 00 00 00 3D FF 00 00 00 75 55 66 0F C5 C2 03 66 0F 12 64 24 04 25 00 80 00 00 81 F1 00 00 F0 BF 0B D1 83 FA 00 0F 84 99 00 00 00 83 F8 00 74 14 66 0F C5 C4 03 25 F0 7F 00 00 3D F0 3F 00 00 72 17 D9 EE C3 66 0F C5 C4 03 25 F0 7F 00 00 3D F0 3F 00 00 73 03 D9 EE C3 DD 05 ?? ?? ?? ?? C3 F2 0F 58 D2 F2 0F 10 C2 BA EE 03 00 00 EB 63 66 0F 7E E0 66 0F 73 D4 20 66 0F 7E E2 81 E2 FF FF FF 7F 8B C8 0B C2 66 0F 12 05 ?? ?? ?? ?? BA 1A 00 00 00 83 F8 00 74 3A 66 0F 7E E0 BA 1D 00 00 00 25 FF FF FF 7F 3D 00 00 F0 7F 77 25 72 05 83 F9 00 77 1E 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 05 ?? ?? ?? ?? BA 1C 00 00 00 83 EC 1C 66 0F 13 44 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 18 89 54 24 04 83 EA 08 89 14 24 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 1C C3 83 F8 00 7E 28 3D 00 00 04 00 0F 83 3C 02 00 00 56 8B D0 83 E0 7F 81 C1 00 FF 03 00 81 EA 80 00 00 00 83 E2 80 57 BF F0 3F 00 00 EB 26 3D 00 02 FC FF 0F 8E F1 01 00 00 56 8B D0 83 E0 7F 81 C1 80 00 00 00 83 E2 80 81 C2 80 FE 03 00 57 BF 00 00 00 00 F2 0F 58 E0 F2 0F 10 C3 F2 0F 58 1D ?? ?? ?? ?? 8B F2 81 EE 80 FF 01 00 66 0F 59 D7 F2 0F 5C 1D ?? ?? ?? ?? 66 0F 59 FF F2 0F 5C C3 03 C0 03 C0 03 C0 03 C0 66 0F 28 98 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 CF 66 0F 58 D1 66 0F 70 CA EE F2 0F 59 D7 F2 0F 58 D1 F2 0F 58 D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 6E CA 81 EA 80 FF 01 00 F7 DA C1 FA 07 83 C2 02 8B C2 83 E0 20 03 D0 66 0F 57 FF B8 80 3F 00 00 66 0F C4 F8 03 F2 0F 59 54 24 14 F2 0F 59 C7 66 0F 73 F1 2D 66 0F 70 C9 44 66 0F 28 3D ?? ?? ?? ?? F2 0F 58 EA 66 0F 59 D9 F2 0F 58 C5 66 0F 14 C0 66 0F 59 F0 F2 0F 59 E0 66 0F 59 C0 66 0F 58 FE 66 0F 59 F8 F2 0F 59 C3 66 0F 70 F7 EE F2 0F 59 C7 66 0F 70 EB EE F2 0F 59 F3 F2 0F 59 E3 66 0F 6E F9 66 0F 73 F7 2D 66 0F 6E D2 66 0F 76 C9 66 0F F3 CA F2 0F 58 C5 F2 0F 58 C6 66 0F 54 CB F2 0F 58 C4 66 0F 57 F6 66 0F 76 E4 66 0F F3 E2 F2 0F 5C D9 F2 0F 10 D1 F2 0F 58 C8 66 0F 54 CC 66 0F C4 F7 03 5F F2 0F 5C D1 F2 0F 58 C2 F2 0F 58 C3 83 FE 00 7F 4E 5E F2 0F 59 C7 F2 0F 59 CF F2 0F 58 C1 F2 0F 59 F0 F2 0F 58 C6 66 0F C5 C0 03 25 F0 7F 00 00 BA 18 00 00 00 3D F0 7F 00 00 0F 84 10 FE FF FF BA 19 00 00 00 83 F8 00 0F 84 02 FE FF FF 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 5E F2 0F 58 C1 F2 0F 59 C7 F2 0F 59 F0 F2 0F 58 C6 66 0F C5 C0 03 25 F0 7F 00 00 BA 18 00 00 00 3D F0 7F 00 00 0F 84 C6 FD FF FF BA 19 00 00 00 83 F8 00 0F 84 B8 FD FF FF 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 05 ?? ?? ?? ?? 66 0F 6E C9 F2 0F 59 C0 66 0F 73 F1 2D 66 0F 56 C1 BA 19 00 00 00 E9 84 FD FF FF BA 18 00 00 00 83 F9 00 74 15 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? E9 65 FD FF FF 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 C0 E9 54 FD FF FF 66 0F 70 E1 44 66 0F 59 E6 66 0F C5 C4 03 25 F0 7F 00 00 BA A0 40 00 00 2B D0 2D 70 3C 00 00 0B D0 81 FA 00 00 00 80 0F 82 EF F6 FF FF 3D 00 00 00 80 72 20 81 C9 80 FF 01 00 66 0F 6E C1 66 0F 73 F0 2D 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 64 24 04 66 0F C5 D4 03 81 E2 F0 7F 00 00 81 EA F0 3F 00 00 66 0F C5 C1 03 33 C2 25 00 80 00 00 83 F8 00 0F 85 2D FF FF FF E9 4B FF FF FF 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "_ValidateLocalCookies"
		size = 50
		refs = "001b @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 57 8B 06 8B 7D 0C 83 F8 FE 74 0D 8B 4E 04 03 CF 33 0C 38 E8 ?? ?? ?? ?? 8B 4E 0C 8B 46 08 03 CF 33 0C 38 5F 5E 5D E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_1_0 {
	meta:
		name = "__except_handler4"
		size = 405
		refs = "0011 ___security_cookie 0033 @__security_check_cookie@4 008c @_EH4_CallFilterFunc@8 00ac __pDestructExceptionObject 00b9 __IsNonwritableInCurrentImage 00d9 @_EH4_GlobalUnwind2@8 00f1 @_EH4_LocalUnwind@16 0190 @_EH4_TransferToHandler@8"
	strings:
		$1 = { 55 8B EC 83 EC 18 53 8B 5D 0C 56 57 8B 7B 08 33 3D ?? ?? ?? ?? C6 45 FF 00 C7 45 F4 01 00 00 00 8B 07 8D 73 10 83 F8 FE 74 0D 8B 4F 04 03 CE 33 0C 30 E8 ?? ?? ?? ?? 8B 4F 0C 8B 47 08 03 CE 33 0C 30 E8 ?? ?? ?? ?? 8B 45 08 F6 40 04 66 0F 85 D0 00 00 00 89 45 E8 8B 45 10 89 45 EC 8D 45 E8 89 43 FC 8B 43 0C 89 45 F8 83 F8 FE 0F 84 EE 00 00 00 8D 04 40 8D 40 04 8B 4C 87 04 8B 1C 87 8D 04 87 89 45 F0 85 C9 74 7B 8B D6 E8 ?? ?? ?? ?? B1 01 88 4D FF 85 C0 0F 88 7E 00 00 00 7E 68 8B 45 08 81 38 63 73 6D E0 75 28 83 3D ?? ?? ?? ?? 00 74 1F 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 0E 6A 01 FF 75 08 FF 15 ?? ?? ?? ?? 83 C4 08 8B 55 08 8B 4D 0C E8 ?? ?? ?? ?? 8B 45 0C 8B 55 F8 39 50 0C 74 10 68 ?? ?? ?? ?? 56 8B C8 E8 ?? ?? ?? ?? 8B 45 0C 89 58 0C 8B 07 83 F8 FE 74 75 EB 66 8A 4D FF 8B C3 89 5D F8 83 FB FE 0F 85 5D FF FF FF 84 C9 74 47 EB 21 C7 45 F4 00 00 00 00 EB 18 83 7B 0C FE 74 36 68 ?? ?? ?? ?? 56 8B CB BA FE FF FF FF E8 ?? ?? ?? ?? 8B 07 83 F8 FE 74 0D 8B 4F 04 03 CE 33 0C 30 E8 ?? ?? ?? ?? 8B 4F 0C 8B 57 08 03 CE 33 0C 32 E8 ?? ?? ?? ?? 8B 45 F4 5F 5E 5B 8B E5 5D C3 8B 4F 04 03 CE 33 0C 30 E8 ?? ?? ?? ?? 8B 4F 0C 8B 47 08 03 CE 33 0C 30 E8 ?? ?? ?? ?? 8B 4D F0 8B D6 8B 49 08 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_2_0_0 {
	meta:
		name = "___sse2_acosf4"
		size = 352
		refs = "000f ___common_sacos_data 0151 ___common_sacos_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 0F 28 3D ?? ?? ?? ?? 0F 28 F7 0F 54 F8 0F 56 F0 0F 28 15 ?? ?? ?? ?? 0F 28 E6 0F 59 E2 0F 28 EE 0F 59 EE 0F 58 E2 0F 52 D4 0F 5D EC 0F 28 DE 0F 28 CA 0F C2 1D ?? ?? ?? ?? 02 0F 59 CA 0F 50 D3 0F 28 DD 0F 29 7C 24 10 0F C2 DC 05 0F 58 E4 0F 59 D4 85 D2 0F 59 E1 0F 28 3D ?? ?? ?? ?? 0F 28 0D ?? ?? ?? ?? 0F 59 CD 0F 5C 25 ?? ?? ?? ?? 0F 59 FC 0F 58 0D ?? ?? ?? ?? 0F 59 E2 0F 58 3D ?? ?? ?? ?? 0F 59 FC 0F 28 E5 0F 59 E5 0F 5C D7 0F 59 CC 0F 28 3D ?? ?? ?? ?? 0F 28 E0 0F 59 FD 0F 54 D3 0F C2 E5 01 0F 58 3D ?? ?? ?? ?? 0F 58 CF 0F 28 FB 0F 59 CD 0F 55 3D ?? ?? ?? ?? 0F 58 0D ?? ?? ?? ?? 0F 59 CD 0F 28 2D ?? ?? ?? ?? 0F 54 EB 0F 54 EC 0F 28 E3 0F 55 E6 0F 58 FD 0F 56 E2 0F 57 64 24 10 0F 59 CC 0F 58 CC 0F 58 F9 75 07 0F 28 C7 8B E5 5D C3 0F 29 44 24 40 0F 29 BC 24 80 00 00 00 74 EA 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 8B CE B8 01 00 00 00 D3 E0 85 F8 75 17 46 83 FE 20 7C ED 8B 74 24 04 8B 3C 24 0F 28 BC 24 80 00 00 00 EB B9 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB D2 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "__wutime64"
		size = 119
		refs = "000a __errno 0015 __invalid_parameter_noinfo 002f __wsopen_s 0043 __futime64 0060 __close"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 6A 00 6A 40 68 02 80 00 00 FF 75 08 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 DF 56 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B F0 59 59 83 FE FF 75 09 E8 ?? ?? ?? ?? 8B 38 EB 03 8B 7D 08 FF 75 08 E8 ?? ?? ?? ?? 59 83 FE FF 75 07 E8 ?? ?? ?? ?? 89 38 5F 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_365_1_0 {
	meta:
		name = "__utime32"
		size = 119
		refs = "000a __errno 0015 __invalid_parameter_noinfo 002f __sopen_s 0043 __futime32 0060 __close"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 6A 00 6A 40 68 02 80 00 00 FF 75 08 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 DF 56 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B F0 59 59 83 FE FF 75 09 E8 ?? ?? ?? ?? 8B 38 EB 03 8B 7D 08 FF 75 08 E8 ?? ?? ?? ?? 59 83 FE FF 75 07 E8 ?? ?? ?? ?? 89 38 5F 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_164_1_0 {
	meta:
		name = "__utime64"
		size = 119
		refs = "000a __errno 0015 __invalid_parameter_noinfo 002f __sopen_s 0043 __futime64 0060 __close"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 6A 00 6A 40 68 02 80 00 00 FF 75 08 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 DF 56 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B F0 59 59 83 FE FF 75 09 E8 ?? ?? ?? ?? 8B 38 EB 03 8B 7D 08 FF 75 08 E8 ?? ?? ?? ?? 59 83 FE FF 75 07 E8 ?? ?? ?? ?? 89 38 5F 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_818_0_0 {
	meta:
		name = "__wutime32"
		size = 119
		refs = "000a __errno 0015 __invalid_parameter_noinfo 002f __wsopen_s 0043 __futime32 0060 __close"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 6A 00 6A 40 68 02 80 00 00 FF 75 08 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 DF 56 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B F0 59 59 83 FE FF 75 09 E8 ?? ?? ?? ?? 8B 38 EB 03 8B 7D 08 FF 75 08 E8 ?? ?? ?? ?? 59 83 FE FF 75 07 E8 ?? ?? ?? ?? 89 38 5F 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "_calloc"
		size = 62
		refs = "0014 __calloc_impl 0027 __errno"
	strings:
		$1 = { 55 8B EC 51 83 65 FC 00 56 8D 45 FC 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B F0 83 C4 0C 85 F6 75 18 39 45 FC 74 13 E8 ?? ?? ?? ?? 85 C0 74 0A E8 ?? ?? ?? ?? 8B 4D FC 89 08 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "_cmpBYTE"
		size = 37
	strings:
		$1 = { 55 8B EC 8B 45 08 0F B6 08 8B 45 0C 0F B6 00 2B C8 74 0E 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF 8B C1 5D C3 }
	condition:
		$1
}

rule file_6_1_0 {
	meta:
		name = "_cmpDWORD"
		size = 139
	strings:
		$1 = { 55 8B EC 8B 4D 08 8B 55 0C 8B 01 3B 02 74 78 56 0F B6 F0 0F B6 02 2B F0 74 12 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 75 58 0F B6 71 01 0F B6 42 01 2B F0 74 12 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 75 3A 0F B6 71 02 0F B6 42 02 2B F0 74 12 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 75 1C 0F B6 49 03 0F B6 42 03 2B C8 74 0E 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF 8B C1 5E 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_6_2_0 {
	meta:
		name = "_cmpResult"
		size = 28
	strings:
		$1 = { 55 8B EC 8B 4D 08 85 C9 74 0E 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF 8B C1 5D C3 }
	condition:
		$1
}

rule file_6_3_0 {
	meta:
		name = "_cmpWORD"
		size = 81
	strings:
		$1 = { 55 8B EC 8B 4D 08 8B 55 0C 66 8B 01 66 3B 02 74 3C 56 0F B6 F0 0F B6 02 2B F0 74 12 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 75 1C 0F B6 49 01 0F B6 42 01 2B C8 74 0E 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF 8B C1 5E 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_6_4_0 {
	meta:
		name = "_memcmp"
		size = 6008
		refs = "04f0 $LN1280 16f8 $LN132 16fc $LN103 1700 $LN88 1704 $LN73 1708 $LN120 170c $LN105 1710 $LN90 1714 $LN75 1718 $LN122 171c $LN107 1720 $LN92 1724 $LN77 1728 $LN124 172c $LN109 1730 $LN94 1734 $LN79 1738 $LN126 173c $LN111 1740 $LN96 1744 $LN81 1748 $LN128 174c $LN113 1750 $LN98 1754 $LN83 1758 $LN130 175c $LN115 1760 $LN100 1764 $LN85 1768 $LN131 176c $LN116 1770 $LN101 1774 $LN86"
	strings:
		$1 = { 55 8B EC 53 8B 5D 10 8B C3 56 83 E8 00 0F 84 DC 16 00 00 48 0F 84 C4 16 00 00 48 0F 84 8E 16 00 00 48 0F 84 3D 16 00 00 8B 55 0C 48 0F 84 AB 15 00 00 8B 75 08 57 83 FB 20 0F 82 A1 04 00 00 8B 06 3B 02 0F 84 80 00 00 00 0F B6 F8 0F B6 02 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 9B 08 00 00 0F B6 7E 01 0F B6 42 01 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 79 08 00 00 0F B6 7E 02 0F B6 42 02 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 57 08 00 00 0F B6 4E 03 0F B6 42 03 2B C8 74 12 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF EB 02 33 C9 85 C9 0F 85 31 08 00 00 8B 46 04 3B 42 04 74 7F 0F B6 F8 0F B6 42 04 2B F8 74 14 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 0A 08 00 00 0F B6 7E 05 0F B6 42 05 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 E8 07 00 00 0F B6 7E 06 0F B6 42 06 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 C6 07 00 00 0F B6 4E 07 0F B6 42 07 2B C8 74 12 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF EB 02 33 C9 85 C9 0F 85 A0 07 00 00 8B 46 08 3B 42 08 74 7F 0F B6 F8 0F B6 42 08 2B F8 74 14 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 79 07 00 00 0F B6 7E 09 0F B6 42 09 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 57 07 00 00 0F B6 7E 0A 0F B6 42 0A 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 35 07 00 00 0F B6 4E 0B 0F B6 42 0B 2B C8 74 12 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF EB 02 33 C9 85 C9 0F 85 0F 07 00 00 8B 46 0C 3B 42 0C 74 7F 0F B6 F8 0F B6 42 0C 2B F8 74 14 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 E8 06 00 00 0F B6 7E 0D 0F B6 42 0D 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 C6 06 00 00 0F B6 7E 0E 0F B6 42 0E 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 A4 06 00 00 0F B6 4E 0F 0F B6 42 0F 2B C8 74 12 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF EB 02 33 C9 85 C9 0F 85 7E 06 00 00 8B 46 10 3B 42 10 0F 84 80 00 00 00 0F B6 42 10 0F B6 7E 10 2B F8 74 14 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 52 06 00 00 0F B6 7E 11 0F B6 42 11 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 30 06 00 00 0F B6 7E 12 0F B6 42 12 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 0E 06 00 00 0F B6 4E 13 0F B6 42 13 2B C8 74 12 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF EB 02 33 C9 85 C9 0F 85 E8 05 00 00 8B 46 14 3B 42 14 74 7F 0F B6 F8 0F B6 42 14 2B F8 74 14 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 C1 05 00 00 0F B6 7E 15 0F B6 42 15 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 9F 05 00 00 0F B6 7E 16 0F B6 42 16 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 7D 05 00 00 0F B6 4E 17 0F B6 42 17 2B C8 74 12 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF EB 02 33 C9 85 C9 0F 85 57 05 00 00 8B 46 18 3B 42 18 74 7F 0F B6 F8 0F B6 42 18 2B F8 74 14 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 30 05 00 00 0F B6 7E 19 0F B6 42 19 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 0E 05 00 00 0F B6 7E 1A 0F B6 42 1A 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 EC 04 00 00 0F B6 4E 1B 0F B6 42 1B 2B C8 74 12 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF EB 02 33 C9 85 C9 0F 85 C6 04 00 00 8B 46 1C 3B 42 1C 74 7F 0F B6 F8 0F B6 42 1C 2B F8 74 14 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 9F 04 00 00 0F B6 7E 1D 0F B6 42 1D 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 7D 04 00 00 0F B6 7E 1E 0F B6 42 1E 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 5B 04 00 00 0F B6 4E 1F 0F B6 42 1F 2B C8 74 12 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF EB 02 33 C9 85 C9 0F 85 35 04 00 00 6A 20 59 2B D9 03 F1 03 D1 3B D9 0F 83 5F FB FF FF 03 F3 03 D3 83 FB 1F 0F 87 15 04 00 00 FF 24 9D ?? ?? ?? ?? 8B 46 E4 3B 42 E4 0F 84 81 00 00 00 0F B6 F8 0F B6 42 E4 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 E3 03 00 00 0F B6 7E E5 0F B6 42 E5 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 C1 03 00 00 0F B6 7E E6 0F B6 42 E6 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 9F 03 00 00 0F B6 4E E7 0F B6 42 E7 2B C8 74 12 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF EB 02 33 C9 85 C9 0F 85 79 03 00 00 8B 46 E8 3B 42 E8 0F 84 81 00 00 00 0F B6 F8 0F B6 42 E8 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 4C 03 00 00 0F B6 7E E9 0F B6 42 E9 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 2A 03 00 00 0F B6 7E EA 0F B6 42 EA 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 08 03 00 00 0F B6 4E EB 0F B6 42 EB 2B C8 74 12 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF EB 02 33 C9 85 C9 0F 85 E2 02 00 00 8B 46 EC 3B 42 EC 0F 84 81 00 00 00 0F B6 F8 0F B6 42 EC 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 B5 02 00 00 0F B6 7E ED 0F B6 42 ED 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 93 02 00 00 0F B6 7E EE 0F B6 42 EE 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 71 02 00 00 0F B6 4E EF 0F B6 42 EF 2B C8 74 12 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF EB 02 33 C9 85 C9 0F 85 4B 02 00 00 8B 46 F0 3B 42 F0 0F 84 81 00 00 00 0F B6 F8 0F B6 42 F0 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 1E 02 00 00 0F B6 7E F1 0F B6 42 F1 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 FC 01 00 00 0F B6 7E F2 0F B6 42 F2 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 DA 01 00 00 0F B6 4E F3 0F B6 42 F3 2B C8 74 12 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF EB 02 33 C9 85 C9 0F 85 B4 01 00 00 8B 46 F4 3B 42 F4 0F 84 82 00 00 00 0F B6 42 F4 0F B6 7E F4 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 86 01 00 00 0F B6 7E F5 0F B6 42 F5 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 64 01 00 00 0F B6 7E F6 0F B6 42 F6 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 42 01 00 00 0F B6 4E F7 0F B6 42 F7 2B C8 74 12 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF EB 02 33 C9 85 C9 0F 85 1C 01 00 00 8B 46 F8 3B 42 F8 0F 84 81 00 00 00 0F B6 F8 0F B6 42 F8 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 EF 00 00 00 0F B6 7E F9 0F B6 42 F9 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 CD 00 00 00 0F B6 7E FA 0F B6 42 FA 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 AB 00 00 00 0F B6 4E FB 0F B6 42 FB 2B C8 74 12 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF EB 02 33 C9 85 C9 0F 85 85 00 00 00 8B 46 FC 3B 42 FC 74 75 0F B6 F8 0F B6 42 FC 2B F8 74 12 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 75 60 0F B6 7E FD 0F B6 42 FD 2B F8 74 12 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 75 42 0F B6 7E FE 0F B6 42 FE 2B F8 74 12 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 75 24 0F B6 4E FF 0F B6 42 FF 2B C8 74 12 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF EB 02 33 C9 85 C9 75 02 33 C9 8B C1 5F E9 E5 0D 00 00 8B 46 E3 3B 42 E3 74 75 0F B6 F8 0F B6 42 E3 2B F8 74 12 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 75 D3 0F B6 7E E4 0F B6 42 E4 2B F8 74 12 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 75 B5 0F B6 7E E5 0F B6 42 E5 2B F8 74 12 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 75 97 0F B6 4E E6 0F B6 42 E6 2B C8 74 12 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF EB 02 33 C9 85 C9 0F 85 71 FF FF FF 8B 46 E7 3B 42 E7 0F 84 81 00 00 00 0F B6 F8 0F B6 42 E7 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 44 FF FF FF 0F B6 7E E8 0F B6 42 E8 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 22 FF FF FF 0F B6 7E E9 0F B6 42 E9 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 00 FF FF FF 0F B6 4E EA 0F B6 42 EA 2B C8 74 12 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF EB 02 33 C9 85 C9 0F 85 DA FE FF FF 8B 46 EB 3B 42 EB 0F 84 81 00 00 00 0F B6 F8 0F B6 42 EB 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 AD FE FF FF 0F B6 7E EC 0F B6 42 EC 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 8B FE FF FF 0F B6 7E ED 0F B6 42 ED 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 69 FE FF FF 0F B6 4E EE 0F B6 42 EE 2B C8 74 12 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF EB 02 33 C9 85 C9 0F 85 43 FE FF FF 8B 46 EF 3B 42 EF 0F 84 81 00 00 00 0F B6 F8 0F B6 42 EF 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 16 FE FF FF 0F B6 7E F0 0F B6 42 F0 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 F4 FD FF FF 0F B6 7E F1 0F B6 42 F1 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 D2 FD FF FF 0F B6 4E F2 0F B6 42 F2 2B C8 74 12 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF EB 02 33 C9 85 C9 0F 85 AC FD FF FF 8B 46 F3 3B 42 F3 0F 84 81 00 00 00 0F B6 F8 0F B6 42 F3 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 7F FD FF FF 0F B6 7E F4 0F B6 42 F4 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 5D FD FF FF 0F B6 7E F5 0F B6 42 F5 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 3B FD FF FF 0F B6 4E F6 0F B6 42 F6 2B C8 74 12 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF EB 02 33 C9 85 C9 0F 85 15 FD FF FF 8B 46 F7 3B 42 F7 0F 84 82 00 00 00 0F B6 42 F7 0F B6 7E F7 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 E7 FC FF FF 0F B6 7E F8 0F B6 42 F8 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 C5 FC FF FF 0F B6 7E F9 0F B6 42 F9 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 A3 FC FF FF 0F B6 4E FA 0F B6 42 FA 2B C8 74 12 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF EB 02 33 C9 85 C9 0F 85 7D FC FF FF 8B 46 FB 3B 42 FB 0F 84 81 00 00 00 0F B6 F8 0F B6 42 FB 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 50 FC FF FF 0F B6 7E FC 0F B6 42 FC 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 2E FC FF FF 0F B6 7E FD 0F B6 42 FD 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 0C FC FF FF 0F B6 4E FE 0F B6 42 FE 2B C8 74 12 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF EB 02 33 C9 85 C9 0F 85 E6 FB FF FF 0F B6 42 FF 0F B6 4E FF 2B C8 0F 84 D6 FB FF FF 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF E9 C3 FB FF FF 8B 46 E2 3B 42 E2 0F 84 81 00 00 00 0F B6 F8 0F B6 42 E2 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 96 FB FF FF 0F B6 7E E3 0F B6 42 E3 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 74 FB FF FF 0F B6 7E E4 0F B6 42 E4 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 52 FB FF FF 0F B6 4E E5 0F B6 42 E5 2B C8 74 12 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF EB 02 33 C9 85 C9 0F 85 2C FB FF FF 8B 46 E6 3B 42 E6 0F 84 81 00 00 00 0F B6 F8 0F B6 42 E6 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 FF FA FF FF 0F B6 7E E7 0F B6 42 E7 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 DD FA FF FF 0F B6 7E E8 0F B6 42 E8 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 BB FA FF FF 0F B6 4E E9 0F B6 42 E9 2B C8 74 12 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF EB 02 33 C9 85 C9 0F 85 95 FA FF FF 8B 46 EA 3B 42 EA 0F 84 81 00 00 00 0F B6 F8 0F B6 42 EA 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 68 FA FF FF 0F B6 7E EB 0F B6 42 EB 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 46 FA FF FF 0F B6 7E EC 0F B6 42 EC 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 24 FA FF FF 0F B6 4E ED 0F B6 42 ED 2B C8 74 12 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF EB 02 33 C9 85 C9 0F 85 FE F9 FF FF 8B 46 EE 3B 42 EE 0F 84 81 00 00 00 0F B6 F8 0F B6 42 EE 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 D1 F9 FF FF 0F B6 7E EF 0F B6 42 EF 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 AF F9 FF FF 0F B6 7E F0 0F B6 42 F0 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 8D F9 FF FF 0F B6 4E F1 0F B6 42 F1 2B C8 74 12 33 C0 85 C9 0F 9F C0 8D 0C 45 FF FF FF FF EB 02 33 C9 85 C9 0F 85 67 F9 FF FF 8B 46 F2 3B 42 F2 0F 84 81 00 00 00 0F B6 F8 0F B6 42 F2 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 3A F9 FF FF 0F B6 7E F3 0F B6 42 F3 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D 0C 4D FF FF FF FF 85 C9 0F 85 18 F9 FF FF 0F B6 7E F4 0F B6 42 F4 2B F8 74 16 33 C9 85 FF 0F 9F C1 8D }
	condition:
		$1
}

rule file_6_5_0 {
	meta:
		name = "_unaligned_memcmp"
		size = 6044
		refs = "0530 $LN1268 171c $LN61 1720 $LN32 1724 $LN17 1728 $LN2 172c $LN49 1730 $LN34 1734 $LN19 1738 $LN4 173c $LN51 1740 $LN36 1744 $LN21 1748 $LN6 174c $LN53 1750 $LN38 1754 $LN23 1758 $LN8 175c $LN55 1760 $LN40 1764 $LN25 1768 $LN10 176c $LN57 1770 $LN42 1774 $LN27 1778 $LN12 177c $LN59 1780 $LN44 1784 $LN29 1788 $LN14 178c $LN60 1790 $LN45 1794 $LN30 1798 $LN15"
	strings:
		$1 = { 55 8B EC 8B 4D 0C 8B 55 08 53 56 57 8B 7D 10 33 DB 83 FF 20 0F 82 06 05 00 00 8B 02 3B 01 0F 84 88 00 00 00 0F B6 F0 0F B6 01 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 3C 09 00 00 0F B6 72 01 0F B6 41 01 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 1A 09 00 00 0F B6 72 02 0F B6 41 02 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 F8 08 00 00 0F B6 72 03 0F B6 41 03 2B F0 89 75 10 74 10 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF EB 07 8B 45 10 EB 02 8B C3 85 C0 0F 85 CA 08 00 00 8B 42 04 3B 41 04 0F 84 89 00 00 00 0F B6 F0 0F B6 41 04 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 9D 08 00 00 0F B6 72 05 0F B6 41 05 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 7B 08 00 00 0F B6 72 06 0F B6 41 06 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 59 08 00 00 0F B6 72 07 0F B6 41 07 2B F0 89 75 10 74 10 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF EB 07 8B 45 10 EB 02 8B C3 85 C0 0F 85 2B 08 00 00 8B 42 08 3B 41 08 0F 84 89 00 00 00 0F B6 F0 0F B6 41 08 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 FE 07 00 00 0F B6 72 09 0F B6 41 09 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 DC 07 00 00 0F B6 72 0A 0F B6 41 0A 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 BA 07 00 00 0F B6 72 0B 0F B6 41 0B 2B F0 89 75 10 74 10 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF EB 07 8B 45 10 EB 02 8B C3 85 C0 0F 85 8C 07 00 00 8B 42 0C 3B 41 0C 0F 84 89 00 00 00 0F B6 F0 0F B6 41 0C 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 5F 07 00 00 0F B6 72 0D 0F B6 41 0D 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 3D 07 00 00 0F B6 72 0E 0F B6 41 0E 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 1B 07 00 00 0F B6 72 0F 0F B6 41 0F 2B F0 89 75 10 74 10 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF EB 07 8B 45 10 EB 02 8B C3 85 C0 0F 85 ED 06 00 00 8B 42 10 3B 41 10 0F 84 89 00 00 00 0F B6 F0 0F B6 41 10 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 C0 06 00 00 0F B6 72 11 0F B6 41 11 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 9E 06 00 00 0F B6 72 12 0F B6 41 12 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 7C 06 00 00 0F B6 72 13 0F B6 41 13 2B F0 89 75 10 74 10 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF EB 07 8B 45 10 EB 02 8B C3 85 C0 0F 85 4E 06 00 00 8B 42 14 3B 41 14 0F 84 89 00 00 00 0F B6 F0 0F B6 41 14 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 21 06 00 00 0F B6 72 15 0F B6 41 15 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 FF 05 00 00 0F B6 72 16 0F B6 41 16 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 DD 05 00 00 0F B6 72 17 0F B6 41 17 2B F0 89 75 10 74 10 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF EB 07 8B 45 10 EB 02 8B C3 85 C0 0F 85 AF 05 00 00 8B 42 18 3B 41 18 0F 84 89 00 00 00 0F B6 F0 0F B6 41 18 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 82 05 00 00 0F B6 72 19 0F B6 41 19 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 60 05 00 00 0F B6 72 1A 0F B6 41 1A 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 3E 05 00 00 0F B6 72 1B 0F B6 41 1B 2B F0 89 75 10 74 10 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF EB 07 8B 45 10 EB 02 8B C3 85 C0 0F 85 10 05 00 00 8B 42 1C 3B 41 1C 0F 84 89 00 00 00 0F B6 F0 0F B6 41 1C 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 E3 04 00 00 0F B6 72 1D 0F B6 41 1D 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 C1 04 00 00 0F B6 72 1E 0F B6 41 1E 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 9F 04 00 00 0F B6 72 1F 0F B6 41 1F 2B F0 89 75 10 74 10 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF EB 07 8B 45 10 EB 02 8B C3 85 C0 0F 85 71 04 00 00 6A 20 5E 2B FE 03 D6 03 CE 3B FE 0F 83 FA FA FF FF 03 D7 03 CF 83 FF 1F 0F 87 51 04 00 00 FF 24 BD ?? ?? ?? ?? 8B 42 E4 3B 41 E4 0F 84 8A 00 00 00 0F B6 41 E4 0F B6 72 E4 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 1E 04 00 00 0F B6 72 E5 0F B6 41 E5 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 FC 03 00 00 0F B6 72 E6 0F B6 41 E6 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 DA 03 00 00 0F B6 72 E7 0F B6 41 E7 2B F0 89 75 10 74 10 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF EB 07 8B 45 10 EB 02 8B C3 85 C0 0F 85 AC 03 00 00 8B 42 E8 3B 41 E8 0F 84 89 00 00 00 0F B6 F0 0F B6 41 E8 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 7F 03 00 00 0F B6 72 E9 0F B6 41 E9 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 5D 03 00 00 0F B6 72 EA 0F B6 41 EA 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 3B 03 00 00 0F B6 72 EB 0F B6 41 EB 2B F0 89 75 10 74 10 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF EB 07 8B 45 10 EB 02 8B C3 85 C0 0F 85 0D 03 00 00 8B 42 EC 3B 41 EC 0F 84 89 00 00 00 0F B6 F0 0F B6 41 EC 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 E0 02 00 00 0F B6 72 ED 0F B6 41 ED 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 BE 02 00 00 0F B6 72 EE 0F B6 41 EE 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 9C 02 00 00 0F B6 72 EF 0F B6 41 EF 2B F0 89 75 10 74 10 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF EB 07 8B 45 10 EB 02 8B C3 85 C0 0F 85 6E 02 00 00 8B 42 F0 3B 41 F0 0F 84 89 00 00 00 0F B6 F0 0F B6 41 F0 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 41 02 00 00 0F B6 72 F1 0F B6 41 F1 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 1F 02 00 00 0F B6 72 F2 0F B6 41 F2 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 FD 01 00 00 0F B6 72 F3 0F B6 41 F3 2B F0 89 75 10 74 10 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF EB 07 8B 45 10 EB 02 8B C3 85 C0 0F 85 CF 01 00 00 8B 42 F4 3B 41 F4 0F 84 89 00 00 00 0F B6 F0 0F B6 41 F4 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 A2 01 00 00 0F B6 72 F5 0F B6 41 F5 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 80 01 00 00 0F B6 72 F6 0F B6 41 F6 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 5E 01 00 00 0F B6 72 F7 0F B6 41 F7 2B F0 89 75 10 74 10 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF EB 07 8B 45 10 EB 02 8B C3 85 C0 0F 85 30 01 00 00 8B 42 F8 3B 41 F8 0F 84 89 00 00 00 0F B6 F0 0F B6 41 F8 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 03 01 00 00 0F B6 72 F9 0F B6 41 F9 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 E1 00 00 00 0F B6 72 FA 0F B6 41 FA 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 BF 00 00 00 0F B6 72 FB 0F B6 41 FB 2B F0 89 75 10 74 10 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF EB 07 8B 45 10 EB 02 8B C3 85 C0 0F 85 91 00 00 00 8B 42 FC 3B 41 FC 74 7F 0F B6 F0 0F B6 41 FC 2B F0 74 16 33 DB 85 F6 0F 9F C3 8D 1C 5D FF FF FF FF 85 DB 0F 85 97 04 00 00 0F B6 72 FD 0F B6 41 FD 2B F0 74 16 33 DB 85 F6 0F 9F C3 8D 1C 5D FF FF FF FF 85 DB 0F 85 75 04 00 00 0F B6 72 FE 0F B6 41 FE 2B F0 74 16 33 DB 85 F6 0F 9F C3 8D 1C 5D FF FF FF FF 85 DB 0F 85 53 04 00 00 0F B6 5A FF 0F B6 41 FF 2B D8 74 0E 33 C0 85 DB 0F 9F C0 8D 1C 45 FF FF FF FF 85 DB 0F 85 31 04 00 00 33 C0 5F 5E 5B 5D C3 8B 42 E3 3B 41 E3 74 7D 0F B6 F0 0F B6 41 E3 2B F0 74 12 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 75 D6 0F B6 72 E4 0F B6 41 E4 2B F0 74 12 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 75 B8 0F B6 72 E5 0F B6 41 E5 2B F0 74 12 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 75 9A 0F B6 72 E6 0F B6 41 E6 2B F0 89 75 10 74 10 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF EB 07 8B 45 10 EB 02 8B C3 85 C0 0F 85 6C FF FF FF 8B 42 E7 3B 41 E7 0F 84 8A 00 00 00 0F B6 41 E7 0F B6 72 E7 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 3E FF FF FF 0F B6 72 E8 0F B6 41 E8 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 1C FF FF FF 0F B6 72 E9 0F B6 41 E9 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 FA FE FF FF 0F B6 72 EA 0F B6 41 EA 2B F0 89 75 10 74 10 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF EB 07 8B 45 10 EB 02 8B C3 85 C0 0F 85 CC FE FF FF 8B 42 EB 3B 41 EB 0F 84 89 00 00 00 0F B6 F0 0F B6 41 EB 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 9F FE FF FF 0F B6 72 EC 0F B6 41 EC 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 7D FE FF FF 0F B6 72 ED 0F B6 41 ED 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 5B FE FF FF 0F B6 72 EE 0F B6 41 EE 2B F0 89 75 10 74 10 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF EB 07 8B 45 10 EB 02 8B C3 85 C0 0F 85 2D FE FF FF 8B 42 EF 3B 41 EF 0F 84 89 00 00 00 0F B6 F0 0F B6 41 EF 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 00 FE FF FF 0F B6 72 F0 0F B6 41 F0 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 DE FD FF FF 0F B6 72 F1 0F B6 41 F1 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 BC FD FF FF 0F B6 72 F2 0F B6 41 F2 2B F0 89 75 10 74 10 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF EB 07 8B 45 10 EB 02 8B C3 85 C0 0F 85 8E FD FF FF 8B 42 F3 3B 41 F3 0F 84 89 00 00 00 0F B6 F0 0F B6 41 F3 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 61 FD FF FF 0F B6 72 F4 0F B6 41 F4 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 3F FD FF FF 0F B6 72 F5 0F B6 41 F5 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 1D FD FF FF 0F B6 72 F6 0F B6 41 F6 2B F0 89 75 10 74 10 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF EB 07 8B 45 10 EB 02 8B C3 85 C0 0F 85 EF FC FF FF 8B 42 F7 3B 41 F7 0F 84 89 00 00 00 0F B6 F0 0F B6 41 F7 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 C2 FC FF FF 0F B6 72 F8 0F B6 41 F8 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 A0 FC FF FF 0F B6 72 F9 0F B6 41 F9 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 7E FC FF FF 0F B6 72 FA 0F B6 41 FA 2B F0 89 75 10 74 10 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF EB 07 8B 45 10 EB 02 8B C3 85 C0 0F 85 50 FC FF FF 8B 42 FB 3B 41 FB 74 73 0F B6 F0 0F B6 41 FB 2B F0 74 12 33 DB 85 F6 0F 9F C3 8D 1C 5D FF FF FF FF 85 DB 75 5A 0F B6 72 FC 0F B6 41 FC 2B F0 74 12 33 DB 85 F6 0F 9F C3 8D 1C 5D FF FF FF FF 85 DB 75 3C 0F B6 72 FD 0F B6 41 FD 2B F0 74 12 33 DB 85 F6 0F 9F C3 8D 1C 5D FF FF FF FF 85 DB 75 1E 0F B6 5A FE 0F B6 41 FE 2B D8 74 0E 33 C0 85 DB 0F 9F C0 8D 1C 45 FF FF FF FF 85 DB 74 07 8B C3 E9 CA FB FF FF 0F B6 52 FF 0F B6 41 FF 2B D0 74 0E 33 C0 85 D2 0F 9F C0 8D 14 45 FF FF FF FF 8B C2 E9 A9 FB FF FF 8B 42 E2 3B 41 E2 0F 84 89 00 00 00 0F B6 F0 0F B6 41 E2 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 7C FB FF FF 0F B6 72 E3 0F B6 41 E3 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 5A FB FF FF 0F B6 72 E4 0F B6 41 E4 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 38 FB FF FF 0F B6 72 E5 0F B6 41 E5 2B F0 89 75 10 74 10 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF EB 07 8B 45 10 EB 02 8B C3 85 C0 0F 85 0A FB FF FF 8B 42 E6 3B 41 E6 0F 84 8A 00 00 00 0F B6 41 E6 0F B6 72 E6 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 DC FA FF FF 0F B6 72 E7 0F B6 41 E7 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 BA FA FF FF 0F B6 72 E8 0F B6 41 E8 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 98 FA FF FF 0F B6 72 E9 0F B6 41 E9 2B F0 89 75 10 74 10 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF EB 07 8B 45 10 EB 02 8B C3 85 C0 0F 85 6A FA FF FF 8B 42 EA 3B 41 EA 0F 84 89 00 00 00 0F B6 F0 0F B6 41 EA 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 3D FA FF FF 0F B6 72 EB 0F B6 41 EB 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 1B FA FF FF 0F B6 72 EC 0F B6 41 EC 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 F9 F9 FF FF 0F B6 72 ED 0F B6 41 ED 2B F0 89 75 10 74 10 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF EB 07 8B 45 10 EB 02 8B C3 85 C0 0F 85 CB F9 FF FF 8B 42 EE 3B 41 EE 0F 84 89 00 00 00 0F B6 F0 0F B6 41 EE 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 9E F9 FF FF 0F B6 72 EF 0F B6 41 EF 2B F0 74 16 33 C0 85 F6 0F 9F C0 8D 04 45 FF FF FF FF 85 C0 0F 85 }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "__mbsnbcat_s"
		size = 27
		refs = "0012 __mbsnbcat_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_672_7_0 {
	meta:
		name = "__aligned_recalloc"
		size = 27
		refs = "0012 __aligned_offset_recalloc"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_705_11_0 {
	meta:
		name = "__cftof"
		size = 27
		refs = "0012 __cftof_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_1027_0_0 {
	meta:
		name = "__mbccpy_s"
		size = 27
		refs = "0012 __mbccpy_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_1085_0_0 {
	meta:
		name = "__mbsnbcpy_s"
		size = 27
		refs = "0012 __mbsnbcpy_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_916_0_0 {
	meta:
		name = "__mbsnbset_s"
		size = 27
		refs = "0012 __mbsnbset_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_204_0_0 {
	meta:
		name = "__mbsncat_s"
		size = 27
		refs = "0012 __mbsncat_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_677_0_0 {
	meta:
		name = "__mbsncpy_s"
		size = 27
		refs = "0012 __mbsncpy_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_525_0_0 {
	meta:
		name = "__mbsnset_s"
		size = 27
		refs = "0012 __mbsnset_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_1081_6_0 {
	meta:
		name = "_wctomb_s"
		size = 27
		refs = "0012 __wctomb_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
		size = 136
		refs = "0012 __getptd 002a ___ptlocinfo 0031 ___globallocalestatus 003b ___updatetlocinfo 0046 ___ptmbcinfo 005a ___updatetmbcinfo"
	strings:
		$1 = { 55 8B EC 56 8B F1 8B 4D 08 C6 46 0C 00 85 C9 75 66 E8 ?? ?? ?? ?? 8B D0 89 56 08 8B 4A 6C 89 0E 8B 4A 68 89 4E 04 8B 0E 3B 0D ?? ?? ?? ?? 74 11 A1 ?? ?? ?? ?? 85 42 70 75 07 E8 ?? ?? ?? ?? 89 06 8B 46 04 3B 05 ?? ?? ?? ?? 74 15 8B 4E 08 A1 ?? ?? ?? ?? 85 41 70 75 08 E8 ?? ?? ?? ?? 89 46 04 8B 4E 08 8B 41 70 A8 02 75 16 83 C8 02 89 41 70 C6 46 0C 01 EB 0A 8B 01 89 06 8B 41 04 89 46 04 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_8_3_0 {
	meta:
		name = "?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
		size = 548
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0039 __errno 0044 __invalid_parameter_noinfo 006b __isctype_l"
	strings:
		$1 = { 55 8B EC 83 EC 24 8D 4D DC FF 75 08 E8 ?? ?? ?? ?? 8B 45 10 85 C0 74 05 8B 4D 0C 89 08 8B 45 0C 53 56 57 85 C0 74 11 8B 7D 14 85 FF 74 1F 83 FF 02 7C 05 83 FF 24 7E 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 C1 01 00 00 8B 7D DC 33 DB 89 5D F4 8A 18 8D 70 01 83 7F 74 01 7E 17 8D 45 DC 50 0F B6 C3 6A 08 50 E8 ?? ?? ?? ?? 8B 7D DC 83 C4 0C EB 10 8B 87 90 00 00 00 0F B6 CB 0F B7 04 48 83 E0 08 85 C0 74 05 8A 1E 46 EB CA 8B 45 18 88 5D FF 80 FB 2D 75 0B 83 C8 02 8A 0E 88 4D FF 46 EB 08 80 FB 2B 74 F3 8A 4D FF 8B 7D 14 8B 5D F4 89 45 F8 85 FF 0F 88 43 01 00 00 83 FF 01 0F 84 3A 01 00 00 83 FF 24 0F 8F 31 01 00 00 85 FF 75 1D 80 F9 30 74 05 6A 0A 5F EB 30 8A 06 3C 78 74 08 3C 58 74 04 6A 08 EB EF 6A 10 5F EB 0A 83 FF 10 75 18 80 F9 30 75 13 8A 06 3C 78 74 04 3C 58 75 09 8A 4E 01 88 4D FF 83 C6 02 83 C8 FF 33 D2 F7 F7 89 45 F4 8B 45 DC 89 55 F0 8B 80 90 00 00 00 8B 55 F8 89 45 EC 0F B6 C9 0F B7 04 48 8B C8 83 E1 04 74 09 0F BE 45 FF 83 E8 30 EB 1A 25 03 01 00 00 74 44 8A 4D FF 8D 41 9F 3C 19 0F BE C1 77 03 83 E8 20 83 C0 C9 3B C7 73 2D 8B 4D F4 83 CA 08 3B D9 72 13 75 05 3B 45 F0 76 0C 8B 45 10 83 CA 04 85 C0 74 15 EB 05 0F AF DF 03 D8 8A 0E 8B 45 EC 88 4D FF 46 EB 9E 8B 45 10 4E 89 55 F8 89 55 F8 F6 C2 08 75 0B 85 C0 74 03 8B 75 0C 33 DB EB 49 BF FF FF FF 7F F6 C2 04 75 1C F6 C2 01 75 3A 8B C2 83 E0 02 74 08 81 FB 00 00 00 80 77 08 85 C0 75 27 3B DF 76 23 E8 ?? ?? ?? ?? 8B 55 F8 C7 00 22 00 00 00 F6 C2 01 74 05 83 CB FF EB 0B 6A 00 F6 C2 02 5B 0F 95 C3 03 DF 8B 45 10 85 C0 74 02 89 30 F6 C2 02 74 12 F7 DB EB 0E 8B 45 10 85 C0 74 05 8B 4D 0C 89 08 33 DB 80 7D E8 00 74 07 8B 4D E4 83 61 70 FD 5F 5E 8B C3 5B C9 C3 }
	condition:
		$1
}

rule file_8_4_0 {
	meta:
		name = "__strtol_l"
		size = 27
		refs = "0012 ?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_708_5_0 {
	meta:
		name = "__strtoi64_l"
		size = 27
		refs = "0012 ?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_134_4_0 {
	meta:
		name = "__wcstoi64_l"
		size = 27
		refs = "0012 ?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_8_5_0 {
	meta:
		name = "__strtoul_l"
		size = 27
		refs = "0012 ?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 55 8B EC 6A 01 FF 75 10 FF 75 0C FF 75 08 FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_708_7_0 {
	meta:
		name = "__strtoui64_l"
		size = 27
		refs = "0012 ?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 55 8B EC 6A 01 FF 75 10 FF 75 0C FF 75 08 FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_134_6_0 {
	meta:
		name = "__wcstoui64_l"
		size = 27
		refs = "0012 ?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 55 8B EC 6A 01 FF 75 10 FF 75 0C FF 75 08 FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_8_6_0 {
	meta:
		name = "_strtol"
		size = 42
		refs = "0005 ___locale_changed 0018 ___initiallocalestructinfo 0021 ?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 6A 00 FF 75 10 FF 75 0C FF 75 08 75 07 68 ?? ?? ?? ?? EB 02 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_708_4_0 {
	meta:
		name = "__strtoi64"
		size = 42
		refs = "0005 ___locale_changed 0018 ___initiallocalestructinfo 0021 ?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 6A 00 FF 75 10 FF 75 0C FF 75 08 75 07 68 ?? ?? ?? ?? EB 02 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_134_3_0 {
	meta:
		name = "__wcstoi64"
		size = 42
		refs = "0005 ___locale_changed 0018 ___initiallocalestructinfo 0021 ?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 6A 00 FF 75 10 FF 75 0C FF 75 08 75 07 68 ?? ?? ?? ?? EB 02 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_8_7_0 {
	meta:
		name = "_strtoul"
		size = 42
		refs = "0005 ___locale_changed 0018 ___initiallocalestructinfo 0021 ?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 6A 01 FF 75 10 FF 75 0C FF 75 08 75 07 68 ?? ?? ?? ?? EB 02 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_708_6_0 {
	meta:
		name = "__strtoui64"
		size = 42
		refs = "0005 ___locale_changed 0018 ___initiallocalestructinfo 0021 ?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 6A 01 FF 75 10 FF 75 0C FF 75 08 75 07 68 ?? ?? ?? ?? EB 02 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_134_5_0 {
	meta:
		name = "__wcstoui64"
		size = 42
		refs = "0005 ___locale_changed 0018 ___initiallocalestructinfo 0021 ?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 6A 01 FF 75 10 FF 75 0C FF 75 08 75 07 68 ?? ?? ?? ?? EB 02 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "_feof"
		size = 38
		refs = "000b __errno 0016 __invalid_parameter_noinfo"
	strings:
		$1 = { 55 8B EC 8B 45 08 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 5D C3 8B 40 0C 83 E0 10 5D C3 }
	condition:
		$1
}

rule file_10_1_0 {
	meta:
		name = "_ferror"
		size = 38
		refs = "000b __errno 0016 __invalid_parameter_noinfo"
	strings:
		$1 = { 55 8B EC 8B 45 08 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 5D C3 8B 40 0C 83 E0 20 5D C3 }
	condition:
		$1
}

rule file_11_3_0 {
	meta:
		name = "__mbsstr"
		size = 21
		refs = "000c __mbsstr_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_5_187_2 {
	meta:
		name = "??$receive@I@Concurrency@@YAIPAV?$ISource@I@0@I@Z"
		size = 21
		refs = "000c ??$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@0@IPBV?$function@$$A6A_NABI@Z@std@@@Z"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_5_189_2 {
	meta:
		name = "??$receive@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@0@AAV?$ISource@W4agent_status@Concurrency@@@0@I@Z"
		size = 21
		refs = "000c ??$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@0@PAV?$ISource@W4agent_status@Concurrency@@@0@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_5_191_2 {
	meta:
		name = "??$receive@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@0@PAV?$ISource@W4agent_status@Concurrency@@@0@I@Z"
		size = 21
		refs = "000c ??$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@0@PAV?$ISource@W4agent_status@Concurrency@@@0@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_49_10_2 {
	meta:
		name = "__Cnd_wait"
		size = 21
		refs = "000c ?do_wait@@YAHPAPAU_Cnd_internal_imp_t@@PAPAU_Mtx_internal_imp_t@@PBUxtime@@@Z"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_672_1_0 {
	meta:
		name = "__aligned_malloc"
		size = 21
		refs = "000c __aligned_offset_malloc"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_505_3_0 {
	meta:
		name = "__atodbl"
		size = 21
		refs = "000c __atodbl_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_505_5_0 {
	meta:
		name = "__atoflt"
		size = 21
		refs = "000c __atoflt_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_505_7_0 {
	meta:
		name = "__atoldbl"
		size = 21
		refs = "000c __atoldbl_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_351_0_0 {
	meta:
		name = "__execvp"
		size = 21
		refs = "000c __execvpe"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_937_2_0 {
	meta:
		name = "__getws_s"
		size = 21
		refs = "000c __getws_helper"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_144_3_0 {
	meta:
		name = "__ismbslead"
		size = 21
		refs = "000c __ismbslead_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_984_3_0 {
	meta:
		name = "__ismbstrail"
		size = 21
		refs = "000c __ismbstrail_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_116_3_0 {
	meta:
		name = "__mbbtype"
		size = 21
		refs = "000c __mbbtype_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_411_3_0 {
	meta:
		name = "__mbsbtype"
		size = 21
		refs = "000c __mbsbtype_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_876_3_0 {
	meta:
		name = "__mbschr"
		size = 21
		refs = "000c __mbschr_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_850_3_0 {
	meta:
		name = "__mbscmp"
		size = 21
		refs = "000c __mbscmp_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_397_3_0 {
	meta:
		name = "__mbscoll"
		size = 21
		refs = "000c __mbscoll_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1061_3_0 {
	meta:
		name = "__mbscspn"
		size = 21
		refs = "000c __mbscspn_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_831_3_0 {
	meta:
		name = "__mbsdec"
		size = 21
		refs = "000c __mbsdec_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_141_3_0 {
	meta:
		name = "__mbsicmp"
		size = 21
		refs = "000c __mbsicmp_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1005_3_0 {
	meta:
		name = "__mbsicoll"
		size = 21
		refs = "000c __mbsicoll_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_769_5_0 {
	meta:
		name = "__mbslwr_s"
		size = 21
		refs = "000c __mbslwr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1019_3_0 {
	meta:
		name = "__mbsnbcnt"
		size = 21
		refs = "000c __mbsnbcnt_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1132_3_0 {
	meta:
		name = "__mbsnccnt"
		size = 21
		refs = "000c __mbsnccnt_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_305_0_0 {
	meta:
		name = "__mbsninc"
		size = 21
		refs = "000c __mbsninc_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_668_3_0 {
	meta:
		name = "__mbsnlen"
		size = 21
		refs = "000c __mbsnlen_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_112_3_0 {
	meta:
		name = "__mbspbrk"
		size = 21
		refs = "000c __mbspbrk_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_13_3_0 {
	meta:
		name = "__mbsrchr"
		size = 21
		refs = "000c __mbsrchr_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_563_3_0 {
	meta:
		name = "__mbsset"
		size = 21
		refs = "000c __mbsset_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_450_3_0 {
	meta:
		name = "__mbsspn"
		size = 21
		refs = "000c __mbsspn_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_306_3_0 {
	meta:
		name = "__mbsspnp"
		size = 21
		refs = "000c __mbsspnp_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1082_0_0 {
	meta:
		name = "__mbstok"
		size = 21
		refs = "000c __mbstok_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_198_3_0 {
	meta:
		name = "__mbstrnlen"
		size = 21
		refs = "000c __mbstrnlen_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_444_5_0 {
	meta:
		name = "__mbsupr_s"
		size = 21
		refs = "000c __mbsupr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_208_8_0 {
	meta:
		name = "__strlwr_s"
		size = 21
		refs = "000c __strlwr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1150_8_0 {
	meta:
		name = "__strupr_s"
		size = 21
		refs = "000c __strupr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_971_8_0 {
	meta:
		name = "__wcslwr_s"
		size = 21
		refs = "000c __wcslwr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_200_8_0 {
	meta:
		name = "__wcsupr_s"
		size = 21
		refs = "000c __wcsupr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1138_0_0 {
	meta:
		name = "__wexecvp"
		size = 21
		refs = "000c __wexecvpe"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_264_2_0 {
	meta:
		name = "_gets_s"
		size = 21
		refs = "000c __gets_helper"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_133_4_0 {
	meta:
		name = "_strcoll"
		size = 21
		refs = "000c __strcoll_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_146_4_0 {
	meta:
		name = "_strtod"
		size = 21
		refs = "000c __strtod_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_328_4_0 {
	meta:
		name = "_wcstod"
		size = 21
		refs = "000c __wcstod_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_11_4_0 {
	meta:
		name = "__mbsstr_l"
		size = 224
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0025 _strstr 004d __errno 0058 __invalid_parameter_noinfo 0060 _strlen"
	strings:
		$1 = { 55 8B EC 83 EC 18 53 56 57 FF 75 10 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 EC 33 DB 39 58 08 75 14 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 8B D8 E9 9A 00 00 00 8B 45 0C 85 C0 74 13 38 18 75 08 8B 5D 08 E9 87 00 00 00 8B 7D 08 85 FF 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 6E 50 E8 ?? ?? ?? ?? 8B F7 57 2B F0 E8 ?? ?? ?? ?? 03 C6 59 59 89 45 F8 38 1F 74 53 8B 55 0C 8B 75 EC 8B CF 2B CA 3B F8 77 45 8B C2 8A 17 88 55 FE 84 D2 8B 55 0C 74 14 8A 10 84 D2 74 2F 38 14 01 8B 55 0C 75 06 40 38 1C 01 75 EC 38 18 74 1D 0F B6 45 FE 47 8A 44 30 19 41 24 04 74 06 38 1F 74 0D 47 41 8B 45 F8 38 1F 75 BB EB 02 8B DF 80 7D F4 00 74 07 8B 4D F0 83 61 70 FD 5F 5E 8B C3 5B C9 C3 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "__swscanf_l"
		size = 31
		refs = "0011 __winput_l 0016 _vscan_fn"
	strings:
		$1 = { 55 8B EC 8D 45 14 50 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_1060_0_0 {
	meta:
		name = "__fscanf_l"
		size = 31
		refs = "0011 __input_l 0016 _vfscanf"
	strings:
		$1 = { 55 8B EC 8D 45 14 50 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_1060_1_0 {
	meta:
		name = "__fscanf_s_l"
		size = 31
		refs = "0011 __input_s_l 0016 _vfscanf"
	strings:
		$1 = { 55 8B EC 8D 45 14 50 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_39_0_0 {
	meta:
		name = "__fwscanf_l"
		size = 31
		refs = "0011 __winput_l 0016 _vfwscanf"
	strings:
		$1 = { 55 8B EC 8D 45 14 50 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_39_1_0 {
	meta:
		name = "__fwscanf_s_l"
		size = 31
		refs = "0011 __winput_s_l 0016 _vfwscanf"
	strings:
		$1 = { 55 8B EC 8D 45 14 50 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_1112_0_0 {
	meta:
		name = "__sscanf_l"
		size = 31
		refs = "0011 __input_l 0016 _vscan_fn"
	strings:
		$1 = { 55 8B EC 8D 45 14 50 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_1112_1_0 {
	meta:
		name = "__sscanf_s_l"
		size = 31
		refs = "0011 __input_s_l 0016 _vscan_fn"
	strings:
		$1 = { 55 8B EC 8D 45 14 50 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_12_1_0 {
	meta:
		name = "__swscanf_s_l"
		size = 31
		refs = "0011 __winput_s_l 0016 _vscan_fn"
	strings:
		$1 = { 55 8B EC 8D 45 14 50 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_12_2_0 {
	meta:
		name = "_swscanf"
		size = 30
		refs = "0010 __winput_l 0015 _vscan_fn"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_1060_2_0 {
	meta:
		name = "_fscanf"
		size = 30
		refs = "0010 __input_l 0015 _vfscanf"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_1060_3_0 {
	meta:
		name = "_fscanf_s"
		size = 30
		refs = "0010 __input_s_l 0015 _vfscanf"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_39_2_0 {
	meta:
		name = "_fwscanf"
		size = 30
		refs = "0010 __winput_l 0015 _vfwscanf"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_39_3_0 {
	meta:
		name = "_fwscanf_s"
		size = 30
		refs = "0010 __winput_s_l 0015 _vfwscanf"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_1112_2_0 {
	meta:
		name = "_sscanf"
		size = 30
		refs = "0010 __input_l 0015 _vscan_fn"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_1112_3_0 {
	meta:
		name = "_sscanf_s"
		size = 30
		refs = "0010 __input_s_l 0015 _vscan_fn"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_12_3_0 {
	meta:
		name = "_swscanf_s"
		size = 30
		refs = "0010 __winput_s_l 0015 _vscan_fn"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_12_4_0 {
	meta:
		name = "_vscan_fn"
		size = 119
		refs = "001e __errno 0029 __invalid_parameter_noinfo 0039 _wcslen"
	strings:
		$1 = { 55 8B EC 83 EC 20 83 65 E0 00 56 8B 75 0C 57 6A 07 33 C0 59 8D 7D E4 F3 AB 85 F6 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 41 39 45 10 74 E6 56 E8 ?? ?? ?? ?? 59 C7 45 EC 49 00 00 00 89 75 E8 89 75 E0 3D FF FF FF 3F 76 09 C7 45 E4 FF FF FF 7F EB 05 03 C0 89 45 E4 FF 75 18 8D 45 E0 FF 75 14 FF 75 10 50 FF 55 08 83 C4 10 5F 5E C9 C3 }
	condition:
		$1
}

rule file_13_4_0 {
	meta:
		name = "__mbsrchr_l"
		size = 143
		refs = "0011 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001d __errno 0028 __invalid_parameter_noinfo 003b _strrchr"
	strings:
		$1 = { 55 8B EC 83 EC 10 8D 4D F0 56 57 FF 75 10 33 F6 E8 ?? ?? ?? ?? 8B 4D 08 85 C9 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 4E 8B 7D F4 39 77 08 75 0F FF 75 0C 51 E8 ?? ?? ?? ?? 59 59 8B F0 EB 37 53 8A 19 0F B6 D3 F6 44 3A 19 04 74 1D 41 8A 19 84 DB 74 12 0F B6 C3 C1 E2 08 0B D0 39 55 0C 75 10 8D 71 FF EB 0B 85 F6 EB 03 39 55 0C 75 02 8B F1 41 84 DB 75 CB 5B 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD 5F 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "__invoke_watson_if_error"
		size = 32
		refs = "001b __invoke_watson"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 75 02 5D C3 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_14_1_0 {
	meta:
		name = "__invoke_watson_if_oneof"
		size = 43
		refs = "0026 __invoke_watson"
	strings:
		$1 = { 55 8B EC 8B 45 08 85 C0 74 0A 3B 45 0C 74 07 3B 45 10 74 02 5D C3 FF 75 24 FF 75 20 FF 75 1C FF 75 18 FF 75 14 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_14_2_0 {
	meta:
		name = "__wspawnvpe"
		size = 568
		refs = "0017 __errno 0022 __invalid_parameter_noinfo 007a __wspawnve 00a3 _wcschr 00b2 ??_C@_19IJOJOJIB@?$AAP?$AAA?$AAT?$AAH?$AA?$AA@ 00bc __wdupenv_s 00e6 __calloc_crt 0111 _wcslen 012e ??_C@_13FPGAJAPJ@?$AA?2?$AA?$AA@ 0139 _wcscat_s 01aa ___doserrno 01de __wgetpath 0210 _free 0233 __invoke_watson"
	strings:
		$1 = { 55 8B EC 83 EC 0C 53 8B 5D 0C 33 C9 57 89 4D FC 8B F9 85 DB 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 F9 01 00 00 66 39 0B 74 E3 56 8B 75 10 85 F6 74 0B 8B 06 85 C0 74 05 66 39 08 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 C8 01 00 00 E8 ?? ?? ?? ?? 8B 00 89 45 F4 E8 ?? ?? ?? ?? FF 75 14 33 C9 56 53 FF 75 08 89 08 E8 ?? ?? ?? ?? 8B F0 83 C4 10 89 75 F8 83 FE FF 0F 85 66 01 00 00 E8 ?? ?? ?? ?? 83 38 02 0F 85 58 01 00 00 6A 2F 58 50 53 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 44 01 00 00 68 ?? ?? ?? ?? 50 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0E 83 F8 16 0F 85 25 01 00 00 E9 56 01 00 00 39 7D FC 0F 84 17 01 00 00 6A 02 68 04 01 00 00 E8 ?? ?? ?? ?? 8B F8 59 59 85 FF 0F 84 FF 00 00 00 68 03 01 00 00 57 FF 75 FC E9 D9 00 00 00 33 C0 66 39 07 0F 84 E6 00 00 00 57 E8 ?? ?? ?? ?? 59 8D 04 47 6A 5C 0F B7 40 FE 59 66 3B C1 74 23 6A 2F 59 66 3B C1 74 1B 68 ?? ?? ?? ?? 68 04 01 00 00 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 E3 00 00 00 57 E8 ?? ?? ?? ?? 53 8B F0 E8 ?? ?? ?? ?? 03 F0 B8 04 01 00 00 59 59 3B F0 0F 83 8B 00 00 00 53 50 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 B1 00 00 00 E8 ?? ?? ?? ?? FF 75 14 33 C9 FF 75 10 89 08 57 FF 75 08 E8 ?? ?? ?? ?? 8B F0 83 C4 10 89 45 F8 83 FE FF 75 56 E8 ?? ?? ?? ?? 83 38 02 74 2B E8 ?? ?? ?? ?? 83 38 15 74 21 0F B7 07 6A 5C 5A 6A 2F 59 66 3B C2 74 05 66 3B C1 75 2F 0F B7 47 02 66 3B C2 74 05 66 3B C1 75 21 68 03 01 00 00 57 FF 75 0C E8 ?? ?? ?? ?? 83 C4 0C 89 45 0C 85 C0 0F 85 14 FF FF FF EB 03 8B 75 F8 E8 ?? ?? ?? ?? 33 C9 39 08 75 0A E8 ?? ?? ?? ?? 8B 4D F4 89 08 85 FF 74 07 57 E8 ?? ?? ?? ?? 59 83 7D FC 00 74 09 FF 75 FC E8 ?? ?? ?? ?? 59 8B C6 5E 5F 5B C9 C3 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_15_2_0 {
	meta:
		name = "??0VirtualProcessorRoot@details@Concurrency@@QAE@PAVSchedulerProxy@12@PAUSchedulerNode@12@I@Z"
		size = 71
		refs = "0010 ??_7VirtualProcessorRoot@details@Concurrency@@6B@ 0020 ??0ExecutionResource@details@Concurrency@@QAE@PAVSchedulerProxy@12@PAUSchedulerNode@12@I@Z 002e ?s_currentId@VirtualProcessorRoot@details@Concurrency@@0JA"
	strings:
		$1 = { 55 8B EC 53 56 57 FF 75 10 8B F9 FF 75 0C C7 07 ?? ?? ?? ?? FF 75 08 33 DB 89 5F 04 8D 4F 08 E8 ?? ?? ?? ?? 33 C0 66 89 5F 44 89 5F 4C B9 ?? ?? ?? ?? 40 F0 0F C1 01 40 89 47 48 89 7F 24 8B C7 5F 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule file_15_3_0 {
	meta:
		name = "??0invalid_argument@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_371_0_0 {
	meta:
		name = "??0_Interruption_exception@details@Concurrency@@QAE@ABV012@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7_Interruption_exception@details@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_318_0_0 {
	meta:
		name = "??0__non_rtti_object@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0bad_typeid@std@@QAE@ABV01@@Z 0010 ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_318_1_0 {
	meta:
		name = "??0__non_rtti_object@std@@QAE@PBD@Z"
		size = 27
		refs = "000a ??0bad_typeid@std@@QAE@PBD@Z 0010 ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_47_31_2 {
	meta:
		name = "??0bad_alloc@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_318_2_0 {
	meta:
		name = "??0bad_cast@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_761_36_0 {
	meta:
		name = "??0bad_exception@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_104_20_2 {
	meta:
		name = "??0bad_function_call@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7bad_function_call@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_122_409_1 {
	meta:
		name = "??0bad_target@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7bad_target@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_318_4_0 {
	meta:
		name = "??0bad_typeid@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_709_8_0 {
	meta:
		name = "??0context_self_unblock@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7context_self_unblock@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_709_9_0 {
	meta:
		name = "??0context_unblock_unbalanced@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7context_unblock_unbalanced@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_765_57_0 {
	meta:
		name = "??0default_scheduler_exists@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7default_scheduler_exists@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_30_59_2 {
	meta:
		name = "??0failure@ios_base@std@@QAE@ABV012@@Z"
		size = 27
		refs = "000a ??0system_error@std@@QAE@ABV01@@Z 0010 ??_7failure@ios_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_605_19_0 {
	meta:
		name = "??0improper_lock@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7improper_lock@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_765_58_0 {
	meta:
		name = "??0improper_scheduler_attach@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7improper_scheduler_attach@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_765_59_0 {
	meta:
		name = "??0improper_scheduler_detach@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7improper_scheduler_detach@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_765_60_0 {
	meta:
		name = "??0improper_scheduler_reference@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7improper_scheduler_reference@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_412_2 {
	meta:
		name = "??0invalid_link_target@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7invalid_link_target@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1116_28_0 {
	meta:
		name = "??0invalid_multiple_scheduling@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7invalid_multiple_scheduling@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_399_8_0 {
	meta:
		name = "??0invalid_operation@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7invalid_operation@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_778_2_0 {
	meta:
		name = "??0invalid_oversubscribe_operation@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7invalid_oversubscribe_operation@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1103_3_0 {
	meta:
		name = "??0invalid_scheduler_policy_key@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7invalid_scheduler_policy_key@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1103_4_0 {
	meta:
		name = "??0invalid_scheduler_policy_thread_specification@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7invalid_scheduler_policy_thread_specification@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1103_5_0 {
	meta:
		name = "??0invalid_scheduler_policy_value@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7invalid_scheduler_policy_value@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_69_36_1 {
	meta:
		name = "??0length_error@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7length_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_61_29_1 {
	meta:
		name = "??0lock_error@threads@stdext@@QAE@ABV012@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7lock_error@threads@stdext@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_709_14_0 {
	meta:
		name = "??0logic_error@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7logic_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_416_2 {
	meta:
		name = "??0message_not_found@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7message_not_found@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_371_2_0 {
	meta:
		name = "??0missing_wait@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7missing_wait@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_709_16_0 {
	meta:
		name = "??0nested_scheduler_missing_detach@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7nested_scheduler_missing_detach@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_122_417_1 {
	meta:
		name = "??0operation_timed_out@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7operation_timed_out@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_31_48_1 {
	meta:
		name = "??0out_of_range@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_69_42_1 {
	meta:
		name = "??0overflow_error@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7overflow_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_47_41_2 {
	meta:
		name = "??0range_error@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7range_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_42_66_2 {
	meta:
		name = "??0runtime_error@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_115_1_0 {
	meta:
		name = "??0scheduler_not_attached@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7scheduler_not_attached@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1057_7_0 {
	meta:
		name = "??0scheduler_worker_creation_error@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0scheduler_resource_allocation_error@Concurrency@@QAE@ABV01@@Z 0010 ??_7scheduler_worker_creation_error@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_991_44_0 {
	meta:
		name = "??0scheduler_worker_creation_error@Concurrency@@QAE@J@Z"
		size = 27
		refs = "000a ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 0010 ??_7scheduler_worker_creation_error@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_99_410_1 {
	meta:
		name = "??0task_canceled@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7task_canceled@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_61_33_1 {
	meta:
		name = "??0thread_resource_error@threads@stdext@@QAE@ABV012@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7thread_resource_error@threads@stdext@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_178_30_0 {
	meta:
		name = "??0unsupported_os@Concurrency@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7unsupported_os@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_15_4_0 {
	meta:
		name = "??0invalid_argument@std@@QAE@PBD@Z"
		size = 34
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 0017 ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 55 8B EC 8B 45 08 56 89 45 08 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_761_39_0 {
	meta:
		name = "??0length_error@std@@QAE@PBD@Z"
		size = 34
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 0017 ??_7length_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 8B 45 08 56 89 45 08 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_31_49_1 {
	meta:
		name = "??0out_of_range@std@@QAE@PBD@Z"
		size = 34
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 0017 ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 55 8B EC 8B 45 08 56 89 45 08 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_69_43_1 {
	meta:
		name = "??0overflow_error@std@@QAE@PBD@Z"
		size = 34
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 0017 ??_7overflow_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 8B 45 08 56 89 45 08 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_31_51_1 {
	meta:
		name = "??0range_error@std@@QAE@PBD@Z"
		size = 34
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 0017 ??_7range_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 8B 45 08 56 89 45 08 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_15_7_0 {
	meta:
		name = "??0logic_error@std@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7logic_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_991_0_0 {
	meta:
		name = "??0_Interruption_exception@details@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7_Interruption_exception@details@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_318_3_0 {
	meta:
		name = "??0bad_cast@std@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_67_2_0 {
	meta:
		name = "??0bad_exception@std@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_991_2_0 {
	meta:
		name = "??0bad_target@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7bad_target@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_318_5_0 {
	meta:
		name = "??0bad_typeid@std@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_991_4_0 {
	meta:
		name = "??0context_self_unblock@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7context_self_unblock@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_991_6_0 {
	meta:
		name = "??0context_unblock_unbalanced@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7context_unblock_unbalanced@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_991_8_0 {
	meta:
		name = "??0default_scheduler_exists@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7default_scheduler_exists@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_991_10_0 {
	meta:
		name = "??0improper_lock@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7improper_lock@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_991_12_0 {
	meta:
		name = "??0improper_scheduler_attach@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7improper_scheduler_attach@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_991_14_0 {
	meta:
		name = "??0improper_scheduler_detach@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7improper_scheduler_detach@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_991_16_0 {
	meta:
		name = "??0improper_scheduler_reference@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7improper_scheduler_reference@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_991_18_0 {
	meta:
		name = "??0invalid_link_target@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7invalid_link_target@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_991_20_0 {
	meta:
		name = "??0invalid_multiple_scheduling@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7invalid_multiple_scheduling@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_991_22_0 {
	meta:
		name = "??0invalid_operation@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7invalid_operation@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_991_24_0 {
	meta:
		name = "??0invalid_oversubscribe_operation@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7invalid_oversubscribe_operation@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_991_26_0 {
	meta:
		name = "??0invalid_scheduler_policy_key@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7invalid_scheduler_policy_key@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_991_28_0 {
	meta:
		name = "??0invalid_scheduler_policy_thread_specification@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7invalid_scheduler_policy_thread_specification@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_991_30_0 {
	meta:
		name = "??0invalid_scheduler_policy_value@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7invalid_scheduler_policy_value@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_991_32_0 {
	meta:
		name = "??0message_not_found@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7message_not_found@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_991_34_0 {
	meta:
		name = "??0missing_wait@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7missing_wait@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_991_36_0 {
	meta:
		name = "??0nested_scheduler_missing_detach@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7nested_scheduler_missing_detach@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_991_38_0 {
	meta:
		name = "??0operation_timed_out@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7operation_timed_out@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_42_68_2 {
	meta:
		name = "??0runtime_error@std@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_991_40_0 {
	meta:
		name = "??0scheduler_not_attached@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7scheduler_not_attached@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_991_46_0 {
	meta:
		name = "??0task_canceled@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7task_canceled@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_991_48_0 {
	meta:
		name = "??0unsupported_os@Concurrency@@QAE@PBD@Z"
		size = 28
		refs = "000b ??0exception@std@@QAE@ABQBD@Z 0011 ??_7unsupported_os@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_15_14_0 {
	meta:
		name = "??_EGlobalCore@details@Concurrency@@QAEPAXI@Z"
		size = 78
		refs = "000e ??1GlobalCore@details@Concurrency@@QAE@XZ 001b ??_M@YGXPAXIHP6EX0@Z@Z 0027 ??_V@YAXPAX@Z 0035 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 02 56 8B F1 74 25 57 68 ?? ?? ?? ?? 8D 7E FC FF 37 6A 24 56 E8 ?? ?? ?? ?? F6 45 08 01 74 07 57 E8 ?? ?? ?? ?? 59 8B C7 5F EB 18 FF 76 20 E8 ?? ?? ?? ?? F6 45 08 01 59 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_15_15_0 {
	meta:
		name = "??_GVirtualProcessorRoot@details@Concurrency@@UAEPAXI@Z"
		size = 39
		refs = "000c ??_7VirtualProcessorRoot@details@Concurrency@@6B@ 0013 ??_7ExecutionResource@details@Concurrency@@6B@ 001b ??3@YAXPAX@Z"
		altNames = "??_GFreeVirtualProcessorRoot@details@Concurrency@@UAEPAXI@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? C7 46 08 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_15_16_0 {
	meta:
		name = "??_Ginvalid_argument@std@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1exception@std@@UAE@XZ 0013 ??3@YAXPAX@Z"
		altNames = "??_G_Interruption_exception@details@Concurrency@@UAEPAXI@Z ??_Gbad_function_call@std@@UAEPAXI@Z ??_Gbad_target@Concurrency@@UAEPAXI@Z ??_Gcontext_self_unblock@Concurrency@@UAEPAXI@Z ??_Gcontext_unblock_unbalanced@Concurrency@@UAEPAXI@Z ??_Gdefault_scheduler_exists@Concurrency@@UAEPAXI@Z ??_Gfailure@ios_base@std@@UAEPAXI@Z ??_Gfuture_error@std@@UAEPAXI@Z ??_Gimproper_lock@Concurrency@@UAEPAXI@Z ??_Gimproper_scheduler_attach@Concurrency@@UAEPAXI@Z ??_Gimproper_scheduler_detach@Concurrency@@UAEPAXI@Z ??_Gimproper_scheduler_reference@Concurrency@@UAEPAXI@Z ??_Ginvalid_link_target@Concurrency@@UAEPAXI@Z ??_Ginvalid_multiple_scheduling@Concurrency@@UAEPAXI@Z ??_Ginvalid_operation@Concurrency@@UAEPAXI@Z ??_Ginvalid_oversubscribe_operation@Concurrency@@UAEPAXI@Z ??_Ginvalid_scheduler_policy_key@Concurrency@@UAEPAXI@Z ??_Ginvalid_scheduler_policy_thread_specification@Concurrency@@UAEPAXI@Z ??_Ginvalid_scheduler_policy_value@Concurrency@@UAEPAXI@Z ??_Glength_error@std@@UAEPAXI@Z ??_Glock_error@threads@stdext@@UAEPAXI@Z ??_Glogic_error@std@@UAEPAXI@Z ??_Gmessage_not_found@Concurrency@@UAEPAXI@Z ??_Gmissing_wait@Concurrency@@UAEPAXI@Z ??_Gnested_scheduler_missing_detach@Concurrency@@UAEPAXI@Z ??_Goperation_timed_out@Concurrency@@UAEPAXI@Z ??_Gout_of_range@std@@UAEPAXI@Z ??_Goverflow_error@std@@UAEPAXI@Z ??_Grange_error@std@@UAEPAXI@Z ??_Gregex_error@std@@UAEPAXI@Z ??_Gruntime_error@std@@UAEPAXI@Z ??_Gscheduler_not_attached@Concurrency@@UAEPAXI@Z ??_Gscheduler_resource_allocation_error@Concurrency@@UAEPAXI@Z ??_Gscheduler_worker_creation_error@Concurrency@@UAEPAXI@Z ??_Gsystem_error@std@@UAEPAXI@Z ??_Gtask_canceled@Concurrency@@UAEPAXI@Z ??_Gthread_resource_error@threads@stdext@@UAEPAXI@Z ??_Gunsupported_os@Concurrency@@UAEPAXI@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_122_656_1 {
	meta:
		name = "??_G?$_AnonymousOriginator@I@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$_AnonymousOriginator@I@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_657_2 {
	meta:
		name = "??_G?$_AnonymousOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$_AnonymousOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_122_669_1 {
	meta:
		name = "??_G?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_670_2 {
	meta:
		name = "??_G?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_99_578_1 {
	meta:
		name = "??_G?$_RunAllParam@E@details@Concurrency@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$_RunAllParam@E@details@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_100_583_1 {
	meta:
		name = "??_G?$_RunAnyParam@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$_RunAnyParam@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_671_2 {
	meta:
		name = "??_G?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_122_672_1 {
	meta:
		name = "??_G?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_122_673_1 {
	meta:
		name = "??_G?$_SyncOriginator@I@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$_SyncOriginator@I@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_674_2 {
	meta:
		name = "??_G?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_53_125_1 {
	meta:
		name = "??_G?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_60_124_1 {
	meta:
		name = "??_G?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_48_124_1 {
	meta:
		name = "??_G?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_53_128_1 {
	meta:
		name = "??_G?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_60_127_1 {
	meta:
		name = "??_G?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_81_107_2 {
	meta:
		name = "??_G?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_122_675_1 {
	meta:
		name = "??_G?$call@IV?$function@$$A6AXABI@Z@std@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$call@IV?$function@$$A6AXABI@Z@std@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_80_201_1 {
	meta:
		name = "??_G?$collate@D@std@@MAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$collate@D@std@@MAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_62_450_1 {
	meta:
		name = "??_G?$collate@G@std@@MAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$collate@G@std@@MAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_62_451_1 {
	meta:
		name = "??_G?$collate@_W@std@@MAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$collate@_W@std@@MAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_122_676_1 {
	meta:
		name = "??_G?$concurrent_queue@PAV?$message@I@Concurrency@@V?$allocator@PAV?$message@I@Concurrency@@@std@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$concurrent_queue@PAV?$message@I@Concurrency@@V?$allocator@PAV?$message@I@Concurrency@@@std@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_122_677_1 {
	meta:
		name = "??_G?$concurrent_queue@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$concurrent_queue@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_10_109_2 {
	meta:
		name = "??_G?$ctype@G@std@@MAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$ctype@G@std@@MAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_30_109_2 {
	meta:
		name = "??_G?$ctype@_W@std@@MAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$ctype@_W@std@@MAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_682_2 {
	meta:
		name = "??_G?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_683_2 {
	meta:
		name = "??_G?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_684_2 {
	meta:
		name = "??_G?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_685_2 {
	meta:
		name = "??_G?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_686_2 {
	meta:
		name = "??_G?$ordered_message_processor@I@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$ordered_message_processor@I@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_122_687_1 {
	meta:
		name = "??_G?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_122_688_1 {
	meta:
		name = "??_G?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_122_689_1 {
	meta:
		name = "??_G?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_122_690_1 {
	meta:
		name = "??_G?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_122_691_1 {
	meta:
		name = "??_G?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_122_692_1 {
	meta:
		name = "??_G?$single_assignment@I@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$single_assignment@I@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_693_2 {
	meta:
		name = "??_G?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_122_694_1 {
	meta:
		name = "??_G?$single_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$single_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_122_695_1 {
	meta:
		name = "??_G?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_122_696_1 {
	meta:
		name = "??_G?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_697_2 {
	meta:
		name = "??_G?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_698_2 {
	meta:
		name = "??_G?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_4_174_2 {
	meta:
		name = "??_G?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_62_472_1 {
	meta:
		name = "??_G?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_105_404_2 {
	meta:
		name = "??_G?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 31
		refs = "0007 ??1?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_765_117_0 {
	meta:
		name = "??_GCacheLocalScheduleGroupSegment@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1ScheduleGroupSegmentBase@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_553_46_0 {
	meta:
		name = "??_GContextBase@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1ContextBase@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_109_26_0 {
	meta:
		name = "??_GExternalContextBase@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1ExternalContextBase@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_765_119_0 {
	meta:
		name = "??_GFairScheduleGroupSegment@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1ScheduleGroupSegmentBase@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_709_40_0 {
	meta:
		name = "??_GInternalContextBase@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1InternalContextBase@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_178_50_0 {
	meta:
		name = "??_GResourceManager@details@Concurrency@@AAEPAXI@Z"
		size = 31
		refs = "0007 ??1ResourceManager@details@Concurrency@@AAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_860_73_0 {
	meta:
		name = "??_GScheduleGroupSegmentBase@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1ScheduleGroupSegmentBase@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_765_123_0 {
	meta:
		name = "??_GSchedulerBase@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1SchedulerBase@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_765_124_0 {
	meta:
		name = "??_GSchedulerPolicy@Concurrency@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1SchedulerPolicy@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_449_22_0 {
	meta:
		name = "??_GSchedulerProxy@details@Concurrency@@IAEPAXI@Z"
		size = 31
		refs = "0007 ??1SchedulerProxy@details@Concurrency@@IAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_765_125_0 {
	meta:
		name = "??_GSchedulingNode@details@Concurrency@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1SchedulingNode@details@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_765_126_0 {
	meta:
		name = "??_GSchedulingRing@details@Concurrency@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1SchedulingRing@details@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_185_22_0 {
	meta:
		name = "??_GSegment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_185_23_0 {
	meta:
		name = "??_GSegment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1116_50_0 {
	meta:
		name = "??_GTaskStack@details@Concurrency@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1TaskStack@details@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_33_10_0 {
	meta:
		name = "??_GThreadProxy@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1ThreadProxy@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1070_13_0 {
	meta:
		name = "??_GThreadScheduler@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1ThreadScheduler@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1155_11_0 {
	meta:
		name = "??_GTimerObj@?6??wait@Concurrency@@YAXI@Z@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1_Timer@details@Concurrency@@MAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1183_18_0 {
	meta:
		name = "??_GTransmogrifiedPrimary@details@Concurrency@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1TransmogrifiedPrimary@details@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_849_40_0 {
	meta:
		name = "??_GUMSFreeThreadProxy@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1UMSFreeThreadProxy@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_849_41_0 {
	meta:
		name = "??_GUMSFreeThreadProxyFactory@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1UMSFreeThreadProxyFactory@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_944_32_0 {
	meta:
		name = "??_GUMSFreeVirtualProcessorRoot@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1UMSFreeVirtualProcessorRoot@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_356_17_0 {
	meta:
		name = "??_GUMSSchedulerProxy@details@Concurrency@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1UMSSchedulerProxy@details@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_778_10_0 {
	meta:
		name = "??_GUMSThreadInternalContext@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1UMSThreadInternalContext@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1057_13_0 {
	meta:
		name = "??_GUMSThreadProxy@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1UMSThreadProxy@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_809_12_0 {
	meta:
		name = "??_GUMSThreadScheduler@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1UMSThreadScheduler@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_538_11_0 {
	meta:
		name = "??_GUMSThreadVirtualProcessor@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1UMSThreadVirtualProcessor@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_92_25_0 {
	meta:
		name = "??_GVirtualProcessor@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1VirtualProcessor@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_699_2 {
	meta:
		name = "??_G_Blocking_recipient@?1???$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@std@@@Z@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1_Blocking_recipient@?1???$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@std@@@Z@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_700_2 {
	meta:
		name = "??_G_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_145_27_0 {
	meta:
		name = "??_G_CancellationTokenState@details@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1_CancellationTokenState@details@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_89_36_1 {
	meta:
		name = "??_G_Concurrent_queue_base_v4@details@Concurrency@@MAEPAXI@Z"
		size = 31
		refs = "0007 ??1_Concurrent_queue_base_v4@details@Concurrency@@MAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_49_2_2 {
	meta:
		name = "??_G_Condition_variable@details@Concurrency@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1_Condition_variable@details@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_99_583_1 {
	meta:
		name = "??_G_ExceptionHolder@details@Concurrency@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1_ExceptionHolder@details@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_92_48_2 {
	meta:
		name = "??_G_Fac_node@std@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1_Fac_node@std@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_4_64_1 {
	meta:
		name = "??_G_Locimp@locale@std@@MAEPAXI@Z"
		size = 31
		refs = "0007 ??1_Locimp@locale@std@@MAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_553_49_0 {
	meta:
		name = "??_G_TaskCollection@details@Concurrency@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1_TaskCollection@details@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1155_12_0 {
	meta:
		name = "??_G_Timer@details@Concurrency@@MAEPAXI@Z"
		size = 31
		refs = "0007 ??1_Timer@details@Concurrency@@MAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_761_64_0 {
	meta:
		name = "??_G__ExceptionPtr@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1__ExceptionPtr@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_701_2 {
	meta:
		name = "??_Gagent@Concurrency@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1agent@Concurrency@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_125_50_1 {
	meta:
		name = "??_Gcritical_section@Concurrency@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1critical_section@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_24_120_2 {
	meta:
		name = "??_Glocale@std@@QAEPAXI@Z"
		size = 31
		refs = "0007 ??1locale@std@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_21_5_0 {
	meta:
		name = "??_Gtype_info@@UAEPAXI@Z"
		size = 31
		refs = "0007 ??1type_info@@UAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_15_19_0 {
	meta:
		name = "??_H@YGXPAXIHP6EPAX0@Z@Z"
		size = 31
	strings:
		$1 = { 55 8B EC 56 8B 75 10 4E 78 10 57 8B 7D 08 8B CF FF 55 14 03 7D 0C 4E 79 F5 5F 5E 5D C2 10 00 }
	condition:
		$1
}

rule file_15_30_0 {
	meta:
		name = "?Remove@VirtualProcessorRoot@details@Concurrency@@UAEXPAUIScheduler@3@@Z"
		size = 101
		refs = "001c ??0invalid_operation@Concurrency@@QAE@XZ 0021 __TI2?AVinvalid_operation@Concurrency@@ 002a ?ResetSubscriptionLevel@VirtualProcessorRoot@details@Concurrency@@QAEXXZ 0033 ?DestroyVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@QAEXPAVVirtualProcessorRoot@23@@Z 0046 ??_C@_0L@HKFDMHB@pScheduler?$AA@ 004b ??0exception@std@@QAE@ABQBD@Z 0052 ??_7invalid_argument@std@@6B@ 0057 __TI3?AVinvalid_argument@std@@ 0060 __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 83 EC 0C 56 8B F1 8B 4D 08 85 C9 74 2C 8B 46 1C 39 48 08 74 0F 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? EB 34 8B CE E8 ?? ?? ?? ?? 8B 4E 1C 56 E8 ?? ?? ?? ?? 5E C9 C2 04 00 8D 45 08 50 8D 4D F4 C7 45 08 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 F4 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_15_31_0 {
	meta:
		name = "?ResetSubscriptionLevel@VirtualProcessorRoot@details@Concurrency@@QAEXXZ"
		size = 24
		refs = "0012 ?Unsubscribe@VirtualProcessorRoot@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 8D 41 4C 83 CA FF F0 0F C1 10 4A 75 05 E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_16_3_0 {
	meta:
		name = "__towlower_l"
		size = 178
		refs = "001d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0057 _iswctype 008a ___crtLCMapStringW"
	strings:
		$1 = { 55 8B EC B8 FF FF 00 00 83 EC 14 66 39 45 08 0F 84 9B 00 00 00 56 FF 75 0C 8D 4D EC E8 ?? ?? ?? ?? 8B 75 EC 8B 86 A8 00 00 00 85 C0 75 18 8B 4D 08 8D 41 BF 66 83 F8 19 77 04 66 83 C1 20 0F B7 C1 0F B7 C0 EB 1F BA 00 01 00 00 6A 01 66 39 55 08 73 2A FF 75 08 E8 ?? ?? ?? ?? 59 59 85 C0 75 09 0F B7 45 08 0F B7 C0 EB 0E 0F B7 4D 08 8B 86 94 00 00 00 0F B6 04 08 0F B7 C0 EB 1C 8D 4D FC 51 6A 01 8D 4D 08 51 52 50 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 09 0F B7 45 08 0F B7 C0 EB 04 0F B7 45 FC 80 7D F8 00 5E 74 07 8B 4D F4 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_16_4_0 {
	meta:
		name = "_towlower"
		size = 17
		refs = "0009 __towlower_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_34_103_2 {
	meta:
		name = "__Mtx_lock"
		size = 17
		refs = "0009 ?mtx_do_lock@@YAHPAPAU_Mtx_internal_imp_t@@PBUxtime@@@Z"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_705_16_0 {
	meta:
		name = "__cropzeros"
		size = 17
		refs = "0009 __cropzeros_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_705_20_0 {
	meta:
		name = "__forcdecpt"
		size = 17
		refs = "0009 __forcdecpt_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_429_12_0 {
	meta:
		name = "__ismbbkana"
		size = 17
		refs = "0009 __ismbbkana_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_929_3_0 {
	meta:
		name = "__ismbcalnum"
		size = 17
		refs = "0009 __ismbcalnum_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_132_3_0 {
	meta:
		name = "__ismbcalpha"
		size = 17
		refs = "0009 __ismbcalpha_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_792_3_0 {
	meta:
		name = "__ismbcdigit"
		size = 17
		refs = "0009 __ismbcdigit_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_416_3_0 {
	meta:
		name = "__ismbcgraph"
		size = 17
		refs = "0009 __ismbcgraph_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_909_3_0 {
	meta:
		name = "__ismbchira"
		size = 17
		refs = "0009 __ismbchira_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_909_5_0 {
	meta:
		name = "__ismbckata"
		size = 17
		refs = "0009 __ismbckata_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_545_3_0 {
	meta:
		name = "__ismbcl0"
		size = 17
		refs = "0009 __ismbcl0_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_545_5_0 {
	meta:
		name = "__ismbcl1"
		size = 17
		refs = "0009 __ismbcl1_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_545_7_0 {
	meta:
		name = "__ismbcl2"
		size = 17
		refs = "0009 __ismbcl2_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_939_3_0 {
	meta:
		name = "__ismbclegal"
		size = 17
		refs = "0009 __ismbclegal_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_418_3_0 {
	meta:
		name = "__ismbclower"
		size = 17
		refs = "0009 __ismbclower_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_337_3_0 {
	meta:
		name = "__ismbcprint"
		size = 17
		refs = "0009 __ismbcprint_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_658_3_0 {
	meta:
		name = "__ismbcpunct"
		size = 17
		refs = "0009 __ismbcpunct_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_740_3_0 {
	meta:
		name = "__ismbcspace"
		size = 17
		refs = "0009 __ismbcspace_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_909_7_0 {
	meta:
		name = "__ismbcsymbol"
		size = 17
		refs = "0009 __ismbcsymbol_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_927_3_0 {
	meta:
		name = "__ismbcupper"
		size = 17
		refs = "0009 __ismbcupper_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_34_3_0 {
	meta:
		name = "__mbbtombc"
		size = 17
		refs = "0009 __mbbtombc_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_812_3_0 {
	meta:
		name = "__mbcjistojms"
		size = 17
		refs = "0009 __mbcjistojms_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_812_5_0 {
	meta:
		name = "__mbcjmstojis"
		size = 17
		refs = "0009 __mbcjmstojis_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_720_0_0 {
	meta:
		name = "__mbctohira"
		size = 17
		refs = "0009 __mbctohira_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_735_0_0 {
	meta:
		name = "__mbctokata"
		size = 17
		refs = "0009 __mbctokata_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_49_3_0 {
	meta:
		name = "__mbctolower"
		size = 17
		refs = "0009 __mbctolower_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_34_5_0 {
	meta:
		name = "__mbctombb"
		size = 17
		refs = "0009 __mbctombb_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_166_3_0 {
	meta:
		name = "__mbctoupper"
		size = 17
		refs = "0009 __mbctoupper_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_631_3_0 {
	meta:
		name = "__mbslen"
		size = 17
		refs = "0009 __mbslen_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_1166_3_0 {
	meta:
		name = "__mbsnextc"
		size = 17
		refs = "0009 __mbsnextc_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_573_3_0 {
	meta:
		name = "__mbsrev"
		size = 17
		refs = "0009 __mbsrev_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_690_2_0 {
	meta:
		name = "__mkgmtime32"
		size = 17
		refs = "0009 __make__time32_t"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_1172_2_0 {
	meta:
		name = "__mkgmtime64"
		size = 17
		refs = "0009 __make__time64_t"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_458_5_0 {
	meta:
		name = "__wtof"
		size = 17
		refs = "0009 __wtof_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_184_6_0 {
	meta:
		name = "_atof"
		size = 17
		refs = "0009 __atof_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_43_19_0 {
	meta:
		name = "_isleadbyte"
		size = 17
		refs = "0009 __isleadbyte_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_864_4_0 {
	meta:
		name = "_towupper"
		size = 17
		refs = "0009 __towupper_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "__iswctype_l"
		size = 18
		refs = "000a _iswctype"
	strings:
		$1 = { 55 8B EC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_17_2_0 {
	meta:
		name = "_iswctype"
		size = 82
		refs = "0024 __pwctype 003c __imp__GetStringTypeW@16"
	strings:
		$1 = { 55 8B EC 51 66 8B 45 08 B9 FF FF 00 00 66 3B C1 75 04 33 C0 C9 C3 B9 00 01 00 00 66 3B C1 73 0E 0F B7 C8 A1 ?? ?? ?? ?? 0F B7 04 48 EB 1C 8D 45 FC 50 6A 01 8D 45 08 50 6A 01 FF 15 ?? ?? ?? ?? F7 D8 1B C0 23 45 FC 0F B7 C0 0F B7 4D 0C 23 C1 C9 C3 }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "__wputenv"
		size = 73
		refs = "0003 __sehtable$__wputenv 0008 __SEH_prolog4 000f __lock 001e __wputenv_helper 0038 __SEH_epilog4 0043 __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 07 E8 ?? ?? ?? ?? 59 83 65 FC 00 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 8B F0 89 75 E4 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 75 E4 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_492_0_0 {
	meta:
		name = "__putenv"
		size = 73
		refs = "0003 __sehtable$__putenv 0008 __SEH_prolog4 000f __lock 001e __putenv_helper 0038 __SEH_epilog4 0043 __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 07 E8 ?? ?? ?? ?? 59 83 65 FC 00 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 8B F0 89 75 E4 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 75 E4 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_19_1_0 {
	meta:
		name = "__wputenv_helper"
		size = 544
		refs = "000b ___env_initialized 0020 __errno 002b __invalid_parameter_noinfo 0046 _wcschr 006a _wcsnlen 0076 _wcslen 0081 __calloc_crt 0097 _wcscpy_s 012c ___crtwsetenv 014a __environ 0165 __imp__WideCharToMultiByte@32 01bb _strlen 01e2 _free 01fb ___crtsetenv"
	strings:
		$1 = { 55 8B EC 51 51 83 65 F8 00 83 3D ?? ?? ?? ?? 00 75 05 83 C8 FF C9 C3 56 8B 75 08 85 F6 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 E6 01 00 00 53 8B 5D 0C 57 85 DB 75 63 6A 3D 58 50 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 24 8B C8 2B CE 83 E1 FE 81 F9 FE FF 00 00 7D 66 BF FF 7F 00 00 83 C0 02 57 50 E8 ?? ?? ?? ?? 59 59 3B C7 73 51 56 E8 ?? ?? ?? ?? 8D 78 01 6A 02 57 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 85 C0 0F 84 81 01 00 00 56 57 50 E8 ?? ?? ?? ?? 83 C4 0C E9 82 00 00 00 BF FF 7F 00 00 57 56 E8 ?? ?? ?? ?? 57 53 89 45 FC E8 ?? ?? ?? ?? 83 C4 10 39 7D FC 73 04 3B C7 72 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 3A 01 00 00 8B 7D FC 83 C0 02 03 C7 6A 02 50 89 45 FC E8 ?? ?? ?? ?? 59 59 89 45 F8 85 C0 0F 84 1A 01 00 00 56 FF 75 FC 50 E8 ?? ?? ?? ?? 8B 45 F8 6A 3D 59 66 89 0C 78 8B 45 FC 47 2B C7 53 50 8B 45 F8 8D 04 78 50 E8 ?? ?? ?? ?? 83 C4 18 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 12 83 7D F8 00 0F 84 D4 00 00 00 FF 75 F8 E9 C6 00 00 00 83 3D ?? ?? ?? ?? 00 0F 84 C4 00 00 00 33 C0 50 50 50 50 6A FF 56 50 50 89 45 FC FF 15 ?? ?? ?? ?? 8B F8 85 FF 74 78 85 DB 74 18 33 C0 50 50 50 50 6A FF 53 50 50 FF 15 ?? ?? ?? ?? 85 C0 74 5F 47 03 F8 6A 01 57 E8 ?? ?? ?? ?? 59 59 89 45 FC 85 C0 74 78 33 C9 51 51 57 50 6A FF 56 8B 35 ?? ?? ?? ?? 51 51 FF D6 85 C0 74 2B 85 DB 74 3D FF 75 FC E8 ?? ?? ?? ?? 59 8B 4D FC 33 D2 52 52 C6 04 08 3D 40 2B F8 03 45 FC 57 50 6A FF 53 52 52 FF D6 85 C0 75 16 FF 75 FC E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 EB 20 8D 45 FC 6A 00 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 14 83 7D FC 00 74 09 FF 75 FC E8 ?? ?? ?? ?? 59 83 C8 FF EB 02 33 C0 5F 5B 5E C9 C3 }
	condition:
		$1
}

rule file_19_2_0 {
	meta:
		name = "__wputenv_s"
		size = 113
		refs = "0003 __sehtable$__wputenv_s 0008 __SEH_prolog4 0019 __errno 0023 __invalid_parameter_noinfo 002a __SEH_epilog4 0032 __lock 0043 __wputenv_helper 006b __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 39 45 0C 0F 95 C0 85 C0 75 17 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C3 6A 07 E8 ?? ?? ?? ?? 59 33 F6 89 75 FC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 85 C0 74 07 E8 ?? ?? ?? ?? 8B 30 89 75 E4 C7 45 FC FE FF FF FF E8 05 00 00 00 EB C2 8B 75 E4 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_492_2_0 {
	meta:
		name = "__putenv_s"
		size = 113
		refs = "0003 __sehtable$__putenv_s 0008 __SEH_prolog4 0019 __errno 0023 __invalid_parameter_noinfo 002a __SEH_epilog4 0032 __lock 0043 __putenv_helper 006b __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 39 45 0C 0F 95 C0 85 C0 75 17 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C3 6A 07 E8 ?? ?? ?? ?? 59 33 F6 89 75 FC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 85 C0 74 07 E8 ?? ?? ?? ?? 8B 30 89 75 E4 C7 45 FC FE FF FF FF E8 05 00 00 00 EB C2 8B 75 E4 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "__dup"
		size = 235
		refs = "0003 __sehtable$__dup 0008 __SEH_prolog4 001b ___doserrno 0023 __errno 0033 __ioinit 0049 __nhandle 0062 ___pioinfo 0072 ___lock_fhandle 008e __dup_nolock 00c3 __unlock_fhandle 00df __invalid_parameter_noinfo 00e6 __SEH_epilog4"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 CE FF 89 75 E4 8B 7D 08 83 FF FE 75 18 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E9 B1 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 88 A4 00 00 00 85 FF 0F 88 84 00 00 00 3B 3D ?? ?? ?? ?? 73 7C 8B C7 C1 F8 05 89 45 E0 8B DF 83 E3 1F C1 E3 06 8B 04 85 ?? ?? ?? ?? 0F BE 44 18 04 83 E0 01 74 5B 57 E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 45 E0 8B 04 85 ?? ?? ?? ?? F6 44 18 04 01 74 0B 57 E8 ?? ?? ?? ?? 59 8B F0 EB 13 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 20 00 89 75 E4 C7 45 FC FE FF FF FF E8 08 00 00 00 EB 28 8B 7D 08 8B 75 E4 57 E8 ?? ?? ?? ?? 59 C3 EB 18 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_20_1_0 {
	meta:
		name = "__dup_nolock"
		size = 364
		refs = "0003 __sehtable$__dup_nolock 0008 __SEH_prolog4 0029 ___pioinfo 0041 __alloc_osfhnd 0050 __errno 005b ___doserrno 0071 __imp__GetCurrentProcess@0 007c __get_osfhandle 0087 __imp__DuplicateHandle@28 0091 __imp__GetLastError@0 009c __set_osfhnd 00aa __dosmaperr 013c __SEH_epilog4 0166 __unlock_fhandle"
	strings:
		$1 = { 6A 20 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D DC 8B 45 08 C1 F8 05 89 45 E0 8B 4D 08 83 E1 1F C1 E1 06 89 4D D4 8B 04 85 ?? ?? ?? ?? 8A 44 08 04 88 45 E7 A8 01 75 08 83 C8 FF E9 FB 00 00 00 E8 ?? ?? ?? ?? 8B F8 89 7D D0 83 FF FF 75 14 E8 ?? ?? ?? ?? C7 00 18 00 00 00 E8 ?? ?? ?? ?? 89 18 EB D5 89 5D FC 6A 02 6A 01 53 8D 45 D8 50 8B 35 ?? ?? ?? ?? FF D6 50 FF 75 08 E8 ?? ?? ?? ?? 59 50 FF D6 50 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 0D FF 75 D8 57 E8 ?? ?? ?? ?? 59 59 8B C3 85 C0 74 09 50 E8 ?? ?? ?? ?? 59 EB 75 8B D7 C1 FA 05 8B F7 83 E6 1F C1 E6 06 0F BE 4D E7 80 E1 EF 8B 04 95 ?? ?? ?? ?? 88 4C 30 04 8B 0C 95 ?? ?? ?? ?? 8B 45 E0 8B 04 85 ?? ?? ?? ?? 8B 5D D4 8A 44 18 24 32 44 31 24 24 7F 30 44 31 24 8B 14 95 ?? ?? ?? ?? 8B 45 E0 8B 04 85 ?? ?? ?? ?? 8A 4C 18 24 32 4C 32 24 80 E1 7F 8B 45 E0 8B 04 85 ?? ?? ?? ?? 32 4C 18 24 88 4C 32 24 33 DB 43 89 5D DC C7 45 FC FE FF FF FF E8 15 00 00 00 85 DB 75 03 83 CF FF 8B C7 E8 ?? ?? ?? ?? C3 8B 5D DC 8B 7D D0 85 DB 75 19 8B C7 C1 F8 05 8B CF 83 E1 1F C1 E1 06 8B 04 85 ?? ?? ?? ?? 80 64 08 04 FE 57 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_21_3_0 {
	meta:
		name = "??8type_info@@QBE_NABV0@@Z"
		size = 30
		refs = "000f _strcmp"
	strings:
		$1 = { 55 8B EC 8D 41 09 50 8B 45 08 83 C0 09 50 E8 ?? ?? ?? ?? F7 D8 59 1B C0 59 40 5D C2 04 00 }
	condition:
		$1
}

rule file_21_4_0 {
	meta:
		name = "??9type_info@@QBE_NABV0@@Z"
		size = 31
		refs = "000f _strcmp"
	strings:
		$1 = { 55 8B EC 8D 41 09 50 8B 45 08 83 C0 09 50 E8 ?? ?? ?? ?? F7 D8 59 1B C0 59 F7 D8 5D C2 04 00 }
	condition:
		$1
}

rule file_21_6_0 {
	meta:
		name = "?_name_internal_method@type_info@@QBEPBDPAU__type_info_node@@@Z"
		size = 18
		refs = "0008 ?_Name_base_internal@type_info@@CAPBDPBV1@PAU__type_info_node@@@Z"
	strings:
		$1 = { 55 8B EC FF 75 08 51 E8 ?? ?? ?? ?? 59 59 5D C2 04 00 }
	condition:
		$1
}

rule file_21_9_0 {
	meta:
		name = "?name@type_info@@QBEPBDPAU__type_info_node@@@Z"
		size = 18
		refs = "0008 ?_Name_base@type_info@@CAPBDPBV1@PAU__type_info_node@@@Z"
	strings:
		$1 = { 55 8B EC FF 75 08 51 E8 ?? ?? ?? ?? 59 59 5D C2 04 00 }
	condition:
		$1
}

rule file_21_8_0 {
	meta:
		name = "?before@type_info@@QBE_NABV1@@Z"
		size = 32
		refs = "000f _strcmp"
	strings:
		$1 = { 55 8B EC 8D 41 09 50 8B 45 08 83 C0 09 50 E8 ?? ?? ?? ?? 59 59 33 C9 85 C0 0F 9F C0 5D C2 04 00 }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "__CIcos_pentium4"
		size = 428
		refs = "0039 PI32INV 0045 SHIFTER 0055 P_1 0061 P_2 007e SC_4 0084 Ctable 0099 P_3 00be SC_2 0103 SC_3 010f SC_1 018e ONE 01a5 __cos_default"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 04 24 E8 08 00 00 00 C9 C3 66 0F 12 44 24 04 66 0F C5 C0 03 66 25 FF 7F 66 2D 30 30 66 3D C5 10 0F 87 42 01 00 00 66 0F 12 0D ?? ?? ?? ?? F2 0F 59 C8 66 0F 12 15 ?? ?? ?? ?? F2 0F 2D D1 F2 0F 58 CA 66 0F 12 1D ?? ?? ?? ?? F2 0F 5C CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 D9 66 0F 14 C9 81 C2 10 76 1C 00 F2 0F 10 E0 83 E2 3F 66 0F 28 2D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 05 03 C2 66 0F 59 D1 F2 0F 5C C3 F2 0F 59 0D ?? ?? ?? ?? F2 0F 5C E3 66 0F 12 78 08 66 0F 14 C0 F2 0F 10 DC F2 0F 5C E2 66 0F 59 E8 66 0F 5C C2 66 0F 28 35 ?? ?? ?? ?? F2 0F 59 FC F2 0F 5C DC 66 0F 59 E8 66 0F 59 C0 F2 0F 5C DA 66 0F 28 10 F2 0F 5C CB 66 0F 12 58 18 F2 0F 58 D3 F2 0F 5C FA F2 0F 59 D4 66 0F 59 F0 F2 0F 59 DC 66 0F 59 D0 66 0F 59 C0 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 20 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 E8 F2 0F 10 C3 F2 0F 58 58 08 F2 0F 59 CF F2 0F 10 FC F2 0F 58 E3 66 0F 58 F5 66 0F 12 68 08 F2 0F 5C EB F2 0F 5C DC F2 0F 58 48 10 66 0F 59 F2 F2 0F 58 E8 F2 0F 58 DF F2 0F 58 CD F2 0F 58 CB F2 0F 58 CE 66 0F 15 F6 F2 0F 58 CE 83 EC 10 F2 0F 58 E1 66 0F 13 64 24 04 DD 44 24 04 83 C4 10 C3 7F 2B 66 0F C5 C0 03 66 25 FF 7F 66 0F C4 C0 03 83 EC 10 66 0F 12 0D ?? ?? ?? ?? F2 0F 5C C8 66 0F 13 4C 24 04 DD 44 24 04 83 C4 10 C3 E9 ?? ?? ?? ?? 8D 49 00 }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "__cwait"
		size = 140
		refs = "0018 __imp__WaitForSingleObject@8 0027 __imp__GetExitCodeProcess@8 0035 __imp__GetLastError@0 003f __errno 004a ___doserrno 005e __dosmaperr 0069 __imp__CloseHandle@4"
	strings:
		$1 = { 55 8B EC 56 8B 75 0C 57 83 CF FF 3B F7 74 6C 83 FE FE 74 67 57 56 FF 15 ?? ?? ?? ?? 85 C0 75 13 8D 45 0C 50 56 FF 15 ?? ?? ?? ?? 85 C0 74 04 8B FE EB 33 FF 15 ?? ?? ?? ?? 83 F8 06 75 18 E8 ?? ?? ?? ?? C7 00 0A 00 00 00 E8 ?? ?? ?? ?? C7 00 06 00 00 00 EB 0D FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 89 7D 0C 56 FF 15 ?? ?? ?? ?? 8B 45 08 85 C0 74 12 8B 4D 0C 89 08 EB 0B E8 ?? ?? ?? ?? C7 00 0A 00 00 00 8B C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "___time64_t_from_ft"
		size = 124
		refs = "0007 ___security_cookie 0025 __imp__FileTimeToSystemTime@8 0039 __imp__SystemTimeToTzSpecificLocalTime@12 0062 ___loctotime64_t 0076 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 24 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 83 38 00 75 06 83 78 04 00 74 4D 8D 4D DC 51 50 FF 15 ?? ?? ?? ?? 85 C0 74 3E 8D 45 EC 50 8D 45 DC 50 6A 00 FF 15 ?? ?? ?? ?? 85 C0 74 2A 0F B7 45 F8 6A FF 50 0F B7 45 F6 50 0F B7 45 F4 50 0F B7 45 F2 50 0F B7 45 EE 50 0F B7 45 EC 50 E8 ?? ?? ?? ?? 83 C4 1C EB 05 83 C8 FF 0B D0 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_28_1_0 {
	meta:
		name = "__findfirst64i32"
		size = 293
		refs = "000a ___security_cookie 001f __errno 002a __invalid_parameter_noinfo 0049 __imp__FindFirstFileExA@24 0056 __imp__GetLastError@0 0087 @__security_check_cookie@4 00c0 ___time64_t_from_ft 0108 _strcpy_s 0120 __invoke_watson"
	strings:
		$1 = { 55 8B EC 81 EC 44 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 0C 85 F6 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 4D 85 C0 74 E7 53 57 33 DB 53 53 53 8D 8D BC FE FF FF 51 53 50 FF 15 ?? ?? ?? ?? 8B F8 83 FF FF 75 4F FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 34 83 F8 08 74 22 83 F8 12 74 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 5F 5B 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? C9 C3 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB E1 E8 ?? ?? ?? ?? 89 30 EB D8 8B 85 BC FE FF FF 83 C0 80 F7 D8 1B C0 23 85 BC FE FF FF 89 06 8D 85 C0 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 C8 FE FF FF 50 89 56 0C E8 ?? ?? ?? ?? 89 46 10 8D 85 D0 FE FF FF 50 89 56 14 E8 ?? ?? ?? ?? 89 46 18 8B 85 DC FE FF FF 89 46 20 8D 85 E8 FE FF FF 50 8D 46 24 68 04 01 00 00 50 89 56 1C E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 07 8B C7 E9 64 FF FF FF 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_28_2_0 {
	meta:
		name = "__findnext64i32"
		size = 277
		refs = "000a ___security_cookie 0020 __errno 002b __invalid_parameter_noinfo 0039 @__security_check_cookie@4 004d __imp__FindNextFileA@8 0057 __imp__GetLastError@0 00b1 ___time64_t_from_ft 00f9 _strcpy_s 0110 __invoke_watson"
	strings:
		$1 = { 55 8B EC 81 EC 44 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 4D 08 56 8B 75 0C 83 F9 FF 75 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? C9 C3 85 F6 74 DC 8D 85 BC FE FF FF 50 51 FF 15 ?? ?? ?? ?? 85 C0 75 3F FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 24 83 F8 08 74 12 83 F8 12 74 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB B1 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB A4 E8 ?? ?? ?? ?? 89 30 EB 9B 8B 85 BC FE FF FF 83 C0 80 F7 D8 1B C0 23 85 BC FE FF FF 89 06 8D 85 C0 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 C8 FE FF FF 50 89 56 0C E8 ?? ?? ?? ?? 89 46 10 8D 85 D0 FE FF FF 50 89 56 14 E8 ?? ?? ?? ?? 89 46 18 8B 85 DC FE FF FF 89 46 20 8D 85 E8 FE FF FF 50 8D 46 24 68 04 01 00 00 50 89 56 1C E8 ?? ?? ?? ?? 83 C4 18 85 C0 0F 84 2A FF FF FF 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_30_2_0 {
	meta:
		name = "?_set_new_handler@@YAP6AHI@ZP6AHI@Z@Z"
		size = 53
		refs = "0007 __lock 000e ?_pnhHeap@@3P6AHI@ZA 0014 __imp__DecodePointer@4 001f __imp__EncodePointer@4 002b __unlock"
	strings:
		$1 = { 55 8B EC 56 6A 04 E8 ?? ?? ?? ?? 59 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF 75 08 8B F0 FF 15 ?? ?? ?? ?? 6A 04 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_30_3_0 {
	meta:
		name = "__callnewh"
		size = 38
		refs = "0005 ?_pnhHeap@@3P6AHI@ZA 000b __imp__DecodePointer@4"
	strings:
		$1 = { 55 8B EC FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 0F FF 75 08 FF D0 59 85 C0 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "___sse4_sin2"
		size = 800
		refs = "0008 _MMDPI1 0014 _MMDINVPI 0020 _MMIABSMASK 0028 _MMDPI2 0030 _MMDPI3 003e _MMDRSHIFT 0046 _MMDHUGE 005a _MMDPI4 008f _MMDA8 0097 _MMDA7 00b3 _MMDA6 00bb _MMDA5 00cb _MMDA4 00d3 _MMDA3 00e3 _MMDA2 00eb _MMDA1 011a _MMISIGNMASK 0134 _TWO_POW_30 0162 _THE_PI02_INV 0177 _MMI_ONE 017f _MSK_LOW_BIT 0187 _RS 019b _PI02C_0 01a7 _PI02C_1 01b7 _PI02C_2 01e8 _PI02C_3 0214 _PI02C_4 02c5 ___common_sin_reduction_LA"
	strings:
		$1 = { 66 0F 28 F8 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 D0 66 0F 59 05 ?? ?? ?? ?? 66 0F 28 D8 66 0F 54 3D ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 3A 09 C0 00 66 0F 58 1D ?? ?? ?? ?? 66 0F 66 3D ?? ?? ?? ?? 66 0F 50 C7 0B C0 0F 85 B2 00 00 00 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E0 66 0F 59 E8 66 0F 59 F0 66 0F 59 F8 66 0F 73 F3 3F 66 0F 5C D4 66 0F 5C D5 66 0F 5C D6 66 0F 28 CA 66 0F 59 D2 66 0F 5C CF 66 0F 28 05 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 E2 66 0F 59 E4 66 0F 59 D1 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F D0 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F2 66 0F 59 C1 66 0F 58 F1 66 0F 58 C6 66 0F 57 C3 C3 8B D4 81 EC 00 01 00 00 83 E4 F0 89 14 24 66 0F 28 3D ?? ?? ?? ?? 66 0F 54 FA 66 0F 29 54 24 10 66 0F 54 15 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F C2 CA 02 66 0F 50 D1 66 0F 29 7C 24 30 66 0F 29 54 24 20 83 F8 03 0F 85 F0 00 00 00 85 D2 0F 85 35 01 00 00 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 DA 66 0F E6 DB 66 0F 70 DB 10 66 0F FE 1D ?? ?? ?? ?? 66 0F DB 1D ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 56 C3 66 0F 5C 05 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 C8 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E0 66 0F 5C D1 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 E8 66 0F 28 CA 66 0F 5C D4 66 0F 5C CA 66 0F 28 F2 66 0F 5C CC 66 0F 5C D5 66 0F 73 F3 3E 66 0F 5C F2 66 0F 28 FA 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 CE 66 0F 58 D1 66 0F 59 E0 66 0F 5C FA 66 0F 28 EA 66 0F 5C D4 66 0F 58 CF 66 0F 5C EA 66 0F 59 05 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 CD 66 0F 5C C8 66 0F DB 1D ?? ?? ?? ?? 66 0F 58 D1 66 0F 28 CA 66 0F 59 D2 66 0F 57 5C 24 30 8B 24 24 E9 45 FE FF FF 66 0F 28 54 24 10 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E0 66 0F 59 E8 66 0F 59 F0 66 0F 59 F8 66 0F 73 F3 3F 66 0F 5C D4 66 0F 5C D5 66 0F 5C D6 66 0F 28 CA 66 0F 59 D2 66 0F 5C CF 66 0F 29 5C 24 60 66 0F 29 4C 24 40 66 0F 29 54 24 50 89 5C 24 04 8B D8 89 7C 24 0C 89 74 24 08 83 EC 10 BE 00 00 00 00 F7 C3 01 00 00 00 74 36 8D 7C F4 50 F3 0F 7E 44 F4 30 66 0F D6 04 24 89 7C 24 08 E8 ?? ?? ?? ?? F3 0F 7E 44 F4 50 33 44 F4 44 89 44 F4 74 33 C0 89 44 F4 70 F2 0F 59 C0 66 0F D6 44 F4 60 83 C6 01 D1 EB 83 FE 02 7C B8 83 C4 10 66 0F 28 54 24 50 66 0F 28 4C 24 40 66 0F 28 5C 24 60 8B 5C 24 04 8B 74 24 08 8B 7C 24 0C 8B 24 24 E9 71 FD FF FF 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "___libm_sse2_log10"
		size = 574
		refs = "0024 _emask 002c _CC 0034 _One 003c _Magic 0044 _hi_mask 0062 _CB_Tbl 006a _T_Tbl 00cc _coeff 00f8 _LOG10_2 0104 _place_LR 015e _Zero 01b2 _Infs 01e1 _Two52"
	strings:
		$1 = { 83 EC 0C BA 00 00 00 00 66 0F 13 44 24 04 66 0F 28 E8 66 0F 14 C0 66 0F 73 D5 34 66 0F C5 CD 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C3 66 0F 58 E0 66 0F C5 C4 00 25 F0 07 00 00 66 0F 28 A0 ?? ?? ?? ?? 66 0F 28 B8 ?? ?? ?? ?? 66 0F 54 F0 66 0F 5C C6 66 0F 59 F4 66 0F 5C F2 F2 0F 58 FE 66 0F 59 C4 66 0F 28 E0 66 0F 58 C6 81 E1 FF 0F 00 00 83 E9 01 81 F9 FD 07 00 00 0F 87 B1 00 00 00 81 E9 FE 03 00 00 03 CA F2 0F 2A F1 66 0F 14 F6 C1 E1 0A 03 C1 B9 10 00 00 00 BA 00 00 00 00 83 F8 00 0F 44 D1 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 D8 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 C8 66 0F 59 DB 66 0F 58 CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 DB 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 F5 66 0F 28 AA ?? ?? ?? ?? 66 0F 54 E5 66 0F 58 FE 66 0F 58 FC 66 0F 59 C8 F2 0F 59 D8 66 0F 58 CA 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 D0 66 0F 28 F7 66 0F 15 F6 66 0F 59 CB 66 0F 28 C1 66 0F 58 CA 66 0F 15 C0 83 C4 0C F2 0F 58 C1 F2 0F 58 C6 F2 0F 58 C7 C3 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? F2 0F C2 C8 00 66 0F C5 C1 00 83 F8 00 77 54 83 F9 FF 74 67 81 F9 FE 07 00 00 77 75 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C2 F2 0F C2 D0 00 66 0F C5 C2 00 83 F8 00 74 0C 83 C4 0C 66 0F 12 05 ?? ?? ?? ?? C3 66 0F 12 44 24 04 83 C4 0C F2 0F 58 C0 C3 83 C4 0C 66 0F 12 15 ?? ?? ?? ?? F2 0F 5E D0 66 0F 12 05 ?? ?? ?? ?? C3 66 0F 12 0D ?? ?? ?? ?? F2 0F 59 C1 BA CC FF FF FF E9 1B FE FF FF 83 C1 01 81 E1 FF 07 00 00 81 F9 FF 07 00 00 73 0C 83 C4 0C 66 0F 57 C0 F2 0F 5E C0 C3 66 0F 12 54 24 04 66 0F 12 44 24 04 66 0F 7E D0 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF 0F 00 0B C1 83 F8 00 74 CE 83 C4 0C F2 0F 58 C0 C3 }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "??0?$_SpinWait@$00@details@Concurrency@@QAE@P6AXXZ@Z"
		size = 19
		altNames = "??0?$_SpinWait@$0A@@details@Concurrency@@QAE@P6AXXZ@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 61 08 00 89 41 0C 8B C1 5D C2 04 00 }
	condition:
		$1
}

rule file_33_2_0 {
	meta:
		name = "??0ThreadProxy@details@Concurrency@@QAE@PAUIThreadProxyFactory@12@I@Z"
		size = 229
		refs = "001b ??_7ThreadProxy@details@Concurrency@@6B@ 0037 ?s_threadProxyIdCount@ResourceManager@details@Concurrency@@0JC 0049 __imp__CreateEventW@16 0056 __imp__GetLastError@0 006e ?ThreadProxyMain@ThreadProxy@details@Concurrency@@CGKPAX@Z 0078 ?LoadLibraryAndCreateThread@details@Concurrency@@YAPAXPAU_SECURITY_ATTRIBUTES@@KP6GKPAX@Z1KPAK@Z 008b __imp__CloseHandle@4 00ae ??0scheduler_worker_creation_error@Concurrency@@QAE@J@Z 00b3 __TI3?AVscheduler_worker_creation_error@Concurrency@@ 00d2 ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 00d7 __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 00e0 __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 EC 20 53 56 57 8B F9 33 DB 89 47 04 8B 45 0C 8B 4F 04 C7 07 ?? ?? ?? ?? 89 47 14 89 5F 18 88 5F 1C 33 F6 46 89 77 20 89 5F 24 8B 01 FF 50 08 B8 ?? ?? ?? ?? F0 0F C1 30 46 53 53 53 53 89 77 28 FF 15 ?? ?? ?? ?? 89 47 0C 85 C0 75 0C FF 15 ?? ?? ?? ?? 85 C0 7E 6F EB 65 8D 47 2C 50 8B 47 14 68 00 00 01 00 57 68 ?? ?? ?? ?? C1 E0 0A 50 53 E8 ?? ?? ?? ?? 83 C4 18 89 47 08 85 C0 75 36 FF 77 0C FF 15 ?? ?? ?? ?? 8B 4F 04 8B 01 FF 50 0C FF 15 ?? ?? ?? ?? 85 C0 7E 08 0F B7 C0 0D 00 00 07 80 50 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 EB 22 8B C7 5F 5E 5B C9 C2 08 00 0F B7 C0 0D 00 00 07 80 50 8D 4D F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_33_3_0 {
	meta:
		name = "??0scheduler_resource_allocation_error@Concurrency@@QAE@ABV01@@Z"
		size = 36
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7scheduler_resource_allocation_error@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 57 56 8B F9 E8 ?? ?? ?? ?? C7 07 ?? ?? ?? ?? 8B 46 0C 89 47 0C 8B C7 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_69_44_1 {
	meta:
		name = "??0regex_error@std@@QAE@ABV01@@Z"
		size = 36
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7regex_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 57 56 8B F9 E8 ?? ?? ?? ?? C7 07 ?? ?? ?? ?? 8B 46 0C 89 47 0C 8B C7 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_33_6_0 {
	meta:
		name = "??1ThreadProxy@details@Concurrency@@UAE@XZ"
		size = 36
		refs = "0008 ??_7ThreadProxy@details@Concurrency@@6B@ 000e __imp__CloseHandle@4"
	strings:
		$1 = { 57 8B F9 FF 77 0C C7 07 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF 77 08 FF 15 ?? ?? ?? ?? 8B 4F 04 5F 8B 01 FF 60 0C }
	condition:
		$1
}

rule file_33_14_0 {
	meta:
		name = "?Cancel@ThreadProxy@details@Concurrency@@QAEXXZ"
		size = 17
		refs = "000c __imp__SetEvent@4"
	strings:
		$1 = { FF 71 0C C7 41 24 01 00 00 00 FF 15 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_33_18_0 {
	meta:
		name = "?SetPriority@ThreadProxy@details@Concurrency@@QAEXH@Z"
		size = 74
		refs = "0012 __imp__SetThreadPriority@8 001c __imp__GetLastError@0 0037 ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 003c __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 0045 __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 EC 10 89 41 18 50 FF 71 08 FF 15 ?? ?? ?? ?? 85 C0 75 0C FF 15 ?? ?? ?? ?? 85 C0 7E 0E EB 04 C9 C2 04 00 0F B7 C0 0D 00 00 07 80 50 8D 4D F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_33_19_0 {
	meta:
		name = "?SpinUntilBlocked@ThreadProxy@details@Concurrency@@QAEXXZ"
		size = 43
		refs = "0016 ?_Sleep0@details@Concurrency@@YAXXZ 001e ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 55 8B EC 83 EC 10 56 8B F1 83 7E 20 00 75 19 83 65 F8 00 C7 45 FC ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 83 7E 20 00 74 F2 5E C9 C3 }
	condition:
		$1
}

rule file_33_20_0 {
	meta:
		name = "?SuspendExecution@ThreadProxy@details@Concurrency@@QAEXXZ"
		size = 26
		refs = "0010 __imp__WaitForSingleObject@8"
	strings:
		$1 = { 33 C0 56 8D 71 20 40 87 06 6A FF FF 71 0C FF 15 ?? ?? ?? ?? 33 C0 87 06 5E C3 }
	condition:
		$1
}

rule file_33_21_0 {
	meta:
		name = "?ThreadProxyMain@ThreadProxy@details@Concurrency@@CGKPAX@Z"
		size = 56
		refs = "000e __imp__WaitForSingleObject@8 002c ?FreeLibraryAndDestroyThread@details@Concurrency@@YAXK@Z"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 6A FF FF 76 0C FF 15 ?? ?? ?? ?? 33 D2 8D 46 20 87 10 8B 06 8B CE FF 50 14 8B 06 6A 01 8B CE FF 50 10 6A 00 E8 ?? ?? ?? ?? 59 33 C0 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_33_24_0 {
	meta:
		name = "?_Reset@?$_SpinWait@$00@details@Concurrency@@IAEXXZ"
		size = 22
		refs = "0008 ?_Value@_SpinCount@details@Concurrency@@SAIXZ 0010 ?_SetSpinCount@?$_SpinWait@$00@details@Concurrency@@QAEXI@Z"
	strings:
		$1 = { 56 8B F1 83 66 08 00 E8 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_553_232_0 {
	meta:
		name = "?_Reset@?$_SpinWait@$0A@@details@Concurrency@@IAEXXZ"
		size = 22
		refs = "0008 ?_Value@_SpinCount@details@Concurrency@@SAIXZ 0010 ?_SetSpinCount@?$_SpinWait@$0A@@details@Concurrency@@QAEXI@Z"
	strings:
		$1 = { 56 8B F1 83 66 08 00 E8 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_33_25_0 {
	meta:
		name = "?_SetSpinCount@?$_SpinWait@$00@details@Concurrency@@QAEXI@Z"
		size = 34
	strings:
		$1 = { 55 8B EC 8B 45 08 85 C0 75 09 C7 41 08 04 00 00 00 EB 0B 89 01 33 C0 40 89 41 04 89 41 08 5D C2 04 00 }
	condition:
		$1
}

rule file_33_27_0 {
	meta:
		name = "?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
		size = 110
		refs = "0011 ?_Value@_SpinCount@details@Concurrency@@SAIXZ 0019 ?_SetSpinCount@?$_SpinWait@$00@details@Concurrency@@QAEXI@Z"
	strings:
		$1 = { 53 56 8B F1 33 DB 8B 46 08 2B C3 75 12 89 5E 08 E8 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? EB E7 48 74 34 48 74 1C 48 74 05 48 74 24 EB 10 89 5E 08 E8 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? 32 C0 EB 2A FF 4E 04 75 07 C7 46 08 03 00 00 00 B3 01 FF 56 0C 8A C3 EB 15 F3 90 FF 0E 75 0D 8B 46 04 F7 D8 1B C0 83 C0 03 89 46 08 B0 01 5E 5B C3 }
	condition:
		$1
}

rule file_33_28_0 {
	meta:
		name = "_HRESULT_FROM_WIN32"
		size = 20
	strings:
		$1 = { 55 8B EC 8B 45 08 85 C0 7E 08 0F B7 C0 0D 00 00 07 80 5D C3 }
	condition:
		$1
}

rule file_34_4_0 {
	meta:
		name = "__mbbtombc_l"
		size = 131
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002c _mbbtable 004d _mbctable"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F4 8B 55 08 81 78 04 A4 03 00 00 75 52 8D 42 E0 83 F8 5E 77 0A 0F B7 14 55 ?? ?? ?? ?? EB 40 81 FA DC 00 00 00 75 07 BA 8F 83 00 00 EB 31 8D 82 5F FF FF FF 83 F8 3E 77 26 A0 ?? ?? ?? ?? 33 C9 EB 0F 0F B6 C0 3B D0 74 0E 8A 04 8D ?? ?? ?? ?? 41 84 C0 75 ED EB 08 0F B7 14 8D ?? ?? ?? ?? 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD 8B C2 C9 C3 }
	condition:
		$1
}

rule file_34_6_0 {
	meta:
		name = "__mbctombb_l"
		size = 161
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002a _mbbtable 0042 _mbctable"
	strings:
		$1 = { 55 8B EC 83 EC 10 57 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F4 8B 55 08 81 78 04 A4 03 00 00 75 6E 33 C9 56 8B F1 0F B7 04 75 ?? ?? ?? ?? 3B D0 74 59 46 83 FE 5E 7E EE 81 FA 96 83 00 00 77 4E 38 0D ?? ?? ?? ?? 74 46 8B C1 0F B7 B8 ?? ?? ?? ?? 8B F2 2B F7 74 2A 33 FA F7 C7 00 FF 00 00 75 0F 85 F6 7E 0B 0F BE 80 ?? ?? ?? ?? 2B F0 78 11 41 8B C1 C1 E0 02 80 B8 ?? ?? ?? ?? 00 75 CB EB 0D 0F B6 14 8D ?? ?? ?? ?? EB 03 8D 56 20 5E 80 7D FC 00 5F 74 07 8B 4D F8 83 61 70 FD 8B C2 C9 C3 }
	condition:
		$1
}

rule file_35_1_0 {
	meta:
		name = "___tmainCRTStartup"
		size = 324
		refs = "0003 __sehtable$___tmainCRTStartup 0008 __SEH_prolog4 000d ___crtGetShowWindowMode 0017 ___set_app_type 0024 ___ImageBase 0065 __heap_init 0070 _fast_error_exit 0076 __mtinit 0087 __RTC_Initialize 0090 __ioinit0 0096 __imp__GetCommandLineA@0 009b __acmdln 00a0 ___crtGetEnvironmentStringsA 00a5 __aenvptr 00aa __setargv 00b5 __amsg_exit 00bb __setenvp 00ce __cinit 00df __wincmdln 00ed _WinMain@16 00fc _exit 0101 __cexit 0114 __XcptFilter 012c __exit 0131 __c_exit 013f __SEH_epilog4"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B7 F0 6A 02 E8 ?? ?? ?? ?? 59 B8 4D 5A 00 00 66 39 05 ?? ?? ?? ?? 74 04 33 DB EB 33 A1 ?? ?? ?? ?? 81 B8 ?? ?? ?? ?? 50 45 00 00 75 EB B9 0B 01 00 00 66 39 88 ?? ?? ?? ?? 75 DD 33 DB 83 B8 ?? ?? ?? ?? 0E 76 09 39 98 ?? ?? ?? ?? 0F 95 C3 89 5D E4 E8 ?? ?? ?? ?? 85 C0 75 08 6A 1C E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 85 C0 75 08 6A 10 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 83 65 FC 00 E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 79 08 6A 08 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 85 C0 79 08 6A 09 E8 ?? ?? ?? ?? 59 6A 01 E8 ?? ?? ?? ?? 59 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 56 50 6A 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 75 DC 85 DB 75 06 56 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 2E 8B 4D EC 8B 01 8B 00 89 45 E0 51 50 E8 ?? ?? ?? ?? 59 59 C3 8B 65 E8 8B 75 E0 89 75 DC 83 7D E4 00 75 06 56 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B C6 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_904_0_0 {
	meta:
		name = "___tmainCRTStartup"
		size = 324
		refs = "0003 __sehtable$___tmainCRTStartup 0008 __SEH_prolog4 000d ___crtGetShowWindowMode 0017 ___set_app_type 0024 ___ImageBase 0065 __heap_init 0070 _fast_error_exit 0076 __mtinit 0087 __RTC_Initialize 0090 __ioinit0 0096 __imp__GetCommandLineW@0 009b __wcmdln 00a0 ___crtGetEnvironmentStringsW 00a5 __wenvptr 00aa __wsetargv 00b5 __amsg_exit 00bb __wsetenvp 00ce __cinit 00df __wwincmdln 00ed _wWinMain@16 00fc _exit 0101 __cexit 0114 __XcptFilter 012c __exit 0131 __c_exit 013f __SEH_epilog4"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B7 F0 6A 02 E8 ?? ?? ?? ?? 59 B8 4D 5A 00 00 66 39 05 ?? ?? ?? ?? 74 04 33 DB EB 33 A1 ?? ?? ?? ?? 81 B8 ?? ?? ?? ?? 50 45 00 00 75 EB B9 0B 01 00 00 66 39 88 ?? ?? ?? ?? 75 DD 33 DB 83 B8 ?? ?? ?? ?? 0E 76 09 39 98 ?? ?? ?? ?? 0F 95 C3 89 5D E4 E8 ?? ?? ?? ?? 85 C0 75 08 6A 1C E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 85 C0 75 08 6A 10 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 83 65 FC 00 E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 79 08 6A 08 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 85 C0 79 08 6A 09 E8 ?? ?? ?? ?? 59 6A 01 E8 ?? ?? ?? ?? 59 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 56 50 6A 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 75 DC 85 DB 75 06 56 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 2E 8B 4D EC 8B 01 8B 00 89 45 E0 51 50 E8 ?? ?? ?? ?? 59 59 C3 8B 65 E8 8B 75 E0 89 75 DC 83 7D E4 00 75 06 56 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B C6 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_35_2_0 {
	meta:
		name = "_check_managed_app"
		size = 70
		refs = "0008 ___ImageBase"
	strings:
		$1 = { B8 4D 5A 00 00 66 39 05 ?? ?? ?? ?? 74 03 33 C0 C3 8B 0D ?? ?? ?? ?? 81 B9 ?? ?? ?? ?? 50 45 00 00 75 EB B8 0B 01 00 00 66 39 81 ?? ?? ?? ?? 75 DD 33 C0 83 B9 ?? ?? ?? ?? 0E 76 09 39 81 ?? ?? ?? ?? 0F 95 C0 C3 }
	condition:
		$1
}

rule file_35_3_0 {
	meta:
		name = "_fast_error_exit"
		size = 39
		refs = "0005 ___error_mode 000d __FF_MSGBANNER 0015 __NMSG_WRITE 001f ___crtExitProcess"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 01 75 05 E8 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 68 FF 00 00 00 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_36_0_0 {
	meta:
		name = "__putch"
		size = 70
		refs = "0003 __sehtable$__putch 0008 __SEH_prolog4 000f __lock 001c __putch_nolock 0035 __SEH_epilog4 0040 __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 03 E8 ?? ?? ?? ?? 59 83 65 FC 00 FF 75 08 E8 ?? ?? ?? ?? 59 8B F0 89 75 E4 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 75 E4 6A 03 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_173_9_0 {
	meta:
		name = "__ungetch"
		size = 70
		refs = "0003 __sehtable$__ungetch 0008 __SEH_prolog4 000f __lock 001c __ungetch_nolock 0035 __SEH_epilog4 0040 __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 03 E8 ?? ?? ?? ?? 59 83 65 FC 00 FF 75 08 E8 ?? ?? ?? ?? 59 8B F0 89 75 E4 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 75 E4 6A 03 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_36_1_0 {
	meta:
		name = "__putch_nolock"
		size = 122
		refs = "0008 __getptd 0030 _isleadbyte 004a _mbtowc 005a __putwch_nolock"
	strings:
		$1 = { 55 8B EC 51 53 56 57 E8 ?? ?? ?? ?? 8B 5D 08 8B F0 33 C0 40 8D 7E 4C 66 39 46 52 75 05 88 5F 01 EB 02 88 1F 66 83 7E 52 00 75 13 0F B6 07 50 E8 ?? ?? ?? ?? 59 85 C0 74 05 33 C0 40 EB 30 0F B7 46 52 40 50 8D 45 FC 57 50 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 74 13 FF 75 FC E8 ?? ?? ?? ?? 59 B9 FF FF 00 00 66 3B C1 75 03 80 CB FF 33 C0 5F 66 89 46 52 5E 0F B6 C3 5B C9 C3 }
	condition:
		$1
}

rule file_37_0_0 {
	meta:
		name = "__snscanf"
		size = 33
		refs = "0013 __input_l 0018 _vscan_fn"
	strings:
		$1 = { 55 8B EC 8D 45 14 50 6A 00 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_37_2_0 {
	meta:
		name = "__snscanf_s"
		size = 33
		refs = "0013 __input_s_l 0018 _vscan_fn"
	strings:
		$1 = { 55 8B EC 8D 45 14 50 6A 00 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_488_0_0 {
	meta:
		name = "__snwscanf"
		size = 33
		refs = "0013 __winput_l 0018 _vscan_fn"
	strings:
		$1 = { 55 8B EC 8D 45 14 50 6A 00 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_488_2_0 {
	meta:
		name = "__snwscanf_s"
		size = 33
		refs = "0013 __winput_s_l 0018 _vscan_fn"
	strings:
		$1 = { 55 8B EC 8D 45 14 50 6A 00 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_37_1_0 {
	meta:
		name = "__snscanf_l"
		size = 34
		refs = "0014 __input_l 0019 _vscan_fn"
	strings:
		$1 = { 55 8B EC 8D 45 18 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_37_3_0 {
	meta:
		name = "__snscanf_s_l"
		size = 34
		refs = "0014 __input_s_l 0019 _vscan_fn"
	strings:
		$1 = { 55 8B EC 8D 45 18 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_488_1_0 {
	meta:
		name = "__snwscanf_l"
		size = 34
		refs = "0014 __winput_l 0019 _vscan_fn"
	strings:
		$1 = { 55 8B EC 8D 45 18 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_488_3_0 {
	meta:
		name = "__snwscanf_s_l"
		size = 34
		refs = "0014 __winput_s_l 0019 _vscan_fn"
	strings:
		$1 = { 55 8B EC 8D 45 18 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_37_4_0 {
	meta:
		name = "_vscan_fn"
		size = 108
		refs = "001e __errno 0029 __invalid_parameter_noinfo"
	strings:
		$1 = { 55 8B EC 83 EC 20 83 65 E0 00 57 6A 07 33 C0 59 8D 7D E4 F3 AB 8B 45 0C 5F 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF C9 C3 83 7D 14 00 74 E5 89 45 E8 89 45 E0 8B 45 10 B9 FF FF FF 7F C7 45 EC 49 00 00 00 89 4D E4 3B C1 77 03 89 45 E4 FF 75 1C 8D 45 E0 FF 75 18 FF 75 14 50 FF 55 08 83 C4 10 C9 C3 }
	condition:
		$1
}

rule file_39_4_0 {
	meta:
		name = "_vfwscanf"
		size = 125
		refs = "0003 __sehtable$_vfwscanf 0008 __SEH_prolog4 001b __errno 0026 __invalid_parameter_noinfo 003d __lock_file 006a __SEH_epilog4 0077 __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 75 0C 85 F6 0F 95 C0 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 3A 33 C0 39 45 10 0F 95 C0 85 C0 74 DF 56 E8 ?? ?? ?? ?? 59 83 65 FC 00 FF 75 18 FF 75 14 FF 75 10 56 FF 55 08 83 C4 10 8B F8 89 7D E4 C7 45 FC FE FF FF FF E8 0E 00 00 00 8B C7 E8 ?? ?? ?? ?? C3 8B 75 0C 8B 7D E4 56 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "___crtMessageBoxW"
		size = 482
		refs = "0007 ___security_cookie 0016 __imp__EncodePointer@4 0030 ___crtIsPackagedApp 0039 ?pfnMessageBox@?1??__crtMessageBoxW@@9@9 004a ??_C@_1BG@GOEBHBDC@?$AAU?$AAS?$AAE?$AAR?$AA3?$AA2?$AA?4?$AAD?$AAL?$AAL?$AA?$AA@ 0050 __imp__LoadLibraryExW@12 005c __imp__GetLastError@0 0070 __imp__LoadLibraryW@4 007f ??_C@_0M@DLDCCGNP@MessageBoxW?$AA@ 0086 __imp__GetProcAddress@8 0096 ??_C@_0BA@HNOPNCHB@GetActiveWindow?$AA@ 00aa ??_C@_0BD@HHGDFDBJ@GetLastActivePopup?$AA@ 00b0 ?pfnGetActiveWindow@?1??__crtMessageBoxW@@9@9 00be ??_C@_0BK@DEKFELLI@GetUserObjectInformationW?$AA@ 00c4 ?pfnGetLastActivePopup@?1??__crtMessageBoxW@@9@9 00d2 ?pfnGetUserObjectInformation@?1??__crtMessageBoxW@@9@9 00db ??_C@_0BI@DFKBFLJE@GetProcessWindowStation?$AA@ 00ea ?pfnGetProcessWindowStation@?1??__crtMessageBoxW@@9@9 00f3 __imp__IsDebuggerPresent@0 0105 __imp__OutputDebugStringW@4 0123 __imp__DecodePointer@4 01dc @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 24 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 53 8B 1D ?? ?? ?? ?? 56 57 89 45 E4 8B 45 0C 33 FF 57 89 45 E0 FF D3 8B F0 89 75 E8 E8 ?? ?? ?? ?? 89 45 EC 39 3D ?? ?? ?? ?? 0F 85 AE 00 00 00 68 00 08 00 00 57 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F0 85 F6 75 24 FF 15 ?? ?? ?? ?? 83 F8 57 0F 85 68 01 00 00 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F0 85 F6 0F 84 53 01 00 00 68 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 85 C0 0F 84 3F 01 00 00 50 FF D3 68 ?? ?? ?? ?? 56 A3 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 FF D3 68 ?? ?? ?? ?? 56 A3 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 FF D3 68 ?? ?? ?? ?? 56 A3 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 FF D3 A3 ?? ?? ?? ?? 85 C0 74 14 68 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 50 FF D3 A3 ?? ?? ?? ?? 8B 75 E8 FF 15 ?? ?? ?? ?? 85 C0 74 1B 8B 45 E4 85 C0 74 07 50 FF 15 ?? ?? ?? ?? 39 7D EC 74 1D 6A 04 58 E9 BD 00 00 00 39 7D EC 74 10 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 6A 03 EB E5 A1 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 3B C6 74 4F 39 35 ?? ?? ?? ?? 74 47 50 FF D3 FF 35 ?? ?? ?? ?? 89 45 EC FF D3 8B 4D EC 89 45 E8 85 C9 74 2F 85 C0 74 2B FF D1 85 C0 74 1A 8D 4D DC 51 6A 0C 8D 4D F0 51 6A 01 50 FF 55 E8 85 C0 74 06 F6 45 F8 01 75 0B 8B 75 10 81 CE 00 00 20 00 EB 30 A1 ?? ?? ?? ?? 3B C6 74 24 50 FF D3 85 C0 74 1D FF D0 8B F8 85 FF 74 15 A1 ?? ?? ?? ?? 3B C6 74 0C 50 FF D3 85 C0 74 05 57 FF D0 8B F8 8B 75 10 FF 35 ?? ?? ?? ?? FF D3 85 C0 74 0C 56 FF 75 E0 FF 75 E4 57 FF D0 EB 02 33 C0 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_1032_0_0 {
	meta:
		name = "___crtMessageBoxA"
		size = 482
		refs = "0007 ___security_cookie 0016 __imp__EncodePointer@4 0030 ___crtIsPackagedApp 0039 ?pfnMessageBox@?1??__crtMessageBoxA@@9@9 004a ??_C@_1BG@GOEBHBDC@?$AAU?$AAS?$AAE?$AAR?$AA3?$AA2?$AA?4?$AAD?$AAL?$AAL?$AA?$AA@ 0050 __imp__LoadLibraryExW@12 005c __imp__GetLastError@0 0070 __imp__LoadLibraryW@4 007f ??_C@_0M@CHKKJDAI@MessageBoxA?$AA@ 0086 __imp__GetProcAddress@8 0096 ??_C@_0BA@HNOPNCHB@GetActiveWindow?$AA@ 00aa ??_C@_0BD@HHGDFDBJ@GetLastActivePopup?$AA@ 00b0 ?pfnGetActiveWindow@?1??__crtMessageBoxA@@9@9 00be ??_C@_0BK@CIDNPOGP@GetUserObjectInformationA?$AA@ 00c4 ?pfnGetLastActivePopup@?1??__crtMessageBoxA@@9@9 00d2 ?pfnGetUserObjectInformation@?1??__crtMessageBoxA@@9@9 00db ??_C@_0BI@DFKBFLJE@GetProcessWindowStation?$AA@ 00ea ?pfnGetProcessWindowStation@?1??__crtMessageBoxA@@9@9 00f3 __imp__IsDebuggerPresent@0 0105 __imp__OutputDebugStringA@4 0123 __imp__DecodePointer@4 01dc @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 24 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 53 8B 1D ?? ?? ?? ?? 56 57 89 45 E4 8B 45 0C 33 FF 57 89 45 E0 FF D3 8B F0 89 75 E8 E8 ?? ?? ?? ?? 89 45 EC 39 3D ?? ?? ?? ?? 0F 85 AE 00 00 00 68 00 08 00 00 57 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F0 85 F6 75 24 FF 15 ?? ?? ?? ?? 83 F8 57 0F 85 68 01 00 00 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F0 85 F6 0F 84 53 01 00 00 68 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 85 C0 0F 84 3F 01 00 00 50 FF D3 68 ?? ?? ?? ?? 56 A3 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 FF D3 68 ?? ?? ?? ?? 56 A3 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 FF D3 68 ?? ?? ?? ?? 56 A3 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 FF D3 A3 ?? ?? ?? ?? 85 C0 74 14 68 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 50 FF D3 A3 ?? ?? ?? ?? 8B 75 E8 FF 15 ?? ?? ?? ?? 85 C0 74 1B 8B 45 E4 85 C0 74 07 50 FF 15 ?? ?? ?? ?? 39 7D EC 74 1D 6A 04 58 E9 BD 00 00 00 39 7D EC 74 10 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 6A 03 EB E5 A1 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 3B C6 74 4F 39 35 ?? ?? ?? ?? 74 47 50 FF D3 FF 35 ?? ?? ?? ?? 89 45 EC FF D3 8B 4D EC 89 45 E8 85 C9 74 2F 85 C0 74 2B FF D1 85 C0 74 1A 8D 4D DC 51 6A 0C 8D 4D F0 51 6A 01 50 FF 55 E8 85 C0 74 06 F6 45 F8 01 75 0B 8B 75 10 81 CE 00 00 20 00 EB 30 A1 ?? ?? ?? ?? 3B C6 74 24 50 FF D3 85 C0 74 1D FF D0 8B F8 85 FF 74 15 A1 ?? ?? ?? ?? 3B C6 74 0C 50 FF D3 85 C0 74 05 57 FF D0 8B F8 8B 75 10 FF 35 ?? ?? ?? ?? FF D3 85 C0 74 0C 56 FF 75 E0 FF 75 E4 57 FF D0 EB 02 33 C0 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_40_1_0 {
	meta:
		name = "___crtMessageBoxWaitThreadW@4"
		size = 30
		altNames = "___crtMessageBoxWaitThreadA@4"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 FF 76 0C FF 76 08 FF 76 04 6A 00 FF 16 89 46 10 33 C0 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_41_0_0 {
	meta:
		name = "__wexeclpe"
		size = 79
		refs = "000b __errno 0016 __invalid_parameter_noinfo 0046 __wexecvpe"
	strings:
		$1 = { 55 8B EC 8B 55 08 85 D2 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 33 C9 66 39 0A 74 E4 8B 45 0C 85 C0 74 DD 66 39 08 74 D8 8D 4D 0C 8B 01 8D 49 04 85 C0 75 F7 FF 31 8D 45 0C 50 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "___dyn_tls_init@12"
		size = 47
		refs = "000c ___xd_a 0011 ___xd_z"
	strings:
		$1 = { 55 8B EC 83 7D 0C 02 75 1F 56 57 BE ?? ?? ?? ?? BF ?? ?? ?? ?? EB 0B 8B 06 85 C0 74 02 FF D0 83 C6 04 3B F7 75 F1 5F 5E 33 C0 40 5D C2 0C 00 }
	condition:
		$1
}

rule file_43_3_0 {
	meta:
		name = "___iswcsym"
		size = 36
		refs = "000c _iswctype"
		altNames = "__iswcsym_l"
	strings:
		$1 = { 55 8B EC 68 07 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 85 C0 75 09 66 83 7D 08 5F 74 02 5D C3 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_43_4_0 {
	meta:
		name = "___iswcsymf"
		size = 36
		refs = "000c _iswctype"
		altNames = "__iswcsymf_l"
	strings:
		$1 = { 55 8B EC 68 03 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 85 C0 75 09 66 83 7D 08 5F 74 02 5D C3 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_43_5_0 {
	meta:
		name = "__isleadbyte_l"
		size = 54
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F0 0F B6 4D 08 8B 80 90 00 00 00 0F B7 04 48 25 00 80 00 00 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_43_6_0 {
	meta:
		name = "__iswalnum_l"
		size = 20
		refs = "000c _iswctype"
		altNames = "_iswalnum"
	strings:
		$1 = { 55 8B EC 68 07 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_43_7_0 {
	meta:
		name = "__iswalpha_l"
		size = 20
		refs = "000c _iswctype"
		altNames = "_iswalpha"
	strings:
		$1 = { 55 8B EC 68 03 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_43_8_0 {
	meta:
		name = "__iswcntrl_l"
		size = 17
		refs = "0009 _iswctype"
		altNames = "_iswcntrl"
	strings:
		$1 = { 55 8B EC 6A 20 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_43_11_0 {
	meta:
		name = "__iswdigit_l"
		size = 17
		refs = "0009 _iswctype"
		altNames = "_iswdigit"
	strings:
		$1 = { 55 8B EC 6A 04 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_43_12_0 {
	meta:
		name = "__iswgraph_l"
		size = 20
		refs = "000c _iswctype"
		altNames = "_iswgraph"
	strings:
		$1 = { 55 8B EC 68 17 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_43_13_0 {
	meta:
		name = "__iswlower_l"
		size = 17
		refs = "0009 _iswctype"
		altNames = "_iswlower"
	strings:
		$1 = { 55 8B EC 6A 02 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_43_14_0 {
	meta:
		name = "__iswprint_l"
		size = 20
		refs = "000c _iswctype"
		altNames = "_iswprint"
	strings:
		$1 = { 55 8B EC 68 57 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_43_15_0 {
	meta:
		name = "__iswpunct_l"
		size = 17
		refs = "0009 _iswctype"
		altNames = "_iswpunct"
	strings:
		$1 = { 55 8B EC 6A 10 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_455_7_0 {
	meta:
		name = "_tmpfile_s"
		size = 17
		refs = "0009 __tmpfile_helper"
	strings:
		$1 = { 55 8B EC 6A 10 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_43_16_0 {
	meta:
		name = "__iswspace_l"
		size = 17
		refs = "0009 _iswctype"
		altNames = "_iswspace"
	strings:
		$1 = { 55 8B EC 6A 08 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_43_17_0 {
	meta:
		name = "__iswupper_l"
		size = 17
		refs = "0009 _iswctype"
		altNames = "_iswupper"
	strings:
		$1 = { 55 8B EC 6A 01 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_690_3_0 {
	meta:
		name = "__mktime32"
		size = 17
		refs = "0009 __make__time32_t"
	strings:
		$1 = { 55 8B EC 6A 01 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_1172_3_0 {
	meta:
		name = "__mktime64"
		size = 17
		refs = "0009 __make__time64_t"
	strings:
		$1 = { 55 8B EC 6A 01 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_43_18_0 {
	meta:
		name = "__iswxdigit_l"
		size = 20
		refs = "000c _iswctype"
		altNames = "_iswxdigit"
	strings:
		$1 = { 55 8B EC 68 80 00 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_43_22_0 {
	meta:
		name = "_iswascii"
		size = 18
	strings:
		$1 = { 55 8B EC B8 80 00 00 00 66 39 45 08 1B C0 F7 D8 5D C3 }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "__vsnwprintf_s"
		size = 30
		refs = "0015 __vsnwprintf_s_l"
	strings:
		$1 = { 55 8B EC FF 75 18 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_404_11_0 {
	meta:
		name = "__strftime_l"
		size = 30
		refs = "0015 __Strftime_l"
	strings:
		$1 = { 55 8B EC FF 75 18 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_169_3_0 {
	meta:
		name = "__vsnprintf_s"
		size = 30
		refs = "0015 __vsnprintf_s_l"
	strings:
		$1 = { 55 8B EC FF 75 18 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_295_19_0 {
	meta:
		name = "__wcsftime_l"
		size = 30
		refs = "0015 __Wcsftime_l"
	strings:
		$1 = { 55 8B EC FF 75 18 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_44_1_0 {
	meta:
		name = "__vsnwprintf_s_l"
		size = 255
		refs = "000b __errno 0016 __invalid_parameter_noinfo 006d __woutput_s_l 0072 __vswprintf_helper"
	strings:
		$1 = { 55 8B EC 51 83 7D 14 00 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF C9 C3 53 56 8B 75 08 57 8B 7D 10 85 FF 75 14 85 F6 75 18 39 75 0C 0F 85 AE 00 00 00 33 C0 E9 BA 00 00 00 85 F6 0F 84 9F 00 00 00 8B 5D 0C 85 DB 0F 84 94 00 00 00 E8 ?? ?? ?? ?? FF 75 1C FF 75 18 FF 75 14 3B DF 76 2C 8B 18 8D 47 01 50 56 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 83 F8 FE 75 4E E8 ?? ?? ?? ?? 83 38 22 75 6F E8 ?? ?? ?? ?? 89 18 EB 66 8B 00 53 56 68 ?? ?? ?? ?? 89 45 FC E8 ?? ?? ?? ?? 33 C9 83 C4 18 66 89 4C 5E FE 83 F8 FE 75 1B 83 FF FF 75 1A E8 ?? ?? ?? ?? 83 38 22 75 37 E8 ?? ?? ?? ?? 8B 4D FC 89 08 EB 2B 85 C0 79 2A 33 C9 66 89 0E 83 F8 FE 75 1D E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 0B E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_44_2_0 {
	meta:
		name = "__vswprintf_c"
		size = 39
		refs = "0012 __woutput_l 0017 __vswprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 85 C0 79 03 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_169_0_0 {
	meta:
		name = "__vsnprintf_c"
		size = 39
		refs = "0012 __output_l 0017 __vsnprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 85 C0 79 03 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_169_5_0 {
	meta:
		name = "__vsprintf_p"
		size = 39
		refs = "0012 __output_p_l 0017 __vsnprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 85 C0 79 03 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_44_5_0 {
	meta:
		name = "__vswprintf_p"
		size = 39
		refs = "0012 __woutput_p_l 0017 __vswprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 85 C0 79 03 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_44_3_0 {
	meta:
		name = "__vswprintf_c_l"
		size = 40
		refs = "0013 __woutput_l 0018 __vswprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 85 C0 79 03 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_169_1_0 {
	meta:
		name = "__vsnprintf_c_l"
		size = 40
		refs = "0013 __output_l 0018 __vsnprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 85 C0 79 03 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_169_6_0 {
	meta:
		name = "__vsprintf_p_l"
		size = 40
		refs = "0013 __output_p_l 0018 __vsnprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 85 C0 79 03 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_44_6_0 {
	meta:
		name = "__vswprintf_p_l"
		size = 40
		refs = "0013 __woutput_p_l 0018 __vswprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 85 C0 79 03 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_44_4_0 {
	meta:
		name = "__vswprintf_helper"
		size = 249
		refs = "001b __errno 0026 __invalid_parameter_noinfo 00b6 __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 20 83 65 E0 00 57 6A 07 33 C0 59 8D 7D E4 F3 AB 39 45 14 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 C4 00 00 00 8B 7D 10 56 8B 75 0C 85 FF 74 1C 85 F6 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 9C 00 00 00 C7 45 EC 42 00 00 00 89 75 E8 89 75 E0 81 FF FF FF FF 3F 76 09 C7 45 E4 FF FF FF 7F EB 06 8D 04 3F 89 45 E4 53 FF 75 1C 8D 45 E0 FF 75 18 FF 75 14 50 FF 55 08 83 C4 10 8B D8 85 F6 74 5D 85 DB 78 49 FF 4D E4 78 0F 8B 45 E0 C6 00 00 8B 45 E0 40 89 45 E0 EB 15 8D 45 E0 50 6A 00 E8 ?? ?? ?? ?? 59 59 83 F8 FF 74 23 8B 45 E0 FF 4D E4 78 05 C6 00 00 EB 12 8D 45 E0 50 6A 00 E8 ?? ?? ?? ?? 59 59 83 F8 FF 74 04 8B C3 EB 10 33 C0 39 45 E4 66 89 44 7E FE 0F 9D C0 83 E8 02 5B 5E 5F C9 C3 }
	condition:
		$1
}

rule file_44_7_0 {
	meta:
		name = "__vswprintf_s_l"
		size = 119
		refs = "000a __errno 0015 __invalid_parameter_noinfo 003a __woutput_s_l 003f __vswprintf_helper"
	strings:
		$1 = { 55 8B EC 83 7D 10 00 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 56 8B 75 08 85 F6 74 3B 83 7D 0C 00 76 35 FF 75 18 FF 75 14 FF 75 10 FF 75 0C 56 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 85 C0 79 05 33 C9 66 89 0E 83 F8 FE 75 20 E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 0B E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5E 5D C3 }
	condition:
		$1
}

rule file_44_8_0 {
	meta:
		name = "_vswprintf_s"
		size = 27
		refs = "0012 __vswprintf_s_l"
	strings:
		$1 = { 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_879_2_0 {
	meta:
		name = "?vswprintf@@YAHPAGIPBGPAD@Z"
		size = 27
		refs = "0012 ?_vswprintf_l@@YAHPA_WIPB_WPAUlocaleinfo_struct@@PAD@Z"
	strings:
		$1 = { 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_879_3_0 {
	meta:
		name = "?vswprintf@@YAHPA_WIPB_WPAD@Z"
		size = 27
		refs = "0012 ?_vswprintf_l@@YAHPA_WIPB_WPAUlocaleinfo_struct@@PAD@Z"
	strings:
		$1 = { 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_1152_0_0 {
	meta:
		name = "__vsnprintf"
		size = 27
		refs = "0012 __vsnprintf_l"
	strings:
		$1 = { 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_409_0_0 {
	meta:
		name = "__vsnwprintf"
		size = 27
		refs = "0012 __vsnwprintf_l"
	strings:
		$1 = { 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_169_8_0 {
	meta:
		name = "_vsprintf_s"
		size = 27
		refs = "0012 __vsprintf_s_l"
	strings:
		$1 = { 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "___IsPackagedAppHelper"
		size = 57
		refs = "0009 ??_C@_0BE@JOGNEJCI@GetCurrentPackageId?$AA@ 000e ??_C@_1BK@MGMFAEKH@?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA3?$AA2?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 0014 __imp__GetModuleHandleW@4 001b __imp__GetProcAddress@8"
	strings:
		$1 = { 55 8B EC 51 83 65 FC 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 12 6A 00 8D 4D FC 51 FF D0 83 F8 7A 75 05 33 C0 40 C9 C3 33 C0 C9 C3 }
	condition:
		$1
}

rule file_45_4_0 {
	meta:
		name = "___crtFlsSetValue"
		size = 17
		refs = "000b __imp__FlsSetValue@8"
	strings:
		$1 = { 55 8B EC FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_1047_5_0 {
	meta:
		name = "___crtGetUserDefaultLocaleName"
		size = 17
		refs = "000b __imp__GetUserDefaultLocaleName@8"
	strings:
		$1 = { 55 8B EC FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_308_0_0 {
	meta:
		name = "__beep"
		size = 17
		refs = "000b __imp__Beep@8"
	strings:
		$1 = { 55 8B EC FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_45_5_0 {
	meta:
		name = "___crtGetShowWindowMode"
		size = 33
		refs = "000c __imp__GetStartupInfoW@4"
	strings:
		$1 = { 55 8B EC 83 EC 44 8D 45 BC 50 FF 15 ?? ?? ?? ?? F6 45 E8 01 74 06 0F B7 45 EC C9 C3 6A 0A 58 C9 C3 }
	condition:
		$1
}

rule file_45_6_0 {
	meta:
		name = "___crtIsPackagedApp"
		size = 76
		refs = "0007 ?isPackaged@?1??__crtIsPackagedApp@@9@9 0010 ??_C@_0BE@JOGNEJCI@GetCurrentPackageId?$AA@ 0017 ??_C@_1BK@MGMFAEKH@?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA3?$AA2?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 0020 __imp__GetModuleHandleW@4 0027 __imp__GetProcAddress@8"
	strings:
		$1 = { 55 8B EC 51 56 8B 35 ?? ?? ?? ?? 85 F6 79 33 68 ?? ?? ?? ?? 33 F6 68 ?? ?? ?? ?? 89 75 FC FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 0D 56 8D 4D FC 51 FF D0 83 F8 7A 75 01 46 89 35 ?? ?? ?? ?? 33 C0 85 F6 0F 9F C0 5E C9 C3 }
	condition:
		$1
}

rule file_45_8_0 {
	meta:
		name = "___crtTerminateProcess"
		size = 21
		refs = "0008 __imp__GetCurrentProcess@0 000f __imp__TerminateProcess@8"
	strings:
		$1 = { 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_45_9_0 {
	meta:
		name = "___crtUnhandledException"
		size = 22
		refs = "0007 __imp__SetUnhandledExceptionFilter@4 0010 __imp__UnhandledExceptionFilter@4"
	strings:
		$1 = { 55 8B EC 6A 00 FF 15 ?? ?? ?? ?? FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "??_M@YGXPAXIHP6EX0@Z@Z"
		size = 111
		refs = "0003 __sehtable$??_M@YGXPAXIHP6EX0@Z@Z 0008 __SEH_prolog4 004c __SEH_epilog4 006a ?__ArrayUnwind@@YGXPAXIHP6EX0@Z@Z"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 E4 00 8B 5D 0C 8B C3 8B 7D 10 0F AF C7 8B 75 08 03 F0 89 75 08 83 65 FC 00 4F 89 7D 10 78 0C 2B F3 89 75 08 8B CE FF 55 14 EB EE 33 C0 40 89 45 E4 C7 45 FC FE FF FF FF E8 14 00 00 00 E8 ?? ?? ?? ?? C2 10 00 8B 7D 10 8B 5D 0C 8B 75 08 8B 45 E4 85 C0 75 0B FF 75 14 57 53 56 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_47_1_0 {
	meta:
		name = "?ArrayUnwindFilter@@YAHPAU_EXCEPTION_POINTERS@@@Z"
		size = 25
		refs = "0015 ?terminate@@YAXXZ"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 00 81 38 63 73 6D E0 74 04 33 C0 5D C3 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_47_2_0 {
	meta:
		name = "?__ArrayUnwind@@YGXPAXIHP6EX0@Z@Z"
		size = 94
		refs = "0003 __sehtable$?__ArrayUnwind@@YGXPAXIHP6EX0@Z@Z 0008 __SEH_prolog4 0048 ?terminate@@YAXXZ 0057 __SEH_epilog4"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 FC 00 FF 4D 10 78 3A 8B 4D 08 2B 4D 0C 89 4D 08 FF 55 14 EB ED 8B 45 EC 89 45 E4 8B 45 E4 8B 00 89 45 E0 8B 45 E0 81 38 63 73 6D E0 74 0B C7 45 DC 00 00 00 00 8B 45 DC C3 E8 ?? ?? ?? ?? 8B 65 E8 C7 45 FC FE FF FF FF E8 ?? ?? ?? ?? C2 10 00 }
	condition:
		$1
}

rule file_49_4_0 {
	meta:
		name = "__mbctolower_l"
		size = 149
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0056 ___crtLCMapStringA"
	strings:
		$1 = { 55 8B EC 83 EC 18 8D 4D E8 53 FF 75 0C E8 ?? ?? ?? ?? 8B 5D 08 81 FB FF 00 00 00 76 54 8B 4D EC 8B C3 C1 E8 08 88 45 FC 0F B6 C0 88 5D FD F6 44 08 19 04 74 4E 6A 01 FF 71 04 8D 45 F8 6A 02 50 6A 02 8D 45 FC 50 68 00 01 00 00 FF B1 1C 02 00 00 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 24 85 C0 74 22 8B 45 F8 0F B6 D8 0F B6 C4 C1 E3 08 03 D8 EB 12 8B 45 EC F6 44 18 19 10 74 08 0F B6 9C 18 19 01 00 00 80 7D F4 00 74 07 8B 4D F0 83 61 70 FD 8B C3 5B C9 C3 }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "___common_dlog_cout_rare"
		size = 704
		refs = "003a __imldLnHATab 0063 _2il0floatpacket_70 0248 _2il0floatpacket_71"
	strings:
		$1 = { 55 8B EC 83 E4 F8 83 EC 18 8B 45 08 0F B7 48 06 8B D1 81 E2 F0 7F 00 00 81 FA F0 7F 00 00 0F 84 3C 02 00 00 F2 0F 10 20 F7 C1 F0 7F 00 00 F2 0F 11 64 24 10 75 15 F2 0F 59 25 ?? ?? ?? ?? BA C4 FF FF FF F2 0F 11 64 24 10 EB 02 33 D2 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F E0 0F 86 C2 01 00 00 F2 0F 10 05 ?? ?? ?? ?? 0F 28 D4 F2 0F 5C D0 F2 0F 11 54 24 08 80 64 24 0F 7F F2 0F 10 4C 24 08 66 0F 2F 0D ?? ?? ?? ?? 0F 86 2B 01 00 00 F2 0F 11 64 24 08 0F B7 4C 24 0E 81 E1 0F 80 FF FF 81 C9 F0 3F FF FF 66 89 4C 24 0E F2 0F 10 74 24 08 0F 28 E6 0F 28 EE 0F B7 44 24 16 25 F0 7F 00 00 F2 0F 58 25 ?? ?? ?? ?? F2 0F 58 2D ?? ?? ?? ?? C1 E8 04 F2 0F 11 24 24 F2 0F 10 3D ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 8B 4D 0C 8D 94 02 01 FC FF FF 8B 04 24 F2 0F 11 2C 24 83 E0 7F F2 0F 10 24 24 F2 0F 2A DA F2 0F 5C 25 ?? ?? ?? ?? F2 0F 59 D3 F2 0F 5C F4 F2 0F 59 1D ?? ?? ?? ?? 8D 14 40 33 C0 F2 0F 10 0C D5 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 58 1C D5 ?? ?? ?? ?? F2 0F 58 14 D5 ?? ?? ?? ?? F2 0F 59 CE F2 0F 5C E0 0F 28 C4 F2 0F 58 E2 F2 0F 58 C1 F2 0F 58 CB F2 0F 59 F8 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 59 F8 F2 0F 58 CF F2 0F 58 E1 F2 0F 11 21 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C2 8B 45 0C F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 59 C2 F2 0F 58 D0 F2 0F 11 10 33 C0 8B E5 5D C3 66 0F 2E E0 7A 02 74 14 F2 0F 5E C0 8B 45 0C F2 0F 11 00 B8 01 00 00 00 8B E5 5D C3 F2 0F 10 0D ?? ?? ?? ?? 0F 57 0D ?? ?? ?? ?? F2 0F 5E C8 8B 45 0C F2 0F 11 08 B8 02 00 00 00 8B E5 5D C3 0F B6 50 07 81 E2 80 00 00 00 81 FA 80 00 00 00 74 15 F2 0F 10 00 F2 0F 59 C0 8B 45 0C F2 0F 11 00 33 C0 8B E5 5D C3 F7 40 04 FF FF 0F 00 75 E2 83 38 00 75 DD F2 0F 10 05 ?? ?? ?? ?? F2 0F 5E C0 8B 45 0C F2 0F 11 00 B8 01 00 00 00 8B E5 5D C3 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_52_3_0 {
	meta:
		name = "__memicmp"
		size = 96
		refs = "0005 ___locale_changed 001a __errno 0025 __invalid_parameter_noinfo 0042 ___ascii_memicmp 0057 __memicmp_l"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 75 3F 83 7D 08 00 8B 45 10 75 1B 85 C0 74 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F 5D C3 83 7D 0C 00 75 04 85 C0 75 DF 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_52_4_0 {
	meta:
		name = "__memicmp_l"
		size = 169
		refs = "0015 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0030 __errno 003b __invalid_parameter_noinfo 0055 ___ascii_memicmp 0074 __tolower_l"
	strings:
		$1 = { 55 8B EC 83 EC 14 8D 4D EC 53 8B 5D 0C 56 57 FF 75 14 33 F6 E8 ?? ?? ?? ?? 8B 4D 08 8B 7D 10 85 C9 75 04 85 FF 75 08 85 DB 75 1B 85 FF 74 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? BE FF FF FF 7F EB 4F 8B 45 EC 39 B0 A8 00 00 00 75 0F 57 53 51 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 EB 35 8B C6 85 FF 74 2D 4F 3B F0 75 28 0F B6 01 8D 4D EC 51 50 E8 ?? ?? ?? ?? FF 45 08 8B F0 0F B6 03 8D 4D EC 51 50 E8 ?? ?? ?? ?? 8B 4D 08 83 C4 10 43 EB CF 2B F0 80 7D F8 00 74 07 8B 4D F4 83 61 70 FD 5F 8B C6 5E 5B C9 C3 }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "??$sign@I@details@Concurrency@@YAII@Z"
		size = 24
	strings:
		$1 = { 55 8B EC 8B 45 08 85 C0 75 02 5D C3 33 C9 3B C8 1B C0 83 E0 02 48 5D C3 }
	condition:
		$1
}

rule file_55_1_0 {
	meta:
		name = "??$sign@N@details@Concurrency@@YANN@Z"
		size = 54
	strings:
		$1 = { 55 8B EC DD 45 08 D9 EE DD E1 DF E0 F6 C4 44 7A 04 DD D9 5D C3 DE D9 DF E0 F6 C4 05 7A 09 C7 45 0C 01 00 00 00 EB 04 83 4D 0C FF DB 45 0C DD 5D 08 DD 45 08 5D C3 }
	condition:
		$1
}

rule file_55_2_0 {
	meta:
		name = "??0HillClimbing@details@Concurrency@@QAE@IIPAVSchedulerProxy@12@@Z"
		size = 138
		refs = "0073 __real@41f0000000000000"
	strings:
		$1 = { 55 8B EC D9 EE 56 6A 3F 5A 8D 41 08 33 F6 DD 50 F8 89 70 08 DD 10 89 70 0C 89 70 10 83 C0 20 4A 79 EC 8B 45 10 DD D8 DB 45 0C 89 81 00 08 00 00 8B 45 08 89 81 1C 08 00 00 8B 45 0C 89 B1 14 08 00 00 89 B1 18 08 00 00 89 B1 20 08 00 00 89 B1 24 08 00 00 89 B1 28 08 00 00 89 B1 2C 08 00 00 89 B1 30 08 00 00 C6 81 34 08 00 00 01 85 C0 79 06 DC 05 ?? ?? ?? ?? 89 81 10 08 00 00 DD 99 08 08 00 00 8B C1 5E 5D C2 0C 00 }
	condition:
		$1
}

rule file_55_3_0 {
	meta:
		name = "??0MeasuredHistory@HillClimbing@details@Concurrency@@QAE@XZ"
		size = 21
	strings:
		$1 = { D9 EE 33 C0 DD 11 89 41 10 89 41 14 DD 59 08 89 41 18 8B C1 C3 }
	condition:
		$1
}

rule file_55_7_0 {
	meta:
		name = "?Add@MeasuredHistory@HillClimbing@details@Concurrency@@QAEXNI@Z"
		size = 35
	strings:
		$1 = { 55 8B EC DD 01 8B 45 10 DD 45 08 FF 41 10 DC C1 89 41 18 D9 C9 DD 19 DC C8 DC 41 08 DD 59 08 5D C2 0C 00 }
	condition:
		$1
}

rule file_55_8_0 {
	meta:
		name = "?CalculateThroughput@HillClimbing@details@Concurrency@@AAENIIII@Z"
		size = 59
		refs = "0011 __real@41f0000000000000 0020 __real@4024000000000000"
	strings:
		$1 = { 55 8B EC 51 51 8B 45 0C DB 45 0C 85 C0 79 06 DC 05 ?? ?? ?? ?? 8B 45 08 DD 5D F8 DD 45 F8 DC 0D ?? ?? ?? ?? DB 45 08 85 C0 79 06 DC 05 ?? ?? ?? ?? DD 5D F8 DC 75 F8 C9 C2 10 00 }
	condition:
		$1
}

rule file_55_9_0 {
	meta:
		name = "?CalculateThroughputSlope@HillClimbing@details@Concurrency@@AAENHH@Z"
		size = 184
		refs = "000f ?GetHistory@HillClimbing@details@Concurrency@@AAEPAVMeasuredHistory@123@I@Z 0025 ?Mean@MeasuredHistory@HillClimbing@details@Concurrency@@QAENXZ 005f __real@3fc3333333333333 0086 ?Variance@MeasuredHistory@HillClimbing@details@Concurrency@@QAENXZ 009e __CIsqrt 00aa __CIexp"
	strings:
		$1 = { 55 8B EC 83 EC 20 53 56 57 FF 75 08 8B F9 E8 ?? ?? ?? ?? 8B 5D 0C 53 8B CF 8B F0 E8 ?? ?? ?? ?? 8B CE 8B F8 E8 ?? ?? ?? ?? DD 5D F8 8B CF E8 ?? ?? ?? ?? DD 45 F8 2B 5D 08 DC E9 D9 C9 89 5D 0C DD 55 E8 D9 C0 DE F2 DB 45 0C DD 5D F8 DD 45 F8 DB 45 08 DD 5D F8 DC 75 F8 DE FA D9 C9 DC 25 ?? ?? ?? ?? DD 5D E0 D9 E1 D9 EE D8 D1 DF E0 DD D9 F6 C4 05 7A 32 DD D8 8B CF DB 47 10 DD 5D F8 DD 45 F8 DD 5D F8 E8 ?? ?? ?? ?? DC 75 F8 8B CF DD 5D F0 E8 ?? ?? ?? ?? DC 75 F8 DC 45 F0 E8 ?? ?? ?? ?? DC 75 E8 D9 E1 D9 E0 E8 ?? ?? ?? ?? DC 4D E0 5F 5E 5B C9 C2 08 00 }
	condition:
		$1
}

rule file_55_10_0 {
	meta:
		name = "?Clear@MeasuredHistory@HillClimbing@details@Concurrency@@QAEXI@Z"
		size = 28
	strings:
		$1 = { 55 8B EC D9 EE 8B 45 08 83 61 10 00 DD 11 83 61 18 00 DD 59 08 89 41 14 5D C2 04 00 }
	condition:
		$1
}

rule file_55_11_0 {
	meta:
		name = "?ClearHistories@HillClimbing@details@Concurrency@@AAEXXZ"
		size = 33
	strings:
		$1 = { D9 EE 6A 40 83 C1 08 58 33 D2 DD 51 F8 89 51 08 DD 11 89 51 0C 89 51 10 83 C1 20 48 75 EC DD D8 C3 }
	condition:
		$1
}

rule file_55_12_0 {
	meta:
		name = "?CoefficientOfVariation@MeasuredHistory@HillClimbing@details@Concurrency@@QAENXZ"
		size = 49
		refs = "0009 ?Mean@MeasuredHistory@HillClimbing@details@Concurrency@@QAENXZ 0022 ?Variance@MeasuredHistory@HillClimbing@details@Concurrency@@QAENXZ 0027 __CIsqrt"
	strings:
		$1 = { 55 8B EC 51 51 56 8B F1 E8 ?? ?? ?? ?? DD 55 F8 D9 EE D8 D1 DF E0 DD D9 F6 C4 01 74 11 8B CE DD D8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? DC 75 F8 5E C9 C3 }
	condition:
		$1
}

rule file_55_13_0 {
	meta:
		name = "?CoefficientOfVariationMean@MeasuredHistory@HillClimbing@details@Concurrency@@QAENXZ"
		size = 55
		refs = "000a ?Variance@MeasuredHistory@HillClimbing@details@Concurrency@@QAENXZ 000f __CIsqrt 002d ?Mean@MeasuredHistory@HillClimbing@details@Concurrency@@QAENXZ"
	strings:
		$1 = { 55 8B EC 83 EC 10 56 8B F1 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? DD 5D F0 DB 46 10 DD 5D F8 DD 45 F8 E8 ?? ?? ?? ?? DC 7D F0 8B CE DD 5D F0 E8 ?? ?? ?? ?? DC 7D F0 5E C9 C3 }
	condition:
		$1
}

rule file_55_16_0 {
	meta:
		name = "?DesiredHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ"
		size = 25
	strings:
		$1 = { 8B 91 B8 00 00 00 03 91 80 00 00 00 8B 81 BC 00 00 00 3B C2 72 02 8B C2 C3 }
	condition:
		$1
}

rule file_55_17_0 {
	meta:
		name = "?EstablishControlSetting@HillClimbing@details@Concurrency@@AAEXI@Z"
		size = 69
		refs = "0023 ?GetHistory@HillClimbing@details@Concurrency@@AAEPAVMeasuredHistory@123@I@Z 003c ?FlushHistories@HillClimbing@details@Concurrency@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 8B 45 08 56 8B F1 8B 8E 14 08 00 00 3B C1 74 2D 89 8E 18 08 00 00 50 8B CE 89 86 14 08 00 00 E8 ?? ?? ?? ?? D9 EE 33 C9 DD 10 89 48 10 DD 58 08 89 48 14 89 48 18 8B CE E8 ?? ?? ?? ?? 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_55_18_0 {
	meta:
		name = "?FlushHistories@HillClimbing@details@Concurrency@@AAEXXZ"
		size = 68
	strings:
		$1 = { D9 EE 56 6A 40 8D 51 14 5E 8B 02 3B 81 14 08 00 00 74 27 3B 81 18 08 00 00 74 1F 8B 81 24 08 00 00 2B 42 04 83 F8 32 76 11 83 62 FC 00 DD 52 EC 83 22 00 DD 52 F4 83 62 04 00 83 C2 20 4E 75 C9 DD D8 5E C3 }
	condition:
		$1
}

rule file_55_19_0 {
	meta:
		name = "?GetHistory@HillClimbing@details@Concurrency@@AAEPAVMeasuredHistory@123@I@Z"
		size = 43
	strings:
		$1 = { 55 8B EC 8B 55 08 8B C2 83 E0 3F C1 E0 05 03 C1 39 50 14 74 12 D9 EE 83 60 10 00 83 60 18 00 DD 10 DD 58 08 89 50 14 5D C2 04 00 }
	condition:
		$1
}

rule file_55_20_0 {
	meta:
		name = "?GetRandomMove@HillClimbing@details@Concurrency@@AAEHXZ"
		size = 25
	strings:
		$1 = { 8A 91 34 08 00 00 33 C0 84 D2 0F 95 C0 84 D2 0F 94 C2 88 91 34 08 00 00 C3 }
	condition:
		$1
}

rule file_55_21_0 {
	meta:
		name = "?IsStableHistory@HillClimbing@details@Concurrency@@AAE_NPAVMeasuredHistory@123@@Z"
		size = 48
		refs = "0017 ?CoefficientOfVariationMean@MeasuredHistory@HillClimbing@details@Concurrency@@QAENXZ 001f __real@3f70624dd2f1a9fc"
	strings:
		$1 = { 55 8B EC 8B 4D 08 83 79 10 05 77 1E 83 79 10 03 73 04 32 C0 EB 16 E8 ?? ?? ?? ?? D9 E1 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 74 E8 B0 01 5D C2 04 00 }
	condition:
		$1
}

rule file_55_23_0 {
	meta:
		name = "?Mean@MeasuredHistory@HillClimbing@details@Concurrency@@QAENXZ"
		size = 32
	strings:
		$1 = { 55 8B EC 51 51 8B 41 10 89 45 FC 85 C0 75 04 D9 EE C9 C3 DB 45 FC DD 5D F8 DD 45 F8 DC 39 C9 C3 }
	condition:
		$1
}

rule file_55_24_0 {
	meta:
		name = "?MinHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ"
		size = 16
		refs = "0004 ?MinVprocHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? 03 86 B8 00 00 00 5E C3 }
	condition:
		$1
}

rule file_55_25_0 {
	meta:
		name = "?MinVprocHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ"
		size = 25
	strings:
		$1 = { 8B 81 AC 00 00 00 2B 81 B8 00 00 00 8B 89 84 00 00 00 3B C1 77 02 8B C1 C3 }
	condition:
		$1
}

rule file_55_26_0 {
	meta:
		name = "?RecommendControlSetting@HillClimbing@details@Concurrency@@AAEII@Z"
		size = 208
		refs = "0015 ?MinVprocHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 0024 ?DesiredHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 0075 ??$sign@I@details@Concurrency@@YAII@Z 009b ?GetHistory@HillClimbing@details@Concurrency@@AAEPAVMeasuredHistory@123@I@Z 00af ?CalculateThroughputSlope@HillClimbing@details@Concurrency@@AAENHH@Z 00b5 __real@bff0000000000000"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F9 89 7D FC 8B B7 00 08 00 00 8B CE E8 ?? ?? ?? ?? 8B D8 03 9E B8 00 00 00 8B CE E8 ?? ?? ?? ?? 8B 4D FC 8B BF 14 08 00 00 8B 89 10 08 00 00 8B 75 08 8B D0 8D 04 39 3B C6 73 02 8B F0 3B F9 76 0A 8B C7 2B C1 3B C6 76 02 8B F0 3B F7 75 08 3B F3 76 03 4E EB 01 46 3B DE 76 02 8B F3 3B D6 73 02 8B F2 3B F7 74 58 8B C6 2B C7 50 E8 ?? ?? ?? ?? 59 83 F8 FF 75 48 8B 5D FC 4F 3B FE 74 10 8B C6 2B C7 50 E8 ?? ?? ?? ?? 59 83 F8 FF 75 30 57 8B CB E8 ?? ?? ?? ?? 83 78 10 00 7E DD 57 FF B3 14 08 00 00 8B CB E8 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? D9 EE DE D9 DF E0 F6 C4 01 75 BE 8D 77 01 5F 8B C6 5E 5B C9 C2 04 00 }
	condition:
		$1
}

rule file_55_27_0 {
	meta:
		name = "?SignificanceTest@MeasuredHistory@HillClimbing@details@Concurrency@@QAEHNHI@Z"
		size = 62
		refs = "0036 ?SignificanceTest@MeasuredHistory@HillClimbing@details@Concurrency@@QAEHPAV1234@H@Z"
	strings:
		$1 = { 55 8B EC 83 EC 20 DD 45 08 8B 45 14 FF 75 10 D9 C0 D9 EE 83 65 F4 00 DC C1 89 45 F8 D9 C9 8D 45 E0 50 C7 45 F0 01 00 00 00 DD 5D E0 D9 C9 DC C8 DE C1 DD 5D E8 E8 ?? ?? ?? ?? C9 C2 10 00 }
	condition:
		$1
}

rule file_55_28_0 {
	meta:
		name = "?SignificanceTest@MeasuredHistory@HillClimbing@details@Concurrency@@QAEHPAV1234@H@Z"
		size = 309
		refs = "0007 ___security_cookie 0012 __real@40049ba5e353f7cf 001e __real@40029c432ca57a78 002b __real@40015c28f5c28f5c 003a __real@4000666666666666 0046 __real@3fff5c28f5c28f5c 004f __real@3ffe147ae147ae14 0058 __real@3ffcf5c28f5c28f6 0061 __real@3ffc000000000000 006a __real@3ffb333333333333 0073 __real@3ffa3d70a3d70a3d 007b ?Variance@MeasuredHistory@HillClimbing@details@Concurrency@@QAENXZ 008e ?Mean@MeasuredHistory@HillClimbing@details@Concurrency@@QAENXZ 00c4 ??$sign@N@details@Concurrency@@YANN@Z 00cb __ftol2_sse 0104 __CIsqrt 012d @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 74 A1 ?? ?? ?? ?? 33 C5 89 45 FC DD 05 ?? ?? ?? ?? 56 DD 5D AC 8B F1 DD 05 ?? ?? ?? ?? 57 DD 5D B4 8B 46 10 DD 05 ?? ?? ?? ?? 8B 7D 08 DD 5D BC 89 45 90 DD 05 ?? ?? ?? ?? 89 45 A8 DD 5D C4 DD 05 ?? ?? ?? ?? DD 5D CC DD 05 ?? ?? ?? ?? DD 5D D4 DD 05 ?? ?? ?? ?? DD 5D DC DD 05 ?? ?? ?? ?? DD 5D E4 DD 05 ?? ?? ?? ?? DD 5D EC DD 05 ?? ?? ?? ?? DD 5D F4 E8 ?? ?? ?? ?? DB 45 A8 8B CE DD 5D 9C DC 75 9C DD 5D 94 E8 ?? ?? ?? ?? DD 5D 9C 8B 47 10 8B CF 89 45 8C 89 45 A8 E8 ?? ?? ?? ?? DB 45 A8 8B CF DD 5D A4 DC 75 A4 DD 5D A4 E8 ?? ?? ?? ?? DC 6D 9C 51 51 DD 55 9C DD 1C 24 E8 ?? ?? ?? ?? 59 59 E8 ?? ?? ?? ?? D9 EE DD 45 94 8B F0 D8 D1 DF E0 F6 C4 41 75 40 DD 45 A4 D8 D2 DF E0 DD DA F6 C4 41 75 32 DB 45 8C DD 5D 94 DD 45 94 DE FA DB 45 90 DD 5D 94 DC 75 94 DE C1 E8 ?? ?? ?? ?? DC 7D 9C 8B 45 0C D9 E1 DC 5C C5 A4 DF E0 F6 C4 05 7A 08 33 F6 EB 04 DD D9 DD D8 8B 4D FC 5F 8B C6 33 CD 5E E8 ?? ?? ?? ?? C9 C2 08 00 }
	condition:
		$1
}

rule file_55_30_0 {
	meta:
		name = "?StandardDeviationMean@MeasuredHistory@HillClimbing@details@Concurrency@@QAENXZ"
		size = 52
		refs = "0015 ?Variance@MeasuredHistory@HillClimbing@details@Concurrency@@QAENXZ 001a __CIsqrt"
	strings:
		$1 = { 55 8B EC 83 EC 10 8B 41 10 89 45 FC 85 C0 75 04 D9 EE C9 C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? DD 5D F0 DB 45 FC DD 5D F8 DD 45 F8 E8 ?? ?? ?? ?? DC 7D F0 C9 C3 }
	condition:
		$1
}

rule file_55_31_0 {
	meta:
		name = "?Update@HillClimbing@details@Concurrency@@QAEIIIII@Z"
		size = 447
		refs = "0020 ?EstablishControlSetting@HillClimbing@details@Concurrency@@AAEXI@Z 0088 ?MinVprocHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 00d3 ?CalculateThroughput@HillClimbing@details@Concurrency@@AAENIIII@Z 00ee ?GetHistory@HillClimbing@details@Concurrency@@AAEPAVMeasuredHistory@123@I@Z 0115 ?Add@MeasuredHistory@HillClimbing@details@Concurrency@@QAEXNI@Z 012a ?IsStableHistory@HillClimbing@details@Concurrency@@AAE_NPAVMeasuredHistory@123@@Z 0145 ?CalculateThroughputSlope@HillClimbing@details@Concurrency@@AAENHH@Z 0161 __real@41f0000000000000 0171 __ftol2 017f ??$sign@N@details@Concurrency@@YANN@Z 01a2 ?GetRandomMove@HillClimbing@details@Concurrency@@AAEHXZ 01b0 ?RecommendControlSetting@HillClimbing@details@Concurrency@@AAEII@Z"
	strings:
		$1 = { 55 8B EC 51 51 53 56 8B 75 08 8B D9 85 F6 75 07 33 C0 E9 A2 01 00 00 FF 83 24 08 00 00 57 56 E8 ?? ?? ?? ?? 8B BB 28 08 00 00 8B 4D 0C 8B 55 10 85 FF 74 0C 03 8B 2C 08 00 00 03 93 30 08 00 00 3B CE 73 0D 3B 4D 14 73 08 8B C6 2B C1 03 D0 8B CE 8B B3 20 08 00 00 83 FE 01 72 4A 83 F9 01 73 45 83 FA 01 73 40 83 7D 14 00 75 3A 8B B3 00 08 00 00 89 8B 2C 08 00 00 47 8B CE 89 BB 28 08 00 00 89 93 30 08 00 00 E8 ?? ?? ?? ?? 03 86 B8 00 00 00 83 FF 03 0F 83 1D 01 00 00 8B 83 14 08 00 00 E9 12 01 00 00 FF 75 14 8D 47 01 52 33 FF 51 46 89 BB 2C 08 00 00 89 BB 30 08 00 00 89 BB 28 08 00 00 8B BB 14 08 00 00 50 8B CB 89 B3 20 08 00 00 E8 ?? ?? ?? ?? DD 5D F8 83 FE 01 77 0B 89 BB 18 08 00 00 E9 CC 00 00 00 57 8B CB E8 ?? ?? ?? ?? FF B3 18 08 00 00 8B CB 8B F0 E8 ?? ?? ?? ?? DD 45 F8 FF B3 24 08 00 00 89 45 14 51 51 8B CE DD 1C 24 E8 ?? ?? ?? ?? 8B 45 14 83 78 10 00 74 71 3B F0 74 6D 56 8B CB E8 ?? ?? ?? ?? 84 C0 0F 84 80 00 00 00 FF B3 14 08 00 00 8B CB FF B3 18 08 00 00 E8 ?? ?? ?? ?? DC 8B 08 08 00 00 8B B3 14 08 00 00 DB 83 14 08 00 00 85 F6 79 06 DC 05 ?? ?? ?? ?? DD 5D F8 DD 45 F8 DD 55 F8 D8 C1 E8 ?? ?? ?? ?? 3B C6 75 16 51 51 DD 1C 24 E8 ?? ?? ?? ?? DC 45 F8 59 59 E8 ?? ?? ?? ?? EB 1D DD D8 EB 19 56 8B CB E8 ?? ?? ?? ?? 84 C0 74 17 8B CB E8 ?? ?? ?? ?? 03 83 14 08 00 00 50 8B CB E8 ?? ?? ?? ?? 8B F8 8B C7 5F 5E 5B C9 C2 10 00 }
	condition:
		$1
}

rule file_55_32_0 {
	meta:
		name = "?Variance@MeasuredHistory@HillClimbing@details@Concurrency@@QAENXZ"
		size = 76
		refs = "0039 __real@3f1a36e2eb1c432d"
	strings:
		$1 = { 55 8B EC 51 51 8B 41 10 D9 EE D9 C0 89 45 FC 83 F8 02 7C 1F DD D8 48 DD 01 DC C8 DB 45 FC DD 5D F8 DC 75 F8 89 45 FC DC 69 08 DB 45 FC DD 5D F8 DC 75 F8 D9 C0 D9 E1 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 04 DD D9 C9 C3 DD D8 C9 C3 }
	condition:
		$1
}

rule file_55_33_0 {
	meta:
		name = "?VarianceMean@MeasuredHistory@HillClimbing@details@Concurrency@@QAENXZ"
		size = 25
		refs = "0009 ?Variance@MeasuredHistory@HillClimbing@details@Concurrency@@QAENXZ"
	strings:
		$1 = { 55 8B EC 51 51 56 8B F1 E8 ?? ?? ?? ?? DB 46 10 5E DD 5D F8 DC 75 F8 C9 C3 }
	condition:
		$1
}

rule file_56_0_0 {
	meta:
		name = "___sse2_coshf4"
		size = 320
		refs = "0012 ___common_scosh_data 0137 ___common_scosh_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 0F 28 C8 0F 28 3D ?? ?? ?? ?? 0F 28 1D ?? ?? ?? ?? 0F 55 F9 0F 59 DF 0F 28 25 ?? ?? ?? ?? 0F 29 4C 24 10 0F 28 CF 66 0F 6F 15 ?? ?? ?? ?? 0F 58 DC 66 0F 66 CA 66 0F 76 D7 66 0F EB CA 0F 50 D1 0F 28 CB 0F 28 15 ?? ?? ?? ?? 66 0F 72 F3 17 0F 28 2D ?? ?? ?? ?? 0F 5C CC 0F 59 D1 85 D2 0F 28 25 ?? ?? ?? ?? 0F 5C FA 0F 59 E1 0F 28 35 ?? ?? ?? ?? 0F 5C FC 0F 28 CF 0F 59 CF 0F 59 E9 0F 59 F1 0F 58 2D ?? ?? ?? ?? 0F 58 35 ?? ?? ?? ?? 0F 59 E9 0F 59 F1 0F 59 EF 0F 58 35 ?? ?? ?? ?? 0F 58 EF 0F 59 F1 66 0F 6F 05 ?? ?? ?? ?? 66 0F 6F D0 66 0F FA C3 66 0F FE D3 66 0F 6F DA 0F 58 D0 0F 5C D8 0F 59 F2 0F 59 DD 0F 58 DE 0F 58 DA 75 07 0F 28 C3 8B E5 5D C3 0F 28 4C 24 10 0F 29 4C 24 40 0F 29 9C 24 80 00 00 00 74 E5 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 8B CE B8 01 00 00 00 D3 E0 85 F8 75 17 46 83 FE 20 7C ED 8B 74 24 04 8B 3C 24 0F 28 9C 24 80 00 00 00 EB B4 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB D2 }
	condition:
		$1
}

rule file_59_1_0 {
	meta:
		name = "__localtime64"
		size = 37
		refs = "0005 ___getgmtimebuf 0014 __localtime64_s"
	strings:
		$1 = { 55 8B EC 56 E8 ?? ?? ?? ?? 8B F0 85 F6 74 13 FF 75 08 56 E8 ?? ?? ?? ?? F7 D8 1B C0 59 F7 D0 59 23 C6 5E 5D C3 }
	condition:
		$1
}

rule file_290_1_0 {
	meta:
		name = "__gmtime32"
		size = 37
		refs = "0005 ___getgmtimebuf 0014 __gmtime32_s"
	strings:
		$1 = { 55 8B EC 56 E8 ?? ?? ?? ?? 8B F0 85 F6 74 13 FF 75 08 56 E8 ?? ?? ?? ?? F7 D8 1B C0 59 F7 D0 59 23 C6 5E 5D C3 }
	condition:
		$1
}

rule file_951_0_0 {
	meta:
		name = "__gmtime64"
		size = 37
		refs = "0005 ___getgmtimebuf 0014 __gmtime64_s"
	strings:
		$1 = { 55 8B EC 56 E8 ?? ?? ?? ?? 8B F0 85 F6 74 13 FF 75 08 56 E8 ?? ?? ?? ?? F7 D8 1B C0 59 F7 D0 59 23 C6 5E 5D C3 }
	condition:
		$1
}

rule file_636_1_0 {
	meta:
		name = "__localtime32"
		size = 37
		refs = "0005 ___getgmtimebuf 0014 __localtime32_s"
	strings:
		$1 = { 55 8B EC 56 E8 ?? ?? ?? ?? 8B F0 85 F6 74 13 FF 75 08 56 E8 ?? ?? ?? ?? F7 D8 1B C0 59 F7 D0 59 23 C6 5E 5D C3 }
	condition:
		$1
}

rule file_59_2_0 {
	meta:
		name = "__localtime64_s"
		size = 632
		refs = "001c __errno 0026 __invalid_parameter_noinfo 003a _memset 0072 ___tzset 007b __get_daylight 008d __get_dstbias 009f __get_timezone 00d3 __gmtime64_s 00ec __isindst 017c __allrem 0198 __alldiv 0273 __invoke_watson"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 56 33 DB 57 8B 7D 08 89 5D F8 89 5D F4 89 5D FC 85 FF 75 16 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 5F 5E 5B C9 C3 6A 24 68 FF 00 00 00 57 E8 ?? ?? ?? ?? 8B 75 0C 83 C4 0C 85 F6 74 D3 39 5E 04 7F 12 7C 04 39 1E 73 0C E8 ?? ?? ?? ?? 6A 16 5E 89 30 EB CB 6A 07 58 39 46 04 7C 0A 7F EA 81 3E FF 6F 40 93 77 E2 E8 ?? ?? ?? ?? 8D 45 F8 50 E8 ?? ?? ?? ?? 59 85 C0 0F 85 E5 01 00 00 8D 45 F4 50 E8 ?? ?? ?? ?? 59 85 C0 0F 85 D3 01 00 00 8D 45 FC 50 E8 ?? ?? ?? ?? 59 85 C0 0F 85 C1 01 00 00 8B 5E 04 8B 0E 85 DB 7C 6E 7F 08 81 F9 80 F4 03 00 76 64 8B 45 FC 99 2B C8 8D 45 EC 50 1B DA 57 89 4D EC 89 5D F0 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 4B FF FF FF 39 45 F8 0F 84 3C 01 00 00 57 E8 ?? ?? ?? ?? 59 85 C0 0F 84 2D 01 00 00 8B 45 F4 99 29 45 EC 8D 45 EC 50 19 55 F0 57 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 15 FF FF FF C7 47 20 01 00 00 00 E9 03 01 00 00 56 57 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 F8 FE FF FF 39 45 F8 74 2D 57 E8 ?? ?? ?? ?? 59 85 C0 74 22 8B 45 F4 03 45 FC C7 47 20 01 00 00 00 99 8B C8 8B 07 8B F2 99 8B D8 2B D9 1B D6 89 55 08 8B F2 EB 0F 8B 07 99 8B D8 8B 45 FC 8B F2 99 2B D8 1B F2 6A 00 6A 3C 56 53 E8 ?? ?? ?? ?? 89 07 85 C0 79 0B 83 C0 3C 83 C3 C4 89 07 83 D6 FF 6A 00 6A 3C 56 53 E8 ?? ?? ?? ?? 8B F0 8B 47 04 8B DA 99 6A 00 03 F0 6A 3C 13 DA 53 56 E8 ?? ?? ?? ?? 89 47 04 85 C0 79 0C 83 C0 3C 83 C6 C4 89 47 04 83 D3 FF 6A 00 6A 3C 53 56 E8 ?? ?? ?? ?? 8B F0 8B 47 08 8B DA 99 6A 00 03 F0 6A 18 13 DA 53 56 E8 ?? ?? ?? ?? 89 47 08 85 C0 79 0C 83 C0 18 83 C6 E8 89 47 08 83 D3 FF 6A 00 6A 18 53 56 E8 ?? ?? ?? ?? 8B C8 85 D2 7C 2B 7F 04 85 C9 74 1B 8B 47 18 03 C1 6A 07 99 5E F7 FE 01 4F 0C 89 57 18 01 4F 1C 33 C0 E9 FF FD FF FF 85 D2 7F F5 7C 04 85 C9 73 EF 8B 47 18 83 C0 07 03 C1 99 6A 07 5E F7 FE 01 4F 0C 8B 47 0C 89 57 18 85 C0 7F D1 83 C0 1F 89 47 0C 8D 81 6D 01 00 00 01 47 1C FF 4F 14 C7 47 10 0B 00 00 00 EB B9 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_60_0_0 {
	meta:
		name = "__get_printf_count_output"
		size = 21
		refs = "0002 ___security_cookie 000d ___enable_percent_n"
	strings:
		$1 = { 8B 0D ?? ?? ?? ?? 83 C9 01 33 C0 39 0D ?? ?? ?? ?? 0F 94 C0 C3 }
	condition:
		$1
}

rule file_60_1_0 {
	meta:
		name = "__printf_l"
		size = 23
		refs = "000e __vprintf_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_999_4_0 {
	meta:
		name = "__cprintf_l"
		size = 23
		refs = "000e __vcprintf_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_848_4_0 {
	meta:
		name = "__cprintf_p_l"
		size = 23
		refs = "000e __vcprintf_p_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_314_4_0 {
	meta:
		name = "__cprintf_s_l"
		size = 23
		refs = "000e __vcprintf_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_210_7_0 {
	meta:
		name = "__cscanf_l"
		size = 23
		refs = "000e __cprinput_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_260_7_0 {
	meta:
		name = "__cscanf_s_l"
		size = 23
		refs = "000e __cprinput_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1127_4_0 {
	meta:
		name = "__cwprintf_l"
		size = 23
		refs = "000e __vcwprintf_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_647_4_0 {
	meta:
		name = "__cwprintf_p_l"
		size = 23
		refs = "000e __vcwprintf_p_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_595_4_0 {
	meta:
		name = "__cwprintf_s_l"
		size = 23
		refs = "000e __vcwprintf_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_74_7_0 {
	meta:
		name = "__cwscanf_l"
		size = 23
		refs = "000e __cprinput_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_645_7_0 {
	meta:
		name = "__cwscanf_s_l"
		size = 23
		refs = "000e __cprinput_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_60_3_0 {
	meta:
		name = "__printf_p_l"
		size = 23
		refs = "000e __vprintf_p_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_60_4_0 {
	meta:
		name = "__printf_s_l"
		size = 23
		refs = "000e __vprintf_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_816_1_0 {
	meta:
		name = "__scprintf_l"
		size = 23
		refs = "000e __vscprintf_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_816_3_0 {
	meta:
		name = "__scprintf_p_l"
		size = 23
		refs = "000e __vscprintf_p_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_643_2_0 {
	meta:
		name = "__scwprintf_l"
		size = 23
		refs = "000e __vscwprintf_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_643_4_0 {
	meta:
		name = "__scwprintf_p_l"
		size = 23
		refs = "000e __vscwprintf_p_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_426_0_0 {
	meta:
		name = "__wprintf_l"
		size = 23
		refs = "000e __vwprintf_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_426_2_0 {
	meta:
		name = "__wprintf_p_l"
		size = 23
		refs = "000e __vwprintf_p_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_426_3_0 {
	meta:
		name = "__wprintf_s_l"
		size = 23
		refs = "000e __vwprintf_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_60_2_0 {
	meta:
		name = "__printf_p"
		size = 22
		refs = "000d __vprintf_p_l"
	strings:
		$1 = { 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_999_3_0 {
	meta:
		name = "__cprintf"
		size = 22
		refs = "000d __vcprintf_l"
	strings:
		$1 = { 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_848_3_0 {
	meta:
		name = "__cprintf_p"
		size = 22
		refs = "000d __vcprintf_p_l"
	strings:
		$1 = { 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_314_3_0 {
	meta:
		name = "__cprintf_s"
		size = 22
		refs = "000d __vcprintf_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_210_6_0 {
	meta:
		name = "__cscanf"
		size = 22
		refs = "000d __cprinput_l"
	strings:
		$1 = { 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_260_6_0 {
	meta:
		name = "__cscanf_s"
		size = 22
		refs = "000d __cprinput_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1127_3_0 {
	meta:
		name = "__cwprintf"
		size = 22
		refs = "000d __vcwprintf_l"
	strings:
		$1 = { 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_647_3_0 {
	meta:
		name = "__cwprintf_p"
		size = 22
		refs = "000d __vcwprintf_p_l"
	strings:
		$1 = { 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_595_3_0 {
	meta:
		name = "__cwprintf_s"
		size = 22
		refs = "000d __vcwprintf_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_74_6_0 {
	meta:
		name = "__cwscanf"
		size = 22
		refs = "000d __cprinput_l"
	strings:
		$1 = { 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_645_6_0 {
	meta:
		name = "__cwscanf_s"
		size = 22
		refs = "000d __cprinput_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_426_1_0 {
	meta:
		name = "__wprintf_p"
		size = 22
		refs = "000d __vwprintf_p_l"
	strings:
		$1 = { 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_60_7_0 {
	meta:
		name = "_printf_s"
		size = 22
		refs = "000d __vprintf_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_426_5_0 {
	meta:
		name = "_wprintf_s"
		size = 22
		refs = "000d __vwprintf_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_60_5_0 {
	meta:
		name = "__set_printf_count_output"
		size = 40
		refs = "0005 ___security_cookie 0013 ___enable_percent_n"
	strings:
		$1 = { 55 8B EC 8B 15 ?? ?? ?? ?? 8B 4D 08 83 CA 01 33 C0 39 15 ?? ?? ?? ?? 0F 94 C0 F7 D9 1B C9 23 CA 89 0D ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_60_6_0 {
	meta:
		name = "_printf"
		size = 172
		refs = "0003 __sehtable$_printf 0008 __SEH_prolog4 0019 __errno 0024 __invalid_parameter_noinfo 002e ___iob_func 0039 __lock_file2 004d __stbuf 0067 __output_l 007b __ftbuf 0091 __SEH_epilog4 00a5 __unlock_file2"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 39 45 08 0F 95 C0 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 63 E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 59 59 83 65 FC 00 E8 ?? ?? ?? ?? 83 C0 20 50 E8 ?? ?? ?? ?? 59 8B F0 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C0 20 50 E8 ?? ?? ?? ?? 8B F8 89 7D E4 E8 ?? ?? ?? ?? 83 C0 20 50 56 E8 ?? ?? ?? ?? 83 C4 18 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C7 E8 ?? ?? ?? ?? C3 8B 7D E4 E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_426_4_0 {
	meta:
		name = "_wprintf"
		size = 172
		refs = "0003 __sehtable$_wprintf 0008 __SEH_prolog4 0019 __errno 0024 __invalid_parameter_noinfo 002e ___iob_func 0039 __lock_file2 004d __stbuf 0067 __woutput_l 007b __ftbuf 0091 __SEH_epilog4 00a5 __unlock_file2"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 39 45 08 0F 95 C0 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 63 E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 59 59 83 65 FC 00 E8 ?? ?? ?? ?? 83 C0 20 50 E8 ?? ?? ?? ?? 59 8B F0 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C0 20 50 E8 ?? ?? ?? ?? 8B F8 89 7D E4 E8 ?? ?? ?? ?? 83 C0 20 50 56 E8 ?? ?? ?? ?? 83 C4 18 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C7 E8 ?? ?? ?? ?? C3 8B 7D E4 E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_61_3_0 {
	meta:
		name = "__stricoll"
		size = 36
		refs = "0005 ___locale_changed 000e __stricmp 001b __stricoll_l"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 75 06 5D E9 ?? ?? ?? ?? 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_61_4_0 {
	meta:
		name = "__stricoll_l"
		size = 142
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0021 __errno 002c __invalid_parameter_noinfo 0042 __stricmp 005e ___crtCompareStringA"
	strings:
		$1 = { 55 8B EC 83 EC 10 8D 4D F0 56 FF 75 10 E8 ?? ?? ?? ?? 8B 4D 08 85 C9 74 07 8B 45 0C 85 C0 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 42 8B 55 F0 8B B2 A4 00 00 00 85 F6 75 0B 50 51 E8 ?? ?? ?? ?? 59 59 EB 34 FF 72 08 6A FF 50 6A FF 51 68 01 10 00 00 8D 45 F0 56 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 B8 FF FF FF 7F EB 03 83 C0 FE 80 7D FC 00 5E 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "?swprintf@@YAHPAGIPBGZZ"
		size = 28
		refs = "0013 ?_vswprintf_l@@YAHPA_WIPB_WPAUlocaleinfo_struct@@PAD@Z"
	strings:
		$1 = { 55 8B EC 8D 45 14 50 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_816_7_0 {
	meta:
		name = "__sprintf_p"
		size = 28
		refs = "0013 __vsprintf_p_l"
	strings:
		$1 = { 55 8B EC 8D 45 14 50 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_643_8_0 {
	meta:
		name = "__swprintf_p"
		size = 28
		refs = "0013 __vswprintf_p_l"
	strings:
		$1 = { 55 8B EC 8D 45 14 50 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_816_11_0 {
	meta:
		name = "_sprintf_s"
		size = 28
		refs = "0013 __vsprintf_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 14 50 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_456_2_0 {
	meta:
		name = "_swprintf"
		size = 28
		refs = "0013 __vswprintf_c_l"
	strings:
		$1 = { 55 8B EC 8D 45 14 50 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_643_11_0 {
	meta:
		name = "_swprintf_s"
		size = 28
		refs = "0013 __vswprintf_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 14 50 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_62_1_0 {
	meta:
		name = "?swprintf@@YAHPA_WIPB_WZZ"
		size = 145
		refs = "004b __woutput_l 006d __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 20 57 6A 07 33 C0 59 8D 7D E4 F3 AB 8B 45 08 89 45 E8 89 45 E0 8B 45 0C C7 45 EC 42 00 00 00 5F 3D FF FF FF 3F 76 09 C7 45 E4 FF FF FF 7F EB 05 03 C0 89 45 E4 53 56 8D 45 14 50 33 DB 53 FF 75 10 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 10 FF 4D E4 8B F0 78 0E 8B 4D E0 88 19 8B 4D E0 41 89 4D E0 EB 0F 8D 45 E0 50 53 E8 ?? ?? ?? ?? 59 59 8B 4D E0 FF 4D E4 78 04 88 19 EB 0C 8D 45 E0 50 53 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5B C9 C3 }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "__libm_sse2_pow_precise"
		size = 2928
		refs = "0040 SIGMASK 0048 ONEMASK 0079 rcp_t1 008d log2_t1 00c8 HALFSIG 00f4 rcp_t2 0108 log2_t2 013a LHN 0150 rcp_t3 0162 log2_t3 024b clv 02a6 Shifter 02ca exp2_tbl 02d2 cev 0381 ABSVALMASK 043d NEG_ZERO 0656 NEG_INF 06de sNaN 06e6 QIND 07dc INF 086d ___libm_error_support 0a8e EMIN 0abb NEG_BIG 0ac3 POS_BIG 0b60 __pow_default"
	strings:
		$1 = { 83 EC 10 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 0F 85 38 0B 00 00 D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 0F 85 23 0B 00 00 66 0F 13 04 24 66 0F 13 4C 24 08 66 0F 12 3D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 66 0F 54 F8 F2 0F 10 E0 66 0F 73 D0 2C 66 0F C5 C0 00 66 0F 56 FA 66 0F C5 CC 03 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 3C 85 ?? ?? ?? ?? 66 0F 12 2C 85 ?? ?? ?? ?? 03 C0 66 0F 28 34 85 ?? ?? ?? ?? BA EF 7F 00 00 2B D1 83 E9 10 0B CA 81 F9 00 00 00 80 0F 83 CE 02 00 00 B9 00 00 00 00 BA 7F FE 03 00 66 0F 6E CA 66 0F FB C1 66 0F 73 D0 08 F3 0F E6 C0 66 0F 12 0D ?? ?? ?? ?? F2 0F 10 DF 66 0F 73 D7 26 66 0F C5 C7 00 66 0F 54 25 ?? ?? ?? ?? 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 1C 85 ?? ?? ?? ?? F2 0F 59 2C 85 ?? ?? ?? ?? 03 C0 66 0F 58 34 85 ?? ?? ?? ?? 66 0F 56 25 ?? ?? ?? ?? F2 0F 58 F0 66 0F 54 CC F2 0F 10 D3 66 0F 73 D3 1F 66 0F C5 C3 00 66 0F 12 05 ?? ?? ?? ?? F2 0F 5C E1 66 0F 12 3D ?? ?? ?? ?? 25 FF 01 00 00 83 C0 01 25 FE 03 00 00 F2 0F 59 2C 85 ?? ?? ?? ?? F2 0F 59 14 85 ?? ?? ?? ?? 66 0F 58 34 C5 ?? ?? ?? ?? 66 0F 54 C5 F2 0F 5C E8 F2 0F 58 FA F2 0F 10 D8 F2 0F 59 C1 F2 0F 59 CD F2 0F 59 DC F2 0F 5C D0 F2 0F 59 E5 F2 0F 10 C6 F2 0F 5C D1 F2 0F 58 F7 66 0F 12 4C 24 08 66 0F C5 C1 03 F2 0F 5C D3 F2 0F 5C C6 66 0F 12 1D ?? ?? ?? ?? 66 0F C5 D6 03 F2 0F 5C D4 F2 0F 10 E6 F2 0F 58 C7 F2 0F 5C FA F2 0F 5C F2 66 0F 14 FF 25 F0 7F 00 00 3D F0 7F 00 00 0F 83 1A 05 00 00 81 E2 F0 7F 00 00 2D F0 3F 00 00 03 C2 BA A0 40 00 00 2B D0 2D 70 3C 00 00 0B D0 81 FA 00 00 00 80 0F 83 D8 08 00 00 F2 0F 5C E6 F2 0F 5C D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 54 D9 66 0F 54 E6 F2 0F 5C C2 66 0F 57 D2 BA 60 40 00 00 66 0F C4 D2 03 F2 0F 10 EB F2 0F 59 DC F2 0F 5C F4 F2 0F 5C CD F2 0F 59 DA F2 0F 59 EE 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 2D C3 F2 0F 59 F1 66 0F 28 0D ?? ?? ?? ?? F2 0F 58 EC 66 0F 70 E6 EE F2 0F 58 EE BA 7F FF 01 00 2B D0 05 FF E1 01 00 0B D0 2D FF E1 01 00 83 FA 00 0F 8E EF 05 00 00 03 C8 83 E0 7F 83 E1 80 81 C1 80 FF 01 00 F2 0F 58 E0 F2 0F 10 C3 F2 0F 58 1D ?? ?? ?? ?? 66 0F 59 D7 F2 0F 5C 1D ?? ?? ?? ?? 66 0F 59 FF F2 0F 5C C3 03 C0 03 C0 03 C0 03 C0 66 0F 28 98 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 CF 66 0F 58 D1 66 0F 70 CA EE F2 0F 59 D7 66 0F 57 FF BA 80 3F 00 00 F2 0F 58 D1 66 0F C4 FA 03 F2 0F 58 D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 6E C9 F2 0F 59 54 24 08 F2 0F 59 C7 66 0F 73 F1 2D 66 0F 70 C9 44 66 0F 28 3D ?? ?? ?? ?? F2 0F 58 EA 66 0F 59 D9 F2 0F 58 C5 66 0F 14 C0 66 0F 59 F0 F2 0F 59 E0 66 0F 59 C0 66 0F 58 FE 66 0F 59 F8 F2 0F 59 C3 66 0F 70 F7 EE F2 0F 59 C7 66 0F 70 EB EE F2 0F 59 F3 F2 0F 59 E3 F2 0F 58 C5 F2 0F 58 C6 F2 0F 58 C4 F2 0F 58 C3 83 C4 10 C3 66 0F 12 4C 24 08 66 0F 12 1D ?? ?? ?? ?? 66 0F 7E C8 F2 0F 10 D1 66 0F 54 CB 66 0F 73 D1 20 66 0F 7E C9 81 F9 00 00 F0 7F 0F 83 D8 00 00 00 0B C1 83 F8 00 0F 84 42 04 00 00 83 FA 00 0F 8D 00 01 00 00 F7 DA 81 C2 EF 7F 00 00 66 0F 73 F3 34 66 0F 56 D3 B9 F3 03 00 00 66 0F 6E D9 66 0F 73 D1 14 66 0F FA CB 66 0F EF DB 66 0F EE CB 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 8B CA 81 E2 FF 7F 00 00 81 FA F0 7F 00 00 0F 83 A2 01 00 00 25 FF 00 00 00 3D FF 00 00 00 0F 85 9D 02 00 00 66 0F 12 4C 24 08 66 0F 28 D1 B9 F4 03 00 00 66 0F 6E D9 66 0F 54 0D ?? ?? ?? ?? 66 0F 73 D1 34 66 0F FA CB 66 0F 12 1D ?? ?? ?? ?? 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 25 FF 00 00 00 B9 01 FF 03 00 03 C8 81 E1 00 00 04 00 83 FA 10 72 5B BA 7F FE 0B 00 66 0F 12 1D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? E9 35 FC FF FF 66 0F 12 3C 24 66 0F 28 E7 66 0F 7E FA 66 0F 73 D7 20 66 0F 7E F8 8B C8 25 FF FF FF 7F 3D 00 00 F0 7F 0F 82 B7 02 00 00 0F 87 F4 01 00 00 83 FA 00 0F 87 EB 01 00 00 E9 A3 02 00 00 B9 00 00 00 00 66 0F 57 C0 B8 F0 43 00 00 66 0F C4 C0 03 66 0F 12 3D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? F2 0F 59 C4 66 0F 7E E2 66 0F 73 D4 20 66 0F 7E E0 83 FA 00 74 52 66 0F 54 F8 F2 0F 10 E0 66 0F 54 05 ?? ?? ?? ?? 66 0F 73 D0 2C 66 0F C5 C0 00 66 0F 56 FA 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 3C 85 ?? ?? ?? ?? 66 0F 12 2C 85 ?? ?? ?? ?? 03 C0 66 0F 28 34 85 ?? ?? ?? ?? BA 7F 3E 04 00 E9 6E FB FF FF 8B D0 81 E2 FF FF FF 7F 83 FA 00 75 A1 8B 54 24 0C 81 E2 00 00 00 80 83 FA 00 74 30 C1 E1 0D 23 C1 BA 00 00 F0 7F 0B D0 66 0F 6E C2 66 0F 73 F0 20 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 14 24 F2 0F 5E CA BA 1B 00 00 00 E9 B8 02 00 00 C1 E1 0D 23 C1 83 F8 00 0F 85 A7 00 00 00 66 0F 57 C0 83 C4 10 C3 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 C9 66 0F 54 DC 66 0F 76 CB 66 0F D7 C9 81 E1 FF 00 00 00 81 F9 FF 00 00 00 0F 85 CF 00 00 00 66 0F C5 CC 03 81 E1 00 80 00 00 83 F9 00 0F 84 9A 00 00 00 25 FF 00 00 00 3D FF 00 00 00 75 6D 66 0F 12 4C 24 08 66 0F 28 D1 B9 F4 03 00 00 66 0F 6E D9 66 0F 54 0D ?? ?? ?? ?? 66 0F 73 D1 34 66 0F FA CB 66 0F EF DB 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 25 FF 00 00 00 3D FF 00 00 00 74 2D 66 0F 12 4C 24 08 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 74 0C 66 0F 12 05 ?? ?? ?? ?? 83 C4 10 C3 66 0F 12 05 ?? ?? ?? ?? 83 C4 10 C3 66 0F 12 4C 24 08 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 61 01 00 00 66 0F 57 C0 83 C4 10 C3 66 0F 12 4C 24 08 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 40 01 00 00 66 0F 57 C0 83 C4 10 C3 F2 0F 58 E4 F2 0F 10 C4 BA EE 03 00 00 E9 97 01 00 00 66 0F 12 14 24 66 0F 7E D0 66 0F 73 D2 20 66 0F 7E D2 81 E2 FF FF FF 7F 0B C2 B9 00 00 00 00 83 F8 00 0F 84 6B FE FF FF 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 C9 BA 1C 00 00 00 E9 51 01 00 00 66 0F 12 24 24 66 0F 12 54 24 08 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 C9 66 0F 54 DA 66 0F 76 CB 66 0F D7 C1 25 FF 00 00 00 3D FF 00 00 00 0F 85 B9 00 00 00 66 0F 7E E0 83 F8 00 75 29 66 0F 73 D4 20 66 0F 7E E2 81 FA 00 00 F0 3F 0F 84 F3 00 00 00 81 FA 00 00 F0 BF 75 0C 66 0F 12 05 ?? ?? ?? ?? 83 C4 10 C3 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 C9 66 0F 54 DA 66 0F 76 CB 66 0F D7 C1 25 FF 00 00 00 3D FF 00 00 00 75 63 66 0F C5 C2 03 66 0F 12 24 24 25 00 80 00 00 81 F1 00 00 F0 BF 0B D1 83 FA 00 0F 84 9B 00 00 00 83 F8 00 74 19 66 0F C5 C4 03 25 F0 7F 00 00 3D F0 3F 00 00 72 21 66 0F 57 C0 83 C4 10 C3 66 0F C5 C4 03 25 F0 7F 00 00 3D F0 3F 00 00 73 08 66 0F 57 C0 83 C4 10 C3 66 0F 12 05 ?? ?? ?? ?? 83 C4 10 C3 F2 0F 58 D2 F2 0F 10 C2 BA EE 03 00 00 EB 56 66 0F 7E E0 66 0F 73 D4 20 66 0F 7E E2 81 E2 FF FF FF 7F 8B C8 0B C2 66 0F 12 05 ?? ?? ?? ?? BA 1A 00 00 00 83 F8 00 74 2D 66 0F 7E E0 BA 1D 00 00 00 25 FF FF FF 7F 3D 00 00 F0 7F 77 18 72 05 83 F9 00 77 11 83 C4 10 C3 66 0F 12 05 ?? ?? ?? ?? BA 1C 00 00 00 83 EC 18 66 0F 13 44 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 10 89 54 24 04 83 EA 08 89 14 24 E8 ?? ?? ?? ?? 66 0F 12 44 24 10 83 C4 28 C3 83 F8 00 7E 28 3D 00 00 04 00 0F 83 22 02 00 00 56 8B D0 83 E0 7F 81 C1 00 FF 03 00 81 EA 80 00 00 00 83 E2 80 57 BF F0 3F 00 00 EB 26 3D 00 02 FC FF 0F 8E D7 01 00 00 56 8B D0 83 E0 7F 81 C1 80 00 00 00 83 E2 80 81 C2 80 FE 03 00 57 BF 00 00 00 00 F2 0F 58 E0 F2 0F 10 C3 F2 0F 58 1D ?? ?? ?? ?? 8B F2 81 EE 80 FF 01 00 66 0F 59 D7 F2 0F 5C 1D ?? ?? ?? ?? 66 0F 59 FF F2 0F 5C C3 03 C0 03 C0 03 C0 03 C0 66 0F 28 98 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 CF 66 0F 58 D1 66 0F 70 CA EE F2 0F 59 D7 F2 0F 58 D1 F2 0F 58 D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 6E CA 81 EA 80 FF 01 00 F7 DA C1 FA 07 83 C2 02 8B C2 83 E0 20 03 D0 66 0F 57 FF B8 80 3F 00 00 66 0F C4 F8 03 F2 0F 59 54 24 10 F2 0F 59 C7 66 0F 73 F1 2D 66 0F 70 C9 44 66 0F 28 3D ?? ?? ?? ?? F2 0F 58 EA 66 0F 59 D9 F2 0F 58 C5 66 0F 14 C0 66 0F 59 F0 F2 0F 59 E0 66 0F 59 C0 66 0F 58 FE 66 0F 59 F8 F2 0F 59 C3 66 0F 70 F7 EE F2 0F 59 C7 66 0F 70 EB EE F2 0F 59 F3 F2 0F 59 E3 66 0F 6E F9 66 0F 73 F7 2D 66 0F 6E D2 66 0F 76 C9 66 0F F3 CA F2 0F 58 C5 F2 0F 58 C6 66 0F 54 CB F2 0F 58 C4 66 0F 57 F6 66 0F 76 E4 66 0F F3 E2 F2 0F 5C D9 F2 0F 10 D1 F2 0F 58 C8 66 0F 54 CC 66 0F C4 F7 03 5F F2 0F 5C D1 F2 0F 58 C2 F2 0F 58 C3 83 FE 00 7F 41 5E F2 0F 59 C7 F2 0F 59 CF F2 0F 58 C1 F2 0F 59 F0 F2 0F 58 C6 66 0F C5 C0 03 25 F0 7F 00 00 BA 18 00 00 00 3D F0 7F 00 00 0F 84 0E FE FF FF BA 19 00 00 00 83 F8 00 0F 84 00 FE FF FF 83 C4 10 C3 5E F2 0F 58 C1 F2 0F 59 C7 F2 0F 59 F0 F2 0F 58 C6 66 0F C5 C0 03 25 F0 7F 00 00 BA 18 00 00 00 3D F0 7F 00 00 0F 84 D1 FD FF FF BA 19 00 00 00 83 F8 00 0F 84 C3 FD FF FF 83 C4 10 C3 66 0F 12 05 ?? ?? ?? ?? 66 0F 6E C9 F2 0F 59 C0 66 0F 73 F1 2D 66 0F 56 C1 BA 19 00 00 00 E9 9C FD FF FF BA 18 00 00 00 83 F9 00 74 15 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? E9 7D FD FF FF 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 C0 E9 6C FD FF FF 66 0F 70 E1 44 66 0F 59 E6 66 0F C5 C4 03 25 F0 7F 00 00 BA A0 40 00 00 2B D0 2D 70 3C 00 00 0B D0 81 FA 00 00 00 80 0F 82 FB F6 FF FF 3D 00 00 00 80 72 13 81 C9 80 FF 01 00 66 0F 6E C1 66 0F 73 F0 2D 83 C4 10 C3 66 0F 12 24 24 66 0F C5 D4 03 81 E2 F0 7F 00 00 81 EA F0 3F 00 00 66 0F C5 C1 03 33 C2 25 00 80 00 00 83 F8 00 0F 85 3B FF FF FF E9 59 FF FF FF 66 0F D6 04 24 66 0F D6 4C 24 08 E8 ?? ?? ?? ?? DD 1C 24 F3 0F 7E 04 24 83 C4 10 C3 }
	condition:
		$1
}

rule file_65_0_0 {
	meta:
		name = "___vdecl_sin2"
		size = 18
		refs = "0002 ___isa_available 0009 ___sse4_sin2 000e ___sse2_sin2"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1045_0_0 {
	meta:
		name = "___vdecl_cos2"
		size = 18
		refs = "0002 ___isa_available 0009 ___sse4_cos2 000e ___sse2_cos2"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_874_0_0 {
	meta:
		name = "___vdecl_cosf4"
		size = 18
		refs = "0002 ___isa_available 0009 ___sse4_cosf4 000e ___sse2_cosf4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_136_0_0 {
	meta:
		name = "___vdecl_exp2"
		size = 18
		refs = "0002 ___isa_available 0009 ___sse4_exp2 000e ___sse2_exp2"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_496_0_0 {
	meta:
		name = "___vdecl_expf4"
		size = 18
		refs = "0002 ___isa_available 0009 ___sse4_expf4 000e ___sse2_expf4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1101_0_0 {
	meta:
		name = "___vdecl_sinf4"
		size = 18
		refs = "0002 ___isa_available 0009 ___sse4_sinf4 000e ___sse2_sinf4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_544_0_0 {
	meta:
		name = "___vdecl_tan2"
		size = 18
		refs = "0002 ___isa_available 0009 ___sse4_tan2 000e ___sse2_tan2"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_865_0_0 {
	meta:
		name = "___vdecl_tanf4"
		size = 18
		refs = "0002 ___isa_available 0009 ___sse4_tanf4 000e ___sse2_tanf4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_1_0 {
	meta:
		name = "?_set_new_mode@@YAHH@Z"
		size = 49
		refs = "0010 __errno 001b __invalid_parameter_noinfo 0025 __newmode"
	strings:
		$1 = { 55 8B EC 8B 4D 08 85 C9 74 1A 83 F9 01 74 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 A1 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "___DestructExceptionObject"
		size = 139
		refs = "0003 __sehtable$___DestructExceptionObject 0008 __SEH_prolog4 0053 ?_CallMemberFunction0@@YGXPAX0@Z 006d ?terminate@@YAXXZ 0086 __SEH_epilog4"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 85 C0 74 72 81 38 63 73 6D E0 75 6A 83 78 10 03 75 64 81 78 14 20 05 93 19 74 12 81 78 14 21 05 93 19 74 09 81 78 14 22 05 93 19 75 49 8B 48 1C 85 C9 74 42 8B 51 04 85 D2 74 27 83 65 FC 00 52 FF 70 18 E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF EB 25 33 C0 38 45 0C 0F 95 C0 C3 8B 65 E8 E8 ?? ?? ?? ?? F6 01 10 74 0F 8B 40 18 8B 08 85 C9 74 06 8B 01 51 FF 50 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_67_4_0 {
	meta:
		name = "??_Gbad_exception@std@@UAEPAXI@Z"
		size = 37
		refs = "0008 ??_7bad_exception@std@@6B@ 000d ??1exception@std@@UAE@XZ 0019 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_849_37_0 {
	meta:
		name = "??_GFreeThreadProxy@details@Concurrency@@UAEPAXI@Z"
		size = 37
		refs = "0008 ??_7FreeThreadProxy@details@Concurrency@@6B@ 000d ??1ThreadProxy@details@Concurrency@@UAE@XZ 0019 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_696_6_0 {
	meta:
		name = "??_GThreadVirtualProcessor@details@Concurrency@@UAEPAXI@Z"
		size = 37
		refs = "0008 ??_7ThreadVirtualProcessor@details@Concurrency@@6B@ 000d ??1VirtualProcessor@details@Concurrency@@UAE@XZ 0019 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_318_15_0 {
	meta:
		name = "??_G__non_rtti_object@std@@UAEPAXI@Z"
		size = 37
		refs = "0008 ??_7exception@std@@6B@ 000d ?_Tidy@exception@std@@AAEXXZ 0019 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_104_60_2 {
	meta:
		name = "??_Gbad_alloc@std@@UAEPAXI@Z"
		size = 37
		refs = "0008 ??_7bad_alloc@std@@6B@ 000d ??1exception@std@@UAE@XZ 0019 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_318_16_0 {
	meta:
		name = "??_Gbad_cast@std@@UAEPAXI@Z"
		size = 37
		refs = "0008 ??_7exception@std@@6B@ 000d ?_Tidy@exception@std@@AAEXXZ 0019 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_318_17_0 {
	meta:
		name = "??_Gbad_typeid@std@@UAEPAXI@Z"
		size = 37
		refs = "0008 ??_7exception@std@@6B@ 000d ?_Tidy@exception@std@@AAEXXZ 0019 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_318_18_0 {
	meta:
		name = "??_Gexception@std@@UAEPAXI@Z"
		size = 37
		refs = "0008 ??_7exception@std@@6B@ 000d ?_Tidy@exception@std@@AAEXXZ 0019 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_67_5_0 {
	meta:
		name = "?CallCatchBlock@@YAPAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PBU_s_FuncInfo@@PAXHK@Z"
		size = 462
		refs = "0003 __sehtable$?CallCatchBlock@@YAPAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PBU_s_FuncInfo@@PAXHK@Z 0008 __SEH_prolog4 002b __CreateFrameInfo 0035 __getptd 0083 ?_CallCatchBlock2@@YAPAXPAUEHRegistrationNode@@PBU_s_FuncInfo@@PAXHK@Z 0099 ?ExFilterRethrow@@YAHPAU_EXCEPTION_POINTERS@@@Z 011e ___FrameUnwindToState 0144 __SEH_epilog4 0159 __FindAndUnlinkFrame 01b4 __IsExceptionObjectToBeDestroyed 01c2 ___DestructExceptionObject"
	strings:
		$1 = { 6A 30 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 18 89 45 E4 33 DB 89 5D C8 8B 7D 0C 8B 47 FC 89 45 D8 8B 75 08 FF 76 18 8D 45 C0 50 E8 ?? ?? ?? ?? 59 59 89 45 D4 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 89 45 D0 E8 ?? ?? ?? ?? 8B 80 8C 00 00 00 89 45 CC E8 ?? ?? ?? ?? 89 B0 88 00 00 00 E8 ?? ?? ?? ?? 8B 4D 10 89 88 8C 00 00 00 89 5D FC 33 C0 40 89 45 10 89 45 FC FF 75 20 FF 75 1C FF 75 18 FF 75 14 57 E8 ?? ?? ?? ?? 83 C4 14 89 45 E4 89 5D FC E9 99 00 00 00 FF 75 EC E8 ?? ?? ?? ?? 59 C3 8B 65 E8 E8 ?? ?? ?? ?? 33 DB 89 98 AC 03 00 00 8B 55 14 8B 7D 0C 81 7A 04 80 00 00 00 7F 06 0F BE 4F 08 EB 03 8B 4F 08 89 4D E0 8B 42 10 89 45 18 8B C3 89 45 DC 39 42 0C 76 3F 8B F0 6B F6 14 8B 7A 10 3B 4C 3E 04 8B 7D 0C 7E 25 8B 55 18 3B 4C 16 08 8B 55 14 7F 19 6B C0 14 8B 4A 10 8B 44 08 04 40 89 45 E0 8B 4A 08 8B 0C C1 89 4D E0 EB 09 40 89 45 DC 3B 42 0C 72 C1 51 52 53 57 E8 ?? ?? ?? ?? 83 C4 10 89 5D E4 89 5D FC 8B 75 08 C7 45 FC FE FF FF FF C7 45 10 00 00 00 00 E8 0E 00 00 00 8B C7 E8 ?? ?? ?? ?? C3 8B 7D 0C 8B 75 08 8B 45 D8 89 47 FC FF 75 D4 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 8B 4D D0 89 88 88 00 00 00 E8 ?? ?? ?? ?? 8B 4D CC 89 88 8C 00 00 00 81 3E 63 73 6D E0 75 48 83 7E 10 03 75 42 81 7E 14 20 05 93 19 74 12 81 7E 14 21 05 93 19 74 09 81 7E 14 22 05 93 19 75 27 8B 7D E4 83 7D C8 00 75 21 85 FF 74 1D FF 76 18 E8 ?? ?? ?? ?? 59 85 C0 74 10 FF 75 10 56 E8 ?? ?? ?? ?? 59 59 EB 03 8B 7D E4 C3 }
	condition:
		$1
}

rule file_67_6_0 {
	meta:
		name = "?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z"
		size = 40
		refs = "0003 __ehhandler$?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z 0008 __EH_prolog3_catch 000d __getptd 001b ?_inconsistency@@YAXXZ 0024 ?unexpected@@YAXXZ"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 B8 94 00 00 00 00 74 05 E8 ?? ?? ?? ?? 83 65 FC 00 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_67_7_0 {
	meta:
		name = "__catch$?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z$0"
		size = 24
		refs = "0001 __getptd 0013 __CxxThrowException@8"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B 4D 08 6A 00 6A 00 89 88 94 00 00 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_67_8_0 {
	meta:
		name = "__ehhandler$?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_58_1 {
	meta:
		name = "__ehhandler$??$_Cancel@V?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@@?$task_completion_event@E@Concurrency@@QBE_NV?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@PAX@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Cancel@V?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@@?$task_completion_event@E@Concurrency@@QBE_NV?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@PAX@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_761_10_0 {
	meta:
		name = "__ehhandler$??$_Resetp@V__ExceptionPtr@@@?$shared_ptr@V__ExceptionPtr@@@std@@AAEXPAV__ExceptionPtr@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Resetp@V__ExceptionPtr@@@?$shared_ptr@V__ExceptionPtr@@@std@@AAEXPAV__ExceptionPtr@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_860_7_0 {
	meta:
		name = "__ehhandler$??0?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@ABVQuickBitSet@12@_NI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@ABVQuickBitSet@12@_NI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_240_2 {
	meta:
		name = "__ehhandler$??0?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@QAE@PAV?$ISource@W4agent_status@Concurrency@@@1@IPAV?$ITarget@I@1@ABV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@QAE@PAV?$ISource@W4agent_status@Concurrency@@@1@IPAV?$ITarget@I@1@ABV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_55_2 {
	meta:
		name = "__ehhandler$??0?$_Mpunct@D@std@@QAE@ABV_Locinfo@1@I_N1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Mpunct@D@std@@QAE@ABV_Locinfo@1@I_N1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_166_2 {
	meta:
		name = "__ehhandler$??0?$_Mpunct@G@std@@QAE@ABV_Locinfo@1@I_N1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Mpunct@G@std@@QAE@ABV_Locinfo@1@I_N1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_169_2 {
	meta:
		name = "__ehhandler$??0?$_Mpunct@_W@std@@QAE@ABV_Locinfo@1@I_N1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Mpunct@_W@std@@QAE@ABV_Locinfo@1@I_N1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_255_2 {
	meta:
		name = "__ehhandler$??0?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@PAV?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@PAV?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_258_2 {
	meta:
		name = "__ehhandler$??0?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@PAV?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@PAV?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_263_1 {
	meta:
		name = "__ehhandler$??0?$_SyncOriginator@I@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_SyncOriginator@I@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_267_1 {
	meta:
		name = "__ehhandler$??0?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_83_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_40_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_43_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_92_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBDI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBDI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_231_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_234_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@IG@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@IG@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_237_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBG@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBG@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_240_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBGI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBGI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_245_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_248_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@I_W@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@I_W@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_251_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_W@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_W@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_254_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_WI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_WI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_301_1 {
	meta:
		name = "__ehhandler$??0?$function@$$A6AXABI@Z@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6AXABI@Z@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_358_1 {
	meta:
		name = "__ehhandler$??0?$function@$$A6AXE@Z@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6AXE@Z@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_361_1 {
	meta:
		name = "__ehhandler$??0?$function@$$A6AXU?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Z@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6AXU?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Z@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_364_1 {
	meta:
		name = "__ehhandler$??0?$function@$$A6AXV?$task@X@Concurrency@@@Z@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6AXV?$task@X@Concurrency@@@Z@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_367_1 {
	meta:
		name = "__ehhandler$??0?$function@$$A6AXXZ@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6AXXZ@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_307_2 {
	meta:
		name = "__ehhandler$??0?$function@$$A6A_NABI@Z@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6A_NABI@Z@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_310_2 {
	meta:
		name = "__ehhandler$??0?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_63_1 {
	meta:
		name = "__ehhandler$??0?$numpunct@D@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$numpunct@D@std@@QAE@ABV_Locinfo@1@I_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_232_2 {
	meta:
		name = "__ehhandler$??0?$numpunct@G@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$numpunct@G@std@@QAE@ABV_Locinfo@1@I_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_235_2 {
	meta:
		name = "__ehhandler$??0?$numpunct@_W@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$numpunct@_W@std@@QAE@ABV_Locinfo@1@I_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_325_1 {
	meta:
		name = "__ehhandler$??0?$ordered_message_processor@I@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ordered_message_processor@I@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_328_2 {
	meta:
		name = "__ehhandler$??0?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_331_2 {
	meta:
		name = "__ehhandler$??0?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_335_2 {
	meta:
		name = "__ehhandler$??0?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_339_2 {
	meta:
		name = "__ehhandler$??0?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_343_2 {
	meta:
		name = "__ehhandler$??0?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_347_2 {
	meta:
		name = "__ehhandler$??0?$single_assignment@I@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$single_assignment@I@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_355_2 {
	meta:
		name = "__ehhandler$??0?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_361_2 {
	meta:
		name = "__ehhandler$??0?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_367_1 {
	meta:
		name = "__ehhandler$??0?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_374_1 {
	meta:
		name = "__ehhandler$??0?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_103_1 {
	meta:
		name = "__ehhandler$??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_238_2 {
	meta:
		name = "__ehhandler$??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_241_2 {
	meta:
		name = "__ehhandler$??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_553_14_0 {
	meta:
		name = "__ehhandler$??0ContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_887_8_0 {
	meta:
		name = "__ehhandler$??0MultiWaitBlockHolder@details@Concurrency@@QAE@_NI00@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0MultiWaitBlockHolder@details@Concurrency@@QAE@_NI00@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_178_16_0 {
	meta:
		name = "__ehhandler$??0ResourceManager@details@Concurrency@@AAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ResourceManager@details@Concurrency@@AAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_860_21_0 {
	meta:
		name = "__ehhandler$??0ScheduleGroupBase@details@Concurrency@@QAE@PAVSchedulerBase@12@PAVlocation@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ScheduleGroupBase@details@Concurrency@@QAE@PAVSchedulerBase@12@PAVlocation@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_449_6_0 {
	meta:
		name = "__ehhandler$??0SchedulerProxy@details@Concurrency@@QAE@PAUIScheduler@2@PAVResourceManager@12@ABVSchedulerPolicy@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0SchedulerProxy@details@Concurrency@@QAE@PAUIScheduler@2@PAVResourceManager@12@ABVSchedulerPolicy@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1003_10_0 {
	meta:
		name = "__ehhandler$??0SchedulingNode@details@Concurrency@@QAE@ABVQuickBitSet@12@KPAVSchedulingRing@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0SchedulingNode@details@Concurrency@@QAE@ABVQuickBitSet@12@KPAVSchedulingRing@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_301_6_0 {
	meta:
		name = "__ehhandler$??0Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@23@ABVQuickBitSet@23@II@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@23@ABVQuickBitSet@23@II@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_696_2_0 {
	meta:
		name = "__ehhandler$??0ThreadVirtualProcessor@details@Concurrency@@QAE@PAVSchedulingNode@12@PAUIVirtualProcessorRoot@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ThreadVirtualProcessor@details@Concurrency@@QAE@PAVSchedulingNode@12@PAUIVirtualProcessorRoot@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1155_2_0 {
	meta:
		name = "__ehhandler$??0TimerObj@?6??wait@Concurrency@@YAXI@Z@QAE@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0TimerObj@?6??wait@Concurrency@@YAXI@Z@QAE@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1183_6_0 {
	meta:
		name = "__ehhandler$??0TransmogrifiedPrimary@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0TransmogrifiedPrimary@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_538_3_0 {
	meta:
		name = "__ehhandler$??0UMSThreadVirtualProcessor@details@Concurrency@@QAE@PAVSchedulingNode@12@PAUIVirtualProcessorRoot@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0UMSThreadVirtualProcessor@details@Concurrency@@QAE@PAVSchedulingNode@12@PAUIVirtualProcessorRoot@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_251_6_0 {
	meta:
		name = "__ehhandler$??0WorkQueue@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0WorkQueue@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1116_10_0 {
	meta:
		name = "__ehhandler$??0_AsyncTaskCollection@details@Concurrency@@AAE@PAV_CancellationTokenState@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_AsyncTaskCollection@details@Concurrency@@AAE@PAV_CancellationTokenState@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_380_1 {
	meta:
		name = "__ehhandler$??0_Blocking_recipient@?1???$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@std@@@Z@QAE@0ABV34@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Blocking_recipient@?1???$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@std@@@Z@QAE@0ABV34@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_384_1 {
	meta:
		name = "__ehhandler$??0_Blocking_recipient@?1???$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@std@@@Z@QAE@0I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Blocking_recipient@?1???$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@std@@@Z@QAE@0I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_390_2 {
	meta:
		name = "__ehhandler$??0_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z@QAE@0ABV45@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z@QAE@0ABV45@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_394_1 {
	meta:
		name = "__ehhandler$??0_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z@QAE@0I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z@QAE@0I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_31_1 {
	meta:
		name = "__ehhandler$??0_Locimp@locale@std@@AAE@ABV012@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Locimp@locale@std@@AAE@ABV012@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_605_12_0 {
	meta:
		name = "__ehhandler$??0_Scoped_lock@_NonReentrantPPLLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Scoped_lock@_NonReentrantPPLLock@details@Concurrency@@QAE@AAV123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_605_15_0 {
	meta:
		name = "__ehhandler$??0_Scoped_lock@_ReentrantPPLLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Scoped_lock@_ReentrantPPLLock@details@Concurrency@@QAE@AAV123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1116_17_0 {
	meta:
		name = "__ehhandler$??0_TaskCollection@details@Concurrency@@AAE@PAV012@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_TaskCollection@details@Concurrency@@AAE@PAV012@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1116_20_0 {
	meta:
		name = "__ehhandler$??0_TaskCollection@details@Concurrency@@QAE@PAV_CancellationTokenState@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_TaskCollection@details@Concurrency@@QAE@PAV_CancellationTokenState@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1116_23_0 {
	meta:
		name = "__ehhandler$??0_TaskCollection@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_TaskCollection@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_401_1 {
	meta:
		name = "__ehhandler$??0_TaskProcThunk@details@Concurrency@@QAE@ABV?$function@$$A6AXXZ@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_TaskProcThunk@details@Concurrency@@QAE@ABV?$function@$$A6AXXZ@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_605_23_0 {
	meta:
		name = "__ehhandler$??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_605_26_0 {
	meta:
		name = "__ehhandler$??0scoped_lock@reader_writer_lock@Concurrency@@QAE@AAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0scoped_lock@reader_writer_lock@Concurrency@@QAE@AAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_38_1 {
	meta:
		name = "__ehhandler$??0sentry@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@AAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0sentry@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@AAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_91_39_1 {
	meta:
		name = "__ehhandler$??0sentry@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@AAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0sentry@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@AAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_73_39_1 {
	meta:
		name = "__ehhandler$??0sentry@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@AAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0sentry@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@AAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_860_47_0 {
	meta:
		name = "__ehhandler$??1?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_424_1 {
	meta:
		name = "__ehhandler$??1?$_AnonymousOriginator@I@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_AnonymousOriginator@I@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_427_2 {
	meta:
		name = "__ehhandler$??1?$_AnonymousOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_AnonymousOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_453_2 {
	meta:
		name = "__ehhandler$??1?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_457_2 {
	meta:
		name = "__ehhandler$??1?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_374_2 {
	meta:
		name = "__ehhandler$??1?$_RunAnyParam@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_RunAnyParam@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_460_1 {
	meta:
		name = "__ehhandler$??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_463_2 {
	meta:
		name = "__ehhandler$??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_469_1 {
	meta:
		name = "__ehhandler$??1?$_SyncOriginator@I@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_SyncOriginator@I@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_475_1 {
	meta:
		name = "__ehhandler$??1?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_479_2 {
	meta:
		name = "__ehhandler$??1?$call@IV?$function@$$A6AXABI@Z@std@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$call@IV?$function@$$A6AXABI@Z@std@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_482_2 {
	meta:
		name = "__ehhandler$??1?$concurrent_queue@PAV?$message@I@Concurrency@@V?$allocator@PAV?$message@I@Concurrency@@@std@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$concurrent_queue@PAV?$message@I@Concurrency@@V?$allocator@PAV?$message@I@Concurrency@@@std@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_485_2 {
	meta:
		name = "__ehhandler$??1?$concurrent_queue@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$concurrent_queue@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_512_1 {
	meta:
		name = "__ehhandler$??1?$ordered_message_processor@I@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$ordered_message_processor@I@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_519_1 {
	meta:
		name = "__ehhandler$??1?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_522_2 {
	meta:
		name = "__ehhandler$??1?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_527_2 {
	meta:
		name = "__ehhandler$??1?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_532_2 {
	meta:
		name = "__ehhandler$??1?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_537_1 {
	meta:
		name = "__ehhandler$??1?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_541_1 {
	meta:
		name = "__ehhandler$??1?$single_assignment@I@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$single_assignment@I@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_549_1 {
	meta:
		name = "__ehhandler$??1?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_555_1 {
	meta:
		name = "__ehhandler$??1?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_561_2 {
	meta:
		name = "__ehhandler$??1?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_565_1 {
	meta:
		name = "__ehhandler$??1?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_569_2 {
	meta:
		name = "__ehhandler$??1?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_574_1 {
	meta:
		name = "__ehhandler$??1?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_109_17_0 {
	meta:
		name = "__ehhandler$??1ExternalContextBase@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1ExternalContextBase@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_709_25_0 {
	meta:
		name = "__ehhandler$??1InternalContextBase@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1InternalContextBase@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_178_37_0 {
	meta:
		name = "__ehhandler$??1ResourceManager@details@Concurrency@@AAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1ResourceManager@details@Concurrency@@AAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_860_56_0 {
	meta:
		name = "__ehhandler$??1ScheduleGroupSegmentBase@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1ScheduleGroupSegmentBase@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_765_96_0 {
	meta:
		name = "__ehhandler$??1SchedulerBase@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1SchedulerBase@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_449_16_0 {
	meta:
		name = "__ehhandler$??1SchedulerProxy@details@Concurrency@@IAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1SchedulerProxy@details@Concurrency@@IAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1003_19_0 {
	meta:
		name = "__ehhandler$??1SchedulingNode@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1SchedulingNode@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_829_12_0 {
	meta:
		name = "__ehhandler$??1SchedulingRing@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1SchedulingRing@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_849_27_0 {
	meta:
		name = "__ehhandler$??1ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1183_14_0 {
	meta:
		name = "__ehhandler$??1TransmogrifiedPrimary@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1TransmogrifiedPrimary@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_849_31_0 {
	meta:
		name = "__ehhandler$??1UMSFreeThreadProxyFactory@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1UMSFreeThreadProxyFactory@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_356_12_0 {
	meta:
		name = "__ehhandler$??1UMSSchedulerProxy@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1UMSSchedulerProxy@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_92_20_0 {
	meta:
		name = "__ehhandler$??1VirtualProcessor@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1VirtualProcessor@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1116_35_0 {
	meta:
		name = "__ehhandler$??1_AsyncTaskCollection@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_AsyncTaskCollection@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_887_27_0 {
	meta:
		name = "__ehhandler$??1_Condition_variable@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Condition_variable@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_397_2 {
	meta:
		name = "__ehhandler$??1_ExceptionHolder@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_ExceptionHolder@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_590_1 {
	meta:
		name = "__ehhandler$??1agent@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1agent@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1116_53_0 {
	meta:
		name = "__ehhandler$??_G_AsyncTaskCollection@details@Concurrency@@UAEPAXI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??_G_AsyncTaskCollection@details@Concurrency@@UAEPAXI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_449_29_0 {
	meta:
		name = "__ehhandler$?AddExecutionResource@SchedulerProxy@details@Concurrency@@QAEXPAVExecutionResource@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AddExecutionResource@SchedulerProxy@details@Concurrency@@QAEXPAVExecutionResource@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_709_51_0 {
	meta:
		name = "__ehhandler$?Alloc@InternalContextBase@details@Concurrency@@UAEPAXI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Alloc@InternalContextBase@details@Concurrency@@UAEPAXI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_765_148_0 {
	meta:
		name = "__ehhandler$?AllocateSegment@CacheLocalScheduleGroup@details@Concurrency@@MAEPAVScheduleGroupSegmentBase@23@PAVSchedulingRing@23@PAVlocation@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AllocateSegment@CacheLocalScheduleGroup@details@Concurrency@@MAEPAVScheduleGroupSegmentBase@23@PAVSchedulingRing@23@PAVlocation@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1080_16_0 {
	meta:
		name = "__ehhandler$?BeginTransmogrifying@Transmogrificator@details@Concurrency@@AAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?BeginTransmogrifying@Transmogrificator@details@Concurrency@@AAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_765_164_0 {
	meta:
		name = "__ehhandler$?CheckStaticConstruction@SchedulerBase@details@Concurrency@@CAXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CheckStaticConstruction@SchedulerBase@details@Concurrency@@CAXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_849_49_0 {
	meta:
		name = "__ehhandler$?Create@FreeThreadProxyFactory@details@Concurrency@@EAEPAVFreeThreadProxy@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Create@FreeThreadProxyFactory@details@Concurrency@@EAEPAVFreeThreadProxy@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1070_19_0 {
	meta:
		name = "__ehhandler$?Create@ThreadScheduler@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Create@ThreadScheduler@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_809_19_0 {
	meta:
		name = "__ehhandler$?Create@UMSThreadScheduler@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Create@UMSThreadScheduler@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_449_43_0 {
	meta:
		name = "__ehhandler$?CreateExternalThreadResource@SchedulerProxy@details@Concurrency@@QAEPAVExecutionResource@23@PAUSchedulerNode@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateExternalThreadResource@SchedulerProxy@details@Concurrency@@QAEPAVExecutionResource@23@PAUSchedulerNode@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_849_56_0 {
	meta:
		name = "__ehhandler$?CreateFactory@UMSFreeThreadProxyFactory@details@Concurrency@@SAPAV123@PAVThreadProxyFactoryManager@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateFactory@UMSFreeThreadProxyFactory@details@Concurrency@@SAPAV123@PAVThreadProxyFactoryManager@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1070_22_0 {
	meta:
		name = "__ehhandler$?CreateInternalContext@ThreadScheduler@details@Concurrency@@MAEPAVInternalContextBase@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateInternalContext@ThreadScheduler@details@Concurrency@@MAEPAVInternalContextBase@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_809_22_0 {
	meta:
		name = "__ehhandler$?CreateInternalContext@UMSThreadScheduler@details@Concurrency@@MAEPAVInternalContextBase@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateInternalContext@UMSThreadScheduler@details@Concurrency@@MAEPAVInternalContextBase@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_178_79_0 {
	meta:
		name = "__ehhandler$?CreateSchedulerProxy@ResourceManager@details@Concurrency@@AAEPAVSchedulerProxy@23@PAUIScheduler@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateSchedulerProxy@ResourceManager@details@Concurrency@@AAEPAVSchedulerProxy@23@PAUIScheduler@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_553_76_0 {
	meta:
		name = "__ehhandler$?CreateStructuredWorkQueue@ContextBase@details@Concurrency@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateStructuredWorkQueue@ContextBase@details@Concurrency@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1070_27_0 {
	meta:
		name = "__ehhandler$?CreateVirtualProcessor@ThreadScheduler@details@Concurrency@@UAEPAVVirtualProcessor@23@PAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateVirtualProcessor@ThreadScheduler@details@Concurrency@@UAEPAVVirtualProcessor@23@PAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_809_27_0 {
	meta:
		name = "__ehhandler$?CreateVirtualProcessor@UMSThreadScheduler@details@Concurrency@@UAEPAVVirtualProcessor@23@PAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateVirtualProcessor@UMSThreadScheduler@details@Concurrency@@UAEPAVVirtualProcessor@23@PAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_449_49_0 {
	meta:
		name = "__ehhandler$?CreateVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@UAEPAVVirtualProcessorRoot@23@PAUSchedulerNode@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@UAEPAVVirtualProcessorRoot@23@PAUSchedulerNode@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_356_27_0 {
	meta:
		name = "__ehhandler$?CreateVirtualProcessorRoot@UMSSchedulerProxy@details@Concurrency@@UAEPAVVirtualProcessorRoot@23@PAUSchedulerNode@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateVirtualProcessorRoot@UMSSchedulerProxy@details@Concurrency@@UAEPAVVirtualProcessorRoot@23@PAUSchedulerNode@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_553_79_0 {
	meta:
		name = "__ehhandler$?CreateWorkQueue@ContextBase@details@Concurrency@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateWorkQueue@ContextBase@details@Concurrency@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_449_59_0 {
	meta:
		name = "__ehhandler$?DestroyVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@QAEXPAVVirtualProcessorRoot@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?DestroyVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@QAEXPAVVirtualProcessorRoot@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_765_229_0 {
	meta:
		name = "__ehhandler$?GetBitSet@SchedulerBase@details@Concurrency@@QAE?AVQuickBitSet@23@PBVlocation@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetBitSet@SchedulerBase@details@Concurrency@@QAE?AVQuickBitSet@23@PBVlocation@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_178_112_0 {
	meta:
		name = "__ehhandler$?GetCoreCount@ResourceManager@details@Concurrency@@SAIXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetCoreCount@ResourceManager@details@Concurrency@@SAIXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_765_242_0 {
	meta:
		name = "__ehhandler$?GetExternalContext@SchedulerBase@details@Concurrency@@AAEPAVExternalContextBase@23@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetExternalContext@SchedulerBase@details@Concurrency@@AAEPAVExternalContextBase@23@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_849_75_0 {
	meta:
		name = "__ehhandler$?GetFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QAEPAVFreeThreadProxyFactory@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QAEPAVFreeThreadProxyFactory@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_178_130_0 {
	meta:
		name = "__ehhandler$?GetNodeCount@ResourceManager@details@Concurrency@@SAIXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetNodeCount@ResourceManager@details@Concurrency@@SAIXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_849_83_0 {
	meta:
		name = "__ehhandler$?GetUMSFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QAEPAVUMSFreeThreadProxyFactory@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetUMSFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QAEPAVUMSFreeThreadProxyFactory@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_301_28_0 {
	meta:
		name = "__ehhandler$?Grow@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@AAEPAUSegment@123@PAU4123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Grow@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@AAEPAUSegment@123@PAU4123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_178_183_0 {
	meta:
		name = "__ehhandler$?Release@ResourceManager@details@Concurrency@@UAEIXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Release@ResourceManager@details@Concurrency@@UAEIXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_449_100_0 {
	meta:
		name = "__ehhandler$?RemoveCore@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?RemoveCore@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_765_379_0 {
	meta:
		name = "__ehhandler$?ResetDefaultSchedulerPolicy@SchedulerBase@details@Concurrency@@SAXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?ResetDefaultSchedulerPolicy@SchedulerBase@details@Concurrency@@SAXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_765_407_0 {
	meta:
		name = "__ehhandler$?StaticDestruction@SchedulerBase@details@Concurrency@@CAXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?StaticDestruction@SchedulerBase@details@Concurrency@@CAXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1003_65_0 {
	meta:
		name = "__ehhandler$?Steal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Steal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_251_46_0 {
	meta:
		name = "__ehhandler$?Steal@WorkQueue@details@Concurrency@@QAEPAV_UnrealizedChore@23@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Steal@WorkQueue@details@Concurrency@@QAEPAV_UnrealizedChore@23@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_178_216_0 {
	meta:
		name = "__ehhandler$?SubscribeCurrentThread@ResourceManager@details@Concurrency@@QAEPAVExecutionResource@23@PAVSchedulerProxy@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?SubscribeCurrentThread@ResourceManager@details@Concurrency@@QAEPAVExecutionResource@23@PAVSchedulerProxy@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_178_224_0 {
	meta:
		name = "__ehhandler$?Version@ResourceManager@details@Concurrency@@SA?AW4OSVersion@IResourceManager@3@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Version@ResourceManager@details@Concurrency@@SA?AW4OSVersion@IResourceManager@3@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1116_112_0 {
	meta:
		name = "__ehhandler$?_Alias@_TaskCollection@details@Concurrency@@AAEPAV123@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Alias@_TaskCollection@details@Concurrency@@AAEPAV123@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_761_75_0 {
	meta:
		name = "__ehhandler$?_CallCopyCtor@__ExceptionPtr@@ABEXPAX0IQBU_s_CatchableType@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CallCopyCtor@__ExceptionPtr@@ABEXPAX0IQBU_s_CatchableType@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_380_10_0 {
	meta:
		name = "__ehhandler$?_Current_exception@exception_ptr@std@@SA?AV12@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Current_exception@exception_ptr@std@@SA?AV12@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_92_81_2 {
	meta:
		name = "__ehhandler$?_Init@locale@std@@CAPAV_Locimp@12@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@locale@std@@CAPAV_Locimp@12@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_215_2 {
	meta:
		name = "__ehhandler$?_Locimp_Addfac@_Locimp@locale@std@@CAXPAV123@PAVfacet@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Locimp_Addfac@_Locimp@locale@std@@CAXPAV123@PAVfacet@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_92_86_2 {
	meta:
		name = "__ehhandler$?_Locimp_dtor@_Locimp@locale@std@@CAXPAV123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Locimp_dtor@_Locimp@locale@std@@CAXPAV123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_225_2 {
	meta:
		name = "__ehhandler$?_Makeloc@_Locimp@locale@std@@CAPAV123@ABV_Locinfo@3@HPAV123@PBV23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Makeloc@_Locimp@locale@std@@CAPAV123@ABV_Locinfo@3@HPAV123@PBV23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1116_160_0 {
	meta:
		name = "__ehhandler$?_NewCollection@_AsyncTaskCollection@details@Concurrency@@SAPAV123@PAV_CancellationTokenState@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_NewCollection@_AsyncTaskCollection@details@Concurrency@@SAPAV123@PAV_CancellationTokenState@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_145_56_0 {
	meta:
		name = "__ehhandler$?_NewTokenState@_CancellationTokenState@details@Concurrency@@SAPAV123@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_NewTokenState@_CancellationTokenState@details@Concurrency@@SAPAV123@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_92_93_2 {
	meta:
		name = "__ehhandler$?_New_Locimp@_Locimp@locale@std@@CAPAV123@ABV123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_New_Locimp@_Locimp@locale@std@@CAPAV123@ABV123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_91_1 {
	meta:
		name = "__ehhandler$?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_91_90_1 {
	meta:
		name = "__ehhandler$?_Osfx@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Osfx@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_96_75_2 {
	meta:
		name = "__ehhandler$?_Osfx@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Osfx@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_380_23_0 {
	meta:
		name = "__ehhandler$?_RaisedException@_TaskCollectionBase@details@Concurrency@@IAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_RaisedException@_TaskCollectionBase@details@Concurrency@@IAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_336_26_0 {
	meta:
		name = "__ehhandler$?_RegisterConcRTEventTracing@details@Concurrency@@YAXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_RegisterConcRTEventTracing@details@Concurrency@@YAXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_676_2 {
	meta:
		name = "__ehhandler$?_Rethrow_future_exception@std@@YAXVexception_ptr@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Rethrow_future_exception@std@@YAXVexception_ptr@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_694_2 {
	meta:
		name = "__ehhandler$?_ScheduleWithAutoInline@_AsyncTaskCollection@details@Concurrency@@QAE?AW4_TaskCollectionStatus@23@PAV_UnrealizedChore@23@W4_TaskInliningMode@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_ScheduleWithAutoInline@_AsyncTaskCollection@details@Concurrency@@QAE?AW4_TaskCollectionStatus@23@PAV_UnrealizedChore@23@W4_TaskInliningMode@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_365_2 {
	meta:
		name = "__ehhandler$?do_get_time@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_time@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_1050_1 {
	meta:
		name = "__ehhandler$?do_get_time@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_time@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_973_2 {
	meta:
		name = "__ehhandler$?do_get_time@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_time@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_369_2 {
	meta:
		name = "__ehhandler$?do_get_year@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_year@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_978_2 {
	meta:
		name = "__ehhandler$?do_get_year@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_year@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_1061_1 {
	meta:
		name = "__ehhandler$?do_get_year@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_year@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_397_2 {
	meta:
		name = "__ehhandler$?do_transform@?$collate@D@std@@MBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@PBD0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_transform@?$collate@D@std@@MBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@PBD0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_1077_2 {
	meta:
		name = "__ehhandler$?do_transform@?$collate@G@std@@MBE?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@PBG0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_transform@?$collate@G@std@@MBE?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@PBG0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_1080_2 {
	meta:
		name = "__ehhandler$?do_transform@?$collate@_W@std@@MBE?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@PB_W0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_transform@?$collate@_W@std@@MBE?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@PB_W0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_605_116_0 {
	meta:
		name = "__ehhandler$?try_lock_for@critical_section@Concurrency@@QAE_NI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?try_lock_for@critical_section@Concurrency@@QAE_NI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_73_305_2 {
	meta:
		name = "__ehhandler$?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QBEDD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QBEDD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_126_315_2 {
	meta:
		name = "__ehhandler$?widen@?$basic_ios@GU?$char_traits@G@std@@@std@@QBEGD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?widen@?$basic_ios@GU?$char_traits@G@std@@@std@@QBEGD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_341_1 {
	meta:
		name = "__ehhandler$?widen@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QBE_WD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?widen@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QBE_WD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_42_126_1 {
	meta:
		name = "__ehhandler$__Call_func@4"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$__Call_func@4 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_67_9_0 {
	meta:
		name = "?CatchIt@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@PBU_s_HandlerType@@PBU_s_CatchableType@@PBU_s_TryBlockMapEntry@@H1E@Z"
		size = 123
		refs = "0018 ___BuildCatchObject 002f ?_UnwindNestedFrames@@YGXPAUEHRegistrationNode@@PAUEHExceptionRecord@@@Z 0041 ___FrameUnwindToState 0065 ?CallCatchBlock@@YAPAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PBU_s_FuncInfo@@PAXHK@Z 0074 ?_JumpToContinuation@@YGXPAXPAUEHRegistrationNode@@@Z"
	strings:
		$1 = { 55 8B EC 83 7D 20 00 57 8B 7D 0C 74 12 FF 75 20 FF 75 1C 57 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 83 7D 2C 00 FF 75 08 75 03 57 EB 03 FF 75 2C E8 ?? ?? ?? ?? 56 8B 75 24 FF 36 FF 75 18 FF 75 14 57 E8 ?? ?? ?? ?? 8B 46 04 68 00 01 00 00 FF 75 28 40 89 47 08 8B 45 1C FF 70 0C FF 75 18 FF 75 10 57 FF 75 08 E8 ?? ?? ?? ?? 83 C4 2C 5E 85 C0 74 07 57 50 E8 ?? ?? ?? ?? 5F 5D C3 }
	condition:
		$1
}

rule file_67_10_0 {
	meta:
		name = "?ExFilterRethrow@@YAHPAU_EXCEPTION_POINTERS@@@Z"
		size = 77
		refs = "0038 __getptd"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 00 81 38 63 73 6D E0 75 39 83 78 10 03 75 33 81 78 14 20 05 93 19 74 12 81 78 14 21 05 93 19 74 09 81 78 14 22 05 93 19 75 18 83 78 1C 00 75 12 E8 ?? ?? ?? ?? 33 C9 41 89 88 AC 03 00 00 8B C1 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_67_11_0 {
	meta:
		name = "?FindHandler@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@EH1@Z"
		size = 923
		refs = "0037 ?_inconsistency@@YAXXZ 007d __getptd 00ae ?_ValidateRead@@YAHPBXI@Z 011b ?IsInExceptionSpec@@YAEPAUEHExceptionRecord@@PBU_s_ESTypeList@@@Z 0139 ??_R0?AVbad_exception@std@@@8 0142 ??8type_info@@QBE_NABV0@@Z 01ba ?_GetRangeOfTrysToCheck@@YAPBU_s_TryBlockMapEntry@@PBU_s_FuncInfo@@HHPAI1@Z 0222 ___TypeMatch 0277 ?CatchIt@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@PBU_s_HandlerType@@PBU_s_CatchableType@@PBU_s_TryBlockMapEntry@@H1E@Z 02a6 ___DestructExceptionObject 0324 ?FindHandlerForForeignException@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@HH1@Z 0343 ?terminate@@YAXXZ 035b ??_C@_0O@DPKOEFFH@bad?5exception?$AA@ 0360 ??0exception@std@@QAE@ABQBD@Z 0365 __TI2?AVbad_exception@std@@ 0370 ??_7bad_exception@std@@6B@ 0375 __CxxThrowException@8 037d ?_UnwindNestedFrames@@YGXPAUEHRegistrationNode@@PAUEHExceptionRecord@@@Z 038b ___FrameUnwindToState 0396 ?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 3C 8B 45 0C 53 56 57 8B 7D 18 33 DB 81 7F 04 80 00 00 00 88 5D DC 88 5D FF 7F 06 0F BE 40 08 EB 03 8B 40 08 89 45 F8 83 F8 FF 7C 05 3B 47 04 7C 05 E8 ?? ?? ?? ?? 8B 75 08 81 3E 63 73 6D E0 0F 85 BA 02 00 00 83 7E 10 03 0F 85 0D 01 00 00 81 7E 14 20 05 93 19 74 16 81 7E 14 21 05 93 19 74 0D 81 7E 14 22 05 93 19 0F 85 EE 00 00 00 39 5E 1C 0F 85 E5 00 00 00 E8 ?? ?? ?? ?? 39 98 88 00 00 00 0F 84 B0 02 00 00 E8 ?? ?? ?? ?? 8B B0 88 00 00 00 E8 ?? ?? ?? ?? 8B 80 8C 00 00 00 6A 01 56 89 45 08 C6 45 DC 01 E8 ?? ?? ?? ?? 59 59 85 C0 75 05 E8 ?? ?? ?? ?? 81 3E 63 73 6D E0 75 2B 83 7E 10 03 75 25 81 7E 14 20 05 93 19 74 12 81 7E 14 21 05 93 19 74 09 81 7E 14 22 05 93 19 75 0A 39 5E 1C 75 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 39 98 94 00 00 00 74 6C E8 ?? ?? ?? ?? 8B 80 94 00 00 00 89 45 EC E8 ?? ?? ?? ?? FF 75 EC 89 98 94 00 00 00 56 E8 ?? ?? ?? ?? 59 59 84 C0 75 44 8B 7D EC 39 1F 0F 8E 12 02 00 00 8B C3 89 5D 18 8B 4F 04 68 ?? ?? ?? ?? 8B 4C 08 04 E8 ?? ?? ?? ?? 84 C0 0F 85 F9 01 00 00 8B 45 18 43 83 C0 10 89 45 18 3B 1F 7C D9 E9 E1 01 00 00 8B 45 10 89 45 08 EB 03 8B 45 08 81 3E 63 73 6D E0 0F 85 8F 01 00 00 83 7E 10 03 0F 85 85 01 00 00 81 7E 14 20 05 93 19 74 16 81 7E 14 21 05 93 19 74 0D 81 7E 14 22 05 93 19 0F 85 66 01 00 00 39 5F 0C 0F 86 F2 00 00 00 8D 45 D8 50 8D 45 F0 50 FF 75 F8 FF 75 20 57 E8 ?? ?? ?? ?? 8B 4D F0 83 C4 14 3B 4D D8 0F 83 CF 00 00 00 8D 50 10 8B 45 F8 89 55 EC 8D 5A F0 89 5D D4 8B 5D 0C 39 42 F0 0F 8F 9F 00 00 00 3B 42 F4 0F 8F 96 00 00 00 8B 3A 89 7D F4 8B 7A FC 89 7D E0 85 FF 8B 7D 18 0F 8E 80 00 00 00 8B 4D F4 8B 46 1C 8B 40 0C 8D 50 04 8B 00 EB 23 FF 76 1C 8B 02 50 51 89 45 D0 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 2A 8B 45 E8 8B 55 E4 8B 4D F4 48 83 C2 04 89 45 E8 89 55 E4 85 C0 7F D3 8B 45 E0 48 83 C1 10 89 45 E0 89 4D F4 85 C0 7F B5 EB 27 FF 75 DC C6 45 FF 01 FF 75 24 FF 75 20 FF 75 D4 FF 75 D0 FF 75 F4 57 FF 75 14 FF 75 08 53 56 E8 ?? ?? ?? ?? 83 C4 2C 8B 55 EC 8B 45 F8 8B 4D F0 41 83 C2 14 89 4D F0 89 55 EC 3B 4D D8 0F 82 3C FF FF FF 33 DB 80 7D 1C 00 74 0A 6A 01 56 E8 ?? ?? ?? ?? 59 59 80 7D FF 00 75 79 8B 07 25 FF FF FF 1F 3D 21 05 93 19 72 6B 83 7F 1C 00 74 65 FF 77 1C 56 E8 ?? ?? ?? ?? 59 59 84 C0 75 56 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 B0 88 00 00 00 E8 ?? ?? ?? ?? 83 7D 24 00 8B 4D 08 89 88 8C 00 00 00 56 75 7A FF 75 0C EB 78 8B 45 10 39 5F 0C 76 1F 38 5D 1C 75 31 FF 75 24 FF 75 20 FF 75 F8 57 FF 75 14 50 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 20 E8 ?? ?? ?? ?? 39 98 94 00 00 00 74 05 E8 ?? ?? ?? ?? 5F 5E 5B C9 C3 E8 ?? ?? ?? ?? 6A 01 56 E8 ?? ?? ?? ?? 59 59 8D 45 18 50 8D 4D C4 C7 45 18 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 C4 50 C7 45 C4 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 75 24 E8 ?? ?? ?? ?? 6A FF 57 FF 75 14 FF 75 0C E8 ?? ?? ?? ?? 83 C4 10 FF 77 1C E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_67_12_0 {
	meta:
		name = "?FindHandlerForForeignException@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@HH1@Z"
		size = 282
		refs = "0018 __getptd 002c __imp__EncodePointer@4 0061 ?_CallSETranslator@@YAHPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAX2PBU_s_FuncInfo@@H1@Z 0077 ?_inconsistency@@YAXXZ 008b ?_GetRangeOfTrysToCheck@@YAPBU_s_TryBlockMapEntry@@PBU_s_FuncInfo@@HHPAI1@Z 00fa ?CatchIt@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@PBU_s_HandlerType@@PBU_s_CatchableType@@PBU_s_TryBlockMapEntry@@H1E@Z"
	strings:
		$1 = { 55 8B EC 51 51 57 8B 7D 08 81 3F 03 00 00 80 0F 84 02 01 00 00 53 56 E8 ?? ?? ?? ?? 83 B8 80 00 00 00 00 8B 5D 18 74 48 6A 00 FF 15 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 39 B0 80 00 00 00 74 31 81 3F 4D 4F 43 E0 74 29 81 3F 52 43 43 E0 74 21 FF 75 24 FF 75 20 53 FF 75 14 FF 75 10 FF 75 0C 57 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 0F 85 A5 00 00 00 83 7B 0C 00 75 05 E8 ?? ?? ?? ?? 8D 45 FC 50 8D 45 F8 50 FF 75 1C FF 75 20 53 E8 ?? ?? ?? ?? 8B 4D F8 8B 55 FC 83 C4 14 3B CA 73 79 8D 70 0C 8B 45 1C 3B 46 F4 7C 63 3B 46 F8 7F 5E 8B 06 8B 7E 04 C1 E0 04 8B 7C 07 F4 85 FF 74 13 8B 56 04 8B 5C 02 F4 8B 55 FC 80 7B 08 00 8B 5D 18 75 38 8B 7E 04 83 C7 F0 03 C7 8B 7D 08 F6 00 40 75 28 6A 01 FF 75 24 8D 4E F4 FF 75 20 51 6A 00 50 53 FF 75 14 FF 75 10 FF 75 0C 57 E8 ?? ?? ?? ?? 8B 55 FC 8B 4D F8 83 C4 2C 8B 45 1C 41 83 C6 14 89 4D F8 3B CA 72 8D 5E 5B 5F C9 C3 }
	condition:
		$1
}

rule file_67_13_0 {
	meta:
		name = "?IsInExceptionSpec@@YAEPAUEHExceptionRecord@@PBU_s_ESTypeList@@@Z"
		size = 134
		refs = "0043 ___TypeMatch 007c ?_inconsistency@@YAXXZ 0081 ?terminate@@YAXXZ"
	strings:
		$1 = { 55 8B EC 51 51 53 56 8B 75 0C 57 85 F6 74 6C 33 DB 8B FB 39 1E 7E 5D 8B CB 89 5D 0C 8B 45 08 8B 40 1C 8B 40 0C 8D 50 04 8B 00 89 55 F8 89 45 FC 85 C0 7E 35 8B 45 08 FF 70 1C 8B 46 04 FF 32 03 C1 50 E8 ?? ?? ?? ?? 8B 4D 0C 83 C4 0C 85 C0 75 16 8B 45 FC 8B 55 F8 48 83 C2 04 89 45 FC 89 55 F8 85 C0 7F CF EB 02 B3 01 47 83 C1 10 89 4D 0C 3B 3E 7C A8 5F 5E 8A C3 5B C9 C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_67_14_0 {
	meta:
		name = "?Is_bad_exception_allowed@@YAEPBU_s_ESTypeList@@@Z"
		size = 57
		refs = "0015 ??_R0?AVbad_exception@std@@@8 001e ??8type_info@@QBE_NABV0@@Z"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 7D 08 33 F6 39 37 7E 1F 8B DE 8B 4F 04 68 ?? ?? ?? ?? 8B 4C 0B 04 E8 ?? ?? ?? ?? 84 C0 75 0F 46 83 C3 10 3B 37 7C E3 32 C0 5F 5E 5B 5D C3 B0 01 EB F7 }
	condition:
		$1
}

rule file_67_15_0 {
	meta:
		name = "?__uncaught_exception@@YA_NXZ"
		size = 17
		refs = "0001 __getptd"
	strings:
		$1 = { E8 ?? ?? ?? ?? 33 C9 39 88 90 00 00 00 0F 95 C0 C3 }
	condition:
		$1
}

rule file_67_16_0 {
	meta:
		name = "?_is_exception_typeof@@YAHABVtype_info@@PAU_EXCEPTION_POINTERS@@@Z"
		size = 135
		refs = "000d ?_inconsistency@@YAXXZ 0064 ?raw_name@type_info@@QBEPBDXZ 006a _strcmp"
	strings:
		$1 = { 55 8B EC 56 8B 75 0C 57 85 F6 75 05 E8 ?? ?? ?? ?? 8B 36 85 F6 75 05 E8 ?? ?? ?? ?? 81 3E 63 73 6D E0 75 21 83 7E 10 03 75 1B 81 7E 14 20 05 93 19 74 17 81 7E 14 21 05 93 19 74 0E 81 7E 14 22 05 93 19 74 05 E8 ?? ?? ?? ?? 8B 46 1C 8B 40 0C 8B 30 8D 78 04 EB 21 8B 07 8B 4D 08 8B 40 04 83 C0 08 50 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 0E 4E 83 C7 04 85 F6 7F DB 33 C0 5F 5E 5D C3 33 C0 40 EB F7 }
	condition:
		$1
}

rule file_67_17_0 {
	meta:
		name = "___AdjustPointer"
		size = 37
	strings:
		$1 = { 55 8B EC 8B 4D 0C 8B 55 08 8B 01 56 8B 71 04 03 C2 85 F6 78 0D 8B 49 08 8B 14 16 8B 0C 0A 03 CE 03 C1 5E 5D C3 }
	condition:
		$1
}

rule file_67_18_0 {
	meta:
		name = "___BuildCatchObject"
		size = 142
		refs = "0003 __sehtable$___BuildCatchObject 0008 __SEH_prolog4 0033 ___BuildCatchObjectHelper 004a ___AdjustPointer 0056 ?_CallMemberFunction2@@YGXPAX00H@Z 0070 ?_CallMemberFunction1@@YGXPAX00@Z 007c __SEH_epilog4 0089 ?terminate@@YAXXZ"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 10 8B 4D 0C F7 02 00 00 00 80 74 04 8B F9 EB 06 8D 79 0C 03 7A 08 83 65 FC 00 8B 75 14 56 52 51 8B 5D 08 53 E8 ?? ?? ?? ?? 83 C4 10 48 74 1F 48 75 34 6A 01 8D 46 08 50 FF 73 18 E8 ?? ?? ?? ?? 59 59 50 FF 76 18 57 E8 ?? ?? ?? ?? EB 18 8D 46 08 50 FF 73 18 E8 ?? ?? ?? ?? 59 59 50 FF 76 18 57 E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF E8 ?? ?? ?? ?? C3 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_67_19_0 {
	meta:
		name = "___BuildCatchObjectHelper"
		size = 389
		refs = "0003 __sehtable$___BuildCatchObjectHelper 0008 __SEH_prolog4 0057 ?_ValidateRead@@YAHPBXI@Z 0069 ?_ValidateWrite@@YAHPAXI@Z 0085 ___AdjustPointer 00cc _memmove 0149 ?_ValidateExecute@@YAHP6GHXZ@Z 0162 ?_inconsistency@@YAXXZ 0179 ?terminate@@YAXXZ 0180 __SEH_epilog4"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 8B 45 10 8B 48 04 85 C9 0F 84 61 01 00 00 38 59 08 0F 84 58 01 00 00 8B 48 08 85 C9 75 0C F7 00 00 00 00 80 0F 84 45 01 00 00 8B 10 8B 7D 0C 85 D2 78 05 83 C7 0C 03 F9 89 5D FC 6A 01 F6 C2 08 74 42 8B 75 08 FF 76 18 E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 FC 00 00 00 6A 01 57 E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 EA 00 00 00 8B 4E 18 89 0F 8B 45 14 83 C0 08 50 51 E8 ?? ?? ?? ?? 59 59 89 07 E9 D4 00 00 00 8B 75 14 8B 45 08 FF 70 18 F6 06 01 74 4E E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 B2 00 00 00 6A 01 57 E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 A0 00 00 00 FF 76 14 8B 45 08 FF 70 18 57 E8 ?? ?? ?? ?? 83 C4 0C 83 7E 14 04 0F 85 89 00 00 00 83 3F 00 0F 84 80 00 00 00 8D 46 08 50 FF 37 EB 96 39 5E 18 75 39 E8 ?? ?? ?? ?? 59 59 85 C0 74 63 6A 01 57 E8 ?? ?? ?? ?? 59 59 85 C0 74 55 FF 76 14 8D 46 08 50 8B 45 08 FF 70 18 E8 ?? ?? ?? ?? 59 59 50 57 E8 ?? ?? ?? ?? 83 C4 0C EB 3A E8 ?? ?? ?? ?? 59 59 85 C0 74 2A 6A 01 57 E8 ?? ?? ?? ?? 59 59 85 C0 74 1C FF 76 18 E8 ?? ?? ?? ?? 59 85 C0 74 0F F6 06 04 6A 00 5B 0F 95 C3 43 89 5D E4 EB 05 E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B C3 EB 0E 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 33 C0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_67_20_0 {
	meta:
		name = "___CxxDetectRethrow"
		size = 79
		refs = "003c __getptd"
	strings:
		$1 = { 55 8B EC 8B 45 08 85 C0 74 41 8B 00 81 38 63 73 6D E0 75 37 83 78 10 03 75 31 81 78 14 20 05 93 19 74 12 81 78 14 21 05 93 19 74 09 81 78 14 22 05 93 19 75 16 83 78 1C 00 75 10 E8 ?? ?? ?? ?? FF 80 90 00 00 00 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_67_21_0 {
	meta:
		name = "___CxxExceptionFilter"
		size = 344
		refs = "0086 __getptd 00c9 ___TypeMatch 00fb ___BuildCatchObject"
	strings:
		$1 = { 55 8B EC 83 EC 10 56 8B 75 08 85 F6 75 07 33 C0 E9 40 01 00 00 8B 36 53 8B 5D 10 57 8B 7D 0C 85 FF 74 06 80 7F 08 00 75 21 81 3E 4D 4F 43 E0 0F 84 CF 00 00 00 81 3E 52 43 43 E0 0F 84 C3 00 00 00 F6 C3 40 0F 84 BA 00 00 00 81 3E 63 73 6D E0 0F 85 EB 00 00 00 83 7E 10 03 0F 85 E1 00 00 00 81 7E 14 20 05 93 19 74 16 81 7E 14 21 05 93 19 74 0D 81 7E 14 22 05 93 19 0F 85 C2 00 00 00 83 7E 1C 00 75 1D E8 ?? ?? ?? ?? 83 B8 88 00 00 00 00 0F 84 AA 00 00 00 E8 ?? ?? ?? ?? 8B B0 88 00 00 00 8B 46 1C 81 CB 00 00 00 80 8B 40 0C 89 7D F4 8B 38 89 5D F0 8D 58 04 EB 1D 8B 03 FF 76 1C 89 45 08 50 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 0A 4F 83 C3 04 85 FF 7F DF EB 63 E8 ?? ?? ?? ?? FF 80 90 00 00 00 83 7D 14 00 74 61 FF 75 08 8D 45 F0 50 FF 75 14 56 E8 ?? ?? ?? ?? 83 C4 10 EB 4C 81 3E 63 73 6D E0 75 39 83 7E 10 03 75 33 81 7E 14 20 05 93 19 74 12 81 7E 14 21 05 93 19 74 09 81 7E 14 22 05 93 19 75 18 83 7E 1C 00 75 12 E8 ?? ?? ?? ?? 83 B8 88 00 00 00 00 75 04 33 C0 EB 0E E8 ?? ?? ?? ?? FF 80 90 00 00 00 33 C0 40 5F 5B 5E C9 C3 }
	condition:
		$1
}

rule file_67_23_0 {
	meta:
		name = "___CxxRegisterExceptionObject"
		size = 183
		refs = "0045 __getptd 0054 __CreateFrameInfo"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 57 8B 7D 0C 85 F6 74 74 8B 36 85 F6 74 6E 81 3E 63 73 6D E0 75 32 83 7E 10 03 75 2C 81 7E 14 20 05 93 19 74 12 81 7E 14 21 05 93 19 74 09 81 7E 14 22 05 93 19 75 11 83 7E 1C 00 75 0B E8 ?? ?? ?? ?? 8B B0 88 00 00 00 FF 76 18 57 E8 ?? ?? ?? ?? 59 59 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 89 47 08 E8 ?? ?? ?? ?? 8B 80 8C 00 00 00 89 47 0C E8 ?? ?? ?? ?? 89 B0 88 00 00 00 EB 08 83 4F 08 FF 83 4F 0C FF E8 ?? ?? ?? ?? FF 88 90 00 00 00 E8 ?? ?? ?? ?? 83 B8 90 00 00 00 00 5F 5E 7D 0C E8 ?? ?? ?? ?? 83 A0 90 00 00 00 00 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_67_24_0 {
	meta:
		name = "___CxxUnregisterExceptionObject"
		size = 317
		refs = "0014 __FindAndUnlinkFrame 0029 __getptd 0093 __IsExceptionObjectToBeDestroyed 00aa ___DestructExceptionObject"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 83 7E 08 FF 0F 84 29 01 00 00 53 56 E8 ?? ?? ?? ?? 83 7D 0C 00 59 BB 63 73 6D E0 0F 85 88 00 00 00 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 39 18 75 79 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 83 78 10 03 75 68 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 81 78 14 20 05 93 19 74 28 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 81 78 14 21 05 93 19 74 14 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 81 78 14 22 05 93 19 75 2C E8 ?? ?? ?? ?? 8B 80 88 00 00 00 FF 70 18 E8 ?? ?? ?? ?? 59 85 C0 74 14 6A 01 E8 ?? ?? ?? ?? FF B0 88 00 00 00 E8 ?? ?? ?? ?? 59 59 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 39 18 5B 75 5E E8 ?? ?? ?? ?? 8B 80 88 00 00 00 83 78 10 03 75 4D E8 ?? ?? ?? ?? 8B 80 88 00 00 00 81 78 14 20 05 93 19 74 28 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 81 78 14 21 05 93 19 74 14 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 81 78 14 22 05 93 19 75 11 83 7D 0C 00 74 0B E8 ?? ?? ?? ?? FF 88 90 00 00 00 E8 ?? ?? ?? ?? 8B 4E 08 89 88 88 00 00 00 E8 ?? ?? ?? ?? 8B 4E 0C 89 88 8C 00 00 00 5E 5D C3 }
	condition:
		$1
}

rule file_67_25_0 {
	meta:
		name = "___FrameUnwindFilter"
		size = 78
		refs = "0021 __getptd 002d ?terminate@@YAXXZ"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 00 81 38 52 43 43 E0 74 21 81 38 4D 4F 43 E0 74 19 81 38 63 73 6D E0 75 2A E8 ?? ?? ?? ?? 83 A0 90 00 00 00 00 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 B8 90 00 00 00 00 7E 0B E8 ?? ?? ?? ?? FF 88 90 00 00 00 33 C0 5D C3 }
	condition:
		$1
}

rule file_67_26_0 {
	meta:
		name = "___FrameUnwindToState"
		size = 217
		refs = "0003 __sehtable$___FrameUnwindToState 0008 __SEH_prolog4 0028 __getptd 0049 ?_inconsistency@@YAXXZ 007b __CallSettingFrame@12 0085 ___FrameUnwindFilter 00b7 __SEH_epilog4"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 10 81 78 04 80 00 00 00 8B 45 08 7F 06 0F BE 70 08 EB 03 8B 70 08 89 75 E4 E8 ?? ?? ?? ?? FF 80 90 00 00 00 83 65 FC 00 3B 75 14 74 5F 83 FE FF 7E 08 8B 45 10 3B 70 04 7C 05 E8 ?? ?? ?? ?? 8B 4D 10 8B 41 08 8B 14 F0 89 55 E0 C7 45 FC 01 00 00 00 83 7C F0 04 00 74 27 8B 45 08 89 50 08 68 03 01 00 00 50 8B 41 08 FF 74 F0 04 E8 ?? ?? ?? ?? EB 0D FF 75 EC E8 ?? ?? ?? ?? 59 C3 8B 65 E8 83 65 FC 00 8B 75 E0 89 75 E4 EB 9C C7 45 FC FE FF FF FF E8 19 00 00 00 3B 75 14 74 05 E8 ?? ?? ?? ?? 8B 45 08 89 70 08 E8 ?? ?? ?? ?? C3 8B 75 E4 E8 ?? ?? ?? ?? 83 B8 90 00 00 00 00 7E 0B E8 ?? ?? ?? ?? FF 88 90 00 00 00 C3 }
	condition:
		$1
}

rule file_67_27_0 {
	meta:
		name = "___InternalCxxFrameHandler"
		size = 223
		refs = "0007 __getptd 0064 ___FrameUnwindToState 00d0 ?FindHandler@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@EH1@Z"
	strings:
		$1 = { 55 8B EC 53 56 57 E8 ?? ?? ?? ?? 8B 4D 18 8B 55 08 33 F6 BB 63 73 6D E0 BF 22 05 93 19 39 B0 AC 03 00 00 75 21 39 1A 74 1D 81 3A 26 00 00 80 74 15 8B 01 25 FF FF FF 1F 3B C7 72 0A F6 41 20 01 0F 85 91 00 00 00 F6 42 04 66 74 21 39 71 04 0F 84 82 00 00 00 39 75 1C 75 7D 6A FF 51 FF 75 14 FF 75 0C E8 ?? ?? ?? ?? 83 C4 10 EB 6A 39 71 0C 75 13 8B 01 25 FF FF FF 1F 3D 21 05 93 19 72 57 39 71 1C 74 52 39 1A 75 32 83 7A 10 03 72 2C 39 7A 14 76 27 8B 42 1C 8B 70 08 85 F6 74 1D 0F B6 45 24 50 FF 75 20 FF 75 1C 51 FF 75 14 FF 75 10 FF 75 0C 52 FF D6 83 C4 20 EB 1F FF 75 20 FF 75 1C FF 75 24 51 FF 75 14 FF 75 10 FF 75 0C 52 E8 ?? ?? ?? ?? 83 C4 20 33 C0 40 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_67_28_0 {
	meta:
		name = "___TypeMatch"
		size = 93
		refs = "0027 _strcmp"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 57 8B 46 04 85 C0 74 47 8D 48 08 80 39 00 74 3F 8B 7D 0C 8B 57 04 3B C2 74 14 8D 42 08 50 51 E8 ?? ?? ?? ?? 59 59 85 C0 74 04 33 C0 EB 24 F6 07 02 74 05 F6 06 08 74 F2 8B 45 10 F6 00 01 74 05 F6 06 01 74 E5 F6 00 02 74 05 F6 06 02 74 DB 33 C0 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_70_0_0 {
	meta:
		name = "___common_sexp_cout_rare"
		size = 624
		refs = "0027 _2il0floatpacket_46 003b _2il0floatpacket_47 0049 _2il0floatpacket_49 0062 _2il0floatpacket_50 006a _2il0floatpacket_53 0082 _2il0floatpacket_54 0098 _2il0floatpacket_51 00a9 _2il0floatpacket_52 00c0 _2il0floatpacket_55 00cf _2il0floatpacket_56 00d6 _2il0floatpacket_58 00e2 _2il0floatpacket_57 0171 _2il0floatpacket_61 01c2 _2il0floatpacket_60 01e3 _2il0floatpacket_59 0208 _2il0floatpacket_48"
	strings:
		$1 = { 83 EC 10 8B 44 24 14 0F B7 50 02 81 E2 80 7F 00 00 81 FA 80 7F 00 00 0F 84 0C 02 00 00 F3 0F 10 00 33 D2 F3 0F 10 0D ?? ?? ?? ?? 89 54 24 0C 0F 2F C8 0F 82 CC 01 00 00 0F 2F 05 ?? ?? ?? ?? 0F 82 9A 01 00 00 F3 0F 10 0D ?? ?? ?? ?? 0F 28 F8 F3 0F 59 C8 F3 0F 11 0C 24 F3 0F 10 14 24 F3 0F 10 1D ?? ?? ?? ?? F3 0F 10 0D ?? ?? ?? ?? F3 0F 58 D3 F3 0F 11 54 24 04 F3 0F 10 64 24 04 F3 0F 10 15 ?? ?? ?? ?? F3 0F 5C E3 F3 0F 11 24 24 F3 0F 10 2C 24 F3 0F 59 2D ?? ?? ?? ?? F3 0F 10 34 24 F3 0F 5C FD F3 0F 59 35 ?? ?? ?? ?? 8B 44 24 04 F3 0F 5C FE F3 0F 59 D7 C1 E0 10 F3 0F 58 15 ?? ?? ?? ?? F3 0F 59 D7 C1 F8 10 F3 0F 58 15 ?? ?? ?? ?? 0F 2F 05 ?? ?? ?? ?? F3 0F 59 D7 F3 0F 58 15 ?? ?? ?? ?? F3 0F 59 D7 F3 0F 58 D1 F3 0F 59 D7 F3 0F 58 D1 F3 0F 11 54 24 08 0F 82 89 00 00 00 8D 50 7F 81 FA FE 00 00 00 77 2D 0F B6 D2 C1 E2 07 66 89 54 24 0E F3 0F 10 44 24 08 F3 0F 59 44 24 0C 8B 4C 24 18 F3 0F 11 44 24 08 8B 44 24 08 89 01 33 C0 83 C4 10 C3 83 C0 7E 0F B6 C0 0F B7 54 24 0E C1 E0 07 81 E2 7F 80 FF FF 0B D0 F3 0F 10 44 24 08 66 89 54 24 0E F3 0F 59 44 24 0C F3 0F 11 44 24 08 F3 0F 10 4C 24 08 F3 0F 59 0D ?? ?? ?? ?? 8B 44 24 18 F3 0F 11 4C 24 08 8B 4C 24 08 89 08 33 C0 83 C4 10 C3 83 C0 BB 0F B6 C0 0F B7 54 24 0E C1 E0 07 81 E2 7F 80 FF FF 0B D0 F3 0F 10 44 24 08 66 89 54 24 0E F3 0F 59 44 24 0C F3 0F 11 44 24 08 F3 0F 10 4C 24 08 F3 0F 59 0D ?? ?? ?? ?? 8B 44 24 18 F3 0F 11 4C 24 08 8B 4C 24 08 89 08 B8 04 00 00 00 83 C4 10 C3 F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 C0 8B 54 24 18 F3 0F 11 44 24 08 8B 44 24 08 89 02 B8 04 00 00 00 83 C4 10 C3 F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 C0 8B 54 24 18 F3 0F 11 44 24 08 8B 44 24 08 89 02 B8 03 00 00 00 83 C4 10 C3 0F B6 50 03 81 E2 80 00 00 00 81 FA 80 00 00 00 74 16 F3 0F 10 00 F3 0F 59 C0 8B 44 24 18 F3 0F 11 00 33 C0 83 C4 10 C3 F7 00 FF FF 7F 00 75 E2 8B 54 24 18 33 C0 89 02 83 C4 10 C3 8D A4 24 00 00 00 00 8D 64 24 00 }
	condition:
		$1
}

rule file_74_3_0 {
	meta:
		name = "__INTRN_LOCALE_CONV"
		size = 16
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 00 8B 80 84 00 00 00 5D C3 }
	condition:
		$1
}

rule file_74_4_0 {
	meta:
		name = "___check_float_string"
		size = 98
		refs = "001d __calloc_crt 0041 _memcpy 004c __recalloc_crt"
	strings:
		$1 = { 55 8B EC 56 8B 75 0C 57 8B 06 39 45 08 75 4C 8B 7D 10 6A 04 8B 0F 50 3B 4D 14 75 2E E8 ?? ?? ?? ?? 59 59 89 07 85 C0 75 04 33 C0 EB 31 8B 45 18 C7 00 01 00 00 00 8B 06 03 C0 50 FF 75 14 FF 37 E8 ?? ?? ?? ?? 83 C4 0C EB 0F 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 D2 89 07 D1 26 33 C0 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_74_5_0 {
	meta:
		name = "__cprinput_l"
		size = 4625
		refs = "000a ___security_cookie 005d __errno 0068 __invalid_parameter_noinfo 0075 __ioinit 0089 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00d6 _iswctype 00ef __whiteout 00f8 __un_inc 01bb _isdigit 0431 __getwche_nolock 057d ___check_float_string 0864 __malloc_crt 087e _wcstombs_s 08b5 __cfltcvt_tab 08bb __imp__DecodePointer@4 08c3 _free 0aca _memset 0d91 _wctomb_s 0e9b __allmul 0ec4 _isxdigit 0ef8 __hextodec 1200 @__security_check_cookie@4 120c __invoke_watson"
	strings:
		$1 = { 55 8B EC 81 EC 40 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 4D 10 8D 85 40 FD FF FF 89 8D E0 FC FF FF 33 C9 53 8B 5D 08 89 85 20 FD FF FF 8B C1 89 9D 2C FD FF FF C7 85 E8 FC FF FF 5E 01 00 00 89 8D EC FC FF FF 89 8D E4 FC FF FF 89 8D DC FC FF FF 89 85 28 FD FF FF 85 DB 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 85 11 00 00 E8 ?? ?? ?? ?? 85 C0 78 EF 56 57 FF 75 0C 8D 8D C0 FC FF FF E8 ?? ?? ?? ?? 33 C0 8B F8 8B F0 88 85 3D FD FF FF 0F B7 03 89 BD 38 FD FF FF 89 BD 18 FD FF FF 89 B5 F0 FC FF FF 66 85 C0 0F 84 2B 11 00 00 8B 8D D4 FC FF FF 89 8D 04 FD FF FF 8B 8D D0 FC FF FF 6A 25 5E 89 8D 00 FD FF FF 6A 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 49 8D 85 18 FD FF FF 4F 50 89 BD 18 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 50 E8 ?? ?? ?? ?? 59 59 83 C3 02 6A 08 0F B7 03 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 EC 8B BD 18 FD FF FF 89 9D 2C FD FF FF 89 BD 38 FD FF FF E9 70 10 00 00 0F B7 03 66 3B F0 0F 85 30 10 00 00 66 3B 73 02 0F 84 13 10 00 00 33 C9 8B F1 8B F9 8A D1 B6 01 6A 78 89 B5 FC FC FF FF 89 8D D4 FC FF FF 89 8D 08 FD FF FF 89 BD F8 FC FF FF 89 8D 34 FD FF FF 88 8D F7 FC FF FF 88 8D 17 FD FF FF 88 8D 3F FD FF FF 88 95 0F FD FF FF 88 8D 1F FD FF FF 88 8D 3E FD FF FF 88 B5 33 FD FF FF 89 8D 10 FD FF FF 5E EB 06 8B 9D 2C FD FF FF 83 C3 02 89 9D 2C FD FF FF 0F B7 1B F7 C3 00 FF 00 00 75 40 0F B6 C3 50 E8 ?? ?? ?? ?? 8A 95 0F FD FF FF 59 8B 8D 10 FD FF FF 85 C0 74 20 8B 85 34 FD FF FF 6B C0 0A 47 83 C0 D0 03 C3 89 BD F8 FC FF FF 89 85 34 FD FF FF E9 D4 00 00 00 8A B5 33 FD FF FF 83 FB 4E 0F 8F 32 01 00 00 0F 84 BF 00 00 00 83 FB 2A 0F 84 0D 01 00 00 83 FB 46 0F 84 AD 00 00 00 83 FB 49 74 16 83 FB 4C 0F 85 1D 01 00 00 FE C6 88 B5 33 FD FF FF E9 92 00 00 00 8B 8D 2C FD FF FF 0F B7 41 02 83 F8 36 75 33 66 83 79 04 34 75 26 8D 41 04 8B 8D 10 FD FF FF 41 33 DB 89 85 2C FD FF FF 89 8D 10 FD FF FF 89 9D 00 FD FF FF 89 9D 04 FD FF FF EB 5C 8B 8D 2C FD FF FF 83 F8 33 75 18 66 83 79 04 32 75 11 8D 41 04 8B 8D 10 FD FF FF 89 85 2C FD FF FF EB 39 6A 64 59 66 3B C1 74 25 6A 69 59 66 3B C1 0F 84 FE 00 00 00 6A 6F 59 66 3B C1 74 11 66 3B C6 74 0C 6A 58 59 66 3B C1 0F 85 84 00 00 00 8B 8D 10 FD FF FF 8B 85 2C FD FF FF 8A 9D 3F FD FF FF 8A BD 3E FD FF FF 8A B5 33 FD FF FF 84 D2 0F 84 B8 FE FF FF 8B B5 FC FC FF FF 8B BD 38 FD FF FF 84 DB 0F 85 C8 00 00 00 8B 8D E0 FC FF FF 89 8D D8 FC FF FF 83 C1 04 89 8D E0 FC FF FF 8B 49 FC 89 8D FC FC FF FF E9 AC 00 00 00 8A 9D 3F FD FF FF 8B 85 2C FD FF FF FE C3 88 9D 3F FD FF FF EB 9F 83 FB 68 74 55 6A 6C 58 3B D8 74 12 83 FB 77 74 2A FE C2 88 95 0F FD FF FF E9 6F FF FF FF 8B 85 2C FD FF FF 6A 6C 83 C0 02 5B 66 39 18 0F 84 ED FE FF FF FE C6 88 B5 33 FD FF FF 8A BD 3E FD FF FF 8B 85 2C FD FF FF 8A 9D 3F FD FF FF FE C7 88 BD 3E FD FF FF E9 4B FF FF FF 8A BD 3E FD FF FF FE CE FE CF 88 B5 33 FD FF FF 88 BD 3E FD FF FF EB 0C 8A BD 3E FD FF FF 8B 8D 10 FD FF FF 8A 9D 3F FD FF FF 8B 85 2C FD FF FF E9 16 FF FF FF 83 A5 FC FC FF FF 00 32 DB 84 FF 75 14 0F B7 00 83 F8 53 74 09 83 F8 43 74 04 FE C7 EB 03 80 CF FF 8B 85 2C FD FF FF 6A 20 0F B7 10 58 0B D0 89 95 24 FD FF FF 83 FA 6E 0F 84 BB 00 00 00 83 FA 63 74 20 83 FA 7B 74 1B 8D 85 18 FD FF FF 50 E8 ?? ?? ?? ?? 8B BD 18 FD FF FF 59 89 BD 38 FD FF FF EB 12 47 89 BD 38 FD FF FF 89 BD 18 FD FF FF E8 ?? ?? ?? ?? 0F B7 C8 B8 FF FF 00 00 89 8D 28 FD FF FF 66 3B C1 0F 84 65 0D 00 00 8B 95 24 FD FF FF 83 BD F8 FC FF FF 00 8B 85 34 FD FF FF 74 08 85 C0 0F 84 3E 0D 00 00 83 FA 6F 0F 8F 94 05 00 00 0F 84 C0 09 00 00 83 FA 63 0F 84 74 04 00 00 83 FA 64 0F 84 AE 09 00 00 0F 8E A0 05 00 00 83 FA 67 7E 3C 6A 69 58 3B D0 74 25 83 FA 6E 0F 85 8B 05 00 00 80 BD 3F FD FF FF 00 8B F7 0F 84 5A 0C 00 00 E9 17 04 00 00 8B 8D 28 FD FF FF EB 91 6A 64 58 8B F8 89 BD 24 FD FF FF E9 DA 06 00 00 8B 9D 28 FD FF FF 6A 2D 5A 33 F6 66 3B D3 75 0C 8B 8D 20 FD FF FF 46 66 89 11 EB 08 6A 2B 59 66 3B CB 75 1C 48 47 89 85 34 FD FF FF 89 BD 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 89 9D 28 FD FF FF 83 BD F8 FC FF FF 00 0F 85 83 00 00 00 83 C8 FF 89 85 34 FD FF FF EB 78 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 72 8B 8D 34 FD FF FF 8B C1 49 89 8D 34 FD FF FF 85 C0 74 5F 8B 8D 20 FD FF FF FF 85 08 FD FF FF 66 0F BE C3 66 89 04 71 8D 85 EC FC FF FF 50 8D 85 40 FD FF FF 50 8D 85 20 FD FF FF 50 8D 85 E8 FC FF FF 50 46 56 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 84 25 0C 00 00 47 89 BD 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 89 9D 28 FD FF FF F7 C3 00 FF 00 00 74 80 8B 85 C0 FC FF FF 8B 80 84 00 00 00 8B 40 30 0F B7 38 0F BE C3 8B CF 3B C8 8B 8D 34 FD FF FF 0F 85 E1 00 00 00 8B C1 49 89 8D 34 FD FF FF 85 C0 0F 84 D0 00 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 8B 85 20 FD FF FF 89 9D 28 FD FF FF 66 89 3C 70 8D 85 EC FC FF FF 50 8D 85 40 FD FF FF 50 8D 85 20 FD FF FF 50 8D 85 E8 FC FF FF 50 46 56 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 84 86 0B 00 00 BF 00 FF 00 00 85 DF 75 75 0F B6 C3 50 E8 ?? ?? ?? ?? 59 8B 8D 34 FD FF FF 85 C0 74 67 8B C1 49 89 8D 34 FD FF FF 85 C0 74 5A 8B 85 20 FD FF FF FF 85 08 FD FF FF 66 89 1C 70 8D 85 EC FC FF FF 50 8D 85 40 FD FF FF 50 8D 85 20 FD FF FF 50 8D 85 E8 FC FF FF 50 46 56 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 84 1E 0B 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 89 9D 28 FD FF FF EB 87 8B 8D 34 FD FF FF 83 BD 08 FD FF FF 00 0F 84 53 01 00 00 6A 65 5A 66 3B D3 74 0C 6A 45 58 66 3B C3 0F 85 3F 01 00 00 8B C1 49 89 8D 34 FD FF FF 85 C0 0F 84 2E 01 00 00 8B 85 20 FD FF FF 66 89 14 70 8D 85 EC FC FF FF 50 8D 85 40 FD FF FF 50 8D 85 20 FD FF FF 50 8D 85 E8 FC FF FF 50 46 56 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 84 98 0A 00 00 8B BD 38 FD FF FF 47 E8 ?? ?? ?? ?? 0F B7 D8 6A 2D 59 89 9D 28 FD FF FF 66 3B CB 75 3A 8B 85 20 FD FF FF 66 89 0C 70 8D 85 EC FC FF FF 50 8D 85 40 FD FF FF 50 8D 85 20 FD FF FF 50 8D 85 E8 FC FF FF 50 46 56 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 84 43 0A 00 00 EB 0C 6A 2B 58 66 3B C3 0F 85 89 00 00 00 8B 8D 34 FD FF FF 8B C1 49 89 8D 34 FD FF FF 85 C0 75 67 89 85 34 FD FF FF EB 6E 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 70 8B 8D 34 FD FF FF 8B C1 49 89 8D 34 FD FF FF 85 C0 74 5D 8B 85 20 FD FF FF FF 85 08 FD FF FF 66 89 1C 70 8D 85 EC FC FF FF 50 8D 85 40 FD FF FF 50 8D 85 20 FD FF FF 50 8D 85 E8 FC FF FF 50 46 56 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 84 BB 09 00 00 47 E8 ?? ?? ?? ?? 0F B7 D8 89 9D 28 FD FF FF F7 C3 00 FF 00 00 74 8A EB 06 8B BD 38 FD FF FF 4F 53 89 BD 38 FD FF FF 89 BD 18 FD FF FF E8 ?? ?? ?? ?? 83 BD 08 FD FF FF 00 59 0F 84 7B 09 00 00 80 BD 3F FD FF FF 00 0F 85 8D 00 00 00 8B 9D 20 FD FF FF FF 85 F0 FC FF FF 33 C0 66 89 04 73 8B 85 E8 FC FF FF 8D 3C 45 02 00 00 00 57 E8 ?? ?? ?? ?? 8B F0 59 85 F6 0F 84 44 09 00 00 8D 4F FF 51 53 57 56 33 DB 53 E8 ?? ?? ?? ?? 83 C4 14 85 C0 74 12 83 F8 16 0F 84 74 09 00 00 83 F8 22 0F 84 6B 09 00 00 8D 85 C0 FC FF FF 50 8B 85 FC FC FF FF 56 50 0F BE 85 33 FD FF FF 48 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF D0 56 E8 ?? ?? ?? ?? 83 C4 14 8B BD 38 FD FF FF 8A 85 3D FD FF FF 8B 9D 2C FD FF FF FE C0 83 C3 02 6A 25 88 85 3D FD FF FF 89 9D 2C FD FF FF 5E E9 A4 08 00 00 83 BD F8 FC FF FF 00 75 11 40 C7 85 F8 FC FF FF 01 00 00 00 89 85 34 FD FF FF 84 FF 7E 07 C6 85 1F FD FF FF 01 8B 9D 38 FD FF FF 8B 85 28 FD FF FF 8B B5 FC FC FF FF 4B 50 89 9D 38 FD FF FF 89 9D 18 FD FF FF E8 ?? ?? ?? ?? 8B BD 24 FD FF FF 59 83 BD F8 FC FF FF 00 74 17 8B 8D 34 FD FF FF 8B C1 49 89 8D 34 FD FF FF 85 C0 0F 84 82 04 00 00 43 89 9D 38 FD FF FF 89 9D 18 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 89 9D 28 FD FF FF 83 FF 63 74 4F 83 FF 73 75 16 83 FB 09 72 09 83 FB 0D 0F 86 35 04 00 00 6A 20 58 66 3B D8 75 34 83 FF 7B 0F 85 24 04 00 00 0F B7 C3 8B C8 83 E1 07 33 D2 42 D3 E2 8B 8D E4 FC FF FF C1 E8 03 0F BE 0C 08 0F BE 85 F7 FC FF FF 33 C8 85 D1 0F 84 F9 03 00 00 80 BD 3F FD FF FF 00 0F 85 DE 03 00 00 80 BD 1F FD FF FF 00 0F 84 88 03 00 00 8B 85 FC FC FF FF 66 89 18 83 C0 02 89 85 FC FC FF FF E9 BD 03 00 00 8B C2 83 E8 70 0F 84 20 04 00 00 83 E8 03 0F 84 F5 FE FF FF 48 48 0F 84 16 04 00 00 83 E8 03 0F 84 7A 01 00 00 83 E8 03 74 3B 8B 85 2C FD FF FF 8B 9D 28 FD FF FF 66 39 18 0F 85 65 07 00 00 8A 85 3D FD FF FF FE C8 80 BD 3F FD FF FF 00 0F 85 7C FE FF FF 8B 8D D8 FC FF FF 89 8D E0 FC FF FF E9 6B FE FF FF 84 FF 7E 07 C6 85 1F FD FF FF 01 8B B5 2C FD FF FF 6A 5E 83 C6 02 58 66 3B 06 75 0A 83 C6 02 C6 85 F7 FC FF FF FF 8B BD E4 FC FF FF 85 FF 75 25 68 00 20 00 00 E8 ?? ?? ?? ?? 8B F8 59 89 BD E4 FC FF FF 85 FF 0F 84 FB 06 00 00 C7 85 DC FC FF FF 01 00 00 00 68 00 20 00 00 33 C0 50 57 E8 ?? ?? ?? ?? 83 C4 0C 6A 5D 5A 66 3B 16 75 10 6A 20 58 8B DA 83 C6 02 88 47 0B E9 9A 00 00 00 8B 9D D4 FC FF FF E9 8F 00 00 00 0F B7 C8 6A 2D 58 83 C6 02 66 3B C1 75 6D 66 85 DB 74 68 0F B7 06 66 3B D0 74 60 83 C6 02 89 B5 2C FD FF FF 66 3B D8 73 04 8B C8 EB 05 0F B7 CB 8B D8 0F B7 F1 0F B7 FB 0F B7 CB EB 17 8B D1 83 E1 07 D2 E0 8B 8D E4 FC FF FF C1 EA 03 08 04 0A 47 0F B7 CF B0 01 3B CE 7C E3 8B BD E4 FC FF FF 8B D6 83 E6 07 8B CE 8B B5 2C FD FF FF D2 E0 C1 EA 03 08 04 3A 33 C0 8B D8 EB 11 8B D1 8B D9 83 E1 07 B0 01 D2 E0 C1 EA 03 08 04 3A 6A 5D 5A 0F B7 06 66 3B D0 0F 85 65 FF FF FF 33 C0 66 39 06 0F 84 17 06 00 00 89 B5 2C FD FF FF E9 75 FD FF FF 8B BD 24 FD FF FF 6A 2D 58 66 3B C1 75 09 C6 85 17 FD FF FF 01 EB 08 6A 2B 58 66 3B C1 75 36 FF 8D 34 FD FF FF 75 0D 83 BD F8 FC FF FF 00 74 04 B3 01 EB 21 8B 85 38 FD FF FF 40 89 85 38 FD FF FF 89 85 18 FD FF FF E8 ?? ?? ?? ?? 0F B7 C8 89 8D 28 FD FF FF 6A 30 58 66 3B C1 0F 85 87 00 00 00 8B 85 38 FD FF FF 40 89 85 38 FD FF FF 89 85 18 FD FF FF E8 ?? ?? ?? ?? 0F B7 C8 6A 78 58 89 8D 28 FD FF FF 66 3B C1 0F 84 F4 00 00 00 6A 58 5A 66 3B D1 0F 84 E8 00 00 00 C7 85 08 FD FF FF 01 00 00 00 3B F8 74 1B 83 BD F8 FC FF FF 00 74 0A FF 8D 34 FD FF FF 75 02 FE C3 6A 6F 5A E9 04 01 00 00 8B BD 38 FD FF FF 4F 51 89 BD 38 FD FF FF 89 BD 18 FD FF FF E8 ?? ?? ?? ?? 59 6A 30 58 8B C8 89 8D 28 FD FF FF 8B 95 24 FD FF FF 6A 78 58 83 BD 10 FD FF FF 00 0F 84 31 03 00 00 84 DB 0F 85 F0 02 00 00 8B 9D 38 FD FF FF 3B D0 0F 84 FA 01 00 00 83 FA 70 0F 84 F1 01 00 00 F7 C1 00 FF 00 00 0F 85 A9 02 00 00 0F B6 C1 50 E8 ?? ?? ?? ?? 8B BD 24 FD FF FF 59 85 C0 0F 84 AD 02 00 00 6A 6F 58 3B F8 0F 85 96 01 00 00 8B 8D 28 FD FF FF 6A 38 58 66 3B C1 0F 86 7A 02 00 00 8B 85 00 FD FF FF 8B 95 04 FD FF FF 0F A4 C2 03 C1 E0 03 89 95 04 FD FF FF 89 85 00 FD FF FF E9 E5 01 00 00 8B BD 38 FD FF FF 47 89 BD 38 FD FF FF 89 BD 18 FD FF FF E8 ?? ?? ?? ?? 83 BD F8 FC FF FF 00 0F B7 C8 89 8D 28 FD FF FF 74 16 8B 85 34 FD FF FF 83 E8 02 89 85 34 FD FF FF 83 F8 01 7D 02 FE C3 6A 78 58 8B D0 89 95 24 FD FF FF E9 1F FF FF FF 53 8B 9D FC FC FF FF 33 C0 6A 05 89 85 10 FD FF FF 8D 85 10 FD FF FF 53 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 16 83 F8 16 74 05 83 F8 22 75 1D 33 C0 50 50 50 50 50 E9 59 04 00 00 03 9D 10 FD FF FF 89 9D FC FC FF FF EB 03 83 C6 02 8B 9D 38 FD FF FF E9 78 FB FF FF 8B 85 38 FD FF FF 48 53 89 85 38 FD FF FF 89 85 18 FD FF FF E8 ?? ?? ?? ?? 59 8B 85 FC FC FF FF 3B F0 0F 84 BB 03 00 00 80 BD 3F FD FF FF 00 0F 85 C7 FA FF FF FF 85 F0 FC FF FF 83 FF 63 8B BD 38 FD FF FF 0F 84 B8 FA FF FF 33 C9 38 8D 1F FD FF FF 74 08 66 89 08 E9 A6 FA FF FF 88 08 E9 9F FA FF FF C6 85 33 FD FF FF 01 6A 2D 58 66 3B C1 75 09 C6 85 17 FD FF FF 01 EB 0C 6A 2B 58 66 3B C1 0F 85 3E FE FF FF FF 8D 34 FD FF FF 75 10 83 BD F8 FC FF FF 00 74 07 B3 01 E9 26 FE FF FF 47 89 BD 38 FD FF FF 89 BD 18 FD FF FF E8 ?? ?? ?? ?? 0F B7 C8 E9 00 FE FF FF 8B 8D 04 FD FF FF 33 C0 50 6A 0A 51 8B 8D 00 FD FF FF 51 E8 ?? ?? ?? ?? 8B 8D 28 FD FF FF 89 85 00 FD FF FF 89 95 04 FD FF FF EB 59 F7 C1 00 FF 00 00 0F 85 B8 00 00 00 0F B6 C1 50 E8 ?? ?? ?? ?? 59 85 C0 0F 84 A0 00 00 00 8B 85 00 FD FF FF 8B 8D 04 FD FF FF 0F A4 C1 04 C1 E0 04 89 85 00 FD FF FF 8B 85 28 FD FF FF 50 89 8D 04 FD FF FF E8 ?? ?? ?? ?? 8B BD 24 FD FF FF 59 0F B7 C8 89 8D 28 FD FF FF FF 85 08 FD FF FF 0F B7 C1 6A 30 59 2B C1 8B 8D 00 FD FF FF 99 03 C8 8B 85 04 FD FF FF 13 C2 83 BD F8 FC FF FF 00 89 8D 00 FD FF FF 89 85 04 FD FF FF 74 08 FF 8D 34 FD FF FF 74 65 43 89 9D 38 FD FF FF 89 9D 18 FD FF FF E8 ?? ?? ?? ?? 8B 95 24 FD FF FF 0F B7 C8 6A 78 89 8D 28 FD FF FF 58 E9 40 FD FF FF 8B 8D 28 FD FF FF 8B BD 24 FD FF FF 4B 51 89 9D 38 FD FF FF 89 9D 18 FD FF FF E8 ?? ?? ?? ?? 59 EB 0E 8B 8D 28 FD FF FF EB E2 8B BD 24 FD FF FF 8B 85 04 FD FF FF 8B 8D 00 FD FF FF 80 BD 17 FD FF FF 00 0F 84 28 01 00 00 F7 D9 6A 00 89 8D 00 FD FF FF 59 13 C1 F7 D8 89 85 04 FD FF FF E9 0E 01 00 00 84 DB 0F 85 F5 00 00 00 8B 9D 38 FD FF FF 3B D0 74 4C 83 FA 70 74 47 F7 C1 00 FF 00 00 0F 85 BE 00 00 00 0F B6 C1 50 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_74_8_0 {
	meta:
		name = "__hextodec"
		size = 49
		refs = "0018 _isdigit"
	strings:
		$1 = { 55 8B EC 53 56 8B 75 08 F7 C6 00 FF 00 00 75 11 0F B7 DE 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 75 09 0F B7 DE 83 E3 DF 83 EB 07 5E 66 8B C3 5B 5D C3 }
	condition:
		$1
}

rule file_74_11_0 {
	meta:
		name = "__un_inc"
		size = 22
		refs = "0010 __ungetwch_nolock"
	strings:
		$1 = { 55 8B EC B8 FF FF 00 00 66 3B 45 08 74 06 5D E9 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_932_8_0 {
	meta:
		name = "__un_inc"
		size = 22
		refs = "0010 __ungetwc_nolock"
	strings:
		$1 = { 55 8B EC B8 FF FF 00 00 66 3B 45 08 74 06 5D E9 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_74_12_0 {
	meta:
		name = "__whiteout"
		size = 49
		refs = "000b __getwche_nolock 0020 _iswctype"
	strings:
		$1 = { 55 8B EC 56 57 8B 7D 08 FF 07 E8 ?? ?? ?? ?? 0F B7 F0 B8 FF FF 00 00 66 3B F0 74 0E 6A 08 56 E8 ?? ?? ?? ?? 59 59 85 C0 75 DE 5F 66 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_75_3_0 {
	meta:
		name = "__freefls@4"
		size = 311
		refs = "0003 __sehtable$__freefls@4 0008 __SEH_prolog4 0021 _free 0083 __XcptActTab 0095 __lock 00a8 __imp__InterlockedDecrement@4 00b2 ___initialmbcinfo 00e3 ___removelocaleref 00ea ___ptlocinfo 00f2 ___initiallocinfo 00ff ___freetlocinfo 0118 __SEH_epilog4 0125 __unlock"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 08 85 F6 0F 84 00 01 00 00 83 7E 24 00 74 09 FF 76 24 E8 ?? ?? ?? ?? 59 83 7E 2C 00 74 09 FF 76 2C E8 ?? ?? ?? ?? 59 83 7E 34 00 74 09 FF 76 34 E8 ?? ?? ?? ?? 59 83 7E 3C 00 74 09 FF 76 3C E8 ?? ?? ?? ?? 59 83 7E 40 00 74 09 FF 76 40 E8 ?? ?? ?? ?? 59 83 7E 44 00 74 09 FF 76 44 E8 ?? ?? ?? ?? 59 83 7E 48 00 74 09 FF 76 48 E8 ?? ?? ?? ?? 59 81 7E 5C ?? ?? ?? ?? 74 09 FF 76 5C E8 ?? ?? ?? ?? 59 6A 0D E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 7E 68 85 FF 74 1A 57 FF 15 ?? ?? ?? ?? 85 C0 75 0F 81 FF ?? ?? ?? ?? 74 07 57 E8 ?? ?? ?? ?? 59 C7 45 FC FE FF FF FF E8 57 00 00 00 6A 0C E8 ?? ?? ?? ?? 59 C7 45 FC 01 00 00 00 8B 7E 6C 85 FF 74 23 57 E8 ?? ?? ?? ?? 59 3B 3D ?? ?? ?? ?? 74 14 81 FF ?? ?? ?? ?? 74 0C 83 3F 00 75 07 57 E8 ?? ?? ?? ?? 59 C7 45 FC FE FF FF FF E8 1E 00 00 00 56 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? C2 04 00 8B 75 08 6A 0D E8 ?? ?? ?? ?? 59 C3 8B 75 08 6A 0C E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_75_4_0 {
	meta:
		name = "__freeptd"
		size = 54
		refs = "0004 ___flsindex 0017 ___crtFlsGetValue 0027 ___crtFlsSetValue 002f __freefls@4"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 83 F8 FF 74 27 56 8B 75 08 85 F6 75 0E 50 E8 ?? ?? ?? ?? 8B F0 A1 ?? ?? ?? ?? 59 6A 00 50 E8 ?? ?? ?? ?? 59 59 56 E8 ?? ?? ?? ?? 5E 5D C3 }
	condition:
		$1
}

rule file_75_5_0 {
	meta:
		name = "__getptd"
		size = 24
		refs = "0002 __getptd_noexit 000f __amsg_exit"
	strings:
		$1 = { 56 E8 ?? ?? ?? ?? 8B F0 85 F6 75 08 6A 10 E8 ?? ?? ?? ?? 59 8B C6 5E C3 }
	condition:
		$1
}

rule file_75_6_0 {
	meta:
		name = "__getptd_noexit"
		size = 111
		refs = "0004 __imp__GetLastError@0 000a ___flsindex 0011 ___crtFlsGetValue 0024 __calloc_crt 0038 ___crtFlsSetValue 0046 __initptd 004e __imp__GetCurrentThreadId@0 005c _free 0066 __imp__SetLastError@4"
	strings:
		$1 = { 56 57 FF 15 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 8B F8 E8 ?? ?? ?? ?? 8B F0 59 85 F6 75 47 68 B8 03 00 00 6A 01 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 74 33 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 85 C0 74 18 6A 00 56 E8 ?? ?? ?? ?? 59 59 FF 15 ?? ?? ?? ?? 83 4E 04 FF 89 06 EB 09 56 E8 ?? ?? ?? ?? 59 33 F6 57 FF 15 ?? ?? ?? ?? 5F 8B C6 5E C3 }
	condition:
		$1
}

rule file_75_7_0 {
	meta:
		name = "__initptd"
		size = 172
		refs = "0003 __sehtable$__initptd 0008 __SEH_prolog4 0012 __XcptActTab 0037 ___initialmbcinfo 003e __lock 004c __imp__InterlockedIncrement@4 0072 ___ptlocinfo 007d ___addlocaleref 008f __SEH_epilog4 009d __unlock"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 08 C7 46 5C ?? ?? ?? ?? 83 66 08 00 33 FF 47 89 7E 14 89 7E 70 6A 43 58 66 89 86 B8 00 00 00 66 89 86 BE 01 00 00 C7 46 68 ?? ?? ?? ?? 6A 0D E8 ?? ?? ?? ?? 59 83 65 FC 00 FF 76 68 FF 15 ?? ?? ?? ?? C7 45 FC FE FF FF FF E8 3E 00 00 00 6A 0C E8 ?? ?? ?? ?? 59 89 7D FC 8B 45 0C 89 46 6C 85 C0 75 08 A1 ?? ?? ?? ?? 89 46 6C FF 76 6C E8 ?? ?? ?? ?? 59 C7 45 FC FE FF FF FF E8 15 00 00 00 E8 ?? ?? ?? ?? C3 33 FF 47 8B 75 08 6A 0D E8 ?? ?? ?? ?? 59 C3 6A 0C E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_75_8_0 {
	meta:
		name = "__mtinit"
		size = 118
		refs = "0001 __init_pointers 0006 __mtinitlocks 000f __mtterm 0017 __freefls@4 001c ___crtFlsAlloc 0022 ___flsindex 0034 __calloc_crt 0048 ___crtFlsSetValue 0056 __initptd 005e __imp__GetCurrentThreadId@0"
	strings:
		$1 = { E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 08 E8 ?? ?? ?? ?? 33 C0 C3 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 A3 ?? ?? ?? ?? 83 F8 FF 74 E3 56 68 B8 03 00 00 6A 01 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 74 2D 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 85 C0 74 1B 6A 00 56 E8 ?? ?? ?? ?? 59 59 FF 15 ?? ?? ?? ?? 83 4E 04 FF 89 06 33 C0 40 5E C3 E8 ?? ?? ?? ?? 33 C0 5E C3 }
	condition:
		$1
}

rule file_75_9_0 {
	meta:
		name = "__mtterm"
		size = 29
		refs = "0001 ___flsindex 000c ___crtFlsFree 0019 __mtdeletelocks"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 F8 FF 74 0E 50 E8 ?? ?? ?? ?? 83 0D ?? ?? ?? ?? FF 59 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_0_0 {
	meta:
		name = "___avx_tanhf8"
		size = 640
		refs = "001d ___common_stanh_data 026b ___common_stanh_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 56 57 53 81 EC B4 00 00 00 C5 FC 28 E0 C5 FC 11 64 24 20 C5 F8 10 35 ?? ?? ?? ?? C5 F8 10 3D ?? ?? ?? ?? C5 F8 10 0D ?? ?? ?? ?? C5 DC 54 05 ?? ?? ?? ?? C5 DC 54 2D ?? ?? ?? ?? C5 FC 11 2C 24 C5 D9 DB DE C4 E3 7D 19 E2 01 C5 E1 66 EF C5 E9 DB D6 C5 E9 66 FF C5 C9 EF F6 C5 D1 6B EF C5 D1 63 E6 C5 E9 FA E9 C5 F9 D7 C4 C5 E1 FA E1 C5 F8 10 0D ?? ?? ?? ?? C5 D9 66 DE C5 D9 DB D3 C5 D9 66 E1 C5 D1 66 F6 C4 E3 69 4A E1 40 C5 D1 DB F6 C5 D1 66 E9 C4 E3 49 4A C9 50 C5 C9 72 D4 0E C5 F9 7E F6 C5 D1 72 D1 0E C5 F9 7E EA C5 F9 10 A6 ?? ?? ?? ?? C4 E3 79 16 F7 01 C4 E3 79 16 F3 03 89 84 24 80 00 00 00 C4 E3 79 16 E8 01 C4 E3 79 16 F1 02 C5 F9 10 97 ?? ?? ?? ?? 89 94 24 84 00 00 00 C5 F9 10 B2 ?? ?? ?? ?? 89 84 24 88 00 00 00 C4 E3 79 16 EA 03 C4 E3 6D 18 8B ?? ?? ?? ?? 01 C5 F9 10 90 ?? ?? ?? ?? C4 E3 79 16 E8 02 C4 E3 5D 18 B9 ?? ?? ?? ?? 01 C5 C5 14 D9 C5 FD 11 5C 24 40 C5 F9 10 9E ?? ?? ?? ?? C5 C5 15 E1 8B B4 24 88 00 00 00 C5 F9 10 BF ?? ?? ?? ?? C4 E3 4D 18 B0 ?? ?? ?? ?? 01 C4 E3 6D 18 92 ?? ?? ?? ?? 01 C5 CD 14 EA C5 FD 11 6C 24 60 C5 CD 15 EA C4 E3 65 18 89 ?? ?? ?? ?? 01 8B 8C 24 84 00 00 00 C5 F9 10 9E ?? ?? ?? ?? 8B B4 24 80 00 00 00 C4 E3 45 18 B3 ?? ?? ?? ?? 01 C5 F5 14 D6 C5 F5 15 CE C5 F9 10 B1 ?? ?? ?? ?? C4 E3 4D 18 B8 ?? ?? ?? ?? 01 8B C6 25 FF 00 00 00 C4 E3 65 18 B2 ?? ?? ?? ?? 01 C5 C5 14 DE C5 C5 15 FE C5 FC 5A F0 C4 E3 7D 19 C0 01 C5 F5 59 CE C5 FC 5A C0 C5 F5 58 D2 C5 C5 59 F8 C5 ED 59 D6 C5 C5 58 CB C5 ED 58 D4 C5 F5 59 E0 C5 DD 58 CD C5 ED 59 EE C5 F5 59 D8 C5 D5 58 54 24 40 C5 E5 58 44 24 60 C5 FD 5A F2 C5 FD 5A C8 C4 E3 4D 18 D1 01 C5 EC 56 04 24 85 C0 75 0D 81 C4 B4 00 00 00 5B 5F 5E 8B E5 5D C3 C5 FC 10 4C 24 20 C5 FC 11 44 24 40 C5 FC 11 0C 24 85 F6 74 DE 33 DB 0F A3 DE 72 19 43 83 FB 20 7C F5 C5 FC 10 44 24 40 81 C4 B4 00 00 00 5B 5F 5E 8B E5 5D C3 C5 F8 77 8D 44 9C 40 8D 14 9C 50 52 E8 ?? ?? ?? ?? 83 C4 08 EB D1 8D A4 24 00 00 00 00 EB 03 CC CC CC }
	condition:
		$1
}

rule file_77_1_0 {
	meta:
		name = "_clearerr_s"
		size = 179
		refs = "0003 __sehtable$_clearerr_s 0008 __SEH_prolog4 001b __errno 0025 __invalid_parameter_noinfo 002e __ioinit 003d __lock_file 004c __fileno 0080 ___pioinfo 0087 ___badioinfo 00a3 __SEH_epilog4 00ad __unlock_file"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 7D 08 85 FF 0F 95 C0 85 C0 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 75 E8 ?? ?? ?? ?? 85 C0 79 05 6A 16 58 EB 67 57 E8 ?? ?? ?? ?? 59 83 65 FC 00 83 67 0C CF 57 E8 ?? ?? ?? ?? 59 83 F8 FF 74 30 57 E8 ?? ?? ?? ?? 59 83 F8 FE 74 24 57 E8 ?? ?? ?? ?? 8B F0 C1 FE 05 57 E8 ?? ?? ?? ?? 59 59 8B C8 83 E1 1F C1 E1 06 03 0C B5 ?? ?? ?? ?? EB 05 B9 ?? ?? ?? ?? 0F BE 41 04 24 FD 88 41 04 C7 45 FC FE FF FF FF E8 0B 00 00 00 33 C0 E8 ?? ?? ?? ?? C3 8B 7D 08 57 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "__getcwd"
		size = 21
		refs = "000c __getdcwd"
	strings:
		$1 = { 55 8B EC FF 75 0C FF 75 08 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_247_0_0 {
	meta:
		name = "__wgetcwd"
		size = 21
		refs = "000c __wgetdcwd"
	strings:
		$1 = { 55 8B EC FF 75 0C FF 75 08 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_78_1_0 {
	meta:
		name = "__getdcwd"
		size = 282
		refs = "000f __validdrive 0019 ___doserrno 0024 __errno 002f __invalid_parameter_noinfo 003b __getdrive 0093 __imp__GetFullPathNameA@16 00ca _calloc 0108 __imp__GetLastError@0 010e __dosmaperr"
	strings:
		$1 = { 55 8B EC 51 51 53 8B 5D 08 85 DB 74 2D 53 E8 ?? ?? ?? ?? 59 85 C0 75 29 E8 ?? ?? ?? ?? C7 00 0F 00 00 00 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 DD 00 00 00 E8 ?? ?? ?? ?? 8B D8 56 8B 75 10 57 8B 7D 0C 85 FF 74 23 85 F6 7F 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 AD 00 00 00 8B C6 89 75 FC C6 07 00 EB 05 33 C0 89 45 FC 85 DB 74 12 80 C3 40 88 5D 08 66 C7 45 09 3A 2E C6 45 0B 00 EB 06 66 C7 45 08 2E 00 8B 1D ?? ?? ?? ?? 8D 4D F8 51 57 50 8D 45 08 50 FF D3 85 C0 74 5F 85 FF 74 15 3B 45 FC 7C 52 E8 ?? ?? ?? ?? C7 00 22 00 00 00 C6 07 00 EB 53 3B C6 7E 02 8B F0 6A 01 56 E8 ?? ?? ?? ?? 8B F8 59 59 85 FF 75 18 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? C7 00 08 00 00 00 EB 25 8D 45 F8 50 57 56 8D 45 08 50 FF D3 85 C0 74 08 3B C6 7D 04 8B C7 EB 0F FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_78_2_0 {
	meta:
		name = "__validdrive"
		size = 122
		refs = "0007 ___security_cookie 0019 ___doserrno 0024 __errno 002f __invalid_parameter_noinfo 005f __imp__GetDriveTypeW@4 0074 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 83 F8 1A 76 1D E8 ?? ?? ?? ?? C7 00 0F 00 00 00 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 E8 ?? ?? ?? ?? EB 37 85 C0 75 05 33 C0 40 EB 30 83 C0 40 6A 3A 66 89 45 F4 58 66 89 45 F6 6A 5C 58 66 89 45 F8 33 C0 66 89 45 FA 8D 45 F4 50 FF 15 ?? ?? ?? ?? 85 C0 74 05 83 F8 01 75 CD 33 C0 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "__wmakepath_s"
		size = 291
		refs = "00fe __errno 0118 __invalid_parameter_noinfo"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 56 57 85 DB 0F 84 FC 00 00 00 8B 7D 0C 85 FF 0F 84 F1 00 00 00 33 C0 8B D0 8B 45 10 8B CB 85 C0 74 21 0F B7 00 66 85 C0 74 19 6A 02 5A 3B FA 0F 86 BC 00 00 00 66 89 03 8D 4B 02 6A 3A 58 66 89 01 03 CA 8B 75 14 33 C0 85 F6 74 3F 66 39 06 74 3A 42 3B D7 0F 83 97 00 00 00 66 8B 06 66 89 01 83 C6 02 33 C0 83 C1 02 66 39 06 75 E4 0F B7 46 FE 83 F8 2F 74 13 6A 5C 5E 66 3B C6 74 0B 42 3B D7 73 6E 66 89 31 83 C1 02 33 C0 8B 75 18 85 F6 74 1A EB 13 42 3B D7 73 58 66 8B 06 66 89 01 83 C1 02 83 C6 02 33 C0 66 39 06 75 E8 8B 75 1C 85 F6 74 37 0F B7 06 66 85 C0 74 2F C7 45 08 2E 00 00 00 66 3B 45 08 74 1B 42 3B D7 73 24 8B 45 08 EB 0B 42 3B D7 73 1A 66 8B 06 83 C6 02 66 89 01 83 C1 02 33 C0 66 39 06 75 E8 8D 42 01 3B C7 76 0E 33 C0 66 89 03 E8 ?? ?? ?? ?? 6A 22 EB 0E 33 C0 66 89 01 EB 11 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_80_0_0 {
	meta:
		name = "__CIsqrt"
		size = 186
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 0031 __load_CW 0040 ___fastflag 0047 __fast_exit 0052 _NAME_ 0057 __math_exit 0073 __convertTOStoQNaN 0092 __indefinite 00b4 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 8B 44 24 0C 74 51 66 81 3C 24 7F 02 74 05 E8 ?? ?? ?? ?? A9 00 00 00 80 75 1F D9 FA 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 05 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? A9 00 00 F0 7F 75 2C A9 FF FF 0F 00 75 25 83 7C 24 08 00 75 1E EB CC E8 ?? ?? ?? ?? EB 22 A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB 25 00 00 00 80 74 B0 DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 05 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_81_0_0 {
	meta:
		name = "___addlocaleref"
		size = 144
		refs = "0007 __imp__InterlockedIncrement@4 004e ___wclocalestr"
	strings:
		$1 = { 55 8B EC 53 56 8B 35 ?? ?? ?? ?? 57 8B 7D 08 57 FF D6 83 7F 78 00 74 05 FF 77 78 FF D6 8B 87 80 00 00 00 85 C0 74 03 50 FF D6 83 7F 7C 00 74 05 FF 77 7C FF D6 8B 87 88 00 00 00 85 C0 74 03 50 FF D6 6A 06 58 8D 5F 1C 89 45 08 81 7B F8 ?? ?? ?? ?? 74 0C 83 3B 00 74 07 FF 33 FF D6 8B 45 08 83 7B F4 00 74 0E 83 7B FC 00 74 08 FF 73 FC FF D6 8B 45 08 83 C3 10 48 89 45 08 75 CE 8B 87 9C 00 00 00 05 B0 00 00 00 50 FF D6 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_81_1_0 {
	meta:
		name = "___freetlocinfo"
		size = 346
		refs = "0016 ___lconv_c 0037 _free 0042 ___free_lconv_mon 0060 ___free_lconv_num 00d0 ___lc_time_c 00e0 ___free_lc_time 0103 ___wclocalestr"
	strings:
		$1 = { 55 8B EC 53 56 8B 75 08 33 DB 8B 86 84 00 00 00 57 85 C0 74 66 3D ?? ?? ?? ?? 74 5F 8B 46 78 85 C0 74 58 39 18 75 54 8B 86 80 00 00 00 85 C0 74 17 39 18 75 13 50 E8 ?? ?? ?? ?? FF B6 84 00 00 00 E8 ?? ?? ?? ?? 59 59 8B 46 7C 85 C0 74 17 39 18 75 13 50 E8 ?? ?? ?? ?? FF B6 84 00 00 00 E8 ?? ?? ?? ?? 59 59 FF 76 78 E8 ?? ?? ?? ?? FF B6 84 00 00 00 E8 ?? ?? ?? ?? 59 59 8B 86 88 00 00 00 85 C0 74 44 39 18 75 40 8B 86 8C 00 00 00 2D FE 00 00 00 50 E8 ?? ?? ?? ?? 8B 86 94 00 00 00 BF 80 00 00 00 2B C7 50 E8 ?? ?? ?? ?? 8B 86 98 00 00 00 2B C7 50 E8 ?? ?? ?? ?? FF B6 88 00 00 00 E8 ?? ?? ?? ?? 83 C4 10 8B 86 9C 00 00 00 3D ?? ?? ?? ?? 74 1B 39 98 B0 00 00 00 75 13 50 E8 ?? ?? ?? ?? FF B6 9C 00 00 00 E8 ?? ?? ?? ?? 59 59 6A 06 58 8D 9E A0 00 00 00 8D 7E 1C 89 45 08 81 7F F8 ?? ?? ?? ?? 74 1D 8B 07 85 C0 74 14 83 38 00 75 0F 50 E8 ?? ?? ?? ?? FF 33 E8 ?? ?? ?? ?? 59 59 8B 45 08 83 7F F4 00 74 16 8B 47 FC 85 C0 74 0C 83 38 00 75 07 50 E8 ?? ?? ?? ?? 59 8B 45 08 83 C3 04 83 C7 10 48 89 45 08 75 B2 56 E8 ?? ?? ?? ?? 59 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_81_2_0 {
	meta:
		name = "___removelocaleref"
		size = 155
		refs = "0013 __imp__InterlockedDecrement@4 0056 ___wclocalestr"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 85 F6 0F 84 87 00 00 00 53 57 8B 3D ?? ?? ?? ?? 56 FF D7 83 7E 78 00 74 05 FF 76 78 FF D7 8B 86 80 00 00 00 85 C0 74 03 50 FF D7 83 7E 7C 00 74 05 FF 76 7C FF D7 8B 86 88 00 00 00 85 C0 74 03 50 FF D7 6A 06 58 8D 5E 1C 89 45 08 81 7B F8 ?? ?? ?? ?? 74 0C 83 3B 00 74 07 FF 33 FF D7 8B 45 08 83 7B F4 00 74 0E 83 7B FC 00 74 08 FF 73 FC FF D7 8B 45 08 83 C3 10 48 89 45 08 75 CE 8B 8E 9C 00 00 00 81 C1 B0 00 00 00 51 FF D7 5F 5B 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_81_3_0 {
	meta:
		name = "___updatetlocinfo"
		size = 124
		refs = "0003 __sehtable$___updatetlocinfo 0008 __SEH_prolog4 000d __getptd 0015 ___globallocalestatus 0033 __amsg_exit 003b __SEH_epilog4 0043 __lock 004e ___ptlocinfo 0057 __updatetlocinfoEx_nolock 0076 __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 8B 0D ?? ?? ?? ?? 85 4E 70 74 22 83 7E 6C 00 74 1C E8 ?? ?? ?? ?? 8B 70 6C 85 F6 75 08 6A 20 E8 ?? ?? ?? ?? 59 8B C6 E8 ?? ?? ?? ?? C3 6A 0C E8 ?? ?? ?? ?? 59 83 65 FC 00 FF 35 ?? ?? ?? ?? 8D 46 6C 50 E8 ?? ?? ?? ?? 59 59 8B F0 89 75 E4 C7 45 FC FE FF FF FF E8 05 00 00 00 EB BC 8B 75 E4 6A 0C E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_81_4_0 {
	meta:
		name = "__updatetlocinfoEx_nolock"
		size = 75
		refs = "001d ___addlocaleref 0028 ___removelocaleref 0034 ___initiallocinfo 003c ___freetlocinfo"
	strings:
		$1 = { 55 8B EC 57 8B 7D 0C 85 FF 74 3B 8B 45 08 85 C0 74 34 56 8B 30 3B F7 74 28 57 89 38 E8 ?? ?? ?? ?? 59 85 F6 74 1B 56 E8 ?? ?? ?? ?? 83 3E 00 59 75 0F 81 FE ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C7 5E EB 02 33 C0 5F 5D C3 }
	condition:
		$1
}

rule file_82_0_0 {
	meta:
		name = "___libm_sse2_sinf"
		size = 325
		refs = "001b _PI_32_RECIP 0027 _BIT_31 003b _SHIFTER 0066 _P_1 0072 _P_2 0078 _Ctable 009e _C_1 00a6 _S_1 00b6 _C_2 00be _S_2 00ca _ONE 010a _ONE_M230 0130 _sin"
	strings:
		$1 = { 66 0F C5 C0 01 66 25 FF 7F 66 2D 80 00 66 3D 7F 45 0F 87 E9 00 00 00 F2 0F 10 0D ?? ?? ?? ?? F3 0F 59 C8 66 0F 28 1D ?? ?? ?? ?? F3 0F 2D D1 66 0F 54 D8 F3 0F 5A C0 F3 0F 58 0D ?? ?? ?? ?? F3 0F 5C 0D ?? ?? ?? ?? 66 0F 28 E3 66 0F 73 F3 20 66 0F 73 F4 1D 66 0F 57 DC 81 C2 00 76 1C 00 83 E2 3F F2 0F 10 15 ?? ?? ?? ?? 66 0F 57 D3 66 0F 57 1D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 04 03 C2 66 0F 73 F1 1D F2 0F 59 D1 F2 0F 59 D9 F2 0F 5C C2 F2 0F 58 D8 F2 0F 59 C0 F2 0F 10 25 ?? ?? ?? ?? F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 E0 F2 0F 59 E8 F2 0F 10 35 ?? ?? ?? ?? F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 C0 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 F0 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 58 E6 F2 0F 58 EF F2 0F 10 10 F2 0F 59 58 08 F2 0F 59 D4 F2 0F 59 DD F2 0F 58 D3 F2 0F 5A C2 C3 7F 11 F3 0F 5A C0 F2 0F 59 05 ?? ?? ?? ?? F2 0F 5A C0 C3 66 0F 7E C0 25 00 00 80 7F 3D 00 00 80 7F 74 1D 83 EC 08 F3 0F 5A C0 66 0F D6 04 24 E8 ?? ?? ?? ?? D9 1C 24 F3 0F 10 04 24 83 C4 08 C3 F3 0F 5C C0 C3 }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "_$I10_OUTPUT"
		size = 2500
		refs = "000a ___security_cookie 00c8 ??_C@_06PGGFOGJG@1?$CDSNAN?$AA@ 00e1 ??_C@_05PHHOCPM@1?$CDIND?$AA@ 00f0 ??_C@_05DNEBIAHO@1?$CDINF?$AA@ 00fb _strcpy_s 0111 ??_C@_06IMKFLFPG@1?$CDQNAN?$AA@ 0172 __pow10pos 01a7 __pow10neg 0978 @__security_check_cookie@4 09bf __invoke_watson"
	strings:
		$1 = { 55 8B EC 81 EC 88 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 0F B7 55 10 53 8B 5D 1C 56 BE 00 80 00 00 23 D6 0F B7 75 10 33 C9 B8 FF 7F 00 00 41 23 F0 57 89 5D 90 C7 45 D0 CC CC CC CC C7 45 D4 CC CC CC CC C7 45 D8 CC CC FB 3F 89 55 88 89 45 98 66 85 D2 74 06 C6 43 02 2D EB 04 C6 43 02 20 8B 7D 0C 66 85 F6 75 3A 85 FF 0F 85 C7 00 00 00 39 7D 08 0F 85 BE 00 00 00 33 C0 66 89 03 B8 00 80 00 00 66 3B D0 0F 95 C0 FE C8 24 0D 04 20 88 43 02 88 4B 03 66 C7 43 04 30 00 8B C1 E9 CE 08 00 00 66 3B F0 0F 85 8C 00 00 00 8B 45 0C BA 00 00 00 80 66 89 0B 8B 4D 08 3B C2 75 04 85 C9 74 0E A9 00 00 00 40 75 07 68 ?? ?? ?? ?? EB 47 66 83 7D 88 00 74 12 3D 00 00 00 C0 75 0B 85 C9 75 30 68 ?? ?? ?? ?? EB 0D 3B C2 75 25 85 C9 75 21 68 ?? ?? ?? ?? 8D 43 04 6A 16 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 AD 08 00 00 C6 43 03 05 EB 1F 68 ?? ?? ?? ?? 8D 43 04 6A 16 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 8C 08 00 00 C6 43 03 06 33 C0 E9 39 08 00 00 0F B7 D6 8B C2 69 D2 10 4D 00 00 C1 E8 08 8B CF C1 E9 18 81 C2 0C ED BC EC 8D 04 48 6B C0 4D 03 C2 C1 F8 10 0F B7 C8 8B 45 08 89 45 E2 33 C0 89 4D B8 0F BF C9 66 89 45 E0 F7 D9 B8 ?? ?? ?? ?? 83 E8 60 33 DB 66 89 75 EA 89 7D E6 89 4D BC C7 45 A4 05 00 00 00 C7 45 94 FD BF 00 00 C7 45 A8 BF 3F 00 00 85 C9 0F 84 21 03 00 00 79 0F F7 D9 B8 ?? ?? ?? ?? 83 E8 60 89 4D BC 85 C9 0F 84 0A 03 00 00 8B 75 E0 8B 55 E4 89 75 C0 C1 7D BC 03 83 C0 54 89 45 AC 83 E1 07 0F 84 E1 02 00 00 6B C9 0C 03 C8 B8 00 80 00 00 89 8D 78 FF FF FF 66 39 01 72 14 8B F1 8D 7D C4 A5 A5 8D 4D C4 A5 FF 4D C6 89 8D 78 FF FF FF 0F B7 79 0A 8B 45 EA 89 7D 9C 31 45 9C 25 FF 7F 00 00 81 E7 FF 7F 00 00 89 45 B0 03 C7 BE 00 80 00 00 21 75 9C 89 7D A0 0F B7 F8 8B 45 B0 4E 89 5D 8C 89 5D F0 89 5D F4 89 5D F8 89 7D B4 66 3B C6 0F 83 4A 02 00 00 66 39 75 A0 8B 75 C0 0F 83 3D 02 00 00 66 3B 7D 94 0F 87 33 02 00 00 66 3B 7D A8 77 08 89 5D E8 E9 3C 02 00 00 66 85 C0 75 20 47 F7 45 E8 FF FF FF 7F 89 7D B4 75 13 85 D2 75 0F 85 F6 75 0B 33 C0 66 89 45 EA E9 24 02 00 00 66 83 7D A0 00 75 16 47 F7 41 08 FF FF FF 7F 89 7D B4 75 09 39 59 04 75 04 39 19 74 B6 6A 05 8B C3 5E 89 45 80 8D 55 F4 89 75 B0 89 75 A0 85 F6 7E 6F 8D 75 E0 8D 04 46 8D 71 08 8B 4D A0 89 45 C0 89 B5 7C FF FF FF 0F B7 38 0F B7 06 0F AF F8 8B 42 FC 89 5D 84 8D 34 38 3B F0 89 75 A0 8B C6 72 04 3B C7 73 05 33 F6 46 EB 03 8B 75 84 89 42 FC 85 F6 74 03 66 FF 02 8B 45 C0 8B B5 7C FF FF FF 83 C0 02 83 EE 02 49 89 45 C0 89 B5 7C FF FF FF 85 C9 7F B2 8B 8D 78 FF FF FF 8B 75 B0 8B 45 80 83 C2 02 40 4E 89 45 80 89 75 B0 85 F6 0F 8F 77 FF FF FF 8B 7D B4 8B 45 F8 8B 75 F0 81 C7 02 C0 00 00 89 45 C0 66 85 FF 7E 3B 85 C0 78 32 8B 45 F4 8B C8 03 C0 8B D6 C1 EA 1F 0B C2 89 45 F4 8B 45 C0 C1 E9 1F 03 C0 0B C1 B9 FF FF 00 00 03 F6 03 F9 89 75 F0 89 45 C0 89 45 F8 66 85 FF 7F CA 66 85 FF 7F 71 B8 FF FF 00 00 03 F8 66 85 FF 79 65 8B 5D C0 8B C7 F7 D8 0F B7 C0 03 F8 33 D2 89 7D B4 8B 7D 8C 89 45 B0 42 84 55 F0 74 01 47 8B 4D F4 8B C3 C1 E0 1F 89 4D C0 D1 6D C0 09 45 C0 8B 45 C0 C1 E1 1F D1 EE D1 EB 0B F1 FF 4D B0 89 5D F8 89 45 F4 89 75 F0 75 CF 6A 00 89 5D C0 85 FF 8B 7D B4 5B 74 0F 66 8B C6 66 0B C2 66 89 45 F0 8B 75 F0 EB 04 66 8B 45 F0 B9 00 80 00 00 66 3B C1 77 0E 81 E6 FF FF 01 00 81 FE 00 80 01 00 75 40 8B 45 F2 83 F8 FF 75 34 8B 45 F6 89 5D F2 83 F8 FF 75 20 66 8B 45 FA BA FF FF 00 00 89 5D F6 66 3B C2 75 07 66 89 4D FA 47 EB 0C 66 40 66 89 45 FA EB 04 40 89 45 F6 8B 4D F8 EB 07 40 89 45 F2 8B 4D C0 B8 FF 7F 00 00 66 3B F8 73 20 66 8B 45 F2 0B 7D 9C 66 89 45 E0 8B 45 F4 89 45 E2 8B 75 E0 89 4D E6 8B 55 E4 66 89 7D EA EB 21 33 C0 66 39 45 9C 0F 94 C0 48 25 00 00 00 80 05 00 80 FF 7F 89 45 E8 8B F3 8B D3 89 75 E0 89 55 E4 89 75 C0 8B 45 AC 8B 4D BC 85 C9 0F 85 01 FD FF FF EB 06 8B 55 E4 8B 75 E0 8B 45 E8 C1 E8 10 B9 FF 3F 00 00 66 3B C1 0F 82 9E 02 00 00 FF 45 B8 8B C8 8B 45 DA 8B F8 33 F9 81 E7 00 80 00 00 89 7D AC BF FF 7F 00 00 23 C7 23 CF 89 45 8C 03 C1 0F B7 F8 B8 FF 7F 00 00 89 5D 84 89 5D F0 89 5D F4 89 5D F8 89 7D B4 66 3B C8 0F 83 40 02 00 00 8B 45 8C 66 3B 45 98 0F 83 33 02 00 00 66 3B 7D 94 0F 87 29 02 00 00 66 3B 7D A8 77 08 89 5D E8 E9 32 02 00 00 66 85 C9 75 20 47 F7 45 E8 FF FF FF 7F 89 7D B4 75 13 85 D2 75 0F 85 F6 75 0B 33 C0 66 89 45 EA E9 11 02 00 00 66 85 C0 75 19 47 F7 45 D8 FF FF FF 7F 89 7D B4 75 0C 83 7D D4 00 75 06 83 7D D0 00 74 B5 8B D3 6A 05 89 55 B0 8D 4D F4 58 8B F0 85 C0 7E 58 8D 7D E0 8D 45 D8 8D 3C 57 89 45 94 89 7D A8 0F B7 10 0F B7 07 0F AF D0 8B 41 FC 89 5D 98 8D 3C 10 3B F8 72 04 3B FA 73 05 33 C0 40 EB 03 8B 45 98 89 79 FC 85 C0 74 03 66 FF 01 8B 7D A8 8B 45 94 83 C7 02 83 E8 02 4E 89 7D A8 89 45 94 85 F6 7F BD 8B 55 B0 8B 45 A4 83 C1 02 42 48 89 55 B0 89 45 A4 85 C0 7F 93 8B 7D B4 8B 75 F8 81 C7 02 C0 00 00 66 85 FF 0F 8E 9C 00 00 00 8B 5D F0 89 5D BC 85 F6 78 2C 8B 45 F4 8B C8 8B D3 03 C0 C1 EA 1F 0B C2 89 45 F4 C1 E9 1F 03 F6 B8 FF FF 00 00 03 DB 0B F1 03 F8 89 5D F0 89 75 F8 66 85 FF 7F D0 89 5D BC 8B 55 BC 6A 00 5B 66 85 FF 7E 5B 66 8B 4D F0 B8 00 80 00 00 66 3B C8 77 12 81 E2 FF FF 01 00 81 FA 00 80 01 00 0F 85 BD 00 00 00 8B 45 F2 83 F8 FF 0F 85 AD 00 00 00 8B 45 F6 89 5D F2 83 F8 FF 0F 85 95 00 00 00 66 8B 45 FA B9 FF FF 00 00 89 5D F6 66 3B C1 75 7C B8 00 80 00 00 66 89 45 FA 47 EB 7C 8B 55 F0 B8 FF FF 00 00 03 F8 66 85 FF 79 99 8B C7 F7 D8 0F B7 C0 03 F8 89 7D B4 8B 7D 84 89 45 A4 F6 45 F0 01 74 01 47 8B 5D F4 8B CB 8B C6 C1 E0 1F C1 E1 1F D1 EB D1 EA 0B D8 0B D1 D1 EE FF 4D A4 89 5D F4 89 55 F0 75 D7 6A 00 85 FF 8B 7D B4 89 75 F8 5B 0F 84 4D FF FF FF 33 C0 66 8B CA 40 66 0B C8 66 89 4D F0 8B 55 F0 E9 3C FF FF FF 66 40 66 89 45 FA EB 04 40 89 45 F6 8B 75 F8 EB 04 40 89 45 F2 B8 FF 7F 00 00 66 3B F8 73 20 66 8B 45 F2 0B 7D AC 66 89 45 E0 8B 45 F4 89 45 E2 89 75 E6 8B 55 E4 8B 75 E0 66 89 7D EA EB 1B 33 C0 66 39 45 AC 0F 94 C0 48 25 00 00 00 80 05 00 80 FF 7F 89 45 E8 8B F3 8B D3 F6 45 18 01 8B 4D 90 8B 45 B8 8B 7D 14 66 89 01 74 36 98 03 F8 89 7D B8 85 FF 7F 2F 33 C0 66 89 01 B8 00 80 00 00 66 39 45 88 0F 95 C0 FE C8 24 0D 04 20 88 41 02 33 C0 40 88 41 03 C6 41 04 30 88 59 05 E9 AC 01 00 00 89 7D B8 6A 15 58 3B F8 7E 03 89 45 B8 8B 7D E8 C1 EF 10 81 EF FE 3F 00 00 33 C0 6A 08 89 7D 98 66 89 45 EA 8B 5D E8 5F 8B CA 8B C6 C1 E8 1F C1 E9 1F 03 D2 03 DB 03 F6 0B D9 0B D0 89 75 E0 89 5D E8 4F 75 E3 8B 7D 98 6A 00 89 5D BC 89 55 E4 89 75 C0 5B 85 FF 79 37 F7 DF 81 E7 FF 00 00 00 7E 2D 8B 5D BC 8B CA 8B C3 C1 E0 1F C1 E1 1F D1 EA D1 EE D1 EB 0B F1 0B D0 4F 89 5D E8 89 75 E0 85 FF 7F E1 89 5D BC 89 55 E4 89 75 C0 33 DB 8B 75 90 8B 45 B8 8D 7E 04 40 8B CF 89 7D 98 89 4D A4 89 45 A8 85 C0 0F 8E C8 00 00 00 8D 75 E0 8D 7D C4 A5 A5 A5 8B 7D C0 8B CA 8B C7 C1 E8 1F 03 D2 0B D0 8B 45 BC C1 E9 1F 8D 34 00 0B F1 03 FF 8B C7 8B CA C1 E8 1F 03 D2 C1 E9 1F 0B D0 8B 45 C4 03 FF 03 F6 0B F1 8D 0C 38 89 4D B8 3B CF 72 04 3B C8 73 1B 8D 42 01 8B CB 3B C2 72 05 83 F8 01 73 03 33 C9 41 85 C9 8B 4D B8 8B D0 74 01 46 8B 45 C8 8D 3C 10 3B FA 72 04 3B F8 73 01 46 8B 55 B8 03 75 CC 03 D2 8B C1 C1 E8 1F 89 55 C0 89 55 E0 8D 14 3F 0B D0 8B CF C1 E9 1F 8D 04 36 0B C1 8B 4D A4 89 45 E8 C1 E8 18 04 30 88 01 8B 45 A8 41 48 89 55 E4 89 4D A4 88 5D EB 89 45 A8 85 C0 7E 0B 8B 45 E8 89 45 BC E9 3E FF FF FF 8B 75 90 8B 7D 98 8A 41 FF 83 E9 02 3C 35 7C 43 EB 09 80 39 39 75 08 C6 01 30 49 3B CF 73 F3 3B CF 73 04 41 66 FF 06 FE 01 8B 45 90 2A C8 80 E9 03 88 48 03 0F BE C9 88 5C 01 04 33 C0 40 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 80 39 30 75 05 49 3B CF 73 F6 3B CF 73 CE 8B 4D 90 33 C0 66 89 01 B8 00 80 00 00 66 39 45 88 0F 95 C0 FE C8 24 0D 04 20 88 41 02 33 C0 40 88 41 03 C6 07 30 E9 04 FE FF FF 33 DB 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_84_1_0 {
	meta:
		name = "___add_12"
		size = 114
	strings:
		$1 = { 55 8B EC 8B 4D 08 53 8B 5D 0C 8B 01 8B 1B 56 33 F6 8D 14 18 57 8B FE 3B D0 72 04 3B D3 73 03 33 FF 47 89 11 85 FF 74 1E 8B 41 04 8B FE 8D 50 01 3B D0 72 05 83 FA 01 73 03 33 FF 47 89 51 04 85 FF 74 03 FF 41 08 8B 5D 0C 8B 41 04 8B 7B 04 8D 14 38 3B D0 72 04 3B D7 73 03 33 F6 46 89 51 04 85 F6 74 03 FF 41 08 8B 43 08 01 41 08 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_84_2_0 {
	meta:
		name = "___addl"
		size = 36
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 4D 0C 56 8D 14 08 33 F6 3B D0 72 04 3B D1 73 03 33 F6 46 8B 4D 10 8B C6 89 11 5E 5D C3 }
	condition:
		$1
}

rule file_84_3_0 {
	meta:
		name = "___ld12mul"
		size = 713
		refs = "0007 ___security_cookie 02c3 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 30 A1 ?? ?? ?? ?? 33 C5 89 45 FC 33 C0 53 8B 5D 0C 56 8B 75 08 0F B7 53 0A 0F B7 4E 0A 89 45 D0 89 45 F0 89 45 F4 89 45 F8 8B C2 33 C1 57 BF 00 80 00 00 23 C7 89 45 D8 8D 47 FF 23 C8 23 D0 89 75 DC 8D 04 0A 0F B7 F8 B8 FF 7F 00 00 89 7D EC 66 3B C8 0F 83 3E 02 00 00 66 3B D0 0F 83 35 02 00 00 B8 FD BF 00 00 66 3B F8 0F 87 27 02 00 00 B8 BF 3F 00 00 66 3B F8 77 0C 33 C0 89 46 04 89 06 E9 2C 02 00 00 33 C0 66 85 C9 75 1F 47 F7 46 08 FF FF FF 7F 89 7D EC 75 12 39 46 04 75 0D 39 06 75 09 66 89 46 0A E9 09 02 00 00 66 85 D2 75 16 47 F7 43 08 FF FF FF 7F 89 7D EC 75 09 39 43 04 75 04 39 03 74 B5 6A 05 5A 89 45 D4 8D 4D F4 89 55 E8 89 55 E4 85 D2 7E 53 8D 7B 08 89 7D E0 8B DF 8D 3C 46 8B F2 0F B7 07 0F B7 13 83 65 E4 00 0F AF D0 89 55 E0 03 51 FC 3B 51 FC 72 05 3B 55 E0 73 05 33 C0 40 EB 03 8B 45 E4 89 51 FC 85 C0 74 03 66 FF 01 83 C7 02 83 EB 02 4E 85 F6 7F C6 8B 75 DC 8B 55 E8 8B 5D 0C 8B 45 D4 83 C1 02 40 4A 89 45 D4 89 55 E8 85 D2 7F 97 8B 7D EC 8B 5D F8 81 C7 02 C0 00 00 B8 FF FF 00 00 66 85 FF 0F 8E 9E 00 00 00 8B 75 F0 89 75 EC 85 DB 78 2C 8B 45 F4 8B C8 8B D6 03 C0 C1 EA 1F 0B C2 89 45 F4 C1 E9 1F 03 DB B8 FF FF 00 00 03 F6 0B D9 03 F8 89 75 F0 89 5D F8 66 85 FF 7F D0 89 75 EC 8B 75 DC 8B 55 EC 66 85 FF 7E 5D 66 8B 45 F0 B9 00 80 00 00 66 3B C1 77 12 81 E2 FF FF 01 00 81 FA 00 80 01 00 0F 85 BA 00 00 00 8B 45 F2 83 F8 FF 0F 85 AA 00 00 00 8B 45 F6 83 65 F2 00 83 F8 FF 0F 85 91 00 00 00 66 8B 45 FA 83 65 F6 00 B9 FF FF 00 00 66 3B C1 75 77 B8 00 80 00 00 66 89 45 FA 47 EB 77 8B 55 F0 03 F8 66 85 FF 79 9C 8B 75 D0 8B C7 F7 D8 0F B7 C0 89 45 E8 03 F8 F6 45 F0 01 74 01 46 8B 4D F4 8B C3 C1 E0 1F 89 4D EC D1 6D EC 09 45 EC 8B 45 EC C1 E1 1F D1 EA 0B D1 D1 EB FF 4D E8 89 45 F4 89 55 F0 75 D1 85 F6 8B 75 DC 89 5D F8 0F 84 50 FF FF FF 33 C9 66 8B C2 41 66 0B C1 66 89 45 F0 8B 55 F0 E9 3F FF FF FF 66 40 66 89 45 FA EB 04 40 89 45 F6 8B 5D F8 EB 04 40 89 45 F2 B8 FF 7F 00 00 66 3B F8 73 19 66 8B 45 F2 0B 7D D8 66 89 06 8B 45 F4 89 46 02 89 5E 06 66 89 7E 0A EB 1E 33 C0 66 39 45 D8 0F 94 C0 83 66 04 00 48 25 00 00 00 80 05 00 80 FF 7F 83 26 00 89 46 08 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_84_4_0 {
	meta:
		name = "___multtenpow12"
		size = 862
		refs = "0007 ___security_cookie 0019 __pow10pos 002e __pow10neg 0358 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 48 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 08 57 8B 7D 0C B8 ?? ?? ?? ?? 83 E8 60 89 5D CC 85 FF 0F 84 25 03 00 00 79 0A B8 ?? ?? ?? ?? F7 DF 83 E8 60 83 7D 10 00 75 05 33 C9 66 89 0B 85 FF 0F 84 06 03 00 00 56 BE 00 80 00 00 33 D2 C7 45 C0 FF 7F 00 00 8B CF 83 C0 54 C1 FF 03 89 45 D8 89 7D 0C 83 E1 07 0F 84 D7 02 00 00 6B C9 0C 03 C8 89 4D C8 66 39 31 72 14 8B F1 8D 7D E4 A5 A5 A5 FF 4D E6 8B 7D 0C 8D 4D E4 89 4D C8 0F B7 41 0A 89 55 B8 89 55 F0 89 55 F4 89 55 F8 0F B7 53 0A 8B F0 33 F2 81 E6 00 80 00 00 89 75 D0 BE FF 7F 00 00 23 C6 23 D6 89 45 DC 03 C2 0F B7 F0 B8 FF 7F 00 00 89 75 D4 66 3B D0 0F 83 4D 02 00 00 8B 45 DC 66 3B 45 C0 0F 83 40 02 00 00 C7 45 DC FD BF 00 00 66 3B 75 DC 0F 87 2F 02 00 00 C7 45 DC BF 3F 00 00 66 3B 75 DC 77 0A 33 D2 89 53 08 E9 31 02 00 00 66 85 D2 75 23 46 33 D2 F7 43 08 FF FF FF 7F 89 75 D4 75 16 39 53 04 75 11 39 13 75 0D 33 C0 66 89 43 0A E9 0E 02 00 00 33 D2 66 85 C0 75 16 46 F7 41 08 FF FF FF 7F 89 75 D4 75 09 39 51 04 75 04 39 11 74 B3 6A 05 8B C2 5F 89 45 C4 8D 55 F4 89 7D DC 89 7D E0 85 FF 7E 55 8D 34 43 8B 5D E0 8D 79 08 0F B7 07 83 65 BC 00 89 45 E0 0F B7 06 8B 4D E0 0F AF C8 89 4D E0 03 4A FC 3B 4A FC 72 05 3B 4D E0 73 05 33 C0 40 EB 03 8B 45 BC 89 4A FC 85 C0 74 03 66 FF 02 83 C6 02 83 EF 02 4B 85 DB 7F C0 8B 5D CC 8B 4D C8 8B 7D DC 8B 45 C4 83 C2 02 40 4F 89 45 C4 89 7D DC 85 FF 7F 95 8B 75 D4 8B 55 F8 8B 7D F0 81 C6 02 C0 00 00 89 55 E0 66 85 F6 7E 3B 85 D2 78 32 8B 45 F4 8B C8 8B D7 C1 EA 1F 03 C0 0B C2 8B 55 E0 89 45 F4 C1 E9 1F 03 D2 B8 FF FF 00 00 0B D1 03 FF 03 F0 89 7D F0 89 55 E0 89 55 F8 66 85 F6 7F CA 66 85 F6 7F 69 B8 FF FF 00 00 03 F0 66 85 F6 79 5D 8B 5D B8 8B C6 F7 D8 0F B7 C0 89 45 DC 03 F0 F6 45 F0 01 74 01 43 8B 4D F4 8B C2 C1 E0 1F 89 4D E0 D1 6D E0 09 45 E0 8B 45 E0 C1 E1 1F D1 EF D1 EA 0B F9 FF 4D DC 89 55 F8 89 45 F4 89 7D F0 75 CE 85 DB 8B 5D CC 89 55 E0 74 12 33 C9 66 8B C7 41 66 0B C1 66 89 45 F0 8B 7D F0 EB 04 66 8B 45 F0 B9 00 80 00 00 66 3B C1 77 0E 81 E7 FF FF 01 00 81 FF 00 80 01 00 75 42 8B 45 F2 83 F8 FF 75 36 8B 45 F6 33 D2 89 55 F2 83 F8 FF 75 20 66 8B 45 FA BF FF FF 00 00 89 55 F6 66 3B C7 75 07 66 89 4D FA 46 EB 0C 66 40 66 89 45 FA EB 04 40 89 45 F6 8B 4D F8 EB 09 40 89 45 F2 8B 4D E0 33 D2 8B 7D 0C B8 FF 7F 00 00 66 3B F0 72 16 33 C0 66 39 45 D0 0F 94 C0 48 25 00 00 00 80 05 00 80 FF 7F EB 2F 66 8B 45 F2 0B 75 D0 66 89 03 8B 45 F4 89 43 02 89 4B 06 66 89 73 0A EB 1E 33 C0 66 39 45 D0 0F 94 C0 48 25 00 00 00 80 05 00 80 FF 7F 33 D2 89 43 08 89 13 89 53 04 8B 45 D8 BE 00 80 00 00 85 FF 0F 85 0A FD FF FF 5E 8B 4D FC 5F 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_84_5_0 {
	meta:
		name = "___shl_12"
		size = 49
	strings:
		$1 = { 55 8B EC 56 57 8B 7D 08 8B 07 8B 4F 04 8B D0 03 C0 89 07 C1 EA 1F 8D 04 09 0B C2 89 47 04 8B 47 08 8B F1 C1 EE 1F 03 C0 0B C6 89 47 08 5F 5E 5D C3 }
	condition:
		$1
}

rule file_84_6_0 {
	meta:
		name = "___shr_12"
		size = 48
	strings:
		$1 = { 55 8B EC 56 57 8B 7D 08 8B 4F 08 8B 47 04 8B D0 8B F1 D1 E8 C1 E6 1F 0B C6 89 47 04 8B 07 C1 E2 1F D1 E9 D1 E8 0B C2 89 4F 08 89 07 5F 5E 5D C3 }
	condition:
		$1
}

rule file_86_3_0 {
	meta:
		name = "__mbsncmp"
		size = 24
		refs = "000f __mbsncmp_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_26_0_1 {
	meta:
		name = "__Stod"
		size = 24
		refs = "000f __Stodx"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_3_0_2 {
	meta:
		name = "__Stof"
		size = 24
		refs = "000f __Stofx"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_20_0_2 {
	meta:
		name = "__Stold"
		size = 24
		refs = "000f __Stoldx"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_114_0_2 {
	meta:
		name = "__Stoll"
		size = 24
		refs = "000f __Stollx"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_63_0_2 {
	meta:
		name = "__Stoul"
		size = 24
		refs = "000f __Stoulx"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_111_0_1 {
	meta:
		name = "__Stoull"
		size = 24
		refs = "000f __Stoullx"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_2_0_1 {
	meta:
		name = "__WStod"
		size = 24
		refs = "000f __WStodx"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_65_0_2 {
	meta:
		name = "__WStof"
		size = 24
		refs = "000f __WStofx"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_1_0_2 {
	meta:
		name = "__WStold"
		size = 24
		refs = "000f __WStoldx"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_672_6_0 {
	meta:
		name = "__aligned_realloc"
		size = 24
		refs = "000f __aligned_offset_realloc"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_705_18_0 {
	meta:
		name = "__fassign"
		size = 24
		refs = "000f __fassign_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_882_0_0 {
	meta:
		name = "__mbscat_s"
		size = 24
		refs = "000f __mbscat_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_676_0_0 {
	meta:
		name = "__mbscpy_s"
		size = 24
		refs = "000f __mbscpy_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_299_3_0 {
	meta:
		name = "__mbsnbcat"
		size = 24
		refs = "000f __mbsnbcat_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_342_3_0 {
	meta:
		name = "__mbsnbcmp"
		size = 24
		refs = "000f __mbsnbcmp_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_656_3_0 {
	meta:
		name = "__mbsnbcoll"
		size = 24
		refs = "000f __mbsnbcoll_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_570_3_0 {
	meta:
		name = "__mbsnbcpy"
		size = 24
		refs = "000f __mbsnbcpy_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_97_3_0 {
	meta:
		name = "__mbsnbicmp"
		size = 24
		refs = "000f __mbsnbicmp_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_1111_3_0 {
	meta:
		name = "__mbsnbicoll"
		size = 24
		refs = "000f __mbsnbicoll_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_698_3_0 {
	meta:
		name = "__mbsnbset"
		size = 24
		refs = "000f __mbsnbset_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_225_3_0 {
	meta:
		name = "__mbsncat"
		size = 24
		refs = "000f __mbsncat_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_718_3_0 {
	meta:
		name = "__mbsncoll"
		size = 24
		refs = "000f __mbsncoll_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_622_3_0 {
	meta:
		name = "__mbsncpy"
		size = 24
		refs = "000f __mbsncpy_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_131_3_0 {
	meta:
		name = "__mbsnicmp"
		size = 24
		refs = "000f __mbsnicmp_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_289_3_0 {
	meta:
		name = "__mbsnicoll"
		size = 24
		refs = "000f __mbsnicoll_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_801_3_0 {
	meta:
		name = "__mbsnset"
		size = 24
		refs = "000f __mbsnset_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_403_0_0 {
	meta:
		name = "__mbsset_s"
		size = 24
		refs = "000f __mbsset_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_1063_3_0 {
	meta:
		name = "__mbstok_s"
		size = 24
		refs = "000f __mbstok_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_893_0_0 {
	meta:
		name = "__spawnvp"
		size = 24
		refs = "000f __spawnvpe"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_899_1_0 {
	meta:
		name = "__wcstol_l"
		size = 24
		refs = "000f ?wcstoxl@@YAKPB_WPAPB_WHH@Z"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_583_0_0 {
	meta:
		name = "__wspawnvp"
		size = 24
		refs = "000f __wspawnvpe"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_657_4_0 {
	meta:
		name = "_mbtowc"
		size = 24
		refs = "000f __mbtowc_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_126_4_0 {
	meta:
		name = "_strxfrm"
		size = 24
		refs = "000f __strxfrm_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_899_3_0 {
	meta:
		name = "_wcstol"
		size = 24
		refs = "000f ?wcstoxl@@YAKPB_WPAPB_WHH@Z"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_422_7_0 {
	meta:
		name = "_wcstombs"
		size = 24
		refs = "000f __wcstombs_l_helper"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_1042_4_0 {
	meta:
		name = "_wcsxfrm"
		size = 24
		refs = "000f __wcsxfrm_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_86_4_0 {
	meta:
		name = "__mbsncmp_l"
		size = 237
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0031 _strncmp 0051 __errno 005c __invalid_parameter_noinfo"
	strings:
		$1 = { 55 8B EC 83 EC 10 8D 4D F0 53 56 57 FF 75 14 E8 ?? ?? ?? ?? 8B 7D 10 33 D2 85 FF 0F 84 B8 00 00 00 8B 45 F4 39 50 08 75 16 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 8B D0 E9 9A 00 00 00 8B 75 08 85 F6 74 0A 8B 5D 0C 89 5D 10 85 DB 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? BA FF FF FF 7F EB 72 0F B6 0E 8B 5D F4 4F 8B C1 46 F6 44 18 19 04 8B 5D 10 74 17 8A 06 84 C0 75 04 8B CA EB 0D C1 E1 08 0F B6 C0 66 0B C8 0F B7 C9 46 0F B6 1B 8B 55 F4 FF 45 10 8B C3 6A 00 F6 44 10 19 04 5A 74 1C 8B 45 10 8A 00 84 C0 75 04 8B DA EB 0F C1 E3 08 0F B6 C0 66 0B D8 FF 45 10 0F B7 DB 66 3B D9 75 0B 66 85 C9 74 0C 85 FF 75 96 EB 06 1B D2 83 E2 02 4A 80 7D FC 00 5F 5E 5B 74 07 8B 4D F8 83 61 70 FD 8B C2 C9 C3 }
	condition:
		$1
}

rule file_87_0_0 {
	meta:
		name = "??_N@YGXPAXIHP6EX0@Z1@Z"
		size = 102
		refs = "0003 __sehtable$??_N@YGXPAXIHP6EX0@Z1@Z 0008 __SEH_prolog4 0044 __SEH_epilog4 0061 ?__ArrayUnwind@@YGXPAXIHP6EX0@Z@Z"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 F6 89 75 E4 89 75 FC 89 75 E0 33 DB 43 8B 7D 08 3B 75 10 7D 12 53 8B CF FF 55 14 03 7D 0C 89 7D 08 46 89 75 E0 EB E9 89 5D E4 C7 45 FC FE FF FF FF E8 11 00 00 00 E8 ?? ?? ?? ?? C2 14 00 8B 7D 08 8B 5D E4 8B 75 E0 85 DB 75 0D FF 75 18 56 FF 75 0C 57 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_88_3_0 {
	meta:
		name = "?__crtCompareStringA_stat@@YAHPAUlocaleinfo_struct@@PB_WKPBDH2HH@Z"
		size = 619
		refs = "0007 ___security_cookie 0035 ?strncnt@@YAHPBDH@Z 00b1 __imp__GetCPInfo@8 012b __imp__MultiByteToWideChar@24 015c __alloca_probe_16 0170 _malloc 023e ___crtCompareStringEx 024a __freea 0265 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 2C A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 8B 4D 1C 53 89 45 E0 8B 45 0C 56 8B 75 18 89 45 D4 8B 45 14 57 89 45 E4 89 4D DC 85 F6 7E 22 56 50 E8 ?? ?? ?? ?? 59 59 8B 4D DC 8B F0 8B 7D 20 85 FF 7E 19 57 51 E8 ?? ?? ?? ?? 59 59 8B F8 EB 11 83 FE FF 7D E7 33 C0 E9 F9 01 00 00 83 FF FF 7C F4 8B 45 24 33 DB 89 5D D8 85 C0 75 0B 8B 45 E0 8B 00 8B 40 04 89 45 24 85 F6 74 08 85 FF 0F 85 96 00 00 00 3B F7 75 08 6A 02 58 E9 C5 01 00 00 83 FF 01 7E 08 33 C0 40 E9 B8 01 00 00 83 FE 01 7E 04 6A 03 EB E4 8D 4D E8 51 50 FF 15 ?? ?? ?? ?? 85 C0 74 A0 85 F6 7E 2B 83 7D E8 02 72 E3 8D 45 EE 38 5D EE 74 DB 8B 75 E4 8A 48 01 84 C9 74 D1 8A 16 3A 10 72 04 3A D1 76 AD 83 C0 02 38 18 75 E8 EB BE 85 FF 7E 32 83 7D E8 02 72 A7 8D 45 EE 38 5D EE 74 9F 8B 75 DC 8A 48 01 84 C9 74 95 8A 16 3A 10 72 08 3A D1 0F 86 7A FF FF FF 83 C0 02 38 18 75 E4 E9 7B FF FF FF 53 53 56 FF 75 E4 6A 09 FF 75 24 FF 15 ?? ?? ?? ?? 8B C8 89 4D E0 85 C9 0F 84 1D FF FF FF 7E 49 6A E0 33 D2 58 F7 F1 83 F8 02 72 3D 8D 0C 4D 08 00 00 00 81 F9 00 04 00 00 77 15 8B C1 E8 ?? ?? ?? ?? 8B DC 85 DB 74 1E C7 03 CC CC 00 00 EB 13 51 E8 ?? ?? ?? ?? 8B D8 59 85 DB 74 09 C7 03 DD DD 00 00 83 C3 08 8B 4D E0 85 DB 0F 84 CA FE FF FF 51 53 56 FF 75 E4 8B 75 24 6A 01 56 FF 15 ?? ?? ?? ?? 85 C0 0F 84 A6 00 00 00 33 C0 50 50 57 FF 75 DC 6A 09 56 FF 15 ?? ?? ?? ?? 8B C8 89 4D E4 85 C9 0F 84 88 00 00 00 7E 4B 6A E0 33 D2 58 F7 F1 83 F8 02 72 3F 8D 0C 4D 08 00 00 00 81 F9 00 04 00 00 77 15 8B C1 E8 ?? ?? ?? ?? 8B F4 85 F6 74 1E C7 06 CC CC 00 00 EB 13 51 E8 ?? ?? ?? ?? 8B F0 59 85 F6 74 09 C7 06 DD DD 00 00 83 C6 08 8B 4D E4 EB 02 33 F6 85 F6 74 35 51 56 57 FF 75 DC 6A 01 FF 75 24 FF 15 ?? ?? ?? ?? 85 C0 74 19 FF 75 E4 56 FF 75 E0 53 FF 75 10 FF 75 D4 E8 ?? ?? ?? ?? 83 C4 18 89 45 D8 56 E8 ?? ?? ?? ?? 59 53 E8 ?? ?? ?? ?? 8B 45 D8 59 8D 65 C8 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_88_4_0 {
	meta:
		name = "?strncnt@@YAHPBDH@Z"
		size = 32
		altNames = "___strncnt"
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 55 08 8B C8 85 C0 74 0B 49 80 3A 00 74 06 42 85 C9 75 F5 49 2B C1 48 5D C3 }
	condition:
		$1
}

rule file_88_5_0 {
	meta:
		name = "__MarkAllocaS"
		size = 20
	strings:
		$1 = { 55 8B EC 8B 45 08 85 C0 74 08 8B 4D 0C 89 08 83 C0 08 5D C3 }
	condition:
		$1
}

rule file_88_6_0 {
	meta:
		name = "___crtCompareStringA"
		size = 65
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002b ?__crtCompareStringA_stat@@YAHPAUlocaleinfo_struct@@PB_WKPBDH2HH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 08 8D 4D F0 E8 ?? ?? ?? ?? FF 75 24 8D 45 F0 FF 75 20 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C 50 E8 ?? ?? ?? ?? 83 C4 20 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_88_7_0 {
	meta:
		name = "__freea"
		size = 30
		refs = "0017 _free"
	strings:
		$1 = { 55 8B EC 8B 45 08 85 C0 74 12 83 E8 08 81 38 DD DD 00 00 75 07 50 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "__wsplitpath"
		size = 74
		refs = "0041 __wsplitpath_helper"
	strings:
		$1 = { 55 8B EC 8B 45 18 F7 D8 1B C0 B9 00 01 00 00 23 C1 50 FF 75 18 8B 45 14 F7 D8 1B C0 23 C1 50 8B 45 10 FF 75 14 F7 D8 1B C0 23 C1 50 8B 45 0C FF 75 10 F7 D8 1B C0 83 E0 03 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 24 5D C3 }
	condition:
		$1
}

rule file_203_0_0 {
	meta:
		name = "__splitpath"
		size = 74
		refs = "0041 __splitpath_helper"
	strings:
		$1 = { 55 8B EC 8B 45 18 F7 D8 1B C0 B9 00 01 00 00 23 C1 50 FF 75 18 8B 45 14 F7 D8 1B C0 23 C1 50 8B 45 10 FF 75 14 F7 D8 1B C0 23 C1 50 8B 45 0C FF 75 10 F7 D8 1B C0 83 E0 03 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 24 5D C3 }
	condition:
		$1
}

rule file_89_1_0 {
	meta:
		name = "__wsplitpath_helper"
		size = 501
		refs = "008a _wcsncpy_s 01cf __errno 01dd __invalid_parameter_noinfo"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 7D 08 33 DB 85 FF 74 0C 8B 4D 0C 85 C9 75 13 39 5D 10 74 13 8B 55 1C 33 DB 43 8B 45 24 E9 63 01 00 00 39 5D 10 74 ED 39 5D 14 75 07 39 5D 18 75 E3 EB 05 39 5D 18 74 DC 8B 55 1C 85 D2 75 07 39 5D 20 75 D3 EB 05 39 5D 20 74 CC 39 5D 24 75 07 39 5D 28 75 C2 EB 05 39 5D 28 74 BB 33 C0 40 8B F7 66 39 1E 74 06 83 C6 02 48 75 F5 66 83 3E 3A 75 20 85 C9 74 17 83 7D 10 03 72 9E 6A 02 57 6A FF 51 E8 ?? ?? ?? ?? 8B 55 1C 83 C4 10 8D 7E 02 EB 09 85 C9 74 05 33 C0 66 89 01 0F B7 07 8B CB 8B F7 66 85 C0 74 57 66 83 F8 2F 74 10 66 83 F8 5C 74 0A 66 83 F8 2E 75 07 8B DE EB 03 8D 4E 02 83 C6 02 0F B7 06 66 85 C0 75 DC 89 4D 08 85 C9 74 2C 8B 45 14 85 C0 74 21 8B C1 2B C7 D1 F8 39 45 18 0F 86 98 00 00 00 50 57 6A FF FF 75 14 E8 ?? ?? ?? ?? 8B 4D 08 83 C4 10 8B F9 EB 0C 8B 45 14 85 C0 74 05 33 C9 66 89 08 85 DB 74 45 3B DF 72 41 8B 55 1C 85 D2 74 1B 8B C3 2B C7 D1 F8 39 45 20 76 5C 50 57 6A FF 52 E8 ?? ?? ?? ?? 8B 55 1C 83 C4 10 8B 45 24 85 C0 74 41 2B F3 D1 FE 39 75 28 76 3F 56 53 6A FF 50 E8 ?? ?? ?? ?? 83 C4 10 EB 29 8B 55 1C 85 D2 74 16 2B F7 D1 FE 39 75 20 76 1D 56 57 6A FF 52 E8 ?? ?? ?? ?? 83 C4 10 8B 45 24 85 C0 74 05 33 C9 66 89 08 33 C0 EB 69 8B 45 24 33 DB 8B 4D 0C 85 C9 74 0B 83 7D 10 00 76 05 33 F6 66 89 31 8B 4D 14 85 C9 74 0B 83 7D 18 00 76 05 33 F6 66 89 31 85 D2 74 0B 83 7D 20 00 76 05 33 C9 66 89 0A 85 C0 74 0B 83 7D 28 00 76 05 33 C9 66 89 08 E8 ?? ?? ?? ?? 85 FF 75 0E 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 0B 85 DB 75 EE 6A 22 59 89 08 8B C1 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_91_0_0 {
	meta:
		name = "__findfirst32i64"
		size = 297
		refs = "000a ___security_cookie 001f __errno 002a __invalid_parameter_noinfo 0049 __imp__FindFirstFileExA@24 0056 __imp__GetLastError@0 0087 @__security_check_cookie@4 00c0 ___timet_from_ft 010c _strcpy_s 0124 __invoke_watson"
	strings:
		$1 = { 55 8B EC 81 EC 44 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 0C 85 F6 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 4D 85 C0 74 E7 53 57 33 DB 53 53 53 8D 8D BC FE FF FF 51 53 50 FF 15 ?? ?? ?? ?? 8B F8 83 FF FF 75 4F FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 34 83 F8 08 74 22 83 F8 12 74 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 5F 5B 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? C9 C3 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB E1 E8 ?? ?? ?? ?? 89 30 EB D8 8B 85 BC FE FF FF 83 C0 80 F7 D8 1B C0 23 85 BC FE FF FF 89 06 8D 85 C0 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 04 8D 85 C8 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 D0 FE FF FF 50 E8 ?? ?? ?? ?? 8B 8D D8 FE FF FF 89 46 0C 33 C0 03 85 DC FE FF FF 89 46 10 8D 85 E8 FE FF FF 50 8D 46 18 13 CB 68 04 01 00 00 50 89 4E 14 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 07 8B C7 E9 60 FF FF FF 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_91_1_0 {
	meta:
		name = "__findnext32i64"
		size = 285
		refs = "000a ___security_cookie 0023 __errno 002e __invalid_parameter_noinfo 003c @__security_check_cookie@4 0050 __imp__FindNextFileA@8 005a __imp__GetLastError@0 00b4 ___timet_from_ft 0103 _strcpy_s 0118 __invoke_watson"
	strings:
		$1 = { 55 8B EC 81 EC 44 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 4D 08 56 8B 75 0C 57 83 CF FF 3B CF 75 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8B C7 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 85 F6 74 DC 8D 85 BC FE FF FF 50 51 FF 15 ?? ?? ?? ?? 85 C0 75 3F FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 24 83 F8 08 74 12 83 F8 12 74 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB B1 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB A4 E8 ?? ?? ?? ?? 89 30 EB 9B 8B 85 BC FE FF FF 83 C0 80 F7 D8 1B C0 23 85 BC FE FF FF 89 06 8D 85 C0 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 04 8D 85 C8 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 D0 FE FF FF 50 E8 ?? ?? ?? ?? 8B 8D D8 FE FF FF 89 46 0C 33 C0 03 85 DC FE FF FF 6A 00 5F 89 46 10 8D 85 E8 FE FF FF 50 8D 46 18 13 CF 68 04 01 00 00 50 89 4E 14 E8 ?? ?? ?? ?? 83 C4 18 85 C0 0F 84 22 FF FF FF 57 57 57 57 57 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_92_0_0 {
	meta:
		name = "??$_InternalDeleteHelper@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@YAXPAVVirtualProcessor@01@@Z"
		size = 18
		altNames = "??$_InternalDeleteHelper@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@YAXPAVScheduleGroupSegmentBase@01@@Z"
	strings:
		$1 = { 55 8B EC 8B 4D 08 85 C9 74 06 8B 01 6A 01 FF 10 5D C3 }
	condition:
		$1
}

rule file_92_1_0 {
	meta:
		name = "??0?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAE@PAV_HyperNonReentrantLock@12@@Z"
		size = 103
		refs = "0021 ??_U@YAPAXI@Z 0057 _memset"
		altNames = "??0?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@PAV_CriticalNonReentrantLock@12@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 53 56 57 8B F1 6A 3F 33 DB 5F 89 1E 68 00 01 00 00 89 5E 04 89 46 14 89 7E 08 E8 ?? ?? ?? ?? 89 46 0C C7 04 24 00 02 00 00 E8 ?? ?? ?? ?? 59 85 C0 74 0F 8B C8 4F 89 19 89 59 04 8D 49 08 79 F5 EB 02 8B C3 68 00 01 00 00 53 FF 76 0C 89 46 10 E8 ?? ?? ?? ?? 83 C4 0C 8B C6 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_92_7_0 {
	meta:
		name = "??0VirtualProcessor@details@Concurrency@@QAE@XZ"
		size = 81
		refs = "000d ??_7VirtualProcessor@details@Concurrency@@6B@ 0012 ??0?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAE@PAV_HyperNonReentrantLock@12@@Z"
	strings:
		$1 = { 56 57 8B F9 8D 77 78 56 8D 4F 0C C7 07 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C9 89 4F 24 89 4F 28 89 4F 3C 89 4F 40 89 0E 8B 06 89 8F 88 00 00 00 89 8F 90 00 00 00 89 8F 94 00 00 00 89 8F 98 00 00 00 89 8F 9C 00 00 00 89 8F B4 00 00 00 8B C7 5F 5E C3 }
	condition:
		$1
}

rule file_92_8_0 {
	meta:
		name = "??0WorkSearchContext@details@Concurrency@@QAE@XZ"
		size = 16
	strings:
		$1 = { 33 C0 89 01 89 41 04 89 41 18 89 41 1C 8B C1 C3 }
	condition:
		$1
}

rule file_92_11_0 {
	meta:
		name = "??0location@Concurrency@@QAE@ABV01@@Z"
		size = 21
		refs = "000a ?_Assign@location@Concurrency@@QAEXABV12@@Z"
		altNames = "??4location@Concurrency@@QAEAAV01@ABV01@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_80_70_1 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAE@ABV01@@Z"
		size = 21
		refs = "000a ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAE@ABV01@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_62_200_1 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAE@ABV01@@Z"
		size = 21
		refs = "000a ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAE@ABV01@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_32_28_1 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAE@ABV01@@Z"
		size = 21
		refs = "000a ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAE@ABV01@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_100_328_1 {
	meta:
		name = "??0?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QAE@ABV01@@Z"
		size = 21
		refs = "000a ??0?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QAE@ABV01@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_100_330_1 {
	meta:
		name = "??0?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QAE@ABV01@@Z"
		size = 21
		refs = "000a ??0?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QAE@ABV01@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_100_368_1 {
	meta:
		name = "??0?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@QAE@ABV01@@Z"
		size = 21
		refs = "000a ??0?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QAE@ABV01@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_100_370_1 {
	meta:
		name = "??0?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@QAE@ABV01@@Z"
		size = 21
		refs = "000a ??0?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QAE@ABV01@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_80_170_1 {
	meta:
		name = "??4?$_Iterator012@Urandom_access_iterator_tag@std@@DHPBDABDU_Iterator_base12@2@@std@@QAEAAU01@ABU01@@Z"
		size = 21
		refs = "000a ??4_Iterator_base12@std@@QAEAAU01@ABU01@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_62_384_1 {
	meta:
		name = "??4?$_Iterator012@Urandom_access_iterator_tag@std@@GHPBGABGU_Iterator_base12@2@@std@@QAEAAU01@ABU01@@Z"
		size = 21
		refs = "000a ??4_Iterator_base12@std@@QAEAAU01@ABU01@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_62_385_1 {
	meta:
		name = "??4?$_Iterator012@Urandom_access_iterator_tag@std@@_WHPB_WAB_WU_Iterator_base12@2@@std@@QAEAAU01@ABU01@@Z"
		size = 21
		refs = "000a ??4_Iterator_base12@std@@QAEAAU01@ABU01@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_765_110_0 {
	meta:
		name = "??4QuickBitSet@details@Concurrency@@QAEAAV012@ABV012@@Z"
		size = 21
		refs = "000a ?CopyFrom@QuickBitSet@details@Concurrency@@IAEXABV123@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_80_197_1 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAEAAV01@H@Z"
		size = 21
		refs = "000a ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAEAAV01@H@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_62_437_1 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAEAAV01@H@Z"
		size = 21
		refs = "000a ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAEAAV01@H@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_62_438_1 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAEAAV01@H@Z"
		size = 21
		refs = "000a ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAEAAV01@H@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_99_569_1 {
	meta:
		name = "??Y?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QAEAAV01@H@Z"
		size = 21
		refs = "000a ??Y?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QAEAAV01@H@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_99_570_1 {
	meta:
		name = "??Y?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QAEAAV01@H@Z"
		size = 21
		refs = "000a ??Y?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QAEAAV01@H@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_92_13_0 {
	meta:
		name = "??1?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAE@XZ"
		size = 23
		refs = "0007 ??_V@YAXPAX@Z"
		altNames = "??1?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 56 8B F1 FF 76 0C E8 ?? ?? ?? ?? FF 76 10 E8 ?? ?? ?? ?? 59 59 5E C3 }
	condition:
		$1
}

rule file_92_16_0 {
	meta:
		name = "??1Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 23
		refs = "0007 ??_V@YAXPAX@Z"
		altNames = "??1Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 56 8B F1 FF 76 0C E8 ?? ?? ?? ?? FF 76 08 E8 ?? ?? ?? ?? 59 59 5E C3 }
	condition:
		$1
}

rule file_92_17_0 {
	meta:
		name = "??1VirtualProcessor@details@Concurrency@@UAE@XZ"
		size = 75
		refs = "0003 __ehhandler$??1VirtualProcessor@details@Concurrency@@UAE@XZ 0008 __EH_prolog3 0013 ??_7VirtualProcessor@details@Concurrency@@6B@ 0028 ?ReturnSubAllocator@SchedulerBase@details@Concurrency@@SAXPAVSubAllocator@23@@Z 0038 ??_V@YAXPAX@Z 0041 ??1?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAE@XZ 0046 __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 F0 C7 06 ?? ?? ?? ?? 83 7E 50 00 C7 45 FC 01 00 00 00 74 0D FF 76 50 E8 ?? ?? ?? ?? 83 66 50 00 59 FF B6 9C 00 00 00 E8 ?? ?? ?? ?? 59 8D 4E 0C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_92_28_0 {
	meta:
		name = "?AcknowledgedAffinityMessage@SchedulerBase@details@Concurrency@@QAE_NI@Z"
		size = 55
	strings:
		$1 = { 55 8B EC 56 8B F1 8B 4D 08 8B 46 58 33 D2 57 8B F9 83 E1 1F 42 C1 EF 05 D3 E2 C1 E7 02 85 14 07 0F 95 C0 84 C0 74 0A 8B 4E 58 F7 D2 03 CF F0 21 11 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_92_30_0 {
	meta:
		name = "?Affinitize@VirtualProcessor@details@Concurrency@@MAEXPAVInternalContextBase@23@@Z"
		size = 61
		refs = "0011 ?SpinUntilBlocked@InternalContextBase@details@Concurrency@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 57 8B F9 85 F6 74 0F 8B CE E8 ?? ?? ?? ?? 8B 06 57 8B CE FF 50 1C 89 77 70 85 F6 74 13 F6 86 B3 00 00 00 01 74 0A FF 47 60 80 A6 B3 00 00 00 FE 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_92_31_0 {
	meta:
		name = "?CheckAffinityNotification@VirtualProcessor@details@Concurrency@@QAE_NXZ"
		size = 30
		refs = "0019 ?AcknowledgedAffinityMessage@SchedulerBase@details@Concurrency@@QAE_NI@Z"
	strings:
		$1 = { 80 79 56 00 74 07 C6 41 56 00 B0 01 C3 8B 41 44 FF B1 84 00 00 00 8B 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_92_32_0 {
	meta:
		name = "?CheckForDeletion@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@AAEXXZ"
		size = 38
		refs = "0007 ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 0015 ?DeleteElements@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z"
	strings:
		$1 = { 56 8B F1 8B 4E 24 E8 ?? ?? ?? ?? 84 C0 75 15 FF 76 10 8B CE E8 ?? ?? ?? ?? 83 66 10 00 33 C9 8D 46 48 87 08 5E C3 }
	condition:
		$1
}

rule file_860_86_0 {
	meta:
		name = "?CheckForDeletion@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@AAEXXZ"
		size = 38
		refs = "0007 ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 0015 ?DeleteElements@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z"
	strings:
		$1 = { 56 8B F1 8B 4E 24 E8 ?? ?? ?? ?? 84 C0 75 15 FF 76 10 8B CE E8 ?? ?? ?? ?? 83 66 10 00 33 C9 8D 46 48 87 08 5E C3 }
	condition:
		$1
}

rule file_829_17_0 {
	meta:
		name = "?CheckForDeletion@?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@AAEXXZ"
		size = 38
		refs = "0007 ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 0015 ?DeleteElements@?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z"
	strings:
		$1 = { 56 8B F1 8B 4E 24 E8 ?? ?? ?? ?? 84 C0 75 15 FF 76 10 8B CE E8 ?? ?? ?? ?? 83 66 10 00 33 C9 8D 46 48 87 08 5E C3 }
	condition:
		$1
}

rule file_553_65_0 {
	meta:
		name = "?CheckForDeletion@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@AAEXXZ"
		size = 38
		refs = "0007 ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 0015 ?DeleteElements@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z"
	strings:
		$1 = { 56 8B F1 8B 4E 24 E8 ?? ?? ?? ?? 84 C0 75 15 FF 76 10 8B CE E8 ?? ?? ?? ?? 83 66 10 00 33 C9 8D 46 48 87 08 5E C3 }
	condition:
		$1
}

rule file_92_34_0 {
	meta:
		name = "?Claim@Slot@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAE_NPAPAVInternalContextBase@34@@Z"
		size = 71
		refs = "003b ?Dereference@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 57 8B 06 8B 56 04 8B 40 0C 8B 3C 90 83 FF 01 74 21 8B 06 8B 4E 04 8B 40 0C 33 D2 42 8D 04 88 87 10 3B D7 75 0D 8B 4D 08 85 C9 74 02 89 39 B0 01 EB 09 8B 0E E8 ?? ?? ?? ?? 32 C0 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_185_34_0 {
	meta:
		name = "?Claim@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE_NPAPAV_UnrealizedChore@34@@Z"
		size = 71
		refs = "003b ?Dereference@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 57 8B 06 8B 56 04 8B 40 0C 8B 3C 90 83 FF 01 74 21 8B 06 8B 4E 04 8B 40 0C 33 D2 42 8D 04 88 87 10 3B D7 75 0D 8B 4D 08 85 C9 74 02 89 39 B0 01 EB 09 8B 0E E8 ?? ?? ?? ?? 32 C0 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_92_35_0 {
	meta:
		name = "?ClaimExclusiveOwnership@VirtualProcessor@details@Concurrency@@QAE_NAAVClaimTicket@123@K_N@Z"
		size = 165
	strings:
		$1 = { 55 8B EC 53 8B 5D 0C 56 8B F1 57 8D 46 04 8B 38 85 FB 74 27 83 FB 0F 75 0B 33 D2 87 10 85 D2 0F 95 C0 EB 22 33 C9 8B C7 8D 56 04 F0 0F B1 0A 8B D0 3B D7 74 0F 8B FA 85 D3 75 E9 32 C0 5F 5E 5B 5D C2 0C 00 B0 01 84 C0 74 F1 80 7D 10 00 74 46 8B 46 44 83 CF FF 8B 08 81 C1 AC 01 00 00 8B C7 F0 0F C1 01 8B 4E 44 83 C1 1C 8B C7 F0 0F C1 01 83 FA 04 74 05 83 FA 08 75 1C 8B 46 44 8B 08 81 C1 B0 01 00 00 8B C7 F0 0F C1 01 8B 4E 44 83 C1 20 F0 0F C1 39 4F 8B 4D 08 B0 01 89 11 89 71 04 89 56 08 EB 98 }
	condition:
		$1
}

rule file_92_38_0 {
	meta:
		name = "?ClearQuickCacheSlot@SchedulerBase@details@Concurrency@@QAEXI@Z"
		size = 37
	strings:
		$1 = { 55 8B EC 8B 51 5C 56 8B 75 08 33 C0 C1 E6 07 40 39 04 16 75 0B 8B 49 5C 33 D2 03 CE F0 0F B1 11 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_92_42_0 {
	meta:
		name = "?DeleteElements@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z"
		size = 36
	strings:
		$1 = { 55 8B EC 56 8B 75 08 EB 12 8D 8E 50 FF FF FF 8B 36 85 C9 74 06 8B 01 6A 01 FF 10 85 F6 75 EA 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_92_43_0 {
	meta:
		name = "?Dereference@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAEXXZ"
		size = 29
		refs = "0010 ?StaticDelete@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@SAXPAU1234@@Z 0018 ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QAEXP6AXPAX@Z0PAVSchedulerBase@23@@Z"
	strings:
		$1 = { 8D 41 14 83 CA FF F0 0F C1 10 75 10 FF 31 51 68 ?? ?? ?? ?? 83 C1 1C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_185_43_0 {
	meta:
		name = "?Dereference@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAEXXZ"
		size = 29
		refs = "0010 ?StaticDelete@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@SAXPAU1234@@Z 0018 ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QAEXP6AXPAX@Z0PAVSchedulerBase@23@@Z"
	strings:
		$1 = { 8D 41 14 83 CA FF F0 0F C1 10 75 10 FF 31 51 68 ?? ?? ?? ?? 83 C1 1C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_92_45_0 {
	meta:
		name = "?Exercise@ClaimTicket@VirtualProcessor@details@Concurrency@@QAE_NPAVScheduleGroupSegmentBase@34@@Z"
		size = 29
		refs = "0011 ?ExerciseClaim@VirtualProcessor@details@Concurrency@@AAE_NW4AvailabilityType@123@PAVScheduleGroupSegmentBase@23@PAVInternalContextBase@23@@Z"
	strings:
		$1 = { 55 8B EC 56 6A 00 FF 75 08 8B F1 FF 36 8B 4E 04 E8 ?? ?? ?? ?? 83 26 00 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_92_46_0 {
	meta:
		name = "?ExerciseClaim@VirtualProcessor@details@Concurrency@@AAE_NW4AvailabilityType@123@PAVScheduleGroupSegmentBase@23@PAVInternalContextBase@23@@Z"
		size = 116
		refs = "002b ?VirtualProcessorActive@SchedulerBase@details@Concurrency@@QAE_N_N@Z 0041 ?ReleaseInternalContext@SchedulerBase@details@Concurrency@@QAEXPAVInternalContextBase@23@_N@Z 004d ?MakeAvailable@VirtualProcessor@details@Concurrency@@IAEXW4AvailabilityType@123@_N@Z 005f ?GetAnonymousScheduleGroupSegment@SchedulerBase@details@Concurrency@@QAEPAVScheduleGroupSegmentBase@23@XZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 57 8B 46 44 8B 38 8B 45 08 48 74 14 83 E8 03 74 0F 8B 4E 4C FF 76 74 8B 01 FF 50 14 B0 01 EB 48 6A 01 8B CF E8 ?? ?? ?? ?? 84 C0 75 22 83 7D 10 00 74 0C 6A 01 FF 75 10 8B CF E8 ?? ?? ?? ?? 6A 00 FF 75 08 8B CE E8 ?? ?? ?? ?? 32 C0 EB 19 8B 45 0C 85 C0 75 07 8B CF E8 ?? ?? ?? ?? FF 75 10 8B 16 50 8B CE FF 52 1C 5F 5E 5D C2 0C 00 }
	condition:
		$1
}

rule file_92_47_0 {
	meta:
		name = "?ExerciseWakesExisting@ClaimTicket@VirtualProcessor@details@Concurrency@@QBE_NXZ"
		size = 17
	strings:
		$1 = { 83 39 02 74 08 83 39 08 74 03 33 C0 C3 33 C0 40 C3 }
	condition:
		$1
}

rule file_92_48_0 {
	meta:
		name = "?ExerciseWith@ClaimTicket@VirtualProcessor@details@Concurrency@@QAE_NPAVInternalContextBase@34@@Z"
		size = 43
		refs = "001f ?ExerciseClaim@VirtualProcessor@details@Concurrency@@AAE_NW4AvailabilityType@123@PAVScheduleGroupSegmentBase@23@PAVInternalContextBase@23@@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 32 C0 83 3E 00 74 19 8B 4E 04 FF 75 08 8B 41 44 8B 40 04 FF 70 08 FF 36 E8 ?? ?? ?? ?? 83 26 00 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_92_49_0 {
	meta:
		name = "?Expire@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAEXXZ"
		size = 17
		refs = "0004 ?StaticDelete@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@SAXPAU1234@@Z 000c ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QAEXP6AXPAX@Z0PAVSchedulerBase@23@@Z"
	strings:
		$1 = { FF 31 51 68 ?? ?? ?? ?? 83 C1 1C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_185_48_0 {
	meta:
		name = "?Expire@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAEXXZ"
		size = 17
		refs = "0004 ?StaticDelete@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@SAXPAU1234@@Z 000c ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QAEXP6AXPAX@Z0PAVSchedulerBase@23@@Z"
	strings:
		$1 = { FF 31 51 68 ?? ?? ?? ?? 83 C1 1C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_92_50_0 {
	meta:
		name = "?Find@?$Hash@II@details@Concurrency@@QAEPAUListNode@123@ABIPAI@Z"
		size = 54
		refs = "000c ?HashValue@?$Hash@II@details@Concurrency@@CAIABIH@Z 0019 ?Lookup@?$Hash@II@details@Concurrency@@AAEPAUListNode@123@ABIH@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 FF 36 FF 75 08 E8 ?? ?? ?? ?? 59 59 50 FF 75 08 8B CE E8 ?? ?? ?? ?? 5E 85 C0 74 0E 8B 55 0C 85 D2 74 09 8B 48 08 89 0A EB 02 33 C0 5D C2 08 00 }
	condition:
		$1
}

rule file_1116_71_0 {
	meta:
		name = "?Find@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEPAUListNode@123@ABQAV_TaskCollection@23@PAPAV523@@Z"
		size = 54
		refs = "000c ?HashValue@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@CAIABQAV_TaskCollection@23@H@Z 0019 ?Lookup@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@AAEPAUListNode@123@ABQAV_TaskCollection@23@H@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 FF 36 FF 75 08 E8 ?? ?? ?? ?? 59 59 50 FF 75 08 8B CE E8 ?? ?? ?? ?? 5E 85 C0 74 0E 8B 55 0C 85 D2 74 09 8B 48 08 89 0A EB 02 33 C0 5D C2 08 00 }
	condition:
		$1
}

rule file_92_53_0 {
	meta:
		name = "?GetCurrentSubAllocator@VirtualProcessor@details@Concurrency@@QAEPAVSubAllocator@23@XZ"
		size = 25
		refs = "000c ?GetSubAllocator@SchedulerBase@details@Concurrency@@SAPAVSubAllocator@23@_N@Z"
	strings:
		$1 = { 56 8B F1 83 7E 50 00 75 0B 6A 00 E8 ?? ?? ?? ?? 59 89 46 50 8B 46 50 5E C3 }
	condition:
		$1
}

rule file_92_57_0 {
	meta:
		name = "?GetLocalRunnableContext@VirtualProcessor@details@Concurrency@@AAEPAVInternalContextBase@23@XZ"
		size = 19
		refs = "000c ?Pop@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@XZ"
	strings:
		$1 = { 8B 41 10 83 C1 0C 2B 01 85 C0 0F 8F ?? ?? ?? ?? 33 C0 C3 }
	condition:
		$1
}

rule file_92_60_0 {
	meta:
		name = "?GetResourceMaskId@SchedulerBase@details@Concurrency@@QAEII@Z"
		size = 30
		refs = "0013 ?Find@?$Hash@II@details@Concurrency@@QAEPAUListNode@123@ABIPAI@Z"
	strings:
		$1 = { 55 8B EC 51 8D 45 FC 50 8D 45 08 50 81 C1 68 01 00 00 E8 ?? ?? ?? ?? 8B 45 FC C9 C2 04 00 }
	condition:
		$1
}

rule file_92_65_0 {
	meta:
		name = "?Grow@QuickBitSet@details@Concurrency@@QAEXI@Z"
		size = 127
		refs = "0028 ??_U@YAPAXI@Z 0061 _memset 0069 ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 53 8B 5D 08 56 8B F1 3B 1E 74 6A 57 8D 7B 1F C1 EF 05 33 C9 6A 04 5A 8B C7 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 59 8B 0E 83 C1 1F C1 E9 05 33 D2 89 45 FC 85 C9 74 16 8B D8 8B 46 04 8B 04 90 89 04 93 42 3B D1 72 F2 8B 5D 08 8B 45 FC 2B F9 C1 E7 02 57 8D 04 88 6A 00 50 E8 ?? ?? ?? ?? FF 76 04 E8 ?? ?? ?? ?? 8B 45 FC 83 C4 10 89 46 04 89 1E 5F 5E 5B C9 C2 04 00 }
	condition:
		$1
}

rule file_92_66_0 {
	meta:
		name = "?HashValue@?$Hash@II@details@Concurrency@@CAIABIH@Z"
		size = 44
		altNames = "?HashValue@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@CAIABQAV_TaskCollection@23@H@Z"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 BA C5 9D 1C 81 33 C9 0F B6 04 31 33 D0 69 D2 93 01 00 01 41 83 F9 04 72 EE 8B C2 33 D2 F7 75 0C 5E 8B C2 5D C3 }
	condition:
		$1
}

rule file_92_68_0 {
	meta:
		name = "?Initialize@VirtualProcessor@details@Concurrency@@MAEXPAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z"
		size = 317
		refs = "0089 ?GetResourceMaskId@SchedulerBase@details@Concurrency@@QAEII@Z 009a ?GetProcessorCount@Concurrency@@YAIXZ 00a2 ?Grow@QuickBitSet@details@Concurrency@@QAEXI@Z 00a9 ?Wipe@QuickBitSet@details@Concurrency@@QAEXXZ 00da ?Reset@WorkSearchContext@details@Concurrency@@QAEXPAVVirtualProcessor@23@W4Algorithm@123@@Z 00f6 ??0location@Concurrency@@QAE@W4_Type@01@IIPAX@Z 0102 ?_Assign@location@Concurrency@@QAEXABV12@@Z 0111 ?InterlockedSet@ReferenceCountedQuickBitSet@details@Concurrency@@QAEII@Z 0119 ?ClearQuickCacheSlot@SchedulerBase@details@Concurrency@@QAEXI@Z 0132 ?TraceVirtualProcessorEvent@VirtualProcessor@details@Concurrency@@AAEXW4ConcRT_EventType@3@EKK@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 8B 45 08 53 8B D9 33 C9 89 8B B8 00 00 00 89 4B 6C 89 43 44 33 D2 42 89 93 CC 00 00 00 89 93 C0 00 00 00 8B 40 04 89 43 48 8B 43 44 56 8B 75 0C 66 89 8B A0 00 00 00 89 73 4C 89 4B 04 89 4B 5C 89 4B 60 89 4B 64 89 4B 68 89 4B 70 89 8B A4 00 00 00 89 8B B4 00 00 00 89 4B 50 66 89 4B 54 88 53 56 57 8B 38 8B 06 8B CE 89 7D 08 FF 50 10 89 43 7C 8B 06 8B CE FF 50 04 50 8B CF 89 83 80 00 00 00 E8 ?? ?? ?? ?? 89 83 84 00 00 00 8D BB 98 00 00 00 E8 ?? ?? ?? ?? 50 8B CF E8 ?? ?? ?? ?? 8B CF E8 ?? ?? ?? ?? 8B 8B 84 00 00 00 8B 57 04 8B 7D 08 33 C0 8B F1 83 E1 1F 40 D3 E0 C1 EE 05 8D 4B 24 09 04 B2 83 7F 0C 00 75 04 6A 01 EB 02 6A 02 53 E8 ?? ?? ?? ?? 8B 43 44 53 8B 08 8B 01 FF 50 04 50 FF B3 80 00 00 00 8D 4D F0 6A 03 E8 ?? ?? ?? ?? 50 8D 8B 88 00 00 00 E8 ?? ?? ?? ?? 8B B3 84 00 00 00 56 8D 4F 48 E8 ?? ?? ?? ?? 56 8B CF E8 ?? ?? ?? ?? 8B 43 44 FF 73 7C 8B 08 8B 01 FF 50 04 50 6A 04 6A 01 8B CB E8 ?? ?? ?? ?? 5F 5E 5B C9 C2 08 00 }
	condition:
		$1
}

rule file_92_69_0 {
	meta:
		name = "?InitializeTicket@ClaimTicket@VirtualProcessor@details@Concurrency@@AAEXW4AvailabilityType@234@PAV234@@Z"
		size = 18
	strings:
		$1 = { 55 8B EC 8B 45 08 89 01 8B 45 0C 89 41 04 5D C2 08 00 }
	condition:
		$1
}

rule file_92_70_0 {
	meta:
		name = "?InterlockedClear@QuickBitSet@details@Concurrency@@QAEXI@Z"
		size = 36
	strings:
		$1 = { 55 8B EC 8B 41 04 8B 55 08 56 33 F6 8B CA 46 83 E1 1F D3 E6 C1 EA 05 8D 04 90 F7 D6 F0 21 30 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_92_71_0 {
	meta:
		name = "?InterlockedClear@ReferenceCountedQuickBitSet@details@Concurrency@@QAEII@Z"
		size = 66
		refs = "001d ?SpinUntilSet@QuickBitSet@details@Concurrency@@QBEXI@Z"
	strings:
		$1 = { 55 8B EC 53 56 8B D9 57 8B 43 08 8B 7D 08 83 CE FF 8D 04 B8 F0 0F C1 30 4E 75 1E 57 E8 ?? ?? ?? ?? 33 D2 8B CF 83 E1 1F 42 D3 E2 8B 4B 04 C1 EF 05 F7 D2 8D 0C B9 F0 21 11 5F 8B C6 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_92_72_0 {
	meta:
		name = "?InterlockedSet@QuickBitSet@details@Concurrency@@QAEXI@Z"
		size = 34
	strings:
		$1 = { 55 8B EC 8B 41 04 8B 55 08 56 8B CA 33 F6 C1 EA 05 83 E1 1F 46 D3 E6 8D 04 90 F0 09 30 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_92_73_0 {
	meta:
		name = "?InterlockedSet@ReferenceCountedQuickBitSet@details@Concurrency@@QAEII@Z"
		size = 70
		refs = "0023 ?SpinUntilClear@QuickBitSet@details@Concurrency@@QBEXI@Z"
	strings:
		$1 = { 55 8B EC 51 8B 41 08 53 8B 5D 08 56 57 33 FF 47 89 4D FC 8D 04 98 8B F7 F0 0F C1 30 46 3B F7 75 1C 53 E8 ?? ?? ?? ?? 8B CB 83 E1 1F D3 E7 8B 4D FC C1 EB 05 8B 49 04 8D 0C 99 F0 09 39 5F 8B C6 5E 5B C9 C2 04 00 }
	condition:
		$1
}

rule file_92_75_0 {
	meta:
		name = "?IsSet@QuickBitSet@details@Concurrency@@QBE_NI@Z"
		size = 43
	strings:
		$1 = { 55 8B EC 8B 41 04 56 8B 75 08 57 8B FE 83 E6 1F 33 D2 42 C1 EF 05 8B CE 8B 04 B8 D3 E2 5F 5E 23 C2 F7 D8 1B C0 F7 D8 5D C2 04 00 }
	condition:
		$1
}

rule file_92_76_0 {
	meta:
		name = "?ListenAffinity@SchedulerBase@details@Concurrency@@QAEXI@Z"
		size = 32
		refs = "000d ?InterlockedSet@ReferenceCountedQuickBitSet@details@Concurrency@@QAEII@Z 0017 ?ClearQuickCacheSlot@SchedulerBase@details@Concurrency@@QAEXI@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 8D 4E 48 E8 ?? ?? ?? ?? FF 75 08 8B CE E8 ?? ?? ?? ?? 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_92_77_0 {
	meta:
		name = "?Lookup@?$Hash@II@details@Concurrency@@AAEPAUListNode@123@ABIH@Z"
		size = 42
		altNames = "?Lookup@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@AAEPAUListNode@123@ABQAV_TaskCollection@23@H@Z"
	strings:
		$1 = { 55 8B EC 8B 49 08 8B 45 0C 8B 0C 81 85 C9 74 10 8B 45 08 8B 00 39 41 04 74 0C 8B 09 85 C9 75 F5 33 C0 5D C2 08 00 8B C1 EB F8 }
	condition:
		$1
}

rule file_92_78_0 {
	meta:
		name = "?MakeAvailable@VirtualProcessor@details@Concurrency@@IAEXW4AvailabilityType@123@_N@Z"
		size = 126
		refs = "002b ?VirtualProcessorActive@SchedulerBase@details@Concurrency@@QAE_N_N@Z"
	strings:
		$1 = { 55 8B EC 53 56 8B 75 08 57 8B F9 33 DB 8B 47 70 43 80 7D 0C 00 89 47 74 74 15 3B F3 74 05 83 FE 04 75 0C 8B 4F 44 6A 00 8B 09 E8 ?? ?? ?? ?? 8B 47 44 8B 08 81 C1 AC 01 00 00 8B C3 F0 0F C1 01 8B 4F 44 83 C1 1C 8B C3 F0 0F C1 01 83 FE 04 74 05 83 FE 08 75 1C 8B 47 44 8B 08 81 C1 B0 01 00 00 8B C3 F0 0F C1 01 8B 47 44 83 C0 20 F0 0F C1 18 43 8D 47 04 87 30 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule file_92_79_0 {
	meta:
		name = "?MarkForRetirement@VirtualProcessor@details@Concurrency@@AAEXXZ"
		size = 84
		refs = "0015 ?ClaimExclusiveOwnership@VirtualProcessor@details@Concurrency@@QAE_NAAVClaimTicket@123@K_N@Z 0044 ?ExerciseClaim@VirtualProcessor@details@Concurrency@@AAE_NW4AvailabilityType@123@PAVScheduleGroupSegmentBase@23@PAVInternalContextBase@23@@Z"
	strings:
		$1 = { 55 8B EC 51 51 83 65 F8 00 56 6A 01 6A 0F 8D 45 F8 50 8B F1 E8 ?? ?? ?? ?? 84 C0 74 2D 83 7D F8 02 74 0F 83 7D F8 08 74 09 8B 06 8B CE FF 50 0C EB 1F 8B 4D FC 6A 00 6A 00 FF 75 F8 C6 86 A1 00 00 00 01 E8 ?? ?? ?? ?? EB 07 C6 86 A1 00 00 00 01 5E C9 C3 }
	condition:
		$1
}

rule file_92_80_0 {
	meta:
		name = "?Oversubscribe@VirtualProcessor@details@Concurrency@@EAEPAV123@XZ"
		size = 35
		refs = "001d ?AddVirtualProcessor@SchedulingNode@details@Concurrency@@QAEPAVVirtualProcessor@23@PAUIVirtualProcessorRoot@3@_N@Z"
	strings:
		$1 = { 56 8B F1 8B 46 44 FF 76 4C 8B 00 8B 88 A4 01 00 00 8B 01 FF 50 14 8B 4E 44 6A 01 50 E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_92_81_0 {
	meta:
		name = "?Pop@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@XZ"
		size = 78
		refs = "003b ?Claim@Slot@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAE_NPAPAVInternalContextBase@34@@Z"
	strings:
		$1 = { 53 56 8B F1 57 8B 7E 04 8B 56 08 8B 46 0C 4F 23 D7 89 7E 04 33 DB 8D 04 90 87 18 85 DB 75 06 8D 47 01 89 46 04 F6 C3 01 74 1E 8B 4E 08 8B 46 10 23 CF 6A 00 8D 0C C8 83 E3 FE E8 ?? ?? ?? ?? 84 C0 75 05 33 C0 40 EB 02 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule file_553_149_0 {
	meta:
		name = "?Pop@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEPAV_UnrealizedChore@23@XZ"
		size = 78
		refs = "003b ?Claim@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE_NPAPAV_UnrealizedChore@34@@Z"
	strings:
		$1 = { 53 56 8B F1 57 8B 7E 04 8B 56 08 8B 46 0C 4F 23 D7 89 7E 04 33 DB 8D 04 90 87 18 85 DB 75 06 8D 47 01 89 46 04 F6 C3 01 74 1E 8B 4E 08 8B 46 10 23 CF 6A 00 8D 0C C8 83 E3 FE E8 ?? ?? ?? ?? 84 C0 75 05 33 C0 40 EB 02 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule file_92_83_0 {
	meta:
		name = "?Remove@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAE_NPAVVirtualProcessor@23@H_N@Z"
		size = 251
		refs = "0077 __imp__QueryDepthSList@4 0095 __imp__InterlockedPushEntrySList@8 00a8 ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 00c3 __imp__InterlockedFlushSList@4 00cf ?CheckForDeletionBridge@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@CAXPAV123@@Z 00d7 ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QAEXP6AXPAX@Z0PAVSchedulerBase@23@@Z"
	strings:
		$1 = { 55 8B EC 51 8B 55 0C 53 56 8B F1 8B 4E 2C 8B 5E 28 D3 FA 4B 23 5D 0C 3B 56 3C 7C 07 32 C0 E9 D2 00 00 00 8B 4E 38 8B 46 34 57 3B D1 7C 11 2B D1 8B 7C 88 FC 78 0C 42 8B 7F 04 4A 75 FA EB 03 8B 3C 90 8B 07 8B 4D 08 89 4D 0C 8D 0C 98 8B 45 0C 33 D2 F0 0F B1 11 89 45 FC 8B 45 FC 3B 45 0C 0F 85 8D 00 00 00 6A FE 8D 4F 08 58 F0 0F B1 19 80 7D 10 00 74 79 8B 3D ?? ?? ?? ?? 56 FF D7 0F B7 C0 3B 46 44 7E 57 8B 45 08 05 B0 00 00 00 50 8D 5E 08 53 FF 15 ?? ?? ?? ?? 53 FF D7 0F B7 C0 3B 46 44 7E 4A 8B 4E 24 E8 ?? ?? ?? ?? 84 C0 75 3E 33 D2 42 8D 4E 48 33 C0 F0 0F B1 11 85 C0 75 2E 53 FF 15 ?? ?? ?? ?? FF 76 24 8D 4E 14 56 68 ?? ?? ?? ?? 89 46 10 E8 ?? ?? ?? ?? EB 11 8B 4D 08 81 C1 B0 00 00 00 51 56 FF 15 ?? ?? ?? ?? B0 01 EB 02 32 C0 5F 5E 5B C9 C2 0C 00 }
	condition:
		$1
}

rule file_92_84_0 {
	meta:
		name = "?Remove@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAE_NPAVVirtualProcessor@23@_N@Z"
		size = 22
		refs = "000e ?Remove@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAE_NPAVVirtualProcessor@23@H_N@Z"
	strings:
		$1 = { 55 8B EC FF 75 0C 8B 45 08 FF 70 58 50 E8 ?? ?? ?? ?? 5D C2 08 00 }
	condition:
		$1
}

rule file_92_86_0 {
	meta:
		name = "?Retire@VirtualProcessor@details@Concurrency@@MAEXXZ"
		size = 323
		refs = "001a ?RemovePrioritizedObject@SchedulerBase@details@Concurrency@@QAEXPAUBoostedObject@23@@Z 002d ?InterlockedClear@ReferenceCountedQuickBitSet@details@Concurrency@@QAEII@Z 005d ?SaveRetiredVirtualProcessorStatistics@SchedulerBase@details@Concurrency@@QAEXPAVVirtualProcessor@23@@Z 0095 ?Pop@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@XZ 00aa ?GetScheduleGroupSegment@ContextBase@details@Concurrency@@QBEPAVScheduleGroupSegmentBase@23@XZ 00bc ?_Assign@location@Concurrency@@QAEXABV12@@Z 00c4 ?AddRunnableContext@ScheduleGroupSegmentBase@details@Concurrency@@IAEXPAVInternalContextBase@23@Vlocation@3@@Z 0116 ?TraceVirtualProcessorEvent@VirtualProcessor@details@Concurrency@@AAEXW4ConcRT_EventType@3@EKK@Z 0124 ?ReturnSubAllocator@SchedulerBase@details@Concurrency@@SAXPAVSubAllocator@23@@Z 013a ?Remove@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAE_NPAVVirtualProcessor@23@H_N@Z"
	strings:
		$1 = { 55 8B EC 51 51 53 56 57 8B F9 89 7D F8 8B 4F 44 8D 87 C0 00 00 00 8B 09 50 E8 ?? ?? ?? ?? 8B 47 44 FF B7 84 00 00 00 8B 08 83 C1 30 E8 ?? ?? ?? ?? 8B 4F 44 83 CA FF 83 C1 24 8B C2 F0 0F C1 01 80 BF A0 00 00 00 00 75 0D 8B 47 44 8B 00 83 C0 14 F0 0F C1 10 4A 8B 4F 44 57 8B 09 E8 ?? ?? ?? ?? 80 7F 54 00 75 13 8B 47 44 FF B7 84 00 00 00 8B 08 83 C1 48 E8 ?? ?? ?? ?? 8D 57 0C C7 47 70 00 00 00 00 8B 02 8B 4A 04 2B C8 89 55 FC 85 C9 7E 0B 8B CA E8 ?? ?? ?? ?? 8B D8 EB 02 33 DB 85 DB 74 44 8B 7D FC 8D 4B 04 E8 ?? ?? ?? ?? 8B F0 83 EC 10 8B D4 8D 4E 0C 51 8B CA E8 ?? ?? ?? ?? 53 8B CE E8 ?? ?? ?? ?? 8B 07 8B 4F 04 2B C8 85 C9 7E 0B 8B CF E8 ?? ?? ?? ?? 8B D8 EB 02 33 DB 85 DB 75 C2 8B 7D F8 8B 47 44 8B 08 8B 47 4C 8B 30 8B 01 FF 50 34 8B 4F 4C 50 FF 56 08 8B 47 44 83 67 4C 00 8B 08 FF 77 7C 8B 01 FF 50 04 50 6A 04 6A 02 8B CF E8 ?? ?? ?? ?? 83 7F 50 00 74 0D FF 77 50 E8 ?? ?? ?? ?? 83 67 50 00 59 8B 4F 44 6A 01 FF 77 58 83 C1 38 57 E8 ?? ?? ?? ?? 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_92_87_0 {
	meta:
		name = "?SafePoint@VirtualProcessor@details@Concurrency@@QAE_NXZ"
		size = 20
		refs = "000f ?MarkSafePoint@SchedulerBase@details@Concurrency@@QAE_NPAVSafePointMarker@23@@Z"
	strings:
		$1 = { 8B D1 8B 42 44 8B 08 8D 82 B4 00 00 00 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_92_88_0 {
	meta:
		name = "?SaveRetiredVirtualProcessorStatistics@SchedulerBase@details@Concurrency@@QAEXPAVVirtualProcessor@23@@Z"
		size = 58
	strings:
		$1 = { 55 8B EC 56 8B 75 08 57 8B 46 5C 8B D0 2B 56 64 8B F9 89 46 64 8D 87 B4 01 00 00 F0 0F C1 10 8B 46 60 8B C8 2B 4E 68 89 46 68 8D 87 B8 01 00 00 F0 0F C1 08 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_92_89_0 {
	meta:
		name = "?Set@QuickBitSet@details@Concurrency@@QAEXI@Z"
		size = 35
	strings:
		$1 = { 55 8B EC 8B 51 04 56 8B 75 08 57 8B FE 83 E6 1F 33 C0 40 8B CE D3 E0 C1 EF 05 09 04 BA 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_92_90_0 {
	meta:
		name = "?SpinUntilClear@QuickBitSet@details@Concurrency@@QBEXI@Z"
		size = 72
		refs = "002c ?_Sleep0@details@Concurrency@@YAXXZ 0036 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 EC 10 53 8B 59 04 56 57 8B F0 83 E0 1F 33 FF 47 8B C8 C1 EE 05 D3 E7 8B 04 B3 85 C7 74 1C 83 65 F8 00 C7 45 FC ?? ?? ?? ?? EB 08 8D 4D F0 E8 ?? ?? ?? ?? 8B 04 B3 85 C7 75 F1 5F 5E 5B C9 C2 04 00 }
	condition:
		$1
}

rule file_92_91_0 {
	meta:
		name = "?SpinUntilSet@QuickBitSet@details@Concurrency@@QBEXI@Z"
		size = 72
		refs = "002c ?_Sleep0@details@Concurrency@@YAXXZ 0036 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 EC 10 53 8B 59 04 56 57 8B F0 83 E0 1F 33 FF 47 8B C8 C1 EE 05 D3 E7 8B 04 B3 85 C7 75 1C 83 65 F8 00 C7 45 FC ?? ?? ?? ?? EB 08 8D 4D F0 E8 ?? ?? ?? ?? 8B 04 B3 85 C7 74 F1 5F 5E 5B C9 C2 04 00 }
	condition:
		$1
}

rule file_92_92_0 {
	meta:
		name = "?StartupWorkerContext@VirtualProcessor@details@Concurrency@@EAE_NPAVScheduleGroupSegmentBase@23@PAVInternalContextBase@23@@Z"
		size = 137
		refs = "0018 ?_Sleep0@details@Concurrency@@YAXXZ 0020 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ 003d ?PrepareForUse@InternalContextBase@details@Concurrency@@QAEXPAVScheduleGroupSegmentBase@23@PAU_Chore@23@_N@Z 0049 ?GetInternalContext@ScheduleGroupSegmentBase@details@Concurrency@@IAEPAVInternalContextBase@23@PAU_Chore@23@_N@Z 005a ?MakeAvailable@VirtualProcessor@details@Concurrency@@IAEXW4AvailabilityType@123@_N@Z 0064 ?DeferredGetInternalContext@SchedulerBase@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 8B F1 33 DB 57 39 5E 70 74 17 89 5D F8 C7 45 FC ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 39 5E 70 75 F3 8B 7D 0C 85 FF 74 13 39 5F 1C 75 1A 53 53 FF 75 08 8B CF E8 ?? ?? ?? ?? EB 0C 8B 4D 08 53 53 E8 ?? ?? ?? ?? 8B F8 8B CE 85 FF 75 17 6A 01 6A 04 E8 ?? ?? ?? ?? 8B 4E 44 8B 09 E8 ?? ?? ?? ?? 32 C0 EB 16 8B 06 57 FF 50 10 8B 46 4C FF 76 70 8B 00 8B 4E 4C FF 50 14 B0 01 5F 5E 5B C9 C2 08 00 }
	condition:
		$1
}

rule file_92_93_0 {
	meta:
		name = "?StaticDelete@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@SAXPAU1234@@Z"
		size = 25
		refs = "000d ??1Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 74 0E 8B 4D 08 E8 ?? ?? ?? ?? 5D E9 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_185_127_0 {
	meta:
		name = "?StaticDelete@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@SAXPAU1234@@Z"
		size = 25
		refs = "000d ??1Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@XZ 0013 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 74 0E 8B 4D 08 E8 ?? ?? ?? ?? 5D E9 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_92_94_0 {
	meta:
		name = "?ThrowVirtualProcessorEvent@VirtualProcessor@details@Concurrency@@CAXW4ConcRT_EventType@3@EKK@Z"
		size = 113
		refs = "0009 ?g_pEtw@details@Concurrency@@3PAVEtw@12@A 001c _memset 0041 _VirtualProcessorEventGuid 005b ?g_ConcRTSessionHandle@details@Concurrency@@3_KA 0068 ?Trace@Etw@details@Concurrency@@QAEK_KPAU_EVENT_TRACE_HEADER@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 40 53 8B 1D ?? ?? ?? ?? 85 DB 74 5D 56 57 6A 3E 8D 45 C2 6A 00 50 E8 ?? ?? ?? ?? 83 C4 0C C7 45 EC 00 00 02 00 6A 40 58 66 89 45 C0 8A 45 08 88 45 C4 8A 45 0C 88 45 C5 8B 45 10 BE ?? ?? ?? ?? 8D 7D D8 A5 A5 A5 A5 89 45 F4 8B 45 14 89 45 F0 8D 45 C0 50 FF 35 ?? ?? ?? ?? 8B CB FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_92_96_0 {
	meta:
		name = "?TraceVirtualProcessorEvent@VirtualProcessor@details@Concurrency@@AAEXW4ConcRT_EventType@3@EKK@Z"
		size = 45
		refs = "0008 ?g_TraceInfo@details@Concurrency@@3U_CONCRT_TRACE_INFO@12@A 0022 ?ThrowVirtualProcessorEvent@VirtualProcessor@details@Concurrency@@CAXW4ConcRT_EventType@3@EKK@Z"
	strings:
		$1 = { 55 8B EC 8B 4D 0C 3A 0D ?? ?? ?? ?? 77 1B A1 ?? ?? ?? ?? A8 04 74 12 FF 75 14 FF 75 10 51 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C2 10 00 }
	condition:
		$1
}

rule file_92_97_0 {
	meta:
		name = "?UpdateWorkState@VirtualProcessor@details@Concurrency@@QAEX_N0@Z"
		size = 94
		refs = "002d ?InterlockedSet@ReferenceCountedQuickBitSet@details@Concurrency@@QAEII@Z 0036 ?ClearQuickCacheSlot@SchedulerBase@details@Concurrency@@QAEXI@Z 004b ?InterlockedClear@ReferenceCountedQuickBitSet@details@Concurrency@@QAEII@Z"
	strings:
		$1 = { 55 8B EC 51 53 8A 5D 08 57 8B F9 80 7F 54 00 8B 47 44 8B 00 89 45 FC 74 24 84 DB 75 32 56 8B B7 84 00 00 00 56 8D 48 48 C6 47 56 01 E8 ?? ?? ?? ?? 8B 4D FC 56 E8 ?? ?? ?? ?? 5E EB 12 84 DB 74 0E FF B7 84 00 00 00 8D 48 48 E8 ?? ?? ?? ?? 8A 45 0C 88 5F 54 88 47 55 5F 5B C9 C2 08 00 }
	condition:
		$1
}

rule file_92_98_0 {
	meta:
		name = "?Wipe@QuickBitSet@details@Concurrency@@QAEXXZ"
		size = 29
	strings:
		$1 = { 8B 11 83 C2 1F 56 C1 EA 05 33 F6 85 D2 74 0C 8B 41 04 83 24 B0 00 46 3B F2 72 F4 5E C3 }
	condition:
		$1
}

rule file_92_99_0 {
	meta:
		name = "?_Assign@location@Concurrency@@QAEXABV12@@Z"
		size = 53
	strings:
		$1 = { 55 8B EC 8B 55 08 56 8B 02 33 01 BE FF FF FF 0F 23 C6 31 01 8B 02 33 01 23 C6 33 02 5E 89 01 8B 42 08 89 41 08 8B 42 04 89 41 04 8B 42 0C 89 41 0C 5D C2 04 00 }
	condition:
		$1
}

rule file_92_101_0 {
	meta:
		name = "?_IsEnabled@_CONCRT_TRACE_INFO@details@Concurrency@@QBE_NEK@Z"
		size = 32
	strings:
		$1 = { 55 8B EC 8A 45 08 3A 41 04 77 0F 8B 01 23 45 0C 3B 45 0C 75 05 33 C0 40 EB 02 33 C0 5D C2 08 00 }
	condition:
		$1
}

rule file_93_0_0 {
	meta:
		name = "__dupenv_s"
		size = 212
		refs = "0003 __sehtable$__dupenv_s 0008 __SEH_prolog4 000f __lock 0028 __errno 0032 __invalid_parameter_noinfo 0053 __getenv_helper_nolock 0061 _strlen 006c _calloc 0096 _strcpy_s 00b9 __SEH_epilog4 00c4 __invoke_watson 00ce __unlock"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 07 E8 ?? ?? ?? ?? 59 33 F6 89 75 FC 33 C0 8B 4D 08 85 C9 0F 95 C0 85 C0 75 11 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? EB 6F 89 31 8B 7D 0C 85 FF 74 02 89 37 33 C0 39 45 10 0F 95 C0 85 C0 74 D8 FF 75 10 E8 ?? ?? ?? ?? 59 89 45 E0 85 C0 74 48 50 E8 ?? ?? ?? ?? 8D 58 01 6A 01 53 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 08 89 01 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 30 EB 17 FF 75 E0 53 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 1D 85 FF 74 02 89 1F 89 75 E4 C7 45 FC FE FF FF FF E8 15 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 56 56 56 56 56 E8 ?? ?? ?? ?? 8B 75 E4 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_93_1_0 {
	meta:
		name = "__dupenv_s_helper"
		size = 156
		refs = "000d __errno 0017 __invalid_parameter_noinfo 0036 __getenv_helper_nolock 0045 _strlen 0050 _calloc 007a _strcpy_s 0097 __invoke_watson"
	strings:
		$1 = { 55 8B EC 56 57 8B 7D 08 85 FF 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 51 8B 75 0C 83 27 00 85 F6 74 03 83 26 00 83 7D 10 00 74 DA FF 75 10 E8 ?? ?? ?? ?? 59 89 45 08 85 C0 74 2E 53 50 E8 ?? ?? ?? ?? 8D 58 01 6A 01 53 E8 ?? ?? ?? ?? 83 C4 0C 89 07 85 C0 75 17 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 5B 5F 5E 5D C3 FF 75 08 53 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 0A 85 F6 74 02 89 1E 33 C0 EB E0 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_93_2_0 {
	meta:
		name = "__getenv_helper_nolock"
		size = 132
		refs = "0005 ___env_initialized 000d __environ 001e __wenviron 0025 ___wtomb_environ 0041 _strlen 0063 __mbsnbicoll"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 56 8B 35 ?? ?? ?? ?? 75 04 33 C0 EB 63 57 85 F6 75 1B 39 35 ?? ?? ?? ?? 74 53 E8 ?? ?? ?? ?? 85 C0 75 4A 8B 35 ?? ?? ?? ?? 85 F6 74 40 83 7D 08 00 74 3A FF 75 08 E8 ?? ?? ?? ?? 59 8B F8 EB 27 51 E8 ?? ?? ?? ?? 59 3B C7 76 19 8B 06 80 3C 38 3D 75 11 57 FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0F 83 C6 04 8B 0E 85 C9 75 D3 33 C0 5F 5E 5D C3 8B 06 40 03 C7 EB F5 }
	condition:
		$1
}

rule file_93_3_0 {
	meta:
		name = "__getenv_s_helper"
		size = 155
		refs = "000d __errno 0017 __invalid_parameter_noinfo 003c __getenv_helper_nolock 004a _strlen 007f _strcpy_s 0096 __invoke_watson"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 56 85 DB 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 3F 83 23 00 8B 75 10 57 8B 7D 0C 85 FF 74 35 85 F6 74 35 85 FF 74 03 C6 07 00 FF 75 14 E8 ?? ?? ?? ?? 59 89 45 08 85 C0 74 42 50 E8 ?? ?? ?? ?? 40 59 89 03 85 F6 74 34 3B C6 76 1F 6A 22 58 5F 5E 5B 5D C3 85 F6 74 CB E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB E4 FF 75 08 56 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 04 33 C0 EB CF 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_93_5_0 {
	meta:
		name = "_getenv"
		size = 124
		refs = "0003 __sehtable$_getenv 0008 __SEH_prolog4 001b __errno 0026 __invalid_parameter_noinfo 0036 _strnlen 0047 __lock 0052 __getenv_helper_nolock 006b __SEH_epilog4 0076 __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 75 08 85 F6 0F 95 C0 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 3C BF FF 7F 00 00 57 56 E8 ?? ?? ?? ?? 59 59 3B C7 1B C0 F7 D8 74 D6 6A 07 E8 ?? ?? ?? ?? 59 83 65 FC 00 56 E8 ?? ?? ?? ?? 59 8B F0 89 75 E4 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 75 E4 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_994_3_0 {
	meta:
		name = "__wgetenv"
		size = 124
		refs = "0003 __sehtable$__wgetenv 0008 __SEH_prolog4 001b __errno 0026 __invalid_parameter_noinfo 0036 _wcsnlen 0047 __lock 0052 __wgetenv_helper_nolock 006b __SEH_epilog4 0076 __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 75 08 85 F6 0F 95 C0 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 3C BF FF 7F 00 00 57 56 E8 ?? ?? ?? ?? 59 59 3B C7 1B C0 F7 D8 74 D6 6A 07 E8 ?? ?? ?? ?? 59 83 65 FC 00 56 E8 ?? ?? ?? ?? 59 8B F0 89 75 E4 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 75 E4 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_93_6_0 {
	meta:
		name = "_getenv_s"
		size = 206
		refs = "0003 __sehtable$_getenv_s 0008 __SEH_prolog4 000f __lock 0028 __errno 0032 __invalid_parameter_noinfo 0066 __getenv_helper_nolock 0073 _strlen 0096 _strcpy_s 00b3 __SEH_epilog4 00be __invoke_watson 00c8 __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 07 E8 ?? ?? ?? ?? 59 33 DB 89 5D FC 33 C0 8B 4D 08 85 C9 0F 95 C0 85 C0 75 11 E8 ?? ?? ?? ?? 6A 16 5B 89 18 E8 ?? ?? ?? ?? EB 69 89 19 8B 75 0C 85 F6 74 0A 83 7D 10 00 77 0A 85 F6 75 0B 83 7D 10 00 75 05 33 C0 40 EB 02 8B C3 85 C0 74 CB 85 F6 74 02 88 1E FF 75 14 E8 ?? ?? ?? ?? 59 8B F8 85 FF 74 30 57 E8 ?? ?? ?? ?? 59 8D 48 01 8B 45 08 89 08 83 7D 10 00 74 1B 3B 4D 10 76 05 6A 22 5B EB 11 57 FF 75 10 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 17 89 5D E4 C7 45 FC FE FF FF FF E8 15 00 00 00 8B C3 E8 ?? ?? ?? ?? C3 53 53 53 53 53 E8 ?? ?? ?? ?? 8B 5D E4 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_94_0_0 {
	meta:
		name = "__fputchar"
		size = 24
		refs = "0004 ___iob_func 0010 _putc"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 83 C0 20 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_1062_0_0 {
	meta:
		name = "__fputwchar"
		size = 24
		refs = "0004 ___iob_func 0010 _fputwc"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 83 C0 20 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_95_0_0 {
	meta:
		name = "__write"
		size = 239
		refs = "0003 __sehtable$__write 0008 __SEH_prolog4 0015 ___doserrno 001d __errno 002d __ioinit 0043 __nhandle 005d ___pioinfo 006d ___lock_fhandle 008c __write_nolock 00c8 __unlock_fhandle 00e2 __invalid_parameter_noinfo 00ea __SEH_epilog4"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 08 83 FE FE 75 18 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E9 BA 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 88 AD 00 00 00 85 F6 0F 88 8D 00 00 00 3B 35 ?? ?? ?? ?? 0F 83 81 00 00 00 8B DE C1 FB 05 8B FE 83 E7 1F C1 E7 06 8B 04 9D ?? ?? ?? ?? 0F BE 44 38 04 83 E0 01 74 63 56 E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 04 9D ?? ?? ?? ?? F6 44 38 04 01 74 13 FF 75 10 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 8B F8 EB 16 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 20 00 83 CF FF 89 7D E4 C7 45 FC FE FF FF FF E8 0A 00 00 00 8B C7 EB 29 8B 75 08 8B 7D E4 56 E8 ?? ?? ?? ?? 59 C3 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_391_0_0 {
	meta:
		name = "__lseek"
		size = 239
		refs = "0003 __sehtable$__lseek 0008 __SEH_prolog4 0015 ___doserrno 001d __errno 002d __ioinit 0043 __nhandle 005d ___pioinfo 006d ___lock_fhandle 008c __lseek_nolock 00c8 __unlock_fhandle 00e2 __invalid_parameter_noinfo 00ea __SEH_epilog4"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 08 83 FE FE 75 18 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E9 BA 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 88 AD 00 00 00 85 F6 0F 88 8D 00 00 00 3B 35 ?? ?? ?? ?? 0F 83 81 00 00 00 8B DE C1 FB 05 8B FE 83 E7 1F C1 E7 06 8B 04 9D ?? ?? ?? ?? 0F BE 44 38 04 83 E0 01 74 63 56 E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 04 9D ?? ?? ?? ?? F6 44 38 04 01 74 13 FF 75 10 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 8B F8 EB 16 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 20 00 83 CF FF 89 7D E4 C7 45 FC FE FF FF FF E8 0A 00 00 00 8B C7 EB 29 8B 75 08 8B 7D E4 56 E8 ?? ?? ?? ?? 59 C3 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_95_1_0 {
	meta:
		name = "__write_nolock"
		size = 2122
		refs = "0009 __chkstk 000e ___security_cookie 0044 ___doserrno 004b __errno 0056 __invalid_parameter_noinfo 0063 __ioinit 007d ___pioinfo 0090 __imp__GetStdHandle@4 00fc __lseeki64_nolock 0105 __isatty 0131 __getptd 0162 __imp__GetConsoleMode@8 0180 __imp__GetConsoleCP@0 0201 _isleadbyte 022f _mbtowc 029d __imp__WideCharToMultiByte@32 02cf __imp__WriteFile@20 039e __putwch_nolock 0759 __imp__GetLastError@0 07f1 __dosmaperr 0844 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC B8 F0 1A 00 00 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 56 8B 75 08 57 33 FF 21 BD 28 E5 FF FF 89 85 44 E5 FF FF 89 BD 34 E5 FF FF 39 7D 10 75 07 33 C0 E9 FD 07 00 00 85 C0 75 1F E8 ?? ?? ?? ?? 21 38 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 DA 07 00 00 E8 ?? ?? ?? ?? 85 C0 78 EF 53 83 FE 01 74 05 83 FE 02 75 20 8B DE C1 E3 06 03 1D ?? ?? ?? ?? 74 13 8D 46 FF F7 D8 1B C0 83 C0 F5 50 FF 15 ?? ?? ?? ?? 89 03 8B C6 C1 F8 05 8B CE 8B 14 85 ?? ?? ?? ?? 83 E1 1F C1 E1 06 89 85 2C E5 FF FF 8A 5C 11 24 02 DB D0 FB 89 8D 1C E5 FF FF 80 FB 02 74 05 80 FB 01 75 25 8B 45 10 F7 D0 A8 01 75 1C E8 ?? ?? ?? ?? 21 38 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 41 07 00 00 F6 44 11 04 20 74 0F 6A 02 6A 00 6A 00 56 E8 ?? ?? ?? ?? 83 C4 10 56 E8 ?? ?? ?? ?? 8B B5 1C E5 FF FF 59 85 C0 0F 84 18 03 00 00 8B 85 2C E5 FF FF 8B 04 85 ?? ?? ?? ?? F6 44 06 04 80 0F 84 00 03 00 00 E8 ?? ?? ?? ?? 8B 40 6C 33 C9 39 88 A8 00 00 00 8D 85 18 E5 FF FF 50 8B 85 2C E5 FF FF 0F 94 C1 8B 04 85 ?? ?? ?? ?? FF 34 06 89 8D 40 E5 FF FF FF 15 ?? ?? ?? ?? 85 C0 0F 84 C2 02 00 00 39 BD 40 E5 FF FF 74 08 84 DB 0F 84 B2 02 00 00 FF 15 ?? ?? ?? ?? 8B 95 44 E5 FF FF 21 BD 30 E5 FF FF 8B CA 89 85 10 E5 FF FF 89 8D 38 E5 FF FF 39 7D 10 0F 86 7E 02 00 00 33 C0 89 85 3C E5 FF FF C7 85 14 E5 FF FF 0A 00 00 00 84 DB 0F 85 8F 01 00 00 8A 09 33 C0 80 F9 0A 0F 94 C0 89 85 40 E5 FF FF 8B 85 2C E5 FF FF 8B 14 85 ?? ?? ?? ?? 83 7C 16 38 00 74 17 8A 44 16 34 88 45 F4 6A 02 8D 45 F4 88 4D F5 83 64 16 38 00 50 EB 5A 0F BE C1 50 E8 ?? ?? ?? ?? 59 85 C0 74 44 8B 85 44 E5 FF FF 8B 95 38 E5 FF FF 2B C2 03 45 10 83 F8 01 0F 86 D3 01 00 00 6A 02 52 8D 85 34 E5 FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 0F 84 DB 01 00 00 8B 85 38 E5 FF FF 40 FF 85 3C E5 FF FF EB 26 6A 01 FF B5 38 E5 FF FF 8D 85 34 E5 FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 0F 84 AC 01 00 00 8B 85 38 E5 FF FF 33 C9 51 51 40 FF 85 3C E5 FF FF 6A 05 89 85 38 E5 FF FF 8D 45 F4 50 6A 01 8D 85 34 E5 FF FF 50 51 FF B5 10 E5 FF FF FF 15 ?? ?? ?? ?? 89 85 18 E5 FF FF 85 C0 0F 84 6B 01 00 00 6A 00 8D 8D 30 E5 FF FF 51 50 8D 45 F4 50 8B 85 2C E5 FF FF 8B 04 85 ?? ?? ?? ?? FF 34 06 FF 15 ?? ?? ?? ?? 85 C0 0F 84 E3 04 00 00 8B BD 3C E5 FF FF 8B 85 18 E5 FF FF 03 BD 28 E5 FF FF 39 85 30 E5 FF FF 0F 8C 21 01 00 00 83 BD 40 E5 FF FF 00 0F 84 DA 00 00 00 6A 00 8D 85 30 E5 FF FF 50 6A 01 8D 45 F4 50 8B 85 2C E5 FF FF C6 45 F4 0D 8B 04 85 ?? ?? ?? ?? FF 34 06 FF 15 ?? ?? ?? ?? 85 C0 0F 84 87 04 00 00 83 BD 30 E5 FF FF 01 0F 8C D6 00 00 00 FF 85 28 E5 FF FF 47 E9 90 00 00 00 80 FB 01 74 05 80 FB 02 75 33 0F B7 01 33 D2 66 3B 85 14 E5 FF FF 89 85 34 E5 FF FF 8B 85 3C E5 FF FF 0F 94 C2 83 C1 02 83 C0 02 89 8D 38 E5 FF FF 89 85 3C E5 FF FF 89 95 40 E5 FF FF 80 FB 01 74 05 80 FB 02 75 55 FF B5 34 E5 FF FF E8 ?? ?? ?? ?? 59 66 3B 85 34 E5 FF FF 0F 85 0E 04 00 00 83 C7 02 83 BD 40 E5 FF FF 00 74 24 6A 0D 58 50 89 85 34 E5 FF FF E8 ?? ?? ?? ?? 59 66 3B 85 34 E5 FF FF 0F 85 E5 03 00 00 47 FF 85 28 E5 FF FF 8B 85 3C E5 FF FF 8B 8D 38 E5 FF FF 3B 45 10 0F 82 C4 FD FF FF EB 23 8B 9D 2C E5 FF FF 8A 02 8B 0C 9D ?? ?? ?? ?? 47 88 44 0E 34 8B 04 9D ?? ?? ?? ?? C7 44 06 38 01 00 00 00 8B B5 40 E5 FF FF E9 A1 03 00 00 8B B5 40 E5 FF FF E9 A0 03 00 00 8B 85 2C E5 FF FF 8B 04 85 ?? ?? ?? ?? F6 44 06 04 80 0F 84 4D 03 00 00 8B 95 44 E5 FF FF 33 F6 89 B5 3C E5 FF FF 84 DB 0F 85 D9 00 00 00 89 95 40 E5 FF FF 39 75 10 0F 86 8B 03 00 00 33 C9 8B C2 2B 85 44 E5 FF FF 8D 9D 48 E5 FF FF 89 8D 30 E5 FF FF 3B 45 10 73 44 8A 0A 42 40 88 8D 23 E5 FF FF 80 F9 0A 8B 8D 30 E5 FF FF 89 95 40 E5 FF FF 75 0B FF 85 28 E5 FF FF C6 03 0D 43 41 8A 95 23 E5 FF FF 88 13 8B 95 40 E5 FF FF 43 41 89 8D 30 E5 FF FF 81 F9 FF 13 00 00 72 B7 8B 8D 1C E5 FF FF 8D 85 48 E5 FF FF 2B D8 6A 00 8D 85 24 E5 FF FF 50 53 8D 85 48 E5 FF FF 50 8B 85 2C E5 FF FF 8B 04 85 ?? ?? ?? ?? FF 34 01 FF 15 ?? ?? ?? ?? 85 C0 0F 84 B5 02 00 00 03 BD 24 E5 FF FF 39 9D 24 E5 FF FF 0F 8C AB 02 00 00 8B 95 40 E5 FF FF 8B C2 2B 85 44 E5 FF FF 3B 45 10 0F 82 3B FF FF FF E9 8F 02 00 00 8B CA 80 FB 02 0F 85 FE 00 00 00 89 8D 40 E5 FF FF 39 75 10 0F 86 A7 02 00 00 C7 85 14 E5 FF FF 0A 00 00 00 83 A5 18 E5 FF FF 00 8B BD 28 E5 FF FF 8B C1 2B C2 8B 95 18 E5 FF FF 8D 9D 48 E5 FF FF 3B 45 10 73 3E 0F B7 31 83 C1 02 83 C0 02 89 8D 40 E5 FF FF 66 3B B5 14 E5 FF FF 75 15 6A 0D 59 66 89 0B 8B 8D 40 E5 FF FF 83 C7 02 83 C3 02 83 C2 02 66 89 33 83 C2 02 83 C3 02 81 FA FE 13 00 00 72 BD 8B 8D 1C E5 FF FF 8D 85 48 E5 FF FF 2B D8 6A 00 8D 85 24 E5 FF FF 50 53 8D 85 48 E5 FF FF 50 8B 85 2C E5 FF FF 89 BD 28 E5 FF FF 8B 04 85 ?? ?? ?? ?? FF 34 01 FF 15 ?? ?? ?? ?? 8B B5 3C E5 FF FF 8B BD 34 E5 FF FF 85 C0 0F 84 B4 01 00 00 03 BD 24 E5 FF FF 8B 95 44 E5 FF FF 89 BD 34 E5 FF FF 39 9D 24 E5 FF FF 0F 8C A4 01 00 00 8B 8D 40 E5 FF FF 8B C1 2B C2 3B 45 10 0F 82 20 FF FF FF E9 8C 01 00 00 8B 5D 10 89 8D 30 E5 FF FF 85 DB 0F 84 A7 01 00 00 C7 85 14 E5 FF FF 0A 00 00 00 83 A5 18 E5 FF FF 00 8B B5 30 E5 FF FF 2B CA 8B 95 18 E5 FF FF 8D 85 48 F9 FF FF 3B CB 73 3B 0F B7 3E 83 C6 02 83 C1 02 89 B5 30 E5 FF FF 66 3B BD 14 E5 FF FF 75 12 6A 0D 5E 66 89 30 8B B5 30 E5 FF FF 83 C0 02 83 C2 02 66 89 38 83 C2 02 83 C0 02 81 FA A8 06 00 00 72 C1 33 F6 56 56 68 55 0D 00 00 8D 8D F0 EB FF FF 51 8D 8D 48 F9 FF FF 2B C1 99 2B C2 D1 F8 50 8B C1 50 56 68 E9 FD 00 00 FF 15 ?? ?? ?? ?? 8B B5 3C E5 FF FF 8B BD 34 E5 FF FF 89 85 38 E5 FF FF 85 C0 0F 84 C2 00 00 00 33 C9 89 8D 40 E5 FF FF 6A 00 2B C1 8D 95 24 E5 FF FF 52 50 8D 85 F0 EB FF FF 03 C1 8B 8D 1C E5 FF FF 50 8B 85 2C E5 FF FF 8B 04 85 ?? ?? ?? ?? FF 34 01 FF 15 ?? ?? ?? ?? 85 C0 74 1E 8B 8D 40 E5 FF FF 03 8D 24 E5 FF FF 8B 85 38 E5 FF FF 89 8D 40 E5 FF FF 3B C1 7F AF EB 1A FF 15 ?? ?? ?? ?? 8B 8D 40 E5 FF FF 8B F0 8B 85 38 E5 FF FF 89 B5 3C E5 FF FF 3B C1 7F 51 8B 8D 30 E5 FF FF 8B 95 44 E5 FF FF 8B F9 2B FA 89 BD 34 E5 FF FF 3B FB 0F 82 C8 FE FF FF EB 37 6A 00 8D 8D 24 E5 FF FF 51 FF 75 10 FF B5 44 E5 FF FF FF 34 06 FF 15 ?? ?? ?? ?? 85 C0 74 0A 8B BD 24 E5 FF FF 33 F6 EB 08 FF 15 ?? ?? ?? ?? 8B F0 8B 95 44 E5 FF FF 85 FF 75 63 85 F6 74 24 6A 05 5B 3B F3 75 14 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 89 18 EB 3F 56 E8 ?? ?? ?? ?? 59 EB 36 8B 85 2C E5 FF FF 8B 8D 1C E5 FF FF 8B 04 85 ?? ?? ?? ?? F6 44 01 04 40 74 09 80 3A 1A 75 04 33 C0 EB 20 E8 ?? ?? ?? ?? C7 00 1C 00 00 00 E8 ?? ?? ?? ?? 83 20 00 83 C8 FF EB 08 2B BD 28 E5 FF FF 8B C7 5B 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_95_2_0 {
	meta:
		name = "_refresh_std_handles"
		size = 50
		refs = "0018 ___pioinfo 0029 __imp__GetStdHandle@4"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 F8 01 74 05 83 F8 02 75 20 56 8B F0 C1 E6 06 03 35 ?? ?? ?? ?? 74 11 48 F7 D8 1B C0 83 C0 F5 50 FF 15 ?? ?? ?? ?? 89 06 5E 5D C3 }
	condition:
		$1
}

rule file_96_0_0 {
	meta:
		name = "___vdecl_fmod4"
		size = 89
		refs = "0016 __CIfmod"
	strings:
		$1 = { 83 EC 40 C5 FE 7F 04 24 C5 FE 7F 4C 24 20 DD 04 24 DD 44 24 20 E8 ?? ?? ?? ?? DD 1C 24 DD 44 24 08 DD 44 24 28 E8 ?? ?? ?? ?? DD 5C 24 08 DD 44 24 10 DD 44 24 30 E8 ?? ?? ?? ?? DD 5C 24 08 DD 44 24 18 DD 44 24 38 E8 ?? ?? ?? ?? DD 5C 24 18 C5 FE 6F 04 24 83 C4 40 C3 }
	condition:
		$1
}

rule file_97_4_0 {
	meta:
		name = "__mbsnbicmp_l"
		size = 444
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0031 __strnicmp 004e __errno 0059 __invalid_parameter_noinfo"
	strings:
		$1 = { 55 8B EC 83 EC 18 8D 4D E8 53 56 57 FF 75 14 E8 ?? ?? ?? ?? 8B 7D 10 33 D2 85 FF 0F 84 87 01 00 00 8B 4D EC 39 51 08 75 16 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 8B D0 E9 69 01 00 00 8B 75 08 85 F6 74 07 8B 5D 0C 85 DB 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? BA FF FF FF 7F E9 41 01 00 00 0F B6 06 89 45 10 89 45 FC 0F B6 C0 4F 46 F6 44 08 19 04 89 75 F8 74 6C 85 FF 75 1E 0F B6 03 89 55 FC F6 44 08 19 04 0F 85 14 01 00 00 8A 03 0F B6 C0 66 8B F2 E9 E3 00 00 00 8A 06 84 C0 75 05 89 55 FC EB 58 C1 65 10 08 0F B6 C0 66 09 45 10 8B 45 10 0F B7 C0 46 89 75 F8 66 8B F0 89 45 FC 66 3B 71 0C 72 0C 66 3B 71 0E 77 06 66 03 71 10 EB 2F 66 3B 71 12 72 29 66 3B 71 14 77 23 66 03 71 16 EB 1D 66 8B 75 FC 0F B7 C6 F6 44 08 19 10 74 0F 0F B6 84 08 19 01 00 00 89 45 FC 66 8B 75 FC 0F B6 03 89 45 FC 89 45 10 0F B6 C0 43 F6 44 08 19 04 74 49 85 FF 75 05 89 55 10 EB 62 8A 03 4F 84 C0 74 F4 C1 65 FC 08 0F B6 C0 66 09 45 FC 8B 45 FC 0F B7 C0 43 89 45 10 66 3B 41 0C 72 0C 66 3B 41 0E 77 06 66 03 41 10 EB 38 66 3B 41 12 72 32 66 3B 41 14 77 2C 66 03 41 16 EB 26 66 8B 45 10 0F B7 D0 6A 00 F6 44 0A 19 10 89 55 10 5A 74 12 8B 45 10 0F B6 84 08 19 01 00 00 89 45 10 66 8B 45 10 66 3B C6 75 12 66 85 F6 74 13 8B 75 F8 85 FF 0F 85 C7 FE FF FF EB 06 1B D2 83 E2 02 4A 80 7D F4 00 5F 5E 5B 74 07 8B 4D F0 83 61 70 FD 8B C2 C9 C3 }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "___lconv_init"
		size = 46
		refs = "0004 ___lconv_c"
	strings:
		$1 = { 83 C8 FF A2 ?? ?? ?? ?? A2 ?? ?? ?? ?? A2 ?? ?? ?? ?? A2 ?? ?? ?? ?? A2 ?? ?? ?? ?? A2 ?? ?? ?? ?? A2 ?? ?? ?? ?? A2 ?? ?? ?? ?? 33 C0 C3 }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "___avx_sinf8"
		size = 3232
		refs = "0013 ___common_ssin_data 0132 ___common_ssin_cout_rare 01e1 ___common_ssin_reduction_data"
	strings:
		$1 = { 55 8B EC 83 E4 C0 56 57 53 81 EC F4 02 00 00 C5 FC 10 1D ?? ?? ?? ?? C5 E9 EF D2 C5 FC 54 CB C5 F4 C2 25 ?? ?? ?? ?? 1E C4 E3 7D 19 E5 01 C5 D9 6B F5 C5 C9 63 FA C5 F9 D7 C7 0F B6 C0 85 C0 0F 85 F6 00 00 00 C5 E4 55 D0 33 DB C5 FC 10 1D ?? ?? ?? ?? C5 F4 59 25 ?? ?? ?? ?? C5 DC 58 FB C5 C9 72 F7 1F C4 E3 7D 19 FD 01 C5 D9 72 F5 1F C5 C4 5C EB C5 D4 59 1D ?? ?? ?? ?? C5 F4 5C DB C4 E3 4D 18 F4 01 C5 D4 59 25 ?? ?? ?? ?? C5 E4 5C DC C5 D4 59 25 ?? ?? ?? ?? C5 E4 5C DC C5 D4 59 25 ?? ?? ?? ?? C5 E4 5C DC C5 E4 59 E3 C5 DC 59 2D ?? ?? ?? ?? C5 D4 58 2D ?? ?? ?? ?? C5 D4 59 EC C5 D4 58 2D ?? ?? ?? ?? C5 D4 59 EC C5 D4 58 2D ?? ?? ?? ?? C5 D4 59 E4 C5 E4 57 DE C5 DC 59 E3 C5 DC 58 DB C5 E4 57 D2 0F B6 C3 85 C0 75 11 C5 FC 28 C2 81 C4 F4 02 00 00 5B 5F 5E 8B E5 5D C3 C5 FC 11 04 24 C5 FC 11 54 24 40 85 DB 74 E0 33 F6 0F A3 F3 72 0E 46 83 FE 20 7C F5 C5 FC 10 54 24 40 EB CB C5 F8 77 8D 44 B4 40 8D 14 B4 50 52 E8 ?? ?? ?? ?? 83 C4 08 EB DC C5 FC 10 25 ?? ?? ?? ?? BA 00 00 80 7F C5 FC 11 44 24 40 C5 F9 6E FA C5 DC 54 E9 C5 D4 C2 DC 00 C4 E3 7D 19 C4 01 C5 F8 11 A4 24 90 00 00 00 C4 E3 7D 19 DD 01 C5 E1 6B F5 C5 C9 63 D2 C5 F9 70 DF 00 C5 F9 D7 C2 89 84 24 A0 02 00 00 C5 F8 28 C8 C5 E1 DB D1 C5 D1 72 D2 17 C5 E1 DB D4 C5 E1 72 D2 17 C5 E9 72 F5 01 C5 E9 FE D5 C5 D1 72 F2 02 C5 E9 72 F3 01 C5 F9 7E EA C5 E9 FE D3 C5 E9 72 F2 02 C5 F8 11 8C 24 80 00 00 00 C4 E3 79 16 E9 01 C4 E3 79 16 E8 02 C4 E3 79 16 EF 03 C5 F9 7E D6 C5 F9 6E 99 ?? ?? ?? ?? C4 E3 79 16 94 24 AC 02 00 00 01 C4 E3 79 16 94 24 B0 02 00 00 02 C4 E3 79 16 D3 03 C5 F9 6E 92 ?? ?? ?? ?? C5 E9 6C EB C5 F9 6E 90 ?? ?? ?? ?? C5 F9 6E 9F ?? ?? ?? ?? C5 E9 6C D3 89 B4 24 A8 02 00 00 C5 D0 C6 F2 88 C5 F9 6E 96 ?? ?? ?? ?? 8B B4 24 AC 02 00 00 89 BC 24 A4 02 00 00 C5 F9 6E 83 ?? ?? ?? ?? C5 F9 6E 9E ?? ?? ?? ?? 8B B4 24 B0 02 00 00 C5 E9 6C EB C5 F9 6E 9B ?? ?? ?? ?? C5 F9 6E 96 ?? ?? ?? ?? C5 E9 6C D3 C5 D0 C6 EA 88 C5 F9 6E 92 ?? ?? ?? ?? C5 F9 6E 99 ?? ?? ?? ?? C5 E9 6C FB C5 F9 6E 9F ?? ?? ?? ?? 8B BC 24 A8 02 00 00 C5 F9 6E 90 ?? ?? ?? ?? C5 E9 6C D3 C5 C0 C6 FA 88 C5 F9 6E 97 ?? ?? ?? ?? 8B BC 24 AC 02 00 00 C5 F8 11 B4 24 A0 00 00 00 C5 F8 11 AC 24 B0 00 00 00 C5 F9 6E 9F ?? ?? ?? ?? C5 E9 6C D3 C5 F9 6E 9E ?? ?? ?? ?? C5 E1 6C D8 C5 E8 C6 D3 88 C5 F8 11 94 24 C0 00 00 00 C5 F9 6E 92 ?? ?? ?? ?? C5 F9 6E 99 ?? ?? ?? ?? B9 FF FF 7F 00 C5 E9 6C DB C5 F9 6E 90 ?? ?? ?? ?? 8B 84 24 A4 02 00 00 8B 94 24 A8 02 00 00 C5 F9 6E 80 ?? ?? ?? ?? B8 FF FF 00 00 C5 E9 6C D0 C5 E0 C6 DA 88 C5 F8 11 9C 24 D0 00 00 00 C5 F9 6E 92 ?? ?? ?? ?? BA 00 00 00 80 C5 F9 6E 9F ?? ?? ?? ?? BF 00 00 80 28 C5 F9 6E 83 ?? ?? ?? ?? BB 00 00 80 00 C5 E9 6C DB C5 F9 6E 96 ?? ?? ?? ?? BE FF 00 00 00 C5 E9 6C D0 C5 E0 C6 C2 88 C5 F9 6E D9 C5 F9 70 D3 00 C5 F9 6E DB C5 F9 70 DB 00 C5 E9 DB E4 C5 E9 DB C9 C5 D9 FE D3 C5 F9 6E E0 C5 F1 FE CB C5 F9 70 DC 00 B9 00 00 80 3F C5 C9 DB E3 C5 D1 DB F3 C5 D1 72 D7 10 C5 C1 DB FB C5 FA 7F AC 24 10 01 00 00 BB 00 00 40 47 C5 F8 10 AC 24 C0 00 00 00 B8 FF FF 03 00 C5 FA 7F B4 24 00 01 00 00 C5 C9 72 D5 10 C5 D1 DB EB C5 FA 7F AC 24 40 01 00 00 C5 F8 10 AC 24 D0 00 00 00 C5 F8 11 84 24 E0 00 00 00 C5 F9 72 D0 10 C5 FA 7F 84 24 60 01 00 00 C5 F9 72 D1 10 C5 F1 DB CB C5 D1 72 D5 10 C5 FA 7F AC 24 50 01 00 00 C5 D1 72 D2 10 C5 E9 DB D3 C5 FA 7F A4 24 F0 00 00 00 C4 E2 71 40 E4 C5 FA 7F A4 24 A0 01 00 00 C4 E2 69 40 A4 24 00 01 00 00 C5 FA 7F B4 24 20 01 00 00 C5 FA 7F BC 24 30 01 00 00 C5 FA 7F A4 24 B0 01 00 00 C4 E2 69 40 F6 C4 E2 71 40 A4 24 10 01 00 00 C5 FA 7F B4 24 D0 01 00 00 C4 E2 71 40 F7 C5 E1 DB BC 24 D0 00 00 00 C5 FA 7F A4 24 C0 01 00 00 C4 E2 79 40 E7 C5 FA 6F BC 24 50 01 00 00 C5 D9 72 D4 10 C5 FA 7F 8C 24 80 01 00 00 C4 E2 71 40 CF C5 FA 7F 84 24 70 01 00 00 C4 E2 79 40 C7 C5 C1 72 D1 10 C5 FA 7F B4 24 E0 01 00 00 C5 C9 DB F3 C5 F9 FE C7 C5 C9 FE F0 C5 D9 FE FE C5 E1 DB A4 24 E0 00 00 00 C5 FA 7F 94 24 90 01 00 00 C4 E2 69 40 94 24 40 01 00 00 C4 E2 51 40 CC C5 E9 DB C3 C5 FA 7F 94 24 F0 01 00 00 C5 C9 72 D1 10 C5 FA 6F 8C 24 60 01 00 00 C5 FA 6F 94 24 90 01 00 00 C4 E2 69 40 D1 C4 E2 51 40 E1 C5 E9 72 D2 10 C5 D9 FE E2 C5 F9 FE C4 C5 FA 7F BC 24 00 02 00 00 C5 C9 FE C8 C5 FA 6F A4 24 70 01 00 00 C5 C9 72 D7 10 C5 FA 6F BC 24 E0 01 00 00 C4 E2 59 40 84 24 30 01 00 00 C5 C1 72 D7 10 C5 E1 DB 94 24 C0 01 00 00 C5 F9 FE C7 C5 FA 7F 8C 24 10 02 00 00 C5 E9 FE D0 C5 C1 72 D1 10 C5 C9 FE C2 C5 FA 6F 8C 24 F0 01 00 00 C4 E2 51 40 B4 24 40 01 00 00 C5 F1 72 D1 10 C5 E1 DB 94 24 D0 01 00 00 C5 C9 FE F1 C5 E9 FE D6 C5 C1 FE F2 C5 FA 6F 94 24 C0 01 00 00 C4 E2 59 40 BC 24 10 01 00 00 C5 E9 72 D2 10 C5 E1 DB 8C 24 A0 01 00 00 C5 C1 FE FA C5 FA 7F 84 24 20 02 00 00 C5 F9 72 D0 10 C5 F1 FE D7 C5 FA 7F B4 24 30 02 00 00 C5 F9 FE FA C5 E9 72 D6 10 C5 FA 6F B4 24 D0 01 00 00 C4 E2 51 40 8C 24 20 01 00 00 C5 C9 72 D6 10 C5 E1 DB 84 24 B0 01 00 00 C5 F1 FE CE C5 F9 FE C1 C5 C9 72 D7 10 C5 E9 FE C8 C5 C1 DB FB C5 F8 10 84 24 A0 00 00 00 C5 FA 6F 94 24 80 01 00 00 C5 F9 72 D0 10 C4 E2 69 40 D0 C4 E2 59 40 84 24 F0 00 00 00 C5 E9 DB D3 C5 FA 6F A4 24 A0 01 00 00 C5 D9 72 D4 10 C5 F9 FE C4 C5 E9 FE D0 C5 C9 FE F2 C5 E9 72 D1 10 C5 F8 10 A4 24 B0 00 00 00 C5 F9 72 F6 10 C5 FA 6F B4 24 90 01 00 00 C5 F9 FE C7 C5 C1 72 D4 10 C5 F1 DB CB C4 E2 49 40 E7 C4 E2 51 40 B4 24 00 01 00 00 C5 D9 DB E3 C5 FA 6F AC 24 B0 01 00 00 C5 D1 72 D5 10 C5 C9 FE FD C5 D9 FE E7 C5 E9 FE D4 C5 D9 72 F2 10 C5 FA 6F BC 24 30 02 00 00 C5 D9 FE E9 C5 FA 6F A4 24 20 02 00 00 C5 E1 DB B4 24 00 02 00 00 C5 E9 72 F4 10 C5 E1 DB 9C 24 10 02 00 00 C5 D9 72 F7 10 C5 D9 FE E3 C5 F9 6E DA C5 E9 FE CE C5 F9 6E F1 C5 F9 70 D3 00 BA 00 00 00 34 C5 E9 DB 9C 24 80 00 00 00 B9 FF 01 00 00 C5 F9 70 F6 00 C5 E9 DB 94 24 90 00 00 00 C5 E1 EF FE C5 FA 7F 84 24 40 02 00 00 C5 F9 72 D0 09 C5 FA 7F AC 24 50 02 00 00 C5 D1 72 D5 09 C5 E9 EF F6 C5 F9 EB C7 C5 D1 EB EE C4 E3 7D 18 ED 01 C5 F9 6E C3 C5 F9 70 F0 00 BB DB 0F C9 40 C4 E3 4D 18 FE 01 C5 C4 58 C5 C5 FC 5C F7 C5 F9 6E FE C5 D4 5C EE BE 00 10 C9 40 C5 FC 11 6C 24 60 C5 F9 6E EF C5 F9 70 F5 00 C5 E9 EF EE BF 7A 77 95 B7 C5 F8 11 84 24 60 02 00 00 C4 E3 7D 19 84 24 70 02 00 00 01 C5 F9 70 C7 00 C5 F9 6E F8 C5 F9 70 FF 00 B8 00 F0 FF FF C5 FA 7F 84 24 80 02 00 00 C5 E1 EF C6 C5 C1 DB F1 C5 C1 DB FC C5 C9 72 F6 05 C5 C1 72 F7 05 C5 C9 EB F0 C5 C1 EB FD C5 F1 72 D1 12 C5 D9 72 D4 12 C4 E3 4D 18 FF 01 C4 E3 7D 18 ED 01 C5 F9 6E C2 C5 C4 5C FD BA FF FF FF 7F C5 F9 70 E8 00 C5 E1 EF C5 C5 F9 6E D9 C5 F9 70 DB 00 C5 E9 EF D5 C5 E1 DB B4 24 40 02 00 00 B9 00 00 80 35 C5 E1 DB 9C 24 50 02 00 00 C5 D1 72 F6 0E C5 E1 72 F3 0E C5 D1 EB E9 C5 E1 EB E4 C5 D1 EB C8 C5 D9 EB DA C4 E3 75 18 EB 01 C5 FC 10 4C 24 60 C4 E3 7D 18 D2 01 C5 D4 5C C2 C5 F9 6E EF C5 F4 58 F0 C5 F4 5C E6 C5 FC 58 DC C5 F9 6E E6 C5 E4 58 D7 C5 F9 6E FB C5 F9 70 DC 00 C5 F9 6E E0 C5 F9 70 C7 00 C5 F9 70 FD 00 C5 F9 70 EC 00 C4 E3 55 18 E5 01 C5 CC 54 E4 C5 CC 5C F4 C4 E3 7D 18 C8 01 C4 E3 65 18 C3 01 C4 E3 45 18 DF 01 C5 FC 59 FC C5 FC 59 EE C5 E4 59 C4 C5 F4 59 D2 C5 F9 6E C9 C5 E4 59 F6 C5 D4 58 C0 C5 F9 6E EA C5 EC 58 E6 C5 F9 70 F5 00 C5 FC 58 D4 C5 FC 10 44 24 40 C5 C4 58 E2 C5 C4 5C DC C5 F9 70 F9 00 C5 E4 58 D2 C4 E3 4D 18 DE 01 C5 FC 54 EB C4 E3 45 18 F7 01 C5 D4 C2 DE 1E C5 D4 C2 EE 12 C5 D4 54 E8 C5 E4 54 E4 C5 E4 54 D2 C5 D4 56 E4 C5 FA 6F AC 24 80 02 00 00 C5 FC 11 14 24 C5 D1 DB 94 24 60 02 00 00 C5 C9 72 F2 04 C5 D1 DB 94 24 70 02 00 00 C5 E9 72 F2 04 C5 F9 7E F6 C5 F9 7E D2 C5 DC 59 DC C4 E3 79 16 F3 01 C4 E3 79 16 F7 02 C4 E3 79 16 F1 03 C4 E3 79 16 94 24 BC 02 00 00 01 C4 E3 79 16 94 24 C0 02 00 00 02 C4 E3 79 16 D0 03 C5 F9 6E 96 ?? ?? ?? ?? C5 F9 6E AB ?? ?? ?? ?? C5 E9 6C F5 C5 F9 6E 97 ?? ?? ?? ?? C5 F9 6E A9 ?? ?? ?? ?? 89 94 24 B8 02 00 00 C5 E9 6C D5 C5 F9 6E AA ?? ?? ?? ?? 8B 94 24 BC 02 00 00 C5 C8 C6 D2 88 89 8C 24 B4 02 00 00 C5 F9 6E B2 ?? ?? ?? ?? 8B 94 24 C0 02 00 00 C5 D1 6C FE C5 F9 6E B0 ?? ?? ?? ?? C5 F9 6E AA ?? ?? ?? ?? C5 D1 6C EE C5 C0 C6 ED 88 C5 F9 6E B3 ?? ?? ?? ?? C5 F9 6E 88 ?? ?? ?? ?? 89 9C 24 98 02 00 00 89 B4 24 94 02 00 00 89 BC 24 9C 02 00 00 C4 E3 6D 18 D5 01 C5 F9 6E AE ?? ?? ?? ?? C5 D1 6C FE C5 F9 6E B1 ?? ?? ?? ?? 8B 8C 24 B8 02 00 00 C5 F9 6E AF ?? ?? ?? ?? C5 D1 6C EE C5 F9 6E B1 ?? ?? ?? ?? 8B 8C 24 BC 02 00 00 C5 C0 C6 ED 88 C5 F9 6E B9 ?? ?? ?? ?? C5 C9 6C F7 C5 F9 6E BA ?? ?? ?? ?? C5 C1 6C F9 C5 C8 C6 F7 88 C4 E3 55 18 EE 01 C5 F9 6E B3 ?? ?? ?? ?? C5 FC 11 6C 24 20 C5 F9 6E AE ?? ?? ?? ?? C5 D1 6C EE 8B 9F ?? ?? ?? ?? 89 9C 24 90 02 00 00 8B 9C 24 A0 02 00 00 8B B4 24 B4 02 00 00 8B BC 24 B8 02 00 00 C5 FC 11 44 24 40 C5 F9 6E BC 24 90 02 00 00 C5 F9 6E 86 ?? ?? ?? ?? C5 C1 6C C8 C5 D0 C6 F1 88 C5 F9 6E AF ?? ?? ?? ?? C5 F9 6E B9 ?? ?? ?? ?? C5 D1 6C CF C5 F9 6E 82 ?? ?? ?? ?? C5 F9 6E A8 ?? ?? ?? ?? C5 F9 6C FD C5 F0 C6 C7 88 C5 EC 59 CC 89 9C 24 A0 02 00 00 8B 9C 24 94 02 00 00 C4 E3 4D 18 F0 01 C5 FC 11 74 24 60 C5 DC 59 FE C5 FC 10 74 24 20 C5 CC 58 C7 C5 F4 58 E8 C5 CC 5C F0 C5 FC 11 AC 24 80 00 00 00 C5 FC 5C ED C5 CC 58 F7 C5 E4 59 3D ?? ?? ?? ?? C5 D4 58 C9 C5 F4 58 C6 C5 FC 11 84 24 A0 00 00 00 C5 C4 58 05 ?? ?? ?? ?? C5 F9 6E BE ?? ?? ?? ?? C5 FC 59 EB C5 E4 59 05 ?? ?? ?? ?? C5 D4 59 CC C5 EC 58 6C 24 60 C5 F4 59 D5 C5 FC 58 0D ?? ?? ?? ?? C5 FC 11 94 24 C0 00 00 00 C5 F4 59 DB C5 FC 10 4C 24 20 C5 F9 6E 93 ?? ?? ?? ?? 8B 9C 24 98 02 00 00 C5 DC 59 E1 C5 E4 59 C1 C5 F9 6E 9B ?? ?? ?? ?? C5 E9 6C D3 C5 D4 5C CC 8B 9C 24 9C 02 00 00 C5 F4 59 24 24 C5 F9 6E B3 ?? ?? ?? ?? C5 C9 6C DF C5 F9 6E B7 ?? ?? ?? ?? C5 F9 6E B9 ?? ?? ?? ?? C5 E8 C6 D3 88 C5 C9 6C DF C5 F9 6E B2 ?? ?? ?? ?? C5 F9 6E B8 ?? ?? ?? ?? C5 C9 6C F7 C5 E0 C6 DE 88 8B 9C 24 A0 02 00 00 C4 E3 6D 18 D3 01 C5 DC 58 DA C5 FC 58 C3 C5 FC 58 AC 24 C0 00 00 00 C5 FC 10 44 24 40 C5 D4 58 B4 24 A0 00 00 00 C5 CC 58 94 24 80 00 00 00 E9 55 F4 FF FF 8D A4 24 00 00 00 00 EB 03 CC CC CC }
	condition:
		$1
}

rule file_103_3_0 {
	meta:
		name = "__mbsnbset_s_l"
		size = 527
		refs = "0048 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 005d __strnset_s 0092 __ismbblead_l 01cc __errno 01d6 __invalid_parameter_noinfo"
	strings:
		$1 = { 55 8B EC 83 EC 20 53 56 8B 75 14 33 DB 57 89 5D F8 89 5D FC 85 F6 75 15 39 5D 08 75 19 39 5D 0C 0F 85 D3 01 00 00 33 C0 E9 DD 01 00 00 39 5D 08 0F 84 C3 01 00 00 8B 7D 0C 85 FF 0F 84 B8 01 00 00 FF 75 18 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 E4 39 58 08 75 17 56 FF 75 10 57 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 8B D8 E9 7F 01 00 00 8B 4D 10 8B 75 08 8B C1 C1 E8 08 89 45 F4 84 C0 0F 84 B3 00 00 00 84 C9 0F 84 BE 00 00 00 8D 4D E0 0F B6 C0 51 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 A7 00 00 00 8B 45 14 A8 01 74 07 33 C9 48 41 89 4D F8 8B CE D1 E8 89 45 14 38 19 74 6B 85 C0 74 64 4F 74 61 8D 4E 01 89 4D F0 38 19 74 5F 39 5D FC 74 04 8B CB EB 14 8D 45 E0 50 0F B6 06 50 E8 ?? ?? ?? ?? 59 59 8B C8 8B 45 14 8B 55 F4 88 16 8B 75 F0 89 4D FC 4F 74 2C 85 C9 74 05 89 5D FC EB 15 8D 45 E0 50 0F B6 06 50 E8 ?? ?? ?? ?? 59 89 45 FC 8B 45 14 59 8B 4D 10 88 0E 46 48 89 45 14 38 1E 75 98 8B 4D 08 8B 55 F8 EB 6E 8B 4D 08 33 D2 47 88 1E 42 EB 63 8D 45 E0 50 0F B6 C1 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 07 88 1E E9 92 00 00 00 8B CE 38 19 74 41 8B 45 14 8B 4D 10 85 C0 74 30 4F 74 2D 39 5D FC 74 05 89 5D FC EB 18 8D 45 E0 50 0F B6 06 50 E8 ?? ?? ?? ?? 59 59 8B 4D 10 89 45 FC 8B 45 14 88 0E 46 48 89 45 14 38 1E 75 CC 8B 4D 08 8B D3 EB 05 8B D3 8B 45 14 85 C0 75 27 39 5D FC 74 1E 38 1E 74 1E 4F 74 17 33 D2 42 38 5E 01 75 05 88 1E 47 EB 0A C6 06 20 46 EB 04 4F 74 05 46 38 1E 75 F8 85 FF 75 13 88 19 E8 ?? ?? ?? ?? 6A 16 5B 89 18 E8 ?? ?? ?? ?? EB 0E 85 D2 74 0A E8 ?? ?? ?? ?? 6A 2A 5B 89 18 80 7D EC 00 74 18 8B 4D E8 83 61 70 FD EB 0F E8 ?? ?? ?? ?? 6A 16 5B 89 18 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_104_0_0 {
	meta:
		name = "_puts"
		size = 354
		refs = "0003 __sehtable$_puts 0008 __SEH_prolog4 001f __errno 002a __invalid_parameter_noinfo 0031 __SEH_epilog4 0037 __ioinit 0040 ___iob_func 004f __fileno 006d ___pioinfo 0074 ___badioinfo 00b6 __lock_file2 00ca __stbuf 00d5 _strlen 00eb __fwrite_nolock 011d __flsbuf 0135 __ftbuf 015b __unlock_file2"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 CF FF 89 7D E4 33 C0 39 45 08 0F 95 C0 85 C0 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 85 C0 78 EF E8 ?? ?? ?? ?? 83 C0 20 F6 40 0C 40 75 5D 50 E8 ?? ?? ?? ?? 59 8B D0 3B D7 74 19 83 FA FE 74 14 8B CA C1 F9 05 83 E0 1F C1 E0 06 03 04 8D ?? ?? ?? ?? EB 05 B8 ?? ?? ?? ?? F6 40 24 7F 75 A0 3B D7 74 19 83 FA FE 74 14 8B C2 C1 F8 05 83 E2 1F C1 E2 06 03 14 85 ?? ?? ?? ?? EB 05 BA ?? ?? ?? ?? F6 42 24 80 0F 85 74 FF FF FF E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 59 59 83 65 FC 00 E8 ?? ?? ?? ?? 83 C0 20 50 E8 ?? ?? ?? ?? 89 45 E0 FF 75 08 E8 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 83 C0 20 50 56 6A 01 FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 3B C6 75 32 E8 ?? ?? ?? ?? FF 48 24 78 11 E8 ?? ?? ?? ?? 8D 48 20 8B 01 C6 00 0A FF 01 EB 12 E8 ?? ?? ?? ?? 83 C0 20 50 6A 0A E8 ?? ?? ?? ?? 59 59 33 FF 89 7D E4 E8 ?? ?? ?? ?? 83 C0 20 50 FF 75 E0 E8 ?? ?? ?? ?? 59 59 C7 45 FC FE FF FF FF E8 08 00 00 00 E9 E2 FE FF FF 8B 7D E4 E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_107_0_0 {
	meta:
		name = "___createFile"
		size = 145
		refs = "0008 ___crtIsPackagedApp 0011 ??_C@_0M@HHGEPIBF@CreateFile2?$AA@ 0016 ??_C@_1BK@MGMFAEKH@?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA3?$AA2?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 001c __imp__GetModuleHandleW@4 0023 __imp__GetProcAddress@8 008a __imp__CreateFileW@28"
	strings:
		$1 = { 55 8B EC 83 EC 1C 56 E8 ?? ?? ?? ?? 85 C0 74 22 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B F0 85 F6 75 08 83 C8 FF EB 5C 8B 75 FC E8 ?? ?? ?? ?? 85 C0 8B 45 1C 74 32 83 65 F0 00 83 65 F8 00 89 45 E8 8B 45 20 89 45 EC 8B 45 14 89 45 F4 8D 45 E4 50 FF 75 18 C7 45 E4 18 00 00 00 FF 75 10 FF 75 0C FF 75 08 FF D6 EB 1B 0B 45 20 6A 00 50 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 5E C9 C3 }
	condition:
		$1
}

rule file_107_2_0 {
	meta:
		name = "__wopen"
		size = 173
		refs = "0003 __sehtable$__wopen 0008 __SEH_prolog4 0022 __errno 002d __invalid_parameter_noinfo 004e __wsopen_nolock 0091 ___pioinfo 009e __unlock_fhandle 00a8 __SEH_epilog4"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 4D E4 FF 33 C0 89 45 E0 33 C9 39 45 08 0F 95 C1 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 71 89 45 FC 50 FF 75 10 6A 40 FF 75 0C FF 75 08 8D 45 E4 50 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 1C 8B F0 89 75 DC C7 45 FC FE FF FF FF E8 10 00 00 00 85 F6 74 3A E8 ?? ?? ?? ?? 89 30 EB BE 8B 75 DC 83 7D E0 00 74 27 85 F6 74 1A 8B 4D E4 8B C1 C1 F8 05 83 E1 1F C1 E1 06 8B 04 85 ?? ?? ?? ?? 80 64 08 04 FE FF 75 E4 E8 ?? ?? ?? ?? 59 C3 8B 45 E4 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_737_0_0 {
	meta:
		name = "__open"
		size = 173
		refs = "0003 __sehtable$__open 0008 __SEH_prolog4 0022 __errno 002d __invalid_parameter_noinfo 004e __sopen_nolock 0091 ___pioinfo 009e __unlock_fhandle 00a8 __SEH_epilog4"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 4D E4 FF 33 C0 89 45 E0 33 C9 39 45 08 0F 95 C1 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 71 89 45 FC 50 FF 75 10 6A 40 FF 75 0C FF 75 08 8D 45 E4 50 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 1C 8B F0 89 75 DC C7 45 FC FE FF FF FF E8 10 00 00 00 85 F6 74 3A E8 ?? ?? ?? ?? 89 30 EB BE 8B 75 DC 83 7D E0 00 74 27 85 F6 74 1A 8B 4D E4 8B C1 C1 F8 05 83 E1 1F C1 E1 06 8B 04 85 ?? ?? ?? ?? 80 64 08 04 FE FF 75 E4 E8 ?? ?? ?? ?? 59 C3 8B 45 E4 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_107_3_0 {
	meta:
		name = "__wsopen"
		size = 49
		refs = "001e __wsopen_helper"
	strings:
		$1 = { 55 8B EC 51 56 6A 00 8D 45 FC 50 FF 75 14 83 CE FF FF 75 10 89 75 FC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 03 8B 75 FC 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_737_1_0 {
	meta:
		name = "__sopen"
		size = 49
		refs = "001e __sopen_helper"
	strings:
		$1 = { 55 8B EC 51 56 6A 00 8D 45 FC 50 FF 75 14 83 CE FF FF 75 10 89 75 FC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 03 8B 75 FC 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_107_4_0 {
	meta:
		name = "__wsopen_helper"
		size = 199
		refs = "0003 __sehtable$__wsopen_helper 0008 __SEH_prolog4 001f __errno 0029 __invalid_parameter_noinfo 006e __wsopen_nolock 0090 __SEH_epilog4 00b5 ___pioinfo 00c1 __unlock_fhandle"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 E4 00 33 C0 8B 75 18 85 F6 0F 95 C0 85 C0 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 5E 83 0E FF 33 C0 39 45 08 0F 95 C0 85 C0 74 DE 83 7D 1C 00 74 0F 8B 45 14 25 7F FE FF FF F7 D8 1B C0 40 74 C9 83 65 FC 00 FF 75 1C FF 75 14 FF 75 10 FF 75 0C FF 75 08 56 8D 45 E4 50 E8 ?? ?? ?? ?? 83 C4 1C 8B F8 89 7D E0 C7 45 FC FE FF FF FF E8 15 00 00 00 85 FF 74 03 83 0E FF 8B C7 E8 ?? ?? ?? ?? C3 8B 75 18 8B 7D E0 83 7D E4 00 74 25 85 FF 74 19 8B 0E 8B C1 C1 F8 05 83 E1 1F C1 E1 06 8B 04 85 ?? ?? ?? ?? 80 64 08 04 FE FF 36 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_737_2_0 {
	meta:
		name = "__sopen_helper"
		size = 199
		refs = "0003 __sehtable$__sopen_helper 0008 __SEH_prolog4 001f __errno 0029 __invalid_parameter_noinfo 006e __sopen_nolock 0090 __SEH_epilog4 00b5 ___pioinfo 00c1 __unlock_fhandle"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 E4 00 33 C0 8B 75 18 85 F6 0F 95 C0 85 C0 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 5E 83 0E FF 33 C0 39 45 08 0F 95 C0 85 C0 74 DE 83 7D 1C 00 74 0F 8B 45 14 25 7F FE FF FF F7 D8 1B C0 40 74 C9 83 65 FC 00 FF 75 1C FF 75 14 FF 75 10 FF 75 0C FF 75 08 56 8D 45 E4 50 E8 ?? ?? ?? ?? 83 C4 1C 8B F8 89 7D E0 C7 45 FC FE FF FF FF E8 15 00 00 00 85 FF 74 03 83 0E FF 8B C7 E8 ?? ?? ?? ?? C3 8B 75 18 8B 7D E0 83 7D E4 00 74 25 85 FF 74 19 8B 0E 8B C1 C1 F8 05 83 E1 1F C1 E1 06 8B 04 85 ?? ?? ?? ?? 80 64 08 04 FE FF 36 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_107_5_0 {
	meta:
		name = "__wsopen_nolock"
		size = 1913
		refs = "001a __ioinit 002a __imp__GetLastError@0 0030 __dosmaperr 0036 __errno 005f __get_fmode 009f ___doserrno 00b6 __invalid_parameter_noinfo 01bd __umaskval 0227 __alloc_osfhnd 0274 ___createFile 02d1 ___pioinfo 02f9 __imp__GetFileType@4 032e __imp__CloseHandle@4 035d __set_osfhnd 03c7 __lseeki64_nolock 03ed __close_nolock 0402 __read_nolock 041d __chsize_nolock 064e __write 0746 __free_osfhnd 0774 __invoke_watson"
	strings:
		$1 = { 55 8B EC 83 EC 38 53 33 DB 89 5D E0 88 5D FE C7 45 C8 0C 00 00 00 89 5D CC E8 ?? ?? ?? ?? 85 C0 79 1F 8B 45 0C 83 08 FF FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 8B 00 E9 12 02 00 00 F6 45 14 80 74 09 89 5D D0 C6 45 FF 10 EB 0A C7 45 D0 01 00 00 00 88 5D FF 8D 45 E0 50 E8 ?? ?? ?? ?? 59 85 C0 0F 85 02 07 00 00 8B 4D 14 B8 00 80 00 00 85 C8 75 11 F7 C1 00 40 07 00 75 05 39 45 E0 74 04 80 4D FF 80 8B C1 83 E0 03 57 BA 00 00 00 C0 2B C3 74 48 48 74 2A 48 74 23 E8 ?? ?? ?? ?? 89 18 8B 45 0C 83 08 FF E8 ?? ?? ?? ?? 6A 16 5B 89 18 E8 ?? ?? ?? ?? 8B C3 E9 91 01 00 00 8B FA EB 20 F6 C1 08 74 0F F7 C1 00 00 07 00 74 07 8B FA 89 55 F8 EB 0F BF 00 00 00 40 EB 05 BF 00 00 00 80 89 7D F8 8B 45 18 56 6A 10 5E 6A 02 5A 89 55 D8 2B C6 74 36 2B C6 74 29 2B C6 74 20 2B C6 74 13 83 E8 40 75 75 81 FF 00 00 00 80 0F 94 C0 89 45 F4 EB 1A C7 45 F4 03 00 00 00 EB 11 89 55 F4 EB 0C C7 45 F4 01 00 00 00 EB 03 89 5D F4 8B C1 25 00 07 00 00 BE 00 04 00 00 3B C6 7F 28 74 21 85 C0 74 1D 3D 00 01 00 00 74 12 3D 00 02 00 00 74 4A 3D 00 03 00 00 75 22 8B F2 EB 46 6A 04 EB 02 6A 03 5E EB 3D 3D 00 05 00 00 74 33 3D 00 06 00 00 74 28 3D 00 07 00 00 74 25 E8 ?? ?? ?? ?? 89 18 8B 45 0C 83 08 FF E8 ?? ?? ?? ?? 6A 16 5B 89 18 E8 ?? ?? ?? ?? E9 C7 05 00 00 6A 05 EB C3 33 F6 46 BA 80 00 00 00 8B C3 89 55 E8 89 45 F0 F7 C1 00 01 00 00 74 16 A1 ?? ?? ?? ?? F7 D0 23 45 1C 84 C0 8B C3 78 06 33 D2 42 89 55 E8 F6 C1 40 74 15 81 CF 00 00 01 00 83 4D F4 04 B8 00 00 00 04 89 45 F0 89 7D F8 F7 C1 00 10 00 00 74 09 81 CA 00 01 00 00 89 55 E8 F7 C1 00 20 00 00 74 08 0D 00 00 00 02 89 45 F0 F6 C1 20 74 07 0D 00 00 00 08 EB 0A F6 C1 10 74 08 0D 00 00 00 10 89 45 F0 E8 ?? ?? ?? ?? 8B 7D 0C 89 07 83 F8 FF 75 21 E8 ?? ?? ?? ?? 89 18 83 0F FF E8 ?? ?? ?? ?? C7 00 18 00 00 00 E8 ?? ?? ?? ?? 8B 00 5E 5F 5B C9 C3 FF 75 F0 8B 45 08 FF 75 E8 C7 00 01 00 00 00 56 8D 45 C8 50 FF 75 F4 FF 75 F8 FF 75 10 E8 ?? ?? ?? ?? 83 C4 1C 89 45 E4 83 F8 FF 75 73 8B 4D F8 BA 00 00 00 C0 8B C1 23 C2 3B C2 75 31 F6 45 14 01 74 2B FF 75 F0 8D 45 C8 FF 75 E8 81 E1 FF FF FF 7F 56 50 FF 75 F4 89 4D F8 51 FF 75 10 E8 ?? ?? ?? ?? 83 C4 1C 89 45 E4 83 F8 FF 75 32 8B 0F 8B C1 C1 F8 05 83 E1 1F 8B 04 85 ?? ?? ?? ?? C1 E1 06 80 64 08 04 FE FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 8B 18 E9 71 04 00 00 50 FF 15 ?? ?? ?? ?? 85 C0 75 42 8B 0F 8B C1 C1 F8 05 83 E1 1F 8B 04 85 ?? ?? ?? ?? C1 E1 06 80 64 08 04 FE FF 15 ?? ?? ?? ?? 8B F0 56 E8 ?? ?? ?? ?? 59 FF 75 E4 FF 15 ?? ?? ?? ?? 85 F6 75 B4 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 EB A7 83 F8 02 75 06 80 4D FF 40 EB 09 83 F8 03 75 04 80 4D FF 08 FF 75 E4 FF 37 E8 ?? ?? ?? ?? 8A 55 FF 59 59 8B 0F 8B C1 C1 F8 05 83 E1 1F 8B 04 85 ?? ?? ?? ?? C1 E1 06 80 CA 01 88 54 08 04 8B 0F 8B C1 C1 F8 05 83 E1 1F 8B 04 85 ?? ?? ?? ?? C1 E1 06 88 55 FF 80 64 08 24 80 8B 4D 14 8A C2 24 48 88 45 FD 0F 85 96 00 00 00 84 D2 0F 89 B2 02 00 00 F6 C1 02 0F 84 85 00 00 00 6A 02 6A FF 6A FF FF 37 E8 ?? ?? ?? ?? 8B C8 23 CA 83 C4 10 89 45 D4 89 55 EC 83 F9 FF 75 19 E8 ?? ?? ?? ?? 81 38 83 00 00 00 74 53 FF 37 E8 ?? ?? ?? ?? E9 F3 FE FF FF 6A 01 8D 45 DC 50 FF 37 89 5D DC E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 1C 66 83 7D DC 1A 75 15 FF 75 EC FF 75 D4 FF 37 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 74 C1 53 53 53 FF 37 E8 ?? ?? ?? ?? 23 C2 83 C4 10 83 F8 FF 74 AD 8A 55 FF 8B 4D 14 84 D2 0F 89 1C 02 00 00 F7 C1 00 40 07 00 75 17 8B 45 E0 25 00 40 07 00 75 08 81 C9 00 40 00 00 EB 02 0B C8 89 4D 14 8B C1 25 00 40 07 00 3D 00 40 00 00 74 44 3D 00 00 01 00 74 29 3D 00 40 01 00 74 22 3D 00 00 02 00 74 29 3D 00 40 02 00 74 22 3D 00 00 04 00 74 07 3D 00 40 04 00 75 1D C6 45 FE 01 EB 17 8B C1 25 01 03 00 00 3D 01 03 00 00 75 09 C6 45 FE 02 EB 03 88 5D FE F7 C1 00 00 07 00 0F 84 9C 01 00 00 89 5D EC F6 C2 40 0F 85 90 01 00 00 8B 45 F8 B9 00 00 00 C0 23 C1 3D 00 00 00 40 0F 84 ED 00 00 00 3D 00 00 00 80 74 5B 3B C1 0F 85 6C 01 00 00 85 F6 0F 84 64 01 00 00 6A 02 59 3B F1 0F 86 10 01 00 00 83 FE 04 76 0E 83 FE 05 0F 84 02 01 00 00 E9 46 01 00 00 51 53 53 FF 37 E8 ?? ?? ?? ?? 83 C4 10 0B C2 0F 84 E5 00 00 00 53 53 53 FF 37 E8 ?? ?? ?? ?? 23 C2 83 C4 10 83 F8 FF 0F 84 9C FE FF FF 6A 03 8D 45 EC 50 FF 37 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 0F 84 83 FE FF FF 8B 4D EC 6A 02 5A 3B C2 74 1A 83 F8 03 0F 85 88 00 00 00 81 F9 EF BB BF 00 75 09 C6 45 FE 01 E9 DC 00 00 00 81 E1 FF FF 00 00 81 F9 FE FF 00 00 75 17 FF 37 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 6A 16 5B 89 18 E9 B7 01 00 00 81 F9 FF FE 00 00 75 4A 53 53 52 FF 37 E8 ?? ?? ?? ?? 23 C2 83 C4 10 83 F8 FF 0F 84 1A FE FF FF C6 45 FE 02 E9 8E 00 00 00 85 F6 0F 84 86 00 00 00 6A 02 59 3B F1 76 36 83 FE 04 0F 87 22 FF FF FF 51 53 53 FF 37 E8 ?? ?? ?? ?? 83 C4 10 0B C2 74 19 53 53 53 FF 37 E8 ?? ?? ?? ?? 23 C2 83 C4 10 83 F8 FF 75 51 E9 CF FD FF FF 6A 02 59 0F BE 45 FE 8B F3 48 74 0C 48 75 3D C7 45 EC FF FE 00 00 EB 0D 6A 03 59 C7 45 EC EF BB BF 00 89 4D D8 8B C1 2B C6 50 8D 45 EC 03 C6 50 FF 37 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 0F 84 8C FD FF FF 8B 4D D8 03 F0 3B CE 7F D9 8B 17 8B C2 C1 F8 05 83 E2 1F 8B 0C 85 ?? ?? ?? ?? C1 E2 06 8A 44 11 24 32 45 FE 24 7F 30 44 11 24 8B 37 8B 4D 14 8B C6 C1 F8 05 83 E6 1F 8B 14 85 ?? ?? ?? ?? C1 E6 06 C1 E9 10 8A 44 32 24 C0 E1 07 24 7F 0A C8 88 4C 32 24 8B 4D 14 38 5D FD 75 21 F6 C1 08 74 1C 8B 0F 8B C1 C1 F8 05 83 E1 1F 8B 04 85 ?? ?? ?? ?? C1 E1 06 80 4C 08 04 20 8B 4D 14 8B 75 F8 BA 00 00 00 C0 8B C6 23 C2 3B C2 75 7D F6 C1 01 74 78 FF 75 E4 FF 15 ?? ?? ?? ?? FF 75 F0 8D 45 C8 FF 75 E8 81 E6 FF FF FF 7F 6A 03 50 FF 75 F4 56 FF 75 10 E8 ?? ?? ?? ?? 83 C4 1C 83 F8 FF 75 32 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 0F 8B C1 C1 F8 05 83 E1 1F 8B 04 85 ?? ?? ?? ?? C1 E1 06 80 64 08 04 FE FF 37 E8 ?? ?? ?? ?? 59 E9 99 FB FF FF 8B 17 8B CA C1 F9 05 83 E2 1F 8B 0C 8D ?? ?? ?? ?? C1 E2 06 89 04 0A 8B C3 E9 E3 FA FF FF 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_107_6_0 {
	meta:
		name = "__wsopen_s"
		size = 30
		refs = "0015 __wsopen_helper"
	strings:
		$1 = { 55 8B EC 6A 01 FF 75 08 FF 75 18 FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_737_4_0 {
	meta:
		name = "__sopen_s"
		size = 30
		refs = "0015 __sopen_helper"
	strings:
		$1 = { 55 8B EC 6A 01 FF 75 08 FF 75 18 FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_108_0_0 {
	meta:
		name = "___avx_logf8"
		size = 352
		refs = "0016 ___common_slog_data 0155 ___common_slog_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FC 11 44 24 20 C5 F8 10 1D ?? ?? ?? ?? C5 F8 10 3D ?? ?? ?? ?? C5 F9 FA F3 C4 E3 7D 19 C1 01 C5 E9 72 E6 17 C5 F1 FA E3 C5 C9 DB F7 C5 D1 72 E4 17 C5 D9 DB FF C4 E3 6D 18 D5 01 C5 C9 FE EB C5 C1 FE DB C5 F8 10 35 ?? ?? ?? ?? C5 FC 5B D2 C5 EC 59 15 ?? ?? ?? ?? C4 E3 55 18 E3 01 C5 F8 10 2D ?? ?? ?? ?? C5 F9 FE C5 C5 F1 FE CD C5 C9 66 F8 C5 C9 66 D9 C5 C1 6B C3 C5 DC 5C 1D ?? ?? ?? ?? C5 F1 EF C9 C5 F9 63 E9 C5 F9 D7 D5 C5 E4 59 25 ?? ?? ?? ?? C5 DC 58 35 ?? ?? ?? ?? C5 CC 59 C3 C5 FC 58 0D ?? ?? ?? ?? C5 F4 59 E3 C5 DC 58 2D ?? ?? ?? ?? C5 D4 59 F3 C5 CC 58 3D ?? ?? ?? ?? C5 C4 59 C3 C5 FC 58 0D ?? ?? ?? ?? C5 F4 59 E3 C5 DC 58 2D ?? ?? ?? ?? C5 D4 59 F3 C5 CC 59 FB C5 C4 58 DB 0F B6 C2 C5 EC 58 C3 85 C0 75 04 8B E5 5D C3 C5 FC 10 4C 24 20 C5 FC 11 84 24 80 00 00 00 C5 FC 11 4C 24 40 85 D2 74 E3 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FC 10 84 24 80 00 00 00 EB B9 C5 F8 77 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE 8B FF }
	condition:
		$1
}

rule file_109_1_0 {
	meta:
		name = "??0ArrayNode@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAE@PAPAVExternalStatistics@23@@Z"
		size = 22
		altNames = "??0ArrayNode@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAE@PAPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@@Z ??0ArrayNode@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QAE@PAPAVScheduleGroupBase@23@@Z ??0ArrayNode@?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@QAE@PAPAVScheduleGroupSegmentBase@23@@Z ??0ArrayNode@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAE@PAPAVVirtualProcessor@23@@Z ??0ArrayNode@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE@PAPAVWorkQueue@23@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 61 04 00 83 49 08 FF 89 01 8B C1 5D C2 04 00 }
	condition:
		$1
}

rule file_109_2_0 {
	meta:
		name = "??0ExternalContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z"
		size = 198
		refs = "0003 __ehhandler$??0ExternalContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z 0008 __EH_prolog3 0017 ??0ContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z 0026 ??_7ExternalContextBase@details@Concurrency@@6B@ 0038 __imp__CreateEventW@16 0048 __imp__GetLastError@0 005d ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 0062 __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 006b __CxxThrowException@8 0073 ?GetAnonymousScheduleGroupSegment@SchedulerBase@details@Concurrency@@QAEPAVScheduleGroupSegmentBase@23@XZ 007d ??2@YAPAXI@Z 00ae ?Add@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAEHPAVExternalStatistics@23@@Z 00b8 ?PrepareForUse@ExternalContextBase@details@Concurrency@@QAEX_N@Z 00bf __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 F0 6A 01 FF 75 08 E8 ?? ?? ?? ?? 33 FF 57 57 57 57 89 7D FC C7 06 ?? ?? ?? ?? 89 BE A0 00 00 00 89 BE A4 00 00 00 FF 15 ?? ?? ?? ?? 89 86 A8 00 00 00 85 C0 75 29 FF 15 ?? ?? ?? ?? 85 C0 7E 08 0F B7 C0 0D 00 00 07 80 50 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 4E 1C E8 ?? ?? ?? ?? 6A 1C 89 46 18 E8 ?? ?? ?? ?? 59 85 C0 74 15 89 78 08 89 78 0C 89 78 10 89 78 14 C7 40 18 01 00 00 00 EB 02 8B C7 8B 4E 1C 50 81 C1 C8 00 00 00 89 86 9C 00 00 00 E8 ?? ?? ?? ?? FF 75 0C 8B CE E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2 08 00 }
	condition:
		$1
}

rule file_109_4_0 {
	meta:
		name = "__ehhandler$??0ExternalContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ExternalContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_63_18_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$codecvt@DDH@std@@@std@@YAABV?$codecvt@DDH@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$codecvt@DDH@std@@@std@@YAABV?$codecvt@DDH@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_14_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$codecvt@GDH@std@@@std@@YAABV?$codecvt@GDH@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$codecvt@GDH@std@@@std@@YAABV?$codecvt@GDH@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_108_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$codecvt@_WDH@std@@@std@@YAABV?$codecvt@_WDH@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$codecvt@_WDH@std@@@std@@YAABV?$codecvt@_WDH@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_36_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$collate@D@std@@@std@@YAABV?$collate@D@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$collate@D@std@@@std@@YAABV?$collate@D@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_94_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$collate@G@std@@@std@@YAABV?$collate@G@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$collate@G@std@@@std@@YAABV?$collate@G@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_97_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$collate@_W@std@@@std@@YAABV?$collate@_W@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$collate@_W@std@@@std@@YAABV?$collate@_W@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_63_21_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_100_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_21_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_42_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$messages@D@std@@@std@@YAABV?$messages@D@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$messages@D@std@@@std@@YAABV?$messages@D@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_106_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$messages@G@std@@@std@@YAABV?$messages@G@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$messages@G@std@@@std@@YAABV?$messages@G@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_126_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$messages@_W@std@@@std@@YAABV?$messages@_W@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$messages@_W@std@@@std@@YAABV?$messages@_W@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_45_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_112_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_132_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_48_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_135_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_121_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_43_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@D$00@std@@@std@@YAABV?$moneypunct@D$00@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@D$00@std@@@std@@YAABV?$moneypunct@D$00@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_46_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@D$0A@@std@@@std@@YAABV?$moneypunct@D$0A@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@D$0A@@std@@@std@@YAABV?$moneypunct@D$0A@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_124_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@G$00@std@@@std@@YAABV?$moneypunct@G$00@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@G$00@std@@@std@@YAABV?$moneypunct@G$00@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_127_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@G$0A@@std@@@std@@YAABV?$moneypunct@G$0A@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@G$0A@@std@@@std@@YAABV?$moneypunct@G$0A@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_130_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@_W$00@std@@@std@@YAABV?$moneypunct@_W$00@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@_W$00@std@@@std@@YAABV?$moneypunct@_W$00@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_150_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@_W$0A@@std@@@std@@YAABV?$moneypunct@_W$0A@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@_W$0A@@std@@@std@@YAABV?$moneypunct@_W$0A@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_31_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_153_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_139_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_38_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_142_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_145_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_37_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_165_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$numpunct@G@std@@@std@@YAABV?$numpunct@G@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$numpunct@G@std@@@std@@YAABV?$numpunct@G@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_151_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$numpunct@_W@std@@@std@@YAABV?$numpunct@_W@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$numpunct@_W@std@@@std@@YAABV?$numpunct@_W@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_49_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_171_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_157_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_60_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_160_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_163_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_829_6_0 {
	meta:
		name = "__ehhandler$??0SchedulingRing@details@Concurrency@@QAE@PAVSchedulerBase@12@H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0SchedulingRing@details@Concurrency@@QAE@PAVSchedulerBase@12@H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_849_10_0 {
	meta:
		name = "__ehhandler$??0ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_849_16_0 {
	meta:
		name = "__ehhandler$??0UMSFreeThreadProxyFactory@details@Concurrency@@IAE@PAVThreadProxyFactoryManager@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0UMSFreeThreadProxyFactory@details@Concurrency@@IAE@PAVThreadProxyFactoryManager@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_944_10_0 {
	meta:
		name = "__ehhandler$??0UMSFreeVirtualProcessorRoot@details@Concurrency@@QAE@PAVUMSSchedulerProxy@12@PAUSchedulerNode@12@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0UMSFreeVirtualProcessorRoot@details@Concurrency@@QAE@PAVUMSSchedulerProxy@12@PAUSchedulerNode@12@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_765_151_0 {
	meta:
		name = "__ehhandler$?AllocateSegment@FairScheduleGroup@details@Concurrency@@MAEPAVScheduleGroupSegmentBase@23@PAVSchedulingRing@23@PAVlocation@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AllocateSegment@FairScheduleGroup@details@Concurrency@@MAEPAVScheduleGroupSegmentBase@23@PAVSchedulingRing@23@PAVlocation@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_301_21_0 {
	meta:
		name = "__ehhandler$?DemandInitialize@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@AAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?DemandInitialize@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@AAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_765_302_0 {
	meta:
		name = "__ehhandler$?InternalCreateScheduleGroup@SchedulerBase@details@Concurrency@@AAEPAVScheduleGroup@3@PAVlocation@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?InternalCreateScheduleGroup@SchedulerBase@details@Concurrency@@AAEPAVScheduleGroup@3@PAVlocation@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_765_393_0 {
	meta:
		name = "__ehhandler$?SetDefaultSchedulerPolicy@SchedulerBase@details@Concurrency@@SAXABVSchedulerPolicy@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?SetDefaultSchedulerPolicy@SchedulerBase@details@Concurrency@@SAXABVSchedulerPolicy@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_761_107_0 {
	meta:
		name = "__ehhandler$?_InitBadAllocException@__ExceptionPtr@@CA?AV?$shared_ptr@V__ExceptionPtr@@@std@@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_InitBadAllocException@__ExceptionPtr@@CA?AV?$shared_ptr@V__ExceptionPtr@@@std@@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_118_1 {
	meta:
		name = "__ehhandler$?_Internal_grow@_Concurrent_vector_base_v4@details@Concurrency@@IAEXIIIP6AXPAXPBXI@Z1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Internal_grow@_Concurrent_vector_base_v4@details@Concurrency@@IAEXIIIP6AXPAXPBXI@Z1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_125_1 {
	meta:
		name = "__ehhandler$?_Internal_reserve@_Concurrent_vector_base_v4@details@Concurrency@@IAEXIII@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Internal_reserve@_Concurrent_vector_base_v4@details@Concurrency@@IAEXIII@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1116_190_0 {
	meta:
		name = "__ehhandler$?_Schedule@_TaskCollection@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Schedule@_TaskCollection@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1116_193_0 {
	meta:
		name = "__ehhandler$?_Schedule@_TaskCollection@details@Concurrency@@QAEXPAV_UnrealizedChore@23@PAVlocation@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Schedule@_TaskCollection@details@Concurrency@@QAEXPAV_UnrealizedChore@23@PAVlocation@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1155_21_0 {
	meta:
		name = "__ehhandler$?wait@Concurrency@@YAXI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?wait@Concurrency@@YAXI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_109_5_0 {
	meta:
		name = "??0ExternalStatistics@details@Concurrency@@QAE@XZ"
		size = 24
	strings:
		$1 = { 33 C0 89 41 08 89 41 0C 89 41 10 89 41 14 C7 41 18 01 00 00 00 8B C1 C3 }
	condition:
		$1
}

rule file_109_10_0 {
	meta:
		name = "??1?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAE@XZ"
		size = 19
		refs = "0004 ?Wipe@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEXXZ 000c ??_V@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? FF 76 08 E8 ?? ?? ?? ?? 59 5E C3 }
	condition:
		$1
}

rule file_765_68_0 {
	meta:
		name = "??1?$Hash@II@details@Concurrency@@QAE@XZ"
		size = 19
		refs = "0004 ?Wipe@?$Hash@II@details@Concurrency@@QAEXXZ 000c ??_V@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? FF 76 08 E8 ?? ?? ?? ?? 59 5E C3 }
	condition:
		$1
}

rule file_109_12_0 {
	meta:
		name = "??1CancellationBeaconStack@ContextBase@details@Concurrency@@QAE@XZ"
		size = 57
		refs = "001a ??_V@YAXPAX@Z 0020 ??3@YAXPAX@Z"
	strings:
		$1 = { 53 8B D9 83 7B 04 00 7E 25 8B 43 08 57 8B 38 85 FF 74 1A 56 FF 37 8B 77 04 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 59 8B FE 85 F6 75 E8 5E 5F FF 73 08 E8 ?? ?? ?? ?? 59 5B C3 }
	condition:
		$1
}

rule file_109_14_0 {
	meta:
		name = "??1ContextBase@details@Concurrency@@UAE@XZ"
		size = 46
		refs = "000b ??1CancellationBeaconStack@ContextBase@details@Concurrency@@QAE@XZ 0018 ?Wipe@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEXXZ 0020 ??_V@YAXPAX@Z 0027 ??_7Context@Concurrency@@6B@"
	strings:
		$1 = { 56 57 8B F9 8D 8F 8C 00 00 00 E8 ?? ?? ?? ?? 8D B7 80 00 00 00 8B CE E8 ?? ?? ?? ?? FF 76 08 E8 ?? ?? ?? ?? 59 C7 07 ?? ?? ?? ?? 5F 5E C3 }
	condition:
		$1
}

rule file_109_15_0 {
	meta:
		name = "??1ExternalContextBase@details@Concurrency@@UAE@XZ"
		size = 45
		refs = "0003 __ehhandler$??1ExternalContextBase@details@Concurrency@@UAE@XZ 0008 __EH_prolog3 0013 ??_7ExternalContextBase@details@Concurrency@@6B@ 001c ?Cleanup@ExternalContextBase@details@Concurrency@@AAEXXZ 0023 ??1ContextBase@details@Concurrency@@UAE@XZ 0028 __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 F0 C7 06 ?? ?? ?? ?? 83 65 FC 00 E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_109_24_0 {
	meta:
		name = "??_GCancellationBeaconNode@CancellationBeaconStack@ContextBase@details@Concurrency@@QAEPAXI@Z"
		size = 34
		refs = "0009 ??_V@YAXPAX@Z 0016 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 FF 36 E8 ?? ?? ?? ?? F6 45 08 01 59 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_109_25_0 {
	meta:
		name = "??_GContext@Concurrency@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7Context@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_652_2 {
	meta:
		name = "??_G?$ISource@I@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7?$ISource@I@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_653_2 {
	meta:
		name = "??_G?$ISource@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7?$ISource@W4agent_status@Concurrency@@@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_654_2 {
	meta:
		name = "??_G?$ITarget@I@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7?$ITarget@I@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_122_655_1 {
	meta:
		name = "??_G?$ITarget@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7?$ITarget@W4agent_status@Concurrency@@@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_849_35_0 {
	meta:
		name = "??_G?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7IThreadProxyFactory@details@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_849_36_0 {
	meta:
		name = "??_G?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7IThreadProxyFactory@details@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_658_2 {
	meta:
		name = "??_G?$_Func_base@XABIU_Nil@std@@U12@U12@U12@U12@U12@@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7?$_Func_base@XABIU_Nil@std@@U12@U12@U12@U12@U12@@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_659_2 {
	meta:
		name = "??_G?$_Func_base@XPAV?$message@I@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7?$_Func_base@XPAV?$message@I@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_660_2 {
	meta:
		name = "??_G?$_Func_base@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7?$_Func_base@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_111_493_2 {
	meta:
		name = "??_G?$_Func_base@XU_Nil@std@@U12@U12@U12@U12@U12@U12@@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7?$_Func_base@XU_Nil@std@@U12@U12@U12@U12@U12@U12@@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_661_2 {
	meta:
		name = "??_G?$_Func_base@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7?$_Func_base@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_662_2 {
	meta:
		name = "??_G?$_Func_impl@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@@2@_NABW4agent_status@Concurrency@@U_Nil@2@U62@U62@U62@U62@U62@@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7?$_Func_base@_NABW4agent_status@Concurrency@@U_Nil@std@@U34@U34@U34@U34@U34@@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_761_60_0 {
	meta:
		name = "??_G?$_Ref_count@V__ExceptionPtr@@@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Ref_count_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_761_61_0 {
	meta:
		name = "??_G?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Ref_count_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_99_577_1 {
	meta:
		name = "??_G?$_Ref_count_obj@U_ExceptionHolder@details@Concurrency@@@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Ref_count_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_39_109_2 {
	meta:
		name = "??_G?$codecvt@DDH@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_60_128_1 {
	meta:
		name = "??_G?$codecvt@GDH@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_105_380_2 {
	meta:
		name = "??_G?$codecvt@_WDH@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_122_680_1 {
	meta:
		name = "??_G?$message@I@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7?$message@I@Concurrency@@6B@ 0014 ?Free@Concurrency@@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_122_681_1 {
	meta:
		name = "??_G?$message@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7?$message@W4agent_status@Concurrency@@@Concurrency@@6B@ 0014 ?Free@Concurrency@@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_4_168_2 {
	meta:
		name = "??_G?$messages@D@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_62_454_1 {
	meta:
		name = "??_G?$messages@G@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_105_386_2 {
	meta:
		name = "??_G?$messages@_W@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_4_169_2 {
	meta:
		name = "??_G?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_105_387_2 {
	meta:
		name = "??_G?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_62_457_1 {
	meta:
		name = "??_G?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_80_205_1 {
	meta:
		name = "??_G?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_62_458_1 {
	meta:
		name = "??_G?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_62_459_1 {
	meta:
		name = "??_G?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_65_129_1 {
	meta:
		name = "??_G?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_62_464_1 {
	meta:
		name = "??_G?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_62_465_1 {
	meta:
		name = "??_G?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_65_130_1 {
	meta:
		name = "??_G?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_62_466_1 {
	meta:
		name = "??_G?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_105_398_2 {
	meta:
		name = "??_G?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_765_116_0 {
	meta:
		name = "??_GCacheLocalScheduleGroup@details@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7ScheduleGroup@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_145_25_0 {
	meta:
		name = "??_GCancellationTokenRegistration_TaskProc@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_RefCounterBase@details@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_449_21_0 {
	meta:
		name = "??_GExecutionResource@details@Concurrency@@QAEPAXI@Z"
		size = 32
		refs = "000c ??_7ExecutionResource@details@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_765_118_0 {
	meta:
		name = "??_GFairScheduleGroup@details@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7ScheduleGroup@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_849_38_0 {
	meta:
		name = "??_GFreeThreadProxyFactory@details@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7IThreadProxyFactory@details@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_849_39_0 {
	meta:
		name = "??_GIThreadProxyFactory@details@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7IThreadProxyFactory@details@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_765_120_0 {
	meta:
		name = "??_GRealizedChore@details@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Chore@details@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_765_121_0 {
	meta:
		name = "??_GScheduleGroup@Concurrency@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7ScheduleGroup@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_860_72_0 {
	meta:
		name = "??_GScheduleGroupBase@details@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7ScheduleGroup@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_765_122_0 {
	meta:
		name = "??_GScheduler@Concurrency@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7Scheduler@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_538_10_0 {
	meta:
		name = "??_GUMSSchedulingContext@details@Concurrency@@QAEPAXI@Z"
		size = 32
		refs = "000c ??_7UMSSchedulingContext@details@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_145_26_0 {
	meta:
		name = "??_G_CancellationTokenRegistration@details@Concurrency@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_RefCounterBase@details@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_765_128_0 {
	meta:
		name = "??_G_Chore@details@Concurrency@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Chore@details@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_106_130_1 {
	meta:
		name = "??_G_Facet_base@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_12_507_2 {
	meta:
		name = "??_G_Future_error_category@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7error_category@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_106_131_1 {
	meta:
		name = "??_G_Generic_error_category@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7error_category@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_48_132_1 {
	meta:
		name = "??_G_Iostream_error_category@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7error_category@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_111_505_2 {
	meta:
		name = "??_G_RefCounterBase@details@Concurrency@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_RefCounterBase@details@Concurrency@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_12_511_2 {
	meta:
		name = "??_G_Ref_count_base@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Ref_count_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_99_588_1 {
	meta:
		name = "??_G_System_error_category@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7error_category@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1_134_1 {
	meta:
		name = "??_Gcodecvt_base@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_43_115_2 {
	meta:
		name = "??_Gctype_base@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_80_215_1 {
	meta:
		name = "??_Gerror_category@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7error_category@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_80_216_1 {
	meta:
		name = "??_Gfacet@locale@std@@MAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_80_217_1 {
	meta:
		name = "??_Gmessages_base@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_62_483_1 {
	meta:
		name = "??_Gmoney_base@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_62_485_1 {
	meta:
		name = "??_Gtime_base@std@@UAEPAXI@Z"
		size = 32
		refs = "000c ??_7_Facet_base@std@@6B@ 0014 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_109_32_0 {
	meta:
		name = "?Add@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAEHPAVExternalStatistics@23@@Z"
		size = 344
		refs = "00a7 ??_U@YAPAXI@Z 00bb _memset 00c2 ??2@YAPAXI@Z 0128 ?_UnderlyingYield@details@Concurrency@@YAXXZ 0130 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
		altNames = "?Add@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAEHPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 20 53 56 57 8B F1 6A 04 8B 56 30 C6 45 FF 00 33 FF 89 55 F8 58 8D 5A 08 89 5D F4 83 3B FF 7C 3B 8B 1A 33 D2 39 56 28 7E 2C 83 3B 00 75 1F 8B 4D 08 8D 04 3A 89 01 8B 46 40 89 45 F0 33 C0 F0 0F B1 0B 85 C0 0F 84 8F 00 00 00 6A 04 58 42 03 D8 3B 56 28 7C D4 8B 5D F4 8B 55 F8 80 7D FF 00 0F 85 D2 00 00 00 6A FE 59 83 C8 FF F0 0F B1 0B 03 7E 28 8D 5A 04 83 3B 00 0F 85 99 00 00 00 33 C9 41 33 C0 F0 0F B1 0B 85 C0 0F 85 88 00 00 00 8B 46 28 33 C9 6A 04 5A F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 8B C8 8B 46 28 C1 E0 02 50 6A 00 51 89 4D F0 E8 ?? ?? ?? ?? 6A 0C E8 ?? ?? ?? ?? 8B C8 83 C4 14 85 C9 74 35 8B 45 F0 83 61 04 00 83 49 08 FF 89 01 EB 28 03 FA C6 45 FF 01 3B 7D F0 7C 0A 33 C9 8D 46 40 41 F0 0F C1 08 8B 5D F4 83 C9 FF 8B C2 F0 0F B1 0B E9 59 FF FF FF 33 C9 8B 56 3C 3B 56 38 7D 09 8B 46 34 89 0C 90 FF 46 3C 87 0B 8B 55 F8 83 3B 01 75 1B 83 65 E8 00 C7 45 EC ?? ?? ?? ?? 8D 4D E0 E8 ?? ?? ?? ?? 83 3B 01 74 F3 8B 55 F8 80 7D FF 00 8B 52 04 6A 04 89 55 F8 58 0F 84 CB FE FF FF 8B C7 5F 5E 5B C9 C2 04 00 }
	condition:
		$1
}

rule file_109_34_0 {
	meta:
		name = "?Alloc@ExternalContextBase@details@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0004 ?GetCurrentSubAllocator@ExternalContextBase@details@Concurrency@@QAEPAVSubAllocator@23@XZ 0010 ?Alloc@SubAllocator@details@Concurrency@@QAEPAXI@Z 0018 ?StaticAlloc@SubAllocator@details@Concurrency@@SAPAXI@Z"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 85 C0 74 08 8B C8 5D E9 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 59 5D C2 04 00 }
	condition:
		$1
}

rule file_109_35_0 {
	meta:
		name = "?Block@ExternalContextBase@details@Concurrency@@UAEXXZ"
		size = 58
		refs = "0016 ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z 0034 __imp__WaitForSingleObject@8"
	strings:
		$1 = { 56 8B F1 8B 4E 1C FF 76 08 8B 01 FF 50 04 50 6A 04 6A 03 8B CE E8 ?? ?? ?? ?? 33 C0 8D 4E 2C 40 F0 0F C1 01 40 83 F8 01 75 0E 6A FF FF B6 A8 00 00 00 FF 15 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_109_36_0 {
	meta:
		name = "?Cleanup@ExternalContextBase@details@Concurrency@@AAEXXZ"
		size = 88
		refs = "0004 ?Cleanup@ContextBase@details@Concurrency@@QAEXXZ 0015 __imp__CloseHandle@4 003d ?ReturnSubAllocator@SchedulerBase@details@Concurrency@@SAXPAVSubAllocator@23@@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? 8B 86 A4 00 00 00 85 C0 74 0E 50 FF 15 ?? ?? ?? ?? 83 A6 A4 00 00 00 00 8B 86 A8 00 00 00 85 C0 74 07 50 FF 15 ?? ?? ?? ?? 8B 86 A0 00 00 00 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 8B 86 9C 00 00 00 83 A6 9C 00 00 00 00 C7 40 18 00 00 00 00 5E C3 }
	condition:
		$1
}

rule file_109_39_0 {
	meta:
		name = "?DetachStatistics@ExternalContextBase@details@Concurrency@@QAEPAVExternalStatistics@23@XZ"
		size = 21
	strings:
		$1 = { 8B 81 9C 00 00 00 83 A1 9C 00 00 00 00 C7 40 18 00 00 00 00 C3 }
	condition:
		$1
}

rule file_109_44_0 {
	meta:
		name = "?Free@ExternalContextBase@details@Concurrency@@UAEXPAX@Z"
		size = 37
		refs = "0004 ?GetCurrentSubAllocator@ExternalContextBase@details@Concurrency@@QAEPAVSubAllocator@23@XZ 0010 ?Free@SubAllocator@details@Concurrency@@QAEXPAX@Z 001c ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 85 C0 74 08 8B C8 5D E9 ?? ?? ?? ?? 8B 45 08 83 C0 FC 50 E8 ?? ?? ?? ?? 59 5D C2 04 00 }
	condition:
		$1
}

rule file_109_47_0 {
	meta:
		name = "?GetCriticalRegionType@ContextBase@details@Concurrency@@UBE?AW4CriticalRegionType@3@XZ"
		size = 20
	strings:
		$1 = { 83 79 10 00 76 04 6A 02 58 C3 33 C0 3B 41 0C 1B C0 F7 D8 C3 }
	condition:
		$1
}

rule file_109_48_0 {
	meta:
		name = "?GetCurrentSubAllocator@ExternalContextBase@details@Concurrency@@QAEPAVSubAllocator@23@XZ"
		size = 34
		refs = "000f ?GetSubAllocator@SchedulerBase@details@Concurrency@@SAPAVSubAllocator@23@_N@Z"
	strings:
		$1 = { 56 8B F1 83 BE A0 00 00 00 00 75 0E 6A 01 E8 ?? ?? ?? ?? 59 89 86 A0 00 00 00 8B 86 A0 00 00 00 5E C3 }
	condition:
		$1
}

rule file_109_50_0 {
	meta:
		name = "?ImplicitDetachHandler@ExternalContextBase@details@Concurrency@@CGXPAU_TP_CALLBACK_INSTANCE@@PAXPAU_TP_WAIT@@K@Z"
		size = 34
		refs = "000d ?DetachExternalContext@SchedulerBase@details@Concurrency@@AAEXPAVExternalContextBase@23@_N@Z 0018 ?UnRegisterAsyncWaitAndUnloadLibrary@details@Concurrency@@YAXPAU_TP_CALLBACK_INSTANCE@@PAU_TP_WAIT@@@Z"
	strings:
		$1 = { 55 8B EC 8B 4D 0C 6A 00 51 8B 49 1C E8 ?? ?? ?? ?? FF 75 10 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C2 10 00 }
	condition:
		$1
}

rule file_109_51_0 {
	meta:
		name = "?ImplicitDetachHandlerXP@ExternalContextBase@details@Concurrency@@CGXPAXE@Z"
		size = 35
		refs = "000f __imp__UnregisterWait@4 001a ?DetachExternalContext@SchedulerBase@details@Concurrency@@AAEXPAVExternalContextBase@23@_N@Z"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 FF B6 AC 00 00 00 FF 15 ?? ?? ?? ?? 8B 4E 1C 6A 00 56 E8 ?? ?? ?? ?? 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_109_54_0 {
	meta:
		name = "?Oversubscribe@ExternalContextBase@details@Concurrency@@UAEX_N@Z"
		size = 55
		refs = "0024 ??0invalid_oversubscribe_operation@Concurrency@@QAE@XZ 0029 __TI2?AVinvalid_oversubscribe_operation@Concurrency@@ 0032 __CxxThrowException@8"
		altNames = "?Oversubscribe@UMSThreadInternalContext@details@Concurrency@@UAEX_N@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 80 7D 08 00 74 05 FF 41 14 EB 0B 8B 41 14 85 C0 74 08 48 89 41 14 C9 C2 04 00 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_109_55_0 {
	meta:
		name = "?PrepareForUse@ExternalContextBase@details@Concurrency@@QAEX_N@Z"
		size = 205
		refs = "0015 __imp__GetCurrentThreadId@0 0033 __imp__GetCurrentProcess@0 003a __imp__GetCurrentThread@0 0048 __imp__DuplicateHandle@28 0052 __imp__GetLastError@0 005d ?GetOSVersion@Concurrency@@YA?AW4OSVersion@IResourceManager@1@XZ 0068 ?ImplicitDetachHandler@ExternalContextBase@details@Concurrency@@CGXPAU_TP_CALLBACK_INSTANCE@@PAXPAU_TP_WAIT@@K@Z 006f ?RegisterAsyncWaitAndLoadLibrary@details@Concurrency@@YAPAU_TP_WAIT@@PAXP6GXPAU_TP_CALLBACK_INSTANCE@@0PAU3@K@Z0@Z 0092 ?ImplicitDetachHandlerXP@ExternalContextBase@details@Concurrency@@CGXPAXE@Z 00a1 __imp__RegisterWaitForSingleObject@24 00ba ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 00bf __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 00c8 __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 8A 5D 08 57 8B F9 88 9F 98 00 00 00 FF 15 ?? ?? ?? ?? 89 47 44 84 DB 0F 85 83 00 00 00 6A 02 6A 00 6A 00 8D 9F A4 00 00 00 53 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 0C FF 15 ?? ?? ?? ?? 85 C0 7E 5B EB 51 E8 ?? ?? ?? ?? 83 F8 03 7C 26 57 68 ?? ?? ?? ?? FF 33 E8 ?? ?? ?? ?? 83 C4 0C 89 87 AC 00 00 00 85 C0 75 27 FF 15 ?? ?? ?? ?? 85 C0 7E 2B EB 21 6A 0C 6A FF 57 68 ?? ?? ?? ?? FF 33 8D 87 AC 00 00 00 50 FF 15 ?? ?? ?? ?? EB D5 5F 5B C9 C2 04 00 0F B7 C0 0D 00 00 07 80 50 8D 4D F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_109_56_0 {
	meta:
		name = "?RemoveFromUse@ExternalContextBase@details@Concurrency@@QAEXXZ"
		size = 34
		refs = "0004 ?ReleaseWorkQueue@ContextBase@details@Concurrency@@IAEXXZ 0015 __imp__CloseHandle@4"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? 8B 86 A4 00 00 00 85 C0 74 0E 50 FF 15 ?? ?? ?? ?? 83 A6 A4 00 00 00 00 5E C3 }
	condition:
		$1
}

rule file_109_58_0 {
	meta:
		name = "?StaticFree@SubAllocator@details@Concurrency@@SAXPAX@Z"
		size = 18
		refs = "000b ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 C0 FC 50 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_109_59_0 {
	meta:
		name = "?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z"
		size = 45
		refs = "0008 ?g_TraceInfo@details@Concurrency@@3U_CONCRT_TRACE_INFO@12@A 0022 ?ThrowContextEvent@ContextBase@details@Concurrency@@KAXW4ConcRT_EventType@3@EKK@Z"
	strings:
		$1 = { 55 8B EC 8B 4D 0C 3A 0D ?? ?? ?? ?? 77 1B A1 ?? ?? ?? ?? A8 02 74 12 FF 75 14 FF 75 10 51 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C2 10 00 }
	condition:
		$1
}

rule file_109_60_0 {
	meta:
		name = "?Unblock@ExternalContextBase@details@Concurrency@@UAEXXZ"
		size = 117
		refs = "000a ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0025 ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z 003e __imp__SetEvent@4 0053 ??0context_self_unblock@Concurrency@@QAE@XZ 0058 __TI2?AVcontext_self_unblock@Concurrency@@ 0062 ??0context_unblock_unbalanced@Concurrency@@QAE@XZ 0067 __TI2?AVcontext_unblock_unbalanced@Concurrency@@ 0070 __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 83 EC 0C 56 8B F1 E8 ?? ?? ?? ?? 3B F0 74 3D 8B 4E 1C FF 76 08 8B 01 FF 50 04 50 6A 04 6A 04 8B CE E8 ?? ?? ?? ?? 8D 46 2C 83 C9 FF F0 0F C1 08 49 75 0F FF B6 A8 00 00 00 FF 15 ?? ?? ?? ?? 5E C9 C3 8D 41 01 83 F8 01 76 F5 EB 0F 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? EB 0D 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_109_61_0 {
	meta:
		name = "?Wipe@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEXXZ"
		size = 74
		refs = "001f ??3@YAXPAX@Z 0040 _memset"
		altNames = "?Wipe@?$Hash@II@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 57 8B F9 83 7F 04 00 7E 3F 53 33 DB 39 1F 7E 20 56 8B 47 08 8B 04 98 85 C0 74 0F 8B 30 50 E8 ?? ?? ?? ?? 59 8B C6 85 F6 75 F1 43 3B 1F 7C E2 5E 8B 07 83 67 04 00 C1 E0 02 50 6A 00 FF 77 08 E8 ?? ?? ?? ?? 83 C4 0C 5B 5F C3 }
	condition:
		$1
}

rule file_109_62_0 {
	meta:
		name = "?Yield@ExternalContextBase@details@Concurrency@@UAEXXZ"
		size = 33
		refs = "0016 ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z 001d __imp__SwitchToThread@0"
	strings:
		$1 = { 56 8B F1 8B 4E 1C FF 76 08 8B 01 FF 50 04 50 6A 04 6A 05 8B CE E8 ?? ?? ?? ?? 5E FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_110_0_0 {
	meta:
		name = "__beginthread"
		size = 159
		refs = "000f __errno 001a __invalid_parameter_noinfo 002c __calloc_crt 0039 __getptd 0042 __initptd 0050 __threadstart@4 0060 __imp__CreateThread@24 006f __imp__GetLastError@0 0077 _free 0082 __dosmaperr 0092 __imp__ResumeThread@4"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 56 33 F6 85 DB 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 68 57 68 B8 03 00 00 6A 01 E8 ?? ?? ?? ?? 8B F8 59 59 85 FF 74 3D E8 ?? ?? ?? ?? FF 70 6C 57 E8 ?? ?? ?? ?? 8B 45 10 59 59 57 6A 04 57 68 ?? ?? ?? ?? FF 75 0C 89 5F 54 56 89 47 58 FF 15 ?? ?? ?? ?? 8B F0 89 77 04 85 F6 75 22 FF 15 ?? ?? ?? ?? 8B F0 57 E8 ?? ?? ?? ?? 59 85 F6 74 07 56 E8 ?? ?? ?? ?? 59 83 C8 FF 5F 5E 5B 5D C3 56 FF 15 ?? ?? ?? ?? 83 F8 FF 74 D2 8B C6 EB EB }
	condition:
		$1
}

rule file_110_1_0 {
	meta:
		name = "__callthreadstart"
		size = 65
		refs = "0003 __sehtable$__callthreadstart 0008 __SEH_prolog4 000d __getptd 001d __endthread 002e __XcptFilter 003c __exit"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 FC 00 FF 70 58 FF 50 54 59 E8 ?? ?? ?? ?? 8B 4D EC 8B 01 8B 00 89 45 E4 51 50 E8 ?? ?? ?? ?? 59 59 C3 8B 65 E8 FF 75 E4 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_110_2_0 {
	meta:
		name = "__endthread"
		size = 43
		refs = "0002 __getptd_noexit 0017 __imp__CloseHandle@4 001d __freeptd 0026 __imp__ExitThread@4"
	strings:
		$1 = { 56 E8 ?? ?? ?? ?? 8B F0 85 F6 74 16 83 7E 04 FF 74 09 FF 76 04 FF 15 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 6A 00 FF 15 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_110_3_0 {
	meta:
		name = "__threadstart@4"
		size = 87
		refs = "0004 ___get_flsindex 000a ___crtFlsGetValue 001f ___crtFlsSetValue 002b __imp__GetLastError@0 0032 __imp__ExitThread@4 004d __freefls@4 0052 __callthreadstart"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B D0 59 85 D2 75 21 FF 75 08 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 28 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B 4D 08 51 8B 41 54 89 42 54 8B 41 58 89 42 58 8B 41 04 89 42 04 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "___libm_sse2_expf"
		size = 343
		refs = "0015 _log2e 0044 _c1 0060 _Tl 007f _Tm 0094 _Th 0137 _INF 0140 _ZERO 0152 _ONE"
	strings:
		$1 = { F3 0F 10 C8 F3 0F 10 E0 B8 3B AA B8 46 66 0F 6E F8 66 0F 12 1D ?? ?? ?? ?? 66 0F 7E C1 0F 5A C9 81 E1 FF FF FF 7F 81 E9 00 00 80 31 81 F9 00 00 00 12 0F 83 92 00 00 00 F3 0F 59 C7 F3 0F 2D C0 66 0F 12 35 ?? ?? ?? ?? 66 0F 6E D0 8B C8 C1 E0 03 8B D1 F2 0F 59 D9 D1 F9 83 E0 78 F2 0F 59 B0 ?? ?? ?? ?? 66 0F 12 80 ?? ?? ?? ?? 81 E1 F8 00 00 00 8B C2 C1 FA 06 F3 0F E6 D2 66 0F 12 B9 ?? ?? ?? ?? C1 F8 0E 81 E2 F8 00 00 00 66 0F 6E E8 F2 0F 59 BA ?? ?? ?? ?? F2 0F 5C DA 66 0F 73 F5 34 66 0F 7E E1 8B C1 81 E1 FF FF FF 7F F2 0F 59 F3 81 F9 4F AC AE 42 77 4F 66 0F FE FD F2 0F 58 C6 F2 0F 59 C7 66 0F 5A C0 C3 81 C1 00 00 80 31 81 F9 00 00 80 31 76 76 81 F9 00 00 80 7F 73 40 66 0F 7E E2 81 FA 00 00 00 80 73 0E BA FF FF 7F 7F 66 0F 6E C2 F3 0F 59 C0 C3 BA 00 00 80 00 66 0F 6E C2 F3 0F 59 C0 C3 3D 18 72 B1 42 72 AA 66 0F FE FD F2 0F 58 F0 F2 0F 59 F7 F2 0F 5A C6 C3 81 F9 00 00 80 7F 75 1D 66 0F 7E E0 3D 00 00 80 7F 75 09 F3 0F 10 05 ?? ?? ?? ?? C3 F3 0F 10 05 ?? ?? ?? ?? C3 F3 0F 10 C4 F3 0F 58 C0 C3 F3 0F 10 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_112_4_0 {
	meta:
		name = "__mbspbrk_l"
		size = 202
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0025 _strpbrk 0041 __errno 004c __invalid_parameter_noinfo"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 56 57 FF 75 10 8D 4D EC E8 ?? ?? ?? ?? 8B 5D F0 33 F6 39 73 08 75 14 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 8B F0 E9 84 00 00 00 8B 4D 08 85 C9 74 07 8B 7D 0C 85 FF 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 64 80 39 00 74 56 8A 07 8B D7 84 C0 74 31 8B 75 F0 8A 1A 0F B6 C3 F6 44 30 19 04 74 15 3A 19 75 08 8A 42 01 3A 41 01 74 13 80 7A 01 00 74 0D 42 EB 04 3A 19 74 06 42 80 3A 00 75 D5 8B 5D F0 80 3A 00 75 18 0F B6 01 F6 44 18 19 04 74 06 41 80 39 00 74 08 8A 07 41 80 39 00 75 AC 0F B6 31 F7 DE 1B F6 23 F1 80 7D F8 00 74 07 8B 4D F4 83 61 70 FD 5F 8B C6 5E 5B C9 C3 }
	condition:
		$1
}

rule file_115_7_0 {
	meta:
		name = "?Create@CurrentScheduler@Concurrency@@SAXABVSchedulerPolicy@2@@Z"
		size = 20
		refs = "0007 ?Create@SchedulerBase@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z"
	strings:
		$1 = { 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 8B 10 59 8B C8 5D FF 62 1C }
	condition:
		$1
}

rule file_115_8_0 {
	meta:
		name = "?CreateScheduleGroup@CurrentScheduler@Concurrency@@SAPAVScheduleGroup@2@AAVlocation@2@@Z"
		size = 20
		refs = "0004 ?CurrentScheduler@SchedulerBase@details@Concurrency@@SAPAV123@XZ"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 8B 10 FF 75 08 8B C8 FF 52 20 5D C3 }
	condition:
		$1
}

rule file_115_10_0 {
	meta:
		name = "?Detach@CurrentScheduler@Concurrency@@SAXXZ"
		size = 47
		refs = "0007 ?SafeFastCurrentScheduler@SchedulerBase@details@Concurrency@@SAPAV123@XZ 0012 ?Detach@SchedulerBase@details@Concurrency@@QAEXXZ 001c ??0scheduler_not_attached@Concurrency@@QAE@XZ 0021 __TI2?AVscheduler_not_attached@Concurrency@@ 002a __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 83 EC 0C E8 ?? ?? ?? ?? 85 C0 74 09 8B C8 E8 ?? ?? ?? ?? C9 C3 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_115_12_0 {
	meta:
		name = "?GetNumberOfVirtualProcessors@CurrentScheduler@Concurrency@@SAIXZ"
		size = 20
		refs = "0001 ?SafeFastCurrentScheduler@SchedulerBase@details@Concurrency@@SAPAV123@XZ"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 74 07 8B 10 8B C8 FF 62 08 83 C8 FF C3 }
	condition:
		$1
}

rule file_537_12_0 {
	meta:
		name = "?ScheduleGroupId@Context@Concurrency@@SAIXZ"
		size = 20
		refs = "0001 ?SafeFastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 74 07 8B 10 8B C8 FF 62 08 83 C8 FF C3 }
	condition:
		$1
}

rule file_115_13_0 {
	meta:
		name = "?GetPolicy@CurrentScheduler@Concurrency@@SA?AVSchedulerPolicy@2@XZ"
		size = 28
		refs = "0009 ?CurrentScheduler@SchedulerBase@details@Concurrency@@SAPAV123@XZ"
	strings:
		$1 = { 55 8B EC 51 83 65 FC 00 E8 ?? ?? ?? ?? 8B 10 FF 75 08 8B C8 FF 52 0C 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_115_14_0 {
	meta:
		name = "?Id@CurrentScheduler@Concurrency@@SAIXZ"
		size = 20
		refs = "0001 ?SafeFastCurrentScheduler@SchedulerBase@details@Concurrency@@SAPAV123@XZ"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 74 07 8B 10 8B C8 FF 62 04 83 C8 FF C3 }
	condition:
		$1
}

rule file_537_13_0 {
	meta:
		name = "?VirtualProcessorId@Context@Concurrency@@SAIXZ"
		size = 20
		refs = "0001 ?SafeFastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 74 07 8B 10 8B C8 FF 62 04 83 C8 FF C3 }
	condition:
		$1
}

rule file_115_15_0 {
	meta:
		name = "?IsAvailableLocation@CurrentScheduler@Concurrency@@SA_NABVlocation@2@@Z"
		size = 28
		refs = "0004 ?SafeFastCurrentScheduler@SchedulerBase@details@Concurrency@@SAPAV123@XZ"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 85 C0 74 0C 8B 10 FF 75 08 8B C8 FF 52 30 5D C3 32 C0 5D C3 }
	condition:
		$1
}

rule file_115_16_0 {
	meta:
		name = "?RegisterShutdownEvent@CurrentScheduler@Concurrency@@SAXPAX@Z"
		size = 50
		refs = "0007 ?SafeFastCurrentScheduler@SchedulerBase@details@Concurrency@@SAPAV123@XZ 001f ??0scheduler_not_attached@Concurrency@@QAE@XZ 0024 __TI2?AVscheduler_not_attached@Concurrency@@ 002d __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 83 EC 0C E8 ?? ?? ?? ?? 85 C0 74 0C 8B 10 FF 75 08 8B C8 FF 52 18 C9 C3 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_115_17_0 {
	meta:
		name = "?ScheduleTask@CurrentScheduler@Concurrency@@SAXP6AXPAX@Z0@Z"
		size = 23
		refs = "0004 ?CurrentScheduler@SchedulerBase@details@Concurrency@@SAPAV123@XZ"
		altNames = "?_ScheduleTask@_CurrentScheduler@details@Concurrency@@SAXP6AXPAX@Z0@Z"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? FF 75 0C 8B 10 FF 75 08 8B C8 FF 52 2C 5D C3 }
	condition:
		$1
}

rule file_115_18_0 {
	meta:
		name = "?ScheduleTask@CurrentScheduler@Concurrency@@SAXP6AXPAX@Z0AAVlocation@2@@Z"
		size = 26
		refs = "0004 ?CurrentScheduler@SchedulerBase@details@Concurrency@@SAPAV123@XZ"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? FF 75 10 8B 10 FF 75 0C 8B C8 FF 75 08 FF 52 28 5D C3 }
	condition:
		$1
}

rule file_115_19_0 {
	meta:
		name = "?_Get@_CurrentScheduler@details@Concurrency@@SA?AV_Scheduler@23@XZ"
		size = 17
		refs = "0004 ?CurrentScheduler@SchedulerBase@details@Concurrency@@SAPAV123@XZ"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 8B 4D 08 89 01 8B C1 5D C3 }
	condition:
		$1
}

rule file_537_15_0 {
	meta:
		name = "?_CurrentContext@_Context@details@Concurrency@@SA?AV123@XZ"
		size = 17
		refs = "0004 ?CurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 8B 4D 08 89 01 8B C1 5D C3 }
	condition:
		$1
}

rule file_116_4_0 {
	meta:
		name = "__mbbtype_l"
		size = 115
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? FF 4D 0C 8B 45 F4 74 36 0F B6 55 08 8A 4C 02 19 F6 C1 04 74 05 33 C0 40 EB 39 8B 45 F0 56 8B 80 90 00 00 00 BE 57 01 00 00 66 85 34 50 5E 75 0A F6 C1 03 75 05 83 C8 FF EB 19 33 C0 EB 15 0F B6 4D 08 8A 44 01 19 24 08 0F B6 C0 F7 D8 1B C0 83 E0 03 48 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_117_1_0 {
	meta:
		name = "_system"
		size = 223
		refs = "000b ??_C@_07CFPBBAOO@COMSPEC?$AA@ 001a __dupenv_s 0046 __access_s 0057 ??_C@_02HNHPBPFE@?1c?$AA@ 0066 __errno 007d __spawnve 00af ??_C@_07INNMNHPJ@cmd?4exe?$AA@ 00ba __spawnvpe 00c9 _free 00da __invoke_watson"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 56 33 DB 68 ?? ?? ?? ?? 8D 45 FC 53 50 89 5D FC 8B F3 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 09 83 F8 16 0F 84 A6 00 00 00 8B 4D 08 8B 45 FC 89 45 EC 85 C9 75 18 85 C0 0F 84 84 00 00 00 53 50 E8 ?? ?? ?? ?? F7 D8 59 1B F6 59 46 EB 71 57 C7 45 F0 ?? ?? ?? ?? 89 4D F4 89 5D F8 85 C0 74 45 E8 ?? ?? ?? ?? 8B 38 E8 ?? ?? ?? ?? 89 18 53 8D 45 EC 50 FF 75 EC 53 E8 ?? ?? ?? ?? 83 C4 10 8B F0 E8 ?? ?? ?? ?? 83 FE FF 74 04 89 38 EB 2F 83 38 02 74 0A E8 ?? ?? ?? ?? 83 38 0D 75 20 E8 ?? ?? ?? ?? 89 38 53 8D 45 EC B9 ?? ?? ?? ?? 50 51 53 89 4D EC E8 ?? ?? ?? ?? 83 C4 10 8B F0 5F 8B 45 FC 50 E8 ?? ?? ?? ?? 59 8B C6 5E 5B C9 C3 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_1075_1_0 {
	meta:
		name = "__wsystem"
		size = 223
		refs = "000b ??_C@_1BA@HMCCKBDK@?$AAC?$AAO?$AAM?$AAS?$AAP?$AAE?$AAC?$AA?$AA@ 001a __wdupenv_s 0046 __waccess_s 0057 ??_C@_15JBFELBFC@?$AA?1?$AAc?$AA?$AA@ 0066 __errno 007d __wspawnve 00af ??_C@_1BA@DBKIDAPL@?$AAc?$AAm?$AAd?$AA?4?$AAe?$AAx?$AAe?$AA?$AA@ 00ba __wspawnvpe 00c9 _free 00da __invoke_watson"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 56 33 DB 68 ?? ?? ?? ?? 8D 45 FC 53 50 89 5D FC 8B F3 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 09 83 F8 16 0F 84 A6 00 00 00 8B 4D 08 8B 45 FC 89 45 EC 85 C9 75 18 85 C0 0F 84 84 00 00 00 53 50 E8 ?? ?? ?? ?? F7 D8 59 1B F6 59 46 EB 71 57 C7 45 F0 ?? ?? ?? ?? 89 4D F4 89 5D F8 85 C0 74 45 E8 ?? ?? ?? ?? 8B 38 E8 ?? ?? ?? ?? 89 18 53 8D 45 EC 50 FF 75 EC 53 E8 ?? ?? ?? ?? 83 C4 10 8B F0 E8 ?? ?? ?? ?? 83 FE FF 74 04 89 38 EB 2F 83 38 02 74 0A E8 ?? ?? ?? ?? 83 38 0D 75 20 E8 ?? ?? ?? ?? 89 38 53 8D 45 EC B9 ?? ?? ?? ?? 50 51 53 89 4D EC E8 ?? ?? ?? ?? 83 C4 10 8B F0 5F 8B 45 FC 50 E8 ?? ?? ?? ?? 59 8B C6 5E 5B C9 C3 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_118_0_0 {
	meta:
		name = "___crtsetenv"
		size = 582
		refs = "0013 __errno 001e __invalid_parameter_noinfo 0033 __mbschr 0048 __environ 0059 ___initenv 0061 _copy_environ 007c __wenviron 0083 ___wtomb_environ 00a9 __malloc_crt 00e8 _findenv 00fd _free 0136 __recalloc_crt 01a7 _strlen 01b1 __calloc_crt 01cb _strcpy_s 01ef __imp__SetEnvironmentVariableA@8 0241 __invoke_watson"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 08 83 65 F8 00 57 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 74 53 8B 18 56 85 DB 74 5C 6A 3D 53 E8 ?? ?? ?? ?? 8B F0 59 59 89 75 F4 85 F6 74 49 3B DE 74 45 8B 3D ?? ?? ?? ?? 33 C0 38 46 01 0F 94 C0 89 45 FC 3B 3D ?? ?? ?? ?? 75 12 57 E8 ?? ?? ?? ?? 8B F8 8B 45 FC 59 89 3D ?? ?? ?? ?? 85 FF 75 6C 39 7D 0C 74 24 39 3D ?? ?? ?? ?? 74 1C E8 ?? ?? ?? ?? 85 C0 74 4C E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 5E 5B 5F C9 C3 85 C0 0F 85 8C 01 00 00 6A 04 E8 ?? ?? ?? ?? 59 A3 ?? ?? ?? ?? 85 C0 74 DF 83 20 00 83 3D ?? ?? ?? ?? 00 75 14 6A 04 E8 ?? ?? ?? ?? 59 A3 ?? ?? ?? ?? 85 C0 74 C2 83 20 00 8B 3D ?? ?? ?? ?? 85 FF 74 B5 8B C6 2B C3 50 53 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 78 57 83 3F 00 74 52 FF 34 B7 E8 ?? ?? ?? ?? 83 7D FC 00 59 75 16 89 1C B7 8B 7D 08 83 27 00 E9 87 00 00 00 8B 44 B7 04 89 04 B7 46 83 3C B7 00 75 F2 81 FE FF FF FF 3F 73 6E 6A 04 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 08 83 C4 0C 85 C0 74 59 A3 ?? ?? ?? ?? EB 52 83 7D FC 00 0F 85 D0 00 00 00 85 F6 79 02 F7 DE 8D 46 02 3B C6 0F 8C 30 FF FF FF 3D FF FF FF 3F 0F 83 25 FF FF FF 50 6A 04 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 0C FF FF FF 8B 7D 08 83 64 B0 04 00 89 1C B0 83 27 00 EB AA 8B 7D 08 83 7D 0C 00 74 6A 6A 01 53 E8 ?? ?? ?? ?? 59 83 C0 02 50 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 74 50 53 53 E8 ?? ?? ?? ?? 59 83 C0 02 50 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 63 8B CE 2B CB 03 4D F4 88 01 8B 45 FC 41 F7 D8 1B C0 F7 D0 23 C1 50 56 FF 15 ?? ?? ?? ?? 85 C0 75 0F 83 4D F8 FF E8 ?? ?? ?? ?? C7 00 2A 00 00 00 56 E8 ?? ?? ?? ?? 59 83 7D FC 00 74 0A 53 E8 ?? ?? ?? ?? 83 27 00 59 8B 45 F8 E9 74 FE FF FF 53 E8 ?? ?? ?? ?? 8B 7D 08 59 83 27 00 33 C0 E9 60 FE FF FF 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_118_2_0 {
	meta:
		name = "_copy_environ"
		size = 96
		refs = "0025 __calloc_crt 0036 __amsg_exit 0045 __strdup"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 33 C9 8B C6 85 F6 74 4E 39 0E 74 09 8D 40 04 41 83 38 00 75 F7 53 57 8D 41 01 6A 04 50 E8 ?? ?? ?? ?? 8B F8 59 59 8B DF 85 FF 75 08 6A 09 E8 ?? ?? ?? ?? 59 8B 06 85 C0 74 15 2B F7 50 E8 ?? ?? ?? ?? 89 07 83 C7 04 59 8B 04 3E 85 C0 75 ED 83 27 00 5F 8B C3 5B 5E 5D C3 }
	condition:
		$1
}

rule file_1024_2_0 {
	meta:
		name = "_copy_environ"
		size = 96
		refs = "0025 __calloc_crt 0036 __amsg_exit 0045 __wcsdup"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 33 C9 8B C6 85 F6 74 4E 39 0E 74 09 8D 40 04 41 83 38 00 75 F7 53 57 8D 41 01 6A 04 50 E8 ?? ?? ?? ?? 8B F8 59 59 8B DF 85 FF 75 08 6A 09 E8 ?? ?? ?? ?? 59 8B 06 85 C0 74 15 2B F7 50 E8 ?? ?? ?? ?? 89 07 83 C7 04 59 8B 04 3E 85 C0 75 ED 83 27 00 5F 8B C3 5B 5E 5D C3 }
	condition:
		$1
}

rule file_118_3_0 {
	meta:
		name = "_findenv"
		size = 91
		refs = "0005 __environ 001c __mbsnbicoll"
	strings:
		$1 = { 55 8B EC 8B 0D ?? ?? ?? ?? 56 8B F1 57 8B 06 85 C0 74 30 8B 7D 0C 57 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 0D 8B 06 8A 04 07 3C 3D 74 20 84 C0 74 1C 83 C6 04 8B 06 85 C0 75 D9 8B 0D ?? ?? ?? ?? 2B F1 C1 FE 02 F7 DE 5F 8B C6 5E 5D C3 2B 35 ?? ?? ?? ?? C1 FE 02 EB EF }
	condition:
		$1
}

rule file_119_0_0 {
	meta:
		name = "__fstat64"
		size = 916
		refs = "0003 __sehtable$__fstat64 0008 __SEH_prolog4_GS 0026 ___doserrno 002d __errno 0041 _memset 0065 __ioinit 007b __nhandle 009b ___pioinfo 00b1 ___lock_fhandle 00f6 __imp__GetFileType@4 011a __imp__GetLastError@0 0120 __dosmaperr 017f __imp__PeekNamedPipe@24 01c3 __imp__GetFileInformationByHandle@8 0207 __imp__FileTimeToLocalFileTime@8 021d __imp__FileTimeToSystemTime@8 024a ___loctotime64_t 036e __unlock_fhandle 0387 __invalid_parameter_noinfo 038f __SEH_epilog4_GS"
	strings:
		$1 = { 6A 6C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 5D 08 89 5D 84 8B 7D 0C 33 F6 89 75 9C 33 C0 85 FF 0F 95 C0 85 C0 75 17 E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 4A 03 00 00 6A 38 56 57 E8 ?? ?? ?? ?? 83 C4 0C 83 FB FE 75 17 E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E9 27 03 00 00 E8 ?? ?? ?? ?? 85 C0 0F 88 1A 03 00 00 85 DB 0F 88 FB 02 00 00 3B 1D ?? ?? ?? ?? 0F 83 EF 02 00 00 8B C3 C1 F8 05 89 45 94 8B CB 83 E1 1F C1 E1 06 89 4D 98 8B 04 85 ?? ?? ?? ?? 0F BE 44 08 04 33 C9 41 23 C1 0F 84 C5 02 00 00 53 E8 ?? ?? ?? ?? 59 89 75 FC 8B 45 94 8B 0C 85 ?? ?? ?? ?? 8B 45 98 F6 44 01 04 01 75 24 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 CE FF 89 75 9C C7 45 FC FE FF FF FF E8 82 02 00 00 8B C6 E9 9D 02 00 00 FF 34 01 FF 15 ?? ?? ?? ?? 25 FF 7F FF FF 33 D2 42 3B C2 0F 84 97 00 00 00 83 F8 02 74 1D 83 F8 03 74 13 85 C0 74 B5 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 EB B1 83 F8 02 75 07 B9 00 20 00 00 EB 05 B9 00 10 00 00 66 89 4F 06 89 1F 89 5F 10 66 89 57 08 33 C9 66 89 4F 04 89 4F 0A 89 77 30 89 77 34 89 77 28 89 77 2C 89 77 20 89 77 24 83 F8 02 74 31 56 8D 45 90 50 56 56 56 8B 45 94 8B 04 85 ?? ?? ?? ?? 8B 4D 98 FF 34 08 FF 15 ?? ?? ?? ?? 85 C0 74 0F 8B 45 90 99 89 47 18 89 57 1C E9 48 FF FF FF 89 77 18 89 77 1C E9 3D FF FF FF 33 C0 89 47 04 89 47 0A 66 89 57 08 8D 45 A0 50 8B 45 94 8B 04 85 ?? ?? ?? ?? 8B 4D 98 FF 34 08 FF 15 ?? ?? ?? ?? 85 C0 0F 84 49 FF FF FF 0F B7 47 06 F6 45 A0 01 74 07 0D 24 01 00 00 EB 05 0D B6 01 00 00 66 89 47 06 83 7D B4 00 75 0E 83 7D B8 00 75 08 89 77 28 89 77 2C EB 5A 8D 45 88 50 8D 45 B4 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 C5 FE FF FF 8D 45 D4 50 8D 45 88 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 AF FE FF FF 6A FF 0F B7 45 E0 50 0F B7 45 DE 50 0F B7 45 DC 50 0F B7 45 DA 50 0F B7 45 D6 50 0F B7 45 D4 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 28 89 57 2C 83 7D AC 00 75 14 83 7D B0 00 75 0E 8B 47 28 89 47 20 8B 47 2C 89 47 24 EB 5A 8D 45 88 50 8D 45 AC 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 51 FE FF FF 8D 45 D4 50 8D 45 88 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 3B FE FF FF 6A FF 0F B7 45 E0 50 0F B7 45 DE 50 0F B7 45 DC 50 0F B7 45 DA 50 0F B7 45 D6 50 0F B7 45 D4 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 20 89 57 24 83 7D A4 00 75 14 83 7D A8 00 75 0E 8B 47 28 89 47 30 8B 47 2C 89 47 34 EB 5A 8D 45 88 50 8D 45 A4 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 DD FD FF FF 8D 45 D4 50 8D 45 88 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 C7 FD FF FF 6A FF 0F B7 45 E0 50 0F B7 45 DE 50 0F B7 45 DC 50 0F B7 45 DA 50 0F B7 45 D6 50 0F B7 45 D4 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 30 89 57 34 33 C0 8B 4D C0 03 45 C4 13 CE 89 47 18 89 4F 1C 0F B7 47 06 0D 00 80 00 00 66 89 47 06 89 37 89 77 10 E9 78 FD FF FF 8B 75 9C 8B 5D 84 53 E8 ?? ?? ?? ?? 59 C3 E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_120_3_0 {
	meta:
		name = "__mbsnbcpy_s_l"
		size = 461
		refs = "003c __errno 0046 __invalid_parameter_noinfo 0058 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 006f _strncpy_s 00ea __ismbblead_l"
	strings:
		$1 = { 55 8B EC 83 EC 14 56 8B 75 08 57 8B 7D 14 85 FF 75 0D 85 F6 75 0D 39 75 0C 75 20 33 C0 EB 2D 85 F6 74 18 83 7D 0C 00 76 12 85 FF 75 05 C6 06 00 EB E9 83 7D 10 00 75 18 C6 06 00 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 5F 5E C9 C3 53 FF 75 18 8D 4D EC E8 ?? ?? ?? ?? 8B 45 F0 33 DB 39 58 08 75 17 57 FF 75 10 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 10 8B D8 E9 3B 01 00 00 8B 45 0C 8B 55 10 8B CE 89 45 14 83 FF FF 75 15 8A 02 88 01 41 42 84 C0 8B 45 14 74 25 48 89 45 14 75 ED EB 1D 8A 02 88 01 41 42 84 C0 8B 45 14 74 09 48 89 45 14 74 03 4F 75 EA 85 FF 75 03 88 19 41 85 C0 0F 85 AD 00 00 00 38 1A 74 05 83 FF 01 75 43 8D 51 FF 8B CA 89 55 FC 89 4D 14 3B D6 72 25 8B DA 8D 45 EC 50 0F B6 03 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 05 4B 3B DE 73 E8 8B 55 FC 89 5D 14 8B 4D 14 33 DB 8B C2 2B C1 A8 01 74 07 88 1A E9 9B 00 00 00 83 FF FF 75 49 8B 4D 0C 83 F9 01 76 38 8D 51 FE 03 D6 89 55 14 8B FA 3B D6 72 1E 8D 45 EC 50 0F B6 07 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 05 4F 3B FE 73 E8 8B 4D 0C 8B 55 14 8B C2 2B C7 A8 01 74 04 88 1A EB 04 88 5C 0E FF 6A 50 5B EB 57 88 1E E8 ?? ?? ?? ?? 6A 22 5B 89 18 E8 ?? ?? ?? ?? EB 44 8B C1 2B C6 83 F8 02 7C 3B 83 C1 FE 89 4D 14 8B F9 3B CE 72 1B 8D 45 EC 50 0F B6 07 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 05 4F 3B FE 73 E8 8B 4D 14 8B C1 2B C7 A8 01 74 0C 88 19 E8 ?? ?? ?? ?? 6A 2A 5B 89 18 80 7D F8 00 74 07 8B 4D F4 83 61 70 FD 8B C3 5B E9 7F FE FF FF }
	condition:
		$1
}

rule file_125_0_0 {
	meta:
		name = "__87except"
		size = 265
		refs = "001c ___security_cookie 0070 __handle_exc 00bb __raise_exc 00cf __ctrlfp 00dc __matherr_flag 00e5 __matherr 00f1 __set_errno_from_matherr 00fe @__security_check_cookie@4"
	strings:
		$1 = { 53 8B DC 51 51 83 E4 F0 83 C4 04 55 8B 6B 04 89 6C 24 04 8B EC 81 EC 88 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 43 10 56 8B 73 0C 0F B7 08 8B 06 57 89 8D 7C FF FF FF 48 74 2B 48 74 24 48 74 1D 48 74 16 48 74 1F 48 48 74 07 48 75 7A 6A 10 EB 16 C7 06 01 00 00 00 EB 6E 6A 12 EB 0A 6A 11 EB 06 6A 04 EB 02 6A 08 5F 51 8D 46 18 50 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 47 8B 4B 08 83 F9 10 74 10 83 F9 16 74 0B 83 F9 1D 74 06 83 65 C0 FE EB 12 8B 45 C0 DD 46 10 83 E0 E3 DD 5D B0 83 C8 03 89 45 C0 8D 46 18 50 8D 46 08 50 51 57 8D 85 7C FF FF FF 50 8D 45 80 50 E8 ?? ?? ?? ?? 83 C4 18 8B 8D 7C FF FF FF 68 FF FF 00 00 51 E8 ?? ?? ?? ?? 83 3E 08 59 59 74 14 83 3D ?? ?? ?? ?? 00 75 0B 56 E8 ?? ?? ?? ?? 59 85 C0 75 08 FF 36 E8 ?? ?? ?? ?? 59 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D 8B E3 5B C3 }
	condition:
		$1
}

rule file_126_3_0 {
	meta:
		name = "__strxfrm_l"
		size = 276
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0033 __errno 003e __invalid_parameter_noinfo 0068 _strncpy 0070 _strlen 0095 ___crtLCMapStringA"
	strings:
		$1 = { 55 8B EC 83 EC 10 8D 4D F0 53 56 57 FF 75 14 E8 ?? ?? ?? ?? 8B 5D 10 BE FF FF FF 7F 3B DE 77 12 8B 7D 08 85 FF 75 04 85 DB 75 07 8B 45 0C 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 B9 00 00 00 85 FF 74 07 85 DB 74 03 C6 07 00 8B 4D F0 8B 91 A4 00 00 00 85 D2 75 1F 39 51 08 75 1A 53 50 57 E8 ?? ?? ?? ?? FF 75 0C E8 ?? ?? ?? ?? 83 C4 10 8B F0 E9 82 00 00 00 6A 01 FF 71 08 6A 00 6A 00 6A FF 50 68 00 04 00 00 52 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 24 89 45 10 85 C0 74 4C 3B C3 76 1E 85 FF 74 15 85 DB 74 11 C6 07 00 E8 ?? ?? ?? ?? C7 00 22 00 00 00 8B 45 10 8D 70 FF EB 3B 8B 45 F0 6A 01 FF 70 08 53 57 6A FF FF 75 0C 68 00 04 00 00 FF B0 A4 00 00 00 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 24 85 C0 75 0D E8 ?? ?? ?? ?? C7 00 2A 00 00 00 EB 04 8B 75 10 4E 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD 5F 8B C6 5E 5B C9 C3 }
	condition:
		$1
}

rule file_127_1_0 {
	meta:
		name = "__wfindfirst32i64"
		size = 297
		refs = "000a ___security_cookie 001f __errno 002a __invalid_parameter_noinfo 0049 __imp__FindFirstFileExW@24 0056 __imp__GetLastError@0 0087 @__security_check_cookie@4 00c0 ___timet_from_ft 010c _wcscpy_s 0124 __invoke_watson"
	strings:
		$1 = { 55 8B EC 81 EC 54 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 0C 85 F6 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 4D 85 C0 74 E7 53 57 33 DB 53 53 53 8D 8D AC FD FF FF 51 53 50 FF 15 ?? ?? ?? ?? 8B F8 83 FF FF 75 4F FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 34 83 F8 08 74 22 83 F8 12 74 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 5F 5B 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? C9 C3 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB E1 E8 ?? ?? ?? ?? 89 30 EB D8 8B 85 AC FD FF FF 83 C0 80 F7 D8 1B C0 23 85 AC FD FF FF 89 06 8D 85 B0 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 04 8D 85 B8 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 C0 FD FF FF 50 E8 ?? ?? ?? ?? 8B 8D C8 FD FF FF 89 46 0C 33 C0 03 85 CC FD FF FF 89 46 10 8D 85 D8 FD FF FF 50 8D 46 18 13 CB 68 04 01 00 00 50 89 4E 14 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 07 8B C7 E9 60 FF FF FF 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_127_2_0 {
	meta:
		name = "__wfindnext32i64"
		size = 285
		refs = "000a ___security_cookie 0023 __errno 002e __invalid_parameter_noinfo 003c @__security_check_cookie@4 0050 __imp__FindNextFileW@8 005a __imp__GetLastError@0 00b4 ___timet_from_ft 0103 _wcscpy_s 0118 __invoke_watson"
	strings:
		$1 = { 55 8B EC 81 EC 54 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 4D 08 56 8B 75 0C 57 83 CF FF 3B CF 75 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8B C7 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 85 F6 74 DC 8D 85 AC FD FF FF 50 51 FF 15 ?? ?? ?? ?? 85 C0 75 3F FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 24 83 F8 08 74 12 83 F8 12 74 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB B1 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB A4 E8 ?? ?? ?? ?? 89 30 EB 9B 8B 85 AC FD FF FF 83 C0 80 F7 D8 1B C0 23 85 AC FD FF FF 89 06 8D 85 B0 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 04 8D 85 B8 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 C0 FD FF FF 50 E8 ?? ?? ?? ?? 8B 8D C8 FD FF FF 89 46 0C 33 C0 03 85 CC FD FF FF 6A 00 5F 89 46 10 8D 85 D8 FD FF FF 50 8D 46 18 13 CF 68 04 01 00 00 50 89 4E 14 E8 ?? ?? ?? ?? 83 C4 18 85 C0 0F 84 22 FF FF FF 57 57 57 57 57 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_128_0_0 {
	meta:
		name = "__chdrive"
		size = 124
		refs = "0007 ___security_cookie 0037 __imp__SetCurrentDirectoryW@4 0045 __imp__GetLastError@0 004b __dosmaperr 0053 ___doserrno 005e __errno 0069 __invalid_parameter_noinfo 0076 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 83 F8 01 7C 3A 83 F8 1A 7F 35 83 C0 40 66 89 45 F4 6A 3A 58 66 89 45 F6 33 C0 66 89 45 F8 8D 45 F4 50 FF 15 ?? ?? ?? ?? 85 C0 74 04 33 C0 EB 2D FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 EB 1B E8 ?? ?? ?? ?? C7 00 0F 00 00 00 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_128_1_0 {
	meta:
		name = "__getdrive"
		size = 205
		refs = "000a ___security_cookie 002e __imp__GetCurrentDirectoryW@8 0049 __calloc_crt 0056 __errno 00b7 _free 00c7 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 18 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 57 8D B5 F0 FD FF FF 8B C6 50 33 DB 68 05 01 00 00 89 9D EC FD FF FF FF 15 ?? ?? ?? ?? 8B F8 81 FF 04 01 00 00 7E 45 8D 47 01 6A 02 50 89 85 E8 FD FF FF E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 75 0F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 8B FB EB 1D C7 85 EC FD FF FF 01 00 00 00 85 FF 74 2F 56 FF B5 E8 FD FF FF FF 15 ?? ?? ?? ?? 8B F8 85 FF 74 1C 66 83 7E 02 3A 75 20 0F B7 06 83 F8 61 72 08 83 F8 7A 77 03 83 E8 20 8D 58 C0 EB 0B E8 ?? ?? ?? ?? C7 00 0C 00 00 00 83 BD EC FD FF FF 00 74 07 56 E8 ?? ?? ?? ?? 59 8B 4D FC 5F 5E 8B C3 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_130_3_0 {
	meta:
		name = "?__crtLCMapStringA_stat@@YAHPAUlocaleinfo_struct@@PB_WKPBDHPADHHH@Z"
		size = 489
		refs = "0006 ___security_cookie 006b __imp__MultiByteToWideChar@24 009f __alloca_probe_16 00b3 _malloc 00fb ___crtLCMapStringEx 01c1 __imp__WideCharToMultiByte@32 01c9 __freea 01e3 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 51 51 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 8B 75 18 57 85 F6 7E 21 8B 45 14 8B CE 49 80 38 00 74 08 40 85 C9 75 F5 83 C9 FF 8B C6 2B C1 48 3B C6 8D 70 01 7C 02 8B F0 8B 4D 24 33 FF 85 C9 75 0D 8B 45 08 8B 00 8B 40 04 89 45 24 8B C8 33 C0 39 45 28 6A 00 0F 95 C0 6A 00 56 FF 75 14 8D 04 C5 01 00 00 00 50 51 FF 15 ?? ?? ?? ?? 8B C8 89 4D F8 85 C9 75 07 33 C0 E9 58 01 00 00 7E 4B 6A E0 33 D2 58 F7 F1 83 F8 02 72 3F 8D 0C 4D 08 00 00 00 81 F9 00 04 00 00 77 15 8B C1 E8 ?? ?? ?? ?? 8B DC 85 DB 74 1E C7 03 CC CC 00 00 EB 13 51 E8 ?? ?? ?? ?? 8B D8 59 85 DB 74 09 C7 03 DD DD 00 00 83 C3 08 8B 4D F8 EB 02 33 DB 85 DB 74 A6 51 53 56 FF 75 14 6A 01 FF 75 24 FF 15 ?? ?? ?? ?? 85 C0 0F 84 E3 00 00 00 8B 75 F8 6A 00 6A 00 56 53 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 8B F8 83 C4 18 85 FF 0F 84 C2 00 00 00 B9 00 04 00 00 85 4D 10 74 2C 8B 4D 20 85 C9 0F 84 AD 00 00 00 3B F9 0F 8F A5 00 00 00 51 FF 75 1C 56 53 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 18 E9 8C 00 00 00 85 FF 7E 42 6A E0 33 D2 58 F7 F7 83 F8 02 72 36 8D 04 7D 08 00 00 00 3B C1 77 13 E8 ?? ?? ?? ?? 8B F4 85 F6 74 66 C7 06 CC CC 00 00 EB 13 50 E8 ?? ?? ?? ?? 8B F0 59 85 F6 74 51 C7 06 DD DD 00 00 83 C6 08 EB 02 33 F6 85 F6 74 40 57 56 FF 75 F8 53 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 21 33 C0 50 50 39 45 20 75 04 50 50 EB 06 FF 75 20 FF 75 1C 57 56 50 FF 75 24 FF 15 ?? ?? ?? ?? 8B F8 56 E8 ?? ?? ?? ?? 59 53 E8 ?? ?? ?? ?? 59 8B C7 8D 65 EC 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_130_6_0 {
	meta:
		name = "___crtLCMapStringA"
		size = 68
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002e ?__crtLCMapStringA_stat@@YAHPAUlocaleinfo_struct@@PB_WKPBDHPADHHH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 08 8D 4D F0 E8 ?? ?? ?? ?? FF 75 28 8D 45 F0 FF 75 24 FF 75 20 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C 50 E8 ?? ?? ?? ?? 83 C4 24 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_131_4_0 {
	meta:
		name = "__mbsnicmp_l"
		size = 405
		refs = "001d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0033 __strnicmp 0053 __errno 005e __invalid_parameter_noinfo"
	strings:
		$1 = { 55 8B EC 83 EC 18 57 8B 7D 10 85 FF 75 07 33 C0 E9 7D 01 00 00 53 FF 75 14 8D 4D E8 E8 ?? ?? ?? ?? 8B 4D EC 33 D2 39 51 08 75 16 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 8B D0 E9 41 01 00 00 8B 5D 08 85 DB 74 0A 8B 45 0C 89 45 FC 85 C0 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? BA FF FF FF 7F E9 16 01 00 00 56 0F B6 33 89 75 10 0F B6 45 10 4F 43 F6 44 08 19 04 74 42 8A 03 84 C0 75 05 89 55 10 EB 50 C1 E6 08 0F B6 C0 66 0B F0 0F B7 C6 66 8B F0 43 89 45 10 66 3B 71 0C 72 0C 66 3B 71 0E 77 06 66 03 71 10 EB 2F 66 3B 71 12 72 29 66 3B 71 14 77 23 66 03 71 16 EB 1D 66 8B 75 10 0F B7 C6 F6 44 08 19 10 74 0F 0F B6 84 08 19 01 00 00 89 45 10 66 8B 75 10 8B 45 FC FF 45 FC 0F B6 00 89 45 F8 89 45 10 0F B6 C0 F6 44 08 19 04 74 49 8B 45 FC 8A 00 84 C0 75 05 89 55 10 EB 5D C1 65 F8 08 0F B6 C0 66 09 45 F8 8B 45 F8 FF 45 FC 0F B7 C0 89 45 10 66 3B 41 0C 72 0C 66 3B 41 0E 77 06 66 03 41 10 EB 38 66 3B 41 12 72 32 66 3B 41 14 77 2C 66 03 41 16 EB 26 66 8B 45 10 0F B7 D0 6A 00 F6 44 0A 19 10 89 55 10 5A 74 12 8B 45 10 0F B6 84 08 19 01 00 00 89 45 10 66 8B 45 10 66 3B C6 75 0F 66 85 F6 74 10 85 FF 0F 85 F4 FE FF FF EB 06 1B D2 83 E2 02 4A 5E 80 7D F4 00 5B 74 07 8B 4D F0 83 61 70 FD 8B C2 5F C9 C3 }
	condition:
		$1
}

rule file_132_4_0 {
	meta:
		name = "__ismbcalpha_l"
		size = 164
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 004d ___crtGetStringTypeA"
	strings:
		$1 = { 55 8B EC 83 EC 14 8D 4D EC 56 FF 75 0C E8 ?? ?? ?? ?? 8B 4D 08 81 F9 FF 00 00 00 76 4D 33 C0 89 45 FC 8B C1 C1 E8 08 88 45 08 8B 45 F0 88 4D 09 83 78 08 00 74 55 33 F6 46 56 FF 70 04 8D 45 FC 50 6A 02 8D 45 08 50 8D 45 EC 56 50 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 74 33 66 83 7D FE 00 75 2C F7 45 FC 03 01 00 00 75 2A EB 21 8B 45 EC 0F B6 C9 8B 80 90 00 00 00 BA 03 01 00 00 66 85 14 48 75 0E 8B 45 F0 F6 44 01 19 01 75 04 33 F6 EB 03 33 F6 46 80 7D F8 00 74 07 8B 4D F4 83 61 70 FD 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_133_3_0 {
	meta:
		name = "__strcoll_l"
		size = 142
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0021 __errno 002c __invalid_parameter_noinfo 0042 _strcmp 005e ___crtCompareStringA"
	strings:
		$1 = { 55 8B EC 83 EC 10 8D 4D F0 56 FF 75 10 E8 ?? ?? ?? ?? 8B 4D 08 85 C9 74 07 8B 45 0C 85 C0 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 42 8B 55 F0 8B B2 A4 00 00 00 85 F6 75 0B 50 51 E8 ?? ?? ?? ?? 59 59 EB 34 FF 72 08 6A FF 50 6A FF 51 68 00 10 00 00 8D 45 F0 56 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 B8 FF FF FF 7F EB 03 83 C0 FE 80 7D FC 00 5E 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_134_2_0 {
	meta:
		name = "?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
		size = 718
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0038 __errno 0043 __invalid_parameter_noinfo 0061 _iswctype 00cb __wchartodigit 0139 __aulldvrm 0202 __allmul"
	strings:
		$1 = { 55 8B EC 83 EC 34 8D 4D CC FF 75 08 E8 ?? ?? ?? ?? 8B 45 10 8B 4D 0C 85 C0 74 02 89 08 53 56 33 D2 57 85 C9 74 11 8B 45 14 85 C0 74 1F 83 F8 02 7C 05 83 F8 24 7E 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 68 02 00 00 0F B7 19 8B FA 6A 08 53 89 55 FC 89 7D EC 89 5D F4 8D 71 02 E8 ?? ?? ?? ?? 59 59 85 C0 74 1D 0F B7 3E 6A 08 57 89 7D F4 83 C6 02 E8 ?? ?? ?? ?? 59 59 85 C0 75 E9 8B 7D EC 8B 5D F4 8B 45 18 66 83 FB 2D 75 05 83 C8 02 EB 06 66 83 FB 2B 75 09 0F B7 1E 83 C6 02 89 5D F4 89 45 F8 8B 45 14 85 C0 0F 88 F5 01 00 00 83 F8 01 0F 84 EC 01 00 00 83 F8 24 0F 8F E3 01 00 00 85 C0 75 30 53 E8 ?? ?? ?? ?? 59 85 C0 74 08 6A 0A 58 89 45 14 EB 4D 0F B7 06 6A 78 59 66 3B C1 74 0C 6A 58 59 66 3B C1 74 04 6A 08 EB E3 6A 10 58 89 45 14 83 F8 10 75 2B 53 E8 ?? ?? ?? ?? 59 85 C0 75 1D 0F B7 06 6A 78 59 66 3B C1 74 08 6A 58 59 66 3B C1 75 0A 0F B7 5E 02 89 5D F4 83 C6 04 8B 45 14 99 8B CA 51 50 6A FF 6A FF 89 45 DC 89 4D E0 E8 ?? ?? ?? ?? 89 5D E8 8B 5D F4 89 4D E4 89 45 F0 89 55 EC 53 E8 ?? ?? ?? ?? 59 8B C8 89 45 F4 83 F9 FF 75 57 6A 41 58 66 3B C3 77 06 66 83 FB 5A 76 32 6A 19 8D 43 9F 59 66 3B C1 76 2A 8B 45 FC 8B 5D F8 8B 4D 10 83 EE 02 F6 C3 08 0F 85 93 00 00 00 85 C9 74 03 8B 75 0C 33 D2 8B C2 8B FA E9 F5 00 00 00 6A 19 59 8D 43 9F 66 3B C1 0F B7 C3 77 03 83 E8 20 8D 48 C9 89 4D F4 8B 5D F8 8B 45 FC 3B 4D 14 73 BD 83 CB 08 89 5D F8 3B 7D EC 72 2F 8B 55 F0 77 04 3B C2 72 26 3B C2 75 13 3B 7D EC 75 0E 33 D2 3B 55 E8 72 16 77 05 3B 4D E4 76 0F 8B 4D 10 83 CB 04 89 5D F8 85 C9 74 88 EB 1A 57 50 FF 75 E0 FF 75 DC E8 ?? ?? ?? ?? 03 45 F4 6A 00 89 45 FC 8B FA 58 13 F8 0F B7 1E 83 C6 02 E9 2E FF FF FF F6 C3 04 75 33 F6 C3 01 75 65 8B CB 83 E1 02 74 12 81 FF 00 00 00 80 77 1F 72 08 33 D2 3B C2 77 17 EB 02 33 D2 85 C9 75 41 81 FF FF FF FF 7F 72 39 77 05 83 F8 FF 76 32 E8 ?? ?? ?? ?? C7 00 22 00 00 00 F6 C3 01 74 08 83 C8 FF 83 CF FF EB 22 F6 C3 02 74 0B 33 D2 8B C2 BF 00 00 00 80 EB 14 83 C8 FF BF FF FF FF 7F EB 08 8B 45 FC EB 05 8B 45 FC 33 D2 8B 4D 10 85 C9 74 02 89 31 F6 C3 02 74 1A F7 D8 13 FA F7 DF EB 12 8B 45 10 85 C0 74 05 8B 4D 0C 89 08 33 C9 8B C1 8B F9 80 7D D8 00 74 07 8B 4D D4 83 61 70 FD 8B D7 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_135_0_0 {
	meta:
		name = "___sse2_logf4"
		size = 272
		refs = "0014 _static_const_table"
	strings:
		$1 = { 8B C4 83 EC 60 83 E4 F0 89 44 24 24 66 0F 6F E0 66 0F 6F 15 ?? ?? ?? ?? 0F 28 F0 66 0F 6F 0D ?? ?? ?? ?? 66 0F 6F 1D ?? ?? ?? ?? 66 0F DB 25 ?? ?? ?? ?? 66 0F 66 D8 66 0F FE D4 66 0F DB 15 ?? ?? ?? ?? 66 0F EF CA 66 0F 72 E2 17 66 0F EB E1 66 0F 6F C8 66 0F 72 E1 17 66 0F 66 05 ?? ?? ?? ?? 66 0F FA 0D ?? ?? ?? ?? 66 0F DB D8 66 0F 6F C1 66 0F FE C2 0F 28 D4 0F 28 0D ?? ?? ?? ?? 0F 5C 15 ?? ?? ?? ?? 66 0F D7 D3 0F 28 1D ?? ?? ?? ?? 0F 58 CA 0F 28 25 ?? ?? ?? ?? 0F 28 EA 0F 5E D1 0F 5B C0 0F 28 CA 0F 59 D2 0F 28 FA 0F 59 D2 0F 59 DA 0F 59 E2 0F 58 1D ?? ?? ?? ?? 0F 59 DF 0F 58 DC 0F 59 05 ?? ?? ?? ?? 0F 28 D5 0F 5C EB 0F 59 E9 0F 5C EA 0F 5C C5 81 FA FF FF 00 00 75 02 EB 1E BA 0C 00 00 00 0F 29 34 24 D9 ED D9 04 14 D9 F1 D9 1C 14 83 EA 04 79 F1 0F 28 04 24 EB E0 8B 64 24 24 C3 8D A4 24 00 00 00 00 8D 49 00 }
	condition:
		$1
}

rule file_137_0_0 {
	meta:
		name = "_strchr"
		size = 299
		refs = "0002 ___isa_available"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 01 72 5F 0F B6 44 24 08 8B D0 C1 E0 08 0B D0 66 0F 6E DA F2 0F 70 DB 00 0F 16 DB 8B 54 24 04 B9 0F 00 00 00 83 C8 FF 23 CA D3 E0 2B D1 F3 0F 6F 0A 66 0F EF D2 66 0F 74 D1 66 0F 74 CB 66 0F EB D1 66 0F D7 CA 23 C8 75 08 83 C8 FF 83 C2 10 EB DC 0F BC C1 03 C2 66 0F 7E DA 33 C9 3A 10 0F 45 C1 C3 33 C0 8A 44 24 08 53 8B D8 C1 E0 08 8B 54 24 08 F7 C2 03 00 00 00 74 15 8A 0A 83 C2 01 3A CB 74 59 84 C9 74 51 F7 C2 03 00 00 00 75 EB 0B D8 57 8B C3 C1 E3 10 56 0B D8 8B 0A BF FF FE FE 7E 8B C1 8B F7 33 CB 03 F0 03 F9 83 F1 FF 83 F0 FF 33 CF 33 C6 83 C2 04 81 E1 00 01 01 81 75 21 25 00 01 01 81 74 D3 25 00 01 01 01 75 08 81 E6 00 00 00 80 75 C4 5E 5F 5B 33 C0 C3 8D 42 FF 5B C3 8B 42 FC 3A C3 74 36 84 C0 74 EA 3A E3 74 27 84 E4 74 E2 C1 E8 10 3A C3 74 15 84 C0 74 D7 3A E3 74 06 84 E4 74 CF EB 91 5E 5F 8D 42 FF 5B C3 8D 42 FE 5E 5F 5B C3 8D 42 FD 5E 5F 5B C3 8D 42 FC 5E 5F 5B C3 }
	condition:
		$1
}

rule file_138_0_0 {
	meta:
		name = "__ftbuf"
		size = 49
		refs = "0018 __flush"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 74 26 56 8B 75 0C F7 46 0C 00 10 00 00 74 18 56 E8 ?? ?? ?? ?? 81 66 0C FF EE FF FF 33 C0 59 89 46 18 89 06 89 46 08 5E 5D C3 }
	condition:
		$1
}

rule file_138_1_0 {
	meta:
		name = "__stbuf"
		size = 166
		refs = "0009 __fileno 000f __isatty 001f ___iob_func 003f __cflush 004f __stdbuf 005e __malloc_crt"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 56 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 86 00 00 00 57 E8 ?? ?? ?? ?? 83 C0 20 3B F0 75 04 33 FF EB 0F E8 ?? ?? ?? ?? 83 C0 40 3B F0 75 66 33 FF 47 FF 05 ?? ?? ?? ?? F7 46 0C 0C 01 00 00 75 54 83 3C BD ?? ?? ?? ?? 00 53 BB 00 10 00 00 75 25 53 E8 ?? ?? ?? ?? 59 89 04 BD ?? ?? ?? ?? 85 C0 75 13 8D 46 14 6A 02 89 46 08 89 06 58 89 46 18 89 46 04 EB 12 8B 0C BD ?? ?? ?? ?? 89 4E 08 89 0E 89 5E 18 89 5E 04 81 4E 0C 02 11 00 00 33 C0 40 5B EB 02 33 C0 5F 5E 5D C3 }
	condition:
		$1
}

rule file_139_0_0 {
	meta:
		name = "__openfile"
		size = 632
		refs = "0014 __commode 0032 __errno 003d __invalid_parameter_noinfo 0195 ?ccsField@?P@??_openfile@@9@9 019a __mbsnbcmp 01c7 ?utf8encoding@?P@??_openfile@@9@9 01cd __mbsnbicmp 01e6 ?utf16encoding@?P@??_openfile@@9@9 0205 ?unicodeencoding@?P@??_openfile@@9@9 0245 __sopen_s 0256 __cflush"
	strings:
		$1 = { 55 8B EC 51 51 53 33 D2 21 55 FC 56 8B 75 0C 33 C0 57 8B 3D ?? ?? ?? ?? 89 45 F8 EB 01 46 80 3E 20 74 FA 8A 06 3C 61 74 2D 3C 72 74 22 3C 77 74 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 2B 02 00 00 BB 01 03 00 00 EB 0C 33 DB 83 CF 01 EB 08 BB 09 01 00 00 83 CF 02 33 C9 41 46 8A 06 84 C0 0F 84 BA 01 00 00 C7 45 0C 00 10 00 00 85 C9 0F 84 03 01 00 00 0F BE C0 83 F8 53 0F 8F 8A 00 00 00 74 76 83 E8 20 0F 84 E1 00 00 00 83 E8 0B 74 52 48 74 43 83 E8 18 74 2D 83 E8 0A 74 1D 83 E8 04 75 88 39 45 FC 0F 85 BB 00 00 00 C7 45 FC 01 00 00 00 83 CB 10 E9 B2 00 00 00 81 CB 80 00 00 00 E9 A7 00 00 00 F6 C3 40 0F 85 98 00 00 00 83 CB 40 E9 96 00 00 00 C7 45 F8 01 00 00 00 E9 84 00 00 00 F6 C3 02 75 7F 83 E3 FE 83 E7 FC 83 CB 02 81 CF 80 00 00 00 EB 74 83 7D FC 00 75 68 C7 45 FC 01 00 00 00 83 CB 20 EB 62 83 E8 54 74 50 83 E8 0E 74 3B 48 74 2B 83 E8 0B 74 19 83 E8 06 0F 85 05 FF FF FF F7 C3 00 C0 00 00 75 39 81 CB 00 40 00 00 EB 37 85 D2 75 2D 42 81 E7 FF BF FF FF EB 2A 85 D2 75 20 42 81 CF 00 40 00 00 EB 1D F7 C3 00 C0 00 00 75 0F 81 CB 00 80 00 00 EB 0D 8B 45 0C 85 D8 74 04 33 C9 EB 02 0B D8 46 8A 06 84 C0 0F 85 F5 FE FF FF 8B 45 F8 85 C0 0F 84 9D 00 00 00 EB 01 46 80 3E 20 74 FA 6A 03 56 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 88 FE FF FF 6A 20 83 C6 03 58 EB 01 46 38 06 74 FB 80 3E 3D 0F 85 72 FE FF FF 46 38 06 74 FB 6A 05 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 0B 83 C6 05 81 CB 00 00 04 00 EB 43 6A 08 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 0B 83 C6 08 81 CB 00 00 02 00 EB 24 6A 07 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 17 FE FF FF 83 C6 07 81 CB 00 00 01 00 EB 01 46 80 3E 20 74 FA 80 3E 00 0F 85 FD FD FF FF 68 80 01 00 00 FF 75 10 8D 45 0C 53 FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 85 ED FD FF FF FF 05 ?? ?? ?? ?? 8B 45 14 33 C9 89 48 04 89 08 89 48 08 89 48 1C 8B 4D 0C 89 78 0C 89 48 10 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_140_0_0 {
	meta:
		name = "__mbclen"
		size = 38
		refs = "000c __ismbblead"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 0F B6 06 50 E8 ?? ?? ?? ?? 59 85 C0 74 0B 80 7E 01 00 74 05 6A 02 58 EB 03 33 C0 40 5E 5D C3 }
	condition:
		$1
}

rule file_140_1_0 {
	meta:
		name = "__mbclen_l"
		size = 42
		refs = "000f __ismbblead_l"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 FF 75 0C 0F B6 06 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 0B 80 7E 01 00 74 05 6A 02 58 EB 03 33 C0 40 5E 5D C3 }
	condition:
		$1
}

rule file_141_4_0 {
	meta:
		name = "__mbsicmp_l"
		size = 427
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0023 __errno 002e __invalid_parameter_noinfo 0048 __stricmp_l 008b ___crtLCMapStringA"
	strings:
		$1 = { 55 8B EC 83 EC 14 8D 4D EC 53 56 57 FF 75 10 E8 ?? ?? ?? ?? 8B 7D 08 85 FF 74 07 8B 55 0C 85 D2 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 53 01 00 00 8B 4D F0 33 F6 39 71 08 75 15 8D 45 EC 50 52 57 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 E9 41 01 00 00 0F B6 1F 47 F6 44 0B 19 04 74 66 80 3F 00 75 04 8B DE EB 6E 6A 01 FF 71 04 8D 45 FC 6A 02 50 6A 02 8D 47 FF 50 68 00 02 00 00 FF B1 1C 02 00 00 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 24 83 F8 01 75 06 0F B6 5D FC EB 21 83 F8 02 0F 85 D9 00 00 00 8B 45 FC 0F B6 C8 BA 00 01 00 00 66 0F AF CA 0F B6 C4 66 03 C8 0F B7 D9 8B 4D F0 8B 55 0C 47 EB 11 8B C3 F6 44 08 19 10 74 08 0F B6 9C 08 19 01 00 00 0F B6 02 89 45 08 0F B6 C0 42 F6 44 08 19 04 89 55 0C 74 65 80 3A 00 75 04 8B C6 EB 7A 6A 01 FF 71 04 8D 45 FC 6A 02 50 6A 02 8D 42 FF 50 68 00 02 00 00 FF B1 1C 02 00 00 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 24 83 F8 01 75 06 0F B6 45 FC EB 1D 83 F8 02 75 52 8B 45 FC 0F B6 C8 BA 00 01 00 00 66 0F AF CA 0F B6 C4 66 03 C8 0F B7 C1 8B 55 0C 8B 4D F0 42 89 55 0C EB 1E 8B 45 08 0F B7 D0 89 55 08 F6 44 0A 19 10 8B 55 0C 74 0B 8B 45 08 0F B6 84 08 19 01 00 00 66 3B C3 75 1D 66 85 DB 0F 85 D9 FE FF FF EB 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 BE FF FF FF 7F EB 06 1B F6 83 E6 02 4E 80 7D F8 00 74 07 8B 4D F4 83 61 70 FD 5F 8B C6 5E 5B C9 C3 }
	condition:
		$1
}

rule file_143_0_0 {
	meta:
		name = "__get_sys_err_msg"
		size = 38
		refs = "000c ___sys_nerr 001c ___sys_errlist"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 85 F6 78 09 E8 ?? ?? ?? ?? 3B 30 7C 07 E8 ?? ?? ?? ?? 8B 30 E8 ?? ?? ?? ?? 8B 04 B0 5E 5D C3 }
	condition:
		$1
}

rule file_143_1_0 {
	meta:
		name = "_perror"
		size = 152
		refs = "0003 __sehtable$_perror 0008 __SEH_prolog4 0013 __ioinit 001d ___lock_fhandle 0034 _strlen 003c __write_nolock 0042 ??_C@_02LMMGGCAJ@?3?5?$AA@ 0050 __errno 0057 __get_sys_err_msg 006e ??_C@_01EEMJAFIK@?6?$AA@ 0088 __SEH_epilog4 0092 __unlock_fhandle"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 02 5F 89 7D E4 E8 ?? ?? ?? ?? 85 C0 78 6C 57 E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 75 08 85 F6 74 22 80 3E 00 74 1D 56 E8 ?? ?? ?? ?? 50 56 57 E8 ?? ?? ?? ?? 57 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 1C E8 ?? ?? ?? ?? FF 30 E8 ?? ?? ?? ?? 8B F0 56 E8 ?? ?? ?? ?? 50 56 57 E8 ?? ?? ?? ?? 6A 01 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 20 C7 45 FC FE FF FF FF E8 09 00 00 00 E8 ?? ?? ?? ?? C3 8B 7D E4 57 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_144_4_0 {
	meta:
		name = "__ismbslead_l"
		size = 141
		refs = "000f __errno 001a __invalid_parameter_noinfo 0045 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 56 8B 75 08 85 F6 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 68 57 8B 7D 0C 85 FF 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 4B FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 33 D2 39 51 08 74 27 EB 1C 8A 06 84 C0 74 1F 0F B6 C0 F6 44 08 19 04 74 0B 8B C6 46 3B C7 74 0B 38 16 74 0A 46 3B F7 76 E0 EB 03 83 CA FF 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD 8B C2 5F 5E C9 C3 }
	condition:
		$1
}

rule file_145_1_0 {
	meta:
		name = "??0?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@XZ"
		size = 23
		refs = "000a ??0_ReaderWriterLock@details@Concurrency@@QAE@XZ"
		altNames = "??0?$SafeRWList@UBoostedObject@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@XZ ??0?$SafeRWList@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@V_ReaderWriterLock@34@@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 56 8B F1 83 26 00 8D 4E 04 E8 ?? ?? ?? ?? 8B 10 8B 40 04 8B C6 5E C3 }
	condition:
		$1
}

rule file_145_2_0 {
	meta:
		name = "??0CancellationTokenRegistration_TaskProc@@QAE@P6AXPAX@Z0H@Z"
		size = 39
		refs = "000a ??0_CancellationTokenRegistration@details@Concurrency@@QAE@J@Z 001c ??_7CancellationTokenRegistration_TaskProc@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 10 8B F1 E8 ?? ?? ?? ?? 8B 45 08 89 46 1C 8B 45 0C 89 46 20 C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 0C 00 }
	condition:
		$1
}

rule file_145_3_0 {
	meta:
		name = "??0_CancellationTokenRegistration@details@Concurrency@@QAE@J@Z"
		size = 38
		refs = "000c ??_7_RefCounterBase@details@Concurrency@@6B@ 0015 ??_7_CancellationTokenRegistration@details@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 61 10 00 C7 01 ?? ?? ?? ?? 89 41 04 C7 01 ?? ?? ?? ?? C7 41 08 03 00 00 00 8B C1 5D C2 04 00 }
	condition:
		$1
}

rule file_145_4_0 {
	meta:
		name = "??0_CancellationTokenState@details@Concurrency@@AAE@XZ"
		size = 82
		refs = "0003 __ehhandler$??0_CancellationTokenState@details@Concurrency@@AAE@XZ 0008 __EH_prolog3 0013 ??_7_RefCounterBase@details@Concurrency@@6B@ 0024 ??_7_CancellationTokenState@details@Concurrency@@6B@ 0033 ??0event@Concurrency@@QAE@XZ 0046 ??0?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@XZ 004d __EH_epilog3"
	strings:
		$1 = { 6A 08 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 F0 C7 06 ?? ?? ?? ?? C7 46 04 01 00 00 00 83 65 FC 00 C7 06 ?? ?? ?? ?? 8D 4E 0C C7 46 08 00 00 00 00 E8 ?? ?? ?? ?? 8D 4E 34 89 4D EC C6 45 FC 02 85 C9 74 05 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_145_7_0 {
	meta:
		name = "__unwindfunclet$??0_CancellationTokenState@details@Concurrency@@AAE@XZ$2"
		size = 18
		refs = "000b ??3@YAXPAX0@Z"
	strings:
		$1 = { 8B 45 F0 83 C0 34 50 FF 75 EC E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_145_8_0 {
	meta:
		name = "__ehhandler$??0_CancellationTokenState@details@Concurrency@@AAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_CancellationTokenState@details@Concurrency@@AAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_2_2 {
	meta:
		name = "__ehhandler$??$?0$$A6A_NABW4agent_status@Concurrency@@@Z@?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@QAE@A6A_NABW4agent_status@Concurrency@@@Z@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$?0$$A6A_NABW4agent_status@Concurrency@@@Z@?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@QAE@A6A_NABW4agent_status@Concurrency@@@Z@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_15_1 {
	meta:
		name = "__ehhandler$??$?0ABVexception_ptr@std@@PAX@?$_Ref_count_obj@U_ExceptionHolder@details@Concurrency@@@std@@QAE@ABVexception_ptr@1@$$QAPAX@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$?0ABVexception_ptr@std@@PAX@?$_Ref_count_obj@U_ExceptionHolder@details@Concurrency@@@std@@QAE@ABVexception_ptr@1@$$QAPAX@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_761_13_0 {
	meta:
		name = "__ehhandler$??$_Resetp@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@?$shared_ptr@V__ExceptionPtr@@@std@@AAEXPAV__ExceptionPtr@@P6AX0@ZV?$_DebugMallocator@H@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Resetp@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@?$shared_ptr@V__ExceptionPtr@@@std@@AAEXPAV__ExceptionPtr@@P6AX0@ZV?$_DebugMallocator@H@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_146_1 {
	meta:
		name = "__ehhandler$??$_Ucopy@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@@?$vector@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@IAEPAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@1@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@1@0PAV21@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Ucopy@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@@?$vector@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@IAEPAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@1@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@1@0PAV21@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_149_1 {
	meta:
		name = "__ehhandler$??$_Ucopy@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@@?$vector@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@IAEPAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@1@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@1@0PAV21@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Ucopy@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@@?$vector@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@IAEPAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@1@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@1@0PAV21@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_156_1 {
	meta:
		name = "__ehhandler$??$_Uninit_copy@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@PAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@2@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@YAPAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@0@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0PAV10@AAU?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@0@U_Nonscalar_ptr_iterator_tag@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Uninit_copy@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@PAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@2@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@YAPAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@0@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0PAV10@AAU?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@0@U_Nonscalar_ptr_iterator_tag@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_159_1 {
	meta:
		name = "__ehhandler$??$_Uninit_copy@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@PAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@2@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@YAPAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@0@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0PAV10@AAU?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@0@U_Nonscalar_ptr_iterator_tag@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Uninit_copy@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@std@@PAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@2@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@YAPAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@0@V?$move_iterator@V?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@@0@0PAV10@AAU?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@0@U_Nonscalar_ptr_iterator_tag@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_255_1 {
	meta:
		name = "__ehhandler$??$make_shared@U_ExceptionHolder@details@Concurrency@@ABVexception_ptr@std@@PAX@std@@YA?AV?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@0@ABVexception_ptr@0@$$QAPAX@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$make_shared@U_ExceptionHolder@details@Concurrency@@ABVexception_ptr@std@@PAX@std@@YA?AV?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@0@ABVexception_ptr@0@$$QAPAX@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_97_30_2 {
	meta:
		name = "__ehhandler$??0?$basic_istream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_istream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_36_1 {
	meta:
		name = "__ehhandler$??0?$basic_istream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_istream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_36_1 {
	meta:
		name = "__ehhandler$??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_36_1 {
	meta:
		name = "__ehhandler$??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_30_2 {
	meta:
		name = "__ehhandler$??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_30_2 {
	meta:
		name = "__ehhandler$??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_296_1 {
	meta:
		name = "__ehhandler$??0?$call@IV?$function@$$A6AXABI@Z@std@@@Concurrency@@QAE@ABV?$function@$$A6AXABI@Z@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$call@IV?$function@$$A6AXABI@Z@std@@@Concurrency@@QAE@ABV?$function@$$A6AXABI@Z@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_402_1 {
	meta:
		name = "__ehhandler$??0agent@Concurrency@@QAE@AAVScheduleGroup@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0agent@Concurrency@@QAE@AAVScheduleGroup@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_405_1 {
	meta:
		name = "__ehhandler$??0agent@Concurrency@@QAE@AAVScheduler@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0agent@Concurrency@@QAE@AAVScheduler@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_408_1 {
	meta:
		name = "__ehhandler$??0agent@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0agent@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_579_2 {
	meta:
		name = "__ehhandler$??1_Blocking_recipient@?1???$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@std@@@Z@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Blocking_recipient@?1???$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@std@@@Z@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_583_2 {
	meta:
		name = "__ehhandler$??1_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_145_18_0 {
	meta:
		name = "__ehhandler$??1_CancellationTokenState@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_CancellationTokenState@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_887_31_0 {
	meta:
		name = "__ehhandler$??1event@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1event@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_905_2_0 {
	meta:
		name = "__ehhandler$??2@YAPAXIABUnothrow_t@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??2@YAPAXIABUnothrow_t@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_944_44_0 {
	meta:
		name = "__ehhandler$?Activate@UMSFreeVirtualProcessorRoot@details@Concurrency@@UAEXPAUIExecutionContext@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Activate@UMSFreeVirtualProcessorRoot@details@Concurrency@@UAEXPAUIExecutionContext@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_178_84_0 {
	meta:
		name = "__ehhandler$?CreateSingleton@ResourceManager@details@Concurrency@@SAPAV123@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateSingleton@ResourceManager@details@Concurrency@@SAPAV123@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_765_233_0 {
	meta:
		name = "__ehhandler$?GetDefaultScheduler@SchedulerBase@details@Concurrency@@CAPAV123@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetDefaultScheduler@SchedulerBase@details@Concurrency@@CAPAV123@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_765_249_0 {
	meta:
		name = "__ehhandler$?GetInternalContext@SchedulerBase@details@Concurrency@@QAEPAVInternalContextBase@23@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetInternalContext@SchedulerBase@details@Concurrency@@QAEPAVInternalContextBase@23@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_553_121_0 {
	meta:
		name = "__ehhandler$?Grow@CancellationBeaconStack@ContextBase@details@Concurrency@@AAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Grow@CancellationBeaconStack@ContextBase@details@Concurrency@@AAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_178_189_0 {
	meta:
		name = "__ehhandler$?RemoveExecutionResource@ResourceManager@details@Concurrency@@QAEXPAVExecutionResource@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?RemoveExecutionResource@ResourceManager@details@Concurrency@@QAEXPAVExecutionResource@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1116_122_0 {
	meta:
		name = "__ehhandler$?_CancelStolenContexts@_TaskCollection@details@Concurrency@@AAEX_N0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CancelStolenContexts@_TaskCollection@details@Concurrency@@AAEX_N0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_284_2 {
	meta:
		name = "__ehhandler$?_Init@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_692_2 {
	meta:
		name = "__ehhandler$?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_695_2 {
	meta:
		name = "__ehhandler$?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1116_145_0 {
	meta:
		name = "__ehhandler$?_Initialize@_TaskCollection@details@Concurrency@@AAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Initialize@_TaskCollection@details@Concurrency@@AAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_727_1 {
	meta:
		name = "__ehhandler$?_JoinAllTokens_Add@details@Concurrency@@YAXABVcancellation_token_source@2@PAV_CancellationTokenState@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_JoinAllTokens_Add@details@Concurrency@@YAXABVcancellation_token_source@2@PAV_CancellationTokenState@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_294_2 {
	meta:
		name = "__ehhandler$?_Makexloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Makexloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_760_1 {
	meta:
		name = "__ehhandler$?_RunContinuation@_Task_impl_base@details@Concurrency@@QAEXPAU_ContinuationTaskHandleBase@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_RunContinuation@_Task_impl_base@details@Concurrency@@QAEXPAU_ContinuationTaskHandleBase@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_687_2 {
	meta:
		name = "__ehhandler$?_ScheduleFuncWithAutoInline@details@Concurrency@@YAXABV?$function@$$A6AXXZ@std@@W4_TaskInliningMode@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_ScheduleFuncWithAutoInline@details@Concurrency@@YAXABV?$function@$$A6AXXZ@std@@W4_TaskInliningMode@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_772_1 {
	meta:
		name = "__ehhandler$?_ScheduleTask@_Task_impl_base@details@Concurrency@@QAEXPAV_UnrealizedChore@23@W4_TaskInliningMode@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_ScheduleTask@_Task_impl_base@details@Concurrency@@QAEXPAV_UnrealizedChore@23@W4_TaskInliningMode@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_761_120_0 {
	meta:
		name = "__ehhandler$?__ExceptionPtrCurrentException@@YAXPAX@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?__ExceptionPtrCurrentException@@YAXPAX@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_103_2 {
	meta:
		name = "__ehhandler$?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEAAV12@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEAAV12@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_91_119_1 {
	meta:
		name = "__ehhandler$?flush@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEAAV12@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?flush@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEAAV12@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_96_102_2 {
	meta:
		name = "__ehhandler$?flush@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEAAV12@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?flush@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEAAV12@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_342_2 {
	meta:
		name = "__ehhandler$?global@locale@std@@SA?AV12@ABV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?global@locale@std@@SA?AV12@ABV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_145_9_0 {
	meta:
		name = "??0_RefCounterBase@details@Concurrency@@IAE@J@Z"
		size = 21
		refs = "0008 ??_7_RefCounterBase@details@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 8B 45 08 C7 01 ?? ?? ?? ?? 89 41 04 8B C1 5D C2 04 00 }
	condition:
		$1
}

rule file_145_10_0 {
	meta:
		name = "??0_Scoped_lock@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@AAV123@@Z"
		size = 26
		refs = "000f ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 8B 4D 08 89 0E 83 C1 04 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_553_20_0 {
	meta:
		name = "??0_Scoped_lock_read@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@AAV123@@Z"
		size = 26
		refs = "000f ?_AcquireRead@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 8B 4D 08 89 0E 83 C1 04 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_145_11_0 {
	meta:
		name = "??0_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 23
		refs = "000c ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 8B 4D 08 89 0E E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_709_4_0 {
	meta:
		name = "??0ScopedCriticalRegion@ContextBase@details@Concurrency@@QAE@PAV123@@Z"
		size = 23
		refs = "000c ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 8B 4D 08 89 0E E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_251_9_0 {
	meta:
		name = "??0_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 23
		refs = "000c ?_Acquire@_CriticalNonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 8B 4D 08 89 0E E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_185_11_0 {
	meta:
		name = "??0_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 23
		refs = "000c ?_Acquire@_HyperNonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 8B 4D 08 89 0E E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_178_20_0 {
	meta:
		name = "??0_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 23
		refs = "000c ?_Acquire@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 8B 4D 08 89 0E E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1183_9_0 {
	meta:
		name = "??0_Scoped_lock@_NonReentrantLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 23
		refs = "000c ?_Acquire@_NonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 8B 4D 08 89 0E E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_449_7_0 {
	meta:
		name = "??0_Scoped_lock@_ReentrantBlockingLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 23
		refs = "000c ?_Acquire@_ReentrantBlockingLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 8B 4D 08 89 0E E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_605_27_0 {
	meta:
		name = "??0scoped_lock_read@reader_writer_lock@Concurrency@@QAE@AAV12@@Z"
		size = 23
		refs = "000c ?lock_read@reader_writer_lock@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 8B 4D 08 89 0E E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_145_15_0 {
	meta:
		name = "??1_CancellationTokenState@details@Concurrency@@UAE@XZ"
		size = 120
		refs = "0003 __ehhandler$??1_CancellationTokenState@details@Concurrency@@UAE@XZ 0008 __EH_prolog3 0013 ??_7_CancellationTokenState@details@Concurrency@@6B@ 002a ?Swap@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEXPAV?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@23@@Z 0056 ?_Release@_RefCounterBase@details@Concurrency@@QAEJXZ 0068 ??1event@Concurrency@@QAE@XZ 006e ??_7_RefCounterBase@details@Concurrency@@6B@ 0073 __EH_epilog3"
	strings:
		$1 = { 6A 08 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 89 7D EC C7 07 ?? ?? ?? ?? 83 65 F0 00 8D 45 F0 8D 4F 34 50 C7 45 FC 01 00 00 00 E8 ?? ?? ?? ?? 8B 75 F0 85 F6 74 05 8B 4E 04 EB 02 33 C9 85 C9 74 20 3B CE 74 05 8B 59 04 EB 02 33 DB 83 C1 EC C7 41 08 02 00 00 00 E8 ?? ?? ?? ?? 8B CB 85 DB 75 E0 8D 4F 0C C6 45 FC 00 E8 ?? ?? ?? ?? C7 07 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_145_31_0 {
	meta:
		name = "?AddTail@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z"
		size = 47
	strings:
		$1 = { 55 8B EC 8B 01 8B 55 08 85 C0 75 07 89 52 04 89 12 EB 16 8B 40 04 89 42 04 8B 01 89 02 8B 01 8B 40 04 89 10 8B 01 89 50 04 89 11 5D C2 04 00 }
	condition:
		$1
}

rule file_145_36_0 {
	meta:
		name = "?Next@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QBEPAUListEntry@23@PAU423@@Z"
		size = 21
	strings:
		$1 = { 55 8B EC 8B 45 08 3B 01 74 05 8B 40 04 EB 02 33 C0 5D C2 04 00 }
	condition:
		$1
}

rule file_145_38_0 {
	meta:
		name = "?Remove@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z"
		size = 46
	strings:
		$1 = { 55 8B EC 56 8B 75 08 8B 56 04 8B 06 89 02 8B 16 8B 46 04 89 42 04 8B 01 3B F0 5E 75 0D 3B 40 04 75 04 33 C0 EB 02 8B 00 89 01 5D C2 04 00 }
	condition:
		$1
}

rule file_145_39_0 {
	meta:
		name = "?Swap@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAEXPAV123@@Z"
		size = 20
	strings:
		$1 = { 55 8B EC 8B 55 08 8B 01 56 8B 32 89 02 89 31 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_145_40_0 {
	meta:
		name = "?Swap@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEXPAV?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@23@@Z"
		size = 42
		refs = "000c ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ 001f ?_ReleaseWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 53 8B D9 56 57 8D 4B 04 E8 ?? ?? ?? ?? 8B 55 08 8B 03 8B 3A 89 02 8D 4B 04 89 3B E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_145_43_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 103
		refs = "0023 ?Swap@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEXPAV?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@23@@Z 0049 ?_Invoke@_CancellationTokenRegistration@details@Concurrency@@AAEXXZ 005f ?set@event@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 53 8B D9 33 D2 8D 4B 08 42 33 C0 F0 0F B1 11 85 C0 75 4D 21 45 FC 56 8D 45 FC 50 8D 4B 34 E8 ?? ?? ?? ?? 8B 75 FC 85 F6 74 05 8B 4E 04 EB 02 33 C9 85 C9 74 1B 57 3B CE 74 05 8B 79 04 EB 02 33 FF 83 C1 EC E8 ?? ?? ?? ?? 8B CF 85 FF 75 E7 5F 8D 4B 0C C7 43 08 02 00 00 00 E8 ?? ?? ?? ?? 5E 5B C9 C3 }
	condition:
		$1
}

rule file_145_44_0 {
	meta:
		name = "?_DeregisterCallback@_CancellationTokenState@details@Concurrency@@QAEXPAV_CancellationTokenRegistration@23@@Z"
		size = 177
		refs = "0003 __ehhandler$?_DeregisterCallback@_CancellationTokenState@details@Concurrency@@QAEXPAV_CancellationTokenRegistration@23@@Z 0008 __EH_prolog3 0018 ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ 002d ?Remove@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z 003b ?_Release@_RefCounterBase@details@Concurrency@@QAEJXZ 004b ?_ReleaseWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ 006c __imp__GetCurrentThreadId@0 0078 ??0event@Concurrency@@QAE@XZ 0099 ?wait@event@Concurrency@@QAEII@Z 00a5 ??1event@Concurrency@@QAE@XZ 00aa __EH_epilog3"
	strings:
		$1 = { 6A 2C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 79 34 33 DB 8D 4F 04 89 7D F0 E8 ?? ?? ?? ?? 8B 75 08 89 5D FC 39 1F 74 1B 8D 46 14 50 8B CF E8 ?? ?? ?? ?? 8B CE C7 46 08 02 00 00 00 E8 ?? ?? ?? ?? EB 02 B3 01 83 4D FC FF 8D 4F 04 E8 ?? ?? ?? ?? 84 DB 74 56 33 C9 8D 5E 08 41 33 C0 F0 0F B1 0B 8B F8 85 FF 74 44 83 FF 03 74 3F FF 15 ?? ?? ?? ?? 3B F8 74 35 8D 4D C8 E8 ?? ?? ?? ?? 8D 45 C8 6A 02 89 46 0C C7 45 FC 01 00 00 00 58 87 03 83 F8 03 74 0A 6A FF 8D 4D C8 E8 ?? ?? ?? ?? 83 4D FC FF 8D 4D C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C2 04 00 }
	condition:
		$1
}

rule file_145_47_0 {
	meta:
		name = "__ehhandler$?_DeregisterCallback@_CancellationTokenState@details@Concurrency@@QAEXPAV_CancellationTokenRegistration@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_DeregisterCallback@_CancellationTokenState@details@Concurrency@@QAEXPAV_CancellationTokenRegistration@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_543_2 {
	meta:
		name = "__ehhandler$?_CancelInternal@?$task_completion_event@E@Concurrency@@ABE_NXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CancelInternal@?$task_completion_event@E@Concurrency@@ABE_NXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_547_2 {
	meta:
		name = "__ehhandler$?_CancelInternal@?$task_completion_event@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Concurrency@@ABE_NXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CancelInternal@?$task_completion_event@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Concurrency@@ABE_NXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_711_2 {
	meta:
		name = "__ehhandler$?_Throw_future_error@std@@YAXABVerror_code@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Throw_future_error@std@@YAXABVerror_code@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_807_2 {
	meta:
		name = "__ehhandler$?set@?$task_completion_event@E@Concurrency@@QBE_NE@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?set@?$task_completion_event@E@Concurrency@@QBE_NE@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_811_2 {
	meta:
		name = "__ehhandler$?set@?$task_completion_event@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Concurrency@@QBE_NU?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?set@?$task_completion_event@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Concurrency@@QBE_NU?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_1318_1 {
	meta:
		name = "__ehhandler$?wait@?$ordered_message_processor@I@Concurrency@@UAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?wait@?$ordered_message_processor@I@Concurrency@@UAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_1321_1 {
	meta:
		name = "__ehhandler$?wait@?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?wait@?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_887_116_0 {
	meta:
		name = "__ehhandler$?wait_for@_Condition_variable@details@Concurrency@@QAE_NAAVcritical_section@3@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?wait_for@_Condition_variable@details@Concurrency@@QAE_NAAVcritical_section@3@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_145_52_0 {
	meta:
		name = "?_Invoke@_CancellationTokenRegistration@details@Concurrency@@AAEXXZ"
		size = 67
		refs = "0007 __imp__GetCurrentThreadId@0 0035 ?set@event@Concurrency@@QAEXXZ 003f ?_Release@_RefCounterBase@details@Concurrency@@QAEJXZ"
	strings:
		$1 = { 53 56 57 8B F1 FF 15 ?? ?? ?? ?? 8B F8 8D 5E 08 8B D7 33 C0 F0 0F B1 13 85 C0 75 1D 8B 06 8B CE FF 50 08 6A 03 59 8B C7 F0 0F B1 0B 83 F8 02 75 08 8B 4E 0C E8 ?? ?? ?? ?? 5F 8B CE 5E 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_145_54_0 {
	meta:
		name = "?_NewTokenState@_CancellationTokenState@details@Concurrency@@SAPAV123@XZ"
		size = 45
		refs = "0003 __ehhandler$?_NewTokenState@_CancellationTokenState@details@Concurrency@@SAPAV123@XZ 0008 __EH_prolog3 000f ??2@YAPAXI@Z 0023 ??0_CancellationTokenState@details@Concurrency@@AAE@XZ 0028 __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 48 E8 ?? ?? ?? ?? 59 8B C8 89 4D F0 33 C0 89 45 FC 85 C9 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_145_58_0 {
	meta:
		name = "?_RegisterCallback@_CancellationTokenState@details@Concurrency@@QAEPAV_CancellationTokenRegistration@23@P6AXPAX@Z0H@Z"
		size = 57
		refs = "000a ??2@YAPAXI@Z 001f ??0CancellationTokenRegistration_TaskProc@@QAE@P6AXPAX@Z0H@Z 002d ?_RegisterCallback@_CancellationTokenState@details@Concurrency@@QAEXPAV_CancellationTokenRegistration@23@@Z"
	strings:
		$1 = { 55 8B EC 56 57 6A 24 8B F9 E8 ?? ?? ?? ?? 59 85 C0 74 14 FF 75 10 8B C8 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B F0 EB 02 33 F6 56 8B CF E8 ?? ?? ?? ?? 5F 8B C6 5E 5D C2 0C 00 }
	condition:
		$1
}

rule file_145_59_0 {
	meta:
		name = "?_RegisterCallback@_CancellationTokenState@details@Concurrency@@QAEXPAV_CancellationTokenRegistration@23@@Z"
		size = 101
		refs = "0031 ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ 0047 ?AddTail@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z 004f ?_ReleaseWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ 005a ?_Invoke@_CancellationTokenRegistration@details@Concurrency@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 53 56 8B 75 08 33 DB 43 57 C7 46 08 00 00 00 00 8B F9 8D 56 04 8B C3 F0 0F C1 02 89 7E 10 83 7F 08 00 75 30 8D 47 34 89 45 08 8D 48 04 E8 ?? ?? ?? ?? 83 7F 08 00 8B 7D 08 75 0D 8D 46 14 50 8B CF 32 DB E8 ?? ?? ?? ?? 8D 4F 04 E8 ?? ?? ?? ?? 84 DB 74 07 8B CE E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_145_60_0 {
	meta:
		name = "?_Release@_RefCounterBase@details@Concurrency@@QAEJXZ"
		size = 23
	strings:
		$1 = { 56 8D 51 04 83 CE FF F0 0F C1 32 4E 75 05 8B 11 FF 52 04 8B C6 5E C3 }
	condition:
		$1
}

rule file_146_3_0 {
	meta:
		name = "__strtod_l"
		size = 277
		refs = "0007 ___security_cookie 0022 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0031 __errno 003c __invalid_parameter_noinfo 0059 __isctype_l 0086 __fltin2 00b6 __HUGE 010f @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 34 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 08 56 57 FF 75 10 8B 7D 0C 8D 4D D4 8B F3 E8 ?? ?? ?? ?? 85 FF 74 02 89 1F 85 DB 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 AD 00 00 00 8B 55 D4 83 7A 74 01 7E 17 8D 45 D4 50 0F B6 06 6A 08 50 E8 ?? ?? ?? ?? 8B 55 D4 83 C4 0C EB 10 0F B6 0E 8B 82 90 00 00 00 0F B7 04 48 83 E0 08 85 C0 74 03 46 EB CC 8D 45 D4 50 8D 45 E4 56 50 E8 ?? ?? ?? ?? 83 C4 0C 8B D0 85 FF 74 07 8B 4A 04 03 CE 89 0F F7 02 40 02 00 00 74 0A D9 EE 85 FF 74 51 89 1F EB 4D F6 02 81 74 20 80 3E 2D DD 05 ?? ?? ?? ?? 75 02 D9 E0 DD 5D CC E8 ?? ?? ?? ?? DD 45 CC C7 00 22 00 00 00 EB 28 F7 02 00 01 00 00 74 1D DD 42 10 D9 EE DA E9 DF E0 F6 C4 44 7A 0F E8 ?? ?? ?? ?? C7 00 22 00 00 00 D9 EE EB 03 DD 42 10 80 7D E0 00 5F 5E 5B 74 07 8B 45 DC 83 60 70 FD 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_147_0_0 {
	meta:
		name = "__fwrite_nolock"
		size = 343
		refs = "001e __errno 0029 __invalid_parameter_noinfo 0095 _memcpy 00b5 __flush 00e1 __fileno 00e8 __write 0116 __flsbuf"
	strings:
		$1 = { 55 8B EC 51 51 8B 4D 0C 53 56 57 85 C9 74 1E 8B 5D 10 85 DB 74 17 8B 75 14 85 F6 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 5F 5E 5B C9 C3 83 7D 08 00 74 E3 83 C8 FF 33 D2 F7 F1 3B D8 77 D8 8B F9 0F AF FB F7 46 0C 0C 01 00 00 8B DF 74 05 8B 4E 18 EB 05 B9 00 10 00 00 89 4D FC 85 FF 0F 84 D3 00 00 00 8B 56 0C 81 E2 08 01 00 00 74 36 8B 46 04 89 45 F8 85 C0 74 2C 0F 88 C0 00 00 00 3B D8 73 05 8B C3 89 5D F8 50 FF 75 08 FF 36 E8 ?? ?? ?? ?? 8B 45 F8 29 46 04 01 06 83 C4 0C 2B D8 01 45 08 EB 5D 3B D9 72 5E 85 D2 74 12 56 E8 ?? ?? ?? ?? 59 85 C0 0F 85 87 00 00 00 8B 4D FC 8B C3 85 C9 74 0D 33 D2 F7 F1 8B C3 2B C2 89 45 F8 EB 03 89 5D F8 50 FF 75 08 56 E8 ?? ?? ?? ?? 59 50 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 74 51 8B 4D F8 8B D1 3B C1 77 02 8B D0 01 55 08 2B DA 3B C1 72 3D 8B 4D FC EB 28 8B 45 08 56 0F BE 00 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 74 28 FF 45 08 8B 4E 18 4B 89 4D FC 85 C9 7F 06 33 C9 41 89 4D FC 85 DB 0F 85 2D FF FF FF 8B 45 10 E9 EA FE FF FF 83 4E 0C 20 2B FB 8B C7 33 D2 F7 75 0C E9 D8 FE FF FF }
	condition:
		$1
}

rule file_147_1_0 {
	meta:
		name = "_fwrite"
		size = 126
		refs = "0003 __sehtable$_fwrite 0008 __SEH_prolog4 0027 __errno 0032 __invalid_parameter_noinfo 0039 __SEH_epilog4 0040 __lock_file 0054 __fwrite_nolock 0078 __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 7D 0C 00 74 24 83 7D 10 00 74 1E 33 C0 8B 75 14 85 F6 0F 95 C0 85 C0 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E8 ?? ?? ?? ?? C3 56 E8 ?? ?? ?? ?? 59 83 65 FC 00 56 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 8B F8 89 7D E4 C7 45 FC FE FF FF FF E8 0A 00 00 00 8B C7 EB C8 8B 75 14 8B 7D E4 56 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_148_0_0 {
	meta:
		name = "___common_dacos_cout_rare"
		size = 2672
		refs = "0042 __vmldACosHATab 09ce _2il0floatpacket_190"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 57 53 83 EC 5C 8B 4D 08 0F B7 41 06 25 F0 7F 00 00 F2 0F 10 09 3D F0 7F 00 00 0F B6 51 07 0F 84 0B 0A 00 00 F2 0F 11 4C 24 40 83 E2 7F 88 54 24 47 F2 0F 10 64 24 40 F2 0F 10 05 ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 66 0F 2F C4 0F 86 6C 09 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F CC 0F 86 3A 04 00 00 66 0F 2F 25 ?? ?? ?? ?? 0F 86 D4 03 00 00 F2 0F 10 1D ?? ?? ?? ?? 0F 28 D4 F2 0F 59 D3 F2 0F 11 54 24 38 F2 0F 10 44 24 38 F2 0F 11 64 24 08 F2 0F 5C 44 24 40 F2 0F 11 44 24 30 0F 28 C4 F2 0F 10 54 24 38 F2 0F 10 6C 24 30 F2 0F 5C D5 F2 0F 11 54 24 38 0F 28 D4 F2 0F 10 7C 24 38 F2 0F 5C C7 F2 0F 10 3D ?? ?? ?? ?? F2 0F 11 44 24 30 F2 0F 10 44 24 38 0F 28 C8 F2 0F 58 D0 F2 0F 59 C8 F2 0F 10 74 24 30 0F 28 E9 F2 0F 59 D6 F2 0F 58 EA F2 0F 59 FD F2 0F 11 6C 24 10 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD 0F 28 EB F2 0F 59 E9 F2 0F 58 3D ?? ?? ?? ?? F2 0F 11 6C 24 38 F2 0F 11 7C 24 18 F2 0F 10 7C 24 38 F2 0F 5C F9 F2 0F 11 7C 24 30 F2 0F 10 7C 24 38 F2 0F 10 6C 24 30 F2 0F 5C FD F2 0F 11 7C 24 38 F2 0F 10 6C 24 38 F2 0F 5C CD F2 0F 11 4C 24 30 F2 0F 10 4C 24 38 F2 0F 10 7C 24 30 F2 0F 59 F1 F2 0F 58 D7 F2 0F 59 C1 F2 0F 59 E2 F2 0F 58 E6 0F 28 F3 F2 0F 59 F0 F2 0F 11 74 24 38 F2 0F 10 6C 24 38 F2 0F 5C E8 F2 0F 11 6C 24 30 0F 28 E8 F2 0F 10 7C 24 38 F2 0F 58 C4 F2 0F 10 74 24 30 F2 0F 59 D0 F2 0F 5C FE F2 0F 11 7C 24 38 F2 0F 10 74 24 38 F2 0F 5C EE F2 0F 11 6C 24 30 0F 28 E9 F2 0F 10 74 24 38 F2 0F 59 EE F2 0F 59 DD F2 0F 10 7C 24 30 F2 0F 11 7C 24 20 F2 0F 58 FC F2 0F 11 5C 24 38 F2 0F 10 5C 24 38 F2 0F 59 CF F2 0F 5C DD F2 0F 11 5C 24 30 0F 28 DD F2 0F 10 7C 24 38 F2 0F 58 CA F2 0F 10 54 24 30 F2 0F 58 E9 F2 0F 5C FA F2 0F 11 7C 24 38 F2 0F 10 54 24 38 F2 0F 10 7C 24 18 F2 0F 5C DA F2 0F 11 5C 24 30 F2 0F 10 5C 24 38 F2 0F 10 54 24 30 F2 0F 11 54 24 28 F2 0F 10 54 24 10 F2 0F 59 D5 F2 0F 59 FA F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 D0 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C5 F2 0F 10 6C 24 08 F2 0F 58 D0 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 D7 F2 0F 59 E0 F2 0F 59 F0 F2 0F 58 D4 F2 0F 10 64 24 20 F2 0F 59 E0 0F 28 C5 F2 0F 58 C6 F2 0F 58 D4 F2 0F 11 44 24 38 F2 0F 10 64 24 38 F2 0F 11 34 24 F2 0F 5C EC F2 0F 10 3D ?? ?? ?? ?? F2 0F 58 EE F2 0F 59 CF F2 0F 59 DF F2 0F 59 7C 24 28 F2 0F 11 6C 24 30 F2 0F 10 64 24 38 F2 0F 10 74 24 30 F2 0F 58 D6 F2 0F 58 D1 0F 28 CC F2 0F 58 CB F2 0F 58 D7 F2 0F 11 4C 24 38 F2 0F 10 44 24 38 F2 0F 5C E0 F2 0F 58 E3 F2 0F 11 64 24 30 F2 0F 10 44 24 38 F2 0F 10 09 F2 0F 10 5C 24 30 66 0F 2F 0D ?? ?? ?? ?? F2 0F 58 D3 76 47 F2 0F 10 25 ?? ?? ?? ?? 0F 28 CC F2 0F 5C C8 F2 0F 11 4C 24 38 F2 0F 10 5C 24 38 F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C E3 F2 0F 5C CA F2 0F 5C E0 F2 0F 11 64 24 30 F2 0F 10 5C 24 38 F2 0F 10 44 24 30 F2 0F 58 C8 EB 45 F2 0F 10 25 ?? ?? ?? ?? 0F 28 C8 F2 0F 58 CC F2 0F 11 4C 24 38 F2 0F 10 5C 24 38 F2 0F 5C E3 F2 0F 58 E0 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 D0 F2 0F 11 64 24 30 F2 0F 10 5C 24 38 F2 0F 10 4C 24 30 F2 0F 58 CA 8B 45 0C F2 0F 58 D9 F2 0F 11 18 33 C0 83 C4 5C 5B 5F 5E 8B E5 5D C3 F2 0F 10 0D ?? ?? ?? ?? F2 0F 58 C4 F2 0F 11 44 24 38 F2 0F 10 44 24 38 F2 0F 59 44 24 40 F2 0F 11 04 24 0F B6 44 24 07 0F B6 49 07 83 E0 7F 83 E1 80 0B C1 88 44 24 07 33 C0 8B 55 0C F2 0F 5C 0C 24 F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 0A 83 C4 5C 5B 5F 5E 8B E5 5D C3 0F 28 D8 8B F0 81 E6 0F 80 FF FF 25 0F 80 FF FF F2 0F 11 44 24 08 F2 0F 5C DC F2 0F 59 CB F2 0F 11 0C 24 0F B7 54 24 06 81 E2 F0 7F 00 00 C1 EA 04 81 C2 01 FC FF FF 8B DA F7 DB 81 C3 FF 03 00 00 81 E3 FF 07 00 00 C1 E3 04 0B F3 66 89 74 24 0E 8B F2 F2 0F 59 4C 24 08 83 E6 01 0F 28 E9 83 FE 01 F2 0F 10 35 ?? ?? ?? ?? 8B FE F2 0F 11 44 24 18 F2 0F 58 E9 74 03 0F 28 E9 F2 0F 59 F5 F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 4C 24 10 0F 28 FE 8B 5C 24 10 2B D6 C1 E7 08 81 E3 FF 01 00 00 03 DF F2 0F 5C FD F2 0F 11 7C 24 30 F2 0F 10 64 24 30 F2 0F 10 14 DD ?? ?? ?? ?? F2 0F 5C F4 0F 28 FA 0F 28 E5 F2 0F 59 FA 0F 28 CE F2 0F 5C E6 F2 0F 59 F2 F2 0F 59 CF F2 0F 59 FC F2 0F 5C C8 D1 EA F2 0F 58 CF F2 0F 10 3D ?? ?? ?? ?? 81 C2 FF 03 00 00 F2 0F 59 F9 81 E2 FF 07 00 00 C1 E2 04 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 0B C2 66 89 44 24 1E F2 0F 10 44 24 18 F2 0F 59 F0 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 11 5C 24 20 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 59 FA F2 0F 59 D4 F2 0F 59 FD F2 0F 58 FA F2 0F 10 15 ?? ?? ?? ?? 0F 28 EA F2 0F 59 EE F2 0F 59 F8 F2 0F 11 6C 24 38 F2 0F 10 44 24 38 F2 0F 10 2D ?? ?? ?? ?? F2 0F 5C C6 F2 0F 58 2D ?? ?? ?? ?? F2 0F 11 44 24 30 F2 0F 10 64 24 38 F2 0F 10 4C 24 30 F2 0F 5C E1 F2 0F 10 0D ?? ?? ?? ?? F2 0F 11 64 24 38 F2 0F 10 44 24 38 F2 0F 10 25 ?? ?? ?? ?? F2 0F 5C F0 F2 0F 58 25 ?? ?? ?? ?? F2 0F 11 74 24 30 F2 0F 10 74 24 38 F2 0F 10 44 24 30 F2 0F 11 74 24 28 0F 28 F1 F2 0F 59 E3 F2 0F 58 F8 F2 0F 58 35 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 F4 F2 0F 59 C3 F2 0F 59 F3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 58 EE F2 0F 59 C3 0F 28 E3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 59 C3 F2 0F 59 C3 F2 0F 11 44 24 40 F2 0F 58 E8 F2 0F 59 FD F2 0F 11 7C 24 48 0F 28 FA F2 0F 59 FB F2 0F 11 7C 24 38 F2 0F 10 44 24 38 F2 0F 5C C3 F2 0F 11 44 24 30 F2 0F 10 74 24 38 F2 0F 10 6C 24 30 F2 0F 5C F5 F2 0F 11 74 24 38 F2 0F 10 7C 24 38 F2 0F 5C E7 F2 0F 11 64 24 30 F2 0F 10 64 24 38 0F 28 EC 0F 28 C4 F2 0F 59 EC F2 0F 58 C3 F2 0F 59 E1 0F 28 DA F2 0F 59 DD F2 0F 10 7C 24 30 F2 0F 11 5C 24 38 F2 0F 10 74 24 38 F2 0F 59 CF F2 0F 5C F5 F2 0F 59 C7 F2 0F 11 74 24 30 F2 0F 10 74 24 38 F2 0F 10 5C 24 30 F2 0F 5C F3 F2 0F 11 74 24 38 F2 0F 10 5C 24 38 F2 0F 5C EB 0F 28 DC F2 0F 11 6C 24 30 F2 0F 10 74 24 38 F2 0F 59 35 ?? ?? ?? ?? F2 0F 10 6C 24 30 F2 0F 58 DE F2 0F 11 5C 24 38 F2 0F 11 6C 24 50 F2 0F 10 6C 24 38 F2 0F 11 74 24 10 F2 0F 5C E5 F2 0F 10 2D ?? ?? ?? ?? F2 0F 58 E6 F2 0F 11 64 24 30 0F 28 E5 F2 0F 10 5C 24 38 F2 0F 10 74 24 30 F2 0F 58 E3 F2 0F 11 64 24 38 F2 0F 10 64 24 38 F2 0F 5C EC F2 0F 58 EB F2 0F 11 6C 24 30 F2 0F 10 64 24 38 F2 0F 59 D4 F2 0F 10 5C 24 30 F2 0F 11 54 24 38 F2 0F 10 54 24 38 F2 0F 5C D4 F2 0F 11 54 24 30 F2 0F 10 54 24 38 F2 0F 10 6C 24 30 F2 0F 5C D5 F2 0F 11 54 24 38 F2 0F 10 6C 24 38 F2 0F 5C E5 F2 0F 11 64 24 30 F2 0F 10 6C 24 38 F2 0F 10 54 24 30 F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 D6 F2 0F 10 31 F2 0F 58 D3 66 0F 2F 35 ?? ?? ?? ?? F2 0F 58 D1 F2 0F 10 5C 24 20 F2 0F 59 E3 F2 0F 10 4C 24 50 F2 0F 58 C8 F2 0F 10 44 24 28 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 0D ?? ?? ?? ?? F2 0F 59 E3 F2 0F 58 D1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 D0 F2 0F 58 64 24 40 F2 0F 10 4C 24 48 F2 0F 59 E0 F2 0F 58 CA F2 0F 59 C5 F2 0F 58 CC 77 4D F2 0F 10 25 ?? ?? ?? ?? 0F 28 D4 F2 0F 10 35 ?? ?? ?? ?? F2 0F 5C D0 F2 0F 5C F1 F2 0F 11 54 24 38 F2 0F 10 5C 24 38 F2 0F 11 04 24 F2 0F 5C E3 F2 0F 5C E0 F2 0F 11 64 24 30 F2 0F 10 44 24 38 F2 0F 10 6C 24 30 0F 28 CD F2 0F 58 CE 8B 45 0C F2 0F 58 C1 F2 0F 11 00 33 C0 83 C4 5C 5B 5F 5E 8B E5 5D C3 66 0F 2E C8 7A 02 74 50 0F 57 05 ?? ?? ?? ?? 66 0F 2E C8 7A 02 74 1E 8B 45 0C F2 0F 5C C9 F2 0F 5E C9 F2 0F 11 08 B8 01 00 00 00 83 C4 5C 5B 5F 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? 8B 45 0C F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 00 33 C0 83 C4 5C 5B 5F 5E 8B E5 5D C3 8B 45 0C F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 00 33 C0 83 C4 5C 5B 5F 5E 8B E5 5D C3 F2 0F 5E C9 8B 45 0C F2 0F 11 08 F7 41 04 FF FF 0F 00 75 17 BA 01 00 00 00 33 C0 83 39 00 0F 44 C2 83 C4 5C 5B 5F 5E 8B E5 5D C3 33 C0 83 C4 5C 5B 5F 5E 8B E5 5D C3 8D 49 00 }
	condition:
		$1
}

rule file_150_0_0 {
	meta:
		name = "__wdospawn"
		size = 560
		refs = "0032 ___doserrno 0039 __errno 0044 __invalid_parameter_noinfo 0077 _memset 0082 __ioinit 0090 __nhandle 00a5 ___pioinfo 00e0 __calloc_crt 01ab __imp__CreateProcessW@40 01b3 __imp__GetLastError@0 01be _free 01cb __dosmaperr 01d9 __imp__CloseHandle@4 01e8 __imp__WaitForSingleObject@8 01f5 __imp__GetExitCodeProcess@8 022b __exit"
	strings:
		$1 = { 55 8B EC 83 EC 68 53 57 8B 7D 08 33 DB 88 5D FF 85 FF 74 15 83 FF 01 74 10 7E 16 83 FF 03 7E 09 83 FF 04 75 0C C6 45 FF 01 8B 45 10 89 45 F0 EB 36 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 D5 01 00 00 83 C0 02 66 39 18 75 F8 66 39 58 02 74 09 6A 20 5A 66 89 10 83 C0 02 66 39 18 75 E4 56 6A 44 5E 56 8D 45 98 53 50 E8 ?? ?? ?? ?? 83 C4 0C 89 75 98 E8 ?? ?? ?? ?? 85 C0 0F 88 93 01 00 00 8B 35 ?? ?? ?? ?? 85 F6 74 23 8D 56 FF 8B C2 C1 F8 05 8B CA 8B 04 85 ?? ?? ?? ?? 83 E1 1F C1 E1 06 38 5C 08 04 75 04 4A 4E 75 E2 85 F6 0F 88 55 01 00 00 81 FE 32 33 00 00 0F 83 49 01 00 00 8B C6 6B C0 05 83 C0 04 66 89 45 CA 0F B7 C0 6A 01 50 E8 ?? ?? ?? ?? 59 59 89 45 CC 85 C0 0F 84 25 01 00 00 89 30 8B 45 CC 8B D3 8D 48 04 89 4D F4 8D 48 04 03 CE 89 4D F8 85 F6 7E 45 8B 7D F4 8B CA 83 E1 1F 8B C2 C1 F8 05 C1 E1 06 03 0C 85 ?? ?? ?? ?? 8A 41 04 A8 10 75 0D 88 07 8B 01 8B 4D F8 89 01 8B C1 EB 08 8B 45 F8 88 1F 83 08 FF 42 83 C0 04 47 89 45 F8 3B D6 7C C4 8B 45 CC 8B 7D 08 38 5D FF 74 2F 8D 50 04 83 C0 04 8B CB 03 C6 89 75 08 83 FE 03 7C 07 C7 45 08 03 00 00 00 3B 4D 08 7D 0C 88 1A 83 08 FF 41 42 83 C0 04 EB E0 6A 08 5E EB 02 8B F3 E8 ?? ?? ?? ?? 89 18 8D 45 DC 50 8D 45 98 50 53 FF 75 14 81 CE 00 04 00 00 56 6A 01 53 53 FF 75 F0 FF 75 0C FF 15 ?? ?? ?? ?? 8B F0 FF 15 ?? ?? ?? ?? FF 75 CC 89 45 08 E8 ?? ?? ?? ?? 59 85 F6 75 0B FF 75 08 E8 ?? ?? ?? ?? 59 EB 4F 83 FF 02 74 52 8B 35 ?? ?? ?? ?? 85 FF 75 1D 6A FF FF 75 DC FF 15 ?? ?? ?? ?? 8D 45 EC 50 FF 75 DC FF 15 ?? ?? ?? ?? 8B 5D EC EB 05 83 FF 04 75 07 FF 75 DC FF D6 EB 03 8B 5D DC FF 75 E0 FF D6 8B C3 EB 0E E8 ?? ?? ?? ?? C7 00 0C 00 00 00 83 C8 FF 5E 5F 5B C9 C3 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_153_0_0 {
	meta:
		name = "_wcstok"
		size = 179
		refs = "0005 __getptd"
	strings:
		$1 = { 55 8B EC 51 E8 ?? ?? ?? ?? 8B 4D 08 89 45 FC 85 C9 75 03 8B 48 1C 0F B7 11 53 56 33 C0 57 8B 7D 0C 66 85 D2 74 30 0F B7 1F 8B C7 66 85 DB 74 12 8B F3 66 3B F2 74 0B 83 C0 02 0F B7 30 66 85 F6 75 F0 33 D2 66 39 10 74 0B 83 C1 02 0F B7 11 66 85 D2 75 D5 33 C0 8B F1 66 39 01 74 41 0F B7 1F 33 D2 8B C7 66 85 DB 74 1E 0F B7 39 89 7D 08 8B 7D 0C 8B D3 66 3B 55 08 74 0B 83 C0 02 0F B7 10 66 85 D2 75 EF 33 D2 66 39 10 75 0A 83 C1 02 66 39 11 75 CE EB 08 33 C0 66 89 01 83 C1 02 8B 45 FC 5F 89 48 1C 8B C6 2B C1 F7 D8 1B C0 23 C6 5E 5B C9 C3 }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "__freopen_helper"
		size = 211
		refs = "0003 __sehtable$__freopen_helper 0008 __SEH_prolog4 001b __errno 0025 __invalid_parameter_noinfo 0071 __SEH_epilog4 007b __lock_file 008b __fclose_nolock 00a6 __openfile 00cd __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 5D 08 85 DB 0F 95 C0 85 C0 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 43 33 FF 89 3B 33 C0 8B 4D 0C 85 C9 0F 95 C0 85 C0 74 DB 33 C0 39 45 10 0F 95 C0 85 C0 74 CF 33 C0 8B 75 14 85 F6 0F 95 C0 85 C0 74 C1 80 39 00 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? C3 89 75 E4 56 E8 ?? ?? ?? ?? 59 89 7D FC F6 46 0C 83 74 07 56 E8 ?? ?? ?? ?? 59 89 7E 08 89 3E 89 7E 0C 89 7E 04 56 FF 75 18 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 10 89 03 C7 45 FC FE FF FF FF E8 10 00 00 00 39 3B 74 AA 33 C0 EB AD 33 FF 8B 5D 08 8B 75 E4 56 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_154_1_0 {
	meta:
		name = "_freopen"
		size = 36
		refs = "0018 __freopen_helper"
	strings:
		$1 = { 55 8B EC 51 83 65 FC 00 6A 40 FF 75 10 8D 45 FC FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 8B 45 FC 83 C4 14 C9 C3 }
	condition:
		$1
}

rule file_998_0_0 {
	meta:
		name = "__wfreopen"
		size = 36
		refs = "0018 __wfreopen_helper"
	strings:
		$1 = { 55 8B EC 51 83 65 FC 00 6A 40 FF 75 10 8D 45 FC FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 8B 45 FC 83 C4 14 C9 C3 }
	condition:
		$1
}

rule file_154_2_0 {
	meta:
		name = "_freopen_s"
		size = 30
		refs = "0015 __freopen_helper"
	strings:
		$1 = { 55 8B EC 68 80 00 00 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_998_2_0 {
	meta:
		name = "__wfreopen_s"
		size = 30
		refs = "0015 __wfreopen_helper"
	strings:
		$1 = { 55 8B EC 68 80 00 00 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_156_0_0 {
	meta:
		name = "__SEH_prolog4_GS"
		size = 72
		refs = "0001 __except_handler4 001e ___security_cookie"
	strings:
		$1 = { 68 ?? ?? ?? ?? 64 FF 35 00 00 00 00 8B 44 24 10 89 6C 24 10 8D 6C 24 10 2B E0 53 56 57 A1 ?? ?? ?? ?? 31 45 FC 33 C5 89 45 E4 50 89 65 E8 FF 75 F8 8B 45 FC C7 45 FC FE FF FF FF 89 45 F8 8D 45 F0 64 A3 00 00 00 00 C3 }
	condition:
		$1
}

rule file_158_0_0 {
	meta:
		name = "__lock"
		size = 52
		refs = "000a __locktable 0013 __mtinitlocknum 001f __amsg_exit 002d __imp__EnterCriticalSection@4"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 83 3C F5 ?? ?? ?? ?? 00 75 13 56 E8 ?? ?? ?? ?? 59 85 C0 75 08 6A 11 E8 ?? ?? ?? ?? 59 FF 34 F5 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 5E 5D C3 }
	condition:
		$1
}

rule file_158_1_0 {
	meta:
		name = "__lockerr_exit"
		size = 32
		refs = "0001 ___crtIsPackagedApp 0010 __imp__FatalAppExitA@8 001a ___crtExitProcess"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 75 0B FF 74 24 04 50 FF 15 ?? ?? ?? ?? 68 FF 00 00 00 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_158_2_0 {
	meta:
		name = "__mtdeletelocks"
		size = 84
		refs = "0003 __locktable 0019 __imp__DeleteCriticalSection@4 001f _free"
	strings:
		$1 = { 56 57 BE ?? ?? ?? ?? 8B FE 53 8B 1F 85 DB 74 17 83 7F 04 01 74 11 53 FF 15 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 83 27 00 59 83 C7 08 81 FF ?? ?? ?? ?? 7C D8 5B 83 3E 00 74 0E 83 7E 04 01 75 08 FF 36 FF 15 ?? ?? ?? ?? 83 C6 08 81 FE ?? ?? ?? ?? 7C E2 5F 5E C3 }
	condition:
		$1
}

rule file_158_3_0 {
	meta:
		name = "__mtinitlocknum"
		size = 167
		refs = "0003 __sehtable$__mtinitlocknum 0008 __SEH_prolog4 000e __crtheap 0016 __FF_MSGBANNER 001d __NMSG_WRITE 0027 ___crtExitProcess 0033 __locktable 003d __malloc_crt 0049 __errno 005a __lock 0075 __imp__InitializeCriticalSectionAndSpinCount@8 0084 _free 0099 __SEH_epilog4 00a1 __unlock"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 18 E8 ?? ?? ?? ?? 6A 1E E8 ?? ?? ?? ?? 68 FF 00 00 00 E8 ?? ?? ?? ?? 59 59 8B 7D 08 83 3C FD ?? ?? ?? ?? 00 75 5B 6A 18 E8 ?? ?? ?? ?? 59 8B F0 85 F6 75 0F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 EB 41 6A 0A E8 ?? ?? ?? ?? 59 83 65 FC 00 83 3C FD ?? ?? ?? ?? 00 75 15 68 A0 0F 00 00 56 FF 15 ?? ?? ?? ?? 89 34 FD ?? ?? ?? ?? EB 07 56 E8 ?? ?? ?? ?? 59 C7 45 FC FE FF FF FF E8 09 00 00 00 33 C0 40 E8 ?? ?? ?? ?? C3 6A 0A E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_158_4_0 {
	meta:
		name = "__mtinitlocks"
		size = 53
		refs = "0003 __locktable 0008 _lclcritsects 0020 __imp__InitializeCriticalSectionAndSpinCount@8"
	strings:
		$1 = { 56 57 BE ?? ?? ?? ?? BF ?? ?? ?? ?? 83 7E 04 01 75 12 89 3E 68 A0 0F 00 00 FF 36 83 C7 18 FF 15 ?? ?? ?? ?? 83 C6 08 81 FE ?? ?? ?? ?? 7C DD 33 C0 5F 40 5E C3 }
	condition:
		$1
}

rule file_158_5_0 {
	meta:
		name = "__unlock"
		size = 21
		refs = "0009 __locktable 000f __imp__LeaveCriticalSection@4"
	strings:
		$1 = { 55 8B EC 8B 45 08 FF 34 C5 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_159_0_0 {
	meta:
		name = "___sse2_atanf4"
		size = 208
		refs = "0012 _static_const_table"
	strings:
		$1 = { 8B C4 81 EC 90 00 00 00 83 E4 F0 89 44 24 54 0F 28 25 ?? ?? ?? ?? 0F 28 DC 0F 55 D8 0F 54 E0 0F 28 3D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F C2 FC 01 0F 28 EF 0F 54 F7 0F 55 FC 0F 56 F7 0F 28 FD 0F 54 E5 0F 55 2D ?? ?? ?? ?? 0F 56 E5 0F 5E F4 0F 28 0D ?? ?? ?? ?? 0F 54 F9 0F 28 CE 0F 59 CE 0F 28 D1 0F 59 D1 0F 28 25 ?? ?? ?? ?? 0F 59 E2 0F 28 05 ?? ?? ?? ?? 0F 59 C2 0F 58 25 ?? ?? ?? ?? 0F 58 05 ?? ?? ?? ?? 0F 59 E2 0F 59 C2 0F 58 25 ?? ?? ?? ?? 0F 58 05 ?? ?? ?? ?? 0F 59 E2 0F 59 C2 0F 58 25 ?? ?? ?? ?? 0F 58 05 ?? ?? ?? ?? 0F 59 E2 0F 59 C1 0F 58 25 ?? ?? ?? ?? 0F 58 C4 0F 59 C6 0F 58 C7 0F 56 C3 8B 64 24 54 C3 8B FF }
	condition:
		$1
}

rule file_160_0_0 {
	meta:
		name = "__chkstk"
		size = 43
	strings:
		$1 = { 51 8D 4C 24 04 2B C8 1B C0 F7 D0 23 C8 8B C4 25 00 F0 FF FF 3B C8 72 0A 8B C1 59 94 8B 00 89 04 24 C3 2D 00 10 00 00 85 00 EB E9 }
	condition:
		$1
}

rule file_161_1_0 {
	meta:
		name = "__wcsdup"
		size = 83
		refs = "0013 _wcslen 001e _calloc 0031 _wcscpy_s 004e __invoke_watson"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 75 04 33 C0 5D C3 53 57 FF 75 08 E8 ?? ?? ?? ?? 8D 78 01 6A 02 57 E8 ?? ?? ?? ?? 8B D8 83 C4 0C 85 DB 74 15 FF 75 08 57 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 0A 8B C3 EB 02 33 C0 5F 5B 5D C3 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_162_0_0 {
	meta:
		name = "__flswbuf"
		size = 367
		refs = "0006 __ioinit 001a __fileno 002a __errno 0086 ___iob_func 009f __isatty 00aa __getbuf 00d8 __write 0105 ___pioinfo 010c ___badioinfo 011c __lseeki64"
	strings:
		$1 = { 55 8B EC 51 51 E8 ?? ?? ?? ?? 85 C0 79 05 83 C8 FF C9 C3 56 8B 75 0C 57 56 E8 ?? ?? ?? ?? 59 8B 4E 0C 8B F8 F6 C1 82 75 0D E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB 10 F6 C1 40 74 19 E8 ?? ?? ?? ?? C7 00 22 00 00 00 83 4E 0C 20 B8 FF FF 00 00 E9 17 01 00 00 53 33 DB F6 C1 01 74 13 89 5E 04 F6 C1 10 74 7F 8B 46 08 83 E1 FE 89 06 89 4E 0C 8B 46 0C 83 E0 EF 83 C8 02 89 46 0C 89 5E 04 A9 0C 01 00 00 75 2A E8 ?? ?? ?? ?? 83 C0 20 3B F0 74 0C E8 ?? ?? ?? ?? 83 C0 40 3B F0 75 0B 57 E8 ?? ?? ?? ?? 59 85 C0 75 07 56 E8 ?? ?? ?? ?? 59 F7 46 0C 08 01 00 00 74 7D 8B 56 08 8B 0E 8D 42 02 89 06 8B 46 18 2B CA 83 E8 02 89 4D FC 89 46 04 85 C9 7E 17 51 52 57 E8 ?? ?? ?? ?? 83 C4 0C 8B D8 EB 47 83 C9 20 89 4E 0C EB 75 83 FF FF 74 1B 83 FF FE 74 16 8B CF 8B C7 83 E1 1F C1 F8 05 C1 E1 06 03 0C 85 ?? ?? ?? ?? EB 05 B9 ?? ?? ?? ?? F6 41 04 20 74 14 6A 02 53 53 57 E8 ?? ?? ?? ?? 23 C2 83 C4 10 83 F8 FF 74 32 8B 46 08 8B 4D 08 66 89 08 EB 22 8B 45 08 66 89 45 F8 6A 02 8D 45 F8 50 57 C7 45 FC 02 00 00 00 E8 ?? ?? ?? ?? 8B 4D 08 83 C4 0C 8B D8 3B 5D FC 74 0B 83 4E 0C 20 B8 FF FF 00 00 EB 03 0F B7 C1 5B 5F 5E C9 C3 }
	condition:
		$1
}

rule file_163_0_0 {
	meta:
		name = "_strcmp"
		size = 140
	strings:
		$1 = { 8B 54 24 04 8B 4C 24 08 F7 C2 03 00 00 00 75 40 8B 02 3A 01 75 32 84 C0 74 26 3A 61 01 75 29 84 E4 74 1D C1 E8 10 3A 41 02 75 1D 84 C0 74 11 3A 61 03 75 14 83 C1 04 83 C2 04 84 E4 75 D2 8B FF 33 C0 C3 EB 03 CC CC CC 1B C0 83 C8 01 C3 8B FF F7 C2 01 00 00 00 74 18 8A 02 83 C2 01 3A 01 75 E7 83 C1 01 84 C0 74 D8 F7 C2 02 00 00 00 74 A0 66 8B 02 83 C2 02 3A 01 75 CE 84 C0 74 C2 3A 61 01 75 C5 84 E4 74 B9 83 C1 02 EB 84 }
	condition:
		$1
}

rule file_164_0_0 {
	meta:
		name = "__futime64"
		size = 454
		refs = "0007 ___security_cookie 001e __errno 002e __ioinit 0044 __nhandle 0058 ___pioinfo 0076 __time64 0093 __localtime64_s 00f1 __imp__SystemTimeToFileTime@8 0103 __imp__LocalFileTimeToFileTime@8 018d __get_osfhandle 0195 __imp__SetFileTime@16 01b1 __invalid_parameter_noinfo 01c0 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 60 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 8B 75 08 57 8B 7D 0C 83 FE FE 75 10 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E9 88 01 00 00 E8 ?? ?? ?? ?? 85 C0 0F 88 7B 01 00 00 85 F6 0F 88 63 01 00 00 3B 35 ?? ?? ?? ?? 0F 83 57 01 00 00 8B C6 C1 F8 05 8B CE 8B 04 85 ?? ?? ?? ?? 83 E1 1F C1 E1 06 F6 44 08 04 01 0F 84 38 01 00 00 85 FF 75 19 8D 45 C0 50 E8 ?? ?? ?? ?? 8B 45 C0 89 45 B8 8B 45 C4 59 89 45 BC 8D 7D B8 8D 47 08 50 8D 45 C8 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 08 01 00 00 8B 45 DC 05 6C 07 00 00 66 89 45 EC 8B 45 D8 40 66 89 45 EE 66 8B 45 D4 66 89 45 F2 66 8B 45 D0 66 89 45 F4 66 8B 45 CC 66 89 45 F6 66 8B 45 C8 66 89 45 F8 33 C0 66 89 45 FA 8D 45 B0 50 8D 45 EC 50 FF 15 ?? ?? ?? ?? 85 C0 74 A4 8D 45 A0 50 8D 45 B0 50 FF 15 ?? ?? ?? ?? 85 C0 74 92 8D 45 C8 57 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 82 8B 45 DC 05 6C 07 00 00 66 89 45 EC 8B 45 D8 40 66 89 45 EE 66 8B 45 D4 66 89 45 F2 66 8B 45 D0 66 89 45 F4 66 8B 45 CC 66 89 45 F6 66 8B 45 C8 66 89 45 F8 33 C0 66 89 45 FA 8D 45 B0 50 8D 45 EC 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 32 FF FF FF 8D 45 A8 50 8D 45 B0 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 1C FF FF FF 8D 45 A0 50 8D 45 A8 50 6A 00 56 E8 ?? ?? ?? ?? 59 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 FC FE FF FF 33 C0 EB 13 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_165_0_0 {
	meta:
		name = "__wstrtime"
		size = 26
		refs = "0009 __wstrtime_s"
	strings:
		$1 = { 55 8B EC 6A 09 FF 75 08 E8 ?? ?? ?? ?? F7 D8 1B C0 59 F7 D0 23 45 08 59 5D C3 }
	condition:
		$1
}

rule file_832_0_0 {
	meta:
		name = "__strdate"
		size = 26
		refs = "0009 __strdate_s"
	strings:
		$1 = { 55 8B EC 6A 09 FF 75 08 E8 ?? ?? ?? ?? F7 D8 1B C0 59 F7 D0 23 45 08 59 5D C3 }
	condition:
		$1
}

rule file_511_0_0 {
	meta:
		name = "__strtime"
		size = 26
		refs = "0009 __strtime_s"
	strings:
		$1 = { 55 8B EC 6A 09 FF 75 08 E8 ?? ?? ?? ?? F7 D8 1B C0 59 F7 D0 23 45 08 59 5D C3 }
	condition:
		$1
}

rule file_355_0_0 {
	meta:
		name = "__wstrdate"
		size = 26
		refs = "0009 __wstrdate_s"
	strings:
		$1 = { 55 8B EC 6A 09 FF 75 08 E8 ?? ?? ?? ?? F7 D8 1B C0 59 F7 D0 23 45 08 59 5D C3 }
	condition:
		$1
}

rule file_165_1_0 {
	meta:
		name = "__wstrtime_s"
		size = 191
		refs = "0007 ___security_cookie 002f __errno 003e __imp__GetLocalTime@4 00ab __invalid_parameter_noinfo 00b9 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 08 56 85 DB 0F 84 83 00 00 00 83 7D 0C 00 76 7D 33 C0 83 7D 0C 09 66 89 03 73 09 E8 ?? ?? ?? ?? 6A 22 EB 70 57 8D 45 EC 50 FF 15 ?? ?? ?? ?? 0F B7 45 F4 6A 3A 59 99 66 89 4B 0A 66 89 4B 04 33 C9 6A 0A 66 89 4B 10 59 F7 F9 0F B7 75 F6 6A 0A 0F B7 7D F8 83 C0 30 66 89 03 8D 4A 30 8B C6 99 5E F7 FE 66 89 4B 02 83 C0 30 66 89 43 06 8D 4A 30 8B C7 99 F7 FE 66 89 4B 08 5F 83 C0 30 66 89 43 0C 8D 42 30 66 89 43 0E 33 C0 EB 11 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 8B 4D FC 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_166_4_0 {
	meta:
		name = "__mbctoupper_l"
		size = 149
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0056 ___crtLCMapStringA"
	strings:
		$1 = { 55 8B EC 83 EC 18 8D 4D E8 53 FF 75 0C E8 ?? ?? ?? ?? 8B 5D 08 81 FB FF 00 00 00 76 54 8B 4D EC 8B C3 C1 E8 08 88 45 FC 0F B6 C0 88 5D FD F6 44 08 19 04 74 4E 6A 01 FF 71 04 8D 45 F8 6A 02 50 6A 02 8D 45 FC 50 68 00 02 00 00 FF B1 1C 02 00 00 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 24 85 C0 74 22 8B 45 F8 0F B6 D8 0F B6 C4 C1 E3 08 03 D8 EB 12 8B 45 EC F6 44 18 19 20 74 08 0F B6 9C 18 19 01 00 00 80 7D F4 00 74 07 8B 4D F0 83 61 70 FD 8B C3 5B C9 C3 }
	condition:
		$1
}

rule file_167_0_0 {
	meta:
		name = "___avx_coshf8"
		size = 384
		refs = "0010 ___common_scosh_data 0173 ___common_scosh_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FC 10 0D ?? ?? ?? ?? C5 FC 10 1D ?? ?? ?? ?? C5 F8 10 15 ?? ?? ?? ?? C5 FC 28 F0 C5 F4 55 E6 C5 DC 59 2D ?? ?? ?? ?? C5 FC 11 74 24 20 C5 F8 10 05 ?? ?? ?? ?? C5 D4 58 EB C5 D9 66 FA C4 E3 7D 19 E1 01 C5 D9 76 F2 C5 C1 EB F6 C5 F1 66 FA C5 F1 76 D2 C5 C1 EB FA C5 C9 6B CF C5 C9 EF F6 C5 F1 63 FE C5 D4 5C F3 C5 F9 D7 D7 C5 CC 59 1D ?? ?? ?? ?? C5 DC 5C FB C5 CC 59 25 ?? ?? ?? ?? C5 C4 5C F4 C5 CC 59 FE 0F B6 C2 C5 E9 72 F5 17 C4 E3 7D 19 EB 01 C5 F9 FE CA C5 E1 72 F3 17 C5 F9 FA D2 C5 F9 FE EB C5 F9 FA C3 C4 E3 75 18 E5 01 C5 C4 59 0D ?? ?? ?? ?? C5 F4 58 1D ?? ?? ?? ?? C4 E3 6D 18 C0 01 C5 C4 59 15 ?? ?? ?? ?? C5 DC 5C E8 C5 DC 58 C0 C5 E4 59 E7 C5 EC 58 1D ?? ?? ?? ?? C5 DC 59 CE C5 E4 59 E7 C5 F4 58 F6 C5 DC 58 0D ?? ?? ?? ?? C5 D4 59 EE C5 F4 59 FF C5 C4 59 C8 C5 D4 58 F1 C5 CC 58 C0 85 C0 75 04 8B E5 5D C3 C5 FC 10 4C 24 20 C5 FC 11 84 24 80 00 00 00 C5 FC 11 4C 24 40 85 D2 74 E3 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FC 10 84 24 80 00 00 00 EB B9 C5 F8 77 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE 8D 64 24 00 }
	condition:
		$1
}

rule file_168_1_0 {
	meta:
		name = "__wsetargv"
		size = 172
		refs = "000e ?_pgmname@?1??_wsetargv@@9@9 0020 __imp__GetModuleFileNameW@12 0026 __wcmdln 002c __wpgmptr 0047 _wparse_cmdline 0070 __malloc_crt 0096 ___argc 009c ___wargv"
	strings:
		$1 = { 55 8B EC 51 51 53 56 57 68 04 01 00 00 BB ?? ?? ?? ?? 53 33 C0 33 FF 57 66 A3 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 85 F6 74 05 66 39 3E 75 02 8B F3 8D 45 F8 50 8D 45 FC 50 57 57 56 E8 ?? ?? ?? ?? 8B 5D FC 83 C4 14 81 FB FF FF FF 3F 73 4B 8B 45 F8 3D FF FF FF 7F 73 41 8D 0C 58 03 C9 03 C0 3B C8 72 36 51 E8 ?? ?? ?? ?? 8B F8 59 85 FF 74 29 8D 45 F8 50 8D 45 FC 50 8D 04 9F 50 57 56 E8 ?? ?? ?? ?? 8B 45 FC 83 C4 14 48 A3 ?? ?? ?? ?? 89 3D ?? ?? ?? ?? 33 C0 EB 03 83 C8 FF 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_168_2_0 {
	meta:
		name = "_wparse_cmdline"
		size = 397
	strings:
		$1 = { 55 8B EC 51 51 8B 45 14 8B 4D 08 8B 55 10 53 8B 5D 18 56 8B 75 0C 57 33 FF 89 3B C7 00 01 00 00 00 85 F6 74 08 89 16 83 C6 04 89 75 0C C7 45 08 20 00 00 00 C7 45 FC 09 00 00 00 6A 22 58 66 39 01 75 11 33 C0 85 FF 0F 94 C0 6A 22 83 C1 02 8B F8 58 EB 1A FF 03 85 D2 74 09 66 8B 01 66 89 02 83 C2 02 0F B7 01 83 C1 02 66 85 C0 74 1C 85 FF 75 C9 66 3B 45 08 74 06 66 3B 45 FC 75 BD 85 D2 74 0B 33 C0 66 89 42 FE EB 03 83 E9 02 8B 7D 18 33 DB 89 5D F8 66 39 19 0F 84 DF 00 00 00 0F B7 01 66 3B 45 08 74 06 66 3B 45 FC 75 05 83 C1 02 EB EC 66 39 19 0F 84 C2 00 00 00 85 F6 74 08 89 16 83 C6 04 89 75 0C 8B 45 14 8B 75 F8 FF 00 6A 5C C7 45 F8 01 00 00 00 58 EB 04 83 C1 02 43 66 39 01 74 F7 6A 22 58 66 39 01 6A 5C 58 75 3B F6 C3 01 75 25 85 F6 74 11 6A 22 5F 66 39 79 02 8B 7D 18 75 05 83 C1 02 EB 0D 83 65 F8 00 33 C0 85 F6 0F 94 C0 8B F0 6A 5C 58 D1 EB EB 0D 4B 85 D2 74 06 66 89 02 83 C2 02 FF 07 85 DB 75 EF 0F B7 01 66 85 C0 74 2C 85 F6 75 0C 66 3B 45 08 74 22 66 3B 45 FC 74 1C 83 7D F8 00 74 0C 85 D2 74 06 66 89 02 83 C2 02 FF 07 83 C1 02 33 DB E9 6D FF FF FF 89 75 F8 8B 75 0C 85 D2 74 08 33 C0 66 89 02 83 C2 02 FF 07 33 DB E9 18 FF FF FF 85 F6 74 02 89 1E 8B 45 14 5F FF 00 5E 5B C9 C3 }
	condition:
		$1
}

rule file_169_2_0 {
	meta:
		name = "__vsnprintf_helper"
		size = 200
		refs = "001b __errno 0026 __invalid_parameter_noinfo 00a4 __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 20 83 65 E0 00 57 6A 07 33 C0 59 8D 7D E4 F3 AB 39 45 14 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 93 00 00 00 8B 7D 0C 56 8B 75 10 85 F6 74 19 85 FF 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 6E B8 FF FF FF 7F 89 45 E4 3B F0 77 03 89 75 E4 53 FF 75 1C 8D 45 E0 FF 75 18 C7 45 EC 42 00 00 00 FF 75 14 89 7D E8 50 89 7D E0 FF 55 08 83 C4 10 8B D8 85 FF 74 37 85 DB 78 23 FF 4D E4 78 08 8B 45 E0 C6 00 00 EB 12 8D 45 E0 50 6A 00 E8 ?? ?? ?? ?? 59 59 83 F8 FF 74 04 8B C3 EB 10 33 C0 39 45 E4 C6 44 37 FF 00 0F 9D C0 83 E8 02 5B 5E 5F C9 C3 }
	condition:
		$1
}

rule file_169_4_0 {
	meta:
		name = "__vsnprintf_s_l"
		size = 251
		refs = "000b __errno 0016 __invalid_parameter_noinfo 006d __output_s_l 0072 __vsnprintf_helper"
	strings:
		$1 = { 55 8B EC 51 83 7D 14 00 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF C9 C3 53 56 8B 75 08 57 8B 7D 10 85 FF 75 14 85 F6 75 18 39 75 0C 0F 85 AA 00 00 00 33 C0 E9 B6 00 00 00 85 F6 0F 84 9B 00 00 00 8B 5D 0C 85 DB 0F 84 90 00 00 00 E8 ?? ?? ?? ?? FF 75 1C FF 75 18 FF 75 14 3B DF 76 2C 8B 18 8D 47 01 50 56 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 83 F8 FE 75 4C E8 ?? ?? ?? ?? 83 38 22 75 6B E8 ?? ?? ?? ?? 89 18 EB 62 8B 00 53 56 68 ?? ?? ?? ?? 89 45 FC E8 ?? ?? ?? ?? 83 C4 18 C6 44 1E FF 00 83 F8 FE 75 1B 83 FF FF 75 1A E8 ?? ?? ?? ?? 83 38 22 75 35 E8 ?? ?? ?? ?? 8B 4D FC 89 08 EB 29 85 C0 79 28 C6 06 00 83 F8 FE 75 1D E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 0B E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_169_7_0 {
	meta:
		name = "__vsprintf_s_l"
		size = 117
		refs = "000a __errno 0015 __invalid_parameter_noinfo 003a __output_s_l 003f __vsnprintf_helper"
	strings:
		$1 = { 55 8B EC 83 7D 10 00 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 56 8B 75 08 85 F6 74 39 83 7D 0C 00 76 33 FF 75 18 FF 75 14 FF 75 10 FF 75 0C 56 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 85 C0 79 03 C6 06 00 83 F8 FE 75 20 E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 0B E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5E 5D C3 }
	condition:
		$1
}

rule file_172_0_0 {
	meta:
		name = "__j0"
		size = 362
		refs = "0020 __real@401e000000000000 0030 _J0p 0051 _J0q 007b __real@4020000000000000 0080 _P0p 00aa _P0q 00cb _Q0p 00f1 _Q0q 011e __real@3fe921fb54442d18 0129 _cos 013a _sin 0151 __real@400921fb54442d18 0157 __real@4000000000000000 015f _sqrt"
	strings:
		$1 = { 55 8B EC 83 EC 20 D9 EE DD 45 08 DD 55 F8 D8 D1 DF E0 DD D9 F6 C4 05 7A 05 D9 E0 DD 55 F8 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 75 4C DC C8 B8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 D8 C9 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D9 C1 DC 0D ?? ?? ?? ?? DC 00 83 E8 08 D8 CA 3D ?? ?? ?? ?? 7F F2 DD DA DD 05 ?? ?? ?? ?? DE C2 DE F1 C9 C3 DD 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D8 F1 DD 55 E8 D9 C0 DE C9 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 D8 C9 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D9 C1 DC 0D ?? ?? ?? ?? DC 00 83 E8 08 D8 CA 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? DE F9 DD 5D 08 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 D8 C9 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D9 C1 DC 0D ?? ?? ?? ?? DC 00 83 E8 08 D8 CA 3D ?? ?? ?? ?? 7F F2 DD DA 51 DD 05 ?? ?? ?? ?? 51 DE C2 DE F1 DD 5D E0 DC 25 ?? ?? ?? ?? DD 55 F0 DD 1C 24 E8 ?? ?? ?? ?? DC 4D 08 DD 5D 08 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DD 45 E8 DC 4D E0 DE C9 DC 6D 08 DD 5D 08 DD 45 F8 DC 0D ?? ?? ?? ?? DC 3D ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? DC 4D 08 59 59 C9 C3 }
	condition:
		$1
}

rule file_172_1_0 {
	meta:
		name = "__j1"
		size = 397
		refs = "002b __real@401e000000000000 003b _J1p 005e _J1q 0095 __real@4020000000000000 009a _P1p 00c4 _P1q 00e5 _Q1p 010b _Q1q 0138 __real@4002d97c7f3321d2 0143 _cos 0154 _sin 016b __real@400921fb54442d18 0171 __real@4000000000000000 0179 _sqrt"
	strings:
		$1 = { 55 8B EC 83 EC 24 D9 EE C7 45 FC 01 00 00 00 DD 45 08 DD 55 F4 D8 D1 DF E0 DD D9 F6 C4 05 7A 09 83 4D FC FF D9 E0 DD 55 F4 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 75 5B D9 C0 B8 ?? ?? ?? ?? D8 C9 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 D8 C9 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D9 C1 DC 0D ?? ?? ?? ?? DC 00 83 E8 08 D8 CA 3D ?? ?? ?? ?? 7F F2 DD DA DD 05 ?? ?? ?? ?? DE C2 DE F1 DB 45 FC DD 5D 08 DD 45 08 DE CA DE C9 C9 C3 DD 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D8 F1 DD 55 E4 D9 C0 DE C9 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 D8 C9 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D9 C1 DC 0D ?? ?? ?? ?? DC 00 83 E8 08 D8 CA 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? DE F9 DD 5D 08 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 D8 C9 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D9 C1 DC 0D ?? ?? ?? ?? DC 00 83 E8 08 D8 CA 3D ?? ?? ?? ?? 7F F2 DD DA 51 DD 05 ?? ?? ?? ?? 51 DE C2 DE F1 DD 5D DC DC 25 ?? ?? ?? ?? DD 55 EC DD 1C 24 E8 ?? ?? ?? ?? DC 4D 08 DD 5D 08 DD 45 EC DD 1C 24 E8 ?? ?? ?? ?? DD 45 E4 DC 4D DC DE C9 DC 6D 08 DD 5D 08 DD 45 F4 DC 0D ?? ?? ?? ?? DC 3D ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? DB 45 FC 59 59 DD 5D DC DC 4D DC DC 4D 08 C9 C3 }
	condition:
		$1
}

rule file_172_2_0 {
	meta:
		name = "__jn"
		size = 379
		refs = "0025 __j0 0039 __j1 0068 _fabs"
	strings:
		$1 = { 55 8B EC DD 45 0C 83 EC 18 56 8B 75 08 85 F6 79 07 F7 DE D9 E0 89 75 08 DD 55 F8 85 F6 75 0F 51 51 DD 1C 24 E8 ?? ?? ?? ?? E9 25 01 00 00 83 FE 01 75 0F 51 51 DD 1C 24 E8 ?? ?? ?? ?? E9 11 01 00 00 D9 EE DD E1 DF E0 F6 C4 44 7A 07 DD D9 E9 01 01 00 00 DD D8 51 DB 45 08 51 DD 5D F0 DD 45 F0 DD 5D F0 DD 1C 24 E8 ?? ?? ?? ?? DC 5D F0 59 03 F6 59 DF E0 DD 45 F8 F6 C4 41 75 5F 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 5D F0 DD 45 F8 DD 1C 24 E8 ?? ?? ?? ?? D9 C0 59 D8 C1 59 DD 45 F8 6A 04 58 DC F9 89 45 FC DD 45 F0 DE EA 3B F0 75 0A DD D8 EB 9A D9 C9 D9 CA D9 C9 D9 C1 83 C0 02 DB 45 FC 89 45 FC DD 5D F0 DD 45 F0 DE CB D9 CA D8 F1 DE E3 3B C6 75 DD DD D8 DD D8 EB 79 8D 46 24 D9 C0 89 75 08 D8 C9 89 45 FC 3B C6 7E 1D D9 EE DB 45 FC 83 E8 02 89 45 FC DD 5D F0 DC 6D F0 D9 C1 DE F1 3B C6 7F E9 DD D9 EB 04 DD D8 D9 EE DB 45 08 83 C6 FE 89 75 FC 4E DD 5D F0 4E DC 6D F0 D9 C1 DE F1 DD 55 E8 D9 E8 DB 45 FC 89 75 FC DD 5D F0 DD 45 F0 D8 F3 DE E2 D9 C9 DD 55 F0 75 1B DD D8 DD D8 51 51 DD 1C 24 E8 ?? ?? ?? ?? DC 4D E8 DC 75 F0 59 59 5E C9 C3 D9 C9 D9 C0 4E DB 45 FC 4E 89 75 FC DD 5D F0 DD 45 F0 DE CA D9 C9 D8 F3 DE E2 75 E4 DD D8 DD 5D F0 EB C8 }
	condition:
		$1
}

rule file_172_3_0 {
	meta:
		name = "__y0"
		size = 426
		refs = "0018 __d_ind 0029 _domain_err 0034 __real@401e000000000000 0044 _Y0p 0067 _Y0q 0096 __j0 009c __real@3fe45f306dc9c883 00aa _log 00bb __real@4020000000000000 00c0 _P0p 00ea _P0q 010b _Q0p 0131 _Q0q 015e __real@3fe921fb54442d18 0169 _cos 017f _sin 0191 __real@400921fb54442d18 0197 __real@4000000000000000 019f _sqrt"
	strings:
		$1 = { 55 8B EC D9 EE 83 EC 20 DD 45 08 D8 D1 DF E0 DD D9 F6 C4 05 7A 1C DD 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 1C 24 6A 22 E8 ?? ?? ?? ?? 83 C4 14 C9 C3 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 75 78 D9 C0 B8 ?? ?? ?? ?? D8 C9 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 D8 C9 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D9 C1 DC 0D ?? ?? ?? ?? DC 00 83 E8 08 D8 CA 3D ?? ?? ?? ?? 7F F2 DD DA 51 DD 05 ?? ?? ?? ?? 51 DE C2 DE F1 DD 5D F0 DD 1C 24 E8 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? DD 5D F8 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? DC 4D F8 DC 45 F0 E9 ED 00 00 00 DD 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D8 F1 DD 55 F0 D9 C0 DE C9 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 D8 C9 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D9 C1 DC 0D ?? ?? ?? ?? DC 00 83 E8 08 D8 CA 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? DE F9 DD 5D E0 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 D8 C9 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D9 C1 DC 0D ?? ?? ?? ?? DC 00 83 E8 08 D8 CA 3D ?? ?? ?? ?? 7F F2 DD DA 51 DD 05 ?? ?? ?? ?? 51 DE C2 DE F1 DD 5D F8 DC 25 ?? ?? ?? ?? DD 55 E8 DD 1C 24 E8 ?? ?? ?? ?? DD 45 F0 DC 4D F8 DE C9 DD 5D F0 DD 45 E8 DD 1C 24 E8 ?? ?? ?? ?? DC 4D E0 DC 45 F0 DD 5D E0 DD 45 08 DC 0D ?? ?? ?? ?? DC 3D ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? DC 4D E0 59 59 C9 C3 }
	condition:
		$1
}

rule file_172_4_0 {
	meta:
		name = "__y1"
		size = 445
		refs = "0018 __d_ind 0029 _domain_err 0034 __real@401e000000000000 0048 _Y1p 006b _Y1q 009a __j1 00a8 _log 00bc __real@3fe45f306dc9c883 00ce __real@4020000000000000 00d3 _P1p 00fd _P1q 011e _Q1p 0144 _Q1q 0171 __real@4002d97c7f3321d2 017c _cos 0192 _sin 01a4 __real@400921fb54442d18 01aa __real@4000000000000000 01b2 _sqrt"
	strings:
		$1 = { 55 8B EC D9 EE 83 EC 20 DD 45 08 D8 D1 DF E0 DD D9 F6 C4 05 7A 1C DD 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 1C 24 6A 23 E8 ?? ?? ?? ?? 83 C4 14 C9 C3 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 0F 85 87 00 00 00 D9 C0 B8 ?? ?? ?? ?? D8 C9 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 D8 C9 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D9 C1 DC 0D ?? ?? ?? ?? DC 00 83 E8 08 D8 CA 3D ?? ?? ?? ?? 7F F2 DD DA 51 DD 05 ?? ?? ?? ?? 51 DE C2 DE F1 DD 5D F0 DD 1C 24 E8 ?? ?? ?? ?? DD 5D F8 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? DC 4D F8 D9 E8 DD 45 08 DC F9 D9 CA DE E1 DC 0D ?? ?? ?? ?? DD 45 F0 DE CA DE C1 E9 ED 00 00 00 DD 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D8 F1 DD 55 F0 D9 C0 DE C9 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 D8 C9 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D9 C1 DC 0D ?? ?? ?? ?? DC 00 83 E8 08 D8 CA 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? DE F9 DD 5D E0 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 D8 C9 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D9 C1 DC 0D ?? ?? ?? ?? DC 00 83 E8 08 D8 CA 3D ?? ?? ?? ?? 7F F2 DD DA 51 DD 05 ?? ?? ?? ?? 51 DE C2 DE F1 DD 5D F8 DC 25 ?? ?? ?? ?? DD 55 E8 DD 1C 24 E8 ?? ?? ?? ?? DD 45 F0 DC 4D F8 DE C9 DD 5D F0 DD 45 E8 DD 1C 24 E8 ?? ?? ?? ?? DC 4D E0 DC 45 F0 DD 5D E0 DD 45 08 DC 0D ?? ?? ?? ?? DC 3D ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? DC 4D E0 59 59 C9 C3 }
	condition:
		$1
}

rule file_172_5_0 {
	meta:
		name = "__yn"
		size = 221
		refs = "0018 __d_ind 0029 _domain_err 0056 __y0 006c __y1 0092 __real@4000000000000000"
	strings:
		$1 = { 55 8B EC D9 EE 83 EC 0C DD 45 0C D8 D1 DF E0 DD D9 F6 C4 05 7A 1C DD 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 1C 24 6A 24 E8 ?? ?? ?? ?? 83 C4 14 C9 C3 53 8B 5D 08 56 33 F6 46 89 75 FC 85 DB 79 0D F7 DB F6 C3 01 74 04 83 4D FC FF 85 DB 51 51 DD 1C 24 75 12 E8 ?? ?? ?? ?? DB 45 FC 59 59 DD 5D 0C DC 4D 0C EB 4B 3B DE 75 12 E8 ?? ?? ?? ?? DB 45 FC 59 59 DD 5D 0C DC 4D 0C EB 35 E8 ?? ?? ?? ?? DD 5D F4 DD 45 0C DD 1C 24 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 DC 75 0C 59 89 75 10 3B DE 7F 16 DD D9 DD D8 DD 45 0C DB 45 FC DD 5D 0C DC 4D 0C 5E 5B C9 C3 DD DA DB 45 10 46 DD 5D 0C DD 45 0C 89 75 10 D8 C9 D8 CA DC 65 F4 D9 CA DD 5D F4 D9 C1 3B F3 7C DF DD D8 DD D8 EB CC }
	condition:
		$1
}

rule file_172_6_0 {
	meta:
		name = "_domain_err"
		size = 52
		refs = "000e __ctrlfp 002b __except1"
	strings:
		$1 = { 55 8B EC 68 FF FF 00 00 68 3F 13 00 00 E8 ?? ?? ?? ?? DD 45 14 59 59 50 83 EC 10 DD 5C 24 08 DD 45 0C DD 1C 24 FF 75 08 6A 08 E8 ?? ?? ?? ?? 83 C4 1C 5D C3 }
	condition:
		$1
}

rule file_172_7_0 {
	meta:
		name = "_evaluate"
		size = 86
		refs = "004a __invalid_parameter_noinfo 0050 __real@bff0000000000000"
	strings:
		$1 = { 55 8B EC 8B 45 14 85 C0 7E 3F 8B 4D 1C 85 C9 7E 38 8B 55 10 DD 04 C2 DD 45 08 EB 05 DD 04 C2 DE C2 48 DC C9 85 C0 7F F4 DD 02 8B 55 18 DE C2 8D 41 FF DD 04 CA D8 C9 85 C0 7E 06 DC 04 C2 48 EB F4 DD D9 DC 02 DE F9 5D C3 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_173_2_0 {
	meta:
		name = "__getch"
		size = 66
		refs = "0003 __sehtable$__getch 0008 __SEH_prolog4 000f __lock 0019 __getch_nolock 0031 __SEH_epilog4 003c __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 03 E8 ?? ?? ?? ?? 59 83 65 FC 00 E8 ?? ?? ?? ?? 8B F0 89 75 E4 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 75 E4 6A 03 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_173_4_0 {
	meta:
		name = "__getche"
		size = 66
		refs = "0003 __sehtable$__getche 0008 __SEH_prolog4 000f __lock 0019 __getche_nolock 0031 __SEH_epilog4 003c __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 03 E8 ?? ?? ?? ?? 59 83 65 FC 00 E8 ?? ?? ?? ?? 8B F0 89 75 E4 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 75 E4 6A 03 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_173_7_0 {
	meta:
		name = "__kbhit"
		size = 66
		refs = "0003 __sehtable$__kbhit 0008 __SEH_prolog4 000f __lock 0019 __kbhit_nolock 0031 __SEH_epilog4 003c __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 03 E8 ?? ?? ?? ?? 59 83 65 FC 00 E8 ?? ?? ?? ?? 8B F0 89 75 E4 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 75 E4 6A 03 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_173_3_0 {
	meta:
		name = "__getch_nolock"
		size = 219
		refs = "0007 ___security_cookie 0011 _chbuf 002d __coninpfh 0037 ___initconin 0051 __imp__GetConsoleMode@8 005f __imp__SetConsoleMode@8 0065 __imp__ReadConsoleInputA@16 008a __getextendedkeycode 00c7 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 20 A1 ?? ?? ?? ?? 33 C5 89 45 FC A1 ?? ?? ?? ?? 53 83 CB FF 3B C3 74 0E 0F B6 C0 89 1D ?? ?? ?? ?? E9 95 00 00 00 8B 0D ?? ?? ?? ?? 83 F9 FE 75 0B E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 3B CB 75 04 8B C3 EB 77 56 8D 45 E0 50 51 FF 15 ?? ?? ?? ?? 6A 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? EB 28 83 7D E4 00 74 3A 66 39 75 E8 75 1F 83 7D EC 00 74 19 0F B6 75 F6 85 F6 75 29 8D 45 EC 50 E8 ?? ?? ?? ?? 59 85 C0 75 3A 33 F6 46 8D 45 E4 50 56 8D 45 E8 50 FF 35 ?? ?? ?? ?? FF D3 85 C0 75 C0 83 CE FF FF 75 E0 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B C6 5E 8B 4D FC 33 CD 5B E8 ?? ?? ?? ?? C9 C3 0F B6 30 0F B6 40 01 A3 ?? ?? ?? ?? EB D3 }
	condition:
		$1
}

rule file_173_5_0 {
	meta:
		name = "__getche_nolock"
		size = 54
		refs = "0001 _chbuf 001a __getch_nolock 0026 __putch_nolock"
	strings:
		$1 = { A1 ?? ?? ?? ?? 57 83 CF FF 3B C7 74 0B 89 3D ?? ?? ?? ?? 0F B6 C0 5F C3 56 E8 ?? ?? ?? ?? 8B F0 3B F7 74 0D 56 E8 ?? ?? ?? ?? 3B C7 59 8B C6 75 02 8B C7 5E 5F C3 }
	condition:
		$1
}

rule file_173_6_0 {
	meta:
		name = "__getextendedkeycode"
		size = 173
		refs = "0020 _EnhancedKeys 006d _NormalKeys"
	strings:
		$1 = { 55 8B EC 8B 55 08 56 8B 4A 0C 57 F7 C1 00 01 00 00 74 4E 0F B7 7A 08 33 C0 8B F0 8B D0 66 39 BA ?? ?? ?? ?? 74 0B 83 C2 0A 46 83 FA 78 72 EE EB 78 8B C6 6B C0 0A F6 C1 03 74 07 05 ?? ?? ?? ?? EB 67 F6 C1 0C 74 07 05 ?? ?? ?? ?? EB 5B F6 C1 10 74 07 05 ?? ?? ?? ?? EB 4F 05 ?? ?? ?? ?? EB 48 0F B7 42 08 F6 C1 03 74 09 8D 04 C5 ?? ?? ?? ?? EB 23 F6 C1 0C 74 09 8D 04 C5 ?? ?? ?? ?? EB 15 F6 C1 10 74 09 8D 04 C5 ?? ?? ?? ?? EB 07 8D 04 C5 ?? ?? ?? ?? 8A 08 84 C9 74 05 80 F9 E0 75 06 80 78 01 00 75 02 33 C0 5F 5E 5D C3 }
	condition:
		$1
}

rule file_173_8_0 {
	meta:
		name = "__kbhit_nolock"
		size = 315
		refs = "0007 ___security_cookie 0015 _chbuf 002a __coninpfh 0034 ___initconin 004d __imp__GetNumberOfConsoleInputEvents@8 0080 __alloca_probe_16 0098 _malloc 00c9 __imp__PeekConsoleInputA@16 00fa __getextendedkeycode 011e __freea 0135 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 33 DB 83 3D ?? ?? ?? ?? FF 56 57 89 5D F0 74 08 33 C0 40 E9 00 01 00 00 A1 ?? ?? ?? ?? 83 F8 FE 75 0A E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 F8 FF 0F 84 E1 00 00 00 8D 4D F8 51 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 CE 00 00 00 8B 7D F8 85 FF 0F 84 C3 00 00 00 6A E0 33 D2 58 F7 F7 83 F8 14 72 45 8B C7 6B C0 14 83 C0 08 3D 00 04 00 00 77 17 E8 ?? ?? ?? ?? 8B F4 85 F6 0F 84 99 00 00 00 C7 06 CC CC 00 00 EB 17 50 E8 ?? ?? ?? ?? 8B F0 59 85 F6 0F 84 80 00 00 00 C7 06 DD DD 00 00 8B 7D F8 83 C6 08 EB 02 33 F6 85 F6 74 6C 8D 45 F4 50 57 56 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 4B 8B 7D F4 85 FF 74 44 3B 7D F8 77 3F 85 FF 74 3B 33 C0 8D 5E 04 40 66 39 43 FC 75 21 83 3B 00 74 1C 80 7B 0A 00 75 0E 53 E8 ?? ?? ?? ?? 59 85 C0 74 08 33 C0 40 89 45 F0 EB 03 33 C0 40 4F 83 C3 14 89 7D F4 85 FF 75 CE 8B 5D F0 56 E8 ?? ?? ?? ?? 59 8B C3 EB 02 33 C0 8D 65 E4 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_173_10_0 {
	meta:
		name = "__ungetch_nolock"
		size = 35
		refs = "000d _chbuf"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 F8 FF 74 13 83 3D ?? ?? ?? ?? FF 75 0A 0F B6 C0 A3 ?? ?? ?? ?? 5D C3 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_174_0_0 {
	meta:
		name = "_log"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __log_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_1175_0_0 {
	meta:
		name = "_acos"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __acos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_896_0_0 {
	meta:
		name = "_asin"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __asin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_1094_0_0 {
	meta:
		name = "_atan"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __atan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_743_0_0 {
	meta:
		name = "_cos"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __cos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_1012_0_0 {
	meta:
		name = "_log10"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __log10_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_480_0_0 {
	meta:
		name = "_sin"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __sin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_888_0_0 {
	meta:
		name = "_tan"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __tan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_174_1_0 {
	meta:
		name = "__CIlog"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIlog_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1175_1_0 {
	meta:
		name = "__CIacos"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIacos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_896_1_0 {
	meta:
		name = "__CIasin"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIasin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1094_1_0 {
	meta:
		name = "__CIatan"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIatan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_743_1_0 {
	meta:
		name = "__CIcos"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIcos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1012_1_0 {
	meta:
		name = "__CIlog10"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIlog10_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1092_1_0 {
	meta:
		name = "__CIpow"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIpow_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_480_1_0 {
	meta:
		name = "__CIsin"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIsin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_888_1_0 {
	meta:
		name = "__CItan"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CItan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_174_2_0 {
	meta:
		name = "__CIlog_default"
		size = 213
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 0032 __DEFAULT_CW_in_mem 004c ___fastflag 0053 __fast_exit 0059 LOG_name 0063 __math_exit 0089 __indefinite 0095 __convertTOStoQNaN 00ad __minfinity 00cf __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 4C 8B 44 24 0C 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? A9 00 00 F0 7F 74 5E A9 00 00 00 80 75 41 D9 ED D9 C9 D9 F1 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? 8D 0D ?? ?? ?? ?? BA 1A 00 00 00 E9 ?? ?? ?? ?? A9 00 00 00 80 75 17 EB D4 A9 FF FF 0F 00 75 1D 83 7C 24 08 00 75 16 25 00 00 00 80 74 C5 DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 EB 22 E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 C5 83 7C 24 08 00 75 BE DD D8 DB 2D ?? ?? ?? ?? B8 02 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? 8D 0D ?? ?? ?? ?? BA 1A 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_175_0_0 {
	meta:
		name = "___sse2_sinhf4"
		size = 320
		refs = "0012 ___common_ssinh_data 0132 ___common_ssinh_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 0F 28 F0 0F 28 05 ?? ?? ?? ?? 0F 54 C6 0F 28 D8 0F 28 25 ?? ?? ?? ?? 66 0F EF DE 0F 59 E3 0F 28 FB 0F 28 2D ?? ?? ?? ?? 66 0F 66 3D ?? ?? ?? ?? 0F 58 E5 0F 50 D7 0F 28 FC 66 0F 72 F4 17 0F 29 74 24 10 85 D2 0F 28 35 ?? ?? ?? ?? 0F 5C FD 0F 28 2D ?? ?? ?? ?? 0F 59 EF 0F 59 F7 0F 5C DD 66 0F 6F 15 ?? ?? ?? ?? 0F 5C DE 0F 28 EB 66 0F 6F F2 0F 59 EB 66 0F FE F4 66 0F FA D4 66 0F 6F E6 0F 28 0D ?? ?? ?? ?? 0F 58 E2 0F 59 CD 0F 5C F2 0F 28 15 ?? ?? ?? ?? 0F 59 D5 0F 58 0D ?? ?? ?? ?? 0F 59 CD 0F 58 15 ?? ?? ?? ?? 0F 59 D5 0F 59 CB 0F 58 15 ?? ?? ?? ?? 0F 58 CB 0F 59 D5 0F 59 E1 0F 59 D6 0F 58 E2 0F 58 E6 0F 56 C4 75 04 8B E5 5D C3 0F 28 4C 24 10 0F 29 4C 24 40 0F 29 84 24 80 00 00 00 74 E8 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 8B CE B8 01 00 00 00 D3 E0 85 F8 75 17 46 83 FE 20 7C ED 8B 74 24 04 8B 3C 24 0F 28 84 24 80 00 00 00 EB B7 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB D2 EB 03 CC CC CC }
	condition:
		$1
}

rule file_176_0_0 {
	meta:
		name = "__resetstkoflw"
		size = 206
		refs = "0007 ___security_cookie 0017 __alloca_probe 0029 __imp__VirtualQuery@12 0041 __imp__GetSystemInfo@4 0053 __imp__SetThreadStackGuarantee@4 0098 __imp__VirtualAlloc@16 00ad __imp__VirtualProtect@16 00c8 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 54 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 57 6A 04 58 E8 ?? ?? ?? ?? 8B C4 6A 1C 8D 4D D0 51 50 89 45 F0 FF 15 ?? ?? ?? ?? 85 C0 0F 84 85 00 00 00 8B 45 D4 89 45 F4 8D 45 AC 50 FF 15 ?? ?? ?? ?? 8B 5D B0 8D 45 F8 33 F6 50 89 75 F8 FF 15 ?? ?? ?? ?? 85 C0 74 08 39 75 F8 76 03 8B 75 F8 4E 8D 43 FF 03 F3 F7 D0 23 F0 74 02 03 F3 8D 04 1B 3B F0 73 02 8B F0 8B 45 F4 8D 7B FF F7 D7 23 7D F0 03 C3 2B FE 3B F8 72 2D 6A 04 68 00 10 00 00 56 57 FF 15 ?? ?? ?? ?? 85 C0 74 1A 8D 45 EC 50 68 04 01 00 00 56 57 FF 15 ?? ?? ?? ?? 85 C0 74 05 33 C0 40 EB 02 33 C0 8D 65 A0 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_178_3_0 {
	meta:
		name = "??0AffinityRestriction@ResourceManager@details@Concurrency@@QAE@GPAUHardwareAffinity@23@@Z"
		size = 22
	strings:
		$1 = { 55 8B EC 66 8B 45 08 66 89 01 8B 45 0C 89 41 04 8B C1 5D C2 08 00 }
	condition:
		$1
}

rule file_178_5_0 {
	meta:
		name = "??0HardwareAffinity@details@Concurrency@@QAE@ABU012@@Z"
		size = 21
	strings:
		$1 = { 55 8B EC 56 8B 75 08 57 8B F9 A5 A5 A5 5F 8B C1 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_178_6_0 {
	meta:
		name = "??0HardwareAffinity@details@Concurrency@@QAE@GK@Z"
		size = 31
	strings:
		$1 = { 55 8B EC 57 33 C0 8B F9 AB AB AB 66 8B 45 08 66 89 41 04 8B 45 0C 89 01 8B C1 5F 5D C2 08 00 }
	condition:
		$1
}

rule file_178_7_0 {
	meta:
		name = "??0HardwareAffinity@details@Concurrency@@QAE@K@Z"
		size = 29
	strings:
		$1 = { 55 8B EC 57 33 C0 8B F9 AB AB AB 33 C0 66 89 41 04 8B 45 08 89 01 8B C1 5F 5D C2 04 00 }
	condition:
		$1
}

rule file_178_8_0 {
	meta:
		name = "??0HardwareAffinity@details@Concurrency@@QAE@PAX@Z"
		size = 85
		refs = "0010 ?Version@ResourceManager@details@Concurrency@@SA?AW4OSVersion@IResourceManager@3@XZ 001b ?s_pfnGetThreadGroupAffinity@HardwareAffinity@details@Concurrency@@0P6GHPAXPAU_GROUP_AFFINITY@@@ZA 0020 ?DecodePointer@Security@details@Concurrency@@SAPAXPAX@Z 0037 __imp__GetCurrentProcess@0 003e __imp__GetProcessAffinityMask@12"
	strings:
		$1 = { 55 8B EC 51 56 57 8B F1 33 C0 8B FE AB AB AB E8 ?? ?? ?? ?? 83 F8 04 7C 14 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 56 FF 75 08 FF D0 EB 20 8D 45 FC 50 8D 45 08 50 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 33 C0 66 89 46 04 8B 45 08 89 06 5F 8B C6 5E C9 C2 04 00 }
	condition:
		$1
}

rule file_178_9_0 {
	meta:
		name = "??0HardwareAffinity@details@Concurrency@@QAE@XZ"
		size = 20
	strings:
		$1 = { 57 33 C0 8B F9 AB AB AB 33 C0 21 01 66 89 41 04 8B C1 5F C3 }
	condition:
		$1
}

rule file_178_13_0 {
	meta:
		name = "??0ResourceManager@details@Concurrency@@AAE@XZ"
		size = 160
		refs = "0003 __ehhandler$??0ResourceManager@details@Concurrency@@AAE@XZ 0008 __EH_prolog3 0015 ??_7ResourceManager@details@Concurrency@@6B@ 0033 ??0_NonReentrantBlockingLock@details@Concurrency@@QAE@XZ 0059 ??0ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ 0064 ?InitializeSystemInformation@ResourceManager@details@Concurrency@@CAX_N@Z 006c ?DetermineTopology@ResourceManager@details@Concurrency@@AAEXXZ 0076 __imp__CreateEventW@16 0090 ??_U@YAPAXI@Z 009b __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 F0 33 FF C7 06 ?? ?? ?? ?? 89 7E 04 89 7E 08 C7 46 0C 10 00 00 00 89 7E 10 89 7E 24 8D 4E 2C 89 7E 28 E8 ?? ?? ?? ?? 89 7E 44 89 7E 48 89 7E 4C 89 7E 50 89 7E 54 89 7E 58 89 7E 5C 8D 4E 68 89 7D FC 89 7E 60 89 7E 64 E8 ?? ?? ?? ?? 6A 01 C6 45 FC 01 E8 ?? ?? ?? ?? 59 8B CE E8 ?? ?? ?? ?? 57 57 57 57 FF 15 ?? ?? ?? ?? 89 46 50 8B 46 0C 33 C9 6A 04 5A F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 89 46 54 59 8B C6 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_178_18_0 {
	meta:
		name = "??0TopologyObject@GlobalCore@details@Concurrency@@QAE@PAU123@@Z"
		size = 21
		refs = "000b ??_7TopologyObject@GlobalCore@details@Concurrency@@6B@"
		altNames = "??0WorkItem@details@Concurrency@@QAE@PAVScheduleGroupSegmentBase@12@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 89 41 04 C7 01 ?? ?? ?? ?? 8B C1 5D C2 04 00 }
	condition:
		$1
}

rule file_178_19_0 {
	meta:
		name = "??0TopologyObject@GlobalNode@details@Concurrency@@QAE@PAU123@@Z"
		size = 21
		refs = "000b ??_7TopologyObject@GlobalNode@details@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 8B 45 08 89 41 04 C7 01 ?? ?? ?? ?? 8B C1 5D C2 04 00 }
	condition:
		$1
}

rule file_5_398_2 {
	meta:
		name = "??0_Runtime_object@details@Concurrency@@QAE@H@Z"
		size = 21
		refs = "000b ??_7_Runtime_object@details@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 8B 45 08 89 41 04 C7 01 ?? ?? ?? ?? 8B C1 5D C2 04 00 }
	condition:
		$1
}

rule file_123_66_1 {
	meta:
		name = "??0codecvt_base@std@@QAE@I@Z"
		size = 21
		refs = "000b ??_7codecvt_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 8B 45 08 89 41 04 C7 01 ?? ?? ?? ?? 8B C1 5D C2 04 00 }
	condition:
		$1
}

rule file_42_54_2 {
	meta:
		name = "??0ctype_base@std@@QAE@I@Z"
		size = 21
		refs = "000b ??_7ctype_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 8B 45 08 89 41 04 C7 01 ?? ?? ?? ?? 8B C1 5D C2 04 00 }
	condition:
		$1
}

rule file_30_58_2 {
	meta:
		name = "??0facet@locale@std@@IAE@I@Z"
		size = 21
		refs = "000b ??_7facet@locale@std@@6B@"
	strings:
		$1 = { 55 8B EC 8B 45 08 89 41 04 C7 01 ?? ?? ?? ?? 8B C1 5D C2 04 00 }
	condition:
		$1
}

rule file_62_315_1 {
	meta:
		name = "??0messages_base@std@@QAE@I@Z"
		size = 21
		refs = "000b ??_7messages_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 8B 45 08 89 41 04 C7 01 ?? ?? ?? ?? 8B C1 5D C2 04 00 }
	condition:
		$1
}

rule file_62_316_1 {
	meta:
		name = "??0money_base@std@@QAE@I@Z"
		size = 21
		refs = "000b ??_7money_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 8B 45 08 89 41 04 C7 01 ?? ?? ?? ?? 8B C1 5D C2 04 00 }
	condition:
		$1
}

rule file_4_108_2 {
	meta:
		name = "??0time_base@std@@QAE@I@Z"
		size = 21
		refs = "000b ??_7time_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 8B 45 08 89 41 04 C7 01 ?? ?? ?? ?? 8B C1 5D C2 04 00 }
	condition:
		$1
}

rule file_178_23_0 {
	meta:
		name = "??0bad_alloc@std@@QAE@XZ"
		size = 36
		refs = "0010 ??_C@_0P@GHFPNOJB@bad?5allocation?$AA@ 0015 ??0exception@std@@QAE@ABQBDH@Z 001b ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 56 6A 01 8D 45 FC 50 8B F1 C7 45 FC ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_178_34_0 {
	meta:
		name = "??1ResourceManager@details@Concurrency@@AAE@XZ"
		size = 168
		refs = "0003 __ehhandler$??1ResourceManager@details@Concurrency@@AAE@XZ 0008 __EH_prolog3 0013 ??_7ResourceManager@details@Concurrency@@6B@ 0035 ??_EGlobalCore@details@Concurrency@@QAEPAXI@Z 004c ??_EGlobalNode@details@Concurrency@@QAEPAXI@Z 0054 ??_V@YAXPAX@Z 005a __imp__CloseHandle@4 0092 ??1ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ 009e ??1_NonReentrantBlockingLock@details@Concurrency@@QAE@XZ 00a3 __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 F0 C7 06 ?? ?? ?? ?? 33 FF C7 45 FC 01 00 00 00 39 7E 18 76 1D 33 DB 8B 46 48 8B 4C 18 20 85 C9 74 07 6A 03 E8 ?? ?? ?? ?? 47 83 C3 28 3B 7E 18 72 E5 8B 4E 48 85 C9 74 07 6A 03 E8 ?? ?? ?? ?? FF 76 44 E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 59 FF 76 50 FF D7 FF 76 54 E8 ?? ?? ?? ?? 83 7E 4C 00 59 74 17 FF 76 4C FF D7 FF 76 58 E8 ?? ?? ?? ?? FF 76 5C E8 ?? ?? ?? ?? 59 59 8D 4E 68 C6 45 FC 00 E8 ?? ?? ?? ?? 83 4D FC FF 8D 4E 2C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_178_46_0 {
	meta:
		name = "??4HardwareAffinity@details@Concurrency@@QAEAAU012@ABU012@@Z"
		size = 24
	strings:
		$1 = { 55 8B EC 8B 55 08 66 8B 42 04 66 89 41 04 8B 02 89 01 8B C1 5D C2 04 00 }
	condition:
		$1
}

rule file_178_48_0 {
	meta:
		name = "??_EGlobalNode@details@Concurrency@@QAEPAXI@Z"
		size = 78
		refs = "000e ??1GlobalNode@details@Concurrency@@QAE@XZ 001b ??_M@YGXPAXIHP6EX0@Z@Z 0027 ??_V@YAXPAX@Z 0035 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 02 56 8B F1 74 25 57 68 ?? ?? ?? ?? 8D 7E FC FF 37 6A 28 56 E8 ?? ?? ?? ?? F6 45 08 01 74 07 57 E8 ?? ?? ?? ?? 59 8B C7 5F EB 18 FF 76 24 E8 ?? ?? ?? ?? F6 45 08 01 59 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_178_49_0 {
	meta:
		name = "??_GAffinityRestriction@ResourceManager@details@Concurrency@@QAEPAXI@Z"
		size = 35
		refs = "000a ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 FF 76 04 E8 ?? ?? ?? ?? F6 45 08 01 59 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_178_58_0 {
	meta:
		name = "?AddTail@?$List@VSchedulerProxy@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QAEXPAVSchedulerProxy@23@@Z"
		size = 57
	strings:
		$1 = { 55 8B EC 8B 41 04 8B 55 08 85 C0 75 08 89 52 18 89 52 1C EB 1B 8B 40 18 89 42 18 8B 41 04 89 42 1C 8B 41 04 8B 40 18 89 50 1C 8B 41 04 89 50 18 89 51 04 FF 01 5D C2 04 00 }
	condition:
		$1
}

rule file_178_59_0 {
	meta:
		name = "?AdjustDynamicAllocation@ResourceManager@details@Concurrency@@AAEIIII@Z"
		size = 208
		refs = "0036 __real@41f0000000000000 0097 ?RoundUpScaledAllocations@ResourceManager@details@Concurrency@@CAXPAPAUAllocationData@23@II@Z"
	strings:
		$1 = { 55 8B EC 51 51 8B 45 0C 56 8B 75 08 57 8B F9 3B F0 0F 83 8A 00 00 00 53 8B 5D 10 83 FB 01 75 0A 8B 47 5C 8B 00 89 70 04 EB 74 89 75 10 DB 45 10 85 F6 79 06 DC 05 ?? ?? ?? ?? DD 5D F8 89 45 10 DD 45 F8 DB 45 10 85 C0 79 06 DC 05 ?? ?? ?? ?? DD 5D F8 DC 75 F8 85 DB 74 35 33 F6 8B 47 5C 8B 14 B0 8B 42 10 8B 4A 24 2B 88 A0 00 00 00 89 4D 10 DB 45 10 79 06 DC 05 ?? ?? ?? ?? DD 5D F8 46 DD 45 F8 D8 C9 DD 5A 08 3B F3 72 D0 8B 75 08 56 DD D8 53 FF 77 5C E8 ?? ?? ?? ?? 83 C4 0C 5B EB 27 33 F6 39 75 10 76 1E 8B 47 5C 8B 14 B0 8B 42 10 8B 4A 24 2B 88 A0 00 00 00 46 89 4A 04 3B 75 10 72 E5 8B 45 0C 8B F0 5F 8B C6 5E C9 C2 0C 00 }
	condition:
		$1
}

rule file_178_60_0 {
	meta:
		name = "?ApplyAffinityLimits@AffinityRestriction@ResourceManager@details@Concurrency@@QAEXPAU_GROUP_AFFINITY@@@Z"
		size = 35
		refs = "000d ?FindGroupAffinity@AffinityRestriction@ResourceManager@details@Concurrency@@QAEPAUHardwareAffinity@34@G@Z"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 0F B7 46 04 50 E8 ?? ?? ?? ?? 85 C0 74 06 8B 00 21 06 EB 03 83 26 00 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_178_61_0 {
	meta:
		name = "?ApplyAffinityRestrictions@ResourceManager@details@Concurrency@@CAXPAK@Z"
		size = 47
		refs = "0022 ?ApplyAffinityRestrictions@ResourceManager@details@Concurrency@@CAXPAU_GROUP_AFFINITY@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 83 65 F8 00 83 65 FC 00 33 C0 56 8B 75 08 66 89 45 F8 8B 06 89 45 F4 8D 45 F4 50 E8 ?? ?? ?? ?? 8B 45 F4 59 89 06 5E C9 C3 }
	condition:
		$1
}

rule file_178_62_0 {
	meta:
		name = "?ApplyAffinityRestrictions@ResourceManager@details@Concurrency@@CAXPAU_GROUP_AFFINITY@@@Z"
		size = 39
		refs = "000d ?s_pProcessAffinityRestriction@ResourceManager@details@Concurrency@@0PAUAffinityRestriction@123@A 0017 ?s_pUserAffinityRestriction@ResourceManager@details@Concurrency@@0PAUAffinityRestriction@123@A 0021 ?ApplyAffinityLimits@AffinityRestriction@ResourceManager@details@Concurrency@@QAEXPAU_GROUP_AFFINITY@@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 38 00 74 1A 8B 0D ?? ?? ?? ?? 85 C9 75 0A 8B 0D ?? ?? ?? ?? 85 C9 74 06 50 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_178_63_0 {
	meta:
		name = "?ApplyTo@HardwareAffinity@details@Concurrency@@QAEXPAX@Z"
		size = 54
		refs = "0007 ?Version@ResourceManager@details@Concurrency@@SA?AW4OSVersion@IResourceManager@3@XZ 0012 ?s_pfnSetThreadGroupAffinity@HardwareAffinity@details@Concurrency@@0P6GHPAXPAU_GROUP_AFFINITY@@1@ZA 0017 ?DecodePointer@Security@details@Concurrency@@SAPAXPAX@Z 002d __imp__SetThreadAffinityMask@8"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? 83 F8 04 7C 16 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 6A 00 56 FF 75 08 FF D0 EB 0B FF 36 FF 75 08 FF 15 ?? ?? ?? ?? 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_178_64_0 {
	meta:
		name = "?CaptureProcessAffinity@ResourceManager@details@Concurrency@@CAXXZ"
		size = 279
		refs = "0003 __ehhandler$?CaptureProcessAffinity@ResourceManager@details@Concurrency@@CAXXZ 0008 __EH_prolog3_GS 000d ?s_systemAffinityMask@ResourceManager@details@Concurrency@@0KA 0012 ?s_processAffinityMask@ResourceManager@details@Concurrency@@0KA 0018 __imp__GetCurrentProcess@0 001f __imp__GetProcessAffinityMask@12 0029 __imp__GetLastError@0 003e ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 0043 __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 004c __CxxThrowException@8 0063 ?s_version@ResourceManager@details@Concurrency@@0W4OSVersion@IResourceManager@3@A 006c __imp__GetCurrentThread@0 0075 ??0HardwareAffinity@details@Concurrency@@QAE@PAX@Z 007c ??2@YAPAXI@Z 00bc ?s_pProcessAffinityRestriction@ResourceManager@details@Concurrency@@0PAUAffinityRestriction@123@A 0112 __EH_epilog3_GS"
	strings:
		$1 = { 6A 24 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 29 FF 15 ?? ?? ?? ?? 85 C0 7E 08 0F B7 C0 0D 00 00 07 80 50 8D 4D D0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 D0 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 0F 84 B0 00 00 00 83 3D ?? ?? ?? ?? 04 7C 58 FF 15 ?? ?? ?? ?? 50 8D 4D E4 E8 ?? ?? ?? ?? 6A 0C E8 ?? ?? ?? ?? 8B F0 59 85 F6 74 19 0F B7 4D E8 8B 15 ?? ?? ?? ?? 33 C0 8B FE AB AB AB 66 89 4E 04 89 16 EB 02 33 F6 6A 08 E8 ?? ?? ?? ?? 59 85 C0 74 0B 33 C9 41 66 89 08 89 70 04 EB 02 33 C0 A3 ?? ?? ?? ?? EB 4F 6A 08 E8 ?? ?? ?? ?? 8B F0 59 89 75 E0 83 65 FC 00 85 F6 74 32 6A 0C E8 ?? ?? ?? ?? 8B D0 59 85 D2 74 17 8B 0D ?? ?? ?? ?? 33 C0 8B FA AB AB AB 33 C0 66 89 42 04 89 0A EB 02 33 D2 33 C0 40 66 89 06 89 56 04 EB 02 33 F6 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_178_66_0 {
	meta:
		name = "__ehhandler$?CaptureProcessAffinity@ResourceManager@details@Concurrency@@CAXXZ"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?CaptureProcessAffinity@ResourceManager@details@Concurrency@@CAXXZ 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_6_150_2 {
	meta:
		name = "__ehhandler$?_Endwrite@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IAE_NXZ"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?_Endwrite@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IAE_NXZ 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_151_2 {
	meta:
		name = "__ehhandler$?_Endwrite@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAE_NXZ"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?_Endwrite@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAE_NXZ 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_151_2 {
	meta:
		name = "__ehhandler$?_Endwrite@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAE_NXZ"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?_Endwrite@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAE_NXZ 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_178_67_0 {
	meta:
		name = "?CleanupTopologyInformation@ResourceManager@details@Concurrency@@CAXXZ"
		size = 27
		refs = "0002 ?s_pSysInfo@ResourceManager@details@Concurrency@@0PAU_SYSTEM_LOGICAL_PROCESSOR_INFORMATION@@A 0007 _free 0014 ?s_logicalProcessorInformationLength@ResourceManager@details@Concurrency@@0KA"
	strings:
		$1 = { FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 25 ?? ?? ?? ?? 00 83 25 ?? ?? ?? ?? 00 59 C3 }
	condition:
		$1
}

rule file_178_68_0 {
	meta:
		name = "?CommitStolenCores@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@@Z"
		size = 269
		refs = "00a9 ?ToggleBorrowedState@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I@Z 00f3 ?RemoveCore@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I@Z"
	strings:
		$1 = { 55 8B EC 83 EC 18 8B 45 08 53 8B 40 10 8B D9 33 C9 89 4D EC 39 4B 18 0F 86 CC 00 00 00 56 57 6A FC 5A 2B D0 8D 70 04 89 55 E8 33 FF 39 3E 0F 86 A3 00 00 00 33 C9 89 4D 08 8B 46 2C 83 65 F0 00 33 D2 42 03 C1 89 45 F4 89 55 F8 39 53 08 76 75 8B 43 54 8B 04 90 8B 40 10 89 45 FC 83 78 6C 00 76 55 8B 4D E8 03 CE 03 48 10 8B 51 30 03 55 08 83 3A 05 75 3F 8B 45 F4 83 38 04 75 7C 83 78 18 00 8B 45 FC 75 68 80 7A 30 00 75 62 83 7D F0 00 75 5C 8B 42 14 FF 00 80 7A 31 00 C7 02 04 00 00 00 75 0A 57 51 8B 4D FC E8 ?? ?? ?? ?? C7 45 F0 01 00 00 00 8B 4D 08 8B 45 F8 40 89 45 F8 8B D0 3B 43 08 72 8B 47 83 C1 34 89 4D 08 3B 3E 0F 82 65 FF FF FF 8B 4D EC 41 83 C6 34 89 4D EC 3B 4B 18 0F 82 43 FF FF FF 5F 5E 5B C9 C2 04 00 57 51 8B C8 E8 ?? ?? ?? ?? EB BB 8B 42 14 FF 00 8B 41 30 8B 4D 08 C7 04 01 04 00 00 00 EB AA }
	condition:
		$1
}

rule file_178_69_0 {
	meta:
		name = "?ComputeDesiredHWThreadsWithExternalThread@SchedulerProxy@details@Concurrency@@QBEIXZ"
		size = 35
		refs = "000b ?DesiredHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ"
	strings:
		$1 = { 56 57 8B F9 8B B7 BC 00 00 00 E8 ?? ?? ?? ?? 40 3B F0 72 0A 8B CF E8 ?? ?? ?? ?? 8D 70 01 5F 8B C6 5E C3 }
	condition:
		$1
}

rule file_178_70_0 {
	meta:
		name = "?ComputeMinHWThreadsWithExternalThread@SchedulerProxy@details@Concurrency@@QBEIXZ"
		size = 45
		refs = "000b ?MinVprocHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ"
	strings:
		$1 = { 56 8B F1 57 8B BE B8 00 00 00 E8 ?? ?? ?? ?? 8B 96 BC 00 00 00 40 03 C7 3B D0 72 0C 8B CE E8 ?? ?? ?? ?? 8D 57 01 03 D0 5F 8B C2 5E C3 }
	condition:
		$1
}

rule file_178_72_0 {
	meta:
		name = "?CreateAllocatedNodeData@ResourceManager@details@Concurrency@@QAEPAUSchedulerNode@23@XZ"
		size = 301
		refs = "0021 ??_U@YAPAXI@Z 0036 _memset"
	strings:
		$1 = { 55 8B EC 83 EC 1C 53 56 8B F1 57 8B 46 18 33 C9 6A 34 5A F7 E2 0F 90 C1 89 75 E8 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 8B 4E 18 6B C9 34 51 8B D8 33 FF 57 53 89 5D E4 E8 ?? ?? ?? ?? 83 C4 10 89 7D F0 39 7E 18 0F 86 DD 00 00 00 8B CF 89 7D EC 8B 46 48 03 C1 6A 06 59 8B F0 8B FB F3 A5 8B 73 04 89 45 FC 33 C9 6A 34 5F 8B C6 F7 E7 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 8B D0 59 85 D2 74 18 8D 46 FF 85 C0 78 13 8D 4A 0C 83 21 00 83 61 04 00 03 CF 48 79 F4 EB 02 33 D2 8B 43 04 6B C0 34 50 6A 00 52 89 53 30 E8 ?? ?? ?? ?? 83 65 F8 00 83 C4 0C 83 7B 04 00 76 4D 33 D2 33 C9 89 4D F4 8B 7B 30 8B 75 FC 03 FA 8B 76 20 03 F1 A5 A5 A5 8B 43 30 6A 34 C7 04 02 01 00 00 00 8B 45 FC 5F 8B 40 20 83 C0 10 03 C8 8B 43 30 89 4C 02 14 8B 45 F8 8B 4D F4 40 83 C1 24 03 D7 89 45 F8 89 4D F4 3B 43 04 72 BA 8B 45 F0 8B 4D EC 8B 75 E8 40 83 C1 28 03 DF 89 45 F0 89 4D EC 3B 46 18 0F 82 2B FF FF FF 8B 5D E4 5F 5E 8B C3 5B C9 C3 }
	condition:
		$1
}

rule file_178_73_0 {
	meta:
		name = "?CreateDynamicRMWorker@ResourceManager@details@Concurrency@@AAEXXZ"
		size = 112
		refs = "000f ?DynamicRMThreadProc@ResourceManager@details@Concurrency@@CGKPAX@Z 001a ?LoadLibraryAndCreateThread@details@Concurrency@@YAPAXPAU_SECURITY_ATTRIBUTES@@KP6GKPAX@Z1KPAK@Z 002b __imp__GetLastError@0 003a __imp__SetThreadPriority@8 005d ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 0062 __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 006b __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 83 EC 10 33 C0 56 50 50 8B F1 56 68 ?? ?? ?? ?? 68 00 00 01 00 50 E8 ?? ?? ?? ?? 83 C4 18 89 46 4C 5E 85 C0 75 0C FF 15 ?? ?? ?? ?? 85 C0 7E 25 EB 1B 6A 0F 50 FF 15 ?? ?? ?? ?? 85 C0 75 0C FF 15 ?? ?? ?? ?? 85 C0 7E 0C EB 02 C9 C3 0F B7 C0 0D 00 00 07 80 50 8D 4D F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_178_76_0 {
	meta:
		name = "?CreateSchedulerProxy@ResourceManager@details@Concurrency@@AAEPAVSchedulerProxy@23@PAUIScheduler@3@@Z"
		size = 92
		refs = "0003 __ehhandler$?CreateSchedulerProxy@ResourceManager@details@Concurrency@@AAEPAVSchedulerProxy@23@PAUIScheduler@3@@Z 0008 __EH_prolog3 0027 ??2@YAPAXI@Z 0040 ??0SchedulerProxy@details@Concurrency@@QAE@PAUIScheduler@2@PAVResourceManager@12@ABVSchedulerPolicy@2@@Z 004e ??1SchedulerPolicy@Concurrency@@QAE@XZ 0055 __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D9 8B 7D 08 8D 4D 08 8B 07 51 8B CF FF 50 08 33 F6 68 D0 00 00 00 89 75 FC E8 ?? ?? ?? ?? 59 89 45 F0 C6 45 FC 01 85 C0 74 0F 8D 4D 08 51 53 57 8B C8 E8 ?? ?? ?? ?? 8B F0 83 4D FC FF 8D 4D 08 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2 04 00 }
	condition:
		$1
}

rule file_178_80_0 {
	meta:
		name = "?CreateSingleton@ResourceManager@details@Concurrency@@SAPAV123@XZ"
		size = 149
		refs = "0003 __ehhandler$?CreateSingleton@ResourceManager@details@Concurrency@@SAPAV123@XZ 0008 __EH_prolog3 000d ?s_lock@ResourceManager@details@Concurrency@@0V_NonReentrantLock@23@A 0015 ?_Acquire@_NonReentrantLock@details@Concurrency@@QAEXXZ 001a ?s_pResourceManager@ResourceManager@details@Concurrency@@0PAV123@A 002d ??2@YAPAXI@Z 003d ?DecodePointer@Security@details@Concurrency@@SAPAXPAX@Z 0047 ?SafeReference@ResourceManager@details@Concurrency@@AAE_NXZ 0068 ??0ResourceManager@details@Concurrency@@AAE@XZ 007d ?EncodePointer@Security@details@Concurrency@@SAPAXPAX@Z 0090 __EH_epilog3"
	strings:
		$1 = { 6A 08 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 89 4D F0 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 DB 89 5D FC 85 C0 75 14 68 8C 00 00 00 E8 ?? ?? ?? ?? 59 89 45 EC C6 45 FC 01 EB 26 50 E8 ?? ?? ?? ?? 8B F0 59 8B CE E8 ?? ?? ?? ?? 84 C0 75 38 68 8C 00 00 00 E8 ?? ?? ?? ?? 59 89 45 EC C6 45 FC 02 85 C0 74 0B 8B C8 E8 ?? ?? ?? ?? 8B F0 EB 02 8B F3 8B 06 8B CE 88 5D FC FF 10 56 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 59 89 1D ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_178_85_0 {
	meta:
		name = "?CurrentSubscriptionLevel@ResourceManager@details@Concurrency@@QAEIII@Z"
		size = 109
		refs = "0018 ?_Acquire@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ 0060 ?_Release@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 51 53 56 57 8B F9 89 7D FC 8D 77 2C 8B CE 33 DB 89 75 F8 E8 ?? ?? ?? ?? 8B 4F 64 85 C9 74 05 8B 49 18 EB 02 33 C9 85 C9 74 2F 8B 55 08 8B 7D 0C 6B D2 34 8B 75 FC 6B FF 34 8B 41 10 8B 44 10 30 8B 44 38 18 03 D8 3B 4E 64 74 05 8B 49 18 EB 02 33 C9 85 C9 75 E3 8B 75 F8 8B CE E8 ?? ?? ?? ?? 5F 5E 8B C3 5B C9 C2 08 00 }
	condition:
		$1
}

rule file_178_88_0 {
	meta:
		name = "?DestroyAllocatedNodeData@ResourceManager@details@Concurrency@@QAEXPAUSchedulerNode@23@@Z"
		size = 58
		refs = "001b ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 53 8B 5D 08 56 8B C1 33 F6 39 70 18 76 1B 57 8D 7B 30 8B D8 FF 37 E8 ?? ?? ?? ?? 46 59 8D 7F 34 3B 73 18 72 EF 8B 5D 08 5F 53 E8 ?? ?? ?? ?? 59 5E 5B C9 C2 04 00 }
	condition:
		$1
}

rule file_178_89_0 {
	meta:
		name = "?DetermineTopology@ResourceManager@details@Concurrency@@AAEXXZ"
		size = 736
		refs = "0004 ?s_numaNodeCount@ResourceManager@details@Concurrency@@0IA 0016 ?s_nodeCount@ResourceManager@details@Concurrency@@0IA 001e ?s_coreCount@ResourceManager@details@Concurrency@@0IA 0036 ??_U@YAPAXI@Z 0049 _memset 0098 ?s_version@ResourceManager@details@Concurrency@@0W4OSVersion@IResourceManager@3@A 00a7 ?s_pSysInfo@ResourceManager@details@Concurrency@@0PAU_SYSTEM_LOGICAL_PROCESSOR_INFORMATION@@A 00b5 ?s_logicalProcessorInformationLength@ResourceManager@details@Concurrency@@0KA 00d1 ?s_countProcessorPackages@ResourceManager@details@Concurrency@@0_NA 0103 ?Initialize@GlobalNode@details@Concurrency@@QAEXPAVResourceManager@23@GGKII@Z 027a ?CleanupTopologyInformation@ResourceManager@details@Concurrency@@CAXXZ"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 83 EC 14 53 56 57 8B F9 33 C9 89 47 14 A1 ?? ?? ?? ?? 89 47 18 A1 ?? ?? ?? ?? 89 47 1C 8B 47 14 6A 0C 5A F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 8B 4F 14 6B C9 0C 51 33 DB 53 50 89 47 44 E8 ?? ?? ?? ?? 8B 77 18 33 C9 6A 28 5A 8B C6 F7 E2 0F 90 C1 F7 D9 0B C8 33 C0 83 C1 04 0F 92 C0 F7 D8 0B C1 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 74 07 89 30 8D 48 04 EB 02 8B CB 8B 47 18 6B C0 28 50 53 51 89 4F 48 E8 ?? ?? ?? ?? 83 C4 0C 83 3D ?? ?? ?? ?? 04 8B D3 0F 8C 07 01 00 00 8B 1D ?? ?? ?? ?? 33 C9 89 55 F8 89 4D FC 39 0D ?? ?? ?? ?? 0F 86 BA 01 00 00 21 4D F0 8B 03 48 74 67 48 48 0F 85 C0 00 00 00 38 05 ?? ?? ?? ?? 0F 84 B4 00 00 00 33 D2 8B F1 8D 43 20 6B F6 28 89 55 EC 89 45 F4 83 38 00 74 27 6A 00 6A 00 FF 30 0F B7 40 04 50 51 8B 4F 48 57 03 CE E8 ?? ?? ?? ?? 8B 4D FC 8B 45 F4 8B 55 EC 41 89 4D FC 83 C6 28 83 C0 0C 89 45 F4 0F B7 43 1E 42 3B D0 8B 45 F4 89 55 EC 7C BF EB 5E 80 3D ?? ?? ?? ?? 00 75 33 83 7B 20 00 74 2D 0F B7 43 24 6A 00 8B F1 6A 00 6B F6 28 FF 73 20 50 51 8B 4F 48 57 03 CE E8 ?? ?? ?? ?? 8B 4F 48 8B 43 08 FF 45 FC 8B 55 F8 89 44 0E 14 8B 73 20 85 F6 74 1E 8B 57 44 03 55 F0 0F B7 4B 24 8B 43 08 83 45 F0 0C 89 42 08 8B C1 89 42 04 89 32 8B 55 F8 03 53 04 03 5B 04 8B 4D FC 89 55 F8 3B 15 ?? ?? ?? ?? 0F 82 1B FF FF FF E9 CD 00 00 00 8B 35 ?? ?? ?? ?? 8B CB 89 55 F4 89 4D FC 39 0D ?? ?? ?? ?? 0F 86 B3 00 00 00 89 5D F0 8B 46 04 48 74 38 48 48 0F 85 8D 00 00 00 38 05 ?? ?? ?? ?? 0F 84 81 00 00 00 39 06 74 7D 50 50 FF 36 50 51 8B 4F 48 57 03 CB E8 ?? ?? ?? ?? 8B 4D FC 8B 55 F4 41 89 4D FC 83 C3 28 EB 5D 80 3D ?? ?? ?? ?? 00 75 2F 83 3E 00 74 4F 33 C0 50 50 FF 36 50 51 8B 4F 48 57 03 CB E8 ?? ?? ?? ?? 8B 4F 48 8B 46 08 8B 55 F4 89 44 0B 14 8B 4D FC 41 89 4D FC 83 C3 28 8B 06 89 45 EC 85 C0 74 1C 8B 4F 44 03 4D F0 8B 46 08 83 61 04 00 83 45 F0 0C 89 41 08 8B 45 EC 89 01 8B 4D FC 83 C2 18 83 C6 18 89 55 F4 3B 15 ?? ?? ?? ?? 0F 82 50 FF FF FF E8 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 74 54 33 DB 39 5F 18 76 4D 33 D2 33 C9 39 4F 14 76 3B 8B 47 48 8B 74 02 0C 89 75 EC 8B 77 44 8B 45 EC 3B 46 04 8B 47 48 75 07 8B 04 02 85 06 75 0B 41 83 C6 0C 3B 4F 14 72 E5 EB 11 8B 47 44 6B C9 0C 8B 44 01 08 8B 4F 48 89 44 0A 14 43 83 C2 28 3B 5F 18 72 B5 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_178_90_0 {
	meta:
		name = "?DiscardExistingSchedulerStatistics@ResourceManager@details@Concurrency@@AAEXXZ"
		size = 77
	strings:
		$1 = { 55 8B EC 83 EC 0C 56 57 8B F9 8B 77 64 85 F6 EB 2B 8B 46 78 8B 4E 08 83 65 F4 00 83 65 F8 00 8D 55 FC 52 8D 55 F8 52 89 45 FC 8B 01 8D 55 F4 52 FF 50 04 8B 45 FC 89 46 78 3B 77 64 74 05 8B 76 18 EB 02 33 F6 85 F6 75 C8 5F 5E C9 C3 }
	condition:
		$1
}

rule file_178_91_0 {
	meta:
		name = "?DistributeCoresToSurvivingScheduler@ResourceManager@details@Concurrency@@AAE_NXZ"
		size = 429
		refs = "002b ?DesiredHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 0050 ?AdjustAllocationIncrease@SchedulerProxy@details@Concurrency@@QBEII@Z 0137 ?AddCore@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I_N@Z 014d ?ToggleBorrowedState@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I@Z 018f ?SendResourceNotifications@ResourceManager@details@Concurrency@@QAEXPAVSchedulerProxy@23@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 2C 53 8B D9 89 5D E0 83 7B 64 00 0F 84 92 01 00 00 56 8B 73 64 85 F6 74 05 8B 76 18 EB 02 33 F6 8B CE 89 75 E4 E8 ?? ?? ?? ?? 39 86 A0 00 00 00 72 0D 83 BE A8 00 00 00 00 0F 86 38 01 00 00 57 8B CE E8 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? 2B 86 A0 00 00 00 8B CE 89 45 F4 8B 46 10 89 45 EC 8B 46 14 89 45 F8 E8 ?? ?? ?? ?? 3B 43 1C 8B 7B 18 0F 95 C2 33 C9 89 4D E8 89 7D DC 85 FF 0F 84 F2 00 00 00 83 7D F4 00 0F 97 C0 22 D0 88 55 FF 74 66 8B 45 F8 8D 51 01 8B 04 88 89 45 D4 6B C0 34 03 45 EC 89 4D F0 89 45 D8 3B D7 73 4A 8B 5D DC 8B 75 F0 8B C8 8B 45 F8 8B 3C 90 6B FF 34 03 7D EC 8B 47 1C 3B 41 1C 76 04 8B F2 8B CF 42 3B D3 72 E3 8B 4D E8 8B 5D E0 89 75 F0 3B CE 8B 75 E4 74 15 8B 55 F0 8B 45 F8 8B 7D F8 8B 04 90 89 04 8F 8B 45 D4 89 04 97 8B 55 F8 83 65 D4 00 8B 3C 8A 6B FF 34 03 7D EC 83 7F 04 00 76 53 8B 5D D4 33 C9 89 4D F0 8B 47 30 83 3C 08 01 75 1C 83 7D F4 00 76 2A 8B 44 08 14 6A 00 FF 00 53 57 8B CE E8 ?? ?? ?? ?? FF 4D F4 EB 11 8A 44 08 31 84 C0 74 0C 53 57 8B CE E8 ?? ?? ?? ?? 8B 4D F0 43 83 C1 34 89 4D F0 3B 5F 04 72 BB 8B 5D E0 8B 4D E8 8B 7B 18 8A 55 FF 41 89 4D E8 89 7D DC 3B CF 0F 82 0E FF FF FF 5F 8B 86 84 00 00 00 3B 86 80 00 00 00 75 09 6A 00 8B CB E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 33 C9 39 86 A0 00 00 00 5E 0F 94 C0 EB 02 B0 01 5B C9 C3 }
	condition:
		$1
}

rule file_178_92_0 {
	meta:
		name = "?DistributeExclusiveCores@ResourceManager@details@Concurrency@@AAEXIIIII@Z"
		size = 314
		refs = "0044 ?FindCoreForPartiallyFilledNode@ResourceManager@details@Concurrency@@AAE_NAAI0PAUDynamicAllocationData@23@I@Z 0114 ?FindBestFitExclusiveAllocation@ResourceManager@details@Concurrency@@AAEIAAI0PAUDynamicAllocationData@23@II@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 8B 5D 08 56 8B 75 14 57 89 4D FC 33 FF C6 45 17 00 85 F6 74 42 8B 41 5C 8B 0C B8 83 79 04 00 76 25 8B 41 28 3B 41 2C 76 1D FF 75 18 8D 45 10 51 8B 4D FC 50 8D 45 0C 50 C6 45 17 01 E8 ?? ?? ?? ?? 84 C0 74 01 4B 8B 4D FC 47 3B FE 72 C7 80 7D 17 00 89 5D 08 75 B4 85 DB 0F 84 CD 00 00 00 33 D2 89 55 F4 85 F6 74 7D 8D 42 01 89 55 14 89 45 F0 8B F8 3B C6 73 54 8B 41 5C 8B DA 89 45 F8 C1 E3 02 8B D0 8B 04 BA 8B 0C 13 8B 40 04 3B 41 04 76 0C 8B C7 8B DF 89 45 14 C1 E3 02 EB 03 8B 45 14 47 3B FE 72 DE 8B 55 F4 8B 5D 08 3B D0 74 18 8B 7D F8 8B 04 87 8B 0C 97 89 04 97 8B 45 FC 8B 7D 14 8B 40 5C 89 0C B8 8B 4D FC 8B 41 5C 8B 04 90 83 78 04 00 74 0C 8B 55 F0 89 55 F4 3B D6 72 87 EB 02 8B F2 8B C6 89 45 14 33 FF 85 C0 74 38 8B 41 5C 8B 04 B8 89 45 08 83 78 04 00 76 21 FF 75 18 56 50 8D 45 10 50 8D 45 0C 50 E8 ?? ?? ?? ?? 8B 4D FC 2B D8 8B 45 08 83 78 04 00 75 01 4E 8B 45 14 47 3B F8 72 C8 85 DB 75 BE 5F 5E 5B C9 C2 14 00 }
	condition:
		$1
}

rule file_178_93_0 {
	meta:
		name = "?DistributeIdleCores@ResourceManager@details@Concurrency@@AAEXII@Z"
		size = 385
		refs = "0075 ?DynamicAssignCores@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@II_N@Z 015b ?FindBestFitIdleAllocation@ResourceManager@details@Concurrency@@AAEIIPAUDynamicAllocationData@23@I@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 8B 5D 08 56 8B 75 0C 57 89 4D FC 33 FF C6 45 0F 00 89 7D F8 85 F6 0F 84 88 00 00 00 85 DB 74 77 8B 41 5C 8B 3C B8 83 7F 04 00 76 60 8B 57 2C 39 57 28 76 58 8B 4F 10 C6 45 0F 01 8B 41 14 8B 14 90 8B C2 6B C0 34 03 41 10 8B CA 6B C9 28 89 55 08 8B 55 FC 89 45 F4 8B 42 48 83 7C 01 1C 00 8B CA 76 26 6A 01 6A 01 FF 75 08 FF 77 10 E8 ?? ?? ?? ?? 8B 4D F4 8B 41 1C 3B 41 04 75 03 FF 47 2C FF 4F 04 8B 4D FC 4B EB 03 FF 47 2C 8B 7D F8 47 89 7D F8 3B FE 72 85 80 7D 0F 00 89 5D 08 0F 85 67 FF FF FF 85 DB 0F 84 C7 00 00 00 33 D2 89 55 F4 85 F6 74 7D 8D 42 01 89 55 0C 89 45 F0 8B F8 3B C6 73 54 8B 41 5C 8B DA 89 45 F8 C1 E3 02 8B D0 8B 04 BA 8B 0C 13 8B 40 04 3B 41 04 76 0C 8B C7 8B DF 89 45 0C C1 E3 02 EB 03 8B 45 0C 47 3B FE 72 DE 8B 55 F4 8B 5D 08 3B D0 74 18 8B 7D F8 8B 04 87 8B 0C 97 89 04 97 8B 45 FC 8B 7D 0C 8B 40 5C 89 0C B8 8B 4D FC 8B 41 5C 8B 04 90 83 78 04 00 74 0C 8B 55 F0 89 55 F4 3B D6 72 87 EB 02 8B F2 8B C6 89 45 0C 33 FF 85 C0 74 32 85 DB 74 32 8B 41 5C 8B 04 B8 89 45 08 83 78 04 00 76 17 56 50 53 E8 ?? ?? ?? ?? 8B 4D FC 2B D8 8B 45 08 83 78 04 00 75 01 4E 8B 45 0C 47 3B F8 72 CE 85 DB 75 C4 5F 5E 5B C9 C2 08 00 }
	condition:
		$1
}

rule file_178_94_0 {
	meta:
		name = "?DoCoreMigration@ResourceManager@details@Concurrency@@AAEXXZ"
		size = 610
		refs = "000c ?PopulateDynamicAllocationData@ResourceManager@details@Concurrency@@AAEXXZ 0013 ?PreProcessDynamicAllocationData@ResourceManager@details@Concurrency@@AAEXXZ 0167 ?IncreaseFullyLoadedSchedulerAllocations@ResourceManager@details@Concurrency@@AAEXXZ 01c7 ?AdjustDynamicAllocation@ResourceManager@details@Concurrency@@AAEIIII@Z 01d3 ?PrepareReceiversForCoreTransfer@ResourceManager@details@Concurrency@@AAEII@Z 020e ?DistributeExclusiveCores@ResourceManager@details@Concurrency@@AAEXIIIII@Z 0244 ?DistributeIdleCores@ResourceManager@details@Concurrency@@AAEXII@Z 0259 ?ResetGlobalAllocationData@ResourceManager@details@Concurrency@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 83 EC 18 53 56 57 8B F9 E8 ?? ?? ?? ?? 8B CF E8 ?? ?? ?? ?? 83 65 F4 00 33 C9 33 DB 89 4D EC 39 4F 08 0F 86 95 00 00 00 8B 47 54 8B 14 98 8B 42 10 8B 80 A0 00 00 00 3B 42 24 76 77 8B 47 58 89 14 88 41 89 4D EC 8B 4A 10 8B B1 A0 00 00 00 8B C6 2B 42 24 01 45 F4 8B C6 2B 42 24 39 42 18 73 05 8B 72 18 EB 03 2B 72 24 89 72 28 8B 81 A8 00 00 00 8B 89 A0 00 00 00 89 4D F8 2B 4A 24 89 45 F0 2B 42 18 2B CE 3B C1 73 08 8B 4D F0 2B 4A 18 EB 08 8B 4D F8 2B 4A 24 2B CE 8B 42 10 89 4A 2C 8B 80 A0 00 00 00 2B 42 24 2B C1 8B 4D EC 2B C6 89 42 30 43 3B 5F 08 0F 82 6B FF FF FF 33 C9 21 4F 20 33 D2 89 4D FC 89 55 F0 39 4F 18 76 69 33 F6 89 75 F8 8B 47 48 83 65 E8 00 03 C6 83 78 04 00 76 46 8B 55 E8 33 DB 8B 48 20 03 CB 8B 71 10 85 F6 75 12 C7 01 02 00 00 00 8B 4D FC FF 40 08 41 89 4D FC EB 14 3B 71 1C 75 0C C7 01 06 00 00 00 FF 40 1C FF 47 20 8B 4D FC 42 83 C3 24 3B 50 04 72 C5 8B 55 F0 8B 75 F8 42 83 C6 28 89 55 F0 89 75 F8 3B 57 18 72 9C 8B 75 F4 03 F1 83 67 24 00 89 75 F8 85 F6 75 09 39 77 20 0F 86 02 01 00 00 83 7F 24 02 0F 83 F8 00 00 00 83 7F 24 01 75 07 8B CF E8 ?? ?? ?? ?? 33 C9 33 DB 33 D2 89 4D F0 39 4F 08 0F 86 D1 00 00 00 8B 47 54 8B 34 90 8B 46 10 8B 80 A0 00 00 00 3B 46 24 73 1B 8B 47 5C 89 34 88 8B 46 10 41 89 4D F0 8B 4E 24 2B 88 A0 00 00 00 03 D9 8B 4D F0 42 3B 57 08 72 CB 8B 75 F8 85 C9 0F 84 91 00 00 00 85 F6 74 5C 51 53 56 8B CF E8 ?? ?? ?? ?? FF 75 F0 8B CF 8B F0 E8 ?? ?? ?? ?? 89 45 E8 8B 45 FC 33 C9 8B D0 3B C6 72 02 8B D6 2B C2 89 45 FC 3B D6 73 12 8B 45 F4 8B CE 2B CA 3B C8 72 02 8B C8 2B C1 89 45 F4 FF 75 EC FF 75 E8 51 52 56 8B CF E8 ?? ?? ?? ?? 29 75 F8 8B 4D F0 2B DE 8B 75 F8 85 DB 74 2D 83 7F 20 00 76 27 51 53 FF 77 20 8B CF E8 ?? ?? ?? ?? FF 75 F0 8B CF 8B F0 E8 ?? ?? ?? ?? 50 56 8B CF E8 ?? ?? ?? ?? 29 77 20 8B 75 F8 FF 47 24 E9 F1 FE FF FF 8B CF E8 ?? ?? ?? ?? 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_178_96_0 {
	meta:
		name = "?DynamicAssignCores@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@II_N@Z"
		size = 108
		refs = "0053 ?AddCore@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I_N@Z"
	strings:
		$1 = { 55 8B EC 51 53 8B 5D 14 56 8B 75 0C 6B F6 28 03 71 48 57 33 FF 33 C9 8B 46 20 03 C1 89 4D FC 83 38 02 75 04 84 DB 74 09 83 38 06 75 32 84 DB 74 2E FF 40 10 83 20 00 84 DB 74 05 FF 4E 1C EB 03 FF 4E 08 8B 45 0C 8B 4D 08 6B C0 34 03 41 10 53 57 50 E8 ?? ?? ?? ?? FF 4D 10 74 09 8B 4D FC 47 83 C1 24 EB B2 5F 5E 5B C9 C2 10 00 }
	condition:
		$1
}

rule file_178_97_0 {
	meta:
		name = "?DynamicMigrateCores@ResourceManager@details@Concurrency@@AAEXPAUDynamicAllocationData@23@PAVSchedulerProxy@23@II@Z"
		size = 360
		refs = "00f4 ?ToggleRMIdleState@ResourceManager@details@Concurrency@@AAEXPAUSchedulerNode@23@PAUSchedulerCore@23@PAUGlobalNode@23@PAUGlobalCore@23@PAUAllocationData@23@@Z 012c ?RemoveCore@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I@Z 0141 ?AddCore@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I_N@Z"
	strings:
		$1 = { 55 8B EC 83 EC 2C 8B 45 08 89 4D E0 8B 4D 10 8B 40 10 6B C9 34 8B 50 10 03 D1 53 8B 5D 14 89 4D D4 8B 4A 2C 56 57 89 45 D8 89 55 F0 3B D9 73 07 8B F3 89 75 F4 EB 05 8B F1 89 4D F4 8B 42 20 8B FB 2B C1 2B FE 3B F8 72 02 8B F8 8B 52 28 8B F3 2B F7 2B 75 F4 2B D1 89 55 EC 3B F2 73 05 8B D6 89 75 EC 8B 4D F0 33 C0 21 45 E4 2B F2 21 45 E8 8B 59 30 03 5D E8 89 45 F8 83 3B 04 0F 85 D1 00 00 00 83 7B 28 00 0F 87 C7 00 00 00 8A 43 31 84 C0 8A 43 30 88 45 FF 74 1C 84 C0 74 0D 8B 45 F4 85 C0 74 06 48 89 45 F4 EB 22 85 FF 0F 84 9E 00 00 00 4F EB 17 84 C0 74 0A 85 D2 74 06 4A 89 55 EC EB 09 85 F6 0F 84 85 00 00 00 4E 8B 4D 10 8B 45 E0 6B C9 28 8B 50 48 03 D1 8A 4D FF 8B 42 20 03 45 E4 84 C9 74 14 FF 75 08 8B 4D E0 50 52 53 FF 75 F0 E8 ?? ?? ?? ?? 8A 4D FF 8A 43 31 C6 45 DC 00 84 C0 74 15 8B 5D 08 C6 45 DC 01 84 C9 74 05 FF 4B 28 EB 0B FF 4B 2C EB 06 8B 45 08 FF 48 30 8B 5D F8 8B 4D D8 53 FF 75 F0 E8 ?? ?? ?? ?? 8B 55 0C FF 75 DC 8B 42 10 03 45 D4 53 50 8B CA E8 ?? ?? ?? ?? FF 4D 14 74 17 8B 55 EC 8B 4D F0 8B 45 F8 83 45 E8 34 40 83 45 E4 24 E9 0F FF FF FF 5F 5E 5B C9 C2 10 00 }
	condition:
		$1
}

rule file_178_98_0 {
	meta:
		name = "?DynamicRMThreadProc@ResourceManager@details@Concurrency@@CGKPAX@Z"
		size = 25
		refs = "0007 ?DynamicResourceManager@ResourceManager@details@Concurrency@@AAEXXZ 000e ?FreeLibraryAndDestroyThread@details@Concurrency@@YAXK@Z"
	strings:
		$1 = { 55 8B EC 8B 4D 08 E8 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? 59 33 C0 5D C2 04 00 }
	condition:
		$1
}

rule file_178_99_0 {
	meta:
		name = "?DynamicResourceManager@ResourceManager@details@Concurrency@@AAEXXZ"
		size = 257
		refs = "0003 __ehhandler$?DynamicResourceManager@ResourceManager@details@Concurrency@@AAEXXZ 0008 __EH_prolog3 0013 __imp__GetTickCount@0 0035 __imp__WaitForSingleObject@8 003f ?_Acquire@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ 0062 ?DoCoreMigration@ResourceManager@details@Concurrency@@AAEXXZ 006f ?SendResourceNotifications@ResourceManager@details@Concurrency@@QAEXPAVSchedulerProxy@23@@Z 0098 ?DiscardExistingSchedulerStatistics@ResourceManager@details@Concurrency@@AAEXXZ 00d0 ?DistributeCoresToSurvivingScheduler@ResourceManager@details@Concurrency@@AAE_NXZ 00e9 ?_Release@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ 00fc __EH_epilog3"
	strings:
		$1 = { 6A 0C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 6A 64 5B FF 15 ?? ?? ?? ?? 2D F4 01 00 00 83 7F 28 02 89 45 F0 0F 84 D2 00 00 00 8D 77 2C 89 75 EC 53 FF 77 50 FF 15 ?? ?? ?? ?? 8B CE 89 45 E8 E8 ?? ?? ?? ?? 8B 47 28 33 F6 89 75 FC 2B C6 74 7E 48 0F 85 8B 00 00 00 81 7D E8 02 01 00 00 75 1C 8B CF E8 ?? ?? ?? ?? 39 77 10 76 08 56 8B CF E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? EB 34 8B 1D ?? ?? ?? ?? FF D3 8B F0 2B 75 F0 83 FE 64 76 2A 81 FE 82 00 00 00 76 09 8B CF E8 ?? ?? ?? ?? EB 0F 33 F6 39 77 10 76 08 56 8B CF E8 ?? ?? ?? ?? FF D3 6A 64 89 45 F0 5B EB 2A 83 7F 10 00 76 09 6A 00 8B CF E8 ?? ?? ?? ?? 6A 64 5B 2B DE EB 14 8B CF E8 ?? ?? ?? ?? 0F B6 D8 F7 DB 1B DB 83 E3 9B 83 C3 64 8B 4D EC 83 4D FC FF E8 ?? ?? ?? ?? 83 7F 28 02 74 08 8B 75 EC E9 34 FF FF FF E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_178_101_0 {
	meta:
		name = "__ehhandler$?DynamicResourceManager@ResourceManager@details@Concurrency@@AAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?DynamicResourceManager@ResourceManager@details@Concurrency@@AAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_860_28_0 {
	meta:
		name = "__ehhandler$??0ScheduleGroupSegmentBase@details@Concurrency@@IAE@PAVScheduleGroupBase@12@PAVSchedulingRing@12@PAVlocation@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ScheduleGroupSegmentBase@details@Concurrency@@IAE@PAVScheduleGroupBase@12@PAVSchedulingRing@12@PAVlocation@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_449_34_0 {
	meta:
		name = "__ehhandler$?AddVirtualProcessorRoots@SchedulerProxy@details@Concurrency@@QAEXPAPAUIVirtualProcessorRoot@3@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AddVirtualProcessorRoots@SchedulerProxy@details@Concurrency@@QAEXPAPAUIVirtualProcessorRoot@3@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_553_64_0 {
	meta:
		name = "__ehhandler$?CancelStealers@ContextBase@details@Concurrency@@QAEXPAV_TaskCollectionBase@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CancelStealers@ContextBase@details@Concurrency@@QAEXPAV_TaskCollectionBase@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_741_20_0 {
	meta:
		name = "__ehhandler$?DoPolling@UMSBackgroundPoller@details@Concurrency@@QAE_NXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?DoPolling@UMSBackgroundPoller@details@Concurrency@@QAE_NXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_178_192_0 {
	meta:
		name = "__ehhandler$?RequestInitialVirtualProcessors@ResourceManager@details@Concurrency@@QAEPAUIExecutionResource@3@PAVSchedulerProxy@23@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?RequestInitialVirtualProcessors@ResourceManager@details@Concurrency@@QAEPAUIExecutionResource@3@PAVSchedulerProxy@23@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_553_199_0 {
	meta:
		name = "__ehhandler$?SyncPop@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEPAV_UnrealizedChore@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?SyncPop@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEPAV_UnrealizedChore@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_550_2 {
	meta:
		name = "__ehhandler$?_CancelWithException@_Task_impl_base@details@Concurrency@@QAE_NABVexception_ptr@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CancelWithException@_Task_impl_base@details@Concurrency@@QAE_NABVexception_ptr@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_50_2 {
	meta:
		name = "__ehhandler$?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXII@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXII@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_444_2 {
	meta:
		name = "__ehhandler$?_Copy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXII@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Copy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXII@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_520_1 {
	meta:
		name = "__ehhandler$?_Copy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXII@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Copy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXII@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_722_2 {
	meta:
		name = "__ehhandler$?_Makeushloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Makeushloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_731_2 {
	meta:
		name = "__ehhandler$?_Makewloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Makewloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_380_26_0 {
	meta:
		name = "__ehhandler$?_RethrowException@_TaskCollectionBase@details@Concurrency@@IAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_RethrowException@_TaskCollectionBase@details@Concurrency@@IAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_178_103_0 {
	meta:
		name = "?FindBestFitExclusiveAllocation@ResourceManager@details@Concurrency@@AAEIAAI0PAUDynamicAllocationData@23@II@Z"
		size = 837
		refs = "0236 ?DynamicAssignCores@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@II_N@Z 02fe ?DynamicMigrateCores@ResourceManager@details@Concurrency@@AAEXPAUDynamicAllocationData@23@PAVSchedulerProxy@23@II@Z"
	strings:
		$1 = { 55 8B EC 83 EC 48 8B 55 10 53 8B 42 10 56 8B 58 10 8B 70 14 89 5D E4 33 DB 83 7D 14 01 57 89 4D F0 89 45 B8 89 75 EC 75 05 88 5D 17 EB 06 8A 42 20 88 45 17 8B 42 2C 8B 49 18 83 CF FF 89 5D C4 89 7D FC 89 5D E8 89 5D D4 89 45 D0 89 4D BC 3B C1 0F 83 E1 02 00 00 8B 0C 86 8B 7D E4 8B C1 6B C0 34 89 45 C8 39 5C 38 1C 8B 7D E8 0F 85 55 01 00 00 8B 72 04 8B 7D E4 89 75 D8 3B 74 38 04 72 09 8B F7 8B 44 30 04 89 45 D8 8B 45 08 8B 7D E8 83 38 00 8B F3 89 5D DC 89 75 F8 76 23 8B 45 F0 6B C9 28 8B 40 48 8B 44 01 08 85 C0 74 12 8B 4D 08 39 01 73 02 8B 01 33 F6 46 89 45 DC 89 75 F8 8B 45 0C 8B CB 83 38 00 89 4D F4 0F 86 BE 00 00 00 83 7D 18 00 89 5D E0 0F 86 B1 00 00 00 8B 5D C8 8B 7D F0 3B 08 0F 83 9B 00 00 00 8B 47 58 8B 75 E0 8B 34 B0 89 75 CC 8B 4E 10 8B 81 A0 00 00 00 3B 46 24 76 68 8B 41 10 8B 4C 03 1C 2B 4C 03 24 74 5B 8B 55 CC 8B 74 03 2C 8B 52 28 89 55 C8 3B F2 73 03 89 75 C8 8B 44 03 20 8B D0 89 45 C0 8B 45 CC 2B D6 3B 50 2C 72 03 8B 50 2C 2B 4D C0 3B 48 30 72 03 8B 48 30 03 CA 03 4D C8 74 1F 8B 45 0C 8B 00 2B 45 F4 3B C1 72 02 8B C1 8B 4D F4 8B 75 F8 03 C8 46 89 4D F4 89 75 F8 EB 06 8B 75 F8 8B 4D F4 8B 45 E0 40 3B 45 18 89 45 E0 8B 45 0C 0F 82 5D FF FF FF 8B 7D E8 8B 55 10 33 DB 8B 45 DC 03 C1 80 7D 17 00 74 05 3B 45 D8 EB 0B 3B 7D D8 73 04 3B C7 77 09 3B C7 75 18 3B 75 D4 76 13 8B 4D D0 8B F8 89 75 D4 8B 75 EC 89 4D FC 89 7D E8 EB 06 8B 75 EC 8B 4D FC 8B 45 D0 40 89 45 D0 3B 45 BC 0F 82 7D FE FF FF 83 F9 FF 0F 84 55 01 00 00 8B 42 04 8B 0C 8E 89 4D 14 3B C7 73 02 8B F8 2B C7 89 42 04 8B 45 08 89 7D C4 8B 30 85 F6 74 3E 8B 45 F0 6B C9 28 8B 40 48 8B 44 01 08 85 C0 74 2D 8B CE 3B F0 72 02 8B C8 3B CF 73 08 3B F0 72 06 8B F0 EB 02 8B F7 8B 4D F0 53 56 FF 75 14 FF 75 B8 E8 ?? ?? ?? ?? 8B 45 08 29 30 2B FE 85 FF 0F 84 CE 00 00 00 8B 45 0C 39 18 0F 86 C3 00 00 00 3B 5D 18 0F 83 BA 00 00 00 8B 30 85 F6 0F 84 B0 00 00 00 8B 45 F0 8B 40 58 8B 0C 98 89 4D 08 8B 41 10 89 45 B8 8B 80 A0 00 00 00 3B 41 24 0F 86 83 00 00 00 8B 45 14 8B 4D B8 6B C0 34 03 41 10 8B 48 1C 2B 48 24 74 6F 8B 55 08 8B 52 28 89 55 C8 39 50 2C 73 06 8B 50 2C 89 55 C8 8B 50 20 89 55 B8 2B 50 2C 8B 45 08 3B 50 2C 72 03 8B 50 2C 2B 4D B8 3B 48 30 72 03 8B 48 30 8D 04 11 8B 55 10 03 45 C8 74 31 8B CE 3B F0 72 02 8B C8 3B CF 73 08 3B F0 72 06 8B F0 EB 02 8B F7 8B 4D F0 56 FF 75 14 FF 72 10 FF 75 08 E8 ?? ?? ?? ?? 8B 45 0C 29 30 2B FE EB 03 8B 45 0C 43 85 FF 0F 85 3D FF FF FF 8B 75 10 8B 5D EC 8B 56 2C 8B 7D FC 8B 0C 93 8B 04 BB 89 04 93 89 0C BB FF 46 2C C6 46 20 01 EB 03 88 5A 20 8B 45 C4 5F 5E 5B C9 C2 14 00 }
	condition:
		$1
}

rule file_178_104_0 {
	meta:
		name = "?FindBestFitIdleAllocation@ResourceManager@details@Concurrency@@AAEIIPAUDynamicAllocationData@23@I@Z"
		size = 268
		refs = "00c7 ?DynamicAssignCores@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@II_N@Z"
	strings:
		$1 = { 55 8B EC 83 EC 1C 53 56 8B 75 0C 89 4D F0 8B 46 10 33 DB 83 7D 10 01 8B 48 10 57 8B 78 14 89 4D E8 75 05 88 5D 13 EB 06 8A 46 20 88 45 13 8B 45 F0 8B 56 2C 8B 40 18 83 4D FC FF 8B CB 89 4D F8 89 45 E4 3B D0 0F 83 B5 00 00 00 8B 04 97 89 45 F4 6B C0 34 03 45 E8 39 58 1C 75 47 8B 4E 04 89 4D EC 3B 48 04 72 06 8B 40 04 89 45 EC 8B 45 F4 6B C0 28 89 45 F4 8B 45 F0 8B 75 F4 8B 40 48 8B CB 8B 44 06 1C 8B 75 0C 85 C0 74 0A 8B 4D 08 39 45 08 72 02 8B C8 38 5D 13 74 51 3B 4D EC 74 51 8B 4D F8 8B 45 FC 42 3B 55 E4 72 9F 83 F8 FF 74 4F 8B 5E 04 3B D9 72 02 8B D9 8B 4D F0 6A 01 53 FF 34 87 FF 76 10 E8 ?? ?? ?? ?? 29 5E 04 8B 56 2C 8B 45 FC 8B 0C 97 8B 04 87 89 04 97 8B 45 FC 89 0C 87 FF 46 2C C6 46 20 01 EB 17 3B 4D F8 76 AF 8B C2 89 45 FC 89 4D F8 38 5D 13 75 AE EB A6 88 5E 20 5F 5E 8B C3 5B C9 C2 0C 00 }
	condition:
		$1
}

rule file_178_105_0 {
	meta:
		name = "?FindCoreForPartiallyFilledNode@ResourceManager@details@Concurrency@@AAE_NAAI0PAUDynamicAllocationData@23@I@Z"
		size = 266
		refs = "0051 ?DynamicAssignCores@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@II_N@Z 00cd ?DynamicMigrateCores@ResourceManager@details@Concurrency@@AAEXPAUDynamicAllocationData@23@PAVSchedulerProxy@23@II@Z"
	strings:
		$1 = { 55 8B EC 51 51 53 56 8B 75 10 89 4D FC 8B 46 10 57 8B 48 10 8B 50 14 8B 46 2C 89 4D F8 8B 0C 82 8B 45 08 8B 55 FC 8B F9 32 DB 6B FF 34 83 38 00 89 4D 10 76 2A 8B 42 48 6B C9 28 83 7C 01 08 00 76 1D 6A 00 6A 01 FF 75 10 8B CA FF 76 10 FE C3 E8 ?? ?? ?? ?? 8B 45 08 FF 08 E9 8A 00 00 00 8B 45 0C 83 38 00 0F 86 93 00 00 00 33 C9 89 4D 08 39 4D 14 0F 86 85 00 00 00 84 DB 75 6C 8B 42 58 8B 0C 88 8B 41 10 8B 80 A0 00 00 00 3B 41 24 76 48 8B 51 10 8B 52 10 83 7C 17 2C 00 77 20 8B 44 17 20 2B 44 17 2C 74 06 83 79 2C 00 77 10 8B 44 17 1C 2B 44 17 24 74 1E 83 79 30 00 76 18 6A 01 FF 75 10 B3 01 FF 76 10 51 8B 4D FC E8 ?? ?? ?? ?? 8B 45 0C FF 08 8B 55 FC 8B 4D 08 41 89 4D 08 3B 4D 14 72 94 84 DB 74 15 8B 4D F8 8B 44 0F 1C 3B 44 0F 04 75 03 FF 46 2C FF 4E 04 EB 03 FF 46 2C 5F 5E 8A C3 5B C9 C2 10 00 }
	condition:
		$1
}

rule file_178_106_0 {
	meta:
		name = "?FindGroupAffinity@AffinityRestriction@ResourceManager@details@Concurrency@@QAEPAUHardwareAffinity@34@G@Z"
		size = 59
	strings:
		$1 = { 55 8B EC 56 0F B7 31 33 C0 57 85 F6 7E 1B 8B 49 04 66 8B 7D 08 8B D0 6B D2 0C 66 39 7C 0A 04 74 10 40 0F B7 D0 3B D6 7C EE 33 C0 5F 5E 5D C2 04 00 0F B7 C0 6B C0 0C 03 C1 EB F0 }
	condition:
		$1
}

rule file_178_110_0 {
	meta:
		name = "?GetCoreCount@ResourceManager@details@Concurrency@@SAIXZ"
		size = 75
		refs = "0003 __ehhandler$?GetCoreCount@ResourceManager@details@Concurrency@@SAIXZ 0008 __EH_prolog3 000d ?s_coreCount@ResourceManager@details@Concurrency@@0IA 0016 ?s_lock@ResourceManager@details@Concurrency@@0V_NonReentrantLock@23@A 001e ?_Acquire@_NonReentrantLock@details@Concurrency@@QAEXXZ 0031 ?InitializeSystemInformation@ResourceManager@details@Concurrency@@CAX_N@Z 0046 __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 75 30 B9 ?? ?? ?? ?? 89 4D F0 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 65 FC 00 85 C0 75 0C 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 59 C7 05 ?? ?? ?? ?? 00 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_178_128_0 {
	meta:
		name = "?GetNodeCount@ResourceManager@details@Concurrency@@SAIXZ"
		size = 75
		refs = "0003 __ehhandler$?GetNodeCount@ResourceManager@details@Concurrency@@SAIXZ 0008 __EH_prolog3 000d ?s_nodeCount@ResourceManager@details@Concurrency@@0IA 0016 ?s_lock@ResourceManager@details@Concurrency@@0V_NonReentrantLock@23@A 001e ?_Acquire@_NonReentrantLock@details@Concurrency@@QAEXXZ 0031 ?InitializeSystemInformation@ResourceManager@details@Concurrency@@CAX_N@Z 0046 __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 75 30 B9 ?? ?? ?? ?? 89 4D F0 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 65 FC 00 85 C0 75 0C 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 59 C7 05 ?? ?? ?? ?? 00 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_178_113_0 {
	meta:
		name = "?GetCurrentNodeAndCore@ResourceManager@details@Concurrency@@QAEIPAI@Z"
		size = 213
		refs = "000c ?Version@ResourceManager@details@Concurrency@@SA?AW4OSVersion@IResourceManager@3@XZ 0017 ?s_pfnGetCurrentProcessorNumberEx@ResourceManager@details@Concurrency@@0P6GXPAU_PROCESSOR_NUMBER@@@ZA 001c ?DecodePointer@Security@details@Concurrency@@SAPAXPAX@Z 0082 __imp__GetCurrentProcessorNumber@0"
	strings:
		$1 = { 55 8B EC 83 EC 0C 53 56 57 8B D9 E8 ?? ?? ?? ?? 83 F8 04 7C 6B FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8D 4D FC 51 FF D0 0F B6 4D FE 0F B7 55 FC 33 C0 40 D3 E0 89 4D F8 8B 4B 48 33 F6 89 45 F4 39 51 0C 75 29 85 01 74 25 33 D2 39 51 04 76 1A 8B 79 20 83 C7 08 0F B6 07 3B 45 F8 74 16 42 83 C7 24 3B 51 04 72 EF 8B 45 F4 0F B7 55 FC 46 83 C1 28 EB CC 8B 4D 08 85 C9 74 02 89 11 8B C6 EB 4E FF 15 ?? ?? ?? ?? 8B C8 33 C0 40 D3 E0 89 4D F4 8B 4B 48 33 D2 89 45 F8 85 01 74 21 33 F6 39 71 04 76 1A 8B 79 20 83 C7 08 0F B6 07 3B 45 F4 74 12 46 83 C7 24 3B 71 04 72 EF 8B 45 F8 42 83 C1 28 EB D5 8B 4D 08 85 C9 74 02 89 31 8B C2 5F 5E 5B C9 C2 04 00 }
	condition:
		$1
}

rule file_178_124_0 {
	meta:
		name = "?GetNext@TopologyObject@GlobalCore@details@Concurrency@@UBEPAUITopologyExecutionResource@4@XZ"
		size = 23
		refs = "0008 ?GetNextGlobalCore@GlobalNode@details@Concurrency@@QAEPAUGlobalCore@23@PBU423@@Z"
	strings:
		$1 = { 8B 49 04 51 8B 49 0C E8 ?? ?? ?? ?? 85 C0 74 04 8B 40 20 C3 33 C0 C3 }
	condition:
		$1
}

rule file_178_125_0 {
	meta:
		name = "?GetNext@TopologyObject@GlobalNode@details@Concurrency@@UBEPAUITopologyNode@4@XZ"
		size = 23
		refs = "0008 ?GetNextGlobalNode@ResourceManager@details@Concurrency@@QAEPAUGlobalNode@23@PBU423@@Z"
	strings:
		$1 = { 8B 49 04 51 8B 49 18 E8 ?? ?? ?? ?? 85 C0 74 04 8B 40 24 C3 33 C0 C3 }
	condition:
		$1
}

rule file_178_126_0 {
	meta:
		name = "?GetNextGlobalCore@GlobalNode@details@Concurrency@@QAEPAUGlobalCore@23@PBU423@@Z"
		size = 37
	strings:
		$1 = { 55 8B EC 8B 45 08 2B 41 20 56 6A 24 99 5E F7 FE 5E 40 3B 41 04 73 08 6B C0 24 03 41 20 EB 02 33 C0 5D C2 04 00 }
	condition:
		$1
}

rule file_178_127_0 {
	meta:
		name = "?GetNextGlobalNode@ResourceManager@details@Concurrency@@QAEPAUGlobalNode@23@PBU423@@Z"
		size = 37
	strings:
		$1 = { 55 8B EC 8B 45 08 2B 41 48 56 6A 28 99 5E F7 FE 5E 40 3B 41 18 73 08 6B C0 28 03 41 48 EB 02 33 C0 5D C2 04 00 }
	condition:
		$1
}

rule file_178_151_0 {
	meta:
		name = "?GetTopologyInformation@ResourceManager@details@Concurrency@@CAXW4_LOGICAL_PROCESSOR_RELATIONSHIP@@@Z"
		size = 274
		refs = "0008 ?s_version@ResourceManager@details@Concurrency@@0W4OSVersion@IResourceManager@3@A 0017 ??_C@_0CB@HOJBBPPI@GetLogicalProcessorInformationEx@ 001c ??_C@_1BK@MGMFAEKH@?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA3?$AA2?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 0022 __imp__GetModuleHandleW@4 0029 __imp__GetProcAddress@8 0035 __imp__GetLastError@0 0047 ?s_logicalProcessorInformationLength@ResourceManager@details@Concurrency@@0KA 0076 _malloc 007c ?s_pSysInfo@ResourceManager@details@Concurrency@@0PAU_SYSTEM_LOGICAL_PROCESSOR_INFORMATION@@A 0090 ??_C@_0P@GHFPNOJB@bad?5allocation?$AA@ 0095 ??0exception@std@@QAE@ABQBDH@Z 009c ??_7bad_alloc@std@@6B@ 00a1 __TI2?AVbad_alloc@std@@ 00bc __imp__GetLogicalProcessorInformation@8 00ff ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 0104 __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 010d __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 83 EC 14 83 3D ?? ?? ?? ?? 04 53 56 57 0F 8C A4 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B D8 85 DB 75 13 FF 15 ?? ?? ?? ?? 85 C0 0F 8E B9 00 00 00 E9 AC 00 00 00 BE ?? ?? ?? ?? 56 6A 00 FF 75 08 FF D3 8B 3D ?? ?? ?? ?? FF D7 83 F8 7A 74 0F FF D7 85 C0 0F 8E 90 00 00 00 E9 83 00 00 00 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 A3 ?? ?? ?? ?? 85 C0 75 26 6A 01 8D 45 FC 50 8D 4D F0 C7 45 FC ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 F0 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 EB 61 56 50 FF 75 08 FF D3 85 C0 74 AB 5F 5E 5B C9 C3 8B 1D ?? ?? ?? ?? BE ?? ?? ?? ?? 56 6A 00 FF D3 8B 3D ?? ?? ?? ?? FF D7 83 F8 7A 75 89 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 A3 ?? ?? ?? ?? 85 C0 74 98 56 50 FF D3 EB BF 0F B7 C0 0D 00 00 07 80 50 8D 4D EC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 EC 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_178_152_0 {
	meta:
		name = "?HandleBorrowedCores@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@PAUAllocationData@23@@Z"
		size = 281
		refs = "0081 ?ToggleBorrowedState@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I@Z 00cd ?ToggleRMIdleState@ResourceManager@details@Concurrency@@AAEXPAUSchedulerNode@23@PAUSchedulerCore@23@PAUGlobalNode@23@PAUGlobalCore@23@PAUAllocationData@23@@Z 00da ?RemoveCore@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I@Z"
	strings:
		$1 = { 55 8B EC 83 EC 1C 56 8B 75 08 8B D1 8B 76 10 33 C0 89 55 F8 89 45 EC 39 42 18 0F 86 F4 00 00 00 33 C9 53 89 4D FC 83 C6 2C 57 83 7E F4 00 0F 86 C8 00 00 00 33 DB 39 5E D8 0F 86 BD 00 00 00 21 5D F4 33 C0 89 45 F0 8B 7E 04 03 F8 83 3F 04 0F 85 8F 00 00 00 8A 47 31 84 C0 0F 84 84 00 00 00 8B 42 48 8B 44 01 20 03 45 F4 89 45 E4 8B 48 10 89 4D E8 83 F9 01 75 23 8B 4D 08 53 8D 46 D4 50 E8 ?? ?? ?? ?? 80 7F 30 00 8B 55 F8 8B 4D FC 74 53 8B 45 0C FF 0E FF 48 18 EB 49 2B 48 1C 33 C0 38 47 30 0F 94 C0 3B C8 76 37 8B 45 E8 8B 4D E4 48 89 41 10 80 7F 30 00 74 17 FF 75 0C 8B 42 48 03 45 FC 51 50 57 8D 46 D4 50 8B CA E8 ?? ?? ?? ?? 8B 4D 08 53 8D 46 D4 50 E8 ?? ?? ?? ?? 8B 55 F8 8B 4D FC 83 45 F0 34 83 45 F4 24 8B 45 F0 43 3B 5E D8 0F 82 4E FF FF FF 8B 45 EC 40 83 C1 28 83 C6 34 89 45 EC 89 4D FC 3B 42 18 0F 82 18 FF FF FF 5F 5B 5E C9 C2 08 00 }
	condition:
		$1
}

rule file_178_153_0 {
	meta:
		name = "?HandleSharedCores@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@PAUDynamicAllocationData@23@@Z"
		size = 341
		refs = "0018 ?MinVprocHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 0104 ?ToggleRMIdleState@ResourceManager@details@Concurrency@@AAEXPAUSchedulerNode@23@PAUSchedulerCore@23@PAUGlobalNode@23@PAUGlobalCore@23@PAUAllocationData@23@@Z 0112 ?RemoveCore@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I@Z"
	strings:
		$1 = { 55 8B EC 83 EC 1C 53 8B 5D 08 56 8B B3 A0 00 00 00 89 4D F8 57 8B CB E8 ?? ?? ?? ?? 8B D0 8B 45 0C 03 93 B8 00 00 00 8B CE 2B 48 18 8B FE 2B BB A8 00 00 00 2B 48 24 8B C7 2B C2 3B C8 73 0B 8B 45 0C 2B 70 18 2B 70 24 EB 11 8B CB E8 ?? ?? ?? ?? 03 83 B8 00 00 00 8B F7 2B F0 8B 7B 10 33 D2 89 55 E4 85 F6 0F 84 E3 00 00 00 21 55 EC 83 C7 24 8B 45 F8 3B 50 18 0F 83 D1 00 00 00 8B 47 F8 2B 07 0F 84 B3 00 00 00 33 C9 89 4D F4 85 F6 0F 84 A6 00 00 00 21 4D FC 8B 45 FC 33 D2 89 55 F0 3B 4F E0 0F 83 8F 00 00 00 8B 4F 0C 03 CA 83 39 04 75 6A 83 79 28 00 77 64 8A 41 31 84 C0 75 5A 8B 45 F8 8B 55 EC 8B 40 48 8B 44 10 20 03 45 FC 89 45 E8 8B 40 10 83 F8 01 76 3C 8B 5D E8 48 89 43 10 8A 41 30 8B 5D 08 84 C0 74 1C FF 75 0C 8B 45 F8 FF 75 E8 8B 40 48 03 C2 50 51 8B 4D F8 8D 47 DC 50 E8 ?? ?? ?? ?? FF 75 F4 8D 47 DC 50 8B CB E8 ?? ?? ?? ?? 4E 8B 55 F0 8B 45 FC 8B 4D F4 41 83 C2 34 83 C0 24 89 4D F4 89 55 F0 89 45 FC 85 F6 0F 85 68 FF FF FF 8B 55 E4 83 45 EC 28 42 83 C7 34 89 55 E4 85 F6 0F 85 23 FF FF FF 5F 5E 5B C9 C2 08 00 }
	condition:
		$1
}

rule file_178_154_0 {
	meta:
		name = "?IncreaseFullyLoadedSchedulerAllocations@ResourceManager@details@Concurrency@@AAEXXZ"
		size = 54
		refs = "001c ?DesiredHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 0025 ?AdjustAllocationIncrease@SchedulerProxy@details@Concurrency@@QBEII@Z"
	strings:
		$1 = { 56 57 8B F9 33 F6 39 77 08 76 28 53 8B 47 54 8B 1C B0 80 7B 21 01 75 14 8B 4B 10 E8 ?? ?? ?? ?? 8B 4B 10 50 E8 ?? ?? ?? ?? 89 43 24 46 3B 77 08 72 DA 5B 5F 5E C3 }
	condition:
		$1
}

rule file_178_156_0 {
	meta:
		name = "?Initialize@GlobalCore@details@Concurrency@@QAEXPAUGlobalNode@23@IE@Z"
		size = 57
		refs = "0009 ??2@YAPAXI@Z 0014 ??_7TopologyObject@GlobalCore@details@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 56 6A 08 8B F1 E8 ?? ?? ?? ?? 59 85 C0 74 0B C7 00 ?? ?? ?? ?? 89 70 04 EB 02 33 C0 89 46 20 8B 45 08 89 46 0C 8B 45 0C 89 46 04 8A 45 10 88 46 08 5E 5D C2 0C 00 }
	condition:
		$1
}

rule file_178_157_0 {
	meta:
		name = "?Initialize@GlobalNode@details@Concurrency@@QAEXPAVResourceManager@23@GGKII@Z"
		size = 281
		refs = "000b ??2@YAPAXI@Z 0018 ??_7TopologyObject@GlobalNode@details@Concurrency@@6B@ 0085 ??_U@YAPAXI@Z 00a4 _memset 00fa ?Initialize@GlobalCore@details@Concurrency@@QAEXPAUGlobalNode@23@IE@Z"
	strings:
		$1 = { 55 8B EC 53 56 57 6A 08 8B F1 E8 ?? ?? ?? ?? 33 DB 59 85 C0 74 0B C7 00 ?? ?? ?? ?? 89 70 04 EB 02 8B C3 8B 4D 18 89 46 24 8B 45 08 89 46 18 0F B7 45 0C 89 46 10 0F B7 45 10 89 46 0C 8B 45 14 89 06 85 C9 75 18 8B C8 8B D3 85 C0 74 08 8D 41 FF 42 23 C8 75 F8 0F B7 C2 89 46 04 EB 03 89 4E 04 8B 7E 04 33 C9 6A 24 5A 8B C7 F7 E2 0F 90 C1 89 5E 08 F7 D9 0B C8 33 C0 83 C1 04 0F 92 C0 F7 D8 0B C1 50 E8 ?? ?? ?? ?? 59 85 C0 74 07 89 38 8D 48 04 EB 02 8B CB 8B 46 04 6B C0 24 50 53 51 89 4E 20 E8 ?? ?? ?? ?? 83 C4 0C 8B D3 39 5E 04 76 60 8B 45 14 8B 4D 18 8B FB 85 C9 75 13 A8 01 74 45 8B 4E 20 8B 46 0C 03 CF 42 89 55 10 53 EB 1E 8A 45 1C 8B 4E 20 02 C3 0F B6 C0 03 CF 42 50 8B 46 0C 89 55 10 0F B7 55 0C C1 E0 08 03 C2 C1 E0 08 03 C3 50 56 83 C7 24 E8 ?? ?? ?? ?? 8B 4D 18 8B 55 10 8B 45 14 D1 E8 43 89 45 14 3B 56 04 72 A8 5F 5E 5B 5D C2 18 00 }
	condition:
		$1
}

rule file_178_158_0 {
	meta:
		name = "?Initialize@GlobalNumaNode@details@Concurrency@@QAEXKGK@Z"
		size = 25
	strings:
		$1 = { 55 8B EC 8B 45 08 89 41 08 0F B7 45 0C 89 41 04 8B 45 10 89 01 5D C2 0C 00 }
	condition:
		$1
}

rule file_178_159_0 {
	meta:
		name = "?InitializeRMBuffers@ResourceManager@details@Concurrency@@AAEXXZ"
		size = 194
		refs = "001d ??_V@YAXPAX@Z 0044 ??_U@YAPAXI@Z 0090 _memset"
	strings:
		$1 = { 56 8B F1 57 8B 46 0C 33 FF 3B 46 08 73 76 03 C0 3B 46 08 72 F9 53 FF 76 54 89 46 0C E8 ?? ?? ?? ?? FF 76 58 E8 ?? ?? ?? ?? FF 76 5C E8 ?? ?? ?? ?? 8B 46 0C 33 C9 6A 04 5B F7 E3 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 10 89 46 54 39 7E 58 74 30 8B 46 0C 33 C9 F7 E3 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 89 46 58 8B 46 0C 33 C9 F7 E3 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 59 59 89 46 5C 5B 8B 46 08 C1 E0 02 50 57 FF 76 54 E8 ?? ?? ?? ?? 83 C4 0C 39 7E 58 74 23 8B 46 08 C1 E0 02 50 57 FF 76 58 E8 ?? ?? ?? ?? 8B 46 08 C1 E0 02 50 57 FF 76 5C E8 ?? ?? ?? ?? 83 C4 18 5F 5E C3 }
	condition:
		$1
}

rule file_178_160_0 {
	meta:
		name = "?InitializeSetThreadGroupAffinityFn@HardwareAffinity@details@Concurrency@@SAXXZ"
		size = 127
		refs = "000a ??_C@_1BK@MGMFAEKH@?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA3?$AA2?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 0010 __imp__GetModuleHandleW@4 0016 __imp__GetProcAddress@8 001d ??_C@_0BH@CJPDKMEB@SetThreadGroupAffinity?$AA@ 0025 ??_C@_0BH@CINNILJO@GetThreadGroupAffinity?$AA@ 003a ?EncodePointer@Security@details@Concurrency@@SAPAXPAX@Z 0040 ?s_pfnSetThreadGroupAffinity@HardwareAffinity@details@Concurrency@@0P6GHPAXPAU_GROUP_AFFINITY@@1@ZA 004e ?s_pfnGetThreadGroupAffinity@HardwareAffinity@details@Concurrency@@0P6GHPAXPAU_GROUP_AFFINITY@@@ZA 0057 __imp__GetLastError@0 006c ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 0071 __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 007a __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 57 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 8B F8 68 ?? ?? ?? ?? 57 FF D6 68 ?? ?? ?? ?? 57 8B D8 FF D6 8B F0 85 DB 74 21 85 F6 74 1D 53 E8 ?? ?? ?? ?? 56 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 5F 5E A3 ?? ?? ?? ?? 5B C9 C3 FF 15 ?? ?? ?? ?? 85 C0 7E 08 0F B7 C0 0D 00 00 07 80 50 8D 4D F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_178_161_0 {
	meta:
		name = "?InitializeSystemFunctionPointers@ResourceManager@details@Concurrency@@CAXXZ"
		size = 105
		refs = "0008 ?s_version@ResourceManager@details@Concurrency@@0W4OSVersion@IResourceManager@3@A 0010 ?InitializeSetThreadGroupAffinityFn@HardwareAffinity@details@Concurrency@@SAXXZ 0015 ??_C@_0BM@JLHMEGJA@GetCurrentProcessorNumberEx?$AA@ 001a ??_C@_1BK@MGMFAEKH@?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA3?$AA2?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 0020 __imp__GetModuleHandleW@4 0027 __imp__GetProcAddress@8 0031 __imp__GetLastError@0 003d ?EncodePointer@Security@details@Concurrency@@SAPAXPAX@Z 0043 ?s_pfnGetCurrentProcessorNumberEx@ResourceManager@details@Concurrency@@0P6GXPAU_PROCESSOR_NUMBER@@@ZA 0056 ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 005b __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 0064 __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 83 EC 10 83 3D ?? ?? ?? ?? 04 7C 38 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 0C FF 15 ?? ?? ?? ?? 85 C0 7E 18 EB 0E 50 E8 ?? ?? ?? ?? 59 A3 ?? ?? ?? ?? C9 C3 0F B7 C0 0D 00 00 07 80 50 8D 4D F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_178_162_0 {
	meta:
		name = "?InitializeSystemInformation@ResourceManager@details@Concurrency@@CAX_N@Z"
		size = 459
		refs = "0008 ?s_version@ResourceManager@details@Concurrency@@0W4OSVersion@IResourceManager@3@A 0010 ?RetrieveSystemVersionInformation@ResourceManager@details@Concurrency@@CAXXZ 0016 ?s_pUserAffinityRestriction@ResourceManager@details@Concurrency@@0PAUAffinityRestriction@123@A 001e ?CaptureProcessAffinity@ResourceManager@details@Concurrency@@CAXXZ 0038 ?GetTopologyInformation@ResourceManager@details@Concurrency@@CAXW4_LOGICAL_PROCESSOR_RELATIONSHIP@@@Z 003e ?s_pSysInfo@ResourceManager@details@Concurrency@@0PAU_SYSTEM_LOGICAL_PROCESSOR_INFORMATION@@A 0059 ?s_logicalProcessorInformationLength@ResourceManager@details@Concurrency@@0KA 006d ?ApplyAffinityRestrictions@ResourceManager@details@Concurrency@@CAXPAU_GROUP_AFFINITY@@@Z 00dc ?s_countProcessorPackages@ResourceManager@details@Concurrency@@0_NA 00e2 ?s_nodeCount@ResourceManager@details@Concurrency@@0IA 00f2 ?s_coreCount@ResourceManager@details@Concurrency@@0IA 00f8 ?s_numaNodeCount@ResourceManager@details@Concurrency@@0IA 012b ?ApplyAffinityRestrictions@ResourceManager@details@Concurrency@@CAXPAK@Z 01a1 ?CleanupTopologyInformation@ResourceManager@details@Concurrency@@CAXXZ 01a7 ?s_pProcessAffinityRestriction@ResourceManager@details@Concurrency@@0PAUAffinityRestriction@123@A 01b3 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 83 3D ?? ?? ?? ?? 00 75 05 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 05 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 04 53 56 57 68 FF FF 00 00 0F 8C CA 00 00 00 E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 59 33 C9 33 F6 33 D2 33 DB 89 4D FC 89 75 F8 89 55 F4 89 5D F0 39 0D ?? ?? ?? ?? 76 77 83 3F 03 75 40 83 65 F8 00 8D 5F 20 53 E8 ?? ?? ?? ?? 59 8B 0B 85 C9 74 11 46 33 D2 8D 41 FF 42 23 C8 75 F8 0F B7 C2 01 45 F4 8B 4D F8 0F B7 47 1E 41 83 C3 0C 89 4D F8 3B C8 7C D0 8B 5D F0 8B 4D FC 89 75 F8 83 3F 01 75 19 8D 77 20 56 E8 ?? ?? ?? ?? 83 3E 00 8B 75 F8 59 8B 4D FC 74 04 43 89 5D F0 03 4F 04 03 7F 04 89 4D FC 3B 0D ?? ?? ?? ?? 72 8C 8B 55 F4 3B F3 0F 97 C0 A2 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 84 C0 75 06 89 1D ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? E9 99 00 00 00 E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 33 C0 59 33 C9 33 DB 33 FF 89 45 FC 89 4D F4 39 05 ?? ?? ?? ?? 76 51 83 7E 04 03 75 21 56 E8 ?? ?? ?? ?? 59 8B 0E 85 C9 74 11 43 33 D2 8D 41 FF 42 23 C8 75 F8 0F B7 C2 01 45 F4 8B 45 FC 83 7E 04 01 75 10 56 E8 ?? ?? ?? ?? 83 3E 00 8B 45 FC 59 74 01 47 83 C0 18 83 C6 18 89 45 FC 3B 05 ?? ?? ?? ?? 72 B2 8B 4D F4 3B DF 0F 97 C0 A2 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 84 C0 75 06 89 3D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 3D ?? ?? ?? ?? 80 7D 08 00 75 05 E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 85 F6 74 10 FF 76 04 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 83 25 ?? ?? ?? ?? 00 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_178_170_0 {
	meta:
		name = "?Next@?$List@VSchedulerProxy@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QBEPAVSchedulerProxy@23@PAV423@@Z"
		size = 22
	strings:
		$1 = { 55 8B EC 8B 45 08 3B 41 04 74 05 8B 40 18 EB 02 33 C0 5D C2 04 00 }
	condition:
		$1
}

rule file_178_171_0 {
	meta:
		name = "?NumberOfBitsSet@details@Concurrency@@YAGK@Z"
		size = 22
	strings:
		$1 = { 55 8B EC 8B 55 08 33 C0 85 D2 74 08 8D 4A FF 40 23 D1 75 F8 5D C3 }
	condition:
		$1
}

rule file_178_172_0 {
	meta:
		name = "?PerformAllocation@ResourceManager@details@Concurrency@@QAEPAVExecutionResource@23@PAVSchedulerProxy@23@_N1@Z"
		size = 342
		refs = "0015 ?CreateAllocatedNodeData@ResourceManager@details@Concurrency@@QAEPAUSchedulerNode@23@XZ 002f ?ComputeMinHWThreadsWithExternalThread@SchedulerProxy@details@Concurrency@@QBEIXZ 0039 ?ComputeDesiredHWThreadsWithExternalThread@SchedulerProxy@details@Concurrency@@QBEIXZ 004f ?MinVprocHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 0086 ?DesiredHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 00a1 ?SetupStaticAllocationData@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@_N@Z 00a8 ?PreProcessStaticAllocationData@ResourceManager@details@Concurrency@@AAEXXZ 00b4 ?ReserveCores@ResourceManager@details@Concurrency@@AAEIPAVSchedulerProxy@23@II@Z 00da ?ReleaseCoresOnExistingSchedulers@ResourceManager@details@Concurrency@@AAEIPAVSchedulerProxy@23@II@Z 00f8 ?RedistributeCoresAmongAll@ResourceManager@details@Concurrency@@AAEIPAVSchedulerProxy@23@III@Z 0122 ?ReserveAtHigherUseCounts@ResourceManager@details@Concurrency@@AAEIPAVSchedulerProxy@23@I@Z 012b ?ResetGlobalAllocationData@ResourceManager@details@Concurrency@@AAEXXZ 0139 ?GrantAllocation@SchedulerProxy@details@Concurrency@@QAEPAVExecutionResource@23@I_N0@Z 0149 ?CommitStolenCores@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 80 7D 0C 00 53 56 8B 75 08 57 8B F9 74 08 E8 ?? ?? ?? ?? 89 46 10 8B 86 A0 00 00 00 33 DB 89 45 F0 8B CE 38 5D 10 74 44 E8 ?? ?? ?? ?? 8B CE 89 45 F4 E8 ?? ?? ?? ?? 8B C8 89 4D FC 38 5D 0C 74 05 8B 45 F4 EB 21 8B CE E8 ?? ?? ?? ?? 03 86 B8 00 00 00 3B 47 1C 8B 45 F4 1B C9 F7 D9 39 45 F0 89 4D FC 1B C0 F7 D8 89 45 F8 EB 1D E8 ?? ?? ?? ?? 03 86 B8 00 00 00 8B CE 89 45 F4 89 45 F8 E8 ?? ?? ?? ?? 8B C8 89 45 FC 88 5D 0B 85 C9 0F 84 95 00 00 00 FF 75 10 8B CF 56 E8 ?? ?? ?? ?? 8B CF E8 ?? ?? ?? ?? 53 FF 75 FC 8B CF 56 E8 ?? ?? ?? ?? 8B D8 8B 45 FC 3B D8 73 67 80 7D 0C 00 75 06 83 7D F8 00 76 5B 6A FE 2B C3 50 56 8B CF C6 45 0B 01 E8 ?? ?? ?? ?? 03 D8 8B 45 FC 3B D8 73 41 8B 4D F0 03 C1 50 FF 75 F4 8D 04 0B 50 56 8B CF E8 ?? ?? ?? ?? 03 D8 8B 45 F8 3B D8 73 23 6A FF 2B C3 50 56 8B CF E8 ?? ?? ?? ?? 03 D8 8B 45 F8 3B D8 73 0D 2B C3 50 56 8B CF E8 ?? ?? ?? ?? 03 D8 8B CF E8 ?? ?? ?? ?? FF 75 10 8B CE FF 75 0C 53 E8 ?? ?? ?? ?? 80 7D 0B 00 8B D8 74 08 56 8B CF E8 ?? ?? ?? ?? 5F 5E 8B C3 5B C9 C2 0C 00 }
	condition:
		$1
}

rule file_178_173_0 {
	meta:
		name = "?PopulateCommonAllocationData@ResourceManager@details@Concurrency@@AAEXIPAVSchedulerProxy@23@PAUAllocationData@23@@Z"
		size = 198
		refs = "008a ?ToggleRMIdleState@ResourceManager@details@Concurrency@@AAEXPAUSchedulerNode@23@PAUSchedulerCore@23@PAUGlobalNode@23@PAUGlobalCore@23@PAUAllocationData@23@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 08 D9 EE 56 57 8B 7D 10 89 4D FC 89 07 DD 5F 08 8B 45 0C 89 47 10 8B 70 10 85 F6 0F 84 97 00 00 00 33 D2 53 8B DA 89 5D F8 39 51 18 0F 86 85 00 00 00 8B C2 89 45 F4 83 C6 2C 89 56 FC 89 16 39 56 F0 76 61 89 55 10 39 56 D8 76 59 8B 5D FC 89 55 0C 89 55 08 8B CA 8B 56 04 03 55 08 83 3A 04 C6 42 30 00 75 26 83 7A 18 00 75 20 8B 4B 48 03 C8 57 8B 41 20 03 45 0C 50 51 52 8D 46 D4 50 8B CB E8 ?? ?? ?? ?? 8B 45 F4 8B 4D 10 83 45 08 34 83 45 0C 24 41 89 4D 10 3B 4E D8 72 BA 8B 5D F8 8B 4D FC 33 D2 43 83 C0 28 83 C6 34 89 5D F8 89 45 F4 3B 59 18 72 83 5B 5F 5E C9 C2 0C 00 }
	condition:
		$1
}

rule file_178_174_0 {
	meta:
		name = "?PopulateDynamicAllocationData@ResourceManager@details@Concurrency@@AAEXXZ"
		size = 272
		refs = "0012 ?InitializeRMBuffers@ResourceManager@details@Concurrency@@AAEXXZ 0036 _memset 0045 ?PopulateCommonAllocationData@ResourceManager@details@Concurrency@@AAEXIPAVSchedulerProxy@23@PAUAllocationData@23@@Z 0089 ?Update@HillClimbing@details@Concurrency@@QAEIIIII@Z 009c ?AdjustAllocationIncrease@SchedulerProxy@details@Concurrency@@QBEII@Z 00f4 ?DesiredHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ"
	strings:
		$1 = { 55 8B EC 83 EC 14 83 65 F8 00 56 8B F1 57 89 75 EC E8 ?? ?? ?? ?? 8B 7E 64 85 FF 74 05 8B 7F 18 EB 02 33 FF 85 FF 0F 84 E0 00 00 00 53 6A 38 8D 5F 40 6A 00 53 E8 ?? ?? ?? ?? 83 C4 0C 8B CE 53 57 FF 75 F8 E8 ?? ?? ?? ?? 8A 87 CC 00 00 00 84 C0 74 58 8B 47 78 8B 4F 08 83 65 F0 00 83 65 F4 00 8B B7 A0 00 00 00 8D 55 FC 52 8D 55 F4 52 89 45 FC 8B 01 8D 55 F0 52 FF 50 04 FF 75 FC 8B 4F 38 FF 75 F4 FF 75 F0 56 E8 ?? ?? ?? ?? 89 43 24 3B 87 A0 00 00 00 76 0B 50 8B CF E8 ?? ?? ?? ?? 89 43 24 8B 45 FC 89 47 78 EB 09 8B 87 A0 00 00 00 89 43 24 8B B7 A0 00 00 00 85 F6 74 25 83 7B 14 00 74 28 33 C0 8B 75 EC 8B 4D F8 88 43 21 8B 46 54 89 1C 88 41 89 4D F8 3B 7E 64 74 23 8B 7F 18 EB 20 83 BF C4 00 00 00 00 76 D8 3B 73 24 77 D3 8B CF E8 ?? ?? ?? ?? 3B F0 73 C8 33 C0 40 EB C5 33 FF 85 FF 0F 85 22 FF FF FF 5B 5F 5E C9 C3 }
	condition:
		$1
}

rule file_178_175_0 {
	meta:
		name = "?PreProcessDynamicAllocationData@ResourceManager@details@Concurrency@@AAEXXZ"
		size = 209
		refs = "002b ?HandleBorrowedCores@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@PAUAllocationData@23@@Z 0049 ?MinVprocHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 00a4 ?HandleSharedCores@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@PAUDynamicAllocationData@23@@Z"
	strings:
		$1 = { 55 8B EC 51 51 53 33 DB 89 4D FC 39 59 08 0F 86 BA 00 00 00 56 57 8B 41 54 8B 3C 98 8B 77 10 83 BE A8 00 00 00 00 76 07 57 56 E8 ?? ?? ?? ?? 83 7F 14 00 76 41 8B 86 A0 00 00 00 89 45 F8 2B 47 14 39 47 24 76 30 8B CE E8 ?? ?? ?? ?? 8B 55 F8 03 86 B8 00 00 00 8B CA 2B 4F 14 3B C1 76 11 8B CE E8 ?? ?? ?? ?? 8B D0 03 96 B8 00 00 00 EB 03 2B 57 14 89 57 24 8B 86 A0 00 00 00 89 45 F8 39 47 24 73 24 8B CE E8 ?? ?? ?? ?? 8B 4D F8 03 86 B8 00 00 00 2B 8E A8 00 00 00 3B C8 76 0A 8B 4D FC 57 56 E8 ?? ?? ?? ?? 80 BE CC 00 00 00 00 75 0E 8B 86 A0 00 00 00 39 47 24 76 03 89 47 24 8B 4D FC 43 3B 59 08 0F 82 4A FF FF FF 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_178_176_0 {
	meta:
		name = "?PreProcessStaticAllocationData@ResourceManager@details@Concurrency@@AAEXXZ"
		size = 47
		refs = "0022 ?HandleBorrowedCores@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@PAUAllocationData@23@@Z"
	strings:
		$1 = { 56 57 8B F9 33 F6 39 77 08 76 21 8B 47 54 8B 04 B0 8B 48 10 83 B9 A8 00 00 00 00 76 09 50 51 8B CF E8 ?? ?? ?? ?? 46 3B 77 08 72 DF 5F 5E C3 }
	condition:
		$1
}

rule file_178_177_0 {
	meta:
		name = "?PrepareReceiversForCoreTransfer@ResourceManager@details@Concurrency@@AAEII@Z"
		size = 559
	strings:
		$1 = { 55 8B EC 83 EC 30 8B 55 08 53 56 8B F1 33 C9 57 89 75 F0 85 D2 74 47 3B CA 73 20 8B 7E 5C 8B 1C 8F 83 7B 04 00 75 11 4A 8B 04 97 89 04 8F 8B 46 5C 89 1C 90 3B CA 72 E3 89 55 08 8B 46 5C 8B 04 88 83 60 28 00 8B 46 5C 8B 04 88 83 60 2C 00 8B 46 5C 8B 04 88 41 C6 40 20 01 3B CA 72 BD 33 C9 89 55 D0 85 D2 74 62 3B CA 73 59 8B 46 5C 8B 04 88 83 78 28 00 75 4A 8B 40 10 33 DB 8B 78 10 39 5E 18 76 20 83 C7 1C 8B 07 85 C0 74 0E 3B 47 E8 73 09 8B 46 5C 8B 04 88 FF 40 28 43 83 C7 34 3B 5E 18 72 E3 8B 7E 5C 8B 1C 8F 83 7B 28 00 75 0D 4A 8B 04 97 89 04 8F 8B 46 5C 89 1C 90 3B CA 72 AA 89 55 08 41 3B CA 72 A2 33 FF 89 7D F8 85 D2 0F 84 4F 01 00 00 8D 47 01 89 7D F4 89 45 D4 8B D8 3B C2 73 6B 8B 46 5C 89 45 FC 8B C7 C1 E0 02 8B C8 8B F7 8B 7D FC 89 45 E8 89 4D EC 8B 04 9F 8B 0C 39 8B 40 28 3B 41 28 73 0C 8B CB C1 E1 02 8B F3 89 4D EC EB 03 8B 4D EC 43 3B DA 72 DE 8B 7D F8 89 75 F4 3B FE 8B 75 F0 74 24 8B 45 FC 8B 4D E8 8B 5D F4 8B 0C 01 8B 04 98 8B 7D FC 8B 75 E8 89 04 3E 8B 75 F0 8B 7D F8 8B 46 5C 89 0C 98 8B 46 5C 8B 0C B8 8B 41 10 8B 58 10 8B 40 14 89 5D E8 33 DB 89 45 F4 89 5D E4 39 59 28 0F 86 A4 00 00 00 8B D0 8B 04 9A 8B 7E 18 8B C8 6B C9 34 03 4D E8 89 45 D8 8D 43 01 89 7D DC 3B C7 8B 7D F8 89 5D FC 89 45 EC 89 45 E0 73 64 8B 75 F4 8B 5D DC 8B F8 8B 04 BE 6B C0 34 03 45 E8 89 45 DC 8B 50 1C 85 D2 74 1F 3B 50 04 73 1A 8B 41 1C 85 C0 74 09 3B 41 04 73 04 3B D0 76 0A 8B 4D DC 8B C7 89 45 FC EB 03 8B 45 FC 47 3B FB 72 C6 8B 5D E4 8B 75 F0 8B 7D F8 8B 55 F4 3B D8 74 0F 8B 04 82 8B 4D D8 89 04 9A 8B 45 FC 89 0C 82 8B 45 EC 8B D8 8B 46 5C 89 5D E4 8B 04 B8 3B 58 28 0F 82 61 FF FF FF 8B 55 08 8B 7D D4 89 7D F8 3B FA 0F 82 B1 FE FF FF 8B 45 D0 5F 5E 5B C9 C2 04 00 }
	condition:
		$1
}

rule file_178_178_0 {
	meta:
		name = "?RedistributeCoresAmongAll@ResourceManager@details@Concurrency@@AAEIPAVSchedulerProxy@23@III@Z"
		size = 979
		refs = "004b ?MinVprocHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 00b4 ??_U@YAPAXI@Z 00d4 __real@41f0000000000000 00e5 __real@0000000000000000 0186 ?RoundUpScaledAllocations@ResourceManager@details@Concurrency@@CAXPAPAUAllocationData@23@II@Z 0256 ?DesiredHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 039d ?ReleaseSchedulerResources@ResourceManager@details@Concurrency@@AAE_NPAVSchedulerProxy@23@0I@Z 03bb ?ReserveCores@ResourceManager@details@Concurrency@@AAEIPAVSchedulerProxy@23@II@Z 03c4 ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 83 EC 3C 83 65 E4 00 53 8B C1 33 DB 8B 48 08 43 89 45 F8 3B CB 0F 86 AD 03 00 00 8B 55 0C 56 57 8B 78 54 6A 04 58 03 F8 49 8B F3 8B 5D 10 89 55 FC 89 4D F4 8B 07 8B 40 10 89 45 EC 8B 88 B8 00 00 00 89 4D 10 8B C8 E8 ?? ?? ?? ?? 8B 4D EC 03 45 10 8B 91 A0 00 00 00 2B 91 A8 00 00 00 89 55 EC 3B D0 76 16 46 E8 ?? ?? ?? ?? 03 45 10 03 D8 8B 45 FC 03 45 EC 89 45 FC EB 03 8B 45 FC 6A 04 5A 03 FA FF 4D F4 75 AC 89 5D 10 33 DB 43 89 75 F4 3B F3 0F 86 2D 03 00 00 39 45 10 0F 87 24 03 00 00 33 C9 8B C6 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? DB 45 14 8B 55 F8 8B F8 8B 42 54 59 8B 08 8B 45 14 89 7D F0 89 0F 85 C0 79 06 DC 05 ?? ?? ?? ?? DD 59 20 8B 07 89 5D 10 DD 40 20 DC 05 ?? ?? ?? ?? DD 55 D4 39 5A 08 76 5B 8D 77 04 8B 7D 10 8B DA 8B 43 54 DD D8 8B 04 B8 8B 48 10 89 4D 10 E8 ?? ?? ?? ?? 8B 55 10 8B C8 8B 82 A0 00 00 00 03 8A B8 00 00 00 2B 82 A8 00 00 00 3B C1 76 13 8D 42 40 89 06 DD 40 20 83 C6 04 DC 45 D4 DD 55 D4 EB 03 DD 45 D4 47 3B 7B 08 72 B6 8B 75 F4 8B 7D F0 33 DB 43 8B 55 FC DB 45 FC 85 D2 79 06 DC 05 ?? ?? ?? ?? DD 5D CC DD 45 CC DD 55 CC DE F1 33 C9 DD 55 C4 85 F6 74 10 8B 04 8F 41 DD 40 20 D8 C9 DD 58 08 3B CE 72 F0 52 DD D8 56 57 E8 ?? ?? ?? ?? 32 D2 83 C4 0C 88 55 13 8B CB 3B F3 0F 86 96 00 00 00 EB 02 DD D8 8B 04 8F 89 45 10 8B 40 10 8B B8 A0 00 00 00 2B B8 A8 00 00 00 8B 45 10 89 7D 14 8B 78 04 8B 45 14 89 7D EC 3B F8 8B 7D F0 76 4A 89 45 14 DB 45 14 85 C0 79 06 DC 05 ?? ?? ?? ?? 8B 45 EC DD 5D DC DD 45 DC DB 45 EC 85 C0 79 06 DC 05 ?? ?? ?? ?? 8B 45 10 DD 5D DC DC 75 DC 8A D3 D9 E8 D8 E1 DC 48 20 DC 6D D4 DD 55 D4 DD 40 20 DE CA D9 C9 DD 58 20 EB 03 DD 45 D4 41 3B CE 72 81 DD 45 CC 88 55 13 84 D2 8B 55 FC 0F 85 37 FF FF FF DD D8 DD D8 33 C0 89 45 F4 85 F6 0F 84 9C 00 00 00 EB 02 DD D8 8B 04 87 89 45 E0 8B 48 10 8B 40 04 89 4D EC 89 45 14 E8 ?? ?? ?? ?? 39 45 14 76 55 8B 4D EC E8 ?? ?? ?? ?? 89 45 10 DB 45 10 85 C0 79 06 DC 05 ?? ?? ?? ?? 8B 45 14 DD 5D E8 DD 45 E8 DB 45 14 85 C0 79 06 DC 05 ?? ?? ?? ?? 8B 45 E0 DD 5D E8 DC 75 E8 8A D3 88 55 13 D9 E8 D8 E1 DC 48 20 DC 6D D4 DD 55 D4 DD 40 20 DE CA D9 C9 DD 58 20 EB 06 DD 45 D4 8A 55 13 8B 45 F4 40 89 45 F4 3B C6 0F 82 78 FF FF FF DD 45 CC 84 D2 8B 55 FC 0F 85 8E FE FF FF DD D8 DD D8 33 C0 89 45 EC 85 F6 0F 84 87 00 00 00 EB 02 DD D8 8B 04 87 89 45 F4 8B 40 10 8B 88 B8 00 00 00 89 4D 14 8B C8 E8 ?? ?? ?? ?? 03 45 14 8B 55 F4 3B 42 04 76 3C 8B 4A 10 E8 ?? ?? ?? ?? 03 45 14 89 45 10 DB 45 10 79 06 DC 05 ?? ?? ?? ?? DD 5D DC 8B 45 F4 DD 45 DC 8A CB DC 75 C4 88 4D 13 D9 C0 DC 60 20 DC 45 D4 DD 55 D4 D9 C9 DD 58 20 EB 06 DD 45 D4 8A 4D 13 8B 45 EC 40 89 45 EC 3B C6 72 8D DD 45 CC 8B 55 FC 84 C9 0F 85 FA FD FF FF DD D8 DD D8 8B 07 8B 4D 0C 39 48 04 76 49 3B F3 76 2C 8B 04 9F 8B 50 10 8B 8A A0 00 00 00 2B 48 04 2B 8A A8 00 00 00 74 0D 51 8B 4D F8 52 FF 75 08 E8 ?? ?? ?? ?? 43 3B DE 72 D7 8B 4D 0C 33 C0 50 8B 07 8B 40 04 2B C1 8B 4D F8 50 FF 75 08 E8 ?? ?? ?? ?? 89 45 E4 57 E8 ?? ?? ?? ?? 59 5F 5E 8B 45 E4 5B C9 C2 10 00 }
	condition:
		$1
}

rule file_178_180_0 {
	meta:
		name = "?RegisterScheduler@ResourceManager@details@Concurrency@@UAEPAUISchedulerProxy@3@PAUIScheduler@3@I@Z"
		size = 83
		refs = "0018 ??_C@_07CPCPJPKL@version?$AA@ 0022 ?CreateSchedulerProxy@ResourceManager@details@Concurrency@@AAEPAVSchedulerProxy@23@PAUIScheduler@3@@Z 002d ??_C@_0L@HKFDMHB@pScheduler?$AA@ 0039 ??0exception@std@@QAE@ABQBD@Z 003e __TI3?AVinvalid_argument@std@@ 0049 ??_7invalid_argument@std@@6B@ 004e __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 83 EC 0C 83 7D 08 00 74 1E 81 7D 0C 00 00 01 00 74 09 C7 45 08 ?? ?? ?? ?? EB 13 FF 75 08 E8 ?? ?? ?? ?? C9 C2 08 00 C7 45 08 ?? ?? ?? ?? 8D 45 08 50 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 C7 45 F4 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_178_181_0 {
	meta:
		name = "?Release@ResourceManager@details@Concurrency@@UAEIXZ"
		size = 151
		refs = "0003 __ehhandler$?Release@ResourceManager@details@Concurrency@@UAEIXZ 0008 __EH_prolog3 001c ?s_lock@ResourceManager@details@Concurrency@@0V_NonReentrantLock@23@A 0024 ?_Acquire@_NonReentrantLock@details@Concurrency@@QAEXXZ 002a ?s_pResourceManager@ResourceManager@details@Concurrency@@0PAV123@A 0034 ?DecodePointer@Security@details@Concurrency@@SAPAXPAX@Z 005a ?_Acquire@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ 0069 ?_Release@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ 0072 __imp__SetEvent@4 007d __imp__WaitForSingleObject@8 0084 ??1ResourceManager@details@Concurrency@@AAE@XZ 008a ??3@YAXPAX@Z 0092 __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 8D 47 04 83 CB FF F0 0F C1 18 4B 75 74 B9 ?? ?? ?? ?? 89 4D F0 E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 33 F6 89 75 FC E8 ?? ?? ?? ?? 59 8B CF 2B C8 F7 D9 1B C9 21 0D ?? ?? ?? ?? 83 4D FC FF 89 35 ?? ?? ?? ?? 39 77 4C 74 2B 8D 4F 2C E8 ?? ?? ?? ?? 8D 4F 2C C7 47 28 02 00 00 00 E8 ?? ?? ?? ?? FF 77 50 FF 15 ?? ?? ?? ?? 6A FF FF 77 4C FF 15 ?? ?? ?? ?? 8B CF E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 8B C3 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_178_184_0 {
	meta:
		name = "?ReleaseCoresOnExistingSchedulers@ResourceManager@details@Concurrency@@AAEIPAVSchedulerProxy@23@II@Z"
		size = 85
		refs = "0025 ?ReleaseSchedulerResources@ResourceManager@details@Concurrency@@AAE_NPAVSchedulerProxy@23@0I@Z 0046 ?ReserveCores@ResourceManager@details@Concurrency@@AAEIPAVSchedulerProxy@23@II@Z"
	strings:
		$1 = { 55 8B EC 51 53 56 57 33 FF 8B F1 47 33 DB 39 7E 08 76 39 8B 46 54 FF 75 10 8B 04 B8 8B CE FF 70 10 FF 75 08 E8 ?? ?? ?? ?? 84 C0 74 02 B3 01 47 3B 7E 08 72 DE 6A 00 84 DB 5B 74 10 53 FF 75 0C 8B CE FF 75 08 E8 ?? ?? ?? ?? 8B D8 5F 5E 8B C3 5B C9 C2 0C 00 }
	condition:
		$1
}

rule file_178_185_0 {
	meta:
		name = "?ReleaseSchedulerResources@ResourceManager@details@Concurrency@@AAE_NPAVSchedulerProxy@23@0I@Z"
		size = 246
		refs = "0029 ?MinVprocHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 55 10 53 56 8B 75 0C 57 89 4D FC 83 FA FE 75 0A 8B 86 A8 00 00 00 8B D0 EB 2C 83 FA FF 75 25 8B CE E8 ?? ?? ?? ?? 8B 96 A0 00 00 00 2B 56 6C 8B 8E A8 00 00 00 03 86 B8 00 00 00 2B D1 2B D0 03 D1 8B 4D FC 33 C0 8B DA 2B D8 85 D2 0F 84 90 00 00 00 8B 45 08 8B 7E 10 8B 40 14 89 45 F8 33 C0 89 7D F4 89 45 08 39 41 18 76 77 8B 4D F8 8B 0C 81 6B C9 34 03 CF 8B 41 1C 2B 41 24 74 55 33 C0 89 45 0C 39 41 04 76 4B 21 45 10 8B 79 30 03 7D 10 83 3F 04 75 2D 83 7F 28 00 77 27 8A 47 31 84 C0 75 04 85 DB 74 19 C7 07 05 00 00 00 FF 46 6C 8B 47 14 FF 08 8A 47 31 84 C0 75 01 4B 4A 74 2B 8B 45 0C 83 45 10 34 40 89 45 0C 3B 41 04 72 BB 8B 7D F4 8B 45 08 8B 4D FC 40 89 45 08 3B 41 18 72 89 32 C0 5F 5E 5B C9 C2 0C 00 B0 01 EB F5 }
	condition:
		$1
}

rule file_178_186_0 {
	meta:
		name = "?Remove@?$List@VSchedulerProxy@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QAEXPAVSchedulerProxy@23@@Z"
		size = 54
	strings:
		$1 = { 55 8B EC FF 09 56 8B 75 08 8B 56 18 8B 46 1C 89 42 1C 8B 56 1C 8B 46 18 89 42 18 8B 41 04 3B F0 5E 75 0F 3B 40 18 75 04 33 C0 EB 03 8B 40 1C 89 41 04 5D C2 04 00 }
	condition:
		$1
}

rule file_178_187_0 {
	meta:
		name = "?RemoveExecutionResource@ResourceManager@details@Concurrency@@QAEXPAVExecutionResource@23@@Z"
		size = 116
		refs = "0003 __ehhandler$?RemoveExecutionResource@ResourceManager@details@Concurrency@@QAEXPAVExecutionResource@23@@Z 0008 __EH_prolog3 001b ?_Acquire@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ 002a ?DecrementUseCounts@ExecutionResource@details@Concurrency@@QAEXXZ 0031 ?DesiredHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 0046 ?DistributeCoresToSurvivingScheduler@ResourceManager@details@Concurrency@@AAE_NXZ 0059 ?_Release@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ 0068 __imp__SetEvent@4 006d __EH_epilog3"
	strings:
		$1 = { 6A 08 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D9 83 65 F0 00 8D 73 2C 8B CE 89 75 EC E8 ?? ?? ?? ?? 8B 4D 08 83 65 FC 00 8B 79 14 E8 ?? ?? ?? ?? 8B CF E8 ?? ?? ?? ?? 39 87 A0 00 00 00 73 15 83 7B 08 01 75 0F 8B CB E8 ?? ?? ?? ?? 84 C0 75 04 C6 45 F0 01 83 4D FC FF 8B CE E8 ?? ?? ?? ?? 80 7D F0 00 74 09 FF 73 50 FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? C2 04 00 }
	condition:
		$1
}

rule file_178_190_0 {
	meta:
		name = "?RequestInitialVirtualProcessors@ResourceManager@details@Concurrency@@QAEPAUIExecutionResource@3@PAVSchedulerProxy@23@_N@Z"
		size = 267
		refs = "0003 __ehhandler$?RequestInitialVirtualProcessors@ResourceManager@details@Concurrency@@QAEPAUIExecutionResource@3@PAVSchedulerProxy@23@_N@Z 0008 __EH_prolog3 001f ?_Acquire@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ 0031 ?ReferenceCurrentThreadExecutionResource@SchedulerProxy@details@Concurrency@@QAEPAVExecutionResource@23@XZ 0059 ?AddTail@?$List@VSchedulerProxy@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QAEXPAVSchedulerProxy@23@@Z 0066 ?PerformAllocation@ResourceManager@details@Concurrency@@QAEPAVExecutionResource@23@PAVSchedulerProxy@23@_N1@Z 0085 ?SendResourceNotifications@ResourceManager@details@Concurrency@@QAEXPAVSchedulerProxy@23@@Z 0096 ?_Release@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ 00bf ??_U@YAPAXI@Z 00f1 __imp__SetEvent@4 00fc ?CreateDynamicRMWorker@ResourceManager@details@Concurrency@@AAEXXZ 0104 __EH_epilog3"
	strings:
		$1 = { 6A 0C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 8D 77 2C 33 DB 8B CE 89 5D F0 88 5D EC 89 75 E8 E8 ?? ?? ?? ?? 38 5D 0C 89 5D FC 8B 5D 08 74 12 8B CB E8 ?? ?? ?? ?? 89 45 F0 85 C0 75 04 C6 45 EC 01 8B 8B 84 00 00 00 3B 8B 80 00 00 00 75 03 FF 47 10 FF 47 08 53 8D 4F 60 E8 ?? ?? ?? ?? FF 75 EC 8B CF 6A 01 53 E8 ?? ?? ?? ?? 83 7D F0 00 75 03 89 45 F0 8B 83 84 00 00 00 3B 83 80 00 00 00 75 08 53 8B CF E8 ?? ?? ?? ?? 83 7F 08 02 74 0D 83 4D FC FF 8B CE E8 ?? ?? ?? ?? EB 64 33 C0 40 33 DB 89 47 28 39 5F 4C 75 38 89 47 4C 8B 47 0C 33 C9 6A 04 5B F7 E3 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 89 47 58 8B 47 0C 33 C9 F7 E3 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 59 59 89 47 5C B3 01 83 4D FC FF 8B CE E8 ?? ?? ?? ?? FF 77 50 FF 15 ?? ?? ?? ?? 84 DB 74 07 8B CF E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? C2 08 00 }
	condition:
		$1
}

rule file_178_193_0 {
	meta:
		name = "?ReserveAtHigherUseCounts@ResourceManager@details@Concurrency@@AAEIPAVSchedulerProxy@23@I@Z"
		size = 52
		refs = "001e ?ReserveCores@ResourceManager@details@Concurrency@@AAEIPAVSchedulerProxy@23@II@Z"
	strings:
		$1 = { 55 8B EC 51 56 57 33 FF 8B F7 89 4D FC 39 75 0C 76 1A 8B 45 0C 47 57 2B C6 50 FF 75 08 E8 ?? ?? ?? ?? 8B 4D FC 03 F0 3B 75 0C 72 E6 5F 8B C6 5E C9 C2 08 00 }
	condition:
		$1
}

rule file_178_194_0 {
	meta:
		name = "?ReserveCores@ResourceManager@details@Concurrency@@AAEIPAVSchedulerProxy@23@II@Z"
		size = 466
		refs = "001e ?GetCurrentNodeAndCore@ResourceManager@details@Concurrency@@QAEIPAI@Z"
	strings:
		$1 = { 55 8B EC 83 EC 20 83 4D E8 FF 53 56 8B 75 08 8B D9 80 7E 68 00 57 89 5D EC 74 0A 6A 00 E8 ?? ?? ?? ?? 89 45 E8 8B 46 10 8B 4E 14 33 F6 32 D2 89 45 F4 89 4D F8 88 55 FF 89 75 E4 39 73 18 76 56 8D 48 08 33 C0 89 45 F0 39 41 FC 76 37 8B 75 10 33 FF 8B 51 28 03 D7 83 3A 01 75 16 8B 42 14 3B 30 8B 45 F0 75 0C C7 02 02 00 00 00 FF 01 C6 45 FF 01 40 83 C7 34 89 45 F0 3B 41 FC 72 D4 8B 75 E4 8B 5D EC 46 83 C1 34 89 75 E4 3B 73 18 72 B3 8B 4D F8 8A 55 FF 33 C0 89 45 10 84 D2 0F 84 28 01 00 00 33 FF 89 7D E4 39 43 18 0F 86 1A 01 00 00 8B 45 EC 8B 14 B9 8B 5D 0C 6B D2 34 03 55 F4 8B F7 89 75 F0 2B 5D 10 74 6D 39 5A 08 76 03 89 5A 08 8D 77 01 3B 70 18 73 5A 8B 7D EC 8B 04 B1 6B C0 34 03 45 F4 39 58 08 76 03 89 58 08 8B 48 1C 03 48 18 8B 40 08 03 C1 8B 4A 1C 03 4A 18 89 45 E0 03 4A 08 3B C8 8B 4D F8 72 13 75 1D 8B 45 08 80 78 68 00 74 14 8B 45 E8 39 04 B1 75 0C 8B 14 B1 6B D2 34 03 55 F4 89 75 F0 46 3B 77 18 72 AC 8B 7D E4 8B 75 F0 83 7A 08 00 76 65 83 65 E0 00 83 7A 04 00 76 57 8B 7D E0 33 DB 8B 42 30 03 C3 83 38 02 75 3C 8B 4D 0C 39 4D 10 8B 4D F8 73 2B C7 00 03 00 00 00 8B 40 14 FF 00 8B 45 08 FF 42 18 80 78 68 00 74 0F 8B 45 E8 39 04 B1 8B 45 08 75 04 C6 40 68 00 FF 45 10 EB 06 C7 00 01 00 00 00 47 83 C3 34 3B 7A 04 72 B1 8B 7D E4 83 62 08 00 3B FE 74 0F 8B 55 F8 8B 0C B9 8B 04 B2 89 04 BA 89 0C B2 8B 45 EC 8B 4D F8 47 89 7D E4 3B 78 18 0F 82 EC FE FF FF 8B 45 10 5F 5E 5B C9 C2 0C 00 }
	condition:
		$1
}

rule file_178_195_0 {
	meta:
		name = "?ResetGlobalAllocationData@ResourceManager@details@Concurrency@@AAEXXZ"
		size = 87
	strings:
		$1 = { 55 8B EC 51 51 56 8B F1 33 C0 89 75 F8 8B D0 39 46 18 76 40 53 57 8B F8 8B 4E 48 03 CF 89 45 FC 89 41 08 89 41 1C 39 41 04 76 1E 8B D8 8B F0 8B 41 20 03 C3 83 C3 24 83 20 00 83 60 1C 00 46 3B 71 04 72 EB 8B 75 F8 33 C0 42 83 C7 28 3B 56 18 72 C6 5F 5B 5E C9 C3 }
	condition:
		$1
}

rule file_178_196_0 {
	meta:
		name = "?RetrieveSystemVersionInformation@ResourceManager@details@Concurrency@@CAXXZ"
		size = 168
		refs = "000a ___security_cookie 0026 __imp__GetVersionExW@4 003c ?s_version@ResourceManager@details@Concurrency@@0W4OSVersion@IResourceManager@3@A 0061 ?InitializeSystemFunctionPointers@ResourceManager@details@Concurrency@@CAXXZ 006e ?Initialize@WinRT@details@Concurrency@@SAXXZ 0085 @__security_check_cookie@4 0092 ??0unsupported_os@Concurrency@@QAE@XZ 0097 __TI2?AVunsupported_os@Concurrency@@ 00a3 __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 81 EC 24 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8D 85 E8 FE FF FF 50 C7 85 E8 FE FF FF 14 01 00 00 FF 15 ?? ?? ?? ?? 85 C0 74 5D 56 6A 06 5E 39 B5 EC FE FF FF 74 08 89 35 ?? ?? ?? ?? EB 1E 8B 85 F0 FE FF FF 83 E8 00 74 27 89 35 ?? ?? ?? ?? 48 75 0A C7 05 ?? ?? ?? ?? 04 00 00 00 E8 ?? ?? ?? ?? 39 35 ?? ?? ?? ?? 7C 11 E8 ?? ?? ?? ?? EB 0A C7 05 ?? ?? ?? ?? 03 00 00 00 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? C9 C3 8D 8D DC FE FF FF E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 DC FE FF FF 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_178_197_0 {
	meta:
		name = "?RoundUpScaledAllocations@ResourceManager@details@Concurrency@@CAXPAPAUAllocationData@23@II@Z"
		size = 447
		refs = "0028 __ftol2 0041 __real@41f0000000000000 005d __real@3e7ad7f29abcaf48"
	strings:
		$1 = { 55 8B EC 83 EC 10 D9 EE 53 8B 5D 08 D9 C0 56 33 D2 57 8B 7D 0C 8B F2 89 55 F0 89 75 FC 85 FF 74 3A 8B 34 B3 DD 46 08 E8 ?? ?? ?? ?? 89 46 04 8B 75 FC 8B 0C B3 8B 41 04 DB 41 04 85 C0 79 06 DC 05 ?? ?? ?? ?? DD 5D F4 46 DD 45 F4 89 75 FC DC 69 08 DD 59 08 3B F7 72 C8 33 D2 DD 05 ?? ?? ?? ?? 8B F2 89 75 F8 85 FF 74 5F 8D 46 01 89 75 0C 89 45 FC 8B D0 3B C7 73 45 C1 E6 02 8B 04 1E 8B 0C 93 DD 40 08 D8 C1 DC 59 08 DF E0 F6 C4 05 7A 0C 8B C2 8B F2 89 45 0C C1 E6 02 EB 03 8B 45 0C 42 3B D7 72 D7 8B 75 F8 3B F0 74 0F 8B 04 83 8B 0C B3 89 04 B3 8B 45 0C 89 0C 83 8B 45 FC 8B F0 89 75 F8 3B F7 72 A3 33 D2 8B F2 8D 4F FF 85 FF 0F 84 B0 00 00 00 D9 E8 EB 04 D9 C9 D9 CA D9 CA EB 12 8B 04 8B D9 C9 DC 50 08 DF E0 F6 C4 05 7B 77 49 D9 C9 D8 D1 DF E0 F6 C4 41 74 E5 3B F1 0F 87 87 00 00 00 8B 04 B3 D9 C9 DC 50 08 DF E0 F6 C4 05 7A 17 8B 04 B3 D9 C2 DC 60 08 DE C2 D9 CB DD 50 08 8B 04 B3 D9 CB FF 40 04 46 3B F7 72 AA DD D8 DD D8 DD D9 DD D8 85 FF 74 7E 8D 42 01 89 55 0C 89 45 F8 8B F0 3B C7 73 66 C1 E2 02 8B 04 B3 8B 0C 1A 8B 00 3B 01 73 36 8B C6 8B D6 89 45 0C C1 E2 02 EB 2D D9 C9 8B 04 8B D9 C9 49 DC 60 08 D9 CB DD 50 08 D9 CB D8 D1 DF E0 F6 C4 41 74 E5 E9 6E FF FF FF DD D8 DD D8 EB AA DD D9 EB A2 8B 45 0C 46 3B F7 72 B6 8B 55 F0 3B D0 74 0F 8B 04 83 8B 0C 93 89 04 93 8B 45 0C 89 0C 83 8B 45 F8 8B D0 89 55 F0 3B D7 72 82 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_178_198_0 {
	meta:
		name = "?SafeInterlockedIncrement@details@Concurrency@@YA_NPCJ@Z"
		size = 35
	strings:
		$1 = { 55 8B EC 56 8B 75 08 8B 16 85 D2 74 11 8D 4A 01 8B C2 F0 0F B1 0E 3B C2 75 ED B0 01 EB 02 32 C0 5E 5D C3 }
	condition:
		$1
}

rule file_178_199_0 {
	meta:
		name = "?SafeReference@ResourceManager@details@Concurrency@@AAE_NXZ"
		size = 31
	strings:
		$1 = { 56 8D 71 04 8B 16 85 D2 74 11 8D 4A 01 8B C2 F0 0F B1 0E 3B C2 75 ED B0 01 5E C3 32 C0 5E C3 }
	condition:
		$1
}

rule file_178_202_0 {
	meta:
		name = "?SendResourceNotifications@ResourceManager@details@Concurrency@@QAEXPAVSchedulerProxy@23@@Z"
		size = 463
		refs = "0175 ?SendCoreNotification@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerCore@23@_N@Z"
	strings:
		$1 = { 55 8B EC 83 EC 20 53 56 57 8B F9 33 DB 6A 30 8B CB 58 89 4D E8 89 45 F0 39 5F 18 0F 86 AF 00 00 00 8B F3 89 75 E4 8B D0 89 45 F4 8B 47 48 03 C6 89 5D FC 39 58 04 76 7F 8B D3 89 5D F8 89 55 EC 8B CB 8B 58 20 03 DA 8B 43 14 83 63 14 00 89 43 18 8B 57 64 85 D2 74 05 8B 52 18 EB 02 33 D2 85 D2 74 31 8B 75 F4 8B 42 10 8B 0C 06 03 4D F8 8B 41 1C 89 41 20 8B 41 18 89 41 1C 01 43 14 3B 57 64 74 05 8B 52 18 EB 02 33 D2 85 D2 75 D8 8B 75 E4 8B 4D FC 8B 47 48 8B 55 EC 83 45 F8 34 41 03 C6 83 C2 24 89 4D FC 89 55 EC 3B 48 04 72 93 8B 4D E8 8B 55 F4 33 DB 41 83 C6 28 83 C2 34 89 4D E8 89 75 E4 89 55 F4 3B 4F 18 0F 82 5B FF FF FF 8B CB 89 4D EC 39 5F 18 0F 86 EA 00 00 00 89 5D F8 8B 47 48 33 D2 03 C3 89 55 E4 39 50 04 0F 86 BD 00 00 00 21 55 F4 33 C9 89 4D E8 8B 40 20 8B 74 08 18 8B 44 08 14 89 75 E0 8B 77 64 89 45 FC 85 F6 74 05 8B 76 18 EB 02 33 F6 85 F6 74 73 8B 5D FC 8B 86 84 00 00 00 3B 86 80 00 00 00 75 49 8B 46 10 8B 4D F0 8B 04 01 03 45 F4 83 78 24 00 76 37 3B 75 08 75 0B 8B CE 3B 58 1C 76 23 6A 01 EB 21 8B 4D E0 3B 48 20 75 0B 3B 58 1C 76 09 6A 01 8B CE EB 0E 3B 58 1C 75 0F 3B 48 20 76 0A 8B CE 6A 00 50 E8 ?? ?? ?? ?? 3B 77 64 74 05 8B 76 18 EB 02 33 F6 85 F6 75 99 8B 5D F8 8B 55 E4 8B 4D E8 8B 47 48 83 45 F4 34 42 03 C3 83 C1 24 89 55 E4 89 4D E8 3B 50 04 0F 82 4E FF FF FF 8B 4D EC 83 45 F0 34 41 83 C3 28 89 4D EC 89 5D F8 3B 4F 18 0F 82 19 FF FF FF 5F 5E 5B C9 C2 04 00 }
	condition:
		$1
}

rule file_178_205_0 {
	meta:
		name = "?SetTaskExecutionResources@ResourceManager@details@Concurrency@@SAXGPAU_GROUP_AFFINITY@@@Z"
		size = 975
		refs = "0006 __ehhandler$?SetTaskExecutionResources@ResourceManager@details@Concurrency@@SAXGPAU_GROUP_AFFINITY@@@Z 000b __EH_prolog3 0010 ?s_lock@ResourceManager@details@Concurrency@@0V_NonReentrantLock@23@A 0018 ?_Acquire@_NonReentrantLock@details@Concurrency@@QAEXXZ 0022 ?s_pResourceManager@ResourceManager@details@Concurrency@@0PAV123@A 0030 ??0invalid_operation@Concurrency@@QAE@XZ 0035 __TI2?AVinvalid_operation@Concurrency@@ 0041 __CxxThrowException@8 0046 ?s_version@ResourceManager@details@Concurrency@@0W4OSVersion@IResourceManager@3@A 004f ?RetrieveSystemVersionInformation@ResourceManager@details@Concurrency@@CAXXZ 008b ??_C@_05IOMEMJEC@count?$AA@ 0090 ??0exception@std@@QAE@ABQBD@Z 009a ??_7invalid_argument@std@@6B@ 009f __TI3?AVinvalid_argument@std@@ 00bc ??_C@_0P@CGIPNALJ@pGroupAffinity?$AA@ 00f1 ??_U@YAPAXI@Z 025f ?GetTopologyInformation@ResourceManager@details@Concurrency@@CAXW4_LOGICAL_PROCESSOR_RELATIONSHIP@@@Z 0265 ?s_pSysInfo@ResourceManager@details@Concurrency@@0PAU_SYSTEM_LOGICAL_PROCESSOR_INFORMATION@@A 032f ?CleanupTopologyInformation@ResourceManager@details@Concurrency@@CAXXZ 0335 ?s_pUserAffinityRestriction@ResourceManager@details@Concurrency@@0PAUAffinityRestriction@123@A 0341 ??3@YAXPAX@Z 0350 ??2@YAPAXI@Z 0373 __EH_epilog3"
	strings:
		$1 = { 68 A8 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 89 4D A0 E8 ?? ?? ?? ?? 83 65 FC 00 83 3D ?? ?? ?? ?? 00 74 1C 8D 8D 58 FF FF FF E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 58 FF FF FF 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 75 0A E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 F8 04 7D 18 8D 8D 4C FF FF FF E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 4C FF FF FF EB CA 66 8B 45 08 66 85 C0 75 2D 8D 45 EC 50 8D 8D 64 FF FF FF C7 45 EC ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 85 64 FF FF FF ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 64 FF FF FF EB 94 8B 7D 0C 85 FF 75 27 8D 45 E4 50 8D 4D BC C7 45 E4 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 BC ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 BC E9 66 FF FF FF 0F B7 F0 33 C9 6A 0C 5A 8B C6 F7 E2 0F 90 C1 89 75 D4 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 8B D8 59 89 5D E8 85 DB 74 23 8D 56 FF 8B CB 85 D2 78 1F 33 C0 8B F9 AB AB AB 33 C0 21 01 66 89 41 04 83 C1 0C 4A 79 EB 8B 7D 0C EB 05 33 DB 89 5D E8 85 F6 7E 4E 8D 43 04 89 45 EC 8B C7 2B C3 8B 5D EC 89 75 F0 8B 75 0C 89 45 E4 0F B7 0C 18 8B 16 33 C0 FF 4D F0 8D BD 70 FF FF FF AB AB AB 8B 45 E4 66 89 0B 89 53 FC 66 89 8D 74 FF FF FF 89 95 70 FF FF FF 8D 76 0C 8D 5B 0C 75 CE 8B 5D E8 8B 75 D4 33 D2 85 F6 0F 84 D9 00 00 00 33 C9 89 4D E8 8B FB 89 5D F0 8D 42 01 89 55 E4 89 45 EC 89 45 C8 3B C6 0F 83 A5 00 00 00 89 4D D8 6A FC 59 8D 47 10 2B CB 89 45 DC 89 4D E0 0F B7 00 0F B7 C8 89 45 CC 8B 45 D8 0F B7 44 18 04 89 45 D0 0F B7 C0 66 3B C8 0F 84 C9 00 00 00 8B 45 CC 0F B7 C8 8B 45 D0 0F B7 C0 66 3B C8 8B 45 C8 73 16 8B 75 E0 03 75 DC 8B 7D F0 8B C8 89 75 D8 8B 75 D4 89 4D E4 EB 03 8B 4D E4 83 45 DC 0C 40 89 45 C8 3B C6 8B 45 DC 72 A4 3B D1 74 2E 8B F7 6B C9 0C 66 8B 44 19 04 8D 7D 88 A5 A5 A5 8B 7D F0 8B 75 D4 66 89 47 04 8B 04 19 89 07 66 8B 45 8C 66 89 44 19 04 8B 45 88 89 04 19 8B 4D E8 8B 45 EC 8B D0 83 C1 0C 83 C7 0C 89 4D E8 89 7D F0 3B D6 0F 82 31 FF FF FF 6A 04 E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 66 8B 75 08 59 66 3B 77 0A 76 4E 8D 45 D0 50 8D 4D A4 C7 45 D0 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 A4 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 A4 E9 A4 FD FF FF 8D 45 E0 50 8D 4D B0 C7 45 E0 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 B0 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 B0 E9 7D FD FF FF 33 C0 33 D2 33 C9 89 45 F0 89 45 EC 66 3B D6 0F 83 C8 00 00 00 0F B7 D0 6B D2 0C 0F B7 44 1A 04 66 3B C8 73 18 0F B7 44 1A 04 89 45 E0 0F B7 47 0A 66 3B C8 73 07 41 66 3B 4D E0 72 F4 66 3B 4F 0A 74 73 0F B7 C1 6B C0 2C 8B 44 38 48 21 04 1A 8B 45 F0 0B 04 1A 89 45 F0 8B 45 EC 40 89 45 EC 66 3B C6 72 B0 8B 45 F0 85 C0 74 71 E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 85 FF 74 10 FF 77 04 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 59 6A 08 E8 ?? ?? ?? ?? 59 85 C0 74 08 66 89 30 89 58 04 EB 02 33 C0 A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 E8 ?? ?? ?? ?? C3 8D 45 CC 50 8D 4D 94 C7 45 CC ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 94 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 94 E9 A0 FC FF FF 8D 45 D8 50 8D 8D 7C FF FF FF C7 45 D8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 85 7C FF FF FF ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 7C FF FF FF E9 70 FC FF FF }
	condition:
		$1
}

rule file_178_207_0 {
	meta:
		name = "__ehhandler$?SetTaskExecutionResources@ResourceManager@details@Concurrency@@SAXGPAU_GROUP_AFFINITY@@@Z"
		size = 30
		refs = "0010 @__security_check_cookie@4 0015 __ehfuncinfo$?SetTaskExecutionResources@ResourceManager@details@Concurrency@@SAXGPAU_GROUP_AFFINITY@@@Z 001a ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 48 FF FF FF 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_178_208_0 {
	meta:
		name = "?SetTaskExecutionResources@ResourceManager@details@Concurrency@@SAXK@Z"
		size = 314
		refs = "0003 __ehhandler$?SetTaskExecutionResources@ResourceManager@details@Concurrency@@SAXK@Z 0008 __EH_prolog3_GS 000d ?s_lock@ResourceManager@details@Concurrency@@0V_NonReentrantLock@23@A 0015 ?_Acquire@_NonReentrantLock@details@Concurrency@@QAEXXZ 001f ?s_pResourceManager@ResourceManager@details@Concurrency@@0PAV123@A 002a ??0invalid_operation@Concurrency@@QAE@XZ 002f __TI2?AVinvalid_operation@Concurrency@@ 0038 __CxxThrowException@8 003e ?s_version@ResourceManager@details@Concurrency@@0W4OSVersion@IResourceManager@3@A 0046 ?RetrieveSystemVersionInformation@ResourceManager@details@Concurrency@@CAXXZ 004c __imp__GetCurrentThread@0 0055 ??0HardwareAffinity@details@Concurrency@@QAE@PAX@Z 005c ??2@YAPAXI@Z 0080 ?CaptureProcessAffinity@ResourceManager@details@Concurrency@@CAXXZ 0085 ?s_systemAffinityMask@ResourceManager@details@Concurrency@@0KA 0099 ??_C@_0P@MBGDBGHG@dwAffinityMask?$AA@ 009e ??0exception@std@@QAE@ABQBD@Z 00a5 ??_7invalid_argument@std@@6B@ 00aa __TI3?AVinvalid_argument@std@@ 00b5 ?s_processAffinityMask@ResourceManager@details@Concurrency@@0KA 00c6 __imp__GetCurrentProcess@0 00cd __imp__SetProcessAffinityMask@8 00d3 ?s_pUserAffinityRestriction@ResourceManager@details@Concurrency@@0PAUAffinityRestriction@123@A 00df ??3@YAXPAX@Z 0106 ?s_pProcessAffinityRestriction@ResourceManager@details@Concurrency@@0PAUAffinityRestriction@123@A 0135 __EH_epilog3_GS"
	strings:
		$1 = { 6A 30 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 89 4D D0 E8 ?? ?? ?? ?? 83 65 FC 00 83 3D ?? ?? ?? ?? 00 74 16 8D 4D C4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 C4 50 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 05 E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 8D 4D E4 E8 ?? ?? ?? ?? 6A 0C E8 ?? ?? ?? ?? 8B F0 59 85 F6 74 16 0F B7 4D E8 33 C0 8B FE AB AB AB 8B 45 08 66 89 4E 04 89 06 EB 02 33 F6 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 21 06 8B 16 75 24 8D 45 E0 50 8D 4D D4 C7 45 E0 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 D4 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 D4 EB 83 8B 0D ?? ?? ?? ?? 8B C1 F7 D0 85 C2 74 10 0B CA 51 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 85 FF 74 10 FF 77 04 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 59 6A 08 E8 ?? ?? ?? ?? 59 85 C0 74 0B 33 C9 41 66 89 08 89 70 04 EB 02 33 C0 8B 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? 85 F6 74 10 FF 76 04 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 83 25 ?? ?? ?? ?? 00 C7 05 ?? ?? ?? ?? 00 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_178_210_0 {
	meta:
		name = "__ehhandler$?SetTaskExecutionResources@ResourceManager@details@Concurrency@@SAXK@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?SetTaskExecutionResources@ResourceManager@details@Concurrency@@SAXK@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C0 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_355_2 {
	meta:
		name = "__ehhandler$?do_get@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0_NAAVios_base@2@AAHAAV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0_NAAVios_base@2@AAHAAV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C0 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_389_2 {
	meta:
		name = "__ehhandler$?do_put@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPBUtm@@DD@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_put@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPBUtm@@DD@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C0 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_6_268_2 {
	meta:
		name = "__ehhandler$?overflow@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MAEHH@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?overflow@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MAEHH@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C0 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_277_2 {
	meta:
		name = "__ehhandler$?overflow@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MAEGG@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?overflow@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MAEGG@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C0 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_277_2 {
	meta:
		name = "__ehhandler$?overflow@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MAEGG@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?overflow@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MAEGG@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C0 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_178_211_0 {
	meta:
		name = "?SetupStaticAllocationData@ResourceManager@details@Concurrency@@AAEXPAVSchedulerProxy@23@_N@Z"
		size = 206
		refs = "000a ?InitializeRMBuffers@ResourceManager@details@Concurrency@@AAEXXZ 001a _memset 0028 ?PopulateCommonAllocationData@ResourceManager@details@Concurrency@@AAEXIPAVSchedulerProxy@23@PAUAllocationData@23@@Z 002f ?DesiredHWThreads@SchedulerProxy@details@Concurrency@@QBEIXZ 003f __real@41f0000000000000"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B D9 E8 ?? ?? ?? ?? 8B 7D 08 6A 30 8D 77 40 6A 00 56 E8 ?? ?? ?? ?? 83 C4 0C 8B CB 56 57 6A 00 E8 ?? ?? ?? ?? 8B CF E8 ?? ?? ?? ?? 89 45 FC DB 45 FC 85 C0 79 06 DC 05 ?? ?? ?? ?? 8A 45 0C DD 5E 20 88 46 28 8B 43 54 C7 45 0C 01 00 00 00 89 30 8B 7B 64 85 FF 74 05 8B 7F 18 EB 02 33 FF 85 FF 74 5D 8B 45 08 3B F8 74 46 6A 30 8D 77 40 6A 00 56 E8 ?? ?? ?? ?? 83 C4 0C 8B CB 56 57 FF 75 0C E8 ?? ?? ?? ?? 8B CF E8 ?? ?? ?? ?? 89 45 FC DB 45 FC 85 C0 79 06 DC 05 ?? ?? ?? ?? 8B 4D 0C DD 5E 20 8B 43 54 89 34 88 8B 45 08 41 89 4D 0C 3B 7B 64 74 05 8B 7F 18 EB 02 33 FF 85 FF 75 A6 5F 5E 5B C9 C2 08 00 }
	condition:
		$1
}

rule file_178_212_0 {
	meta:
		name = "?ShouldReceiveNotifications@SchedulerProxy@details@Concurrency@@QAE_NXZ"
		size = 18
	strings:
		$1 = { 8B 81 84 00 00 00 2B 81 80 00 00 00 F7 D8 1B C0 40 C3 }
	condition:
		$1
}

rule file_178_213_0 {
	meta:
		name = "?Shutdown@ResourceManager@details@Concurrency@@QAEXPAVSchedulerProxy@23@@Z"
		size = 185
		refs = "0012 ?_Acquire@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ 001e ?Remove@?$List@VSchedulerProxy@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QAEXPAVSchedulerProxy@23@@Z 0099 ?_Release@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ 00a6 __imp__SetEvent@4"
	strings:
		$1 = { 55 8B EC 51 51 53 56 57 8B F9 33 DB 8D 77 2C 8B CE E8 ?? ?? ?? ?? 8B 4D 08 51 8D 4F 60 E8 ?? ?? ?? ?? 8B 4D 08 8B C3 8B 51 10 89 45 FC 39 5F 18 76 45 83 C2 04 39 5A 18 76 2B 8B C3 89 45 F8 39 1A 76 1F 8B F3 8B 4A 2C 83 3C 0E 04 75 09 8B 44 0E 14 FF 08 8B 45 F8 40 83 C6 34 89 45 F8 3B 02 72 E3 8B 45 FC 40 83 C2 34 89 45 FC 3B 47 18 72 C4 8B 4D 08 8D 77 2C 8B 81 84 00 00 00 3B 81 80 00 00 00 75 03 FF 4F 10 FF 4F 08 83 7F 08 01 75 05 89 5F 28 B3 01 8B CE E8 ?? ?? ?? ?? 84 DB 74 09 FF 77 50 FF 15 ?? ?? ?? ?? 8B 4D 08 8B 01 FF 50 20 5F 5E 5B C9 C2 04 00 }
	condition:
		$1
}

rule file_178_214_0 {
	meta:
		name = "?SubscribeCurrentThread@ResourceManager@details@Concurrency@@QAEPAVExecutionResource@23@PAVSchedulerProxy@23@@Z"
		size = 81
		refs = "0003 __ehhandler$?SubscribeCurrentThread@ResourceManager@details@Concurrency@@QAEPAVExecutionResource@23@PAVSchedulerProxy@23@@Z 0008 __EH_prolog3 0017 ?_Acquire@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ 0023 ?ReferenceCurrentThreadExecutionResource@SchedulerProxy@details@Concurrency@@QAEPAVExecutionResource@23@XZ 0036 ?PerformAllocation@ResourceManager@details@Concurrency@@QAEPAVExecutionResource@23@PAVSchedulerProxy@23@_N1@Z 0043 ?_Release@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ 004a __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D9 8D 73 2C 8B CE 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 83 65 FC 00 E8 ?? ?? ?? ?? 8B F8 85 FF 75 0F 6A 01 50 FF 75 08 8B CB E8 ?? ?? ?? ?? 8B F8 83 4D FC FF 8B CE E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C2 04 00 }
	condition:
		$1
}

rule file_178_217_0 {
	meta:
		name = "?ToggleRMIdleState@ResourceManager@details@Concurrency@@AAEXPAUSchedulerNode@23@PAUSchedulerCore@23@PAUGlobalNode@23@PAUGlobalCore@23@PAUAllocationData@23@@Z"
		size = 109
	strings:
		$1 = { 55 8B EC 8B 55 0C 56 8A 42 30 8B F1 84 C0 74 35 8B 45 18 8B 4D 08 C6 42 30 00 FF 48 14 FF 49 28 80 7A 31 00 74 06 FF 48 18 FF 49 2C 8B 4D 14 83 39 06 75 0C 8B 45 10 83 21 00 FF 48 1C FF 4E 20 FF 49 1C EB 23 8B 4D 18 8B 75 08 C6 42 30 01 FF 41 14 FF 46 28 8A 42 31 84 C0 74 06 FF 41 18 FF 46 2C 8B 45 14 FF 40 1C 5E 5D C2 14 00 }
	condition:
		$1
}

rule file_178_222_0 {
	meta:
		name = "?Version@ResourceManager@details@Concurrency@@SA?AW4OSVersion@IResourceManager@3@XZ"
		size = 73
		refs = "0003 __ehhandler$?Version@ResourceManager@details@Concurrency@@SA?AW4OSVersion@IResourceManager@3@XZ 0008 __EH_prolog3 000d ?s_version@ResourceManager@details@Concurrency@@0W4OSVersion@IResourceManager@3@A 0016 ?s_lock@ResourceManager@details@Concurrency@@0V_NonReentrantLock@23@A 001e ?_Acquire@_NonReentrantLock@details@Concurrency@@QAEXXZ 0030 ?RetrieveSystemVersionInformation@ResourceManager@details@Concurrency@@CAXXZ 0044 __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 75 2E B9 ?? ?? ?? ?? 89 4D F0 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 65 FC 00 85 C0 75 0A E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_178_226_0 {
	meta:
		name = "?_Acquire@_NonReentrantLock@details@Concurrency@@QAEXXZ"
		size = 49
		refs = "0019 ?_Sleep0@details@Concurrency@@YAXXZ 0021 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 55 8B EC 83 EC 10 33 C0 56 8B F1 40 87 06 85 C0 74 1C 83 65 F8 00 C7 45 FC ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 33 C0 40 87 06 85 C0 75 EF 5E C9 C3 }
	condition:
		$1
}

rule file_179_0_0 {
	meta:
		name = "@x64toa@20"
		size = 108
		refs = "002f __aulldvrm"
	strings:
		$1 = { 55 8B EC 51 83 7D 10 00 8B 45 08 56 89 55 FC 8B 55 0C 57 8B F1 74 0B C6 06 2D 46 F7 D8 83 D2 00 F7 DA 8B 7D FC 89 75 10 53 6A 00 57 52 50 E8 ?? ?? ?? ?? 89 5D 0C 83 F9 09 76 05 80 C1 57 EB 03 80 C1 30 88 0E 46 85 D2 77 DF 72 04 85 C0 75 D9 8B 7D 10 C6 06 00 4E 5B 8A 07 8A 0E 88 06 4E 88 0F 47 3B FE 72 F2 5F 5E C9 C2 0C 00 }
	condition:
		$1
}

rule file_179_1_0 {
	meta:
		name = "__i64toa"
		size = 48
		refs = "0027 @x64toa@20"
	strings:
		$1 = { 55 8B EC 8B 55 14 33 C0 83 FA 0A 75 0F 39 45 0C 7F 0A 7C 05 39 45 08 73 03 33 C0 40 8B 4D 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 10 5D C3 }
	condition:
		$1
}

rule file_1171_1_0 {
	meta:
		name = "__i64tow"
		size = 48
		refs = "0027 @x64tow@20"
	strings:
		$1 = { 55 8B EC 8B 55 14 33 C0 83 FA 0A 75 0F 39 45 0C 7F 0A 7C 05 39 45 08 73 03 33 C0 40 8B 4D 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 10 5D C3 }
	condition:
		$1
}

rule file_179_2_0 {
	meta:
		name = "__itoa"
		size = 43
		refs = "0022 _xtoa@16"
	strings:
		$1 = { 55 8B EC 83 7D 10 0A 8B 45 08 56 75 0A 85 C0 79 06 6A 01 6A 0A EB 05 6A 00 FF 75 10 8B 75 0C 56 50 E8 ?? ?? ?? ?? 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_1171_2_0 {
	meta:
		name = "__itow"
		size = 43
		refs = "0022 _xtow@16"
	strings:
		$1 = { 55 8B EC 83 7D 10 0A 8B 45 08 56 75 0A 85 C0 79 06 6A 01 6A 0A EB 05 6A 00 FF 75 10 8B 75 0C 56 50 E8 ?? ?? ?? ?? 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_179_3_0 {
	meta:
		name = "__ltoa"
		size = 42
		refs = "0021 _xtoa@16"
	strings:
		$1 = { 55 8B EC 83 7D 10 0A 75 0B 83 7D 08 00 7D 05 33 C0 40 EB 02 33 C0 50 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_1171_3_0 {
	meta:
		name = "__ltow"
		size = 42
		refs = "0021 _xtow@16"
	strings:
		$1 = { 55 8B EC 83 7D 10 0A 75 0B 83 7D 08 00 7D 05 33 C0 40 EB 02 33 C0 50 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_179_4_0 {
	meta:
		name = "__ui64toa"
		size = 27
		refs = "0012 @x64toa@20"
	strings:
		$1 = { 55 8B EC 8B 55 14 8B 4D 10 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 10 5D C3 }
	condition:
		$1
}

rule file_1171_4_0 {
	meta:
		name = "__ui64tow"
		size = 27
		refs = "0012 @x64tow@20"
	strings:
		$1 = { 55 8B EC 8B 55 14 8B 4D 10 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 10 5D C3 }
	condition:
		$1
}

rule file_179_5_0 {
	meta:
		name = "__ultoa"
		size = 24
		refs = "000f _xtoa@16"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_1171_5_0 {
	meta:
		name = "__ultow"
		size = 24
		refs = "000f _xtow@16"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_179_6_0 {
	meta:
		name = "_xtoa@16"
		size = 73
	strings:
		$1 = { 55 8B EC 83 7D 14 00 8B 45 08 56 8B 75 0C 57 74 06 C6 06 2D 46 F7 D8 8B FE 33 D2 F7 75 10 83 FA 09 76 05 80 C2 57 EB 03 80 C2 30 88 16 46 85 C0 75 E7 88 06 4E 8A 07 8A 0E 88 06 4E 88 0F 47 3B FE 72 F2 5F 5E 5D C2 10 00 }
	condition:
		$1
}

rule file_181_4_0 {
	meta:
		name = "__get_daylight"
		size = 42
		refs = "000b __errno 0016 __invalid_parameter_noinfo 0020 __daylight"
	strings:
		$1 = { 55 8B EC 8B 4D 08 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 6A 16 58 5D C3 A1 ?? ?? ?? ?? 89 01 33 C0 5D C3 }
	condition:
		$1
}

rule file_181_5_0 {
	meta:
		name = "__get_dstbias"
		size = 42
		refs = "000b __errno 0016 __invalid_parameter_noinfo 0020 __dstbias"
	strings:
		$1 = { 55 8B EC 8B 4D 08 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 6A 16 58 5D C3 A1 ?? ?? ?? ?? 89 01 33 C0 5D C3 }
	condition:
		$1
}

rule file_206_0_0 {
	meta:
		name = "__get_fmode"
		size = 42
		refs = "000b __errno 0016 __invalid_parameter_noinfo 0020 __fmode"
	strings:
		$1 = { 55 8B EC 8B 4D 08 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 6A 16 58 5D C3 A1 ?? ?? ?? ?? 89 01 33 C0 5D C3 }
	condition:
		$1
}

rule file_181_6_0 {
	meta:
		name = "__get_timezone"
		size = 42
		refs = "000b __errno 0016 __invalid_parameter_noinfo 0020 __timezone"
	strings:
		$1 = { 55 8B EC 8B 4D 08 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 6A 16 58 5D C3 A1 ?? ?? ?? ?? 89 01 33 C0 5D C3 }
	condition:
		$1
}

rule file_181_7_0 {
	meta:
		name = "__get_tzname"
		size = 147
		refs = "002e __errno 0038 __invalid_parameter_noinfo 005a __tzname 005f _strlen 0087 _strcpy_s"
	strings:
		$1 = { 55 8B EC 56 8B 75 10 57 8B 7D 0C 85 FF 74 31 85 F6 74 31 85 FF 74 03 C6 07 00 83 7D 08 00 74 24 53 8B 5D 14 85 DB 74 2F 83 FB 01 74 2A E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 4E 85 F6 74 CF E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 38 FF 34 9D ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8D 48 01 8B 45 08 89 08 85 FF 75 04 33 C0 EB 1A 3B CE 76 05 6A 22 58 EB 11 FF 34 9D ?? ?? ?? ?? 56 57 E8 ?? ?? ?? ?? 83 C4 0C 5B 5F 5E 5D C3 }
	condition:
		$1
}

rule file_182_0_0 {
	meta:
		name = "__cgets"
		size = 82
		refs = "0011 ___doserrno 0018 __errno 0023 __invalid_parameter_noinfo 0039 __cgets_s"
	strings:
		$1 = { 55 8B EC 51 83 65 FC 00 57 8B 7D 08 85 FF 75 1B E8 ?? ?? ?? ?? 21 38 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 24 0F BE 07 56 8D 4D FC 51 50 8D 77 02 56 E8 ?? ?? ?? ?? 8A 4D FC 83 C4 0C F7 D8 1B C0 F7 D0 23 C6 88 4F 01 5E 5F C9 C3 }
	condition:
		$1
}

rule file_182_1_0 {
	meta:
		name = "__cgets_s"
		size = 271
		refs = "0003 __sehtable$__cgets_s 0008 __SEH_prolog4 0020 ___doserrno 0027 __errno 0031 __invalid_parameter_noinfo 0060 __lock 0078 __cgetws_s 009d _wctomb_s 00cf ___console_wchar_buffer 00d5 ___console_wchar_buffer_used 00f9 __SEH_epilog4 0109 __unlock"
	strings:
		$1 = { 6A 20 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D DC 33 C0 8B 7D 08 85 FF 0F 95 C0 85 C0 75 1B E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? E9 BC 00 00 00 33 C0 8B 4D 0C 3B C1 1B C0 F7 D8 74 D8 88 1F 33 C0 8B 75 10 85 F6 0F 95 C0 85 C0 74 C8 8D 41 FF 89 45 E4 6A 03 E8 ?? ?? ?? ?? 59 89 5D FC 89 1E 89 5D D4 8D 45 D4 50 6A 02 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 89 75 DC 85 F6 75 55 89 5D D8 66 39 45 E0 74 4C FF 75 E0 FF 75 E4 57 8D 45 D8 50 E8 ?? ?? ?? ?? 83 C4 10 8B F0 89 75 DC 85 F6 75 1C 8B 45 D8 03 F8 89 7D 08 8B 4D 10 01 01 8B 4D E4 2B C8 89 4D E4 89 4D D0 75 A3 EB 14 66 8B 45 E0 66 A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 C7 45 FC FE FF FF FF E8 1D 00 00 00 88 1F 85 F6 74 07 E8 ?? ?? ?? ?? 89 30 8B C6 E8 ?? ?? ?? ?? C3 33 DB 8B 7D 08 8B 75 DC 6A 03 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_183_0_0 {
	meta:
		name = "__close"
		size = 215
		refs = "0003 __sehtable$__close 0008 __SEH_prolog4 0015 ___doserrno 001d __errno 002d __ioinit 003f __nhandle 0055 ___pioinfo 0065 ___lock_fhandle 007e __close_nolock 00b0 __unlock_fhandle 00ca __invalid_parameter_noinfo 00d2 __SEH_epilog4"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 08 83 FE FE 75 18 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E9 A2 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 88 95 00 00 00 85 F6 78 79 3B 35 ?? ?? ?? ?? 73 71 8B DE C1 FB 05 8B FE 83 E7 1F C1 E7 06 8B 04 9D ?? ?? ?? ?? 0F BE 44 38 04 83 E0 01 74 53 56 E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 04 9D ?? ?? ?? ?? F6 44 38 04 01 74 0B 56 E8 ?? ?? ?? ?? 59 8B F8 EB 0E E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 CF FF 89 7D E4 C7 45 FC FE FF FF FF E8 0A 00 00 00 8B C7 EB 29 8B 75 08 8B 7D E4 56 E8 ?? ?? ?? ?? 59 C3 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_183_1_0 {
	meta:
		name = "__close_nolock"
		size = 168
		refs = "0004 __ioinit 0018 __get_osfhandle 0023 ___pioinfo 0060 __imp__CloseHandle@4 006a __imp__GetLastError@0 0076 __free_osfhnd 0098 __dosmaperr"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 85 C0 79 05 83 C8 FF 5D C3 56 57 8B 7D 08 57 E8 ?? ?? ?? ?? 59 83 F8 FF 74 50 A1 ?? ?? ?? ?? 83 FF 01 75 09 F6 80 84 00 00 00 01 75 0B 83 FF 02 75 1C F6 40 44 01 74 16 6A 02 E8 ?? ?? ?? ?? 6A 01 8B F0 E8 ?? ?? ?? ?? 59 59 3B C6 74 1C 57 E8 ?? ?? ?? ?? 59 50 FF 15 ?? ?? ?? ?? 85 C0 75 0A FF 15 ?? ?? ?? ?? 8B F0 EB 02 33 F6 57 E8 ?? ?? ?? ?? 59 8B CF C1 F9 05 83 E7 1F 8B 0C 8D ?? ?? ?? ?? C1 E7 06 C6 44 39 04 00 85 F6 74 0C 56 E8 ?? ?? ?? ?? 59 83 C8 FF EB 02 33 C0 5F 5E 5D C3 }
	condition:
		$1
}

rule file_184_3_0 {
	meta:
		name = "___STRINGTOLD"
		size = 55
		refs = "000c ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0021 ___STRINGTOLD_L"
	strings:
		$1 = { 55 8B EC 83 EC 10 6A 00 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_458_3_0 {
	meta:
		name = "___WSTRINGTOLD"
		size = 55
		refs = "000c ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0021 ___WSTRINGTOLD_L"
	strings:
		$1 = { 55 8B EC 83 EC 10 6A 00 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_184_4_0 {
	meta:
		name = "___strgtold12"
		size = 64
		refs = "000c ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002a ___strgtold12_l"
	strings:
		$1 = { 55 8B EC 83 EC 10 6A 00 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 FF 75 20 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 20 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_458_4_0 {
	meta:
		name = "___wstrgtold12"
		size = 64
		refs = "000c ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002a ___wstrgtold12_l"
	strings:
		$1 = { 55 8B EC 83 EC 10 6A 00 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 FF 75 20 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 20 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_184_5_0 {
	meta:
		name = "__atof_l"
		size = 156
		refs = "0007 ___security_cookie 001b ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0024 __errno 002f __invalid_parameter_noinfo 004b __isctype_l 0078 __fltin2 0096 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 2C A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 FF 75 0C 8B 75 08 8D 4D D4 E8 ?? ?? ?? ?? 85 F6 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? D9 EE EB 4B 8B 55 D4 83 7A 74 01 7E 17 8D 45 D4 50 0F B6 06 6A 08 50 E8 ?? ?? ?? ?? 8B 55 D4 83 C4 0C EB 10 0F B6 0E 8B 82 90 00 00 00 0F B7 04 48 83 E0 08 85 C0 74 03 46 EB CC 8D 45 D4 50 8D 45 E4 56 50 E8 ?? ?? ?? ?? DD 40 10 83 C4 0C 80 7D E0 00 5E 74 07 8B 45 DC 83 60 70 FD 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_185_1_0 {
	meta:
		name = "??0QuickBitSet@details@Concurrency@@QAE@ABV012@@Z"
		size = 28
		refs = "0011 ?CopyFrom@QuickBitSet@details@Concurrency@@IAEXABV123@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 83 26 00 83 66 04 00 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_761_1_0 {
	meta:
		name = "??$?0V__ExceptionPtr@@@?$shared_ptr@V__ExceptionPtr@@@std@@QAE@PAV__ExceptionPtr@@@Z"
		size = 28
		refs = "0011 ??$_Resetp@V__ExceptionPtr@@@?$shared_ptr@V__ExceptionPtr@@@std@@AAEXPAV__ExceptionPtr@@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 83 26 00 83 66 04 00 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_80_61_1 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@DHPBDABDU_Iterator_base12@2@@std@@QAE@ABU01@@Z"
		size = 28
		refs = "0011 ??4_Iterator_base12@std@@QAEAAU01@ABU01@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 83 26 00 83 66 04 00 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_62_181_1 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@GHPBGABGU_Iterator_base12@2@@std@@QAE@ABU01@@Z"
		size = 28
		refs = "0011 ??4_Iterator_base12@std@@QAEAAU01@ABU01@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 83 26 00 83 66 04 00 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_100_310_1 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@2@HPBV32@ABV32@U_Iterator_base12@2@@std@@QAE@ABU01@@Z"
		size = 28
		refs = "0011 ??4_Iterator_base12@std@@QAEAAU01@ABU01@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 83 26 00 83 66 04 00 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_99_312_1 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@2@HPBV32@ABV32@U_Iterator_base12@2@@std@@QAE@ABU01@@Z"
		size = 28
		refs = "0011 ??4_Iterator_base12@std@@QAEAAU01@ABU01@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 83 26 00 83 66 04 00 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_62_183_1 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@_WHPB_WAB_WU_Iterator_base12@2@@std@@QAE@ABU01@@Z"
		size = 28
		refs = "0011 ??4_Iterator_base12@std@@QAEAAU01@ABU01@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 83 26 00 83 66 04 00 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_111_267_2 {
	meta:
		name = "??0?$_Ptr_base@U?$_Task_impl@E@details@Concurrency@@@std@@QAE@$$QAV01@@Z"
		size = 28
		refs = "0011 ?_Assign_rv@?$_Ptr_base@U?$_Task_impl@E@details@Concurrency@@@std@@QAEX$$QAV12@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 83 26 00 83 66 04 00 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_111_269_2 {
	meta:
		name = "??0?$_Ptr_base@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QAE@$$QAV01@@Z"
		size = 28
		refs = "0011 ?_Assign_rv@?$_Ptr_base@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QAEX$$QAV12@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 83 26 00 83 66 04 00 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_12_270_2 {
	meta:
		name = "??0?$_Ptr_base@U_ExceptionHolder@details@Concurrency@@@std@@QAE@$$QAV01@@Z"
		size = 28
		refs = "0011 ?_Assign_rv@?$_Ptr_base@U_ExceptionHolder@details@Concurrency@@@std@@QAEX$$QAV12@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 83 26 00 83 66 04 00 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_761_25_0 {
	meta:
		name = "??0?$_Ptr_base@V__ExceptionPtr@@@std@@QAE@$$QAV01@@Z"
		size = 28
		refs = "0011 ?_Assign_rv@?$_Ptr_base@V__ExceptionPtr@@@std@@QAEX$$QAV12@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 83 26 00 83 66 04 00 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_100_372_1 {
	meta:
		name = "??0?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@QAE@$$QAV01@@Z"
		size = 28
		refs = "0011 ?_Assign_rv@?$_Ptr_base@U?$_Task_impl@E@details@Concurrency@@@std@@QAEX$$QAV12@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 83 26 00 83 66 04 00 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_111_318_2 {
	meta:
		name = "??0?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QAE@$$QAV01@@Z"
		size = 28
		refs = "0011 ?_Assign_rv@?$_Ptr_base@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QAEX$$QAV12@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 83 26 00 83 66 04 00 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_111_319_2 {
	meta:
		name = "??0?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@QAE@$$QAV01@@Z"
		size = 28
		refs = "0011 ?_Assign_rv@?$_Ptr_base@U_ExceptionHolder@details@Concurrency@@@std@@QAEX$$QAV12@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 83 26 00 83 66 04 00 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_761_29_0 {
	meta:
		name = "??0?$shared_ptr@V__ExceptionPtr@@@std@@QAE@$$QAV01@@Z"
		size = 28
		refs = "0011 ?_Assign_rv@?$_Ptr_base@V__ExceptionPtr@@@std@@QAEX$$QAV12@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 83 26 00 83 66 04 00 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_80_110_1 {
	meta:
		name = "??0_Iterator_base12@std@@QAE@ABU01@@Z"
		size = 28
		refs = "0011 ??4_Iterator_base12@std@@QAEAAU01@ABU01@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 83 26 00 83 66 04 00 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_185_2_0 {
	meta:
		name = "??0Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@23@ABVQuickBitSet@23@II@Z"
		size = 108
		refs = "0003 __ehhandler$??0Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@23@ABVQuickBitSet@23@II@Z 0008 __EH_prolog3 0024 ?CopyFrom@QuickBitSet@details@Concurrency@@IAEXABV123@@Z 004a ??_U@YAPAXI@Z 005b _memset 0065 __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 89 7D F0 8B 45 08 FF 75 0C 8D 4F 04 89 07 33 DB 89 19 89 59 04 E8 ?? ?? ?? ?? 8B 45 14 89 47 10 8B 45 10 33 C9 6A 04 5A F7 E2 0F 90 C1 89 5D FC 89 5F 14 89 5F 18 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 8B 4D 10 C1 E1 02 51 53 50 89 47 0C E8 ?? ?? ?? ?? 83 C4 10 8B C7 E8 ?? ?? ?? ?? C2 10 00 }
	condition:
		$1
}

rule file_185_5_0 {
	meta:
		name = "??0Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@AAE@PAUSegment@123@I@Z"
		size = 20
		altNames = "??0?$_Smanip@H@std@@QAE@P6AXAAVios_base@1@H@ZH@Z ??0_Fac_node@std@@QAE@PAU01@PAV_Facet_base@1@@Z ??0error_code@std@@QAE@HABVerror_category@1@@Z ??0error_condition@std@@QAE@HABVerror_category@1@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 89 01 8B 45 0C 89 41 04 8B C1 5D C2 08 00 }
	condition:
		$1
}

rule file_185_6_0 {
	meta:
		name = "??0WorkItem@details@Concurrency@@QAE@PAVInternalContextBase@12@@Z"
		size = 38
		refs = "0014 ?GetScheduleGroupSegment@ContextBase@details@Concurrency@@QBEPAVScheduleGroupSegmentBase@23@XZ"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 57 8B F9 8D 4E 04 C7 07 01 00 00 00 E8 ?? ?? ?? ?? 89 47 04 89 77 08 8B C7 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_185_7_0 {
	meta:
		name = "??0WorkItem@details@Concurrency@@QAE@PAVRealizedChore@12@PAVScheduleGroupSegmentBase@12@@Z"
		size = 27
	strings:
		$1 = { 55 8B EC 8B 45 0C 89 41 04 8B 45 08 89 41 08 C7 01 02 00 00 00 8B C1 5D C2 08 00 }
	condition:
		$1
}

rule file_185_9_0 {
	meta:
		name = "??0WorkItem@details@Concurrency@@QAE@PAVWorkQueue@12@PAVScheduleGroupSegmentBase@12@@Z"
		size = 27
	strings:
		$1 = { 55 8B EC 8B 45 0C 89 41 04 8B 45 08 89 41 08 C7 01 10 00 00 00 8B C1 5D C2 08 00 }
	condition:
		$1
}

rule file_185_10_0 {
	meta:
		name = "??0WorkItem@details@Concurrency@@QAE@PAV_UnrealizedChore@12@PAVScheduleGroupSegmentBase@12@@Z"
		size = 27
	strings:
		$1 = { 55 8B EC 8B 45 0C 89 41 04 8B 45 08 89 41 08 C7 01 04 00 00 00 8B C1 5D C2 08 00 }
	condition:
		$1
}

rule file_185_19_0 {
	meta:
		name = "??A?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@QBEPAVScheduleGroupSegmentBase@12@H@Z"
		size = 70
		altNames = "??A?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QBEPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@12@H@Z ??A?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QBEPAVExternalStatistics@12@H@Z ??A?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QBEPAVVirtualProcessor@12@H@Z ??A?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QBEPAVWorkQueue@12@H@Z"
	strings:
		$1 = { 55 8B EC 8B 55 08 56 8B F1 8B 4E 2C D3 FA 3B 56 3C 7C 04 33 C0 EB 2A 8B 4E 38 8B 46 34 3B D1 7C 11 2B D1 8B 44 88 FC 78 0C 42 8B 40 04 4A 75 FA EB 03 8B 04 90 8B 4E 28 8B 00 49 23 4D 08 8B 04 88 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_185_26_0 {
	meta:
		name = "?AcquireQuickCacheSlot@SchedulerBase@details@Concurrency@@QAEPAVScheduleGroupSegmentBase@23@I@Z"
		size = 30
		refs = "0014 ?ActualGetQuickCacheSlot@SchedulerBase@details@Concurrency@@AAEPAVScheduleGroupSegmentBase@23@I@Z"
	strings:
		$1 = { 55 8B EC 8B 55 08 8B 41 5C C1 E2 07 83 3C 02 01 76 06 5D E9 ?? ?? ?? ?? 33 C0 5D C2 04 00 }
	condition:
		$1
}

rule file_185_27_0 {
	meta:
		name = "?ActualGetQuickCacheSlot@SchedulerBase@details@Concurrency@@AAEPAVScheduleGroupSegmentBase@23@I@Z"
		size = 51
	strings:
		$1 = { 55 8B EC 8B 41 5C 56 8B 75 08 57 C1 E6 07 33 FF 8B 14 06 47 3B D7 76 13 8B 49 5C 03 CE 8B C2 F0 0F B1 39 3B D0 75 04 8B C2 EB 02 33 C0 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_185_28_0 {
	meta:
		name = "?AllSlotsClaimed@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE_NI@Z"
		size = 18
	strings:
		$1 = { 55 8B EC 8B 41 14 03 45 08 F7 D8 1B C0 40 5D C2 04 00 }
	condition:
		$1
}

rule file_185_29_0 {
	meta:
		name = "?BiasStage@WorkSearchContext@details@Concurrency@@AAE?AW4BiasStageType@123@XZ"
		size = 19
	strings:
		$1 = { 83 79 0C 65 73 03 33 C0 C3 83 79 0C 7F 1B C0 83 C0 02 C3 }
	condition:
		$1
}

rule file_185_30_0 {
	meta:
		name = "?Bind@WorkItem@details@Concurrency@@QAEPAVInternalContextBase@23@XZ"
		size = 73
		refs = "0009 ?ResolveToken@WorkItem@details@Concurrency@@QAE_NXZ 002c ?GetInternalContext@ScheduleGroupSegmentBase@details@Concurrency@@IAEPAVInternalContextBase@23@PAU_Chore@23@_N@Z"
	strings:
		$1 = { 56 8B F1 F6 06 18 74 0D E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 5E C3 8B 06 48 48 74 08 48 48 75 25 6A 01 EB 02 6A 00 FF 76 08 8B 4E 04 E8 ?? ?? ?? ?? 89 46 08 85 C0 74 0D 80 88 B3 00 00 00 01 C7 06 01 00 00 00 8B 46 08 5E C3 }
	condition:
		$1
}

rule file_185_31_0 {
	meta:
		name = "?BindTo@WorkItem@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z"
		size = 54
		refs = "0023 ?PrepareForUse@InternalContextBase@details@Concurrency@@QAEXPAVScheduleGroupSegmentBase@23@PAU_Chore@23@_N@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 57 8B 06 8B 7D 08 48 48 74 08 48 48 75 13 6A 01 EB 02 6A 00 FF 76 08 8B CF FF 76 04 E8 ?? ?? ?? ?? 89 7E 08 5F C7 06 01 00 00 00 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_185_32_0 {
	meta:
		name = "?CheckPriorityList@WorkSearchContext@details@Concurrency@@AAE_NK@Z"
		size = 30
	strings:
		$1 = { 55 8B EC 8B 55 08 8B C2 2B 41 14 3D E8 03 00 00 0F 97 C0 84 C0 74 03 89 51 14 5D C2 04 00 }
	condition:
		$1
}

rule file_185_35_0 {
	meta:
		name = "?CopyFrom@QuickBitSet@details@Concurrency@@IAEXABV123@@Z"
		size = 61
		refs = "0013 ?Reallocate@QuickBitSet@details@Concurrency@@IAEXI@Z"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 56 8B 03 8B F1 57 39 06 74 06 50 E8 ?? ?? ?? ?? 8B 16 83 C2 1F C1 EA 05 33 FF 85 D2 74 11 8B 43 04 8B 4E 04 8B 04 B8 89 04 B9 47 3B FA 72 EF 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_185_37_0 {
	meta:
		name = "?DeferToAffineSearchers@Slot@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QBE_NXZ"
		size = 86
		refs = "0006 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0021 ?Intersects@QuickBitSet@details@Concurrency@@QBE_NABV123@@Z"
		altNames = "?DeferToAffineSearchers@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QBE_NXZ"
	strings:
		$1 = { 53 56 57 8B F9 E8 ?? ?? ?? ?? 85 C0 74 05 8D 70 FC EB 02 33 F6 8B 0F 8D 41 04 8B 09 50 83 C1 3C E8 ?? ?? ?? ?? 84 C0 74 25 8B 86 A0 00 00 00 33 DB 8B 88 84 00 00 00 8B 07 43 8B 50 08 8B F1 83 E1 1F 8B C3 D3 E0 C1 EE 05 85 04 B2 74 02 33 DB 5F 5E 8A C3 5B C3 }
	condition:
		$1
}

rule file_185_38_0 {
	meta:
		name = "?DemandInitialize@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@AAEXXZ"
		size = 118
		refs = "0003 __ehhandler$?DemandInitialize@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@AAEXXZ 0008 __EH_prolog3 0027 ??2@YAPAXI@Z 0043 ??0Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@23@ABVQuickBitSet@23@II@Z 005f ?_Sleep0@details@Concurrency@@YAXXZ 0067 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ 0071 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 8D 7E 10 33 DB 39 1F 75 3D 33 D2 42 33 C0 F0 0F B1 17 85 C0 75 30 6A 2C E8 ?? ?? ?? ?? 59 89 45 F0 89 5D FC 85 C0 74 13 53 FF 76 0C 8D 4E 04 51 FF 36 8B C8 E8 ?? ?? ?? ?? EB 02 8B C3 83 4D FC FF 89 07 89 46 14 39 5E 14 75 17 89 5D E8 C7 45 EC ?? ?? ?? ?? 8D 4D E0 E8 ?? ?? ?? ?? 39 5E 14 74 F3 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_185_41_0 {
	meta:
		name = "?Dequeue@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE_NPAPAV_UnrealizedChore@23@@Z"
		size = 194
		refs = "0033 ?LocateMailboxSegment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@AAEPAUSegment@123@I_N@Z 0084 ?SetDeletionReferences@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAEXI@Z 00a6 ?Claim@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE_NPAPAV_UnrealizedChore@34@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 18 53 8B D9 56 57 89 5D F0 8D 53 18 8B 32 3B 73 1C 0F 84 9D 00 00 00 8D 4E 01 8B C6 F0 0F B1 0A 3B C6 74 04 8B F0 EB E6 6A 00 56 8B CB E8 ?? ?? ?? ?? 8B C8 8D 43 14 89 4D FC 89 45 F4 3B 08 74 50 8B 10 8B FA EB 03 8B 7F 18 8B 47 14 03 43 0C 74 F5 8B 47 10 3B 42 10 76 34 8B 5D F4 8B CF 8B C2 F0 0F B1 0B 8B 5D F0 89 45 F8 3B C2 74 06 8B F8 8B D0 EB D5 3B C7 74 15 FF 73 0C 8B C8 E8 ?? ?? ?? ?? 8B 45 F8 8B 40 18 89 45 F8 EB E7 8B 4D FC 2B 71 10 FF 75 08 89 4D E8 8D 4D E8 89 75 EC E8 ?? ?? ?? ?? 8D 53 18 84 C0 0F 84 5C FF FF FF B0 01 EB 02 32 C0 5F 5E 5B C9 C2 04 00 }
	condition:
		$1
}

rule file_185_49_0 {
	meta:
		name = "?FindScheduleGroupSegment@SchedulingRing@details@Concurrency@@AAEPAVScheduleGroupSegmentBase@23@HHPAHPAV?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@23@@Z"
		size = 43
		refs = "0014 ??A?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@QBEPAVScheduleGroupSegmentBase@12@H@Z"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 33 C0 EB 0E 85 C0 75 0F 8B 4D 14 56 E8 ?? ?? ?? ?? 46 3B 75 0C 7C ED 8B 4D 10 8D 56 FF 89 11 5E 5D C2 10 00 }
	condition:
		$1
}

rule file_185_50_0 {
	meta:
		name = "?FindVirtualProcessor@SchedulingNode@details@Concurrency@@QAEPAVVirtualProcessor@23@HHPAH@Z"
		size = 47
		refs = "0017 ??A?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QBEPAVVirtualProcessor@12@H@Z"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 57 8B F9 33 C0 EB 0E 85 C0 75 0F 56 8D 4F 38 E8 ?? ?? ?? ?? 46 3B 75 0C 7C ED 8B 4D 10 8D 56 FF 5F 89 11 5E 5D C2 0C 00 }
	condition:
		$1
}

rule file_185_55_0 {
	meta:
		name = "?GetFirstScheduleGroupSegment@ScheduleGroupBase@details@Concurrency@@QAEPAVScheduleGroupSegmentBase@23@_N@Z"
		size = 21
	strings:
		$1 = { 55 8B EC 80 7D 08 00 74 05 8B 41 0C EB 03 8B 41 10 5D C2 04 00 }
	condition:
		$1
}

rule file_185_56_0 {
	meta:
		name = "?GetFirstSchedulingNode@SchedulerBase@details@Concurrency@@QAEPAVSchedulingNode@23@PAH@Z"
		size = 21
		refs = "000d ?GetNextSchedulingNode@SchedulerBase@details@Concurrency@@QAEPAVSchedulingNode@23@PAHH@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 6A FF 83 20 00 50 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_185_57_0 {
	meta:
		name = "?GetFirstVirtualProcessor@SchedulingNode@details@Concurrency@@QAEPAVVirtualProcessor@23@PAH@Z"
		size = 21
		refs = "000d ?FindVirtualProcessor@SchedulingNode@details@Concurrency@@QAEPAVVirtualProcessor@23@HHPAH@Z"
	strings:
		$1 = { 55 8B EC FF 75 08 8B 41 78 50 6A 00 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_185_59_0 {
	meta:
		name = "?GetLocalRunnable@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVVirtualProcessor@23@_N@Z"
		size = 151
		refs = "0021 ?Pop@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@XZ 0032 ??0WorkItem@details@Concurrency@@QAE@PAVInternalContextBase@12@@Z 0052 ?StealLocalRunnableContext@VirtualProcessor@details@Concurrency@@AAEPAVInternalContextBase@23@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 18 80 7D 10 00 53 56 57 8B D9 74 31 8B 4D 0C 83 C1 0C 8B 41 04 2B 01 85 C0 7E 07 E8 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 61 50 8D 4D F4 E8 ?? ?? ?? ?? 8B 7D 08 8B F0 A5 A5 A5 B0 01 EB 4E 83 7B 0C 65 72 10 83 7B 0C 7F 73 3C 8B 4D 0C E8 ?? ?? ?? ?? EB 18 8B 4D 0C 83 C1 0C 8B 41 04 2B 01 85 C0 7E 07 E8 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 16 50 8D 4D E8 E8 ?? ?? ?? ?? 8B 7D 08 8B F0 A5 A5 A5 FF 43 0C EB B4 83 63 0C 00 32 C0 5F 5E 5B C9 C2 0C 00 }
	condition:
		$1
}

rule file_185_63_0 {
	meta:
		name = "?GetNextAffineScheduleGroupSegment@SchedulingRing@details@Concurrency@@QAEPAVScheduleGroupSegmentBase@23@PAHH@Z"
		size = 22
		refs = "000e ?GetNextScheduleGroupSegment@SchedulingRing@details@Concurrency@@AAEPAVScheduleGroupSegmentBase@23@PAHHPAV?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 55 8B EC 8D 41 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 5D C2 08 00 }
	condition:
		$1
}

rule file_185_64_0 {
	meta:
		name = "?GetNextNonAffineScheduleGroupSegment@SchedulingRing@details@Concurrency@@QAEPAVScheduleGroupSegmentBase@23@PAHH@Z"
		size = 22
		refs = "000e ?GetNextScheduleGroupSegment@SchedulingRing@details@Concurrency@@AAEPAVScheduleGroupSegmentBase@23@PAHHPAV?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 55 8B EC 8D 41 60 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 5D C2 08 00 }
	condition:
		$1
}

rule file_185_65_0 {
	meta:
		name = "?GetNextScheduleGroupSegment@ScheduleGroupBase@details@Concurrency@@QAEPAVScheduleGroupSegmentBase@23@PAV423@@Z"
		size = 16
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 80 04 01 00 00 5D C2 04 00 }
	condition:
		$1
}

rule file_185_66_0 {
	meta:
		name = "?GetNextScheduleGroupSegment@SchedulingRing@details@Concurrency@@AAEPAVScheduleGroupSegmentBase@23@PAHHPAV?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@23@@Z"
		size = 60
		refs = "001e ?FindScheduleGroupSegment@SchedulingRing@details@Concurrency@@AAEPAVScheduleGroupSegmentBase@23@HHPAHPAV?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 55 8B EC 53 56 8B 75 08 57 8B 16 8B 7D 10 42 8B D9 3B 55 0C 7E 12 8B 47 40 57 56 50 52 E8 ?? ?? ?? ?? 33 D2 85 C0 75 0D 57 56 FF 75 0C 8B CB 52 E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule file_185_67_0 {
	meta:
		name = "?GetNextSchedulingNode@SchedulerBase@details@Concurrency@@QAEPAVSchedulingNode@23@PAHH@Z"
		size = 77
	strings:
		$1 = { 55 8B EC 51 8B C1 33 C9 83 7D 0C FF 53 8B 5D 08 0F 95 C1 56 57 8B 78 2C 33 F6 89 45 FC 03 0B 85 FF 7E 1D 8D 04 0E 99 F7 FF 3B 55 0C 74 12 8B 45 FC 8B 40 20 8B 04 90 85 C0 75 0E 46 3B F7 7C E3 33 C0 5F 5E 5B C9 C2 08 00 89 13 EB F5 }
	condition:
		$1
}

rule file_185_68_0 {
	meta:
		name = "?GetNextVirtualProcessor@SchedulingNode@details@Concurrency@@QAEPAVVirtualProcessor@23@PAHH@Z"
		size = 53
		refs = "0019 ?FindVirtualProcessor@SchedulingNode@details@Concurrency@@QAEPAVVirtualProcessor@23@HHPAH@Z"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 57 8B 16 42 8B F9 3B 55 0C 7E 11 8B 47 78 56 50 52 E8 ?? ?? ?? ?? 33 D2 85 C0 75 0C 56 FF 75 0C 8B CF 52 E8 ?? ?? ?? ?? 5F 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_185_72_0 {
	meta:
		name = "?GetPseudoRRAffineScheduleGroupSegment@SchedulingRing@details@Concurrency@@QAEPAVScheduleGroupSegmentBase@23@PAH@Z"
		size = 59
		refs = "001b ?FindScheduleGroupSegment@SchedulingRing@details@Concurrency@@AAEPAVScheduleGroupSegmentBase@23@HHPAHPAV?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 55 8B EC 53 56 8B F1 57 8B 46 50 8B BE B0 00 00 00 8D 5E 10 53 FF 75 08 50 57 E8 ?? ?? ?? ?? 85 C0 75 11 85 FF 74 0D 53 FF 75 08 8B CE 57 50 E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_185_73_0 {
	meta:
		name = "?GetPseudoRRNonAffineScheduleGroupSegment@SchedulingRing@details@Concurrency@@QAEPAVScheduleGroupSegmentBase@23@PAH@Z"
		size = 62
		refs = "001e ?FindScheduleGroupSegment@SchedulingRing@details@Concurrency@@AAEPAVScheduleGroupSegmentBase@23@HHPAHPAV?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 55 8B EC 53 56 8B F1 57 8B 86 A0 00 00 00 8B BE B4 00 00 00 8D 5E 60 53 FF 75 08 50 57 E8 ?? ?? ?? ?? 85 C0 75 11 85 FF 74 0D 53 FF 75 08 8B CE 57 50 E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_185_74_0 {
	meta:
		name = "?GetRealizedChore@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@_N@Z"
		size = 80
		refs = "0014 ?GetRealizedChore@ScheduleGroupSegmentBase@details@Concurrency@@IAEPAVRealizedChore@23@XZ 0037 ?HasRealizedChores@ScheduleGroupSegmentBase@details@Concurrency@@IBE_NXZ"
	strings:
		$1 = { 55 8B EC 83 EC 0C 80 7D 10 00 56 8B 75 0C 57 8B CE 74 23 E8 ?? ?? ?? ?? 85 C0 74 2C C7 45 F4 02 00 00 00 89 45 FC 8B 7D 08 89 75 F8 8D 75 F4 A5 A5 A5 B0 01 EB 14 E8 ?? ?? ?? ?? 84 C0 74 09 C7 45 F4 08 00 00 00 EB DE 32 C0 5F 5E C9 C2 0C 00 }
	condition:
		$1
}

rule file_185_75_0 {
	meta:
		name = "?GetRealizedChoreWithinGroup@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@_NW4SearchAffinity@123@2@Z"
		size = 129
		refs = "001b ?SkipSegmentSearch@WorkSearchContext@details@Concurrency@@AAE_NPAVScheduleGroupSegmentBase@23@0W4SearchAffinity@123@_N@Z 002d ?GetRealizedChore@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@_N@Z"
	strings:
		$1 = { 55 8B EC 53 8B 5D 0C 56 8B B3 00 01 00 00 57 FF 75 18 8B F9 FF 75 14 6A 00 53 E8 ?? ?? ?? ?? 84 C0 75 16 FF 75 10 8B CF 53 FF 75 08 E8 ?? ?? ?? ?? 84 C0 74 04 B0 01 EB 41 83 7D 14 00 74 05 8B 76 0C EB 30 8B 76 10 EB 2B FF 75 18 8B CF FF 75 14 53 56 E8 ?? ?? ?? ?? 84 C0 75 12 FF 75 10 8B CF 56 FF 75 08 E8 ?? ?? ?? ?? 84 C0 75 C7 8B B6 04 01 00 00 85 F6 75 D1 32 C0 5F 5E 5B 5D C2 14 00 }
	condition:
		$1
}

rule file_185_76_0 {
	meta:
		name = "?GetRunnableContext@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@@Z"
		size = 49
		refs = "0019 ??0WorkItem@details@Concurrency@@QAE@PAVInternalContextBase@12@@Z"
	strings:
		$1 = { 55 8B EC 8B 4D 0C 83 EC 0C 8B 01 FF 50 0C 85 C0 74 19 56 57 50 8D 4D F4 E8 ?? ?? ?? ?? 8B 7D 08 8B F0 A5 A5 A5 5F B0 01 5E EB 02 32 C0 C9 C2 08 00 }
	condition:
		$1
}

rule file_185_77_0 {
	meta:
		name = "?GetRunnableContextWithinGroup@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@W4SearchAffinity@123@_N@Z"
		size = 123
		refs = "001b ?SkipSegmentSearch@WorkSearchContext@details@Concurrency@@AAE_NPAVScheduleGroupSegmentBase@23@0W4SearchAffinity@123@_N@Z 002a ?GetRunnableContext@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@@Z"
	strings:
		$1 = { 55 8B EC 53 8B 5D 0C 56 8B B3 00 01 00 00 57 FF 75 14 8B F9 FF 75 10 6A 00 53 E8 ?? ?? ?? ?? 84 C0 75 13 53 FF 75 08 8B CF E8 ?? ?? ?? ?? 84 C0 74 04 B0 01 EB 3E 83 7D 10 00 74 05 8B 76 0C EB 2D 8B 76 10 EB 28 FF 75 14 8B CF FF 75 10 53 56 E8 ?? ?? ?? ?? 84 C0 75 0F 56 FF 75 08 8B CF E8 ?? ?? ?? ?? 84 C0 75 CA 8B B6 04 01 00 00 85 F6 75 D4 32 C0 5F 5E 5B 5D C2 10 00 }
	condition:
		$1
}

rule file_185_82_0 {
	meta:
		name = "?GetUnrealizedChore@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@_N2@Z"
		size = 83
		refs = "0017 ?StealUnrealizedChore@ScheduleGroupSegmentBase@details@Concurrency@@IAEPAV_UnrealizedChore@23@_N@Z 003a ?LocateUnrealizedChores@ScheduleGroupSegmentBase@details@Concurrency@@IAEPAVWorkQueue@23@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 0C 80 7D 14 00 56 8B 75 0C 57 8B CE 74 26 FF 75 10 E8 ?? ?? ?? ?? 85 C0 74 2C C7 45 F4 04 00 00 00 8B 7D 08 89 75 F8 89 45 FC 8D 75 F4 A5 A5 A5 B0 01 EB 14 E8 ?? ?? ?? ?? 85 C0 74 09 C7 45 F4 10 00 00 00 EB DB 32 C0 5F 5E C9 C2 10 00 }
	condition:
		$1
}

rule file_185_83_0 {
	meta:
		name = "?GetUnrealizedChoreWithinGroup@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@_NW4SearchAffinity@123@2@Z"
		size = 142
		refs = "001e ?SkipSegmentSearch@WorkSearchContext@details@Concurrency@@AAE_NPAVScheduleGroupSegmentBase@23@0W4SearchAffinity@123@_N@Z 0033 ?GetUnrealizedChore@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@_N2@Z"
	strings:
		$1 = { 55 8B EC 51 56 8B 75 0C 57 FF 75 18 8B 86 00 01 00 00 FF 75 14 8B F9 6A 00 56 89 45 FC E8 ?? ?? ?? ?? 84 C0 75 19 FF 75 10 8B CF FF 75 18 56 FF 75 08 E8 ?? ?? ?? ?? 84 C0 74 04 B0 01 EB 49 83 7D 14 00 8B 75 FC 74 05 8B 76 0C EB 35 8B 76 10 EB 30 FF 75 18 8B CF FF 75 14 FF 75 0C 56 E8 ?? ?? ?? ?? 84 C0 75 15 FF 75 10 8B CF FF 75 18 56 FF 75 08 E8 ?? ?? ?? ?? 84 C0 75 BF 8B B6 04 01 00 00 85 F6 75 CC 32 C0 5F 5E C9 C2 14 00 }
	condition:
		$1
}

rule file_185_84_0 {
	meta:
		name = "?Grow@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@AAEPAUSegment@123@PAU4123@@Z"
		size = 74
		refs = "0003 __ehhandler$?Grow@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@AAEPAUSegment@123@PAU4123@@Z 0008 __EH_prolog3 0011 ??2@YAPAXI@Z 0038 ??0Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@23@ABVQuickBitSet@23@II@Z 0043 __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 6A 2C E8 ?? ?? ?? ?? 59 8B C8 89 4D F0 8B 7D 08 33 C0 89 45 FC 85 C9 74 15 8B 47 10 03 46 0C 50 FF 76 0C 8D 46 04 50 FF 36 E8 ?? ?? ?? ?? 89 46 10 89 47 18 E8 ?? ?? ?? ?? C2 04 00 }
	condition:
		$1
}

rule file_185_89_0 {
	meta:
		name = "?InternalRelease@ScheduleGroupBase@details@Concurrency@@IAEJXZ"
		size = 46
		refs = "0021 ?RemoveScheduleGroup@SchedulerBase@details@Concurrency@@QAEXPAVScheduleGroupBase@23@@Z"
	strings:
		$1 = { 56 8B F1 F6 46 30 04 75 21 57 8D 46 14 83 CF FF F0 0F C1 38 4F 75 0E 8B 16 FF 52 1C 8B 4E 04 56 E8 ?? ?? ?? ?? 8B C7 5F 5E C3 33 C0 5E C3 }
	condition:
		$1
}

rule file_185_90_0 {
	meta:
		name = "?Intersects@QuickBitSet@details@Concurrency@@QBE_NABV123@@Z"
		size = 62
	strings:
		$1 = { 55 8B EC 53 56 8B D9 33 D2 8B 33 83 C6 1F C1 EE 05 57 8B FA 85 F6 74 18 85 D2 75 14 8B 45 08 8B 4B 04 8B 40 04 8B 14 B8 23 14 B9 47 3B FE 72 E8 5F 33 C0 85 D2 5E 0F 95 C0 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_185_91_0 {
	meta:
		name = "?Invoke@WorkItem@details@Concurrency@@QAEXXZ"
		size = 53
		refs = "001b ?Invoke@RealizedChore@details@Concurrency@@QAEXXZ 002f ?ReleaseRealizedChore@SchedulerBase@details@Concurrency@@QAEXPAVRealizedChore@23@@Z"
	strings:
		$1 = { 56 8B F1 8B 06 48 48 74 0E 48 48 75 26 8B 46 08 50 FF 50 0C 59 5E C3 8B 4E 08 E8 ?? ?? ?? ?? 8B 46 04 FF 76 08 8B 88 00 01 00 00 8B 49 04 E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_185_96_0 {
	meta:
		name = "?LocateMailboxSegment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@AAEPAUSegment@123@I_N@Z"
		size = 74
		refs = "000d ?DemandInitialize@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@AAEXXZ 0037 ?Grow@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@AAEPAUSegment@123@PAU4123@@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 83 7E 14 00 75 05 E8 ?? ?? ?? ?? 80 7D 0C 00 74 05 8B 4E 10 EB 03 8B 4E 14 8B D1 8B 41 10 03 46 0C 39 45 08 72 17 8B 49 18 85 C9 75 0A 52 8B CE E8 ?? ?? ?? ?? 8B C8 8B D1 85 C9 75 DE 8B C1 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_185_100_0 {
	meta:
		name = "?PeriodicScan@SchedulerBase@details@Concurrency@@QAEXK@Z"
		size = 31
		refs = "0017 ?PerformServiceScan@SchedulerBase@details@Concurrency@@AAEXK@Z"
	strings:
		$1 = { 55 8B EC 8B 91 9C 01 00 00 8B 45 08 2B C2 3D D0 07 00 00 76 06 5D E9 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_185_102_0 {
	meta:
		name = "?PreSearch@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@@Z"
		size = 48
		refs = "0018 ??0WorkItem@details@Concurrency@@QAE@PAVInternalContextBase@12@@Z"
	strings:
		$1 = { 55 8B EC 8B 09 83 EC 0C 8B 01 FF 50 08 85 C0 74 19 56 57 50 8D 4D F4 E8 ?? ?? ?? ?? 8B 7D 08 8B F0 A5 A5 A5 5F B0 01 5E EB 02 32 C0 C9 C2 04 00 }
	condition:
		$1
}

rule file_185_103_0 {
	meta:
		name = "?QuickSearch@WorkSearchContext@details@Concurrency@@AAE_NPAVScheduleGroupSegmentBase@23@PAVWorkItem@23@_NK@Z"
		size = 109
		refs = "0016 ?GetRunnableContext@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@@Z 0036 ?GetRealizedChore@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@_N@Z 0059 ?GetUnrealizedChore@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@_N2@Z"
	strings:
		$1 = { 55 8B EC 53 8B 5D 14 56 8B F1 F6 C3 01 74 0F FF 75 08 FF 75 0C E8 ?? ?? ?? ?? 84 C0 75 43 F6 C3 0A 74 1B 8B C3 D1 E8 24 01 0F B6 C0 50 FF 75 08 8B CE FF 75 0C E8 ?? ?? ?? ?? 84 C0 75 23 F6 C3 14 74 22 C1 EB 02 80 E3 01 0F B6 C3 50 FF 75 10 8B CE FF 75 08 FF 75 0C E8 ?? ?? ?? ?? 84 C0 74 04 B0 01 EB 02 32 C0 5E 5B 5D C2 10 00 }
	condition:
		$1
}

rule file_185_104_0 {
	meta:
		name = "?QuickSearchYield@WorkSearchContext@details@Concurrency@@AAE_NPAVScheduleGroupSegmentBase@23@PAVWorkItem@23@_NK@Z"
		size = 110
		refs = "0024 ?GetUnrealizedChore@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@_N2@Z 0044 ?GetRealizedChore@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@_N@Z 005a ?GetRunnableContext@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@@Z"
	strings:
		$1 = { 55 8B EC 53 8B 5D 14 56 8B F1 F6 C3 14 74 1D 8B C3 C1 E8 02 24 01 0F B6 C0 50 FF 75 10 FF 75 08 FF 75 0C E8 ?? ?? ?? ?? 84 C0 75 36 F6 C3 0A 74 1B 8B C3 D1 E8 24 01 0F B6 C0 50 FF 75 08 8B CE FF 75 0C E8 ?? ?? ?? ?? 84 C0 75 16 F6 C3 01 74 15 FF 75 08 8B CE FF 75 0C E8 ?? ?? ?? ?? 84 C0 74 04 B0 01 EB 02 32 C0 5E 5B 5D C2 10 00 }
	condition:
		$1
}

rule file_185_105_0 {
	meta:
		name = "?Reallocate@QuickBitSet@details@Concurrency@@IAEXI@Z"
		size = 55
		refs = "000a ??_V@YAXPAX@Z 0029 ??_U@YAPAXI@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 FF 76 04 E8 ?? ?? ?? ?? 8B 45 08 89 06 83 C0 1F 33 C9 6A 04 C1 E8 05 5A F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 59 59 89 46 04 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_185_106_0 {
	meta:
		name = "?Reset@WorkSearchContext@details@Concurrency@@QAEXPAVVirtualProcessor@23@W4Algorithm@123@@Z"
		size = 84
		refs = "0022 __imp__GetTickCount@0 0034 ?SearchFair@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@_NK@Z 003b ?SearchFairYield@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@_NK@Z 0044 ?SearchCacheLocal@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@_NK@Z 004b ?SearchCacheLocalYield@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@_NK@Z"
	strings:
		$1 = { 55 8B EC 8B 55 08 56 8B F1 83 66 0C 00 89 16 8B 82 84 00 00 00 89 46 08 8B 42 44 8B 00 89 46 04 FF 15 ?? ?? ?? ?? FF 4D 0C 89 46 14 89 46 10 74 10 C7 46 18 ?? ?? ?? ?? C7 46 1C ?? ?? ?? ?? EB 0E C7 46 18 ?? ?? ?? ?? C7 46 1C ?? ?? ?? ?? 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_185_108_0 {
	meta:
		name = "?ResolveToken@WorkItem@details@Concurrency@@QAE_NXZ"
		size = 126
		refs = "0025 ?Dequeue@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE_NPAPAV_UnrealizedChore@23@@Z 003a ?_SetDetached@_UnrealizedChore@details@Concurrency@@QAEX_N@Z 004c ?Steal@WorkQueue@details@Concurrency@@QAEPAV_UnrealizedChore@23@_N@Z 0060 ?GetRealizedChore@ScheduleGroupSegmentBase@details@Concurrency@@IAEPAVRealizedChore@23@XZ"
	strings:
		$1 = { 55 8B EC 51 56 8B F1 57 83 3E 08 74 4F 83 3E 10 75 5F 8B 4E 08 83 F9 01 75 2F 8B 4E 04 8D 45 FC 50 83 C1 34 E8 ?? ?? ?? ?? 0F B6 F8 F7 DF 1B FF 23 7D FC 74 3C 6A 01 8B CF E8 ?? ?? ?? ?? 89 7E 08 C7 06 04 00 00 00 EB 28 6A 00 E8 ?? ?? ?? ?? 85 C0 74 1D C7 06 04 00 00 00 EB 12 8B 4E 04 E8 ?? ?? ?? ?? 85 C0 74 09 C7 06 02 00 00 00 89 46 08 F6 06 18 6A 00 58 5F 0F 94 C0 5E C9 C3 }
	condition:
		$1
}

rule file_185_110_0 {
	meta:
		name = "?SearchCacheLocal@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@_NK@Z"
		size = 702
		refs = "0007 ___security_cookie 0026 ?PreSearch@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@@Z 0038 __imp__GetTickCount@0 0044 ?PeriodicScan@SchedulerBase@details@Concurrency@@QAEXK@Z 004e ?CheckPriorityList@WorkSearchContext@details@Concurrency@@AAE_NK@Z 0079 ?QuickSearch@WorkSearchContext@details@Concurrency@@AAE_NPAVScheduleGroupSegmentBase@23@PAVWorkItem@23@_NK@Z 0090 ?StealLocalRunnableContext@VirtualProcessor@details@Concurrency@@AAEPAVInternalContextBase@23@XZ 009c ?GetNextPriorityObject@SchedulerBase@details@Concurrency@@QAEPAUBoostedObject@23@XZ 00ab ??0WorkItem@details@Concurrency@@QAE@PAVInternalContextBase@12@@Z 00ec ?CheckAffinityNotification@VirtualProcessor@details@Concurrency@@QAE_NXZ 012b ?AcquireQuickCacheSlot@SchedulerBase@details@Concurrency@@QAEPAVScheduleGroupSegmentBase@23@I@Z 015e ?GetLocalRunnable@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVVirtualProcessor@23@_N@Z 018c ?SearchCacheLocal_Runnables@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@PAVScheduleGroupSegmentBase@23@_NW4SearchAffinity@123@K3@Z 01bd ?SearchCacheLocal_Realized@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@PAVScheduleGroupSegmentBase@23@_NW4SearchAffinity@123@K3@Z 01ef ?SearchCacheLocal_Unrealized@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@PAVScheduleGroupSegmentBase@23@_NW4SearchAffinity@123@K3@Z 0212 ?StealLocalRunnable@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingNode@23@PAVVirtualProcessor@23@@Z 0230 ?GetNextSchedulingRing@SchedulerBase@details@Concurrency@@QAEPAVSchedulingRing@23@PBV423@PAV423@@Z 025b ?ServiceMark@ScheduleGroupSegmentBase@details@Concurrency@@QAEXK@Z 027a ?_Assign@location@Concurrency@@QAEXABV12@@Z 0283 ?_FastVPIntersects@location@Concurrency@@QBE_NABV12@@Z 029f ?UpdateWorkState@VirtualProcessor@details@Concurrency@@QAEX_N0@Z 02af @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 30 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 53 57 8B 7D 08 57 8B D9 89 7D DC 89 45 D4 C6 45 EB 00 E8 ?? ?? ?? ?? 84 C0 74 07 B0 01 E9 72 02 00 00 56 FF 15 ?? ?? ?? ?? 8B 4B 04 50 89 43 10 E8 ?? ?? ?? ?? FF 73 10 8B CB E8 ?? ?? ?? ?? 84 C0 74 6B 8B 4B 04 83 B9 30 01 00 00 00 74 59 EB 37 83 38 00 75 1A FF 75 14 05 F4 FE FF FF FF 75 10 8B CB 57 50 E8 ?? ?? ?? ?? 84 C0 75 36 EB 15 F6 45 14 01 74 0F 8D 88 40 FF FF FF E8 ?? ?? ?? ?? 85 C0 75 0E 8B 4B 04 E8 ?? ?? ?? ?? 85 C0 75 C0 EB 15 50 8D 4D F0 E8 ?? ?? ?? ?? 8B F0 A5 A5 A5 8B 7D DC C6 45 EB 01 8B 03 C6 40 56 01 80 7D EB 00 8B 0B 8B 41 48 89 45 DC 0F 85 7C 01 00 00 83 65 F4 00 80 79 54 00 C7 45 F0 01 00 00 00 C7 45 F8 02 00 00 00 75 13 E8 ?? ?? ?? ?? 84 C0 75 0A 38 45 10 75 05 33 F6 46 EB 02 33 F6 8A 45 EB C6 45 E7 01 83 FE 02 0F 8F 3B 01 00 00 8B 4D D4 89 4D D8 8B 4D DC 89 4D E0 85 C9 0F 84 1E 01 00 00 FF 73 08 8B 4B 04 E8 ?? ?? ?? ?? 85 C0 74 17 FF 75 14 8B CB FF 75 10 57 50 E8 ?? ?? ?? ?? 84 C0 0F 85 6D 01 00 00 80 7D E7 00 74 1A F6 45 14 01 74 14 6A 00 FF 33 8B CB 57 E8 ?? ?? ?? ?? 84 C0 0F 85 4D 01 00 00 8B 45 14 83 E0 01 89 45 D0 74 23 FF 75 10 8B CB FF 75 14 FF 74 B5 F0 FF 75 E7 FF 75 D8 FF 75 E0 57 E8 ?? ?? ?? ?? 84 C0 0F 85 1F 01 00 00 F6 45 14 0A 74 2B FF 75 10 8B 45 14 FF 75 14 D1 E8 FF 74 B5 F0 24 01 0F B6 C0 50 FF 75 D8 8B CB FF 75 E0 57 E8 ?? ?? ?? ?? 84 C0 0F 85 EE 00 00 00 F6 45 14 14 74 2C FF 75 10 8B 45 14 FF 75 14 C1 E8 02 FF 74 B5 F0 24 01 0F B6 C0 50 FF 75 D8 8B CB FF 75 E0 57 E8 ?? ?? ?? ?? 84 C0 0F 85 BC 00 00 00 83 7D D0 00 74 1D 83 FE 02 75 18 FF 33 8B 45 E0 8B CB FF 70 04 57 E8 ?? ?? ?? ?? 84 C0 0F 85 99 00 00 00 FF 75 E0 8B 4B 04 FF 75 DC 83 65 D8 00 C6 45 E7 00 E8 ?? ?? ?? ?? 89 45 E0 85 C0 0F 85 E5 FE FF FF 8A 45 EB 46 84 C0 0F 84 BC FE FF FF 84 C0 74 57 8B 77 04 FF 73 10 8B 7E 08 8B CE E8 ?? ?? ?? ?? 83 C6 0C C6 45 E7 00 F7 06 FF FF FF 0F 74 21 8B 03 05 88 00 00 00 50 8D 4D EC E8 ?? ?? ?? ?? 56 8D 4D EC E8 ?? ?? ?? ?? 84 C0 74 04 C6 45 E7 01 3B 7D DC 8B 0B 0F 94 C2 0F B6 D2 52 FF 75 E7 E8 ?? ?? ?? ?? 8A 45 EB 5E 8B 4D FC 5F 33 CD 5B E8 ?? ?? ?? ?? C9 C2 10 00 B0 01 88 45 EB EB 84 }
	condition:
		$1
}

rule file_185_111_0 {
	meta:
		name = "?SearchCacheLocalYield@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@_NK@Z"
		size = 639
		refs = "0007 ___security_cookie 0026 ?PreSearch@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@@Z 0038 __imp__GetTickCount@0 0044 ?PeriodicScan@SchedulerBase@details@Concurrency@@QAEXK@Z 004e ?CheckPriorityList@WorkSearchContext@details@Concurrency@@AAE_NK@Z 0079 ?QuickSearchYield@WorkSearchContext@details@Concurrency@@AAE_NPAVScheduleGroupSegmentBase@23@PAVWorkItem@23@_NK@Z 0090 ?StealLocalRunnableContext@VirtualProcessor@details@Concurrency@@AAEPAVInternalContextBase@23@XZ 009c ?GetNextPriorityObject@SchedulerBase@details@Concurrency@@QAEPAUBoostedObject@23@XZ 00ab ??0WorkItem@details@Concurrency@@QAE@PAVInternalContextBase@12@@Z 00ec ?CheckAffinityNotification@VirtualProcessor@details@Concurrency@@QAE_NXZ 014d ?SearchCacheLocal_Unrealized@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@PAVScheduleGroupSegmentBase@23@_NW4SearchAffinity@123@K3@Z 0180 ?SearchCacheLocal_Realized@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@PAVScheduleGroupSegmentBase@23@_NW4SearchAffinity@123@K3@Z 01af ?SearchCacheLocal_Runnables@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@PAVScheduleGroupSegmentBase@23@_NW4SearchAffinity@123@K3@Z 01cf ?StealLocalRunnable@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingNode@23@PAVVirtualProcessor@23@@Z 01ec ?GetLocalRunnable@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVVirtualProcessor@23@_N@Z 0207 ?GetNextSchedulingRing@SchedulerBase@details@Concurrency@@QAEPAVSchedulingRing@23@PBV423@PAV423@@Z 0240 ?ServiceMark@ScheduleGroupSegmentBase@details@Concurrency@@QAEXK@Z 0267 ?UpdateWorkState@VirtualProcessor@details@Concurrency@@QAEX_N0@Z 0277 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 30 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 53 57 8B 7D 08 57 8B D9 89 7D DC 89 45 D0 C6 45 EF 00 E8 ?? ?? ?? ?? 84 C0 74 07 B0 01 E9 3A 02 00 00 56 FF 15 ?? ?? ?? ?? 8B 4B 04 50 89 43 10 E8 ?? ?? ?? ?? FF 73 10 8B CB E8 ?? ?? ?? ?? 84 C0 74 6B 8B 4B 04 83 B9 30 01 00 00 00 74 59 EB 37 83 38 00 75 1A FF 75 14 05 F4 FE FF FF FF 75 10 8B CB 57 50 E8 ?? ?? ?? ?? 84 C0 75 36 EB 15 F6 45 14 01 74 0F 8D 88 40 FF FF FF E8 ?? ?? ?? ?? 85 C0 75 0E 8B 4B 04 E8 ?? ?? ?? ?? 85 C0 75 C0 EB 15 50 8D 4D F0 E8 ?? ?? ?? ?? 8B F0 A5 A5 A5 8B 7D DC C6 45 EF 01 8B 03 C6 40 56 01 80 7D EF 00 8B 0B 8B 41 48 89 45 E0 0F 85 63 01 00 00 83 65 F4 00 80 79 54 00 C7 45 F0 01 00 00 00 C7 45 F8 02 00 00 00 75 13 E8 ?? ?? ?? ?? 84 C0 75 0A 38 45 10 75 05 33 F6 46 EB 02 33 F6 8A 45 EF C6 45 D8 01 83 FE 02 0F 8F 22 01 00 00 8B 4D E0 8B 55 D0 89 55 E4 89 4D E8 85 C9 0F 84 05 01 00 00 8B 45 14 83 E0 14 89 45 D4 85 C0 74 2E FF 75 10 8B 45 14 FF 75 14 C1 E8 02 FF 74 B5 F0 24 01 0F B6 C0 50 52 51 57 8B CB E8 ?? ?? ?? ?? 84 C0 0F 85 C6 00 00 00 8B 4D E8 8B 55 E4 F6 45 14 0A 74 27 FF 75 10 8B 45 14 FF 75 14 D1 E8 FF 74 B5 F0 24 01 0F B6 C0 50 52 51 57 8B CB E8 ?? ?? ?? ?? 84 C0 0F 85 93 00 00 00 8B 45 14 83 E0 01 89 45 DC 74 23 FF 75 10 8B 45 E4 FF 75 14 8B CB FF 74 B5 F0 FF 75 D8 50 FF 75 E8 57 E8 ?? ?? ?? ?? 84 C0 75 68 8B 45 DC 85 C0 74 1C 83 FE 02 75 17 FF 33 8B 45 E8 8B CB FF 70 04 57 E8 ?? ?? ?? ?? 84 C0 75 48 8B 45 DC 80 7D D8 00 74 14 85 C0 74 10 6A 01 FF 33 8B CB 57 E8 ?? ?? ?? ?? 84 C0 75 2B FF 75 E8 8B 4B 04 FF 75 E0 33 C0 C6 45 D8 00 89 45 E4 E8 ?? ?? ?? ?? 8B C8 89 4D E8 85 C9 74 12 8B 55 E4 8B 45 D4 E9 0E FF FF FF B0 01 88 45 EF EB 03 8A 45 EF 46 84 C0 0F 84 D5 FE FF FF 84 C0 74 38 8B 4F 04 FF 73 10 8B 71 08 E8 ?? ?? ?? ?? 3B 75 E0 8B 0B 0F 94 C0 0F B6 C0 50 8B 47 04 8B 50 0C 81 E2 FF FF FF 0F F7 DA 1A D2 FE C2 0F B6 D2 52 E8 ?? ?? ?? ?? 8A 45 EF 5E 8B 4D FC 5F 33 CD 5B E8 ?? ?? ?? ?? C9 C2 10 00 }
	condition:
		$1
}

rule file_185_112_0 {
	meta:
		name = "?SearchCacheLocal_Realized@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@PAVScheduleGroupSegmentBase@23@_NW4SearchAffinity@123@K3@Z"
		size = 249
		refs = "0021 ?GetRealizedChoreWithinGroup@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@_NW4SearchAffinity@123@2@Z 0040 ?GetPseudoRRNonAffineScheduleGroupSegment@SchedulingRing@details@Concurrency@@QAEPAVScheduleGroupSegmentBase@23@PAH@Z 0047 ?GetPseudoRRAffineScheduleGroupSegment@SchedulingRing@details@Concurrency@@QAEPAVScheduleGroupSegmentBase@23@PAH@Z 005f ?AcquireQuickCacheSlot@SchedulerBase@details@Concurrency@@QAEPAVScheduleGroupSegmentBase@23@I@Z 0075 ?QuickSearch@WorkSearchContext@details@Concurrency@@AAE_NPAVScheduleGroupSegmentBase@23@PAVWorkItem@23@_NK@Z 0089 ?SkipSegmentSearch@WorkSearchContext@details@Concurrency@@AAE_NPAVScheduleGroupSegmentBase@23@0W4SearchAffinity@123@_N@Z 009c ?GetRealizedChore@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@_N@Z 00b9 ?GetNextScheduleGroupSegment@SchedulingRing@details@Concurrency@@AAEPAVScheduleGroupSegmentBase@23@PAHHPAV?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 55 8B EC 51 83 7D 10 00 8B C1 57 8B 7D 18 89 45 FC 74 1D FF 75 20 57 FF 75 14 FF 75 10 FF 75 08 E8 ?? ?? ?? ?? 84 C0 74 07 B0 01 E9 97 00 00 00 53 56 8B 75 0C 8D 45 18 50 8B CE 85 FF 75 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 8B D8 8B 45 18 89 45 0C EB 6A 8B 45 FC FF 70 08 8B 48 04 E8 ?? ?? ?? ?? 85 C0 74 16 FF 75 1C 8B 4D FC FF 75 20 FF 75 08 50 E8 ?? ?? ?? ?? 84 C0 75 78 FF 75 20 8B 4D FC 57 FF 75 10 53 E8 ?? ?? ?? ?? 84 C0 75 13 FF 75 14 8B 4D FC 53 FF 75 08 E8 ?? ?? ?? ?? 84 C0 75 28 8B CE 8D 46 60 85 FF 74 03 8D 46 10 50 FF 75 0C 8D 45 18 50 E8 ?? ?? ?? ?? 8B D8 85 DB 75 92 32 C0 5E 5B 5F C9 C2 1C 00 85 FF 75 15 8B 8E A0 00 00 00 8B 45 18 40 99 F7 F9 89 96 B4 00 00 00 EB 10 8B 4E 50 8B 45 18 40 99 F7 F9 89 96 B0 00 00 00 B0 01 EB CC }
	condition:
		$1
}

rule file_185_113_0 {
	meta:
		name = "?SearchCacheLocal_Runnables@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@PAVScheduleGroupSegmentBase@23@_NW4SearchAffinity@123@K3@Z"
		size = 262
		refs = "001b ?GetRunnableContextWithinGroup@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@W4SearchAffinity@123@_N@Z 003c ?StealLocalRunnable@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingNode@23@PAVVirtualProcessor@23@@Z 0053 ?GetPseudoRRNonAffineScheduleGroupSegment@SchedulingRing@details@Concurrency@@QAEPAVScheduleGroupSegmentBase@23@PAH@Z 005a ?GetPseudoRRAffineScheduleGroupSegment@SchedulingRing@details@Concurrency@@QAEPAVScheduleGroupSegmentBase@23@PAH@Z 006d ?AcquireQuickCacheSlot@SchedulerBase@details@Concurrency@@QAEPAVScheduleGroupSegmentBase@23@I@Z 0082 ?QuickSearch@WorkSearchContext@details@Concurrency@@AAE_NPAVScheduleGroupSegmentBase@23@PAVWorkItem@23@_NK@Z 0097 ?SkipSegmentSearch@WorkSearchContext@details@Concurrency@@AAE_NPAVScheduleGroupSegmentBase@23@0W4SearchAffinity@123@_N@Z 00a8 ?GetRunnableContext@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@@Z 00c5 ?GetNextScheduleGroupSegment@SchedulingRing@details@Concurrency@@AAEPAVScheduleGroupSegmentBase@23@PAHHPAV?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 55 8B EC 83 7D 10 00 53 8B 5D 18 57 8B F9 74 1A FF 75 20 53 FF 75 10 FF 75 08 E8 ?? ?? ?? ?? 84 C0 74 07 B0 01 E9 A9 00 00 00 80 7D 14 00 74 14 8B 07 50 FF 70 44 8B CF FF 75 08 E8 ?? ?? ?? ?? 84 C0 75 DF 56 8B 75 0C 8D 45 14 50 8B CE 85 DB 75 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 8B 4D 14 89 4D 18 EB 63 FF 77 08 8B 4F 04 E8 ?? ?? ?? ?? 85 C0 74 15 FF 75 1C 8B CF FF 75 20 FF 75 08 50 E8 ?? ?? ?? ?? 84 C0 75 78 FF 75 20 8B CF 53 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 84 C0 75 11 FF 75 0C 8B CF FF 75 08 E8 ?? ?? ?? ?? 84 C0 75 29 8B CE 8D 46 60 85 DB 74 03 8D 46 10 50 FF 75 18 8D 45 14 50 E8 ?? ?? ?? ?? 89 45 0C 85 C0 75 96 32 C0 5E 5F 5B 5D C2 1C 00 85 DB 75 15 8B 8E A0 00 00 00 8B 45 14 40 99 F7 F9 89 96 B4 00 00 00 EB 10 8B 4E 50 8B 45 14 40 99 F7 F9 89 96 B0 00 00 00 B0 01 EB CC }
	condition:
		$1
}

rule file_185_114_0 {
	meta:
		name = "?SearchCacheLocal_Unrealized@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@PAVScheduleGroupSegmentBase@23@_NW4SearchAffinity@123@K3@Z"
		size = 252
		refs = "0021 ?GetUnrealizedChoreWithinGroup@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@_NW4SearchAffinity@123@2@Z 0040 ?GetPseudoRRNonAffineScheduleGroupSegment@SchedulingRing@details@Concurrency@@QAEPAVScheduleGroupSegmentBase@23@PAH@Z 0047 ?GetPseudoRRAffineScheduleGroupSegment@SchedulingRing@details@Concurrency@@QAEPAVScheduleGroupSegmentBase@23@PAH@Z 005f ?AcquireQuickCacheSlot@SchedulerBase@details@Concurrency@@QAEPAVScheduleGroupSegmentBase@23@I@Z 0075 ?QuickSearch@WorkSearchContext@details@Concurrency@@AAE_NPAVScheduleGroupSegmentBase@23@PAVWorkItem@23@_NK@Z 0089 ?SkipSegmentSearch@WorkSearchContext@details@Concurrency@@AAE_NPAVScheduleGroupSegmentBase@23@0W4SearchAffinity@123@_N@Z 009f ?GetUnrealizedChore@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@_N2@Z 00bc ?GetNextScheduleGroupSegment@SchedulingRing@details@Concurrency@@AAEPAVScheduleGroupSegmentBase@23@PAHHPAV?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 55 8B EC 51 83 7D 10 00 8B C1 57 8B 7D 18 89 45 FC 74 1D FF 75 20 57 FF 75 14 FF 75 10 FF 75 08 E8 ?? ?? ?? ?? 84 C0 74 07 B0 01 E9 9A 00 00 00 53 56 8B 75 0C 8D 45 18 50 8B CE 85 FF 75 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 8B D8 8B 45 18 89 45 0C EB 6D 8B 45 FC FF 70 08 8B 48 04 E8 ?? ?? ?? ?? 85 C0 74 16 FF 75 1C 8B 4D FC FF 75 20 FF 75 08 50 E8 ?? ?? ?? ?? 84 C0 75 7B FF 75 20 8B 4D FC 57 FF 75 10 53 E8 ?? ?? ?? ?? 84 C0 75 16 FF 75 14 8B 4D FC FF 75 20 53 FF 75 08 E8 ?? ?? ?? ?? 84 C0 75 28 8B CE 8D 46 60 85 FF 74 03 8D 46 10 50 FF 75 0C 8D 45 18 50 E8 ?? ?? ?? ?? 8B D8 85 DB 75 8F 32 C0 5E 5B 5F C9 C2 1C 00 85 FF 75 15 8B 8E A0 00 00 00 8B 45 18 40 99 F7 F9 89 96 B4 00 00 00 EB 10 8B 4E 50 8B 45 18 40 99 F7 F9 89 96 B0 00 00 00 B0 01 EB CC }
	condition:
		$1
}

rule file_185_115_0 {
	meta:
		name = "?SearchFair@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@_NK@Z"
		size = 275
		refs = "000f ?PreSearch@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@@Z 0023 ?GetNextSchedulingRing@SchedulerBase@details@Concurrency@@QAEPAVSchedulingRing@23@XZ 0040 ?SearchFair_Runnables@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@@Z 0056 ?GetNextSchedulingRing@SchedulerBase@details@Concurrency@@QAEPAVSchedulingRing@23@PBV423@PAV423@@Z 006c ?StealForeignLocalRunnable@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingNode@23@@Z 009c ?SearchFair_Realized@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@_N@Z 00e1 ?SearchFair_Unrealized@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@_N@Z 0106 ?SetNextSchedulingRing@SchedulerBase@details@Concurrency@@QAEXPAVSchedulingRing@23@@Z"
	strings:
		$1 = { 55 8B EC 51 51 53 56 FF 75 08 8B F1 32 DB E8 ?? ?? ?? ?? 84 C0 74 07 B0 01 E9 EF 00 00 00 8B 4E 04 57 E8 ?? ?? ?? ?? 8B F8 8B 45 14 A8 01 74 4D 8B C7 89 7D FC 85 FF 74 28 50 FF 75 08 8B CE E8 ?? ?? ?? ?? FF 75 FC 8B 4E 04 8A D8 84 DB 0F 85 B1 00 00 00 57 E8 ?? ?? ?? ?? 89 45 FC 85 C0 75 D8 8B 06 8B CE FF 70 44 FF 75 08 E8 ?? ?? ?? ?? 8A D8 84 DB 0F 85 90 00 00 00 8B 45 14 A8 0A 74 40 8B CF 89 4D FC 85 FF 74 37 D1 E8 89 45 F8 24 01 0F B6 C0 50 51 FF 75 08 8B CE E8 ?? ?? ?? ?? 8B 4E 04 FF 75 FC 8A D8 84 DB 75 59 57 E8 ?? ?? ?? ?? 8B C8 89 45 FC 8B 45 F8 85 C9 75 D1 8B 45 14 A8 14 74 45 8B CF 89 4D FC 85 FF 74 3C C1 E8 02 89 45 14 24 01 0F B6 C0 50 51 FF 75 08 8B CE E8 ?? ?? ?? ?? 8B 4E 04 FF 75 FC 8A D8 84 DB 75 14 57 E8 ?? ?? ?? ?? 8B C8 89 45 FC 8B 45 14 85 C9 75 D1 EB 05 E8 ?? ?? ?? ?? 8A C3 5F 5E 5B C9 C2 10 00 }
	condition:
		$1
}

rule file_185_116_0 {
	meta:
		name = "?SearchFairYield@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupSegmentBase@23@_NK@Z"
		size = 270
		refs = "000f ?PreSearch@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@@Z 0023 ?GetNextSchedulingRing@SchedulerBase@details@Concurrency@@QAEPAVSchedulingRing@23@XZ 004e ?SearchFair_Unrealized@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@_N@Z 0064 ?GetNextSchedulingRing@SchedulerBase@details@Concurrency@@QAEPAVSchedulingRing@23@PBV423@PAV423@@Z 0098 ?SearchFair_Realized@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@_N@Z 00d0 ?SearchFair_Runnables@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@@Z 00f8 ?StealForeignLocalRunnable@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingNode@23@@Z 0108 ?SetNextSchedulingRing@SchedulerBase@details@Concurrency@@QAEXPAVSchedulingRing@23@@Z"
	strings:
		$1 = { 55 8B EC 51 51 53 56 FF 75 08 8B F1 32 DB E8 ?? ?? ?? ?? 84 C0 74 07 B0 01 E9 E3 00 00 00 8B 4E 04 57 E8 ?? ?? ?? ?? F6 45 14 14 8B F8 74 45 8B CF 89 4D FC 85 FF 74 3C 8B 45 14 C1 E8 02 89 45 F8 24 01 0F B6 C0 50 51 FF 75 08 8B CE E8 ?? ?? ?? ?? 8B 4E 04 FF 75 FC 8A D8 84 DB 0F 85 A5 00 00 00 57 E8 ?? ?? ?? ?? 8B C8 89 45 FC 8B 45 F8 85 C9 75 CD F6 45 14 0A 74 40 8B CF 89 4D FC 85 FF 74 37 8B 45 14 D1 E8 89 45 F8 24 01 0F B6 C0 50 51 FF 75 08 8B CE E8 ?? ?? ?? ?? 8B 4E 04 FF 75 FC 8A D8 84 DB 75 5F 57 E8 ?? ?? ?? ?? 8B C8 89 45 FC 8B 45 F8 85 C9 75 D1 F6 45 14 01 74 3E 8B C7 89 7D 14 85 FF 74 24 50 FF 75 08 8B CE E8 ?? ?? ?? ?? FF 75 14 8B 4E 04 8A D8 84 DB 75 27 57 E8 ?? ?? ?? ?? 89 45 14 85 C0 75 DC 8B 06 8B CE FF 70 44 FF 75 08 E8 ?? ?? ?? ?? 8A D8 8A C3 5F 5E 5B C9 C2 10 00 E8 ?? ?? ?? ?? EB F0 }
	condition:
		$1
}

rule file_185_117_0 {
	meta:
		name = "?SearchFair_Realized@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@_N@Z"
		size = 148
		refs = "0013 ?GetPseudoRRNonAffineScheduleGroupSegment@SchedulingRing@details@Concurrency@@QAEPAVScheduleGroupSegmentBase@23@PAH@Z 002a ?GetRealizedChore@ScheduleGroupSegmentBase@details@Concurrency@@IAEPAVRealizedChore@23@XZ 0062 ?HasRealizedChores@ScheduleGroupSegmentBase@details@Concurrency@@IBE_NXZ 0078 ?GetNextScheduleGroupSegment@SchedulingRing@details@Concurrency@@AAEPAVScheduleGroupSegmentBase@23@PAHHPAV?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 57 8B 7D 0C 8D 45 FC 50 8B CF E8 ?? ?? ?? ?? 8B F0 8B 45 FC 89 45 0C EB 5D 80 7D 10 00 8B CE 74 38 E8 ?? ?? ?? ?? 8B D8 85 DB 74 36 C7 45 F0 02 00 00 00 89 5D F8 8B 8F A0 00 00 00 8B 45 FC 40 99 F7 F9 89 75 F4 8D 75 F0 B0 01 89 97 B4 00 00 00 8B 7D 08 A5 A5 A5 EB 23 E8 ?? ?? ?? ?? 84 C0 75 21 8D 47 60 50 FF 75 0C 8D 45 FC 50 8B CF E8 ?? ?? ?? ?? 8B F0 85 F6 75 9F 32 C0 5F 5E 5B C9 C2 0C 00 C7 45 F0 08 00 00 00 EB AA }
	condition:
		$1
}

rule file_185_118_0 {
	meta:
		name = "?SearchFair_Runnables@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@@Z"
		size = 110
		refs = "0013 ?GetPseudoRRNonAffineScheduleGroupSegment@SchedulingRing@details@Concurrency@@QAEPAVScheduleGroupSegmentBase@23@PAH@Z 0035 ?GetNextScheduleGroupSegment@SchedulingRing@details@Concurrency@@AAEPAVScheduleGroupSegmentBase@23@PAHHPAV?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@23@@Z 005e ??0WorkItem@details@Concurrency@@QAE@PAVInternalContextBase@12@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 8B 75 0C 57 8D 45 FC 50 8B CE E8 ?? ?? ?? ?? 8B 5D FC EB 1D 8B 10 8B C8 FF 52 0C 8B F8 85 FF 75 1D 8D 46 60 50 53 8D 45 FC 50 8B CE E8 ?? ?? ?? ?? 85 C0 75 DF 32 C0 5F 5E 5B C9 C2 08 00 8B 8E A0 00 00 00 8B 45 FC 40 99 F7 F9 57 8D 4D F0 89 96 B4 00 00 00 E8 ?? ?? ?? ?? 8B 7D 08 8B F0 A5 A5 A5 B0 01 EB D1 }
	condition:
		$1
}

rule file_185_119_0 {
	meta:
		name = "?SearchFair_Unrealized@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@_N@Z"
		size = 152
		refs = "0013 ?GetPseudoRRNonAffineScheduleGroupSegment@SchedulingRing@details@Concurrency@@QAEPAVScheduleGroupSegmentBase@23@PAH@Z 002c ?StealUnrealizedChore@ScheduleGroupSegmentBase@details@Concurrency@@IAEPAV_UnrealizedChore@23@_N@Z 0064 ?LocateUnrealizedChores@ScheduleGroupSegmentBase@details@Concurrency@@IAEPAVWorkQueue@23@XZ 007c ?GetNextScheduleGroupSegment@SchedulingRing@details@Concurrency@@AAEPAVScheduleGroupSegmentBase@23@PAHHPAV?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 57 8B 7D 0C 8D 45 FC 50 8B CF E8 ?? ?? ?? ?? 8B F0 8B 45 FC 89 45 0C EB 61 80 7D 10 00 8B CE 74 3A 6A 00 E8 ?? ?? ?? ?? 8B D8 85 DB 74 38 C7 45 F0 04 00 00 00 8B 8F A0 00 00 00 8B 45 FC 40 99 F7 F9 89 75 F4 89 5D F8 8D 75 F0 B0 01 89 97 B4 00 00 00 8B 7D 08 A5 A5 A5 EB 25 E8 ?? ?? ?? ?? 8B D8 85 DB 75 21 8D 47 60 50 FF 75 0C 8D 45 FC 50 8B CF E8 ?? ?? ?? ?? 8B F0 85 F6 75 9B 32 C0 5F 5E 5B C9 C2 0C 00 C7 45 F0 10 00 00 00 EB A5 }
	condition:
		$1
}

rule file_185_120_0 {
	meta:
		name = "?ServiceMark@ScheduleGroupSegmentBase@details@Concurrency@@QAEXK@Z"
		size = 29
	strings:
		$1 = { 55 8B EC 8B 55 08 8B C2 2B 81 08 01 00 00 83 F8 64 76 06 89 91 08 01 00 00 5D C2 04 00 }
	condition:
		$1
}

rule file_185_121_0 {
	meta:
		name = "?ServiceMark@VirtualProcessor@details@Concurrency@@QAEXK@Z"
		size = 29
	strings:
		$1 = { 55 8B EC 8B 55 08 8B C2 2B 81 B8 00 00 00 83 F8 64 76 06 89 91 B8 00 00 00 5D C2 04 00 }
	condition:
		$1
}

rule file_185_122_0 {
	meta:
		name = "?SetDeletionReferences@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAEXI@Z"
		size = 38
		refs = "0016 ?StaticDelete@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@SAXPAU1234@@Z 001e ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QAEXP6AXPAX@Z0PAVSchedulerBase@23@@Z"
	strings:
		$1 = { 55 8B EC 8B 55 08 8D 41 14 F0 0F C1 10 03 55 08 75 10 FF 31 51 68 ?? ?? ?? ?? 83 C1 1C E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_185_123_0 {
	meta:
		name = "?SetPseudoRRAffineScheduleGroupSegmentNext@SchedulingRing@details@Concurrency@@QAEXH@Z"
		size = 25
	strings:
		$1 = { 55 8B EC 8B 45 08 40 56 8B 71 50 99 F7 FE 5E 89 91 B0 00 00 00 5D C2 04 00 }
	condition:
		$1
}

rule file_185_124_0 {
	meta:
		name = "?SetPseudoRRNonAffineScheduleGroupSegmentNext@SchedulingRing@details@Concurrency@@QAEXH@Z"
		size = 28
	strings:
		$1 = { 55 8B EC 8B 45 08 40 56 8B B1 A0 00 00 00 99 F7 FE 5E 89 91 B4 00 00 00 5D C2 04 00 }
	condition:
		$1
}

rule file_185_125_0 {
	meta:
		name = "?SkipSegmentSearch@WorkSearchContext@details@Concurrency@@AAE_NPAVScheduleGroupSegmentBase@23@0W4SearchAffinity@123@_N@Z"
		size = 136
		refs = "0038 ?_FastVPIntersects@location@Concurrency@@QBE_NABV12@@Z 004b ?Intersects@QuickBitSet@details@Concurrency@@QBE_NABV123@@Z"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 57 8B F9 3B 75 0C 75 04 B0 01 EB 6F 8B 45 10 53 33 DB 8D 56 0C 2B C3 74 56 48 74 35 48 75 59 F7 02 FF FF FF 0F 74 44 8B 0F 81 C1 88 00 00 00 52 E8 ?? ?? ?? ?? 84 C0 75 32 8B 4F 04 8D 46 1C 50 83 C1 3C E8 ?? ?? ?? ?? 84 C0 74 2C 38 5D 14 EB 18 F7 02 FF FF FF 0F 74 12 8B 0F 81 C1 88 00 00 00 52 E8 ?? ?? ?? ?? 84 C0 75 0D B3 01 EB 09 F7 02 FF FF FF 0F 0F 95 C3 8A C3 5B 5F 5E 5D C2 10 00 }
	condition:
		$1
}

rule file_185_128_0 {
	meta:
		name = "?Steal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@_N@Z"
		size = 64
		refs = "0003 __ehhandler$?Steal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@_N@Z 0008 __EH_prolog3 0017 ?_Acquire@_HyperNonReentrantLock@details@Concurrency@@QAEXXZ 0025 ?UnlockedSteal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@_N@Z 0032 ?_Release@_HyperNonReentrantLock@details@Concurrency@@QAEXXZ 0039 __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 8B 77 14 8B CE 89 75 F0 E8 ?? ?? ?? ?? FF 75 08 83 65 FC 00 8B CF E8 ?? ?? ?? ?? 83 4D FC FF 8B CE 8B F8 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C2 04 00 }
	condition:
		$1
}

rule file_185_131_0 {
	meta:
		name = "?StealForeignLocalRunnable@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingNode@23@@Z"
		size = 66
		refs = "001d ?StealLocalRunnable@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingNode@23@PAVVirtualProcessor@23@@Z 002f ?GetNextSchedulingNode@SchedulerBase@details@Concurrency@@QAEPAVSchedulingNode@23@PAHH@Z"
	strings:
		$1 = { 55 8B EC 51 83 65 FC 00 56 8B F1 6A FF EB 18 3B 45 0C 74 11 6A 00 50 FF 75 08 8B CE E8 ?? ?? ?? ?? 84 C0 75 19 6A 00 8B 4E 04 8D 45 FC 50 E8 ?? ?? ?? ?? 85 C0 75 D8 32 C0 5E C9 C2 08 00 B0 01 EB F7 }
	condition:
		$1
}

rule file_185_132_0 {
	meta:
		name = "?StealLocalRunnable@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingNode@23@PAVVirtualProcessor@23@@Z"
		size = 108
		refs = "001b ?FindVirtualProcessor@SchedulingNode@details@Concurrency@@QAEPAVVirtualProcessor@23@HHPAH@Z 002c ?ServiceMark@VirtualProcessor@details@Concurrency@@QAEXK@Z 0033 ?StealLocalRunnableContext@VirtualProcessor@details@Concurrency@@AAEPAVInternalContextBase@23@XZ 0044 ?GetNextVirtualProcessor@SchedulingNode@details@Concurrency@@QAEPAVVirtualProcessor@23@PAHH@Z 005c ??0WorkItem@details@Concurrency@@QAE@PAVInternalContextBase@12@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 53 56 57 8B 7D 0C 8B D9 8B 47 78 8D 4D 0C 51 50 6A 00 8B CF E8 ?? ?? ?? ?? EB 27 3B 75 10 74 15 FF 73 10 8B CE E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 85 C0 75 1C 6A 00 8D 45 0C 50 8B CF E8 ?? ?? ?? ?? 8B F0 85 F6 75 D3 32 C0 5F 5E 5B C9 C2 0C 00 50 8D 4D F4 E8 ?? ?? ?? ?? 8B 7D 08 8B F0 A5 A5 A5 B0 01 EB E4 }
	condition:
		$1
}

rule file_185_133_0 {
	meta:
		name = "?StealLocalRunnableContext@VirtualProcessor@details@Concurrency@@AAEPAVInternalContextBase@23@XZ"
		size = 23
		refs = "000e ?Steal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@_N@Z"
	strings:
		$1 = { 8B 41 10 83 C1 0C 33 D2 3B 01 7E 08 52 E8 ?? ?? ?? ?? 8B D0 8B C2 C3 }
	condition:
		$1
}

rule file_185_134_0 {
	meta:
		name = "?TimeSinceServicing@ScheduleGroupSegmentBase@details@Concurrency@@QAEKK@Z"
		size = 16
	strings:
		$1 = { 55 8B EC 8B 45 08 2B 81 08 01 00 00 5D C2 04 00 }
	condition:
		$1
}

rule file_185_135_0 {
	meta:
		name = "?TimeSinceServicing@VirtualProcessor@details@Concurrency@@QAEKK@Z"
		size = 16
	strings:
		$1 = { 55 8B EC 8B 45 08 2B 81 B8 00 00 00 5D C2 04 00 }
	condition:
		$1
}

rule file_185_136_0 {
	meta:
		name = "?TransferReferences@WorkItem@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z"
		size = 85
		refs = "000e ?GetScheduleGroupSegment@ContextBase@details@Concurrency@@QBEPAVScheduleGroupSegmentBase@23@XZ 002e ?InternalRelease@ScheduleGroupBase@details@Concurrency@@IAEJXZ 004b ?SwapScheduleGroupSegment@InternalContextBase@details@Concurrency@@QAEXPAVScheduleGroupSegmentBase@23@_N@Z"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 57 8B F9 8D 4E 04 E8 ?? ?? ?? ?? 83 3F 02 75 1D 8B 57 04 8B 88 00 01 00 00 3B 8A 00 01 00 00 74 05 6A 00 52 EB 1B E8 ?? ?? ?? ?? EB 1B 8B 4F 04 8B 80 00 01 00 00 3B 81 00 01 00 00 74 0A 6A 01 51 8B CE E8 ?? ?? ?? ?? 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_185_137_0 {
	meta:
		name = "?UnlockedSteal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@_N@Z"
		size = 126
		refs = "0027 ?DeferToAffineSearchers@Slot@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QBE_NXZ 0054 ?Claim@Slot@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAE_NPAPAVInternalContextBase@34@@Z"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F1 EB 57 8B 3E 8B 4E 08 8B 46 0C 23 CF F6 04 88 01 74 15 80 7D 08 00 75 0F 8B 46 10 8D 0C C8 E8 ?? ?? ?? ?? 84 C0 75 39 8B 46 0C 8B CF 23 4E 08 33 DB 8D 04 88 87 18 F6 C3 01 74 2E 8B 46 10 8B CF 23 4E 08 6A 00 83 E3 FE 8D 0C C8 E8 ?? ?? ?? ?? 84 C0 75 15 8D 47 01 89 06 8B 06 3B 46 04 7C A2 33 C0 5F 5E 5B 5D C2 04 00 85 DB 74 05 8D 4F 01 89 0E 8B C3 EB EC }
	condition:
		$1
}

rule file_251_52_0 {
	meta:
		name = "?UnlockedSteal@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEPAV_UnrealizedChore@23@_N@Z"
		size = 126
		refs = "0027 ?DeferToAffineSearchers@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QBE_NXZ 0054 ?Claim@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE_NPAPAV_UnrealizedChore@34@@Z"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F1 EB 57 8B 3E 8B 4E 08 8B 46 0C 23 CF F6 04 88 01 74 15 80 7D 08 00 75 0F 8B 46 10 8D 0C C8 E8 ?? ?? ?? ?? 84 C0 75 39 8B 46 0C 8B CF 23 4E 08 33 DB 8D 04 88 87 18 F6 C3 01 74 2E 8B 46 10 8B CF 23 4E 08 6A 00 83 E3 FE 8D 0C C8 E8 ?? ?? ?? ?? 84 C0 75 15 8D 47 01 89 06 8B 06 3B 46 04 7C A2 33 C0 5F 5E 5B 5D C2 04 00 85 DB 74 05 8D 4F 01 89 0E 8B C3 EB EC }
	condition:
		$1
}

rule file_187_0_0 {
	meta:
		name = "___wcserror"
		size = 222
		refs = "0005 __getptd_noexit 0025 __calloc_crt 0053 _wcsncat_s 005f ??_C@_15ELOONFKJ@?$AA?3?$AA?5?$AA?$AA@ 0066 _wcscat_s 0072 __errno 0079 __get_sys_err_msg 0081 _wcslen 00ae _mbstowcs_s 00ba ??_C@_13LBAGMAIH@?$AA?6?$AA?$AA@ 00d9 __invoke_watson"
	strings:
		$1 = { 55 8B EC 57 E8 ?? ?? ?? ?? 8B F8 85 FF 0F 84 BD 00 00 00 53 33 DB 56 BE 86 00 00 00 39 5F 28 75 15 6A 02 56 E8 ?? ?? ?? ?? 59 59 89 47 28 85 C0 0F 84 98 00 00 00 8B 7F 28 33 C0 66 89 07 8B 45 08 85 C0 74 2C 66 39 18 74 27 68 82 00 00 00 50 56 57 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 75 68 ?? ?? ?? ?? 56 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 62 E8 ?? ?? ?? ?? FF 30 E8 ?? ?? ?? ?? 57 8B F0 E8 ?? ?? ?? ?? 59 59 B9 84 00 00 00 2B C8 51 56 57 E8 ?? ?? ?? ?? 59 BE 86 00 00 00 8B CE 2B C8 51 57 E8 ?? ?? ?? ?? 59 8D 04 47 50 53 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 1A 68 ?? ?? ?? ?? 56 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 07 8B C7 5E 5B 5F 5D C3 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_187_1_0 {
	meta:
		name = "___wcserror_s"
		size = 180
		refs = "000c __errno 0016 __invalid_parameter_noinfo 0050 _wcslen 0060 _wcscpy_s 006c ??_C@_15ELOONFKJ@?$AA?3?$AA?5?$AA?$AA@ 0073 _wcscat_s 009b __wcserror_s 00af __invoke_watson"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 85 F6 75 16 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 E9 83 00 00 00 57 8B 7D 0C 85 FF 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 67 53 8B 5D 10 33 C0 66 89 06 85 DB 74 35 66 39 03 74 30 53 E8 ?? ?? ?? ?? 59 8D 4F F9 3B C1 73 22 53 57 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 3C 68 ?? ?? ?? ?? 57 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 29 E8 ?? ?? ?? ?? FF 30 56 E8 ?? ?? ?? ?? 59 2B F8 57 56 E8 ?? ?? ?? ?? 59 8D 04 46 50 E8 ?? ?? ?? ?? 83 C4 0C 5B 5F 5E 5D C3 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_188_0_0 {
	meta:
		name = "_memcpy"
		size = 1604
		refs = "0023 ___favor 004b ___isa_enabled 0205 TrailUpVec 023c LeadUpVec 024b UnwindUpVec 0250 LeadUp1 0254 LeadUp2 0258 LeadUp3 02cc UnwindUp0 02d0 UnwindUp1 02d4 UnwindUp2 02d8 UnwindUp3 02dc UnwindUp4 02e0 UnwindUp5 02e4 UnwindUp6 02e8 UnwindUp7 0338 TrailUp0 033c TrailUp1 0340 TrailUp2 0344 TrailUp3 03aa TrailDownVec 03b5 UnwindDownVec 03d0 LeadDownVec 03dc LeadDown1 03e0 LeadDown2 03e4 LeadDown3 0468 UnwindDown7 046c UnwindDown6 0470 UnwindDown5 0474 UnwindDown4 0478 UnwindDown3 047c UnwindDown2 0480 UnwindDown1 0484 UnwindDown0 04d4 TrailDown0 04d8 TrailDown1 04dc TrailDown2 04e0 TrailDown3"
		altNames = "_memmove"
	strings:
		$1 = { 57 56 8B 74 24 10 8B 4C 24 14 8B 7C 24 0C 8B C1 8B D1 03 C6 3B FE 76 08 3B F8 0F 82 68 03 00 00 0F BA 25 ?? ?? ?? ?? 01 73 07 F3 A4 E9 17 03 00 00 81 F9 80 00 00 00 0F 82 CE 01 00 00 8B C7 33 C6 A9 0F 00 00 00 75 0E 0F BA 25 ?? ?? ?? ?? 01 0F 82 DA 04 00 00 0F BA 25 ?? ?? ?? ?? 00 0F 83 A7 01 00 00 F7 C7 03 00 00 00 0F 85 B8 01 00 00 F7 C6 03 00 00 00 0F 85 97 01 00 00 0F BA E7 02 73 0D 8B 06 83 E9 04 8D 76 04 89 07 8D 7F 04 0F BA E7 03 73 11 F3 0F 7E 0E 83 E9 08 8D 76 08 66 0F D6 0F 8D 7F 08 F7 C6 07 00 00 00 74 63 0F BA E6 03 0F 83 B2 00 00 00 66 0F 6F 4E F4 8D 76 F4 66 0F 6F 5E 10 83 E9 30 66 0F 6F 46 20 66 0F 6F 6E 30 8D 76 30 83 F9 30 66 0F 6F D3 66 0F 3A 0F D9 0C 66 0F 7F 1F 66 0F 6F E0 66 0F 3A 0F C2 0C 66 0F 7F 47 10 66 0F 6F CD 66 0F 3A 0F EC 0C 66 0F 7F 6F 20 8D 7F 30 7D B7 8D 76 0C E9 AF 00 00 00 66 0F 6F 4E F8 8D 76 F8 8D 49 00 66 0F 6F 5E 10 83 E9 30 66 0F 6F 46 20 66 0F 6F 6E 30 8D 76 30 83 F9 30 66 0F 6F D3 66 0F 3A 0F D9 08 66 0F 7F 1F 66 0F 6F E0 66 0F 3A 0F C2 08 66 0F 7F 47 10 66 0F 6F CD 66 0F 3A 0F EC 08 66 0F 7F 6F 20 8D 7F 30 7D B7 8D 76 08 EB 56 66 0F 6F 4E FC 8D 76 FC 8B FF 66 0F 6F 5E 10 83 E9 30 66 0F 6F 46 20 66 0F 6F 6E 30 8D 76 30 83 F9 30 66 0F 6F D3 66 0F 3A 0F D9 04 66 0F 7F 1F 66 0F 6F E0 66 0F 3A 0F C2 04 66 0F 7F 47 10 66 0F 6F CD 66 0F 3A 0F EC 04 66 0F 7F 6F 20 8D 7F 30 7D B7 8D 76 04 83 F9 10 7C 13 F3 0F 6F 0E 83 E9 10 8D 76 10 66 0F 7F 0F 8D 7F 10 EB E8 0F BA E1 02 73 0D 8B 06 83 E9 04 8D 76 04 89 07 8D 7F 04 0F BA E1 03 73 11 F3 0F 7E 0E 83 E9 08 8D 76 08 66 0F D6 0F 8D 7F 08 8B 04 8D ?? ?? ?? ?? FF E0 F7 C7 03 00 00 00 75 15 C1 E9 02 83 E2 03 83 F9 08 72 2A F3 A5 FF 24 95 ?? ?? ?? ?? 90 8B C7 BA 03 00 00 00 83 E9 04 72 0C 83 E0 03 03 C8 FF 24 85 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 90 FF 24 8D ?? ?? ?? ?? 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 23 D1 8A 06 88 07 8A 46 01 88 47 01 8A 46 02 C1 E9 02 88 47 02 83 C6 03 83 C7 03 83 F9 08 72 CC F3 A5 FF 24 95 ?? ?? ?? ?? 8D 49 00 23 D1 8A 06 88 07 8A 46 01 C1 E9 02 88 47 01 83 C6 02 83 C7 02 83 F9 08 72 A6 F3 A5 FF 24 95 ?? ?? ?? ?? 90 23 D1 8A 06 88 07 83 C6 01 C1 E9 02 83 C7 01 83 F9 08 72 88 F3 A5 FF 24 95 ?? ?? ?? ?? 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 44 8E E4 89 44 8F E4 8B 44 8E E8 89 44 8F E8 8B 44 8E EC 89 44 8F EC 8B 44 8E F0 89 44 8F F0 8B 44 8E F4 89 44 8F F4 8B 44 8E F8 89 44 8F F8 8B 44 8E FC 89 44 8F FC 8D 04 8D 00 00 00 00 03 F0 03 F8 FF 24 95 ?? ?? ?? ?? 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 44 24 0C 5E 5F C3 90 8A 06 88 07 8B 44 24 0C 5E 5F C3 90 8A 06 88 07 8A 46 01 88 47 01 8B 44 24 0C 5E 5F C3 8D 49 00 8A 06 88 07 8A 46 01 88 47 01 8A 46 02 88 47 02 8B 44 24 0C 5E 5F C3 90 8D 74 31 FC 8D 7C 39 FC F7 C7 03 00 00 00 75 24 C1 E9 02 83 E2 03 83 F9 08 72 0D FD F3 A5 FC FF 24 95 ?? ?? ?? ?? 8B FF F7 D9 FF 24 8D ?? ?? ?? ?? 8D 49 00 8B C7 BA 03 00 00 00 83 F9 04 72 0C 83 E0 03 2B C8 FF 24 85 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8A 46 03 23 D1 88 47 03 83 EE 01 C1 E9 02 83 EF 01 83 F9 08 72 B2 FD F3 A5 FC FF 24 95 ?? ?? ?? ?? 8D 49 00 8A 46 03 23 D1 88 47 03 8A 46 02 C1 E9 02 88 47 02 83 EE 02 83 EF 02 83 F9 08 72 88 FD F3 A5 FC FF 24 95 ?? ?? ?? ?? 90 8A 46 03 23 D1 88 47 03 8A 46 02 88 47 02 8A 46 01 C1 E9 02 88 47 01 83 EE 03 83 EF 03 83 F9 08 0F 82 56 FF FF FF FD F3 A5 FC FF 24 95 ?? ?? ?? ?? 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 44 8E 1C 89 44 8F 1C 8B 44 8E 18 89 44 8F 18 8B 44 8E 14 89 44 8F 14 8B 44 8E 10 89 44 8F 10 8B 44 8E 0C 89 44 8F 0C 8B 44 8E 08 89 44 8F 08 8B 44 8E 04 89 44 8F 04 8D 04 8D 00 00 00 00 03 F0 03 F8 FF 24 95 ?? ?? ?? ?? 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 44 24 0C 5E 5F C3 90 8A 46 03 88 47 03 8B 44 24 0C 5E 5F C3 8D 49 00 8A 46 03 88 47 03 8A 46 02 88 47 02 8B 44 24 0C 5E 5F C3 90 8A 46 03 88 47 03 8A 46 02 88 47 02 8A 46 01 88 47 01 8B 44 24 0C 5E 5F C3 8D A4 24 00 00 00 00 57 8B C6 83 E0 0F 85 C0 0F 85 D2 00 00 00 8B D1 83 E1 7F C1 EA 07 74 65 8D A4 24 00 00 00 00 90 66 0F 6F 06 66 0F 6F 4E 10 66 0F 6F 56 20 66 0F 6F 5E 30 66 0F 7F 07 66 0F 7F 4F 10 66 0F 7F 57 20 66 0F 7F 5F 30 66 0F 6F 66 40 66 0F 6F 6E 50 66 0F 6F 76 60 66 0F 6F 7E 70 66 0F 7F 67 40 66 0F 7F 6F 50 66 0F 7F 77 60 66 0F 7F 7F 70 8D B6 80 00 00 00 8D BF 80 00 00 00 4A 75 A3 85 C9 74 4F 8B D1 C1 EA 04 85 D2 74 17 8D 9B 00 00 00 00 66 0F 6F 06 66 0F 7F 07 8D 76 10 8D 7F 10 4A 75 EF 83 E1 0F 74 2A 8B C1 C1 E9 02 74 0D 8B 16 89 17 8D 76 04 8D 7F 04 49 75 F3 8B C8 83 E1 03 74 0F 8A 06 88 07 46 47 49 75 F7 8D 9B 00 00 00 00 58 5E 5F C3 8D A4 24 00 00 00 00 EB 03 CC CC CC BA 10 00 00 00 2B D0 2B CA 51 8B C2 8B C8 83 E1 03 74 09 8A 16 88 17 46 47 49 75 F7 C1 E8 02 74 0D 8B 16 89 17 8D 76 04 8D 7F 04 48 75 F3 59 E9 FA FE FF FF }
	condition:
		$1
}

rule file_189_0_0 {
	meta:
		name = "___avx_tan4"
		size = 2752
		refs = "0012 ___common_dtan_data 0176 ___common_dtan_cout_rare 01f6 ___common_dtan_reduction_data 0287 _2il0floatpacket_343 028f _2il0floatpacket_344 029f _2il0floatpacket_345 061b _2il0floatpacket_346 0658 _2il0floatpacket_349 0667 _2il0floatpacket_347 069d _2il0floatpacket_350 06d9 _2il0floatpacket_351 06e9 _2il0floatpacket_352 0744 _2il0floatpacket_356 0755 _2il0floatpacket_353 075e _2il0floatpacket_354 0767 _2il0floatpacket_355 07a1 _2il0floatpacket_357 07ae _2il0floatpacket_358 07c0 _2il0floatpacket_359 07dc _2il0floatpacket_348"
	strings:
		$1 = { 55 8B EC 83 E4 C0 56 57 81 EC 38 03 00 00 C5 FD 10 0D ?? ?? ?? ?? C5 FD 54 E1 C5 DD C2 1D ?? ?? ?? ?? 1E C5 F5 55 C8 C4 E3 7D 19 DD 01 C5 E0 C6 F5 DD C5 F8 50 C6 85 C0 0F 85 41 01 00 00 C5 DD 59 1D ?? ?? ?? ?? 33 F6 C5 FD 10 2D ?? ?? ?? ?? C5 E5 58 F5 C5 CD 5C DD C5 E5 59 2D ?? ?? ?? ?? C5 DD 5C E5 C5 E5 59 2D ?? ?? ?? ?? C5 DD 5C E5 C5 E5 59 2D ?? ?? ?? ?? C5 DD 5C FD C5 E5 59 25 ?? ?? ?? ?? C5 C5 59 D7 C5 C5 5C DC C5 D9 73 F6 3F C4 E3 7D 19 F5 01 C5 C1 73 F5 3F C5 D1 73 F5 3E C4 E3 5D 18 E7 01 C5 DD 57 E1 C5 F1 73 F6 3E C5 C5 57 FF C4 E3 75 18 F5 01 C5 ED 59 2D ?? ?? ?? ?? C5 CD C2 CF 0C C5 ED 59 35 ?? ?? ?? ?? C5 D5 58 2D ?? ?? ?? ?? C5 CD 58 3D ?? ?? ?? ?? C5 D5 59 F2 C5 C5 59 FA C5 CD 58 35 ?? ?? ?? ?? C5 C5 58 2D ?? ?? ?? ?? C5 CD 59 F2 C5 D5 59 EA C5 CD 58 3D ?? ?? ?? ?? C5 D5 58 35 ?? ?? ?? ?? C5 C5 59 FB C5 F5 55 DF C5 F5 54 EE C5 E5 56 ED C5 F5 54 DF C5 F5 55 CE C5 E5 56 C9 C5 D5 5E C9 C5 F5 57 CC 85 F6 75 10 C5 FD 28 C1 81 C4 38 03 00 00 5F 5E 8B E5 5D C3 C5 FD 11 04 24 C5 FD 11 4C 24 40 74 E3 33 FF 0F A3 FE 72 0E 47 83 FF 20 7C F5 C5 FD 10 4C 24 40 EB CE C5 F8 77 8D 44 FC 40 8D 14 FC 50 52 E8 ?? ?? ?? ?? 83 C4 08 EB DC C5 FD 10 35 ?? ?? ?? ?? B8 00 00 F0 7F C5 FD 11 04 24 C5 CD 54 CC C5 F5 C2 E6 00 C5 F9 6E C8 C5 F9 70 C9 11 C4 E3 7D 19 C5 01 C5 F8 11 AC 24 50 01 00 00 C5 F8 28 D0 C5 F1 DB DA C4 E3 7D 19 E6 01 C5 F1 DB CD C5 D8 C6 FE DD C5 E1 73 D3 34 C5 D9 73 D1 34 C5 F9 7E DF C5 F9 7E E0 C5 F8 50 F7 C5 F8 11 94 24 40 01 00 00 C4 E3 79 16 D9 02 8D 14 7F C5 FA 7E 0C D5 ?? ?? ?? ?? 8D 3C 40 C4 E3 79 16 E0 02 C5 FA 7E 24 FD ?? ?? ?? ?? C5 FA 7E 1C D5 ?? ?? ?? ?? 8D 0C 49 C5 F1 16 3C CD ?? ?? ?? ?? C5 FA 7E 0C FD ?? ?? ?? ?? 8D 04 40 C5 F1 16 34 C5 ?? ?? ?? ?? C5 FA 7E 0C D5 ?? ?? ?? ?? BA 00 00 00 80 C5 F1 16 04 CD ?? ?? ?? ?? C5 D9 16 0C C5 ?? ?? ?? ?? C5 E1 16 24 CD ?? ?? ?? ?? C5 FA 7E 1C FD ?? ?? ?? ?? C5 F9 11 A4 24 80 01 00 00 C5 E1 16 24 C5 ?? ?? ?? ?? C5 F9 11 A4 24 90 01 00 00 C5 FA 6F 25 ?? ?? ?? ?? C5 FA 6F 1D ?? ?? ?? ?? C5 D9 DB D2 C5 D9 DB ED C5 FA 6F 25 ?? ?? ?? ?? C5 F9 11 BC 24 60 01 00 00 C5 E9 D4 D3 C5 D1 D4 DB C5 C1 DB EC C5 C1 73 D0 20 C5 FA 7F BC 24 C0 01 00 00 C5 C1 73 D1 20 C5 F1 DB CC C5 F9 DB C4 C5 FA 7F 8C 24 F0 01 00 00 C5 F9 10 8C 24 80 01 00 00 C5 F1 73 D1 20 C5 FA 7F 8C 24 00 02 00 00 C5 F9 10 8C 24 90 01 00 00 C5 F1 73 D1 20 C5 FA 7F 8C 24 10 02 00 00 C5 F1 73 D2 20 C5 F9 11 B4 24 70 01 00 00 C5 C9 DB F4 C5 FA 7F 8C 24 20 02 00 00 C5 F1 73 D3 20 C5 E1 DB DC C5 E9 DB D4 C5 FA 7F B4 24 B0 01 00 00 C5 E1 F4 F6 C5 FA 7F B4 24 60 02 00 00 C5 E9 F4 B4 24 C0 01 00 00 C5 FA 7F AC 24 A0 01 00 00 C5 E9 F4 ED C5 FA 7F BC 24 D0 01 00 00 C5 E1 F4 FF C5 FA 7F 84 24 E0 01 00 00 C5 FA 7F B4 24 70 02 00 00 C5 FA 7F AC 24 50 02 00 00 C5 E9 F4 E8 C5 D9 DB B4 24 80 01 00 00 C5 FA 6F 84 24 20 02 00 00 C5 FA 7F BC 24 80 02 00 00 C5 F9 F4 FE C5 C9 73 D7 20 C5 FA 6F BC 24 00 02 00 00 C5 FA 7F 94 24 30 02 00 00 C5 E9 F4 D7 C5 F9 F4 C7 C5 E9 73 D2 20 C5 F9 D4 C2 C5 FA 7F AC 24 90 02 00 00 C5 D1 DB EC C5 D1 D4 D0 C5 FA 7F 9C 24 40 02 00 00 C5 E1 F4 9C 24 F0 01 00 00 C5 C9 D4 FA C5 D9 DB B4 24 90 01 00 00 C5 F1 F4 C6 C5 E1 DB F4 C5 FA 7F 9C 24 A0 02 00 00 C5 E9 73 D0 20 C5 FA 6F 9C 24 10 02 00 00 C5 E1 F4 AC 24 40 02 00 00 C5 F1 F4 C3 C5 E1 73 D5 20 C5 F9 D4 C3 C5 C9 D4 F0 C5 FA 6F 84 24 20 02 00 00 C5 E1 73 D7 20 C5 FA 7F BC 24 B0 02 00 00 C5 F9 F4 BC 24 E0 01 00 00 C5 E9 D4 D6 C5 FA 6F B4 24 90 02 00 00 C5 C9 73 D6 20 C5 C1 D4 FE C5 D9 DB AC 24 70 02 00 00 C5 D1 D4 EF C5 E1 D4 FD C5 F1 F4 9C 24 F0 01 00 00 C5 FA 6F AC 24 A0 02 00 00 C5 D1 73 D5 20 C5 E1 D4 DD C5 D9 DB B4 24 80 02 00 00 C5 C9 D4 F3 C5 FA 7F 94 24 C0 02 00 00 C5 E9 73 D2 20 C5 E9 D4 EE C5 F9 F4 B4 24 C0 01 00 00 C5 FA 6F 9C 24 70 02 00 00 C5 E1 73 D3 20 C5 C9 D4 F3 C5 D9 DB 94 24 50 02 00 00 C5 E9 D4 D6 C5 FA 7F BC 24 D0 02 00 00 C5 C1 73 D7 20 C5 C1 D4 F2 C5 F1 F4 94 24 D0 01 00 00 C5 FA 6F 9C 24 80 02 00 00 C5 E1 73 D3 20 C5 E9 D4 D3 C5 D9 DB BC 24 60 02 00 00 C5 E1 73 D6 20 C5 C1 D4 FA C5 FA 7F AC 24 E0 02 00 00 C5 D1 73 D5 20 C5 D1 D4 D7 C5 F9 10 BC 24 60 01 00 00 C5 C9 DB F4 C5 D1 73 D7 20 C5 D1 F4 BC 24 30 02 00 00 C5 C1 DB EC C5 F9 F4 BC 24 A0 01 00 00 C5 FA 6F 84 24 50 02 00 00 C5 F9 73 D0 20 C5 C1 D4 F8 C5 D1 D4 EF C5 E1 D4 DD C5 F9 10 84 24 70 01 00 00 C5 C1 73 F3 20 C5 D1 73 D0 20 C5 C1 D4 DE C5 D1 F4 BC 24 40 02 00 00 C5 C1 DB EC C5 C9 73 D2 20 C5 F1 F4 BC 24 B0 01 00 00 C5 E9 DB D4 C5 FA 6F 8C 24 60 02 00 00 C5 F1 73 D1 20 C5 C1 D4 C1 C5 D1 D4 E8 C5 C9 D4 F5 C5 C9 73 F6 20 C5 FA 6F 84 24 E0 02 00 00 C5 C9 D4 CA C5 FA 6F B4 24 D0 02 00 00 C5 D9 DB BC 24 B0 02 00 00 C5 E9 73 F6 20 C5 D9 DB A4 24 C0 02 00 00 C5 C9 73 F0 20 C5 E9 D4 EF C5 C9 D4 FC C5 F9 6E F2 C5 F9 70 D6 11 C5 E9 DB A4 24 40 01 00 00 C5 FA 6F 05 ?? ?? ?? ?? C5 E9 DB B4 24 50 01 00 00 C5 D9 EF D0 C5 FA 7F 9C 24 F0 02 00 00 C5 E1 73 D3 0C C5 FA 7F 8C 24 00 03 00 00 C5 F1 73 D1 0C C5 C9 EF C0 C5 E1 EB D2 C5 F1 EB D8 C5 FA 6F 05 ?? ?? ?? ?? C4 E3 6D 18 CB 01 C4 E2 7D 1A 15 ?? ?? ?? ?? C5 ED 58 D9 C5 E5 5C D2 C5 F5 5C CA C5 FD 11 4C 24 20 C5 C9 EF C8 C5 F8 11 9C 24 10 03 00 00 C4 E3 7D 19 9C 24 20 03 00 00 01 C5 D9 EF D8 C5 FA 6F 05 ?? ?? ?? ?? C5 F9 DB D5 C5 F9 DB C7 C5 E9 73 F2 1C C5 F9 73 F0 1C C5 E9 EB D3 C5 F9 EB C1 C5 D1 73 D5 18 C5 C1 73 D7 18 C4 E3 6D 18 D0 01 C4 E3 65 18 C9 01 C5 ED 5C D1 C5 FA 6F 0D ?? ?? ?? ?? C5 D9 EF C1 C5 C9 EF C9 C5 FA 6F 35 ?? ?? ?? ?? C5 C9 DB A4 24 F0 02 00 00 C5 C9 DB B4 24 00 03 00 00 C5 D9 73 F4 28 C5 C9 73 F6 28 C5 D9 EB E5 C5 C9 EB F7 C5 D9 EB E0 C5 C9 EB F9 C5 FD 10 6C 24 20 C4 E3 5D 18 E7 01 C4 E3 7D 18 C9 01 C5 DD 5C D9 C5 D5 58 C3 C5 D5 5C F0 C5 E5 58 FE C5 C5 58 F2 C4 E2 7D 1A 15 ?? ?? ?? ?? C5 FD 54 FA C5 FD 5C C7 C4 E2 7D 1A 2D ?? ?? ?? ?? C4 E2 7D 1A 1D ?? ?? ?? ?? C4 E2 7D 1A 25 ?? ?? ?? ?? C5 E5 59 D7 C5 E5 59 C8 C5 DD 59 DF C5 D5 59 EE C5 DD 59 C0 C5 F5 58 CB C5 D5 58 E0 C5 FD 10 2C 24 C5 F5 58 DC C5 ED 58 CB C5 ED 5C F1 C5 CD 58 FB C4 E2 7D 1A 15 ?? ?? ?? ?? C5 D5 54 F2 C4 E2 7D 1A 05 ?? ?? ?? ?? C5 CD C2 D0 1E C5 CD C2 E0 12 C5 FA 6F 05 ?? ?? ?? ?? C5 DD 54 DD C5 ED 54 C9 C5 E5 56 F1 C5 ED 54 FF C5 CD 58 D7 C5 FA 6F 3D ?? ?? ?? ?? C5 C1 DB B4 24 10 03 00 00 C5 C1 DB 8C 24 20 03 00 00 C5 C9 DB E0 C5 F1 DB F0 C5 F9 7E E7 C5 F9 7E F0 6B CF 68 6B C0 68 C5 FA 7E A9 ?? ?? ?? ?? C4 E3 79 16 E2 02 C4 E3 79 16 F7 02 6B D2 68 6B FF 68 C5 FA 7E B8 ?? ?? ?? ?? C5 FA 7E 81 ?? ?? ?? ?? C5 D1 16 9A ?? ?? ?? ?? C5 C1 16 8F ?? ?? ?? ?? C5 FA 7E A8 ?? ?? ?? ?? C5 D1 16 BF ?? ?? ?? ?? C5 FA 7E A8 ?? ?? ?? ?? C5 F9 16 A2 ?? ?? ?? ?? C4 E3 65 18 F1 01 C5 FA 7E 89 ?? ?? ?? ?? C5 F1 16 82 ?? ?? ?? ?? C5 D1 16 9F ?? ?? ?? ?? C5 FA 7E 89 ?? ?? ?? ?? C5 FA 7E A8 ?? ?? ?? ?? C4 E3 5D 18 E7 01 C4 E3 7D 18 FB 01 C5 FC 11 7C 24 40 C5 F1 16 82 ?? ?? ?? ?? C5 D1 16 9F ?? ?? ?? ?? C5 FA 7E B9 ?? ?? ?? ?? C5 FA 7E A8 ?? ?? ?? ?? C5 C1 16 8A ?? ?? ?? ?? C4 E3 7D 18 C3 01 C5 D1 16 9F ?? ?? ?? ?? C5 FD 59 C2 C4 E3 75 18 FB 01 C5 FA 7E 89 ?? ?? ?? ?? C5 FA 7E 98 ?? ?? ?? ?? C5 FC 11 7C 24 60 C5 F1 16 AA ?? ?? ?? ?? C5 E1 16 BF ?? ?? ?? ?? C5 FA 7E 99 ?? ?? ?? ?? C4 E3 55 18 CF 01 C5 FC 11 8C 24 80 00 00 00 C5 FA 7E 88 ?? ?? ?? ?? C5 E1 16 BA ?? ?? ?? ?? C5 F1 16 AF ?? ?? ?? ?? C4 E3 45 18 DD 01 C5 FA 7E B9 ?? ?? ?? ?? C5 FA 7E A8 ?? ?? ?? ?? C5 FC 11 9C 24 A0 00 00 00 C5 C1 16 8A ?? ?? ?? ?? C5 D1 16 9F ?? ?? ?? ?? C4 E3 75 18 FB 01 C5 FA 7E 89 ?? ?? ?? ?? C5 FA 7E 98 ?? ?? ?? ?? C5 FC 11 BC 24 C0 00 00 00 C5 F1 16 AA ?? ?? ?? ?? C5 E1 16 BF ?? ?? ?? ?? C5 FA 7E 99 ?? ?? ?? ?? C4 E3 55 18 CF 01 C5 FC 11 8C 24 E0 00 00 00 C5 FA 7E 88 ?? ?? ?? ?? C5 E1 16 BA ?? ?? ?? ?? C5 F1 16 AF ?? ?? ?? ?? C4 E3 45 18 DD 01 C5 FA 7E B9 ?? ?? ?? ?? C5 FA 7E A8 ?? ?? ?? ?? C5 FC 11 9C 24 00 01 00 00 C5 C1 16 8A ?? ?? ?? ?? C5 D1 16 9F ?? ?? ?? ?? C4 E3 75 18 FB 01 C5 FC 11 BC 24 20 01 00 00 C5 CD 5C FA C5 FD 5A F7 C5 F8 53 F6 C5 FC 5A EE C5 C5 59 CD C4 E2 7D 1A 1D ?? ?? ?? ?? C5 E5 5C F1 C5 D5 59 FE C5 CD 59 CE C5 E5 58 F6 C5 E5 58 C9 C5 C5 59 DE C5 E5 59 F1 C5 ED 59 8C 24 80 00 00 00 C5 D5 58 EE C5 F5 58 4C 24 60 C5 D5 59 F4 C5 ED 59 EA C5 FD 58 64 24 40 C5 ED 59 84 24 00 01 00 00 C5 D5 59 FD C5 DD 58 F6 C5 FD 58 84 24 E0 00 00 00 C5 ED 59 A4 24 C0 00 00 00 C5 DD 58 9C 24 A0 00 00 00 C5 D5 59 A4 24 20 01 00 00 C5 D5 59 DB C5 FD 58 C4 C5 F5 58 EB C5 C5 59 F8 C5 D5 58 C7 C5 FD 59 D2 C5 FD 10 04 24 C5 CD 58 CA E9 7C F6 FF FF 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_192_0_0 {
	meta:
		name = "__errcode"
		size = 50
	strings:
		$1 = { 55 8B EC 8B 45 08 A8 20 74 04 6A 05 EB 17 A8 08 74 05 33 C0 40 5D C3 A8 04 74 04 6A 02 EB 06 A8 01 74 05 6A 03 58 5D C3 0F B6 C0 83 E0 02 03 C0 5D C3 }
	condition:
		$1
}

rule file_192_1_0 {
	meta:
		name = "__except1"
		size = 200
		refs = "001c ___security_cookie 0032 __handle_exc 0059 __raise_exc_ex 0067 __errcode 006d __matherr_flag 0095 __umatherr 00a0 __set_errno_from_matherr 00ad __ctrlfp 00bd @__security_check_cookie@4"
	strings:
		$1 = { 53 8B DC 51 51 83 E4 F0 83 C4 04 55 8B 6B 04 89 6C 24 04 8B EC 81 EC 8C 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 8B 73 20 56 8D 43 18 50 FF 73 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 26 83 65 C0 FE 50 8D 43 18 50 8D 43 10 50 FF 73 0C 8D 43 20 FF 73 08 50 8D 45 80 50 E8 ?? ?? ?? ?? 8B 73 20 83 C4 1C FF 73 08 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 59 75 29 85 C0 74 25 DD 43 18 56 83 EC 18 DD 5C 24 10 D9 EE DD 5C 24 08 DD 43 10 DD 1C 24 FF 73 0C 50 E8 ?? ?? ?? ?? 83 C4 24 EB 18 50 E8 ?? ?? ?? ?? C7 04 24 FF FF 00 00 56 E8 ?? ?? ?? ?? DD 43 18 59 59 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D 8B E3 5B C3 }
	condition:
		$1
}

rule file_192_2_0 {
	meta:
		name = "__except2"
		size = 220
		refs = "001c ___security_cookie 0032 __handle_exc 0068 __raise_exc_ex 007a __errcode 0080 __matherr_flag 00a9 __umatherr 00b4 __set_errno_from_matherr 00c1 __ctrlfp 00d1 @__security_check_cookie@4"
	strings:
		$1 = { 53 8B DC 51 51 83 E4 F0 83 C4 04 55 8B 6B 04 89 6C 24 04 8B EC 81 EC 8C 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 8B 73 28 56 8D 43 20 50 FF 73 08 E8 ?? ?? ?? ?? DD 43 18 83 C4 0C 85 C0 75 34 8B 45 C0 DD 5D B0 83 E0 E3 83 C8 03 89 45 C0 6A 00 8D 43 20 50 8D 43 10 50 FF 73 0C 8D 43 28 FF 73 08 50 8D 45 80 50 E8 ?? ?? ?? ?? 8B 73 28 83 C4 1C EB 02 DD D8 FF 73 08 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 59 75 2A 85 C0 74 26 DD 43 20 56 83 EC 18 DD 5C 24 10 DD 43 18 DD 5C 24 08 DD 43 10 DD 1C 24 FF 73 0C 50 E8 ?? ?? ?? ?? 83 C4 24 EB 18 50 E8 ?? ?? ?? ?? C7 04 24 FF FF 00 00 56 E8 ?? ?? ?? ?? DD 43 20 59 59 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D 8B E3 5B C3 }
	condition:
		$1
}

rule file_192_3_0 {
	meta:
		name = "__get_fname"
		size = 36
		refs = "000b ?_names@?1??_get_fname@@9@9"
	strings:
		$1 = { 55 8B EC 8B 4D 08 33 C0 39 0C C5 ?? ?? ?? ?? 74 0A 40 83 F8 1D 7C F1 33 C0 5D C3 8B 04 C5 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_192_4_0 {
	meta:
		name = "__handle_exc"
		size = 476
		refs = "001e __set_statfp 008a __d_max 00d1 __d_inf 0125 __decomp"
	strings:
		$1 = { 55 8B EC 83 EC 0C 53 8B 5D 08 56 8B F3 83 E6 1F F6 C3 08 74 16 F6 45 10 01 74 10 6A 01 E8 ?? ?? ?? ?? 59 83 E6 F7 E9 90 01 00 00 F6 C3 04 74 16 F6 45 10 04 74 10 6A 04 E8 ?? ?? ?? ?? 59 83 E6 FB E9 75 01 00 00 F6 C3 01 0F 84 9A 00 00 00 F6 45 10 08 0F 84 90 00 00 00 6A 08 E8 ?? ?? ?? ?? 8B 45 10 59 B9 00 0C 00 00 23 C1 74 54 3D 00 04 00 00 74 37 3D 00 08 00 00 74 1A 3B C1 75 62 D9 EE 8B 4D 0C DC 19 DF E0 DD 05 ?? ?? ?? ?? F6 C4 05 7B 4C EB 48 D9 EE 8B 4D 0C DC 19 DF E0 F6 C4 05 7B 2C DD 05 ?? ?? ?? ?? EB 32 D9 EE 8B 4D 0C DC 19 DF E0 F6 C4 05 7A 1E DD 05 ?? ?? ?? ?? EB 1E D9 EE 8B 4D 0C DC 19 DF E0 F6 C4 05 7A 08 DD 05 ?? ?? ?? ?? EB 08 DD 05 ?? ?? ?? ?? D9 E0 DD 19 83 E6 FE E9 D2 00 00 00 F6 C3 02 0F 84 C9 00 00 00 F6 45 10 10 0F 84 BF 00 00 00 57 33 FF F6 C3 10 74 01 47 8B 4D 0C DD 01 D9 EE DA E9 DF E0 F6 C4 44 0F 8B 8F 00 00 00 DD 01 8D 45 08 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 8B 45 08 DD 55 F4 D9 EE 05 00 FA FF FF 83 C4 0C 89 45 08 3D CE FB FF FF 7D 07 33 FF DE C9 47 EB 57 DE D9 33 D2 DF E0 F6 C4 41 75 01 42 8B 45 FA 83 E0 0F 83 C8 10 66 89 45 FA 8B 45 08 B9 03 FC FF FF 3B C1 7D 29 2B C8 8B 45 F4 F6 45 F4 01 74 05 85 FF 75 01 47 D1 E8 F6 45 F8 01 89 45 F4 74 08 0D 00 00 00 80 89 45 F4 D1 6D F8 49 75 DC DD 45 F4 85 D2 74 02 D9 E0 8B 45 0C DD 18 EB 03 33 FF 47 85 FF 5F 74 08 6A 10 E8 ?? ?? ?? ?? 59 83 E6 FD F6 C3 10 74 11 F6 45 10 20 74 0B 6A 20 E8 ?? ?? ?? ?? 59 83 E6 EF 33 C0 85 F6 5E 0F 94 C0 5B C9 C3 }
	condition:
		$1
}

rule file_192_5_0 {
	meta:
		name = "__handle_qnan1"
		size = 80
		refs = "0005 __matherr_flag 0028 __umatherr 0032 __errno 0045 __ctrlfp"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 75 25 FF 75 14 DD 45 0C 83 EC 18 DD 54 24 10 D9 EE DD 5C 24 08 DD 1C 24 FF 75 08 6A 01 E8 ?? ?? ?? ?? 83 C4 24 5D C3 E8 ?? ?? ?? ?? 68 FF FF 00 00 FF 75 14 C7 00 21 00 00 00 E8 ?? ?? ?? ?? DD 45 0C 59 59 5D C3 }
	condition:
		$1
}

rule file_192_6_0 {
	meta:
		name = "__handle_qnan2"
		size = 96
		refs = "0005 __matherr_flag 0032 __umatherr 0042 __errno 0055 __ctrlfp"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 DD 45 0C D9 C0 DD 45 14 DC C1 D9 C9 DD 55 0C 75 20 FF 75 1C 83 EC 18 DD 5C 24 10 DD 5C 24 08 DD 1C 24 FF 75 08 6A 01 E8 ?? ?? ?? ?? 83 C4 24 5D C3 DD D8 DD D9 DD D8 E8 ?? ?? ?? ?? 68 FF FF 00 00 FF 75 1C C7 00 21 00 00 00 E8 ?? ?? ?? ?? DD 45 0C 59 59 5D C3 }
	condition:
		$1
}

rule file_192_7_0 {
	meta:
		name = "__raise_exc"
		size = 33
		refs = "0018 __raise_exc_ex"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 1C 5D C3 }
	condition:
		$1
}

rule file_705_4_0 {
	meta:
		name = "__cfltcvt"
		size = 33
		refs = "0018 __cfltcvt_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 1C 5D C3 }
	condition:
		$1
}

rule file_192_8_0 {
	meta:
		name = "__raise_exc_ex"
		size = 741
		refs = "00d9 __statfp 021e __clrfp 022d __imp__RaiseException@16"
	strings:
		$1 = { 55 8B EC 8B 45 08 33 C9 89 48 04 8B 45 08 53 89 48 08 8B 45 08 33 DB 89 48 0C 8B 4D 10 43 57 F6 C1 10 74 0D 8B 45 08 BF 8F 00 00 C0 09 58 04 EB 03 8B 7D 08 F6 C1 02 74 0C 8B 45 08 BF 93 00 00 C0 83 48 04 02 F6 C1 01 74 0C 8B 45 08 BF 91 00 00 C0 83 48 04 04 F6 C1 04 74 0C 8B 45 08 BF 8E 00 00 C0 83 48 04 08 F6 C1 08 74 0C 8B 45 08 BF 90 00 00 C0 83 48 04 10 8B 4D 08 56 8B 75 0C 8B 06 C1 E0 04 F7 D0 33 41 08 83 E0 10 31 41 08 8B 06 8B 4D 08 03 C0 F7 D0 33 41 08 83 E0 08 31 41 08 8B 06 8B 4D 08 D1 E8 F7 D0 33 41 08 83 E0 04 31 41 08 8B 06 8B 4D 08 C1 E8 03 F7 D0 33 41 08 83 E0 02 31 41 08 8B 06 8B 4D 08 C1 E8 05 F7 D0 33 41 08 23 C3 31 41 08 E8 ?? ?? ?? ?? 8B D0 F6 C2 01 74 07 8B 4D 08 83 49 0C 10 F6 C2 04 74 07 8B 45 08 83 48 0C 08 F6 C2 08 74 07 8B 45 08 83 48 0C 04 F6 C2 10 74 07 8B 45 08 83 48 0C 02 F6 C2 20 74 06 8B 45 08 09 58 0C 8B 06 B9 00 0C 00 00 23 C1 74 35 3D 00 04 00 00 74 22 3D 00 08 00 00 74 0C 3B C1 75 29 8B 45 08 83 08 03 EB 21 8B 4D 08 8B 01 83 E0 FE 83 C8 02 89 01 EB 12 8B 4D 08 8B 01 83 E0 FD 0B C3 EB F0 8B 45 08 83 20 FC 8B 06 B9 00 03 00 00 23 C1 74 20 3D 00 02 00 00 74 0C 3B C1 75 22 8B 45 08 83 20 E3 EB 1A 8B 4D 08 8B 01 83 E0 E7 83 C8 04 EB 0B 8B 4D 08 8B 01 83 E0 EB 83 C8 08 89 01 8B 45 08 8B 4D 14 C1 E1 05 33 08 81 E1 E0 FF 01 00 31 08 8B 45 08 09 58 20 83 7D 20 00 74 2C 8B 45 08 83 60 20 E1 8B 45 18 D9 00 8B 45 08 D9 58 10 8B 45 08 09 58 60 8B 45 08 8B 5D 1C 83 60 60 E1 8B 45 08 D9 03 D9 58 50 EB 3A 8B 4D 08 8B 41 20 83 E0 E3 83 C8 02 89 41 20 8B 45 18 DD 00 8B 45 08 DD 58 10 8B 45 08 09 58 60 8B 4D 08 8B 5D 1C 8B 41 60 83 E0 E3 83 C8 02 89 41 60 DD 03 8B 45 08 DD 58 50 E8 ?? ?? ?? ?? 8D 45 08 50 6A 01 6A 00 57 FF 15 ?? ?? ?? ?? 8B 4D 08 F6 41 08 10 74 03 83 26 FE F6 41 08 08 74 03 83 26 FB F6 41 08 04 74 03 83 26 F7 F6 41 08 02 74 03 83 26 EF F6 41 08 01 74 03 83 26 DF 8B 01 83 E0 03 BA FF F3 FF FF 83 E8 00 74 2F 48 74 1E 48 74 0B 48 75 28 81 0E 00 0C 00 00 EB 20 8B 06 25 FF FB FF FF 0D 00 08 00 00 89 06 EB 10 8B 06 25 FF F7 FF FF 0D 00 04 00 00 EB EE 21 16 8B 01 C1 E8 02 83 E0 07 83 E8 00 74 15 48 74 07 48 75 1A 21 16 EB 16 8B 06 23 C2 0D 00 02 00 00 EB 09 8B 06 23 C2 0D 00 03 00 00 89 06 83 7D 20 00 5E 74 07 D9 41 50 D9 1B EB 05 DD 41 50 DD 1B 5F 5B 5D C3 }
	condition:
		$1
}

rule file_192_9_0 {
	meta:
		name = "__raise_excf"
		size = 33
		refs = "0018 __raise_exc_ex"
	strings:
		$1 = { 55 8B EC 6A 01 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 1C 5D C3 }
	condition:
		$1
}

rule file_192_10_0 {
	meta:
		name = "__set_errno_from_matherr"
		size = 45
		refs = "0014 __errno"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 F8 01 74 15 83 C0 FE 83 F8 01 77 18 E8 ?? ?? ?? ?? C7 00 22 00 00 00 5D C3 E8 ?? ?? ?? ?? C7 00 21 00 00 00 5D C3 }
	condition:
		$1
}

rule file_192_11_0 {
	meta:
		name = "__umatherr"
		size = 158
		refs = "0010 ?_names@?1??_get_fname@@9@9 0060 __ctrlfp 0069 __matherr 0076 __set_errno_from_matherr"
	strings:
		$1 = { 55 8B EC 8B 55 0C 83 EC 20 33 C9 8B C1 39 14 C5 ?? ?? ?? ?? 74 08 40 83 F8 1D 7C F1 EB 07 8B 0C C5 ?? ?? ?? ?? 89 4D E4 85 C9 74 55 8B 45 10 89 45 E8 8B 45 14 89 45 EC 8B 45 18 89 45 F0 8B 45 1C 56 8B 75 08 89 45 F4 8B 45 20 89 45 F8 8B 45 24 68 FF FF 00 00 FF 75 28 89 75 E0 89 45 FC E8 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 07 56 E8 ?? ?? ?? ?? 59 DD 45 F8 5E C9 C3 68 FF FF 00 00 FF 75 28 E8 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? DD 45 20 83 C4 0C C9 C3 }
	condition:
		$1
}

rule file_193_0_0 {
	meta:
		name = "___common_dcosh_cout_rare"
		size = 976
		refs = "0011 __vmldCoshHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 83 EC 3C 8B 4D 08 F2 0F 10 0D ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 0F B7 51 06 81 E2 F0 7F 00 00 81 FA F0 7F 00 00 0F 84 7F 03 00 00 F2 0F 10 01 0F B6 51 07 F2 0F 11 44 24 20 83 E2 7F 88 54 24 27 0F B7 4C 24 26 81 E1 F0 7F 00 00 81 F9 90 3C 00 00 0F 8E 34 03 00 00 F2 0F 10 7C 24 20 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F C7 0F 86 FC 02 00 00 F2 0F 11 4C 24 30 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 CF 66 0F 2F 3D ?? ?? ?? ?? 0F 82 2B 01 00 00 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 C8 F2 0F 11 0C 24 F2 0F 10 0C 24 8B 0C 24 8B D1 83 E2 3F F2 0F 5C 0D ?? ?? ?? ?? F2 0F 11 4C 24 08 F2 0F 10 54 24 08 F2 0F 59 15 ?? ?? ?? ?? F2 0F 10 5C 24 08 F2 0F 5C FA F2 0F 59 1D ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C FB F2 0F 59 CF C1 E2 04 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CF F2 0F 10 A2 ?? ?? ?? ?? C1 E9 06 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CF 81 C1 FF 03 00 00 49 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CF 81 E1 FF 07 00 00 81 F9 FE 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CF F2 0F 59 CF F2 0F 58 CF F2 0F 59 CC F2 0F 58 8A ?? ?? ?? ?? F2 0F 58 CC 77 2A C1 E1 04 25 0F 80 FF FF 0B C1 66 89 44 24 36 F2 0F 10 44 24 30 F2 0F 59 C1 8B 45 0C F2 0F 11 00 33 C0 83 C4 3C 5E 8B E5 5D C3 49 81 E1 FF 07 00 00 0F B7 44 24 36 C1 E1 04 25 0F 80 FF FF 0B C1 66 89 44 24 36 33 C0 F2 0F 59 4C 24 30 F2 0F 59 0D ?? ?? ?? ?? 8B 55 0C F2 0F 11 0A 83 C4 3C 5E 8B E5 5D C3 F2 0F 10 2D ?? ?? ?? ?? 0F B7 4C 24 36 81 E1 0F 80 FF FF F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 0C 24 F2 0F 10 04 24 8B 34 24 8B D6 C1 EA 06 83 E6 3F 81 C2 FF 03 00 00 F2 0F 5C 05 ?? ?? ?? ?? F2 0F 11 44 24 08 8D 42 FF F2 0F 10 74 24 08 25 FF 07 00 00 F2 0F 59 35 ?? ?? ?? ?? F7 DA F2 0F 10 5C 24 08 83 C2 FC F2 0F 59 1D ?? ?? ?? ?? F2 0F 5C FE F2 0F 10 35 ?? ?? ?? ?? 81 E2 FF 07 00 00 C1 E6 04 F2 0F 5C FB 0F 28 E7 F2 0F 59 E7 F2 0F 59 F4 F2 0F 59 EC F2 0F 58 35 ?? ?? ?? ?? F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 F4 F2 0F 59 EC F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 EF F2 0F 59 F4 C1 E0 04 F2 0F 10 9E ?? ?? ?? ?? 0B C8 F2 0F 10 A6 ?? ?? ?? ?? F7 DE 66 89 4C 24 36 81 E1 0F 80 FF FF C1 E2 04 F2 0F 10 44 24 30 0B CA 66 89 4C 24 36 F2 0F 59 D8 F2 0F 59 E0 F2 0F 10 4C 24 30 F2 0F 10 96 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 10 86 ?? ?? ?? ?? F2 0F 59 C1 0F 28 CB F2 0F 58 CA F2 0F 11 4C 24 10 0F 28 CB F2 0F 11 44 24 20 F2 0F 5C DA F2 0F 10 44 24 10 F2 0F 59 EB F2 0F 5C C8 8B 45 0C F2 0F 58 CA F2 0F 11 4C 24 18 F2 0F 10 44 24 10 F2 0F 10 54 24 20 F2 0F 11 44 24 28 0F 28 C4 F2 0F 10 4C 24 18 F2 0F 5C C2 F2 0F 59 C7 F2 0F 59 FB F2 0F 58 C2 F2 0F 58 C4 F2 0F 58 C1 F2 0F 58 C5 F2 0F 10 6C 24 28 F2 0F 59 F5 F2 0F 58 C6 F2 0F 58 C7 F2 0F 11 44 24 10 F2 0F 10 7C 24 10 F2 0F 58 EF F2 0F 11 28 33 C0 83 C4 3C 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C0 8B 45 0C F2 0F 11 00 B8 03 00 00 00 83 C4 3C 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? 8B 45 0C F2 0F 58 44 24 20 F2 0F 11 00 33 C0 83 C4 3C 5E 8B E5 5D C3 F2 0F 10 01 F2 0F 59 C0 8B 45 0C F2 0F 11 00 33 C0 83 C4 3C 5E 8B E5 5D C3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_194_0_0 {
	meta:
		name = "_frexp"
		size = 214
		refs = "000e __errno 0019 __invalid_parameter_noinfo 0032 __ctrlfp 0056 __sptype 0076 __handle_qnan1 0081 __d_ind 0098 __real@3ff0000000000000 00ad __except1 00bd __decomp"
	strings:
		$1 = { 55 8B EC 51 51 56 8B 75 10 85 F6 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? D9 EE E9 AF 00 00 00 53 57 BB FF FF 00 00 53 68 3F 13 00 00 E8 ?? ?? ?? ?? DD 45 08 59 59 0F B7 4D 0E 8B F8 B8 F0 7F 00 00 23 C8 66 3B C8 75 69 83 0E FF 51 51 DD 1C 24 E8 ?? ?? ?? ?? 59 59 85 C0 7E 32 83 F8 02 7E 1A 83 F8 03 75 28 DD 45 08 57 51 51 DD 1C 24 6A 17 E8 ?? ?? ?? ?? 83 C4 10 EB 52 DD 05 ?? ?? ?? ?? 57 83 EC 10 DD 5C 24 08 DD 45 08 EB 13 DD 45 08 57 DD 05 ?? ?? ?? ?? 83 EC 10 D8 C1 DD 5C 24 08 DD 1C 24 6A 17 6A 08 E8 ?? ?? ?? ?? 83 C4 1C EB 1B 56 51 51 DD 1C 24 E8 ?? ?? ?? ?? 53 DD 5D F8 57 E8 ?? ?? ?? ?? DD 45 F8 83 C4 14 5F 5B 5E C9 C3 }
	condition:
		$1
}

rule file_195_0_0 {
	meta:
		name = "__allshl"
		size = 31
	strings:
		$1 = { 80 F9 40 73 15 80 F9 20 73 06 0F A5 C2 D3 E0 C3 8B D0 33 C0 80 E1 1F D3 E2 C3 33 C0 33 D2 C3 }
	condition:
		$1
}

rule file_196_0_0 {
	meta:
		name = "___sse2_asinf4"
		size = 336
		refs = "000f ___common_sasin_data 013e ___common_sasin_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 0F 28 2D ?? ?? ?? ?? 0F 28 F5 0F 55 E8 0F 54 F0 0F 28 1D ?? ?? ?? ?? 0F 28 FE 0F 59 FB 0F 28 E6 0F 59 E6 0F 28 15 ?? ?? ?? ?? 0F C2 D6 02 0F 29 44 24 10 0F 28 C3 0F 50 D2 0F 28 D6 0F C2 D3 05 0F 5C C7 0F 52 D8 0F 5D E0 0F 58 C0 0F 28 CB 0F 28 FC 0F 59 CB 85 D2 0F 59 D8 0F 59 FC 0F 59 C1 0F 28 0D ?? ?? ?? ?? 0F 5C 05 ?? ?? ?? ?? 0F 59 C8 0F 59 C3 0F 58 0D ?? ?? ?? ?? 0F 59 C8 0F 28 05 ?? ?? ?? ?? 0F 5C CB 0F 59 C4 0F 28 1D ?? ?? ?? ?? 0F 54 CA 0F 59 DC 0F 58 05 ?? ?? ?? ?? 0F 59 C7 0F 58 1D ?? ?? ?? ?? 0F 58 C3 0F 59 C4 0F 58 05 ?? ?? ?? ?? 0F 59 C4 0F 28 E2 0F 55 E6 0F 56 E1 0F 59 C4 0F 28 35 ?? ?? ?? ?? 0F 58 C4 0F 54 F2 0F 58 C6 66 0F EF C5 75 04 8B E5 5D C3 0F 28 4C 24 10 0F 29 4C 24 40 0F 29 84 24 80 00 00 00 74 E8 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 8B CE B8 01 00 00 00 D3 E0 85 F8 75 17 46 83 FE 20 7C ED 8B 74 24 04 8B 3C 24 0F 28 84 24 80 00 00 00 EB B7 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB D2 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_198_4_0 {
	meta:
		name = "__mbstrnlen_l"
		size = 229
		refs = "000f __errno 001a __invalid_parameter_noinfo 0052 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0062 _strnlen 0079 __imp__MultiByteToWideChar@24 00a9 __isleadbyte_l"
	strings:
		$1 = { 55 8B EC 83 EC 10 56 8B 75 08 85 F6 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 BC 00 00 00 53 8B 5D 0C 81 FB FF FF FF 7F 76 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 97 00 00 00 57 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F0 83 78 74 01 75 0D 53 56 E8 ?? ?? ?? ?? 59 59 8B F8 EB 65 33 FF 57 57 53 56 6A 09 FF 70 04 FF 15 ?? ?? ?? ?? 85 C0 75 10 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 83 CF FF EB 40 8B C7 89 45 08 85 DB 74 35 8A 0E 84 C9 74 2B 8D 45 F0 50 0F B6 C1 50 E8 ?? ?? ?? ?? 59 85 C0 8B 45 08 59 74 0B 40 3B C3 73 14 46 80 3E 00 74 0A 47 46 40 89 45 08 3B C3 72 CF 3B C3 72 02 8B FB 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD 8B C7 5F 5B 5E C9 C3 }
	condition:
		$1
}

rule file_199_0_0 {
	meta:
		name = "__spawnlpe"
		size = 80
		refs = "000b __errno 0016 __invalid_parameter_noinfo 0047 __spawnvpe"
	strings:
		$1 = { 55 8B EC 8B 55 0C 85 D2 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 80 3A 00 74 E6 8B 45 10 85 C0 74 DF 80 38 00 74 DA 8D 4D 10 8B 01 8D 49 04 85 C0 75 F7 FF 31 8D 45 10 50 52 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_783_0_0 {
	meta:
		name = "__spawnle"
		size = 80
		refs = "000b __errno 0016 __invalid_parameter_noinfo 0047 __spawnve"
	strings:
		$1 = { 55 8B EC 8B 55 0C 85 D2 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 80 3A 00 74 E6 8B 45 10 85 C0 74 DF 80 38 00 74 DA 8D 4D 10 8B 01 8D 49 04 85 C0 75 F7 FF 31 8D 45 10 50 52 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_200_3_0 {
	meta:
		name = "?_wcsupr_s_l_stat@@YAHPA_WIPAUlocaleinfo_struct@@@Z"
		size = 376
		refs = "0006 ___security_cookie 0019 __errno 0023 __invalid_parameter_noinfo 0033 _wcsnlen 0062 ___crtLCMapStringW 00e3 __alloca_probe_16 00f7 _malloc 0149 _wcscpy_s 0160 __freea 0172 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 51 51 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 57 8B 7D 08 85 FF 75 16 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 E9 39 01 00 00 FF 75 0C 57 E8 ?? ?? ?? ?? 59 59 3B 45 0C 72 07 33 C0 66 89 07 EB D3 8B 45 10 33 F6 8B 00 8B 80 A8 00 00 00 85 C0 74 49 56 56 6A FF 57 68 00 02 00 00 50 E8 ?? ?? ?? ?? 8B C8 83 C4 18 89 4D F8 85 C9 75 39 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 E8 ?? ?? ?? ?? 8B 00 E9 DE 00 00 00 0F B7 07 83 F8 61 72 0B 83 F8 7A 77 06 83 C0 E0 66 89 07 83 C7 02 66 39 37 75 E5 33 C0 E9 BC 00 00 00 39 4D 0C 73 11 33 C0 66 89 07 E8 ?? ?? ?? ?? 6A 22 E9 5E FF FF FF 85 C9 7E 49 6A E0 33 D2 58 F7 F1 83 F8 02 72 3D 8D 0C 4D 08 00 00 00 81 F9 00 04 00 00 77 15 8B C1 E8 ?? ?? ?? ?? 8B F4 85 F6 74 1E C7 06 CC CC 00 00 EB 13 51 E8 ?? ?? ?? ?? 8B F0 59 85 F6 74 09 C7 06 DD DD 00 00 83 C6 08 8B 4D F8 85 F6 75 10 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E9 5B FF FF FF 8B 45 10 51 8B 00 56 6A FF 57 68 00 02 00 00 FF B0 A8 00 00 00 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 11 56 FF 75 0C 57 E8 ?? ?? ?? ?? 83 C4 0C 8B F8 EB 0A E8 ?? ?? ?? ?? 6A 2A 5F 89 38 56 E8 ?? ?? ?? ?? 59 8B C7 8D 65 F0 5F 5E 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_200_6_0 {
	meta:
		name = "__wcsupr"
		size = 104
		refs = "0005 ___locale_changed 0014 __errno 001f __invalid_parameter_noinfo 005c __wcsupr_s_l"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 75 48 8B 45 08 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 5D C3 57 33 FF 8B D0 66 39 38 74 20 56 0F B7 0A 6A 61 5E 66 3B F1 77 0B 83 F9 7A 77 06 83 C1 E0 66 89 0A 83 C2 02 66 39 3A 75 E2 5E 5F 5D C3 6A 00 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_200_7_0 {
	meta:
		name = "__wcsupr_l"
		size = 24
		refs = "000c __wcsupr_s_l"
	strings:
		$1 = { 55 8B EC FF 75 0C 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_208_7_0 {
	meta:
		name = "__strlwr_l"
		size = 24
		refs = "000c __strlwr_s_l"
	strings:
		$1 = { 55 8B EC FF 75 0C 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1150_7_0 {
	meta:
		name = "__strupr_l"
		size = 24
		refs = "000c __strupr_s_l"
	strings:
		$1 = { 55 8B EC FF 75 0C 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_971_7_0 {
	meta:
		name = "__wcslwr_l"
		size = 24
		refs = "000c __wcslwr_s_l"
	strings:
		$1 = { 55 8B EC FF 75 0C 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_200_9_0 {
	meta:
		name = "__wcsupr_s_l"
		size = 50
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001c ?_wcsupr_s_l_stat@@YAHPA_WIPAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_208_9_0 {
	meta:
		name = "__strlwr_s_l"
		size = 50
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001c ?_strlwr_s_l_stat@@YAHPADIPAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_1150_9_0 {
	meta:
		name = "__strupr_s_l"
		size = 50
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001c ?_strupr_s_l_stat@@YAHPADIPAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_971_9_0 {
	meta:
		name = "__wcslwr_s_l"
		size = 50
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001c ?_wcslwr_s_l_stat@@YAHPA_WIPAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_201_0_0 {
	meta:
		name = "__add_exp"
		size = 45
		refs = "0024 __set_exp"
	strings:
		$1 = { 55 8B EC 0F B7 4D 0E DD 45 08 8B 45 10 C1 E9 04 81 E1 FF 07 00 00 05 02 FC FF FF 03 C1 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_201_1_0 {
	meta:
		name = "__decomp"
		size = 210
		refs = "009d __set_exp"
	strings:
		$1 = { 55 8B EC DD 45 08 57 D9 EE DD E1 DF E0 F6 C4 44 7A 09 DD D9 33 FF E9 AF 00 00 00 56 66 8B 75 0E 0F B7 C6 A9 F0 7F 00 00 75 7C 8B 4D 0C 8B 55 08 F7 C1 FF FF 0F 00 75 04 85 D2 74 6A DE D9 BF 03 FC FF FF DF E0 F6 C4 41 75 05 33 C0 40 EB 02 33 C0 F6 45 0E 10 75 1F 03 C9 89 4D 0C 85 D2 79 06 83 C9 01 89 4D 0C 03 D2 4F F6 45 0E 10 74 E8 66 8B 75 0E 89 55 08 B9 EF FF 00 00 66 23 F1 66 89 75 0E 85 C0 74 0C B8 00 80 00 00 66 0B F0 66 89 75 0E DD 45 08 6A 00 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C EB 23 6A 00 DD D8 51 51 DD 1C 24 E8 ?? ?? ?? ?? 0F B7 FE C1 EF 04 81 E7 FF 07 00 00 83 C4 0C 81 EF FE 03 00 00 5E 8B 45 10 89 38 5F 5D C3 }
	condition:
		$1
}

rule file_201_2_0 {
	meta:
		name = "__get_exp"
		size = 23
	strings:
		$1 = { 55 8B EC 0F B7 45 0E C1 E8 04 25 FF 07 00 00 2D FE 03 00 00 98 5D C3 }
	condition:
		$1
}

rule file_201_3_0 {
	meta:
		name = "__set_bexp"
		size = 37
	strings:
		$1 = { 55 8B EC 51 51 0F B7 45 0E DD 45 08 8B 4D 10 DD 5D F8 C1 E1 04 25 0F 80 00 00 0B C8 66 89 4D FE DD 45 F8 C9 C3 }
	condition:
		$1
}

rule file_201_4_0 {
	meta:
		name = "__set_exp"
		size = 43
	strings:
		$1 = { 55 8B EC 51 51 8B 4D 10 DD 45 08 0F B7 45 0E DD 5D F8 8D 89 FE 03 00 00 C1 E1 04 25 0F 80 00 00 0B C8 66 89 4D FE DD 45 F8 C9 C3 }
	condition:
		$1
}

rule file_201_5_0 {
	meta:
		name = "__sptype"
		size = 92
	strings:
		$1 = { 55 8B EC 81 7D 0C 00 00 F0 7F 8B 45 08 75 07 85 C0 75 15 40 5D C3 81 7D 0C 00 00 F0 FF 75 09 85 C0 75 05 6A 02 58 5D C3 66 8B 4D 0E BA F8 7F 00 00 66 23 CA 66 3B CA 75 04 6A 03 EB E8 BA F0 7F 00 00 66 3B CA 75 11 F7 45 0C FF FF 07 00 75 04 85 C0 74 04 6A 04 EB CD 33 C0 5D C3 }
	condition:
		$1
}

rule file_202_1_0 {
	meta:
		name = "__vscwprintf"
		size = 26
		refs = "000c __woutput_l 0011 __vscwprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 0C 6A 00 FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_671_1_0 {
	meta:
		name = "__vprintf_p"
		size = 26
		refs = "000c __output_p_l 0011 _vprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 0C 6A 00 FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_608_0_0 {
	meta:
		name = "__vscprintf"
		size = 26
		refs = "000c __output_l 0011 __vscprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 0C 6A 00 FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_608_3_0 {
	meta:
		name = "__vscprintf_p"
		size = 26
		refs = "000c __output_p_l 0011 __vscprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 0C 6A 00 FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_202_4_0 {
	meta:
		name = "__vscwprintf_p"
		size = 26
		refs = "000c __woutput_p_l 0011 __vscwprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 0C 6A 00 FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_854_1_0 {
	meta:
		name = "__vwprintf_p"
		size = 26
		refs = "000c __woutput_p_l 0011 _vwprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 0C 6A 00 FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_671_4_0 {
	meta:
		name = "_vprintf"
		size = 26
		refs = "000c __output_l 0011 _vprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 0C 6A 00 FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_671_6_0 {
	meta:
		name = "_vprintf_s"
		size = 26
		refs = "000c __output_s_l 0011 _vprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 0C 6A 00 FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_854_4_0 {
	meta:
		name = "_vwprintf"
		size = 26
		refs = "000c __woutput_l 0011 _vwprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 0C 6A 00 FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_854_6_0 {
	meta:
		name = "_vwprintf_s"
		size = 26
		refs = "000c __woutput_s_l 0011 _vwprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 0C 6A 00 FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_202_2_0 {
	meta:
		name = "__vscwprintf_helper"
		size = 90
		refs = "001d __errno 0028 __invalid_parameter_noinfo"
		altNames = "__vscprintf_helper"
	strings:
		$1 = { 55 8B EC 83 EC 20 57 6A 07 33 D2 59 33 C0 8D 7D E4 89 55 E0 F3 AB 5F 39 45 0C 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF C9 C3 FF 75 14 8D 45 E0 FF 75 10 C7 45 E4 FF FF FF 7F FF 75 0C C7 45 EC 42 00 00 00 50 89 55 E8 89 55 E0 FF 55 08 83 C4 10 C9 C3 }
	condition:
		$1
}

rule file_202_3_0 {
	meta:
		name = "__vscwprintf_l"
		size = 27
		refs = "000d __woutput_l 0012 __vscwprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_671_0_0 {
	meta:
		name = "__vprintf_l"
		size = 27
		refs = "000d __output_l 0012 _vprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_671_2_0 {
	meta:
		name = "__vprintf_p_l"
		size = 27
		refs = "000d __output_p_l 0012 _vprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_671_3_0 {
	meta:
		name = "__vprintf_s_l"
		size = 27
		refs = "000d __output_s_l 0012 _vprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_608_2_0 {
	meta:
		name = "__vscprintf_l"
		size = 27
		refs = "000d __output_l 0012 __vscprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_608_4_0 {
	meta:
		name = "__vscprintf_p_l"
		size = 27
		refs = "000d __output_p_l 0012 __vscprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_202_5_0 {
	meta:
		name = "__vscwprintf_p_l"
		size = 27
		refs = "000d __woutput_p_l 0012 __vscwprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_854_0_0 {
	meta:
		name = "__vwprintf_l"
		size = 27
		refs = "000d __woutput_l 0012 _vwprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_854_2_0 {
	meta:
		name = "__vwprintf_p_l"
		size = 27
		refs = "000d __woutput_p_l 0012 _vwprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_854_3_0 {
	meta:
		name = "__vwprintf_s_l"
		size = 27
		refs = "000d __woutput_s_l 0012 _vwprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_202_6_0 {
	meta:
		name = "__vswprintf"
		size = 24
		refs = "000f __vswprintf_l"
	strings:
		$1 = { 55 8B EC FF 75 10 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_608_6_0 {
	meta:
		name = "_vsprintf"
		size = 24
		refs = "000f __vsprintf_l"
	strings:
		$1 = { 55 8B EC FF 75 10 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_202_7_0 {
	meta:
		name = "__vswprintf_l"
		size = 162
		refs = "001d __errno 0028 __invalid_parameter_noinfo 005b __woutput_l 007d __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 20 53 57 33 DB 6A 07 33 C0 59 8D 7D E4 89 5D E0 F3 AB 39 45 0C 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 6D 8B 45 08 85 C0 74 E4 56 FF 75 14 89 45 E8 FF 75 10 89 45 E0 FF 75 0C 8D 45 E0 50 C7 45 EC 42 00 00 00 C7 45 E4 FF FF FF 7F E8 ?? ?? ?? ?? 83 C4 10 FF 4D E4 8B F0 78 0E 8B 4D E0 88 19 8B 4D E0 41 89 4D E0 EB 0F 8D 45 E0 50 53 E8 ?? ?? ?? ?? 59 59 8B 4D E0 FF 4D E4 78 04 88 19 EB 0C 8D 45 E0 50 53 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5F 5B C9 C3 }
	condition:
		$1
}

rule file_203_1_0 {
	meta:
		name = "__splitpath_helper"
		size = 519
		refs = "0096 __mbsnbcpy_s 00c0 __ismbblead 01dc __errno 01ea __invalid_parameter_noinfo"
	strings:
		$1 = { 55 8B EC 51 51 83 65 FC 00 8B 55 10 53 56 57 8B 7D 08 85 FF 74 0B 8B 4D 0C 85 C9 75 12 85 D2 74 12 8B 5D 14 8B 45 24 33 F6 46 E9 72 01 00 00 85 D2 74 EE 8B 5D 14 85 DB 75 07 39 5D 18 75 E5 EB 06 83 7D 18 00 74 DD 83 7D 1C 00 75 08 83 7D 20 00 75 D1 EB 06 83 7D 20 00 74 C9 83 7D 24 00 75 08 83 7D 28 00 75 BD EB 06 83 7D 28 00 74 B5 33 C0 40 8B F7 80 3E 00 74 04 46 48 75 F7 80 3E 3A 75 23 85 C9 74 17 83 FA 03 0F 82 63 01 00 00 6A 02 57 6A FF 51 E8 ?? ?? ?? ?? 83 C4 10 8D 7E 01 89 7D 08 EB 07 85 C9 74 03 C6 01 00 83 65 F8 00 33 DB 8B F7 38 1F 74 60 8B 7D F8 0F BE 06 50 E8 ?? ?? ?? ?? 59 85 C0 74 03 46 EB 15 8A 06 3C 2F 74 0C 3C 5C 74 08 3C 2E 75 07 8B DE EB 03 8D 7E 01 46 80 3E 00 75 D4 89 7D F8 85 FF 8B 7D 08 74 27 8B 4D 14 85 C9 74 1B 8B 45 F8 2B C7 39 45 18 0F 86 92 00 00 00 50 57 6A FF 51 E8 ?? ?? ?? ?? 83 C4 10 8B 7D F8 EB 0A 8B 4D 14 85 C9 74 03 C6 01 00 85 DB 74 3E 3B DF 72 3A 8B 4D 1C 85 C9 74 16 8B C3 2B C7 39 45 20 76 53 50 57 6A FF 51 E8 ?? ?? ?? ?? 83 C4 10 8B 45 24 85 C0 74 3B 2B F3 39 75 28 76 46 56 53 6A FF 50 E8 ?? ?? ?? ?? 83 C4 10 EB 25 8B 4D 1C 85 C9 74 14 2B F7 39 75 20 76 1B 56 57 6A FF 51 E8 ?? ?? ?? ?? 83 C4 10 8B 45 24 85 C0 74 03 C6 00 00 33 C0 EB 75 8B 45 24 8B 5D 14 8B 75 FC EB 0C 8B 45 24 8B 5D 14 8B 75 FC 8B 4D 1C 8B 55 0C 85 D2 74 09 83 7D 10 00 76 03 C6 02 00 85 DB 74 09 83 7D 18 00 76 03 C6 03 00 85 C9 74 09 83 7D 20 00 76 03 C6 01 00 85 C0 74 09 83 7D 28 00 76 03 C6 00 00 E8 ?? ?? ?? ?? 85 FF 75 13 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 10 8B 45 24 EB A7 85 F6 75 E9 6A 22 59 89 08 8B C1 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_205_3_0 {
	meta:
		name = "__isctype"
		size = 47
		refs = "0005 ___locale_changed 0010 ___initiallocinfo 0026 __isctype_l"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 75 11 8B 4D 08 A1 ?? ?? ?? ?? 0F B7 04 48 23 45 0C 5D C3 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_205_4_0 {
	meta:
		name = "__isctype_l"
		size = 175
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 003f __isleadbyte_l 007d ___crtGetStringTypeA"
	strings:
		$1 = { 55 8B EC 83 EC 18 8D 4D E8 53 FF 75 10 E8 ?? ?? ?? ?? 8B 5D 08 8D 43 01 3D 00 01 00 00 77 0F 8B 45 E8 8B 80 90 00 00 00 0F B7 04 58 EB 6E 8B C3 C1 F8 08 89 45 08 8D 4D E8 0F B6 C0 51 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 12 8B 45 08 6A 02 88 45 F8 88 5D F9 C6 45 FA 00 59 EB 0A 33 C9 88 5D F8 C6 45 F9 00 41 8B 45 E8 6A 01 FF 70 04 8D 45 FC 50 51 8D 45 F8 50 8D 45 E8 6A 01 50 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 10 38 45 F4 74 07 8B 45 F0 83 60 70 FD 33 C0 EB 14 0F B7 45 FC 23 45 0C 80 7D F4 00 74 07 8B 4D F0 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_206_1_0 {
	meta:
		name = "__set_fmode"
		size = 64
		refs = "001c __errno 0027 __invalid_parameter_noinfo 0032 __fmode 0038 __imp__InterlockedExchange@8"
	strings:
		$1 = { 55 8B EC 8B 45 08 3D 00 40 00 00 74 23 3D 00 80 00 00 74 1C 3D 00 00 01 00 74 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 6A 16 58 5D C3 50 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 C0 5D C3 }
	condition:
		$1
}

rule file_206_2_0 {
	meta:
		name = "__setmode"
		size = 270
		refs = "0003 __sehtable$__setmode 0008 __SEH_prolog4 0038 __errno 0060 __ioinit 0076 __nhandle 008f ___pioinfo 009f ___lock_fhandle 00bc __setmode_nolock 00ef __unlock_fhandle 0101 __invalid_parameter_noinfo 0109 __SEH_epilog4"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 0C 81 FF 00 40 00 00 74 30 81 FF 00 80 00 00 74 28 81 FF 00 00 01 00 74 20 81 FF 00 00 04 00 74 18 81 FF 00 00 02 00 74 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 B9 00 00 00 8B 75 08 83 FE FE 75 10 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E9 A6 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 88 99 00 00 00 85 F6 0F 88 81 00 00 00 3B 35 ?? ?? ?? ?? 73 79 8B C6 C1 F8 05 89 45 0C 8B DE 83 E3 1F C1 E3 06 8B 04 85 ?? ?? ?? ?? 0F BE 44 03 04 83 E0 01 74 58 56 E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 45 0C 8B 04 85 ?? ?? ?? ?? F6 44 03 04 01 74 0D 57 56 E8 ?? ?? ?? ?? 59 59 8B F8 EB 0E E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 CF FF 89 7D E4 C7 45 FC FE FF FF FF E8 0A 00 00 00 8B C7 EB 21 8B 75 08 8B 7D E4 56 E8 ?? ?? ?? ?? 59 C3 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_206_3_0 {
	meta:
		name = "__setmode_nolock"
		size = 205
		refs = "0017 ___pioinfo"
	strings:
		$1 = { 55 8B EC 53 56 8B 75 08 8B DE C1 FB 05 83 E6 1F C1 E6 06 57 8B 3C 9D ?? ?? ?? ?? 8A 4C 37 04 0F B6 C1 25 80 00 00 00 89 45 08 8A 44 37 24 02 C0 0F BE D0 8B 45 0C D1 FA 3D 00 40 00 00 74 59 3D 00 80 00 00 74 49 3D 00 00 01 00 74 2A 3D 00 00 02 00 74 23 3D 00 00 04 00 75 50 80 C9 80 88 4C 37 04 8B 0C 9D ?? ?? ?? ?? 8A 44 31 24 24 81 0C 01 88 44 31 24 EB 34 80 C9 80 88 4C 37 04 8B 0C 9D ?? ?? ?? ?? 8A 44 31 24 24 82 0C 02 EB E2 80 E1 7F 88 4C 37 04 EB 13 80 C9 80 88 4C 37 04 8B 04 9D ?? ?? ?? ?? 80 64 30 24 80 83 7D 08 00 5F 5E 5B 75 07 B8 00 80 00 00 5D C3 F7 DA 1B D2 81 E2 00 C0 00 00 8D 82 00 40 00 00 5D C3 }
	condition:
		$1
}

rule file_207_0_0 {
	meta:
		name = "__heapmin"
		size = 22
		refs = "0004 __crtheap 000a __imp__HeapCompact@8"
	strings:
		$1 = { 6A 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? F7 D8 1B C0 F7 D8 48 C3 }
	condition:
		$1
}

rule file_208_3_0 {
	meta:
		name = "?_strlwr_s_l_stat@@YAHPADIPAUlocaleinfo_struct@@@Z"
		size = 370
		refs = "0006 ___security_cookie 0019 __errno 0023 __invalid_parameter_noinfo 0031 _strnlen 0064 ___crtLCMapStringA 00d7 __alloca_probe_16 00eb _malloc 0143 _strcpy_s 015a __freea 016c @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 51 51 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 8B 75 08 85 F6 75 14 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? E9 33 01 00 00 FF 75 0C 56 E8 ?? ?? ?? ?? 59 59 3B 45 0C 72 05 C6 06 00 EB D7 8B 55 10 8B 02 8B 88 A8 00 00 00 85 C9 74 4A 6A 01 FF 70 04 33 DB 53 53 6A FF 56 68 00 01 00 00 51 52 E8 ?? ?? ?? ?? 8B C8 83 C4 24 89 4D F8 85 C9 75 32 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 E8 ?? ?? ?? ?? 8B 00 E9 D6 00 00 00 8A 06 3C 41 7C 08 3C 5A 7F 04 04 20 88 06 46 80 3E 00 75 EC 33 C0 E9 BB 00 00 00 39 4D 0C 73 0E 88 1E E8 ?? ?? ?? ?? 6A 22 E9 66 FF FF FF 85 C9 7E 45 6A E0 33 D2 58 F7 F1 83 F8 01 72 39 83 C1 08 81 F9 00 04 00 00 77 15 8B C1 E8 ?? ?? ?? ?? 8B DC 85 DB 74 1E C7 03 CC CC 00 00 EB 13 51 E8 ?? ?? ?? ?? 8B D8 59 85 DB 74 09 C7 03 DD DD 00 00 83 C3 08 8B 4D F8 85 DB 75 10 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E9 69 FF FF FF 8B 55 10 6A 01 8B 02 FF 70 04 51 53 6A FF 56 68 00 01 00 00 FF B0 A8 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 24 85 C0 74 11 53 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 EB 0A E8 ?? ?? ?? ?? 6A 2A 5E 89 30 53 E8 ?? ?? ?? ?? 59 8B C6 8D 65 F0 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_208_6_0 {
	meta:
		name = "__strlwr"
		size = 91
		refs = "0005 ___locale_changed 0014 __errno 001f __invalid_parameter_noinfo 004f __strlwr_s_l"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 75 3B 8B 45 08 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 5D C3 80 38 00 8B C8 74 2B 8A 11 80 FA 41 7C 0A 80 FA 5A 7F 05 80 C2 20 88 11 41 80 39 00 75 E9 5D C3 6A 00 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_210_4_0 {
	meta:
		name = "___check_float_string"
		size = 95
		refs = "001d __calloc_crt 003e _memcpy 0049 __recalloc_crt"
	strings:
		$1 = { 55 8B EC 56 8B 75 0C 57 8B 06 39 45 08 75 49 8B 7D 10 6A 02 8B 0F 50 3B 4D 14 75 2B E8 ?? ?? ?? ?? 59 59 89 07 85 C0 75 04 33 C0 EB 2E 8B 45 18 C7 00 01 00 00 00 FF 36 FF 75 14 FF 37 E8 ?? ?? ?? ?? 83 C4 0C EB 0F 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 D5 89 07 D1 26 33 C0 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_210_5_0 {
	meta:
		name = "__cprinput_l"
		size = 3894
		refs = "000a ___security_cookie 0052 __errno 005d __invalid_parameter_noinfo 006a __ioinit 007d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00c2 _isspace 00da __whiteout 00e0 __un_inc 0166 _isdigit 036c __getche_nolock 04be ___check_float_string 0765 __cfltcvt_tab 076b __imp__DecodePointer@4 086f _isleadbyte 08bf __mbtowc_l 0973 _memset 0c45 __allmul 0c58 _isxdigit 0c86 __hextodec 0f07 _free 0f30 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 00 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 4D 10 53 8D 9D 7C FE FF FF 89 9D 54 FE FF FF 33 DB 57 8B 7D 08 8B C3 89 8D 18 FE FF FF C7 85 24 FE FF FF 5E 01 00 00 89 9D 30 FE FF FF 89 9D 1C FE FF FF 89 85 68 FE FF FF 85 FF 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 BF 0E 00 00 E8 ?? ?? ?? ?? 85 C0 78 EF 56 FF 75 0C 8D 8D 00 FE FF FF E8 ?? ?? ?? ?? 8A 07 8B F3 88 9D 78 FE FF FF 89 B5 6C FE FF FF 89 B5 60 FE FF FF 89 9D 34 FE FF FF 84 C0 0F 84 6D 0E 00 00 8B 8D 14 FE FF FF 89 8D 50 FE FF FF 8B 8D 10 FE FF FF 89 8D 48 FE FF FF 0F B6 C0 50 E8 ?? ?? ?? ?? 59 85 C0 74 35 8D 85 60 FE FF FF 4E 50 89 B5 60 FE FF FF E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 47 0F B6 07 50 E8 ?? ?? ?? ?? 59 85 C0 75 F1 8B B5 60 FE FF FF E9 CF 0D 00 00 8A 07 3C 25 0F 85 82 0D 00 00 38 47 01 0F 84 6F 0D 00 00 33 D2 89 95 38 FE FF FF 88 95 2F FE FF FF 89 95 4C FE FF FF 89 95 3C FE FF FF 8B F2 88 95 47 FE FF FF 88 95 5F FE FF FF 88 95 79 FE FF FF 88 95 7B FE FF FF 88 95 67 FE FF FF 88 95 7A FE FF FF C6 85 77 FE FF FF 01 89 95 28 FE FF FF 47 0F B6 1F 53 E8 ?? ?? ?? ?? 59 85 C0 74 60 FF 85 3C FE FF FF 6B F6 0A 83 C6 D0 03 F3 8A 95 79 FE FF FF 8A 85 7B FE FF FF 8A 8D 7A FE FF FF 84 C0 74 CD 89 B5 70 FE FF FF 8B B5 6C FE FF FF 89 BD 58 FE FF FF 84 D2 0F 85 56 01 00 00 8B 85 18 FE FF FF 89 85 14 FE FF FF 8B 10 83 C0 04 89 85 18 FE FF FF 89 95 40 FE FF FF E9 3B 01 00 00 83 FB 4E 0F 8F A2 00 00 00 74 A3 83 FB 2A 0F 84 84 00 00 00 83 FB 46 74 95 83 FB 49 74 14 83 FB 4C 0F 85 93 00 00 00 FE 85 77 FE FF FF E9 7C FF FF FF 8A 47 01 3C 36 75 23 8D 4F 02 80 39 34 75 1B 8B F9 FF 85 28 FE FF FF 83 A5 48 FE FF FF 00 83 A5 50 FE FF FF 00 E9 52 FF FF FF 3C 33 75 0F 8D 4F 02 80 39 32 75 07 8B F9 E9 3F FF FF FF 3C 64 0F 84 37 FF FF FF 3C 69 0F 84 9E 00 00 00 3C 6F 0F 84 27 FF FF FF 3C 78 0F 84 1F FF FF FF 3C 58 75 27 E9 16 FF FF FF 8A 95 79 FE FF FF FE C2 88 95 79 FE FF FF E9 09 FF FF FF 83 FB 68 74 57 83 FB 6C 74 1E 83 FB 77 74 2E 8A 85 7B FE FF FF 8A 95 79 FE FF FF FE C0 88 85 7B FE FF FF E9 E7 FE FF FF 8D 47 01 80 38 6C 75 07 8B F8 E9 61 FF FF FF FE 85 77 FE FF FF 8A 8D 7A FE FF FF 8A 85 7B FE FF FF 8A 95 79 FE FF FF FE C1 88 8D 7A FE FF FF E9 B9 FE FF FF 8A 8D 7A FE FF FF FE 8D 77 FE FF FF FE C9 88 8D 7A FE FF FF EB 06 8A 8D 7A FE FF FF 8A 95 79 FE FF FF 8A 85 7B FE FF FF E9 8C FE FF FF 83 A5 40 FE FF FF 00 32 C0 88 85 7B FE FF FF 84 C9 75 18 8A 07 3C 53 74 0B C6 85 7A FE FF FF FF 3C 43 75 07 C6 85 7A FE FF FF 01 0F B6 3F 83 CF 20 83 FF 6E 74 4A 83 FF 63 74 20 83 FF 7B 74 1B 8D 85 60 FE FF FF 50 E8 ?? ?? ?? ?? 8B B5 60 FE FF FF 59 89 B5 6C FE FF FF EB 12 46 89 B5 6C FE FF FF 89 B5 60 FE FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 68 FE FF FF 83 FB FF 0F 84 76 0B 00 00 EB 06 8B 9D 68 FE FF FF 8B 95 3C FE FF FF 8B 8D 70 FE FF FF 85 D2 74 08 85 C9 0F 84 4F 0B 00 00 83 FF 6F 0F 8F 3A 05 00 00 0F 84 E4 07 00 00 83 FF 63 0F 84 C0 03 00 00 83 FF 64 0F 84 D2 07 00 00 0F 8E 46 05 00 00 83 FF 67 7E 55 83 FF 69 74 38 83 FF 6E 0F 85 33 05 00 00 80 BD 79 FE FF FF 00 8B C6 0F 84 4E 0A 00 00 8B BD 58 FE FF FF 8A 85 78 FE FF FF 8B B5 6C FE FF FF FE C0 88 85 78 FE FF FF 47 E9 CB 0A 00 00 6A 64 5F 83 FB 2D 0F 85 03 06 00 00 C6 85 5F FE FF FF 01 E9 FC 05 00 00 33 F6 83 FB 2D 75 0B 8B 85 54 FE FF FF 46 88 18 EB 05 83 FB 2B 75 23 8B BD 6C FE FF FF 49 89 8D 70 FE FF FF 47 E8 ?? ?? ?? ?? 8B 95 3C FE FF FF 8B D8 89 9D 68 FE FF FF EB 06 8B BD 6C FE FF FF 85 D2 75 09 83 C8 FF 89 85 70 FE FF FF 0F B6 C3 50 E8 ?? ?? ?? ?? 59 8B 8D 70 FE FF FF 85 C0 74 5A 8B C1 49 89 8D 70 FE FF FF 85 C0 74 4D 8B 85 54 FE FF FF FF 85 4C FE FF FF 88 1C 06 8D 85 30 FE FF FF 50 8D 85 7C FE FF FF 50 8D 85 54 FE FF FF 50 8D 85 24 FE FF FF 50 46 56 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 84 2A 0A 00 00 47 E8 ?? ?? ?? ?? 8B D8 89 9D 68 FE FF FF EB 92 8B 85 00 FE FF FF 8B 80 84 00 00 00 8B 00 8A 18 8B 85 68 FE FF FF 3A D8 0F 85 CA 00 00 00 8B C1 49 89 8D 70 FE FF FF 85 C0 0F 84 B9 00 00 00 47 E8 ?? ?? ?? ?? 89 85 68 FE FF FF 8B 85 54 FE FF FF 88 1C 06 8D 85 30 FE FF FF 50 8D 85 7C FE FF FF 50 8D 85 54 FE FF FF 50 8D 85 24 FE FF FF 50 46 56 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 84 A8 09 00 00 8B 9D 68 FE FF FF EB 5E 8B 8D 70 FE FF FF 8B C1 49 89 8D 70 FE FF FF 85 C0 74 61 8B 85 54 FE FF FF FF 85 4C FE FF FF 88 1C 06 8D 85 30 FE FF FF 50 8D 85 7C FE FF FF 50 8D 85 54 FE FF FF 50 8D 85 24 FE FF FF 50 46 56 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 84 50 09 00 00 47 E8 ?? ?? ?? ?? 8B D8 89 9D 68 FE FF FF 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 75 94 EB 06 8B 9D 68 FE FF FF 83 BD 4C FE FF FF 00 0F 84 35 01 00 00 83 FB 65 74 09 83 FB 45 0F 85 27 01 00 00 8B 8D 70 FE FF FF 8B C1 49 89 8D 70 FE FF FF 85 C0 0F 84 10 01 00 00 8B 85 54 FE FF FF C6 04 06 65 8D 85 30 FE FF FF 50 8D 85 7C FE FF FF 50 8D 85 54 FE FF FF 50 8D 85 24 FE FF FF 50 46 56 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 84 C2 08 00 00 47 E8 ?? ?? ?? ?? 8B D8 89 9D 68 FE FF FF 83 FB 2D 75 39 8B 85 54 FE FF FF 88 1C 06 8D 85 30 FE FF FF 50 8D 85 7C FE FF FF 50 8D 85 54 FE FF FF 50 8D 85 24 FE FF FF 50 46 56 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 84 78 08 00 00 EB 05 83 FB 2B 75 79 8B 8D 70 FE FF FF 8B C1 49 89 8D 70 FE FF FF 85 C0 75 58 89 85 70 FE FF FF EB 5E 8B 8D 70 FE FF FF 8B C1 49 89 8D 70 FE FF FF 85 C0 74 59 8B 85 54 FE FF FF FF 85 4C FE FF FF 88 1C 06 8D 85 30 FE FF FF 50 8D 85 7C FE FF FF 50 8D 85 54 FE FF FF 50 8D 85 24 FE FF FF 50 46 56 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 84 06 08 00 00 47 E8 ?? ?? ?? ?? 8B D8 89 9D 68 FE FF FF 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 75 94 4F 53 89 BD 6C FE FF FF 89 BD 60 FE FF FF E8 ?? ?? ?? ?? 83 BD 4C FE FF FF 00 59 0F 84 C9 07 00 00 80 BD 79 FE FF FF 00 0F 85 AF FC FF FF 8B 85 54 FE FF FF FF 85 34 FE FF FF 8D 8D 00 FE FF FF 51 8B 8D 40 FE FF FF 50 C6 04 06 00 0F BE 85 77 FE FF FF 51 48 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF D0 83 C4 10 E9 71 FC FF FF 85 D2 75 11 41 C7 85 3C FE FF FF 01 00 00 00 89 8D 70 FE FF FF 8A 85 7A FE FF FF 84 C0 7E 07 C6 85 67 FE FF FF 01 8B 85 6C FE FF FF 8B B5 40 FE FF FF 48 53 89 85 6C FE FF FF 89 85 60 FE FF FF E8 ?? ?? ?? ?? 59 83 BD 3C FE FF FF 00 74 17 8B 8D 70 FE FF FF 8B C1 49 89 8D 70 FE FF FF 85 C0 0F 84 63 03 00 00 8B 85 6C FE FF FF 40 89 85 6C FE FF FF 89 85 60 FE FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 68 FE FF FF 83 FF 63 74 46 83 FF 73 75 13 83 FB 09 7C 09 83 FB 0D 0F 8E 11 03 00 00 83 FB 20 75 2E 83 FF 7B 0F 85 03 03 00 00 33 D2 8B CB 83 E1 07 8B C3 C1 F8 03 42 D3 E2 0F BE 4C 05 DC 0F BE 85 47 FE FF FF 33 C8 85 D1 0F 84 DE 02 00 00 80 BD 79 FE FF FF 00 0F 85 CB 02 00 00 80 BD 67 FE FF FF 00 0F 84 AA 02 00 00 0F B6 C3 50 88 9D 20 FE FF FF E8 ?? ?? ?? ?? 59 85 C0 74 1E 8B 85 6C FE FF FF 40 89 85 6C FE FF FF 89 85 60 FE FF FF E8 ?? ?? ?? ?? 88 85 21 FE FF FF 8D 85 00 FE FF FF 50 8B 85 00 FE FF FF C7 85 1C FE FF FF 3F 00 00 00 FF 70 74 8D 85 20 FE FF FF 50 8D 85 1C FE FF FF 50 E8 ?? ?? ?? ?? 8B 8D 40 FE FF FF 66 8B 85 1C FE FF FF 83 C4 10 66 89 01 83 C1 02 89 8D 40 FE FF FF E9 DB FE FF FF 8B C7 83 E8 70 0F 84 9E 02 00 00 83 E8 03 0F 84 96 FE FF FF 48 48 0F 84 94 02 00 00 83 E8 03 0F 84 04 FB FF FF 83 E8 03 74 37 8B BD 58 FE FF FF 0F B6 07 3B C3 0F 85 D1 05 00 00 8A 85 78 FE FF FF FE C8 80 BD 79 FE FF FF 00 0F 85 C2 FA FF FF 8B 8D 14 FE FF FF 89 8D 18 FE FF FF E9 B1 FA FF FF 8A 85 7A FE FF FF 84 C0 7E 07 C6 85 67 FE FF FF 01 8B B5 58 FE FF FF 46 80 3E 5E 75 08 46 C6 85 47 FE FF FF FF 6A 20 8D 45 DC 6A 00 50 E8 ?? ?? ?? ?? 83 C4 0C 80 3E 5D 75 09 B4 5D 46 C6 45 E7 20 EB 78 8A A5 2F FE FF FF EB 70 46 3C 2D 75 56 84 E4 74 52 8A 0E 80 F9 5D 74 4B 46 89 B5 58 FE FF FF 3A E1 73 04 8A C1 EB 04 8A C4 8A E1 0F B6 F0 EB 10 8B D1 83 E1 07 D2 E0 C1 EA 03 08 44 15 DC FE C4 0F B6 CC B0 01 3B CE 7C E7 8B D6 83 E6 07 8B CE 8B B5 58 FE FF FF D2 E0 C1 EA 03 08 44 15 DC 32 E4 EB 15 0F B6 C8 8A E0 8B D1 83 E1 07 B0 01 D2 E0 C1 EA 03 08 44 15 DC 8A 06 3C 5D 75 8A 84 C0 0F 84 E9 04 00 00 89 B5 58 FE FF FF E9 86 FD FF FF 83 FB 2B 75 31 49 89 8D 70 FE FF FF 75 0E 85 D2 74 0A B0 01 88 85 7B FE FF FF EB 1A 46 89 B5 6C FE FF FF 89 B5 60 FE FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 68 FE FF FF 83 FB 30 0F 85 7A 01 00 00 46 89 B5 6C FE FF FF 89 B5 60 FE FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 68 FE FF FF 80 FB 78 74 56 80 FB 58 74 51 C7 85 4C FE FF FF 01 00 00 00 83 FF 78 74 26 83 BD 3C FE FF FF 00 74 15 8B 85 70 FE FF FF 48 89 85 70 FE FF FF 75 06 FE 85 7B FE FF FF 6A 6F 5F E9 21 01 00 00 4E 53 89 B5 6C FE FF FF 89 B5 60 FE FF FF E8 ?? ?? ?? ?? 59 6A 30 5B E9 FF 00 00 00 46 89 B5 6C FE FF FF 89 B5 60 FE FF FF E8 ?? ?? ?? ?? 83 BD 3C FE FF FF 00 8B D8 89 9D 68 FE FF FF 74 1A 8B 85 70 FE FF FF 83 E8 02 89 85 70 FE FF FF 83 F8 01 7D 06 FE 85 7B FE FF FF 6A 78 EB 9D 8B 85 40 FE FF FF 88 18 40 89 85 40 FE FF FF E9 9D FC FF FF 46 E9 97 FC FF FF 8B 85 6C FE FF FF 48 53 89 85 6C FE FF FF 89 85 60 FE FF FF E8 ?? ?? ?? ?? 59 8B 85 40 FE FF FF 3B F0 0F 84 A7 03 00 00 80 BD 79 FE FF FF 00 0F 85 8D F8 FF FF FF 85 34 FE FF FF 83 FF 63 0F 84 7E F8 FF FF 80 BD 67 FE FF FF 00 8B BD 58 FE FF FF 74 0A 33 C9 66 89 08 E9 6B F8 FF FF C6 00 00 E9 63 F8 FF FF C6 85 77 FE FF FF 01 83 FB 2D 75 09 C6 85 5F FE FF FF 01 EB 05 83 FB 2B 75 2B 49 89 8D 70 FE FF FF 75 08 85 D2 74 04 B0 01 EB 20 46 89 B5 6C FE FF FF 89 B5 60 FE FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 68 FE FF FF 8A 85 7B FE FF FF 83 BD 28 FE FF FF 00 0F 84 49 01 00 00 84 C0 0F 85 10 01 00 00 83 FF 78 74 61 83 FF 70 74 5C 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 0F 84 E0 00 00 00 83 FF 6F 75 24 83 FB 38 0F 8D D2 00 00 00 8B 85 50 FE FF FF 8B 8D 48 FE FF FF 0F A4 C8 03 89 85 50 FE FF FF C1 E1 03 EB 67 8B 8D 50 FE FF FF 6A 00 6A 0A 51 8B 8D 48 FE FF FF 51 E8 ?? ?? ?? ?? 8B C8 89 95 50 FE FF FF EB 46 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 0F 84 84 00 00 00 8B 85 48 FE FF FF 8B 8D 50 FE FF FF 0F A4 C1 04 C1 E0 04 53 89 8D 50 FE FF FF 89 85 48 FE FF FF E8 ?? ?? ?? ?? 8B D8 59 8B 8D 48 FE FF FF 89 9D 68 FE FF FF FF 85 4C FE FF FF 8D 43 D0 99 03 C8 8B 85 50 FE FF FF 13 C2 83 BD 3C FE FF FF 00 89 8D 48 FE FF FF 89 85 50 FE FF FF 74 08 FF 8D 70 FE FF FF 74 3F 46 89 B5 6C FE FF FF 89 B5 60 FE FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 68 FE FF FF E9 04 FF FF FF 4E 53 89 B5 6C FE FF FF 89 B5 60 FE FF FF E8 ?? ?? ?? ?? 59 8B 85 50 FE FF FF 8B 8D 48 FE FF FF 80 BD 5F FE FF FF 00 0F 84 F6 00 00 00 F7 D9 83 D0 00 F7 D8 89 8D 48 FE FF FF 89 85 50 FE FF FF E9 DE 00 00 00 84 C0 0F 85 BF 00 00 00 83 FF 78 74 3B 83 FF 70 74 36 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 0F 84 8F 00 00 00 83 FF 6F 75 14 83 FB 38 0F 8D 81 00 00 00 8B 85 38 FE FF FF C1 E0 03 EB 35 8B 85 38 FE FF FF 6B C0 0A EB 2A 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 5D C1 A5 38 FE FF FF 04 53 E8 ?? ?? ?? ?? 8B D8 8B 85 38 FE FF FF 59 89 9D 68 FE FF FF FF 85 4C FE FF FF 83 C0 D0 03 C3 83 BD 3C FE FF FF 00 89 85 38 FE FF FF 74 08 FF 8D 70 FE FF FF 74 39 46 89 B5 6C FE FF FF 89 B5 60 FE FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 68 FE FF FF E9 55 FF FF FF 4E 53 89 B5 6C FE FF FF 89 B5 60 FE FF FF E8 ?? ?? ?? ?? 59 8B 85 38 FE FF FF 80 BD 5F FE FF FF 00 74 08 F7 D8 89 85 38 FE FF FF 83 EF 46 F7 DF 1B FF 23 BD 4C FE FF FF 0F 84 D8 00 00 00 80 BD 79 FE FF FF 00 0F 85 BE F5 FF FF FF 85 34 FE FF FF 8B 85 38 FE FF FF 83 BD 28 FE FF FF 00 74 1C 8B 85 40 FE FF FF 8B 8D 48 FE FF FF 89 08 8B 8D 50 FE FF FF 89 48 04 E9 8D F5 FF FF 8A 8D 77 FE FF FF 8B BD 58 FE FF FF 84 C9 8B 8D 40 FE FF FF 74 07 89 01 E9 76 F5 FF FF 66 89 01 E9 6E F5 FF FF 3C 25 75 06 38 47 01 75 01 47 46 89 B5 6C FE FF FF 89 B5 60 FE FF FF E8 ?? ?? ?? ?? 8B D8 0F B6 07 47 89 9D 68 FE FF FF 3B C3 75 42 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 19 E8 ?? ?? ?? ?? 0F B6 0F 47 3B C8 75 18 89 B5 60 FE FF FF 89 B5 6C FE FF FF 8A 07 84 C0 0F 85 DE F1 FF FF EB 16 50 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 59 EB 06 53 E8 ?? ?? ?? ?? 59 83 BD 30 FE FF FF 01 75 0C FF B5 54 FE FF FF E8 ?? ?? ?? ?? 59 8B 9D 34 FE FF FF 80 BD 0C FE FF FF 00 5E 74 0A 8B 8D 08 FE FF FF 83 61 70 FD 8B C3 8B 4D FC 5F 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_210_8_0 {
	meta:
		name = "__hextodec"
		size = 33
		refs = "000c _isdigit"
	strings:
		$1 = { 55 8B EC 53 8A 5D 08 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 0F BE C3 75 06 83 E0 DF 83 E8 07 5B 5D C3 }
	condition:
		$1
}

rule file_210_10_0 {
	meta:
		name = "__un_inc"
		size = 17
		refs = "000b __ungetch_nolock"
	strings:
		$1 = { 55 8B EC 83 7D 08 FF 74 06 5D E9 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_763_8_0 {
	meta:
		name = "__un_inc"
		size = 17
		refs = "000b __ungetc_nolock"
	strings:
		$1 = { 55 8B EC 83 7D 08 FF 74 06 5D E9 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_210_11_0 {
	meta:
		name = "__whiteout"
		size = 42
		refs = "000b __getche_nolock 001b _isspace"
	strings:
		$1 = { 55 8B EC 53 56 8B 75 08 FF 06 E8 ?? ?? ?? ?? 8B D8 83 FB FF 74 0E 0F B6 CB 51 E8 ?? ?? ?? ?? 59 85 C0 75 E4 5E 8B C3 5B 5D C3 }
	condition:
		$1
}

rule file_211_0_0 {
	meta:
		name = "__vfprintf_l"
		size = 30
		refs = "0010 __output_l 0015 _vfprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_211_2_0 {
	meta:
		name = "__vfprintf_p_l"
		size = 30
		refs = "0010 __output_p_l 0015 _vfprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_211_3_0 {
	meta:
		name = "__vfprintf_s_l"
		size = 30
		refs = "0010 __output_s_l 0015 _vfprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_755_0_0 {
	meta:
		name = "__vfwprintf_l"
		size = 30
		refs = "0010 __woutput_l 0015 _vfwprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_755_2_0 {
	meta:
		name = "__vfwprintf_p_l"
		size = 30
		refs = "0010 __woutput_p_l 0015 _vfwprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_755_3_0 {
	meta:
		name = "__vfwprintf_s_l"
		size = 30
		refs = "0010 __woutput_s_l 0015 _vfwprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_211_1_0 {
	meta:
		name = "__vfprintf_p"
		size = 29
		refs = "000f __output_p_l 0014 _vfprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 10 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_755_1_0 {
	meta:
		name = "__vfwprintf_p"
		size = 29
		refs = "000f __woutput_p_l 0014 _vfwprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 10 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_211_4_0 {
	meta:
		name = "_vfprintf"
		size = 29
		refs = "000f __output_l 0014 _vfprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 10 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_211_6_0 {
	meta:
		name = "_vfprintf_s"
		size = 29
		refs = "000f __output_s_l 0014 _vfprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 10 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_755_4_0 {
	meta:
		name = "_vfwprintf"
		size = 29
		refs = "000f __woutput_l 0014 _vfwprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 10 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_755_6_0 {
	meta:
		name = "_vfwprintf_s"
		size = 29
		refs = "000f __woutput_s_l 0014 _vfwprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 10 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_211_5_0 {
	meta:
		name = "_vfprintf_helper"
		size = 282
		refs = "0003 __sehtable$_vfprintf_helper 0008 __SEH_prolog4 0020 __errno 002b __invalid_parameter_noinfo 0044 __ioinit 0051 __lock_file 0061 __fileno 0080 ___pioinfo 0087 ___badioinfo 00d6 __stbuf 00f1 __ftbuf 0107 __SEH_epilog4 0114 __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D E4 33 C0 8B 7D 0C 85 FF 0F 95 C0 85 C0 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 CF 00 00 00 33 C0 39 45 10 0F 95 C0 85 C0 74 DC E8 ?? ?? ?? ?? 85 C0 78 E3 89 7D 0C 57 E8 ?? ?? ?? ?? 59 89 5D FC F6 47 0C 40 75 71 57 E8 ?? ?? ?? ?? 59 8B D0 83 FA FF 74 19 83 FA FE 74 14 8B CA C1 F9 05 83 E0 1F C1 E0 06 03 04 8D ?? ?? ?? ?? EB 05 B8 ?? ?? ?? ?? F6 40 24 7F 75 29 83 FA FF 74 19 83 FA FE 74 14 8B C2 C1 F8 05 83 E2 1F C1 E2 06 03 14 85 ?? ?? ?? ?? EB 05 BA ?? ?? ?? ?? F6 42 24 80 74 16 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 CB FF 89 5D E4 85 DB 75 24 57 E8 ?? ?? ?? ?? 8B F0 FF 75 18 FF 75 14 FF 75 10 57 FF 55 08 8B D8 89 5D E4 57 56 E8 ?? ?? ?? ?? 83 C4 1C C7 45 FC FE FF FF FF E8 0E 00 00 00 8B C3 E8 ?? ?? ?? ?? C3 8B 5D E4 8B 7D 0C 57 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_212_12_0 {
	meta:
		name = "?AssociateExecutionContext@FreeThreadProxy@details@Concurrency@@QAEXPAUIExecutionContext@3@@Z"
		size = 21
	strings:
		$1 = { 55 8B EC 8B D1 8B 4D 08 89 4A 40 8B 01 52 FF 50 0C 5D C2 04 00 }
	condition:
		$1
}

rule file_212_13_0 {
	meta:
		name = "?Dispatch@FreeThreadProxy@details@Concurrency@@EAEXXZ"
		size = 122
		refs = "002b __imp__TlsSetValue@8 0056 ?ReturnIdleProxy@FreeThreadProxy@details@Concurrency@@QAEXXZ 0063 ?ResetOnIdle@FreeVirtualProcessorRoot@details@Concurrency@@QAEXW4SwitchingProxyState@3@@Z 006c ?SuspendExecution@ThreadProxy@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 51 53 56 8B F1 33 DB C7 45 F8 08 00 00 00 89 5D FC 39 5E 24 75 5C 8B 4E 04 8B C6 83 C8 01 50 8B 01 FF 50 10 50 FF 15 ?? ?? ?? ?? 39 5E 24 75 42 57 8B 4E 40 56 8B 01 FF 50 0C 8B 4E 40 8D 55 F8 8B 01 52 FF 50 10 8B 7E 10 8B CE 89 5E 40 89 5E 10 E8 ?? ?? ?? ?? 85 FF 74 0B 6A 01 8B CF E8 ?? ?? ?? ?? EB 07 8B CE E8 ?? ?? ?? ?? 39 5E 24 74 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_212_16_0 {
	meta:
		name = "?ReturnIdleProxy@FreeThreadProxy@details@Concurrency@@QAEXXZ"
		size = 16
	strings:
		$1 = { 8B D1 52 8B 4A 04 83 62 40 00 8B 01 FF 50 04 C3 }
	condition:
		$1
}

rule file_212_17_0 {
	meta:
		name = "?SwitchOut@FreeThreadProxy@details@Concurrency@@UAEXW4SwitchingProxyState@3@@Z"
		size = 98
		refs = "002a ?ResetOnIdle@FreeVirtualProcessorRoot@details@Concurrency@@QAEXW4SwitchingProxyState@3@@Z 0033 ?SuspendExecution@ThreadProxy@details@Concurrency@@QAEXXZ 0043 ??_C@_0M@CIMHMGAD@switchState?$AA@ 0048 ??0exception@std@@QAE@ABQBD@Z 004d __TI3?AVinvalid_argument@std@@ 0058 ??_7invalid_argument@std@@6B@ 005d __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 EC 0C 85 C0 74 2C 8B 51 10 85 D2 75 09 83 F8 01 75 20 85 D2 74 15 83 F8 02 75 04 83 61 10 00 50 8B CA E8 ?? ?? ?? ?? C9 C2 04 00 E8 ?? ?? ?? ?? EB F5 8D 45 08 50 8D 4D F4 C7 45 08 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 C7 45 F4 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_212_18_0 {
	meta:
		name = "?SwitchTo@FreeThreadProxy@details@Concurrency@@UAEXPAUIExecutionContext@3@W4SwitchingProxyState@3@@Z"
		size = 162
		refs = "0046 ?Affinitize@FreeVirtualProcessorRoot@details@Concurrency@@QAEXPAVFreeThreadProxy@23@@Z 005e __imp__SignalObjectAndWait@16 006e ?ResumeExecution@ThreadProxy@details@Concurrency@@QAEXXZ 0083 ??_C@_08BAFMHLII@pContext?$AA@ 0088 ??0exception@std@@QAE@ABQBD@Z 008d __TI3?AVinvalid_argument@std@@ 0098 ??_7invalid_argument@std@@6B@ 009d __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 83 EC 0C 53 8B 5D 08 56 57 8B F9 85 DB 74 67 8B 03 8B CB FF 50 08 8B F0 85 F6 75 0E 8B 47 10 53 8B 48 1C 8B 01 FF 50 1C 8B F0 8B 4F 10 8B 5D 0C 83 67 10 00 83 FB 01 75 08 33 D2 42 8D 47 20 87 10 56 E8 ?? ?? ?? ?? 83 EB 00 74 1C 4B 75 19 6A 01 6A FF FF 77 0C FF 76 0C FF 15 ?? ?? ?? ?? 33 C9 8D 47 20 87 08 EB 07 8B CE E8 ?? ?? ?? ?? 5F 5E 5B C9 C2 08 00 8D 45 08 50 8D 4D F4 C7 45 08 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 C7 45 F4 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_213_0_0 {
	meta:
		name = "_memmove_s"
		size = 76
		refs = "0012 __errno 001c __invalid_parameter_noinfo 0040 _memmove"
	strings:
		$1 = { 55 8B EC 8B 45 14 56 85 C0 74 3C 83 7D 08 00 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 25 83 7D 10 00 74 E7 39 45 0C 73 09 E8 ?? ?? ?? ?? 6A 22 EB E0 50 FF 75 10 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_215_0_0 {
	meta:
		name = "_setvbuf"
		size = 262
		refs = "0003 __sehtable$_setvbuf 0008 __SEH_prolog4 0020 __errno 002b __invalid_parameter_noinfo 006e __lock_file 0078 __flush 007e __freebuf 00ad __malloc_crt 00b8 __cflush 00f3 __SEH_epilog4 0100 __unlock_file"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D E4 33 C0 8B 75 08 85 F6 0F 95 C0 85 C0 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 BB 00 00 00 8B 5D 10 83 FB 04 74 09 85 DB 74 13 83 FB 40 75 D7 85 DB 74 0A 83 FB 40 74 05 8B 4D 14 EB 0D 8B 4D 14 8D 41 FE 3D FD FF FF 7F 77 BC 83 E1 FE 89 4D 08 89 75 E0 56 E8 ?? ?? ?? ?? 59 89 7D FC 56 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 81 66 0C F3 C2 FF FF 8B 4E 0C F6 C3 04 74 0E 83 C9 04 89 4E 0C 8D 46 14 6A 02 5B EB 38 8B 45 0C 85 C0 75 25 8B 5D 08 53 E8 ?? ?? ?? ?? 59 85 C0 75 0E FF 05 ?? ?? ?? ?? 83 CF FF 89 7D E4 EB 20 81 4E 0C 08 04 00 00 EB 0C 81 C9 00 05 00 00 89 4E 0C 8B 5D 08 89 5E 18 89 46 08 89 06 89 7E 04 C7 45 FC FE FF FF FF E8 0E 00 00 00 8B C7 E8 ?? ?? ?? ?? C3 8B 7D E4 8B 75 E0 56 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_216_0_0 {
	meta:
		name = "___avx_sin4"
		size = 2368
		refs = "0012 ___common_dsin_data 0145 ___common_dsin_cout_rare 015d ___common_dsin_data_ha 01d6 ___common_dsin_reduction_data 023e _2il0floatpacket_266 0260 _2il0floatpacket_267 026d _2il0floatpacket_268 05fb _2il0floatpacket_269 0636 _2il0floatpacket_270 0650 _2il0floatpacket_271 066f _2il0floatpacket_272 0677 _2il0floatpacket_273 06c4 _2il0floatpacket_274 06d4 _2il0floatpacket_275 072f _2il0floatpacket_279 0740 _2il0floatpacket_276 0749 _2il0floatpacket_277 0752 _2il0floatpacket_278 078c _2il0floatpacket_280 0799 _2il0floatpacket_281"
	strings:
		$1 = { 55 8B EC 83 E4 C0 57 53 81 EC B8 02 00 00 C5 FD 10 1D ?? ?? ?? ?? C5 E5 55 F0 C5 FD 54 DB C5 E5 C2 0D ?? ?? ?? ?? 1E C4 E3 7D 19 CA 01 C5 F0 C6 E2 DD C5 F8 50 C4 85 C0 0F 85 10 01 00 00 C5 FD 10 0D ?? ?? ?? ?? 33 DB C5 E5 59 3D ?? ?? ?? ?? C5 C5 58 D1 C5 ED 5C E9 C5 D9 73 F2 3F C4 E3 7D 19 D7 01 C5 D5 59 15 ?? ?? ?? ?? C5 F1 73 F7 3F C5 E5 5C DA C4 E3 5D 18 E1 01 C5 D5 59 0D ?? ?? ?? ?? C5 E5 5C D1 C5 D5 59 1D ?? ?? ?? ?? C5 D5 59 2D ?? ?? ?? ?? C5 ED 5C FB C5 C5 5C CD C5 F5 59 D1 C5 F5 57 CC C5 ED 59 25 ?? ?? ?? ?? C5 DD 58 1D ?? ?? ?? ?? C5 E5 59 E2 C5 DD 58 2D ?? ?? ?? ?? C5 D5 59 FA C5 C5 58 1D ?? ?? ?? ?? C5 E5 59 E2 C5 DD 58 2D ?? ?? ?? ?? C5 D5 59 FA C5 C5 58 1D ?? ?? ?? ?? C5 E5 59 E2 C5 DD 58 2D ?? ?? ?? ?? C5 D5 59 D2 C5 ED 59 D1 C5 ED 58 C9 C5 F5 57 CE 85 DB 75 10 C5 FD 28 C1 81 C4 B8 02 00 00 5B 5F 8B E5 5D C3 C5 FD 11 04 24 C5 FD 11 4C 24 40 74 E3 33 FF 0F A3 FB 72 0E 47 83 FF 20 7C F5 C5 FD 10 4C 24 40 EB CE C5 F8 77 8D 44 FC 40 8D 14 FC 50 52 E8 ?? ?? ?? ?? 83 C4 08 EB DC C5 FD 11 74 24 20 BF 00 00 F0 7F C5 FD 10 35 ?? ?? ?? ?? C5 FD 11 1C 24 C5 FD 11 44 24 40 C5 F9 6E D7 C5 CD 54 E3 C5 DD C2 CE 00 C5 F9 70 E2 11 C4 E3 7D 19 CF 01 C5 F0 C6 EF DD C5 F8 50 DD C5 D9 DB C3 C4 E3 7D 19 DD 01 C5 F1 73 D0 34 C5 D9 DB F5 C5 E9 73 D6 34 C5 F9 7E D0 C5 F9 7E C9 C5 F8 11 9C 24 C0 00 00 00 C5 F8 11 AC 24 D0 00 00 00 C4 E3 79 16 D7 02 8D 04 40 C4 E3 79 16 CA 02 8D 0C 49 C5 FA 7E 04 C5 ?? ?? ?? ?? C5 FA 7E 24 CD ?? ?? ?? ?? C5 FA 7E 14 CD ?? ?? ?? ?? 8D 3C 7F C5 F9 16 34 FD ?? ?? ?? ?? 8D 14 52 C5 D9 16 04 D5 ?? ?? ?? ?? C5 E9 16 24 D5 ?? ?? ?? ?? C5 FA 7E 14 C5 ?? ?? ?? ?? C5 F9 11 A4 24 00 01 00 00 C5 E9 16 24 FD ?? ?? ?? ?? C5 F9 11 A4 24 10 01 00 00 C5 FA 7E 3C CD ?? ?? ?? ?? C5 FA 6F 25 ?? ?? ?? ?? C5 FA 7E 0C C5 ?? ?? ?? ?? C5 D9 DB D3 C5 C1 16 3C D5 ?? ?? ?? ?? C5 D9 DB ED C5 FA 6F 1D ?? ?? ?? ?? B8 00 00 00 80 C5 FA 6F 25 ?? ?? ?? ?? C5 F1 16 0C FD ?? ?? ?? ?? C5 F9 11 BC 24 E0 00 00 00 C5 E9 D4 D3 C5 D1 D4 DB C5 C1 DB EC C5 C1 73 D0 20 C5 FA 7F BC 24 40 01 00 00 C5 C1 73 D1 20 C5 F1 DB CC C5 F9 DB C4 C5 FA 7F 8C 24 70 01 00 00 C5 F9 10 8C 24 00 01 00 00 C5 F1 73 D1 20 C5 FA 7F 8C 24 80 01 00 00 C5 F9 10 8C 24 10 01 00 00 C5 F1 73 D1 20 C5 FA 7F 8C 24 90 01 00 00 C5 F1 73 D2 20 C5 FA 7F 8C 24 A0 01 00 00 C5 F1 73 D3 20 C5 E1 DB DC C5 E9 DB D4 C5 F9 11 B4 24 F0 00 00 00 C5 C9 DB F4 C5 FA 7F BC 24 50 01 00 00 C5 E1 F4 FF C5 FA 7F B4 24 30 01 00 00 C5 E1 F4 F6 C5 FA 7F AC 24 20 01 00 00 C5 E9 F4 ED C5 FA 7F BC 24 00 02 00 00 C5 E9 F4 F8 C5 FA 7F B4 24 E0 01 00 00 C5 E9 F4 B4 24 40 01 00 00 C5 FA 7F 84 24 60 01 00 00 C5 FA 7F AC 24 D0 01 00 00 C5 D9 DB AC 24 00 01 00 00 C5 FA 6F 84 24 A0 01 00 00 C5 FA 7F BC 24 10 02 00 00 C5 FA 7F B4 24 F0 01 00 00 C5 F9 F4 F5 C5 C1 DB EC C5 FA 6F BC 24 80 01 00 00 C5 C9 73 D6 20 C5 FA 7F 94 24 B0 01 00 00 C5 E9 F4 D7 C5 F9 F4 C7 C5 C1 73 D2 20 C5 F9 D4 C7 C5 FA 7F 9C 24 C0 01 00 00 C5 E1 F4 9C 24 70 01 00 00 C5 D1 D4 F8 C5 C9 D4 EF C5 D9 DB B4 24 10 01 00 00 C5 FA 7F 9C 24 20 02 00 00 C5 F1 F4 D6 C5 E1 DB F4 C5 FA 6F 9C 24 90 01 00 00 C5 C1 73 D2 20 C5 F1 F4 C3 C5 E1 F4 9C 24 C0 01 00 00 C5 E9 73 D3 20 C5 F9 D4 C2 C5 C9 D4 F0 C5 FA 6F 84 24 A0 01 00 00 C5 C1 D4 D6 C5 F9 F4 B4 24 60 01 00 00 C5 FA 6F 9C 24 10 02 00 00 C5 E1 73 D3 20 C5 C9 D4 F3 C5 D9 DB BC 24 F0 01 00 00 C5 C1 D4 FE C5 F1 F4 B4 24 70 01 00 00 C5 FA 6F 9C 24 20 02 00 00 C5 E1 73 D3 20 C5 FA 7F AC 24 30 02 00 00 C5 D1 73 D5 20 C5 C9 D4 F3 C5 D1 D4 FF C5 D9 DB AC 24 00 02 00 00 C5 E1 73 D7 20 C5 D1 D4 EE C5 F9 F4 B4 24 40 01 00 00 C5 FA 7F 94 24 40 02 00 00 C5 E9 73 D2 20 C5 E9 D4 ED C5 FA 6F 94 24 F0 01 00 00 C5 E9 73 D2 20 C5 C9 D4 F2 C5 F1 F4 94 24 50 01 00 00 C5 FA 7F BC 24 50 02 00 00 C5 D9 DB BC 24 D0 01 00 00 C5 C1 D4 FE C5 E1 D4 F7 C5 FA 6F 9C 24 00 02 00 00 C5 E1 73 D3 20 C5 E9 D4 D3 C5 D9 DB BC 24 E0 01 00 00 C5 E1 73 D6 20 C5 C1 D4 FA C5 FA 7F AC 24 60 02 00 00 C5 D1 73 D5 20 C5 D1 D4 D7 C5 F9 10 AC 24 E0 00 00 00 C5 C9 DB F4 C5 C1 73 D5 20 C5 C1 F4 AC 24 B0 01 00 00 C5 F9 F4 BC 24 20 01 00 00 C5 FA 6F 84 24 D0 01 00 00 C5 D1 DB EC C5 F9 73 D0 20 C5 C1 D4 F8 C5 D1 D4 EF C5 E1 D4 DD C5 C1 73 F3 20 C5 D1 73 D2 20 C5 C1 D4 DE C5 F9 10 B4 24 F0 00 00 00 C5 E9 DB D4 C5 C1 73 D6 20 C5 C1 F4 84 24 C0 01 00 00 C5 F1 F4 B4 24 30 01 00 00 C5 FA 6F 8C 24 E0 01 00 00 C5 F9 DB FC C5 F1 73 D1 20 C5 C9 D4 C1 C5 C1 D4 F8 C5 D1 D4 EF C5 C9 73 F5 20 C5 C9 D4 CA C5 FA 6F B4 24 50 02 00 00 C5 FA 6F 94 24 60 02 00 00 C5 C1 73 F6 20 C5 F9 6E F0 C5 F9 73 F2 20 C5 D9 DB AC 24 30 02 00 00 C5 D9 DB A4 24 40 02 00 00 C5 F9 70 D6 11 C5 E9 DB B4 24 D0 00 00 00 C5 C1 D4 ED C5 F9 D4 FC C5 E9 DB A4 24 C0 00 00 00 C5 FA 6F 15 ?? ?? ?? ?? C5 FA 7F 9C 24 70 02 00 00 C5 E1 73 D3 0C C5 D9 EF C2 C5 C9 EF D2 C5 FA 7F 8C 24 80 02 00 00 C5 F1 73 D1 0C C5 E1 EB D8 C5 F1 EB CA C4 E3 65 18 D1 01 C4 E2 7D 1A 1D ?? ?? ?? ?? C5 E5 58 CA C5 F5 5C C3 C5 ED 5C D8 C5 FD 11 5C 24 60 C5 F8 10 1D ?? ?? ?? ?? C5 F1 DB D3 C4 E3 7D 19 C8 01 C5 FA 7F 94 24 90 02 00 00 C5 F8 54 CB C5 FA 6F 15 ?? ?? ?? ?? C5 FA 6F 05 ?? ?? ?? ?? C5 D9 EF DA C5 F8 11 8C 24 A0 02 00 00 C5 C9 EF CA C5 F9 DB D5 C5 F9 DB C7 C5 E9 73 F2 1C C5 F9 73 F0 1C C5 E9 EB D3 C5 F9 EB C1 C5 D1 73 D5 18 C5 C1 73 D7 18 C4 E3 6D 18 D0 01 C4 E3 65 18 C9 01 C5 ED 5C D1 C5 FA 6F 0D ?? ?? ?? ?? C5 D9 EF D9 C5 C9 EF C9 C5 FA 6F 35 ?? ?? ?? ?? C5 C9 DB A4 24 70 02 00 00 C5 C9 DB B4 24 80 02 00 00 C5 F9 73 F4 28 C5 F9 EB ED C5 F9 73 F6 28 C5 F9 EB F7 C5 D1 EB E3 C5 C9 EB F9 C4 E3 5D 18 EF 01 C5 FD 10 64 24 60 C4 E3 65 18 C9 01 C5 D5 5C F1 C5 DD 58 C6 C5 DD 5C C8 C5 CD 58 F9 C5 C5 58 F2 C4 E2 7D 1A 15 ?? ?? ?? ?? C5 FD 54 FA C5 FD 5C C7 C4 E2 7D 1A 2D ?? ?? ?? ?? C4 E2 7D 1A 1D ?? ?? ?? ?? C4 E2 7D 1A 25 ?? ?? ?? ?? C5 E5 59 D7 C5 E5 59 C8 C5 DD 59 DF C5 D5 59 EE C5 DD 59 C0 C5 F5 58 F3 C5 D5 58 C8 C5 CD 58 D9 C5 ED 58 EB C5 ED 5C FD C5 C5 58 C3 C5 FD 10 1C 24 C4 E2 7D 1A 15 ?? ?? ?? ?? C5 E5 54 E2 C4 E2 7D 1A 0D ?? ?? ?? ?? C5 DD C2 F1 1E C5 DD C2 F9 12 C5 CD 54 ED C5 CD 54 C0 C5 FA 6F B4 24 90 02 00 00 C5 C5 54 D3 C5 F8 10 9C 24 A0 02 00 00 C5 F9 7E F2 C5 F9 7E D8 C5 FD 11 84 24 80 00 00 00 C1 E2 05 C4 E3 79 16 F1 02 C4 E3 79 16 DF 02 C5 ED 56 ED C1 E0 05 C1 E1 05 C1 E7 05 C5 FA 7E 8A ?? ?? ?? ?? C5 FA 7E 90 ?? ?? ?? ?? C5 F1 16 B9 ?? ?? ?? ?? C5 FA 7E A2 ?? ?? ?? ?? C5 E9 16 87 ?? ?? ?? ?? C5 FA 7E 88 ?? ?? ?? ?? C5 D9 16 B1 ?? ?? ?? ?? C5 FA 7E 9A ?? ?? ?? ?? C4 E3 45 18 C0 01 C5 F1 16 BF ?? ?? ?? ?? C5 FA 7E 88 ?? ?? ?? ?? C5 FD 59 D5 C4 E3 4D 18 E7 01 C5 D5 59 FC C5 E1 16 B1 ?? ?? ?? ?? C5 F1 16 9F ?? ?? ?? ?? C4 E3 4D 18 DB 01 C5 E5 58 CF C5 FC 11 9C 24 A0 00 00 00 C5 ED 58 F1 C5 E5 5C D9 C5 F5 5C CE C5 E5 58 DF C5 F5 58 D2 C5 ED 58 CB C5 D5 59 D5 C5 ED 59 3D ?? ?? ?? ?? C5 C5 58 3D ?? ?? ?? ?? C5 C5 59 DA C5 FD 58 FC C5 ED 59 25 ?? ?? ?? ?? C5 E5 59 DD C5 E5 59 C7 C5 F5 58 D8 C5 DD 58 0D ?? ?? ?? ?? C5 F5 59 C2 C5 FD 58 25 ?? ?? ?? ?? C5 FC 10 84 24 A0 00 00 00 C5 DD 59 D2 C5 D5 59 E8 C5 ED 59 C8 C5 FA 7E 82 ?? ?? ?? ?? C5 F9 16 91 ?? ?? ?? ?? C5 C5 5C FD C5 E5 58 C9 C5 FA 7E 98 ?? ?? ?? ?? C5 E1 16 A7 ?? ?? ?? ?? C5 C5 59 BC 24 80 00 00 00 C4 E3 6D 18 EC 01 C5 C5 58 C5 C5 F5 58 C8 C5 FD 10 44 24 40 C5 CD 58 F1 C5 CD 57 4C 24 20 E9 C4 F7 FF FF 8B FF }
	condition:
		$1
}

rule file_219_0_0 {
	meta:
		name = "___WSTRINGTOLD_L"
		size = 89
		refs = "0007 ___security_cookie 002e ___wstrgtold12_l 003a __ld12told 0053 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 18 8B 4D 10 8B 55 0C 56 8B 75 08 57 50 33 C0 50 50 50 FF 75 14 8D 45 F0 51 52 50 E8 ?? ?? ?? ?? 8B F8 8D 45 F0 56 50 E8 ?? ?? ?? ?? 83 C4 28 83 F8 01 75 03 83 CF 02 8B 4D FC 8B C7 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_845_0_0 {
	meta:
		name = "___STRINGTOLD_L"
		size = 89
		refs = "0007 ___security_cookie 002e ___strgtold12_l 003a __ld12told 0053 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 18 8B 4D 10 8B 55 0C 56 8B 75 08 57 50 33 C0 50 50 50 FF 75 14 8D 45 F0 51 52 50 E8 ?? ?? ?? ?? 8B F8 8D 45 F0 56 50 E8 ?? ?? ?? ?? 83 C4 28 83 F8 01 75 03 83 CF 02 8B 4D FC 8B C7 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_219_6_0 {
	meta:
		name = "___wstrgtold12_l"
		size = 2108
		refs = "000a ___security_cookie 004f __errno 005a __invalid_parameter_noinfo 00c1 $LN291 044f ___mtold12 048f __pow10pos 04a1 __pow10neg 0806 @__security_check_cookie@4 080c $LN119 0810 $LN108 0814 $LN97 0818 $LN88 081c $LN75 0820 $LN61 0824 $LN58 0828 $LN43 082c $LN49 0830 $LN36 0834 $LN21 0838 $LN28"
	strings:
		$1 = { 55 8B EC 81 EC 84 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 89 85 7C FF FF FF 8B 45 0C 89 45 A4 33 C0 53 33 DB 40 56 89 45 88 8B C3 8D 75 E0 57 89 75 A8 89 5D 80 89 5D B0 89 5D 90 89 5D A0 89 5D 8C 8B FB 89 5D AC 39 45 24 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 98 07 00 00 8B 55 10 89 55 B4 C7 45 9C 09 00 00 00 C7 45 98 0A 00 00 00 0F B7 0A 83 F9 20 74 11 66 3B 4D 9C 74 0B 66 3B 4D 98 74 05 83 F9 0D 75 05 83 C2 02 EB E2 C7 45 98 08 00 00 00 C7 45 94 30 00 00 00 C7 45 9C 39 00 00 00 0F B7 0A 83 C2 02 89 4D 84 83 F8 0B 0F 87 D1 02 00 00 FF 24 85 ?? ?? ?? ?? 8D 41 CF 66 3B 45 98 77 08 6A 03 58 83 EA 02 EB D6 8B 45 24 0F B7 C9 8B 00 8B 80 84 00 00 00 8B 00 0F BE 00 3B C8 75 05 6A 05 58 EB BA 83 E9 2B 74 1F 49 49 74 0E 83 E9 03 0F 85 F3 02 00 00 33 C0 40 EB A3 6A 02 B9 00 80 00 00 58 89 4D 80 EB 96 6A 02 58 89 5D 80 EB 8E 33 C0 40 89 45 90 8D 41 CF 66 3B 45 98 76 A1 8B 45 24 0F B7 C9 8B 00 8B 80 84 00 00 00 8B 00 0F BE 00 3B C8 75 04 6A 04 EB A7 83 F9 2B 74 2F 83 F9 2D 74 2A 6A 30 58 3B C8 74 AB 83 F9 43 0F 8E 95 02 00 00 83 F9 45 7E 0E 8D 41 9C 33 C9 41 3B C1 0F 87 82 02 00 00 6A 06 E9 73 FF FF FF 83 EA 02 6A 0B E9 69 FF FF FF 8D 41 CF 6A 08 59 66 3B C1 0F 86 39 FF FF FF 8B 45 24 8B 75 84 8B 00 8B 80 84 00 00 00 8B 00 0F BE 08 0F B7 C6 3B C1 75 0B 6A 05 58 8B 75 A8 E9 F2 FE FF FF 6A 30 58 66 3B F0 0F 85 D6 01 00 00 33 C0 40 EB E7 33 C0 40 6A 30 89 45 90 58 66 3B C8 72 32 8B 45 B0 8B 7D AC 66 3B 4D 9C 77 1B 83 F8 19 73 09 80 E9 30 40 88 0E 46 EB 01 47 0F B7 0A 83 C2 02 66 3B 4D 94 73 DF 89 7D AC 89 45 B0 89 75 A8 8B FB 8B 45 24 0F B7 C9 8B 00 8B 80 84 00 00 00 8B 00 0F BE 00 3B C8 0F 84 1E FF FF FF 83 F9 2B 0F 84 4D FF FF FF 83 F9 2D 0F 84 44 FF FF FF E9 1C FF FF FF 33 C0 40 89 45 90 89 45 A0 8B 45 B0 85 C0 75 1C 66 3B 4D 94 75 1A 8B 75 AC 0F B7 0A 4E 83 C2 02 66 3B 4D 94 74 F3 89 75 AC 8B 75 A8 66 3B 4D 94 72 2D 8B 7D AC 66 3B 4D 9C 77 19 83 F8 19 73 08 80 E9 30 40 88 0E 46 4F 0F B7 0A 83 C2 02 66 3B 4D 94 73 E1 89 7D AC 89 45 B0 89 75 A8 8B FB 0F B7 C1 83 F8 2B 0F 84 D4 FE FF FF 83 F8 2D 0F 84 CB FE FF FF 83 F8 43 0F 8E 3D 01 00 00 83 F8 45 0F 8E B2 FE FF FF 83 C0 9C E9 9F FE FF FF 33 C0 40 89 45 A0 8D 41 D0 6A 09 59 66 3B C1 0F 87 C4 00 00 00 6A 04 E9 E9 FD FF FF 8D 42 FC 89 45 B4 8D 41 CF 66 3B 45 98 77 07 6A 09 E9 D3 FD FF FF 0F B7 C1 83 E8 2B 74 22 48 48 74 10 83 E8 03 0F 85 92 00 00 00 6A 08 E9 D6 FD FF FF 6A 07 83 C9 FF 58 89 4D 88 E9 85 FD FF FF 6A 07 E9 C1 FD FF FF 33 C0 40 6A 30 89 45 8C 58 EB 06 0F B7 0A 83 C2 02 66 3B C8 74 F5 8D 41 CF 6A 08 59 66 3B C1 0F 87 A4 00 00 00 EB A1 8D 41 CF 66 3B 45 98 76 98 6A 30 58 66 3B C8 EB A6 39 5D 20 74 1E 8D 42 FE 89 45 B4 0F B7 C1 83 E8 2B 74 AE 48 48 75 27 83 4D 88 FF 6A 07 58 E9 23 FD FF FF 6A 0A 58 83 EA 02 6A 0A 59 3B C1 0F 85 12 FD FF FF EB 5E 8B 55 B4 8B 75 A8 EB 56 8B 55 B4 EB 51 33 C0 40 89 45 8C 8B FB EB 1F 66 3B 4D 9C 77 39 6B FF 0A 0F B7 C1 83 C7 D0 03 F8 81 FF 50 14 00 00 7F 10 0F B7 0A 83 C2 02 6A 30 58 66 3B C8 73 D9 EB 16 6A 30 BF 51 14 00 00 58 EB 0C 66 3B 4D 9C 77 0B 0F B7 0A 83 C2 02 66 3B C8 73 EF 83 EA 02 8B 45 A4 89 10 8B 45 90 85 C0 0F 84 D0 03 00 00 8B 45 B0 83 F8 18 76 19 8A 45 F7 3C 05 7C 05 FE C0 88 45 F7 8B 4D AC 4E 6A 18 41 58 89 4D AC EB 03 8B 4D AC 85 C0 0F 84 9A 03 00 00 4E 38 1E 75 0A 48 41 4E 38 1E 74 F9 89 4D AC 8D 4D C4 51 50 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 4D 88 83 C4 0C 85 C9 79 02 F7 DF 8B 45 8C 03 7D AC 85 C0 75 03 03 7D 18 8B 45 A0 85 C0 75 03 2B 7D 1C 81 FF 50 14 00 00 0F 8F 40 03 00 00 81 FF B0 EB FF FF 0F 8C 27 03 00 00 B8 ?? ?? ?? ?? 83 E8 60 85 FF 0F 84 05 03 00 00 79 0A B8 ?? ?? ?? ?? F7 DF 83 E8 60 39 5D 14 75 06 33 C9 66 89 4D C4 85 FF 0F 84 E6 02 00 00 C7 45 84 FF 7F 00 00 8B CF 83 C0 54 C1 FF 03 89 45 B4 89 7D 88 83 E1 07 0F 84 C0 02 00 00 6B C9 0C 03 C8 B8 00 80 00 00 89 4D 98 66 39 01 72 14 8B F1 8D 7D B8 A5 A5 A5 FF 4D BA 8B 7D 88 8D 4D B8 89 4D 98 0F B7 41 0A 8B 55 CE 8B F0 33 F2 81 E6 00 80 00 00 89 75 90 BE FF 7F 00 00 23 C6 23 D6 89 45 A4 03 C2 0F B7 F0 B8 FF 7F 00 00 89 5D AC 89 5D D4 89 5D D8 89 5D DC 89 75 8C 66 3B D0 0F 83 38 02 00 00 8B 45 A4 66 3B 45 84 0F 83 2B 02 00 00 C7 45 A4 FD BF 00 00 66 3B 75 A4 0F 87 1A 02 00 00 C7 45 A4 BF 3F 00 00 66 3B 75 A4 77 08 89 5D CC E9 1C 02 00 00 66 85 D2 75 24 46 F7 45 CC FF FF FF 7F 89 75 8C 75 17 83 7D C8 00 75 11 83 7D C4 00 75 0B 33 C0 66 89 45 CE E9 F9 01 00 00 66 85 C0 75 16 46 F7 41 08 FF FF FF 7F 89 75 8C 75 09 39 59 04 75 04 39 19 74 B4 6A 05 8B C3 5F 89 45 B0 8D 55 D8 89 7D 94 89 7D A4 85 FF 7E 5C 8D 75 C4 8D 34 46 8D 41 08 89 45 9C 8B CF 0F B7 00 89 45 A0 0F B7 06 8B 7D A0 0F AF F8 89 7D A0 03 7A FC 89 5D A4 3B 7A FC 72 05 3B 7D A0 73 05 33 C0 40 EB 03 8B 45 A4 89 7A FC 85 C0 74 03 66 FF 02 8B 45 9C 83 E8 02 83 C6 02 49 89 45 9C 85 C9 7F BB 8B 4D 98 8B 7D 94 8B 45 B0 83 C2 02 40 4F 89 45 B0 89 7D 94 85 FF 7F 8E 8B 75 8C 8B 55 DC 8B 7D D4 81 C6 02 C0 00 00 89 55 A8 66 85 F6 7E 3B 85 D2 78 32 8B 45 D8 8B C8 8B D7 C1 EA 1F 03 C0 0B C2 8B 55 A8 89 45 D8 C1 E9 1F 03 D2 B8 FF FF 00 00 0B D1 03 FF 03 F0 89 7D D4 89 55 A8 89 55 DC 66 85 F6 7F CA 66 85 F6 7F 69 B8 FF FF 00 00 03 F0 66 85 F6 79 5D 8B 5D AC 8B C6 F7 D8 0F B7 C0 89 45 A0 03 F0 F6 45 D4 01 74 01 43 8B 4D D8 8B C2 C1 E0 1F 89 4D B0 D1 6D B0 09 45 B0 8B 45 B0 C1 E1 1F D1 EF D1 EA 0B F9 FF 4D A0 89 55 DC 89 45 D8 89 7D D4 75 CE 6A 00 85 DB 89 55 A8 5B 74 12 33 C9 66 8B C7 41 66 0B C1 66 89 45 D4 8B 7D D4 EB 04 66 8B 45 D4 BA 00 80 00 00 66 3B C2 77 0E 81 E7 FF FF 01 00 81 FF 00 80 01 00 75 40 8B 45 D6 83 F8 FF 75 34 8B 45 DA 89 5D D6 83 F8 FF 75 20 66 8B 45 DE B9 FF FF 00 00 89 5D DA 66 3B C1 75 07 66 89 55 DE 46 EB 0C 66 40 66 89 45 DE EB 04 40 89 45 DA 8B 4D DC EB 07 40 89 45 D6 8B 4D A8 8B 7D 88 B8 FF 7F 00 00 66 3B F0 73 1A 66 8B 45 D6 0B 75 90 66 89 45 C4 8B 45 D8 89 45 C6 89 4D CA 66 89 75 CE EB 1D 33 C0 66 39 45 90 0F 94 C0 48 25 00 00 00 80 05 00 80 FF 7F 89 45 CC 89 5D C4 89 5D C8 8B 45 B4 85 FF 0F 85 21 FD FF FF 8B 45 CC 0F B7 4D C4 8B 55 C6 8B 75 CA C1 E8 10 EB 30 8B CB 8B C3 8B F3 8B D3 33 DB 43 EB 23 B8 FF 7F 00 00 BE 00 00 00 80 6A 02 EB 10 8B CB 8B C3 8B F3 8B D3 EB 0B 8B C3 8B F3 6A 04 8B CB 8B D3 5B 8B BD 7C FF FF FF 0B 45 80 66 89 0F 66 89 47 0A 89 57 02 89 77 06 8B C3 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_220_0_0 {
	meta:
		name = "__wexecl"
		size = 66
		refs = "000b __errno 0016 __invalid_parameter_noinfo 0039 __wexecve"
	strings:
		$1 = { 55 8B EC 8B 45 08 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 33 D2 66 39 10 74 E4 8B 4D 0C 85 C9 74 DD 66 39 11 74 D8 52 8D 4D 0C 51 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_221_0_0 {
	meta:
		name = "__lrotr"
		size = 16
		altNames = "__rotr"
	strings:
		$1 = { 55 8B EC 8B 4D 0C 8B 45 08 83 E1 1F D3 C8 5D C3 }
	condition:
		$1
}

rule file_221_2_0 {
	meta:
		name = "__rotr64"
		size = 54
		refs = "0018 __allshl 0029 __aullshr"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 0C 53 8B 5D 10 56 57 6A 40 59 83 E3 3F 2B CB E8 ?? ?? ?? ?? 8B F0 8B 45 08 8B FA 8B 55 0C 8B CB E8 ?? ?? ?? ?? 0B C6 0B D7 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_387_2_0 {
	meta:
		name = "__rotl64"
		size = 54
		refs = "0018 __aullshr 0029 __allshl"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 0C 53 8B 5D 10 56 57 6A 40 59 83 E3 3F 2B CB E8 ?? ?? ?? ?? 8B F0 8B 45 08 8B FA 8B 55 0C 8B CB E8 ?? ?? ?? ?? 0B C6 0B D7 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_222_0_0 {
	meta:
		name = "__set_abort_behavior"
		size = 31
		refs = "0007 ___abort_behavior"
	strings:
		$1 = { 55 8B EC 8B 55 0C A1 ?? ?? ?? ?? 8B 4D 08 23 4D 0C F7 D2 23 D0 0B D1 89 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_222_1_0 {
	meta:
		name = "_abort"
		size = 67
		refs = "0001 ___get_sigabrt 000c _raise 0013 ___abort_behavior 001d _IsProcessorFeaturePresent@4 0034 __call_reportfault 003e __exit"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 74 08 6A 16 E8 ?? ?? ?? ?? 59 F6 05 ?? ?? ?? ?? 02 74 21 6A 17 E8 ?? ?? ?? ?? 85 C0 74 05 6A 07 59 CD 29 6A 01 68 15 00 00 40 6A 03 E8 ?? ?? ?? ?? 83 C4 0C 6A 03 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_223_0_0 {
	meta:
		name = "__cosh_spec_sd"
		size = 304
		refs = "004b _static_const_table"
	strings:
		$1 = { 8B 58 04 8B 08 81 E3 FF FF FF 7F 81 FB 36 23 86 40 0F 82 01 01 00 00 0F 87 BA 00 00 00 81 FB 50 3C 9C F4 0F 82 EF 00 00 00 81 FB C3 33 86 40 72 2D 77 08 81 F9 00 79 98 78 72 23 8B 48 50 C1 E1 04 81 E1 F0 03 00 00 66 0F 28 B9 ?? ?? ?? ?? 66 0F 28 EF BB 01 00 00 00 66 0F 15 FF EB 0C F2 0F 10 68 10 F2 0F 10 78 20 33 DB 66 0F 28 DD F2 0F 10 70 40 66 0F 28 D6 66 0F 28 0D ?? ?? ?? ?? F2 0F 59 CE 66 0F 58 EF F2 0F 59 F6 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CE F2 0F 58 D1 F2 0F 59 D5 F2 0F 58 D7 85 DB F2 0F 58 D3 74 51 F2 0F 59 15 ?? ?? ?? ?? 33 DB F2 0F 59 15 ?? ?? ?? ?? EB 3D 81 FB CE 33 86 40 0F 82 46 FF FF FF 77 18 81 FB 7D F8 B9 8F 0F 82 38 FF FF FF 33 DB F2 0F 10 15 ?? ?? ?? ?? EB 17 81 FB 00 00 F0 7F 72 EC 77 04 85 C9 74 E8 66 0F 57 D2 66 0F C2 D2 00 85 DB 74 01 C3 66 0F 28 2D ?? ?? ?? ?? 66 0F 58 ED C3 8D A4 24 00 00 00 00 8D 49 00 }
	condition:
		$1
}

rule file_223_1_0 {
	meta:
		name = "___sse2_cosh2"
		size = 560
		refs = "0019 _static_const_table"
	strings:
		$1 = { 8B C4 81 EC E0 00 00 00 83 E4 F0 89 84 24 A4 00 00 00 89 1C 24 66 0F 28 3D ?? ?? ?? ?? 89 7C 24 04 89 74 24 08 66 0F 28 15 ?? ?? ?? ?? 66 0F 54 C7 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 D0 8D 44 24 10 66 0F 28 25 ?? ?? ?? ?? B9 FF FF FF 7F 66 0F 58 D3 66 0F 28 2D ?? ?? ?? ?? BB FF FF FF 7F 66 0F 28 F2 66 0F 29 44 24 10 66 0F 5C D3 66 0F 28 CE 66 0F 59 E2 66 0F 57 DB 23 48 04 66 0F 73 F6 04 66 0F 29 4C 24 60 66 0F 59 EA 23 58 0C 66 0F FB D9 66 0F 5C C4 66 0F 7E F6 66 0F 5C C5 66 0F FE 0D ?? ?? ?? ?? 81 E6 F0 03 00 00 66 0F 15 F6 66 0F FE 1D ?? ?? ?? ?? 66 0F 73 F1 2E 66 0F 7E F7 66 0F 28 BE ?? ?? ?? ?? 81 E7 F0 03 00 00 66 0F 73 F3 2E 66 0F 29 44 24 50 F7 DE 66 0F 28 B7 ?? ?? ?? ?? 81 C6 00 04 00 00 66 0F DB 0D ?? ?? ?? ?? 66 0F 28 EF F7 DF 66 0F DB 1D ?? ?? ?? ?? 66 0F C6 EE 00 81 C7 00 04 00 00 66 0F 28 A6 ?? ?? ?? ?? 66 0F C6 FE 03 66 0F 28 97 ?? ?? ?? ?? 66 0F 59 E9 81 E9 36 23 86 40 66 0F 28 F4 66 0F 59 F9 81 EB 36 23 86 40 66 0F C6 E2 00 66 0F 29 6C 24 20 66 0F 28 C8 66 0F C6 F2 03 66 0F 59 E3 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 C0 66 0F 29 64 24 40 66 0F 59 F3 66 0F 58 EF 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 D0 23 D9 66 0F 58 E6 66 0F 29 7C 24 30 66 0F 59 D8 66 0F 58 15 ?? ?? ?? ?? 66 0F 28 FD 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 D0 66 0F 58 EC 66 0F 59 C3 66 0F 5C FC 66 0F 59 D1 66 0F 59 C5 66 0F 58 D1 66 0F 28 5C 24 30 66 0F 59 D7 66 0F 58 C2 66 0F 28 64 24 40 66 0F 58 C6 66 0F 28 6C 24 20 66 0F 58 C3 F7 C3 00 00 00 80 66 0F 58 C4 66 0F 58 C5 8B 74 24 08 8B 7C 24 04 74 02 EB 29 8D 44 24 10 66 0F 28 E0 66 0F 28 D0 66 0F 15 E4 E8 C9 FC FF FF 83 C0 08 66 0F 28 C2 66 0F 28 D4 E8 B9 FC FF FF 66 0F 14 C2 8B 1C 24 8B A4 24 A4 00 00 00 C3 8D A4 24 00 00 00 00 8D 49 00 }
	condition:
		$1
}

rule file_225_4_0 {
	meta:
		name = "__mbsncat_l"
		size = 263
		refs = "001f __errno 002a __invalid_parameter_noinfo 005b ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 006c _strncat 008b __ismbslead_l 00d2 __mbsbtype_l"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 8B 5D 10 85 DB 75 08 8B 45 08 E9 EE 00 00 00 56 8B 75 08 85 F6 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 CE 00 00 00 57 8B 7D 0C 85 FF 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 AE 00 00 00 FF 75 14 8D 4D EC E8 ?? ?? ?? ?? 8B 45 F0 83 78 08 00 75 0F 53 57 56 E8 ?? ?? ?? ?? 83 C4 0C 8B D8 EB 7C 8B DE 89 5D FC 8A 06 46 84 C0 75 F9 8D 45 EC 50 4E 56 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 01 4E 8B 4D 10 8A 17 8B 5D F0 0F B6 C2 49 F6 44 18 19 04 8B 5D FC 88 16 74 35 8A 47 01 88 46 01 83 C6 02 83 C7 02 84 C0 75 2B 88 46 FE 3B F3 74 2A 8D 45 EC 50 8B C6 2B C3 48 50 53 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 01 75 12 C6 46 FF 00 EB 0F 46 47 84 D2 74 D8 85 C9 75 AC EB D2 C6 06 00 80 7D F8 00 74 07 8B 45 F4 83 60 70 FD 8B C3 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_226_0_0 {
	meta:
		name = "__libm_sse2_tan_precise"
		size = 624
		refs = "0050 PI32INV 0060 SHIFTER 006c P_1 0078 QQ_2 0086 P_2 00a5 P_3 00c0 ONE 00c9 Ctable 00d1 MASK_35 0223 TWO_POW_M55 022b TWO_POW_55 024d __tan_default"
	strings:
		$1 = { 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 0F 85 13 02 00 00 66 0F C5 C0 03 66 25 FF 7F 66 2D 20 38 66 3D A8 08 0F 87 C7 01 00 00 66 0F 14 C0 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 C8 F2 0F 2D D1 66 0F 28 15 ?? ?? ?? ?? 66 0F 58 CA 66 0F 28 1D ?? ?? ?? ?? 66 0F 5C CA 66 0F 12 2D ?? ?? ?? ?? 81 C2 00 29 07 00 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 D9 83 E2 1F F2 0F 59 E9 8B CA 66 0F 59 E1 D1 E1 66 0F 5C C3 66 0F 59 0D ?? ?? ?? ?? 03 D1 C1 E1 02 03 D1 F2 0F 58 E8 66 0F 28 D0 66 0F 5C C4 66 0F 12 35 ?? ?? ?? ?? C1 E2 04 8D 05 ?? ?? ?? ?? 66 0F 54 2D ?? ?? ?? ?? 66 0F 28 D8 03 C2 66 0F 5C D0 66 0F 15 C0 F2 0F 5E F5 66 0F 5C D4 66 0F 28 78 10 F2 0F 5C DD 66 0F 59 F8 66 0F 5C D1 66 0F 28 48 30 66 0F 59 C8 66 0F 28 60 60 66 0F 59 E0 F2 0F 58 D3 66 0F 28 D8 66 0F 59 C0 66 0F 58 38 66 0F 58 48 20 66 0F 59 C8 66 0F 58 60 50 66 0F 58 F9 66 0F 28 48 70 66 0F 59 C8 66 0F 59 C0 66 0F 58 E1 66 0F 28 48 40 66 0F 59 C8 66 0F 58 F9 66 0F 28 CB 66 0F 59 D8 F2 0F 59 C0 66 0F 59 88 90 00 00 00 66 0F 59 E3 F2 0F 10 D9 66 0F 58 FC F2 0F 10 E1 F2 0F 59 C7 66 0F 15 FF F2 0F 58 C7 66 0F 15 C9 F2 0F 58 D9 F2 0F 5C E3 F2 0F 58 CC F2 0F 10 E2 66 0F 12 B8 90 00 00 00 66 0F 15 D2 F2 0F 58 B8 98 00 00 00 F2 0F 59 FA F2 0F 58 B8 88 00 00 00 F2 0F 58 F9 F2 0F 58 C7 66 0F 12 3D ?? ?? ?? ?? F2 0F 59 E6 66 0F 12 90 A8 00 00 00 66 0F 54 D6 F2 0F 59 EA F2 0F 59 B0 A0 00 00 00 F2 0F 5C FD F2 0F 5C 90 80 00 00 00 F2 0F 5C FC F2 0F 59 FE F2 0F 10 E3 F2 0F 5C DA F2 0F 58 D3 F2 0F 5C E2 F2 0F 58 C4 F2 0F 5C C7 F2 0F 58 C3 C3 7F 33 66 C1 E8 04 66 3D 7E 0C 75 0C F2 0F 10 D8 F2 0F 59 1D ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 58 D8 F2 0F 59 1D ?? ?? ?? ?? 66 0F 28 C3 C3 83 EC 08 66 0F D6 04 24 E8 ?? ?? ?? ?? DD 1C 24 F3 0F 7E 04 24 83 C4 08 C3 F2 0F 5C C0 C3 8B FF 8D A4 24 00 00 00 00 EB 03 CC CC CC }
	condition:
		$1
}

rule file_227_3_0 {
	meta:
		name = "__mbsnset_s_l"
		size = 513
		refs = "0044 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0059 __strnset_s 008b __ismbblead_l 01be __errno 01c8 __invalid_parameter_noinfo"
	strings:
		$1 = { 55 8B EC 83 EC 1C 53 33 DB 56 8B 75 08 57 89 5D FC 39 5D 14 75 14 85 F6 75 18 39 5D 0C 0F 85 C8 01 00 00 33 C0 E9 D2 01 00 00 85 F6 0F 84 B9 01 00 00 8B 7D 0C 85 FF 0F 84 AE 01 00 00 FF 75 18 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 E8 39 58 08 75 17 FF 75 14 FF 75 10 57 56 E8 ?? ?? ?? ?? 83 C4 10 8B D8 E9 75 01 00 00 8B 4D 10 8B C1 C1 E8 08 89 45 F8 84 C0 0F 84 AE 00 00 00 84 C9 0F 84 B9 00 00 00 8D 4D E4 0F B6 C0 51 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 A2 00 00 00 8B 45 08 38 18 0F 84 E5 00 00 00 8B 45 14 85 C0 0F 84 D7 00 00 00 4F 0F 84 D0 00 00 00 8D 4E 01 89 4D F4 38 19 74 5D 39 5D FC 74 04 8B CB EB 14 8D 45 E4 50 0F B6 06 50 E8 ?? ?? ?? ?? 59 59 8B C8 8B 45 14 8B 55 F8 88 16 8B 75 F4 89 4D FC 4F 0F 84 97 00 00 00 85 C9 74 05 89 5D FC EB 15 8D 45 E4 50 0F B6 06 50 E8 ?? ?? ?? ?? 59 89 45 FC 8B 45 14 59 8B 4D 10 88 0E 46 48 89 45 14 38 1E 75 8C EB 69 8B 45 08 33 D2 47 88 1E 42 EB 63 8D 45 E4 50 0F B6 C1 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 0A 8B 45 08 88 18 E9 8D 00 00 00 8B 45 08 38 18 74 3D 8B 45 14 8B 4D 10 85 C0 74 30 4F 74 2D 39 5D FC 74 05 89 5D FC EB 18 8D 45 E4 50 0F B6 06 50 E8 ?? ?? ?? ?? 59 59 8B 4D 10 89 45 FC 8B 45 14 88 0E 46 48 89 45 14 38 1E 75 CC 8B 45 08 8B D3 39 5D 14 75 27 39 5D FC 74 1E 38 1E 74 1E 4F 74 17 33 D2 42 38 5E 01 75 05 88 1E 47 EB 0A C6 06 20 46 EB 04 4F 74 05 46 38 1E 75 F8 85 FF 75 13 88 18 E8 ?? ?? ?? ?? 6A 16 5B 89 18 E8 ?? ?? ?? ?? EB 0E 85 D2 74 0A E8 ?? ?? ?? ?? 6A 2A 5B 89 18 80 7D F0 00 74 18 8B 4D EC 83 61 70 FD EB 0F E8 ?? ?? ?? ?? 6A 16 5B 89 18 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_228_0_0 {
	meta:
		name = "__filelengthi64"
		size = 323
		refs = "0003 __sehtable$__filelengthi64 0008 __SEH_prolog4 0015 ___doserrno 001d __errno 002d __ioinit 0043 __nhandle 005d ___pioinfo 0071 ___lock_fhandle 008f __lseeki64_nolock 0118 __unlock_fhandle 0132 __invalid_parameter_noinfo 013e __SEH_epilog4"
	strings:
		$1 = { 6A 18 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 08 83 FF FE 75 18 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E9 0A 01 00 00 E8 ?? ?? ?? ?? 85 C0 0F 88 FD 00 00 00 85 FF 0F 88 DD 00 00 00 3B 3D ?? ?? ?? ?? 0F 83 D1 00 00 00 8B DF C1 FB 05 8B F7 83 E6 1F C1 E6 06 8B 04 9D ?? ?? ?? ?? 0F BE 44 30 04 83 E0 01 0F 84 AF 00 00 00 57 E8 ?? ?? ?? ?? 59 33 C9 89 4D FC 8B 04 9D ?? ?? ?? ?? F6 44 30 04 01 74 56 6A 01 51 51 57 E8 ?? ?? ?? ?? 83 C4 10 8B C8 89 4D E0 8B C2 89 45 E4 23 C8 83 CE FF 3B CE 74 4C 6A 02 6A 00 6A 00 57 E8 ?? ?? ?? ?? 83 C4 10 8B D8 89 5D D8 8B F2 89 75 DC 8B 4D E0 8B 45 E4 3B CB 75 04 3B C6 74 2D 6A 00 50 51 57 E8 ?? ?? ?? ?? 83 C4 10 EB 1E E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 20 00 83 CE FF 8B DE 89 5D D8 89 75 DC C7 45 FC FE FF FF FF E8 0D 00 00 00 8B C3 EB 2E 8B 7D 08 8B 75 DC 8B 5D D8 57 E8 ?? ?? ?? ?? 59 C3 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 CE FF 8B C6 8B D6 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_229_0_0 {
	meta:
		name = "___libm_sse2_cos"
		size = 417
		refs = "001b _PI32INV 0027 _SHIFTER 0037 _P_1 0043 _P_2 0060 _SC_4 0066 _Ctable 007b _P_3 00a0 _SC_2 00e5 _SC_3 00f1 _SC_1 0161 _ONE 0188 _cos 019c _NEG_ZERO"
	strings:
		$1 = { 66 0F C5 C0 03 66 25 FF 7F 66 2D 30 30 66 3D C5 10 0F 87 36 01 00 00 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 10 15 ?? ?? ?? ?? F2 0F 2D D1 F2 0F 58 CA F2 0F 10 1D ?? ?? ?? ?? F2 0F 5C CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 D9 66 0F 14 C9 81 C2 10 76 1C 00 F2 0F 10 E0 83 E2 3F 66 0F 28 2D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 05 03 C2 66 0F 59 D1 F2 0F 5C C3 F2 0F 59 0D ?? ?? ?? ?? F2 0F 5C E3 F2 0F 10 78 08 66 0F 14 C0 F2 0F 10 DC F2 0F 5C E2 66 0F 59 E8 66 0F 5C C2 66 0F 28 35 ?? ?? ?? ?? F2 0F 59 FC F2 0F 5C DC 66 0F 59 E8 66 0F 59 C0 F2 0F 5C DA 66 0F 28 10 F2 0F 5C CB F2 0F 10 58 18 F2 0F 58 D3 F2 0F 5C FA F2 0F 59 D4 66 0F 59 F0 F2 0F 59 DC 66 0F 59 D0 66 0F 59 C0 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 20 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 E8 F2 0F 10 C3 F2 0F 58 58 08 66 0F 59 CF F2 0F 10 FC F2 0F 58 E3 66 0F 58 F5 F2 0F 10 68 08 F2 0F 5C EB F2 0F 5C DC F2 0F 58 48 10 66 0F 59 F2 F2 0F 58 E8 F2 0F 58 DF F2 0F 58 CD F2 0F 58 CB F2 0F 58 CE 66 0F 15 F6 F2 0F 58 CE F2 0F 58 E1 66 0F 28 C4 C3 7F 1F 66 0F C5 C0 03 66 25 FF 7F 66 0F C4 C0 03 F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C C8 66 0F 28 C1 C3 66 0F C5 C0 03 25 F0 7F 00 00 3D F0 7F 00 00 74 19 83 EC 08 66 0F D6 04 24 E8 ?? ?? ?? ?? DD 1C 24 F3 0F 7E 04 24 83 C4 08 C3 F2 0F 59 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_230_0_0 {
	meta:
		name = "__execve"
		size = 489
		refs = "0012 __errno 001d __invalid_parameter_noinfo 0045 __mbsrchr 0062 __mbschr 0070 _strlen 007b __calloc_crt 008d ??_C@_02CEGDFPFP@?4?2?$AA@ 0094 _strcpy_s 00a7 _strcat_s 00d7 __access_s 00ed _comexecmd 0159 _ext_strings 01c0 _free 01e4 __invoke_watson"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 8B 5D 08 57 8B FB 85 DB 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 AF 01 00 00 80 3B 00 74 E3 8B 45 0C 85 C0 74 DC 8B 00 85 C0 74 D6 80 38 00 74 D1 56 6A 5C 53 E8 ?? ?? ?? ?? 6A 2F 53 8B F0 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 61 85 F6 75 67 6A 3A 53 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 75 57 53 E8 ?? ?? ?? ?? 8D 70 03 6A 01 56 E8 ?? ?? ?? ?? 8B F8 83 C4 0C 85 FF 0F 84 8F 00 00 00 68 ?? ?? ?? ?? 56 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 39 01 00 00 53 56 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 26 01 00 00 8D 77 02 EB 0A 85 F6 74 04 3B C6 76 02 8B F0 6A 2E 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 28 6A 00 57 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 E2 00 00 00 FF 75 10 FF 75 0C 57 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 E9 CF 00 00 00 57 E8 ?? ?? ?? ?? 83 C0 05 6A 01 50 89 45 FC E8 ?? ?? ?? ?? 8B F0 83 C4 0C 89 75 08 85 F6 75 08 83 C8 FF E9 B4 00 00 00 57 FF 75 FC 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 A4 00 00 00 57 E8 ?? ?? ?? ?? 03 C6 59 89 45 F8 E8 ?? ?? ?? ?? 8B 55 FC 8B 00 8B 4D F8 2B D1 89 45 F0 03 D6 B8 ?? ?? ?? ?? 89 55 F4 89 45 FC 33 F6 FF 30 52 51 E8 ?? ?? ?? ?? 83 C4 0C 56 85 C0 75 69 FF 75 08 E8 ?? ?? ?? ?? 59 59 85 C0 74 1B 8B 45 FC 8B 4D F8 8B 55 F4 83 E8 04 89 45 FC 3D ?? ?? ?? ?? 7D CB 83 CE FF EB 1D E8 ?? ?? ?? ?? FF 75 10 8B 4D F0 FF 75 0C 89 08 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 FF 75 08 E8 ?? ?? ?? ?? 59 EB 03 83 CE FF 3B FB 74 07 57 E8 ?? ?? ?? ?? 59 8B C6 5E 5F 5B C9 C3 33 F6 56 56 56 56 56 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_230_2_0 {
	meta:
		name = "_comexecmd"
		size = 107
		refs = "000d __errno 0018 __invalid_parameter_noinfo 0037 __cenvarg 004d __dospawn 0057 _free"
	strings:
		$1 = { 55 8B EC 51 56 8B 75 08 85 F6 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 47 83 7D 0C 00 74 E5 56 8D 45 FC 50 8D 45 08 50 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 14 83 F8 FF 74 D9 FF 75 FC FF 75 08 56 6A 02 E8 ?? ?? ?? ?? FF 75 08 8B F0 E8 ?? ?? ?? ?? FF 75 FC E8 ?? ?? ?? ?? 83 C4 18 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_235_2_0 {
	meta:
		name = "_wcomexecmd"
		size = 107
		refs = "000d __errno 0018 __invalid_parameter_noinfo 0037 __wcenvarg 004d __wdospawn 0057 _free"
	strings:
		$1 = { 55 8B EC 51 56 8B 75 08 85 F6 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 47 83 7D 0C 00 74 E5 56 8D 45 FC 50 8D 45 08 50 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 14 83 F8 FF 74 D9 FF 75 FC FF 75 08 56 6A 02 E8 ?? ?? ?? ?? FF 75 08 8B F0 E8 ?? ?? ?? ?? FF 75 FC E8 ?? ?? ?? ?? 83 C4 18 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_231_0_0 {
	meta:
		name = "__except_handler2"
		size = 174
		refs = "0057 __global_unwind2 0064 __local_unwind2"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 55 FC 8B 5D 0C 8B 45 08 F7 40 04 06 00 00 00 75 77 89 45 F8 8B 45 10 89 45 FC 8D 45 F8 89 43 14 8B 73 0C 8B 7B 08 83 FE FF 74 56 8D 0C 76 83 7C 8F 04 00 74 3A 56 55 8B 6B 10 FF 54 8F 04 5D 5E 8B 5D 0C 0B C0 74 28 78 31 8B 7B 08 53 E8 ?? ?? ?? ?? 83 C4 04 8B 6B 10 56 53 E8 ?? ?? ?? ?? 83 C4 08 8D 0C 76 8B 04 8F 89 43 0C FF 54 8F 08 8B 7B 08 8D 0C 76 8B 34 8F EB AC B8 00 00 00 00 EB 1C B8 01 00 00 00 EB 15 55 8B 6B 10 6A FF 53 E8 ?? ?? ?? ?? 83 C4 08 5D B8 01 00 00 00 5D 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_233_3_0 {
	meta:
		name = "__strnicmp"
		size = 107
		refs = "0005 ___locale_changed 0014 __errno 001f __invalid_parameter_noinfo 0051 ___ascii_strnicmp 0061 __strnicmp_l"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 56 75 48 83 7D 08 00 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F EB 3E 83 7D 0C 00 74 E3 BE FF FF FF 7F 39 75 10 76 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8B C6 EB 1A 5E 5D E9 ?? ?? ?? ?? 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5E 5D C3 }
	condition:
		$1
}

rule file_730_3_0 {
	meta:
		name = "__strncoll"
		size = 107
		refs = "0005 ___locale_changed 0014 __errno 001f __invalid_parameter_noinfo 0051 _strncmp 0061 __strncoll_l"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 56 75 48 83 7D 08 00 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F EB 3E 83 7D 0C 00 74 E3 BE FF FF FF 7F 39 75 10 76 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8B C6 EB 1A 5E 5D E9 ?? ?? ?? ?? 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5E 5D C3 }
	condition:
		$1
}

rule file_1083_3_0 {
	meta:
		name = "__wcsncoll"
		size = 107
		refs = "0005 ___locale_changed 0014 __errno 001f __invalid_parameter_noinfo 0051 _wcsncmp 0061 __wcsncoll_l"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 56 75 48 83 7D 08 00 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F EB 3E 83 7D 0C 00 74 E3 BE FF FF FF 7F 39 75 10 76 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8B C6 EB 1A 5E 5D E9 ?? ?? ?? ?? 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5E 5D C3 }
	condition:
		$1
}

rule file_233_4_0 {
	meta:
		name = "__strnicmp_l"
		size = 175
		refs = "001a ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0039 __errno 0044 __invalid_parameter_noinfo 005a ___ascii_strnicmp 0071 __tolower_l"
	strings:
		$1 = { 55 8B EC 83 EC 10 83 7D 10 00 0F 84 9B 00 00 00 53 56 57 FF 75 14 8D 4D F0 E8 ?? ?? ?? ?? 8B 7D 08 BE FF FF FF 7F 85 FF 74 0E 8B 5D 0C 85 DB 74 07 8B 4D 10 3B CE 76 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 4D 8B 45 F0 83 B8 A8 00 00 00 00 75 0F 51 53 57 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 EB 32 2B FB 0F B6 04 1F 8D 4D F0 51 50 E8 ?? ?? ?? ?? 8B F0 0F B6 03 8D 4D F0 51 50 E8 ?? ?? ?? ?? 83 C4 10 43 FF 4D 10 74 08 85 F6 74 04 3B F0 74 D2 2B F0 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD 5F 8B C6 5E 5B C9 C3 33 C0 C9 C3 }
	condition:
		$1
}

rule file_235_1_0 {
	meta:
		name = "__wexecve"
		size = 490
		refs = "0012 __errno 001d __invalid_parameter_noinfo 0047 _wcsrchr 0064 _wcschr 0072 _wcslen 007d __calloc_crt 008f ??_C@_15PCEAIKAA@?$AA?4?$AA?2?$AA?$AA@ 0096 _wcscpy_s 00a9 _wcscat_s 00dd __waccess_s 00f3 _wcomexecmd 0161 _ext_strings 01be _free 01e5 __invoke_watson"
	strings:
		$1 = { 55 8B EC 83 EC 10 56 57 8B 7D 08 8B F7 85 FF 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 B0 01 00 00 33 C9 66 39 0F 74 E1 8B 45 0C 85 C0 74 DA 8B 00 85 C0 74 D4 66 39 08 74 CF 53 6A 5C 57 E8 ?? ?? ?? ?? 6A 2F 57 8B D8 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 61 85 DB 75 67 6A 3A 57 E8 ?? ?? ?? ?? 8B D8 59 59 85 DB 75 57 57 E8 ?? ?? ?? ?? 8D 58 03 6A 02 53 E8 ?? ?? ?? ?? 8B F0 83 C4 0C 85 F6 0F 84 90 00 00 00 68 ?? ?? ?? ?? 53 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 38 01 00 00 57 53 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 25 01 00 00 8D 5E 04 EB 0A 85 DB 74 04 3B C3 76 02 8B D8 83 4D F4 FF 6A 2E 53 E8 ?? ?? ?? ?? 59 59 85 C0 74 28 6A 00 56 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 DD 00 00 00 FF 75 10 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 8B D8 E9 CA 00 00 00 56 E8 ?? ?? ?? ?? 83 C0 05 6A 02 50 89 45 08 E8 ?? ?? ?? ?? 8B D8 83 C4 0C 85 DB 75 08 83 C8 FF E9 B2 00 00 00 56 FF 75 08 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 A2 00 00 00 56 E8 ?? ?? ?? ?? 8D 04 43 59 89 45 F8 E8 ?? ?? ?? ?? 8B 00 8B 55 F8 8B 4D 08 89 45 F0 8B C2 2B C3 D1 F8 2B C8 B8 ?? ?? ?? ?? 89 4D 08 89 45 FC FF 30 51 52 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 62 50 53 E8 ?? ?? ?? ?? 59 59 85 C0 74 18 8B 45 FC 8B 4D 08 8B 55 F8 83 E8 04 89 45 FC 3D ?? ?? ?? ?? 7D CD EB 1C E8 ?? ?? ?? ?? FF 75 10 8B 4D F0 FF 75 0C 89 08 53 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 53 E8 ?? ?? ?? ?? 8B 5D F4 59 EB 03 83 CB FF 3B F7 74 07 56 E8 ?? ?? ?? ?? 59 8B C3 5B 5F 5E C9 C3 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_237_0_0 {
	meta:
		name = "___dtold"
		size = 198
	strings:
		$1 = { 55 8B EC 51 51 8B 45 0C 53 8B 50 04 56 57 0F B7 78 06 8B 00 8B CF C1 E9 04 81 E1 FF 07 00 00 81 E7 00 80 00 00 8B F1 81 E2 FF FF 0F 00 BB 00 00 00 80 89 7D F8 89 45 FC 85 F6 74 17 81 FE FF 07 00 00 74 08 8D 81 00 3C 00 00 EB 25 B8 FF 7F 00 00 EB 21 85 D2 75 12 85 C0 75 0E 8B 45 08 21 50 04 21 10 66 89 78 08 EB 58 8D 81 01 3C 00 00 33 DB 0F B7 C0 8B 4D FC 8B F1 C1 EE 15 C1 E2 0B 0B F2 0B F3 8B 5D 08 C1 E1 0B 89 45 0C 89 73 04 89 0B 85 F6 78 26 8B F8 8B 13 8B CA C1 E9 1F 03 F6 8D 04 12 81 C7 FF FF 00 00 0B F1 89 03 79 E8 89 7D 0C 8B 7D F8 8B 45 0C 89 73 04 0B F8 66 89 7B 08 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_237_1_0 {
	meta:
		name = "__fltout2"
		size = 140
		refs = "0007 ___security_cookie 0025 ___dtold 0040 _$I10_OUTPUT 0060 _strcpy_s 0079 @__security_check_cookie@4 0087 __invoke_watson"
	strings:
		$1 = { 55 8B EC 83 EC 30 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 14 53 8B 5D 10 56 89 45 DC 57 8D 45 08 50 8D 45 D0 50 E8 ?? ?? ?? ?? 59 59 8D 45 E0 50 6A 00 6A 11 83 EC 0C 8D 75 D0 8B FC A5 A5 66 A5 E8 ?? ?? ?? ?? 8B 75 DC 89 43 08 0F BE 45 E2 89 03 0F BF 45 E0 89 43 04 8D 45 E4 50 FF 75 18 56 E8 ?? ?? ?? ?? 83 C4 24 85 C0 75 14 8B 4D FC 5F 89 73 0C 5E 8B C3 33 CD 5B E8 ?? ?? ?? ?? C9 C3 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_238_0_0 {
	meta:
		name = "__loaddll"
		size = 31
		refs = "0004 ___crtIsPackagedApp 0019 __imp__LoadLibraryExA@12"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 85 C0 74 04 33 C0 5D C3 6A 00 6A 00 FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_238_1_0 {
	meta:
		name = "__unloaddll"
		size = 27
		refs = "0008 __imp__FreeLibrary@4 0013 __imp__GetLastError@0"
	strings:
		$1 = { 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 07 5D FF 25 ?? ?? ?? ?? 33 C0 5D C3 }
	condition:
		$1
}

rule file_239_0_0 {
	meta:
		name = "___mbtow_environ"
		size = 123
		refs = "0007 __environ 001c __imp__MultiByteToWideChar@24 002a __calloc_crt 0051 ___crtwsetenv 0071 _free"
	strings:
		$1 = { 55 8B EC 51 56 8B 35 ?? ?? ?? ?? 57 33 FF 89 7D FC EB 4B 57 57 6A FF 50 57 57 FF 15 ?? ?? ?? ?? 8B F8 85 FF 74 50 6A 02 57 E8 ?? ?? ?? ?? 59 59 89 45 FC 85 C0 74 3F 57 50 6A FF FF 36 33 FF 57 57 FF 15 ?? ?? ?? ?? 85 C0 74 22 8D 45 FC 57 50 E8 ?? ?? ?? ?? 59 59 85 C0 78 0D 83 C6 04 8B 06 85 C0 75 AF 5F 5E C9 C3 39 7D FC 74 09 FF 75 FC E8 ?? ?? ?? ?? 59 83 C8 FF EB E9 }
	condition:
		$1
}

rule file_240_0_0 {
	meta:
		name = "___common_dexp_cout_rare"
		size = 912
		refs = "0011 __imldExpHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 83 EC 4C 8B 45 08 F2 0F 10 15 ?? ?? ?? ?? 0F B7 0D ?? ?? ?? ?? F2 0F 10 00 0F B7 40 06 25 F0 7F 00 00 C1 E8 04 F2 0F 11 44 24 40 3D FF 07 00 00 0F 84 01 03 00 00 3D CA 03 00 00 0F 8E D9 02 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 82 A7 02 00 00 66 0F 2F 05 ?? ?? ?? ?? 0F 82 79 02 00 00 F2 0F 10 0D ?? ?? ?? ?? 0F 28 F0 F2 0F 59 C8 F2 0F 11 4C 24 30 F2 0F 11 54 24 40 F2 0F 10 54 24 30 F2 0F 58 15 ?? ?? ?? ?? F2 0F 11 54 24 38 F2 0F 10 5C 24 38 8B 74 24 38 8B C6 83 E6 3F F2 0F 5C 1D ?? ?? ?? ?? F2 0F 11 5C 24 30 F2 0F 10 64 24 30 F2 0F 59 25 ?? ?? ?? ?? F2 0F 10 6C 24 30 F2 0F 5C F4 F2 0F 59 2D ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? F2 0F 5C F5 F2 0F 59 DE C1 E6 04 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 DE C1 E8 06 F2 0F 58 1D ?? ?? ?? ?? 66 0F 2F 05 ?? ?? ?? ?? F2 0F 59 DE F2 0F 10 8E ?? ?? ?? ?? 8D 90 FF 03 00 00 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 DE F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 DE F2 0F 59 DE F2 0F 58 DE F2 0F 58 9E ?? ?? ?? ?? F2 0F 59 D9 72 73 81 E2 FF 07 00 00 F2 0F 58 D9 81 FA FE 07 00 00 77 27 C1 E2 04 81 E1 0F 80 FF FF 0B CA 66 89 4C 24 46 F2 0F 59 5C 24 40 8B 45 0C F2 0F 11 18 33 C0 83 C4 4C 5E 8B E5 5D C3 4A 81 E2 FF 07 00 00 0F B7 44 24 46 C1 E2 04 25 0F 80 FF FF 0B C2 66 89 44 24 46 33 C0 F2 0F 59 5C 24 40 F2 0F 59 1D ?? ?? ?? ?? 8B 55 0C F2 0F 11 1A 83 C4 4C 5E 8B E5 5D C3 05 3B 04 00 00 25 FF 07 00 00 8B D0 0F B7 4C 24 46 C1 E2 04 81 E1 0F 80 FF FF 0B CA 66 89 4C 24 46 83 F8 32 F2 0F 10 54 24 40 F2 0F 59 DA F2 0F 59 D1 0F 28 C2 F2 0F 58 C3 77 14 F2 0F 59 05 ?? ?? ?? ?? 8B 45 0C F2 0F 11 00 E9 CC 00 00 00 F2 0F 11 04 24 F2 0F 10 04 24 8B 45 0C F2 0F 5C D0 F2 0F 11 54 24 08 F2 0F 10 4C 24 08 F2 0F 58 D9 F2 0F 11 5C 24 08 F2 0F 10 14 24 F2 0F 59 15 ?? ?? ?? ?? F2 0F 11 54 24 10 F2 0F 10 24 24 F2 0F 10 5C 24 10 F2 0F 58 E3 F2 0F 11 64 24 18 F2 0F 10 74 24 18 F2 0F 10 6C 24 10 F2 0F 5C F5 F2 0F 11 74 24 20 F2 0F 10 04 24 F2 0F 10 7C 24 20 F2 0F 5C C7 F2 0F 11 44 24 28 F2 0F 10 4C 24 08 F2 0F 10 54 24 28 F2 0F 58 D1 F2 0F 11 54 24 28 F2 0F 10 5C 24 20 F2 0F 59 1D ?? ?? ?? ?? F2 0F 11 5C 24 20 F2 0F 10 64 24 28 F2 0F 59 25 ?? ?? ?? ?? F2 0F 11 64 24 28 F2 0F 10 74 24 20 F2 0F 10 6C 24 28 F2 0F 58 F5 F2 0F 11 30 B8 04 00 00 00 83 C4 4C 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C0 8B 45 0C F2 0F 11 00 B8 04 00 00 00 83 C4 4C 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C0 8B 45 0C F2 0F 11 00 B8 03 00 00 00 83 C4 4C 5E 8B E5 5D C3 F2 0F 10 0D ?? ?? ?? ?? 8B 45 0C F2 0F 58 C8 F2 0F 11 08 33 C0 83 C4 4C 5E 8B E5 5D C3 0F B6 44 24 47 25 80 00 00 00 3D 80 00 00 00 74 15 F2 0F 59 C0 8B 45 0C F2 0F 11 00 33 C0 83 C4 4C 5E 8B E5 5D C3 F7 44 24 44 FF FF 0F 00 75 E1 83 7C 24 40 00 75 DA 8B 45 0C F2 0F 11 10 33 C0 83 C4 4C 5E 8B E5 5D C3 8D A4 24 00 00 00 00 8D 49 00 }
	condition:
		$1
}

rule file_241_0_0 {
	meta:
		name = "__chsize"
		size = 26
		refs = "000d __chsize_s"
	strings:
		$1 = { 55 8B EC 8B 45 0C 99 52 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 5D C3 }
	condition:
		$1
}

rule file_241_1_0 {
	meta:
		name = "__chsize_nolock"
		size = 436
		refs = "0019 __lseeki64_nolock 006b __imp__GetProcessHeap@0 0072 __imp__HeapAlloc@12 007e __errno 009b __setmode_nolock 00c4 __write_nolock 00e6 ___doserrno 0119 __imp__HeapFree@12 0147 __get_osfhandle 014f __imp__SetEndOfFile@4 017f __imp__GetLastError@0"
	strings:
		$1 = { 55 8B EC 83 EC 18 53 56 57 8B 7D 08 33 F6 6A 01 56 56 57 8B DE 89 75 F8 E8 ?? ?? ?? ?? 8B CA 89 45 E8 23 C1 83 C4 10 89 4D EC 83 F8 FF 74 59 6A 02 56 56 57 E8 ?? ?? ?? ?? 8B C8 23 C2 83 C4 10 83 F8 FF 74 43 8B 75 0C 8B 45 10 2B F1 1B C2 89 45 FC 0F 88 C7 00 00 00 7F 08 85 F6 0F 84 BD 00 00 00 68 00 10 00 00 6A 08 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 F4 85 C0 75 17 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 5F 5E 5B C9 C3 68 00 80 00 00 57 E8 ?? ?? ?? ?? 59 89 45 F0 8B 45 FC 59 85 C0 7C 11 7F 08 81 FE 00 10 00 00 72 07 B8 00 10 00 00 EB 02 8B C6 50 FF 75 F4 57 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 74 15 99 2B F0 8B 45 FC 1B C2 89 45 FC 78 23 7F C8 85 F6 74 1D EB C2 E8 ?? ?? ?? ?? 83 38 05 75 0B E8 ?? ?? ?? ?? C7 00 0D 00 00 00 83 CB FF 09 5D F8 FF 75 F0 57 E8 ?? ?? ?? ?? 59 59 FF 75 F4 6A 00 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? EB 66 85 C0 7F 6E 7C 04 85 F6 73 68 6A 00 FF 75 10 FF 75 0C 57 E8 ?? ?? ?? ?? 23 C2 83 C4 10 83 F8 FF 0F 84 43 FF FF FF 57 E8 ?? ?? ?? ?? 59 50 FF 15 ?? ?? ?? ?? F7 D8 1B C0 F7 D8 48 99 8B D8 8B C2 8B CB 23 C8 89 45 F8 83 F9 FF 75 26 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 E8 ?? ?? ?? ?? 8B F0 FF 15 ?? ?? ?? ?? 89 06 23 5D F8 83 FB FF 0F 84 F7 FE FF FF 6A 00 FF 75 EC FF 75 E8 57 E8 ?? ?? ?? ?? 23 C2 83 C4 10 83 F8 FF 0F 84 DB FE FF FF 33 C0 E9 DB FE FF FF }
	condition:
		$1
}

rule file_241_2_0 {
	meta:
		name = "__chsize_s"
		size = 244
		refs = "0003 __sehtable$__chsize_s 0008 __SEH_prolog4 0015 ___doserrno 0025 __ioinit 0037 __nhandle 0051 ___pioinfo 0076 __errno 0080 ___lock_fhandle 009f __chsize_nolock 00cd __unlock_fhandle 00e8 __invalid_parameter_noinfo 00ef __SEH_epilog4"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 08 83 FF FE 75 10 E8 ?? ?? ?? ?? 83 20 00 6A 09 58 E9 CA 00 00 00 E8 ?? ?? ?? ?? 85 C0 78 EF 85 FF 0F 88 A0 00 00 00 3B 3D ?? ?? ?? ?? 0F 83 94 00 00 00 8B DF C1 FB 05 8B F7 83 E6 1F C1 E6 06 8B 04 9D ?? ?? ?? ?? 0F BE 44 30 04 83 E0 01 74 76 83 7D 10 00 7F 19 7C 06 83 7D 0C 00 73 11 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? 6A 16 EB 66 57 E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 04 9D ?? ?? ?? ?? F6 44 30 04 01 74 13 FF 75 10 FF 75 0C 57 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 EB 0A E8 ?? ?? ?? ?? 6A 09 5E 89 30 89 75 E4 C7 45 FC FE FF FF FF E8 08 00 00 00 EB 27 8B 7D 08 8B 75 E4 57 E8 ?? ?? ?? ?? 59 C3 EB 17 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? 6A 09 5E 89 30 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_242_0_0 {
	meta:
		name = "_localeconv"
		size = 38
		refs = "0001 __getptd 000a ___ptlocinfo 0012 ___globallocalestatus 001c ___updatetlocinfo 0021 ___lconv"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B 48 6C 3B 0D ?? ?? ?? ?? 74 10 8B 0D ?? ?? ?? ?? 85 48 70 75 05 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_247_1_0 {
	meta:
		name = "__wgetdcwd"
		size = 315
		refs = "0007 ___security_cookie 0022 __validdrive 002c ___doserrno 0037 __errno 0042 __invalid_parameter_noinfo 004c __getdrive 00a8 __imp__GetFullPathNameW@16 00e5 _calloc 011f __imp__GetLastError@0 0125 __dosmaperr 0135 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 08 56 8B 75 10 57 8B 7D 0C 85 DB 74 2B 53 E8 ?? ?? ?? ?? 59 85 C0 75 27 E8 ?? ?? ?? ?? C7 00 0F 00 00 00 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 E8 ?? ?? ?? ?? E9 DF 00 00 00 E8 ?? ?? ?? ?? 8B D8 85 FF 74 1D 85 F6 7F 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB DA 33 C0 8B CE 89 75 F0 66 89 07 EB 05 33 C9 89 4D F0 85 DB 74 1D 8D 43 40 6A 3A 66 89 45 F4 58 66 89 45 F6 6A 2E 58 66 89 45 F8 33 C0 66 89 4