
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was retdec-yaramod-config.cmake                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

if(NOT TARGET yaramod-libs)
    add_library(yaramod-libs INTERFACE)
    add_library(retdec::deps::yaramod-libs ALIAS yaramod-libs)
    foreach(YARAMOD_LIB ${PACKAGE_PREFIX_DIR}/var/macports/build/_opt_bblocal_var_buildworker_ports_build_ports_devel_retdec/retdec/work/destroot${PACKAGE_PREFIX_DIR}/lib/libretdec-yaramod.a;${PACKAGE_PREFIX_DIR}/var/macports/build/_opt_bblocal_var_buildworker_ports_build_ports_devel_retdec/retdec/work/destroot${PACKAGE_PREFIX_DIR}/lib/libretdec-pog_fmt.a;${PACKAGE_PREFIX_DIR}/var/macports/build/_opt_bblocal_var_buildworker_ports_build_ports_devel_retdec/retdec/work/destroot${PACKAGE_PREFIX_DIR}/lib/libretdec-pog_re2.a)
        target_link_libraries(yaramod-libs INTERFACE
            ${YARAMOD_LIB}
        )
    endforeach(YARAMOD_LIB)
endif()

if(NOT TARGET retdec::deps::yaramod)
    include(${CMAKE_CURRENT_LIST_DIR}/retdec-yaramod-targets.cmake)
endif()
