private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule function_10_0 {
	meta:
		name = "AllocTlsBuffer"
		size = 9
		refs = "0004 LocalAlloc"
	strings:
		$1 = { 50 6A 40 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12_0 {
	meta:
		name = "InitThreadTLS"
		size = 68
		refs = "0002 GetTlsSize 000e TlsIndex 001b @RunError 0022 AllocTlsBuffer 003e TlsSetValue"
	strings:
		$1 = { 53 E8 ?? ?? ?? ?? 8B D8 85 DB 74 36 83 3D ?? ?? ?? ?? FF 75 0A B8 E2 00 00 00 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 85 C0 75 0C B8 E2 00 00 00 E8 ?? ?? ?? ?? EB 0C 50 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_13_0 {
	meta:
		name = "InitProcessTLS"
		size = 41
		refs = "0001 TlsLast 000a TlsAlloc 000f TlsIndex 0014 InitThreadTLS 001f TlsGetValue 0024 tlsBuffer"
	strings:
		$1 = { B8 ?? ?? ?? ?? 85 C0 74 1F E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_14_0 {
	meta:
		name = "ExitThreadTLS"
		size = 53
		refs = "0001 TlsLast 000b TlsIndex 0019 TlsGetValue 0023 LocalFree 0030 TlsSetValue"
	strings:
		$1 = { B8 ?? ?? ?? ?? 85 C0 74 2B 83 3D ?? ?? ?? ?? FF 74 22 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 74 13 50 E8 ?? ?? ?? ?? 6A 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15_0 {
	meta:
		name = "ExitProcessTLS"
		size = 35
		refs = "0001 TlsLast 000a ExitThreadTLS 0010 TlsIndex 001e TlsFree"
	strings:
		$1 = { B8 ?? ?? ?? ?? 85 C0 74 19 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? FF 74 0B A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_16_0 {
	meta:
		name = "@GetTls"
		size = 64
		refs = "0002 ModuleIsLib 0007 TlsIndex 001b InitThreadTLS 0026 TlsGetValue 0030 tlsBuffer"
	strings:
		$1 = { 8A 0D ?? ?? ?? ?? A1 ?? ?? ?? ?? 84 C9 75 26 64 8B 15 2C 00 00 00 8B 04 82 C3 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 74 01 C3 A1 ?? ?? ?? ?? C3 50 E8 ?? ?? ?? ?? 85 C0 74 DB C3 }
	condition:
		$1
}

rule function_18_0 {
	meta:
		name = "UninitializeModule"
		size = 34
		refs = "0001 Module 0006 UnregisterModule 001d FreeLibrary"
	strings:
		$1 = { B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 74 0A 85 C0 74 06 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_19_0 {
	meta:
		name = "VclInit"
		size = 151
		refs = "000d ModuleIsLib 0013 ModuleIsPackage 0027 IsLibrary 002f HInstance 0035 Module 0049 ModuleIsCpp 004f InitializeModule 005d VclInit 0062 FindHInstance 006c DataMark 007b GetCommandLine 0081 CmdLine 008f IsConsole"
	strings:
		$1 = { 55 8B EC 8B 4D 10 8B 55 0C 8B 45 08 A2 ?? ?? ?? ?? 88 15 ?? ?? ?? ?? 84 C0 74 04 84 D2 74 04 33 C0 EB 02 B0 01 8B 15 ?? ?? ?? ?? 88 02 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 E8 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 75 39 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 02 0F B6 45 14 34 01 8B 15 ?? ?? ?? ?? 88 02 5D C3 }
	condition:
		$1
}

rule function_20_0 {
	meta:
		name = "VclExit"
		size = 45
		refs = "0004 ExitProc 000a ModuleIsLib 0026 UninitializeModule"
	strings:
		$1 = { 53 56 8B 35 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 75 14 83 3E 00 74 0F 8B 06 89 C3 33 C0 89 06 FF D3 83 3E 00 75 F1 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_21_0 {
	meta:
		name = "@InitPkg"
		size = 99
		refs = "000d ModuleIsLib 0014 ModuleIsPackage 001a Module 002f HInstance 0034 TlsLast 003f TlsProc 004b InitializeModule 0056 UninitializeModule"
	strings:
		$1 = { 55 8B EC 53 56 8B 5D 0C 8B 45 08 C6 05 ?? ?? ?? ?? 01 C6 05 ?? ?? ?? ?? 01 A3 ?? ?? ?? ?? 33 D2 89 15 ?? ?? ?? ?? 33 D2 89 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? B8 ?? ?? ?? ?? 85 C0 74 09 8B 34 9D ?? ?? ?? ?? FF D6 83 FB 01 75 07 E8 ?? ?? ?? ?? EB 09 85 DB 75 05 E8 ?? ?? ?? ?? 83 C8 FF 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_24_0 {
	meta:
		name = "@InitLib"
		size = 70
		refs = "0001 Module 000f ModuleIsLib 0019 HInstance 002f InitializeModule 0037 DllProc 003c TlsProc 0041 @StartLib"
	strings:
		$1 = { BA ?? ?? ?? ?? 83 7D 0C 01 75 2A 50 52 C6 05 ?? ?? ?? ?? 01 8B 4D 08 89 0D ?? ?? ?? ?? 89 4A 04 C7 42 08 00 00 00 00 C7 42 0C 00 00 00 00 E8 ?? ?? ?? ?? 5A 58 FF 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_25_0 {
	meta:
		name = "@InitExe"
		size = 65
		refs = "0006 TlsIndex 000d GetModuleHandle 0012 HInstance 001c Module 002f InitializeModule 003b @StartExe"
	strings:
		$1 = { 53 8B D8 33 C0 A3 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_26_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_27_0 {
	meta:
		name = "SysInit"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28_0 {
	meta:
		name = "Abs"
		size = 4
		altNames = "Addr Append Assert Assign AssignFile Assigned BlockRead BlockWrite Break Chr Close CloseFile Concat Continue Copy Dec Delete Dispose Eof Eoln Erase Exclude Exit Fail FilePos FileSize FillChar Finalize FreeMem GetDir GetMem Halt Hi High Inc Include Initialize Insert Length Lo Low New Odd Ord Pi Pred Ptr Read Readln ReallocMem Rename Reset Rewrite Round RunError Seek SeekEof SeekEoln SetLength SetString SetTextBuf SizeOf Slice Sqr Str Succ Swap Trunc Truncate TypeHandle TypeInfo TypeOf Val VarArrayRedim VarCast VarClear VarCopy Write Writeln"
	strings:
		$1 = { 05 04 00 00 }
	condition:
		$1
}

rule function_190_0 {
	meta:
		name = "GetCmdShow"
		size = 34
		refs = "000b GetStartupInfo"
	strings:
		$1 = { 53 83 C4 BC BB 0A 00 00 00 54 E8 ?? ?? ?? ?? F6 44 24 2C 01 74 05 0F B7 5C 24 30 8B C3 83 C4 44 5B C3 }
	condition:
		$1
}

rule function_200_0 {
	meta:
		name = "LockCmpxchg"
		size = 5
	strings:
		$1 = { F0 0F B0 11 C3 }
	condition:
		$1
}

rule function_201_0 {
	meta:
		name = "Move12"
		size = 17
	strings:
		$1 = { 8B 08 89 0A 8B 48 04 8B 40 08 89 4A 04 89 42 08 C3 }
	condition:
		$1
}

rule function_202_0 {
	meta:
		name = "Move20"
		size = 29
	strings:
		$1 = { 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 48 0C 8B 40 10 89 4A 0C 89 42 10 C3 }
	condition:
		$1
}

rule function_203_0 {
	meta:
		name = "Move28"
		size = 41
	strings:
		$1 = { 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 48 0C 89 4A 0C 8B 48 10 89 4A 10 8B 48 14 8B 40 18 89 4A 14 89 42 18 C3 }
	condition:
		$1
}

rule function_204_0 {
	meta:
		name = "Move36"
		size = 29
	strings:
		$1 = { DF 28 DF 68 08 DF 68 10 DF 68 18 8B 48 20 89 4A 20 DF 7A 18 DF 7A 10 DF 7A 08 DF 3A C3 }
	condition:
		$1
}

rule function_205_0 {
	meta:
		name = "Move44"
		size = 35
	strings:
		$1 = { DF 28 DF 68 08 DF 68 10 DF 68 18 DF 68 20 8B 48 28 89 4A 28 DF 7A 20 DF 7A 18 DF 7A 10 DF 7A 08 DF 3A C3 }
	condition:
		$1
}

rule function_206_0 {
	meta:
		name = "Move52"
		size = 41
	strings:
		$1 = { DF 28 DF 68 08 DF 68 10 DF 68 18 DF 68 20 DF 68 28 8B 48 30 89 4A 30 DF 7A 28 DF 7A 20 DF 7A 18 DF 7A 10 DF 7A 08 DF 3A C3 }
	condition:
		$1
}

rule function_207_0 {
	meta:
		name = "Move60"
		size = 47
	strings:
		$1 = { DF 28 DF 68 08 DF 68 10 DF 68 18 DF 68 20 DF 68 28 DF 68 30 8B 48 38 89 4A 38 DF 7A 30 DF 7A 28 DF 7A 20 DF 7A 18 DF 7A 10 DF 7A 08 DF 3A C3 }
	condition:
		$1
}

rule function_208_0 {
	meta:
		name = "Move68"
		size = 53
	strings:
		$1 = { DF 28 DF 68 08 DF 68 10 DF 68 18 DF 68 20 DF 68 28 DF 68 30 DF 68 38 8B 48 40 89 4A 40 DF 7A 38 DF 7A 30 DF 7A 28 DF 7A 20 DF 7A 18 DF 7A 10 DF 7A 08 DF 3A C3 }
	condition:
		$1
}

rule function_209_0 {
	meta:
		name = "MoveX16L4"
		size = 45
	strings:
		$1 = { 83 E9 0C 01 C8 01 CA F7 D9 79 13 DF 2C 01 DF 6C 01 08 DF 7C 11 08 DF 3C 11 83 C1 10 78 ED DF 2C 01 DF 3C 11 8B 44 01 08 89 44 11 08 C3 }
	condition:
		$1
}

rule function_210_0 {
	meta:
		name = "MoveX8L4"
		size = 27
	strings:
		$1 = { 83 E9 04 01 C8 01 CA F7 D9 DF 2C 01 DF 3C 11 83 C1 08 78 F5 8B 04 01 89 04 11 C3 }
	condition:
		$1
}

rule function_211_0 {
	meta:
		name = "LockAllSmallBlockTypes"
		size = 76
		refs = "0004 IsMultiThread 0011 SmallBlockTypes 001a Sleep 0025 LockCmpxchg"
	strings:
		$1 = { 53 56 80 3D ?? ?? ?? ?? 00 74 3E BE 37 00 00 00 BB ?? ?? ?? ?? EB 1D 6A 00 E8 ?? ?? ?? ?? 8B CB B2 01 33 C0 E8 ?? ?? ?? ?? 84 C0 74 16 6A 0A E8 ?? ?? ?? ?? 8B CB B2 01 33 C0 E8 ?? ?? ?? ?? 84 C0 75 D4 83 C3 20 4E 75 EB 5E 5B C3 }
	condition:
		$1
}

rule function_212_0 {
	meta:
		name = "LockMediumBlocks"
		size = 62
		refs = "0002 IsMultiThread 000e Sleep 0013 MediumBlocksLocked 001c LockCmpxchg"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 00 74 34 EB 20 6A 00 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? B2 01 33 C0 E8 ?? ?? ?? ?? 84 C0 74 19 6A 0A E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? B2 01 33 C0 E8 ?? ?? ?? ?? 84 C0 75 CE C3 }
	condition:
		$1
}

rule function_218_0 {
	meta:
		name = "LockLargeBlocks"
		size = 62
		refs = "0002 IsMultiThread 000e Sleep 0013 LargeBlocksLocked 001c LockCmpxchg"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 00 74 34 EB 20 6A 00 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? B2 01 33 C0 E8 ?? ?? ?? ?? 84 C0 74 19 6A 0A E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? B2 01 33 C0 E8 ?? ?? ?? ?? 84 C0 75 CE C3 }
	condition:
		$1
}

rule function_213_0 {
	meta:
		name = "RemoveMediumFreeBlock"
		size = 62
		refs = "0012 MediumBlockBins 0028 MediumBlockBinBitmaps 0039 MediumBlockBinGroupBitmap"
	strings:
		$1 = { 8B 48 04 8B 10 39 D1 89 11 89 4A 04 74 02 C3 90 81 E9 ?? ?? ?? ?? 89 CA C1 E9 03 0F B6 D6 B8 FE FF FF FF D3 C0 21 04 95 ?? ?? ?? ?? 75 E0 B8 FE FF FF FF 89 D1 D3 C0 21 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_214_0 {
	meta:
		name = "InsertMediumBlockIntoBin"
		size = 96
		refs = "001c MediumBlockBins 004c MediumBlockBinBitmaps 005b MediumBlockBinGroupBitmap"
	strings:
		$1 = { 81 EA 30 0B 00 00 C1 EA 08 81 EA FF 03 00 00 19 C9 21 CA 81 C2 FF 03 00 00 8D 0C D5 ?? ?? ?? ?? 8B 51 04 39 CA 89 08 89 50 04 89 02 89 41 04 74 03 C3 90 90 81 E9 ?? ?? ?? ?? 89 CA C1 E9 03 0F B6 D6 B8 01 00 00 00 D3 E0 09 04 95 ?? ?? ?? ?? B8 01 00 00 00 89 D1 D3 E0 09 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_215_0 {
	meta:
		name = "BinMediumSequentialFeedRemainder"
		size = 107
		refs = "0002 MediumSequentialFeedBytesLeft 000d LastSequentiallyFedMediumBlock 0035 InsertMediumBlockIntoBin 004d RemoveMediumFreeBlock"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 03 C3 90 90 A1 ?? ?? ?? ?? F6 40 FC 01 75 25 83 48 FC 08 8B 15 ?? ?? ?? ?? 29 D0 8D 4A 03 89 48 FC 89 54 02 F8 81 FA 30 0B 00 00 0F 83 ?? ?? ?? ?? C3 90 90 BA F0 FF FF FF 23 50 FC 81 FA 30 0B 00 00 72 12 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? BA F0 FF FF FF 23 50 FC 8B 0D ?? ?? ?? ?? 29 C8 01 CA EB B9 C3 }
	condition:
		$1
}

rule function_216_0 {
	meta:
		name = "AllocNewSequentialFeedMediumPool"
		size = 119
		refs = "0004 BinMediumSequentialFeedRemainder 0017 VirtualAlloc 0021 MediumBlockPoolsCircularList 0053 MediumSequentialFeedBytesLeft 005c LastSequentiallyFedMediumBlock"
	strings:
		$1 = { 53 8B D8 E8 ?? ?? ?? ?? 6A 04 68 00 10 00 00 68 00 00 14 00 6A 00 E8 ?? ?? ?? ?? 85 C0 74 4D 8B 15 ?? ?? ?? ?? 8B C8 C7 01 ?? ?? ?? ?? A3 ?? ?? ?? ?? 89 51 04 89 02 8B D0 81 C2 00 00 14 00 8B CA 83 E9 04 C7 01 02 00 00 00 B9 F0 FF 13 00 2B CB 89 0D ?? ?? ?? ?? 2B D3 8B C2 A3 ?? ?? ?? ?? 83 CB 02 8B D0 83 EA 04 89 1A 5B C3 33 C0 A3 ?? ?? ?? ?? 33 C0 5B C3 }
	condition:
		$1
}

rule function_217_0 {
	meta:
		name = "FreeMediumBlockPool"
		size = 24
		refs = "0013 VirtualFree"
	strings:
		$1 = { 8B 10 8B 48 04 89 4A 04 89 11 68 00 80 00 00 6A 00 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_219_0 {
	meta:
		name = "AllocateLargeBlock"
		size = 98
		refs = "0021 VirtualAlloc 0037 LockLargeBlocks 003c LargeBlocksCircularList 0053 LargeBlocksLocked"
	strings:
		$1 = { 53 56 57 55 8B E8 8D B5 10 00 01 00 4E 83 C6 04 81 E6 00 00 FF FF 6A 04 68 00 10 10 00 56 6A 00 E8 ?? ?? ?? ?? 8B D8 85 DB 74 30 8B FB 89 6F 08 83 CE 04 89 77 0C E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 07 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 89 47 04 89 18 C6 05 ?? ?? ?? ?? 00 83 C3 10 8B C3 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_220_0 {
	meta:
		name = "FreeLargeBlock"
		size = 60
		refs = "0009 LockLargeBlocks 001d VirtualFree 0033 LargeBlocksLocked"
	strings:
		$1 = { 53 56 57 8B D8 83 EB 10 E8 ?? ?? ?? ?? 8B C3 8B 30 8B 78 04 68 00 80 00 00 6A 00 53 E8 ?? ?? ?? ?? 85 C0 74 09 89 37 89 7E 04 33 C0 EB 03 83 C8 FF C6 05 ?? ?? ?? ?? 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_221_0 {
	meta:
		name = "SysGetMem"
		size = 872
		refs = "000e IsMultiThread 001d AllocSize2SmallBlockTypeIndX4 0024 SmallBlockTypes 00ad Sleep 00e0 MediumBlocksLocked 010e MediumBlockBinGroupBitmap 0121 MediumBlockBinBitmaps 012e MediumBlockBins 017e InsertMediumBlockIntoBin 018a MediumSequentialFeedBytesLeft 0194 LastSequentiallyFedMediumBlock 01bf AllocNewSequentialFeedMediumPool 0361 AllocateLargeBlock"
	strings:
		$1 = { 8D 50 03 C1 EA 03 3D 2C 0A 00 00 53 8A 0D ?? ?? ?? ?? 0F 87 2C 02 00 00 84 C9 0F B6 82 ?? ?? ?? ?? 8D 1C C5 ?? ?? ?? ?? 75 56 8B 53 04 8B 42 08 B9 F8 FF FF FF 39 DA 74 17 83 42 0C 01 23 48 FC 89 4A 08 89 50 FC 74 28 C6 03 00 5B C3 90 90 90 8B 53 10 0F B7 4B 02 01 C1 3B 43 0C 77 6E 83 42 0C 01 89 4B 08 C6 03 00 89 50 FC 5B C3 90 90 90 8B 4A 04 89 59 14 89 4B 04 C6 03 00 5B C3 90 90 B8 00 01 00 00 F0 0F B0 23 74 9F 83 C3 20 B8 00 01 00 00 F0 0F B0 23 74 91 83 C3 20 B8 00 01 00 00 F0 0F B0 23 74 83 83 EB 40 6A 00 E8 ?? ?? ?? ?? B8 00 01 00 00 F0 0F B0 23 0F 84 6A FF FF FF 6A 0A E8 ?? ?? ?? ?? EB B7 90 90 90 56 57 80 3D ?? ?? ?? ?? 00 74 31 B8 00 01 00 00 F0 0F B0 25 ?? ?? ?? ?? 74 22 6A 00 E8 ?? ?? ?? ?? B8 00 01 00 00 F0 0F B0 25 ?? ?? ?? ?? 74 0C 6A 0A E8 ?? ?? ?? ?? EB D2 90 90 90 0F BE 73 01 23 35 ?? ?? ?? ?? 74 70 0F BC C6 8D 34 C5 00 00 00 00 8B 0C 85 ?? ?? ?? ?? 0F BC C9 8D 0C B1 8D 3C CD ?? ?? ?? ?? 8B 77 04 8B 56 04 89 57 04 89 3A 39 D7 75 17 BA FE FF FF FF D3 C2 21 14 85 ?? ?? ?? ?? 75 07 0F B3 05 ?? ?? ?? ?? BF F0 FF FF FF 23 7E FC 81 FF 60 0A 01 00 72 6C 89 FA 0F B7 7B 1A 29 FA 8D 04 37 8D 4A 03 89 48 FC 89 54 02 F8 E8 ?? ?? ?? ?? EB 55 0F B7 4B 18 8B 3D ?? ?? ?? ?? 39 CF 72 26 8B 35 ?? ?? ?? ?? 0F B7 4B 1A 8D 91 30 0B 00 00 39 D7 72 02 89 CF 29 FE 29 3D ?? ?? ?? ?? 89 35 ?? ?? ?? ?? EB 21 0F B7 43 1A 89 C7 E8 ?? ?? ?? ?? 89 C6 85 C0 75 10 A2 ?? ?? ?? ?? 88 03 5F 5E 5B C3 80 64 37 FC F7 8D 4F 06 89 4E FC 31 C0 A2 ?? ?? ?? ?? 89 1E 89 46 08 C7 46 0C 01 00 00 00 89 73 10 8D 46 20 0F B7 4B 02 8D 14 01 89 53 08 01 F7 29 CF 89 7B 0C C6 03 00 89 70 FC 5F 5E 5B C3 90 B8 00 01 00 00 F0 0F B0 25 ?? ?? ?? ?? 74 3F 6A 00 E8 ?? ?? ?? ?? B8 00 01 00 00 F0 0F B0 25 ?? ?? ?? ?? 74 29 6A 0A E8 ?? ?? ?? ?? EB D2 90 90 3D 2C 0A 04 00 0F 87 0D 01 00 00 8D 98 D3 00 00 00 81 E3 00 FF FF FF 83 C3 30 84 C9 75 B2 8D 93 D0 F4 FF FF 89 D1 C1 EA 0D C1 E9 08 B8 FF FF FF FF D3 E0 23 04 95 ?? ?? ?? ?? 74 0C 83 E1 E0 0F BC C0 09 C1 EB 5E 90 90 B8 FE FF FF FF 89 D1 D3 E0 23 05 ?? ?? ?? ?? 74 17 0F BC D0 8B 04 95 ?? ?? ?? ?? 0F BC C8 89 D0 C1 E0 05 09 C1 EB 35 90 8B 0D ?? ?? ?? ?? 29 D9 72 1A A1 ?? ?? ?? ?? 29 D8 A3 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 83 CB 02 89 58 FC EB 07 89 D8 E8 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 00 5B C3 56 57 8D 3C CD ?? ?? ?? ?? 8B 77 04 8B 46 04 89 47 04 89 38 39 C7 75 17 B8 FE FF FF FF D3 C0 21 04 95 ?? ?? ?? ?? 75 07 0F B3 15 ?? ?? ?? ?? BF F0 FF FF FF 23 7E FC 89 FA 29 DA 74 1F 8D 04 33 8D 4A 03 89 48 FC 89 54 02 F8 81 FA 30 0B 00 00 72 0F E8 ?? ?? ?? ?? EB 08 90 90 90 80 64 37 FC F7 8D 4B 02 89 4E FC C6 05 ?? ?? ?? ?? 00 89 F0 5F 5E 5B C3 5B 85 C0 0F 89 ?? ?? ?? ?? 31 C0 C3 }
	condition:
		$1
}

rule function_222_0 {
	meta:
		name = "SysFreeMem"
		size = 480
		refs = "000b IsMultiThread 008c Sleep 00b9 MediumBlocksLocked 0127 InsertMediumBlockIntoBin 0149 RemoveMediumFreeBlock 016a MediumSequentialFeedBytesLeft 0191 VirtualFree 01a7 BinMediumSequentialFeedRemainder 01be LastSequentiallyFedMediumBlock 01d6 FreeLargeBlock"
	strings:
		$1 = { 8B 50 FC F6 C2 07 89 C1 53 8A 1D ?? ?? ?? ?? 0F 85 CB 00 00 00 84 DB 8B 1A 75 61 83 6A 0C 01 8B 42 08 74 2C 85 C0 89 4A 08 8D 40 01 89 41 FC 74 07 31 C0 88 03 5B C3 90 8B 4B 04 89 5A 14 89 4A 04 89 51 14 89 53 04 C6 03 00 31 C0 5B C3 90 90 85 C0 74 13 8B 42 14 8B 4A 04 89 48 04 89 41 14 31 C0 39 53 10 75 03 89 43 0C 88 03 89 D0 8B 52 FC 8A 1D ?? ?? ?? ?? EB 70 90 90 90 B8 00 01 00 00 F0 0F B0 23 74 94 51 52 6A 00 E8 ?? ?? ?? ?? 5A 59 B8 00 01 00 00 F0 0F B0 23 0F 84 7A FF FF FF 51 52 6A 0A E8 ?? ?? ?? ?? 5A 59 EB CE 90 90 B8 00 01 00 00 F0 0F B0 25 ?? ?? ?? ?? 74 36 6A 00 E8 ?? ?? ?? ?? B8 00 01 00 00 F0 0F B0 25 ?? ?? ?? ?? 74 20 6A 0A E8 ?? ?? ?? ?? EB D2 90 90 F6 C2 05 0F 85 E7 00 00 00 83 E2 F0 84 DB 89 D3 56 89 C6 75 BB F7 44 33 FC 01 00 00 00 8B 4C 33 FC 75 35 83 C9 08 89 4C 33 FC F6 46 FC 08 75 40 81 FB F0 FF 13 00 74 50 8D 43 03 89 46 FC 89 5C 33 F8 89 F0 89 DA E8 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 00 31 C0 5E 5B C3 90 8D 04 33 83 E1 F0 01 CB 81 F9 30 0B 00 00 72 C2 E8 ?? ?? ?? ?? EB BB 90 8B 4E F8 29 CE 01 CB 81 F9 30 0B 00 00 72 B1 89 F0 E8 ?? ?? ?? ?? EB A8 81 3D ?? ?? ?? ?? F0 FF 13 00 75 2C 83 EE 10 8B 06 8B 56 04 89 50 04 89 02 C6 05 ?? ?? ?? ?? 00 68 00 80 00 00 6A 00 56 E8 ?? ?? ?? ?? 83 F8 01 19 C0 5E 5B C3 90 90 90 8D 9E F0 FF 13 00 E8 ?? ?? ?? ?? C7 43 FC 02 00 00 00 C7 05 ?? ?? ?? ?? F0 FF 13 00 89 1D ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 00 31 C0 5E 5B C3 90 90 5B F6 C2 03 0F 84 ?? ?? ?? ?? B8 FF FF FF FF C3 }
	condition:
		$1
}

rule function_223_0 {
	meta:
		name = "SysReallocMem"
		size = 901
		refs = "0031 SysGetMem 0042 MoveX8L4 0049 SysFreeMem 00f7 IsMultiThread 0107 MediumBlocksLocked 0111 Sleep 0162 RemoveMediumFreeBlock 017e InsertMediumBlockIntoBin 02d9 MoveX16L4"
	strings:
		$1 = { 8B 48 FC F6 C1 07 53 56 89 C6 0F 85 88 00 00 00 8B 19 0F B7 4B 02 83 E9 04 39 D1 72 37 8D 1C 95 40 00 00 00 39 CB 72 04 5E 5B C3 90 89 D3 89 D0 E8 ?? ?? ?? ?? 85 C0 74 16 89 D9 89 C2 89 C3 89 F0 E8 ?? ?? ?? ?? 89 F0 E8 ?? ?? ?? ?? 89 D8 5E 5B C3 90 90 8D 4C 09 20 57 89 D7 31 C0 29 D1 83 D0 FF 21 C8 01 D0 E8 ?? ?? ?? ?? 85 C0 74 24 81 FF 2C 0A 04 00 76 03 89 78 F8 0F B7 4B 02 83 E9 04 89 C2 89 C7 89 F0 FF 53 1C 89 F0 E8 ?? ?? ?? ?? 89 F8 5F 5E 5B C3 90 F6 C1 05 0F 85 4B 02 00 00 89 CB 83 E1 F0 57 8D 3C 01 83 E9 04 83 E3 0F 39 CA 55 0F 87 FF 00 00 00 8D 2C 12 39 CD 72 08 5D 5F 5E 5B C3 90 90 90 81 FA 2C 0B 00 00 73 11 81 FD 2C 0B 00 00 0F 82 B4 00 00 00 BA 2C 0B 00 00 8D AA D3 00 00 00 81 E5 00 FF FF FF 83 C5 30 83 C1 04 29 E9 80 3D ?? ?? ?? ?? 00 74 3A B8 00 01 00 00 F0 0F B0 25 ?? ?? ?? ?? 74 23 51 6A 00 E8 ?? ?? ?? ?? 59 B8 00 01 00 00 F0 0F B0 25 ?? ?? ?? ?? 74 0B 51 6A 0A E8 ?? ?? ?? ?? 59 EB CE BB 0F 00 00 00 23 5E FC 09 EB 89 5E FC 89 CB 8B 57 FC F6 C2 01 75 09 83 CA 08 89 57 FC EB 17 90 89 F8 83 E2 F0 01 D3 01 D7 81 FA 30 0B 00 00 72 05 E8 ?? ?? ?? ?? 89 5F F8 8D 43 03 89 44 2E FC 81 FB 30 0B 00 00 72 0A 8D 04 2E 89 DA E8 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 00 89 F0 5D 5F 5E 5B C3 89 D7 89 D0 E8 ?? ?? ?? ?? 85 C0 74 16 89 C5 89 C2 89 F0 89 F9 E8 ?? ?? ?? ?? 89 F0 E8 ?? ?? ?? ?? 89 E8 5D 5F 5E 5B C3 8B 47 FC A8 01 0F 84 E1 00 00 00 83 E0 F0 8D 2C 01 39 EA 0F 87 D3 00 00 00 80 3D ?? ?? ?? ?? 00 74 4F B8 00 01 00 00 F0 0F B0 25 ?? ?? ?? ?? 74 27 51 52 6A 00 E8 ?? ?? ?? ?? 5A 59 B8 00 01 00 00 F0 0F B0 25 ?? ?? ?? ?? 74 0D 51 52 6A 0A E8 ?? ?? ?? ?? 5A 59 EB CA BB 0F 00 00 00 23 5E FC 8B 47 FC A8 01 74 7E 83 E0 F0 8D 2C 01 39 EA 77 74 3D 30 0B 00 00 72 0B 89 F8 51 52 E8 ?? ?? ?? ?? 5A 59 89 C8 C1 E8 02 01 C8 31 FF 29 D0 83 D7 FF 21 F8 8D 84 02 D3 00 00 00 25 00 FF FF FF 83 C0 30 8D 55 04 29 C2 77 0B 83 24 2E F7 83 C5 04 EB 1E 90 90 89 54 2E FC 8D 7A 03 89 7C 30 FC 89 C5 81 FA 30 0B 00 00 72 07 01 F0 E8 ?? ?? ?? ?? 09 DD 89 6E FC C6 05 ?? ?? ?? ?? 00 89 F0 5D 5F 5E 5B C3 90 90 C6 05 ?? ?? ?? ?? 00 89 C8 C1 E8 02 01 C8 31 FF 29 D0 83 D7 FF 21 F8 01 D0 89 C5 89 CF 52 E8 ?? ?? ?? ?? 5A 85 C0 74 D1 81 FD 2C 0A 04 00 76 03 89 50 F8 89 C5 89 C2 89 F0 89 F9 E8 ?? ?? ?? ?? 89 F0 E8 ?? ?? ?? ?? 89 E8 5D 5F 5E 5B C3 90 F6 C1 03 0F 85 8B 00 00 00 83 E9 18 39 CA 76 44 89 C8 C1 E9 02 01 C1 31 C0 29 D1 83 D0 FF 21 C8 01 D0 89 C3 52 E8 ?? ?? ?? ?? 5A 85 C0 74 22 81 FB 2C 0A 04 00 76 03 89 50 F8 8B 4E F8 89 C3 89 C2 89 F0 E8 ?? ?? ?? ?? 89 F0 E8 ?? ?? ?? ?? 89 D8 5E 5B C3 D1 E9 39 CA 72 06 89 50 F8 5E 5B C3 89 D3 89 D0 E8 ?? ?? ?? ?? 85 C0 74 E4 81 FB 2C 0A 04 00 76 03 89 58 F8 89 D9 89 C3 89 C2 89 F0 E8 ?? ?? ?? ?? 89 F0 E8 ?? ?? ?? ?? 89 D8 5E 5B C3 90 90 90 31 C0 5E 5B C3 }
	condition:
		$1
}

rule function_224_0 {
	meta:
		name = "SysAllocMem"
		size = 48
		refs = "0008 SysGetMem"
	strings:
		$1 = { 53 8D 58 FF 83 E3 FC E8 ?? ?? ?? ?? 83 F8 01 19 C9 8D 14 03 09 CB 81 FB 2C 0A 04 00 73 10 F7 DB D9 EE DD 14 13 83 C3 08 78 F8 89 0A DD C0 5B C3 }
	condition:
		$1
}

rule function_225_0 {
	meta:
		name = "NextMediumBlock"
		size = 33
	strings:
		$1 = { 8B C8 8B D1 83 EA 04 8B 12 83 E2 F0 03 D1 8B C2 8B D0 83 EA 04 8B 12 83 E2 F0 85 D2 75 02 33 C0 C3 }
	condition:
		$1
}

rule function_226_0 {
	meta:
		name = "GetFirstMediumBlockInPool"
		size = 61
		refs = "0002 MediumSequentialFeedBytesLeft 000b LastSequentiallyFedMediumBlock"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 1A 8B 15 ?? ?? ?? ?? 3B D0 72 10 8B D0 81 C2 00 00 14 00 3B 15 ?? ?? ?? ?? 73 04 83 C0 10 C3 81 3D ?? ?? ?? ?? F0 FF 13 00 74 07 A1 ?? ?? ?? ?? EB 02 33 C0 C3 }
	condition:
		$1
}

rule function_227_0 {
	meta:
		name = "GetFirstAndLastSmallBlockInPool"
		size = 58
	strings:
		$1 = { 53 56 8B D8 83 C3 20 89 1A 8B 10 3B 42 10 75 08 8B 5A 08 3B 5A 0C 76 19 8B F0 8B DE 83 EB 04 8B 1B 83 E3 F0 03 DE 0F B7 42 02 2B D8 89 19 5E 5B C3 8B 42 08 48 89 01 5E 5B C3 }
	condition:
		$1
}

rule function_228_0 {
	meta:
		name = "CardinalToStrBuf"
		size = 281
	strings:
		$1 = { 57 89 D7 83 C0 01 BA 41 5F 70 89 F7 E2 C1 E8 1E 89 D1 81 E2 FF FF FF 1F C1 E9 1D 8D 14 92 01 C2 89 C8 83 C8 30 88 07 89 D0 83 F9 01 83 DF FF C1 E8 1C 81 E2 FF FF FF 0F 09 C1 83 C8 30 88 07 8D 04 92 8D 14 92 83 F9 01 83 DF FF C1 E8 1B 81 E2 FF FF FF 07 09 C1 83 C8 30 88 07 8D 04 92 8D 14 92 83 F9 01 83 DF FF C1 E8 1A 81 E2 FF FF FF 03 09 C1 83 C8 30 88 07 8D 04 92 8D 14 92 83 F9 01 83 DF FF C1 E8 19 81 E2 FF FF FF 01 09 C1 83 C8 30 88 07 8D 04 92 8D 14 92 83 F9 01 83 DF FF C1 E8 18 81 E2 FF FF FF 00 09 C1 83 C8 30 88 07 8D 04 92 8D 14 92 83 F9 01 83 DF FF C1 E8 17 81 E2 FF FF 7F 00 09 C1 83 C8 30 88 07 8D 04 92 8D 14 92 83 F9 01 83 DF FF C1 E8 16 81 E2 FF FF 3F 00 09 C1 83 C8 30 88 07 8D 04 92 8D 14 92 83 F9 01 83 DF FF C1 E8 15 81 E2 FF FF 1F 00 09 C1 83 C8 30 88 07 8D 04 92 83 F9 01 83 DF FF C1 E8 14 83 C8 30 88 07 8D 47 01 5F C3 }
	condition:
		$1
}

rule function_229_0 {
	meta:
		name = "AppendStringToBuffer"
		size = 22
		refs = "000b Move"
	strings:
		$1 = { 53 56 8B F1 8B DA 8B D3 8B CE E8 ?? ?? ?? ?? 8B C3 03 C6 5E 5B C3 }
	condition:
		$1
}

rule function_230_0 {
	meta:
		name = "InternalIsValidClass"
		size = 181
		refs = "003a VirtualQuery 00a2 InternalIsValidClass"
	strings:
		$1 = { 55 8B EC 53 56 8B F2 8B D8 8B D3 8B CA 83 C1 B4 8B 45 08 8B 40 E4 3B C8 72 10 8B 4D 08 8B 4D 08 03 41 F0 83 C2 DF 3B C2 73 14 6A 1C 8B 45 08 83 C0 E4 50 8B C3 83 C0 B4 50 E8 ?? ?? ?? ?? 81 FE E8 03 00 00 7D 3C 8B 45 08 8B 40 E4 8B 55 08 03 42 F0 8B D3 83 C2 DF 3B C2 76 27 8B 45 08 81 78 F4 00 10 00 00 75 1B 8B 45 08 F6 40 F8 E6 74 12 8B 45 08 F6 40 F9 01 75 09 8B C3 83 C0 B4 3B 18 74 04 33 C0 EB 02 B0 01 84 C0 74 25 83 C3 DC 8B 1B 85 DB 74 1A 8B 45 08 50 8D 56 01 8B C3 83 E8 B4 E8 ?? ?? ?? ?? 59 84 C0 75 04 33 C0 EB 02 B0 01 5E 5B 5D C3 }
	condition:
		$1
}

rule function_231_0 {
	meta:
		name = "GetObjectClass"
		size = 46
		refs = "001c InternalIsValidClass"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 8B 18 33 C0 89 45 F0 81 FB 00 00 01 00 72 0F 55 33 D2 8B C3 E8 ?? ?? ?? ?? 59 84 C0 75 02 33 DB 8B C3 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_232_0 {
	meta:
		name = "LockExpectedMemoryLeaksList"
		size = 105
		refs = "0002 IsMultiThread 000e Sleep 0013 ExpectedMemoryLeaksListLocked 001c LockCmpxchg 003f ExpectedMemoryLeaks 0055 VirtualAlloc"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 00 74 34 EB 20 6A 00 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? B2 01 33 C0 E8 ?? ?? ?? ?? 84 C0 74 19 6A 0A E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? B2 01 33 C0 E8 ?? ?? ?? ?? 84 C0 75 CE 83 3D ?? ?? ?? ?? 00 75 18 6A 04 68 00 10 00 00 68 00 00 01 00 6A 00 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 0F 95 C0 C3 }
	condition:
		$1
}

rule function_233_0 {
	meta:
		name = "SysRegisterExpectedMemoryLeak"
		size = 64
		refs = "0004 LockExpectedMemoryLeaksList 000d ExpectedMemoryLeaks 0039 ExpectedMemoryLeaksListLocked"
	strings:
		$1 = { 53 8B D8 E8 ?? ?? ?? ?? 84 C0 74 29 A1 ?? ?? ?? ?? 81 38 FE 3F 00 00 7D 1C A1 ?? ?? ?? ?? 8B 00 8B 15 ?? ?? ?? ?? 89 5C 82 04 A1 ?? ?? ?? ?? FF 00 B0 01 EB 02 33 C0 C6 05 ?? ?? ?? ?? 00 5B C3 }
	condition:
		$1
}

rule function_234_0 {
	meta:
		name = "SysUnregisterExpectedMemoryLeak"
		size = 86
		refs = "0006 ExpectedMemoryLeaks 0012 LockExpectedMemoryLeaksList 004b ExpectedMemoryLeaksListLocked"
	strings:
		$1 = { 53 56 57 8B F0 BF ?? ?? ?? ?? 33 DB 83 3F 00 74 3F E8 ?? ?? ?? ?? 84 C0 74 36 8B 07 8B 10 4A 85 D2 7C 26 42 33 C0 8B 0F 3B 74 81 04 75 17 8B 17 8B 12 8B 0F 8B 14 91 8B 0F 89 54 81 04 8B 17 FF 0A B3 01 EB 04 40 4A 75 DD C6 05 ?? ?? ?? ?? 00 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_235_0 {
	meta:
		name = "CheckSmallBlockPoolForLeaks"
		size = 330
		refs = "0013 SmallBlockTypes 0031 GetFirstAndLastSmallBlockInPool 004d SysUnregisterExpectedMemoryLeak 0069 GetObjectClass"
	strings:
		$1 = { 55 8B EC 83 C4 E0 53 56 57 89 45 FC 8B 45 FC 8B 00 81 E8 ?? ?? ?? ?? C1 E8 05 C1 E0 08 8B 55 08 8D B4 C2 00 48 FE FF 8D 4D E4 8D 55 E8 8B 45 FC E8 ?? ?? ?? ?? E9 FD 00 00 00 8B 45 E8 83 E8 04 F6 00 01 0F 85 E2 00 00 00 8B 45 E8 E8 ?? ?? ?? ?? 84 C0 0F 85 D2 00 00 00 8B 45 08 C6 80 FF 47 FE FF 00 33 DB 8B 45 E8 E8 ?? ?? ?? ?? 8B F8 85 FF 0F 85 88 00 00 00 8B 45 E8 81 38 00 01 00 00 0F 83 A1 00 00 00 8B 45 E8 83 C0 04 8B 00 89 45 F4 83 7D F4 00 0F 8E 8C 00 00 00 8B 45 FC 8B 00 0F B7 40 02 83 E8 0D 3B 45 F4 7E 7B 8B 45 E8 83 C0 08 89 45 F0 C6 45 EF 01 8B 45 F4 85 C0 7E 2A 89 45 E0 80 7D EF 00 74 10 8B 45 F0 80 38 20 72 08 8B 45 F0 80 38 80 72 04 33 C0 EB 02 B0 01 88 45 EF FF 45 F0 FF 4D E0 75 D9 80 7D EF 00 74 37 8B 45 F0 80 38 00 75 2F BB 01 00 00 00 EB 28 BB 02 00 00 00 3B 3C DE 74 0F 83 3C DE 00 74 09 43 81 FB FF 00 00 00 7E EC 81 FB FF 00 00 00 7F 05 89 3C DE EB 02 33 DB FF 44 DE 04 8B 45 FC 8B 00 0F B7 40 02 01 45 E8 8B 45 E8 3B 45 E4 0F 86 F7 FE FF FF 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_236_0 {
	meta:
		name = "ScanForMemoryLeaks"
		size = 1144
		refs = "002d @FillChar 0054 MediumBlockPoolsCircularList 0060 GetFirstMediumBlockInPool 0085 CheckSmallBlockPoolForLeaks 00a7 SysUnregisterExpectedMemoryLeak 00d2 NextMediumBlock 00ed LargeBlocksCircularList 0161 ScanForMemoryLeaks 016b AppendStringToBuffer 0181 SmallBlockTypes 020c CardinalToStrBuf 0290 TObject.ClassName 039f MessageBox"
	strings:
		$1 = { 55 8B EC 50 B8 27 00 00 00 81 C4 04 F0 FF FF 50 48 75 F6 8B 45 FC 81 C4 DC F6 FF FF 53 56 57 8D 85 00 48 FE FF 33 C9 BA 00 B8 01 00 E8 ?? ?? ?? ?? 8D 85 D8 07 FE FF 33 C9 BA 00 40 00 00 E8 ?? ?? ?? ?? 33 C0 89 85 F8 47 FE FF C6 85 FF 47 FE FF 01 8B 3D ?? ?? ?? ?? E9 82 00 00 00 8B C7 E8 ?? ?? ?? ?? 8B D8 85 DB 74 72 8B C3 83 E8 04 8B 30 F7 C6 01 00 00 00 75 56 F7 C6 04 00 00 00 74 0B 55 8B C3 E8 ?? ?? ?? ?? 59 EB 43 81 BD F8 47 FE FF 00 10 00 00 7D 37 83 E6 F0 83 EE 04 89 B5 EC 47 FE FF 8B C3 E8 ?? ?? ?? ?? 84 C0 75 20 C6 85 FF 47 FE FF 00 8B 85 F8 47 FE FF 8B 95 EC 47 FE FF 89 94 85 D8 07 FE FF FF 85 F8 47 FE FF 8B C3 E8 ?? ?? ?? ?? 8B D8 85 DB 75 8E 8B 7F 04 81 FF ?? ?? ?? ?? 0F 85 72 FF FF FF 8B 1D ?? ?? ?? ?? EB 37 8B C3 83 C0 10 E8 ?? ?? ?? ?? 84 C0 75 26 C6 85 FF 47 FE FF 00 8B 73 0C 83 E6 F0 83 EE 04 83 EE 10 8B 85 F8 47 FE FF 89 B4 85 D8 07 FE FF FF 85 F8 47 FE FF 8B 5B 04 81 FB ?? ?? ?? ?? 74 0C 81 BD F8 47 FE FF 00 10 00 00 7C B5 80 BD FF 47 FE FF 00 0F 85 58 02 00 00 C6 85 F7 47 FE FF 00 33 C0 89 85 E8 47 FE FF 8D 95 D8 87 FD FF B8 ?? ?? ?? ?? B9 28 00 00 00 E8 ?? ?? ?? ?? 8B D8 C7 85 F0 47 FE FF 37 00 00 00 C7 85 DC 47 FE FF ?? ?? ?? ?? 8D 85 FC 4F FE FF 89 85 D8 47 FE FF 8B 85 DC 47 FE FF 0F B7 00 83 E8 04 89 85 E4 47 FE FF C6 85 F6 47 FE FF 00 BF FF 00 00 00 8B 85 D8 47 FE FF 8B F0 8D 85 D7 FF FD FF 3B D8 0F 87 09 01 00 00 83 3E 00 0F 86 F3 00 00 00 80 BD F7 47 FE FF 00 75 1A B8 ?? ?? ?? ?? B9 27 00 00 00 8B D3 E8 ?? ?? ?? ?? 8B D8 C6 85 F7 47 FE FF 01 80 BD F6 47 FE FF 00 75 4F C6 03 0D 43 C6 03 0A 43 8B 85 E8 47 FE FF 40 8B D3 E8 ?? ?? ?? ?? 8B D8 C6 03 20 43 C6 03 2D 43 C6 03 20 43 8B D3 8B 85 E4 47 FE FF E8 ?? ?? ?? ?? 8B D8 B8 ?? ?? ?? ?? B9 08 00 00 00 8B D3 E8 ?? ?? ?? ?? 8B D8 C6 85 F6 47 FE FF 01 EB 08 C6 03 2C 43 C6 03 20 43 8B C7 83 E8 01 72 04 74 17 EB 2A B8 ?? ?? ?? ?? B9 07 00 00 00 8B D3 E8 ?? ?? ?? ?? 8B D8 EB 39 B8 ?? ?? ?? ?? B9 06 00 00 00 8B D3 E8 ?? ?? ?? ?? 8B D8 EB 24 8D 95 D8 86 FD FF 8B 46 FC E8 ?? ?? ?? ?? 0F B6 8D D8 86 FD FF 8D 85 D9 86 FD FF 8B D3 E8 ?? ?? ?? ?? 8B D8 C6 03 20 43 C6 03 78 43 C6 03 20 43 8B 06 8B D3 E8 ?? ?? ?? ?? 8B D8 4F 83 EE 08 83 FF FF 0F 85 E9 FE FF FF 8B 85 E4 47 FE FF 89 85 E8 47 FE FF 81 85 D8 47 FE FF 00 08 00 00 83 85 DC 47 FE FF 20 FF 8D F0 47 FE FF 0F 85 9A FE FF FF 83 BD F8 47 FE FF 00 7E 7A 80 BD F7 47 FE FF 00 74 10 C6 03 0D 43 C6 03 0A 43 C6 03 0D 43 C6 03 0A 43 B8 ?? ?? ?? ?? B9 3C 00 00 00 8B D3 E8 ?? ?? ?? ?? 8B D8 8B BD F8 47 FE FF 4F 85 FF 72 43 47 C7 85 E0 47 FE FF 00 00 00 00 8D B5 D8 07 FE FF 83 BD E0 47 FE FF 00 74 08 C6 03 2C 43 C6 03 20 43 8B 06 8B D3 E8 ?? ?? ?? ?? 8B D8 8D 85 D7 FF FD FF 3B D8 77 0C FF 85 E0 47 FE FF 83 C6 04 4F 75 CE B8 ?? ?? ?? ?? B9 03 00 00 00 8B D3 E8 ?? ?? ?? ?? 68 10 20 00 00 68 ?? ?? ?? ?? 8D 85 D8 87 FD FF 50 6A 00 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 00 00 41 6E 20 75 6E 65 78 70 65 63 74 65 64 20 6D 65 6D 6F 72 79 20 6C 65 61 6B 20 68 61 73 20 6F 63 63 75 72 72 65 64 2E 20 00 00 00 00 54 68 65 20 75 6E 65 78 70 65 63 74 65 64 20 73 6D 61 6C 6C 20 62 6C 6F 63 6B 20 6C 65 61 6B 73 20 61 72 65 3A 0D 0A 00 20 62 79 74 65 73 3A 20 00 00 00 00 55 6E 6B 6E 6F 77 6E 00 53 74 72 69 6E 67 00 00 54 68 65 20 73 69 7A 65 73 20 6F 66 20 75 6E 65 78 70 65 63 74 65 64 20 6C 65 61 6B 65 64 20 6D 65 64 69 75 6D 20 61 6E 64 20 6C 61 72 67 65 20 62 6C 6F 63 6B 73 20 61 72 65 3A 20 00 00 00 00 0D 0A 00 00 55 6E 65 78 70 65 63 74 65 64 20 4D 65 6D 6F 72 79 20 4C 65 61 6B 00 00 }
	condition:
		$1
}

rule function_237_0 {
	meta:
		name = "GetMemoryManagerState"
		size = 328
		refs = "0013 @FillChar 001d SmallBlockTypes 0044 LockAllSmallBlockTypes 0049 LockMediumBlocks 004e MediumBlockPoolsCircularList 0068 GetFirstMediumBlockInPool 00ce NextMediumBlock 00f1 MediumBlocksLocked 010a LockLargeBlocks 010f LargeBlocksCircularList 013c LargeBlocksLocked"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B F8 8B C7 33 C9 BA 88 03 00 00 E8 ?? ?? ?? ?? B9 37 00 00 00 BA ?? ?? ?? ?? 8B C7 0F B7 1A 89 18 0F B7 1A 83 EB 04 89 58 04 85 DB 7D 05 33 DB 89 58 04 83 C0 10 83 C2 20 49 75 E0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 04 24 E9 87 00 00 00 81 87 78 03 00 00 00 00 14 00 8B 04 24 E8 ?? ?? ?? ?? 8B D8 85 DB 74 66 8B C3 83 E8 04 8B 30 F7 C6 01 00 00 00 75 4A 8B EE 83 E5 F0 F7 C6 04 00 00 00 74 2E 8B 03 81 E8 ?? ?? ?? ?? C1 E8 05 89 44 24 04 29 AF 78 03 00 00 8B 44 24 04 03 C0 01 6C C7 0C 8B 44 24 04 03 C0 8B 53 0C 01 54 C7 08 EB 0F FF 87 70 03 00 00 83 ED 04 01 AF 74 03 00 00 8B C3 E8 ?? ?? ?? ?? 8B D8 85 DB 75 9A 8B 04 24 8B 40 04 89 04 24 B8 ?? ?? ?? ?? 3B 04 24 0F 85 6B FF FF FF C6 05 ?? ?? ?? ?? 00 B9 37 00 00 00 B8 ?? ?? ?? ?? C6 00 00 83 C0 20 49 75 F7 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? EB 1E 8B 50 0C 83 E2 F0 FF 87 7C 03 00 00 01 97 84 03 00 00 8B 50 08 01 97 80 03 00 00 8B 40 04 3D ?? ?? ?? ?? 75 DB C6 05 ?? ?? ?? ?? 00 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_238_0 {
	meta:
		name = "GetMemoryMap"
		size = 213
		refs = "0012 @FillChar 0017 LockMediumBlocks 001d MediumBlockPoolsCircularList 0044 MediumBlocksLocked 004a LockLargeBlocks 0050 LargeBlocksCircularList 008a LargeBlocksLocked 00a6 VirtualQuery"
	strings:
		$1 = { 53 56 57 83 C4 E0 8B F0 8B C6 33 C9 BA 00 00 01 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? EB 17 8B C2 C1 E8 10 33 DB 8D 0C 03 C6 04 0E 01 43 83 FB 14 75 F3 8B 52 04 81 FA ?? ?? ?? ?? 75 E1 C6 05 ?? ?? ?? ?? 00 E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? EB 2A 8B C7 C1 E8 10 8B 57 0C 83 E2 F0 89 14 24 8B 14 24 4A C1 EA 10 85 D2 72 0E 42 33 DB 8D 0C 03 C6 04 0E 01 43 4A 75 F5 8B 7F 04 81 FF ?? ?? ?? ?? 75 CE C6 05 ?? ?? ?? ?? 00 33 DB 8B FE 80 3F 00 75 2C 6A 1C 8D 44 24 08 50 8B C3 C1 E0 10 50 E8 ?? ?? ?? ?? 8B 44 24 14 3D 00 10 00 00 75 05 C6 07 03 EB 0A 3D 00 20 00 00 75 03 C6 07 04 43 47 81 FB 00 00 01 00 75 C5 83 C4 20 5F 5E 5B C3 }
	condition:
		$1
}

rule function_239_0 {
	meta:
		name = "GetHeapStatus"
		size = 354
		refs = "0013 @FillChar 0018 LockAllSmallBlockTypes 001d LockMediumBlocks 0022 MediumBlockPoolsCircularList 0043 GetFirstMediumBlockInPool 0071 SmallBlockTypes 00d3 NextMediumBlock 00f9 MediumSequentialFeedBytesLeft 0102 MediumBlocksLocked 011b LockLargeBlocks 0120 LargeBlocksCircularList 0149 LargeBlocksLocked"
	strings:
		$1 = { 53 56 57 55 83 C4 F0 8B F0 8B C6 33 C9 BA 28 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 04 24 E9 BC 00 00 00 81 06 00 00 14 00 81 46 08 00 00 14 00 83 46 20 10 8B 04 24 E8 ?? ?? ?? ?? 8B D8 85 DB 0F 84 90 00 00 00 8B C3 83 E8 04 8B 38 8B EF 83 E5 F0 F7 C7 01 00 00 00 75 68 F7 C7 04 00 00 00 74 54 8B 03 81 E8 ?? ?? ?? ?? C1 E8 05 89 44 24 04 8B 43 0C 8B 54 24 04 03 D2 03 D2 0F B7 14 D5 ?? ?? ?? ?? F7 EA 89 44 24 08 8B 43 0C 03 C0 03 C0 89 44 24 0C 2B 6C 24 08 83 ED 04 01 6E 14 8B 44 24 0C 83 C0 04 01 46 20 8B 44 24 08 2B 44 24 0C 01 46 0C EB 0F 83 ED 04 01 6E 0C 83 46 20 04 EB 03 01 6E 18 8B C3 E8 ?? ?? ?? ?? 8B D8 85 DB 0F 85 70 FF FF FF 8B 04 24 8B 40 04 89 04 24 B8 ?? ?? ?? ?? 3B 04 24 0F 85 36 FF FF FF A1 ?? ?? ?? ?? 01 46 1C C6 05 ?? ?? ?? ?? 00 BA 37 00 00 00 B8 ?? ?? ?? ?? C6 00 00 83 C0 20 4A 75 F7 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? EB 1A 8B 50 0C 83 E2 F0 01 16 01 56 08 8B 48 08 01 4E 0C 2B 50 08 01 56 20 8B 40 04 3D ?? ?? ?? ?? 75 DF C6 05 ?? ?? ?? ?? 00 8B 46 14 03 46 18 03 46 1C 89 46 10 83 C4 10 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_240_0 {
	meta:
		name = "CreateWindow"
		size = 85
		refs = "000f Get8087CW 003e CreateWindowEx 0047 Set8087CW"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 4D FC 8B FA 8B F0 E8 ?? ?? ?? ?? 8B D8 8B 45 08 50 8B 45 0C 50 8B 45 10 50 8B 45 14 50 8B 45 18 50 8B 45 1C 50 8B 45 20 50 8B 45 24 50 8B 45 FC 50 57 56 6A 00 E8 ?? ?? ?? ?? 8B F0 8B C3 E8 ?? ?? ?? ?? 8B C6 5F 5E 5B 59 5D C2 20 00 }
	condition:
		$1
}

rule function_241_0 {
	meta:
		name = "BuildProcessIDString"
		size = 51
		refs = "0002 GetCurrentProcessId 001a HexTable 0027 UniqueProcessIDString"
	strings:
		$1 = { 53 E8 ?? ?? ?? ?? 8B D0 33 C0 8B C8 03 C9 03 C9 8B DA D3 EB 83 E3 0F 0F B6 8B ?? ?? ?? ?? BB 08 00 00 00 2B D8 88 8B ?? ?? ?? ?? 40 83 F8 08 75 D9 5B C3 }
	condition:
		$1
}

rule function_242_0 {
	meta:
		name = "FindSharedMemoryManager"
		size = 52
		refs = "0002 BuildProcessIDString 0007 UniqueProcessIDString 000c FindSharedMemoryManager 0011 FindWindow 0023 GetWindowLong"
	strings:
		$1 = { 53 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 DB 75 04 33 C0 5B C3 6A EB 53 E8 ?? ?? ?? ?? 5B C3 00 00 00 53 54 41 54 49 43 00 00 }
	condition:
		$1
}

rule function_243_0 {
	meta:
		name = "AttemptToUseSharedMemoryManager"
		size = 276
		refs = "0001 IsMemoryManagerSet 000b MMSharingWindow 0013 MediumBlockPoolsCircularList 0020 LargeBlocksCircularList 002d FindSharedMemoryManager 0036 SetMemoryManager 0048 AttemptToUseSharedMemoryManager 0054 MessageBox"
	strings:
		$1 = { E8 ?? ?? ?? ?? 84 C0 75 6C 83 3D ?? ?? ?? ?? 00 75 4A B8 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 75 23 B8 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 75 16 E8 ?? ?? ?? ?? 85 C0 74 09 E8 ?? ?? ?? ?? B0 01 EB 39 33 C0 EB 35 68 10 20 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? 33 C0 EB 1B 68 10 20 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? 33 C0 C3 33 C0 C3 43 61 6E 6E 6F 74 20 53 77 69 74 63 68 20 4D 65 6D 6F 72 79 20 4D 61 6E 61 67 65 72 00 00 00 00 54 68 65 20 6D 65 6D 6F 72 79 20 6D 61 6E 61 67 65 72 20 63 61 6E 6E 6F 74 20 62 65 20 63 68 61 6E 67 65 64 20 61 66 74 65 72 20 69 74 20 68 61 73 20 62 65 65 6E 20 75 73 65 64 2E 00 00 00 00 54 68 65 20 6D 65 6D 6F 72 79 20 6D 61 6E 61 67 65 72 20 63 61 6E 6E 6F 74 20 62 65 20 63 68 61 6E 67 65 64 20 69 66 20 69 74 20 69 73 20 62 65 69 6E 67 20 73 68 61 72 65 64 2E 00 }
	condition:
		$1
}

rule function_244_0 {
	meta:
		name = "ShareMemoryManager"
		size = 108
		refs = "0001 IsMemoryManagerSet 000b MMSharingWindow 0013 FindSharedMemoryManager 0028 GetCurrentProcessId 0030 UniqueProcessIDString 0035 ShareMemoryManager 003f CreateWindow 0049 ThisMemoryManager 0056 SetWindowLong"
	strings:
		$1 = { E8 ?? ?? ?? ?? 84 C0 75 58 83 3D ?? ?? ?? ?? 00 75 4F E8 ?? ?? ?? ?? 85 C0 75 43 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 50 6A 00 BA ?? ?? ?? ?? B8 ?? ?? ?? ?? B9 00 00 00 80 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A EB A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? B0 01 EB 05 33 C0 C3 33 C0 C3 53 54 41 54 49 43 00 00 }
	condition:
		$1
}

rule function_245_0 {
	meta:
		name = "BuildBlockTypeLookupTable"
		size = 66
		refs = "0007 SmallBlockTypes 000d MinimumBlockAlignment 002b AllocSize2SmallBlockTypeIndX4"
	strings:
		$1 = { 56 57 33 C0 33 F6 BA ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 74 05 F6 02 0F 75 1D 0F B7 3A C1 EF 03 8B CE 03 C9 03 C9 3B F8 76 0B 88 88 ?? ?? ?? ?? 40 3B F8 77 F5 8B C7 46 83 C2 20 83 FE 37 75 CC 5F 5E C3 }
	condition:
		$1
}

rule function_246_0 {
	meta:
		name = "GetMinimumBlockAlignment"
		size = 8
		refs = "0003 MinimumBlockAlignment"
	strings:
		$1 = { 0F B6 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_247_0 {
	meta:
		name = "SetMinimumBlockAlignment"
		size = 19
		refs = "0002 MinimumBlockAlignment 000e BuildBlockTypeLookupTable"
	strings:
		$1 = { 3A 05 ?? ?? ?? ?? 74 0A A2 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_248_0 {
	meta:
		name = "InitializeMemoryManager"
		size = 293
		refs = "0009 SmallBlockTypes 0014 MoveX16L4 00de BuildBlockTypeLookupTable 00e4 MediumBlockPoolsCircularList 00fc MediumBlockBins 010f LargeBlocksCircularList"
	strings:
		$1 = { 53 56 57 BE 37 00 00 00 BB ?? ?? ?? ?? 83 3B 00 75 06 C7 03 ?? ?? ?? ?? 8D 43 E4 89 43 F8 8D 43 E4 89 43 E8 33 C0 89 43 F0 C7 43 EC 01 00 00 00 0F B7 43 E6 03 C0 03 C0 8D 04 40 05 EF 00 00 00 25 00 FF FF FF 83 C0 30 3D 30 0B 00 00 73 05 B8 30 0B 00 00 05 D0 04 00 00 C1 E8 0D 83 F8 07 76 05 B8 07 00 00 00 8B C8 B2 FF D2 E2 88 53 E5 C1 E0 0D 66 05 30 0B 66 89 43 FC 0F B7 7B E6 0F B7 C7 8B C8 C1 E1 04 8D 0C 49 81 C1 EF 00 00 00 81 E1 00 FF FF FF 83 C1 30 81 F9 30 73 00 00 73 05 B9 30 73 00 00 81 F9 30 FF 00 00 76 05 B9 30 FF 00 00 8B C1 83 E8 20 0F B7 D7 8B CA 33 D2 F7 F1 66 F7 EF 66 05 EF 00 66 25 00 FF 66 83 C0 30 66 89 43 FE 83 C3 20 4E 0F 85 30 FF FF FF E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? BE 00 04 00 00 BA ?? ?? ?? ?? 8B C2 89 00 89 40 04 83 C2 08 4E 75 F3 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_249_0 {
	meta:
		name = "FreeAllMemory"
		size = 144
		refs = "0005 MediumBlockPoolsCircularList 000a LargeBlocksCircularList 001f VirtualFree 002f SmallBlockTypes 005a MediumBlockBins"
	strings:
		$1 = { 53 56 57 55 BB ?? ?? ?? ?? BE ?? ?? ?? ?? 8B 7B 04 EB 12 8B 6F 04 68 00 80 00 00 6A 00 57 E8 ?? ?? ?? ?? 8B FD 3B FB 75 EA BA 37 00 00 00 B8 ?? ?? ?? ?? 8B C8 89 48 14 8B C8 89 48 04 C7 40 08 01 00 00 00 33 C9 89 48 0C 83 C0 20 4A 75 E4 89 1B 89 5B 04 BA 00 04 00 00 B9 ?? ?? ?? ?? 8B C1 89 00 89 40 04 83 C1 08 4A 75 F3 8B 5E 04 EB 12 8B 7B 04 68 00 80 00 00 6A 00 53 E8 ?? ?? ?? ?? 8B DF 3B DE 75 EA 89 36 89 76 04 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_250_0 {
	meta:
		name = "FinalizeMemoryManager"
		size = 81
		refs = "0002 MMSharingWindow 0010 DestroyWindow 001d ReportMemoryLeaksOnShutdown 0025 ScanForMemoryLeaks 002b ExpectedMemoryLeaks 0040 VirtualFree 004c FreeAllMemory"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 12 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 74 05 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 19 68 00 80 00 00 6A 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_251_0 {
	meta:
		name = "AllocMem"
		size = 24
		refs = "0006 MemoryManager 0013 Error"
	strings:
		$1 = { 85 C0 74 0A FF 15 ?? ?? ?? ?? 85 C0 74 02 F3 C3 B0 01 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_252_0 {
	meta:
		name = "RegisterExpectedMemoryLeak"
		size = 27
		refs = "000b MemoryManager"
		altNames = "UnregisterExpectedMemoryLeak"
	strings:
		$1 = { 53 8B D8 85 DB 74 0C 8B C3 FF 15 ?? ?? ?? ?? 84 C0 75 04 33 C0 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_254_0 {
	meta:
		name = "@GetMem"
		size = 27
		refs = "0006 MemoryManager 0013 Error"
	strings:
		$1 = { 85 C0 7E 13 FF 15 ?? ?? ?? ?? 85 C0 74 02 F3 C3 B0 01 E9 ?? ?? ?? ?? 31 C0 F3 C3 }
	condition:
		$1
}

rule function_255_0 {
	meta:
		name = "@FreeMem"
		size = 24
		refs = "0006 MemoryManager 0013 Error"
	strings:
		$1 = { 85 C0 74 0A FF 15 ?? ?? ?? ?? 85 C0 75 02 F3 C3 B0 02 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_256_0 {
	meta:
		name = "@ReallocMem"
		size = 77
		refs = "000f MemoryManager 001e Error"
	strings:
		$1 = { 8B 08 85 C9 74 32 85 D2 74 18 50 89 C8 FF 15 ?? ?? ?? ?? 59 09 C0 74 19 89 01 C3 B0 02 E9 ?? ?? ?? ?? 89 10 89 C8 FF 15 ?? ?? ?? ?? 09 C0 75 EB C3 B0 01 E9 ?? ?? ?? ?? 85 D2 74 10 50 89 D0 FF 15 ?? ?? ?? ?? 59 09 C0 74 E7 89 01 C3 }
	condition:
		$1
}

rule function_257_0 {
	meta:
		name = "DefaultAllocMem"
		size = 34
		refs = "0008 MemoryManager 0019 @FillChar"
	strings:
		$1 = { 53 56 8B F0 8B C6 FF 15 ?? ?? ?? ?? 8B D8 85 DB 74 0B 8B C3 33 C9 8B D6 E8 ?? ?? ?? ?? 8B C3 5E 5B C3 }
	condition:
		$1
}

rule function_259_0 {
	meta:
		name = "GetMemoryManager"
		size = 27
		refs = "0002 MemoryManager"
	strings:
		$1 = { 8B 15 ?? ?? ?? ?? 89 10 8B 15 ?? ?? ?? ?? 89 50 04 8B 15 ?? ?? ?? ?? 89 50 08 C3 }
	condition:
		$1
}

rule function_260_0 {
	meta:
		name = "SetMemoryManager"
		size = 43
		refs = "0001 MemoryManager 0018 DefaultAllocMem 001f DefaultRegisterAndUnregisterExpectedMemoryLeak"
	strings:
		$1 = { BA ?? ?? ?? ?? 8B 08 89 0A 8B 48 04 89 4A 04 8B 40 08 89 42 08 C7 42 0C ?? ?? ?? ?? C7 42 10 ?? ?? ?? ?? C7 42 14 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_261_0 {
	meta:
		name = "GetMemoryManager"
		size = 19
		refs = "0005 MemoryManager"
	strings:
		$1 = { 56 57 8B F8 BE ?? ?? ?? ?? B9 06 00 00 00 F3 A5 5F 5E C3 }
	condition:
		$1
}

rule function_262_0 {
	meta:
		name = "SetMemoryManager"
		size = 19
		refs = "0005 MemoryManager"
	strings:
		$1 = { 56 57 8B F0 BF ?? ?? ?? ?? B9 06 00 00 00 F3 A5 5F 5E C3 }
	condition:
		$1
}

rule function_263_0 {
	meta:
		name = "IsMemoryManagerSet"
		size = 70
		refs = "0001 MemoryManager 0006 SysGetMem 000f SysFreeMem 0019 SysReallocMem 0023 SysAllocMem 002d SysRegisterExpectedMemoryLeak 0037 SysUnregisterExpectedMemoryLeak"
	strings:
		$1 = { B8 ?? ?? ?? ?? BA ?? ?? ?? ?? 3B 10 75 35 BA ?? ?? ?? ?? 3B 50 04 75 2B BA ?? ?? ?? ?? 3B 50 08 75 21 BA ?? ?? ?? ?? 3B 50 0C 75 17 BA ?? ?? ?? ?? 3B 50 10 75 0D BA ?? ?? ?? ?? 3B 50 14 75 03 33 C0 C3 B0 01 C3 }
	condition:
		$1
}

rule function_264_0 {
	meta:
		name = "ExceptObject"
		size = 32
		refs = "0001 @GetTls 0007 RaiseListPtr"
	strings:
		$1 = { E8 ?? ?? ?? ?? 83 B8 ?? ?? ?? ?? 00 74 0F E8 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 8B 40 08 C3 33 C0 C3 }
	condition:
		$1
}

rule function_265_0 {
	meta:
		name = "ExceptAddr"
		size = 32
		refs = "0001 @GetTls 0007 RaiseListPtr"
	strings:
		$1 = { E8 ?? ?? ?? ?? 83 B8 ?? ?? ?? ?? 00 74 0F E8 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 8B 40 04 C3 33 C0 C3 }
	condition:
		$1
}

rule function_266_0 {
	meta:
		name = "AcquireExceptionObject"
		size = 49
		refs = "0003 @GetTls 0009 RaiseListPtr"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 83 B8 ?? ?? ?? ?? 00 74 1A E8 ?? ?? ?? ?? 8B B0 ?? ?? ?? ?? 8B 5E 08 E8 ?? ?? ?? ?? 33 C0 89 46 08 EB 02 33 DB 8B C3 5E 5B C3 }
	condition:
		$1
}

rule function_268_0 {
	meta:
		name = "RaiseList"
		size = 12
		refs = "0001 @GetTls 0007 RaiseListPtr"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_269_0 {
	meta:
		name = "SetRaiseList"
		size = 21
		refs = "0002 @GetTls 0008 RaiseListPtr"
	strings:
		$1 = { 50 E8 ?? ?? ?? ?? 8B 90 ?? ?? ?? ?? 8F 80 ?? ?? ?? ?? 89 D0 C3 }
	condition:
		$1
}

rule function_272_0 {
	meta:
		name = "RunErrorAt"
		size = 12
		refs = "0002 ErrorAddr 0007 @Halt"
	strings:
		$1 = { 89 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_273_0 {
	meta:
		name = "ErrorAt"
		size = 73
		refs = "000b ErrorProc 0021 @GetTls 0027 InOutRes 0038 reMap 0042 RunErrorAt"
	strings:
		$1 = { 53 56 8B F2 8B D8 80 E3 7F 83 3D ?? ?? ?? ?? 00 74 0A 8B D6 8B C3 FF 15 ?? ?? ?? ?? 84 DB 75 0D E8 ?? ?? ?? ?? 8B 98 ?? ?? ?? ?? EB 0F 80 FB 18 77 0A 0F B6 C3 0F B6 98 ?? ?? ?? ?? 0F B6 C3 8B D6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_274_0 {
	meta:
		name = "Error"
		size = 12
		refs = "0007 ErrorAt"
	strings:
		$1 = { 83 E0 7F 8B 14 24 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_275_0 {
	meta:
		name = "@_IOTest"
		size = 29
		refs = "0004 @GetTls 000a InOutRes 0018 Error"
	strings:
		$1 = { 50 52 51 E8 ?? ?? ?? ?? 83 B8 ?? ?? ?? ?? 00 59 5A 58 75 01 C3 31 C0 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_276_0 {
	meta:
		name = "SetInOutRes"
		size = 16
		refs = "0004 @GetTls 000a InOutRes"
	strings:
		$1 = { 53 8B D8 E8 ?? ?? ?? ?? 89 98 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_278_0 {
	meta:
		name = "ChDir"
		size = 17
		refs = "0006 @LStrToPChar 000b ChDir"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_286_0 {
	meta:
		name = "MkDir"
		size = 17
		refs = "0006 @LStrToPChar 000b MkDir"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_298_0 {
	meta:
		name = "RmDir"
		size = 17
		refs = "0006 @LStrToPChar 000b RmDir"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_279_0 {
	meta:
		name = "ChDir"
		size = 21
		refs = "0005 SetCurrentDirectory 000f InOutError"
	strings:
		$1 = { 53 8B D8 53 E8 ?? ?? ?? ?? 66 85 C0 75 05 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_299_0 {
	meta:
		name = "RmDir"
		size = 21
		refs = "0005 RemoveDirectory 000f InOutError"
	strings:
		$1 = { 53 8B D8 53 E8 ?? ?? ?? ?? 66 85 C0 75 05 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_280_0 {
	meta:
		name = "@Copy"
		size = 65
	strings:
		$1 = { 56 57 89 C6 8B 7C 24 0C 31 C0 0A 06 74 2B 85 D2 7E 18 39 C2 7F 1B 29 D0 40 85 C9 7C 14 39 C1 7F 14 01 D6 88 0F 47 F3 A4 EB 11 BA 01 00 00 00 EB E5 31 C9 EB EC 89 C1 EB E8 88 07 5F 5E C2 04 00 C3 }
	condition:
		$1
}

rule function_281_0 {
	meta:
		name = "@Delete"
		size = 45
	strings:
		$1 = { 56 57 89 C7 31 C0 8A 07 85 D2 7E 1E 39 C2 7F 1A 85 C9 7E 16 29 D0 40 39 C1 7E 02 89 C1 28 0F 01 D7 8D 34 39 29 C8 89 C1 F3 A4 5F 5E C3 }
	condition:
		$1
}

rule function_282_0 {
	meta:
		name = "@LGetDir"
		size = 117
		refs = "0032 GetCurrentDirectory 0038 SetCurrentDirectory 0068 @LStrFromArray"
	strings:
		$1 = { 53 56 81 C4 F0 FD FF FF 8B F2 8B D8 84 DB 74 2C 0F B6 C3 83 C0 41 48 88 04 24 C6 44 24 01 3A C6 44 24 02 00 8D 84 24 09 01 00 00 50 68 05 01 00 00 E8 ?? ?? ?? ?? 54 E8 ?? ?? ?? ?? 8D 44 24 04 50 68 05 01 00 00 E8 ?? ?? ?? ?? 84 DB 74 0D 8D 84 24 09 01 00 00 50 E8 ?? ?? ?? ?? 8B C6 8D 54 24 04 B9 05 01 00 00 E8 ?? ?? ?? ?? 81 C4 10 02 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_283_0 {
	meta:
		name = "@SGetDir"
		size = 111
		refs = "0018 @SGetDir 0026 @LGetDir 0039 @LStrToString 0048 @PStrNCpy 005d @LStrClr 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 FC FE FF FF 53 56 33 DB 89 5D FC 8B F1 8B DA 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8D 55 FC E8 ?? ?? ?? ?? 8D 85 FC FE FF FF 8B 55 FC B9 FF 00 00 00 E8 ?? ?? ?? ?? 8D 95 FC FE FF FF 8B C3 8B CE E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_284_0 {
	meta:
		name = "@Insert"
		size = 102
	strings:
		$1 = { 53 56 57 51 8B 4C 24 14 81 EC 00 02 00 00 89 D3 89 D6 31 D2 8A 16 46 42 85 C9 7E 32 39 D1 7F 35 4A 89 E7 49 29 CA F3 A4 96 8A 0E 46 F3 A4 89 C6 89 D1 F3 A4 29 E7 8B 8C 24 00 02 00 00 39 F9 72 02 89 F9 89 DF 89 E6 88 0F 47 F3 A4 EB 0B B9 01 00 00 00 EB CB 89 D1 EB C7 81 C4 04 02 00 00 5F 5E 5B C2 04 00 C3 }
	condition:
		$1
}

rule function_285_0 {
	meta:
		name = "IOResult"
		size = 29
		refs = "0002 @GetTls 0008 InOutRes"
	strings:
		$1 = { 53 E8 ?? ?? ?? ?? 8B 98 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 D2 89 90 ?? ?? ?? ?? 8B C3 5B C3 }
	condition:
		$1
}

rule function_287_0 {
	meta:
		name = "MkDir"
		size = 23
		refs = "0007 CreateDirectory 0011 InOutError"
	strings:
		$1 = { 53 8B D8 6A 00 53 E8 ?? ?? ?? ?? 66 85 C0 75 05 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_288_0 {
	meta:
		name = "Move"
		size = 253
		refs = "0011 Move"
	strings:
		$1 = { 39 D0 74 31 83 F9 20 77 7C 83 E9 08 7F 07 FF 24 8D ?? ?? ?? ?? DF 2C 01 DF 28 83 F9 08 7E 11 DF 68 08 83 F9 10 7E 06 DF 68 10 DF 7A 10 DF 7A 08 DF 3A DF 3C 11 C3 90 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 52 DF 28 8D 44 01 F8 8D 4C 0A F8 DF 28 51 F7 D9 83 E2 F8 8D 4C 0A 08 5A DF 2C 01 DF 3C 11 83 C1 08 7C F5 DF 3A 5A DF 3A C3 7E 2E 39 D0 77 D1 29 CA 39 D0 8D 14 11 76 C8 83 E9 08 51 DF 2C 01 DF 28 01 D1 83 E1 F8 29 D1 DF 2C 01 DF 3C 11 83 E9 08 7F F5 59 DF 3A DF 3C 11 C3 0F B6 08 88 0A C3 0F B7 08 66 89 0A C3 66 8B 08 8A 40 02 66 89 0A 88 42 02 C3 8B 08 89 0A C3 8B 08 8A 40 04 89 0A 88 42 04 C3 8B 08 66 8B 40 04 89 0A 66 89 42 04 C3 8B 08 8B 40 03 89 0A 89 42 03 C3 DF 28 DF 3A C3 }
	condition:
		$1
}

rule function_289_0 {
	meta:
		name = "GetParamStr"
		size = 250
		refs = "000d CharNext 0086 @LStrSetLength"
	strings:
		$1 = { 53 56 57 55 51 8B F2 8B D8 EB 08 53 E8 ?? ?? ?? ?? 8B D8 80 3B 00 74 05 80 3B 20 76 EE 80 3B 22 75 0B 80 7B 01 22 75 05 83 C3 02 EB E6 33 ED 89 1C 24 EB 48 80 3B 22 75 33 53 E8 ?? ?? ?? ?? 8B D8 EB 10 53 E8 ?? ?? ?? ?? 8B F8 8B C7 2B C3 03 E8 8B DF 80 3B 00 74 05 80 3B 22 75 E6 80 3B 00 74 1A 53 E8 ?? ?? ?? ?? 8B D8 EB 10 53 E8 ?? ?? ?? ?? 8B F8 8B C7 2B C3 03 E8 8B DF 80 3B 20 77 B3 8B C6 8B D5 E8 ?? ?? ?? ?? 8B 1C 24 8B 2E 33 F6 EB 5A 80 3B 22 75 3C 53 E8 ?? ?? ?? ?? 8B D8 EB 19 53 E8 ?? ?? ?? ?? 8B F8 3B FB 76 0D 0F B6 03 88 44 35 00 43 46 3B FB 77 F3 80 3B 00 74 05 80 3B 22 75 DD 80 3B 00 74 23 53 E8 ?? ?? ?? ?? 8B D8 EB 19 53 E8 ?? ?? ?? ?? 8B F8 3B FB 76 0D 0F B6 03 88 44 35 00 43 46 3B FB 77 F3 80 3B 20 77 A1 8B C3 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_290_0 {
	meta:
		name = "ParamCount"
		size = 95
		refs = "000b ParamCount 0018 GetCommandLine 0020 GetParamStr 004c @LStrClr 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 F6 E8 ?? ?? ?? ?? 8D 55 FC E8 ?? ?? ?? ?? 8B D8 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B D8 83 7D FC 00 74 03 46 EB EB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_291_0 {
	meta:
		name = "ParamStr"
		size = 94
		refs = "0010 @LStrClr 0025 GetModuleFileName 0030 @LStrFromPCharLen 0037 GetCommandLine 0042 GetParamStr"
	strings:
		$1 = { 53 56 57 81 C4 F8 FE FF FF 8B DA 8B F0 8B C3 E8 ?? ?? ?? ?? 85 F6 75 1E 68 05 01 00 00 8D 44 24 04 50 6A 00 E8 ?? ?? ?? ?? 8B C8 8B D4 8B C3 E8 ?? ?? ?? ?? EB 1E E8 ?? ?? ?? ?? 8B F8 8B D3 8B C7 E8 ?? ?? ?? ?? 8B F8 85 F6 74 08 83 3B 00 74 03 4E EB E9 81 C4 08 01 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_292_0 {
	meta:
		name = "@Pos"
		size = 62
	strings:
		$1 = { 53 56 57 89 C6 89 D7 31 C9 8A 0F 47 57 31 D2 8A 16 46 4A 78 1B 8A 06 46 29 D1 7E 14 F2 AE 75 10 89 CB 56 57 89 D1 F3 A6 5F 5E 74 09 89 D9 EB EC 5A 31 C0 EB 05 5A 89 F8 29 D0 5F 5E 5B C3 }
	condition:
		$1
}

rule function_294_0 {
	meta:
		name = "@SetString"
		size = 17
		refs = "000c Move"
	strings:
		$1 = { 88 08 85 D2 74 0A 40 0F B6 C9 92 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_295_0 {
	meta:
		name = "Randomize"
		size = 37
		refs = "0005 QueryPerformanceCounter 0011 RandSeed 0019 GetTickCount"
	strings:
		$1 = { 83 C4 F8 54 E8 ?? ?? ?? ?? 85 C0 74 0B 8B 04 24 A3 ?? ?? ?? ?? 59 5A C3 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 59 5A C3 }
	condition:
		$1
}

rule function_296_0 {
	meta:
		name = "Random"
		size = 26
		refs = "0005 RandSeed"
	strings:
		$1 = { 53 31 DB 69 93 ?? ?? ?? ?? 05 84 08 08 42 89 93 ?? ?? ?? ?? F7 E2 89 D0 5B C3 }
	condition:
		$1
}

rule function_297_0 {
	meta:
		name = "Random"
		size = 39
		refs = "0005 RandSeed 0016 two2neg32"
	strings:
		$1 = { 53 31 DB 69 93 ?? ?? ?? ?? 05 84 08 08 42 89 93 ?? ?? ?? ?? DD 83 ?? ?? ?? ?? 6A 00 52 DF 2C 24 83 C4 08 DE C9 5B C3 }
	condition:
		$1
}

rule function_300_0 {
	meta:
		name = "UpCase"
		size = 11
	strings:
		$1 = { 3C 61 72 06 3C 7A 77 02 2C 20 C3 }
	condition:
		$1
}

rule function_301_0 {
	meta:
		name = "Set8087CW"
		size = 15
		refs = "0002 Default8087CW"
	strings:
		$1 = { 66 A3 ?? ?? ?? ?? DB E2 D9 2D ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_302_0 {
	meta:
		name = "Get8087CW"
		size = 7
	strings:
		$1 = { 6A 00 D9 3C 24 58 C3 }
	condition:
		$1
}

rule function_303_0 {
	meta:
		name = "Int"
		size = 41
	strings:
		$1 = { 55 8B EC DB 6D 08 83 EC 04 D9 3C 24 D9 7C 24 02 9B 66 81 4C 24 02 00 0F D9 6C 24 02 D9 FC 9B D9 2C 24 83 C4 04 5D C2 0C 00 }
	condition:
		$1
}

rule function_304_0 {
	meta:
		name = "Frac"
		size = 45
	strings:
		$1 = { 55 8B EC DB 6D 08 D9 C0 83 EC 04 D9 3C 24 D9 7C 24 02 9B 66 81 4C 24 02 00 0F D9 6C 24 02 D9 FC 9B D9 2C 24 83 C4 04 DE E9 5D C2 0C 00 }
	condition:
		$1
}

rule function_305_0 {
	meta:
		name = "Exp"
		size = 32
	strings:
		$1 = { 55 8B EC DB 6D 08 D9 EA DE C9 D9 C0 D9 FC DC E9 D9 C9 D9 F0 D9 E8 DE C1 D9 FD DD D9 5D C2 0C 00 }
	condition:
		$1
}

rule function_306_0 {
	meta:
		name = "Cos"
		size = 13
	strings:
		$1 = { 55 8B EC DB 6D 08 D9 FF 9B 5D C2 0C 00 }
	condition:
		$1
}

rule function_307_0 {
	meta:
		name = "Sin"
		size = 13
	strings:
		$1 = { 55 8B EC DB 6D 08 D9 FE 9B 5D C2 0C 00 }
	condition:
		$1
}

rule function_308_0 {
	meta:
		name = "Ln"
		size = 17
	strings:
		$1 = { 55 8B EC DB 6D 08 D9 ED D9 C9 D9 F1 9B 5D C2 0C 00 }
	condition:
		$1
}

rule function_309_0 {
	meta:
		name = "ArcTan"
		size = 15
	strings:
		$1 = { 55 8B EC DB 6D 08 D9 E8 D9 F3 9B 5D C2 0C 00 }
	condition:
		$1
}

rule function_310_0 {
	meta:
		name = "Sqrt"
		size = 13
	strings:
		$1 = { 55 8B EC DB 6D 08 D9 FA 9B 5D C2 0C 00 }
	condition:
		$1
}

rule function_311_0 {
	meta:
		name = "@ROUND"
		size = 10
	strings:
		$1 = { 83 EC 08 DF 3C 24 9B 58 5A C3 }
	condition:
		$1
}

rule function_312_0 {
	meta:
		name = "@TRUNC"
		size = 34
	strings:
		$1 = { 83 EC 0C D9 3C 24 D9 7C 24 02 9B 66 81 4C 24 02 00 0F D9 6C 24 02 DF 7C 24 04 9B D9 2C 24 59 58 5A C3 }
	condition:
		$1
}

rule function_313_0 {
	meta:
		name = "@AbstractError"
		size = 26
		refs = "0002 AbstractErrorProc 0015 @RunError"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 06 FF 15 ?? ?? ?? ?? B8 D2 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_314_0 {
	meta:
		name = "OpenText"
		size = 88
		refs = "0026 @Close 003d TextOpen 004f SetInOutRes"
	strings:
		$1 = { 53 56 8B F2 8B D8 0F B7 43 04 66 3D B0 D7 72 06 66 3D B3 D7 76 07 BB 66 00 00 00 EB 2B 66 3D B0 D7 74 07 8B C3 E8 ?? ?? ?? ?? 66 89 73 04 80 7B 48 00 75 0D 83 7B 18 00 75 07 C7 43 18 ?? ?? ?? ?? 8B C3 FF 53 18 8B D8 85 DB 74 07 8B C3 E8 ?? ?? ?? ?? 8B C3 5E 5B C3 }
	condition:
		$1
}

rule function_315_0 {
	meta:
		name = "@ResetText"
		size = 10
		refs = "0005 OpenText"
	strings:
		$1 = { 66 BA B1 D7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_316_0 {
	meta:
		name = "@RewritText"
		size = 10
		refs = "0005 OpenText"
	strings:
		$1 = { 66 BA B2 D7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_317_0 {
	meta:
		name = "@Append"
		size = 10
		refs = "0005 OpenText"
	strings:
		$1 = { 66 BA B3 D7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_318_0 {
	meta:
		name = "TextIn"
		size = 57
		refs = "001f ReadFile 0028 GetLastError"
	strings:
		$1 = { 53 8B D8 33 C0 89 43 10 33 C0 89 43 0C 6A 00 8D 43 10 50 8B 43 08 50 8B 43 14 50 8B 03 50 E8 ?? ?? ?? ?? 85 C0 75 0E E8 ?? ?? ?? ?? 83 F8 6D 75 06 33 C0 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_320_0 {
	meta:
		name = "TextOut"
		size = 58
		refs = "0020 WriteFile 0029 GetLastError"
	strings:
		$1 = { 53 56 51 8B D8 8B 73 0C 85 F6 75 04 33 C0 EB 26 6A 00 8D 44 24 04 50 56 8B 43 14 50 8B 03 50 E8 ?? ?? ?? ?? 85 C0 75 07 E8 ?? ?? ?? ?? EB 02 33 C0 33 D2 89 53 0C 5A 5E 5B C3 }
	condition:
		$1
}

rule function_321_0 {
	meta:
		name = "InternalClose"
		size = 15
		refs = "0005 CloseHandle"
	strings:
		$1 = { 53 8B D8 53 E8 ?? ?? ?? ?? 48 0F 94 C0 5B C3 }
	condition:
		$1
}

rule function_322_0 {
	meta:
		name = "TextClose"
		size = 31
		refs = "000c InternalClose 0015 GetLastError"
	strings:
		$1 = { 53 8B D8 66 C7 43 04 B0 D7 8B 03 E8 ?? ?? ?? ?? 84 C0 75 07 E8 ?? ?? ?? ?? 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_323_0 {
	meta:
		name = "TextOpenCleanup"
		size = 23
		refs = "0006 InternalClose 0011 GetLastError"
	strings:
		$1 = { 53 8B D8 8B 03 E8 ?? ?? ?? ?? 66 C7 43 04 B0 D7 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_324_0 {
	meta:
		name = "TextOpen"
		size = 428
		refs = "0033 TextIn 005c TextOut 0063 TextClose 006a FileNOPProc 0089 CreateFileA 00ad GetFileSize 00c9 SetFilePointer 00ea ReadFile 0121 SetEndOfFile 014f ErrOutput 015c GetStdHandle 0172 GetFileType 018d CloseHandle 01a5 GetLastError"
	strings:
		$1 = { 56 89 C6 31 C0 89 46 0C 89 46 10 66 8B 46 04 2D B1 D7 00 00 74 0B 48 74 20 48 74 2E E9 67 01 00 00 B8 00 00 00 80 BA 01 00 00 00 B9 03 00 00 00 C7 46 1C ?? ?? ?? ?? EB 27 B8 00 00 00 40 BA 01 00 00 00 B9 02 00 00 00 EB 0F B8 00 00 00 C0 BA 01 00 00 00 B9 03 00 00 00 C7 46 1C ?? ?? ?? ?? C7 46 24 ?? ?? ?? ?? C7 46 20 ?? ?? ?? ?? 80 7E 48 00 0F 84 B2 00 00 00 6A 00 68 80 00 00 00 51 6A 00 52 50 8D 46 48 50 E8 ?? ?? ?? ?? 83 F8 FF 0F 84 08 01 00 00 89 06 66 81 7E 04 B3 D7 0F 85 C3 00 00 00 66 FF 4E 04 6A 00 FF 36 E8 ?? ?? ?? ?? 40 0F 84 E6 00 00 00 2D 81 00 00 00 73 02 31 C0 6A 00 6A 00 50 FF 36 E8 ?? ?? ?? ?? 40 0F 84 CA 00 00 00 6A 00 89 E2 6A 00 52 68 80 00 00 00 8D 96 4C 01 00 00 52 FF 36 E8 ?? ?? ?? ?? 5A 48 0F 85 A8 00 00 00 31 C0 39 D0 73 6B 80 BC 06 4C 01 00 00 0E 74 03 40 EB EF 6A 02 6A 00 29 D0 50 FF 36 E8 ?? ?? ?? ?? 40 0F 84 80 00 00 00 FF 36 E8 ?? ?? ?? ?? 48 75 76 EB 3D 8D 86 4C 01 00 00 C7 46 08 80 00 00 00 C7 46 24 ?? ?? ?? ?? 89 46 14 66 81 7E 04 B2 D7 74 04 6A F6 EB 0E 81 FE ?? ?? ?? ?? 75 04 6A F4 EB 02 6A F5 E8 ?? ?? ?? ?? 83 F8 FF 74 39 89 06 66 81 7E 04 B1 D7 74 17 FF 36 E8 ?? ?? ?? ?? 85 C0 74 10 83 F8 02 75 07 C7 46 20 ?? ?? ?? ?? 31 C0 5E C3 FF 36 E8 ?? ?? ?? ?? 66 C7 46 04 B0 D7 B8 69 00 00 00 EB EA 66 C7 46 04 B0 D7 E8 ?? ?? ?? ?? EB DD C3 }
	condition:
		$1
}

rule function_325_0 {
	meta:
		name = "@Assign"
		size = 101
		refs = "0010 @FillChar 0026 DefaultTextLineBreakStyle 0038 TextOpen 003f @LStrLen 0047 @LStrToPChar 0050 Move"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 33 C9 BA 4C 01 00 00 E8 ?? ?? ?? ?? 8D 83 4C 01 00 00 89 43 14 66 C7 43 04 B0 D7 0F B6 05 ?? ?? ?? ?? 66 89 43 06 C7 43 08 80 00 00 00 C7 43 18 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 50 8B C6 E8 ?? ?? ?? ?? 8D 53 48 59 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C6 44 03 48 00 33 C0 5E 5B C3 }
	condition:
		$1
}

rule function_326_0 {
	meta:
		name = "InternalFlush"
		size = 69
		refs = "0020 Output 0027 ErrOutput 003d SetInOutRes"
	strings:
		$1 = { 53 0F B7 48 04 66 81 E9 B1 D7 74 0F 49 66 83 E9 02 73 0C 8B DA FF D3 8B D8 EB 1B 33 DB EB 17 3D ?? ?? ?? ?? 74 07 3D ?? ?? ?? ?? 75 04 33 DB EB 05 BB 67 00 00 00 85 DB 74 07 8B C3 E8 ?? ?? ?? ?? 8B C3 5B C3 }
	condition:
		$1
}

rule function_327_0 {
	meta:
		name = "Flush"
		size = 9
		refs = "0004 InternalFlush"
	strings:
		$1 = { 8B 50 1C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_328_0 {
	meta:
		name = "@Flush"
		size = 9
		refs = "0004 InternalFlush"
	strings:
		$1 = { 8B 50 20 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_331_0 {
	meta:
		name = "BlockIO"
		size = 142
		refs = "0032 GetLastError 0037 SetInOutRes"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F1 8B FA 8B D8 8B 45 10 0F B7 53 04 23 D0 3B C2 75 5A 6A 00 8D 45 FC 50 8B 43 08 F7 EE 50 57 8B 03 50 FF 55 0C 85 C0 75 11 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 89 45 FC EB 41 8B 4B 08 8B 45 FC 33 D2 F7 F1 89 45 FC 8B 45 14 85 C0 74 0A 8B 45 14 8B 55 FC 89 10 EB 23 3B 75 FC 74 1E 8B 45 08 E8 ?? ?? ?? ?? 33 C0 89 45 FC EB 0F B8 67 00 00 00 E8 ?? ?? ?? ?? 33 C0 89 45 FC 8B 45 FC 5F 5E 5B 59 5D C2 10 00 }
	condition:
		$1
}

rule function_332_0 {
	meta:
		name = "@BlockRead"
		size = 30
		refs = "000e ReadFileX 0015 BlockIO"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 53 68 B1 D7 00 00 68 ?? ?? ?? ?? 6A 64 E8 ?? ?? ?? ?? 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_333_0 {
	meta:
		name = "@BlockWrite"
		size = 30
		refs = "000e WriteFileX 0015 BlockIO"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 53 68 B2 D7 00 00 68 ?? ?? ?? ?? 6A 65 E8 ?? ?? ?? ?? 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_334_0 {
	meta:
		name = "@Close"
		size = 86
		refs = "0039 SetInOutRes 0041 Input"
	strings:
		$1 = { 53 56 8B D8 33 F6 0F B7 43 04 66 3D B1 D7 72 2F 66 3D B3 D7 77 29 66 25 B2 D7 66 3D B2 D7 75 07 8B C3 FF 53 1C 8B F0 85 F6 75 07 8B C3 FF 53 24 8B F0 85 F6 74 1B 8B C6 E8 ?? ?? ?? ?? EB 12 81 FB ?? ?? ?? ?? 74 0A B8 67 00 00 00 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_335_0 {
	meta:
		name = "@PStrCat"
		size = 40
	strings:
		$1 = { 56 57 89 C7 31 C0 8A 07 89 D6 31 C9 8A 0E 46 88 C2 00 CA 72 0A 88 17 47 01 C7 F3 A4 5F 5E C3 FE C2 28 D1 B2 FF EB EE C3 }
	condition:
		$1
}

rule function_336_0 {
	meta:
		name = "@PStrNCat"
		size = 48
	strings:
		$1 = { 56 57 89 C7 31 C0 8A 07 89 D6 31 D2 8A 16 46 00 D0 72 12 38 C8 77 0E 89 D1 8A 17 88 07 47 01 D7 F3 A4 5F 5E C3 88 C8 2A 0F 76 F7 88 CA EB E8 C3 }
	condition:
		$1
}

rule function_337_0 {
	meta:
		name = "@PStrCpy"
		size = 11
		refs = "0006 Move"
	strings:
		$1 = { 0F B6 0A 41 92 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_338_0 {
	meta:
		name = "@PStrNCpy"
		size = 25
		refs = "0013 Move"
	strings:
		$1 = { 53 0F B6 1A 3A CB 76 02 8B CB 88 08 42 40 0F B6 C9 92 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_339_0 {
	meta:
		name = "@PStrCmp"
		size = 130
	strings:
		$1 = { 53 56 57 89 C6 89 D7 31 C0 31 D2 8A 06 8A 17 46 47 29 D0 77 02 01 C2 52 C1 EA 02 74 26 8B 0E 8B 1F 39 D9 75 44 4A 74 15 8B 4E 04 8B 5F 04 39 D9 75 37 83 C6 08 83 C7 08 4A 75 E2 EB 06 83 C6 04 83 C7 04 5A 83 E2 03 74 1C 8A 0E 3A 0F 75 2F 4A 74 13 8A 4E 01 3A 4F 01 75 24 4A 74 08 8A 4E 02 3A 4F 02 75 19 01 C0 EB 15 5A 38 D9 75 10 38 FD 75 0C C1 E9 10 C1 EB 10 38 D9 75 02 38 FD 5F 5E 5B C3 }
	condition:
		$1
}

rule function_340_0 {
	meta:
		name = "@AStrCmp"
		size = 111
	strings:
		$1 = { 53 56 51 89 CE C1 EE 02 74 26 8B 08 8B 1A 39 D9 75 45 4E 74 15 8B 48 04 8B 5A 04 39 D9 75 38 83 C0 08 83 C2 08 4E 75 E2 EB 06 83 C0 04 83 C2 04 5E 83 E6 03 74 36 8A 08 3A 0A 75 30 4E 74 13 8A 48 01 3A 4A 01 75 25 4E 74 08 8A 48 02 3A 4A 02 75 1A 31 C0 5E 5B C3 5E 38 D9 75 10 38 FD 75 0C C1 E9 10 C1 EB 10 38 D9 75 02 38 FD 5E 5B C3 }
	condition:
		$1
}

rule function_341_0 {
	meta:
		name = "@EofFile"
		size = 28
		refs = "0007 @FilePos 0010 @FileSize"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 8B F0 8B C3 E8 ?? ?? ?? ?? 3B F0 0F 9D C0 5E 5B C3 }
	condition:
		$1
}

rule function_342_0 {
	meta:
		name = "@EofText"
		size = 55
		refs = "0027 @ReadChar"
	strings:
		$1 = { 66 81 78 04 B1 D7 75 1D 8B 50 0C 3B 50 10 73 15 03 50 14 66 F7 40 06 01 00 74 19 8A 0A 80 F9 1A 75 12 B0 01 C3 50 E8 ?? ?? ?? ?? 5A 80 FC 1A 74 F1 FF 4A 0C 31 C0 C3 }
	condition:
		$1
}

rule function_343_0 {
	meta:
		name = "@Eoln"
		size = 87
		refs = "0037 @ReadChar"
	strings:
		$1 = { 66 81 78 04 B1 D7 75 2D 8B 50 0C 3B 50 10 73 25 03 50 14 66 F7 40 06 01 00 B0 00 8A 0A 74 0B 80 F9 0D 74 30 80 F9 1A 74 2B C3 80 F9 0A 74 25 80 F9 1A 74 20 C3 50 E8 ?? ?? ?? ?? 5A 80 FC 1A 74 13 FF 4A 0C 31 C9 91 66 F7 42 04 01 00 74 DB 80 F9 0D 75 02 B0 01 C3 }
	condition:
		$1
}

rule function_344_0 {
	meta:
		name = "@Erase"
		size = 56
		refs = "0019 SetInOutRes 0024 DeleteFileA 002d GetLastError"
	strings:
		$1 = { 53 8B D8 0F B7 43 04 66 3D B0 D7 72 06 66 3D B3 D7 76 0C B8 66 00 00 00 E8 ?? ?? ?? ?? 5B C3 8D 43 48 50 E8 ?? ?? ?? ?? 85 C0 75 0A E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_345_0 {
	meta:
		name = "@FSafeDivideR"
		size = 8
		refs = "0003 @FSafeDivide"
	strings:
		$1 = { D9 C9 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_346_0 {
	meta:
		name = "@FSafeDivide"
		size = 354
		refs = "0002 TestFDIV 0050 @FSafeDivide"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 00 7E 7E DE F9 C3 00 01 00 00 04 00 00 07 00 00 0A 00 00 0D 00 00 00 00 70 3F 00 00 88 3F 00 00 00 5F 00 00 00 C0 7E 01 50 41 00 00 00 80 FF FF 47 41 00 00 00 00 00 00 F0 3F C6 05 ?? ?? ?? ?? 01 50 83 EC 0C DB 3C 24 DD 05 ?? ?? ?? ?? DC 35 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? DC 2D ?? ?? ?? ?? DC 1D ?? ?? ?? ?? 9B DF E0 C1 E8 07 83 E0 02 48 A2 ?? ?? ?? ?? DB 2C 24 83 C4 0C 58 E9 ?? ?? ?? ?? 74 B7 50 83 EC 18 DB 7C 24 0C DB 3C 24 DB 2C 24 DB 6C 24 0C 8B 44 24 10 01 C0 73 63 35 00 00 00 0E A9 00 00 00 0E 74 07 DE F9 83 C4 18 58 C3 C1 E8 1C 80 B8 ?? ?? ?? ?? 00 74 ED 8B 44 24 14 25 FF 7F 00 00 74 E2 3D FF 7F 00 00 74 DB 8B 44 24 08 25 FF 7F 00 00 83 F8 01 74 12 D8 0D ?? ?? ?? ?? D9 C9 D8 0D ?? ?? ?? ?? D9 C9 EB BB D8 0D ?? ?? ?? ?? D9 C9 D8 0D ?? ?? ?? ?? D9 C9 EB A9 8B 44 24 0C 0B 44 24 10 74 9F 8B 44 24 14 25 FF 7F 00 00 75 94 8B 44 24 08 25 FF 7F 00 00 74 15 3D FF 7F 00 00 74 82 8B 44 24 04 01 C0 0F 83 76 FF FF FF EB 0C 8B 44 24 04 01 C0 0F 82 68 FF FF FF D9 C9 DD D8 D9 C0 D8 0D ?? ?? ?? ?? DB 7C 24 0C DB 2C 24 D9 C9 E9 3A FF FF FF C3 }
	condition:
		$1
}

rule function_347_0 {
	meta:
		name = "@FilePos"
		size = 77
		refs = "001e SetFilePointer 002a InOutError 0041 SetInOutRes"
	strings:
		$1 = { 53 56 8B D8 0F B7 43 04 66 3D B0 D7 76 2D 66 3D B3 D7 77 27 6A 01 6A 00 6A 00 8B 03 50 E8 ?? ?? ?? ?? 8B F0 83 FE FF 75 07 E8 ?? ?? ?? ?? EB 18 8B C6 33 D2 F7 73 08 8B F0 EB 0D B8 67 00 00 00 E8 ?? ?? ?? ?? 83 CE FF 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_348_0 {
	meta:
		name = "@FileSize"
		size = 73
		refs = "001d GetFileSize 0029 InOutError 0040 SetInOutRes"
	strings:
		$1 = { 53 56 8B D8 83 CE FF 0F B7 43 04 66 3D B0 D7 76 29 66 3D B3 D7 77 23 6A 00 8B 03 50 E8 ?? ?? ?? ?? 8B F0 83 FE FF 75 07 E8 ?? ?? ?? ?? EB 15 8B C6 33 D2 F7 73 08 8B F0 EB 0A B8 67 00 00 00 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_349_0 {
	meta:
		name = "@FillChar"
		size = 153
		refs = "0054 @FillChar"
	strings:
		$1 = { 83 FA 20 88 CD 7C 3D 66 89 08 66 89 48 02 66 89 48 04 66 89 48 06 83 EA 10 DD 00 DD 14 02 DD 54 02 08 89 C1 83 E1 07 83 E9 08 29 C8 01 CA 01 D0 F7 DA DD 14 02 DD 54 02 08 83 C2 10 7C F4 DD C0 C3 90 90 90 85 D2 7E 50 88 4C 02 FF 83 E2 FE F7 DA 8D 14 55 ?? ?? ?? ?? FF E2 90 90 66 89 48 1C 66 89 48 1A 66 89 48 18 66 89 48 16 66 89 48 14 66 89 48 12 66 89 48 10 66 89 48 0E 66 89 48 0C 66 89 48 0A 66 89 48 08 66 89 48 06 66 89 48 04 66 89 48 02 66 89 08 C3 C3 }
	condition:
		$1
}

rule function_350_0 {
	meta:
		name = "Mark"
		size = 8
		refs = "0003 Error"
		altNames = "Release"
	strings:
		$1 = { B0 02 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_351_0 {
	meta:
		name = "@ReadRec"
		size = 75
		refs = "0024 ReadFile 0040 GetLastError 0045 SetInOutRes"
	strings:
		$1 = { 53 31 C9 89 C3 66 8B 48 04 81 E9 B1 D7 00 00 74 05 83 E9 02 75 22 6A 00 89 E0 6A 00 50 FF 73 08 52 FF 33 E8 ?? ?? ?? ?? 5A 48 75 13 3B 53 08 74 18 B8 64 00 00 00 EB 0C B8 67 00 00 00 EB 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_352_0 {
	meta:
		name = "TryOpenForInput"
		size = 58
		refs = "0005 Input 000e DefaultTextLineBreakStyle 0019 @ResetText 0032 SetInOutRes"
	strings:
		$1 = { 53 8B D8 81 FB ?? ?? ?? ?? 75 12 0F B6 05 ?? ?? ?? ?? 66 89 43 06 8B C3 E8 ?? ?? ?? ?? 66 81 7B 04 B1 D7 0F 94 C0 8B D8 84 DB 75 0A B8 68 00 00 00 E8 ?? ?? ?? ?? 8B C3 5B C3 }
	condition:
		$1
}

rule function_353_0 {
	meta:
		name = "@ReadChar"
		size = 105
		refs = "000a TryOpenForInput 005d SetInOutRes"
	strings:
		$1 = { 66 81 78 04 B1 D7 74 0B 50 E8 ?? ?? ?? ?? 84 C0 58 74 4F 8B 50 0C 3B 50 10 73 1C 66 F7 40 06 01 00 8B 48 14 8A 0C 0A 74 05 80 F9 1A 74 34 42 89 50 0C 31 C0 88 C8 C3 50 FF 50 1C 85 C0 75 1D 58 8B 50 0C 3B 50 10 72 D3 66 F7 40 06 01 00 74 12 8B 48 14 C6 04 0A 1A FF 40 10 EB 06 E8 ?? ?? ?? ?? 58 B1 1A 88 CC 88 C8 C3 }
	condition:
		$1
}

rule function_354_0 {
	meta:
		name = "@ReadLong"
		size = 86
		refs = "0009 @SeekEof 0018 @ReadChar 002e @ValLong 003d SetInOutRes"
	strings:
		$1 = { 53 56 57 83 EC 24 89 C6 E8 ?? ?? ?? ?? FE C8 74 3C 89 E7 B3 20 89 F0 E8 ?? ?? ?? ?? 3C 20 76 23 AA FE CB 75 F0 C6 07 00 89 E0 52 89 E2 E8 ?? ?? ?? ?? 5A 85 D2 74 18 B8 6A 00 00 00 E8 ?? ?? ?? ?? EB 0C 80 FC 1A 74 DD FF 4E 0C EB D8 31 C0 83 C4 24 5F 5E 5B C3 }
	condition:
		$1
}

rule function_355_0 {
	meta:
		name = "ReadLine"
		size = 127
		refs = "0012 TryOpenForInput 0063 @ReadChar"
	strings:
		$1 = { 53 56 57 51 89 CE 89 D7 66 81 78 04 B1 D7 74 0B 50 E8 ?? ?? ?? ?? 84 C0 58 74 5B 89 C3 85 F6 7E 55 8B 53 0C 8B 4B 10 29 D1 03 53 14 49 7C 2E 8A 02 42 3C 0A 74 1E 3C 0D 74 14 3C 1A 74 06 AA 4E 7F EA EB 11 66 F7 43 06 01 00 74 F2 EB 07 8A 02 3C 0A 75 D8 4A 2B 53 14 89 53 0C EB 19 89 53 0C 89 D8 E8 ?? ?? ?? ?? 8B 53 0C 8B 4B 10 29 D1 03 53 14 84 E4 74 BC 89 D8 59 29 F1 5F 5E 5B C3 }
	condition:
		$1
}

rule function_356_0 {
	meta:
		name = "@ReadString"
		size = 11
		refs = "0003 ReadLine"
	strings:
		$1 = { 52 42 E8 ?? ?? ?? ?? 5A 88 0A C3 }
	condition:
		$1
}

rule function_357_0 {
	meta:
		name = "@ReadCString"
		size = 12
		refs = "0002 ReadLine"
	strings:
		$1 = { 52 E8 ?? ?? ?? ?? 5A C6 04 11 00 C3 }
	condition:
		$1
}

rule function_358_0 {
	meta:
		name = "@ReadLString"
		size = 106
		refs = "0009 @LStrClr 001d @ReadString 0026 @LStrFromString 004f @LStrCat"
	strings:
		$1 = { 53 56 89 C3 89 D6 89 D0 E8 ?? ?? ?? ?? 81 EC 00 01 00 00 89 D8 89 E2 B9 FF 00 00 00 E8 ?? ?? ?? ?? 89 F0 89 E2 E8 ?? ?? ?? ?? 80 3C 24 FF 75 31 89 D8 89 E2 B9 FF 00 00 00 E8 ?? ?? ?? ?? 89 E2 6A 00 89 E0 E8 ?? ?? ?? ?? 89 F0 8B 14 24 E8 ?? ?? ?? ?? 89 E0 E8 ?? ?? ?? ?? 58 80 3C 24 FF 74 CF 81 C4 00 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_359_0 {
	meta:
		name = "IsValidMultibyteChar"
		size = 38
		refs = "0013 DefaultSystemCodePage 0019 MultiByteToWideChar"
	strings:
		$1 = { 53 56 51 8B F2 8B D8 6A 01 8D 44 24 04 50 56 53 6A 08 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 0F 95 C0 5A 5E 5B C3 }
	condition:
		$1
}

rule function_360_0 {
	meta:
		name = "@ReadWChar"
		size = 94
		refs = "0010 @ReadChar 0023 IsValidMultibyteChar 0038 WCharFromChar 004e SetInOutRes"
	strings:
		$1 = { 53 56 57 55 83 C4 F4 8B F0 8B EC 33 DB 8B C6 E8 ?? ?? ?? ?? 88 44 1D 00 43 C6 44 1D 00 00 8B C5 8B D3 E8 ?? ?? ?? ?? 84 C0 74 18 53 8B CD 8D 44 24 0C BA 01 00 00 00 E8 ?? ?? ?? ?? 0F B7 7C 24 08 EB 11 83 FB 07 7C C5 B8 6A 00 00 00 E8 ?? ?? ?? ?? 33 FF 8B C7 83 C4 0C 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_361_0 {
	meta:
		name = "@ReadWCString"
		size = 116
		refs = "0021 @ReadWChar 003c @EofText"
	strings:
		$1 = { 53 56 57 55 51 8B EA 8B F8 85 ED 74 61 33 DB D1 F9 79 03 83 D1 00 89 0C 24 3B 1C 24 7D 49 8B C7 E8 ?? ?? ?? ?? 8B F0 0F B7 C6 83 E8 0A 74 17 83 E8 03 74 17 83 E8 0D 75 23 8B C7 E8 ?? ?? ?? ?? 84 C0 75 23 EB 16 FF 4F 0C EB 1C 8B 47 0C 8B 57 14 80 3C 02 0A 75 05 FF 4F 0C EB 0B 66 89 74 5D 00 43 3B 1C 24 7C B7 66 C7 44 5D 00 00 00 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_362_0 {
	meta:
		name = "@ReadWString"
		size = 73
		refs = "000c @ReadWString 001a @ReadLString 0024 @WStrFromLStr 0039 @LStrClr 003f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B DA 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8D 55 FC E8 ?? ?? ?? ?? 8B C3 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_363_0 {
	meta:
		name = "@ReadExt"
		size = 86
		refs = "0009 @SeekEof 0018 @ReadChar 002e @ValExt 003d SetInOutRes"
	strings:
		$1 = { 53 56 57 83 EC 44 89 C6 E8 ?? ?? ?? ?? FE C8 74 3C 89 E7 B3 40 89 F0 E8 ?? ?? ?? ?? 3C 20 76 23 AA FE CB 75 F0 C6 07 00 89 E0 52 89 E2 E8 ?? ?? ?? ?? 5A 85 D2 74 18 B8 6A 00 00 00 E8 ?? ?? ?? ?? EB 0C 80 FC 1A 74 DD FF 4E 0C EB D8 D9 EE 83 C4 44 5F 5E 5B C3 }
	condition:
		$1
}

rule function_364_0 {
	meta:
		name = "@ReadLn"
		size = 46
		refs = "0006 @ReadChar"
	strings:
		$1 = { 53 89 C3 89 D8 E8 ?? ?? ?? ?? 3C 0A 74 1E 80 FC 1A 74 19 3C 0D 75 EC 89 D8 E8 ?? ?? ?? ?? 3C 0A 74 0A 80 FC 1A 74 05 FF 4B 0C EB D7 5B C3 }
	condition:
		$1
}

rule function_365_0 {
	meta:
		name = "@Rename"
		size = 96
		refs = "0013 @Rename 001d MoveFileA 0040 GetLastError 0045 SetInOutRes"
	strings:
		$1 = { 53 56 8B DA 8B F0 66 81 7E 04 B0 D7 75 3E 85 DB 75 05 BB ?? ?? ?? ?? 53 8D 46 48 50 E8 ?? ?? ?? ?? 85 C0 74 1A 33 C0 EB 05 88 54 06 48 40 0F B6 14 03 84 D2 74 20 3D 03 01 00 00 7C EC EB 17 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 B8 66 00 00 00 E8 ?? ?? ?? ?? 5E 5B C3 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_367_0 {
	meta:
		name = "@CloseFile"
		size = 38
		refs = "000f InternalClose 0018 InOutError"
	strings:
		$1 = { 53 56 8B D8 66 C7 43 04 B0 D7 33 F6 8B 03 E8 ?? ?? ?? ?? 84 C0 75 0A E8 ?? ?? ?? ?? BE 01 00 00 00 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_368_0 {
	meta:
		name = "OpenFile"
		size = 221
		refs = "0028 SetInOutRes 0038 @CloseFile 003f FileNOPProc 0050 FileMode 005c ShareTab 009c CreateFileA 00bc GetStdHandle 00d0 GetLastError"
	strings:
		$1 = { 53 56 57 89 D6 89 CF 31 D2 89 C3 66 8B 50 04 81 EA B0 D7 00 00 74 15 83 FA 03 0F 87 A2 00 00 00 FF 53 24 85 C0 74 05 E8 ?? ?? ?? ?? 66 C7 43 04 B3 D7 89 73 08 C7 43 24 ?? ?? ?? ?? C7 43 1C ?? ?? ?? ?? 80 7B 48 00 74 60 B8 00 00 00 C0 8A 15 ?? ?? ?? ?? 83 E2 70 C1 EA 02 8B 92 ?? ?? ?? ?? B9 02 00 00 00 83 EF 03 74 21 B9 03 00 00 00 47 74 19 B8 00 00 00 40 47 66 C7 43 04 B2 D7 74 0B B8 00 00 00 80 66 C7 43 04 B1 D7 6A 00 68 80 00 00 00 51 6A 00 52 50 8D 43 48 50 E8 ?? ?? ?? ?? 83 F8 FF 74 24 89 03 EB 30 C7 43 24 ?? ?? ?? ?? 83 FF 03 74 04 6A F6 EB 02 6A F5 E8 ?? ?? ?? ?? EB DE B8 66 00 00 00 EB 0B 66 C7 43 04 B0 D7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_369_0 {
	meta:
		name = "@ResetFile"
		size = 26
		refs = "0003 FileMode 0015 OpenFile"
	strings:
		$1 = { 0F B6 0D ?? ?? ?? ?? 80 E1 03 80 F9 02 76 02 B1 02 0F B6 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_370_0 {
	meta:
		name = "@RewritFile"
		size = 11
		refs = "0006 OpenFile"
	strings:
		$1 = { B9 03 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_371_0 {
	meta:
		name = "@Seek"
		size = 52
		refs = "001d SetFilePointer 0024 InOutError 002f SetInOutRes"
	strings:
		$1 = { 89 C1 0F B7 40 04 2D B1 D7 00 00 83 F8 02 77 19 6A 00 8B 41 08 F7 E2 6A 00 50 FF 31 E8 ?? ?? ?? ?? 40 0F 84 ?? ?? ?? ?? C3 B8 67 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_372_0 {
	meta:
		name = "@SeekEof"
		size = 30
		refs = "0006 @ReadChar"
	strings:
		$1 = { 53 89 C3 89 D8 E8 ?? ?? ?? ?? 3C 20 77 09 80 FC 1A 75 F0 B0 01 5B C3 FF 4B 0C 32 C0 5B C3 }
	condition:
		$1
}

rule function_373_0 {
	meta:
		name = "@SeekEoln"
		size = 42
		refs = "0006 @ReadChar"
	strings:
		$1 = { 53 89 C3 89 D8 E8 ?? ?? ?? ?? 3C 20 77 11 80 FC 1A 74 13 3C 0A 74 04 3C 0D 75 E8 B0 01 EB 02 32 C0 FF 4B 0C 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_374_0 {
	meta:
		name = "@SetTextBuf"
		size = 40
		refs = "0010 Error"
	strings:
		$1 = { 53 56 57 8B F1 8B FA 8B D8 85 F6 7D 07 B0 04 E8 ?? ?? ?? ?? 89 7B 14 89 73 08 33 C0 89 43 0C 33 C0 89 43 10 5F 5E 5B C3 }
	condition:
		$1
}

rule function_375_0 {
	meta:
		name = "@StrLong"
		size = 95
	strings:
		$1 = { 53 56 57 52 83 EC 14 89 CF 89 C6 99 31 D0 29 D0 B9 0A 00 00 00 31 DB 31 D2 F7 F1 83 C2 30 88 14 1C 43 85 C0 75 F1 85 F6 7D 05 C6 04 1C 2D 43 88 1F 47 8B 4C 24 14 81 F9 FF 00 00 00 7E 05 B9 FF 00 00 00 29 D9 7E 07 00 4F FF B0 20 F3 AA 8A 44 1C FF 88 07 47 4B 75 F6 83 C4 18 5F 5E 5B C3 }
	condition:
		$1
}

rule function_376_0 {
	meta:
		name = "@Str0Long"
		size = 10
		refs = "0005 @StrLong"
	strings:
		$1 = { 8B CA 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_377_0 {
	meta:
		name = "@Truncate"
		size = 41
		refs = "0012 SetEndOfFile 001a InOutError 0024 SetInOutRes"
	strings:
		$1 = { 0F B7 50 04 81 EA B1 D7 00 00 83 FA 02 77 0F FF 30 E8 ?? ?? ?? ?? 48 74 0F E9 ?? ?? ?? ?? B8 67 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_378_0 {
	meta:
		name = "@ValLong"
		size = 209
	strings:
		$1 = { 53 56 57 89 C6 50 85 C0 74 6C 31 C0 31 DB BF CC CC CC 0C 8A 1E 46 80 FB 20 74 F8 B5 00 80 FB 2D 74 62 80 FB 2B 74 5F 80 FB 24 74 5F 80 FB 78 74 5A 80 FB 58 74 55 80 FB 30 75 13 8A 1E 46 80 FB 78 74 48 80 FB 58 74 43 84 DB 74 20 EB 04 84 DB 74 2D 80 EB 30 80 FB 09 77 25 39 F8 77 21 8D 04 80 01 C0 01 D8 8A 1E 46 84 DB 75 E6 FE CD 74 09 85 C0 7D 54 EB 09 46 EB 06 F7 D8 7E 4B 78 49 5B 29 DE EB 47 FE C5 8A 1E 46 EB 9C BF FF FF FF 0F 8A 1E 46 84 DB 74 DF 80 FB 61 72 03 80 EB 20 80 EB 30 80 FB 09 76 0B 80 EB 11 80 FB 05 77 D0 80 C3 0A 39 F8 77 C9 C1 E0 04 01 D8 8A 1E 46 84 DB 75 D5 FE CD 75 02 F7 D8 59 31 F6 89 32 5F 5E 5B C3 }
	condition:
		$1
}

rule function_379_0 {
	meta:
		name = "@WriteRec"
		size = 72
		refs = "001f WriteFile 003b GetLastError 0040 SetInOutRes"
	strings:
		$1 = { 53 89 C3 0F B7 40 04 2D B2 D7 00 00 83 F8 01 77 22 6A 00 89 E0 6A 00 50 FF 73 08 52 FF 33 E8 ?? ?? ?? ?? 5A 48 75 13 3B 53 08 74 18 B8 65 00 00 00 EB 0C B8 05 00 00 00 EB 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 D8 5B C3 }
	condition:
		$1
}

rule function_380_0 {
	meta:
		name = "TryOpenForOutput"
		size = 66
		refs = "0005 Output 000d ErrOutput 0016 DefaultTextLineBreakStyle 0021 @RewritText 003a SetInOutRes"
	strings:
		$1 = { 53 8B D8 81 FB ?? ?? ?? ?? 74 08 81 FB ?? ?? ?? ?? 75 12 0F B6 05 ?? ?? ?? ?? 66 89 43 06 8B C3 E8 ?? ?? ?? ?? 66 81 7B 04 B2 D7 0F 94 C0 8B D8 84 DB 75 0A B8 69 00 00 00 E8 ?? ?? ?? ?? 8B C3 5B C3 }
	condition:
		$1
}

rule function_381_0 {
	meta:
		name = "@WriteBytes"
		size = 83
		refs = "0010 TryOpenForOutput 0042 SetInOutRes"
	strings:
		$1 = { 56 57 89 D6 66 81 78 04 B2 D7 74 0F 50 52 51 E8 ?? ?? ?? ?? 84 C0 59 5A 58 74 35 8B 78 14 03 78 0C 8B 50 08 2B 50 0C 39 CA 7F 20 01 50 0C 29 D1 50 51 89 D1 F3 A4 FF 50 1C 85 C0 75 04 59 58 EB DA E8 ?? ?? ?? ?? 59 58 5F 5E C3 01 48 0C F3 A4 5F 5E C3 }
	condition:
		$1
}

rule function_382_0 {
	meta:
		name = "@WriteSpaces"
		size = 121
		refs = "0003 @WriteSpaces 0017 @WriteBytes 001c @GetTls 0022 InOutRes"
	strings:
		$1 = { 89 D1 BA ?? ?? ?? ?? 83 F9 40 7E 64 83 E9 40 50 51 B9 40 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 B8 ?? ?? ?? ?? 00 75 04 59 58 EB D5 59 58 C3 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 85 C9 0F 8F ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_383_0 {
	meta:
		name = "@Write0Char"
		size = 60
		refs = "000b TryOpenForOutput 0024 SetInOutRes"
	strings:
		$1 = { 66 81 78 04 B2 D7 74 23 50 52 E8 ?? ?? ?? ?? 84 C0 5A 58 75 16 C3 50 52 FF 50 1C 85 C0 75 04 5A 58 EB 08 E8 ?? ?? ?? ?? 5A 58 C3 8B 48 0C 3B 48 08 7D E3 03 48 14 88 11 FF 40 0C C3 }
	condition:
		$1
}

rule function_384_0 {
	meta:
		name = "@WriteChar"
		size = 34
		refs = "000d @WriteSpaces 001b @WriteBytes"
	strings:
		$1 = { 53 51 88 14 24 8B D8 8B D1 4A 8B C3 E8 ?? ?? ?? ?? 8B D4 8B C3 B9 01 00 00 00 E8 ?? ?? ?? ?? 5A 5B C3 }
	condition:
		$1
}

rule function_385_0 {
	meta:
		name = "@WriteBool"
		size = 19
		refs = "0009 BoolStrs 000e @WriteString"
	strings:
		$1 = { 83 E2 7F C1 E2 05 8D 14 D5 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_386_0 {
	meta:
		name = "@Write0Bool"
		size = 8
		refs = "0003 @WriteBool"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_391_0 {
	meta:
		name = "@Write0CString"
		size = 8
		refs = "0003 @WriteCString"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_551_0 {
	meta:
		name = "@Write0LString"
		size = 8
		refs = "0003 @WriteLString"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_388_0 {
	meta:
		name = "@Write0Long"
		size = 8
		refs = "0003 @WriteLong"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_560_0 {
	meta:
		name = "@Write0Variant"
		size = 8
		refs = "0003 @WriteVariant"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_555_0 {
	meta:
		name = "@Write0WCString"
		size = 8
		refs = "0003 @WriteWCString"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_557_0 {
	meta:
		name = "@Write0WChar"
		size = 8
		refs = "0003 @WriteWChar"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_553_0 {
	meta:
		name = "@Write0WString"
		size = 8
		refs = "0003 @WriteWString"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_387_0 {
	meta:
		name = "@WriteLong"
		size = 62
		refs = "0018 @StrLong 0025 @PStrNCpy 0030 @WriteString"
	strings:
		$1 = { 53 56 57 81 C4 E0 FE FF FF 8B F9 8B F2 8B D8 8D 4C 24 20 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 54 24 20 8B C4 B1 1F E8 ?? ?? ?? ?? 8B D4 8B C3 8B CF E8 ?? ?? ?? ?? 81 C4 20 01 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_389_0 {
	meta:
		name = "@Write0String"
		size = 10
		refs = "0005 @WriteBytes"
	strings:
		$1 = { 0F B6 0A 42 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_390_0 {
	meta:
		name = "@WriteString"
		size = 36
		refs = "0010 @WriteSpaces 001d @WriteBytes"
	strings:
		$1 = { 53 56 8B DA 8B F0 0F B6 03 8B D1 2B D0 8B C6 E8 ?? ?? ?? ?? 0F B6 0B 8D 53 01 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_392_0 {
	meta:
		name = "@WriteCString"
		size = 45
		refs = "000c @strlen 0019 @WriteSpaces 0024 @WriteBytes"
	strings:
		$1 = { 53 56 57 55 8B E9 8B FA 8B F0 57 E8 ?? ?? ?? ?? 8B D8 8B D5 2B D3 8B C6 E8 ?? ?? ?? ?? 8B D7 8B C6 8B CB E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_393_0 {
	meta:
		name = "@Write2Ext"
		size = 50
		refs = "001b @Str2Ext 0024 @WriteString"
	strings:
		$1 = { DB 6C 24 04 81 EC 00 01 00 00 50 52 83 EC 0C DB 3C 24 89 D0 89 CA 8D 4C 24 14 E8 ?? ?? ?? ?? 59 58 89 E2 E8 ?? ?? ?? ?? 81 C4 00 01 00 00 C2 0C 00 C3 }
	condition:
		$1
}

rule function_394_0 {
	meta:
		name = "@Write1Ext"
		size = 9
		refs = "0004 @Write2Ext"
	strings:
		$1 = { 83 C9 FF E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_395_0 {
	meta:
		name = "@Write0Ext"
		size = 14
		refs = "0009 @Write2Ext"
	strings:
		$1 = { BA 17 00 00 00 83 C9 FF E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_396_0 {
	meta:
		name = "@WriteLn"
		size = 71
		refs = "001e @WriteBytes 003d @Flush"
	strings:
		$1 = { 53 56 51 8B D8 F6 43 06 01 74 1B C6 04 24 0D C6 44 24 01 0A 8B D4 8B C3 B9 02 00 00 00 E8 ?? ?? ?? ?? 8B F0 EB 14 C6 04 24 0A 8B D4 8B C3 B9 01 00 00 00 E8 ?? ?? ?? ?? 8B F0 8B C3 E8 ?? ?? ?? ?? 8B C6 5A 5E 5B C3 }
	condition:
		$1
}

rule function_397_0 {
	meta:
		name = "@_CToPasStr"
		size = 11
		refs = "0006 @_CLenToPasStr"
	strings:
		$1 = { B9 FF 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_398_0 {
	meta:
		name = "@_CLenToPasStr"
		size = 35
	strings:
		$1 = { 53 50 81 F9 FF 00 00 00 76 05 B9 FF 00 00 00 8A 1A 42 84 DB 74 06 40 88 18 49 75 F3 5A 29 D0 88 02 5B C3 }
	condition:
		$1
}

rule function_399_0 {
	meta:
		name = "@_ArrayToPasStr"
		size = 23
		refs = "0012 Move"
	strings:
		$1 = { 81 F9 FF 00 00 00 7E 05 B9 FF 00 00 00 88 08 40 92 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_400_0 {
	meta:
		name = "@_PasToCStr"
		size = 29
		refs = "000f Move"
	strings:
		$1 = { 53 56 8B F2 8B D8 0F B6 0B 8B D6 8D 43 01 E8 ?? ?? ?? ?? 0F B6 03 C6 04 06 00 5E 5B C3 }
	condition:
		$1
}

rule function_401_0 {
	meta:
		name = "@SetElem"
		size = 34
	strings:
		$1 = { 53 57 89 C7 31 DB 88 CB 89 D9 31 C0 F3 AA 29 DF 40 88 D1 D2 C0 C1 E9 03 39 D9 73 03 08 04 39 5F 5B C3 }
	condition:
		$1
}

rule function_402_0 {
	meta:
		name = "@SetRange"
		size = 86
	strings:
		$1 = { 53 56 57 31 DB 88 E3 0F B6 F0 0F B6 D2 89 CF 89 D9 31 C0 F3 AA 29 DF C1 E3 03 39 DA 72 03 8D 53 FF 39 D6 77 2D 48 89 F1 80 E1 07 D2 E0 C1 EE 03 88 D1 F6 D1 80 E1 07 D2 EC C1 EA 03 01 F7 89 D1 29 F1 75 06 20 E0 88 07 EB 08 AA 49 B0 FF F3 AA 88 27 5F 5E 5B C3 }
	condition:
		$1
}

rule function_403_0 {
	meta:
		name = "@SetEq"
		size = 17
	strings:
		$1 = { 56 57 89 C6 89 D7 81 E1 FF 00 00 00 F3 A6 5F 5E C3 }
	condition:
		$1
}

rule function_404_0 {
	meta:
		name = "@SetLe"
		size = 15
	strings:
		$1 = { 8A 2A F6 D5 22 28 75 06 42 40 FE C9 75 F2 C3 }
	condition:
		$1
}

rule function_405_0 {
	meta:
		name = "@SetIntersect"
		size = 11
	strings:
		$1 = { 8A 2A 42 20 28 40 FE C9 75 F6 C3 }
	condition:
		$1
}

rule function_406_0 {
	meta:
		name = "@SetIntersect3"
		size = 24
	strings:
		$1 = { 53 56 8B 74 24 0C 8A 5C 11 FF 22 5C 31 FF 88 5C 01 FF 49 75 F1 5E 5B C3 }
	condition:
		$1
}

rule function_407_0 {
	meta:
		name = "@SetUnion"
		size = 11
	strings:
		$1 = { 8A 2A 42 08 28 40 FE C9 75 F6 C3 }
	condition:
		$1
}

rule function_408_0 {
	meta:
		name = "@SetUnion3"
		size = 24
	strings:
		$1 = { 53 56 8B 74 24 0C 8A 5C 11 FF 0A 5C 31 FF 88 5C 01 FF 49 75 F1 5E 5B C3 }
	condition:
		$1
}

rule function_409_0 {
	meta:
		name = "@SetSub"
		size = 13
	strings:
		$1 = { 8A 2A F6 D5 42 20 28 40 FE C9 75 F4 C3 }
	condition:
		$1
}

rule function_410_0 {
	meta:
		name = "@SetSub3"
		size = 26
	strings:
		$1 = { 53 56 8B 74 24 0C 8A 5C 31 FF F6 D3 22 5C 11 FF 88 5C 01 FF 49 75 EF 5E 5B C3 }
	condition:
		$1
}

rule function_411_0 {
	meta:
		name = "@SetExpand"
		size = 31
	strings:
		$1 = { 56 57 89 C6 89 D7 89 CA 31 C9 31 C0 88 D1 F3 AA 88 F1 28 D1 F3 A4 B1 20 28 F1 F3 AA 5F 5E C3 }
	condition:
		$1
}

rule function_412_0 {
	meta:
		name = "@EmitDigits"
		size = 110
		refs = "0010 tenE17 0018 tenE18"
	strings:
		$1 = { 53 31 DB 57 89 D7 89 C1 83 EC 0A C6 07 30 DC 8B ?? ?? ?? ?? D9 FC DC 93 ?? ?? ?? ?? 9B DF E0 9E 72 09 DC A3 ?? ?? ?? ?? C6 07 31 DF 34 24 BA 08 00 00 00 47 9B 8A 04 14 88 C4 C0 E8 04 80 E4 0F 66 05 30 30 66 AB 4A 79 EB 83 E9 12 7C 06 B0 30 F3 AA EB 14 01 CF 80 3F 35 7C 0D 4F FE 07 80 3F 39 7E 05 C6 07 30 EB F3 83 C4 0A 5F 5B C3 }
	condition:
		$1
}

rule function_413_0 {
	meta:
		name = "@ScaleExt"
		size = 68
		refs = "002a @Pow10"
	strings:
		$1 = { 53 83 EC 0C 31 DB D9 C0 DB 3C 24 66 8B 44 24 08 66 85 C0 74 1B 66 2D FF 3F 66 BA 10 4D 66 F7 EA 0F BF C2 F7 D8 74 16 29 C3 E8 ?? ?? ?? ?? EB D6 83 7C 24 04 00 75 DE 83 3C 24 00 75 D8 83 C4 0C 89 D8 5B C3 }
	condition:
		$1
}

rule function_414_0 {
	meta:
		name = "@Str2Ext"
		size = 441
		refs = "0049 @ScaleExt 006e @EmitDigits 00f8 Ten 018a NanStr 0193 PlusInfStr 019b MinInfStr"
	strings:
		$1 = { DB 6C 24 04 53 56 57 89 C3 89 D6 51 81 EC 00 01 00 00 81 FB FF 00 00 00 7E 05 BB FF 00 00 00 D9 C0 DB 3C 24 31 C0 66 8B 44 24 08 89 C7 C1 EF 0F 66 25 FF 7F 66 3D FF 7F 0F 84 3E 01 00 00 D9 E1 85 F6 0F 8D A1 00 00 00 E8 ?? ?? ?? ?? 89 DE 83 EE 08 83 FE 02 7D 07 BE 02 00 00 00 EB 0A 83 FE 12 7E 05 BE 12 00 00 00 89 E2 50 89 F0 E8 ?? ?? ?? ?? 89 FA 8B BC 24 04 01 00 00 88 1F 47 B0 20 89 D9 29 F1 83 E9 08 7E 02 F3 AA 28 4F FF 84 D2 74 02 B0 2D AA 58 89 F1 89 E6 80 3E 30 74 02 40 4E 46 A4 C6 07 2E 47 49 F3 A4 C6 07 45 B1 2B 85 C0 7D 04 B1 2D F7 D8 88 4F 01 31 D2 66 B9 0A 00 66 F7 F1 80 C2 30 88 57 05 31 D2 66 F7 F1 80 C2 30 88 57 04 31 D2 66 F7 F1 80 C2 30 88 57 03 04 30 88 47 02 E9 86 00 00 00 81 FE D8 00 00 00 7E 05 BE D8 00 00 00 DC 15 ?? ?? ?? ?? 9B DF E0 9E B8 00 00 00 00 72 0E E8 ?? ?? ?? ?? 83 F8 23 0F 8F 38 FF FF FF 40 89 E2 50 01 F0 E8 ?? ?? ?? ?? 58 89 F2 89 E6 80 3E 30 74 02 40 4E 46 89 C1 01 F9 85 D2 74 09 41 01 D1 39 CB 7F 02 89 CB 50 57 8B BC 24 08 01 00 00 88 1F 47 29 CB 89 D9 7E 04 B0 20 F3 AA 28 4F FF 58 59 85 C0 74 04 C6 07 2D 47 F3 A4 85 D2 74 08 C6 07 2E 47 89 D1 F3 A4 81 C4 00 01 00 00 59 5F 5E 5B C2 0C 00 31 C0 DD D8 81 7C 24 04 00 00 00 80 8D B0 ?? ?? ?? ?? 75 0F 4F 8D B0 ?? ?? ?? ?? 75 06 8D B0 ?? ?? ?? ?? 89 CF 89 D9 88 0F 47 2A 0E 76 04 B0 20 F3 AA 28 4F FF 8A 0E 46 F3 A4 EB B7 C3 }
	condition:
		$1
}

rule function_415_0 {
	meta:
		name = "@Str0Ext"
		size = 16
		refs = "000b @Str2Ext"
	strings:
		$1 = { 89 C1 B8 17 00 00 00 83 CA FF E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_416_0 {
	meta:
		name = "@Str1Ext"
		size = 11
		refs = "0006 @Str2Ext"
	strings:
		$1 = { 89 D1 83 CA FF E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_417_0 {
	meta:
		name = "@ValExt"
		size = 259
		refs = "004b Ten 00df @Pow10"
	strings:
		$1 = { 53 31 DB 56 57 53 89 C6 50 D9 EE 31 C0 31 DB 31 FF 53 85 F6 0F 84 DE 00 00 00 8A 1E 46 80 FB 20 74 F8 B5 00 80 FB 2D 74 07 80 FB 2B 74 04 EB 05 FE C5 8A 1E 46 84 DB 0F 84 BC 00 00 00 8B 7C 24 08 80 EB 30 80 FB 09 77 15 DC 8F ?? ?? ?? ?? 89 1C 24 DA 04 24 8A 1E 46 84 DB 75 E5 EB 28 80 FB FE 75 27 8A 1E 46 84 DB 74 1C 80 EB 30 80 FB 09 77 18 DC 8F ?? ?? ?? ?? 89 1C 24 DA 04 24 48 8A 1E 46 84 DB 75 E4 31 FF EB 50 80 FB 15 74 05 80 FB 35 75 65 8A 1E 46 B4 00 80 FB 2D 74 07 80 FB 2B 74 04 EB 05 FE C4 8A 1E 46 80 EB 30 80 FB 09 77 47 89 DF 8A 1E 46 84 DB 74 16 80 EB 30 80 FB 09 77 36 8D 3C BF 01 FF 01 DF 8A 1E 46 84 DB 75 EA FE CC 75 02 F7 DF 0F BE C0 01 F8 52 51 E8 ?? ?? ?? ?? 59 5A FE CD 74 0B 83 C4 0C 31 F6 89 32 5F 5E 5B C3 D9 E0 EB F1 46 58 5B 29 DE 83 C4 04 EB EC C3 }
	condition:
		$1
}

rule function_419_0 {
	meta:
		name = "@Pow10"
		size = 740
		refs = "0023 @Pow10"
	strings:
		$1 = { 53 31 DB 85 C0 7C 4D 0F 84 9A 00 00 00 3D 00 14 00 00 0F 8D 81 00 00 00 89 C2 83 E2 1F 8D 14 92 DB AC 53 ?? ?? ?? ?? DE C9 C1 E8 05 74 79 89 C2 83 E2 0F 74 0C 8D 14 92 DB AC 53 ?? ?? ?? ?? DE C9 C1 E8 04 74 61 8D 04 80 DB AC 43 ?? ?? ?? ?? DE C9 EB 53 F7 D8 3D 00 14 00 00 7D 46 89 C2 83 E2 1F 8D 14 92 DB AC 53 ?? ?? ?? ?? DE F9 C1 E8 05 74 34 89 C2 83 E2 0F 74 0C 8D 14 92 DB AC 53 ?? ?? ?? ?? DE F9 C1 E8 04 74 1C 8D 04 80 DB AC 43 ?? ?? ?? ?? DE F9 EB 0E DD D8 DB AB ?? ?? ?? ?? EB 04 DD D8 D9 EE 5B C3 00 00 00 00 00 00 00 80 FF 7F 00 00 00 00 00 00 00 80 FF 3F 00 00 00 00 00 00 00 A0 02 40 00 00 00 00 00 00 00 C8 05 40 00 00 00 00 00 00 00 FA 08 40 00 00 00 00 00 00 40 9C 0C 40 00 00 00 00 00 00 50 C3 0F 40 00 00 00 00 00 00 24 F4 12 40 00 00 00 00 00 80 96 98 16 40 00 00 00 00 00 20 BC BE 19 40 00 00 00 00 00 28 6B EE 1C 40 00 00 00 00 00 F9 02 95 20 40 00 00 00 00 40 B7 43 BA 23 40 00 00 00 00 10 A5 D4 E8 26 40 00 00 00 00 2A E7 84 91 2A 40 00 00 00 80 F4 20 E6 B5 2D 40 00 00 00 A0 31 A9 5F E3 30 40 00 00 00 04 BF C9 1B 8E 34 40 00 00 00 C5 2E BC A2 B1 37 40 00 00 40 76 3A 6B 0B DE 3A 40 00 00 E8 89 04 23 C7 8A 3E 40 00 00 62 AC C5 EB 78 AD 41 40 00 80 7A 17 B7 26 D7 D8 44 40 00 90 AC 6E 32 78 86 87 48 40 00 B4 57 0A 3F 16 68 A9 4B 40 00 A1 ED CC CE 1B C2 D3 4E 40 A0 84 14 40 61 51 59 84 52 40 C8 A5 19 90 B9 A5 6F A5 55 40 3A 0F 20 F4 27 8F CB CE 58 40 84 09 94 F8 78 39 3F 81 5C 40 E5 0B B9 36 D7 07 8F A1 5F 40 DF 4E 67 04 CD C9 F2 C9 62 40 96 22 81 45 40 7C 6F FC 65 40 9E B5 70 2B A8 AD C5 9D 69 40 D5 A6 CF FF 49 1F 78 C2 D3 40 A3 14 9B C5 16 AB B3 EF 3D 41 E0 8C E9 80 C9 47 BA 93 A8 41 AA 17 E6 7F 2B A1 16 B6 12 42 6B 55 27 39 8D F7 70 E0 7C 42 30 C9 3C E3 FF 96 52 8A E7 42 8E DE F9 9D FB EB 7E AA 51 43 8C 2F 6A 5C 19 FC 26 D2 BB 43 76 E3 CC F2 29 2F 84 81 26 44 D2 0A 90 DB 00 27 A4 9F 90 44 17 AA F8 AE 10 E3 C5 C4 FA 44 59 9C B0 E9 07 9C 8A F2 64 45 D4 F3 F7 EB E1 4A 7A 95 CF 45 62 A2 95 07 DC D8 3E B8 39 46 C7 91 0E A6 AE A0 19 E3 A3 46 17 0C 75 81 86 75 76 C9 48 4D E4 A7 93 39 3B 35 B8 B2 ED 53 E5 5D 3D C5 5D 3B 8B 9E 92 5A A6 F0 A1 20 C0 54 A5 8C 37 61 8B 5A 8B D8 25 5D 89 F9 DB 67 F8 F3 27 BF A2 C8 5D DD 80 6E 9B 97 20 8A 02 52 60 C4 25 75 F0 59 D5 6E 62 11 35 AE CA 7B C3 }
	condition:
		$1
}

rule function_420_0 {
	meta:
		name = "@Real2Ext"
		size = 46
	strings:
		$1 = { 8A 70 05 80 E6 80 8A 10 84 D2 74 1E 66 81 C2 7E 3F 52 8B 50 02 81 CA 00 00 00 80 52 8A 50 01 C1 E2 18 52 DB 2C 24 83 C4 0C C3 D9 EE C3 C3 }
	condition:
		$1
}

rule function_421_0 {
	meta:
		name = "@Ext2Real"
		size = 75
		refs = "0046 Error"
	strings:
		$1 = { 53 83 EC 0C DB 3C 24 5B 5A 59 C1 EB 18 80 D3 00 83 D2 00 66 83 D1 00 70 29 01 D2 66 01 C9 D1 DA 66 D1 E9 66 81 E9 7E 3F 7E 0E 84 ED 7F 14 88 08 88 58 01 89 50 02 5B C3 31 C9 89 08 66 89 48 04 5B C3 5B B0 08 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_422_0 {
	meta:
		name = "@ObjSetup"
		size = 94
		refs = "0014 @GetMem"
	strings:
		$1 = { 83 FA 01 73 01 C3 51 85 C0 75 43 8B 42 F8 85 C0 74 35 52 E8 ?? ?? ?? ?? 5A 85 C0 74 26 57 8B 4A F8 89 C7 50 31 C0 C1 E9 02 F3 AB 8B 4A F8 83 E1 03 F3 AA 58 5F 8B 4A FC 85 C9 7C 03 89 14 01 85 C0 59 C3 31 D2 59 C3 31 D2 83 F8 01 59 C3 8B 4A FC 85 C9 7C 03 89 14 01 31 D2 85 C0 59 C3 }
	condition:
		$1
}

rule function_423_0 {
	meta:
		name = "@ObjCopy"
		size = 35
	strings:
		$1 = { 53 56 57 89 D6 89 C7 8D 04 39 8B 10 8B 5A F8 89 D9 C1 E9 02 F3 A5 89 D9 83 E1 03 F3 A4 89 10 5F 5E 5B C3 }
	condition:
		$1
}

rule function_424_0 {
	meta:
		name = "@Fail"
		size = 12
		refs = "0005 @FreeMem"
	strings:
		$1 = { 85 D2 74 05 E8 ?? ?? ?? ?? 31 C0 C3 }
	condition:
		$1
}

rule function_426_0 {
	meta:
		name = "@isNECWindows"
		size = 47
		refs = "0006 GetKeyboardType"
	strings:
		$1 = { 53 33 DB 6A 00 E8 ?? ?? ?? ?? 83 F8 07 75 1C 6A 01 E8 ?? ?? ?? ?? 25 00 FF 00 00 3D 00 0D 00 00 74 07 3D 00 04 00 00 75 02 B3 01 8B C3 5B C3 }
	condition:
		$1
}

rule function_427_0 {
	meta:
		name = "@FpuMaskInit"
		size = 196
		refs = "0009 Default8087CW 0019 @FpuMaskInit 0023 RegOpenKeyEx 0056 RegQueryValueEx 006c RegCloseKey 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 0F B7 05 ?? ?? ?? ?? 89 45 F8 8D 45 FC 50 6A 01 6A 00 68 ?? ?? ?? ?? 68 02 00 00 80 E8 ?? ?? ?? ?? 85 C0 75 4D 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C7 45 F4 04 00 00 00 8D 45 F4 50 8D 45 F8 50 6A 00 6A 00 68 ?? ?? ?? ?? 8B 45 FC 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EF 0F B7 05 ?? ?? ?? ?? 66 25 C0 FF 0F B7 55 F8 66 83 E2 3F 66 0B C2 66 A3 ?? ?? ?? ?? 8B E5 5D C3 53 4F 46 54 57 41 52 45 5C 42 6F 72 6C 61 6E 64 5C 44 65 6C 70 68 69 5C 52 54 4C 00 46 50 55 4D 61 73 6B 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_428_0 {
	meta:
		name = "@FpuInit"
		size = 10
		refs = "0005 Default8087CW"
	strings:
		$1 = { DB E3 9B D9 2D ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_429_0 {
	meta:
		name = "@BoundErr"
		size = 8
		refs = "0003 Error"
	strings:
		$1 = { B0 04 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_430_0 {
	meta:
		name = "@IntOver"
		size = 8
		refs = "0003 Error"
	strings:
		$1 = { B0 05 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_431_0 {
	meta:
		name = "TObject.ClassType"
		size = 7
	strings:
		$1 = { 8B 00 89 C2 8B C2 C3 }
	condition:
		$1
}

rule function_432_0 {
	meta:
		name = "TObject.ClassName"
		size = 17
	strings:
		$1 = { 56 57 89 D7 8B 70 D4 31 C9 8A 0E 41 F3 A4 5F 5E C3 }
	condition:
		$1
}

rule function_433_0 {
	meta:
		name = "TObject.ClassNameIs"
		size = 150
		refs = "0018 TObject.ClassNameIs 002b TObject.ClassName 0039 @LStrFromString 0040 @LStrLen 0048 @LStrToPChar 0067 CompareString 0082 @LStrClr 0088 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 FC FE FF FF 53 56 33 C9 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 95 FC FE FF FF 8B C3 E8 ?? ?? ?? ?? 8D 95 FC FE FF FF 8D 45 FC E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 50 8B C6 E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 50 6A 01 68 00 08 00 00 E8 ?? ?? ?? ?? 83 F8 02 0F 94 C3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_434_0 {
	meta:
		name = "TObject.ClassParent"
		size = 10
	strings:
		$1 = { 8B 40 DC 85 C0 74 02 8B 00 C3 }
	condition:
		$1
}

rule function_435_0 {
	meta:
		name = "TObject.NewInstance"
		size = 26
		refs = "0006 TObject.InstanceSize 000b @GetMem 0014 TObject.InitInstance"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_436_0 {
	meta:
		name = "TObject.FreeInstance"
		size = 19
		refs = "0006 TObject.CleanupInstance 000d @FreeMem"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_437_0 {
	meta:
		name = "TObject.InstanceSize"
		size = 6
	strings:
		$1 = { 83 C0 D8 8B 00 C3 }
	condition:
		$1
}

rule function_438_0 {
	meta:
		name = "TObject.Create"
		size = 32
		refs = "0008 @ClassCreate 0011 @AfterConstruction"
	strings:
		$1 = { 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 84 D2 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C C3 }
	condition:
		$1
}

rule function_439_0 {
	meta:
		name = "TObject.Destroy"
		size = 15
		refs = "0001 @BeforeDestruction 000a @ClassDestroy"
	strings:
		$1 = { E8 ?? ?? ?? ?? 84 D2 7E 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_440_0 {
	meta:
		name = "TObject.Free"
		size = 12
	strings:
		$1 = { 85 C0 74 07 B2 01 8B 08 FF 51 FC C3 }
	condition:
		$1
}

rule function_441_0 {
	meta:
		name = "TObject.InitInstance"
		size = 86
	strings:
		$1 = { 53 56 57 89 C3 89 D7 AB 8B 4B D8 31 C0 51 C1 E9 02 49 F3 AB 59 83 E1 03 F3 AA 89 D0 89 E2 8B 4B B8 85 C9 74 01 51 8B 5B DC 85 DB 74 04 8B 1B EB ED 39 D4 74 1D 5B 8B 0B 83 C3 04 8B 73 10 85 F6 74 06 8B 7B 14 89 34 07 83 C3 1C 49 75 ED 39 D4 75 E3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_442_0 {
	meta:
		name = "TObject.CleanupInstance"
		size = 32
		refs = "0013 @FinalizeRecord"
	strings:
		$1 = { 53 56 89 C3 89 C6 8B 36 8B 56 C0 8B 76 DC 85 D2 74 07 E8 ?? ?? ?? ?? 89 D8 85 F6 75 E9 5E 5B C3 }
	condition:
		$1
}

rule function_443_0 {
	meta:
		name = "InvokeImplGetter"
		size = 45
		refs = "0028 @IntfCopy"
	strings:
		$1 = { 87 D1 81 F9 00 00 00 FF 73 11 81 F9 00 00 00 FE 72 07 0F BF C9 03 08 FF 21 FF E1 81 E1 FF FF FF 00 01 C1 89 D0 8B 11 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_444_0 {
	meta:
		name = "TObject.GetInterface"
		size = 148
		refs = "0019 TObject.GetInterface 002d TObject.GetInterfaceEntry 005a InvokeImplGetter 0064 @IntfCopy 007f @IntfClear 0085 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 DB 89 5D F8 8B F1 89 55 FC 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 89 06 8B 55 FC 8B 07 E8 ?? ?? ?? ?? 8B D8 85 DB 74 31 8B 43 14 85 C0 74 13 03 F8 89 3E 83 3E 00 74 21 8B 06 50 8B 00 FF 50 04 EB 17 8D 4D F8 8B 53 18 8B C7 E8 ?? ?? ?? ?? 8B 55 F8 8B C6 E8 ?? ?? ?? ?? 83 3E 00 0F 95 C3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_445_0 {
	meta:
		name = "TObject.GetInterfaceEntry"
		size = 68
	strings:
		$1 = { 53 56 89 C3 8B 43 B8 85 C0 74 29 8B 08 83 C0 04 8B 32 3B 30 75 18 8B 72 04 3B 70 04 75 10 8B 72 08 3B 70 08 75 08 8B 72 0C 3B 70 0C 74 13 83 C0 1C 49 75 DC 8B 5B DC 85 DB 74 04 8B 1B EB C5 31 C0 5E 5B C3 }
	condition:
		$1
}

rule function_446_0 {
	meta:
		name = "TObject.GetInterfaceTable"
		size = 6
	strings:
		$1 = { 83 C0 B8 8B 00 C3 }
	condition:
		$1
}

rule function_447_0 {
	meta:
		name = "@IsClass"
		size = 33
		refs = "000f TObject.InheritsFrom"
	strings:
		$1 = { 53 56 8B F2 8B D8 85 DB 74 0D 8B D6 8B 03 E8 ?? ?? ?? ?? 84 C0 75 05 33 C0 5E 5B C3 B0 01 5E 5B C3 }
	condition:
		$1
}

rule function_448_0 {
	meta:
		name = "@AsClass"
		size = 27
		refs = "0016 Error"
	strings:
		$1 = { 85 C0 74 16 89 C1 8B 09 39 D1 74 0E 8B 49 DC 85 C9 75 F3 B0 0A E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_449_0 {
	meta:
		name = "@GetHelperIntf"
		size = 12
		refs = "0006 @IntfClear"
	strings:
		$1 = { 53 8B D9 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_450_0 {
	meta:
		name = "GetDynaMethod"
		size = 46
	strings:
		$1 = { 57 96 EB 02 8B 36 8B 7E D0 85 FF 74 0D 0F B7 0F 51 83 C7 02 F2 66 AF 74 0A 59 8B 76 DC 85 F6 75 E3 5F C3 58 01 C0 29 C8 8B 74 47 FC 5F C3 }
	condition:
		$1
}

rule function_451_0 {
	meta:
		name = "@CallDynaInst"
		size = 22
		refs = "0005 GetDynaMethod 0011 @AbstractError"
	strings:
		$1 = { 50 51 8B 00 E8 ?? ?? ?? ?? 59 58 74 02 FF E6 59 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_452_0 {
	meta:
		name = "@CallDynaClass"
		size = 20
		refs = "0003 GetDynaMethod 000f @AbstractError"
	strings:
		$1 = { 50 51 E8 ?? ?? ?? ?? 59 58 74 02 FF E6 59 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_453_0 {
	meta:
		name = "@FindDynaInst"
		size = 22
		refs = "0006 GetDynaMethod 0011 @AbstractError"
	strings:
		$1 = { 56 89 D6 8B 00 E8 ?? ?? ?? ?? 89 F0 5E 75 06 59 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_454_0 {
	meta:
		name = "@FindDynaClass"
		size = 20
		refs = "0004 GetDynaMethod 000f @AbstractError"
	strings:
		$1 = { 56 89 D6 E8 ?? ?? ?? ?? 89 F0 5E 75 06 59 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_455_0 {
	meta:
		name = "TObject.InheritsFrom"
		size = 19
	strings:
		$1 = { EB 02 8B 00 39 D0 74 08 8B 40 DC 85 C0 75 F3 C3 B0 01 C3 }
	condition:
		$1
}

rule function_456_0 {
	meta:
		name = "TObject.ClassInfo"
		size = 6
	strings:
		$1 = { 83 C0 C4 8B 00 C3 }
	condition:
		$1
}

rule function_457_0 {
	meta:
		name = "PICEmptyString"
		size = 6
		altNames = "TObject.SafeCallException"
	strings:
		$1 = { B8 FF FF 00 80 C3 }
	condition:
		$1
}

rule function_461_0 {
	meta:
		name = "TObject.Dispatch"
		size = 39
		refs = "0014 GetDynaMethod"
	strings:
		$1 = { 56 66 8B 32 66 09 F6 74 17 66 81 FE 00 C0 73 10 50 8B 00 E8 ?? ?? ?? ?? 58 74 05 89 F1 5E FF E1 5E 8B 08 FF 61 F0 C3 }
	condition:
		$1
}

rule function_462_0 {
	meta:
		name = "TObject.MethodAddress"
		size = 78
	strings:
		$1 = { 53 56 57 31 C9 31 FF 8A 1A EB 02 8B 00 8B 70 CC 85 F6 74 15 66 8B 3E 83 C6 02 8A 4E 06 38 D9 74 15 66 8B 0E 01 CE 4F 75 F1 8B 40 DC 85 C0 75 DB EB 18 8A 1A EB EB B5 00 8A 5C 31 06 32 1C 11 80 E3 DF 75 EE 49 75 F1 8B 46 02 5F 5E 5B C3 }
	condition:
		$1
}

rule function_463_0 {
	meta:
		name = "TObject.MethodName"
		size = 64
	strings:
		$1 = { 53 56 57 89 CF 31 DB 31 C9 EB 02 8B 00 8B 70 CC 85 F6 74 13 66 8B 0E 83 C6 02 3B 56 02 74 13 66 8B 1E 01 DE 49 75 F3 8B 40 DC 85 C0 75 DD 88 07 EB 0A 83 C6 06 31 C9 8A 0E 41 F3 A4 5F 5E 5B C3 }
	condition:
		$1
}

rule function_464_0 {
	meta:
		name = "TObject.FieldAddress"
		size = 80
	strings:
		$1 = { 53 56 57 31 C9 31 FF 8A 1A 50 8B 00 8B 70 C8 85 F6 74 14 66 8B 3E 83 C6 06 8A 4E 06 38 D9 74 18 8D 74 31 07 4F 75 F2 8B 40 DC 85 C0 75 DC 5A EB 1B 8A 1A 8A 4E 06 EB E8 8A 5C 31 06 32 1C 11 80 E3 DF 75 ED 49 75 F1 8B 06 5A 01 D0 5F 5E 5B C3 }
	condition:
		$1
}

rule function_465_0 {
	meta:
		name = "@ClassCreate"
		size = 77
		refs = "001b @ClassCreate 002a @HandleAnyException 0043 @ClassDestroy 0048 @RaiseAgain"
	strings:
		$1 = { 52 51 53 84 D2 7C 03 FF 50 F4 31 D2 8D 4C 24 10 64 8B 1A 89 19 89 69 08 C7 41 04 ?? ?? ?? ?? 89 41 0C 64 89 0A 5B 59 5A C3 E9 ?? ?? ?? ?? 8B 44 24 2C 8B 40 0C 85 C0 74 0E 8B 08 B2 81 50 FF 51 FC 58 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_466_0 {
	meta:
		name = "@ClassDestroy"
		size = 6
	strings:
		$1 = { 8B 10 FF 52 F8 C3 }
	condition:
		$1
}

rule function_467_0 {
	meta:
		name = "@AfterConstruction"
		size = 78
		refs = "000e @AfterConstruction 0030 @HandleAnyException 003a @BeforeDestruction 003f @RaiseAgain 0044 @DoneExcept"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 45 FC 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC 8B 10 FF 52 E4 8B 45 FC 64 8F 05 00 00 00 00 83 C4 08 EB 19 E9 ?? ?? ?? ?? B2 01 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_468_0 {
	meta:
		name = "@BeforeDestruction"
		size = 15
	strings:
		$1 = { 84 D2 7F 01 C3 50 52 8B 10 FF 52 E8 5A 58 C3 }
	condition:
		$1
}

rule function_469_0 {
	meta:
		name = "NotifyReRaise"
		size = 27
		refs = "0002 DebugHook 0016 RaiseExceptionProc"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 01 76 11 6A 00 6A 00 6A 00 68 DF FA ED 0E FF 15 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_470_0 {
	meta:
		name = "NotifyNonDelphiException"
		size = 33
		refs = "0002 DebugHook 0018 RaiseExceptionProc"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 00 74 17 50 50 52 54 6A 02 6A 00 68 E4 FA ED 0E FF 15 ?? ?? ?? ?? 83 C4 08 58 C3 }
	condition:
		$1
}

rule function_471_0 {
	meta:
		name = "NotifyExcept"
		size = 21
		refs = "000c RaiseExceptionProc"
	strings:
		$1 = { 54 6A 01 6A 00 68 E0 FA ED 0E FF 15 ?? ?? ?? ?? 83 C4 04 58 C3 }
	condition:
		$1
}

rule function_472_0 {
	meta:
		name = "NotifyOnExcept"
		size = 19
		refs = "0002 DebugHook 000e NotifyExcept"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 01 76 09 50 FF 73 04 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_473_0 {
	meta:
		name = "NotifyAnyExcept"
		size = 17
		refs = "0002 DebugHook 000c NotifyExcept"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 01 76 07 50 53 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_474_0 {
	meta:
		name = "CheckJmp"
		size = 30
	strings:
		$1 = { 85 C9 74 19 8B 41 01 80 39 E9 74 0C 80 39 EB 75 0C 0F BE C0 41 41 EB 03 83 C1 05 01 C1 C3 }
	condition:
		$1
}

rule function_475_0 {
	meta:
		name = "NotifyExceptFinally"
		size = 39
		refs = "0002 DebugHook 000d CheckJmp 001e RaiseExceptionProc"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 01 76 1D 50 52 51 E8 ?? ?? ?? ?? 51 54 6A 01 6A 00 68 E1 FA ED 0E FF 15 ?? ?? ?? ?? 59 59 5A 58 C3 }
	condition:
		$1
}

rule function_476_0 {
	meta:
		name = "NotifyTerminate"
		size = 28
		refs = "0002 DebugHook 0016 RaiseExceptionProc"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 01 76 12 52 54 6A 01 6A 00 68 E2 FA ED 0E FF 15 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_477_0 {
	meta:
		name = "NotifyUnhandled"
		size = 30
		refs = "0004 DebugHook 0017 RaiseExceptionProc"
	strings:
		$1 = { 50 52 80 3D ?? ?? ?? ?? 01 76 10 54 6A 02 6A 00 68 E3 FA ED 0E FF 15 ?? ?? ?? ?? 5A 58 C3 }
	condition:
		$1
}

rule function_478_0 {
	meta:
		name = "@HandleAnyException"
		size = 298
		refs = "0021 @FpuInit 0027 ExceptObjProc 004e NotifyNonDelphiException 0054 JITEnable 005d DebugHook 006b UnhandledExceptionFilter 00cd @HandleAnyException 00d4 RTLUnwindProc 00dd @GetTls 00e3 RaiseListPtr 00fe NotifyAnyExcept 0105 @HandleFinallyInternal 0120 TObject.Free"
	strings:
		$1 = { 8B 44 24 04 F7 40 04 06 00 00 00 0F 85 13 01 00 00 81 38 DE FA ED 0E 8B 50 18 8B 48 14 74 6E FC E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 85 D2 0F 84 F1 00 00 00 FF D2 85 C0 0F 84 E7 00 00 00 8B 54 24 0C 8B 4C 24 04 81 39 CE FA EF 0E 74 37 E8 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 76 29 80 3D ?? ?? ?? ?? 00 77 20 8D 4C 24 04 50 51 E8 ?? ?? ?? ?? 83 F8 00 58 0F 84 AB 00 00 00 89 C2 8B 44 24 04 8B 48 0C EB 30 89 C2 8B 44 24 04 8B 48 0C 80 3D ?? ?? ?? ?? 01 76 1E 80 3D ?? ?? ?? ?? 00 77 15 50 8D 44 24 08 52 51 50 E8 ?? ?? ?? ?? 83 F8 00 59 5A 58 74 70 83 48 04 02 53 31 DB 56 57 55 64 8B 1B 53 50 52 51 8B 54 24 28 6A 00 50 68 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 8B 7C 24 28 E8 ?? ?? ?? ?? FF B0 ?? ?? ?? ?? 89 A0 ?? ?? ?? ?? 8B 6F 08 8B 5F 04 C7 47 04 ?? ?? ?? ?? 83 C3 05 E8 ?? ?? ?? ?? FF E3 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 88 ?? ?? ?? ?? 8B 11 89 90 ?? ?? ?? ?? 8B 41 08 E9 ?? ?? ?? ?? B8 01 00 00 00 C3 }
	condition:
		$1
}

rule function_479_0 {
	meta:
		name = "@HandleOnException"
		size = 390
		refs = "001b @FpuInit 0021 ExceptClsProc 007b @AStrCmp 00ad ExceptObjProc 00b6 NotifyNonDelphiException 00bc JITEnable 00c5 DebugHook 00d3 UnhandledExceptionFilter 0129 @HandleOnException 0130 RTLUnwindProc 013a @GetTls 0140 RaiseListPtr 0159 NotifyOnExcept 0161 @HandleFinallyInternal 017c TObject.Free"
	strings:
		$1 = { 8B 44 24 04 F7 40 04 06 00 00 00 0F 85 6F 01 00 00 81 38 DE FA ED 0E 74 1F FC E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 85 D2 0F 84 53 01 00 00 FF D2 85 C0 75 0A E9 48 01 00 00 8B 40 18 8B 00 8B 54 24 08 53 56 57 55 8B 4A 04 8B 59 05 8D 71 09 89 C5 8B 06 85 C0 74 43 89 EF EB 02 8B 3F 8B 00 39 F8 74 37 8B 48 D8 3B 4F D8 75 17 8B 40 D4 8B 57 D4 31 C9 8A 08 3A 0A 75 09 40 42 E8 ?? ?? ?? ?? 74 18 8B 7F DC 8B 06 85 FF 75 D0 83 C6 08 4B 75 C0 5D 5F 5E 5B E9 E7 00 00 00 8B 44 24 14 81 38 DE FA ED 0E 8B 50 18 8B 48 14 74 41 FF 15 ?? ?? ?? ?? 8B 54 24 1C E8 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 76 1E 80 3D ?? ?? ?? ?? 00 77 15 8D 4C 24 04 50 51 E8 ?? ?? ?? ?? 83 F8 00 58 0F 84 9F 00 00 00 89 C2 8B 44 24 14 8B 48 0C EB 27 80 3D ?? ?? ?? ?? 01 76 1E 80 3D ?? ?? ?? ?? 00 77 15 50 8D 44 24 08 52 51 50 E8 ?? ?? ?? ?? 83 F8 00 59 5A 58 74 6D 31 DB 64 8B 1B 53 50 52 51 8B 54 24 28 83 48 04 02 56 6A 00 50 68 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 5B 8B 7C 24 28 E8 ?? ?? ?? ?? FF B0 ?? ?? ?? ?? 89 A0 ?? ?? ?? ?? 8B 6F 08 C7 47 04 ?? ?? ?? ?? 8B 44 24 08 E8 ?? ?? ?? ?? FF 63 04 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 88 ?? ?? ?? ?? 8B 11 89 90 ?? ?? ?? ?? 8B 41 08 E9 ?? ?? ?? ?? B8 01 00 00 00 C3 }
	condition:
		$1
}

rule function_480_0 {
	meta:
		name = "@HandleFinally"
		size = 166
		refs = "0019 @HandleFinally 0035 @GetTls 003b RaiseListPtr 0056 NotifyExceptFinally 0081 @HandleFinallyInternal 009c TObject.Free"
	strings:
		$1 = { 8B 44 24 04 F7 40 04 06 00 00 00 0F 84 8F 00 00 00 53 31 DB 56 57 55 55 68 ?? ?? ?? ?? 64 FF 33 64 89 23 64 8B 1B 8B 50 18 8B 48 14 53 50 52 51 8B 7C 24 34 E8 ?? ?? ?? ?? FF B0 ?? ?? ?? ?? 89 A0 ?? ?? ?? ?? 8B 4F 04 8B 6F 08 C7 47 04 ?? ?? ?? ?? 83 C1 05 E8 ?? ?? ?? ?? FF D1 E8 ?? ?? ?? ?? 8B 88 ?? ?? ?? ?? 8B 11 89 90 ?? ?? ?? ?? 83 C4 14 31 C0 5A 59 59 64 89 10 5D 5F 5E 5B EB 20 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 88 ?? ?? ?? ?? 8B 11 89 90 ?? ?? ?? ?? 8B 41 08 E9 ?? ?? ?? ?? B8 01 00 00 00 C3 }
	condition:
		$1
}

rule function_481_0 {
	meta:
		name = "@HandleFinallyInternal"
		size = 54
		refs = "0017 @HandleFinallyInternal 0026 NotifyExceptFinally"
	strings:
		$1 = { 8B 44 24 04 8B 54 24 08 F7 40 04 06 00 00 00 74 1F 8B 4A 04 C7 42 04 ?? ?? ?? ?? 53 56 57 55 8B 6A 08 83 C1 05 E8 ?? ?? ?? ?? FF D1 5D 5F 5E 5B B8 01 00 00 00 C3 }
	condition:
		$1
}

rule function_482_0 {
	meta:
		name = "@HandleAutoException"
		size = 194
		refs = "0019 @FpuInit 0021 JITEnable 002a DebugHook 0037 UnhandledExceptionFilter 0067 @HandleAutoException 006e RTLUnwindProc 00a6 TObject.Free"
	strings:
		$1 = { 8B 44 24 04 F7 40 04 06 00 00 00 0F 85 AB 00 00 00 81 38 DE FA ED 0E FC E8 ?? ?? ?? ?? 74 27 80 3D ?? ?? ?? ?? 00 76 1E 80 3D ?? ?? ?? ?? 00 77 15 8D 44 24 04 50 E8 ?? ?? ?? ?? 83 F8 00 74 7C 8B 44 24 04 EB 12 80 3D ?? ?? ?? ?? 01 76 09 80 3D ?? ?? ?? ?? 00 76 D9 83 48 04 02 56 57 55 8B 54 24 14 6A 00 50 68 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 5D 5F 5E 8B 44 24 04 BB FF FF 00 80 81 38 DE FA ED 0E 75 24 8B 50 18 8B 48 14 8B 44 24 08 8B 40 0C 85 C0 74 07 8B 18 FF 53 E0 89 C3 8B 44 24 04 8B 40 18 E8 ?? ?? ?? ?? 31 C0 8B 64 24 08 59 64 89 08 5A 5D 8D 52 05 59 FF E2 B8 01 00 00 00 C3 }
	condition:
		$1
}

rule function_483_0 {
	meta:
		name = "@RaiseExcept"
		size = 40
		refs = "000a @RunError 0023 RaiseExceptionProc"
	strings:
		$1 = { 09 C0 75 0A B8 D8 00 00 00 E8 ?? ?? ?? ?? 5A 54 55 57 56 53 50 52 54 6A 07 6A 01 68 DE FA ED 0E 52 FF 25 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_484_0 {
	meta:
		name = "@RaiseAgain"
		size = 81
		refs = "0007 @RaiseAgain 000c @GetTls 0012 RaiseListPtr 0031 TObject.Free 0036 NotifyReRaise"
	strings:
		$1 = { 8B 44 24 30 C7 40 04 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 90 ?? ?? ?? ?? 8B 0A 89 88 ?? ?? ?? ?? 8B 42 0C 83 60 04 FD 81 38 DE FA ED 0E 74 0D 8B 42 08 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 31 C0 83 C4 14 64 8B 10 59 8B 12 89 11 5D 5F 5E 5B B8 01 00 00 00 C3 }
	condition:
		$1
}

rule function_485_0 {
	meta:
		name = "@DoneExcept"
		size = 48
		refs = "0001 @GetTls 0007 RaiseListPtr 0017 TObject.Free 0029 NotifyTerminate"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B 90 ?? ?? ?? ?? 8B 0A 89 88 ?? ?? ?? ?? 8B 42 08 E8 ?? ?? ?? ?? 5A 8B 64 24 2C 31 C0 59 64 89 08 58 5D E8 ?? ?? ?? ?? FF E2 C3 }
	condition:
		$1
}

rule function_486_0 {
	meta:
		name = "@TryFinallyExit"
		size = 22
	strings:
		$1 = { 31 D2 8B 4C 24 08 8B 44 24 04 83 C1 05 64 89 02 FF D1 C2 0C 00 C3 }
	condition:
		$1
}

rule function_487_0 {
	meta:
		name = "MapToRunError"
		size = 158
		refs = "0096 RunErrorAt"
	strings:
		$1 = { 55 8B EC 8B 55 08 8B 02 3D 92 00 00 C0 7F 2C 74 5C 3D 8E 00 00 C0 7F 15 74 57 2D 05 00 00 C0 74 5C 2D 87 00 00 00 74 3D 48 74 4E EB 60 05 71 FF FF 3F 83 E8 02 72 36 74 30 EB 52 3D 96 00 00 C0 7F 11 74 3D 2D 93 00 00 C0 74 2E 48 74 13 48 74 24 EB 3A 2D FD 00 00 C0 74 2F 83 E8 3D 74 26 EB 2C B0 C8 EB 2A B0 C9 EB 26 B0 CD EB 22 B0 CF EB 1E B0 C8 EB 1A B0 D7 EB 16 B0 CE EB 12 B0 D8 EB 0E B0 DA EB 0A B0 D9 EB 06 B0 CA EB 02 B0 FF 0F B6 C0 8B 52 0C E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule function_488_0 {
	meta:
		name = "@ExceptionHandler"
		size = 157
		refs = "0013 DebugHook 0020 UnhandledExceptionFilter 002f @FpuInit 003b @ExceptionHandler 0042 RTLUnwindProc 005a ExceptObjProc 0062 MapToRunError 0076 NotifyUnhandled 007c ExceptProc 0096 @RunError"
	strings:
		$1 = { 8B 44 24 04 F7 40 04 06 00 00 00 0F 85 89 00 00 00 80 3D ?? ?? ?? ?? 00 77 0F 8D 44 24 04 50 E8 ?? ?? ?? ?? 83 F8 00 74 71 8B 44 24 04 FC E8 ?? ?? ?? ?? 8B 54 24 08 6A 00 50 68 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 8B 5C 24 04 81 3B DE FA ED 0E 8B 53 14 8B 43 18 74 1D 8B 15 ?? ?? ?? ?? 85 D2 0F 84 ?? ?? ?? ?? 89 D8 FF D2 85 C0 0F 84 ?? ?? ?? ?? 8B 53 0C E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 85 C9 74 02 FF D1 8B 4C 24 04 B8 D9 00 00 00 8B 51 14 89 14 24 E9 ?? ?? ?? ?? 31 C0 C3 }
	condition:
		$1
}

rule function_489_0 {
	meta:
		name = "SetExceptionHandler"
		size = 29
		refs = "0010 @ExceptionHandler 0018 InitContext"
	strings:
		$1 = { 31 D2 8D 45 F4 64 8B 0A 64 89 02 89 08 C7 40 04 ?? ?? ?? ?? 89 68 08 A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_490_0 {
	meta:
		name = "UnsetExceptionHandler"
		size = 40
		refs = "0003 InitContext"
	strings:
		$1 = { 31 D2 A1 ?? ?? ?? ?? 85 C0 74 1C 64 8B 0A 39 C8 75 08 8B 00 64 89 02 C3 8B 09 83 F9 FF 74 08 39 01 75 F5 8B 00 89 01 C3 }
	condition:
		$1
}

rule function_491_0 {
	meta:
		name = "FinalizeUnits"
		size = 98
		refs = "0007 InitContext 001c FinalizeUnits 004a @HandleAnyException 0054 @RaiseAgain 0059 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 A1 ?? ?? ?? ?? 85 C0 74 4E 8B 1D ?? ?? ?? ?? 8B 78 04 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 DB 7E 15 4B 89 1D ?? ?? ?? ?? 8B 74 DF 04 85 F6 74 02 FF D6 85 DB 7F EB 33 C0 5A 59 59 64 89 10 EB 14 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_492_0 {
	meta:
		name = "InitUnits"
		size = 103
		refs = "0008 InitContext 001e InitUnits 004e @HandleAnyException 0053 FinalizeUnits 0058 @RaiseAgain 005d @DoneExcept"
	strings:
		$1 = { 55 8B EC 51 53 56 57 A1 ?? ?? ?? ?? 85 C0 74 51 8B 38 33 DB 8B 40 04 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 3B FB 7E 17 8B 45 FC 8B 34 D8 43 89 1D ?? ?? ?? ?? 85 F6 74 02 FF D6 3B FB 7F E9 33 C0 5A 59 59 64 89 10 EB 14 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_493_0 {
	meta:
		name = "@PackageLoad"
		size = 117
		refs = "0009 InitContext 003c @PackageLoad 0047 InitUnits 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D4 56 57 BE ?? ?? ?? ?? 8D 7D D4 B9 0B 00 00 00 F3 A5 C6 05 ?? ?? ?? ?? 00 A3 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 8D 45 D4 A3 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 75 D4 BF ?? ?? ?? ?? B9 0B 00 00 00 F3 A5 C3 E9 ?? ?? ?? ?? EB E9 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule function_494_0 {
	meta:
		name = "@PackageUnload"
		size = 117
		refs = "0009 InitContext 003c @PackageUnload 0047 FinalizeUnits 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D4 56 57 BE ?? ?? ?? ?? 8D 7D D4 B9 0B 00 00 00 F3 A5 C6 05 ?? ?? ?? ?? 00 A3 ?? ?? ?? ?? 8B 00 A3 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 8D 45 D4 A3 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 75 D4 BF ?? ?? ?? ?? B9 0B 00 00 00 F3 A5 C3 E9 ?? ?? ?? ?? EB E9 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule function_495_0 {
	meta:
		name = "@StartExe"
		size = 64
		refs = "0002 RaiseExceptionProc 0006 RaiseException 000c RTLUnwindProc 0010 RtlUnwind 0015 InitContext 002a MainInstance 002f SetExceptionHandler 0035 IsLibrary 003b InitUnits"
	strings:
		$1 = { C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? A3 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 8B 42 04 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_496_0 {
	meta:
		name = "@StartLib"
		size = 200
		refs = "0004 InitContext 004f RaiseException 0054 RaiseExceptionProc 0059 RtlUnwind 005e RTLUnwindProc 0063 SetExceptionHandler 00a1 MainInstance 00aa IsLibrary 00b1 Default8087CW 00bb @Halt0 00c0 InitUnits"
	strings:
		$1 = { 51 56 57 BE ?? ?? ?? ?? 8D 7D C4 B9 0B 00 00 00 F3 A5 8F 05 ?? ?? ?? ?? 8F 05 ?? ?? ?? ?? 89 2D ?? ?? ?? ?? 89 1D ?? ?? ?? ?? A3 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 8D 4D C4 89 0D ?? ?? ?? ?? 31 C9 83 7D 0C 00 75 02 8B 08 89 0D ?? ?? ?? ?? B8 ?? ?? ?? ?? A3 ?? ?? ?? ?? B8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 0C 40 A2 ?? ?? ?? ?? 48 59 8B 11 89 15 ?? ?? ?? ?? 74 07 3C 03 7D 03 FF 14 81 51 8B 4C 24 08 85 C9 74 08 8B 45 0C 8B 55 10 FF D1 59 8B 45 0C 3C 03 7C 03 FF 14 81 83 3D ?? ?? ?? ?? 00 75 0D C6 05 ?? ?? ?? ?? 01 D9 3D ?? ?? ?? ?? 8B 45 0C 48 0F 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? C2 04 00 C3 }
	condition:
		$1
}

rule function_497_0 {
	meta:
		name = "@InitResStrings"
		size = 36
		refs = "0016 LoadResString"
	strings:
		$1 = { 53 31 DB 57 56 8B 3C 18 8D 74 18 04 8B 46 04 8B 16 01 D8 01 DA E8 ?? ?? ?? ?? 83 C6 08 4F 75 EC 5E 5F 5B C3 }
	condition:
		$1
}

rule function_498_0 {
	meta:
		name = "@InitResStringImports"
		size = 37
		refs = "0017 LoadResString"
	strings:
		$1 = { 53 31 DB 57 56 8B 3C 18 8D 74 18 04 8B 46 04 8B 16 8B 04 18 01 DA E8 ?? ?? ?? ?? 83 C6 08 4F 75 EB 5E 5F 5B C3 }
	condition:
		$1
}

rule function_499_0 {
	meta:
		name = "@InitImports"
		size = 36
	strings:
		$1 = { 53 31 DB 57 56 8B 3C 18 8D 74 18 04 8B 46 04 8B 16 8B 04 18 03 46 08 89 04 1A 83 C6 0C 4F 75 EC 5E 5F 5B C3 }
	condition:
		$1
}

rule function_500_0 {
	meta:
		name = "@InitWideStrings"
		size = 26
		refs = "000d @WStrAsg"
	strings:
		$1 = { 53 56 8B 18 8D 70 04 8B 56 04 8B 06 E8 ?? ?? ?? ?? 83 C6 08 4B 75 F0 5E 5B C3 }
	condition:
		$1
}

rule function_501_0 {
	meta:
		name = "MakeErrorMessage"
		size = 100
		refs = "0004 runErrMsg 000c ExitCode 0038 ErrorAddr 0044 dig"
	strings:
		$1 = { 53 56 57 BF ?? ?? ?? ?? B3 10 8B 35 ?? ?? ?? ?? 8B C6 B9 0A 00 00 00 99 F7 F9 80 C2 30 0F B6 C3 88 14 07 B9 0A 00 00 00 8B C6 99 F7 F9 89 C6 4B 85 F6 75 DC B3 1C 8B 35 ?? ?? ?? ?? 8B C6 83 E0 0F 0F B6 80 ?? ?? ?? ?? 0F B6 D3 88 04 17 B9 10 00 00 00 8B C6 33 D2 F7 F1 89 C6 4B 85 F6 75 DC 5F 5E 5B C3 }
	condition:
		$1
}

rule function_502_0 {
	meta:
		name = "ExitDll"
		size = 46
		refs = "0004 ExitCode 000e InitContext"
	strings:
		$1 = { 31 C0 87 05 ?? ?? ?? ?? F7 D8 19 C0 40 BF ?? ?? ?? ?? 8B 5F 18 8B 6F 14 FF 77 1C FF 77 20 8B 37 B9 0B 00 00 00 F3 A5 5F 5E C9 C2 0C 00 C3 }
	condition:
		$1
}

rule function_503_0 {
	meta:
		name = "WriteErrorMessage"
		size = 140
		refs = "0003 IsConsole 000d Output 0033 runErrMsg 003a GetStdHandle 0040 WriteFile 004e WriteErrorMessage 0063 NoErrMsg 006d errCaption 0079 MessageBox"
	strings:
		$1 = { 51 80 3D ?? ?? ?? ?? 00 74 57 66 81 3D ?? ?? ?? ?? B2 D7 75 14 83 3D ?? ?? ?? ?? 00 76 0B B8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 6A 00 8D 44 24 04 50 6A 1E 68 ?? ?? ?? ?? 6A F5 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 6A 00 8D 44 24 04 50 6A 02 68 ?? ?? ?? ?? 6A F5 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5A C3 80 3D ?? ?? ?? ?? 00 75 13 6A 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? 5A C3 00 FF FF FF FF 02 00 00 00 0D 0A 00 00 }
	condition:
		$1
}

rule function_504_0 {
	meta:
		name = "@Halt0"
		size = 220
		refs = "0005 InitContext 000a ExitProc 002a ErrorAddr 0032 MakeErrorMessage 0037 WriteErrorMessage 004a ExitCode 0057 FinalizeUnits 0074 UnregisterModule 0089 FreeLibrary 008e UnsetExceptionHandler 00a2 ExitDll 00ad ExitProcessProc 00c1 ExitProcess"
	strings:
		$1 = { 53 56 57 55 BB ?? ?? ?? ?? BF ?? ?? ?? ?? 80 7B 28 00 75 14 83 3F 00 74 0F 8B 07 89 C6 33 C0 89 07 FF D6 83 3F 00 75 F1 83 3D ?? ?? ?? ?? 00 74 11 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 80 7B 28 02 75 0E 83 3D ?? ?? ?? ?? 00 75 05 33 C0 89 43 0C E8 ?? ?? ?? ?? 80 7B 28 01 76 09 83 3D ?? ?? ?? ?? 00 74 23 8B 7B 10 85 FF 74 1C 8B C7 E8 ?? ?? ?? ?? 8B 6B 10 8B 75 10 3B 75 04 74 0A 85 F6 74 06 56 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 7B 28 01 75 03 FF 53 24 80 7B 28 00 74 05 E8 ?? ?? ?? ?? 83 3B 00 75 1A 83 3D ?? ?? ?? ?? 00 74 06 FF 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 03 8B F0 8B FB B9 0B 00 00 00 F3 A5 E9 6B FF FF FF 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_506_0 {
	meta:
		name = "@Run0Error"
		size = 8
		refs = "0003 @RunError"
	strings:
		$1 = { 31 C0 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_507_0 {
	meta:
		name = "@RunError"
		size = 12
		refs = "0002 ErrorAddr 0007 @Halt"
	strings:
		$1 = { 8F 05 ?? ?? ?? ?? E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_508_0 {
	meta:
		name = "@UnhandledException"
		size = 46
		refs = "0002 ExceptProc 000a ExceptAddr 0010 ExceptObject 0029 RunErrorAt"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 13 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5A FF 15 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 8B D0 B8 E6 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_509_0 {
	meta:
		name = "@Assert"
		size = 31
		refs = "0003 AssertErrorProc 000d Error"
	strings:
		$1 = { 53 83 3D ?? ?? ?? ?? 00 75 09 B0 15 E8 ?? ?? ?? ?? 5B C3 FF 74 24 04 FF 15 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_510_0 {
	meta:
		name = "ThreadWrapper"
		size = 54
		refs = "0004 @FpuInit 000c @ExceptionHandler 0022 @FreeMem"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 55 31 C9 68 ?? ?? ?? ?? 64 8B 11 52 64 89 21 8B 45 08 8B 48 04 8B 10 51 52 E8 ?? ?? ?? ?? 5A 58 FF D2 31 D2 59 64 89 0A 59 5D 5D C2 04 00 }
	condition:
		$1
}

rule function_511_0 {
	meta:
		name = "BeginThread"
		size = 93
		refs = "0013 SystemThreadFuncProc 002c @GetMem 0037 IsMultiThread 0046 ThreadWrapper 0051 CreateThread"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B D9 89 55 FC 8B F8 8B 75 10 83 3D ?? ?? ?? ?? 00 74 0C 8B D6 8B C3 FF 15 ?? ?? ?? ?? EB 0F B8 08 00 00 00 E8 ?? ?? ?? ?? 89 18 89 70 04 C6 05 ?? ?? ?? ?? 01 8B 55 08 52 8B 55 0C 52 50 B8 ?? ?? ?? ?? 50 8B 45 FC 50 57 E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_512_0 {
	meta:
		name = "EndThread"
		size = 28
		refs = "0005 SystemThreadEndProc 0016 ExitThread"
	strings:
		$1 = { 53 8B D8 83 3D ?? ?? ?? ?? 00 74 08 8B C3 FF 15 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_513_0 {
	meta:
		name = "@LStrClr"
		size = 35
		refs = "001d @FreeMem"
	strings:
		$1 = { 8B 10 85 D2 74 1C C7 00 00 00 00 00 8B 4A F8 49 7C 10 F0 FF 4A F8 75 0A 50 8D 42 F8 E8 ?? ?? ?? ?? 58 C3 }
	condition:
		$1
}

rule function_514_0 {
	meta:
		name = "@LStrArrayClr"
		size = 47
		refs = "0022 @FreeMem"
	strings:
		$1 = { 53 56 89 C3 89 D6 8B 13 85 D2 74 1A C7 03 00 00 00 00 8B 4A F8 49 7C 0E F0 FF 4A F8 75 08 8D 42 F8 E8 ?? ?? ?? ?? 83 C3 04 4E 75 DA 5E 5B C3 }
	condition:
		$1
}

rule function_515_0 {
	meta:
		name = "@LStrAsg"
		size = 67
		refs = "0010 @NewAnsiString 001c Move 003e @FreeMem"
	strings:
		$1 = { 85 D2 74 24 8B 4A F8 41 7F 1A 50 52 8B 42 FC E8 ?? ?? ?? ?? 89 C2 58 52 8B 48 FC E8 ?? ?? ?? ?? 5A 58 EB 04 F0 FF 42 F8 87 10 85 D2 74 14 8B 4A F8 49 7C 0E F0 FF 4A F8 75 08 8D 42 F8 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_516_0 {
	meta:
		name = "@LStrLAsg"
		size = 41
		refs = "0024 @FreeMem"
	strings:
		$1 = { 85 D2 74 0A 8B 4A F8 41 7E 04 F0 FF 42 F8 87 10 85 D2 74 14 8B 4A F8 49 7C 0E F0 FF 4A F8 75 08 8D 42 F8 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_517_0 {
	meta:
		name = "@NewAnsiString"
		size = 43
		refs = "000d @GetMem"
	strings:
		$1 = { 85 C0 7E 24 50 83 C0 0A 83 E0 FE 50 E8 ?? ?? ?? ?? 5A 66 C7 44 02 FE 00 00 83 C0 08 5A 89 50 FC C7 40 F8 01 00 00 00 C3 31 C0 C3 }
	condition:
		$1
}

rule function_518_0 {
	meta:
		name = "@LStrFromPCharLen"
		size = 46
		refs = "000c @NewAnsiString 001d Move 0024 @LStrClr"
	strings:
		$1 = { 53 56 57 89 C3 89 D6 89 CF 89 F8 E8 ?? ?? ?? ?? 89 F9 89 C7 85 F6 74 09 89 C2 89 F0 E8 ?? ?? ?? ?? 89 D8 E8 ?? ?? ?? ?? 89 3B 5F 5E 5B C3 }
	condition:
		$1
}

rule function_519_0 {
	meta:
		name = "CharFromWChar"
		size = 31
		refs = "0011 DefaultSystemCodePage 0017 WideCharToMultiByte"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 52 50 8B 45 08 50 51 6A 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule function_520_0 {
	meta:
		name = "WCharFromChar"
		size = 27
		refs = "000d DefaultSystemCodePage 0013 MultiByteToWideChar"
	strings:
		$1 = { 55 8B EC 52 50 8B 45 08 50 51 6A 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule function_521_0 {
	meta:
		name = "@LStrFromPWCharLen"
		size = 140
		refs = "001c @LStrClr 003c CharFromWChar 004f @LStrFromPCharLen 005e @LStrSetLength"
	strings:
		$1 = { 53 56 57 55 81 C4 04 F0 FF FF 50 83 C4 FC 8B F1 89 14 24 8B F8 85 F6 7F 09 8B C7 E8 ?? ?? ?? ?? EB 5F 8D 6E 01 81 FD FF 07 00 00 7D 28 56 8D 44 24 08 8B 4C 24 04 BA FF 0F 00 00 E8 ?? ?? ?? ?? 8B D8 85 DB 7C 0F 8D 54 24 04 8B C7 8B CB E8 ?? ?? ?? ?? EB 2C 8B DD 03 DB 8B C7 8B D3 E8 ?? ?? ?? ?? 56 8B 07 8B 4C 24 04 8B D3 E8 ?? ?? ?? ?? 8B D8 85 DB 7D 02 33 DB 8B C7 8B D3 E8 ?? ?? ?? ?? 81 C4 04 10 00 00 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_522_0 {
	meta:
		name = "@LStrFromChar"
		size = 15
		refs = "0009 @LStrFromPCharLen"
	strings:
		$1 = { 52 89 E2 B9 01 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_523_0 {
	meta:
		name = "@LStrFromWChar"
		size = 15
		refs = "0009 @LStrFromPWCharLen"
	strings:
		$1 = { 52 89 E2 B9 01 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_570_0 {
	meta:
		name = "@WStrFromChar"
		size = 15
		refs = "0009 @WStrFromPCharLen"
	strings:
		$1 = { 52 89 E2 B9 01 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_571_0 {
	meta:
		name = "@WStrFromWChar"
		size = 15
		refs = "0009 @WStrFromPWCharLen"
	strings:
		$1 = { 52 89 E2 B9 01 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_524_0 {
	meta:
		name = "@LStrFromPChar"
		size = 45
		refs = "0028 @LStrFromPCharLen"
	strings:
		$1 = { 31 C9 85 D2 74 21 52 3A 0A 74 17 3A 4A 01 74 11 3A 4A 02 74 0B 3A 4A 03 74 05 83 C2 04 EB E8 42 42 42 89 D1 5A 29 D1 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_572_0 {
	meta:
		name = "@WStrFromPChar"
		size = 45
		refs = "0028 @WStrFromPCharLen"
	strings:
		$1 = { 31 C9 85 D2 74 21 52 3A 0A 74 17 3A 4A 01 74 11 3A 4A 02 74 0B 3A 4A 03 74 05 83 C2 04 EB E8 42 42 42 89 D1 5A 29 D1 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_525_0 {
	meta:
		name = "@LStrFromPWChar"
		size = 57
		refs = "0034 @LStrFromPWCharLen"
	strings:
		$1 = { 31 C9 85 D2 74 2D 52 66 3B 0A 74 20 66 3B 4A 02 74 17 66 3B 4A 04 74 0E 66 3B 4A 06 74 05 83 C2 08 EB E4 83 C2 02 83 C2 02 83 C2 02 89 D1 5A 29 D1 D1 E9 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_573_0 {
	meta:
		name = "@WStrFromPWChar"
		size = 57
		refs = "0034 @WStrFromPWCharLen"
	strings:
		$1 = { 31 C9 85 D2 74 2D 52 66 3B 0A 74 20 66 3B 4A 02 74 17 66 3B 4A 04 74 0E 66 3B 4A 06 74 05 83 C2 08 EB E4 83 C2 02 83 C2 02 83 C2 02 89 D1 5A 29 D1 D1 E9 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_526_0 {
	meta:
		name = "@LStrFromString"
		size = 11
		refs = "0006 @LStrFromPCharLen"
	strings:
		$1 = { 31 C9 8A 0A 42 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_574_0 {
	meta:
		name = "@WStrFromString"
		size = 11
		refs = "0006 @WStrFromPCharLen"
	strings:
		$1 = { 31 C9 8A 0A 42 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_527_0 {
	meta:
		name = "@LStrFromArray"
		size = 24
		refs = "0013 @LStrFromPCharLen"
	strings:
		$1 = { 57 50 51 89 D7 31 C0 F2 AE 75 02 F7 D1 58 01 C1 58 5F E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_575_0 {
	meta:
		name = "@WStrFromArray"
		size = 24
		refs = "0013 @WStrFromPCharLen"
	strings:
		$1 = { 57 50 51 89 D7 31 C0 F2 AE 75 02 F7 D1 58 01 C1 58 5F E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_528_0 {
	meta:
		name = "@LStrFromWArray"
		size = 25
		refs = "0014 @LStrFromPWCharLen"
	strings:
		$1 = { 57 50 51 89 D7 31 C0 F2 66 AF 75 02 F7 D1 58 01 C1 58 5F E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_576_0 {
	meta:
		name = "@WStrFromWArray"
		size = 25
		refs = "0014 @WStrFromPWCharLen"
	strings:
		$1 = { 57 50 51 89 D7 31 C0 F2 66 AF 75 02 F7 D1 58 01 C1 58 5F E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_529_0 {
	meta:
		name = "@LStrFromWStr"
		size = 17
		refs = "000c @LStrFromPWCharLen"
	strings:
		$1 = { 31 C9 85 D2 74 05 8B 4A FC D1 E9 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_530_0 {
	meta:
		name = "@LStrToString"
		size = 34
		refs = "0017 Move"
	strings:
		$1 = { 53 85 D2 74 18 8B 5A FC 85 DB 74 11 39 D9 7C 02 89 D9 88 08 40 92 E8 ?? ?? ?? ?? 5B C3 C6 00 00 5B C3 }
	condition:
		$1
}

rule function_531_0 {
	meta:
		name = "@LStrLen"
		size = 10
	strings:
		$1 = { 85 C0 74 05 83 E8 04 8B 00 C3 }
	condition:
		$1
}

rule function_532_0 {
	meta:
		name = "@LStrCat"
		size = 68
		refs = "000a @LStrAsg 0022 @LStrSetLength 0030 Move"
	strings:
		$1 = { 85 D2 74 3F 8B 08 85 C9 0F 84 ?? ?? ?? ?? 53 56 57 89 C3 89 D6 8B 79 FC 8B 56 FC 01 FA 39 CE 74 17 E8 ?? ?? ?? ?? 89 F0 8B 4E FC 8B 13 01 FA E8 ?? ?? ?? ?? 5F 5E 5B C3 E8 ?? ?? ?? ?? 8B 03 89 F9 EB E8 C3 }
	condition:
		$1
}

rule function_533_0 {
	meta:
		name = "@LStrCat3"
		size = 116
		refs = "0008 @LStrAsg 001e @LStrCat 0031 @NewAnsiString 003f Move"
	strings:
		$1 = { 85 D2 74 61 85 C9 0F 84 ?? ?? ?? ?? 3B 10 74 5C 3B 08 74 0E 50 51 E8 ?? ?? ?? ?? 5A 58 E9 ?? ?? ?? ?? 53 56 57 89 D3 89 CE 50 8B 43 FC 03 46 FC E8 ?? ?? ?? ?? 89 C7 89 C2 89 D8 8B 4B FC E8 ?? ?? ?? ?? 89 FA 89 F0 8B 4E FC 03 53 FC E8 ?? ?? ?? ?? 58 89 FA 85 FF 74 03 FF 4F F8 E8 ?? ?? ?? ?? 5F 5E 5B C3 89 CA E9 ?? ?? ?? ?? 89 CA E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_534_0 {
	meta:
		name = "@LStrCatN"
		size = 138
		refs = "0040 @LStrSetLength 004f @NewAnsiString 0066 Move 007b @LStrAsg"
	strings:
		$1 = { 53 56 57 52 50 89 D3 31 FF 8B 4C 94 14 85 C9 74 0C 39 08 75 08 89 CF 8B 41 FC 4A EB 02 31 C0 8B 4C 94 14 85 C9 74 09 03 41 FC 39 CF 75 02 31 FF 4A 75 EC 85 FF 74 17 89 C2 8B 04 24 8B 77 FC E8 ?? ?? ?? ?? 8B 3C 24 FF 37 03 37 4B EB 08 E8 ?? ?? ?? ?? 50 89 C6 8B 44 9C 18 89 F2 85 C0 74 0A 8B 48 FC 01 CE E8 ?? ?? ?? ?? 4B 75 E9 5A 58 85 FF 75 0C 85 D2 74 03 FF 4A F8 E8 ?? ?? ?? ?? 5A 5F 5E 5B 58 8D 24 94 FF E0 C3 }
	condition:
		$1
}

rule function_535_0 {
	meta:
		name = "@LStrCmp"
		size = 162
	strings:
		$1 = { 53 56 57 89 C6 89 D7 39 D0 0F 84 8F 00 00 00 85 F6 74 68 85 FF 74 6B 8B 46 FC 8B 57 FC 29 D0 77 02 01 C2 52 C1 EA 02 74 26 8B 0E 8B 1F 39 D9 75 58 4A 74 15 8B 4E 04 8B 5F 04 39 D9 75 4B 83 C6 08 83 C7 08 4A 75 E2 EB 06 83 C6 04 83 C7 04 5A 83 E2 03 74 22 8B 0E 8B 1F 38 D9 75 41 4A 74 17 38 FD 75 3A 4A 74 10 81 E3 00 00 FF 00 81 E1 00 00 FF 00 39 D9 75 27 01 C0 EB 23 8B 57 FC 29 D0 EB 1C 8B 46 FC 29 D0 EB 15 5A 38 D9 75 10 38 FD 75 0C C1 E9 10 C1 EB 10 38 D9 75 02 38 FD 5F 5E 5B C3 }
	condition:
		$1
}

rule function_536_0 {
	meta:
		name = "@LStrAddRef"
		size = 15
	strings:
		$1 = { 85 C0 74 0A 8B 50 F8 42 7E 04 F0 FF 40 F8 C3 }
	condition:
		$1
}

rule function_538_0 {
	meta:
		name = "@LStrToPChar"
		size = 12
		refs = "0007 @LStrToPChar"
	strings:
		$1 = { 85 C0 74 02 C3 00 B8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_539_0 {
	meta:
		name = "InternalUniqueString"
		size = 65
		refs = "0013 @NewAnsiString 0022 Move 0037 @FreeMem"
	strings:
		$1 = { 8B 10 85 D2 74 38 8B 4A F8 49 74 32 53 89 C3 8B 42 FC E8 ?? ?? ?? ?? 89 C2 8B 03 89 13 50 8B 48 FC E8 ?? ?? ?? ?? 58 8B 48 F8 49 7C 0E F0 FF 48 F8 75 08 8D 40 F8 E8 ?? ?? ?? ?? 8B 13 5B 89 D0 C3 }
	condition:
		$1
}

rule function_544_0 {
	meta:
		name = "@LStrCopy"
		size = 64
		refs = "0024 @LStrFromPCharLen 0037 @LStrClr"
	strings:
		$1 = { 53 85 C0 74 2D 8B 58 FC 85 DB 74 26 4A 7C 1B 39 DA 7D 1F 29 D3 85 C9 7C 19 39 D9 7F 11 01 C2 8B 44 24 08 E8 ?? ?? ?? ?? EB 11 31 D2 EB E5 89 D9 EB EB 8B 44 24 08 E8 ?? ?? ?? ?? 5B C2 04 00 C3 }
	condition:
		$1
}

rule function_545_0 {
	meta:
		name = "@LStrDelete"
		size = 72
		refs = "000a UniqueString 0032 Move 0040 @LStrSetLength"
	strings:
		$1 = { 53 56 57 89 C3 89 D6 89 CF E8 ?? ?? ?? ?? 8B 13 85 D2 74 30 8B 4A FC 4E 7C 2A 39 CE 7D 26 85 FF 7E 22 29 F1 39 CF 7E 02 89 CF 29 F9 01 F2 8D 04 17 E8 ?? ?? ?? ?? 8B 13 89 D8 8B 52 FC 29 FA E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_546_0 {
	meta:
		name = "@LStrInsert"
		size = 91
		refs = "002b @LStrSetLength 0045 Move"
	strings:
		$1 = { 85 C0 74 56 53 56 57 55 89 C3 89 D6 89 CF 8B 12 52 85 D2 74 03 8B 52 FC 4F 7D 02 31 FF 39 D7 7E 02 89 D7 8B 6B FC 89 F0 01 EA E8 ?? ?? ?? ?? 58 39 D8 75 02 8B 1E 8B 06 8D 14 2F 8B 48 FC 29 D1 01 C2 01 F8 E8 ?? ?? ?? ?? 89 D8 8B 16 89 E9 01 FA E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_547_0 {
	meta:
		name = "@LStrPos"
		size = 69
	strings:
		$1 = { 85 C0 74 40 85 D2 74 31 53 56 57 89 C6 89 D7 8B 4F FC 57 8B 56 FC 4A 78 1B 8A 06 46 29 D1 7E 14 F2 AE 75 10 89 CB 56 57 89 D1 F3 A6 5F 5E 74 0C 89 D9 EB EC 5A 31 C0 EB 08 31 C0 C3 5A 89 F8 29 D0 5F 5E 5B C3 }
	condition:
		$1
}

rule function_548_0 {
	meta:
		name = "Pos"
		size = 323
	strings:
		$1 = { 53 56 83 C4 F0 85 D2 74 4E 85 C0 74 4A 8B 72 FC 8B 58 FC 39 DE 7C 40 85 DB 7E 3C 4B 01 D6 01 DA 89 74 24 08 01 D8 89 54 24 04 F7 DB 0F B6 08 89 1C 24 0F 85 99 00 00 00 83 EE 02 89 74 24 0C 3A 0A 74 41 3A 4A 01 74 4C 83 C2 02 3B 54 24 0C 72 0A 3B 54 24 08 72 E8 31 C0 EB 30 3A 0A 74 25 3A 4A 01 74 30 3A 4A 02 74 18 3A 4A 03 74 23 83 C2 04 3B 54 24 0C 72 E4 3B 54 24 08 72 C2 31 C0 EB 0A 83 C2 02 42 89 D0 2B 44 24 04 83 C4 10 5E 5B C3 83 C2 02 83 C2 02 31 C0 3B 54 24 08 77 06 89 D0 2B 44 24 04 83 C4 10 5E 5B C3 3A 0A 74 75 3A 4A 01 74 43 3A 4A 02 74 68 3A 4A 03 74 36 83 C2 04 3B 54 24 0C 72 E4 3B 54 24 08 72 0B 31 C0 EB 4A 83 EE 02 89 74 24 0C 3A 0A 74 48 3A 4A 01 74 16 83 C2 02 3B 54 24 0C 72 C1 3B 54 24 08 72 E8 31 C0 EB 27 83 C2 02 8B 34 24 0F B7 1C 30 66 3B 5C 32 01 75 DC 83 C6 02 7C F0 83 C2 02 31 C0 3B 54 24 08 77 06 89 D0 2B 44 24 04 83 C4 10 5E 5B C3 83 C2 02 8B 34 24 0F B7 1C 30 66 3B 1C 32 75 AB 83 C6 02 7C F1 42 89 D0 2B 44 24 04 83 C4 10 5E 5B C3 }
	condition:
		$1
}

rule function_549_0 {
	meta:
		name = "@LStrSetLength"
		size = 98
		refs = "0023 @ReallocMem 0039 @NewAnsiString 0051 Move 0058 @LStrClr"
	strings:
		$1 = { 53 56 57 89 C3 89 D6 31 FF 85 D2 7E 48 8B 03 85 C0 74 23 83 78 F8 01 75 1D 83 E8 08 83 C2 09 50 89 E0 E8 ?? ?? ?? ?? 58 83 C0 08 89 03 89 70 FC C6 04 06 00 EB 28 89 D0 E8 ?? ?? ?? ?? 89 C7 8B 03 85 C0 74 10 89 FA 8B 48 FC 39 F1 7C 02 89 F1 E8 ?? ?? ?? ?? 89 D8 E8 ?? ?? ?? ?? 89 3B 5F 5E 5B C3 }
	condition:
		$1
}

rule function_550_0 {
	meta:
		name = "StringOfChar"
		size = 42
		refs = "000c @LStrClr 0017 @NewAnsiString 0022 @FillChar"
	strings:
		$1 = { 53 56 57 89 C3 89 D6 89 CF 89 C8 E8 ?? ?? ?? ?? 85 F6 7E 12 89 F0 E8 ?? ?? ?? ?? 89 07 89 F2 88 D9 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_552_0 {
	meta:
		name = "@WriteLString"
		size = 32
		refs = "0012 @WriteSpaces 001b @WriteBytes"
	strings:
		$1 = { 53 89 D3 89 CA 31 C9 85 DB 74 05 8B 4B FC 29 CA 51 E8 ?? ?? ?? ?? 59 89 DA 5B E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_554_0 {
	meta:
		name = "@WriteWString"
		size = 107
		refs = "0012 @WriteWString 001f @WStrLen 002a @WriteSpaces 0034 @LStrFromWStr 0040 @WriteLString 0057 @LStrClr 005d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 8B D7 2B D0 8B C3 E8 ?? ?? ?? ?? 8D 45 FC 8B D6 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 33 C9 E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_556_0 {
	meta:
		name = "@WriteWCString"
		size = 112
		refs = "000f @WriteWCString 0030 @WriteSpaces 003a @LStrFromPWChar 0046 @WriteLString 005d @LStrClr 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 85 DB 74 0A EB 01 40 66 83 3C 43 00 75 F8 8B D1 2B D0 8B C6 E8 ?? ?? ?? ?? 8D 45 FC 8B D3 E8 ?? ?? ?? ?? 8B 55 FC 8B C6 33 C9 E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_558_0 {
	meta:
		name = "@WriteWChar"
		size = 95
		refs = "000f @WriteWChar 001f @WriteSpaces 0029 @LStrFromWChar 0035 @WriteLString 004c @LStrClr 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D1 4A 8B C3 E8 ?? ?? ?? ?? 8D 45 FC 8B D6 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 33 C9 E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_559_0 {
	meta:
		name = "@WriteVariant"
		size = 100
		refs = "000f @WriteVariant 001b VarToLStrProc 0033 @WriteLString 003c Error 0051 @LStrClr 0057 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 3D ?? ?? ?? ?? 00 74 17 8D 45 FC FF 15 ?? ?? ?? ?? 8B C3 8B CE 8B 55 FC E8 ?? ?? ?? ?? EB 07 B0 10 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_561_0 {
	meta:
		name = "WStrError"
		size = 8
		refs = "0003 Error"
	strings:
		$1 = { B0 01 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_562_0 {
	meta:
		name = "@NewWideString"
		size = 21
		refs = "0008 SysAllocStringLen 0010 WStrError"
	strings:
		$1 = { 85 C0 74 10 50 6A 00 E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_563_0 {
	meta:
		name = "WStrSet"
		size = 13
		refs = "0008 SysFreeString"
	strings:
		$1 = { 87 10 85 D2 74 06 52 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_564_0 {
	meta:
		name = "@WStrClr"
		size = 21
		refs = "000f SysFreeString"
	strings:
		$1 = { 8B 10 85 D2 74 0E C7 00 00 00 00 00 50 52 E8 ?? ?? ?? ?? 58 C3 }
	condition:
		$1
}

rule function_565_0 {
	meta:
		name = "@WStrArrayClr"
		size = 33
		refs = "0014 SysFreeString"
	strings:
		$1 = { 53 56 89 C3 89 D6 8B 03 85 C0 74 0C C7 03 00 00 00 00 50 E8 ?? ?? ?? ?? 83 C3 04 4E 75 E8 5E 5B C3 }
	condition:
		$1
}

rule function_566_0 {
	meta:
		name = "@WStrAsg"
		size = 40
		refs = "0008 @WStrClr 001b SysReAllocStringLen 0023 WStrError"
	strings:
		$1 = { 39 10 74 23 85 D2 0F 84 ?? ?? ?? ?? 8B 4A FC D1 E9 0F 84 ?? ?? ?? ?? 51 52 50 E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_568_0 {
	meta:
		name = "@WStrFromPCharLen"
		size = 138
		refs = "001c @WStrClr 003c WCharFromChar 004f @WStrFromPWCharLen 005c @WStrSetLength"
	strings:
		$1 = { 53 56 57 55 81 C4 04 F0 FF FF 50 83 C4 FC 8B F1 89 14 24 8B F8 85 F6 7F 09 8B C7 E8 ?? ?? ?? ?? EB 5D 8D 6E 01 81 FD FF 07 00 00 7D 28 56 8D 44 24 08 8B 4C 24 04 BA FF 07 00 00 E8 ?? ?? ?? ?? 8B D8 85 DB 7E 0F 8D 54 24 04 8B C7 8B CB E8 ?? ?? ?? ?? EB 2A 8B DD 8B C7 8B D3 E8 ?? ?? ?? ?? 56 8B 07 8B 4C 24 04 8B D3 E8 ?? ?? ?? ?? 8B D8 85 DB 7D 02 33 DB 8B C7 8B D3 E8 ?? ?? ?? ?? 81 C4 04 10 00 00 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_569_0 {
	meta:
		name = "@WStrFromPWCharLen"
		size = 35
		refs = "0004 @WStrClr 000c SysAllocStringLen 0014 WStrError 001e SysFreeString"
	strings:
		$1 = { 85 C9 0F 84 ?? ?? ?? ?? 50 51 52 E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 5A FF 32 89 02 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_577_0 {
	meta:
		name = "@WStrFromLStr"
		size = 15
		refs = "000a @WStrFromPCharLen"
	strings:
		$1 = { 31 C9 85 D2 74 03 8B 4A FC E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_578_0 {
	meta:
		name = "@WStrToString"
		size = 107
		refs = "001f @WStrLen 003e CharFromWChar 005d Move"
	strings:
		$1 = { 53 56 57 81 C4 00 FE FF FF 8B D9 8B FA 8B F0 81 FB FF 00 00 00 7E 05 BB FF 00 00 00 8B C7 E8 ?? ?? ?? ?? 3B D8 7F 02 8B C3 85 C0 75 04 33 C0 EB 1F 50 8D 44 24 04 8B CF BA FF 01 00 00 E8 ?? ?? ?? ?? 85 C0 7D 04 33 C0 EB 06 3B D8 7D 02 8B C3 88 06 85 C0 7E 0B 8D 56 01 8B CC 91 E8 ?? ?? ?? ?? 81 C4 00 02 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_579_0 {
	meta:
		name = "@WStrToPWChar"
		size = 14
		refs = "0009 @WStrToPWChar"
	strings:
		$1 = { 85 C0 74 04 C3 90 00 00 B8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_580_0 {
	meta:
		name = "@WStrLen"
		size = 10
	strings:
		$1 = { 85 C0 74 05 8B 40 FC D1 E8 C3 }
	condition:
		$1
}

rule function_581_0 {
	meta:
		name = "@WStrCat"
		size = 95
		refs = "000d @WStrLen 0027 @NewWideString 003d Move 0055 WStrSet"
	strings:
		$1 = { 53 56 57 55 51 8B EA 89 04 24 8B C5 E8 ?? ?? ?? ?? 8B D8 85 DB 74 42 8B 04 24 8B 00 E8 ?? ?? ?? ?? 8B F0 8D 04 33 E8 ?? ?? ?? ?? 8B F8 85 F6 7E 10 8B CE 03 C9 8B D7 8B 04 24 8B 00 E8 ?? ?? ?? ?? 8B CB 03 C9 8D 14 77 8B C5 E8 ?? ?? ?? ?? 8B 04 24 8B D7 E8 ?? ?? ?? ?? 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_582_0 {
	meta:
		name = "@WStrCat3"
		size = 110
		refs = "0013 @WStrLen 0030 @NewWideString 003f Move 0059 WStrSet 0063 @WStrClr"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 89 4C 24 04 8B EA 89 04 24 8B C5 E8 ?? ?? ?? ?? 8B D8 8B 44 24 04 E8 ?? ?? ?? ?? 8B F0 85 DB 75 04 85 F6 74 33 8D 04 1E E8 ?? ?? ?? ?? 8B F8 8B CB 03 C9 8B D7 8B C5 E8 ?? ?? ?? ?? 8B CE 03 C9 8D 14 5F 8B 44 24 04 E8 ?? ?? ?? ?? 8B 04 24 8B D7 E8 ?? ?? ?? ?? EB 08 8B 04 24 E8 ?? ?? ?? ?? 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_583_0 {
	meta:
		name = "@WStrCatN"
		size = 72
		refs = "0019 @NewWideString 0030 Move 003a WStrSet"
	strings:
		$1 = { 53 56 52 50 89 D3 31 C0 8B 4C 94 10 85 C9 74 03 03 41 FC 4A 75 F2 D1 E8 E8 ?? ?? ?? ?? 50 89 C6 8B 44 9C 14 89 F2 85 C0 74 0A 8B 48 FC 01 CE E8 ?? ?? ?? ?? 4B 75 E9 5A 58 E8 ?? ?? ?? ?? 5A 5E 5B 58 8D 24 94 FF E0 C3 }
	condition:
		$1
}

rule function_584_0 {
	meta:
		name = "@WStrCmp"
		size = 129
	strings:
		$1 = { 53 56 57 89 C6 89 D7 39 D0 74 72 85 F6 74 51 85 FF 74 54 8B 46 FC 8B 57 FC 29 D0 77 02 01 C2 52 C1 EA 02 74 26 8B 0E 8B 1F 39 D9 75 41 4A 74 15 8B 4E 04 8B 5F 04 39 D9 75 34 83 C6 08 83 C7 08 4A 75 E2 EB 06 83 C6 04 83 C7 04 5A 83 E2 02 74 0B 66 8B 0E 66 8B 1F 66 39 D9 75 21 01 C0 EB 1D 8B 57 FC 29 D0 EB 16 8B 46 FC 29 D0 EB 0F 5A 66 39 D9 75 09 C1 E9 10 C1 EB 10 66 39 D9 5F 5E 5B C3 }
	condition:
		$1
}

rule function_585_0 {
	meta:
		name = "@WStrCopy"
		size = 73
		refs = "000f @WStrLen 003e @WStrFromPWCharLen"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F9 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 83 FB 01 7D 04 33 DB EB 07 4B 3B C3 7D 02 8B D8 85 FF 7D 04 33 C0 EB 08 2B C3 3B F8 7D 02 8B C7 8B D3 03 D2 03 D6 8B 4D 08 91 E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_586_0 {
	meta:
		name = "@WStrDelete"
		size = 141
		refs = "000f @WStrLen 0048 @NewWideString 005e Move 0083 WStrSet"
	strings:
		$1 = { 53 56 57 55 51 8B F9 8B DA 8B E8 8B 45 00 E8 ?? ?? ?? ?? 8B F0 85 F6 7E 6E 83 FB 01 7C 69 3B F3 7C 65 85 FF 7E 61 4B 8B C6 2B C3 2B C7 8B F8 85 FF 7D 02 33 FF 85 DB 75 0B 85 FF 75 07 33 C0 89 04 24 EB 39 8D 04 1F E8 ?? ?? ?? ?? 89 04 24 85 DB 7E 0F 8B CB 03 C9 8B 14 24 8B 45 00 E8 ?? ?? ?? ?? 85 FF 7E 17 2B F7 8B 45 00 8D 04 70 8B CF 03 C9 8B 14 24 8D 14 5A E8 ?? ?? ?? ?? 8B C5 8B 14 24 E8 ?? ?? ?? ?? 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_587_0 {
	meta:
		name = "@WStrInsert"
		size = 154
		refs = "0014 @WStrLen 003f @NewWideString 0056 Move 008f WStrSet"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B D9 89 54 24 04 89 04 24 8B 04 24 E8 ?? ?? ?? ?? 8B F0 85 F6 7E 75 8B 44 24 04 8B 00 E8 ?? ?? ?? ?? 8B F8 83 FB 01 7D 04 33 DB EB 07 4B 3B FB 7D 02 8B DF 8D 04 3E E8 ?? ?? ?? ?? 8B E8 85 DB 7E 11 8B CB 03 C9 8B D5 8B 44 24 04 8B 00 E8 ?? ?? ?? ?? 8B CE 03 C9 8D 54 5D 00 8B 04 24 E8 ?? ?? ?? ?? 3B FB 7E 1A 03 F3 8D 54 75 00 2B FB 8B CF 03 C9 8B 44 24 04 8B 00 8D 04 58 E8 ?? ?? ?? ?? 8B 44 24 04 8B D5 E8 ?? ?? ?? ?? 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_588_0 {
	meta:
		name = "Pos"
		size = 80
	strings:
		$1 = { 85 C0 74 4B 85 D2 74 3A 53 56 57 89 C6 89 D7 8B 4F FC D1 E9 57 8B 56 FC D1 EA 4A 78 20 66 8B 06 83 C6 02 29 D1 7E 16 F2 66 AF 75 11 89 CB 56 57 89 D1 F3 66 A7 5F 5E 74 0C 89 D9 EB EA 5A 31 C0 EB 0A 31 C0 C3 5A 89 F8 29 D0 D1 E8 5F 5E 5B C3 }
	condition:
		$1
}

rule function_589_0 {
	meta:
		name = "@WStrSetLength"
		size = 65
		refs = "0010 @NewWideString 0019 @WStrLen 0030 Move 0039 WStrSet"
	strings:
		$1 = { 53 56 57 8B F2 8B F8 33 DB 85 F6 7E 27 8B C6 E8 ?? ?? ?? ?? 8B D8 8B 07 E8 ?? ?? ?? ?? 85 C0 7E 13 3B F0 7D 02 8B C6 8B C8 03 C9 8B D3 8B 07 E8 ?? ?? ?? ?? 8B C7 8B D3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_590_0 {
	meta:
		name = "StringOfChar"
		size = 39
		refs = "0010 @WStrFromPWCharLen"
	strings:
		$1 = { 53 56 57 8B F9 8B DA 8B F0 8B C7 8B CB 33 D2 E8 ?? ?? ?? ?? 8B 07 85 DB 7E 09 4B 66 89 34 58 85 DB 7F F7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_591_0 {
	meta:
		name = "@WStrAddRef"
		size = 31
		refs = "000f SysAllocStringLen 0018 WStrError"
	strings:
		$1 = { 8B 10 85 D2 74 18 50 8B 4A FC D1 E9 51 52 E8 ?? ?? ?? ?? 5A 85 C0 0F 84 ?? ?? ?? ?? 89 02 C3 }
	condition:
		$1
}

rule function_592_0 {
	meta:
		name = "@WCharToString"
		size = 91
		refs = "002d CharFromWChar 004e Move"
	strings:
		$1 = { 53 56 81 C4 FC FE FF FF 8B D9 66 89 14 24 8B F0 81 FB FF 00 00 00 7E 05 BB FF 00 00 00 6A 01 8D 4C 24 04 8D 44 24 06 BA FF 00 00 00 E8 ?? ?? ?? ?? 85 C0 7D 04 33 C0 EB 06 3B D8 7D 02 8B C3 88 06 85 C0 7E 0D 8D 56 01 8D 4C 24 02 91 E8 ?? ?? ?? ?? 81 C4 04 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_593_0 {
	meta:
		name = "@InitializeRecord"
		size = 47
		refs = "0021 @InitializeArray"
	strings:
		$1 = { 31 C9 53 8A 4A 01 56 57 89 C3 8D 74 11 0A 8B 7C 11 06 8B 16 8B 46 04 01 D8 8B 12 B9 01 00 00 00 E8 ?? ?? ?? ?? 83 C6 08 4F 7F E7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_600_0 {
	meta:
		name = "@AddRefRecord"
		size = 47
		refs = "0021 @AddRefArray"
	strings:
		$1 = { 31 C9 53 8A 4A 01 56 57 89 C3 8D 74 11 0A 8B 7C 11 06 8B 16 8B 46 04 01 D8 8B 12 B9 01 00 00 00 E8 ?? ?? ?? ?? 83 C6 08 4F 7F E7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_594_0 {
	meta:
		name = "@InitializeArray"
		size = 147
		refs = "003c Error 0071 @InitializeArray 0087 @InitializeRecord"
	strings:
		$1 = { 85 C9 0F 84 8A 00 00 00 53 56 57 89 C3 89 D6 89 CF 31 D2 8A 06 8A 56 01 31 C9 3C 0A 74 22 3C 0B 74 1E 3C 0C 74 24 3C 0D 74 33 3C 0E 74 4D 3C 0F 74 0E 3C 11 74 0A B0 02 5F 5E 5B E9 ?? ?? ?? ?? 89 0B 83 C3 04 4F 7F F8 EB 45 89 0B 89 4B 04 89 4B 08 89 4B 0C 83 C3 10 4F 7F EF EB 32 55 89 D5 8B 54 2E 0A 89 D8 03 5C 2E 02 8B 4C 2E 06 8B 12 E8 ?? ?? ?? ?? 4F 7F E8 5D EB 14 55 89 D5 89 D8 03 5C 2E 02 89 F2 E8 ?? ?? ?? ?? 4F 7F F0 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_595_0 {
	meta:
		name = "@Initialize"
		size = 11
		refs = "0006 @InitializeArray"
	strings:
		$1 = { B9 01 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_603_0 {
	meta:
		name = "@AddRef"
		size = 11
		refs = "0006 @AddRefArray"
	strings:
		$1 = { B9 01 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_599_0 {
	meta:
		name = "@Finalize"
		size = 11
		refs = "0006 @FinalizeArray"
	strings:
		$1 = { B9 01 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_596_0 {
	meta:
		name = "@FinalizeRecord"
		size = 49
		refs = "0021 @FinalizeArray"
	strings:
		$1 = { 31 C9 53 8A 4A 01 56 57 89 C3 8D 74 11 0A 8B 7C 11 06 8B 16 8B 46 04 01 D8 8B 12 B9 01 00 00 00 E8 ?? ?? ?? ?? 83 C6 08 4F 7F E7 89 D8 5F 5E 5B C3 }
	condition:
		$1
}

rule function_597_0 {
	meta:
		name = "@VarClr"
		size = 24
		refs = "0002 VarClearProc 0013 Error"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 07 FF 15 ?? ?? ?? ?? C3 B0 10 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_601_0 {
	meta:
		name = "@VarAddRef"
		size = 24
		refs = "0002 VarAddRefProc 0013 Error"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 07 FF 15 ?? ?? ?? ?? C3 B0 10 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_604_0 {
	meta:
		name = "@VarCopy"
		size = 24
		refs = "0002 VarCopyProc 0013 Error"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 07 FF 15 ?? ?? ?? ?? C3 B0 10 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_598_0 {
	meta:
		name = "@FinalizeArray"
		size = 234
		refs = "004b @LStrClr 0057 @LStrArrayClr 0068 @WStrClr 0071 @WStrArrayClr 007d @VarClr 009a @FinalizeArray 00b0 @FinalizeRecord 00c0 @IntfClear 00d1 @DynArrayClear 00e1 Error"
	strings:
		$1 = { 83 F9 00 0F 84 E0 00 00 00 50 53 56 57 89 C3 89 D6 89 CF 31 D2 8A 06 8A 56 01 3C 0A 74 25 3C 0B 74 3E 3C 0C 74 51 3C 0D 74 5C 3C 0E 74 76 3C 0F 0F 84 84 00 00 00 3C 11 0F 84 8B 00 00 00 E9 97 00 00 00 83 F9 01 89 D8 7F 0A E8 ?? ?? ?? ?? E9 91 00 00 00 89 CA E8 ?? ?? ?? ?? E9 85 00 00 00 83 F9 01 89 D8 7F 07 E8 ?? ?? ?? ?? EB 77 89 CA E8 ?? ?? ?? ?? EB 6E 89 D8 83 C3 10 E8 ?? ?? ?? ?? 4F 7F F3 EB 5F 55 89 D5 8B 54 2E 0A 89 D8 03 5C 2E 02 8B 4C 2E 06 8B 12 E8 ?? ?? ?? ?? 4F 7F E8 5D EB 41 55 89 D5 89 D8 03 5C 2E 02 89 F2 E8 ?? ?? ?? ?? 4F 7F F0 5D EB 2B 89 D8 83 C3 04 E8 ?? ?? ?? ?? 4F 7F F3 EB 1C 89 D8 89 F2 83 C3 04 E8 ?? ?? ?? ?? 4F 7F F1 EB 0B 5F 5E 5B 58 B0 02 E9 ?? ?? ?? ?? 5F 5E 5B 58 C3 }
	condition:
		$1
}

rule function_602_0 {
	meta:
		name = "@AddRefArray"
		size = 191
		refs = "003a Error 0044 @LStrAddRef 0053 @WStrAddRef 0062 @VarAddRef 007f @AddRefArray 0095 @AddRefRecord 00a5 @IntfAddRef 00b4 @DynArrayAddRef"
	strings:
		$1 = { 53 56 57 85 C9 0F 84 B0 00 00 00 89 C3 89 D6 89 CF 31 D2 8A 06 8A 56 01 3C 0A 74 22 3C 0B 74 2D 3C 0C 74 38 3C 0D 74 43 3C 0E 74 5D 3C 0F 74 6F 3C 11 74 7A B0 02 5F 5E 5B E9 ?? ?? ?? ?? 8B 03 83 C3 04 E8 ?? ?? ?? ?? 4F 7F F3 EB 6E 89 D8 83 C3 04 E8 ?? ?? ?? ?? 4F 7F F3 EB 5F 89 D8 83 C3 10 E8 ?? ?? ?? ?? 4F 7F F3 EB 50 55 89 D5 8B 54 2E 0A 89 D8 03 5C 2E 02 8B 4C 2E 06 8B 12 E8 ?? ?? ?? ?? 4F 7F E8 5D EB 32 55 89 D5 89 D8 03 5C 2E 02 89 F2 E8 ?? ?? ?? ?? 4F 7F F0 5D EB 1C 8B 03 83 C3 04 E8 ?? ?? ?? ?? 4F 7F F3 EB 0D 8B 03 83 C3 04 E8 ?? ?? ?? ?? 4F 7F F3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_605_0 {
	meta:
		name = "@CopyRecord"
		size = 282
		refs = "0028 Move 0067 Error 0071 @LStrAsg 0082 @WStrAsg 0093 @VarCopy 00b7 @CopyArray 00d0 @CopyRecord 00dd @IntfCopy 00f0 @DynArrayAsg"
	strings:
		$1 = { 53 56 57 55 89 C3 89 D6 31 C0 8A 41 01 8D 7C 08 0A 8B 6F FC 31 C0 8B 4F F8 51 8B 4F 04 29 C1 7E 0B 89 C2 01 F0 01 DA E8 ?? ?? ?? ?? 8B 47 04 8B 17 8B 12 8A 0A 80 F9 0A 74 31 80 F9 0B 74 3D 80 F9 0C 74 49 80 F9 0D 74 55 80 F9 0E 74 70 80 F9 0F 0F 84 80 00 00 00 80 F9 11 0F 84 88 00 00 00 B0 02 5D 5F 5E 5B E9 ?? ?? ?? ?? 8B 14 30 01 D8 E8 ?? ?? ?? ?? B8 04 00 00 00 EB 7D 8B 14 30 01 D8 E8 ?? ?? ?? ?? B8 04 00 00 00 EB 6C 8D 14 30 01 D8 E8 ?? ?? ?? ?? B8 10 00 00 00 EB 5B 31 C9 8A 4A 01 FF 74 11 02 FF 74 11 06 8B 4C 11 0A 8B 09 8D 14 30 01 D8 E8 ?? ?? ?? ?? 58 EB 3B 31 C9 8A 4A 01 8B 4C 11 02 51 89 D1 8D 14 30 01 D8 E8 ?? ?? ?? ?? 58 EB 22 8B 14 30 01 D8 E8 ?? ?? ?? ?? B8 04 00 00 00 EB 11 89 D1 8B 14 30 01 D8 E8 ?? ?? ?? ?? B8 04 00 00 00 03 47 04 83 C7 08 4D 0F 85 14 FF FF FF 59 29 C1 7E 0A 8D 14 18 01 F0 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_606_0 {
	meta:
		name = "@CopyObject"
		size = 21
		refs = "000a @CopyRecord"
	strings:
		$1 = { 01 C1 FF 31 51 8B 4C 24 0C E8 ?? ?? ?? ?? 59 8F 01 C2 04 00 C3 }
	condition:
		$1
}

rule function_607_0 {
	meta:
		name = "@CopyArray"
		size = 243
		refs = "0042 Error 004b @LStrAsg 0062 @WStrAsg 0076 @VarCopy 0099 @CopyArray 00ad @CopyRecord 00c8 @IntfCopy 00de @DynArrayAsg"
	strings:
		$1 = { 53 56 57 55 89 C3 89 D6 89 CF 8B 6C 24 14 8A 0F 80 F9 0A 74 31 80 F9 0B 74 43 80 F9 0C 74 52 80 F9 0D 74 61 80 F9 0E 74 7D 80 F9 0F 0F 84 91 00 00 00 80 F9 11 0F 84 9C 00 00 00 B0 02 5D 5F 5E 5B E9 ?? ?? ?? ?? 89 D8 8B 16 E8 ?? ?? ?? ?? 83 C3 04 83 C6 04 4D 75 EE E9 8E 00 00 00 89 D8 8B 16 E8 ?? ?? ?? ?? 83 C3 04 83 C6 04 4D 75 EE EB 7A 89 D8 89 F2 E8 ?? ?? ?? ?? 83 C3 10 83 C6 10 4D 75 EE EB 66 31 C9 8A 4F 01 8D 7C 39 02 89 D8 89 F2 8B 4F 08 FF 77 04 E8 ?? ?? ?? ?? 03 1F 03 37 4D 75 EA EB 45 89 D8 89 F2 89 F9 E8 ?? ?? ?? ?? 31 C0 8A 47 01 03 5C 38 02 03 74 38 02 4D 75 E5 EB 28 89 D8 8B 16 E8 ?? ?? ?? ?? 83 C3 04 83 C6 04 4D 75 EE EB 14 89 D8 8B 16 89 F9 E8 ?? ?? ?? ?? 83 C3 04 83 C6 04 4D 75 EC 5D 5F 5E 5B C2 04 00 C3 }
	condition:
		$1
}

rule function_608_0 {
	meta:
		name = "@New"
		size = 19
		refs = "0002 @GetMem 000d @Initialize"
	strings:
		$1 = { 52 E8 ?? ?? ?? ?? 5A 85 C0 74 07 50 E8 ?? ?? ?? ?? 58 C3 }
	condition:
		$1
}

rule function_609_0 {
	meta:
		name = "@Dispose"
		size = 13
		refs = "0002 @Finalize 0008 @FreeMem"
	strings:
		$1 = { 50 E8 ?? ?? ?? ?? 58 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_613_0 {
	meta:
		name = "WideCharLenToStrVar"
		size = 9
		refs = "0004 @LStrFromPWCharLen"
	strings:
		$1 = { 91 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_614_0 {
	meta:
		name = "StringToWideChar"
		size = 54
		refs = "0019 @LStrToPChar 0025 WCharFromChar"
	strings:
		$1 = { 53 56 57 55 8B E9 8B F2 8B F8 8B DF 85 DB 74 05 83 EB 04 8B 1B 53 8B C7 E8 ?? ?? ?? ?? 8B C8 8B D5 4A 8B C6 E8 ?? ?? ?? ?? 66 C7 04 46 00 00 8B C6 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_616_0 {
	meta:
		name = "OleStrToStrVar"
		size = 33
		refs = "000e @WStrLen 0019 WideCharLenToStrVar"
	strings:
		$1 = { 53 56 51 8B F2 8B D8 89 1C 24 8B 04 24 E8 ?? ?? ?? ?? 8B D0 8B CE 8B C3 E8 ?? ?? ?? ?? 5A 5E 5B C3 }
	condition:
		$1
}

rule function_617_0 {
	meta:
		name = "StringToOleStr"
		size = 32
		refs = "0017 @WStrFromPCharLen"
	strings:
		$1 = { 51 33 D2 89 14 24 8B D0 85 D2 74 05 83 EA 04 8B 12 8B CC 91 87 D1 E8 ?? ?? ?? ?? 8B 04 24 5A C3 }
	condition:
		$1
}

rule function_618_0 {
	meta:
		name = "GetVariantManager"
		size = 13
		refs = "0008 @FillChar"
	strings:
		$1 = { 33 C9 BA B0 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_622_0 {
	meta:
		name = "@DispCallByIDError"
		size = 8
		refs = "0003 Error"
	strings:
		$1 = { B0 11 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_624_0 {
	meta:
		name = "@_llmul"
		size = 36
		altNames = "@_llmulo"
	strings:
		$1 = { 52 50 8B 44 24 10 F7 24 24 89 C1 8B 44 24 04 F7 64 24 0C 01 C1 8B 04 24 F7 64 24 0C 01 CA 59 59 C2 08 00 C3 }
	condition:
		$1
}

rule function_626_0 {
	meta:
		name = "@_lldiv"
		size = 146
	strings:
		$1 = { 53 56 57 8B 5C 24 10 8B 4C 24 14 89 D6 89 CF C1 FE 1F 31 F0 31 F2 29 F0 19 F2 C1 FF 1F 31 FE 31 FB 31 F9 29 FB 19 F9 75 13 39 DA 72 09 89 C1 89 D0 31 D2 F7 F3 91 F7 F3 89 CA EB 47 83 EC 0C 89 04 24 89 5C 24 04 89 54 24 08 89 CF D1 EA D1 D8 D1 CF D1 DB 0F BD C9 0F AD FB 0F AD D0 D3 EA D1 C7 F7 F3 8B 1C 24 89 C1 0F AF F8 F7 64 24 04 01 FA 29 C3 89 C8 8B 4C 24 08 19 D1 83 D8 00 31 D2 83 C4 0C 31 F0 31 F2 29 F0 19 F2 5F 5E 5B C2 08 00 C3 }
	condition:
		$1
}

rule function_627_0 {
	meta:
		name = "@_lldivo"
		size = 54
		refs = "002c @_lldiv"
	strings:
		$1 = { 56 8B 74 24 0C 23 74 24 08 81 FE FF FF FF FF 75 11 89 C6 09 D6 81 FE 00 00 00 80 75 05 89 F0 5E 48 C3 5E FF 74 24 08 FF 74 24 08 E8 ?? ?? ?? ?? 21 C0 C2 08 00 C3 }
	condition:
		$1
}

rule function_630_0 {
	meta:
		name = "@_llmodo"
		size = 54
		refs = "002c @_llmod"
	strings:
		$1 = { 56 8B 74 24 0C 23 74 24 08 81 FE FF FF FF FF 75 11 89 C6 09 D6 81 FE 00 00 00 80 75 05 89 F0 5E 48 C3 5E FF 74 24 08 FF 74 24 08 E8 ?? ?? ?? ?? 21 C0 C2 08 00 C3 }
	condition:
		$1
}

rule function_628_0 {
	meta:
		name = "@_lludiv"
		size = 74
	strings:
		$1 = { 55 53 56 57 8B 5C 24 14 8B 4C 24 18 09 C9 75 08 09 D2 74 2F 09 DB 74 2B 89 CD B9 40 00 00 00 31 FF 31 F6 D1 E0 D1 D2 D1 D6 D1 D7 39 EF 72 0B 77 04 39 DE 72 05 29 DE 19 EF 40 E2 E7 5F 5E 5B 5D C2 08 00 F7 F3 31 D2 EB F3 C3 }
	condition:
		$1
}

rule function_629_0 {
	meta:
		name = "@_llmod"
		size = 123
	strings:
		$1 = { 55 53 56 57 31 FF 8B 5C 24 14 8B 4C 24 18 09 C9 75 08 09 D2 74 5D 09 DB 74 59 09 D2 79 0A F7 DA F7 D8 83 DA 00 83 CF 01 09 C9 79 07 F7 D9 F7 DB 83 D9 00 89 CD B9 40 00 00 00 57 31 FF 31 F6 D1 E0 D1 D2 D1 D6 D1 D7 39 EF 72 0B 77 04 39 DE 72 05 29 DE 19 EF 40 E2 E7 89 F0 89 FA 5B F7 C3 01 00 00 00 74 07 F7 DA F7 D8 83 DA 00 5F 5E 5B 5D C2 08 00 F7 F3 92 31 D2 EB F2 C3 }
	condition:
		$1
}

rule function_631_0 {
	meta:
		name = "@_llumod"
		size = 79
	strings:
		$1 = { 55 53 56 57 8B 5C 24 14 8B 4C 24 18 09 C9 75 08 09 D2 74 33 09 DB 74 2F 89 CD B9 40 00 00 00 31 FF 31 F6 D1 E0 D1 D2 D1 D6 D1 D7 39 EF 72 0B 77 04 39 DE 72 05 29 DE 19 EF 40 E2 E7 89 F0 89 FA 5F 5E 5B 5D C2 08 00 F7 F3 92 31 D2 EB F2 C3 }
	condition:
		$1
}

rule function_632_0 {
	meta:
		name = "@_llshl"
		size = 29
	strings:
		$1 = { 80 F9 20 7C 11 80 F9 40 7C 05 31 D2 31 C0 C3 89 C2 D3 E2 31 C0 C3 0F A5 C2 D3 E0 C3 C3 }
	condition:
		$1
}

rule function_633_0 {
	meta:
		name = "@_llshr"
		size = 29
	strings:
		$1 = { 80 F9 20 7C 11 80 F9 40 7C 06 C1 FA 1F 89 D0 C3 89 D0 99 D3 F8 C3 0F AD D0 D3 FA C3 C3 }
	condition:
		$1
}

rule function_634_0 {
	meta:
		name = "@_llushr"
		size = 29
	strings:
		$1 = { 80 F9 20 7C 11 80 F9 40 7C 05 31 D2 31 C0 C3 89 D0 31 D2 D3 E8 C3 0F AD D0 D3 EA C3 C3 }
	condition:
		$1
}

rule function_635_0 {
	meta:
		name = "@StrUInt64Digits"
		size = 161
		refs = "001d @_llumod 0037 @_lludiv 0094 @SetLength"
	strings:
		$1 = { 55 8B EC 83 C4 DC 53 56 57 8B F1 88 55 FF 8B F8 33 DB 6A 00 6A 0A 8B 45 08 8B 55 0C E8 ?? ?? ?? ?? 83 C0 30 83 D2 00 88 44 1D DF 43 6A 00 6A 0A 8B 45 08 8B 55 0C E8 ?? ?? ?? ?? 89 45 08 89 55 0C 83 7D 0C 00 75 CB 83 7D 08 00 75 C5 80 7D FF 00 74 06 C6 44 1D DF 2D 43 81 FF FF 00 00 00 7E 05 BF FF 00 00 00 B8 01 00 00 00 8B D7 2B D3 3B D0 7C 09 C6 04 06 20 40 3B D0 7D F7 85 DB 7E 0E 4B 0F B6 54 1D DF 88 14 06 40 85 DB 7F F2 8B D0 4A 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_636_0 {
	meta:
		name = "@StrInt64"
		size = 61
		refs = "0033 @StrUInt64Digits"
	strings:
		$1 = { 55 8B EC 53 56 8B F2 8B D8 8B 45 08 8B 55 0C 85 D2 7D 07 F7 D8 83 D2 00 F7 DA 52 50 83 7D 0C 00 75 09 83 7D 08 00 0F 92 C2 EB 03 0F 9C C2 8B CE 8B C3 E8 ?? ?? ?? ?? 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_637_0 {
	meta:
		name = "@Str0Int64"
		size = 26
		refs = "0011 @StrInt64"
	strings:
		$1 = { 55 8B EC 53 8B D8 FF 75 0C FF 75 08 8B D3 33 C0 E8 ?? ?? ?? ?? 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_639_0 {
	meta:
		name = "@Str0UInt64"
		size = 26
		refs = "0011 @StrUInt64"
	strings:
		$1 = { 55 8B EC 53 8B D8 FF 75 0C FF 75 08 8B D3 33 C0 E8 ?? ?? ?? ?? 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_638_0 {
	meta:
		name = "@StrUInt64"
		size = 32
		refs = "0016 @StrUInt64Digits"
	strings:
		$1 = { 55 8B EC 53 56 8B F2 8B D8 FF 75 0C FF 75 08 8B CE 33 D2 8B C3 E8 ?? ?? ?? ?? 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_640_0 {
	meta:
		name = "@WriteInt64"
		size = 40
		refs = "0014 @StrInt64 001d @WriteString"
	strings:
		$1 = { 83 EC 20 50 52 FF 74 24 30 FF 74 24 30 31 C0 8D 54 24 10 E8 ?? ?? ?? ?? 59 58 89 E2 E8 ?? ?? ?? ?? 83 C4 20 C2 08 00 C3 }
	condition:
		$1
}

rule function_642_0 {
	meta:
		name = "@WriteUInt64"
		size = 40
		refs = "0014 @StrUInt64 001d @WriteString"
	strings:
		$1 = { 83 EC 20 50 52 FF 74 24 30 FF 74 24 30 31 C0 8D 54 24 10 E8 ?? ?? ?? ?? 59 58 89 E2 E8 ?? ?? ?? ?? 83 C4 20 C2 08 00 C3 }
	condition:
		$1
}

rule function_641_0 {
	meta:
		name = "@Write0Int64"
		size = 8
		refs = "0003 @WriteInt64"
	strings:
		$1 = { 31 D2 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_643_0 {
	meta:
		name = "@Write0UInt64"
		size = 8
		refs = "0003 @WriteUInt64"
	strings:
		$1 = { 31 D2 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_644_0 {
	meta:
		name = "@ReadInt64"
		size = 87
		refs = "0009 @SeekEof 0018 @ReadChar 002e @ValInt64 003d SetInOutRes"
	strings:
		$1 = { 53 56 57 83 EC 24 89 C6 E8 ?? ?? ?? ?? FE C8 74 41 89 E7 B3 20 89 F0 E8 ?? ?? ?? ?? 3C 20 76 28 AA FE CB 75 F0 C6 07 00 89 E0 52 89 E2 E8 ?? ?? ?? ?? 59 85 C9 74 0A B8 6A 00 00 00 E8 ?? ?? ?? ?? 83 C4 24 5F 5E 5B C3 80 FC 1A 74 D8 FF 4E 0C EB D3 31 C0 EB EB C3 }
	condition:
		$1
}

rule function_645_0 {
	meta:
		name = "@ValInt64"
		size = 536
		refs = "0063 UpCase 0187 @_llmul"
	strings:
		$1 = { 53 56 57 55 83 C4 EC 89 14 24 8B F0 BD 01 00 00 00 33 FF C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 00 85 F6 75 0B 8B 04 24 89 28 E9 D7 01 00 00 45 80 7C 2E FF 20 74 F8 C6 44 24 10 00 0F B6 44 2E FF 3C 2D 75 08 C6 44 24 10 01 45 EB 05 3C 2B 75 01 45 B3 01 80 7C 2E FF 24 74 2A 0F B6 44 2E FF E8 ?? ?? ?? ?? 3C 58 74 1C 80 7C 2E FF 30 0F 85 C7 00 00 00 0F B6 04 2E E8 ?? ?? ?? ?? 3C 58 0F 85 B6 00 00 00 80 7C 2E FF 30 75 01 45 45 0F B6 4C 2E FF 8B C1 04 D0 2C 0A 72 0E 04 F9 2C 06 72 10 04 E6 2C 06 72 12 EB 6B 0F B6 F9 83 EF 30 EB 0E 0F B6 F9 83 EF 37 EB 06 0F B6 F9 83 EF 57 83 7C 24 0C 00 75 09 83 7C 24 08 00 72 47 EB 02 7C 43 81 7C 24 0C FF FF FF 0F 75 09 83 7C 24 08 FF 76 04 EB 30 7F 2E 8B C7 99 52 50 8B 44 24 10 8B 54 24 14 0F A4 C2 04 C1 E0 04 03 04 24 13 54 24 04 83 C4 08 89 44 24 08 89 54 24 0C 45 33 DB E9 7A FF FF FF 80 7C 24 10 00 0F 84 CD 00 00 00 8B 44 24 08 8B 54 24 0C F7 D8 83 D2 00 F7 DA 89 44 24 08 89 54 24 0C E9 B1 00 00 00 0F B6 44 2E FF 04 D0 2C 0A 73 5F 0F B6 7C 2E FF 83 EF 30 83 7C 24 0C 00 75 09 83 7C 24 08 00 72 49 EB 02 7C 45 81 7C 24 0C CC CC CC 0C 75 0C 81 7C 24 08 CC CC CC CC 76 04 EB 2F 7F 2D 6A 00 6A 0A 8B 44 24 10 8B 54 24 14 E8 ?? ?? ?? ?? 52 50 8B C7 99 03 04 24 13 54 24 04 83 C4 08 89 44 24 08 89 54 24 0C 45 33 DB EB 96 80 7C 24 10 00 74 17 8B 44 24 08 8B 54 24 0C F7 D8 83 D2 00 F7 DA 89 44 24 08 89 54 24 0C 83 7C 24 0C 00 75 05 83 7C 24 08 00 74 1B 83 7C 24 0C 00 75 0A 83 7C 24 08 00 0F 92 C0 EB 03 0F 9C C0 3A 44 24 10 74 01 4D 80 7C 2E FF 00 0F 95 C0 0A D8 74 07 8B 04 24 89 28 EB 07 8B 04 24 33 D2 89 10 8B 44 24 08 8B 54 24 0C 83 C4 14 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_646_0 {
	meta:
		name = "@DynArrayLength"
		size = 8
		altNames = "DynArraySize"
	strings:
		$1 = { 85 C0 74 03 8B 40 FC C3 }
	condition:
		$1
}

rule function_648_0 {
	meta:
		name = "CopyArray"
		size = 15
		refs = "0007 @CopyArray"
	strings:
		$1 = { 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule function_651_0 {
	meta:
		name = "DynArraySetLength"
		size = 395
		refs = "0026 Error 0030 DynArrayClear 00b0 FinalizeArray 00bb @ReallocMem 00ca @GetMem 00f1 @FillChar 0106 CopyArray 011e Move 0173 DynArraySetLength"
	strings:
		$1 = { 55 8B EC 83 C4 E0 53 56 57 89 4D F8 8B F2 89 45 FC 8B 5D FC 8B 1B 8B 45 08 8B 38 85 FF 7F 1A 85 FF 7D 07 B0 04 E8 ?? ?? ?? ?? 8B 45 FC 8B D6 E8 ?? ?? ?? ?? E9 49 01 00 00 33 C0 89 45 F0 85 DB 74 0B 83 EB 04 8B 03 89 45 F0 83 EB 04 0F B6 46 01 01 C6 8B C6 8B 50 02 89 55 E8 8B 50 06 85 D2 74 04 8B 32 EB 02 33 F6 8B C7 F7 6D E8 89 45 E4 8B 45 E4 99 F7 FF 3B 45 E8 74 07 B0 04 E8 ?? ?? ?? ?? 83 45 E4 08 85 DB 74 05 83 3B 01 75 35 89 5D E0 3B 7D F0 7D 1D 85 F6 74 19 8B C3 83 C0 08 8B D7 0F AF 55 E8 03 C2 8B 4D F0 2B CF 8B D6 E8 ?? ?? ?? ?? 8D 45 E0 8B 55 E4 E8 ?? ?? ?? ?? 8B 5D E0 EB 5E FF 0B 8B 45 E4 E8 ?? ?? ?? ?? 8B D8 8B 45 F0 89 45 EC 3B 7D EC 7D 03 89 7D EC 85 F6 74 2A 8B 55 EC 0F AF 55 E8 8B C3 83 C0 08 33 C9 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 55 FC 8B 12 8B C3 83 C0 08 8B CE E8 ?? ?? ?? ?? EB 16 8B 4D EC 0F AF 4D E8 8B D3 83 C2 08 8B 45 FC 8B 00 E8 ?? ?? ?? ?? C7 03 01 00 00 00 83 C3 04 89 3B 83 C3 04 8B D7 2B 55 F0 0F AF 55 E8 8B 45 E8 0F AF 45 F0 03 C3 33 C9 E8 ?? ?? ?? ?? 83 7D F8 01 7E 2E 83 45 08 04 FF 4D F8 4F 85 FF 7C 22 47 C7 45 F4 00 00 00 00 8B 45 08 50 8B 45 F4 8D 04 83 8B 4D F8 8B D6 E8 ?? ?? ?? ?? FF 45 F4 4F 75 E6 8B 45 FC 89 18 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_652_0 {
	meta:
		name = "@DynArraySetLength"
		size = 11
		refs = "0006 DynArraySetLength"
	strings:
		$1 = { 54 83 04 24 04 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_653_0 {
	meta:
		name = "@DynArrayCopy"
		size = 32
		refs = "0011 @DynArrayCopyRange 001a @DynArrayClear"
	strings:
		$1 = { 53 85 C0 74 12 8B D8 83 EB 04 8B 1B 53 51 33 C9 E8 ?? ?? ?? ?? 5B C3 8B C1 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_654_0 {
	meta:
		name = "@DynArrayCopyRange"
		size = 243
		refs = "0086 @GetMem 00b6 @FillChar 00c4 CopyArray 00d6 Move 00e1 DynArrayClear"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 8B F9 89 55 F8 89 45 FC 8B 75 0C 33 DB 83 7D FC 00 0F 84 BA 00 00 00 8B 45 F8 89 45 F0 85 FF 7D 04 03 F7 33 FF 8B 45 FC 83 E8 04 8B 00 3B C7 7D 02 8B F8 8B D0 2B D7 3B F2 7E 02 8B F2 85 F6 7D 02 33 F6 85 F6 0F 8E 86 00 00 00 8B 45 F0 0F B6 40 01 01 45 F0 8B 45 F0 8B 40 02 89 45 F4 8B 45 F0 8B 40 06 85 C0 74 07 8B 00 89 45 F0 EB 05 33 C0 89 45 F0 8B C6 F7 6D F4 83 C0 08 E8 ?? ?? ?? ?? 8B D8 C7 03 01 00 00 00 83 C3 04 89 33 83 C3 04 0F AF 7D F4 01 7D FC 85 F6 7E 35 83 7D F0 00 74 1F 8B D6 0F AF 55 F4 8B C3 33 C9 E8 ?? ?? ?? ?? 56 8B 4D F0 8B 55 FC 8B C3 E8 ?? ?? ?? ?? EB 10 8B CE 0F AF 4D F4 8B D3 8B 45 FC E8 ?? ?? ?? ?? 8B 45 08 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 08 89 18 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_655_0 {
	meta:
		name = "@DynArrayClear"
		size = 58
		refs = "002c @FinalizeArray 0034 @FreeMem"
	strings:
		$1 = { 8B 08 85 C9 74 33 C7 00 00 00 00 00 F0 FF 49 F8 75 27 50 89 C8 31 C9 8A 4A 01 8B 54 11 06 85 D2 74 0E 8B 48 FC 85 C9 74 07 8B 12 E8 ?? ?? ?? ?? 83 E8 08 E8 ?? ?? ?? ?? 58 C3 }
	condition:
		$1
}

rule function_656_0 {
	meta:
		name = "@DynArrayAsg"
		size = 39
		refs = "001d @DynArrayClear"
	strings:
		$1 = { 53 8B 18 85 D2 74 04 F0 FF 42 F8 85 DB 74 14 F0 FF 4B F8 75 0E 50 52 89 CA FF 43 F8 E8 ?? ?? ?? ?? 5A 58 89 10 5B C3 }
	condition:
		$1
}

rule function_657_0 {
	meta:
		name = "@DynArrayAddRef"
		size = 9
	strings:
		$1 = { 85 C0 74 04 F0 FF 40 F8 C3 }
	condition:
		$1
}

rule function_658_0 {
	meta:
		name = "DynArrayIndex"
		size = 62
	strings:
		$1 = { 55 8B EC 53 56 57 55 89 D6 8B 7D 08 89 C5 31 DB 85 C9 7D 03 8B 6D 00 31 C0 8A 47 01 01 C7 8B 04 9E F7 67 02 8B 7F 06 85 FF 74 02 8B 3F 01 C5 43 39 CB 7E E0 89 E8 5D 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_659_0 {
	meta:
		name = "DynArrayElTypeInfo"
		size = 24
	strings:
		$1 = { 33 D2 85 C0 74 0F 0F B6 48 01 01 C8 8B 48 06 85 C9 74 02 8B 11 8B C2 C3 }
	condition:
		$1
}

rule function_660_0 {
	meta:
		name = "DynArrayDim"
		size = 32
		refs = "000c DynArrayElTypeInfo"
	strings:
		$1 = { 53 56 8B D8 33 F6 EB 0A 46 8B C3 E8 ?? ?? ?? ?? 8B D8 85 DB 74 05 80 3B 11 74 ED 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_662_0 {
	meta:
		name = "IsDynArrayRectangular"
		size = 102
		refs = "0010 DynArrayDim 0024 DynArraySize"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 C6 04 24 01 8B D8 8B C2 E8 ?? ?? ?? ?? 48 85 C0 7E 42 89 44 24 04 85 DB 74 34 8B C3 E8 ?? ?? ?? ?? 8B F0 8B 03 E8 ?? ?? ?? ?? 8B E8 4E 85 F6 7E 1B BF 01 00 00 00 8B 04 BB E8 ?? ?? ?? ?? 3B E8 74 06 C6 04 24 00 EB 0C 47 4E 75 EA 8B 1B FF 4C 24 04 75 C2 0F B6 04 24 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_663_0 {
	meta:
		name = "DynArrayBounds"
		size = 82
		refs = "0010 DynArrayDim 0020 TBoundArray 0025 @DynArraySetLength 003b DynArraySize"
	strings:
		$1 = { 53 56 57 55 51 8B E9 89 14 24 8B D8 8B 04 24 E8 ?? ?? ?? ?? 8B F0 56 8B C5 B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 4E 85 F6 7C 1B 46 33 FF 85 DB 74 10 8B C3 E8 ?? ?? ?? ?? 48 8B 55 00 89 04 BA 8B 1B 47 4E 75 E8 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_664_0 {
	meta:
		name = "DecIndices"
		size = 108
		refs = "000c @DynArrayHigh"
	strings:
		$1 = { 53 56 57 8B F2 8B F8 33 DB 8B 07 E8 ?? ?? ?? ?? 8B D0 85 D2 7C 13 42 33 C0 8B 0F 83 3C 81 00 74 04 B3 01 EB 04 40 4A 75 F0 84 DB 74 39 8B 07 E8 ?? ?? ?? ?? 83 F8 00 7C 2D 8B 17 83 3C 82 00 74 10 8B 17 FF 0C 82 EB 1E 8B 14 86 8B 0F 89 14 81 48 8B 17 83 3C 82 00 74 EF 8B 17 FF 0C 82 EB 06 48 83 F8 FF 75 D3 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_665_0 {
	meta:
		name = "FindModule"
		size = 39
		refs = "0002 LibModuleList"
	strings:
		$1 = { 8B 15 ?? ?? ?? ?? 85 D2 74 1A 3B 42 04 74 15 3B 42 08 74 10 3B 42 0C 74 0B 3B 42 10 74 06 8B 12 85 D2 75 E6 8B C2 C3 }
	condition:
		$1
}

rule function_666_0 {
	meta:
		name = "FindHInstance"
		size = 38
		refs = "000c VirtualQuery"
	strings:
		$1 = { 83 C4 E4 6A 1C 8D 54 24 04 52 50 E8 ?? ?? ?? ?? 81 7C 24 10 00 10 00 00 75 06 8B 44 24 04 EB 02 33 C0 83 C4 1C C3 }
	condition:
		$1
}

rule function_668_0 {
	meta:
		name = "DelayLoadResourceModule"
		size = 71
		refs = "001f GetModuleFileName 0028 LoadResourceModule"
	strings:
		$1 = { 53 56 81 C4 F8 FE FF FF 8B D8 83 7B 10 00 75 2B 68 05 01 00 00 8D 44 24 04 50 8B 43 04 50 E8 ?? ?? ?? ?? 8B C4 B2 01 E8 ?? ?? ?? ?? 8B F0 89 73 10 85 F6 75 06 8B 43 04 89 43 10 8B 43 10 81 C4 08 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_669_0 {
	meta:
		name = "FindResourceHInstance"
		size = 55
		refs = "0007 LibModuleList 0021 DelayLoadResourceModule"
	strings:
		$1 = { 53 56 57 8B F0 8B 1D ?? ?? ?? ?? 85 DB 74 20 3B 73 04 74 0A 3B 73 08 74 05 3B 73 0C 75 0B 8B C3 E8 ?? ?? ?? ?? 8B F8 EB 08 8B 1B 85 DB 75 E0 8B FE 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_670_0 {
	meta:
		name = "FindBS"
		size = 31
		refs = "0008 CharNext"
	strings:
		$1 = { 53 56 8B F0 EB 08 56 E8 ?? ?? ?? ?? 8B F0 0F B6 1E 84 DB 74 05 80 FB 5C 75 EC 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_671_0 {
	meta:
		name = "ToLongPath"
		size = 452
		refs = "0019 ToLongPath 001e GetModuleHandle 0035 GetProcAddress 0065 lstrcpyn 008a FindBS 0112 FindFirstFile 0124 FindClose 0130 @strlen"
	strings:
		$1 = { 55 8B EC 81 C4 AC FD FF FF 53 56 57 89 55 F8 89 45 FC 8B 45 FC 89 45 F4 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 83 7D F0 00 74 43 68 ?? ?? ?? ?? 8B 45 F0 50 E8 ?? ?? ?? ?? 89 C3 85 DB 74 2F 68 05 01 00 00 8D 85 AD FD FF FF 50 8B 45 FC 50 FF D3 85 C0 74 19 8B 45 F8 50 8D 85 AD FD FF FF 50 8B 45 FC 50 E8 ?? ?? ?? ?? E9 28 01 00 00 8B 45 FC 80 38 5C 75 38 8B 45 FC 80 78 01 5C 0F 85 13 01 00 00 8B 45 FC 83 C0 02 E8 ?? ?? ?? ?? 8B F0 80 3E 00 0F 84 FD 00 00 00 8D 46 01 E8 ?? ?? ?? ?? 8B F0 80 3E 00 0F 84 EA 00 00 00 EB 06 8B 75 FC 83 C6 02 8B DE 2B 5D FC 8D 43 01 50 8B 45 FC 50 8D 85 AD FD FF FF 50 E8 ?? ?? ?? ?? E9 A7 00 00 00 8D 46 01 E8 ?? ?? ?? ?? 8B F8 8B C7 2B C6 03 C3 40 3D 05 01 00 00 0F 8F A8 00 00 00 8B C7 2B C6 40 50 56 8D 85 AD FD FF FF 03 C3 50 E8 ?? ?? ?? ?? 8D 85 B2 FE FF FF 50 8D 85 AD FD FF FF 50 E8 ?? ?? ?? ?? 89 45 F0 83 7D F0 FF 74 77 8B 45 F0 50 E8 ?? ?? ?? ?? 8D 85 DE FE FF FF 50 E8 ?? ?? ?? ?? 8D 53 01 03 C2 40 3D 05 01 00 00 7F 55 C6 84 1D AD FD FF FF 5C B8 05 01 00 00 2B C3 48 50 8D 85 DE FE FF FF 50 8D 85 AD FD FF FF 03 C3 40 50 E8 ?? ?? ?? ?? 8D 85 DE FE FF FF 50 E8 ?? ?? ?? ?? 40 03 D8 8B F7 80 3E 00 0F 85 50 FF FF FF 8B 45 F8 50 8D 85 AD FD FF FF 50 8B 45 FC 50 E8 ?? ?? ?? ?? 8B 45 F4 5F 5E 5B 8B E5 5D C3 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 4C 6F 6E 67 50 61 74 68 4E 61 6D 65 41 00 00 00 00 }
	condition:
		$1
}

rule function_672_0 {
	meta:
		name = "LoadResourceModule"
		size = 624
		refs = "001d GetModuleFileName 0031 LoadResourceModule 003b RegOpenKeyEx 00a4 ToLongPath 00c0 RegQueryValueEx 0100 RegCloseKey 0106 @HandleFinally 011d lstrcpyn 012a GetThreadLocale 0130 GetLocaleInfo 015b @strlen 01b2 LoadLibraryEx"
	strings:
		$1 = { 55 8B EC 81 C4 E0 FE FF FF 53 56 89 45 FC 68 05 01 00 00 8D 85 E3 FE FF FF 50 6A 00 E8 ?? ?? ?? ?? C6 45 EE 00 8D 45 F8 50 68 19 00 0F 00 6A 00 68 ?? ?? ?? ?? 68 01 00 00 80 E8 ?? ?? ?? ?? 85 C0 74 40 8D 45 F8 50 68 19 00 0F 00 6A 00 68 ?? ?? ?? ?? 68 02 00 00 80 E8 ?? ?? ?? ?? 85 C0 74 22 8D 45 F8 50 68 19 00 0F 00 6A 00 68 ?? ?? ?? ?? 68 01 00 00 80 E8 ?? ?? ?? ?? 85 C0 0F 85 89 00 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C7 45 E8 05 00 00 00 8D 85 E3 FE FF FF BA 05 01 00 00 E8 ?? ?? ?? ?? 8D 45 E8 50 8D 45 EE 50 6A 00 6A 00 8D 85 E3 FE FF FF 50 8B 45 F8 50 E8 ?? ?? ?? ?? 85 C0 74 22 8D 45 E8 50 8D 45 EE 50 6A 00 6A 00 68 ?? ?? ?? ?? 8B 45 F8 50 E8 ?? ?? ?? ?? 85 C0 74 04 C6 45 EE 00 C6 45 F2 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EF 68 05 01 00 00 8B 45 FC 50 8D 85 E3 FE FF FF 50 E8 ?? ?? ?? ?? 6A 05 8D 45 F3 50 6A 03 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 F6 80 BD E3 FE FF FF 00 0F 84 E3 00 00 00 80 7D F3 00 75 0A 80 7D EE 00 0F 84 D3 00 00 00 8D 85 E3 FE FF FF 50 E8 ?? ?? ?? ?? 8B D8 8D 85 E3 FE FF FF 03 D8 EB 01 4B 80 3B 2E 74 0A 8D 85 E3 FE FF FF 3B D8 75 F0 8D 85 E3 FE FF FF 3B D8 0F 84 9D 00 00 00 43 80 7D EE 00 74 28 8B D3 2B D0 B8 05 01 00 00 2B C2 50 8D 45 EE 50 53 E8 ?? ?? ?? ?? 6A 02 6A 00 8D 85 E3 FE FF FF 50 E8 ?? ?? ?? ?? 8B F0 85 F6 75 6A 80 7D F3 00 74 64 8D 85 E3 FE FF FF 8B D3 2B D0 B8 05 01 00 00 2B C2 50 8D 45 F3 50 53 E8 ?? ?? ?? ?? 6A 02 6A 00 8D 85 E3 FE FF FF 50 E8 ?? ?? ?? ?? 8B F0 85 F6 75 32 C6 45 F5 00 8D 85 E3 FE FF FF 8B D3 2B D0 B8 05 01 00 00 2B C2 50 8D 45 F3 50 53 E8 ?? ?? ?? ?? 6A 02 6A 00 8D 85 E3 FE FF FF 50 E8 ?? ?? ?? ?? 8B F0 8B C6 5E 5B 8B E5 5D C3 00 00 53 6F 66 74 77 61 72 65 5C 42 6F 72 6C 61 6E 64 5C 4C 6F 63 61 6C 65 73 00 00 00 00 53 6F 66 74 77 61 72 65 5C 42 6F 72 6C 61 6E 64 5C 44 65 6C 70 68 69 5C 4C 6F 63 61 6C 65 73 00 00 00 00 00 }
	condition:
		$1
}

rule function_675_0 {
	meta:
		name = "EnumModules"
		size = 38
		refs = "0009 LibModuleList"
	strings:
		$1 = { 53 56 57 8B FA 8B F0 8B 1D ?? ?? ?? ?? 85 DB 74 11 8B D7 8B 43 04 FF D6 84 C0 74 06 8B 1B 85 DB 75 EF 5F 5E 5B C3 }
	condition:
		$1
}

rule function_676_0 {
	meta:
		name = "EnumResourceModules"
		size = 42
		refs = "0009 LibModuleList 0014 DelayLoadResourceModule"
	strings:
		$1 = { 53 56 57 8B FA 8B F0 8B 1D ?? ?? ?? ?? 85 DB 74 15 8B C3 E8 ?? ?? ?? ?? 8B D7 FF D6 84 C0 74 06 8B 1B 85 DB 75 EB 5F 5E 5B C3 }
	condition:
		$1
}

rule function_679_0 {
	meta:
		name = "AddModuleUnloadProc"
		size = 31
		refs = "0009 @GetMem 000f ModuleUnloadList"
	strings:
		$1 = { 53 8B D8 B8 08 00 00 00 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 10 89 58 04 A3 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_680_0 {
	meta:
		name = "RemoveModuleUnloadProc"
		size = 99
		refs = "0008 ModuleUnloadList 002b @FreeMem"
	strings:
		$1 = { 53 56 57 55 8B E8 8B 3D ?? ?? ?? ?? 85 FF 74 21 8B 47 04 3B C5 75 1A A1 ?? ?? ?? ?? 8B 00 A3 ?? ?? ?? ?? BA 08 00 00 00 8B C7 E8 ?? ?? ?? ?? EB 2D 8B DF 85 DB 74 27 8B 33 85 F6 74 1B 8B 46 04 3B C5 75 14 8B FE 8B 06 89 03 BA 08 00 00 00 8B C7 E8 ?? ?? ?? ?? EB 06 8B 1B 85 DB 75 D9 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_681_0 {
	meta:
		name = "NotifyModuleUnload"
		size = 90
		refs = "000d ModuleUnloadList 001e NotifyModuleUnload 003c @HandleAnyException 0041 @DoneExcept"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 89 45 FC A1 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 74 39 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 5D F8 8B 45 FC FF 53 04 33 C0 5A 59 59 64 89 10 EB 0A E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 8B 00 89 45 F8 83 7D F8 00 75 C7 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_682_0 {
	meta:
		name = "RegisterModule"
		size = 14
		refs = "0002 LibModuleList"
	strings:
		$1 = { 8B 15 ?? ?? ?? ?? 89 10 A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_683_0 {
	meta:
		name = "UnregisterModule"
		size = 110
		refs = "000b UnregisterModule 001c NotifyModuleUnload 0032 LibModuleList 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC 8B 40 04 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 3B 05 ?? ?? ?? ?? 75 0C 8B 45 FC 8B 00 A3 ?? ?? ?? ?? EB 1F A1 ?? ?? ?? ?? 85 C0 74 16 8B 10 3B 55 FC 75 09 8B 55 FC 8B 12 89 10 EB 06 8B 00 85 C0 75 EA C3 E9 ?? ?? ?? ?? EB C2 59 5D C3 }
	condition:
		$1
}

rule function_684_0 {
	meta:
		name = "@IntfClear"
		size = 21
	strings:
		$1 = { 8B 10 85 D2 74 0E C7 00 00 00 00 00 50 52 8B 02 FF 50 08 58 C3 }
	condition:
		$1
}

rule function_685_0 {
	meta:
		name = "@IntfCopy"
		size = 44
	strings:
		$1 = { 85 D2 74 19 52 50 8B 02 52 FF 50 04 58 8B 08 8F 00 85 C9 75 01 C3 8B 01 51 FF 50 08 C3 8B 08 85 C9 89 10 74 06 8B 01 51 FF 50 08 C3 }
	condition:
		$1
}

rule function_686_0 {
	meta:
		name = "@IntfCast"
		size = 48
		refs = "0004 @IntfClear 001b Error"
	strings:
		$1 = { 85 D2 0F 84 ?? ?? ?? ?? 57 89 C7 6A 00 54 51 52 8B 02 FF 10 85 C0 74 07 B0 17 E9 ?? ?? ?? ?? 8B 07 85 C0 74 06 50 8B 00 FF 50 08 58 89 07 5F C3 }
	condition:
		$1
}

rule function_687_0 {
	meta:
		name = "@IntfAddRef"
		size = 11
	strings:
		$1 = { 85 C0 74 06 50 8B 00 FF 50 04 C3 }
	condition:
		$1
}

rule function_688_0 {
	meta:
		name = "TInterfacedObject.AfterConstruction"
		size = 10
		refs = "0005 InterlockedDecrement"
	strings:
		$1 = { 83 C0 04 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_689_0 {
	meta:
		name = "TInterfacedObject.BeforeDestruction"
		size = 14
		refs = "0009 Error"
	strings:
		$1 = { 83 78 04 00 74 07 B0 02 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_690_0 {
	meta:
		name = "TInterfacedObject.NewInstance"
		size = 13
		refs = "0001 TObject.NewInstance"
	strings:
		$1 = { E8 ?? ?? ?? ?? C7 40 04 01 00 00 00 C3 }
	condition:
		$1
}

rule function_691_0 {
	meta:
		name = "TContainedObject.QueryInterface"
		size = 38
		refs = "0010 TObject.GetInterface"
		altNames = "TInterfacedObject.QueryInterface"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 8B 4D 10 8B 55 0C 8B C3 E8 ?? ?? ?? ?? 84 C0 74 04 33 C0 EB 05 B8 02 40 00 80 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_692_0 {
	meta:
		name = "TInterfacedObject._AddRef"
		size = 19
		refs = "000b InterlockedIncrement"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 C0 04 50 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule function_693_0 {
	meta:
		name = "TInterfacedObject._Release"
		size = 40
		refs = "000d InterlockedDecrement"
	strings:
		$1 = { 55 8B EC 53 56 8B 5D 08 8D 43 04 50 E8 ?? ?? ?? ?? 8B F0 85 F6 75 09 B2 01 8B C3 8B 08 FF 51 FC 8B C6 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_694_0 {
	meta:
		name = "TAggregatedObject.Create"
		size = 35
		refs = "0008 @ClassCreate 0014 @AfterConstruction"
	strings:
		$1 = { 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 48 04 84 D2 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C C3 }
	condition:
		$1
}

rule function_695_0 {
	meta:
		name = "TAggregatedObject.GetController"
		size = 19
		refs = "000c @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_696_0 {
	meta:
		name = "TAggregatedObject.QueryInterface"
		size = 26
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 10 52 8B 55 0C 52 8B 40 04 50 8B 00 FF 10 5D C2 0C 00 }
	condition:
		$1
}

rule function_697_0 {
	meta:
		name = "TAggregatedObject._AddRef"
		size = 19
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 40 04 50 8B 00 FF 50 04 5D C2 04 00 }
	condition:
		$1
}

rule function_698_0 {
	meta:
		name = "TAggregatedObject._Release"
		size = 19
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 40 04 50 8B 00 FF 50 08 5D C2 04 00 }
	condition:
		$1
}

rule function_700_0 {
	meta:
		name = "TClassHelperBase._Create"
		size = 60
		refs = "000b @ClassCreate 001a TObject.Create 0028 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 0C 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_701_0 {
	meta:
		name = "@CheckAutoResult"
		size = 27
		refs = "0006 SafeCallErrorProc 0016 Error"
	strings:
		$1 = { 85 C0 79 16 8B 0D ?? ?? ?? ?? 85 C9 74 05 8B 14 24 FF D1 B0 18 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_702_0 {
	meta:
		name = "CompToDouble"
		size = 20
	strings:
		$1 = { 55 8B EC 83 C4 F8 DF 6D 08 DD 5D F8 9B DD 45 F8 59 59 5D C3 }
	condition:
		$1
}

rule function_703_0 {
	meta:
		name = "DoubleToComp"
		size = 14
	strings:
		$1 = { 55 8B EC DD 45 08 8B 45 10 DF 38 9B 5D C3 }
	condition:
		$1
}

rule function_704_0 {
	meta:
		name = "CompToCurrency"
		size = 32
		refs = "000b CompToCurrency"
	strings:
		$1 = { 55 8B EC 83 C4 F8 DF 6D 08 D8 0D ?? ?? ?? ?? DF 7D F8 9B DF 6D F8 59 59 5D C3 00 00 00 40 1C 46 }
	condition:
		$1
}

rule function_705_0 {
	meta:
		name = "CurrencyToComp"
		size = 24
		refs = "0008 CurrencyToComp"
	strings:
		$1 = { 55 8B EC DF 6D 08 D8 35 ?? ?? ?? ?? 8B 45 10 DF 38 9B 5D C3 00 40 1C 46 }
	condition:
		$1
}

rule function_706_0 {
	meta:
		name = "GetMemory"
		size = 14
		refs = "0008 MemoryManager"
	strings:
		$1 = { 55 8B EC 8B 45 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule function_707_0 {
	meta:
		name = "FreeMemory"
		size = 22
		refs = "0010 MemoryManager"
	strings:
		$1 = { 55 8B EC 8B 45 08 85 C0 75 04 33 C0 5D C3 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule function_708_0 {
	meta:
		name = "ReallocMemory"
		size = 30
		refs = "000f GetMemory 0018 MemoryManager"
	strings:
		$1 = { 55 8B EC 8B 55 0C 8B 45 08 85 C0 75 09 52 E8 ?? ?? ?? ?? 59 5D C3 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule function_709_0 {
	meta:
		name = "SetLineBreakStyle"
		size = 39
		refs = "0022 SetInOutRes"
	strings:
		$1 = { 66 81 78 04 B0 D7 75 14 0F B7 48 06 66 81 E1 FE FF 0F B6 D2 66 0B CA 66 89 48 06 C3 B8 6B 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_710_0 {
	meta:
		name = "UnicodeToUtf8"
		size = 27
		refs = "0015 UnicodeToUtf8"
	strings:
		$1 = { 56 33 F6 85 D2 74 0A EB 01 46 66 83 3C 72 00 75 F8 56 87 CA E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_711_0 {
	meta:
		name = "UnicodeToUtf8"
		size = 220
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 89 4D F8 89 55 FC 33 D2 83 7D F8 00 0F 84 B8 00 00 00 33 F6 33 C9 85 C0 0F 84 87 00 00 00 EB 6C 8B 55 F8 0F B7 14 4A 41 83 FA 7F 77 06 88 14 30 46 EB 59 81 FA FF 07 00 00 76 31 8D 5E 03 3B 5D FC 77 53 8B DA C1 EB 0C 80 CB E0 88 1C 30 8B DA C1 EB 06 80 E3 3F 80 CB 80 88 5C 30 01 80 E2 3F 80 CA 80 88 54 30 02 83 C6 03 EB 20 8D 5E 02 3B 5D FC 77 22 8B DA C1 EB 06 80 CB C0 88 1C 30 80 E2 3F 80 CA 80 88 54 30 01 83 C6 02 3B 4D 08 73 05 3B 75 FC 72 8A 3B 75 FC 72 04 8B 75 FC 4E C6 04 30 00 EB 22 3B 4D 08 73 1D 8B 45 F8 0F B7 14 48 41 83 FA 7F 76 0A 81 FA FF 07 00 00 76 01 46 46 46 3B 4D 08 72 E3 8D 56 01 8B C2 5E 5B 59 59 5D C2 04 00 }
	condition:
		$1
}

rule function_712_0 {
	meta:
		name = "Utf8ToUnicode"
		size = 26
		refs = "0014 Utf8ToUnicode"
	strings:
		$1 = { 56 33 F6 85 D2 74 09 EB 01 46 80 3C 32 00 75 F9 56 87 CA E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_713_0 {
	meta:
		name = "Utf8ToUnicode"
		size = 304
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 89 4D F4 89 55 F8 89 45 FC 83 7D F4 00 75 0A 33 C0 89 45 F0 E9 04 01 00 00 C7 45 F0 FF FF FF FF 33 C0 33 F6 83 7D FC 00 0F 84 A1 00 00 00 EB 7D 8B 55 F4 0F B6 0C 32 46 F6 C1 80 74 68 3B 75 08 0F 83 D7 00 00 00 83 E1 3F F6 C1 20 74 2C 8B 55 F4 0F B6 14 32 46 8B DA 80 E3 C0 80 FB 80 0F 85 B9 00 00 00 3B 75 08 0F 83 B0 00 00 00 80 E2 3F 0F B6 D2 C1 E1 06 0B D1 8B CA 8B 55 F4 0F B6 14 32 46 8B DA 80 E3 C0 80 FB 80 0F 85 8D 00 00 00 80 E2 3F 0F B6 D2 C1 E1 06 66 0B D1 8B 4D FC 66 89 14 41 EB 07 8B 55 FC 66 89 0C 42 40 3B 75 08 73 09 3B 45 F8 0F 82 75 FF FF FF 3B 45 F8 72 04 8B 45 F8 48 8B 55 FC 66 C7 04 42 00 00 EB 4A 3B 75 08 73 45 8B 55 F4 0F B6 14 32 46 F6 C2 80 74 32 3B 75 08 73 37 80 E2 3F F6 C2 20 74 15 8B 55 F4 0F B6 14 32 46 80 E2 C0 80 FA 80 75 1F 3B 75 08 73 1A 8B 55 F4 0F B6 14 32 46 80 E2 C0 80 FA 80 75 0A 40 3B 75 08 72 BB 40 89 45 F0 8B 45 F0 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_714_0 {
	meta:
		name = "UTF8Encode"
		size = 185
		refs = "0016 UTF8Encode 0024 @LStrClr 002d @WStrCmp 0036 @WStrLen 0041 @LStrSetLength 005c @WStrToPWChar 0065 @LStrToPChar 006e UnicodeToUtf8 0092 @LStrAsg 00ad @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 C9 89 4D FC 89 55 F8 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 E8 ?? ?? ?? ?? 8B C6 33 D2 E8 ?? ?? ?? ?? 74 63 8B C6 E8 ?? ?? ?? ?? 8D 14 40 8D 45 FC E8 ?? ?? ?? ?? 8B 5D FC 85 DB 74 05 83 EB 04 8B 1B 8B C6 E8 ?? ?? ?? ?? 50 8B C6 E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 8D 53 01 59 E8 ?? ?? ?? ?? 85 C0 7E 0D 8B D0 4A 8D 45 FC E8 ?? ?? ?? ?? EB 08 8D 45 FC E8 ?? ?? ?? ?? 8B 45 F8 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_715_0 {
	meta:
		name = "UTF8Decode"
		size = 184
		refs = "0016 UTF8Decode 0024 @WStrClr 0042 @WStrSetLength 0054 @WStrLen 005d @LStrToPChar 0066 @WStrToPWChar 006d Utf8ToUnicode 0091 @WStrAsg 00ac @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D FC 89 55 F8 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 E8 ?? ?? ?? ?? 85 F6 74 69 89 75 F4 8B 5D F4 8B C3 85 C0 74 05 83 E8 04 8B 00 8D 55 FC 92 E8 ?? ?? ?? ?? 85 DB 74 05 83 EB 04 8B 1B 53 8B 45 FC E8 ?? ?? ?? ?? 40 50 8B C6 E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 59 5A E8 ?? ?? ?? ?? 85 C0 7E 0D 8B D0 4A 8D 45 FC E8 ?? ?? ?? ?? EB 08 8D 45 FC E8 ?? ?? ?? ?? 8B 45 F8 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_716_0 {
	meta:
		name = "AnsiToUtf8"
		size = 79
		refs = "000f AnsiToUtf8 001f @WStrFromLStr 0029 UTF8Encode 003e @WStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B D3 E8 ?? ?? ?? ?? 8B 45 FC 8B D6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_717_0 {
	meta:
		name = "Utf8ToAnsi"
		size = 79
		refs = "000f Utf8ToAnsi 001f UTF8Decode 0029 @LStrFromWStr 003e @WStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_718_0 {
	meta:
		name = "LoadResString"
		size = 87
		refs = "002d FindResourceHInstance 0033 LoadString 003e @LStrFromPCharLen 004a @LStrFromPChar"
	strings:
		$1 = { 53 56 81 C4 04 F0 FF FF 50 8B F2 8B D8 85 DB 74 3D 81 7B 04 00 00 01 00 7D 2A 68 00 10 00 00 8D 44 24 04 50 8B 43 04 50 8B 03 8B 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B C8 8B D4 8B C6 E8 ?? ?? ?? ?? EB 0A 8B C6 8B 53 04 E8 ?? ?? ?? ?? 81 C4 00 10 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_719_0 {
	meta:
		name = "PUCS4Chars"
		size = 25
		refs = "0006 @DynArrayLength 0013 xxPNull"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 85 C0 7E 04 8B C3 5B C3 A1 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_720_0 {
	meta:
		name = "WideStringToUCS4String"
		size = 85
		refs = "000a @WStrLen 0019 UCS4String 001e @DynArraySetLength"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 40 50 8B C6 B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 8B C3 E8 ?? ?? ?? ?? 8B D0 4A 85 D2 7C 10 42 33 C0 0F B7 0C 43 8B 3E 89 0C 87 40 4A 75 F3 8B C3 E8 ?? ?? ?? ?? 8B 16 33 C9 89 0C 82 5F 5E 5B C3 }
	condition:
		$1
}

rule function_721_0 {
	meta:
		name = "UCS4StringToWideString"
		size = 61
		refs = "000a @DynArrayLength 0014 @WStrSetLength"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D0 4A 8B C6 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D0 83 EA 02 85 D2 7C 11 42 33 C0 0F B7 0C 83 8B 3E 66 89 0C 47 40 4A 75 F2 5F 5E 5B C3 }
	condition:
		$1
}

rule function_723_0 {
	meta:
		name = "LCIDToCodePage"
		size = 116
		refs = "0010 LCIDToCodePage 0027 GetLocaleInfo 0037 @LStrFromArray 0042 @ValLong 0061 @LStrClr 0067 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 33 D2 89 55 F0 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 6A 07 8D 55 F5 52 68 04 10 00 00 50 E8 ?? ?? ?? ?? 8D 45 F0 8D 55 F5 B9 07 00 00 00 E8 ?? ?? ?? ?? 8B 45 F0 8D 55 FC E8 ?? ?? ?? ?? 8B D8 83 7D FC 00 74 02 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_725_0 {
	meta:
		name = "Finalization"
		size = 93
		refs = "0007 Finalization 0013 _DV_6 001a Input 001f @Close 0024 Output 002e ErrOutput 0038 FinalizeMemoryManager 003d Copyright 0042 @LStrClr 0055 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 2D B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_726_0 {
	meta:
		name = "System"
		size = 149
		refs = "0002 _DV_6 000e InitializeMemoryManager 0014 FileMode 001b RaiseExceptionProc 001f RaiseException 0025 RTLUnwindProc 0029 RtlUnwind 002f Test8086 0036 DispCallByIDProc 003a @DispCallByIDError 003f @isNECWindows 0048 @FpuMaskInit 004d @FpuInit 0054 Input 005d Output 0066 ErrOutput 006d GetCommandLine 0072 CmdLine 0077 GetCmdShow 007c CmdShow 0081 GetACP 0086 DefaultSystemCodePage 008b GetCurrentThreadId 0090 MainThreadID"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 0F 83 87 00 00 00 E8 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 02 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 02 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 C7 05 ?? ?? ?? ?? B0 D7 66 C7 05 ?? ?? ?? ?? B0 D7 66 C7 05 ?? ?? ?? ?? B0 D7 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}