private rule architecture {
	meta:
		bits = 32
		endianness = "big"
		architecture = "MIPS"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "__fsetlocking"
		size = 68
	strings:
		$1 = { 8C 86 00 00 24 03 00 02 24 07 00 01 30 C2 80 00 00 62 38 0B 10 A0 00 06 00 E0 10 21 3C 07 FF FF 24 E7 7F FF 10 A3 00 04 00 C7 30 24 AC 86 00 00 03 E0 00 08 00 00 00 00 34 C6 80 00 03 E0 00 08 AC 86 00 00 }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "prefixcmp"
		size = 40
	strings:
		$1 = { 8C 83 00 10 8C A4 00 10 00 64 28 2B 14 A0 00 04 24 02 00 01 00 64 10 26 00 02 10 2B 00 02 10 23 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_1_1_0 {
	meta:
		name = "scopecmp"
		size = 40
	strings:
		$1 = { 8C 82 00 04 8C A3 00 04 00 62 20 2B 14 80 00 04 00 00 00 00 00 43 10 26 03 E0 00 08 00 02 10 2B 03 E0 00 08 24 02 FF FF }
	condition:
		$1
}

rule file_1_2_0 {
	meta:
		name = "in6aicmp"
		size = 16
		refs = "0008 memcmp"
	strings:
		$1 = { 24 84 00 08 24 A5 00 08 0? ?? ?? ?? 24 06 00 10 }
	condition:
		$1
}

rule file_1_3_0 {
	meta:
		name = "match_prefix"
		size = 284
	strings:
		$1 = { 94 83 00 00 24 07 00 02 10 67 00 07 27 BD FF D8 00 C0 10 21 24 06 00 0A 10 66 00 11 00 00 00 00 03 E0 00 08 27 BD 00 28 94 83 00 02 8C 82 00 04 24 04 00 0A A7 A3 00 0A 24 03 FF FF AF A0 00 18 A7 A4 00 08 AF A0 00 0C AF A0 00 10 AF A0 00 14 A7 A3 00 1A AF A2 00 1C AF A0 00 20 27 A4 00 08 8C A2 00 10 24 89 00 08 2C 43 00 08 14 60 00 1D 34 0A FF 00 90 A6 00 00 90 83 00 08 14 C3 00 14 01 20 30 21 0? ?? ?? ?? 00 A0 18 21 90 68 00 00 90 C7 00 00 15 07 00 0E 00 00 00 00 24 42 FF F8 2C 47 00 08 24 63 00 01 10 E0 FF F8 24 C6 00 01 90 C6 00 00 90 63 00 00 00 4A 10 07 00 C3 18 26 30 63 00 FF 00 62 10 24 10 40 00 11 00 00 00 00 24 A5 00 18 8C A2 00 10 2C 43 00 08 10 60 FF E5 00 00 00 00 01 20 30 21 00 A0 18 21 90 C6 00 00 90 63 00 00 00 4A 10 07 00 C3 18 26 30 63 00 FF 00 62 10 24 14 40 FF F3 24 A5 00 18 24 A5 FF E8 8C A2 00 14 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_1_4_0 {
	meta:
		name = "gaiconf_init"
		size = 3232
		refs = "0000 __gnu_local_gp 0004 $LC0 0008 $LC1 005c _IO_new_fopen 006c fileno 007c __fxstat64 0090 __libc_tsd_CTYPE_B 0094 __libc_errno 00d8 __getline 00ec strchr 0298 strcmp 0294 $LC5 02e0 inet_pton 0300 strtoul 0374 free 037c _IO_new_fclose 03b8 malloc 0448 qsort 0554 $LC2 0680 $LC4 07cc $LC3"
	strings:
		$1 = { 3C 1C ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 27 BD FE D8 27 9C ?? ?? 24 84 ?? ?? 24 A5 ?? ?? AF B0 01 00 AF BF 01 24 AF BE 01 20 AF B7 01 1C AF B6 01 18 AF B5 01 14 AF B4 01 10 AF B3 01 0C AF B2 01 08 AF B1 01 04 AF BC 00 10 AF A0 00 E0 AF A0 00 DC A3 A0 00 E5 AF A0 00 D8 AF A0 00 D4 0? ?? ?? ?? A3 A0 00 E4 10 40 02 8C 00 40 80 21 0? ?? ?? ?? 00 40 20 21 00 40 28 21 24 04 00 03 0? ?? ?? ?? 27 A6 00 18 14 40 02 AE 8F BC 00 10 8E 02 00 00 8F 93 ?? ?? 8F 95 ?? ?? 7C 03 E8 3B 34 42 80 00 AF A0 00 D0 AF A0 00 CC 00 60 90 21 AF A0 00 F8 AE 02 00 00 AF A0 00 E8 00 00 88 21 02 63 A0 21 02 A3 A8 21 30 42 00 10 14 40 00 AA 02 72 F0 21 27 A4 00 D0 27 A5 00 CC 0? ?? ?? ?? 02 00 30 21 18 40 00 A4 8F B6 00 D0 24 05 00 23 0? ?? ?? ?? 02 C0 20 21 10 40 01 60 00 00 00 00 A0 40 00 00 8F A4 00 D0 80 83 00 00 0? ?? ?? ?? 8F C2 00 00 80 83 00 00 00 03 28 40 00 45 28 21 94 A5 00 00 30 A5 00 20 14 A0 FF FA 24 84 00 01 24 84 FF FF 14 60 00 07 00 80 B8 21 0? ?? ?? ?? 00 00 30 21 94 C5 00 00 30 A5 00 20 14 A0 00 7C 02 E4 40 23 26 F7 00 01 82 E5 00 00 00 05 30 40 14 A0 FF F8 00 46 30 21 94 46 00 00 02 E4 40 23 00 00 28 21 30 C6 00 20 30 C6 FF FF 10 C0 00 0A 00 00 00 00 26 F7 00 01 82 E5 00 00 00 05 30 40 00 46 30 21 94 C6 00 00 30 C6 00 20 14 C0 FF FA 26 F7 00 01 26 F7 FF FF 10 A0 02 37 00 00 00 00 00 05 30 40 00 46 30 21 94 C6 00 00 30 C6 00 20 10 C0 00 07 02 E0 B0 21 0? ?? ?? ?? 00 00 00 00 94 C6 00 00 30 C6 00 20 14 C0 00 06 00 00 00 00 26 D6 00 01 82 C5 00 00 00 05 30 40 14 A0 FF F8 00 46 30 21 12 C4 00 5C 00 00 00 00 10 A0 00 04 00 00 00 00 A2 C0 00 00 8E 82 00 00 26 D6 00 01 82 C5 00 00 00 05 30 40 00 46 48 21 95 29 00 00 31 29 00 20 15 20 FF FA 26 D6 00 01 26 D6 FF FF 10 A0 01 88 00 46 30 21 94 C5 00 00 30 A5 00 20 14 A0 01 84 00 00 00 00 0? ?? ?? ?? 02 C0 28 21 95 26 00 00 30 C6 00 20 14 C0 00 06 00 00 00 00 24 A5 00 01 80 A6 00 00 00 06 48 40 14 C0 FF F8 00 49 48 21 24 02 00 06 11 02 01 55 A0 A0 00 00 2D 02 00 07 14 40 00 B2 24 02 00 07 11 02 00 FD 24 02 00 0A 15 02 00 28 3C 05 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 14 40 00 24 27 A3 00 E4 AF A3 00 F4 27 A3 00 D4 AF A3 00 F0 02 E0 20 21 27 A3 00 D8 24 05 00 2F AE A0 00 00 0? ?? ?? ?? AF A3 00 EC 10 40 00 B1 00 40 F0 21 A0 40 00 00 24 04 00 0A 02 E0 28 21 0? ?? ?? ?? 27 A6 00 B8 10 40 00 12 27 C4 00 01 10 80 00 AE 27 A3 00 C8 00 60 28 21 24 06 00 0A 0? ?? ?? ?? AF A3 00 FC 00 40 40 21 24 02 FF FF 11 02 00 08 8F A3 00 FC 8F A2 00 C8 80 42 00 00 14 40 00 04 00 00 00 00 2D 02 00 81 14 40 00 A5 02 C0 20 21 0? ?? ?? ?? 8E 02 00 00 A2 E0 00 00 82 E5 00 01 8F C2 00 00 00 05 30 40 00 46 30 21 94 C6 00 00 26 F7 00 01 30 C6 00 20 0? ?? ?? ?? 30 C6 FF FF 8E 02 00 00 30 42 00 10 10 40 FF 59 27 A4 00 D0 0? ?? ?? ?? 8F A4 00 D0 0? ?? ?? ?? 02 00 20 21 8F A2 00 DC 14 40 01 33 93 B3 00 E5 8F A2 00 D4 3C 13 ?? ?? 26 73 ?? ?? 10 40 01 61 02 60 80 21 93 B5 00 E4 12 A0 01 EC 00 40 A0 21 00 14 10 C0 00 14 21 40 0? ?? ?? ?? 00 82 20 23 10 40 01 87 00 40 90 21 12 A0 01 E7 02 80 10 21 18 40 00 18 8F A4 00 D8 00 02 18 C0 00 02 11 40 00 43 60 23 00 0C 68 23 00 80 18 21 02 4C 60 21 00 00 10 21 8C 6B 00 00 8C 6A 00 04 8C 69 00 08 8C 68 00 0C 8C 67 00 10 8C 66 00 14 01 82 28 21 AC AB FF E8 AC AA FF EC AC A9 FF F0 AC A8 FF F4 AC A7 FF F8 AC A6 FF FC 24 42 FF E8 14 4D FF F1 8C 63 00 18 14 80 01 64 8F A5 00 D4 3C 07 ?? ?? 02 40 20 21 24 06 00 18 0? ?? ?? ?? 24 E7 ?? ?? 8F A3 00 E8 3C 15 ?? ?? 10 60 01 37 26 B5 ?? ?? 8F A3 00 F8 2C 62 00 01 8F A3 00 E8 00 62 18 21 00 03 10 80 00 03 21 00 00 82 20 23 0? ?? ?? ?? AF A3 00 E8 10 40 01 D2 00 40 A0 21 8F A3 00 F8 14 60 00 0A 8F A2 00 E8 24 42 FF FF 00 02 21 00 00 02 18 80 00 83 18 23 02 83 18 21 24 04 00 0E AC 60 00 00 AC 60 00 04 AC 64 00 08 18 40 00 11 00 02 18 80 00 02 11 00 00 43 40 23 00 08 48 23 02 20 18 21 02 88 40 21 00 00 10 21 8C 67 00 00 8C 66 00 04 8C 65 00 08 01 02 20 21 AC 87 FF F4 AC 86 FF F8 AC 85 FF FC 24 42 FF F4 14 49 FF F7 8C 63 00 0C 16 20 00 04 8F A5 00 E8 0? ?? ?? ?? 3C 07 ?? ?? 02 E0 88 21 8E 37 00 0C 0? ?? ?? ?? 02 20 20 21 16 E0 FF FB 8F A5 00 E8 3C 07 ?? ?? 02 80 20 21 24 06 00 0C 24 E7 ?? ?? 0? ?? ?? ?? 3C 11 ?? ?? 0? ?? ?? ?? 26 31 ?? ?? 24 02 00 05 15 02 FF 78 3C 05 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 14 40 FF 74 27 A3 00 E5 AF A3 00 F4 27 A3 00 DC AF A3 00 F0 02 E0 20 21 27 A3 00 E0 24 05 00 2F AE A0 00 00 0? ?? ?? ?? AF A3 00 EC 14 40 FF 51 00 40 F0 21 24 04 00 0A 02 E0 28 21 0? ?? ?? ?? 27 A6 00 B8 10 40 FF 63 00 00 00 00 8F A2 00 C8 80 42 00 00 14 40 FF 5F 24 08 00 80 27 A3 00 C8 02 C0 20 21 00 60 28 21 24 06 00 0A 0? ?? ?? ?? AF A8 00 FC 00 40 B0 21 24 02 FF FF 12 C2 01 90 8F A8 00 FC 8F A2 00 C8 80 42 00 00 14 40 FF 51 00 00 00 00 06 C0 FF 4F 24 04 00 1C 0? ?? ?? ?? AF A8 00 FC 10 40 01 93 8F A8 00 FC 8F A3 00 F0 2D 07 00 01 AC 48 00 10 8C 65 00 00 8F A3 00 F4 AC 56 00 14 24 A5 00 01 90 64 00 00 8F A3 00 EC 00 E4 20 25 8F A7 00 B8 8C 66 00 00 AC 47 00 00 8F A7 00 BC AC 46 00 18 AC 47 00 04 8F A7 00 C0 AC 47 00 08 8F A7 00 C4 AC 47 00 0C AC 62 00 00 8F A3 00 F0 AC 65 00 00 8F A3 00 F4 A0 64 00 00 0? ?? ?? ?? 8E 02 00 00 0? ?? ?? ?? 02 C0 20 21 3C 05 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 14 40 FF 29 02 E0 20 21 24 05 00 2F 0? ?? ?? ?? AE A0 00 00 10 40 00 03 00 00 F0 21 24 5E 00 01 A0 40 00 00 24 04 00 0A 02 E0 28 21 0? ?? ?? ?? 27 A6 00 B8 10 40 00 F7 8F A2 00 B8 14 40 FF 1A 00 00 00 00 8F A2 00 BC 14 40 FF 17 8F A3 00 C0 34 02 FF FF 14 62 FF 14 00 00 00 00 13 C0 01 53 03 C0 20 21 27 A5 00 C8 0? ?? ?? ?? 24 06 00 0A 00 40 F0 21 24 02 FF FF 13 C2 01 3C 8F A2 00 C8 80 42 00 00 14 40 FF 08 00 00 00 00 2F C2 00 60 14 40 FF 05 00 00 00 00 2F C2 00 81 10 40 FF 02 02 C0 20 21 27 A5 00 C8 0? ?? ?? ?? 24 06 00 0A 00 40 B0 21 24 02 FF FF 12 C2 01 49 24 02 00 22 8F A2 00 C8 80 42 00 00 14 40 FE F7 00 00 00 00 06 C0 FE F5 00 00 00 00 0? ?? ?? ?? 24 04 00 10 10 40 01 39 00 00 00 00 24 04 00 60 13 C4 01 41 24 05 FF FF 00 1E 20 23 00 85 20 04 8F A3 00 E8 8F A6 00 C4 3B C5 00 60 24 63 00 01 AF A3 00 E8 8F A3 00 F8 2C A5 00 01 00 86 30 24 AC 51 00 0C AC 44 00 04 AC 46 00 00 AC 56 00 08 00 65 18 25 00 40 88 21 AF A3 00 F8 0? ?? ?? ?? 8E 02 00 00 3C 02 ?? ?? 0? ?? ?? ?? 24 45 ?? ?? 14 40 FE D6 24 04 00 79 92 E2 00 00 00 82 10 23 14 40 00 15 2C 42 00 01 92 E2 00 01 24 04 00 65 00 82 10 23 14 40 00 10 2C 42 00 01 92 E2 00 02 24 04 00 73 00 82 10 23 14 40 00 0B 2C 42 00 01 92 E2 00 03 3C 03 ?? ?? 2C 42 00 01 10 40 FE C3 AC 62 ?? ?? 3C 02 ?? ?? 24 03 00 01 AC 43 ?? ?? 0? ?? ?? ?? 8E 02 00 00 3C 03 ?? ?? AC 62 ?? ?? 0? ?? ?? ?? 8E 02 00 00 0? ?? ?? ?? 02 C0 28 21 12 60 00 BD 00 40 90 21 00 12 10 C0 00 12 21 40 0? ?? ?? ?? 00 82 20 23 10 40 00 5F 00 40 80 21 12 60 00 C8 00 00 00 00 1A 40 00 18 8F A4 00 E0 00 12 10 C0 00 12 61 40 01 82 60 23 00 0C 68 23 00 80 18 21 02 0C 60 21 00 00 10 21 8C 6B 00 00 8C 6A 00 04 8C 69 00 08 8C 68 00 0C 8C 67 00 10 8C 66 00 14 01 82 28 21 AC AB FF E8 AC AA FF EC AC A9 FF F0 AC A8 FF F4 AC A7 FF F8 AC A6 FF FC 24 42 FF E8 14 4D FF F1 8C 63 00 18 10 80 00 06 8F A5 00 DC 0? ?? ?? ?? 8C 92 00 18 16 40 FF FD 02 40 20 21 8F A5 00 DC 3C 07 ?? ?? 02 00 20 21 24 06 00 18 0? ?? ?? ?? 24 E7 ?? ?? 8F A2 00 D4 3C 13 ?? ?? 14 40 FE A1 26 73 ?? ?? 8F A3 00 E8 3C 15 ?? ?? 26 B5 ?? ?? 14 60 FE CB 02 A0 90 21 3C 11 ?? ?? 26 31 ?? ?? 02 20 A0 21 3C 02 ?? ?? 8C 44 ?? ?? 10 93 00 03 AC 50 ?? ?? 0? ?? ?? ?? 00 00 00 00 3C 02 ?? ?? 8C 44 ?? ?? 10 95 00 03 AC 52 ?? ?? 0? ?? ?? ?? 00 00 00 00 3C 02 ?? ?? 8C 44 ?? ?? 10 91 00 03 AC 54 ?? ?? 0? ?? ?? ?? 00 00 00 00 8F A3 00 60 8F BF 01 24 3C 02 ?? ?? 8F BE 01 20 8F B7 01 1C 8F B6 01 18 8F B5 01 14 8F B4 01 10 8F B3 01 0C 8F B2 01 08 8F B1 01 04 8F B0 01 00 AC 43 ?? ?? 03 E0 00 08 27 BD 01 28 0? ?? ?? ?? 8C 94 00 18 16 80 FF FD 02 80 20 21 0? ?? ?? ?? 8F A5 00 D4 12 13 00 04 8F A4 00 E0 0? ?? ?? ?? 02 00 20 21 8F A4 00 E0 14 80 00 03 00 00 00 00 0? ?? ?? ?? 8F A4 00 D8 0? ?? ?? ?? 8C 90 00 18 16 00 FF FD 02 00 20 21 8F A4 00 D8 10 80 00 05 00 00 00 00 0? ?? ?? ?? 8C 90 00 18 16 00 FF FD 02 00 20 21 12 20 00 06 00 00 00 00 8E 30 00 0C 0? ?? ?? ?? 02 20 20 21 16 00 FF FC 02 00 88 21 0? ?? ?? ?? 00 00 00 00 8F BF 01 24 8F BE 01 20 8F B7 01 1C 8F B6 01 18 8F B5 01 14 8F B4 01 10 8F B3 01 0C 8F B2 01 08 8F B1 01 04 8F B0 01 00 03 E0 00 08 27 BD 01 28 0? ?? ?? ?? 02 E0 B0 21 00 00 40 21 0? ?? ?? ?? 00 00 28 21 0? ?? ?? ?? 00 00 88 21 24 04 00 02 02 E0 28 21 0? ?? ?? ?? 27 A6 00 C4 10 40 FE 20 00 00 00 00 13 C0 00 73 27 A3 00 C8 03 C0 20 21 00 60 28 21 24 06 00 0A 0? ?? ?? ?? AF A3 00 FC 00 40 F0 21 24 02 FF FF 13 C2 FE 15 8F A3 00 FC 8F A2 00 C8 80 42 00 00 14 40 FE 11 00 00 00 00 2F C2 00 21 10 40 FE 0E 00 00 00 00 02 C0 20 21 00 60 28 21 0? ?? ?? ?? 24 06 00 0A 00 40 B0 21 24 02 FF FF 12 C2 00 49 24 02 00 22 8F A2 00 C8 80 42 00 00 14 40 FE 02 00 00 00 00 06 C0 FE 00 00 00 00 00 0? ?? ?? ?? 27 DE 00 60 0? ?? ?? ?? 02 00 20 21 0? ?? ?? ?? 00 00 88 21 24 52 00 01 0? ?? ?? ?? AF B2 00 DC 24 54 00 01 0? ?? ?? ?? AF B4 00 D4 26 82 FF FF 00 02 21 40 00 02 18 C0 00 83 18 23 02 43 18 21 24 04 00 28 AC 60 00 00 AC 60 00 04 AC 60 00 08 AC 60 00 0C AC 60 00 10 0? ?? ?? ?? AC 64 00 14 26 52 FF FF 00 12 19 40 00 12 10 C0 00 62 10 23 02 02 10 21 24 03 00 01 AC 40 00 00 AC 40 00 04 AC 40 00 08 AC 40 00 0C AC 40 00 10 0? ?? ?? ?? AC 43 00 14 12 13 00 03 00 00 00 00 0? ?? ?? ?? 02 00 20 21 12 55 FF 83 00 00 00 00 0? ?? ?? ?? 02 40 20 21 0? ?? ?? ?? 8F A4 00 E0 8E A3 00 00 24 02 00 22 10 62 FD CC 00 00 00 00 8F A2 00 C8 80 42 00 00 10 40 FE C4 00 00 00 00 0? ?? ?? ?? 8E 02 00 00 8E A4 00 00 24 02 00 22 14 82 FE 6E 00 00 00 00 0? ?? ?? ?? 8E 02 00 00 0? ?? ?? ?? 24 1E 00 80 8E A4 00 00 14 82 FF B6 00 00 00 00 0? ?? ?? ?? 8E 02 00 00 0? ?? ?? ?? 8F A4 00 D0 0? ?? ?? ?? 02 00 20 21 0? ?? ?? ?? 8F A4 00 E0 8E A4 00 00 14 82 FE B6 00 00 00 00 0? ?? ?? ?? 8E 02 00 00 0? ?? ?? ?? 00 00 20 21 8F A2 00 C8 80 42 00 00 14 40 FD A8 00 00 00 00 0? ?? ?? ?? 24 1E 00 20 }
	condition:
		$1
}

rule file_1_5_0 {
	meta:
		name = "get_scope"
		size = 228
	strings:
		$1 = { 94 83 00 00 24 02 00 0A 10 62 00 16 24 05 00 02 10 65 00 03 24 02 00 0F 03 E0 00 08 00 00 00 00 3C 02 ?? ?? 8C 43 ?? ?? 8C 86 00 04 8C 65 00 04 8C 64 00 00 00 C5 28 24 10 A4 00 08 24 62 00 0C 8C 45 00 04 00 40 18 21 24 42 00 0C 8C 44 FF F4 00 C5 28 24 14 A4 FF FA 00 00 00 00 03 E0 00 08 8C 62 00 08 90 83 00 08 24 02 00 FF 10 62 00 1A 3C 03 FF C0 8C 82 00 08 3C 05 FE 80 00 43 18 24 10 65 00 13 00 00 00 00 14 40 00 0B 00 00 00 00 8C 82 00 0C 14 40 00 08 00 00 00 00 8C 82 00 10 14 40 00 05 00 00 00 00 8C 84 00 14 24 02 00 01 10 82 00 07 00 00 00 00 3C 04 FE C0 00 64 18 26 24 02 00 05 24 04 00 0E 03 E0 00 08 00 83 10 0B 03 E0 00 08 24 02 00 02 90 82 00 09 03 E0 00 08 30 42 00 0F }
	condition:
		$1
}

rule file_1_6_0 {
	meta:
		name = "rfc3484_sort"
		size = 1636
		refs = "0340 __check_native 0398 $LC6 03a4 $LC7 03b8 __assert_fail 03a8 __PRETTY_FUNCTION__.13532 03d0 $LC8 05f0 $LC10 060c $LC9 0628 $LC12 0648 $LC11"
	strings:
		$1 = { 27 BD FF B8 AF B2 00 28 8C 92 00 00 AF B3 00 2C AF B1 00 24 8C B3 00 00 00 12 18 80 00 12 89 00 8C C2 00 00 02 23 88 23 02 32 88 23 00 13 18 80 AF B0 00 20 00 11 88 80 00 13 81 00 00 51 88 21 02 03 80 23 02 13 80 23 92 23 00 21 00 10 80 80 00 50 80 21 AF B6 00 38 AF BF 00 44 AF BE 00 40 AF B7 00 3C AF B5 00 34 AF B4 00 30 00 C0 B0 21 10 60 00 40 92 02 00 21 10 40 00 96 26 2D 00 04 8E 22 00 00 26 0E 00 04 8C 47 00 14 0? ?? ?? ?? 00 E0 20 21 8E 03 00 00 00 40 A0 21 0? ?? ?? ?? 8C 64 00 14 01 A0 20 21 0? ?? ?? ?? 00 40 A8 21 01 C0 20 21 0? ?? ?? ?? 00 40 40 21 12 88 00 97 00 00 00 00 12 A2 00 6B 8F BF 00 44 92 22 00 22 30 43 00 01 14 60 00 73 00 00 00 00 92 03 00 22 30 64 00 01 14 80 00 7B 30 42 00 02 10 40 00 73 30 63 00 02 10 60 00 78 24 02 FF FF 3C 02 ?? ?? 8C 4C ?? ?? 3C 0B 7F FF 00 E0 20 21 01 80 28 21 0? ?? ?? ?? 35 66 FF FF 01 80 28 21 35 66 FF FF 01 A0 20 21 0? ?? ?? ?? 00 40 78 21 8E 03 00 00 01 80 28 21 35 66 FF FF 8C 64 00 14 0? ?? ?? ?? 00 40 68 21 35 66 FF FF 01 C0 20 21 01 80 28 21 0? ?? ?? ?? 00 40 58 21 11 ED 00 6B 00 00 00 00 11 62 00 44 8F BF 00 44 8E 22 00 00 0? ?? ?? ?? 8C 47 00 14 14 40 00 3F 8F BF 00 44 8E 22 00 00 8C 47 00 14 0? ?? ?? ?? 00 E0 20 21 8E 03 00 00 00 40 A0 21 0? ?? ?? ?? 8C 64 00 14 00 40 A8 21 3C 02 ?? ?? 8C 4B ?? ?? 00 E0 20 21 00 00 30 21 0? ?? ?? ?? 01 60 28 21 8E 03 00 00 01 60 28 21 00 00 30 21 8C 64 00 14 0? ?? ?? ?? 00 40 58 21 00 4B 18 2A 14 60 00 3F 01 62 58 2A 15 60 00 25 8F BF 00 44 92 22 00 21 10 40 00 11 02 95 10 2A 8E 37 00 24 8E 1E 00 24 12 FE 00 0C 24 02 FF FF 8E 26 00 28 8E 09 00 28 AF A6 00 1C 10 C2 00 A2 AF A9 00 18 11 22 00 45 00 00 00 00 14 C0 00 2B 00 00 00 00 15 20 00 13 8F BF 00 44 02 95 10 2A 14 40 00 28 02 B4 A0 2A 16 80 00 0E 8F BF 00 44 92 22 00 21 10 40 00 07 00 00 00 00 8E 24 00 00 8E 03 00 00 8C 82 00 04 8C 65 00 04 10 45 00 66 24 05 00 02 02 53 90 2B 16 40 00 1B 24 02 FF FF 8F BF 00 44 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 24 02 00 01 03 E0 00 08 27 BD 00 48 92 03 00 22 30 64 00 01 10 80 FF F0 30 42 00 02 14 40 FF 8F 30 63 00 02 10 60 FF 90 3C 02 ?? ?? 0? ?? ?? ?? 8F BF 00 44 15 20 FF D8 02 95 10 2A 24 02 FF FF 8F BF 00 44 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 48 15 62 FF F3 24 02 FF FF 8E 22 00 00 0? ?? ?? ?? 8C 47 00 14 12 A2 FF 6B 24 02 FF FF 0? ?? ?? ?? 8F BF 00 44 24 17 FF FF AF A0 00 18 03 C0 30 21 02 E0 20 21 27 A5 00 1C 0? ?? ?? ?? 27 A7 00 18 8E C2 00 04 8F A6 00 1C 18 40 FF B2 8F A9 00 18 8E C3 00 00 00 00 28 21 0? ?? ?? ?? 24 08 FF FF 13 C7 00 15 00 00 00 00 24 A5 00 01 10 A2 FF A9 24 63 00 2C 8C 67 00 24 14 F7 FF F9 00 00 00 00 8C 64 00 28 10 88 00 03 00 00 00 00 14 86 00 03 3C 04 ?? ?? 0? ?? ?? ?? AC 66 00 28 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 06 CD 0? ?? ?? ?? 24 E7 ?? ?? 8C 64 00 28 10 88 00 03 00 00 00 00 14 89 00 03 3C 04 ?? ?? 0? ?? ?? ?? AC 69 00 28 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 06 D3 0? ?? ?? ?? 24 E7 ?? ?? 10 45 00 2B 24 05 00 0A 10 45 00 08 00 00 00 00 00 00 18 21 00 00 10 21 00 43 10 2A 10 40 FF 94 02 53 90 2B 0? ?? ?? ?? 8F BF 00 44 96 25 00 04 14 A2 00 87 3C 07 ?? ?? 96 02 00 04 14 45 00 7C 00 00 10 21 8C 87 00 14 8C 68 00 14 00 00 28 21 26 2D 00 04 26 0A 00 04 24 09 00 04 00 E2 20 21 01 A2 18 21 8C 84 00 08 8C 63 00 08 14 83 00 45 00 83 30 26 01 02 30 21 01 42 18 21 8C C6 00 08 8C 63 00 08 14 C3 00 3E 00 80 18 21 24 A5 00 01 14 A9 FF F2 24 42 00 04 0? ?? ?? ?? 00 00 18 21 11 26 FF A5 AF A0 00 1C 0? ?? ?? ?? 24 1E FF FF 96 25 00 04 14 A2 00 57 3C 07 ?? ?? 96 02 00 04 14 45 00 4D 3C 05 ?? ?? 8C 84 00 14 92 22 00 23 8E 26 00 08 8C 84 00 04 00 02 10 23 00 C4 30 26 24 04 FF FF 00 44 20 04 00 86 20 24 14 80 00 0A 00 00 10 21 3C 04 80 00 0? ?? ?? ?? 24 07 00 20 10 47 00 05 00 04 20 42 00 86 28 24 10 A0 FF FC 24 42 00 01 24 42 FF FF 8C 64 00 14 8E 06 00 08 92 03 00 23 8C 84 00 04 00 03 18 23 00 C4 30 26 24 04 FF FF 00 64 18 04 00 66 18 24 14 60 00 0E 3C 04 80 00 0? ?? ?? ?? 24 07 00 20 10 67 FF B2 00 04 20 42 00 86 28 24 10 A0 FF FC 24 63 00 01 24 63 FF FF 00 62 20 2A 10 80 FF AB 00 00 00 00 0? ?? ?? ?? 24 02 FF FF 0? ?? ?? ?? 00 00 18 21 00 83 30 26 00 00 10 21 3C 03 80 00 0? ?? ?? ?? 24 07 00 20 10 47 00 05 00 03 18 42 00 66 20 24 10 80 FF FC 24 42 00 01 24 42 FF FF 24 A3 00 02 00 03 18 80 02 03 80 21 01 03 18 21 8C 65 00 00 8E 06 00 04 00 00 18 21 3C 04 80 00 00 C5 30 26 0? ?? ?? ?? 24 07 00 20 10 67 FF 8F 00 04 20 42 00 86 28 24 10 A0 FF FC 24 63 00 01 24 63 FF FF 0? ?? ?? ?? 00 62 20 2A 3C 04 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 06 F1 0? ?? ?? ?? 24 E7 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 06 F0 0? ?? ?? ?? 24 E7 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 07 10 0? ?? ?? ?? 24 E7 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 07 0F 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_1_7_0 {
	meta:
		name = "gaih_inet_serv.isra.4"
		size = 304
		refs = "0070 __getservbyname_r"
	strings:
		$1 = { 27 BD FF A0 AF BE 00 58 AF B6 00 54 AF B5 00 50 AF B4 00 4C AF B3 00 48 AF B2 00 44 AF B1 00 40 AF B0 00 3C AF BF 00 5C 03 A0 F0 21 00 A0 98 21 00 80 90 21 00 C0 B0 21 00 E0 A0 21 24 B1 00 0A 24 10 04 00 24 15 00 22 26 02 00 0E 00 02 10 C2 00 02 10 C0 03 A2 E8 23 27 C2 00 30 AF B0 00 10 AF A2 00 14 02 40 20 21 02 20 28 21 27 C6 00 20 0? ?? ?? ?? 27 A7 00 18 14 40 00 1C 00 00 00 00 8F C2 00 30 10 40 00 1B 00 00 00 00 8E 63 00 00 AE 80 00 00 AE 83 00 04 92 63 00 08 30 63 00 02 10 60 00 21 00 00 00 00 8E C4 00 00 8C 43 00 08 AE 84 00 08 00 00 10 21 AE 83 00 0C 03 C0 E8 21 8F BF 00 5C 8F BE 00 58 8F B6 00 54 8F B5 00 50 8F B4 00 4C 8F B3 00 48 8F B2 00 44 8F B1 00 40 8F B0 00 3C 03 E0 00 08 27 BD 00 60 10 55 FF D6 00 10 80 40 03 C0 E8 21 8F DF 00 5C 8F BE 00 58 8F B6 00 54 8F B5 00 50 8F B4 00 4C 8F B3 00 48 8F B2 00 44 8F B1 00 40 8F B0 00 3C 24 02 01 08 03 E0 00 08 27 BD 00 60 0? ?? ?? ?? 8E 64 00 04 }
	condition:
		$1
}

rule file_1_8_0 {
	meta:
		name = "gaih_inet"
		size = 8816
		refs = "0014 __gnu_local_gp 026c __idna_to_ascii_lz 02bc __inet_aton 0388 malloc 0438 strchr 0450 inet_pton 04d0 free 0660 strtoul 06c0 __nss_not_use_nscd_hosts 06e4 __nss_hosts_database 06fc _res_hconf 070c __libc_resp 072c __res_maybe_init 078c __libc_errno 07f4 $LC17 07fc __nss_lookup_function 082c __libc_h_errno 0888 $LC15 08bc _dl_mcount_wrapper_check 0af8 in6addr_loopback 0b90 __idna_to_unicode_lzlz 0bd4 realloc 0fe8 __nss_database_custom 1004 __nscd_getai 11a4 strlen 11fc memcpy 14a0 $LC18 07f0 $LC16 160c __gethostbyname2_r 16bc if_nametoindex 19d8 __strdup 1a0c __libc_alloca_cutoff 06f0 $LC13 1c3c $LC14 1c4c __nss_database_lookup 1cc0 __gethostbyaddr_r 1df8 $LC19 1dfc $LC7 1e10 __assert_fail 1e00 __PRETTY_FUNCTION__.13266 1fe0 _res_hconf_init 21a8 mempcpy 2234 __strndup"
	strings:
		$1 = { 27 BD FF 10 AF B7 00 E4 00 C0 B8 21 8C C6 00 0C AF B0 00 C8 3C 1C ?? ?? 3C 10 ?? ?? AF BE 00 E8 27 9C ?? ?? 03 A0 F0 21 26 10 ?? ?? AF B6 00 E0 AF B1 00 CC AF C4 00 F0 AF BF 00 EC AF B5 00 DC AF B4 00 D8 AF B3 00 D4 AF B2 00 D0 AF DC 00 28 00 A0 88 21 00 E0 B0 21 AF D0 00 58 AF C0 00 54 14 C0 00 03 8E E4 00 08 10 80 00 2B 3C 02 ?? ?? 3C 02 ?? ?? 24 42 ?? ?? 10 80 00 16 00 00 00 00 8C 43 00 00 10 64 00 13 00 00 00 00 24 42 00 14 80 43 00 0A 14 60 FF F8 00 00 00 00 24 02 01 07 03 C0 E8 21 8F BF 00 EC 8F BE 00 E8 8F B7 00 E4 8F B6 00 E0 8F B5 00 DC 8F B4 00 D8 8F B3 00 D4 8F B2 00 D0 8F B1 00 CC 8F B0 00 C8 03 E0 00 08 27 BD 00 F0 10 C0 00 11 00 00 00 00 90 43 00 08 30 63 00 02 14 60 00 0D 00 00 00 00 8C 43 00 04 10 C3 00 0A 00 00 00 00 24 42 00 14 80 43 00 0A 14 60 FF DD 00 00 00 00 10 80 00 0B 24 02 01 08 0? ?? ?? ?? 24 02 01 07 24 42 ?? ?? 12 20 00 16 00 00 28 21 90 43 00 08 30 63 00 01 10 60 00 0F 00 00 00 00 24 02 01 08 03 C0 E8 21 8F BF 00 EC 8F BE 00 E8 8F B7 00 E4 8F B6 00 E0 8F B5 00 DC 8F B4 00 D8 8F B3 00 D4 8F B2 00 D0 8F B1 00 CC 8F B0 00 C8 03 E0 00 08 27 BD 00 F0 8E 25 00 04 04 A0 00 E0 00 00 00 00 14 80 00 1C 00 00 00 00 14 C0 00 1A 00 00 00 00 80 43 00 1E 10 60 04 B2 24 42 00 14 27 C4 00 58 0? ?? ?? ?? 00 00 30 21 24 42 00 14 80 43 00 0A 10 60 00 9D 00 00 00 00 90 43 00 09 10 60 FF FA 00 00 00 00 8C 48 00 00 8C 47 00 04 27 BD FF E8 27 A3 00 28 AF A0 00 28 AF A8 00 2C AF A7 00 30 AF A5 00 34 24 C6 00 10 AC 83 00 00 0? ?? ?? ?? 00 60 20 21 90 44 00 08 8C 47 00 00 27 BD FF E8 27 A3 00 28 30 84 00 02 AF C3 00 58 AC 60 00 00 14 80 00 02 AC 67 00 04 8C 46 00 04 AC 66 00 08 AC 65 00 0C 24 19 00 30 AF D9 00 7C 8F D9 00 F0 13 20 02 01 00 00 00 00 8E E3 00 00 27 BD FF D8 27 A2 00 28 30 64 00 40 AF C2 00 54 AC 40 00 08 AC 40 00 1C 10 80 00 A4 AC 40 00 00 7C 62 02 00 34 46 00 02 30 63 02 00 00 43 30 0A 03 20 20 21 27 C5 00 30 0? ?? ?? ?? AF C0 00 30 00 40 18 21 10 40 00 08 AF C2 00 50 24 02 00 C9 10 62 02 BE 38 63 00 CA 24 02 00 0B 24 04 00 69 0? ?? ?? ?? 00 83 10 0B 8F D9 00 30 8F C2 00 F0 8F C5 00 54 AF D9 00 64 00 59 18 26 00 03 18 2B AF C3 00 88 8F C4 00 64 0? ?? ?? ?? 24 A5 00 0C 10 40 00 59 8F D0 00 54 8E E2 00 04 24 03 FF FD 00 43 18 24 14 60 00 B9 24 03 00 0A 8F D0 00 54 24 02 00 02 8E E3 00 00 AE 02 00 08 8F D9 00 64 30 63 00 02 00 03 C8 0A AF D9 00 80 00 00 A8 21 AF C0 00 74 AF C0 00 84 AF C0 00 78 AF C0 00 70 AF C0 00 6C AF C0 00 8C 8F D2 00 80 02 00 98 21 AF D5 00 68 12 70 02 0A 00 00 00 00 8E 15 00 08 24 02 00 0A 32 B4 FF FF 12 82 01 AA 24 11 00 10 8F D3 00 58 12 60 01 88 26 23 00 20 AF C3 00 60 0? ?? ?? ?? 32 B5 FF FF 26 04 00 0C A4 45 00 22 88 85 00 00 98 85 00 03 AC 40 00 28 AC 40 00 2C AC 45 00 24 8E 73 00 00 24 56 00 1C 12 60 01 7A 00 00 90 21 0? ?? ?? ?? 8F C4 00 60 10 40 01 7F AE C2 00 00 8E 65 00 08 8E 67 00 04 8E E8 00 00 24 44 00 20 AC 44 00 14 24 04 00 0A AC 45 00 0C AC 55 00 04 AC 48 00 00 AC 47 00 08 AC 51 00 10 AC 52 00 18 A4 54 00 20 AC 40 00 1C 16 84 FF E2 8E 65 00 0C 26 04 00 0C AC 40 00 24 A4 45 00 22 88 89 00 00 88 88 00 04 88 87 00 08 88 85 00 0C 98 89 00 03 98 88 00 07 98 87 00 0B 98 85 00 0F AC 49 00 28 AC 48 00 2C AC 47 00 30 AC 45 00 34 8E 04 00 1C 0? ?? ?? ?? AC 44 00 38 24 C6 00 20 0? ?? ?? ?? AF C6 00 7C 8E 02 00 08 14 40 00 61 8F C4 00 64 0? ?? ?? ?? 24 05 00 25 14 40 07 2D 00 40 88 21 8F C5 00 64 24 04 00 0A 0? ?? ?? ?? 26 06 00 0C 8F DC 00 28 18 40 02 8F 00 00 00 00 8E E3 00 04 10 60 02 36 24 02 00 0A 10 62 02 34 24 02 00 02 10 62 00 60 8F C2 00 54 24 12 00 09 00 00 A8 21 AF C0 00 74 AF C0 00 84 AF C0 00 78 AF C0 00 70 AF C0 00 6C 8F D9 00 88 17 20 01 49 00 00 00 00 8F D9 00 6C 17 20 01 42 00 00 00 00 8F D9 00 78 17 20 01 3B 00 00 00 00 8F D9 00 74 13 20 FF 1C 02 40 10 21 02 A0 20 21 0? ?? ?? ?? AF D2 00 AC 0? ?? ?? ?? 8F C2 00 AC 8F D9 00 F0 00 40 28 21 AF C0 00 88 0? ?? ?? ?? AF D9 00 64 80 43 00 0A 14 60 02 16 00 40 28 21 80 43 00 1E 10 60 FF 0B 24 54 00 14 27 C3 00 58 00 00 98 21 AF C3 00 60 26 F2 00 0C 0? ?? ?? ?? 02 60 A8 21 8E 84 00 00 10 64 00 0C 00 00 00 00 26 94 00 14 82 82 00 0A 10 40 01 FE 8F C2 00 58 92 82 00 08 30 43 00 01 14 60 FF F9 00 00 00 00 8E E3 00 08 14 60 FF F3 00 00 00 00 8E E3 00 0C 10 60 00 06 30 42 00 02 14 40 00 04 00 00 00 00 8E 82 00 04 14 62 FF EE 00 00 00 00 27 BD FF E8 8E 24 00 00 27 B3 00 28 02 80 28 21 02 40 30 21 0? ?? ?? ?? 02 60 38 21 26 B5 00 10 10 40 01 0E AF C2 00 50 30 43 01 00 14 60 FF E2 26 94 00 14 0? ?? ?? ?? 03 C0 E8 21 0? ?? ?? ?? AF C0 00 80 14 43 FF B0 24 12 00 09 8E E3 00 00 30 64 00 08 10 80 FF AD 00 00 A8 21 8F D0 00 54 34 05 FF FF 8E 04 00 0C AE 05 00 14 AE 00 00 10 AE 04 00 18 AE 00 00 0C 0? ?? ?? ?? AE 02 00 08 8C 44 00 0C 14 80 FF A0 24 12 00 09 8C 44 00 10 14 80 FF 9E 00 00 A8 21 8C 45 00 14 34 04 FF FF 14 A4 FF 9A 00 00 00 00 8C 44 00 18 AC 43 00 08 00 40 80 21 AC 44 00 0C 12 20 00 13 3C 02 FF C0 8E 03 00 0C 00 62 18 24 3C 02 FE 80 10 62 04 1B 24 02 00 FF 92 03 00 0C 10 62 04 13 26 24 00 01 27 C5 00 30 0? ?? ?? ?? 24 06 00 0A 8F C3 00 30 8F DC 00 28 AE 02 00 1C 80 62 00 00 14 40 01 5D 00 00 00 00 8F D0 00 54 8E E2 00 00 30 42 00 02 14 40 03 6F 8F D9 00 64 8E 02 00 08 AF C0 00 80 14 40 FF 18 00 00 00 00 8E E2 00 00 30 42 00 04 14 40 01 50 24 02 00 02 8E E3 00 04 10 62 03 C0 AF C0 00 4C 3C 10 ?? ?? 8E 02 ?? ?? 18 40 03 A7 00 00 00 00 24 42 00 01 28 43 00 65 10 60 02 42 00 00 00 00 AE 02 ?? ?? 3C 02 ?? ?? 8C 42 ?? ?? 10 40 05 53 3C 04 ?? ?? AF C2 00 4C 00 00 80 21 3C 02 ?? ?? 8C 42 ?? ?? 10 40 06 36 00 00 00 00 8F 99 ?? ?? 7C 03 E8 3B 00 00 28 21 03 23 88 21 AF D9 00 94 8F D9 00 7C 8E 24 00 00 27 39 04 20 0? ?? ?? ?? AF D9 00 68 8E 32 00 00 24 11 DF FF 34 03 80 01 8E 59 00 08 00 02 10 27 24 04 00 01 03 31 88 24 AF D9 00 90 8F D9 00 68 8F DC 00 28 00 82 80 0A 03 23 18 2B 10 60 06 06 AE 51 00 08 27 BD FB D8 27 B5 00 28 AF C0 00 74 16 00 05 B1 24 19 FF FF 7C 03 E8 3B AF C3 00 98 AF D9 00 7C 8F 82 ?? ?? 8F D9 00 98 AF D7 00 70 00 00 40 21 00 59 10 21 8F D9 00 70 27 D2 00 54 AF D6 00 9C 8F 39 00 04 8F C4 00 4C 24 11 04 20 24 03 FF FF AF C0 00 84 AF C0 00 78 AF C0 00 8C AF C2 00 A8 01 00 98 21 8F D7 00 74 02 40 B0 21 13 20 00 2B AF D9 00 6C 8F D9 00 70 8F 22 00 00 30 42 00 02 14 40 03 62 3C 02 ?? ?? 3C 05 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? AF C3 00 C4 00 40 80 21 8F DC 00 28 14 40 01 8D 8F C3 00 C4 8F D9 00 A8 24 02 FF FD 8F 23 00 00 00 62 10 24 10 40 05 01 24 19 00 01 8F 82 ?? ?? 8F D9 00 98 24 03 00 01 AF C3 00 6C 00 59 10 21 24 03 FF FF AC 43 00 00 00 00 A0 21 8F D9 00 6C 8F C2 00 4C 00 19 20 80 00 44 20 21 8C 85 00 04 24 04 00 01 10 A4 01 57 8F D9 00 94 8C 44 00 00 10 80 01 53 8F D9 00 70 AF C4 00 4C 8F 39 00 04 17 20 FF D7 AF D9 00 6C 3C 05 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? AF C3 00 C4 27 D9 00 50 00 40 80 21 27 D2 00 30 AF D9 00 60 10 40 05 63 8F C3 00 C4 24 14 00 01 24 13 FF FE 02 00 20 21 0? ?? ?? ?? AF C0 00 50 8F C3 00 60 8F C4 00 64 AF B2 00 14 AF A3 00 10 AF A0 00 18 02 C0 28 21 02 A0 30 21 02 00 C8 21 03 20 F8 09 02 20 38 21 10 54 00 D0 8F DC 00 28 14 53 00 C6 24 04 00 22 8F C3 00 50 14 64 01 09 24 05 FF FF 8F C3 00 30 14 65 00 FE 00 60 20 21 16 E0 00 AE 02 A0 20 21 8F D9 00 68 00 11 18 40 34 04 80 01 00 79 28 21 00 A4 10 2B 10 40 05 4A 00 A0 20 21 24 02 FF F0 24 63 00 0F 00 62 18 24 24 62 00 08 03 A2 E8 23 27 A2 00 28 00 43 20 21 12 A4 00 AA 00 00 00 00 00 60 88 21 AF C5 00 68 0? ?? ?? ?? 00 40 A8 21 8F C5 01 00 8C A2 00 00 24 42 00 01 AC A2 00 00 8E 10 00 00 12 00 04 B7 8F D3 00 54 0? ?? ?? ?? 00 00 00 00 02 40 20 21 8F D5 00 68 0? ?? ?? ?? 24 12 00 0A 0? ?? ?? ?? 8F D9 00 88 0? ?? ?? ?? 8F C4 00 84 0? ?? ?? ?? 8F D9 00 74 0? ?? ?? ?? 8F C4 00 70 0? ?? ?? ?? 8F D9 00 78 0? ?? ?? ?? 8F C4 00 64 0? ?? ?? ?? 8F D9 00 6C 8F D9 00 60 AF D3 00 60 0? ?? ?? ?? AF 33 00 00 8F D9 00 8C 13 20 00 76 24 02 00 08 8E E3 00 00 30 63 00 18 14 62 FE 51 24 11 00 1C 8E 02 00 0C 14 40 FE 4F 8F D3 00 58 8E 02 00 10 14 40 FE 4C 34 02 FF FF 8E 03 00 14 14 62 FE 49 00 00 00 00 0? ?? ?? ?? 8E 10 00 00 27 BD FF D8 27 A2 00 28 AC 40 00 00 AC 40 00 04 AC 40 00 08 AC 40 00 0C AC 40 00 10 AC 40 00 14 AC 40 00 18 AC 40 00 1C 8E E3 00 04 10 60 00 15 AF C2 00 54 24 04 00 0A 10 64 00 1E 00 00 00 00 24 04 00 02 10 64 00 2D 00 00 00 00 8F D0 00 54 12 00 04 05 00 00 90 21 AF C0 00 80 AF C0 00 64 00 00 A8 21 AF C0 00 74 AF C0 00 84 AF C0 00 78 AF C0 00 70 AF C0 00 6C AF C0 00 88 0? ?? ?? ?? AF C0 00 8C 27 BD FF D8 27 A4 00 28 AC 44 00 00 AF A0 00 28 AF A0 00 2C AF A0 00 30 AF A0 00 34 AF A0 00 38 AF A0 00 3C AF A0 00 40 14 60 FF E1 AF A0 00 44 8E E4 00 00 24 05 00 0A 30 84 00 01 14 80 00 0C AC 45 00 08 3C 04 ?? ?? 24 83 ?? ?? 8C 86 ?? ?? 8C 65 00 04 8C 64 00 08 8C 63 00 0C AC 46 00 0C AC 45 00 10 AC 44 00 14 AC 43 00 18 8E E3 00 04 14 60 FF D2 8C 42 00 00 8E E3 00 00 24 04 00 02 AC 44 00 08 30 63 00 01 14 60 FF D0 8F D0 00 54 3C 03 7F 00 24 63 00 01 0? ?? ?? ?? AC 43 00 0C 8E E2 00 00 30 43 00 02 10 60 FD F4 00 00 00 00 12 40 04 41 00 00 A0 21 00 00 88 21 30 43 00 80 10 60 02 3B 8F D9 00 78 7C 43 02 00 34 66 00 02 30 42 02 00 02 40 20 21 27 C5 00 30 0? ?? ?? ?? 00 62 30 0A 14 40 05 24 8F D5 00 68 8F C2 00 30 10 52 02 2F 8F D9 00 78 00 40 90 21 12 20 FD DF 00 00 00 00 0? ?? ?? ?? 02 80 20 21 0? ?? ?? ?? 8E 15 00 08 0? ?? ?? ?? 24 11 00 1C 00 11 88 40 0? ?? ?? ?? 02 20 28 21 10 40 00 6B 8F D9 00 94 24 17 00 01 0? ?? ?? ?? 00 40 A8 21 24 12 01 02 00 00 A8 21 0? ?? ?? ?? AF C0 00 74 02 23 88 21 AF C5 00 68 0? ?? ?? ?? 00 40 A8 21 00 40 18 21 8F C2 00 30 24 79 00 02 AF D9 00 6C 38 42 00 04 2C 54 00 01 0? ?? ?? ?? 02 80 98 21 8F D9 00 70 00 40 18 21 8F 22 00 00 30 42 00 02 14 40 00 9A 8F D9 00 80 8E C2 00 00 8F C9 00 70 24 14 00 01 24 06 00 02 24 07 00 0A 34 08 FF FF 10 40 00 26 24 19 00 03 8C 44 00 08 10 86 00 08 8D 25 00 04 10 A0 00 1D 00 00 00 00 10 85 00 14 00 00 00 00 8C 42 00 00 0? ?? ?? ?? AE C2 00 00 14 A7 FF F8 00 00 00 00 8D 24 00 00 30 84 00 08 10 80 FF F8 00 00 00 00 8C 44 00 0C AC 47 00 08 AC 48 00 14 AC 44 00 18 AC 40 00 10 AC 40 00 0C 00 40 B0 21 00 00 A0 21 0? ?? ?? ?? 8C 42 00 00 00 40 B0 21 00 00 A0 21 14 87 FF E1 8C 42 00 00 24 19 00 01 0? ?? ?? ?? AF D9 00 8C 00 40 B0 21 00 00 A0 21 0? ?? ?? ?? 8C 42 00 00 AF D9 00 6C 0? ?? ?? ?? 02 80 98 21 00 40 18 21 00 80 10 21 24 04 00 02 14 44 FF C3 38 42 00 04 24 14 FF FD 0? ?? ?? ?? 02 80 98 21 00 40 18 21 0? ?? ?? ?? 8F C2 00 30 10 50 FC FF 26 B3 00 20 0? ?? ?? ?? AF D3 00 7C 8F D0 00 54 24 02 00 0A 0? ?? ?? ?? AE 02 00 08 27 BD FF E8 8E 24 00 00 27 A3 00 28 26 E6 00 0C 00 60 38 21 0? ?? ?? ?? AF C3 00 58 10 40 FD 2A AF C2 00 50 0? ?? ?? ?? 03 C0 E8 21 0? ?? ?? ?? 24 02 00 0A 8F D9 00 94 7C 03 E8 3B AF D7 00 74 03 23 10 21 8C 42 00 00 8F D9 00 90 24 12 00 0A 8C 44 00 08 33 23 20 00 AF C0 00 70 00 83 18 25 AF C0 00 6C 0? ?? ?? ?? AC 43 00 08 8F D9 00 94 7C 03 E8 3B AF D7 00 74 03 23 10 21 8C 42 00 00 8F D7 00 70 8F D6 00 9C 8C 51 00 08 02 60 40 21 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 8F D9 00 90 00 64 20 21 33 25 20 00 8C 83 00 00 02 25 88 25 AC 51 00 08 24 02 FF FF 10 62 03 1F 24 12 01 0B 12 80 03 0E 8F D0 00 54 11 00 03 0C 24 02 FF FD 16 82 FD 9B 24 12 01 05 01 14 50 26 24 02 00 03 00 4A 90 0A AF C0 00 70 0? ?? ?? ?? AF C0 00 6C 8F D9 00 70 24 04 00 0A 8F 22 00 04 10 44 00 1B 00 00 00 00 10 40 00 19 24 04 00 02 10 44 04 9A 27 D9 00 50 00 00 A0 21 8F D9 00 7C 24 02 00 01 13 22 01 7F 00 00 00 00 10 62 01 7D 24 02 FF FE 13 22 03 07 24 02 FF FF 10 62 03 AA 24 79 00 02 0? ?? ?? ?? AF D9 00 6C 8F D0 00 54 AF C0 00 80 0? ?? ?? ?? 8E 02 00 08 17 20 FF 67 8E C2 00 00 8C 59 00 04 0? ?? ?? ?? AF D9 00 80 27 C3 00 44 27 D9 00 50 AF D7 00 74 AF D6 00 7C AF C0 00 44 27 D2 00 30 27 D3 00 48 AF C3 00 6C AF D9 00 60 24 14 00 22 8F D6 00 64 0? ?? ?? ?? 00 60 B8 21 8F C4 00 48 24 03 FF FF 14 83 01 A7 00 40 18 21 00 11 10 40 24 04 FF F0 24 42 00 0F 00 44 10 24 24 43 00 08 03 A3 E8 23 27 A3 00 28 00 62 20 21 02 A4 A8 26 00 51 88 21 00 55 88 0B 00 60 A8 21 02 00 20 21 0? ?? ?? ?? AF C0 00 50 8F C3 00 60 02 C0 20 21 AF B1 00 10 AF A3 00 14 AF B3 00 18 AF A0 00 1C AF B7 00 20 24 05 00 0A 02 40 30 21 02 00 C8 21 03 20 F8 09 02 A0 38 21 8F C4 00 50 10 94 FF DF 8F DC 00 28 8F D6 00 7C 00 40 18 21 AF C2 00 7C 24 02 00 01 10 62 02 44 8F D7 00 74 10 80 00 C5 00 00 A0 21 8F C4 00 48 24 02 FF FF 14 82 04 1F 8F D9 00 94 7C 03 E8 3B 00 60 10 21 03 23 18 21 8C 63 00 00 8F D9 00 90 8F 87 ?? ?? 8C 66 00 08 33 25 20 00 00 E2 10 21 AC 44 00 00 00 C5 10 25 AC 62 00 08 0? ?? ?? ?? 24 02 00 0B AE 00 ?? ?? 3C 02 ?? ?? 90 42 ?? ?? 14 40 FD BD 3C 02 ?? ?? 8F C4 00 64 27 C5 00 44 }
	condition:
		$1
}

rule file_1_9_0 {
	meta:
		name = "freeaddrinfo"
		size = 80
		refs = "0024 free"
	strings:
		$1 = { 27 BD FF D8 AF B0 00 1C AF BF 00 24 AF B1 00 20 14 80 00 03 00 80 80 21 0? ?? ?? ?? 8F BF 00 24 8E 04 00 18 0? ?? ?? ?? 8E 11 00 1C 0? ?? ?? ?? 02 00 20 21 16 20 FF FA 02 20 80 21 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_1_10_0 {
	meta:
		name = "getaddrinfo"
		size = 2884
		refs = "0004 __gnu_local_gp 0150 __pthread_once 01e8 qsort 020c __libc_errno 02bc __connect 0384 __socket 03b0 memcmp 03c8 memcpy 0400 __getsockname 05f0 __check_pf 06d4 qsort_r 0774 __free_in6ai 07d0 strtoul 0874 $LC21 0878 $LC7 088c __assert_fail 087c __PRETTY_FUNCTION__.13804 0898 freeaddrinfo 08f4 free 030c $LC20 09fc __lll_lock_wait_private 0ac4 __libc_alloca_cutoff 0ad4 malloc 0a1c $LC0 0b14 __xstat64"
	strings:
		$1 = { 27 BD FE 88 3C 1C ?? ?? 27 9C ?? ?? AF BE 01 70 03 A0 F0 21 AF B3 01 5C AF B2 01 58 AF B1 01 54 AF BF 01 74 AF B7 01 6C AF B6 01 68 AF B5 01 64 AF B4 01 60 AF B0 01 50 AF DC 00 18 00 80 98 21 00 A0 90 21 00 C0 88 21 AF C7 01 84 10 80 00 05 AF C0 00 FC 80 83 00 00 24 02 00 2A 10 62 01 88 00 00 00 00 12 40 01 7F 24 02 00 2A 82 43 00 00 10 62 01 79 00 00 00 00 12 20 01 7E 00 00 00 00 8E 22 00 00 24 03 F8 00 00 43 18 24 14 60 02 3D AF C3 01 24 30 43 00 02 10 60 00 03 00 00 00 00 12 60 02 30 00 00 00 00 30 42 00 20 AF C0 00 F8 AF C0 00 F4 A3 C0 01 01 A3 C0 01 00 14 40 01 49 00 00 80 21 12 40 01 E9 00 00 00 00 82 42 00 00 14 40 01 BC 00 00 28 21 8E 22 00 04 24 03 FF FD 00 43 18 24 10 60 00 04 AF C0 00 F0 24 03 00 0A 14 43 02 17 8F C4 00 F8 27 C2 00 F0 AF A2 00 10 02 60 20 21 02 20 30 21 0? ?? ?? ?? 27 C7 00 FC 14 40 01 E0 8F DC 00 18 8F C2 00 FC AF C0 01 1C 10 40 00 05 8F C3 01 1C 8C 42 00 1C 14 40 FF FE 24 63 00 01 AF C3 01 1C 8F C2 00 F0 2C 42 00 02 14 40 01 8C 3C 04 ?? ?? 8C 82 ?? ?? AF C2 01 44 3C 02 ?? ?? 24 42 ?? ?? 10 40 02 4C 3C 05 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 8F DC 00 18 8F C4 01 1C 34 02 80 01 00 04 91 00 00 04 89 80 02 32 88 23 02 22 10 2B 10 40 02 4E 00 00 00 00 26 31 00 08 03 B1 E8 23 27 A4 00 18 AF C4 01 20 AF C0 01 40 8F C2 01 1C 8F C3 01 1C 8F C4 01 20 00 02 10 80 AF C2 01 2C 02 42 10 23 00 43 10 23 00 02 10 80 00 82 10 21 12 00 01 8E AF C2 01 28 8F C4 00 F8 10 80 00 08 8F D1 00 FC 8F C5 00 F4 3C 07 ?? ?? 24 06 00 18 0? ?? ?? ?? 24 E7 ?? ?? 8F DC 00 18 8F D1 00 FC 12 20 01 E7 8F C5 01 20 7C 03 E8 3B 00 60 20 21 8F C2 01 20 8F 83 ?? ?? 8F D4 01 28 8F D0 01 20 24 42 00 0C 24 A5 00 04 00 64 18 21 AF C2 01 3C AF C2 01 0C AF C5 01 38 AF C5 01 08 AF C0 01 14 24 12 FF FF AF C0 01 10 00 00 10 21 00 00 98 21 AF C3 01 18 24 03 FF FF AE 11 00 00 AE 03 00 28 10 40 00 05 AE 93 00 00 8C 46 00 10 8E 23 00 10 10 C3 00 50 00 00 00 00 24 02 FF FF A2 00 00 21 A2 00 00 22 A2 00 00 23 12 42 00 3C AE 02 00 24 8F C3 01 14 24 02 00 02 14 62 00 05 02 40 20 21 8E 23 00 04 24 02 00 0A 10 62 00 32 00 00 00 00 27 C5 00 20 24 06 00 10 AF C0 00 20 AF C0 00 24 AF C0 00 28 0? ?? ?? ?? AF C0 00 2C 24 02 00 1C AF C2 00 E0 8E 25 00 14 8E 26 00 10 0? ?? ?? ?? 02 40 20 21 10 40 00 47 26 05 00 04 8F C2 01 18 8C 43 00 00 24 02 00 7C 10 62 00 17 8F C3 01 14 A2 00 00 20 8E 22 00 18 10 40 00 05 8F C4 01 10 14 80 01 A5 3C 04 ?? ?? AE 20 00 18 AF C2 01 10 8F C5 01 08 8F C2 01 0C 8E 23 00 1C 24 A5 00 2C 24 42 00 2C 26 73 00 01 26 10 00 2C 26 94 00 04 AF C5 01 08 10 60 00 D3 AF C2 01 0C 02 20 10 21 0? ?? ?? ?? 00 60 88 21 24 02 00 0A 14 62 FF E8 24 02 00 02 8E 23 00 04 14 62 FF E5 00 00 00 00 02 40 20 21 24 02 0F A6 00 00 00 0C 8E 23 00 04 24 05 00 01 00 00 30 21 00 60 20 21 0? ?? ?? ?? AF C3 01 14 00 40 90 21 24 02 00 1C AF C2 00 E0 24 02 FF FF 12 42 FF D2 8F C2 01 18 0? ?? ?? ?? 8E 25 00 14 8C 44 00 14 0? ?? ?? ?? 8E 25 00 14 14 40 FF AE 24 02 FF FF 92 06 FF F4 26 04 00 04 0? ?? ?? ?? 26 05 FF D8 92 06 FF F4 92 05 FF F5 92 04 FF F6 92 03 FF F7 8E 02 FF F8 A2 06 00 20 A2 05 00 21 A2 04 00 22 A2 03 00 23 0? ?? ?? ?? AE 02 00 24 02 40 20 21 0? ?? ?? ?? 27 C6 00 E0 14 40 FF B7 8F C2 01 18 8F C2 00 E0 8F C7 00 F8 A2 02 00 20 24 02 00 01 10 E0 00 38 A2 02 00 21 8E 22 00 04 24 03 00 02 10 43 00 5E 8F C3 01 14 26 02 00 0C 88 46 00 00 88 45 00 04 88 44 00 08 88 43 00 0C 98 46 00 03 98 45 00 07 98 44 00 0B 98 43 00 0F AF C6 00 28 AF C5 00 2C AF C4 00 30 AF C3 00 34 8F D5 00 F4 AF D0 01 34 00 00 B8 21 02 A0 80 21 AF D1 01 30 00 E0 A8 21 02 F0 10 2B 14 40 00 08 02 17 B0 21 0? ?? ?? ?? 8F D1 01 30 02 F6 10 2B 10 40 00 3D 8F D1 01 30 02 C0 80 21 02 17 B0 21 00 16 B0 42 00 16 10 C0 00 16 31 40 00 C2 30 23 02 A6 88 21 27 C4 00 20 0? ?? ?? ?? 02 20 28 21 04 40 FF F2 00 00 00 00 14 40 FF EB 26 D7 00 01 02 20 B0 21 8F D0 01 34 12 C0 00 07 8F D1 01 30 92 C2 00 00 A2 02 00 22 92 C2 00 01 A2 02 00 23 8E C2 00 04 AE 02 00 24 8E 22 00 04 24 03 00 02 14 43 FF 7B 00 00 00 00 8F C4 01 14 24 03 00 0A 14 83 FF 77 8F C5 01 0C 8F C4 01 20 00 A4 18 23 8F C5 01 3C 00 65 18 21 8C 64 FF F4 14 80 00 CF 3C 04 ?? ?? 8C 64 FF F8 14 80 00 CC 3C 04 ?? ?? 8C 64 FF FC 34 03 FF FF 14 83 00 C7 8F C5 01 08 8F C4 01 20 00 A4 18 23 8F C5 01 38 26 04 00 18 00 65 18 21 A4 62 FF FC 88 83 00 00 26 02 00 08 98 83 00 03 AA 03 00 08 B8 43 00 03 24 02 00 10 0? ?? ?? ?? A2 02 00 20 24 03 00 02 8E 22 00 04 14 43 FF 57 8F D0 01 34 0? ?? ?? ?? 8F C4 01 14 14 62 FF A3 26 02 00 0C 34 03 FF FF 8F C4 01 08 8F C5 01 20 AF C3 00 30 8F C3 01 38 00 85 10 23 AF C0 00 28 AF C0 00 2C 00 43 10 21 8C 42 00 00 0? ?? ?? ?? AF C2 00 34 27 C4 01 01 27 C5 01 00 27 C6 00 F8 0? ?? ?? ?? 27 C7 00 F4 8E 22 00 04 14 40 00 8B 24 03 00 02 93 C2 01 01 10 40 00 94 93 C2 01 00 14 40 FE AC 24 10 00 01 8E 22 00 1C 8E 28 00 00 8E 27 00 08 8E 26 00 0C 8E 25 00 10 8E 24 00 14 8E 23 00 18 AF C2 00 DC AF C8 00 C0 AF C7 00 C8 AF C6 00 CC AF C5 00 D0 AF C4 00 D4 AF C3 00 D8 0? ?? ?? ?? 24 02 00 02 82 42 00 01 14 40 FE 86 00 00 00 00 12 60 01 15 24 02 FF FE 16 20 FE 84 00 00 90 21 3C 11 ?? ?? 0? ?? ?? ?? 26 31 ?? ?? 80 82 00 01 0? ?? ?? ?? 00 02 98 0A 24 02 FF FF 12 42 00 03 02 40 20 21 24 02 0F A6 00 00 00 0C 3C 02 ?? ?? 8F C3 01 20 8F C4 01 1C 8C 42 ?? ?? AF C3 00 E0 14 40 00 C7 AF C4 00 E4 8F C4 01 28 8F C5 01 1C 27 C2 00 E0 3C 07 ?? ?? AF A2 00 10 24 06 00 04 0? ?? ?? ?? 24 E7 ?? ?? 8F C4 01 28 8F C5 01 1C 8C 82 00 00 28 A3 00 02 00 02 20 80 00 02 29 00 00 A4 20 23 00 82 10 23 8F C4 01 20 00 02 10 80 00 82 10 21 8C 48 00 00 14 60 00 A0 AF C8 00 FC 8F C5 01 2C 8F C2 01 28 01 00 20 21 24 A7 FF FC 00 47 38 21 0? ?? ?? ?? 8F C9 01 20 00 60 20 21 8C 43 00 04 24 42 00 04 00 03 28 80 00 03 31 00 00 C5 28 23 00 A3 18 23 00 03 18 80 01 23 18 21 8C 63 00 00 14 47 FF F5 AC 83 00 1C AC 60 00 1C 8F C2 01 10 8F C3 01 40 14 60 00 61 AD 02 00 18 0? ?? ?? ?? 8F C4 00 F8 8F C2 00 FC 10 40 00 CD 8F C4 01 84 AC 82 00 00 03 C0 E8 21 8F BF 01 74 8F C2 01 24 8F B7 01 6C 8F BE 01 70 8F B6 01 68 8F B5 01 64 8F B4 01 60 8F B3 01 5C 8F B2 01 58 8F B1 01 54 8F B0 01 50 03 E0 00 08 27 BD 01 78 02 40 20 21 27 C5 00 20 24 06 00 0A 0? ?? ?? ?? AF D2 00 E8 AF C2 00 EC 8F C2 00 20 80 42 00 00 10 40 FE 3C 27 C5 00 E8 8E 22 00 00 30 42 04 00 14 40 00 71 24 02 FF FF 0? ?? ?? ?? AF C2 00 EC 27 C4 01 01 27 C5 01 00 27 C6 00 F8 0? ?? ?? ?? 27 C7 00 F4 8F C4 00 F8 14 80 FE 6F 8F DC 00 18 0? ?? ?? ?? 8F D1 00 FC 10 43 00 50 24 03 00 0A 14 43 00 0B 93 C2 01 00 14 40 FE 21 24 10 00 01 8F C4 00 F8 24 02 FF FE 0? ?? ?? ?? AF C2 01 24 0? ?? ?? ?? 03 C0 E8 21 14 40 00 29 00 00 00 00 16 40 FE 19 24 10 00 01 0? ?? ?? ?? 00 00 28 21 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 0A 48 0? ?? ?? ?? 24 E7 ?? ?? 8F C4 00 FC 0? ?? ?? ?? AF C2 01 48 0? ?? ?? ?? 8F C4 00 F8 8F C2 01 48 24 03 FE FF 03 C0 E8 21 8F BF 01 74 00 43 10 24 00 02 10 23 AF C2 01 24 8F C2 01 24 8F B7 01 6C 8F BE 01 70 8F B6 01 68 8F B5 01 64 8F B4 01 60 8F B3 01 5C 8F B2 01 58 8F B1 01 54 8F B0 01 50 03 E0 00 08 27 BD 01 78 0? ?? ?? ?? 8F C4 01 20 0? ?? ?? ?? 00 00 00 00 8E 22 00 1C 8E 28 00 00 8E 27 00 08 8E 26 00 0C 8E 25 00 10 8E 24 00 14 8E 23 00 18 AF C2 00 DC AF C8 00 C0 AF C7 00 C8 AF C6 00 CC AF C5 00 D0 AF C4 00 D4 AF C3 00 D8 24 02 00 0A AF C2 00 C4 24 10 00 01 0? ?? ?? ?? 27 D1 00 C0 24 05 FF FA 0? ?? ?? ?? AF C5 01 24 0? ?? ?? ?? 03 C0 E8 21 24 02 FF FF 0? ?? ?? ?? AF C2 01 24 93 C2 01 01 14 40 FD D3 24 10 00 01 0? ?? ?? ?? 8F C4 00 F8 24 05 FF FF 0? ?? ?? ?? AF C5 01 24 0? ?? ?? ?? 01 00 18 21 0? ?? ?? ?? AF C0 01 10 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 0A 63 0? ?? ?? ?? 24 E7 ?? ?? 8F C4 00 F8 24 03 FF FE 0? ?? ?? ?? AF C3 01 24 0? ?? ?? ?? 03 C0 E8 21 3C 10 ?? ?? 26 05 ?? ?? C0 A2 00 00 24 41 00 01 E0 A1 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 10 40 00 04 8F C2 01 44 0? ?? ?? ?? 26 04 ?? ?? 8F C2 01 44 10 40 00 06 8F C4 01 28 3C 02 ?? ?? 8C 42 ?? ?? 14 40 00 3C 3C 05 ?? ?? 8F C4 01 28 8F C5 01 1C 27 C2 00 E0 3C 07 ?? ?? AF A2 00 10 24 06 00 04 0? ?? ?? ?? 24 E7 ?? ?? 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF 1E 26 04 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F C4 01 28 8F C3 01 44 14 60 FD B7 00 00 00 00 0? ?? ?? ?? AF C4 01 48 8F C4 01 48 8F DC 00 18 8C 82 ?? ?? 34 42 00 02 0? ?? ?? ?? AC 82 ?? ?? 24 02 FF FE 0? ?? ?? ?? AF C2 01 24 0? ?? ?? ?? 02 20 20 21 14 40 FD B0 8F DC 00 18 0? ?? ?? ?? 02 20 20 21 AF C2 01 20 10 40 00 04 8F DC 00 18 24 03 00 01 0? ?? ?? ?? AF C3 01 40 8F C4 00 F8 24 05 FF F6 0? ?? ?? ?? AF C5 01 24 0? ?? ?? ?? 03 C0 E8 21 24 04 00 03 24 A5 ?? ?? 0? ?? ?? ?? 27 C6 00 20 14 40 00 05 3C 02 ?? ?? 8C 42 ?? ?? 8F C3 00 68 10 62 FF BC 00 00 00 00 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 8F C4 01 28 }
	condition:
		$1
}

rule file_1_11_0 {
	meta:
		name = "fini"
		size = 112
		refs = "001c free"
	strings:
		$1 = { 3C 02 ?? ?? 8C 44 ?? ?? 3C 03 ?? ?? 27 BD FF E0 24 63 ?? ?? 10 83 00 03 AF BF 00 1C 0? ?? ?? ?? AC 43 ?? ?? 3C 02 ?? ?? 8C 44 ?? ?? 3C 03 ?? ?? 24 63 ?? ?? 10 83 00 03 00 00 00 00 0? ?? ?? ?? AC 43 ?? ?? 3C 02 ?? ?? 8C 44 ?? ?? 3C 03 ?? ?? 24 63 ?? ?? 10 83 00 04 8F BF 00 1C 27 BD 00 20 0? ?? ?? ?? AC 43 ?? ?? 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "bcopy"
		size = 404
		refs = "0074 _wordcopy_fwd_dest_aligned 0114 _wordcopy_bwd_dest_aligned 0164 _wordcopy_bwd_aligned 0174 _wordcopy_fwd_aligned"
	strings:
		$1 = { 00 A4 18 23 27 BD FF D8 00 66 18 2B 00 A0 10 21 AF BF 00 24 AF B2 00 20 AF B1 00 1C 14 60 00 29 AF B0 00 18 2C C3 00 10 14 60 00 19 00 80 80 21 00 05 40 23 31 08 00 03 11 00 00 52 00 C8 90 23 00 A8 88 21 00 80 18 21 90 67 00 00 24 42 00 01 24 63 00 01 14 51 FF FC A0 47 FF FF 00 88 80 21 32 02 00 03 02 20 20 21 02 00 28 21 10 40 00 41 00 12 30 82 0? ?? ?? ?? 00 00 00 00 24 02 FF FC 02 42 10 24 02 02 80 21 32 46 00 03 02 22 10 21 10 C0 00 06 00 46 20 21 92 03 00 00 24 42 00 01 26 10 00 01 14 44 FF FC A0 43 FF FF 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 2C C3 00 10 00 86 10 21 14 60 00 19 00 A6 80 21 32 05 00 03 10 A0 00 2C 00 C5 90 23 00 45 88 23 02 00 18 21 24 42 FF FF 90 44 00 00 24 63 FF FF 14 51 FF FC A0 64 00 00 02 05 80 23 32 22 00 03 02 00 20 21 02 20 28 21 10 40 00 15 00 12 30 82 0? ?? ?? ?? 00 00 00 00 24 03 FF FC 02 43 18 24 32 46 00 03 02 23 10 23 10 C0 FF DF 02 03 80 23 00 46 30 23 24 42 FF FF 90 43 00 00 26 10 FF FF 14 46 FF FC A2 03 00 00 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 24 03 FF FC 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 24 02 FF FC 0? ?? ?? ?? 00 A0 88 21 0? ?? ?? ?? 00 40 88 21 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "__libc_cleanup_routine"
		size = 32
		altNames = "__pthread_cleanup_routine"
	strings:
		$1 = { 8C 82 00 08 14 40 00 03 00 00 00 00 03 E0 00 08 00 00 00 00 8C 99 00 00 03 20 00 08 8C 84 00 04 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "__atomic_pwritev64_replacement"
		size = 468
		refs = "0004 __gnu_local_gp 00d4 mempcpy 00fc __pwrite64 0108 free 014c __libc_errno 0198 __libc_alloca_cutoff 01ac malloc"
	strings:
		$1 = { 27 BD FF B0 3C 1C ?? ?? 27 9C ?? ?? AF BE 00 48 03 A0 F0 21 AF B3 00 38 AF B1 00 30 AF BF 00 4C AF B6 00 44 AF B5 00 40 AF B4 00 3C AF B2 00 34 AF B0 00 2C AF DC 00 18 00 C0 98 21 18 C0 00 54 00 80 88 21 8C A2 00 04 3C 03 80 00 00 43 18 2B 10 60 00 3C 3C 04 7F FF 00 A0 38 21 00 00 18 21 00 00 80 21 0? ?? ?? ?? 34 84 FF FF 8C E2 00 04 01 02 40 2B 15 00 00 33 00 00 00 00 02 02 80 21 24 63 00 01 24 E7 00 08 14 73 FF F8 00 90 40 23 34 02 80 01 02 02 10 2B 10 40 00 3F 02 00 20 21 26 02 00 0E 00 02 10 C2 00 02 10 C0 03 A2 E8 23 27 B4 00 18 1A 60 00 0B 00 00 A8 21 00 A0 90 21 02 80 10 21 00 00 B0 21 8E 45 00 00 8E 46 00 04 00 40 20 21 0? ?? ?? ?? 26 D6 00 01 16 D3 FF FA 26 52 00 08 8F C9 00 64 8F C8 00 60 02 20 20 21 AF A9 00 14 AF A8 00 10 02 80 28 21 0? ?? ?? ?? 02 00 30 21 02 A0 20 21 0? ?? ?? ?? AF C2 00 20 03 C0 E8 21 8F BF 00 4C 8F C2 00 20 8F B6 00 44 8F BE 00 48 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 50 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 16 AC 43 00 00 03 C0 E8 21 8F BF 00 4C 8F BE 00 48 8F B6 00 44 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 24 02 FF FF 03 E0 00 08 27 BD 00 50 0? ?? ?? ?? 00 00 80 21 0? ?? ?? ?? AF C5 00 20 14 40 FF BF 8F C5 00 20 02 00 20 21 0? ?? ?? ?? AF C5 00 20 00 40 A0 21 10 40 00 03 8F C5 00 20 0? ?? ?? ?? 00 40 A8 21 00 00 A8 21 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_5_1_0 {
	meta:
		name = "pwritev64"
		size = 392
		refs = "0004 __gnu_local_gp 008c __libc_errno 00cc __libc_enable_asynccancel 0130 __libc_disable_asynccancel"
	strings:
		$1 = { 27 BD FF B8 3C 1C ?? ?? 27 9C ?? ?? AF BE 00 40 03 A0 F0 21 AF B5 00 3C AF B4 00 38 AF B3 00 34 AF B2 00 30 AF B1 00 2C AF BF 00 44 AF B0 00 28 AF DC 00 18 00 80 A0 21 00 A0 98 21 00 C0 90 21 8F D1 00 58 8F D5 00 5C 7C 03 E8 3B 8C 62 8B 70 14 40 00 1E 00 00 00 00 27 BD FF F0 27 A2 00 18 AF C2 00 24 02 A0 38 21 27 BD FF E0 AF B1 00 10 24 02 10 EB 00 00 00 0C 27 BD 00 20 10 E0 00 2F 00 40 80 21 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 02 00 20 21 00 62 10 21 AC 50 00 00 24 10 FF FF 24 03 00 59 14 83 00 27 02 00 10 21 AF B1 00 10 AF B5 00 14 02 80 20 21 02 60 28 21 0? ?? ?? ?? 02 40 30 21 0? ?? ?? ?? 03 C0 E8 21 0? ?? ?? ?? 00 00 00 00 27 BD FF F0 27 A3 00 18 8F DC 00 18 00 40 F8 21 AF C3 00 20 02 80 20 21 02 60 28 21 02 40 30 21 02 A0 38 21 27 BD FF E0 AF B1 00 10 24 02 10 EB 00 00 00 0C 27 BD 00 20 10 E0 00 07 00 40 80 21 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 AC 50 00 00 24 10 FF FF 03 E0 20 21 0? ?? ?? ?? 00 00 00 00 8F DC 00 18 06 00 00 0C 02 00 10 21 03 C0 E8 21 8F BF 00 44 8F BE 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 48 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 0? ?? ?? ?? 8C 44 00 00 }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "decode_name"
		size = 252
	strings:
		$1 = { 00 80 10 21 24 85 00 01 00 80 18 21 24 07 00 5C 24 04 00 30 24 09 00 31 24 0B 00 33 24 0A 00 34 24 0C 00 32 24 0F 00 0A 24 0E 00 09 24 0D 00 20 80 66 00 00 10 C7 00 08 00 00 00 00 A0 A6 FF FF 80 66 00 00 24 A5 00 01 14 C0 FF F9 24 63 00 01 03 E0 00 08 00 00 00 00 80 68 00 01 11 04 00 0E 00 00 00 00 11 07 00 19 00 00 00 00 15 09 FF F3 00 00 00 00 80 68 00 02 15 0B FF F0 00 00 00 00 80 68 00 03 15 0A FF ED 00 00 00 00 A0 A7 FF FF 0? ?? ?? ?? 24 63 00 03 80 68 00 02 11 0A 00 0E 00 00 00 00 15 09 FF E5 00 00 00 00 80 68 00 03 11 09 00 0F 00 00 00 00 15 0C FF E0 00 00 00 00 A0 AF FF FF 0? ?? ?? ?? 24 63 00 03 A0 A7 FF FF 0? ?? ?? ?? 24 63 00 01 80 68 00 03 15 04 FF D7 00 00 00 00 A0 AD FF FF 0? ?? ?? ?? 24 63 00 03 A0 AE FF FF 0? ?? ?? ?? 24 63 00 03 }
	condition:
		$1
}

rule file_6_1_0 {
	meta:
		name = "__setmntent"
		size = 156
		refs = "0020 strlen 0044 mempcpy 0064 _IO_new_fopen"
	strings:
		$1 = { 27 BD FF D0 AF BE 00 28 AF B1 00 24 03 A0 F0 21 00 80 88 21 00 A0 20 21 AF BF 00 2C AF B0 00 20 0? ?? ?? ?? AF C5 00 18 24 43 00 0A 00 03 18 C2 00 03 18 C0 03 A3 E8 23 8F C5 00 18 27 B0 00 10 02 00 20 21 0? ?? ?? ?? 00 40 30 21 24 03 00 63 A0 43 00 00 24 03 00 65 A0 43 00 01 A0 40 00 02 02 20 20 21 0? ?? ?? ?? 02 00 28 21 10 40 00 04 00 00 00 00 8C 43 00 00 34 63 80 00 AC 43 00 00 03 C0 E8 21 8F DF 00 2C 8F BE 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_6_2_0 {
	meta:
		name = "__endmntent"
		size = 48
		refs = "0010 _IO_new_fclose"
	strings:
		$1 = { 10 80 00 09 00 00 00 00 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? 00 00 00 00 8F BF 00 1C 24 02 00 01 03 E0 00 08 27 BD 00 20 03 E0 00 08 24 02 00 01 }
	condition:
		$1
}

rule file_6_3_0 {
	meta:
		name = "__getmntent_r"
		size = 944
		refs = "0048 fgets_unlocked 0058 strchr 0114 $LC1 0360 $LC0 0370 sscanf"
	strings:
		$1 = { 27 BD FB C8 AF B6 04 30 AF B5 04 2C AF B4 04 28 AF B3 04 24 AF B2 04 20 AF B1 04 1C AF B0 04 18 AF BF 04 34 00 80 90 21 00 A0 A8 21 00 C0 88 21 00 E0 98 21 24 10 00 20 24 16 00 09 24 14 00 23 02 20 20 21 02 60 28 21 0? ?? ?? ?? 02 40 30 21 10 40 00 42 02 20 20 21 0? ?? ?? ?? 24 05 00 0A 10 40 00 0E 27 A4 00 18 A0 40 00 00 02 20 10 21 80 43 00 00 10 70 00 03 00 40 40 21 14 76 00 0F 00 00 00 00 0? ?? ?? ?? 24 42 00 01 0? ?? ?? ?? 00 00 00 00 14 40 FF F5 27 A4 00 18 24 05 04 00 0? ?? ?? ?? 02 40 30 21 27 A4 00 18 14 40 FF F7 24 05 00 0A 0? ?? ?? ?? 02 20 10 21 10 60 FF E1 02 20 20 21 10 74 FF E0 02 60 28 21 24 04 00 20 10 64 00 2D 24 04 00 09 10 64 00 2B 24 05 00 20 0? ?? ?? ?? 25 08 00 01 10 65 00 27 00 00 00 00 10 64 00 25 00 00 00 00 25 08 00 01 81 03 00 00 14 60 FF F9 00 00 00 00 0? ?? ?? ?? 00 40 20 21 AE A2 00 00 3C 02 ?? ?? 24 42 ?? ?? AE A2 00 04 AE A2 00 08 AE A2 00 0C AE A0 00 10 8F BF 04 34 AE A0 00 14 02 A0 10 21 8F B6 04 30 8F B5 04 2C 8F B4 04 28 8F B3 04 24 8F B2 04 20 8F B1 04 1C 8F B0 04 18 03 E0 00 08 27 BD 04 38 8F BF 04 34 8F B6 04 30 8F B5 04 2C 8F B4 04 28 8F B3 04 24 8F B2 04 20 8F B1 04 1C 8F B0 04 18 00 00 10 21 03 E0 00 08 27 BD 04 38 A1 00 00 00 00 40 20 21 0? ?? ?? ?? 25 18 00 01 13 00 FF DE AE A2 00 00 03 00 20 21 24 05 00 20 24 06 00 09 80 83 00 00 10 65 00 03 00 80 10 21 14 66 00 03 00 00 00 00 0? ?? ?? ?? 24 84 00 01 10 60 00 0F 24 05 00 20 10 65 00 14 24 05 00 09 10 65 00 12 24 06 00 20 0? ?? ?? ?? 24 42 00 01 10 66 00 0E 00 00 00 00 10 65 00 0C 00 00 00 00 24 42 00 01 80 43 00 00 14 60 FF F9 00 00 00 00 0? ?? ?? ?? 00 00 00 00 AE A2 00 04 3C 02 ?? ?? 24 42 ?? ?? 0? ?? ?? ?? AE A2 00 08 A0 40 00 00 0? ?? ?? ?? 24 58 00 01 03 00 20 21 AE A2 00 04 24 05 00 20 13 00 FF F5 24 06 00 09 80 83 00 00 10 65 00 03 00 80 10 21 14 66 00 03 00 00 00 00 0? ?? ?? ?? 24 84 00 01 10 60 00 0F 24 05 00 20 10 65 00 14 24 05 00 09 10 65 00 12 24 06 00 20 0? ?? ?? ?? 24 42 00 01 10 66 00 0E 00 00 00 00 10 65 00 0C 00 00 00 00 24 42 00 01 80 43 00 00 14 60 FF F9 00 00 00 00 0? ?? ?? ?? 00 00 00 00 AE A2 00 08 3C 02 ?? ?? 24 42 ?? ?? 0? ?? ?? ?? AE A2 00 0C A0 40 00 00 0? ?? ?? ?? 24 58 00 01 03 00 20 21 AE A2 00 08 24 05 00 20 13 00 FF F5 24 06 00 09 80 83 00 00 10 65 00 03 00 80 10 21 14 66 00 03 00 00 00 00 0? ?? ?? ?? 24 84 00 01 10 60 00 0F 24 05 00 20 10 65 00 12 24 05 00 09 10 65 00 10 24 06 00 20 0? ?? ?? ?? 24 42 00 01 10 66 00 0C 00 00 00 00 10 65 00 0A 00 00 00 00 24 42 00 01 80 43 00 00 14 60 FF F9 00 00 00 00 0? ?? ?? ?? 00 00 00 00 AE A2 00 0C 0? ?? ?? ?? AE A0 00 10 A0 40 00 00 0? ?? ?? ?? 24 58 00 01 13 00 FF 73 AE A2 00 0C 3C 05 ?? ?? 03 00 20 21 24 A5 ?? ?? 26 A6 00 10 0? ?? ?? ?? 26 A7 00 14 10 40 FF 6B 24 03 00 01 10 43 FF 6B 8F BF 04 34 02 A0 10 21 8F B6 04 30 8F B5 04 2C 8F B4 04 28 8F B3 04 24 8F B2 04 20 8F B1 04 1C 8F B0 04 18 03 E0 00 08 27 BD 04 38 }
	condition:
		$1
}

rule file_6_4_0 {
	meta:
		name = "__addmntent"
		size = 1632
		refs = "0058 fseek 0224 $LC2 0244 fprintf 0254 fflush 02cc strlen"
	strings:
		$1 = { 27 BD FF A8 00 A0 10 21 AF B7 00 4C AF B5 00 44 AF B4 00 40 AF B1 00 34 AF B0 00 30 8C 54 00 00 8C 57 00 04 8C 51 00 08 8C 50 00 0C 8C 55 00 10 8C 42 00 14 AF BE 00 50 24 06 00 02 03 A0 F0 21 00 00 28 21 AF B2 00 38 AF BF 00 54 AF B6 00 48 AF B3 00 3C 00 80 90 21 0? ?? ?? ?? AF C2 00 28 14 40 00 8C 00 00 00 00 82 96 00 00 12 C0 00 19 00 00 00 00 24 02 00 20 12 C2 00 94 26 C2 FF F7 30 42 00 FF 2C 42 00 02 14 40 00 90 24 02 00 5C 12 C2 00 8E 02 80 18 21 24 06 00 20 0? ?? ?? ?? 24 07 00 5C 10 46 00 89 00 00 00 00 14 A0 00 87 00 00 00 00 10 47 00 85 00 00 00 00 24 63 00 01 80 62 00 00 24 45 FF F7 30 A5 00 FF 14 40 FF F5 2C A5 00 02 02 80 98 21 82 E7 00 00 10 E0 00 19 00 00 00 00 24 02 00 20 10 E2 00 A1 24 E2 FF F7 30 42 00 FF 2C 42 00 02 14 40 00 9D 24 02 00 5C 10 E2 00 9B 02 E0 18 21 24 05 00 20 0? ?? ?? ?? 24 06 00 5C 10 45 00 96 00 00 00 00 14 80 00 94 00 00 00 00 10 46 00 92 00 00 00 00 24 63 00 01 80 62 00 00 24 44 FF F7 30 84 00 FF 14 40 FF F5 2C 84 00 02 02 E0 B0 21 82 27 00 00 10 E0 00 18 24 02 00 20 10 E2 00 B0 24 E2 FF F7 30 42 00 FF 2C 42 00 02 14 40 00 AC 24 02 00 5C 10 E2 00 AA 26 23 00 01 24 05 00 20 0? ?? ?? ?? 24 06 00 5C 10 45 00 A5 00 00 00 00 14 80 00 A3 00 00 00 00 10 46 00 A1 00 00 00 00 80 62 00 00 24 63 00 01 24 44 FF F7 30 84 00 FF 14 40 FF F5 2C 84 00 02 02 20 B8 21 82 11 00 00 12 20 00 18 24 02 00 20 12 22 00 BF 26 22 FF F7 30 42 00 FF 2C 42 00 02 14 40 00 BB 24 02 00 5C 12 22 00 B9 26 03 00 01 24 05 00 20 0? ?? ?? ?? 24 06 00 5C 10 45 00 B4 00 00 00 00 14 80 00 B2 00 00 00 00 10 46 00 B0 00 00 00 00 80 62 00 00 24 63 00 01 24 44 FF F7 30 84 00 FF 14 40 FF F5 2C 84 00 02 02 00 40 21 8F C2 00 28 3C 05 ?? ?? AF B7 00 10 AF A8 00 14 AF B5 00 18 AF A2 00 1C 02 40 20 21 24 A5 ?? ?? 02 60 30 21 0? ?? ?? ?? 02 C0 38 21 04 40 00 11 00 00 00 00 0? ?? ?? ?? 02 40 20 21 03 C0 E8 21 8F BF 00 54 8F BE 00 50 8F B7 00 4C 8F B6 00 48 8F B5 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 00 02 10 2B 03 E0 00 08 27 BD 00 58 03 C0 E8 21 8F DF 00 54 8F BE 00 50 8F B7 00 4C 8F B6 00 48 8F B5 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 24 02 00 01 03 E0 00 08 27 BD 00 58 0? ?? ?? ?? 02 80 20 21 00 02 10 80 24 42 00 0F 00 02 10 C2 00 02 10 C0 03 A2 E8 23 27 B3 00 20 02 C0 18 21 24 05 00 20 02 80 20 21 02 60 10 21 24 07 00 09 24 0B 00 0A 24 09 00 5C 24 08 00 5C 24 06 00 30 24 0A 00 31 24 0D 00 32 10 65 00 0F 24 0C 00 34 10 67 00 A1 00 00 00 00 10 6B 00 AB 00 00 00 00 10 69 00 C7 00 00 00 00 A0 43 00 00 24 42 00 01 80 83 00 00 10 60 FF 64 00 00 00 00 80 83 00 01 14 65 FF F3 24 84 00 01 A0 48 00 00 A0 46 00 01 A0 4C 00 02 A0 46 00 03 0? ?? ?? ?? 24 42 00 04 02 E0 20 21 0? ?? ?? ?? AF C7 00 2C 00 02 10 80 24 42 00 0F 8F C7 00 2C 00 02 10 C2 00 02 10 C0 03 A2 E8 23 27 B6 00 20 00 E0 18 21 24 04 00 20 02 C0 10 21 24 06 00 09 24 0A 00 0A 24 08 00 5C 24 07 00 5C 24 05 00 30 24 09 00 31 24 0C 00 32 10 64 00 0F 24 0B 00 34 10 66 00 71 00 00 00 00 10 6A 00 7B 00 00 00 00 10 68 00 99 00 00 00 00 A0 43 00 00 24 42 00 01 82 E3 00 00 10 60 FF 56 00 00 00 00 82 E3 00 01 14 64 FF F3 26 F7 00 01 A0 47 00 00 A0 45 00 01 A0 4B 00 02 A0 45 00 03 0? ?? ?? ?? 24 42 00 04 02 20 20 21 0? ?? ?? ?? AF C7 00 2C 00 02 10 80 24 42 00 0F 8F C7 00 2C 00 02 10 C2 00 02 10 C0 03 A2 E8 23 27 B7 00 20 00 E0 18 21 24 04 00 20 02 E0 10 21 24 06 00 09 24 0A 00 0A 24 08 00 5C 24 07 00 5C 24 05 00 30 24 09 00 31 24 0C 00 32 10 64 00 0F 24 0B 00 34 10 66 00 3B 00 00 00 00 10 6A 00 63 00 00 00 00 10 68 00 6B 00 00 00 00 A0 43 00 00 24 42 00 01 82 23 00 00 10 60 FF 47 00 00 00 00 82 23 00 01 14 64 FF F3 26 31 00 01 A0 47 00 00 A0 45 00 01 A0 4B 00 02 A0 45 00 03 0? ?? ?? ?? 24 42 00 04 0? ?? ?? ?? 02 00 20 21 00 02 10 80 24 42 00 0F 00 02 10 C2 00 02 10 C0 03 A2 E8 23 27 A8 00 20 02 20 18 21 24 04 00 20 01 00 10 21 24 06 00 09 24 0B 00 0A 24 09 00 5C 24 07 00 5C 24 05 00 30 24 0A 00 31 24 0D 00 32 10 64 00 0F 24 0C 00 34 10 66 00 19 00 00 00 00 10 6B 00 35 00 00 00 00 10 69 00 3F 00 00 00 00 A0 43 00 00 24 42 00 01 82 03 00 00 10 60 FF 3A 00 00 00 00 82 03 00 01 14 64 FF F3 26 10 00 01 A0 47 00 00 A0 45 00 01 A0 4C 00 02 A0 45 00 03 0? ?? ?? ?? 24 42 00 04 A0 47 00 00 A0 45 00 01 A0 49 00 02 A0 49 00 03 0? ?? ?? ?? 24 42 00 04 A0 47 00 00 A0 45 00 01 A0 4A 00 02 A0 4A 00 03 0? ?? ?? ?? 24 42 00 04 A0 47 00 00 A0 45 00 01 A0 49 00 02 A0 49 00 03 0? ?? ?? ?? 24 42 00 04 A0 48 00 00 A0 46 00 01 A0 4A 00 02 A0 4A 00 03 0? ?? ?? ?? 24 42 00 04 A0 47 00 00 A0 45 00 01 A0 49 00 02 A0 4C 00 03 0? ?? ?? ?? 24 42 00 04 A0 48 00 00 A0 46 00 01 A0 4A 00 02 A0 4D 00 03 0? ?? ?? ?? 24 42 00 04 A0 47 00 00 A0 45 00 01 A0 4A 00 02 A0 4D 00 03 0? ?? ?? ?? 24 42 00 04 A0 47 00 00 A0 45 00 01 A0 49 00 02 A0 4C 00 03 0? ?? ?? ?? 24 42 00 04 A0 49 00 00 A0 49 00 01 0? ?? ?? ?? 24 42 00 02 A0 48 00 00 A0 48 00 01 0? ?? ?? ?? 24 42 00 02 A0 48 00 00 A0 48 00 01 0? ?? ?? ?? 24 42 00 02 A0 49 00 00 A0 49 00 01 0? ?? ?? ?? 24 42 00 02 }
	condition:
		$1
}

rule file_6_5_0 {
	meta:
		name = "__hasmntopt"
		size = 220
		refs = "0024 strlen 0040 strchr 0054 strstr"
	strings:
		$1 = { 27 BD FF D0 AF B0 00 18 00 80 80 21 00 A0 20 21 AF B4 00 28 AF B3 00 24 AF B2 00 20 AF B1 00 1C AF BF 00 2C 0? ?? ?? ?? 00 A0 90 21 00 40 98 21 8E 10 00 0C 24 14 00 3D 0? ?? ?? ?? 24 11 00 2C 0? ?? ?? ?? 00 00 00 00 10 40 00 1B 24 50 00 01 02 00 20 21 0? ?? ?? ?? 02 40 28 21 00 40 20 21 10 40 00 0D 24 05 00 2C 10 50 00 04 00 53 18 21 80 43 FF FF 14 71 FF F2 00 53 18 21 80 63 00 00 10 60 00 06 8F BF 00 2C 10 74 00 04 00 00 00 00 14 71 FF EB 00 00 00 00 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 30 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 00 00 10 21 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "__setitimer"
		size = 28
	strings:
		$1 = { 24 02 10 08 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "__isoc99_vwscanf"
		size = 500
		refs = "0008 stdin 007c __lll_lock_wait_private 00b8 _IO_vfwscanf 01a0 _Unwind_Resume"
	strings:
		$1 = { 27 BD FF C8 AF B1 00 24 3C 11 ?? ?? AF B0 00 20 8E 30 ?? ?? AF B3 00 2C AF B2 00 28 8E 02 00 00 AF BF 00 34 AF B4 00 30 30 42 80 00 00 80 98 21 14 40 00 39 00 A0 90 21 7C 03 E8 3B 8E 04 00 48 24 74 8B 70 8C 83 00 08 10 74 00 12 02 00 38 21 AF A0 00 18 C0 85 00 00 14 A0 00 06 24 03 00 00 24 01 00 01 E0 81 00 00 10 20 FF FA 24 03 00 01 00 00 00 0F 14 60 00 03 00 00 00 00 0? ?? ?? ?? AF A5 00 18 8E 03 00 48 8E 27 ?? ?? 00 60 20 21 AC 74 00 08 8C 83 00 04 24 63 00 01 AC 83 00 04 8C E2 00 3C 00 E0 20 21 02 60 28 21 34 42 00 10 AC E2 00 3C 02 40 30 21 0? ?? ?? ?? 00 00 38 21 8E 05 00 3C 8E 03 00 00 24 04 FF EB 00 A4 20 24 30 63 80 00 00 40 88 21 14 60 00 06 AE 04 00 3C 8E 04 00 48 8C 82 00 04 24 42 FF FF 10 40 00 0C AC 82 00 04 8F BF 00 34 02 20 10 21 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 38 0? ?? ?? ?? 02 00 38 21 AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF EC 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 34 8E 05 00 3C 8E 02 00 00 24 03 FF EB 00 A3 18 24 30 42 80 00 00 80 88 21 14 40 00 06 AE 03 00 3C 8E 04 00 48 8C 83 00 04 24 63 FF FF 10 60 00 03 AC 83 00 04 0? ?? ?? ?? 02 20 20 21 AC 80 00 08 00 00 00 0F C0 83 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 63 00 02 14 60 FF F5 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_1159_0_0 {
	meta:
		name = "__isoc99_vscanf"
		size = 500
		refs = "0008 stdin 007c __lll_lock_wait_private 00b8 _IO_vfscanf 01a0 _Unwind_Resume"
	strings:
		$1 = { 27 BD FF C8 AF B1 00 24 3C 11 ?? ?? AF B0 00 20 8E 30 ?? ?? AF B3 00 2C AF B2 00 28 8E 02 00 00 AF BF 00 34 AF B4 00 30 30 42 80 00 00 80 98 21 14 40 00 39 00 A0 90 21 7C 03 E8 3B 8E 04 00 48 24 74 8B 70 8C 83 00 08 10 74 00 12 02 00 38 21 AF A0 00 18 C0 85 00 00 14 A0 00 06 24 03 00 00 24 01 00 01 E0 81 00 00 10 20 FF FA 24 03 00 01 00 00 00 0F 14 60 00 03 00 00 00 00 0? ?? ?? ?? AF A5 00 18 8E 03 00 48 8E 27 ?? ?? 00 60 20 21 AC 74 00 08 8C 83 00 04 24 63 00 01 AC 83 00 04 8C E2 00 3C 00 E0 20 21 02 60 28 21 34 42 00 10 AC E2 00 3C 02 40 30 21 0? ?? ?? ?? 00 00 38 21 8E 05 00 3C 8E 03 00 00 24 04 FF EB 00 A4 20 24 30 63 80 00 00 40 88 21 14 60 00 06 AE 04 00 3C 8E 04 00 48 8C 82 00 04 24 42 FF FF 10 40 00 0C AC 82 00 04 8F BF 00 34 02 20 10 21 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 38 0? ?? ?? ?? 02 00 38 21 AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF EC 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 34 8E 05 00 3C 8E 02 00 00 24 03 FF EB 00 A3 18 24 30 42 80 00 00 80 88 21 14 40 00 06 AE 03 00 3C 8E 04 00 48 8C 83 00 04 24 63 FF FF 10 60 00 03 AC 83 00 04 0? ?? ?? ?? 02 20 20 21 AC 80 00 08 00 00 00 0F C0 83 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 63 00 02 14 60 FF F5 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "allocate"
		size = 36
		refs = "0008 malloc"
	strings:
		$1 = { 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? 24 04 04 00 8F BF 00 1C 3C 03 ?? ?? AC 62 ?? ?? 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_9_1_0 {
	meta:
		name = "getnetgrent"
		size = 236
		refs = "0000 __gnu_local_gp 0004 __pthread_once 0070 __getnetgrent_r 009c __libc_errno 00cc malloc"
	strings:
		$1 = { 3C 1C ?? ?? 3C 02 ?? ?? 27 BD FF C8 27 9C ?? ?? 24 42 ?? ?? AF B2 00 2C AF B1 00 28 AF B0 00 24 AF BF 00 34 AF B3 00 30 AF BC 00 18 00 80 88 21 00 A0 80 21 10 40 00 1F 00 C0 90 21 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 8F BC 00 18 3C 03 ?? ?? 8C 67 ?? ?? 10 E0 00 0D 02 20 20 21 24 02 04 00 AF A2 00 10 02 00 28 21 0? ?? ?? ?? 02 40 30 21 8F BF 00 34 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 38 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 0C AC 43 00 00 0? ?? ?? ?? 24 02 FF FF 3C 13 ?? ?? 8E 62 ?? ?? 10 40 00 03 00 00 00 00 0? ?? ?? ?? 3C 03 ?? ?? 0? ?? ?? ?? 24 04 04 00 3C 03 ?? ?? AC 62 ?? ?? 24 02 00 02 8F BC 00 18 0? ?? ?? ?? AE 62 ?? ?? }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "putwc"
		size = 464
		refs = "006c __lll_lock_wait_private 0148 __woverflow 017c _Unwind_Resume"
	strings:
		$1 = { 8C A2 00 00 27 BD FF D0 AF B2 00 28 30 42 80 00 AF B0 00 20 AF BF 00 2C AF B1 00 24 00 A0 80 21 14 40 00 1A 00 80 90 21 7C 03 E8 3B 8C A4 00 48 24 71 8B 70 8C 83 00 08 10 71 00 11 00 00 00 00 AF A0 00 18 C0 85 00 00 14 A0 00 06 24 03 00 00 24 01 00 01 E0 81 00 00 10 20 FF FA 24 03 00 01 00 00 00 0F 14 60 00 03 00 00 00 00 0? ?? ?? ?? AF A5 00 18 8E 03 00 48 00 60 20 21 AC 71 00 08 8C 83 00 04 24 63 00 01 AC 83 00 04 8E 02 00 5C 10 40 00 2D 02 00 20 21 8C 43 00 10 8C 44 00 14 00 64 20 2B 10 80 00 27 24 64 00 04 AC 44 00 10 02 40 88 21 AC 72 00 00 8E 02 00 00 30 42 80 00 14 40 00 07 8F BF 00 2C 8E 04 00 48 8C 82 00 04 24 42 FF FF 10 40 00 08 AC 82 00 04 8F BF 00 2C 02 20 10 21 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 30 AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF F0 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 2C 02 00 20 21 0? ?? ?? ?? 02 40 28 21 0? ?? ?? ?? 00 40 88 21 8E 02 00 00 30 42 80 00 14 40 00 06 00 80 88 21 8E 04 00 48 8C 83 00 04 24 63 FF FF 10 60 00 03 AC 83 00 04 0? ?? ?? ?? 02 20 20 21 AC 80 00 08 00 00 00 0F C0 83 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 63 00 02 14 60 FF F5 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_11_0_0 {
	meta:
		name = "parse_printf_format"
		size = 348
		refs = "002c __strchrnul 0078 __parse_one_specmb 0050 __printf_arginfo_table"
	strings:
		$1 = { 27 BD FF 90 AF B1 00 58 00 A0 88 21 24 05 00 25 AF B3 00 60 AF BF 00 6C AF B5 00 68 AF B4 00 64 AF B2 00 5C AF B0 00 54 00 C0 98 21 0? ?? ?? ?? AF A0 00 4C 00 40 20 21 90 42 00 00 10 40 00 45 00 00 80 21 24 12 FF FF 24 14 00 01 0? ?? ?? ?? 3C 15 ?? ?? 00 05 28 80 02 65 28 21 AC A2 00 00 8F A4 00 30 90 82 00 00 10 40 00 2F 8F A2 00 4C 02 00 28 21 27 A6 00 18 0? ?? ?? ?? 27 A7 00 4C 8F A3 00 38 10 72 00 07 02 02 80 21 00 71 10 2B 10 40 00 05 8F A2 00 34 00 03 18 80 02 63 18 21 AC 60 00 00 8F A2 00 34 10 52 00 06 00 51 18 2B 10 60 00 05 8F A5 00 3C 00 02 10 80 02 62 10 21 AC 40 00 00 8F A5 00 3C 00 B1 10 2B 10 40 FF E5 8F A4 00 30 8F A2 00 44 10 40 FF E2 00 00 00 00 10 54 FF DC 8F A2 00 40 8F A2 00 20 8E A3 ?? ?? 00 05 30 80 00 02 10 80 00 62 10 21 8C 59 00 00 27 A4 00 18 02 25 28 23 02 66 30 21 03 20 F8 09 27 A7 00 48 8F A4 00 30 90 82 00 00 14 40 FF D5 02 00 28 21 8F A2 00 4C 02 02 18 2B 02 03 10 0A 8F BF 00 6C 8F B5 00 68 8F B4 00 64 8F B3 00 60 8F B2 00 5C 8F B1 00 58 8F B0 00 54 03 E0 00 08 27 BD 00 70 0? ?? ?? ?? 00 00 10 21 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "getwchar_unlocked"
		size = 64
		refs = "0000 _IO_stdin 0038 __wuflow"
	strings:
		$1 = { 3C 02 ?? ?? 8C 44 ?? ?? 8C 82 00 5C 10 40 00 0A 00 00 00 00 8C 43 00 00 8C 45 00 04 00 65 28 2B 10 A0 00 05 00 00 00 00 24 64 00 04 AC 44 00 00 03 E0 00 08 8C 62 00 00 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_13_0_0 {
	meta:
		name = "rename"
		size = 28
	strings:
		$1 = { 24 02 0F C6 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "posix_spawn_file_actions_destroy"
		size = 36
		refs = "000c free"
	strings:
		$1 = { 8C 84 00 08 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? 00 00 00 00 8F BF 00 1C 00 00 10 21 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "__mmap"
		size = 28
	strings:
		$1 = { 24 02 0F FA 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "__nl_langinfo_l"
		size = 112
		refs = "0050 $LC0"
	strings:
		$1 = { 00 04 14 03 24 03 00 06 10 43 00 11 2C 43 00 0D 10 60 00 0F 30 84 FF FF 34 03 FF FF 10 83 00 0F 00 00 00 00 00 02 10 80 00 A2 28 21 8C A2 00 00 8C 43 00 20 00 83 18 2B 10 60 00 05 24 84 00 08 00 04 20 80 00 44 10 21 03 E0 00 08 8C 42 00 04 3C 02 ?? ?? 03 E0 00 08 24 42 ?? ?? 24 42 00 10 00 02 10 80 00 A2 28 21 03 E0 00 08 8C A2 00 00 }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "strerror_l"
		size = 308
		refs = "001c _sys_nerr_internal 002c _sys_errlist_internal 0048 __uselocale 0060 __dcgettext 0050 _libc_intl_domainname 0094 last_value 00a0 free 00b4 $LC0 00dc $LC1 00ec __asprintf"
	strings:
		$1 = { 27 BD FF D0 AF B0 00 20 AF BF 00 2C AF B2 00 28 AF B1 00 24 04 80 00 1E 00 80 80 21 3C 02 ?? ?? 8C 42 ?? ?? 00 82 10 2A 10 40 00 19 3C 02 ?? ?? 00 04 18 80 24 42 ?? ?? 00 62 10 21 8C 51 00 00 12 20 00 13 00 00 00 00 0? ?? ?? ?? 00 A0 20 21 3C 04 ?? ?? 02 20 28 21 24 06 00 05 00 40 80 21 0? ?? ?? ?? 24 84 ?? ?? 02 00 20 21 0? ?? ?? ?? 00 40 88 21 8F BF 00 2C 02 20 10 21 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 30 7C 03 E8 3B 3C 11 ?? ?? 02 23 88 21 8E 24 ?? ?? 0? ?? ?? ?? AF A5 00 18 8F A5 00 18 0? ?? ?? ?? 00 A0 20 21 3C 05 ?? ?? 3C 04 ?? ?? 24 A5 ?? ?? 24 06 00 05 00 40 90 21 0? ?? ?? ?? 24 84 ?? ?? 02 40 20 21 0? ?? ?? ?? 00 40 90 21 3C 05 ?? ?? 26 24 ?? ?? 24 A5 ?? ?? 02 40 30 21 0? ?? ?? ?? 02 00 38 21 24 03 FF FF 10 43 00 07 8F BF 00 2C 8E 22 ?? ?? 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 30 AE 20 ?? ?? 8F B2 00 28 8F B1 00 24 8F B0 00 20 00 00 10 21 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_17_1_0 {
	meta:
		name = "strerror_thread_freeres"
		size = 24
		refs = "0008 last_value 0010 free"
	strings:
		$1 = { 7C 03 E8 3B 00 60 10 21 3C 03 ?? ?? 00 62 10 21 0? ?? ?? ?? 8C 44 ?? ?? }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "__scanf"
		size = 68
		refs = "0000 stdin 0030 _IO_vfscanf"
	strings:
		$1 = { 3C 02 ?? ?? 27 BD FF D8 00 80 18 21 8C 44 ?? ?? 27 A2 00 2C AF A5 00 2C AF A6 00 30 AF A7 00 34 00 60 28 21 00 40 30 21 00 00 38 21 AF BF 00 24 0? ?? ?? ?? AF A2 00 18 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_929_0_0 {
	meta:
		name = "__wscanf"
		size = 68
		refs = "0000 stdin 0030 _IO_vfwscanf"
	strings:
		$1 = { 3C 02 ?? ?? 27 BD FF D8 00 80 18 21 8C 44 ?? ?? 27 A2 00 2C AF A5 00 2C AF A6 00 30 AF A7 00 34 00 60 28 21 00 40 30 21 00 00 38 21 AF BF 00 24 0? ?? ?? ?? AF A2 00 18 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "fstatvfs"
		size = 124
		refs = "001c __fstatfs 0034 __fxstat64 0050 __internal_statvfs"
	strings:
		$1 = { 27 BD FE F0 AF B1 01 04 00 A0 88 21 27 A5 00 B8 AF B2 01 08 AF BF 01 0C AF B0 01 00 0? ?? ?? ?? 00 80 90 21 04 40 00 13 27 B0 00 18 24 04 00 03 02 40 28 21 0? ?? ?? ?? 02 00 30 21 00 02 10 27 00 00 38 21 02 02 38 0B 00 00 20 21 02 20 28 21 0? ?? ?? ?? 27 A6 00 B8 00 00 10 21 8F BF 01 0C 8F B2 01 08 8F B1 01 04 8F B0 01 00 03 E0 00 08 27 BD 01 10 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "syscall"
		size = 28
	strings:
		$1 = { 24 02 0F A0 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_21_0_0 {
	meta:
		name = "__strverscmp"
		size = 300
	strings:
		$1 = { 10 85 00 33 00 00 00 00 90 82 00 00 90 A3 00 00 24 84 00 01 38 48 00 30 24 47 FF D0 2D 08 00 01 2C E7 00 0A 00 43 30 23 24 A5 00 01 14 C0 00 15 01 07 38 21 10 40 00 26 3C 09 ?? ?? 0? ?? ?? ?? 25 29 ?? ?? 10 40 00 22 00 00 00 00 24 84 00 01 90 82 FF FF 24 A5 00 01 01 27 38 21 90 A3 FF FF 90 E8 00 00 24 46 FF D0 38 47 00 30 2C C6 00 0A 2C E7 00 01 00 E6 38 21 00 43 30 23 10 C0 FF F1 00 E8 38 21 38 62 00 30 24 63 FF D0 2C 63 00 0A 2C 42 00 01 00 07 40 40 00 43 10 21 01 07 38 21 00 E2 38 21 3C 02 ?? ?? 24 42 ?? ?? 00 E2 10 21 80 42 00 00 24 03 00 02 10 43 00 18 24 03 00 03 10 43 00 0A 24 84 00 01 03 E0 00 08 00 00 00 00 03 E0 00 08 00 00 10 21 90 A2 FF FF 24 42 FF D0 2C 42 00 0A 10 40 00 0F 24 84 00 01 90 82 FF FF 24 42 FF D0 2C 42 00 0A 14 40 FF F7 24 A5 00 01 24 A5 FF FF 90 A3 00 00 24 02 FF FF 24 63 FF D0 2C 63 00 0A 03 E0 00 08 00 C3 10 0A 03 E0 00 08 00 C0 10 21 03 E0 00 08 24 02 00 01 }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "getnetent"
		size = 296
		refs = "0004 __gnu_local_gp 004c __libc_h_errno 0064 __getnetent_r 0084 __nss_getent 0098 __libc_errno 00f4 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF C8 3C 1C ?? ?? AF B0 00 24 3C 10 ?? ?? 27 9C ?? ?? 26 03 ?? ?? AF BF 00 34 AF B3 00 30 AF B2 00 2C AF B1 00 28 AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 2B 00 00 00 00 8F 82 ?? ?? 7C 03 E8 3B 00 60 90 21 00 43 10 21 3C 03 ?? ?? 24 63 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 06 ?? ?? AF A3 00 10 AF A2 00 14 24 84 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 24 07 04 00 8F BC 00 18 00 40 98 21 26 03 ?? ?? 8F 91 ?? ?? 02 32 90 21 8E 52 00 00 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 10 26 04 ?? ?? 8F BF 00 34 7C 03 E8 3B 02 23 88 21 AE 32 00 00 02 60 10 21 8F B2 00 2C 8F B3 00 30 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 38 0? ?? ?? ?? 26 04 ?? ?? 0? ?? ?? ?? 8F BC 00 18 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 34 }
	condition:
		$1
}

rule file_311_0_0 {
	meta:
		name = "gethostent"
		size = 296
		refs = "0004 __gnu_local_gp 004c __libc_h_errno 0064 __gethostent_r 0084 __nss_getent 0098 __libc_errno 00f4 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF C8 3C 1C ?? ?? AF B0 00 24 3C 10 ?? ?? 27 9C ?? ?? 26 03 ?? ?? AF BF 00 34 AF B3 00 30 AF B2 00 2C AF B1 00 28 AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 2B 00 00 00 00 8F 82 ?? ?? 7C 03 E8 3B 00 60 90 21 00 43 10 21 3C 03 ?? ?? 24 63 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 06 ?? ?? AF A3 00 10 AF A2 00 14 24 84 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 24 07 04 00 8F BC 00 18 00 40 98 21 26 03 ?? ?? 8F 91 ?? ?? 02 32 90 21 8E 52 00 00 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 10 26 04 ?? ?? 8F BF 00 34 7C 03 E8 3B 02 23 88 21 AE 32 00 00 02 60 10 21 8F B2 00 2C 8F B3 00 30 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 38 0? ?? ?? ?? 26 04 ?? ?? 0? ?? ?? ?? 8F BC 00 18 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 34 }
	condition:
		$1
}

rule file_23_0_0 {
	meta:
		name = "__dup2"
		size = 28
	strings:
		$1 = { 24 02 0F DF 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "__wctrans"
		size = 212
		refs = "0000 __gnu_local_gp 0010 _nl_current_LC_CTYPE 0054 __rawmemchr 006c strcmp"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 27 BD FF D0 AF B3 00 28 00 62 10 21 8C 42 00 00 AF BF 00 2C AF B2 00 24 8C 53 00 00 AF B1 00 20 AF B0 00 1C AF BC 00 10 8E 70 00 50 82 02 00 00 10 40 00 1B 00 80 90 21 0? ?? ?? ?? 00 00 88 21 0? ?? ?? ?? 26 31 00 01 80 43 00 01 10 60 00 14 24 50 00 01 02 00 28 21 0? ?? ?? ?? 02 40 20 21 02 00 20 21 14 40 FF F6 00 00 28 21 8E 62 00 6C 8F BF 00 2C 8F B2 00 24 02 22 10 21 24 42 00 08 00 02 10 80 02 62 98 21 8E 62 00 04 8F B1 00 20 8F B3 00 28 8F B0 00 1C 03 E0 00 08 27 BD 00 30 8F BF 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 00 00 10 21 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "critical_factorization"
		size = 428
		refs = "0000 __gnu_local_gp 0008 __libc_tsd_CTYPE_TOLOWER"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 8F 8D ?? ?? 7C 03 E8 3B 24 0E 00 01 01 A3 10 21 8C 4B 00 00 24 07 00 01 00 00 40 21 24 02 FF FF 00 82 18 21 00 67 60 21 00 E8 18 21 00 65 48 2B 11 20 00 15 00 83 50 21 91 89 00 00 91 4A 00 00 00 09 48 80 00 0A 50 80 01 6A 50 21 01 69 48 21 91 4A 00 03 91 29 00 03 01 49 60 2B 11 80 00 35 00 00 00 00 00 60 40 21 24 07 00 01 00 62 70 23 00 82 18 21 00 67 60 21 00 E8 18 21 00 65 48 2B 15 20 FF ED 00 83 50 21 7C 03 E8 3B 01 A3 68 21 8D AC 00 00 AC CE 00 00 24 07 00 01 24 0E 00 01 00 00 40 21 24 0B FF FF 00 8B 18 21 00 67 68 21 00 E8 18 21 00 65 48 2B 11 20 00 15 00 83 50 21 91 A9 00 00 91 4A 00 00 00 09 48 80 00 0A 50 80 01 8A 50 21 01 89 48 21 91 4A 00 03 91 29 00 03 01 2A 68 2B 11 A0 00 1A 00 00 00 00 00 60 40 21 24 07 00 01 00 6B 70 23 00 8B 18 21 00 67 68 21 00 E8 18 21 00 65 48 2B 15 20 FF ED 00 83 50 21 24 42 00 01 25 6B 00 01 01 62 18 2B 14 60 00 03 00 00 00 00 AC CE 00 00 01 60 10 21 03 E0 00 08 00 00 00 00 11 49 00 0D 00 00 00 00 01 00 10 21 24 0E 00 01 25 08 00 01 0? ?? ?? ?? 24 07 00 01 11 49 00 0A 00 00 00 00 01 00 58 21 24 0E 00 01 25 08 00 01 0? ?? ?? ?? 24 07 00 01 10 EE 00 07 00 00 00 00 0? ?? ?? ?? 24 E7 00 01 10 EE 00 06 00 00 00 00 0? ?? ?? ?? 24 E7 00 01 00 60 40 21 0? ?? ?? ?? 24 07 00 01 00 60 40 21 0? ?? ?? ?? 24 07 00 01 }
	condition:
		$1
}

rule file_25_1_0 {
	meta:
		name = "two_way_long_needle"
		size = 1400
		refs = "0008 __gnu_local_gp 0084 __libc_tsd_CTYPE_TOLOWER 00e0 __strncasecmp 0134 memchr"
	strings:
		$1 = { 27 BD FB 90 27 AF 04 18 3C 1C ?? ?? 00 A0 50 21 27 9C ?? ?? AF B7 04 64 AF B6 04 60 00 C0 B8 21 00 80 B0 21 00 E0 28 21 00 C0 20 21 01 E0 30 21 AF B2 04 50 AF B0 04 48 AF BC 00 10 AF AA 04 40 AF BF 04 6C AF BE 04 68 AF B5 04 5C AF B4 04 58 AF B3 04 54 AF B1 04 4C 0? ?? ?? ?? 00 E0 90 21 8F BC 00 10 8F AA 04 40 00 40 80 21 27 A3 00 18 AC 72 00 00 24 63 00 04 15 E3 FF FD 00 00 00 00 12 40 00 12 8F 94 ?? ?? 7C 03 E8 3B 02 83 20 21 8C 86 00 00 02 E0 10 21 02 57 28 21 26 43 FF FF 90 44 00 00 27 A7 00 18 24 42 00 01 00 04 20 80 00 C4 20 21 8C 84 00 00 00 04 20 80 00 E4 20 21 AC 83 00 00 14 45 FF F6 24 63 FF FF 8F A7 04 18 02 E0 20 21 02 00 30 21 02 E7 28 21 AF AA 04 40 0? ?? ?? ?? AF A7 04 20 14 40 00 93 8F AA 04 40 7C 03 E8 3B 02 83 10 21 26 03 FF FF 02 E3 38 21 AF A3 04 2C 8F A3 04 20 00 00 A0 21 8C 51 00 00 02 92 98 21 24 02 00 01 02 43 18 23 00 50 10 23 02 CA 20 21 00 00 28 21 02 6A 30 23 AF A7 04 24 AF A3 04 28 0? ?? ?? ?? AF A2 04 30 00 00 A8 21 14 40 00 1C 26 5E FF FF 12 60 00 1A 02 D3 10 21 90 42 FF FF 27 A4 00 18 00 02 10 80 02 22 10 21 8C 42 00 00 00 02 10 80 00 82 10 21 8C 42 00 00 10 40 00 1D 02 B0 68 2B 12 A0 00 04 8F A7 04 20 00 47 18 2B 8F A7 04 28 00 E3 10 0B 02 82 A0 21 00 00 A8 21 02 60 50 21 02 92 98 21 02 CA 20 21 00 00 28 21 0? ?? ?? ?? 02 6A 30 23 10 40 FF E6 00 00 00 00 00 00 10 21 8F BF 04 6C 8F BE 04 68 8F B7 04 64 8F B6 04 60 8F B5 04 5C 8F B4 04 58 8F B3 04 54 8F B2 04 50 8F B1 04 4C 8F B0 04 48 03 E0 00 08 27 BD 04 70 02 00 18 21 02 AD 18 0A 00 74 10 21 00 7E 20 2B 02 E3 50 21 10 80 00 1D 02 C2 10 21 91 45 00 00 90 44 00 00 00 05 28 80 00 04 20 80 02 25 28 21 02 24 20 21 8C A5 00 00 8C 84 00 00 14 A4 00 3E 00 03 30 23 01 46 50 21 0? ?? ?? ?? 00 46 30 21 90 84 00 00 90 42 00 00 00 04 20 80 00 02 10 80 02 24 20 21 02 22 10 21 8C 84 00 00 8C 42 00 00 14 82 00 32 8F A7 04 30 24 63 00 01 00 7E 28 2B 01 43 20 21 14 A0 FF F2 00 C3 10 21 8F A7 04 2C 02 87 50 21 11 A0 00 BA 02 CA 50 21 8F A3 04 24 8F A7 04 24 90 64 00 00 91 43 00 00 24 E2 FF FF 00 04 20 80 00 03 18 80 02 24 20 21 02 23 18 21 8C 85 00 00 8C 64 00 00 14 A4 00 AD 25 43 FF FF 02 B0 68 23 01 4D 68 21 0? ?? ?? ?? 02 0A 50 23 24 63 FF FF 90 45 00 01 90 64 00 01 00 05 28 80 00 04 20 80 02 25 28 21 02 24 20 21 8C A5 00 00 8C 84 00 00 14 A4 00 05 26 AC 00 01 24 42 FF FF 14 6D FF F3 00 6A 30 21 26 AC 00 01 00 CC 30 2B 14 C0 00 99 8F A7 04 20 8F B5 04 28 02 60 50 21 0? ?? ?? ?? 02 87 A0 21 8F A7 04 30 00 00 A8 21 02 60 50 21 00 F4 58 21 0? ?? ?? ?? 01 63 A0 21 02 50 10 23 00 50 18 2B 02 03 10 0B 7C 03 E8 3B 00 60 20 21 26 03 FF FF 02 E3 38 21 AF A7 04 30 02 84 20 21 AF A3 04 20 26 54 FF FF 00 10 18 23 AF A3 04 28 02 14 38 2B 8F A3 04 30 AF A7 04 2C 8F A7 04 30 02 F0 B8 21 AF B7 04 24 24 63 FF FF AF A3 04 38 00 F0 A8 23 8F A3 04 24 8F A7 04 28 24 17 00 01 8C 93 00 00 24 42 00 01 02 F0 B8 23 AF B7 04 34 AF A2 04 3C AF A2 04 18 00 00 F0 21 00 67 B8 21 03 D2 88 21 02 CA 20 21 00 00 28 21 0? ?? ?? ?? 02 2A 30 23 14 40 FF 79 00 00 10 21 12 20 FF 76 02 D1 10 21 90 42 FF FF 27 A3 00 18 00 02 10 80 02 62 10 21 8C 42 00 00 00 02 10 80 00 62 10 21 8C 42 00 00 10 40 00 04 8F A7 04 2C 03 C2 F0 21 0? ?? ?? ?? 02 20 50 21 03 D0 30 21 10 E0 00 1E 02 C6 30 21 8F A7 04 24 90 C2 00 00 90 E3 00 00 00 02 10 80 02 62 10 21 00 03 18 80 02 63 18 21 8C 63 00 00 8C 42 00 00 14 62 00 3E 8F A7 04 28 02 00 18 21 0? ?? ?? ?? 00 C7 30 21 90 84 00 00 90 42 00 00 00 04 20 80 00 02 10 80 02 64 20 21 02 62 10 21 8C 84 00 00 8C 42 00 00 14 82 00 33 8F A7 04 34 24 63 00 01 00 74 28 2B 02 E3 20 21 14 A0 FF F2 00 C3 10 21 8F A7 04 20 24 02 FF FF 03 C7 18 21 10 E2 00 1A 02 C3 18 21 8F A7 04 30 90 62 00 00 90 E4 00 00 00 02 10 80 02 62 10 21 00 04 20 80 02 64 20 21 8C 84 00 00 8C 42 00 00 14 82 00 22 24 63 FF FF 0? ?? ?? ?? 8F A2 04 38 90 45 00 00 90 64 00 01 00 05 28 80 00 04 20 80 02 65 28 21 02 64 20 21 8C A5 00 00 8C 84 00 00 14 A4 00 16 24 42 FF FF 14 55 FF F5 24 63 FF FF 8F BF 04 6C 02 DE 10 21 8F B7 04 64 8F BE 04 68 8F B6 04 60 8F B5 04 5C 8F B4 04 58 8F B3 04 54 8F B2 04 50 8F B1 04 4C 8F B0 04 48 03 E0 00 08 27 BD 04 70 02 00 18 21 8F A7 04 34 02 20 50 21 00 FE 70 21 0? ?? ?? ?? 01 C3 F0 21 8F A3 04 3C 02 20 50 21 0? ?? ?? ?? 03 C3 F0 21 0? ?? ?? ?? 02 00 30 21 0? ?? ?? ?? 02 D4 10 21 }
	condition:
		$1
}

rule file_25_2_0 {
	meta:
		name = "__strcasestr"
		size = 1484
		refs = "0000 __gnu_local_gp 004c __libc_tsd_CTYPE_TOLOWER 014c __strncasecmp 01b0 memchr"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF 98 27 9C ?? ?? AF B7 00 5C AF BF 00 64 AF BE 00 60 AF B6 00 58 AF B5 00 54 AF B4 00 50 AF B3 00 4C AF B2 00 48 AF B1 00 44 AF B0 00 40 AF BC 00 10 80 82 00 00 10 40 01 5C 00 A0 B8 21 80 A7 00 00 10 E0 01 5C 8F 86 ?? ?? 7C 03 E8 3B 00 60 28 21 00 C5 28 21 8C A6 00 00 02 E0 18 21 00 80 40 21 0? ?? ?? ?? 24 05 00 01 80 67 00 00 10 E0 00 13 00 00 00 00 30 42 00 FF 30 E7 00 FF 00 02 10 80 00 07 38 80 00 C2 10 21 00 C7 38 21 8C 49 00 00 8C E7 00 00 25 08 00 01 81 02 00 00 01 27 38 26 2C E7 00 01 24 63 00 01 14 40 FF EF 00 A7 28 24 80 62 00 00 14 40 00 A6 8F BF 00 64 14 A0 00 0B 00 80 10 21 00 77 B0 23 2E C2 00 20 24 95 00 01 14 40 00 12 26 C8 FF FF 02 A0 20 21 01 00 28 21 02 E0 30 21 0? ?? ?? ?? 02 C0 38 21 8F BF 00 64 8F BE 00 60 8F B7 00 5C 8F B6 00 58 8F B5 00 54 8F B4 00 50 8F B3 00 4C 8F B2 00 48 8F B1 00 44 8F B0 00 40 03 E0 00 08 27 BD 00 68 02 E0 20 21 02 C0 28 21 27 A6 00 18 0? ?? ?? ?? AF A8 00 3C 8F A3 00 18 02 E0 20 21 00 40 30 21 02 E3 28 21 AF A3 00 20 0? ?? ?? ?? 00 40 98 21 8F BC 00 10 7C 03 E8 3B 14 40 00 68 8F A8 00 3C 00 60 10 21 26 63 FF FF AF A3 00 24 8F 83 ?? ?? 00 00 A0 21 00 00 F0 21 00 62 10 21 8F A3 00 24 8C 50 00 00 24 02 00 01 02 E3 88 21 8F A3 00 20 00 53 10 23 AF A2 00 28 02 C3 18 23 AF A3 00 2C 03 D6 90 21 02 A8 20 21 00 00 28 21 0? ?? ?? ?? 02 48 30 23 14 40 00 67 8F BF 00 64 12 40 00 65 02 93 18 2B 02 60 10 21 02 83 10 0A 00 40 18 21 00 5E 28 21 00 56 10 2B 02 E3 30 21 10 40 00 1D 02 A5 28 21 90 C4 00 00 90 A2 00 00 00 04 20 80 00 02 10 80 02 04 20 21 02 02 10 21 8C 84 00 00 8C 42 00 00 14 82 00 5F 00 03 10 23 00 C2 30 21 0? ?? ?? ?? 00 A2 28 21 91 42 00 00 91 24 00 00 00 02 10 80 00 04 20 80 02 02 10 21 02 04 20 21 8C 42 00 00 8C 88 00 00 14 48 00 53 8F A2 00 28 24 63 00 01 00 76 40 2B 00 C3 50 21 15 00 FF F2 00 A3 48 21 8F A3 00 24 02 93 10 2B 03 C3 40 21 10 40 00 D0 02 A8 40 21 92 24 00 00 91 03 00 00 26 22 FF FF 00 04 20 80 00 03 18 80 02 04 20 21 02 03 18 21 8C 85 00 00 8C 64 00 00 14 A4 00 C5 25 03 FF FF 02 93 48 23 01 09 48 21 0? ?? ?? ?? 02 68 40 23 24 63 FF FF 90 45 00 01 90 64 00 01 00 05 28 80 00 04 20 80 02 05 28 21 02 04 20 21 8C A5 00 00 8C 84 00 00 14 A4 00 05 26 8C 00 01 24 42 FF FF 14 69 FF F3 00 68 30 21 26 8C 00 01 00 CC 30 2B 14 C0 00 B6 8F B4 00 2C 8F A2 00 20 02 40 40 21 0? ?? ?? ?? 03 C2 F0 21 8F 84 ?? ?? 00 60 10 21 02 F3 18 21 00 82 10 21 90 64 00 00 8C 54 00 00 26 7E 00 01 00 04 20 80 02 84 20 21 02 B3 18 21 01 1E 10 2B AF A3 00 20 10 40 00 1B 90 91 00 03 02 76 30 23 02 A8 20 21 00 00 28 21 0? ?? ?? ?? 24 C6 00 02 10 40 00 14 03 C0 40 21 8F BF 00 64 8F BE 00 60 8F B7 00 5C 8F B6 00 58 8F B5 00 54 8F B4 00 50 8F B3 00 4C 8F B2 00 48 8F B1 00 44 8F B0 00 40 00 00 10 21 03 E0 00 08 27 BD 00 68 8F A2 00 28 00 00 A0 21 02 40 40 21 00 5E F0 21 0? ?? ?? ?? 03 C3 F0 21 02 D3 10 23 00 53 20 2B 02 64 10 0B 24 42 00 01 8F A4 00 20 26 63 FF FF AF A2 00 18 AF A2 00 30 24 02 00 01 00 53 10 23 AF A3 00 24 02 E3 18 21 AF A3 00 28 AF A2 00 34 03 D6 18 2B 90 82 00 00 AF A3 00 2C 8F A3 00 28 00 02 10 80 02 82 10 21 24 63 FF FF AF A3 00 38 90 42 00 03 8F A3 00 28 02 FE 90 21 24 8F 00 01 12 22 00 09 00 73 B8 23 10 40 FF D0 01 E0 20 21 90 82 00 00 00 02 10 80 02 82 10 21 90 42 00 03 16 22 FF F9 24 8F 00 01 8F A3 00 20 01 E3 78 23 8F A3 00 2C 10 60 00 20 25 EF FF FF 90 86 00 01 92 42 00 00 26 45 00 01 00 06 30 80 02 86 30 21 00 02 10 80 02 82 10 21 8C C6 00 00 8C 58 00 00 24 84 00 02 30 CE 00 FF 13 0E 00 0E 03 C0 10 21 0? ?? ?? ?? 30 C6 00 FF 90 86 FF FF 90 AE FF FF 00 06 30 80 02 86 30 21 00 0E 70 80 02 8E 70 21 8C C6 00 00 8D D8 00 00 30 CE 00 FF 17 0E 00 29 30 C6 00 FF 24 42 00 01 00 56 30 2B 24 84 00 01 14 C0 FF F1 24 A5 00 01 8F A3 00 24 24 02 FF FF 01 E3 20 21 10 62 00 1D 02 A4 20 21 8F A3 00 28 90 85 00 00 24 84 FF FF 90 62 00 00 00 05 28 80 02 85 28 21 00 02 10 80 02 82 10 21 8C A5 00 00 8C 4E 00 00 30 A6 00 FF 11 C6 00 0E 8F A2 00 38 0? ?? ?? ?? 30 A5 00 FF 90 85 00 01 90 46 00 00 00 05 28 80 00 06 30 80 02 85 28 21 02 86 30 21 8C A5 00 00 8C CE 00 00 30 A6 00 FF 15 C6 00 17 24 42 FF FF 14 57 FF F4 24 84 FF FF 0? ?? ?? ?? 02 AF 10 21 10 C0 FF 81 8F A3 00 34 00 6F 78 21 01 E2 80 21 02 16 70 21 01 C8 30 23 02 A8 20 21 00 00 28 21 0? ?? ?? ?? AF AE 00 3C 14 40 FF 77 8F AE 00 3C 11 C0 FF 75 02 13 78 21 02 AF 78 21 01 C0 40 21 0? ?? ?? ?? 01 E0 20 21 30 A5 00 FF 10 A0 FF 6E 8F A3 00 30 0? ?? ?? ?? 01 E3 80 21 0? ?? ?? ?? 02 60 30 21 00 A0 18 21 0? ?? ?? ?? 24 05 00 01 0? ?? ?? ?? 00 80 10 21 0? ?? ?? ?? 02 BE 10 21 }
	condition:
		$1
}

rule file_26_0_0 {
	meta:
		name = "__libc_csu_init"
		size = 212
		refs = "0010 __preinit_array_start 000c __preinit_array_end 006c __init_array_start 0070 __init_array_end 0080 _init"
	strings:
		$1 = { 27 BD FF C8 AF B5 00 30 AF B1 00 20 3C 15 ?? ?? 3C 11 ?? ?? 26 31 ?? ?? 26 B5 ?? ?? 02 B1 A8 23 00 15 A8 83 AF B4 00 2C AF B3 00 28 AF B2 00 24 AF B0 00 1C AF BF 00 34 00 80 90 21 00 A0 98 21 00 C0 A0 21 12 A0 00 09 00 00 80 21 8E 39 00 00 02 40 20 21 02 60 28 21 02 80 30 21 03 20 F8 09 26 10 00 01 16 15 FF F9 26 31 00 04 3C 11 ?? ?? 3C 15 ?? ?? 26 31 ?? ?? 26 B5 ?? ?? 02 B1 A8 23 0? ?? ?? ?? 00 15 A8 83 12 A0 00 09 00 00 80 21 8E 39 00 00 02 40 20 21 02 60 28 21 02 80 30 21 03 20 F8 09 26 10 00 01 16 15 FF F9 26 31 00 04 8F BF 00 34 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_26_1_0 {
	meta:
		name = "__libc_csu_fini"
		size = 100
		refs = "0004 __fini_array_start 000c __fini_array_end 005c _fini"
	strings:
		$1 = { 27 BD FF D8 3C 02 ?? ?? AF B0 00 1C 3C 10 ?? ?? 24 42 ?? ?? 26 10 ?? ?? 02 02 80 23 00 10 80 83 AF B1 00 20 26 11 FF FF 00 11 88 80 AF BF 00 24 12 00 00 07 00 51 88 21 8E 39 00 00 26 10 FF FF 03 20 F8 09 26 31 FF FC 16 00 FF FB 00 00 00 00 8F BF 00 24 8F B1 00 20 8F B0 00 1C 0? ?? ?? ?? 27 BD 00 28 }
	condition:
		$1
}

rule file_27_0_0 {
	meta:
		name = "xdr_rmtcallres"
		size = 144
		refs = "0008 xdr_u_long 002c xdr_reference"
	strings:
		$1 = { 8C A2 00 00 27 BD FF D0 3C 07 ?? ?? 24 06 00 04 AF B0 00 24 24 E7 ?? ?? 00 A0 80 21 27 A5 00 18 AF B1 00 28 AF BF 00 2C 00 80 88 21 0? ?? ?? ?? AF A2 00 18 14 40 00 07 02 20 20 21 8F BF 00 2C 8F B1 00 28 8F B0 00 24 00 00 10 21 03 E0 00 08 27 BD 00 30 0? ?? ?? ?? 26 05 00 04 10 40 FF F8 8F BF 00 2C 8F A2 00 18 8E 19 00 0C 8E 05 00 08 02 20 20 21 03 20 F8 09 AE 02 00 00 8F BF 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_27_1_0 {
	meta:
		name = "xdr_rmtcall_args"
		size = 300
		refs = "0020 xdr_u_long"
	strings:
		$1 = { 27 BD FF C8 AF B1 00 24 AF B0 00 20 AF BF 00 34 AF B4 00 30 AF B3 00 2C AF B2 00 28 00 80 80 21 0? ?? ?? ?? 00 A0 88 21 14 40 00 0A 02 00 20 21 00 00 10 21 8F BF 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 38 0? ?? ?? ?? 26 25 00 04 10 40 FF F5 00 00 10 21 02 00 20 21 0? ?? ?? ?? 26 25 00 08 10 40 FF F0 00 00 10 21 8E 02 00 04 AF A0 00 18 8C 59 00 10 03 20 F8 09 02 00 20 21 02 00 20 21 27 A5 00 18 0? ?? ?? ?? 00 40 90 21 10 40 FF E5 00 00 10 21 8E 02 00 04 8C 59 00 10 03 20 F8 09 02 00 20 21 8E 39 00 14 8E 25 00 10 02 00 20 21 03 20 F8 09 00 40 98 21 10 40 FF DA 00 00 10 21 8E 02 00 04 8C 59 00 10 03 20 F8 09 02 00 20 21 8E 03 00 04 00 53 98 23 02 00 20 21 8C 79 00 14 02 40 28 21 AE 33 00 0C 03 20 F8 09 00 40 A0 21 02 00 20 21 0? ?? ?? ?? 26 25 00 0C 10 40 FF C8 02 00 20 21 8E 02 00 04 8C 59 00 14 03 20 F8 09 02 80 28 21 0? ?? ?? ?? 24 02 00 01 }
	condition:
		$1
}

rule file_27_2_0 {
	meta:
		name = "pmap_rmtcall"
		size = 296
		refs = "0060 clntudp_create 0074 xdr_rmtcallres 0090 xdr_rmtcall_args"
	strings:
		$1 = { 3C 02 ?? ?? 24 43 ?? ?? 27 BD FF 88 8C 63 00 04 AF B2 00 68 00 E0 90 21 8C 47 ?? ?? 24 02 00 6F AF B4 00 70 AF B3 00 6C AF B1 00 64 AF B0 00 60 AF BF 00 74 00 A0 A0 21 A4 82 00 02 3C 05 00 01 27 A2 00 50 AF A2 00 14 00 C0 98 21 24 02 FF FF AF A3 00 10 34 A5 86 A0 24 06 00 02 00 80 88 21 0? ?? ?? ?? AF A2 00 50 00 40 80 21 12 00 00 25 24 02 00 10 3C 03 ?? ?? 24 63 ?? ?? 8E 02 00 04 AF A3 00 10 27 A3 00 40 AF A3 00 14 8F A3 00 98 3C 06 ?? ?? 02 00 20 21 AF A3 00 18 8F A3 00 9C 24 05 00 05 24 C6 ?? ?? AF A3 00 1C 8C 59 00 00 8F A2 00 8C 27 A7 00 28 AF B4 00 28 AF A2 00 38 8F A2 00 88 AF B3 00 2C AF B2 00 30 AF A2 00 3C 8F A2 00 A0 AF A2 00 40 8F A2 00 94 AF A2 00 48 8F A2 00 90 03 20 F8 09 AF A2 00 4C 8E 03 00 04 02 00 20 21 8C 79 00 10 03 20 F8 09 AF A2 00 58 8F A2 00 58 8F BF 00 74 A6 20 00 02 8F B4 00 70 8F B3 00 6C 8F B2 00 68 8F B1 00 64 8F B0 00 60 03 E0 00 08 27 BD 00 78 }
	condition:
		$1
}

rule file_27_3_0 {
	meta:
		name = "clnt_broadcast"
		size = 1332
		refs = "0000 __gnu_local_gp 0048 authunix_create_default 0060 __socket 0084 __setsockopt 009c getifaddrs 0128 freeifaddrs 0148 _create_xid 01e8 xdrmem_create 01f4 xdr_callmsg 0090 _libc_intl_domainname 020c $LC1 0218 __dcgettext 0224 perror 022c __close 027c $LC0 028c xdr_rmtcall_args 02cc __libc_errno 0320 __sendto 0334 $LC3 00a8 $LC2 035c _null_auth 0378 xdr_rmtcallres 039c __poll 03e8 $LC4 0444 __recvfrom 0474 xdr_replymsg 0498 xdr_void 04f0 $LC5"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD D6 E0 27 9C ?? ?? AF BF 29 1C AF B7 29 14 AF B6 29 10 AF B5 29 0C AF B3 29 04 AF B2 29 00 AF B1 28 FC AF B0 28 F8 AF BC 00 18 00 80 B8 21 00 A0 B0 21 00 C0 A8 21 00 E0 90 21 AF BE 29 18 AF B4 29 08 0? ?? ?? ?? 24 13 00 01 24 04 00 02 24 05 00 01 24 06 00 11 00 40 80 21 0? ?? ?? ?? AF B3 28 E4 04 40 00 83 00 40 88 21 24 02 00 04 AF A2 00 10 02 20 20 21 34 05 FF FF 24 06 00 20 0? ?? ?? ?? 27 A7 28 E4 04 40 00 5F 3C 04 ?? ?? 27 A4 00 20 AF B1 28 D8 0? ?? ?? ?? A7 B3 28 DC 14 40 00 A7 3C 04 ?? ?? 8F A4 00 20 10 80 01 0D 00 80 10 21 00 00 98 21 24 05 00 03 0? ?? ?? ?? 24 06 00 02 8C 42 00 00 10 40 00 16 2A 63 00 14 10 60 00 14 00 00 00 00 8C 43 00 08 30 63 00 03 14 65 FF F8 00 00 00 00 8C 43 00 0C 10 60 FF F5 00 00 00 00 94 63 00 00 14 66 FF F2 27 A8 00 20 8C 47 00 14 8C 42 00 00 00 13 18 80 8C E7 00 04 01 03 18 21 26 73 00 01 AC 67 27 D8 14 40 FF EC 2A 63 00 14 0? ?? ?? ?? 00 00 00 00 24 02 00 02 A7 A2 28 C8 24 02 00 6F AF A0 28 CC AF A0 28 D0 AF A0 28 D4 0? ?? ?? ?? A7 A2 28 CA 24 04 00 05 AF A4 28 5C 3C 04 00 01 24 03 00 02 34 84 86 A0 AF A3 28 58 AF A4 28 54 AF A3 28 50 8E 05 00 00 8E 04 00 04 8E 03 00 08 AF A2 28 48 00 40 A0 21 8F A2 29 30 AF A5 28 60 AF A4 28 64 AF A3 28 68 8E 09 00 0C 8E 08 00 10 AF A2 28 88 27 A2 28 E0 8E 03 00 14 8F B9 29 34 AF A2 28 A8 8F A2 29 38 27 A4 28 90 27 A5 22 80 24 06 05 78 00 00 38 21 AF A9 28 6C AF A8 28 70 AF A3 28 74 AF B9 28 B4 AF A2 28 B0 AF A0 28 4C AF B7 28 78 AF B6 28 7C AF B5 28 80 0? ?? ?? ?? AF B2 28 8C 27 A4 28 90 0? ?? ?? ?? 27 A5 28 48 14 40 00 23 27 A4 28 90 0? ?? ?? ?? 24 12 00 01 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 00 40 20 21 0? ?? ?? ?? 24 12 00 03 0? ?? ?? ?? 02 20 20 21 8E 03 00 20 8C 79 00 10 03 20 F8 09 02 00 20 21 8F BF 29 1C 02 40 10 21 8F BE 29 18 8F B7 29 14 8F B6 29 10 8F B5 29 0C 8F B4 29 08 8F B3 29 04 8F B2 29 00 8F B1 28 FC 8F B0 28 F8 03 E0 00 08 27 BD 29 20 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 27 A5 28 78 10 40 FF E5 24 12 00 01 8F A2 28 94 8C 59 00 10 03 20 F8 09 27 A4 28 90 00 40 90 21 8F A2 28 94 8C 59 00 1C 13 20 00 04 8F BC 00 18 03 20 F8 09 27 A4 28 90 8F BC 00 18 8F 95 ?? ?? 7C 03 E8 3B 00 60 10 21 24 03 0F A0 AF A3 28 F0 02 A2 A8 21 12 60 00 1B 27 BE 27 F8 00 00 B8 21 0? ?? ?? ?? 24 16 00 10 12 F3 00 16 27 DE 00 04 8F C2 00 00 27 A8 28 C8 AF A8 00 10 AF B6 00 14 02 20 20 21 27 A5 22 80 02 40 30 21 00 00 38 21 0? ?? ?? ?? AF A2 28 CC 12 42 FF F3 26 F7 00 01 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 00 00 98 21 8F B9 29 3C 13 20 00 61 3C 02 ?? ?? 24 5E ?? ?? 3C 03 ?? ?? 8C 67 ?? ?? 8F C2 00 08 8F C3 00 04 8F A6 28 F0 3C 19 ?? ?? 27 A8 28 A8 27 39 ?? ?? 27 A4 28 D8 24 05 00 01 AF A3 28 58 AF A7 28 54 AF A2 28 5C AF A8 28 64 0? ?? ?? ?? AF B9 28 68 24 03 FF FF 10 43 00 0A 00 00 00 00 14 40 00 17 24 16 00 10 8F A3 28 F0 24 02 3E 80 24 63 07 D0 14 62 FF C7 AF A3 28 F0 0? ?? ?? ?? 24 12 00 05 8E A3 00 00 24 02 00 04 10 62 FF E2 3C 03 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 00 40 20 21 0? ?? ?? ?? 24 12 00 04 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 24 17 00 04 8E A2 00 00 14 57 00 34 3C 04 ?? ?? 27 A8 28 B8 27 B9 28 E8 AF A8 00 10 AF B9 00 14 02 20 20 21 27 A5 00 20 24 06 22 60 00 00 38 21 0? ?? ?? ?? AF B6 28 E8 04 40 FF F2 2C 43 00 04 14 60 FF C4 3C 03 ?? ?? 27 A4 28 90 27 A5 00 20 00 40 30 21 0? ?? ?? ?? 24 07 00 01 27 A4 28 90 0? ?? ?? ?? 27 A5 28 48 10 40 00 04 00 00 B0 21 8F A2 28 48 12 82 00 1D 8F A2 28 50 24 02 00 02 AF A2 28 90 3C 02 ?? ?? 27 A4 28 90 27 A5 28 48 24 42 ?? ?? 0? ?? ?? ?? AF A2 28 68 8F B9 29 34 8F A5 29 38 03 20 F8 09 27 A4 28 90 8F A2 28 94 8C 59 00 1C 13 20 00 03 00 00 00 00 03 20 F8 09 27 A4 28 90 12 C0 FF A3 3C 03 ?? ?? 0? ?? ?? ?? 00 00 90 21 0? ?? ?? ?? 00 00 98 21 3C 05 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 14 40 FF E4 24 02 00 02 8F A2 28 60 14 40 FF E1 24 02 00 02 8F A2 28 E0 8F A4 29 38 8F B9 29 3C 27 A5 28 B8 03 20 F8 09 A7 A2 28 BA 0? ?? ?? ?? 00 40 B0 21 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "compute_tzname_max"
		size = 96
		refs = "0030 __tzname_cur_max"
	strings:
		$1 = { 3C 02 ?? ?? 8C 45 ?? ?? 3C 06 ?? ?? 00 A4 20 21 80 A2 00 00 10 40 00 0C 00 A0 10 21 24 42 00 01 80 43 00 00 14 60 FF FE 24 42 00 01 24 42 FF FF 8C C3 ?? ?? 00 45 28 23 00 65 18 2B 10 60 00 02 00 00 00 00 AC C5 ?? ?? 24 45 00 01 00 A4 10 2B 14 40 FF EF 00 00 00 00 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_28_1_0 {
	meta:
		name = "__tzfile_read"
		size = 3556
		refs = "0008 __use_tzfile 0054 __libc_enable_secure 006c getenv 0068 $LC2 0088 default_tzdir.5534 009c strlen 00c8 mempcpy 00e0 memcpy 00f8 __xstat64 0124 _IO_new_fopen 09a0 $LC3 0134 fileno 0144 __fxstat64 0154 _IO_new_fclose 0170 strstr 0208 $LC1 0184 free 01d8 $LC0 01e0 memcmp 026c fread_unlocked 027c $LC4 0368 malloc 04f4 __uflow 0864 __tzstring 088c __tzname 092c __daylight 0938 __timezone 0b14 fseek 0b24 ftello 0d7c $LC5 0d80 $LC6 0d94 __assert_fail 0d84 __PRETTY_FUNCTION__.5698"
	strings:
		$1 = { 27 BD FE B8 AF B1 01 24 3C 11 ?? ?? AF BE 01 40 AF B5 01 34 AF B3 01 2C AF B2 01 28 AF B0 01 20 8E 35 ?? ?? AF BF 01 44 AF B7 01 3C AF B6 01 38 AF B4 01 30 03 A0 F0 21 00 80 80 21 00 A0 90 21 00 C0 98 21 10 80 01 08 AE 20 ?? ?? 80 94 00 00 12 80 00 4B 3C 02 ?? ?? 8C 42 ?? ?? 14 40 00 41 24 02 00 2F 12 82 01 03 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 10 40 00 04 00 40 B0 21 80 42 00 00 14 40 00 50 00 00 00 00 3C 16 ?? ?? 24 14 00 14 24 06 00 13 26 D6 ?? ?? 02 00 20 21 0? ?? ?? ?? AF C6 01 10 24 57 00 01 02 F4 10 21 24 42 00 0E 00 02 10 C2 00 02 10 C0 03 A2 E8 23 8F C6 01 10 27 B4 00 10 02 80 20 21 0? ?? ?? ?? 02 C0 28 21 24 03 00 2F A0 43 00 00 24 44 00 01 02 00 28 21 0? ?? ?? ?? 02 E0 30 21 12 A0 00 0D 3C 05 ?? ?? 24 04 00 03 02 80 28 21 0? ?? ?? ?? 27 C6 00 18 14 40 00 07 3C 05 ?? ?? 3C 02 ?? ?? 8C 43 ?? ?? 8F C4 00 28 10 83 02 20 8C 42 ?? ?? 3C 05 ?? ?? 02 80 20 21 0? ?? ?? ?? 24 A5 ?? ?? 10 40 00 14 00 40 B8 21 0? ?? ?? ?? 00 40 20 21 00 40 28 21 24 04 00 03 0? ?? ?? ?? 27 C6 00 18 10 40 00 31 00 00 00 00 0? ?? ?? ?? 02 E0 20 21 0? ?? ?? ?? 3C 10 ?? ?? 12 82 00 1C 3C 05 ?? ?? 02 00 20 21 0? ?? ?? ?? 24 A5 ?? ?? 10 40 FF BA 24 02 00 2F 3C 10 ?? ?? 0? ?? ?? ?? 8E 04 ?? ?? AE 00 ?? ?? 03 C0 E8 21 8F BF 01 44 8F BE 01 40 8F B7 01 3C 8F B6 01 38 8F B5 01 34 8F B4 01 30 8F B3 01 2C 8F B2 01 28 8F B1 01 24 8F B0 01 20 03 E0 00 08 27 BD 01 48 0? ?? ?? ?? 02 C0 20 21 00 40 30 21 0? ?? ?? ?? 24 54 00 01 3C 05 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 0F 10 40 FF E0 3C 05 ?? ?? 3C 05 ?? ?? 02 00 20 21 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 13 10 40 FF D9 3C 05 ?? ?? 0? ?? ?? ?? 3C 10 ?? ?? 3C 10 ?? ?? 0? ?? ?? ?? 8E 04 ?? ?? 8E E4 00 00 8F CB 00 18 8F C9 00 2C 8F C8 00 28 8F CA 00 60 3C 02 ?? ?? 34 84 80 00 AC 4B ?? ?? AC 40 ?? ?? 3C 02 ?? ?? AE E4 00 00 AC 49 ?? ?? 27 C4 00 B8 AC 48 ?? ?? 24 05 00 2C 3C 02 ?? ?? 24 06 00 01 02 E0 38 21 AE 00 ?? ?? 0? ?? ?? ?? AC 4A ?? ?? 24 04 00 01 14 44 00 77 3C 02 ?? ?? 27 C4 00 B8 24 45 ?? ?? 0? ?? ?? ?? 24 06 00 04 14 40 00 71 AF C2 00 F0 8F C6 00 D8 8F C4 00 DC 8F C2 00 D4 3C 05 33 33 24 A5 33 33 3C 09 ?? ?? 3C 0C ?? ?? 3C 03 ?? ?? 00 C5 28 2B AC 66 ?? ?? AD 24 ?? ?? 8F D5 00 E0 AD 82 ?? ?? 8F D6 00 D0 10 A0 00 61 8F CE 00 CC 00 06 18 80 00 66 40 21 25 08 00 03 24 05 FF FC 01 05 A0 24 00 14 38 27 00 07 38 C2 00 E4 38 2B 14 E0 00 57 00 04 38 C0 02 87 20 21 00 04 50 27 01 55 50 2B 15 40 00 52 00 95 20 21 2C 8A FF FD 11 40 00 4F 24 84 00 03 00 85 28 24 00 05 20 27 00 04 20 C2 00 82 20 2B 14 80 00 49 00 02 C0 C0 00 B8 20 21 00 04 10 27 00 52 10 2B 14 40 00 44 00 92 20 21 AF C3 00 F8 AF C5 01 04 AF C6 01 10 AF C7 01 00 AF C9 01 18 AF CC 01 08 AF CE 01 0C 0? ?? ?? ?? AF D8 00 FC AE 02 ?? ?? 8F C3 00 F8 8F C5 01 04 8F C6 01 10 8F C7 01 00 8F C9 01 18 8F CC 01 08 8F CE 01 0C 10 40 00 31 8F D8 00 FC 00 54 20 21 3C 08 ?? ?? 00 43 C8 21 00 87 38 21 3C 14 ?? ?? 00 45 28 21 3C 0A ?? ?? AD 04 ?? ?? 3C 03 ?? ?? 3C 04 ?? ?? AE 99 ?? ?? AC 87 ?? ?? AD 45 ?? ?? 12 40 00 03 AC 60 ?? ?? 00 B8 28 21 AE 65 00 00 00 40 20 21 24 05 00 05 02 E0 38 21 AF C8 01 14 AF C9 01 18 AF CA 00 F8 AF CC 01 08 0? ?? ?? ?? AF CE 01 0C 3C 05 ?? ?? 8C A4 ?? ?? 8F C8 01 14 8F C9 01 18 8F CA 00 F8 8F CC 01 08 14 44 00 0F 8F CE 01 0C 10 40 00 16 8E 85 ?? ?? 8D 26 ?? ?? 90 A4 00 00 00 86 20 2B 10 80 00 08 24 A4 00 01 00 A2 28 21 10 85 00 12 00 00 98 21 90 82 00 00 00 46 10 2B 14 40 FF FB 24 84 00 01 0? ?? ?? ?? 02 E0 20 21 0? ?? ?? ?? 00 00 00 00 3C 14 ?? ?? 0? ?? ?? ?? 26 94 ?? ?? 0? ?? ?? ?? 02 00 A0 21 8D 22 ?? ?? 10 40 00 49 3C 02 ?? ?? 00 00 98 21 27 C6 00 E4 24 07 FF FF 27 C5 00 E8 8E E2 00 04 8E F8 00 08 00 58 20 2B 10 80 00 0B 00 C0 90 21 24 44 00 01 AE E4 00 04 90 42 00 00 26 52 00 01 12 45 00 1B A2 42 FF FF 00 80 10 21 00 58 20 2B 14 80 FF F8 24 44 00 01 02 E0 20 21 AF C5 01 04 AF C6 01 10 AF C7 01 00 AF C8 01 14 AF C9 01 18 AF CA 00 F8 AF CC 01 08 0? ?? ?? ?? AF CE 01 0C 8F C7 01 00 8F C5 01 04 8F C6 01 10 8F C8 01 14 8F C9 01 18 8F CA 00 F8 8F CC 01 08 10 47 FF CF 8F CE 01 0C 8E E4 00 04 0? ?? ?? ?? 8E F8 00 08 00 98 C0 2B 13 00 01 F1 00 00 00 00 24 82 00 01 AE E2 00 04 90 82 00 00 2C 44 00 02 10 80 FF C3 8D 04 ?? ?? 00 13 90 C0 00 92 20 21 A0 82 00 04 8E E2 00 04 8E E4 00 08 00 44 20 2B 10 80 01 D0 24 44 00 01 AE E4 00 04 90 42 00 00 02 A2 20 2B 14 80 FF B6 8D 18 ?? ?? 8D 24 ?? ?? 26 73 00 01 03 12 90 21 A2 42 00 05 8F C2 00 E4 02 64 20 2B 14 80 FF BE AE 42 00 00 3C 02 ?? ?? 8C 44 ?? ?? 24 05 00 01 02 A0 30 21 02 E0 38 21 AF C8 01 14 AF C9 01 18 AF CA 00 F8 AF CC 01 08 0? ?? ?? ?? AF CE 01 0C 8F C8 01 14 8F C9 01 18 8F CA 00 F8 8F CC 01 08 16 A2 FF 9D 8F CE 01 0C 8D 82 ?? ?? 00 00 28 21 27 C6 00 E4 24 07 FF FF 10 40 00 3F 27 D3 00 E8 8E E4 00 08 00 C0 90 21 8E E2 00 04 00 44 C0 2B 13 00 01 91 24 58 00 01 AE F8 00 04 90 42 00 00 26 52 00 01 16 53 FF F8 A2 42 FF FF 8D 42 ?? ?? 8F D9 00 E4 00 05 C0 C0 00 58 10 21 AC 59 00 00 8E E2 00 04 00 44 20 2B 10 80 00 0C 00 C0 90 21 24 44 00 01 AE E4 00 04 90 42 00 00 26 52 00 01 12 53 00 1D A2 42 FF FF 8E E4 00 08 8E E2 00 04 00 44 20 2B 14 80 FF F7 24 44 00 01 02 E0 20 21 AF C5 01 04 AF C6 01 10 AF C7 01 00 AF C8 01 14 AF C9 01 18 AF CA 00 F8 AF CC 01 08 AF CE 01 0C 0? ?? ?? ?? AF D8 00 FC 8F C7 01 00 8F C5 01 04 8F C6 01 10 8F C8 01 14 8F C9 01 18 8F CA 00 F8 8F CC 01 08 8F CE 01 0C 10 47 FF 63 8F D8 00 FC 0? ?? ?? ?? 26 52 00 01 8D 44 ?? ?? 8D 82 ?? ?? 24 A5 00 01 00 98 C0 21 8F C4 00 E4 00 A2 10 2B 14 40 FF C3 AF 04 00 04 12 C0 00 10 00 00 90 21 24 13 FF FF 8E E2 00 04 8E E4 00 08 00 44 20 2B 10 80 01 8C 24 44 00 01 AE E4 00 04 90 42 00 00 8D 05 ?? ?? 00 12 20 C0 00 02 10 2B 00 A4 20 21 26 52 00 01 16 D2 FF F3 A0 82 00 06 8D 25 ?? ?? 02 45 10 2B 10 40 00 0B 8D 04 ?? ?? 00 12 10 C0 00 05 30 C0 00 82 10 21 00 86 20 21 24 42 00 06 24 84 00 06 A0 40 00 00 24 42 00 08 14 44 FF FD 00 00 00 00 00 00 90 21 24 13 FF FF 11 C0 00 10 00 A0 10 21 8E E2 00 04 8E E4 00 08 00 44 20 2B 10 80 01 82 24 44 00 01 AE E4 00 04 90 42 00 00 8D 05 ?? ?? 00 12 20 C0 00 02 10 2B 00 A4 20 21 26 52 00 01 15 D2 FF F3 A0 82 00 07 8D 22 ?? ?? 02 42 20 2B 10 80 00 0B 8D 05 ?? ?? 00 12 90 C0 00 02 20 C0 00 B2 10 21 24 A5 00 07 24 42 00 07 00 A4 20 21 A0 40 00 00 24 42 00 08 14 44 FF FD 00 00 00 00 83 C2 00 BC 14 40 00 A3 3C 03 ?? ?? 8C 62 ?? ?? 10 40 00 07 02 E0 20 21 80 42 00 00 14 40 00 04 00 00 00 00 3C 04 ?? ?? AC 80 ?? ?? 02 E0 20 21 AF C8 01 14 0? ?? ?? ?? AF C9 01 18 8F C9 01 18 00 00 80 21 8D 22 ?? ?? 10 40 00 11 8F C8 01 14 8D 03 ?? ?? 00 10 10 C0 3C 05 ?? ?? 00 62 10 21 90 42 00 05 8C A4 ?? ?? AF C8 01 14 AF C9 01 18 0? ?? ?? ?? 00 82 20 21 8F C9 01 18 26 10 00 01 8D 22 ?? ?? 02 02 10 2B 14 40 FF F1 8F C8 01 14 3C 05 ?? ?? 8C B3 ?? ?? 3C 10 ?? ?? 26 17 ?? ?? AE 00 ?? ?? AE E0 00 04 12 60 00 D8 AF D7 00 F4 8E 82 ?? ?? 26 73 FF FF 8D 03 ?? ?? 00 53 10 21 90 42 00 00 00 02 10 C0 00 62 10 21 90 52 00 04 00 12 B0 80 02 F6 B0 21 8E C4 00 00 10 80 00 1E 3C 03 ?? ?? 16 60 FF F3 8E 82 ?? ?? 8E 02 ?? ?? 10 40 00 C7 8D 23 ?? ?? 8E E2 00 04 10 40 00 C0 3C 02 ?? ?? 0? ?? ?? ?? 02 A0 20 21 3C 03 ?? ?? 8C 62 ?? ?? 14 40 00 33 8E 87 ?? ?? 8D 02 ?? ?? 8C 49 00 00 3C 02 ?? ?? AC 49 ?? ?? 3C 02 ?? ?? AC 49 ?? ?? 8F C3 00 F0 3C 02 ?? ?? 00 09 48 23 AC 43 ?? ?? 3C 02 ?? ?? AC 49 ?? ?? 24 02 00 01 0? ?? ?? ?? AE 22 ?? ?? 90 42 00 05 8C 64 ?? ?? AF C8 01 14 AF C9 01 18 0? ?? ?? ?? 00 82 20 21 24 04 00 01 8F C5 00 F4 00 92 18 23 00 03 18 80 AE C2 00 00 00 65 18 21 8C 62 00 00 8F C8 01 14 10 40 FF D4 8F C9 01 18 3C 02 ?? ?? 0? ?? ?? ?? 8C 42 ?? ?? 8F C3 00 2C 14 62 FD E0 3C 05 ?? ?? 3C 02 ?? ?? 8C 43 ?? ?? 14 60 FD DC 8F C4 00 18 8C 42 ?? ?? 14 44 FD D9 3C 02 ?? ?? 8C 42 ?? ?? 8F C3 00 60 14 62 FD D5 24 02 00 01 0? ?? ?? ?? AE 22 ?? ?? 8D 08 ?? ?? 3C 0A ?? ?? 3C 0C ?? ?? AD 40 ?? ?? AD 80 ?? ?? 00 00 58 21 00 00 48 21 00 00 28 21 00 00 18 21 14 60 00 14 00 E2 20 21 90 84 FF FF 00 04 20 C0 01 04 20 21 90 86 00 04 14 C0 00 0E 00 00 00 00 14 A0 00 82 8C 83 00 00 00 60 48 21 24 03 00 01 24 42 FF FF 14 40 FF F2 00 00 00 00 AD 89 ?? ?? 14 A0 00 82 AD 4B ?? ?? 3C 02 ?? ?? 0? ?? ?? ?? AC 49 ?? ?? 10 A0 00 05 00 E2 20 21 14 60 00 C5 24 05 00 01 0? ?? ?? ?? 24 42 FF FF 90 84 FF FF 00 04 20 C0 01 04 20 21 90 86 00 04 10 C0 FF EC 00 00 00 00 0? ?? ?? ?? 8C 8B 00 00 27 C4 00 B8 24 05 00 2C 24 06 00 01 02 E0 38 21 AF C8 01 14 0? ?? ?? ?? AF C9 01 18 24 04 00 01 14 44 FE 6B 3C 02 ?? ?? 27 C4 00 B8 24 45 ?? ?? 0? ?? ?? ?? 24 06 00 04 14 40 FE 65 8F C6 00 E0 8F CA 00 D0 8F C5 00 D8 8F C4 00 DC 01 46 50 21 8F C6 00 CC 8F C2 00 D4 00 05 38 C0 00 E5 28 21 01 46 30 21 00 04 38 40 00 04 20 C0 00 C5 30 21 00 87 28 23 00 02 20 80 00 02 11 00 00 44 10 23 00 C5 28 21 02 E0 20 21 00 A2 28 21 0? ?? ?? ?? 24 06 00 01 14 40 FE 4E 00 00 00 00 0? ?? ?? ?? 02 E0 20 21 8F C8 01 14 04 40 FE 49 8F C9 01 18 8F C5 00 50 24 44 00 02 00 04 37 C3 00 A6 38 2A 14 E0 FE 43 8F D3 00 54 14 C5 00 03 02 64 20 2B 14 80 FE 3F 00 00 00 00 02 62 98 23 26 65 00 0D 8E E2 00 04 8E E4 00 08 00 05 28 C2 00 05 28 C0 03 A5 E8 23 00 44 20 2B 10 80 00 91 27 B2 00 10 24 44 00 01 AE E4 00 04 90 42 00 00 24 04 00 0A 14 44 FE 2F 26 73 FF FE 02 40 20 21 24 05 00 01 02 60 30 21 02 E0 38 21 AF C8 01 14 0? ?? ?? ?? AF C9 01 18 8F C8 01 14 16 62 FE 25 8F C9 01 18 02 53 98 21 A2 60 00 00 02 40 20 21 AF C8 01 14 0? ?? ?? ?? AF C9 01 18 3C 03 ?? ?? AC 62 ?? ?? 8F C9 01 18 0? ?? ?? ?? 8F C8 01 14 8C 42 ?? ?? 0? ?? ?? ?? AE E2 00 04 8D 23 ?? ?? 24 02 00 01 14 62 00 5C 3C 02 ?? ?? 8C 44 ?? ?? 0? ?? ?? ?? AF C8 01 14 AE 02 ?? ?? 0? ?? ?? ?? 8F C8 01 14 AD 83 ?? ?? AD 4B ?? ?? 00 60 48 21 8D 55 ?? ?? 02 A9 A8 26 00 15 A8 2B 0? ?? ?? ?? AF D5 00 F0 01 2B 58 26 00 0B 58 2B 0? ?? ?? ?? AF CB 00 F0 02 E0 20 21 AF C5 01 04 AF C6 01 10 AF C7 01 00 AF C8 01 14 AF C9 01 18 AF CA 00 F8 AF CC 01 08 0? ?? ?? ?? AF CE 01 0C 8F C7 01 00 8F C5 01 04 8F C6 01 10 8F C8 01 14 8F C9 01 18 8F CA 00 F8 8F CC 01 08 10 47 FD EE 8F CE 01 0C 0? ?? ?? ?? 8E E4 00 08 02 E0 20 21 AF C5 01 04 AF C6 01 10 AF C7 01 00 AF C8 01 14 AF C9 01 18 AF CA 00 F8 AF CC 01 08 0? ?? ?? ?? AF CE 01 0C 8F C5 01 04 8F C6 01 10 8F C7 01 00 8F C8 01 14 8F C9 01 18 8F CA 00 F8 8F CC 01 08 0? ?? ?? ?? 8F CE 01 0C 02 E0 20 21 AF C5 01 04 AF C6 01 10 AF C7 01 00 AF C8 01 14 AF C9 01 18 AF CA 00 F8 AF CC 01 08 0? ?? ?? ?? AF CE 01 0C 8F C5 01 04 8F C6 01 10 8F C7 01 00 8F C8 01 14 8F C9 01 18 8F CA 00 F8 8F CC 01 08 0? ?? ?? ?? 8F CE 01 0C 02 E0 20 21 AF C8 01 14 AF C9 01 18 0? ?? ?? ?? AF CE 01 0C 8F C8 01 14 8F C9 01 18 14 53 FE 6F 8F CE 01 0C 0? ?? ?? ?? 00 00 00 00 AD 89 ?? ?? 0? ?? ?? ?? AD 4B ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 01 EA 0? ?? ?? ?? 24 E7 ?? ?? 02 E0 20 21 AF C8 01 14 AF C9 01 18 0? ?? ?? ?? AF CE 01 0C 8F C8 01 14 8F C9 01 18 10 53 FD A7 8F CE 01 0C 0? ?? ?? ?? 8D 05 ?? ?? 02 E0 20 21 AF C8 01 14 0? ?? ?? ?? AF C9 01 18 8F C8 01 14 0? ?? ?? ?? 8F C9 01 18 }
	condition:
		$1
}

rule file_28_2_0 {
	meta:
		name = "__tzfile_default"
		size = 556
		refs = "0034 strlen 0050 $LC7 005c __tzfile_read 0064 __use_tzfile 008c mempcpy 009c memcpy 0178 __tzname 01a8 __timezone"
	strings:
		$1 = { 27 BD FF B8 AF B0 00 24 00 A0 80 21 AF BF 00 44 AF B6 00 3C AF B5 00 38 AF B4 00 34 00 E0 A8 21 AF B3 00 30 AF B2 00 2C 00 C0 98 21 AF B1 00 28 00 80 A0 21 0? ?? ?? ?? AF B7 00 40 02 00 20 21 0? ?? ?? ?? 24 51 00 01 24 56 00 01 02 D1 90 21 3C 04 ?? ?? 24 84 ?? ?? 02 40 28 21 0? ?? ?? ?? 27 A6 00 18 3C 02 ?? ?? 8C 43 ?? ?? 10 60 00 55 8F BF 00 44 3C 17 ?? ?? 8E E3 ?? ?? 2C 63 00 02 14 60 00 5A 8F A4 00 18 02 80 28 21 0? ?? ?? ?? 02 20 30 21 00 40 20 21 02 C0 30 21 0? ?? ?? ?? 02 00 28 21 3C 02 ?? ?? 8F A3 00 18 8C 46 ?? ?? 3C 02 ?? ?? AC 43 ?? ?? 24 02 00 02 10 C0 00 56 AE E2 ?? ?? 3C 02 ?? ?? 8C 43 ?? ?? 3C 0B ?? ?? 3C 02 ?? ?? 3C 0C ?? ?? 8C 4A ?? ?? 8D 6D ?? ?? 8D 87 ?? ?? 3C 02 ?? ?? 8C 44 ?? ?? 02 AD 68 23 02 67 38 23 00 66 30 21 01 40 48 21 0? ?? ?? ?? 00 00 28 21 91 02 00 06 14 40 00 13 00 00 00 00 8D 42 00 00 00 4D 10 21 AD 42 00 00 24 63 00 01 91 05 00 04 25 4A 00 04 10 66 00 13 25 29 00 04 90 68 00 00 00 08 40 C0 00 88 40 21 91 02 00 04 A0 62 00 00 91 02 00 07 14 40 FF F4 00 00 00 00 14 A0 FF EC 00 00 00 00 8D 22 00 00 24 63 00 01 25 4A 00 04 00 47 10 21 AD 22 00 00 91 05 00 04 14 66 FF EF 25 29 00 04 3C 02 ?? ?? 24 45 ?? ?? 24 03 00 01 AC 93 00 00 A0 80 00 05 A0 80 00 04 AC 95 00 08 A0 83 00 0C A0 91 00 0D 00 13 18 23 AC 54 ?? ?? 02 40 20 21 3C 02 ?? ?? AC B0 00 04 AD 93 ?? ?? AD 75 ?? ?? 0? ?? ?? ?? AC 43 ?? ?? 8F BF 00 44 8F B7 00 40 8F B6 00 3C 8F B5 00 38 8F B4 00 34 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 48 8F B7 00 40 8F B6 00 3C 8F B5 00 38 8F B4 00 34 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 AC 40 ?? ?? 03 E0 00 08 27 BD 00 48 3C 02 ?? ?? 8C 44 ?? ?? 3C 0B ?? ?? 0? ?? ?? ?? 3C 0C ?? ?? }
	condition:
		$1
}

rule file_28_3_0 {
	meta:
		name = "__tzfile_compute"
		size = 1912
		refs = "00c8 __tzname 01dc __tzstring 02b4 __daylight 02c8 __timezone 0304 strcmp 0504 $LC5 04d4 $LC6 0518 __assert_fail 0508 __PRETTY_FUNCTION__.5735 0530 __tzset_parse_tz 0540 __offtime 055c __tz_compute 05b0 strlen 0730 $LC8 0758 $LC9"
	strings:
		$1 = { 27 BD FF B8 AF B1 00 24 AF BF 00 44 AF BE 00 40 AF B7 00 3C AF B6 00 38 AF B5 00 34 AF B4 00 30 AF B3 00 2C AF B2 00 28 AF B0 00 20 AF A4 00 48 00 C0 88 21 14 A0 00 22 AF A7 00 54 3C 02 ?? ?? 8C 43 ?? ?? 3C 10 ?? ?? 8E 08 ?? ?? 8F AA 00 54 00 03 10 C0 24 42 FF F8 AE 20 00 00 8F A6 00 48 01 02 10 21 0? ?? ?? ?? AD 40 00 00 00 40 38 21 24 42 FF F8 8C 45 00 08 00 C5 28 2A 10 A0 00 C5 00 00 00 00 00 80 18 21 14 60 FF F8 24 64 FF FF 8F BF 00 44 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 48 3C 12 ?? ?? 8E 42 ?? ?? 3C 03 ?? ?? 24 73 ?? ?? AC 60 ?? ?? 10 40 01 3E AE 60 00 04 3C 03 ?? ?? 8C 69 ?? ?? 8D 23 00 00 00 83 18 2A 14 60 01 38 00 02 18 80 01 23 18 21 8C 63 FF FC 00 83 28 2A 10 A0 01 07 3C 06 88 1A 00 64 18 23 24 C6 22 EF 00 66 00 18 00 03 2F C3 00 00 30 10 00 C3 18 21 00 03 1D C3 00 65 18 23 00 62 28 2B 10 A0 00 80 24 50 FF FF 00 43 18 23 24 65 FF FF 00 05 30 80 01 26 50 21 8D 4B 00 00 00 8B 58 2A 11 60 00 9D 00 00 00 00 2C A2 00 0A 14 40 00 05 01 26 10 21 8D 42 FF D8 00 82 10 2A 14 40 00 E0 01 26 10 21 8C 42 FF FC 00 82 10 2A 10 40 00 09 00 A0 80 21 24 C6 00 04 01 26 48 21 00 A0 80 21 25 29 FF FC 8D 22 FF F8 00 82 10 2A 14 40 FF FC 26 10 FF FF 3C 14 ?? ?? 8E 82 ?? ?? 26 03 FF FF 3C 15 ?? ?? 00 43 10 21 90 42 00 00 AF A3 00 18 8E A3 ?? ?? 00 02 10 C0 3C 17 ?? ?? 00 62 10 21 90 43 00 05 8E E4 ?? ?? 90 56 00 04 AF B3 00 1C 0? ?? ?? ?? 00 83 20 21 8E 43 ?? ?? 00 16 B0 80 02 76 B0 21 02 03 18 2B AE C2 00 00 14 60 00 08 8E 8A ?? ?? 0? ?? ?? ?? 3C 03 ?? ?? 8E 42 ?? ?? 26 10 00 01 02 02 10 2B 10 40 00 1A 3C 03 ?? ?? 01 50 10 21 90 42 00 00 8E A3 ?? ?? 00 02 10 C0 00 62 10 21 90 56 00 04 90 44 00 05 00 16 F0 80 02 7E F0 21 8F C2 00 00 14 40 FF F1 8E 42 ?? ?? 8E E2 ?? ?? 0? ?? ?? ?? 00 44 20 21 24 04 00 01 8F A5 00 1C 00 96 18 23 00 03 18 80 AF C2 00 00 00 65 18 21 8C 62 00 00 10 40 FF E4 8E 8A ?? ?? 3C 03 ?? ?? 8C 62 ?? ?? 10 40 01 31 00 00 00 00 8F A5 00 18 8E B0 ?? ?? 01 45 50 21 91 43 00 00 00 03 18 C0 02 03 80 21 3C 04 ?? ?? 3C 03 ?? ?? 8C 63 ?? ?? 8C 85 ?? ?? 3C 04 ?? ?? 00 65 28 26 00 05 28 2B 00 03 18 23 AC 85 ?? ?? 3C 04 ?? ?? 10 40 00 7D AC 83 ?? ?? 8E 62 00 04 10 40 00 77 3C 02 ?? ?? 92 02 00 04 8F AA 00 58 8E E4 ?? ?? 00 02 18 80 AD 42 00 20 02 63 38 21 8C F4 00 00 92 02 00 05 02 80 28 21 0? ?? ?? ?? 00 82 20 21 14 40 01 12 8F AA 00 58 8E 02 00 00 3C 03 ?? ?? 8C 63 ?? ?? AD 54 00 28 AD 42 00 24 0? ?? ?? ?? 3C 10 ?? ?? 00 00 18 21 24 66 00 01 00 D0 10 2B 10 40 FF 98 02 03 10 21 00 02 10 42 00 02 28 80 01 25 28 21 8C A5 00 00 00 85 28 2A 10 A0 00 0C 00 00 00 00 00 40 80 21 00 D0 10 2B 10 40 FF 8D 02 03 10 21 00 02 10 42 00 02 28 80 01 25 28 21 8C A5 00 00 00 85 28 2A 14 A0 FF F6 00 00 00 00 0? ?? ?? ?? 00 40 18 21 8C E2 00 04 AE 22 00 00 8C E2 00 00 14 C2 FF 3C 8F BF 00 44 14 80 00 18 8C E2 00 04 18 40 00 16 8F AA 00 54 24 02 00 01 0? ?? ?? ?? AD 42 00 00 24 63 00 09 00 62 10 2B 10 40 00 05 00 00 00 00 8D 42 00 28 00 82 10 2A 10 40 FF D5 00 00 00 00 24 C6 00 04 01 26 48 21 00 A0 80 21 25 29 00 04 8D 22 FF FC 00 82 10 2A 10 40 FF FC 26 10 00 01 0? ?? ?? ?? 3C 14 ?? ?? 3C 05 1F FF 34 A5 FF FE 00 65 18 21 00 03 38 C0 01 07 38 21 8C E3 00 04 00 62 48 2A 11 20 FF 19 8F AA 00 54 24 09 00 01 10 80 FF 16 AD 49 00 00 8C E7 00 00 24 E7 00 01 14 E6 FF 13 8F BF 00 44 24 63 00 01 14 62 FF 11 8F BE 00 40 24 A2 00 01 00 82 10 21 00 02 10 C0 01 02 10 21 24 42 00 04 24 84 00 01 0? ?? ?? ?? 24 03 00 02 8C 46 FF F4 8C 47 FF FC 24 C6 00 01 14 E6 00 0A 8F AA 00 54 8C 47 FF F8 8C 46 00 00 24 63 00 01 24 E5 00 01 14 C5 00 16 24 42 FF F8 14 64 FF F4 00 60 40 21 8F AA 00 54 0? ?? ?? ?? AD 43 00 00 8C 42 ?? ?? 0? ?? ?? ?? AE 62 00 04 3C 02 ?? ?? 8C 43 ?? ?? 24 02 00 01 14 62 00 0C 3C 05 ?? ?? 0? ?? ?? ?? 8E E4 ?? ?? 3C 0A ?? ?? 0? ?? ?? ?? AD 42 ?? ?? 24 70 FF F5 0? ?? ?? ?? 00 00 18 21 8F A3 00 54 0? ?? ?? ?? AC 68 00 00 3C 04 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 03 15 0? ?? ?? ?? 24 E7 ?? ?? 3C 03 ?? ?? 8C 64 ?? ?? 10 80 FF 1D 00 40 80 21 0? ?? ?? ?? 00 00 00 00 8F A6 00 58 27 A4 00 48 0? ?? ?? ?? 00 00 28 21 10 40 FF 15 8E 50 ?? ?? 8F A4 00 48 8F A5 00 58 24 06 00 01 0? ?? ?? ?? 3C 12 ?? ?? 3C 10 ?? ?? 8E 43 ?? ?? 8E 05 ?? ?? 3C 15 ?? ?? 8E A2 ?? ?? 00 03 20 C0 00 A4 20 21 14 82 FE B2 8E 08 ?? ?? 3C 02 ?? ?? 8C 43 ?? ?? 24 02 00 02 14 62 00 66 3C 05 ?? ?? 0? ?? ?? ?? 00 00 00 00 8E B5 ?? ?? 3C 0A ?? ?? AD 42 ?? ?? 0? ?? ?? ?? 02 A0 20 21 24 42 00 01 0? ?? ?? ?? 02 A2 20 21 AE 62 00 04 0? ?? ?? ?? 8E 43 ?? ?? 3C 10 ?? ?? 8E 02 ?? ?? 10 40 00 50 3C 15 ?? ?? 8E A2 ?? ?? 90 43 00 04 10 60 00 11 00 00 18 21 00 00 90 21 3C 17 ?? ?? 10 60 00 43 8E E4 ?? ?? 8E 03 ?? ?? 26 52 00 01 02 43 10 2B 10 40 00 3C 8E A4 ?? ?? 00 12 10 C0 00 82 10 21 90 48 00 04 11 00 00 12 00 00 00 00 0? ?? ?? ?? 8E 63 00 04 00 00 B0 21 00 00 90 21 3C 17 ?? ?? 00 56 10 21 90 42 00 05 8E E4 ?? ?? 0? ?? ?? ?? 00 82 20 21 8E 63 00 04 3C 04 ?? ?? 10 60 00 09 AC 82 ?? ?? 8E B0 ?? ?? 0? ?? ?? ?? 02 16 80 21 00 80 10 21 10 72 00 20 00 00 00 00 0? ?? ?? ?? 00 12 B0 C0 8E 04 ?? ?? 02 44 18 2B 10 60 FF F5 8E A3 ?? ?? 00 76 80 21 92 08 00 04 15 00 00 0C 26 45 00 01 00 05 40 C0 00 68 18 21 24 63 00 04 00 A4 40 2B 11 00 FE FC 24 68 FF FC 24 63 00 08 90 69 FF F8 11 20 FF FA 24 A5 00 01 01 00 80 21 92 02 00 05 8E E4 ?? ?? 0? ?? ?? ?? 00 82 20 21 8E B0 ?? ?? 3C 05 ?? ?? AE 62 00 04 8C A2 ?? ?? 0? ?? ?? ?? 02 16 80 21 00 00 B0 21 0? ?? ?? ?? 00 00 90 21 0? ?? ?? ?? 8E A2 ?? ?? 90 42 00 05 0? ?? ?? ?? 00 82 20 21 0? ?? ?? ?? AE 62 00 04 8E A2 ?? ?? 00 00 B0 21 00 00 90 21 0? ?? ?? ?? 3C 17 ?? ?? 3C 04 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 02 B7 0? ?? ?? ?? 24 E7 ?? ?? 8E 62 00 04 0? ?? ?? ?? AC 62 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 03 1C 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_29_0_0 {
	meta:
		name = "fgetpwent"
		size = 624
		refs = "0004 __gnu_local_gp 003c _IO_new_fgetpos 0084 __libc_errno 00ac _IO_new_fsetpos 00d8 __fgetpwent_r 00f8 realloc 0114 free 0228 malloc 0260 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF A0 3C 1C ?? ?? 27 9C ?? ?? 27 A5 00 20 AF B2 00 40 AF BC 00 18 AF BF 00 5C AF BE 00 58 AF B7 00 54 AF B6 00 50 AF B5 00 4C AF B4 00 48 AF B3 00 44 AF B1 00 3C AF B0 00 38 0? ?? ?? ?? 00 80 90 21 14 40 00 69 8F BC 00 18 3C 03 ?? ?? 24 64 ?? ?? C0 82 00 00 24 41 00 01 E0 81 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 7C 00 00 00 00 3C 11 ?? ?? 8E 22 ?? ?? 10 40 00 68 24 03 04 00 8F 97 ?? ?? 7C 03 E8 3B 3C 13 ?? ?? 3C 10 ?? ?? 26 73 ?? ?? 24 14 00 22 02 E3 F0 21 0? ?? ?? ?? 3C 15 ?? ?? 27 A5 00 20 0? ?? ?? ?? AE 22 ?? ?? 14 40 00 23 3C 02 ?? ?? 8E A2 ?? ?? 00 40 30 21 02 40 20 21 10 40 00 24 02 60 28 21 8E 07 ?? ?? 27 A2 00 2C 0? ?? ?? ?? AF A2 00 10 14 54 00 3D 8E 02 ?? ?? 8E 36 ?? ?? 24 42 04 00 02 C0 20 21 00 40 28 21 0? ?? ?? ?? AE 02 ?? ?? 14 40 FF E9 02 40 20 21 8F C5 00 00 02 C0 20 21 AF A2 00 30 0? ?? ?? ?? AF A5 00 34 8F A5 00 34 8F A2 00 30 02 40 20 21 AF C5 00 00 27 A5 00 20 0? ?? ?? ?? AE 22 ?? ?? 10 40 FF E1 8E A2 ?? ?? 3C 02 ?? ?? AC 40 ?? ?? 00 00 10 21 00 40 30 21 02 40 20 21 14 40 FF DE 02 60 28 21 AF A0 00 2C 7C 03 E8 3B 02 E3 10 21 8C 50 00 00 3C 03 ?? ?? 24 64 ?? ?? 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 2A 24 64 ?? ?? 8F BF 00 5C 7C 03 E8 3B 02 E3 10 21 AC 50 00 00 8F BE 00 58 8F A2 00 2C 8F B7 00 54 8F B6 00 50 8F B5 00 4C 8F B4 00 48 8F B3 00 44 8F B2 00 40 8F B1 00 3C 8F B0 00 38 03 E0 00 08 27 BD 00 60 8E 22 ?? ?? 14 40 FF E0 00 00 00 00 0? ?? ?? ?? AF A0 00 2C 8F BF 00 5C 8F BE 00 58 8F B7 00 54 8F B6 00 50 8F B5 00 4C 8F B4 00 48 8F B3 00 44 8F B2 00 40 8F B1 00 3C 8F B0 00 38 00 00 10 21 03 E0 00 08 27 BD 00 60 3C 02 ?? ?? 24 04 04 00 0? ?? ?? ?? AC 43 ?? ?? AE 22 ?? ?? 0? ?? ?? ?? 8F BC 00 18 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 5C 0? ?? ?? ?? 24 64 ?? ?? 0? ?? ?? ?? 8F BC 00 18 }
	condition:
		$1
}

rule file_442_0_0 {
	meta:
		name = "fgetsgent"
		size = 624
		refs = "0004 __gnu_local_gp 003c _IO_new_fgetpos 0084 __libc_errno 00ac _IO_new_fsetpos 00d8 __fgetsgent_r 00f8 realloc 0114 free 0228 malloc 0260 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF A0 3C 1C ?? ?? 27 9C ?? ?? 27 A5 00 20 AF B2 00 40 AF BC 00 18 AF BF 00 5C AF BE 00 58 AF B7 00 54 AF B6 00 50 AF B5 00 4C AF B4 00 48 AF B3 00 44 AF B1 00 3C AF B0 00 38 0? ?? ?? ?? 00 80 90 21 14 40 00 69 8F BC 00 18 3C 03 ?? ?? 24 64 ?? ?? C0 82 00 00 24 41 00 01 E0 81 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 7C 00 00 00 00 3C 11 ?? ?? 8E 22 ?? ?? 10 40 00 68 24 03 04 00 8F 97 ?? ?? 7C 03 E8 3B 3C 13 ?? ?? 3C 10 ?? ?? 26 73 ?? ?? 24 14 00 22 02 E3 F0 21 0? ?? ?? ?? 3C 15 ?? ?? 27 A5 00 20 0? ?? ?? ?? AE 22 ?? ?? 14 40 00 23 3C 02 ?? ?? 8E A2 ?? ?? 00 40 30 21 02 40 20 21 10 40 00 24 02 60 28 21 8E 07 ?? ?? 27 A2 00 2C 0? ?? ?? ?? AF A2 00 10 14 54 00 3D 8E 02 ?? ?? 8E 36 ?? ?? 24 42 04 00 02 C0 20 21 00 40 28 21 0? ?? ?? ?? AE 02 ?? ?? 14 40 FF E9 02 40 20 21 8F C5 00 00 02 C0 20 21 AF A2 00 30 0? ?? ?? ?? AF A5 00 34 8F A5 00 34 8F A2 00 30 02 40 20 21 AF C5 00 00 27 A5 00 20 0? ?? ?? ?? AE 22 ?? ?? 10 40 FF E1 8E A2 ?? ?? 3C 02 ?? ?? AC 40 ?? ?? 00 00 10 21 00 40 30 21 02 40 20 21 14 40 FF DE 02 60 28 21 AF A0 00 2C 7C 03 E8 3B 02 E3 10 21 8C 50 00 00 3C 03 ?? ?? 24 64 ?? ?? 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 2A 24 64 ?? ?? 8F BF 00 5C 7C 03 E8 3B 02 E3 10 21 AC 50 00 00 8F BE 00 58 8F A2 00 2C 8F B7 00 54 8F B6 00 50 8F B5 00 4C 8F B4 00 48 8F B3 00 44 8F B2 00 40 8F B1 00 3C 8F B0 00 38 03 E0 00 08 27 BD 00 60 8E 22 ?? ?? 14 40 FF E0 00 00 00 00 0? ?? ?? ?? AF A0 00 2C 8F BF 00 5C 8F BE 00 58 8F B7 00 54 8F B6 00 50 8F B5 00 4C 8F B4 00 48 8F B3 00 44 8F B2 00 40 8F B1 00 3C 8F B0 00 38 00 00 10 21 03 E0 00 08 27 BD 00 60 3C 02 ?? ?? 24 04 04 00 0? ?? ?? ?? AC 43 ?? ?? AE 22 ?? ?? 0? ?? ?? ?? 8F BC 00 18 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 5C 0? ?? ?? ?? 24 64 ?? ?? 0? ?? ?? ?? 8F BC 00 18 }
	condition:
		$1
}

rule file_852_0_0 {
	meta:
		name = "fgetspent"
		size = 624
		refs = "0004 __gnu_local_gp 003c _IO_new_fgetpos 0084 __libc_errno 00ac _IO_new_fsetpos 00d8 __fgetspent_r 00f8 realloc 0114 free 0228 malloc 0260 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF A0 3C 1C ?? ?? 27 9C ?? ?? 27 A5 00 20 AF B2 00 40 AF BC 00 18 AF BF 00 5C AF BE 00 58 AF B7 00 54 AF B6 00 50 AF B5 00 4C AF B4 00 48 AF B3 00 44 AF B1 00 3C AF B0 00 38 0? ?? ?? ?? 00 80 90 21 14 40 00 69 8F BC 00 18 3C 03 ?? ?? 24 64 ?? ?? C0 82 00 00 24 41 00 01 E0 81 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 7C 00 00 00 00 3C 11 ?? ?? 8E 22 ?? ?? 10 40 00 68 24 03 04 00 8F 97 ?? ?? 7C 03 E8 3B 3C 13 ?? ?? 3C 10 ?? ?? 26 73 ?? ?? 24 14 00 22 02 E3 F0 21 0? ?? ?? ?? 3C 15 ?? ?? 27 A5 00 20 0? ?? ?? ?? AE 22 ?? ?? 14 40 00 23 3C 02 ?? ?? 8E A2 ?? ?? 00 40 30 21 02 40 20 21 10 40 00 24 02 60 28 21 8E 07 ?? ?? 27 A2 00 2C 0? ?? ?? ?? AF A2 00 10 14 54 00 3D 8E 02 ?? ?? 8E 36 ?? ?? 24 42 04 00 02 C0 20 21 00 40 28 21 0? ?? ?? ?? AE 02 ?? ?? 14 40 FF E9 02 40 20 21 8F C5 00 00 02 C0 20 21 AF A2 00 30 0? ?? ?? ?? AF A5 00 34 8F A5 00 34 8F A2 00 30 02 40 20 21 AF C5 00 00 27 A5 00 20 0? ?? ?? ?? AE 22 ?? ?? 10 40 FF E1 8E A2 ?? ?? 3C 02 ?? ?? AC 40 ?? ?? 00 00 10 21 00 40 30 21 02 40 20 21 14 40 FF DE 02 60 28 21 AF A0 00 2C 7C 03 E8 3B 02 E3 10 21 8C 50 00 00 3C 03 ?? ?? 24 64 ?? ?? 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 2A 24 64 ?? ?? 8F BF 00 5C 7C 03 E8 3B 02 E3 10 21 AC 50 00 00 8F BE 00 58 8F A2 00 2C 8F B7 00 54 8F B6 00 50 8F B5 00 4C 8F B4 00 48 8F B3 00 44 8F B2 00 40 8F B1 00 3C 8F B0 00 38 03 E0 00 08 27 BD 00 60 8E 22 ?? ?? 14 40 FF E0 00 00 00 00 0? ?? ?? ?? AF A0 00 2C 8F BF 00 5C 8F BE 00 58 8F B7 00 54 8F B6 00 50 8F B5 00 4C 8F B4 00 48 8F B3 00 44 8F B2 00 40 8F B1 00 3C 8F B0 00 38 00 00 10 21 03 E0 00 08 27 BD 00 60 3C 02 ?? ?? 24 04 04 00 0? ?? ?? ?? AC 43 ?? ?? AE 22 ?? ?? 0? ?? ?? ?? 8F BC 00 18 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 5C 0? ?? ?? ?? 24 64 ?? ?? 0? ?? ?? ?? 8F BC 00 18 }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "__getclktck"
		size = 20
		refs = "0000 _dl_clktck"
	strings:
		$1 = { 3C 02 ?? ?? 8C 42 ?? ?? 24 03 00 64 03 E0 00 08 00 62 10 0A }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "__pause_nocancel"
		size = 28
	strings:
		$1 = { 24 02 0F BD 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_31_1_0 {
	meta:
		name = "__libc_pause"
		size = 124
		refs = "0034 __libc_enable_asynccancel 0054 __libc_disable_asynccancel"
	strings:
		$1 = { 7C 03 E8 3B 8C 63 8B 70 14 03 00 08 00 00 00 00 24 02 0F BD 00 00 00 0C 14 E0 FF F0 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 27 BD FF D0 AF BF 00 1C 0? ?? ?? ?? 00 00 00 00 AF A2 00 2C 24 02 0F BD 00 00 00 0C AF A2 00 24 AF A7 00 28 8F A4 00 2C 0? ?? ?? ?? 00 00 00 00 8F A2 00 24 8F A7 00 28 8F BF 00 1C 14 E0 FF DC 27 BD 00 30 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_4_1_2 {
	meta:
		name = "__libc_pause"
		size = 124
		refs = "0034 __pthread_enable_asynccancel 0054 __pthread_disable_asynccancel"
	strings:
		$1 = { 7C 03 E8 3B 8C 63 8B 70 14 03 00 08 00 00 00 00 24 02 0F BD 00 00 00 0C 14 E0 FF F0 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 27 BD FF D0 AF BF 00 1C 0? ?? ?? ?? 00 00 00 00 AF A2 00 2C 24 02 0F BD 00 00 00 0C AF A2 00 24 AF A7 00 28 8F A4 00 2C 0? ?? ?? ?? 00 00 00 00 8F A2 00 24 8F A7 00 28 8F BF 00 1C 14 E0 FF DC 27 BD 00 30 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "getsubopt"
		size = 360
		refs = "0048 __strchrnul 005c memchr 0088 strncmp"
	strings:
		$1 = { 27 BD FF C0 AF B4 00 28 8C 94 00 00 AF B6 00 30 AF BF 00 3C AF BE 00 38 AF B7 00 34 AF B5 00 2C AF B3 00 24 AF B2 00 20 AF B1 00 1C AF B0 00 18 82 82 00 00 10 40 00 4A 00 80 B0 21 00 A0 88 21 02 80 20 21 24 05 00 2C 0? ?? ?? ?? 00 C0 F0 21 00 54 30 23 02 80 20 21 24 05 00 3D 0? ?? ?? ?? 00 40 A8 21 8E 30 00 00 02 A0 B8 21 12 00 00 11 00 42 B8 0B 02 F4 90 23 26 31 00 04 00 00 98 21 02 00 28 21 02 80 20 21 0? ?? ?? ?? 02 40 30 21 26 31 00 04 14 40 00 04 02 12 80 21 82 02 00 00 10 40 00 19 26 E2 00 01 8E 30 FF FC 16 00 FF F4 26 73 00 01 AF D4 00 00 82 A2 00 00 14 40 00 0F 00 00 00 00 AE D5 00 00 24 02 FF FF 8F BF 00 3C 8F BE 00 38 8F B7 00 34 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 40 A2 A0 00 00 0? ?? ?? ?? 26 B5 00 01 02 F5 B8 26 00 17 10 0A AF C2 00 00 82 A2 00 00 10 40 00 04 8F BF 00 3C A2 A0 00 00 26 B5 00 01 8F BF 00 3C AE D5 00 00 02 60 10 21 8F BE 00 38 8F B7 00 34 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 40 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "day_of_the_week"
		size = 296
		refs = "0044 __mon_yday"
	strings:
		$1 = { 8C 83 00 14 8C 89 00 10 3C 07 51 EB 24 65 07 6C 29 22 00 02 00 A2 10 23 28 46 00 00 24 45 00 03 00 46 28 0A 34 E7 85 1F 00 A0 30 21 00 05 28 83 00 A7 00 18 24 63 FF BA 00 03 50 C0 00 03 41 80 01 48 40 21 3C 0A ?? ?? 25 4A ?? ?? 00 06 37 C3 00 09 48 40 01 03 18 21 01 2A 48 21 95 2A 00 00 00 03 40 80 00 68 18 21 24 63 FE 27 00 02 47 C3 00 65 18 21 00 00 58 10 00 47 00 18 00 0B 38 C3 00 E6 30 23 00 06 49 40 00 06 38 C0 01 27 38 23 00 E6 30 21 00 A6 28 23 00 05 2F C2 8C 89 00 0C 3C 07 92 49 24 E7 24 93 00 00 10 10 00 02 31 43 01 06 30 23 00 66 18 21 00 02 11 C3 00 48 40 23 00 65 18 21 00 68 18 21 00 6A 18 21 00 69 18 21 24 63 FF FF 00 67 00 18 00 03 2F C3 00 00 10 10 00 43 10 21 00 02 10 83 00 45 10 23 00 02 28 C0 00 A2 10 23 00 62 10 23 24 42 00 07 00 47 00 18 00 02 2F C3 00 00 18 10 00 62 18 21 00 03 18 83 00 65 18 23 00 03 28 C0 00 A3 18 23 00 43 10 23 03 E0 00 08 AC 82 00 18 }
	condition:
		$1
}

rule file_33_1_0 {
	meta:
		name = "__strptime_internal"
		size = 14028
		refs = "035c _nl_C_LC_TIME 03a8 __strptime_internal 09f4 $LC1 0b28 strlen 0b44 __strncasecmp_l 0b8c strcmp 1018 __localtime_r 1168 _nl_select_era_entry 1924 $LC0 195c _nl_parse_alt_digit 287c __mon_yday 3124 $LC2 1d54 $LC3 3138 __assert_fail 3128 __PRETTY_FUNCTION__.7624"
	strings:
		$1 = { 27 BD FF 60 AF B3 00 84 8F B3 00 B0 AF B5 00 8C AF B2 00 80 AF B0 00 78 AF BF 00 9C AF BE 00 98 AF B7 00 94 AF B6 00 90 AF B4 00 88 AF B1 00 7C 00 E0 80 21 AF A4 00 A0 00 A0 A8 21 AF A6 00 A8 10 E0 01 03 8E 72 00 08 8C E2 00 04 8C E3 00 00 AF A2 00 50 8F A2 00 A8 AF A3 00 4C 27 A3 00 20 24 44 00 20 8C 4A 00 00 8C 47 00 04 8C 46 00 08 8C 45 00 0C 24 42 00 10 AC 6A 00 00 AC 67 00 04 AC 66 00 08 AC 65 00 0C 14 44 FF F6 24 63 00 10 8C 45 00 00 8C 44 00 04 8C 42 00 08 27 B1 00 20 AC 65 00 00 AC 64 00 04 AC 62 00 08 3C 14 ?? ?? 26 94 ?? ?? 3C 1E ?? ?? 82 A2 00 00 10 40 00 17 00 00 00 00 8E 66 00 34 00 02 18 40 00 C3 18 21 94 63 00 00 30 63 00 20 10 60 00 2B 00 00 00 00 8F A2 00 A0 0? ?? ?? ?? 80 43 00 00 AF A2 00 A0 80 43 00 00 00 03 18 40 00 C3 18 21 94 63 00 00 30 63 00 20 14 60 FF F9 24 42 00 01 26 B5 00 01 82 A2 00 00 14 40 FF EB 00 00 00 00 12 00 09 54 8F A3 00 4C 8F B3 00 A8 27 A2 00 20 AE 03 00 00 8F A3 00 50 AE 03 00 04 27 A3 00 40 8C 47 00 00 8C 46 00 04 8C 45 00 08 8C 44 00 0C 24 42 00 10 AE 67 00 00 AE 66 00 04 AE 65 00 08 AE 64 00 0C 14 43 FF F6 26 73 00 10 8C 44 00 00 8C 43 00 04 8C 42 00 08 AE 64 00 00 AE 63 00 04 AE 62 00 08 0? ?? ?? ?? 8F A2 00 A0 24 03 00 25 10 43 00 13 8F A3 00 A0 24 64 00 01 AF A4 00 A0 80 63 00 00 10 62 FF C5 26 B5 00 01 00 00 10 21 8F BF 00 9C 8F BE 00 98 8F B7 00 94 8F B6 00 90 8F B5 00 8C 8F B4 00 88 8F B3 00 84 8F B2 00 80 8F B1 00 7C 8F B0 00 78 03 E0 00 08 27 BD 00 A0 12 00 00 9A 26 A2 00 01 24 04 00 2D 24 09 00 30 24 0A 00 23 80 43 00 00 10 64 00 0A 00 00 00 00 10 69 00 08 00 00 00 00 30 65 00 FF 24 A7 FF A2 2C E7 00 02 14 E0 00 03 00 00 00 00 14 6A 00 03 00 00 00 00 0? ?? ?? ?? 24 42 00 01 24 A5 FF D0 2C A5 00 0A 10 A0 00 0A 24 63 FF DB 24 42 00 01 80 43 00 00 24 64 FF D0 30 84 00 FF 2C 84 00 0A 14 80 FF FB 24 42 00 01 24 42 FF FF 24 63 FF DB 30 63 00 FF 2C 64 00 56 8F B7 00 A0 10 80 FF CF 24 55 00 01 00 03 18 80 02 83 18 21 8C 63 00 00 00 60 00 08 00 00 00 00 AF B7 00 A0 82 E2 00 00 00 02 18 40 00 C3 18 21 94 63 00 00 30 63 00 20 14 60 FF F9 26 F7 00 01 24 42 FF D0 30 42 00 FF 2C 42 00 0A 10 40 FF BD 8F A2 00 A0 24 06 00 02 00 40 20 21 24 42 00 01 AF A2 00 A0 80 83 00 00 24 65 FF D0 00 05 38 40 00 05 28 C0 00 E5 28 21 2C A7 01 6F 10 E0 00 0F 00 00 00 00 90 84 00 01 24 84 FF D0 30 84 00 FF 2C 84 00 0A 10 80 00 0A 24 63 FF CF 00 40 20 21 24 42 00 01 AF A2 00 A0 80 83 00 00 24 C6 FF FF 00 65 18 21 14 C0 FF ED 24 65 FF D0 24 63 FF CF 2C 62 01 6E 10 40 FF A0 00 00 10 21 AE 23 00 1C 97 A2 00 4C 24 03 00 01 7C 62 6B 44 0? ?? ?? ?? A7 A2 00 4C 8F A2 00 4C 3C 16 00 18 3C 03 00 10 00 56 10 24 10 43 00 0D 27 C3 ?? ?? 8E 45 00 CC 80 A3 00 00 14 60 0B 0A 02 E0 20 21 3C 03 00 08 10 43 FF 8C 97 A2 00 4C 24 03 00 02 AF B7 00 A0 7C 62 20 C4 A7 A2 00 4C 27 C3 ?? ?? 8C 65 00 CC 80 A2 00 00 10 40 FF 83 8F A4 00 A0 AF B3 00 10 02 20 30 21 0? ?? ?? ?? 27 A7 00 4C 14 40 FF 41 AF A2 00 A0 0? ?? ?? ?? 00 00 10 21 8F A2 00 4C 3C 16 00 18 3C 03 00 10 00 56 10 24 10 43 00 0D 27 C3 ?? ?? 8E 45 00 C8 80 A3 00 00 14 60 0A FA 02 E0 20 21 3C 03 00 08 10 43 FF 6E 97 A2 00 4C 24 03 00 02 AF B7 00 A0 7C 62 20 C4 A7 A2 00 4C 27 C3 ?? ?? 8C 65 00 C8 80 A2 00 00 10 40 FF 66 00 00 10 21 8F A4 00 A0 AF B3 00 10 02 20 30 21 0? ?? ?? ?? 27 A7 00 4C 10 40 FF 5E AF A2 00 A0 97 A2 00 4C 24 03 00 01 7C 62 29 44 0? ?? ?? ?? A7 A2 00 4C 0? ?? ?? ?? 82 A3 00 01 24 02 FF FF AF A0 00 4C AF A2 00 50 A3 A2 00 4F 0? ?? ?? ?? 00 C0 88 21 82 E3 00 00 26 E2 00 01 00 03 20 40 00 C4 20 21 94 84 00 00 30 84 00 20 10 80 00 0A 02 E0 28 21 AF A2 00 A0 80 43 00 00 00 40 28 21 00 03 20 40 00 C4 20 21 94 84 00 00 30 84 00 20 14 80 FF F8 24 42 00 01 24 62 FF D0 30 42 00 FF 2C 42 00 0A 10 40 FF 3B 24 A2 00 01 AF A2 00 A0 80 A2 00 00 24 42 FF D0 00 02 20 40 00 02 18 C0 00 83 18 21 2C 64 00 36 10 80 00 0C 00 00 00 00 90 A4 00 01 24 84 FF D0 30 84 00 FF 2C 84 00 0A 10 80 00 06 00 00 00 00 24 A2 00 02 AF A2 00 A0 80 A2 00 01 24 42 FF D0 00 43 10 21 2C 43 00 36 10 60 FF 24 97 A3 00 4C A3 A2 00 4E 24 02 00 01 7C 43 52 84 0? ?? ?? ?? A7 A3 00 4C 82 E3 00 00 26 E2 00 01 00 03 20 40 00 C4 20 21 94 84 00 00 30 84 00 20 10 80 00 0A 02 E0 28 21 AF A2 00 A0 80 43 00 00 00 40 28 21 00 03 20 40 00 C4 20 21 94 84 00 00 30 84 00 20 14 80 FF F8 24 42 00 01 24 62 FF D0 30 42 00 FF 2C 42 00 0A 10 40 FF 09 24 A2 00 01 AF A2 00 A0 80 A2 00 00 24 42 FF D0 00 02 20 40 00 02 18 C0 00 83 18 21 2C 64 00 36 10 80 00 0C 00 00 00 00 90 A4 00 01 24 84 FF D0 30 84 00 FF 2C 84 00 0A 10 80 00 07 2C 42 00 36 24 A2 00 02 AF A2 00 A0 80 A2 00 01 24 42 FF D0 00 43 10 21 2C 42 00 36 14 40 FE B6 00 00 10 21 0? ?? ?? ?? 8F BF 00 9C 10 80 0A DD 8F A4 00 50 97 A2 00 4C 24 03 00 01 8F A4 00 50 7C 62 20 C4 A7 A2 00 4C 16 C4 FE AB 8F A3 00 4C 3C 02 00 18 00 62 18 24 24 02 FF FF AF A2 00 50 3C 02 00 08 10 62 FE E0 97 A2 00 4C 24 03 00 02 8F B7 00 A0 7C 62 20 C4 A7 A2 00 4C 8E 66 00 34 82 E3 00 00 00 03 10 40 00 C2 10 21 94 42 00 00 30 42 00 20 10 40 0A 4D 26 E2 00 01 AF A2 00 A0 80 43 00 00 00 40 28 21 00 03 20 40 00 C4 20 21 94 84 00 00 30 84 00 20 14 80 FF F8 24 42 00 01 24 62 FF D0 30 42 00 FF 2C 42 00 0A 10 40 FE C6 24 A2 00 01 AF A2 00 A0 80 A3 00 00 24 62 FF D0 00 02 30 40 00 02 20 C0 00 C4 20 21 2C 86 00 64 10 C0 00 0C 00 00 00 00 90 A6 00 01 24 C6 FF D0 30 C6 00 FF 2C C6 00 0A 10 C0 00 06 00 00 00 00 24 A2 00 02 AF A2 00 A0 80 A3 00 01 00 83 18 21 24 62 FF D0 2C 44 00 64 10 80 FE AF 24 63 00 34 2C 44 00 45 00 64 10 0B AE 22 00 14 97 A2 00 4C 24 03 00 01 7C 62 39 C4 7C 62 29 44 0? ?? ?? ?? A7 A2 00 4C 82 E3 00 00 26 E2 00 01 00 03 20 40 00 C4 20 21 94 84 00 00 30 84 00 20 10 80 00 0A 02 E0 28 21 AF A2 00 A0 80 43 00 00 00 40 28 21 00 03 20 40 00 C4 20 21 94 84 00 00 30 84 00 20 14 80 FF F8 24 42 00 01 24 62 FF D0 30 42 00 FF 2C 42 00 0A 10 40 FE 90 24 A2 00 01 AF A2 00 A0 80 A2 00 00 24 44 FF D0 00 04 18 40 00 04 20 C0 00 64 18 21 2C 64 00 0D 10 80 00 0B 00 00 00 00 90 A4 00 01 24 84 FF D0 30 84 00 FF 2C 84 00 0A 10 80 00 06 24 42 FF CF 24 A2 00 02 AF A2 00 A0 80 A2 00 01 00 62 10 21 24 42 FF CF 2C 43 00 0C 10 60 FE 79 00 00 00 00 AE 22 00 10 97 A2 00 4C 24 03 00 01 7C 62 63 04 7C 62 29 44 0? ?? ?? ?? A7 A2 00 4C 0? ?? ?? ?? 82 E2 00 00 AF B7 00 A0 82 E2 00 00 00 02 10 40 00 C2 10 21 94 42 00 00 30 42 00 20 14 40 FF F9 26 F7 00 01 0? ?? ?? ?? 82 A2 00 00 82 E3 00 00 26 E2 00 01 00 03 20 40 00 C4 20 21 94 84 00 00 30 84 00 20 10 80 00 0A 02 E0 28 21 AF A2 00 A0 80 43 00 00 00 40 28 21 00 03 20 40 00 C4 20 21 94 84 00 00 30 84 00 20 14 80 FF F8 24 42 00 01 24 62 FF D0 30 42 00 FF 2C 42 00 0A 10 40 FE 50 24 A2 00 01 AF A2 00 A0 80 A3 00 00 24 62 FF D0 00 02 30 40 00 02 20 C0 00 C4 20 21 2C 86 00 0D 10 C0 00 0C 00 00 00 00 90 A6 00 01 24 C6 FF D0 30 C6 00 FF 2C C6 00 0A 10 C0 00 07 24 63 FF CF 24 A2 00 02 AF A2 00 A0 80 A3 00 01 00 83 18 21 24 62 FF D0 24 63 FF CF 2C 63 00 0C 10 60 FE 38 3C 03 AA AA 34 63 AA AB 00 43 00 19 00 00 18 10 00 03 18 C2 00 03 20 80 00 03 19 00 00 64 18 23 00 43 10 23 AE 22 00 08 97 A2 00 4C 24 03 00 01 7C 62 7B C4 0? ?? ?? ?? A7 A2 00 4C 82 E3 00 00 26 E2 00 01 00 03 20 40 00 C4 20 21 94 84 00 00 30 84 00 20 10 80 00 0A 02 E0 28 21 AF A2 00 A0 80 43 00 00 00 40 28 21 00 03 20 40 00 C4 20 21 94 84 00 00 30 84 00 20 14 80 FF F8 24 42 00 01 24 62 FF D0 30 42 00 FF 2C 42 00 0A 10 40 FE 14 24 A2 00 01 AF A2 00 A0 80 A2 00 00 24 42 FF D0 00 02 20 40 00 02 18 C0 00 83 18 21 2C 64 00 3C 10 80 00 0C 00 00 00 00 90 A4 00 01 24 84 FF D0 30 84 00 FF 2C 84 00 0A 10 80 00 06 00 00 00 00 24 A2 00 02 AF A2 00 A0 80 A2 00 01 24 42 FF D0 00 43 10 21 2C 43 00 3C 10 60 FD FD 00 00 00 00 0? ?? ?? ?? AE 22 00 04 90 43 00 01 24 55 00 02 24 62 FF B8 30 42 00 FF 2C 43 00 32 10 60 FD F4 3C 03 ?? ?? 00 02 10 80 24 63 ?? ?? 00 62 10 21 8C 42 00 00 00 40 00 08 00 00 00 00 3C 05 ?? ?? AF B3 00 10 02 E0 20 21 24 A5 ?? ?? 02 20 30 21 0? ?? ?? ?? 27 A7 00 4C 14 40 FD A9 AF A2 00 A0 0? ?? ?? ?? 00 00 10 21 82 E3 00 00 26 E2 00 01 00 03 20 40 00 C4 20 21 94 84 00 00 30 84 00 20 10 80 00 0A 02 E0 28 21 AF A2 00 A0 80 43 00 00 00 40 28 21 00 03 20 40 00 C4 20 21 94 84 00 00 30 84 00 20 14 80 FF F8 24 42 00 01 24 62 FF D0 30 42 00 FF 2C 42 00 0A 10 40 FD CD 24 A2 00 01 AF A2 00 A0 80 A2 00 00 24 42 FF D0 00 02 20 40 00 02 18 C0 00 83 18 21 2C 64 00 3E 10 80 00 0C 00 00 00 00 90 A4 00 01 24 84 FF D0 30 84 00 FF 2C 84 00 0A 10 80 00 06 00 00 00 00 24 A2 00 02 AF A2 00 A0 80 A2 00 01 24 42 FF D0 00 43 10 21 2C 43 00 3E 10 60 FD B6 00 00 00 00 0? ?? ?? ?? AE 22 00 00 8F A2 00 4C 3C 16 ?? ?? 26 D6 ?? ?? 7C 48 0C C0 24 03 FF FF AF B6 00 58 AF A8 00 64 AF A3 00 60 00 00 B0 21 0? ?? ?? ?? AF A0 00 5C 34 C6 00 1A 02 C6 58 21 31 6B FF FF 00 0B 58 80 02 4B 58 21 8D 65 00 24 AF AB 00 70 00 A0 20 21 0? ?? ?? ?? AF A5 00 68 8F A5 00 68 00 40 30 21 02 60 38 21 00 A0 20 21 02 E0 28 21 0? ?? ?? ?? AF A2 00 68 8F AA 00 68 14 40 00 14 8F AB 00 70 8F A8 00 5C 02 EA 50 21 01 0A 10 2B 10 40 00 10 3C 04 00 02 8F A2 00 4C 3C 03 00 18 00 43 10 24 14 40 07 B8 8F A8 00 58 8D 64 00 24 AF B6 00 60 8D 05 00 30 0? ?? ?? ?? AF AA 00 5C 8F A3 00 64 24 04 00 01 00 82 18 0B AF A3 00 64 3C 04 00 02 34 84 00 0E 02 C4 58 21 31 6B FF FF 00 0B 58 80 02 4B 58 21 8D 65 00 24 8F B7 00 A0 AF AB 00 70 00 A0 20 21 0? ?? ?? ?? AF A5 00 68 8F A5 00 68 00 40 30 21 02 60 38 21 00 A0 20 21 02 E0 28 21 0? ?? ?? ?? AF A2 00 68 8F AA 00 68 14 40 06 5F 8F AB 00 70 8F A8 00 5C 02 EA 50 21 01 0A 10 2B 14 40 06 89 8F A2 00 4C 3C 03 00 18 00 43 10 24 3C 04 00 08 14 44 00 0E 8F B7 00 A0 8F A3 00 58 26 D6 00 01 24 02 00 0C 24 63 00 04 12 C2 07 77 AF A3 00 58 8F B7 00 A0 8F A2 00 4C 3C 04 00 18 00 44 10 24 3C 05 00 10 14 45 FF AD 3C 06 00 02 8F A8 00 58 8D 05 00 30 00 A0 20 21 0? ?? ?? ?? AF A5 00 68 8F A5 00 68 00 40 30 21 02 60 38 21 00 A0 20 21 02 E0 28 21 0? ?? ?? ?? AF A2 00 68 14 40 06 1E 8F AA 00 68 8F A3 00 5C 02 EA 50 21 00 6A 10 2B 10 40 06 1A 8F A8 00 58 24 08 00 02 AF B6 00 60 AF AA 00 5C 0? ?? ?? ?? AF A8 00 64 82 E3 00 00 00 03 10 40 00 C2 10 21 94 42 00 00 30 42 00 20 10 40 00 0B 24 62 FF D0 26 E2 00 01 AF A2 00 A0 82 E3 00 01 00 03 20 40 00 C4 20 21 94 84 00 00 30 84 00 20 14 80 FF F8 00 40 B8 21 24 62 FF D0 30 42 00 FF 2C 42 00 0A 10 40 FD 28 8F A2 00 A0 24 06 00 03 00 40 28 21 24 42 00 01 AF A2 00 A0 80 A4 00 00 24 83 FF D0 00 03 50 40 00 03 38 C0 01 47 38 21 2C EA 27 10 11 40 00 0F 00 00 00 00 90 A5 00 01 24 A5 FF D0 30 A5 00 FF 2C A5 00 0A 10 A0 00 09 00 00 00 00 00 40 28 21 24 42 00 01 AF A2 00 A0 80 A4 00 00 24 C6 FF FF 00 E4 20 21 14 C0 FF ED 24 83 FF D0 2C 63 27 10 10 60 FD 0B 24 84 F8 64 AE 24 00 14 97 A2 00 4C 24 03 00 01 7C 02 39 C4 7C 62 29 44 0? ?? ?? ?? A7 A2 00 4C 8F A2 00 4C 24 08 FF FF 02 E0 B0 21 7C 43 0C C0 AF B2 00 5C AF A3 00 64 AF A8 00 60 00 00 B8 21 0? ?? ?? ?? AF A0 00 58 34 A5 00 07 02 E5 58 21 31 6B FF FF 00 0B 58 80 02 4B 58 21 8D 63 00 24 AF AB 00 70 00 60 20 21 0? ?? ?? ?? AF A3 00 6C 8F A3 00 6C 02 C0 28 21 00 40 30 21 00 60 20 21 02 60 38 21 0? ?? ?? ?? AF A2 00 68 8F AB 00 70 14 40 00 16 8F AC 00 68 8F A8 00 58 02 CC 60 21 01 0C 10 2B 10 40 00 12 8F A8 00 5C 8F A2 00 4C 3C 03 00 18 00 43 10 24 14 40 07 1D 00 17 30 80 27 C3 ?? ?? 00 66 18 21 8C 65 00 40 8D 64 00 24 AF B7 00 60 0? ?? ?? ?? AF AC 00 58 8F A8 00 64 24 03 00 01 00 62 40 0B AF A8 00 64 8F A8 00 5C 8F B6 00 A0 8D 03 00 24 00 60 20 21 0? ?? ?? ?? AF A3 00 6C 8F A3 00 6C 02 C0 28 21 00 40 30 21 00 60 20 21 02 60 38 21 0? ?? ?? ?? AF A2 00 70 14 40 05 DA 8F AB 00 70 8F A3 00 58 02 CB 58 21 00 6B 10 2B 10 40 06 C7 8F A2 00 4C 3C 05 00 18 00 45 10 24 14 40 06 F7 8F A8 00 5C 00 17 30 80 27 C3 ?? ?? 00 66 10 21 8D 04 00 24 8C 45 00 24 AF A3 00 6C AF A6 00 68 0? ?? ?? ?? AF AB 00 70 8F AB 00 70 8F A3 00 6C 8F A6 00 68 8F B6 00 A0 AF B7 00 60 10 40 00 03 AF AB 00 58 24 08 00 01 AF A8 00 64 00 66 30 21 8C C5 00 40 AF A3 00 6C 00 A0 20 21 0? ?? ?? ?? AF A5 00 68 8F A5 00 68 00 40 30 21 02 60 38 21 00 A0 20 21 02 C0 28 21 0? ?? ?? ?? AF A2 00 70 8F A3 00 6C 14 40 05 8E 8F AB 00 70 8F A8 00 58 02 CB 58 21 01 0B 10 2B 10 40 05 8A 26 E2 00 08 24 03 00 02 AF B7 00 60 AF AB 00 58 AF A3 00 64 8F A8 00 5C 26 F7 00 01 24 02 00 07 25 08 00 04 12 E2 06 95 AF A8 00 5C 8F B6 00 A0 8F A2 00 4C 3C 03 00 18 00 43 10 24 3C 04 00 10 14 44 FF 88 3C 05 00 02 00 17 30 80 0? ?? ?? ?? 27 C3 ?? ?? AF A0 00 54 92 E2 00 00 24 42 FF D0 30 42 00 FF 2C 42 00 0A 10 40 FC 77 26 F7 00 01 00 00 10 21 00 02 18 40 00 02 10 C0 00 62 10 21 AF A2 00 54 AF B7 00 A0 82 E4 FF FF 26 F7 00 01 24 84 FF D0 00 44 10 21 AF A2 00 54 92 E3 FF FF }
	condition:
		$1
}

rule file_33_2_0 {
	meta:
		name = "__strptime_l"
		size = 32
		refs = "000c __strptime_internal"
	strings:
		$1 = { 27 BD FF D8 AF A7 00 10 AF BF 00 24 0? ?? ?? ?? 00 00 38 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_1491_1_0 {
	meta:
		name = "__strtol_l"
		size = 32
		refs = "000c ____strtol_l_internal"
	strings:
		$1 = { 27 BD FF D8 AF A7 00 10 AF BF 00 24 0? ?? ?? ?? 00 00 38 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_1389_1_0 {
	meta:
		name = "__strtoll_l"
		size = 32
		refs = "000c ____strtoll_l_internal"
	strings:
		$1 = { 27 BD FF D8 AF A7 00 10 AF BF 00 24 0? ?? ?? ?? 00 00 38 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_825_1_0 {
	meta:
		name = "__strtoul_l"
		size = 32
		refs = "000c ____strtoul_l_internal"
	strings:
		$1 = { 27 BD FF D8 AF A7 00 10 AF BF 00 24 0? ?? ?? ?? 00 00 38 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_1298_1_0 {
	meta:
		name = "__strtoull_l"
		size = 32
		refs = "000c ____strtoull_l_internal"
	strings:
		$1 = { 27 BD FF D8 AF A7 00 10 AF BF 00 24 0? ?? ?? ?? 00 00 38 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_1408_1_0 {
	meta:
		name = "__wcstol_l"
		size = 32
		refs = "000c ____wcstol_l_internal"
	strings:
		$1 = { 27 BD FF D8 AF A7 00 10 AF BF 00 24 0? ?? ?? ?? 00 00 38 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_391_1_0 {
	meta:
		name = "__wcstoll_l"
		size = 32
		refs = "000c ____wcstoll_l_internal"
	strings:
		$1 = { 27 BD FF D8 AF A7 00 10 AF BF 00 24 0? ?? ?? ?? 00 00 38 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_1238_1_0 {
	meta:
		name = "__wcstoul_l"
		size = 32
		refs = "000c ____wcstoul_l_internal"
	strings:
		$1 = { 27 BD FF D8 AF A7 00 10 AF BF 00 24 0? ?? ?? ?? 00 00 38 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_543_1_0 {
	meta:
		name = "__wcstoull_l"
		size = 32
		refs = "000c ____wcstoull_l_internal"
	strings:
		$1 = { 27 BD FF D8 AF A7 00 10 AF BF 00 24 0? ?? ?? ?? 00 00 38 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_34_0_0 {
	meta:
		name = "jrand48"
		size = 40
		refs = "0010 __jrand48_r 0004 __libc_drand48_data"
	strings:
		$1 = { 27 BD FF D8 3C 05 ?? ?? 27 A6 00 18 AF BF 00 24 0? ?? ?? ?? 24 A5 ?? ?? 8F BF 00 24 8F A2 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_443_0_0 {
	meta:
		name = "nrand48"
		size = 40
		refs = "0010 __nrand48_r 0004 __libc_drand48_data"
	strings:
		$1 = { 27 BD FF D8 3C 05 ?? ?? 27 A6 00 18 AF BF 00 24 0? ?? ?? ?? 24 A5 ?? ?? 8F BF 00 24 8F A2 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "_longjmp_unwind"
		size = 56
		refs = "0000 __pthread_cleanup_upto"
	strings:
		$1 = { 3C 02 ?? ?? 24 42 ?? ?? 10 40 00 09 00 00 00 00 27 BD FF F8 AF BE 00 04 03 A0 F0 21 03 C0 E8 21 03 C0 28 21 8F BE 00 04 0? ?? ?? ?? 27 BD 00 08 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_36_0_0 {
	meta:
		name = "mabort"
		size = 204
		refs = "002c _libc_intl_domainname 0028 $LC2 0038 __dcgettext 0040 __libc_fatal 004c $LC1 006c $LC0 0090 $LC4 00b0 $LC3"
	strings:
		$1 = { 27 BD FF E0 24 02 00 01 10 82 00 28 AF BF 00 1C 28 82 00 02 14 40 00 14 24 02 00 02 10 82 00 0A 24 02 00 03 14 82 00 19 3C 05 ?? ?? 3C 04 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 0? ?? ?? ?? 00 40 20 21 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 0? ?? ?? ?? 00 00 00 00 14 80 00 08 3C 05 ?? ?? 3C 04 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 0? ?? ?? ?? 00 00 00 00 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 0? ?? ?? ?? 00 00 00 00 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_36_1_0 {
	meta:
		name = "checkhdr.part.0"
		size = 180
	strings:
		$1 = { 8C 85 00 0C 8C 83 00 08 8C 82 00 04 27 BD FF D8 00 A3 18 21 00 62 18 26 3C 02 D8 67 24 42 53 09 AF BF 00 24 10 62 00 21 AF B0 00 20 3C 02 FE DA 34 42 BE EB 10 62 00 10 00 00 00 00 24 02 00 02 3C 03 ?? ?? 8C 79 ?? ?? 3C 10 ?? ?? 00 40 20 21 AF A2 00 18 03 20 F8 09 AE 00 ?? ?? 8F A2 00 18 24 03 00 01 AE 03 ?? ?? 8F BF 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 28 8C 85 00 00 00 85 28 21 80 A6 00 18 24 05 FF D7 14 C5 FF ED 24 02 00 03 8C 85 00 10 8C 84 00 14 00 A4 20 26 14 83 FF E8 24 02 00 02 0? ?? ?? ?? 00 00 10 21 0? ?? ?? ?? 24 02 00 01 }
	condition:
		$1
}

rule file_36_2_0 {
	meta:
		name = "unlink_blk.isra.1"
		size = 88
	strings:
		$1 = { 10 A0 00 08 3C 03 FE DA 8C 82 00 00 8C A6 00 0C 34 63 BE EB 00 46 30 21 00 C3 18 26 AC A2 00 08 AC A3 00 04 8C 82 00 00 10 40 00 08 3C 03 FE DA 8C 44 00 08 34 63 BE EB 00 A4 20 21 00 83 18 26 AC 45 00 0C 03 E0 00 08 AC 43 00 04 3C 02 ?? ?? 03 E0 00 08 AC 45 ?? ?? }
	condition:
		$1
}

rule file_36_3_0 {
	meta:
		name = "memalignhook"
		size = 424
		refs = "0008 __gnu_local_gp 0058 __memalign_hook 00fc memset 0128 mcheck_check_all 0160 __libc_errno 0190 memalign"
	strings:
		$1 = { 3C 02 ?? ?? 8C 42 ?? ?? 3C 1C ?? ?? 27 BD FF D0 27 9C ?? ?? AF B0 00 20 AF BF 00 2C AF B2 00 28 AF B1 00 24 AF BC 00 10 14 40 00 3E 00 A0 80 21 24 82 00 17 00 04 88 23 02 22 88 24 26 22 00 01 00 02 10 27 00 50 10 2B 14 40 00 43 00 00 00 00 3C 02 ?? ?? 8C 59 ?? ?? 3C 12 ?? ?? 26 05 00 01 AE 59 ?? ?? 13 20 00 4A 00 B1 28 21 03 20 F8 09 00 00 00 00 00 40 28 21 3C 02 ?? ?? 24 42 ?? ?? 10 A0 00 47 AE 42 ?? ?? 3C 02 ?? ?? 8C 44 ?? ?? 3C 06 FE DA 26 23 FF E8 34 C6 BE EB 00 A3 18 21 00 86 38 26 AC 70 00 00 AC 60 00 08 AC 64 00 0C AC 43 ?? ?? 10 80 00 06 AC 67 00 04 8C 82 00 0C AC 83 00 08 00 62 10 21 00 46 30 26 AC 86 00 04 3C 04 FE DA 34 84 BE EB 00 A4 20 26 24 67 00 18 AC 65 00 10 AC 64 00 14 00 70 10 21 24 03 FF D7 00 E0 20 21 A0 43 00 18 24 05 FF 93 0? ?? ?? ?? 02 00 30 21 00 40 38 21 8F BF 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 00 E0 10 21 03 E0 00 08 27 BD 00 30 AF A4 00 18 0? ?? ?? ?? AF A6 00 1C 8F A4 00 18 8F BC 00 10 24 82 00 17 00 04 88 23 02 22 88 24 26 22 00 01 00 02 10 27 00 50 10 2B 10 40 FF BF 8F A6 00 1C 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 8F BF 00 2C 00 00 38 21 00 62 10 21 24 03 00 0C AC 43 00 00 8F B2 00 28 8F B1 00 24 8F B0 00 20 00 E0 10 21 03 E0 00 08 27 BD 00 30 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 00 40 28 21 0? ?? ?? ?? 00 00 38 21 }
	condition:
		$1
}

rule file_36_4_0 {
	meta:
		name = "mallochook"
		size = 352
		refs = "0008 __gnu_local_gp 004c __malloc_hook 00d8 memset 00fc mcheck_check_all 011c __libc_errno 0148 malloc"
	strings:
		$1 = { 3C 02 ?? ?? 8C 42 ?? ?? 3C 1C ?? ?? 27 BD FF D0 27 9C ?? ?? AF B0 00 24 AF BF 00 2C AF B1 00 28 AF BC 00 10 14 40 00 35 00 80 80 21 2E 02 FF E7 10 40 00 38 00 00 00 00 3C 02 ?? ?? 8C 59 ?? ?? 3C 11 ?? ?? 26 04 00 19 13 20 00 3F AE 39 ?? ?? 03 20 F8 09 00 00 00 00 00 40 18 21 3C 02 ?? ?? 24 42 ?? ?? 10 60 00 3C AE 22 ?? ?? 3C 04 ?? ?? 8C 82 ?? ?? 3C 05 FE DA 34 A5 BE EB 00 45 30 26 AC 70 00 00 AC 60 00 08 AC 62 00 0C AC 83 ?? ?? 10 40 00 06 AC 66 00 04 8C 44 00 0C AC 43 00 08 00 83 20 21 00 85 28 26 AC 45 00 04 3C 04 FE DA 34 84 BE EB 00 64 20 26 24 67 00 18 AC 64 00 14 00 70 10 21 AC 63 00 10 24 03 FF D7 00 E0 20 21 A0 43 00 18 24 05 FF 93 0? ?? ?? ?? 02 00 30 21 00 40 38 21 8F BF 00 2C 8F B1 00 28 8F B0 00 24 00 E0 10 21 03 E0 00 08 27 BD 00 30 0? ?? ?? ?? AF A5 00 18 2E 02 FF E7 8F BC 00 10 14 40 FF CA 8F A5 00 18 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 8F BF 00 2C 00 00 38 21 00 62 10 21 24 03 00 0C AC 43 00 00 8F B1 00 28 8F B0 00 24 00 E0 10 21 03 E0 00 08 27 BD 00 30 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 00 40 18 21 0? ?? ?? ?? 00 00 38 21 }
	condition:
		$1
}

rule file_36_5_0 {
	meta:
		name = "freehook"
		size = 260
		refs = "0068 memset 0088 __free_hook 00b8 mcheck_check_all 00d8 free"
	strings:
		$1 = { 3C 02 ?? ?? 8C 42 ?? ?? 27 BD FF D8 AF B2 00 20 AF B0 00 18 AF BF 00 24 AF B1 00 1C 00 80 80 21 14 40 00 25 00 A0 90 21 12 00 00 12 3C 02 ?? ?? 8C 42 ?? ?? 14 40 00 24 00 00 00 00 8E 05 FF F4 3C 02 D8 67 24 42 53 09 26 04 FF F0 AE 02 FF EC 0? ?? ?? ?? AE 02 FF FC 8E 06 FF E8 AE 00 FF F4 AE 00 FF F0 02 00 20 21 0? ?? ?? ?? 24 05 FF 95 8E 10 FF F8 3C 02 ?? ?? 8C 59 ?? ?? 3C 11 ?? ?? 02 00 20 21 13 20 00 14 AE 39 ?? ?? 03 20 F8 09 02 40 28 21 8F BF 00 24 3C 02 ?? ?? 24 42 ?? ?? 8F B2 00 20 8F B0 00 18 AE 22 ?? ?? 8F B1 00 1C 03 E0 00 08 27 BD 00 28 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 26 04 FF E8 0? ?? ?? ?? 8E 05 FF F4 0? ?? ?? ?? 00 00 00 00 8F BF 00 24 3C 02 ?? ?? 24 42 ?? ?? 8F B2 00 20 8F B0 00 18 AE 22 ?? ?? 8F B1 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_36_6_0 {
	meta:
		name = "reallochook"
		size = 604
		refs = "0000 __gnu_local_gp 00b0 __free_hook 00c4 __malloc_hook 00c8 __memalign_hook 00cc __realloc_hook 01c4 memset 01d4 mcheck_check_all 0214 realloc 022c __libc_errno"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF C0 27 9C ?? ?? AF B7 00 34 AF B1 00 1C AF BF 00 3C AF BE 00 38 AF B6 00 30 AF B5 00 2C AF B4 00 28 AF B3 00 24 AF B2 00 20 AF B0 00 18 AF BC 00 10 00 A0 88 21 10 A0 00 81 00 C0 B8 21 3C 02 ?? ?? 8C 42 ?? ?? 14 40 00 61 00 80 80 21 2E 22 FF E7 10 40 00 72 00 00 00 00 12 00 00 69 3C 02 ?? ?? 8C 42 ?? ?? 26 16 FF E8 14 40 00 61 8E 12 FF E8 8E 05 FF F4 0? ?? ?? ?? 26 04 FF F0 02 32 10 2B 14 40 00 56 02 11 20 21 3C 02 ?? ?? 8C 44 ?? ?? 3C 02 ?? ?? 8C 43 ?? ?? 3C 05 ?? ?? 3C 02 ?? ?? 8C B9 ?? ?? 8C 42 ?? ?? 3C 1E ?? ?? 3C 15 ?? ?? 3C 14 ?? ?? 3C 13 ?? ?? AF C4 ?? ?? AE A3 ?? ?? AE 82 ?? ?? AE 79 ?? ?? 02 C0 20 21 13 20 00 4F 26 25 00 19 03 20 F8 09 02 E0 30 21 00 40 80 21 3C 02 ?? ?? 24 42 ?? ?? AF C2 ?? ?? 3C 02 ?? ?? 24 42 ?? ?? AE A2 ?? ?? 3C 02 ?? ?? 24 42 ?? ?? AE 82 ?? ?? 3C 02 ?? ?? 24 42 ?? ?? 12 00 00 4F AE 62 ?? ?? 3C 03 ?? ?? 8C 62 ?? ?? 3C 04 FE DA 34 84 BE EB 00 44 28 26 AE 11 00 00 AE 00 00 08 AE 02 00 0C AC 70 ?? ?? 10 40 00 06 AE 05 00 04 8C 43 00 0C AC 50 00 08 00 70 18 21 00 64 20 26 AC 44 00 04 3C 04 FE DA 34 84 BE EB 02 04 20 26 AE 04 00 14 02 11 18 21 24 04 FF D7 02 51 10 2B AE 10 00 10 14 40 00 0E A0 64 00 18 26 02 00 18 8F BF 00 3C 8F BE 00 38 8F B7 00 34 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 40 26 44 00 18 02 04 20 21 24 05 FF 93 0? ?? ?? ?? 02 32 30 23 0? ?? ?? ?? 26 02 00 18 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 8F BC 00 10 24 05 FF 95 0? ?? ?? ?? 02 51 30 23 0? ?? ?? ?? 3C 02 ?? ?? 0? ?? ?? ?? 02 C0 20 21 0? ?? ?? ?? 8E 05 FF F4 00 00 90 21 0? ?? ?? ?? 00 00 B0 21 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 00 40 80 21 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 0C AC 43 00 00 0? ?? ?? ?? 00 00 10 21 0? ?? ?? ?? 00 C0 28 21 0? ?? ?? ?? 00 00 10 21 0? ?? ?? ?? 00 00 10 21 }
	condition:
		$1
}

rule file_36_7_0 {
	meta:
		name = "mcheck_check_all"
		size = 124
	strings:
		$1 = { 27 BD FF D8 3C 02 ?? ?? AF B0 00 18 8C 50 ?? ?? AF B2 00 20 3C 12 ?? ?? AF BF 00 24 AF B1 00 1C 12 00 00 0E AE 40 ?? ?? 0? ?? ?? ?? 3C 11 ?? ?? 8E 10 00 0C 12 00 00 0A 8F BF 00 24 8E 22 ?? ?? 10 40 FF FB 00 00 00 00 0? ?? ?? ?? 02 00 20 21 8E 10 00 0C 16 00 FF FA 8E 22 ?? ?? 8F BF 00 24 24 02 00 01 8F B1 00 1C 8F B0 00 18 AE 42 ?? ?? 8F B2 00 20 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_36_8_0 {
	meta:
		name = "mcheck"
		size = 252
		refs = "0014 __libc_malloc_initialized 0060 malloc 006c free 0074 __free_hook 007c __malloc_hook 00a0 __memalign_hook 00bc __realloc_hook"
	strings:
		$1 = { 27 BD FF D0 AF BF 00 2C AF B1 00 28 10 80 00 38 AF B0 00 24 3C 02 ?? ?? 8C 42 ?? ?? 3C 03 ?? ?? 18 40 00 0B AC 64 ?? ?? 3C 02 ?? ?? 8C 50 ?? ?? 2E 10 00 01 00 10 80 23 8F BF 00 2C 02 00 10 21 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 30 3C 11 ?? ?? 8E 22 ?? ?? 14 40 FF F7 00 00 80 21 0? ?? ?? ?? 00 00 20 21 AF A2 00 18 0? ?? ?? ?? 8F A4 00 18 3C 05 ?? ?? 8C AA ?? ?? 3C 04 ?? ?? 3C 09 ?? ?? 8C 88 ?? ?? AD 2A ?? ?? 3C 09 ?? ?? 25 29 ?? ?? 3C 03 ?? ?? AC A9 ?? ?? 3C 05 ?? ?? 8C 67 ?? ?? AC A8 ?? ?? 3C 05 ?? ?? 24 A5 ?? ?? 3C 02 ?? ?? AC 85 ?? ?? 3C 04 ?? ?? 8C 46 ?? ?? AC 87 ?? ?? 3C 04 ?? ?? 24 84 ?? ?? AC 64 ?? ?? 3C 03 ?? ?? AC 66 ?? ?? 3C 03 ?? ?? 24 63 ?? ?? AC 43 ?? ?? 24 02 00 01 0? ?? ?? ?? AE 22 ?? ?? 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? }
	condition:
		$1
}

rule file_36_9_0 {
	meta:
		name = "mcheck_pedantic"
		size = 44
		refs = "0008 mcheck"
	strings:
		$1 = { 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? 00 00 00 00 14 40 00 03 24 04 00 01 3C 03 ?? ?? AC 64 ?? ?? 8F BF 00 1C 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_1383_0_0 {
	meta:
		name = "_IO_str_chk_overflow"
		size = 16
		refs = "0008 __chk_fail"
	strings:
		$1 = { 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_510_0_0 {
	meta:
		name = "__stack_chk_fail_local"
		size = 16
		refs = "0008 __stack_chk_fail"
	strings:
		$1 = { 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_257_1_0 {
	meta:
		name = "_dl_start"
		size = 16
		refs = "0008 abort"
	strings:
		$1 = { 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_66_0_2 {
	meta:
		name = "longjmp"
		size = 16
		refs = "0008 __libc_longjmp"
	strings:
		$1 = { 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_828_4_0 {
	meta:
		name = "svctcp_rendezvous_abort"
		size = 16
		refs = "0008 abort"
	strings:
		$1 = { 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_167_4_0 {
	meta:
		name = "svcunix_rendezvous_abort"
		size = 16
		refs = "0008 abort"
	strings:
		$1 = { 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_36_10_0 {
	meta:
		name = "mprobe"
		size = 32
	strings:
		$1 = { 3C 02 ?? ?? 8C 42 ?? ?? 10 40 00 03 00 00 00 00 0? ?? ?? ?? 24 84 FF E8 03 E0 00 08 24 02 FF FF }
	condition:
		$1
}

rule file_39_0_0 {
	meta:
		name = "_create_xid"
		size = 284
		refs = "0044 getpid 0060 __gettimeofday 007c __srand48_r 008c lrand48_r 00e8 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF C8 AF B0 00 20 3C 10 ?? ?? 26 03 ?? ?? AF BF 00 34 AF B4 00 30 AF B3 00 2C AF B2 00 28 AF B1 00 24 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 2A 00 00 00 00 0? ?? ?? ?? 3C 12 ?? ?? 8E 43 ?? ?? 00 40 88 21 10 62 00 22 27 B3 00 18 02 60 20 21 0? ?? ?? ?? 00 00 28 21 8F A2 00 18 8F A4 00 1C 3C 14 ?? ?? 26 85 ?? ?? 00 82 20 26 0? ?? ?? ?? 00 91 20 26 AE 51 ?? ?? 26 84 ?? ?? 0? ?? ?? ?? 02 60 28 21 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 10 26 04 ?? ?? 8F BF 00 34 8F A2 00 18 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 38 0? ?? ?? ?? 3C 14 ?? ?? 0? ?? ?? ?? 26 04 ?? ?? 0? ?? ?? ?? 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 34 }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "alphasort64"
		size = 20
		refs = "000c strcoll"
	strings:
		$1 = { 8C 84 00 00 8C A5 00 00 24 84 00 13 0? ?? ?? ?? 24 A5 00 13 }
	condition:
		$1
}

rule file_65_0_0 {
	meta:
		name = "versionsort64"
		size = 20
		refs = "000c __strverscmp"
	strings:
		$1 = { 8C 84 00 00 8C A5 00 00 24 84 00 13 0? ?? ?? ?? 24 A5 00 13 }
	condition:
		$1
}

rule file_41_0_0 {
	meta:
		name = "lrand48"
		size = 44
		refs = "0000 __libc_drand48_data 0014 __nrand48_r"
	strings:
		$1 = { 3C 04 ?? ?? 27 BD FF D8 24 84 ?? ?? 27 A6 00 18 AF BF 00 24 0? ?? ?? ?? 00 80 28 21 8F BF 00 24 8F A2 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_1306_0_0 {
	meta:
		name = "mrand48"
		size = 44
		refs = "0000 __libc_drand48_data 0014 __jrand48_r"
	strings:
		$1 = { 3C 04 ?? ?? 27 BD FF D8 24 84 ?? ?? 27 A6 00 18 AF BF 00 24 0? ?? ?? ?? 00 80 28 21 8F BF 00 24 8F A2 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "__realpath_chk"
		size = 36
		refs = "000c __realpath 001c __chk_fail"
	strings:
		$1 = { 2C C6 10 00 14 C0 00 03 00 00 00 00 0? ?? ?? ?? 00 00 00 00 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_43_0_0 {
	meta:
		name = "psignal"
		size = 296
		refs = "0030 $LC0 0044 _sys_siglist 005c _libc_intl_domainname 0064 __dcgettext 0080 __fxprintf 006c $LC2 00a8 $LC3 00cc __asprintf 00dc $LC5 00ec free 002c $LC1 0118 $LC4"
	strings:
		$1 = { 27 BD FF C0 AF B1 00 30 AF B0 00 2C AF BF 00 3C AF B3 00 38 AF B2 00 34 00 A0 80 21 10 A0 00 04 00 80 88 21 80 A2 00 00 14 40 00 39 3C 12 ?? ?? 3C 12 ?? ?? 26 52 ?? ?? 02 40 80 21 2E 22 00 80 10 40 00 18 3C 02 ?? ?? 00 11 18 80 24 42 ?? ?? 00 62 10 21 8C 45 00 00 10 A0 00 12 3C 04 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 24 06 00 05 3C 05 ?? ?? 02 00 30 21 02 40 38 21 AF A2 00 10 00 00 20 21 0? ?? ?? ?? 24 A5 ?? ?? 8F BF 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 40 3C 13 ?? ?? 3C 05 ?? ?? 26 64 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 00 40 28 21 AF B1 00 10 27 A4 00 20 02 00 30 21 0? ?? ?? ?? 02 40 38 21 04 40 00 10 8F A6 00 20 3C 05 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 00 00 20 21 0? ?? ?? ?? 8F A4 00 20 8F BF 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 40 0? ?? ?? ?? 26 52 ?? ?? 3C 05 ?? ?? 26 64 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "__lcong48_r"
		size = 84
	strings:
		$1 = { 88 83 00 00 00 00 10 21 98 83 00 03 A8 A3 00 00 B8 A3 00 03 90 83 00 04 A0 A3 00 04 90 83 00 05 A0 A3 00 05 94 88 00 08 94 87 00 06 94 83 00 0C 94 86 00 0A 00 08 24 00 00 E4 20 25 A4 A3 00 0C 24 03 00 01 AC A6 00 10 AC A4 00 14 03 E0 00 08 A4 A3 00 0E }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "grantpt"
		size = 720
		refs = "0004 __gnu_local_gp 0050 realloc 0074 __ptsname_internal 0090 memchr 00ac malloc 00bc __libc_errno 00d4 free 00ec __libc_fcntl 014c __getuid 0184 __chown 01ac __chmod 0248 __sysconf 026c $LC0 0284 __getgrnam_r 02ac __getgid"
	strings:
		$1 = { 27 BD EF 10 3C 1C ?? ?? AF BE 10 E8 03 A0 F0 21 AF B2 10 E0 AF B0 10 D8 27 9C ?? ?? 27 D2 00 20 24 10 10 00 AF B3 10 E4 AF B1 10 DC AF BF 10 EC AF DC 00 18 00 80 98 21 16 00 00 0B 02 40 88 21 24 10 00 80 02 20 20 21 12 51 00 18 02 00 28 21 0? ?? ?? ?? 00 00 00 00 10 40 00 18 8F DC 00 18 12 00 FF F7 00 40 88 21 02 60 20 21 02 20 28 21 02 00 30 21 0? ?? ?? ?? 27 C7 10 20 8F DC 00 18 02 00 30 21 02 20 20 21 14 40 00 25 00 00 28 21 0? ?? ?? ?? 00 00 00 00 14 40 00 2C 00 10 80 40 02 20 20 21 16 51 FF EA 02 00 28 21 0? ?? ?? ?? 02 00 20 21 14 40 FF EA 8F DC 00 18 8F 90 ?? ?? 7C 03 E8 3B 02 03 10 21 24 03 00 0C 12 51 00 03 AC 43 00 00 0? ?? ?? ?? 02 20 20 21 7C 03 E8 3B 02 03 88 21 02 60 20 21 24 05 00 01 0? ?? ?? ?? 8E 32 00 00 24 03 FF FF 10 43 00 4E 24 03 00 09 24 02 00 19 7C 03 E8 3B 12 42 00 6C 00 00 00 00 02 03 10 21 AC 52 00 00 0? ?? ?? ?? 24 02 FF FF 8F 90 ?? ?? 7C 03 E8 3B 00 60 20 21 38 45 00 19 24 03 00 16 00 65 10 0A 02 04 20 21 16 51 FF E5 AC 82 00 00 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 00 00 00 00 00 40 80 21 8F C2 10 40 14 50 00 24 8F C6 10 44 3C 13 ?? ?? 8E 66 ?? ?? 24 02 FF FF 10 C2 00 35 00 00 00 00 8F C3 10 44 10 C3 00 05 02 20 20 21 0? ?? ?? ?? 02 00 28 21 04 40 00 1D 00 00 00 00 8F C3 10 38 24 02 01 90 30 63 01 FF 10 62 00 05 00 00 80 21 02 20 20 21 0? ?? ?? ?? 24 05 01 90 00 02 87 C3 12 51 00 14 00 00 00 00 0? ?? ?? ?? 02 20 20 21 02 00 10 21 03 C0 E8 21 8F BF 10 EC 8F BE 10 E8 8F B3 10 E4 8F B2 10 E0 8F B1 10 DC 8F B0 10 D8 03 E0 00 08 27 BD 10 F0 02 20 20 21 0? ?? ?? ?? 02 00 28 21 04 41 FF DA 3C 13 ?? ?? 16 51 FF EE 24 10 FF FF 03 C0 E8 21 8F DF 10 EC 02 00 10 21 8F BE 10 E8 8F B3 10 E4 8F B2 10 E0 8F B1 10 DC 8F B0 10 D8 03 E0 00 08 27 BD 10 F0 8E 24 00 00 14 83 FF B1 00 00 00 00 0? ?? ?? ?? 03 C0 E8 21 0? ?? ?? ?? 24 04 00 45 00 02 20 27 24 03 04 00 00 64 10 0A 24 43 00 0E 00 03 18 C2 00 03 18 C0 03 A3 E8 23 3C 04 ?? ?? 27 C3 10 D0 AF A3 00 10 24 84 ?? ?? 27 C5 10 C0 27 A6 00 18 0? ?? ?? ?? 00 40 38 21 8F C2 10 D0 10 40 00 03 8E 66 ?? ?? 8C 46 00 08 AE 66 ?? ?? 24 02 FF FF 14 C2 FF B5 8F C3 10 44 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 00 40 30 21 02 03 10 21 24 03 00 16 AC 43 00 00 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "__getpwuid_r"
		size = 660
		refs = "0000 __nss_not_use_nscd_passwd 0008 __gnu_local_gp 009c __libc_errno 00a4 $LC0 00b0 _dl_mcount_wrapper_check 0104 __nss_next2 0170 __nss_database_custom 0190 __nscd_getpwuid_r 0200 __nss_passwd_lookup2"
	strings:
		$1 = { 3C 03 ?? ?? 8C 62 ?? ?? 3C 1C ?? ?? 27 BD FF B0 27 9C ?? ?? AF BE 00 48 AF B5 00 3C AF B4 00 38 AF B3 00 34 AF B2 00 30 AF BF 00 4C AF B7 00 44 AF B6 00 40 AF B1 00 2C AF B0 00 28 AF BC 00 18 00 80 98 21 00 A0 90 21 00 C0 A0 21 00 E0 A8 21 18 40 00 61 8F BE 00 60 24 42 00 01 28 44 00 65 10 80 00 42 3C 10 ?? ?? AC 62 ?? ?? 92 02 ?? ?? 10 40 00 60 3C 05 ?? ?? 3C 02 ?? ?? 8C 43 ?? ?? 3C 02 ?? ?? 8C 44 ?? ?? 24 62 00 01 AF A3 00 24 AF A4 00 20 2C 42 00 01 14 40 00 43 8F 97 ?? ?? 7C 03 E8 3B 3C 16 ?? ?? 02 E3 88 21 26 D6 ?? ?? 0? ?? ?? ?? 8F A4 00 20 8F B9 00 20 02 60 20 21 02 40 28 21 02 80 30 21 02 A0 38 21 03 20 F8 09 AF B1 00 10 00 40 80 21 24 02 FF FE 27 A4 00 24 02 C0 28 21 00 00 30 21 16 02 00 05 27 A7 00 20 8E 23 00 00 24 02 00 22 10 62 00 2C 00 00 00 00 AF B0 00 10 0? ?? ?? ?? AF A0 00 14 10 40 FF E8 24 02 00 01 12 02 00 48 2E 02 00 02 14 40 00 5B AF C0 00 00 7C 03 E8 3B 02 E3 10 21 8C 42 00 00 24 03 00 22 10 43 00 24 24 03 FF FE 8F BF 00 4C 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 AC 60 ?? ?? 3C 02 ?? ?? 90 42 ?? ?? 14 40 FF BC 3C 10 ?? ?? AF BE 00 10 02 60 20 21 02 40 28 21 02 80 30 21 0? ?? ?? ?? 02 A0 38 21 04 41 FF E8 8F BC 00 18 0? ?? ?? ?? 3C 10 ?? ?? 24 10 FF FF 7C 03 E8 3B 02 E3 10 21 8C 42 00 00 24 03 00 22 14 43 FF DF AF C0 00 00 24 03 FF FE 12 03 FF DD 8F BF 00 4C 0? ?? ?? ?? 24 02 00 16 10 40 FF E6 3C 02 ?? ?? 3C 10 ?? ?? 92 02 ?? ?? 14 40 FF A4 3C 02 ?? ?? 3C 05 ?? ?? 27 A4 00 24 24 A5 ?? ?? 00 00 30 21 0? ?? ?? ?? 27 A7 00 20 14 40 00 1C 8F BC 00 18 8F A4 00 20 3C 03 ?? ?? AC 64 ?? ?? 8F A4 00 24 3C 03 ?? ?? AC 64 ?? ?? 00 00 00 0F 24 03 00 01 0? ?? ?? ?? A2 03 ?? ?? AF D2 00 00 00 00 10 21 8F BF 00 4C 7C 03 E8 3B 02 E3 20 21 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 AC 82 00 00 03 E0 00 08 27 BD 00 50 24 04 FF FF 3C 03 ?? ?? 0? ?? ?? ?? AC 64 ?? ?? 0? ?? ?? ?? 00 00 10 21 }
	condition:
		$1
}

rule file_216_0_0 {
	meta:
		name = "__getgrgid_r"
		size = 660
		refs = "0000 __nss_not_use_nscd_group 0008 __gnu_local_gp 009c __libc_errno 00a4 $LC0 00b0 _dl_mcount_wrapper_check 0104 __nss_next2 0170 __nss_database_custom 0190 __nscd_getgrgid_r 0200 __nss_group_lookup2"
	strings:
		$1 = { 3C 03 ?? ?? 8C 62 ?? ?? 3C 1C ?? ?? 27 BD FF B0 27 9C ?? ?? AF BE 00 48 AF B5 00 3C AF B4 00 38 AF B3 00 34 AF B2 00 30 AF BF 00 4C AF B7 00 44 AF B6 00 40 AF B1 00 2C AF B0 00 28 AF BC 00 18 00 80 98 21 00 A0 90 21 00 C0 A0 21 00 E0 A8 21 18 40 00 61 8F BE 00 60 24 42 00 01 28 44 00 65 10 80 00 42 3C 10 ?? ?? AC 62 ?? ?? 92 02 ?? ?? 10 40 00 60 3C 05 ?? ?? 3C 02 ?? ?? 8C 43 ?? ?? 3C 02 ?? ?? 8C 44 ?? ?? 24 62 00 01 AF A3 00 24 AF A4 00 20 2C 42 00 01 14 40 00 43 8F 97 ?? ?? 7C 03 E8 3B 3C 16 ?? ?? 02 E3 88 21 26 D6 ?? ?? 0? ?? ?? ?? 8F A4 00 20 8F B9 00 20 02 60 20 21 02 40 28 21 02 80 30 21 02 A0 38 21 03 20 F8 09 AF B1 00 10 00 40 80 21 24 02 FF FE 27 A4 00 24 02 C0 28 21 00 00 30 21 16 02 00 05 27 A7 00 20 8E 23 00 00 24 02 00 22 10 62 00 2C 00 00 00 00 AF B0 00 10 0? ?? ?? ?? AF A0 00 14 10 40 FF E8 24 02 00 01 12 02 00 48 2E 02 00 02 14 40 00 5B AF C0 00 00 7C 03 E8 3B 02 E3 10 21 8C 42 00 00 24 03 00 22 10 43 00 24 24 03 FF FE 8F BF 00 4C 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 AC 60 ?? ?? 3C 02 ?? ?? 90 42 ?? ?? 14 40 FF BC 3C 10 ?? ?? AF BE 00 10 02 60 20 21 02 40 28 21 02 80 30 21 0? ?? ?? ?? 02 A0 38 21 04 41 FF E8 8F BC 00 18 0? ?? ?? ?? 3C 10 ?? ?? 24 10 FF FF 7C 03 E8 3B 02 E3 10 21 8C 42 00 00 24 03 00 22 14 43 FF DF AF C0 00 00 24 03 FF FE 12 03 FF DD 8F BF 00 4C 0? ?? ?? ?? 24 02 00 16 10 40 FF E6 3C 02 ?? ?? 3C 10 ?? ?? 92 02 ?? ?? 14 40 FF A4 3C 02 ?? ?? 3C 05 ?? ?? 27 A4 00 24 24 A5 ?? ?? 00 00 30 21 0? ?? ?? ?? 27 A7 00 20 14 40 00 1C 8F BC 00 18 8F A4 00 20 3C 03 ?? ?? AC 64 ?? ?? 8F A4 00 24 3C 03 ?? ?? AC 64 ?? ?? 00 00 00 0F 24 03 00 01 0? ?? ?? ?? A2 03 ?? ?? AF D2 00 00 00 00 10 21 8F BF 00 4C 7C 03 E8 3B 02 E3 20 21 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 AC 82 00 00 03 E0 00 08 27 BD 00 50 24 04 FF FF 3C 03 ?? ?? 0? ?? ?? ?? AC 64 ?? ?? 0? ?? ?? ?? 00 00 10 21 }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "__getgrnam_r"
		size = 660
		refs = "0000 __nss_not_use_nscd_group 0008 __gnu_local_gp 009c __libc_errno 00a4 $LC0 00b0 _dl_mcount_wrapper_check 0104 __nss_next2 0170 __nss_database_custom 0190 __nscd_getgrnam_r 0200 __nss_group_lookup2"
	strings:
		$1 = { 3C 03 ?? ?? 8C 62 ?? ?? 3C 1C ?? ?? 27 BD FF B0 27 9C ?? ?? AF BE 00 48 AF B5 00 3C AF B4 00 38 AF B3 00 34 AF B2 00 30 AF BF 00 4C AF B7 00 44 AF B6 00 40 AF B1 00 2C AF B0 00 28 AF BC 00 18 00 80 98 21 00 A0 90 21 00 C0 A0 21 00 E0 A8 21 18 40 00 61 8F BE 00 60 24 42 00 01 28 44 00 65 10 80 00 42 3C 10 ?? ?? AC 62 ?? ?? 92 02 ?? ?? 10 40 00 60 3C 05 ?? ?? 3C 02 ?? ?? 8C 43 ?? ?? 3C 02 ?? ?? 8C 44 ?? ?? 24 62 00 01 AF A3 00 24 AF A4 00 20 2C 42 00 01 14 40 00 43 8F 97 ?? ?? 7C 03 E8 3B 3C 16 ?? ?? 02 E3 88 21 26 D6 ?? ?? 0? ?? ?? ?? 8F A4 00 20 8F B9 00 20 02 60 20 21 02 40 28 21 02 80 30 21 02 A0 38 21 03 20 F8 09 AF B1 00 10 00 40 80 21 24 02 FF FE 27 A4 00 24 02 C0 28 21 00 00 30 21 16 02 00 05 27 A7 00 20 8E 23 00 00 24 02 00 22 10 62 00 2C 00 00 00 00 AF B0 00 10 0? ?? ?? ?? AF A0 00 14 10 40 FF E8 24 02 00 01 12 02 00 48 2E 02 00 02 14 40 00 5B AF C0 00 00 7C 03 E8 3B 02 E3 10 21 8C 42 00 00 24 03 00 22 10 43 00 24 24 03 FF FE 8F BF 00 4C 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 AC 60 ?? ?? 3C 02 ?? ?? 90 42 ?? ?? 14 40 FF BC 3C 10 ?? ?? AF BE 00 10 02 60 20 21 02 40 28 21 02 80 30 21 0? ?? ?? ?? 02 A0 38 21 04 41 FF E8 8F BC 00 18 0? ?? ?? ?? 3C 10 ?? ?? 24 10 FF FF 7C 03 E8 3B 02 E3 10 21 8C 42 00 00 24 03 00 22 14 43 FF DF AF C0 00 00 24 03 FF FE 12 03 FF DD 8F BF 00 4C 0? ?? ?? ?? 24 02 00 16 10 40 FF E6 3C 02 ?? ?? 3C 10 ?? ?? 92 02 ?? ?? 14 40 FF A4 3C 02 ?? ?? 3C 05 ?? ?? 27 A4 00 24 24 A5 ?? ?? 00 00 30 21 0? ?? ?? ?? 27 A7 00 20 14 40 00 1C 8F BC 00 18 8F A4 00 20 3C 03 ?? ?? AC 64 ?? ?? 8F A4 00 24 3C 03 ?? ?? AC 64 ?? ?? 00 00 00 0F 24 03 00 01 0? ?? ?? ?? A2 03 ?? ?? AF D2 00 00 00 00 10 21 8F BF 00 4C 7C 03 E8 3B 02 E3 20 21 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 AC 82 00 00 03 E0 00 08 27 BD 00 50 24 04 FF FF 3C 03 ?? ?? 0? ?? ?? ?? AC 64 ?? ?? 0? ?? ?? ?? 00 00 10 21 }
	condition:
		$1
}

rule file_326_0_0 {
	meta:
		name = "__getpwnam_r"
		size = 660
		refs = "0000 __nss_not_use_nscd_passwd 0008 __gnu_local_gp 009c __libc_errno 00a4 $LC0 00b0 _dl_mcount_wrapper_check 0104 __nss_next2 0170 __nss_database_custom 0190 __nscd_getpwnam_r 0200 __nss_passwd_lookup2"
	strings:
		$1 = { 3C 03 ?? ?? 8C 62 ?? ?? 3C 1C ?? ?? 27 BD FF B0 27 9C ?? ?? AF BE 00 48 AF B5 00 3C AF B4 00 38 AF B3 00 34 AF B2 00 30 AF BF 00 4C AF B7 00 44 AF B6 00 40 AF B1 00 2C AF B0 00 28 AF BC 00 18 00 80 98 21 00 A0 90 21 00 C0 A0 21 00 E0 A8 21 18 40 00 61 8F BE 00 60 24 42 00 01 28 44 00 65 10 80 00 42 3C 10 ?? ?? AC 62 ?? ?? 92 02 ?? ?? 10 40 00 60 3C 05 ?? ?? 3C 02 ?? ?? 8C 43 ?? ?? 3C 02 ?? ?? 8C 44 ?? ?? 24 62 00 01 AF A3 00 24 AF A4 00 20 2C 42 00 01 14 40 00 43 8F 97 ?? ?? 7C 03 E8 3B 3C 16 ?? ?? 02 E3 88 21 26 D6 ?? ?? 0? ?? ?? ?? 8F A4 00 20 8F B9 00 20 02 60 20 21 02 40 28 21 02 80 30 21 02 A0 38 21 03 20 F8 09 AF B1 00 10 00 40 80 21 24 02 FF FE 27 A4 00 24 02 C0 28 21 00 00 30 21 16 02 00 05 27 A7 00 20 8E 23 00 00 24 02 00 22 10 62 00 2C 00 00 00 00 AF B0 00 10 0? ?? ?? ?? AF A0 00 14 10 40 FF E8 24 02 00 01 12 02 00 48 2E 02 00 02 14 40 00 5B AF C0 00 00 7C 03 E8 3B 02 E3 10 21 8C 42 00 00 24 03 00 22 10 43 00 24 24 03 FF FE 8F BF 00 4C 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 AC 60 ?? ?? 3C 02 ?? ?? 90 42 ?? ?? 14 40 FF BC 3C 10 ?? ?? AF BE 00 10 02 60 20 21 02 40 28 21 02 80 30 21 0? ?? ?? ?? 02 A0 38 21 04 41 FF E8 8F BC 00 18 0? ?? ?? ?? 3C 10 ?? ?? 24 10 FF FF 7C 03 E8 3B 02 E3 10 21 8C 42 00 00 24 03 00 22 14 43 FF DF AF C0 00 00 24 03 FF FE 12 03 FF DD 8F BF 00 4C 0? ?? ?? ?? 24 02 00 16 10 40 FF E6 3C 02 ?? ?? 3C 10 ?? ?? 92 02 ?? ?? 14 40 FF A4 3C 02 ?? ?? 3C 05 ?? ?? 27 A4 00 24 24 A5 ?? ?? 00 00 30 21 0? ?? ?? ?? 27 A7 00 20 14 40 00 1C 8F BC 00 18 8F A4 00 20 3C 03 ?? ?? AC 64 ?? ?? 8F A4 00 24 3C 03 ?? ?? AC 64 ?? ?? 00 00 00 0F 24 03 00 01 0? ?? ?? ?? A2 03 ?? ?? AF D2 00 00 00 00 10 21 8F BF 00 4C 7C 03 E8 3B 02 E3 20 21 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 AC 82 00 00 03 E0 00 08 27 BD 00 50 24 04 FF FF 3C 03 ?? ?? 0? ?? ?? ?? AC 64 ?? ?? 0? ?? ?? ?? 00 00 10 21 }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "__futimes"
		size = 648
		refs = "0000 __gnu_local_gp 00c4 __libc_errno 014c _itoa_word 0154 selffd.6734"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF A0 27 9C ?? ?? AF B1 00 50 AF B0 00 4C AF BF 00 5C AF B3 00 58 AF B2 00 54 AF BC 00 10 00 A0 80 21 10 A0 00 1A 00 80 88 21 8C A2 00 04 3C 05 00 0F 24 A5 42 40 00 45 18 2B 10 60 00 34 00 00 00 00 8E 03 00 0C 00 65 28 2B 10 A0 00 30 00 02 20 80 00 02 39 C0 00 03 30 80 00 03 41 C0 00 E4 38 23 8E 05 00 00 8E 04 00 08 01 06 30 23 00 E2 10 21 00 C3 18 21 00 02 10 C0 00 03 18 C0 AF A5 00 34 AF A2 00 38 AF A4 00 3C AF A3 00 40 3C 12 ?? ?? 8E 42 ?? ?? 14 40 00 27 27 A6 00 34 02 20 20 21 00 00 28 21 00 10 30 0A 00 00 38 21 24 02 10 DC 00 00 00 0C 10 E0 00 0C 24 03 FF FF 8F 93 ?? ?? 7C 03 E8 3B 00 60 20 21 02 64 98 21 00 40 18 21 AE 62 00 00 24 02 00 59 10 62 00 14 00 00 00 00 0? ?? ?? ?? 24 02 FF FF 10 43 00 4A 8F 93 ?? ?? 8F BF 00 5C 8F B3 00 58 8F B2 00 54 8F B1 00 50 8F B0 00 4C 03 E0 00 08 27 BD 00 60 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 16 AC 43 00 00 0? ?? ?? ?? 24 02 FF FF 24 02 00 01 AE 42 ?? ?? 02 20 20 21 27 A5 00 32 24 06 00 0A 00 00 38 21 0? ?? ?? ?? A3 A0 00 32 3C 03 ?? ?? 8C 66 ?? ?? 24 63 ?? ?? 8C 65 00 04 8F BC 00 10 24 44 FF F2 A8 46 FF F2 B8 86 00 03 8C 62 00 08 A8 85 00 04 90 66 00 0C 90 63 00 0D B8 85 00 07 A8 82 00 08 B8 82 00 0B A0 86 00 0C A0 83 00 0D 02 00 28 21 24 02 10 AB 00 00 00 0C 14 E0 00 19 8F 93 ?? ?? 24 03 FF FF 14 43 FF D2 8F BF 00 5C 8F 93 ?? ?? 7C 03 E8 3B 02 63 10 21 8C 42 00 00 24 03 00 14 10 43 00 09 28 43 00 15 10 60 00 21 24 03 00 02 10 43 00 13 24 03 00 0D 14 43 FF C0 00 00 00 00 12 00 FF BE 00 00 00 00 7C 03 E8 3B 02 63 10 21 24 03 00 59 AC 43 00 00 0? ?? ?? ?? 24 02 FF FF 7C 03 E8 3B 02 63 20 21 0? ?? ?? ?? AC 82 00 00 7C 03 E8 3B 02 63 10 21 0? ?? ?? ?? 8C 43 00 00 02 20 20 21 24 05 00 01 00 00 30 21 24 02 0F D7 00 00 00 0C 10 E0 00 0D 24 03 FF FF 7C 03 E8 3B 02 63 20 21 AC 82 00 00 0? ?? ?? ?? 24 02 FF FF 24 03 00 4E 10 43 FF E4 24 03 00 5A 10 43 FF E2 00 00 00 00 0? ?? ?? ?? 24 02 FF FF 14 43 FF DE 00 00 00 00 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "wmemset"
		size = 124
	strings:
		$1 = { 2C C3 00 04 14 60 00 1B 00 80 10 21 00 80 18 21 00 C0 38 21 24 E7 FF FC 2C E8 00 04 AC 65 00 00 AC 65 00 04 AC 65 00 08 AC 65 00 0C 11 00 FF F9 24 63 00 10 24 C3 FF FC 00 03 18 82 24 63 00 01 00 03 19 00 00 43 18 21 30 C6 00 03 10 C0 00 07 24 04 00 01 10 C4 00 05 AC 65 00 00 24 04 00 03 14 C4 00 02 AC 65 00 04 AC 65 00 08 03 E0 00 08 00 00 00 00 0? ?? ?? ?? 00 80 18 21 }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "__fdatasync_nocancel"
		size = 28
	strings:
		$1 = { 24 02 10 38 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_50_1_0 {
	meta:
		name = "fdatasync"
		size = 132
		refs = "0038 __libc_enable_asynccancel 005c __libc_disable_asynccancel"
	strings:
		$1 = { 7C 03 E8 3B 8C 63 8B 70 14 03 00 08 00 00 00 00 24 02 10 38 00 00 00 0C 14 E0 FF F0 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 27 BD FF D0 AF BF 00 1C AF A4 00 00 0? ?? ?? ?? 00 00 00 00 AF A2 00 2C 8F A4 00 00 24 02 10 38 00 00 00 0C AF A2 00 24 AF A7 00 28 8F A4 00 2C 0? ?? ?? ?? 00 00 00 00 8F A2 00 24 8F A7 00 28 8F BF 00 1C 14 E0 FF DA 27 BD 00 30 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "_dl_add_to_namespace_list"
		size = 260
		refs = "0000 __pthread_mutex_lock 0024 _dl_load_write_lock 0040 _dl_ns 0080 _dl_load_adds 00b0 __pthread_mutex_unlock"
	strings:
		$1 = { 3C 02 ?? ?? 27 BD FF D8 24 42 ?? ?? AF B1 00 20 AF B0 00 1C AF BF 00 24 00 80 88 21 10 40 00 04 00 A0 80 21 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 00 10 30 80 00 10 29 00 00 C5 10 21 00 50 10 23 3C 04 ?? ?? 00 02 10 80 24 84 ?? ?? 00 82 10 21 8C 43 00 00 14 60 00 04 00 00 00 00 0? ?? ?? ?? AC 51 00 00 00 40 18 21 8C 62 00 0C 14 40 FF FD 00 00 00 00 AE 23 00 10 AC 71 00 0C 3C 02 ?? ?? 8C 43 ?? ?? 00 C5 28 21 00 B0 80 23 00 10 80 80 8C 45 ?? ?? 00 90 80 21 24 64 00 01 8E 07 00 04 00 83 30 2B 00 C5 30 21 AC 46 ?? ?? AC 44 ?? ?? 3C 02 ?? ?? 24 E7 00 01 24 42 ?? ?? AE 07 00 04 AE 25 03 28 10 40 00 0A AE 23 03 2C 8F BF 00 24 8F B1 00 20 8F B0 00 1C 3C 04 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 27 BD 00 28 0? ?? ?? ?? 3C 02 ?? ?? 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_51_1_0 {
	meta:
		name = "_dl_new_object"
		size = 780
		refs = "0004 __gnu_local_gp 0048 strlen 005c calloc 0088 memcpy 0090 _dl_debug_mask 00cc _dl_ns 0198 __libc_errno 01b4 __getcwd 01d8 realloc 01f8 free 0268 strchr 028c mempcpy 02d4 malloc"
	strings:
		$1 = { 27 BD FF B8 3C 1C ?? ?? 27 9C ?? ?? AF B6 00 38 00 80 B0 21 00 A0 20 21 AF BF 00 44 AF B5 00 34 AF B4 00 30 AF B3 00 2C AF B2 00 28 AF B1 00 24 AF B0 00 20 AF BC 00 10 00 A0 98 21 00 C0 A0 21 00 E0 88 21 AF BE 00 40 0? ?? ?? ?? AF B7 00 3C 24 44 03 41 24 05 00 01 8F B2 00 5C 0? ?? ?? ?? 24 55 00 01 10 40 00 A1 00 40 80 21 24 43 03 30 26 04 03 40 24 42 03 34 02 60 28 21 02 A0 30 21 AE 03 02 38 AE 10 00 14 0? ?? ?? ?? AE 02 00 1C 3C 04 ?? ?? 8E 03 02 68 8C 85 ?? ?? 24 04 00 01 7E 83 FF 84 30 A5 01 00 AE 02 03 34 AE 04 03 3C AE 16 00 04 10 A0 00 63 AE 03 02 68 00 12 11 00 00 12 18 80 00 62 18 21 00 72 18 23 3C 02 ?? ?? 00 03 18 80 24 42 ?? ?? 00 62 10 21 8C 43 00 00 24 04 FF FF 26 02 02 8C AE 04 03 10 24 04 00 04 AE 11 02 40 AE 12 00 18 AE 02 02 A0 10 60 00 57 AE 04 02 9C 24 63 02 30 AE 03 02 8C 24 04 00 01 16 20 00 04 00 00 00 00 0? ?? ?? ?? 02 00 88 21 00 60 88 21 8E 23 02 40 14 60 FF FD 00 00 00 00 10 80 00 42 00 00 18 21 8E 03 02 8C 26 31 02 30 10 71 00 08 8F A4 00 58 30 84 00 10 10 80 00 6D 00 00 00 00 AE 03 02 90 00 00 18 21 00 43 10 21 AC 51 00 00 82 D1 00 00 26 02 02 30 AE 02 02 A4 12 20 00 25 02 00 10 21 0? ?? ?? ?? 02 C0 20 21 00 40 A0 21 24 42 00 01 AF A2 00 18 24 02 00 2F 12 22 00 50 8F BC 00 10 8F 97 ?? ?? 7C 03 E8 3B 8F B2 00 18 00 00 F0 21 02 E3 B8 21 0? ?? ?? ?? 24 15 00 22 0? ?? ?? ?? 00 00 00 00 14 40 00 29 02 20 F0 21 8E E2 00 00 14 55 00 3E 02 60 90 21 26 53 00 80 03 C0 20 21 0? ?? ?? ?? 02 60 28 21 26 45 00 7F 00 B4 28 23 00 40 88 21 14 40 FF F1 00 40 20 21 03 C0 20 21 0? ?? ?? ?? 24 11 FF FF AE 11 02 7C 02 00 10 21 8F BF 00 44 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 48 00 00 18 21 0? ?? ?? ?? 26 31 02 30 0? ?? ?? ?? AE 04 02 D4 10 80 FF FA 00 00 00 00 0? ?? ?? ?? 8E 03 02 8C 0? ?? ?? ?? 00 00 20 21 02 20 20 21 0? ?? ?? ?? 00 00 28 21 80 44 FF FF 24 03 00 2F 10 83 00 03 00 40 20 21 24 44 00 01 A0 43 00 00 8F A6 00 18 0? ?? ?? ?? 02 C0 28 21 0? ?? ?? ?? 24 05 00 2F 00 60 10 21 80 44 FF FF 14 85 FF FD 24 43 FF FF 02 23 20 26 00 44 18 0A A0 60 00 00 02 00 10 21 0? ?? ?? ?? AE 11 02 7C 0? ?? ?? ?? 03 C0 20 21 0? ?? ?? ?? 24 11 FF FF 0? ?? ?? ?? 8F A4 00 18 10 40 00 05 00 40 88 21 0? ?? ?? ?? 00 40 20 21 0? ?? ?? ?? 00 00 10 21 24 11 FF FF AE 11 02 7C 0? ?? ?? ?? 02 00 10 21 0? ?? ?? ?? 24 03 00 04 }
	condition:
		$1
}

rule file_53_0_0 {
	meta:
		name = "__atfct_seterrno_2"
		size = 588
		refs = "0000 __gnu_local_gp 003c strchr 0054 __lxstat64 007c __libc_errno 0094 __fxstat64 00b8 $LC0 0148 __xstat64"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF 30 27 9C ?? ?? AF B0 00 C4 AF BF 00 CC AF B1 00 C8 AF BC 00 10 10 C0 00 3F 00 80 80 21 24 02 00 14 10 82 00 17 24 02 00 02 14 82 00 41 24 C4 00 0E 24 05 00 2F 0? ?? ?? ?? AF A6 00 B8 A0 40 00 00 8F A6 00 B8 24 04 00 03 00 C0 28 21 0? ?? ?? ?? 27 A6 00 18 24 03 FF FF 10 43 00 6A 8F BC 00 10 14 40 00 52 8F A3 00 30 34 02 A0 00 30 63 F0 00 10 62 00 4E 8F 91 ?? ?? 0? ?? ?? ?? 24 10 00 09 27 B0 00 18 24 04 00 03 02 00 30 21 0? ?? ?? ?? AF A7 00 B8 8F BC 00 10 14 40 00 19 8F A7 00 B8 8F B1 00 30 24 02 40 00 32 31 F0 00 12 22 00 2F 3C 05 ?? ?? 8F A2 00 E0 10 40 00 0D 8F 91 ?? ?? 24 04 00 03 00 E0 28 21 0? ?? ?? ?? 02 00 30 21 14 40 00 0B 8F BC 00 10 8F B1 00 30 24 02 40 00 32 31 F0 00 12 22 00 14 3C 05 ?? ?? 8F 91 ?? ?? 24 10 00 14 7C 03 E8 3B 02 23 10 21 AC 50 00 00 8F BF 00 CC 8F B1 00 C8 8F B0 00 C4 03 E0 00 08 27 BD 00 D0 8F A2 00 E0 10 40 00 05 24 02 00 14 10 82 00 20 24 02 00 02 10 82 00 20 00 00 00 00 0? ?? ?? ?? 8F 91 ?? ?? 24 04 00 03 24 A5 ?? ?? 0? ?? ?? ?? 02 00 30 21 14 40 00 05 8F BC 00 10 8F A2 00 30 30 42 F0 00 10 51 FF E4 00 00 00 00 24 10 00 59 0? ?? ?? ?? 8F 91 ?? ?? 24 04 00 03 24 A5 ?? ?? 02 00 30 21 0? ?? ?? ?? AF A7 00 B8 8F BC 00 10 14 40 FF F6 8F A7 00 B8 8F A2 00 30 30 42 F0 00 10 51 FF C7 8F 91 ?? ?? 0? ?? ?? ?? 24 10 00 59 0? ?? ?? ?? 27 B0 00 18 8F 91 ?? ?? 8F A2 00 E0 10 40 00 11 24 05 00 2F 0? ?? ?? ?? 24 44 00 0E 8F A5 00 E0 A0 40 00 00 24 04 00 03 0? ?? ?? ?? 27 A6 00 18 24 03 FF FF 10 43 00 11 00 00 00 00 14 40 00 05 8F A3 00 30 34 02 A0 00 30 63 F0 00 14 62 FF A0 00 00 00 00 0? ?? ?? ?? 24 10 00 02 8F 91 ?? ?? 7C 03 E8 3B 02 23 10 21 8C 42 00 00 14 50 FF E7 8F A2 00 E0 0? ?? ?? ?? 24 10 00 09 7C 03 E8 3B 02 23 10 21 8C 43 00 00 24 02 00 02 10 62 FF 90 00 00 00 00 0? ?? ?? ?? 24 10 00 02 }
	condition:
		$1
}

rule file_53_1_0 {
	meta:
		name = "renameat"
		size = 500
		refs = "0008 __have_atfcts 0010 __gnu_local_gp 0068 __libc_errno 00a0 strlen 00c4 procfd.7870 00d8 __snprintf 0164 __atfct_seterrno_2"
	strings:
		$1 = { 27 BD FF C0 AF B2 00 28 3C 12 ?? ?? 8E 42 ?? ?? 3C 1C ?? ?? AF BE 00 38 27 9C ?? ?? 03 A0 F0 21 AF B4 00 30 AF B3 00 2C AF B1 00 24 AF B0 00 20 AF BF 00 3C AF B5 00 34 AF DC 00 18 00 80 98 21 00 A0 88 21 00 C0 A0 21 04 40 00 0F 00 E0 80 21 24 02 10 C7 00 00 00 0C 10 E0 00 46 24 03 FF FF 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 40 28 21 00 64 20 21 AC 82 00 00 24 03 00 59 14 A3 00 3F 24 02 FF FF AE 42 ?? ?? 24 02 FF 9C 12 62 00 46 24 02 00 2F 82 23 00 00 10 62 00 44 24 02 FF 9C 0? ?? ?? ?? 02 20 20 21 10 40 00 44 8F DC 00 18 24 43 00 2E 00 03 18 C2 00 03 18 C0 03 A3 E8 23 27 B2 00 18 3C 06 ?? ?? AF B1 00 10 02 40 20 21 24 45 00 20 24 C6 ?? ?? 0? ?? ?? ?? 02 60 38 21 24 02 FF 9C 12 82 00 33 02 40 88 21 82 03 00 00 24 02 00 2F 10 62 00 12 00 00 A8 21 0? ?? ?? ?? 02 00 20 21 10 40 00 2D 8F DC 00 18 24 43 00 2E 00 03 18 C2 00 03 18 C0 03 A3 E8 23 27 B5 00 18 3C 06 ?? ?? AF B0 00 10 02 A0 20 21 24 45 00 20 24 C6 ?? ?? 02 80 38 21 0? ?? ?? ?? 02 A0 80 21 02 20 20 21 02 00 28 21 24 02 0F C6 00 00 00 0C 10 E0 00 0A 00 40 20 21 AF B2 00 10 02 80 28 21 02 A0 30 21 0? ?? ?? ?? 02 60 38 21 0? ?? ?? ?? 24 02 FF FF 10 43 00 19 00 00 00 00 03 C0 E8 21 8F DF 00 3C 8F BE 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 40 24 02 FF 9C 16 82 FF CF 00 00 90 21 0? ?? ?? ?? 00 00 A8 21 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 02 AC 43 00 00 0? ?? ?? ?? 24 02 FF FF 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 0? ?? ?? ?? 8C 45 00 00 }
	condition:
		$1
}

rule file_54_0_0 {
	meta:
		name = "__getdate_r"
		size = 1700
		refs = "0004 __gnu_local_gp 0010 $LC0 0048 getenv 00a4 __xstat64 00cc __access 0124 _IO_new_fopen 0120 $LC1 0144 __libc_tsd_CTYPE_B 0180 strlen 0220 memcpy 0278 strptime 02ac __getline 02e8 free 0308 _IO_new_fclose 033c time 0348 __localtime_r 0494 mktime 04bc __libc_alloca_cutoff 04cc malloc 0540 memset"
	strings:
		$1 = { 27 BD FE B8 3C 1C ?? ?? AF B2 01 28 00 80 90 21 3C 04 ?? ?? AF BE 01 40 27 9C ?? ?? 03 A0 F0 21 24 84 ?? ?? AF B1 01 24 AF B0 01 20 AF BF 01 44 AF B7 01 3C AF B6 01 38 AF B5 01 34 AF B4 01 30 AF B3 01 2C AF DC 00 10 0? ?? ?? ?? 00 A0 88 21 10 40 00 24 00 40 80 21 80 42 00 00 14 40 00 0F 24 03 00 01 03 C0 E8 21 8F BF 01 44 8F BE 01 40 8F B7 01 3C 8F B6 01 38 8F B5 01 34 8F B4 01 30 8F B3 01 2C 8F B2 01 28 8F B1 01 24 8F B0 01 20 00 60 10 21 03 E0 00 08 27 BD 01 48 24 04 00 03 02 00 28 21 0? ?? ?? ?? 27 C6 00 18 04 40 FF ED 24 03 00 03 8F C4 00 30 34 02 80 00 30 84 F0 00 14 82 FF E8 24 03 00 04 02 00 20 21 0? ?? ?? ?? 24 05 00 04 04 41 00 12 02 00 20 21 0? ?? ?? ?? 24 03 00 02 03 C0 E8 21 8F BF 01 44 24 03 00 01 8F BE 01 40 8F B7 01 3C 8F B6 01 38 8F B5 01 34 8F B4 01 30 8F B3 01 2C 8F B2 01 28 8F B1 01 24 8F B0 01 20 00 60 10 21 03 E0 00 08 27 BD 01 48 3C 05 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 00 40 98 21 10 40 FF EA 8F DC 00 10 8C 44 00 00 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 34 84 80 00 AE 64 00 00 00 62 18 21 8C 74 00 00 0? ?? ?? ?? 82 42 00 00 82 42 00 00 00 02 10 40 02 82 10 21 94 42 00 00 30 42 00 20 14 40 FF FA 26 52 00 01 26 52 FF FF 0? ?? ?? ?? 02 40 20 21 10 40 00 63 00 00 00 00 24 50 FF FF 02 50 18 21 80 63 00 00 00 03 18 40 02 83 18 21 94 63 00 00 30 63 00 20 14 60 00 0C 26 03 FF FF 0? ?? ?? ?? 00 00 A8 21 80 84 00 00 00 04 20 40 02 84 20 21 94 84 00 00 30 84 00 20 10 80 00 05 00 00 00 00 00 60 80 21 26 03 FF FF 16 00 FF F6 02 43 20 21 02 02 10 2B 10 40 00 12 00 00 A8 21 26 14 00 01 34 02 80 01 02 82 10 2B 10 40 00 AE 26 82 00 0E 00 02 10 C2 00 02 10 C0 03 A2 E8 23 27 A3 00 10 02 40 28 21 02 00 30 21 0? ?? ?? ?? 00 60 20 21 00 50 80 21 A2 00 00 00 00 40 90 21 00 00 A8 21 AF C0 01 18 AF C0 01 14 00 00 B8 21 24 16 00 0A 3C 10 80 00 0? ?? ?? ?? 24 14 FF FF AE 30 00 18 AE 30 00 0C AE 30 00 10 AE 30 00 14 AE 30 00 04 AE 30 00 00 AE 30 00 08 AE 34 00 20 AE 20 00 24 0? ?? ?? ?? AE 20 00 28 10 40 00 04 00 40 B8 21 80 42 00 00 10 40 00 16 00 00 00 00 8E 62 00 00 30 42 00 10 14 40 00 12 00 00 00 00 27 C4 01 18 02 60 30 21 0? ?? ?? ?? 27 C5 01 14 00 40 18 21 02 40 20 21 02 20 30 21 04 60 00 09 24 42 FF FF 8F C5 01 18 00 A2 10 21 80 43 00 00 14 76 FF DF 00 00 00 00 A0 40 00 00 0? ?? ?? ?? 8F C5 01 18 0? ?? ?? ?? 02 A0 20 21 0? ?? ?? ?? 8F C4 01 18 8E 63 00 00 30 63 00 20 10 60 00 07 02 60 20 21 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 24 03 00 05 0? ?? ?? ?? 00 00 A8 21 0? ?? ?? ?? 00 00 00 00 12 E0 00 40 00 00 00 00 82 E2 00 00 14 40 FF 4B 24 03 00 07 0? ?? ?? ?? 27 C4 01 10 27 C4 01 10 0? ?? ?? ?? 27 C5 00 E4 8E 33 00 18 2E 62 00 07 10 40 00 36 3C 02 80 00 8E 32 00 14 8E 30 00 10 12 42 00 9E 00 00 18 21 2E 02 00 0C 10 40 00 04 3C 04 80 00 8E 22 00 0C 10 44 00 62 00 00 00 00 8E 24 00 08 3C 02 80 00 10 82 00 8F 8E 25 00 04 8E 22 00 00 3C 06 80 00 10 A6 00 89 00 00 00 00 3C 05 80 00 10 45 00 41 00 00 00 00 2C 82 00 18 10 40 00 04 3C 02 80 00 12 02 00 9C 00 00 00 00 3C 02 80 00 12 42 00 37 8F C2 00 F8 3C 02 80 00 12 02 00 6D 8F C2 00 F4 14 60 00 2C 00 00 00 00 8E 25 00 10 8E 22 00 14 8E 24 00 0C 2C A6 00 0C 10 C0 FF 1A 24 03 00 08 24 03 00 01 00 A3 18 04 30 65 0A D5 14 A0 00 62 30 65 05 28 14 A0 00 66 30 63 00 02 14 60 00 09 00 00 00 00 0? ?? ?? ?? 24 03 00 08 0? ?? ?? ?? 24 03 00 07 00 00 18 21 8E 32 00 14 0? ?? ?? ?? 8E 30 00 10 18 80 FF F7 24 42 07 6C 30 45 00 03 14 A0 00 0D 24 03 00 1C 24 03 00 64 00 43 00 1A 00 60 01 F4 00 00 28 10 14 A0 00 07 24 03 00 1D 24 05 01 90 00 45 00 1A 00 A0 01 F4 24 06 00 1C 00 00 38 10 00 C7 18 0B 00 64 20 2A 14 80 FE F5 24 03 00 08 0? ?? ?? ?? 02 20 20 21 00 02 10 27 24 03 00 08 0? ?? ?? ?? 00 02 18 0B 0? ?? ?? ?? AE 22 00 14 0? ?? ?? ?? AE 20 00 00 0? ?? ?? ?? 02 80 20 21 14 40 FF 50 26 82 00 0E 0? ?? ?? ?? 02 80 20 21 10 40 00 09 00 40 A8 21 02 40 28 21 02 00 30 21 00 40 20 21 0? ?? ?? ?? 02 B0 80 21 02 A0 90 21 0? ?? ?? ?? A2 00 00 00 0? ?? ?? ?? 02 60 20 21 0? ?? ?? ?? 24 03 00 06 16 42 00 08 3C 02 80 00 8F C2 00 F4 8F D2 00 F8 02 02 10 23 00 02 17 C2 02 42 90 21 AE 32 00 14 3C 02 80 00 12 62 00 14 24 14 00 01 27 C4 00 B8 00 00 28 21 0? ?? ?? ?? 24 06 00 2C 27 C4 00 B8 AF D2 00 CC AF D0 00 C8 0? ?? ?? ?? AF D4 00 C4 8F C3 00 D0 24 02 00 07 8E 32 00 14 02 63 18 23 24 63 00 07 00 62 00 1A 00 40 01 F4 8E 30 00 10 00 00 A0 10 26 94 00 01 AE 34 00 0C 0? ?? ?? ?? 24 03 00 01 0? ?? ?? ?? AE 22 00 10 24 82 FF FF 2C 42 00 1F 10 40 FF A0 00 00 00 00 0? ?? ?? ?? 00 00 00 00 24 82 FF FF 2C 42 00 1E 10 40 FF 9A 00 00 00 00 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? AE 20 00 04 10 A4 00 28 8E 22 00 00 AE 20 00 08 0? ?? ?? ?? 00 00 20 21 16 12 FF 63 2E 02 00 0C 8E 22 00 0C 14 50 FF 65 24 02 00 07 8F C3 00 FC 8F D2 00 F8 02 63 18 23 24 63 00 07 00 62 00 1A 00 40 01 F4 8F C2 00 F0 8F D0 00 F4 24 03 00 01 AE 32 00 14 AE 30 00 10 00 00 20 10 00 44 10 21 0? ?? ?? ?? AE 22 00 0C 8E 22 00 0C 14 50 FF 64 3C 02 80 00 8E 22 00 18 14 50 FF 61 3C 02 80 00 8F C2 00 EC 8F C3 00 F0 8F D0 00 F4 00 82 10 23 00 02 17 C2 00 62 10 21 AE 30 00 10 AE 22 00 0C 0? ?? ?? ?? 24 03 00 01 14 45 FF D8 8F C6 00 E4 8F C4 00 EC 8F C5 00 E8 AE 24 00 08 AE 25 00 04 14 82 00 03 AE 26 00 00 0? ?? ?? ?? 00 C0 10 21 0? ?? ?? ?? 00 C0 10 21 }
	condition:
		$1
}

rule file_54_1_0 {
	meta:
		name = "getdate"
		size = 84
		refs = "0010 __getdate_r 0038 getdate_err"
	strings:
		$1 = { 27 BD FF E0 AF B0 00 18 3C 10 ?? ?? AF BF 00 1C 0? ?? ?? ?? 26 05 ?? ?? 14 40 00 06 26 10 ?? ?? 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 8F BF 00 1C 3C 03 ?? ?? 00 00 80 21 AC 62 ?? ?? 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "__nss_ethers_lookup2"
		size = 228
		refs = "0008 __nss_ethers_database 0064 __nss_lookup 006c $LC0 007c __nss_database_lookup"
	strings:
		$1 = { 27 BD FF D0 AF B1 00 1C 3C 11 ?? ?? 8E 22 ?? ?? AF B4 00 28 AF B3 00 24 AF B2 00 20 AF B0 00 18 AF BF 00 2C 00 80 80 21 00 A0 A0 21 00 C0 98 21 10 40 00 0E 00 E0 90 21 AE 02 00 00 8F BF 00 2C 8F B1 00 1C 02 00 20 21 02 80 28 21 8F B0 00 18 8F B4 00 28 02 60 30 21 02 40 38 21 8F B3 00 24 8F B2 00 20 0? ?? ?? ?? 27 BD 00 30 3C 04 ?? ?? 24 84 ?? ?? 00 00 28 21 00 00 30 21 0? ?? ?? ?? 26 27 ?? ?? 04 40 00 0E 8E 22 ?? ?? 8F BF 00 2C 8F B1 00 1C AE 02 00 00 02 00 20 21 02 80 28 21 8F B0 00 18 8F B4 00 28 02 60 30 21 02 40 38 21 8F B3 00 24 8F B2 00 20 0? ?? ?? ?? 27 BD 00 30 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 24 02 FF FF 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_873_0_0 {
	meta:
		name = "__nss_aliases_lookup2"
		size = 228
		refs = "0008 __nss_aliases_database 0064 __nss_lookup 006c $LC0 007c __nss_database_lookup"
	strings:
		$1 = { 27 BD FF D0 AF B1 00 1C 3C 11 ?? ?? 8E 22 ?? ?? AF B4 00 28 AF B3 00 24 AF B2 00 20 AF B0 00 18 AF BF 00 2C 00 80 80 21 00 A0 A0 21 00 C0 98 21 10 40 00 0E 00 E0 90 21 AE 02 00 00 8F BF 00 2C 8F B1 00 1C 02 00 20 21 02 80 28 21 8F B0 00 18 8F B4 00 28 02 60 30 21 02 40 38 21 8F B3 00 24 8F B2 00 20 0? ?? ?? ?? 27 BD 00 30 3C 04 ?? ?? 24 84 ?? ?? 00 00 28 21 00 00 30 21 0? ?? ?? ?? 26 27 ?? ?? 04 40 00 0E 8E 22 ?? ?? 8F BF 00 2C 8F B1 00 1C AE 02 00 00 02 00 20 21 02 80 28 21 8F B0 00 18 8F B4 00 28 02 60 30 21 02 40 38 21 8F B3 00 24 8F B2 00 20 0? ?? ?? ?? 27 BD 00 30 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 24 02 FF FF 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_822_0_0 {
	meta:
		name = "__nss_netgroup_lookup2"
		size = 228
		refs = "0008 __nss_netgroup_database 0064 __nss_lookup 006c $LC0 007c __nss_database_lookup"
	strings:
		$1 = { 27 BD FF D0 AF B1 00 1C 3C 11 ?? ?? 8E 22 ?? ?? AF B4 00 28 AF B3 00 24 AF B2 00 20 AF B0 00 18 AF BF 00 2C 00 80 80 21 00 A0 A0 21 00 C0 98 21 10 40 00 0E 00 E0 90 21 AE 02 00 00 8F BF 00 2C 8F B1 00 1C 02 00 20 21 02 80 28 21 8F B0 00 18 8F B4 00 28 02 60 30 21 02 40 38 21 8F B3 00 24 8F B2 00 20 0? ?? ?? ?? 27 BD 00 30 3C 04 ?? ?? 24 84 ?? ?? 00 00 28 21 00 00 30 21 0? ?? ?? ?? 26 27 ?? ?? 04 40 00 0E 8E 22 ?? ?? 8F BF 00 2C 8F B1 00 1C AE 02 00 00 02 00 20 21 02 80 28 21 8F B0 00 18 8F B4 00 28 02 60 30 21 02 40 38 21 8F B3 00 24 8F B2 00 20 0? ?? ?? ?? 27 BD 00 30 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 24 02 FF FF 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_658_0_0 {
	meta:
		name = "__nss_protocols_lookup2"
		size = 228
		refs = "0008 __nss_protocols_database 0064 __nss_lookup 006c $LC0 007c __nss_database_lookup"
	strings:
		$1 = { 27 BD FF D0 AF B1 00 1C 3C 11 ?? ?? 8E 22 ?? ?? AF B4 00 28 AF B3 00 24 AF B2 00 20 AF B0 00 18 AF BF 00 2C 00 80 80 21 00 A0 A0 21 00 C0 98 21 10 40 00 0E 00 E0 90 21 AE 02 00 00 8F BF 00 2C 8F B1 00 1C 02 00 20 21 02 80 28 21 8F B0 00 18 8F B4 00 28 02 60 30 21 02 40 38 21 8F B3 00 24 8F B2 00 20 0? ?? ?? ?? 27 BD 00 30 3C 04 ?? ?? 24 84 ?? ?? 00 00 28 21 00 00 30 21 0? ?? ?? ?? 26 27 ?? ?? 04 40 00 0E 8E 22 ?? ?? 8F BF 00 2C 8F B1 00 1C AE 02 00 00 02 00 20 21 02 80 28 21 8F B0 00 18 8F B4 00 28 02 60 30 21 02 40 38 21 8F B3 00 24 8F B2 00 20 0? ?? ?? ?? 27 BD 00 30 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 24 02 FF FF 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_280_0_0 {
	meta:
		name = "__nss_rpc_lookup2"
		size = 228
		refs = "0008 __nss_rpc_database 0064 __nss_lookup 006c $LC0 007c __nss_database_lookup"
	strings:
		$1 = { 27 BD FF D0 AF B1 00 1C 3C 11 ?? ?? 8E 22 ?? ?? AF B4 00 28 AF B3 00 24 AF B2 00 20 AF B0 00 18 AF BF 00 2C 00 80 80 21 00 A0 A0 21 00 C0 98 21 10 40 00 0E 00 E0 90 21 AE 02 00 00 8F BF 00 2C 8F B1 00 1C 02 00 20 21 02 80 28 21 8F B0 00 18 8F B4 00 28 02 60 30 21 02 40 38 21 8F B3 00 24 8F B2 00 20 0? ?? ?? ?? 27 BD 00 30 3C 04 ?? ?? 24 84 ?? ?? 00 00 28 21 00 00 30 21 0? ?? ?? ?? 26 27 ?? ?? 04 40 00 0E 8E 22 ?? ?? 8F BF 00 2C 8F B1 00 1C AE 02 00 00 02 00 20 21 02 80 28 21 8F B0 00 18 8F B4 00 28 02 60 30 21 02 40 38 21 8F B3 00 24 8F B2 00 20 0? ?? ?? ?? 27 BD 00 30 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 24 02 FF FF 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_654_0_0 {
	meta:
		name = "__nss_services_lookup2"
		size = 228
		refs = "0008 __nss_services_database 0064 __nss_lookup 006c $LC0 007c __nss_database_lookup"
	strings:
		$1 = { 27 BD FF D0 AF B1 00 1C 3C 11 ?? ?? 8E 22 ?? ?? AF B4 00 28 AF B3 00 24 AF B2 00 20 AF B0 00 18 AF BF 00 2C 00 80 80 21 00 A0 A0 21 00 C0 98 21 10 40 00 0E 00 E0 90 21 AE 02 00 00 8F BF 00 2C 8F B1 00 1C 02 00 20 21 02 80 28 21 8F B0 00 18 8F B4 00 28 02 60 30 21 02 40 38 21 8F B3 00 24 8F B2 00 20 0? ?? ?? ?? 27 BD 00 30 3C 04 ?? ?? 24 84 ?? ?? 00 00 28 21 00 00 30 21 0? ?? ?? ?? 26 27 ?? ?? 04 40 00 0E 8E 22 ?? ?? 8F BF 00 2C 8F B1 00 1C AE 02 00 00 02 00 20 21 02 80 28 21 8F B0 00 18 8F B4 00 28 02 60 30 21 02 40 38 21 8F B3 00 24 8F B2 00 20 0? ?? ?? ?? 27 BD 00 30 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 24 02 FF FF 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_57_0_0 {
	meta:
		name = "__setstate_r"
		size = 296
		refs = "0000 __gnu_local_gp 0110 __libc_errno"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 10 80 00 3F 24 83 00 04 10 A0 00 3D 00 00 00 00 8C A2 00 0C 10 40 00 38 8C A6 00 08 8C A7 00 04 00 E6 38 23 00 07 38 83 00 07 40 80 01 07 38 21 00 E2 10 21 AC C2 FF FC 8C 86 00 00 3C 07 66 66 24 E7 66 67 00 C7 00 18 00 06 47 C3 00 00 10 10 00 02 10 43 00 48 10 23 00 02 40 80 01 02 10 21 00 C2 10 23 2C 46 00 05 10 C0 00 25 24 49 00 04 3C 06 ?? ?? 24 C6 ?? ?? 00 09 48 80 00 02 40 80 01 06 40 21 00 C9 48 21 8D 26 00 04 8D 08 00 00 AC A2 00 0C AC A6 00 10 10 40 00 11 AC A8 00 14 8C 82 00 00 00 47 00 18 00 02 17 C3 00 00 38 10 00 07 38 43 00 E2 38 23 00 E8 40 21 01 06 00 1A 00 C0 01 F4 00 07 38 80 00 67 38 21 AC A7 00 04 00 00 10 10 00 02 40 80 00 68 40 21 AC A8 00 00 00 06 30 80 00 66 30 21 AC A3 00 08 AC A6 00 18 03 E0 00 08 00 00 10 21 0? ?? ?? ?? AC C0 FF FC 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 16 AC 43 00 00 03 E0 00 08 24 02 FF FF }
	condition:
		$1
}

rule file_57_1_0 {
	meta:
		name = "__random_r"
		size = 200
		refs = "0000 __gnu_local_gp 00b0 __libc_errno"
	strings:
		$1 = { 3C 1C ?? ?? 10 80 00 28 27 9C ?? ?? 10 A0 00 26 00 00 00 00 8C 82 00 0C 10 40 00 1A 8C 83 00 08 8C 82 00 00 8C 88 00 04 8C 89 00 18 8C 4B 00 00 8D 07 00 00 24 46 00 04 00 C9 50 2B 01 67 38 21 00 07 58 42 AC 47 00 00 11 40 00 08 AC AB 00 00 25 08 00 04 01 09 48 2B 01 09 18 0B AC 86 00 00 AC 83 00 04 03 E0 00 08 00 00 10 21 00 60 30 21 25 03 00 04 AC 86 00 00 AC 83 00 04 03 E0 00 08 00 00 10 21 8C 66 00 00 3C 04 41 C6 24 84 4E 6D 70 C4 20 02 24 84 30 39 7C 84 F0 00 AC 64 00 00 03 E0 00 08 AC A4 00 00 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 16 AC 43 00 00 03 E0 00 08 24 02 FF FF }
	condition:
		$1
}

rule file_57_2_0 {
	meta:
		name = "__srandom_r"
		size = 352
		refs = "0130 __random_r"
	strings:
		$1 = { 10 A0 00 55 00 A0 68 21 8C A3 00 0C 2C 62 00 05 10 40 00 51 00 00 00 00 8C AB 00 08 24 02 00 01 00 84 10 0B 10 60 00 4A AD 62 00 00 8C A5 00 10 01 60 30 21 28 A3 00 02 14 60 00 2E 24 07 00 01 3C 0C 83 4E 3C 0A 7F FF 25 8C 0B 5F 35 4A FF FF 00 4C 00 18 00 02 27 C3 24 C6 00 04 24 E7 00 01 00 00 18 10 00 62 18 21 00 03 1C 03 00 64 18 23 00 03 40 80 00 03 4A 40 01 28 48 23 01 23 48 23 00 09 20 C0 00 89 48 23 00 09 48 80 01 23 48 21 00 09 20 C0 01 24 48 21 00 49 10 23 00 03 71 80 00 02 21 C0 00 02 49 40 01 C8 40 23 01 24 48 21 01 03 40 23 00 08 20 80 00 09 71 00 00 88 40 23 01 C9 48 23 01 22 10 21 00 08 40 80 00 02 20 C0 01 03 18 21 00 82 10 23 00 03 18 80 00 43 10 23 00 4A 18 21 28 44 00 00 00 64 10 0B 14 E5 FF D8 AC C2 00 00 8D A2 00 14 00 05 60 40 00 05 28 C0 00 02 10 80 01 85 60 21 01 62 10 21 25 8C FF FF AD A2 00 00 AD AB 00 04 05 80 00 0D 24 0E FF FF 27 BD FF D8 AF BF 00 24 01 A0 20 21 27 A5 00 18 0? ?? ?? ?? 25 8C FF FF 15 8E FF FC 01 A0 20 21 8F BF 00 24 00 00 10 21 03 E0 00 08 27 BD 00 28 03 E0 00 08 00 00 10 21 03 E0 00 08 24 02 FF FF }
	condition:
		$1
}

rule file_57_3_0 {
	meta:
		name = "__initstate_r"
		size = 384
		refs = "0000 __gnu_local_gp 0074 __srandom_r 0168 __libc_errno"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF E0 27 9C ?? ?? 00 E0 78 21 AF BF 00 1C AF B0 00 18 10 E0 00 51 AF BC 00 10 8C E2 00 08 10 40 00 05 00 A0 80 21 8C E3 00 0C 14 60 00 3B 00 00 00 00 AC 40 FF FC 2C C2 00 80 10 40 00 14 2C C2 00 20 10 40 00 41 24 18 00 01 2C C6 00 08 14 C0 00 42 00 00 00 00 26 02 00 04 AD E0 00 0C AD E0 00 14 AD E0 00 10 AD E2 00 18 AD E2 00 08 0? ?? ?? ?? 01 E0 28 21 AE 00 00 00 00 00 10 21 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 2C C6 01 00 24 18 00 04 24 02 00 03 00 46 C0 0B 27 02 00 04 3C 03 ?? ?? 24 63 ?? ?? 00 02 10 80 00 62 10 21 00 18 28 80 8C 42 00 04 00 A3 18 21 8C 65 00 00 26 19 00 04 00 02 18 80 03 23 18 21 AD F8 00 0C AD E5 00 14 AD E3 00 18 AD F9 00 08 AD E2 00 10 0? ?? ?? ?? 01 E0 28 21 8D E3 00 04 8F BF 00 1C 00 00 10 21 00 79 C8 23 00 19 C8 83 00 19 18 80 00 79 C8 21 03 38 C0 21 AE 18 00 00 8F B0 00 18 03 E0 00 08 27 BD 00 20 8C E5 00 04 00 A2 28 23 00 05 28 83 00 05 38 80 00 E5 28 21 00 A3 18 21 AC 43 FF FC 2C C2 00 80 14 40 FF C1 2C C2 00 20 0? ?? ?? ?? 2C C6 01 00 2C C6 00 40 24 02 00 02 0? ?? ?? ?? 00 46 C0 0A 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 16 AC 43 00 00 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_58_0_0 {
	meta:
		name = "fputwc"
		size = 484
		refs = "006c __lll_lock_wait_private 0090 _IO_fwide 015c __woverflow 0190 _Unwind_Resume"
	strings:
		$1 = { 8C A2 00 00 27 BD FF D0 AF B2 00 28 30 42 80 00 AF B0 00 20 AF BF 00 2C AF B1 00 24 00 A0 80 21 14 40 00 1A 00 80 90 21 7C 03 E8 3B 8C A4 00 48 24 71 8B 70 8C 83 00 08 10 71 00 11 00 00 00 00 AF A0 00 18 C0 85 00 00 14 A0 00 06 24 03 00 00 24 01 00 01 E0 81 00 00 10 20 FF FA 24 03 00 01 00 00 00 0F 14 60 00 03 00 00 00 00 0? ?? ?? ?? AF A5 00 18 8E 03 00 48 00 60 20 21 AC 71 00 08 8C 83 00 04 24 63 00 01 AC 83 00 04 02 00 20 21 0? ?? ?? ?? 24 05 00 01 04 40 00 0C 24 11 FF FF 8E 02 00 5C 10 40 00 2D 02 00 20 21 8C 43 00 10 8C 44 00 14 00 64 20 2B 10 80 00 27 24 64 00 04 AC 44 00 10 02 40 88 21 AC 72 00 00 8E 02 00 00 30 42 80 00 14 40 00 07 8F BF 00 2C 8E 04 00 48 8C 82 00 04 24 42 FF FF 10 40 00 08 AC 82 00 04 8F BF 00 2C 02 20 10 21 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 30 AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF F0 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 2C 02 00 20 21 0? ?? ?? ?? 02 40 28 21 0? ?? ?? ?? 00 40 88 21 8E 02 00 00 30 42 80 00 14 40 00 06 00 80 88 21 8E 04 00 48 8C 83 00 04 24 63 FF FF 10 60 00 03 AC 83 00 04 0? ?? ?? ?? 02 20 20 21 AC 80 00 08 00 00 00 0F C0 83 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 63 00 02 14 60 FF F5 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_59_0_0 {
	meta:
		name = "__towctrans_l"
		size = 132
		altNames = "__towctrans"
	strings:
		$1 = { 10 A0 00 1E 00 80 10 21 8C A6 00 00 8C A3 00 04 00 C4 20 06 00 83 18 2B 10 60 00 18 24 84 00 05 00 04 20 80 00 A4 20 21 8C 83 00 00 10 60 00 13 00 00 00 00 8C A4 00 08 8C A6 00 0C 00 82 20 06 00 86 20 24 00 04 20 80 00 83 18 21 00 A3 18 21 8C 63 00 00 10 60 00 09 00 00 00 00 8C A4 00 10 00 44 20 24 00 04 20 80 00 83 18 21 00 A3 28 21 8C A3 00 00 03 E0 00 08 00 43 10 21 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_60_0_0 {
	meta:
		name = "wcscmp"
		size = 56
	strings:
		$1 = { 24 A5 00 04 8C A3 FF FC 24 84 00 04 10 60 00 08 8C 82 FF FC 10 43 FF FB 24 A5 00 04 24 A5 FF FC 00 43 18 2A 24 04 00 01 24 02 FF FF 00 83 10 0A 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_61_0_0 {
	meta:
		name = "__iswalnum_l"
		size = 196
	strings:
		$1 = { 24 02 FF 80 00 82 10 24 10 40 00 27 00 00 00 00 8C A3 00 00 8C 65 00 68 24 A5 00 13 00 05 28 80 00 65 18 21 8C 63 00 04 8C 65 00 00 8C 66 00 04 00 A4 28 06 00 A6 30 2B 10 C0 00 19 00 00 10 21 24 A5 00 05 00 05 28 80 00 65 28 21 8C A5 00 00 10 A0 00 13 00 00 00 00 8C 66 00 08 8C 67 00 0C 00 C4 30 06 00 C7 30 24 00 06 30 80 00 C5 28 21 00 65 28 21 8C A5 00 00 10 A0 00 09 00 04 31 42 8C 62 00 10 00 C2 10 24 00 02 10 80 00 45 28 21 00 65 18 21 8C 62 00 00 00 82 20 06 30 82 00 01 03 E0 00 08 00 00 00 00 8C A2 00 34 00 04 20 40 00 44 20 21 94 82 00 00 30 42 08 00 03 E0 00 08 30 42 FF FF }
	condition:
		$1
}

rule file_61_1_0 {
	meta:
		name = "__iswalpha_l"
		size = 196
	strings:
		$1 = { 24 02 FF 80 00 82 10 24 10 40 00 27 00 00 00 00 8C A3 00 00 8C 65 00 68 24 A5 00 0A 00 05 28 80 00 65 18 21 8C 63 00 04 8C 65 00 00 8C 66 00 04 00 A4 28 06 00 A6 30 2B 10 C0 00 19 00 00 10 21 24 A5 00 05 00 05 28 80 00 65 28 21 8C A5 00 00 10 A0 00 13 00 00 00 00 8C 66 00 08 8C 67 00 0C 00 C4 30 06 00 C7 30 24 00 06 30 80 00 C5 28 21 00 65 28 21 8C A5 00 00 10 A0 00 09 00 04 31 42 8C 62 00 10 00 C2 10 24 00 02 10 80 00 45 28 21 00 65 18 21 8C 62 00 00 00 82 20 06 30 82 00 01 03 E0 00 08 00 00 00 00 8C A2 00 34 00 04 20 40 00 44 20 21 94 82 00 00 30 42 00 04 03 E0 00 08 30 42 FF FF }
	condition:
		$1
}

rule file_61_2_0 {
	meta:
		name = "__iswblank_l"
		size = 196
	strings:
		$1 = { 24 02 FF 80 00 82 10 24 10 40 00 27 00 00 00 00 8C A3 00 00 8C 65 00 68 24 A5 00 10 00 05 28 80 00 65 18 21 8C 63 00 04 8C 65 00 00 8C 66 00 04 00 A4 28 06 00 A6 30 2B 10 C0 00 19 00 00 10 21 24 A5 00 05 00 05 28 80 00 65 28 21 8C A5 00 00 10 A0 00 13 00 00 00 00 8C 66 00 08 8C 67 00 0C 00 C4 30 06 00 C7 30 24 00 06 30 80 00 C5 28 21 00 65 28 21 8C A5 00 00 10 A0 00 09 00 04 31 42 8C 62 00 10 00 C2 10 24 00 02 10 80 00 45 28 21 00 65 18 21 8C 62 00 00 00 82 20 06 30 82 00 01 03 E0 00 08 00 00 00 00 8C A2 00 34 00 04 20 40 00 44 20 21 94 82 00 00 30 42 01 00 03 E0 00 08 30 42 FF FF }
	condition:
		$1
}

rule file_61_3_0 {
	meta:
		name = "__iswcntrl_l"
		size = 196
	strings:
		$1 = { 24 02 FF 80 00 82 10 24 10 40 00 27 00 00 00 00 8C A3 00 00 8C 65 00 68 24 A5 00 11 00 05 28 80 00 65 18 21 8C 63 00 04 8C 65 00 00 8C 66 00 04 00 A4 28 06 00 A6 30 2B 10 C0 00 19 00 00 10 21 24 A5 00 05 00 05 28 80 00 65 28 21 8C A5 00 00 10 A0 00 13 00 00 00 00 8C 66 00 08 8C 67 00 0C 00 C4 30 06 00 C7 30 24 00 06 30 80 00 C5 28 21 00 65 28 21 8C A5 00 00 10 A0 00 09 00 04 31 42 8C 62 00 10 00 C2 10 24 00 02 10 80 00 45 28 21 00 65 18 21 8C 62 00 00 00 82 20 06 30 82 00 01 03 E0 00 08 00 00 00 00 8C A2 00 34 00 04 20 40 00 44 20 21 94 82 00 00 30 42 02 00 03 E0 00 08 30 42 FF FF }
	condition:
		$1
}

rule file_61_4_0 {
	meta:
		name = "__iswdigit_l"
		size = 180
	strings:
		$1 = { 24 02 FF 80 00 82 10 24 10 40 00 27 00 00 00 00 8C A3 00 00 8C 65 00 68 24 A5 00 0B 00 05 28 80 00 65 18 21 8C 63 00 04 8C 65 00 00 8C 66 00 04 00 A4 28 06 00 A6 30 2B 10 C0 00 19 00 00 10 21 24 A5 00 05 00 05 28 80 00 65 28 21 8C A5 00 00 10 A0 00 13 00 00 00 00 8C 66 00 08 8C 67 00 0C 00 C4 30 06 00 C7 30 24 00 06 30 80 00 C5 28 21 00 65 28 21 8C A5 00 00 10 A0 00 09 00 04 31 42 8C 62 00 10 00 C2 10 24 00 02 10 80 00 45 28 21 00 65 18 21 8C 62 00 00 00 82 20 06 30 82 00 01 03 E0 00 08 00 00 00 00 24 84 FF D0 03 E0 00 08 2C 82 00 0A }
	condition:
		$1
}

rule file_61_5_0 {
	meta:
		name = "__iswlower_l"
		size = 196
	strings:
		$1 = { 24 02 FF 80 00 82 10 24 10 40 00 27 00 00 00 00 8C A3 00 00 8C 65 00 68 24 A5 00 09 00 05 28 80 00 65 18 21 8C 63 00 04 8C 65 00 00 8C 66 00 04 00 A4 28 06 00 A6 30 2B 10 C0 00 19 00 00 10 21 24 A5 00 05 00 05 28 80 00 65 28 21 8C A5 00 00 10 A0 00 13 00 00 00 00 8C 66 00 08 8C 67 00 0C 00 C4 30 06 00 C7 30 24 00 06 30 80 00 C5 28 21 00 65 28 21 8C A5 00 00 10 A0 00 09 00 04 31 42 8C 62 00 10 00 C2 10 24 00 02 10 80 00 45 28 21 00 65 18 21 8C 62 00 00 00 82 20 06 30 82 00 01 03 E0 00 08 00 00 00 00 8C A2 00 34 00 04 20 40 00 44 20 21 94 82 00 00 30 42 00 02 03 E0 00 08 30 42 FF FF }
	condition:
		$1
}

rule file_61_6_0 {
	meta:
		name = "__iswgraph_l"
		size = 196
	strings:
		$1 = { 24 02 FF 80 00 82 10 24 10 40 00 27 00 00 00 00 8C A3 00 00 8C 65 00 68 24 A5 00 0F 00 05 28 80 00 65 18 21 8C 63 00 04 8C 65 00 00 8C 66 00 04 00 A4 28 06 00 A6 30 2B 10 C0 00 19 00 00 10 21 24 A5 00 05 00 05 28 80 00 65 28 21 8C A5 00 00 10 A0 00 13 00 00 00 00 8C 66 00 08 8C 67 00 0C 00 C4 30 06 00 C7 30 24 00 06 30 80 00 C5 28 21 00 65 28 21 8C A5 00 00 10 A0 00 09 00 04 31 42 8C 62 00 10 00 C2 10 24 00 02 10 80 00 45 28 21 00 65 18 21 8C 62 00 00 00 82 20 06 30 82 00 01 03 E0 00 08 00 00 00 00 8C A2 00 34 00 04 20 40 00 44 20 21 94 82 00 00 30 42 00 80 03 E0 00 08 30 42 FF FF }
	condition:
		$1
}

rule file_61_7_0 {
	meta:
		name = "__iswprint_l"
		size = 196
	strings:
		$1 = { 24 02 FF 80 00 82 10 24 10 40 00 27 00 00 00 00 8C A3 00 00 8C 65 00 68 24 A5 00 0E 00 05 28 80 00 65 18 21 8C 63 00 04 8C 65 00 00 8C 66 00 04 00 A4 28 06 00 A6 30 2B 10 C0 00 19 00 00 10 21 24 A5 00 05 00 05 28 80 00 65 28 21 8C A5 00 00 10 A0 00 13 00 00 00 00 8C 66 00 08 8C 67 00 0C 00 C4 30 06 00 C7 30 24 00 06 30 80 00 C5 28 21 00 65 28 21 8C A5 00 00 10 A0 00 09 00 04 31 42 8C 62 00 10 00 C2 10 24 00 02 10 80 00 45 28 21 00 65 18 21 8C 62 00 00 00 82 20 06 30 82 00 01 03 E0 00 08 00 00 00 00 8C A2 00 34 00 04 20 40 00 44 20 21 94 82 00 00 30 42 00 40 03 E0 00 08 30 42 FF FF }
	condition:
		$1
}

rule file_61_8_0 {
	meta:
		name = "__iswpunct_l"
		size = 196
	strings:
		$1 = { 24 02 FF 80 00 82 10 24 10 40 00 27 00 00 00 00 8C A3 00 00 8C 65 00 68 24 A5 00 12 00 05 28 80 00 65 18 21 8C 63 00 04 8C 65 00 00 8C 66 00 04 00 A4 28 06 00 A6 30 2B 10 C0 00 19 00 00 10 21 24 A5 00 05 00 05 28 80 00 65 28 21 8C A5 00 00 10 A0 00 13 00 00 00 00 8C 66 00 08 8C 67 00 0C 00 C4 30 06 00 C7 30 24 00 06 30 80 00 C5 28 21 00 65 28 21 8C A5 00 00 10 A0 00 09 00 04 31 42 8C 62 00 10 00 C2 10 24 00 02 10 80 00 45 28 21 00 65 18 21 8C 62 00 00 00 82 20 06 30 82 00 01 03 E0 00 08 00 00 00 00 8C A2 00 34 00 04 20 40 00 44 20 21 94 82 00 00 30 42 04 00 03 E0 00 08 30 42 FF FF }
	condition:
		$1
}

rule file_61_9_0 {
	meta:
		name = "__iswspace_l"
		size = 196
	strings:
		$1 = { 24 02 FF 80 00 82 10 24 10 40 00 27 00 00 00 00 8C A3 00 00 8C 65 00 68 24 A5 00 0D 00 05 28 80 00 65 18 21 8C 63 00 04 8C 65 00 00 8C 66 00 04 00 A4 28 06 00 A6 30 2B 10 C0 00 19 00 00 10 21 24 A5 00 05 00 05 28 80 00 65 28 21 8C A5 00 00 10 A0 00 13 00 00 00 00 8C 66 00 08 8C 67 00 0C 00 C4 30 06 00 C7 30 24 00 06 30 80 00 C5 28 21 00 65 28 21 8C A5 00 00 10 A0 00 09 00 04 31 42 8C 62 00 10 00 C2 10 24 00 02 10 80 00 45 28 21 00 65 18 21 8C 62 00 00 00 82 20 06 30 82 00 01 03 E0 00 08 00 00 00 00 8C A2 00 34 00 04 20 40 00 44 20 21 94 82 00 00 30 42 00 20 03 E0 00 08 30 42 FF FF }
	condition:
		$1
}

rule file_61_10_0 {
	meta:
		name = "__iswupper_l"
		size = 192
	strings:
		$1 = { 24 02 FF 80 00 82 10 24 10 40 00 27 00 00 00 00 8C A3 00 00 8C 65 00 68 24 A5 00 08 00 05 28 80 00 65 18 21 8C 63 00 04 8C 65 00 00 8C 66 00 04 00 A4 28 06 00 A6 30 2B 10 C0 00 19 00 00 10 21 24 A5 00 05 00 05 28 80 00 65 28 21 8C A5 00 00 10 A0 00 13 00 00 00 00 8C 66 00 08 8C 67 00 0C 00 C4 30 06 00 C7 30 24 00 06 30 80 00 C5 28 21 00 65 28 21 8C A5 00 00 10 A0 00 09 00 04 31 42 8C 62 00 10 00 C2 10 24 00 02 10 80 00 45 28 21 00 65 18 21 8C 62 00 00 00 82 20 06 30 82 00 01 03 E0 00 08 00 00 00 00 8C A2 00 34 00 04 20 40 00 44 20 21 94 82 00 00 03 E0 00 08 30 42 00 01 }
	condition:
		$1
}

rule file_61_11_0 {
	meta:
		name = "__iswxdigit_l"
		size = 196
	strings:
		$1 = { 24 02 FF 80 00 82 10 24 10 40 00 27 00 00 00 00 8C A3 00 00 8C 65 00 68 24 A5 00 0C 00 05 28 80 00 65 18 21 8C 63 00 04 8C 65 00 00 8C 66 00 04 00 A4 28 06 00 A6 30 2B 10 C0 00 19 00 00 10 21 24 A5 00 05 00 05 28 80 00 65 28 21 8C A5 00 00 10 A0 00 13 00 00 00 00 8C 66 00 08 8C 67 00 0C 00 C4 30 06 00 C7 30 24 00 06 30 80 00 C5 28 21 00 65 28 21 8C A5 00 00 10 A0 00 09 00 04 31 42 8C 62 00 10 00 C2 10 24 00 02 10 80 00 45 28 21 00 65 18 21 8C 62 00 00 00 82 20 06 30 82 00 01 03 E0 00 08 00 00 00 00 8C A2 00 34 00 04 20 40 00 44 20 21 94 82 00 00 30 42 00 10 03 E0 00 08 30 42 FF FF }
	condition:
		$1
}

rule file_61_12_0 {
	meta:
		name = "__towlower_l"
		size = 148
	strings:
		$1 = { 8C A3 00 00 00 80 10 21 8C 65 00 6C 24 A5 00 09 00 05 28 80 00 65 18 21 8C 63 00 04 8C 66 00 00 8C 65 00 04 00 C4 20 06 00 85 28 2B 10 A0 00 17 24 84 00 05 00 04 20 80 00 64 20 21 8C 84 00 00 10 80 00 12 00 00 00 00 8C 65 00 08 8C 66 00 0C 00 A2 28 06 00 A6 28 24 00 05 28 80 00 A4 20 21 00 64 20 21 8C 84 00 00 10 80 00 08 00 00 00 00 8C 65 00 10 00 45 28 24 00 05 28 80 00 A4 20 21 00 64 18 21 8C 63 00 00 00 43 10 21 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_61_13_0 {
	meta:
		name = "__towupper_l"
		size = 148
	strings:
		$1 = { 8C A3 00 00 00 80 10 21 8C 65 00 6C 24 A5 00 08 00 05 28 80 00 65 18 21 8C 63 00 04 8C 66 00 00 8C 65 00 04 00 C4 20 06 00 85 28 2B 10 A0 00 17 24 84 00 05 00 04 20 80 00 64 20 21 8C 84 00 00 10 80 00 12 00 00 00 00 8C 65 00 08 8C 66 00 0C 00 A2 28 06 00 A6 28 24 00 05 28 80 00 A4 20 21 00 64 20 21 8C 84 00 00 10 80 00 08 00 00 00 00 8C 65 00 10 00 45 28 24 00 05 28 80 00 A4 20 21 00 64 18 21 8C 63 00 00 00 43 10 21 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "__strnlen"
		size = 268
	strings:
		$1 = { 10 A0 00 33 00 00 10 21 00 85 28 21 00 A4 30 2B 24 03 FF FF 30 82 00 03 10 40 00 38 00 66 28 0B 80 82 00 00 10 40 00 37 00 00 00 00 0? ?? ?? ?? 00 80 10 21 80 43 00 00 10 60 00 23 00 A2 18 2B 24 42 00 01 30 43 00 03 14 60 FF FA 00 00 00 00 00 45 18 2B 10 60 00 1B 3C 09 FE FE 3C 08 80 80 35 29 FE FF 35 08 80 80 24 43 00 04 8C 66 FF FC 00 C9 30 21 00 C8 30 24 10 C0 00 0D 00 65 38 2B 80 66 FF FC 10 C0 00 0F 00 00 00 00 80 66 FF FD 10 C0 00 0B 00 00 00 00 80 66 FF FE 10 C0 00 15 00 00 00 00 80 66 FF FF 10 C0 00 0B 00 00 00 00 10 E0 00 0B 00 00 00 00 0? ?? ?? ?? 00 60 10 21 24 42 00 01 00 A2 18 2B 00 A3 10 0B 00 44 10 23 03 E0 00 08 00 00 00 00 0? ?? ?? ?? 24 42 00 03 00 A0 10 21 00 A5 18 2B 00 A3 10 0B 03 E0 00 08 00 44 10 23 0? ?? ?? ?? 24 42 00 02 0? ?? ?? ?? 00 80 10 21 0? ?? ?? ?? 00 80 10 21 }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "__posix_spawnp"
		size = 48
		refs = "001c __spawni"
	strings:
		$1 = { 27 BD FF D0 8F A2 00 40 AF BF 00 2C AF A2 00 10 8F A2 00 44 AF A2 00 14 24 02 00 01 0? ?? ?? ?? AF A2 00 18 8F BF 00 2C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "wait_on_socket"
		size = 336
		refs = "0004 __gnu_local_gp 0040 __poll 0074 __libc_errno 0094 __gettimeofday"
	strings:
		$1 = { 27 BD FF C0 3C 1C ?? ?? AF B0 00 28 00 A0 80 21 27 9C ?? ?? AF A4 00 20 24 02 00 19 27 A4 00 20 24 05 00 01 02 00 30 21 AF BC 00 10 AF BF 00 3C AF B4 00 38 AF B3 00 34 AF B2 00 30 AF B1 00 2C 0? ?? ?? ?? A7 A2 00 24 24 03 FF FF 10 43 00 09 8F BC 00 10 8F BF 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 40 8F 91 ?? ?? 7C 03 E8 3B 02 23 88 21 8E 24 00 00 24 03 00 04 14 83 FF F3 8F BF 00 3C 27 A4 00 18 0? ?? ?? ?? 00 00 28 21 8F A3 00 1C 24 02 03 E8 8F A4 00 18 24 63 01 F4 00 62 00 1A 00 40 01 F4 3C 12 10 62 02 20 A0 21 24 13 FF FF 26 52 4D D3 00 00 18 12 70 44 28 02 00 B0 10 21 0? ?? ?? ?? 00 43 88 21 8E 86 00 00 24 03 00 04 14 C3 FF DD 8F BF 00 3C 0? ?? ?? ?? 00 00 00 00 8F A3 00 1C 8F A2 00 18 24 63 01 F4 00 72 00 18 00 02 28 80 00 02 31 C0 00 C5 28 23 00 03 1F C3 00 A2 10 21 00 02 10 C0 00 00 20 10 00 04 21 83 00 64 80 23 02 02 80 23 02 11 80 21 27 A4 00 20 24 05 00 01 0? ?? ?? ?? 02 00 30 21 27 A4 00 18 10 53 FF E5 00 00 28 21 0? ?? ?? ?? 8F BF 00 3C }
	condition:
		$1
}

rule file_64_1_0 {
	meta:
		name = "open_socket"
		size = 740
		refs = "0008 __have_sock_cloexec 0010 __gnu_local_gp 0058 __socket 00bc $LC0 0118 __connect 0140 memcpy 0154 __libc_errno 016c __send 0224 __gettimeofday 025c __poll 02a0 __fcntl"
	strings:
		$1 = { 27 BD FF 40 AF B0 00 A0 3C 10 ?? ?? 8E 02 ?? ?? 3C 1C ?? ?? AF BE 00 B8 27 9C ?? ?? 03 A0 F0 21 AF B4 00 B0 AF B3 00 AC AF B2 00 A8 AF BF 00 BC AF B5 00 B4 AF B1 00 A4 AF DC 00 10 00 80 98 21 00 A0 A0 21 04 40 00 5C 00 C0 90 21 3C 05 00 08 24 04 00 01 24 A5 00 82 0? ?? ?? ?? 00 00 30 21 8E 03 ?? ?? 00 40 88 21 8F DC 00 10 14 60 00 05 00 60 10 21 24 03 FF FF 12 23 00 7E 24 02 00 01 AE 02 ?? ?? 04 40 00 4D 24 04 00 01 06 20 00 88 26 43 00 0F 24 02 FF FC 00 62 18 24 24 63 00 0A 00 03 18 C2 8E 02 ?? ?? 00 03 18 C0 03 A3 E8 23 27 B0 00 10 04 40 00 78 26 55 00 0C 3C 03 ?? ?? 8C 62 ?? ?? 24 63 ?? ?? 8C 64 00 04 24 05 00 01 A7 C5 00 18 AB C2 00 1A BB C2 00 1D 8C 62 00 08 AB C4 00 1E BB C4 00 21 8C 64 00 0C AB C2 00 22 BB C2 00 25 8C 62 00 10 AB C4 00 26 90 63 00 14 BB C4 00 29 AB C2 00 2A 02 20 20 21 27 C5 00 18 24 06 00 6E BB C2 00 2D 0? ?? ?? ?? A3 C3 00 2E 04 40 00 2B 8F DC 00 10 24 02 00 02 02 40 30 21 AE 13 00 04 AE 12 00 08 26 04 00 0C 02 80 28 21 0? ?? ?? ?? AE 02 00 00 8F DC 00 10 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 24 12 00 01 00 62 98 21 02 20 20 21 02 00 28 21 02 A0 30 21 0? ?? ?? ?? 24 07 40 00 24 03 FF FF 10 43 00 22 24 04 00 04 14 55 00 1C 02 20 20 21 02 20 10 21 03 C0 E8 21 8F BF 00 BC 8F BE 00 B8 8F B5 00 B4 8F B4 00 B0 8F B3 00 AC 8F B2 00 A8 8F B1 00 A4 8F B0 00 A0 03 E0 00 08 27 BD 00 C0 24 04 00 01 24 05 00 02 0? ?? ?? ?? 00 00 30 21 0? ?? ?? ?? 00 40 88 21 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 8C 43 00 00 24 02 00 96 10 62 FF CF 00 00 00 00 02 20 20 21 24 02 0F A6 00 00 00 0C 0? ?? ?? ?? 24 02 FF FF 8E 63 00 00 10 64 FF D5 00 00 00 00 12 A2 FF DE 02 20 10 21 24 02 00 0B 14 62 FF F4 27 C4 00 90 0? ?? ?? ?? 00 00 28 21 12 40 00 22 8F C4 00 9C 8F C2 00 90 8F C3 00 94 24 06 13 88 24 42 00 05 AF C3 00 9C AF C2 00 98 24 02 00 1C 27 C4 00 88 24 05 00 01 AF D1 00 88 0? ?? ?? ?? A7 C2 00 8C 18 40 FF E2 00 00 90 21 0? ?? ?? ?? 02 20 20 21 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 64 20 21 8C 83 00 00 38 63 00 16 02 23 10 0A 0? ?? ?? ?? AE 02 ?? ?? 02 20 20 21 24 05 00 04 0? ?? ?? ?? 24 06 00 82 0? ?? ?? ?? 3C 03 ?? ?? 0? ?? ?? ?? 24 02 FF FF 8F C3 00 94 24 02 03 E8 8F C5 00 98 00 83 18 23 00 62 00 1A 00 40 01 F4 8F C4 00 90 00 A4 20 23 70 82 00 00 0? ?? ?? ?? 00 00 30 12 }
	condition:
		$1
}

rule file_64_2_0 {
	meta:
		name = "__readall"
		size = 260
		refs = "0000 __gnu_local_gp 0010 __libc_errno 0060 __read"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF C0 27 9C ?? ?? AF B6 00 34 8F 96 ?? ?? 7C 03 E8 3B AF B7 00 38 AF B5 00 30 AF B4 00 2C AF B3 00 28 AF B2 00 24 AF B1 00 20 AF BF 00 3C AF B0 00 1C AF BC 00 10 00 C0 A8 21 00 80 98 21 00 A0 90 21 00 C0 88 21 24 14 FF FF 24 17 00 0B 02 C3 B0 21 02 40 28 21 02 20 30 21 0? ?? ?? ?? 02 60 20 21 10 54 00 12 00 40 80 21 18 40 00 18 00 00 00 00 02 22 88 23 16 20 FF F6 02 42 90 21 02 B1 10 23 8F BF 00 3C 8F B7 00 38 8F B6 00 34 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 40 8E C2 00 00 24 03 00 04 10 43 FF E7 02 40 28 21 10 57 00 08 02 00 10 21 0? ?? ?? ?? 00 00 00 00 10 40 FF EC 02 B1 10 23 8E C2 00 00 14 57 FF E9 02 00 10 21 02 60 20 21 0? ?? ?? ?? 24 05 00 C8 1C 40 FF D8 02 00 10 21 0? ?? ?? ?? 8F BF 00 3C }
	condition:
		$1
}

rule file_64_3_0 {
	meta:
		name = "__readvall"
		size = 608
		refs = "0000 __gnu_local_gp 0010 __libc_errno 0074 __readv 010c memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF B8 27 9C ?? ?? AF B6 00 38 8F 96 ?? ?? AF BE 00 40 7C 03 E8 3B 03 A0 F0 21 AF B5 00 34 AF B4 00 30 AF B3 00 2C AF B2 00 28 AF B1 00 24 AF BF 00 44 AF B7 00 3C AF B0 00 20 00 80 A0 21 AF DC 00 10 00 A0 88 21 00 C0 98 21 24 12 FF FF 02 C3 B0 21 0? ?? ?? ?? 24 15 00 04 8E C2 00 00 14 55 00 71 24 03 00 0B 02 80 20 21 02 20 28 21 0? ?? ?? ?? 02 60 30 21 00 40 80 21 10 52 FF F7 8F DC 00 10 18 40 00 60 00 00 00 00 1A 60 00 0B 00 00 90 21 00 13 20 C0 00 00 30 21 02 26 10 21 8C 42 00 04 24 C6 00 08 14 C4 FF FC 02 42 90 21 02 12 10 2B 14 40 00 0F 24 C2 00 0A 03 C0 E8 21 8F DF 00 44 02 00 10 21 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 48 00 02 10 C2 00 02 10 C0 03 A0 A8 21 03 A2 E8 23 27 A4 00 10 0? ?? ?? ?? 02 20 28 21 8F DC 00 10 7C 03 E8 3B 00 60 20 21 8F 96 ?? ?? 00 40 B8 21 02 00 18 21 24 11 FF FF 02 C4 B0 21 8E E2 00 04 00 62 20 2B 10 80 00 1F 00 00 00 00 8E E4 00 00 00 43 10 23 AE E2 00 04 00 83 18 21 AE E3 00 00 02 80 20 21 02 E0 28 21 0? ?? ?? ?? 02 60 30 21 10 51 00 18 00 40 18 21 1C 40 00 20 00 00 00 00 14 40 00 30 00 00 00 00 02 A0 E8 21 03 C0 E8 21 8F BF 00 44 02 00 10 21 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 48 00 62 18 23 26 73 FF FF 0? ?? ?? ?? 26 F7 00 08 8E C2 00 00 24 04 00 04 10 44 FF E1 02 80 20 21 24 04 00 0B 10 44 00 18 02 80 20 21 00 60 80 21 0? ?? ?? ?? 02 A0 E8 21 02 02 80 21 02 12 10 2B 14 40 FF CD 00 00 00 00 0? ?? ?? ?? 02 A0 E8 21 10 40 FF AC 00 00 00 00 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 8C 42 00 00 24 03 00 0B 14 43 FF A4 00 00 00 00 0? ?? ?? ?? 00 00 80 21 0? ?? ?? ?? 8E C2 00 00 24 05 00 C8 0? ?? ?? ?? AF C3 00 18 1C 40 FF C1 8F C3 00 18 0? ?? ?? ?? 00 60 80 21 }
	condition:
		$1
}

rule file_64_4_0 {
	meta:
		name = "__nscd_unmap"
		size = 88
		refs = "001c __munmap 0030 free 0038 $LC1 003c $LC2 0050 __assert_fail 0040 __PRETTY_FUNCTION__.10554"
	strings:
		$1 = { 8C 82 00 0C 27 BD FF E0 AF B0 00 18 AF BF 00 1C 14 40 00 09 00 80 80 21 8C 84 00 00 0? ?? ?? ?? 8E 05 00 08 8F BF 00 1C 02 00 20 21 8F B0 00 18 0? ?? ?? ?? 27 BD 00 20 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 01 10 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_64_5_0 {
	meta:
		name = "__nscd_get_mapping"
		size = 1012
		refs = "0004 __gnu_local_gp 0048 strlen 005c __libc_errno 0138 __recvmsg 0178 strcmp 018c __fxstat64 01b4 __close 0238 __nscd_unmap 02a8 __mmap 0320 malloc 0378 __munmap 0394 time"
	strings:
		$1 = { 27 BD FE C0 3C 1C ?? ?? 27 9C ?? ?? AF BE 01 38 AF B0 01 18 03 A0 F0 21 00 80 80 21 00 A0 20 21 AF BF 01 3C AF B7 01 34 AF B6 01 30 AF B5 01 2C AF B4 01 28 AF B3 01 24 AF B2 01 20 AF B1 01 1C AF DC 00 18 00 A0 A0 21 0? ?? ?? ?? 00 C0 B0 21 8F DC 00 18 00 40 A8 21 26 A3 00 01 8F 97 ?? ?? 24 42 00 08 AF C3 01 08 00 02 10 C2 7C 03 E8 3B 02 E3 98 21 00 02 10 C0 03 A2 E8 23 8F C6 01 08 8E 62 00 00 02 00 20 21 02 80 28 21 0? ?? ?? ?? AF C2 01 0C 27 A3 00 18 00 40 80 21 AF C3 01 10 04 40 00 46 24 12 FF FF AF C3 00 EC 8F C3 01 08 24 02 00 10 02 00 20 21 AF C3 00 F0 27 C3 01 00 AF C3 00 F4 24 03 00 08 AF C3 00 F8 27 C3 00 EC AF C3 00 C8 24 03 00 02 AF C3 00 CC 27 C3 00 DC AF C3 00 D0 34 03 FF FF AF C3 00 E0 24 05 13 88 24 03 00 01 AF C0 00 C0 AF C0 00 C4 AF C0 00 D8 AF C2 00 D4 AF C3 00 E4 AF C2 00 DC 0? ?? ?? ?? AF D2 00 E8 18 40 00 26 24 11 FF FF 0? ?? ?? ?? 24 12 00 04 8E 63 00 00 14 72 00 07 8F C3 00 D4 02 00 20 21 27 C5 00 C0 0? ?? ?? ?? 3C 06 40 00 10 51 FF F8 8F C3 00 D4 2C 63 00 0C 14 60 00 18 8F C3 00 D0 10 60 00 16 00 00 00 00 8C 64 00 00 24 03 00 10 14 83 00 12 8F C3 01 08 14 62 00 42 8F D1 00 E8 8F C4 01 10 0? ?? ?? ?? 02 80 28 21 14 40 00 9A 24 04 00 03 02 20 28 21 0? ?? ?? ?? 27 C6 00 20 14 40 00 95 8F C2 00 58 18 40 00 8F 8F C3 00 5C AF C2 01 00 0? ?? ?? ?? AF C3 01 04 24 12 FF FF 0? ?? ?? ?? 02 00 20 21 8E C4 00 00 8F C2 01 0C 7C 03 E8 3B 02 E3 B8 21 AE E2 00 00 10 80 00 0B AE D2 00 00 24 82 00 0C C0 43 00 00 24 61 FF FF E0 41 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 24 02 00 01 10 62 00 0F 00 00 00 00 03 C0 E8 21 8F BF 01 3C 02 40 10 21 8F BE 01 38 8F B7 01 34 8F B6 01 30 8F B5 01 2C 8F B4 01 28 8F B3 01 24 8F B2 01 20 8F B1 01 1C 8F B0 01 18 03 E0 00 08 27 BD 01 40 0? ?? ?? ?? 00 00 00 00 03 C0 E8 21 8F DF 01 3C 02 40 10 21 8F BE 01 38 8F B7 01 34 8F B6 01 30 8F B5 01 2C 8F B4 01 28 8F B3 01 24 8F B2 01 20 8F B1 01 1C 8F B0 01 18 03 E0 00 08 27 BD 01 40 26 B5 00 09 14 55 00 5B 8F C4 01 10 0? ?? ?? ?? 02 80 28 21 14 40 00 32 24 12 FF FF 8F C5 01 04 AF B1 00 10 AF A0 00 14 00 00 20 21 24 06 00 01 0? ?? ?? ?? 24 07 00 01 00 40 A8 21 24 02 FF FF 12 A2 00 4C 24 02 00 02 8E A3 00 00 14 62 00 43 24 02 00 78 8E A3 00 04 14 62 00 29 8F C5 01 04 8E A2 00 28 10 40 00 26 00 00 00 00 8E A3 00 0C 10 60 00 27 00 00 00 00 00 02 10 80 8E B4 00 2C 24 45 00 0F 8F C3 01 04 8F C2 01 00 24 04 FF F0 00 A4 28 24 26 93 00 78 02 65 98 21 10 40 00 14 AF C3 01 08 24 04 00 14 0? ?? ?? ?? AF C5 01 14 00 40 90 21 10 40 00 11 8F C5 01 14 8E A2 00 04 AE 55 00 00 AE 53 00 08 00 A2 28 21 02 A5 A8 21 24 02 00 01 AE 55 00 04 AE 54 00 10 AE 42 00 0C 0? ?? ?? ?? 02 20 20 21 0? ?? ?? ?? 00 00 00 00 00 73 10 2B 10 40 FF EC 24 04 00 14 8F C5 01 08 0? ?? ?? ?? 02 A0 20 21 0? ?? ?? ?? 24 12 FF FF 8E B3 00 14 00 00 20 21 8E B2 00 10 0? ?? ?? ?? 00 00 00 00 26 63 01 2C 00 73 28 2B 00 02 27 C3 00 B2 90 21 02 44 28 2B 14 A0 FF F1 8F C5 01 04 10 92 00 03 00 00 00 00 0? ?? ?? ?? 8E A2 00 28 00 62 10 2B 10 40 FF FC 00 00 00 00 0? ?? ?? ?? 8F C5 01 04 14 40 00 03 2C 64 00 78 10 80 FF 6F 00 00 00 00 0? ?? ?? ?? 24 12 FF FF }
	condition:
		$1
}

rule file_64_6_0 {
	meta:
		name = "__nscd_get_map_ref"
		size = 460
		refs = "00bc __nscd_get_mapping 0178 time"
	strings:
		$1 = { 8C C2 00 04 27 BD FF C0 24 03 FF FF AF B2 00 30 AF BF 00 3C AF B4 00 38 AF B3 00 34 AF B1 00 2C AF B0 00 28 10 43 00 47 00 C0 90 21 00 80 A0 21 24 06 00 06 AF A0 00 18 8F A2 00 18 C2 44 00 00 14 82 00 06 24 03 00 00 24 01 00 01 E2 41 00 00 10 20 FF FA 24 03 00 01 00 00 00 0F 10 60 00 34 00 00 00 00 8F A2 00 18 AF A2 00 1C 8F A2 00 1C 14 40 00 31 00 00 00 00 8E 53 00 04 24 02 FF FF 12 62 00 50 00 00 00 00 12 60 00 0B 02 80 20 21 8E 62 00 00 8C 43 00 0C 10 60 00 33 00 00 00 00 8C 44 00 2C 8E 63 00 10 00 64 18 2B 10 60 00 0A 00 00 00 00 02 80 20 21 26 46 00 04 0? ?? ?? ?? AF A7 00 24 00 40 98 21 24 02 FF FF 12 62 00 3D 8F A7 00 24 8E 62 00 00 8C 42 00 08 30 43 00 01 14 60 00 38 AC E2 00 00 26 62 00 0C 00 00 00 0F C0 41 00 00 24 21 00 01 E0 41 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 8F BF 00 3C AE 40 00 00 02 60 10 21 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 40 0? ?? ?? ?? AF A4 00 18 24 C6 FF FF 14 C0 FF BD 00 00 00 00 8F BF 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 24 02 FF FF 03 E0 00 08 27 BD 00 40 8C 51 00 14 00 00 20 21 8C 50 00 10 AF A5 00 20 0? ?? ?? ?? AF A7 00 24 26 24 01 2C 00 91 30 2B 00 02 1F C3 00 D0 80 21 02 03 30 2B 8F A5 00 20 14 C0 FF C6 8F A7 00 24 10 70 00 03 00 00 00 00 0? ?? ?? ?? 8E 62 00 00 00 82 10 2B 14 40 FF C0 02 80 20 21 0? ?? ?? ?? 8E 62 00 00 0? ?? ?? ?? 24 13 FF FF }
	condition:
		$1
}

rule file_64_7_0 {
	meta:
		name = "__nscd_cache_search"
		size = 504
		refs = "0040 __nis_hash 015c memcmp"
	strings:
		$1 = { 27 BD FF B8 AF A5 00 4C AF BE 00 40 00 80 F0 21 8F A4 00 4C AF B0 00 20 00 C0 28 21 00 E0 80 21 AF B6 00 38 AF B5 00 34 AF B3 00 2C AF B1 00 24 AF BF 00 44 AF B7 00 3C AF B4 00 30 AF B2 00 28 0? ?? ?? ?? 00 C0 B0 21 8E 15 00 10 3C 13 CC CC 36 73 CC CD 02 B3 00 19 8E 03 00 00 8C 64 00 28 00 00 98 10 00 13 99 42 00 44 00 1B 00 80 01 F4 00 00 10 10 24 44 00 1E 00 04 20 80 00 64 18 21 24 02 FF FF 8C 71 00 00 12 22 00 4E 26 22 00 1C 02 A2 10 2B 14 40 00 4C 00 00 10 21 8E 17 00 04 02 F1 80 21 32 02 00 03 14 40 00 46 8F A9 00 58 26 73 FF FF 00 00 90 21 25 29 00 18 24 14 FF FF 0? ?? ?? ?? 24 07 00 01 8E 02 00 10 12 22 00 3D 00 00 00 00 12 74 00 3B 00 00 00 00 12 40 00 08 02 F1 18 21 30 64 00 03 14 80 00 36 26 31 00 1C 02 B1 88 2B 16 20 00 33 00 00 00 00 8C 71 00 10 10 54 00 30 00 F2 90 23 24 43 00 1C 02 A3 18 2B 14 60 00 2C 02 E2 80 21 32 02 00 03 14 40 00 29 26 73 FF FF 92 02 00 00 14 5E FF E7 00 00 00 00 8E 02 00 04 14 56 FF E4 00 00 00 00 8E 05 00 08 00 B6 10 21 02 A2 10 2B 14 40 FF DF 8F A4 00 4C 02 E5 28 21 02 C0 30 21 AF A7 00 1C 0? ?? ?? ?? AF A9 00 18 8F A7 00 1C 14 40 FF D7 8F A9 00 18 8E 03 00 14 24 62 00 18 02 A2 10 2B 14 40 FF D2 02 E3 10 21 30 44 00 07 14 80 00 0E 00 00 00 00 90 44 00 12 10 80 FF CC 00 00 00 00 8C 44 00 00 00 64 20 21 02 A4 20 2B 14 80 FF C7 01 23 18 21 02 A3 18 2B 14 60 FF C4 8F BF 00 44 0? ?? ?? ?? 8F BE 00 40 00 00 10 21 8F BF 00 44 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_64_8_0 {
	meta:
		name = "__nscd_open_socket"
		size = 320
		refs = "0000 __gnu_local_gp 0044 __libc_errno 00a4 __read"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF C0 27 9C ?? ?? 2C A3 04 01 00 A0 10 21 AF B1 00 20 AF BF 00 3C AF B7 00 38 AF B6 00 34 AF B5 00 30 AF B4 00 2C AF B3 00 28 AF B2 00 24 AF B0 00 1C AF BC 00 10 10 60 00 3E 8F B1 00 50 8F 96 ?? ?? 7C 03 E8 3B 00 80 28 21 02 C3 A8 21 00 C0 20 21 00 40 30 21 00 E0 90 21 0? ?? ?? ?? 8E B7 00 00 04 40 00 23 00 40 80 21 00 40 20 21 0? ?? ?? ?? 24 05 13 88 24 13 FF FF 1C 40 00 06 24 14 00 04 0? ?? ?? ?? 02 00 20 21 8E A3 00 00 14 74 00 07 00 00 00 00 02 00 20 21 02 40 28 21 0? ?? ?? ?? 02 20 30 21 10 53 FF F8 00 00 00 00 14 51 00 0D 02 00 18 21 8F BF 00 3C 8F B7 00 38 8F B6 00 34 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 00 60 10 21 03 E0 00 08 27 BD 00 40 02 00 20 21 24 02 0F A6 00 00 00 0C 8F BF 00 3C 7C 03 E8 3B 02 C3 10 21 24 03 FF FF AC 57 00 00 8F B6 00 34 8F B7 00 38 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 00 60 10 21 03 E0 00 08 27 BD 00 40 0? ?? ?? ?? 24 03 FF FF }
	condition:
		$1
}

rule file_66_0_0 {
	meta:
		name = "convert_and_print"
		size = 348
		refs = "0038 strlen 0064 realloc 008c __mbsrtowcs 00c8 $LC0 00d0 stderr 00d8 __vfwprintf 0120 fputws_unlocked 011c $LC1"
	strings:
		$1 = { 27 BD FF B0 AF BE 00 48 AF B3 00 34 AF BF 00 4C AF B7 00 44 AF B6 00 40 AF B5 00 3C AF B4 00 38 AF B2 00 30 AF B1 00 2C AF B0 00 28 03 A0 F0 21 10 80 00 2B 00 80 98 21 0? ?? ?? ?? 00 A0 B8 21 24 51 00 01 00 11 90 80 26 56 00 0E 00 16 B0 C2 00 00 80 21 2E 35 07 D0 2E 34 0F A0 0? ?? ?? ?? 00 16 B0 C0 0? ?? ?? ?? 00 00 00 00 10 40 00 29 00 40 80 21 02 00 20 21 27 C5 00 20 02 20 30 21 27 C7 00 18 AF C0 00 18 AF C0 00 1C 0? ?? ?? ?? AF D3 00 20 16 22 00 0A 24 03 FF FF 00 00 10 21 02 14 10 0A 00 50 80 0B 02 00 20 21 12 A0 FF ED 02 40 28 21 03 B6 E8 23 0? ?? ?? ?? 27 B0 00 10 14 43 00 03 3C 02 ?? ?? 3C 10 ?? ?? 26 10 ?? ?? 8C 44 ?? ?? 02 00 28 21 0? ?? ?? ?? 02 E0 30 21 03 C0 E8 21 8F BF 00 4C 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 3C 02 ?? ?? 8C 45 ?? ?? 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 03 C0 E8 21 8F BF 00 4C 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_66_1_0 {
	meta:
		name = "vwarnx"
		size = 244
		refs = "0008 stderr 002c __progname 003c __fwprintf 0034 $LC2 0068 putwc_unlocked 0080 fprintf 0078 $LC3 0094 vfprintf 00ec __overflow"
	strings:
		$1 = { 27 BD FF D8 AF B0 00 18 3C 10 ?? ?? 8E 02 ?? ?? AF B2 00 20 AF B1 00 1C 8C 43 00 6C AF BF 00 24 00 80 88 21 18 60 00 12 00 A0 90 21 3C 03 ?? ?? 8C 66 ?? ?? 3C 05 ?? ?? 00 40 20 21 0? ?? ?? ?? 24 A5 ?? ?? 02 20 20 21 0? ?? ?? ?? 02 40 28 21 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8E 05 ?? ?? 8F B0 00 18 24 04 00 0A 0? ?? ?? ?? 27 BD 00 28 3C 03 ?? ?? 8C 66 ?? ?? 3C 05 ?? ?? 00 40 20 21 0? ?? ?? ?? 24 A5 ?? ?? 12 20 00 04 8E 04 ?? ?? 02 20 28 21 0? ?? ?? ?? 02 40 30 21 8E 04 ?? ?? 8C 82 00 14 8C 83 00 18 00 43 18 2B 10 60 00 0A 24 43 00 01 AC 83 00 14 24 03 00 0A A0 43 00 00 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 24 05 00 0A 0? ?? ?? ?? 27 BD 00 28 }
	condition:
		$1
}

rule file_66_2_0 {
	meta:
		name = "vwarn"
		size = 336
		refs = "0008 stderr 000c __gnu_local_gp 0020 __libc_errno 0054 __progname 0064 __fwprintf 005c $LC2 0088 fputws_unlocked 0084 $LC4 00bc $LC5 00dc fprintf 00d4 $LC3 00f4 vfprintf 0100 $LC6 010c fwrite_unlocked 0140 $LC7"
	strings:
		$1 = { 27 BD FF D0 AF B0 00 18 3C 10 ?? ?? 3C 1C ?? ?? 8E 02 ?? ?? 27 9C ?? ?? 7C 03 E8 3B AF B1 00 1C 8F 91 ?? ?? 00 60 30 21 8C 43 00 6C 02 26 38 21 AF B4 00 28 AF B3 00 24 AF B2 00 20 AF BF 00 2C AF BC 00 10 00 80 90 21 00 A0 A0 21 18 60 00 1F 8C F3 00 00 3C 03 ?? ?? 8C 66 ?? ?? 3C 05 ?? ?? 00 40 20 21 0? ?? ?? ?? 24 A5 ?? ?? 12 40 00 09 8F BC 00 10 02 40 20 21 0? ?? ?? ?? 02 80 28 21 8E 05 ?? ?? 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 8F BC 00 10 7C 03 E8 3B 02 23 88 21 AE 33 00 00 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8E 04 ?? ?? 8F B0 00 18 3C 05 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 27 BD 00 30 3C 03 ?? ?? 8C 66 ?? ?? 3C 05 ?? ?? 00 40 20 21 0? ?? ?? ?? 24 A5 ?? ?? 12 40 00 0C 8F BC 00 10 8E 04 ?? ?? 02 40 28 21 0? ?? ?? ?? 02 80 30 21 8E 07 ?? ?? 3C 04 ?? ?? 24 84 ?? ?? 24 05 00 01 0? ?? ?? ?? 24 06 00 02 8F BC 00 10 7C 03 E8 3B 02 23 88 21 AE 33 00 00 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8E 04 ?? ?? 8F B0 00 18 3C 05 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 27 BD 00 30 }
	condition:
		$1
}

rule file_66_3_0 {
	meta:
		name = "warn"
		size = 48
		refs = "001c vwarn"
		altNames = "warnx"
	strings:
		$1 = { 27 BD FF D8 27 A2 00 2C AF A5 00 2C 00 40 28 21 AF BF 00 24 AF A6 00 30 AF A7 00 34 0? ?? ?? ?? AF A2 00 18 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_66_5_0 {
	meta:
		name = "verr"
		size = 36
		refs = "0014 vwarn 001c exit"
	strings:
		$1 = { 27 BD FF E0 AF B0 00 18 00 80 80 21 00 A0 20 21 AF BF 00 1C 0? ?? ?? ?? 00 C0 28 21 0? ?? ?? ?? 02 00 20 21 }
	condition:
		$1
}

rule file_66_6_0 {
	meta:
		name = "verrx"
		size = 36
		refs = "0014 vwarnx 001c exit"
	strings:
		$1 = { 27 BD FF E0 AF B0 00 18 00 80 80 21 00 A0 20 21 AF BF 00 1C 0? ?? ?? ?? 00 C0 28 21 0? ?? ?? ?? 02 00 20 21 }
	condition:
		$1
}

rule file_66_7_0 {
	meta:
		name = "err"
		size = 32
		refs = "0018 verr"
		altNames = "errx"
	strings:
		$1 = { 27 BD FF D8 27 A2 00 30 AF A6 00 30 00 40 30 21 AF BF 00 24 AF A7 00 34 0? ?? ?? ?? AF A2 00 18 }
	condition:
		$1
}

rule file_202_3_0 {
	meta:
		name = "_IO_obstack_printf"
		size = 44
		refs = "0018 _IO_obstack_vprintf"
	strings:
		$1 = { 27 BD FF D8 27 A2 00 30 AF A6 00 30 00 40 30 21 AF BF 00 24 AF A7 00 34 0? ?? ?? ?? AF A2 00 18 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_1395_0_0 {
	meta:
		name = "___asprintf"
		size = 44
		refs = "0018 _IO_vasprintf"
	strings:
		$1 = { 27 BD FF D8 27 A2 00 30 AF A6 00 30 00 40 30 21 AF BF 00 24 AF A7 00 34 0? ?? ?? ?? AF A2 00 18 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_1258_0_0 {
	meta:
		name = "__dprintf"
		size = 44
		refs = "0018 _IO_vdprintf"
	strings:
		$1 = { 27 BD FF D8 27 A2 00 30 AF A6 00 30 00 40 30 21 AF BF 00 24 AF A7 00 34 0? ?? ?? ?? AF A2 00 18 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_876_0_0 {
	meta:
		name = "__fprintf"
		size = 44
		refs = "0018 vfprintf"
	strings:
		$1 = { 27 BD FF D8 27 A2 00 30 AF A6 00 30 00 40 30 21 AF BF 00 24 AF A7 00 34 0? ?? ?? ?? AF A2 00 18 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_1272_0_0 {
	meta:
		name = "__fscanf"
		size = 44
		refs = "0018 __vfscanf"
	strings:
		$1 = { 27 BD FF D8 27 A2 00 30 AF A6 00 30 00 40 30 21 AF BF 00 24 AF A7 00 34 0? ?? ?? ?? AF A2 00 18 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_860_0_0 {
	meta:
		name = "__fwprintf"
		size = 44
		refs = "0018 __vfwprintf"
	strings:
		$1 = { 27 BD FF D8 27 A2 00 30 AF A6 00 30 00 40 30 21 AF BF 00 24 AF A7 00 34 0? ?? ?? ?? AF A2 00 18 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_889_0_0 {
	meta:
		name = "__fwscanf"
		size = 44
		refs = "0018 __vfwscanf"
	strings:
		$1 = { 27 BD FF D8 27 A2 00 30 AF A6 00 30 00 40 30 21 AF BF 00 24 AF A7 00 34 0? ?? ?? ?? AF A2 00 18 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_545_0_0 {
	meta:
		name = "__isoc99_sscanf"
		size = 44
		refs = "0018 __isoc99_vsscanf"
	strings:
		$1 = { 27 BD FF D8 27 A2 00 30 AF A6 00 30 00 40 30 21 AF BF 00 24 AF A7 00 34 0? ?? ?? ?? AF A2 00 18 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_1056_0_0 {
	meta:
		name = "__isoc99_swscanf"
		size = 44
		refs = "0018 __isoc99_vswscanf"
	strings:
		$1 = { 27 BD FF D8 27 A2 00 30 AF A6 00 30 00 40 30 21 AF BF 00 24 AF A7 00 34 0? ?? ?? ?? AF A2 00 18 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_619_0_0 {
	meta:
		name = "__sprintf"
		size = 44
		refs = "0018 _IO_vsprintf"
	strings:
		$1 = { 27 BD FF D8 27 A2 00 30 AF A6 00 30 00 40 30 21 AF BF 00 24 AF A7 00 34 0? ?? ?? ?? AF A2 00 18 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_343_0_0 {
	meta:
		name = "__sscanf"
		size = 44
		refs = "0018 _IO_vsscanf"
	strings:
		$1 = { 27 BD FF D8 27 A2 00 30 AF A6 00 30 00 40 30 21 AF BF 00 24 AF A7 00 34 0? ?? ?? ?? AF A2 00 18 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_859_0_0 {
	meta:
		name = "__swscanf"
		size = 44
		refs = "0018 vswscanf"
	strings:
		$1 = { 27 BD FF D8 27 A2 00 30 AF A6 00 30 00 40 30 21 AF BF 00 24 AF A7 00 34 0? ?? ?? ?? AF A2 00 18 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "scandir64"
		size = 56
		refs = "0024 scandirat64"
		altNames = "scandir"
	strings:
		$1 = { 27 BD FF D8 00 80 40 21 00 A0 18 21 00 C0 10 21 24 04 FF 9C AF A7 00 10 01 00 28 21 00 60 30 21 AF BF 00 24 0? ?? ?? ?? 00 40 38 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_68_0_0 {
	meta:
		name = "ether_ntohost"
		size = 368
		refs = "0010 __gnu_local_gp 0068 __libc_errno 0064 $LC0 00a8 __nss_next2 00f0 strcpy 0138 __nss_ethers_lookup"
	strings:
		$1 = { 27 BD FB A8 AF B0 04 38 3C 10 ?? ?? 8E 02 ?? ?? 3C 1C ?? ?? 27 9C ?? ?? AF B6 04 50 AF B1 04 3C AF BF 04 54 AF B5 04 4C AF B4 04 48 AF B3 04 44 AF B2 04 40 AF BC 00 18 00 80 B0 21 10 40 00 39 00 A0 88 21 3C 03 ?? ?? 8C 79 ?? ?? 24 03 FF FF AF A2 04 30 10 43 00 3E AF B9 04 2C 27 B3 04 30 27 B2 04 2C 3C 14 ?? ?? 8F 95 ?? ?? 7C 03 E8 3B 26 94 ?? ?? 02 A3 A8 21 02 20 20 21 27 A5 04 20 27 A6 00 20 24 07 04 00 03 20 F8 09 AF B5 00 10 AF A2 00 10 AF A0 00 14 02 60 20 21 02 80 28 21 00 00 30 21 02 40 38 21 0? ?? ?? ?? 00 40 80 21 10 40 FF F1 8F B9 04 2C 24 03 00 01 12 03 00 0B 24 02 FF FF 8F BF 04 54 8F B6 04 50 8F B5 04 4C 8F B4 04 48 8F B3 04 44 8F B2 04 40 8F B1 04 3C 8F B0 04 38 03 E0 00 08 27 BD 04 58 8F A5 04 20 0? ?? ?? ?? 02 C0 20 21 8F BF 04 54 8F B6 04 50 8F B5 04 4C 8F B4 04 48 8F B3 04 44 8F B2 04 40 8F B1 04 3C 8F B0 04 38 00 00 10 21 03 E0 00 08 27 BD 04 58 27 B3 04 30 27 B2 04 2C 3C 14 ?? ?? 02 60 20 21 26 85 ?? ?? 0? ?? ?? ?? 02 40 30 21 10 40 00 05 8F BC 00 18 24 02 FF FF AE 02 ?? ?? 0? ?? ?? ?? 24 02 FF FF 8F B9 04 2C 3C 02 ?? ?? AC 59 ?? ?? 8F A2 04 30 0? ?? ?? ?? AE 02 ?? ?? }
	condition:
		$1
}

rule file_69_0_0 {
	meta:
		name = "clnttcp_geterr"
		size = 32
	strings:
		$1 = { 8C 82 00 08 8C 44 00 24 8C 43 00 28 8C 42 00 2C AC A4 00 00 AC A3 00 04 03 E0 00 08 AC A2 00 08 }
	condition:
		$1
}

rule file_69_1_0 {
	meta:
		name = "clnttcp_freeres"
		size = 28
	strings:
		$1 = { 8C 84 00 08 24 02 00 02 00 A0 C8 21 AC 82 00 4C 00 C0 28 21 03 20 00 08 24 84 00 4C }
	condition:
		$1
}

rule file_69_3_0 {
	meta:
		name = "clnttcp_destroy"
		size = 104
		refs = "0038 free 0058 __close"
	strings:
		$1 = { 27 BD FF D8 AF B0 00 1C 8C 90 00 08 AF B1 00 20 AF BF 00 24 8E 02 00 04 14 40 00 0F 00 80 88 21 8E 02 00 50 8C 59 00 1C 13 20 00 03 00 00 00 00 03 20 F8 09 26 04 00 4C 0? ?? ?? ?? 02 00 20 21 8F BF 00 24 8F B0 00 1C 02 20 20 21 8F B1 00 20 0? ?? ?? ?? 27 BD 00 28 0? ?? ?? ?? 8E 04 00 00 0? ?? ?? ?? 8E 02 00 50 }
	condition:
		$1
}

rule file_69_4_0 {
	meta:
		name = "clnttcp_control"
		size = 348
	strings:
		$1 = { 2C A2 00 10 27 BD FF F0 10 40 00 52 8C 83 00 08 3C 02 ?? ?? 24 42 ?? ?? 00 05 28 80 00 45 28 21 8C A2 00 00 00 40 00 08 00 00 00 00 88 C4 00 00 24 65 00 3C 24 02 00 01 98 C4 00 03 A8 64 00 3C AF A4 00 0C AF A4 00 08 B8 A4 00 03 03 E0 00 08 27 BD 00 10 8C C2 00 04 8C C4 00 00 AC 62 00 0C 24 02 00 01 AC 64 00 08 0? ?? ?? ?? AC 62 00 10 8C 64 00 08 8C 63 00 0C 24 02 00 01 AC C4 00 00 0? ?? ?? ?? AC C3 00 04 8C 67 00 14 8C 65 00 18 8C 64 00 1C 8C 63 00 20 24 02 00 01 AC C7 00 00 AC C5 00 04 AC C4 00 08 0? ?? ?? ?? AC C3 00 0C 8C 63 00 00 24 02 00 01 0? ?? ?? ?? AC C3 00 00 24 02 00 01 0? ?? ?? ?? AC 62 00 04 AC 60 00 04 0? ?? ?? ?? 24 02 00 01 24 63 00 30 88 64 00 00 24 02 00 01 98 64 00 03 A8 C4 00 00 B8 C4 00 03 03 E0 00 08 27 BD 00 10 88 C5 00 00 24 64 00 30 24 02 00 01 98 C5 00 03 24 A6 FF FF A8 66 00 30 AF A5 00 0C AF A6 00 08 0? ?? ?? ?? B8 86 00 03 0? ?? ?? ?? 24 63 00 40 88 C4 00 00 24 65 00 40 24 02 00 01 98 C4 00 03 A8 64 00 40 AF A4 00 0C AF A4 00 08 0? ?? ?? ?? B8 A4 00 03 0? ?? ?? ?? 24 63 00 3C 0? ?? ?? ?? 00 00 10 21 }
	condition:
		$1
}

rule file_69_5_0 {
	meta:
		name = "clnttcp_call"
		size = 760
		refs = "006c xdr_void 00fc xdrrec_endofrecord 0128 _null_auth 014c xdrrec_skiprecord 0160 xdr_replymsg 01b4 _seterr_reply 02b8 xdr_opaque_auth"
	strings:
		$1 = { 27 BD FF 88 AF B0 00 50 8C 90 00 08 AF B5 00 64 AF B1 00 54 8E 02 00 10 AF BF 00 74 AF BE 00 70 AF B7 00 6C AF B6 00 68 AF B4 00 60 AF B3 00 5C AF B2 00 58 00 80 A8 21 AF A5 00 7C AF A6 00 80 AF A7 00 84 14 40 00 05 26 11 00 4C 8F A2 00 90 AE 02 00 08 8F A2 00 94 AE 02 00 0C 8F B9 00 88 13 20 00 75 24 16 00 01 24 03 00 03 3C 13 ?? ?? 26 17 00 30 AF A3 00 48 3C 12 ?? ?? 26 73 ?? ?? 8E 02 00 50 8E 14 00 30 8E 06 00 48 8C 59 00 0C 26 94 FF FF AE 00 00 4C AE 00 00 24 AE 14 00 30 02 20 20 21 03 20 F8 09 02 E0 28 21 10 40 00 68 02 20 20 21 8E 02 00 50 8C 59 00 04 03 20 F8 09 27 A5 00 7C 10 40 00 62 00 00 00 00 8E A4 00 00 8C 82 00 20 8C 59 00 04 03 20 F8 09 02 20 28 21 10 40 00 5B 8F A5 00 84 8F B9 00 80 03 20 F8 09 02 20 20 21 10 40 00 56 02 20 20 21 0? ?? ?? ?? 02 C0 28 21 10 40 00 5B 24 02 00 03 12 C0 00 1B 00 00 10 21 8E 02 00 08 10 40 00 42 00 00 00 00 24 02 00 01 AE 02 00 4C 26 5E ?? ?? 8F C5 00 04 8E 46 ?? ?? 8F C2 00 08 02 20 20 21 AF A5 00 28 AF A6 00 24 AF A2 00 2C AF A0 00 34 0? ?? ?? ?? AF B3 00 38 02 20 20 21 10 40 00 25 27 A5 00 18 0? ?? ?? ?? 00 00 00 00 14 40 00 10 8F A2 00 18 8E 02 00 24 10 40 FF ED 00 00 00 00 8F BF 00 74 8F BE 00 70 8F B7 00 6C 8F B6 00 68 8F B5 00 64 8F B4 00 60 8F B3 00 5C 8F B2 00 58 8F B1 00 54 8F B0 00 50 03 E0 00 08 27 BD 00 78 16 82 FF DF 27 A4 00 18 0? ?? ?? ?? 26 05 00 24 8E 02 00 24 10 40 00 2E 8F A3 00 48 24 63 FF FF 10 60 FF EB AF A3 00 48 8E A4 00 00 8C 82 00 20 8C 59 00 0C 03 20 F8 09 00 00 00 00 14 40 FF A5 00 00 00 00 8E 02 00 24 8F BF 00 74 8F BE 00 70 8F B7 00 6C 8F B6 00 68 8F B5 00 64 8F B4 00 60 8F B3 00 5C 8F B2 00 58 8F B1 00 54 8F B0 00 50 03 E0 00 08 27 BD 00 78 8E 02 00 0C 14 40 FF BD 24 02 00 05 0? ?? ?? ?? AE 02 00 24 8E 02 00 08 14 40 FF 8B 24 03 00 03 8E 16 00 0C 0? ?? ?? ?? 00 16 B0 2B 8E 02 00 24 14 40 00 03 02 20 20 21 24 02 00 01 AE 02 00 24 0? ?? ?? ?? 24 05 00 01 0? ?? ?? ?? 8E 02 00 24 0? ?? ?? ?? AE 02 00 24 8E A4 00 00 8C 82 00 20 8C 59 00 08 03 20 F8 09 27 A5 00 24 14 40 00 0D 24 02 00 07 AE 02 00 24 24 02 00 06 AE 02 00 28 8F A2 00 28 10 40 FF D1 24 02 00 02 AE 02 00 4C 02 20 20 21 0? ?? ?? ?? 27 A5 00 24 0? ?? ?? ?? 8E 02 00 24 8F A5 00 8C 8F B9 00 88 03 20 F8 09 02 20 20 21 14 40 FF F3 8F A2 00 28 8E 02 00 24 14 40 FF F0 8F A2 00 28 24 02 00 02 0? ?? ?? ?? AE 02 00 24 }
	condition:
		$1
}

rule file_69_6_0 {
	meta:
		name = "writetcp"
		size = 212
		refs = "0000 __gnu_local_gp 0058 __write 0074 __libc_errno"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF D0 27 9C ?? ?? AF B4 00 28 AF B3 00 24 AF B2 00 20 AF B1 00 1C AF B0 00 18 AF BF 00 2C AF BC 00 10 00 C0 A0 21 00 80 90 21 00 A0 88 21 00 C0 80 21 1C C0 00 05 24 13 FF FF 0? ?? ?? ?? 8F BF 00 2C 1A 00 00 19 02 22 88 21 8E 44 00 00 02 00 30 21 0? ?? ?? ?? 02 20 28 21 02 02 80 23 14 53 FF F8 8F BC 00 10 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 8C 43 00 00 24 02 00 03 AE 42 00 24 AE 43 00 28 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 24 02 FF FF 03 E0 00 08 27 BD 00 30 8F BF 00 2C 02 80 10 21 8F B3 00 24 8F B4 00 28 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_69_7_0 {
	meta:
		name = "readtcp"
		size = 400
		refs = "0000 __gnu_local_gp 006c __libc_errno 00b0 __poll 0100 __read"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF C0 27 9C ?? ?? 8C 83 00 08 AF B1 00 24 AF B0 00 20 AF BF 00 3C 00 80 80 21 AF B6 00 38 AF B5 00 34 AF B4 00 30 AF B3 00 2C AF B2 00 28 AF BC 00 10 00 C0 88 21 8C 84 00 0C 10 C0 00 24 00 00 10 21 00 A0 A0 21 3C 05 10 62 24 A5 4D D3 00 85 00 18 00 03 91 C0 00 03 10 80 02 42 10 23 00 43 18 21 8E 07 00 00 8F 96 ?? ?? 00 03 10 C0 00 04 27 C3 7C 03 E8 3B 00 60 30 21 24 03 00 01 AF A7 00 18 A7 A3 00 1C 24 13 FF FF 02 C6 B0 21 24 15 00 04 00 00 28 10 00 05 29 83 00 A4 20 23 00 44 90 21 27 A4 00 18 24 05 00 01 0? ?? ?? ?? 02 40 30 21 10 53 00 1E 00 00 00 00 14 40 00 0E 02 80 28 21 24 02 00 05 AE 02 00 24 24 02 FF FF 8F BF 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 40 8E 04 00 00 0? ?? ?? ?? 02 20 30 21 24 03 FF FF 10 43 00 0E 8F BC 00 10 14 40 FF F0 8F BF 00 3C 24 02 00 83 AE 02 00 28 24 02 00 04 AE 02 00 24 0? ?? ?? ?? 24 02 FF FF 8E C3 00 00 10 75 FF DC 27 A4 00 18 0? ?? ?? ?? AE 03 00 28 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 64 20 21 8C 83 00 00 AE 03 00 28 8F BF 00 3C 24 04 00 04 AE 04 00 24 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_69_8_0 {
	meta:
		name = "clnttcp_create"
		size = 756
		refs = "0004 __gnu_local_gp 003c malloc 00a8 _create_xid 00d4 xdrmem_create 00e0 xdr_callhdr 0140 xdrrec_create 0154 authnone_create 0190 pmap_getport 01b4 __socket 01c4 bindresvport 01d8 __connect 0200 free 023c __close 024c __rpc_thread_createerr 0254 _libc_intl_domainname 0258 $LC0 0268 __dcgettext 0270 $LC1 0274 __func__.12981 0284 __fxprintf 02b0 __libc_errno"
	strings:
		$1 = { 27 BD FF 90 3C 1C ?? ?? 27 9C ?? ?? AF B1 00 58 00 80 88 21 24 04 00 0C AF BF 00 6C AF B5 00 68 AF B4 00 64 AF B3 00 60 AF B2 00 5C AF B0 00 54 AF BC 00 18 00 A0 A8 21 00 C0 A0 21 0? ?? ?? ?? 00 E0 98 21 24 04 00 64 0? ?? ?? ?? 00 40 90 21 12 40 00 7E 00 40 80 21 10 40 00 7C 00 00 00 00 96 22 00 02 10 40 00 48 02 20 20 21 8E 62 00 00 04 40 00 4F 24 04 00 02 AE 00 00 04 8E 23 00 0C 8E 26 00 00 8E 25 00 04 8E 24 00 08 AE 03 00 20 26 11 00 4C AE 06 00 14 AE 05 00 18 AE 04 00 1C AE 02 00 00 AE 00 00 0C 0? ?? ?? ?? AE 00 00 10 AF A2 00 20 02 20 20 21 24 02 00 02 26 05 00 30 24 06 00 18 00 00 38 21 AF A2 00 28 AF A0 00 24 AF B5 00 2C 0? ?? ?? ?? AF B4 00 30 02 20 20 21 0? ?? ?? ?? 27 A5 00 20 10 40 00 42 00 00 00 00 8E 02 00 50 8C 59 00 10 03 20 F8 09 02 20 20 21 8E 03 00 50 AE 02 00 48 8C 79 00 1C 13 20 00 04 3C 02 ?? ?? 03 20 F8 09 02 20 20 21 3C 02 ?? ?? 24 42 ?? ?? 8F A5 00 80 8F A6 00 84 AF A2 00 10 3C 02 ?? ?? 24 42 ?? ?? 02 20 20 21 02 00 38 21 0? ?? ?? ?? AF A2 00 14 3C 02 ?? ?? 24 42 ?? ?? AE 42 00 04 0? ?? ?? ?? AE 50 00 08 AE 42 00 00 02 40 10 21 8F BF 00 6C 8F B5 00 68 8F B4 00 64 8F B3 00 60 8F B2 00 5C 8F B1 00 58 8F B0 00 54 03 E0 00 08 27 BD 00 70 02 A0 28 21 02 80 30 21 0? ?? ?? ?? 24 07 00 06 10 40 00 50 00 00 00 00 A6 22 00 02 8E 62 00 00 04 41 FF B3 24 04 00 02 24 05 00 02 0? ?? ?? ?? 24 06 00 06 00 40 20 21 AE 62 00 00 0? ?? ?? ?? 00 00 28 21 8E 64 00 00 04 80 00 32 02 20 28 21 0? ?? ?? ?? 24 06 00 10 04 40 00 2E 24 02 00 01 AE 02 00 04 0? ?? ?? ?? 8E 62 00 00 8E 02 00 04 14 40 00 0F 00 00 00 00 0? ?? ?? ?? 02 00 20 21 0? ?? ?? ?? 02 40 20 21 8F BF 00 6C 8F B5 00 68 8F B4 00 64 8F B3 00 60 8F B2 00 5C 8F B1 00 58 8F B0 00 54 00 00 10 21 03 E0 00 08 27 BD 00 70 8E 64 00 00 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 00 00 00 00 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 05 0? ?? ?? ?? 00 40 88 21 3C 05 ?? ?? 3C 06 ?? ?? 00 00 20 21 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 00 40 38 21 24 02 00 0C AE 22 00 00 0? ?? ?? ?? AE 22 00 08 0? ?? ?? ?? 00 00 00 00 8F BC 00 18 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 64 20 21 8C 83 00 00 24 04 00 0C AC 44 00 00 AC 43 00 08 8E 64 00 00 04 81 FF DB 00 00 00 00 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 02 00 20 21 0? ?? ?? ?? 02 40 20 21 0? ?? ?? ?? 00 00 10 21 }
	condition:
		$1
}

rule file_70_0_0 {
	meta:
		name = "__libc_siglongjmp"
		size = 76
		refs = "0014 _longjmp_unwind 0030 __longjmp 003c __sigprocmask"
	strings:
		$1 = { 27 BD FF D8 AF B0 00 1C 00 80 80 21 AF B1 00 20 AF BF 00 24 0? ?? ?? ?? 00 A0 88 21 8E 02 00 68 14 40 00 05 24 04 00 03 24 05 00 01 02 00 20 21 0? ?? ?? ?? 02 31 28 0B 26 05 00 6C 0? ?? ?? ?? 00 00 30 21 0? ?? ?? ?? 24 05 00 01 }
	condition:
		$1
}

rule file_1406_0_0 {
	meta:
		name = "__longjmp_chk"
		size = 76
		refs = "0014 _longjmp_unwind 0030 ____longjmp_chk 003c __sigprocmask"
	strings:
		$1 = { 27 BD FF D8 AF B0 00 1C 00 80 80 21 AF B1 00 20 AF BF 00 24 0? ?? ?? ?? 00 A0 88 21 8E 02 00 68 14 40 00 05 24 04 00 03 24 05 00 01 02 00 20 21 0? ?? ?? ?? 02 31 28 0B 26 05 00 6C 0? ?? ?? ?? 00 00 30 21 0? ?? ?? ?? 24 05 00 01 }
	condition:
		$1
}

rule file_72_0_0 {
	meta:
		name = "__vwprintf"
		size = 24
		refs = "0000 stdout 0010 __vfwprintf"
	strings:
		$1 = { 3C 03 ?? ?? 00 80 10 21 8C 64 ?? ?? 00 A0 30 21 0? ?? ?? ?? 00 40 28 21 }
	condition:
		$1
}

rule file_1265_0_0 {
	meta:
		name = "_IO_vscanf"
		size = 28
		refs = "0000 _IO_stdin 0014 _IO_vfscanf"
	strings:
		$1 = { 3C 03 ?? ?? 00 80 10 21 8C 64 ?? ?? 00 A0 30 21 00 00 38 21 0? ?? ?? ?? 00 40 28 21 }
	condition:
		$1
}

rule file_816_0_0 {
	meta:
		name = "__vprintf"
		size = 24
		refs = "0000 stdout 0010 vfprintf"
	strings:
		$1 = { 3C 03 ?? ?? 00 80 10 21 8C 64 ?? ?? 00 A0 30 21 0? ?? ?? ?? 00 40 28 21 }
	condition:
		$1
}

rule file_1459_0_0 {
	meta:
		name = "__vwscanf"
		size = 28
		refs = "0000 _IO_stdin 0014 _IO_vfwscanf"
	strings:
		$1 = { 3C 03 ?? ?? 00 80 10 21 8C 64 ?? ?? 00 A0 30 21 00 00 38 21 0? ?? ?? ?? 00 40 28 21 }
	condition:
		$1
}

rule file_73_0_0 {
	meta:
		name = "__link"
		size = 28
	strings:
		$1 = { 24 02 0F A9 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_74_0_0 {
	meta:
		name = "getpass"
		size = 504
		refs = "0004 $LC1 0010 $LC0 002c _IO_new_fopen 0050 fileno 005c __tcgetattr 006c $LC2 0078 __fxprintf 0080 fflush_unlocked 0098 __getline 00d0 stdin 00e0 _IO_new_fclose 016c tcsetattr 0184 $LC3 01c4 stderr 01f0 _Unwind_Resume"
	strings:
		$1 = { 27 BD FF 68 3C 05 ?? ?? AF B1 00 84 00 80 88 21 3C 04 ?? ?? 24 A5 ?? ?? 24 84 ?? ?? AF B0 00 80 AF BF 00 94 AF B4 00 90 AF B3 00 8C 0? ?? ?? ?? AF B2 00 88 10 40 00 61 00 40 80 21 8C 42 00 00 02 00 90 21 02 00 A0 21 34 42 80 00 AE 02 00 00 0? ?? ?? ?? 02 00 20 21 00 40 20 21 0? ?? ?? ?? 27 A5 00 18 10 40 00 29 00 00 98 21 3C 05 ?? ?? 02 40 20 21 24 A5 ?? ?? 0? ?? ?? ?? 02 20 30 21 0? ?? ?? ?? 02 40 20 21 3C 11 ?? ?? 3C 05 ?? ?? 26 24 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 02 00 30 21 8E 23 ?? ?? 10 60 00 08 00 00 00 00 04 40 00 41 24 42 FF FF 00 62 18 21 80 64 00 00 24 02 00 0A 10 82 00 2E 00 00 00 00 16 60 00 32 00 00 00 00 3C 02 ?? ?? 8C 42 ?? ?? 12 02 00 04 8F BF 00 94 0? ?? ?? ?? 02 00 20 21 8F BF 00 94 8E 22 ?? ?? 8F B4 00 90 8F B3 00 8C 8F B2 00 88 8F B1 00 84 8F B0 00 80 03 E0 00 08 27 BD 00 98 27 A2 00 18 27 A3 00 4C 27 A4 00 48 8C 48 00 00 8C 47 00 04 8C 46 00 08 8C 45 00 0C 24 42 00 10 AC 68 00 00 AC 67 00 04 AC 66 00 08 AC 65 00 0C 14 44 FF F6 24 63 00 10 8C 42 00 00 02 00 20 21 AC 62 00 00 8F A3 00 24 24 02 FF F6 00 62 10 24 0? ?? ?? ?? AF A2 00 24 00 40 20 21 24 05 54 10 0? ?? ?? ?? 27 A6 00 18 0? ?? ?? ?? 2C 53 00 01 12 60 FF D4 A0 60 00 00 3C 05 ?? ?? 02 40 20 21 0? ?? ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 02 00 20 21 00 40 20 21 24 05 54 10 0? ?? ?? ?? 27 A6 00 4C 0? ?? ?? ?? 3C 02 ?? ?? 0? ?? ?? ?? A0 60 00 00 3C 02 ?? ?? 8C 50 ?? ?? 3C 02 ?? ?? 8C 52 ?? ?? 00 00 10 21 02 12 A0 26 02 14 10 0A 0? ?? ?? ?? 00 40 A0 21 12 80 00 03 00 80 80 21 0? ?? ?? ?? 02 80 20 21 0? ?? ?? ?? 02 00 20 21 }
	condition:
		$1
}

rule file_75_0_0 {
	meta:
		name = "__isoc99_fscanf"
		size = 480
		refs = "0074 __lll_lock_wait_private 00b4 _IO_vfscanf 018c _Unwind_Resume"
	strings:
		$1 = { 8C 82 00 00 27 BD FF D0 AF B1 00 24 30 42 80 00 AF B0 00 20 AF BF 00 2C AF B2 00 28 00 80 80 21 AF A6 00 38 AF A7 00 3C 14 40 00 1A 00 A0 88 21 7C 03 E8 3B 8C 84 00 48 24 72 8B 70 8C 82 00 08 10 52 00 11 00 00 00 00 AF A0 00 18 C0 83 00 00 14 60 00 06 24 02 00 00 24 01 00 01 E0 81 00 00 10 20 FF FA 24 02 00 01 00 00 00 0F 14 40 00 03 00 00 00 00 0? ?? ?? ?? AF A3 00 18 8E 02 00 48 00 40 20 21 AC 52 00 08 8C 82 00 04 24 42 00 01 AC 82 00 04 8E 03 00 3C 27 A2 00 38 02 00 20 21 34 63 00 10 AE 03 00 3C 02 20 28 21 00 40 30 21 00 00 38 21 0? ?? ?? ?? AF A2 00 18 8E 05 00 3C 8E 03 00 00 24 04 FF EB 00 A4 20 24 30 63 80 00 00 40 88 21 14 60 00 06 AE 04 00 3C 8E 04 00 48 8C 82 00 04 24 42 FF FF 10 40 00 08 AC 82 00 04 8F BF 00 2C 02 20 10 21 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 30 AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF F0 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 2C 8E 05 00 3C 8E 02 00 00 24 03 FF EB 00 A3 18 24 30 42 80 00 00 80 88 21 14 40 00 06 AE 03 00 3C 8E 04 00 48 8C 83 00 04 24 63 FF FF 10 60 00 03 AC 83 00 04 0? ?? ?? ?? 02 20 20 21 AC 80 00 08 00 00 00 0F C0 83 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 63 00 02 14 60 FF F5 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_820_0_0 {
	meta:
		name = "__isoc99_fwscanf"
		size = 480
		refs = "0074 __lll_lock_wait_private 00b4 _IO_vfwscanf 018c _Unwind_Resume"
	strings:
		$1 = { 8C 82 00 00 27 BD FF D0 AF B1 00 24 30 42 80 00 AF B0 00 20 AF BF 00 2C AF B2 00 28 00 80 80 21 AF A6 00 38 AF A7 00 3C 14 40 00 1A 00 A0 88 21 7C 03 E8 3B 8C 84 00 48 24 72 8B 70 8C 82 00 08 10 52 00 11 00 00 00 00 AF A0 00 18 C0 83 00 00 14 60 00 06 24 02 00 00 24 01 00 01 E0 81 00 00 10 20 FF FA 24 02 00 01 00 00 00 0F 14 40 00 03 00 00 00 00 0? ?? ?? ?? AF A3 00 18 8E 02 00 48 00 40 20 21 AC 52 00 08 8C 82 00 04 24 42 00 01 AC 82 00 04 8E 03 00 3C 27 A2 00 38 02 00 20 21 34 63 00 10 AE 03 00 3C 02 20 28 21 00 40 30 21 00 00 38 21 0? ?? ?? ?? AF A2 00 18 8E 05 00 3C 8E 03 00 00 24 04 FF EB 00 A4 20 24 30 63 80 00 00 40 88 21 14 60 00 06 AE 04 00 3C 8E 04 00 48 8C 82 00 04 24 42 FF FF 10 40 00 08 AC 82 00 04 8F BF 00 2C 02 20 10 21 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 30 AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF F0 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 2C 8E 05 00 3C 8E 02 00 00 24 03 FF EB 00 A3 18 24 30 42 80 00 00 80 88 21 14 40 00 06 AE 03 00 3C 8E 04 00 48 8C 83 00 04 24 63 FF FF 10 60 00 03 AC 83 00 04 0? ?? ?? ?? 02 20 20 21 AC 80 00 08 00 00 00 0F C0 83 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 63 00 02 14 60 FF F5 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_76_0_0 {
	meta:
		name = "__getegid"
		size = 16
	strings:
		$1 = { 24 02 0F D2 00 00 00 0C 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_77_0_0 {
	meta:
		name = "__mktemp"
		size = 64
		refs = "0018 __gen_tempname"
	strings:
		$1 = { 27 BD FF E0 00 00 28 21 00 00 30 21 24 07 00 02 AF B0 00 18 AF BF 00 1C 0? ?? ?? ?? 00 80 80 21 04 41 00 03 8F BF 00 1C A2 00 00 00 8F BF 00 1C 02 00 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "__strcasecmp"
		size = 112
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE"
	strings:
		$1 = { 3C 1C ?? ?? 7C 03 E8 3B 27 9C ?? ?? 00 60 10 21 8F 83 ?? ?? 00 62 10 21 10 85 00 13 8C 42 00 00 0? ?? ?? ?? 8C 46 00 38 10 60 00 0F 00 00 00 00 24 A5 00 01 90 83 00 00 90 A2 FF FF 00 03 38 80 00 02 10 80 00 C7 38 21 00 C2 10 21 8C E7 00 00 8C 42 00 00 00 E2 10 23 10 40 FF F3 24 84 00 01 03 E0 00 08 00 00 00 00 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "strftime"
		size = 60
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0028 __strftime_l"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 27 BD FF D8 AF BF 00 24 00 62 10 21 8C 42 00 00 AF BC 00 18 0? ?? ?? ?? AF A2 00 10 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_931_0_0 {
	meta:
		name = "__strtol_internal"
		size = 60
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0028 ____strtol_l_internal"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 27 BD FF D8 AF BF 00 24 00 62 10 21 8C 42 00 00 AF BC 00 18 0? ?? ?? ?? AF A2 00 10 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_1295_0_0 {
	meta:
		name = "__strtoll_internal"
		size = 60
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0028 ____strtoll_l_internal"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 27 BD FF D8 AF BF 00 24 00 62 10 21 8C 42 00 00 AF BC 00 18 0? ?? ?? ?? AF A2 00 10 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_795_0_0 {
	meta:
		name = "__strtoul_internal"
		size = 60
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0028 ____strtoul_l_internal"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 27 BD FF D8 AF BF 00 24 00 62 10 21 8C 42 00 00 AF BC 00 18 0? ?? ?? ?? AF A2 00 10 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_810_0_0 {
	meta:
		name = "__strtoull_internal"
		size = 60
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0028 ____strtoull_l_internal"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 27 BD FF D8 AF BF 00 24 00 62 10 21 8C 42 00 00 AF BC 00 18 0? ?? ?? ?? AF A2 00 10 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_81_0_0 {
	meta:
		name = "__wcstol_internal"
		size = 60
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0028 ____wcstol_l_internal"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 27 BD FF D8 AF BF 00 24 00 62 10 21 8C 42 00 00 AF BC 00 18 0? ?? ?? ?? AF A2 00 10 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_715_0_0 {
	meta:
		name = "__wcstoll_internal"
		size = 60
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0028 ____wcstoll_l_internal"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 27 BD FF D8 AF BF 00 24 00 62 10 21 8C 42 00 00 AF BC 00 18 0? ?? ?? ?? AF A2 00 10 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_209_0_0 {
	meta:
		name = "__wcstoul_internal"
		size = 60
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0028 ____wcstoul_l_internal"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 27 BD FF D8 AF BF 00 24 00 62 10 21 8C 42 00 00 AF BC 00 18 0? ?? ?? ?? AF A2 00 10 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_850_0_0 {
	meta:
		name = "__wcstoull_internal"
		size = 60
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0028 ____wcstoull_l_internal"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 27 BD FF D8 AF BF 00 24 00 62 10 21 8C 42 00 00 AF BC 00 18 0? ?? ?? ?? AF A2 00 10 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_342_0_0 {
	meta:
		name = "wcsftime"
		size = 60
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0028 __wcsftime_l"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 27 BD FF D8 AF BF 00 24 00 62 10 21 8C 42 00 00 AF BC 00 18 0? ?? ?? ?? AF A2 00 10 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_80_0_0 {
	meta:
		name = "__socketpair"
		size = 28
	strings:
		$1 = { 24 02 10 58 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_81_1_0 {
	meta:
		name = "wcstol"
		size = 64
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 002c ____wcstol_l_internal"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 27 BD FF D8 00 00 38 21 00 62 10 21 8C 42 00 00 AF BF 00 24 AF BC 00 18 0? ?? ?? ?? AF A2 00 10 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_137_0_0 {
	meta:
		name = "strptime"
		size = 64
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 002c __strptime_internal"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 27 BD FF D8 00 00 38 21 00 62 10 21 8C 42 00 00 AF BF 00 24 AF BC 00 18 0? ?? ?? ?? AF A2 00 10 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_931_1_0 {
	meta:
		name = "strtol"
		size = 64
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 002c ____strtol_l_internal"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 27 BD FF D8 00 00 38 21 00 62 10 21 8C 42 00 00 AF BF 00 24 AF BC 00 18 0? ?? ?? ?? AF A2 00 10 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_1295_1_0 {
	meta:
		name = "strtoll"
		size = 64
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 002c ____strtoll_l_internal"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 27 BD FF D8 00 00 38 21 00 62 10 21 8C 42 00 00 AF BF 00 24 AF BC 00 18 0? ?? ?? ?? AF A2 00 10 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_795_1_0 {
	meta:
		name = "strtoul"
		size = 64
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 002c ____strtoul_l_internal"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 27 BD FF D8 00 00 38 21 00 62 10 21 8C 42 00 00 AF BF 00 24 AF BC 00 18 0? ?? ?? ?? AF A2 00 10 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_810_1_0 {
	meta:
		name = "strtoull"
		size = 64
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 002c ____strtoull_l_internal"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 27 BD FF D8 00 00 38 21 00 62 10 21 8C 42 00 00 AF BF 00 24 AF BC 00 18 0? ?? ?? ?? AF A2 00 10 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_715_1_0 {
	meta:
		name = "wcstoll"
		size = 64
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 002c ____wcstoll_l_internal"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 27 BD FF D8 00 00 38 21 00 62 10 21 8C 42 00 00 AF BF 00 24 AF BC 00 18 0? ?? ?? ?? AF A2 00 10 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_209_1_0 {
	meta:
		name = "wcstoul"
		size = 64
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 002c ____wcstoul_l_internal"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 27 BD FF D8 00 00 38 21 00 62 10 21 8C 42 00 00 AF BF 00 24 AF BC 00 18 0? ?? ?? ?? AF A2 00 10 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_850_1_0 {
	meta:
		name = "wcstoull"
		size = 64
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 002c ____wcstoull_l_internal"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 27 BD FF D8 00 00 38 21 00 62 10 21 8C 42 00 00 AF BF 00 24 AF BC 00 18 0? ?? ?? ?? AF A2 00 10 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_82_0_0 {
	meta:
		name = "nfsservctl"
		size = 28
	strings:
		$1 = { 24 02 10 5D 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_83_0_0 {
	meta:
		name = "listxattr"
		size = 28
	strings:
		$1 = { 24 02 10 86 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "memfrob"
		size = 44
	strings:
		$1 = { 00 80 10 21 00 85 30 21 10 A0 00 06 00 80 18 21 24 63 00 01 90 65 FF FF 38 A5 00 2A 14 66 FF FC A0 65 FF FF 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_85_0_0 {
	meta:
		name = "__exit_thread"
		size = 16
	strings:
		$1 = { 24 02 0F A1 00 00 00 0C 14 E0 FF FB 00 00 00 00 }
	condition:
		$1
}

rule file_86_0_0 {
	meta:
		name = "sigignore"
		size = 76
		refs = "0020 memset 0034 __sigaction"
	strings:
		$1 = { 27 BD FF 50 00 00 28 21 24 06 00 80 AF B0 00 A8 24 02 00 01 00 80 80 21 27 A4 00 20 AF BF 00 AC 0? ?? ?? ?? AF A2 00 1C 02 00 20 21 27 A5 00 18 00 00 30 21 0? ?? ?? ?? AF A0 00 18 8F BF 00 AC 8F B0 00 A8 03 E0 00 08 27 BD 00 B0 }
	condition:
		$1
}

rule file_87_0_0 {
	meta:
		name = "seteuid"
		size = 168
		refs = "0000 __gnu_local_gp 0020 __nptl_setxid 005c __libc_errno"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF C8 27 9C ?? ?? 24 02 FF FF 00 80 28 21 AF BF 00 34 10 82 00 0E AF BC 00 10 3C 03 ?? ?? 24 63 ?? ?? 10 60 00 12 24 03 10 59 27 A4 00 18 AF A3 00 18 AF A2 00 1C AF A5 00 20 0? ?? ?? ?? AF A2 00 24 8F BF 00 34 03 E0 00 08 27 BD 00 38 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 16 AC 43 00 00 0? ?? ?? ?? 24 02 FF FF 24 04 FF FF 24 06 FF FF 24 02 10 59 00 00 00 0C 10 E0 FF F1 8F BF 00 34 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 64 20 21 AC 82 00 00 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_88_0_0 {
	meta:
		name = "setlinebuf"
		size = 16
		refs = "0008 _IO_setvbuf"
	strings:
		$1 = { 00 00 28 21 24 06 00 01 0? ?? ?? ?? 00 00 38 21 }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "__libc_init_secure"
		size = 108
		refs = "0000 __libc_enable_secure_decided 0020 __geteuid 0028 __getuid 003c __libc_enable_secure 0050 __getegid 0058 __getgid"
	strings:
		$1 = { 3C 02 ?? ?? 8C 42 ?? ?? 10 40 00 03 00 00 00 00 03 E0 00 08 00 00 00 00 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? AF B0 00 18 0? ?? ?? ?? 00 40 80 21 12 02 00 07 24 03 00 01 8F BF 00 1C 3C 02 ?? ?? 8F B0 00 18 AC 43 ?? ?? 03 E0 00 08 27 BD 00 20 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 00 40 80 21 02 02 10 26 0? ?? ?? ?? 00 02 18 2B }
	condition:
		$1
}

rule file_90_0_0 {
	meta:
		name = "fchmodat"
		size = 452
		refs = "0004 __gnu_local_gp 0040 __have_atfcts 0070 __libc_errno 00a8 strlen 00cc procfd.8484 00e4 __snprintf 0108 __atfct_seterrno"
	strings:
		$1 = { 27 BD FF C8 3C 1C ?? ?? 24 02 FE FF 27 9C ?? ?? AF BE 00 30 00 E2 10 24 03 A0 F0 21 AF BF 00 34 AF B3 00 2C AF B2 00 28 AF B1 00 24 AF B0 00 20 14 40 00 46 AF DC 00 18 30 E2 01 00 14 40 00 4B 3C 11 ?? ?? 8E 22 ?? ?? 00 80 90 21 00 A0 80 21 04 40 00 0F 00 C0 98 21 24 02 10 CB 00 00 00 0C 10 E0 00 2D 24 03 FF FF 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 40 28 21 00 64 20 21 AC 82 00 00 24 03 00 59 14 A3 00 26 24 02 FF FF AE 22 ?? ?? 24 02 FF 9C 12 42 00 2B 24 02 00 2F 82 03 00 00 10 62 00 12 00 00 88 21 0? ?? ?? ?? 02 00 20 21 10 40 00 36 8F DC 00 18 24 43 00 2E 00 03 18 C2 00 03 18 C0 03 A3 E8 23 27 B1 00 18 3C 06 ?? ?? AF B0 00 10 02 20 20 21 24 45 00 20 24 C6 ?? ?? 02 40 38 21 0? ?? ?? ?? 02 20 80 21 02 00 20 21 02 60 28 21 24 02 0F AF 00 00 00 0C 10 E0 00 08 00 40 20 21 02 40 28 21 0? ?? ?? ?? 02 20 30 21 0? ?? ?? ?? 24 02 FF FF 10 43 00 24 00 00 00 00 03 C0 E8 21 8F DF 00 34 8F BE 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 38 0? ?? ?? ?? 00 00 88 21 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 16 AC 43 00 00 0? ?? ?? ?? 24 02 FF FF 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 7A AC 43 00 00 0? ?? ?? ?? 24 02 FF FF 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 02 AC 43 00 00 0? ?? ?? ?? 24 02 FF FF 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 0? ?? ?? ?? 8C 45 00 00 }
	condition:
		$1
}

rule file_91_1_0 {
	meta:
		name = "__dlclose"
		size = 44
		refs = "0010 _dlerror_run"
	strings:
		$1 = { 00 80 28 21 3C 04 ?? ?? 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? 24 84 ?? ?? 8F BF 00 1C 00 02 10 2B 00 02 10 23 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_92_0_0 {
	meta:
		name = "__ptsname_internal"
		size = 784
		refs = "0000 __gnu_local_gp 0010 __libc_errno 0050 __isatty 00c8 __ioctl 00ec __xstat64 0154 __fxstat64 0198 __libc_ptyname1 01a8 strlen 01bc $LC1 01b8 __libc_ptyname2 0218 _itoa_word 0234 $LC0 0268 memcpy"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF A8 27 9C ?? ?? AF B2 00 40 8F 92 ?? ?? 7C 03 E8 3B AF B0 00 38 02 43 80 21 AF B6 00 50 AF B1 00 3C AF BF 00 54 AF B5 00 4C AF B4 00 48 AF B3 00 44 AF BC 00 10 00 A0 88 21 10 A0 00 12 8E 16 00 00 00 80 A0 21 00 C0 A8 21 0? ?? ?? ?? 00 E0 98 21 14 40 00 18 24 02 00 19 AE 02 00 00 8F BF 00 54 8F B6 00 50 8F B5 00 4C 8F B4 00 48 8F B3 00 44 8F B2 00 40 8F B1 00 3C 8F B0 00 38 03 E0 00 08 27 BD 00 58 8F BF 00 54 24 02 00 16 AE 02 00 00 8F B6 00 50 8F B5 00 4C 8F B4 00 48 8F B3 00 44 8F B2 00 40 8F B1 00 3C 8F B0 00 38 03 E0 00 08 27 BD 00 58 3C 05 40 04 02 80 20 21 24 A5 54 30 0? ?? ?? ?? 27 A6 00 30 10 40 00 4D 24 02 00 16 8E 03 00 00 10 62 00 12 00 00 00 00 24 04 00 03 02 20 28 21 0? ?? ?? ?? 02 60 30 21 04 40 00 12 00 00 00 00 8E 63 00 18 24 02 20 00 30 63 F0 00 10 62 00 5B 24 04 00 03 7C 03 E8 3B 02 43 10 21 24 03 00 19 AC 43 00 00 0? ?? ?? ?? 24 02 00 19 2E B5 00 0B 12 A0 00 08 24 04 00 03 24 02 00 22 0? ?? ?? ?? AE 02 00 00 7C 03 E8 3B 02 43 10 21 0? ?? ?? ?? 8C 42 00 00 02 80 28 21 0? ?? ?? ?? 02 60 30 21 04 40 00 5F 24 04 00 02 8E 62 00 28 7C 43 5A 00 10 64 00 06 24 04 00 04 10 64 00 5B 24 63 FF 80 2C 63 00 08 10 60 FF E3 00 00 00 00 00 02 1B 02 30 42 00 FF 24 04 FF 00 00 64 18 24 3C 15 ?? ?? 00 62 80 25 26 A4 ?? ?? AF B0 00 30 0? ?? ?? ?? 00 10 A1 02 02 82 10 2B 10 40 FF D6 3C 04 ?? ?? 3C 02 ?? ?? 8C 43 ?? ?? 24 42 ?? ?? 26 B5 ?? ?? 32 10 00 0F 24 84 ?? ?? 8C 42 00 04 02 95 A0 21 02 04 20 21 AA 23 00 00 92 85 00 00 90 84 00 00 BA 23 00 03 AA 22 00 04 BA 22 00 07 A2 25 00 08 A2 24 00 09 0? ?? ?? ?? A2 20 00 0A 8F A4 00 30 24 06 00 0A 27 A5 00 2C 00 00 38 21 0? ?? ?? ?? A3 A0 00 2C 27 A6 00 2D 00 C2 30 23 24 C3 00 09 02 A3 A8 2B 16 A0 FF C0 3C 03 ?? ?? 8C 65 ?? ?? 24 63 ?? ?? 8C 64 00 04 AA 25 00 00 90 67 00 08 90 63 00 09 BA 25 00 03 AA 24 00 04 BA 24 00 07 00 40 28 21 26 24 00 09 A2 27 00 08 0? ?? ?? ?? A2 23 00 09 0? ?? ?? ?? 24 04 00 03 8E 63 00 28 7C 62 5A 00 10 44 00 06 24 04 00 04 10 44 00 09 24 42 FF 78 2C 42 00 08 10 40 FF 9E 00 00 00 00 7C 03 E8 3B 02 43 10 21 AC 56 00 00 0? ?? ?? ?? 00 00 10 21 00 03 23 02 24 02 FF 00 00 82 10 24 30 63 00 FF 00 43 10 25 24 42 FF 40 2C 42 00 40 10 40 FF 90 00 00 00 00 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 8E 02 00 00 00 02 1B 02 24 04 FF 00 00 83 20 24 30 42 00 FF 00 82 20 25 24 84 FF 80 2C 84 00 40 10 80 FF 83 24 04 FF 00 0? ?? ?? ?? 00 64 18 24 }
	condition:
		$1
}

rule file_92_1_0 {
	meta:
		name = "ptsname"
		size = 60
		refs = "0018 __ptsname_internal"
	strings:
		$1 = { 27 BD FF 40 AF B0 00 B8 3C 10 ?? ?? 26 05 ?? ?? 27 A7 00 18 AF BF 00 BC 0? ?? ?? ?? 24 06 00 1E 8F BF 00 BC 26 10 ?? ?? 00 02 80 0B 02 00 10 21 8F B0 00 B8 03 E0 00 08 27 BD 00 C0 }
	condition:
		$1
}

rule file_92_2_0 {
	meta:
		name = "__ptsname_r"
		size = 28
		refs = "0008 __ptsname_internal"
	strings:
		$1 = { 27 BD FF 40 AF BF 00 BC 0? ?? ?? ?? 27 A7 00 18 8F BF 00 BC 03 E0 00 08 27 BD 00 C0 }
	condition:
		$1
}

rule file_93_0_0 {
	meta:
		name = "cbc_crypt"
		size = 312
		refs = "00f4 _des_crypt"
	strings:
		$1 = { 27 BD FF A8 AF B0 00 50 8F B0 00 68 AF BF 00 54 30 C2 00 07 82 0E 00 00 82 0D 00 01 82 0C 00 02 82 0B 00 03 82 0A 00 04 82 09 00 05 82 08 00 06 82 03 00 07 AF A0 00 24 A3 AE 00 28 A3 AD 00 29 A3 AC 00 2A A3 AB 00 2B A3 AA 00 2C A3 A9 00 2D A3 A8 00 2E A3 A3 00 2F 10 40 00 0E 24 0F 00 03 A2 0E 00 00 A2 0D 00 01 A2 0C 00 02 A2 0B 00 03 A2 0A 00 04 A2 09 00 05 A2 08 00 06 A2 03 00 07 8F BF 00 54 8F B0 00 50 01 E0 10 21 03 E0 00 08 27 BD 00 58 2C C2 20 01 10 40 FF F1 00 00 00 00 90 8D 00 00 90 8C 00 01 90 8B 00 02 90 8A 00 03 90 89 00 04 90 88 00 05 90 83 00 06 90 82 00 07 30 EE 00 01 00 A0 20 21 00 C0 28 21 27 A6 00 18 AF A7 00 48 AF AE 00 20 A3 AD 00 18 A3 AC 00 19 A3 AB 00 1A A3 AA 00 1B A3 A9 00 1C A3 A8 00 1D A3 A3 00 1E 0? ?? ?? ?? A3 A2 00 1F 24 0F 00 02 14 40 00 0A 8F A7 00 48 83 AE 00 28 83 AD 00 29 83 AC 00 2A 83 AB 00 2B 83 AA 00 2C 83 A9 00 2D 83 A8 00 2E 0? ?? ?? ?? 83 A3 00 2F 30 E7 00 02 0? ?? ?? ?? 2C EF 00 01 }
	condition:
		$1
}

rule file_93_1_0 {
	meta:
		name = "ecb_crypt"
		size = 172
		refs = "008c _des_crypt"
	strings:
		$1 = { 27 BD FF A8 24 08 00 01 30 C2 00 07 24 03 00 03 AF BF 00 54 10 40 00 05 AF A8 00 24 8F BF 00 54 00 60 10 21 03 E0 00 08 27 BD 00 58 2C C2 20 01 10 40 FF FB 8F BF 00 54 90 83 00 06 90 8D 00 00 90 8C 00 01 90 8B 00 02 90 8A 00 03 90 89 00 04 90 88 00 05 90 82 00 07 30 EE 00 01 00 A0 20 21 00 C0 28 21 27 A6 00 18 A3 A3 00 1E AF A7 00 48 AF AE 00 20 A3 AD 00 18 A3 AC 00 19 A3 AB 00 1A A3 AA 00 1B A3 A9 00 1C A3 A8 00 1D 0? ?? ?? ?? A3 A2 00 1F 24 03 00 02 10 40 FF E0 8F A7 00 48 30 E3 00 02 0? ?? ?? ?? 2C 63 00 01 }
	condition:
		$1
}

rule file_94_0_0 {
	meta:
		name = "strxfrm"
		size = 32
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0018 __strxfrm_l"
	strings:
		$1 = { 3C 1C ?? ?? 7C 03 E8 3B 27 9C ?? ?? 00 60 10 21 8F 83 ?? ?? 00 62 10 21 0? ?? ?? ?? 8C 47 00 00 }
	condition:
		$1
}

rule file_1101_0_0 {
	meta:
		name = "__strtod_internal"
		size = 32
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0018 ____strtod_l_internal"
	strings:
		$1 = { 3C 1C ?? ?? 7C 03 E8 3B 27 9C ?? ?? 00 60 10 21 8F 83 ?? ?? 00 62 10 21 0? ?? ?? ?? 8C 47 00 00 }
	condition:
		$1
}

rule file_737_0_0 {
	meta:
		name = "__strtof_internal"
		size = 32
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0018 ____strtof_l_internal"
	strings:
		$1 = { 3C 1C ?? ?? 7C 03 E8 3B 27 9C ?? ?? 00 60 10 21 8F 83 ?? ?? 00 62 10 21 0? ?? ?? ?? 8C 47 00 00 }
	condition:
		$1
}

rule file_559_0_0 {
	meta:
		name = "__strtold_internal"
		size = 32
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0018 ____strtold_l_internal"
	strings:
		$1 = { 3C 1C ?? ?? 7C 03 E8 3B 27 9C ?? ?? 00 60 10 21 8F 83 ?? ?? 00 62 10 21 0? ?? ?? ?? 8C 47 00 00 }
	condition:
		$1
}

rule file_1090_0_0 {
	meta:
		name = "__wcstod_internal"
		size = 32
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0018 ____wcstod_l_internal"
	strings:
		$1 = { 3C 1C ?? ?? 7C 03 E8 3B 27 9C ?? ?? 00 60 10 21 8F 83 ?? ?? 00 62 10 21 0? ?? ?? ?? 8C 47 00 00 }
	condition:
		$1
}

rule file_1023_0_0 {
	meta:
		name = "__wcstof_internal"
		size = 32
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0018 ____wcstof_l_internal"
	strings:
		$1 = { 3C 1C ?? ?? 7C 03 E8 3B 27 9C ?? ?? 00 60 10 21 8F 83 ?? ?? 00 62 10 21 0? ?? ?? ?? 8C 47 00 00 }
	condition:
		$1
}

rule file_947_0_0 {
	meta:
		name = "__wcstold_internal"
		size = 32
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0018 ____wcstold_l_internal"
	strings:
		$1 = { 3C 1C ?? ?? 7C 03 E8 3B 27 9C ?? ?? 00 60 10 21 8F 83 ?? ?? 00 62 10 21 0? ?? ?? ?? 8C 47 00 00 }
	condition:
		$1
}

rule file_232_0_0 {
	meta:
		name = "wcsxfrm"
		size = 32
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 0018 __wcsxfrm_l"
	strings:
		$1 = { 3C 1C ?? ?? 7C 03 E8 3B 27 9C ?? ?? 00 60 10 21 8F 83 ?? ?? 00 62 10 21 0? ?? ?? ?? 8C 47 00 00 }
	condition:
		$1
}

rule file_95_0_0 {
	meta:
		name = "endnetgrent_hook"
		size = 96
		refs = "0034 __nss_lookup_function 0030 $LC0"
	strings:
		$1 = { 27 BD FF E0 AF B0 00 18 00 80 80 21 8C 84 00 28 24 82 FF FF 2C 42 FF FE 14 40 00 05 AF BF 00 1C 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 3C 05 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 10 40 00 03 00 40 C8 21 03 20 F8 09 02 00 20 21 8F BF 00 1C AE 00 00 28 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_95_1_0 {
	meta:
		name = "setup"
		size = 188
		refs = "0048 $LC1 0054 __nss_lookup 0068 __nss_netgroup_lookup"
	strings:
		$1 = { 27 BD FF D8 AF B1 00 20 3C 11 ?? ?? 92 22 ?? ?? AF B0 00 1C AF BF 00 24 00 80 38 21 10 40 00 0F 00 A0 80 21 3C 02 ?? ?? 8C 42 ?? ?? 24 03 FF FF 10 43 00 1D 8F BF 00 24 8F B1 00 20 8F B0 00 1C AC A2 00 00 00 A0 20 21 3C 05 ?? ?? 24 A5 ?? ?? 00 00 30 21 0? ?? ?? ?? 27 BD 00 28 00 A0 20 21 3C 05 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 00 E0 30 21 10 40 00 0B 24 03 FF FF 3C 04 ?? ?? AC 83 ?? ?? 00 00 00 0F 8F BF 00 24 24 03 00 01 8F B0 00 1C A2 23 ?? ?? 8F B1 00 20 03 E0 00 08 27 BD 00 28 0? ?? ?? ?? 8E 03 00 00 8F B1 00 20 8F B0 00 1C 24 02 00 01 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_95_2_0 {
	meta:
		name = "__internal_setnetgrent_reuse"
		size = 504
		refs = "0004 __gnu_local_gp 006c $LC1 0070 $LC0 0098 _dl_mcount_wrapper_check 00cc __nss_next2 00e4 strlen 00f0 malloc 0114 memcpy 0158 __nss_lookup_function 018c __libc_errno 01d8 $LC2 01dc $LC3 01f0 __assert_fail 01e0 __PRETTY_FUNCTION__.11039"
	strings:
		$1 = { 27 BD FF B0 3C 1C ?? ?? 27 9C ?? ?? AF B3 00 34 AF B2 00 30 24 B3 00 28 00 80 90 21 00 A0 20 21 AF BF 00 4C AF BE 00 48 AF B0 00 28 AF BC 00 18 00 A0 80 21 00 C0 F0 21 AF B7 00 44 AF B6 00 40 AF B5 00 3C AF B4 00 38 0? ?? ?? ?? AF B1 00 2C 27 A4 00 20 0? ?? ?? ?? 02 60 28 21 14 40 00 5C 00 00 00 00 8E 02 00 10 14 40 00 5B 3C 16 ?? ?? 3C 17 ?? ?? 26 D6 ?? ?? 24 15 00 01 0? ?? ?? ?? 26 F7 ?? ?? 14 40 00 17 00 00 00 00 8E 02 00 10 14 40 00 52 3C 04 ?? ?? 0? ?? ?? ?? 8F A4 00 20 8F B9 00 20 02 40 20 21 03 20 F8 09 02 00 28 21 AF A2 00 10 AF A0 00 14 00 40 88 21 02 60 20 21 02 C0 28 21 00 00 30 21 27 A7 00 20 0? ?? ?? ?? 8E 14 00 28 16 35 FF EB 00 00 00 00 10 40 00 1E 02 80 20 21 0? ?? ?? ?? 02 40 20 21 24 44 00 05 0? ?? ?? ?? 24 54 00 01 00 40 98 21 10 40 00 21 8F BC 00 18 8E 02 00 20 26 64 00 04 02 40 28 21 02 80 30 21 0? ?? ?? ?? AE 62 00 00 8F BF 00 4C 3A 22 00 01 AE 13 00 20 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 2C 42 00 01 03 E0 00 08 27 BD 00 50 0? ?? ?? ?? 02 E0 28 21 10 40 FF CA 00 40 88 21 0? ?? ?? ?? 00 40 20 21 02 20 C8 21 03 20 F8 09 02 00 20 21 0? ?? ?? ?? 8E 02 00 10 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 8F BF 00 4C 8F B7 00 44 00 64 20 21 8C 83 00 00 8F B6 00 40 8F B5 00 3C AF C3 00 00 8F B4 00 38 8F BE 00 48 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 00 00 10 21 03 E0 00 08 27 BD 00 50 0? ?? ?? ?? 24 11 FF FF 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 88 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_95_3_0 {
	meta:
		name = "nscd_getnetgrent"
		size = 140
		refs = "0034 __rawmemchr"
	strings:
		$1 = { 27 BD FF E0 AF B0 00 18 00 80 80 21 AF BF 00 1C 8C 84 00 10 8E 03 00 14 8E 02 00 18 00 83 18 21 00 43 18 2B 10 60 00 17 00 40 20 21 00 00 28 21 AE 00 00 00 0? ?? ?? ?? AE 02 00 04 24 42 00 01 00 40 20 21 00 00 28 21 AE 02 00 18 0? ?? ?? ?? AE 02 00 08 24 44 00 01 AE 04 00 18 AE 04 00 0C 0? ?? ?? ?? 00 00 28 21 24 42 00 01 AE 02 00 18 24 02 00 01 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_95_4_0 {
	meta:
		name = "free_memory.isra.0"
		size = 108
		refs = "0024 free"
	strings:
		$1 = { 27 BD FF D8 AF B1 00 20 00 80 88 21 8C 84 00 00 AF B0 00 1C AF BF 00 24 10 80 00 07 00 A0 80 21 8C 82 00 00 0? ?? ?? ?? AE 22 00 00 8E 24 00 00 14 80 FF FB 00 00 00 00 8E 04 00 00 10 80 00 07 8F BF 00 24 8C 82 00 00 0? ?? ?? ?? AE 02 00 00 8E 04 00 00 14 80 FF FB 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_95_5_0 {
	meta:
		name = "__internal_setnetgrent"
		size = 92
		refs = "0004 __gnu_local_gp 003c __libc_errno"
	strings:
		$1 = { 27 BD FF D8 3C 1C ?? ?? AF B0 00 1C 00 A0 80 21 AF B1 00 20 27 9C ?? ?? 00 80 88 21 24 A5 00 24 AF BF 00 24 AF BC 00 10 0? ?? ?? ?? 26 04 00 20 8F BC 00 10 8F BF 00 24 02 20 20 21 8F 86 ?? ?? 8F B1 00 20 02 00 28 21 8F B0 00 1C 7C 03 E8 3B 00 C3 30 21 0? ?? ?? ?? 27 BD 00 28 }
	condition:
		$1
}

rule file_95_6_0 {
	meta:
		name = "setnetgrent"
		size = 304
		refs = "0044 __nss_not_use_nscd_netgroup 0068 __nss_database_custom 007c __nscd_setnetgrent 00dc __internal_setnetgrent 00fc __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF D0 AF B0 00 1C 3C 10 ?? ?? AF B3 00 28 26 03 ?? ?? 00 80 98 21 AF BF 00 2C AF B2 00 24 AF B1 00 20 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 2F 00 00 00 00 3C 03 ?? ?? 8C 62 ?? ?? 18 40 00 27 00 00 00 00 24 42 00 01 28 44 00 65 14 80 00 1D 3C 12 ?? ?? AC 60 ?? ?? 3C 02 ?? ?? 90 42 ?? ?? 14 40 00 20 02 60 20 21 3C 12 ?? ?? 0? ?? ?? ?? 26 45 ?? ?? 04 40 00 14 00 40 88 21 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 17 26 04 ?? ?? 8F BF 00 2C 02 20 10 21 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 30 AC 62 ?? ?? 02 60 20 21 0? ?? ?? ?? 26 45 ?? ?? 0? ?? ?? ?? 00 40 88 21 10 40 FF DF 3C 02 ?? ?? 0? ?? ?? ?? 3C 12 ?? ?? 0? ?? ?? ?? 26 04 ?? ?? 0? ?? ?? ?? 3C 03 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 2C }
	condition:
		$1
}

rule file_95_7_0 {
	meta:
		name = "__internal_endnetgrent"
		size = 44
	strings:
		$1 = { 27 BD FF E0 AF B0 00 18 AF BF 00 1C 0? ?? ?? ?? 00 80 80 21 8F BF 00 1C 26 04 00 20 26 05 00 24 8F B0 00 18 0? ?? ?? ?? 27 BD 00 20 }
	condition:
		$1
}

rule file_95_8_0 {
	meta:
		name = "endnetgrent"
		size = 192
		refs = "008c __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF E0 AF B0 00 18 3C 10 ?? ?? 26 03 ?? ?? AF BF 00 1C C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 17 00 00 00 00 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 09 26 04 ?? ?? 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 0? ?? ?? ?? 26 04 ?? ?? 0? ?? ?? ?? 3C 04 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 1C }
	condition:
		$1
}

rule file_95_9_0 {
	meta:
		name = "__internal_getnetgrent_r"
		size = 612
		refs = "0004 __gnu_local_gp 0064 __nss_lookup_function 005c $LC4 0078 __libc_errno 008c _dl_mcount_wrapper_check 00d8 strcmp 0120 strlen 012c malloc 014c memcpy"
	strings:
		$1 = { 8C E2 00 28 3C 1C ?? ?? 27 BD FF B8 27 9C ?? ?? AF B2 00 28 AF B0 00 20 AF BF 00 44 AF BE 00 40 AF B7 00 3C AF B6 00 38 AF B5 00 34 AF B4 00 30 AF B3 00 2C AF B1 00 24 AF BC 00 10 00 E0 80 21 AF A4 00 48 AF A5 00 4C AF A6 00 50 10 40 00 60 8F B2 00 60 24 03 FF FF 10 43 00 6A 3C 05 ?? ?? 00 40 20 21 0? ?? ?? ?? 24 A5 ?? ?? 00 40 98 21 10 40 00 57 8F BC 00 10 8F 96 ?? ?? 7C 03 E8 3B 24 15 00 02 02 C3 B0 21 24 14 00 01 0? ?? ?? ?? 02 60 20 21 8F A5 00 58 8F A6 00 5C 02 00 20 21 02 60 C8 21 03 20 F8 09 02 C0 38 21 10 55 00 2B 00 00 00 00 14 54 00 47 8F BF 00 44 8E 02 00 00 14 54 00 53 8F B9 00 48 8E 1E 00 20 13 C0 00 09 8E 11 00 04 27 C5 00 04 0? ?? ?? ?? 02 20 20 21 10 40 FF EA 00 00 00 00 8F DE 00 00 17 C0 FF FA 27 C5 00 04 8E 1E 00 24 13 C0 00 09 27 C5 00 04 03 C0 B8 21 0? ?? ?? ?? 02 20 20 21 10 40 FF DF 00 00 00 00 8E F7 00 00 16 E0 FF FA 26 E5 00 04 0? ?? ?? ?? 02 20 20 21 24 44 00 05 0? ?? ?? ?? AF A2 00 18 00 40 88 21 10 40 00 25 8F A6 00 18 8E 05 00 04 26 24 00 04 24 C6 00 01 0? ?? ?? ?? AE 3E 00 00 0? ?? ?? ?? AE 11 00 24 8E 03 00 24 14 60 00 05 8F BF 00 44 0? ?? ?? ?? 8F BE 00 40 14 40 00 0F 00 00 00 00 8C 65 00 00 8E 02 00 20 24 64 00 04 AE 05 00 24 02 40 30 21 AC 62 00 00 02 00 28 21 0? ?? ?? ?? AE 03 00 20 8E 03 00 24 14 60 FF F3 00 00 00 00 10 40 00 0A 8F BF 00 44 8E 04 00 28 10 80 00 07 8F BF 00 44 3C 05 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 14 40 FF B0 00 40 98 21 8F BF 00 44 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 00 00 10 21 03 E0 00 08 27 BD 00 48 3C 13 ?? ?? 0? ?? ?? ?? 26 73 ?? ?? 8E 03 00 04 8F BF 00 44 8F BE 00 40 AF 23 00 00 8E 03 00 08 8F B9 00 4C 8F B7 00 3C 8F B6 00 38 AF 23 00 00 8E 03 00 0C 8F B9 00 50 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 24 02 00 01 AF 23 00 00 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_95_10_0 {
	meta:
		name = "__getnetgrent_r"
		size = 260
		refs = "0004 __gnu_local_gp 0050 __libc_errno 0070 __internal_getnetgrent_r 00c4 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF B8 3C 1C ?? ?? AF B0 00 3C 3C 10 ?? ?? AF B1 00 40 27 9C ?? ?? 00 80 88 21 26 03 ?? ?? AF BF 00 44 AF BC 00 20 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 1E 26 04 ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? AF A7 00 10 3C 07 ?? ?? 00 62 10 21 8F A3 00 58 02 20 20 21 AF A2 00 18 AF A3 00 14 0? ?? ?? ?? 24 E7 ?? ?? 00 40 88 21 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 10 26 04 ?? ?? 8F BF 00 44 02 20 10 21 8F B0 00 3C 8F B1 00 40 03 E0 00 08 27 BD 00 48 AF A5 00 28 AF A6 00 2C 0? ?? ?? ?? AF A7 00 30 8F BC 00 20 8F A7 00 30 8F A6 00 2C 0? ?? ?? ?? 8F A5 00 28 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 44 }
	condition:
		$1
}

rule file_95_11_0 {
	meta:
		name = "innetgr"
		size = 972
		refs = "0394 __nss_database_custom 0000 __nss_not_use_nscd_netgroup 0008 __gnu_local_gp 006c __libc_errno 00c8 _dl_mcount_wrapper_check 00f8 __nss_lookup_function 00f4 $LC0 0120 $LC1 0138 __nss_next2 0190 __nscd_innetgr 01d0 $LC4 0228 __strcasecmp 024c strcmp 02fc strlen 030c malloc 0328 memcpy 03ac $LC5 03b0 $LC3 03c4 __assert_fail 03b4 __PRETTY_FUNCTION__.11216"
	strings:
		$1 = { 3C 03 ?? ?? 8C 62 ?? ?? 3C 1C ?? ?? 27 BD FB 80 27 9C ?? ?? AF B6 04 70 AF B5 04 6C AF B3 04 64 AF BF 04 7C AF BE 04 78 AF B7 04 74 AF B4 04 68 AF B2 04 60 AF B1 04 5C AF B0 04 58 AF BC 00 18 AF A4 04 80 00 A0 98 21 00 C0 A8 21 18 40 00 D0 00 E0 B0 21 24 42 00 01 28 44 00 65 10 80 00 44 00 00 00 00 AC 62 ?? ?? 8F B9 04 80 8F 94 ?? ?? 7C 03 E8 3B AF A0 04 20 AF A0 04 24 AF A0 04 28 AF A0 04 2C AF A0 04 30 AF A0 04 34 AF A0 04 38 AF A0 04 3C AF A0 04 40 AF A0 04 44 AF A0 04 48 AF B9 04 50 02 83 A0 21 27 A4 04 4C 0? ?? ?? ?? 27 A5 04 48 14 40 00 25 8F A2 04 44 8F A2 04 30 14 40 00 BA 8F A4 04 4C 0? ?? ?? ?? 00 00 90 21 8F A4 04 50 8F B9 04 4C 03 20 F8 09 27 A5 04 20 00 40 80 21 24 02 00 01 12 02 00 39 8F A4 04 48 8F A4 04 48 3C 02 ?? ?? 0? ?? ?? ?? 24 45 ?? ?? 10 40 00 06 00 40 88 21 0? ?? ?? ?? 00 40 20 21 02 20 C8 21 03 20 F8 09 27 A4 04 20 16 40 00 89 3C 05 ?? ?? AF B0 00 10 AF A0 00 14 27 A4 04 48 24 A5 ?? ?? 00 00 30 21 0? ?? ?? ?? 27 A7 04 4C 10 40 FF DF 8F A2 04 30 8F A2 04 44 10 40 00 7F 24 59 00 04 8C 43 00 00 AF B9 04 50 AF A3 04 44 8F A3 04 40 AC 43 00 00 0? ?? ?? ?? AF A2 04 40 AC 60 ?? ?? 3C 02 ?? ?? 90 42 ?? ?? 14 40 FF BB 8F B9 04 80 8F A4 04 80 02 60 28 21 02 A0 30 21 0? ?? ?? ?? 02 C0 38 21 04 40 FF B3 8F BC 00 18 8F BF 04 7C 8F BE 04 78 8F B7 04 74 8F B6 04 70 8F B5 04 6C 8F B4 04 68 8F B3 04 64 8F B2 04 60 8F B1 04 5C 8F B0 04 58 03 E0 00 08 27 BD 04 80 3C 05 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 10 40 FF C4 00 40 88 21 24 12 00 01 0? ?? ?? ?? 02 20 20 21 27 A4 04 20 27 A5 00 20 24 06 04 00 02 20 C8 21 03 20 F8 09 02 80 38 21 14 52 00 4B 8F A2 04 20 10 52 00 1E 8F A4 04 24 10 80 00 07 00 00 00 00 12 60 00 05 00 00 00 00 0? ?? ?? ?? 02 60 28 21 14 40 FF ED 00 00 00 00 8F A4 04 28 10 80 00 07 00 00 00 00 12 A0 00 05 00 00 00 00 0? ?? ?? ?? 02 A0 28 21 14 40 FF E4 00 00 00 00 8F A4 04 2C 10 80 00 07 00 00 00 00 12 C0 00 05 00 00 00 00 0? ?? ?? ?? 02 C0 28 21 14 40 FF DB 00 00 00 00 24 12 00 01 0? ?? ?? ?? 24 10 00 02 8F B7 04 40 12 E0 00 09 8F B0 04 24 02 00 20 21 0? ?? ?? ?? 26 E5 00 04 10 40 FF D0 00 00 00 00 8E F7 00 00 16 E0 FF FA 02 00 20 21 8F B7 04 44 12 E0 00 0B 8F A4 04 80 02 E0 F0 21 02 00 20 21 0? ?? ?? ?? 27 C5 00 04 10 40 FF C4 00 00 00 00 8F DE 00 00 17 C0 FF FA 02 00 20 21 8F A4 04 80 0? ?? ?? ?? 02 00 28 21 10 40 FF BC 00 00 00 00 0? ?? ?? ?? 02 00 20 21 24 46 00 01 24 44 00 05 0? ?? ?? ?? AF A6 04 54 00 40 F0 21 10 40 00 21 8F A6 04 54 24 44 00 04 02 00 28 21 0? ?? ?? ?? AC 57 00 00 0? ?? ?? ?? AF BE 04 44 00 00 90 21 0? ?? ?? ?? 24 10 00 02 3A 42 00 01 2C 42 00 01 27 A4 04 40 27 A5 04 44 0? ?? ?? ?? AF A2 04 54 8F BF 04 7C 8F A2 04 54 8F BE 04 78 8F B7 04 74 8F B6 04 70 8F B5 04 6C 8F B4 04 68 8F B3 04 64 8F B2 04 60 8F B1 04 5C 8F B0 04 58 03 E0 00 08 27 BD 04 80 10 40 FF 79 3C 02 ?? ?? 0? ?? ?? ?? 8F B9 04 80 24 12 FF FF 0? ?? ?? ?? 24 10 00 02 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 01 A7 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_96_0_0 {
	meta:
		name = "__getsgnam_r"
		size = 544
		refs = "0010 __gnu_local_gp 0074 __libc_errno 007c $LC0 0088 _dl_mcount_wrapper_check 00dc __nss_next2 01d0 __nss_gshadow_lookup2"
	strings:
		$1 = { 27 BD FF B0 AF B0 00 2C 3C 10 ?? ?? 92 02 ?? ?? 3C 1C ?? ?? 27 9C ?? ?? AF B5 00 40 AF B4 00 3C AF B3 00 38 AF B2 00 34 AF BF 00 4C AF B7 00 48 AF B6 00 44 AF B1 00 30 AF BC 00 18 00 80 98 21 00 A0 90 21 00 C0 A0 21 10 40 00 5D 00 E0 A8 21 3C 02 ?? ?? 8C 43 ?? ?? 3C 02 ?? ?? 8C 44 ?? ?? 24 62 00 01 AF A3 00 24 AF A4 00 20 2C 42 00 01 14 40 00 45 8F 97 ?? ?? 7C 03 E8 3B 3C 16 ?? ?? 02 E3 88 21 26 D6 ?? ?? 0? ?? ?? ?? 8F A4 00 20 8F B9 00 20 02 60 20 21 02 40 28 21 02 80 30 21 02 A0 38 21 03 20 F8 09 AF B1 00 10 00 40 80 21 24 02 FF FE 27 A4 00 24 02 C0 28 21 00 00 30 21 16 02 00 05 27 A7 00 20 8E 23 00 00 24 02 00 22 10 62 00 2F 8F A3 00 60 AF B0 00 10 0? ?? ?? ?? AF A0 00 14 10 40 FF E8 24 02 00 01 12 02 00 15 8F A3 00 60 2E 02 00 02 14 40 00 47 AC 60 00 00 7C 03 E8 3B 02 E3 10 21 8C 42 00 00 24 03 00 22 10 43 00 27 24 03 FF FE 8F BF 00 4C 8F B7 00 48 8F B6 00 44 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 50 8F A2 00 60 AC 52 00 00 00 00 10 21 8F BF 00 4C 7C 03 E8 3B 02 E3 20 21 8F B6 00 44 8F B7 00 48 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C AC 82 00 00 03 E0 00 08 27 BD 00 50 24 10 FF FF 8F A3 00 60 AC 60 00 00 7C 03 E8 3B 02 E3 10 21 8C 42 00 00 24 03 00 22 14 43 FF DD 8F BF 00 4C 24 03 FF FE 12 03 FF DA 8F BF 00 4C 0? ?? ?? ?? 24 02 00 16 3C 05 ?? ?? 27 A4 00 24 24 A5 ?? ?? 00 00 30 21 0? ?? ?? ?? 27 A7 00 20 14 40 00 0B 8F BC 00 18 8F A4 00 20 3C 03 ?? ?? AC 64 ?? ?? 8F A4 00 24 3C 03 ?? ?? AC 64 ?? ?? 00 00 00 0F 24 03 00 01 0? ?? ?? ?? A2 03 ?? ?? 24 04 FF FF 3C 03 ?? ?? 0? ?? ?? ?? AC 64 ?? ?? 0? ?? ?? ?? 00 00 10 21 }
	condition:
		$1
}

rule file_802_0_0 {
	meta:
		name = "__getaliasbyname_r"
		size = 544
		refs = "0010 __gnu_local_gp 0074 __libc_errno 007c $LC0 0088 _dl_mcount_wrapper_check 00dc __nss_next2 01d0 __nss_aliases_lookup2"
	strings:
		$1 = { 27 BD FF B0 AF B0 00 2C 3C 10 ?? ?? 92 02 ?? ?? 3C 1C ?? ?? 27 9C ?? ?? AF B5 00 40 AF B4 00 3C AF B3 00 38 AF B2 00 34 AF BF 00 4C AF B7 00 48 AF B6 00 44 AF B1 00 30 AF BC 00 18 00 80 98 21 00 A0 90 21 00 C0 A0 21 10 40 00 5D 00 E0 A8 21 3C 02 ?? ?? 8C 43 ?? ?? 3C 02 ?? ?? 8C 44 ?? ?? 24 62 00 01 AF A3 00 24 AF A4 00 20 2C 42 00 01 14 40 00 45 8F 97 ?? ?? 7C 03 E8 3B 3C 16 ?? ?? 02 E3 88 21 26 D6 ?? ?? 0? ?? ?? ?? 8F A4 00 20 8F B9 00 20 02 60 20 21 02 40 28 21 02 80 30 21 02 A0 38 21 03 20 F8 09 AF B1 00 10 00 40 80 21 24 02 FF FE 27 A4 00 24 02 C0 28 21 00 00 30 21 16 02 00 05 27 A7 00 20 8E 23 00 00 24 02 00 22 10 62 00 2F 8F A3 00 60 AF B0 00 10 0? ?? ?? ?? AF A0 00 14 10 40 FF E8 24 02 00 01 12 02 00 15 8F A3 00 60 2E 02 00 02 14 40 00 47 AC 60 00 00 7C 03 E8 3B 02 E3 10 21 8C 42 00 00 24 03 00 22 10 43 00 27 24 03 FF FE 8F BF 00 4C 8F B7 00 48 8F B6 00 44 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 50 8F A2 00 60 AC 52 00 00 00 00 10 21 8F BF 00 4C 7C 03 E8 3B 02 E3 20 21 8F B6 00 44 8F B7 00 48 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C AC 82 00 00 03 E0 00 08 27 BD 00 50 24 10 FF FF 8F A3 00 60 AC 60 00 00 7C 03 E8 3B 02 E3 10 21 8C 42 00 00 24 03 00 22 14 43 FF DD 8F BF 00 4C 24 03 FF FE 12 03 FF DA 8F BF 00 4C 0? ?? ?? ?? 24 02 00 16 3C 05 ?? ?? 27 A4 00 24 24 A5 ?? ?? 00 00 30 21 0? ?? ?? ?? 27 A7 00 20 14 40 00 0B 8F BC 00 18 8F A4 00 20 3C 03 ?? ?? AC 64 ?? ?? 8F A4 00 24 3C 03 ?? ?? AC 64 ?? ?? 00 00 00 0F 24 03 00 01 0? ?? ?? ?? A2 03 ?? ?? 24 04 FF FF 3C 03 ?? ?? 0? ?? ?? ?? AC 64 ?? ?? 0? ?? ?? ?? 00 00 10 21 }
	condition:
		$1
}

rule file_1405_0_0 {
	meta:
		name = "__getprotobyname_r"
		size = 544
		refs = "0010 __gnu_local_gp 0074 __libc_errno 007c $LC0 0088 _dl_mcount_wrapper_check 00dc __nss_next2 01d0 __nss_protocols_lookup2"
	strings:
		$1 = { 27 BD FF B0 AF B0 00 2C 3C 10 ?? ?? 92 02 ?? ?? 3C 1C ?? ?? 27 9C ?? ?? AF B5 00 40 AF B4 00 3C AF B3 00 38 AF B2 00 34 AF BF 00 4C AF B7 00 48 AF B6 00 44 AF B1 00 30 AF BC 00 18 00 80 98 21 00 A0 90 21 00 C0 A0 21 10 40 00 5D 00 E0 A8 21 3C 02 ?? ?? 8C 43 ?? ?? 3C 02 ?? ?? 8C 44 ?? ?? 24 62 00 01 AF A3 00 24 AF A4 00 20 2C 42 00 01 14 40 00 45 8F 97 ?? ?? 7C 03 E8 3B 3C 16 ?? ?? 02 E3 88 21 26 D6 ?? ?? 0? ?? ?? ?? 8F A4 00 20 8F B9 00 20 02 60 20 21 02 40 28 21 02 80 30 21 02 A0 38 21 03 20 F8 09 AF B1 00 10 00 40 80 21 24 02 FF FE 27 A4 00 24 02 C0 28 21 00 00 30 21 16 02 00 05 27 A7 00 20 8E 23 00 00 24 02 00 22 10 62 00 2F 8F A3 00 60 AF B0 00 10 0? ?? ?? ?? AF A0 00 14 10 40 FF E8 24 02 00 01 12 02 00 15 8F A3 00 60 2E 02 00 02 14 40 00 47 AC 60 00 00 7C 03 E8 3B 02 E3 10 21 8C 42 00 00 24 03 00 22 10 43 00 27 24 03 FF FE 8F BF 00 4C 8F B7 00 48 8F B6 00 44 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 50 8F A2 00 60 AC 52 00 00 00 00 10 21 8F BF 00 4C 7C 03 E8 3B 02 E3 20 21 8F B6 00 44 8F B7 00 48 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C AC 82 00 00 03 E0 00 08 27 BD 00 50 24 10 FF FF 8F A3 00 60 AC 60 00 00 7C 03 E8 3B 02 E3 10 21 8C 42 00 00 24 03 00 22 14 43 FF DD 8F BF 00 4C 24 03 FF FE 12 03 FF DA 8F BF 00 4C 0? ?? ?? ?? 24 02 00 16 3C 05 ?? ?? 27 A4 00 24 24 A5 ?? ?? 00 00 30 21 0? ?? ?? ?? 27 A7 00 20 14 40 00 0B 8F BC 00 18 8F A4 00 20 3C 03 ?? ?? AC 64 ?? ?? 8F A4 00 24 3C 03 ?? ?? AC 64 ?? ?? 00 00 00 0F 24 03 00 01 0? ?? ?? ?? A2 03 ?? ?? 24 04 FF FF 3C 03 ?? ?? 0? ?? ?? ?? AC 64 ?? ?? 0? ?? ?? ?? 00 00 10 21 }
	condition:
		$1
}

rule file_1270_0_0 {
	meta:
		name = "__getprotobynumber_r"
		size = 544
		refs = "0010 __gnu_local_gp 0074 __libc_errno 007c $LC0 0088 _dl_mcount_wrapper_check 00dc __nss_next2 01d0 __nss_protocols_lookup2"
	strings:
		$1 = { 27 BD FF B0 AF B0 00 2C 3C 10 ?? ?? 92 02 ?? ?? 3C 1C ?? ?? 27 9C ?? ?? AF B5 00 40 AF B4 00 3C AF B3 00 38 AF B2 00 34 AF BF 00 4C AF B7 00 48 AF B6 00 44 AF B1 00 30 AF BC 00 18 00 80 98 21 00 A0 90 21 00 C0 A0 21 10 40 00 5D 00 E0 A8 21 3C 02 ?? ?? 8C 43 ?? ?? 3C 02 ?? ?? 8C 44 ?? ?? 24 62 00 01 AF A3 00 24 AF A4 00 20 2C 42 00 01 14 40 00 45 8F 97 ?? ?? 7C 03 E8 3B 3C 16 ?? ?? 02 E3 88 21 26 D6 ?? ?? 0? ?? ?? ?? 8F A4 00 20 8F B9 00 20 02 60 20 21 02 40 28 21 02 80 30 21 02 A0 38 21 03 20 F8 09 AF B1 00 10 00 40 80 21 24 02 FF FE 27 A4 00 24 02 C0 28 21 00 00 30 21 16 02 00 05 27 A7 00 20 8E 23 00 00 24 02 00 22 10 62 00 2F 8F A3 00 60 AF B0 00 10 0? ?? ?? ?? AF A0 00 14 10 40 FF E8 24 02 00 01 12 02 00 15 8F A3 00 60 2E 02 00 02 14 40 00 47 AC 60 00 00 7C 03 E8 3B 02 E3 10 21 8C 42 00 00 24 03 00 22 10 43 00 27 24 03 FF FE 8F BF 00 4C 8F B7 00 48 8F B6 00 44 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 50 8F A2 00 60 AC 52 00 00 00 00 10 21 8F BF 00 4C 7C 03 E8 3B 02 E3 20 21 8F B6 00 44 8F B7 00 48 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C AC 82 00 00 03 E0 00 08 27 BD 00 50 24 10 FF FF 8F A3 00 60 AC 60 00 00 7C 03 E8 3B 02 E3 10 21 8C 42 00 00 24 03 00 22 14 43 FF DD 8F BF 00 4C 24 03 FF FE 12 03 FF DA 8F BF 00 4C 0? ?? ?? ?? 24 02 00 16 3C 05 ?? ?? 27 A4 00 24 24 A5 ?? ?? 00 00 30 21 0? ?? ?? ?? 27 A7 00 20 14 40 00 0B 8F BC 00 18 8F A4 00 20 3C 03 ?? ?? AC 64 ?? ?? 8F A4 00 24 3C 03 ?? ?? AC 64 ?? ?? 00 00 00 0F 24 03 00 01 0? ?? ?? ?? A2 03 ?? ?? 24 04 FF FF 3C 03 ?? ?? 0? ?? ?? ?? AC 64 ?? ?? 0? ?? ?? ?? 00 00 10 21 }
	condition:
		$1
}

rule file_373_0_0 {
	meta:
		name = "__getrpcbyname_r"
		size = 544
		refs = "0010 __gnu_local_gp 0074 __libc_errno 007c $LC0 0088 _dl_mcount_wrapper_check 00dc __nss_next2 01d0 __nss_rpc_lookup2"
	strings:
		$1 = { 27 BD FF B0 AF B0 00 2C 3C 10 ?? ?? 92 02 ?? ?? 3C 1C ?? ?? 27 9C ?? ?? AF B5 00 40 AF B4 00 3C AF B3 00 38 AF B2 00 34 AF BF 00 4C AF B7 00 48 AF B6 00 44 AF B1 00 30 AF BC 00 18 00 80 98 21 00 A0 90 21 00 C0 A0 21 10 40 00 5D 00 E0 A8 21 3C 02 ?? ?? 8C 43 ?? ?? 3C 02 ?? ?? 8C 44 ?? ?? 24 62 00 01 AF A3 00 24 AF A4 00 20 2C 42 00 01 14 40 00 45 8F 97 ?? ?? 7C 03 E8 3B 3C 16 ?? ?? 02 E3 88 21 26 D6 ?? ?? 0? ?? ?? ?? 8F A4 00 20 8F B9 00 20 02 60 20 21 02 40 28 21 02 80 30 21 02 A0 38 21 03 20 F8 09 AF B1 00 10 00 40 80 21 24 02 FF FE 27 A4 00 24 02 C0 28 21 00 00 30 21 16 02 00 05 27 A7 00 20 8E 23 00 00 24 02 00 22 10 62 00 2F 8F A3 00 60 AF B0 00 10 0? ?? ?? ?? AF A0 00 14 10 40 FF E8 24 02 00 01 12 02 00 15 8F A3 00 60 2E 02 00 02 14 40 00 47 AC 60 00 00 7C 03 E8 3B 02 E3 10 21 8C 42 00 00 24 03 00 22 10 43 00 27 24 03 FF FE 8F BF 00 4C 8F B7 00 48 8F B6 00 44 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 50 8F A2 00 60 AC 52 00 00 00 00 10 21 8F BF 00 4C 7C 03 E8 3B 02 E3 20 21 8F B6 00 44 8F B7 00 48 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C AC 82 00 00 03 E0 00 08 27 BD 00 50 24 10 FF FF 8F A3 00 60 AC 60 00 00 7C 03 E8 3B 02 E3 10 21 8C 42 00 00 24 03 00 22 14 43 FF DD 8F BF 00 4C 24 03 FF FE 12 03 FF DA 8F BF 00 4C 0? ?? ?? ?? 24 02 00 16 3C 05 ?? ?? 27 A4 00 24 24 A5 ?? ?? 00 00 30 21 0? ?? ?? ?? 27 A7 00 20 14 40 00 0B 8F BC 00 18 8F A4 00 20 3C 03 ?? ?? AC 64 ?? ?? 8F A4 00 24 3C 03 ?? ?? AC 64 ?? ?? 00 00 00 0F 24 03 00 01 0? ?? ?? ?? A2 03 ?? ?? 24 04 FF FF 3C 03 ?? ?? 0? ?? ?? ?? AC 64 ?? ?? 0? ?? ?? ?? 00 00 10 21 }
	condition:
		$1
}

rule file_1490_0_0 {
	meta:
		name = "__getrpcbynumber_r"
		size = 544
		refs = "0010 __gnu_local_gp 0074 __libc_errno 007c $LC0 0088 _dl_mcount_wrapper_check 00dc __nss_next2 01d0 __nss_rpc_lookup2"
	strings:
		$1 = { 27 BD FF B0 AF B0 00 2C 3C 10 ?? ?? 92 02 ?? ?? 3C 1C ?? ?? 27 9C ?? ?? AF B5 00 40 AF B4 00 3C AF B3 00 38 AF B2 00 34 AF BF 00 4C AF B7 00 48 AF B6 00 44 AF B1 00 30 AF BC 00 18 00 80 98 21 00 A0 90 21 00 C0 A0 21 10 40 00 5D 00 E0 A8 21 3C 02 ?? ?? 8C 43 ?? ?? 3C 02 ?? ?? 8C 44 ?? ?? 24 62 00 01 AF A3 00 24 AF A4 00 20 2C 42 00 01 14 40 00 45 8F 97 ?? ?? 7C 03 E8 3B 3C 16 ?? ?? 02 E3 88 21 26 D6 ?? ?? 0? ?? ?? ?? 8F A4 00 20 8F B9 00 20 02 60 20 21 02 40 28 21 02 80 30 21 02 A0 38 21 03 20 F8 09 AF B1 00 10 00 40 80 21 24 02 FF FE 27 A4 00 24 02 C0 28 21 00 00 30 21 16 02 00 05 27 A7 00 20 8E 23 00 00 24 02 00 22 10 62 00 2F 8F A3 00 60 AF B0 00 10 0? ?? ?? ?? AF A0 00 14 10 40 FF E8 24 02 00 01 12 02 00 15 8F A3 00 60 2E 02 00 02 14 40 00 47 AC 60 00 00 7C 03 E8 3B 02 E3 10 21 8C 42 00 00 24 03 00 22 10 43 00 27 24 03 FF FE 8F BF 00 4C 8F B7 00 48 8F B6 00 44 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 50 8F A2 00 60 AC 52 00 00 00 00 10 21 8F BF 00 4C 7C 03 E8 3B 02 E3 20 21 8F B6 00 44 8F B7 00 48 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C AC 82 00 00 03 E0 00 08 27 BD 00 50 24 10 FF FF 8F A3 00 60 AC 60 00 00 7C 03 E8 3B 02 E3 10 21 8C 42 00 00 24 03 00 22 14 43 FF DD 8F BF 00 4C 24 03 FF FE 12 03 FF DA 8F BF 00 4C 0? ?? ?? ?? 24 02 00 16 3C 05 ?? ?? 27 A4 00 24 24 A5 ?? ?? 00 00 30 21 0? ?? ?? ?? 27 A7 00 20 14 40 00 0B 8F BC 00 18 8F A4 00 20 3C 03 ?? ?? AC 64 ?? ?? 8F A4 00 24 3C 03 ?? ?? AC 64 ?? ?? 00 00 00 0F 24 03 00 01 0? ?? ?? ?? A2 03 ?? ?? 24 04 FF FF 3C 03 ?? ?? 0? ?? ?? ?? AC 64 ?? ?? 0? ?? ?? ?? 00 00 10 21 }
	condition:
		$1
}

rule file_843_0_0 {
	meta:
		name = "__getspnam_r"
		size = 544
		refs = "0010 __gnu_local_gp 0074 __libc_errno 007c $LC0 0088 _dl_mcount_wrapper_check 00dc __nss_next2 01d0 __nss_shadow_lookup2"
	strings:
		$1 = { 27 BD FF B0 AF B0 00 2C 3C 10 ?? ?? 92 02 ?? ?? 3C 1C ?? ?? 27 9C ?? ?? AF B5 00 40 AF B4 00 3C AF B3 00 38 AF B2 00 34 AF BF 00 4C AF B7 00 48 AF B6 00 44 AF B1 00 30 AF BC 00 18 00 80 98 21 00 A0 90 21 00 C0 A0 21 10 40 00 5D 00 E0 A8 21 3C 02 ?? ?? 8C 43 ?? ?? 3C 02 ?? ?? 8C 44 ?? ?? 24 62 00 01 AF A3 00 24 AF A4 00 20 2C 42 00 01 14 40 00 45 8F 97 ?? ?? 7C 03 E8 3B 3C 16 ?? ?? 02 E3 88 21 26 D6 ?? ?? 0? ?? ?? ?? 8F A4 00 20 8F B9 00 20 02 60 20 21 02 40 28 21 02 80 30 21 02 A0 38 21 03 20 F8 09 AF B1 00 10 00 40 80 21 24 02 FF FE 27 A4 00 24 02 C0 28 21 00 00 30 21 16 02 00 05 27 A7 00 20 8E 23 00 00 24 02 00 22 10 62 00 2F 8F A3 00 60 AF B0 00 10 0? ?? ?? ?? AF A0 00 14 10 40 FF E8 24 02 00 01 12 02 00 15 8F A3 00 60 2E 02 00 02 14 40 00 47 AC 60 00 00 7C 03 E8 3B 02 E3 10 21 8C 42 00 00 24 03 00 22 10 43 00 27 24 03 FF FE 8F BF 00 4C 8F B7 00 48 8F B6 00 44 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 50 8F A2 00 60 AC 52 00 00 00 00 10 21 8F BF 00 4C 7C 03 E8 3B 02 E3 20 21 8F B6 00 44 8F B7 00 48 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C AC 82 00 00 03 E0 00 08 27 BD 00 50 24 10 FF FF 8F A3 00 60 AC 60 00 00 7C 03 E8 3B 02 E3 10 21 8C 42 00 00 24 03 00 22 14 43 FF DD 8F BF 00 4C 24 03 FF FE 12 03 FF DA 8F BF 00 4C 0? ?? ?? ?? 24 02 00 16 3C 05 ?? ?? 27 A4 00 24 24 A5 ?? ?? 00 00 30 21 0? ?? ?? ?? 27 A7 00 20 14 40 00 0B 8F BC 00 18 8F A4 00 20 3C 03 ?? ?? AC 64 ?? ?? 8F A4 00 24 3C 03 ?? ?? AC 64 ?? ?? 00 00 00 0F 24 03 00 01 0? ?? ?? ?? A2 03 ?? ?? 24 04 FF FF 3C 03 ?? ?? 0? ?? ?? ?? AC 64 ?? ?? 0? ?? ?? ?? 00 00 10 21 }
	condition:
		$1
}

rule file_97_0_0 {
	meta:
		name = "__getsockname"
		size = 28
	strings:
		$1 = { 24 02 10 4C 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_98_0_0 {
	meta:
		name = "__openat64_2"
		size = 40
		refs = "000c __openat64 0020 __fortify_fail 0014 $LC0"
	strings:
		$1 = { 30 C2 01 00 14 40 00 03 00 00 00 00 0? ?? ?? ?? 00 00 00 00 3C 04 ?? ?? 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? 24 84 ?? ?? }
	condition:
		$1
}

rule file_944_0_0 {
	meta:
		name = "__openat_2"
		size = 40
		refs = "000c __openat 0020 __fortify_fail 0014 $LC0"
	strings:
		$1 = { 30 C2 01 00 14 40 00 03 00 00 00 00 0? ?? ?? ?? 00 00 00 00 3C 04 ?? ?? 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? 24 84 ?? ?? }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "__getlogin_r_chk"
		size = 36
		refs = "000c getlogin_r 001c __chk_fail"
	strings:
		$1 = { 00 C5 30 2B 14 C0 00 03 00 00 00 00 0? ?? ?? ?? 00 00 00 00 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_1437_0_0 {
	meta:
		name = "__getcwd_chk"
		size = 36
		refs = "000c __getcwd 001c __chk_fail"
	strings:
		$1 = { 00 C5 30 2B 14 C0 00 03 00 00 00 00 0? ?? ?? ?? 00 00 00 00 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_846_0_0 {
	meta:
		name = "__getdomainname_chk"
		size = 36
		refs = "000c getdomainname 001c __chk_fail"
	strings:
		$1 = { 00 C5 30 2B 14 C0 00 03 00 00 00 00 0? ?? ?? ?? 00 00 00 00 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_841_0_0 {
	meta:
		name = "__gethostname_chk"
		size = 36
		refs = "000c __gethostname 001c __chk_fail"
	strings:
		$1 = { 00 C5 30 2B 14 C0 00 03 00 00 00 00 0? ?? ?? ?? 00 00 00 00 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "semtimedop"
		size = 140
		refs = "0004 __gnu_local_gp 0078 __libc_errno"
	strings:
		$1 = { 27 BD FF E8 3C 1C ?? ?? 00 80 18 21 AF BE 00 14 AF B0 00 10 03 A0 F0 21 27 9C ?? ?? 27 BD FF F0 00 A0 10 21 00 E0 80 21 AF DC 00 00 AF DD 00 08 24 04 00 04 00 60 28 21 00 00 38 21 27 BD FF E0 AF A2 00 10 AF B0 00 14 24 02 10 15 00 00 00 0C 27 BD 00 20 14 E0 00 06 00 00 00 00 03 C0 E8 21 8F BE 00 14 8F B0 00 10 03 E0 00 08 27 BD 00 18 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 64 20 21 AC 82 00 00 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "__vswprintf_chk"
		size = 216
		refs = "0028 _IO_wstrn_jumps 0048 _IO_no_init 0054 _IO_fwide 007c _IO_wstr_init_static 008c _IO_vfwprintf 00d0 __chk_fail"
	strings:
		$1 = { 27 BD FD 68 00 E5 38 2B AF B0 02 88 AF BF 02 94 AF B2 02 90 AF B1 02 8C 14 E0 00 2D 00 A0 80 21 10 A0 00 29 AF A0 00 68 3C 02 ?? ?? 24 42 ?? ?? 00 80 88 21 34 05 80 00 27 A4 00 20 27 A7 01 C8 AF A2 00 10 00 C0 90 21 0? ?? ?? ?? 00 00 30 21 27 A4 00 20 0? ?? ?? ?? 24 05 00 01 1A 40 00 04 AE 20 00 00 8F A2 00 5C 34 42 00 04 AF A2 00 5C 02 20 28 21 02 20 38 21 27 A4 00 20 0? ?? ?? ?? 26 06 FF FF 8F A5 02 A8 8F A6 02 AC 0? ?? ?? ?? 27 A4 00 20 8F A3 00 7C 27 A4 00 C8 8C 65 00 18 10 A4 00 09 00 00 00 00 8C 63 00 10 AC 60 00 00 8F BF 02 94 8F B2 02 90 8F B1 02 8C 8F B0 02 88 03 E0 00 08 27 BD 02 98 0? ?? ?? ?? 24 02 FF FF 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_103_0_0 {
	meta:
		name = "__swapoff"
		size = 28
	strings:
		$1 = { 24 02 10 13 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_104_1_0 {
	meta:
		name = "gmtime"
		size = 16
		refs = "0008 __tz_convert 0000 _tmbuf"
	strings:
		$1 = { 3C 06 ?? ?? 00 00 28 21 0? ?? ?? ?? 24 C6 ?? ?? }
	condition:
		$1
}

rule file_105_0_0 {
	meta:
		name = "__rmdir"
		size = 28
	strings:
		$1 = { 24 02 0F C8 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "read_int"
		size = 140
	strings:
		$1 = { 8C 83 00 00 3C 08 0C CC 35 08 CC CD 90 62 00 00 24 63 00 01 AC 83 00 00 90 65 00 00 24 42 FF D0 3C 09 7F FF 24 A5 FF D0 2C A6 00 0A 35 29 FF FF 10 C0 00 12 00 48 38 2A 04 40 00 09 00 02 30 40 00 02 10 C0 00 C2 10 21 01 25 30 23 00 C2 30 2A 00 45 28 21 10 E0 00 0B 24 02 FF FF 00 A6 10 0A 24 63 00 01 AC 83 00 00 90 65 00 00 24 A5 FF D0 2C A6 00 0A 14 C0 FF F0 00 48 38 2A 03 E0 00 08 00 00 00 00 0? ?? ?? ?? 24 63 00 01 }
	condition:
		$1
}

rule file_106_1_0 {
	meta:
		name = "__parse_one_specmb"
		size = 1888
		refs = "0140 __printf_modifier_table 0204 __printf_function_table 028c __strchrnul 0578 __handle_registered_modifier_mb 068c __printf_arginfo_table"
	strings:
		$1 = { 27 BD FF D8 AF B2 00 20 AF B0 00 18 AF BF 00 24 AF B1 00 1C 94 C2 00 0C 24 03 00 20 24 8B 00 01 7C 02 63 04 7C 02 5A C4 7C 02 52 84 7C 02 4A 44 7C 02 42 04 7C 02 21 04 7C 02 39 C4 7C 02 29 44 24 0D FF FF AF AB 00 28 AC C3 00 10 AC CD 00 24 A4 C2 00 0C 90 82 00 01 00 C0 80 21 00 80 50 21 24 43 FF D0 2C 63 00 0A 00 A0 90 21 14 60 00 91 00 E0 60 21 01 60 18 21 3C 06 ?? ?? 24 C6 ?? ?? 24 08 00 01 24 05 00 30 24 42 FF E0 30 42 00 FF 2C 44 00 2A 10 80 00 0D 00 02 10 80 00 C2 10 21 8C 42 00 00 00 40 00 08 00 00 00 00 96 02 00 0C 7D 02 21 04 A6 02 00 0C 24 64 00 01 AF A4 00 28 90 62 00 01 14 40 FF F0 00 80 18 21 8E 02 00 0C 7C 42 06 80 10 40 00 03 24 0A FF FF 24 02 00 20 AE 02 00 10 AE 0A 00 20 AE 00 00 04 90 62 00 00 24 04 00 2A 10 44 00 85 24 42 FF D0 2C 42 00 0A 14 40 00 8F 00 00 88 21 24 0A FF FF AE 0A 00 1C AE 0A 00 00 90 64 00 00 24 02 00 2E 10 82 00 71 24 64 00 01 96 02 00 0C A6 00 00 0E 7C 02 7B C4 7C 02 73 84 7C 02 6B 44 7C 02 31 84 A6 02 00 0C 3C 02 ?? ?? 8C 42 ?? ?? 14 40 01 05 00 00 00 00 24 64 00 01 AF A4 00 28 90 62 00 00 24 42 FF B4 30 42 00 FF 2C 45 00 2F 10 A0 00 B8 3C 05 ?? ?? 00 02 10 80 24 A5 ?? ?? 00 A2 10 21 8C 42 00 00 00 40 00 08 00 00 00 00 0? ?? ?? ?? AE 05 00 10 96 02 00 0C 7D 02 52 84 0? ?? ?? ?? A6 02 00 0C 96 02 00 0C 7D 02 4A 44 0? ?? ?? ?? A6 02 00 0C 96 02 00 0C 7D 02 42 04 0? ?? ?? ?? A6 02 00 0C 96 02 00 0C 7D 02 63 04 0? ?? ?? ?? A6 02 00 0C 96 02 00 0C 7D 02 5A C4 0? ?? ?? ?? A6 02 00 0C 96 05 00 0C 24 62 00 02 00 80 18 21 7C 05 7B C4 00 A0 20 21 7C 04 6B 44 A6 04 00 0C AF A2 00 28 90 62 00 00 3C 03 ?? ?? 8C 63 ?? ?? 24 04 FF FF AE 02 00 08 14 60 01 1D AE 04 00 30 8E 04 00 08 24 02 00 01 24 03 00 64 10 83 00 FA AE 02 00 2C 28 83 00 65 10 60 01 2E 28 83 00 48 14 60 01 22 24 03 00 58 10 83 00 F3 28 83 00 59 14 60 01 09 24 03 00 61 10 83 00 E9 24 03 00 63 14 83 00 E2 00 00 00 00 AE 02 00 28 24 04 00 63 8E 03 00 24 24 02 FF FF 10 62 00 C6 00 00 00 00 10 80 00 CB 8F A2 00 28 8F A4 00 28 24 05 00 25 0? ?? ?? ?? AE 04 00 14 8F BF 00 24 AE 02 00 18 8F B2 00 20 02 20 10 21 8F B0 00 18 8F B1 00 1C 03 E0 00 08 27 BD 00 28 0? ?? ?? ?? 27 A4 00 28 10 40 00 05 8F A4 00 28 24 03 00 24 90 85 00 00 10 A3 00 77 00 00 00 00 AF AB 00 28 91 42 00 01 0? ?? ?? ?? 01 60 18 21 AF A4 00 28 90 62 00 01 24 05 00 2A 10 45 00 61 24 42 FF D0 2C 42 00 0A 14 40 00 55 00 80 18 21 0? ?? ?? ?? AE 00 00 00 24 6B 00 01 AF AB 00 28 90 62 00 01 24 42 FF D0 2C 42 00 0A 14 40 00 33 00 00 00 00 AE 12 00 20 AF AB 00 28 01 60 18 21 26 52 00 01 0? ?? ?? ?? 24 11 00 01 0? ?? ?? ?? 27 A4 00 28 10 4A FF 6F 8F A3 00 28 0? ?? ?? ?? AE 02 00 04 96 02 00 0C 00 80 18 21 24 04 00 01 7C 82 7B C4 A6 02 00 0C 0? ?? ?? ?? 24 62 00 01 96 02 00 0C 24 05 00 01 7C A2 6B 44 A6 02 00 0C 90 66 00 01 24 05 00 6C 10 C5 00 58 00 00 00 00 24 62 00 02 0? ?? ?? ?? 00 80 18 21 90 65 00 01 24 02 00 68 10 A2 00 4B 24 05 00 01 96 05 00 0C 24 62 00 02 24 03 00 01 7C 65 73 84 A6 05 00 0C 0? ?? ?? ?? 00 80 18 21 96 06 00 0C 24 05 00 01 24 62 00 02 7C A6 7B C4 00 C0 18 21 7C A3 6B 44 A6 03 00 0C 0? ?? ?? ?? 00 80 18 21 0? ?? ?? ?? 27 A4 00 28 10 40 00 1D 8F A3 00 28 24 04 00 24 90 65 00 00 14 A4 00 19 00 00 00 00 10 4A 00 06 24 44 FF FF AE 04 00 20 8D 84 00 00 00 44 28 2B 00 85 10 0B AD 82 00 00 8E 02 00 20 24 63 00 01 AF A3 00 28 04 40 FF BB 00 00 00 00 8F A3 00 28 0? ?? ?? ?? 00 00 88 21 0? ?? ?? ?? 00 80 10 21 0? ?? ?? ?? 27 A4 00 28 10 4A 00 02 00 00 00 00 AE 02 00 00 0? ?? ?? ?? 8F A3 00 28 0? ?? ?? ?? 8E 02 00 20 24 6B 00 02 AF AB 00 28 90 62 00 02 24 42 FF D0 2C 42 00 0A 14 40 00 1A 00 00 00 00 AE 12 00 1C 26 31 00 01 AF AB 00 28 01 60 18 21 0? ?? ?? ?? 26 52 00 01 24 83 00 01 10 4D 00 07 AF A3 00 28 24 45 FF FF AE 05 00 24 8D 85 00 00 00 45 30 2B 00 A6 10 0B AD 82 00 00 0? ?? ?? ?? 90 82 00 01 96 04 00 0C 24 62 00 03 7C A4 31 84 A6 04 00 0C 0? ?? ?? ?? 24 63 00 02 0? ?? ?? ?? 24 63 00 02 0? ?? ?? ?? 27 A4 00 28 10 40 00 05 24 04 00 24 8F A3 00 28 90 65 00 00 10 A4 00 06 00 00 00 00 8E 02 00 1C 04 40 FF DD 00 00 00 00 0? ?? ?? ?? 8F A3 00 28 10 4A 00 06 24 44 FF FF AE 04 00 1C 8D 84 00 00 00 44 28 2B 00 85 10 0B AD 82 00 00 8E 02 00 1C 24 63 00 01 04 41 FF F4 AF A3 00 28 0? ?? ?? ?? AE 12 00 1C 90 64 00 00 00 04 20 80 00 44 10 21 8C 42 00 00 10 40 FE F7 27 A4 00 28 0? ?? ?? ?? 02 00 28 21 14 40 FE F3 8F A3 00 28 0? ?? ?? ?? 24 62 00 01 8E 02 00 2C 10 40 FF 39 00 00 00 00 AE 12 00 24 14 80 FF 38 02 22 88 21 8F A2 00 28 8F BF 00 24 8F B2 00 20 24 42 FF FF AE 02 00 18 AE 02 00 14 02 20 10 21 8F B0 00 18 8F B1 00 1C 03 E0 00 08 27 BD 00 28 24 02 00 75 10 82 00 0E 24 02 00 78 10 82 00 0C 00 00 00 00 0? ?? ?? ?? AE 00 00 2C 28 82 00 68 10 40 FF FC 00 00 00 00 8E 02 00 0C 04 41 00 0A 24 02 00 07 24 02 01 07 0? ?? ?? ?? AE 02 00 28 8E 02 00 0C 04 41 00 06 7C 43 07 40 24 02 01 00 0? ?? ?? ?? AE 02 00 28 0? ?? ?? ?? AE 02 00 28 10 60 00 04 7C 43 07 80 24 02 02 00 0? ?? ?? ?? AE 02 00 28 10 60 00 04 7C 42 05 80 24 02 04 00 0? ?? ?? ?? AE 02 00 28 10 40 00 03 24 02 00 01 0? ?? ?? ?? AE 02 00 28 0? ?? ?? ?? AE 00 00 28 24 02 00 53 14 82 FF DB 24 02 00 04 AE 02 00 28 0? ?? ?? ?? 24 04 00 53 3C 03 ?? ?? 8C 63 ?? ?? 00 02 10 80 00 62 10 21 8C 59 00 00 13 20 FE DE 02 00 20 21 24 05 00 01 26 06 00 28 03 20 F8 09 26 07 00 30 04 40 FE D8 AE 02 00 2C 0? ?? ?? ?? 8E 04 00 08 28 82 00 45 10 40 FF CB 24 02 00 41 10 82 FF C9 24 02 00 43 14 82 FF C2 24 02 00 02 AE 02 00 28 0? ?? ?? ?? 24 04 00 43 24 02 00 6F 10 82 FF C7 28 82 00 70 14 40 00 0E 24 02 00 73 10 82 00 08 28 82 00 74 10 40 FF B1 24 02 00 70 14 82 FF B4 24 02 00 05 AE 02 00 28 0? ?? ?? ?? 24 04 00 70 24 02 00 03 AE 02 00 28 0? ?? ?? ?? 24 04 00 73 24 02 00 69 10 82 FF B5 28 82 00 6A 14 40 FF AA 24 02 00 6E 14 82 FF A6 24 02 08 00 AE 02 00 28 0? ?? ?? ?? 24 04 00 6E }
	condition:
		$1
}

rule file_107_0_0 {
	meta:
		name = "__flock"
		size = 28
	strings:
		$1 = { 24 02 10 2F 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_108_0_0 {
	meta:
		name = "putgrent"
		size = 756
		refs = "0000 __gnu_local_gp 00dc fprintf 00d0 $LC4 0104 $LC2 010c $LC1 0254 $LC3 026c __lll_lock_wait_private 0284 $LC0 02a4 __libc_errno 02c0 __overflow"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF C0 27 9C ?? ?? AF B4 00 38 AF BF 00 3C AF B3 00 34 AF B2 00 30 AF B1 00 2C AF B0 00 28 AF BC 00 18 10 80 00 9C 00 80 A0 21 10 A0 00 9A 00 A0 88 21 8C A2 00 00 30 42 80 00 14 40 00 18 00 00 00 00 7C 03 E8 3B 8C A4 00 48 24 70 8B 70 8C 82 00 08 10 50 00 0F 00 00 00 00 AF A0 00 20 C0 83 00 00 14 60 00 06 24 02 00 00 24 01 00 01 E0 81 00 00 10 20 FF FA 24 02 00 01 00 00 00 0F 10 40 00 79 00 00 00 00 8E 22 00 48 00 40 20 21 AC 50 00 08 8C 82 00 04 24 42 00 01 AC 82 00 04 8E 86 00 00 24 03 00 2B 80 C2 00 00 10 43 00 66 8E 87 00 04 24 03 00 2D 10 43 00 63 00 00 00 00 10 E0 00 6F 00 00 00 00 8E 82 00 08 3C 05 ?? ?? 02 20 20 21 AF A2 00 10 0? ?? ?? ?? 24 A5 ?? ?? 04 40 00 17 00 00 00 00 8E 82 00 0C 10 40 00 31 00 00 00 00 8C 46 00 00 10 C0 00 2E 00 00 80 21 3C 13 ?? ?? 0? ?? ?? ?? 3C 12 ?? ?? 8E 82 00 0C 00 43 18 21 8C 66 00 00 10 C0 00 26 00 00 00 00 26 62 ?? ?? 26 45 ?? ?? 00 50 28 0B 0? ?? ?? ?? 02 20 20 21 26 10 00 01 04 41 FF F4 00 10 18 80 8E 22 00 00 30 42 80 00 14 40 00 10 00 00 00 00 8E 24 00 48 8C 82 00 04 24 42 FF FF 14 40 00 0B AC 82 00 04 AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 51 00 00 00 00 24 10 FF FF 8F BF 00 3C 02 00 10 21 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 40 8E 23 00 14 8E 22 00 18 00 62 10 2B 10 40 00 3D 24 62 00 01 AE 22 00 14 24 02 00 0A 00 00 80 21 A0 62 00 00 8E 22 00 00 30 42 80 00 14 40 FF EC 8F BF 00 3C 8E 24 00 48 8C 82 00 04 24 42 FF FF 14 40 FF E6 AC 82 00 04 AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF DC 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 3C 10 E0 00 10 00 00 00 00 3C 05 ?? ?? 02 20 20 21 0? ?? ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? AF A3 00 20 8E 22 00 48 00 40 20 21 0? ?? ?? ?? AC 50 00 08 3C 07 ?? ?? 0? ?? ?? ?? 24 E7 ?? ?? 3C 07 ?? ?? 0? ?? ?? ?? 24 E7 ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 24 10 FF FF 00 62 10 21 24 03 00 16 0? ?? ?? ?? AC 43 00 00 02 20 20 21 0? ?? ?? ?? 24 05 00 0A 0? ?? ?? ?? 00 02 87 C3 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 24 10 FF FF }
	condition:
		$1
}

rule file_109_0_0 {
	meta:
		name = "svc_exit"
		size = 56
		refs = "0008 __rpc_thread_svc_pollfd 0014 free 001c __rpc_thread_svc_max_pollfd"
	strings:
		$1 = { 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? AF B0 00 18 8C 44 00 00 0? ?? ?? ?? 00 40 80 21 0? ?? ?? ?? AE 00 00 00 8F BF 00 1C 8F B0 00 18 AC 40 00 00 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_109_1_0 {
	meta:
		name = "svc_run"
		size = 380
		refs = "0000 __gnu_local_gp 002c __rpc_thread_svc_max_pollfd 0040 __libc_errno 0060 __rpc_thread_svc_pollfd 007c realloc 00e0 __poll 00fc svc_getreq_poll 0114 _libc_intl_domainname 0118 $LC1 0124 __dcgettext 012c perror 015c free 016c $LC0"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF C8 27 9C ?? ?? AF B4 00 28 AF B3 00 24 AF B2 00 20 AF B1 00 1C AF B0 00 18 AF BC 00 10 AF BF 00 34 AF B6 00 30 0? ?? ?? ?? AF B5 00 2C 8F BC 00 10 7C 03 E8 3B 00 40 90 21 8F 94 ?? ?? 00 00 88 21 00 00 80 21 02 83 A0 21 24 13 00 04 8E 55 00 00 16 A0 00 06 00 00 00 00 0? ?? ?? ?? 00 00 00 00 8C 42 00 00 10 40 00 32 8F BC 00 10 12 35 00 3B 02 00 20 21 0? ?? ?? ?? 00 15 28 C0 10 40 00 39 3C 04 ?? ?? 02 A0 B0 21 02 A0 88 21 00 40 80 21 1A A0 00 10 02 00 20 21 0? ?? ?? ?? 00 00 00 00 8C 46 00 00 02 00 18 21 00 00 38 21 8C C2 00 00 24 C6 00 08 24 63 00 08 AC 62 FF F8 84 C8 FF FC 24 E7 00 01 A4 60 FF FE 14 F5 FF F8 A4 68 FF FC 02 00 20 21 02 C0 28 21 0? ?? ?? ?? 24 06 FF FF 24 03 FF FF 10 43 00 07 00 00 00 00 10 40 FF D7 02 00 20 21 0? ?? ?? ?? 00 40 28 21 0? ?? ?? ?? 8E 55 00 00 8E 82 00 00 10 53 FF D0 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 0? ?? ?? ?? 00 40 20 21 8F BC 00 10 8F BF 00 34 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 02 00 20 21 8F B0 00 18 0? ?? ?? ?? 27 BD 00 38 0? ?? ?? ?? 02 20 B0 21 3C 05 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? }
	condition:
		$1
}

rule file_110_0_0 {
	meta:
		name = "_dl_important_hwcaps"
		size = 2200
		refs = "0004 _dl_hwcap 0024 _dl_hwcap_mask 010c _dl_sysinfo_map 0230 $LC1 02d4 $LC2 03ac malloc 0464 mempcpy 0540 $LC0 0548 memcmp 07c0 strlen 0850 $LC3 0854 $LC4 0868 __assert_fail 0858 __PRETTY_FUNCTION__.8915 0880 _dl_signal_error 0870 $LC5"
	strings:
		$1 = { 3C 03 ?? ?? 8C 63 ?? ?? 27 BD FF 88 3C 02 ?? ?? AF BE 00 70 03 A0 F0 21 8C 42 ?? ?? AF C3 00 2C 3C 03 ?? ?? 8C 63 ?? ?? AF C2 00 20 3C 02 ?? ?? 8C 42 ?? ?? AF C3 00 34 8F C3 00 20 AF C4 00 78 AF B5 00 64 8F C4 00 2C 00 43 A8 24 8F C3 00 34 AF B3 00 5C AF B0 00 50 00 64 98 24 8F C3 00 78 02 B3 80 25 AF B6 00 68 00 03 18 2B AF BF 00 74 AF B7 00 6C AF B4 00 60 AF B2 00 58 AF B1 00 54 AF C2 00 30 AF C3 00 24 AF C5 00 7C AF C6 00 80 AF C7 00 84 12 00 00 1D 00 60 B0 21 00 00 20 21 00 00 18 21 00 15 40 40 24 07 00 01 24 63 00 01 30 65 00 20 00 67 10 04 00 40 58 21 00 05 10 0B 00 05 58 0A 00 04 60 27 00 02 28 23 00 05 50 2B 00 93 10 06 01 88 60 04 00 0B 58 23 30 89 00 20 00 95 30 06 01 82 10 25 01 6A 20 23 00 95 20 24 00 C9 10 0B 00 B3 28 24 30 42 00 01 00 85 28 25 02 C2 B0 21 14 A0 FF E9 00 60 20 21 3C 02 ?? ?? 8C 42 ?? ?? 10 40 00 3C AF C2 00 1C 94 58 02 2C 13 00 00 39 8C 4B 02 24 00 00 68 21 AF D5 00 3C AF D3 00 40 AF D0 00 44 24 11 00 04 24 12 00 02 24 14 FF FC AF D6 00 38 01 60 A8 21 01 A0 98 21 0? ?? ?? ?? 03 00 80 21 26 73 00 01 02 70 10 2B 10 40 00 25 26 B5 00 20 8E A2 00 00 14 51 FF FA 8F C3 00 1C 8E A7 00 08 8E A8 00 14 8C 62 00 00 24 04 00 0C 00 E2 B8 21 00 88 10 2B 02 E0 B0 21 10 40 FF F1 26 E4 00 0C AF D0 00 18 02 E0 80 21 01 00 B8 21 8E C2 00 08 10 52 00 E4 8E C3 00 00 8E C2 00 04 24 63 00 03 24 42 00 03 00 74 18 24 00 54 10 24 00 62 10 21 24 42 00 0C 02 C2 B0 21 26 C4 00 0C 00 90 10 23 00 57 10 2B 14 40 FF F1 00 00 00 00 8F D0 00 18 26 73 00 01 02 70 10 2B 14 40 FF DD 26 B5 00 20 8F D6 00 38 8F D5 00 3C 8F D3 00 40 8F D0 00 44 26 D6 00 01 00 16 10 C0 24 42 00 08 03 A2 E8 23 AF D6 00 1C 27 B2 00 10 24 02 00 01 00 00 B8 21 12 00 01 7A 00 00 00 00 3C 07 ?? ?? 00 00 10 21 24 E7 ?? ?? 24 06 00 01 00 02 18 27 00 15 28 40 00 65 28 04 00 53 18 06 00 A3 18 25 30 44 00 20 00 55 28 06 00 A4 18 0B 30 63 00 01 10 60 00 0C 00 46 18 04 00 60 28 21 00 17 40 C0 00 04 28 0A 00 04 18 0B 02 A5 A8 26 02 48 20 21 02 63 98 26 AC 87 00 00 AC 80 00 04 26 F7 00 01 02 B3 80 25 16 00 FF E9 24 42 00 01 26 E7 00 01 AF C7 00 20 8F C3 00 24 10 60 01 1B 00 17 10 C0 8F C3 00 78 02 42 10 21 AC 43 00 00 8F C7 00 20 8F C3 00 7C AC 43 00 04 24 E3 00 01 8F C7 00 20 3C 04 ?? ?? 24 84 ?? ?? 00 07 10 C0 8F C7 00 1C 02 42 10 21 AC 44 00 00 24 04 00 03 14 E3 01 57 AC 44 00 04 8F C3 00 1C 24 02 00 01 10 62 00 D9 00 00 00 00 8E 47 00 04 2C 62 00 03 AF C7 00 18 14 40 00 1E 24 E4 00 05 00 04 20 40 24 02 00 02 24 05 00 01 0? ?? ?? ?? 00 60 30 21 00 40 28 21 00 60 10 21 00 05 18 C0 02 43 18 21 8C 65 00 04 24 43 00 01 24 A5 00 01 14 C3 FF F8 00 85 20 21 8F C7 00 1C 24 02 00 03 10 E2 00 0A 8F C3 00 20 2C E2 00 20 10 40 01 41 24 83 00 40 8F C7 00 20 24 02 00 22 00 47 10 23 00 43 10 06 14 40 01 3B 8F C3 00 20 24 62 FF FE 00 44 20 04 8F C7 00 1C 24 08 00 01 8F C3 00 80 00 E8 98 04 00 13 80 C0 AC 73 00 00 00 90 20 21 0? ?? ?? ?? AF C8 00 48 00 40 88 21 10 40 01 2D 8F C8 00 48 8F C3 00 1C 02 30 20 21 24 02 00 02 AE 24 00 00 10 62 01 12 AE 24 00 08 8F C7 00 20 8E 56 00 00 AF D1 00 24 24 F5 FF FF 00 15 10 C0 00 E8 B8 04 02 42 18 21 02 E0 88 21 24 10 00 2F AF D3 00 28 AF D2 00 2C 00 60 B8 21 24 02 00 74 24 03 00 6C 24 05 00 73 A0 82 00 00 A0 83 00 01 A0 85 00 02 A0 90 00 03 26 31 FF FE 24 84 00 04 02 E0 A0 21 02 A0 98 21 0? ?? ?? ?? 24 12 00 01 26 73 FF FF 12 60 00 0D 26 94 FF F8 02 72 28 04 00 B1 28 24 10 A0 FF FA 00 00 00 00 8E 85 00 00 8E 86 00 04 26 73 FF FF 0? ?? ?? ?? 26 94 FF F8 A0 50 00 00 16 60 FF F5 24 44 00 01 8F C6 00 18 0? ?? ?? ?? 02 C0 28 21 A0 50 00 00 16 20 FF DF 24 44 00 01 8F D1 00 24 8F D3 00 28 8F D2 00 2C 8F C7 00 1C 24 03 00 01 00 00 10 21 00 E3 18 04 10 60 00 05 00 03 20 C0 02 22 18 21 24 42 00 08 14 44 FF FD AC 60 00 04 8F C3 00 1C 24 08 00 01 24 74 FF FF 00 14 38 C0 02 47 38 21 24 E7 00 04 02 88 28 04 02 20 18 21 12 60 00 11 02 60 10 21 24 42 FF FF 00 A2 20 24 10 80 00 0B 00 00 00 00 8C E4 00 00 8C 66 00 04 24 42 FF FF 24 84 00 01 00 C4 20 21 24 63 00 08 AC 64 FF FC 00 A2 20 24 14 80 FF F7 00 00 00 00 14 40 FF F1 24 63 00 08 12 80 00 12 24 E7 FF F8 0? ?? ?? ?? 26 94 FF FF 14 71 FF 1C 3C 05 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 04 10 40 00 03 24 03 00 04 0? ?? ?? ?? 8E C2 00 04 8E C2 00 04 2C 43 00 0B 10 60 00 6F 24 03 00 04 0? ?? ?? ?? 24 63 00 03 8F C6 00 20 24 07 00 01 26 63 FF FE 00 C7 38 04 10 67 00 1C 26 22 00 10 02 20 28 21 00 40 20 21 0? ?? ?? ?? 26 29 00 08 8C A8 00 00 8C A6 00 04 24 84 00 08 24 A5 00 08 01 06 30 21 10 67 00 0B AC 86 FF F8 24 63 FF FF 30 66 00 01 14 C0 FF F6 00 91 30 23 00 C9 30 21 8C C6 FF F0 24 84 00 08 24 A5 00 08 14 67 FF F7 AC 86 FF F8 3C 04 1F FF 34 84 FF FE 02 64 20 21 00 83 20 23 00 04 20 C0 00 44 10 21 8F C7 00 20 24 05 FF F8 00 E5 28 04 00 45 20 21 8C 84 00 00 24 42 00 08 24 63 FF FF 24 84 00 04 14 60 FF FA AC 44 FF F8 8E 22 00 04 8F C3 00 84 AC 62 00 00 03 C0 E8 21 8F BF 00 74 02 20 10 21 8F BE 00 70 8F B7 00 6C 8F B6 00 68 8F B5 00 64 8F B4 00 60 8F B3 00 5C 8F B2 00 58 8F B1 00 54 8F B0 00 50 03 E0 00 08 27 BD 00 78 8E 50 00 04 8F C3 00 80 24 13 00 02 26 04 00 11 0? ?? ?? ?? AC 73 00 00 00 40 88 21 12 20 00 7A 26 02 00 01 8F C3 00 80 AE 22 00 04 8E 45 00 00 8C 62 00 00 AE 20 00 0C 8C 64 00 00 00 02 10 C0 26 23 00 10 02 22 10 21 00 04 20 C0 AE 23 00 00 02 24 20 21 02 00 30 21 0? ?? ?? ?? AE 22 00 08 24 03 00 2F A0 43 00 00 8F C3 00 80 8F C7 00 84 AC 73 00 00 8E 22 00 04 AC E2 00 00 03 C0 E8 21 8F BF 00 74 02 20 10 21 8F BE 00 70 8F B7 00 6C 8F B6 00 68 8F B5 00 64 8F B4 00 60 8F B3 00 5C 8F B2 00 58 8F B1 00 54 8F B0 00 50 03 E0 00 08 27 BD 00 78 8F C3 00 20 0? ?? ?? ?? AF D7 00 20 02 C0 B8 21 8F D6 00 38 8E E4 00 10 8E F1 00 14 26 CF 00 01 01 E4 20 21 8F C7 00 34 AF C4 00 1C 00 04 20 C0 24 84 00 08 8F C6 00 2C 03 A4 E8 23 02 27 20 25 8F C7 00 20 02 26 28 25 3C 06 ?? ?? 26 F6 00 18 24 42 FF F8 AC C5 ?? ?? AC C7 ?? ?? 8F C6 00 30 02 C2 18 21 3C 05 ?? ?? 02 C3 10 2B 8F D5 00 3C 8F D3 00 40 8F D0 00 44 27 B2 00 10 AC A6 ?? ?? AC A4 ?? ?? 10 40 00 29 00 00 B8 21 AF D3 00 18 02 E0 98 21 02 00 B8 21 02 20 80 21 00 60 88 21 26 D4 00 01 0? ?? ?? ?? 02 80 20 21 92 C4 00 00 24 07 00 01 00 87 20 04 00 90 20 24 10 80 00 2B 00 13 20 C0 02 44 20 21 AC 94 00 00 AC 82 00 04 26 73 00 01 24 56 00 01 02 96 B0 21 02 D1 10 2B 14 40 FF EF 26 62 00 01 02 E0 80 21 02 60 B8 21 16 00 FE 88 8F D3 00 18 0? ?? ?? ?? AF C2 00 20 8E 45 00 08 8E 46 00 0C 0? ?? ?? ?? 24 10 00 2F 8E 45 00 00 8F C6 00 18 A0 50 00 00 0? ?? ?? ?? 24 44 00 01 0? ?? ?? ?? A0 50 00 00 0? ?? ?? ?? 24 02 00 01 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 A6 0? ?? ?? ?? 24 E7 ?? ?? 3C 07 ?? ?? 24 04 00 0C 00 00 28 21 00 00 30 21 0? ?? ?? ?? 24 E7 ?? ?? 8F C3 00 1C 24 63 FF FF 0? ?? ?? ?? AF C3 00 1C }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "getchar_unlocked"
		size = 48
		refs = "0000 _IO_stdin 0028 __uflow"
	strings:
		$1 = { 3C 02 ?? ?? 8C 44 ?? ?? 8C 82 00 04 8C 83 00 08 00 43 18 2B 10 60 00 04 24 43 00 01 AC 83 00 04 03 E0 00 08 90 42 00 00 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_112_0_0 {
	meta:
		name = "inotify_init"
		size = 28
	strings:
		$1 = { 24 02 10 BC 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_113_0_0 {
	meta:
		name = "__mpn_mul"
		size = 996
		refs = "0064 __mpn_mul_1 0094 __mpn_addmul_1 00dc __mpn_add_n 0150 __mpn_impn_mul_n 0344 __mpn_mul"
	strings:
		$1 = { 27 BD FF A0 AF BE 00 58 03 A0 F0 21 AF B6 00 50 8F D6 00 70 AF B5 00 4C AF B3 00 44 2A C2 00 20 AF B2 00 40 AF B0 00 38 AF BF 00 5C AF B7 00 54 AF B4 00 48 AF B1 00 3C 00 80 98 21 00 A0 A8 21 00 C0 80 21 10 40 00 39 00 E0 90 21 12 C0 00 2A 00 00 10 21 8C E7 00 00 2C E2 00 02 14 40 00 57 24 02 00 01 0? ?? ?? ?? 00 10 A0 80 02 74 20 21 2A C3 00 02 AC 82 00 00 14 60 00 1F 26 71 00 04 26 42 FF FC 00 16 B0 80 00 56 B0 21 0? ?? ?? ?? 24 13 00 01 0? ?? ?? ?? 00 00 00 00 02 34 18 21 26 52 00 04 AC 62 00 00 12 56 00 13 26 31 00 04 8E 43 00 04 02 20 20 21 02 A0 28 21 2C 62 00 02 02 00 30 21 10 40 FF F3 00 60 38 21 14 73 FF F3 00 00 10 21 02 20 28 21 02 A0 30 21 0? ?? ?? ?? 02 00 38 21 26 52 00 04 02 34 18 21 AC 62 00 00 16 56 FF EF 26 31 00 04 03 C0 E8 21 8F BF 00 5C 8F BE 00 58 8F B7 00 54 8F B6 00 50 8F B5 00 4C 8F B4 00 48 8F B3 00 44 8F B2 00 40 8F B1 00 3C 8F B0 00 38 03 E0 00 08 27 BD 00 60 00 16 88 C0 26 31 00 08 03 B1 E8 23 27 A2 00 18 02 16 18 23 AF A2 00 10 00 E0 30 21 02 C0 38 21 AF C2 00 20 0? ?? ?? ?? AF C3 00 2C 8F C3 00 2C 00 16 A0 80 02 74 B8 21 00 76 10 2A 10 40 00 1E 02 B4 A8 21 14 60 00 70 8F C4 00 20 02 16 80 21 00 10 80 80 02 70 50 21 8D 42 FF FC 03 C0 E8 21 8F BF 00 5C 8F BE 00 58 8F B7 00 54 8F B6 00 50 8F B5 00 4C 8F B4 00 48 8F B3 00 44 8F B2 00 40 8F B1 00 3C 8F B0 00 38 03 E0 00 08 27 BD 00 60 10 E2 00 53 00 06 A0 80 18 C0 00 05 00 00 10 21 02 62 18 21 24 42 00 04 14 54 FF FD AC 60 00 00 0? ?? ?? ?? 00 00 10 21 03 B1 E8 23 27 B1 00 18 02 34 78 21 25 E4 00 04 00 16 28 23 AF C4 00 28 AF C5 00 24 00 76 58 23 8F C2 00 20 02 20 20 21 02 A0 28 21 02 40 30 21 02 C0 38 21 AF A2 00 10 AF CB 00 2C 0? ?? ?? ?? AF CF 00 30 02 E0 20 21 02 E0 28 21 02 20 30 21 0? ?? ?? ?? 02 C0 38 21 8F CF 00 30 02 F4 B8 21 26 E3 00 04 8D E4 00 00 8F CB 00 2C 8F C8 00 28 00 44 10 21 00 44 20 2B AE E2 00 00 14 80 00 1D 02 C0 10 21 10 68 00 0E 28 44 00 02 14 80 00 0D 8F C4 00 24 3C 05 3F FF 34 A5 FF FF 00 45 10 21 00 02 30 80 00 00 10 21 01 02 20 21 8C 85 00 00 00 62 20 21 24 42 00 04 14 46 FF FB AC 85 00 00 8F C4 00 24 01 60 18 21 01 64 58 21 02 CB 10 21 00 56 10 2A 10 40 FF D2 02 B4 A8 21 0? ?? ?? ?? 00 00 00 00 8D 09 FF FC 25 29 00 01 15 20 FF E5 AC 69 FF FC 24 42 FF FF 25 08 00 04 14 40 FF F9 24 63 00 04 8F C4 00 24 01 60 18 21 01 64 58 21 02 CB 10 21 00 56 10 2A 10 40 FF C1 02 B4 A8 21 0? ?? ?? ?? 00 00 00 00 18 C0 FF B3 00 00 10 21 02 A2 18 21 8C 64 00 00 02 62 18 21 24 42 00 04 14 54 FF FB AC 64 00 00 0? ?? ?? ?? 00 00 10 21 AF A3 00 10 02 40 28 21 02 C0 30 21 02 A0 38 21 0? ?? ?? ?? AF C3 00 2C 8F C6 00 20 02 E0 20 21 02 E0 28 21 0? ?? ?? ?? 02 C0 38 21 8F C5 00 20 02 F4 70 21 8F C3 00 2C 00 B4 20 21 8C 85 00 00 24 84 00 04 00 45 10 21 00 45 30 2B AD C2 00 00 10 C0 00 09 25 C5 00 04 24 63 FF FF 24 84 00 04 10 60 FF 78 24 A5 00 04 8C 82 FF FC 24 42 00 01 10 40 FF F9 AC A2 FF FC 10 A4 FF 72 28 62 00 02 14 40 FF 70 00 00 10 21 00 03 18 80 24 67 FF FC 00 82 18 21 8C 66 00 00 00 A2 18 21 24 42 00 04 14 47 FF FB AC 66 00 00 0? ?? ?? ?? 02 16 80 21 }
	condition:
		$1
}

rule file_114_0_0 {
	meta:
		name = "__dup"
		size = 28
	strings:
		$1 = { 24 02 0F C9 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_115_0_0 {
	meta:
		name = "__gets_chk"
		size = 632
		refs = "0024 _IO_stdin 0090 _IO_getline 0178 __lll_lock_wait_private 01d4 __uflow 01f0 __chk_fail 021c _Unwind_Resume"
	strings:
		$1 = { 27 BD FF C0 AF B3 00 34 AF BF 00 3C AF B4 00 38 AF B2 00 30 AF B1 00 2C AF B0 00 28 10 A0 00 81 00 A0 98 21 3C 12 ?? ?? 8E 50 ?? ?? 8E 02 00 00 30 42 80 00 10 40 00 35 00 80 88 21 02 00 30 21 8C C2 00 04 8C C3 00 08 00 43 18 2B 10 60 00 61 24 43 00 01 AC C3 00 04 90 42 00 00 24 03 00 0A 10 43 00 43 8E 44 ?? ?? 24 08 FF DF 26 25 00 01 8C 83 00 00 26 66 FF FF 24 07 00 0A 00 68 40 24 AC 88 00 00 A2 22 00 00 8E 44 ?? ?? AF A0 00 10 0? ?? ?? ?? 30 74 00 20 8E 44 ?? ?? 8C 85 00 00 30 A3 00 20 14 60 00 50 24 42 00 01 02 85 28 25 AC 85 00 00 00 53 98 2B 12 60 00 4D 02 22 10 21 A0 40 00 00 8E 02 00 00 30 42 80 00 14 40 00 07 8F BF 00 3C 8E 04 00 48 8C 82 00 04 24 42 FF FF 10 40 00 29 AC 82 00 04 8F BF 00 3C 02 20 10 21 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 40 7C 03 E8 3B 8E 04 00 48 24 74 8B 70 8C 82 00 08 10 54 00 10 02 00 30 21 AF A0 00 20 C0 83 00 00 14 60 00 06 24 02 00 00 24 01 00 01 E0 81 00 00 10 20 FF FA 24 02 00 01 00 00 00 0F 10 40 00 0B 00 00 00 00 8E 02 00 48 8E 46 ?? ?? 00 40 20 21 AC 54 00 08 8C 82 00 04 24 42 00 01 0? ?? ?? ?? AC 82 00 04 0? ?? ?? ?? 00 00 10 21 0? ?? ?? ?? AF A3 00 20 0? ?? ?? ?? 8E 02 00 48 AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF CF 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 3C 0? ?? ?? ?? 00 C0 20 21 24 03 FF FF 14 43 FF 9F 24 03 00 0A 0? ?? ?? ?? 00 00 88 21 0? ?? ?? ?? 00 00 00 00 8E 02 00 00 30 42 80 00 14 40 00 06 00 80 88 21 8E 04 00 48 8C 83 00 04 24 63 FF FF 10 60 00 05 AC 83 00 04 0? ?? ?? ?? 02 20 20 21 0? ?? ?? ?? 00 00 00 00 AC 80 00 08 00 00 00 0F C0 83 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 63 00 02 14 60 FF F3 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_116_0_0 {
	meta:
		name = "__ftruncate64"
		size = 60
		refs = "0010 __gnu_local_gp 0028 __libc_errno"
	strings:
		$1 = { 00 00 28 21 24 02 10 74 00 00 00 0C 14 E0 00 03 3C 1C ?? ?? 03 E0 00 08 00 00 00 00 27 9C ?? ?? 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 64 20 21 AC 82 00 00 03 E0 00 08 24 02 FF FF }
	condition:
		$1
}

rule file_117_0_0 {
	meta:
		name = "__libc_fork"
		size = 880
		refs = "0004 __gnu_local_gp 0028 __fork_handlers 00d8 _IO_list_lock 015c __fork_generation_pointer 0178 __nptl_set_robust 0190 _IO_iter_begin 01a0 _IO_iter_file 01b8 _IO_iter_next 01c4 _IO_iter_end 01d4 _IO_list_resetlock 01dc _dl_load_lock 022c __fork_lock 0260 __libc_errno 0284 _IO_list_unlock 027c $LC2 0334 $LC1 0348 __assert_fail 0338 __PRETTY_FUNCTION__.10519 0350 $LC0"
	strings:
		$1 = { 27 BD FF C8 3C 1C ?? ?? 27 9C ?? ?? AF BE 00 30 03 A0 F0 21 AF BF 00 34 AF B2 00 2C AF B1 00 28 AF B0 00 24 AF DC 00 10 3C 03 ?? ?? 8C 70 ?? ?? 12 00 00 29 00 00 88 21 00 00 00 0F 8E 02 00 14 10 40 FF FA 8C 64 ?? ?? 24 46 00 01 AF C2 00 18 24 84 00 14 C0 87 00 00 14 E2 00 06 24 05 00 00 00 C0 08 21 E0 81 00 00 10 20 FF FA 24 05 00 01 00 00 00 0F 10 A0 00 AA 00 00 90 21 0? ?? ?? ?? 8E 19 00 04 26 03 00 14 00 00 00 0F C0 61 00 00 24 21 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 00 40 90 21 8E 19 00 04 13 20 00 03 00 00 00 00 03 20 F8 09 00 00 00 00 27 BD FF F0 27 A2 00 10 AC 50 00 00 8E 10 00 00 00 40 88 21 16 00 FF EC AC 52 00 04 0? ?? ?? ?? 00 00 00 00 8F DC 00 10 7C 03 E8 3B 8C 7F 8B D8 7C 03 E8 3B 8C 70 8B DC 7C 03 E8 3B 00 10 20 23 27 BD FF F0 AC 64 8B DC 27 A2 00 10 3C 04 01 20 24 84 00 12 AF C2 00 18 00 00 28 21 00 00 30 21 00 00 38 21 7C 03 E8 3B 24 62 8B D8 27 BD FF E0 AF A2 00 10 24 02 10 18 00 00 00 0C 27 BD 00 20 14 E0 00 46 00 40 90 21 14 40 00 4A 00 00 00 00 7C 03 E8 3B 8C 65 8B D8 10 BF 00 7E 24 64 8B 70 3C 02 ?? ?? 8C 42 ?? ?? 10 40 00 04 00 00 00 00 8C 46 00 00 24 C6 00 04 AC 46 00 00 3C 02 ?? ?? 24 42 ?? ?? 10 40 00 03 AC 65 8B DC 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 00 40 80 21 0? ?? ?? ?? 02 00 20 21 8C 43 00 48 02 00 20 21 AC 60 00 00 AC 60 00 04 0? ?? ?? ?? AC 60 00 08 00 40 80 21 0? ?? ?? ?? 00 00 00 00 16 02 FF F4 00 00 00 00 0? ?? ?? ?? 24 10 00 01 3C 03 ?? ?? 24 62 ?? ?? AC 60 ?? ?? 24 03 00 01 AC 40 00 04 AC 40 00 08 AC 43 00 0C AC 40 00 10 12 20 00 0B AC 40 00 14 8E 23 00 00 8C 79 00 0C 13 20 00 04 00 00 00 00 03 20 F8 09 00 00 00 00 8E 23 00 00 8E 31 00 04 16 20 FF F7 AC 70 00 14 3C 02 ?? ?? AC 40 ?? ?? 03 C0 E8 21 8F DF 00 34 02 40 10 21 8F BE 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 38 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 AC 52 00 00 24 12 FF FF 7C 03 E8 3B 8C 62 8B D8 14 5F 00 2E 3C 04 ?? ?? 7C 03 E8 3B 0? ?? ?? ?? AC 70 8B DC 12 20 FF E9 24 10 00 01 0? ?? ?? ?? 8E 23 00 00 8E 31 00 04 12 20 FF E4 00 00 00 00 8E 23 00 00 8C 79 00 08 13 20 00 05 24 63 00 14 03 20 F8 09 00 00 00 00 8E 23 00 00 24 63 00 14 C0 62 00 00 24 41 FF FF E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 50 FF EE 00 00 00 00 8E 22 00 00 8C 43 00 18 10 60 FF EA 00 00 00 00 8C 44 00 14 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8E 31 00 04 8C 70 ?? ?? 16 00 FF 44 AF C7 00 18 0? ?? ?? ?? 00 00 88 21 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 D3 0? ?? ?? ?? 24 E7 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 8D 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_118_0_0 {
	meta:
		name = "_IO_vasprintf"
		size = 392
		refs = "0024 malloc 0048 _IO_no_init 0050 _IO_str_jumps 0068 _IO_str_init_static_internal 0090 free 00a0 _IO_vfprintf 00f4 memcpy 0138 realloc"
	strings:
		$1 = { 27 BD FF 20 AF B3 00 D8 00 80 98 21 24 04 00 64 AF B2 00 D4 AF B1 00 D0 AF B0 00 CC AF BF 00 DC 00 A0 90 21 0? ?? ?? ?? 00 C0 88 21 10 40 00 54 00 40 80 21 27 A4 00 20 34 05 80 00 24 06 FF FF 00 00 38 21 AF A0 00 10 0? ?? ?? ?? AF A0 00 68 3C 02 ?? ?? 24 42 ?? ?? 02 00 28 21 02 00 38 21 27 A4 00 20 24 06 00 64 0? ?? ?? ?? AF A2 00 B8 8F A3 00 20 24 02 FF FE 02 20 30 21 00 62 10 24 AF A2 00 20 3C 02 ?? ?? 24 42 ?? ?? AF A2 00 C0 3C 02 ?? ?? 24 42 ?? ?? 27 A4 00 20 02 40 28 21 0? ?? ?? ?? AF A2 00 C4 04 40 00 2B 00 40 88 21 8F A2 00 30 8F B0 00 34 8F A3 00 38 02 02 80 23 00 62 10 23 26 12 00 01 00 02 10 42 02 42 10 2B 10 40 00 19 8F A4 00 3C 0? ?? ?? ?? 02 40 20 21 10 40 00 21 AE 62 00 00 8F B2 00 3C 00 40 20 21 02 00 30 21 0? ?? ?? ?? 02 40 28 21 0? ?? ?? ?? 02 40 20 21 8E 63 00 00 10 60 00 10 00 00 00 00 00 70 80 21 A2 00 00 00 02 20 10 21 8F BF 00 DC 8F B3 00 D8 8F B2 00 D4 8F B1 00 D0 8F B0 00 CC 03 E0 00 08 27 BD 00 E0 0? ?? ?? ?? 02 40 28 21 00 40 18 21 14 60 FF F2 AE 62 00 00 8F A3 00 3C 0? ?? ?? ?? AE 63 00 00 0? ?? ?? ?? 8F A4 00 3C 0? ?? ?? ?? 02 20 10 21 8F A4 00 3C 0? ?? ?? ?? 02 40 28 21 AE 62 00 00 0? ?? ?? ?? 00 40 18 21 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_119_0_0 {
	meta:
		name = "getservbyport"
		size = 464
		refs = "0008 __gnu_local_gp 00a8 __getservbyport_r 00c8 realloc 00d8 free 00ec __libc_errno 0180 malloc 01c0 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF B0 3C 03 ?? ?? 3C 1C ?? ?? 27 9C ?? ?? AF B4 00 38 AF B3 00 34 00 A0 A0 21 00 80 98 21 24 64 ?? ?? AF BF 00 4C AF BE 00 48 AF B7 00 44 AF B6 00 40 AF B5 00 3C AF B2 00 30 AF B1 00 2C AF B0 00 28 AF BC 00 18 C0 82 00 00 24 41 00 01 E0 81 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 57 00 00 00 00 3C 12 ?? ?? 8E 47 ?? ?? 3C 11 ?? ?? 10 E0 00 40 8E 30 ?? ?? 3C 16 ?? ?? 26 D6 ?? ?? 24 15 00 22 0? ?? ?? ?? 3C 17 ?? ?? AE E2 ?? ?? 27 A2 00 20 AF B0 00 10 02 60 20 21 02 80 28 21 02 C0 30 21 0? ?? ?? ?? AF A2 00 14 14 55 00 16 8E 30 ?? ?? 8E 5E ?? ?? 00 10 80 40 03 C0 20 21 02 00 28 21 0? ?? ?? ?? AE 30 ?? ?? 14 40 FF EF 00 40 38 21 0? ?? ?? ?? 03 C0 20 21 8F BC 00 18 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 0C AC 43 00 00 3C 02 ?? ?? AC 40 ?? ?? 0? ?? ?? ?? AF A0 00 20 8E 42 ?? ?? 10 40 FF FC 00 00 00 00 3C 03 ?? ?? 24 64 ?? ?? 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 17 24 64 ?? ?? 8F BF 00 4C 8F A2 00 20 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 24 02 04 00 24 04 04 00 0? ?? ?? ?? AE 22 ?? ?? 10 40 FF DE AE 42 ?? ?? 00 40 38 21 0? ?? ?? ?? 24 10 04 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 4C 0? ?? ?? ?? 24 64 ?? ?? 0? ?? ?? ?? 3C 12 ?? ?? }
	condition:
		$1
}

rule file_416_0_0 {
	meta:
		name = "getservbyname"
		size = 464
		refs = "0008 __gnu_local_gp 00a8 __getservbyname_r 00c8 realloc 00d8 free 00ec __libc_errno 0180 malloc 01c0 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF B0 3C 03 ?? ?? 3C 1C ?? ?? 27 9C ?? ?? AF B4 00 38 AF B3 00 34 00 A0 A0 21 00 80 98 21 24 64 ?? ?? AF BF 00 4C AF BE 00 48 AF B7 00 44 AF B6 00 40 AF B5 00 3C AF B2 00 30 AF B1 00 2C AF B0 00 28 AF BC 00 18 C0 82 00 00 24 41 00 01 E0 81 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 57 00 00 00 00 3C 12 ?? ?? 8E 47 ?? ?? 3C 11 ?? ?? 10 E0 00 40 8E 30 ?? ?? 3C 16 ?? ?? 26 D6 ?? ?? 24 15 00 22 0? ?? ?? ?? 3C 17 ?? ?? AE E2 ?? ?? 27 A2 00 20 AF B0 00 10 02 60 20 21 02 80 28 21 02 C0 30 21 0? ?? ?? ?? AF A2 00 14 14 55 00 16 8E 30 ?? ?? 8E 5E ?? ?? 00 10 80 40 03 C0 20 21 02 00 28 21 0? ?? ?? ?? AE 30 ?? ?? 14 40 FF EF 00 40 38 21 0? ?? ?? ?? 03 C0 20 21 8F BC 00 18 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 0C AC 43 00 00 3C 02 ?? ?? AC 40 ?? ?? 0? ?? ?? ?? AF A0 00 20 8E 42 ?? ?? 10 40 FF FC 00 00 00 00 3C 03 ?? ?? 24 64 ?? ?? 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 17 24 64 ?? ?? 8F BF 00 4C 8F A2 00 20 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 24 02 04 00 24 04 04 00 0? ?? ?? ?? AE 22 ?? ?? 10 40 FF DE AE 42 ?? ?? 00 40 38 21 0? ?? ?? ?? 24 10 04 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 4C 0? ?? ?? ?? 24 64 ?? ?? 0? ?? ?? ?? 3C 12 ?? ?? }
	condition:
		$1
}

rule file_120_0_0 {
	meta:
		name = "_IO_helper_overflow"
		size = 240
		refs = "00a4 __wmemmove 00e0 __woverflow"
	strings:
		$1 = { 8C 82 00 5C 27 BD FF D0 AF B2 00 24 AF B1 00 20 8C 52 00 10 00 A0 88 21 8C 45 00 0C AF B0 00 1C AF BF 00 2C 02 45 90 23 00 12 90 83 00 80 80 21 AF B3 00 28 16 40 00 10 8C 84 01 5C 8C 43 00 10 8C 44 00 14 00 64 20 2B 10 80 00 1E 24 64 00 04 AC 44 00 10 02 20 10 21 AC 71 00 00 8F BF 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 30 8C 82 00 98 8C 59 00 1C 03 20 F8 09 02 40 30 21 24 43 FF FF 2C 63 FF FE 10 60 00 15 00 02 98 80 8E 03 00 5C 02 42 30 23 8C 64 00 0C 0? ?? ?? ?? 00 93 28 21 8E 03 00 5C 8C 64 00 10 00 60 10 21 00 93 98 23 14 60 FF DF AC 73 00 10 8F BF 00 2C 8F B3 00 28 8F B2 00 24 02 00 20 21 02 20 28 21 8F B0 00 1C 8F B1 00 20 0? ?? ?? ?? 27 BD 00 30 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_120_1_0 {
	meta:
		name = "buffered_vfprintf"
		size = 648
		refs = "0028 _IO_fwide 00a0 _IO_vfwprintf 0078 _pthread_cleanup_push_defer 00bc _IO_funlockfile 01b4 _pthread_cleanup_pop_restore 0264 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD 80 10 AF B3 7F E8 AF B2 7F E4 AF B1 7F E0 AF BF 7F EC AF B0 7F DC 00 A0 90 21 27 BD FE 38 24 05 00 01 00 80 88 21 0? ?? ?? ?? 00 C0 98 21 24 03 00 01 14 43 00 82 3C 06 00 01 34 C6 00 18 03 A6 80 21 34 04 80 18 AE 02 80 6C 3C 02 FB AD 03 A4 18 21 8E 27 00 3C 34 42 80 04 24 68 00 A0 AE 02 80 00 3C 02 ?? ?? 02 60 30 21 AE 08 80 5C 24 42 ?? ?? 27 A8 00 18 3C 13 ?? ?? 02 40 28 21 00 60 20 21 AE 11 81 5C AE 08 80 B0 AE 08 80 AC AE 03 80 B4 AE 00 80 48 AE 07 80 3C AE 02 80 98 0? ?? ?? ?? 26 73 ?? ?? 00 13 98 2B 12 60 00 71 00 40 90 21 27 A2 00 18 34 04 81 70 3C 05 ?? ?? 00 44 20 21 24 A5 ?? ?? 0? ?? ?? ?? 02 20 30 21 8E 22 00 00 30 42 80 00 14 40 00 1E 3C 02 00 01 7C 03 E8 3B 8E 24 00 48 24 70 8B 70 8C 82 00 08 10 50 00 14 34 02 81 80 27 A6 00 18 3C 03 00 01 00 C3 18 21 00 C2 28 21 00 00 10 21 AC 60 81 80 C0 86 00 00 14 C2 00 06 24 03 00 00 24 01 00 01 E0 81 00 00 10 20 FF FA 24 03 00 01 00 00 00 0F 10 60 00 4C 00 00 00 00 8E 22 00 48 00 40 20 21 AC 50 00 08 8C 82 00 04 24 42 00 01 AC 82 00 04 3C 02 00 01 27 A8 00 18 01 02 10 21 8C 42 80 5C 8C 45 00 0C 8C 50 00 10 02 05 80 23 00 10 80 83 1A 00 00 08 02 20 20 21 8E 22 00 98 8C 59 00 1C 03 20 F8 09 02 00 30 21 00 50 10 26 24 03 FF FF 00 62 90 0B 8E 22 00 00 30 42 80 00 10 40 00 10 00 00 00 00 12 60 00 05 27 A2 00 18 34 04 81 70 00 44 20 21 0? ?? ?? ?? 00 00 28 21 27 BD 01 C8 8F BF 7F EC 02 40 10 21 8F B3 7F E8 8F B2 7F E4 8F B1 7F E0 8F B0 7F DC 03 E0 00 08 27 BD 7F F0 8E 24 00 48 8C 82 00 04 24 42 FF FF 14 40 FF ED AC 82 00 04 AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF E3 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 27 BD 01 C8 8F BF 7F EC 8F B3 7F E8 8F B2 7F E4 8F B1 7F E0 8F B0 7F DC 24 02 FF FF 03 E0 00 08 27 BD 7F F0 0? ?? ?? ?? AC A6 00 00 0? ?? ?? ?? 8E 22 00 48 3C 02 ?? ?? 24 42 ?? ?? AE 02 81 70 0? ?? ?? ?? AE 11 81 74 }
	condition:
		$1
}

rule file_120_2_0 {
	meta:
		name = "_IO_vfwprintf"
		size = 18732
		refs = "0000 __gnu_local_gp 0010 __libc_errno 005c _IO_fwide 00b0 __wcschrnul 00cc _pthread_cleanup_push_defer 00d8 _IO_funlockfile 0144 __lll_lock_wait_private 023c _pthread_cleanup_pop_restore 02ec __printf_function_table 02f8 __printf_modifier_table 0304 __printf_va_arg_table 03bc _nl_current_LC_NUMERIC 05d4 _IO_wpadn 060c __btowc 0824 __strnlen 0874 __mbsrtowcs 09b4 free 0abc __parse_one_specwc 0b20 memmove 0b38 __strerror_r 0c5c __printf_fphex 0f94 __printf_fp 0fb4 $LC3 0fbc $LC4 0fcc __assert_fail 0fc0 __PRETTY_FUNCTION__.11408 2248 memset 2288 __printf_arginfo_table 23dc $LC7 24c0 __libc_fatal 23d8 $LC8 28b8 __wcsnlen 2930 _itowa_lower_digits 2a5c _itowa 3030 __woverflow 33d4 $LC5 34e0 _itowa_upper_digits 3508 null 3524 __wcslen 3534 __readonly_area 3fd4 $LC6 361c __libc_alloca_cutoff 362c malloc 3644 $LC2 368c $LC1 3d88 strlen"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD EF 00 27 9C ?? ?? AF B2 10 E0 8F 92 ?? ?? 7C 03 E8 3B AF B4 10 E8 02 43 A0 21 8E 88 00 00 AF BE 10 F8 AF B0 10 D8 03 A0 F0 21 00 A0 80 21 24 05 00 01 AF B7 10 F4 AF B3 10 E4 AF B1 10 DC AF BF 10 FC AF B6 10 F0 AF B5 10 EC AF DC 00 18 00 80 B8 21 00 C0 98 21 0? ?? ?? ?? AF C8 10 20 00 40 88 21 24 02 00 01 16 22 00 8E 00 00 00 00 8E E2 00 00 30 43 00 08 14 60 08 44 34 42 00 20 12 00 00 86 02 E0 20 21 0? ?? ?? ?? 24 05 00 01 14 51 00 84 00 00 00 00 8E F1 00 00 32 22 00 02 14 40 00 53 02 00 20 21 24 05 00 25 0? ?? ?? ?? AF D3 10 14 00 40 A0 21 32 22 80 00 AF D4 10 18 14 40 00 27 00 00 A8 21 3C 02 ?? ?? 24 42 ?? ?? 10 40 0A B8 3C 05 ?? ?? 27 C4 0F F0 24 A5 ?? ?? 0? ?? ?? ?? 02 E0 30 21 8E F1 00 00 24 15 00 01 32 31 80 00 16 20 00 1A 00 00 00 00 7C 03 E8 3B 8E E4 00 48 24 71 8B 70 8C 82 00 08 10 51 00 11 00 00 00 00 AF C0 00 20 C0 83 00 00 14 60 00 06 24 02 00 00 24 01 00 01 E0 81 00 00 10 20 FF FA 24 02 00 01 00 00 00 0F 14 40 00 03 00 00 00 00 0? ?? ?? ?? AF C3 00 20 8E E2 00 48 00 40 20 21 AC 51 00 08 8C 82 00 04 24 42 00 01 AC 82 00 04 8E E2 00 98 02 90 88 23 00 11 88 83 8C 59 00 1C 02 E0 20 21 02 00 28 21 03 20 F8 09 02 20 30 21 12 22 00 56 8F DC 00 18 24 11 FF FF 8E E2 00 00 30 42 80 00 14 40 00 06 00 00 00 00 8E E4 00 48 8C 82 00 04 24 42 FF FF 10 40 00 27 AC 82 00 04 16 A0 00 20 00 00 00 00 02 20 10 21 03 C0 E8 21 8F BF 10 FC 8F BE 10 F8 8F B7 10 F4 8F B6 10 F0 8F B5 10 EC 8F B4 10 E8 8F B3 10 E4 8F B2 10 E0 8F B1 10 DC 8F B0 10 D8 03 E0 00 08 27 BD 11 00 02 E0 20 21 02 00 28 21 0? ?? ?? ?? 02 60 30 21 03 C0 E8 21 8F BF 10 FC 8F BE 10 F8 8F B7 10 F4 8F B6 10 F0 8F B5 10 EC 8F B4 10 E8 8F B3 10 E4 8F B2 10 E0 8F B1 10 DC 8F B0 10 D8 03 E0 00 08 27 BD 11 00 27 C4 0F F0 0? ?? ?? ?? 00 00 28 21 0? ?? ?? ?? 02 20 10 21 AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF D1 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 12 A0 FF CA 00 00 00 00 0? ?? ?? ?? 27 C4 0F F0 24 02 00 16 AE 82 00 00 03 C0 E8 21 8F DF 10 FC 8F BE 10 F8 8F B7 10 F4 8F B6 10 F0 8F B5 10 EC 8F B4 10 E8 8F B3 10 E4 8F B2 10 E0 8F B1 10 DC 8F B0 10 D8 24 02 FF FF 03 E0 00 08 27 BD 11 00 8F C2 10 18 8C 43 00 00 10 60 FF A9 3C 04 ?? ?? 8C 83 ?? ?? 14 60 01 C6 3C 03 ?? ?? 8C 63 ?? ?? 14 60 01 C3 3C 03 ?? ?? 8C 63 ?? ?? 14 60 01 C0 24 08 FF FF AF C0 10 58 AF C0 10 60 AF C0 10 38 AF C8 10 30 AF C0 10 5C 8C 48 00 04 24 42 00 04 AF C2 10 18 25 03 FF E0 AF C8 10 28 24 08 FF FF AF C8 10 4C 3C 02 ?? ?? 24 08 00 20 2C 64 00 5B 00 00 B0 21 27 C9 0F C0 AF C0 10 7C AF C0 10 78 AF C0 10 70 AF C0 10 74 AF C0 10 80 AF C0 10 54 AF C0 10 68 AF C0 10 50 AF C0 10 84 AF C0 10 64 AF C0 10 88 AF C8 10 6C 10 80 00 0A 24 42 ?? ?? 3C 02 ?? ?? 24 42 ?? ?? 00 62 18 21 90 63 00 00 3C 02 ?? ?? 24 42 ?? ?? 00 03 18 80 00 62 10 21 8C 42 00 00 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 64 18 21 AF C3 10 B8 00 40 00 08 00 00 00 00 8F C2 10 18 8C 48 00 04 24 42 00 04 AF C2 10 18 25 02 FF E0 2C 43 00 5B 10 60 01 76 AF C8 10 28 3C 03 ?? ?? 24 63 ?? ?? 00 43 10 21 90 42 00 00 3C 04 ?? ?? 24 84 ?? ?? 00 02 10 80 00 44 10 21 AF C0 10 50 8C 42 00 00 00 40 00 08 AF C0 10 54 8F C2 10 18 8C 48 00 04 24 42 00 04 AF C2 10 18 25 02 FF E0 2C 43 00 5B 10 60 08 5A AF C8 10 28 3C 03 ?? ?? 24 63 ?? ?? 00 43 10 21 90 42 00 00 24 08 00 01 AF C8 10 50 AF C8 10 54 3C 03 ?? ?? 00 02 10 80 24 63 ?? ?? 00 43 10 21 8C 42 00 00 00 40 00 08 00 00 00 00 8E E2 00 5C 10 40 0D 36 02 E0 20 21 8C 43 00 10 8C 44 00 14 00 64 20 2B 10 80 0D 30 24 64 00 04 AC 44 00 10 24 02 00 25 AC 62 00 00 3C 02 7F FF 34 42 FF FF 12 22 01 4E 26 23 00 01 AF D3 10 54 16 C0 0F 10 02 C0 20 21 8F D3 10 18 24 05 00 25 AF C3 10 D0 26 73 00 04 02 60 20 21 0? ?? ?? ?? AF D3 10 18 8F C3 10 D0 04 60 0E FE AF C2 10 18 8E E5 00 98 00 53 30 23 02 E0 20 21 8C B9 00 1C 00 06 30 83 02 60 28 21 03 20 F8 09 AF C3 10 D0 8F C4 10 18 8F DC 00 18 00 00 B0 21 00 93 28 23 00 05 28 83 14 45 01 32 8F C3 10 D0 3C 05 7F FF 34 A5 FF FF 00 A3 28 23 00 A2 28 2A 14 A0 07 11 00 00 00 00 8C 85 00 00 10 A0 01 2A 00 62 88 21 8F C8 10 38 00 80 10 21 8F D3 10 54 25 08 00 01 0? ?? ?? ?? AF C8 10 38 8E E2 00 3C 30 42 00 04 10 40 00 05 8F C8 10 54 8F C8 10 60 11 00 0E 8E 00 00 00 00 8F C8 10 54 11 00 10 A9 8F C8 10 84 8E 62 00 00 00 11 1F C3 26 73 00 04 AC 43 00 00 AF D3 10 54 AC 51 00 04 0? ?? ?? ?? 02 20 18 21 8F C8 10 50 15 00 00 40 8F C8 10 64 8F C3 10 64 8F C8 10 70 24 63 FF FF 15 00 00 10 AF C3 10 28 18 60 00 0E 00 60 30 21 02 E0 20 21 0? ?? ?? ?? 24 05 00 20 24 03 FF FF 10 43 01 01 3C 03 7F FF 34 63 FF FF 02 23 20 2B 10 80 0D 78 00 71 18 23 00 62 18 2B 14 60 06 DF 00 51 88 21 92 64 00 03 26 73 00 04 0? ?? ?? ?? AF D3 10 54 8E E3 00 5C 10 60 10 97 02 E0 20 21 8C 64 00 10 8C 65 00 14 00 85 28 2B 10 A0 10 91 24 85 00 04 AC 65 00 10 24 03 FF FF 10 43 00 EA AC 82 00 00 3C 13 7F FF 36 73 FF FF 12 33 00 E6 8F C8 10 70 11 00 FF 98 26 23 00 01 8F C8 10 28 19 00 FF 95 02 E0 20 21 24 05 00 20 01 00 30 21 0? ?? ?? ?? AF C3 10 D0 24 04 FF FF 10 44 00 DA 8F C3 10 D0 00 73 20 2B 10 80 0D 53 3C 04 ?? ?? 26 64 FF FF 00 91 20 23 00 82 20 2B 10 80 FF 86 00 43 18 21 0? ?? ?? ?? 00 00 00 00 8F C8 10 64 25 07 FF FF 8F C8 10 70 15 00 00 12 00 00 00 00 18 E0 00 10 00 E0 30 21 02 E0 20 21 24 05 00 20 0? ?? ?? ?? AF C7 10 C0 24 03 FF FF 10 43 00 C2 8F C7 10 C0 3C 03 7F FF 34 63 FF FF 02 23 20 2B 10 80 0D 38 00 71 18 23 00 62 18 2B 14 60 06 9F 00 51 88 21 8E E2 00 5C 26 63 00 04 AF C3 10 54 10 40 0E B5 8E 65 00 00 8C 43 00 10 8C 44 00 14 00 64 20 2B 10 80 0E B0 24 64 00 04 AC 44 00 10 24 02 FF FF 10 A2 00 AC AC 65 00 00 3C 13 7F FF 36 73 FF FF 12 33 00 A8 8F C8 10 70 11 00 FF 5A 26 23 00 01 18 E0 FF 58 02 E0 20 21 24 05 00 20 0? ?? ?? ?? 00 E0 30 21 24 03 00 10 AF C3 10 50 8F C8 10 54 11 00 08 DD 8F C8 10 84 26 73 00 07 24 02 FF F8 02 62 10 24 8C 4A 00 00 8C 45 00 04 24 42 00 08 AF C2 10 54 AF C0 10 74 AF C0 10 78 00 00 58 21 8F C8 10 4C 05 00 0D 5C 01 45 18 25 15 00 0D 56 24 08 00 20 14 60 08 9F AF C3 10 68 8F C8 10 50 24 02 00 08 11 02 0E 35 8F C8 10 7C 24 08 00 20 01 20 98 21 AF C8 10 6C 8F C3 10 68 0? ?? ?? ?? 00 03 50 2B 8E 69 00 00 26 63 00 04 AF C3 10 54 11 20 0B 3D 8F C8 10 50 15 00 08 E0 8F C8 10 4C 8F C8 10 28 24 02 00 53 11 02 08 DC 8F C8 10 4C 24 02 FF FF AF C9 10 00 11 02 0D 5A 01 20 20 21 0? ?? ?? ?? 01 00 28 21 00 40 30 21 00 06 98 80 34 02 80 01 02 62 10 2B 10 40 0D 46 02 60 20 21 26 62 00 0E 00 02 10 C2 00 02 10 C0 03 A2 E8 23 27 A9 00 18 00 00 50 21 01 20 20 21 27 C5 10 00 27 C7 0F C0 AF C9 10 CC AF CA 10 C8 AF C0 0F C0 0? ?? ?? ?? AF C0 0F C4 00 40 98 21 24 02 FF FF 8F C9 10 CC 12 62 00 57 8F CA 10 C8 8F C8 10 64 01 13 38 23 04 E0 0A D6 8F C8 10 70 15 00 00 16 00 00 00 00 10 E0 00 14 00 E0 30 21 02 E0 20 21 24 05 00 20 AF C7 10 C0 AF C9 10 CC 0? ?? ?? ?? AF CA 10 C8 24 03 FF FF 8F C7 10 C0 8F C9 10 CC 10 43 00 44 8F CA 10 C8 3C 03 7F FF 34 63 FF FF 02 23 20 2B 10 80 0C BA 00 71 18 23 00 62 18 2B 14 60 06 21 00 51 88 21 06 20 0A B5 01 20 28 21 8E E2 00 98 02 E0 20 21 8C 59 00 1C 02 60 30 21 AF C7 10 C0 AF C9 10 CC 03 20 F8 09 AF CA 10 C8 8F C7 10 C0 8F C9 10 CC 16 62 00 2E 8F CA 10 C8 3C 0B 7F FF 35 6B FF FF 01 71 10 23 00 53 10 2B 14 40 06 0D 8F C8 10 70 11 00 00 17 02 33 18 21 10 E0 00 15 02 E0 20 21 24 05 00 20 00 E0 30 21 AF C3 10 D0 AF C9 10 CC AF CA 10 C8 0? ?? ?? ?? AF CB 10 D4 24 04 FF FF 8F C3 10 D0 8F C9 10 CC 8F CA 10 C8 10 44 00 17 8F CB 10 D4 00 6B 20 2B 10 80 0C 90 3C 04 ?? ?? 01 63 20 23 00 82 20 2B 14 80 05 F5 00 43 18 21 11 40 FE C2 01 20 20 21 0? ?? ?? ?? AF C3 10 D0 0? ?? ?? ?? 8F C3 10 D0 AF C0 10 50 AF C0 10 54 8F C8 10 28 15 00 00 16 00 00 00 00 7C 03 E8 3B 02 43 10 21 24 03 00 16 AC 43 00 00 24 11 FF FF 8F C8 10 58 15 00 01 2E 00 00 00 00 12 C0 FD E5 00 00 00 00 0? ?? ?? ?? 02 C0 20 21 0? ?? ?? ?? 8E E2 00 00 24 08 FF FF AF C0 10 58 AF C0 10 60 AF C0 10 38 00 00 B0 21 AF C8 10 30 AF C0 10 5C 27 BD F9 78 27 A8 00 18 AF C8 10 44 16 C0 0C 35 AF C0 10 10 8F C8 10 30 24 02 FF FF 11 02 06 9F 00 00 00 00 8E 96 00 00 12 C0 06 BA AF D4 10 18 24 16 00 34 00 00 50 21 00 00 48 21 24 03 06 80 02 80 20 21 AF D5 10 24 AF D4 10 34 AF D1 10 2C AF D0 10 3C 02 C0 88 21 AF C0 10 40 01 40 40 21 00 60 B0 21 00 00 A0 21 8F D5 10 44 01 20 80 21 0? ?? ?? ?? AF D2 10 48 02 20 40 21 02 40 20 21 26 31 00 34 02 A8 90 21 02 00 28 21 02 40 30 21 0? ?? ?? ?? 27 C7 10 10 8E 52 00 18 02 02 80 21 26 94 00 01 8E 42 00 00 10 40 05 B3 AF D2 10 18 02 36 10 2B 14 40 FF F0 00 16 10 40 24 03 FF F0 24 42 00 0F 00 43 10 24 24 44 00 08 03 A4 E8 23 27 A8 00 18 01 02 20 21 02 A4 20 26 00 56 B0 21 02 C4 10 0A 02 A0 28 21 01 00 20 21 02 20 30 21 01 00 A8 21 0? ?? ?? ?? 00 40 B0 21 0? ?? ?? ?? 02 20 40 21 8F C4 10 20 27 C5 00 20 0? ?? ?? ?? 24 06 0F A0 00 40 48 21 AF D3 10 54 0? ?? ?? ?? AF C0 10 50 24 03 00 0A 0? ?? ?? ?? AF C3 10 50 24 08 00 08 0? ?? ?? ?? AF C8 10 50 8F C8 10 54 11 00 0D A6 8F C8 10 84 24 02 FF F8 26 63 00 07 00 62 18 24 8C 62 00 00 24 68 00 08 AF C8 10 54 00 02 5F C2 11 60 00 05 8C 65 00 04 00 05 28 23 00 05 18 2B 00 02 10 23 00 43 10 23 24 03 00 0A 00 40 50 21 0? ?? ?? ?? AF C3 10 50 8F C8 10 54 24 03 00 01 26 67 00 07 00 08 13 C0 8F C8 10 68 AF C0 0F CC 02 E0 20 21 7D 02 73 84 8F C8 10 50 27 C5 0F C0 27 C6 10 08 7D 02 6B 44 8F C8 10 7C 7D 02 63 04 8F C8 10 78 7D 02 5A C4 8F C8 10 70 7D 02 52 84 8F C8 10 74 7D 02 4A 44 8F C8 10 80 7D 02 42 04 8F C8 10 4C 7C 62 29 44 24 03 FF F8 00 E3 38 24 A7 C2 0F CC 8C E2 00 00 8C E3 00 04 AF C8 0F C0 8F C8 10 64 24 E7 00 08 AF C2 10 00 AF C8 0F C4 8F C8 10 28 27 C2 10 00 AF C7 10 54 AF C8 0F C8 8F C8 10 6C AF C3 10 04 AF C2 10 08 0? ?? ?? ?? AF C8 0F D0 04 40 FF 60 3C 03 7F FF 34 63 FF FF 02 23 20 2B 10 80 0D 6F 00 71 18 23 00 62 20 2B 10 80 FE 0D 02 22 18 21 0? ?? ?? ?? 00 00 00 00 8E 6A 00 00 26 73 00 04 11 40 0A 77 AF D3 10 54 24 08 00 78 AF C8 10 28 24 03 00 10 24 08 00 01 AF C0 10 80 AF C8 10 7C AF C3 10 50 00 00 58 21 8F C8 10 4C 05 00 08 C9 00 00 00 00 15 00 08 89 24 08 00 20 15 40 08 87 00 00 00 00 8F C3 10 50 24 02 00 08 10 62 0A 5D 8F C8 10 7C 24 08 00 20 01 20 98 21 AF C8 10 6C 8F C8 10 4C 01 33 18 23 00 03 10 83 00 48 10 2A 14 40 00 0F 00 00 00 00 11 40 00 0D 00 00 00 00 8F C8 10 7C 11 00 00 0A 8F C8 10 4C 8F C8 10 50 24 02 00 08 15 02 00 06 8F C8 10 4C 24 02 00 30 AE 62 FF FC 26 73 FF FC 01 33 18 23 8F C8 10 4C 00 03 18 83 AF C3 10 68 00 03 18 23 00 68 10 21 8F C8 10 70 28 44 00 00 00 04 10 0B AF C3 10 80 15 00 06 12 AF C2 10 4C 8F C8 10 64 00 62 30 23 11 40 00 08 00 C8 30 21 8F C8 10 7C 11 00 00 06 8F C8 10 78 8F C3 10 50 24 C2 FF FE 38 64 00 10 00 44 30 0A 8F C8 10 78 01 0B 10 25 8F C8 10 74 00 48 10 25 8F C8 10 6C 00 02 10 2B 00 C2 30 23 24 02 00 20 11 02 04 DB 00 00 00 00 11 60 07 60 8F C8 10 74 8E E2 00 5C 10 40 0B D7 02 E0 20 21 8C 44 00 10 8C 45 00 14 00 85 28 2B 10 A0 0B D1 24 85 00 04 AC 45 00 10 24 02 00 2D AC 82 00 00 3C 02 7F FF 34 42 FF FF 12 22 FE F9 26 31 00 01 11 40 00 07 8F C3 10 4C 8F C8 10 7C 11 00 00 04 24 02 00 10 8F C3 10 50 10 62 0A AA 8F C3 10 4C 00 C3 30 21 18 C0 00 0E 02 E0 20 21 0? ?? ?? ?? 24 05 00 30 24 04 FF FF 10 44 FE E9 3C 04 7F FF 34 84 FF FF 02 24 28 2B 10 A0 0C F8 00 00 00 00 00 91 20 23 00 82 20 2B 14 80 04 C6 00 51 88 21 06 20 09 72 8F C6 10 68 8E E2 00 98 02 E0 20 21 8C 59 00 1C 03 20 F8 09 02 60 28 21 8F C8 10 68 15 02 FE D7 3C 02 7F FF 34 42 FF FF 00 51 10 23 00 48 10 2A 10 40 FD 86 02 28 18 21 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 01 00 20 21 0? ?? ?? ?? 00 00 00 00 24 08 00 0A AF C8 10 3C 8F C8 10 94 11 00 07 F9 24 02 00 34 8F C8 10 38 8F C3 10 44 71 02 20 02 00 83 10 21 10 40 0A 47 8F C8 10 34 8C 42 00 24 AF C0 10 90 00 02 10 C0 01 02 10 21 8C 4A 00 00 8C 45 00 04 AF C0 10 8C 00 00 58 21 8F C8 10 24 05 00 0A 4A 01 45 18 25 15 00 0A 44 24 08 00 20 14 60 07 2B AF C3 10 94 8F C8 10 3C 24 02 00 08 11 02 08 35 8F C8 10 A4 24 08 00 20 01 20 18 21 AF C8 10 98 8F C8 10 94 0? ?? ?? ?? 00 08 50 2B 24 03 00 08 0? ?? ?? ?? AF C3 10 3C 24 08 00 10 0? ?? ?? ?? AF C8 10 3C 8F C8 10 38 24 05 00 34 8F C2 10 44 71 05 18 02 00 62 28 21 10 A0 0A 90 8F C8 10 34 8C A2 00 24 02 E0 20 21 00 02 10 C0 01 02 10 21 27 C6 10 0C 0? ?? ?? ?? AF C2 10 0C 04 40 FE 92 3C 03 7F FF 34 63 FF FF 02 23 20 2B 14 80 02 53 00 71 18 23 3C 04 ?? ?? 24 84 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 A5 ?? ?? 24 06 07 E3 0? ?? ?? ?? 24 E7 ?? ?? 8F C8 10 38 24 05 00 34 8F C2 10 44 71 05 18 02 00 62 28 21 10 A0 0B 1C 8F C8 10 34 8C A2 00 24 02 E0 20 21 00 02 10 C0 01 02 10 21 }
	condition:
		$1
}

rule file_120_3_0 {
	meta:
		name = "read_int"
		size = 116
	strings:
		$1 = { 8C 83 00 00 3C 08 0C CC 3C 0A 7F FF 8C 62 00 00 35 08 CC CD 24 63 00 04 24 42 FF D0 24 0B 00 0A 35 4A FF FF 8C 65 00 00 24 A5 FF D0 2C A6 00 0A 10 C0 00 0E 00 48 38 2A 04 40 00 0A 00 00 00 00 10 E0 00 07 01 45 48 23 70 4B 30 02 24 02 FF FF 01 26 48 2A 00 C5 28 21 0? ?? ?? ?? 00 A9 10 0A 24 02 FF FF 0? ?? ?? ?? 24 63 00 04 03 E0 00 08 AC 83 00 00 }
	condition:
		$1
}

rule file_120_4_0 {
	meta:
		name = "group_number"
		size = 292
		refs = "0064 mempcpy"
	strings:
		$1 = { 27 BD FF C8 AF BE 00 30 AF B2 00 28 AF BF 00 34 AF B3 00 2C AF B1 00 24 AF B0 00 20 80 D0 00 00 03 A0 F0 21 00 C0 90 21 26 03 FF FF 30 63 00 FF 2C 63 00 7E 00 80 40 21 10 60 00 31 00 80 10 21 00 A4 30 23 24 C2 00 0E 00 02 10 C2 00 02 10 C0 03 A2 E8 23 27 B1 00 10 00 A0 98 21 02 20 20 21 01 00 28 21 0? ?? ?? ?? AF C7 00 18 8F C7 00 18 26 52 00 01 02 60 28 21 24 06 00 7F 02 22 18 2B 24 42 FF FC 26 10 FF FF 10 60 00 1C 02 22 40 2B 8C 44 00 00 24 A3 FF FC 16 00 00 16 AC A4 FF FC 11 00 00 14 00 00 00 00 AC A7 FF F8 82 50 00 00 12 06 00 03 24 A3 FF F8 06 01 00 09 00 00 00 00 24 42 FF FC 8C 45 00 00 24 63 FF FC 02 22 20 2B 14 80 FF FB AC 65 00 00 0? ?? ?? ?? 00 60 10 21 12 00 00 03 00 00 00 00 0? ?? ?? ?? 26 52 00 01 82 50 FF FF 0? ?? ?? ?? 00 60 28 21 00 A0 10 21 03 C0 E8 21 8F BF 00 34 8F BE 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_120_5_0 {
	meta:
		name = "_i18n_number_rewrite"
		size = 452
		refs = "0004 __gnu_local_gp 0010 $LC0 004c __wctrans 005c __towctrans 008c __libc_alloca_cutoff 00b8 malloc 00d0 mempcpy 00e8 _nl_current_LC_CTYPE 017c free"
	strings:
		$1 = { 27 BD FF B8 3C 1C ?? ?? AF B7 00 3C 00 80 B8 21 3C 04 ?? ?? 27 9C ?? ?? AF BE 00 40 24 84 ?? ?? 03 A0 F0 21 AF BF 00 44 AF DC 00 10 AF B6 00 38 AF B4 00 30 00 C0 B0 21 AF B3 00 2C AF B1 00 24 00 A0 98 21 AF B0 00 20 AF B5 00 34 0? ?? ?? ?? AF B2 00 28 00 40 A0 21 24 04 00 2E 0? ?? ?? ?? 00 40 28 21 24 04 00 2C 02 80 28 21 00 40 80 21 0? ?? ?? ?? 02 77 98 23 34 03 80 01 02 63 18 2B 00 40 88 21 14 60 00 04 24 02 00 01 0? ?? ?? ?? 02 60 20 21 00 02 10 2B 10 40 00 07 00 40 A8 21 26 62 00 0E 00 02 10 C2 00 02 10 C0 03 A2 E8 23 0? ?? ?? ?? 27 B2 00 10 0? ?? ?? ?? 02 60 20 21 10 40 00 32 00 40 90 21 02 40 20 21 02 E0 28 21 0? ?? ?? ?? 02 60 30 21 8F DC 00 10 7C 03 E8 3B 00 60 20 21 00 40 18 21 8F 82 ?? ?? 26 C6 FF FC 24 09 FF FD 00 44 20 21 8C 84 00 00 24 05 00 2C 24 63 FF FC 00 72 38 2B 14 E0 00 1A 24 C2 00 04 8C 67 00 00 24 E8 FF D0 2D 08 00 0A 11 00 00 08 00 00 00 00 8C 82 00 00 24 E7 00 0B 00 07 38 80 00 47 38 21 8C E2 00 04 0? ?? ?? ?? AC C2 00 00 12 80 00 04 00 00 00 00 00 E9 10 24 10 45 00 03 00 00 00 00 0? ?? ?? ?? AC C7 00 00 38 E2 00 2E 02 00 38 21 02 22 38 0B AC C7 00 00 0? ?? ?? ?? 24 C6 FF FC 16 A0 00 06 02 40 20 21 0? ?? ?? ?? AF C2 00 18 0? ?? ?? ?? 8F C2 00 18 02 E0 10 21 03 C0 E8 21 8F DF 00 44 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_121_0_0 {
	meta:
		name = "__sched_setparam"
		size = 28
	strings:
		$1 = { 24 02 10 3E 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_122_0_0 {
	meta:
		name = "__vswscanf"
		size = 144
		refs = "0000 _IO_wstr_jumps 003c _IO_no_init 0048 _IO_fwide 005c _IO_wstr_init_static 0070 _IO_vfwscanf"
	strings:
		$1 = { 3C 02 ?? ?? 27 BD FE 68 24 42 ?? ?? 27 A7 00 20 AF B2 01 90 AF B1 01 8C AF B0 01 88 00 80 90 21 00 A0 88 21 00 C0 80 21 27 A4 00 E0 00 00 30 21 AF A2 00 10 34 05 80 00 AF BF 01 94 0? ?? ?? ?? AF A0 01 28 27 A4 00 E0 0? ?? ?? ?? 24 05 00 01 27 A4 00 E0 02 40 28 21 00 00 30 21 0? ?? ?? ?? 00 00 38 21 27 A4 00 E0 02 20 28 21 02 00 30 21 0? ?? ?? ?? 00 00 38 21 8F BF 01 94 8F B2 01 90 8F B1 01 8C 8F B0 01 88 03 E0 00 08 27 BD 01 98 }
	condition:
		$1
}

rule file_123_0_0 {
	meta:
		name = "insque"
		size = 48
	strings:
		$1 = { 10 A0 00 08 00 00 00 00 8C A2 00 00 10 40 00 02 AC A4 00 00 AC 44 00 04 AC 82 00 00 03 E0 00 08 AC 85 00 04 AC 80 00 00 03 E0 00 08 AC 80 00 04 }
	condition:
		$1
}

rule file_123_1_0 {
	meta:
		name = "remque"
		size = 36
	strings:
		$1 = { 8C 83 00 00 10 60 00 02 8C 82 00 04 AC 62 00 04 10 40 00 02 00 00 00 00 AC 43 00 00 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_124_0_0 {
	meta:
		name = "strcat"
		size = 60
	strings:
		$1 = { 00 80 10 21 0? ?? ?? ?? 00 80 18 21 00 C0 18 21 80 67 00 00 14 E0 FF FD 24 66 00 01 24 63 FF FF 24 A5 00 01 80 A6 FF FF 24 63 00 01 14 C0 FF FC A0 66 00 00 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_125_0_0 {
	meta:
		name = "__libc_tcdrain"
		size = 188
		refs = "0000 __gnu_local_gp 0044 __libc_errno 0064 __libc_enable_asynccancel 00ac __libc_disable_asynccancel"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF D8 27 9C ?? ?? AF BF 00 24 AF B0 00 20 AF BC 00 10 7C 03 E8 3B 8C 62 8B 70 14 40 00 10 24 05 54 05 24 06 00 01 24 02 0F D6 00 00 00 0C 10 E0 00 08 8F BF 00 24 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 64 20 21 AC 82 00 00 24 02 FF FF 8F BF 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 28 0? ?? ?? ?? AF A4 00 18 00 40 F8 21 8F BC 00 10 8F A4 00 18 24 05 54 05 24 06 00 01 24 02 0F D6 00 00 00 0C 10 E0 00 07 00 40 80 21 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 24 10 FF FF 00 64 20 21 AC 82 00 00 03 E0 20 21 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 02 00 10 21 }
	condition:
		$1
}

rule file_72_0_2 {
	meta:
		name = "__libc_tcdrain"
		size = 188
		refs = "0000 __gnu_local_gp 0044 errno 0064 __pthread_enable_asynccancel 00ac __pthread_disable_asynccancel"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF D8 27 9C ?? ?? AF BF 00 24 AF B0 00 20 AF BC 00 10 7C 03 E8 3B 8C 62 8B 70 14 40 00 10 24 05 54 05 24 06 00 01 24 02 0F D6 00 00 00 0C 10 E0 00 08 8F BF 00 24 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 64 20 21 AC 82 00 00 24 02 FF FF 8F BF 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 28 0? ?? ?? ?? AF A4 00 18 00 40 F8 21 8F BC 00 10 8F A4 00 18 24 05 54 05 24 06 00 01 24 02 0F D6 00 00 00 0C 10 E0 00 07 00 40 80 21 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 24 10 FF FF 00 64 20 21 AC 82 00 00 03 E0 20 21 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 02 00 10 21 }
	condition:
		$1
}

rule file_126_0_0 {
	meta:
		name = "__sched_rr_get_interval"
		size = 28
	strings:
		$1 = { 24 02 10 45 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_127_0_0 {
	meta:
		name = "fileno"
		size = 72
		refs = "0004 __gnu_local_gp 0030 __libc_errno"
	strings:
		$1 = { 8C 82 00 00 3C 1C ?? ?? 30 42 20 00 10 40 00 06 27 9C ?? ?? 8C 82 00 38 04 40 00 03 00 00 00 00 03 E0 00 08 00 00 00 00 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 09 AC 43 00 00 03 E0 00 08 24 02 FF FF }
	condition:
		$1
}

rule file_128_0_0 {
	meta:
		name = "__default_morecore"
		size = 36
		refs = "0008 __sbrk"
	strings:
		$1 = { 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? 00 00 00 00 8F BF 00 1C 00 02 18 27 00 03 10 0A 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_129_0_0 {
	meta:
		name = "setsgent"
		size = 280
		refs = "0004 __gnu_local_gp 0050 $LC0 0054 __nss_gshadow_lookup2 007c __nss_setent 008c __libc_errno 00e4 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF C8 3C 1C ?? ?? AF B0 00 28 3C 10 ?? ?? 27 9C ?? ?? 26 03 ?? ?? AF BF 00 34 AF B2 00 30 AF B1 00 2C AF BC 00 20 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 28 00 00 00 00 3C 02 ?? ?? 24 42 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 06 ?? ?? 3C 07 ?? ?? AF A2 00 10 AF A0 00 14 AF A0 00 18 AF A0 00 1C 24 84 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 24 E7 ?? ?? 8F BC 00 20 7C 03 E8 3B 8F 91 ?? ?? 02 23 10 21 8C 52 00 00 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 0E 26 04 ?? ?? 8F BF 00 34 7C 03 E8 3B 02 23 88 21 AE 32 00 00 8F B0 00 28 8F B2 00 30 8F B1 00 2C 03 E0 00 08 27 BD 00 38 0? ?? ?? ?? 26 04 ?? ?? 0? ?? ?? ?? 3C 02 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 34 }
	condition:
		$1
}

rule file_1071_0_0 {
	meta:
		name = "setaliasent"
		size = 280
		refs = "0004 __gnu_local_gp 0050 $LC0 0054 __nss_aliases_lookup2 007c __nss_setent 008c __libc_errno 00e4 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF C8 3C 1C ?? ?? AF B0 00 28 3C 10 ?? ?? 27 9C ?? ?? 26 03 ?? ?? AF BF 00 34 AF B2 00 30 AF B1 00 2C AF BC 00 20 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 28 00 00 00 00 3C 02 ?? ?? 24 42 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 06 ?? ?? 3C 07 ?? ?? AF A2 00 10 AF A0 00 14 AF A0 00 18 AF A0 00 1C 24 84 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 24 E7 ?? ?? 8F BC 00 20 7C 03 E8 3B 8F 91 ?? ?? 02 23 10 21 8C 52 00 00 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 0E 26 04 ?? ?? 8F BF 00 34 7C 03 E8 3B 02 23 88 21 AE 32 00 00 8F B0 00 28 8F B2 00 30 8F B1 00 2C 03 E0 00 08 27 BD 00 38 0? ?? ?? ?? 26 04 ?? ?? 0? ?? ?? ?? 3C 02 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 34 }
	condition:
		$1
}

rule file_1120_0_0 {
	meta:
		name = "setgrent"
		size = 280
		refs = "0004 __gnu_local_gp 0050 $LC0 0054 __nss_group_lookup2 007c __nss_setent 008c __libc_errno 00e4 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF C8 3C 1C ?? ?? AF B0 00 28 3C 10 ?? ?? 27 9C ?? ?? 26 03 ?? ?? AF BF 00 34 AF B2 00 30 AF B1 00 2C AF BC 00 20 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 28 00 00 00 00 3C 02 ?? ?? 24 42 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 06 ?? ?? 3C 07 ?? ?? AF A2 00 10 AF A0 00 14 AF A0 00 18 AF A0 00 1C 24 84 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 24 E7 ?? ?? 8F BC 00 20 7C 03 E8 3B 8F 91 ?? ?? 02 23 10 21 8C 52 00 00 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 0E 26 04 ?? ?? 8F BF 00 34 7C 03 E8 3B 02 23 88 21 AE 32 00 00 8F B0 00 28 8F B2 00 30 8F B1 00 2C 03 E0 00 08 27 BD 00 38 0? ?? ?? ?? 26 04 ?? ?? 0? ?? ?? ?? 3C 02 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 34 }
	condition:
		$1
}

rule file_729_0_0 {
	meta:
		name = "setpwent"
		size = 280
		refs = "0004 __gnu_local_gp 0050 $LC0 0054 __nss_passwd_lookup2 007c __nss_setent 008c __libc_errno 00e4 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF C8 3C 1C ?? ?? AF B0 00 28 3C 10 ?? ?? 27 9C ?? ?? 26 03 ?? ?? AF BF 00 34 AF B2 00 30 AF B1 00 2C AF BC 00 20 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 28 00 00 00 00 3C 02 ?? ?? 24 42 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 06 ?? ?? 3C 07 ?? ?? AF A2 00 10 AF A0 00 14 AF A0 00 18 AF A0 00 1C 24 84 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 24 E7 ?? ?? 8F BC 00 20 7C 03 E8 3B 8F 91 ?? ?? 02 23 10 21 8C 52 00 00 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 0E 26 04 ?? ?? 8F BF 00 34 7C 03 E8 3B 02 23 88 21 AE 32 00 00 8F B0 00 28 8F B2 00 30 8F B1 00 2C 03 E0 00 08 27 BD 00 38 0? ?? ?? ?? 26 04 ?? ?? 0? ?? ?? ?? 3C 02 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 34 }
	condition:
		$1
}

rule file_534_0_0 {
	meta:
		name = "setspent"
		size = 280
		refs = "0004 __gnu_local_gp 0050 $LC0 0054 __nss_shadow_lookup2 007c __nss_setent 008c __libc_errno 00e4 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF C8 3C 1C ?? ?? AF B0 00 28 3C 10 ?? ?? 27 9C ?? ?? 26 03 ?? ?? AF BF 00 34 AF B2 00 30 AF B1 00 2C AF BC 00 20 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 28 00 00 00 00 3C 02 ?? ?? 24 42 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 06 ?? ?? 3C 07 ?? ?? AF A2 00 10 AF A0 00 14 AF A0 00 18 AF A0 00 1C 24 84 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 24 E7 ?? ?? 8F BC 00 20 7C 03 E8 3B 8F 91 ?? ?? 02 23 10 21 8C 52 00 00 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 0E 26 04 ?? ?? 8F BF 00 34 7C 03 E8 3B 02 23 88 21 AE 32 00 00 8F B0 00 28 8F B2 00 30 8F B1 00 2C 03 E0 00 08 27 BD 00 38 0? ?? ?? ?? 26 04 ?? ?? 0? ?? ?? ?? 3C 02 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 34 }
	condition:
		$1
}

rule file_129_1_0 {
	meta:
		name = "endsgent"
		size = 288
		refs = "0014 __gnu_local_gp 0060 $LC1 0064 __nss_gshadow_lookup2 0080 __nss_endent 0090 __libc_errno 00ec __lll_lock_wait_private"
	strings:
		$1 = { 3C 07 ?? ?? 8C E2 ?? ?? 10 40 00 36 00 00 00 00 27 BD FF C8 3C 1C ?? ?? AF B0 00 28 3C 10 ?? ?? 27 9C ?? ?? 26 03 ?? ?? AF BF 00 34 AF B2 00 30 AF B1 00 2C AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 26 26 04 ?? ?? 3C 02 ?? ?? 24 42 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 06 ?? ?? AF A2 00 10 AF A0 00 14 24 84 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 24 E7 ?? ?? 8F BC 00 18 7C 03 E8 3B 8F 91 ?? ?? 02 23 10 21 8C 52 00 00 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 0F 26 04 ?? ?? 7C 03 E8 3B 02 23 88 21 AE 32 00 00 8F BF 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 27 BD 00 38 03 E0 00 08 00 00 00 00 0? ?? ?? ?? AF A7 00 20 0? ?? ?? ?? 8F A7 00 20 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_1071_1_0 {
	meta:
		name = "endaliasent"
		size = 288
		refs = "0014 __gnu_local_gp 0060 $LC1 0064 __nss_aliases_lookup2 0080 __nss_endent 0090 __libc_errno 00ec __lll_lock_wait_private"
	strings:
		$1 = { 3C 07 ?? ?? 8C E2 ?? ?? 10 40 00 36 00 00 00 00 27 BD FF C8 3C 1C ?? ?? AF B0 00 28 3C 10 ?? ?? 27 9C ?? ?? 26 03 ?? ?? AF BF 00 34 AF B2 00 30 AF B1 00 2C AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 26 26 04 ?? ?? 3C 02 ?? ?? 24 42 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 06 ?? ?? AF A2 00 10 AF A0 00 14 24 84 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 24 E7 ?? ?? 8F BC 00 18 7C 03 E8 3B 8F 91 ?? ?? 02 23 10 21 8C 52 00 00 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 0F 26 04 ?? ?? 7C 03 E8 3B 02 23 88 21 AE 32 00 00 8F BF 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 27 BD 00 38 03 E0 00 08 00 00 00 00 0? ?? ?? ?? AF A7 00 20 0? ?? ?? ?? 8F A7 00 20 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_1120_1_0 {
	meta:
		name = "endgrent"
		size = 288
		refs = "0014 __gnu_local_gp 0060 $LC1 0064 __nss_group_lookup2 0080 __nss_endent 0090 __libc_errno 00ec __lll_lock_wait_private"
	strings:
		$1 = { 3C 07 ?? ?? 8C E2 ?? ?? 10 40 00 36 00 00 00 00 27 BD FF C8 3C 1C ?? ?? AF B0 00 28 3C 10 ?? ?? 27 9C ?? ?? 26 03 ?? ?? AF BF 00 34 AF B2 00 30 AF B1 00 2C AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 26 26 04 ?? ?? 3C 02 ?? ?? 24 42 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 06 ?? ?? AF A2 00 10 AF A0 00 14 24 84 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 24 E7 ?? ?? 8F BC 00 18 7C 03 E8 3B 8F 91 ?? ?? 02 23 10 21 8C 52 00 00 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 0F 26 04 ?? ?? 7C 03 E8 3B 02 23 88 21 AE 32 00 00 8F BF 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 27 BD 00 38 03 E0 00 08 00 00 00 00 0? ?? ?? ?? AF A7 00 20 0? ?? ?? ?? 8F A7 00 20 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_1018_1_0 {
	meta:
		name = "endprotoent"
		size = 288
		refs = "0014 __gnu_local_gp 0060 $LC1 0064 __nss_protocols_lookup2 0080 __nss_endent 0090 __libc_errno 00ec __lll_lock_wait_private"
	strings:
		$1 = { 3C 07 ?? ?? 8C E2 ?? ?? 10 40 00 36 00 00 00 00 27 BD FF C8 3C 1C ?? ?? AF B0 00 28 3C 10 ?? ?? 27 9C ?? ?? 26 03 ?? ?? AF BF 00 34 AF B2 00 30 AF B1 00 2C AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 26 26 04 ?? ?? 3C 02 ?? ?? 24 42 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 06 ?? ?? AF A2 00 10 AF A0 00 14 24 84 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 24 E7 ?? ?? 8F BC 00 18 7C 03 E8 3B 8F 91 ?? ?? 02 23 10 21 8C 52 00 00 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 0F 26 04 ?? ?? 7C 03 E8 3B 02 23 88 21 AE 32 00 00 8F BF 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 27 BD 00 38 03 E0 00 08 00 00 00 00 0? ?? ?? ?? AF A7 00 20 0? ?? ?? ?? 8F A7 00 20 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_729_1_0 {
	meta:
		name = "endpwent"
		size = 288
		refs = "0014 __gnu_local_gp 0060 $LC1 0064 __nss_passwd_lookup2 0080 __nss_endent 0090 __libc_errno 00ec __lll_lock_wait_private"
	strings:
		$1 = { 3C 07 ?? ?? 8C E2 ?? ?? 10 40 00 36 00 00 00 00 27 BD FF C8 3C 1C ?? ?? AF B0 00 28 3C 10 ?? ?? 27 9C ?? ?? 26 03 ?? ?? AF BF 00 34 AF B2 00 30 AF B1 00 2C AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 26 26 04 ?? ?? 3C 02 ?? ?? 24 42 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 06 ?? ?? AF A2 00 10 AF A0 00 14 24 84 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 24 E7 ?? ?? 8F BC 00 18 7C 03 E8 3B 8F 91 ?? ?? 02 23 10 21 8C 52 00 00 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 0F 26 04 ?? ?? 7C 03 E8 3B 02 23 88 21 AE 32 00 00 8F BF 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 27 BD 00 38 03 E0 00 08 00 00 00 00 0? ?? ?? ?? AF A7 00 20 0? ?? ?? ?? 8F A7 00 20 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_368_1_0 {
	meta:
		name = "endrpcent"
		size = 288
		refs = "0014 __gnu_local_gp 0060 $LC1 0064 __nss_rpc_lookup2 0080 __nss_endent 0090 __libc_errno 00ec __lll_lock_wait_private"
	strings:
		$1 = { 3C 07 ?? ?? 8C E2 ?? ?? 10 40 00 36 00 00 00 00 27 BD FF C8 3C 1C ?? ?? AF B0 00 28 3C 10 ?? ?? 27 9C ?? ?? 26 03 ?? ?? AF BF 00 34 AF B2 00 30 AF B1 00 2C AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 26 26 04 ?? ?? 3C 02 ?? ?? 24 42 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 06 ?? ?? AF A2 00 10 AF A0 00 14 24 84 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 24 E7 ?? ?? 8F BC 00 18 7C 03 E8 3B 8F 91 ?? ?? 02 23 10 21 8C 52 00 00 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 0F 26 04 ?? ?? 7C 03 E8 3B 02 23 88 21 AE 32 00 00 8F BF 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 27 BD 00 38 03 E0 00 08 00 00 00 00 0? ?? ?? ?? AF A7 00 20 0? ?? ?? ?? 8F A7 00 20 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_1386_1_0 {
	meta:
		name = "endservent"
		size = 288
		refs = "0014 __gnu_local_gp 0060 $LC1 0064 __nss_services_lookup2 0080 __nss_endent 0090 __libc_errno 00ec __lll_lock_wait_private"
	strings:
		$1 = { 3C 07 ?? ?? 8C E2 ?? ?? 10 40 00 36 00 00 00 00 27 BD FF C8 3C 1C ?? ?? AF B0 00 28 3C 10 ?? ?? 27 9C ?? ?? 26 03 ?? ?? AF BF 00 34 AF B2 00 30 AF B1 00 2C AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 26 26 04 ?? ?? 3C 02 ?? ?? 24 42 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 06 ?? ?? AF A2 00 10 AF A0 00 14 24 84 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 24 E7 ?? ?? 8F BC 00 18 7C 03 E8 3B 8F 91 ?? ?? 02 23 10 21 8C 52 00 00 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 0F 26 04 ?? ?? 7C 03 E8 3B 02 23 88 21 AE 32 00 00 8F BF 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 27 BD 00 38 03 E0 00 08 00 00 00 00 0? ?? ?? ?? AF A7 00 20 0? ?? ?? ?? 8F A7 00 20 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_534_1_0 {
	meta:
		name = "endspent"
		size = 288
		refs = "0014 __gnu_local_gp 0060 $LC1 0064 __nss_shadow_lookup2 0080 __nss_endent 0090 __libc_errno 00ec __lll_lock_wait_private"
	strings:
		$1 = { 3C 07 ?? ?? 8C E2 ?? ?? 10 40 00 36 00 00 00 00 27 BD FF C8 3C 1C ?? ?? AF B0 00 28 3C 10 ?? ?? 27 9C ?? ?? 26 03 ?? ?? AF BF 00 34 AF B2 00 30 AF B1 00 2C AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 26 26 04 ?? ?? 3C 02 ?? ?? 24 42 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 06 ?? ?? AF A2 00 10 AF A0 00 14 24 84 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 24 E7 ?? ?? 8F BC 00 18 7C 03 E8 3B 8F 91 ?? ?? 02 23 10 21 8C 52 00 00 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 0F 26 04 ?? ?? 7C 03 E8 3B 02 23 88 21 AE 32 00 00 8F BF 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 27 BD 00 38 03 E0 00 08 00 00 00 00 0? ?? ?? ?? AF A7 00 20 0? ?? ?? ?? 8F A7 00 20 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_129_2_0 {
	meta:
		name = "__getsgent_r"
		size = 344
		refs = "0004 __gnu_local_gp 0070 $LC2 0074 $LC0 0078 __nss_gshadow_lookup2 00a0 __nss_getent_r 00b4 __libc_errno 011c __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF 98 3C 1C ?? ?? AF B0 00 54 3C 10 ?? ?? AF B1 00 58 27 9C ?? ?? 00 80 88 21 26 03 ?? ?? AF BF 00 64 AF B3 00 60 AF B2 00 5C AF BC 00 38 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 32 26 04 ?? ?? 3C 02 ?? ?? 24 42 ?? ?? AF A2 00 10 3C 02 ?? ?? AF A5 00 24 AF A6 00 28 AF A7 00 2C 24 42 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 06 ?? ?? 3C 07 ?? ?? AF B1 00 20 AF A2 00 14 AF A0 00 18 AF A0 00 1C AF A0 00 30 24 84 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 24 E7 ?? ?? 8F BC 00 38 7C 03 E8 3B 00 40 90 21 8F 91 ?? ?? 02 23 20 21 8C 93 00 00 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 14 26 04 ?? ?? 8F BF 00 64 7C 03 E8 3B 02 23 88 21 AE 33 00 00 02 40 10 21 8F B3 00 60 8F B2 00 5C 8F B1 00 58 8F B0 00 54 03 E0 00 08 27 BD 00 68 AF A5 00 40 AF A6 00 44 0? ?? ?? ?? AF A7 00 48 8F A7 00 48 8F A6 00 44 0? ?? ?? ?? 8F A5 00 40 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 64 }
	condition:
		$1
}

rule file_1071_2_0 {
	meta:
		name = "__getaliasent_r"
		size = 344
		refs = "0004 __gnu_local_gp 0070 $LC2 0074 $LC0 0078 __nss_aliases_lookup2 00a0 __nss_getent_r 00b4 __libc_errno 011c __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF 98 3C 1C ?? ?? AF B0 00 54 3C 10 ?? ?? AF B1 00 58 27 9C ?? ?? 00 80 88 21 26 03 ?? ?? AF BF 00 64 AF B3 00 60 AF B2 00 5C AF BC 00 38 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 32 26 04 ?? ?? 3C 02 ?? ?? 24 42 ?? ?? AF A2 00 10 3C 02 ?? ?? AF A5 00 24 AF A6 00 28 AF A7 00 2C 24 42 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 06 ?? ?? 3C 07 ?? ?? AF B1 00 20 AF A2 00 14 AF A0 00 18 AF A0 00 1C AF A0 00 30 24 84 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 24 E7 ?? ?? 8F BC 00 38 7C 03 E8 3B 00 40 90 21 8F 91 ?? ?? 02 23 20 21 8C 93 00 00 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 14 26 04 ?? ?? 8F BF 00 64 7C 03 E8 3B 02 23 88 21 AE 33 00 00 02 40 10 21 8F B3 00 60 8F B2 00 5C 8F B1 00 58 8F B0 00 54 03 E0 00 08 27 BD 00 68 AF A5 00 40 AF A6 00 44 0? ?? ?? ?? AF A7 00 48 8F A7 00 48 8F A6 00 44 0? ?? ?? ?? 8F A5 00 40 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 64 }
	condition:
		$1
}

rule file_1120_2_0 {
	meta:
		name = "__getgrent_r"
		size = 344
		refs = "0004 __gnu_local_gp 0070 $LC2 0074 $LC0 0078 __nss_group_lookup2 00a0 __nss_getent_r 00b4 __libc_errno 011c __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF 98 3C 1C ?? ?? AF B0 00 54 3C 10 ?? ?? AF B1 00 58 27 9C ?? ?? 00 80 88 21 26 03 ?? ?? AF BF 00 64 AF B3 00 60 AF B2 00 5C AF BC 00 38 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 32 26 04 ?? ?? 3C 02 ?? ?? 24 42 ?? ?? AF A2 00 10 3C 02 ?? ?? AF A5 00 24 AF A6 00 28 AF A7 00 2C 24 42 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 06 ?? ?? 3C 07 ?? ?? AF B1 00 20 AF A2 00 14 AF A0 00 18 AF A0 00 1C AF A0 00 30 24 84 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 24 E7 ?? ?? 8F BC 00 38 7C 03 E8 3B 00 40 90 21 8F 91 ?? ?? 02 23 20 21 8C 93 00 00 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 14 26 04 ?? ?? 8F BF 00 64 7C 03 E8 3B 02 23 88 21 AE 33 00 00 02 40 10 21 8F B3 00 60 8F B2 00 5C 8F B1 00 58 8F B0 00 54 03 E0 00 08 27 BD 00 68 AF A5 00 40 AF A6 00 44 0? ?? ?? ?? AF A7 00 48 8F A7 00 48 8F A6 00 44 0? ?? ?? ?? 8F A5 00 40 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 64 }
	condition:
		$1
}

rule file_729_2_0 {
	meta:
		name = "__getpwent_r"
		size = 344
		refs = "0004 __gnu_local_gp 0070 $LC2 0074 $LC0 0078 __nss_passwd_lookup2 00a0 __nss_getent_r 00b4 __libc_errno 011c __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF 98 3C 1C ?? ?? AF B0 00 54 3C 10 ?? ?? AF B1 00 58 27 9C ?? ?? 00 80 88 21 26 03 ?? ?? AF BF 00 64 AF B3 00 60 AF B2 00 5C AF BC 00 38 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 32 26 04 ?? ?? 3C 02 ?? ?? 24 42 ?? ?? AF A2 00 10 3C 02 ?? ?? AF A5 00 24 AF A6 00 28 AF A7 00 2C 24 42 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 06 ?? ?? 3C 07 ?? ?? AF B1 00 20 AF A2 00 14 AF A0 00 18 AF A0 00 1C AF A0 00 30 24 84 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 24 E7 ?? ?? 8F BC 00 38 7C 03 E8 3B 00 40 90 21 8F 91 ?? ?? 02 23 20 21 8C 93 00 00 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 14 26 04 ?? ?? 8F BF 00 64 7C 03 E8 3B 02 23 88 21 AE 33 00 00 02 40 10 21 8F B3 00 60 8F B2 00 5C 8F B1 00 58 8F B0 00 54 03 E0 00 08 27 BD 00 68 AF A5 00 40 AF A6 00 44 0? ?? ?? ?? AF A7 00 48 8F A7 00 48 8F A6 00 44 0? ?? ?? ?? 8F A5 00 40 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 64 }
	condition:
		$1
}

rule file_534_2_0 {
	meta:
		name = "__getspent_r"
		size = 344
		refs = "0004 __gnu_local_gp 0070 $LC2 0074 $LC0 0078 __nss_shadow_lookup2 00a0 __nss_getent_r 00b4 __libc_errno 011c __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF 98 3C 1C ?? ?? AF B0 00 54 3C 10 ?? ?? AF B1 00 58 27 9C ?? ?? 00 80 88 21 26 03 ?? ?? AF BF 00 64 AF B3 00 60 AF B2 00 5C AF BC 00 38 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 32 26 04 ?? ?? 3C 02 ?? ?? 24 42 ?? ?? AF A2 00 10 3C 02 ?? ?? AF A5 00 24 AF A6 00 28 AF A7 00 2C 24 42 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 06 ?? ?? 3C 07 ?? ?? AF B1 00 20 AF A2 00 14 AF A0 00 18 AF A0 00 1C AF A0 00 30 24 84 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 24 E7 ?? ?? 8F BC 00 38 7C 03 E8 3B 00 40 90 21 8F 91 ?? ?? 02 23 20 21 8C 93 00 00 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 14 26 04 ?? ?? 8F BF 00 64 7C 03 E8 3B 02 23 88 21 AE 33 00 00 02 40 10 21 8F B3 00 60 8F B2 00 5C 8F B1 00 58 8F B0 00 54 03 E0 00 08 27 BD 00 68 AF A5 00 40 AF A6 00 44 0? ?? ?? ?? AF A7 00 48 8F A7 00 48 8F A6 00 44 0? ?? ?? ?? 8F A5 00 40 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 64 }
	condition:
		$1
}

rule file_130_0_0 {
	meta:
		name = "__gethostname"
		size = 176
		refs = "0004 __gnu_local_gp 002c uname 003c strlen 0058 memcpy 0098 __libc_errno"
	strings:
		$1 = { 27 BD FE 48 3C 1C ?? ?? 27 9C ?? ?? AF B3 01 B0 00 80 98 21 27 A4 00 18 AF B1 01 A8 AF B0 01 A4 AF BF 01 B4 AF B2 01 AC AF BC 00 10 0? ?? ?? ?? 00 A0 88 21 14 40 00 14 00 40 80 21 0? ?? ?? ?? 27 A4 00 59 24 42 00 01 02 22 90 2B 02 20 30 21 02 60 20 21 27 A5 00 59 0? ?? ?? ?? 00 52 30 0A 16 40 00 0B 8F BC 00 10 8F BF 01 B4 02 00 10 21 8F B3 01 B0 8F B2 01 AC 8F B1 01 A8 8F B0 01 A4 03 E0 00 08 27 BD 01 B8 0? ?? ?? ?? 24 10 FF FF 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 24 10 FF FF 00 62 10 21 24 03 00 4E 0? ?? ?? ?? AC 43 00 00 }
	condition:
		$1
}

rule file_131_0_0 {
	meta:
		name = "posix_spawnattr_setsigdefault"
		size = 92
	strings:
		$1 = { 24 84 00 08 24 A8 00 80 88 A7 00 00 88 A6 00 04 88 A3 00 08 88 A2 00 0C 98 A7 00 03 98 A6 00 07 98 A3 00 0B 98 A2 00 0F A8 87 00 00 B8 87 00 03 A8 86 00 04 B8 86 00 07 A8 83 00 08 B8 83 00 0B 24 A5 00 10 A8 82 00 0C B8 82 00 0F 14 A8 FF EE 24 84 00 10 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_132_0_0 {
	meta:
		name = "fchflags"
		size = 60
		refs = "0000 __gnu_local_gp 0010 __libc_errno"
	strings:
		$1 = { 3C 1C ?? ?? 7C 03 E8 3B 27 9C ?? ?? 00 60 10 21 8F 83 ?? ?? 04 80 00 05 00 62 10 21 24 03 00 59 AC 43 00 00 03 E0 00 08 24 02 FF FF 24 03 00 16 AC 43 00 00 03 E0 00 08 24 02 FF FF }
	condition:
		$1
}

rule file_133_0_0 {
	meta:
		name = "__socket"
		size = 28
	strings:
		$1 = { 24 02 10 57 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_134_1_0 {
	meta:
		name = "open_translit"
		size = 288
		refs = "0020 __libc_dlopen_mode 0038 __libc_dlsym 003c $LC0 0064 __libc_dlclose 0090 $LC1 00a8 $LC2 00c8 $LC3"
	strings:
		$1 = { 27 BD FF D8 AF B0 00 18 00 80 80 21 8C 84 00 20 3C 05 80 00 24 A5 00 01 AF BF 00 24 AF B2 00 20 0? ?? ?? ?? AF B1 00 1C 10 40 00 35 AE 02 00 24 3C 12 ?? ?? 00 40 20 21 0? ?? ?? ?? 26 45 ?? ?? 10 40 00 07 26 05 00 08 8E 04 00 00 00 40 C8 21 03 20 F8 09 26 06 00 0C 10 40 00 0C 00 40 88 21 8E 04 00 24 0? ?? ?? ?? 24 11 00 01 8F BF 00 24 AE 00 00 24 02 20 10 21 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 8E 04 00 24 3C 05 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 10 40 FF F0 AE 02 00 10 8E 04 00 24 3C 05 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 8E 04 00 24 26 45 ?? ?? 0? ?? ?? ?? AE 02 00 18 8E 04 00 24 3C 05 ?? ?? AE 02 00 14 0? ?? ?? ?? 24 A5 ?? ?? 8F BF 00 24 AE 02 00 1C 24 02 00 01 AE 02 00 28 8F B2 00 20 02 20 10 21 8F B0 00 18 8F B1 00 1C 03 E0 00 08 27 BD 00 28 8F BF 00 24 24 11 00 01 02 20 10 21 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_134_2_0 {
	meta:
		name = "__gconv_transliterate"
		size = 1288
		refs = "0000 __gnu_local_gp 0008 _nl_current_LC_CTYPE 0374 _dl_mcount_wrapper_check"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 8F 99 ?? ?? 7C 03 E8 3B 27 BD FF 78 03 23 10 21 8C 43 00 00 AF B4 00 70 AF B3 00 6C 8C 62 00 00 AF B2 00 68 AF B0 00 60 AF BF 00 84 AF BE 00 80 AF B7 00 7C AF B6 00 78 AF B5 00 74 AF B1 00 64 AF BC 00 20 AF B9 00 44 8C 59 01 18 00 80 90 21 AF B9 00 30 8F B9 00 98 8F B3 00 A0 8C 90 00 14 8F 39 00 00 AF B9 00 34 8F B9 00 30 13 20 00 4E 00 A0 A0 21 8F B9 00 34 8C 56 01 28 27 23 00 04 8F B9 00 9C 03 23 20 2B 8C 59 01 1C AF B9 00 4C 8C 59 01 20 AF B9 00 48 8C 59 01 24 14 80 00 85 AF B9 00 54 8F B9 00 9C AF A0 00 3C 24 15 00 06 27 22 00 03 00 43 18 23 00 03 50 82 25 57 00 01 8F A3 00 30 8F B9 00 3C 00 79 F0 21 8F A3 00 4C 00 1E F0 42 00 1E 38 80 00 67 10 21 8C 42 00 00 AF BE 00 38 00 00 F0 21 AF A2 00 40 8F B9 00 40 8F A2 00 34 00 19 18 80 8F B9 00 48 03 23 18 21 0? ?? ?? ?? 8C 64 00 00 8C 64 00 04 27 DE 00 01 10 80 00 7F 24 63 00 04 13 D7 00 6B 8F BF 00 84 8C 45 00 00 00 40 30 21 10 A4 FF F7 24 42 00 04 17 C0 00 75 AF A0 00 50 8F B9 00 9C 00 D9 10 2B 10 40 00 6E 8F B9 00 38 8F A3 00 50 8F B9 00 40 00 79 10 21 8F A3 00 48 00 02 10 80 00 62 10 21 8C 43 00 00 8C C2 00 00 00 62 10 2B 14 40 00 63 8F B9 00 38 8F A3 00 38 AF A3 00 30 8F B9 00 3C 8F A3 00 30 03 23 10 2B 14 40 FF CF 00 00 00 00 8F B9 00 44 7C 03 E8 3B 03 23 10 21 8C 4A 00 00 0? ?? ?? ?? 8D 48 00 00 00 40 40 21 00 60 50 21 8D 07 01 34 14 E0 00 11 8F B9 00 98 8D 02 01 2C 14 40 00 2D 24 11 00 06 8F BF 00 84 02 20 10 21 8F BE 00 80 8F B7 00 7C 8F B6 00 78 8F B5 00 74 8F B4 00 70 8F B3 00 6C 8F B2 00 68 8F B1 00 64 8F B0 00 60 03 E0 00 08 27 BD 00 88 8D 02 01 38 8F 2B 00 00 8F B9 00 34 27 23 00 04 8F B9 00 9C 03 23 18 2B 14 60 00 27 8D 65 00 00 1C E0 00 0F 00 00 00 00 0? ?? ?? ?? 8D 02 01 2C 8C 46 00 04 00 C5 30 2B 14 C0 00 07 00 A4 20 23 8C 46 00 08 00 86 00 1B 00 C0 01 F4 00 00 48 10 11 20 00 9A 8F B9 00 98 10 E3 FF D9 24 42 00 0C 8C 44 00 00 00 A4 30 2B 10 C0 FF F1 24 63 00 01 8D 02 01 2C 10 40 FF D5 24 11 00 06 8F B9 00 34 8D 15 01 30 27 22 00 04 AF B5 00 2C 8F B9 00 9C 8D 43 00 00 03 22 10 2B 10 40 00 6F 8C 76 01 2C 8F A2 00 34 24 11 00 07 00 59 B8 26 24 02 00 04 0? ?? ?? ?? 00 57 88 0A 8F B9 00 34 8F A2 00 9C 13 22 FF C2 24 11 00 04 8F BF 00 84 24 11 00 07 02 20 10 21 8F BE 00 80 8F B7 00 7C 8F B6 00 78 8F B5 00 74 8F B4 00 70 8F B3 00 6C 8F B2 00 68 8F B1 00 64 8F B0 00 60 03 E0 00 08 27 BD 00 88 27 39 00 01 0? ?? ?? ?? AF B9 00 3C 14 80 FF EF 8F BF 00 84 8F A3 00 54 AF BE 00 50 00 67 38 21 8C F1 00 00 00 11 10 80 02 C2 18 21 8C 63 00 00 10 60 00 26 02 C2 28 21 24 42 00 04 26 31 00 01 0? ?? ?? ?? 02 C2 10 21 00 80 88 21 8C 43 00 00 00 40 38 21 26 24 00 01 14 60 FF FB 24 42 00 04 8E 62 00 00 02 00 20 21 AF A5 00 2C AF A2 00 28 0? ?? ?? ?? AF A7 00 58 8F A7 00 58 27 A4 00 28 AF A4 00 10 AF A0 00 14 AF A0 00 18 AF A0 00 1C 02 40 20 21 02 80 28 21 02 00 C8 21 03 20 F8 09 27 A6 00 2C 14 55 00 0B 26 31 00 01 00 11 10 80 02 C2 18 21 8C 63 00 00 14 60 FF DD 8F B9 00 34 00 1E 30 80 0? ?? ?? ?? 03 26 30 21 0? ?? ?? ?? 00 A0 38 21 24 03 00 04 10 43 00 12 24 03 00 05 10 43 00 02 8F A3 00 28 AE 63 00 00 8F BF 00 84 00 40 88 21 02 20 10 21 8F BE 00 80 8F B7 00 7C 8F B6 00 78 8F B5 00 74 8F B4 00 70 8F B3 00 6C 8F B2 00 68 8F B1 00 64 8F B0 00 60 03 E0 00 08 27 BD 00 88 8F B9 00 98 8F A4 00 A4 00 1E 40 80 8F 22 00 00 8C 83 00 00 00 48 10 21 24 63 00 01 AF 22 00 00 AC 83 00 00 8F A3 00 28 00 00 10 21 0? ?? ?? ?? AE 63 00 00 8E 62 00 00 02 00 20 21 0? ?? ?? ?? AF A2 00 28 27 A2 00 28 00 16 38 80 AF A2 00 10 AF A0 00 14 AF A0 00 18 AF A0 00 1C 02 40 20 21 02 80 28 21 27 A6 00 2C 02 00 C8 21 03 20 F8 09 02 A7 38 21 24 03 00 06 10 43 FF 4B 24 03 00 04 10 43 00 0D 8F B9 00 98 00 40 88 21 8F A2 00 28 0? ?? ?? ?? AE 62 00 00 8F A3 00 A4 25 6B 00 04 8C 62 00 00 00 00 88 21 AF 2B 00 00 24 42 00 01 0? ?? ?? ?? AC 62 00 00 8F A2 00 A4 8F A5 00 A4 8C 44 00 00 8F 23 00 00 00 00 10 21 24 84 00 01 24 63 00 04 AC A4 00 00 0? ?? ?? ?? AF 23 00 00 }
	condition:
		$1
}

rule file_134_3_0 {
	meta:
		name = "__gconv_translit_find"
		size = 780
		refs = "0070 __tfind 0100 strlen 0104 __gconv_path_elem 0128 $LC6 0134 memcmp 0140 __gconv_max_path_elem_len 0150 malloc 0198 mempcpy 01e4 stpcpy 0220 __tsearch 02a4 __gconv_get_path 02dc __lll_lock_wait_private 02ec $LC4 02f0 $LC5 0304 __assert_fail 02f4 __PRETTY_FUNCTION__.8484"
	strings:
		$1 = { 8C 82 00 00 27 BD FF B8 AF B1 00 24 AF BF 00 44 AF BE 00 40 AF B7 00 3C AF B6 00 38 AF B5 00 34 AF B4 00 30 AF B3 00 2C AF B2 00 28 AF B0 00 20 10 40 00 AE 00 80 88 21 3C 10 ?? ?? 26 03 ?? ?? C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 A0 00 00 00 00 3C 14 ?? ?? 3C 15 ?? ?? 02 20 20 21 26 85 ?? ?? 0? ?? ?? ?? 26 A6 ?? ?? 10 40 00 20 00 40 90 21 8C 44 00 00 8C 82 00 24 10 40 00 1A 24 03 FF FF 10 43 00 6A 00 00 98 21 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 7E 00 00 00 00 8F BF 00 44 02 60 10 21 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 48 0? ?? ?? ?? 24 13 00 01 8E 24 00 00 0? ?? ?? ?? 3C 13 ?? ?? 8E 63 ?? ?? 10 60 00 65 24 56 00 01 2E C3 00 05 14 60 00 09 24 17 00 01 8E 24 00 00 24 42 FF FD 3C 05 ?? ?? 00 82 20 21 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 03 00 02 B8 2B 3C 02 ?? ?? 8C 44 ?? ?? 24 84 00 2F 00 96 20 21 0? ?? ?? ?? 00 96 20 21 10 40 FF E6 00 40 90 21 8E 25 00 00 24 42 00 2C 00 40 20 21 02 C0 30 21 AE 40 00 04 AE 40 00 08 AE 40 00 0C AE 40 00 10 AE 40 00 14 AE 40 00 18 AE 40 00 1C AE 40 00 20 AE 40 00 24 AE 40 00 28 0? ?? ?? ?? AE 42 00 00 8E 73 ?? ?? AE 42 00 20 8E 65 00 00 10 A0 00 18 3C 03 ?? ?? 8C 7E ?? ?? 0? ?? ?? ?? 00 40 20 21 0? ?? ?? ?? 02 40 20 21 10 40 00 1A 00 00 00 00 26 73 00 08 8E 65 00 00 10 A0 00 0D 00 00 00 00 8E 44 00 20 0? ?? ?? ?? 00 00 00 00 8E 25 00 00 00 40 20 21 0? ?? ?? ?? 02 C0 30 21 12 E0 FF F0 00 00 00 00 A8 5E 00 00 0? ?? ?? ?? B8 5E 00 03 AE 40 00 20 24 13 00 01 02 40 20 21 26 85 ?? ?? 0? ?? ?? ?? 26 A6 ?? ?? 24 03 00 01 0? ?? ?? ?? 00 62 98 0A 0? ?? ?? ?? 00 00 98 21 0? ?? ?? ?? 00 00 00 00 14 40 FF AB 00 00 00 00 8E 42 00 00 8C 43 00 18 8C 49 00 00 8C 48 00 04 8C 47 00 08 8C 46 00 0C 8C 45 00 10 8C 44 00 14 8C 42 00 1C AE 23 00 18 AE 29 00 00 AE 28 00 04 AE 27 00 08 AE 26 00 0C AE 25 00 10 AE 24 00 14 AE 22 00 1C 8E 42 00 00 8C 43 00 28 24 63 00 01 0? ?? ?? ?? AC 43 00 28 0? ?? ?? ?? AF A2 00 18 0? ?? ?? ?? 8F A2 00 18 26 04 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 44 0? ?? ?? ?? 26 04 ?? ?? 0? ?? ?? ?? 3C 14 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 01 4C 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_135_0_0 {
	meta:
		name = "_itoa_word"
		size = 244
		refs = "0008 _itoa_upper_digits 00a0 _itoa_lower_digits"
	strings:
		$1 = { 10 E0 00 27 00 A0 10 21 3C 03 ?? ?? 24 05 00 0A 10 C5 00 27 24 63 ?? ?? 24 05 00 10 10 C5 00 0E 24 05 00 08 10 C5 00 16 30 85 00 07 00 86 00 1B 00 C0 01 F4 24 42 FF FF 00 00 28 10 00 65 28 21 80 A5 00 00 00 00 20 12 14 80 FF F8 A0 45 00 00 03 E0 00 08 00 00 00 00 30 85 00 0F 00 65 28 21 80 A5 00 00 24 42 FF FF 00 04 21 02 14 80 FF FA A0 45 00 00 03 E0 00 08 00 00 00 00 30 85 00 07 00 65 28 21 80 A5 00 00 24 42 FF FF 00 04 20 C2 14 80 FF FA A0 45 00 00 03 E0 00 08 00 00 00 00 3C 03 ?? ?? 24 05 00 0A 14 C5 FF DB 24 63 ?? ?? 3C 08 CC CC 35 08 CC CD 00 88 00 19 24 42 FF FF 00 00 28 10 00 05 28 C2 00 05 38 40 00 05 30 C0 00 E6 30 21 00 86 20 23 00 64 20 21 80 86 00 00 00 A0 20 21 14 A0 FF F4 A0 46 00 00 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_135_1_0 {
	meta:
		name = "_itoa"
		size = 1296
		refs = "0014 _itoa_upper_digits 0084 _itoa_lower_digits 0138 _itoa_base_table"
	strings:
		$1 = { 27 BD FF E0 8F A2 00 30 AF B0 00 1C 10 40 00 1D 00 A0 60 21 3C 0B ?? ?? 24 02 00 08 10 E2 00 1D 25 6B ?? ?? 24 02 00 10 14 E2 00 40 24 E2 FF FE 10 80 00 87 00 C0 10 21 01 80 28 21 24 C2 FF F8 30 A3 00 0F 01 63 18 21 80 63 00 00 24 C6 FF FF 00 05 29 02 14 C2 FF FA A0 C3 00 00 30 83 00 0F 01 63 18 21 80 63 00 00 24 42 FF FF 00 04 21 02 14 80 00 78 A0 43 00 00 8F B0 00 1C 03 E0 00 08 27 BD 00 20 3C 0B ?? ?? 24 02 00 08 14 E2 FF E5 25 6B ?? ?? 01 80 28 21 10 80 00 14 00 C0 10 21 24 C2 FF F6 00 C0 18 21 30 A7 00 07 01 67 38 21 80 E7 00 00 24 63 FF FF 00 05 28 C2 14 62 FF FA A0 67 00 00 30 83 00 01 00 03 18 80 00 04 20 42 10 80 00 06 00 A3 28 25 01 65 28 21 80 A3 00 00 24 C2 FF F5 00 80 28 21 A0 C3 FF F5 30 A3 00 07 01 63 18 21 80 63 00 00 24 42 FF FF 00 05 28 C2 10 A0 FF DD A0 43 00 00 30 A3 00 07 01 63 18 21 80 63 00 00 24 42 FF FF 00 05 28 C2 14 A0 FF F3 A0 43 00 00 0? ?? ?? ?? 8F B0 00 1C 00 02 50 80 00 02 11 00 01 42 10 21 3C 0A ?? ?? 25 4A ?? ?? 14 80 00 4E 01 42 50 21 AF AC 00 08 01 80 40 21 24 0D 00 01 81 43 00 04 00 0D 68 80 01 BD 68 21 27 AE 00 04 00 C0 10 21 24 0C 00 30 14 60 00 23 8D 49 00 00 11 00 00 0E 00 00 00 00 01 09 00 19 81 45 00 05 24 42 FF FF 24 63 00 01 00 00 20 10 00 A4 20 06 70 87 78 02 01 0F 28 23 01 65 28 21 80 A5 00 00 00 80 40 21 14 80 FF F4 A0 45 00 00 11 AE 00 D1 00 00 00 00 81 44 00 09 00 64 20 2A 10 80 00 09 00 00 00 00 24 42 FF FF A0 4C 00 00 81 44 00 09 24 63 00 01 00 64 20 2A 14 80 FF FB 24 42 FF FF 24 42 00 01 81 43 00 04 8D A8 00 00 8D 49 00 00 10 60 FF DF 25 AD FF FC 11 00 FF EC 00 00 18 21 01 09 00 19 81 45 00 05 24 42 FF FF 24 63 00 01 24 A5 FF FF 00 00 20 10 01 04 78 23 00 0F 78 42 01 E4 20 21 00 A4 20 06 70 87 78 02 01 0F 28 23 01 65 28 21 80 A5 00 00 00 80 40 21 14 80 FF F0 A0 45 00 00 0? ?? ?? ?? 00 00 00 00 01 80 20 21 30 83 00 0F 01 63 18 21 80 63 00 00 24 42 FF FF 00 04 21 02 14 80 FF FA A0 43 00 00 8F B0 00 1C 03 E0 00 08 27 BD 00 20 8D 4E 00 0C 81 4D 00 08 00 8E 10 2B 14 40 00 67 01 AE 70 04 11 A0 00 8A 00 00 40 21 24 19 00 40 03 2D C8 23 00 19 40 27 00 04 10 40 01 02 40 04 03 2C 18 06 33 25 00 20 01 03 18 25 03 24 C8 06 00 65 C8 0A 03 20 40 21 8D 50 00 10 24 18 00 20 03 0D C0 23 01 10 00 19 00 18 18 27 00 62 10 04 03 0C 28 06 33 03 00 20 00 45 28 25 03 04 20 06 00 83 28 0B 00 00 40 10 03 28 78 21 01 EE 00 19 00 00 18 12 00 A3 48 23 00 A9 28 2B 00 00 10 10 03 22 10 23 00 45 10 23 10 40 00 06 01 2E 18 23 01 23 48 2B 10 49 00 72 00 00 00 00 00 6E 48 23 25 EF 00 02 01 2E 10 2B 14 40 00 04 01 30 00 19 01 2E 48 23 25 EF 00 01 01 30 00 19 01 AC 60 04 00 00 20 10 01 24 20 21 00 8E 00 19 00 00 18 12 01 83 18 23 01 83 60 2B 00 00 10 10 01 22 10 23 00 4C 10 23 10 40 00 06 00 6E 28 23 00 65 18 2B 10 43 00 52 00 00 00 00 00 AE 18 23 24 84 00 02 00 6E 10 2B 14 40 00 04 01 A3 40 06 00 6E 18 23 24 84 00 01 01 A3 40 06 11 A0 00 04 AF A8 00 10 01 AF 78 04 03 04 C0 06 03 0F 78 25 01 F0 00 19 01 A4 20 04 00 00 10 10 01 E2 28 21 00 AE 00 19 00 00 18 12 00 83 18 23 00 83 20 2B 00 00 10 10 01 E2 10 23 00 44 10 23 10 40 00 06 00 6E 20 23 00 64 18 2B 10 43 00 38 00 00 00 00 00 8E 18 23 24 A5 00 02 00 6E 10 2B 14 40 00 03 00 00 00 00 00 6E 18 23 24 A5 00 01 01 A3 18 06 AF A5 00 08 AF A3 00 0C 0? ?? ?? ?? 24 0D 00 03 00 0C 18 42 00 0D 10 27 00 43 18 06 01 A4 20 04 8D 42 00 10 31 A5 00 20 01 AC 60 04 00 64 20 25 01 85 20 0B 00 82 00 19 00 05 60 0B 00 00 10 10 00 82 28 21 00 AE 00 19 00 00 18 12 01 83 18 23 01 83 60 2B 00 00 10 10 00 82 10 23 00 4C 10 23 10 40 00 06 00 6E 20 23 00 64 18 2B 10 43 00 16 00 00 00 00 00 8E 18 23 24 A5 00 02 00 6E 10 2B 14 40 00 03 00 00 00 00 00 6E 18 23 24 A5 00 01 01 A3 40 06 AF A5 00 08 AF A8 00 0C 0? ?? ?? ?? 24 0D 00 02 00 00 C8 21 0? ?? ?? ?? 00 04 10 40 24 84 00 01 0? ?? ?? ?? 00 A0 18 21 24 A5 00 01 0? ?? ?? ?? 00 80 18 21 24 A5 00 01 0? ?? ?? ?? 00 80 18 21 25 EF 00 01 0? ?? ?? ?? 00 60 48 21 14 46 FE DF 00 40 20 21 24 03 00 30 24 42 FF FF 0? ?? ?? ?? A0 83 FF FF }
	condition:
		$1
}

rule file_135_2_0 {
	meta:
		name = "_fitoa_word"
		size = 92
		refs = "0010 _itoa_word"
	strings:
		$1 = { 27 BD FF D0 27 A9 00 28 00 A0 50 21 AF BF 00 2C 0? ?? ?? ?? 01 20 28 21 00 49 18 2B 10 60 00 0C 8F BF 00 2C 00 40 18 21 01 40 20 21 24 63 00 01 80 66 FF FF 24 84 00 01 14 69 FF FC A0 86 FF FF 03 A2 10 23 24 42 00 28 01 42 50 21 8F BF 00 2C 01 40 10 21 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_135_3_0 {
	meta:
		name = "_fitoa"
		size = 116
		refs = "0020 _itoa"
	strings:
		$1 = { 27 BD FF B0 8F A2 00 60 AF B0 00 44 27 B0 00 40 AF B1 00 48 AF A2 00 10 00 C0 88 21 AF BF 00 4C 0? ?? ?? ?? 02 00 30 21 00 50 18 2B 10 60 00 0C 8F BF 00 4C 00 40 18 21 02 20 20 21 24 63 00 01 80 65 FF FF 24 84 00 01 14 70 FF FC A0 85 FF FF 03 A2 10 23 24 42 00 40 02 22 88 21 8F BF 00 4C 02 20 10 21 8F B0 00 44 8F B1 00 48 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_136_0_0 {
	meta:
		name = "__setsid"
		size = 28
	strings:
		$1 = { 24 02 0F E2 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_138_0_0 {
	meta:
		name = "__nscd_getgrouplist"
		size = 964
		refs = "0038 strlen 0040 $LC0 0044 __gr_map_handle 0058 __nscd_get_map_ref 0088 __nscd_cache_search 01b4 __nscd_open_socket 0200 memcpy 024c __nscd_unmap 0298 realloc 02cc __readall 0300 __nss_not_use_nscd_group 01d8 $LC1 0100 $LC2 0324 __assert_fail 0314 __PRETTY_FUNCTION__.12170 03a0 $LC3"
	strings:
		$1 = { 27 BD FF A0 AF BF 00 5C AF BE 00 58 AF B7 00 54 AF B6 00 50 AF B5 00 4C AF B4 00 48 AF B3 00 44 AF B2 00 40 AF B1 00 3C AF A4 00 60 00 A0 90 21 00 C0 F0 21 00 E0 A8 21 0? ?? ?? ?? AF B0 00 38 3C 05 ?? ?? 3C 06 ?? ?? 24 04 00 0C 24 A5 ?? ?? 24 C6 ?? ?? 27 A7 00 2C 0? ?? ?? ?? 24 57 00 01 00 40 88 21 00 00 A0 21 24 13 FF FF 24 16 00 01 12 33 00 4B 8F A5 00 60 24 02 00 0C AF A2 00 10 24 04 00 0F 02 E0 30 21 0? ?? ?? ?? 02 20 38 21 10 40 00 44 8F A4 00 60 8E 23 00 00 8C 48 00 04 8C 4B 00 18 8C 67 00 08 8C 4A 00 1C 8C 45 00 20 8F A4 00 2C 24 49 00 18 24 46 00 24 AF AB 00 20 AF AA 00 24 AF A5 00 28 14 E4 00 88 01 28 40 21 00 05 28 80 00 C5 28 21 01 05 40 2B 15 00 00 85 00 00 00 00 8F A3 00 24 10 76 00 39 24 08 FF FF 10 73 00 A7 24 03 00 01 8F C2 00 00 18 40 00 A8 3C 05 ?? ?? 8E A7 00 00 00 00 18 21 00 03 10 80 00 E2 38 21 24 70 00 01 AC F2 00 00 11 13 00 03 01 00 20 21 24 02 0F A6 00 00 00 0C 12 33 00 0F 8F A4 00 2C 8E 23 00 00 8C 62 00 08 14 44 00 7B 30 43 00 01 26 22 00 0C C0 43 00 00 24 61 FF FF E0 41 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 24 02 00 01 10 62 00 39 00 00 00 00 8F BF 00 5C 02 00 10 21 8F BE 00 58 8F B7 00 54 8F B6 00 50 8F B5 00 4C 8F B4 00 48 8F B3 00 44 8F B2 00 40 8F B1 00 3C 8F B0 00 38 03 E0 00 08 27 BD 00 60 8F A4 00 60 24 02 00 0C AF A2 00 10 02 E0 28 21 24 06 00 0F 0? ?? ?? ?? 27 A7 00 20 10 53 00 4F 00 40 40 21 8F A3 00 24 14 76 FF C9 00 00 30 21 8F B0 00 28 06 00 00 4E 3C 04 ?? ?? 8F C2 00 00 02 02 10 2A 10 40 00 28 00 00 00 00 10 C0 00 35 8E A5 00 00 00 A0 20 21 00 C0 28 21 00 10 30 80 0? ?? ?? ?? AF A8 00 34 8F A8 00 34 06 00 FF C3 00 00 00 00 12 00 00 69 8E A7 00 00 8C E2 00 00 10 52 FF BE 24 E5 00 04 00 00 18 21 24 63 00 01 10 70 FF B6 24 A5 00 04 8C A6 FF FC 14 D2 FF FC 24 63 00 01 0? ?? ?? ?? 24 63 FF FF 0? ?? ?? ?? 02 20 20 21 8F BF 00 5C 02 00 10 21 8F BE 00 58 8F B7 00 54 8F B6 00 50 8F B5 00 4C 8F B4 00 48 8F B3 00 44 8F B2 00 40 8F B1 00 3C 8F B0 00 38 03 E0 00 08 27 BD 00 60 8E A4 00 00 26 05 00 01 00 05 28 80 AF A6 00 30 0? ?? ?? ?? AF A8 00 34 8F A6 00 30 10 40 00 0F 8F A8 00 34 8F B0 00 28 AE A2 00 00 00 40 28 21 26 02 00 01 14 C0 FF CD AF C2 00 00 00 10 30 80 01 00 20 21 0? ?? ?? ?? AF A8 00 34 8F B0 00 28 00 10 18 80 10 43 FF CB 8F A8 00 34 0? ?? ?? ?? 24 10 FF FF 0? ?? ?? ?? 24 10 FF FE 0? ?? ?? ?? 24 10 FF FF 24 03 00 01 3C 02 ?? ?? AC 43 ?? ?? 0? ?? ?? ?? 24 10 FF FF 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 64 0? ?? ?? ?? 24 E7 ?? ?? 14 60 00 07 AF A2 00 2C 26 94 00 01 24 02 00 05 12 82 00 04 26 23 00 0C 16 13 FF 4A 00 00 00 00 26 23 00 0C C0 62 00 00 24 41 FF FF E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 10 56 00 05 00 00 00 00 12 13 FF 7E 24 11 FF FF 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 02 20 20 21 0? ?? ?? ?? 00 00 00 00 3C 02 ?? ?? AC 43 ?? ?? 0? ?? ?? ?? 24 10 FF FF 3C 04 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 8F 0? ?? ?? ?? 24 E7 ?? ?? 0? ?? ?? ?? 00 00 18 21 }
	condition:
		$1
}

rule file_139_0_0 {
	meta:
		name = "__uselocale"
		size = 600
		refs = "0000 __gnu_local_gp 0008 __libc_tsd_LOCALE 0024 _nl_global_locale 0038 _nl_current_LC_COLLATE_used 0048 _nl_current_LC_COLLATE 0058 _nl_current_LC_CTYPE_used 0070 _nl_current_LC_CTYPE 007c _nl_current_LC_MONETARY_used 0088 _nl_current_LC_MONETARY 00a0 _nl_current_LC_NUMERIC_used 00ac _nl_current_LC_NUMERIC 00c4 _nl_current_LC_TIME_used 00d0 _nl_current_LC_TIME 00e8 _nl_current_LC_MESSAGES_used 00f4 _nl_current_LC_MESSAGES 010c _nl_current_LC_PAPER_used 0118 _nl_current_LC_PAPER 0130 _nl_current_LC_NAME_used 013c _nl_current_LC_NAME 0154 _nl_current_LC_ADDRESS_used 0160 _nl_current_LC_ADDRESS 0178 _nl_current_LC_TELEPHONE_used 0184 _nl_current_LC_TELEPHONE 019c _nl_current_LC_MEASUREMENT_used 01a8 _nl_current_LC_MEASUREMENT 01c0 _nl_current_LC_IDENTIFICATION_used 01cc _nl_current_LC_IDENTIFICATION 01e4 __libc_tsd_CTYPE_B 0200 __libc_tsd_CTYPE_TOLOWER 0204 __libc_tsd_CTYPE_TOUPPER"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 8F 86 ?? ?? 7C 03 E8 3B 00 C3 10 21 10 80 00 86 8C 45 00 00 24 02 FF FF 10 82 00 8A 3C 02 ?? ?? 24 42 ?? ?? 7C 03 E8 3B 00 C3 30 21 00 60 38 21 3C 03 ?? ?? 24 63 ?? ?? 10 60 00 05 AC C4 00 00 8F 86 ?? ?? 24 83 00 0C 00 C7 38 21 AC E3 00 00 3C 03 ?? ?? 24 63 ?? ?? 10 60 00 07 3C 03 ?? ?? 7C 03 E8 3B 00 60 30 21 8F 83 ?? ?? 00 66 30 21 AC C4 00 00 3C 03 ?? ?? 24 63 ?? ?? 10 60 00 06 8F 87 ?? ?? 7C 03 E8 3B 00 60 30 21 00 E6 30 21 24 83 00 10 AC C3 00 00 3C 03 ?? ?? 24 63 ?? ?? 10 60 00 06 8F 87 ?? ?? 7C 03 E8 3B 00 60 30 21 00 E6 30 21 24 83 00 04 AC C3 00 00 3C 03 ?? ?? 24 63 ?? ?? 10 60 00 06 8F 87 ?? ?? 7C 03 E8 3B 00 60 30 21 00 E6 30 21 24 83 00 08 AC C3 00 00 3C 03 ?? ?? 24 63 ?? ?? 10 60 00 06 8F 87 ?? ?? 7C 03 E8 3B 00 60 30 21 00 E6 30 21 24 83 00 14 AC C3 00 00 3C 03 ?? ?? 24 63 ?? ?? 10 60 00 06 8F 87 ?? ?? 7C 03 E8 3B 00 60 30 21 00 E6 30 21 24 83 00 1C AC C3 00 00 3C 03 ?? ?? 24 63 ?? ?? 10 60 00 06 8F 87 ?? ?? 7C 03 E8 3B 00 60 30 21 00 E6 30 21 24 83 00 20 AC C3 00 00 3C 03 ?? ?? 24 63 ?? ?? 10 60 00 06 8F 87 ?? ?? 7C 03 E8 3B 00 60 30 21 00 E6 30 21 24 83 00 24 AC C3 00 00 3C 03 ?? ?? 24 63 ?? ?? 10 60 00 06 8F 87 ?? ?? 7C 03 E8 3B 00 60 30 21 00 E6 30 21 24 83 00 28 AC C3 00 00 3C 03 ?? ?? 24 63 ?? ?? 10 60 00 06 8F 87 ?? ?? 7C 03 E8 3B 00 60 30 21 00 E6 30 21 24 83 00 2C AC C3 00 00 3C 03 ?? ?? 24 63 ?? ?? 10 60 00 06 8F 87 ?? ?? 7C 03 E8 3B 00 60 30 21 00 E6 30 21 24 83 00 30 AC C3 00 00 8F 89 ?? ?? 7C 03 E8 3B 8C 88 00 34 8C 87 00 38 8C 86 00 3C 01 23 48 21 00 60 20 21 8F 83 ?? ?? 8F 8A ?? ?? 00 A2 10 26 00 64 18 21 AC 67 00 00 24 03 FF FF 01 44 20 21 00 A2 18 0B AD 28 00 00 AC 86 00 00 03 E0 00 08 00 60 10 21 3C 02 ?? ?? 24 42 ?? ?? 00 A2 10 26 24 03 FF FF 00 A2 18 0B 03 E0 00 08 00 60 10 21 24 42 ?? ?? 0? ?? ?? ?? 00 40 20 21 }
	condition:
		$1
}

rule file_140_0_0 {
	meta:
		name = "xdr_int64_t"
		size = 232
	strings:
		$1 = { 8C 82 00 00 27 BD FF D0 24 03 00 01 AF B1 00 28 AF B0 00 24 AF BF 00 2C 00 80 80 21 10 43 00 09 00 A0 88 21 10 40 00 13 38 42 00 02 2C 42 00 01 8F BF 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 30 8C 82 00 04 8C 59 00 20 03 20 F8 09 27 A5 00 1C 14 40 00 18 02 00 20 21 8F BF 00 2C 8F B1 00 28 8F B0 00 24 00 00 10 21 03 E0 00 08 27 BD 00 30 8C 85 00 04 8E 23 00 00 8E 22 00 04 8C B9 00 24 AF A3 00 1C AF A2 00 18 03 20 F8 09 27 A5 00 1C 10 40 FF F2 8F BF 00 2C 8E 02 00 04 02 00 20 21 8C 59 00 24 03 20 F8 09 27 A5 00 18 0? ?? ?? ?? 00 02 10 2B 8E 02 00 04 8C 59 00 20 03 20 F8 09 27 A5 00 18 10 40 FF E5 8F BF 00 2C 8F A3 00 18 24 02 00 01 AE 23 00 04 8F A3 00 1C 0? ?? ?? ?? AE 23 00 00 }
	condition:
		$1
}

rule file_140_2_0 {
	meta:
		name = "xdr_uint64_t"
		size = 232
	strings:
		$1 = { 8C 82 00 00 27 BD FF D0 24 03 00 01 AF B1 00 28 AF B0 00 24 AF BF 00 2C 00 80 80 21 10 43 00 09 00 A0 88 21 10 40 00 13 38 42 00 02 2C 42 00 01 8F BF 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 30 8C 82 00 04 8C 59 00 20 03 20 F8 09 27 A5 00 1C 14 40 00 18 02 00 20 21 8F BF 00 2C 8F B1 00 28 8F B0 00 24 00 00 10 21 03 E0 00 08 27 BD 00 30 8C 85 00 04 8E 23 00 00 8E 22 00 04 8C B9 00 24 AF A3 00 1C AF A2 00 18 03 20 F8 09 27 A5 00 1C 10 40 FF F2 8F BF 00 2C 8E 02 00 04 02 00 20 21 8C 59 00 24 03 20 F8 09 27 A5 00 18 0? ?? ?? ?? 00 02 10 2B 8E 02 00 04 8C 59 00 20 03 20 F8 09 27 A5 00 18 10 40 FF E5 8F BF 00 2C 8F A3 00 1C 24 02 00 01 AE 23 00 00 8F A3 00 18 0? ?? ?? ?? AE 23 00 04 }
	condition:
		$1
}

rule file_140_4_0 {
	meta:
		name = "xdr_int32_t"
		size = 64
		altNames = "xdr_uint32_t"
	strings:
		$1 = { 8C 82 00 00 24 06 00 01 10 46 00 05 00 00 00 00 10 40 00 07 38 42 00 02 03 E0 00 08 2C 42 00 01 8C 82 00 04 8C 59 00 20 03 20 00 08 00 00 00 00 8C 82 00 04 8C 59 00 24 03 20 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_140_6_0 {
	meta:
		name = "xdr_int16_t"
		size = 164
	strings:
		$1 = { 8C 82 00 00 27 BD FF D8 24 06 00 01 AF B0 00 20 AF BF 00 24 10 46 00 09 00 A0 80 21 10 40 00 15 38 42 00 02 2C 43 00 01 8F BF 00 24 8F B0 00 20 00 60 10 21 03 E0 00 08 27 BD 00 28 8C 82 00 04 8C 59 00 20 03 20 F8 09 27 A5 00 18 10 40 FF F6 00 00 18 21 8F A2 00 18 8F BF 00 24 24 03 00 01 A6 02 00 00 8F B0 00 20 00 60 10 21 03 E0 00 08 27 BD 00 28 8C 83 00 04 84 A2 00 00 27 A5 00 18 8C 79 00 24 03 20 F8 09 AF A2 00 18 8F BF 00 24 00 40 18 21 8F B0 00 20 00 60 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_140_7_0 {
	meta:
		name = "xdr_uint16_t"
		size = 164
	strings:
		$1 = { 8C 82 00 00 27 BD FF D8 24 06 00 01 AF B0 00 20 AF BF 00 24 10 46 00 09 00 A0 80 21 10 40 00 15 38 42 00 02 2C 43 00 01 8F BF 00 24 8F B0 00 20 00 60 10 21 03 E0 00 08 27 BD 00 28 8C 82 00 04 8C 59 00 20 03 20 F8 09 27 A5 00 18 10 40 FF F6 00 00 18 21 8F A2 00 18 8F BF 00 24 24 03 00 01 A6 02 00 00 8F B0 00 20 00 60 10 21 03 E0 00 08 27 BD 00 28 8C 83 00 04 94 A2 00 00 27 A5 00 18 8C 79 00 24 03 20 F8 09 AF A2 00 18 8F BF 00 24 00 40 18 21 8F B0 00 20 00 60 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_140_8_0 {
	meta:
		name = "xdr_int8_t"
		size = 164
	strings:
		$1 = { 8C 82 00 00 27 BD FF D8 24 06 00 01 AF B0 00 20 AF BF 00 24 10 46 00 09 00 A0 80 21 10 40 00 15 38 42 00 02 2C 43 00 01 8F BF 00 24 8F B0 00 20 00 60 10 21 03 E0 00 08 27 BD 00 28 8C 82 00 04 8C 59 00 20 03 20 F8 09 27 A5 00 18 10 40 FF F6 00 00 18 21 8F A2 00 18 24 03 00 01 A2 02 00 00 8F BF 00 24 8F B0 00 20 00 60 10 21 03 E0 00 08 27 BD 00 28 8C 83 00 04 80 A2 00 00 27 A5 00 18 8C 79 00 24 03 20 F8 09 AF A2 00 18 8F BF 00 24 00 40 18 21 8F B0 00 20 00 60 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_140_9_0 {
	meta:
		name = "xdr_uint8_t"
		size = 164
	strings:
		$1 = { 8C 82 00 00 27 BD FF D8 24 06 00 01 AF B0 00 20 AF BF 00 24 10 46 00 09 00 A0 80 21 10 40 00 15 38 42 00 02 2C 43 00 01 8F BF 00 24 8F B0 00 20 00 60 10 21 03 E0 00 08 27 BD 00 28 8C 82 00 04 8C 59 00 20 03 20 F8 09 27 A5 00 18 10 40 FF F6 00 00 18 21 8F A2 00 18 24 03 00 01 A2 02 00 00 8F BF 00 24 8F B0 00 20 00 60 10 21 03 E0 00 08 27 BD 00 28 8C 83 00 04 90 A2 00 00 27 A5 00 18 8C 79 00 24 03 20 F8 09 AF A2 00 18 8F BF 00 24 00 40 18 21 8F B0 00 20 00 60 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_141_0_0 {
	meta:
		name = "__remap_file_pages"
		size = 28
	strings:
		$1 = { 24 02 10 9B 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_142_0_0 {
	meta:
		name = "___vfprintf_chk"
		size = 512
		refs = "007c __lll_lock_wait_private 00b4 vfprintf 01ac _Unwind_Resume"
	strings:
		$1 = { 8C 82 00 00 27 BD FF C8 AF B3 00 2C 30 42 80 00 AF B2 00 28 AF B1 00 24 AF B0 00 20 AF BF 00 34 AF B4 00 30 00 80 80 21 00 A0 90 21 00 C0 98 21 14 40 00 1A 00 E0 88 21 7C 03 E8 3B 8C 84 00 48 24 74 8B 70 8C 82 00 08 10 54 00 11 00 00 00 00 AF A0 00 18 C0 83 00 00 14 60 00 06 24 02 00 00 24 01 00 01 E0 81 00 00 10 20 FF FA 24 02 00 01 00 00 00 0F 14 40 00 03 00 00 00 00 0? ?? ?? ?? AF A3 00 18 8E 02 00 48 00 40 20 21 AC 54 00 08 8C 82 00 04 24 42 00 01 AC 82 00 04 1A 40 00 04 02 00 20 21 8E 02 00 3C 34 42 00 04 AE 02 00 3C 02 60 28 21 0? ?? ?? ?? 02 20 30 21 1A 40 00 19 00 40 88 21 8E 03 00 3C 24 02 FF FB 00 62 10 24 AE 02 00 3C 8E 03 00 00 24 04 FF EB 00 44 10 24 30 63 80 00 14 60 00 06 AE 02 00 3C 8E 04 00 48 8C 82 00 04 24 42 FF FF 10 40 00 0C AC 82 00 04 8F BF 00 34 02 20 10 21 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 38 0? ?? ?? ?? 8E 02 00 3C AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF EC 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 34 8E 05 00 3C 8E 02 00 00 24 03 FF EB 00 A3 18 24 30 42 80 00 00 80 88 21 14 40 00 06 AE 03 00 3C 8E 04 00 48 8C 83 00 04 24 63 FF FF 10 60 00 03 AC 83 00 04 0? ?? ?? ?? 02 20 20 21 AC 80 00 08 00 00 00 0F C0 83 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 63 00 02 14 60 FF F5 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_1259_0_0 {
	meta:
		name = "__vfwprintf_chk"
		size = 512
		refs = "007c __lll_lock_wait_private 00b4 _IO_vfwprintf 01ac _Unwind_Resume"
	strings:
		$1 = { 8C 82 00 00 27 BD FF C8 AF B3 00 2C 30 42 80 00 AF B2 00 28 AF B1 00 24 AF B0 00 20 AF BF 00 34 AF B4 00 30 00 80 80 21 00 A0 90 21 00 C0 98 21 14 40 00 1A 00 E0 88 21 7C 03 E8 3B 8C 84 00 48 24 74 8B 70 8C 82 00 08 10 54 00 11 00 00 00 00 AF A0 00 18 C0 83 00 00 14 60 00 06 24 02 00 00 24 01 00 01 E0 81 00 00 10 20 FF FA 24 02 00 01 00 00 00 0F 14 40 00 03 00 00 00 00 0? ?? ?? ?? AF A3 00 18 8E 02 00 48 00 40 20 21 AC 54 00 08 8C 82 00 04 24 42 00 01 AC 82 00 04 1A 40 00 04 02 00 20 21 8E 02 00 3C 34 42 00 04 AE 02 00 3C 02 60 28 21 0? ?? ?? ?? 02 20 30 21 1A 40 00 19 00 40 88 21 8E 03 00 3C 24 02 FF FB 00 62 10 24 AE 02 00 3C 8E 03 00 00 24 04 FF EB 00 44 10 24 30 63 80 00 14 60 00 06 AE 02 00 3C 8E 04 00 48 8C 82 00 04 24 42 FF FF 10 40 00 0C AC 82 00 04 8F BF 00 34 02 20 10 21 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 38 0? ?? ?? ?? 8E 02 00 3C AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF EC 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 34 8E 05 00 3C 8E 02 00 00 24 03 FF EB 00 A3 18 24 30 42 80 00 00 80 88 21 14 40 00 06 AE 03 00 3C 8E 04 00 48 8C 83 00 04 24 63 FF FF 10 60 00 03 AC 83 00 04 0? ?? ?? ?? 02 20 20 21 AC 80 00 08 00 00 00 0F C0 83 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 63 00 02 14 60 FF F5 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_143_0_0 {
	meta:
		name = "sigemptyset"
		size = 84
		refs = "0000 __gnu_local_gp 001c memset 003c __libc_errno"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF E0 27 9C ?? ?? AF BF 00 1C 10 80 00 08 AF BC 00 10 00 00 28 21 0? ?? ?? ?? 24 06 00 80 00 00 10 21 8F BF 00 1C 03 E0 00 08 27 BD 00 20 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 16 AC 43 00 00 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "w_addword"
		size = 228
		refs = "0034 realloc 009c calloc 00d4 free"
	strings:
		$1 = { 27 BD FF D8 AF B1 00 1C AF B0 00 18 AF BF 00 24 AF B2 00 20 00 A0 88 21 10 A0 00 1F 00 80 80 21 8C 85 00 00 8C 82 00 08 8C 84 00 04 00 A2 28 21 24 A5 00 02 0? ?? ?? ?? 00 05 28 80 10 40 00 27 00 00 00 00 8E 05 00 00 8E 03 00 08 AE 02 00 04 24 A4 00 01 00 A3 28 21 00 05 28 80 00 45 30 21 AE 04 00 00 AC D1 00 00 8E 02 00 04 00 83 18 21 00 03 18 80 00 43 18 21 AC 60 00 00 00 00 10 21 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 24 04 00 01 0? ?? ?? ?? 24 05 00 01 00 40 90 21 10 40 00 0C 00 40 88 21 8E 05 00 00 8E 02 00 08 8E 04 00 04 00 A2 28 21 24 A5 00 02 0? ?? ?? ?? 00 05 28 80 14 40 FF DD 00 00 00 00 0? ?? ?? ?? 02 40 20 21 0? ?? ?? ?? 24 02 00 01 }
	condition:
		$1
}

rule file_144_1_0 {
	meta:
		name = "w_addchar"
		size = 196
		refs = "007c realloc 0098 free 006c $LC0 00a8 $LC1 00bc __assert_fail 00ac __PRETTY_FUNCTION__.10516"
	strings:
		$1 = { 27 BD FF D0 8C C2 00 00 AF B1 00 28 00 A0 88 21 8C A5 00 00 AF B0 00 24 AF BF 00 2C 10 A2 00 10 00 80 80 21 10 80 00 09 8F BF 00 2C 02 05 28 21 A0 A7 00 00 8E 22 00 00 24 42 00 01 02 02 18 21 AE 22 00 00 A0 60 00 00 8F BF 00 2C 02 00 10 21 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 30 10 80 00 03 24 A2 00 64 10 A0 00 0F 3C 04 ?? ?? AC C2 00 00 02 00 20 21 24 A5 00 65 0? ?? ?? ?? AF A7 00 18 10 40 00 04 8F A7 00 18 8E 25 00 00 0? ?? ?? ?? 00 40 80 21 0? ?? ?? ?? 02 00 20 21 0? ?? ?? ?? 00 00 80 21 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 66 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_144_2_0 {
	meta:
		name = "parse_backslash"
		size = 164
	strings:
		$1 = { 27 BD FF D8 AF B0 00 1C 8F B0 00 38 AF BF 00 24 AF B1 00 20 8E 02 00 00 24 42 00 01 00 E2 38 21 80 E7 00 00 10 E0 00 17 24 03 00 0A 10 E3 00 0F 8F BF 00 24 00 80 88 21 0? ?? ?? ?? 8C 84 00 00 10 40 00 16 AE 22 00 00 8E 03 00 00 00 00 10 21 24 63 00 01 AE 03 00 00 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 AE 02 00 00 8F B1 00 20 8F B0 00 1C 00 00 10 21 03 E0 00 08 27 BD 00 28 8F BF 00 24 8F B1 00 20 8F B0 00 1C 24 02 00 05 03 E0 00 08 27 BD 00 28 0? ?? ?? ?? 24 02 00 01 }
	condition:
		$1
}

rule file_144_3_0 {
	meta:
		name = "parse_qtd_backslash"
		size = 348
	strings:
		$1 = { 27 BD FF D0 AF B0 00 18 8F B0 00 40 AF B1 00 1C 00 E0 88 21 8E 07 00 00 AF B4 00 28 AF B3 00 24 24 E8 00 01 AF B2 00 20 02 28 10 21 AF BF 00 2C 80 43 00 00 24 02 00 22 00 80 90 21 00 A0 A0 21 10 62 00 33 00 C0 98 21 28 62 00 23 10 40 00 0F 00 00 00 00 10 60 00 05 24 02 00 05 24 02 00 0A 14 62 00 11 00 00 10 21 AE 08 00 00 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 30 24 02 00 5C 10 62 00 1F 24 02 00 60 10 62 00 1D 24 02 00 24 10 62 00 1B 00 00 00 00 02 27 38 21 8E 44 00 00 80 E7 00 00 02 80 28 21 0? ?? ?? ?? 02 60 30 21 10 40 00 0A AE 42 00 00 8E 03 00 00 00 40 20 21 02 80 28 21 02 23 88 21 82 27 00 01 0? ?? ?? ?? 02 60 30 21 14 40 00 11 AE 42 00 00 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 24 02 00 01 03 E0 00 08 27 BD 00 30 8E 44 00 00 02 80 28 21 02 60 30 21 0? ?? ?? ?? 00 60 38 21 10 40 FF F1 AE 42 00 00 8E 03 00 00 8F BF 00 2C 8F B4 00 28 24 63 00 01 AE 03 00 00 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 00 00 10 21 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_144_4_0 {
	meta:
		name = "w_addmem"
		size = 240
		refs = "0060 realloc 0080 mempcpy 00c4 free 0040 $LC0 00d4 $LC1 00e8 __assert_fail 00d8 __PRETTY_FUNCTION__.10525"
	strings:
		$1 = { 27 BD FF D0 8C A3 00 00 AF B1 00 24 8F B1 00 40 8C C2 00 00 AF B0 00 20 00 80 80 21 00 71 20 21 00 44 20 2B AF B2 00 28 AF BF 00 2C 10 80 00 21 00 A0 90 21 12 00 00 03 00 11 18 40 10 40 00 25 3C 04 ?? ?? 2C 65 00 64 24 04 00 64 00 85 18 0B 00 62 28 21 AC C5 00 00 02 00 20 21 24 A5 00 01 0? ?? ?? ?? AF A7 00 18 10 40 00 16 8F A7 00 18 8E 44 00 00 00 40 80 21 02 20 30 21 02 04 20 21 0? ?? ?? ?? 00 E0 28 21 A0 40 00 00 8E 42 00 00 00 51 88 21 AE 51 00 00 8F BF 00 2C 02 00 10 21 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 30 12 00 FF F8 00 60 20 21 0? ?? ?? ?? 02 20 30 21 0? ?? ?? ?? 02 00 20 21 0? ?? ?? ?? 00 00 80 21 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 81 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_144_5_0 {
	meta:
		name = "exec_comm"
		size = 1800
		refs = "0000 __gnu_local_gp 0054 __have_pipe2 0070 __pipe2 00ac __libc_errno 00c0 __pipe 00e4 __fork 010c __close 0130 __read 0154 strchr 023c __waitpid 031c __kill 0518 free 0558 $LC2 0564 $LC3 0594 __dup2 05b4 $LC4 05bc __open 05f0 __fxstat64 061c _exit 069c $LC6 06bc __unsetenv 06b8 $LC5 06cc __environ 06d8 __execve 06e0 abort 06f8 __fcntl"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FE 70 27 9C ?? ?? AF BF 01 8C AF BE 01 88 AF B7 01 84 AF B6 01 80 AF B5 01 7C AF B4 01 78 AF B3 01 74 AF B2 01 70 AF B1 01 6C AF B0 01 68 AF BC 00 18 AF A4 01 90 AF A7 01 9C 10 80 00 E8 AF A0 01 58 8F A3 01 90 80 62 00 00 10 40 00 E4 3C 04 ?? ?? 8C 82 ?? ?? 00 A0 98 21 00 C0 B0 21 04 40 00 16 27 B0 01 50 02 00 20 21 0? ?? ?? ?? 3C 05 00 08 3C 04 ?? ?? 8C 83 ?? ?? 14 60 00 07 8F BC 00 18 24 03 FF FF 10 43 01 1A 24 04 00 01 3C 03 ?? ?? AC 64 ?? ?? 00 80 18 21 18 60 00 05 00 00 00 00 04 41 00 0A 8F 9E ?? ?? 0? ?? ?? ?? 24 02 00 01 04 61 00 06 8F 9E ?? ?? 0? ?? ?? ?? 02 00 20 21 04 40 FF F9 8F BC 00 18 8F 9E ?? ?? 7C 03 E8 3B 00 00 80 21 00 00 A0 21 03 C3 F0 21 0? ?? ?? ?? 00 00 00 00 AF A2 01 60 04 40 01 4C 8F BC 00 18 8F A4 01 60 10 80 01 15 00 00 00 00 16 00 01 4D 8F 92 ?? ?? 0? ?? ?? ?? 8F A4 01 54 24 02 FF FF AF A2 01 54 8F A2 01 A4 10 40 00 BD 00 00 90 21 8F A4 01 50 27 A5 00 C0 0? ?? ?? ?? 24 06 00 80 24 03 FF FF 10 43 00 33 00 40 A8 21 18 40 00 35 00 00 00 00 0? ?? ?? ?? 00 00 80 21 0? ?? ?? ?? 02 E0 28 21 14 40 00 61 24 04 00 0A 24 02 00 02 12 42 00 8C 8F A4 01 A4 8E 65 00 00 0? ?? ?? ?? 00 00 90 21 24 03 00 01 10 43 00 65 8F A4 01 60 8F A2 01 9C 00 00 A0 21 AC 40 00 00 AE C0 00 00 AE 60 00 00 26 10 00 01 02 15 10 2A 10 40 FF E1 8F A4 01 50 27 A3 00 C0 00 70 88 21 82 37 00 00 8F A4 01 A8 0? ?? ?? ?? 02 E0 28 21 14 40 FF E3 8F A4 01 AC 24 04 00 03 12 44 00 78 8F A4 01 A4 8E 63 00 00 8F A6 01 9C 3A E2 00 0A 26 94 00 01 00 60 20 21 02 C0 28 21 02 E0 38 21 0? ?? ?? ?? 00 02 A0 0B 10 40 00 45 AE 62 00 00 0? ?? ?? ?? 24 12 00 01 8F C3 00 00 24 02 00 04 10 62 FF C5 8F A4 01 50 00 15 A8 2B 0? ?? ?? ?? 24 10 00 04 8F C2 00 00 14 50 00 0A 00 00 00 00 8F A4 01 60 27 A5 01 58 0? ?? ?? ?? 02 A0 30 21 24 04 FF FF 10 44 FF F7 00 00 00 00 10 40 FF B6 8F A4 01 50 0? ?? ?? ?? 24 10 00 04 8F C2 00 00 14 50 00 0B 00 00 00 00 8F A4 01 50 27 A5 00 C0 0? ?? ?? ?? 24 06 00 80 00 40 A8 21 24 02 FF FF 12 A2 FF F6 00 00 00 00 1E A0 FF AF 00 00 00 00 26 94 FF FF 24 06 FF FF 24 05 00 0A 12 86 00 A3 00 00 00 00 8E C3 00 00 10 60 00 A0 24 63 FF FF 8E 62 00 00 00 43 10 21 80 44 00 00 14 85 00 9B 00 00 00 00 AE C3 00 00 A0 40 00 00 8E C2 00 00 10 40 00 90 26 83 FF FF 0? ?? ?? ?? 00 60 A0 21 12 E4 00 2F 24 04 FF FD 02 44 18 24 24 02 00 01 14 62 FF A9 8F A4 01 A4 8E 65 00 00 0? ?? ?? ?? 24 12 00 02 24 03 00 01 14 43 FF 9F 8F A2 01 9C 8F A4 01 60 24 05 00 09 0? ?? ?? ?? 24 10 FF FF 8F BC 00 18 7C 03 E8 3B 24 11 00 04 8F 92 ?? ?? 0? ?? ?? ?? 02 43 90 21 8E 42 00 00 14 51 00 07 00 00 00 00 8F A4 01 60 00 00 28 21 0? ?? ?? ?? 00 00 30 21 10 50 FF F8 00 00 00 00 0? ?? ?? ?? 8F A4 01 50 24 02 00 01 8F BF 01 8C 8F BE 01 88 8F B7 01 84 8F B6 01 80 8F B5 01 7C 8F B4 01 78 8F B3 01 74 8F B2 01 70 8F B1 01 6C 8F B0 01 68 03 E0 00 08 27 BD 01 90 0? ?? ?? ?? 00 00 90 21 3A 42 00 01 24 03 00 03 0? ?? ?? ?? 00 62 90 0A 8E 65 00 00 0? ?? ?? ?? AF A2 01 64 24 04 00 01 10 44 FF D3 8F A3 01 64 8F A2 01 9C 82 37 00 00 AC 40 00 00 AE C0 00 00 0? ?? ?? ?? AE 60 00 00 8F BF 01 8C 8F BE 01 88 8F B7 01 84 8F B6 01 80 8F B5 01 7C 8F B4 01 78 8F B3 01 74 8F B2 01 70 8F B1 01 6C 8F B0 01 68 00 00 10 21 03 E0 00 08 27 BD 01 90 24 10 FF FF 8F A4 01 50 27 A5 00 C0 0? ?? ?? ?? 24 06 00 80 10 50 00 12 00 00 00 00 18 40 00 14 00 02 88 2B 8E 64 00 00 8F A6 01 9C AF A2 00 10 02 C0 28 21 27 A7 00 C0 0? ?? ?? ?? 02 82 A0 21 10 40 FF AE AE 62 00 00 8F A4 01 50 27 A5 00 C0 0? ?? ?? ?? 24 06 00 80 14 50 FF F0 00 00 00 00 8F C4 00 00 24 03 00 04 10 83 FF E6 00 02 88 2B 0? ?? ?? ?? 24 12 00 04 8F C2 00 00 14 52 00 09 00 00 00 00 8F A4 01 60 27 A5 01 58 0? ?? ?? ?? 02 20 30 21 10 50 FF F8 00 00 00 00 10 40 FF DA 8F A4 01 50 0? ?? ?? ?? 24 12 00 04 8F C2 00 00 14 52 FF 72 00 00 00 00 8F A4 01 50 27 A5 00 C0 0? ?? ?? ?? 24 06 00 80 10 50 FF F8 00 00 00 00 1C 40 FF D4 00 00 00 00 0? ?? ?? ?? 26 94 FF FF 7C 03 E8 3B 00 60 28 21 8F 83 ?? ?? 00 65 28 21 8C A3 00 00 38 63 00 59 0? ?? ?? ?? 00 43 20 0A 0? ?? ?? ?? 8E 64 00 00 8F A3 01 9C AC 60 00 00 AE C0 00 00 AE 60 00 00 0? ?? ?? ?? 8F A4 01 50 24 02 FF FF AF A2 01 50 8F A2 01 58 10 40 FF A7 24 10 00 01 0? ?? ?? ?? 00 00 00 00 16 00 00 4E 3C 10 ?? ?? 26 02 ?? ?? AF A2 01 40 3C 02 ?? ?? 24 42 ?? ?? 8F B1 01 A0 AF A2 01 44 8F A2 01 90 32 31 00 10 AF A0 01 4C AF A2 01 48 8F A4 01 54 24 02 00 01 10 82 00 56 3C 03 ?? ?? 0? ?? ?? ?? 24 05 00 01 0? ?? ?? ?? 8F A4 01 54 16 20 00 45 3C 04 ?? ?? 0? ?? ?? ?? 24 04 00 02 3C 04 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 24 05 00 01 04 40 00 08 00 40 88 21 24 02 00 02 12 22 00 05 02 20 20 21 0? ?? ?? ?? 24 05 00 02 0? ?? ?? ?? 02 20 20 21 24 04 00 03 24 05 00 02 0? ?? ?? ?? 27 A6 00 20 14 40 00 08 8F A3 00 38 24 02 20 00 30 63 F0 00 14 62 00 04 8F A3 00 48 24 02 01 03 10 62 00 28 00 00 00 00 0? ?? ?? ?? 24 04 00 5A 0? ?? ?? ?? 8F A4 01 50 0? ?? ?? ?? 8F A4 01 54 0? ?? ?? ?? 24 02 00 01 7C 03 E8 3B 24 10 FF FF 02 43 90 21 0? ?? ?? ?? 24 11 00 04 8E 42 00 00 14 51 FF 64 8F BF 01 8C 8F A4 01 60 27 A5 01 58 0? ?? ?? ?? 00 00 30 21 10 50 FF F8 00 40 18 21 8F A4 01 60 14 83 FF 3C 00 00 10 21 8F A3 01 58 24 02 00 05 0? ?? ?? ?? 00 03 10 0A 26 02 ?? ?? 8F A4 01 90 AF A2 01 40 3C 02 ?? ?? 24 42 ?? ?? AF A4 01 48 AF A0 01 4C AF A2 01 44 0? ?? ?? ?? 00 00 88 21 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 8F A4 01 50 3C 02 ?? ?? 8C 46 ?? ?? 26 04 ?? ?? 0? ?? ?? ?? 27 A5 01 40 0? ?? ?? ?? 00 00 00 00 8C 62 ?? ?? 18 40 FF AD 24 05 00 02 24 04 00 01 0? ?? ?? ?? 00 00 30 21 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_144_6_0 {
	meta:
		name = "parse_backtick"
		size = 428
		refs = "00b4 free"
	strings:
		$1 = { 27 BD FF 98 AF B0 00 44 8F B0 00 78 AF B7 00 60 AF BF 00 64 8E 03 00 00 AF B6 00 5C AF B5 00 58 AF B4 00 54 AF B3 00 50 AF B2 00 4C AF B1 00 48 00 E3 10 21 00 E0 B8 21 80 47 00 00 AF A0 00 2C AF A0 00 30 10 E0 00 57 AF A0 00 28 00 80 B0 21 00 A0 A8 21 00 C0 A0 21 00 00 90 21 24 11 00 5C 24 13 00 60 10 F1 00 33 00 00 00 00 10 F3 00 15 24 03 00 27 14 E3 00 03 8F A4 00 28 24 03 00 01 00 72 90 23 27 A5 00 30 0? ?? ?? ?? 27 A6 00 2C 10 40 00 42 AF A2 00 28 8E 03 00 00 24 63 00 01 AE 03 00 00 02 E3 10 21 80 47 00 00 14 E0 FF ED 8F A4 00 28 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 24 02 00 05 8F A2 00 7C 8F A4 00 28 02 C0 28 21 AF A2 00 10 8F A2 00 80 02 A0 30 21 02 80 38 21 AF A2 00 14 8F A2 00 84 AF A2 00 18 8F A2 00 88 0? ?? ?? ?? AF A2 00 1C 8F A4 00 28 0? ?? ?? ?? 00 40 80 21 02 00 10 21 8F BF 00 64 8F B7 00 60 8F B6 00 5C 8F B5 00 58 8F B4 00 54 8F B3 00 50 8F B2 00 4C 8F B1 00 48 8F B0 00 44 03 E0 00 08 27 BD 00 68 12 40 00 0B 24 63 00 01 AF B0 00 10 27 A4 00 28 27 A5 00 30 27 A6 00 2C 0? ?? ?? ?? 02 E0 38 21 14 40 00 0C 24 12 00 01 0? ?? ?? ?? 8E 03 00 00 AE 03 00 00 27 A4 00 28 AF B0 00 10 27 A5 00 30 27 A6 00 2C 0? ?? ?? ?? 02 E0 38 21 10 40 FF C5 00 00 00 00 8F A4 00 28 0? ?? ?? ?? AF A2 00 38 0? ?? ?? ?? 8F A2 00 38 0? ?? ?? ?? 24 02 00 01 0? ?? ?? ?? 00 00 20 21 }
	condition:
		$1
}

rule file_144_7_0 {
	meta:
		name = "eval_expr_multdiv"
		size = 332
		refs = "0000 __gnu_local_gp 0068 __libc_tsd_CTYPE_B"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF C8 27 9C ?? ?? AF B4 00 30 AF B2 00 28 AF B1 00 24 AF BC 00 10 AF BF 00 34 AF B3 00 2C AF B0 00 20 00 80 90 21 0? ?? ?? ?? 00 A0 A0 21 00 40 88 21 10 40 00 0B 8F BC 00 10 24 11 00 05 8F BF 00 34 02 20 10 21 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 38 8F 93 ?? ?? 7C 03 E8 3B 24 10 00 2A 02 63 98 21 8E 47 00 00 80 E6 00 00 10 C0 FF F0 00 06 10 40 8E 63 00 00 00 62 10 21 94 42 00 00 30 42 00 20 10 40 00 11 00 00 00 00 0? ?? ?? ?? 24 E3 00 01 80 66 00 00 24 63 00 01 10 C0 FF E4 00 06 40 40 8E 62 00 00 00 48 40 21 95 08 00 00 31 08 00 20 11 00 00 05 00 00 00 00 00 60 38 21 14 60 FF F4 AE 43 00 00 80 06 00 00 10 D0 00 0F 24 02 00 2F 14 C2 FF D6 24 E7 00 01 AE 47 00 00 02 40 20 21 0? ?? ?? ?? 27 A5 00 18 14 40 FF CF 8F A2 00 18 8E 83 00 00 00 62 00 1A 00 40 01 F4 00 00 10 12 0? ?? ?? ?? AE 82 00 00 24 E7 00 01 AE 47 00 00 02 40 20 21 0? ?? ?? ?? 27 A5 00 18 14 40 FF C2 8F A2 00 18 8E 83 00 00 70 62 10 02 0? ?? ?? ?? AE 82 00 00 }
	condition:
		$1
}

rule file_144_8_0 {
	meta:
		name = "eval_expr_val"
		size = 364
		refs = "0010 __gnu_local_gp 0038 __libc_tsd_CTYPE_B 0110 strtol"
	strings:
		$1 = { 27 BD FF D8 AF B1 00 1C 00 80 88 21 8C 84 00 00 3C 1C ?? ?? 27 9C ?? ?? AF B2 00 20 AF BF 00 24 AF B0 00 18 AF BC 00 10 10 80 00 1B 00 A0 90 21 80 82 00 00 10 40 00 33 8F 85 ?? ?? 7C 03 E8 3B 00 60 30 21 00 A6 30 21 8C C6 00 00 00 02 18 40 00 C3 18 21 94 63 00 00 30 63 00 20 14 60 00 0B 00 80 80 21 0? ?? ?? ?? 24 03 00 28 82 02 00 00 00 02 18 40 10 40 00 24 00 C3 18 21 94 63 00 00 30 63 00 20 10 60 00 07 24 03 00 28 26 10 00 01 16 00 FF F6 00 00 00 00 80 02 00 00 00 00 80 21 24 03 00 28 14 43 00 18 00 00 00 00 80 82 00 00 10 40 00 0E 8F BF 00 24 24 03 00 29 10 43 00 20 24 82 00 01 0? ?? ?? ?? 24 04 00 29 10 64 00 1D 00 00 00 00 AE 22 00 00 80 43 00 00 00 40 30 21 14 60 FF FA 24 42 00 01 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 24 02 00 05 03 E0 00 08 27 BD 00 28 00 80 80 21 02 00 20 21 02 20 28 21 0? ?? ?? ?? 00 00 30 21 8E 23 00 00 10 70 FF F2 AE 42 00 00 00 00 10 21 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 00 80 30 21 24 C2 00 01 AE 22 00 00 26 04 00 01 A0 C0 00 00 0? ?? ?? ?? 02 40 28 21 14 40 FF E3 8F BF 00 24 0? ?? ?? ?? 00 00 10 21 }
	condition:
		$1
}

rule file_144_9_0 {
	meta:
		name = "eval_expr"
		size = 320
		refs = "0004 __gnu_local_gp 0064 __libc_tsd_CTYPE_B"
	strings:
		$1 = { 27 BD FF C8 3C 1C ?? ?? 27 9C ?? ?? AF A4 00 38 27 A4 00 38 AF B3 00 30 AF B2 00 2C AF BC 00 10 AF BF 00 34 AF B1 00 28 AF B0 00 24 0? ?? ?? ?? 00 A0 98 21 00 40 90 21 10 40 00 0A 8F BC 00 10 24 12 00 05 8F BF 00 34 02 40 10 21 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 38 8F 91 ?? ?? 7C 03 E8 3B 24 10 00 2B 02 23 88 21 8F A7 00 38 80 E4 00 00 10 80 FF F1 00 04 18 40 8E 22 00 00 00 43 18 21 94 63 00 00 30 63 00 20 10 60 00 11 00 00 00 00 0? ?? ?? ?? 24 E3 00 01 80 64 00 00 24 63 00 01 00 04 30 40 10 80 FF E4 00 46 30 21 94 C6 00 00 30 C6 00 20 10 C0 00 06 00 00 00 00 AF A3 00 38 14 60 FF F5 00 60 38 21 80 04 00 00 00 00 38 21 10 90 00 0D 24 02 00 2D 14 82 FF D7 24 E7 00 01 27 A4 00 38 27 A5 00 18 0? ?? ?? ?? AF A7 00 38 14 40 FF D0 8F A2 00 18 8E 63 00 00 00 62 10 23 0? ?? ?? ?? AE 62 00 00 24 E7 00 01 27 A4 00 38 27 A5 00 18 0? ?? ?? ?? AF A7 00 38 14 40 FF C5 8F A2 00 18 8E 63 00 00 00 62 10 21 0? ?? ?? ?? AE 62 00 00 }
	condition:
		$1
}

rule file_144_10_0 {
	meta:
		name = "w_addstr"
		size = 112
		refs = "0020 strlen 0050 $LC7 0054 $LC1 0068 __assert_fail 0058 __PRETTY_FUNCTION__.10533"
	strings:
		$1 = { 27 BD FF C8 AF BF 00 34 10 E0 00 11 AF B0 00 30 00 80 80 21 00 E0 20 21 AF A5 00 20 AF A6 00 24 0? ?? ?? ?? AF A7 00 28 8F A5 00 20 8F A6 00 24 8F A7 00 28 02 00 20 21 0? ?? ?? ?? AF A2 00 10 8F BF 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 38 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 9B 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_144_11_0 {
	meta:
		name = "parse_tilde"
		size = 1088
		refs = "0008 __gnu_local_gp 0074 strchr 0130 __strnlen 0158 memcpy 016c __libc_errno 01c8 __getpwnam_r 02f4 getenv 02f0 $LC8 0354 __getuid 03c0 __getpwuid_r"
	strings:
		$1 = { 8C A2 00 00 27 BD FF 90 3C 1C ?? ?? 27 9C ?? ?? AF BE 00 68 03 A0 F0 21 AF BF 00 6C AF B7 00 64 AF B6 00 60 AF B5 00 5C AF B4 00 58 AF B3 00 54 AF B2 00 50 AF B1 00 4C AF B0 00 48 AF DC 00 18 AF C5 00 74 AF C4 00 70 10 40 00 11 AF C6 00 78 8C 90 00 00 24 03 00 3D 02 02 10 21 80 42 FF FF 10 43 00 08 24 03 00 3A 14 43 00 79 02 00 20 21 24 05 00 3D 0? ?? ?? ?? AF C7 00 40 10 40 00 74 8F C7 00 40 8F C2 00 84 14 40 00 72 8F C5 00 74 8F C2 00 80 24 03 FF DF 8C 45 00 00 24 AD 00 01 00 ED 88 21 82 22 00 00 00 43 18 24 10 60 00 90 24 03 00 3A 10 43 00 8E 24 03 00 2F 10 43 00 8C 24 03 00 09 10 43 00 8A 24 03 00 5C 10 43 00 97 01 A0 80 21 24 08 FF DF 24 09 00 3A 24 0A 00 2F 24 0B 00 09 0? ?? ?? ?? 24 0C 00 5C 10 49 00 0D 00 00 00 00 10 4A 00 0B 00 00 00 00 10 4B 00 09 00 00 00 00 10 4C 00 89 00 60 80 21 26 03 00 01 00 E3 10 21 80 42 00 00 00 48 30 24 14 C0 FF F3 00 00 00 00 11 A3 00 73 3C 04 ?? ?? 02 20 20 21 0? ?? ?? ?? 02 05 28 23 24 43 00 0F 00 03 18 C2 00 03 18 C0 03 A3 E8 23 27 A4 00 18 00 82 18 21 02 20 28 21 A0 60 00 00 0? ?? ?? ?? 00 40 30 21 8F DC 00 18 27 BD FC 10 7C 03 E8 3B 8F 95 ?? ?? 00 40 90 21 27 B4 00 18 24 16 03 E8 27 D1 00 3C 27 D7 00 20 02 A3 A8 21 0? ?? ?? ?? 24 13 FF F0 8E A2 00 00 24 05 00 22 14 45 00 42 00 60 B0 21 03 A4 E8 23 27 A2 00 18 00 43 20 21 02 84 48 26 01 09 B0 0A 00 40 A0 21 02 40 20 21 AF B1 00 10 02 80 30 21 02 C0 38 21 0? ?? ?? ?? 02 E0 28 21 26 C3 03 F7 00 73 18 24 24 64 00 08 14 40 FF EC 00 76 40 21 8F C2 00 3C 10 40 00 2E 8F C7 00 34 10 E0 00 2C 8F C2 00 70 8F C5 00 74 8F C6 00 78 0? ?? ?? ?? 8C 44 00 00 8F C3 00 70 AC 62 00 00 8F C3 00 80 AC 70 00 00 2C 42 00 01 03 C0 E8 21 8F BF 00 6C 8F BE 00 68 8F B7 00 64 8F B6 00 60 8F B5 00 5C 8F B4 00 58 8F B3 00 54 8F B2 00 50 8F B1 00 4C 8F B0 00 48 03 E0 00 08 27 BD 00 70 8F C5 00 74 8F C6 00 78 02 00 20 21 0? ?? ?? ?? 24 07 00 7E 8F C3 00 70 AC 62 00 00 2C 42 00 01 03 C0 E8 21 8F BF 00 6C 8F BE 00 68 8F B7 00 64 8F B6 00 60 8F B5 00 5C 8F B4 00 58 8F B3 00 54 8F B2 00 50 8F B1 00 4C 8F B0 00 48 03 E0 00 08 27 BD 00 70 8F C5 00 70 8F C6 00 78 24 07 00 7E 8C A4 00 00 0? ?? ?? ?? 8F C5 00 74 8F C3 00 70 10 40 FF D3 AC 62 00 00 8F C5 00 74 8F C6 00 78 00 40 20 21 0? ?? ?? ?? 02 40 38 21 8F C5 00 70 8F C3 00 80 AC A2 00 00 0? ?? ?? ?? AC 70 00 00 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 10 40 00 15 8F C3 00 70 8F C5 00 74 8F C6 00 78 8C 64 00 00 0? ?? ?? ?? 00 40 38 21 8F C5 00 70 14 40 FF BE AC A2 00 00 0? ?? ?? ?? 24 02 00 01 8F C3 00 70 8F C5 00 74 8F C6 00 78 8C 64 00 00 0? ?? ?? ?? 24 07 00 7E 8F C5 00 70 AC A2 00 00 0? ?? ?? ?? 2C 42 00 01 0? ?? ?? ?? 24 14 03 E8 8F DC 00 18 27 BD FC 10 7C 03 E8 3B 8F 88 ?? ?? 00 40 90 21 27 B5 00 18 27 D1 00 3C 27 D7 00 20 01 03 B0 21 24 13 00 22 0? ?? ?? ?? 24 10 FF F0 8E C2 00 00 14 53 00 21 8F C5 00 70 03 A4 E8 23 27 A2 00 18 00 43 20 21 02 A4 A8 26 00 75 A0 0B 00 40 A8 21 02 80 38 21 02 40 20 21 AF B1 00 10 02 A0 30 21 0? ?? ?? ?? 02 E0 28 21 26 83 03 F7 00 70 18 24 24 64 00 08 14 40 FF ED 00 74 A0 21 8F C2 00 3C 10 40 00 0C 8F C7 00 34 10 E0 00 0A 8F C2 00 70 8F C5 00 74 8F C6 00 78 0? ?? ?? ?? 8C 44 00 00 8F C3 00 70 10 40 FF C7 AC 62 00 00 0? ?? ?? ?? 2C 42 00 01 8F C5 00 70 8F C6 00 78 24 07 00 7E 8C A4 00 00 0? ?? ?? ?? 8F C5 00 74 8F C3 00 70 10 40 FF BC AC 62 00 00 0? ?? ?? ?? 2C 42 00 01 }
	condition:
		$1
}

rule file_144_12_0 {
	meta:
		name = "parse_arith"
		size = 952
		refs = "00f4 free 02c0 _itoa_word 035c _itoa"
	strings:
		$1 = { 27 BD FF 78 AF B0 00 64 8F B0 00 98 AF B7 00 80 AF BF 00 84 8E 03 00 00 AF B6 00 7C AF B5 00 78 AF B4 00 74 AF B3 00 70 AF B2 00 6C AF B1 00 68 00 E3 10 21 00 E0 B8 21 80 47 00 00 AF A0 00 50 AF A0 00 54 10 E0 00 AB AF A0 00 4C 00 80 A0 21 00 A0 B0 21 00 C0 A8 21 24 12 00 01 24 11 00 3B 24 13 00 60 10 F1 00 75 28 E4 00 3C 10 80 00 25 24 04 00 24 10 E4 00 5B 28 E4 00 25 14 80 00 7D 24 04 00 28 10 E4 00 0D 24 04 00 29 14 E4 00 0D 8F A4 00 4C 26 52 FF FF 12 40 00 9E 27 A5 00 54 27 A6 00 50 0? ?? ?? ?? 24 07 00 29 14 40 00 0A AF A2 00 4C 0? ?? ?? ?? 24 02 00 01 26 52 00 01 8F A4 00 4C 27 A5 00 54 0? ?? ?? ?? 27 A6 00 50 10 40 FF F8 AF A2 00 4C 8E 03 00 00 24 63 00 01 AE 03 00 00 02 E3 10 21 80 47 00 00 14 E0 FF DD 8F A4 00 4C 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 24 02 00 05 10 F3 00 1B 8F A2 00 9C 28 E3 00 61 10 60 00 45 24 03 00 5C 10 E3 00 28 24 03 00 5D 14 E3 FF E7 8F A2 00 A0 10 40 00 04 8F A4 00 4C 24 02 00 01 12 42 00 56 00 00 00 00 0? ?? ?? ?? 00 00 00 00 24 02 00 05 8F BF 00 84 8F B7 00 80 8F B6 00 7C 8F B5 00 78 8F B4 00 74 8F B3 00 70 8F B2 00 6C 8F B1 00 68 8F B0 00 64 03 E0 00 08 27 BD 00 88 24 63 00 01 AE 03 00 00 27 A4 00 4C AF B0 00 10 AF A2 00 14 AF A0 00 18 AF A0 00 1C AF A0 00 20 27 A5 00 54 27 A6 00 50 0? ?? ?? ?? 02 E0 38 21 10 40 FF CC 8F A4 00 4C 0? ?? ?? ?? AF A2 00 58 0? ?? ?? ?? 8F A2 00 58 AF B0 00 10 27 A4 00 4C 27 A5 00 54 27 A6 00 50 0? ?? ?? ?? 02 E0 38 21 10 40 FF C0 8F A4 00 4C 0? ?? ?? ?? 00 00 00 00 8F A2 00 9C AF B0 00 10 AF A0 00 18 AF A2 00 14 24 02 00 01 AF A0 00 1C AF A0 00 20 AF A2 00 24 27 A4 00 4C 27 A5 00 54 27 A6 00 50 0? ?? ?? ?? 02 E0 38 21 10 40 FF AF 8F A4 00 4C 0? ?? ?? ?? 00 00 00 00 24 03 00 7B 10 E3 00 03 24 03 00 7D 14 E3 FF A3 8F A4 00 4C 0? ?? ?? ?? 8F A4 00 4C 24 02 00 02 8F BF 00 84 8F B7 00 80 8F B6 00 7C 8F B5 00 78 8F B4 00 74 8F B3 00 70 8F B2 00 6C 8F B1 00 68 8F B0 00 64 03 E0 00 08 27 BD 00 88 24 03 00 0A 14 E3 FF 91 00 00 00 00 0? ?? ?? ?? 8F A4 00 4C 0? ?? ?? ?? 24 02 00 02 AF A0 00 48 80 82 00 00 10 40 00 18 00 00 00 00 0? ?? ?? ?? 27 A5 00 48 14 40 00 16 8F A4 00 48 8E 90 00 00 00 00 38 21 27 A5 00 44 24 06 00 0A 0? ?? ?? ?? A3 A0 00 44 00 40 38 21 02 00 20 21 02 C0 28 21 0? ?? ?? ?? 02 A0 30 21 8F A4 00 4C 0? ?? ?? ?? AE 82 00 00 8E 82 00 00 0? ?? ?? ?? 2C 42 00 01 0? ?? ?? ?? 00 00 20 21 0? ?? ?? ?? 00 00 20 21 0? ?? ?? ?? 8F A4 00 4C 0? ?? ?? ?? 24 02 00 05 8F A2 00 A0 14 40 FF FA AF A0 00 48 24 63 00 01 02 E3 B8 21 82 E4 00 00 14 87 FF F5 8F A4 00 4C AE 03 00 00 80 82 00 00 14 40 00 0C 00 00 80 21 00 10 27 C3 8E 91 00 00 24 07 00 0A 02 00 28 21 27 A6 00 44 AF A0 00 10 0? ?? ?? ?? A3 A0 00 44 00 40 38 21 0? ?? ?? ?? 02 20 20 21 0? ?? ?? ?? 27 A5 00 48 14 40 FF E2 8F B0 00 48 06 01 FF F0 02 C0 28 21 8E 84 00 00 02 A0 30 21 0? ?? ?? ?? 24 07 00 2D 00 10 80 23 00 10 27 C3 14 40 FF E9 AE 82 00 00 0? ?? ?? ?? 8F A4 00 4C 0? ?? ?? ?? 24 02 00 01 }
	condition:
		$1
}

rule file_144_13_0 {
	meta:
		name = "parse_dollars"
		size = 5756
		refs = "0010 __gnu_local_gp 0188 __libc_tsd_CTYPE_B 022c free 04f4 $LC11 04f8 $LC1 050c __assert_fail 04fc __PRETTY_FUNCTION__.10919 01c4 $LC9 0540 strchr 07dc strtol 07e4 __libc_argc 0964 $LC12 09c0 strlen 09d4 _itoa_word 0a38 __strdup 0a54 __setenv 0ab4 strspn 0ad8 strcspn 0c50 fnmatch 0c68 malloc 0c80 mempcpy 0e70 getenv 0f04 __libc_argv 0f2c $LC10 0ff8 __getpid 1020 pthread_setcancelstate 10e4 _libc_intl_domainname 10e8 $LC14 10f4 __dcgettext 10fc $LC15 110c __fxprintf 1164 $LC16 13c0 $LC13 14d8 stpcpy"
	strings:
		$1 = { 27 BD FF 38 AF B5 00 B4 8F B5 00 D8 AF B1 00 A4 3C 1C ?? ?? 8E B1 00 00 27 9C ?? ?? AF B3 00 AC 26 23 00 01 AF B2 00 A8 AF B0 00 A0 AF BF 00 C4 AF BE 00 C0 AF B7 00 BC AF B6 00 B8 AF B4 00 B0 AF BC 00 28 00 E3 90 21 82 42 00 00 24 09 00 27 00 E0 80 21 00 80 98 21 AF A5 00 CC 10 49 00 84 AF A6 00 D0 28 49 00 28 15 20 00 30 24 09 00 28 10 49 00 18 24 09 00 5B 14 49 00 30 24 02 00 01 8F A3 00 DC 26 31 00 02 AE B1 00 00 AF B5 00 10 AF A3 00 14 0? ?? ?? ?? AF A2 00 18 00 40 F0 21 8F BF 00 C4 03 C0 10 21 8F B7 00 BC 8F BE 00 C0 8F B6 00 B8 8F B5 00 B4 8F B4 00 B0 8F B3 00 AC 8F B2 00 A8 8F B1 00 A4 8F B0 00 A0 03 E0 00 08 27 BD 00 C8 26 27 00 02 02 07 50 21 81 43 00 00 10 62 00 A3 00 00 00 00 8F A3 00 DC 30 7E 00 04 13 C0 00 73 8F BF 00 C4 24 1E 00 04 03 C0 10 21 8F B7 00 BC 8F BE 00 C0 8F B6 00 B8 8F B5 00 B4 8F B4 00 B0 8F B3 00 AC 8F B2 00 A8 8F B1 00 A4 8F B0 00 A0 03 E0 00 08 27 BD 00 C8 10 40 00 50 24 04 00 22 10 44 00 4E 00 00 00 00 AE A3 00 00 82 47 00 00 AF A0 00 74 AF A0 00 78 38 FE 00 7B 2F DE 00 01 AF BE 00 80 AF A0 00 6C 13 C0 00 F1 AF A0 00 70 26 22 00 02 02 02 18 21 AE A2 00 00 80 67 00 00 24 03 00 23 10 E3 01 0B 26 36 00 03 00 40 B0 21 AF A0 00 8C 8F 84 ?? ?? 7C 03 E8 3B 00 60 28 21 00 85 28 21 8C A2 00 00 00 07 18 40 00 43 28 21 94 A5 00 00 30 A5 00 04 14 A0 00 9C 24 02 00 5F 10 E2 00 9A 24 E2 FF D0 2C 42 00 0A 10 40 00 DD 3C 04 ?? ?? 00 00 A0 21 27 B7 00 78 0? ?? ?? ?? 27 BE 00 74 8F A8 00 80 11 00 03 37 24 03 00 01 8E A2 00 00 24 42 00 01 02 02 20 21 AE A2 00 00 80 87 00 00 24 E4 FF D0 2C 84 00 0A 10 80 03 34 00 40 B0 21 02 80 20 21 02 E0 28 21 0? ?? ?? ?? 03 C0 30 21 14 40 FF EF 00 40 A0 21 24 1E 00 01 00 00 B8 21 00 00 A0 21 0? ?? ?? ?? 02 80 20 21 0? ?? ?? ?? 02 E0 20 21 8F BF 00 C4 03 C0 10 21 8F B7 00 BC 8F BE 00 C0 8F B6 00 B8 8F B5 00 B4 8F B4 00 B0 8F B3 00 AC 8F B2 00 A8 8F B1 00 A4 8F B0 00 A0 03 E0 00 08 27 BD 00 C8 8E 64 00 00 8F A5 00 CC 8F A6 00 D0 0? ?? ?? ?? 24 07 00 24 AE 62 00 00 2C 5E 00 01 8F BF 00 C4 03 C0 10 21 8F B7 00 BC 8F BE 00 C0 8F B6 00 B8 8F B5 00 B4 8F B4 00 B0 8F B3 00 AC 8F B2 00 A8 8F B1 00 A4 8F B0 00 A0 03 E0 00 08 27 BD 00 C8 AE A7 00 00 8F A8 00 E0 8F A2 00 EC 81 47 00 00 AF A0 00 48 00 02 40 0B AF A8 00 84 AF A0 00 60 10 E0 00 1F 00 00 A0 21 24 16 00 01 00 00 88 21 24 12 00 27 24 17 00 28 10 F2 00 43 28 E2 00 28 14 40 00 37 24 02 00 22 10 F7 00 3C 24 02 00 29 14 E2 00 07 02 80 20 21 16 20 00 06 27 A5 00 60 26 D6 FF FF 12 C0 03 3D 00 00 00 00 02 80 20 21 27 A5 00 60 0? ?? ?? ?? 27 A6 00 48 10 40 00 98 00 40 A0 21 8E A4 00 00 24 84 00 01 AE A4 00 00 02 04 20 21 80 87 00 00 14 E0 FF E7 00 00 00 00 0? ?? ?? ?? 02 80 20 21 0? ?? ?? ?? 24 1E 00 05 26 31 00 03 02 11 10 21 80 42 00 00 10 40 FF 5A 02 20 18 21 02 20 28 21 00 00 20 21 24 09 00 29 24 06 00 28 14 80 00 07 00 00 00 00 10 49 00 EE 00 00 00 00 14 46 00 07 00 00 00 00 0? ?? ?? ?? 24 84 00 01 10 46 FF FD 38 42 00 29 2C 42 00 01 00 82 20 23 24 63 00 01 02 03 10 21 80 42 00 00 14 40 FF F0 00 60 28 21 0? ?? ?? ?? 8F A3 00 DC 14 E2 FF D3 02 80 20 21 12 20 00 4A 00 00 00 00 3A 31 00 02 0? ?? ?? ?? 00 11 88 2B 2E 22 00 01 0? ?? ?? ?? 02 C2 B0 21 12 20 00 44 24 03 00 02 3A 31 00 01 00 11 18 0A 0? ?? ?? ?? 00 60 88 21 7C 03 E8 3B 00 00 A0 21 27 B7 00 78 27 BE 00 74 00 83 B0 21 02 80 20 21 02 E0 28 21 0? ?? ?? ?? 03 C0 30 21 10 40 FF 76 00 40 A0 21 8E A2 00 00 8E C5 00 00 24 42 00 01 02 02 20 21 AE A2 00 00 80 87 00 00 00 07 20 40 00 A4 20 21 94 84 00 00 30 84 08 00 14 80 FF EF 24 03 00 5F 10 E3 FF EE 02 80 20 21 00 40 B0 21 AF A0 00 90 8F A8 00 80 15 00 00 4B 00 00 B8 21 26 D6 FF FF AF A0 00 94 AF A0 00 88 AE B6 00 00 82 47 00 00 24 02 00 7B 10 E2 00 33 00 00 00 00 12 80 02 74 8F A8 00 8C 82 82 00 00 24 44 FF D0 2C 84 00 0A 14 80 00 C1 8F A3 00 90 10 60 02 66 24 04 00 24 10 44 02 C6 00 00 00 00 24 04 00 2A 10 44 04 35 24 04 00 40 10 44 03 DF 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 05 DF 0? ?? ?? ?? 24 E7 ?? ?? 0? ?? ?? ?? 24 11 00 02 0? ?? ?? ?? 24 11 00 01 24 02 00 23 10 E2 03 BC 00 60 B0 21 0? ?? ?? ?? AF A0 00 8C 00 E0 28 21 24 84 ?? ?? 0? ?? ?? ?? AF A7 00 98 10 40 02 64 8F A7 00 98 00 00 20 21 27 A5 00 78 0? ?? ?? ?? 27 A6 00 74 10 40 FF 2F 00 40 A0 21 8E B6 00 00 24 03 00 01 AF A3 00 90 26 D6 00 01 0? ?? ?? ?? AE B6 00 00 8E A2 00 00 02 02 80 21 82 04 00 00 24 02 00 7D 14 82 FF 26 24 1E 00 05 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 24 1E 00 01 AE B6 00 00 02 16 10 21 24 08 00 01 80 47 00 00 0? ?? ?? ?? AF A8 00 8C 02 16 10 21 80 47 00 00 24 02 00 2D 10 E2 02 76 26 C4 00 01 28 E2 00 2E 10 40 00 6F 24 02 00 3D 24 02 00 25 10 E2 02 69 24 02 00 2B 10 E2 02 6E 00 00 00 00 24 02 00 23 14 E2 02 61 02 04 10 21 80 45 00 00 10 A7 02 AC 24 03 00 23 AF A0 00 94 AF A3 00 88 AE A4 00 00 80 45 00 00 10 A0 02 E1 00 00 B0 21 00 00 B8 21 AF A0 00 80 24 1E 00 5C 10 BE 00 36 28 A2 00 5D 10 40 00 1E 24 02 00 22 10 A2 00 28 24 02 00 27 14 A2 00 06 00 00 00 00 12 C0 00 3D 24 02 00 02 3A D6 00 01 00 16 10 0A 00 40 B0 21 8E A2 00 00 02 E0 20 21 27 A5 00 70 02 02 10 21 80 47 00 00 0? ?? ?? ?? 27 A6 00 6C 10 40 00 2F 00 40 B8 21 8E A4 00 00 24 84 00 01 AE A4 00 00 02 04 10 21 80 45 00 00 14 A0 FF E4 00 00 00 00 00 80 B0 21 26 D6 FF FF 0? ?? ?? ?? AE B6 00 00 24 02 00 7B 10 A2 00 0F 24 03 00 7D 14 A3 FF E8 00 00 00 00 16 C0 FF E6 8F A3 00 80 10 60 FF 75 8F A8 00 80 25 08 FF FF 0? ?? ?? ?? AF A8 00 80 12 C0 00 1A 00 00 00 00 3A D6 00 02 0? ?? ?? ?? 00 16 B0 2B 8F A8 00 80 2E C2 00 01 01 02 40 21 0? ?? ?? ?? AF A8 00 80 16 C0 FF D5 24 84 00 01 AE A4 00 00 02 04 20 21 80 82 00 00 10 40 02 9C 02 E0 20 21 27 A5 00 70 27 A6 00 6C 0? ?? ?? ?? 24 07 00 5C 14 40 FF CA 00 40 B8 21 0? ?? ?? ?? 24 1E 00 01 0? ?? ?? ?? 24 16 00 01 0? ?? ?? ?? 24 16 00 02 02 05 28 21 80 A3 00 01 14 62 FE 62 8F A3 00 DC 8F A2 00 DC 8F A5 00 CC 8F A6 00 D0 AE B1 00 00 02 60 20 21 AF B5 00 10 AF A2 00 14 AF A0 00 18 0? ?? ?? ?? 02 00 38 21 0? ?? ?? ?? 00 40 F0 21 10 E2 02 03 26 C4 00 01 28 E2 00 3E 14 40 01 DC 24 02 00 3F 10 E2 01 FE 00 00 00 00 24 02 00 7D 14 E2 01 F1 00 00 00 00 AF A0 00 94 AF A0 00 88 00 00 B8 21 0? ?? ?? ?? 82 47 00 00 02 80 20 21 00 00 28 21 0? ?? ?? ?? 24 06 00 0A 3C 04 ?? ?? 8C 84 ?? ?? 00 44 20 2A 14 80 01 C4 3C 04 ?? ?? 8F A3 00 DC 30 62 00 20 14 40 FE 8A 24 1E 00 03 00 00 90 21 00 00 80 21 8F A8 00 88 11 00 00 91 25 11 FF DD 2E 22 00 30 10 40 00 50 3C 04 ?? ?? 00 11 10 80 24 84 ?? ?? 00 82 10 21 8C 42 00 00 00 40 00 08 00 00 00 00 12 00 00 06 00 00 00 00 82 02 00 00 14 40 00 28 8F A3 00 94 10 60 00 27 2E 22 00 30 AF A0 00 60 AF A0 00 64 12 E0 00 1F AF A0 00 68 82 E2 00 00 10 40 00 1C 02 E0 40 21 00 00 A8 21 24 16 00 2A 10 56 01 15 00 00 00 00 28 44 00 2B 10 80 01 0B 24 04 00 24 10 44 01 47 24 04 00 27 10 44 01 6C 24 04 00 22 10 44 00 28 24 02 00 02 8F A4 00 68 81 07 00 00 01 00 F0 21 27 A5 00 64 0? ?? ?? ?? 27 A6 00 60 10 40 FF 9E AF A2 00 68 27 C8 00 01 11 00 00 04 00 00 00 00 83 C2 00 01 14 40 FF E8 00 00 00 00 0? ?? ?? ?? 02 E0 20 21 8F B7 00 68 2E 22 00 30 10 40 00 E9 3C 02 ?? ?? 00 11 88 80 24 42 ?? ?? 00 51 10 21 8C 42 00 00 00 40 00 08 00 00 00 00 12 00 00 06 00 00 00 00 82 02 00 00 14 40 FF CE 8F A8 00 94 11 00 FF CC 00 00 00 00 12 40 FE 3E 00 00 F0 21 0? ?? ?? ?? 02 00 20 21 0? ?? ?? ?? 00 00 00 00 12 A2 01 8A 00 00 00 00 16 A0 FF D7 8F A4 00 68 24 15 00 02 0? ?? ?? ?? 01 00 F0 21 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 06 2E 0? ?? ?? ?? 24 E7 ?? ?? 12 00 01 D4 00 00 00 00 82 02 00 00 10 40 01 CF 8F A3 00 94 0? ?? ?? ?? 02 80 20 21 0? ?? ?? ?? 02 E0 20 21 8F A8 00 8C 11 00 00 35 8F A2 00 EC A3 A0 00 44 12 00 02 5B 8E 71 00 00 0? ?? ?? ?? 02 00 20 21 00 40 20 21 27 A5 00 44 24 06 00 0A 0? ?? ?? ?? 00 00 38 21 8F A5 00 CC 8F A6 00 D0 00 40 38 21 0? ?? ?? ?? 02 20 20 21 12 40 FE 25 AE 62 00 00 0? ?? ?? ?? 02 00 20 21 8E 62 00 00 0? ?? ?? ?? 2C 5E 00 01 12 00 00 06 00 00 00 00 82 02 00 00 14 40 FF DF 8F A8 00 94 11 00 FF C3 00 00 00 00 16 40 01 D6 00 00 00 00 12 E0 01 DA 00 00 00 00 0? ?? ?? ?? 02 E0 20 21 10 40 FF 3F 00 40 80 21 02 80 20 21 02 00 28 21 24 06 00 01 0? ?? ?? ?? 24 12 00 01 0? ?? ?? ?? 02 80 20 21 0? ?? ?? ?? 02 E0 20 21 8F A8 00 8C 15 00 FF D0 00 00 00 00 12 00 FD 89 00 00 F0 21 8F A2 00 EC 14 40 01 4C 8F A3 00 E0 10 60 01 4A 00 00 00 00 0? ?? ?? ?? 02 00 20 21 16 40 00 A4 00 40 B0 21 12 C0 FD DE 02 C0 80 21 00 00 B8 21 8F A5 00 E8 0? ?? ?? ?? 02 00 20 21 16 E0 00 04 02 02 88 21 82 22 00 00 10 40 00 9D 00 00 00 00 8F A5 00 E4 02 20 20 21 0? ?? ?? ?? 00 00 B8 21 8F A5 00 E8 02 22 90 21 0? ?? ?? ?? 02 40 20 21 02 42 80 21 82 05 00 00 10 A0 00 07 00 00 00 00 0? ?? ?? ?? 8F A4 00 E4 10 40 00 03 00 00 00 00 26 10 00 01 24 17 00 01 A2 40 00 00 8E 64 00 00 8F A5 00 CC 8F A6 00 D0 0? ?? ?? ?? 02 20 38 21 10 40 00 76 AE 62 00 00 16 E0 00 85 00 00 00 00 82 03 00 00 10 60 00 7E 00 00 00 00 12 D0 FF D8 8F A4 00 E0 0? ?? ?? ?? 00 40 28 21 24 03 00 01 10 43 00 6D 8F A8 00 D0 AD 00 00 00 8F A8 00 CC AD 00 00 00 0? ?? ?? ?? AE 60 00 00 12 00 00 04 00 00 00 00 82 02 00 00 14 40 FF 83 00 00 00 00 12 40 00 04 8F A3 00 94 0? ?? ?? ?? 02 00 20 21 8F A3 00 94 14 60 00 03 00 00 00 00 16 00 FD 9F 00 00 F0 21 12 E0 01 59 00 00 00 00 0? ?? ?? ?? 02 E0 20 21 10 40 FE DE 00 40 80 21 0? ?? ?? ?? 24 12 00 01 12 00 01 CB 00 00 00 00 12 E0 FF 6E 00 00 00 00 82 E2 00 00 10 40 FF 6B 00 00 00 00 0? ?? ?? ?? 02 00 20 21 8F A3 00 88 02 02 88 21 24 02 00 25 10 62 01 A2 2C 62 00 26 14 40 01 6A 8F A8 00 88 24 02 00 4C 11 02 01 7E 24 02 00 52 15 02 FF 5D 02 30 10 2B 02 00 B0 21 10 40 00 06 24 15 00 01 0? ?? ?? ?? 00 00 00 00 02 36 10 2B 14 40 FF 55 00 00 00 00 02 E0 20 21 02 C0 28 21 0? ?? ?? ?? 00 00 30 21 10 55 FF F8 26 D6 00 01 26 D6 FF FF 02 D0 B0 23 0? ?? ?? ?? 26 C4 00 01 10 40 01 CF 00 40 88 21 00 40 20 21 02 00 28 21 0? ?? ?? ?? 02 C0 30 21 16 40 01 C7 A0 40 00 00 02 20 80 21 0? ?? ?? ?? 24 12 00 01 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 07 7B 0? ?? ?? ?? 24 E7 ?? ?? 24 04 00 5C 10 44 00 53 24 04 00 7E 10 44 00 23 24 04 00 3F 14 44 FE F6 00 00 00 00 12 A0 FE F5 8F A4 00 68 27 A5 00 64 27 A6 00 60 24 07 00 5C 0? ?? ?? ?? AF A8 00 98 00 40 20 21 AF A2 00 68 14 40 FE EC 8F A8 00 98 0? ?? ?? ?? 24 1E 00 01 82 23 00 00 10 60 FF 89 00 00 00 00 0? ?? ?? ?? 02 C0 20 21 24 1E 00 01 00 00 B8 21 0? ?? ?? ?? 00 00 A0 21 0? ?? ?? ?? 02 00 20 21 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 02 C0 20 21 0? ?? ?? ?? 00 00 F0 21 0? ?? ?? ?? 24 17 00 01 16 A0 FE D5 8F A4 00 68 8F A2 00 64 14 40 FE D2 27 A2 00 30 01 00 38 21 AF A2 00 10 AF A0 00 14 27 A4 00 68 27 A5 00 64 27 A6 00 60 AF A8 00 98 0? ?? ?? ?? AF A0 00 30 00 40 F0 21 10 40 00 1A 8F A8 00 98 16 40 00 BC 00 00 00 00 0? ?? ?? ?? 8F A4 00 68 0? ?? ?? ?? 00 00 00 00 8F A3 00 DC 27 A2 00 30 AF A2 00 10 24 02 00 01 01 00 38 21 AF A3 00 14 AF A0 00 18 AF A0 00 1C AF A0 00 20 AF A2 00 24 27 A4 00 68 27 A5 00 64 27 A6 00 60 AF A8 00 98 0? ?? ?? ?? AF A0 00 30 00 40 F0 21 14 40 FF E8 8F A8 00 98 8F A2 00 30 01 02 40 21 0? ?? ?? ?? 01 00 F0 21 8F A4 00 68 24 07 00 5C 27 A5 00 64 27 A6 00 60 0? ?? ?? ?? AF A8 00 98 8F A8 00 98 AF A2 00 68 00 40 20 21 81 07 00 01 10 E0 01 61 25 1E 00 01 14 40 FE 9E 27 A5 00 64 0? ?? ?? ?? 24 1E 00 01 24 02 00 01 12 A2 00 47 00 00 00 00 16 A0 FE 94 8F A4 00 68 24 15 00 01 0? ?? ?? ?? 01 00 F0 21 0? ?? ?? ?? 02 80 20 21 00 40 80 21 16 00 FE 64 00 00 90 21 0? ?? ?? ?? 8F A3 00 DC 11 00 00 57 3C 02 ?? ?? 8C 44 ?? ?? 27 A5 00 5C 24 06 00 0A 24 84 FF FF 00 00 38 21 0? ?? ?? ?? A3 A0 00 5C 00 40 80 21 0? ?? ?? ?? AF A0 00 8C AF A3 00 90 AF A0 00 94 AF A0 00 88 00 00 B8 21 0? ?? ?? ?? 82 47 00 00 0? ?? ?? ?? AF A3 00 90 8F A8 00 80 15 00 00 3E 26 D6 FF FF AF A0 00 90 00 00 A0 21 AF A0 00 94 AF A0 00 88 00 00 B8 21 0? ?? ?? ?? AE B6 00 00 8C 84 ?? ?? 00 02 10 80 00 82 10 21 0? ?? ?? ?? 8C 50 00 00 24 02 00 3A 14 E2 00 18 26 C6 00 01 02 06 18 21 80 65 00 00 3C 04 ?? ?? 24 84 ?? ?? AF A3 00 9C 0? ?? ?? ?? AF A6 00 98 24 1E 00 05 00 00 B8 21 8F A3 00 9C 10 40 FC B7 8F A6 00 98 AE A6 00 00 80 63 00 00 26 C4 00 02 24 08 00 01 AF A3 00 88 02 04 10 21 0? ?? ?? ?? AF A8 00 94 00 00 A8 21 0? ?? ?? ?? 01 00 F0 21 24 1E 00 05 0? ?? ?? ?? 00 00 B8 21 02 04 10 21 80 45 00 00 10 A7 00 42 24 08 00 25 AF A0 00 94 0? ?? ?? ?? AF A8 00 88 AF A7 00 88 02 04 10 21 0? ?? ?? ?? AF A0 00 94 8E 64 00 00 8F A5 00 CC 8F A6 00 D0 0? ?? ?? ?? 02 00 38 21 16 40 FE 8A AE 62 00 00 0? ?? ?? ?? 2C 5E 00 01 24 1E 00 05 00 00 B8 21 0? ?? ?? ?? 00 00 A0 21 8E 64 00 00 0? ?? ?? ?? AE B1 00 00 0? ?? ?? ?? A3 A0 00 5C }
	condition:
		$1
}

rule file_144_14_0 {
	meta:
		name = "wordfree"
		size = 116
		refs = "003c free"
	strings:
		$1 = { 27 BD FF D8 AF B1 00 20 AF BF 00 24 AF B0 00 1C 10 80 00 13 00 80 88 21 8C 82 00 04 10 40 00 11 8F BF 00 24 8C 90 00 08 00 10 80 80 00 50 80 21 8E 04 00 00 10 80 00 07 00 00 00 00 0? ?? ?? ?? 26 10 00 04 8E 04 00 00 14 80 FF FC 00 00 00 00 8E 22 00 04 0? ?? ?? ?? 00 40 20 21 AE 20 00 04 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_144_15_0 {
	meta:
		name = "wordexp"
		size = 2704
		refs = "0080 calloc 0098 getenv 0094 $LC5 0190 free 0408 strchr 04d4 glob 0588 globfree 0614 __strdup 0630 wordfree 06f0 $LC19 0940 $LC17 0944 $LC1 0958 __assert_fail 0948 __PRETTY_FUNCTION__.10624 0984 $LC20 0a70 $LC18"
	strings:
		$1 = { 8C A3 00 00 27 BD FF 48 30 C2 00 08 AF A3 00 8C 8C A3 00 04 AF B4 00 A0 AF B2 00 98 AF A3 00 84 8C A3 00 08 AF B0 00 90 AF BF 00 B4 AF BE 00 B0 AF B7 00 AC AF B6 00 A8 AF B5 00 A4 AF B3 00 9C AF B1 00 94 00 C0 A0 21 00 A0 90 21 00 80 80 21 AF A0 00 68 AF A0 00 6C AF A0 00 64 14 40 02 57 AF A3 00 88 32 83 00 02 14 60 00 0A AF A3 00 80 32 82 00 01 14 40 02 16 AE 40 00 00 24 04 00 01 0? ?? ?? ?? 24 05 00 04 10 40 02 17 AE 42 00 04 AE 40 00 08 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 10 40 02 4F 00 40 98 21 80 44 00 00 27 A3 00 60 AF A3 00 78 10 80 00 0E 00 60 28 21 00 40 38 21 00 60 28 21 24 08 00 20 10 88 00 75 24 82 FF F7 30 42 00 FF 2C 42 00 02 14 40 00 72 8F A3 00 78 24 E7 00 01 80 E4 00 00 14 80 FF F7 00 00 00 00 A0 A0 00 00 82 11 00 00 AF A0 00 70 12 20 00 57 00 00 10 21 24 03 00 3F 12 23 00 B2 2A 23 00 40 10 60 00 39 24 03 00 5C 24 03 00 24 12 23 01 60 2A 23 00 25 14 60 00 71 24 03 00 27 16 23 00 A6 24 42 00 01 02 02 18 21 80 67 00 00 10 E0 00 92 AF A2 00 70 10 F1 00 96 8F A4 00 64 0? ?? ?? ?? 24 11 00 27 8F A2 00 70 24 42 00 01 02 02 18 21 80 67 00 00 10 E0 00 89 AF A2 00 70 10 F1 00 8D 8F A2 00 6C 27 A5 00 6C 0? ?? ?? ?? 27 A6 00 68 00 40 20 21 14 40 FF F3 AF A2 00 64 24 1E 00 01 0? ?? ?? ?? 00 00 00 00 24 02 00 01 13 C2 00 0A 8F A3 00 80 10 60 02 0A 00 00 00 00 8F A3 00 8C 03 C0 10 21 AE 43 00 00 8F A3 00 84 AE 43 00 04 8F A3 00 88 AE 43 00 08 8F BF 00 B4 8F BE 00 B0 8F B7 00 AC 8F B6 00 A8 8F B5 00 A4 8F B4 00 A0 8F B3 00 9C 8F B2 00 98 8F B1 00 94 8F B0 00 90 03 E0 00 08 27 BD 00 B8 12 23 01 60 2A 23 00 5D 14 60 01 38 24 03 00 60 12 23 01 49 32 83 00 04 24 02 00 7E 16 22 01 36 27 A3 00 70 8E 42 00 00 AF A3 00 10 AF A2 00 14 27 A4 00 64 27 A5 00 6C 27 A6 00 68 0? ?? ?? ?? 02 00 38 21 14 40 01 27 00 40 F0 21 8F A2 00 70 24 42 00 01 02 02 18 21 80 71 00 00 16 20 FF AB AF A2 00 70 8F A5 00 64 10 A0 01 E6 8F BF 00 B4 0? ?? ?? ?? 02 40 20 21 8F BF 00 B4 8F BE 00 B0 8F B7 00 AC 8F B6 00 A8 8F B5 00 A4 8F B4 00 A0 8F B3 00 9C 8F B2 00 98 8F B1 00 94 8F B0 00 90 03 E0 00 08 27 BD 00 B8 8F A3 00 78 00 65 10 2B 10 40 01 B1 83 A3 00 60 14 64 00 07 27 A2 00 61 0? ?? ?? ?? 8F A6 00 78 24 42 00 01 80 43 FF FF 10 64 00 03 00 00 00 00 14 A2 FF FB 00 40 30 21 14 C5 FF 81 00 00 00 00 24 A5 00 01 0? ?? ?? ?? A0 C4 00 00 24 03 00 22 16 23 00 FF 24 42 00 01 02 02 18 21 80 67 00 00 10 E0 00 21 AF A2 00 70 32 91 00 04 24 03 00 24 10 E3 01 38 28 E3 00 25 14 60 00 1E 24 03 00 5C 10 E3 01 29 24 03 00 60 14 E3 01 1F 8F A4 00 64 16 20 01 C6 27 A3 00 70 24 42 00 01 AF A3 00 10 AF B4 00 14 AF A0 00 18 AF A0 00 1C AF A0 00 20 27 A4 00 64 27 A5 00 6C 27 A6 00 68 02 00 38 21 0? ?? ?? ?? AF A2 00 70 14 40 00 DC 00 40 F0 21 8F A2 00 70 24 42 00 01 02 02 18 21 80 67 00 00 14 E0 FF E2 AF A2 00 70 8F A4 00 64 0? ?? ?? ?? 24 1E 00 05 24 02 00 22 14 E2 01 03 8F A4 00 64 8F A2 00 6C 14 40 FF A8 8F A2 00 70 02 40 20 21 0? ?? ?? ?? 00 00 28 21 10 40 FF A2 8F BF 00 B4 0? ?? ?? ?? 8F BE 00 B0 24 02 00 2A 16 22 00 C9 3C 04 ?? ?? 8F B7 00 70 AF A0 00 54 AF A0 00 58 02 17 10 21 80 56 00 00 12 C0 01 95 AF A0 00 5C 27 A3 00 54 24 1E 00 01 00 00 88 21 AF A3 00 7C 24 15 00 27 02 60 20 21 0? ?? ?? ?? 02 C0 28 21 14 40 00 1D 00 00 00 00 12 D5 00 9B 24 02 00 22 12 C2 00 87 24 02 00 01 12 22 01 8C 24 02 00 24 12 C2 01 11 24 02 00 5C 16 C2 00 85 8F A4 00 64 12 20 00 FE 27 A3 00 70 27 A2 00 70 AF A2 00 10 27 A4 00 64 27 A5 00 6C 27 A6 00 68 0? ?? ?? ?? 02 00 38 21 00 40 F0 21 17 C0 00 71 00 00 00 00 8F B7 00 70 26 F7 00 01 02 17 10 21 80 56 00 00 16 C0 FF E0 AF B7 00 70 8F A5 00 64 8F A4 00 7C 26 E3 FF FF 0? ?? ?? ?? AF A3 00 70 00 40 F0 21 AF A0 00 68 AF A0 00 6C 14 40 00 61 AF A0 00 64 8F A2 00 54 10 40 01 1C 24 16 00 01 00 00 A8 21 8F A2 00 58 24 05 00 10 00 00 30 21 00 55 10 21 8C 44 00 00 0? ?? ?? ?? 27 A7 00 30 14 40 01 16 24 03 00 01 82 62 00 00 14 40 00 32 8F A4 00 64 8F A2 00 34 8C 47 00 00 10 E0 01 5D 27 A5 00 6C 0? ?? ?? ?? 27 A6 00 68 00 40 20 21 AF A2 00 64 8F A2 00 30 2C 42 00 02 14 40 00 1B 00 00 00 00 10 80 00 19 00 00 00 00 0? ?? ?? ?? 24 11 00 01 10 80 00 15 00 00 00 00 27 A5 00 6C 27 A6 00 68 0? ?? ?? ?? 24 07 00 20 10 40 00 0A AF A2 00 64 8F A3 00 34 00 11 28 80 00 40 20 21 00 65 10 21 8C 47 00 00 27 A5 00 6C 0? ?? ?? ?? 27 A6 00 68 AF A2 00 64 8F A2 00 30 26 31 00 01 02 22 10 2B 14 40 FF EB 8F A4 00 64 0? ?? ?? ?? 27 A4 00 30 8F A2 00 64 10 40 00 25 8F A2 00 54 26 C3 00 01 02 C2 B0 2B 12 C0 00 E0 26 B5 00 04 0? ?? ?? ?? 00 60 B0 21 10 80 00 07 8F A2 00 30 0? ?? ?? ?? 00 00 00 00 AF A0 00 68 AF A0 00 6C AF A0 00 64 8F A2 00 30 14 40 00 0C 00 00 88 21 0? ?? ?? ?? 00 00 00 00 02 40 20 21 0? ?? ?? ?? 00 40 28 21 14 40 00 0C 8F A2 00 30 26 31 00 01 02 22 10 2B 10 40 00 D7 00 00 00 00 8F A3 00 34 00 11 10 80 00 62 10 21 0? ?? ?? ?? 8C 44 00 00 14 40 FF F1 00 00 00 00 0? ?? ?? ?? 27 A4 00 30 24 1E 00 01 0? ?? ?? ?? 8F A4 00 7C 0? ?? ?? ?? 8F A4 00 64 12 20 00 8B 24 02 00 02 12 22 00 13 8F A4 00 64 27 A5 00 6C 27 A6 00 68 0? ?? ?? ?? 02 C0 38 21 14 40 FF 83 AF A2 00 64 0? ?? ?? ?? 8F A4 00 7C 13 C0 FE F4 00 00 00 00 0? ?? ?? ?? 8F A4 00 64 0? ?? ?? ?? 24 02 00 01 12 20 00 77 24 02 00 01 16 22 FF EF 8F A4 00 64 0? ?? ?? ?? 00 00 88 21 8F A3 00 78 27 A2 00 70 AF A2 00 10 AF B4 00 14 AF B2 00 18 AF B3 00 1C AF A3 00 20 AF A0 00 24 27 A4 00 64 27 A5 00 6C 27 A6 00 68 0? ?? ?? ?? 02 00 38 21 10 40 FE DB 00 40 F0 21 0? ?? ?? ?? 8F A4 00 64 24 02 00 5B 12 22 FF 3B 8F B7 00 70 3C 04 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 02 20 28 21 10 40 00 A0 8F A5 00 64 10 A0 00 05 00 00 00 00 0? ?? ?? ?? 02 40 20 21 14 40 FF F0 00 40 F0 21 AF A0 00 68 AF A0 00 6C 0? ?? ?? ?? AF A0 00 64 14 60 00 BE 24 42 00 01 27 A3 00 70 AF A3 00 10 8F A3 00 78 AF B4 00 14 AF B2 00 18 AF B3 00 1C AF A3 00 20 27 A4 00 64 27 A5 00 6C 27 A6 00 68 02 00 38 21 0? ?? ?? ?? AF A2 00 70 10 40 FE B5 00 40 F0 21 0? ?? ?? ?? 8F A4 00 64 27 A2 00 70 AF A2 00 10 27 A4 00 64 27 A5 00 6C 27 A6 00 68 0? ?? ?? ?? 02 00 38 21 10 40 FE AA 00 40 F0 21 0? ?? ?? ?? 8F A4 00 64 27 A5 00 6C 0? ?? ?? ?? 27 A6 00 68 00 40 20 21 14 40 FE ED AF A2 00 64 0? ?? ?? ?? 24 1E 00 01 27 A2 00 70 AF A2 00 10 27 A4 00 64 27 A5 00 6C 27 A6 00 68 0? ?? ?? ?? 02 00 38 21 10 40 FE E2 00 40 F0 21 0? ?? ?? ?? 8F A4 00 64 8F A3 00 78 27 A2 00 70 AF A2 00 10 24 02 00 01 AF B4 00 14 AF B2 00 18 AF B3 00 1C AF A3 00 20 AF A2 00 24 27 A4 00 64 27 A5 00 6C 27 A6 00 68 0? ?? ?? ?? 02 00 38 21 10 40 FE D0 00 40 F0 21 0? ?? ?? ?? 8F A4 00 64 AF A3 00 10 27 A4 00 64 27 A5 00 6C 27 A6 00 68 0? ?? ?? ?? 02 00 38 21 00 40 F0 21 13 C0 FF 06 8F B7 00 70 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 24 11 00 01 0? ?? ?? ?? 24 11 00 02 27 A3 00 70 AF A3 00 10 8F A3 00 7C 3A 22 00 02 2C 42 00 01 AF A3 00 18 8F A3 00 78 AF B4 00 14 AF B3 00 1C AF A3 00 20 AF A2 00 24 27 A4 00 64 27 A5 00 6C 27 A6 00 68 0? ?? ?? ?? 02 00 38 21 10 40 FE ED 00 40 F0 21 0? ?? ?? ?? 8F A4 00 7C 0? ?? ?? ?? 8F A4 00 64 8E 44 00 08 24 05 00 04 0? ?? ?? ?? 24 84 00 01 14 40 FD EC AE 42 00 04 8F A2 00 64 0? ?? ?? ?? 00 40 20 21 8F BF 00 B4 8F BE 00 B0 8F B7 00 AC 8F B6 00 A8 8F B5 00 A4 8F B4 00 A0 8F B3 00 9C 8F B2 00 98 8F B1 00 94 8F B0 00 90 24 02 00 01 03 E0 00 08 27 BD 00 B8 0? ?? ?? ?? 8F A4 00 7C 0? ?? ?? ?? 8F A2 00 70 10 43 FF 3D 24 1E 00 01 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 01 8C 0? ?? ?? ?? 24 E7 ?? ?? 0? ?? ?? ?? 27 A4 00 30 0? ?? ?? ?? 8F A2 00 54 8F A6 00 78 14 C5 FD DA 00 00 00 00 0? ?? ?? ?? 24 A5 00 01 3C 04 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 02 20 28 21 14 40 00 2F 8F A4 00 64 27 A5 00 6C 27 A6 00 68 0? ?? ?? ?? 02 20 38 21 14 40 FE 25 AF A2 00 64 0? ?? ?? ?? 00 00 00 00 00 A0 20 21 0? ?? ?? ?? AF A0 00 84 0? ?? ?? ?? 32 83 00 02 0? ?? ?? ?? 02 40 20 21 0? ?? ?? ?? 8F A3 00 8C 3C 02 20 09 27 A3 00 60 24 42 0A 00 AF A3 00 78 AF A2 00 60 0? ?? ?? ?? 00 60 98 21 8F BE 00 B0 8F B7 00 AC 8F B6 00 A8 8F B5 00 A4 8F B4 00 A0 8F B3 00 9C 8F B2 00 98 8F B1 00 94 8F B0 00 90 00 00 10 21 03 E0 00 08 27 BD 00 B8 24 1E 00 04 0? ?? ?? ?? 8F A4 00 64 0? ?? ?? ?? 8F A3 00 80 27 A3 00 54 0? ?? ?? ?? AF A3 00 7C 0? ?? ?? ?? 24 1E 00 04 0? ?? ?? ?? 24 1E 00 02 24 02 00 5C 16 C2 FE FB 8F A4 00 64 0? ?? ?? ?? 27 A2 00 70 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 01 93 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_145_0_0 {
	meta:
		name = "__wcrtomb_chk"
		size = 76
		refs = "0000 __gnu_local_gp 0010 _nl_current_LC_CTYPE 003c __wcrtomb 0044 __chk_fail"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 27 BD FF E0 AF BF 00 1C 00 62 10 21 8C 42 00 00 AF BC 00 10 8C 42 00 00 8C 42 00 58 00 E2 38 2B 14 E0 00 03 8F BF 00 1C 0? ?? ?? ?? 27 BD 00 20 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_146_0_0 {
	meta:
		name = "critical_factorization"
		size = 344
	strings:
		$1 = { 24 0C 00 01 24 07 00 01 00 00 40 21 24 02 FF FF 00 82 18 21 00 67 58 21 00 E8 18 21 00 65 48 2B 11 20 00 0F 00 83 50 21 91 4A 00 00 91 69 00 00 01 49 58 2B 11 60 00 2C 00 00 00 00 00 60 40 21 24 07 00 01 00 62 60 23 00 82 18 21 00 67 58 21 00 E8 18 21 00 65 48 2B 15 20 FF F3 00 83 50 21 AC CC 00 00 24 0D 00 01 24 07 00 01 00 00 40 21 24 0B FF FF 00 8B 18 21 00 67 60 21 00 E8 18 21 00 65 48 2B 11 20 00 0F 00 83 50 21 91 4A 00 00 91 89 00 00 01 2A 60 2B 11 80 00 1A 00 00 00 00 00 60 40 21 24 07 00 01 00 6B 68 23 00 8B 18 21 00 67 60 21 00 E8 18 21 00 65 48 2B 15 20 FF F3 00 83 50 21 24 42 00 01 25 6B 00 01 01 62 18 2B 14 60 00 03 00 00 00 00 AC CD 00 00 01 60 10 21 03 E0 00 08 00 00 00 00 11 49 00 0D 00 00 00 00 01 00 10 21 24 0C 00 01 25 08 00 01 0? ?? ?? ?? 24 07 00 01 11 49 00 0A 00 00 00 00 01 00 58 21 24 0D 00 01 25 08 00 01 0? ?? ?? ?? 24 07 00 01 10 EC 00 07 00 00 00 00 0? ?? ?? ?? 24 E7 00 01 10 ED 00 06 00 00 00 00 0? ?? ?? ?? 24 E7 00 01 00 60 40 21 0? ?? ?? ?? 24 07 00 01 00 60 40 21 0? ?? ?? ?? 24 07 00 01 }
	condition:
		$1
}

rule file_146_1_0 {
	meta:
		name = "two_way_long_needle"
		size = 1084
		refs = "00b0 memcmp 00f4 memchr"
	strings:
		$1 = { 27 BD FB 98 27 AE 04 18 00 A0 40 21 AF B6 04 58 AF B2 04 48 00 80 B0 21 00 C0 90 21 00 C0 20 21 00 E0 28 21 01 C0 30 21 AF B3 04 4C AF B0 04 40 AF A8 04 3C AF BF 04 64 AF BE 04 60 AF B7 04 5C AF B5 04 54 AF B4 04 50 AF B1 04 44 0? ?? ?? ?? 00 E0 98 21 8F A8 04 3C 00 40 80 21 27 A3 00 18 AC 73 00 00 24 63 00 04 15 C3 FF FD 00 00 00 00 12 60 00 0B 02 40 10 21 02 72 28 21 26 63 FF FF 90 44 00 00 27 A6 00 18 24 42 00 01 00 04 20 80 00 C4 20 21 AC 83 00 00 14 45 FF F9 24 63 FF FF 8F B1 04 18 02 40 20 21 02 00 30 21 02 51 28 21 0? ?? ?? ?? AF A8 04 3C 14 40 00 71 8F A8 04 3C 26 03 FF FF 00 00 A8 21 AF A3 04 28 24 02 00 01 02 43 18 21 02 B3 F0 21 AF A3 04 20 00 50 10 23 02 71 18 23 02 C8 20 21 00 00 28 21 03 C8 30 23 AF A3 04 24 0? ?? ?? ?? AF A2 04 2C 00 00 A0 21 14 40 00 18 26 77 FF FF 13 C0 00 16 02 DE 10 21 90 42 FF FF 27 A4 00 18 00 02 10 80 00 82 10 21 8C 42 00 00 10 40 00 1C 02 90 60 2B 12 80 00 03 8F A6 04 24 00 51 18 2B 00 C3 10 0B 02 A2 A8 21 00 00 A0 21 03 C0 40 21 02 B3 F0 21 02 C8 20 21 00 00 28 21 0? ?? ?? ?? 03 C8 30 23 10 40 FF EA 00 00 00 00 00 00 10 21 8F BF 04 64 8F BE 04 60 8F B7 04 5C 8F B6 04 58 8F B5 04 54 8F B4 04 50 8F B3 04 4C 8F B2 04 48 8F B1 04 44 8F B0 04 40 03 E0 00 08 27 BD 04 68 02 00 18 21 02 8C 18 0A 00 75 10 21 00 77 20 2B 02 43 40 21 10 80 00 11 02 C2 10 21 91 05 00 00 90 44 00 00 14 A4 00 2A 00 03 30 23 01 06 40 21 0? ?? ?? ?? 00 46 30 21 90 84 00 00 90 42 00 00 14 82 00 24 8F A4 04 2C 24 63 00 01 00 77 28 2B 01 03 20 21 14 A0 FF F8 00 C3 10 21 8F A3 04 28 02 A3 40 21 11 80 00 8B 02 C8 40 21 8F A3 04 20 91 04 00 00 90 65 00 00 24 62 FF FF 14 A4 00 85 25 03 FF FF 02 90 60 23 01 0C 60 21 0? ?? ?? ?? 02 08 40 23 24 63 FF FF 90 45 00 01 90 64 00 01 14 A4 00 05 26 8B 00 01 24 42 FF FF 14 6C FF F9 00 68 30 21 26 8B 00 01 00 CB 30 2B 14 C0 00 77 8F B4 04 24 02 B1 A8 21 0? ?? ?? ?? 03 C0 40 21 8F A4 04 2C 00 00 A0 21 03 C0 40 21 00 95 50 21 0? ?? ?? ?? 01 43 A8 21 02 70 10 23 00 50 18 2B 26 11 FF FF 02 03 10 0B 02 51 18 21 AF A3 04 2C 26 74 FF FF 00 10 18 23 AF A3 04 24 02 14 18 2B AF A3 04 28 8F A3 04 2C 8F A4 04 24 24 17 00 01 24 63 FF FF AF A3 04 34 8F A3 04 2C 24 42 00 01 02 50 90 21 02 F0 B8 23 AF B7 04 30 AF A2 04 38 AF B2 04 20 AF A2 04 18 00 00 F0 21 00 70 A8 23 02 44 B8 21 03 D3 90 21 02 C8 20 21 00 00 28 21 0? ?? ?? ?? 02 48 30 23 14 40 FF 99 00 00 10 21 12 40 FF 96 02 D2 10 21 90 42 FF FF 27 A6 00 18 00 02 10 80 00 C2 10 21 8C 42 00 00 10 40 00 04 8F A3 04 28 03 C2 F0 21 0? ?? ?? ?? 02 40 40 21 03 D0 78 21 10 60 00 12 02 CF 78 21 8F A4 04 20 91 E2 00 00 90 83 00 00 14 62 00 2C 8F A6 04 24 02 00 18 21 0? ?? ?? ?? 01 E6 78 21 91 04 00 00 90 C2 00 00 14 82 00 27 8F A2 04 30 24 63 00 01 00 74 28 2B 02 E3 40 21 14 A0 FF F8 01 E3 30 21 03 D1 10 21 24 06 FF FF 12 26 00 0F 02 C2 10 21 8F A3 04 2C 24 42 FF FF 90 64 00 00 90 43 00 01 14 83 00 1C 8F A3 04 34 0? ?? ?? ?? 00 00 00 00 90 64 00 00 90 45 00 01 14 A4 00 16 24 63 FF FF 14 75 FF FB 24 42 FF FF 8F BF 04 64 02 DE 10 21 8F B7 04 5C 8F BE 04 60 8F B6 04 58 8F B5 04 54 8F B4 04 50 8F B3 04 4C 8F B2 04 48 8F B1 04 44 8F B0 04 40 03 E0 00 08 27 BD 04 68 02 00 18 21 8F A2 04 30 02 40 40 21 00 5E 68 21 0? ?? ?? ?? 01 A3 F0 21 8F A3 04 38 02 40 40 21 0? ?? ?? ?? 03 C3 F0 21 0? ?? ?? ?? 02 00 30 21 0? ?? ?? ?? 02 D5 10 21 }
	condition:
		$1
}

rule file_146_2_0 {
	meta:
		name = "strstr"
		size = 1160
		refs = "0098 strchr 0138 memchr 0210 memcmp"
	strings:
		$1 = { 27 BD FF 98 AF B6 00 58 AF B1 00 44 AF BF 00 64 AF BE 00 60 AF B7 00 5C AF B5 00 54 AF B4 00 50 AF B3 00 4C AF B2 00 48 AF B0 00 40 80 82 00 00 00 80 88 21 10 40 01 06 00 A0 B0 21 80 A3 00 00 10 60 01 06 00 A0 80 21 00 80 30 21 0? ?? ?? ?? 24 07 00 01 82 03 00 00 10 60 00 0B 00 00 00 00 24 C6 00 01 00 43 18 26 80 C2 00 00 2C 63 00 01 26 10 00 01 14 40 FF F7 00 E3 38 24 82 02 00 00 14 40 00 4E 8F BF 00 64 14 E0 00 15 02 20 10 21 82 C5 00 00 26 24 00 01 0? ?? ?? ?? 02 16 B0 23 10 40 00 45 00 40 A8 21 24 14 00 01 12 D4 00 0C 02 36 88 21 02 22 48 2B 02 22 88 23 2E C2 00 20 02 16 80 23 14 40 00 49 02 89 88 0B 02 A0 20 21 02 20 28 21 02 00 30 21 0? ?? ?? ?? 02 C0 38 21 8F BF 00 64 8F BE 00 60 8F B7 00 5C 8F B6 00 58 8F B5 00 54 8F B4 00 50 8F B3 00 4C 8F B2 00 48 8F B1 00 44 8F B0 00 40 03 E0 00 08 27 BD 00 68 26 7E 00 01 02 13 18 21 02 B3 20 21 01 3E 10 2B AF A4 00 20 10 40 00 09 90 77 00 00 02 89 30 23 02 A9 20 21 00 00 28 21 0? ?? ?? ?? 00 D3 30 21 14 40 00 1E 8F BF 00 64 03 C0 48 21 02 D3 10 23 00 53 18 2B 02 63 10 0B 26 63 FF FF AF A3 00 24 02 03 18 21 AF A3 00 28 03 D6 18 2B AF A3 00 2C 8F A3 00 28 24 42 00 01 8F A8 00 20 AF A2 00 18 AF A2 00 30 24 02 00 01 24 63 FF FF 00 53 10 23 AF A3 00 38 AF A2 00 34 8F A3 00 28 91 02 00 00 02 1E A0 21 25 06 00 01 12 E2 00 7E 00 73 80 23 14 40 00 78 00 00 00 00 8F BF 00 64 8F BE 00 60 8F B7 00 5C 8F B6 00 58 8F B5 00 54 8F B4 00 50 8F B3 00 4C 8F B2 00 48 8F B1 00 44 8F B0 00 40 00 00 10 21 03 E0 00 08 27 BD 00 68 02 00 20 21 02 C0 28 21 27 A6 00 18 0? ?? ?? ?? AF B1 00 3C 8F B2 00 18 02 00 20 21 00 40 30 21 02 12 28 21 0? ?? ?? ?? 00 40 98 21 14 40 FF BD 8F A9 00 3C 26 63 FF FF AF A3 00 20 02 03 88 21 02 93 A0 23 02 D2 18 23 00 00 F0 21 00 00 B8 21 AF A3 00 28 AF B4 00 24 02 F6 A0 21 02 A9 20 21 00 00 28 21 0? ?? ?? ?? 02 89 30 23 14 40 FF D8 8F BF 00 64 12 80 FF D6 02 60 20 21 03 D3 18 2B 03 C3 20 0A 00 80 18 21 00 97 28 21 00 96 20 2B 02 03 10 21 10 80 00 11 02 A5 28 21 90 46 00 00 90 A4 00 00 14 C4 00 2A 00 03 20 23 00 44 10 21 0? ?? ?? ?? 00 A4 28 21 91 4A 00 00 91 28 00 00 15 48 00 24 8F A4 00 24 24 63 00 01 00 76 40 2B 00 43 50 21 15 00 FF F8 00 A3 48 21 8F A3 00 20 03 D3 10 2B 02 E3 40 21 10 40 00 5C 02 A8 40 21 92 24 00 00 91 02 00 00 26 25 FF FF 14 82 00 57 25 03 FF FF 03 D3 48 23 01 09 48 21 0? ?? ?? ?? 02 68 40 23 24 63 FF FF 90 A4 00 01 90 62 00 01 14 82 00 04 00 00 00 00 24 A5 FF FF 14 69 FF F9 00 68 30 21 27 DE 00 01 00 DE 30 2B 14 C0 00 4E 8F BE 00 28 02 F2 B8 21 0? ?? ?? ?? 02 80 48 21 8F A4 00 24 00 00 F0 21 02 80 48 21 00 97 B8 21 0? ?? ?? ?? 02 E3 B8 21 10 80 FF 99 8F BF 00 64 8F A3 00 30 00 C3 90 21 02 56 88 21 02 A9 20 21 00 00 28 21 0? ?? ?? ?? 02 29 30 23 14 40 FF 90 8F BF 00 64 12 20 FF 8E 00 00 00 00 02 53 30 21 02 A6 30 21 02 20 48 21 00 C0 40 21 90 C2 00 00 16 E2 FF 84 25 06 00 01 8F A3 00 20 00 C3 30 23 8F A3 00 2C 10 60 00 11 24 C6 FF FF 91 04 00 01 92 82 00 00 26 83 00 01 14 44 00 29 25 08 00 02 0? ?? ?? ?? 03 C0 10 21 91 04 FF FF 90 65 FF FF 14 A4 00 24 00 00 00 00 24 42 00 01 00 56 20 2B 24 63 00 01 14 80 FF F8 25 08 00 01 8F A4 00 24 24 05 FF FF 00 C4 18 21 10 85 00 0E 02 A3 18 21 8F A5 00 28 90 64 00 00 90 A2 00 00 14 44 FF CE 24 63 FF FF 0? ?? ?? ?? 8F A2 00 38 90 45 00 00 90 64 00 01 14 A4 FF C8 24 42 FF FF 14 50 FF FB 24 63 FF FF 0? ?? ?? ?? 02 A6 10 21 0? ?? ?? ?? 02 60 30 21 00 A0 80 21 0? ?? ?? ?? 24 07 00 01 0? ?? ?? ?? 00 80 10 21 0? ?? ?? ?? 02 B7 10 21 03 C0 10 21 10 80 FF 52 8F BF 00 64 8F A3 00 34 00 66 30 21 0? ?? ?? ?? 00 C2 90 21 }
	condition:
		$1
}

rule file_147_2_0 {
	meta:
		name = "__libc_allocate_rtsig"
		size = 80
	strings:
		$1 = { 3C 05 ?? ?? 8C A2 ?? ?? 24 03 FF FF 10 43 00 0E 3C 06 ?? ?? 8C C3 ?? ?? 00 62 38 2A 14 E0 00 0A 00 00 00 00 10 80 00 04 00 00 00 00 24 43 00 01 03 E0 00 08 AC A3 ?? ?? 24 62 FF FF AC C2 ?? ?? 03 E0 00 08 00 60 10 21 03 E0 00 08 24 02 FF FF }
	condition:
		$1
}

rule file_149_0_0 {
	meta:
		name = "_IO_ftell"
		size = 652
		refs = "0004 __gnu_local_gp 0074 __lll_lock_wait_private 00a8 _IO_seekoff_unlocked 013c __libc_errno 0238 _Unwind_Resume"
	strings:
		$1 = { 8C 82 00 00 3C 1C ?? ?? 27 BD FF C8 27 9C ?? ?? 30 42 80 00 AF B0 00 28 AF BF 00 34 AF B2 00 30 AF B1 00 2C AF BC 00 18 14 40 00 1A 00 80 80 21 7C 03 E8 3B 8C 84 00 48 24 71 8B 70 8C 82 00 08 10 51 00 11 00 00 00 00 AF A0 00 20 C0 83 00 00 14 60 00 06 24 02 00 00 24 01 00 01 E0 81 00 00 10 20 FF FA 24 02 00 01 00 00 00 0F 14 40 00 03 00 00 00 00 0? ?? ?? ?? AF A3 00 20 8E 02 00 48 00 40 20 21 AC 51 00 08 8C 82 00 04 24 42 00 01 AC 82 00 04 24 02 00 01 AF A2 00 10 AF A0 00 14 02 00 20 21 00 00 38 21 0? ?? ?? ?? 00 00 30 21 8F BC 00 18 8E 04 00 00 00 40 88 21 30 82 01 00 10 40 00 07 00 60 90 21 24 02 FF FF 12 22 00 27 00 00 00 00 8E 02 00 6C 18 40 00 29 00 00 00 00 30 84 80 00 14 80 00 07 24 02 FF FF 8E 04 00 48 8C 82 00 04 24 42 FF FF 10 40 00 2B AC 82 00 04 24 02 FF FF 12 22 00 09 00 12 1F C3 14 71 00 39 02 40 10 21 8F BF 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 38 16 51 FF F7 00 00 00 00 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 64 18 21 8C 64 00 00 14 80 FF F3 8F BF 00 34 24 04 00 05 8F B2 00 30 8F B1 00 2C 8F B0 00 28 AC 64 00 00 03 E0 00 08 27 BD 00 38 10 71 FF DC 00 00 00 00 8E 02 00 6C 1C 40 FF D9 00 00 00 00 8E 03 00 2C 8E 02 00 24 00 62 10 23 02 42 18 23 00 02 17 C3 02 43 90 2B 02 22 88 23 02 32 88 23 0? ?? ?? ?? 00 60 90 21 AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF CD 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 24 02 FF FF 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 4F AC 43 00 00 0? ?? ?? ?? 24 02 FF FF 8E 02 00 00 30 42 80 00 14 40 00 06 00 80 88 21 8E 04 00 48 8C 83 00 04 24 63 FF FF 10 60 00 03 AC 83 00 04 0? ?? ?? ?? 02 20 20 21 AC 80 00 08 00 00 00 0F C0 83 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 63 00 02 14 60 FF F5 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_150_0_0 {
	meta:
		name = "__getgid"
		size = 16
	strings:
		$1 = { 24 02 0F CF 00 00 00 0C 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_151_0_0 {
	meta:
		name = "__new_exitfn"
		size = 468
		refs = "00dc __new_exitfn_called 015c calloc 0178 $LC0 017c $LC1 0190 __assert_fail 0180 __PRETTY_FUNCTION__.6418 01a0 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF D8 AF B0 00 18 3C 10 ?? ?? AF B2 00 20 26 03 ?? ?? 00 80 90 21 AF BF 00 24 AF B1 00 1C C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 59 00 00 00 00 8E 51 00 00 12 20 00 4C 02 20 40 21 00 00 48 21 8D 05 00 04 10 A0 00 11 24 A3 FF FF 00 03 31 00 01 06 30 21 8C C6 00 08 14 C0 00 12 00 00 00 00 00 05 29 00 24 A5 FF E8 10 60 00 08 01 05 28 21 24 A5 FF F0 8C A6 00 10 14 C0 00 0B 24 67 FF FF 00 E0 18 21 14 60 FF FB 24 A5 FF F0 8D 03 00 00 AD 00 00 04 10 60 00 29 01 00 48 21 0? ?? ?? ?? 00 60 40 21 00 A0 18 21 24 05 00 20 10 65 00 21 00 00 00 00 00 03 89 00 26 31 00 08 24 63 00 01 01 11 88 21 AD 03 00 04 3C 03 ?? ?? 8C 64 ?? ?? 8C 65 ?? ?? 24 82 00 01 00 44 20 2B 00 85 20 21 24 05 00 01 AE 25 00 00 AC 64 ?? ?? AC 62 ?? ?? 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 23 26 04 ?? ?? 8F BF 00 24 02 20 10 21 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 11 20 00 05 24 04 00 01 24 02 00 01 25 31 00 08 0? ?? ?? ?? AD 22 00 04 0? ?? ?? ?? 24 05 02 08 10 40 00 0C 00 40 48 21 AC 51 00 00 0? ?? ?? ?? AE 42 00 00 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 64 0? ?? ?? ?? 24 E7 ?? ?? 0? ?? ?? ?? 00 00 88 21 0? ?? ?? ?? 26 04 ?? ?? 0? ?? ?? ?? 8E 51 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 24 }
	condition:
		$1
}

rule file_151_1_0 {
	meta:
		name = "__internal_atexit"
		size = 108
		refs = "0020 __new_exitfn"
	strings:
		$1 = { 27 BD FF D8 AF B0 00 18 00 80 80 21 00 E0 20 21 AF B2 00 20 AF B1 00 1C AF BF 00 24 00 A0 90 21 0? ?? ?? ?? 00 C0 88 21 10 40 00 0E 00 00 00 00 AC 50 00 04 AC 52 00 08 AC 51 00 0C 00 00 00 0F 24 03 00 04 AC 43 00 00 00 00 10 21 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_152_0_0 {
	meta:
		name = "__sched_getscheduler"
		size = 28
	strings:
		$1 = { 24 02 10 41 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_153_0_0 {
	meta:
		name = "putmsg"
		size = 112
		refs = "0004 __gnu_local_gp 005c __libc_errno"
	strings:
		$1 = { 27 BD FF E8 3C 1C ?? ?? 27 9C ?? ?? AF BE 00 14 03 A0 F0 21 27 BD FF F0 00 E0 10 21 AF DC 00 00 AF DD 00 08 24 07 FF FF 27 BD FF E0 AF A2 00 10 24 02 10 71 00 00 00 0C 27 BD 00 20 14 E0 00 05 00 00 00 00 03 C0 E8 21 8F BE 00 14 03 E0 00 08 27 BD 00 18 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 64 20 21 AC 82 00 00 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "__wcscat_chk"
		size = 116
		refs = "006c __chk_fail"
	strings:
		$1 = { 27 BD FF E0 24 C6 FF FF 00 80 18 21 AF BF 00 1C 24 0A FF FF 10 CA 00 15 24 67 00 04 8C 68 00 00 11 00 00 04 24 C9 FF FF 01 20 30 21 0? ?? ?? ?? 00 E0 18 21 0? ?? ?? ?? 24 63 FF FC 10 C0 00 0B 24 C7 FF FF 00 E0 30 21 24 A5 00 04 8C A7 FF FC 24 63 00 04 14 E0 FF F9 AC 67 00 00 8F BF 00 1C 00 80 10 21 03 E0 00 08 27 BD 00 20 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_155_0_0 {
	meta:
		name = "__readlinkat_chk"
		size = 40
		refs = "0018 readlinkat 0020 __chk_fail"
	strings:
		$1 = { 27 BD FF E0 8F A2 00 30 00 47 10 2B 14 40 00 04 AF BF 00 1C 8F BF 00 1C 0? ?? ?? ?? 27 BD 00 20 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_156_0_0 {
	meta:
		name = "_IO_wpadn"
		size = 280
	strings:
		$1 = { 27 BD FF 90 24 02 00 20 AF B2 00 64 AF B0 00 5C AF BF 00 6C AF B3 00 68 AF B1 00 60 00 80 90 21 10 A2 00 37 00 C0 80 21 24 02 00 30 10 A2 00 37 27 A2 00 54 27 A3 00 14 AC 45 00 00 24 42 FF FC 14 43 FF FD 27 B3 00 18 2A 02 00 10 10 40 00 05 00 00 88 21 0? ?? ?? ?? 00 00 00 00 14 80 00 17 00 00 00 00 8E 42 00 98 02 40 20 21 02 60 28 21 8C 59 00 1C 24 06 00 10 03 20 F8 09 26 10 FF F0 24 03 00 10 2A 04 00 10 10 43 FF F4 02 22 88 21 8F BF 00 6C 00 02 10 27 24 03 FF FF 02 22 18 0B 8F B3 00 68 8F B2 00 64 8F B1 00 60 8F B0 00 5C 00 60 10 21 03 E0 00 08 27 BD 00 70 1A 00 00 07 02 40 20 21 8E 42 00 98 02 60 28 21 8C 59 00 1C 03 20 F8 09 02 00 30 21 02 22 88 21 8F BF 00 6C 02 20 18 21 8F B3 00 68 8F B2 00 64 8F B1 00 60 8F B0 00 5C 00 60 10 21 03 E0 00 08 27 BD 00 70 3C 13 ?? ?? 0? ?? ?? ?? 26 73 ?? ?? 3C 13 ?? ?? 0? ?? ?? ?? 26 73 ?? ?? }
	condition:
		$1
}

rule file_157_0_0 {
	meta:
		name = "mkostemps"
		size = 52
		refs = "0008 __gen_tempname 0004 __gnu_local_gp 001c __libc_errno"
	strings:
		$1 = { 04 A0 00 03 3C 1C ?? ?? 0? ?? ?? ?? 00 00 38 21 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 16 AC 43 00 00 03 E0 00 08 24 02 FF FF }
	condition:
		$1
}

rule file_158_0_0 {
	meta:
		name = "fgets_unlocked"
		size = 232
		refs = "000c __gnu_local_gp 005c _IO_getline 00ac __libc_errno"
	strings:
		$1 = { 18 A0 00 34 00 A0 18 21 27 BD FF D0 3C 1C ?? ?? 27 9C ?? ?? AF B1 00 24 00 80 88 21 24 04 00 01 AF BF 00 2C AF B2 00 28 AF B0 00 20 10 A4 00 2B AF BC 00 18 8C C2 00 00 AF A4 00 10 24 04 FF DF 00 44 20 24 AC C4 00 00 00 C0 80 21 00 C0 20 21 02 20 28 21 24 66 FF FF 24 07 00 0A 0? ?? ?? ?? 30 52 00 20 8F BC 00 18 14 40 00 0B 8E 04 00 00 00 00 88 21 00 92 20 25 AE 04 00 00 02 20 10 21 8F BF 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 30 30 83 00 20 10 60 00 09 00 00 00 00 7C 03 E8 3B 00 60 28 21 8F 83 ?? ?? 00 65 28 21 8C A5 00 00 24 03 00 0B 14 A3 FF EC 00 00 00 00 02 22 10 21 A0 40 00 00 0? ?? ?? ?? 8E 04 00 00 03 E0 00 08 00 00 10 21 A2 20 00 00 0? ?? ?? ?? 02 20 10 21 }
	condition:
		$1
}

rule file_159_0_0 {
	meta:
		name = "enlarge_userbuf.part.0"
		size = 572
		refs = "00cc __wmemcpy 00f8 _IO_wsetb 0178 wmemset 0230 $LC0 0238 $LC1 0224 __assert_fail 0214 __PRETTY_FUNCTION__.10309"
	strings:
		$1 = { 27 BD FF B8 AF B3 00 2C 8C 93 00 3C AF B0 00 20 8C 90 00 5C 32 73 00 08 AF B7 00 3C AF B1 00 24 AF BF 00 44 AF BE 00 40 AF B6 00 38 AF B5 00 34 AF B4 00 30 AF B2 00 28 00 80 88 21 8E 03 00 14 12 60 00 0F 8E 17 00 0C 8F BF 00 44 24 13 00 01 02 60 10 21 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 48 8C 99 00 A0 24 FE 00 64 00 1E F0 80 8E 14 00 18 03 C0 20 21 AF A3 00 18 00 C0 B0 21 03 20 F8 09 00 E0 A8 21 00 40 90 21 10 40 FF E7 8F A3 00 18 12 80 00 0D 02 40 20 21 8E 22 00 5C 02 80 28 21 8C 46 00 1C 8C 42 00 18 00 C2 30 23 0? ?? ?? ?? 00 06 30 83 8E 39 00 A4 03 20 F8 09 02 80 20 21 8F A3 00 18 AE 00 00 18 02 5E 30 21 02 20 20 21 02 40 28 21 24 07 00 01 0? ?? ?? ?? 00 77 B8 23 8F A2 00 58 10 40 00 2B 00 17 30 83 8E 02 00 00 8E 07 00 0C 8E 05 00 10 8E 04 00 14 8E 03 00 1C 00 F4 38 23 00 B4 28 23 00 94 20 23 00 17 BF C3 00 54 A0 23 02 47 38 21 02 45 28 21 02 44 20 21 02 54 A0 21 02 D7 10 2A AE 07 00 0C AE 05 00 10 AE 04 00 14 AE 14 00 00 AE 12 00 08 14 40 00 2B AE 03 00 04 12 F6 00 31 02 A6 10 2B 00 06 20 80 02 44 20 21 02 A6 30 23 0? ?? ?? ?? 00 00 28 21 8F BF 00 44 02 60 10 21 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 48 8E 02 00 10 8E 07 00 08 8E 05 00 00 8E 04 00 04 8E 03 00 1C 00 F4 38 23 00 B4 28 23 00 94 20 23 00 17 BF C3 00 54 A0 23 02 47 38 21 02 45 28 21 02 44 20 21 02 54 A0 21 02 D7 10 2A AE 07 00 08 AE 05 00 00 AE 04 00 04 AE 14 00 10 AE 12 00 0C 10 40 FF D7 AE 03 00 14 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 E6 0? ?? ?? ?? 24 E7 ?? ?? 10 40 FF CF 3C 04 ?? ?? 0? ?? ?? ?? 3C 05 ?? ?? }
	condition:
		$1
}

rule file_159_1_0 {
	meta:
		name = "_IO_wstr_underflow"
		size = 108
	strings:
		$1 = { 8C 82 00 5C 8C 43 00 10 8C 45 00 04 00 A3 30 2B 10 C0 00 03 00 00 00 00 AC 43 00 04 00 60 28 21 8C 86 00 00 24 07 0C 00 30 C8 0C 00 11 07 00 09 24 08 F7 FF 8C 43 00 00 00 65 28 2B 14 A0 00 03 24 02 FF FF 03 E0 00 08 00 00 00 00 03 E0 00 08 8C 62 00 00 8C 47 00 14 00 C8 30 24 AC 86 00 00 AC 43 00 00 0? ?? ?? ?? AC 47 00 10 }
	condition:
		$1
}

rule file_159_2_0 {
	meta:
		name = "_IO_wstr_overflow"
		size = 576
		refs = "0130 __wmemcpy 0158 wmemset 016c _IO_wsetb"
	strings:
		$1 = { 27 BD FF C0 AF B0 00 1C 00 80 80 21 8C 84 00 00 AF B2 00 24 24 B2 00 01 30 82 00 08 AF B1 00 20 AF BF 00 3C AF B7 00 38 AF B6 00 34 AF B5 00 30 AF B4 00 2C AF B3 00 28 00 A0 88 21 10 40 00 0E 2E 52 00 01 3A 52 00 01 00 12 10 23 8F BF 00 3C 8F B7 00 38 8F B6 00 34 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 40 30 83 0C 00 24 02 04 00 10 62 00 63 34 84 08 00 8E 03 00 5C 8C 62 00 10 8C 74 00 18 8C 73 00 1C 8C 64 00 0C 02 74 98 23 00 44 10 23 00 13 98 83 00 02 10 83 02 72 20 21 00 44 10 2B 14 40 00 43 00 00 00 00 8E 02 00 3C 30 42 00 08 10 40 00 0D 26 62 00 32 8F BF 00 3C 8F B7 00 38 8F B6 00 34 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 24 02 FF FF 03 E0 00 08 27 BD 00 40 00 02 A8 40 02 B3 18 2B 14 60 FF F2 8F BF 00 3C 8E 19 00 A0 00 02 B8 C0 03 20 F8 09 02 E0 20 21 10 40 FF EB 00 40 B0 21 12 80 00 09 00 40 20 21 02 80 28 21 0? ?? ?? ?? 02 60 30 21 8E 19 00 A4 03 20 F8 09 02 80 20 21 8E 02 00 5C AC 40 00 18 00 13 20 80 02 C4 20 21 00 00 28 21 0? ?? ?? ?? 02 B3 30 23 02 00 20 21 02 C0 28 21 02 D7 30 21 0? ?? ?? ?? 24 07 00 01 8E 03 00 5C 8C 67 00 08 8C 66 00 00 8C 65 00 04 8C 64 00 10 8C 62 00 1C 00 F4 38 23 00 D4 30 23 00 B4 28 23 00 94 20 23 02 C7 38 21 02 C6 30 21 02 C5 28 21 02 C4 20 21 AC 67 00 08 AC 66 00 00 AC 65 00 04 AC 64 00 10 AC 76 00 0C AC 62 00 14 12 40 00 19 00 00 00 00 8C 64 00 10 8C 65 00 04 00 A4 28 2B 10 A0 FF 9C 02 20 10 21 8F BF 00 3C 8F B7 00 38 8F B6 00 34 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C AC 64 00 04 03 E0 00 08 27 BD 00 40 8E 03 00 5C AE 04 00 00 8C 62 00 00 8C 64 00 04 AC 62 00 10 0? ?? ?? ?? AC 64 00 00 8C 62 00 10 24 44 00 04 AC 64 00 10 0? ?? ?? ?? AC 51 00 00 }
	condition:
		$1
}

rule file_159_3_0 {
	meta:
		name = "_IO_wstr_pbackfail"
		size = 40
		refs = "0020 _IO_wdefault_pbackfail"
	strings:
		$1 = { 8C 82 00 00 30 42 00 08 10 40 00 05 24 02 FF FF 10 A2 00 03 00 00 00 00 03 E0 00 08 00 00 00 00 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_159_4_0 {
	meta:
		name = "_IO_wstr_finish"
		size = 88
		refs = "0050 _IO_wdefault_finish"
	strings:
		$1 = { 8C 82 00 5C 27 BD FF E0 AF B0 00 18 00 80 80 21 8C 44 00 18 10 80 00 09 AF BF 00 1C 8E 03 00 3C 30 63 00 08 14 60 00 06 8F BF 00 1C 8E 19 00 A4 03 20 F8 09 00 00 00 00 8E 02 00 5C 8F BF 00 1C 02 00 20 21 8F B0 00 18 AC 40 00 18 00 00 28 21 0? ?? ?? ?? 27 BD 00 20 }
	condition:
		$1
}

rule file_159_5_0 {
	meta:
		name = "_IO_wstr_seekoff"
		size = 812
	strings:
		$1 = { 27 BD FF C8 AF B2 00 28 8F B2 00 4C AF B3 00 2C AF B1 00 24 AF B0 00 20 AF BF 00 34 AF B4 00 30 00 80 88 21 00 C0 98 21 16 40 00 33 00 E0 80 21 8C 82 00 00 30 43 04 00 10 60 00 57 00 00 00 00 30 42 08 00 10 40 00 71 00 00 00 00 8C 85 00 5C 8C A2 00 10 8C A3 00 04 8C A4 00 08 00 62 A0 2B 00 74 10 0A 00 44 A0 23 00 14 A0 83 8F A3 00 48 24 02 00 01 10 62 00 7D 24 02 00 02 14 62 00 06 02 14 18 21 00 14 17 C3 00 70 80 2B 02 62 98 21 02 13 98 21 00 60 80 21 06 60 00 2F 02 90 A0 2A 12 80 00 07 00 00 00 00 8E 23 00 20 8E 22 00 1C 00 62 10 23 00 50 10 2A 14 40 00 94 02 20 20 21 8C A4 00 0C 8F BF 00 34 00 10 18 80 00 83 18 21 02 60 10 21 AC A3 00 10 8F B4 00 30 02 00 18 21 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 38 8C 85 00 5C 32 46 00 01 8C A2 00 04 8C A3 00 10 8C A4 00 08 00 62 A0 2B 00 74 10 0A 00 44 A0 23 10 C0 00 12 00 14 A0 83 8F A3 00 48 24 02 00 01 10 62 00 44 00 00 00 00 24 02 00 02 14 62 00 06 02 14 18 21 00 14 17 C3 00 70 80 2B 02 62 98 21 02 13 98 21 00 60 80 21 06 61 00 51 00 00 00 00 24 02 FF FF 0? ?? ?? ?? 24 03 FF FF 32 52 00 02 24 02 FF FF 24 03 FF FF 16 40 FF BE 00 00 00 00 8F BF 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 38 30 42 00 08 10 40 00 0E 8F BF 00 34 8E 22 00 5C 8F B4 00 30 8C 43 00 00 8C 42 00 08 8F B3 00 2C 8F B2 00 28 00 62 18 23 00 03 17 C3 8F B1 00 24 8F B0 00 20 00 03 18 83 03 E0 00 08 27 BD 00 38 8E 22 00 5C 8F B4 00 30 8C 43 00 10 8C 42 00 0C 8F B3 00 2C 8F B2 00 28 00 62 18 23 00 03 17 C3 8F B1 00 24 8F B0 00 20 00 03 18 83 03 E0 00 08 27 BD 00 38 8C 85 00 5C 24 12 00 01 8C A3 00 04 8C A2 00 10 8C A4 00 08 00 62 A0 2B 00 74 10 0A 8F A3 00 48 00 44 A0 23 24 02 00 01 14 62 FF BE 00 14 A0 83 8C A2 00 00 00 44 20 23 00 04 18 83 02 03 18 21 00 04 27 C3 00 70 80 2B 02 64 98 21 02 13 98 21 06 60 FF BE 00 60 80 21 0? ?? ?? ?? 02 90 10 2A 8C A3 00 10 8C A2 00 0C 00 62 10 23 00 02 18 83 02 03 18 21 00 02 17 C3 00 70 80 2B 02 62 98 21 02 13 98 21 0? ?? ?? ?? 00 60 80 21 02 90 10 2A 10 40 00 07 00 00 00 00 8E 23 00 20 8E 22 00 1C 00 62 10 23 00 50 10 2A 14 40 00 0C 02 20 20 21 8C A2 00 08 00 10 18 80 00 14 20 80 00 43 18 21 00 44 10 21 AC A3 00 00 AC A2 00 04 32 52 00 02 02 60 10 21 0? ?? ?? ?? 02 00 18 21 24 02 00 01 AF A2 00 10 02 60 30 21 0? ?? ?? ?? 02 00 38 21 14 40 FF 96 00 00 00 00 0? ?? ?? ?? 8E 25 00 5C AF A0 00 10 02 60 30 21 0? ?? ?? ?? 02 00 38 21 14 40 FF 8F 24 02 FF FF 0? ?? ?? ?? 8E 25 00 5C }
	condition:
		$1
}

rule file_159_6_0 {
	meta:
		name = "_IO_wstr_init_static"
		size = 224
		refs = "0028 __wcslen 0044 _IO_wsetb"
	strings:
		$1 = { 27 BD FF D0 AF B2 00 24 AF B1 00 20 AF B0 00 1C AF BF 00 2C AF B3 00 28 00 80 88 21 00 A0 80 21 14 C0 00 1A 00 E0 90 21 0? ?? ?? ?? 00 A0 20 21 00 02 10 80 02 02 98 21 02 20 20 21 02 00 28 21 02 60 30 21 0? ?? ?? ?? 00 00 38 21 8E 23 00 5C AC 70 00 0C AC 70 00 08 12 40 00 16 AC 70 00 00 8F BF 00 2C AC 72 00 10 AC 73 00 14 AC 72 00 04 8F B3 00 28 AE 20 00 A0 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 30 00 06 98 80 02 65 98 21 00 B3 10 2B 14 40 FF E8 02 20 20 21 00 05 98 27 00 13 98 82 00 13 98 80 0? ?? ?? ?? 00 B3 98 21 8F BF 00 2C AC 70 00 10 AC 70 00 14 AC 73 00 04 8F B2 00 24 AE 20 00 A0 8F B3 00 28 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_159_7_0 {
	meta:
		name = "_IO_wstr_count"
		size = 36
	strings:
		$1 = { 8C 82 00 5C 8C 43 00 04 8C 44 00 10 8C 45 00 08 00 83 10 2B 00 82 18 0A 00 65 10 23 03 E0 00 08 00 02 10 83 }
	condition:
		$1
}

rule file_160_0_0 {
	meta:
		name = "_IO_ungetc"
		size = 424
		refs = "0074 __lll_lock_wait_private 0098 _IO_sputbackc 0154 _Unwind_Resume"
	strings:
		$1 = { 27 BD FF D0 24 02 FF FF AF B1 00 24 AF BF 00 2C AF B2 00 28 AF B0 00 20 10 82 00 43 00 80 88 21 8C A2 00 00 30 42 80 00 14 40 00 1A 00 A0 80 21 7C 03 E8 3B 8C A4 00 48 24 72 8B 70 8C 83 00 08 10 72 00 11 00 00 00 00 AF A0 00 18 C0 85 00 00 14 A0 00 06 24 03 00 00 24 01 00 01 E0 81 00 00 10 20 FF FA 24 03 00 01 00 00 00 0F 14 60 00 03 00 00 00 00 0? ?? ?? ?? AF A5 00 18 8E 03 00 48 00 60 20 21 AC 72 00 08 8C 83 00 04 24 63 00 01 AC 83 00 04 32 25 00 FF 0? ?? ?? ?? 02 00 20 21 8E 03 00 00 30 63 80 00 14 60 00 06 00 40 88 21 8E 04 00 48 8C 83 00 04 24 63 FF FF 10 60 00 07 AC 83 00 04 8F BF 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 30 AC 80 00 08 00 00 00 0F C0 83 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 63 00 02 14 60 FF F1 02 20 10 21 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 02 20 10 21 0? ?? ?? ?? 24 02 FF FF 8E 02 00 00 30 42 80 00 14 40 00 06 00 80 88 21 8E 04 00 48 8C 83 00 04 24 63 FF FF 10 60 00 03 AC 83 00 04 0? ?? ?? ?? 02 20 20 21 AC 80 00 08 00 00 00 0F C0 83 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 63 00 02 14 60 FF F5 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "__dladdr1"
		size = 56
		refs = "0018 _dl_addr"
	strings:
		$1 = { 24 02 00 01 10 E2 00 09 00 C0 18 21 24 02 00 02 14 E2 00 03 00 00 00 00 0? ?? ?? ?? 00 00 38 21 00 00 30 21 0? ?? ?? ?? 00 00 38 21 00 00 30 21 0? ?? ?? ?? 00 60 38 21 }
	condition:
		$1
}

rule file_162_0_0 {
	meta:
		name = "__fxprintf"
		size = 296
		refs = "0040 strlen 00a4 __vfwprintf 00d4 _IO_vfprintf 00fc stderr 0108 $LC0 010c $LC1 0120 __assert_fail 0110 __PRETTY_FUNCTION__.10946"
	strings:
		$1 = { 27 BD FF C8 AF BE 00 30 03 A0 F0 21 AF B1 00 28 AF B0 00 24 AF BF 00 34 AF B2 00 2C 00 80 88 21 AF C6 00 40 AF C7 00 44 10 80 00 34 00 A0 80 21 8E 22 00 6C 27 C6 00 40 18 40 00 25 AF C6 00 18 0? ?? ?? ?? 02 00 20 21 24 42 00 01 00 02 18 80 24 63 00 0A 00 03 18 C2 00 03 18 C0 03 A0 90 21 03 A3 E8 23 10 40 00 0E 27 A5 00 10 82 06 00 00 00 A0 38 21 04 C1 00 07 00 00 18 21 0? ?? ?? ?? 3C 04 ?? ?? 02 03 30 21 80 C6 00 00 04 C0 00 1E 24 E7 00 04 24 63 00 01 14 43 FF FA AC E6 00 00 8F C6 00 18 0? ?? ?? ?? 02 20 20 21 02 40 E8 21 03 C0 E8 21 8F BF 00 34 8F BE 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 38 02 20 20 21 0? ?? ?? ?? 02 00 28 21 03 C0 E8 21 8F BF 00 34 8F BE 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 38 3C 02 ?? ?? 0? ?? ?? ?? 8C 51 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 2E 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_163_0_0 {
	meta:
		name = "__vdprintf_chk"
		size = 236
		refs = "0000 _IO_wfile_jumps 0044 _IO_no_init 004c _IO_file_jumps 0058 _IO_file_init 0064 _IO_file_attach 009c _IO_vfprintf 00dc _IO_un_link"
	strings:
		$1 = { 3C 02 ?? ?? 27 BD FE 68 24 42 ?? ?? AF B3 01 90 AF B2 01 8C AF B1 01 88 AF B0 01 84 AF A2 00 10 00 80 80 21 00 A0 98 21 27 A4 00 E0 34 05 80 00 00 C0 90 21 00 E0 88 21 00 00 30 21 27 A7 00 20 AF BF 01 94 0? ?? ?? ?? AF A0 01 28 3C 02 ?? ?? 24 42 ?? ?? 27 A4 00 E0 0? ?? ?? ?? AF A2 01 78 27 A4 00 E0 0? ?? ?? ?? 02 00 28 21 10 40 00 1B 8F A3 00 E0 24 02 EF F3 00 62 10 24 34 42 00 44 1A 60 00 04 AF A2 00 E0 8F A2 01 1C 34 42 00 04 AF A2 01 1C 27 A4 00 E0 02 40 28 21 0? ?? ?? ?? 02 20 30 21 00 40 80 21 8F A2 01 78 27 A4 00 E0 8C 59 00 08 03 20 F8 09 00 00 28 21 02 00 10 21 8F BF 01 94 8F B3 01 90 8F B2 01 8C 8F B1 01 88 8F B0 01 84 03 E0 00 08 27 BD 01 98 0? ?? ?? ?? 27 A4 00 E0 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_164_0_0 {
	meta:
		name = "__tcgetattr"
		size = 204
		refs = "0000 __gnu_local_gp 006c mempcpy 00b8 __libc_errno"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF B0 27 9C ?? ?? 27 A6 00 18 AF B0 00 44 AF BF 00 4C 00 A0 80 21 AF B1 00 48 AF BC 00 10 24 05 54 0D 24 02 0F D6 00 00 00 0C 14 E0 00 1F 00 40 88 21 14 40 00 17 8F A2 00 18 26 04 00 11 27 A5 00 29 AE 02 00 00 8F A2 00 1C 24 06 00 17 AE 02 00 04 8F A2 00 20 AE 02 00 08 8F A2 00 24 AE 02 00 0C 93 A2 00 28 0? ?? ?? ?? A2 02 00 10 A0 40 00 00 A0 40 00 01 A0 40 00 02 A0 40 00 03 A0 40 00 04 A0 40 00 05 A0 40 00 06 A0 40 00 07 A0 40 00 08 8F BF 00 4C 02 20 10 21 8F B0 00 44 8F B1 00 48 03 E0 00 08 27 BD 00 50 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 AC 51 00 00 0? ?? ?? ?? 24 11 FF FF }
	condition:
		$1
}

rule file_165_0_0 {
	meta:
		name = "ptrace"
		size = 156
		refs = "0008 __gnu_local_gp 0050 __libc_errno"
	strings:
		$1 = { 27 BD FF E8 27 A2 00 1C 3C 1C ?? ?? AF B0 00 14 24 90 FF FF 27 9C ?? ?? 2E 10 00 03 AF A2 00 08 27 A2 00 0C AF A7 00 24 AF BC 00 00 AF A5 00 1C AF A6 00 20 00 50 38 0B 24 02 0F BA 00 00 00 0C 10 E0 00 0A 00 40 20 21 7C 03 E8 3B 00 60 28 21 8F 83 ?? ?? 24 02 FF FF 00 65 28 21 AC A4 00 00 8F B0 00 14 03 E0 00 08 27 BD 00 18 04 40 FF FC 00 00 00 00 12 00 FF FA 8F B0 00 14 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 8F A2 00 0C 00 64 20 21 AC 80 00 00 03 E0 00 08 27 BD 00 18 }
	condition:
		$1
}

rule file_166_0_0 {
	meta:
		name = "__inet_aton"
		size = 448
		refs = "0000 __gnu_local_gp 0010 __libc_errno 0088 strtoul 0194 __libc_tsd_CTYPE_B"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF B0 27 9C ?? ?? AF B2 00 30 8F 92 ?? ?? 7C 03 E8 3B AF B6 00 40 02 43 B0 21 AF B4 00 38 AF B3 00 34 AF BF 00 4C AF BE 00 48 AF B7 00 44 AF B5 00 3C AF B1 00 2C AF B0 00 28 AF BC 00 10 8E D3 00 00 AE C0 00 00 80 82 00 00 00 80 A0 21 24 42 FF D0 2C 42 00 0A 10 40 00 1F AF A0 00 1C 27 A2 00 1C 00 A0 B8 21 AF A2 00 20 00 40 F0 21 24 10 FF FF 24 15 00 22 27 B1 00 1F 00 00 30 21 02 80 20 21 0? ?? ?? ?? 27 A5 00 18 2C 46 01 00 10 50 00 20 8F BC 00 10 8F A5 00 18 24 03 00 2E 80 A4 00 00 14 83 00 20 00 00 00 00 13 D1 00 09 00 00 00 00 10 C0 00 07 27 DE 00 01 A3 C2 FF FF 80 A2 00 01 24 42 FF D0 2C 42 00 0A 14 40 FF EB 24 B4 00 01 7C 03 E8 3B 02 43 90 21 AE 53 00 00 00 00 10 21 8F BF 00 4C 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 8E C3 00 00 14 75 FF DF 00 00 00 00 0? ?? ?? ?? 00 00 00 00 14 80 00 15 00 00 00 00 10 B4 FF E8 8F A3 00 20 03 C3 20 23 3C 03 ?? ?? 00 04 20 80 24 63 ?? ?? 00 83 18 21 8C 63 00 00 00 62 18 2B 14 60 FF DF 00 00 00 00 12 E0 00 03 8F A3 00 1C 00 43 10 25 AE E2 00 00 7C 03 E8 3B 02 43 10 21 AC 53 00 00 0? ?? ?? ?? 24 02 00 01 04 80 FF D4 00 00 00 00 7C 03 E8 3B 00 60 30 21 8F 83 ?? ?? 00 04 20 40 00 66 30 21 8C C3 00 00 00 64 18 21 94 63 00 00 30 63 00 20 10 60 FF C9 00 00 00 00 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_166_1_0 {
	meta:
		name = "inet_addr"
		size = 44
		refs = "0008 __inet_aton"
	strings:
		$1 = { 27 BD FF D8 AF BF 00 24 0? ?? ?? ?? 27 A5 00 18 8F A4 00 18 8F BF 00 24 24 03 FF FF 00 82 18 0B 00 60 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_167_1_0 {
	meta:
		name = "svcunix_getargs"
		size = 20
		altNames = "svctcp_getargs"
	strings:
		$1 = { 8C 84 00 2C 00 A0 C8 21 00 C0 28 21 03 20 00 08 24 84 00 08 }
	condition:
		$1
}

rule file_167_2_0 {
	meta:
		name = "svcunix_freeargs"
		size = 28
		altNames = "svctcp_freeargs"
	strings:
		$1 = { 8C 84 00 2C 24 02 00 02 00 A0 C8 21 AC 82 00 08 00 C0 28 21 03 20 00 08 24 84 00 08 }
	condition:
		$1
}

rule file_167_3_0 {
	meta:
		name = "svcunix_destroy"
		size = 112
		refs = "0014 xprt_unregister 001c __close 0048 free"
		altNames = "svctcp_destroy"
	strings:
		$1 = { 27 BD FF D8 AF B0 00 1C 00 80 80 21 AF BF 00 24 AF B1 00 20 0? ?? ?? ?? 8C 91 00 2C 0? ?? ?? ?? 8E 04 00 00 96 02 00 04 14 40 00 0F 00 00 00 00 8E 22 00 0C 8C 59 00 1C 13 20 00 03 00 00 00 00 03 20 F8 09 26 24 00 08 0? ?? ?? ?? 02 20 20 21 8F BF 00 24 8F B1 00 20 02 00 20 21 8F B0 00 1C 0? ?? ?? ?? 27 BD 00 28 0? ?? ?? ?? A6 00 00 04 }
	condition:
		$1
}

rule file_167_5_0 {
	meta:
		name = "makefd_xprt"
		size = 284
		refs = "0028 malloc 0074 xdrrec_create 00a4 xprt_register 00d0 _libc_intl_domainname 00d4 $LC0 00e0 __dcgettext 00e8 $LC1 00ec $LC2 00fc __fxprintf 0104 free"
	strings:
		$1 = { 27 BD FF C8 AF B2 00 28 00 80 90 21 24 04 01 34 AF BF 00 34 AF B4 00 30 AF B3 00 2C AF B1 00 24 AF B0 00 20 00 A0 A0 21 0? ?? ?? ?? 00 C0 98 21 24 04 01 B0 0? ?? ?? ?? 00 40 80 21 12 00 00 24 00 40 88 21 10 40 00 22 02 80 28 21 24 44 00 08 3C 02 ?? ?? 24 42 ?? ?? AF A2 00 10 3C 02 ?? ?? 24 42 ?? ?? 02 60 30 21 02 00 38 21 AF A2 00 14 24 02 00 02 0? ?? ?? ?? AE 22 00 00 26 22 00 20 AE 02 00 24 3C 02 ?? ?? 24 42 ?? ?? 02 00 20 21 AE 02 00 08 AE 00 00 30 AE 11 00 2C AE 00 00 0C A6 00 00 04 0? ?? ?? ?? AE 12 00 00 02 00 10 21 8F BF 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 38 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 3C 05 ?? ?? 3C 06 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 00 40 38 21 0? ?? ?? ?? 00 00 20 21 0? ?? ?? ?? 02 00 20 21 0? ?? ?? ?? 02 20 20 21 0? ?? ?? ?? 00 00 10 21 }
	condition:
		$1
}

rule file_167_6_0 {
	meta:
		name = "readunix"
		size = 392
		refs = "0000 __gnu_local_gp 0010 __libc_errno 0064 __poll 00e0 __setsockopt 0118 __recvmsg"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF 90 27 9C ?? ?? AF B4 00 60 8F 94 ?? ?? AF B0 00 50 8C 90 00 00 7C 03 E8 3B AF B6 00 68 AF B5 00 64 AF B3 00 5C AF B2 00 58 AF B1 00 54 AF BF 00 6C AF BC 00 18 00 80 98 21 00 A0 B0 21 00 C0 A8 21 24 12 00 01 24 11 FF FF 02 83 A0 21 27 A4 00 44 24 05 00 01 34 06 88 B8 AF B0 00 44 0? ?? ?? ?? A7 B2 00 48 10 51 00 40 00 00 00 00 10 40 00 31 97 A2 00 4A 30 43 00 38 14 60 00 2E 30 42 00 01 10 40 FF F3 27 A4 00 44 24 03 00 04 AF A3 00 10 27 A3 00 3C AF A3 00 28 3C 03 ?? ?? 24 63 ?? ?? 24 02 00 01 AF A3 00 30 02 00 20 21 24 03 00 1C 34 05 FF FF 24 06 00 11 27 A7 00 4C AF B6 00 3C AF B5 00 40 AF A2 00 2C AF A0 00 20 AF A0 00 24 AF A3 00 34 AF A0 00 38 0? ?? ?? ?? AF A2 00 4C 14 40 00 14 8F BC 00 18 8F 91 ?? ?? 7C 03 E8 3B 24 12 00 04 0? ?? ?? ?? 02 23 88 21 8E 22 00 00 14 52 00 0C 00 00 00 00 02 00 20 21 27 A5 00 20 0? ?? ?? ?? 00 00 30 21 04 40 FF F8 8F A3 00 38 30 63 00 08 14 60 00 03 00 00 00 00 14 40 00 05 8F BF 00 6C 8E 63 00 2C 24 02 FF FF AC 60 00 00 8F BF 00 6C 8F B6 00 68 8F B5 00 64 8F B4 00 60 8F B3 00 5C 8F B2 00 58 8F B1 00 54 8F B0 00 50 03 E0 00 08 27 BD 00 70 8E 83 00 00 24 02 00 04 14 62 FF F0 97 A2 00 4A 0? ?? ?? ?? 30 42 00 01 }
	condition:
		$1
}

rule file_167_7_0 {
	meta:
		name = "writeunix"
		size = 364
		refs = "0000 __gnu_local_gp 0040 __libc_errno 0060 __getpid 0068 __geteuid 0070 __getegid 00e4 __sendmsg"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF 98 27 9C ?? ?? AF BF 00 64 AF BE 00 60 AF B7 00 5C AF B6 00 58 AF B5 00 54 AF B4 00 50 AF B3 00 4C AF B2 00 48 AF B1 00 44 AF B0 00 40 AF BC 00 10 18 C0 00 31 AF A6 00 70 8F 92 ?? ?? 3C 17 ?? ?? 7C 03 E8 3B 00 80 B0 21 00 A0 A8 21 00 C0 A0 21 26 F3 ?? ?? 02 43 90 21 0? ?? ?? ?? 8E D0 00 00 0? ?? ?? ?? 00 40 F0 21 0? ?? ?? ?? 00 40 88 21 AE 62 00 14 34 02 FF FF AE 62 00 04 24 02 00 02 AE 62 00 08 27 A2 00 34 24 03 00 18 AF A2 00 20 24 02 00 01 AE 71 00 10 AE 7E 00 0C AE E3 ?? ?? AF B5 00 34 AF B4 00 38 AF A2 00 24 AF A0 00 18 AF A0 00 1C AF B3 00 28 AF A3 00 2C AF A0 00 30 0? ?? ?? ?? 24 11 00 04 8E 42 00 00 14 51 00 17 8F BF 00 64 02 00 20 21 27 A5 00 18 0? ?? ?? ?? 00 00 30 21 04 40 FF F8 00 00 00 00 02 82 A0 23 1E 80 FF D9 02 A2 A8 21 8F BF 00 64 8F A2 00 70 8F BE 00 60 8F B7 00 5C 8F B6 00 58 8F B5 00 54 8F B4 00 50 8F B3 00 4C 8F B2 00 48 8F B1 00 44 8F B0 00 40 03 E0 00 08 27 BD 00 68 8E C3 00 2C 8F BE 00 60 8F B7 00 5C 8F B6 00 58 8F B5 00 54 8F B4 00 50 8F B3 00 4C 8F B2 00 48 8F B1 00 44 8F B0 00 40 24 02 FF FF AC 60 00 00 03 E0 00 08 27 BD 00 68 }
	condition:
		$1
}

rule file_167_8_0 {
	meta:
		name = "rendezvous_request"
		size = 288
		refs = "0000 __gnu_local_gp 0010 __libc_errno 0060 accept 00f4 __svc_accept_failed"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF 48 27 9C ?? ?? AF B3 00 AC 8F 93 ?? ?? 7C 03 E8 3B AF B4 00 B0 AF B2 00 A8 AF B1 00 A4 AF B0 00 A0 AF BF 00 B4 AF BC 00 10 00 80 80 21 8C 94 00 2C 24 11 00 6E 02 63 98 21 0? ?? ?? ?? 24 12 00 04 8E 62 00 00 14 52 00 29 00 00 00 00 8E 04 00 00 27 A5 00 18 27 A6 00 98 0? ?? ?? ?? AF B1 00 98 04 40 FF F7 00 40 20 21 8E 85 00 00 8E 86 00 04 24 02 00 01 AF A0 00 88 AF A0 00 8C AF A0 00 90 AF A0 00 94 0? ?? ?? ?? A7 A2 00 88 8F A4 00 88 24 43 00 10 8F A6 00 8C A8 64 00 00 B8 64 00 03 8F A5 00 90 A8 66 00 04 B8 66 00 07 8F A4 00 94 A8 65 00 08 B8 65 00 0B A8 64 00 0C B8 64 00 0F 8F BF 00 B4 8F A3 00 98 8F B4 00 B0 8F B3 00 AC AC 43 00 0C 8F B2 00 A8 8F B1 00 A4 8F B0 00 A0 00 00 10 21 03 E0 00 08 27 BD 00 B8 0? ?? ?? ?? 00 00 00 00 8F BF 00 B4 8F B4 00 B0 8F B3 00 AC 8F B2 00 A8 8F B1 00 A4 8F B0 00 A0 00 00 10 21 03 E0 00 08 27 BD 00 B8 }
	condition:
		$1
}

rule file_167_9_0 {
	meta:
		name = "svcunix_reply"
		size = 84
		refs = "0024 xdr_replymsg 0034 xdrrec_endofrecord"
		altNames = "svctcp_reply"
	strings:
		$1 = { 8C 82 00 2C 27 BD FF D8 AF B0 00 1C 8C 43 00 04 24 50 00 08 AF BF 00 24 AF B1 00 20 02 00 20 21 AC 40 00 08 0? ?? ?? ?? AC A3 00 00 02 00 20 21 24 05 00 01 0? ?? ?? ?? 00 40 88 21 8F BF 00 24 02 20 10 21 8F B0 00 1C 8F B1 00 20 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_167_10_0 {
	meta:
		name = "svcunix_stat"
		size = 68
		refs = "0020 xdrrec_eof"
		altNames = "svctcp_stat"
	strings:
		$1 = { 8C 84 00 2C 8C 83 00 00 14 60 00 03 00 60 10 21 03 E0 00 08 00 00 00 00 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? 24 84 00 08 8F BF 00 1C 24 04 00 02 24 03 00 01 00 82 18 0B 00 60 10 21 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_167_11_0 {
	meta:
		name = "svcunix_recv"
		size = 168
		refs = "002c xdrrec_skiprecord 0038 xdr_callmsg"
	strings:
		$1 = { 27 BD FF D0 AF B0 00 1C 8C 90 00 2C AF B3 00 28 AF B2 00 24 24 13 00 01 26 12 00 08 AF BF 00 2C AF B1 00 20 02 40 20 21 00 A0 88 21 0? ?? ?? ?? AE 13 00 08 02 40 20 21 0? ?? ?? ?? 02 20 28 21 14 40 00 09 8F BF 00 2C AE 00 00 00 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 00 00 10 21 03 E0 00 08 27 BD 00 30 8E 22 00 00 3C 03 ?? ?? 24 63 ?? ?? AE 02 00 04 AE 23 00 28 24 03 00 1C AE 33 00 24 AE 23 00 2C 8F BF 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 24 02 00 01 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_167_12_0 {
	meta:
		name = "svcunix_create"
		size = 576
		refs = "00a4 _libc_intl_domainname 004c memset 005c strlen 0074 memcpy 0088 __bind 0098 __getsockname 00a8 $LC4 00b4 __dcgettext 00bc perror 00f8 __listen 0108 malloc 0128 _null_auth 0170 xprt_register 01a0 __close 01b8 __socket 01d0 $LC3 01f8 $LC0 020c $LC1 0210 __func__.10010 0220 __fxprintf 0228 free"
	strings:
		$1 = { 27 BD FF 50 24 02 00 10 AF A2 00 88 24 02 FF FF AF B5 00 A8 AF B4 00 A4 AF B3 00 A0 AF B1 00 98 AF B0 00 94 AF BF 00 AC AF B2 00 9C 00 80 80 21 00 A0 A8 21 00 C0 A0 21 00 E0 88 21 10 82 00 5C 00 00 98 21 00 00 28 21 24 06 00 6E 0? ?? ?? ?? 27 A4 00 18 02 20 20 21 24 02 00 01 0? ?? ?? ?? A7 A2 00 18 00 40 90 21 27 A4 00 1A 02 20 28 21 24 46 00 01 0? ?? ?? ?? 26 52 00 03 02 00 20 21 27 A5 00 18 02 40 30 21 0? ?? ?? ?? AF B2 00 88 02 00 20 21 27 A5 00 18 0? ?? ?? ?? 27 A6 00 88 10 40 00 14 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 0? ?? ?? ?? 00 40 20 21 16 60 00 36 00 00 00 00 00 00 10 21 8F BF 00 AC 8F B5 00 A8 8F B4 00 A4 8F B3 00 A0 8F B2 00 9C 8F B1 00 98 8F B0 00 94 03 E0 00 08 27 BD 00 B0 02 00 20 21 0? ?? ?? ?? 24 05 00 80 14 40 FF E9 3C 04 ?? ?? 0? ?? ?? ?? 24 04 00 08 24 04 01 34 0? ?? ?? ?? 00 40 90 21 12 40 00 35 00 40 88 21 10 40 00 33 3C 03 ?? ?? 24 62 ?? ?? 8C 65 ?? ?? 8C 43 00 04 8C 42 00 08 02 20 20 21 AE 55 00 00 AE 22 00 28 3C 02 ?? ?? 24 42 ?? ?? AE 22 00 08 24 02 FF FF AE 54 00 04 AE 32 00 2C AE 25 00 20 AE 23 00 24 A6 22 00 04 AE 30 00 00 0? ?? ?? ?? AE 20 00 30 8F BF 00 AC 02 20 10 21 8F B5 00 A8 8F B4 00 A4 8F B3 00 A0 8F B2 00 9C 8F B1 00 98 8F B0 00 94 03 E0 00 08 27 BD 00 B0 0? ?? ?? ?? 02 00 20 21 0? ?? ?? ?? 00 00 10 21 24 04 00 01 24 05 00 02 0? ?? ?? ?? 00 00 30 21 00 40 80 21 04 41 FF 9F 24 13 00 01 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 0? ?? ?? ?? 00 40 20 21 0? ?? ?? ?? 00 00 10 21 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 3C 05 ?? ?? 3C 06 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 00 40 38 21 0? ?? ?? ?? 00 00 20 21 0? ?? ?? ?? 02 40 20 21 0? ?? ?? ?? 02 20 20 21 0? ?? ?? ?? 00 00 10 21 }
	condition:
		$1
}

rule file_168_0_0 {
	meta:
		name = "strerror"
		size = 240
		refs = "0000 __gnu_local_gp 002c __strerror_r 0058 __libc_errno 00ac malloc 00d4 _libc_intl_domainname 00d8 $LC0 00e8 __dcgettext"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF D0 27 9C ?? ?? 00 00 28 21 00 00 30 21 AF B0 00 1C AF BC 00 10 AF BF 00 2C AF B3 00 28 AF B2 00 24 AF B1 00 20 0? ?? ?? ?? 00 80 80 21 10 40 00 08 8F BC 00 10 8F BF 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 30 8F 92 ?? ?? 3C 11 ?? ?? 8E 22 ?? ?? 7C 03 E8 3B 02 43 20 21 10 40 00 0F 8C 93 00 00 8E 25 ?? ?? 7C 03 E8 3B 02 43 10 21 10 A0 00 0F AC 53 00 00 8F BF 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 02 00 20 21 8F B0 00 1C 24 06 04 00 0? ?? ?? ?? 27 BD 00 30 0? ?? ?? ?? 24 04 04 00 AE 22 ?? ?? 0? ?? ?? ?? 8F BC 00 10 8F BF 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 05 0? ?? ?? ?? 27 BD 00 30 }
	condition:
		$1
}

rule file_170_0_0 {
	meta:
		name = "__syscall_error"
		size = 48
		refs = "000c __errno_location"
	strings:
		$1 = { 27 BD FF E0 AF A2 00 14 AF BF 00 1C 0? ?? ?? ?? 00 00 00 00 8F A8 00 14 AC 48 00 00 8F BF 00 1C 27 BD 00 20 24 02 FF FF 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_171_0_0 {
	meta:
		name = "__libc_chown"
		size = 28
	strings:
		$1 = { 24 02 10 6A 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_172_0_0 {
	meta:
		name = "___fprintf_chk"
		size = 516
		refs = "0078 __lll_lock_wait_private 00bc vfprintf 01b0 _Unwind_Resume"
	strings:
		$1 = { 8C 82 00 00 27 BD FF C8 AF B2 00 2C 30 42 80 00 AF B1 00 28 AF B0 00 24 AF BF 00 34 AF B3 00 30 00 80 80 21 00 A0 90 21 AF A7 00 44 14 40 00 1A 00 C0 88 21 7C 03 E8 3B 8C 84 00 48 24 73 8B 70 8C 82 00 08 10 53 00 11 00 00 00 00 AF A0 00 18 C0 83 00 00 14 60 00 06 24 02 00 00 24 01 00 01 E0 81 00 00 10 20 FF FA 24 02 00 01 00 00 00 0F 14 40 00 03 00 00 00 00 0? ?? ?? ?? AF A3 00 18 8E 02 00 48 00 40 20 21 AC 53 00 08 8C 82 00 04 24 42 00 01 AC 82 00 04 1A 40 00 05 27 A2 00 44 8E 02 00 3C 34 42 00 04 AE 02 00 3C 27 A2 00 44 02 00 20 21 02 20 28 21 00 40 30 21 0? ?? ?? ?? AF A2 00 18 1A 40 00 18 00 40 88 21 8E 03 00 3C 24 02 FF FB 00 62 10 24 AE 02 00 3C 8E 03 00 00 24 04 FF EB 00 44 10 24 30 63 80 00 14 60 00 06 AE 02 00 3C 8E 04 00 48 8C 82 00 04 24 42 FF FF 10 40 00 0B AC 82 00 04 8F BF 00 34 02 20 10 21 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 38 0? ?? ?? ?? 8E 02 00 3C AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF ED 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 34 8E 05 00 3C 8E 02 00 00 24 03 FF EB 00 A3 18 24 30 42 80 00 00 80 88 21 14 40 00 06 AE 03 00 3C 8E 04 00 48 8C 83 00 04 24 63 FF FF 10 60 00 03 AC 83 00 04 0? ?? ?? ?? 02 20 20 21 AC 80 00 08 00 00 00 0F C0 83 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 63 00 02 14 60 FF F5 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_329_0_0 {
	meta:
		name = "__fwprintf_chk"
		size = 516
		refs = "0078 __lll_lock_wait_private 00bc _IO_vfwprintf 01b0 _Unwind_Resume"
	strings:
		$1 = { 8C 82 00 00 27 BD FF C8 AF B2 00 2C 30 42 80 00 AF B1 00 28 AF B0 00 24 AF BF 00 34 AF B3 00 30 00 80 80 21 00 A0 90 21 AF A7 00 44 14 40 00 1A 00 C0 88 21 7C 03 E8 3B 8C 84 00 48 24 73 8B 70 8C 82 00 08 10 53 00 11 00 00 00 00 AF A0 00 18 C0 83 00 00 14 60 00 06 24 02 00 00 24 01 00 01 E0 81 00 00 10 20 FF FA 24 02 00 01 00 00 00 0F 14 40 00 03 00 00 00 00 0? ?? ?? ?? AF A3 00 18 8E 02 00 48 00 40 20 21 AC 53 00 08 8C 82 00 04 24 42 00 01 AC 82 00 04 1A 40 00 05 27 A2 00 44 8E 02 00 3C 34 42 00 04 AE 02 00 3C 27 A2 00 44 02 00 20 21 02 20 28 21 00 40 30 21 0? ?? ?? ?? AF A2 00 18 1A 40 00 18 00 40 88 21 8E 03 00 3C 24 02 FF FB 00 62 10 24 AE 02 00 3C 8E 03 00 00 24 04 FF EB 00 44 10 24 30 63 80 00 14 60 00 06 AE 02 00 3C 8E 04 00 48 8C 82 00 04 24 42 FF FF 10 40 00 0B AC 82 00 04 8F BF 00 34 02 20 10 21 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 38 0? ?? ?? ?? 8E 02 00 3C AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF ED 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 34 8E 05 00 3C 8E 02 00 00 24 03 FF EB 00 A3 18 24 30 42 80 00 00 80 88 21 14 40 00 06 AE 03 00 3C 8E 04 00 48 8C 83 00 04 24 63 FF FF 10 60 00 03 AC 83 00 04 0? ?? ?? ?? 02 20 20 21 AC 80 00 08 00 00 00 0F C0 83 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 63 00 02 14 60 FF F5 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_173_0_0 {
	meta:
		name = "gethostid"
		size = 512
		refs = "0004 __gnu_local_gp 0010 $LC0 0058 __libc_errno 0068 __gethostname 0188 __gethostbyname_r 01ec memcpy"
	strings:
		$1 = { 27 BD FF 58 3C 1C ?? ?? 27 9C ?? ?? AF BE 00 A0 3C 04 ?? ?? 03 A0 F0 21 AF BF 00 A4 AF B4 00 9C AF B3 00 98 AF B2 00 94 AF B1 00 90 AF B0 00 8C AF DC 00 18 24 84 ?? ?? 24 05 20 00 00 00 30 21 24 02 0F A5 00 00 00 0C 10 E0 00 19 00 40 80 21 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 AC 50 00 00 27 C4 00 20 0? ?? ?? ?? 24 05 00 40 04 40 00 04 8F DC 00 18 83 C2 00 20 14 40 00 2A 8F 94 ?? ?? 00 00 10 21 03 C0 E8 21 8F BF 00 A4 8F BE 00 A0 8F B4 00 9C 8F B3 00 98 8F B2 00 94 8F B1 00 90 8F B0 00 8C 03 E0 00 08 27 BD 00 A8 04 40 FF EC 00 40 20 21 27 C5 00 80 24 06 00 04 24 02 0F A3 00 00 00 0C 10 E0 00 07 00 40 28 21 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 AC 45 00 00 24 05 FF FF 02 00 20 21 24 02 0F A6 00 00 00 0C 24 02 00 04 14 A2 FF DA 8F DF 00 A4 03 C0 E8 21 8F C2 00 80 8F B4 00 9C 8F BE 00 A0 8F B3 00 98 8F B2 00 94 8F B1 00 90 8F B0 00 8C 03 E0 00 08 27 BD 00 A8 27 BD FB F8 7C 03 E8 3B 27 B1 00 18 24 10 04 00 24 12 FF FF 02 83 A0 21 0? ?? ?? ?? 24 13 00 22 8E 82 00 00 14 53 FF CE 00 00 10 21 03 A4 E8 23 27 A2 00 18 00 43 20 21 02 24 88 26 00 71 80 0B 00 40 88 21 27 C2 00 84 AF A2 00 10 27 C2 00 78 02 00 38 21 27 C4 00 20 AF A2 00 14 02 20 30 21 0? ?? ?? ?? 27 C5 00 64 00 10 18 40 24 04 FF F0 24 63 00 0F 00 64 18 24 24 64 00 08 14 40 00 04 00 70 80 21 8F C2 00 84 14 40 00 06 00 00 00 00 8F C2 00 78 10 52 FF E2 00 00 10 21 0? ?? ?? ?? 03 C0 E8 21 8C 43 00 10 8C 42 00 0C 27 C4 00 7C 8C 65 00 00 28 46 00 05 24 03 00 04 00 46 18 0B 00 60 30 21 0? ?? ?? ?? AF C0 00 7C 8F C2 00 7C 0? ?? ?? ?? 00 22 14 02 }
	condition:
		$1
}

rule file_174_0_0 {
	meta:
		name = "__atomic_writev_replacement"
		size = 524
		refs = "0004 __gnu_local_gp 00f8 mempcpy 0114 __write 0120 free 0168 __libc_errno 01b8 __libc_alloca_cutoff 01c8 malloc 01ec _Unwind_Resume"
	strings:
		$1 = { 27 BD FF B8 3C 1C ?? ?? 27 9C ?? ?? AF BE 00 40 03 A0 F0 21 AF B4 00 30 AF B3 00 2C AF B2 00 28 AF BF 00 44 AF B7 00 3C AF B6 00 38 AF B5 00 34 AF B1 00 24 AF B0 00 20 AF DC 00 10 00 C0 98 21 00 80 A0 21 18 C0 00 5A 00 A0 90 21 8C A2 00 04 3C 03 80 00 00 43 18 2B 10 60 00 41 00 A0 38 21 3C 05 7F FF 00 00 18 21 00 00 80 21 0? ?? ?? ?? 34 A5 FF FF 24 E7 00 08 8C E2 00 04 00 B0 20 23 00 82 20 2B 14 80 00 36 00 00 00 00 24 63 00 01 14 73 FF F8 02 02 80 21 34 02 80 01 02 02 10 2B 10 40 00 45 00 00 00 00 26 02 00 0E 00 02 10 C2 00 02 10 C0 03 A2 E8 23 27 B5 00 10 1A 60 00 13 AF C0 00 18 02 A0 10 21 02 00 88 21 0? ?? ?? ?? 00 00 B0 21 12 D3 00 0D 26 52 00 08 8E 43 00 04 8E 45 00 00 00 40 20 21 02 23 B8 2B 02 37 18 0B 00 60 B8 21 00 60 30 21 0? ?? ?? ?? 02 37 88 23 16 20 FF F4 26 D6 00 01 26 D6 FF FF 02 80 20 21 02 A0 28 21 0? ?? ?? ?? 02 00 30 21 8F C4 00 18 0? ?? ?? ?? AF C2 00 1C 03 C0 E8 21 8F BF 00 44 8F C2 00 1C 8F B7 00 3C 8F BE 00 40 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 48 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 16 AC 43 00 00 03 C0 E8 21 8F BF 00 44 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 24 02 FF FF 03 E0 00 08 27 BD 00 48 0? ?? ?? ?? 00 00 80 21 0? ?? ?? ?? 02 00 20 21 14 40 FF BA 26 02 00 0E 0? ?? ?? ?? 02 00 20 21 10 40 00 08 00 40 A8 21 0? ?? ?? ?? AF C2 00 18 00 80 80 21 0? ?? ?? ?? 8F C4 00 18 0? ?? ?? ?? 02 00 20 21 AF C0 00 18 0? ?? ?? ?? 24 02 FF FF AF C0 00 18 0? ?? ?? ?? 00 80 80 21 }
	condition:
		$1
}

rule file_174_1_0 {
	meta:
		name = "__libc_writev"
		size = 292
		refs = "0000 __gnu_local_gp 0054 __libc_errno 0098 __libc_enable_asynccancel 00e0 __libc_disable_asynccancel"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF D0 27 9C ?? ?? AF B2 00 28 AF B1 00 24 AF B0 00 20 AF BF 00 2C AF BC 00 10 00 80 90 21 00 A0 88 21 00 C0 80 21 7C 03 E8 3B 8C 62 8B 70 14 40 00 18 00 00 00 00 24 02 10 32 00 00 00 0C 10 E0 00 2A 00 40 28 21 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 64 20 21 AC 82 00 00 24 02 FF FF 24 03 00 16 14 A3 00 23 8F BF 00 2C 2A 03 00 09 14 60 00 20 02 40 20 21 02 20 28 21 8F B2 00 28 8F B1 00 24 02 00 30 21 8F B0 00 20 0? ?? ?? ?? 27 BD 00 30 0? ?? ?? ?? 00 00 00 00 00 40 F8 21 8F BC 00 10 02 40 20 21 02 20 28 21 02 00 30 21 24 02 10 32 00 00 00 0C 10 E0 00 08 03 E0 20 21 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 64 20 21 AC 82 00 00 24 02 FF FF 03 E0 20 21 0? ?? ?? ?? AF A2 00 18 8F BC 00 10 8F A2 00 18 04 40 00 06 8F BF 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 30 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 64 20 21 0? ?? ?? ?? 8C 85 00 00 }
	condition:
		$1
}

rule file_175_0_0 {
	meta:
		name = "fexecve"
		size = 244
		refs = "0000 __gnu_local_gp 003c __libc_errno 0048 __snprintf 0034 $LC0 0058 __execve 0064 $LC1 0078 __xstat"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF 28 27 9C ?? ?? AF BF 00 D4 AF B2 00 D0 AF B1 00 CC AF B0 00 C8 04 80 00 28 AF BC 00 10 10 A0 00 26 00 A0 80 21 10 C0 00 24 00 C0 88 21 3C 06 ?? ?? 00 80 38 21 8F 92 ?? ?? 27 A4 00 A8 24 05 00 1B 0? ?? ?? ?? 24 C6 ?? ?? 02 00 28 21 02 20 30 21 0? ?? ?? ?? 27 A4 00 A8 7C 03 E8 3B 3C 05 ?? ?? 02 43 88 21 24 04 00 03 24 A5 ?? ?? 27 A6 00 18 0? ?? ?? ?? 8E 30 00 00 14 40 00 0B 24 02 00 59 8F BF 00 D4 7C 03 E8 3B 02 43 90 21 AE 50 00 00 8F B1 00 CC 8F B2 00 D0 8F B0 00 C8 24 02 FF FF 03 E0 00 08 27 BD 00 D8 8E 23 00 00 38 63 00 02 0? ?? ?? ?? 00 43 80 0A 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 8F BF 00 D4 8F B2 00 D0 00 62 10 21 24 03 00 16 AC 43 00 00 8F B1 00 CC 8F B0 00 C8 24 02 FF FF 03 E0 00 08 27 BD 00 D8 }
	condition:
		$1
}

rule file_176_0_0 {
	meta:
		name = "__getdtablesize"
		size = 52
		refs = "000c __getrlimit"
	strings:
		$1 = { 27 BD FF D8 27 A5 00 18 AF BF 00 24 0? ?? ?? ?? 24 04 00 05 8F A4 00 18 8F BF 00 24 28 42 00 00 24 03 01 00 00 82 18 0A 00 60 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_177_0_0 {
	meta:
		name = "__frexp"
		size = 168
		refs = "0050 $LC0 0054 __muldf3"
	strings:
		$1 = { 27 BD FF E0 7C 87 F0 00 AF B0 00 18 00 C0 80 21 3C 06 7F F0 00 E6 30 2A AF BF 00 1C 00 A0 18 21 AE 00 00 00 00 80 48 21 10 C0 00 19 00 A0 40 21 00 E5 30 25 10 C0 00 16 00 80 50 21 3C 06 00 10 00 E6 30 2A 10 C0 00 08 00 00 10 21 3C 02 ?? ?? 8C 47 ?? ?? 0? ?? ?? ?? 8C 46 ?? ?? 00 40 50 21 7C 47 F0 00 24 02 FF CA 00 07 3D 03 3C 09 80 0F 24 E7 FC 02 35 29 FF FF 01 49 48 24 00 E2 10 21 3C 04 3F E0 01 24 48 25 AE 02 00 00 00 60 40 21 8F BF 00 1C 8F B0 00 18 01 20 10 21 01 00 18 21 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_178_0_0 {
	meta:
		name = "getgrent"
		size = 284
		refs = "0004 __gnu_local_gp 0054 __getgrent_r 0074 __nss_getent 0088 __libc_errno 00e8 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF C8 3C 1C ?? ?? AF B0 00 24 3C 10 ?? ?? 27 9C ?? ?? 26 03 ?? ?? AF BF 00 34 AF B3 00 30 AF B2 00 2C AF B1 00 28 AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 28 00 00 00 00 3C 02 ?? ?? 24 42 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 06 ?? ?? AF A2 00 10 AF A0 00 14 24 84 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 24 07 04 00 8F BC 00 18 7C 03 E8 3B 00 40 90 21 8F 91 ?? ?? 02 23 20 21 8C 93 00 00 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 10 26 04 ?? ?? 8F BF 00 34 7C 03 E8 3B 02 23 88 21 AE 33 00 00 02 40 10 21 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 38 0? ?? ?? ?? 26 04 ?? ?? 0? ?? ?? ?? 3C 02 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 34 }
	condition:
		$1
}

rule file_275_0_0 {
	meta:
		name = "getaliasent"
		size = 284
		refs = "0004 __gnu_local_gp 0054 __getaliasent_r 0074 __nss_getent 0088 __libc_errno 00e8 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF C8 3C 1C ?? ?? AF B0 00 24 3C 10 ?? ?? 27 9C ?? ?? 26 03 ?? ?? AF BF 00 34 AF B3 00 30 AF B2 00 2C AF B1 00 28 AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 28 00 00 00 00 3C 02 ?? ?? 24 42 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 06 ?? ?? AF A2 00 10 AF A0 00 14 24 84 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 24 07 04 00 8F BC 00 18 7C 03 E8 3B 00 40 90 21 8F 91 ?? ?? 02 23 20 21 8C 93 00 00 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 10 26 04 ?? ?? 8F BF 00 34 7C 03 E8 3B 02 23 88 21 AE 33 00 00 02 40 10 21 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 38 0? ?? ?? ?? 26 04 ?? ?? 0? ?? ?? ?? 3C 02 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 34 }
	condition:
		$1
}

rule file_286_0_0 {
	meta:
		name = "getprotoent"
		size = 284
		refs = "0004 __gnu_local_gp 0054 __getprotoent_r 0074 __nss_getent 0088 __libc_errno 00e8 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF C8 3C 1C ?? ?? AF B0 00 24 3C 10 ?? ?? 27 9C ?? ?? 26 03 ?? ?? AF BF 00 34 AF B3 00 30 AF B2 00 2C AF B1 00 28 AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 28 00 00 00 00 3C 02 ?? ?? 24 42 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 06 ?? ?? AF A2 00 10 AF A0 00 14 24 84 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 24 07 04 00 8F BC 00 18 7C 03 E8 3B 00 40 90 21 8F 91 ?? ?? 02 23 20 21 8C 93 00 00 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 10 26 04 ?? ?? 8F BF 00 34 7C 03 E8 3B 02 23 88 21 AE 33 00 00 02 40 10 21 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 38 0? ?? ?? ?? 26 04 ?? ?? 0? ?? ?? ?? 3C 02 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 34 }
	condition:
		$1
}

rule file_598_0_0 {
	meta:
		name = "getpwent"
		size = 284
		refs = "0004 __gnu_local_gp 0054 __getpwent_r 0074 __nss_getent 0088 __libc_errno 00e8 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF C8 3C 1C ?? ?? AF B0 00 24 3C 10 ?? ?? 27 9C ?? ?? 26 03 ?? ?? AF BF 00 34 AF B3 00 30 AF B2 00 2C AF B1 00 28 AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 28 00 00 00 00 3C 02 ?? ?? 24 42 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 06 ?? ?? AF A2 00 10 AF A0 00 14 24 84 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 24 07 04 00 8F BC 00 18 7C 03 E8 3B 00 40 90 21 8F 91 ?? ?? 02 23 20 21 8C 93 00 00 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 10 26 04 ?? ?? 8F BF 00 34 7C 03 E8 3B 02 23 88 21 AE 33 00 00 02 40 10 21 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 38 0? ?? ?? ?? 26 04 ?? ?? 0? ?? ?? ?? 3C 02 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 34 }
	condition:
		$1
}

rule file_702_0_0 {
	meta:
		name = "getrpcent"
		size = 284
		refs = "0004 __gnu_local_gp 0054 __getrpcent_r 0074 __nss_getent 0088 __libc_errno 00e8 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF C8 3C 1C ?? ?? AF B0 00 24 3C 10 ?? ?? 27 9C ?? ?? 26 03 ?? ?? AF BF 00 34 AF B3 00 30 AF B2 00 2C AF B1 00 28 AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 28 00 00 00 00 3C 02 ?? ?? 24 42 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 06 ?? ?? AF A2 00 10 AF A0 00 14 24 84 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 24 07 04 00 8F BC 00 18 7C 03 E8 3B 00 40 90 21 8F 91 ?? ?? 02 23 20 21 8C 93 00 00 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 10 26 04 ?? ?? 8F BF 00 34 7C 03 E8 3B 02 23 88 21 AE 33 00 00 02 40 10 21 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 38 0? ?? ?? ?? 26 04 ?? ?? 0? ?? ?? ?? 3C 02 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 34 }
	condition:
		$1
}

rule file_1026_0_0 {
	meta:
		name = "getservent"
		size = 284
		refs = "0004 __gnu_local_gp 0054 __getservent_r 0074 __nss_getent 0088 __libc_errno 00e8 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF C8 3C 1C ?? ?? AF B0 00 24 3C 10 ?? ?? 27 9C ?? ?? 26 03 ?? ?? AF BF 00 34 AF B3 00 30 AF B2 00 2C AF B1 00 28 AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 28 00 00 00 00 3C 02 ?? ?? 24 42 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 06 ?? ?? AF A2 00 10 AF A0 00 14 24 84 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 24 07 04 00 8F BC 00 18 7C 03 E8 3B 00 40 90 21 8F 91 ?? ?? 02 23 20 21 8C 93 00 00 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 10 26 04 ?? ?? 8F BF 00 34 7C 03 E8 3B 02 23 88 21 AE 33 00 00 02 40 10 21 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 38 0? ?? ?? ?? 26 04 ?? ?? 0? ?? ?? ?? 3C 02 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 34 }
	condition:
		$1
}

rule file_1280_0_0 {
	meta:
		name = "getsgent"
		size = 284
		refs = "0004 __gnu_local_gp 0054 __getsgent_r 0074 __nss_getent 0088 __libc_errno 00e8 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF C8 3C 1C ?? ?? AF B0 00 24 3C 10 ?? ?? 27 9C ?? ?? 26 03 ?? ?? AF BF 00 34 AF B3 00 30 AF B2 00 2C AF B1 00 28 AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 28 00 00 00 00 3C 02 ?? ?? 24 42 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 06 ?? ?? AF A2 00 10 AF A0 00 14 24 84 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 24 07 04 00 8F BC 00 18 7C 03 E8 3B 00 40 90 21 8F 91 ?? ?? 02 23 20 21 8C 93 00 00 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 10 26 04 ?? ?? 8F BF 00 34 7C 03 E8 3B 02 23 88 21 AE 33 00 00 02 40 10 21 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 38 0? ?? ?? ?? 26 04 ?? ?? 0? ?? ?? ?? 3C 02 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 34 }
	condition:
		$1
}

rule file_533_0_0 {
	meta:
		name = "getspent"
		size = 284
		refs = "0004 __gnu_local_gp 0054 __getspent_r 0074 __nss_getent 0088 __libc_errno 00e8 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF C8 3C 1C ?? ?? AF B0 00 24 3C 10 ?? ?? 27 9C ?? ?? 26 03 ?? ?? AF BF 00 34 AF B3 00 30 AF B2 00 2C AF B1 00 28 AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 28 00 00 00 00 3C 02 ?? ?? 24 42 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 06 ?? ?? AF A2 00 10 AF A0 00 14 24 84 ?? ?? 24 A5 ?? ?? 24 C6 ?? ?? 0? ?? ?? ?? 24 07 04 00 8F BC 00 18 7C 03 E8 3B 00 40 90 21 8F 91 ?? ?? 02 23 20 21 8C 93 00 00 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 10 26 04 ?? ?? 8F BF 00 34 7C 03 E8 3B 02 23 88 21 AE 33 00 00 02 40 10 21 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 38 0? ?? ?? ?? 26 04 ?? ?? 0? ?? ?? ?? 3C 02 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 34 }
	condition:
		$1
}

rule file_179_0_0 {
	meta:
		name = "shmat"
		size = 144
		refs = "0004 __gnu_local_gp 006c __libc_errno"
	strings:
		$1 = { 27 BD FF E8 3C 1C ?? ?? 00 80 18 21 AF BE 00 14 27 9C ?? ?? 03 A0 F0 21 27 BD FF F0 00 A0 10 21 AF DC 00 00 AF DD 00 08 24 04 00 15 00 60 28 21 27 C7 00 0C 27 BD FF E0 AF A2 00 10 24 02 10 15 00 00 00 0C 27 BD 00 20 14 E0 00 06 00 00 00 00 03 C0 E8 21 8F C2 00 0C 8F BE 00 14 03 E0 00 08 27 BD 00 18 7C 03 E8 3B 00 60 28 21 8F 83 ?? ?? 00 40 20 21 24 02 FF FF 00 65 28 21 AC A4 00 00 03 C0 E8 21 8F BE 00 14 03 E0 00 08 27 BD 00 18 }
	condition:
		$1
}

rule file_180_0_0 {
	meta:
		name = "__posix_spawn_file_actions_realloc"
		size = 104
		refs = "0028 realloc"
	strings:
		$1 = { 27 BD FF D8 AF B1 00 20 8C 91 00 00 AF B0 00 1C 00 80 80 21 26 31 00 08 8C 84 00 08 00 11 11 00 00 11 28 80 AF BF 00 24 0? ?? ?? ?? 00 A2 28 21 10 40 00 08 8F BF 00 24 AE 02 00 08 AE 11 00 00 00 00 10 21 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 8F B1 00 20 8F B0 00 1C 24 02 00 0C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_180_1_0 {
	meta:
		name = "posix_spawn_file_actions_init"
		size = 36
		refs = "000c memset"
	strings:
		$1 = { 27 BD FF E0 00 00 28 21 AF BF 00 1C 0? ?? ?? ?? 24 06 00 4C 8F BF 00 1C 00 00 10 21 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_181_0_0 {
	meta:
		name = "_IO_getwc"
		size = 448
		refs = "0064 __lll_lock_wait_private 0138 __wuflow 016c _Unwind_Resume"
	strings:
		$1 = { 8C 82 00 00 27 BD FF D0 AF B0 00 24 30 42 80 00 AF BF 00 2C AF B1 00 28 14 40 00 1A 00 80 80 21 7C 03 E8 3B 8C 84 00 48 24 71 8B 70 8C 82 00 08 10 51 00 11 00 00 00 00 AF A0 00 18 C0 83 00 00 14 60 00 06 24 02 00 00 24 01 00 01 E0 81 00 00 10 20 FF FA 24 02 00 01 00 00 00 0F 14 40 00 03 00 00 00 00 0? ?? ?? ?? AF A3 00 18 8E 02 00 48 00 40 20 21 AC 51 00 08 8C 82 00 04 24 42 00 01 AC 82 00 04 8E 03 00 5C 10 60 00 2B 00 00 00 00 8C 64 00 00 8C 62 00 04 00 82 10 2B 10 40 00 26 00 00 00 00 8C 91 00 00 24 84 00 04 AC 64 00 00 8E 02 00 00 30 42 80 00 14 40 00 07 8F BF 00 2C 8E 04 00 48 8C 82 00 04 24 42 FF FF 10 40 00 07 AC 82 00 04 8F BF 00 2C 02 20 10 21 8F B0 00 24 8F B1 00 28 03 E0 00 08 27 BD 00 30 AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF F1 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 2C 0? ?? ?? ?? 02 00 20 21 0? ?? ?? ?? 00 40 88 21 8E 02 00 00 30 42 80 00 14 40 00 06 00 80 88 21 8E 04 00 48 8C 83 00 04 24 63 FF FF 10 60 00 03 AC 83 00 04 0? ?? ?? ?? 02 20 20 21 AC 80 00 08 00 00 00 0F C0 83 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 63 00 02 14 60 FF F5 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_182_0_0 {
	meta:
		name = "str_to_mpn.isra.0"
		size = 1044
		refs = "017c _tens_in_limb 01dc __mpn_mul_1 03b4 $LC2 03b8 $LC1 03cc __assert_fail 03bc __PRETTY_FUNCTION__.9581 03f4 $LC0"
	strings:
		$1 = { 27 BD FF C0 AF BE 00 38 AF B5 00 2C AF B3 00 24 AF B2 00 20 AF BF 00 3C AF B7 00 34 AF B6 00 30 AF B4 00 28 AF B1 00 1C AF B0 00 18 00 E0 F0 21 00 A0 90 21 8F B3 00 54 8F B5 00 58 18 A0 00 ED AC E0 00 00 3C 14 3B 9A 00 C0 B8 21 00 80 80 21 00 00 30 21 00 00 88 21 00 00 48 21 24 16 00 09 36 94 CA 00 82 02 00 00 24 44 FF D0 30 84 00 FF 2C 84 00 0A 14 80 00 08 00 40 18 21 12 A0 00 04 00 00 00 00 82 A3 00 00 10 62 00 17 00 00 00 00 02 13 80 21 82 03 00 00 00 11 10 40 00 11 88 C0 00 51 88 21 26 31 FF D0 26 52 FF FF 26 10 00 01 02 23 88 21 12 40 00 27 25 22 00 01 14 56 FF E9 00 40 48 21 14 C0 00 43 24 02 00 01 AE F1 00 00 AF C2 00 00 00 00 10 21 24 06 00 01 00 00 88 21 0? ?? ?? ?? 00 40 48 21 82 A2 00 01 10 40 00 AE 24 04 00 01 82 03 00 01 14 62 FF E5 24 03 00 01 0? ?? ?? ?? 24 63 00 01 02 03 40 21 81 08 00 00 15 02 FF DF 24 63 00 01 02 A3 10 21 80 42 00 00 14 40 FF F9 00 60 20 21 02 04 80 21 82 03 00 00 00 11 10 40 00 11 88 C0 00 51 88 21 26 31 FF D0 26 52 FF FF 26 10 00 01 02 23 88 21 16 40 FF DB 25 22 00 01 8F A4 00 50 8C 83 00 00 18 60 00 7B 8C 84 00 04 24 05 00 08 00 A9 48 23 00 09 2F C3 00 A3 38 2A 10 E0 00 43 00 00 00 00 3C 03 ?? ?? 00 02 10 80 24 63 ?? ?? 00 43 10 21 14 C0 00 4E 8C 47 00 00 24 02 00 01 AE F1 00 00 AF C2 00 00 8F BF 00 3C 02 00 10 21 8F BE 00 38 8F B7 00 34 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 40 02 E0 20 21 02 E0 28 21 0? ?? ?? ?? 02 80 38 21 8E E3 00 00 8F C4 00 00 02 23 88 21 02 23 18 2B 10 60 00 1B AE F1 00 00 0? ?? ?? ?? 26 E3 00 04 8C 65 FF FC 24 A5 00 01 14 A0 00 15 AC 65 FF FC 24 84 FF FF 14 80 FF FA 24 63 00 04 24 03 00 01 00 62 10 21 10 40 00 12 00 00 00 00 8F C3 00 00 28 64 00 73 10 80 00 66 00 03 18 80 02 E3 18 21 AC 62 00 00 8F C6 00 00 00 00 10 21 00 00 88 21 24 C6 00 01 AF C6 00 00 0? ?? ?? ?? 00 40 48 21 00 00 18 21 00 62 10 21 14 40 FF F0 00 00 00 00 8F C6 00 00 00 00 88 21 0? ?? ?? ?? 00 40 48 21 10 65 00 43 3C 03 ?? ?? 24 63 ?? ?? 00 04 28 80 00 A3 28 21 00 82 10 21 00 02 10 80 8F A4 00 50 8C A5 00 00 00 43 18 21 8C 67 00 00 00 00 10 21 00 00 18 21 72 25 88 02 AC 83 00 04 10 C0 FF B4 AC 82 00 00 02 E0 20 21 0? ?? ?? ?? 02 E0 28 21 8E E3 00 00 8F C4 00 00 02 23 88 21 02 23 18 2B 14 60 00 1F AE F1 00 00 00 00 18 21 00 62 10 21 10 40 FF AB 8F BF 00 3C 8F C3 00 00 28 64 00 73 10 80 00 2B 00 03 20 80 02 E4 B8 21 24 63 00 01 AF C3 00 00 8F B6 00 30 AE E2 00 00 8F BE 00 38 02 00 10 21 8F B7 00 34 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 40 14 60 FF 8B 00 00 00 00 14 80 FF 83 00 00 00 00 0? ?? ?? ?? 3C 03 ?? ?? 0? ?? ?? ?? 26 E3 00 04 8C 65 FF FC 24 A5 00 01 14 A0 FF DD AC 65 FF FC 24 84 FF FF 14 80 FF FA 24 63 00 04 24 63 FF FC 0? ?? ?? ?? 24 03 00 01 01 24 48 2B 15 20 FF 78 24 63 ?? ?? 0? ?? ?? ?? 00 00 00 00 02 04 80 21 0? ?? ?? ?? 82 03 00 00 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 01 B3 0? ?? ?? ?? 24 E7 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 01 7B 0? ?? ?? ?? 24 E7 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 01 6A 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_182_1_0 {
	meta:
		name = "round_and_return"
		size = 1352
		refs = "0000 __gnu_local_gp 0068 __libc_errno 0084 $LC5 0090 $LC6 0094 __muldf3 00f8 $LC3 0104 $LC4 018c __mpn_rshift 0238 __mpn_construct_double"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF C0 27 9C ?? ?? 28 C3 FF FF 00 C0 10 21 AF B3 00 2C AF B2 00 28 AF B1 00 24 AF B0 00 20 AF BF 00 3C AF B6 00 38 AF B5 00 34 AF B4 00 30 AF BC 00 10 00 80 80 21 8F B2 00 54 8F B3 00 58 14 60 00 21 8F B1 00 5C 24 04 FF FF 10 C4 00 1C 2C E4 FC 02 18 40 00 60 00 00 00 00 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 8F A4 00 50 00 62 10 21 24 03 00 22 AC 43 00 00 3C 02 ?? ?? 10 80 00 48 8C 45 ?? ?? 8C 44 ?? ?? 3C 02 ?? ?? 8C 47 ?? ?? 0? ?? ?? ?? 8C 46 ?? ?? 8F BF 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 40 10 80 FF E4 00 00 00 00 10 60 00 1A 24 03 FF FF 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 22 AC 43 00 00 8F A2 00 50 10 40 00 61 3C 02 ?? ?? 8C 45 ?? ?? 8C 44 ?? ?? 3C 02 ?? ?? 8C 47 ?? ?? 0? ?? ?? ?? 8C 46 ?? ?? 8F BF 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 40 10 43 00 4B 2C E2 FB CD 24 03 00 01 02 63 20 04 24 84 FF FF 00 92 20 24 00 04 20 2B 24 02 FC 02 02 24 88 25 00 47 10 23 24 04 00 35 10 44 00 53 28 44 00 20 10 80 00 92 00 00 00 00 10 43 00 BD 02 00 20 21 02 00 28 21 24 06 00 02 00 40 38 21 8E 12 00 00 0? ?? ?? ?? 24 53 FF FF 8E 14 00 00 8F BC 00 10 0? ?? ?? ?? 32 96 00 01 8C 44 ?? ?? 00 A0 38 21 0? ?? ?? ?? 00 80 30 21 8F BF 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 40 14 40 00 04 00 00 00 00 2C E3 04 01 10 60 FF 9D 00 00 00 00 8E 14 00 00 02 72 A8 06 32 B5 00 01 32 96 00 01 16 20 00 05 24 03 00 01 02 63 18 04 24 63 FF FF 00 72 90 24 00 12 18 2B 12 A0 00 06 00 E0 28 21 16 C0 00 3F 00 00 00 00 14 60 00 3E 26 83 00 01 00 E0 28 21 8F A6 00 50 0? ?? ?? ?? 02 00 20 21 8F BF 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 40 10 40 FF B6 24 03 00 01 0? ?? ?? ?? 00 00 00 00 8C 45 ?? ?? 8C 44 ?? ?? 00 A0 38 21 0? ?? ?? ?? 00 80 30 21 8F BF 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 40 8E 12 00 04 8E 02 00 00 AE 00 00 04 00 12 18 2B 00 02 10 2B 00 62 10 25 02 22 88 25 AE 00 00 00 00 00 B0 21 00 00 A0 21 24 13 00 14 02 72 A8 06 32 B5 00 01 16 A0 00 21 3C 02 ?? ?? 16 20 00 1F 00 00 00 00 24 02 00 01 02 62 10 04 24 42 FF FF 00 52 10 24 14 40 00 18 00 00 00 00 02 20 A8 21 24 02 FF FF 0? ?? ?? ?? 24 07 FC 01 26 83 00 01 00 74 A0 2B AE 03 00 00 12 80 00 03 8E 03 00 04 24 63 00 01 AE 03 00 04 7C 64 05 40 14 80 00 37 24 04 FF FF 14 44 FF BA 00 E0 28 21 24 02 FC 01 14 E2 FF B8 8F A6 00 50 7C 63 05 00 24 05 FC 02 0? ?? ?? ?? 00 E3 28 0A 3C 02 ?? ?? 7C 03 E8 3B 8C 45 ?? ?? 8C 44 ?? ?? 00 60 10 21 8F 83 ?? ?? 00 A0 38 21 00 80 30 21 00 62 10 21 24 03 00 22 0? ?? ?? ?? AC 43 00 00 AF A3 00 1C AF A2 00 18 8F A3 00 1C 8F A2 00 18 24 07 FC 01 0? ?? ?? ?? 24 02 FF FF 24 53 FF FF 00 13 21 43 00 04 28 80 02 05 28 21 8C B2 00 00 14 83 00 04 32 73 00 1F 8E 03 00 00 00 03 18 2B 02 23 88 25 24 03 00 01 02 63 18 04 24 63 FF FF 02 43 18 24 00 03 18 2B 02 00 20 21 26 05 00 04 24 06 00 01 30 47 00 1F 0? ?? ?? ?? 02 23 88 25 8E 14 00 00 8F BC 00 10 AE 00 00 04 0? ?? ?? ?? 32 96 00 01 24 F1 00 01 02 27 90 2B 02 00 20 21 02 00 28 21 24 06 00 02 24 07 00 01 0? ?? ?? ?? 02 42 90 21 8E 03 00 04 3C 02 00 10 8F BC 00 10 00 62 10 25 16 40 00 04 AE 02 00 04 24 02 04 01 12 22 FF 00 00 00 00 00 0? ?? ?? ?? 02 20 28 21 02 72 98 06 32 73 00 01 12 60 00 06 8E 12 00 00 32 55 00 01 16 A0 00 0D 26 43 00 01 16 20 00 0C 00 72 20 2B 02 00 20 21 02 00 28 21 24 06 00 02 0? ?? ?? ?? 00 40 38 21 8F BC 00 10 8E 14 00 00 00 00 98 21 0? ?? ?? ?? 32 96 00 01 00 72 20 2B 14 80 00 19 AF A3 00 18 26 04 00 04 24 06 00 02 27 A3 00 1C 10 64 00 05 24 05 00 02 14 C5 00 04 8F B3 00 1C 8C 84 00 00 AC 64 00 00 8F B3 00 1C 02 00 20 21 02 00 28 21 24 06 00 02 0? ?? ?? ?? 00 40 38 21 7E 62 05 40 10 40 FF E8 8F BC 00 10 8E 14 00 00 00 00 98 21 24 02 FF FF 32 96 00 01 0? ?? ?? ?? 24 07 FC 01 8E 03 00 04 00 00 98 21 24 63 00 01 10 60 FF EE AF A3 00 1C 26 04 00 08 24 06 00 01 0? ?? ?? ?? 27 A3 00 20 }
	condition:
		$1
}

rule file_182_2_0 {
	meta:
		name = "____strtod_l_internal"
		size = 10352
		refs = "0000 __gnu_local_gp 0058 strlen 02b8 _nl_C_locobj 05dc _fpioconst_pow10 0604 __tens 0624 memcpy 0684 __mpn_mul 07d0 __correctly_grouped_prefixmb 0808 $LC8 02e0 $LC14 0b24 __strncasecmp_l 0b40 $LC7 0be4 __divdi3 0c30 __moddi3 0d68 $LC12 0d90 $LC13 0dbc $LC9 0dd4 __mpn_lshift 1254 __mpn_cmp 15f8 __mpn_submul_1 1614 __mpn_add_n 1cfc $LC25 1d00 $LC1 1d14 __assert_fail 1d04 __PRETTY_FUNCTION__.9631 1d8c __mpn_rshift 2018 $LC10 2120 ____strtoull_l_internal 2148 $LC16 2224 $LC21 22cc __libc_errno 22e8 $LC3 22f8 $LC4 2300 __muldf3 2360 $LC5 2370 $LC6 23b8 $LC20 23d8 $LC19 23f8 $LC15 143c $LC28 2484 $LC11 24b0 $LC26 24e0 $LC27 1620 $LC29 2548 $LC23 2568 $LC24 2590 $LC18 25b0 $LC22 03d4 $LC17"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FB B8 27 9C ?? ?? 8C E2 00 04 AF BE 04 40 AF B6 04 38 AF B2 04 28 AF B1 04 24 AF BF 04 44 AF B7 04 3C AF B5 04 34 AF B4 04 30 AF B3 04 2C AF B0 04 20 AF BC 00 20 00 E0 B0 21 00 80 88 21 00 A0 90 21 00 00 F0 21 14 C0 08 46 AF A0 03 D8 8C 53 00 24 0? ?? ?? ?? 02 60 20 21 00 40 A0 21 10 40 09 07 8F BC 00 20 8E C3 00 34 00 00 28 21 00 00 20 21 AF A5 03 CC AF A4 03 C8 26 37 FF FF 26 F7 00 01 82 F0 00 00 00 10 10 40 00 62 10 21 94 42 00 00 30 42 00 20 14 40 FF FA 26 F7 00 01 26 F7 FF FF 24 02 00 2D 12 02 00 AB 02 E0 18 21 24 02 00 2B 12 02 01 E3 AF A0 03 E0 82 66 00 00 10 C0 00 0E 00 00 20 21 82 E2 00 00 14 46 00 74 00 00 10 21 0? ?? ?? ?? 24 42 00 01 02 E2 20 21 80 84 00 00 14 83 00 6E 24 42 00 01 02 62 18 21 80 63 00 00 14 60 FF F9 00 40 20 21 02 E4 20 21 90 82 00 00 24 42 FF D0 30 42 00 FF 2C 42 00 0A 10 40 00 64 26 02 FF D0 24 02 00 30 12 02 01 CC 8F A8 03 D8 8E C5 00 38 02 E0 48 21 2D 0D 00 01 11 A0 08 1D 24 0B 00 0A 26 07 FF D0 00 10 18 80 30 E2 00 FF 00 A3 18 21 2C 42 00 0A 14 40 00 15 8C 6C 00 00 24 02 00 10 11 62 01 FA 25 82 FF 9F 10 C0 00 0E 24 02 00 10 82 E2 00 00 14 46 01 8C 00 00 10 21 0? ?? ?? ?? 24 42 00 01 80 84 00 00 14 83 01 87 24 42 00 01 02 62 18 21 80 63 00 00 14 60 FF FA 02 E2 20 21 24 02 00 10 11 62 04 84 00 00 00 00 02 E0 A8 21 00 00 60 21 24 03 00 10 30 E2 00 FF 2C 42 00 0A 14 40 00 62 00 00 00 00 11 63 00 59 00 10 10 80 11 A0 09 59 8F AA 03 D8 17 C0 09 30 01 35 10 2B 2D 8D 00 01 10 C0 00 0D 00 0D F0 23 82 A2 00 00 14 46 00 60 00 00 10 21 0? ?? ?? ?? 24 42 00 01 80 84 00 00 14 83 00 5B 24 42 00 01 02 62 18 21 80 63 00 00 14 60 FF FA 02 A2 20 21 02 B4 30 21 80 C2 00 00 00 C0 A8 21 01 86 20 23 24 43 FF D0 30 63 00 FF 2C 63 00 0A 24 0E 00 10 24 07 00 30 14 60 00 14 02 A4 48 21 15 6E 02 B3 00 02 10 80 00 A2 10 21 8C 42 00 00 24 43 FF 9F 30 63 00 FF 2C 63 00 06 10 60 02 41 7C 02 14 20 02 A6 10 23 00 1E 18 27 26 B5 00 01 00 43 F0 0A 82 A2 00 00 24 43 FF D0 30 63 00 FF 2C 63 00 0A 10 60 FF EE 02 A4 48 21 14 47 FF F5 00 00 00 00 26 B5 00 01 0? ?? ?? ?? 82 A2 00 00 26 02 FF D0 30 42 00 FF 2C 42 00 0A 14 40 FF 9B 24 02 00 30 3C 14 ?? ?? 26 94 ?? ?? 8E 82 00 38 00 10 80 80 24 03 00 69 00 50 10 21 80 42 00 03 10 43 02 A4 24 03 00 6E 10 43 02 0E 3C 05 ?? ?? 12 40 00 02 00 00 20 21 AE 51 00 00 00 00 28 21 8F BF 04 44 8F BE 04 40 8F B7 04 3C 8F B6 04 38 8F B5 04 34 8F B4 04 30 8F B3 04 2C 8F B2 04 28 8F B1 04 24 8F B0 04 20 00 80 10 21 00 A0 18 21 03 E0 00 08 27 BD 04 48 00 A2 10 21 8C 42 00 00 24 42 FF 9F 30 42 00 FF 2C 42 00 06 10 40 FF A2 00 00 00 00 25 8C 00 01 82 B0 00 01 26 B5 00 01 0? ?? ?? ?? 26 07 FF D0 24 08 00 01 26 F7 00 01 80 70 00 01 0? ?? ?? ?? AF A8 03 E0 00 10 80 80 00 B0 28 21 24 03 00 10 80 A2 00 03 11 63 01 F9 01 80 48 21 24 03 00 65 10 43 01 F9 02 A0 28 21 01 89 10 2B 10 40 00 0F 24 02 00 30 80 A3 FF FF 14 62 00 09 00 A0 10 21 24 06 00 30 24 42 FF FF 80 43 FF FF 00 49 20 21 10 66 FF FC 00 85 20 23 00 80 48 21 00 40 28 21 01 2C 10 2B 14 40 08 D1 3C 04 ?? ?? 11 89 01 32 00 00 00 00 12 40 00 02 00 00 00 00 AE 55 00 00 11 20 01 03 8F A8 03 E0 13 C0 00 30 24 02 00 10 82 65 00 00 82 E2 00 00 10 A2 00 05 82 66 00 01 82 E2 00 01 26 F7 00 01 14 A2 FF FD 00 00 00 00 10 C0 00 0F 24 02 00 10 82 E2 00 01 14 46 FF F9 00 00 00 00 0? ?? ?? ?? 24 02 00 01 80 84 00 00 14 83 01 C7 00 00 00 00 24 42 00 01 02 62 18 21 80 63 00 00 14 60 FF F9 02 E2 20 21 24 02 00 10 11 62 05 F4 8F A2 03 C8 8F A3 03 CC 3C 05 80 00 00 45 28 21 00 60 20 21 10 A0 08 44 00 9E 20 2B 24 04 00 10 11 64 06 2B 00 1E 2F 82 03 C0 20 21 00 00 28 21 00 64 20 23 00 64 18 2B 00 45 10 23 03 D4 30 21 00 43 10 23 02 E6 B8 21 AF A2 03 C8 AF A4 03 CC 01 3E 48 23 24 02 00 10 11 62 01 29 8F A3 03 C8 04 61 02 1B 8F A5 03 CC 00 0C 20 23 00 04 10 2B 00 02 10 23 00 43 30 2A 14 C0 02 20 00 00 00 00 10 62 04 F0 00 85 30 2B 24 07 01 35 01 84 B0 21 00 F6 30 23 00 A4 20 23 00 A4 28 2B 00 62 10 23 00 E6 38 2B 00 45 10 23 00 07 18 23 00 62 28 2A AF A2 03 C8 14 A0 08 46 AF A4 03 CC 10 43 08 41 28 43 FF FF 14 60 08 2D 24 03 FF FF 10 43 08 28 00 00 00 00 16 C0 02 D6 00 00 98 21 02 C9 10 2B 10 40 08 1B 8F B0 03 CC 8F A2 03 C8 26 03 01 43 00 70 20 2B 00 82 20 21 14 80 08 15 2C 63 01 44 10 60 08 13 00 00 00 00 1A 60 05 C3 00 00 00 00 12 C0 07 F5 00 50 10 25 14 40 07 F3 24 02 00 36 00 53 10 23 00 00 50 21 01 36 18 23 01 23 20 2B AF A3 03 E4 00 04 20 23 00 02 1F C3 00 83 28 2A 14 A0 02 26 00 00 00 00 10 64 02 21 8F A8 03 E4 02 C2 10 21 00 56 20 2B 00 83 18 21 04 60 02 17 00 00 00 00 10 60 02 12 00 00 00 00 AF A0 03 FC 8F A8 03 E4 27 B2 01 F4 27 B1 00 28 3C 09 ?? ?? 01 0A 50 23 25 29 ?? ?? 02 40 A8 21 02 20 B0 21 24 1E 00 01 0? ?? ?? ?? 00 00 80 21 8D 30 00 04 24 A5 00 02 3C 02 ?? ?? 24 42 ?? ?? 26 10 FF FE 00 05 28 80 02 C0 20 21 00 45 28 21 00 10 30 80 AF A9 04 1C 0? ?? ?? ?? AF AA 04 04 8F A9 04 1C 8F AA 04 04 00 1E F0 40 11 40 00 21 25 29 00 10 01 5E 10 24 10 40 FF FB 00 00 00 00 01 5E 50 26 12 00 FF EA 8D 25 00 00 8D 26 00 04 24 A5 00 02 3C 03 ?? ?? 24 63 ?? ?? 00 05 28 80 AF B0 00 10 02 A0 20 21 00 65 28 21 24 C6 FF FE 02 C0 38 21 AF A9 04 1C 0? ?? ?? ?? AF AA 04 04 8F A9 04 1C 8F AA 04 04 8D 24 00 04 24 84 FF FE 14 40 01 A0 02 04 80 21 02 C0 10 21 26 10 FF FF 02 A0 B0 21 00 1E F0 40 00 40 A8 21 15 40 FF E1 25 29 00 10 12 D2 06 50 02 20 20 21 8F AA 03 D8 8F A5 03 E4 26 08 FF FF 27 A2 03 C8 00 08 18 80 AF B4 00 14 AF A2 00 10 AF AA 00 18 02 E0 20 21 02 40 30 21 27 A7 03 D0 AF A8 03 DC 0? ?? ?? ?? AF A3 04 00 8F A8 04 00 02 28 10 21 8C 54 00 00 72 94 A0 20 1E 80 01 AE 02 20 20 21 8F A6 03 D0 00 13 1F C3 24 02 00 01 AF A3 03 C8 12 02 01 C7 AF B3 03 CC 24 02 00 02 16 02 02 BD 8F AA 04 00 28 C6 00 02 8F B5 00 28 10 C0 03 DE 8F B2 00 2C 8F B0 01 F4 02 12 10 2B 10 40 03 DC 00 00 B0 21 1A 60 07 38 2A 62 00 16 10 40 07 2C 24 17 00 35 8F A2 03 C0 00 00 B8 21 AF A0 03 C0 AF A2 03 C4 27 B4 03 C0 26 73 00 20 02 00 B0 21 2A 62 00 36 14 40 03 D0 00 00 80 21 8F A3 03 C8 8F A2 03 CC 0? ?? ?? ?? 00 00 88 21 24 02 00 10 11 62 05 29 7C 0C 64 20 24 02 00 65 11 82 FE 7D 02 E0 A8 21 8F A6 03 D8 01 20 20 21 02 E0 28 21 03 C0 38 21 AF A9 04 1C 0? ?? ?? ?? AF AB 04 14 8F A9 04 1C 12 40 00 06 8F AB 04 14 15 22 00 03 39 6B 00 10 26 E2 FF FF 02 2B 10 0B AE 42 00 00 8F A8 03 E0 11 00 FE BC 00 00 20 21 3C 02 ?? ?? 8C 45 ?? ?? 8F BF 04 44 8C 44 ?? ?? 8F BE 04 40 8F B7 04 3C 8F B6 04 38 8F B5 04 34 8F B4 04 30 8F B3 04 2C 8F B2 04 28 8F B1 04 24 8F B0 04 20 00 80 10 21 00 A0 18 21 03 E0 00 08 27 BD 04 48 82 F0 00 01 0? ?? ?? ?? 26 F7 00 01 82 E3 00 01 8E C5 00 38 00 03 18 80 00 A3 18 21 8C 64 00 00 24 03 00 78 10 83 01 FB 02 E0 48 21 2D 0D 00 01 11 A0 06 4B 24 0B 00 0A 01 20 B8 21 24 02 00 30 26 F7 00 01 82 F0 00 00 12 02 FF FE 26 F7 00 01 26 F7 FF FF 0? ?? ?? ?? 26 07 FF D0 11 80 FE CE 8F A2 03 C8 04 41 01 E9 24 03 00 01 24 04 00 04 39 67 00 10 24 A5 FF FF 24 06 00 10 00 67 20 0B 01 80 48 21 24 0E 00 30 11 66 00 16 80 A3 00 00 24 63 FF D0 2C 63 00 0A 38 63 00 01 14 60 00 0E 00 00 00 00 80 A3 00 00 14 6E FE BB 8F A3 03 CC 25 29 FF FF 25 8C FF FF 00 83 18 21 00 64 38 2B 00 E2 10 21 AF A2 03 C8 11 20 FE B3 AF A3 03 CC 04 41 FE B1 00 00 00 00 24 A5 FF FF 15 66 FF EC 80 A3 00 00 8E C7 00 34 00 03 18 40 00 E3 18 21 94 63 00 00 38 63 00 10 0? ?? ?? ?? 7C 63 01 00 30 42 00 FF 2C 42 00 06 10 40 FE 04 02 E0 A8 21 0? ?? ?? ?? 00 00 60 21 82 E2 00 00 0? ?? ?? ?? 8E C8 00 34 82 E2 00 00 00 02 18 40 01 03 18 21 94 63 00 00 30 63 00 10 10 60 FF FA 26 F7 00 01 24 03 00 30 14 43 00 06 26 F7 FF FF 26 F7 00 01 82 E2 00 00 10 43 FF FE 26 F7 00 01 26 F7 FF FF 24 43 FF D0 2C 64 00 0A 14 80 02 7D 00 00 00 00 8E C3 00 38 00 02 10 80 26 F7 00 01 00 62 10 21 8C 42 00 00 24 42 FF A9 3C 03 ?? ?? 00 02 20 80 24 63 ?? ?? 00 83 18 21 8C 63 00 00 10 60 06 7C 24 04 00 15 00 83 20 23 8F A5 03 C8 00 82 10 04 AF A2 03 C4 24 02 00 14 00 43 10 23 04 A1 04 40 8F A6 03 CC 00 03 58 27 3C 0D 7F FF 25 64 00 01 00 03 3F C3 35 AD FF FF 00 8B 58 2B 01 A7 38 23 01 67 38 21 00 07 5F 80 00 04 20 82 01 64 20 25 00 07 38 83 10 E0 06 5D 00 8C 20 2B 25 87 FF FF 00 EC 20 2B 24 84 FF FF 24 63 FF FF 00 07 67 82 00 04 20 80 00 07 38 80 00 67 38 21 00 03 5F C3 01 84 20 25 00 E3 18 2B 01 64 20 21 00 C7 38 21 00 64 18 21 00 A3 28 21 00 E6 30 2B 00 C5 30 21 AF A6 03 C8 AF A7 03 CC 24 05 00 01 24 0D 00 03 25 23 FF FF 10 60 04 0D 00 00 00 00 82 E4 00 00 00 04 58 40 01 0B 58 21 95 6B 00 00 31 6B 00 10 15 60 00 04 00 80 60 21 02 F4 B8 21 82 EC 00 00 01 80 20 21 24 8B FF D0 2D 6B 00 0A 11 60 03 96 00 04 20 80 26 F7 00 01 25 84 FF D0 28 4B 00 03 15 60 03 82 27 AA 00 28 00 05 48 80 01 49 48 21 8D 2B 03 98 24 4C FF FD 01 84 20 04 00 8B 20 25 AD 24 03 98 24 42 FF FC 0? ?? ?? ?? 00 60 48 21 02 E0 20 21 24 A5 ?? ?? 24 06 00 03 0? ?? ?? ?? 02 80 38 21 14 40 FD ED 24 02 00 28 82 E3 00 03 10 62 05 5E 26 E6 00 03 3C 02 ?? ?? 8C 44 ?? ?? 8C 45 ?? ?? 12 40 FD EA 8F BF 04 44 0? ?? ?? ?? AE 46 00 00 00 C0 10 21 0? ?? ?? ?? 26 F7 00 01 24 03 00 70 14 43 FE 09 02 A0 28 21 82 AF 00 01 24 02 00 2D 11 E2 04 67 24 02 00 2B 11 E2 04 99 26 AE 00 02 26 AE 00 01 AF A0 03 DC 25 EF FF D0 31 E2 00 FF 2C 42 00 0A 10 40 FD FC 02 A0 28 21 24 02 00 10 11 62 04 B7 8F A8 03 DC 11 00 02 11 25 82 01 68 00 4C 80 2B 00 40 88 21 02 20 28 21 02 00 20 21 24 07 00 0A 00 00 30 21 AF A9 04 1C AF AB 04 14 AF AC 04 10 AF AE 04 18 0? ?? ?? ?? AF AF 04 0C 8F A9 04 1C 8F AB 04 14 8F AC 04 10 8F AE 04 18 8F AF 04 0C 00 40 C0 21 00 60 C8 21 02 00 20 21 02 20 28 21 24 07 00 0A 00 00 30 21 AF A9 04 1C AF AB 04 14 AF AC 04 10 AF AE 04 18 AF AF 04 0C AF B8 04 04 0? ?? ?? ?? AF B9 04 08 00 40 38 21 8F BC 00 20 8F A4 03 C8 8F A5 03 CC 00 60 80 21 8F B9 04 08 8F B8 04 04 8F AF 04 0C 8F AE 04 18 8F AC 04 10 8F AB 04 14 8F A9 04 1C 03 04 10 2A 14 40 05 92 00 00 00 00 10 98 06 16 03 25 10 2B 13 04 05 84 00 0F 37 C3 00 05 17 C2 00 04 20 40 00 05 18 40 00 44 20 25 00 03 8F 82 00 04 10 80 00 05 28 C0 00 65 28 21 02 22 10 25 00 82 10 21 00 A3 18 2B 00 AF 88 21 00 62 10 21 00 46 30 21 02 25 20 2B 00 86 20 21 AF A4 03 C8 AF B1 03 CC 25 CE 00 01 81 CF 00 00 25 EF FF D0 31 E2 00 FF 2C 42 00 0A 14 40 FF E1 02 20 28 21 8F AA 03 DC 11 40 04 64 00 11 88 23 00 11 10 2B 00 04 20 23 00 82 10 23 02 A0 28 21 AF A2 03 C8 AF B1 03 CC 0? ?? ?? ?? 01 C0 A8 21 00 A2 28 21 0? ?? ?? ?? 80 A2 00 03 02 C0 10 21 02 A0 B0 21 0? ?? ?? ?? 00 40 A8 21 01 2C 20 23 01 24 10 2B 00 02 10 23 00 62 30 2A 14 C0 00 06 00 00 00 00 14 43 FD E8 24 07 01 35 00 A4 30 2B 10 C0 FD E6 01 84 B0 21 00 60 10 21 0? ?? ?? ?? 00 A0 20 21 3C 05 ?? ?? 02 E0 20 21 24 A5 ?? ?? 24 06 00 03 0? ?? ?? ?? 02 80 38 21 14 40 FD 58 00 00 00 00 12 40 00 0A 26 F0 00 03 3C 05 ?? ?? 02 00 20 21 24 A5 ?? ?? 24 06 00 05 0? ?? ?? ?? 02 80 38 21 26 F7 00 08 02 E2 80 0A AE 50 00 00 8F AA 03 E0 15 40 04 97 3C 02 ?? ?? 8C 44 ?? ?? 0? ?? ?? ?? 8C 45 ?? ?? 02 20 28 21 02 00 30 21 0? ?? ?? ?? 02 80 38 21 8F A6 03 D0 02 40 20 21 02 40 28 21 0? ?? ?? ?? 02 80 38 21 10 40 FE 4A 8F A6 03 D0 00 06 18 80 02 23 18 21 24 C6 00 01 AF A6 03 D0 0? ?? ?? ?? AC 62 01 CC 00 49 48 2B 11 20 FD ED 00 00 00 00 24 03 00 01 00 56 10 23 AF A3 03 FC 0? ?? ?? ?? AF A2 03 E4 01 02 20 2B 10 80 FD DE 00 00 00 00 8F A2 03 E4 0? ?? ?? ?? 00 02 1F C3 8F B1 01 F4 14 D0 05 98 8F A7 00 28 02 27 10 2B 00 07 24 02 30 E9 FF FF 10 40 05 93 24 0B 00 20 02 24 00 1B 00 80 01 F4 00 00 88 12 00 00 18 10 00 03 1C 00 00 00 30 12 72 29 28 02 00 65 10 2B 10 40 00 0A 00 00 00 00 00 67 18 21 00 67 10 2B 14 40 00 06 26 26 FF FF 00 65 10 2B 10 40 00 03 00 00 00 00 26 26 FF FE 00 67 18 21 00 65 18 23 00 64 00 1B 00 80 01 F4 00 00 18 12 00 00 10 10 00 02 14 00 00 00 28 12 70 69 88 02 00 51 50 2B 11 40 00 0A 00 00 00 00 00 47 10 21 00 47 50 2B 15 40 00 06 24 65 FF FF 00 51 50 2B 11 40 00 03 00 00 00 00 24 65 FF FE 00 47 10 21 00 06 34 00 00 51 88 23 16 60 00 29 00 A6 80 25 12 00 00 2F 8F A3 03 CC 72 12 90 20 8F A2 03 C8 00 72 28 23 00 65 18 2B 01 72 40 23 00 43 10 23 29 06 00 36 AF A2 03 C8 00 A0 18 21 14 C0 00 2D AF A5 03 CC 24 03 FF EB 00 72 18 23 00 70 18 06 AF A3 03 C0 26 52 00 35 00 A0 18 21 27 B4 03 C0 8F A8 03 FC 8F AA 03 E0 24 05 00 1F 24 67 FF FF 00 11 88 2B 24 04 00 01 00 B2 90 23 02 28 20 0A 00 E3 18 2B 24 46 FF FF AF A4 00 1C AF AA 00 10 02 80 20 21 AF B0 00 14 AF B2 00 18 0? ?? ?? ?? 00 66 30 21 00 40 20 21 0? ?? ?? ?? 00 60 28 21 2A 62 00 16 10 40 00 15 24 12 00 35 8F A2 03 C0 26 73 00 20 AF B0 03 C0 0? ?? ?? ?? AF A2 03 C4 8F A2 03 C8 24 65 FF E0 00 A3 18 2B 24 42 FF FF 00 62 10 21 00 00 40 21 00 A0 18 21 AF A2 03 C8 AF A5 03 CC 29 05 00 36 AF A0 03 C4 }
	condition:
		$1
}

rule file_183_0_0 {
	meta:
		name = "__xpg_basename"
		size = 284
		refs = "0020 strrchr 00ac $LC0"
	strings:
		$1 = { 27 BD FF E0 AF B0 00 18 AF BF 00 1C 10 80 00 26 00 80 80 21 80 82 00 00 10 40 00 24 8F BF 00 1C 0? ?? ?? ?? 24 05 00 2F 10 40 00 25 00 40 18 21 80 44 00 01 14 80 00 18 24 42 00 01 02 03 10 2B 10 40 00 15 00 60 10 21 80 64 FF FF 24 02 00 2F 14 82 00 1D 24 05 00 2F 0? ?? ?? ?? 24 62 FF FF 80 44 FF FF 14 85 00 19 00 40 18 21 24 62 FF FF 14 50 FF FB 00 00 00 00 80 63 00 00 10 60 00 07 8F BF 00 1C 24 42 00 01 80 43 00 01 14 60 FF FE 24 42 00 01 24 42 FF FF 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 8F BF 00 1C 3C 02 ?? ?? 8F B0 00 18 24 42 ?? ?? 03 E0 00 08 27 BD 00 20 0? ?? ?? ?? 02 00 10 21 00 60 10 21 24 43 FF FF 02 03 20 2B 10 80 00 0F A0 40 00 00 80 44 FF FE 24 02 00 2F 10 82 00 0B 24 04 00 2F 0? ?? ?? ?? 00 60 10 21 80 43 FF FF 10 64 FF E8 00 00 00 00 24 42 FF FF 14 50 FF FB 8F BF 00 1C 0? ?? ?? ?? 8F B0 00 18 0? ?? ?? ?? 00 60 10 21 }
	condition:
		$1
}

rule file_184_0_0 {
	meta:
		name = "__ppoll_chk"
		size = 44
		refs = "001c ppoll 0024 __chk_fail"
	strings:
		$1 = { 27 BD FF E0 8F A2 00 30 00 02 10 C2 00 45 10 2B 14 40 00 04 AF BF 00 1C 8F BF 00 1C 0? ?? ?? ?? 27 BD 00 20 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_185_0_0 {
	meta:
		name = "execl"
		size = 372
		refs = "00a4 __environ 00b0 __execve 00c0 free 0104 realloc 015c memcpy"
	strings:
		$1 = { 27 BD EF B8 AF B1 10 28 27 B1 10 50 AF BF 10 44 AF B7 10 40 AF B6 10 3C AF B5 10 38 AF B4 10 34 AF B3 10 30 AF B2 10 2C AF B0 10 24 AF A6 10 50 AF A7 10 54 AF A5 00 18 10 A0 00 38 AF B1 10 18 26 31 00 04 24 10 00 01 27 B5 00 18 8E 23 FF FC 00 10 B8 80 02 A0 98 21 02 77 38 21 00 80 B0 21 24 12 00 10 24 14 04 00 AC E3 00 00 AF B1 10 18 10 60 00 0C 26 10 00 01 12 90 00 1F 02 60 20 21 26 52 00 08 26 31 00 04 8E 23 FF FC 00 10 B8 80 02 77 38 21 AC E3 00 00 AF B1 10 18 14 60 FF F6 26 10 00 01 3C 02 ?? ?? 8C 46 ?? ?? 02 C0 20 21 0? ?? ?? ?? 02 60 28 21 12 B3 00 04 00 40 80 21 0? ?? ?? ?? 02 60 20 21 02 00 10 21 8F BF 10 44 8F B7 10 40 8F B6 10 3C 8F B5 10 38 8F B4 10 34 8F B3 10 30 8F B2 10 2C 8F B1 10 28 8F B0 10 24 03 E0 00 08 27 BD 10 48 02 40 28 21 12 B3 00 11 00 14 A0 40 0? ?? ?? ?? 00 00 00 00 10 40 00 09 26 52 00 08 0? ?? ?? ?? 00 40 98 21 3C 02 ?? ?? 8C 46 ?? ?? 0? ?? ?? ?? 27 A5 00 18 0? ?? ?? ?? 8F BF 10 44 0? ?? ?? ?? 02 60 20 21 0? ?? ?? ?? 24 02 FF FF 0? ?? ?? ?? 00 00 20 21 10 40 00 07 00 40 98 21 02 60 20 21 02 A0 28 21 0? ?? ?? ?? 26 E6 00 04 0? ?? ?? ?? 26 52 00 08 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_186_0_0 {
	meta:
		name = "_rpc_dtablesize"
		size = 52
		refs = "0018 __getdtablesize"
	strings:
		$1 = { 27 BD FF E0 AF B0 00 18 3C 10 ?? ?? 8E 02 ?? ?? 14 40 00 04 AF BF 00 1C 0? ?? ?? ?? 00 00 00 00 AE 02 ?? ?? 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_187_0_0 {
	meta:
		name = "__mpn_mod_1"
		size = 1552
	strings:
		$1 = { 10 A0 01 2A 00 00 10 21 00 05 10 80 00 05 19 40 00 43 10 21 00 45 10 21 00 02 10 40 28 42 00 65 14 40 00 71 70 D8 C0 20 70 C2 10 20 10 40 00 D1 00 46 40 04 00 08 18 40 10 60 00 24 24 0E FF FF 00 08 30 23 00 08 1C 02 00 C3 00 1B 00 60 01 F4 31 09 FF FF 00 00 50 12 00 00 30 10 00 06 34 00 00 00 70 12 71 49 38 02 00 C7 58 2B 11 60 00 0A 00 00 00 00 00 C8 30 21 00 C8 58 2B 15 60 00 06 25 4E FF FF 00 C7 58 2B 11 60 00 03 00 00 00 00 25 4E FF FE 00 C8 30 21 00 C7 30 23 00 C3 00 1B 00 60 01 F4 00 00 30 12 00 00 18 10 00 03 54 00 00 00 38 12 70 C9 48 02 01 49 18 2B 14 60 01 3A 00 00 00 00 00 0E 74 00 00 EE 70 25 00 05 18 80 24 63 FF FC 00 83 30 21 8C CC 00 00 24 0F 00 20 01 E2 78 23 28 A6 00 02 14 C0 01 42 01 EC 48 06 00 05 C0 23 00 18 C0 80 24 63 00 04 27 18 00 04 00 83 20 21 0? ?? ?? ?? 00 00 28 21 00 60 48 21 01 2E 00 19 00 85 18 21 8C 6A FF F8 00 4C 60 04 24 A5 FF FC 01 EA 58 06 01 6C 58 25 01 40 60 21 00 00 30 10 01 26 30 21 00 C8 00 19 00 00 38 12 01 67 18 23 00 68 38 23 00 00 30 10 01 26 30 23 01 63 58 2B 00 67 68 2B 00 CB 30 23 00 E8 48 23 10 C0 00 03 00 CD 68 26 00 E0 18 21 01 2D 18 0B 00 68 38 2B 00 68 30 23 14 B8 FF E4 00 C7 18 0A 00 6E 00 19 00 4A 50 04 00 00 20 10 00 64 20 21 00 88 00 19 00 00 28 12 01 45 C0 23 01 58 50 2B 00 00 20 10 00 64 20 23 00 8A 50 23 11 40 00 08 03 08 18 2B 03 08 18 23 03 03 C0 2B 01 58 C0 26 00 68 20 23 00 98 18 0B 00 60 C0 21 03 08 18 2B 03 08 40 23 01 03 C0 0A 03 E0 00 08 00 58 10 06 03 E0 00 08 00 60 10 21 13 00 00 B2 00 05 38 80 24 E7 FF FC 00 87 10 21 8C 4E 00 00 24 02 00 20 00 58 10 23 28 A8 00 02 03 06 30 04 15 00 00 FC 00 4E 18 06 00 05 C8 23 24 E8 00 04 00 19 C8 80 00 88 20 21 00 06 3C 02 30 CD FF FF 27 39 00 04 00 00 40 21 00 67 00 1B 00 E0 01 F4 00 88 58 21 8D 6B FF F8 03 0E 70 04 25 08 FF FC 00 4B 60 06 01 8E 60 25 00 0C 2C 02 01 60 70 21 00 00 18 12 00 00 78 10 70 6D 50 02 00 0F 1C 00 00 A3 28 25 00 AA 48 2B 11 20 00 07 31 8C FF FF 00 A6 28 21 00 A6 18 2B 00 AA 78 2B 14 60 00 02 00 A6 48 21 01 2F 28 0B 00 AA 28 23 00 A7 00 1B 00 E0 01 F4 00 00 28 12 00 00 18 10 00 03 1C 00 00 6C 18 25 70 AD 48 02 00 69 50 2B 11 40 00 07 00 00 00 00 00 66 18 21 00 66 28 2B 00 69 60 2B 14 A0 00 02 00 66 50 21 01 4C 18 0B 15 19 FF D6 00 69 18 23 00 67 00 1B 00 E0 01 F4 03 0B 58 04 00 0B 14 02 00 00 18 12 00 00 40 10 70 6D 20 02 00 08 1C 00 00 43 10 25 00 44 18 2B 10 60 00 05 00 00 00 00 00 46 10 21 00 46 18 2B 10 60 00 B3 00 44 28 2B 00 44 10 23 00 47 00 1B 00 E0 01 F4 31 6B FF FF 00 00 10 12 00 00 28 10 70 4D 68 02 00 05 14 00 00 4B 58 25 01 6D 10 2B 10 40 00 08 01 6D 10 23 01 66 58 21 01 66 10 2B 14 40 00 03 01 66 30 21 01 6D 10 2B 00 C2 58 0B 01 6D 10 23 03 E0 00 08 03 02 10 06 00 06 10 40 10 40 00 24 24 0B FF FF 00 06 18 23 00 06 14 02 00 62 00 1B 00 40 01 F4 30 C8 FF FF 00 00 48 12 00 00 18 10 00 03 1C 00 00 00 58 12 71 28 38 02 00 67 50 2B 11 40 00 0A 00 00 00 00 00 66 18 21 00 66 50 2B 15 40 00 06 25 2B FF FF 00 67 50 2B 11 40 00 03 00 00 00 00 25 2B FF FE 00 66 18 21 00 67 18 23 00 62 00 1B 00 40 01 F4 00 00 18 12 00 00 10 10 00 02 4C 00 00 00 38 12 70 68 40 02 01 28 10 2B 14 40 00 72 00 00 00 00 00 0B 5C 00 00 EB 58 25 24 A2 FF FF 00 02 18 80 00 83 18 21 8C 63 00 00 00 66 38 2B 10 E0 00 5D 00 00 00 00 24 A2 FF FE 04 40 FF 6C 00 02 60 27 00 02 10 80 00 0C 60 80 00 82 20 21 0? ?? ?? ?? 00 00 28 21 00 40 18 21 00 6B 00 19 00 85 10 21 8C 4A 00 00 24 A5 FF FC 00 00 40 10 00 68 40 21 01 06 00 19 00 00 48 12 01 49 10 23 00 46 38 23 00 00 40 10 00 68 18 23 01 42 50 2B 00 47 48 2B 00 6A 18 23 00 E6 40 23 10 60 00 03 00 69 48 26 00 E0 10 21 01 09 10 0B 00 46 38 2B 00 46 18 23 14 AC FF E8 00 67 10 0A 03 E0 00 08 00 00 00 00 24 A3 FF FF 00 03 10 80 00 82 10 21 8C 42 00 00 00 46 38 2B 10 E0 00 35 00 00 00 00 24 A3 FF FE 04 60 FF F5 00 03 68 27 00 03 18 80 00 06 3C 02 30 CB FF FF 00 0D 68 80 00 83 20 21 00 00 28 21 00 47 00 1B 00 E0 01 F4 00 85 50 21 8D 4A 00 00 24 A5 FF FC 00 0A 1C 02 00 00 10 12 00 00 60 10 70 4B 48 02 00 0C 14 00 00 62 18 25 00 69 10 2B 10 40 00 07 31 4A FF FF 00 66 18 21 00 66 10 2B 00 69 60 2B 14 40 00 02 00 66 40 21 01 0C 18 0B 00 69 18 23 00 67 00 1B 00 E0 01 F4 00 00 18 12 00 00 10 10 00 02 14 00 00 4A 10 25 70 6B 40 02 00 48 18 2B 10 60 00 07 00 00 00 00 00 46 10 21 00 46 18 2B 00 48 50 2B 14 60 00 02 00 46 48 21 01 2A 10 0B 14 AD FF DA 00 48 10 23 03 E0 00 08 00 00 00 00 0? ?? ?? ?? 00 00 18 21 0? ?? ?? ?? 00 00 10 21 01 48 50 21 01 48 18 2B 14 60 FE C4 24 C7 FF FF 01 49 48 2B 24 C6 FF FE 0? ?? ?? ?? 00 C9 38 0B 01 26 48 21 01 26 10 2B 14 40 FF 8C 24 67 FF FF 01 28 40 2B 24 63 FF FE 0? ?? ?? ?? 00 68 38 0B 00 46 18 21 0? ?? ?? ?? 00 65 10 0B 01 20 18 21 0? ?? ?? ?? 01 80 50 21 00 06 3C 02 30 CD FF FF 0? ?? ?? ?? 01 C0 58 21 }
	condition:
		$1
}

rule file_188_0_0 {
	meta:
		name = "fputc"
		size = 452
		refs = "006c __lll_lock_wait_private 013c __overflow 0170 _Unwind_Resume"
		altNames = "_IO_putc"
	strings:
		$1 = { 8C A2 00 00 27 BD FF D0 AF B2 00 28 30 42 80 00 AF B0 00 20 AF BF 00 2C AF B1 00 24 00 A0 80 21 14 40 00 1A 00 80 90 21 7C 03 E8 3B 8C A4 00 48 24 71 8B 70 8C 83 00 08 10 71 00 11 00 00 00 00 AF A0 00 18 C0 85 00 00 14 A0 00 06 24 03 00 00 24 01 00 01 E0 81 00 00 10 20 FF FA 24 03 00 01 00 00 00 0F 14 60 00 03 00 00 00 00 0? ?? ?? ?? AF A5 00 18 8E 03 00 48 00 60 20 21 AC 71 00 08 8C 83 00 04 24 63 00 01 AC 83 00 04 8E 03 00 14 8E 02 00 18 00 62 10 2B 10 40 00 27 24 62 00 01 AE 02 00 14 32 51 00 FF A0 72 00 00 8E 02 00 00 30 42 80 00 14 40 00 07 8F BF 00 2C 8E 04 00 48 8C 82 00 04 24 42 FF FF 10 40 00 08 AC 82 00 04 8F BF 00 2C 02 20 10 21 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 30 AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF F0 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 2C 02 00 20 21 0? ?? ?? ?? 32 45 00 FF 0? ?? ?? ?? 00 40 88 21 8E 02 00 00 30 42 80 00 14 40 00 06 00 80 88 21 8E 04 00 48 8C 83 00 04 24 63 FF FF 10 60 00 03 AC 83 00 04 0? ?? ?? ?? 02 20 20 21 AC 80 00 08 00 00 00 0F C0 83 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 63 00 02 14 60 FF F5 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_189_0_0 {
	meta:
		name = "__finite"
		size = 20
	strings:
		$1 = { 7C 84 F0 00 3C 02 80 10 00 82 10 21 03 E0 00 08 00 02 17 C2 }
	condition:
		$1
}

rule file_191_0_0 {
	meta:
		name = "_nl_intern_locale_data"
		size = 996
		refs = "0000 __gnu_local_gp 0094 malloc 0194 free 01a8 __libc_errno 01cc $LC10 01d0 $LC1 01e0 __assert_fail 0154 __PRETTY_FUNCTION__.8345 01f4 $LC9 021c $LC8 0244 $LC7 026c $LC6 0294 $LC5 02bc $LC4 02e4 $LC3 030c $LC2 0334 $LC0 038c $LC11 03c8 $LC12"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF D0 27 9C ?? ?? 2C C2 00 08 AF B3 00 24 AF BF 00 2C AF B4 00 28 AF B2 00 20 AF B1 00 1C AF B0 00 18 AF BC 00 10 14 40 00 DE 00 C0 98 21 24 03 00 03 00 80 80 21 00 A0 88 21 10 83 00 24 8C A2 00 00 14 80 00 1F 3C 03 20 03 3C 03 20 09 24 63 07 20 14 62 00 D3 3C 02 ?? ?? 00 10 A0 80 24 42 ?? ?? 00 54 10 21 8E 32 00 04 8C 42 00 00 02 42 10 2B 14 40 00 CB 00 00 00 00 26 44 00 02 00 04 20 80 00 93 10 2B 10 40 00 C6 00 00 00 00 0? ?? ?? ?? 24 84 00 1C 14 40 00 10 00 00 18 21 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 00 60 10 21 03 E0 00 08 27 BD 00 30 24 63 11 15 0? ?? ?? ?? 00 83 18 26 3C 03 20 05 0? ?? ?? ?? 24 63 10 17 AC 51 00 04 AC 53 00 08 AC 40 00 14 AC 40 00 10 AC 40 00 18 AC 40 00 1C 12 40 00 A2 AC 52 00 20 8E 24 00 08 02 64 18 2B 14 60 00 22 3C 0B ?? ?? 3C 07 ?? ?? 25 6B ?? ?? 24 E7 ?? ?? 01 74 58 21 02 20 30 21 00 40 28 21 00 00 18 21 2E 08 00 0D 24 0A 00 05 00 F4 A0 21 11 00 00 85 00 00 00 00 8E 87 00 00 00 E0 00 08 00 00 00 00 2C 67 00 10 10 E0 00 8E 3C 07 ?? ?? 8D 69 00 00 00 03 38 80 01 27 38 21 8C E7 00 00 10 EA 00 80 30 87 00 03 02 24 20 21 AC A4 00 24 24 63 00 01 10 72 00 81 24 A5 00 04 8C C4 00 0C 02 64 38 2B 10 E0 FF EA 24 C6 00 04 0? ?? ?? ?? 00 40 20 21 8F BC 00 10 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 16 AC 43 00 00 0? ?? ?? ?? 00 00 18 21 2C 67 00 02 14 E0 FF E4 3C 07 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 89 0? ?? ?? ?? 24 E7 ?? ?? 2C 67 00 05 14 E0 FF DA 3C 07 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 88 0? ?? ?? ?? 24 E7 ?? ?? 2C 67 00 0D 14 E0 FF D0 3C 07 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 87 0? ?? ?? ?? 24 E7 ?? ?? 2C 67 00 07 14 E0 FF C6 3C 07 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 86 0? ?? ?? ?? 24 E7 ?? ?? 2C 67 00 03 14 E0 FF BC 3C 07 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 85 0? ?? ?? ?? 24 E7 ?? ?? 2C 67 00 05 14 E0 FF B2 3C 07 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 84 0? ?? ?? ?? 24 E7 ?? ?? 2C 67 00 2E 14 E0 FF A8 3C 07 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 83 0? ?? ?? ?? 24 E7 ?? ?? 2C 67 00 13 14 E0 FF 9E 3C 07 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 82 0? ?? ?? ?? 24 E7 ?? ?? 2C 67 00 6F 14 E0 FF 94 3C 07 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 81 0? ?? ?? ?? 24 E7 ?? ?? 2C 67 00 06 14 E0 FF 8A 3C 07 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 80 0? ?? ?? ?? 24 E7 ?? ?? 16 00 00 1D 3C 07 ?? ?? 2C 67 00 47 10 E0 FF 84 00 00 00 00 0? ?? ?? ?? 8D 69 00 00 14 E0 FF 89 00 00 00 00 02 24 20 21 8C 84 00 00 0? ?? ?? ?? AC A4 00 24 0? ?? ?? ?? 00 40 18 21 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 8A 0? ?? ?? ?? 24 E7 ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 16 AC 43 00 00 0? ?? ?? ?? 00 00 18 21 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 8C 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_191_1_0 {
	meta:
		name = "_nl_load_locale"
		size = 860
		refs = "0004 __gnu_local_gp 0074 __fxstat64 0098 __libc_errno 00bc __mmap 00ec _nl_intern_locale_data 0198 malloc 0204 free 022c __munmap 027c strlen 0284 _nl_category_name_sizes 02b4 mempcpy 02bc $LC13 02d0 _nl_category_name_idxs 02e0 _nl_category_names 02f0 memcpy"
	strings:
		$1 = { 27 BD FF 10 3C 1C ?? ?? 27 9C ?? ?? AF BE 00 E8 24 02 00 01 03 A0 F0 21 AF B5 00 DC AF B1 00 CC AF BF 00 EC AF B7 00 E4 AF B6 00 E0 AF B4 00 D8 AF B3 00 D4 AF B2 00 D0 AF B0 00 C8 AF DC 00 18 00 80 88 21 00 A0 A8 21 AC 82 00 04 AC 80 00 08 3C 05 00 08 8C 84 00 00 24 02 0F A5 00 00 00 0C 14 E0 00 36 00 40 80 21 04 40 00 27 24 04 00 03 00 40 28 21 0? ?? ?? ?? 27 C6 00 20 04 40 00 63 8F DC 00 18 8F C3 00 38 24 02 40 00 30 63 F0 00 10 62 00 77 02 00 20 21 8F 93 ?? ?? 7C 03 E8 3B 8F C5 00 5C 02 63 B0 21 8E D7 00 00 00 00 20 21 AF B0 00 10 AF A0 00 14 24 06 00 01 0? ?? ?? ?? 24 07 00 02 00 40 90 21 24 02 FF FF 12 42 00 2D 24 14 00 01 02 00 20 21 24 02 0F A6 00 00 00 0C 12 40 00 09 8F C6 00 5C 02 A0 20 21 0? ?? ?? ?? 02 40 28 21 10 40 00 4A 00 00 00 00 AC 40 00 00 AC 54 00 0C AE 22 00 08 03 C0 E8 21 8F BF 00 EC 8F BE 00 E8 8F B7 00 E4 8F B6 00 E0 8F B5 00 DC 8F B4 00 D8 8F B3 00 D4 8F B2 00 D0 8F B1 00 CC 8F B0 00 C8 03 E0 00 08 27 BD 00 F0 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 AC 50 00 00 03 C0 E8 21 8F BF 00 EC 8F BE 00 E8 8F B7 00 E4 8F B6 00 E0 8F B5 00 DC 8F B4 00 D8 8F B3 00 D4 8F B2 00 D0 8F B1 00 CC 8F B0 00 C8 03 E0 00 08 27 BD 00 F0 8E C3 00 00 24 02 00 59 14 62 00 71 00 00 00 00 8F D4 00 5C 0? ?? ?? ?? 02 80 20 21 10 40 00 6A 00 40 90 21 1A 80 00 63 02 00 20 21 00 40 28 21 02 80 30 21 24 02 0F A3 00 00 00 0C 14 E0 00 0D 00 00 00 00 18 40 00 1E 02 40 B0 21 02 82 A0 23 1A 80 00 58 02 C2 B0 21 02 00 20 21 02 C0 28 21 02 80 30 21 24 02 0F A3 00 00 00 0C 10 E0 00 12 00 00 00 00 7C 03 E8 3B 02 63 98 21 02 40 20 21 0? ?? ?? ?? AE 62 00 00 02 00 20 21 24 02 0F A6 00 00 00 0C 0? ?? ?? ?? 03 C0 E8 21 12 80 FF B9 00 00 00 00 8F C5 00 5C 0? ?? ?? ?? 02 40 20 21 0? ?? ?? ?? 03 C0 E8 21 1C 40 FF E5 02 82 A0 23 02 40 20 21 0? ?? ?? ?? AF C2 00 C0 8F C2 00 C0 14 40 FF EE 02 00 20 21 7C 03 E8 3B 02 63 10 21 24 03 00 16 0? ?? ?? ?? AC 43 00 00 24 02 0F A6 00 00 00 0C 8E 30 00 00 0? ?? ?? ?? 02 00 20 21 3C 03 ?? ?? 24 63 ?? ?? 02 A3 18 21 90 72 00 00 02 00 28 21 00 40 30 21 02 42 18 21 24 63 00 14 00 03 18 C2 00 03 18 C0 03 A3 E8 23 27 B0 00 18 0? ?? ?? ?? 02 00 20 21 3C 05 ?? ?? 24 A5 ?? ?? 00 40 20 21 0? ?? ?? ?? 24 06 00 05 3C 03 ?? ?? 24 63 ?? ?? 02 A3 18 21 90 63 00 00 3C 05 ?? ?? 24 A5 ?? ?? 00 A3 28 21 00 40 20 21 0? ?? ?? ?? 26 46 00 01 8F DC 00 18 02 00 20 21 3C 05 00 08 24 02 0F A5 00 00 00 0C 14 E0 FF 8B 00 40 80 21 04 40 FF 7C 24 04 00 03 00 40 28 21 0? ?? ?? ?? 27 C6 00 20 04 41 FF 5B 8F DC 00 18 0? ?? ?? ?? 02 00 20 21 7C 03 E8 3B 02 63 10 21 AC 57 00 00 0? ?? ?? ?? 00 00 A0 21 0? ?? ?? ?? 00 00 A0 21 0? ?? ?? ?? 00 00 90 21 }
	condition:
		$1
}

rule file_191_2_0 {
	meta:
		name = "_nl_unload_locale"
		size = 128
		refs = "0040 free 0060 __munmap"
	strings:
		$1 = { 8C 99 00 10 27 BD FF E0 AF B0 00 18 AF BF 00 1C 13 20 00 03 00 80 80 21 03 20 F8 09 00 00 00 00 8E 02 00 0C 10 40 00 12 24 03 00 01 10 43 00 0B 00 00 00 00 24 03 00 02 10 43 00 04 8F BF 00 1C 0? ?? ?? ?? 8E 04 00 00 8F BF 00 1C 02 00 20 21 8F B0 00 18 0? ?? ?? ?? 27 BD 00 20 8E 04 00 04 0? ?? ?? ?? 8E 05 00 08 0? ?? ?? ?? 8E 02 00 0C 0? ?? ?? ?? 8E 04 00 04 0? ?? ?? ?? 8E 02 00 0C }
	condition:
		$1
}

rule file_193_0_0 {
	meta:
		name = "getutmp"
		size = 88
	strings:
		$1 = { 24 88 01 80 88 87 00 00 88 86 00 04 88 83 00 08 88 82 00 0C 98 87 00 03 98 86 00 07 98 83 00 0B 98 82 00 0F A8 A7 00 00 B8 A7 00 03 A8 A6 00 04 B8 A6 00 07 A8 A3 00 08 B8 A3 00 0B 24 84 00 10 A8 A2 00 0C B8 A2 00 0F 14 88 FF EE 24 A5 00 10 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_194_0_0 {
	meta:
		name = "__sysv_signal"
		size = 172
		refs = "0000 __gnu_local_gp 0040 memset 0058 __sigaction 0080 __libc_errno"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FE C0 27 9C ?? ?? 24 03 FF FF 00 A0 10 21 AF BF 01 3C AF B0 01 38 10 A3 00 16 AF BC 00 10 24 83 FF FF 2C 63 00 7F 10 60 00 12 00 80 80 21 27 A4 00 B0 00 00 28 21 24 06 00 80 0? ?? ?? ?? AF A2 00 AC 3C 02 E0 00 02 00 20 21 27 A5 00 A8 27 A6 00 18 0? ?? ?? ?? AF A2 00 A8 04 40 00 10 8F BF 01 3C 8F A2 00 1C 8F B0 01 38 03 E0 00 08 27 BD 01 40 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 16 AC 43 00 00 24 02 FF FF 8F BF 01 3C 8F B0 01 38 03 E0 00 08 27 BD 01 40 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_196_0_0 {
	meta:
		name = "__getsockopt"
		size = 28
	strings:
		$1 = { 24 02 10 4D 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_197_0_0 {
	meta:
		name = "posix_spawnattr_setschedpolicy"
		size = 32
	strings:
		$1 = { 2C A3 00 03 14 60 00 03 24 02 00 16 03 E0 00 08 00 00 00 00 AC 85 01 0C 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_199_0_0 {
	meta:
		name = "erand48"
		size = 44
		refs = "0010 __erand48_r 0004 __libc_drand48_data"
	strings:
		$1 = { 27 BD FF D8 3C 05 ?? ?? 27 A6 00 18 AF BF 00 24 0? ?? ?? ?? 24 A5 ?? ?? 8F BF 00 24 8F A3 00 1C 8F A2 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_200_0_0 {
	meta:
		name = "__fstat"
		size = 20
		refs = "000c __fxstat"
		altNames = "fstat64"
	strings:
		$1 = { 00 80 10 21 00 A0 30 21 24 04 00 03 0? ?? ?? ?? 00 40 28 21 }
	condition:
		$1
}

rule file_800_0_0 {
	meta:
		name = "__lstat"
		size = 20
		refs = "000c __lxstat"
	strings:
		$1 = { 00 80 10 21 00 A0 30 21 24 04 00 03 0? ?? ?? ?? 00 40 28 21 }
	condition:
		$1
}

rule file_951_0_0 {
	meta:
		name = "__stat"
		size = 20
		refs = "000c __xstat"
	strings:
		$1 = { 00 80 10 21 00 A0 30 21 24 04 00 03 0? ?? ?? ?? 00 40 28 21 }
	condition:
		$1
}

rule file_591_0_0 {
	meta:
		name = "lstat64"
		size = 20
		refs = "000c __lxstat64"
	strings:
		$1 = { 00 80 10 21 00 A0 30 21 24 04 00 03 0? ?? ?? ?? 00 40 28 21 }
	condition:
		$1
}

rule file_602_0_0 {
	meta:
		name = "stat64"
		size = 20
		refs = "000c __xstat64"
	strings:
		$1 = { 00 80 10 21 00 A0 30 21 24 04 00 03 0? ?? ?? ?? 00 40 28 21 }
	condition:
		$1
}

rule file_201_0_0 {
	meta:
		name = "revoke"
		size = 40
		refs = "0000 __gnu_local_gp 0010 __libc_errno"
		altNames = "__sigreturn fattach fdetach lchmod setlogin sstk"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 59 AC 43 00 00 03 E0 00 08 24 02 FF FF }
	condition:
		$1
}

rule file_202_0_0 {
	meta:
		name = "_IO_obstack_xsputn"
		size = 232
		refs = "0060 memcpy 00ac _obstack_newchunk 00bc mempcpy"
	strings:
		$1 = { 27 BD FF D0 AF B1 00 20 00 80 88 21 8C 84 00 14 8E 22 00 18 AF B2 00 24 00 86 18 21 00 43 18 2B AF B0 00 1C AF BF 00 2C AF B3 00 28 00 C0 90 21 10 60 00 22 8E 30 00 A0 00 A0 98 21 8E 05 00 0C 00 82 20 23 8E 03 00 10 00 A4 20 21 00 86 10 21 00 62 10 2B 14 40 00 14 AE 04 00 0C 02 60 28 21 0? ?? ?? ?? 02 40 30 21 8E 03 00 0C 8E 02 00 10 8E 04 00 08 8F BF 00 2C 00 72 18 21 AE 22 00 18 AE 24 00 10 AE 23 00 14 8F B3 00 28 AE 02 00 0C 8F B1 00 20 02 40 10 21 8F B0 00 1C 8F B2 00 24 03 E0 00 08 27 BD 00 30 02 00 20 21 0? ?? ?? ?? 00 C0 28 21 0? ?? ?? ?? 8E 04 00 0C 0? ?? ?? ?? 00 00 00 00 8F BF 00 2C AE 22 00 14 8F B3 00 28 02 40 10 21 8F B1 00 20 8F B2 00 24 8F B0 00 1C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_202_1_0 {
	meta:
		name = "_IO_obstack_overflow"
		size = 172
		refs = "0040 _obstack_newchunk 008c $LC0 0090 $LC1 00a4 __assert_fail 0094 __PRETTY_FUNCTION__.9814"
	strings:
		$1 = { 27 BD FF D0 24 03 FF FF 00 A0 10 21 AF B1 00 28 AF B0 00 24 AF BF 00 2C 00 80 88 21 10 A3 00 1B 8C 90 00 A0 8E 03 00 0C 8E 05 00 10 24 64 00 01 00 A4 28 2B 10 A0 00 07 24 05 00 01 02 00 20 21 0? ?? ?? ?? AF A2 00 18 8E 03 00 0C 8F A2 00 18 24 64 00 01 AE 04 00 0C A0 62 00 00 8E 04 00 0C 8E 03 00 10 8E 05 00 08 8F BF 00 2C AE 24 00 14 AE 25 00 10 AE 23 00 18 AE 03 00 0C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 30 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 2F 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_202_2_0 {
	meta:
		name = "_IO_obstack_vprintf"
		size = 392
		refs = "003c _IO_no_init 0050 _IO_obstack_jumps 0080 _IO_str_init_static_internal 00c8 _IO_vfprintf 0108 _obstack_newchunk 0120 $LC2 0124 $LC1 0138 __assert_fail 0128 __PRETTY_FUNCTION__.9849 014c $LC4 0098 $LC3"
	strings:
		$1 = { 27 BD FF 20 00 00 38 21 AF B3 00 D4 AF B2 00 D0 AF B0 00 C8 00 A0 98 21 00 80 80 21 34 05 80 00 27 A4 00 20 00 C0 90 21 AF A0 00 10 24 06 FF FF AF B1 00 CC AF BF 00 DC AF B4 00 D8 0? ?? ?? ?? AF A0 00 68 8E 11 00 10 8E 05 00 08 8E 07 00 0C 3C 04 ?? ?? 02 25 18 23 24 84 ?? ?? AF A4 00 B8 14 60 00 37 02 27 88 23 2A 22 00 40 14 40 00 26 02 00 20 21 8E 05 00 08 02 20 A0 21 27 A4 00 20 0? ?? ?? ?? 02 20 30 21 8F A2 00 30 8F A3 00 38 00 62 18 23 14 71 00 35 3C 04 ?? ?? 8E 03 00 0C 8E 04 00 08 00 64 20 23 00 44 10 21 8F A4 00 34 14 82 00 26 00 74 18 21 AE 03 00 0C 27 A4 00 20 02 60 28 21 02 40 30 21 0? ?? ?? ?? AF B0 00 C0 8F A3 00 38 8F A5 00 34 8E 04 00 0C 8F BF 00 DC 00 A3 18 23 00 83 18 21 AE 03 00 0C 8F B4 00 D8 8F B3 00 D4 8F B2 00 D0 8F B1 00 CC 8F B0 00 C8 03 E0 00 08 27 BD 00 E0 0? ?? ?? ?? 24 05 00 40 8E 07 00 0C 8E 11 00 10 02 27 88 23 16 20 FF D5 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 97 0? ?? ?? ?? 24 E7 ?? ?? 02 20 A0 21 0? ?? ?? ?? 00 60 88 21 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 A2 0? ?? ?? ?? 24 E7 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 9F 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_203_0_0 {
	meta:
		name = "skip"
		size = 288
	strings:
		$1 = { 80 83 00 00 10 60 00 43 24 07 00 22 00 80 28 21 00 00 30 21 24 09 00 01 24 0A 00 23 24 0B 00 20 10 67 00 11 24 0C 00 5C 10 C9 00 16 24 88 00 01 80 A2 00 00 10 6A 00 31 A0 82 00 00 24 62 FF F7 2C 42 00 02 14 40 00 1C 00 00 00 00 10 6B 00 1A 01 00 20 21 80 A3 00 01 10 60 00 07 24 A2 00 01 14 67 FF F1 00 40 28 21 80 A3 00 01 38 C6 00 01 14 60 FF FB 24 A2 00 01 00 80 40 21 03 E0 00 08 A1 00 FF FF 10 6C 00 05 00 00 00 00 80 A2 00 00 24 84 00 01 0? ?? ?? ?? A0 82 FF FF 80 A2 00 01 14 47 FF FA 00 00 00 00 A0 82 00 00 24 A5 00 01 0? ?? ?? ?? 24 84 00 01 3C 02 ?? ?? A0 43 ?? ?? A0 A0 00 00 24 A2 00 01 24 05 00 20 80 43 00 00 24 64 FF F7 30 84 00 FF 2C 84 00 02 14 80 00 05 00 00 00 00 10 65 00 03 00 00 00 00 03 E0 00 08 A1 00 FF FF 0? ?? ?? ?? 24 42 00 01 3C 02 ?? ?? A0 43 ?? ?? A0 A0 00 00 00 A0 10 21 03 E0 00 08 A1 00 FF FF 00 80 40 21 0? ?? ?? ?? 00 80 10 21 }
	condition:
		$1
}

rule file_203_1_0 {
	meta:
		name = "setttyent"
		size = 124
		refs = "0018 rewind 0034 $LC0 0040 _IO_new_fopen 0038 $LC1"
	strings:
		$1 = { 27 BD FF E0 AF B0 00 18 3C 10 ?? ?? 8E 04 ?? ?? 10 80 00 08 AF BF 00 1C 0? ?? ?? ?? 00 00 00 00 24 02 00 01 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 00 40 18 21 10 40 00 09 AE 02 ?? ?? 8C 44 00 00 8F BF 00 1C 8F B0 00 18 34 84 80 00 24 02 00 01 AC 64 00 00 03 E0 00 08 27 BD 00 20 0? ?? ?? ?? 00 00 10 21 }
	condition:
		$1
}

rule file_203_2_0 {
	meta:
		name = "getttyent"
		size = 1048
		refs = "0010 __gnu_local_gp 0044 __libc_tsd_CTYPE_B 0068 fgets_unlocked 007c strchr 01b0 $LC2 01b4 $LC3 01b8 $LC4 0220 strncmp 02f0 $LC5 03d4 setttyent 0408 __uflow"
	strings:
		$1 = { 27 BD FF C0 AF B2 00 20 3C 12 ?? ?? 8E 46 ?? ?? 3C 1C ?? ?? 27 9C ?? ?? AF BF 00 3C AF BE 00 38 AF B7 00 34 AF B6 00 30 AF B5 00 2C AF B4 00 28 AF B3 00 24 AF B1 00 1C AF B0 00 18 10 C0 00 E5 AF BC 00 10 8F 97 ?? ?? 3C 14 ?? ?? 26 91 ?? ?? 7C 03 E8 3B 02 20 98 21 24 10 FF FF 02 E3 B0 21 3C 15 ?? ?? 02 20 20 21 0? ?? ?? ?? 24 05 00 64 10 40 00 21 00 00 10 21 02 60 20 21 0? ?? ?? ?? 24 05 00 0A 10 40 00 28 26 A2 ?? ?? 82 83 ?? ?? 8E C6 00 00 00 03 20 40 00 C4 20 21 94 84 00 00 30 84 00 20 10 80 00 09 02 20 38 21 80 43 00 00 00 40 38 21 00 03 28 40 00 C5 28 21 94 A5 00 00 30 A5 00 20 14 A0 FF F9 24 42 00 01 10 60 00 04 8E 46 ?? ?? 24 02 00 23 14 62 00 22 00 E0 20 21 02 20 20 21 0? ?? ?? ?? 24 05 00 64 14 40 FF E3 02 60 20 21 00 00 10 21 8F BF 00 3C 8F BE 00 38 8F B7 00 34 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 40 8E 46 ?? ?? 24 1E 00 0A 8C C2 00 04 8C C4 00 08 00 44 20 2B 10 80 00 B2 24 43 00 01 AC C3 00 04 90 42 00 00 10 5E FF C6 02 20 20 21 14 50 FF F6 00 00 00 00 0? ?? ?? ?? 00 00 00 00 3C 12 ?? ?? 3C 16 ?? ?? AE 47 ?? ?? A2 C0 ?? ?? 0? ?? ?? ?? 26 52 ?? ?? AE 42 00 04 00 40 80 21 80 42 00 00 14 40 00 89 00 00 00 00 AE 40 00 08 AE 40 00 04 AE 40 00 0C AE 40 00 10 82 11 00 00 12 20 00 38 82 C3 ?? ?? 7C 03 E8 3B 3C 13 ?? ?? 3C 14 ?? ?? 3C 15 ?? ?? 26 73 ?? ?? 26 94 ?? ?? 26 B5 ?? ?? 3C 1E ?? ?? 0? ?? ?? ?? 02 E3 B8 21 82 02 00 03 8E E3 00 00 00 02 10 40 00 62 10 21 94 42 00 00 30 42 00 20 10 40 00 11 02 80 28 21 8E 43 00 0C 24 02 FF FE 00 62 10 24 AE 42 00 0C 0? ?? ?? ?? 02 00 20 21 80 51 00 00 12 20 00 1C 00 40 80 21 02 00 20 21 02 60 28 21 0? ?? ?? ?? 24 06 00 03 10 40 FF EA 02 00 20 21 02 80 28 21 0? ?? ?? ?? 24 06 00 02 14 40 00 20 02 00 20 21 82 02 00 02 8E E3 00 00 00 02 10 40 00 62 10 21 94 42 00 00 30 42 00 20 10 40 00 19 02 A0 28 21 8E 42 00 0C 02 00 20 21 34 42 00 01 0? ?? ?? ?? AE 42 00 0C 80 51 00 00 16 20 FF E6 00 40 80 21 82 C3 ?? ?? 24 02 00 23 14 62 00 31 00 00 00 00 24 03 00 20 24 04 00 09 26 10 00 01 82 02 00 00 10 43 FF FD 00 00 00 00 10 44 FF FC 26 10 00 01 26 10 FF FF 0? ?? ?? ?? AE 50 00 14 02 A0 28 21 0? ?? ?? ?? 24 06 00 06 14 40 00 0D 02 00 20 21 82 02 00 06 8E E3 00 00 00 02 10 40 00 62 10 21 94 42 00 00 30 42 00 20 10 40 00 06 27 C5 ?? ?? 8E 42 00 0C 34 42 00 02 0? ?? ?? ?? AE 42 00 0C 27 C5 ?? ?? 0? ?? ?? ?? 24 06 00 06 14 40 00 0A 24 02 00 3D 82 03 00 06 14 62 00 07 02 00 20 21 0? ?? ?? ?? 24 05 00 3D 24 43 00 01 00 02 18 0A 0? ?? ?? ?? AE 43 00 10 82 C3 ?? ?? 24 02 00 23 10 62 FF D4 24 03 00 20 12 22 FF D2 00 00 00 00 AE 50 00 14 82 02 00 00 14 40 00 02 02 00 20 21 AE 40 00 14 0? ?? ?? ?? 24 05 00 0A 10 40 00 1F 00 00 00 00 A0 40 00 00 8F BF 00 3C 02 40 10 21 8F BE 00 38 8F B7 00 34 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 40 0? ?? ?? ?? 02 00 20 21 AE 42 00 08 00 40 80 21 80 42 00 00 14 40 00 0C 00 00 00 00 0? ?? ?? ?? AE 40 00 08 0? ?? ?? ?? 00 00 00 00 8F BC 00 10 14 40 FF 18 8E 46 ?? ?? 0? ?? ?? ?? 00 00 10 21 0? ?? ?? ?? 02 40 10 21 0? ?? ?? ?? 02 00 20 21 0? ?? ?? ?? 00 40 80 21 0? ?? ?? ?? 00 C0 20 21 0? ?? ?? ?? 8E 46 ?? ?? }
	condition:
		$1
}

rule file_203_3_0 {
	meta:
		name = "endttyent"
		size = 80
		refs = "0018 _IO_new_fclose"
	strings:
		$1 = { 27 BD FF E0 AF B0 00 18 3C 10 ?? ?? 8E 04 ?? ?? 10 80 00 0A AF BF 00 1C 0? ?? ?? ?? 00 00 00 00 8F BF 00 1C 24 42 00 01 AE 00 ?? ?? 00 02 10 2B 8F B0 00 18 03 E0 00 08 27 BD 00 20 8F BF 00 1C 8F B0 00 18 24 02 00 01 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_203_4_0 {
	meta:
		name = "getttynam"
		size = 100
		refs = "0010 setttyent 0020 strcmp 0030 getttyent 0044 endttyent"
	strings:
		$1 = { 27 BD FF D8 AF B1 00 20 AF BF 00 24 AF B0 00 1C 0? ?? ?? ?? 00 80 88 21 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 8E 05 00 00 10 40 00 06 00 00 00 00 0? ?? ?? ?? 00 00 00 00 00 40 80 21 14 40 FF F8 02 20 20 21 0? ?? ?? ?? 00 00 00 00 8F BF 00 24 02 00 10 21 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_204_0_0 {
	meta:
		name = "quotactl"
		size = 28
	strings:
		$1 = { 24 02 10 23 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_205_0_0 {
	meta:
		name = "__strchrnul"
		size = 260
	strings:
		$1 = { 30 82 00 03 14 40 00 09 30 A3 00 FF 0? ?? ?? ?? 30 A5 00 FF 10 40 00 09 00 80 10 21 24 84 00 01 30 82 00 03 10 40 00 07 00 00 00 00 90 82 00 00 14 43 FF F8 00 00 00 00 00 80 10 21 03 E0 00 08 00 00 00 00 30 A5 00 FF 00 05 62 00 01 85 28 25 00 05 64 00 3C 08 7E FE 3C 0B 81 01 01 85 60 25 35 08 FE FF 25 6B 01 00 24 85 00 04 8C A6 FF FC 00 CC 38 26 00 07 50 27 00 06 48 27 00 E8 38 21 00 C8 30 21 01 47 38 26 01 26 30 26 00 E6 30 25 00 CB 30 24 10 C0 00 15 24 82 00 01 90 A6 FF FC 10 C3 FF E5 00 00 00 00 10 C0 FF E3 00 00 00 00 90 A6 FF FD 10 C3 FF E1 00 00 00 00 10 C0 FF DF 00 00 00 00 90 A2 FF FE 10 43 00 0C 00 00 00 00 10 40 00 0A 00 00 00 00 90 A2 FF FF 10 43 00 05 00 00 00 00 10 40 00 03 00 00 00 00 0? ?? ?? ?? 00 A0 20 21 03 E0 00 08 24 82 00 03 03 E0 00 08 24 82 00 02 }
	condition:
		$1
}

rule file_206_0_0 {
	meta:
		name = "do_waitid"
		size = 108
		refs = "0004 __gnu_local_gp 0058 __libc_errno"
	strings:
		$1 = { 27 BD FF E8 3C 1C ?? ?? 27 9C ?? ?? AF BE 00 14 03 A0 F0 21 27 BD FF F0 AF DC 00 00 AF DD 00 08 00 00 10 21 27 BD FF E0 AF A2 00 10 24 02 10 B6 00 00 00 0C 27 BD 00 20 14 E0 00 05 00 00 00 00 03 C0 E8 21 8F BE 00 14 03 E0 00 08 27 BD 00 18 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 64 20 21 AC 82 00 00 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_206_1_0 {
	meta:
		name = "__waitid"
		size = 112
		refs = "0030 __libc_enable_asynccancel 0054 __libc_disable_asynccancel"
	strings:
		$1 = { 7C 03 E8 3B 8C 62 8B 70 14 40 00 03 00 00 00 00 0? ?? ?? ?? 00 00 00 00 27 BD FF D0 AF BF 00 2C AF B0 00 28 AF A4 00 18 AF A5 00 1C AF A6 00 20 0? ?? ?? ?? AF A7 00 24 8F A5 00 1C 8F A6 00 20 8F A7 00 24 8F A4 00 18 0? ?? ?? ?? 00 40 80 21 02 00 20 21 0? ?? ?? ?? AF A2 00 18 8F BF 00 2C 8F A2 00 18 8F B0 00 28 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_207_0_0 {
	meta:
		name = "__snprintf"
		size = 40
		refs = "0014 _IO_vsnprintf"
	strings:
		$1 = { 27 BD FF D8 27 A2 00 34 AF A7 00 34 00 40 38 21 AF BF 00 24 0? ?? ?? ?? AF A2 00 18 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_214_0_0 {
	meta:
		name = "__asprintf_chk"
		size = 40
		refs = "0014 __vasprintf_chk"
	strings:
		$1 = { 27 BD FF D8 27 A2 00 34 AF A7 00 34 00 40 38 21 AF BF 00 24 0? ?? ?? ?? AF A2 00 18 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_1063_0_0 {
	meta:
		name = "__dprintf_chk"
		size = 40
		refs = "0014 __vdprintf_chk"
	strings:
		$1 = { 27 BD FF D8 27 A2 00 34 AF A7 00 34 00 40 38 21 AF BF 00 24 0? ?? ?? ?? AF A2 00 18 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_1385_1_0 {
	meta:
		name = "__obstack_printf_chk"
		size = 40
		refs = "0014 __obstack_vprintf_chk"
	strings:
		$1 = { 27 BD FF D8 27 A2 00 34 AF A7 00 34 00 40 38 21 AF BF 00 24 0? ?? ?? ?? AF A2 00 18 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_1422_0_0 {
	meta:
		name = "__swprintf"
		size = 40
		refs = "0014 __vswprintf"
	strings:
		$1 = { 27 BD FF D8 27 A2 00 34 AF A7 00 34 00 40 38 21 AF BF 00 24 0? ?? ?? ?? AF A2 00 18 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_888_5_0 {
	meta:
		name = "__syslog_chk"
		size = 40
		refs = "0014 __vsyslog_chk"
	strings:
		$1 = { 27 BD FF D8 27 A2 00 34 AF A7 00 34 00 40 38 21 AF BF 00 24 0? ?? ?? ?? AF A2 00 18 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_208_0_0 {
	meta:
		name = "wcwidth"
		size = 160
		refs = "0000 __gnu_local_gp 0010 _nl_current_LC_CTYPE"
	strings:
		$1 = { 3C 1C ?? ?? 7C 03 E8 3B 27 9C ?? ?? 00 60 10 21 8F 83 ?? ?? 00 62 10 21 8C 43 00 00 8C 63 00 00 8C 63 00 54 8C 65 00 00 8C 66 00 04 00 A4 28 06 00 A6 30 2B 10 C0 00 18 24 02 FF FF 24 A5 00 05 00 05 28 80 00 65 28 21 8C A5 00 00 10 A0 00 12 00 00 00 00 8C 66 00 08 8C 67 00 0C 00 C4 30 06 00 C7 30 24 00 06 30 80 00 C5 28 21 00 65 28 21 8C A5 00 00 10 A0 00 08 00 00 00 00 8C 66 00 10 00 65 18 21 00 86 20 24 00 64 18 21 90 63 00 00 38 64 00 FF 00 64 10 0B 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_210_0_0 {
	meta:
		name = "__fcvt"
		size = 252
		refs = "0060 __fcvt_r 00e4 malloc"
	strings:
		$1 = { 27 BD FF B8 AF B2 00 30 3C 12 ?? ?? 8E 42 ?? ?? AF B5 00 3C AF B4 00 38 AF B3 00 34 AF B1 00 2C AF B0 00 28 AF BF 00 44 AF B6 00 40 00 A0 88 21 00 80 80 21 00 C0 A8 21 00 E0 A0 21 10 40 00 15 8F B3 00 58 AF A2 00 14 24 02 01 48 AF B3 00 10 02 20 28 21 02 00 20 21 02 A0 30 21 02 80 38 21 0? ?? ?? ?? AF A2 00 18 8F BF 00 44 8E 42 ?? ?? 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 48 3C 16 ?? ?? 24 02 00 14 26 D6 ?? ?? AF B3 00 10 AF B6 00 14 0? ?? ?? ?? AF A2 00 18 24 03 FF FF 10 43 00 0B 02 C0 10 21 8F BF 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 48 0? ?? ?? ?? 24 04 01 48 14 40 FF D5 AE 42 ?? ?? 0? ?? ?? ?? 02 C0 10 21 }
	condition:
		$1
}

rule file_210_1_0 {
	meta:
		name = "__ecvt"
		size = 68
		refs = "0028 __ecvt_r"
	strings:
		$1 = { 27 BD FF D0 8F A2 00 40 AF B0 00 28 3C 10 ?? ?? 26 10 ?? ?? AF A2 00 10 24 02 00 14 AF B0 00 14 AF A2 00 18 AF BF 00 2C 0? ?? ?? ?? 00 00 00 00 8F BF 00 2C 02 00 10 21 8F B0 00 28 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_210_2_0 {
	meta:
		name = "__gcvt"
		size = 72
		refs = "0010 $LC0 002c sprintf"
		altNames = "__qgcvt"
	strings:
		$1 = { 27 BD FF D8 24 03 00 11 28 C2 00 12 AF A5 00 14 3C 05 ?? ?? AF A4 00 10 00 62 30 0A 00 E0 20 21 24 A5 ?? ?? AF BF 00 24 AF B0 00 20 0? ?? ?? ?? 00 E0 80 21 8F BF 00 24 02 00 10 21 8F B0 00 20 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_211_0_0 {
	meta:
		name = "ualarm"
		size = 104
		refs = "0020 __setitimer"
	strings:
		$1 = { 27 BD FF C0 27 A6 00 18 AF A4 00 34 AF A5 00 2C 00 00 20 21 27 A5 00 28 AF BF 00 3C AF A0 00 30 0? ?? ?? ?? AF A0 00 28 04 40 00 0B 24 03 FF FF 8F A2 00 20 00 02 22 00 00 02 18 C0 00 83 18 23 00 03 21 80 00 83 18 23 8F A4 00 24 00 62 18 21 00 03 19 80 00 64 18 21 8F BF 00 3C 00 60 10 21 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_212_2_0 {
	meta:
		name = "svcraw_freeargs"
		size = 96
		refs = "0014 __rpc_thread_variables"
	strings:
		$1 = { 27 BD FF D8 AF B1 00 20 AF B0 00 1C AF BF 00 24 00 A0 80 21 0? ?? ?? ?? 00 C0 88 21 8C 44 00 B8 10 80 00 0A 8F BF 00 24 02 20 28 21 02 00 C8 21 8F B1 00 20 8F B0 00 1C 24 02 00 02 AC 82 23 94 24 84 23 94 03 20 00 08 27 BD 00 28 8F B1 00 20 8F B0 00 1C 00 00 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_212_3_0 {
	meta:
		name = "svcraw_getargs"
		size = 88
		refs = "0014 __rpc_thread_variables"
	strings:
		$1 = { 27 BD FF D8 AF B1 00 20 AF B0 00 1C AF BF 00 24 00 A0 80 21 0? ?? ?? ?? 00 C0 88 21 8C 44 00 B8 10 80 00 08 8F BF 00 24 02 20 28 21 02 00 C8 21 8F B1 00 20 8F B0 00 1C 24 84 23 94 03 20 00 08 27 BD 00 28 8F B1 00 20 8F B0 00 1C 00 00 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_212_4_0 {
	meta:
		name = "svcraw_reply"
		size = 156
		refs = "0014 __rpc_thread_variables 0044 xdr_replymsg"
	strings:
		$1 = { 27 BD FF D8 AF B2 00 20 AF B0 00 18 AF BF 00 24 AF B1 00 1C 0? ?? ?? ?? 00 A0 90 21 8C 50 00 B8 12 00 00 0C 26 11 23 94 8E 02 23 98 02 20 20 21 8C 59 00 14 00 00 28 21 03 20 F8 09 AE 00 23 94 02 20 20 21 0? ?? ?? ?? 02 40 28 21 14 40 00 08 00 00 00 00 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 00 00 10 21 03 E0 00 08 27 BD 00 28 8E 02 23 98 8C 59 00 10 03 20 F8 09 02 20 20 21 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 24 02 00 01 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_212_5_0 {
	meta:
		name = "svcraw_recv"
		size = 124
		refs = "0010 __rpc_thread_variables 0044 xdr_callmsg"
	strings:
		$1 = { 27 BD FF D8 AF B1 00 20 AF BF 00 24 AF B0 00 1C 0? ?? ?? ?? 00 A0 88 21 8C 42 00 B8 10 40 00 11 24 50 23 94 8C 43 23 98 02 00 20 21 8C 79 00 14 24 03 00 01 AC 43 23 94 03 20 F8 09 00 00 28 21 02 00 20 21 0? ?? ?? ?? 02 20 28 21 8F BF 00 24 8F B1 00 20 8F B0 00 1C 00 02 10 2B 03 E0 00 08 27 BD 00 28 8F BF 00 24 8F B1 00 20 8F B0 00 1C 00 00 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_212_6_0 {
	meta:
		name = "svcraw_create"
		size = 124
		refs = "000c __rpc_thread_variables 0048 xdrmem_create 0064 calloc"
	strings:
		$1 = { 27 BD FF E0 AF B0 00 18 AF BF 00 1C 0? ?? ?? ?? 00 00 00 00 8C 50 00 B8 12 00 00 12 24 04 00 01 3C 03 ?? ?? 26 02 23 AC 24 63 ?? ?? AE 02 22 84 AE 00 22 60 A6 00 22 64 AE 03 22 68 26 04 23 94 02 00 28 21 24 06 22 60 0? ?? ?? ?? 24 07 00 02 26 02 22 60 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 0? ?? ?? ?? 24 05 25 3C 14 40 FF EC 00 40 80 21 0? ?? ?? ?? 00 00 10 21 }
	condition:
		$1
}

rule file_213_0_0 {
	meta:
		name = "raise"
		size = 140
		refs = "0004 __gnu_local_gp 0078 __libc_errno"
	strings:
		$1 = { 27 BD FF F8 3C 1C ?? ?? 27 9C ?? ?? AF B0 00 04 00 80 30 21 7C 03 E8 3B 8C 65 8B D8 00 60 80 21 14 A0 00 0D 8C 64 8B DC 24 02 10 7E 00 00 00 0C 00 40 20 21 AE 02 8B D8 00 40 28 21 24 02 10 AA 00 00 00 0C 14 E0 00 0A 00 00 00 00 8F B0 00 04 03 E0 00 08 27 BD 00 08 1C 80 FF F8 7C 83 F0 00 00 04 10 23 00 A0 20 21 0? ?? ?? ?? 00 43 20 0B 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 64 20 21 AC 82 00 00 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_215_0_0 {
	meta:
		name = "plural_eval"
		size = 520
	strings:
		$1 = { 27 BD FF D0 AF B0 00 18 00 80 80 21 8E 02 00 00 AF B1 00 1C 24 11 00 01 AF B4 00 28 AF B3 00 24 AF B2 00 20 AF BF 00 2C 00 A0 90 21 24 13 00 02 10 51 00 14 24 14 00 03 28 43 00 02 14 60 00 2F 00 00 00 00 10 53 00 1B 00 00 00 00 14 54 00 35 00 00 10 21 8E 04 00 08 0? ?? ?? ?? 02 40 28 21 02 20 18 21 02 62 18 0A 24 62 00 02 00 02 10 80 02 02 80 21 8E 10 00 00 8E 02 00 00 14 51 FF EF 28 43 00 02 8E 04 00 08 0? ?? ?? ?? 02 40 28 21 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 2C 42 00 01 03 E0 00 08 27 BD 00 30 8E 04 00 08 0? ?? ?? ?? 02 40 28 21 8E 11 00 04 00 40 98 21 24 02 00 0F 12 22 00 1F 00 00 00 00 24 02 00 0E 16 22 00 20 00 00 00 00 12 60 00 10 00 00 10 21 8E 04 00 0C 0? ?? ?? ?? 02 40 28 21 0? ?? ?? ?? 00 02 10 2B 14 40 00 09 00 00 10 21 8E 02 00 04 10 40 00 0E 24 03 00 01 14 43 00 03 00 00 00 00 0? ?? ?? ?? 8E 02 00 08 00 00 10 21 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 30 0? ?? ?? ?? 02 40 10 21 16 60 FF F5 24 02 00 01 0? ?? ?? ?? 8E 04 00 0C 8E 04 00 0C 02 40 28 21 0? ?? ?? ?? 26 31 FF FD 2E 23 00 0B 10 60 FF EB 3C 03 ?? ?? 24 63 ?? ?? 00 11 88 80 00 71 88 21 8E 23 00 00 00 60 00 08 00 00 00 00 02 62 10 26 0? ?? ?? ?? 2C 42 00 01 02 62 10 2B 0? ?? ?? ?? 38 42 00 01 00 53 10 2B 0? ?? ?? ?? 38 42 00 01 0? ?? ?? ?? 00 53 10 2B 0? ?? ?? ?? 02 62 10 2B 0? ?? ?? ?? 02 62 10 23 0? ?? ?? ?? 00 53 10 21 02 62 00 1B 00 40 01 F4 0? ?? ?? ?? 00 00 10 10 02 62 00 1B 00 40 01 F4 0? ?? ?? ?? 00 00 10 12 0? ?? ?? ?? 70 53 10 02 02 62 10 26 0? ?? ?? ?? 00 02 10 2B }
	condition:
		$1
}

rule file_215_1_0 {
	meta:
		name = "transcmp"
		size = 152
		refs = "0034 strcmp"
	strings:
		$1 = { 8C 82 00 10 27 BD FF D8 AF B1 00 20 AF B0 00 1C AF BF 00 24 00 80 88 21 10 40 00 1D 00 A0 80 21 24 84 00 1C 8E 02 00 10 10 40 00 17 00 00 00 00 26 05 00 1C 0? ?? ?? ?? 00 00 00 00 14 40 00 0E 8F BF 00 24 8E 24 00 00 0? ?? ?? ?? 8E 05 00 00 14 40 00 09 8F BF 00 24 8E 24 00 08 0? ?? ?? ?? 8E 05 00 08 14 40 00 04 8F BF 00 24 8E 23 00 04 8E 02 00 04 00 62 10 23 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 0? ?? ?? ?? 8E 05 00 1C 0? ?? ?? ?? 8C 84 00 1C }
	condition:
		$1
}

rule file_215_2_0 {
	meta:
		name = "plural_lookup.isra.1"
		size = 156
		refs = "0048 __rawmemchr"
	strings:
		$1 = { 27 BD FF D8 AF B0 00 18 00 80 80 21 8C 84 00 60 AF B2 00 20 AF B1 00 1C 00 C0 90 21 AF BF 00 24 0? ?? ?? ?? 00 E0 88 21 8E 10 00 64 00 40 18 21 02 40 10 21 00 70 80 2B 00 10 18 0A 00 60 80 21 0? ?? ?? ?? 02 51 88 21 0? ?? ?? ?? 26 10 FF FF 24 42 00 01 00 51 18 2B 10 60 00 0A 8F BF 00 24 00 40 20 21 16 00 FF F8 00 00 28 21 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 02 40 10 21 8F B1 00 1C 8F B2 00 20 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_215_3_0 {
	meta:
		name = "_nl_find_msg"
		size = 3080
		refs = "0008 __gnu_local_gp 0070 strlen 007c __hash_string 013c strcmp 01a0 __pthread_rwlock_unlock 01b8 free 0260 __pthread_rwlock_rdlock 0444 _nl_load_domain 047c _nl_current_LC_CTYPE 02d8 __pthread_rwlock_wrlock 05a8 getenv 05a4 $LC0 05ec malloc 0608 memcpy 0648 realloc 065c __strdup 0688 $LC1 06a0 _nl_find_msg 06c0 strstr 06b8 $LC2 073c mempcpy 078c _nl_C_locobj 085c __gconv_open 0958 __gconv 0ad0 $LC3 0b20 __lll_lock_wait_private 0bec calloc"
	strings:
		$1 = { 8C 82 00 04 27 BD FF 88 3C 1C ?? ?? 27 9C ?? ?? AF BE 00 70 03 A0 F0 21 AF B6 00 68 AF BF 00 74 AF B7 00 6C AF B5 00 64 AF B4 00 60 AF B3 00 5C AF B2 00 58 AF B1 00 54 AF B0 00 50 AF DC 00 18 AF C4 00 78 AF C5 00 7C 00 C0 B0 21 18 40 00 FD AF C7 00 84 8F C2 00 78 8C 55 00 08 12 A0 00 59 00 00 10 21 8E A2 00 30 10 40 00 AE 8E B1 00 14 0? ?? ?? ?? 02 C0 20 21 02 C0 20 21 0? ?? ?? ?? 00 40 B8 21 8E AA 00 2C 8F DC 00 18 8E A9 00 34 25 46 FF FE 00 46 00 1B 00 C0 01 F4 8E A7 00 30 00 00 18 10 24 73 00 01 01 53 58 23 00 4A 00 1B 01 40 01 F4 02 6A A0 23 00 00 90 10 00 12 10 80 00 E2 10 21 11 20 00 03 8C 50 00 00 7C 10 80 A0 00 30 84 02 12 00 00 3A 26 10 FF FF 02 11 10 2B 10 40 00 23 02 11 18 23 8E A3 00 18 8E A4 00 0C 00 10 60 C0 00 6C 10 21 10 80 00 03 8C 42 00 00 7C 02 10 A0 00 22 14 02 00 57 28 2B 14 A0 00 12 00 00 10 21 00 6C 18 21 8E A5 00 00 10 80 00 03 8C 62 00 04 7C 02 10 A0 00 22 14 02 02 C0 20 21 00 A2 28 21 AF C7 00 44 AF C9 00 40 0? ?? ?? ?? AF CB 00 48 8F DC 00 18 8F CB 00 48 8F C9 00 40 8F C7 00 44 2C 42 00 01 14 40 00 27 02 4B 18 2B 02 54 10 21 02 53 90 21 0? ?? ?? ?? 00 43 90 0A 8E A2 00 24 00 03 18 C0 00 43 18 21 8C 64 00 00 02 E4 20 2B 10 80 FF F4 00 00 10 21 8C 65 00 04 0? ?? ?? ?? 02 C0 20 21 10 43 02 5F 00 00 00 00 3C 02 ?? ?? 24 42 ?? ?? 10 40 00 03 00 00 00 00 0? ?? ?? ?? 26 A4 00 40 0? ?? ?? ?? 02 80 20 21 00 00 10 21 03 C0 E8 21 8F BF 00 74 8F BE 00 70 8F B7 00 6C 8F B6 00 68 8F B5 00 64 8F B4 00 60 8F B3 00 5C 8F B2 00 58 8F B1 00 54 8F B0 00 50 03 E0 00 08 27 BD 00 78 02 11 10 2B 10 40 00 70 02 11 10 23 8E A2 00 0C 8E A3 00 00 10 40 00 85 8E A4 00 1C 00 10 10 C0 00 82 10 21 8C 56 00 04 8C 57 00 00 7C 16 B0 A0 00 36 B4 02 00 76 B0 21 8F C3 00 84 7C 17 B8 A0 00 37 BC 02 AF D6 00 38 10 60 00 68 26 F7 00 01 8F C4 00 7C 10 80 00 83 3C 12 ?? ?? 8C 94 00 08 12 80 00 81 8E 42 ?? ?? 3C 02 ?? ?? 24 42 ?? ?? 10 40 00 03 00 00 00 00 0? ?? ?? ?? 26 A4 00 40 8E B6 00 3C 12 C0 00 75 00 16 20 80 00 16 11 00 8E B2 00 38 00 44 10 23 24 42 FF F4 0? ?? ?? ?? 02 42 90 21 12 C0 00 6D 26 52 FF F4 8E 44 00 00 02 80 28 21 0? ?? ?? ?? 26 D6 FF FF 14 40 FF F9 00 00 00 00 3C 02 ?? ?? 24 42 ?? ?? 10 40 00 03 00 00 00 00 0? ?? ?? ?? 26 A4 00 40 12 40 00 8C 3C 02 ?? ?? 8E 43 00 04 24 02 FF FF 10 62 00 40 8F C2 00 88 8E 42 00 08 10 40 02 19 3C 03 ?? ?? 24 03 FF FF 10 43 00 80 00 10 18 80 00 43 10 21 8C 42 00 00 10 40 01 5C 3C 03 ?? ?? 8C 57 00 00 24 42 00 04 0? ?? ?? ?? AF C2 00 38 02 20 A0 21 0? ?? ?? ?? 00 00 98 21 8C 85 00 04 02 C0 20 21 AF C3 00 44 7C 05 28 A0 00 25 2C 02 0? ?? ?? ?? 02 E5 28 21 8F DC 00 18 04 40 00 16 8F C3 00 44 10 40 FF A7 26 13 00 01 02 74 10 2B 10 40 FF 97 00 00 10 21 8E B7 00 00 8E B2 00 0C 8E A3 00 18 02 93 80 21 00 10 80 42 00 10 10 C0 16 40 FF EA 00 62 20 21 8C 85 00 04 02 C0 20 21 AF C3 00 44 0? ?? ?? ?? 02 E5 28 21 8F DC 00 18 04 41 FF EC 8F C3 00 44 02 70 10 2B 10 40 FF 83 02 00 A0 21 0? ?? ?? ?? 02 93 80 21 8E A3 00 28 00 02 10 C0 00 62 10 21 8C 43 00 04 8C 57 00 00 AF C3 00 38 8F C3 00 84 14 60 FF 9B 8F C4 00 7C 8F C2 00 88 AC 57 00 00 03 C0 E8 21 8F BF 00 74 8F C2 00 38 8F B7 00 6C 8F BE 00 70 8F B6 00 68 8F B5 00 64 8F B4 00 60 8F B3 00 5C 8F B2 00 58 8F B1 00 54 8F B0 00 50 03 E0 00 08 27 BD 00 78 00 10 10 C0 00 82 10 21 8C 56 00 04 8C 57 00 00 00 76 B0 21 AF D6 00 38 0? ?? ?? ?? 26 F7 00 01 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 8F C2 00 78 0? ?? ?? ?? 00 00 90 21 8E 42 ?? ?? 10 40 00 50 3C 02 ?? ?? 8C 54 ?? ?? 16 80 FF 7D 3C 02 ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 8C 42 00 00 8C 42 00 00 0? ?? ?? ?? 8C 54 00 5C 8E 83 00 00 3C 02 ?? ?? 02 80 20 21 0? ?? ?? ?? AC 43 ?? ?? 8F C3 00 30 3C 02 ?? ?? AC 40 ?? ?? 24 64 ?? ?? AE 20 ?? ?? 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 00 09 8F C3 00 30 24 64 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 24 02 FF FF 24 42 ?? ?? 10 40 00 03 00 00 00 00 0? ?? ?? ?? 26 A4 00 40 8E A3 00 3C 10 60 00 41 AF C3 00 34 8E A3 00 38 8F C6 00 34 AF C3 00 3C 8F C3 00 34 8F C4 00 3C 00 03 10 80 00 03 19 00 00 62 18 23 24 63 FF F4 0? ?? ?? ?? 00 83 18 21 10 C0 00 36 24 63 FF F4 8C 64 00 00 24 C6 FF FF 02 80 28 21 AF C3 00 44 0? ?? ?? ?? AF C6 00 40 8F C3 00 44 8F C6 00 40 14 40 FF F5 00 60 90 21 3C 03 ?? ?? 24 63 ?? ?? 10 60 FF 53 00 00 00 00 0? ?? ?? ?? 26 A4 00 40 0? ?? ?? ?? 8E 43 00 04 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 00 40 28 21 10 40 00 04 8F DC 00 18 80 42 00 00 14 40 00 06 00 00 00 00 3C 02 ?? ?? 8C 54 ?? ?? 24 02 00 01 0? ?? ?? ?? AE 42 ?? ?? 00 A0 20 21 0? ?? ?? ?? AF C5 00 40 24 56 00 01 0? ?? ?? ?? 02 C0 20 21 00 40 A0 21 8F DC 00 18 10 40 00 05 8F C5 00 40 00 40 20 21 0? ?? ?? ?? 02 C0 30 21 8F DC 00 18 3C 02 ?? ?? AC 54 ?? ?? 24 02 00 01 0? ?? ?? ?? AE 42 ?? ?? 8E A3 00 38 AF C3 00 3C 8F C3 00 34 8F C4 00 3C 24 62 00 01 00 02 18 80 00 02 11 00 00 43 90 23 0? ?? ?? ?? 02 40 28 21 10 40 01 39 02 80 20 21 AE A2 00 38 0? ?? ?? ?? AF C2 00 44 00 40 A0 21 10 40 01 33 8F C3 00 44 26 52 FF F4 00 72 90 21 8F C4 00 78 8F C5 00 7C 24 03 FF FF AE 42 00 00 3C 06 ?? ?? 27 C2 00 20 AE 43 00 04 24 C6 ?? ?? AF A2 00 10 00 00 38 21 0? ?? ?? ?? AF C3 00 44 8F C3 00 44 10 43 FF 94 00 00 00 00 10 40 00 6D 3C 05 ?? ?? 00 40 20 21 0? ?? ?? ?? 24 A5 ?? ?? 10 40 00 68 24 04 FF DF 80 43 00 08 00 64 20 24 10 80 01 15 24 45 00 08 24 63 FF F7 30 63 00 FF 2C 63 00 02 14 60 00 0E 00 00 30 21 0? ?? ?? ?? 24 07 00 20 10 67 00 0A 00 00 00 00 14 80 00 08 00 00 00 00 24 C6 00 01 00 46 18 21 80 63 00 08 24 64 FF F7 30 84 00 FF 14 60 FF F6 2C 84 00 02 24 C2 00 0F 00 02 10 C2 00 02 10 C0 03 A2 E8 23 27 B3 00 18 0? ?? ?? ?? 02 60 20 21 A0 40 00 00 02 80 10 21 0? ?? ?? ?? 00 00 30 21 24 42 00 01 00 C4 30 21 80 43 00 00 38 64 00 2F 14 60 FF FB 2C 84 00 01 00 54 10 23 24 42 00 19 00 02 10 C2 82 83 00 00 00 02 10 C0 03 A2 E8 23 10 60 00 D0 27 B6 00 18 3C 02 ?? ?? 8C 44 ?? ?? 02 80 28 21 02 C0 10 21 00 03 18 80 00 83 18 21 8C 63 00 00 24 42 00 01 24 A5 00 01 A0 43 FF FF 80 A3 00 00 14 60 FF F9 00 03 18 80 2C C3 00 02 14 60 00 B3 24 03 00 2F A0 40 00 00 00 00 30 21 0? ?? ?? ?? 02 60 10 21 24 42 00 01 00 C5 30 21 80 43 00 00 38 65 00 2F 14 60 FF FB 2C A5 00 01 00 53 10 23 24 42 00 11 00 02 10 C2 82 63 00 00 00 02 10 C0 03 A2 E8 23 10 60 00 AC 27 A5 00 18 3C 02 ?? ?? 8C 44 ?? ?? 00 A0 10 21 00 03 18 80 00 83 18 21 8C 63 00 00 24 42 00 01 26 73 00 01 A0 43 FF FF 82 63 00 00 14 60 FF F9 00 03 18 80 2C C3 00 02 14 60 00 96 24 03 00 2F 02 C0 20 21 26 46 00 04 24 07 00 01 0? ?? ?? ?? A0 40 00 00 14 40 FE 4C 24 03 FF FF 8E A2 00 3C AE 40 00 08 24 42 00 01 0? ?? ?? ?? AE A2 00 3C 24 64 ?? ?? AF C3 00 30 C0 82 00 00 24 41 00 01 E0 81 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 9F 00 00 00 00 3C 03 ?? ?? 8C 62 ?? ?? 3C 11 ?? ?? 8E 26 ?? ?? 8F C4 00 38 24 42 00 04 AF C2 00 24 2C C2 00 04 AF C4 00 28 00 00 A8 21 10 40 00 17 3C 13 ?? ?? 12 A0 00 2A 24 02 0F F0 26 B5 00 01 8E 74 ?? ?? 00 15 11 00 00 15 33 00 00 C2 B0 23 02 80 20 21 02 C0 28 21 0? ?? ?? ?? AE 36 ?? ?? 10 40 FE E3 26 C6 FF FC AE 62 ?? ?? 24 44 00 04 24 42 00 08 3C 03 ?? ?? AF C2 00 24 2C C2 00 04 AC 64 ?? ?? 14 40 FF EB AE 26 ?? ?? 8F C2 00 24 24 C6 FF FC 8E 44 00 04 00 46 10 21 8F C6 00 28 AF A2 00 10 27 C2 00 20 27 C5 00 28 00 D7 30 21 27 C7 00 24 0? ?? ?? ?? AF A2 00 14 24 03 FF FB 00 43 20 24 10 80 00 10 24 04 00 05 14 44 00 32 8F C4 00 38 16 A0 FF D9 AF C4 00 28 24 02 0F F0 24 04 0F F0 0? ?? ?? ?? AE 22 ?? ?? 10 40 FE C5 8E 63 ?? ?? 24 06 0F EC AE 62 ?? ?? AC 43 00 00 0? ?? ?? ?? 24 15 00 01 3C 04 ?? ?? 8C 82 ?? ?? 8F C4 00 24 8E 43 00 08 00 10 80 80 00 82 20 23 00 70 18 21 24 84 FF FC AC 44 00 00 AC 62 00 00 8F C3 00 24 8E 24 ?? ?? 00 43 10 23 00 44 10 21 30 44 00 03 00 64 18 21 24 04 FF FC 00 44 10 24 3C 04 ?? ?? AC 83 ?? ?? 8F C3 00 30 AE 22 ?? ?? 24 64 ?? ?? 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 32 00 00 00 00 8E 42 00 08 00 50 80 21 0? ?? ?? ?? 8E 02 00 00 8F C4 00 30 24 82 ?? ?? 00 00 00 0F C0 43 00 00 24 01 00 00 E0 41 00 00 10 20 FF FC 00 00 00 00 28 63 00 02 14 60 FD D8 00 00 10 21 8F C3 00 30 24 64 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 10 21 10 C0 00 0E A0 43 00 00 0? ?? ?? ?? 24 42 00 01 14 C0 00 04 A0 43 00 00 A0 43 00 01 0? ?? ?? ?? 24 42 00 02 0? ?? ?? ?? 24 42 00 01 0? ?? ?? ?? 00 A0 10 21 0? ?? ?? ?? 02 C0 10 21 3C 05 ?? ?? A0 43 00 01 24 44 00 02 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 08 0? ?? ?? ?? A0 40 00 00 24 64 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8E 42 00 08 0? ?? ?? ?? AE 42 00 04 0? ?? ?? ?? 24 64 ?? ?? 0? ?? ?? ?? 3C 03 ?? ?? 0? ?? ?? ?? 00 00 30 21 3C 04 ?? ?? 24 84 ?? ?? 10 80 FE 6F 00 00 00 00 0? ?? ?? ?? 26 A4 00 40 0? ?? ?? ?? 24 02 FF FF 24 64 ?? ?? AF C3 00 30 C0 82 00 00 24 41 00 01 E0 81 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 10 40 00 03 00 00 00 00 0? ?? ?? ?? 24 64 ?? ?? 8E 42 00 08 10 40 00 16 24 05 00 04 8F C3 00 30 24 64 ?? ?? 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 00 09 8F C3 00 30 24 64 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8E 42 00 08 8E A4 00 20 0? ?? ?? ?? 02 24 20 21 14 40 FF 2C AE 42 00 08 24 02 FF FF 0? ?? ?? ?? AE 42 00 08 }
	condition:
		$1
}

rule file_215_4_0 {
	meta:
		name = "__dcigettext"
		size = 2024
		refs = "03c4 __pthread_rwlock_unlock 0004 __gnu_local_gp 0064 __pthread_rwlock_rdlock 0070 __libc_setlocale_lock 007c _nl_state_lock 00a8 __current_locale_name 00b4 strlen 00d4 memcpy 0104 __tfind 0138 _nl_msg_cat_cntr 0150 __libc_errno 015c _nl_domain_bindings 0194 _nl_default_dirname 019c strcmp 0210 __getcwd 022c __rawmemchr 0244 strcpy 0250 _nl_category_name_idxs 0260 $LC4 0264 _nl_category_names 0270 getenv 02ec stpcpy 0308 mempcpy 0310 $LC5 0368 $LC6 0388 _nl_find_domain 03ac _nl_find_msg 0544 __libc_enable_secure 0558 strchr 0090 _nl_current_default_domain 06d4 malloc 074c __pthread_rwlock_wrlock 078c __tsearch 07d0 free"
	strings:
		$1 = { 27 BD FF 70 3C 1C ?? ?? 27 9C ?? ?? AF BE 00 88 03 A0 F0 21 AF B3 00 74 AF BF 00 8C AF B7 00 84 AF B6 00 80 AF B5 00 7C AF B4 00 78 AF B2 00 70 AF B1 00 6C AF B0 00 68 AF DC 00 18 00 A0 98 21 AF C4 00 90 AF C6 00 98 10 A0 01 96 AF C7 00 9C 8F C3 00 A4 2C 62 00 0D 10 40 00 FF 24 02 00 06 10 62 00 FD 3C 10 ?? ?? 26 10 ?? ?? 12 00 00 06 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 8F C5 00 90 10 A0 01 72 3C 02 ?? ?? 8F C4 00 A4 8F C2 00 90 AF C0 00 30 AF C4 00 24 AF D3 00 3C 0? ?? ?? ?? AF C2 00 20 00 40 20 21 0? ?? ?? ?? 00 40 88 21 24 43 00 0F 00 03 18 C2 00 03 18 C0 03 A3 E8 23 27 A4 00 18 02 20 28 21 0? ?? ?? ?? 24 46 00 01 AF C2 00 58 12 00 00 04 AF C2 00 28 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 3C 02 ?? ?? 3C 03 ?? ?? 24 45 ?? ?? 27 C4 00 20 0? ?? ?? ?? 24 66 ?? ?? 3C 05 ?? ?? 24 A5 ?? ?? 8F DC 00 18 10 A0 00 05 AF C2 00 50 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 8F DC 00 18 8F C2 00 50 10 40 00 06 3C 03 ?? ?? 8C 42 00 00 8C 63 ?? ?? 8C 44 00 0C 10 83 01 34 8F C3 00 9C 8F 82 ?? ?? 7C 03 E8 3B AF C2 00 54 3C 02 ?? ?? 8C 51 ?? ?? 00 60 10 21 8F C3 00 54 00 62 10 21 8C 42 00 00 12 20 01 21 AF C2 00 60 0? ?? ?? ?? 8F D0 00 90 04 40 01 21 3C 15 ?? ?? 8E 31 00 00 12 20 01 1C 26 B5 ?? ?? 26 25 00 0C 0? ?? ?? ?? 02 00 20 21 14 40 FF F7 00 00 00 00 8E 23 00 04 24 02 00 2F AF C3 00 48 80 63 00 00 10 62 00 23 8F C4 00 48 24 14 10 02 0? ?? ?? ?? 24 12 00 22 8F C5 00 54 7C 03 E8 3B 24 50 00 01 0? ?? ?? ?? 00 A3 B0 21 8E C2 00 00 14 52 00 AE 02 83 A0 21 02 90 10 21 24 42 00 0E 00 02 10 C2 00 02 10 C0 03 A2 E8 23 27 B5 00 18 02 80 28 21 02 A0 20 21 0? ?? ?? ?? AE C0 00 00 00 14 18 42 10 40 FF F1 24 63 00 20 02 A0 20 21 00 00 28 21 0? ?? ?? ?? AF D5 00 48 24 03 00 2F A0 43 00 00 A0 40 00 01 8E 25 00 04 0? ?? ?? ?? 24 44 00 01 8F C3 00 A4 3C 02 ?? ?? 24 42 ?? ?? 00 62 10 21 90 42 00 00 3C 04 ?? ?? 3C 10 ?? ?? 24 84 ?? ?? 26 10 ?? ?? 0? ?? ?? ?? 02 02 80 21 10 40 00 DC 00 40 90 21 80 42 00 00 10 40 00 D9 00 00 00 00 0? ?? ?? ?? 8F C4 00 A4 90 43 00 00 00 40 B8 21 24 02 00 43 14 62 00 F0 00 00 00 00 92 E2 00 01 02 42 B8 0B 0? ?? ?? ?? 8F C4 00 90 02 00 20 21 0? ?? ?? ?? AF C2 00 5C 8F C3 00 5C 02 00 28 21 24 10 00 3A 00 62 10 21 24 42 00 13 00 02 10 C2 00 02 10 C0 03 A2 E8 23 27 A3 00 18 00 60 20 21 0? ?? ?? ?? AF C3 00 4C 8F C5 00 90 8F C6 00 5C 24 03 00 2F 24 44 00 01 A0 43 00 00 0? ?? ?? ?? A0 40 00 01 3C 03 ?? ?? 8C 63 ?? ?? 02 E0 20 21 A8 43 00 00 0? ?? ?? ?? B8 43 00 03 24 42 00 0F 00 02 10 C2 00 02 10 C0 03 A2 E8 23 27 B2 00 18 82 E2 00 00 10 50 00 8F 00 00 00 00 14 40 00 79 02 40 18 21 24 02 00 43 A2 42 00 00 A2 40 00 01 92 42 00 01 10 40 00 51 3C 02 ?? ?? 3C 05 ?? ?? 02 40 20 21 0? ?? ?? ?? 24 A5 ?? ?? 10 40 00 4A 8F C4 00 48 8F C6 00 4C 02 40 28 21 0? ?? ?? ?? 02 20 38 21 10 40 FF EA 00 40 A0 21 27 C3 00 40 AF A3 00 10 00 40 20 21 02 20 28 21 02 60 30 21 0? ?? ?? ?? 24 07 00 01 10 40 00 74 00 40 48 21 24 02 FF FF 11 22 00 39 3C 02 ?? ?? 8F C5 00 50 10 A0 00 B7 8F C3 00 50 8F C5 00 50 8C 62 00 00 3C 03 ?? ?? 8C 64 ?? ?? AC 54 00 10 8C A3 00 00 AC 44 00 0C AC 69 00 14 8C A2 00 00 8F C3 00 40 AC 43 00 18 7C 03 E8 3B 00 60 10 21 8F C3 00 54 8F C5 00 60 00 62 10 21 AC 45 00 00 8F C2 00 9C 14 40 00 93 8F C5 00 A0 3C 03 ?? ?? 24 63 ?? ?? 10 60 00 EC 3C 04 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? AF C9 00 64 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 8F C9 00 64 0? ?? ?? ?? 01 20 10 21 8F C5 00 9C 10 A0 00 24 8F C3 00 A0 24 02 00 01 10 62 00 21 8F C2 00 98 03 C0 E8 21 8F BF 00 8C 8F BE 00 88 8F B7 00 84 8F B6 00 80 8F B5 00 7C 8F B4 00 78 8F B3 00 74 8F B2 00 70 8F B1 00 6C 8F B0 00 68 03 E0 00 08 27 BD 00 90 3C 02 ?? ?? 24 42 ?? ?? 10 40 00 07 00 00 00 00 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 7C 03 E8 3B 00 60 10 21 8F C3 00 54 8F C5 00 60 00 62 10 21 AC 45 00 00 8F C2 00 9C 14 40 FF DE 8F C3 00 A0 03 C0 E8 21 8F DF 00 8C 02 60 10 21 8F BE 00 88 8F B7 00 84 8F B6 00 80 8F B5 00 7C 8F B4 00 78 8F B3 00 74 8F B2 00 70 8F B1 00 6C 8F B0 00 68 03 E0 00 08 27 BD 00 90 10 50 00 07 00 00 00 00 24 63 00 01 A0 62 FF FF 26 F7 00 01 82 E2 00 00 14 40 FF F9 3C 05 ?? ?? 8C A2 ?? ?? 10 40 00 06 A0 60 00 00 02 40 20 21 0? ?? ?? ?? 24 05 00 2F 14 40 FF 76 00 00 00 00 92 43 00 00 24 02 00 43 14 62 FF 7D 00 00 00 00 0? ?? ?? ?? 92 42 00 01 0? ?? ?? ?? 26 F7 00 01 8E 84 00 10 10 80 FF 6B 00 00 00 00 02 80 B0 21 0? ?? ?? ?? 00 00 A8 21 8E C4 00 10 10 80 FF 65 26 B5 00 01 27 C5 00 40 AF A5 00 10 02 60 30 21 02 20 28 21 0? ?? ?? ?? 24 07 00 01 24 03 FF FF 10 43 FF B6 26 D6 00 04 10 40 FF F3 00 40 48 21 26 A2 00 04 00 02 10 80 02 82 A0 21 0? ?? ?? ?? 8E 94 00 00 0? ?? ?? ?? 8F C4 00 A4 0? ?? ?? ?? 00 40 B8 21 3C 15 ?? ?? 26 B5 ?? ?? 0? ?? ?? ?? AF D5 00 48 26 B5 ?? ?? 00 00 88 21 0? ?? ?? ?? AF D5 00 48 14 60 00 19 00 00 00 00 8C 53 00 14 3C 05 ?? ?? 24 A5 ?? ?? 10 A0 FF AF 00 00 00 00 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 02 60 10 21 8C 42 ?? ?? 0? ?? ?? ?? AF C2 00 90 0? ?? ?? ?? 02 40 B8 21 8E 84 00 08 8F C7 00 40 0? ?? ?? ?? 01 20 30 21 0? ?? ?? ?? 00 40 48 21 8C 43 00 10 8C 46 00 14 8C 47 00 18 8C 64 00 08 0? ?? ?? ?? 8F C5 00 A0 0? ?? ?? ?? 00 40 98 21 0? ?? ?? ?? 00 00 10 21 02 60 20 21 0? ?? ?? ?? AF C9 00 64 8F C4 00 58 0? ?? ?? ?? 24 51 00 01 8F C3 00 5C 00 40 80 21 24 64 00 1E 00 82 20 21 0? ?? ?? ?? 00 91 20 21 00 40 90 21 10 40 FF 47 8F C9 00 64 02 60 28 21 02 20 30 21 0? ?? ?? ?? 24 44 00 1C 8F C3 00 5C 8F C5 00 90 00 40 20 21 24 71 00 01 02 20 30 21 00 40 98 21 0? ?? ?? ?? 00 51 88 21 8F C5 00 58 02 20 20 21 0? ?? ?? ?? 26 06 00 01 3C 02 ?? ?? 8C 42 ?? ?? 8F C9 00 64 8F C5 00 A4 AE 42 00 0C 8F C2 00 40 AE 53 00 00 AE 45 00 04 AE 42 00 18 3C 02 ?? ?? 24 42 ?? ?? AE 51 00 08 AE 54 00 10 10 40 00 06 AE 49 00 14 3C 04 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? AF C9 00 64 8F C9 00 64 3C 02 ?? ?? 3C 03 ?? ?? 24 45 ?? ?? 02 40 20 21 24 66 ?? ?? 0? ?? ?? ?? AF C9 00 64 3C 05 ?? ?? 24 A5 ?? ?? 00 40 80 21 10 A0 00 05 8F C9 00 64 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 8F C9 00 64 12 00 00 04 00 00 00 00 8E 02 00 00 12 42 FF 0E 00 00 00 00 02 40 20 21 0? ?? ?? ?? AF C9 00 64 0? ?? ?? ?? 8F C9 00 64 0? ?? ?? ?? 01 20 10 21 }
	condition:
		$1
}

rule file_215_5_0 {
	meta:
		name = "free_mem"
		size = 208
		refs = "0008 _nl_domain_bindings 0020 _nl_default_dirname 0038 free 005c _nl_current_default_domain 0064 _nl_default_default_domain 0088 __tdestroy"
	strings:
		$1 = { 27 BD FF D8 AF B1 00 1C 3C 11 ?? ?? AF B0 00 18 8E 30 ?? ?? AF BF 00 24 12 00 00 10 AF B2 00 20 3C 12 ?? ?? 26 52 ?? ?? 8E 02 00 00 8E 04 00 04 10 92 00 03 AE 22 ?? ?? 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 8E 04 00 08 0? ?? ?? ?? 02 00 20 21 8E 30 ?? ?? 16 00 FF F4 00 00 00 00 3C 02 ?? ?? 8C 44 ?? ?? 3C 02 ?? ?? 24 42 ?? ?? 10 82 00 03 3C 10 ?? ?? 0? ?? ?? ?? 00 00 00 00 8E 04 ?? ?? 3C 05 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 3C 11 ?? ?? 8E 24 ?? ?? 14 80 00 03 AE 00 ?? ?? 0? ?? ?? ?? 8F BF 00 24 8C 90 00 00 0? ?? ?? ?? AE 30 ?? ?? 16 00 FF FC 02 00 20 21 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_217_0_0 {
	meta:
		name = "__gconv"
		size = 680
		refs = "00e0 _dl_mcount_wrapper_check 0268 $LC2 026c $LC1 0280 __assert_fail 0270 __PRETTY_FUNCTION__.8309 0288 $LC0"
	strings:
		$1 = { 27 BD FF A8 24 02 FF FF AF B4 00 40 AF B0 00 30 AF BF 00 54 AF BE 00 50 AF B7 00 4C AF B6 00 48 AF B5 00 44 AF B3 00 3C AF B2 00 38 AF B1 00 34 00 80 80 21 10 82 00 4E 8F B4 00 6C 8C 95 00 00 12 80 00 91 26 B5 FF FF 00 A0 88 21 00 C0 98 21 00 E0 B8 21 10 E0 00 80 AE 80 00 00 8C E4 00 00 00 15 18 80 AF A3 00 28 8F A5 00 28 00 15 C9 40 8E 03 00 04 00 B9 10 21 02 02 10 21 AC 44 00 08 8F A4 00 68 AF B9 00 2C 8C 72 00 14 12 20 00 46 AC 44 00 0C 8E 3E 00 00 13 C0 00 43 00 00 00 00 12 E0 00 71 26 16 00 08 8E E2 00 00 14 40 00 0C 24 15 00 04 0? ?? ?? ?? 3C 04 ?? ?? 8E 23 00 00 10 7E 00 15 00 00 00 00 8E 04 00 04 8C 84 00 24 00 64 20 21 02 64 20 2B 14 80 00 0F 00 60 F0 21 0? ?? ?? ?? 02 40 20 21 8E 04 00 04 02 C0 28 21 AF A0 00 10 AF B4 00 14 AF A0 00 18 AF A0 00 1C 02 20 30 21 02 40 C8 21 03 20 F8 09 02 60 38 21 10 55 FF EA 00 00 00 00 8E E3 00 00 10 60 00 50 8F B9 00 2C 8F A3 00 28 00 79 F0 21 02 1E 80 21 8E 04 00 08 00 40 18 21 AE E4 00 00 8F BF 00 54 8F BE 00 50 8F B7 00 4C 8F B6 00 48 8F B5 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 00 60 10 21 03 E0 00 08 27 BD 00 58 8F BF 00 54 24 03 00 08 8F BE 00 50 8F B7 00 4C 8F B6 00 48 8F B5 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 00 60 10 21 03 E0 00 08 27 BD 00 58 0? ?? ?? ?? 02 40 20 21 8F B9 00 28 8F A3 00 2C 8E 04 00 04 00 00 30 21 03 23 10 21 02 02 10 21 8C 45 00 08 24 03 00 01 24 02 00 02 00 65 10 0B AF A0 00 10 AF B4 00 14 AF A2 00 18 AF A0 00 1C 26 05 00 08 02 40 C8 21 03 20 F8 09 00 00 38 21 14 40 00 08 00 00 00 00 02 00 20 21 00 00 18 21 24 63 00 01 02 A3 28 2B AC 80 00 14 10 A0 FF FC 24 84 00 24 16 E0 FF BE 00 40 18 21 8F BF 00 54 8F BE 00 50 8F B7 00 4C 8F B6 00 48 8F B5 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 00 60 10 21 03 E0 00 08 27 BD 00 58 0? ?? ?? ?? 00 00 20 21 0? ?? ?? ?? 00 40 18 21 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 4A 0? ?? ?? ?? 24 E7 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 2C 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_218_0_0 {
	meta:
		name = "_IO_getdelim"
		size = 904
		refs = "0000 __gnu_local_gp 00ec malloc 0128 realloc 014c memcpy 0164 __underflow 018c memchr 0244 __lll_lock_wait_private 02d8 __libc_errno 0334 _Unwind_Resume"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF B8 27 9C ?? ?? AF B4 00 30 AF BF 00 44 AF BE 00 40 AF B7 00 3C AF B6 00 38 AF B5 00 34 AF B3 00 2C AF B2 00 28 AF B1 00 24 AF B0 00 20 AF BC 00 10 00 80 A0 21 10 80 00 A4 AF A6 00 50 10 A0 00 A2 00 A0 A8 21 8C E2 00 00 00 E0 88 21 30 44 80 00 14 80 00 1A 00 40 18 21 7C 03 E8 3B 8C E4 00 48 24 70 8B 70 8C 83 00 08 10 70 00 10 00 00 00 00 AF A0 00 18 C0 83 00 00 14 60 00 06 24 02 00 00 24 01 00 01 E0 81 00 00 10 20 FF FA 24 02 00 01 00 00 00 0F 10 40 00 69 00 00 00 00 8E 23 00 48 8E 22 00 00 00 60 20 21 AC 70 00 08 8C 85 00 04 00 40 18 21 24 A5 00 01 AC 85 00 04 30 42 00 20 14 40 00 45 24 13 FF FF 8E 82 00 00 10 40 00 04 24 02 00 78 8E A2 00 00 14 40 00 06 24 02 00 78 AE A2 00 00 0? ?? ?? ?? 24 04 00 78 10 40 00 73 AE 82 00 00 8E 32 00 04 8E 30 00 08 02 12 80 23 1A 00 00 65 00 00 00 00 0? ?? ?? ?? 00 00 F0 21 00 45 30 2B 00 A0 B0 21 8E 84 00 00 00 46 B0 0A 0? ?? ?? ?? 02 C0 28 21 10 40 00 64 00 40 20 21 AE 82 00 00 8E 32 00 04 AE B6 00 00 02 00 30 21 00 9E 20 21 0? ?? ?? ?? 02 40 28 21 8E 22 00 04 00 50 80 21 16 E0 00 34 AE 30 00 04 0? ?? ?? ?? 02 20 20 21 24 03 FF FF 10 43 00 2F 02 60 F0 21 8E 32 00 04 8E 30 00 08 02 12 80 23 8F A5 00 50 02 40 20 21 0? ?? ?? ?? 02 00 30 21 00 40 B8 21 10 40 00 03 8F BC 00 10 00 52 80 23 26 10 00 01 3C 03 7F FF 34 63 FF FF 00 7E 10 23 02 02 10 2A 10 40 00 4D 24 13 FF FF 8E A4 00 00 03 D0 98 21 26 62 00 01 00 82 28 2B 14 A0 FF D1 00 04 28 40 0? ?? ?? ?? 8E 84 00 00 30 63 80 00 14 60 00 06 02 60 10 21 8E 24 00 48 8C 83 00 04 24 63 FF FF 10 60 00 16 AC 83 00 04 8F BF 00 44 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 48 8E 82 00 00 00 53 10 21 A0 40 00 00 0? ?? ?? ?? 8E 23 00 00 0? ?? ?? ?? AF A3 00 18 0? ?? ?? ?? 8E 23 00 48 AC 80 00 08 00 00 00 0F C0 83 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 63 00 02 14 60 FF E2 02 60 10 21 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 02 60 10 21 0? ?? ?? ?? 02 20 20 21 24 03 FF FF 10 43 00 05 00 00 00 00 8E 32 00 04 8E 30 00 08 0? ?? ?? ?? 02 12 80 23 8E 23 00 00 0? ?? ?? ?? 24 13 FF FF 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 16 AC 43 00 00 0? ?? ?? ?? 24 02 FF FF 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 4F AC 43 00 00 0? ?? ?? ?? 8E 23 00 00 8E 22 00 00 30 42 80 00 14 40 00 06 00 80 80 21 8E 24 00 48 8C 83 00 04 24 63 FF FF 10 60 00 03 AC 83 00 04 0? ?? ?? ?? 02 00 20 21 AC 80 00 08 00 00 00 0F C0 83 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 63 00 02 14 60 FF F5 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_219_0_0 {
	meta:
		name = "check_match.9290"
		size = 512
		refs = "0064 strcmp 01d0 _dl_name_match_p 01e0 $LC0 01e4 $LC1 01f8 __assert_fail 01e8 __PRETTY_FUNCTION__.9293"
	strings:
		$1 = { 27 BD FF D0 AF B1 00 20 AF B0 00 1C AF BF 00 2C AF B3 00 28 AF B2 00 24 90 83 00 0C 8C 82 00 04 00 80 80 21 01 E0 88 21 10 40 00 61 30 63 00 0F 96 02 00 0E 10 40 00 30 24 02 04 67 00 62 18 07 30 63 00 01 10 60 00 35 00 00 10 21 8E 22 00 20 12 02 00 08 00 00 00 00 8E 24 00 1C 8E 02 00 00 8E 25 00 18 0? ?? ?? ?? 00 82 20 21 14 40 00 2A 00 00 00 00 8E 25 00 14 8E 32 00 10 12 40 00 35 8C A2 02 78 10 40 00 4F 00 00 00 00 8E 26 00 0C 8C A4 02 44 8E 43 00 04 00 06 28 40 00 45 10 21 94 53 00 00 32 62 7F FF 00 02 11 00 00 82 10 21 8C 51 00 04 12 23 00 20 00 00 00 00 8E 42 00 08 14 40 00 15 00 00 00 00 16 20 00 13 7C 13 9E 20 06 60 00 12 00 00 10 21 02 00 10 21 8F BF 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 30 92 02 00 0D 30 42 00 08 10 40 00 06 00 00 10 21 8E 22 00 24 30 42 00 01 10 40 FF CA 24 02 04 67 00 00 10 21 8F BF 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 30 8C 44 00 00 0? ?? ?? ?? 8E 45 00 00 10 40 FF E4 00 00 00 00 0? ?? ?? ?? 8E 42 00 08 10 40 FF E0 24 05 00 03 8E 23 00 0C 8E 26 00 08 00 03 18 40 00 43 10 21 94 43 00 00 30 C6 00 02 24 02 00 02 30 64 7F FF 00 A6 10 0A 00 82 10 2A 14 40 FF D5 02 00 10 21 7C 03 1E 20 04 60 FF E2 00 00 10 21 8E 22 00 04 24 43 00 01 14 40 FF DD AE 23 00 04 0? ?? ?? ?? AE 30 00 00 24 02 00 06 10 62 FF 9E 00 00 10 21 0? ?? ?? ?? 8F BF 00 2C 8E 44 00 0C 10 80 FF C4 02 00 10 21 0? ?? ?? ?? 00 00 00 00 10 40 FF C0 02 00 10 21 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 B9 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_219_1_0 {
	meta:
		name = "do_lookup_x"
		size = 2380
		refs = "0068 $LC3 0078 _dl_debug_mask 0180 _dl_name_match_p 0284 _dl_ns 02ac __pthread_mutex_lock 0348 strcmp 0378 __pthread_mutex_unlock 007c _dl_dynamic_weak 0474 _dl_higher_prime_number 0484 calloc 0544 free 0088 _dl_argv 008c $LC2 06e4 _dl_debug_printf 0878 _dl_dprintf 0870 $LC4 0880 _exit"
	strings:
		$1 = { 27 BD FF 70 8F A3 00 AC 8F A2 00 A4 AF B6 00 80 AF A3 00 28 8F A3 00 B0 AF B5 00 7C AF B4 00 78 AF A3 00 20 8F A3 00 B8 AF B0 00 68 AF BF 00 8C AF BE 00 88 AF B7 00 84 AF B3 00 74 AF B2 00 70 AF B1 00 6C 8C 54 00 04 00 A0 B0 21 00 C0 50 21 8F B0 00 A8 8F B5 00 B4 AF A4 00 30 AF A7 00 38 AF A3 00 3C 8C 51 00 00 3C 0D ?? ?? 00 10 10 80 00 05 41 42 02 22 88 21 3C 17 ?? ?? 3C 09 ?? ?? 30 BE 00 1F 25 AD ?? ?? 3C 0C ?? ?? 3C 12 ?? ?? 8E 22 00 00 AF A0 00 1C AF A0 00 18 8C 42 00 14 10 55 00 3F AF A2 00 2C 8F A3 00 3C 30 63 00 02 14 60 00 4C 3C 04 C0 00 8C 43 02 68 7C 63 04 80 14 60 00 37 8E E3 ?? ?? 30 63 00 08 14 60 01 77 00 00 00 00 8C 43 02 4C 10 60 00 31 00 00 00 00 8C 46 00 34 8C 44 00 38 8C 45 00 00 8C C6 00 04 8C 87 00 04 8C 44 02 58 00 C5 30 21 AF A6 00 34 10 80 01 81 00 A7 28 21 8C 47 02 50 8C 46 02 54 01 07 38 24 00 07 38 80 00 87 20 21 8C 84 00 00 00 D6 30 06 00 C4 30 06 03 C4 20 06 00 C4 20 24 30 84 00 01 14 80 01 D6 00 00 00 00 AF A0 00 24 8F A3 00 1C 24 02 00 01 10 62 00 30 8F B3 00 18 8F A2 00 24 14 40 00 12 8F A2 00 28 10 40 00 10 00 00 00 00 8C 44 00 0C 10 80 00 0D 8F A5 00 2C AF A8 00 54 AF A9 00 5C AF AA 00 58 AF AC 00 64 0? ?? ?? ?? AF AD 00 60 8F A8 00 54 8F A9 00 5C 8F AA 00 58 8F AC 00 64 14 40 01 AD 8F AD 00 60 26 10 00 01 02 14 10 2B 14 40 FF B9 26 31 00 04 8F BF 00 8C 8F BE 00 88 8F B7 00 84 8F B6 00 80 8F B5 00 7C 8F B4 00 78 8F B3 00 74 8F B2 00 70 8F B1 00 6C 8F B0 00 68 00 00 10 21 03 E0 00 08 27 BD 00 90 8C 43 02 68 00 64 20 24 14 80 FF B3 00 00 00 00 26 10 00 01 02 14 10 2B 14 40 FF A4 26 31 00 04 0? ?? ?? ?? 8F BF 00 8C 12 60 FF D1 8F A2 00 24 92 62 00 0C 24 03 00 02 00 02 11 02 10 43 00 5D 24 03 00 0A 10 43 00 15 24 03 00 01 14 43 FF C8 8F A2 00 24 8F A3 00 A0 8F A4 00 A0 24 02 00 01 AC 73 00 00 8F A3 00 2C AC 83 00 04 8F BF 00 8C 8F BE 00 88 8F B7 00 84 8F B6 00 80 8F B5 00 7C 8F B4 00 78 8F B3 00 74 8F B2 00 70 8F B1 00 6C 8F B0 00 68 03 E0 00 08 27 BD 00 90 8F A2 00 2C 3C 11 ?? ?? 26 31 ?? ?? 8C 42 00 18 00 02 20 80 00 02 19 00 00 83 18 21 00 62 10 23 00 02 10 80 24 42 00 10 02 22 88 21 3C 02 ?? ?? 24 42 ?? ?? 10 40 00 03 AF B1 00 40 0? ?? ?? ?? 02 20 20 21 8F A3 00 40 8C 63 00 18 AF A3 00 44 8F A3 00 40 8C 72 00 1C 8F A3 00 44 10 60 00 CE 26 46 FF FE 02 C6 00 1B 00 C0 01 F4 8F B7 00 30 00 00 10 10 24 5E 00 01 00 1E A1 00 02 D2 00 1B 02 40 01 F4 00 00 18 10 AF A3 00 48 00 60 A8 21 8F A3 00 44 00 15 81 00 00 70 80 21 8E 02 00 00 10 56 00 08 8E 11 00 04 12 20 00 25 02 BE A8 21 02 B2 10 2B 14 40 FF F9 02 14 80 21 0? ?? ?? ?? 02 B2 A8 23 02 E0 28 21 0? ?? ?? ?? 02 20 20 21 14 40 FF F5 8F A2 00 3C 30 42 00 02 14 40 00 AA 8F A3 00 A0 8E 03 00 08 8E 02 00 0C 8F A4 00 A0 AC 83 00 00 AC 82 00 04 3C 02 ?? ?? 24 42 ?? ?? 10 40 01 41 00 00 00 00 0? ?? ?? ?? 8F A4 00 40 0? ?? ?? ?? 24 02 00 01 8D 22 ?? ?? 10 40 FF A7 8F A3 00 A0 8C 62 00 00 14 40 FF 6A 8F A2 00 24 8F A2 00 2C AC 73 00 00 0? ?? ?? ?? AC 62 00 04 8F A3 00 40 8C 67 00 20 00 12 18 40 00 72 18 21 00 07 10 80 00 43 10 2B 10 40 00 26 03 C0 30 21 8F BE 00 48 8F A2 00 3C 30 42 00 02 10 40 00 64 00 00 00 00 8E 62 00 00 8F AA 00 34 8F A9 00 38 00 06 29 00 01 42 50 21 8F A3 00 44 00 1E 11 00 00 62 10 21 0? ?? ?? ?? 24 42 00 04 03 C6 F0 21 03 D2 18 2B 10 60 00 76 00 45 10 21 8C 43 00 00 14 60 FF FA 24 44 FF FC AC 56 FF FC AC 4A 00 00 AC 49 00 04 8F A2 00 BC AC 82 00 0C 8F A3 00 40 3C 02 ?? ?? 24 E7 00 01 24 42 ?? ?? 10 40 FF 76 AC 67 00 20 0? ?? ?? ?? 00 60 20 21 0? ?? ?? ?? 8F A3 00 A0 0? ?? ?? ?? 26 44 00 01 00 40 28 21 24 04 00 10 0? ?? ?? ?? 00 40 80 21 10 40 00 F2 00 40 A8 21 12 40 00 23 26 17 FF FE 8F AA 00 44 00 00 60 21 8D 4D 00 04 11 A0 00 1B 00 00 00 00 8D 4B 00 00 8D 4E 00 08 8D 42 00 0C 01 77 00 1B 02 E0 01 F4 00 00 28 10 24 A5 00 01 00 05 49 00 01 70 00 1B 02 00 01 F4 00 00 30 10 00 06 19 00 02 A3 18 21 0? ?? ?? ?? 24 63 00 04 00 D0 38 2B 10 E0 00 21 00 69 18 21 8C 67 00 00 14 E0 FF FB 00 C5 30 21 00 C5 30 23 AC 6B FF FC AC 6D 00 00 AC 6E 00 04 AC 62 00 08 25 8C 00 01 15 92 FF E1 25 4A 00 10 8F A3 00 40 8F A4 00 44 8C 79 00 24 03 20 F8 09 02 00 90 21 02 D0 00 1B 02 00 01 F4 8F A3 00 40 3C 02 ?? ?? 24 42 ?? ?? AC 70 00 1C AC 75 00 18 AC 62 00 24 AF B5 00 44 8C 67 00 20 00 00 F0 10 02 D7 00 1B 02 E0 01 F4 00 00 30 10 0? ?? ?? ?? 24 C6 00 01 0? ?? ?? ?? 00 D0 30 23 8E 62 00 00 8F AA 00 34 8F A9 00 2C 00 06 29 00 01 42 50 21 8F A3 00 44 00 1E 11 00 00 62 10 21 0? ?? ?? ?? 24 42 00 04 03 C6 F0 21 03 D2 18 2B 10 60 00 11 00 45 10 21 8C 43 00 00 14 60 FF FA 24 44 FF FC 8D 23 02 68 3C 02 C0 00 AC 96 00 00 00 62 18 24 3C 02 80 00 AC 8A 00 04 AC 93 00 08 14 62 FF 9A AC 89 00 0C 8D 22 02 DC 34 42 00 08 0? ?? ?? ?? AD 22 02 DC 0? ?? ?? ?? 03 D2 F0 23 0? ?? ?? ?? 03 D2 F0 23 8F A2 00 2C AC 73 00 00 0? ?? ?? ?? AC 62 00 04 24 04 00 10 0? ?? ?? ?? 24 05 00 1F 10 40 00 8C AF A2 00 44 3C 03 08 42 24 63 10 85 02 C3 00 19 8F A4 00 40 24 12 00 1F AC 82 00 18 24 02 00 1F AC 82 00 1C 3C 02 ?? ?? 24 42 ?? ?? AC 82 00 24 3C 02 8D 3D 34 42 CB 09 8C 87 00 20 00 00 18 10 02 C3 20 23 00 04 20 42 02 C2 00 19 00 64 18 21 00 03 19 02 00 03 21 40 00 83 18 23 02 C3 F0 23 00 00 10 10 00 02 11 02 00 02 18 80 00 02 21 40 00 83 18 23 00 62 10 21 02 C2 30 23 0? ?? ?? ?? 24 C6 00 01 8C 46 00 04 80 C3 00 00 14 60 00 04 8D 84 ?? ?? 26 43 ?? ?? 8C 86 00 00 00 66 30 0A 8C 47 00 18 8F A5 00 30 01 A0 20 21 AF A8 00 54 AF A9 00 5C AF AA 00 58 AF AC 00 64 0? ?? ?? ?? AF AD 00 60 8F A2 00 2C 8F AD 00 60 8F AC 00 64 8F AA 00 58 8F A9 00 5C 0? ?? ?? ?? 8F A8 00 54 8D 44 00 00 24 06 FF FF 10 86 00 28 8F A7 00 30 00 83 00 1B 00 60 01 F4 00 00 30 10 00 06 30 80 8C 42 02 60 00 46 30 21 8C C2 00 00 14 40 00 0B AF A2 00 24 0? ?? ?? ?? 8F A3 00 1C 8F A2 00 2C 8C 43 02 5C 8F A2 00 24 00 02 10 80 00 62 10 21 8C 42 00 00 10 40 FE 78 AF A2 00 24 00 02 21 00 00 A4 20 21 27 AF 00 18 AF A5 00 50 AF A8 00 54 AF A9 00 5C AF AA 00 58 AF AC 00 64 0? ?? ?? ?? AF AD 00 60 00 40 98 21 8F A5 00 50 8F A8 00 54 8F A9 00 5C 8F AA 00 58 8F AC 00 64 10 40 FF E7 8F AD 00 60 0? ?? ?? ?? 92 62 00 0C 90 E4 00 00 10 80 00 23 00 00 30 21 90 E6 00 01 10 C0 00 1C 00 00 00 00 90 EE 00 02 00 04 21 00 11 C0 00 18 00 86 20 21 90 E6 00 03 00 04 21 00 10 C0 00 14 00 8E 20 21 90 EE 00 04 00 04 21 00 11 C0 00 10 00 86 20 21 90 E6 00 05 00 04 21 00 00 8E 20 21 10 C0 00 0A 24 E7 00 05 3C 0E F0 00 00 04 21 00 24 E7 00 01 00 C4 20 21 90 E6 00 00 00 8E 78 24 00 0F 7E 02 14 C0 FF F9 01 E4 20 26 7C 84 D8 00 00 83 00 1B 00 60 01 F4 00 00 30 10 00 06 30 80 0? ?? ?? ?? AD 44 00 00 0? ?? ?? ?? 24 02 FF FF 3C 02 ?? ?? 24 42 ?? ?? 10 40 00 03 00 00 00 00 0? ?? ?? ?? 8F A4 00 40 3C 05 ?? ?? 24 04 00 02 0? ?? ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 04 00 7F 0? ?? ?? ?? 24 02 00 01 02 C3 00 1B 00 60 01 F4 8C 44 02 5C 00 00 30 10 00 06 18 80 00 83 18 21 8C 64 00 00 10 80 FE 23 00 04 20 80 8C 43 02 60 0? ?? ?? ?? 00 64 18 21 30 42 00 01 14 40 FE 1D 24 63 00 04 8C 62 00 00 00 56 20 26 00 04 20 42 14 80 FF FA 30 42 00 01 8F A2 00 2C 27 AF 00 18 8C 42 02 60 AF A3 00 4C AF A5 00 50 00 62 10 23 00 02 10 83 00 02 21 00 00 A4 20 21 AF A8 00 54 AF A9 00 5C AF AA 00 58 AF AC 00 64 AF AD 00 60 0? ?? ?? ?? AF A2 00 24 00 40 98 21 8F A3 00 4C 8F A5 00 50 8F A8 00 54 8F A9 00 5C 8F AA 00 58 8F AC 00 64 14 40 FE 35 8F AD 00 60 0? ?? ?? ?? 8C 62 00 00 }
	condition:
		$1
}

rule file_219_2_0 {
	meta:
		name = "elf_machine_matches_host"
		size = 56
	strings:
		$1 = { 8C 83 00 24 30 63 04 20 14 60 00 07 00 00 10 21 94 83 00 12 24 04 00 08 10 64 00 05 24 04 00 0A 10 64 00 03 00 00 00 00 03 E0 00 08 00 00 00 00 03 E0 00 08 24 02 00 01 }
	condition:
		$1
}

rule file_219_3_0 {
	meta:
		name = "_dl_lookup_symbol_x"
		size = 2940
		refs = "0b70 _dl_debug_mask 07d8 __pthread_mutex_lock 02d8 _dl_argv 02ec $LC2 0304 $LC14 02fc $LC7 030c $LC8 0314 $LC13 0340 $LC6 0360 strlen 039c stpcpy 03a8 $LC15 03b8 _dl_signal_cerror 02c0 $LC12 0404 $LC1 0418 __assert_fail 0408 __PRETTY_FUNCTION__.9484 0098 $LC11 0534 $LC9 054c _dl_debug_printf 053c $LC18 0564 _dl_debug_printf_c 0560 $LC19 0610 undefined_msg 0690 $LC16 06cc $LC5 0758 _dl_load_lock 077c _dl_ns 0880 __pthread_mutex_unlock 08d0 _dl_lookup_symbol_x 09a4 $LC20 0a04 $LC10 0ac0 $LC17 0af0 malloc 0b2c memcpy 0b64 _dl_scope_free"
	strings:
		$1 = { 27 BD FF 50 AF BE 00 A8 AF B5 00 9C AF B3 00 94 AF B2 00 90 AF B1 00 8C AF B0 00 88 AF BF 00 AC AF B7 00 A4 AF B6 00 A0 AF B4 00 98 90 82 00 00 03 A0 F0 21 00 80 88 21 00 A0 A8 21 00 C0 80 21 AF C7 00 BC 8F D2 00 C0 10 40 00 8F 8F D3 00 CC 00 80 18 21 24 16 15 05 00 16 21 40 00 96 B0 21 24 63 00 01 00 56 B0 21 90 62 00 00 14 40 FF FB 00 16 21 40 24 02 FF FF AF C2 00 60 AF C0 00 58 12 40 00 06 AF C0 00 5C 8F C3 00 C8 24 02 FF FA 00 62 10 24 14 40 00 E6 3C 04 ?? ?? 16 60 00 CB 8F C4 00 BC AF C0 00 68 8C 82 00 00 10 40 01 31 00 00 00 00 8F C4 00 68 8F D4 00 BC 0? ?? ?? ?? 27 D7 00 58 14 40 00 7A 00 00 00 00 26 94 00 04 8E 82 00 00 10 40 00 12 00 00 20 21 8E 07 00 00 AF A2 00 14 AF A4 00 18 8F C2 00 C4 8F C4 00 C8 AF B7 00 10 AF B2 00 1C AF A4 00 20 AF B3 00 24 AF A2 00 28 AF B5 00 2C 02 20 20 21 02 C0 28 21 0? ?? ?? ?? 27 C6 00 60 18 40 FF EA 00 00 00 00 8F C2 00 58 10 40 01 13 00 00 00 00 8E 07 00 00 10 E0 00 06 00 00 00 00 90 E3 00 0D 24 02 00 03 30 63 00 03 10 62 00 20 8F C3 00 C4 8F D7 00 5C AF C0 00 68 8E E4 02 68 3C 02 C0 00 3C 03 80 00 00 82 20 24 10 83 00 BD 02 E0 10 21 8C 43 02 D4 10 60 00 B8 24 03 00 01 3C 03 ?? ?? 8C 63 ?? ?? 30 64 08 04 14 80 00 D2 30 63 00 04 8F C3 00 58 AE 03 00 00 03 C0 E8 21 8F BF 00 AC 8F BE 00 A8 8F B7 00 A4 8F B6 00 A0 8F B5 00 9C 8F B4 00 98 8F B3 00 94 8F B2 00 90 8F B1 00 8C 8F B0 00 88 03 E0 00 08 27 BD 00 B0 24 02 00 01 10 62 00 30 8F C4 00 BC AF C0 00 38 AF C0 00 3C 8C 82 00 00 10 40 01 38 24 03 00 01 00 80 B8 21 27 C9 00 38 0? ?? ?? ?? 8F C6 00 68 26 F7 00 04 8E E2 00 00 10 40 00 14 00 00 30 21 8E 07 00 00 AF A2 00 14 8F C2 00 C8 AF A9 00 10 AF A6 00 18 AF A3 00 28 AF B2 00 1C AF A2 00 20 AF B3 00 24 AF A0 00 2C 02 20 20 21 02 C0 28 21 27 C6 00 60 AF C3 00 80 0? ?? ?? ?? AF C9 00 7C 8F C3 00 80 10 40 FF EA 8F C9 00 7C 8F C2 00 38 10 40 01 1A 00 00 00 00 8F C2 00 3C 10 55 01 17 00 00 00 00 8E 02 00 00 AF D5 00 5C 02 A0 B8 21 AF C2 00 58 24 03 00 01 0? ?? ?? ?? AF C3 00 68 0? ?? ?? ?? 24 16 15 05 8F C2 00 5C 10 55 00 62 24 03 00 01 AF C7 00 58 AF D5 00 5C 02 A0 B8 21 0? ?? ?? ?? AF C3 00 68 16 60 FF 87 26 94 00 04 26 94 FF FC 12 40 00 51 3C 04 ?? ?? 12 A0 00 02 00 00 98 21 8E B3 00 04 82 63 00 00 14 60 00 07 3C 03 ?? ?? 8C 63 ?? ?? 8C 73 00 00 16 60 00 03 00 00 00 00 3C 13 ?? ?? 26 73 ?? ?? 8E 43 00 0C 8E 44 00 00 3C 14 ?? ?? AF C3 00 4C 3C 03 ?? ?? 24 63 ?? ?? 3C 05 ?? ?? AF C4 00 44 3C 04 ?? ?? 26 94 ?? ?? 24 A5 ?? ?? 24 84 ?? ?? AF C3 00 50 24 03 FF FE AF D4 00 38 AF D1 00 3C AF C5 00 40 10 43 00 E4 AF C4 00 48 3C 02 ?? ?? 24 42 ?? ?? AF C2 00 54 27 D1 00 3C 24 02 00 07 0? ?? ?? ?? 24 12 00 01 8E 24 00 00 0? ?? ?? ?? 26 31 00 04 16 F1 FF FC 02 42 90 21 26 42 00 0E 00 02 10 C2 00 02 10 C0 03 A2 E8 23 27 B2 00 30 27 D1 00 3C 02 40 10 21 0? ?? ?? ?? 02 80 28 21 8E 25 00 00 26 31 00 04 0? ?? ?? ?? 00 40 20 21 16 F1 FF FB 3C 06 ?? ?? 00 00 20 21 02 60 28 21 24 C6 ?? ?? 0? ?? ?? ?? 02 40 38 21 AE 00 00 00 0? ?? ?? ?? 00 00 10 21 8F C3 00 BC 8C 62 00 00 8C 43 00 00 8C 64 00 00 10 93 00 1B 24 63 00 04 AF C0 00 68 00 00 20 21 24 63 00 04 8C 65 FF FC 14 B3 FF FD 24 84 00 01 0? ?? ?? ?? AF C4 00 68 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 02 FE 0? ?? ?? ?? 24 E7 ?? ?? 24 04 00 01 02 A0 B8 21 0? ?? ?? ?? AF C4 00 68 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 02 E8 0? ?? ?? ?? 24 E7 ?? ?? 0? ?? ?? ?? AF C0 00 68 0? ?? ?? ?? AC 43 02 D4 8F C2 00 C8 30 43 00 01 10 60 FF 41 02 E0 10 21 12 B7 00 AE 00 00 00 00 8E E3 02 DC 30 63 00 08 14 60 FF 3B 00 00 00 00 8E A3 02 CC AF C3 00 6C 00 00 00 0F 8E A4 02 C8 10 80 00 90 AF C4 00 70 8C 82 00 00 10 40 00 8D 00 00 00 00 10 57 FF 30 8F C2 00 5C 24 82 00 04 8C 43 00 00 10 60 00 87 00 00 00 00 14 77 FF FC 24 42 00 04 0? ?? ?? ?? 8F C2 00 5C 10 60 FF 2E 8E A5 00 04 80 A3 00 00 14 60 00 07 3C 03 ?? ?? 8C 63 ?? ?? 8C 65 00 00 14 A0 00 03 00 00 00 00 3C 05 ?? ?? 24 A5 ?? ?? 8C 47 00 04 80 E3 00 00 14 60 00 08 8E A6 00 18 3C 03 ?? ?? 8C 63 ?? ?? 8C 67 00 00 14 E0 00 04 8F C4 00 68 3C 07 ?? ?? 24 E7 ?? ?? 8F C4 00 68 10 80 01 35 8C 43 00 18 3C 02 ?? ?? 24 42 ?? ?? 3C 04 ?? ?? AF A3 00 10 AF A2 00 14 AF B1 00 18 0? ?? ?? ?? 24 84 ?? ?? 12 40 01 13 00 00 00 00 8E 45 00 00 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 8F C2 00 5C 8E 02 00 00 10 40 00 06 00 00 00 00 90 43 00 0C 24 02 00 02 00 03 19 02 10 62 00 03 00 00 00 00 12 60 00 04 00 00 00 00 AE 00 00 00 0? ?? ?? ?? 00 00 10 21 3C 02 ?? ?? 8C 42 ?? ?? 30 42 01 00 14 40 FF F9 00 00 00 00 12 A0 00 38 3C 04 ?? ?? 8E A4 00 04 12 40 00 22 00 00 00 00 8E 42 00 00 3C 03 ?? ?? 14 40 00 03 24 63 ?? ?? 3C 02 ?? ?? 24 42 ?? ?? 80 85 00 00 14 A0 00 08 00 80 90 21 3C 04 ?? ?? 8C 84 ?? ?? 8C 92 00 00 16 40 00 04 3C 15 ?? ?? 3C 12 ?? ?? 26 52 ?? ?? 3C 15 ?? ?? 26 B5 ?? ?? AF D1 00 3C AF C2 00 44 AF D5 00 38 AF C3 00 40 27 D4 00 48 27 D1 00 3C 24 02 00 12 24 13 00 01 12 34 00 0A 02 62 98 21 8E 24 00 00 0? ?? ?? ?? 26 31 00 04 0? ?? ?? ?? 00 00 00 00 3C 03 ?? ?? 24 63 ?? ?? 0? ?? ?? ?? 00 60 10 21 26 62 00 0E 00 02 10 C2 00 02 10 C0 03 A2 E8 23 27 B3 00 30 27 D1 00 3C 02 60 10 21 02 A0 28 21 0? ?? ?? ?? 00 40 20 21 12 91 00 06 3C 06 ?? ?? 8E 25 00 00 0? ?? ?? ?? 26 31 00 04 0? ?? ?? ?? 24 84 ?? ?? 00 00 20 21 02 40 28 21 24 C6 ?? ?? 0? ?? ?? ?? 02 60 38 21 0? ?? ?? ?? AE 00 00 00 0? ?? ?? ?? 8F D7 00 5C 3C 02 ?? ?? 0? ?? ?? ?? 24 42 ?? ?? 8F C2 00 6C 10 40 00 14 00 00 B0 21 8C 56 00 00 12 C0 00 11 00 00 00 00 8C 42 00 04 10 57 FF 74 8F C4 00 6C 00 00 10 21 24 83 00 08 24 42 00 01 10 56 00 09 24 63 00 04 8C 64 FF FC 14 97 FF FC 24 42 00 01 24 42 FF FF 0? ?? ?? ?? 8F C2 00 5C 0? ?? ?? ?? 02 A0 10 21 8F C2 00 C8 8E E3 03 28 8E E4 03 2C 30 54 00 04 AF C3 00 74 16 80 00 1A AF C4 00 78 3C 02 ?? ?? 24 42 ?? ?? 10 40 00 03 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 8E A2 00 18 00 02 20 80 00 02 19 00 00 83 18 21 00 62 10 23 00 02 18 80 3C 02 ?? ?? 24 42 ?? ?? 00 62 10 21 8C 42 00 00 10 40 00 06 00 00 00 00 10 57 00 88 8F C4 00 74 8C 42 00 0C 14 40 FF FC 00 00 00 00 0? ?? ?? ?? 24 17 FF FF 7C 03 E8 3B 24 63 8B 74 00 00 00 0F C0 64 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 24 02 00 02 14 82 00 0B 3C 02 ?? ?? 7C 03 E8 3B 24 64 8B 74 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 3C 02 ?? ?? 24 42 ?? ?? 10 40 00 04 00 00 00 00 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 8E A2 02 C8 8F C3 00 70 10 62 00 2E 00 00 00 00 10 40 00 2C 00 00 00 00 8C 43 00 00 10 60 00 29 00 00 00 00 12 E3 00 06 24 42 00 04 8C 43 00 00 10 60 00 24 00 00 00 00 16 E3 FF FC 24 42 00 04 8E E3 03 28 8E E2 03 2C 8F C4 00 74 00 83 18 26 8F C4 00 78 00 82 10 26 00 62 B8 25 00 17 B8 2B 00 17 B8 23 3C 02 ?? ?? 24 42 ?? ?? 10 40 00 04 00 00 00 00 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 16 80 00 25 00 00 00 00 12 E0 FF 08 00 00 00 00 8F C7 00 BC 8F C2 00 C4 8F C3 00 C8 AF B2 00 10 AF A2 00 14 AF A3 00 18 AF B3 00 1C 02 20 20 21 02 A0 28 21 0? ?? ?? ?? 02 00 30 21 0? ?? ?? ?? 03 C0 E8 21 8E A2 02 CC 10 40 FF 9F 8F C4 00 6C 10 82 00 19 8F C3 00 6C 8C 56 00 00 12 C0 FF 9A 00 00 00 00 8C 43 00 04 12 E3 FF D5 24 42 00 08 00 00 18 21 24 63 00 01 10 76 FF 93 24 42 00 04 8C 44 FF FC 16 E4 FF FC 24 63 00 01 24 63 FF FF 0? ?? ?? ?? 8E E3 03 28 7C 03 E8 3B 24 02 00 01 AC 62 8B 74 00 00 00 0F 12 E0 FE E0 00 00 00 00 0? ?? ?? ?? 8E A7 02 A0 8C 62 00 00 02 C2 18 2B 10 60 FF 81 8F C3 00 6C 24 64 00 04 00 16 18 80 00 83 18 21 8C 64 00 00 12 E4 FF B9 00 00 00 00 26 D6 00 01 02 C2 20 2B 10 80 00 22 24 63 00 04 8C 64 00 00 16 E4 FF FB 26 D6 00 01 26 D6 FF FF 0? ?? ?? ?? 8E E3 03 28 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 8F C2 00 5C 8E E3 03 28 14 83 FF A9 8E E2 03 2C 8F C4 00 78 14 82 FF A6 00 00 00 00 8E E5 02 DC 30 A2 00 08 14 40 00 08 3C 02 C0 00 8E A3 02 68 00 62 18 24 3C 02 80 00 10 62 00 0A 00 00 00 00 34 A5 00 08 AE E5 02 DC 0? ?? ?? ?? 00 00 B8 21 3C 02 ?? ?? 0? ?? ?? ?? 24 42 ?? ?? 0? ?? ?? ?? 00 40 B0 21 8E A2 02 DC 30 42 00 08 14 40 FF F4 00 00 00 00 8E A7 02 D0 02 C7 10 2B 10 40 00 29 00 16 10 80 8E A3 02 CC 00 62 10 21 AC 57 00 04 00 00 00 0F 8E A2 02 CC 26 C3 00 01 AC 43 00 00 3C 02 ?? ?? 8C 42 ?? ?? 30 42 00 40 10 40 FF E6 00 00 00 00 8E E5 00 04 80 A2 00 00 14 40 00 07 3C 02 ?? ?? 8C 42 ?? ?? 8C 45 00 00 14 A0 00 03 00 00 00 00 3C 05 ?? ?? 24 A5 ?? ?? 8E A7 00 04 80 E2 00 00 14 40 00 08 8E E6 00 18 3C 02 ?? ?? 8C 42 ?? ?? 8C 47 00 00 14 E0 00 03 00 00 00 00 3C 07 ?? ?? 24 E7 ?? ?? 8E A2 00 18 3C 04 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? AF A2 00 10 0? ?? ?? ?? 00 00 B8 21 10 E0 00 26 24 04 00 2C 00 07 38 40 24 E4 00 01 00 04 20 80 AF C5 00 7C 0? ?? ?? ?? AF C7 00 84 00 40 18 21 8F C5 00 7C 10 40 FF BC 8F C7 00 84 12 C0 00 0D 00 00 40 21 8E A5 02 CC 00 16 40 80 01 00 30 21 24 44 00 04 24 A5 00 04 AF C7 00 84 AF C8 00 7C 0? ?? ?? ?? AF C2 00 80 8F C8 00 7C 8F C7 00 84 8F C3 00 80 00 68 40 21 26 C2 00 01 AD 17 00 04 AC 62 00 00 00 00 00 0F 8E A4 02 CC AE A7 02 D0 10 80 FF BD AE A3 02 CC 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 3C 02 ?? ?? 0? ?? ?? ?? 24 07 00 0A }
	condition:
		$1
}

rule file_219_4_0 {
	meta:
		name = "_dl_setup_hash"
		size = 208
		refs = "00a8 $LC21 00ac $LC1 00c8 __assert_fail 00b0 __PRETTY_FUNCTION__.9534"
	strings:
		$1 = { 8C 82 02 20 10 40 00 19 00 00 00 00 8C 42 00 04 8C 83 00 00 00 62 10 21 8C 46 00 00 AC 86 02 4C 8C 43 00 08 24 67 FF FF 00 E3 28 24 14 A0 00 1E 8C 48 00 04 24 45 00 10 AC 87 02 50 00 03 18 80 8C 42 00 0C 00 A3 18 21 00 06 30 80 00 66 30 21 00 08 38 80 00 C7 30 23 AC 82 02 54 AC 85 02 58 AC 83 02 5C 03 E0 00 08 AC 86 02 60 8C 82 00 30 10 40 00 0B 00 00 00 00 8C 42 00 04 8C 83 00 00 00 62 18 21 8C 62 00 00 24 63 00 08 AC 83 02 60 00 02 28 80 00 65 18 21 AC 82 02 4C AC 83 02 5C 03 E0 00 08 00 00 00 00 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 27 BD FF E0 24 84 ?? ?? 24 A5 ?? ?? 24 06 03 79 AF BF 00 1C 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_220_0_0 {
	meta:
		name = "capset"
		size = 28
	strings:
		$1 = { 24 02 10 6D 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_222_0_0 {
	meta:
		name = "__strftime_internal"
		size = 7468
		refs = "02e4 memset 0374 memcpy 03e8 strlen 04cc $LC4 05c8 $LC2 05dc $LC1 05f0 $LC0 0b5c mktime 0bc4 $LC3 0ffc __tzname 1550 _nl_get_alt_digit 101c $LC5 1a3c _nl_get_era_entry 1b70 __tzset"
	strings:
		$1 = { 27 BD FF 58 8C E3 00 08 AF B4 00 90 8F B4 00 BC AF A3 00 58 28 62 00 0D 8E 88 00 08 8C E3 00 28 AF B7 00 9C AF B6 00 98 AF B1 00 84 AF B0 00 80 AF BF 00 A4 AF BE 00 A0 AF B5 00 94 AF B3 00 8C AF B2 00 88 00 E0 B0 21 00 80 88 21 00 A0 B8 21 00 C0 80 21 AF A8 00 60 14 40 00 84 AF A3 00 64 8F A8 00 58 25 08 FF F4 AF A8 00 58 82 02 00 00 10 40 00 11 00 00 98 21 AF B6 00 5C 24 03 00 25 10 43 00 13 02 F3 18 23 2C 63 00 02 14 60 00 66 00 00 00 00 12 20 00 03 00 00 00 00 A2 22 00 00 26 31 00 01 26 73 00 01 02 00 10 21 80 42 00 01 14 40 FF F2 26 10 00 01 12 20 00 5C 02 60 10 21 12 E0 00 5B 8F BF 00 A4 0? ?? ?? ?? A2 20 00 00 00 00 30 21 00 00 B0 21 00 00 F0 21 24 04 00 30 24 07 00 5E 24 0A 00 5F 24 05 00 23 24 09 00 2D 26 10 00 01 82 02 00 00 10 44 00 0A 00 00 00 00 28 43 00 31 10 60 00 09 00 00 00 00 14 45 00 0B 00 00 00 00 26 10 00 01 82 02 00 00 14 44 FF F8 24 06 00 01 0? ?? ?? ?? 00 40 F0 21 14 47 00 35 00 00 00 00 0? ?? ?? ?? 24 16 00 01 10 49 FF F9 24 43 FF D0 2C 63 00 0A 10 60 00 1F 24 12 FF FF 3C 04 0C CC 34 84 CC CD 3C 05 7F FF 00 00 90 21 34 A5 FF FF 0? ?? ?? ?? 24 87 FF FF 12 47 00 29 82 03 00 00 00 12 10 40 00 12 90 C0 00 52 10 21 26 10 00 01 24 72 FF D0 02 42 90 21 82 02 00 00 24 43 FF D0 2C 63 00 0A 10 60 00 0C 24 03 00 45 02 44 10 2A 14 40 FF F1 00 00 00 00 00 A0 90 21 26 10 00 01 82 02 00 00 24 43 FF D0 2C 63 00 0A 14 60 FF F7 00 00 00 00 24 03 00 45 10 43 00 23 24 03 00 4F 10 43 00 21 00 00 38 21 30 43 00 FF 2C 64 00 7B 10 80 00 28 3C 04 ?? ?? 00 03 18 80 24 84 ?? ?? 00 83 18 21 8C 63 00 00 00 60 00 08 00 00 00 00 14 4A FF CF 24 43 FF D0 0? ?? ?? ?? 00 40 F0 21 28 62 00 38 14 40 FF D7 00 12 10 40 0? ?? ?? ?? 00 A0 90 21 00 00 10 21 8F BF 00 A4 8F BE 00 A0 8F B7 00 9C 8F B6 00 98 8F B5 00 94 8F B4 00 90 8F B3 00 8C 8F B2 00 88 8F B1 00 84 8F B0 00 80 03 E0 00 08 27 BD 00 A8 26 10 00 01 00 40 38 21 0? ?? ?? ?? 82 02 00 00 8F A3 00 58 24 02 00 0C 00 43 18 0A 0? ?? ?? ?? AF A3 00 58 82 02 FF FF 26 10 FF FF 24 03 00 25 14 43 00 2D 26 02 FF FF 02 00 48 21 24 15 00 01 02 55 90 23 2A 4A 00 00 00 00 10 21 02 4A 10 0A 02 A2 50 21 02 F3 10 23 01 42 10 2B 10 40 FF DB 00 00 00 00 12 20 00 1C 00 00 00 00 1A 40 00 0B 24 02 00 30 13 C2 00 2C 02 20 20 21 24 05 00 20 02 40 30 21 AF A9 00 78 0? ?? ?? ?? AF AA 00 74 8F AA 00 74 8F A9 00 78 02 32 88 21 12 C0 00 1B 02 20 20 21 26 A2 FF FF 24 05 FF FF 01 22 18 21 90 64 00 00 8E 86 00 3C 02 22 18 21 00 04 20 80 00 C4 20 21 8C 84 00 00 24 42 FF FF 14 45 FF F7 A0 64 00 00 02 35 88 21 02 6A 98 21 0? ?? ?? ?? 02 00 10 21 26 02 FF FF 24 15 00 01 24 04 00 25 00 40 48 21 24 42 FF FF 80 43 00 01 14 64 FF FC 26 B5 00 01 0? ?? ?? ?? 02 55 90 23 01 20 28 21 02 A0 30 21 AF AA 00 74 0? ?? ?? ?? 02 35 88 21 0? ?? ?? ?? 8F AA 00 74 24 05 00 30 02 40 30 21 AF A9 00 78 AF AA 00 74 0? ?? ?? ?? 02 32 88 21 8F A9 00 78 0? ?? ?? ?? 8F AA 00 74 24 03 00 01 8F A8 00 5C 24 04 00 27 24 02 00 26 8D 05 00 08 8F A8 00 60 00 06 B0 0B 28 A7 00 0C 00 87 10 0A 24 42 00 08 00 02 10 80 01 02 10 21 8C 44 00 04 24 02 00 01 00 46 18 0B AF A3 00 70 0? ?? ?? ?? AF A5 00 6C 02 42 90 23 00 40 A8 21 2A 49 00 00 00 00 10 21 02 49 10 0A 00 55 48 21 02 F3 10 23 01 22 10 2B 8F A3 00 70 10 40 FF 84 8F A5 00 6C 12 20 00 28 00 00 00 00 1A 40 00 0F 28 A5 00 0C 24 02 00 30 13 C2 04 F6 02 20 20 21 24 05 00 20 02 40 30 21 AF A3 00 70 0? ?? ?? ?? AF A9 00 78 8F A8 00 5C 8F A3 00 70 8F A9 00 78 8D 05 00 08 02 32 88 21 28 A5 00 0C 10 60 04 B3 24 02 00 27 24 03 00 26 00 65 10 0B 8F A3 00 60 24 42 00 08 00 02 10 80 00 62 10 21 8C 46 00 04 26 A3 FF FF 12 A0 00 0B 24 02 FF FF 00 C3 20 21 90 85 00 00 8E 87 00 38 02 23 20 21 00 05 28 80 00 E5 28 21 8C A5 00 00 24 63 FF FF 14 62 FF F7 A0 85 00 00 02 35 88 21 02 69 98 21 0? ?? ?? ?? 02 00 10 21 3C 03 ?? ?? 24 63 ?? ?? 8F A2 00 B8 8F A7 00 5C 00 00 20 21 00 60 30 21 AF A2 00 10 AF B4 00 14 24 05 FF FF 0? ?? ?? ?? AF A3 00 70 02 42 90 23 2A 49 00 00 00 00 20 21 02 49 20 0A 00 82 48 21 02 F3 38 23 00 40 A8 21 01 27 10 2B 10 40 FF 43 8F A3 00 70 12 20 FF E7 00 00 00 00 1A 40 04 7D 24 02 00 30 13 C2 04 7D 02 20 20 21 24 05 00 20 02 40 30 21 AF A3 00 70 AF A7 00 6C 0? ?? ?? ?? AF A9 00 78 8F A3 00 70 8F A7 00 6C 8F A9 00 78 02 32 90 21 8F A5 00 B8 02 40 20 21 AF B4 00 14 AF A5 00 10 00 E0 28 21 8F A7 00 5C 00 60 30 21 0? ?? ?? ?? AF A9 00 78 8F A9 00 78 02 55 20 21 12 C0 04 45 02 69 98 21 02 24 10 2B 10 40 04 43 02 00 10 21 92 22 00 00 8E 83 00 3C 26 31 00 01 00 02 10 80 00 62 10 21 8C 42 00 00 14 91 FF F9 A2 22 FF FF 0? ?? ?? ?? 02 00 10 21 3C 03 ?? ?? 0? ?? ?? ?? 24 63 ?? ?? 14 E0 FF 5B 26 02 FF FF 3C 04 ?? ?? 0? ?? ?? ?? 24 83 ?? ?? 14 E0 FF 56 26 02 FF FF 3C 02 ?? ?? 0? ?? ?? ?? 24 43 ?? ?? 24 02 00 45 10 E2 05 28 8F A4 00 5C 8F A8 00 5C 3C 04 51 EB 34 84 85 1F 8D 03 00 14 00 12 28 2A 24 0A 00 01 24 63 07 6C 00 64 00 18 00 03 17 C3 02 45 50 0B 00 00 20 10 00 04 21 43 00 82 10 23 00 02 28 80 00 02 21 00 00 A4 20 21 00 04 28 80 00 85 20 21 00 64 18 23 00 03 AF C2 00 55 A8 23 24 03 00 4F 10 E3 03 B8 02 A0 10 21 06 A0 04 02 00 00 38 21 27 A9 00 58 3C 06 CC CC 01 20 A8 21 34 C6 CC CD 00 46 00 19 26 B5 FF FF 00 00 18 10 00 03 18 C2 00 03 28 40 00 03 20 C0 00 A4 20 21 00 44 10 23 24 44 00 30 A2 A4 00 00 14 60 FF F5 00 60 10 21 10 E0 00 05 24 02 00 2D 24 02 00 2D A2 A2 FF FF 26 B5 FF FF 24 02 00 2D 13 C2 00 1C 02 A9 18 23 00 6A 18 21 18 60 00 19 24 04 00 5F 13 C4 03 FD 02 F3 20 23 01 44 50 2B 11 40 FE CF 00 00 00 00 10 E0 00 06 00 00 00 00 12 20 00 03 26 B5 00 01 A2 22 00 00 26 31 00 01 26 73 00 01 12 20 00 09 02 20 20 21 00 60 30 21 24 05 00 30 02 23 88 21 AF A3 00 70 0? ?? ?? ?? AF A9 00 78 8F A9 00 78 8F A3 00 70 02 63 98 21 00 00 90 21 01 35 48 23 02 49 90 23 2A 4A 00 00 00 00 10 21 02 4A 10 0A 00 49 50 21 02 F3 10 23 01 42 10 2B 10 40 FE B2 00 00 00 00 12 20 FE F3 00 00 00 00 1A 40 00 0B 24 02 00 30 13 C2 03 CE 02 20 20 21 24 05 00 20 02 40 30 21 AF A9 00 78 0? ?? ?? ?? AF AA 00 74 8F AA 00 74 8F A9 00 78 02 32 88 21 12 C0 03 B8 02 20 20 21 11 20 03 FA 25 22 FF FF 24 07 FF FF 02 A2 18 21 90 64 00 00 8E 85 00 3C 02 22 18 21 00 04 20 80 00 A4 20 21 8C 84 00 00 24 42 FF FF 14 47 FF F7 A0 64 00 00 02 29 88 21 02 6A 98 21 0? ?? ?? ?? 02 00 10 21 14 E0 FE D6 26 02 FF FF 8F A8 00 5C 3C 15 00 02 26 B5 00 1A 8D 02 00 10 8F A3 00 60 00 55 10 21 30 42 FF FF 24 42 00 08 00 02 10 80 00 62 10 21 8C 45 00 04 24 02 00 01 00 46 B0 0B 00 A0 20 21 0? ?? ?? ?? AF A5 00 6C 02 42 18 23 28 72 00 00 00 00 20 21 00 72 20 0A 00 82 90 21 00 40 50 21 02 F3 10 23 02 42 10 2B 10 40 FE 75 8F A5 00 6C 12 20 00 26 00 00 00 00 18 60 00 14 24 02 00 30 13 C2 04 F1 02 20 20 21 00 60 30 21 24 05 00 20 AF A3 00 70 0? ?? ?? ?? AF AA 00 74 8F A8 00 5C 8F A3 00 70 8D 02 00 10 02 23 88 21 00 55 10 21 30 42 FF FF 8F A3 00 60 24 42 00 08 00 02 10 80 00 62 10 21 8C 45 00 04 8F AA 00 74 12 C0 03 D8 00 00 00 00 25 43 FF FF 11 40 00 0B 24 04 FF FF 00 A3 10 21 90 46 00 00 8E 87 00 3C 02 23 10 21 00 06 30 80 00 E6 30 21 8C C6 00 00 24 63 FF FF 14 64 FF F7 A0 46 00 00 02 2A 88 21 02 72 98 21 0? ?? ?? ?? 02 00 10 21 14 E0 FE 90 26 02 FF FF 8F A8 00 5C 3C 15 00 02 26 B5 00 07 8D 02 00 18 8F A3 00 60 00 55 10 21 30 42 FF FF 24 42 00 08 00 02 10 80 00 62 10 21 8C 45 00 04 24 02 00 01 00 46 B0 0B 00 A0 20 21 0? ?? ?? ?? AF A5 00 6C 02 42 18 23 28 72 00 00 00 00 20 21 00 72 20 0A 00 82 90 21 00 40 50 21 02 F3 10 23 02 42 10 2B 10 40 FE 2F 8F A5 00 6C 12 20 FF E0 00 00 00 00 18 60 00 14 24 02 00 30 13 C2 04 A1 02 20 20 21 00 60 30 21 24 05 00 20 AF A3 00 70 0? ?? ?? ?? AF AA 00 74 8F A8 00 5C 8F A3 00 70 8D 02 00 18 02 23 88 21 00 55 10 21 30 42 FF FF 8F A3 00 60 24 42 00 08 00 02 10 80 00 62 10 21 8C 45 00 04 8F AA 00 74 12 C0 03 92 00 00 00 00 25 43 FF FF 11 40 FF C5 24 04 FF FF 00 A3 10 21 90 46 00 00 8E 87 00 3C 02 23 10 21 00 06 30 80 00 E6 30 21 8C C6 00 00 24 63 FF FF 14 64 FF F7 A0 46 00 00 0? ?? ?? ?? 02 2A 88 21 14 E0 FE 21 02 00 48 21 26 52 FF FF 2A 55 00 00 00 00 28 21 02 55 28 0A 24 B5 00 01 02 F3 18 23 02 A3 18 2B 10 60 FD FC 00 00 00 00 12 20 00 0D 00 00 00 00 1A 40 00 09 00 00 00 00 24 02 00 30 13 C2 04 96 02 20 20 21 24 05 00 20 0? ?? ?? ?? 02 40 30 21 82 02 00 00 02 32 88 21 A2 22 00 00 26 31 00 01 02 75 98 21 0? ?? ?? ?? 02 00 10 21 26 52 FF FF 2A 55 00 00 00 00 10 21 02 55 10 0A 24 55 00 01 02 F3 10 23 02 A2 10 2B 10 40 FD E2 00 00 00 00 12 20 FF F3 00 00 00 00 1A 40 00 09 24 02 00 0A 24 02 00 30 13 C2 03 C0 02 20 20 21 24 05 00 20 02 40 30 21 0? ?? ?? ?? 02 32 88 21 24 02 00 0A A2 22 00 00 02 75 98 21 26 31 00 01 0? ?? ?? ?? 02 00 10 21 24 02 00 45 10 E2 FE 14 8F A8 00 5C 24 0A 00 02 2A 42 00 02 8D 15 00 10 02 42 50 0A 0? ?? ?? ?? 26 B5 00 01 8F A2 00 5C 27 A3 00 20 24 44 00 20 8C 48 00 00 8C 47 00 04 8C 46 00 08 8C 45 00 0C 24 42 00 10 AC 68 00 00 AC 67 00 04 AC 66 00 08 AC 65 00 0C 14 44 FF F6 24 63 00 10 8C 46 00 00 8C 45 00 04 8C 42 00 08 27 A4 00 20 AC 66 00 00 AC 65 00 04 0? ?? ?? ?? AC 62 00 08 27 A9 00 58 3C 0A 66 66 00 02 3F C2 01 20 A8 21 25 4A 66 67 00 4A 00 18 00 02 27 C3 26 B5 FF FF 00 00 28 10 00 05 28 83 00 A4 18 23 00 03 30 40 00 03 18 C0 00 C3 18 21 00 43 18 23 00 03 10 23 00 47 18 0B 24 63 00 30 00 A4 10 23 14 40 FF F1 A2 A3 00 00 0? ?? ?? ?? 24 0A 00 01 8F A8 00 60 3C 04 ?? ?? 24 82 ?? ?? 8D 03 00 D0 80 64 00 00 0? ?? ?? ?? 00 44 18 0A 24 02 00 45 10 E2 FD D7 8F A3 00 5C 24 0A 00 02 2A 42 00 02 02 42 50 0A 0? ?? ?? ?? 8C 75 00 0C 24 02 00 4F 10 E2 FD CF 24 02 00 45 10 E2 02 85 8F A8 00 60 0? ?? ?? ?? 8D 03 00 C4 8F A3 00 5C 8C 62 00 20 04 40 FD 22 02 00 10 21 8C 63 00 24 04 60 03 45 26 55 FF FF 2A A9 00 00 00 00 28 21 02 A9 28 0A 24 A9 00 01 02 F3 10 23 01 22 10 2B 10 40 FD 76 00 00 00 00 12 20 00 13 00 00 00 00 1A A0 00 0F 24 02 00 2B 24 02 00 30 13 C2 04 05 02 20 20 21 24 05 00 20 02 A0 30 21 AF A3 00 70 AF A7 00 6C 0? ?? ?? ?? AF A9 00 78 8F A9 00 78 8F A7 00 6C 8F A3 00 70 02 35 88 21 24 02 00 2B A2 22 00 00 26 31 00 01 02 69 98 21 3C 04 88 88 34 84 88 89 00 64 00 18 00 03 17 C3 2A 46 00 04 24 0A 00 04 02 46 50 0A 00 00 28 10 00 A3 18 21 00 03 19 43 00 62 10 23 00 44 00 18 00 02 1F C3 00 00 20 10 00 82 20 21 00 04 21 43 00 83 18 23 00 03 28 80 00 03 21 00 00 A4 20 21 00 03 19 80 00 04 30 80 00 65 28 23 00 86 20 21 00 45 10 23 0? ?? ?? ?? 00 82 A8 21 24 02 00 45 10 E2 03 4E 8F A4 00 5C 8F A8 00 5C 3C 03 51 EB 34 63 85 1F 8D 02 00 14 24 0A 00 02 2A 46 00 02 00 43 00 18 00 02 27 C3 02 46 50 0A 00 00 28 10 00 05 29 43 00 A4 28 23 00 05 20 80 00 05 29 00 00 85 20 21 00 04 28 80 00 85 20 21 00 44 10 23 24 42 00 64 00 43 00 18 00 02 27 C3 00 00 18 10 00 03 A9 43 02 A4 A8 23 00 15 18 80 00 15 A9 00 00 75 18 21 00 03 20 80 00 64 18 21 00 43 A8 23 24 02 00 4F 10 E2 01 EB 8F A5 00 60 0? ?? ?? ?? 02 A0 10 21 24 02 00 45 10 E2 FD 63 8F A8 00 5C 3C 04 92 49 24 84 24 93 8D 03 00 1C 8D 02 00 18 24 0A 00 02 2A 45 00 02 00 62 10 23 24 42 00 07 00 44 00 18 00 02 1F C3 02 45 50 0A 00 00 20 10 00 82 10 21 00 02 A8 83 0? ?? ?? ?? 02 A3 A8 23 24 02 00 45 10 E2 FD 50 24 0A 00 02 2A 42 00 02 02 42 50 0A 0? ?? ?? ?? 8F B5 00 58 24 02 00 45 10 E2 FD 49 8F A8 00 5C 24 0A 00 02 2A 42 00 02 02 42 50 0A 0? ?? ?? ?? 8D 15 00 08 24 02 00 45 10 E2 FD 41 24 0A 00 02 8F B5 00 58 2A 42 00 02 02 42 50 0A 24 02 00 30 13 C2 FE 02 24 03 00 5F 3B DE 00 2D 24 02 00 2D 00 7E 10 0B 0? ?? ?? ?? 00 40 F0 21 24 02 00 45 10 E2 FD 33 8F A3 00 5C 24 0A 00 02 2A 42 00 02 02 42 50 0A 0? ?? ?? ?? 8C 75 00 08 24 02 00 45 10 E2 FD 2B 8F A8 00 5C 24 0A 00 03 2A 42 00 03 8D 15 00 1C 02 42 50 0A 0? ?? ?? ?? 26 B5 00 01 24 02 00 45 10 E2 FD 22 8F A8 00 5C 24 0A 00 02 2A 42 00 02 8D 15 00 0C 0? ?? ?? ?? 02 42 50 0A 0? ?? ?? ?? 00 00 18 21 24 02 00 4F 10 E2 FD 18 24 02 00 45 10 E2 01 D5 8F A8 00 60 0? ?? ?? ?? 8D 03 00 C8 24 02 00 45 10 E2 FD 11 8F A3 00 5C 24 0A 00 01 00 12 10 2A 02 42 50 0B 0? ?? ?? ?? 8C 75 00 18 8F A3 00 5C 3C 04 92 49 24 84 24 93 8C 62 00 18 24 0A 00 01 00 12 28 2A 24 42 00 06 00 44 00 18 00 02 1F C3 02 45 50 0B 00 00 20 10 00 82 20 21 00 04 20 83 00 83 18 23 00 03 20 C0 00 83 18 23 00 43 10 23 0? ?? ?? ?? 24 55 00 01 26 52 FF FF 2A 55 00 00 00 00 10 21 02 55 10 0A 24 55 00 01 02 F3 10 23 02 A2 10 2B 10 40 FC AA 00 00 00 00 12 20 FE BB 00 00 00 00 1A 40 00 09 24 02 00 09 24 02 00 30 13 C2 02 94 02 20 20 21 24 05 00 20 02 40 30 21 0? ?? ?? ?? 02 32 88 21 24 02 00 09 A2 22 00 00 0? ?? ?? ?? 26 31 00 01 8F A8 00 64 00 06 18 2B AF A3 00 68 11 00 00 04 00 06 B0 0B 81 02 00 00 14 40 00 11 00 00 00 00 8F A3 00 5C 8C 62 00 20 04 40 00 0A 8F A4 00 B8 90 83 00 00 10 60 02 DE 00 00 00 00 3C 05 ?? ?? }
	condition:
		$1
}

rule file_222_1_0 {
	meta:
		name = "__strftime_l"
		size = 44
		altNames = "__wcsftime_l"
	strings:
		$1 = { 27 BD FF D0 27 A2 00 20 AF A2 00 10 8F A2 00 40 AF BF 00 2C A3 A0 00 20 0? ?? ?? ?? AF A2 00 14 8F BF 00 2C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_223_0_0 {
	meta:
		name = "__atomic_preadv64_replacement"
		size = 516
		refs = "0004 __gnu_local_gp 00d8 __libc_pread64 0120 memcpy 0138 free 0180 __libc_errno 01dc __libc_alloca_cutoff 01ec malloc"
	strings:
		$1 = { 27 BD FF B0 3C 1C ?? ?? 27 9C ?? ?? AF BE 00 48 03 A0 F0 21 AF B3 00 34 AF B2 00 30 AF B1 00 2C AF BF 00 4C AF B7 00 44 AF B6 00 40 AF B5 00 3C AF B4 00 38 AF B0 00 28 AF DC 00 18 00 C0 88 21 00 80 98 21 18 C0 00 63 00 A0 90 21 8C A2 00 04 3C 03 80 00 00 43 18 2B 10 60 00 47 3C 06 7F FF 00 A0 38 21 00 00 18 21 00 00 80 21 0? ?? ?? ?? 34 C6 FF FF 8C E2 00 04 01 02 40 2B 15 00 00 3E 00 00 00 00 02 02 80 21 24 63 00 01 24 E7 00 08 14 71 FF F8 00 D0 40 23 34 02 80 01 02 02 10 2B 10 40 00 4E 00 00 00 00 26 02 00 0E 00 02 10 C2 00 02 10 C0 03 A2 E8 23 27 B5 00 18 00 00 A0 21 8F C9 00 64 8F C8 00 60 02 60 20 21 AF A9 00 14 AF A8 00 10 02 A0 28 21 0? ?? ?? ?? 02 00 30 21 04 40 00 3A 00 40 B8 21 1A 20 00 11 00 40 80 21 0? ?? ?? ?? 00 00 B0 21 12 D1 00 0D 26 52 00 08 8E 42 00 04 8E 44 00 00 02 A0 28 21 02 02 98 2B 02 13 10 0B 00 40 98 21 00 40 30 21 02 02 80 23 0? ?? ?? ?? 26 D6 00 01 16 00 FF F3 02 B3 A8 21 02 E0 10 21 02 80 20 21 0? ?? ?? ?? AF C2 00 20 03 C0 E8 21 8F BF 00 4C 8F C2 00 20 8F B7 00 44 8F BE 00 48 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 16 AC 43 00 00 03 C0 E8 21 8F BF 00 4C 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 24 02 FF FF 03 E0 00 08 27 BD 00 50 00 00 A0 21 0? ?? ?? ?? 24 02 FF FF 0? ?? ?? ?? 00 00 80 21 0? ?? ?? ?? 02 00 20 21 14 40 FF B1 26 02 00 0E 0? ?? ?? ?? 02 00 20 21 10 40 FF F4 00 40 A8 21 0? ?? ?? ?? 00 40 A0 21 }
	condition:
		$1
}

rule file_223_1_0 {
	meta:
		name = "preadv64"
		size = 392
		refs = "0004 __gnu_local_gp 008c __libc_errno 00cc __libc_enable_asynccancel 0130 __libc_disable_asynccancel"
	strings:
		$1 = { 27 BD FF B8 3C 1C ?? ?? 27 9C ?? ?? AF BE 00 40 03 A0 F0 21 AF B5 00 3C AF B4 00 38 AF B3 00 34 AF B2 00 30 AF B1 00 2C AF BF 00 44 AF B0 00 28 AF DC 00 18 00 80 A0 21 00 A0 98 21 00 C0 90 21 8F D1 00 58 8F D5 00 5C 7C 03 E8 3B 8C 62 8B 70 14 40 00 1E 00 00 00 00 27 BD FF F0 27 A2 00 18 AF C2 00 24 02 A0 38 21 27 BD FF E0 AF B1 00 10 24 02 10 EA 00 00 00 0C 27 BD 00 20 10 E0 00 2F 00 40 80 21 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 02 00 20 21 00 62 10 21 AC 50 00 00 24 10 FF FF 24 03 00 59 14 83 00 27 02 00 10 21 AF B1 00 10 AF B5 00 14 02 80 20 21 02 60 28 21 0? ?? ?? ?? 02 40 30 21 0? ?? ?? ?? 03 C0 E8 21 0? ?? ?? ?? 00 00 00 00 27 BD FF F0 27 A3 00 18 8F DC 00 18 00 40 F8 21 AF C3 00 20 02 80 20 21 02 60 28 21 02 40 30 21 02 A0 38 21 27 BD FF E0 AF B1 00 10 24 02 10 EA 00 00 00 0C 27 BD 00 20 10 E0 00 07 00 40 80 21 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 AC 50 00 00 24 10 FF FF 03 E0 20 21 0? ?? ?? ?? 00 00 00 00 8F DC 00 18 06 00 00 0C 02 00 10 21 03 C0 E8 21 8F BF 00 44 8F BE 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 48 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 0? ?? ?? ?? 8C 44 00 00 }
	condition:
		$1
}

rule file_224_0_0 {
	meta:
		name = "__wcsncpy"
		size = 296
	strings:
		$1 = { 00 80 10 21 2C C4 00 04 14 80 00 21 24 43 FF FC 0? ?? ?? ?? 00 06 38 82 8C A8 00 04 11 00 00 30 AC 68 00 08 24 A5 00 10 8C A8 FF F8 11 00 00 35 AC 68 00 0C 8C A8 FF FC 24 63 00 10 11 00 00 08 AC 68 00 00 10 E0 00 12 00 00 00 00 8C A8 00 00 24 E7 FF FF 15 00 FF F0 AC 68 00 04 24 63 00 04 00 62 20 23 24 C6 FF FF 00 04 20 83 00 C4 30 23 10 C0 00 19 00 00 00 00 24 63 00 04 24 C6 FF FF 14 C0 FF FD AC 60 00 00 03 E0 00 08 00 00 00 00 30 C6 00 03 10 C0 FF FC 24 A5 00 04 8C A7 FF FC 24 63 00 04 24 C6 FF FF 10 C0 FF F7 AC 67 00 00 10 E0 FF F1 00 00 00 00 24 A5 00 04 8C A7 FF FC 24 63 00 04 24 C6 FF FF 14 C0 FF F9 AC 67 00 00 03 E0 00 08 00 00 00 00 03 E0 00 08 00 00 00 00 24 63 00 08 00 62 20 23 24 C6 FF FF 00 04 20 83 00 C4 30 23 14 C0 FF E0 00 00 00 00 0? ?? ?? ?? 00 00 00 00 24 63 00 0C 00 62 20 23 24 C6 FF FF 00 04 20 83 00 C4 30 23 14 C0 FF D7 00 00 00 00 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_225_0_0 {
	meta:
		name = "__wcschrnul"
		size = 68
	strings:
		$1 = { 8C 83 00 00 10 60 00 0B 00 80 10 21 14 65 00 06 24 42 00 04 03 E0 00 08 24 42 FF FC 10 65 00 07 00 00 00 00 24 42 00 04 8C 43 00 00 14 60 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_226_0_0 {
	meta:
		name = "timerfd_create"
		size = 28
	strings:
		$1 = { 24 02 10 E1 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_228_0_0 {
	meta:
		name = "lrand48_r"
		size = 24
		refs = "0008 __nrand48_r"
	strings:
		$1 = { 10 80 00 03 00 A0 30 21 0? ?? ?? ?? 00 80 28 21 03 E0 00 08 24 02 FF FF }
	condition:
		$1
}

rule file_1019_0_0 {
	meta:
		name = "mrand48_r"
		size = 24
		refs = "0008 __jrand48_r"
	strings:
		$1 = { 10 80 00 03 00 A0 30 21 0? ?? ?? ?? 00 80 28 21 03 E0 00 08 24 02 FF FF }
	condition:
		$1
}

rule file_229_0_0 {
	meta:
		name = "getw"
		size = 56
		refs = "0014 _IO_fread"
	strings:
		$1 = { 27 BD FF D8 00 80 38 21 24 05 00 04 27 A4 00 18 AF BF 00 24 0? ?? ?? ?? 24 06 00 01 24 03 00 01 14 43 00 02 24 02 FF FF 8F A2 00 18 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_230_0_0 {
	meta:
		name = "__dcgettext"
		size = 40
		refs = "0014 __dcigettext"
	strings:
		$1 = { 27 BD FF D8 00 00 38 21 AF A6 00 14 AF A0 00 10 AF BF 00 24 0? ?? ?? ?? 00 00 30 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_231_0_0 {
	meta:
		name = "tcsendbreak"
		size = 56
		refs = "0024 __ioctl"
	strings:
		$1 = { 18 A0 00 0A 3C 06 51 EB 24 A5 00 63 34 C6 85 1F 00 A6 00 18 00 05 17 C3 24 05 54 86 00 00 30 10 00 06 31 43 0? ?? ?? ?? 00 C2 30 23 24 05 54 05 0? ?? ?? ?? 00 00 30 21 }
	condition:
		$1
}

rule file_234_0_0 {
	meta:
		name = "_IO_mem_sync"
		size = 108
		refs = "0054 _IO_str_overflow"
	strings:
		$1 = { 8C 82 00 14 8C 83 00 18 27 BD FF E0 AF B0 00 18 AF BF 00 1C 10 43 00 0F 00 80 80 21 A0 40 00 00 8E 03 00 A8 8E 04 00 10 8F BF 00 1C 00 00 10 21 AC 64 00 00 8E 05 00 14 8E 04 00 10 8E 03 00 AC 8F B0 00 18 00 A4 20 23 AC 64 00 00 03 E0 00 08 27 BD 00 20 0? ?? ?? ?? 00 00 28 21 8E 02 00 14 24 42 FF FF 0? ?? ?? ?? AE 02 00 14 }
	condition:
		$1
}

rule file_234_1_0 {
	meta:
		name = "_IO_mem_finish"
		size = 140
		refs = "0028 realloc 0084 _IO_str_finish"
	strings:
		$1 = { 8C 82 00 10 8C 83 00 14 27 BD FF D8 AF B1 00 20 00 62 28 23 8C 91 00 A8 AF B0 00 1C 24 A5 00 01 00 80 80 21 AF BF 00 24 0? ?? ?? ?? 00 40 20 21 AE 22 00 00 8E 02 00 A8 8C 42 00 00 10 40 00 0D 8F BF 00 24 8E 04 00 14 8E 03 00 10 00 83 18 23 00 43 10 21 A0 40 00 00 8E 04 00 14 8E 03 00 10 8E 02 00 AC 00 83 18 23 AC 43 00 00 AE 00 00 1C 8F BF 00 24 8F B1 00 20 02 00 20 21 8F B0 00 1C 00 00 28 21 0? ?? ?? ?? 27 BD 00 28 }
	condition:
		$1
}

rule file_234_2_0 {
	meta:
		name = "open_memstream"
		size = 208
		refs = "0020 malloc 003c calloc 0050 _IO_init 0070 _IO_str_init_static_internal 0098 free"
	strings:
		$1 = { 27 BD FF D0 AF B3 00 28 00 80 98 21 24 04 01 78 AF B2 00 24 AF B0 00 1C AF BF 00 2C AF B1 00 20 0? ?? ?? ?? 00 A0 90 21 10 40 00 27 00 40 80 21 24 42 00 B0 24 04 00 01 24 05 20 00 0? ?? ?? ?? AE 02 00 48 10 40 00 20 00 40 88 21 02 00 20 21 0? ?? ?? ?? 00 00 28 21 3C 02 ?? ?? 24 42 ?? ?? 02 20 28 21 02 00 20 21 24 06 20 00 02 20 38 21 0? ?? ?? ?? AE 02 00 98 8E 03 00 00 24 02 FF FE AE 13 00 A8 00 62 10 24 AE 02 00 00 3C 02 ?? ?? 24 42 ?? ?? AE 02 00 A0 3C 02 ?? ?? 24 42 ?? ?? AE 02 00 A4 AE 12 00 AC 02 00 10 21 8F BF 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 30 0? ?? ?? ?? 00 00 10 21 }
	condition:
		$1
}

rule file_235_0_0 {
	meta:
		name = "__getrusage"
		size = 28
	strings:
		$1 = { 24 02 0F ED 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_236_0_0 {
	meta:
		name = "profil_count"
		size = 392
	strings:
		$1 = { 3C 03 ?? ?? 24 6A ?? ?? 8D 42 00 08 8C 46 00 10 00 86 30 2B 14 C0 00 06 8C 67 ?? ?? 8C 47 00 14 00 87 38 2B 14 E0 00 1D 00 40 30 21 8C 67 ?? ?? 8D 49 00 04 00 00 18 21 0? ?? ?? ?? 24 E7 FF FF 8C C8 00 14 24 43 00 01 00 88 10 2B 14 40 00 2A 00 00 00 00 00 E3 10 2B 14 40 00 0F 00 00 00 00 00 67 10 21 00 02 10 42 00 02 41 40 00 02 30 C0 01 06 30 23 01 26 30 21 8C C8 00 10 00 88 40 2B 11 00 FF EF 00 00 00 00 24 47 FF FF 00 E3 10 2B 10 40 FF F4 00 67 10 21 8D 42 00 0C 8C 43 00 00 8C 42 00 08 10 A0 00 1D 00 83 20 23 00 04 20 82 00 82 00 19 8C C4 00 04 00 00 18 12 00 00 10 10 00 02 2C 00 00 03 14 02 00 A2 10 25 00 44 18 2B 10 60 00 0C 00 02 10 80 8C C3 00 0C 24 04 FF FF 00 62 18 21 8C 62 00 00 10 44 00 25 24 42 00 01 03 E0 00 08 AC 62 00 00 AD 46 00 08 0? ?? ?? ?? 8D 42 00 0C 8D 42 00 0C 8C 42 00 0C 8C 43 00 00 24 63 00 01 03 E0 00 08 AC 43 00 00 00 04 20 42 00 82 00 19 8C C4 00 04 00 00 18 12 00 00 10 10 00 02 2C 00 00 03 14 02 00 A2 10 25 00 44 18 2B 10 60 00 09 00 02 10 40 8C C3 00 0C 34 04 FF FF 00 62 18 21 94 62 00 00 10 44 00 09 24 42 00 01 03 E0 00 08 A4 62 00 00 8D 42 00 0C 8C 42 00 0C 94 43 00 00 24 63 00 01 03 E0 00 08 A4 43 00 00 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_236_1_0 {
	meta:
		name = "profil_counter_ushort"
		size = 32
	strings:
		$1 = { 8C C4 00 0C 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? 00 00 28 21 8F BF 00 1C 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_236_2_0 {
	meta:
		name = "profil_counter_uint"
		size = 32
	strings:
		$1 = { 8C C4 00 0C 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? 24 05 00 01 8F BF 00 1C 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_236_3_0 {
	meta:
		name = "pcmp"
		size = 44
	strings:
		$1 = { 8C 83 00 00 8C A5 00 00 8C 64 00 08 8C A3 00 08 00 83 28 2B 14 A0 00 03 24 02 00 01 00 64 10 2B 00 02 10 23 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_236_4_0 {
	meta:
		name = "insert.part.0"
		size = 380
		refs = "003c malloc 010c realloc 0164 memmove"
	strings:
		$1 = { 27 BD FF C8 AF B0 00 1C 3C 10 ?? ?? 8E 02 ?? ?? AF B5 00 30 AF B4 00 2C AF B3 00 28 AF B1 00 20 AF BF 00 34 AF B2 00 24 00 80 98 21 00 A0 A8 21 00 C0 A0 21 14 40 00 30 00 E0 88 21 0? ?? ?? ?? 24 04 00 18 00 40 90 21 12 40 00 22 24 02 FF FF 8E 02 ?? ?? 00 53 18 23 14 60 00 39 00 03 30 C0 00 13 18 C0 00 13 21 40 00 83 20 23 02 44 20 21 8F A7 00 48 8E 25 00 04 24 06 00 02 24 03 00 04 00 C7 18 0A 00 A3 00 1B 00 60 01 F4 8E 29 00 00 8E 25 00 08 8E 27 00 0C 24 42 00 01 26 08 ?? ?? AC 85 00 00 AC 87 00 08 AE 02 ?? ?? AC 89 00 0C AC 95 00 10 AC 94 00 14 00 00 10 21 00 00 18 12 AC 83 00 04 14 A0 00 03 AD 12 00 04 10 E6 00 13 8F BF 00 34 8F BF 00 34 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 38 26 03 ?? ?? 24 42 00 01 8C 64 00 04 00 02 28 C0 00 02 11 40 0? ?? ?? ?? 00 45 28 23 0? ?? ?? ?? 00 40 90 21 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B1 00 20 8F B0 00 1C AD 12 00 0C 8F B2 00 24 03 E0 00 08 27 BD 00 38 26 73 00 01 00 13 10 C0 00 13 99 40 02 62 20 23 24 93 FF E8 02 53 98 21 00 03 19 40 02 44 20 21 02 60 28 21 0? ?? ?? ?? 00 66 30 23 3C 02 ?? ?? 8C 42 ?? ?? 0? ?? ?? ?? 02 60 20 21 }
	condition:
		$1
}

rule file_236_5_0 {
	meta:
		name = "__sprofil"
		size = 1244
		refs = "005c __profile_frequency 010c qsort 016c __udivdi3 0290 free 0370 __sigaction 039c __setitimer 04bc $LC0 04c0 $LC1 04d4 __assert_fail 04c4 __PRETTY_FUNCTION__.4919"
	strings:
		$1 = { 00 05 10 80 24 42 00 0A 00 02 10 C2 27 BD FF 00 00 02 10 C0 AF BE 00 F8 AF B5 00 EC 03 A0 F0 21 AF B1 00 DC AF B0 00 D8 AF BF 00 FC AF B7 00 F4 AF B6 00 F0 AF B4 00 E8 AF B3 00 E4 AF B2 00 E0 03 A2 E8 23 AF C5 01 04 00 C0 88 21 00 80 80 21 AF C7 01 0C 10 C0 00 17 27 B5 00 18 0? ?? ?? ?? 00 00 00 00 3C 03 00 0F 24 63 42 40 00 62 00 1A 00 40 01 F4 3C 03 43 1B 34 63 DE 83 00 00 10 12 00 43 00 19 00 00 18 10 00 03 1C 82 00 03 2A 00 00 03 20 C0 00 A4 20 23 00 04 29 80 00 A4 20 23 00 83 20 21 00 04 21 80 00 44 10 23 AE 23 00 00 AE 22 00 04 3C 17 ?? ?? 8E E2 ?? ?? 14 40 00 D6 3C 02 ?? ?? 26 F2 ?? ?? 24 42 ?? ?? AE 42 00 0C 8F C2 01 04 18 40 00 F1 AE 40 00 04 00 02 31 00 02 A0 18 21 00 00 10 21 02 02 28 21 24 42 00 10 AC 65 00 00 14 46 FF FC 24 63 00 04 8F C5 01 04 3C 07 ?? ?? 02 A0 20 21 24 06 00 04 0? ?? ?? ?? 24 E7 ?? ?? 8F C2 01 0C 24 03 00 04 AF C0 00 C4 30 53 00 01 24 02 00 02 00 53 18 0A AF C3 00 C0 8E B1 00 00 8E 28 00 0C 2D 02 00 02 14 40 00 71 8F C2 00 C4 12 60 00 A4 8E 24 00 04 8E 29 00 08 00 04 58 82 00 0B 2C 80 00 04 24 02 01 00 38 21 00 00 30 21 AF C8 00 C8 AF C9 00 CC 0? ?? ?? ?? AF CB 00 D0 8F C9 00 CC 8F C8 00 C8 8F CB 00 D0 00 69 80 21 24 04 00 04 00 64 00 1B 00 80 01 F4 00 09 30 27 00 00 20 12 00 88 00 19 00 00 28 12 00 05 14 02 00 00 20 10 00 04 1C 00 00 62 10 25 00 4B 10 2B 8F C3 00 C0 02 02 80 21 00 D0 20 21 00 83 00 1B 00 60 01 F4 00 00 20 12 00 88 00 19 00 00 28 12 00 05 14 02 00 00 20 10 00 04 1C 00 00 62 10 25 00 4B 10 2B 10 40 00 B4 8F C4 00 C0 02 09 10 23 00 44 00 1B 00 80 01 F4 00 00 10 12 00 48 00 19 00 00 10 10 00 02 24 00 00 00 18 12 00 03 14 02 00 82 10 25 00 4B 10 2B 14 40 00 A7 8E E2 ?? ?? 10 40 00 2D 00 00 20 21 8E 45 00 04 00 00 B0 21 0? ?? ?? ?? 00 00 A0 21 8E 45 00 04 00 B6 10 21 26 94 00 01 8C 49 00 14 02 84 10 2B 10 40 00 21 26 D6 00 18 00 B6 10 21 8C 46 00 10 01 26 20 2B 10 80 FF F7 8E E4 ?? ?? 02 06 10 2B 14 40 00 19 02 80 20 21 AF B3 00 10 01 20 28 21 0? ?? ?? ?? 02 20 38 21 04 41 FF EC 8E E4 ?? ?? 0? ?? ?? ?? 8E 44 00 04 AE E0 ?? ?? AE 40 00 04 24 02 FF FF 03 C0 E8 21 8F BF 00 FC 8F BE 00 F8 8F B7 00 F4 8F B6 00 F0 8F B5 00 EC 8F B4 00 E8 8F B3 00 E4 8F B2 00 E0 8F B1 00 DC 8F B0 00 D8 03 E0 00 08 27 BD 01 00 02 80 20 21 01 30 10 2B 10 40 00 08 8F C2 00 C4 AF B3 00 10 01 20 28 21 02 00 30 21 0? ?? ?? ?? 02 20 38 21 04 40 FF E4 8F C2 00 C4 8F C3 01 04 26 B5 00 04 24 42 00 01 14 43 FF 87 AF C2 00 C4 8E E3 ?? ?? 10 60 FF E1 00 00 10 21 8F C4 01 0C 8E 43 00 04 30 82 00 01 14 40 00 56 AE 43 00 08 3C 02 ?? ?? 24 42 ?? ?? AF C2 00 24 3C 02 10 00 AF C2 00 20 27 C4 00 24 27 C2 00 A4 24 03 FF FF AC 43 00 00 24 42 FF FC 14 44 FF FD 3C 06 ?? ?? 24 04 00 1D 27 C5 00 20 0? ?? ?? ?? 24 C6 ?? ?? 04 40 FF C9 3C 06 ?? ?? 24 02 00 01 27 C5 00 B0 24 04 00 02 24 C6 ?? ?? AF C0 00 B8 AF C2 00 BC AF C0 00 B0 0? ?? ?? ?? AF C2 00 B4 03 C0 E8 21 8F BF 00 FC 8F BE 00 F8 8F B7 00 F4 8F B6 00 F0 8F B5 00 EC 8F B4 00 E8 8F B3 00 E4 8F B2 00 E0 8F B1 00 DC 8F B0 00 D8 03 E0 00 08 27 BD 01 00 8E 29 00 08 00 04 58 42 00 0B 2C 40 00 04 24 02 01 00 38 21 00 00 30 21 AF C8 00 C8 AF C9 00 CC 0? ?? ?? ?? AF CB 00 D0 8F C9 00 CC 24 04 00 02 8F C8 00 C8 00 69 80 21 0? ?? ?? ?? 8F CB 00 D0 3C 05 ?? ?? 24 04 00 02 24 A5 ?? ?? 0? ?? ?? ?? 00 00 30 21 04 40 FF 9C 3C 05 ?? ?? 24 04 00 1D 24 A5 ?? ?? 0? ?? ?? ?? 00 00 30 21 04 40 FF 96 26 EA ?? ?? 0? ?? ?? ?? 8D 44 00 04 03 C0 E8 21 8F BF 00 FC 8F BE 00 F8 8F B7 00 F4 8F B6 00 F0 8F B5 00 EC 8F B4 00 E8 8F B3 00 E4 8F B2 00 E0 8F B1 00 DC 8F B0 00 D8 00 00 10 21 03 E0 00 08 27 BD 01 00 3C 02 ?? ?? 24 42 ?? ?? 0? ?? ?? ?? AF C2 00 24 8F C5 01 04 3C 07 ?? ?? 02 A0 20 21 24 06 00 04 0? ?? ?? ?? 24 E7 ?? ?? 0? ?? ?? ?? 8E E3 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 65 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_237_0_0 {
	meta:
		name = "__memrchr"
		size = 320
	strings:
		$1 = { 30 A3 00 FF 10 C0 00 12 00 86 10 21 30 44 00 03 10 80 00 19 00 00 00 00 90 44 FF FF 14 83 00 09 24 42 FF FF 0? ?? ?? ?? 00 00 00 00 10 80 00 12 00 00 00 00 24 42 FF FF 90 44 00 00 10 83 00 3E 00 00 00 00 24 C6 FF FF 14 C0 FF F8 30 44 00 03 00 00 30 21 00 46 30 23 10 46 00 2F 00 00 00 00 24 42 FF FF 90 44 00 00 14 83 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 30 A5 00 FF 00 05 52 00 01 45 28 25 00 05 54 00 2C C4 00 04 14 80 FF F1 01 45 50 25 3C 09 7E FE 3C 08 81 01 35 29 FE FF 25 08 01 00 24 42 FF FC 8C 44 00 00 24 C6 FF FC 01 44 20 26 00 04 28 27 00 89 20 21 00 A4 20 26 00 88 20 24 10 80 00 0F 2C C7 00 04 90 44 00 03 10 83 00 13 00 00 00 00 90 44 00 02 10 83 00 12 00 00 00 00 90 44 00 01 10 83 00 11 00 00 00 00 90 44 00 00 14 83 00 03 00 00 00 00 03 E0 00 08 00 00 00 00 10 E0 FF E8 24 42 FF FC 24 42 00 04 0? ?? ?? ?? 00 46 30 23 03 E0 00 08 00 00 10 21 03 E0 00 08 24 42 00 03 03 E0 00 08 24 42 00 02 03 E0 00 08 24 42 00 01 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_238_0_0 {
	meta:
		name = "rewinddir"
		size = 192
		refs = "0040 __lseek 008c __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF D8 AF B1 00 20 AF B0 00 1C 00 80 88 21 24 90 00 04 AF BF 00 24 C2 02 00 00 24 41 00 01 E2 01 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 16 00 00 00 00 8E 24 00 00 00 00 28 21 0? ?? ?? ?? 00 00 30 21 AE 20 00 14 AE 20 00 10 AE 20 00 0C 00 00 00 0F C2 02 00 00 24 01 00 00 E2 01 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 0A 02 00 20 21 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 0? ?? ?? ?? 02 00 20 21 0? ?? ?? ?? 8E 24 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 24 }
	condition:
		$1
}

rule file_239_0_0 {
	meta:
		name = "__fgets_unlocked_chk"
		size = 284
		refs = "0004 __gnu_local_gp 0064 _IO_getline 00b8 __libc_errno 0114 __chk_fail"
	strings:
		$1 = { 18 C0 00 42 3C 1C ?? ?? 8C E2 00 00 27 BD FF C8 AF B1 00 28 00 80 88 21 24 04 FF DF 27 9C ?? ?? 00 44 20 24 24 C6 FF FF AF B3 00 30 AF B2 00 2C AF B0 00 24 AF BC 00 18 00 A6 18 2B AF BF 00 34 00 A0 90 21 AC E4 00 00 24 04 00 01 00 E0 80 21 AF A4 00 10 02 20 28 21 00 E0 20 21 02 43 30 0B 24 07 00 0A 0? ?? ?? ?? 30 53 00 20 8F BC 00 18 14 40 00 0C 8E 04 00 00 8F BF 00 34 00 93 20 25 00 00 88 21 AE 04 00 00 02 20 10 21 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 38 30 83 00 20 10 60 00 09 00 00 00 00 7C 03 E8 3B 00 60 28 21 8F 83 ?? ?? 00 65 28 21 8C A5 00 00 24 03 00 0B 14 A3 FF EC 8F BF 00 34 00 52 90 2B 12 40 00 0F 02 22 10 21 A0 40 00 00 8E 04 00 00 8F BF 00 34 02 20 10 21 00 93 20 25 AE 04 00 00 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 38 03 E0 00 08 00 00 10 21 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_240_0_0 {
	meta:
		name = "ntp_gettimex"
		size = 100
		refs = "0014 __adjtimex"
	strings:
		$1 = { 27 BD FF 60 AF B0 00 98 00 80 80 21 27 A4 00 18 AF BF 00 9C 0? ?? ?? ?? AF A0 00 18 8F A3 00 3C 8F BF 00 9C AE 00 00 14 AE 03 00 00 8F A3 00 40 AE 00 00 18 AE 00 00 1C AE 03 00 04 8F A3 00 24 AE 00 00 20 AE 03 00 08 8F A3 00 28 AE 03 00 0C 8F A3 00 68 AE 03 00 10 8F B0 00 98 03 E0 00 08 27 BD 00 A0 }
	condition:
		$1
}

rule file_241_0_0 {
	meta:
		name = "__stpcpy"
		size = 44
	strings:
		$1 = { 0? ?? ?? ?? 00 80 10 21 00 60 10 21 80 A4 00 00 24 A5 00 01 A0 44 00 00 80 A4 FF FF 14 80 FF FA 24 43 00 01 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_242_0_0 {
	meta:
		name = "_dl_build_local_scope"
		size = 168
	strings:
		$1 = { 27 BD FF D0 AF B3 00 28 AF B2 00 24 AF B0 00 1C AF BF 00 2C AF B1 00 20 AC 85 00 00 8C A2 02 68 8C B0 02 C8 24 03 00 01 7C 62 D6 44 00 80 98 21 24 92 00 04 12 00 00 13 AC A2 02 68 8E 05 00 04 10 A0 00 10 26 10 00 04 0? ?? ?? ?? 3C 11 06 00 8E 05 00 00 10 A0 00 0C 8F BF 00 2C 8C A2 02 68 00 51 10 24 14 40 FF FA 26 10 00 04 0? ?? ?? ?? 02 40 20 21 8E 05 00 00 00 02 10 80 14 A0 FF F7 02 42 90 21 8F BF 00 2C 02 53 10 23 8F B1 00 20 8F B3 00 28 8F B2 00 24 8F B0 00 1C 00 02 10 83 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_242_1_0 {
	meta:
		name = "openaux"
		size = 92
		refs = "0040 _dl_map_object"
	strings:
		$1 = { 27 BD FF D8 AF B0 00 20 00 80 80 21 8E 03 00 08 8C 84 00 00 8E 05 00 10 3C 08 C0 00 8C 82 02 68 AF A3 00 10 8C 83 00 18 8E 07 00 04 00 48 40 24 24 06 00 01 00 02 17 82 AF A3 00 14 AF BF 00 24 0? ?? ?? ?? 00 48 30 0B 8F BF 00 24 AE 02 00 14 8F B0 00 20 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_242_2_0 {
	meta:
		name = "_dl_map_object_deps"
		size = 4460
		refs = "001c __gnu_local_gp 00dc __libc_errno 019c strchr 01c8 _dl_catch_error 0228 malloc 0248 memcpy 03ac strlen 04f8 _dl_debug_mask 0630 memset 07c4 memmove 0838 _dl_scope_free 09d0 _dl_dst_count 09e0 __libc_enable_secure 0a18 _dl_platformlen 0a6c _dl_dst_substitute 0b60 $LC4 0b68 _dl_debug_printf 0b90 _dl_get_origin 0bc4 _dl_signal_error 09ec $LC1 0bd8 $LC9 0bdc $LC3 0bf0 __assert_fail 0be0 __PRETTY_FUNCTION__.8921 0c10 $LC8 0b8c $LC2 0ca8 free 0d1c $LC5 0db0 _dl_argv 0dac $LC6 0dc4 $LC0 0e0c $LC13 0508 _dl_ns 0ed8 $LC12 0fa0 $LC11 0fb8 $LC10 1050 $LC7"
	strings:
		$1 = { 00 06 10 80 00 06 41 00 01 02 40 23 25 02 00 26 00 02 10 C2 27 BD FF 50 00 02 10 C0 3C 1C ?? ?? AF BE 00 A8 AF BF 00 AC AF B7 00 A4 AF B6 00 A0 AF B5 00 9C AF B4 00 98 AF B3 00 94 AF B2 00 90 AF B1 00 8C AF B0 00 88 03 A0 F0 21 03 A2 E8 23 27 A9 00 18 27 A2 00 24 27 9C ?? ?? AF DC 00 18 AF C9 00 60 AF C4 00 B0 AF A0 00 18 AF A4 00 1C AF A2 00 20 8C 82 02 68 24 03 00 01 AF C7 00 BC 7C 62 D6 44 25 09 00 18 10 C0 02 DB AC 82 02 68 8F C3 00 60 00 A0 20 21 24 07 00 01 24 62 00 18 00 69 48 21 8C 83 00 00 AC 40 FF F4 AC 42 FF FC AC 43 FF F8 8C 65 02 68 24 42 00 0C 24 84 00 04 7C E5 D6 44 14 49 FF F7 AC 65 02 68 8F C9 00 60 24 C6 00 01 AF C6 00 4C 8D 32 00 04 8F 89 ?? ?? 7C 03 E8 3B AF C0 00 3C AF C9 00 74 8F C9 00 60 AF C0 00 6C AF C0 00 68 01 28 40 21 8F C9 00 74 AD 00 00 08 AF C8 00 48 01 23 10 21 8C 49 00 00 AC 40 00 00 8E 42 02 30 AF C9 00 70 8F C9 00 60 24 03 00 01 3C 17 ?? ?? AF C9 00 58 8F C9 00 58 00 00 A0 21 10 40 00 77 AD 23 00 00 8E 42 00 24 10 40 00 91 00 00 00 00 8E 42 00 34 8E 51 00 08 8F C9 00 BC 8E 55 00 00 8C 43 00 04 8E 22 00 00 AF C9 00 24 8F C9 00 C0 02 A3 A8 21 AF D2 00 20 AF D5 00 2C 10 40 00 8A AF C9 00 28 8F C3 00 58 00 00 98 21 AF C3 00 54 24 03 00 01 14 43 01 C4 24 05 00 24 8E 30 00 04 02 B0 80 21 0? ?? ?? ?? 02 00 20 21 14 40 02 0A 00 40 20 21 27 C2 00 20 3C 07 ?? ?? AF D0 00 30 27 C4 00 38 AF A2 00 10 27 C5 00 3C 27 C6 00 40 0? ?? ?? ?? 24 E7 ?? ?? 8F D0 00 3C 16 00 00 74 3C 03 06 00 8F C2 00 34 8C 44 02 68 00 83 18 24 10 60 00 32 8F C9 00 48 12 80 00 04 00 13 18 80 02 83 18 21 AC 62 00 00 26 73 00 01 26 31 00 08 8E 22 00 00 14 40 FF DF 24 03 00 01 12 80 00 19 00 13 88 80 02 91 10 21 00 13 20 C0 AC 40 00 00 0? ?? ?? ?? 24 84 00 0C 10 40 02 76 00 40 80 21 26 33 00 04 02 80 28 21 02 60 30 21 24 44 00 04 0? ?? ?? ?? AC 52 00 00 26 24 00 08 02 04 20 21 02 00 28 21 0? ?? ?? ?? 02 60 30 21 00 00 00 0F 8E 42 02 68 24 03 00 01 AE 50 02 C8 7C 62 7B C4 AE 42 02 68 8F C3 00 58 8C 62 00 00 10 40 00 1D 8F C9 00 58 0? ?? ?? ?? 8F C2 00 58 8C 43 00 00 10 60 00 15 00 00 00 00 8C 42 00 08 14 40 FF FB 00 00 B0 21 0? ?? ?? ?? 8F C9 00 74 27 BD FF E8 27 A3 00 18 AF A2 00 1C AF A0 00 18 AF A0 00 20 AD 23 00 08 8C 44 02 68 8F C9 00 4C 24 05 00 01 7C A4 D6 44 25 29 00 01 AF C9 00 4C AC 44 02 68 0? ?? ?? ?? AF C3 00 48 AF C2 00 58 8F C3 00 58 8F C9 00 58 00 00 A0 21 8C 72 00 04 24 03 00 01 8E 42 02 30 14 40 FF 8B AD 23 00 00 8E 42 02 C8 14 40 FF 88 00 00 00 00 8F C9 00 B0 11 32 FF 85 00 00 00 00 96 42 02 2E 10 40 FF 82 00 02 10 80 8F C9 00 6C 01 22 18 2B 10 60 FF 7E 8F D4 00 68 24 03 FF F0 24 42 00 0F 00 43 10 24 24 43 00 0E 00 03 18 C2 00 03 18 C0 03 A3 E8 23 8F C9 00 68 27 B4 00 18 02 82 18 21 11 23 03 1D 00 00 00 00 AF C2 00 6C 8E 42 00 24 14 40 FF 71 AF D4 00 68 8E 42 01 C4 14 40 FF 6E 00 00 00 00 8E 42 01 BC 14 40 FF 6B 00 00 00 00 0? ?? ?? ?? 00 00 98 21 02 00 20 21 0? ?? ?? ?? 00 40 B0 21 24 43 00 0F 00 03 18 C2 00 03 18 C0 03 A3 E8 23 27 A4 00 18 02 00 28 21 0? ?? ?? ?? 24 46 00 01 8F D2 00 38 00 40 88 21 0? ?? ?? ?? 02 40 20 21 24 43 00 0F 00 03 18 C2 00 03 18 C0 03 A3 E8 23 27 A4 00 18 02 40 28 21 0? ?? ?? ?? 24 46 00 01 93 C3 00 40 14 60 02 F3 AF C2 00 38 24 02 FF FF AF D1 00 3C 00 56 B0 0A 8F C9 00 74 7C 03 E8 3B 01 23 10 21 8C 43 00 00 14 60 00 06 8F C9 00 B0 8F C9 00 70 11 20 00 02 00 00 00 00 AC 49 00 00 8F C9 00 B0 8D 29 02 C8 11 20 00 09 AF C9 00 50 8F C9 00 B0 3C 02 C0 00 8D 23 02 68 00 62 18 24 3C 02 80 00 10 62 01 D8 00 00 00 00 AF C0 00 50 8F C9 00 4C 00 09 20 C0 0? ?? ?? ?? 24 84 00 04 10 40 02 D1 00 40 88 21 8F C9 00 4C 8F C3 00 60 8F C8 00 BC 25 22 00 01 8F C9 00 B0 00 02 10 80 02 22 10 21 AD 22 02 30 8F C2 00 4C 00 00 80 21 3C 05 00 40 AD 22 02 34 01 20 30 21 15 00 02 72 8C 62 00 04 8C C7 02 30 00 10 20 80 26 10 00 01 00 E4 20 21 AC 82 00 00 8C 62 00 04 8C 44 02 68 7C 04 D6 44 AC 44 02 68 8C 63 00 08 14 60 FF F3 00 00 00 00 3C 02 ?? ?? 8C 42 ?? ?? 30 42 08 00 14 40 02 49 3C 02 ?? ?? 8F C9 00 B0 8D 25 02 30 8C B2 00 00 16 49 02 3C 8F C9 00 B0 8D 2B 02 CC 11 60 02 2F 2E 07 00 02 14 E0 02 C3 AF C7 00 48 24 A6 FF FC 00 10 A8 80 00 A0 10 21 00 D5 30 21 24 05 00 01 8C 43 00 04 24 42 00 04 8C 64 02 68 7C A4 D6 44 14 46 FF FB AC 64 02 68 8D 62 00 00 25 74 00 04 00 00 98 21 10 40 00 15 3C 17 06 00 AF D0 00 4C AF D1 00 54 02 80 80 21 02 40 A0 21 00 13 30 80 02 06 88 21 8E 22 00 00 8C 42 02 68 00 57 10 24 14 40 00 5D 00 00 00 00 8E 82 02 CC 8C 42 00 00 26 73 00 01 02 62 10 2B 14 40 FF F5 00 13 30 80 8F D0 00 4C 8F D1 00 54 02 80 90 21 8F C9 00 48 15 20 02 93 02 20 20 21 8E 45 02 30 24 A6 FF FC 00 A0 10 21 00 D5 30 21 8C 43 00 04 24 42 00 04 8C 64 02 68 7C 04 D6 44 14 46 FF FB AC 64 02 68 02 20 20 21 02 A0 30 21 0? ?? ?? ?? AF D5 00 48 00 10 30 40 24 C2 00 08 00 02 10 C2 00 02 10 C0 AF DD 00 5C 03 A2 E8 23 27 B3 00 18 00 10 B8 80 02 60 20 21 00 00 28 21 0? ?? ?? ?? 26 F7 FF FC 24 14 00 01 26 03 FF FF 02 37 B8 21 24 15 00 02 AF D7 00 58 AF D6 00 60 AF D2 00 64 02 60 B0 21 02 A0 90 21 AF C3 00 4C 24 0F 00 04 02 83 C0 2B 24 17 00 02 AF D1 00 54 02 00 98 21 02 80 A8 21 02 D2 48 21 95 22 00 00 8F C7 00 54 24 42 00 01 00 EF 20 21 8C 90 00 00 13 00 00 12 A5 22 00 00 8F D4 00 58 8F D1 00 4C 8E 82 00 00 8C 42 02 C8 14 40 00 05 00 00 00 00 0? ?? ?? ?? 26 31 FF FF 12 03 00 3A 24 42 00 04 8C 43 00 00 14 60 FF FC 00 00 00 00 26 31 FF FF 02 B1 10 2B 14 40 FF F2 26 94 FF FC 12 77 00 46 02 E0 A8 21 02 77 30 23 00 17 90 40 02 D2 20 21 00 00 28 21 0? ?? ?? ?? 00 06 30 40 8F C9 00 4C 00 17 78 80 02 E9 C0 2B 0? ?? ?? ?? 26 F7 00 01 8E 84 02 D0 AF C6 00 78 24 84 00 01 0? ?? ?? ?? 00 04 20 80 00 40 90 21 10 40 FF 9D 8F C6 00 78 24 44 00 04 0? ?? ?? ?? 02 00 28 21 8E 82 02 CC 26 69 00 01 8C 4A 00 00 01 2A 20 2B 10 80 02 38 02 60 30 21 00 0A 40 80 02 08 40 21 02 20 18 21 25 08 FF FC 8C 64 00 04 8C 87 02 68 00 F7 38 24 14 E0 00 04 00 06 38 80 02 47 38 21 AC E4 00 04 24 C6 00 01 24 63 00 04 14 68 FF F6 00 00 00 00 25 4A FF FF 01 49 48 21 01 33 98 23 0? ?? ?? ?? AE 46 00 00 8F C7 00 54 02 35 18 23 25 E5 00 04 00 E5 28 21 00 03 30 80 AF C3 00 7C AF C9 00 78 AF CF 00 80 0? ?? ?? ?? AF D8 00 84 00 17 28 40 02 C5 28 21 94 A4 00 00 02 75 10 23 AE 90 00 00 00 44 10 2B 8F C3 00 7C 10 40 00 23 8F C9 00 78 0? ?? ?? ?? 02 E0 A8 21 8F D6 00 60 8F D1 00 54 8F D2 00 64 8F DD 00 5C 8F C3 00 48 02 23 A8 21 AE A0 00 00 00 00 00 0F 8E 42 02 68 24 03 00 01 AE 51 02 C8 7C 62 7B C4 AE 42 02 68 8F C7 00 50 10 E0 00 03 00 00 00 00 0? ?? ?? ?? 00 E0 20 21 16 C0 01 EE 8F DF 00 AC 03 C0 E8 21 8F BE 00 A8 8F B7 00 A4 8F B6 00 A0 8F B5 00 9C 8F B4 00 98 8F B3 00 94 8F B2 00 90 8F B1 00 8C 8F B0 00 88 03 E0 00 08 27 BD 00 B0 95 30 00 00 02 D2 20 21 0? ?? ?? ?? 00 03 30 40 00 11 10 40 02 C2 10 21 A4 50 00 00 8F CF 00 80 0? ?? ?? ?? 8F D8 00 84 24 03 FF FD 00 43 10 24 3C 03 7F FF 34 63 FF FD 14 43 FE 54 00 00 00 00 8E 30 00 04 02 B0 80 21 0? ?? ?? ?? 02 00 20 21 14 40 00 6F 00 00 00 00 8E 23 00 00 3C 02 7F FF 34 42 FF FD 10 62 00 F8 AF D0 00 30 8E E2 ?? ?? 30 42 00 01 14 40 01 D5 27 C2 00 20 3C 07 ?? ?? AF A2 00 10 27 C4 00 38 27 C5 00 3C 27 C6 00 40 0? ?? ?? ?? 24 E7 ?? ?? 8F D0 00 3C 16 00 00 CB 02 00 20 21 8F C9 00 54 8F C2 00 34 27 BD FF E8 89 26 00 00 89 25 00 04 89 24 00 08 99 26 00 03 99 25 00 07 99 24 00 0B 27 A3 00 18 AC 66 00 00 AC 65 00 04 AC 64 00 08 AD 20 00 00 12 80 00 06 AD 22 00 04 00 13 20 80 02 84 20 21 AC 82 00 00 8F C2 00 34 26 73 00 01 8C 45 02 68 3C 04 06 00 00 A4 20 24 10 80 01 E1 24 06 00 01 0? ?? ?? ?? 00 60 20 21 8C A6 00 04 10 C2 01 BD 00 80 38 21 00 A0 20 21 8C 85 00 08 14 A0 FF FA 8F C9 00 54 8C 65 00 00 8C 64 00 04 8C 62 00 08 A9 25 00 00 B9 25 00 03 A9 24 00 04 B9 24 00 07 A9 22 00 08 0? ?? ?? ?? B9 22 00 0B 0? ?? ?? ?? 00 00 28 21 10 40 FD F4 AF C2 00 50 3C 02 ?? ?? 8C 42 ?? ?? 14 40 00 73 3C 07 ?? ?? 0? ?? ?? ?? 02 00 20 21 8E 44 02 7C 10 80 00 60 00 40 B0 21 24 02 FF FF 10 82 00 03 00 00 10 21 0? ?? ?? ?? 00 00 00 00 3C 03 ?? ?? 8C 64 ?? ?? 24 03 00 03 2C 86 00 03 00 86 18 0A 00 62 20 2B 00 44 18 0B 2C 62 00 05 14 40 00 06 26 C5 00 0E 8F C5 00 50 24 63 FF FC 70 65 30 02 00 D6 B0 21 26 C5 00 0E 00 05 28 C2 00 05 28 C0 03 A5 E8 23 02 40 20 21 02 00 28 21 27 A6 00 18 0? ?? ?? ?? 00 00 38 21 80 43 00 00 10 60 00 34 00 00 00 00 0? ?? ?? ?? 00 40 80 21 00 40 20 21 0? ?? ?? ?? 00 00 28 21 10 40 FF 8E AF C2 00 50 3C 02 ?? ?? 8C 42 ?? ?? 14 40 00 B2 3C 07 ?? ?? 0? ?? ?? ?? 02 00 20 21 8E 44 02 7C 10 80 00 9F 00 40 B0 21 24 02 FF FF 10 82 00 03 00 00 10 21 0? ?? ?? ?? 00 00 00 00 3C 03 ?? ?? 8C 64 ?? ?? 24 03 00 03 2C 85 00 03 00 85 18 0A 00 62 20 2B 00 64 10 0A 2C 43 00 05 14 60 00 04 8F C3 00 50 24 42 FF FC 70 43 20 02 00 96 B0 21 26 C2 00 0E 00 02 10 C2 00 02 10 C0 03 A2 E8 23 02 40 20 21 02 00 28 21 27 A6 00 18 0? ?? ?? ?? 00 00 38 21 80 43 00 00 14 60 00 7F 00 00 00 00 8E 23 00 00 3C 02 7F FF 34 42 FF FD 10 62 00 75 00 00 20 21 8E E2 ?? ?? 30 42 00 01 10 40 FD AC 26 31 00 08 26 31 FF F8 3C 04 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 02 00 28 21 0? ?? ?? ?? 26 31 00 08 0? ?? ?? ?? 00 00 10 21 8E 42 00 04 80 42 00 00 14 40 00 27 3C 04 ?? ?? 0? ?? ?? ?? 00 00 00 00 24 43 FF FF 2C 63 FF FE 10 60 FF F5 AE 42 02 7C 0? ?? ?? ?? 00 40 20 21 0? ?? ?? ?? 3C 03 ?? ?? 00 00 20 21 02 00 28 21 00 00 30 21 0? ?? ?? ?? 24 E7 ?? ?? 8D 22 02 30 10 40 FE 29 8F C9 00 4C 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 01 F9 0? ?? ?? ?? 24 E7 ?? ?? 24 09 00 01 8F D2 00 B0 00 00 40 21 0? ?? ?? ?? AF C9 00 4C 8F C9 00 B0 3C 07 ?? ?? 24 04 00 0C 8D 25 00 04 00 00 30 21 0? ?? ?? ?? 24 E7 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 F9 0? ?? ?? ?? 24 E7 ?? ?? 0? ?? ?? ?? 00 40 B0 21 24 43 00 0F 00 03 18 C2 00 03 18 C0 03 A3 E8 23 27 A4 00 18 02 00 28 21 0? ?? ?? ?? 24 46 00 01 8F D1 00 38 00 40 90 21 0? ?? ?? ?? 02 20 20 21 24 43 00 0F 00 03 18 C2 00 03 18 C0 03 A3 E8 23 27 A4 00 18 02 20 28 21 0? ?? ?? ?? 24 46 00 01 93 C3 00 40 10 60 00 03 AF C2 00 38 0? ?? ?? ?? 02 00 20 21 24 02 FF FF AF D2 00 3C 0? ?? ?? ?? 00 56 B0 0A 8E E2 ?? ?? 30 42 00 01 14 40 00 35 27 C2 00 20 3C 07 ?? ?? 27 C4 00 38 AF A2 00 10 27 C5 00 3C 27 C6 00 40 0? ?? ?? ?? 24 E7 ?? ?? 8F C4 00 3C 10 80 FF 0B 8F C9 00 54 93 C2 00 40 10 40 FD 41 00 00 00 00 0? ?? ?? ?? 26 31 00 08 0? ?? ?? ?? 8E 22 00 00 0? ?? ?? ?? 00 00 10 21 3C 07 ?? ?? 02 00 28 21 00 00 30 21 0? ?? ?? ?? 24 E7 ?? ?? 0? ?? ?? ?? 00 40 80 21 8E 42 00 04 80 42 00 00 14 40 00 10 3C 04 ?? ?? 0? ?? ?? ?? 00 00 00 00 24 43 FF FF 2C 63 FF FE 10 60 FF EE AE 42 02 7C 0? ?? ?? ?? 00 40 20 21 0? ?? ?? ?? 3C 03 ?? ?? 00 00 20 21 02 00 28 21 00 00 30 21 0? ?? ?? ?? 24 E7 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 01 2D 0? ?? ?? ?? 24 E7 ?? ?? 8E 46 00 04 80 C2 00 00 14 40 00 09 3C 04 ?? ?? 3C 05 ?? ?? 8C A2 ?? ?? 8C 46 00 00 14 C0 00 05 24 84 ?? ?? 3C 06 ?? ?? 24 C6 ?? ?? 3C 04 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 02 00 28 21 0? ?? ?? ?? 27 C2 00 20 00 10 18 80 02 20 20 21 00 60 30 21 0? ?? ?? ?? AF C3 00 48 2E 02 00 02 14 40 FE 83 8F C3 00 48 0? ?? ?? ?? 00 10 30 40 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 02 4A 0? ?? ?? ?? 24 E7 ?? ?? 8C 57 ?? ?? 8F C9 00 B0 16 E9 FD B6 00 00 00 00 12 00 FD B4 00 00 98 21 24 15 00 01 8E E3 02 30 00 13 10 80 00 62 10 21 8C 52 00 00 12 F2 00 07 00 00 00 00 8E 42 02 A4 10 40 00 11 00 00 00 00 8C 42 00 04 10 40 00 0E 00 00 00 00 26 73 00 01 16 70 FF F2 8F C9 00 B0 0? ?? ?? ?? 8D 25 02 30 8C 44 02 68 00 85 20 24 10 80 FD 8C 00 00 00 00 8C C4 02 34 24 84 FF FF 0? ?? ?? ?? AC C4 02 34 8E 42 01 C4 14 40 00 3A 00 00 00 00 8E 42 01 BC 14 40 00 37 02 20 20 21 0? ?? ?? ?? 02 40 28 21 00 40 A0 21 02 02 10 2B 14 40 00 2A 3C 04 ?? ?? 12 80 00 17 26 23 00 04 8E 24 00 00 00 00 10 21 8C 85 02 68 7C 05 D6 44 AC 85 02 68 24 42 00 01 12 82 00 10 26 86 00 02 8C 64 00 00 8C 85 02 68 7C 05 D6 44 10 40 00 08 AC 85 02 68 8C 64 00 00 8C 84 00 60 10 80 00 04 00 00 00 00 8E 44 02 68 7E A4 84 04 AE 44 02 68 0? ?? ?? ?? 24 63 00 04 26 86 00 02 00 06 30 80 00 C0 20 21 0? ?? ?? ?? AF C6 00 78 AE 42 02 A4 10 40 00 17 8F C6 00 78 24 43 00 08 00 60 20 21 02 20 28 21 24 C6 FF F8 AC 54 00 04 0? ?? ?? ?? AC 43 00 00 0? ?? ?? ?? 26 73 00 01 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 02 31 0? ?? ?? ?? 24 E7 ?? ?? 8E 45 00 04 3C 07 ?? ?? 24 04 00 16 00 00 30 21 0? ?? ?? ?? 24 E7 ?? ?? 8E E5 00 04 3C 07 ?? ?? 24 04 00 0C 00 00 30 21 0? ?? ?? ?? 24 E7 ?? ?? 8F C9 00 B0 0? ?? ?? ?? 8D 25 00 04 0? ?? ?? ?? 02 00 20 21 0? ?? ?? ?? 24 02 FF FF 8F C3 00 6C AF D4 00 68 00 62 18 21 0? ?? ?? ?? AF C3 00 6C 00 16 20 27 }
	condition:
		$1
}

rule file_243_0_0 {
	meta:
		name = "dlinfo_doit"
		size = 304
		refs = "00a8 _dl_rtld_di_serinfo 00dc strcpy 0114 _dl_signal_error 0104 $LC0 011c _dl_tls_get_addr_soft"
	strings:
		$1 = { 8C 82 00 08 27 BD FF E0 8C 86 00 04 2C 43 00 0B AF B0 00 18 AF BF 00 1C 10 60 00 3A 00 80 80 21 3C 03 ?? ?? 00 02 10 80 24 63 ?? ?? 00 62 10 21 8C 42 00 00 00 40 00 08 00 00 00 00 8C C3 03 14 14 60 00 36 00 00 10 21 8E 03 00 0C AC 62 00 00 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 8C C3 00 18 8C 82 00 0C AC 43 00 00 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 8C 82 00 0C 8F BF 00 1C 8F B0 00 18 AC 46 00 00 03 E0 00 08 27 BD 00 20 8C 85 00 0C 8F BF 00 1C 8F B0 00 18 00 C0 20 21 00 00 30 21 0? ?? ?? ?? 27 BD 00 20 8C 85 00 0C 8F BF 00 1C 8F B0 00 18 00 C0 20 21 24 06 00 01 0? ?? ?? ?? 27 BD 00 20 8F BF 00 1C 8F B0 00 18 8C 84 00 0C 8C C5 02 7C 0? ?? ?? ?? 27 BD 00 20 8C 82 00 0C AC 40 00 00 8C C3 03 14 AC 43 00 00 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 3C 07 ?? ?? 00 00 20 21 00 00 28 21 00 00 30 21 0? ?? ?? ?? 24 E7 ?? ?? 0? ?? ?? ?? 00 C0 20 21 8E 03 00 0C 0? ?? ?? ?? AC 62 00 00 }
	condition:
		$1
}

rule file_243_1_0 {
	meta:
		name = "__dlinfo"
		size = 60
		refs = "0020 _dlerror_run"
	strings:
		$1 = { 27 BD FF D0 AF A4 00 1C 3C 04 ?? ?? AF A5 00 20 24 84 ?? ?? 27 A5 00 18 AF BF 00 2C AF A7 00 18 0? ?? ?? ?? AF A6 00 24 8F BF 00 2C 00 02 10 2B 00 02 10 23 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_244_0_0 {
	meta:
		name = "abs"
		size = 16
		altNames = "labs"
	strings:
		$1 = { 00 04 1F C3 00 64 10 26 03 E0 00 08 00 43 10 23 }
	condition:
		$1
}

rule file_245_0_0 {
	meta:
		name = "_nl_init_alt_digit"
		size = 220
		refs = "0040 malloc 006c __rawmemchr 00ac _nl_cleanup_time"
	strings:
		$1 = { 27 BD FF D0 AF B0 00 1C AF BF 00 2C AF B3 00 28 AF B2 00 24 AF B1 00 20 8C 92 00 14 12 40 00 1F 00 80 80 21 8E 42 00 14 14 40 00 16 8F BF 00 2C 8E 11 00 E0 24 02 00 01 12 20 00 11 AE 42 00 14 0? ?? ?? ?? 24 04 01 90 10 40 00 0D AE 42 00 0C 00 00 80 21 0? ?? ?? ?? 24 13 01 90 8E 42 00 0C 00 50 10 21 AC 51 00 00 02 20 20 21 0? ?? ?? ?? 00 00 28 21 26 10 00 04 16 13 FF F8 24 51 00 01 8F BF 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 30 0? ?? ?? ?? 24 04 00 1C 10 40 FF F6 AE 02 00 14 3C 03 ?? ?? 24 63 ?? ?? AC 40 00 00 AC 40 00 04 AC 40 00 08 AC 40 00 0C AC 40 00 10 AC 40 00 14 AC 40 00 18 00 40 90 21 0? ?? ?? ?? AE 03 00 10 }
	condition:
		$1
}

rule file_245_1_0 {
	meta:
		name = "_nl_get_alt_digit"
		size = 220
		refs = "002c __pthread_rwlock_wrlock 003c __libc_setlocale_lock 0074 __pthread_rwlock_unlock"
	strings:
		$1 = { 27 BD FF D8 2C 82 00 64 AF B1 00 20 AF BF 00 24 AF B0 00 1C 10 40 00 2B 00 80 88 21 8C A2 00 E0 80 42 00 00 10 40 00 27 00 A0 80 21 3C 02 ?? ?? 24 42 ?? ?? 10 40 00 04 00 00 00 00 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 8E 02 00 14 10 40 00 16 00 00 00 00 8C 43 00 14 10 60 00 13 00 00 00 00 8C 42 00 0C 10 40 00 15 00 11 88 80 00 51 10 21 8C 50 00 00 3C 03 ?? ?? 24 63 ?? ?? 10 60 00 05 02 00 10 21 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 02 00 10 21 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 0? ?? ?? ?? 02 00 20 21 8E 02 00 14 14 40 FF EA 00 00 00 00 0? ?? ?? ?? 00 00 80 21 8F BF 00 24 8F B1 00 20 8F B0 00 1C 00 00 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_245_2_0 {
	meta:
		name = "_nl_get_walt_digit"
		size = 376
		refs = "0038 __pthread_rwlock_wrlock 0048 __libc_setlocale_lock 0078 malloc 00a4 wcschr 00cc __pthread_rwlock_unlock 0148 _nl_cleanup_time"
	strings:
		$1 = { 27 BD FF D0 2C 82 00 64 AF B4 00 28 AF BF 00 2C AF B3 00 24 AF B2 00 20 AF B1 00 1C AF B0 00 18 10 40 00 3A 00 80 A0 21 8C A2 01 AC 8C 42 00 00 10 40 00 36 00 A0 80 21 3C 02 ?? ?? 24 42 ?? ?? 10 40 00 04 00 00 00 00 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 8E 12 00 14 12 40 00 35 00 00 00 00 8E 42 00 18 14 40 00 14 24 02 00 01 8E 11 01 AC 12 20 00 11 AE 42 00 18 0? ?? ?? ?? 24 04 01 90 10 40 00 2F AE 42 00 10 00 00 80 21 0? ?? ?? ?? 24 13 01 90 8E 42 00 10 00 50 10 21 AC 51 00 00 02 20 20 21 0? ?? ?? ?? 00 00 28 21 26 10 00 04 16 13 FF F8 24 51 00 04 8E 42 00 10 10 40 00 20 00 14 A0 80 00 54 10 21 8C 50 00 00 3C 02 ?? ?? 24 42 ?? ?? 10 40 00 05 02 00 10 21 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 02 00 10 21 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 30 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 00 00 10 21 03 E0 00 08 27 BD 00 30 0? ?? ?? ?? 24 04 00 1C 14 40 00 03 AE 02 00 14 0? ?? ?? ?? 00 00 80 21 3C 03 ?? ?? 24 63 ?? ?? AC 40 00 00 AC 40 00 04 AC 40 00 08 AC 40 00 0C AC 40 00 10 AC 40 00 14 AC 40 00 18 00 40 90 21 0? ?? ?? ?? AE 03 00 10 }
	condition:
		$1
}

rule file_245_3_0 {
	meta:
		name = "_nl_parse_alt_digit"
		size = 344
		refs = "0040 __pthread_rwlock_wrlock 0050 __libc_setlocale_lock 0094 strlen 00b4 strncmp 00d0 __pthread_rwlock_unlock"
	strings:
		$1 = { 27 BD FF C0 AF B7 00 38 AF B5 00 30 AF B0 00 1C AF BF 00 3C AF B6 00 34 AF B4 00 2C AF B3 00 28 AF B2 00 24 AF B1 00 20 8C A2 01 AC 00 A0 80 21 00 80 B8 21 8C 42 00 00 10 40 00 45 8C 95 00 00 3C 02 ?? ?? 24 42 ?? ?? 10 40 00 04 00 00 00 00 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 8E 02 00 14 10 40 00 34 00 00 00 00 8C 43 00 14 10 60 00 31 00 00 00 00 8C 52 00 0C 12 40 00 33 00 00 98 21 00 00 80 21 24 14 FF FF 24 16 00 64 8E 51 00 00 26 52 00 04 0? ?? ?? ?? 02 20 20 21 00 40 30 21 02 20 20 21 00 40 88 21 02 62 10 2B 10 40 00 05 02 A0 28 21 0? ?? ?? ?? 00 00 00 00 02 02 A0 0A 02 22 98 0A 26 10 00 01 16 16 FF F0 00 00 00 00 3C 02 ?? ?? 24 42 ?? ?? 10 40 00 05 24 02 FF FF 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 24 02 FF FF 12 82 00 05 8F BF 00 3C 8E E2 00 00 00 53 98 21 AE F3 00 00 8F BF 00 3C 02 80 10 21 8F B7 00 38 8F B6 00 34 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 40 0? ?? ?? ?? 02 00 20 21 8E 02 00 14 14 40 FF CC 00 00 98 21 0? ?? ?? ?? 24 14 FF FF 0? ?? ?? ?? 24 14 FF FF }
	condition:
		$1
}

rule file_247_0_0 {
	meta:
		name = "is_dst"
		size = 324
	strings:
		$1 = { 80 A8 00 00 24 02 00 7B 11 02 00 36 00 00 48 21 80 C2 00 00 14 48 00 0F 00 00 18 21 15 00 00 07 24 63 00 01 24 63 FF FF 0? ?? ?? ?? 00 00 10 21 10 40 00 37 00 00 10 21 24 63 00 01 00 A3 40 21 00 C3 10 21 80 42 00 00 81 08 00 00 10 48 FF F8 00 00 00 00 11 20 00 05 24 06 00 7D 11 06 00 25 00 00 10 21 03 E0 00 08 00 00 00 00 11 00 00 09 8F A6 00 10 24 02 00 2F 11 02 00 06 00 00 00 00 10 E0 FF F8 00 00 10 21 24 06 00 3A 15 06 FF F5 8F A6 00 10 10 C0 FF F3 00 60 10 21 00 A3 10 21 80 46 00 00 10 C0 00 20 24 02 00 2F 10 C2 00 1E 00 00 00 00 10 E0 FF EB 00 00 10 21 24 07 00 3A 14 C7 FF E8 24 84 00 01 10 A4 00 15 00 00 00 00 80 A2 FF FE 38 42 00 3A 00 02 18 0B 03 E0 00 08 00 60 10 21 80 A8 00 01 24 09 00 01 0? ?? ?? ?? 24 A5 00 01 8F A6 00 10 24 63 00 02 24 A5 FF FF 10 C0 FF D8 00 60 10 21 0? ?? ?? ?? 00 A3 10 21 11 20 FF E0 8F A6 00 10 03 E0 00 08 00 00 00 00 03 E0 00 08 00 60 10 21 24 84 00 01 10 A4 FF FC 00 00 00 00 14 E0 FF E6 00 00 10 21 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_247_1_0 {
	meta:
		name = "is_trusted_path_normalize"
		size = 492
		refs = "00b8 memcmp"
	strings:
		$1 = { 27 BD FF D0 AF BE 00 28 AF B1 00 20 AF BF 00 2C AF B2 00 24 AF B0 00 1C 03 A0 F0 21 10 A0 00 31 00 00 88 21 80 83 00 00 24 02 00 3A 10 62 00 4E 24 07 00 2F 24 A5 00 10 00 05 28 C2 00 05 28 C0 03 A5 E8 23 27 B0 00 10 02 00 10 21 24 08 00 2E 10 60 00 09 00 00 00 00 10 67 00 2B 00 00 00 00 80 86 00 01 A0 43 00 00 00 C0 18 21 24 84 00 01 14 60 FF F9 24 42 00 01 10 50 00 05 00 40 18 21 80 45 FF FF 24 04 00 2F 10 A4 00 05 00 50 90 23 24 04 00 2F 24 42 00 01 A0 64 00 00 00 50 90 23 2E 42 00 05 14 40 00 0F 00 00 88 21 3C 04 ?? ?? 24 84 ?? ?? 02 00 28 21 0? ?? ?? ?? 24 06 00 05 10 40 00 48 2E 52 00 09 16 40 00 06 3C 04 ?? ?? 24 84 ?? ?? 02 00 28 21 0? ?? ?? ?? 24 06 00 09 2C 51 00 01 03 C0 E8 21 8F BF 00 2C 02 20 10 21 8F BE 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 30 80 85 00 01 10 A8 00 0C 00 00 00 00 02 02 30 2B 10 C0 00 07 00 00 00 00 80 49 FF FF 15 27 FF CF 00 A0 30 21 24 84 00 01 0? ?? ?? ?? 00 A0 18 21 0? ?? ?? ?? 00 A0 30 21 80 86 00 02 10 C8 00 13 00 00 00 00 10 C3 00 03 00 00 00 00 14 C0 FF EF 00 00 00 00 24 84 00 02 0? ?? ?? ?? 00 C0 18 21 24 A5 FF FF 24 A5 00 10 00 05 28 C2 00 05 28 C0 03 A5 E8 23 27 B0 00 10 80 83 00 01 02 00 10 21 24 84 00 01 0? ?? ?? ?? 24 08 00 2E 80 86 00 03 10 C3 00 03 00 00 00 00 14 C0 FF DC 00 00 00 00 02 02 18 2B 10 60 00 0A 00 00 00 00 80 43 FF FF 10 67 00 07 24 42 FF FF 10 50 00 05 00 00 00 00 24 42 FF FF 80 43 00 00 14 67 FF FB 00 00 00 00 24 84 00 03 0? ?? ?? ?? 00 C0 18 21 0? ?? ?? ?? 24 11 00 01 }
	condition:
		$1
}

rule file_247_2_0 {
	meta:
		name = "local_strdup"
		size = 92
		refs = "0010 strlen 001c malloc 0040 memcpy"
		altNames = "__strdup"
	strings:
		$1 = { 27 BD FF D8 AF BF 00 24 AF B1 00 20 AF B0 00 1C 0? ?? ?? ?? 00 80 88 21 24 50 00 01 0? ?? ?? ?? 02 00 20 21 10 40 00 08 00 40 20 21 8F BF 00 24 02 20 28 21 02 00 30 21 8F B1 00 20 8F B0 00 1C 0? ?? ?? ?? 27 BD 00 28 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_247_3_0 {
	meta:
		name = "fillin_rpath"
		size = 932
		refs = "004c __strsep_g 005c strlen 00d0 _dl_all_dirs 00dc curwd.9209 0114 memcmp 0204 malloc 0230 mempcpy 02a0 memcpy 039c _dl_signal_error 038c $LC0"
	strings:
		$1 = { 27 BD FF B0 AF B2 00 30 8F B2 00 64 AF B5 00 3C AF B4 00 38 AF B3 00 34 AF B0 00 28 AF BF 00 4C AF BE 00 48 AF B7 00 44 AF B6 00 40 AF B1 00 2C AF A4 00 50 00 A0 A8 21 00 C0 A0 21 AF A7 00 5C 00 00 80 21 3C 13 ?? ?? 27 A4 00 50 0? ?? ?? ?? 02 80 28 21 10 40 00 4B 00 40 B0 21 0? ?? ?? ?? 02 C0 20 21 10 40 00 1B 00 40 B8 21 2C 42 00 02 14 40 00 10 26 E3 FF FF 02 C3 10 21 80 44 00 00 24 02 00 2F 14 82 00 A8 24 04 00 01 10 64 00 09 24 05 00 2F 24 66 FF FF 02 C6 10 21 80 42 00 00 14 45 00 8B 02 C3 10 21 00 C0 18 21 14 64 FF FA 24 66 FF FF 82 C3 00 00 24 02 00 2F 14 62 00 82 8F A4 00 5C 14 80 FF E0 24 17 00 01 0? ?? ?? ?? 8E 71 ?? ?? 8F A4 00 5C 14 80 FF DB 3C 02 ?? ?? 24 56 ?? ?? 8E 71 ?? ?? 12 20 00 36 02 20 F0 21 0? ?? ?? ?? 8F C3 00 10 8F DE 00 00 13 C0 00 31 00 00 00 00 8F C3 00 10 14 77 FF FB 02 C0 20 21 8F C5 00 0C 0? ?? ?? ?? 02 E0 30 21 14 40 FF F6 00 00 00 00 12 00 00 8A 00 00 18 21 8E A2 00 00 10 5E FF C5 26 A3 00 04 00 00 10 21 24 42 00 01 10 50 00 07 24 63 00 04 8C 64 FF FC 14 9E FF FC 24 42 00 01 24 42 FF FF 16 02 FF BC 27 A4 00 50 00 02 18 80 02 A3 18 21 24 50 00 01 AC 7E 00 00 27 A4 00 50 0? ?? ?? ?? 02 80 28 21 14 40 FF B7 00 40 B0 21 8F BF 00 4C 00 10 10 80 02 A2 10 21 AC 40 00 00 8F BE 00 48 02 A0 10 21 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 12 40 00 56 00 00 00 00 0? ?? ?? ?? 02 40 20 21 24 42 00 01 AF A2 00 18 3C 04 ?? ?? 8C 89 ?? ?? 25 23 00 05 00 03 18 80 24 62 00 01 AF A2 00 1C 00 57 20 21 8F A2 00 18 AF A3 00 20 AF A9 00 24 0? ?? ?? ?? 00 82 20 21 00 40 F0 21 8F A3 00 20 10 40 00 5D 8F A9 00 24 00 43 10 21 00 40 20 21 AF C2 00 0C 02 C0 28 21 02 E0 30 21 0? ?? ?? ?? AF A9 00 24 3C 04 ?? ?? 8C 83 ?? ?? A0 40 00 00 AF D7 00 10 00 77 18 2B 10 60 00 02 8F A9 00 24 AC 97 ?? ?? 82 C2 00 00 24 05 00 02 03 C0 20 21 38 42 00 2F 00 02 28 0A 11 20 00 05 00 00 18 21 24 63 00 01 AC 85 00 14 14 69 FF FD 24 84 00 04 8F A2 00 60 12 40 00 3E AF C2 00 04 8F A2 00 1C 8F A6 00 18 02 40 28 21 00 57 20 21 0? ?? ?? ?? 03 C4 20 21 AF C2 00 08 00 10 10 80 02 A2 10 21 AE 7E ?? ?? AF D1 00 00 26 10 00 01 0? ?? ?? ?? AC 5E 00 00 24 03 00 01 02 C3 10 21 24 77 00 01 24 03 00 2F A0 43 00 00 8F A2 00 5C 10 40 FF 81 8E 71 ?? ?? 24 02 00 05 12 E2 00 1C 24 02 00 09 16 E2 FF 55 27 A4 00 50 3C 04 ?? ?? 24 84 ?? ?? 02 C0 28 21 0? ?? ?? ?? 24 06 00 09 14 40 FF 4E 27 A4 00 50 0? ?? ?? ?? 8E 71 ?? ?? 0? ?? ?? ?? AF A0 00 18 02 E0 18 21 02 C3 10 21 24 77 00 01 24 03 00 2F A0 43 00 00 8F A2 00 5C 10 40 FF 69 8E 71 ?? ?? 0? ?? ?? ?? 24 02 00 05 02 A3 18 21 24 10 00 01 0? ?? ?? ?? AC 7E 00 00 3C 04 ?? ?? 24 84 ?? ?? 02 C0 28 21 0? ?? ?? ?? 24 06 00 05 14 40 FF 35 27 A4 00 50 0? ?? ?? ?? 8E 71 ?? ?? 0? ?? ?? ?? AF C0 00 08 3C 07 ?? ?? 24 04 00 0C 00 00 28 21 00 00 30 21 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_247_4_0 {
	meta:
		name = "add_name_to_object.isra.2"
		size = 268
		refs = "0040 strcmp 0068 strlen 0074 malloc 008c memcpy 00d4 $LC2 00d8 $LC3 00ec __assert_fail 00dc __PRETTY_FUNCTION__.9190 0104 _dl_signal_error 00f4 $LC1"
	strings:
		$1 = { 27 BD FF D0 AF B1 00 20 AF B0 00 1C AF BF 00 2C AF B3 00 28 AF B2 00 24 00 80 80 21 14 80 00 07 00 A0 88 21 0? ?? ?? ?? 00 00 00 00 8E 02 00 04 10 40 00 0D 00 00 00 00 00 40 80 21 8E 05 00 00 0? ?? ?? ?? 02 20 20 21 14 40 FF F8 8F BF 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 30 0? ?? ?? ?? 02 20 20 21 24 44 00 0D 0? ?? ?? ?? 24 53 00 01 10 40 00 1D 00 40 90 21 02 20 28 21 02 60 30 21 0? ?? ?? ?? 24 44 00 0C 8F BF 00 2C AE 42 00 00 AE 40 00 04 AE 40 00 08 8F B3 00 28 AE 12 00 04 8F B1 00 20 8F B2 00 24 8F B0 00 1C 03 E0 00 08 27 BD 00 30 0? ?? ?? ?? 00 A0 20 21 0? ?? ?? ?? 24 44 00 0D 10 40 00 08 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 01 D5 0? ?? ?? ?? 24 E7 ?? ?? 3C 07 ?? ?? 24 04 00 0C 02 20 28 21 00 00 30 21 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_247_5_0 {
	meta:
		name = "lose.isra.3"
		size = 144
		refs = "0038 __close 0054 free 0074 _dl_debug_state 0088 _dl_signal_error"
	strings:
		$1 = { 27 BD FF D0 24 03 FF FF AF B4 00 28 AF B3 00 24 AF B2 00 20 AF B1 00 1C AF B0 00 18 AF BF 00 2C 00 80 98 21 00 C0 90 21 00 E0 A0 21 8F B0 00 40 10 A3 00 03 8F B1 00 48 0? ?? ?? ?? 00 A0 20 21 12 00 00 06 24 03 FF FF 8E 04 02 7C 10 83 00 03 00 00 00 00 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 02 00 20 21 0? ?? ?? ?? 02 80 20 21 12 20 00 04 8F A7 00 44 0? ?? ?? ?? AE 20 00 0C 8F A7 00 44 02 60 20 21 02 40 28 21 0? ?? ?? ?? 00 00 30 21 }
	condition:
		$1
}

rule file_247_6_0 {
	meta:
		name = "_dl_map_object_from_fd"
		size = 3824
		refs = "0038 __gnu_local_gp 0050 _dl_debug_initialize 0064 __fxstat64 0088 _dl_ns 0100 __close 0108 free 0160 _dl_debug_mask 01a8 _dl_new_object 0310 _dl_use_load_bias 0330 __mmap 03a4 _dl_pagesize 0400 memset 0490 $LC18 05a0 _dl_next_tls_modid 0810 _dl_stack_flags 0890 _dl_setup_hash 08c4 _dl_initfirst 08cc _dl_profile 08f8 _dl_add_to_namespace_list 0948 __mprotect 095c _dl_debug_state 0984 __lseek 0998 __libc_read 09e4 $LC20 0aa4 $LC9 0ae4 malloc 0afc memcpy 0b1c $LC17 0b30 $LC12 0b44 $LC13 0b54 $LC6 0b64 __libc_errno 0b74 $LC7 071c $LC23 0b80 $LC24 0b94 __assert_fail 0b84 __PRETTY_FUNCTION__.9074 073c $LC25 075c $LC26 0c18 __munmap 0c50 $LC10 0c7c _dl_tls_dtv_slotinfo_list 0c90 _dl_tls_setup 0cac _dl_allocate_tls 0cdc _dl_deallocate_tls 0ce4 $LC15 0cf8 _dl_debug_printf 0cf4 $LC27 0d0c _dl_tls_max_dtv_idx 0d20 $LC14 0d60 memmove 0da0 $LC28 0dc8 $LC8 0dd4 __stack_prot 0dd8 _dl_make_stack_executable_hook 0df4 $LC11 0e38 $LC4 0e50 $LC21 0e64 $LC16 0e74 $LC22 0e78 $LC3 0e7c __PRETTY_FUNCTION__.9329 0e94 $LC5 0ec8 $LC19"
	strings:
		$1 = { 27 BD FE D0 AF BE 01 28 03 A0 F0 21 AF BF 01 2C AF B7 01 24 AF B6 01 20 AF B5 01 1C AF B4 01 18 AF B3 01 14 AF B2 01 10 AF B1 01 0C AF B0 01 08 AF C5 01 34 8F C5 01 50 3C 1C ?? ?? 27 9C ?? ?? AF C4 01 30 00 00 20 21 AF DC 00 38 00 C0 B8 21 0? ?? ?? ?? AF C7 01 3C 8F C5 01 34 24 04 00 03 27 C6 00 40 0? ?? ?? ?? AF C2 00 E4 04 40 03 72 8F DC 00 38 8F C5 01 50 00 05 11 00 00 05 18 80 00 62 18 21 00 65 18 23 3C 02 ?? ?? 00 03 18 80 24 42 ?? ?? 00 62 10 21 8C 51 00 00 12 20 00 2D 8F C4 00 50 8F C5 00 54 8F C6 00 40 0? ?? ?? ?? 3C 03 00 04 8E 31 00 0C 12 20 00 26 00 00 00 00 8E 22 02 68 00 43 10 24 14 40 FF FA 00 00 00 00 8E 22 02 B8 14 44 FF F7 00 00 00 00 8E 22 02 BC 14 45 FF F4 00 00 00 00 8E 22 02 B0 14 40 FF F1 00 00 00 00 8E 22 02 B4 14 46 FF EE 00 00 00 00 0? ?? ?? ?? 8F C4 01 34 0? ?? ?? ?? 8F C4 01 3C 8E 24 00 1C 0? ?? ?? ?? 8F C5 01 30 03 C0 E8 21 8F BF 01 2C 02 20 10 21 8F BE 01 28 8F B7 01 24 8F B6 01 20 8F B5 01 1C 8F B4 01 18 8F B3 01 14 8F B2 01 10 8F B1 01 0C 8F B0 01 08 03 E0 00 08 27 BD 01 30 8F C6 01 48 30 C2 00 08 14 40 02 48 3C 03 ?? ?? 8C 62 ?? ?? 30 42 00 40 14 40 03 37 8F C5 01 30 8F C4 00 E4 8C 82 00 0C 10 40 01 F6 24 03 00 01 14 43 03 3B AF C0 00 F4 8F C6 01 48 AF A6 00 10 8F C2 01 50 AF A2 00 14 8F C4 01 3C 8F C5 01 30 8F C6 01 44 0? ?? ?? ?? 8F C7 01 40 00 40 88 21 10 40 03 37 8F DC 00 38 96 E2 00 30 8E E5 00 20 8E E3 00 00 00 02 81 40 02 05 30 21 8E E4 00 1C 00 66 18 2B 96 E6 00 14 AE 24 02 28 A6 22 02 2C 14 60 01 E2 AF C6 00 E8 02 E5 28 21 24 B2 00 04 02 00 18 21 00 02 10 C0 00 62 18 23 24 63 00 08 02 50 80 21 AF DD 00 F0 02 50 80 2B 03 A3 E8 23 12 00 02 41 27 B5 00 38 3C 14 64 74 36 94 E5 51 24 03 00 07 AF D7 00 EC 02 40 80 21 00 00 B0 21 00 00 98 21 AF C3 00 E0 26 85 00 01 3C 06 ?? ?? 0? ?? ?? ?? 24 17 00 07 10 54 00 DF 00 00 00 00 10 45 00 D8 24 03 00 07 10 43 00 BE 00 00 00 00 96 22 02 2C 26 10 00 20 00 02 11 40 02 42 10 21 02 02 10 2B 10 40 00 16 00 00 00 00 8E 02 00 00 24 03 00 06 10 43 00 84 2C 43 00 07 10 60 FF EE 24 03 00 01 10 43 00 83 24 03 00 02 14 43 FF F0 00 00 00 00 8E 02 00 14 8E 03 00 08 26 10 00 20 00 02 10 C2 A6 22 02 2E 96 22 02 2C 00 02 11 40 02 42 10 21 02 02 10 2B 14 40 FF EC AE 23 00 08 AF D7 00 E0 12 60 02 10 8F D7 00 EC 26 62 FF FF 00 02 18 C0 00 02 A1 40 02 83 A0 23 02 B4 A0 21 8E A2 00 00 8E 90 00 0C 8F C4 00 E8 24 03 00 03 14 83 02 BE 02 02 80 23 8F C5 01 34 3C 03 ?? ?? 8C 64 ?? ?? 8E A6 00 14 AF A5 00 10 8E A3 00 10 00 44 20 24 02 00 28 21 AF A3 00 14 0? ?? ?? ?? 24 07 20 02 24 03 FF FF 8F DC 00 38 10 43 00 53 AE 22 02 80 8E A3 00 00 00 50 20 21 AE 24 02 84 00 43 20 23 16 C0 01 77 AE 24 00 00 8E 22 02 68 24 03 00 01 02 A0 A0 21 7C 62 8C 44 AE 22 02 68 8E 86 00 14 30 C2 00 04 14 40 00 9A 00 00 00 00 8E 22 02 24 10 40 00 9E 00 00 00 00 8E 82 00 0C 8E 83 00 08 00 62 20 2B 10 80 00 23 00 00 00 00 3C 08 ?? ?? 8E 36 00 00 8D 05 ?? ?? 02 C3 18 21 24 A7 FF FF 00 E3 38 21 00 05 20 23 02 C2 B0 21 00 E4 10 24 02 C2 38 2B 02 C7 10 0B 00 40 38 21 00 62 10 2B 10 40 00 12 00 F6 10 2B 30 C2 00 02 10 40 02 AE 00 83 20 24 00 E3 30 23 00 60 20 21 00 00 28 21 AF C3 01 00 AF C7 00 FC 0? ?? ?? ?? AF C8 00 F8 8E 86 00 14 8F C3 01 00 8F C7 00 FC 30 C2 00 02 10 40 02 AE 8F C8 00 F8 00 F6 10 2B 14 40 01 64 24 03 FF FF 26 94 00 18 00 13 10 C0 00 13 19 40 00 62 10 23 02 A2 10 21 02 82 10 2B 10 40 00 81 00 00 00 00 8E 85 00 04 8E 82 00 00 00 45 18 2B 10 60 FF C6 8F C3 01 34 8E 24 00 00 8E 86 00 14 AF A3 00 10 8E 83 00 10 00 44 20 21 00 A2 28 23 AF A3 00 14 0? ?? ?? ?? 24 07 20 12 24 03 FF FF 14 43 FF BA 8F DC 00 38 3C 05 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 8E 02 00 08 0? ?? ?? ?? AE 22 02 24 8C C7 ?? ?? 8E 03 00 1C 24 E4 FF FF 00 64 20 24 14 80 01 9D 24 63 FF FF 8E 04 00 08 8E 08 00 04 00 88 48 23 00 69 18 24 14 60 01 9C 00 13 51 40 8E 09 00 10 8E 0B 00 14 00 89 48 21 00 13 18 C0 24 EC FF FF 01 43 18 23 00 07 38 23 26 73 00 01 01 89 60 21 02 A3 18 21 00 87 50 24 01 87 60 24 01 64 20 21 01 07 38 24 2E 6B 00 02 AC 6A 00 00 AC 6C 00 04 AC 69 00 08 AC 64 00 0C 15 60 00 04 AC 67 00 10 8C 64 FF EC 01 44 50 26 00 4A B0 0B 8E 02 00 18 3C 04 73 51 34 84 62 40 00 02 10 80 00 44 10 07 30 42 00 0F 0? ?? ?? ?? AC 62 00 14 8E 02 00 14 10 40 FF 41 00 00 00 00 8E 03 00 1C AE 22 03 04 14 60 00 19 AE 23 03 08 8E 02 00 08 AE 20 03 0C 8E 27 02 68 8E 04 00 10 3C 03 C0 00 AE 22 02 FC 00 E3 18 24 3C 02 40 00 14 62 01 B9 AE 24 03 00 AF C5 00 F8 0? ?? ?? ?? AF C6 00 FC AE 22 03 14 8F C5 00 F8 0? ?? ?? ?? 8F C6 00 FC 8E 03 00 08 8E 02 00 14 AE 23 03 1C 0? ?? ?? ?? AE 22 03 20 0? ?? ?? ?? 8E 17 00 18 8E 02 00 08 24 63 FF FF 00 62 18 24 0? ?? ?? ?? AE 23 03 0C 8E 83 00 04 8E 22 00 00 00 62 10 21 AE 22 02 88 8E 22 02 24 14 40 FF 64 00 00 00 00 8E 82 00 10 8E E3 00 20 00 62 20 2B 14 80 FF 5F 00 00 00 00 8E 87 00 04 96 E5 00 30 8E 84 00 00 00 47 38 21 00 05 29 40 00 E4 38 23 00 A3 28 21 00 E5 28 2B 14 A0 FF 55 00 83 18 21 00 62 10 23 0? ?? ?? ?? AE 22 02 24 8E 22 00 08 10 40 01 11 8F DD 00 F0 8E 23 00 00 00 43 18 21 10 60 01 05 AE 23 00 08 8C 62 00 00 10 40 00 24 26 25 00 20 3C 06 6F FF 34 C6 FF FF 3C 08 10 00 3C 07 90 00 24 CA FE 00 24 CC FF 00 3C 0B C0 00 24 C9 00 57 0? ?? ?? ?? 25 08 00 22 00 48 10 21 00 02 10 80 00 A2 10 21 AC 43 00 00 24 63 00 08 8C 62 00 00 10 40 00 12 00 00 00 00 2C 44 00 22 14 80 FF F7 00 47 20 21 2C 84 00 35 14 80 FF F3 00 C2 20 23 2C 84 00 10 10 80 00 C6 00 02 20 40 01 22 10 23 00 02 10 80 00 A2 10 21 AC 43 00 00 24 63 00 08 8C 62 00 00 14 40 FF F1 2C 44 00 22 8E 22 00 70 10 40 00 06 24 03 00 11 8C 42 00 04 10 43 00 03 24 03 00 07 14 43 01 19 3C 04 ?? ?? 8E 22 00 3C 10 40 00 06 00 00 00 00 8E 22 00 44 8C 43 00 04 24 02 00 0C 14 62 01 18 3C 04 ?? ?? 8E 22 00 64 10 40 00 06 00 00 00 00 8E 22 00 6C 8C 43 00 04 24 02 00 08 14 62 01 17 3C 04 ?? ?? 8E 23 00 98 10 60 00 0E 00 00 00 00 8C 62 00 04 30 44 00 02 10 80 00 02 AE 22 02 E0 AE 23 00 60 30 44 00 04 10 80 00 02 00 00 00 00 AE 23 00 78 30 42 00 08 10 40 00 02 00 00 00 00 AE 23 00 80 8E 22 01 8C 10 40 00 B2 3C 06 ?? ?? 8C C5 ?? ?? 8C 44 00 04 30 A5 00 40 00 80 18 21 AE 24 02 DC 14 A0 01 27 00 80 10 21 30 63 00 01 10 60 00 03 00 00 00 00 8E 23 01 8C AE 23 00 80 8E 23 00 94 10 60 00 02 00 00 00 00 AE 20 00 5C 30 42 00 40 14 40 01 05 8F C2 01 48 8E 22 02 24 10 40 00 B7 00 00 00 00 8E 23 00 00 00 43 10 21 AE 22 02 24 3C 02 ?? ?? 8C 42 ?? ?? 8F C3 00 E0 00 02 10 27 00 62 10 24 30 42 00 01 14 40 01 6A 3C 02 ?? ?? 8E 22 02 FC 10 40 00 04 00 00 00 00 8E 23 00 00 00 43 10 21 AE 22 02 FC 0? ?? ?? ?? 8F C4 01 34 14 40 01 5D 8F DC 00 38 8E 22 02 68 3C 04 C0 00 3C 03 40 00 00 44 20 24 10 83 00 7B 8F C4 00 E8 3C 05 ?? ?? 8E 22 02 28 8E 23 00 00 8C A4 ?? ?? 00 62 10 21 30 84 00 40 14 80 01 3B AE 22 02 28 0? ?? ?? ?? 02 20 20 21 8F C6 01 48 30 C2 00 10 14 40 00 04 00 00 00 00 8E 22 00 60 14 40 01 20 26 22 02 30 8E 22 02 DC 30 42 00 20 10 40 00 04 3C 02 ?? ?? 3C 02 ?? ?? AC 51 ?? ?? 3C 02 ?? ?? 8C 44 ?? ?? 8F C2 00 40 8F C3 00 54 AE 20 02 B0 AE 22 02 B4 8F C2 00 50 AE 23 02 BC 14 80 00 B9 AE 22 02 B8 8F C5 01 50 0? ?? ?? ?? 02 20 20 21 02 20 10 21 03 C0 E8 21 8F BF 01 2C 8F BE 01 28 8F B7 01 24 8F B6 01 20 8F B5 01 1C 8F B4 01 18 8F B3 01 14 8F B2 01 10 8F B1 01 0C 8F B0 01 08 03 E0 00 08 27 BD 01 30 8E A3 00 04 8E 85 00 00 00 00 30 21 00 83 20 21 0? ?? ?? ?? 00 A3 28 23 0? ?? ?? ?? 8E 22 02 68 24 02 00 01 0? ?? ?? ?? AC 82 00 0C 24 05 00 01 0? ?? ?? ?? AF C5 00 F4 26 02 00 0E 8F C4 01 34 00 02 10 C2 00 02 10 C0 03 A2 E8 23 0? ?? ?? ?? 00 00 30 21 8F C4 01 34 27 B2 00 38 02 40 28 21 0? ?? ?? ?? 02 00 30 21 14 50 00 6C 8F DC 00 38 96 22 02 2C 00 02 19 40 0? ?? ?? ?? 00 60 80 21 8E 86 00 14 AF A3 00 10 00 E0 20 21 AF A0 00 14 02 C7 28 23 AF C3 01 00 0? ?? ?? ?? 24 07 08 12 8F C3 01 00 14 43 FE 93 8F DC 00 38 3C 05 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 8F DD 00 F0 00 04 20 43 2C 8D FF FD 15 A0 00 06 00 00 00 00 00 04 10 27 00 02 10 80 00 A2 10 21 0? ?? ?? ?? AC 43 01 9C 01 42 20 23 2C 84 00 0C 10 80 00 06 01 82 20 23 00 02 10 80 00 A2 10 23 01 62 10 21 0? ?? ?? ?? AC 43 F9 A4 2C 84 00 0B 10 80 FF 1A 00 02 10 80 00 A2 10 23 01 62 10 21 0? ?? ?? ?? AC 43 FD D4 24 03 00 02 14 83 FF 85 3C 05 ?? ?? 7C 02 FF 84 0? ?? ?? ?? AE 22 02 68 0? ?? ?? ?? 8E 22 02 DC 0? ?? ?? ?? 8E 22 02 DC 0? ?? ?? ?? 8F C4 01 3C 0? ?? ?? ?? 8F C4 01 34 0? ?? ?? ?? 00 00 10 21 8F C4 00 E8 24 02 00 03 14 82 FF F5 3C 05 ?? ?? 00 00 10 21 24 A5 ?? ?? 8F C4 00 F4 8F C3 00 E4 AF B1 00 10 AF A5 00 14 00 04 18 0A AF A3 00 18 8F C5 01 34 8F C6 01 30 8F C7 01 3C 0? ?? ?? ?? 00 40 20 21 96 F3 00 30 00 13 99 40 0? ?? ?? ?? 02 60 20 21 10 40 00 21 8F DC 00 38 00 40 20 21 02 40 28 21 0? ?? ?? ?? 02 60 30 21 8E 23 02 68 AE 22 02 24 24 02 00 01 7C 43 C6 04 0? ?? ?? ?? AE 23 02 68 3C 05 ?? ?? 00 00 10 21 24 A5 ?? ?? 0? ?? ?? ?? 8F DD 00 F0 3C 05 ?? ?? 00 00 10 21 24 A5 ?? ?? 0? ?? ?? ?? 8F DD 00 F0 3C 05 ?? ?? 00 00 10 21 0? ?? ?? ?? 24 A5 ?? ?? 3C 05 ?? ?? 24 A5 ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 0? ?? ?? ?? 8C 42 00 00 3C 05 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 73 0? ?? ?? ?? 24 E7 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 78 0? ?? ?? ?? 24 E7 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 7C 0? ?? ?? ?? 24 E7 ?? ?? 8E 22 00 58 10 40 FF 46 00 00 00 00 8E 24 00 34 8C 43 00 04 8E 22 00 00 8C 85 00 04 8E 24 00 1C 00 A3 28 21 0? ?? ?? ?? 00 A2 28 21 0? ?? ?? ?? 8F C5 01 50 04 41 FE FB 00 00 00 00 8E 24 02 80 8E 25 02 84 0? ?? ?? ?? 00 A4 28 23 8E 24 00 1C 8C 82 00 08 14 40 00 03 00 00 00 00 0? ?? ?? ?? 00 00 00 00 8E 22 02 68 7C 42 06 00 10 40 00 03 00 00 00 00 0? ?? ?? ?? 8E 24 02 24 3C 05 ?? ?? 00 00 10 21 0? ?? ?? ?? 24 A5 ?? ?? 24 05 F7 16 00 85 28 24 14 A0 00 22 00 00 00 00 00 80 18 21 0? ?? ?? ?? 00 80 10 21 3C 03 ?? ?? 8C 62 ?? ?? 14 40 FE 45 00 00 00 00 AF C5 00 F8 0? ?? ?? ?? AF C6 00 FC 8F C5 00 F8 14 40 00 20 8F C6 00 FC 00 00 20 21 AF C5 00 F8 0? ?? ?? ?? AF C6 00 FC 00 40 F8 21 8F C5 00 F8 10 40 00 18 8F C6 00 FC 24 44 70 00 24 02 10 BB 00 00 00 0C 10 E0 00 0E 3C 03 ?? ?? 03 E0 20 21 0? ?? ?? ?? 24 05 00 01 3C 05 ?? ?? 00 00 10 21 0? ?? ?? ?? 24 A5 ?? ?? 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 8E 22 02 DC 0? ?? ?? ?? 00 40 18 21 8C 62 ?? ?? 24 42 00 01 AC 62 ?? ?? 0? ?? ?? ?? AE 22 03 14 3C 05 ?? ?? 24 02 00 0C 0? ?? ?? ?? 24 A5 ?? ?? 8E 23 02 A0 8C 63 00 00 10 62 FE DE 00 00 00 00 8E 22 02 38 8E 26 02 9C AC 51 00 00 8E 25 02 A0 24 02 00 01 00 06 30 80 AE 22 02 3C 24 A4 00 04 0? ?? ?? ?? 24 C6 FF FC 8E 22 02 A0 26 23 02 38 0? ?? ?? ?? AC 43 00 00 24 04 00 08 8E 26 00 08 AF A4 00 14 AF A4 00 1C AF A4 00 24 AF A3 00 10 AF B0 00 18 AF A2 00 20 8E 22 02 24 AF A4 00 2C 3C 04 ?? ?? AF A2 00 28 96 22 02 2C 24 84 ?? ?? 24 05 00 08 AF A2 00 30 0? ?? ?? ?? 24 07 00 08 0? ?? ?? ?? 00 00 00 00 3C 05 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 8C 43 ?? ?? 3C 04 ?? ?? 8C 99 ?? ?? 8F C4 01 4C 34 63 00 07 03 20 F8 09 AC 43 ?? ?? 10 40 FE 8F 3C 05 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 8F C6 01 48 7C C3 07 40 10 60 00 16 3A D6 00 01 8E 24 00 00 8E 23 02 68 00 44 10 21 00 50 20 21 7E C3 8C 44 AE 22 02 80 AE 24 02 84 AE 23 02 68 0? ?? ?? ?? 02 A0 A0 21 3C 05 ?? ?? AF C0 00 F4 24 A5 ?? ?? 0? ?? ?? ?? 00 00 88 21 8F C6 01 50 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 8F C4 00 E4 3C 05 ?? ?? 00 00 10 21 0? ?? ?? ?? 24 A5 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 04 1A 0? ?? ?? ?? 24 E7 ?? ?? 3C 05 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 34 C6 00 02 AF C3 01 00 AF C7 00 FC 0? ?? ?? ?? AF C8 00 F8 8F DC 00 38 8F C3 01 00 8F C7 00 FC 04 41 FD 4A 8F C8 00 F8 3C 05 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 8D 05 ?? ?? AF C7 00 FC 00 05 20 23 0? ?? ?? ?? 00 83 20 24 0? ?? ?? ?? 8F C7 00 FC }
	condition:
		$1
}

rule file_247_7_0 {
	meta:
		name = "open_verify.isra.4"
		size = 1484
		refs = "03b4 $LC6 0004 __gnu_local_gp 004c __open 0064 __libc_errno 0090 __libc_read 00d0 memcmp 0134 __close 02fc _dl_osversion 0380 __lseek 0424 $LC33 0478 strlen 0498 memcpy 04a4 free 04b4 $LC39 04d0 $LC30 0508 $LC31 0528 $LC32 0534 $LC38 054c $LC37 055c $LC29 057c $LC34 05b4 $LC35 05c0 $LC36"
	strings:
		$1 = { 27 BD FF A8 3C 1C ?? ?? 27 9C ?? ?? AF BE 00 50 AF B0 00 30 03 A0 F0 21 00 A0 80 21 3C 05 00 08 AF B4 00 40 AF B1 00 34 AF DC 00 20 AF BF 00 54 AF B7 00 4C AF B6 00 48 AF B5 00 44 AF B3 00 3C AF B2 00 38 AF C4 00 58 00 C0 88 21 0? ?? ?? ?? AF C7 00 2C 00 40 A0 21 24 02 FF FF 12 82 00 3E 8F DC 00 20 8F 82 ?? ?? 7C 03 E8 3B 00 00 30 21 00 43 20 21 AC 80 00 00 AF C2 00 28 24 12 02 00 AE 00 00 00 02 06 28 21 02 80 20 21 24 A5 00 04 0? ?? ?? ?? 02 46 30 23 18 40 00 D9 00 00 00 00 8E 03 00 00 00 43 10 21 2C 43 00 34 14 60 01 25 AE 02 00 00 00 40 98 21 2A 62 00 34 14 40 00 D2 26 12 00 04 3C 05 ?? ?? 02 40 20 21 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 08 14 40 00 DF 3C 05 ?? ?? 92 02 00 0C 14 40 00 FD 3C 05 ?? ?? 26 04 00 0D 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 07 14 40 00 28 24 02 00 01 8E 03 00 18 14 62 01 10 00 00 00 00 8E 02 00 28 30 42 04 20 14 40 00 06 24 03 00 08 96 02 00 16 10 43 00 28 24 03 00 0A 10 43 00 26 00 00 00 00 0? ?? ?? ?? 02 80 20 21 7C 03 E8 3B 00 60 10 21 8F C3 00 28 24 14 FF FF 00 62 B0 21 24 02 00 02 AE C2 00 00 03 C0 E8 21 8F DF 00 54 02 80 10 21 8F BE 00 50 8F B7 00 4C 8F B6 00 48 8F B5 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 58 14 64 00 03 2C 42 00 03 14 40 FF D4 3C 05 ?? ?? 8E 03 00 04 3C 02 7F 45 24 42 4C 46 14 62 00 EB 24 02 00 01 92 03 00 08 10 62 00 C1 00 00 00 00 0? ?? ?? ?? A2 22 00 00 96 02 00 14 24 42 FF FE 30 42 FF FF 2C 42 00 02 10 40 00 D6 24 02 00 20 96 03 00 2E 14 62 00 B3 00 00 88 21 96 04 00 30 8E 05 00 20 00 04 89 40 02 25 10 21 02 62 98 2B 16 60 00 6F 26 22 00 0E 02 05 28 21 24 B2 00 04 02 51 88 21 02 51 88 2B 12 20 FF CF 02 40 B0 21 24 13 00 04 0? ?? ?? ?? 24 11 FF FC 00 04 11 40 26 D6 00 20 02 42 10 21 02 C2 10 2B 10 40 FF C6 00 00 00 00 8E C2 00 00 14 53 FF F9 00 04 11 40 8E D5 00 10 2E A2 00 20 14 40 FF F5 00 04 11 40 8E C2 00 1C 2C 42 00 04 14 40 FF F1 00 04 11 40 8E C5 00 04 8E 02 00 00 00 B5 20 21 00 44 10 2B 14 40 00 3A 26 A2 00 0E 02 05 28 21 0? ?? ?? ?? 24 B7 00 04 8E E5 00 00 8E E2 00 04 24 A5 00 03 24 42 00 03 00 B1 28 24 00 51 10 24 00 A2 10 21 24 42 00 0C 00 82 20 2B 14 80 00 2A 02 A2 A8 23 02 E2 B8 21 3C 05 ?? ?? 02 E0 20 21 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 10 14 40 FF EE 26 A4 FF E0 12 A0 00 20 00 00 00 00 8E E2 00 10 8E E5 00 14 8E E4 00 18 14 40 FF 8F 8E E3 00 1C 3C 02 ?? ?? 8C 42 ?? ?? 10 40 FF 94 30 A5 00 FF 00 05 2A 00 30 84 00 FF 00 A4 20 21 00 04 22 00 30 63 00 FF 00 83 18 21 00 43 10 2B 14 40 FF 82 8F DF 00 54 03 C0 E8 21 02 80 10 21 8F BE 00 50 8F B7 00 4C 8F B6 00 48 8F B5 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 58 0? ?? ?? ?? 96 04 00 30 00 02 10 C2 00 02 10 C0 03 A2 E8 23 02 80 20 21 00 00 30 21 0? ?? ?? ?? 27 B7 00 20 02 80 20 21 02 E0 28 21 0? ?? ?? ?? 02 A0 30 21 12 A2 FF CB 3C 05 ?? ?? 7C 03 E8 3B 00 60 10 21 8F C3 00 28 00 62 10 21 8C 51 00 00 3C 10 ?? ?? 0? ?? ?? ?? 26 10 ?? ?? 00 02 10 C2 00 02 10 C0 03 A2 E8 23 02 80 20 21 00 00 30 21 0? ?? ?? ?? 27 B2 00 20 02 80 20 21 02 40 28 21 0? ?? ?? ?? 02 20 30 21 16 22 FF EC 00 00 00 00 96 04 00 30 0? ?? ?? ?? 00 04 89 40 0? ?? ?? ?? 8E 13 00 00 7C 03 E8 3B 00 60 10 21 8F C3 00 28 00 62 10 21 8C 51 00 00 16 20 FF E6 3C 10 ?? ?? 3C 10 ?? ?? 26 10 ?? ?? 8F C2 00 2C 14 40 00 11 00 00 00 00 8F C6 00 58 AF A0 00 10 AF B0 00 14 AF A0 00 18 02 20 20 21 02 80 28 21 0? ?? ?? ?? 00 00 38 21 02 40 20 21 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 08 10 40 FF 1D 00 00 00 00 0? ?? ?? ?? 8E 03 00 04 0? ?? ?? ?? 8F C4 00 58 24 43 00 0F 00 03 18 C2 00 03 18 C0 8F C5 00 58 03 A3 E8 23 27 A4 00 20 0? ?? ?? ?? 24 46 00 01 8F C4 00 58 0? ?? ?? ?? AF C2 00 58 0? ?? ?? ?? 8F C6 00 58 3C 10 ?? ?? 0? ?? ?? ?? 26 10 ?? ?? 92 04 00 09 24 02 00 02 10 82 00 0C 00 00 88 21 3C 10 ?? ?? 0? ?? ?? ?? 26 10 ?? ?? 92 03 00 0B 14 60 FF 2B 24 04 00 03 2C 42 00 02 14 40 FE FF 3C 05 ?? ?? 0? ?? ?? ?? 8E 03 00 04 92 02 00 0A 10 43 00 04 00 00 00 00 3C 10 ?? ?? 0? ?? ?? ?? 26 10 ?? ?? 92 02 00 0B 10 40 00 1C 24 03 00 03 10 43 00 12 00 00 88 21 3C 10 ?? ?? 0? ?? ?? ?? 26 10 ?? ?? 3C 10 ?? ?? 00 00 88 21 0? ?? ?? ?? 26 10 ?? ?? 0? ?? ?? ?? 00 40 30 21 3C 10 ?? ?? 00 00 88 21 0? ?? ?? ?? 26 10 ?? ?? 3C 10 ?? ?? 00 00 88 21 0? ?? ?? ?? 26 10 ?? ?? 92 02 00 0C 2C 42 00 03 14 40 00 09 3C 05 ?? ?? 3C 10 ?? ?? 00 00 88 21 0? ?? ?? ?? 26 10 ?? ?? 92 02 00 0C 2C 42 00 02 10 40 FF F9 3C 05 ?? ?? 26 04 00 0D 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 07 10 40 00 04 00 00 88 21 3C 10 ?? ?? 0? ?? ?? ?? 26 10 ?? ?? 3C 10 ?? ?? 0? ?? ?? ?? 26 10 ?? ?? }
	condition:
		$1
}

rule file_247_8_0 {
	meta:
		name = "open_path.isra.5"
		size = 1504
		refs = "0008 __gnu_local_gp 009c __libc_errno 00a4 _dl_debug_mask 00cc mempcpy 0268 _dl_ns 02b8 __xstat64 02f4 malloc 031c memcpy 037c $LC46 0384 _dl_debug_printf 0170 __libc_enable_secure 03ac __fxstat64 03cc __close 0400 $LC43 04d0 $LC40 04d8 $LC41 04ec _dl_debug_printf_c 0540 _dl_argv 0554 $LC42 055c $LC44 0530 $LC45 05bc free"
	strings:
		$1 = { 8C E2 00 00 27 BD FE F8 3C 1C ?? ?? 27 9C ?? ?? AF BE 01 00 03 A0 F0 21 AF BF 01 04 AF B7 00 FC AF B6 00 F8 AF B5 00 F4 AF B4 00 F0 AF B3 00 EC AF B2 00 E8 AF B1 00 E4 AF B0 00 E0 AF DC 00 10 AF C7 01 14 AF C2 00 BC AF C4 01 08 AF C5 01 0C 10 40 00 6C AF C6 01 10 3C 04 ?? ?? 8C 83 ?? ?? 3C 04 ?? ?? 8C 82 ?? ?? 8F C4 00 BC AF C0 00 C0 00 62 10 21 8F C3 01 0C 8C 96 00 00 AF C0 00 C8 00 43 10 21 24 42 00 0E 00 02 10 C2 00 02 10 C0 7C 03 E8 3B 03 A2 E8 23 00 60 10 21 8F 83 ?? ?? 27 B0 00 10 3C 13 ?? ?? 00 62 18 21 3C 12 ?? ?? AF C3 00 C4 8E 62 ?? ?? 30 42 00 01 14 40 00 CA 8F C3 00 C8 8E C5 00 0C 8E C6 00 10 0? ?? ?? ?? 02 00 20 21 8E 44 ?? ?? 10 80 00 A6 AF C2 00 B8 02 C0 A0 21 00 00 B8 21 02 E0 B0 21 00 00 88 21 3C 15 ?? ?? 0? ?? ?? ?? 02 80 B8 21 00 16 10 C0 8F C4 00 B8 00 A2 10 21 8C 45 00 00 0? ?? ?? ?? 8C 46 00 04 8F C5 01 08 8F C6 01 0C 0? ?? ?? ?? 00 40 20 21 8E 64 ?? ?? 30 84 00 01 14 80 00 93 00 50 A0 23 8F C5 01 1C 8F C6 01 24 02 00 20 21 0? ?? ?? ?? 00 00 38 21 8E E4 00 14 14 80 00 3B 00 40 38 21 24 02 FF FF 10 E2 00 3F 24 02 00 02 AE E2 00 14 24 11 00 01 8F C2 01 10 14 40 00 89 3C 02 ?? ?? 24 02 FF FF 14 E2 00 5D 26 C8 00 01 8E 42 ?? ?? 01 00 B0 21 01 02 10 2B 10 40 00 0B 26 F7 00 04 8E E4 00 14 24 02 00 01 14 82 FF D7 8E A5 ?? ?? 26 C8 00 01 8E 42 ?? ?? 01 00 B0 21 01 02 10 2B 14 40 FF F7 26 F7 00 04 12 20 00 07 8F C3 00 C4 8C 62 00 00 24 03 00 02 10 43 00 03 24 03 00 0D 14 43 00 0C 24 02 FF FF 8F C4 00 BC 8F C3 00 C0 24 84 00 04 8C 96 00 00 00 71 18 25 AF C4 00 BC 16 C0 FF AF AF C3 00 C0 10 60 00 EC 8F C4 01 14 24 02 FF FF 03 C0 E8 21 8F BF 01 04 8F BE 01 00 8F B7 00 FC 8F B6 00 F8 8F B5 00 F4 8F B4 00 F0 8F B3 00 EC 8F B2 00 E8 8F B1 00 E4 8F B0 00 E0 03 E0 00 08 27 BD 01 08 38 84 00 01 00 04 20 2B 24 02 FF FF 14 E2 FF C7 02 24 88 25 0? ?? ?? ?? 26 C8 00 01 8F C3 01 20 10 60 00 0F 00 00 00 00 8C 62 00 18 3C 03 ?? ?? 24 63 ?? ?? 00 02 30 80 00 02 29 00 00 C5 28 21 00 A2 10 23 00 02 10 80 00 43 10 21 8C 42 00 00 8C 42 02 68 7C 42 05 00 14 40 00 13 24 04 00 01 8F C4 01 0C 02 14 A0 21 02 00 28 21 00 04 10 27 02 82 A0 21 A2 80 00 00 24 04 00 03 0? ?? ?? ?? 27 C6 00 18 14 40 00 06 24 02 00 01 8F C4 00 30 24 02 40 00 30 84 F0 00 10 82 00 22 24 02 00 01 AE E2 00 14 00 00 20 21 02 24 88 25 0? ?? ?? ?? 26 C8 00 01 02 80 20 21 0? ?? ?? ?? AF C7 00 D8 8F C3 01 18 02 80 B0 21 8F C7 00 D8 10 40 00 A5 AC 62 00 00 02 00 28 21 02 C0 30 21 00 40 20 21 0? ?? ?? ?? AF C7 00 D8 8F C7 00 D8 03 C0 E8 21 8F BF 01 04 8F BE 01 00 8F B7 00 FC 8F B6 00 F8 8F B5 00 F4 8F B4 00 F0 8F B3 00 EC 8F B2 00 E8 8F B1 00 E4 8F B0 00 E0 00 E0 10 21 03 E0 00 08 27 BD 01 08 24 02 00 02 24 04 00 01 AE E2 00 14 0? ?? ?? ?? 02 24 88 25 0? ?? ?? ?? 00 00 88 21 3C 04 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 02 00 28 21 0? ?? ?? ?? 8F C5 01 1C 8C 42 ?? ?? 10 40 FF 77 24 02 FF FF 00 E0 28 21 24 04 00 03 27 C6 00 18 0? ?? ?? ?? AF C7 00 D8 14 40 00 05 8F C7 00 D8 8F C2 00 30 30 42 08 00 14 40 FF 6C 24 02 FF FF 0? ?? ?? ?? 00 E0 20 21 8F C3 00 C4 24 02 00 02 24 07 FF FF 0? ?? ?? ?? AC 62 00 00 8E D4 00 04 12 83 FF 35 3C 04 ?? ?? 3C 03 ?? ?? 8C 85 ?? ?? 8C 62 ?? ?? 3C 03 ?? ?? AF DD 00 D0 00 A2 10 21 24 42 00 07 00 02 10 C2 00 02 10 C0 03 A2 E8 23 24 64 ?? ?? 0? ?? ?? ?? 8E D7 00 08 8F C4 00 BC 8C 82 00 00 10 40 00 3E 27 B5 00 10 8C 44 00 04 16 84 00 3B 24 03 00 01 8F D1 00 BC AF C3 00 B8 27 A3 00 11 AF D6 00 CC AF C3 00 D4 AF D0 00 C8 02 A0 B0 21 8C 45 00 0C 8C 46 00 10 0? ?? ?? ?? 02 C0 20 21 8E 44 ?? ?? 10 80 00 24 00 40 80 21 00 00 A8 21 8E 23 00 00 26 A2 00 04 00 02 10 80 00 62 10 21 8C 42 00 04 24 03 00 01 00 15 28 C0 10 43 00 15 02 00 20 21 3C 03 ?? ?? 8C 62 ?? ?? 00 45 10 21 8C 45 00 00 0? ?? ?? ?? 8C 46 00 04 12 C2 00 31 8F C3 00 D4 10 43 00 2C 24 03 00 2F A0 40 FF FF 3C 02 ?? ?? 24 44 ?? ?? 3C 02 ?? ?? 24 43 ?? ?? 8F C2 00 B8 02 C0 28 21 AF C0 00 B8 0? ?? ?? ?? 00 62 20 0A 8E 42 ?? ?? 26 B5 00 01 02 A2 10 2B 14 40 FF DF 00 00 00 00 26 31 00 04 8E 22 00 00 10 40 00 04 00 00 00 00 8C 44 00 04 12 84 FF D0 00 00 00 00 8F D0 00 C8 8F D6 00 CC 12 E0 00 17 3C 04 ?? ?? 82 E2 00 00 14 40 00 08 02 E0 30 21 3C 02 ?? ?? 8C 42 ?? ?? 8C 46 00 00 14 C0 00 03 00 00 00 00 3C 06 ?? ?? 24 C6 ?? ?? 3C 04 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 02 80 28 21 AF D4 00 C8 0? ?? ?? ?? 8F DD 00 D0 82 C4 00 00 14 83 FF D3 00 00 00 00 0? ?? ?? ?? A0 40 00 00 24 84 ?? ?? 0? ?? ?? ?? 02 80 28 21 0? ?? ?? ?? AF D4 00 C8 0? ?? ?? ?? 00 E0 20 21 0? ?? ?? ?? 24 02 FF FF 8C 82 00 04 10 40 00 04 8F C3 01 14 0? ?? ?? ?? 8C 84 00 00 8F C3 01 14 3C 02 ?? ?? 24 42 ?? ?? 10 62 FF 0C 24 02 FF FF 0? ?? ?? ?? AC 62 00 00 }
	condition:
		$1
}

rule file_247_9_0 {
	meta:
		name = "add_path.9517.isra.1.constprop.7"
		size = 288
		refs = "00c4 mempcpy"
	strings:
		$1 = { 24 02 FF FF 10 82 00 40 00 00 00 00 27 BD FF C8 8C 82 00 00 AF B5 00 30 AF B4 00 2C AF B3 00 28 AF B1 00 20 AF B0 00 1C AF BF 00 34 AF B2 00 24 01 E0 80 21 24 91 00 04 24 15 00 2E 24 14 00 2F 0? ?? ?? ?? 24 13 00 02 8E 03 00 08 8C 42 00 10 26 31 00 04 8C 65 00 00 2C 46 00 02 02 66 10 0B 8C 64 00 04 00 A2 10 21 AC 62 00 00 8E 22 FF FC 24 84 00 01 10 40 00 1C AC 64 00 04 92 03 00 0C 14 60 FF F1 02 80 48 21 8E 07 00 04 8C 45 00 10 8E 12 00 08 8E 03 00 00 24 E7 00 01 00 07 40 C0 24 A6 FF FF 02 A5 48 0A 02 48 90 21 2C A5 00 02 AE 07 00 04 00 60 20 21 24 6A 00 01 14 A0 00 14 AE 43 00 00 0? ?? ?? ?? 8C 45 00 0C 24 43 00 01 AE 03 00 00 26 31 00 04 A0 40 00 00 8E 22 FF FC 14 40 FF E6 AE 40 00 04 8F BF 00 34 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 27 BD 00 38 03 E0 00 08 00 00 00 00 AE 0A 00 00 A0 69 00 00 0? ?? ?? ?? 8E 02 00 00 }
	condition:
		$1
}

rule file_247_10_0 {
	meta:
		name = "elf_machine_matches_host"
		size = 60
	strings:
		$1 = { 8C 83 00 24 30 63 04 20 14 60 00 08 00 00 10 21 94 83 00 12 24 04 00 08 10 64 00 06 00 00 00 00 24 04 00 0A 10 64 00 03 00 00 00 00 03 E0 00 08 00 00 00 00 03 E0 00 08 24 02 00 01 }
	condition:
		$1
}

rule file_247_11_0 {
	meta:
		name = "expand_dynamic_string_token"
		size = 372
		refs = "002c strchr 0060 _dl_dst_count 0070 strlen 0098 _dl_platformlen 00c8 malloc 00fc _dl_dst_substitute 0114 _dl_get_origin 0110 $LC51 0158 $LC3 016c __assert_fail 015c __PRETTY_FUNCTION__.9168"
	strings:
		$1 = { 27 BD FF D0 AF B0 00 18 00 A0 80 21 AF B1 00 1C 24 05 00 24 00 80 88 21 02 00 20 21 AF B2 00 20 AF BF 00 2C AF B4 00 28 AF B3 00 24 0? ?? ?? ?? 00 C0 90 21 14 40 00 0A 00 40 20 21 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 02 00 20 21 8F B0 00 18 0? ?? ?? ?? 27 BD 00 30 0? ?? ?? ?? 02 40 28 21 10 40 FF F4 00 40 A0 21 0? ?? ?? ?? 02 00 20 21 8E 24 02 7C 10 80 00 21 00 40 98 21 24 02 FF FF 10 82 00 03 00 00 10 21 0? ?? ?? ?? 00 00 00 00 3C 03 ?? ?? 8C 64 ?? ?? 24 03 00 03 2C 85 00 03 00 85 18 0A 00 62 20 2B 00 64 10 0A 2C 43 00 05 14 60 00 03 24 42 FF FC 70 54 18 02 00 73 98 21 0? ?? ?? ?? 26 64 00 01 10 40 00 19 00 40 30 21 8F BF 00 2C 8F B4 00 28 8F B3 00 24 02 20 20 21 02 00 28 21 8F B1 00 1C 8F B0 00 18 02 40 38 21 8F B2 00 20 0? ?? ?? ?? 27 BD 00 30 8E 22 00 04 80 42 00 00 14 40 00 12 3C 04 ?? ?? 0? ?? ?? ?? 00 00 00 00 00 40 20 21 24 42 FF FF 2C 42 FF FE 14 40 FF D9 AE 24 02 7C 0? ?? ?? ?? 00 00 10 21 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 30 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 01 B0 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_247_12_0 {
	meta:
		name = "cache_rpath.part.6"
		size = 476
		refs = "0048 _dl_inhibit_rpath 009c malloc 00b0 $LC53 00cc free 0134 __libc_enable_secure 01b8 $LC0 01c8 _dl_signal_error 01d0 $LC52"
	strings:
		$1 = { 24 C6 00 08 00 06 30 80 00 86 30 21 8C C2 00 00 27 BD FF C8 AF B0 00 20 AF BF 00 34 AF B4 00 30 AF B3 00 2C AF B2 00 28 AF B1 00 24 10 40 00 36 00 A0 80 21 8C 83 00 34 8C 86 00 00 00 E0 88 21 8C 65 00 04 8C 43 00 04 3C 02 ?? ?? 8C 42 ?? ?? 00 C5 28 21 00 A3 28 21 14 40 00 36 8C 92 00 04 0? ?? ?? ?? 24 06 00 01 10 40 00 59 00 40 98 21 80 43 00 00 10 60 00 22 00 40 30 21 00 00 40 21 24 C6 00 01 38 69 00 3A 80 C3 00 00 2D 29 00 01 14 60 FF FB 01 09 40 21 25 04 00 02 0? ?? ?? ?? 00 04 20 80 00 40 A0 21 10 40 00 41 02 60 20 21 3C 06 ?? ?? 00 40 28 21 24 C6 ?? ?? 00 00 38 21 AF B1 00 10 0? ?? ?? ?? AF B2 00 14 0? ?? ?? ?? 02 60 20 21 8F BF 00 34 24 02 00 01 AE 14 00 00 AE 02 00 04 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 38 0? ?? ?? ?? 00 40 20 21 8F BF 00 34 24 02 FF FF AE 02 00 00 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 00 00 10 21 03 E0 00 08 27 BD 00 38 3C 03 ?? ?? 8C 63 ?? ?? 14 60 FF C8 02 40 30 21 80 43 00 00 0? ?? ?? ?? 24 08 00 3A 10 60 FF ED 24 C6 00 01 80 43 00 01 24 42 00 01 80 C7 00 00 10 E3 FF FA 00 00 00 00 14 E0 00 05 00 00 00 00 10 60 FF E5 8F BF 00 34 10 68 FF E3 00 00 00 00 10 60 FF B6 00 00 00 00 10 68 00 03 24 42 00 01 0? ?? ?? ?? 80 43 00 00 80 43 00 00 10 60 FF AF 02 40 30 21 0? ?? ?? ?? 80 C7 00 00 0? ?? ?? ?? 00 00 00 00 3C 07 ?? ?? 24 E7 ?? ?? 24 04 00 0C 00 00 28 21 0? ?? ?? ?? 00 00 30 21 3C 07 ?? ?? 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_247_13_0 {
	meta:
		name = "_dl_dst_count"
		size = 244
		refs = "0004 __libc_enable_secure 0014 $LC47 0018 $LC48 001c $LC49 00b8 strchr"
	strings:
		$1 = { 27 BD FF C0 3C 02 ?? ?? AF B6 00 38 AF B4 00 30 AF B3 00 2C 3C 14 ?? ?? 3C 13 ?? ?? 3C 16 ?? ?? AF B5 00 34 AF B2 00 28 AF B1 00 24 AF B0 00 20 8C 55 ?? ?? AF BF 00 3C 00 80 80 21 00 A0 88 21 00 80 10 21 00 00 90 21 26 94 ?? ?? 26 73 ?? ?? 26 D6 ?? ?? 24 4A 00 01 02 00 20 21 01 40 28 21 02 80 30 21 02 20 38 21 0? ?? ?? ?? AF B5 00 10 01 40 28 21 02 00 20 21 02 60 30 21 14 40 00 0C 02 20 38 21 0? ?? ?? ?? AF A0 00 10 01 40 28 21 02 00 20 21 02 C0 30 21 14 40 00 05 02 20 38 21 0? ?? ?? ?? AF A0 00 10 10 40 00 03 01 42 20 21 26 52 00 01 01 42 20 21 0? ?? ?? ?? 24 05 00 24 14 40 FF E5 24 4A 00 01 8F BF 00 3C 02 40 10 21 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 40 }
	condition:
		$1
}

rule file_247_14_0 {
	meta:
		name = "_dl_dst_substitute"
		size = 776
		refs = "0004 $LC47 0038 $LC48 0040 $LC49 0064 __libc_enable_secure 0214 _dl_platform 006c $LC50 02a8 stpcpy"
	strings:
		$1 = { 27 BD FF A0 3C 02 ?? ?? AF BE 00 58 AF B7 00 54 AF B6 00 50 AF B5 00 4C AF B4 00 48 AF B3 00 44 AF BF 00 5C AF B2 00 40 AF B1 00 3C AF B0 00 38 24 4E ?? ?? 80 B0 00 00 3C 02 ?? ?? 24 4C ?? ?? 3C 02 ?? ?? 00 A0 B0 21 00 C0 A0 21 00 80 F0 21 00 E0 98 21 00 C0 B8 21 00 C0 50 21 00 A0 58 21 00 00 A8 21 3C 0D ?? ?? 24 49 ?? ?? 3C 08 ?? ?? 24 03 00 24 12 03 00 13 25 51 00 01 A1 50 00 00 25 72 00 01 12 60 00 04 81 70 00 01 24 03 00 3A 12 03 00 06 00 00 00 00 12 00 00 32 00 00 00 00 02 20 50 21 0? ?? ?? ?? 02 40 58 21 16 A0 00 3D 02 37 28 23 02 20 B8 21 02 20 50 21 0? ?? ?? ?? 02 40 58 21 8D AF ?? ?? 25 72 00 01 02 C0 20 21 AF AF 00 10 02 40 28 21 01 C0 30 21 02 60 38 21 AF A8 00 30 0? ?? ?? ?? AF A9 00 2C 00 40 80 21 8F A8 00 30 10 40 00 3B 8F A9 00 2C 8F C5 02 7C 11 E0 00 05 00 00 A8 21 8F D5 02 68 3C 02 C0 00 02 A2 A8 24 2E B5 00 01 24 A2 FF FF 2C 42 FF FE 14 40 00 5B 2E 02 00 02 14 40 00 45 24 02 00 24 02 50 90 21 82 42 00 00 10 40 00 0A 02 E0 88 21 24 03 00 3A 12 60 00 03 00 00 00 00 10 43 00 34 00 00 00 00 26 52 00 01 82 42 00 00 14 40 FF F9 02 E0 88 21 16 A0 00 5C 00 00 00 00 A2 20 00 00 8F BF 00 5C 02 80 10 21 8F BE 00 58 8F B7 00 54 8F B6 00 50 8F B5 00 4C 8F B4 00 48 8F B3 00 44 8F B2 00 40 8F B1 00 3C 8F B0 00 38 03 E0 00 08 27 BD 00 60 02 E0 20 21 AF A8 00 30 AF A9 00 2C AF AC 00 28 AF AD 00 20 0? ?? ?? ?? AF AE 00 24 02 E2 88 0A 00 00 A8 21 8F A8 00 30 8F A9 00 2C 8F AC 00 28 8F AD 00 20 8F AE 00 24 0? ?? ?? ?? 02 20 B8 21 AF A0 00 10 02 C0 20 21 02 40 28 21 01 80 30 21 02 60 38 21 AF A8 00 30 0? ?? ?? ?? AF A9 00 2C 00 40 80 21 8F A8 00 30 10 40 00 12 8F A9 00 2C 3C 02 ?? ?? 0? ?? ?? ?? 8C 45 ?? ?? 12 F4 00 32 00 00 00 00 82 50 00 00 16 00 FF 9C 02 E0 88 21 0? ?? ?? ?? 00 00 00 00 24 02 00 24 A1 42 00 00 81 70 00 01 16 00 FF 95 25 51 00 01 0? ?? ?? ?? 00 00 00 00 01 20 30 21 AF A0 00 10 02 C0 20 21 02 40 28 21 02 60 38 21 AF A8 00 30 0? ?? ?? ?? AF A9 00 2C 00 40 80 21 8F A8 00 30 10 40 FF EE 8F A9 00 2C 0? ?? ?? ?? 25 05 ?? ?? 01 40 20 21 02 50 90 21 AF A8 00 30 AF A9 00 2C AF AC 00 28 AF AD 00 20 0? ?? ?? ?? AF AE 00 24 82 50 00 00 00 40 88 21 8F A8 00 30 8F A9 00 2C 8F AC 00 28 8F AD 00 20 16 00 FF 75 8F AE 00 24 0? ?? ?? ?? 00 00 00 00 02 37 28 23 0? ?? ?? ?? 02 E0 20 21 0? ?? ?? ?? 02 E2 88 0A 82 50 00 01 12 00 FF CD 00 00 00 00 02 80 88 21 26 52 00 01 0? ?? ?? ?? 02 20 B8 21 }
	condition:
		$1
}

rule file_247_15_0 {
	meta:
		name = "_dl_init_paths"
		size = 700
		refs = "0000 _dl_platformlen 000c _dl_platform 0044 _dl_important_hwcaps 0058 malloc 00a4 _dl_all_dirs 00b4 $LC55 019c strlen 01bc memcpy 020c __libc_enable_secure 0214 $LC57 021c $LC56 0274 free 0298 $LC0 02a8 _dl_signal_error 02b0 $LC54"
	strings:
		$1 = { 3C 02 ?? ?? 27 BD FF C0 8C 45 ?? ?? 3C 02 ?? ?? AF B1 00 28 00 80 88 21 8C 44 ?? ?? AF B0 00 24 3C 07 ?? ?? 3C 10 ?? ?? AF BE 00 38 26 06 ?? ?? 03 A0 F0 21 24 E7 ?? ?? AF BF 00 3C AF B4 00 34 AF B2 00 2C 0? ?? ?? ?? AF B3 00 30 3C 03 ?? ?? 24 04 00 0C AC 62 ?? ?? 0? ?? ?? ?? 3C 14 ?? ?? 00 40 90 21 10 40 00 92 AE 82 ?? ?? 8E 10 ?? ?? 3C 02 CC CC 34 42 CC CD 00 10 98 80 26 73 00 27 02 62 00 19 00 00 98 10 00 13 99 02 00 13 12 00 00 13 21 80 0? ?? ?? ?? 00 82 20 21 10 40 00 7E AE 42 00 00 3C 03 ?? ?? AC 62 ?? ?? 3C 03 ?? ?? 24 63 ?? ?? 3C 05 ?? ?? 00 13 20 80 26 94 ?? ?? 24 A5 ?? ?? 00 13 99 00 AC 43 00 0C 24 03 00 05 AE 80 00 04 AC 45 00 04 AC 40 00 08 AC 43 00 10 12 00 00 07 00 93 20 21 00 40 30 21 00 00 18 21 24 63 00 01 AC C0 00 14 14 70 FF FD 24 C6 00 04 00 44 20 21 AC 44 00 00 3C 02 ?? ?? 24 42 ?? ?? AC 82 00 0C 24 02 00 09 AE 44 00 04 AC 85 00 04 AC 80 00 08 AC 82 00 10 00 80 30 21 12 00 00 05 00 00 18 21 24 63 00 01 AC C0 00 14 14 70 FF FD 24 C6 00 04 24 03 00 09 3C 02 ?? ?? AC 80 00 00 AC 43 ?? ?? 12 20 00 04 AE 40 00 08 82 22 00 00 14 40 00 0E 00 00 00 00 03 C0 E8 21 8F BF 00 3C 24 03 FF FF 3C 02 ?? ?? 8F BE 00 38 8F B4 00 34 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 AC 43 ?? ?? 03 E0 00 08 27 BD 00 40 0? ?? ?? ?? 02 20 20 21 24 43 00 0F 00 03 18 C2 00 03 18 C0 03 A3 E8 23 27 A4 00 18 02 20 28 21 0? ?? ?? ?? 24 46 00 01 82 23 00 00 10 60 00 31 00 40 90 21 24 05 00 01 26 31 00 01 24 66 FF C6 82 23 00 00 30 C6 00 FF 2C C6 00 02 14 60 FF FA 00 A6 28 21 24 A4 00 01 00 04 20 80 0? ?? ?? ?? 3C 10 ?? ?? 00 40 28 21 10 40 00 24 AE 02 ?? ?? 3C 02 ?? ?? 8C 47 ?? ?? 3C 02 ?? ?? 24 42 ?? ?? 3C 06 ?? ?? 02 40 20 21 AF A2 00 10 AF A0 00 14 0? ?? ?? ?? 24 C6 ?? ?? 8E 04 ?? ?? 8C 82 00 00 10 40 00 0D 00 00 00 00 26 10 ?? ?? AE 00 00 04 03 C0 E8 21 8F BF 00 3C 8F BE 00 38 8F B4 00 34 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 40 0? ?? ?? ?? 00 00 00 00 24 02 FF FF AE 02 ?? ?? 26 10 ?? ?? 0? ?? ?? ?? AE 00 00 04 0? ?? ?? ?? 24 04 00 08 3C 07 ?? ?? 24 E7 ?? ?? 24 04 00 0C 00 00 28 21 0? ?? ?? ?? 00 00 30 21 3C 07 ?? ?? 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_247_16_0 {
	meta:
		name = "_dl_map_object"
		size = 2324
		refs = "000c __gnu_local_gp 0044 _dl_nns 0064 _dl_ns 00c8 _dl_name_match_p 0108 _dl_debug_mask 0124 strchr 019c __libc_stack_end 0230 strlen 0330 _dl_inhibit_cache 0340 _dl_load_cache_lookup 03bc $LC65 03c4 _dl_debug_printf 0534 $LC63 0590 strcmp 05c4 __close 0674 $LC64 06a8 memcmp 0728 _dl_new_object 0740 dummy_bucket.9506 0760 _dl_add_to_namespace_list 0788 $LC58 079c _dl_argv 07b0 $LC42 07ec $LC59 07f8 free 0810 _dl_signal_error 0800 $LC5 0820 $LC66 0864 __libc_enable_secure 0884 __libc_errno 0888 $LC67 08a0 $LC62 08bc $LC61 08c0 $LC3 08d4 __assert_fail 08c4 __PRETTY_FUNCTION__.9479 08dc $LC60"
	strings:
		$1 = { 27 BD FD 78 AF B1 02 64 8F B1 02 9C 3C 1C ?? ?? 27 9C ?? ?? AF BF 02 84 AF BE 02 80 AF B7 02 7C AF B6 02 78 AF B5 02 74 AF B4 02 70 AF B3 02 6C AF B2 02 68 AF B0 02 60 AF BC 00 28 06 20 02 27 AF A7 02 94 3C 02 ?? ?? 8C 42 ?? ?? 02 22 10 2B 10 40 02 1A 00 00 00 00 00 11 A8 80 00 11 B1 00 02 B6 10 21 3C 13 ?? ?? 00 51 10 23 00 02 10 80 26 74 ?? ?? 02 82 10 21 8C 5E 00 00 00 80 90 21 00 A0 80 21 17 C0 00 0A 00 C0 B8 21 0? ?? ?? ?? 3C 1E ?? ?? 8F C2 02 68 7C 42 05 C0 10 40 01 33 00 00 00 00 8F DE 00 0C 13 C0 00 17 00 00 00 00 8F C2 02 68 7C 44 05 80 14 80 FF FA 7C 42 04 80 14 40 FF F8 02 00 20 21 0? ?? ?? ?? 03 C0 28 21 10 40 FF F0 03 C0 10 21 8F BF 02 84 8F BE 02 80 8F B7 02 7C 8F B6 02 78 8F B5 02 74 8F B4 02 70 8F B3 02 6C 8F B2 02 68 8F B1 02 64 8F B0 02 60 03 E0 00 08 27 BD 02 88 3C 1E ?? ?? 8F C3 ?? ?? 30 62 00 40 14 40 01 96 02 00 20 21 24 05 00 2F AF A3 02 58 0? ?? ?? ?? A3 A0 02 3C 10 40 00 3B 8F A3 02 58 12 40 00 AA 8F A3 02 98 3C 02 10 00 00 62 10 24 AF A2 02 40 02 40 20 21 02 00 28 21 0? ?? ?? ?? 00 00 30 21 8F BC 00 28 10 40 00 9E AF A2 02 38 27 A5 00 30 00 40 20 21 27 A6 02 3C 0? ?? ?? ?? 24 07 00 01 00 40 28 21 24 02 FF FF 10 A2 01 DE 8F BC 00 28 8F A3 02 40 24 02 FF FF 10 A2 01 54 00 03 90 0B 8F A3 02 98 3C 02 ?? ?? 8F A7 02 38 8C 42 ?? ?? AF A3 00 18 27 A3 02 34 AF B2 00 10 AF B7 00 14 AF A3 00 1C AF B1 00 20 02 00 20 21 27 A6 00 30 0? ?? ?? ?? AF A2 02 34 8F BF 02 84 8F BE 02 80 8F B7 02 7C 8F B6 02 78 8F B5 02 74 8F B4 02 70 8F B3 02 6C 8F B2 02 68 8F B1 02 64 8F B0 02 60 03 E0 00 08 27 BD 02 88 02 00 20 21 24 05 00 2F AF A3 02 58 0? ?? ?? ?? A3 A0 02 3C 14 40 00 72 8F A3 02 58 8F A4 02 98 3C 02 10 00 00 82 10 24 AF A2 02 40 02 00 20 21 0? ?? ?? ?? AF A3 02 58 8F A3 02 58 24 42 00 01 8F BC 00 28 30 63 00 01 14 60 01 95 AF A2 02 48 12 40 00 6B 8E 63 ?? ?? 8E 42 00 94 10 40 00 8E 3C 02 04 00 8F A3 02 98 3C 02 04 00 00 62 10 24 AF A2 02 44 3C 07 ?? ?? 8C E2 ?? ?? 24 03 FF FF 10 43 00 13 8E 62 ?? ?? 27 A4 02 38 8F A5 02 48 02 52 10 0B 8F A6 02 44 AF A4 00 10 AF A2 00 18 27 A4 00 30 27 A2 02 3C AF A4 00 14 AF A2 00 1C 02 00 20 21 24 E7 ?? ?? 0? ?? ?? ?? AF A3 02 58 8F A3 02 58 8F BC 00 28 14 43 00 38 00 40 28 21 12 40 00 15 24 03 FF FF 8E 42 02 C0 10 43 00 12 26 53 02 C0 10 40 00 E3 27 A2 02 38 AF A2 00 10 8F A5 02 48 27 A2 00 30 8F A6 02 44 AF A2 00 14 27 A2 02 3C AF B2 00 18 AF A2 00 1C 02 00 20 21 0? ?? ?? ?? 02 60 38 21 00 40 28 21 24 02 FF FF 14 A2 00 22 8F BC 00 28 8F A3 02 44 14 60 01 4D 3C 02 ?? ?? 8C 42 ?? ?? 14 40 00 A5 00 00 00 00 0? ?? ?? ?? 02 00 20 21 00 40 98 21 10 40 00 A0 8F BC 00 28 12 40 00 06 27 A5 00 30 8E 43 02 DC 30 62 08 00 14 40 00 CD 3C 05 ?? ?? 27 A5 00 30 02 60 20 21 27 A6 02 3C 0? ?? ?? ?? 00 00 38 21 00 40 28 21 24 02 FF FF 10 A2 00 91 8F BC 00 28 02 60 20 21 0? ?? ?? ?? AF A5 02 54 AF A2 02 38 8F BC 00 28 10 40 00 87 8F A5 02 54 8F C2 ?? ?? 30 42 00 01 10 40 FF 75 8F A3 02 40 3C 04 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? AF A5 02 54 8F BC 00 28 0? ?? ?? ?? 8F A5 02 54 0? ?? ?? ?? 24 05 FF FF 0? ?? ?? ?? 02 00 20 21 8F A4 02 98 3C 03 10 00 8F BC 00 28 00 83 18 24 0? ?? ?? ?? AF A3 02 40 3C 02 04 00 AF A3 02 4C 8F A3 02 98 00 62 10 24 AF A2 02 44 8F A3 02 4C 10 60 FF 96 3C 02 C0 00 8C 63 02 68 00 62 18 24 3C 02 80 00 10 62 FF 91 8F A3 02 4C 24 04 FF FF 8C 62 02 6C 10 44 FF 8D 24 63 02 6C 10 40 00 FB 8F A2 02 4C 27 A4 02 38 8F A5 02 48 02 52 10 0B 8F A6 02 44 AF A4 00 10 AF A2 00 18 27 A4 00 30 27 A2 02 3C AF A4 00 14 AF A2 00 1C 02 00 20 21 0? ?? ?? ?? 00 60 38 21 00 40 28 21 24 02 FF FF 14 A2 FF C8 8F BC 00 28 0? ?? ?? ?? 3C 07 ?? ?? AF A0 02 50 AF A3 02 4C 8F A3 02 98 00 62 10 24 AF A2 02 44 0? ?? ?? ?? 02 40 18 21 8F A5 02 48 8F A6 02 44 AF A4 00 10 27 A2 00 30 27 A4 02 3C AF A4 00 1C AF A2 00 14 AF B2 00 18 02 00 20 21 01 00 38 21 0? ?? ?? ?? AF A3 02 58 00 40 28 21 24 02 FF FF 8F BC 00 28 14 A2 FF AE 8F A3 02 58 8F A4 02 4C 00 64 10 26 8F A4 02 50 2C 42 00 01 00 82 20 25 AF A4 02 50 8C 63 02 40 10 60 00 4A 00 00 00 00 8C 62 02 6C 24 04 FF FF 10 44 FF FA 24 68 02 6C 14 40 FF E1 27 A4 02 38 3C 07 ?? ?? 00 60 20 21 01 00 28 21 24 06 00 0F 24 E7 ?? ?? AF A3 02 58 0? ?? ?? ?? AF A8 02 54 8F BC 00 28 8F A3 02 58 10 40 FF EC 8F A8 02 54 0? ?? ?? ?? 27 A4 02 38 8F C2 00 58 10 40 FE CC 00 00 00 00 8F C4 00 34 8C 45 00 04 8F C2 00 00 8C 86 00 04 02 00 20 21 00 C5 28 21 0? ?? ?? ?? 00 A2 28 21 14 40 FE C2 00 00 00 00 8F C4 00 1C 0? ?? ?? ?? 02 00 28 21 8F C4 02 68 24 05 00 01 03 C0 10 21 7C A4 BD C4 0? ?? ?? ?? AF C4 02 68 0? ?? ?? ?? 00 A0 20 21 8F BC 00 28 12 40 00 20 02 B6 10 21 8E 43 02 DC 02 40 10 21 30 63 08 00 14 60 FF 71 24 05 FF FF 3C 07 ?? ?? 8C E4 ?? ?? 24 03 FF FF 10 83 00 0F 27 A3 02 38 8F A5 02 48 8F A6 02 44 AF A3 00 10 AF A2 00 18 27 A3 00 30 27 A2 02 3C AF A3 00 14 AF A2 00 1C 02 00 20 21 0? ?? ?? ?? 24 E7 ?? ?? 00 40 28 21 0? ?? ?? ?? 8F BC 00 28 0? ?? ?? ?? 24 05 FF FF 8F A3 02 50 14 60 FF 07 8F A3 02 4C 0? ?? ?? ?? 00 00 00 00 00 51 10 23 00 02 10 80 02 82 A0 21 8E 82 00 00 10 40 FF E2 3C 07 ?? ?? 0? ?? ?? ?? 8C 43 02 DC 3C 07 ?? ?? 02 40 20 21 02 60 28 21 24 06 00 1D 0? ?? ?? ?? 24 E7 ?? ?? 10 40 FF 26 8F BC 00 28 0? ?? ?? ?? 27 A2 02 38 02 60 20 21 24 A5 ?? ?? 24 06 00 05 0? ?? ?? ?? AF A3 02 58 8F BC 00 28 10 40 FF C9 8F A3 02 58 3C 05 ?? ?? 02 60 20 21 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 09 8F BC 00 28 14 40 FF 25 8F A3 02 58 0? ?? ?? ?? 02 40 10 21 8F A3 02 94 10 60 00 4B 93 A2 02 3C 8F C2 ?? ?? 30 42 08 00 14 40 00 47 93 A2 02 3C 0? ?? ?? ?? 02 00 20 21 10 40 00 3B 00 40 98 21 8F A3 02 98 02 40 38 21 AF B1 00 14 AF A3 00 10 00 40 20 21 02 00 28 21 0? ?? ?? ?? 02 E0 30 21 10 40 00 31 00 40 90 21 8C 43 02 68 24 02 00 01 3C 04 ?? ?? 7C 43 B5 84 7C 43 EF 44 24 84 ?? ?? AE 44 02 60 AE 42 02 4C AE 43 02 68 02 40 20 21 0? ?? ?? ?? 02 20 28 21 0? ?? ?? ?? 02 40 10 21 12 40 FE A3 3C 02 10 00 8F A3 02 98 00 62 10 24 14 40 00 1A AF A2 02 40 3C 04 ?? ?? 24 84 ?? ?? 8E 47 00 04 80 E2 00 00 14 40 00 07 3C 02 ?? ?? 8C 42 ?? ?? 8C 47 00 00 14 E0 00 03 00 00 00 00 3C 07 ?? ?? 24 E7 ?? ?? 8E 42 00 18 02 00 28 21 02 20 30 21 0? ?? ?? ?? AF A2 00 10 02 00 20 21 24 05 00 2F 0? ?? ?? ?? A3 A0 02 3C 14 40 FE 5B 02 40 20 21 0? ?? ?? ?? 8F C3 ?? ?? 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 02 60 20 21 3C 07 ?? ?? 24 04 00 0C 02 00 28 21 00 00 30 21 0? ?? ?? ?? 24 E7 ?? ?? 10 40 00 18 02 00 28 21 3C 07 ?? ?? 00 00 20 21 00 00 30 21 0? ?? ?? ?? 24 E7 ?? ?? 8F A4 02 4C 3C 07 ?? ?? 00 60 28 21 24 06 00 0F 24 E7 ?? ?? 0? ?? ?? ?? AF A3 02 58 8F BC 00 28 10 40 FE 87 8F A3 02 58 0? ?? ?? ?? 8F A2 02 4C 3C 02 ?? ?? 8C 42 ?? ?? 14 40 FF 58 3C 02 ?? ?? 0? ?? ?? ?? 8C 42 ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 3C 07 ?? ?? 00 62 10 21 8C 44 00 00 00 00 30 21 0? ?? ?? ?? 24 E7 ?? ?? 3C 04 ?? ?? 24 84 ?? ?? 02 00 28 21 0? ?? ?? ?? 02 20 30 21 0? ?? ?? ?? 8F BC 00 28 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 08 26 0? ?? ?? ?? 24 E7 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 08 25 0? ?? ?? ?? 24 E7 ?? ?? 8F A4 02 38 0? ?? ?? ?? AF A5 02 54 8F BC 00 28 0? ?? ?? ?? 8F A5 02 54 }
	condition:
		$1
}

rule file_247_17_0 {
	meta:
		name = "_dl_rtld_di_serinfo"
		size = 532
		refs = "0100 $LC63 0148 _dl_ns 0078 $LC64"
	strings:
		$1 = { 27 BD FF C0 30 C6 00 FF AF B1 00 2C AF BF 00 3C AF B4 00 38 AF B3 00 34 AF B2 00 30 AF B0 00 28 00 80 88 21 AF A5 00 20 14 C0 00 2B A3 A6 00 24 8C A3 00 04 8E 22 00 94 AF A0 00 1C 24 63 00 01 00 03 18 C0 00 A3 28 21 10 40 00 2D AF A5 00 18 27 B2 00 18 3C 02 ?? ?? 8C 44 ?? ?? 0? ?? ?? ?? 02 40 78 21 8E 24 02 C0 24 02 FF FF 10 82 00 05 00 00 00 00 10 80 00 55 3C 07 ?? ?? 0? ?? ?? ?? 02 40 78 21 8E 22 02 DC 30 42 08 00 10 40 00 42 3C 02 ?? ?? 93 A2 00 24 10 40 00 07 8F A2 00 20 8C 43 00 04 8C 44 00 00 24 63 00 01 00 03 18 C0 00 83 18 21 AC 43 00 00 8F BF 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 40 00 00 18 21 24 63 00 01 8E 22 00 94 00 03 18 C0 AC A0 00 04 AC A0 00 00 00 A3 28 21 AF A0 00 1C 14 40 FF D5 AF A5 00 18 3C 07 ?? ?? 02 20 80 21 27 B2 00 18 24 13 FF FF 24 F4 ?? ?? 8E 02 02 6C 10 53 00 05 00 40 20 21 10 40 00 22 26 05 02 6C 0? ?? ?? ?? 02 40 78 21 8E 10 02 40 16 00 FF F7 00 00 00 00 8E 22 00 18 14 40 FF C5 3C 02 ?? ?? 3C 02 ?? ?? 8C 50 ?? ?? 12 00 FF C0 3C 02 C0 00 8E 03 02 68 00 62 18 24 3C 02 80 00 10 62 FF BC 3C 02 ?? ?? 12 11 FF B9 24 02 FF FF 8E 04 02 6C 10 82 FF B7 3C 02 ?? ?? 10 80 00 1B 3C 07 ?? ?? 0? ?? ?? ?? 02 40 78 21 0? ?? ?? ?? 3C 02 ?? ?? 8C 44 ?? ?? 0? ?? ?? ?? 02 40 78 21 0? ?? ?? ?? 93 A2 00 24 02 00 20 21 24 06 00 0F 0? ?? ?? ?? 02 80 38 21 10 40 FF DC 00 00 00 00 0? ?? ?? ?? 8E 04 02 6C 02 20 20 21 26 25 02 C0 24 06 00 1D 0? ?? ?? ?? 24 E7 ?? ?? 10 40 FF A8 00 00 00 00 0? ?? ?? ?? 8E 24 02 C0 02 00 20 21 26 05 02 6C 24 06 00 0F 0? ?? ?? ?? 24 E7 ?? ?? 10 40 FF 93 00 00 00 00 0? ?? ?? ?? 8E 04 02 6C }
	condition:
		$1
}

rule file_248_0_0 {
	meta:
		name = "ppoll"
		size = 692
		refs = "0004 __gnu_local_gp 00a4 __libc_errno 0160 __sigprocmask 0170 __poll 0194 __libc_enable_asynccancel 01fc __libc_disable_asynccancel"
	strings:
		$1 = { 27 BD FF 30 3C 1C ?? ?? 27 9C ?? ?? AF BE 00 C8 03 A0 F0 21 AF B4 00 C4 AF B3 00 C0 AF B2 00 BC AF B0 00 B4 AF BF 00 CC AF B1 00 B8 AF DC 00 10 00 C0 80 21 00 80 A0 21 00 A0 98 21 10 C0 00 80 00 E0 90 21 8C C3 00 00 8C C2 00 04 27 D0 00 98 AF C3 00 98 AF C2 00 9C 02 00 30 21 7C 03 E8 3B 8C 62 8B 70 14 40 00 4B 00 00 00 00 27 BD FF F0 27 A2 00 10 AF C2 00 A4 02 80 20 21 02 60 28 21 02 40 38 21 24 02 00 10 27 BD FF E0 AF A2 00 10 24 02 10 CE 00 00 00 0C 27 BD 00 20 10 E0 00 5A 00 40 88 21 8F 82 ?? ?? 7C 03 E8 3B 00 60 20 21 00 44 20 21 02 20 18 21 AC 91 00 00 24 04 00 59 14 64 00 54 24 11 FF FF 12 00 00 64 00 00 00 00 8E 03 00 00 04 60 00 6D 3C 05 3B 9A 8E 04 00 04 34 A5 CA 00 00 85 28 2B 10 A0 00 68 00 00 00 00 3C 02 00 20 34 42 C4 9C 00 62 28 2A 10 A0 00 14 24 10 FF FF 24 42 FF FF 10 62 00 58 3C 02 26 90 3C 02 00 0F 24 42 42 3F 00 82 20 21 3C 02 43 1B 34 42 DE 83 00 82 00 18 00 03 28 80 00 03 81 C0 02 05 80 23 02 03 80 21 00 04 27 C3 00 10 80 C0 00 00 10 10 00 02 14 83 00 44 20 23 02 04 80 21 12 40 00 3D 02 80 20 21 24 04 00 03 02 40 28 21 0? ?? ?? ?? 27 C6 00 18 02 80 20 21 02 60 28 21 0? ?? ?? ?? 02 00 30 21 24 04 00 03 27 C5 00 18 00 00 30 21 0? ?? ?? ?? 00 40 88 21 0? ?? ?? ?? 03 C0 E8 21 0? ?? ?? ?? AF C6 00 A8 27 BD FF F0 27 A3 00 10 00 40 F8 21 8F DC 00 10 AF C3 00 A0 02 80 20 21 02 60 28 21 8F C6 00 A8 02 40 38 21 24 02 00 10 27 BD FF E0 AF A2 00 10 24 02 10 CE 00 00 00 0C 27 BD 00 20 10 E0 00 07 00 40 88 21 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 AC 51 00 00 24 11 FF FF 03 E0 20 21 0? ?? ?? ?? 00 00 00 00 8F DC 00 10 24 02 FF FF 12 22 00 25 8F 82 ?? ?? 03 C0 E8 21 8F BF 00 CC 02 20 10 21 8F BE 00 C8 8F B4 00 C4 8F B3 00 C0 8F B2 00 BC 8F B1 00 B8 8F B0 00 B4 03 E0 00 08 27 BD 00 D0 0? ?? ?? ?? 00 00 30 21 02 60 28 21 0? ?? ?? ?? 02 00 30 21 0? ?? ?? ?? 00 40 88 21 16 40 FF BE 24 10 FF FF 0? ?? ?? ?? 02 80 20 21 24 42 6F C1 00 82 10 2A 14 40 FF A7 3C 02 00 0F 16 40 FF B6 02 80 20 21 0? ?? ?? ?? 02 60 28 21 7C 03 E8 3B 00 43 10 21 24 03 00 16 AC 43 00 00 0? ?? ?? ?? 24 11 FF FF 7C 03 E8 3B 00 43 20 21 0? ?? ?? ?? 8C 83 00 00 }
	condition:
		$1
}

rule file_249_0_0 {
	meta:
		name = "__atomic_readv_replacement"
		size = 532
		refs = "0004 __gnu_local_gp 00c8 __read 0110 memcpy 0128 free 0170 __libc_errno 01cc __libc_alloca_cutoff 01dc malloc 0200 _Unwind_Resume"
	strings:
		$1 = { 27 BD FF B8 3C 1C ?? ?? 27 9C ?? ?? AF BE 00 40 03 A0 F0 21 AF B3 00 2C AF B2 00 28 AF B1 00 24 AF BF 00 44 AF B7 00 3C AF B6 00 38 AF B5 00 34 AF B4 00 30 AF B0 00 20 AF DC 00 10 00 C0 88 21 00 80 98 21 18 C0 00 5F 00 A0 90 21 8C A2 00 04 3C 03 80 00 00 43 18 2B 10 60 00 43 3C 04 7F FF 00 A0 38 21 00 00 18 21 00 00 80 21 0? ?? ?? ?? 34 84 FF FF 24 E7 00 08 8C E2 00 04 00 90 40 23 01 02 40 2B 15 00 00 38 00 00 00 00 24 63 00 01 14 71 FF F8 02 02 80 21 34 02 80 01 02 02 10 2B 10 40 00 4A 00 00 00 00 26 02 00 0E 00 02 10 C2 00 02 10 C0 03 A2 E8 23 27 B4 00 10 00 00 A8 21 02 60 20 21 02 80 28 21 0? ?? ?? ?? 02 00 30 21 04 40 00 3A 00 40 B0 21 1A 20 00 11 00 40 80 21 0? ?? ?? ?? 00 00 B8 21 12 F1 00 0D 26 52 00 08 8E 42 00 04 8E 44 00 00 02 80 28 21 02 02 98 2B 02 13 10 0B 00 40 98 21 00 40 30 21 02 02 80 23 0? ?? ?? ?? 02 93 A0 21 16 00 FF F3 26 F7 00 01 02 C0 10 21 02 A0 20 21 0? ?? ?? ?? AF C2 00 18 03 C0 E8 21 8F BF 00 44 8F C2 00 18 8F B7 00 3C 8F BE 00 40 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 48 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 16 AC 43 00 00 03 C0 E8 21 8F BF 00 44 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 24 02 FF FF 03 E0 00 08 27 BD 00 48 00 00 A8 21 0? ?? ?? ?? 24 02 FF FF 0? ?? ?? ?? 00 00 80 21 0? ?? ?? ?? 02 00 20 21 14 40 FF B5 26 02 00 0E 0? ?? ?? ?? 02 00 20 21 10 40 FF F4 00 40 A0 21 0? ?? ?? ?? 00 40 A8 21 00 80 80 21 0? ?? ?? ?? 02 A0 20 21 0? ?? ?? ?? 02 00 20 21 00 00 A8 21 0? ?? ?? ?? 00 80 80 21 }
	condition:
		$1
}

rule file_249_1_0 {
	meta:
		name = "__libc_readv"
		size = 292
		refs = "0000 __gnu_local_gp 0054 __libc_errno 0098 __libc_enable_asynccancel 00e0 __libc_disable_asynccancel"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF D0 27 9C ?? ?? AF B2 00 28 AF B1 00 24 AF B0 00 20 AF BF 00 2C AF BC 00 10 00 80 90 21 00 A0 88 21 00 C0 80 21 7C 03 E8 3B 8C 62 8B 70 14 40 00 18 00 00 00 00 24 02 10 31 00 00 00 0C 10 E0 00 2A 00 40 28 21 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 64 20 21 AC 82 00 00 24 02 FF FF 24 03 00 16 14 A3 00 23 8F BF 00 2C 2A 03 00 09 14 60 00 20 02 40 20 21 02 20 28 21 8F B2 00 28 8F B1 00 24 02 00 30 21 8F B0 00 20 0? ?? ?? ?? 27 BD 00 30 0? ?? ?? ?? 00 00 00 00 00 40 F8 21 8F BC 00 10 02 40 20 21 02 20 28 21 02 00 30 21 24 02 10 31 00 00 00 0C 10 E0 00 08 03 E0 20 21 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 64 20 21 AC 82 00 00 24 02 FF FF 03 E0 20 21 0? ?? ?? ?? AF A2 00 18 8F BC 00 10 8F A2 00 18 04 40 00 06 8F BF 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 30 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 64 20 21 0? ?? ?? ?? 8C 85 00 00 }
	condition:
		$1
}

rule file_250_0_0 {
	meta:
		name = "__umask"
		size = 16
	strings:
		$1 = { 24 02 0F DC 00 00 00 0C 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_251_0_0 {
	meta:
		name = "__seed48_r"
		size = 108
	strings:
		$1 = { 88 A2 00 00 00 A0 18 21 24 A5 00 06 98 62 00 03 A8 62 00 06 B8 A2 00 03 90 66 00 04 00 00 10 21 A0 A6 00 04 90 66 00 05 A0 A6 00 05 94 85 00 04 A4 65 00 04 94 85 00 02 A4 65 00 02 94 86 00 00 24 04 00 05 AC 64 00 10 3C 05 DE EC 24 04 00 0B 34 A5 E6 6D A4 64 00 0C 24 04 00 01 AC 65 00 14 A4 66 00 00 03 E0 00 08 A4 64 00 0E }
	condition:
		$1
}

rule file_252_0_0 {
	meta:
		name = "sethostname"
		size = 28
	strings:
		$1 = { 24 02 0F EA 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_253_0_0 {
	meta:
		name = "iruserfopen"
		size = 476
		refs = "0020 __lxstat64 003c _libc_intl_domainname 0040 $LC1 0050 __dcgettext 0060 __rcmd_errstr 006c _IO_new_fclose 0090 $LC0 00f0 _IO_new_fopen 00e8 $LC2 0100 fileno 0110 __fxstat64 0130 $LC5 0168 $LC7 0184 $LC6 01a4 $LC3 01c0 $LC4"
	strings:
		$1 = { 27 BD FF 38 AF B0 00 BC 00 80 80 21 AF B1 00 C0 24 04 00 03 00 A0 88 21 27 A6 00 18 AF BF 00 C4 0? ?? ?? ?? 02 00 28 21 14 40 00 18 8F A3 00 30 34 02 80 00 30 63 F0 00 10 62 00 2B 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 05 0? ?? ?? ?? 00 00 80 21 10 40 00 14 00 00 00 00 3C 03 ?? ?? 12 00 00 1A AC 62 ?? ?? 0? ?? ?? ?? 02 00 20 21 8F BF 00 C4 8F B1 00 C0 8F B0 00 BC 00 00 10 21 03 E0 00 08 27 BD 00 C8 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 14 40 FF EE 00 00 80 21 8E 03 00 00 8F BF 00 C4 02 00 10 21 34 63 80 00 AE 03 00 00 8F B1 00 C0 8F B0 00 BC 03 E0 00 08 27 BD 00 C8 8F BF 00 C4 8F B1 00 C0 8F B0 00 BC 00 00 10 21 03 E0 00 08 27 BD 00 C8 3C 05 ?? ?? 02 00 20 21 0? ?? ?? ?? 24 A5 ?? ?? 10 40 00 29 00 40 80 21 0? ?? ?? ?? 00 40 20 21 00 40 28 21 24 04 00 03 0? ?? ?? ?? 27 A6 00 18 04 40 00 29 3C 04 ?? ?? 8F A2 00 38 10 40 00 09 00 00 00 00 10 51 00 07 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 0? ?? ?? ?? 00 00 00 00 8F A2 00 30 30 42 00 12 14 40 00 0B 3C 04 ?? ?? 8F A2 00 34 2C 42 00 02 14 40 FF D1 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 0? ?? ?? ?? 00 00 00 00 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 0? ?? ?? ?? 00 00 00 00 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 0? ?? ?? ?? 00 00 00 00 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_253_1_0 {
	meta:
		name = "__validuser2_sa"
		size = 1224
		refs = "0000 __gnu_local_gp 0008 __libc_tsd_CTYPE_B 000c __libc_tsd_CTYPE_TOLOWER 0080 __getline 0154 $LC8 0160 strncmp 016c $LC9 0210 free 024c strcmp 0300 getnameinfo 0350 getaddrinfo 0398 memcmp 03ac freeaddrinfo 0414 innetgr"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 8F 82 ?? ?? 8F 89 ?? ?? 27 BD FF 40 7C 03 E8 3B AF BE 00 B8 AF B7 00 B4 AF B4 00 A8 AF B3 00 A4 AF B1 00 9C AF BF 00 BC AF B6 00 B0 AF B5 00 AC AF B2 00 A0 AF B0 00 98 AF BC 00 20 AF A2 00 88 00 60 A0 21 00 80 88 21 00 A0 98 21 AF A6 00 C8 AF A7 00 CC AF A0 00 80 AF A0 00 7C 01 23 B8 21 00 43 F0 21 8F A3 00 88 24 12 00 23 00 74 80 21 27 A4 00 80 27 A5 00 7C 0? ?? ?? ?? 02 20 30 21 18 40 00 77 8F A3 00 80 8F A2 00 7C 00 62 10 21 A0 40 FF FF 8F B6 00 80 82 C4 00 00 10 80 FF F4 00 04 10 40 8E 06 00 00 00 C2 10 21 94 47 00 00 30 E7 00 20 30 E7 FF FF 10 E0 00 0C 00 80 18 21 02 C0 10 21 24 42 00 01 80 43 00 00 00 03 28 40 10 60 FF E7 00 C5 28 21 94 A5 00 00 30 A5 00 20 14 A0 FF F9 24 42 00 01 24 42 FF FF 10 72 FF E0 00 00 00 00 10 E0 00 09 00 00 00 00 0? ?? ?? ?? 24 02 00 20 8F C3 00 00 00 62 10 21 94 42 00 00 30 42 00 20 14 40 00 54 00 00 00 00 8E E2 00 00 00 04 20 80 26 D6 00 01 00 44 20 21 8C 82 00 00 82 C4 00 00 A2 C2 FF FF 14 80 FF F2 00 04 10 40 02 C0 10 21 A0 40 00 00 8F B0 00 80 3C 03 ?? ?? 24 64 ?? ?? 24 06 00 02 0? ?? ?? ?? 02 00 28 21 10 40 00 A7 3C 02 ?? ?? 24 44 ?? ?? 02 00 28 21 0? ?? ?? ?? 24 06 00 02 10 40 00 AC 24 03 00 2D 92 02 00 00 10 43 00 A5 24 03 00 2B 14 43 00 52 24 03 00 01 92 02 00 01 14 40 00 4F 00 00 00 00 82 C2 00 00 8F A3 00 CC 3C 04 ?? ?? 24 84 ?? ?? 00 62 B0 0A 24 06 00 02 0? ?? ?? ?? 02 C0 28 21 10 40 00 A3 3C 02 ?? ?? 24 44 ?? ?? 02 C0 28 21 0? ?? ?? ?? 24 06 00 02 10 40 00 A6 24 03 00 2D 92 C2 00 00 10 43 00 AD 24 03 00 2B 14 43 00 15 8F A4 00 D0 92 C2 00 01 14 40 00 12 00 00 00 00 00 00 10 21 8F A4 00 80 0? ?? ?? ?? AF A2 00 94 8F BF 00 BC 8F A2 00 94 8F BE 00 B8 8F B7 00 B4 8F B6 00 B0 8F B5 00 AC 8F B4 00 A8 8F B3 00 A4 8F B2 00 A0 8F B1 00 9C 8F B0 00 98 03 E0 00 08 27 BD 00 C0 0? ?? ?? ?? 02 C0 28 21 2C 42 00 01 1C 40 FF EB 00 00 00 00 10 40 FF 83 8F A3 00 88 0? ?? ?? ?? 24 02 FF FF 24 02 00 20 14 82 00 60 24 02 00 09 82 C3 00 01 26 C2 00 01 10 60 00 14 A2 C0 00 00 8F C4 00 00 00 03 18 40 00 83 18 21 94 63 00 00 30 63 00 20 14 60 00 09 24 42 00 01 24 42 FF FF 0? ?? ?? ?? 00 40 B0 21 94 A3 00 00 30 63 00 20 10 60 00 47 00 40 B0 21 24 42 00 01 80 43 00 00 00 03 28 40 14 60 FF F8 00 85 28 21 0? ?? ?? ?? 00 40 B0 21 AF A3 00 90 8F A5 00 C8 24 02 00 01 AF A0 00 10 AF A0 00 14 AF A2 00 18 02 60 20 21 27 A6 00 28 0? ?? ?? ?? 24 07 00 2E 14 40 00 05 27 A4 00 28 0? ?? ?? ?? 02 00 28 21 10 40 00 4D 00 00 00 00 96 62 00 00 02 00 20 21 00 00 28 21 27 A6 00 58 27 A7 00 78 AF A0 00 58 AF A0 00 60 AF A0 00 64 AF A0 00 68 AF A0 00 6C AF A0 00 70 AF A0 00 74 0? ?? ?? ?? AF A2 00 5C 14 40 FF 44 00 40 90 21 8F A3 00 78 10 60 00 11 AF A3 00 8C 96 75 00 00 0? ?? ?? ?? 00 60 80 21 8E 10 00 1C 12 00 00 0B 00 00 00 00 8E 04 00 04 14 95 FF FB 00 00 00 00 8E 04 00 14 8E 06 00 10 0? ?? ?? ?? 02 60 28 21 14 40 FF F5 00 00 00 00 8F B2 00 90 0? ?? ?? ?? 8F A4 00 8C 06 40 FF 95 24 02 FF FF 12 40 FF 2C 8F A3 00 88 0? ?? ?? ?? 82 C2 00 00 94 A3 00 00 30 63 00 20 14 60 FF 5D 00 00 00 00 24 42 00 01 80 43 00 00 00 03 28 40 14 60 FF F8 00 85 28 21 0? ?? ?? ?? A0 40 00 00 10 82 FF A0 02 C0 10 21 0? ?? ?? ?? A0 40 00 00 8F A5 00 D4 26 04 00 02 00 00 30 21 0? ?? ?? ?? 00 00 38 21 0? ?? ?? ?? 00 40 90 21 24 03 FF FF 26 10 00 01 0? ?? ?? ?? AF A3 00 90 8F A5 00 D4 26 04 00 02 00 00 30 21 0? ?? ?? ?? 00 00 38 21 0? ?? ?? ?? 00 02 90 23 0? ?? ?? ?? 8F B2 00 90 8F A6 00 D0 26 C4 00 02 00 00 28 21 0? ?? ?? ?? 00 00 38 21 18 40 FF 7C 00 00 00 00 0? ?? ?? ?? 00 00 10 21 8F A6 00 D0 26 C4 00 02 00 00 28 21 0? ?? ?? ?? 00 00 38 21 00 02 10 23 18 40 FF 72 00 00 00 00 0? ?? ?? ?? 00 00 10 21 8F A5 00 D0 0? ?? ?? ?? 26 C4 00 01 2C 42 00 01 00 02 10 23 10 40 FE ED 8F A3 00 88 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_253_2_0 {
	meta:
		name = "ruserok2_sa"
		size = 544
		refs = "0048 __check_rhosts_file 005c __sysconf 0088 __getpwnam_r 00a8 strlen 00cc mempcpy 00d4 $LC11 00fc __geteuid 010c seteuid 0150 _IO_new_fclose 0198 $LC10"
	strings:
		$1 = { 27 BD FF 98 AF BE 00 60 03 A0 F0 21 AF B5 00 58 AF B4 00 54 AF B3 00 50 AF B1 00 48 AF B0 00 44 AF BF 00 64 AF B6 00 5C AF B2 00 4C 00 C0 80 21 00 80 A8 21 00 A0 A0 21 00 E0 98 21 10 C0 00 56 8F D1 00 78 24 12 FF FF 3C 02 ?? ?? 8C 42 ?? ?? 02 02 80 25 12 00 00 70 00 00 00 00 0? ?? ?? ?? 24 04 00 46 24 43 00 0E 00 03 18 C2 00 03 18 C0 03 A3 E8 23 27 C3 00 3C AF A3 00 10 02 20 20 21 27 C5 00 20 27 A6 00 18 0? ?? ?? ?? 00 40 38 21 14 40 00 34 24 03 FF FF 8F C2 00 3C 10 40 00 31 00 00 00 00 8C 56 00 14 0? ?? ?? ?? 02 C0 20 21 24 43 00 17 00 03 18 C2 00 03 18 C0 03 A3 E8 23 27 B0 00 18 00 40 30 21 02 C0 28 21 0? ?? ?? ?? 02 00 20 21 3C 05 ?? ?? 8C A4 ?? ?? 24 A5 ?? ?? 00 40 18 21 8C A2 00 04 A8 64 00 00 90 A5 00 08 B8 64 00 03 A8 62 00 04 B8 62 00 07 0? ?? ?? ?? A0 65 00 08 00 40 B0 21 8F C2 00 3C 0? ?? ?? ?? 8C 44 00 08 8F C2 00 3C 02 00 20 21 0? ?? ?? ?? 8C 45 00 08 10 40 00 0C 00 40 80 21 00 40 20 21 8F C2 00 7C 02 A0 28 21 02 80 30 21 02 20 38 21 AF B3 00 10 0? ?? ?? ?? AF A2 00 14 02 00 20 21 0? ?? ?? ?? 00 40 90 21 0? ?? ?? ?? 02 C0 20 21 02 40 18 21 03 C0 E8 21 8F DF 00 64 8F BE 00 60 8F B6 00 5C 8F B5 00 58 8F B4 00 54 8F B3 00 50 8F B2 00 4C 8F B1 00 48 8F B0 00 44 00 60 10 21 03 E0 00 08 27 BD 00 68 3C 04 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 00 00 28 21 10 40 FF A6 00 40 B0 21 00 40 20 21 8F C2 00 7C 02 A0 28 21 02 80 30 21 02 20 38 21 AF B3 00 10 0? ?? ?? ?? AF A2 00 14 00 40 90 21 0? ?? ?? ?? 02 C0 20 21 16 40 FF 9A 00 00 18 21 03 C0 E8 21 8F BF 00 64 8F BE 00 60 8F B6 00 5C 8F B5 00 58 8F B4 00 54 8F B3 00 50 8F B2 00 4C 8F B1 00 48 8F B0 00 44 00 60 10 21 03 E0 00 08 27 BD 00 68 0? ?? ?? ?? 24 03 FF FF }
	condition:
		$1
}

rule file_253_3_0 {
	meta:
		name = "rresvport_af"
		size = 512
		refs = "0004 __gnu_local_gp 0054 __socket 006c memset 0094 __libc_errno 00e0 __bind 0180 __close"
	strings:
		$1 = { 27 BD FF 48 3C 1C ?? ?? 27 9C ?? ?? AF B4 00 A8 24 02 00 02 30 B4 FF FF AF B0 00 98 AF BF 00 B4 AF B6 00 B0 AF B5 00 AC AF B3 00 A4 AF B2 00 A0 AF B1 00 9C AF BC 00 10 12 82 00 49 00 80 80 21 24 02 00 0A 16 82 00 35 24 13 00 1C 02 80 20 21 24 05 00 02 0? ?? ?? ?? 00 00 30 21 04 40 00 66 00 40 90 21 27 A4 00 18 00 00 28 21 0? ?? ?? ?? 24 06 00 80 8E 11 00 00 8F BC 00 10 2A 22 02 00 10 40 00 39 A7 B4 00 18 24 02 02 00 AE 02 00 00 24 11 02 00 8F 95 ?? ?? 7C 03 E8 3B 00 60 B0 21 02 B6 B0 21 02 20 18 21 0? ?? ?? ?? 24 14 00 7D 8E C5 00 00 14 B4 00 32 00 00 00 00 8E 05 00 00 24 A2 FF FF 38 A5 02 00 00 45 18 0B 12 23 00 39 AE 03 00 00 02 40 20 21 27 A5 00 18 02 60 30 21 0? ?? ?? ?? A7 A3 00 1A 04 40 FF F1 24 03 03 FF 8F BF 00 B4 02 40 10 21 8F B6 00 B0 8F B5 00 AC 8F B4 00 A8 8F B3 00 A4 8F B2 00 A0 8F B1 00 9C 8F B0 00 98 03 E0 00 08 27 BD 00 B8 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 7C AC 43 00 00 24 02 FF FF 8F BF 00 B4 8F B6 00 B0 8F B5 00 AC 8F B4 00 A8 8F B3 00 A4 8F B2 00 A0 8F B1 00 9C 8F B0 00 98 03 E0 00 08 27 BD 00 B8 0? ?? ?? ?? 24 13 00 10 2A 22 04 00 14 40 FF C9 24 02 03 FF AE 02 00 00 0? ?? ?? ?? 24 11 03 FF 0? ?? ?? ?? 02 40 20 21 8F BF 00 B4 8F B6 00 B0 8F B5 00 AC 8F B4 00 A8 8F B3 00 A4 8F B2 00 A0 8F B1 00 9C 8F B0 00 98 24 02 FF FF 03 E0 00 08 27 BD 00 B8 0? ?? ?? ?? 02 40 20 21 8F BF 00 B4 7C 03 E8 3B 02 A3 10 21 24 03 00 0B AC 43 00 00 8F B6 00 B0 8F B5 00 AC 8F B4 00 A8 8F B3 00 A4 8F B2 00 A0 8F B1 00 9C 8F B0 00 98 24 02 FF FF 03 E0 00 08 27 BD 00 B8 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_253_4_0 {
	meta:
		name = "rcmd_af"
		size = 2444
		refs = "000c __gnu_local_gp 0060 __getpid 0068 $LC12 00a0 __snprintf 00b8 getaddrinfo 00e4 free 00f0 __strdup 0110 __libc_errno 011c __sigblock 0148 _libc_intl_domainname 0130 $LC19 0158 rresvport_af 0174 __fcntl 0184 __connect 0194 __close 01e0 getnameinfo 01f4 __dcgettext 0204 __asprintf 021c __fxprintf 0210 $LC16 0230 perror 0150 $LC20 02d4 $LC18 02e4 __sigsetmask 02ec freeaddrinfo 033c $LC13 03a4 __sleep 03e0 __strerror_r 03e8 $LC21 0410 gai_strerror 0418 $LC14 0490 __listen 04b4 strlen 04c4 __write 0504 __poll 0544 accept 05fc __writev 0638 __read 06b4 $LC29 0724 $LC17 0774 $LC22 079c $LC23 08f0 $LC24 0880 $LC27 08b4 $LC25 08f4 $LC26 0910 $LC15 0954 $LC28"
	strings:
		$1 = { 27 BD FE 48 AF B0 01 90 97 B0 01 D2 3C 1C ?? ?? 27 9C ?? ?? 24 02 00 0A AF B1 01 94 AF BF 01 B4 AF BE 01 B0 AF B7 01 AC AF B6 01 A8 AF B5 01 A4 AF B4 01 A0 AF B3 01 9C AF B2 01 98 AF BC 00 20 AF A4 01 B8 AF A6 01 C0 AF A7 01 C4 12 02 00 04 30 B1 FF FF 32 02 FF FD 14 40 01 BE 00 00 00 00 0? ?? ?? ?? 00 00 00 00 3C 07 ?? ?? 24 03 00 02 24 E6 ?? ?? 27 A4 01 68 24 05 00 08 02 20 38 21 AF A3 01 20 AF A3 01 28 00 40 A0 21 AF A0 01 2C AF A0 01 30 AF A0 01 34 AF A0 01 38 AF A0 01 3C 0? ?? ?? ?? AF B0 01 24 8F A2 01 B8 27 A5 01 68 27 A6 01 20 8C 44 00 00 0? ?? ?? ?? 27 A7 01 7C 14 40 00 99 8F BC 00 20 8F B0 01 7C 24 02 00 01 A7 A2 01 5C 8E 03 00 18 10 60 01 71 A7 A2 01 64 3C 10 ?? ?? 0? ?? ?? ?? 8E 04 ?? ?? 8F A2 01 7C 0? ?? ?? ?? 8C 44 00 18 AE 02 ?? ?? 10 40 02 03 8F BC 00 20 8F A7 01 B8 8F B0 01 7C AC E2 00 00 8F 83 ?? ?? 3C 04 00 10 3C 15 ?? ?? 0? ?? ?? ?? AF A3 01 84 8F A7 01 84 7C 03 E8 3B AF A2 01 88 3C 17 ?? ?? 24 02 03 FF AF A2 01 78 AF A0 01 80 24 16 00 01 00 E3 98 21 26 B5 ?? ?? 26 F7 ?? ?? 3C 1E ?? ?? 96 05 00 06 0? ?? ?? ?? 27 A4 01 78 00 40 88 21 04 40 00 54 8F BC 00 20 00 40 20 21 24 05 00 18 0? ?? ?? ?? 02 80 30 21 8E 05 00 14 8E 06 00 10 0? ?? ?? ?? 02 20 20 21 04 41 00 B4 8F A2 01 78 0? ?? ?? ?? 02 20 20 21 8E 71 00 00 24 02 00 7D 12 22 00 76 24 02 00 92 12 22 01 E1 24 03 00 01 8E 02 00 1C 10 40 00 75 8F A3 01 80 AF A0 00 28 8E 04 00 14 8E 05 00 10 24 02 00 01 24 07 00 2E 27 A6 00 F0 AF A0 00 10 AF A0 00 14 0? ?? ?? ?? AF A2 00 18 02 A0 20 21 02 E0 28 21 24 06 00 05 0? ?? ?? ?? 27 B2 00 28 00 40 28 21 02 40 20 21 0? ?? ?? ?? 27 A6 00 F0 04 40 00 07 3C 05 ?? ?? 8F A6 00 28 00 00 20 21 0? ?? ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 8F A4 00 28 00 00 20 21 0? ?? ?? ?? AE 71 00 00 8E 10 00 1C 24 02 00 01 24 07 00 2E 8E 04 00 14 8E 05 00 10 27 A6 00 F0 AF A0 00 10 AF A0 00 14 0? ?? ?? ?? AF A2 00 18 02 A0 20 21 27 C5 ?? ?? 0? ?? ?? ?? 24 06 00 05 00 40 28 21 02 40 20 21 0? ?? ?? ?? 27 A6 00 F0 04 40 FF B4 8F A6 00 28 3C 05 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 00 00 20 21 0? ?? ?? ?? 8F A4 00 28 96 05 00 06 0? ?? ?? ?? 27 A4 01 78 00 40 88 21 04 41 FF AE 8F BC 00 20 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 8C 43 00 00 24 02 00 0B 10 62 01 13 3C 05 ?? ?? 00 00 20 21 0? ?? ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 8F A4 01 88 0? ?? ?? ?? 8F A4 01 7C 24 02 FF FF 8F BF 01 B4 8F BE 01 B0 8F B7 01 AC 8F B6 01 A8 8F B5 01 A4 8F B4 01 A0 8F B3 01 9C 8F B2 01 98 8F B1 01 94 8F B0 01 90 03 E0 00 08 27 BD 01 B8 24 03 FF FE 14 43 00 38 8F A3 01 B8 8C 66 00 00 10 C0 00 35 3C 05 ?? ?? 00 00 20 21 0? ?? ?? ?? 24 A5 ?? ?? 24 02 FF FF 8F BF 01 B4 8F BE 01 B0 8F B7 01 AC 8F B6 01 A8 8F B5 01 A4 8F B4 01 A0 8F B3 01 9C 8F B2 01 98 8F B1 01 94 8F B0 01 90 03 E0 00 08 27 BD 01 B8 8F A2 01 78 24 42 FF FF 0? ?? ?? ?? AF A2 01 78 10 60 00 0A 00 00 00 00 2A C2 00 11 10 40 00 07 00 00 00 00 0? ?? ?? ?? 02 C0 20 21 00 16 B0 40 8F B0 01 7C 0? ?? ?? ?? AF A0 01 80 0? ?? ?? ?? 8F A4 01 7C 8F A7 01 84 7C 03 E8 3B 27 A5 00 28 00 E3 10 21 8C 44 00 00 8F A2 01 B8 24 06 00 C8 0? ?? ?? ?? 8C 50 00 00 3C 05 ?? ?? 00 00 20 21 24 A5 ?? ?? 02 00 30 21 0? ?? ?? ?? 00 40 38 21 0? ?? ?? ?? 8F A4 01 88 0? ?? ?? ?? 24 02 FF FF 0? ?? ?? ?? 00 40 20 21 3C 05 ?? ?? 00 00 20 21 24 A5 ?? ?? 0? ?? ?? ?? 00 40 30 21 8F BF 01 B4 8F BE 01 B0 8F B7 01 AC 8F B6 01 A8 8F B5 01 A4 8F B4 01 A0 8F B3 01 9C 8F B2 01 98 8F B1 01 94 8F B0 01 90 24 02 FF FF 03 E0 00 08 27 BD 01 B8 8F A3 01 CC 24 42 FF FF 10 60 00 C2 AF A2 01 78 96 05 00 06 0? ?? ?? ?? 27 A4 01 78 8E 03 00 10 00 40 98 21 04 40 00 9E AF A3 01 74 00 40 20 21 0? ?? ?? ?? 24 05 00 01 8F A7 01 78 27 B0 01 40 3C 02 ?? ?? 24 05 00 08 24 46 ?? ?? 0? ?? ?? ?? 02 00 20 21 0? ?? ?? ?? 02 00 20 21 24 46 00 01 02 20 20 21 0? ?? ?? ?? 02 00 28 21 02 00 20 21 0? ?? ?? ?? 00 40 90 21 24 42 00 01 16 42 00 AE 8F BC 00 20 8F 94 ?? ?? 7C 03 E8 3B 27 A4 01 58 02 83 A8 21 24 05 00 02 24 06 FF FF AE A0 00 00 AF B1 01 58 0? ?? ?? ?? AF B3 01 60 18 40 00 C8 97 A2 01 66 27 B2 00 28 30 42 00 01 10 40 00 C4 27 B6 01 74 24 14 FF FF 0? ?? ?? ?? 24 1E 00 04 8E A2 00 00 14 5E 00 08 97 A2 00 28 02 60 20 21 02 40 28 21 0? ?? ?? ?? 02 C0 30 21 10 54 FF F8 00 40 B8 21 97 A2 00 28 24 03 00 02 10 43 00 03 24 03 00 0A 14 43 00 02 00 00 90 21 97 B2 00 2A 0? ?? ?? ?? 02 60 20 21 06 E0 00 DE 8F A3 01 CC 26 42 FE 00 2C 42 02 00 10 40 00 BC AC 77 00 00 8F A4 01 C0 24 12 FF FF 24 13 00 04 0? ?? ?? ?? AF A4 01 40 8F A4 01 C4 24 42 00 01 AF A2 01 44 0? ?? ?? ?? AF A4 01 48 8F A4 01 C8 24 42 00 01 AF A2 01 4C 0? ?? ?? ?? AF A4 01 50 8F BC 00 20 24 42 00 01 7C 03 E8 3B 8F 94 ?? ?? AF A2 01 54 0? ?? ?? ?? 02 83 A0 21 8E 82 00 00 14 53 00 07 00 00 00 00 02 20 20 21 02 00 28 21 0? ?? ?? ?? 24 06 00 03 10 52 FF F8 8F BC 00 20 8F 93 ?? ?? 7C 03 E8 3B 24 10 FF FF 02 63 98 21 0? ?? ?? ?? 24 12 00 04 8E 62 00 00 14 52 00 20 00 00 00 00 02 20 20 21 02 C0 28 21 0? ?? ?? ?? 24 06 00 01 10 50 FF F8 24 03 00 01 14 43 00 BF 00 00 00 00 83 A2 01 74 14 40 00 6B 24 10 00 0A 0? ?? ?? ?? 8F A4 01 88 0? ?? ?? ?? 8F A4 01 7C 8F BF 01 B4 02 20 10 21 8F BE 01 B0 8F B7 01 AC 8F B6 01 A8 8F B5 01 A4 8F B4 01 A0 8F B3 01 9C 8F B2 01 98 8F B1 01 94 8F B0 01 90 03 E0 00 08 27 BD 01 B8 8F A2 01 B8 0? ?? ?? ?? AC 40 00 00 AF A0 01 70 8F A7 01 B8 3C 05 ?? ?? 27 A4 01 70 8C E6 00 00 0? ?? ?? ?? 24 A5 ?? ?? 04 40 00 09 8F A2 01 78 8F A6 01 70 3C 05 ?? ?? 00 00 20 21 0? ?? ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 8F A4 01 70 8F A2 01 78 10 40 00 03 8F A7 01 CC 0? ?? ?? ?? 8C E4 00 00 0? ?? ?? ?? 02 20 20 21 0? ?? ?? ?? 8F A4 01 88 0? ?? ?? ?? 8F A4 01 7C 0? ?? ?? ?? 24 02 FF FF 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 3C 05 ?? ?? 00 00 20 21 24 A5 ?? ?? 0? ?? ?? ?? 00 40 30 21 0? ?? ?? ?? 00 00 00 00 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 7C AC 43 00 00 0? ?? ?? ?? 24 02 FF FF 3C 05 ?? ?? 02 20 20 21 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 01 27 B0 01 40 AF A0 01 78 0? ?? ?? ?? 27 B6 01 74 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 05 0? ?? ?? ?? AF A0 00 28 00 40 28 21 0? ?? ?? ?? 27 A4 00 28 04 40 00 07 8F A6 00 28 3C 05 ?? ?? 00 00 20 21 0? ?? ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 8F A4 00 28 0? ?? ?? ?? 02 60 20 21 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 00 00 00 00 83 A2 01 74 10 50 FF BC 8F A2 01 78 02 20 20 21 02 C0 28 21 0? ?? ?? ?? 24 06 00 01 24 03 00 01 24 04 00 02 02 C0 28 21 10 43 FF F3 24 06 00 01 0? ?? ?? ?? 8F A2 01 78 7C 03 E8 3B 02 83 A0 21 8E 82 00 00 AF A0 00 28 14 40 00 1C 3C 10 ?? ?? 27 B2 00 28 3C 05 ?? ?? 26 04 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 00 40 28 21 0? ?? ?? ?? 02 40 20 21 04 41 FF D6 8F A6 00 28 0? ?? ?? ?? 00 00 00 00 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 05 0? ?? ?? ?? AF A0 01 70 00 40 28 21 0? ?? ?? ?? 27 A4 01 70 04 41 FF 8B 8F A6 01 70 0? ?? ?? ?? 8F A2 01 78 3C 05 ?? ?? 26 04 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 27 B2 00 28 02 40 20 21 0? ?? ?? ?? 00 40 28 21 04 41 FF BB 8F A6 00 28 8E 82 00 00 14 40 FF BE 00 00 00 00 0? ?? ?? ?? 3C 05 ?? ?? 3C 05 ?? ?? 00 00 20 21 0? ?? ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? AF A0 01 78 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 3C 05 ?? ?? 00 00 20 21 0? ?? ?? ?? 24 A5 ?? ?? 8E 02 00 1C 14 40 FE 21 AF A3 01 80 0? ?? ?? ?? 2A C2 00 11 14 40 FF 59 AF A0 01 70 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 8F A3 01 B8 27 A4 01 70 00 40 28 21 0? ?? ?? ?? 8C 66 00 00 04 41 FF 55 8F A6 01 70 0? ?? ?? ?? 8F A2 01 78 }
	condition:
		$1
}

rule file_253_5_0 {
	meta:
		name = "rcmd"
		size = 52
		refs = "0020 rcmd_af"
	strings:
		$1 = { 27 BD FF D0 8F A2 00 40 30 A5 FF FF AF BF 00 2C AF A2 00 10 8F A2 00 44 AF A2 00 14 24 02 00 02 0? ?? ?? ?? AF A2 00 18 8F BF 00 2C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_253_7_0 {
	meta:
		name = "ruserok_af"
		size = 232
		refs = "0058 getaddrinfo 00ac freeaddrinfo"
	strings:
		$1 = { 27 BD FF A0 97 A2 00 72 AF B4 00 58 AF B3 00 54 AF B2 00 50 00 C0 98 21 00 A0 90 21 00 E0 A0 21 00 00 28 21 27 A6 00 20 27 A7 00 40 AF B1 00 4C AF BF 00 5C AF B0 00 48 00 80 88 21 AF A0 00 20 AF A0 00 28 AF A0 00 2C AF A0 00 30 AF A0 00 34 AF A0 00 38 AF A0 00 3C 0? ?? ?? ?? AF A2 00 24 14 40 00 1F 8F B0 00 40 16 00 00 06 00 00 20 21 0? ?? ?? ?? 24 10 FF FF 8E 10 00 1C 12 00 00 16 00 00 00 00 8E 04 00 14 8E 05 00 10 02 40 30 21 AF B4 00 10 AF B1 00 14 0? ?? ?? ?? 02 60 38 21 14 40 FF F5 8F A4 00 40 00 00 80 21 0? ?? ?? ?? 00 00 00 00 02 00 10 21 8F BF 00 5C 8F B4 00 58 8F B3 00 54 8F B2 00 50 8F B1 00 4C 8F B0 00 48 03 E0 00 08 27 BD 00 60 0? ?? ?? ?? 24 10 FF FF 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_253_8_0 {
	meta:
		name = "ruserok"
		size = 36
		refs = "0010 ruserok_af"
	strings:
		$1 = { 27 BD FF D8 24 02 00 02 AF A2 00 10 AF BF 00 24 0? ?? ?? ?? 00 00 00 00 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_253_9_0 {
	meta:
		name = "iruserok_af"
		size = 260
		refs = "0038 memset 008c $LC30"
	strings:
		$1 = { 27 BD FF 48 AF B1 00 A4 97 B1 00 CA AF B3 00 AC AF B2 00 A8 AF B0 00 A0 00 A0 98 21 00 80 80 21 00 C0 90 21 27 A4 00 20 00 00 28 21 24 06 00 80 AF B4 00 B0 AF BF 00 B4 0? ?? ?? ?? 00 E0 A0 21 24 02 00 02 12 22 00 29 24 02 00 0A 16 22 00 1F 8F BF 00 B4 8A 05 00 00 8A 04 00 04 8A 03 00 08 8A 02 00 0C 9A 05 00 03 9A 04 00 07 9A 03 00 0B 9A 02 00 0F AF A5 00 28 A7 B1 00 20 AF A4 00 2C AF A3 00 30 AF A2 00 34 24 05 00 1C 3C 02 ?? ?? 24 42 ?? ?? AF B4 00 10 27 A4 00 20 02 60 30 21 02 40 38 21 0? ?? ?? ?? AF A2 00 14 8F BF 00 B4 8F B4 00 B0 8F B3 00 AC 8F B2 00 A8 8F B1 00 A4 8F B0 00 A0 03 E0 00 08 27 BD 00 B8 8F B4 00 B0 8F B3 00 AC 8F B2 00 A8 8F B1 00 A4 8F B0 00 A0 00 00 10 21 03 E0 00 08 27 BD 00 B8 8A 02 00 00 A7 B1 00 20 24 05 00 10 9A 02 00 03 0? ?? ?? ?? AF A2 00 24 }
	condition:
		$1
}

rule file_253_10_0 {
	meta:
		name = "iruserok"
		size = 40
		refs = "0014 iruserok_af"
	strings:
		$1 = { 27 BD FF D8 24 02 00 02 AF A4 00 28 AF A2 00 10 AF BF 00 24 0? ?? ?? ?? 27 A4 00 28 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_253_11_0 {
	meta:
		name = "__ivaliduser"
		size = 80
		refs = "0000 $LC30"
	strings:
		$1 = { 3C 03 ?? ?? 27 BD FF C8 00 C0 10 21 24 63 ?? ?? 24 06 00 10 AF A5 00 24 AF A7 00 10 AF A3 00 14 27 A5 00 20 00 40 38 21 24 02 00 02 AF BF 00 34 AF A0 00 20 AF A0 00 28 AF A0 00 2C 0? ?? ?? ?? A7 A2 00 20 8F BF 00 34 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_254_1_0 {
	meta:
		name = "hsearch"
		size = 52
		refs = "001c hsearch_r"
	strings:
		$1 = { 3C 02 ?? ?? 27 BD FF D0 24 42 ?? ?? 27 A7 00 20 AF A2 00 10 AF BF 00 2C AF A4 00 30 0? ?? ?? ?? AF A5 00 34 8F BF 00 2C 8F A2 00 20 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_255_0_0 {
	meta:
		name = "psiginfo"
		size = 1184
		refs = "0004 __gnu_local_gp 0038 fmemopen 0008 $LC11 0068 _sys_siglist 0080 _libc_intl_domainname 0088 __dcgettext 0090 $LC25 009c fprintf 00f4 $LC2 016c $LC18 01b8 $LC23 01d4 $LC24 01f8 _IO_new_fclose 0200 strlen 0228 __libc_errno 0058 $LC13 0288 $LC6 0294 $LC19 02b0 $LC20 02d8 $LC0 02dc $LC1 02f8 __fxprintf 02e8 $LC12 0328 $LC3 0340 $LC4 034c $LC22 0364 __libc_current_sigrtmin 0378 __libc_current_sigrtmax 03c8 $LC15 0400 $LC17 041c $LC8 0428 $LC10 0434 $LC5 00e0 $LC7 0448 $LC9 0460 $LC21 03bc $LC14 0488 fwrite 03f0 $LC16"
	strings:
		$1 = { 27 BD FD C8 3C 1C ?? ?? 3C 06 ?? ?? 27 9C ?? ?? AF B2 02 2C AF B1 02 28 00 A0 90 21 00 80 88 21 24 05 02 00 27 A4 00 20 AF B0 02 24 AF BF 02 34 AF B3 02 30 AF BC 00 18 0? ?? ?? ?? 24 C6 ?? ?? 10 40 00 A1 00 40 80 21 12 40 00 04 00 00 00 00 82 42 00 00 14 40 00 7E 3C 05 ?? ?? 8E 32 00 00 2E 42 00 80 10 40 00 5A 3C 03 ?? ?? 00 12 10 80 24 63 ?? ?? 00 43 10 21 8C 45 00 00 10 A0 00 B9 3C 04 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 24 06 00 05 3C 05 ?? ?? 02 00 20 21 24 A5 ?? ?? 0? ?? ?? ?? 00 40 30 21 8E 22 00 00 24 42 FF FC 2C 43 00 13 14 60 00 13 3C 03 ?? ?? 8E 26 00 04 24 02 FF FD 10 C2 00 D6 28 C2 FF FE 14 40 00 67 24 02 FF FA 24 02 FF FF 10 C2 00 DC 28 C2 FF FF 14 40 00 D8 3C 05 ?? ?? 10 C0 00 D0 24 02 00 80 14 C2 00 69 00 00 00 00 3C 05 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 00 02 10 80 24 63 ?? ?? 00 43 18 21 3C 04 ?? ?? 3C 05 ?? ?? 8C 63 00 00 24 84 ?? ?? 24 A5 ?? ?? 00 44 20 21 00 45 10 21 8C 84 00 00 10 60 FF E2 8C 42 00 00 8E 26 00 04 18 C0 FF E0 00 46 10 2B 14 40 FF DF 24 02 FF FD 00 66 18 21 90 65 FF FF 00 85 28 21 10 A0 00 4F 00 00 00 00 3C 04 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 24 06 00 05 3C 05 ?? ?? 02 00 20 21 24 A5 ?? ?? 0? ?? ?? ?? 00 40 30 21 8E 22 00 00 24 03 00 04 10 43 00 48 24 03 00 08 10 43 00 46 24 43 FF F6 2C 63 00 02 14 60 00 43 24 03 00 12 10 43 00 AB 24 03 00 16 10 43 00 67 8E 26 00 0C 8E 27 00 10 3C 05 ?? ?? 02 00 20 21 0? ?? ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 00 00 00 00 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 8E 26 00 00 02 00 20 21 0? ?? ?? ?? 00 40 28 21 0? ?? ?? ?? 02 00 20 21 0? ?? ?? ?? 27 A4 00 20 00 40 30 21 8F BC 00 18 24 02 0F A4 00 00 00 0C 10 E0 00 07 8F BF 02 34 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 64 20 21 AC 82 00 00 8F BF 02 34 8F B3 02 30 8F B2 02 2C 8F B1 02 28 8F B0 02 24 03 E0 00 08 27 BD 02 38 02 00 20 21 24 A5 ?? ?? 0? ?? ?? ?? 02 40 30 21 0? ?? ?? ?? 8E 32 00 00 10 C2 00 72 28 C2 FF FB 14 40 00 30 24 02 FF FB 10 C2 00 2B 24 02 FF FC 14 C2 00 04 00 00 00 00 3C 05 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 3C 05 ?? ?? 02 00 20 21 0? ?? ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 8E 22 00 00 8E 26 00 0C 3C 05 ?? ?? 02 00 20 21 0? ?? ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 00 00 00 00 12 40 00 14 3C 07 ?? ?? 82 42 00 00 10 40 00 12 24 E7 ?? ?? 3C 07 ?? ?? 24 E7 ?? ?? 8E 22 00 00 3C 05 ?? ?? 02 40 30 21 00 00 20 21 AF A2 00 10 0? ?? ?? ?? 24 A5 ?? ?? 8F BF 02 34 8F B3 02 30 8F B2 02 2C 8F B1 02 28 8F B0 02 24 03 E0 00 08 27 BD 02 38 24 E7 ?? ?? 0? ?? ?? ?? 00 E0 90 21 3C 05 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 24 02 FF C4 14 C2 FF D6 00 00 00 00 3C 05 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 3C 05 ?? ?? 02 00 20 21 0? ?? ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 00 00 00 00 02 42 10 2A 14 40 FF 98 3C 04 ?? ?? 0? ?? ?? ?? 8E 32 00 00 02 42 10 2A 10 40 FF 93 3C 04 ?? ?? 0? ?? ?? ?? 8E 33 00 00 0? ?? ?? ?? 02 62 98 23 8E 32 00 00 00 52 10 23 02 62 98 2A 12 60 00 0E 00 00 00 00 0? ?? ?? ?? 00 00 00 00 12 42 00 30 3C 04 ?? ?? 0? ?? ?? ?? 8E 32 00 00 3C 05 ?? ?? 02 00 20 21 24 A5 ?? ?? 0? ?? ?? ?? 02 42 30 23 0? ?? ?? ?? 8E 22 00 00 0? ?? ?? ?? 00 00 00 00 12 42 00 2A 3C 04 ?? ?? 0? ?? ?? ?? 00 00 00 00 8E 26 00 00 3C 05 ?? ?? 02 00 20 21 24 A5 ?? ?? 0? ?? ?? ?? 00 46 30 23 0? ?? ?? ?? 8E 22 00 00 3C 05 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 3C 05 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 3C 05 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 3C 05 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 8E 22 00 10 8E 26 00 0C 8E 27 00 14 3C 05 ?? ?? 02 00 20 21 AF A2 00 10 0? ?? ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 00 00 00 00 24 84 ?? ?? 24 05 00 01 24 06 00 0A 0? ?? ?? ?? 02 00 38 21 0? ?? ?? ?? 8E 22 00 00 0? ?? ?? ?? 24 84 ?? ?? }
	condition:
		$1
}

rule file_256_0_0 {
	meta:
		name = "__strndup"
		size = 100
		refs = "0010 __strnlen 001c malloc 0048 memcpy"
	strings:
		$1 = { 27 BD FF D8 AF BF 00 24 AF B1 00 20 AF B0 00 1C 0? ?? ?? ?? 00 80 88 21 24 44 00 01 0? ?? ?? ?? 00 40 80 21 10 40 00 0A 00 40 20 21 00 50 10 21 A0 40 00 00 8F BF 00 24 02 20 28 21 02 00 30 21 8F B1 00 20 8F B0 00 1C 0? ?? ?? ?? 27 BD 00 28 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_257_0_0 {
	meta:
		name = "__libc_init_first"
		size = 164
		refs = "0000 _dl_starting_up 0038 __fpu_control 0044 __setfpucw 0040 __libc_multiple_libcs 004c __libc_argc 0054 __libc_argv 0060 __libc_init_secure 005c __environ 0068 _dl_non_dynamic_init 0078 __init_misc 0090 __ctype_init"
	strings:
		$1 = { 3C 02 ?? ?? 27 BD FF D8 24 43 ?? ?? AF B2 00 20 AF B1 00 1C AF B0 00 18 AF BF 00 24 00 80 80 21 00 A0 88 21 10 60 00 04 00 C0 90 21 8C 42 ?? ?? 10 40 00 19 24 03 00 01 3C 02 ?? ?? 8C 44 ?? ?? 3C 02 ?? ?? 0? ?? ?? ?? AC 40 ?? ?? 3C 02 ?? ?? AC 50 ?? ?? 3C 02 ?? ?? AC 51 ?? ?? 3C 02 ?? ?? 0? ?? ?? ?? AC 52 ?? ?? 0? ?? ?? ?? 00 00 00 00 02 00 20 21 02 20 28 21 0? ?? ?? ?? 02 40 30 21 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 0? ?? ?? ?? 27 BD 00 28 3C 02 ?? ?? 0? ?? ?? ?? AC 43 ?? ?? }
	condition:
		$1
}

rule file_258_0_0 {
	meta:
		name = "getspnam"
		size = 452
		refs = "0004 __gnu_local_gp 00a0 __getspnam_r 00c0 realloc 00d0 free 00e4 __libc_errno 0174 malloc 01b4 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF B0 3C 1C ?? ?? AF B7 00 44 3C 17 ?? ?? AF B3 00 34 27 9C ?? ?? 00 80 98 21 26 E3 ?? ?? AF BF 00 4C AF BE 00 48 AF B6 00 40 AF B5 00 3C AF B4 00 38 AF B2 00 30 AF B1 00 2C AF B0 00 28 AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 55 00 00 00 00 3C 12 ?? ?? 8E 46 ?? ?? 3C 11 ?? ?? 10 C0 00 3E 8E 27 ?? ?? 3C 15 ?? ?? 26 B5 ?? ?? 24 14 00 22 0? ?? ?? ?? 3C 16 ?? ?? AE C2 ?? ?? 02 00 38 21 27 A2 00 20 02 60 20 21 02 A0 28 21 0? ?? ?? ?? AF A2 00 10 14 54 00 16 8E 30 ?? ?? 8E 5E ?? ?? 00 10 80 40 03 C0 20 21 02 00 28 21 0? ?? ?? ?? AE 30 ?? ?? 14 40 FF F0 00 40 30 21 0? ?? ?? ?? 03 C0 20 21 8F BC 00 18 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 0C AC 43 00 00 3C 02 ?? ?? AC 40 ?? ?? 0? ?? ?? ?? AF A0 00 20 8E 42 ?? ?? 10 40 FF FC 00 00 00 00 26 E3 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 17 26 E4 ?? ?? 8F BF 00 4C 8F A2 00 20 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 24 02 04 00 24 04 04 00 0? ?? ?? ?? AE 22 ?? ?? 10 40 FF DF AE 42 ?? ?? 00 40 30 21 0? ?? ?? ?? 24 07 04 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 4C 0? ?? ?? ?? 26 E4 ?? ?? 0? ?? ?? ?? 3C 12 ?? ?? }
	condition:
		$1
}

rule file_1347_0_0 {
	meta:
		name = "getaliasbyname"
		size = 452
		refs = "0004 __gnu_local_gp 00a0 __getaliasbyname_r 00c0 realloc 00d0 free 00e4 __libc_errno 0174 malloc 01b4 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF B0 3C 1C ?? ?? AF B7 00 44 3C 17 ?? ?? AF B3 00 34 27 9C ?? ?? 00 80 98 21 26 E3 ?? ?? AF BF 00 4C AF BE 00 48 AF B6 00 40 AF B5 00 3C AF B4 00 38 AF B2 00 30 AF B1 00 2C AF B0 00 28 AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 55 00 00 00 00 3C 12 ?? ?? 8E 46 ?? ?? 3C 11 ?? ?? 10 C0 00 3E 8E 27 ?? ?? 3C 15 ?? ?? 26 B5 ?? ?? 24 14 00 22 0? ?? ?? ?? 3C 16 ?? ?? AE C2 ?? ?? 02 00 38 21 27 A2 00 20 02 60 20 21 02 A0 28 21 0? ?? ?? ?? AF A2 00 10 14 54 00 16 8E 30 ?? ?? 8E 5E ?? ?? 00 10 80 40 03 C0 20 21 02 00 28 21 0? ?? ?? ?? AE 30 ?? ?? 14 40 FF F0 00 40 30 21 0? ?? ?? ?? 03 C0 20 21 8F BC 00 18 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 0C AC 43 00 00 3C 02 ?? ?? AC 40 ?? ?? 0? ?? ?? ?? AF A0 00 20 8E 42 ?? ?? 10 40 FF FC 00 00 00 00 26 E3 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 17 26 E4 ?? ?? 8F BF 00 4C 8F A2 00 20 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 24 02 04 00 24 04 04 00 0? ?? ?? ?? AE 22 ?? ?? 10 40 FF DF AE 42 ?? ?? 00 40 30 21 0? ?? ?? ?? 24 07 04 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 4C 0? ?? ?? ?? 26 E4 ?? ?? 0? ?? ?? ?? 3C 12 ?? ?? }
	condition:
		$1
}

rule file_1025_0_0 {
	meta:
		name = "getgrgid"
		size = 452
		refs = "0004 __gnu_local_gp 00a0 __getgrgid_r 00c0 realloc 00d0 free 00e4 __libc_errno 0174 malloc 01b4 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF B0 3C 1C ?? ?? AF B7 00 44 3C 17 ?? ?? AF B3 00 34 27 9C ?? ?? 00 80 98 21 26 E3 ?? ?? AF BF 00 4C AF BE 00 48 AF B6 00 40 AF B5 00 3C AF B4 00 38 AF B2 00 30 AF B1 00 2C AF B0 00 28 AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 55 00 00 00 00 3C 12 ?? ?? 8E 46 ?? ?? 3C 11 ?? ?? 10 C0 00 3E 8E 27 ?? ?? 3C 15 ?? ?? 26 B5 ?? ?? 24 14 00 22 0? ?? ?? ?? 3C 16 ?? ?? AE C2 ?? ?? 02 00 38 21 27 A2 00 20 02 60 20 21 02 A0 28 21 0? ?? ?? ?? AF A2 00 10 14 54 00 16 8E 30 ?? ?? 8E 5E ?? ?? 00 10 80 40 03 C0 20 21 02 00 28 21 0? ?? ?? ?? AE 30 ?? ?? 14 40 FF F0 00 40 30 21 0? ?? ?? ?? 03 C0 20 21 8F BC 00 18 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 0C AC 43 00 00 3C 02 ?? ?? AC 40 ?? ?? 0? ?? ?? ?? AF A0 00 20 8E 42 ?? ?? 10 40 FF FC 00 00 00 00 26 E3 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 17 26 E4 ?? ?? 8F BF 00 4C 8F A2 00 20 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 24 02 04 00 24 04 04 00 0? ?? ?? ?? AE 22 ?? ?? 10 40 FF DF AE 42 ?? ?? 00 40 30 21 0? ?? ?? ?? 24 07 04 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 4C 0? ?? ?? ?? 26 E4 ?? ?? 0? ?? ?? ?? 3C 12 ?? ?? }
	condition:
		$1
}

rule file_516_0_0 {
	meta:
		name = "getgrnam"
		size = 452
		refs = "0004 __gnu_local_gp 00a0 __getgrnam_r 00c0 realloc 00d0 free 00e4 __libc_errno 0174 malloc 01b4 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF B0 3C 1C ?? ?? AF B7 00 44 3C 17 ?? ?? AF B3 00 34 27 9C ?? ?? 00 80 98 21 26 E3 ?? ?? AF BF 00 4C AF BE 00 48 AF B6 00 40 AF B5 00 3C AF B4 00 38 AF B2 00 30 AF B1 00 2C AF B0 00 28 AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 55 00 00 00 00 3C 12 ?? ?? 8E 46 ?? ?? 3C 11 ?? ?? 10 C0 00 3E 8E 27 ?? ?? 3C 15 ?? ?? 26 B5 ?? ?? 24 14 00 22 0? ?? ?? ?? 3C 16 ?? ?? AE C2 ?? ?? 02 00 38 21 27 A2 00 20 02 60 20 21 02 A0 28 21 0? ?? ?? ?? AF A2 00 10 14 54 00 16 8E 30 ?? ?? 8E 5E ?? ?? 00 10 80 40 03 C0 20 21 02 00 28 21 0? ?? ?? ?? AE 30 ?? ?? 14 40 FF F0 00 40 30 21 0? ?? ?? ?? 03 C0 20 21 8F BC 00 18 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 0C AC 43 00 00 3C 02 ?? ?? AC 40 ?? ?? 0? ?? ?? ?? AF A0 00 20 8E 42 ?? ?? 10 40 FF FC 00 00 00 00 26 E3 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 17 26 E4 ?? ?? 8F BF 00 4C 8F A2 00 20 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 24 02 04 00 24 04 04 00 0? ?? ?? ?? AE 22 ?? ?? 10 40 FF DF AE 42 ?? ?? 00 40 30 21 0? ?? ?? ?? 24 07 04 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 4C 0? ?? ?? ?? 26 E4 ?? ?? 0? ?? ?? ?? 3C 12 ?? ?? }
	condition:
		$1
}

rule file_434_0_0 {
	meta:
		name = "getprotobyname"
		size = 452
		refs = "0004 __gnu_local_gp 00a0 __getprotobyname_r 00c0 realloc 00d0 free 00e4 __libc_errno 0174 malloc 01b4 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF B0 3C 1C ?? ?? AF B7 00 44 3C 17 ?? ?? AF B3 00 34 27 9C ?? ?? 00 80 98 21 26 E3 ?? ?? AF BF 00 4C AF BE 00 48 AF B6 00 40 AF B5 00 3C AF B4 00 38 AF B2 00 30 AF B1 00 2C AF B0 00 28 AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 55 00 00 00 00 3C 12 ?? ?? 8E 46 ?? ?? 3C 11 ?? ?? 10 C0 00 3E 8E 27 ?? ?? 3C 15 ?? ?? 26 B5 ?? ?? 24 14 00 22 0? ?? ?? ?? 3C 16 ?? ?? AE C2 ?? ?? 02 00 38 21 27 A2 00 20 02 60 20 21 02 A0 28 21 0? ?? ?? ?? AF A2 00 10 14 54 00 16 8E 30 ?? ?? 8E 5E ?? ?? 00 10 80 40 03 C0 20 21 02 00 28 21 0? ?? ?? ?? AE 30 ?? ?? 14 40 FF F0 00 40 30 21 0? ?? ?? ?? 03 C0 20 21 8F BC 00 18 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 0C AC 43 00 00 3C 02 ?? ?? AC 40 ?? ?? 0? ?? ?? ?? AF A0 00 20 8E 42 ?? ?? 10 40 FF FC 00 00 00 00 26 E3 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 17 26 E4 ?? ?? 8F BF 00 4C 8F A2 00 20 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 24 02 04 00 24 04 04 00 0? ?? ?? ?? AE 22 ?? ?? 10 40 FF DF AE 42 ?? ?? 00 40 30 21 0? ?? ?? ?? 24 07 04 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 4C 0? ?? ?? ?? 26 E4 ?? ?? 0? ?? ?? ?? 3C 12 ?? ?? }
	condition:
		$1
}

rule file_1446_0_0 {
	meta:
		name = "getprotobynumber"
		size = 452
		refs = "0004 __gnu_local_gp 00a0 __getprotobynumber_r 00c0 realloc 00d0 free 00e4 __libc_errno 0174 malloc 01b4 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF B0 3C 1C ?? ?? AF B7 00 44 3C 17 ?? ?? AF B3 00 34 27 9C ?? ?? 00 80 98 21 26 E3 ?? ?? AF BF 00 4C AF BE 00 48 AF B6 00 40 AF B5 00 3C AF B4 00 38 AF B2 00 30 AF B1 00 2C AF B0 00 28 AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 55 00 00 00 00 3C 12 ?? ?? 8E 46 ?? ?? 3C 11 ?? ?? 10 C0 00 3E 8E 27 ?? ?? 3C 15 ?? ?? 26 B5 ?? ?? 24 14 00 22 0? ?? ?? ?? 3C 16 ?? ?? AE C2 ?? ?? 02 00 38 21 27 A2 00 20 02 60 20 21 02 A0 28 21 0? ?? ?? ?? AF A2 00 10 14 54 00 16 8E 30 ?? ?? 8E 5E ?? ?? 00 10 80 40 03 C0 20 21 02 00 28 21 0? ?? ?? ?? AE 30 ?? ?? 14 40 FF F0 00 40 30 21 0? ?? ?? ?? 03 C0 20 21 8F BC 00 18 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 0C AC 43 00 00 3C 02 ?? ?? AC 40 ?? ?? 0? ?? ?? ?? AF A0 00 20 8E 42 ?? ?? 10 40 FF FC 00 00 00 00 26 E3 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 17 26 E4 ?? ?? 8F BF 00 4C 8F A2 00 20 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 24 02 04 00 24 04 04 00 0? ?? ?? ?? AE 22 ?? ?? 10 40 FF DF AE 42 ?? ?? 00 40 30 21 0? ?? ?? ?? 24 07 04 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 4C 0? ?? ?? ?? 26 E4 ?? ?? 0? ?? ?? ?? 3C 12 ?? ?? }
	condition:
		$1
}

rule file_304_0_0 {
	meta:
		name = "getpwnam"
		size = 452
		refs = "0004 __gnu_local_gp 00a0 __getpwnam_r 00c0 realloc 00d0 free 00e4 __libc_errno 0174 malloc 01b4 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF B0 3C 1C ?? ?? AF B7 00 44 3C 17 ?? ?? AF B3 00 34 27 9C ?? ?? 00 80 98 21 26 E3 ?? ?? AF BF 00 4C AF BE 00 48 AF B6 00 40 AF B5 00 3C AF B4 00 38 AF B2 00 30 AF B1 00 2C AF B0 00 28 AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 55 00 00 00 00 3C 12 ?? ?? 8E 46 ?? ?? 3C 11 ?? ?? 10 C0 00 3E 8E 27 ?? ?? 3C 15 ?? ?? 26 B5 ?? ?? 24 14 00 22 0? ?? ?? ?? 3C 16 ?? ?? AE C2 ?? ?? 02 00 38 21 27 A2 00 20 02 60 20 21 02 A0 28 21 0? ?? ?? ?? AF A2 00 10 14 54 00 16 8E 30 ?? ?? 8E 5E ?? ?? 00 10 80 40 03 C0 20 21 02 00 28 21 0? ?? ?? ?? AE 30 ?? ?? 14 40 FF F0 00 40 30 21 0? ?? ?? ?? 03 C0 20 21 8F BC 00 18 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 0C AC 43 00 00 3C 02 ?? ?? AC 40 ?? ?? 0? ?? ?? ?? AF A0 00 20 8E 42 ?? ?? 10 40 FF FC 00 00 00 00 26 E3 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 17 26 E4 ?? ?? 8F BF 00 4C 8F A2 00 20 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 24 02 04 00 24 04 04 00 0? ?? ?? ?? AE 22 ?? ?? 10 40 FF DF AE 42 ?? ?? 00 40 30 21 0? ?? ?? ?? 24 07 04 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 4C 0? ?? ?? ?? 26 E4 ?? ?? 0? ?? ?? ?? 3C 12 ?? ?? }
	condition:
		$1
}

rule file_1077_0_0 {
	meta:
		name = "getpwuid"
		size = 452
		refs = "0004 __gnu_local_gp 00a0 __getpwuid_r 00c0 realloc 00d0 free 00e4 __libc_errno 0174 malloc 01b4 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF B0 3C 1C ?? ?? AF B7 00 44 3C 17 ?? ?? AF B3 00 34 27 9C ?? ?? 00 80 98 21 26 E3 ?? ?? AF BF 00 4C AF BE 00 48 AF B6 00 40 AF B5 00 3C AF B4 00 38 AF B2 00 30 AF B1 00 2C AF B0 00 28 AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 55 00 00 00 00 3C 12 ?? ?? 8E 46 ?? ?? 3C 11 ?? ?? 10 C0 00 3E 8E 27 ?? ?? 3C 15 ?? ?? 26 B5 ?? ?? 24 14 00 22 0? ?? ?? ?? 3C 16 ?? ?? AE C2 ?? ?? 02 00 38 21 27 A2 00 20 02 60 20 21 02 A0 28 21 0? ?? ?? ?? AF A2 00 10 14 54 00 16 8E 30 ?? ?? 8E 5E ?? ?? 00 10 80 40 03 C0 20 21 02 00 28 21 0? ?? ?? ?? AE 30 ?? ?? 14 40 FF F0 00 40 30 21 0? ?? ?? ?? 03 C0 20 21 8F BC 00 18 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 0C AC 43 00 00 3C 02 ?? ?? AC 40 ?? ?? 0? ?? ?? ?? AF A0 00 20 8E 42 ?? ?? 10 40 FF FC 00 00 00 00 26 E3 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 17 26 E4 ?? ?? 8F BF 00 4C 8F A2 00 20 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 24 02 04 00 24 04 04 00 0? ?? ?? ?? AE 22 ?? ?? 10 40 FF DF AE 42 ?? ?? 00 40 30 21 0? ?? ?? ?? 24 07 04 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 4C 0? ?? ?? ?? 26 E4 ?? ?? 0? ?? ?? ?? 3C 12 ?? ?? }
	condition:
		$1
}

rule file_353_0_0 {
	meta:
		name = "getrpcbyname"
		size = 452
		refs = "0004 __gnu_local_gp 00a0 __getrpcbyname_r 00c0 realloc 00d0 free 00e4 __libc_errno 0174 malloc 01b4 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF B0 3C 1C ?? ?? AF B7 00 44 3C 17 ?? ?? AF B3 00 34 27 9C ?? ?? 00 80 98 21 26 E3 ?? ?? AF BF 00 4C AF BE 00 48 AF B6 00 40 AF B5 00 3C AF B4 00 38 AF B2 00 30 AF B1 00 2C AF B0 00 28 AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 55 00 00 00 00 3C 12 ?? ?? 8E 46 ?? ?? 3C 11 ?? ?? 10 C0 00 3E 8E 27 ?? ?? 3C 15 ?? ?? 26 B5 ?? ?? 24 14 00 22 0? ?? ?? ?? 3C 16 ?? ?? AE C2 ?? ?? 02 00 38 21 27 A2 00 20 02 60 20 21 02 A0 28 21 0? ?? ?? ?? AF A2 00 10 14 54 00 16 8E 30 ?? ?? 8E 5E ?? ?? 00 10 80 40 03 C0 20 21 02 00 28 21 0? ?? ?? ?? AE 30 ?? ?? 14 40 FF F0 00 40 30 21 0? ?? ?? ?? 03 C0 20 21 8F BC 00 18 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 0C AC 43 00 00 3C 02 ?? ?? AC 40 ?? ?? 0? ?? ?? ?? AF A0 00 20 8E 42 ?? ?? 10 40 FF FC 00 00 00 00 26 E3 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 17 26 E4 ?? ?? 8F BF 00 4C 8F A2 00 20 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 24 02 04 00 24 04 04 00 0? ?? ?? ?? AE 22 ?? ?? 10 40 FF DF AE 42 ?? ?? 00 40 30 21 0? ?? ?? ?? 24 07 04 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 4C 0? ?? ?? ?? 26 E4 ?? ?? 0? ?? ?? ?? 3C 12 ?? ?? }
	condition:
		$1
}

rule file_530_0_0 {
	meta:
		name = "getrpcbynumber"
		size = 452
		refs = "0004 __gnu_local_gp 00a0 __getrpcbynumber_r 00c0 realloc 00d0 free 00e4 __libc_errno 0174 malloc 01b4 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF B0 3C 1C ?? ?? AF B7 00 44 3C 17 ?? ?? AF B3 00 34 27 9C ?? ?? 00 80 98 21 26 E3 ?? ?? AF BF 00 4C AF BE 00 48 AF B6 00 40 AF B5 00 3C AF B4 00 38 AF B2 00 30 AF B1 00 2C AF B0 00 28 AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 55 00 00 00 00 3C 12 ?? ?? 8E 46 ?? ?? 3C 11 ?? ?? 10 C0 00 3E 8E 27 ?? ?? 3C 15 ?? ?? 26 B5 ?? ?? 24 14 00 22 0? ?? ?? ?? 3C 16 ?? ?? AE C2 ?? ?? 02 00 38 21 27 A2 00 20 02 60 20 21 02 A0 28 21 0? ?? ?? ?? AF A2 00 10 14 54 00 16 8E 30 ?? ?? 8E 5E ?? ?? 00 10 80 40 03 C0 20 21 02 00 28 21 0? ?? ?? ?? AE 30 ?? ?? 14 40 FF F0 00 40 30 21 0? ?? ?? ?? 03 C0 20 21 8F BC 00 18 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 0C AC 43 00 00 3C 02 ?? ?? AC 40 ?? ?? 0? ?? ?? ?? AF A0 00 20 8E 42 ?? ?? 10 40 FF FC 00 00 00 00 26 E3 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 17 26 E4 ?? ?? 8F BF 00 4C 8F A2 00 20 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 24 02 04 00 24 04 04 00 0? ?? ?? ?? AE 22 ?? ?? 10 40 FF DF AE 42 ?? ?? 00 40 30 21 0? ?? ?? ?? 24 07 04 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 4C 0? ?? ?? ?? 26 E4 ?? ?? 0? ?? ?? ?? 3C 12 ?? ?? }
	condition:
		$1
}

rule file_498_0_0 {
	meta:
		name = "getsgnam"
		size = 452
		refs = "0004 __gnu_local_gp 00a0 __getsgnam_r 00c0 realloc 00d0 free 00e4 __libc_errno 0174 malloc 01b4 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF B0 3C 1C ?? ?? AF B7 00 44 3C 17 ?? ?? AF B3 00 34 27 9C ?? ?? 00 80 98 21 26 E3 ?? ?? AF BF 00 4C AF BE 00 48 AF B6 00 40 AF B5 00 3C AF B4 00 38 AF B2 00 30 AF B1 00 2C AF B0 00 28 AF BC 00 18 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 55 00 00 00 00 3C 12 ?? ?? 8E 46 ?? ?? 3C 11 ?? ?? 10 C0 00 3E 8E 27 ?? ?? 3C 15 ?? ?? 26 B5 ?? ?? 24 14 00 22 0? ?? ?? ?? 3C 16 ?? ?? AE C2 ?? ?? 02 00 38 21 27 A2 00 20 02 60 20 21 02 A0 28 21 0? ?? ?? ?? AF A2 00 10 14 54 00 16 8E 30 ?? ?? 8E 5E ?? ?? 00 10 80 40 03 C0 20 21 02 00 28 21 0? ?? ?? ?? AE 30 ?? ?? 14 40 FF F0 00 40 30 21 0? ?? ?? ?? 03 C0 20 21 8F BC 00 18 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 0C AC 43 00 00 3C 02 ?? ?? AC 40 ?? ?? 0? ?? ?? ?? AF A0 00 20 8E 42 ?? ?? 10 40 FF FC 00 00 00 00 26 E3 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 17 26 E4 ?? ?? 8F BF 00 4C 8F A2 00 20 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 24 02 04 00 24 04 04 00 0? ?? ?? ?? AE 22 ?? ?? 10 40 FF DF AE 42 ?? ?? 00 40 30 21 0? ?? ?? ?? 24 07 04 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 4C 0? ?? ?? ?? 26 E4 ?? ?? 0? ?? ?? ?? 3C 12 ?? ?? }
	condition:
		$1
}

rule file_259_0_0 {
	meta:
		name = "timerfd_settime"
		size = 28
	strings:
		$1 = { 24 02 10 E3 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_260_0_0 {
	meta:
		name = "init_module"
		size = 28
	strings:
		$1 = { 24 02 10 20 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_261_0_0 {
	meta:
		name = "print_errno_message"
		size = 52
		refs = "000c __strerror_r 0014 $LC0 0020 __fxprintf"
	strings:
		$1 = { 27 BD FB E0 27 A5 00 18 AF BF 04 1C 0? ?? ?? ?? 24 06 04 00 3C 05 ?? ?? 00 00 20 21 24 A5 ?? ?? 0? ?? ?? ?? 00 40 30 21 8F BF 04 1C 03 E0 00 08 27 BD 04 20 }
	condition:
		$1
}

rule file_261_1_0 {
	meta:
		name = "error_tail"
		size = 580
		refs = "0008 stderr 0050 strlen 00bc __mbsrtowcs 00d8 __vfwprintf 00e8 free 00f0 error_message_count 010c __fxprintf 0194 $LC2 0114 _IO_fflush 0168 $LC3 01a0 vfprintf 01c0 __libc_alloca_cutoff 01d4 realloc 0200 fputws_unlocked 01fc $LC1 023c exit"
	strings:
		$1 = { 27 BD FF A8 AF B5 00 44 3C 15 ?? ?? 8E A2 ?? ?? AF BE 00 50 03 A0 F0 21 8C 43 00 6C AF B6 00 48 AF B1 00 34 AF BF 00 54 AF B7 00 4C AF B4 00 40 AF B3 00 3C AF B2 00 38 AF B0 00 30 AF C4 00 58 00 A0 B0 21 00 C0 88 21 18 60 00 53 AF C7 00 64 0? ?? ?? ?? 00 C0 20 21 3C 13 7F FF 24 50 00 01 00 00 A0 21 00 00 B8 21 34 12 80 01 0? ?? ?? ?? 36 73 FF FF 02 13 10 2B 10 40 00 37 00 10 80 40 00 10 28 80 00 B2 10 2B 10 40 00 4D 00 A0 20 21 24 A3 00 0E 00 03 18 C2 00 03 18 C0 03 A3 E8 23 27 B7 00 10 02 E0 20 21 27 C5 00 20 02 00 30 21 27 C7 00 18 AF C0 00 18 AF C0 00 1C 0? ?? ?? ?? AF D1 00 20 12 02 FF EB 24 03 FF FF 10 43 00 22 8E A4 ?? ?? 8F C6 00 64 0? ?? ?? ?? 02 E0 28 21 12 80 00 04 3C 02 ?? ?? 0? ?? ?? ?? 02 E0 20 21 3C 02 ?? ?? 8C 43 ?? ?? 24 63 00 01 16 C0 00 22 AC 43 ?? ?? 3C 05 ?? ?? 00 00 20 21 0? ?? ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 8E A4 ?? ?? 8F C2 00 58 14 40 00 46 8F DF 00 54 03 C0 E8 21 8F BE 00 50 8F B7 00 4C 8F B6 00 48 8F B5 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 58 16 80 00 15 00 00 00 00 8E A4 ?? ?? 8F C6 00 64 3C 05 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 3C 02 ?? ?? 8C 43 ?? ?? 24 63 00 01 12 C0 FF E0 AC 43 ?? ?? 0? ?? ?? ?? 02 C0 20 21 0? ?? ?? ?? 3C 05 ?? ?? 00 C0 28 21 00 40 20 21 0? ?? ?? ?? 00 E0 30 21 0? ?? ?? ?? 3C 02 ?? ?? 0? ?? ?? ?? 02 E0 20 21 0? ?? ?? ?? 8E A4 ?? ?? 0? ?? ?? ?? AF C5 00 28 14 40 FF B1 8F C5 00 28 00 14 B8 0A 0? ?? ?? ?? 02 E0 20 21 02 E0 A0 21 10 40 00 03 00 40 B8 21 0? ?? ?? ?? 24 14 00 01 0? ?? ?? ?? 02 80 20 21 8E A5 ?? ?? 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 03 C0 E8 21 8F BF 00 54 8F BE 00 50 8F B7 00 4C 8F B6 00 48 8F B5 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 58 0? ?? ?? ?? 00 40 20 21 }
	condition:
		$1
}

rule file_261_2_0 {
	meta:
		name = "__error"
		size = 204
		refs = "0008 pthread_setcancelstate 0048 _IO_fflush 0044 stdout 0050 error_print_progname 005c program_invocation_name 00bc __fxprintf 00b4 $LC4"
	strings:
		$1 = { 27 BD FF C8 AF B0 00 24 3C 10 ?? ?? 26 10 ?? ?? AF B3 00 30 AF B2 00 2C AF B1 00 28 AF BF 00 34 00 80 98 21 00 A0 90 21 AF A7 00 44 00 C0 88 21 12 00 00 04 AF A0 00 18 24 04 00 01 0? ?? ?? ?? 27 A5 00 18 3C 02 ?? ?? 0? ?? ?? ?? 8C 44 ?? ?? 3C 02 ?? ?? 8C 59 ?? ?? 13 20 00 15 3C 02 ?? ?? 03 20 F8 09 00 00 00 00 27 A2 00 44 02 60 20 21 02 40 28 21 02 20 30 21 00 40 38 21 0? ?? ?? ?? AF A2 00 1C 12 00 00 03 8F A4 00 18 0? ?? ?? ?? 00 00 28 21 8F BF 00 34 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 38 8C 46 ?? ?? 3C 05 ?? ?? 00 00 20 21 0? ?? ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 27 A2 00 44 }
	condition:
		$1
}

rule file_261_3_0 {
	meta:
		name = "__error_at_line"
		size = 348
		refs = "0000 error_one_per_line 0054 pthread_setcancelstate 0074 _IO_fflush 0070 stdout 007c error_print_progname 009c $LC5 00ac __fxprintf 0120 strcmp 0098 $LC6 0088 program_invocation_name 0144 $LC7"
	strings:
		$1 = { 3C 02 ?? ?? 8C 42 ?? ?? 27 BD FF C0 AF B4 00 34 AF B3 00 30 AF B1 00 28 AF B0 00 24 AF BF 00 3C AF B5 00 38 AF B2 00 2C 00 80 A0 21 00 A0 98 21 00 C0 80 21 10 40 00 07 00 E0 88 21 3C 12 ?? ?? 8E 42 ?? ?? 10 47 00 2F 3C 15 ?? ?? AE B0 ?? ?? AE 51 ?? ?? 3C 12 ?? ?? 26 52 ?? ?? 12 40 00 04 AF A0 00 18 24 04 00 01 0? ?? ?? ?? 27 A5 00 18 3C 02 ?? ?? 0? ?? ?? ?? 8C 44 ?? ?? 3C 02 ?? ?? 8C 59 ?? ?? 13 20 00 2E 3C 02 ?? ?? 03 20 F8 09 00 00 00 00 12 00 00 28 3C 05 ?? ?? 3C 05 ?? ?? 24 A5 ?? ?? 00 00 20 21 02 00 30 21 0? ?? ?? ?? 02 20 38 21 8F A6 00 50 27 A2 00 54 02 80 20 21 02 60 28 21 00 40 38 21 0? ?? ?? ?? AF A2 00 1C 12 40 00 03 8F A4 00 18 0? ?? ?? ?? 00 00 28 21 8F BF 00 3C 8F B5 00 38 8F B4 00 34 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 40 8E A4 ?? ?? 10 C4 FF F6 8F BF 00 3C 10 80 FF CE 00 00 00 00 10 C0 FF CC 00 00 00 00 0? ?? ?? ?? 00 C0 28 21 10 40 FF EE 8F BF 00 3C 0? ?? ?? ?? AE B0 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 8C 46 ?? ?? 3C 05 ?? ?? 00 00 20 21 0? ?? ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_262_0_0 {
	meta:
		name = "__sched_getparam"
		size = 28
	strings:
		$1 = { 24 02 10 3F 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_263_0_0 {
	meta:
		name = "object_compare"
		size = 168
	strings:
		$1 = { 8C 86 00 08 8C A3 00 08 00 66 10 2B 00 C3 18 2B 00 43 10 23 14 40 00 0C 00 00 00 00 8C 83 00 00 8C A6 00 00 8C 87 00 04 8C A8 00 04 00 C3 10 2B 10 40 00 0C 24 04 00 01 00 66 28 2B 10 A0 00 04 24 02 00 01 00 82 10 23 03 E0 00 08 00 00 00 00 10 C3 00 10 00 00 00 00 00 00 10 21 03 E0 00 08 00 82 10 23 10 66 00 06 00 66 28 2B 00 00 20 21 14 A0 FF F4 24 02 00 01 0? ?? ?? ?? 00 00 00 00 01 07 10 2B 14 40 FF EC 00 00 00 00 0? ?? ?? ?? 00 00 20 21 00 E8 38 2B 10 E0 FF EF 00 00 00 00 03 E0 00 08 00 82 10 23 }
	condition:
		$1
}

rule file_263_1_0 {
	meta:
		name = "add_object.isra.1"
		size = 124
		refs = "0020 malloc 004c __tsearch"
	strings:
		$1 = { 27 BD FF D8 AF B0 00 18 00 80 80 21 24 04 00 10 AF B2 00 20 AF B1 00 1C AF BF 00 24 00 A0 88 21 0? ?? ?? ?? 00 C0 90 21 10 40 00 12 3C 06 ?? ?? 8E 27 00 00 8E 43 00 00 00 40 20 21 26 05 00 30 24 C6 ?? ?? AC 47 00 04 AC 40 00 00 0? ?? ?? ?? AC 43 00 08 2C 42 00 01 00 02 10 23 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_263_2_0 {
	meta:
		name = "process_entry"
		size = 864
		refs = "0000 __gnu_local_gp 0064 mempcpy 009c __fxstatat 0118 realloc 01a0 __lxstat 01b8 __libc_errno 023c __xstat 0314 __tfind"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF 20 27 9C ?? ?? AF B2 00 D4 AF B1 00 D0 AF B0 00 CC AF BF 00 DC AF B3 00 D8 AF BC 00 18 80 C2 00 00 24 03 00 2E 00 C0 88 21 00 80 80 21 10 43 00 40 00 A0 90 21 8E 03 00 14 8E 04 00 10 24 62 00 02 00 47 10 21 00 82 20 2B 14 80 00 2F 00 02 28 40 8E 04 00 0C 02 20 28 21 00 83 20 21 0? ?? ?? ?? 00 E0 30 21 A0 40 00 00 8E 45 00 04 24 02 FF FF 10 A2 00 3F 24 02 01 00 8E 04 00 1C 27 B3 00 20 30 84 00 01 00 04 10 0A AF A2 00 10 24 04 00 03 02 20 30 21 0? ?? ?? ?? 02 60 38 21 8F BC 00 18 04 40 00 41 00 00 00 00 8F A2 00 34 24 03 40 00 30 42 F0 00 10 43 00 7E 34 03 A0 00 10 43 00 7F 00 00 00 00 8E 02 00 1C 00 00 20 21 30 43 00 02 10 60 00 45 24 03 00 01 8E 03 00 28 10 60 00 3E 8F A5 00 20 00 00 18 21 00 60 10 21 8F BF 00 DC 8F B3 00 D8 8F B2 00 D4 8F B1 00 D0 8F B0 00 CC 03 E0 00 08 27 BD 00 E0 8E 04 00 0C AE 05 00 10 0? ?? ?? ?? AF A7 00 C0 10 40 00 8D 8F A7 00 C0 8E 03 00 14 AE 02 00 0C 0? ?? ?? ?? 00 40 20 21 80 C3 00 01 10 60 00 06 00 00 00 00 14 62 FF BD 00 00 00 00 80 C2 00 02 14 40 FF BA 00 00 00 00 00 00 10 21 8F BF 00 DC 8F B3 00 D8 8F B2 00 D4 8F B1 00 D0 8F B0 00 CC 03 E0 00 08 27 BD 00 E0 8E 02 00 1C 30 43 00 04 14 60 00 02 27 B3 00 20 8E 11 00 0C 30 42 00 01 24 04 00 03 02 20 28 21 10 40 00 28 02 60 30 21 0? ?? ?? ?? 00 00 00 00 04 41 FF C1 8F BC 00 18 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 8C 42 00 00 24 03 00 0D 10 43 00 20 24 03 00 02 10 43 00 1E 24 03 FF FF 0? ?? ?? ?? 00 60 10 21 8E 03 00 2C 14 65 FF C2 00 00 18 21 24 03 00 01 14 83 00 37 00 04 18 80 30 42 00 01 10 40 00 3E 3C 06 ?? ?? 02 00 20 21 02 60 28 21 0? ?? ?? ?? 02 40 30 21 00 40 18 21 8E 04 00 1C 30 84 00 10 10 80 FF CE 00 60 10 21 24 02 00 02 10 62 FF CA 00 60 10 21 0? ?? ?? ?? 8F BF 00 DC 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 8F BC 00 18 8E 02 00 1C 30 43 00 01 14 60 00 1E 24 03 00 0C 8F A4 00 F0 24 03 00 0A 10 83 FF 9B 24 04 00 06 8E 45 00 04 24 02 FF FF 10 A2 00 33 24 04 00 03 24 02 01 00 AF A2 00 10 02 20 30 21 0? ?? ?? ?? 02 60 38 21 14 40 00 0F 24 03 00 0C 8F A3 00 34 34 02 A0 00 30 63 F0 00 14 62 00 0A 24 03 00 0C 8E 02 00 1C 0? ?? ?? ?? 24 04 00 06 8E 02 00 1C 0? ?? ?? ?? 24 04 00 01 8E 02 00 1C 0? ?? ?? ?? 24 04 00 04 8E 02 00 20 8E 19 00 24 8E 04 00 0C 00 43 10 21 8C 46 00 00 02 60 28 21 03 20 F8 09 26 07 00 14 0? ?? ?? ?? 00 40 18 21 8F A2 00 20 27 A4 00 B0 AF A2 00 B4 8F A2 00 30 26 05 00 30 24 C6 ?? ?? AF A0 00 B0 0? ?? ?? ?? AF A2 00 B8 14 40 FF 74 00 00 18 21 02 00 20 21 02 60 28 21 0? ?? ?? ?? 27 A6 00 30 10 40 FF B3 00 40 18 21 0? ?? ?? ?? 8E 04 00 1C 02 20 28 21 0? ?? ?? ?? 02 60 30 21 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_263_3_0 {
	meta:
		name = "ftw_dir"
		size = 1868
		refs = "0020 __gnu_local_gp 0070 malloc 009c strlen 00d4 realloc 00f0 mempcpy 0100 __readdir64 015c __closedir 01c8 __openat64_nocancel 01e0 __fdopendir 0270 __rawmemchr 0358 __libc_errno 0364 free 0398 $LC0 03a0 __opendir 04b8 __fchdir 06a0 __chdir 069c $LC6 06c0 $LC5 06f0 $LC4 06f4 $LC2 0708 __assert_fail 06f8 __PRETTY_FUNCTION__.8352 019c $LC1 0714 __PRETTY_FUNCTION__.8316 072c $LC3"
	strings:
		$1 = { 8C 83 00 04 8C 82 00 00 27 BD FF 98 00 03 18 80 00 43 10 21 8C 83 00 14 AF B0 00 40 8C 50 00 00 3C 1C ?? ?? 24 C2 00 04 27 9C ?? ?? 00 06 10 0A AF B7 00 5C AF B3 00 4C AF BF 00 64 AF BE 00 60 AF B6 00 58 AF B5 00 54 AF B4 00 50 AF B2 00 48 AF B1 00 44 AF BC 00 18 00 80 98 21 00 C0 B8 21 AF A5 00 6C AF A3 00 34 12 00 00 4D AF A2 00 30 0? ?? ?? ?? 24 04 04 00 00 40 A0 21 10 40 01 4F 8F BC 00 18 8E 15 00 00 24 12 04 00 00 00 80 21 0? ?? ?? ?? 24 16 04 00 24 51 00 13 0? ?? ?? ?? 02 20 20 21 00 50 F0 21 00 40 30 21 27 C2 00 02 00 52 10 2B 14 40 00 0E 02 90 20 21 00 06 10 40 2C 44 04 00 02 C4 10 0B 02 42 90 21 02 80 20 21 02 40 28 21 0? ?? ?? ?? AF A6 00 38 8F BC 00 18 10 40 01 12 8F A6 00 38 00 40 A0 21 02 90 20 21 0? ?? ?? ?? 02 20 28 21 A0 40 00 00 27 D0 00 01 0? ?? ?? ?? 02 A0 20 21 14 40 FF E3 02 80 20 21 02 90 10 21 A0 40 00 00 8E 62 00 04 8E 63 00 00 00 02 10 80 00 62 10 21 26 05 00 01 0? ?? ?? ?? 8C 50 00 00 8E 64 00 04 8E 63 00 00 8F BC 00 18 00 04 20 80 AE 02 00 08 00 64 18 21 8C 62 00 00 8C 42 00 08 10 40 00 F5 00 00 00 00 0? ?? ?? ?? 02 A0 20 21 8E 63 00 04 8E 62 00 00 24 05 FF FF 00 03 18 80 00 43 10 21 8C 44 00 00 AC 80 00 00 8C 44 00 00 AC 85 00 04 AC 40 00 00 8E 62 00 00 00 43 18 21 8C 62 00 00 14 40 01 5D 3C 04 ?? ?? 8F A3 00 30 10 60 00 73 24 10 FF FF 8C 64 00 00 10 90 00 70 3C 06 00 01 8E 65 00 0C 8E 62 00 14 24 C6 00 80 00 A2 28 21 0? ?? ?? ?? 00 00 38 21 00 40 88 21 8F BC 00 18 10 50 00 F8 AF A0 00 20 0? ?? ?? ?? 00 40 20 21 AF A2 00 20 14 40 00 07 8F BC 00 18 02 20 20 21 24 02 0F A6 00 00 00 0C 8F A2 00 20 10 40 00 ED 00 00 00 00 8E 63 00 04 8E 65 00 00 8C 46 00 00 8E 64 00 08 00 03 10 80 00 A2 28 21 27 B2 00 20 24 62 00 01 AF A6 00 24 AF A0 00 28 AC B2 00 00 10 44 01 1F AE 62 00 04 8E 62 00 1C 30 43 00 08 10 60 00 E2 8F A5 00 6C 30 42 00 04 14 40 00 E9 8F A2 00 20 8E 62 00 18 8E 70 00 0C 00 00 28 21 24 42 00 01 AE 62 00 18 0? ?? ?? ?? 02 00 20 21 12 02 01 2C 8F BC 00 18 80 44 FF FF 24 03 00 2F 10 83 00 04 00 00 00 00 A0 43 00 00 8E 70 00 0C 24 42 00 01 00 50 80 23 0? ?? ?? ?? AE 70 00 14 0? ?? ?? ?? 00 00 00 00 00 40 80 21 10 40 00 3F 8F BC 00 18 26 11 00 13 0? ?? ?? ?? 02 20 20 21 92 03 00 12 02 60 20 21 02 40 28 21 AF A3 00 10 02 20 30 21 0? ?? ?? ?? 00 40 38 21 00 40 80 21 14 40 00 32 8F BC 00 18 8F A4 00 20 14 80 FF EC 8F B4 00 28 82 82 00 00 14 40 00 06 02 80 20 21 0? ?? ?? ?? 00 00 80 21 82 22 00 01 10 40 00 10 8F A4 00 28 02 80 20 21 0? ?? ?? ?? 00 00 28 21 00 54 38 23 02 80 30 21 AF A0 00 10 02 60 20 21 02 40 28 21 0? ?? ?? ?? 00 40 88 21 00 40 80 21 8F BC 00 18 10 40 FF F0 26 34 00 01 8F A4 00 28 8F 91 ?? ?? 7C 03 E8 3B 02 23 88 21 0? ?? ?? ?? 8E 32 00 00 0? ?? ?? ?? AE 32 00 00 8E 62 00 1C 30 42 00 04 10 40 00 08 8E 64 00 0C 8E 62 00 14 00 82 20 21 80 82 00 00 14 40 00 03 00 00 00 00 3C 04 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 00 00 00 00 AF A2 00 20 0? ?? ?? ?? 8F BC 00 18 8F A4 00 20 10 80 00 C8 8F 91 ?? ?? 8F A2 00 28 7C 03 E8 3B 02 23 88 21 14 40 00 C8 8E 32 00 00 0? ?? ?? ?? 00 00 00 00 8E 62 00 04 24 03 FF FF AF A3 00 24 24 43 FF FF AE 32 00 00 10 40 00 67 AE 63 00 04 8E 62 00 00 00 03 18 80 00 43 18 21 AC 60 00 00 8E 62 00 1C 30 42 00 10 10 40 00 3A 24 02 00 03 16 02 00 38 00 00 00 00 8E 62 00 14 8E 63 00 0C 00 62 10 21 A0 40 FF FF 8E 62 00 18 8F A3 00 34 24 42 FF FF AE 63 00 14 AE 62 00 18 8E 62 00 1C 30 42 00 08 10 40 00 08 00 00 80 21 8E 79 00 24 8E 64 00 0C 8F A5 00 6C 24 06 00 05 03 20 F8 09 26 67 00 14 00 40 80 21 12 E0 00 16 8F BF 00 64 8E 62 00 1C 30 43 00 04 10 60 00 12 00 00 00 00 12 00 00 08 30 42 00 10 10 40 00 0F 02 00 10 21 24 02 FF FF 12 02 00 2F 24 02 00 01 12 02 00 0A 02 00 10 21 8E E2 00 00 10 40 00 76 00 00 00 00 0? ?? ?? ?? 8C 44 00 00 14 40 00 72 00 00 00 00 8F BF 00 64 02 00 10 21 8F BE 00 60 8F B7 00 5C 8F B6 00 58 8F B5 00 54 8F B4 00 50 8F B3 00 4C 8F B2 00 48 8F B1 00 44 8F B0 00 40 03 E0 00 08 27 BD 00 68 8E 62 00 14 8E 63 00 0C 00 62 10 21 A0 40 FF FF 8E 62 00 18 8F A3 00 34 24 42 FF FF AE 63 00 14 16 00 FF D4 AE 62 00 18 0? ?? ?? ?? 8E 62 00 1C 8F 91 ?? ?? 7C 03 E8 3B 02 80 20 21 02 23 88 21 0? ?? ?? ?? 8E 30 00 00 AE 30 00 00 02 00 18 21 24 02 00 0D 10 62 00 13 8F A5 00 6C 8F BF 00 64 24 10 FF FF 02 00 10 21 8F BE 00 60 8F B7 00 5C 8F B6 00 58 8F B5 00 54 8F B4 00 50 8F B3 00 4C 8F B2 00 48 8F B1 00 44 8F B0 00 40 03 E0 00 08 27 BD 00 68 8E 63 00 08 24 63 FF FF 0? ?? ?? ?? AE 63 00 04 8E 79 00 24 8E 64 00 0C 24 06 00 02 03 20 F8 09 26 67 00 14 0? ?? ?? ?? 00 40 80 21 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 0? ?? ?? ?? 8C 43 00 00 8E 79 00 24 8E 64 00 0C 24 06 00 01 03 20 F8 09 26 67 00 14 00 40 80 21 14 40 00 08 8F BC 00 18 0? ?? ?? ?? 8E 62 00 1C 0? ?? ?? ?? 8C 44 00 00 04 41 FF 15 8F BC 00 18 24 10 FF FF 8F 91 ?? ?? 8F A4 00 20 7C 03 E8 3B 02 23 88 21 0? ?? ?? ?? 8E 32 00 00 8E 62 00 04 AE 32 00 00 24 43 FF FF 14 40 00 04 AE 63 00 04 8E 63 00 08 24 63 FF FF AE 63 00 04 8E 62 00 00 8F BF 00 64 00 03 18 80 00 43 10 21 AC 40 00 00 8F BE 00 60 02 00 10 21 8F B7 00 5C 8F B6 00 58 8F B5 00 54 8F B4 00 50 8F B3 00 4C 8F B2 00 48 8F B1 00 44 8F B0 00 40 03 E0 00 08 27 BD 00 68 8E 63 00 14 24 02 00 01 10 62 00 0A 00 00 00 00 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 04 41 FF 87 8F BF 00 64 0? ?? ?? ?? 24 10 FF FF 0? ?? ?? ?? AE 60 00 04 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 04 41 FF 7E 8F BF 00 64 0? ?? ?? ?? 24 10 FF FF 8F B4 00 28 16 00 FF 1D 02 80 20 21 0? ?? ?? ?? 82 82 00 00 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 02 30 0? ?? ?? ?? 24 E7 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 01 52 0? ?? ?? ?? 24 E7 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 02 1A 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_263_4_0 {
	meta:
		name = "ftw_startup"
		size = 1316
		refs = "0004 __gnu_local_gp 0088 memset 0090 strlen 00ac malloc 00c4 stpcpy 0184 __libc_errno 01c4 __lxstat 0200 $LC0 0208 __open 0264 __chdir 02b0 free 02c8 __xstat 0348 __fchdir 0370 __tdestroy 0474 $LC5 0508 __getcwd"
	strings:
		$1 = { 27 BD FE F8 3C 1C ?? ?? 27 9C ?? ?? AF BE 01 00 03 A0 F0 21 AF B4 00 F0 AF B1 00 E4 AF BF 01 04 AF B7 00 FC AF B6 00 F8 AF B5 00 F4 AF B3 00 EC AF B2 00 E8 AF B0 00 E0 AF DC 00 10 80 82 00 00 00 80 A0 21 10 40 00 FD 8F D1 01 18 00 07 18 2A 24 02 00 01 00 E3 10 0B 00 C0 98 21 00 02 30 80 24 C3 00 0E 00 03 18 C2 00 03 18 C0 03 A3 E8 23 27 A3 00 10 00 60 20 21 00 A0 90 21 00 00 28 21 AF C3 00 A8 AF C2 00 B0 0? ?? ?? ?? AF C0 00 AC 0? ?? ?? ?? 02 80 20 21 00 02 10 40 2C 44 10 00 24 03 10 00 00 64 10 0B 00 40 20 21 0? ?? ?? ?? AF C2 00 B8 00 40 80 21 10 40 00 FE AF C2 00 B4 00 40 20 21 0? ?? ?? ?? 02 80 28 21 00 40 18 21 26 02 00 01 00 43 20 2B 10 80 00 0E 8F DC 00 10 80 65 FF FF 24 04 00 2F 10 A4 00 08 24 63 FF FF 24 63 00 01 0? ?? ?? ?? 02 03 10 2B 80 67 FF FF 14 E4 00 04 00 00 00 00 24 63 FF FF 14 62 FF FB 00 00 00 00 02 03 10 2B A0 60 00 00 10 40 00 0E AF C0 00 C0 80 64 FF FF 24 02 00 2F 14 82 00 08 24 63 FF FF 24 63 00 01 0? ?? ?? ?? 00 70 18 23 80 67 FF FF 10 E2 00 04 00 00 00 00 24 63 FF FF 14 70 FF FB 00 00 00 00 00 70 18 23 AF C3 00 BC AF D1 00 C4 16 40 00 20 AF D3 00 CC 3C 02 ?? ?? 24 42 ?? ?? 32 23 00 04 AF C2 00 C8 14 60 00 20 AF C0 00 D8 8F 92 ?? ?? 00 00 A8 21 24 13 FF FF 10 60 00 07 27 D6 00 18 8F C2 00 BC 02 02 80 21 82 02 00 00 10 40 00 87 00 00 00 00 27 D6 00 18 32 34 00 01 24 04 00 03 02 00 28 21 12 80 00 42 02 C0 30 21 0? ?? ?? ?? 00 00 00 00 04 41 00 43 8F C2 00 2C 7C 03 E8 3B 02 43 10 21 8C 54 00 00 0? ?? ?? ?? 24 10 FF FF 3C 02 ?? ?? 24 42 ?? ?? 32 23 00 04 AF C2 00 C8 10 60 FF E2 AF C0 00 D8 3C 04 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 3C 05 00 01 00 40 98 21 24 02 FF FF 12 62 00 74 8F DC 00 10 8F C2 00 B0 2C 43 00 02 14 60 00 8F 24 42 FF FF 8F 92 ?? ?? AF C2 00 B0 00 00 A8 21 8F C2 00 BC 18 40 00 86 8F C3 00 C4 24 03 00 01 10 43 00 89 8F C3 00 B4 24 42 FF FF 00 62 10 21 80 54 00 00 A0 40 00 00 0? ?? ?? ?? 8F C4 00 B4 00 40 80 21 8F C3 00 B4 8F C2 00 BC 00 62 10 21 A0 54 FF FF 12 00 00 76 8F C3 00 C4 7C 03 E8 3B 02 43 10 21 8C 54 00 00 24 02 FF FF 16 62 00 2B 00 00 00 00 12 A0 00 31 00 00 00 00 0? ?? ?? ?? 02 A0 20 21 0? ?? ?? ?? 02 A0 20 21 7C 03 E8 3B 02 43 10 21 0? ?? ?? ?? AC 54 00 00 0? ?? ?? ?? 00 00 00 00 04 40 00 3F 24 02 00 02 8F C2 00 2C 24 03 40 00 30 42 F0 00 10 43 00 4A 38 43 A0 00 24 02 00 10 00 03 10 0B 8F C3 00 C8 8F C4 00 B4 8F D9 00 CC 00 62 10 21 8C 46 00 00 02 C0 28 21 03 20 F8 09 27 C7 00 BC 7C 03 E8 3B 02 43 20 21 8C 94 00 00 00 40 80 21 32 31 00 10 12 20 00 05 24 02 FF FF 26 02 FF FE 2C 42 00 02 00 02 80 0B 24 02 FF FF 12 62 FF D7 00 00 00 00 0? ?? ?? ?? 02 60 20 21 02 60 20 21 24 02 0F A6 00 00 00 0C 7C 03 E8 3B 02 43 10 21 AC 54 00 00 8F C4 00 D8 3C 05 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 8F C4 00 B4 7C 03 E8 3B 02 43 90 21 AE 54 00 00 02 00 10 21 03 C0 E8 21 8F BF 01 04 8F BE 01 00 8F B7 00 FC 8F B6 00 F8 8F B5 00 F4 8F B4 00 F0 8F B3 00 EC 8F B2 00 E8 8F B1 00 E4 8F B0 00 E0 03 E0 00 08 27 BD 01 08 3C 10 ?? ?? 0? ?? ?? ?? 26 10 ?? ?? 7C 03 E8 3B 02 43 B8 21 8E F4 00 00 12 82 00 37 24 04 00 03 0? ?? ?? ?? 24 10 FF FF 8F 92 ?? ?? 7C 03 E8 3B 24 02 00 0D 02 43 80 21 8E 14 00 00 12 82 00 40 00 00 00 00 0? ?? ?? ?? 00 00 80 21 8F C2 00 18 AF C0 00 D0 12 80 00 1B AF C2 00 D4 27 D4 00 A8 02 80 20 21 02 C0 28 21 0? ?? ?? ?? 00 00 30 21 0? ?? ?? ?? 00 00 00 00 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 02 AC 43 00 00 0? ?? ?? ?? 24 02 FF FF 8F D0 00 B4 0? ?? ?? ?? 30 63 00 04 8F 92 ?? ?? 0? ?? ?? ?? 00 00 A8 21 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 00 40 80 21 27 D4 00 A8 02 80 20 21 02 C0 28 21 0? ?? ?? ?? 27 C6 00 28 10 40 FF E1 00 40 80 21 7C 03 E8 3B 02 43 10 21 0? ?? ?? ?? 8C 54 00 00 0? ?? ?? ?? 24 02 FF FF 02 00 28 21 0? ?? ?? ?? 02 C0 30 21 14 40 FF 42 8F C3 00 2C 34 02 A0 00 30 63 F0 00 14 62 FF 3E 8F C2 00 C8 8F C4 00 B4 8F D9 00 CC 8C 46 00 18 02 C0 28 21 03 20 F8 09 27 C7 00 BC 00 40 80 21 0? ?? ?? ?? 8E F4 00 00 00 00 20 21 0? ?? ?? ?? 00 00 28 21 14 40 FF 4A 00 40 A8 21 8E 14 00 00 0? ?? ?? ?? 00 00 80 21 }
	condition:
		$1
}

rule file_263_5_0 {
	meta:
		name = "ftw"
		size = 44
		altNames = "ftw64"
	strings:
		$1 = { 27 BD FF D8 00 A0 10 21 00 C0 38 21 AF A0 00 10 00 00 28 21 AF BF 00 24 0? ?? ?? ?? 00 40 30 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_263_6_0 {
	meta:
		name = "__new_nftw"
		size = 104
		refs = "0000 __gnu_local_gp 0050 __libc_errno"
		altNames = "__new_nftw64"
	strings:
		$1 = { 3C 1C ?? ?? 24 02 FF E0 27 BD FF D8 27 9C ?? ?? 00 E2 10 24 AF BF 00 24 14 40 00 0B AF BC 00 18 00 A0 40 21 00 C0 18 21 AF A7 00 10 24 05 00 01 01 00 30 21 0? ?? ?? ?? 00 60 38 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 16 AC 43 00 00 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_264_0_0 {
	meta:
		name = "pmap_getmaps"
		size = 340
		refs = "0000 __gnu_local_gp 0038 __get_socket 0068 clnttcp_create 007c xdr_pmaplist 0098 xdr_void 0100 __libc_errno 00c4 _libc_intl_domainname 012c $LC0 0138 __dcgettext 0144 clnt_perror"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF B8 27 9C ?? ?? 24 02 00 6F AF BC 00 20 AF BF 00 44 AF B2 00 40 AF B1 00 3C AF B0 00 38 A4 82 00 02 24 02 00 3C 00 80 88 21 AF A0 00 34 AF A2 00 28 0? ?? ?? ?? AF A0 00 2C 00 40 90 21 24 02 00 32 AF A2 00 10 3C 05 00 01 24 02 01 F4 AF A2 00 14 02 20 20 21 34 A5 86 A0 24 06 00 02 27 A7 00 30 0? ?? ?? ?? AF B2 00 30 00 40 80 21 10 40 00 19 8F BC 00 20 3C 03 ?? ?? 24 63 ?? ?? 8C 42 00 04 AF A3 00 10 27 A3 00 34 AF A3 00 14 8F A3 00 28 3C 06 ?? ?? 02 00 20 21 AF A3 00 18 8F A3 00 2C 24 05 00 04 24 C6 ?? ?? AF A3 00 1C 8C 59 00 00 03 20 F8 09 00 00 38 21 14 40 00 1A 3C 04 ?? ?? 8E 02 00 04 8C 59 00 10 03 20 F8 09 02 00 20 21 8F BC 00 20 24 02 FF FF 12 42 00 0A 8F A4 00 30 24 02 0F A6 00 00 00 0C 10 E0 00 07 8F BF 00 44 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 64 20 21 AC 82 00 00 8F BF 00 44 8F A2 00 34 A6 20 00 02 8F B2 00 40 8F B1 00 3C 8F B0 00 38 03 E0 00 08 27 BD 00 48 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 00 40 28 21 0? ?? ?? ?? 02 00 20 21 0? ?? ?? ?? 8E 02 00 04 }
	condition:
		$1
}

rule file_265_0_0 {
	meta:
		name = "fputws_unlocked"
		size = 140
		refs = "0018 __wcslen 0028 _IO_fwide"
	strings:
		$1 = { 27 BD FF D8 AF B0 00 18 00 A0 80 21 AF BF 00 24 AF B2 00 20 AF B1 00 1C 0? ?? ?? ?? 00 80 90 21 02 00 20 21 24 05 00 01 0? ?? ?? ?? 00 40 88 21 24 03 00 01 14 43 00 0E 02 00 20 21 8E 02 00 98 02 40 28 21 8C 59 00 1C 03 20 F8 09 02 20 30 21 14 51 00 07 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 24 02 00 01 03 E0 00 08 27 BD 00 28 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 24 02 FF FF 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_266_1_0 {
	meta:
		name = "updwtmp_file"
		size = 628
		refs = "0000 __gnu_local_gp 0050 __libc_errno 0090 alarm 00b0 memset 00c4 __sigaction 0108 __fcntl_nocancel 0128 __lseek64 0144 __moddi3 0194 __ftruncate64"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FE 78 27 9C ?? ?? AF B4 01 78 AF BF 01 84 00 A0 A0 21 AF B6 01 80 AF B5 01 7C AF B3 01 74 AF B2 01 70 AF B1 01 6C AF B0 01 68 AF BC 00 18 24 05 20 01 24 02 0F A5 00 00 00 0C 10 E0 00 11 00 40 80 21 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 24 02 FF FF 00 64 20 21 AC 90 00 00 8F BF 01 84 8F B6 01 80 8F B5 01 7C 8F B4 01 78 8F B3 01 74 8F B2 01 70 8F B1 01 6C 8F B0 01 68 03 E0 00 08 27 BD 01 88 06 00 FF F5 24 02 FF FF 0? ?? ?? ?? 00 00 20 21 00 40 90 21 3C 02 ?? ?? 27 A4 00 B8 00 00 28 21 24 06 00 80 24 42 ?? ?? 0? ?? ?? ?? AF A2 00 B4 27 A5 00 B0 27 A6 00 20 24 04 00 0E 0? ?? ?? ?? AF A0 00 B0 0? ?? ?? ?? 24 04 00 0A 24 02 00 01 02 00 20 21 24 05 00 07 27 A6 01 40 AF A0 01 40 AF A0 01 44 AF A0 01 48 AF A0 01 4C AF A0 01 50 AF A0 01 54 AF A0 01 58 AF A0 01 5C AF A0 01 60 0? ?? ?? ?? A7 A2 01 40 04 40 00 28 24 11 FF FF 24 16 00 02 02 00 20 21 00 00 38 21 00 00 30 21 0? ?? ?? ?? AF B6 00 10 00 40 A8 21 02 A0 20 21 00 60 28 21 24 07 01 80 00 00 30 21 0? ?? ?? ?? 00 60 98 21 00 62 20 25 14 80 00 36 8F BC 00 18 02 00 20 21 02 80 28 21 24 06 01 80 24 02 0F A4 00 00 00 0C 10 E0 00 2B 24 03 01 80 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 64 20 21 AC 82 00 00 02 00 20 21 02 A0 30 21 02 60 38 21 0? ?? ?? ?? 24 11 FF FF 24 02 00 02 02 00 20 21 24 05 00 07 27 A6 01 40 0? ?? ?? ?? A7 A2 01 40 0? ?? ?? ?? 00 00 20 21 24 04 00 0E 27 A5 00 20 0? ?? ?? ?? 00 00 30 21 16 40 00 0F 00 00 00 00 02 00 20 21 24 02 0F A6 00 00 00 0C 8F BF 01 84 02 20 10 21 8F B6 01 80 8F B5 01 7C 8F B4 01 78 8F B3 01 74 8F B2 01 70 8F B1 01 6C 8F B0 01 68 03 E0 00 08 27 BD 01 88 0? ?? ?? ?? 02 40 20 21 0? ?? ?? ?? 02 00 20 21 10 43 FF DF 00 00 88 21 0? ?? ?? ?? 02 00 20 21 02 63 18 23 02 63 98 2B 02 A2 A8 23 02 B3 A8 23 00 60 38 21 02 00 20 21 02 A0 30 21 0? ?? ?? ?? 00 60 98 21 AF B6 00 10 02 00 20 21 00 00 38 21 0? ?? ?? ?? 00 00 30 21 04 41 FF BC 8F BC 00 18 0? ?? ?? ?? 24 02 00 02 }
	condition:
		$1
}

rule file_266_2_0 {
	meta:
		name = "setutent_file"
		size = 612
		refs = "0010 __gnu_local_gp 0040 __lseek64 0090 __libc_utmp_file_name 0098 $LC2 00a0 strcmp 00bc $LC3 00d4 $LC1 00ec $LC0 0124 __libc_errno 0170 __have_o_cloexec 0184 __fcntl_nocancel 01e4 __access"
	strings:
		$1 = { 27 BD FF C0 AF B0 00 24 3C 10 ?? ?? 8E 04 ?? ?? 3C 1C ?? ?? 27 9C ?? ?? AF BF 00 3C AF B5 00 38 AF B4 00 34 AF B3 00 30 AF B2 00 2C AF B1 00 28 04 80 00 17 AF BC 00 18 AF A0 00 10 00 00 38 21 0? ?? ?? ?? 00 00 30 21 3C 02 ?? ?? 00 00 28 21 00 00 20 21 AC 45 ?? ?? AC 44 ?? ?? 24 03 FF FF 3C 02 ?? ?? A4 43 ?? ?? 24 02 00 01 8F BF 00 3C 8F B5 00 38 8F B4 00 34 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 40 3C 12 ?? ?? 8E 51 ?? ?? 3C 13 ?? ?? 26 65 ?? ?? 0? ?? ?? ?? 02 20 20 21 10 40 00 4C 00 00 00 00 3C 14 ?? ?? 02 20 20 21 0? ?? ?? ?? 26 85 ?? ?? 10 40 00 4F 00 00 00 00 3C 15 ?? ?? 02 20 20 21 0? ?? ?? ?? 26 A5 ?? ?? 10 40 00 52 00 00 00 00 3C 13 ?? ?? 02 20 20 21 0? ?? ?? ?? 26 65 ?? ?? 8F BC 00 18 10 40 00 53 02 20 20 21 3C 02 ?? ?? 3C 05 00 08 A0 40 ?? ?? 24 A5 20 00 24 02 0F A5 00 00 00 0C 10 E0 00 12 00 40 28 21 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 8F BF 00 3C 8F B5 00 38 00 62 10 21 AC 45 00 00 24 02 FF FF AE 02 ?? ?? 8F B4 00 34 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 00 00 10 21 03 E0 00 08 27 BD 00 40 24 12 FF FF AE 02 ?? ?? 10 B2 FF C0 00 00 10 21 3C 11 ?? ?? 8E 22 ?? ?? 1C 40 FF AF 00 A0 20 21 24 05 00 01 0? ?? ?? ?? 00 00 30 21 04 40 00 0C 8E 23 ?? ?? 14 60 00 05 00 00 00 00 30 44 00 01 24 03 00 01 02 44 18 0A AE 23 ?? ?? 04 61 FF A2 8E 04 ?? ?? 34 46 00 01 0? ?? ?? ?? 24 05 00 02 24 03 FF FF 14 43 FF 9C 8E 04 ?? ?? 24 02 0F A6 00 00 00 0C 0? ?? ?? ?? 00 00 10 21 3C 11 ?? ?? 26 24 ?? ?? 0? ?? ?? ?? 00 00 28 21 8F BC 00 18 10 40 FF C2 26 24 ?? ?? 0? ?? ?? ?? 8E 51 ?? ?? 3C 11 ?? ?? 26 24 ?? ?? 0? ?? ?? ?? 00 00 28 21 8F BC 00 18 10 40 FF B9 26 24 ?? ?? 0? ?? ?? ?? 8E 51 ?? ?? 26 A4 ?? ?? 0? ?? ?? ?? 00 00 28 21 8F BC 00 18 14 40 FF B1 26 64 ?? ?? 0? ?? ?? ?? 8E 51 ?? ?? 26 64 ?? ?? 0? ?? ?? ?? 00 00 28 21 8E 43 ?? ?? 26 84 ?? ?? 8F BC 00 18 0? ?? ?? ?? 00 62 20 0A }
	condition:
		$1
}

rule file_266_3_0 {
	meta:
		name = "__utmp_equal"
		size = 148
		refs = "0058 strncmp"
	strings:
		$1 = { 94 83 00 00 24 63 FF FB 30 63 FF FF 2C 63 00 04 10 60 00 16 00 00 10 21 94 A3 00 00 24 63 FF FB 30 63 FF FF 2C 63 00 04 10 60 00 10 00 00 00 00 27 BD FF E0 AF BF 00 1C 80 82 00 28 10 40 00 0D 00 00 00 00 80 A2 00 28 10 40 00 0A 00 00 00 00 24 84 00 28 24 A5 00 28 0? ?? ?? ?? 24 06 00 04 2C 42 00 01 8F BF 00 1C 27 BD 00 20 03 E0 00 08 00 00 00 00 24 84 00 08 24 A5 00 08 0? ?? ?? ?? 24 06 00 20 2C 42 00 01 8F BF 00 1C 0? ?? ?? ?? 27 BD 00 20 }
	condition:
		$1
}

rule file_266_4_0 {
	meta:
		name = "getutline_r_file"
		size = 672
		refs = "0010 __gnu_local_gp 0060 alarm 0080 memset 0094 __sigaction 00d0 __fcntl_nocancel 011c __libc_errno 01f0 strncmp 0280 $LC4 0284 $LC5 0298 __assert_fail 0288 __PRETTY_FUNCTION__.9086"
	strings:
		$1 = { 27 BD FE 78 AF B1 01 64 3C 11 ?? ?? 8E 22 ?? ?? 3C 1C ?? ?? 27 9C ?? ?? AF BF 01 84 AF BE 01 80 AF B7 01 7C AF B6 01 78 AF B5 01 74 AF B4 01 70 AF B3 01 6C AF B2 01 68 AF B0 01 60 AF BC 00 10 04 40 00 8F AF A5 01 8C 3C 10 ?? ?? 8E 02 ?? ?? 24 03 FF FF 00 80 A8 21 10 43 00 84 00 C0 B0 21 0? ?? ?? ?? 00 00 20 21 00 40 B8 21 3C 02 ?? ?? 27 A4 00 B0 00 00 28 21 24 06 00 80 24 42 ?? ?? 0? ?? ?? ?? AF A2 00 AC 27 A5 00 A8 27 A6 00 18 24 04 00 0E 0? ?? ?? ?? AF A0 00 A8 0? ?? ?? ?? 24 04 00 0A 8E 24 ?? ?? 24 05 00 07 27 A6 01 38 AF A0 01 38 AF A0 01 3C AF A0 01 40 AF A0 01 44 AF A0 01 48 AF A0 01 4C AF A0 01 50 AF A0 01 54 0? ?? ?? ?? AF A0 01 58 04 40 00 62 8F BC 00 10 3C 12 ?? ?? 26 5E ?? ?? 3C 14 ?? ?? 03 C0 98 21 26 B5 00 08 26 94 ?? ?? 8E 24 ?? ?? 02 60 28 21 24 06 01 80 24 02 0F A3 00 00 00 0C 10 E0 00 29 24 03 01 80 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 03 AC 43 00 00 24 03 FF FF 24 02 FF FF AE 03 ?? ?? AE 02 ?? ?? AE C0 00 00 8E 24 ?? ?? 24 02 00 02 24 05 00 07 27 A6 01 38 0? ?? ?? ?? A7 A2 01 38 0? ?? ?? ?? 00 00 20 21 24 04 00 0E 27 A5 00 18 0? ?? ?? ?? 00 00 30 21 16 E0 00 38 00 00 00 00 8E C2 00 00 2C 42 00 01 00 02 10 23 8F BF 01 84 8F BE 01 80 8F B7 01 7C 8F B6 01 78 8F B5 01 74 8F B4 01 70 8F B3 01 6C 8F B2 01 68 8F B1 01 64 8F B0 01 60 03 E0 00 08 27 BD 01 88 14 43 FF D7 8E 03 ?? ?? 96 44 ?? ?? 8E 05 ?? ?? 24 62 01 80 24 84 FF FA 00 43 18 2B 30 84 FF FF 00 65 18 21 2C 84 00 02 AE 03 ?? ?? 10 80 FF C5 AE 02 ?? ?? 02 A0 20 21 02 80 28 21 0? ?? ?? ?? 24 06 00 20 14 40 FF BF 8F BC 00 10 8F A2 01 8C 03 C0 18 21 27 C8 01 80 8C 67 00 00 8C 66 00 04 8C 65 00 08 8C 64 00 0C A8 47 00 00 B8 47 00 03 A8 46 00 04 B8 46 00 07 A8 45 00 08 B8 45 00 0B A8 44 00 0C 24 63 00 10 B8 44 00 0F 14 68 FF F2 24 42 00 10 8F A2 01 8C 0? ?? ?? ?? AE C2 00 00 0? ?? ?? ?? 02 E0 20 21 0? ?? ?? ?? 8E C2 00 00 0? ?? ?? ?? AE C0 00 00 8E 03 ?? ?? 14 62 FF 7B 24 02 FF FF 0? ?? ?? ?? AC C0 00 00 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 01 59 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_266_5_0 {
	meta:
		name = "getutent_r_file"
		size = 624
		refs = "0010 __gnu_local_gp 0050 alarm 0070 memset 0084 __sigaction 00c0 __fcntl_nocancel 01cc __libc_errno 0250 $LC4 0254 $LC5 0268 __assert_fail 0258 __PRETTY_FUNCTION__.9017"
	strings:
		$1 = { 27 BD FE 80 AF B1 01 68 3C 11 ?? ?? 8E 22 ?? ?? 3C 1C ?? ?? 27 9C ?? ?? AF BF 01 7C AF B5 01 78 AF B4 01 74 AF B3 01 70 AF B2 01 6C AF B0 01 64 04 40 00 87 AF BC 00 10 3C 10 ?? ?? 8E 02 ?? ?? 24 03 FF FF 00 80 A0 21 10 43 00 7C 00 A0 98 21 0? ?? ?? ?? 00 00 20 21 00 40 A8 21 3C 02 ?? ?? 27 A4 00 B0 00 00 28 21 24 06 00 80 24 42 ?? ?? 0? ?? ?? ?? AF A2 00 AC 27 A5 00 A8 27 A6 00 18 24 04 00 0E 0? ?? ?? ?? AF A0 00 A8 0? ?? ?? ?? 24 04 00 0A 8E 24 ?? ?? 24 05 00 07 27 A6 01 38 AF A0 01 38 AF A0 01 3C AF A0 01 40 AF A0 01 44 AF A0 01 48 AF A0 01 4C AF A0 01 50 AF A0 01 54 0? ?? ?? ?? AF A0 01 58 04 40 00 5A 8F BC 00 10 3C 02 ?? ?? 3C 05 ?? ?? 8C 44 ?? ?? 24 A5 ?? ?? 24 06 01 80 24 02 0F A3 00 00 00 0C 14 E0 00 35 00 40 90 21 8E 24 ?? ?? 24 02 00 02 24 05 00 07 27 A6 01 38 0? ?? ?? ?? A7 A2 01 38 0? ?? ?? ?? 00 00 20 21 24 04 00 0E 27 A5 00 18 0? ?? ?? ?? 00 00 30 21 16 A0 00 2E 24 02 01 80 16 42 00 31 8E 03 ?? ?? 8E 04 ?? ?? 24 62 01 80 00 43 18 2B 00 64 20 21 3C 03 ?? ?? 24 63 ?? ?? AE 02 ?? ?? AE 04 ?? ?? 02 80 10 21 24 68 01 80 8C 67 00 00 8C 66 00 04 8C 65 00 08 8C 64 00 0C A8 47 00 00 B8 47 00 03 A8 46 00 04 B8 46 00 07 A8 45 00 08 B8 45 00 0B A8 44 00 0C 24 63 00 10 B8 44 00 0F 14 68 FF F2 24 42 00 10 8F BF 01 7C AE 74 00 00 8F B5 01 78 8F B4 01 74 8F B3 01 70 8F B2 01 6C 8F B1 01 68 8F B0 01 64 00 00 10 21 03 E0 00 08 27 BD 01 80 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 AC 52 00 00 0? ?? ?? ?? 24 12 FF FF 0? ?? ?? ?? 02 A0 20 21 24 02 01 80 12 42 FF D1 8E 03 ?? ?? 12 40 00 04 24 03 FF FF 24 02 FF FF AE 03 ?? ?? AE 02 ?? ?? AE 60 00 00 24 02 FF FF 8F BF 01 7C 8F B5 01 78 8F B4 01 74 8F B3 01 70 8F B2 01 6C 8F B1 01 68 8F B0 01 64 03 E0 00 08 27 BD 01 80 0? ?? ?? ?? 00 00 90 21 8E 03 ?? ?? 14 62 FF 83 24 02 FF FF 0? ?? ?? ?? AE 60 00 00 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 CC 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_266_6_0 {
	meta:
		name = "endutent_file"
		size = 72
		refs = "0024 $LC4 0028 $LC5 0040 __assert_fail 000c __PRETTY_FUNCTION__.9218"
	strings:
		$1 = { 3C 05 ?? ?? 8C A4 ?? ?? 04 80 00 06 3C 07 ?? ?? 24 02 0F A6 00 00 00 0C 24 02 FF FF 03 E0 00 08 AC A2 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 27 BD FF E0 24 84 ?? ?? 24 A5 ?? ?? 24 06 02 10 AF BF 00 1C 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_266_7_0 {
	meta:
		name = "internal_getut_r.constprop.2"
		size = 536
		refs = "0004 __gnu_local_gp 0034 alarm 0054 memset 006c __sigaction 00a8 __fcntl_nocancel 00f8 __libc_errno"
	strings:
		$1 = { 27 BD FE 88 3C 1C ?? ?? 27 9C ?? ?? AF B4 01 70 00 80 A0 21 00 00 20 21 AF BC 00 10 AF BF 01 74 AF B3 01 6C AF B2 01 68 AF B1 01 64 AF B0 01 60 00 A0 88 21 0? ?? ?? ?? 00 C0 80 21 00 40 98 21 3C 02 ?? ?? 27 A4 00 B0 00 00 28 21 24 06 00 80 24 42 ?? ?? 0? ?? ?? ?? AF A2 00 AC 27 A5 00 A8 27 A6 00 18 24 04 00 0E AF A0 00 A8 0? ?? ?? ?? 3C 12 ?? ?? 0? ?? ?? ?? 24 04 00 0A 8E 44 ?? ?? 24 05 00 07 27 A6 01 38 AF A0 01 38 AF A0 01 3C AF A0 01 40 AF A0 01 44 AF A0 01 48 AF A0 01 4C AF A0 01 50 AF A0 01 54 0? ?? ?? ?? AF A0 01 58 04 40 00 55 8F BC 00 10 96 82 00 00 24 42 FF FF 30 42 FF FF 2C 42 00 04 14 40 00 2D 3C 10 ?? ?? 8E 44 ?? ?? 02 20 28 21 24 06 01 80 24 02 0F A3 00 00 00 0C 02 20 20 21 10 E0 00 39 02 80 28 21 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 24 07 FF FF 24 06 FF FF 00 62 10 21 24 03 00 03 AE 07 ?? ?? AE 06 ?? ?? AC 43 00 00 24 10 FF FF 8E 44 ?? ?? 24 02 00 02 24 05 00 07 27 A6 01 38 0? ?? ?? ?? A7 A2 01 38 0? ?? ?? ?? 00 00 20 21 24 04 00 0E 27 A5 00 18 0? ?? ?? ?? 00 00 30 21 12 60 00 04 8F BF 01 74 0? ?? ?? ?? 02 60 20 21 8F BF 01 74 02 00 10 21 8F B4 01 70 8F B3 01 6C 8F B2 01 68 8F B1 01 64 8F B0 01 60 03 E0 00 08 27 BD 01 78 8E 44 ?? ?? 02 20 28 21 24 06 01 80 24 02 0F A3 00 00 00 0C 14 E0 FF D6 24 03 01 80 14 43 FF D4 8E 02 ?? ?? 8E 04 ?? ?? 86 87 00 00 24 43 01 80 86 26 00 00 00 62 10 2B 00 44 10 21 AE 02 ?? ?? 14 E6 FF EF AE 03 ?? ?? 0? ?? ?? ?? 00 00 80 21 24 03 01 80 14 43 FF C6 8E 03 ?? ?? 8E 06 ?? ?? 24 62 01 80 00 43 18 2B 00 66 18 21 AE 03 ?? ?? 0? ?? ?? ?? AE 02 ?? ?? 10 40 FF B5 8F BC 00 10 0? ?? ?? ?? 00 00 80 21 24 02 00 01 A2 02 00 00 0? ?? ?? ?? 24 10 FF FF }
	condition:
		$1
}

rule file_266_8_0 {
	meta:
		name = "getutid_r_file"
		size = 244
		refs = "00d4 $LC4 00d8 $LC5 00ec __assert_fail 00dc __PRETTY_FUNCTION__.9079"
	strings:
		$1 = { 3C 02 ?? ?? 8C 42 ?? ?? 27 BD FF D0 AF BF 00 2C AF B2 00 28 AF B1 00 24 04 40 00 2E AF B0 00 20 3C 03 ?? ?? 8C 62 ?? ?? 00 A0 88 21 24 05 FF FF 10 45 00 22 00 C0 90 21 3C 10 ?? ?? 26 05 ?? ?? 27 A6 00 18 0? ?? ?? ?? A3 A0 00 18 04 40 00 1E 00 00 00 00 26 03 ?? ?? 02 20 10 21 24 65 01 80 8C 69 00 00 8C 68 00 04 8C 67 00 08 8C 64 00 0C A8 49 00 00 B8 49 00 03 A8 48 00 04 B8 48 00 07 A8 47 00 08 B8 47 00 0B A8 44 00 0C 24 63 00 10 B8 44 00 0F 14 65 FF F2 24 42 00 10 AE 51 00 00 00 00 10 21 8F BF 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 30 8C 63 ?? ?? 14 62 FF DE 3C 10 ?? ?? AE 40 00 00 0? ?? ?? ?? 24 02 FF FF 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 01 3B 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_266_9_0 {
	meta:
		name = "pututline_file"
		size = 1592
		refs = "0010 __gnu_local_gp 0054 __libc_utmp_file_name 005c $LC2 0064 strcmp 0080 $LC3 0098 $LC1 00b0 $LC0 00e0 __libc_errno 012c __have_o_cloexec 0148 __lseek64 0170 __dup2 01ec alarm 020c memset 0220 __sigaction 0268 __fcntl_nocancel 0450 __moddi3 0480 __access 059c __ftruncate64 05f8 $LC4 05fc $LC5 0610 __assert_fail 0600 __PRETTY_FUNCTION__.9122"
	strings:
		$1 = { 27 BD FC E8 AF B0 02 F0 3C 10 ?? ?? 8E 02 ?? ?? 3C 1C ?? ?? 27 9C ?? ?? AF BF 03 14 AF BE 03 10 AF B7 03 0C AF B6 03 08 AF B5 03 04 AF B4 03 00 AF B3 02 FC AF B2 02 F8 AF B1 02 F4 04 40 01 6E AF BC 00 18 3C 11 ?? ?? 92 22 ?? ?? 14 40 00 50 00 80 90 21 3C 14 ?? ?? 8E 93 ?? ?? 3C 15 ?? ?? 26 A5 ?? ?? 0? ?? ?? ?? 02 60 20 21 10 40 01 02 00 00 00 00 3C 16 ?? ?? 02 60 20 21 0? ?? ?? ?? 26 C5 ?? ?? 10 40 01 1B 00 00 00 00 3C 17 ?? ?? 02 60 20 21 0? ?? ?? ?? 26 E5 ?? ?? 10 40 01 26 00 00 00 00 3C 15 ?? ?? 02 60 20 21 0? ?? ?? ?? 26 A5 ?? ?? 8F BC 00 18 10 40 01 27 02 60 20 21 3C 05 00 08 24 A5 20 02 24 02 0F A5 00 00 00 0C 10 E0 00 13 00 40 98 21 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 00 10 21 00 64 20 21 AC 93 00 00 8F BF 03 14 8F BE 03 10 8F B7 03 0C 8F B6 03 08 8F B5 03 04 8F B4 03 00 8F B3 02 FC 8F B2 02 F8 8F B1 02 F4 8F B0 02 F0 03 E0 00 08 27 BD 03 18 24 15 FF FF 12 75 FF F2 00 00 10 21 3C 14 ?? ?? 8E 82 ?? ?? 18 40 00 D9 8E 04 ?? ?? 24 02 00 01 00 00 38 21 00 00 30 21 0? ?? ?? ?? AF A2 00 10 00 60 38 21 02 60 20 21 00 40 30 21 0? ?? ?? ?? AF A0 00 10 24 04 FF FF 10 44 01 03 8E 05 ?? ?? 0? ?? ?? ?? 02 60 20 21 04 40 01 01 02 60 20 21 24 02 0F A6 00 00 00 0C 24 02 00 01 A2 22 ?? ?? 3C 13 ?? ?? 8E 62 ?? ?? 18 40 00 E1 3C 04 ?? ?? 84 83 ?? ?? 86 42 00 00 10 43 00 79 24 42 FF FF 24 84 ?? ?? 0? ?? ?? ?? 02 40 28 21 14 40 00 78 00 00 00 00 27 B4 01 A0 02 40 20 21 27 A5 00 20 02 80 30 21 0? ?? ?? ?? A3 A0 01 A0 93 A3 01 A0 8F BC 00 18 14 60 01 0C 00 40 B0 21 0? ?? ?? ?? 00 00 20 21 00 40 A8 21 3C 02 ?? ?? 27 A4 02 38 00 00 28 21 24 06 00 80 24 42 ?? ?? 0? ?? ?? ?? AF A2 02 34 27 A5 02 30 02 80 30 21 24 04 00 0E 0? ?? ?? ?? AF A0 02 30 0? ?? ?? ?? 24 04 00 0A 8E 04 ?? ?? 27 B1 02 C0 AF A0 02 C0 24 02 00 01 24 05 00 07 02 20 30 21 AE 20 00 04 AE 20 00 08 AE 20 00 0C AE 20 00 10 AE 20 00 14 AE 20 00 18 AE 20 00 1C AE 20 00 20 0? ?? ?? ?? A7 A2 02 C0 04 40 00 A9 3C 17 ?? ?? 06 C0 00 6A 8E E4 ?? ?? 8E 62 ?? ?? 8E 65 ?? ?? 8E 04 ?? ?? 24 43 FE 80 00 62 10 2B 24 A5 FF FF 00 45 10 21 AF A0 00 10 00 40 30 21 00 60 38 21 AE 62 ?? ?? 0? ?? ?? ?? AE 63 ?? ?? 8F BC 00 18 8E 04 ?? ?? 02 40 28 21 24 06 01 80 24 02 0F A4 00 00 00 0C 10 E0 00 27 24 03 01 80 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 64 20 21 AC 82 00 00 06 C0 00 AA 00 00 90 21 8E 04 ?? ?? 24 02 00 02 24 05 00 07 02 20 30 21 0? ?? ?? ?? A7 A2 02 C0 0? ?? ?? ?? 00 00 20 21 24 04 00 0E 02 80 28 21 0? ?? ?? ?? 00 00 30 21 16 A0 00 0E 00 00 00 00 02 40 10 21 8F BF 03 14 8F BE 03 10 8F B7 03 0C 8F B6 03 08 8F B5 03 04 8F B4 03 00 8F B3 02 FC 8F B2 02 F8 8F B1 02 F4 8F B0 02 F0 03 E0 00 08 27 BD 03 18 0? ?? ?? ?? 02 A0 20 21 0? ?? ?? ?? 02 40 10 21 14 43 FF DE 8E 63 ?? ?? 8E 64 ?? ?? 24 62 01 80 00 43 18 2B 00 64 18 21 AE 63 ?? ?? 0? ?? ?? ?? AE 62 ?? ?? 30 42 FF FF 2C 42 00 04 10 40 FF 85 00 00 00 00 0? ?? ?? ?? 00 00 20 21 00 40 A8 21 3C 02 ?? ?? 27 A4 02 38 00 00 28 21 24 06 00 80 24 42 ?? ?? 27 B4 01 A0 0? ?? ?? ?? AF A2 02 34 27 A5 02 30 02 80 30 21 24 04 00 0E 27 B1 02 C0 0? ?? ?? ?? AF A0 02 30 0? ?? ?? ?? 24 04 00 0A 02 20 20 21 00 00 28 21 0? ?? ?? ?? 24 06 00 24 8E 04 ?? ?? 24 02 00 01 24 05 00 07 02 20 30 21 0? ?? ?? ?? A7 A2 02 C0 04 40 00 40 24 16 00 01 0? ?? ?? ?? 8E 62 ?? ?? 24 1E 00 02 00 00 38 21 00 00 30 21 0? ?? ?? ?? AF BE 00 10 00 40 48 21 01 20 20 21 00 60 28 21 24 07 01 80 00 00 30 21 AF A9 02 E8 0? ?? ?? ?? AF A3 02 EC 00 62 20 25 8F BC 00 18 8F A8 02 EC 14 80 00 51 8F A9 02 E8 AE 69 ?? ?? 0? ?? ?? ?? AE 68 ?? ?? 3C 13 ?? ?? 26 64 ?? ?? 0? ?? ?? ?? 00 00 28 21 8F BC 00 18 10 40 FF 0C 26 64 ?? ?? 0? ?? ?? ?? 8E 93 ?? ?? 24 05 00 01 0? ?? ?? ?? 00 00 30 21 04 40 00 0B 8E 83 ?? ?? 14 60 00 04 30 44 00 01 24 03 00 01 02 A4 18 0A AE 83 ?? ?? 04 61 FF 1D 8E 04 ?? ?? 34 46 00 01 0? ?? ?? ?? 24 05 00 02 24 03 FF FF 14 43 FF 17 8E 04 ?? ?? 24 02 0F A6 00 00 00 0C 0? ?? ?? ?? 00 00 10 21 3C 13 ?? ?? 26 64 ?? ?? 0? ?? ?? ?? 00 00 28 21 8F BC 00 18 10 40 FE ED 26 64 ?? ?? 0? ?? ?? ?? 8E 93 ?? ?? 0? ?? ?? ?? 00 00 90 21 14 40 FF 28 8E 62 ?? ?? 14 40 FF 1D 3C 04 ?? ?? 0? ?? ?? ?? 27 B4 01 A0 26 E4 ?? ?? 0? ?? ?? ?? 00 00 28 21 8F BC 00 18 14 40 FE DD 26 A4 ?? ?? 0? ?? ?? ?? 8E 93 ?? ?? 26 A4 ?? ?? 0? ?? ?? ?? 00 00 28 21 8E 83 ?? ?? 26 C4 ?? ?? 8F BC 00 18 0? ?? ?? ?? 00 62 20 0A 14 62 FE FD 00 00 00 00 02 60 20 21 24 02 0F A6 00 00 00 0C 0? ?? ?? ?? 00 00 10 21 8E 04 ?? ?? 8E 67 ?? ?? 0? ?? ?? ?? 8E 66 ?? ?? 0? ?? ?? ?? 8E 04 ?? ?? 01 03 18 23 01 03 40 2B 01 22 10 23 8E E4 ?? ?? 00 48 10 23 00 60 38 21 00 40 30 21 AE 63 ?? ?? 0? ?? ?? ?? AE 62 ?? ?? 8E E4 ?? ?? AF BE 00 10 00 00 38 21 0? ?? ?? ?? 00 00 30 21 04 41 FF 33 8F BC 00 18 0? ?? ?? ?? 00 00 90 21 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 01 90 0? ?? ?? ?? 24 E7 ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 0B AC 43 00 00 0? ?? ?? ?? 00 00 10 21 }
	condition:
		$1
}

rule file_267_0_0 {
	meta:
		name = "cfsetspeed"
		size = 232
		refs = "0004 __gnu_local_gp 0060 __libc_errno 0088 cfsetispeed 0094 cfsetospeed"
	strings:
		$1 = { 27 BD FF D8 3C 1C ?? ?? 27 9C ?? ?? AF B0 00 18 3C 02 ?? ?? 00 A0 80 21 3C 05 ?? ?? AF B2 00 20 AF BF 00 24 AF B1 00 1C AF BC 00 10 00 80 90 21 24 42 ?? ?? 24 A5 ?? ?? 8C 51 00 00 12 30 00 12 02 40 20 21 8C 43 FF FC 10 70 00 1B 24 42 00 08 14 45 FF F9 8F BF 00 24 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 8F B2 00 20 00 62 10 21 24 03 00 16 AC 43 00 00 8F B1 00 1C 8F B0 00 18 24 02 FF FF 03 E0 00 08 27 BD 00 28 0? ?? ?? ?? 02 00 28 21 02 40 20 21 0? ?? ?? ?? 02 00 28 21 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 00 00 10 21 03 E0 00 08 27 BD 00 28 0? ?? ?? ?? 02 20 28 21 02 40 20 21 0? ?? ?? ?? 02 20 28 21 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 00 00 10 21 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_268_0_0 {
	meta:
		name = "strcpy"
		size = 36
	strings:
		$1 = { 00 80 10 21 00 85 38 23 24 A5 00 01 80 A3 FF FF 00 A7 30 21 14 60 FF FC A0 C3 FF FF 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_269_0_0 {
	meta:
		name = "_IO_fflush"
		size = 432
		refs = "006c __lll_lock_wait_private 0128 _IO_flush_all 015c _Unwind_Resume"
	strings:
		$1 = { 27 BD FF D0 AF B0 00 24 AF BF 00 2C AF B1 00 28 10 80 00 45 00 80 80 21 8C 82 00 00 30 42 80 00 14 40 00 1A 00 00 00 00 7C 03 E8 3B 8C 84 00 48 24 71 8B 70 8C 82 00 08 10 51 00 11 00 00 00 00 AF A0 00 18 C0 83 00 00 14 60 00 06 24 02 00 00 24 01 00 01 E0 81 00 00 10 20 FF FA 24 02 00 01 00 00 00 0F 14 40 00 03 00 00 00 00 0? ?? ?? ?? AF A3 00 18 8E 02 00 48 00 40 20 21 AC 51 00 08 8C 82 00 04 24 42 00 01 AC 82 00 04 8E 02 00 98 8C 59 00 30 03 20 F8 09 02 00 20 21 8E 03 00 00 00 02 10 2B 30 63 80 00 14 60 00 06 00 02 88 23 8E 04 00 48 8C 82 00 04 24 42 FF FF 10 40 00 07 AC 82 00 04 8F BF 00 2C 02 20 10 21 8F B0 00 24 8F B1 00 28 03 E0 00 08 27 BD 00 30 AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF F1 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 2C 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 00 40 88 21 8E 02 00 00 30 42 80 00 14 40 00 06 00 80 88 21 8E 04 00 48 8C 83 00 04 24 63 FF FF 10 60 00 03 AC 83 00 04 0? ?? ?? ?? 02 20 20 21 AC 80 00 08 00 00 00 0F C0 83 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 63 00 02 14 60 FF F5 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_270_0_0 {
	meta:
		name = "__setgid"
		size = 112
		refs = "0000 __gnu_local_gp 0004 __nptl_setxid 005c __libc_errno"
	strings:
		$1 = { 3C 1C ?? ?? 3C 02 ?? ?? 27 BD FF C8 27 9C ?? ?? 24 42 ?? ?? AF BF 00 34 10 40 00 0A AF BC 00 10 00 80 18 21 24 02 0F CE 27 A4 00 18 AF A2 00 18 0? ?? ?? ?? AF A3 00 1C 8F BF 00 34 03 E0 00 08 27 BD 00 38 24 02 0F CE 00 00 00 0C 10 E0 FF FB 8F BF 00 34 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 64 20 21 AC 82 00 00 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_271_0_0 {
	meta:
		name = "msort_with_tmp.part.0"
		size = 828
		refs = "0188 memcpy 0208 mempcpy"
	strings:
		$1 = { 8C 87 00 00 27 BD FF B8 AF B0 00 20 00 06 80 42 72 07 18 02 2E 02 00 02 AF B7 00 3C AF B6 00 38 AF B5 00 34 AF BF 00 44 AF BE 00 40 AF B4 00 30 AF B3 00 2C AF B2 00 28 AF B1 00 24 00 80 A8 21 AF A6 00 1C AF A5 00 18 00 D0 B8 23 14 40 00 03 00 65 B0 21 0? ?? ?? ?? 02 00 30 21 2E E2 00 02 14 40 00 04 02 A0 20 21 02 C0 28 21 0? ?? ?? ?? 02 E0 30 21 8E A2 00 04 24 03 00 01 8E BE 00 10 8E B4 00 00 8E B2 00 08 10 43 00 80 8E B3 00 0C 10 40 00 64 24 03 00 02 10 43 00 1D 24 03 00 03 14 43 00 4C 00 00 00 00 12 00 00 3A 03 C0 28 21 16 E0 00 0B 8F B1 00 18 0? ?? ?? ?? 72 14 30 02 8E C2 00 00 26 F7 FF FF 26 D6 00 04 AF C2 00 00 12 00 00 2F 27 DE 00 04 12 E0 00 29 72 14 30 02 8E 24 00 00 8E C5 00 00 02 40 C8 21 03 20 F8 09 02 60 30 21 1C 40 FF F2 00 00 00 00 8E 22 00 00 26 10 FF FF 26 31 00 04 0? ?? ?? ?? AF C2 00 00 12 00 00 20 03 C0 28 21 12 E0 00 18 8F B1 00 18 02 C0 28 21 02 20 20 21 02 40 C8 21 03 20 F8 09 02 60 30 21 18 40 00 73 03 D4 28 21 02 C0 10 21 26 F7 FF FF 02 D4 B0 21 03 C5 18 2B 10 60 00 07 00 00 00 00 24 42 00 04 8C 44 FF FC 27 DE 00 04 03 C5 18 2B 14 60 FF FB AF C4 FF FC 12 00 00 08 00 00 00 00 16 E0 FF EA 00 A0 F0 21 72 14 30 02 03 C0 20 21 02 20 28 21 0? ?? ?? ?? 00 00 B8 21 8E A5 00 10 8F A3 00 1C 8F A4 00 18 8F BF 00 44 00 77 30 23 70 D4 30 02 8F BE 00 40 8F B7 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 0? ?? ?? ?? 27 BD 00 48 12 00 FF EF 03 C0 28 21 12 E0 FF E7 8F B1 00 18 02 20 20 21 02 C0 28 21 02 40 C8 21 03 20 F8 09 02 60 30 21 03 C0 20 21 02 C0 28 21 18 40 00 44 02 80 30 21 0? ?? ?? ?? 26 F7 FF FF 00 40 F0 21 16 E0 FF F3 02 D4 B0 21 0? ?? ?? ?? 72 14 30 02 12 00 FF DB 03 C0 28 21 16 E0 00 0B 8F B1 00 18 0? ?? ?? ?? 72 14 30 02 8E C2 00 00 26 F7 FF FF 26 D6 00 04 AF C2 00 00 12 00 FF D0 27 DE 00 04 12 E0 FF CA 72 14 30 02 02 20 20 21 02 C0 28 21 02 40 C8 21 03 20 F8 09 02 60 30 21 1C 40 FF F2 00 00 00 00 8E 22 00 00 26 10 FF FF 26 31 00 04 0? ?? ?? ?? AF C2 00 00 12 00 FF C1 03 C0 28 21 16 E0 00 0D 8F B1 00 18 0? ?? ?? ?? 72 14 30 02 8E C9 00 04 8E C8 00 00 26 F7 FF FF 26 D6 00 08 AF C9 00 04 AF C8 00 00 12 00 FF B4 27 DE 00 08 12 E0 FF AE 72 14 30 02 02 20 20 21 02 C0 28 21 02 40 C8 21 03 20 F8 09 02 60 30 21 1C 40 FF F0 00 00 00 00 8E 29 00 04 8E 28 00 00 26 10 FF FF 26 31 00 08 AF C9 00 04 0? ?? ?? ?? AF C8 00 00 02 20 10 21 26 10 FF FF 0? ?? ?? ?? 02 34 88 21 0? ?? ?? ?? 02 20 28 21 26 10 FF FF 00 40 F0 21 12 00 FF 9A 02 34 88 21 16 E0 FF AE 02 20 20 21 0? ?? ?? ?? 72 14 30 02 }
	condition:
		$1
}

rule file_271_1_0 {
	meta:
		name = "qsort_r"
		size = 916
		refs = "0004 __gnu_local_gp 0094 __libc_errno 00a0 malloc 015c memcpy 01d8 free 02d4 _quicksort 0310 __sysconf"
	strings:
		$1 = { 27 BD FF 98 3C 1C ?? ?? 27 9C ?? ?? AF BE 00 60 AF B1 00 44 03 A0 F0 21 2C D1 00 21 AF B7 00 5C AF B3 00 4C AF B2 00 48 AF BF 00 64 AF B6 00 58 AF B5 00 54 AF B4 00 50 AF B0 00 40 AF DC 00 18 00 C0 B8 21 00 80 98 21 AF C5 00 6C 12 20 00 71 00 E0 90 21 70 A6 80 02 2E 02 04 00 14 40 00 74 26 02 00 0E 3C 14 ?? ?? 8E 82 ?? ?? 10 40 00 A8 3C 15 ?? ?? 02 02 00 1B 00 40 01 F4 8E A3 ?? ?? 00 00 10 12 00 62 10 2B 14 40 00 8E 8F C2 00 78 02 00 20 21 8F 90 ?? ?? 7C 03 E8 3B 02 03 80 21 0? ?? ?? ?? 8E 14 00 00 AF C2 00 38 10 40 00 84 AE 14 00 00 8F C3 00 78 AF C2 00 30 24 02 00 04 AF D7 00 20 AF C2 00 24 AF D2 00 28 16 20 00 65 AF C3 00 2C 8F C2 00 6C 8F D1 00 30 00 02 28 80 02 25 88 21 02 25 A8 21 02 35 10 2B 10 40 00 A5 02 20 10 21 02 60 18 21 24 42 00 04 00 55 20 2B AC 43 FF FC 14 80 FF FC 00 77 18 21 8F C2 00 30 00 45 28 21 8F C3 00 6C 2C 62 00 02 24 03 00 04 AF C3 00 20 24 03 00 03 14 40 00 89 AF C3 00 24 8F C6 00 6C 0? ?? ?? ?? 27 C4 00 20 02 60 90 21 00 00 A0 21 00 14 10 80 02 22 10 21 8C 50 00 00 12 12 00 1D 02 A0 20 21 02 E0 30 21 0? ?? ?? ?? 02 40 28 21 02 40 20 21 0? ?? ?? ?? 02 80 30 21 00 40 80 21 02 13 18 23 00 77 00 1B 02 E0 01 F4 00 06 30 80 02 26 30 21 AC C4 00 00 02 00 28 21 02 E0 30 21 0? ?? ?? ?? 00 00 B0 12 00 16 28 80 02 25 28 21 8C A2 00 00 02 00 20 21 14 52 FF F0 02 C0 30 21 AC B0 00 00 02 00 20 21 02 A0 28 21 0? ?? ?? ?? 02 E0 30 21 8F C2 00 6C 26 94 00 01 16 82 FF DC 02 57 90 21 0? ?? ?? ?? 8F C4 00 38 03 C0 E8 21 8F BF 00 64 8F BE 00 60 8F B7 00 5C 8F B6 00 58 8F B5 00 54 8F B4 00 50 8F B3 00 4C 8F B2 00 48 8F B1 00 44 8F B0 00 40 03 E0 00 08 27 BD 00 68 8F C2 00 6C 00 02 80 C0 02 06 80 21 2E 02 04 00 10 40 FF 90 3C 14 ?? ?? 26 02 00 0E 00 02 10 C2 00 02 10 C0 03 A2 E8 23 8F C3 00 78 27 A2 00 18 AF C2 00 30 24 02 00 04 AF C0 00 38 AF D7 00 20 AF C2 00 24 AF D2 00 28 12 20 FF 9D AF C3 00 2C 32 E3 00 03 14 60 00 0B 8F C3 00 6C 32 63 00 03 14 60 00 07 00 00 00 00 12 E2 00 43 24 02 00 08 12 E2 00 3A 32 62 00 07 24 02 00 02 AF C2 00 24 8F C3 00 6C 2C 62 00 02 14 40 FF CE 27 C4 00 20 02 60 28 21 0? ?? ?? ?? 00 60 30 21 0? ?? ?? ?? 8F C4 00 38 0? ?? ?? ?? 03 C0 E8 21 8F C2 00 78 8F C5 00 6C 02 60 20 21 AF A2 00 10 02 E0 30 21 0? ?? ?? ?? 02 40 38 21 03 C0 E8 21 8F BF 00 64 8F BE 00 60 8F B7 00 5C 8F B6 00 58 8F B5 00 54 8F B4 00 50 8F B3 00 4C 8F B2 00 48 8F B1 00 44 8F B0 00 40 03 E0 00 08 27 BD 00 68 0? ?? ?? ?? 24 04 00 55 24 03 FF FF 10 43 00 11 24 43 00 03 28 44 00 00 00 64 10 0B 00 02 10 83 3C 15 ?? ?? AE A2 ?? ?? 00 00 00 0F 0? ?? ?? ?? 24 04 00 1E AE 82 ?? ?? 0? ?? ?? ?? 8F DC 00 18 8F C2 00 6C 14 40 FF 7A 02 60 90 21 0? ?? ?? ?? 00 00 00 00 3C 02 1F FF 0? ?? ?? ?? 34 42 FF FF 14 40 FF C7 24 02 00 02 24 02 00 01 0? ?? ?? ?? AF C2 00 24 0? ?? ?? ?? 02 20 28 21 0? ?? ?? ?? AF C0 00 24 }
	condition:
		$1
}

rule file_271_2_0 {
	meta:
		name = "qsort"
		size = 32
		refs = "000c qsort_r"
	strings:
		$1 = { 27 BD FF D8 AF A0 00 10 AF BF 00 24 0? ?? ?? ?? 00 00 00 00 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_272_0_0 {
	meta:
		name = "__nrand48_r"
		size = 84
		refs = "0014 __drand48_iterate"
	strings:
		$1 = { 27 BD FF D8 AF B1 00 20 AF B0 00 1C AF BF 00 24 00 80 80 21 0? ?? ?? ?? 00 C0 88 21 04 40 00 08 24 02 FF FF 96 04 00 02 96 03 00 04 00 00 10 21 00 04 20 42 00 03 1B C0 00 83 18 25 AE 23 00 00 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_273_0_0 {
	meta:
		name = "__get_sol"
		size = 136
		refs = "0064 $LC0 0068 $LC1 0080 __assert_fail 002c __PRETTY_FUNCTION__.6834"
	strings:
		$1 = { 3C 03 ?? ?? 24 63 ?? ?? 24 69 00 54 24 02 FF FF 0? ?? ?? ?? 24 08 FF FF 24 63 00 0C 10 69 00 0D 00 00 00 00 8C 66 00 00 10 C8 00 0E 3C 07 ?? ?? 8C 67 00 08 14 E5 FF F8 00 00 00 00 8C 67 00 04 10 E4 00 06 00 02 38 27 24 63 00 0C 14 69 FF F5 00 C7 10 0A 03 E0 00 08 00 00 00 00 03 E0 00 08 00 C0 10 21 3C 04 ?? ?? 3C 05 ?? ?? 27 BD FF E0 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 45 AF BF 00 1C 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_273_1_0 {
	meta:
		name = "getsourcefilter"
		size = 480
		refs = "0018 __gnu_local_gp 008c memcpy 00a0 __get_sol 00c8 __getsockopt 0118 __libc_errno 0138 free 01ac __libc_alloca_cutoff 01c0 malloc"
	strings:
		$1 = { 27 BD FF A8 AF BE 00 50 03 A0 F0 21 AF B1 00 38 8F D1 00 6C AF B0 00 34 3C 1C ?? ?? 8E 30 00 00 34 02 80 01 27 9C ?? ?? 00 10 81 C0 26 10 00 8C 02 02 10 2B AF B6 00 4C AF B5 00 48 AF B3 00 40 AF B2 00 3C AF BF 00 54 AF B4 00 44 AF DC 00 18 00 80 A8 21 00 A0 B0 21 00 C0 90 21 00 E0 98 21 10 40 00 52 AF D0 00 20 26 10 00 0E 00 10 80 C2 00 10 80 C0 03 B0 E8 23 27 B0 00 18 24 14 00 01 26 04 00 04 02 40 28 21 02 60 30 21 0? ?? ?? ?? AE 16 00 00 8E 22 00 00 96 44 00 00 02 60 28 21 0? ?? ?? ?? AE 02 00 88 24 03 FF FF 10 43 00 18 8F DC 00 18 27 C3 00 20 AF A3 00 10 02 A0 20 21 00 40 28 21 24 06 00 30 0? ?? ?? ?? 02 00 38 21 10 40 00 28 00 40 90 21 12 80 00 16 02 40 10 21 03 C0 E8 21 8F BF 00 54 8F BE 00 50 8F B6 00 4C 8F B5 00 48 8F B4 00 44 8F B3 00 40 8F B2 00 3C 8F B1 00 38 8F B0 00 34 03 E0 00 08 27 BD 00 58 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 24 12 FF FF 00 62 10 21 24 03 00 16 AC 43 00 00 16 80 FF EC 02 40 10 21 02 00 20 21 0? ?? ?? ?? AF D2 00 28 03 C0 E8 21 8F BF 00 54 8F C2 00 28 8F B6 00 4C 8F BE 00 50 8F B5 00 48 8F B4 00 44 8F B3 00 40 8F B2 00 3C 8F B1 00 38 8F B0 00 34 03 E0 00 08 27 BD 00 58 8E 03 00 84 8F C2 00 68 8F C4 00 70 26 05 00 8C AC 43 00 00 8E 02 00 88 8E 23 00 00 00 43 30 2B 00 66 10 0A 0? ?? ?? ?? 00 02 31 C0 8E 02 00 88 0? ?? ?? ?? AE 22 00 00 0? ?? ?? ?? 02 00 20 21 14 40 FF AD 26 10 00 0E 26 10 FF F2 0? ?? ?? ?? 02 00 20 21 10 40 00 03 00 40 80 21 0? ?? ?? ?? 00 00 A0 21 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_274_0_0 {
	meta:
		name = "__strfmon"
		size = 80
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_LOCALE 003c __vstrfmon_l"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 27 BD FF D0 AF A7 00 3C 00 62 10 21 8C 42 00 00 27 A3 00 3C 00 C0 38 21 AF A3 00 10 00 40 30 21 AF BF 00 2C AF BC 00 18 0? ?? ?? ?? AF A3 00 20 8F BF 00 2C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_276_0_0 {
	meta:
		name = "mknodat"
		size = 56
		refs = "0024 __xmknodat"
	strings:
		$1 = { 27 BD FF D8 00 80 18 21 00 A0 10 21 27 A4 00 38 00 C0 38 21 AF A4 00 10 00 60 28 21 24 04 00 01 AF BF 00 24 0? ?? ?? ?? 00 40 30 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_277_0_0 {
	meta:
		name = "__msync_nocancel"
		size = 28
	strings:
		$1 = { 24 02 10 30 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_277_1_0 {
	meta:
		name = "__libc_msync"
		size = 148
		refs = "0040 __libc_enable_asynccancel 006c __libc_disable_asynccancel"
	strings:
		$1 = { 7C 03 E8 3B 8C 63 8B 70 14 03 00 08 00 00 00 00 24 02 10 30 00 00 00 0C 14 E0 FF F0 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 27 BD FF D0 AF BF 00 1C AF A4 00 00 AF A5 00 04 AF A6 00 08 0? ?? ?? ?? 00 00 00 00 AF A2 00 2C 8F A4 00 00 8F A5 00 04 8F A6 00 08 24 02 10 30 00 00 00 0C AF A2 00 24 AF A7 00 28 8F A4 00 2C 0? ?? ?? ?? 00 00 00 00 8F A2 00 24 8F A7 00 28 8F BF 00 1C 14 E0 FF D6 27 BD 00 30 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_78_1_2 {
	meta:
		name = "__libc_msync"
		size = 148
		refs = "0040 __pthread_enable_asynccancel 006c __pthread_disable_asynccancel"
	strings:
		$1 = { 7C 03 E8 3B 8C 63 8B 70 14 03 00 08 00 00 00 00 24 02 10 30 00 00 00 0C 14 E0 FF F0 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 27 BD FF D0 AF BF 00 1C AF A4 00 00 AF A5 00 04 AF A6 00 08 0? ?? ?? ?? 00 00 00 00 AF A2 00 2C 8F A4 00 00 8F A5 00 04 8F A6 00 08 24 02 10 30 00 00 00 0C AF A2 00 24 AF A7 00 28 8F A4 00 2C 0? ?? ?? ?? 00 00 00 00 8F A2 00 24 8F A7 00 28 8F BF 00 1C 14 E0 FF D6 27 BD 00 30 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_278_0_0 {
	meta:
		name = "__sendmsg_nocancel"
		size = 28
	strings:
		$1 = { 24 02 10 53 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_278_1_0 {
	meta:
		name = "__libc_sendmsg"
		size = 148
		refs = "0040 __libc_enable_asynccancel 006c __libc_disable_asynccancel"
	strings:
		$1 = { 7C 03 E8 3B 8C 63 8B 70 14 03 00 08 00 00 00 00 24 02 10 53 00 00 00 0C 14 E0 FF F0 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 27 BD FF D0 AF BF 00 1C AF A4 00 00 AF A5 00 04 AF A6 00 08 0? ?? ?? ?? 00 00 00 00 AF A2 00 2C 8F A4 00 00 8F A5 00 04 8F A6 00 08 24 02 10 53 00 00 00 0C AF A2 00 24 AF A7 00 28 8F A4 00 2C 0? ?? ?? ?? 00 00 00 00 8F A2 00 24 8F A7 00 28 8F BF 00 1C 14 E0 FF D6 27 BD 00 30 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_73_1_2 {
	meta:
		name = "__libc_sendmsg"
		size = 148
		refs = "0040 __pthread_enable_asynccancel 006c __pthread_disable_asynccancel"
	strings:
		$1 = { 7C 03 E8 3B 8C 63 8B 70 14 03 00 08 00 00 00 00 24 02 10 53 00 00 00 0C 14 E0 FF F0 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 27 BD FF D0 AF BF 00 1C AF A4 00 00 AF A5 00 04 AF A6 00 08 0? ?? ?? ?? 00 00 00 00 AF A2 00 2C 8F A4 00 00 8F A5 00 04 8F A6 00 08 24 02 10 53 00 00 00 0C AF A2 00 24 AF A7 00 28 8F A4 00 2C 0? ?? ?? ?? 00 00 00 00 8F A2 00 24 8F A7 00 28 8F BF 00 1C 14 E0 FF D6 27 BD 00 30 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_279_0_0 {
	meta:
		name = "mkostemps64"
		size = 56
		refs = "0008 __gen_tempname 0010 __gnu_local_gp 0020 __libc_errno"
	strings:
		$1 = { 04 A0 00 03 34 C6 20 00 0? ?? ?? ?? 00 00 38 21 3C 1C ?? ?? 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 16 AC 43 00 00 03 E0 00 08 24 02 FF FF }
	condition:
		$1
}

rule file_281_0_0 {
	meta:
		name = "posix_spawnattr_setflags"
		size = 40
	strings:
		$1 = { 7C 05 2E 20 24 03 FF 80 00 A3 18 24 10 60 00 03 24 02 00 16 03 E0 00 08 00 00 00 00 A4 85 00 00 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_282_0_0 {
	meta:
		name = "__fdelt_chk"
		size = 36
		refs = "001c __chk_fail"
	strings:
		$1 = { 2C 82 04 00 10 40 00 03 00 04 11 43 03 E0 00 08 00 00 00 00 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_283_0_0 {
	meta:
		name = "__wmemcpy_chk"
		size = 36
		refs = "000c memcpy 001c __chk_fail"
	strings:
		$1 = { 00 E6 38 2B 14 E0 00 03 00 00 00 00 0? ?? ?? ?? 00 06 30 80 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_1002_0_0 {
	meta:
		name = "__wmemmove_chk"
		size = 36
		refs = "000c memmove 001c __chk_fail"
	strings:
		$1 = { 00 E6 38 2B 14 E0 00 03 00 00 00 00 0? ?? ?? ?? 00 06 30 80 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_1055_0_0 {
	meta:
		name = "__wmempcpy_chk"
		size = 36
		refs = "000c mempcpy 001c __chk_fail"
	strings:
		$1 = { 00 E6 38 2B 14 E0 00 03 00 00 00 00 0? ?? ?? ?? 00 06 30 80 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_284_0_0 {
	meta:
		name = "strcspn"
		size = 112
		refs = "003c strchr"
	strings:
		$1 = { 27 BD FF D8 AF B0 00 18 AF BF 00 24 AF B2 00 20 AF B1 00 1C 80 83 00 00 10 60 00 13 00 80 80 21 00 A0 90 21 0? ?? ?? ?? 00 00 88 21 82 03 00 00 10 60 00 06 26 31 00 01 00 60 28 21 0? ?? ?? ?? 02 40 20 21 10 40 FF F9 26 10 00 01 8F BF 00 24 02 20 10 21 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 0? ?? ?? ?? 00 00 88 21 }
	condition:
		$1
}

rule file_285_0_0 {
	meta:
		name = "__vwprintf_chk"
		size = 540
		refs = "0008 stdout 00b4 _IO_vfwprintf 0138 __lll_lock_wait_private 01c8 _Unwind_Resume"
	strings:
		$1 = { 27 BD FF C0 AF B1 00 28 3C 11 ?? ?? AF B0 00 24 8E 30 ?? ?? AF B4 00 34 AF B3 00 30 8E 02 00 00 AF B2 00 2C AF BF 00 3C 30 42 80 00 AF B5 00 38 00 80 98 21 00 A0 A0 21 14 40 00 3D 00 C0 90 21 7C 03 E8 3B 8E 02 00 48 24 75 8B 70 8C 43 00 08 10 75 00 10 02 00 20 21 AF A0 00 18 C0 45 00 00 14 A0 00 06 24 03 00 00 24 01 00 01 E0 41 00 00 10 20 FF FA 24 03 00 01 00 00 00 0F 10 60 00 2E 00 40 20 21 8E 03 00 48 8E 24 ?? ?? 00 60 10 21 AC 75 00 08 8C 43 00 04 24 63 00 01 AC 43 00 04 1A 60 00 04 02 80 28 21 8C 82 00 3C 34 42 00 04 AC 82 00 3C 0? ?? ?? ?? 02 40 30 21 1A 60 00 06 00 40 90 21 8E 22 ?? ?? 24 03 FF FB 8C 44 00 3C 00 83 18 24 AC 43 00 3C 8E 04 00 3C 8E 02 00 00 24 03 FF EB 00 83 18 24 30 42 80 00 14 40 00 06 AE 03 00 3C 8E 04 00 48 8C 82 00 04 24 42 FF FF 10 40 00 11 AC 82 00 04 8F BF 00 3C 02 40 10 21 8F B5 00 38 8F B4 00 34 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 40 0? ?? ?? ?? 02 00 20 21 0? ?? ?? ?? AF A5 00 18 0? ?? ?? ?? 8E 03 00 48 AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF E7 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 3C 8E 05 00 3C 8E 02 00 00 24 03 FF EB 00 A3 18 24 30 42 80 00 00 80 88 21 14 40 00 06 AE 03 00 3C 8E 04 00 48 8C 83 00 04 24 63 FF FF 10 60 00 03 AC 83 00 04 0? ?? ?? ?? 02 20 20 21 AC 80 00 08 00 00 00 0F C0 83 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 63 00 02 14 60 FF F5 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_452_0_0 {
	meta:
		name = "___vprintf_chk"
		size = 540
		refs = "0008 stdout 00b4 vfprintf 0138 __lll_lock_wait_private 01c8 _Unwind_Resume"
	strings:
		$1 = { 27 BD FF C0 AF B1 00 28 3C 11 ?? ?? AF B0 00 24 8E 30 ?? ?? AF B4 00 34 AF B3 00 30 8E 02 00 00 AF B2 00 2C AF BF 00 3C 30 42 80 00 AF B5 00 38 00 80 98 21 00 A0 A0 21 14 40 00 3D 00 C0 90 21 7C 03 E8 3B 8E 02 00 48 24 75 8B 70 8C 43 00 08 10 75 00 10 02 00 20 21 AF A0 00 18 C0 45 00 00 14 A0 00 06 24 03 00 00 24 01 00 01 E0 41 00 00 10 20 FF FA 24 03 00 01 00 00 00 0F 10 60 00 2E 00 40 20 21 8E 03 00 48 8E 24 ?? ?? 00 60 10 21 AC 75 00 08 8C 43 00 04 24 63 00 01 AC 43 00 04 1A 60 00 04 02 80 28 21 8C 82 00 3C 34 42 00 04 AC 82 00 3C 0? ?? ?? ?? 02 40 30 21 1A 60 00 06 00 40 90 21 8E 22 ?? ?? 24 03 FF FB 8C 44 00 3C 00 83 18 24 AC 43 00 3C 8E 04 00 3C 8E 02 00 00 24 03 FF EB 00 83 18 24 30 42 80 00 14 40 00 06 AE 03 00 3C 8E 04 00 48 8C 82 00 04 24 42 FF FF 10 40 00 11 AC 82 00 04 8F BF 00 3C 02 40 10 21 8F B5 00 38 8F B4 00 34 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 40 0? ?? ?? ?? 02 00 20 21 0? ?? ?? ?? AF A5 00 18 0? ?? ?? ?? 8E 03 00 48 AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF E7 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 3C 8E 05 00 3C 8E 02 00 00 24 03 FF EB 00 A3 18 24 30 42 80 00 00 80 88 21 14 40 00 06 AE 03 00 3C 8E 04 00 48 8C 83 00 04 24 63 FF FF 10 60 00 03 AC 83 00 04 0? ?? ?? ?? 02 20 20 21 AC 80 00 08 00 00 00 0F C0 83 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 63 00 02 14 60 FF F5 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_288_0_0 {
	meta:
		name = "__alloc_dir"
		size = 412
		refs = "0004 __gnu_local_gp 0044 __fcntl 0078 malloc 00bc __have_o_cloexec 0168 __libc_errno"
	strings:
		$1 = { 27 BD FF D0 3C 1C ?? ?? 27 9C ?? ?? AF B2 00 24 30 B2 00 FF AF B1 00 20 AF B0 00 1C AF BF 00 2C AF B3 00 28 AF BC 00 10 00 80 80 21 16 40 00 23 00 E0 88 21 7C C6 04 C0 14 C0 00 20 02 00 20 21 24 05 00 02 0? ?? ?? ?? 24 06 00 01 04 40 00 41 8F BC 00 10 12 20 00 37 34 04 80 18 8E 22 00 58 3C 04 00 10 00 44 18 2B 14 60 00 22 34 03 80 00 24 84 00 18 3C 11 00 10 0? ?? ?? ?? 00 00 00 00 10 40 00 2E 00 00 00 00 AC 50 00 00 AC 40 00 04 AC 51 00 08 AC 40 00 0C AC 40 00 10 AC 40 00 14 8F BF 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 30 3C 13 ?? ?? 8E 62 ?? ?? 10 40 00 10 02 00 20 21 1C 40 FF E1 00 00 00 00 02 00 20 21 24 05 00 02 0? ?? ?? ?? 24 06 00 01 04 41 FF DB 8F BC 00 10 0? ?? ?? ?? 00 00 10 21 00 43 88 2B 00 51 18 0A 00 60 88 21 0? ?? ?? ?? 24 64 00 18 24 05 00 01 0? ?? ?? ?? 00 00 30 21 30 44 00 01 24 03 00 01 24 02 FF FF 00 64 10 0B 18 40 FF EB AE 62 ?? ?? 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 34 11 80 00 0? ?? ?? ?? 24 04 20 18 10 40 00 03 8F BC 00 10 0? ?? ?? ?? 24 11 20 00 00 00 10 21 12 40 FF D2 8F BF 00 2C 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 02 00 20 21 00 62 10 21 8C 45 00 00 24 02 0F A6 00 00 00 0C 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 00 10 21 00 64 20 21 0? ?? ?? ?? AC 85 00 00 }
	condition:
		$1
}

rule file_288_1_0 {
	meta:
		name = "__opendirat"
		size = 120
		refs = "0000 __gnu_local_gp 0024 __openat_nocancel 0048 __alloc_dir 0058 __libc_errno"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF E0 27 9C ?? ?? AF BF 00 1C AF BC 00 10 80 A2 00 00 10 40 00 0D 3C 06 00 09 24 C6 20 80 0? ?? ?? ?? 00 00 38 21 04 40 00 0E 8F BC 00 10 8F BF 00 1C 00 40 20 21 24 05 00 01 00 00 30 21 00 00 38 21 0? ?? ?? ?? 27 BD 00 20 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 02 AC 43 00 00 8F BF 00 1C 00 00 10 21 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_289_0_0 {
	meta:
		name = "__updwtmp"
		size = 440
		refs = "0008 $LC2 0028 strcmp 0044 $LC3 005c $LC1 0074 $LC0 007c __libc_utmp_file_functions 00b0 __access"
	strings:
		$1 = { 27 BD FF D0 AF B1 00 1C 3C 11 ?? ?? AF B2 00 20 00 A0 90 21 26 25 ?? ?? AF B0 00 18 AF BF 00 2C AF B4 00 28 AF B3 00 24 0? ?? ?? ?? 00 80 80 21 10 40 00 1E 3C 13 ?? ?? 3C 13 ?? ?? 02 00 20 21 0? ?? ?? ?? 26 65 ?? ?? 10 40 00 29 3C 14 ?? ?? 3C 14 ?? ?? 02 00 20 21 0? ?? ?? ?? 26 85 ?? ?? 10 40 00 34 26 84 ?? ?? 3C 11 ?? ?? 02 00 20 21 0? ?? ?? ?? 26 25 ?? ?? 10 40 00 3E 3C 02 ?? ?? 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B1 00 1C 02 00 20 21 02 40 28 21 8F B0 00 18 8F B2 00 20 8C 59 ?? ?? 03 20 00 08 27 BD 00 30 26 64 ?? ?? 0? ?? ?? ?? 00 00 28 21 14 40 FF DF 3C 02 ?? ?? 26 70 ?? ?? 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B1 00 1C 02 00 20 21 02 40 28 21 8F B0 00 18 8F B2 00 20 8C 59 ?? ?? 03 20 00 08 27 BD 00 30 26 84 ?? ?? 0? ?? ?? ?? 00 00 28 21 14 40 FF D4 3C 02 ?? ?? 26 90 ?? ?? 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B1 00 1C 02 00 20 21 02 40 28 21 8F B0 00 18 8F B2 00 20 8C 59 ?? ?? 03 20 00 08 27 BD 00 30 0? ?? ?? ?? 00 00 28 21 10 40 FF CA 3C 02 ?? ?? 26 30 ?? ?? 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B1 00 1C 02 00 20 21 02 40 28 21 8F B0 00 18 8F B2 00 20 8C 59 ?? ?? 03 20 00 08 27 BD 00 30 26 24 ?? ?? 0? ?? ?? ?? 00 00 28 21 26 73 ?? ?? 02 62 80 0B 3C 02 ?? ?? 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B1 00 1C 02 00 20 21 02 40 28 21 8F B0 00 18 8F B2 00 20 8C 59 ?? ?? 03 20 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_290_0_0 {
	meta:
		name = "__fchdir"
		size = 28
	strings:
		$1 = { 24 02 10 25 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_291_0_0 {
	meta:
		name = "__clock_gettime"
		size = 56
		refs = "0000 __gnu_local_gp 0020 __libc_errno"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 24 02 10 A7 00 00 00 0C 10 E0 00 07 00 00 00 00 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 64 20 21 AC 82 00 00 24 02 FF FF 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_292_0_0 {
	meta:
		name = "__assert_fail_base"
		size = 396
		refs = "0000 pthread_setcancelstate 0048 __progname 005c $LC0 0090 __asprintf 00a0 $LC2 00a8 __fxprintf 00b0 stderr 00b8 _IO_fflush 00c0 _dl_pagesize 00f0 __mmap 010c strcpy 0114 __abort_msg 013c __munmap 0144 free 014c abort 0154 $LC1 0170 errstr.10390 017c __libc_write"
	strings:
		$1 = { 3C 02 ?? ?? 27 BD FF B0 24 42 ?? ?? AF B4 00 48 AF B3 00 44 AF B2 00 40 AF B1 00 3C AF B0 00 38 AF BF 00 4C 00 80 88 21 00 A0 90 21 00 C0 98 21 00 E0 A0 21 10 40 00 04 8F B0 00 60 24 04 00 01 0? ?? ?? ?? 00 00 28 21 3C 02 ?? ?? 8C 46 ?? ?? 80 C3 00 00 10 60 00 3F 00 00 00 00 3C 07 ?? ?? 12 00 00 3F 24 E7 ?? ?? 3C 03 ?? ?? 24 63 ?? ?? AF A3 00 1C 27 A3 00 30 AF B3 00 10 AF B4 00 14 AF B0 00 18 AF B2 00 20 AF A3 00 24 27 A4 00 34 0? ?? ?? ?? 02 20 28 21 04 40 00 35 8F A6 00 34 3C 05 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 00 00 20 21 3C 02 ?? ?? 8C 44 ?? ?? 0? ?? ?? ?? 24 11 FF FF 3C 02 ?? ?? 8C 43 ?? ?? 8F A2 00 30 AF B1 00 10 00 03 20 23 00 62 10 21 00 44 10 24 AF A0 00 14 00 00 20 21 00 40 28 21 24 06 00 03 24 07 08 02 0? ?? ?? ?? AF A2 00 30 10 51 00 12 00 40 80 21 24 44 00 04 8F A2 00 30 8F A5 00 34 0? ?? ?? ?? AE 02 00 00 3C 02 ?? ?? 24 42 ?? ?? C0 44 00 00 02 00 08 21 E0 41 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 10 80 00 03 00 00 00 00 0? ?? ?? ?? 8C 85 00 00 0? ?? ?? ?? 8F A4 00 34 0? ?? ?? ?? 00 00 00 00 3C 07 ?? ?? 16 00 FF C3 24 E7 ?? ?? 3C 10 ?? ?? 26 10 ?? ?? 0? ?? ?? ?? 02 00 18 21 3C 05 ?? ?? 24 04 00 02 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 12 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_292_1_0 {
	meta:
		name = "__assert_fail"
		size = 88
		refs = "0014 _libc_intl_domainname 0018 $LC3 0038 __dcgettext 0050 __assert_fail_base"
	strings:
		$1 = { 27 BD FF C8 AF B2 00 2C AF B1 00 28 00 80 90 21 00 A0 88 21 3C 04 ?? ?? 3C 05 ?? ?? AF B0 00 24 24 84 ?? ?? 00 C0 80 21 24 A5 ?? ?? 24 06 00 05 AF B3 00 30 AF BF 00 34 0? ?? ?? ?? 00 E0 98 21 00 40 20 21 AF B3 00 10 02 40 28 21 02 20 30 21 0? ?? ?? ?? 02 00 38 21 }
	condition:
		$1
}

rule file_295_0_0 {
	meta:
		name = "getpgrp"
		size = 16
	strings:
		$1 = { 24 02 0F E1 00 00 00 0C 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_296_0_0 {
	meta:
		name = "__lll_lock_wait_private"
		size = 92
	strings:
		$1 = { 8C 83 00 00 27 BD FF F8 24 02 00 02 AF B0 00 04 14 62 00 07 00 80 80 21 7C 03 E8 3B 24 06 00 02 8C 65 8B 78 00 00 38 21 24 02 10 8E 00 00 00 0C C2 02 00 00 24 01 00 02 E2 01 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 FF F3 02 00 20 21 8F B0 00 04 03 E0 00 08 27 BD 00 08 }
	condition:
		$1
}

rule file_297_0_0 {
	meta:
		name = "setegid"
		size = 168
		refs = "0000 __gnu_local_gp 0020 __nptl_setxid 005c __libc_errno"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF C8 27 9C ?? ?? 24 02 FF FF 00 80 28 21 AF BF 00 34 10 82 00 0E AF BC 00 10 3C 03 ?? ?? 24 63 ?? ?? 10 60 00 12 24 03 10 5E 27 A4 00 18 AF A3 00 18 AF A2 00 1C AF A5 00 20 0? ?? ?? ?? AF A2 00 24 8F BF 00 34 03 E0 00 08 27 BD 00 38 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 16 AC 43 00 00 0? ?? ?? ?? 24 02 FF FF 24 04 FF FF 24 06 FF FF 24 02 10 5E 00 00 00 0C 10 E0 FF F1 8F BF 00 34 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 64 20 21 AC 82 00 00 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_299_0_0 {
	meta:
		name = "__printf_fphex"
		size = 5276
		refs = "000c __gnu_local_gp 0064 _nl_current_LC_NUMERIC 00a0 __isnan 00b8 __libc_tsd_CTYPE_B 00e0 $LC6 00e4 $LC7 0128 _IO_padn 01fc _IO_wpadn 0240 _nl_current_LC_MONETARY 0260 __isinf 02a0 $LC0 02a4 $LC1 0360 $LC4 0364 $LC5 0378 __signbit 03a4 _itowa 03cc _itoa 053c _itoa_word 0554 _itowa_lower_digits 0600 strlen 029c $LC2 0a48 $LC3 0a98 __overflow 0f08 __libc_tsd_CTYPE_TOLOWER 0084 $LC8 1070 $LC9 1084 __assert_fail 1074 __PRETTY_FUNCTION__.11976 1098 __woverflow"
	strings:
		$1 = { 27 BD FE D0 AF B7 01 24 8C B7 00 0C 3C 1C ?? ?? 27 9C ?? ?? 7E EA 05 40 7E E2 05 C0 AF BE 01 28 AF B6 01 20 AF B2 01 10 AF B0 01 08 AF BF 01 2C AF B5 01 1C AF B4 01 18 AF B3 01 14 AF B1 01 0C AF BC 00 18 00 A0 F0 21 00 80 80 21 8C B6 00 00 8C B2 00 04 7C 03 E8 3B 14 40 00 78 AF AA 00 E0 00 60 10 21 8F 83 ?? ?? 00 62 10 21 8C 42 00 00 8C 42 00 00 8C 54 00 24 8C 55 00 30 82 82 00 00 10 40 03 FB 3C 04 ?? ?? 12 A0 03 FA 3C 05 ?? ?? 8C C2 00 00 8C 53 00 04 8C 51 00 00 02 60 28 21 0? ?? ?? ?? 02 20 20 21 10 40 00 6C 8F BC 00 18 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 8F C4 00 08 00 62 10 21 8C 43 00 00 00 04 10 40 00 62 10 21 94 42 00 00 30 42 00 01 14 40 00 A1 00 11 8F C2 3C 15 ?? ?? 3C 16 ?? ?? 26 B5 ?? ?? 26 D6 ?? ?? 16 20 00 72 3C 02 0A 00 02 E2 10 24 14 40 00 6F 00 00 00 00 7E F7 06 80 16 E0 00 70 26 52 FF FD 1A 40 00 6E 8F AA 00 E0 02 00 20 21 24 05 00 20 15 40 02 45 02 40 30 21 0? ?? ?? ?? 02 40 A0 21 14 52 02 63 00 00 00 00 12 20 00 66 00 00 00 00 8F AA 00 E0 11 40 02 1F 00 00 00 00 8E 02 00 5C 10 40 03 D7 02 00 20 21 8C 43 00 10 8C 44 00 14 00 64 20 2B 10 80 03 D1 24 64 00 04 AC 44 00 10 24 02 00 2D AC 62 00 00 26 94 00 01 8F AA 00 E0 11 40 00 67 02 C0 88 21 26 91 00 03 02 80 98 21 8E 02 00 5C 26 B5 00 04 10 40 03 BF 8E A5 FF FC 8C 43 00 10 8C 44 00 14 00 64 20 2B 10 80 03 BA 24 66 00 04 24 A4 00 01 AC 46 00 10 2C 82 00 01 AC 65 00 00 14 40 02 3E 26 73 00 01 16 71 FF F0 00 00 00 00 8F C3 00 0C 7C 63 06 80 10 60 00 0B 02 60 10 21 1A 40 00 09 8F AA 00 E0 02 00 20 21 24 05 00 20 11 40 02 0C 02 40 30 21 0? ?? ?? ?? 00 00 00 00 14 52 02 2E 02 62 10 21 8F BF 01 2C 8F BE 01 28 8F B7 01 24 8F B6 01 20 8F B5 01 1C 8F B4 01 18 8F B3 01 14 8F B2 01 10 8F B1 01 0C 8F B0 01 08 03 E0 00 08 27 BD 01 30 00 60 10 21 8F 83 ?? ?? 00 62 10 21 8C 42 00 00 8C 42 00 00 8C 54 00 2C 0? ?? ?? ?? 8C 55 00 D0 02 20 20 21 0? ?? ?? ?? 02 60 28 21 10 40 00 42 8F BC 00 18 8F 85 ?? ?? 7C 03 E8 3B 00 60 20 21 00 A4 20 21 8F C3 00 08 8C 84 00 00 00 03 18 40 00 83 18 21 94 63 00 00 30 63 00 01 10 60 01 EB 3C 15 ?? ?? 3C 15 ?? ?? 3C 16 ?? ?? 26 B5 ?? ?? 26 D6 ?? ?? 00 02 8F C2 12 20 FF 90 3C 02 0A 00 26 52 FF FF 7E F7 06 80 12 E0 FF 92 26 52 FF FD 16 20 FF 9C 00 00 A0 21 8F C2 00 0C 7C 43 06 40 10 60 01 C2 7C 42 06 C0 8F AA 00 E0 11 40 01 DC 00 00 00 00 8E 02 00 5C 10 40 03 87 02 00 20 21 8C 43 00 10 8C 44 00 14 00 64 20 2B 10 80 03 81 24 64 00 04 AC 44 00 10 24 02 00 2B 0? ?? ?? ?? AC 62 00 00 26 D5 00 03 24 17 FF FF 8E 02 00 14 8E 03 00 18 26 31 00 01 00 43 18 2B 10 60 03 65 82 25 FF FF 24 43 00 01 AE 03 00 14 A0 45 00 00 02 36 98 23 16 35 FF F5 02 74 98 21 0? ?? ?? ?? 8F C3 00 0C 3C 15 ?? ?? 3C 16 ?? ?? 26 B5 ?? ?? 0? ?? ?? ?? 26 D6 ?? ?? 02 20 20 21 0? ?? ?? ?? 02 60 28 21 8F C3 00 08 7E 37 98 00 02 E0 20 21 38 63 00 41 2C 63 00 01 02 60 28 21 27 A6 00 A0 24 07 00 10 AF A3 00 10 0? ?? ?? ?? AF A2 00 E4 8F C3 00 08 02 E0 20 21 02 60 28 21 38 63 00 41 2C 63 00 01 AF A3 00 10 27 A6 00 C0 24 07 00 10 0? ?? ?? ?? AF A2 01 00 8F A8 01 00 27 A3 00 6C 8F BC 00 18 00 68 20 2B 10 80 00 13 00 40 48 21 24 02 00 03 00 43 10 23 25 03 FF FC 00 62 10 21 00 02 10 82 00 02 20 27 00 04 20 80 01 04 40 21 24 05 00 30 0? ?? ?? ?? 01 20 20 21 24 63 FF FC 24 84 FF FF AC 65 00 00 14 68 FF FC A0 85 00 00 00 02 10 27 01 22 48 21 3C 04 7F F0 00 91 20 24 24 0C 00 30 02 F3 10 25 24 03 00 31 7E 31 55 00 00 64 60 0B 16 20 01 B1 2C 42 00 01 14 40 01 FF 00 00 B8 21 24 0A 00 01 24 17 03 FE AF AA 00 E8 8F A3 00 9C 24 02 00 30 14 62 02 E7 27 A2 00 A0 27 AD 00 C0 24 04 00 30 24 42 FF FC 8C 43 FF FC 10 64 FF FD 25 AD FF FF 24 02 FF FF 12 C2 02 45 01 A9 10 23 02 C2 18 2A 10 60 00 1D 00 00 00 00 1A C0 02 D7 01 80 18 21 01 36 20 21 80 83 FF FF 30 65 00 FF 24 A6 FF BF 2C C6 00 06 10 C0 02 7F 80 84 00 00 24 65 FF C9 30 83 00 FF 24 66 FF BF 2C C6 00 06 10 C0 02 74 24 63 FF 9F 24 83 FF C9 30 64 00 07 14 80 00 03 24 06 00 01 26 C6 00 01 00 C2 30 2A 28 63 00 08 14 60 00 05 30 A5 00 01 14 A0 02 7D 26 C2 FF FF 14 C0 02 7B 00 00 00 00 27 B1 00 D9 02 20 28 21 24 06 00 0A 02 E0 20 21 00 00 38 21 AF A8 01 00 AF A9 00 FC AF AC 00 F4 0? ?? ?? ?? AF AD 00 F8 8F AD 00 F8 8F AC 00 F4 8F A9 00 FC 8F A8 01 00 3C 06 ?? ?? 3C 05 CC CC 00 40 70 21 27 B3 00 D4 24 C6 ?? ?? 34 A5 CC CD 02 E5 00 19 26 73 FF FC 00 00 18 10 00 03 18 C2 00 03 20 40 00 03 10 C0 00 82 10 21 02 E2 B8 23 00 17 B8 80 00 D7 B8 21 8E E4 00 00 00 60 B8 21 14 60 FF F3 AE 64 00 00 8F AA 00 E4 01 D1 18 23 8F D7 00 0C 15 40 00 06 24 02 FF FC 3C 02 0A 00 02 E2 10 24 00 02 10 2B 24 04 FF FD 00 82 10 23 00 56 10 23 24 42 FF FE 00 62 10 21 1A C0 01 9A 00 52 90 21 8F AA 00 E0 15 40 00 0D 24 02 00 01 02 80 20 21 AF A8 01 00 AF A9 00 FC AF AC 00 F4 AF AD 00 F8 0? ?? ?? ?? AF AE 00 F0 8F AE 00 F0 8F AD 00 F8 8F AC 00 F4 8F A9 00 FC 8F A8 01 00 02 42 90 23 7E F7 06 80 16 E0 01 58 24 02 00 30 8F C3 00 10 10 62 01 55 00 00 00 00 1A 40 01 53 8F AA 00 E0 02 00 20 21 24 05 00 20 02 40 30 21 AF A8 01 00 AF A9 00 FC AF AC 00 F4 AF AD 00 F8 11 40 01 EB AF AE 00 F0 0? ?? ?? ?? 00 00 00 00 8F A8 01 00 8F A9 00 FC 8F AC 00 F4 8F AD 00 F8 8F AE 00 F0 14 52 01 0F 02 40 B8 21 8F AA 00 E4 11 40 01 40 8F AA 00 E0 11 40 01 76 02 00 20 21 8E 02 00 5C 10 40 03 2D 24 05 00 2D 8C 43 00 10 8C 44 00 14 00 64 20 2B 10 80 03 26 24 64 00 04 AC 44 00 10 24 02 00 2D AC 62 00 00 26 F7 00 01 8F AA 00 E0 11 40 01 43 00 00 00 00 8E 02 00 5C 10 40 03 01 02 00 20 21 8C 43 00 10 8C 44 00 14 00 64 20 2B 10 80 02 FB 24 64 00 04 AC 44 00 10 24 02 00 30 AC 62 00 00 8F C2 00 08 8F AA 00 E0 11 40 01 3D 24 45 00 17 8E 03 00 5C 10 60 02 E3 02 00 20 21 8C 64 00 10 8C 66 00 14 00 86 30 2B 10 C0 02 DD 24 86 00 04 24 42 00 18 AC 66 00 10 2C 42 00 01 AC 85 00 00 14 40 00 DF 24 02 FF FF 8F C2 00 0C 7C 42 06 80 14 40 00 05 26 E7 00 02 8F C3 00 10 24 02 00 30 10 62 01 BB 00 00 00 00 8F AA 00 E0 11 40 01 2C 00 00 00 00 8E 02 00 5C 10 40 03 01 02 00 20 21 8C 43 00 10 8C 44 00 14 00 64 20 2B 10 80 02 FB 24 64 00 04 AC 44 00 10 AC 6C 00 00 1A C0 01 4E 24 F7 00 01 8F AA 00 E0 15 40 00 E6 02 80 20 21 AF A8 01 00 AF A9 00 FC AF AD 00 F8 0? ?? ?? ?? AF AE 00 F0 00 40 A8 21 24 06 FF FF 8F A8 01 00 8F A9 00 FC 8F AD 00 F8 10 40 00 0D 8F AE 00 F0 8E 02 00 14 8E 03 00 18 26 94 00 01 00 43 18 2B 10 60 02 F5 82 85 FF FF 24 43 00 01 AE 03 00 14 A0 45 00 00 26 B5 FF FF 16 A0 FF F5 26 F7 00 01 1A C0 00 23 8F AA 00 E0 01 A9 10 23 02 C2 18 2A 01 2D 68 23 01 B6 A8 21 15 40 01 31 00 43 B0 0A 01 20 A0 21 24 06 FF FF 12 C0 00 0E 02 E0 18 21 8E 02 00 14 8E 03 00 18 26 94 00 01 00 43 18 2B 10 60 02 87 82 85 FF FF 24 43 00 01 AE 03 00 14 A0 45 00 00 02 89 10 23 26 D6 FF FF 16 C0 FF F4 00 57 18 21 1A A0 01 3A 02 00 20 21 24 05 00 30 02 A0 30 21 AF A3 00 EC 0? ?? ?? ?? AF AE 00 F0 8F AE 00 F0 8F A3 00 EC 14 55 00 88 00 62 B8 21 8F C5 00 08 8F AA 00 E0 11 40 01 30 24 A5 00 0F 8E 02 00 5C 10 40 02 DF 02 00 20 21 8C 43 00 10 8C 44 00 14 00 64 20 2B 10 80 02 D9 24 66 00 04 24 A4 00 01 AC 46 00 10 2C 82 00 01 AC 65 00 00 14 40 00 77 24 02 FF FF 8F AA 00 E8 24 05 00 2D 24 02 00 2B 00 4A 28 0A 8F AA 00 E0 11 40 01 23 00 00 00 00 8E 02 00 5C 10 40 02 44 02 00 20 21 8C 43 00 10 8C 44 00 14 00 64 20 2B 10 80 02 3E 24 64 00 04 AC 44 00 10 AC 65 00 00 8F AA 00 E0 26 F7 00 02 15 40 01 1F 02 2E 88 23 12 20 00 0D 24 13 FF FF 8E 02 00 14 8E 03 00 18 25 CE 00 01 00 43 18 2B 10 60 02 C0 81 C5 FF FF 24 43 00 01 AE 03 00 14 A0 45 00 00 26 31 FF FF 16 20 FF F5 26 F7 00 01 8F C3 00 0C 7C 63 06 80 10 60 FE 22 02 E0 10 21 8F C5 00 10 24 03 00 30 10 A3 FE 1E 00 00 00 00 1A 40 FE 1C 8F AA 00 E0 02 00 20 21 11 40 01 AE 02 40 30 21 0? ?? ?? ?? 00 00 00 00 14 52 00 42 02 E2 10 21 0? ?? ?? ?? 8F BF 01 2C 8E 02 00 14 8E 03 00 18 00 43 18 2B 10 60 01 C6 24 43 00 01 AE 03 00 14 24 03 00 2D 0? ?? ?? ?? A0 43 00 00 10 40 FD E5 8F AA 00 E0 11 40 00 40 00 00 00 00 8E 02 00 5C 10 40 02 18 02 00 20 21 8C 43 00 10 8C 44 00 14 00 64 20 2B 10 80 02 12 24 64 00 04 AC 44 00 10 24 02 00 20 0? ?? ?? ?? AC 62 00 00 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 02 40 A0 21 0? ?? ?? ?? 00 00 00 00 3C 16 ?? ?? 26 B5 ?? ?? 26 D6 ?? ?? 0? ?? ?? ?? 00 02 8F C2 8E 02 00 14 8E 03 00 18 00 43 18 2B 10 60 01 F6 24 43 00 01 AE 03 00 14 24 03 00 2B 0? ?? ?? ?? A0 43 00 00 02 00 20 21 24 05 00 20 AF A8 01 00 AF A9 00 FC AF AC 00 F4 AF AD 00 F8 0? ?? ?? ?? AF AE 00 F0 24 42 00 01 2C 42 00 01 8F A8 01 00 8F A9 00 FC 8F AC 00 F4 8F AD 00 F8 10 40 FF 03 8F AE 00 F0 24 02 FF FF 8F BF 01 2C 8F BE 01 28 8F B7 01 24 8F B6 01 20 8F B5 01 1C 8F B4 01 18 8F B3 01 14 8F B2 01 10 8F B1 01 0C 8F B0 01 08 03 E0 00 08 27 BD 01 30 8E 02 00 14 8E 03 00 18 00 43 18 2B 10 60 01 A0 24 43 00 01 AE 03 00 14 24 03 00 20 0? ?? ?? ?? A0 43 00 00 2A 23 03 FF 14 60 00 50 24 17 03 FF 26 37 FC 01 AF A0 00 E8 10 40 FE 50 8F A3 00 9C 24 02 FF FF 16 C2 FE 78 01 20 68 21 0? ?? ?? ?? 00 00 B0 21 8E 02 00 5C 10 40 01 7A 02 00 20 21 8C 43 00 10 8C 44 00 14 00 64 20 2B 10 80 01 74 24 65 00 04 26 A4 00 01 AC 45 00 10 2C 82 00 01 AC 75 00 00 14 40 FF D1 24 F7 00 02 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 00 00 B8 21 8F C2 00 0C 7C 43 06 40 10 60 00 3F 7C 42 06 C0 8F AA 00 E0 11 40 00 A1 02 00 20 21 8E 02 00 5C 10 40 01 E9 24 05 00 2B 8C 43 00 10 8C 44 00 14 00 64 20 2B 10 80 01 EC 02 00 20 21 24 64 00 04 AC 44 00 10 24 02 00 2B 0? ?? ?? ?? AC 62 00 00 8E 02 00 14 8E 03 00 18 00 43 18 2B 10 60 01 CE 24 43 00 01 AE 03 00 14 24 03 00 30 0? ?? ?? ?? A0 43 00 00 8E 02 00 14 8E 03 00 18 00 43 18 2B 10 60 01 FE 24 43 00 01 AE 03 00 14 0? ?? ?? ?? A0 45 00 00 8E 02 00 14 8E 03 00 18 00 43 18 2B 10 60 01 5A 24 43 00 01 AE 03 00 14 0? ?? ?? ?? A0 4C 00 00 7E E2 07 00 10 40 FE 75 8F AA 00 E0 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? AF A0 00 E8 24 0A 00 01 02 F1 B8 23 0? ?? ?? ?? AF AA 00 E8 8E 02 00 14 8E 03 00 18 00 43 18 2B 10 60 FF 82 24 05 00 2D 24 43 00 01 AE 03 00 14 24 03 00 2D 0? ?? ?? ?? A0 43 00 00 10 40 FE 8D 8F AA 00 E0 11 40 00 8F 00 00 00 00 8E 02 00 5C 10 40 01 C5 02 00 20 21 8C 43 00 10 8C 44 00 14 00 64 20 2B 10 80 01 C0 02 00 20 21 24 64 00 04 AC 44 00 10 24 02 00 20 0? ?? ?? ?? AC 62 00 00 8F C2 00 0C 7C 42 07 00 10 40 FE EF 8F AA 00 E0 0? ?? ?? ?? 00 00 00 00 12 C0 00 12 00 00 00 00 8E 02 00 5C 25 08 00 04 10 40 01 3C 8D 05 FF FC 8C 43 00 10 8C 44 00 14 00 64 20 2B 10 80 01 37 24 66 00 04 24 A4 00 01 AC 46 00 10 2C 82 00 01 AC 65 00 00 14 40 FF 63 26 D6 FF FF 16 C0 FF F0 26 F7 00 01 1A A0 01 C3 02 00 20 21 24 05 00 30 02 A0 30 21 0? ?? ?? ?? AF AE 00 F0 02 E0 18 21 0? ?? ?? ?? 8F AE 00 F0 8F C5 00 08 00 60 B8 21 24 A5 00 0F 8E 02 00 14 8E 03 00 18 00 43 18 2B 10 60 01 BF 24 43 00 01 AE 03 00 14 0? ?? ?? ?? A0 45 00 00 8E 02 00 14 8E 03 00 18 00 43 18 2B 10 60 01 82 24 43 00 01 AE 03 00 14 0? ?? ?? ?? A0 45 00 00 0? ?? ?? ?? 01 A9 B0 23 12 20 FE EF 00 00 00 00 8E 02 00 5C 26 73 00 04 10 40 01 06 8E 65 FF FC 8C 43 00 10 8C 44 00 14 00 64 20 2B 10 80 01 01 24 66 00 04 24 A4 00 01 AC 46 00 10 2C 82 00 01 AC 65 00 00 14 40 FF 32 26 31 FF FF 16 20 FF F0 26 F7 00 01 0? ?? ?? ?? 8F C3 00 0C 0? ?? ?? ?? 00 00 00 00 8F AE 00 F0 8F AD 00 F8 8F AC 00 F4 8F A9 00 FC 0? ?? ?? ?? 8F A8 01 00 8E 02 00 14 8E 03 00 18 00 43 18 2B 10 60 FF 13 24 05 00 2B 24 43 00 01 AE 03 00 14 24 03 00 2B 0? ?? ?? ?? A0 43 00 00 1A 40 FE 45 8F AA 00 E0 02 00 20 21 24 05 00 30 02 40 30 21 AF A7 00 EC AF A8 01 00 AF A9 00 FC AF AC 00 F4 AF AD 00 F8 11 40 00 67 AF AE 00 F0 0? ?? ?? ?? 00 00 00 00 8F A7 00 EC 8F A8 01 00 8F A9 00 FC 8F AC 00 F4 8F AD 00 F8 8F AE 00 F0 14 52 FF 06 00 F2 38 21 0? ?? ?? ?? 8F AA 00 E0 2C 66 00 06 24 83 FF A9 24 84 FF D0 0? ?? ?? ?? 00 86 18 0A 24 A5 FF 9F 2C A6 00 06 24 65 FF A9 24 63 FF D0 0? ?? ?? ?? 00 66 28 0A 8E 02 00 14 8E 03 00 18 00 43 18 2B 10 60 FE E4 24 43 00 01 AE 03 00 14 24 03 00 20 0? ?? ?? ?? A0 43 00 00 04 40 00 26 8F 98 ?? ?? 01 22 28 21 80 A4 00 00 24 03 00 39 10 83 00 35 00 00 00 00 7C 03 E8 3B 00 60 C8 21 03 19 C8 21 8F 26 00 00 00 04 18 80 00 C3 18 21 8C 63 00 00 28 63 00 66 14 60 00 23 26 C3 FF FE 01 23 18 21 24 0E 00 30 24 07 00 30 24 06 FF FF 0? ?? ?? ?? 24 0F 00 39 80 64 00 00 10 8F 00 22 00 60 28 21 8F 2A 00 00 00 04 88 80 01 51 88 21 8E 31 00 00 2A 31 00 66 16 20 00 13 24 63 FF FF 00 02 20 80 01 04 20 21 24 42 FF FF A0 AE 00 00 14 46 FF F1 AC 87 00 00 7C 03 E8 3B 03 03 10 21 8C 43 00 00 00 0C 10 80 00 62 10 21 8C 42 00 00 28 42 00 66 10 40 00 20 8F AA 00 E8 25 8C 00 01 0? ?? ?? ?? 7C 0C 64 20 24 84 00 01 00 02 10 80 A0 A4 00 00 01 02 10 21 8C 43 00 00 24 63 00 01 0? ?? ?? ?? AC 43 00 00 8F C3 00 08 00 02 10 80 01 02 10 21 AC 43 00 00 }
	condition:
		$1
}

rule file_300_0_0 {
	meta:
		name = "__sched_setscheduler"
		size = 28
	strings:
		$1 = { 24 02 10 40 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_301_0_0 {
	meta:
		name = "__dl_runtime_resolve"
		size = 808
		refs = "0000 _dl_mips_gnu_objects 0038 _dl_ns 0164 _dl_lookup_symbol_x 01e8 _dl_signal_error 01d8 $LC0"
	strings:
		$1 = { 3C 02 ?? ?? 8C 42 ?? ?? 27 BD FF B8 AF B0 00 30 AF BF 00 44 AF B4 00 40 AF B3 00 3C AF B2 00 38 AF B1 00 34 10 40 00 04 00 80 80 21 8C C5 80 14 04 A0 00 6F 00 00 00 00 3C 02 ?? ?? 8C 49 ?? ?? 11 20 00 65 24 04 00 01 95 23 02 2C 10 60 00 5F 8D 22 02 24 24 63 FF FF 30 63 FF FF 24 45 00 20 00 03 19 40 0? ?? ?? ?? 00 A3 28 21 24 42 00 20 10 45 00 56 00 00 00 00 8C 43 00 00 14 64 FF FB 00 00 00 00 8D 26 00 00 8C 43 00 08 00 C3 18 21 00 E3 40 2B 15 00 FF F5 8C 4A 00 14 00 6A 18 21 00 E3 18 2B 10 60 FF F2 24 42 00 20 01 20 28 21 8C A2 00 38 8C A7 00 2C 8C A4 00 34 8C 43 00 04 00 10 11 00 8C F1 00 04 00 C3 18 21 00 62 10 21 90 43 00 0D 8C 84 00 04 8C A8 00 D0 8C A7 00 F4 30 63 00 03 00 C4 20 21 00 D1 88 21 8D 13 00 04 8C F2 00 04 14 60 00 89 AF A2 00 28 8C A3 01 B8 10 60 00 0C 00 10 38 40 8C 63 00 04 00 E6 30 21 00 C3 18 21 94 63 00 00 8C A6 02 44 30 63 7F FF 00 03 19 00 00 C3 30 21 8C C3 00 04 14 60 00 4D 00 00 00 00 7C 03 E8 3B 8C 66 8B 70 14 C0 00 54 24 03 00 01 24 06 00 01 8C 42 00 00 8C A7 02 A0 AF A0 00 10 AF A6 00 14 AF A3 00 18 AF A0 00 1C 00 82 20 21 0? ?? ?? ?? 27 A6 00 28 00 40 A0 21 7C 03 E8 3B 8C 62 8B 70 14 40 00 52 00 00 00 00 8F A3 00 28 10 60 00 04 00 00 10 21 8C 63 00 04 8E 82 00 00 00 62 10 21 02 72 18 23 8F BF 00 44 00 70 18 21 00 03 18 80 02 23 88 21 AE 22 00 00 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 48 8D 29 00 0C 15 20 FF 9D 00 00 00 00 3C 07 ?? ?? 00 00 20 21 00 00 28 21 00 00 30 21 0? ?? ?? ?? 24 E7 ?? ?? 7C A5 F0 00 94 A3 02 2C 10 60 FF 8F 8C A2 02 24 24 63 FF FF 30 63 FF FF 24 46 00 20 00 03 19 40 00 C3 30 21 0? ?? ?? ?? 24 04 00 01 24 42 00 20 10 46 FF 85 00 00 00 00 8C 43 00 00 14 64 FF FB 00 00 00 00 8C A8 00 00 8C 43 00 08 01 03 18 21 00 E3 48 2B 15 20 FF F5 8C 4A 00 14 00 6A 18 21 00 E3 18 2B 10 60 FF F2 24 42 00 20 0? ?? ?? ?? 01 00 30 21 7C 03 E8 3B 8C 63 8B 70 14 60 00 0F 00 00 00 00 24 03 00 01 8C 42 00 00 8C A7 02 A0 AF A6 00 10 AF A3 00 14 0? ?? ?? ?? AF A0 00 18 7C 03 E8 3B 24 02 00 01 AC 62 8B 74 00 00 00 0F 24 03 00 05 0? ?? ?? ?? 8F A2 00 28 7C 03 E8 3B 24 02 00 01 AC 62 8B 74 00 00 00 0F 0? ?? ?? ?? 8F A2 00 28 7C 03 E8 3B 24 63 8B 74 00 00 00 0F C0 64 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 24 02 00 02 14 82 FF A5 00 00 00 00 7C 03 E8 3B 24 64 8B 74 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F A3 00 28 8C 42 00 04 0? ?? ?? ?? 00 C2 10 21 }
	condition:
		$1
}

rule file_301_2_0 {
	meta:
		name = "_dl_runtime_resolve"
		size = 92
	strings:
		$1 = { 03 80 18 21 27 BD FF D8 27 39 00 0C 03 E0 10 21 AF AF 00 24 AF A4 00 10 AF A5 00 14 AF A6 00 18 AF A7 00 1C 03 00 20 21 01 E0 28 21 00 60 30 21 0? ?? ?? ?? 00 40 38 21 8F BF 00 24 8F A4 00 10 8F A5 00 14 8F A6 00 18 8F A7 00 1C 27 BD 00 28 00 40 C8 21 03 20 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_301_3_0 {
	meta:
		name = "_dl_runtime_pltresolve"
		size = 92
		refs = "002c _dl_fixup"
	strings:
		$1 = { 27 BD FF D0 8F 8D 00 04 27 39 00 0C AF AF 00 24 AF A4 00 10 AF A5 00 14 AF A6 00 18 AF A7 00 1C AF A2 00 28 AF A3 00 2C 01 A0 20 21 0? ?? ?? ?? 00 18 28 C0 00 40 C8 21 8F BF 00 24 8F A4 00 10 8F A5 00 14 8F A6 00 18 8F A7 00 1C 8F A2 00 28 8F A3 00 2C 03 20 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_302_0_0 {
	meta:
		name = "__difftime"
		size = 80
		refs = "0010 __floatsidf 0034 __subdf3"
	strings:
		$1 = { 27 BD FF D8 AF B0 00 1C 00 A0 80 21 AF BF 00 24 0? ?? ?? ?? AF B1 00 20 02 00 20 21 00 60 88 21 0? ?? ?? ?? 00 40 80 21 00 60 38 21 02 20 28 21 02 00 20 21 0? ?? ?? ?? 00 40 30 21 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_303_0_0 {
	meta:
		name = "__correctly_grouped_prefixmb"
		size = 644
		refs = "0030 strlen"
	strings:
		$1 = { 27 BD FF D0 AF B4 00 28 AF B2 00 20 AF BF 00 2C AF B3 00 24 AF B1 00 1C AF B0 00 18 00 E0 A0 21 10 E0 00 42 00 A0 90 21 00 80 80 21 00 C0 20 21 0? ?? ?? ?? 00 C0 98 21 02 12 18 2B 10 60 00 2E 8F BF 00 2C 24 4E FF FF 26 04 FF FF 24 0F 00 7F 26 49 FF FF 01 30 10 2B 14 40 00 35 8F BF 00 2C 82 6D 00 00 0? ?? ?? ?? 02 4E 58 21 25 29 FF FF 11 24 00 2E 25 6B FF FF 81 62 FF FF 14 4D FF FB 00 00 00 00 82 62 00 01 10 40 00 0C 00 00 00 00 81 63 FF FE 14 62 FF F5 26 62 00 02 0? ?? ?? ?? 01 60 40 21 81 0A FF FD 14 6A FF F0 25 08 FF FF 80 43 00 00 14 60 FF FB 24 42 00 01 01 30 10 2B 14 40 00 1A 01 20 C8 21 82 82 00 00 02 49 18 23 24 42 00 01 10 62 00 1E 00 43 18 2A 01 20 90 21 01 22 10 21 00 43 90 0B 02 12 10 2B 14 40 FF D9 26 49 FF FF 8F BF 00 2C 02 50 10 2B 02 42 80 0A 02 00 10 21 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 30 25 6B FF FF 14 8B 00 3B 25 4A FF FF 8F BF 00 2C 02 40 10 21 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 30 02 80 C0 21 83 11 00 01 12 20 00 27 25 2B FF FF 27 18 00 01 12 2F 00 27 01 70 10 2B 06 20 00 25 00 00 00 00 14 40 00 3D 00 00 00 00 11 A0 00 35 01 2E 50 21 01 60 60 21 81 42 FF FF 14 4D 00 11 26 62 00 01 0? ?? ?? ?? 01 40 40 21 81 09 FF FE 14 69 00 0C 25 08 FF FF 80 43 00 00 14 60 FF FB 24 42 00 01 01 90 10 2B 14 40 00 2A 01 80 48 21 01 6C 58 23 11 71 FF E3 00 00 00 00 0? ?? ?? ?? 27 32 FF FF 25 8C FF FF 14 8C FF EB 25 4A FF FF 01 64 58 23 02 2B 58 2A 11 60 FF D1 8F BF 00 2C 0? ?? ?? ?? 27 32 FF FF 83 11 00 00 16 2F FF DB 01 70 10 2B 14 40 FF CA 8F BF 00 2C 11 A0 00 19 01 2E 50 21 81 42 FF FF 14 4D FF C1 26 62 00 01 0? ?? ?? ?? 01 40 40 21 81 09 FF FE 14 69 FF BC 25 08 FF FF 80 43 00 00 14 60 FF FB 24 42 00 01 01 70 10 2B 10 40 FF C3 01 60 48 21 0? ?? ?? ?? 8F BF 00 2C 01 60 60 21 01 90 10 2B 10 40 FF D8 01 60 48 21 0? ?? ?? ?? 01 69 58 23 0? ?? ?? ?? 00 00 58 21 10 40 FF B7 01 60 48 21 0? ?? ?? ?? 8F BF 00 2C }
	condition:
		$1
}

rule file_305_0_0 {
	meta:
		name = "add_pad"
		size = 176
		refs = "0064 memset"
	strings:
		$1 = { 8C 82 00 00 27 BD FF D8 24 03 00 01 AF B1 00 20 AF B0 00 1C AF BF 00 24 00 80 80 21 00 A0 88 21 10 A3 00 1A 24 44 FF F4 14 A0 00 07 8F BF 00 24 00 51 10 21 AE 02 00 00 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 24 42 FF FC 02 02 10 21 24 A6 FF FE 02 04 20 21 A0 83 00 0C 00 00 28 21 24 44 00 06 0? ?? ?? ?? A0 46 00 05 8E 02 00 00 8F BF 00 24 00 51 10 21 AE 02 00 00 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 02 04 20 21 A0 80 00 0C 8F BF 00 24 00 51 10 21 AE 02 00 00 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_305_1_0 {
	meta:
		name = "option_alloc"
		size = 280
		refs = "00a0 $LC0 00f0 $LC1 0104 __assert_fail 00f4 __PRETTY_FUNCTION__.3472"
	strings:
		$1 = { 24 C2 FF FF 27 BD FF D8 2C 48 00 02 AF B2 00 20 AF B0 00 18 AF BF 00 24 AF B1 00 1C 00 80 80 21 15 00 00 06 00 A0 90 21 24 03 00 04 10 C3 00 03 24 03 00 08 14 C3 00 28 8F BF 00 24 2C E3 00 08 10 60 00 25 8F BF 00 24 8E 04 00 00 24 83 FF F4 10 60 00 2E 24 84 00 02 00 62 18 24 00 C3 30 23 00 C2 28 24 00 A7 28 21 0? ?? ?? ?? 02 00 20 21 8E 11 00 00 02 00 20 21 02 51 18 21 24 65 FF F4 00 05 28 23 AE 03 00 00 0? ?? ?? ?? 30 A5 00 07 8E 03 00 00 24 63 FF F4 30 62 00 07 14 40 00 14 3C 04 ?? ?? 00 03 18 C2 24 63 FF FF 28 62 01 00 10 40 00 08 02 11 10 21 A2 03 00 0D 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 00 00 10 21 03 E0 00 08 27 BD 00 28 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 D4 0? ?? ?? ?? 24 E7 ?? ?? AE 04 00 00 0? ?? ?? ?? 24 03 00 02 }
	condition:
		$1
}

rule file_305_2_0 {
	meta:
		name = "get_opt_end"
		size = 96
	strings:
		$1 = { 00 A6 10 2B 10 40 00 14 00 00 00 00 90 A2 00 00 10 40 00 0E 00 00 00 00 24 A2 00 02 00 C2 10 2B 14 40 00 0D 00 00 00 00 90 A2 00 01 24 42 00 02 00 A2 28 21 00 C5 30 2B 14 C0 00 07 00 00 00 00 AC 85 00 00 03 E0 00 08 00 00 10 21 24 A5 00 01 03 E0 00 08 AC 85 00 00 03 E0 00 08 24 02 FF FF }
	condition:
		$1
}

rule file_305_3_0 {
	meta:
		name = "inet6_option_space"
		size = 20
	strings:
		$1 = { 24 84 00 09 24 02 FF F8 00 82 10 24 03 E0 00 08 24 42 00 0C }
	condition:
		$1
}

rule file_305_4_0 {
	meta:
		name = "inet6_option_init"
		size = 64
	strings:
		$1 = { 24 02 00 36 10 C2 00 05 24 02 00 0C 24 02 00 3B 14 C2 00 09 00 00 00 00 24 02 00 0C AC 82 00 00 24 02 00 29 AC 82 00 04 AC 86 00 08 00 00 10 21 03 E0 00 08 AC A4 00 00 03 E0 00 08 24 02 FF FF }
	condition:
		$1
}

rule file_305_5_0 {
	meta:
		name = "inet6_option_append"
		size = 100
		refs = "003c memcpy"
	strings:
		$1 = { 27 BD FF D8 AF B1 00 20 AF B0 00 1C AF BF 00 24 90 A2 00 00 00 A0 88 21 10 40 00 03 24 10 00 01 90 B0 00 01 26 10 00 02 0? ?? ?? ?? 02 00 28 21 10 40 00 0A 00 40 20 21 02 20 28 21 0? ?? ?? ?? 02 00 30 21 00 00 10 21 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_305_7_0 {
	meta:
		name = "inet6_option_next"
		size = 200
	strings:
		$1 = { 8C 82 00 04 27 BD FF D8 00 A0 18 21 24 05 00 29 14 45 00 25 AF BF 00 24 8C 82 00 08 24 05 00 36 10 45 00 03 24 05 00 3B 14 45 00 1F 00 00 00 00 8C 82 00 00 2C 45 00 0E 14 A0 00 1B 00 00 00 00 90 86 00 0D 24 C6 00 01 00 06 30 C0 24 C5 00 0C 00 45 10 2B 14 40 00 14 00 86 30 21 8C 65 00 00 10 A0 00 15 24 C7 00 0C 24 84 00 0E 00 A4 20 2B 14 80 00 0D 27 A8 00 18 01 00 20 21 0? ?? ?? ?? 00 E0 30 21 14 40 00 08 8F A5 00 18 AC 65 00 00 01 00 20 21 0? ?? ?? ?? 00 E0 30 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 8F BF 00 24 24 02 FF FF 03 E0 00 08 27 BD 00 28 24 85 00 0E AF A5 00 18 0? ?? ?? ?? 27 A8 00 18 }
	condition:
		$1
}

rule file_305_8_0 {
	meta:
		name = "inet6_option_find"
		size = 228
	strings:
		$1 = { 8C 82 00 04 27 BD FF D8 24 03 00 29 14 43 00 2D AF BF 00 24 8C 82 00 08 24 03 00 36 00 A0 58 21 10 43 00 04 00 C0 50 21 24 03 00 3B 14 43 00 25 00 00 00 00 8C 82 00 00 2C 43 00 0E 14 60 00 21 00 00 00 00 90 88 00 0D 25 08 00 01 00 08 40 C0 25 03 00 0C 00 43 10 2B 14 40 00 1A 00 88 40 21 8D 65 00 00 10 A0 00 1B 25 08 00 0C 24 84 00 0E 00 A4 20 2B 14 80 00 13 27 A9 00 18 01 20 20 21 0? ?? ?? ?? 01 00 30 21 14 40 00 0F 8F BF 00 24 8F A3 00 18 00 60 28 21 01 20 20 21 0? ?? ?? ?? 01 00 30 21 14 40 00 08 8F BF 00 24 90 67 00 00 14 EA FF F7 00 00 00 00 AD 63 00 00 03 E0 00 08 27 BD 00 28 8F BF 00 24 24 02 FF FF 03 E0 00 08 27 BD 00 28 24 83 00 0E AF A3 00 18 0? ?? ?? ?? 27 A9 00 18 }
	condition:
		$1
}

rule file_306_0_0 {
	meta:
		name = "wcsrchr"
		size = 32
	strings:
		$1 = { 00 00 10 21 8C 83 00 00 00 65 30 26 00 86 10 0A 14 60 FF FC 24 84 00 04 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_307_0_0 {
	meta:
		name = "__getcontext"
		size = 112
		refs = "0068 __syscall_error"
	strings:
		$1 = { 24 03 00 01 AC 83 00 28 AC 90 00 68 AC 91 00 6C AC 92 00 70 AC 93 00 74 AC 94 00 78 AC 95 00 7C AC 96 00 80 AC 97 00 84 AC 9C 00 98 AC 9D 00 9C AC 9E 00 A0 AC 9F 00 A4 AC 9F 00 20 24 07 00 10 24 86 02 68 00 00 28 21 24 04 00 01 24 02 10 63 00 00 00 0C 14 E0 00 04 00 00 00 00 00 00 10 21 03 E0 00 08 00 00 00 00 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_308_0_0 {
	meta:
		name = "__splice_nocancel"
		size = 28
	strings:
		$1 = { 24 02 10 D0 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_308_1_0 {
	meta:
		name = "splice"
		size = 172
		refs = "0054 __libc_enable_asynccancel 0084 __libc_disable_asynccancel"
	strings:
		$1 = { 7C 03 E8 3B 8C 63 8B 70 14 03 00 08 00 00 00 00 24 02 10 D0 00 00 00 0C 14 E0 FF F0 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 8F A8 00 10 8F A9 00 14 27 BD FF D0 AF A8 00 10 AF A9 00 14 AF BF 00 1C AF A4 00 00 AF A5 00 04 AF A6 00 08 AF A7 00 0C 0? ?? ?? ?? 00 00 00 00 AF A2 00 2C 8F A4 00 00 8F A5 00 04 8F A6 00 08 8F A7 00 0C 24 02 10 D0 00 00 00 0C AF A2 00 24 AF A7 00 28 8F A4 00 2C 0? ?? ?? ?? 00 00 00 00 8F A2 00 24 8F A7 00 28 8F BF 00 1C 14 E0 FF D0 27 BD 00 30 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_309_0_0 {
	meta:
		name = "__wcsrtombs"
		size = 812
		refs = "0000 __gnu_local_gp 005c _nl_current_LC_CTYPE 0098 __wcsnlen 00b4 _dl_mcount_wrapper_check 016c __wcslen 0224 $LC4 0114 $LC1 023c __assert_fail 022c __PRETTY_FUNCTION__.8870 024c __libc_errno 029c $LC0 02c8 _nl_C_LC_CTYPE 02d8 __wcsmbs_load_conv 0124 $LC3 0304 $LC2 0320 __wcsmbs_gconv_fcts_c"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FE 78 24 02 00 01 27 9C ?? ?? AF B4 01 74 AF B2 01 6C AF B0 01 64 AF BF 01 84 AF B7 01 80 AF B6 01 7C AF B5 01 78 AF B3 01 70 AF B1 01 68 AF BC 00 20 00 80 90 21 00 A0 A0 21 00 C0 80 21 AF A0 01 34 AF A2 01 38 10 E0 00 9B AF A2 01 30 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? AF A7 01 3C AF A0 01 48 00 62 10 21 8C 42 00 00 8C 51 00 00 8E 22 00 14 10 40 00 93 00 00 00 00 8C 53 00 08 12 40 00 36 8E 71 00 14 8E 95 00 00 02 00 28 21 02 50 80 21 0? ?? ?? ?? 02 A0 20 21 24 42 00 01 00 02 10 80 02 20 20 21 02 A2 A8 21 AF B0 01 2C 0? ?? ?? ?? AF B2 01 28 27 A2 00 28 AF A2 00 14 24 02 00 01 02 60 20 21 AF A0 00 10 AF A0 00 18 AF A2 00 1C 27 A5 01 28 02 80 30 21 02 20 C8 21 03 20 F8 09 02 A0 38 21 8F A3 01 28 24 04 FF FB 00 44 20 24 8F BC 00 20 14 80 00 43 00 72 80 23 90 62 FF FF 14 40 00 0A 8F BF 01 84 12 43 00 7C 3C 05 ?? ?? 8F A2 01 3C 8C 42 00 00 14 40 00 71 3C 04 ?? ?? AE 80 00 00 26 10 FF FF 8F BF 01 84 02 00 10 21 8F B7 01 80 8F B6 01 7C 8F B5 01 78 8F B4 01 74 8F B3 01 70 8F B2 01 6C 8F B1 01 68 8F B0 01 64 03 E0 00 08 27 BD 01 88 8E 90 00 00 27 B7 01 28 27 B2 00 28 0? ?? ?? ?? 02 00 20 21 8F A3 01 3C 24 42 00 01 00 02 B0 80 8C 62 00 04 8C 64 00 00 02 16 B0 21 AF A2 01 50 27 A2 01 4C AF B0 01 58 AF A4 01 4C AF A2 01 3C AF B7 01 2C 00 00 80 21 24 15 00 01 24 14 00 05 02 20 20 21 0? ?? ?? ?? AF B2 01 28 27 A2 01 54 02 60 20 21 AF A0 00 10 AF A2 00 14 AF A0 00 18 AF B5 00 1C 02 E0 28 21 27 A6 01 58 02 20 C8 21 03 20 F8 09 02 C0 38 21 8F A3 01 28 8F BC 00 20 00 72 20 23 10 54 FF EE 02 04 80 21 24 04 FF FB 00 44 20 24 10 80 00 22 00 00 00 00 24 43 FF FA 2C 63 00 02 14 60 00 0B 24 03 00 05 10 43 FF C5 8F BF 01 84 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 8B 0? ?? ?? ?? 24 E7 ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 8F BF 01 84 24 10 FF FF 00 62 10 21 24 03 00 58 AC 43 00 00 8F B7 01 80 02 00 10 21 8F B6 01 7C 8F B5 01 78 8F B4 01 74 8F B3 01 70 8F B2 01 6C 8F B1 01 68 8F B0 01 64 03 E0 00 08 27 BD 01 88 90 62 FF FF 10 40 FF A6 26 10 FF FF 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 63 0? ?? ?? ?? 24 E7 ?? ?? 3C 07 ?? ?? 0? ?? ?? ?? 24 E7 ?? ?? 3C 02 ?? ?? 24 42 ?? ?? 12 22 00 13 00 00 00 00 0? ?? ?? ?? 02 20 20 21 0? ?? ?? ?? 8E 22 00 14 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 80 0? ?? ?? ?? 24 E7 ?? ?? 3C 04 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 7F 0? ?? ?? ?? 24 E7 ?? ?? 3C 02 ?? ?? 0? ?? ?? ?? 24 42 ?? ?? }
	condition:
		$1
}

rule file_310_0_0 {
	meta:
		name = "__brk"
		size = 76
		refs = "0008 __curbrk 0024 __gnu_local_gp 0034 __libc_errno"
	strings:
		$1 = { 24 02 0F CD 00 00 00 0C 3C 03 ?? ?? 00 44 28 2B AC 62 ?? ?? 14 A0 00 03 00 00 10 21 03 E0 00 08 00 00 00 00 3C 1C ?? ?? 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 0C AC 43 00 00 03 E0 00 08 24 02 FF FF }
	condition:
		$1
}

rule file_312_0_0 {
	meta:
		name = "putw"
		size = 52
		refs = "0018 _IO_fwrite"
	strings:
		$1 = { 27 BD FF E0 00 A0 38 21 24 05 00 04 AF A4 00 20 24 06 00 01 AF BF 00 1C 0? ?? ?? ?? 27 A4 00 20 8F BF 00 1C 2C 42 00 01 00 02 10 23 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_313_0_0 {
	meta:
		name = "__wctype_l"
		size = 224
		refs = "0024 strlen 006c memcmp"
	strings:
		$1 = { 27 BD FF C8 AF B0 00 1C 00 A0 80 21 AF B5 00 30 AF B4 00 2C AF B3 00 28 AF B2 00 24 AF BF 00 34 AF B1 00 20 0? ?? ?? ?? 00 80 A0 21 8E 15 00 00 00 40 98 21 00 00 90 21 0? ?? ?? ?? 8E B0 00 4C 26 31 00 01 02 11 80 21 82 03 00 00 10 60 00 1A 26 52 00 01 0? ?? ?? ?? 02 00 20 21 16 62 FF F8 00 40 88 21 02 00 28 21 02 80 20 21 0? ?? ?? ?? 02 60 30 21 14 40 FF F3 26 31 00 01 8E A2 00 68 8F BF 00 34 8F B4 00 2C 02 42 10 21 24 42 00 08 00 02 10 80 02 A2 A8 21 8E A2 00 04 8F B3 00 28 8F B5 00 30 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 38 8F BF 00 34 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 00 00 10 21 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_314_0_0 {
	meta:
		name = "known_compare"
		size = 28
		refs = "000c strcmp"
	strings:
		$1 = { 10 85 00 04 00 00 00 00 8C 84 00 00 0? ?? ?? ?? 8C A5 00 00 03 E0 00 08 00 00 10 21 }
	condition:
		$1
}

rule file_314_1_0 {
	meta:
		name = "nss_parse_service_list"
		size = 1196
		refs = "0000 __gnu_local_gp 0008 __libc_tsd_CTYPE_B 00c8 malloc 00e8 mempcpy 0264 $LC2 0270 __strncasecmp 0280 $LC3 0350 $LC5 03cc $LC0 03e8 $LC1 040c $LC4 043c free"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 8F 82 ?? ?? 27 BD FF B0 7C 03 E8 3B AF A2 00 20 00 60 10 21 8F A3 00 20 AF B6 00 40 AF B7 00 44 00 62 10 21 8C 56 00 00 AF B1 00 2C AF BF 00 4C AF BE 00 48 AF B5 00 3C AF B4 00 38 AF B3 00 34 AF B2 00 30 AF B0 00 28 AF BC 00 10 00 80 B8 21 AF A0 00 18 27 B1 00 18 82 E2 00 00 00 02 18 40 02 C3 18 21 94 63 00 00 30 63 00 20 14 60 00 44 00 00 00 00 10 40 00 FE 24 03 00 5B 10 43 00 FC 02 E0 80 21 0? ?? ?? ?? 24 04 00 5B 94 63 00 00 30 63 00 20 14 60 00 08 00 00 00 00 10 44 00 06 00 00 00 00 26 10 00 01 82 02 00 00 00 02 18 40 14 40 FF F6 02 C3 18 21 12 F0 00 ED 02 17 90 23 0? ?? ?? ?? 26 44 00 25 10 40 00 E9 00 40 F0 21 24 42 00 24 02 E0 28 21 00 40 20 21 02 40 30 21 0? ?? ?? ?? AF C2 00 20 24 03 00 01 A0 40 00 00 AF C0 00 1C AF C0 00 04 AF C0 00 08 AF C0 00 0C AF C3 00 10 AF C3 00 14 AF C0 00 18 AF C0 00 00 82 03 00 00 00 03 10 40 02 C2 10 21 94 42 00 00 30 42 00 20 10 40 00 0A 02 00 B8 21 26 F7 00 01 82 E3 00 00 00 03 28 40 02 C5 28 21 94 A5 00 00 30 A5 00 20 14 A0 FF FA 26 F7 00 01 26 F7 FF FF 24 02 00 5B 10 62 00 10 00 00 00 00 AE 3E 00 00 03 C0 88 21 82 E2 00 00 00 02 18 40 02 C3 18 21 94 63 00 00 30 63 00 20 10 60 FF BE 00 00 00 00 0? ?? ?? ?? 26 F7 00 01 94 63 00 00 30 63 00 20 10 60 00 06 00 00 00 00 26 F7 00 01 82 E2 00 00 00 02 18 40 14 40 FF F8 02 C3 18 21 7C 03 E8 3B 00 60 20 21 8F A3 00 20 24 14 00 3D 24 15 00 5D 00 64 20 21 8C 96 00 00 38 50 00 21 2E 10 00 01 12 00 00 03 00 00 00 00 82 E2 00 01 26 F7 00 01 10 40 00 94 00 02 18 40 02 C3 18 21 94 63 00 00 30 63 00 20 14 60 00 8F 00 00 00 00 10 54 00 8D 00 00 00 00 10 55 00 8B 02 E0 98 21 0? ?? ?? ?? 26 73 00 01 94 42 00 00 30 42 00 20 14 40 00 0A 00 00 00 00 10 B4 00 08 00 00 00 00 10 B5 00 06 00 00 00 00 26 73 00 01 82 65 00 00 00 05 10 40 14 A0 FF F4 02 C2 10 21 02 77 10 23 24 03 00 07 10 43 00 5C 24 03 00 08 14 43 00 76 3C 05 ?? ?? 02 E0 20 21 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 08 10 40 00 08 00 00 90 21 3C 05 ?? ?? 02 E0 20 21 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 08 14 40 00 69 24 12 FF FE 82 62 00 00 00 02 20 40 02 C4 20 21 94 84 00 00 30 84 00 20 14 80 FF FA 26 73 00 01 14 54 00 60 26 73 FF FF 26 73 00 01 82 62 00 00 00 02 20 40 02 C4 20 21 94 84 00 00 30 84 00 20 14 80 FF FA 26 73 00 01 26 73 FF FF 10 40 00 55 02 60 20 21 10 54 00 53 00 00 00 00 14 55 00 0C 26 73 00 01 0? ?? ?? ?? 00 00 00 00 94 42 00 00 30 42 00 20 14 40 00 0A 00 00 00 00 10 B4 00 08 00 00 00 00 10 B5 00 06 00 00 00 00 26 73 00 01 82 65 00 00 00 05 10 40 14 A0 FF F4 02 C2 10 21 02 64 10 23 24 03 00 06 10 43 00 32 24 03 00 08 14 43 00 3C 02 60 B8 21 3C 05 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 08 14 40 00 36 00 00 00 00 26 44 00 02 00 04 20 80 12 00 00 14 03 C4 20 21 8C 85 00 04 AF C2 00 04 AF C2 00 08 AF C2 00 0C AF C2 00 10 AC 85 00 04 0? ?? ?? ?? 82 62 00 00 82 E2 00 00 00 02 18 40 02 C3 18 21 94 63 00 00 30 63 00 20 14 60 FF FA 26 F7 00 01 10 55 00 1D 26 F7 FF FF 0? ?? ?? ?? 82 E2 00 00 0? ?? ?? ?? AC 82 00 04 3C 05 ?? ?? 02 E0 20 21 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 07 10 40 FF AE 24 12 00 01 3C 05 ?? ?? 02 E0 20 21 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 07 14 40 00 0F 24 12 FF FF 0? ?? ?? ?? 82 62 00 00 3C 05 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 06 14 40 00 07 02 60 B8 21 0? ?? ?? ?? 24 02 00 01 AE 3E 00 00 26 F7 00 01 0? ?? ?? ?? 03 C0 88 21 0? ?? ?? ?? 03 C0 20 21 8F BF 00 4C 8F A2 00 18 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 8F BF 00 4C 8F A2 00 18 8F BE 00 48 8F B7 00 44 8F B6 00 40 8F B5 00 3C 8F B4 00 38 8F B3 00 34 8F B2 00 30 8F B1 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_314_2_0 {
	meta:
		name = "free_database_entries"
		size = 148
		refs = "0020 free 0048 __tdestroy"
	strings:
		$1 = { 27 BD FF D0 AF B3 00 28 AF BF 00 2C AF B2 00 24 AF B1 00 20 AF B0 00 1C 10 80 00 17 00 80 98 21 3C 12 ?? ?? 26 52 ?? ?? 8E 70 00 04 16 00 00 03 00 00 00 00 0? ?? ?? ?? 8E 70 00 00 8E 04 00 1C 10 80 00 03 02 40 28 21 0? ?? ?? ?? 00 00 00 00 8E 11 00 00 0? ?? ?? ?? 02 00 20 21 16 20 FF F7 02 20 80 21 8E 70 00 00 0? ?? ?? ?? 02 60 20 21 16 00 FF ED 02 00 98 21 8F BF 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_314_3_0 {
	meta:
		name = "__nss_database_lookup"
		size = 1164
		refs = "0004 __gnu_local_gp 00f0 strcmp 01e4 malloc 0200 $LC9 00dc $LC7 0220 _IO_new_fopen 0218 $LC8 026c __libc_tsd_CTYPE_B 02a0 __getline 02c4 __strchrnul 0374 strlen 03a8 memcpy 03f4 free 03fc _IO_new_fclose 0410 $LC6 0454 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF A0 3C 1C ?? ?? AF B0 00 38 3C 10 ?? ?? AF B4 00 48 AF B3 00 44 AF B2 00 40 AF B1 00 3C 27 9C ?? ?? 00 80 90 21 00 A0 98 21 00 C0 A0 21 00 E0 88 21 26 03 ?? ?? AF BF 00 5C AF BE 00 58 AF B7 00 54 AF B6 00 50 AF B5 00 4C AF BC 00 10 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 FA 00 00 00 00 8E 22 00 00 10 40 00 16 26 02 ?? ?? 00 00 00 0F C0 43 00 00 24 01 00 00 E0 41 00 00 10 20 FF FC 00 00 00 00 28 63 00 02 10 60 00 E4 00 00 10 21 8F BF 00 5C 8F BE 00 58 8F B7 00 54 8F B6 00 50 8F B5 00 4C 8F B4 00 48 8F B3 00 44 8F B2 00 40 8F B1 00 3C 8F B0 00 38 03 E0 00 08 27 BD 00 60 3C 16 ?? ?? 8E D5 ?? ?? 12 A0 00 4F 3C 04 ?? ?? 8E B6 00 00 12 C0 00 0B 00 00 00 00 8E C5 00 08 0? ?? ?? ?? 02 40 20 21 14 40 00 03 00 00 00 00 8E C2 00 04 AE 22 00 00 8E D6 00 00 16 C0 FF F7 00 00 00 00 8E 22 00 00 10 40 00 1A 00 00 00 00 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 C8 00 00 00 00 8E 22 00 00 8F BF 00 5C 8F BE 00 58 2C 42 00 01 8F B7 00 54 8F B6 00 50 8F B5 00 4C 8F B4 00 48 8F B3 00 44 8F B2 00 40 8F B1 00 3C 8F B0 00 38 00 02 10 23 03 E0 00 08 27 BD 00 60 12 60 00 11 00 00 00 00 8E B2 00 00 12 40 00 0E 00 00 00 00 8E 45 00 08 0? ?? ?? ?? 02 60 20 21 14 40 00 03 00 00 00 00 8E 42 00 04 AE 22 00 00 8E 52 00 00 16 40 FF F7 00 00 00 00 8E 22 00 00 14 40 FF D7 26 03 ?? ?? 12 80 00 90 02 80 20 21 0? ?? ?? ?? 00 00 00 00 10 40 FF D0 AE 22 00 00 0? ?? ?? ?? 24 04 00 0D 10 40 FF CC 3C 03 ?? ?? 8E 24 00 00 8C 65 ?? ?? AC 44 00 04 3C 04 ?? ?? 24 84 ?? ?? AC 45 00 00 AC 44 00 08 0? ?? ?? ?? AC 62 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 10 40 00 7E 00 40 B8 21 8C 42 00 00 24 04 00 08 34 42 80 00 0? ?? ?? ?? AE E2 00 00 AF A2 00 24 10 40 00 74 8F BC 00 10 7C 03 E8 3B 00 60 10 21 8F A3 00 24 AF A0 00 1C AF A0 00 18 AC 60 00 00 AC 60 00 04 8F 83 ?? ?? AF A0 00 20 24 1E 00 0A 00 62 18 21 AF A3 00 2C 0? ?? ?? ?? 24 15 00 3A 8E E2 00 00 30 42 00 10 14 40 00 58 00 00 00 00 27 A4 00 1C 27 A5 00 18 0? ?? ?? ?? 02 E0 30 21 04 40 00 52 8F A4 00 1C 24 42 FF FF 00 82 10 21 80 43 00 00 10 7E 00 4A 00 00 00 00 0? ?? ?? ?? 24 05 00 23 A0 40 00 00 8F A5 00 1C 80 A2 00 00 10 40 FF EB 8F A3 00 2C 8C 64 00 00 00 02 18 40 00 83 18 21 94 63 00 00 30 63 00 20 10 60 00 0B 00 00 00 00 24 A5 00 01 80 A2 00 00 00 02 18 40 00 83 18 21 94 63 00 00 30 63 00 20 14 60 FF FA 24 A5 00 01 10 40 FF DA 24 A5 FF FF 10 55 FF D8 00 A0 18 21 0? ?? ?? ?? 24 63 00 01 10 55 00 0A 00 00 00 00 24 63 00 01 80 62 00 00 00 02 30 40 10 40 FF CF 00 86 30 21 94 C6 00 00 30 C6 00 20 10 C0 FF F6 00 00 00 00 10 65 FF C9 00 A0 20 21 A0 60 00 00 24 63 00 01 AF A3 00 28 0? ?? ?? ?? AF A5 00 34 24 46 00 01 24 44 00 0D 0? ?? ?? ?? AF A6 00 30 00 40 18 21 8F A5 00 34 10 40 FF BC 8F A6 00 30 24 42 00 0C AC 62 00 08 00 40 20 21 0? ?? ?? ?? AF A3 00 30 0? ?? ?? ?? 8F A4 00 28 8F A3 00 30 AC 62 00 04 8F A2 00 20 10 40 00 04 AC 60 00 00 AC 43 00 00 0? ?? ?? ?? AF A3 00 20 8F A2 00 24 AC 43 00 00 0? ?? ?? ?? AF A3 00 20 A0 40 00 00 0? ?? ?? ?? 8F A4 00 1C 0? ?? ?? ?? 8F A4 00 1C 0? ?? ?? ?? 02 E0 20 21 8F B5 00 24 0? ?? ?? ?? AE D5 ?? ?? 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 02 E0 20 21 0? ?? ?? ?? AE C0 ?? ?? 26 04 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 10 21 0? ?? ?? ?? 26 04 ?? ?? 0? ?? ?? ?? 8E 22 00 00 26 04 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8E 22 00 00 }
	condition:
		$1
}

rule file_314_4_0 {
	meta:
		name = "__nss_configure_lookup"
		size = 404
		refs = "0004 __gnu_local_gp 004c strcmp 0074 __libc_errno 00f8 __nss_database_custom 0160 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF C0 3C 1C ?? ?? AF B4 00 34 3C 14 ?? ?? 27 9C ?? ?? 26 94 ?? ?? AF B5 00 38 AF B3 00 30 AF B2 00 2C AF B1 00 28 AF B0 00 24 AF BF 00 3C AF BC 00 10 00 80 90 21 00 A0 A8 21 02 80 88 21 00 00 80 21 24 13 00 0E 02 20 28 21 0? ?? ?? ?? 02 40 20 21 10 40 00 15 8F BC 00 10 04 40 00 03 26 10 00 01 16 13 FF F8 26 31 00 10 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 8F BF 00 3C 8F B5 00 38 00 62 10 21 24 03 00 16 AC 43 00 00 8F B4 00 34 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 24 02 FF FF 03 E0 00 08 27 BD 00 40 00 10 11 00 02 82 A0 21 8E 92 00 0C 12 40 00 20 00 00 10 21 0? ?? ?? ?? 02 A0 20 21 10 40 FF E8 8F BC 00 10 3C 11 ?? ?? 26 24 ?? ?? C0 83 00 00 24 61 00 01 E0 81 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 60 00 1B 26 24 ?? ?? 3C 03 ?? ?? 24 63 ?? ?? 02 03 80 21 AE 42 00 00 26 23 ?? ?? 24 02 00 01 A2 02 00 00 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 0F 26 24 ?? ?? 00 00 10 21 8F BF 00 3C 8F B5 00 38 8F B4 00 34 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 40 0? ?? ?? ?? AF A2 00 18 0? ?? ?? ?? 8F A2 00 18 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 10 21 }
	condition:
		$1
}

rule file_314_5_0 {
	meta:
		name = "__nss_lookup_function"
		size = 932
		refs = "0004 __gnu_local_gp 0080 __tsearch 0100 malloc 0140 strlen 015c $LC12 0194 stpcpy 01ac strcpy 01bc __libc_dlsym 0220 strcmp 0244 __tdelete 0250 free 0274 $LC10 02a0 __libc_errno 02c0 $LC11 02f4 __libc_dlopen_mode 0394 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF C0 3C 1C ?? ?? AF B0 00 18 3C 10 ?? ?? AF BE 00 38 AF B3 00 24 03 A0 F0 21 27 9C ?? ?? 00 80 98 21 26 03 ?? ?? AF BF 00 3C AF B7 00 34 AF B6 00 30 AF B5 00 2C AF B4 00 28 AF B2 00 20 AF B1 00 1C AF DC 00 10 AF C5 00 44 C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 CB 00 00 00 00 26 74 00 1C 27 D2 00 44 3C 15 ?? ?? 02 40 20 21 02 80 28 21 0? ?? ?? ?? 26 A6 ?? ?? 10 40 00 55 00 40 88 21 8C 42 00 00 10 52 00 1A 00 00 00 00 8C 51 00 04 26 03 ?? ?? 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 10 40 00 AB 26 04 ?? ?? 03 C0 E8 21 8F BF 00 3C 02 20 10 21 8F BE 00 38 8F B7 00 34 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 40 0? ?? ?? ?? 24 04 00 08 10 40 00 4C 00 40 B0 21 AE 22 00 00 8E 71 00 18 8F C2 00 44 12 20 00 32 AE C2 00 00 8E 22 00 04 10 40 00 4D 00 00 00 00 24 03 FF FF 10 43 00 27 00 00 00 00 8E 64 00 20 0? ?? ?? ?? 03 A0 90 21 8F C4 00 44 0? ?? ?? ?? 00 40 88 21 02 22 10 21 24 44 00 0E 3C 03 ?? ?? 00 04 20 C2 8C 62 ?? ?? 00 04 20 C0 24 63 ?? ?? 03 A4 E8 23 90 64 00 04 90 63 00 05 27 B1 00 10 AB A2 00 10 BA 22 00 03 A2 24 00 04 A2 23 00 05 8E 65 00 20 0? ?? ?? ?? 27 A4 00 15 24 03 00 5F A0 43 00 00 A0 40 00 01 8F C5 00 44 0? ?? ?? ?? 24 44 00 01 8E 62 00 18 02 20 28 21 0? ?? ?? ?? 8C 44 00 04 00 40 88 21 02 40 E8 21 0? ?? ?? ?? AE D1 00 04 00 00 88 21 0? ?? ?? ?? AE D1 00 04 0? ?? ?? ?? 00 00 88 21 3C 02 ?? ?? 8C 42 ?? ?? 10 40 00 59 00 00 00 00 8C 51 00 04 16 20 00 07 8E 77 00 20 0? ?? ?? ?? 24 51 00 04 8E 22 00 08 10 40 00 43 26 31 00 08 00 40 88 21 8E 24 00 00 0? ?? ?? ?? 02 E0 28 21 14 40 FF F8 00 00 00 00 0? ?? ?? ?? AE 71 00 18 AE 60 00 18 02 40 20 21 02 80 28 21 0? ?? ?? ?? 26 A6 ?? ?? 02 C0 20 21 0? ?? ?? ?? 00 00 88 21 0? ?? ?? ?? 26 03 ?? ?? 8E 64 00 20 0? ?? ?? ?? 03 A0 A8 21 24 42 00 14 00 02 20 C2 3C 02 ?? ?? 8C 43 ?? ?? 00 04 20 C0 24 42 ?? ?? 03 A4 E8 23 8C 42 00 04 8F DC 00 10 27 B1 00 10 AB A3 00 10 BA 23 00 03 AA 22 00 04 8F 94 ?? ?? BA 22 00 07 8E 65 00 20 7C 03 E8 3B 27 A4 00 17 02 83 A0 21 0? ?? ?? ?? 8E 92 00 00 3C 03 ?? ?? 8C 63 ?? ?? 24 44 00 03 3C 05 80 00 A8 43 00 00 B8 43 00 03 24 03 00 2E A0 43 00 03 24 02 00 32 A0 82 00 01 A0 80 00 02 8E 77 00 18 02 20 20 21 0? ?? ?? ?? 24 A5 00 01 AE E2 00 04 8E 62 00 18 8C 43 00 04 10 60 00 16 24 03 FF FF 8E 62 00 18 02 A0 E8 21 0? ?? ?? ?? 8C 42 00 04 0? ?? ?? ?? 24 04 00 0C 10 40 FF C3 AE 22 00 00 AC 57 00 00 8E 22 00 00 AC 40 00 04 8E 22 00 00 AC 40 00 08 8E 31 00 00 16 20 FF 76 AE 71 00 18 0? ?? ?? ?? 02 40 20 21 3C 02 ?? ?? 0? ?? ?? ?? 24 42 ?? ?? AC 43 00 04 0? ?? ?? ?? AE 92 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 03 C0 E8 21 0? ?? ?? ?? 26 04 ?? ?? 0? ?? ?? ?? 26 74 00 1C }
	condition:
		$1
}

rule file_314_6_0 {
	meta:
		name = "__nss_lookup"
		size = 272
		refs = "0028 __nss_lookup_function"
	strings:
		$1 = { 27 BD FF D0 AF B0 00 1C 00 80 80 21 8C 84 00 00 AF B3 00 28 AF B2 00 24 AF B1 00 20 AF BF 00 2C 00 E0 88 21 00 A0 90 21 0? ?? ?? ?? 00 C0 98 21 10 40 00 30 AE 22 00 00 14 40 00 14 8F BF 00 2C 8E 02 00 00 8C 43 00 08 14 60 00 17 02 40 28 21 8C 42 00 00 10 40 00 1F 00 40 20 21 0? ?? ?? ?? AE 02 00 00 14 40 FF F4 AE 22 00 00 12 60 FF F4 00 00 00 00 8E 04 00 00 0? ?? ?? ?? 02 60 28 21 10 40 FF EF AE 22 00 00 8F BF 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 00 00 10 21 03 E0 00 08 27 BD 00 30 8C 44 00 00 8F BF 00 2C 24 03 FF FF 24 02 00 01 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 00 64 10 0B 03 E0 00 08 27 BD 00 30 8F BF 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 24 02 00 01 03 E0 00 08 27 BD 00 30 12 60 FF D0 00 00 00 00 8E 04 00 00 0? ?? ?? ?? 02 60 28 21 0? ?? ?? ?? AE 22 00 00 }
	condition:
		$1
}

rule file_314_7_0 {
	meta:
		name = "__nss_next2"
		size = 336
		refs = "0054 __nss_lookup_function 0148 __libc_fatal 0144 $LC13"
	strings:
		$1 = { 27 BD FF D0 8F A2 00 44 AF B3 00 28 AF B2 00 24 AF B1 00 20 AF B0 00 1C AF BF 00 2C 00 80 80 21 00 A0 90 21 00 C0 98 21 10 40 00 28 00 E0 88 21 8C 82 00 00 24 04 00 01 8C 43 00 04 10 64 00 36 00 00 00 00 8C 44 00 00 10 80 00 19 8F BF 00 2C AE 04 00 00 0? ?? ?? ?? 02 40 28 21 10 40 00 09 AE 22 00 00 8F BF 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 00 00 10 21 03 E0 00 08 27 BD 00 30 12 60 00 06 00 00 00 00 8E 04 00 00 0? ?? ?? ?? 02 60 28 21 14 40 FF F2 AE 22 00 00 8E 02 00 00 8C 43 00 08 10 60 FF E6 8F BF 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 24 02 FF FF 03 E0 00 08 27 BD 00 30 8F A3 00 40 24 63 00 02 2C 62 00 05 10 40 00 1A 00 03 18 80 8C 82 00 00 00 43 18 21 8C 64 00 04 24 03 00 01 14 83 FF D4 00 00 00 00 24 02 00 01 8F BF 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 30 8C 44 00 08 14 83 FF C9 00 00 00 00 8C 43 00 0C 14 64 FF C6 00 00 00 00 8C 44 00 10 14 83 FF C3 00 00 00 00 0? ?? ?? ?? 24 02 00 01 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? }
	condition:
		$1
}

rule file_314_8_0 {
	meta:
		name = "free_defconfig"
		size = 32
	strings:
		$1 = { 3C 02 ?? ?? 8C 44 ?? ?? 10 80 00 03 00 00 00 00 0? ?? ?? ?? AC 40 ?? ?? 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_314_9_0 {
	meta:
		name = "free_mem"
		size = 188
		refs = "0044 free 006c __libc_dlclose"
	strings:
		$1 = { 27 BD FF D8 3C 02 ?? ?? AF B2 00 20 8C 52 ?? ?? AF BF 00 24 AF B1 00 1C 12 40 00 22 AF B0 00 18 8E 44 00 00 0? ?? ?? ?? AC 40 ?? ?? 8E 50 00 04 16 00 00 09 8F BF 00 24 0? ?? ?? ?? 8F B1 00 1C 8E 11 00 08 0? ?? ?? ?? 02 00 20 21 12 20 00 0F 8F BF 00 24 02 20 80 21 8E 04 00 04 24 82 FF FF 2C 42 FF FE 10 40 FF F6 00 00 00 00 0? ?? ?? ?? 00 00 00 00 8E 11 00 08 0? ?? ?? ?? 02 00 20 21 16 20 FF F5 02 20 80 21 8F BF 00 24 8F B1 00 1C 8F B0 00 18 02 40 20 21 8F B2 00 20 0? ?? ?? ?? 27 BD 00 28 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_314_10_0 {
	meta:
		name = "__nss_next"
		size = 48
		refs = "001c __nss_next2"
	strings:
		$1 = { 27 BD FF D8 8F A3 00 38 00 C0 10 21 AF A7 00 10 AF A3 00 14 00 00 30 21 AF BF 00 24 0? ?? ?? ?? 00 40 38 21 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_315_0_0 {
	meta:
		name = "__sleep"
		size = 700
		refs = "0000 __gnu_local_gp 005c memset 0070 __sigaction 0094 __sigprocmask 00a0 __nanosleep 0158 __libc_errno 02b4 __pthread_unwind"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FE 38 27 9C ?? ?? AF B0 01 B4 AF BF 01 C4 AF B3 01 C0 AF B2 01 BC AF B1 01 B8 AF BC 00 10 10 80 00 88 00 80 80 21 3C 13 7F FF AF A0 01 AC 00 00 18 21 36 73 FF FF 3C 12 80 00 0? ?? ?? ?? 3C 11 00 02 00 51 10 24 14 40 00 14 27 A4 01 A8 27 A4 01 28 00 00 28 21 0? ?? ?? ?? 24 06 00 80 24 04 00 12 00 00 28 21 27 A6 00 18 0? ?? ?? ?? AF B1 01 28 04 40 00 57 8F BC 00 10 8F A3 00 1C 24 02 00 01 10 62 00 24 24 04 00 03 27 A5 00 A8 0? ?? ?? ?? 00 00 30 21 27 A4 01 A8 0? ?? ?? ?? 00 80 28 21 14 40 00 35 8F A3 01 AC 12 00 00 41 8F A3 01 A8 02 12 10 2B 02 60 20 21 02 02 20 0B 00 83 10 21 00 00 28 21 27 A4 01 28 24 06 00 80 AF A2 01 A8 0? ?? ?? ?? 02 02 80 23 24 04 00 01 27 A5 01 28 27 A6 00 A8 0? ?? ?? ?? AF B1 01 28 10 40 FF D4 8F A2 00 A8 24 02 FF FF 8F BF 01 C4 8F B3 01 C0 8F B2 01 BC 8F B1 01 B8 8F B0 01 B4 03 E0 00 08 27 BD 01 C8 3C 11 7F FF 0? ?? ?? ?? 36 31 FF FF 12 00 00 3C 02 00 18 21 02 11 10 2B 02 22 18 0A 8F A2 01 AC AF A3 01 A8 02 02 80 23 27 A4 01 A8 0? ?? ?? ?? 00 80 28 21 10 40 FF F5 8F BC 00 10 8F 91 ?? ?? 7C 03 E8 3B 24 04 00 03 02 23 88 21 8E 32 00 00 27 A5 00 A8 0? ?? ?? ?? 00 00 30 21 AE 32 00 00 8F A3 01 AC 3C 02 1D CD 24 42 65 00 00 62 18 2A 8F A2 01 A8 8F BF 01 C4 38 63 00 01 00 62 10 21 00 50 10 21 8F B3 01 C0 8F B2 01 BC 8F B1 01 B8 8F B0 01 B4 03 E0 00 08 27 BD 01 C8 8F BF 01 C4 8F B3 01 C0 8F B2 01 BC 8F B1 01 B8 8F B0 01 B4 00 00 10 21 03 E0 00 08 27 BD 01 C8 8F 90 ?? ?? 7C 03 E8 3B 27 A5 00 A8 02 03 80 21 24 04 00 03 00 00 30 21 0? ?? ?? ?? 8E 11 00 00 8F BF 01 C4 AE 11 00 00 8F B3 01 C0 8F B2 01 BC 8F B1 01 B8 8F B0 01 B4 24 02 FF FF 03 E0 00 08 27 BD 01 C8 8F 90 ?? ?? 7C 03 E8 3B 24 04 00 03 02 03 80 21 8E 11 00 00 27 A5 00 A8 0? ?? ?? ?? 00 00 30 21 AE 11 00 00 0? ?? ?? ?? 00 00 10 21 7C 03 E8 3B 8C 63 8B F4 24 02 FF B9 00 62 18 24 24 02 00 08 14 62 FF D7 8F BF 01 C4 7C 03 E8 3B 24 02 FF FF AC 62 8D 90 7C 03 E8 3B 24 62 8B F4 8C 64 8B F4 34 87 00 10 AF A4 00 18 C0 45 00 00 14 A4 00 06 24 06 00 00 00 E0 08 21 E0 41 00 00 10 20 FF FA 24 06 00 01 00 00 00 0F 14 C0 00 03 00 00 00 00 0? ?? ?? ?? AF A5 00 18 0? ?? ?? ?? 8C 64 8B F0 }
	condition:
		$1
}

rule file_316_0_0 {
	meta:
		name = "posix_spawnattr_getschedparam"
		size = 28
	strings:
		$1 = { 24 84 01 08 88 83 00 00 00 00 10 21 98 83 00 03 A8 A3 00 00 03 E0 00 08 B8 A3 00 03 }
	condition:
		$1
}

rule file_317_0_0 {
	meta:
		name = "skip_string"
		size = 148
		refs = "000c __gnu_local_gp 0014 __libc_tsd_CTYPE_B"
	strings:
		$1 = { 00 80 10 21 80 84 00 00 10 80 00 20 3C 1C ?? ?? 27 9C ?? ?? 8F 86 ?? ?? 7C 03 E8 3B 00 60 28 21 00 C5 28 21 8C A5 00 00 00 04 18 40 00 A3 18 21 94 63 00 00 30 63 00 20 14 60 00 14 24 03 00 23 10 83 00 12 24 03 00 2C 10 83 00 10 24 06 00 23 0? ?? ?? ?? 24 07 00 2C 94 84 00 00 30 84 00 20 14 80 00 0A 00 00 00 00 10 66 00 08 00 00 00 00 10 67 00 06 00 00 00 00 24 42 00 01 80 43 00 00 00 03 20 40 14 60 FF F4 00 A4 20 21 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_317_1_0 {
	meta:
		name = "arg_trimdomain_list"
		size = 576
		refs = "0000 __gnu_local_gp 0010 __libc_tsd_CTYPE_B 0018 _res_hconf 0088 __strndup 017c _libc_intl_domainname 0180 $LC0 018c __dcgettext 01a8 __asprintf 01c4 __fxprintf 01bc $LC1 01cc free 0208 $LC2"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF B0 27 9C ?? ?? AF B2 00 34 8F 92 ?? ?? AF B1 00 30 3C 11 ?? ?? 26 31 ?? ?? 7C 03 E8 3B AF B5 00 40 AF B4 00 3C AF B3 00 38 AF B0 00 2C AF BF 00 4C AF B7 00 48 AF B6 00 44 AF BC 00 18 00 80 A8 21 00 A0 A0 21 00 C0 40 21 02 20 80 21 02 43 90 21 24 13 00 01 0? ?? ?? ?? 01 00 20 21 8E 36 00 18 00 40 B8 21 00 48 28 23 2A C2 00 04 10 40 00 41 26 C2 00 01 26 D6 00 06 01 00 20 21 AE 02 00 18 0? ?? ?? ?? 00 16 B0 80 02 16 B0 21 AE C2 00 04 82 E3 00 00 8E 44 00 00 00 03 10 40 00 82 10 21 94 42 00 00 30 42 00 20 10 40 00 0A 02 E0 40 21 25 08 00 01 81 03 00 00 00 03 10 40 00 82 10 21 94 42 00 00 30 42 00 20 14 40 FF FA 25 08 00 01 25 08 FF FF 24 63 FF D4 30 63 00 FF 2C 62 00 10 10 40 00 13 00 73 18 04 30 63 C0 01 10 60 00 10 00 00 00 00 81 02 00 01 0? ?? ?? ?? 25 08 00 01 81 02 00 00 00 02 18 40 00 83 18 21 94 63 00 00 30 63 00 20 14 60 FF FA 25 08 00 01 25 08 FF FF 10 40 00 36 24 03 00 23 10 43 00 34 00 00 00 00 81 02 00 00 10 40 00 04 8F BF 00 4C 24 03 00 23 14 43 FF C4 00 00 00 00 8F B7 00 48 8F B6 00 44 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 01 00 10 21 03 E0 00 08 27 BD 00 50 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 24 03 00 04 AF A3 00 10 27 A4 00 20 00 40 28 21 02 A0 30 21 0? ?? ?? ?? 02 80 38 21 04 40 00 09 8F BF 00 4C 8F A6 00 20 3C 05 ?? ?? 00 00 20 21 0? ?? ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 8F A4 00 20 8F BF 00 4C 8F B7 00 48 8F B6 00 44 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 00 00 10 21 03 E0 00 08 27 BD 00 50 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 00 40 28 21 27 A4 00 20 02 A0 30 21 0? ?? ?? ?? 02 80 38 21 04 41 FF E2 8F A6 00 20 0? ?? ?? ?? 8F BF 00 4C }
	condition:
		$1
}

rule file_317_2_0 {
	meta:
		name = "arg_spoof.isra.0"
		size = 244
		refs = "002c _res_hconf 0048 $LC4 0080 __strncasecmp 0098 $LC3"
	strings:
		$1 = { 27 BD FF D8 00 80 40 21 AF B0 00 18 AF BF 00 24 AF B2 00 20 0? ?? ?? ?? AF B1 00 1C 00 40 80 21 24 03 00 03 00 48 10 23 10 43 00 1B 3C 11 ?? ?? 26 31 ?? ?? 8E 32 00 2C 36 43 00 06 AE 23 00 2C 24 03 00 04 10 43 00 0C 3C 05 ?? ?? 24 02 FF FB 02 42 90 24 36 52 00 02 AE 32 00 2C 8F BF 00 24 02 00 10 21 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 01 00 20 21 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 04 14 40 FF F1 24 02 FF FB 0? ?? ?? ?? 8F BF 00 24 3C 05 ?? ?? 01 00 20 21 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 03 10 40 00 04 3C 11 ?? ?? 26 31 ?? ?? 0? ?? ?? ?? 8E 32 00 2C 3C 02 ?? ?? 24 42 ?? ?? 8C 44 00 2C 8F BF 00 24 24 03 FF F9 00 83 18 24 AC 43 00 2C 8F B2 00 20 02 00 10 21 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_317_3_0 {
	meta:
		name = "arg_bool"
		size = 284
		refs = "000c $LC5 0034 __strncasecmp 0044 _res_hconf 0040 $LC3 00c4 _libc_intl_domainname 00c8 $LC6 00d4 __dcgettext 00ec __asprintf 0104 __fxprintf 00fc $LC1 010c free"
	strings:
		$1 = { 27 BD FF C0 AF B2 00 34 00 A0 90 21 3C 05 ?? ?? AF B3 00 38 AF B0 00 2C 00 80 98 21 00 C0 80 21 00 C0 20 21 24 A5 ?? ?? 24 06 00 02 AF B1 00 30 AF BF 00 3C 0? ?? ?? ?? 00 E0 88 21 14 40 00 0E 3C 05 ?? ?? 3C 03 ?? ?? 24 63 ?? ?? 8C 64 00 2C 26 02 00 02 02 24 88 25 AC 71 00 2C 8F BF 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 40 02 00 20 21 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 03 14 40 00 0E 3C 03 ?? ?? 24 63 ?? ?? 8C 64 00 2C 8F BF 00 3C 00 11 88 27 02 24 88 24 26 02 00 03 8F B3 00 38 8F B2 00 34 8F B0 00 2C AC 71 00 2C 8F B1 00 30 03 E0 00 08 27 BD 00 40 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 05 00 40 28 21 AF B0 00 10 27 A4 00 20 02 60 30 21 0? ?? ?? ?? 02 40 38 21 04 40 00 07 8F A6 00 20 3C 05 ?? ?? 00 00 20 21 0? ?? ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 8F A4 00 20 0? ?? ?? ?? 00 00 10 21 }
	condition:
		$1
}

rule file_317_4_0 {
	meta:
		name = "do_init"
		size = 1032
		refs = "0008 __gnu_local_gp 000c $LC8 001c _res_hconf 0074 getenv 008c _IO_new_fopen 0088 $LC9 00a0 __libc_tsd_CTYPE_B 00d4 fgets_unlocked 00e8 __strchrnul 016c __strncasecmp 017c strlen 019c $LC16 0198 _libc_intl_domainname 01a8 __dcgettext 01c0 __asprintf 01d0 $LC1 01d8 __fxprintf 01e0 free 0200 _IO_new_fclose 0208 $LC11 0218 $LC12 0250 $LC13 0274 $LC14 0294 $LC15 03a8 $LC10 03f8 $LC7"
	strings:
		$1 = { 27 BD FE A8 3C 02 ?? ?? 3C 1C ?? ?? 3C 04 ?? ?? 27 9C ?? ?? AF B4 01 40 24 84 ?? ?? 24 54 ?? ?? AC 40 ?? ?? AF BF 01 54 AF BE 01 50 AF B7 01 4C AF B6 01 48 AF B5 01 44 AF B3 01 3C AF B2 01 38 AF B1 01 34 AF B0 01 30 AF BC 00 18 AE 80 00 04 AE 80 00 08 AE 80 00 0C AE 80 00 10 AE 80 00 14 AE 80 00 18 AE 80 00 1C AE 80 00 20 AE 80 00 24 AE 80 00 28 0? ?? ?? ?? AE 80 00 2C 10 40 00 DE AF A2 01 2C 8F A4 01 2C 3C 05 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 00 40 98 21 10 40 00 5B 8F BC 00 18 8F 95 ?? ?? 8C 44 00 00 7C 03 E8 3B 02 A3 A8 21 3C 03 ?? ?? 34 84 80 00 24 63 ?? ?? AE 64 00 00 00 00 88 21 AF B5 01 28 24 72 00 70 27 A4 00 20 24 05 01 00 0? ?? ?? ?? 02 60 30 21 10 40 00 48 00 00 00 00 27 A4 00 20 0? ?? ?? ?? 24 05 00 0A A0 40 00 00 8F A2 01 28 83 A3 00 20 8C 55 00 00 00 03 10 40 02 A2 10 21 94 42 00 00 30 42 00 20 10 40 00 AD 26 31 00 01 27 A2 00 21 80 43 00 00 00 40 F0 21 00 03 28 40 02 A5 28 21 94 A5 00 00 30 A5 00 20 14 A0 FF F9 24 42 00 01 10 60 FF E3 24 02 00 23 10 62 FF E1 00 00 00 00 0? ?? ?? ?? 03 C0 20 21 3C 16 ?? ?? 00 40 B8 21 00 5E 80 23 26 D6 ?? ?? 03 C0 20 21 02 C0 28 21 0? ?? ?? ?? 02 00 30 21 14 40 00 05 02 C0 20 21 0? ?? ?? ?? 00 00 00 00 12 02 00 59 00 00 00 00 26 D6 00 10 16 D2 FF F5 03 C0 20 21 3C 04 ?? ?? 3C 05 ?? ?? 24 A5 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 24 06 00 05 00 40 28 21 AF BE 00 10 8F A6 01 2C 27 A4 01 20 0? ?? ?? ?? 02 20 38 21 04 40 FF C0 8F A6 01 20 3C 05 ?? ?? 24 A5 ?? ?? 0? ?? ?? ?? 00 00 20 21 0? ?? ?? ?? 8F A4 01 20 27 A4 00 20 24 05 01 00 0? ?? ?? ?? 02 60 30 21 14 40 FF BA 00 00 00 00 0? ?? ?? ?? 02 60 20 21 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 10 40 00 04 3C 10 ?? ?? 0? ?? ?? ?? 00 40 20 21 3C 10 ?? ?? 0? ?? ?? ?? 26 04 ?? ?? 10 40 00 05 26 04 ?? ?? 24 05 00 01 00 40 30 21 0? ?? ?? ?? 24 07 00 10 3C 10 ?? ?? 0? ?? ?? ?? 26 04 ?? ?? 10 40 00 05 26 04 ?? ?? 24 05 00 01 00 40 30 21 0? ?? ?? ?? 24 07 00 08 3C 10 ?? ?? 0? ?? ?? ?? 26 04 ?? ?? 10 40 00 04 26 04 ?? ?? 24 05 00 01 0? ?? ?? ?? 00 40 30 21 3C 10 ?? ?? 0? ?? ?? ?? 26 04 ?? ?? 10 40 00 05 26 04 ?? ?? 24 05 00 01 00 40 30 21 0? ?? ?? ?? AE 80 00 18 8F BF 01 54 24 02 00 01 3C 03 ?? ?? 8F BE 01 50 8F B7 01 4C 8F B6 01 48 8F B5 01 44 8F B4 01 40 8F B3 01 3C 8F B2 01 38 8F B1 01 34 8F B0 01 30 AC 62 ?? ?? 03 E0 00 08 27 BD 01 58 82 E2 00 00 00 02 10 40 02 A2 10 21 94 42 00 00 30 42 00 20 14 40 FF FA 26 F7 00 01 26 F7 FF FF 92 C2 00 0B 24 04 00 01 10 44 00 2E 24 04 00 02 10 44 00 32 24 04 00 03 14 44 FF 6A 27 A4 00 20 8E C7 00 0C 8F A4 01 2C 02 20 28 21 0? ?? ?? ?? 02 E0 30 21 00 40 80 21 12 00 FF 62 27 A4 00 20 82 03 00 00 10 60 FF 5F 8F A2 01 28 8C 44 00 00 00 03 10 40 00 82 10 21 94 42 00 00 30 42 00 20 10 40 00 0B 00 00 00 00 26 10 00 01 82 03 00 00 00 03 10 40 10 60 FF 52 00 82 10 21 94 42 00 00 30 42 00 20 14 40 FF F9 26 10 00 01 26 10 FF FF 24 02 00 23 10 62 FF 4A 3C 04 ?? ?? 3C 05 ?? ?? 24 A5 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 24 06 00 05 00 40 28 21 0? ?? ?? ?? AF B0 00 10 0? ?? ?? ?? 27 BE 00 20 8F A4 01 2C 02 20 28 21 0? ?? ?? ?? 02 E0 30 21 0? ?? ?? ?? 00 40 80 21 0? ?? ?? ?? 02 E0 20 21 0? ?? ?? ?? 00 40 80 21 3C 16 ?? ?? 26 D6 ?? ?? 0? ?? ?? ?? AF B6 01 2C }
	condition:
		$1
}

rule file_317_5_0 {
	meta:
		name = "_res_hconf_init"
		size = 92
		refs = "0000 __pthread_once"
	strings:
		$1 = { 3C 02 ?? ?? 24 42 ?? ?? 10 40 00 05 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 24 A5 ?? ?? 27 BD FF E0 AF B0 00 18 3C 10 ?? ?? 8E 02 ?? ?? 14 40 00 06 AF BF 00 1C 0? ?? ?? ?? 00 00 00 00 8E 02 ?? ?? 34 42 00 02 AE 02 ?? ?? 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_317_6_0 {
	meta:
		name = "_res_hconf_reorder_addrs"
		size = 936
		refs = "0000 _res_hconf 0018 __gnu_local_gp 0098 __libc_errno 0174 __socket 01b8 __close 01d8 __ifreq 01f8 malloc 0298 __ioctl 02e0 realloc 02f4 free 0378 __lll_lock_wait_private 0388 $LC17 038c $LC18 03a0 __assert_fail 0390 __PRETTY_FUNCTION__.12955"
	strings:
		$1 = { 3C 02 ?? ?? 8C 42 ?? ?? 30 42 00 08 10 40 00 1D 24 02 00 02 8C 83 00 08 3C 1C ?? ?? 27 BD FF A0 27 9C ?? ?? AF B0 00 38 AF BF 00 5C AF BE 00 58 AF B7 00 54 AF B6 00 50 AF B5 00 4C AF B4 00 48 AF B3 00 44 AF B2 00 40 AF B1 00 3C AF BC 00 10 10 62 00 0E 00 80 80 21 8F BF 00 5C 8F BE 00 58 8F B7 00 54 8F B6 00 50 8F B5 00 4C 8F B4 00 48 8F B3 00 44 8F B2 00 40 8F B1 00 3C 8F B0 00 38 27 BD 00 60 03 E0 00 08 00 00 00 00 3C 11 ?? ?? 8E 28 ?? ?? 19 00 00 32 8F 95 ?? ?? 8E 0B 00 10 8D 6D 00 00 11 A0 FF EC 3C 02 ?? ?? 8C 49 ?? ?? 25 6C 00 04 01 A0 50 21 19 00 00 13 00 00 00 00 8D 44 00 00 8D 22 00 04 8D 23 00 08 00 82 10 26 00 43 10 24 10 40 00 13 01 20 18 21 0? ?? ?? ?? 00 00 10 21 8C 67 00 10 8C 66 00 14 00 87 28 26 00 A6 28 24 10 A0 00 0B 24 63 00 0C 24 42 00 01 14 48 FF F8 00 00 00 00 01 80 58 21 25 8C 00 04 8D 8A FF FC 15 40 FF E8 8F BF 00 5C 0? ?? ?? ?? 8F BE 00 58 AD 6D 00 00 8E 02 00 10 8F BF 00 5C 8F BE 00 58 8F B7 00 54 8F B6 00 50 8F B5 00 4C 8F B4 00 48 8F B3 00 44 8F B2 00 40 8F B1 00 3C 8F B0 00 38 AC 4A 00 00 0? ?? ?? ?? 27 BD 00 60 7C 03 E8 3B 24 04 00 02 02 A3 10 21 24 05 00 01 00 00 30 21 0? ?? ?? ?? 8C 56 00 00 04 40 FF B6 00 40 A0 21 3C 1E ?? ?? 27 C3 ?? ?? C0 62 00 00 24 41 00 01 E0 61 00 00 10 20 FF FC 00 00 00 00 00 00 00 0F 14 40 00 74 00 00 00 00 8E 22 ?? ?? 18 40 00 08 27 A4 00 1C 0? ?? ?? ?? 02 80 20 21 8E 28 ?? ?? 11 00 FF A5 8F BF 00 5C 0? ?? ?? ?? 8E 0B 00 10 27 A5 00 18 0? ?? ?? ?? 02 80 30 21 8F AA 00 1C 11 40 00 60 8F A2 00 18 AF AA 00 30 00 02 20 80 00 02 11 00 0? ?? ?? ?? 00 44 20 23 3C 04 ?? ?? AC 82 ?? ?? 10 40 00 59 8F AA 00 30 8F A5 00 18 18 A0 00 30 00 40 20 21 25 43 00 10 01 40 90 21 00 00 B8 21 00 00 98 21 24 09 00 02 0? ?? ?? ?? AF A3 00 20 00 17 19 00 00 62 18 23 26 73 00 01 02 65 10 2A 10 40 00 25 26 52 00 20 96 42 00 10 14 49 FF F8 00 17 10 80 00 17 19 00 00 62 18 23 00 83 10 21 8F A4 00 20 02 4A 58 23 AC 49 00 00 01 64 58 21 8D 66 00 04 02 80 20 21 34 05 89 1B AC 46 00 04 02 40 30 21 AF A3 00 28 AF A9 00 2C AF AA 00 30 0? ?? ?? ?? AF AB 00 24 8F A3 00 28 8F A9 00 2C 8F AA 00 30 04 40 00 2A 8F AB 00 24 3C 02 ?? ?? 8C 44 ?? ?? 8D 66 00 04 8F A5 00 18 00 83 10 21 AC 46 00 08 26 F7 00 01 0? ?? ?? ?? 24 63 00 0C 00 00 18 21 00 00 B8 21 0? ?? ?? ?? 00 60 28 21 3C 03 ?? ?? 10 40 00 26 AC 62 ?? ?? 0? ?? ?? ?? 8F A4 00 1C 7C 03 E8 3B 02 A3 10 21 27 C4 ?? ?? AC 56 00 00 AE 37 ?? ?? 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF A2 27 C4 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 3C 02 ?? ?? 8C 44 ?? ?? 0? ?? ?? ?? 8F A5 00 18 0? ?? ?? ?? 00 00 B8 21 0? ?? ?? ?? 00 00 B8 21 0? ?? ?? ?? 27 C4 ?? ?? 0? ?? ?? ?? 8E 22 ?? ?? 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 01 C6 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_317_7_0 {
	meta:
		name = "_res_hconf_trim_domain"
		size = 224
		refs = "0024 strlen 002c _res_hconf 0074 __strcasecmp"
	strings:
		$1 = { 27 BD FF C8 AF B6 00 30 AF B5 00 2C AF BF 00 34 AF B4 00 28 AF B3 00 24 AF B2 00 20 AF B1 00 1C AF B0 00 18 0? ?? ?? ?? 00 80 B0 21 3C 03 ?? ?? 8C 75 ?? ?? 1A A0 00 15 3C 10 ?? ?? 00 40 98 21 26 10 ?? ?? 00 00 88 21 8E 12 00 00 26 31 00 01 26 10 00 04 0? ?? ?? ?? 02 40 20 21 02 62 A0 23 02 D4 A0 21 00 53 10 2B 02 80 20 21 10 40 00 05 02 40 28 21 0? ?? ?? ?? 00 00 00 00 10 40 00 0D 00 00 00 00 16 35 FF F0 00 00 00 00 8F BF 00 34 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 38 A2 80 00 00 8F BF 00 34 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_317_8_0 {
	meta:
		name = "_res_hconf_trim_domains"
		size = 116
		refs = "0000 _res_hconf 002c _res_hconf_trim_domain"
	strings:
		$1 = { 3C 02 ?? ?? 8C 42 ?? ?? 14 40 00 03 00 00 00 00 03 E0 00 08 00 00 00 00 27 BD FF D8 AF B1 00 20 00 80 88 21 8C 84 00 00 AF BF 00 24 0? ?? ?? ?? AF B0 00 1C 8E 22 00 04 8C 44 00 00 10 80 00 08 24 10 00 04 0? ?? ?? ?? 00 00 00 00 8E 22 00 04 00 50 10 21 8C 44 00 00 14 80 FF FA 26 10 00 04 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_318_0_0 {
	meta:
		name = "__isoc99_vswscanf"
		size = 156
		refs = "0000 _IO_wstr_jumps 003c _IO_no_init 0048 _IO_fwide 005c _IO_wstr_init_static 007c _IO_vfwscanf"
	strings:
		$1 = { 3C 02 ?? ?? 27 BD FE 68 24 42 ?? ?? 27 A7 00 20 AF B2 01 90 AF B1 01 8C AF B0 01 88 00 80 90 21 00 A0 88 21 00 C0 80 21 27 A4 00 E0 00 00 30 21 AF A2 00 10 34 05 80 00 AF BF 01 94 0? ?? ?? ?? AF A0 01 28 27 A4 00 E0 0? ?? ?? ?? 24 05 00 01 27 A4 00 E0 02 40 28 21 00 00 30 21 0? ?? ?? ?? 00 00 38 21 8F A2 01 1C 27 A4 00 E0 02 20 28 21 02 00 30 21 34 42 00 10 00 00 38 21 0? ?? ?? ?? AF A2 01 1C 8F BF 01 94 8F B2 01 90 8F B1 01 8C 8F B0 01 88 03 E0 00 08 27 BD 01 98 }
	condition:
		$1
}

rule file_320_0_0 {
	meta:
		name = "flush_cleanup"
		size = 232
	strings:
		$1 = { 3C 02 ?? ?? 8C 42 ?? ?? 10 40 00 0B 3C 04 ?? ?? 8C 43 00 00 30 63 80 00 14 60 00 07 00 00 00 00 8C 44 00 48 8C 82 00 04 24 42 FF FF 10 40 00 1B AC 82 00 04 3C 04 ?? ?? 24 82 ?? ?? 8C 43 00 04 24 63 FF FF 14 60 00 13 AC 43 00 04 00 40 18 21 AC 40 00 08 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 00 08 24 84 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 03 E0 00 08 00 00 00 00 AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF DD 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 3C 04 ?? ?? }
	condition:
		$1
}

rule file_320_1_0 {
	meta:
		name = "save_for_backup"
		size = 472
		refs = "00e8 malloc 0108 memcpy 0114 free 0174 memmove 01b0 mempcpy"
	strings:
		$1 = { 27 BD FF C0 8C 82 00 30 AF B4 00 28 8C 94 00 0C AF B3 00 24 AF B1 00 1C AF BF 00 3C AF BE 00 38 AF B7 00 34 AF B6 00 30 AF B5 00 2C AF B2 00 20 AF B0 00 18 00 80 88 21 00 A0 98 21 10 40 00 46 00 B4 40 23 01 00 80 21 00 40 18 21 8C 66 00 08 8C 63 00 00 00 D0 38 2A 14 60 FF FC 00 C7 80 0B 8E 36 00 2C 8E 24 00 24 01 10 90 23 02 C4 18 23 00 72 28 2B 14 A0 00 1C 26 5E 00 64 06 00 00 3B 00 72 A8 23 16 40 00 2B 02 90 28 21 00 95 A8 21 01 00 28 21 10 40 00 07 AE 35 00 28 8C 43 00 08 00 65 18 23 AC 43 00 08 8C 42 00 00 14 40 FF FB 00 00 00 00 00 00 10 21 8F BF 00 3C 8F BE 00 38 8F B7 00 34 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 40 0? ?? ?? ?? 03 C0 20 21 10 40 00 37 00 40 B8 21 24 55 00 64 06 00 00 2B 02 A0 20 21 02 90 28 21 0? ?? ?? ?? 02 40 30 21 8E 24 00 24 0? ?? ?? ?? 02 FE F0 21 8E 25 00 0C AE 37 00 24 AE 3E 00 2C 02 65 28 23 0? ?? ?? ?? 8E 22 00 30 00 95 20 21 0? ?? ?? ?? 02 40 30 21 8E 25 00 0C 8E 24 00 24 8E 22 00 30 02 65 28 23 0? ?? ?? ?? 00 95 A8 21 8C 96 00 2C 8C 84 00 24 05 01 FF CA 02 C4 A8 23 01 00 80 21 00 95 20 21 02 D0 28 21 0? ?? ?? ?? 00 10 30 23 8E 25 00 0C 8E 24 00 24 02 B0 80 23 02 65 30 23 0? ?? ?? ?? 00 90 20 21 8E 25 00 0C 8E 23 00 24 8E 22 00 30 02 65 28 23 0? ?? ?? ?? 00 75 A8 21 02 D0 28 21 0? ?? ?? ?? 00 10 30 23 8E 25 00 0C 00 40 20 21 0? ?? ?? ?? 02 65 30 23 0? ?? ?? ?? 8E 24 00 24 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_320_2_0 {
	meta:
		name = "_IO_un_link"
		size = 768
		refs = "0030 _pthread_cleanup_push_defer 009c __lll_lock_wait_private 012c _IO_list_all 01bc _pthread_cleanup_pop_restore"
	strings:
		$1 = { 8C 82 00 00 27 BD FF B0 AF B0 00 34 30 42 00 80 AF BF 00 4C AF B5 00 48 AF B4 00 44 AF B3 00 40 AF B2 00 3C AF B1 00 38 10 40 00 66 00 80 80 21 3C 13 ?? ?? 26 73 ?? ?? 00 13 98 2B 12 60 00 AB 3C 05 ?? ?? 27 A4 00 18 24 A5 ?? ?? 0? ?? ?? ?? 00 00 30 21 7C 03 E8 3B 3C 12 ?? ?? 26 51 ?? ?? 8E 22 00 08 24 74 8B 70 10 54 00 0F 00 00 00 00 AF A0 00 28 C2 23 00 00 14 60 00 06 24 02 00 00 24 01 00 01 E2 21 00 00 10 20 FF FA 24 02 00 01 00 00 00 0F 14 40 00 03 26 44 ?? ?? 0? ?? ?? ?? AF A3 00 28 AE 34 00 08 8E 22 00 04 8E 05 00 00 3C 14 ?? ?? 24 42 00 01 30 A4 80 00 AE 22 00 04 14 80 00 1A AE 90 ?? ?? 7C 03 E8 3B 8E 04 00 48 24 75 8B 70 8C 82 00 08 10 55 00 0F 00 00 00 00 AF A0 00 28 C0 83 00 00 14 60 00 06 24 02 00 00 24 01 00 01 E0 81 00 00 10 20 FF FA 24 02 00 01 00 00 00 0F 10 40 00 4D 00 00 00 00 8E 02 00 48 00 40 20 21 AC 55 00 08 8C 82 00 04 8E 05 00 00 24 42 00 01 AC 82 00 04 30 A4 80 00 3C 03 ?? ?? 8C 62 ?? ?? 10 40 00 10 00 00 00 00 12 02 00 56 00 00 00 00 8C 43 00 34 10 60 00 0B 00 00 00 00 16 03 00 06 00 00 00 00 0? ?? ?? ?? 24 43 00 34 12 02 00 54 24 63 00 34 00 40 18 21 8C 62 00 34 14 40 FF FB 00 00 00 00 24 02 FF 7F 00 A2 28 24 14 80 00 06 AE 05 00 00 8E 04 00 48 8C 82 00 04 24 42 FF FF 10 40 00 2D AC 82 00 04 8E 22 00 04 AE 80 ?? ?? 3C 03 ?? ?? 24 42 FF FF 10 40 00 0E AE 22 00 04 12 60 00 03 27 A4 00 18 0? ?? ?? ?? 00 00 28 21 8F BF 00 4C 8F B5 00 48 8F B4 00 44 8F B3 00 40 8F B2 00 3C 8F B1 00 38 8F B0 00 34 03 E0 00 08 27 BD 00 50 24 63 ?? ?? AE 20 00 08 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF E9 00 00 00 00 26 44 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? AF A3 00 28 0? ?? ?? ?? 8E 02 00 48 AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF CB 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8E 22 00 04 3C 02 ?? ?? 8C 46 ?? ?? 8E 07 00 34 24 C6 00 01 AC 67 ?? ?? 0? ?? ?? ?? AC 46 ?? ?? 3C 06 ?? ?? 8C C7 ?? ?? 8E 08 00 34 24 02 FF 7F 24 E7 00 01 00 A2 28 24 AC 68 00 00 AC C7 ?? ?? 14 80 FF B1 AE 05 00 00 0? ?? ?? ?? 8E 04 00 48 0? ?? ?? ?? 3C 06 ?? ?? 3C 02 ?? ?? 24 42 ?? ?? AF A2 00 18 0? ?? ?? ?? AF A0 00 1C }
	condition:
		$1
}

rule file_320_3_0 {
	meta:
		name = "_IO_link_in"
		size = 652
		refs = "0030 _pthread_cleanup_push_defer 00a4 __lll_lock_wait_private 0134 _IO_list_all 023c _pthread_cleanup_pop_restore"
	strings:
		$1 = { 8C 82 00 00 27 BD FF B0 AF B0 00 34 30 43 00 80 AF BF 00 4C AF B5 00 48 AF B4 00 44 AF B3 00 40 AF B2 00 3C AF B1 00 38 14 60 00 86 00 80 80 21 3C 13 ?? ?? 26 73 ?? ?? 34 42 00 80 00 13 98 2B 12 60 00 8D AC 82 00 00 3C 05 ?? ?? 27 A4 00 18 24 A5 ?? ?? 0? ?? ?? ?? 00 00 30 21 7C 03 E8 3B 3C 12 ?? ?? 26 51 ?? ?? 8E 22 00 08 24 74 8B 70 10 54 00 0F 00 00 00 00 AF A0 00 28 C2 23 00 00 14 60 00 06 24 02 00 00 24 01 00 01 E2 21 00 00 10 20 FF FA 24 02 00 01 00 00 00 0F 14 40 00 03 26 44 ?? ?? 0? ?? ?? ?? AF A3 00 28 AE 34 00 08 8E 24 00 04 8E 02 00 00 3C 14 ?? ?? 24 84 00 01 30 43 80 00 AE 24 00 04 14 60 00 3A AE 90 ?? ?? 7C 03 E8 3B 8E 04 00 48 24 75 8B 70 8C 83 00 08 10 75 00 11 3C 03 ?? ?? AF A0 00 28 C0 83 00 00 14 60 00 06 24 02 00 00 24 01 00 01 E0 81 00 00 10 20 FF FA 24 02 00 01 00 00 00 0F 10 40 00 56 00 00 00 00 8E 03 00 48 8E 02 00 00 00 60 20 21 AC 75 00 08 3C 03 ?? ?? 8C 88 00 04 3C 05 ?? ?? 8C 66 ?? ?? 8C A7 ?? ?? 25 08 00 01 24 C6 00 01 30 42 80 00 AC 88 00 04 AC B0 ?? ?? AE 07 00 34 14 40 00 20 AC 66 ?? ?? 8C 82 00 04 24 42 FF FF 14 40 00 1C AC 82 00 04 AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 00 12 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8E 22 00 04 3C 02 ?? ?? 3C 03 ?? ?? 8C 45 ?? ?? 8C 64 ?? ?? AC 70 ?? ?? 24 A3 00 01 AE 04 00 34 AC 43 ?? ?? 8E 22 00 04 AE 80 ?? ?? 3C 03 ?? ?? 24 42 FF FF 14 40 00 13 AE 22 00 04 24 63 ?? ?? AE 20 00 08 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 00 08 26 44 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 12 60 00 03 27 A4 00 18 0? ?? ?? ?? 00 00 28 21 8F BF 00 4C 8F B5 00 48 8F B4 00 44 8F B3 00 40 8F B2 00 3C 8F B1 00 38 8F B0 00 34 03 E0 00 08 27 BD 00 50 0? ?? ?? ?? AF A3 00 28 0? ?? ?? ?? 8E 03 00 48 3C 02 ?? ?? 24 42 ?? ?? AF A2 00 18 0? ?? ?? ?? AF A0 00 1C }
	condition:
		$1
}

rule file_320_4_0 {
	meta:
		name = "_IO_least_marker"
		size = 44
	strings:
		$1 = { 8C 82 00 0C 8C 83 00 30 10 60 00 06 00 A2 10 23 8C 64 00 08 8C 63 00 00 00 82 28 2A 14 60 FF FC 00 85 10 0B 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_320_5_0 {
	meta:
		name = "_IO_switch_to_main_get_area"
		size = 56
	strings:
		$1 = { 8C 88 00 00 8C 82 00 24 8C 85 00 08 8C 86 00 2C 8C 83 00 0C 24 07 FE FF 01 07 38 24 AC 87 00 00 AC 86 00 08 AC 85 00 2C AC 82 00 0C AC 83 00 24 03 E0 00 08 AC 82 00 04 }
	condition:
		$1
}

rule file_320_6_0 {
	meta:
		name = "_IO_switch_to_backup_area"
		size = 52
	strings:
		$1 = { 8C 87 00 00 8C 82 00 2C 8C 86 00 08 8C 83 00 0C 8C 85 00 24 34 E7 01 00 AC 87 00 00 AC 82 00 08 AC 86 00 2C AC 85 00 0C AC 83 00 24 03 E0 00 08 AC 82 00 04 }
	condition:
		$1
}

rule file_320_7_0 {
	meta:
		name = "_IO_switch_to_get_mode"
		size = 164
	strings:
		$1 = { 8C 82 00 14 8C 83 00 10 27 BD FF E0 AF B0 00 18 00 62 18 2B AF BF 00 1C 14 60 00 19 00 80 80 21 8E 03 00 00 30 64 01 00 14 80 00 12 00 00 00 00 8E 04 00 08 8E 05 00 1C 00 82 20 2B 10 80 00 02 AE 05 00 0C AE 02 00 08 24 04 F7 FF 00 64 18 24 AE 02 00 04 AE 02 00 18 AE 02 00 10 AE 03 00 00 00 00 10 21 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 8E 04 00 28 0? ?? ?? ?? AE 04 00 0C 8C 82 00 98 8C 59 00 0C 03 20 F8 09 24 05 FF FF 24 03 FF FF 10 43 FF F4 8F BF 00 1C 0? ?? ?? ?? 8E 02 00 14 }
	condition:
		$1
}

rule file_320_8_0 {
	meta:
		name = "_IO_free_backup_area"
		size = 120
		refs = "004c free"
	strings:
		$1 = { 8C 82 00 00 27 BD FF E0 AF B0 00 18 30 43 01 00 AF BF 00 1C 10 60 00 16 00 80 80 21 8C 84 00 0C 8E 03 00 24 8E 05 00 08 8E 06 00 2C 24 07 FE FF 00 47 10 24 AE 02 00 00 AE 06 00 08 AE 05 00 2C AE 03 00 0C AE 04 00 24 AE 03 00 04 0? ?? ?? ?? 00 00 00 00 8F BF 00 1C AE 00 00 24 AE 00 00 2C AE 00 00 28 8F B0 00 18 03 E0 00 08 27 BD 00 20 0? ?? ?? ?? 8C 84 00 24 }
	condition:
		$1
}

rule file_320_9_0 {
	meta:
		name = "__overflow"
		size = 32
	strings:
		$1 = { 8C 82 00 6C 14 40 00 02 24 02 FF FF AC 82 00 6C 8C 82 00 98 8C 59 00 0C 03 20 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_320_10_0 {
	meta:
		name = "__underflow"
		size = 312
		refs = "0100 _IO_switch_to_get_mode 0128 _IO_free_backup_area"
	strings:
		$1 = { 8C 82 00 6C 27 BD FF E0 AF B0 00 18 AF BF 00 1C 14 40 00 1F 00 80 80 21 24 02 FF FF AC 82 00 6C 8E 02 00 00 30 42 08 00 14 40 00 35 00 00 00 00 8E 02 00 04 8E 03 00 08 00 43 20 2B 14 80 00 2C 8F BF 00 1C 8E 02 00 00 30 44 01 00 14 80 00 17 24 06 FE FF 8E 02 00 30 10 40 00 30 00 00 00 00 8E 05 00 08 0? ?? ?? ?? 02 00 20 21 14 40 00 0B 24 02 FF FF 8E 02 00 98 8F BF 00 1C 02 00 20 21 8C 59 00 10 8F B0 00 18 03 20 00 08 27 BD 00 20 24 03 FF FF 10 43 FF E2 24 02 FF FF 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 8E 04 00 24 8E 05 00 2C 8E 07 00 0C 00 46 10 24 00 85 30 2B AE 02 00 00 AE 05 00 08 AE 03 00 2C AE 04 00 0C AE 07 00 24 10 C0 FF DF AE 04 00 04 8F BF 00 1C 90 82 00 00 8F B0 00 18 03 E0 00 08 27 BD 00 20 90 42 00 00 8F B0 00 18 03 E0 00 08 27 BD 00 20 0? ?? ?? ?? 02 00 20 21 24 03 FF FF 14 43 FF C8 24 02 FF FF 0? ?? ?? ?? 8F BF 00 1C 8E 02 00 24 10 40 FF D4 00 00 00 00 0? ?? ?? ?? 02 00 20 21 0? ?? ?? ?? 8E 02 00 98 }
	condition:
		$1
}

rule file_320_11_0 {
	meta:
		name = "__uflow"
		size = 336
		refs = "00f0 _IO_free_backup_area 0118 _IO_switch_to_get_mode"
	strings:
		$1 = { 8C 82 00 6C 27 BD FF E0 AF B0 00 18 AF BF 00 1C 14 40 00 1F 00 80 80 21 24 02 FF FF AC 82 00 6C 8E 02 00 00 30 42 08 00 14 40 00 3B 00 00 00 00 8E 02 00 04 8E 03 00 08 00 43 20 2B 14 80 00 30 8F BF 00 1C 8E 02 00 00 30 44 01 00 14 80 00 17 24 06 FE FF 8E 02 00 30 10 40 00 22 00 00 00 00 8E 05 00 08 0? ?? ?? ?? 02 00 20 21 14 40 00 0B 24 02 FF FF 8E 02 00 98 8F BF 00 1C 02 00 20 21 8C 59 00 14 8F B0 00 18 03 20 00 08 27 BD 00 20 24 03 FF FF 10 43 FF E2 24 02 FF FF 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 8E 05 00 2C 8E 04 00 24 8E 07 00 0C 00 46 10 24 00 85 30 2B AE 02 00 00 AE 05 00 08 AE 03 00 2C AE 04 00 0C 14 C0 00 18 AE 07 00 24 8E 02 00 30 14 40 FF E0 AE 04 00 04 8E 02 00 24 10 40 FF E2 00 00 00 00 0? ?? ?? ?? 02 00 20 21 0? ?? ?? ?? 8E 02 00 98 24 43 00 01 AE 03 00 04 90 42 00 00 8F B0 00 18 03 E0 00 08 27 BD 00 20 0? ?? ?? ?? 02 00 20 21 24 03 FF FF 14 43 FF C2 24 02 FF FF 0? ?? ?? ?? 8F BF 00 1C 8F BF 00 1C 24 82 00 01 AE 02 00 04 90 82 00 00 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_320_12_0 {
	meta:
		name = "_IO_setb"
		size = 172
		refs = "0094 __munmap"
	strings:
		$1 = { 27 BD FF D0 AF B0 00 24 00 80 80 21 8C 84 00 1C AF B1 00 28 AF BF 00 2C 00 A0 88 21 10 80 00 04 8E 02 00 00 30 43 00 01 10 60 00 13 00 00 00 00 AE 11 00 1C 14 E0 00 08 AE 06 00 20 8F BF 00 2C 34 42 00 01 AE 02 00 00 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 30 8F BF 00 2C 24 03 FF FE 00 43 10 24 AE 02 00 00 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 30 8E 05 00 20 34 02 FF FF AF A6 00 18 00 A4 28 23 00 A2 28 21 3C 02 FF FF 00 A2 28 24 0? ?? ?? ?? AF A7 00 1C 8E 02 00 00 8F A7 00 1C 0? ?? ?? ?? 8F A6 00 18 }
	condition:
		$1
}

rule file_320_13_0 {
	meta:
		name = "_IO_doallocbuf"
		size = 124
		refs = "0074 _IO_setb"
	strings:
		$1 = { 8C 82 00 1C 27 BD FF E0 AF B0 00 18 AF BF 00 1C 10 40 00 05 00 80 80 21 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 8C 82 00 00 30 42 00 02 10 40 00 04 00 00 00 00 8C 82 00 6C 18 40 00 08 8F BF 00 1C 8E 02 00 98 8C 59 00 34 03 20 F8 09 02 00 20 21 24 03 FF FF 14 43 FF F0 8F BF 00 1C 02 00 20 21 26 05 00 47 26 06 00 48 8F B0 00 18 00 00 38 21 0? ?? ?? ?? 27 BD 00 20 }
	condition:
		$1
}

rule file_320_15_0 {
	meta:
		name = "_IO_default_uflow"
		size = 72
	strings:
		$1 = { 8C 82 00 98 27 BD FF E0 AF B0 00 18 8C 59 00 10 AF BF 00 1C 03 20 F8 09 00 80 80 21 24 03 FF FF 10 43 00 05 24 02 FF FF 8E 02 00 04 24 43 00 01 AE 03 00 04 90 42 00 00 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_320_16_0 {
	meta:
		name = "_IO_default_xsputn"
		size = 264
		refs = "00c8 mempcpy"
	strings:
		$1 = { 27 BD FF C8 00 00 10 21 AF B4 00 2C AF BF 00 34 AF B5 00 30 AF B3 00 28 AF B2 00 24 AF B1 00 20 AF B0 00 1C 10 C0 00 2F 00 C0 A0 21 00 80 88 21 00 A0 90 21 00 C0 80 21 24 13 FF FF 8E 23 00 14 8E 22 00 18 00 62 20 2B 10 80 00 13 00 43 10 23 00 50 A8 2B 02 15 10 0A 00 40 A8 21 2C 42 00 15 10 40 00 18 02 40 28 21 12 A0 00 0A 00 00 00 00 00 75 20 21 02 40 38 21 24 E7 00 01 80 E2 FF FF 24 63 00 01 14 64 FF FC A0 62 FF FF 02 55 90 21 AE 23 00 14 02 15 80 23 12 00 00 11 02 20 20 21 8E 22 00 98 92 45 00 00 8C 59 00 0C 03 20 F8 09 26 52 00 01 10 53 00 0B 02 90 10 23 0? ?? ?? ?? 26 10 FF FF 00 60 20 21 0? ?? ?? ?? 02 A0 30 21 AE 22 00 14 02 55 90 21 0? ?? ?? ?? 02 15 80 23 02 90 10 23 8F BF 00 34 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_320_17_0 {
	meta:
		name = "_IO_sgetn"
		size = 16
	strings:
		$1 = { 8C 82 00 98 8C 59 00 20 03 20 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_320_18_0 {
	meta:
		name = "_IO_default_xsgetn"
		size = 236
		refs = "0094 __underflow 00cc mempcpy"
	strings:
		$1 = { 27 BD FF C8 AF B4 00 2C AF B3 00 28 AF B2 00 24 AF B1 00 20 AF B0 00 1C AF BF 00 34 AF B5 00 30 00 C0 A0 21 00 80 80 21 00 A0 98 21 00 C0 88 21 24 12 FF FF 8E 05 00 04 8E 03 00 08 00 A3 10 2B 10 40 00 12 00 00 00 00 00 65 18 23 00 71 A8 2B 02 35 18 0A 2C 62 00 15 10 40 00 1B 00 60 A8 21 10 60 00 09 00 A3 10 21 02 60 18 21 24 A5 00 01 80 A7 FF FF 24 63 00 01 14 A2 FF FC A0 67 FF FF 02 75 98 21 AE 05 00 04 02 35 88 23 12 20 00 05 8F BF 00 34 0? ?? ?? ?? 02 00 20 21 14 52 FF E5 8F BF 00 34 02 91 10 23 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 38 02 60 20 21 0? ?? ?? ?? 00 60 30 21 8E 03 00 04 00 40 98 21 02 35 88 23 00 75 18 21 0? ?? ?? ?? AE 03 00 04 }
	condition:
		$1
}

rule file_320_19_0 {
	meta:
		name = "_IO_default_setbuf"
		size = 204
		refs = "0060 _IO_setb"
	strings:
		$1 = { 8C 82 00 98 27 BD FF D8 AF B2 00 20 8C 59 00 30 AF B1 00 1C AF B0 00 18 AF BF 00 24 00 80 80 21 00 A0 88 21 03 20 F8 09 00 C0 90 21 24 03 FF FF 10 43 00 24 00 00 00 00 12 20 00 03 00 00 00 00 16 40 00 16 24 02 FF FD 8E 02 00 00 02 00 20 21 26 05 00 47 34 42 00 02 AE 02 00 00 26 06 00 48 0? ?? ?? ?? 00 00 38 21 AE 00 00 18 AE 00 00 14 AE 00 00 10 AE 00 00 08 AE 00 00 04 AE 00 00 0C 02 00 10 21 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 8E 03 00 00 02 20 28 21 00 62 10 24 AE 02 00 00 02 00 20 21 02 32 30 21 0? ?? ?? ?? 00 00 38 21 0? ?? ?? ?? AE 00 00 18 0? ?? ?? ?? 00 00 10 21 }
	condition:
		$1
}

rule file_320_20_0 {
	meta:
		name = "_IO_default_seekpos"
		size = 48
	strings:
		$1 = { 27 BD FF D8 8F A3 00 38 8C 82 00 98 AF A0 00 10 AF A3 00 14 8C 59 00 24 AF BF 00 24 03 20 F8 09 00 00 00 00 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_320_21_0 {
	meta:
		name = "_IO_default_doallocate"
		size = 108
		refs = "002c __mmap 0044 _IO_setb"
	strings:
		$1 = { 27 BD FF D0 AF B0 00 24 24 10 FF FF AF B1 00 28 AF B0 00 10 00 80 88 21 AF A0 00 14 00 00 20 21 3C 05 00 01 24 06 00 03 AF BF 00 2C 0? ?? ?? ?? 24 07 08 02 10 50 00 0B 00 40 28 21 24 46 20 00 02 20 20 21 0? ?? ?? ?? 24 07 00 01 24 02 00 01 8F BF 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 30 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_320_22_0 {
	meta:
		name = "_IO_old_init"
		size = 100
	strings:
		$1 = { 8C 82 00 48 3C 03 FB AD 00 A3 28 25 AC 85 00 00 AC 80 00 3C AC 80 00 1C AC 80 00 20 AC 80 00 0C AC 80 00 04 AC 80 00 08 AC 80 00 10 AC 80 00 14 AC 80 00 18 AC 80 00 34 AC 80 00 24 AC 80 00 28 AC 80 00 2C AC 80 00 30 10 40 00 04 A4 80 00 44 AC 40 00 00 AC 40 00 04 AC 40 00 08 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_320_23_0 {
	meta:
		name = "_IO_init"
		size = 44
		refs = "0008 _IO_old_init"
	strings:
		$1 = { 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? 00 80 38 21 8F BF 00 1C 24 02 FF FF AC E2 00 6C AC E2 00 5C AC E0 00 60 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_320_24_0 {
	meta:
		name = "_IO_no_init"
		size = 124
		refs = "000c _IO_old_init"
	strings:
		$1 = { 27 BD FF E0 00 80 40 21 AF BF 00 1C 0? ?? ?? ?? 00 C0 48 21 05 20 00 13 AD 09 00 6C 8F A2 00 30 8F BF 00 1C AD 07 00 5C AC E0 00 18 AC E0 00 1C AC E0 00 08 AC E0 00 00 AC E0 00 04 AC E0 00 0C AC E0 00 10 AC E0 00 14 AC E0 00 20 AC E0 00 24 AC E0 00 28 AC E2 00 B8 AD 00 00 60 03 E0 00 08 27 BD 00 20 8F BF 00 1C 24 02 FF FF AD 02 00 5C AD 00 00 60 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_320_26_0 {
	meta:
		name = "_IO_default_finish"
		size = 148
		refs = "0050 free 0068 _IO_un_link 0080 __munmap"
	strings:
		$1 = { 27 BD FF E0 AF B0 00 18 00 80 80 21 8C 84 00 1C 10 80 00 05 AF BF 00 1C 8E 02 00 00 30 42 00 01 10 40 00 13 34 02 FF FF 8E 02 00 30 10 40 00 05 00 00 00 00 AC 40 00 04 8C 42 00 00 14 40 FF FD 00 00 00 00 8E 04 00 24 10 80 00 04 00 00 00 00 0? ?? ?? ?? 00 00 00 00 AE 00 00 24 8F BF 00 1C 02 00 20 21 8F B0 00 18 0? ?? ?? ?? 27 BD 00 20 8E 05 00 20 00 A4 28 23 00 A2 28 21 3C 02 FF FF 0? ?? ?? ?? 00 A2 28 24 AE 00 00 20 0? ?? ?? ?? AE 00 00 1C }
	condition:
		$1
}

rule file_320_28_0 {
	meta:
		name = "_IO_sputbackc"
		size = 120
	strings:
		$1 = { 8C 83 00 04 8C 82 00 0C 27 BD FF E0 AF B0 00 18 00 43 10 2B AF BF 00 1C 10 40 00 05 00 80 80 21 90 64 FF FF 30 A2 00 FF 10 82 00 10 24 63 FF FF 8E 02 00 98 8C 59 00 18 03 20 F8 09 02 00 20 21 24 03 FF FF 10 43 00 06 8F BF 00 1C 8E 04 00 00 24 03 FF EF 00 83 18 24 AE 03 00 00 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 AE 03 00 04 0? ?? ?? ?? 30 A2 00 FF }
	condition:
		$1
}

rule file_320_29_0 {
	meta:
		name = "_IO_sungetc"
		size = 116
	strings:
		$1 = { 8C 82 00 04 8C 83 00 0C 27 BD FF E0 AF B0 00 18 00 62 18 2B AF BF 00 1C 10 60 00 0C 00 80 80 21 24 43 FF FF AC 83 00 04 90 42 FF FF 8E 04 00 00 8F BF 00 1C 24 03 FF EF 00 83 18 24 AE 03 00 00 8F B0 00 18 03 E0 00 08 27 BD 00 20 8C 82 00 98 8C 59 00 18 03 20 F8 09 24 05 FF FF 24 03 FF FF 14 43 FF F2 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_320_30_0 {
	meta:
		name = "_IO_adjust_column"
		size = 80
	strings:
		$1 = { 00 A6 48 21 00 A9 18 2B 10 60 00 0F 00 00 00 00 81 28 FF FF 24 07 00 0A 11 07 00 08 25 23 FF FF 24 08 00 0A 10 65 00 08 00 00 00 00 24 63 FF FF 80 67 00 00 14 E8 FF FB 00 00 00 00 01 23 10 23 03 E0 00 08 24 42 FF FF 03 E0 00 08 00 C4 10 21 }
	condition:
		$1
}

rule file_320_31_0 {
	meta:
		name = "_IO_flush_all_lockp"
		size = 820
		refs = "0038 _pthread_cleanup_push_defer 00b4 _IO_list_all 012c __lll_lock_wait_private 0200 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 27 BD FF A8 AF B7 00 4C AF B1 00 34 AF BF 00 54 AF BE 00 50 AF B6 00 48 AF B5 00 44 AF B4 00 40 AF B3 00 3C AF B2 00 38 AF B0 00 30 00 80 88 21 10 80 00 20 00 00 B8 21 3C 02 ?? ?? 24 42 ?? ?? 10 40 00 B7 3C 05 ?? ?? 27 A4 00 18 24 A5 ?? ?? 00 00 30 21 0? ?? ?? ?? 24 17 00 01 7C 03 E8 3B 3C 04 ?? ?? 24 90 ?? ?? 8E 02 00 08 24 72 8B 70 10 52 00 0D 24 85 ?? ?? AF A0 00 28 C0 A3 00 00 14 60 00 06 24 02 00 00 24 01 00 01 E0 A1 00 00 10 20 FF FA 24 02 00 01 00 00 00 0F 10 40 00 86 00 00 00 00 AE 12 00 08 8E 02 00 04 24 42 00 01 AE 02 00 04 3C 16 ?? ?? 8E D0 ?? ?? 3C 14 ?? ?? 8E 93 ?? ?? 12 00 00 43 00 00 A8 21 3C 12 ?? ?? 12 20 00 1E AE 50 ?? ?? 8E 02 00 00 30 42 80 00 14 40 00 1A 00 00 00 00 7C 03 E8 3B 8E 04 00 48 24 7E 8B 70 8C 82 00 08 10 5E 00 11 00 00 10 21 AF A0 00 28 C0 85 00 00 14 A2 00 06 24 03 00 00 24 01 00 01 E0 81 00 00 10 20 FF FA 24 03 00 01 00 00 00 0F 14 60 00 03 00 00 00 00 0? ?? ?? ?? AF A5 00 28 8E 02 00 48 00 40 20 21 AC 5E 00 08 8C 82 00 04 24 42 00 01 AC 82 00 04 8E 02 00 6C 18 40 00 3F 00 00 00 00 8E 02 00 5C 8C 43 00 10 8C 42 00 0C 00 43 10 2B 10 40 00 09 00 00 00 00 8E 02 00 98 02 00 20 21 8C 59 00 0C 03 20 F8 09 24 05 FF FF 00 02 10 27 24 03 FF FF 00 62 A8 0A 12 20 00 0B 8E 83 ?? ?? 8E 02 00 00 30 42 80 00 14 40 00 07 00 00 00 00 8E 04 00 48 8C 82 00 04 24 42 FF FF 10 40 00 2D AC 82 00 04 8E 83 ?? ?? 12 63 00 1E AE 40 ?? ?? 8E D0 ?? ?? 16 00 FF C0 00 60 98 21 12 20 00 07 00 00 00 00 3C 04 ?? ?? 24 82 ?? ?? 8C 43 00 04 24 63 FF FF 10 60 00 37 AC 43 00 04 12 E0 00 05 8F BF 00 54 27 A4 00 18 0? ?? ?? ?? 00 00 28 21 8F BF 00 54 02 A0 10 21 8F BE 00 50 8F B7 00 4C 8F B6 00 48 8F B5 00 44 8F B4 00 40 8F B3 00 3C 8F B2 00 38 8F B1 00 34 8F B0 00 30 03 E0 00 08 27 BD 00 58 8E 10 00 34 16 00 FF A3 00 00 00 00 0? ?? ?? ?? 00 00 00 00 8E 03 00 14 8E 02 00 10 00 43 10 2B 14 40 FF C4 00 00 00 00 0? ?? ?? ?? 00 00 00 00 AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF CB 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8E 83 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? AF A3 00 28 0? ?? ?? ?? AE 12 00 08 00 40 18 21 AC 40 00 08 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF C0 00 00 00 00 24 84 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 3C 02 ?? ?? 24 42 ?? ?? AF A2 00 18 0? ?? ?? ?? AF A0 00 1C }
	condition:
		$1
}

rule file_320_32_0 {
	meta:
		name = "_IO_cleanup"
		size = 564
		refs = "0028 _IO_flush_all_lockp 0030 _IO_list_all 0160 __sched_yield"
	strings:
		$1 = { 27 BD FF B8 00 00 20 21 AF B4 00 34 AF B0 00 24 AF BF 00 44 AF B7 00 40 AF B6 00 3C AF B5 00 38 AF B3 00 30 AF B2 00 2C 0? ?? ?? ?? AF B1 00 28 3C 03 ?? ?? 8C 70 ?? ?? 12 00 00 3D 00 40 A0 21 24 12 00 08 24 13 00 02 3C 15 ?? ?? 3C 16 ?? ?? 24 11 FF FF 8E 03 00 00 30 62 00 02 14 40 00 30 30 63 10 08 10 72 00 2E 00 00 00 00 8E 02 00 6C 10 40 00 2B 00 00 B8 21 8E 04 00 48 10 80 00 1A 92 A2 ?? ?? 7C 03 E8 3B 8C 82 00 08 24 63 8B 70 10 62 00 39 00 00 00 00 AF A0 00 18 C0 85 00 00 14 A0 00 06 24 02 00 00 24 01 00 01 E0 81 00 00 10 20 FF FA 24 02 00 01 00 00 00 0F 14 40 00 03 8F A2 00 18 AF A5 00 18 8F A2 00 18 14 40 00 24 00 00 00 00 8E 04 00 48 AC 83 00 08 24 03 00 01 AC 83 00 04 92 A2 ?? ?? 14 40 00 05 00 00 00 00 8E 02 00 00 30 43 00 01 10 60 00 23 34 42 00 01 8E 02 00 98 02 00 20 21 00 00 28 21 8C 59 00 2C 03 20 F8 09 00 00 30 21 16 F3 00 2C 00 00 00 00 AE 11 00 6C 8E 10 00 34 16 00 FF CA 00 00 00 00 8F BF 00 44 02 80 10 21 8F B7 00 40 8F B6 00 3C 8F B5 00 38 8F B4 00 34 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 48 0? ?? ?? ?? 26 F7 00 01 12 F3 FF DF 92 A2 ?? ?? 0? ?? ?? ?? 8E 04 00 48 8C 82 00 04 24 42 00 01 0? ?? ?? ?? AC 82 00 04 AE 02 00 00 8E 02 00 98 8E 03 00 1C 8E 04 00 20 8E C5 ?? ?? 8C 59 00 2C 00 83 20 23 AE 05 00 60 AE 04 00 68 AE D0 ?? ?? AE 03 00 64 02 00 20 21 00 00 28 21 03 20 F8 09 00 00 30 21 12 F3 FF D6 00 00 00 00 8E 04 00 48 10 80 FF D3 00 00 00 00 8C 82 00 04 24 42 FF FF 14 40 FF CF AC 82 00 04 AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF C5 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? AE 11 00 6C }
	condition:
		$1
}

rule file_320_34_0 {
	meta:
		name = "_IO_flush_all_linebuffered"
		size = 720
		refs = "0008 _pthread_cleanup_push_defer 00a4 _IO_list_all 011c __lll_lock_wait_private 01a8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 27 BD FF A0 AF BE 00 58 3C 1E ?? ?? 27 DE ?? ?? 00 1E F0 2B AF BF 00 5C AF B7 00 54 AF B6 00 50 AF B5 00 4C AF B4 00 48 AF B3 00 44 AF B2 00 40 AF B1 00 3C AF B0 00 38 13 C0 00 A0 AF BE 00 30 3C 05 ?? ?? 27 A4 00 18 24 A5 ?? ?? 0? ?? ?? ?? 00 00 30 21 7C 03 E8 3B 3C 17 ?? ?? 26 F6 ?? ?? 8E C2 00 08 24 70 8B 70 10 50 00 0D 00 00 00 00 AF A0 00 28 C2 C3 00 00 14 60 00 06 24 02 00 00 24 01 00 01 E2 C1 00 00 10 20 FF FA 24 02 00 01 00 00 00 0F 10 40 00 70 26 E4 ?? ?? AE D0 00 08 8E C2 00 04 3C 15 ?? ?? 8E B0 ?? ?? 24 42 00 01 3C 13 ?? ?? AE C2 00 04 12 00 00 34 8E 72 ?? ?? 3C 11 ?? ?? 24 14 02 00 8E 02 00 00 30 42 80 00 14 40 00 1A AE 30 ?? ?? 7C 03 E8 3B 8E 04 00 48 24 7E 8B 70 8C 82 00 08 10 5E 00 11 00 00 10 21 AF A0 00 28 C0 86 00 00 14 C2 00 06 24 05 00 00 24 01 00 01 E0 81 00 00 10 20 FF FA 24 05 00 01 00 00 00 0F 14 A0 00 03 00 00 00 00 0? ?? ?? ?? AF A6 00 28 8E 02 00 48 00 40 20 21 AC 5E 00 08 8C 82 00 04 24 42 00 01 AC 82 00 04 8E 02 00 00 30 42 02 08 10 54 00 3E 02 00 20 21 8E 02 00 00 30 42 80 00 14 40 00 07 8E 62 ?? ?? 8E 04 00 48 8C 82 00 04 24 42 FF FF 10 40 00 22 AC 82 00 04 8E 62 ?? ?? 12 42 00 1A AE 20 ?? ?? 8E B0 ?? ?? 16 00 FF D1 00 40 90 21 8E C2 00 04 24 42 FF FF 3C 03 ?? ?? 10 40 00 34 AE C2 00 04 8F A2 00 30 10 40 00 03 27 A4 00 18 0? ?? ?? ?? 00 00 28 21 8F BF 00 5C 8F BE 00 58 8F B7 00 54 8F B6 00 50 8F B5 00 4C 8F B4 00 48 8F B3 00 44 8F B2 00 40 8F B1 00 3C 8F B0 00 38 03 E0 00 08 27 BD 00 60 8E 10 00 34 16 00 FF B8 00 00 00 00 0? ?? ?? ?? 8E C2 00 04 AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF D6 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8E 62 ?? ?? 8E 02 00 98 8C 59 00 0C 03 20 F8 09 24 05 FF FF 0? ?? ?? ?? 8E 02 00 00 0? ?? ?? ?? AF A3 00 28 0? ?? ?? ?? AE D0 00 08 24 63 ?? ?? AE C0 00 08 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF C3 00 00 00 00 26 E4 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F A2 00 30 3C 02 ?? ?? 24 42 ?? ?? AF A2 00 18 0? ?? ?? ?? AF A0 00 1C }
	condition:
		$1
}

rule file_320_35_0 {
	meta:
		name = "_IO_init_marker"
		size = 148
		refs = "0080 _IO_switch_to_get_mode"
	strings:
		$1 = { 8C A2 00 00 27 BD FF D8 AF B0 00 20 30 43 08 00 AF BF 00 24 00 80 80 21 14 60 00 18 AC 85 00 04 30 42 01 00 14 40 00 0B 8C A3 00 04 8C A2 00 0C 8F BF 00 24 00 62 10 23 AE 02 00 08 8C A2 00 30 AE 02 00 00 AC B0 00 30 8F B0 00 20 03 E0 00 08 27 BD 00 28 8C A2 00 08 8F BF 00 24 00 62 10 23 AE 02 00 08 8C A2 00 30 AE 02 00 00 AC B0 00 30 8F B0 00 20 03 E0 00 08 27 BD 00 28 00 A0 20 21 0? ?? ?? ?? AF A5 00 18 8F A5 00 18 0? ?? ?? ?? 8C A2 00 00 }
	condition:
		$1
}

rule file_320_36_0 {
	meta:
		name = "_IO_remove_marker"
		size = 76
	strings:
		$1 = { 8C 82 00 04 8C 43 00 30 10 60 00 0B 00 00 00 00 14 83 00 06 00 00 00 00 0? ?? ?? ?? 24 43 00 30 10 82 00 07 00 00 00 00 00 40 18 21 8C 62 00 00 14 40 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 8C 84 00 00 03 E0 00 08 AC 64 00 00 }
	condition:
		$1
}

rule file_320_37_0 {
	meta:
		name = "_IO_marker_difference"
		size = 16
	strings:
		$1 = { 8C 82 00 08 8C A3 00 08 03 E0 00 08 00 43 10 23 }
	condition:
		$1
}

rule file_320_38_0 {
	meta:
		name = "_IO_marker_delta"
		size = 76
	strings:
		$1 = { 8C 83 00 04 10 60 00 0F 00 00 00 00 8C 62 00 00 30 42 01 00 14 40 00 06 8C 65 00 04 8C 62 00 0C 8C 83 00 08 00 A2 10 23 03 E0 00 08 00 62 10 23 8C 62 00 08 8C 83 00 08 00 A2 10 23 03 E0 00 08 00 62 10 23 03 E0 00 08 24 02 FF FF }
	condition:
		$1
}

rule file_320_39_0 {
	meta:
		name = "_IO_seekmark"
		size = 200
	strings:
		$1 = { 8C A2 00 04 14 44 00 2E 00 00 00 00 8C A3 00 08 8C 45 00 00 04 60 00 16 30 A4 01 00 10 80 00 0F 24 09 FE FF 8C 44 00 24 8C 47 00 08 8C 48 00 2C 8C 46 00 0C 00 A9 28 24 00 83 18 21 AC 45 00 00 AC 48 00 08 AC 47 00 2C AC 44 00 0C AC 46 00 24 AC 43 00 04 03 E0 00 08 00 00 10 21 8C 44 00 0C 00 83 18 21 AC 43 00 04 03 E0 00 08 00 00 10 21 14 80 00 0E 34 A5 01 00 8C 44 00 2C 8C 48 00 08 8C 46 00 0C 8C 47 00 24 00 83 18 21 AC 45 00 00 AC 44 00 08 AC 48 00 2C AC 47 00 0C AC 46 00 24 AC 43 00 04 03 E0 00 08 00 00 10 21 8C 44 00 08 00 83 18 21 AC 43 00 04 03 E0 00 08 00 00 10 21 03 E0 00 08 24 02 FF FF }
	condition:
		$1
}

rule file_320_40_0 {
	meta:
		name = "_IO_unsave_markers"
		size = 44
		refs = "001c _IO_free_backup_area"
	strings:
		$1 = { 8C 82 00 30 10 40 00 02 00 00 00 00 AC 80 00 30 8C 82 00 24 10 40 00 03 00 00 00 00 0? ?? ?? ?? 00 00 00 00 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_1115_23_0 {
	meta:
		name = "_IO_unsave_wmarkers"
		size = 44
		refs = "001c _IO_free_wbackup_area"
	strings:
		$1 = { 8C 82 00 30 10 40 00 02 00 00 00 00 AC 80 00 30 8C 82 00 24 10 40 00 03 00 00 00 00 0? ?? ?? ?? 00 00 00 00 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_320_41_0 {
	meta:
		name = "_IO_default_pbackfail"
		size = 384
		refs = "0108 malloc 0124 memcpy 0130 free"
	strings:
		$1 = { 27 BD FF C8 AF B3 00 28 AF B1 00 20 8C 93 00 0C 8C 91 00 04 AF B2 00 24 AF B0 00 1C 02 71 10 2B AF BF 00 34 AF B5 00 30 AF B4 00 2C 00 80 80 21 14 40 00 1D 00 A0 90 21 8C 84 00 00 30 82 01 00 14 40 00 2F 00 00 00 00 8E 02 00 24 10 40 00 41 02 20 28 21 8E 11 00 2C 8E 03 00 08 34 84 01 00 AE 04 00 00 AE 11 00 08 AE 03 00 2C AE 02 00 0C AE 05 00 24 26 22 FF FF AE 02 00 04 A2 32 FF FF 32 42 00 FF 8F BF 00 34 8F B5 00 30 8F B4 00 2C 8F B3 00 28 8F B2 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 38 8C 82 00 00 30 42 01 00 14 40 FF F1 26 22 FF FF 92 22 FF FF 10 45 00 0D 00 00 00 00 8C 82 00 24 10 40 00 22 00 00 00 00 0? ?? ?? ?? 02 20 28 21 14 40 00 27 00 00 00 00 8E 05 00 04 8E 04 00 00 8E 11 00 2C 0? ?? ?? ?? 8E 02 00 24 26 31 FF FF 0? ?? ?? ?? AC 91 00 04 8E 14 00 08 02 93 A0 23 0? ?? ?? ?? 00 14 20 40 10 40 00 19 00 40 A8 21 00 54 88 21 02 80 30 21 02 20 20 21 0? ?? ?? ?? 02 60 28 21 8E 04 00 0C 0? ?? ?? ?? 02 34 A0 21 26 22 FF FF AE 15 00 0C AE 14 00 08 AE 11 00 28 AE 02 00 04 0? ?? ?? ?? A2 32 FF FF 0? ?? ?? ?? 24 04 00 80 10 40 00 06 24 43 00 80 02 20 28 21 8E 04 00 00 AE 03 00 28 0? ?? ?? ?? 00 60 88 21 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_320_52_0 {
	meta:
		name = "_IO_list_lock"
		size = 144
		refs = "0080 __lll_lock_wait_private"
	strings:
		$1 = { 27 BD FF D0 AF BF 00 2C AF B1 00 28 AF B0 00 24 7C 03 E8 3B 3C 04 ?? ?? 24 90 ?? ?? 8E 02 00 08 24 71 8B 70 10 51 00 0D 00 00 00 00 AF A0 00 18 C2 03 00 00 14 60 00 06 24 02 00 00 24 01 00 01 E2 01 00 00 10 20 FF FA 24 02 00 01 00 00 00 0F 10 40 00 0A 00 00 00 00 AE 11 00 08 8E 02 00 04 8F BF 00 2C 8F B1 00 28 24 42 00 01 AE 02 00 04 8F B0 00 24 03 E0 00 08 27 BD 00 30 24 84 ?? ?? 0? ?? ?? ?? AF A3 00 18 0? ?? ?? ?? AE 11 00 08 }
	condition:
		$1
}

rule file_320_53_0 {
	meta:
		name = "_IO_list_unlock"
		size = 108
	strings:
		$1 = { 3C 04 ?? ?? 24 82 ?? ?? 8C 43 00 04 24 63 FF FF 14 60 00 14 AC 43 00 04 00 40 18 21 AC 40 00 08 00 00 00 0F C0 62 00 00 24 01 00 00 E0 61 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 00 09 00 00 00 00 24 84 ?? ?? 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_320_54_0 {
	meta:
		name = "_IO_list_resetlock"
		size = 24
	strings:
		$1 = { 3C 03 ?? ?? 24 62 ?? ?? AC 60 ?? ?? AC 40 00 04 03 E0 00 08 AC 40 00 08 }
	condition:
		$1
}

rule file_320_55_0 {
	meta:
		name = "buffer_free"
		size = 112
		refs = "0040 __munmap"
	strings:
		$1 = { 27 BD FF D8 AF B0 00 18 3C 10 ?? ?? 8E 02 ?? ?? 24 04 00 01 3C 03 ?? ?? AF B2 00 20 AF B1 00 1C AF BF 00 24 A0 64 ?? ?? 34 12 FF FF 10 40 00 0A 3C 11 FF FF 8C 45 00 68 8C 44 00 64 00 B2 28 21 0? ?? ?? ?? 00 B1 28 24 8E 02 ?? ?? 8C 42 00 60 14 40 FF F8 AE 02 ?? ?? 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_321_0_0 {
	meta:
		name = "truncate64"
		size = 60
		refs = "0010 __gnu_local_gp 0028 __libc_errno"
	strings:
		$1 = { 00 00 28 21 24 02 10 73 00 00 00 0C 14 E0 00 03 3C 1C ?? ?? 03 E0 00 08 00 00 00 00 27 9C ?? ?? 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 64 20 21 AC 82 00 00 03 E0 00 08 24 02 FF FF }
	condition:
		$1
}

rule file_322_0_0 {
	meta:
		name = "__write_nocancel"
		size = 28
	strings:
		$1 = { 24 02 0F A4 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_322_1_0 {
	meta:
		name = "__libc_write"
		size = 148
		refs = "0040 __libc_enable_asynccancel 006c __libc_disable_asynccancel"
	strings:
		$1 = { 7C 03 E8 3B 8C 63 8B 70 14 03 00 08 00 00 00 00 24 02 0F A4 00 00 00 0C 14 E0 FF F0 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 27 BD FF D0 AF BF 00 1C AF A4 00 00 AF A5 00 04 AF A6 00 08 0? ?? ?? ?? 00 00 00 00 AF A2 00 2C 8F A4 00 00 8F A5 00 04 8F A6 00 08 24 02 0F A4 00 00 00 0C AF A2 00 24 AF A7 00 28 8F A4 00 2C 0? ?? ?? ?? 00 00 00 00 8F A2 00 24 8F A7 00 28 8F BF 00 1C 14 E0 FF D6 27 BD 00 30 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_142_1_2 {
	meta:
		name = "__libc_write"
		size = 148
		refs = "0040 __pthread_enable_asynccancel 006c __pthread_disable_asynccancel"
	strings:
		$1 = { 7C 03 E8 3B 8C 63 8B 70 14 03 00 08 00 00 00 00 24 02 0F A4 00 00 00 0C 14 E0 FF F0 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 27 BD FF D0 AF BF 00 1C AF A4 00 00 AF A5 00 04 AF A6 00 08 0? ?? ?? ?? 00 00 00 00 AF A2 00 2C 8F A4 00 00 8F A5 00 04 8F A6 00 08 24 02 0F A4 00 00 00 0C AF A2 00 24 AF A7 00 28 8F A4 00 2C 0? ?? ?? ?? 00 00 00 00 8F A2 00 24 8F A7 00 28 8F BF 00 1C 14 E0 FF D6 27 BD 00 30 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_323_0_0 {
	meta:
		name = "wctomb"
		size = 160
		refs = "0008 __wcrtomb 000c __wctomb_state 0010 __gnu_local_gp 0020 _nl_current_LC_CTYPE 0074 _nl_C_LC_CTYPE 0084 __wcsmbs_load_conv 0094 __wcsmbs_gconv_fcts_c"
	strings:
		$1 = { 10 80 00 03 3C 06 ?? ?? 0? ?? ?? ?? 24 C6 ?? ?? 3C 1C ?? ?? 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 27 BD FF E0 AF B0 00 18 00 62 10 21 8C 42 00 00 AF BF 00 1C AF BC 00 10 8C 50 00 00 8E 02 00 14 10 40 00 0B 00 00 00 00 3C 03 ?? ?? 24 64 ?? ?? AC 80 00 04 8C 42 00 08 8F BF 00 1C 8F B0 00 18 8C 42 00 34 AC 60 ?? ?? 03 E0 00 08 27 BD 00 20 3C 02 ?? ?? 24 42 ?? ?? 12 02 00 05 00 00 00 00 0? ?? ?? ?? 02 00 20 21 0? ?? ?? ?? 8E 02 00 14 3C 02 ?? ?? 0? ?? ?? ?? 24 42 ?? ?? }
	condition:
		$1
}

rule file_324_0_0 {
	meta:
		name = "sigrelse"
		size = 92
		refs = "0018 __sigprocmask 0028 sigdelset"
	strings:
		$1 = { 27 BD FF 60 00 00 28 21 27 A6 00 18 AF B0 00 98 00 80 80 21 AF BF 00 9C 0? ?? ?? ?? 24 04 00 03 04 40 00 0C 27 A4 00 18 0? ?? ?? ?? 02 00 28 21 04 40 00 08 24 04 00 03 27 A5 00 18 0? ?? ?? ?? 00 00 30 21 8F BF 00 9C 8F B0 00 98 03 E0 00 08 27 BD 00 A0 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_668_0_0 {
	meta:
		name = "sighold"
		size = 92
		refs = "0018 __sigprocmask 0028 sigaddset"
	strings:
		$1 = { 27 BD FF 60 00 00 28 21 27 A6 00 18 AF B0 00 98 00 80 80 21 AF BF 00 9C 0? ?? ?? ?? 24 04 00 03 04 40 00 0C 27 A4 00 18 0? ?? ?? ?? 02 00 28 21 04 40 00 08 24 04 00 03 27 A5 00 18 0? ?? ?? ?? 00 00 30 21 8F BF 00 9C 8F B0 00 98 03 E0 00 08 27 BD 00 A0 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_325_0_0 {
	meta:
		name = "__mempcpy"
		size = 40
		refs = "000c memcpy"
	strings:
		$1 = { 27 BD FF E0 AF BF 00 1C AF B0 00 18 0? ?? ?? ?? 00 C0 80 21 8F BF 00 1C 00 50 10 21 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_327_0_0 {
	meta:
		name = "l64a"
		size = 80
		refs = "0044 $LC0"
	strings:
		$1 = { 10 80 00 10 3C 07 ?? ?? 3C 02 ?? ?? 00 00 18 21 24 42 ?? ?? 24 E7 ?? ?? 30 85 00 3F 00 E5 28 21 90 A6 00 00 00 04 21 82 00 43 28 21 A0 A6 00 00 14 80 FF F9 24 63 00 01 00 62 18 21 03 E0 00 08 A0 60 00 00 3C 02 ?? ?? 03 E0 00 08 24 42 ?? ?? }
	condition:
		$1
}

rule file_328_0_0 {
	meta:
		name = "rexec_af"
		size = 1360
		refs = "0008 __gnu_local_gp 0018 $LC0 0064 __snprintf 00a0 getaddrinfo 00c4 free 00d0 __strdup 00f8 ruserpass 010c __libc_errno 0124 __socket 0140 __connect 0164 __close 0170 __sleep 0180 perror 01bc $LC2 01fc __listen 0214 __getsockname 0224 __libc_sa_len 025c getnameinfo 0278 $LC5 0284 sprintf 0294 strlen 02a4 __write 02e0 accept 0380 __writev 03bc __read 03dc freeaddrinfo 03f4 strtol 041c $LC6 0460 $LC3 0504 $LC1 0220 $LC4"
	strings:
		$1 = { 27 BD FE 30 00 A0 10 21 3C 1C ?? ?? AF B4 01 B8 AF A6 01 D8 00 C0 A0 21 3C 06 ?? ?? 27 9C ?? ?? AF B3 01 B4 AF B0 01 A8 AF A7 01 DC 00 80 80 21 24 05 00 20 27 A4 01 48 24 C6 ?? ?? 00 E0 98 21 00 40 38 21 AF BC 00 20 AF BF 01 CC AF B2 01 B0 AF B1 01 AC 97 B2 01 EA AF BE 01 C8 AF B7 01 C4 AF B6 01 C0 0? ?? ?? ?? AF B5 01 BC 8E 04 00 00 24 11 00 02 27 A5 01 48 27 A6 01 68 27 A7 01 90 A3 A0 01 67 AF A0 01 74 AF A0 01 78 AF A0 01 7C AF A0 01 80 AF A0 01 84 AF B2 01 6C AF B1 01 70 0? ?? ?? ?? AF B1 01 68 14 40 00 D8 8F BC 00 20 8F A2 01 90 8C 42 00 18 10 40 00 E1 00 00 00 00 3C 11 ?? ?? 0? ?? ?? ?? 8E 24 ?? ?? 8F A2 01 90 0? ?? ?? ?? 8C 44 00 18 10 40 01 0A AE 22 ?? ?? AE 02 00 00 8F A2 01 90 27 A5 01 D8 27 A6 01 DC 8C 44 00 18 24 11 00 06 0? ?? ?? ?? 24 12 00 01 8F BC 00 20 7C 03 E8 3B 24 15 00 92 8F 96 ?? ?? 02 C3 B0 21 8F A2 01 90 00 00 30 21 26 31 FF FF 8C 44 00 04 0? ?? ?? ?? 8C 45 00 08 00 40 F0 21 04 40 00 22 00 40 20 21 8F A2 01 90 8C 45 00 14 0? ?? ?? ?? 8C 46 00 10 04 41 00 21 03 C0 20 21 8E C2 00 00 14 55 00 0A 8F A2 01 90 12 20 00 08 00 00 00 00 0? ?? ?? ?? 00 00 00 00 02 40 20 21 0? ?? ?? ?? 00 12 90 40 0? ?? ?? ?? 8F A2 01 90 0? ?? ?? ?? 8C 44 00 18 24 02 FF FF 8F BF 01 CC 8F BE 01 C8 8F B7 01 C4 8F B6 01 C0 8F B5 01 BC 8F B4 01 B8 8F B3 01 B4 8F B2 01 B0 8F B1 01 AC 8F B0 01 A8 03 E0 00 08 27 BD 01 D0 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 24 02 FF FF 8F A2 01 E4 10 40 00 A2 8F A2 01 90 00 00 30 21 8C 44 00 04 0? ?? ?? ?? 8C 45 00 08 04 40 00 D4 00 40 90 21 00 40 20 21 24 05 00 01 0? ?? ?? ?? 27 B1 00 28 24 02 00 80 02 40 20 21 02 20 28 21 27 A6 01 8C 0? ?? ?? ?? AF A2 01 8C 04 40 00 C2 3C 04 ?? ?? 0? ?? ?? ?? 97 A4 00 28 8F A3 01 8C 14 43 00 95 8F BC 00 20 27 A3 01 48 AF A3 00 10 24 03 00 20 AF A3 00 14 24 03 00 02 AF A3 00 18 02 20 20 21 00 40 28 21 00 00 30 21 0? ?? ?? ?? 00 00 38 21 10 40 00 61 00 00 00 00 00 00 30 21 AF A0 01 9C 27 A2 01 28 3C 05 ?? ?? 24 A5 ?? ?? 00 40 20 21 0? ?? ?? ?? AF A2 01 98 8F A4 01 98 24 15 FF FF 0? ?? ?? ?? 24 16 00 04 8F A5 01 98 24 46 00 01 0? ?? ?? ?? 03 C0 20 21 8F BC 00 20 7C 03 E8 3B 00 60 10 21 8F 97 ?? ?? 24 03 00 80 AF A3 01 88 0? ?? ?? ?? 02 E2 B8 21 8E E2 00 00 14 56 00 50 00 00 00 00 02 40 20 21 27 A5 00 A8 0? ?? ?? ?? 27 A6 01 88 10 55 FF F8 02 40 20 21 0? ?? ?? ?? AF A2 01 A0 8F A3 01 A0 04 60 00 48 3C 04 ?? ?? 8F A2 01 E4 AC 43 00 00 8F A2 01 D8 24 12 FF FF 24 16 00 04 00 40 20 21 0? ?? ?? ?? AF A2 00 28 8F A3 01 DC 24 42 00 01 AF A2 00 2C 00 60 20 21 0? ?? ?? ?? AF A3 00 30 8F A4 01 E0 24 42 00 01 AF A2 00 34 0? ?? ?? ?? AF A4 00 38 8F BC 00 20 24 42 00 01 7C 03 E8 3B 8F 95 ?? ?? AF A2 00 3C 0? ?? ?? ?? 02 A3 A8 21 8E A2 00 00 14 56 00 07 00 00 00 00 03 C0 20 21 02 20 28 21 0? ?? ?? ?? 24 06 00 03 10 52 FF F8 8F A4 01 D8 10 94 00 03 00 00 00 00 0? ?? ?? ?? 00 00 00 00 8F A4 01 DC 10 93 00 04 8F A5 01 98 0? ?? ?? ?? 00 00 00 00 8F A5 01 98 03 C0 20 21 0? ?? ?? ?? 24 06 00 01 24 03 00 01 14 43 00 53 00 00 00 00 83 A2 01 28 14 40 00 3B 24 10 00 0A 0? ?? ?? ?? 8F A4 01 90 0? ?? ?? ?? 03 C0 10 21 24 06 00 0A 27 A4 01 48 0? ?? ?? ?? 00 00 28 21 30 43 FF FF AF A3 01 9C 0? ?? ?? ?? 30 46 FF FF 0? ?? ?? ?? 24 02 FF FF 0? ?? ?? ?? 02 40 20 21 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 03 C0 20 21 0? ?? ?? ?? 8F A4 01 90 0? ?? ?? ?? 24 02 FF FF 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? AE 00 00 00 00 62 10 21 AC 51 00 00 0? ?? ?? ?? 24 02 FF FF 3C 05 ?? ?? 03 C0 20 21 24 A5 ?? ?? 0? ?? ?? ?? 24 06 00 01 27 A3 01 28 AF A0 01 9C 27 B1 00 28 0? ?? ?? ?? AF A3 01 98 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 02 40 20 21 00 62 10 21 24 03 00 16 0? ?? ?? ?? AC 43 00 00 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 00 00 00 00 83 A2 01 28 10 50 00 0B 8F A2 01 9C 8F A5 01 98 03 C0 20 21 0? ?? ?? ?? 24 06 00 01 24 03 00 01 24 04 00 02 8F A5 01 98 10 43 FF F3 24 06 00 01 8F A2 01 9C 10 40 FF CE 8F A3 01 E4 0? ?? ?? ?? 8C 64 00 00 0? ?? ?? ?? 00 00 00 00 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 24 02 FF FF 0? ?? ?? ?? 8E 04 00 00 0? ?? ?? ?? 8F A2 01 9C 0? ?? ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 02 40 20 21 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 03 C0 20 21 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_328_1_0 {
	meta:
		name = "rexec"
		size = 48
		refs = "001c rexec_af"
	strings:
		$1 = { 27 BD FF D0 8F A2 00 40 AF BF 00 2C AF A2 00 10 8F A2 00 44 AF A2 00 14 24 02 00 02 0? ?? ?? ?? AF A2 00 18 8F BF 00 2C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_330_0_0 {
	meta:
		name = "__posix_fadvise64_l64"
		size = 100
	strings:
		$1 = { 27 BD FF E0 AF BE 00 1C AF B1 00 18 03 A0 F0 21 AF B0 00 14 27 BD FF F0 AF DD 00 08 00 00 28 21 8F C2 00 34 8F D0 00 30 8F D1 00 38 27 BD FF E0 AF B0 00 10 AF A2 00 14 AF B1 00 18 24 02 10 9E 00 00 00 0C 27 BD 00 20 03 C0 E8 21 8F BE 00 1C 8F B1 00 18 8F B0 00 14 00 07 10 0A 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_331_0_0 {
	meta:
		name = "__ctype_get_mb_cur_max"
		size = 40
		refs = "0000 __gnu_local_gp 0010 _nl_current_LC_CTYPE"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 8C 42 00 00 8C 42 00 00 03 E0 00 08 8C 42 00 58 }
	condition:
		$1
}

rule file_332_0_0 {
	meta:
		name = "map_newlink"
		size = 136
	strings:
		$1 = { 18 E0 00 11 24 03 FF FF 8C C2 00 00 10 43 00 10 00 00 00 00 10 44 00 0F 24 C6 00 04 00 00 10 21 0? ?? ?? ?? 24 08 FF FF 8C C3 00 00 10 68 00 0C 00 00 00 00 10 64 00 08 24 C6 00 04 24 42 00 01 14 47 FF F9 00 00 00 00 03 E0 00 08 24 02 FF FF AC C4 00 00 00 00 10 21 03 E0 00 08 00 00 00 00 18 40 FF FD AC C4 00 00 00 02 20 C0 00 02 19 40 00 83 18 21 00 62 18 23 00 03 18 80 00 A3 28 21 03 E0 00 08 AC A5 FF 64 }
	condition:
		$1
}

rule file_332_1_0 {
	meta:
		name = "getifaddrs_internal"
		size = 3116
		refs = "004c __netlink_open 005c __netlink_request 0188 __netlink_free_handle 0298 calloc 02ec memset 0798 mempcpy 0934 memcpy 0bf4 free 0c04 abort 0c0c $LC0 0c10 $LC1 0c24 __assert_fail 0c14 __PRETTY_FUNCTION__.8565"
	strings:
		$1 = { 27 BD FF 70 AF BE 00 88 03 A0 F0 21 AF BF 00 8C AF B7 00 84 AF B6 00 80 AF B5 00 7C AF B4 00 78 AF B3 00 74 AF B2 00 70 AF B1 00 6C AF B0 00 68 AF C4 00 90 AC 80 00 00 27 C4 00 18 AF C0 00 18 AF C0 00 1C AF C0 00 20 AF C0 00 24 0? ?? ?? ?? AF C0 00 28 04 40 02 E2 27 C4 00 18 0? ?? ?? ?? 24 05 00 12 04 40 00 7C 8F C2 00 20 27 C4 00 18 24 05 00 16 24 42 00 01 0? ?? ?? ?? AF C2 00 20 04 40 00 75 8F D3 00 24 12 60 00 79 8F C7 00 1C 02 60 58 21 00 00 C0 21 00 00 68 21 AF C0 00 34 24 0E 00 03 24 0F 00 10 24 0C 00 07 24 06 FF FC 00 00 50 21 8D 62 00 04 10 40 00 2C 8D 63 00 08 2C 64 00 10 14 80 00 29 00 00 00 00 8C 44 00 00 2C 85 00 10 14 A0 00 25 00 64 28 2B 10 A0 00 0F 00 00 00 00 0? ?? ?? ?? 8D 6B 00 00 24 84 00 03 00 86 20 24 00 64 18 23 2C 65 00 10 14 A0 00 1B 00 44 10 21 8C 44 00 00 2C 85 00 10 14 A0 00 17 00 64 28 2B 14 A0 00 15 00 00 00 00 8C 45 00 0C 14 A7 FF F2 00 00 00 00 8C 48 00 08 8D 65 00 0C 15 05 FF EE 00 00 00 00 94 45 00 04 10 AE 00 0B 00 00 00 00 10 AF 00 23 38 A5 00 14 24 84 00 03 00 86 20 24 2C A5 00 01 00 64 18 23 01 A5 68 21 2C 65 00 10 10 A0 FF E7 00 44 10 21 8D 6B 00 00 15 60 FF D0 00 00 00 00 01 4D 68 21 AF CA 00 34 15 A0 00 3D 00 00 80 21 0? ?? ?? ?? 27 C4 00 18 8F C4 00 18 24 02 0F A6 00 00 00 0C 02 00 10 21 03 C0 E8 21 8F BF 00 8C 8F BE 00 88 8F B7 00 84 8F B6 00 80 8F B5 00 7C 8F B4 00 78 8F B3 00 74 8F B2 00 70 8F B1 00 6C 8F B0 00 68 03 E0 00 08 27 BD 00 90 24 85 FF E0 2C A8 00 04 15 00 00 1C 24 49 00 20 94 48 00 20 2D 19 00 04 17 20 00 18 00 A8 C8 2B 17 20 00 16 00 00 00 00 94 59 00 22 17 2C 00 0E 25 08 00 03 25 08 FF FD 0? ?? ?? ?? 25 08 FF FC 95 28 00 00 2D 19 00 04 17 20 00 0C 00 A8 C8 2B 17 20 00 0A 00 00 00 00 95 39 00 02 13 2C 00 0B 00 00 00 00 25 08 00 03 01 06 40 24 00 A8 28 23 2C B9 00 04 13 20 FF F2 01 28 48 21 0? ?? ?? ?? 25 4A 00 01 0? ?? ?? ?? 24 10 FF FF 25 08 FF FC 03 08 C0 21 0? ?? ?? ?? 25 4A 00 01 0? ?? ?? ?? 00 00 80 21 00 0D 18 C0 00 0D 11 40 00 62 10 21 00 4D 68 23 00 0D 88 80 02 38 C0 21 24 04 00 01 03 00 28 21 0? ?? ?? ?? AF D8 00 60 10 40 FF ED AF C2 00 38 8F C3 00 34 24 05 FF FF 24 15 00 03 00 03 30 80 24 C2 00 0E 00 02 10 C2 00 02 10 C0 03 A2 E8 23 27 A3 00 10 AF C3 00 50 00 60 20 21 8F C3 00 38 24 10 00 10 24 14 00 02 00 71 88 21 02 60 90 21 AF D1 00 54 0? ?? ?? ?? AF C0 00 48 8E 56 00 04 12 C0 00 BD 8E 51 00 08 2E 22 00 10 14 40 00 BA 00 00 00 00 8E C2 00 00 2C 44 00 10 14 80 00 B6 02 22 20 2B 10 80 00 11 00 00 00 00 0? ?? ?? ?? 8E 52 00 00 8E C2 00 00 24 03 FF FC 24 42 00 03 00 43 10 24 02 22 88 23 2E 23 00 10 14 60 00 AA 02 C2 B0 21 8E C2 00 00 2C 43 00 10 14 60 00 A6 02 22 18 2B 14 60 00 A4 00 00 00 00 8E C4 00 0C 8F C3 00 1C 14 83 FF EF 00 00 00 00 8E C4 00 08 8E 43 00 0C 14 83 FF EB 00 00 00 00 96 C3 00 04 10 75 00 99 00 00 00 00 10 70 01 35 24 04 00 14 14 64 FF E4 8F C5 00 38 8E C4 00 14 8F C6 00 50 8F C7 00 34 24 48 FF E8 24 84 FF FF 0? ?? ?? ?? AF C8 00 64 8F C5 00 48 8F C6 00 34 26 C3 00 18 00 A6 20 21 24 05 FF FF 10 45 02 07 8F C8 00 64 00 02 30 C0 00 02 29 40 00 C5 28 21 8F C6 00 38 00 A2 10 23 00 04 48 C0 00 04 29 40 00 02 10 80 01 25 48 21 00 C2 10 21 01 24 48 23 8C 42 00 08 00 09 48 80 00 C9 B8 21 18 80 00 02 AE E2 00 08 AE F7 FF 64 8F C4 00 48 2D 02 00 04 24 84 00 01 14 40 00 EB AF C4 00 48 96 C4 00 18 2C 82 00 04 14 40 00 E7 01 04 10 2B 14 40 00 E5 26 E5 00 1E 26 F3 00 64 26 EA 00 1C 26 E6 00 3C 26 E2 00 88 AF D1 00 40 AF D2 00 44 02 60 48 21 02 E0 90 21 AF C5 00 4C 02 C0 B8 21 AF C6 00 3C AF C2 00 30 01 00 B0 21 01 40 88 21 0? ?? ?? ?? 00 60 98 21 10 55 00 BE 24 03 00 04 14 43 00 17 00 00 00 00 8E 42 00 14 10 40 00 0A 00 00 00 00 AD 20 00 00 AD 20 00 04 AD 20 00 08 AD 20 00 0C AD 20 00 10 AD 20 00 14 AD 20 00 18 AD 20 00 1C AD 20 00 20 AE 49 00 14 92 E2 00 10 A6 42 00 64 92 E2 00 10 10 54 01 79 24 03 00 0A 14 43 01 70 2C C2 00 25 10 D0 01 8C 3C 02 FF C0 96 62 00 00 24 03 FF FC 24 42 00 03 00 43 10 24 02 C2 B0 23 2E C3 00 04 14 60 00 AF 02 62 98 21 96 64 00 00 2C 82 00 04 14 40 00 AB 02 C4 10 2B 14 40 00 A9 00 00 00 00 96 62 00 02 26 65 00 04 10 54 00 53 24 86 FF FC 2C 43 00 03 10 60 FF D2 24 03 00 01 14 43 FF EA 00 00 00 00 8E 42 00 0C 10 40 01 70 02 20 20 21 01 20 20 21 AE 49 00 14 92 E2 00 10 A4 82 00 00 92 E2 00 10 10 54 01 46 24 03 00 0A 14 43 01 3D 2C C2 00 25 14 D0 FF DC 3C 02 FF C0 88 AD 00 00 88 AC 00 04 88 A6 00 08 88 A3 00 0C 98 AD 00 03 98 AC 00 07 98 A3 00 0F 98 A6 00 0B AC 8D 00 08 AC 8C 00 0C AC 86 00 10 AC 83 00 14 8E 63 00 04 00 62 18 24 3C 02 FE 80 10 62 00 08 24 02 00 FF 92 63 00 04 14 62 FF C8 00 00 00 00 92 62 00 05 30 42 00 0F 14 54 FF C4 00 00 00 00 8E E2 00 14 0? ?? ?? ?? AC 82 00 18 8E 52 00 00 16 40 FF 3F 8F C3 00 38 8F C4 00 60 00 64 10 21 8F C3 00 54 00 43 88 2B 16 20 01 7F 8F C3 00 48 10 60 00 15 8F C3 00 34 10 60 00 13 00 03 11 40 00 03 28 C0 00 A2 28 21 00 A3 28 23 8F C3 00 38 00 05 28 80 8F C2 00 38 00 65 28 21 24 06 FF FF 0? ?? ?? ?? 8F C3 00 50 24 42 00 9C 10 A2 00 06 24 63 00 04 8C 64 00 00 14 86 FF FB 00 00 00 00 0? ?? ?? ?? AC 45 FF 64 8F C4 00 38 8F C3 00 90 00 00 80 21 0? ?? ?? ?? AC 64 00 00 8E 42 00 0C 10 40 00 1A 02 20 10 21 01 20 18 21 8C 44 00 0C 8C 4A 00 00 8C 48 00 04 8C 47 00 08 AC 6A 00 00 AC 68 00 04 AC 67 00 08 AC 64 00 0C 8F C4 00 3C 24 42 00 10 14 44 FF F5 24 63 00 10 8C 82 00 00 AC 62 00 00 AE 49 00 14 AE 20 00 00 AE 20 00 04 AE 20 00 08 AE 20 00 0C AE 20 00 10 AE 20 00 14 AE 20 00 18 AE 20 00 1C AE 20 00 20 AE 51 00 0C 92 E2 00 10 A6 42 00 1C 92 E2 00 10 10 54 00 FD 24 03 00 0A 14 43 00 F4 2C C2 00 25 14 D0 FF 77 3C 02 FF C0 88 AC 00 00 88 A6 00 04 88 A4 00 08 88 A3 00 0C 98 AC 00 03 98 A6 00 07 98 A3 00 0F 98 A4 00 0B AE 4C 00 24 AE 46 00 28 AE 44 00 2C AE 43 00 30 8E 63 00 04 00 62 18 24 3C 02 FE 80 10 62 00 08 24 02 00 FF 92 63 00 04 14 62 FF 63 00 00 00 00 92 62 00 05 30 42 00 0F 14 54 FF 5F 00 00 00 00 8E E2 00 14 0? ?? ?? ?? AE 42 00 34 24 84 FF FD 2C 84 00 12 10 80 01 1D 8F C4 00 30 AE 44 00 04 0? ?? ?? ?? AF C9 00 64 A0 40 00 00 96 62 00 00 24 03 FF FC 8F C9 00 64 24 42 00 03 00 43 10 24 02 C2 B0 23 2E C3 00 04 10 60 FF 53 02 62 98 21 02 E0 B0 21 8F D1 00 40 02 40 B8 21 8F D2 00 44 8E E2 00 04 10 40 00 EF 8F C5 00 38 8E E2 00 0C 10 40 FE D0 00 00 00 00 94 43 00 00 10 60 FE CD 24 02 00 11 10 62 FE CB 26 E2 00 40 10 74 00 E2 AE E2 00 10 24 02 00 0A 14 62 00 DD 26 E2 00 48 24 06 00 80 A6 E3 00 40 92 C3 00 11 24 04 FF FF 00 66 28 2B 00 C5 18 0A 00 03 30 C2 00 60 28 21 10 C0 00 EB 00 46 18 21 24 42 00 01 14 43 FF FE A0 44 FF FF 30 A5 00 07 24 02 00 08 00 45 10 23 24 04 FF FF 00 44 10 04 0? ?? ?? ?? A0 62 00 00 8E C4 00 14 8F C5 00 38 8F C6 00 50 8F C7 00 34 24 84 FF FF 0? ?? ?? ?? 24 53 FF E0 24 04 FF FF 10 44 00 D9 26 C3 00 20 00 02 28 C0 00 02 21 40 00 A4 20 21 8F C5 00 38 00 82 10 23 8E C4 00 18 00 02 48 80 00 A9 B8 21 2E 62 00 04 14 40 FE 9D AE E4 00 08 96 C4 00 20 2C 82 00 04 14 40 FE 99 02 64 10 2B 14 40 FE 97 26 E6 00 70 26 E2 00 64 26 E5 00 88 AF C6 00 44 AF C2 00 4C 26 E6 00 28 26 E2 00 1C AF D1 00 3C AF D2 00 40 02 E0 88 21 02 60 90 21 AF C5 00 30 AF C6 00 58 AF C2 00 5C 00 60 B8 21 0? ?? ?? ?? 8F D3 00 54 10 55 00 3C 24 84 FF FD 24 04 00 07 14 44 00 06 02 67 10 21 AE 33 00 18 02 60 20 21 00 E0 30 21 0? ?? ?? ?? 00 40 98 21 96 E2 00 00 24 04 FF FC 24 42 00 03 00 44 10 24 02 42 90 23 2E 44 00 04 14 80 00 28 02 E2 B8 21 96 E4 00 00 2C 82 00 04 14 40 00 24 02 44 10 2B 14 40 00 22 00 00 00 00 96 E2 00 02 26 E5 00 04 10 54 00 2A 24 87 FF FC 2C 46 00 03 10 C0 FF E2 00 00 00 00 24 04 00 01 14 44 FF E9 2C E2 00 25 10 40 FF E7 8F C4 00 58 24 02 00 11 00 E0 30 21 A6 22 00 1C 0? ?? ?? ?? AF C7 00 64 8F C7 00 64 24 04 FF FC 8F C3 00 5C A2 27 00 27 8E C2 00 14 AE 22 00 20 96 C2 00 12 AE 23 00 0C A6 22 00 24 96 E2 00 00 24 42 00 03 00 44 10 24 02 42 90 23 2E 44 00 04 10 80 FF DA 02 E2 B8 21 AF D3 00 54 8F D1 00 3C 0? ?? ?? ?? 8F D2 00 40 2C 84 00 12 10 80 FF CB 8F C4 00 30 00 E0 30 21 0? ?? ?? ?? AE 24 00 04 0? ?? ?? ?? A0 40 00 00 2C E2 00 25 10 40 FF C3 8F C4 00 44 24 02 00 11 00 E0 30 21 A6 22 00 64 0? ?? ?? ?? AF C7 00 64 8F C7 00 64 8F C3 00 4C A2 27 00 6F 8E C2 00 14 AE 22 00 68 96 C2 00 12 AE 23 00 14 0? ?? ?? ?? A6 22 00 6C 10 40 FE A0 00 00 00 00 24 84 00 02 0? ?? ?? ?? AF C9 00 64 0? ?? ?? ?? 8F C9 00 64 24 02 00 04 14 C2 FE 98 00 00 00 00 88 A2 00 00 98 A2 00 03 0? ?? ?? ?? AC 82 00 04 10 40 FE 92 00 00 00 00 26 44 00 66 0? ?? ?? ?? AF C9 00 64 0? ?? ?? ?? 8F C9 00 64 24 02 00 04 14 C2 FE 8A 00 00 00 00 88 A2 00 00 98 A2 00 03 0? ?? ?? ?? AE 42 00 68 10 40 FE 84 00 00 00 00 8F C4 00 4C 0? ?? ?? ?? AF C9 00 64 0? ?? ?? ?? 8F C9 00 64 24 02 00 04 14 C2 FE 7C 00 00 00 00 88 A2 00 00 98 A2 00 03 0? ?? ?? ?? AE 42 00 20 0? ?? ?? ?? AE 51 00 0C 88 AC 00 00 88 A6 00 04 88 A4 00 08 88 A3 00 0C 98 AC 00 03 98 A6 00 07 98 A3 00 0F 98 A4 00 0B AE 4C 00 6C AE 46 00 70 AE 44 00 74 AE 43 00 78 8E 63 00 04 00 62 18 24 3C 02 FE 80 10 62 00 08 24 02 00 FF 92 63 00 04 14 62 FE 62 00 00 00 00 92 62 00 05 30 42 00 0F 14 54 FE 5E 00 00 00 00 8E E2 00 14 0? ?? ?? ?? AE 42 00 7C 0? ?? ?? ?? A6 E3 00 40 26 E2 00 44 0? ?? ?? ?? 24 06 00 20 8E C4 00 14 8F C6 00 50 8F C7 00 34 0? ?? ?? ?? 24 84 FF FF 24 05 FF FF 10 45 00 0E 00 02 19 40 00 02 20 C0 00 83 18 21 00 62 10 23 8F C3 00 38 00 02 10 80 00 62 10 21 8C 42 00 04 0? ?? ?? ?? AE E2 00 04 0? ?? ?? ?? 24 02 FF FF 0? ?? ?? ?? 00 40 18 21 8F C4 00 38 0? ?? ?? ?? 24 10 FF F5 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 00 00 00 00 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 03 1A 0? ?? ?? ?? 24 E7 ?? ?? }
	condition:
		$1
}

rule file_332_2_0 {
	meta:
		name = "__netlink_free_handle"
		size = 116
		refs = "0000 __gnu_local_gp 0010 __libc_errno 0040 free"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF D8 27 9C ?? ?? AF B1 00 1C 8F 91 ?? ?? 8C 84 00 0C 7C 03 E8 3B 02 23 10 21 AF B2 00 20 AF BF 00 24 AF B0 00 18 AF BC 00 10 14 80 00 03 8C 52 00 00 0? ?? ?? ?? 8F BF 00 24 0? ?? ?? ?? 8C 90 00 00 16 00 FF FD 02 00 20 21 8F BF 00 24 7C 03 E8 3B 02 23 88 21 AE 32 00 00 8F B0 00 18 8F B2 00 20 8F B1 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_332_3_0 {
	meta:
		name = "__netlink_request"
		size = 888
		refs = "0008 __gnu_local_gp 0060 __libc_errno 00e0 __sendto 0150 __recvmsg 02c4 malloc 02e0 memcpy 032c time"
	strings:
		$1 = { 27 BD FF 80 8C 82 00 08 3C 1C ?? ?? AF BE 00 78 AF B2 00 60 03 A0 F0 21 AF B0 00 58 AF BF 00 7C AF B7 00 74 AF B6 00 70 AF B5 00 6C AF B4 00 68 AF B3 00 64 AF B1 00 5C 27 BD EF F8 27 9C ?? ?? 27 B2 00 18 24 03 10 00 AF DC 00 18 00 80 80 21 AF D2 00 48 10 40 00 B4 AF C3 00 4C 7C 03 E8 3B 8F 94 ?? ?? 00 60 20 21 24 03 00 14 AF C3 00 20 AF C2 00 28 24 03 03 01 24 02 00 10 AF C0 00 3C A7 C5 00 24 A7 C3 00 26 AF C0 00 2C A3 C0 00 30 A3 C0 00 31 A3 C0 00 32 A3 C0 00 33 AF C0 00 40 AF C0 00 44 A7 C2 00 3C 24 13 00 0C 24 11 FF FF 0? ?? ?? ?? 02 84 A0 21 8E 83 00 00 24 02 00 04 14 62 00 5F 24 03 FF FF 8E 04 00 00 27 C2 00 3C AF A2 00 10 AF B3 00 14 27 C5 00 20 24 06 00 14 0? ?? ?? ?? 00 00 38 21 10 51 FF F3 8F DC 00 18 04 40 00 53 24 03 FF FF 8F 91 ?? ?? 7C 03 E8 3B 24 14 00 0C 24 13 00 01 02 23 88 21 27 C2 00 3C AF C2 00 20 27 C2 00 48 AF D4 00 24 AF C2 00 28 AF D3 00 2C AF C0 00 30 AF C0 00 34 AF C0 00 38 24 16 FF FF 0? ?? ?? ?? 24 17 00 04 8E 22 00 00 14 57 00 3F 24 03 FF FF 8E 04 00 00 27 C5 00 20 0? ?? ?? ?? 00 00 30 21 00 40 A8 21 10 56 FF F7 8F DC 00 18 04 40 00 35 8F C2 00 40 14 40 FF E8 27 C2 00 3C 8F C2 00 38 30 42 00 20 14 40 00 2F 2E A2 00 10 14 40 FF E2 27 C2 00 3C 8E 47 00 00 2C E2 00 10 14 40 FF DD 02 A7 10 2B 14 40 FF DB 02 A0 40 21 8E 09 00 04 02 40 18 21 00 00 58 21 24 0C 00 03 24 0D 00 02 0? ?? ?? ?? 24 06 FF FC 14 A0 00 2D 00 62 18 21 8C 67 00 00 2C E2 00 10 14 40 00 29 01 07 20 2B 14 80 00 27 00 00 00 00 24 E2 00 03 8C 64 00 0C 00 46 10 24 01 02 40 23 15 24 FF F3 2D 05 00 10 8C 6A 00 08 8E 04 00 08 15 44 FF EF 00 00 00 00 94 64 00 04 10 8C 00 4D 25 6B 00 01 14 8D FF EA 2C E7 00 24 10 E0 00 4D 00 00 00 00 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 05 AC 43 00 00 24 03 FF FF 03 C0 E8 21 8F BF 00 7C 8F BE 00 78 8F B7 00 74 8F B6 00 70 8F B5 00 6C 8F B4 00 68 8F B3 00 64 8F B2 00 60 8F B1 00 5C 8F B0 00 58 00 60 10 21 03 E0 00 08 27 BD 00 80 15 60 00 12 00 00 B0 21 12 C0 FF A3 27 C2 00 3C 03 C0 E8 21 8F BF 00 7C 00 00 18 21 8F BE 00 78 8F B7 00 74 8F B6 00 70 8F B5 00 6C 8F B4 00 68 8F B3 00 64 8F B2 00 60 8F B1 00 5C 8F B0 00 58 00 60 10 21 03 E0 00 08 27 BD 00 80 0? ?? ?? ?? 26 A4 00 10 10 40 FF DB 00 40 B8 21 24 44 00 10 02 40 28 21 02 A0 30 21 0? ?? ?? ?? AC 40 00 00 8E 04 00 08 8E 03 00 0C AE E2 00 04 AE F5 00 08 10 60 00 08 AE E4 00 0C 8E 02 00 10 AC 57 00 00 AE 17 00 10 12 C0 FF 80 27 C2 00 3C 0? ?? ?? ?? 03 C0 E8 21 AE 17 00 0C 0? ?? ?? ?? AE 17 00 10 00 00 20 21 0? ?? ?? ?? AF C5 00 50 8F DC 00 18 AE 02 00 08 0? ?? ?? ?? 8F C5 00 50 11 60 FF CE 24 16 00 01 0? ?? ?? ?? 00 00 00 00 8C 62 00 10 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 02 10 23 00 64 20 21 AC 82 00 00 0? ?? ?? ?? 24 03 FF FF }
	condition:
		$1
}

rule file_332_4_0 {
	meta:
		name = "__netlink_close"
		size = 20
	strings:
		$1 = { 8C 84 00 00 24 02 0F A6 00 00 00 0C 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_332_5_0 {
	meta:
		name = "__netlink_open"
		size = 164
		refs = "0018 __socket 0044 __bind 0060 __getsockname"
	strings:
		$1 = { 27 BD FF D0 24 05 00 03 00 00 30 21 AF B0 00 28 00 80 80 21 AF BF 00 2C 0? ?? ?? ?? 24 04 00 10 04 40 00 1E AE 02 00 00 00 40 20 21 27 A5 00 18 24 02 00 10 24 06 00 0C AF A0 00 18 AF A0 00 1C AF A0 00 20 0? ?? ?? ?? A7 A2 00 18 04 40 00 0E 27 A5 00 18 8E 04 00 00 24 02 00 0C 27 A6 00 24 0? ?? ?? ?? AF A2 00 24 04 40 00 07 8F A3 00 1C 00 00 10 21 AE 03 00 04 8F BF 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 30 8E 04 00 00 24 02 0F A6 00 00 00 0C 0? ?? ?? ?? 24 02 FF FF 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_332_6_0 {
	meta:
		name = "getifaddrs"
		size = 56
	strings:
		$1 = { 27 BD FF D8 AF B1 00 20 AF B0 00 1C AF BF 00 24 00 80 88 21 24 10 FF F5 0? ?? ?? ?? 02 20 20 21 10 50 FF FD 8F BF 00 24 8F B1 00 20 8F B0 00 1C 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_333_0_0 {
	meta:
		name = "putwchar"
		size = 496
		refs = "0008 _IO_stdout 010c __lll_lock_wait_private 0168 __woverflow 019c _Unwind_Resume"
	strings:
		$1 = { 27 BD FF C8 AF B1 00 28 3C 11 ?? ?? AF B0 00 24 8E 30 ?? ?? AF B2 00 2C AF BF 00 34 8E 02 00 00 AF B3 00 30 30 42 80 00 14 40 00 1A 00 80 90 21 7C 03 E8 3B 8E 02 00 48 24 73 8B 70 8C 43 00 08 10 73 00 10 02 00 20 21 AF A0 00 18 C0 45 00 00 14 A0 00 06 24 03 00 00 24 01 00 01 E0 41 00 00 10 20 FF FA 24 03 00 01 00 00 00 0F 10 60 00 26 00 00 00 00 8E 03 00 48 8E 24 ?? ?? 00 60 10 21 AC 73 00 08 8C 43 00 04 24 63 00 01 0? ?? ?? ?? AC 43 00 04 02 00 20 21 8C 82 00 5C 10 40 00 32 00 00 00 00 8C 43 00 10 8C 45 00 14 00 65 28 2B 10 A0 00 2D 02 40 88 21 24 64 00 04 AC 44 00 10 AC 72 00 00 8E 02 00 00 30 42 80 00 14 40 00 07 8F BF 00 34 8E 04 00 48 8C 82 00 04 24 42 FF FF 10 40 00 0E AC 82 00 04 8F BF 00 34 02 20 10 21 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 38 00 40 20 21 0? ?? ?? ?? AF A5 00 18 0? ?? ?? ?? 8E 03 00 48 AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF EA 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 34 0? ?? ?? ?? 02 40 28 21 0? ?? ?? ?? 00 40 88 21 8E 02 00 00 30 42 80 00 14 40 00 06 00 80 88 21 8E 04 00 48 8C 83 00 04 24 63 FF FF 10 60 00 03 AC 83 00 04 0? ?? ?? ?? 02 20 20 21 AC 80 00 08 00 00 00 0F C0 83 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 63 00 02 14 60 FF F5 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_334_0_0 {
	meta:
		name = "futimesat"
		size = 440
		refs = "0008 __have_atfcts 0010 __gnu_local_gp 0064 __libc_errno 00d4 strlen 00f8 procfd.7576 0110 __snprintf 0134 __atfct_seterrno 014c __futimes 00b8 procfd.7573"
	strings:
		$1 = { 27 BD FF C8 AF B1 00 24 3C 11 ?? ?? 8E 22 ?? ?? 3C 1C ?? ?? AF BE 00 30 27 9C ?? ?? 03 A0 F0 21 AF B3 00 2C AF B2 00 28 AF B0 00 20 AF BF 00 34 AF DC 00 18 00 80 90 21 00 A0 80 21 04 40 00 1D 00 C0 98 21 10 A0 00 41 00 00 00 00 24 02 10 C4 00 00 00 0C 10 E0 00 0C 24 03 FF FF 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 40 28 21 00 64 20 21 AC 82 00 00 24 03 00 59 14 A3 00 05 24 02 FF FF 0? ?? ?? ?? AE 22 ?? ?? 10 43 00 45 00 00 00 00 03 C0 E8 21 8F BF 00 34 8F BE 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 38 10 A0 00 29 3C 06 ?? ?? 24 02 FF 9C 12 42 00 20 24 02 00 2F 82 03 00 00 10 62 00 12 00 00 88 21 0? ?? ?? ?? 02 00 20 21 10 40 00 28 8F DC 00 18 24 43 00 2E 00 03 18 C2 00 03 18 C0 03 A3 E8 23 27 B1 00 18 3C 06 ?? ?? AF B0 00 10 02 20 20 21 24 45 00 20 24 C6 ?? ?? 02 40 38 21 0? ?? ?? ?? 02 20 80 21 02 00 20 21 02 60 28 21 24 02 10 AB 00 00 00 0C 10 E0 FF D9 00 40 20 21 02 40 28 21 0? ?? ?? ?? 02 20 30 21 0? ?? ?? ?? 24 02 FF FF 0? ?? ?? ?? 00 00 88 21 0? ?? ?? ?? 00 C0 28 21 0? ?? ?? ?? 03 C0 E8 21 27 BD FF D8 27 B0 00 18 02 00 20 21 24 05 00 1D 24 C6 ?? ?? 0? ?? ?? ?? 02 40 38 21 0? ?? ?? ?? 02 00 88 21 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 02 AC 43 00 00 0? ?? ?? ?? 24 02 FF FF 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 0? ?? ?? ?? 8C 45 00 00 }
	condition:
		$1
}

rule file_335_0_0 {
	meta:
		name = "__getpeername"
		size = 28
	strings:
		$1 = { 24 02 10 4B 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_336_0_0 {
	meta:
		name = "__lxstat"
		size = 188
		refs = "0004 __gnu_local_gp 0044 __xstat_conv 0064 __libc_errno"
	strings:
		$1 = { 27 BD FF 50 3C 1C ?? ?? 27 9C ?? ?? AF B0 00 A8 24 02 00 01 00 80 80 21 AF BF 00 AC AF BC 00 10 12 02 00 18 00 A0 20 21 27 A5 00 18 24 02 10 0B 00 00 00 0C 14 E0 00 09 00 40 20 21 14 40 00 03 02 00 20 21 0? ?? ?? ?? 27 A5 00 18 8F BF 00 AC 8F B0 00 A8 03 E0 00 08 27 BD 00 B0 7C 03 E8 3B 00 60 28 21 8F 83 ?? ?? 8F BF 00 AC 8F B0 00 A8 00 65 28 21 24 02 FF FF AC A4 00 00 03 E0 00 08 27 BD 00 B0 00 C0 28 21 24 02 10 0B 00 00 00 0C 10 E0 FF EE 8F BF 00 AC 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 8F B0 00 A8 00 64 20 21 AC 82 00 00 24 02 FF FF 03 E0 00 08 27 BD 00 B0 }
	condition:
		$1
}

rule file_337_0_0 {
	meta:
		name = "do_sigpause"
		size = 136
		refs = "0034 __sigsuspend 005c __sigprocmask 0070 sigdelset"
	strings:
		$1 = { 27 BD FF 58 AF B1 00 A0 AF BF 00 A4 AF B0 00 9C 14 A0 00 0F 00 80 88 21 AF A4 00 18 27 A2 00 1C 27 A3 00 98 24 42 00 04 14 43 FF FE AC 40 FF FC 27 B0 00 18 0? ?? ?? ?? 02 00 20 21 8F BF 00 A4 8F B1 00 A0 8F B0 00 9C 03 E0 00 08 27 BD 00 A8 27 B0 00 18 00 00 20 21 00 00 28 21 0? ?? ?? ?? 02 00 30 21 04 40 FF F5 24 02 FF FF 02 00 20 21 0? ?? ?? ?? 02 20 28 21 04 41 FF EE 24 02 FF FF 0? ?? ?? ?? 8F BF 00 A4 }
	condition:
		$1
}

rule file_337_1_0 {
	meta:
		name = "__sigpause"
		size = 96
		refs = "0028 __libc_enable_asynccancel 0044 __libc_disable_asynccancel"
		altNames = "__sigwait __sigwaitinfo"
	strings:
		$1 = { 7C 03 E8 3B 8C 62 8B 70 14 40 00 03 00 00 00 00 0? ?? ?? ?? 00 00 00 00 27 BD FF D8 AF BF 00 24 AF B0 00 20 AF A4 00 18 0? ?? ?? ?? AF A5 00 1C 8F A5 00 1C 8F A4 00 18 0? ?? ?? ?? 00 40 80 21 02 00 20 21 0? ?? ?? ?? AF A2 00 18 8F BF 00 24 8F A2 00 18 8F B0 00 20 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_74_1_2 {
	meta:
		name = "__sigwait"
		size = 96
		refs = "0028 __pthread_enable_asynccancel 0044 __pthread_disable_asynccancel"
	strings:
		$1 = { 7C 03 E8 3B 8C 62 8B 70 14 40 00 03 00 00 00 00 0? ?? ?? ?? 00 00 00 00 27 BD FF D8 AF BF 00 24 AF B0 00 20 AF A4 00 18 0? ?? ?? ?? AF A5 00 1C 8F A5 00 1C 8F A4 00 18 0? ?? ?? ?? 00 40 80 21 02 00 20 21 0? ?? ?? ?? AF A2 00 18 8F BF 00 24 8F A2 00 18 8F B0 00 20 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_338_0_0 {
	meta:
		name = "_nl_explode_name"
		size = 708
		refs = "016c _nl_normalize_codeset 0184 strcmp 01f8 __rawmemchr 0220 free"
	strings:
		$1 = { 27 BD FF C0 AF B4 00 30 AF B2 00 28 8F B4 00 50 8F B2 00 54 AF BF 00 3C AF B6 00 38 AF B5 00 34 AF B3 00 2C AF B1 00 24 AF B0 00 20 AC C0 00 00 AC E0 00 00 AE 80 00 00 AE 40 00 00 AC A4 00 00 80 82 00 00 24 03 FF BF 00 43 18 24 10 60 00 68 00 00 00 00 24 03 00 5F 10 43 00 66 00 00 28 21 24 03 00 2E 10 43 00 63 24 08 00 40 00 80 18 21 24 05 00 5F 0? ?? ?? ?? 24 09 00 2E 10 45 00 6E 00 00 00 00 10 48 00 8A 00 00 00 00 10 49 00 21 00 00 00 00 24 63 00 01 80 62 00 00 14 40 FF F7 00 00 00 00 10 83 00 52 00 00 00 00 00 00 98 21 8C E2 00 00 10 40 00 05 00 00 00 00 80 42 00 00 14 40 00 02 24 02 FF FB 02 62 98 24 8E 82 00 00 10 40 00 3D 8F BF 00 3C 80 43 00 00 14 60 00 04 02 60 10 21 24 03 FF FD 02 63 10 24 8F BF 00 3C 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 40 10 83 00 36 00 00 A8 21 24 13 00 02 24 64 00 01 A0 60 00 00 AE 84 00 00 80 63 00 01 24 02 FF BF 00 62 10 24 10 40 00 37 00 80 88 21 0? ?? ?? ?? 24 02 FF BF 02 00 88 21 82 23 00 01 00 62 28 24 14 A0 FF FC 26 30 00 01 10 90 00 11 24 02 00 40 02 04 28 23 AF A6 00 18 0? ?? ?? ?? AF A7 00 1C 00 40 B0 21 10 40 00 4B AE 42 00 00 8E 84 00 00 0? ?? ?? ?? 00 40 28 21 8F A6 00 18 10 40 00 23 8F A7 00 1C 82 23 00 01 36 B3 00 03 24 02 00 40 14 62 FF C2 00 00 00 00 26 02 00 01 A2 00 00 00 AC C2 00 00 82 03 00 01 36 62 00 08 0? ?? ?? ?? 00 43 98 0B 02 60 10 21 8F B6 00 38 8F B5 00 34 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 40 00 00 28 21 AF A6 00 18 0? ?? ?? ?? AF A7 00 1C 00 40 80 21 80 43 00 00 00 00 98 21 8F A6 00 18 0? ?? ?? ?? 8F A7 00 1C 0? ?? ?? ?? 00 80 80 21 0? ?? ?? ?? 02 C0 20 21 82 23 00 01 8F A6 00 18 0? ?? ?? ?? 8F A7 00 1C 10 83 FF EE 00 00 28 21 24 70 00 01 A0 60 00 00 AC F0 00 00 80 63 00 01 10 60 00 0F 24 02 00 2E 10 62 00 0F 24 02 00 40 10 62 00 0B 24 02 00 2E 0? ?? ?? ?? 24 04 00 40 10 62 00 09 00 00 00 00 10 64 FF C9 24 13 00 04 26 10 00 01 82 03 00 00 14 60 FF F9 00 00 00 00 0? ?? ?? ?? 24 13 00 04 02 00 18 21 24 13 00 06 0? ?? ?? ?? 24 15 00 04 0? ?? ?? ?? 24 02 FF FF 10 83 FF CF 00 00 00 00 00 60 80 21 0? ?? ?? ?? 00 00 98 21 }
	condition:
		$1
}

rule file_339_0_0 {
	meta:
		name = "fseeko"
		size = 452
		refs = "0074 __lll_lock_wait_private 00a8 _IO_seekoff_unlocked 0170 _Unwind_Resume"
		altNames = "fseek"
	strings:
		$1 = { 8C 82 00 00 27 BD FF C0 AF B2 00 34 30 42 80 00 AF B1 00 30 AF B0 00 2C AF BF 00 3C AF B3 00 38 00 80 80 21 00 A0 88 21 14 40 00 1A 00 C0 90 21 7C 03 E8 3B 8C 84 00 48 24 73 8B 70 8C 82 00 08 10 53 00 11 00 00 00 00 AF A0 00 20 C0 83 00 00 14 60 00 06 24 02 00 00 24 01 00 01 E0 81 00 00 10 20 FF FA 24 02 00 01 00 00 00 0F 14 40 00 03 00 00 00 00 0? ?? ?? ?? AF A3 00 20 8E 02 00 48 00 40 20 21 AC 53 00 08 8C 82 00 04 24 42 00 01 AC 82 00 04 24 02 00 03 AF B2 00 10 AF A2 00 14 02 00 20 21 00 11 37 C3 0? ?? ?? ?? 02 20 38 21 8E 04 00 00 00 43 10 24 24 51 00 01 2E 31 00 01 30 84 80 00 14 80 00 06 00 11 88 23 8E 04 00 48 8C 82 00 04 24 42 FF FF 10 40 00 09 AC 82 00 04 8F BF 00 3C 02 20 10 21 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 40 AC 80 00 08 00 00 00 0F C0 82 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 42 00 02 14 40 FF EF 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 8F BF 00 3C 8E 02 00 00 30 42 80 00 14 40 00 06 00 80 88 21 8E 04 00 48 8C 83 00 04 24 63 FF FF 10 60 00 03 AC 83 00 04 0? ?? ?? ?? 02 20 20 21 AC 80 00 08 00 00 00 0F C0 83 00 00 24 01 00 00 E0 81 00 00 10 20 FF FC 00 00 00 00 28 63 00 02 14 60 FF F5 00 00 00 00 7C 03 E8 3B 8C 65 8B 78 24 06 00 01 00 00 38 21 34 A5 00 01 24 02 10 8E 00 00 00 0C 0? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_340_0_0 {
	meta:
		name = "_dl_discover_osversion"
		size = 328
		refs = "0010 __uname 00e8 $LC0 00f0 __open 0108 __read 0114 __close"
	strings:
		$1 = { 27 BD FE 10 27 A4 00 18 AF BF 01 EC AF B1 01 E8 0? ?? ?? ?? AF B0 01 E4 14 40 00 33 27 A4 00 9A 00 00 38 21 00 00 10 21 24 08 00 2E 24 09 00 03 80 85 00 00 24 A5 FF D0 30 A3 00 FF 2C 63 00 0A 10 60 00 21 8F BF 01 EC 80 83 00 01 24 66 FF D0 30 C6 00 FF 2C C6 00 0A 10 C0 00 0C 24 84 00 01 00 05 30 40 00 05 28 C0 00 C5 28 21 24 84 00 01 00 A3 28 21 80 83 00 00 24 66 FF D0 30 C6 00 FF 2C C6 00 0A 14 C0 FF F6 24 A5 FF D0 00 02 12 00 24 E7 00 01 00 A2 10 25 14 68 00 08 24 84 00 01 14 E9 FF E3 00 00 00 00 8F BF 01 EC 8F B1 01 E8 8F B0 01 E4 03 E0 00 08 27 BD 01 F0 24 03 00 03 10 E3 FF F9 8F BF 01 EC 24 03 00 03 00 67 38 23 00 07 38 C0 8F B1 01 E8 8F B0 01 E4 00 E2 10 04 03 E0 00 08 27 BD 01 F0 3C 04 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 00 00 28 21 04 40 00 11 00 40 80 21 00 40 20 21 27 A5 01 A0 0? ?? ?? ?? 24 06 00 40 00 40 88 21 0? ?? ?? ?? 02 00 20 21 1A 20 00 08 2A 23 00 40 24 02 00 3F 02 23 10 0B 27 A3 00 18 00 62 10 21 A0 40 01 88 0? ?? ?? ?? 27 A4 01 A0 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_341_0_0 {
	meta:
		name = "__gconv_open"
		size = 2104
		refs = "0004 __gnu_local_gp 004c strchr 00e4 _nl_current_LC_CTYPE 00f8 strlen 011c mempcpy 0164 __gconv_find_transform 0190 __gconv_translit_find 01c8 malloc 01dc __libc_errno 01f8 __gconv_close_transform 0264 memset 0274 _nl_C_locobj 02dc __strcasecmp_l 040c memcpy 04a4 $LC0 04a8 __gconv_transliterate 05a4 $LC1 06f4 free"
	strings:
		$1 = { 27 BD FF 98 3C 1C ?? ?? 27 9C ?? ?? AF BE 00 60 AF B0 00 40 03 A0 F0 21 00 A0 80 21 24 05 00 2F AF B2 00 48 AF BF 00 64 AF B7 00 5C AF B6 00 58 AF B5 00 54 AF B4 00 50 AF B3 00 4C AF B1 00 44 AF DC 00 18 00 80 90 21 AF C6 00 70 0? ?? ?? ?? AF C7 00 74 10 40 00 08 24 44 00 01 0? ?? ?? ?? 24 05 00 2F 10 40 00 05 00 00 B8 21 80 43 00 01 14 60 00 DD 24 51 00 01 00 00 B8 21 AF C0 00 34 02 00 20 21 0? ?? ?? ?? 24 05 00 2F 10 40 00 09 8F DC 00 18 24 44 00 01 0? ?? ?? ?? 24 05 00 2F 10 40 00 04 8F DC 00 18 80 43 00 01 14 60 01 9F 24 42 00 01 92 42 00 00 24 03 00 2F 14 43 00 1D 00 00 00 00 92 51 00 01 16 22 00 1A 00 00 00 00 92 42 00 02 14 40 00 17 00 00 00 00 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 8C 42 00 00 8C 42 00 00 8C 53 00 5C 0? ?? ?? ?? 02 60 20 21 24 43 00 11 00 03 18 C2 00 03 18 C0 03 A3 E8 23 27 B2 00 18 02 40 20 21 02 60 28 21 0? ?? ?? ?? 00 40 30 21 8F DC 00 18 A0 51 00 00 A0 51 00 01 A0 40 00 02 92 02 00 00 24 03 00 2F 14 43 00 04 00 00 00 00 92 11 00 01 12 22 01 3C 00 00 00 00 8F C2 00 74 02 40 20 21 02 00 28 21 AF A2 00 10 27 C6 00 28 0? ?? ?? ?? 27 C7 00 24 AF C2 00 30 14 40 00 27 00 00 A0 21 12 E0 00 0E 02 E0 A8 21 00 00 80 21 8E E2 00 00 10 40 00 05 02 E0 20 21 0? ?? ?? ?? 00 00 00 00 14 40 01 9C 00 00 00 00 8E E2 00 04 10 40 00 04 02 E0 80 21 0? ?? ?? ?? 00 40 B8 21 00 00 A8 21 8F D0 00 24 00 10 11 40 00 10 88 80 02 22 88 21 0? ?? ?? ?? 26 24 00 08 00 40 A0 21 14 40 00 1E 8F DC 00 18 8F 92 ?? ?? 7C 03 E8 3B 02 00 28 21 02 43 10 21 8C 55 00 00 8F C4 00 28 24 02 00 03 0? ?? ?? ?? AF C2 00 30 7C 03 E8 3B 02 43 10 21 AC 55 00 00 00 00 A0 21 8F C3 00 70 8F C2 00 30 AC 74 00 00 03 C0 E8 21 8F BF 00 64 8F BE 00 60 8F B7 00 5C 8F B6 00 58 8F B5 00 54 8F B4 00 50 8F B3 00 4C 8F B2 00 48 8F B1 00 44 8F B0 00 40 03 E0 00 08 27 BD 00 68 AC 50 00 00 24 44 00 08 8F C2 00 28 00 00 28 21 02 20 30 21 0? ?? ?? ?? AE 82 00 04 8F C2 00 24 10 40 FF E7 3C 11 ?? ?? 26 92 00 28 00 00 80 21 00 00 98 21 26 31 ?? ?? 26 42 FF F8 12 A0 00 3A AE 42 FF F4 02 A0 B8 21 8E E2 00 0C 10 40 00 33 00 00 B0 21 0? ?? ?? ?? 8E E5 00 08 8E E2 00 0C 02 C2 10 2B 10 40 00 2D 00 00 00 00 8E E5 00 08 8F C4 00 28 00 16 10 80 00 A2 10 21 00 90 20 21 8C 84 00 0C 8C 45 00 00 02 20 30 21 0? ?? ?? ?? 26 D6 00 01 14 40 FF F1 00 00 00 00 8E F9 00 18 13 20 00 08 AF C0 00 20 8F C2 00 28 27 C4 00 20 00 50 10 21 03 20 F8 09 8C 45 00 10 14 40 00 17 00 00 00 00 0? ?? ?? ?? 24 04 00 14 10 40 00 E2 8F DC 00 18 8E E3 00 1C 8E E6 00 10 8E E5 00 14 8E 44 00 00 AC 43 00 08 8F C3 00 20 AC 46 00 00 AC 45 00 04 AC 43 00 0C 14 80 00 04 AC 40 00 10 0? ?? ?? ?? 02 40 20 21 00 60 20 21 8C 83 00 10 14 60 FF FD 24 84 00 10 AC 82 00 00 8E F7 00 04 16 E0 FF C9 00 00 00 00 8F D7 00 24 26 E2 FF FF 02 62 10 2B 10 40 01 1A 8F C3 00 34 8F C2 00 28 AE 43 FF E8 00 50 10 21 8C 42 00 30 00 02 21 40 00 02 13 40 00 44 28 23 00 A0 20 21 0? ?? ?? ?? AF C5 00 38 8F DC 00 18 AE 42 FF E0 10 40 00 BA 8F C5 00 38 26 73 00 01 00 45 10 21 02 77 18 2B AE 42 FF E4 26 10 00 3C 14 60 FF AB 26 52 00 24 0? ?? ?? ?? 8F C3 00 70 02 32 10 23 24 43 00 0F 00 03 18 C2 00 03 18 C0 03 A3 E8 23 27 A4 00 18 00 40 30 21 00 82 10 21 02 40 28 21 0? ?? ?? ?? A0 40 00 00 02 20 20 21 0? ?? ?? ?? 00 40 90 21 24 43 00 0F 00 03 18 C2 00 03 18 C0 03 A3 E8 23 27 A4 00 18 02 20 28 21 0? ?? ?? ?? 24 46 00 01 00 40 A8 21 80 42 00 00 24 03 00 2C 14 43 00 06 00 00 00 00 26 B5 00 01 82 A2 00 00 10 43 FF FE 26 B5 00 01 26 B5 FF FF 10 40 FF 04 00 00 B8 21 26 B3 00 01 0? ?? ?? ?? 24 05 00 2C 10 45 00 CA 00 00 00 00 00 80 98 21 82 62 00 00 14 40 FF FB 26 64 00 01 00 00 B8 21 12 A0 FE F9 AF C0 00 34 3C 02 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 02 A0 20 21 24 A5 ?? ?? 24 46 ?? ?? 0? ?? ?? ?? 24 F6 ?? ?? 14 40 00 39 3C 05 ?? ?? 12 E0 00 AA 3C 02 ?? ?? 8E E2 00 10 10 56 00 16 02 E0 20 21 0? ?? ?? ?? 8C 82 00 04 8C 45 00 10 10 B6 00 11 00 40 20 21 8C 82 00 04 14 40 FF FB 3C 03 ?? ?? 27 BD FF D8 27 A2 00 18 24 63 ?? ?? 24 05 00 01 AF A0 00 18 AF A0 00 1C AF A0 00 2C AF A0 00 30 AF A0 00 34 AF A3 00 20 AF A5 00 24 AF B6 00 28 AC 82 00 04 82 62 00 00 24 04 00 2C 14 44 00 06 00 00 00 00 26 73 00 01 82 62 00 00 10 44 FF FE 26 73 00 01 26 73 FF FF 10 40 FE CA 26 65 00 01 0? ?? ?? ?? 24 06 00 2C 10 46 00 7E 00 00 00 00 00 80 28 21 80 A2 00 00 14 40 FF FB 24 A4 00 01 12 60 FE C0 02 60 A8 21 3C 02 ?? ?? 00 A0 98 21 3C 05 ?? ?? 02 A0 20 21 24 A5 ?? ?? 0? ?? ?? ?? 24 46 ?? ?? 10 40 FF C9 3C 05 ?? ?? 3C 06 ?? ?? 02 A0 20 21 24 A5 ?? ?? 0? ?? ?? ?? 24 C6 ?? ?? 10 40 00 6B 24 03 00 02 12 E0 00 7B 3C 11 ?? ?? 02 E0 A0 21 0? ?? ?? ?? 26 31 ?? ?? 00 40 A0 21 8E 82 00 00 02 A0 20 21 02 20 30 21 10 40 00 05 00 40 28 21 0? ?? ?? ?? 00 00 00 00 10 40 FF CD 00 00 00 00 8E 82 00 04 14 40 FF F4 00 00 00 00 27 BD FF D8 27 A2 00 18 AF A0 00 1C AF A0 00 20 AF A0 00 24 AF A0 00 28 AF A0 00 2C AF A0 00 30 AF A0 00 34 AF B5 00 18 0? ?? ?? ?? AE 82 00 04 92 02 00 02 14 40 FE C4 8F C2 00 74 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 8C 42 00 00 8C 42 00 00 8C 53 00 5C 0? ?? ?? ?? 02 60 20 21 24 43 00 11 00 03 18 C2 00 03 18 C0 03 A3 E8 23 27 B0 00 18 02 00 20 21 02 60 28 21 0? ?? ?? ?? 00 40 30 21 A0 51 00 00 A0 51 00 01 0? ?? ?? ?? A0 40 00 02 0? ?? ?? ?? AC 82 00 00 8F 92 ?? ?? 7C 03 E8 3B 26 62 FF FF 02 43 20 21 12 60 00 18 8C 95 00 00 00 02 B0 80 00 02 11 40 02 C2 B0 21 26 D6 00 28 02 96 B0 21 8E D0 00 00 16 00 00 03 00 00 00 00 0? ?? ?? ?? 8E C4 FF E0 8E 19 00 08 17 20 00 3C 8E 11 00 10 0? ?? ?? ?? 02 00 20 21 16 20 FF FA 02 20 80 21 8E C4 FF E0 26 73 FF FF 0? ?? ?? ?? 26 D6 FF DC 16 60 FF EF 00 00 00 00 0? ?? ?? ?? 02 80 20 21 0? ?? ?? ?? 8F C5 00 24 00 50 30 23 24 C2 00 0F 00 02 10 C2 00 02 10 C0 03 A2 E8 23 27 A4 00 18 00 86 10 21 02 00 28 21 0? ?? ?? ?? A0 40 00 00 00 40 80 21 0? ?? ?? ?? 8F DC 00 18 A0 A0 00 00 0? ?? ?? ?? 00 80 28 21 0? ?? ?? ?? AF C3 00 34 27 BD FF D8 27 B7 00 18 24 42 ?? ?? AE E2 00 08 24 02 00 01 AE E0 00 00 AE E0 00 04 AE E0 00 14 AE E0 00 18 AE E0 00 1C AE E2 00 0C 0? ?? ?? ?? AE F6 00 10 A2 60 00 00 0? ?? ?? ?? 00 80 98 21 27 BD FF D8 27 B7 00 18 AE E0 00 04 AE E0 00 08 AE E0 00 0C AE E0 00 10 AE E0 00 14 AE E0 00 18 AE E0 00 1C 0? ?? ?? ?? AE F5 00 00 03 20 F8 09 8E 04 00 0C 0? ?? ?? ?? 00 00 00 00 00 13 10 80 00 13 99 40 00 53 10 21 02 82 10 21 34 77 00 01 0? ?? ?? ?? AC 57 00 10 12 00 00 06 00 00 00 00 8E E2 00 04 AE 02 00 04 8E E2 00 04 0? ?? ?? ?? 02 00 B8 21 8E F5 00 04 00 00 B8 21 0? ?? ?? ?? 02 A0 10 21 }
	condition:
		$1
}

rule file_344_0_0 {
	meta:
		name = "atexit"
		size = 36
		refs = "0000 __dso_handle 0014 __cxa_atexit"
	strings:
		$1 = { 3C 02 ?? ?? 24 43 ?? ?? 10 60 00 04 00 00 00 00 8C 46 ?? ?? 0? ?? ?? ?? 00 00 28 21 0? ?? ?? ?? 00 00 30 21 }
	condition:
		$1
}

rule file_345_0_0 {
	meta:
		name = "utime"
		size = 28
	strings:
		$1 = { 24 02 0F BE 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_346_0_0 {
	meta:
		name = "strchr"
		size = 268
	strings:
		$1 = { 30 82 00 03 14 40 00 08 30 A3 00 FF 0? ?? ?? ?? 30 A5 00 FF 10 40 00 33 24 84 00 01 30 82 00 03 10 40 00 06 00 00 00 00 90 82 00 00 14 43 FF F9 00 00 00 00 03 E0 00 08 00 80 10 21 30 A5 00 FF 00 05 5A 00 01 65 28 25 00 05 5C 00 3C 07 7E FE 3C 0A 81 01 01 65 58 25 34 E7 FE FF 25 4A 01 00 24 82 00 04 8C 45 FF FC 00 AB 30 26 00 06 48 27 00 05 40 27 00 C7 30 21 00 A7 28 21 01 26 30 26 01 05 28 26 00 C5 28 25 00 AA 28 24 10 A0 00 17 00 00 00 00 90 45 FF FC 10 A3 FF E6 00 00 00 00 10 A0 00 10 00 00 00 00 90 45 FF FD 10 A3 00 11 00 00 00 00 10 A0 00 0B 00 00 00 00 90 45 FF FE 10 A3 00 0E 00 00 00 00 10 A0 00 06 00 00 00 00 90 45 FF FF 10 A3 00 0B 00 00 00 00 14 A0 FF E0 00 40 20 21 03 E0 00 08 00 00 10 21 0? ?? ?? ?? 00 40 20 21 03 E0 00 08 24 82 00 01 03 E0 00 08 24 82 00 02 03 E0 00 08 24 82 00 03 }
	condition:
		$1
}

rule file_347_0_0 {
	meta:
		name = "mbrtoc16"
		size = 744
		refs = "0000 __gnu_local_gp 0070 _nl_current_LC_CTYPE 00b4 _dl_mcount_wrapper_check 0188 $LC1 018c $LC2 01a0 __assert_fail 0190 __PRETTY_FUNCTION__.8888 023c $LC0 0258 __libc_errno 0098 _nl_C_LC_CTYPE 02a4 __wcsmbs_load_conv 02bc $LC3 02dc __wcsmbs_gconv_fcts_c"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF 80 27 9C ?? ?? AF B2 00 68 AF B1 00 64 AF B0 00 60 AF BF 00 7C AF B6 00 78 AF B5 00 74 AF B4 00 70 AF B3 00 6C AF BC 00 20 00 E0 80 21 00 80 90 21 10 E0 00 8D 00 A0 88 21 8E 02 00 00 04 40 00 58 7C 42 F0 00 24 02 00 01 AF A0 00 34 AF A2 00 38 AF A2 00 30 AF B0 00 3C 12 20 00 76 AF A0 00 48 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 27 B6 00 54 AF B6 00 28 00 62 10 21 8C 42 00 00 27 A3 00 58 AF A3 00 2C 8C 53 00 00 8E 74 00 14 12 80 00 80 3C 02 ?? ?? 02 26 98 21 02 71 10 2B 14 40 00 77 AF B1 00 4C 8E 82 00 00 8C 55 00 14 0? ?? ?? ?? 02 A0 20 21 8E 84 00 00 27 A2 00 50 AF A2 00 14 24 02 00 01 AF A0 00 10 AF A0 00 18 AF A2 00 1C 27 A5 00 28 27 A6 00 4C 02 A0 C8 21 03 20 F8 09 02 60 38 21 24 03 FF FB 00 43 18 24 14 60 00 1D 8F BC 00 20 8F A3 00 54 8F A2 00 4C 3C 04 00 01 00 64 20 2A 10 80 00 35 00 51 10 23 12 40 00 03 8F A4 00 28 A6 43 00 00 8F A4 00 28 10 96 00 08 8F BF 00 7C 14 60 00 07 8F B6 00 78 8F A3 00 3C 8C 63 00 00 14 60 00 5F 00 00 10 21 8F BF 00 7C 8F B6 00 78 8F B5 00 74 8F B4 00 70 8F B3 00 6C 8F B2 00 68 8F B1 00 64 8F B0 00 60 03 E0 00 08 27 BD 00 80 24 03 00 06 10 43 00 37 24 03 00 07 10 43 00 40 24 03 00 05 10 43 FF DF 8F A3 00 54 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 71 0? ?? ?? ?? 24 E7 ?? ?? 8E 03 00 04 AE 02 00 00 A6 43 00 00 AE 00 00 04 8F BF 00 7C 8F B6 00 78 8F B5 00 74 8F B4 00 70 8F B3 00 6C 8F B2 00 68 8F B1 00 64 8F B0 00 60 24 02 FF FD 03 E0 00 08 27 BD 00 80 12 40 00 03 00 03 22 83 24 84 D7 C0 A6 44 00 00 8E 05 00 00 3C 04 80 00 30 63 03 FF 00 A4 20 25 34 05 DC 00 00 65 18 21 AE 03 00 04 8F BF 00 7C AE 04 00 00 8F B6 00 78 8F B5 00 74 8F B4 00 70 8F B3 00 6C 8F B2 00 68 8F B1 00 64 8F B0 00 60 03 E0 00 08 27 BD 00 80 3C 11 ?? ?? 24 06 00 01 26 31 ?? ?? 0? ?? ?? ?? 00 00 90 21 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 58 AC 43 00 00 0? ?? ?? ?? 24 02 FF FF 3C 10 ?? ?? 0? ?? ?? ?? 26 10 ?? ?? 0? ?? ?? ?? 24 02 FF FE 24 02 FF FF 12 22 FF F1 24 13 FF FF 0? ?? ?? ?? 8E 82 00 00 24 42 ?? ?? 12 62 00 0F 02 60 20 21 0? ?? ?? ?? AF A6 00 58 8F BC 00 20 8E 74 00 14 0? ?? ?? ?? 8F A6 00 58 3C 04 ?? ?? 3C 05 ?? ?? 3C 07 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 80 0? ?? ?? ?? 24 E7 ?? ?? 3C 14 ?? ?? 0? ?? ?? ?? 26 94 ?? ?? }
	condition:
		$1
}

rule file_348_0_0 {
	meta:
		name = "__posix_openpt"
		size = 344
		refs = "0010 __gnu_local_gp 0034 __open 0030 $LC0 0080 $LC1 0088 __statfs 00a4 $LC2 00c8 __close 00dc __libc_errno"
	strings:
		$1 = { 27 BD FF 90 AF B1 00 64 3C 11 ?? ?? 8E 22 ?? ?? 3C 1C ?? ?? 27 9C ?? ?? AF BF 00 6C AF B2 00 68 AF B0 00 60 14 40 00 44 AF BC 00 10 00 80 28 21 3C 04 ?? ?? 0? ?? ?? ?? 24 84 ?? ?? 00 40 80 21 24 02 FF FF 12 02 00 2D 8F BC 00 10 3C 12 ?? ?? 8E 42 ?? ?? 10 40 00 0A 00 00 00 00 24 02 00 01 AE 42 ?? ?? 02 00 10 21 8F BF 00 6C 8F B2 00 68 8F B1 00 64 8F B0 00 60 03 E0 00 08 27 BD 00 70 3C 04 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 27 A5 00 18 14 40 00 04 8F A3 00 18 24 02 1C D1 10 62 FF F0 24 02 00 01 3C 04 ?? ?? 24 84 ?? ?? 0? ?? ?? ?? 27 A5 00 18 14 40 00 04 8F A3 00 18 24 02 13 73 10 62 FF E6 00 00 00 00 0? ?? ?? ?? 02 00 20 21 8F BC 00 10 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 01 AE 23 ?? ?? 24 03 00 02 AC 43 00 00 0? ?? ?? ?? 24 02 FF FF 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 8C 43 00 00 24 02 00 02 10 62 00 04 00 00 00 00 24 04 00 13 14 64 FF D1 24 02 FF FF 24 02 00 01 AE 22 ?? ?? 0? ?? ?? ?? 24 02 FF FF 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 02 AC 43 00 00 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_348_1_0 {
	meta:
		name = "__bsd_getpt"
		size = 280
		refs = "0004 __gnu_local_gp 0008 $LC3 0038 mempcpy 004c __libc_errno 0048 __libc_ptyname1 0050 __libc_ptyname2 00a0 __open"
	strings:
		$1 = { 27 BD FF B8 3C 1C ?? ?? 3C 05 ?? ?? 27 9C ?? ?? 27 A4 00 18 24 A5 ?? ?? 24 06 00 08 AF B5 00 40 AF B4 00 3C AF B3 00 38 AF B2 00 34 AF B1 00 30 AF BC 00 10 AF BF 00 44 0? ?? ?? ?? AF B0 00 2C 8F BC 00 10 7C 03 E8 3B 3C 13 ?? ?? 8F 95 ?? ?? 3C 14 ?? ?? 00 40 88 21 A0 40 00 02 26 73 ?? ?? 24 02 00 70 26 94 ?? ?? 24 12 FF FF 02 A3 A8 21 A2 22 00 00 02 80 80 21 0? ?? ?? ?? 24 03 00 30 8E A3 00 00 10 64 00 1B 8F BF 00 44 82 03 FF FF 10 60 00 11 00 00 00 00 27 A4 00 18 A2 23 00 01 0? ?? ?? ?? 24 05 00 02 26 10 00 01 10 52 FF F4 24 04 00 02 8F BF 00 44 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 48 26 73 00 01 82 62 FF FF 14 40 FF E3 00 00 00 00 AE A4 00 00 0? ?? ?? ?? 24 02 FF FF 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 24 02 FF FF 03 E0 00 08 27 BD 00 48 }
	condition:
		$1
}

rule file_348_2_0 {
	meta:
		name = "__getpt"
		size = 44
		refs = "0008 __posix_openpt 0024 __bsd_getpt"
	strings:
		$1 = { 27 BD FF E0 AF BF 00 1C 0? ?? ?? ?? 24 04 00 02 24 03 FF FF 10 43 00 03 8F BF 00 1C 03 E0 00 08 27 BD 00 20 0? ?? ?? ?? 27 BD 00 20 }
	condition:
		$1
}

rule file_349_0_0 {
	meta:
		name = "__bb_exit_func"
		size = 644
		refs = "000c $LC0 0004 $LC1 0034 _IO_new_fopen 0074 fwrite_unlocked 007c __bb_head 0108 __overflow 01c0 _IO_new_fclose 01f4 perror"
	strings:
		$1 = { 27 BD FF A0 3C 05 ?? ?? AF B1 00 40 3C 11 ?? ?? 26 24 ?? ?? 24 A5 ?? ?? AF B0 00 3C AF BF 00 5C AF B7 00 58 AF B6 00 54 AF B5 00 50 AF B4 00 4C AF B3 00 48 0? ?? ?? ?? AF B2 00 44 10 40 00 6D 00 40 80 21 8C 42 00 00 3C 03 67 6D 24 63 6F 6E 34 42 80 00 AE 02 00 00 27 A4 00 18 24 02 00 01 24 05 00 14 24 06 00 01 02 00 38 21 AF A3 00 18 AF A2 00 30 0? ?? ?? ?? AF A2 00 1C 3C 02 ?? ?? 8C 56 ?? ?? 24 17 00 02 12 C0 00 4D 24 13 FF FF 8E 02 00 14 8E 03 00 18 8E C4 00 0C 00 43 18 2B 10 60 00 73 AF A4 00 2C 24 43 00 01 AE 03 00 14 A0 57 00 00 8E 02 00 14 8E 05 00 18 27 A3 00 2C 24 11 00 04 00 45 28 2B 24 72 00 01 10 A0 00 0D 24 44 00 01 90 63 00 00 AE 04 00 14 A0 43 00 00 26 31 FF FF 12 20 00 0C 02 40 18 21 8E 02 00 14 8E 05 00 18 24 72 00 01 00 45 28 2B 14 A0 FF F5 24 44 00 01 90 65 00 00 0? ?? ?? ?? 02 00 20 21 14 53 FF F3 00 00 00 00 8F A2 00 2C 10 40 00 25 00 00 A0 21 8E D2 00 14 00 14 A8 80 24 11 00 04 02 55 90 21 26 52 00 01 8E 02 00 14 8E 03 00 18 26 31 FF FF 00 43 18 2B 10 60 00 37 24 44 00 01 AE 04 00 14 82 43 FF FF A0 43 00 00 16 20 FF F6 26 52 00 01 8E D2 00 08 24 11 00 04 02 55 90 21 26 52 00 01 8E 02 00 14 8E 03 00 18 26 31 FF FF 00 43 18 2B 10 60 00 2F 24 44 00 01 AE 04 00 14 82 43 FF FF A0 43 00 00 16 20 FF F6 26 52 00 01 8F A2 00 2C 26 94 00 01 02 82 10 2B 14 40 FF DD 00 00 00 00 8E D6 00 10 16 C0 FF B5 00 00 00 00 0? ?? ?? ?? 02 00 20 21 8F BF 00 5C 8F B7 00 58 8F B6 00 54 8F B5 00 50 8F B4 00 4C 8F B3 00 48 8F B2 00 44 8F B1 00 40 8F B0 00 3C 03 E0 00 08 27 BD 00 60 0? ?? ?? ?? 26 24 ?? ?? 8F BF 00 5C 8F B7 00 58 8F B6 00 54 8F B5 00 50 8F B4 00 4C 8F B3 00 48 8F B2 00 44 8F B1 00 40 8F B0 00 3C 03 E0 00 08 27 BD 00 60 92 45 FF FF 0? ?? ?? ?? 02 00 20 21 10 53 FF CB 00 00 00 00 0? ?? ?? ?? 00 00 00 00 92 45 FF FF 0? ?? ?? ?? 02 00 20 21 14 53 FF D1 8F A2 00 2C 26 94 00 01 02 82 10 2B 14 40 FF B0 00 00 00 00 0? ?? ?? ?? 8E D6 00 10 02 00 20 21 0? ?? ?? ?? 24 05 00 02 0? ?? ?? ?? 8E 02 00 14 }
	condition:
		$1
}

rule file_350_0_0 {
	meta:
		name = "accept4"
		size = 200
		refs = "0000 __gnu_local_gp 0040 __libc_errno 006c __libc_enable_asynccancel 00b8 __libc_disable_asynccancel"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF D0 27 9C ?? ?? AF BF 00 2C AF B0 00 28 AF BC 00 10 7C 03 E8 3B 8C 62 8B 70 14 40 00 0F 00 00 00 00 24 02 10 EE 00 00 00 0C 10 E0 00 08 8F BF 00 2C 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 00 64 20 21 AC 82 00 00 24 02 FF FF 8F BF 00 2C 8F B0 00 28 03 E0 00 08 27 BD 00 30 AF A4 00 18 AF A5 00 1C AF A6 00 20 0? ?? ?? ?? AF A7 00 24 00 40 F8 21 8F BC 00 10 8F A4 00 18 8F A5 00 1C 8F A6 00 20 8F A7 00 24 24 02 10 EE 00 00 00 0C 10 E0 00 07 00 40 80 21 7C 03 E8 3B 00 60 20 21 8F 83 ?? ?? 24 10 FF FF 00 64 20 21 AC 82 00 00 03 E0 20 21 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 02 00 10 21 }
	condition:
		$1
}

rule file_351_0_0 {
	meta:
		name = "dysize"
		size = 116
	strings:
		$1 = { 30 83 00 03 14 60 00 19 24 02 01 6D 3C 07 51 EB 34 E7 85 1F 00 87 00 18 00 04 37 C3 00 00 38 10 00 07 29 43 00 A6 28 23 00 05 18 80 00 05 29 00 00 65 18 21 00 03 28 80 00 65 18 21 14 83 00 0B 24 02 01 6E 00 07 39 C3 00 E6 30 23 00 06 19 00 00 06 31 80 00 66 30 21 00 06 18 80 00 C3 30 21 00 86 20 23 24 03 01 6D 00 64 10 0B 03 E0 00 08 00 00 00 00 }
	condition:
		$1
}

rule file_352_0_0 {
	meta:
		name = "__statvfs64"
		size = 128
		refs = "0020 __statfs64 003c __xstat64 0058 __internal_statvfs64"
	strings:
		$1 = { 27 BD FE D0 AF B2 01 24 00 A0 90 21 27 A5 00 B8 AF B1 01 20 AF B0 01 1C AF BF 01 2C AF B3 01 28 0? ?? ?? ?? 00 80 88 21 14 40 00 0D 00 40 80 21 27 B3 00 18 24 04 00 03 02 20 28 21 0? ?? ?? ?? 02 60 30 21 00 02 10 27 00 00 38 21 02 20 20 21 02 40 28 21 27 A6 00 B8 0? ?? ?? ?? 02 62 38 0B 8F BF 01 2C 02 00 10 21 8F B3 01 28 8F B2 01 24 8F B1 01 20 8F B0 01 1C 03 E0 00 08 27 BD 01 30 }
	condition:
		$1
}

rule file_354_0_0 {
	meta:
		name = "__scalbn"
		size = 388
		refs = "0094 $LC3 00a4 $LC4 00b0 __muldf3 00c8 $LC1 00d8 $LC2 0100 __adddf3 0124 $LC0 015c $LC5"
		altNames = "__scalbln"
	strings:
		$1 = { 27 BD FF E0 7C 82 55 00 00 80 38 21 AF B0 00 18 AF BF 00 1C 00 C0 80 21 10 40 00 3E 00 80 18 21 24 04 07 FF 10 44 00 34 00 E0 20 21 3C 04 FF FF 24 84 3C B0 02 04 20 2A 14 80 00 22 00 00 00 00 34 04 C3 51 02 04 20 2A 10 80 00 11 00 50 10 21 28 44 07 FF 10 80 00 0E 00 00 00 00 18 40 00 3A 28 44 FF CB 3C 07 80 0F 34 E7 FF FF 00 02 15 00 00 67 18 24 00 43 38 25 8F BF 00 1C 8F B0 00 18 00 E0 10 21 00 A0 18 21 03 E0 00 08 27 BD 00 20 3C 02 ?? ?? 8C 45 ?? ?? 04 E1 00 04 8C 44 ?? ?? 3C 03 ?? ?? 8C 65 ?? ?? 8C 64 ?? ?? 8C 47 ?? ?? 0? ?? ?? ?? 8C 46 ?? ?? 00 40 38 21 0? ?? ?? ?? 00 60 28 21 3C 02 ?? ?? 8C 45 ?? ?? 04 E1 00 04 8C 44 ?? ?? 3C 03 ?? ?? 8C 65 ?? ?? 8C 64 ?? ?? 8C 47 ?? ?? 0? ?? ?? ?? 8C 46 ?? ?? 00 40 38 21 0? ?? ?? ?? 00 60 28 21 00 A0 18 21 00 E0 30 21 0? ?? ?? ?? 00 60 38 21 00 40 38 21 0? ?? ?? ?? 00 60 28 21 7C 82 F0 00 00 45 10 25 10 40 FF D6 3C 06 ?? ?? 8C C7 ?? ?? 0? ?? ?? ?? 8C C6 ?? ?? 7C 44 55 00 00 40 38 21 00 60 28 21 00 40 18 21 0? ?? ?? ?? 24 82 FF CA 14 80 FF DE 3C 06 ?? ?? 3C 04 80 0F 34 84 FF FF 24 42 00 36 8C C7 ?? ?? 00 02 15 00 00 64 18 24 8C C6 ?? ?? 00 43 18 25 0? ?? ?? ?? 00 60 20 21 00 40 38 21 0? ?? ?? ?? 00 60 28 21 }
	condition:
		$1
}

rule file_355_0_0 {
	meta:
		name = "mkstemp"
		size = 16
		refs = "0008 __gen_tempname"
	strings:
		$1 = { 00 00 28 21 00 00 30 21 0? ?? ?? ?? 00 00 38 21 }
	condition:
		$1
}

rule file_356_0_0 {
	meta:
		name = "svc_find"
		size = 136
		refs = "001c __rpc_thread_variables"
	strings:
		$1 = { 27 BD FF D8 AF B2 00 20 AF B1 00 1C AF B0 00 18 AF BF 00 24 00 80 80 21 00 A0 88 21 0? ?? ?? ?? 00 C0 90 21 8C 43 00 B4 10 60 00 15 00 00 20 21 0? ?? ?? ?? 8C 62 00 04 8C 62 00 00 10 40 00 09 00 60 20 21 00 40 18 21 8C 62 00 04 14 50 FF FA 00 00 00 00 8C 62 00 08 14 51 FF F7 00 60 10 21 00 80 18 21 8F BF 00 24 AE 43 00 00 8F B1 00 1C 8F B2 00 20 8F B0 00 18 03 E0 00 08 27 BD 00 28 0? ?? ?? ?? 00 00 10 21 }
	condition:
		$1
}

rule file_356_1_0 {
	meta:
		name = "xprt_register"
		size = 384
		refs = "0014 __rpc_thread_variables 002c _rpc_dtablesize 0054 __rpc_thread_svc_max_pollfd 005c __rpc_thread_svc_pollfd 00a0 realloc 0104 __rpc_thread_svc_fdset 0168 malloc"
	strings:
		$1 = { 27 BD FF D8 AF B2 00 20 AF B1 00 1C AF B0 00 18 AF BF 00 24 0? ?? ?? ?? 00 80 90 21 00 40 88 21 8C 42 00 B0 10 40 00 4E 8E 50 00 00 0? ?? ?? ?? 00 00 00 00 02 02 10 2A 10 40 00 2C 00 10 18 80 8E 24 00 B0 2A 02 04 00 00 83 18 21 14 40 00 2D AC 72 00 00 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 00 40 88 21 8C 44 00 00 00 40 90 21 8E 27 00 00 00 00 28 21 00 80 18 21 0? ?? ?? ?? 24 09 FF FF 8C 66 FF F8 10 C9 00 2D 24 A5 00 01 00 A7 30 2A 00 60 40 21 14 C0 FF FA 24 63 00 08 24 E5 00 01 0? ?? ?? ?? 00 05 28 C0 10 40 00 10 3C 03 1F FF 8E 24 00 00 34 63 FF FF 24 84 00 01 00 83 28 21 00 05 28 C0 00 45 28 21 AE 42 00 00 AE 24 00 00 AC B0 00 00 8E 24 00 00 00 83 18 21 00 03 18 C0 00 43 10 21 24 03 00 C3 A4 43 00 04 8F BF 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 28 0? ?? ?? ?? 00 00 00 00 2A 04 00 00 26 03 00 1F 02 04 18 0A 00 03 19 43 00 03 18 80 00 43 10 21 8C 44 00 00 24 03 00 01 02 03 18 04 00 83 18 25 0? ?? ?? ?? AC 43 00 00 8F BF 00 24 24 02 00 C3 AD 10 00 00 8F B2 00 20 8F B1 00 1C 8F B0 00 18 A5 02 00 04 03 E0 00 08 27 BD 00 28 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 00 02 20 80 14 40 FF AE AE 22 00 B0 0? ?? ?? ?? 8F BF 00 24 }
	condition:
		$1
}

rule file_356_2_0 {
	meta:
		name = "xprt_unregister"
		size = 256
		refs = "0020 _rpc_dtablesize 0034 __rpc_thread_variables 007c __rpc_thread_svc_fdset 00b4 __rpc_thread_svc_max_pollfd 00d4 __rpc_thread_svc_pollfd"
	strings:
		$1 = { 27 BD FF D0 AF B1 00 1C 8C 91 00 00 AF B0 00 18 AF BF 00 2C AF B4 00 28 AF B3 00 24 AF B2 00 20 0? ?? ?? ?? 00 80 80 21 02 22 10 2A 10 40 00 0A 8F BF 00 2C 0? ?? ?? ?? 00 00 00 00 8C 43 00 B0 00 11 10 80 00 62 10 21 8C 43 00 00 10 70 00 09 2A 23 04 00 8F BF 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 30 10 60 00 0F AC 40 00 00 0? ?? ?? ?? 00 00 00 00 2A 24 00 00 26 23 00 1F 02 24 18 0A 00 03 19 43 00 03 18 80 00 43 10 21 8C 44 00 00 24 03 00 01 02 23 18 04 00 03 18 27 00 83 18 24 AC 43 00 00 0? ?? ?? ?? 00 00 80 21 8C 52 00 00 00 40 98 21 24 14 FF FF 02 12 18 2A 10 60 FF E2 8F BF 00 2C 0? ?? ?? ?? 00 00 00 00 8C 42 00 00 00 10 18 C0 00 43 18 21 8C 64 00 00 14 91 FF F6 26 10 00 01 AC 74 00 00 0? ?? ?? ?? 8E 72 00 00 }
	condition:
		$1
}

rule file_356_3_0 {
	meta:
		name = "svc_register"
		size = 216
		refs = "0078 malloc 0090 __rpc_thread_variables 00c0 pmap_set"
	strings:
		$1 = { 27 BD FF C8 AF B2 00 28 00 A0 90 21 AF B4 00 30 AF B1 00 24 00 C0 28 21 00 C0 88 21 00 80 A0 21 27 A6 00 18 02 40 20 21 AF B3 00 2C AF B0 00 20 AF BF 00 34 0? ?? ?? ?? 00 E0 98 21 10 40 00 0E 00 40 80 21 8C 42 00 0C 10 53 00 18 8F A2 00 48 00 00 98 21 8F BF 00 34 02 60 10 21 8F B4 00 30 8F B3 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 38 0? ?? ?? ?? 24 04 00 14 10 40 FF F3 00 40 80 21 AC 52 00 04 AC 51 00 08 0? ?? ?? ?? AC 53 00 0C 8C 43 00 B4 AE 00 00 10 AE 03 00 00 AC 50 00 B4 8F A2 00 48 10 40 FF E9 24 13 00 01 96 87 00 04 02 40 20 21 02 20 28 21 0? ?? ?? ?? 00 40 30 21 10 40 FF E1 00 00 00 00 0? ?? ?? ?? AE 13 00 10 }
	condition:
		$1
}

rule file_356_4_0 {
	meta:
		name = "svc_unregister"
		size = 164
		refs = "0044 free 0070 pmap_unset 0090 __rpc_thread_variables"
	strings:
		$1 = { 27 BD FF D0 27 A6 00 1C AF B2 00 28 AF B1 00 24 AF B0 00 20 AF BF 00 2C 00 80 90 21 0? ?? ?? ?? 00 A0 88 21 10 40 00 14 00 40 80 21 8F A2 00 1C 10 40 00 17 00 00 00 00 8E 03 00 00 AC 43 00 00 02 00 20 21 0? ?? ?? ?? AE 00 00 00 02 40 20 21 02 20 28 21 0? ?? ?? ?? 27 A6 00 18 10 40 00 04 02 40 20 21 8C 42 00 10 14 40 00 04 8F BF 00 2C 0? ?? ?? ?? 02 20 28 21 8F BF 00 2C 8F B2 00 28 8F B1 00 24 8F B0 00 20 03 E0 00 08 27 BD 00 30 0? ?? ?? ?? 00 00 00 00 8E 03 00 00 0? ?? ?? ?? AC 43 00 B4 }
	condition:
		$1
}

rule file_356_5_0 {
	meta:
		name = "svc_sendreply"
		size = 84
	strings:
		$1 = { 8C 88 00 20 8C 87 00 24 8C 83 00 28 8C 82 00 08 27 BD FF B0 AF A5 00 38 AF A8 00 24 AF A7 00 28 AF A3 00 2C AF A6 00 34 AF A0 00 30 8C 59 00 0C 24 02 00 01 AF BF 00 4C 27 A5 00 18 AF A2 00 1C 03 20 F8 09 AF A0 00 20 8F BF 00 4C 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_356_6_0 {
	meta:
		name = "svcerr_noproc"
		size = 80
	strings:
		$1 = { 8C 83 00 28 8C 85 00 24 8C 86 00 20 27 BD FF B0 8C 82 00 08 AF A3 00 2C 24 03 00 03 AF A6 00 24 AF A5 00 28 AF A3 00 30 8C 59 00 0C 24 02 00 01 AF BF 00 4C 27 A5 00 18 AF A2 00 1C 03 20 F8 09 AF A0 00 20 8F BF 00 4C 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_356_7_0 {
	meta:
		name = "svcerr_decode"
		size = 80
	strings:
		$1 = { 8C 83 00 28 8C 85 00 24 8C 86 00 20 27 BD FF B0 8C 82 00 08 AF A3 00 2C 24 03 00 04 AF A6 00 24 AF A5 00 28 AF A3 00 30 8C 59 00 0C 24 02 00 01 AF BF 00 4C 27 A5 00 18 AF A2 00 1C 03 20 F8 09 AF A0 00 20 8F BF 00 4C 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_356_8_0 {
	meta:
		name = "svcerr_systemerr"
		size = 80
	strings:
		$1 = { 8C 83 00 28 8C 85 00 24 8C 86 00 20 27 BD FF B0 8C 82 00 08 AF A3 00 2C 24 03 00 05 AF A6 00 24 AF A5 00 28 AF A3 00 30 8C 59 00 0C 24 02 00 01 AF BF 00 4C 27 A5 00 18 AF A2 00 1C 03 20 F8 09 AF A0 00 20 8F BF 00 4C 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_356_9_0 {
	meta:
		name = "svcerr_auth"
		size = 56
	strings:
		$1 = { 8C 83 00 08 27 BD FF B0 24 02 00 01 AF A5 00 28 AF A2 00 24 8C 79 00 0C AF BF 00 4C 27 A5 00 18 AF A2 00 1C 03 20 F8 09 AF A2 00 20 8F BF 00 4C 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_356_10_0 {
	meta:
		name = "svcerr_weakauth"
		size = 60
	strings:
		$1 = { 8C 83 00 08 27 BD FF B0 24 02 00 01 24 05 00 05 AF A5 00 28 AF A2 00 24 8C 79 00 0C AF BF 00 4C 27 A5 00 18 AF A2 00 1C 03 20 F8 09 AF A2 00 20 8F BF 00 4C 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_356_11_0 {
	meta:
		name = "svcerr_noprog"
		size = 76
	strings:
		$1 = { 8C 85 00 28 8C 87 00 20 8C 86 00 24 8C 83 00 08 27 BD FF B0 24 02 00 01 AF A7 00 24 AF A6 00 28 AF A5 00 2C AF A2 00 30 8C 79 00 0C AF BF 00 4C 27 A5 00 18 AF A2 00 1C 03 20 F8 09 AF A0 00 20 8F BF 00 4C 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_356_12_0 {
	meta:
		name = "svcerr_progvers"
		size = 88
	strings:
		$1 = { 8C 83 00 28 8C 88 00 20 8C 87 00 24 27 BD FF B0 8C 82 00 08 AF A3 00 2C 24 03 00 02 AF A5 00 34 AF A8 00 24 AF A7 00 28 AF A3 00 30 AF A6 00 38 8C 59 00 0C 24 02 00 01 AF BF 00 4C 27 A5 00 18 AF A2 00 1C 03 20 F8 09 AF A0 00 20 8F BF 00 4C 03 E0 00 08 27 BD 00 50 }
	condition:
		$1
}

rule file_356_13_0 {
	meta:
		name = "svc_getreq_common"
		size = 496
		refs = "0024 __rpc_thread_variables 0044 _null_auth 0110 svcerr_progvers 0150 svcerr_noprog 019c _authenticate"
	strings:
		$1 = { 27 BD FA A8 27 A2 00 18 AF A2 05 14 27 A2 01 A8 AF B1 05 4C AF B0 05 48 AF BF 05 54 00 80 80 21 AF B2 05 50 0? ?? ?? ?? AF A2 05 20 00 40 88 21 8C 42 00 B0 00 10 80 80 00 50 10 21 8C 50 00 00 12 00 00 3D 3C 12 ?? ?? 8E 02 00 08 02 00 20 21 8C 59 00 00 03 20 F8 09 27 A5 04 F8 10 40 00 2E 27 A3 03 38 AF A3 05 40 8F A3 05 04 8F A2 05 10 AF B0 05 44 AF A3 05 28 8F A3 05 08 AF A2 05 34 AF A3 05 2C 8F A3 05 0C AF A3 05 30 8F A3 05 14 AF A3 05 38 8F A3 05 18 14 40 00 3F AF A3 05 3C 8E 42 ?? ?? AE 00 00 28 AE 02 00 20 8E 23 00 B4 10 60 00 27 8F A8 05 28 8F AA 05 2C 00 00 48 21 00 00 30 21 0? ?? ?? ?? 24 05 FF FF 8C 63 00 00 10 60 00 0D 00 00 00 00 8C 67 00 04 15 07 FF FB 00 00 00 00 8C 67 00 08 24 09 00 01 00 E5 20 2B 10 EA 00 39 00 C7 10 2B 8C 63 00 00 00 E4 28 0B 14 60 FF F5 00 E2 30 0B 11 20 00 11 00 00 00 00 0? ?? ?? ?? 02 00 20 21 8E 02 00 08 8C 59 00 04 03 20 F8 09 02 00 20 21 10 40 00 11 24 03 00 01 10 43 FF C5 00 00 00 00 8F BF 05 54 8F B2 05 50 8F B1 05 4C 8F B0 05 48 03 E0 00 08 27 BD 05 58 0? ?? ?? ?? 02 00 20 21 8E 02 00 08 8C 59 00 04 03 20 F8 09 02 00 20 21 14 40 FF F1 24 03 00 01 8E 02 00 08 8C 59 00 14 03 20 F8 09 02 00 20 21 8F BF 05 54 8F B2 05 50 8F B1 05 4C 8F B0 05 48 03 E0 00 08 27 BD 05 58 27 A4 05 28 0? ?? ?? ?? 27 A5 04 F8 10 40 FF C1 24 03 00 01 AF A3 04 D4 AF A2 04 D8 AF A3 04 D0 8E 02 00 08 AF A3 04 CC 02 00 20 21 8C 59 00 0C 03 20 F8 09 27 A5 04 C8 0? ?? ?? ?? 8E 02 00 08 8C 79 00 0C 27 A4 05 28 03 20 F8 09 02 00 28 21 0? ?? ?? ?? 8E 02 00 08 }
	condition:
		$1
}

rule file_356_14_0 {
	meta:
		name = "svc_getreqset"
		size = 184
		refs = "0024 _rpc_dtablesize 0058 svc_getreq_common"
	strings:
		$1 = { 27 BD FF C8 AF B6 00 30 AF B5 00 2C AF B4 00 28 AF B3 00 24 AF B2 00 20 AF BF 00 34 AF B1 00 1C AF B0 00 18 0? ?? ?? ?? 00 80 A8 21 24 16 04 00 28 43 04 01 00 43 B0 0B 00 00 90 21 24 13 00 1F 1A C0 00 13 24 14 00 01 26 B5 00 04 0? ?? ?? ?? 8E B0 FF FC 02 34 88 04 0? ?? ?? ?? 02 11 80 26 00 10 88 23 02 11 88 24 72 31 88 20 02 71 88 23 26 23 00 01 02 43 20 21 14 60 FF F6 24 84 FF FF 26 52 00 20 02 56 10 2A 14 40 FF F0 26 B5 00 04 8F BF 00 34 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 38 }
	condition:
		$1
}

rule file_356_15_0 {
	meta:
		name = "svc_getreq"
		size = 56
		refs = "0024 svc_getreqset"
	strings:
		$1 = { 27 BD FF 60 00 80 28 21 27 A2 00 18 AF BF 00 9C 27 A3 00 98 AC 40 00 00 24 42 00 04 14 43 FF FD 27 A4 00 18 0? ?? ?? ?? AF A5 00 18 8F BF 00 9C 03 E0 00 08 27 BD 00 A0 }
	condition:
		$1
}

rule file_356_16_0 {
	meta:
		name = "svc_getreq_poll"
		size = 228
		refs = "002c __rpc_thread_svc_max_pollfd 0070 __rpc_thread_variables 0080 xprt_unregister 00d4 svc_getreq_common"
	strings:
		$1 = { 27 BD FF C8 AF B4 00 28 AF BF 00 34 AF B6 00 30 AF B5 00 2C AF B3 00 24 AF B2 00 20 AF B1 00 1C AF B0 00 18 10 A0 00 21 00 A0 A0 21 0? ?? ?? ?? 00 80 80 21 8C 46 00 00 00 00 88 21 00 40 A8 21 02 26 18 2A 00 00 98 21 10 60 00 18 24 16 FF FF 8E 12 00 00 12 56 00 11 00 00 00 00 86 03 00 06 10 60 00 0E 30 62 00 20 10 40 00 1A 00 00 00 00 0? ?? ?? ?? 00 12 90 80 8C 42 00 B0 00 52 90 21 0? ?? ?? ?? 8E 44 00 00 26 73 00 01 02 74 10 2A 10 40 00 07 8F BF 00 34 8E A6 00 00 26 31 00 01 02 26 18 2A 14 60 FF EA 26 10 00 08 8F BF 00 34 8F B6 00 30 8F B5 00 2C 8F B4 00 28 8F B3 00 24 8F B2 00 20 8F B1 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 38 0? ?? ?? ?? 02 40 20 21 0? ?? ?? ?? 26 73 00 01 }
	condition:
		$1
}

rule file_356_17_0 {
	meta:
		name = "__svc_accept_failed"
		size = 100
		refs = "0000 __gnu_local_gp 0010 __libc_errno 0050 __nanosleep"
	strings:
		$1 = { 3C 1C ?? ?? 27 9C ?? ?? 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 27 BD FF D8 AF BF 00 24 00 62 10 21 8C 43 00 00 24 02 00 18 10 62 00 04 AF BC 00 10 8F BF 00 24 03 E0 00 08 27 BD 00 28 3C 02 02 FA 27 A4 00 18 00 00 28 21 34 42 F0 80 AF A0 00 18 0? ?? ?? ?? AF A2 00 1C 8F BF 00 24 03 E0 00 08 27 BD 00 28 }
	condition:
		$1
}

rule file_356_18_0 {
	meta:
		name = "__rpc_thread_svc_cleanup"
		size = 64
		refs = "000c __rpc_thread_variables 0020 svc_unregister"
	strings:
		$1 = { 27 BD FF E0 AF B0 00 18 AF BF 00 1C 0? ?? ?? ?? 00 00 00 00 0? ?? ?? ?? 00 40 80 21 8C 64 00 04 0? ?? ?? ?? 8C 65 00 08 8E 03 00 B4 14 60 FF FB 8F BF 00 1C 8F B0 00 18 03 E0 00 08 27 BD 00 20 }
	condition:
		$1
}

rule file_357_0_0 {
	meta:
		name = "__fxstatat64"
		size = 456
		refs = "0004 __gnu_local_gp 003c __have_atfcts 0088 __libc_errno 00e8 strlen 010c procfd.7592 0124 __snprintf 0150 __atfct_seterrno"
	strings:
		$1 = { 27 BD FF C0 3C 1C ?? ?? 27 9C ?? ?? AF BE 00 38 24 02 00 03 03 A0 F0 21 AF B1 00 28 AF BF 00 3C AF B4 00 34 AF B3 00 30 AF B2 00 2C AF B0 00 24 AF DC 00 18 14 82 00 52 8F D1 00 50 3C 13 ?? ?? 8E 62 ?? ?? 00 A0 90 21 00 C0 80 21 04 40 00 1C 00 E0 A0 21 00 A0 20 21 00 C0 28 21 00 E0 30 21 02 20 38 21 24 02 10 C5 00 00 00 0C 10 E0 00 4C 00 40 20 21 24 02 00 59 10 82 00 10 24 02 FF FF 7C 03 E8 3B 00 60 28 21 8F 83 ?? ?? 00 65 28 21 AC A4 00 00 03 C0 E8 21 8F DF 00 3C 8F BE 00 38 8F B4 00 34 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 40 AE 62 ?? ?? 24 02 FE FF 02 22 10 24 14 40 00 2D 00 00 00 00 24 02 FF 9C 12 42 00 28 24 02 00 2F 82 03 00 00 10 62 00 12 00 00 98 21 0? ?? ?? ?? 02 00 20 21 10 40 00 2D 8F DC 00 18 24 43 00 2E 00 03 18 C2 00 03 18 C0 03 A3 E8 23 27 B3 00 18 3C 06 ?? ?? AF B0 00 10 02 60 20 21 24 45 00 20 24 C6 ?? ?? 02 40 38 21 0? ?? ?? ?? 02 60 80 21 32 31 01 00 02 00 20 21 12 20 00 0A 02 80 28 21 24 02 10 76 00 00 00 0C 10 E0 FF D3 00 40 20 21 02 40 28 21 0? ?? ?? ?? 02 60 30 21 0? ?? ?? ?? 24 02 FF FF 24 02 10 75 00 00 00 0C 10 E0 FF CA 00 40 20 21 0? ?? ?? ?? 02 40 28 21 0? ?? ?? ?? 00 00 98 21 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 16 AC 43 00 00 0? ?? ?? ?? 24 02 FF FF 0? ?? ?? ?? 00 00 10 21 7C 03 E8 3B 00 60 10 21 8F 83 ?? ?? 00 62 10 21 24 03 00 02 AC 43 00 00 0? ?? ?? ?? 24 02 FF FF }
	condition:
		$1
}

rule file_358_0_0 {
	meta:
		name = "setdomainname"
		size = 28
	strings:
		$1 = { 24 02 10 19 00 00 00 0C 14 E0 FF FB 00 00 00 00 03 E0 00 08 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_359_0_0 {
	meta:
		name = "__posix_spawn"
		size = 44
		refs = "0018 __spawni"
	strings:
		$1 = { 27 BD FF D0 8F A2 00 40 AF A0 00 18 AF BF 00 2C AF A2 00 10 8F A2 00 44 0? ?? ?? ?? AF A2 00 14 8F BF 00 2C 03 E0 00 08 27 BD 00 30 }
	condition:
		$1
}

rule file_360_1_0 {
	meta:
		name = "svcudp_getargs"
		size = 20
	strings:
		$1 = { 8C 84 00 30 00 A0 C8 21 00 C0 28 21 03 20 00 08 24 84 00 08 }
	condition:
		$1
}

rule file_360_2_0 {
	meta:
		name = "svcudp_freeargs"
		size = 28
	strings:
		$1 = { 8C 84 00 30 24 02 00 02 00 A0 C8 21 AC 82 00 08 00 C0 28 21 03 20 00 08 24 84 00 08 }
	condition:
		$1
}

rule file_360_3_0 {
	meta:
		name = "svcudp_destroy"
		size = 100
		refs = "0014 xprt_unregister 001c __close 003c free"
	strings:
		$1 = { 27 BD FF D8 AF B0 00 1C 00 80 80 21 AF BF 00 24 AF B1 00 20 0? ?? ?? ?? 8C 91 00 30 0? ?? ?? ?? 8E 04 00 00 8E 22 00 0C 8C 59 00 1C 13 20 00 03 00 00 00 00 03 20 F8 09 26 24 00 08 0? ?? ?? ?? 8E 04 00 2C 0? ?? ?? ?? 02 20 20 21 8F BF 00 24 8F B1 00 20 02 00 20 21 8F B0 00 1C 0? ?? ?? ?? 27 BD 00 28 }
	condition:
		$1
}

rule file_360_4_0 {
	meta:
		name = "svcudp_recv"
		size = 972
		refs = "0000 __gnu_local_gp 0010 __libc_errno 00a8 __recvmsg 0174 xdr_callmsg 0220 memcmp 0250 __sendto 0274 __recvfrom 02a0 __svc_accept_failed 03bc __sendmsg"
	strings:
		$1 = { 3C 1C ?? ?? 27 BD FF B0 27 9C ?? ?? AF B4 00 3C 8F 94 ?? ?? AF B2 00 34 8C 92 00 30 7C 03 E8 3B AF B7 00 48 AF B6 00 44 AF B5 00 40 AF B3 00 38 AF B1 00 30 AF B0 00 2C AF BF 00 4C AF BC 00 18 00 80 80 21 00 A0 B8 21 24 96 00 34 24 93 00 3C 24 91 00 10 24 95 00 58 02 83 A0 21 8E 03 00 48 24 02 00 10 02 60 28 21 00 00 30 21 00 00 38 21 10 60 00 7B AF A2 00 20 8E 03 00 2C 8E 47 00 00 8E 04 00 00 AE 03 00 34 AE 02 00 40 24 03 00 01 24 02 00 DC AE 07 00 38 AE 16 00 44 AE 03 00 48 AE 11 00 3C AE 15 00 4C 0? ?? ?? ?? AE 02 00 50 04 40 00 73 8F A3 00 20 8E 05 00 50 8E 04 00 40 2C A3 00 0C 14 60 00 1D AF A4 00 20 8E 03 00 4C 10 60 00 1A 00 00 00 00 8C 66 00 00 2C C7 00 0C 14 E0 00 10 24 C7 00 03 24 08 FF FC 00 E8 38 24 00 67 38 21 00 65 28 21 24 E9 00 0C 00 A9 48 2B 15 20 00 08 00 00 00 00 8C E9 00 00 25 29 00 03 01 28 40 24 00 E8 38 21 00 A7 28 2B 10 A0 00 07 00 00 00 00 8C 65 00 04 14 A0 00 04 24 05 00 08 8C 67 00 08 10 E5 00 74 00 00 00 00 AE 00 00 4C AE 00 00 50 AE 04 00 0C 28 42 00 10 14 40 00 62 26 54 00 08 8E 42 00 0C 02 80 20 21 8C 59 00 14 24 02 00 01 00 00 28 21 03 20 F8 09 AE 42 00 08 02 80 20 21 0? ?? ?? ?? 02 E0 28 21 10 40 00 57 8F BF 00 4C 8E E3 00 00 8E 42 01 B0 10 40 00 63 AE 43 00 04 8E 02 00 30 8C 56 01 B0 8C 54 00 04 8E C2 00 00 8E C3 00 04 00 02 10 80 02 82 00 1B 00 40 01 F4 00 00 20 10 00 04 10 80 00 62 10 21 8C 52 00 00 16 40 00 06 26 D5 00 1C 0? ?? ?? ?? 8E E3 00 14 8E 52 00 28 12 40 00 52 00 00 00 00 8E 42 00 00 16 82 FF FB 00 00 00 00 8E 43 00 04 8E C2 00 18 14 62 FF F7 00 00 00 00 8E 43 00 08 8E C2 00 14 14 62 FF F3 00 00 00 00 8E 43 00 0C 8E C2 00 10 14 62 FF EF 26 44 00 10 02 A0 28 21 0? ?? ?? ?? 24 06 00 10 14 40 FF EA 00 00 00 00 8E 02 00 48 8E 45 00 20 14 40 00 5C 8E 46 00 24 8F A2 00 20 8E 04 00 00 00 00 38 21 AF B1 00 10 0? ?? ?? ?? AF A2 00 14 0? ?? ?? ?? 24 02 00 01 8E 46 00 00 8E 04 00 00 8E 05 00 2C 27 A2 00 20 AF B1 00 10 0? ?? ?? ?? AF A2 00 14 8F A3 00 20 AE 03 00 0C 24 03 FF FF 14 43 FF B0 28 42 00 10 8E 83 00 00 24 02 00 04 10 62 FF 70 00 00 00 00 0? ?? ?? ?? 00 00 00 00 00 00 10 21 8F BF 00 4C 8F B7 00 48 8F B6 00 44 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 50 8F BF 00 4C 8F B7 00 48 8F B6 00 44 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 00 00 10 21 03 E0 00 08 27 BD 00 50 2C C6 00 18 14 C0 FF 8B 00 00 00 00 0? ?? ?? ?? AC 60 00 0C 0? ?? ?? ?? 24 02 00 01 8E E3 00 14 24 02 00 01 AE C3 00 18 8E E3 00 10 AE C3 00 14 8E E3 00 0C AE C3 00 10 8A 26 00 00 8A 25 00 04 8A 24 00 08 8A 23 00 0C 9A 26 00 03 9A 25 00 07 9A 23 00 0F 9A 24 00 0B AA A6 00 00 BA A6 00 03 AA A5 00 04 BA A5 00 07 AA A4 00 08 BA A4 00 0B AA A3 00 0C BA A3 00 0F 8F BF 00 4C 8F B7 00 48 8F B6 00 44 8F B5 00 40 8F B4 00 3C 8F B3 00 38 8F B2 00 34 8F B1 00 30 8F B0 00 2C 03 E0 00 08 27 BD 00 50 8E 04 00 00 AE 05 00 34 AE 06 00 38 02 60 28 21 0? ?? ?? ?? 00 00 30 21 0? ?? ?? ?? 24 02 00 01 }
	condition:
		$1
}

rule file_360_5_0 {
	meta:
		name = "svcudp_reply"
		size = 780
		refs = "0054 xdr_replymsg 00b8 __sendmsg 02e0 _libc_intl_domainname 015c $LC3 016c __dcgettext 0174 $LC1 0180 __fxprintf 01cc __sendto 0204 xdrmem_create 02b4 malloc 02d8 free 02e4 $LC2 02fc $LC0"
	strings:
		$1 = { 27 BD FF C0 AF B0 00 24 8C 90 00 30 AF B2 00 2C AF BF 00 3C 8E 02 00 0C 26 12 00 08 AF B3 00 30 8C 59 00 14 AF B1 00 28 00 A0 98 21 AF B5 00 38 AF B4 00 34 00 00 28 21 00 80 88 21 AE 00 00 08 03 20 F8 09 02 40 20 21 8E 02 00 04 02 40 20 21 02 60 28 21 0? ?? ?? ?? AE 62 00 00 14 40 00 0A 00 00 10 21 8F BF 00 3C 8F B5 00 38 8F B4 00 34 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 03 E0 00 08 27 BD 00 40 8E 02 00 0C 8C 59 00 10 03 20 F8 09 02 40 20 21 8E 23 00 48 10 60 00 44 00 40 90 21 8E 22 00 2C 8E 24 00 00 AE 32 00 38 AE 22 00 34 26 25 00 3C 0? ?? ?? ?? 00 00 30 21 14 52 FF E8 00 00 10 21 8E 02 01 B0 10 40 00 2F 8F BF 00 3C 06 40 00 2E 8F B5 00 38 8E 34 00 30 8E 93 01 B0 8E 62 00 0C 8E 63 00 08 00 02 10 80 00 62 10 21 8C 50 00 00 12 00 00 6E 00 00 00 00 8E 62 00 00 8E 03 00 00 8E 64 00 04 00 02 10 80 00 62 00 1B 00 40 01 F4 00 00 28 10 00 05 10 80 00 82 10 21 8C 44 00 00 10 80 00 0B 00 00 00 00 16 04 00 06 00 00 00 00 0? ?? ?? ?? 8E 03 00 28 12 03 00 26 24 82 00 28 00 60 20 21 8C 83 00 28 14 60 FF FB 00 00 00 00 3C 04 ?? ?? 3C 05 ?? ?? 24 84 ?? ?? 24 A5 ?? ?? 24 06 00 05 0? ?? ?? ?? 00 00 00 00 3C 05 ?? ?? 00 00 20 21 24 A5 ?? ?? 0? ?? ?? ?? 00 40 30 21 8F BF 00 3C 8F B5 00 38 8F B4 00 34 8F B3 00 30 8F B2 00 2C 8F B1 00 28 8F B0 00 24 24 02 00 01 03 E0 00 08 27 BD 00 40 8E 22 00 0C 8E 24 00 00 8E 25 00 2C 26 23 00 10 AF A3 00 10 AF A2 00 14 02 40 30 21 0? ?? ?? ?? 00 00 38 21 0? ?? ?? ?? 00 00 00 00 8E 03 00 28 8E 86 00 00 AC 43 00 00 8E 02 00 20 8E 23 00 2C 00 40 28 21 AE 12 00 24 AE 03 00 20 26 84 00 08 AE 22 00 2C 0? ?? ?? ?? 00 00 38 21 8E 83 00 04 8E 65 00 18 8E 64 00 14 8E 62 00 10 AE 03 00 00 AE 05 00 04 AE 04 00 08 AE 02 00 0C 8E 66 00 1C 8E 65 00 20 8E 64 00 24 8E 62 00 28 AE 06 00 10 AE 05 00 14 AE 04 00 18 AE 02 00 1C 8E 62 00 0C 8E 25 00 30 8E 64 00 00 8C A7 01 B0 24 45 00 01 00 A4 00 1B 00 80 01 F4 8C E4 00