/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.chartData.processors;

import java.awt.font.FontRenderContext;
import java.util.Iterator;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.chartData.interfaces.IAxisChartDataSet;
import org.jCharts.chartData.interfaces.IAxisPlotDataSet;
import org.jCharts.chartData.interfaces.IDataSeries;
import org.jCharts.chartData.interfaces.IStockChartDataSet;
import org.jCharts.chartData.processors.NonStackedDataProcessor;
import org.jCharts.chartData.processors.StackedDataProcessor;
import org.jCharts.chartData.processors.StockDataProcessor;
import org.jCharts.properties.DataAxisProperties;
import org.jCharts.types.ChartType;

public class AxisChartDataProcessor {
    private double max;
    private double min;
    private int numberOfElementsInADataSet;

    public void processData(AxisChart axisChart, FontRenderContext fontRenderContext) {
        DataAxisProperties dataAxisProperties = axisChart.getAxisProperties().isPlotHorizontal() ? (DataAxisProperties)axisChart.getAxisProperties().getXAxisProperties() : (DataAxisProperties)axisChart.getAxisProperties().getYAxisProperties();
        if (!dataAxisProperties.hasUserDefinedScale()) {
            this.processDataSet((IDataSeries)axisChart.getIAxisDataSeries());
        }
        Iterator iterator = axisChart.getIAxisDataSeries().getIAxisPlotDataSetIterator();
        IAxisPlotDataSet iAxisPlotDataSet = (IAxisPlotDataSet)iterator.next();
        this.numberOfElementsInADataSet = iAxisPlotDataSet.getNumberOfDataItems();
    }

    private void processDataSet(IDataSeries iDataSeries) {
        Iterator iterator = iDataSeries.getIAxisPlotDataSetIterator();
        while (iterator.hasNext()) {
            IAxisPlotDataSet iAxisPlotDataSet = (IAxisPlotDataSet)iterator.next();
            if (iAxisPlotDataSet.getChartType().isStacked()) {
                StackedDataProcessor.processData((IAxisChartDataSet)iAxisPlotDataSet, this);
                continue;
            }
            if (iAxisPlotDataSet.getChartType().equals(ChartType.STOCK)) {
                StockDataProcessor.processData((IStockChartDataSet)iAxisPlotDataSet, this);
                continue;
            }
            NonStackedDataProcessor.processData((IAxisChartDataSet)iAxisPlotDataSet, this);
        }
    }

    void setMaxValue(double d) {
        this.max = d;
    }

    public double getMaxValue() {
        return this.max;
    }

    void setMinValue(double d) {
        this.min = d;
    }

    public double getMinValue() {
        return this.min;
    }

    public int getNumberOfElementsInADataSet() {
        return this.numberOfElementsInADataSet;
    }
}

