/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads.openmodel;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.jmeter.threads.openmodel.DefaultThreadSchedule;
import org.apache.jmeter.threads.openmodel.ParserException;
import org.apache.jmeter.threads.openmodel.ScheduleParser;
import org.apache.jmeter.threads.openmodel.ThreadSchedule;
import org.apache.jmeter.threads.openmodel.ThreadScheduleStep;
import org.apache.jmeter.threads.openmodel.TimeUnitExtensionsKt;
import org.apache.jmeter.threads.openmodel.TokenizerException;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"FORMAT", "Ljava/text/DecimalFormat;", "ThreadSchedule", "Lorg/apache/jmeter/threads/openmodel/ThreadSchedule;", "schedule", "", "ApacheJMeter_core"})
@JvmName(name="ThreadScheduleUtils")
public final class ThreadScheduleUtils {
    @NotNull
    private static final DecimalFormat FORMAT = new DecimalFormat("#.#", DecimalFormatSymbols.getInstance(Locale.ROOT));

    @API(status=API.Status.EXPERIMENTAL, since="5.5")
    @NotNull
    public static final ThreadSchedule ThreadSchedule(@NotNull String schedule) throws ParserException, TokenizerException {
        ThreadSchedule threadSchedule;
        Intrinsics.checkNotNullParameter((Object)schedule, (String)"schedule");
        Integer n = StringsKt.toIntOrNull((String)schedule);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            double rate = it;
            Object[] objectArray = new ThreadScheduleStep[]{new ThreadScheduleStep.RateStep(rate), new ThreadScheduleStep.ArrivalsStep(ThreadScheduleStep.ArrivalType.EVEN, 1.0), new ThreadScheduleStep.RateStep(rate), new ThreadScheduleStep.RateStep(0.0), new ThreadScheduleStep.ArrivalsStep(ThreadScheduleStep.ArrivalType.EVEN, TimeUnitExtensionsKt.getAsSeconds(TimeUnit.HOURS))};
            threadSchedule = new DefaultThreadSchedule(CollectionsKt.listOf((Object[])objectArray));
        } else {
            threadSchedule = new ScheduleParser(schedule).parse();
        }
        return threadSchedule;
    }

    public static final /* synthetic */ DecimalFormat access$getFORMAT$p() {
        return FORMAT;
    }
}

