/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.colorspace;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.colorspace.LAB;
import org.jetbrains.letsPlot.commons.colorspace.XYZ;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0001\u00a8\u0006\u0006"}, d2={"labFromXyz", "Lorg/jetbrains/letsPlot/commons/colorspace/LAB;", "xyz", "Lorg/jetbrains/letsPlot/commons/colorspace/XYZ;", "xyzFromLab", "lab", "commons"})
public final class LABKt {
    @NotNull
    public static final LAB labFromXyz(@NotNull XYZ xyz) {
        Intrinsics.checkNotNullParameter((Object)xyz, (String)"xyz");
        double preA = LABKt.labFromXyz$transform(xyz.getX() / 95.047);
        double preL = LABKt.labFromXyz$transform(xyz.getY() / 100.0);
        double preB = LABKt.labFromXyz$transform(xyz.getZ() / 108.883);
        double l = 116.0 * preL - 16.0;
        double a = 500.0 * (preA - preL);
        double b = 200.0 * (preL - preB);
        return new LAB(l, a, b);
    }

    @NotNull
    public static final XYZ xyzFromLab(@NotNull LAB lab) {
        Intrinsics.checkNotNullParameter((Object)lab, (String)"lab");
        double preY = (lab.getL() + 16.0) / 116.0;
        double preX = lab.getA() / 500.0 + preY;
        double preZ = preY - lab.getB() / 200.0;
        double x2 = LABKt.xyzFromLab$transform$0(preX) * 95.047;
        double y2 = LABKt.xyzFromLab$transform$0(preY) * 100.0;
        double z = LABKt.xyzFromLab$transform$0(preZ) * 108.883;
        return new XYZ(x2, y2, z);
    }

    private static final double labFromXyz$transform(double v) {
        return v > 0.008856 ? Math.cbrt(v) : 7.787 * v + 0.13793103448275862;
    }

    private static final double xyzFromLab$transform$0(double v) {
        return Math.pow(v, 3) > 0.008856 ? Math.pow(v, 3) : (v - 0.13793103448275862) / 7.787;
    }
}

