import { jsx as _jsx } from "react/jsx-runtime";
/**
 * @license
 * Copyright 2026 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { describe, it, expect } from 'vitest';
import { ToolGroupMessage } from './ToolGroupMessage.js';
import { renderWithProviders } from '../../../test-utils/render.js';
import { StreamingState } from '../../types.js';
import { OverflowProvider } from '../../contexts/OverflowContext.js';
import { waitFor } from '../../../test-utils/async.js';
import { CoreToolCallStatus } from '@google/gemini-cli-core';
describe('ToolResultDisplay Overflow', () => {
    it('should display "press ctrl-o" hint when content overflows in ToolGroupMessage', async () => {
        // Large output that will definitely overflow
        const lines = [];
        for (let i = 0; i < 50; i++) {
            lines.push(`line ${i + 1}`);
        }
        const resultDisplay = lines.join('\n');
        const toolCalls = [
            {
                callId: 'call-1',
                name: 'test-tool',
                description: 'a test tool',
                status: CoreToolCallStatus.Success,
                resultDisplay,
                confirmationDetails: undefined,
            },
        ];
        const { lastFrame } = renderWithProviders(_jsx(OverflowProvider, { children: _jsx(ToolGroupMessage, { item: { id: 1, type: 'tool_group', tools: toolCalls }, toolCalls: toolCalls, availableTerminalHeight: 15, terminalWidth: 80, isExpandable: true }) }), {
            uiState: {
                streamingState: StreamingState.Idle,
                constrainHeight: true,
            },
            useAlternateBuffer: true,
        });
        // ResizeObserver might take a tick
        await waitFor(() => expect(lastFrame()?.toLowerCase()).toContain('press ctrl+o to show more lines'));
        const frame = lastFrame();
        expect(frame).toBeDefined();
        if (frame) {
            expect(frame.toLowerCase()).toContain('press ctrl+o to show more lines');
            // Ensure it's AFTER the bottom border
            const linesOfOutput = frame.split('\n');
            const bottomBorderIndex = linesOfOutput.findLastIndex((l) => l.includes('╰─'));
            const hintIndex = linesOfOutput.findIndex((l) => l.toLowerCase().includes('press ctrl+o to show more lines'));
            expect(hintIndex).toBeGreaterThan(bottomBorderIndex);
            expect(frame).toMatchSnapshot();
        }
    });
});
//# sourceMappingURL=ToolResultDisplayOverflow.test.js.map