/**
 * @license
 * Copyright 2026 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import type { TextBuffer } from '../components/shared/text-buffer.js';
import type { GenericListItem } from '../components/shared/SearchableList.js';
export interface UseRegistrySearchResult<T extends GenericListItem> {
    filteredItems: T[];
    searchBuffer: TextBuffer | undefined;
    searchQuery: string;
    setSearchQuery: (query: string) => void;
    maxLabelWidth: number;
}
export declare function useRegistrySearch<T extends GenericListItem>(props: {
    items: T[];
    initialQuery?: string;
    onSearch?: (query: string) => void;
}): UseRegistrySearchResult<T>;
