/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
export interface SemanticColors {
    text: {
        primary: string;
        secondary: string;
        link: string;
        accent: string;
        response: string;
    };
    background: {
        primary: string;
        message: string;
        input: string;
        diff: {
            added: string;
            removed: string;
        };
    };
    border: {
        default: string;
        focused: string;
    };
    ui: {
        comment: string;
        symbol: string;
        dark: string;
        gradient: string[] | undefined;
    };
    status: {
        error: string;
        success: string;
        warning: string;
    };
}
export declare const lightSemanticColors: SemanticColors;
export declare const darkSemanticColors: SemanticColors;
