/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Random;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.raw.log.LogCounter;
import org.apache.derby.impl.store.raw.log.LogToFile;
import org.apache.derby.io.StorageRandomAccessFile;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_Generic;
import org.apache.derbyTesting.unitTests.store.T_RawStoreRow;
import org.apache.derbyTesting.unitTests.store.T_TWC;
import org.apache.derbyTesting.unitTests.store.T_Util;

public class T_RecoverBadLog
extends T_Generic {
    private String testService = "BadLogTest";
    static final String REC_001 = "McLaren";
    static final String REC_002 = "Ferrari";
    static final String REC_003 = "Benetton";
    static final String REC_004 = "Prost";
    static final String REC_005 = "Tyrell";
    static final String REC_006 = "Derby, Natscape, Goatscape, the popular names";
    static final String REC_UNDO = "Lotus";
    static final String SP1 = "savepoint1";
    static final String SP2 = "savepoint2";
    private RandomAccessFile infofile = null;
    private boolean setup;
    private boolean test1;
    private boolean test2;
    private boolean test3;
    private boolean test4;
    private boolean test5;
    private boolean test6;
    private boolean test7;
    private boolean checksumTest;
    private String infoPath = "extinout/T_RecoverBadLog.info";
    private static final String TEST_BADLOG_SETUP = "TestBadLogSetup";
    private static final String TEST_BADLOG1 = "TestBadLog1";
    private static final String TEST_BADLOG2 = "TestBadLog2";
    private static final String TEST_BADLOG3 = "TestBadLog3";
    private static final String TEST_BADLOG4 = "TestBadLog4";
    private static final String TEST_BADLOG5 = "TestBadLog5";
    private static final String TEST_BADLOG6 = "TestBadLog6";
    private static final String TEST_BADLOG7 = "TestBadLog7";
    private static final String TEST_BAD_CHECKSUM_LOG = "TestBadChecksumLog";
    private static final String TEST_BADLOG_INFO = "TestBadLogInfo";
    private static final String TEST_BADCHECKSUMLOG_INFO = "TestBadChecksumLogInfo";
    RawStoreFactory factory;
    LockFactory lf;
    LogToFile logFactory;
    ContextService contextService;
    T_Util t_util;

    public String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.store.raw.RawStoreFactory";
    }

    private void getConfig() {
        String param = PropertyUtil.getSystemProperty((String)TEST_BADLOG_SETUP);
        this.setup = Boolean.valueOf(param);
        param = PropertyUtil.getSystemProperty((String)TEST_BADLOG1);
        this.test1 = Boolean.valueOf(param);
        param = PropertyUtil.getSystemProperty((String)TEST_BADLOG2);
        this.test2 = Boolean.valueOf(param);
        param = PropertyUtil.getSystemProperty((String)TEST_BADLOG3);
        this.test3 = Boolean.valueOf(param);
        param = PropertyUtil.getSystemProperty((String)TEST_BADLOG4);
        this.test4 = Boolean.valueOf(param);
        param = PropertyUtil.getSystemProperty((String)TEST_BADLOG5);
        this.test5 = Boolean.valueOf(param);
        param = PropertyUtil.getSystemProperty((String)TEST_BADLOG6);
        this.test6 = Boolean.valueOf(param);
        param = PropertyUtil.getSystemProperty((String)TEST_BADLOG7);
        this.test7 = Boolean.valueOf(param);
        param = PropertyUtil.getSystemProperty((String)TEST_BAD_CHECKSUM_LOG);
        this.checksumTest = Boolean.valueOf(param);
        if (this.checksumTest) {
            this.infoPath = "extinout/T_RecoverBadChecksumLog.info";
            this.testService = "BadChecksumLogTest";
        }
    }

    public void runTests() throws T_Fail {
        this.getConfig();
        int tests = 0;
        if (this.setup) {
            ++tests;
        }
        if (this.test1) {
            ++tests;
        }
        if (this.test2) {
            ++tests;
        }
        if (this.test3) {
            ++tests;
        }
        if (this.test4) {
            ++tests;
        }
        if (this.test5) {
            ++tests;
        }
        if (this.test6) {
            ++tests;
        }
        if (this.test7) {
            ++tests;
        }
        if (tests != 1) {
            throw T_Fail.testFailMsg("One & only one of the bad log recovery test should be run");
        }
        this.REPORT("recoverBadLog cannot be run on an insane server");
    }

    private long find(long inkey) {
        if (this.infofile == null) {
            return -1L;
        }
        try {
            this.infofile.seek(0L);
            while (true) {
                long key;
                if ((key = this.infofile.readLong()) == inkey) {
                    long value = this.infofile.readLong();
                    return value;
                }
                this.infofile.readLong();
            }
        }
        catch (IOException ioe) {
            return -1L;
        }
    }

    private long key(int test, int param) {
        long i = test;
        return (i << 32) + (long)param;
    }

    private void register(long key, long value) throws T_Fail {
        try {
            this.infofile.seek(this.infofile.length());
            this.infofile.writeLong(key);
            this.infofile.writeLong(value);
        }
        catch (IOException ioe) {
            T_Fail.exceptionFail(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void STest1() throws T_Fail, StandardException {
        Transaction t = this.t_util.t_startTransaction();
        this.factory.checkpoint();
        try {
            long cid = this.t_util.t_addContainer(t, 0L);
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page page = this.t_util.t_getPage(c, 1L);
            int numcol = 40;
            T_RawStoreRow bigrow = new T_RawStoreRow(numcol);
            String string1 = "01234567890123456789";
            for (int i = 0; i < numcol; ++i) {
                bigrow.setColumn(i, string1);
            }
            RecordHandle rh = null;
            while (numcol > 0) {
                try {
                    rh = T_Util.t_insert(page, bigrow);
                    break;
                }
                catch (StandardException se) {
                    bigrow.setColumn(--numcol, (String)null);
                }
            }
            if (numcol == 0) {
                throw T_Fail.testFailMsg("cannot fit any column into the page");
            }
            this.t_util.t_commit(t);
            String string2 = "abcdefghijklmnopqrst";
            for (int i = 0; i < numcol; ++i) {
                bigrow.setColumn(i, string2);
            }
            c = this.t_util.t_openContainer(t, 0L, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            Page p2 = this.t_util.t_addPage(c);
            T_Util.t_insert(p2, new T_RawStoreRow(REC_001));
            this.factory.checkpoint();
            if (!this.checksumTest) {
                SanityManager.DEBUG_SET((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
                System.setProperty(LogToFile.TEST_LOG_PARTIAL_LOG_WRITE_NUM_BYTES, Integer.toString(numcol * 20));
            }
            this.logFactory.flushAll();
            int slot = page.getSlotNumber(rh);
            page.updateAtSlot(slot, (Object[])bigrow.getRow(), null);
            if (this.checksumTest) {
                this.simulateLogFileCorruption();
            }
            this.REPORT("badlog test1: cid = " + cid + " numcol " + numcol);
            this.register(this.key(1, 1), cid);
            this.register(this.key(1, 2), numcol);
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            SanityManager.DEBUG_CLEAR((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
            throw throwable;
        }
        SanityManager.DEBUG_CLEAR((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void RTest1() throws T_Fail, StandardException {
        long cid = this.find(this.key(1, 1));
        if (cid < 0L) {
            this.REPORT("bad log test1 not run");
            return;
        }
        int numcol = (int)this.find(this.key(1, 2));
        Transaction t = this.t_util.t_startTransaction();
        try {
            int i;
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page page = this.t_util.t_getPage(c, 1L);
            int optimisticNumcol = 40;
            T_RawStoreRow bigrow = new T_RawStoreRow(optimisticNumcol);
            for (int i2 = 0; i2 < optimisticNumcol; ++i2) {
                bigrow.setColumn(i2, (String)null);
            }
            page.fetchFromSlot((RecordHandle)null, 0, (Object[])bigrow.getRow(), (FetchDescriptor)null, false);
            String string1 = "01234567890123456789";
            for (i = 0; i < numcol; ++i) {
                DataValueDescriptor column = bigrow.getStorableColumn(i);
                if (column.toString().equals(string1)) continue;
                throw T_Fail.testFailMsg("Column " + i + " value incorrect, got :" + column.toString());
            }
            for (i = numcol; i < optimisticNumcol; ++i) {
                DataValueDescriptor column = bigrow.getStorableColumn(i);
                if (column.isNull()) continue;
                throw T_Fail.testFailMsg("Column " + i + " expect Null, got : " + column.toString());
            }
            this.REPORT("RTest1 passed");
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.t_util.t_commit(t);
            t.close();
            throw throwable;
        }
        this.t_util.t_commit(t);
        t.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void STest2() throws T_Fail, StandardException {
        Transaction t = this.t_util.t_startTransaction();
        try {
            long cid = this.t_util.t_addContainer(t, 0L);
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page page = this.t_util.t_getPage(c, 1L);
            int numcol = 40;
            T_RawStoreRow bigrow = new T_RawStoreRow(numcol);
            String string1 = "01234567890123456789";
            for (int i = 0; i < numcol; ++i) {
                bigrow.setColumn(i, string1);
            }
            RecordHandle rh = null;
            while (numcol > 0) {
                try {
                    rh = T_Util.t_insert(page, bigrow);
                    break;
                }
                catch (StandardException se) {
                    bigrow.setColumn(--numcol, (String)null);
                }
            }
            if (numcol == 0) {
                throw T_Fail.testFailMsg("cannot fit any column into the page");
            }
            rh = T_Util.t_insert(page, bigrow);
            this.t_util.t_commit(t);
            String string2 = "abcdefghijklmnopqrst";
            for (int i = 0; i < numcol; ++i) {
                bigrow.setColumn(i, string2);
            }
            c = this.t_util.t_openContainer(t, 0L, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            if (!this.checksumTest) {
                SanityManager.DEBUG_SET((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
                System.setProperty(LogToFile.TEST_LOG_PARTIAL_LOG_WRITE_NUM_BYTES, Integer.toString(numcol * 20));
            }
            this.logFactory.flushAll();
            int slot = page.getSlotNumber(rh);
            page.updateAtSlot(slot, (Object[])bigrow.getRow(), null);
            if (this.checksumTest) {
                this.simulateLogFileCorruption();
            }
            this.REPORT("badlog test2: cid = " + cid + " numcol " + numcol);
            this.register(this.key(2, 1), cid);
            this.register(this.key(2, 2), numcol);
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            SanityManager.DEBUG_CLEAR((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
            throw throwable;
        }
        SanityManager.DEBUG_CLEAR((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void RTest2() throws T_Fail, StandardException {
        long cid = this.find(this.key(2, 1));
        if (cid < 0L) {
            this.REPORT("bad log test2 not run");
            return;
        }
        int numcol = (int)this.find(this.key(2, 2));
        Transaction t = this.t_util.t_startTransaction();
        try {
            int i;
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page page = this.t_util.t_getPage(c, 1L);
            int optimisticNumcol = 40;
            T_RawStoreRow bigrow = new T_RawStoreRow(optimisticNumcol);
            for (int i2 = 0; i2 < optimisticNumcol; ++i2) {
                bigrow.setColumn(i2, (String)null);
            }
            page.fetchFromSlot((RecordHandle)null, 0, (Object[])bigrow.getRow(), (FetchDescriptor)null, false);
            String string1 = "01234567890123456789";
            for (i = 0; i < numcol; ++i) {
                DataValueDescriptor column = bigrow.getStorableColumn(i);
                if (column.toString().equals(string1)) continue;
                throw T_Fail.testFailMsg("Column " + i + " value incorrect, got :" + column.toString());
            }
            for (i = numcol; i < optimisticNumcol; ++i) {
                DataValueDescriptor column = bigrow.getStorableColumn(i);
                if (column.isNull()) continue;
                throw T_Fail.testFailMsg("Column " + i + " expect Null, got : " + column.toString());
            }
            this.REPORT("RTest2 passed");
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.t_util.t_commit(t);
            t.close();
            throw throwable;
        }
        this.t_util.t_commit(t);
        t.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void STest3() throws T_Fail, StandardException {
        int numtrans = 7;
        int numpages = 7;
        try {
            int j;
            int i;
            T_TWC[] t = new T_TWC[numtrans];
            for (i = 0; i < numtrans; ++i) {
                t[i] = this.t_util.t_startTransactionWithContext();
            }
            long[] cid = new long[numtrans];
            ContainerHandle[] c = new ContainerHandle[numtrans];
            for (i = 0; i < numtrans; ++i) {
                cid[i] = this.t_util.t_addContainer(t[i], 0L);
                this.t_util.t_commit(t[i]);
                c[i] = this.t_util.t_openContainer(t[i], 0L, cid[i], true);
            }
            Page[][] page = new Page[numtrans][numpages];
            long[][] pagenum = new long[numtrans][numpages];
            for (i = 0; i < numtrans; ++i) {
                for (j = 0; j < numpages; ++j) {
                    t[i].switchTransactionContext();
                    page[i][j] = this.t_util.t_addPage(c[i]);
                    pagenum[i][j] = page[i][j].getPageNumber();
                    t[i].resetContext();
                }
            }
            RecordHandle[][] rh = new RecordHandle[numtrans][numpages];
            T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
            for (i = 0; i < numtrans; ++i) {
                for (j = 0; j < numpages; ++j) {
                    t[i].switchTransactionContext();
                    rh[i][j] = T_Util.t_insert(page[i][j], row1);
                    t[i].resetContext();
                }
            }
            t[0].setSavePoint(SP1, null);
            T_RawStoreRow row2 = new T_RawStoreRow(REC_002);
            for (i = 0; i < numtrans; ++i) {
                for (j = 0; j < numpages; ++j) {
                    t[i].switchTransactionContext();
                    int slot = page[i][j].getSlotNumber(rh[i][j]);
                    page[i][j].updateAtSlot(slot, (Object[])row2.getRow(), null);
                    t[i].resetContext();
                }
            }
            for (i = 1; i < numtrans; ++i) {
                t[i].setSavePoint(SP1, null);
            }
            this.factory.checkpoint();
            T_RawStoreRow row3 = new T_RawStoreRow(REC_003);
            for (i = 0; i < numtrans; ++i) {
                for (j = 0; j < numpages; ++j) {
                    int slot = page[i][j].getSlotNumber(rh[i][j]);
                    page[i][j].updateAtSlot(slot, (Object[])row3.getRow(), null);
                }
            }
            for (i = 0; i < numtrans; ++i) {
                t[i].setSavePoint(SP2, null);
            }
            T_RawStoreRow row4 = new T_RawStoreRow(REC_004);
            for (i = 0; i < numtrans; ++i) {
                t[i].switchTransactionContext();
                for (j = 0; j < numpages; ++j) {
                    int slot = page[i][j].getSlotNumber(rh[i][j]);
                    page[i][j].updateAtSlot(slot, (Object[])row4.getRow(), null);
                }
                t[i].resetContext();
            }
            t[0].switchTransactionContext();
            for (j = 0; j < numpages; ++j) {
                page[0][j].unlatch();
            }
            t[0].rollbackToSavePoint(SP1, null);
            for (j = 0; j < numpages; ++j) {
                page[0][j] = this.t_util.t_getPage(c[0], pagenum[0][j]);
            }
            t[0].resetContext();
            this.factory.checkpoint();
            for (i = 1; i < numtrans; ++i) {
                t[i].switchTransactionContext();
                for (j = 0; j < numpages; ++j) {
                    T_Util.t_checkFetch(page[i][j], rh[i][j], REC_004);
                }
                t[i].resetContext();
            }
            t[0].switchTransactionContext();
            for (j = 0; j < numpages; ++j) {
                T_Util.t_checkFetch(page[0][j], rh[0][j], REC_001);
            }
            t[0].resetContext();
            T_RawStoreRow row5 = new T_RawStoreRow(REC_005);
            for (i = 0; i < numtrans; ++i) {
                t[i].switchTransactionContext();
                for (j = 0; j < numpages; ++j) {
                    int slot = page[i][j].getSlotNumber(rh[i][j]);
                    page[i][j].updateAtSlot(slot, (Object[])row5.getRow(), null);
                }
                t[i].resetContext();
            }
            for (i = 1; i < numtrans; ++i) {
                t[i].switchTransactionContext();
                for (j = 0; j < numpages; ++j) {
                    page[i][j].unlatch();
                }
                t[i].rollbackToSavePoint(SP2, null);
                for (j = 0; j < numpages; ++j) {
                    page[i][j] = this.t_util.t_getPage(c[i], pagenum[i][j]);
                }
                t[i].resetContext();
            }
            for (i = 1; i < numtrans; ++i) {
                t[i].switchTransactionContext();
                for (j = 0; j < numpages; ++j) {
                    T_Util.t_checkFetch(page[i][j], rh[i][j], REC_003);
                }
                t[i].resetContext();
            }
            t[0].switchTransactionContext();
            for (j = 0; j < numpages; ++j) {
                T_Util.t_checkFetch(page[0][j], rh[0][j], REC_005);
            }
            t[0].resetContext();
            this.factory.checkpoint();
            T_RawStoreRow row6 = new T_RawStoreRow(REC_006);
            for (i = 0; i < numtrans; ++i) {
                t[i].switchTransactionContext();
                for (j = 0; j < numpages; ++j) {
                    int slot = page[i][j].getSlotNumber(rh[i][j]);
                    page[i][j].updateAtSlot(slot, (Object[])row6.getRow(), null);
                }
                t[i].resetContext();
            }
            t[0].switchTransactionContext();
            for (j = 0; j < numpages; ++j) {
                page[0][j].unlatch();
            }
            t[0].rollbackToSavePoint(SP1, null);
            for (j = 0; j < numpages; ++j) {
                page[0][j] = this.t_util.t_getPage(c[0], pagenum[0][j]);
            }
            t[0].resetContext();
            for (i = 1; i < numtrans; ++i) {
                t[i].switchTransactionContext();
                for (j = 0; j < numpages; ++j) {
                    T_Util.t_checkFetch(page[i][j], rh[i][j], REC_006);
                    T_Util.t_checkRecordCount(page[i][j], 1, 1);
                }
                t[i].resetContext();
            }
            t[0].switchTransactionContext();
            for (j = 0; j < numpages; ++j) {
                T_Util.t_checkFetch(page[0][j], rh[0][j], REC_001);
                T_Util.t_checkRecordCount(page[0][j], 1, 1);
            }
            t[0].resetContext();
            for (i = 0; i < numtrans; ++i) {
                t[i].switchTransactionContext();
                for (j = 0; j < numpages; ++j) {
                    page[i][j].unlatch();
                }
                t[i].resetContext();
            }
            this.t_util.t_abort(t[1]);
            this.t_util.t_commit(t[2]);
            this.t_util.t_commit(t[4]);
            c[1] = this.t_util.t_openContainer(t[1], 0L, cid[1], false);
            c[2] = this.t_util.t_openContainer(t[2], 0L, cid[2], false);
            c[4] = this.t_util.t_openContainer(t[4], 0L, cid[4], false);
            for (j = 0; j < numpages; ++j) {
                t[0].switchTransactionContext();
                this.t_util.t_checkFetch(c[0], rh[0][j], REC_001);
                t[0].resetContext();
                t[1].switchTransactionContext();
                page[1][j] = this.t_util.t_getPage(c[1], pagenum[1][j]);
                T_Util.t_checkRecordCount(page[1][j], 1, 0);
                T_Util.t_checkFetchBySlot(page[1][j], 0, REC_001, true, false);
                page[1][j].unlatch();
                t[1].resetContext();
                t[2].switchTransactionContext();
                this.t_util.t_checkFetch(c[2], rh[2][j], REC_006);
                t[2].resetContext();
                t[3].switchTransactionContext();
                this.t_util.t_checkFetch(c[3], rh[3][j], REC_006);
                t[3].resetContext();
                t[4].switchTransactionContext();
                this.t_util.t_checkFetch(c[4], rh[4][j], REC_006);
                t[4].resetContext();
            }
            t[3].switchTransactionContext();
            Page badPage1 = this.t_util.t_addPage(c[3]);
            Page badPage2 = this.t_util.t_addPage(c[3]);
            i = 0;
            T_RawStoreRow row = new T_RawStoreRow("row at slot " + i);
            while (badPage1.spaceForInsert()) {
                if (T_Util.t_insertAtSlot(badPage1, i, row, (byte)2) == null) break;
                row = new T_RawStoreRow("row at slot " + ++i);
            }
            if (!this.checksumTest) {
                SanityManager.DEBUG_SET((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
                System.setProperty(LogToFile.TEST_LOG_PARTIAL_LOG_WRITE_NUM_BYTES, "200");
            }
            this.logFactory.flushAll();
            badPage1.copyAndPurge(badPage2, 0, i, 0);
            t[3].resetContext();
            if (this.checksumTest) {
                this.simulateLogFileCorruption();
            }
            this.REPORT("badlog test3: numtrans " + numtrans + " numpages " + numpages);
            for (i = 0; i < numtrans; ++i) {
                this.register(this.key(3, i + 10), cid[i]);
                String str = "container " + i + ":" + this.find(this.key(3, i + 10)) + " pages: ";
                for (j = 0; j < numpages; ++j) {
                    str = str + pagenum[i][j] + " ";
                    this.register(this.key(3, (i + 1) * 1000 + j), pagenum[i][j]);
                }
                this.REPORT("\t" + str);
            }
            this.register(this.key(3, 1), numtrans);
            this.register(this.key(3, 2), numpages);
            this.register(this.key(3, 3), badPage1.getPageNumber());
            this.register(this.key(3, 4), badPage2.getPageNumber());
            Object var22_26 = null;
        }
        catch (Throwable throwable) {
            Object var22_27 = null;
            SanityManager.DEBUG_CLEAR((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
            throw throwable;
        }
        SanityManager.DEBUG_CLEAR((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void RTest3() throws T_Fail, StandardException {
        int j;
        int i;
        int numtrans = (int)this.find(this.key(3, 1));
        if (numtrans < 0) {
            this.REPORT("bad log test3 not run");
            return;
        }
        int numpages = (int)this.find(this.key(3, 2));
        long badPagenum1 = this.find(this.key(3, 3));
        long badPagenum2 = this.find(this.key(3, 4));
        Transaction t = this.t_util.t_startTransaction();
        long[] cid = new long[numtrans];
        ContainerHandle[] c = new ContainerHandle[numtrans];
        long[][] pagenum = new long[numtrans][numpages];
        Page[][] page = new Page[numtrans][numpages];
        for (i = 0; i < numtrans; ++i) {
            cid[i] = this.find(this.key(3, i + 10));
            c[i] = this.t_util.t_openContainer(t, 0L, cid[i], true);
            for (j = 0; j < numpages; ++j) {
                pagenum[i][j] = this.find(this.key(3, (i + 1) * 1000 + j));
                page[i][j] = this.t_util.t_getPage(c[i], pagenum[i][j]);
            }
        }
        try {
            for (j = 0; j < numpages; ++j) {
                T_Util.t_checkRecordCount(page[0][j], 1, 0);
                T_Util.t_checkFetchBySlot(page[0][j], 0, REC_001, true, true);
                T_Util.t_checkRecordCount(page[1][j], 1, 0);
                T_Util.t_checkFetchBySlot(page[1][j], 0, REC_001, true, true);
                T_Util.t_checkRecordCount(page[2][j], 1, 1);
                T_Util.t_checkFetchBySlot(page[2][j], 0, REC_006, false, true);
                T_Util.t_checkRecordCount(page[3][j], 1, 0);
                T_Util.t_checkFetchBySlot(page[3][j], 0, REC_001, true, true);
                T_Util.t_checkRecordCount(page[4][j], 1, 1);
                T_Util.t_checkFetchBySlot(page[4][j], 0, REC_006, false, true);
            }
            Page badPage1 = this.t_util.t_getPage(c[3], badPagenum1);
            Page badPage2 = this.t_util.t_getPage(c[3], badPagenum2);
            T_Util.t_checkRecordCount(badPage1, 0, 0);
            T_Util.t_checkRecordCount(badPage2, 0, 0);
            this.REPORT("RTest3 passed: numtrans " + numtrans + " numpages " + numpages);
            for (i = 0; i < numtrans; ++i) {
                String str = "container " + i + ":" + cid[i] + " pages: ";
                for (j = 0; j < numpages; ++j) {
                    str = str + pagenum[i][j] + " ";
                }
                this.REPORT("\t" + str);
            }
            Object var18_15 = null;
        }
        catch (Throwable throwable) {
            Object var18_16 = null;
            this.t_util.t_commit(t);
            t.close();
            throw throwable;
        }
        this.t_util.t_commit(t);
        t.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void STest4() throws T_Fail, StandardException {
        Transaction t = this.t_util.t_startTransaction();
        try {
            long cid = this.t_util.t_addContainer(t, 0L);
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page page = this.t_util.t_getPage(c, 1L);
            int numcol = 40;
            T_RawStoreRow bigrow = new T_RawStoreRow(numcol);
            String string1 = "01234567890123456789";
            for (int i = 0; i < numcol; ++i) {
                bigrow.setColumn(i, string1);
            }
            RecordHandle rh = null;
            while (numcol > 0) {
                try {
                    rh = T_Util.t_insert(page, bigrow);
                    break;
                }
                catch (StandardException se) {
                    bigrow.setColumn(--numcol, (String)null);
                }
            }
            if (numcol == 0) {
                throw T_Fail.testFailMsg("cannot fit any column into the page");
            }
            this.t_util.t_commit(t);
            String string2 = "abcdefghijklmnopqrst";
            for (int i = 0; i < numcol; ++i) {
                bigrow.setColumn(i, string2);
            }
            c = this.t_util.t_openContainer(t, 0L, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            Page p2 = this.t_util.t_addPage(c);
            T_Util.t_insert(p2, new T_RawStoreRow(REC_001));
            if (!this.checksumTest) {
                SanityManager.DEBUG_SET((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
                System.setProperty(LogToFile.TEST_LOG_PARTIAL_LOG_WRITE_NUM_BYTES, Integer.toString(11));
            }
            this.logFactory.flushAll();
            int slot = page.getSlotNumber(rh);
            page.updateAtSlot(slot, (Object[])bigrow.getRow(), null);
            if (this.checksumTest) {
                this.simulateLogFileCorruption();
            }
            this.REPORT("badlog test4: cid = " + cid + " numcol " + numcol);
            this.register(this.key(4, 1), cid);
            this.register(this.key(4, 2), numcol);
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            SanityManager.DEBUG_CLEAR((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
            throw throwable;
        }
        SanityManager.DEBUG_CLEAR((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void RTest4() throws T_Fail, StandardException {
        long cid = this.find(this.key(4, 1));
        if (cid < 0L) {
            this.REPORT("bad log test4 not run");
            return;
        }
        int numcol = (int)this.find(this.key(4, 2));
        Transaction t = this.t_util.t_startTransaction();
        try {
            int i;
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page page = this.t_util.t_getPage(c, 1L);
            int optimisticNumcol = 40;
            T_RawStoreRow bigrow = new T_RawStoreRow(optimisticNumcol);
            for (int i2 = 0; i2 < optimisticNumcol; ++i2) {
                bigrow.setColumn(i2, (String)null);
            }
            page.fetchFromSlot((RecordHandle)null, 0, (Object[])bigrow.getRow(), (FetchDescriptor)null, false);
            String string1 = "01234567890123456789";
            for (i = 0; i < numcol; ++i) {
                DataValueDescriptor column = bigrow.getStorableColumn(i);
                if (column.toString().equals(string1)) continue;
                throw T_Fail.testFailMsg("Column " + i + " value incorrect, got :" + column.toString());
            }
            for (i = numcol; i < optimisticNumcol; ++i) {
                DataValueDescriptor column = bigrow.getStorableColumn(i);
                if (column.isNull()) continue;
                throw T_Fail.testFailMsg("Column " + i + " expect Null, got : " + column.toString());
            }
            this.REPORT("RTest4 passed");
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.t_util.t_commit(t);
            t.close();
            throw throwable;
        }
        this.t_util.t_commit(t);
        t.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void STest5() throws T_Fail, StandardException {
        Transaction t = this.t_util.t_startTransaction();
        try {
            long cid = this.t_util.t_addContainer(t, 0L);
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page page = this.t_util.t_getPage(c, 1L);
            int numcol = 40;
            T_RawStoreRow bigrow = new T_RawStoreRow(numcol);
            String string1 = "01234567890123456789";
            for (int i = 0; i < numcol; ++i) {
                bigrow.setColumn(i, string1);
            }
            RecordHandle rh = null;
            while (numcol > 0) {
                try {
                    rh = T_Util.t_insert(page, bigrow);
                    break;
                }
                catch (StandardException se) {
                    bigrow.setColumn(--numcol, (String)null);
                }
            }
            if (numcol == 0) {
                throw T_Fail.testFailMsg("cannot fit any column into the page");
            }
            this.t_util.t_commit(t);
            String string2 = "abcdefghijklmnopqrst";
            for (int i = 0; i < numcol; ++i) {
                bigrow.setColumn(i, string2);
            }
            c = this.t_util.t_openContainer(t, 0L, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            Page p2 = this.t_util.t_addPage(c);
            T_Util.t_insert(p2, new T_RawStoreRow(REC_001));
            if (!this.checksumTest) {
                SanityManager.DEBUG_SET((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
                System.setProperty(LogToFile.TEST_LOG_PARTIAL_LOG_WRITE_NUM_BYTES, Integer.toString(3));
            }
            this.logFactory.flushAll();
            int slot = page.getSlotNumber(rh);
            page.updateAtSlot(slot, (Object[])bigrow.getRow(), null);
            if (this.checksumTest) {
                this.simulateLogFileCorruption();
            }
            this.REPORT("badlog test5: cid = " + cid + " numcol " + numcol);
            this.register(this.key(5, 1), cid);
            this.register(this.key(5, 2), numcol);
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            SanityManager.DEBUG_CLEAR((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
            throw throwable;
        }
        SanityManager.DEBUG_CLEAR((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void RTest5() throws T_Fail, StandardException {
        long cid = this.find(this.key(5, 1));
        if (cid < 0L) {
            this.REPORT("bad log test5 not run");
            return;
        }
        int numcol = (int)this.find(this.key(5, 2));
        Transaction t = this.t_util.t_startTransaction();
        try {
            int i;
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page page = this.t_util.t_getPage(c, 1L);
            int optimisticNumcol = 40;
            T_RawStoreRow bigrow = new T_RawStoreRow(optimisticNumcol);
            for (int i2 = 0; i2 < optimisticNumcol; ++i2) {
                bigrow.setColumn(i2, (String)null);
            }
            page.fetchFromSlot((RecordHandle)null, 0, (Object[])bigrow.getRow(), (FetchDescriptor)null, false);
            String string1 = "01234567890123456789";
            for (i = 0; i < numcol; ++i) {
                DataValueDescriptor column = bigrow.getStorableColumn(i);
                if (column.toString().equals(string1)) continue;
                throw T_Fail.testFailMsg("Column " + i + " value incorrect, got :" + column.toString());
            }
            for (i = numcol; i < optimisticNumcol; ++i) {
                DataValueDescriptor column = bigrow.getStorableColumn(i);
                if (column.isNull()) continue;
                throw T_Fail.testFailMsg("Column " + i + " expect Null, got : " + column.toString());
            }
            this.REPORT("RTest5 passed");
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.t_util.t_commit(t);
            t.close();
            throw throwable;
        }
        this.t_util.t_commit(t);
        t.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void STest6() throws T_Fail, StandardException {
        Transaction t = this.t_util.t_startTransaction();
        try {
            long cid = this.t_util.t_addContainer(t, 0L);
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page page = this.t_util.t_getPage(c, 1L);
            int numcol = 40;
            T_RawStoreRow bigrow = new T_RawStoreRow(numcol);
            String string1 = "01234567890123456789";
            for (int i = 0; i < numcol; ++i) {
                bigrow.setColumn(i, string1);
            }
            RecordHandle rh = null;
            while (numcol > 0) {
                try {
                    rh = T_Util.t_insert(page, bigrow);
                    break;
                }
                catch (StandardException se) {
                    bigrow.setColumn(--numcol, (String)null);
                }
            }
            if (numcol == 0) {
                throw T_Fail.testFailMsg("cannot fit any column into the page");
            }
            this.t_util.t_commit(t);
            String string2 = "abcdefghijklmnopqrst";
            for (int i = 0; i < numcol; ++i) {
                bigrow.setColumn(i, string2);
            }
            c = this.t_util.t_openContainer(t, 0L, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            Page p2 = this.t_util.t_addPage(c);
            T_Util.t_insert(p2, new T_RawStoreRow(REC_001));
            if (!this.checksumTest) {
                SanityManager.DEBUG_SET((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
                System.setProperty(LogToFile.TEST_LOG_PARTIAL_LOG_WRITE_NUM_BYTES, Integer.toString(1014));
            }
            this.logFactory.flushAll();
            int slot = page.getSlotNumber(rh);
            page.updateAtSlot(slot, (Object[])bigrow.getRow(), null);
            if (this.checksumTest) {
                this.simulateLogFileCorruption();
            }
            this.REPORT("badlog test6: cid = " + cid + " numcol " + numcol);
            this.register(this.key(6, 1), cid);
            this.register(this.key(6, 2), numcol);
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            SanityManager.DEBUG_CLEAR((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
            throw throwable;
        }
        SanityManager.DEBUG_CLEAR((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void RTest6() throws T_Fail, StandardException {
        long cid = this.find(this.key(6, 1));
        if (cid < 0L) {
            this.REPORT("bad log test6 not run");
            return;
        }
        int numcol = (int)this.find(this.key(6, 2));
        Transaction t = this.t_util.t_startTransaction();
        try {
            int i;
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page page = this.t_util.t_getPage(c, 1L);
            int optimisticNumcol = 40;
            T_RawStoreRow bigrow = new T_RawStoreRow(optimisticNumcol);
            for (int i2 = 0; i2 < optimisticNumcol; ++i2) {
                bigrow.setColumn(i2, (String)null);
            }
            page.fetchFromSlot((RecordHandle)null, 0, (Object[])bigrow.getRow(), (FetchDescriptor)null, false);
            String string1 = "01234567890123456789";
            for (i = 0; i < numcol; ++i) {
                DataValueDescriptor column = bigrow.getStorableColumn(i);
                if (column.toString().equals(string1)) continue;
                throw T_Fail.testFailMsg("Column " + i + " value incorrect, got :" + column.toString());
            }
            for (i = numcol; i < optimisticNumcol; ++i) {
                DataValueDescriptor column = bigrow.getStorableColumn(i);
                if (column.isNull()) continue;
                throw T_Fail.testFailMsg("Column " + i + " expect Null, got : " + column.toString());
            }
            this.REPORT("RTest6 passed");
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.t_util.t_commit(t);
            t.close();
            throw throwable;
        }
        this.t_util.t_commit(t);
        t.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void STest7() throws T_Fail, StandardException {
        Transaction t = this.t_util.t_startTransaction();
        try {
            long cid = this.t_util.t_addContainer(t, 0L);
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page page = this.t_util.t_getPage(c, 1L);
            int numcol = 40;
            T_RawStoreRow bigrow = new T_RawStoreRow(numcol);
            String string1 = "01234567890123456789";
            for (int i = 0; i < numcol; ++i) {
                bigrow.setColumn(i, string1);
            }
            RecordHandle rh = null;
            while (numcol > 0) {
                try {
                    rh = T_Util.t_insert(page, bigrow);
                    break;
                }
                catch (StandardException se) {
                    bigrow.setColumn(--numcol, (String)null);
                }
            }
            if (numcol == 0) {
                throw T_Fail.testFailMsg("cannot fit any column into the page");
            }
            this.t_util.t_commit(t);
            String string2 = "abcdefghijklmnopqrst";
            for (int i = 0; i < numcol; ++i) {
                bigrow.setColumn(i, string2);
            }
            c = this.t_util.t_openContainer(t, 0L, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            Page p2 = this.t_util.t_addPage(c);
            T_Util.t_insert(p2, new T_RawStoreRow(REC_001));
            if (!this.checksumTest) {
                SanityManager.DEBUG_SET((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
                System.setProperty(LogToFile.TEST_LOG_PARTIAL_LOG_WRITE_NUM_BYTES, Integer.toString(2012));
            }
            this.logFactory.flushAll();
            int slot = page.getSlotNumber(rh);
            page.updateAtSlot(slot, (Object[])bigrow.getRow(), null);
            if (this.checksumTest) {
                this.simulateLogFileCorruption();
            }
            this.REPORT("badlog test7: cid = " + cid + " numcol " + numcol);
            this.register(this.key(7, 1), cid);
            this.register(this.key(7, 2), numcol);
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            SanityManager.DEBUG_CLEAR((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
            throw throwable;
        }
        SanityManager.DEBUG_CLEAR((String)LogToFile.TEST_LOG_INCOMPLETE_LOG_WRITE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void RTest7() throws T_Fail, StandardException {
        long cid = this.find(this.key(6, 1));
        if (cid < 0L) {
            this.REPORT("bad log test7 not run");
            return;
        }
        int numcol = (int)this.find(this.key(6, 2));
        Transaction t = this.t_util.t_startTransaction();
        try {
            int i;
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page page = this.t_util.t_getPage(c, 1L);
            int optimisticNumcol = 40;
            T_RawStoreRow bigrow = new T_RawStoreRow(optimisticNumcol);
            for (int i2 = 0; i2 < optimisticNumcol; ++i2) {
                bigrow.setColumn(i2, (String)null);
            }
            page.fetchFromSlot((RecordHandle)null, 0, (Object[])bigrow.getRow(), (FetchDescriptor)null, false);
            String string1 = "01234567890123456789";
            for (i = 0; i < numcol; ++i) {
                DataValueDescriptor column = bigrow.getStorableColumn(i);
                if (column.toString().equals(string1)) continue;
                throw T_Fail.testFailMsg("Column " + i + " value incorrect, got :" + column.toString());
            }
            for (i = numcol; i < optimisticNumcol; ++i) {
                DataValueDescriptor column = bigrow.getStorableColumn(i);
                if (column.isNull()) continue;
                throw T_Fail.testFailMsg("Column " + i + " expect Null, got : " + column.toString());
            }
            this.REPORT("RTest7 passed");
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.t_util.t_commit(t);
            t.close();
            throw throwable;
        }
        this.t_util.t_commit(t);
        t.close();
    }

    private void simulateLogFileCorruption() throws T_Fail, StandardException {
        LogCounter logInstant = (LogCounter)this.logFactory.getFirstUnflushedInstant();
        long filenum = logInstant.getLogFileNumber();
        long filepos = logInstant.getLogFilePosition();
        this.logFactory.flushAll();
        logInstant = (LogCounter)this.logFactory.getFirstUnflushedInstant();
        filenum = logInstant.getLogFileNumber();
        long amountOfLogWritten = logInstant.getLogFilePosition() - filepos;
        try {
            StorageRandomAccessFile log = this.logFactory.getLogFileToSimulateCorruption(filenum);
            int noWrites = (int)amountOfLogWritten / 512;
            filepos += 512L;
            Random r = new Random();
            for (int i = 0; i < noWrites; ++i) {
                this.REPORT("corruptig log file : filenum " + filenum + " fileposition " + filepos);
                log.seek(filepos);
                log.writeInt(r.nextInt());
                filepos += 512L;
            }
            log.sync(false);
            log.close();
        }
        catch (IOException ie) {
            throw T_Fail.exceptionFail(ie);
        }
    }
}

