/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.sttest.utils;

import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.system.sttest.tools.MemCheck;

public class CompressTable {
    static boolean startByIJ = false;
    static String dbURL = "jdbc:derby:testDB";
    static String driver = "org.apache.derby.jdbc.EmbeddedDriver";

    public static void main(String[] args) throws SQLException, IOException, InterruptedException, Exception, Throwable {
        Connection conn = null;
        Object d = null;
        Class.forName(driver).newInstance();
        try {
            conn = CompressTable.mystartJBMS();
        }
        catch (Throwable t) {
            return;
        }
        MemCheck mc = new MemCheck(200000);
        mc.start();
        CompressTable.compress(conn);
        System.exit(0);
    }

    public static Connection mystartJBMS() throws Throwable {
        Connection conn = null;
        if (startByIJ) {
            conn = ij.startJBMS();
        } else {
            try {
                conn = DriverManager.getConnection(dbURL + ";create=false");
                conn.setAutoCommit(false);
            }
            catch (SQLException se) {
                System.out.println("connect failed  for " + dbURL);
                JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)se);
            }
        }
        return conn;
    }

    static synchronized void compress(Connection conn) throws Exception {
        Statement s = null;
        int tick = 1;
        boolean locked = false;
        while (!locked) {
            try {
                s = conn.createStatement();
                s.execute("lock table Datatypes in exclusive mode");
                s.close();
                locked = true;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("X0X02")) {
                    Thread.sleep(20000L);
                    if (tick++ < 10) {
                        System.out.println("compress: cannot lock table, retrying " + tick + "\n");
                        continue;
                    }
                    System.out.println("compress timed out\n");
                    return;
                }
                JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)se);
            }
        }
        System.out.println("compressing table");
        try {
            s = conn.createStatement();
            s.execute("alter table Datatypes compress");
            System.out.println("table compressed");
        }
        catch (SQLException se) {
            System.out.println("compress table: FAIL -- unexpected exception:");
            JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)se);
        }
    }
}

