/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.clients;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Random;
import org.apache.derbyTesting.perf.clients.Client;
import org.apache.derbyTesting.perf.clients.SingleRecordFiller;

public class SingleRecordUpdateClient
implements Client {
    private Connection conn;
    private final PreparedStatement[] pss;
    private final Random r;
    private final int tableSize;
    private final int dataType;
    private final boolean secondaryIndex;
    private final boolean noIndex;

    public SingleRecordUpdateClient(int records, int tables) {
        this(records, tables, 12, false, false);
    }

    public SingleRecordUpdateClient(int records, int tables, int type, boolean secIndex, boolean nonIndexed) {
        this.tableSize = records;
        this.r = new Random();
        this.pss = new PreparedStatement[tables];
        this.dataType = type;
        if (secIndex && nonIndexed) {
            throw new IllegalArgumentException("Cannot select on both secondary index and non-index column");
        }
        this.secondaryIndex = secIndex;
        this.noIndex = nonIndexed;
    }

    public void init(Connection c) throws SQLException {
        for (int i = 0; i < this.pss.length; ++i) {
            String tableName = SingleRecordFiller.getTableName(this.tableSize, i, this.dataType, this.secondaryIndex, this.noIndex);
            String column = "ID";
            if (this.secondaryIndex) {
                column = "SEC";
            } else if (this.noIndex) {
                column = "NI";
            }
            String sql = "UPDATE " + tableName + " SET TEXT = ? WHERE " + column + " = ?";
            this.pss[i] = c.prepareStatement(sql);
        }
        c.setAutoCommit(false);
        this.conn = c;
    }

    public void doWork() throws SQLException {
        PreparedStatement ps = this.pss[this.r.nextInt(this.pss.length)];
        int seed = this.r.nextInt();
        if (this.dataType == 12) {
            ps.setString(1, SingleRecordFiller.randomString(seed));
        } else if (this.dataType == 2004) {
            byte[] bytes = SingleRecordFiller.randomBytes(seed);
            ps.setBinaryStream(1, (InputStream)new ByteArrayInputStream(bytes), 100);
        } else if (this.dataType == 2005) {
            String string = SingleRecordFiller.randomString(seed);
            ps.setCharacterStream(1, (Reader)new StringReader(string), 100);
        } else {
            throw new IllegalArgumentException();
        }
        ps.setInt(2, this.r.nextInt(this.tableSize));
        ps.executeUpdate();
        this.conn.commit();
    }
}

