/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.clients;

import java.io.PrintStream;
import java.sql.SQLException;
import java.util.Random;
import org.apache.derbyTesting.perf.clients.Client;
import org.apache.derbyTesting.perf.clients.LoadGenerator;

public class PoissonLoadGenerator
implements LoadGenerator {
    private final double avgWaitTime;
    private ClientThread[] threads;
    private volatile boolean stop;
    private volatile boolean collect;
    private long startTime;
    private long stopTime;

    public PoissonLoadGenerator(double avgWaitTime) {
        this.avgWaitTime = avgWaitTime;
    }

    public void init(Client[] clients) {
        this.threads = new ClientThread[clients.length];
        for (int i = 0; i < clients.length; ++i) {
            this.threads[i] = new ClientThread(clients[i]);
        }
    }

    public void startWarmup() {
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i].start();
        }
    }

    public void startSteadyState() {
        this.startTime = System.currentTimeMillis();
        this.collect = true;
    }

    public void stop() {
        this.stopTime = System.currentTimeMillis();
        this.collect = false;
        this.stop = true;
        for (int i = 0; i < this.threads.length; ++i) {
            try {
                this.threads[i].wakeup();
                this.threads[i].join();
                continue;
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
    }

    public void printReport(PrintStream out) {
        long time = this.stopTime - this.startTime;
        long count = 0L;
        long totalTime = 0L;
        long min = Long.MAX_VALUE;
        long max = 0L;
        for (int i = 0; i < this.threads.length; ++i) {
            count += this.threads[i].count;
            totalTime += this.threads[i].totalTime;
            min = Math.min(min, this.threads[i].min);
            max = Math.max(max, this.threads[i].max);
        }
        double tps = (double)count * 1000.0 / (double)time;
        double avgResp = (double)totalTime / (double)count;
        out.println("Number of threads:\t" + this.threads.length);
        out.println("Average injection rate (tx/s):\t" + tps);
        out.println("Average response time (ms):\t" + avgResp);
        out.println("Minimum response time (ms):\t" + min);
        out.println("Maximum response time (ms):\t" + max);
    }

    private class ClientThread
    extends Thread {
        private final Client client;
        private long count;
        private long totalTime;
        private long min = Long.MAX_VALUE;
        private long max = 0L;

        ClientThread(Client c) {
            this.client = c;
        }

        synchronized void wakeup() {
            this.notifyAll();
        }

        public void run() {
            try {
                this.runClient();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runClient() throws SQLException, InterruptedException {
            Random r = new Random();
            long start = System.currentTimeMillis();
            double timeOffset = 0.0;
            long now = start;
            while (!PoissonLoadGenerator.this.stop) {
                long nextWakeup = start + (long)(timeOffset += -Math.log(r.nextDouble()) * PoissonLoadGenerator.this.avgWaitTime);
                while (now < nextWakeup) {
                    ClientThread clientThread = this;
                    synchronized (clientThread) {
                        if (PoissonLoadGenerator.this.stop) {
                            return;
                        }
                        this.wait(nextWakeup - now);
                    }
                    now = System.currentTimeMillis();
                }
                long t0 = now;
                this.client.doWork();
                long t12 = System.currentTimeMillis();
                if (PoissonLoadGenerator.this.collect) {
                    long time = t12 - t0;
                    ++this.count;
                    this.totalTime += time;
                    if (time > this.max) {
                        this.max = time;
                    }
                    if (time < this.min) {
                        this.min = time;
                    }
                }
                now = t12;
            }
        }
    }
}

