/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.File;
import java.io.FileWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class FTFileUtil {
    public static void mkFile(String fileName, int length) throws Exception {
        FileWriter fw = new FileWriter(fileName);
        int offset = 0;
        String data = "Amber!";
        for (int ix = 0; ix < length; ++ix) {
            fw.write(data, offset, 1);
            if (++offset < data.length()) continue;
            offset = 0;
        }
        fw.close();
    }

    public static void renameFile(String location, String name, String newName) throws Exception {
        final File src = new File(location, name);
        final File dst = new File(location, newName);
        AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                if (!src.renameTo(dst)) {
                    throw new Exception("unable to rename File: " + src.getAbsolutePath() + " To: " + dst.getAbsolutePath());
                }
                return null;
            }
        });
    }

    public static String fileExists(String fileName) throws PrivilegedActionException {
        final File fl = new File(fileName);
        return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() {
                if (fl.exists()) {
                    return "true";
                }
                return "false";
            }
        });
    }

    private static boolean removeDirectory(File directory) {
        if (directory == null) {
            return false;
        }
        if (!directory.exists()) {
            return true;
        }
        if (!directory.isDirectory()) {
            return false;
        }
        String[] list = directory.list();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                File entry = new File(directory, list[i]);
                if (!(entry.isDirectory() ? !FTFileUtil.removeDirectory(entry) : !entry.delete())) continue;
                return false;
            }
        }
        return directory.delete();
    }

    public static String removeDirectory(final String directory) throws PrivilegedActionException {
        return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() {
                return FTFileUtil.removeDirectory(new File(directory)) ? "true" : "false";
            }
        });
    }
}

