/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.BufferedOutputStream;
import java.util.Vector;
import org.apache.derbyTesting.functionTests.harness.ProcessStreamResult;
import org.apache.derbyTesting.functionTests.harness.TimedProcess;

public class ExecProcUtil {
    private static String timeoutMinutes = "2";
    private static int timeoutSecondsForProcess = 180;

    public static void execCmdDumpResults(String[] args, Vector vCmd, BufferedOutputStream bos) throws Exception {
        ProcessStreamResult prout = null;
        ProcessStreamResult prerr = null;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            sb.append(args[i] + " ");
        }
        System.out.println(sb.toString());
        int totalSize = vCmd.size() + args.length;
        String[] serverCmd = new String[totalSize];
        int i = 0;
        for (i = 0; i < vCmd.size(); ++i) {
            serverCmd[i] = (String)vCmd.elementAt(i);
        }
        int j = 0;
        while (i < totalSize) {
            serverCmd[i] = args[j++];
            ++i;
        }
        System.out.flush();
        bos.flush();
        Process pr = Runtime.getRuntime().exec(serverCmd);
        TimedProcess tp = new TimedProcess(pr);
        prout = new ProcessStreamResult(pr.getInputStream(), bos, timeoutMinutes);
        prerr = new ProcessStreamResult(pr.getErrorStream(), bos, timeoutMinutes);
        boolean outTimedOut = prout.Wait();
        boolean errTimedOut = prerr.Wait();
        tp.waitFor(timeoutSecondsForProcess);
        pr = null;
        if (outTimedOut || errTimedOut) {
            System.out.println(" Reading from process streams timed out.. ");
        }
        System.out.flush();
    }
}

