/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class Changes10_4
extends UpgradeChange {
    public Changes10_4(String name) {
        super(name);
    }

    public static Test suite(int phase) {
        TestSuite suite = new TestSuite("Upgrade test for 10.4");
        suite.addTestSuite(Changes10_4.class);
        return new SupportFilesSetup((Test)suite);
    }

    public void testMetaDataQueryRunInSYScompilationSchema() throws SQLException {
        if (!this.oldAtLeast(10, 3)) {
            return;
        }
        DataSource ds = JDBCDataSource.getDataSourceLogical("COLLATED_DB_10_3");
        switch (this.getPhase()) {
            case 0: {
                JDBCDataSource.setBeanProperty(ds, "ConnectionAttributes", "create=true;territory=no;collation=TERRITORY_BASED");
                ds.getConnection().close();
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                Connection con = ds.getConnection();
                Statement s = con.createStatement();
                s.execute("SET SCHEMA APP");
                DatabaseMetaData dmd = con.getMetaData();
                ResultSet rs = dmd.getTables(null, "APP", null, null);
                JDBC.assertDrainResults(rs);
                s.close();
            }
        }
    }

    public void testTableFunctionDeclaration() throws SQLException {
        Statement s = this.createStatement();
        String createTableFunctionText = "create function svnLogReader( logFileName varchar( 32672 ) )\nreturns TABLE\n  (\n     XID varchar( 15 ),\n     committer    varchar( 20 ),\n     commit_time  timestamp,\n     line_count   varchar( 10 ),\n     description  varchar( 32672 )\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name 'org.apache.derbyDemo.vtis.example.SubversionLogVTI.subversionLogVTI'\n";
        switch (this.getPhase()) {
            case 0: {
                Changes10_4.assertStatementError("42X01", s, createTableFunctionText);
                break;
            }
            case 1: {
                Changes10_4.assertStatementError("XCL47", s, createTableFunctionText);
                break;
            }
            case 2: {
                Changes10_4.assertStatementError("42X01", s, createTableFunctionText);
                break;
            }
            case 3: {
                s.execute(createTableFunctionText);
            }
        }
        s.close();
    }

    public void testRoutineParameters() throws SQLException {
        switch (this.getPhase()) {
            case 0: {
                break;
            }
            case 1: {
                Statement s = this.createStatement();
                s.execute("CREATE FUNCTION TYPES_10_4(A INTEGER) RETURNS CHAR(10) LANGUAGE JAVA PARAMETER STYLE JAVA NO SQL EXTERNAL NAME 'java.lang.Integer.toHexString'");
            }
            case 2: 
            case 3: {
                PreparedStatement ps = this.prepareStatement("VALUES TYPES_10_4(?)");
                ps.setInt(1, 48879);
                JDBC.assertFullResultSet(ps.executeQuery(), new Object[][]{{"beef      "}}, false);
            }
        }
    }

    private void testIndexes(Statement s, String tableName, int val, boolean nulls, boolean duplicate) throws Exception {
        s.executeUpdate("delete from " + tableName);
        s.executeUpdate("insert into " + tableName + " values (" + val + ")");
        try {
            s.executeUpdate("insert into " + tableName + " values (" + val + ")");
            if (!duplicate) {
                Changes10_4.fail((String)"no duplicates allowed");
            }
        }
        catch (SQLException e) {
            if (!duplicate) {
                Changes10_4.assertSQLState("duplicate record", "23505", e);
            }
            throw e;
        }
        try {
            s.executeUpdate("insert into " + tableName + " values (null)");
            if (!nulls) {
                Changes10_4.fail((String)"null in a not null column");
            }
        }
        catch (SQLException e) {
            if (!nulls) {
                Changes10_4.assertSQLState("null in not null column", "23502", e);
            }
            throw e;
        }
        if (!nulls) {
            return;
        }
        try {
            s.executeUpdate("insert into " + tableName + " values (null)");
            if (!duplicate) {
                Changes10_4.fail((String)"no duplicates allowed");
            }
        }
        catch (SQLException e) {
            if (!duplicate) {
                Changes10_4.assertSQLState("duplicate record", "23505", e);
            }
            throw e;
        }
    }

    private void createTablesForIndexTesting(Statement s, String prefix) throws Exception {
        s.executeUpdate("create table  " + prefix + "_indextest1" + "(col1 integer not null)");
        s.executeUpdate("create unique index " + prefix + "_uinn on " + prefix + "_indextest1 (col1)");
        s.executeUpdate("create table  " + prefix + "_indextest2" + "(col1 integer)");
        s.executeUpdate("create unique index " + prefix + "_uin on " + prefix + "_indextest2 (col1)");
        s.executeUpdate("create table  " + prefix + "_indextest3" + "(col1 integer not null)");
        s.executeUpdate("create index " + prefix + "_nuinn on " + prefix + "_indextest3 (col1)");
        s.executeUpdate("create table  " + prefix + "_indextest4" + "(col1 integer)");
        s.executeUpdate("create index " + prefix + "_nuin on " + prefix + "_indextest4 (col1)");
        s.executeUpdate("create table  " + prefix + "_indextest5" + "(col1 integer not null)");
        s.executeUpdate("alter table " + prefix + "_indextest5 " + "add constraint " + prefix + "_cons1 unique(col1)");
    }

    public void testIndexes() throws Exception {
        Statement s = this.createStatement();
        switch (this.getPhase()) {
            case 0: {
                this.createTablesForIndexTesting(s, "ph_create");
                this.testIndexes(s, "ph_create_indextest1", 1, false, false);
                this.testIndexes(s, "ph_create_indextest2", 1, true, false);
                this.testIndexes(s, "ph_create_indextest3", 1, false, true);
                this.testIndexes(s, "ph_create_indextest4", 1, true, true);
                this.testIndexes(s, "ph_create_indextest5", 1, false, false);
                break;
            }
            case 1: {
                this.testIndexes(s, "ph_create_indextest1", 2, false, false);
                this.testIndexes(s, "ph_create_indextest2", 2, true, false);
                this.testIndexes(s, "ph_create_indextest3", 2, false, true);
                this.testIndexes(s, "ph_create_indextest4", 2, true, true);
                this.testIndexes(s, "ph_create_indextest5", 2, false, false);
                this.createTablesForIndexTesting(s, "ph__soft_upg");
                this.testIndexes(s, "ph__soft_upg_indextest1", 2, false, false);
                this.testIndexes(s, "ph__soft_upg_indextest2", 2, true, false);
                this.testIndexes(s, "ph__soft_upg_indextest3", 2, false, true);
                this.testIndexes(s, "ph__soft_upg_indextest4", 2, true, true);
                this.testIndexes(s, "ph__soft_upg_indextest5", 2, false, false);
                break;
            }
            case 2: {
                this.testIndexes(s, "ph_create_indextest1", 3, false, false);
                this.testIndexes(s, "ph_create_indextest2", 3, true, false);
                this.testIndexes(s, "ph_create_indextest3", 3, false, true);
                this.testIndexes(s, "ph_create_indextest4", 3, true, true);
                this.testIndexes(s, "ph_create_indextest5", 3, false, false);
                this.testIndexes(s, "ph__soft_upg_indextest1", 3, false, false);
                this.testIndexes(s, "ph__soft_upg_indextest2", 3, true, false);
                this.testIndexes(s, "ph__soft_upg_indextest3", 3, false, true);
                this.testIndexes(s, "ph__soft_upg_indextest4", 3, true, true);
                this.testIndexes(s, "ph__soft_upg_indextest5", 3, false, false);
                break;
            }
            case 3: {
                this.testIndexes(s, "ph_create_indextest1", 4, false, false);
                this.testIndexes(s, "ph_create_indextest2", 4, true, false);
                this.testIndexes(s, "ph_create_indextest3", 4, false, true);
                this.testIndexes(s, "ph_create_indextest4", 4, true, true);
                this.testIndexes(s, "ph_create_indextest5", 4, false, false);
                this.testIndexes(s, "ph__soft_upg_indextest1", 4, false, false);
                this.testIndexes(s, "ph__soft_upg_indextest2", 4, true, false);
                this.testIndexes(s, "ph__soft_upg_indextest3", 4, false, true);
                this.testIndexes(s, "ph__soft_upg_indextest4", 4, true, true);
                this.testIndexes(s, "ph__soft_upg_indextest5", 5, false, false);
                this.createTablesForIndexTesting(s, "ph_upgrade");
                this.testIndexes(s, "ph_upgrade_indextest1", 4, false, false);
                this.testIndexes(s, "ph_upgrade_indextest2", 4, true, false);
                this.testIndexes(s, "ph_upgrade_indextest3", 4, false, true);
                this.testIndexes(s, "ph_upgrade_indextest4", 4, true, true);
                this.testIndexes(s, "ph_upgrade_indextest5", 4, false, false);
            }
        }
        s.close();
    }

    public void testUniqueConstraint() throws SQLException {
        Statement s = this.createStatement();
        switch (this.getPhase()) {
            case 0: {
                s.executeUpdate("create table constraintest1 (i integer not null, j integer, k integer, constraint ucon unique (i))");
                s.executeUpdate("create table constraintest2 (i integer, j integer, k integer)");
                s.executeUpdate("create table constraintest3 (i integer not null, j integer, k integer)");
                break;
            }
            case 1: {
                Changes10_4.assertStatementError("42Z20", s, "alter table constraintest1 alter column i null");
                Changes10_4.assertStatementError("42831", s, "alter table constraintest2 add constraint ucon1 unique(i, j)");
                s.execute("alter table constraintest3 add constraint ucon2 unique(i)");
                break;
            }
            case 2: {
                s.executeUpdate("insert into constraintest3 (i) values (1)");
                Changes10_4.assertStatementError("23505", s, "insert into constraintest3 (i) values (1)");
                break;
            }
            case 3: {
                s.executeUpdate("insert into constraintest1 (i) values (2)");
                Changes10_4.assertStatementError("23505", s, "insert into constraintest1 (i) values (2)");
                s.executeUpdate("alter table constraintest1 alter column i null");
                s.executeUpdate("alter table constraintest2 add constraint ucon1 unique(i, j)");
                s.executeUpdate("insert into constraintest1 (j) values (1)");
                s.executeUpdate("insert into constraintest1 (j) values (1)");
                s.executeUpdate("insert into constraintest2 (j) values (1)");
                s.executeUpdate("insert into constraintest2 (j) values (1)");
            }
        }
        s.close();
    }

    private void verifyError() throws SQLException {
        ResultSet rs;
        Statement stmt = this.createStatement();
        PreparedStatement ps = this.prepareStatement("select text from errormessage where state = ?");
        if (this.oldAtLeast(10, 2)) {
            try {
                stmt.execute("alter table t1 alter column i null");
                Changes10_4.fail((String)"expected error while setting primary key column to nullable");
            }
            catch (SQLException e) {
                Changes10_4.assertSQLState("expected state 42Z20", "42Z20", e);
                ps.setString(1, e.getSQLState());
                rs = ps.executeQuery();
                rs.next();
                Changes10_4.assertEquals((String)"error message mismatch", (String)rs.getString(1), (String)e.getMessage());
                rs.close();
            }
        }
        try {
            stmt.execute("alter table t1 add constraint  uidx unique(j)");
            Changes10_4.fail((String)"expected error while creating unique constraint over nullable column");
        }
        catch (SQLException e) {
            Changes10_4.assertSQLState("expected state 42831", "42831", e);
            ps.setString(1, e.getSQLState());
            rs = ps.executeQuery();
            rs.next();
            Changes10_4.assertEquals((String)"error message mismatch", (String)rs.getString(1), (String)e.getMessage());
            rs.close();
        }
        stmt.close();
        ps.close();
    }

    private void prepareTable() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create table errormessage (state varchar (6), text varchar (200))");
        PreparedStatement ps = this.prepareStatement("insert into errormessage (state, text) values (?, ?)");
        stmt.executeUpdate("create table t1 (i integer not null primary key, j integer)");
        if (this.oldAtLeast(10, 2)) {
            try {
                stmt.execute("alter table t1 alter column i null");
                Changes10_4.fail((String)"expected error while setting primary key column to nullable");
            }
            catch (SQLException e) {
                Changes10_4.assertSQLState("expected state 42Z20", "42Z20", e);
                ps.setString(1, e.getSQLState());
                ps.setString(2, e.getMessage());
                ps.executeUpdate();
            }
        }
        try {
            stmt.execute("alter table t1 add constraint  uidx unique(j)");
            Changes10_4.fail((String)"expected error while creating unique constraint over nullable column");
        }
        catch (SQLException e) {
            Changes10_4.assertSQLState("expected state 42831", "42831", e);
            ps.setString(1, e.getSQLState());
            ps.setString(2, e.getMessage());
            ps.executeUpdate();
        }
        stmt.close();
        ps.close();
    }

    public void testErrorMessage() throws Exception {
        switch (this.getPhase()) {
            case 0: {
                this.prepareTable();
                break;
            }
            case 1: {
                this.verifyError();
            }
        }
    }

    public void testAlterColumnOfUniqueConstraint() throws Exception {
        Statement stmt = this.createStatement();
        switch (this.getPhase()) {
            case 0: {
                stmt.executeUpdate("create table datatype_test (fl1 varchar (2) not null)");
                stmt.executeUpdate("alter table datatype_test add constraint ucon_datatype_test unique (fl1)");
                stmt.executeUpdate("alter table datatype_test alter column fl1 set data type varchar (3)");
                break;
            }
            case 1: {
                stmt.executeUpdate("alter table datatype_test alter column fl1  set data type varchar (4)");
                break;
            }
            case 3: {
                stmt.executeUpdate("alter table datatype_test alter column fl1  set data type varchar (5)");
            }
        }
        stmt.close();
    }
}

