/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.tools.dblook;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class dblook_test {
    private static final int SERVER_PORT = 1527;
    private static final int FRONT = -1;
    private static final int REAR = 1;
    protected static final String dbCreationScript_1 = "dblook_makeDB.sql";
    protected static final String dbCreationScript_2 = "dblook_makeDB_2.sql";
    private static final char TEST_DELIMITER = '#';
    protected static String testDirectory = "dblook_test";
    protected static String testDBName = "wombat";
    protected static String separator;
    private static String dbPath;
    private static int duplicateCounter;
    private static int sysNameCount;
    private static String jdbcProtocol;
    protected static String territoryBased;
    protected static String expectedCollation;
    private static final String[] ignorableSchemaNames;

    public static void main(String[] args) {
        separator = System.getProperty("file.separator");
        new dblook_test().doTest();
        System.out.println("\n[ Done. ]\n");
        dblook_test.renameDbLookLog("dblook_test");
    }

    protected void doTest() {
        try {
            System.out.println("\n-= Start dblook Functional Tests. =-");
            this.createTestDatabase(dbCreationScript_1);
            this.runDBLook(testDBName);
            System.out.println("\n-= Start dblook Message Tests =-");
            this.createTestDatabase(dbCreationScript_2);
            this.runMessageCheckTest(testDBName);
        }
        catch (SQLException se) {
            System.out.println("FAILED: to complete the test:");
            se.printStackTrace(System.out);
            for (se = se.getNextException(); se != null; se = se.getNextException()) {
                se.printStackTrace(System.out);
            }
        }
        catch (Exception e) {
            System.out.println("FAILED: to complete the test:");
            e.printStackTrace(System.out);
        }
    }

    protected void createTestDatabase(String scriptName) throws Exception {
        try {
            this.deleteDB(testDBName);
        }
        catch (Exception e) {
            System.out.println("** Warning: failed to delete old test db before creating a new one...");
        }
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        jdbcProtocol = "jdbc:derby:";
        this.createDBFromDDL(testDBName, scriptName);
        String systemhome = System.getProperty("derby.system.home");
        dbPath = systemhome + File.separatorChar;
    }

    private void runDBLook(String dbName) throws Exception {
        System.err.close();
        this.dumpSysCatalogs(dbName);
        this.lookOne(dbName);
        this.dumpFileToSysOut("dblook.log");
        String newDBName = dbName + "_new";
        this.createDBFromDDL(newDBName, dbName + ".sql");
        this.deleteFile(new File(dbName + ".sql"));
        this.dumpSysCatalogs(newDBName);
        this.deleteDB(newDBName);
        this.deleteFile(new File(newDBName + ".sql"));
        this.runAllTests(dbName, newDBName);
    }

    protected void runAllTests(String dbName, String newDBName) throws Exception {
        this.runTest(2, dbName, newDBName);
        this.runTest(4, dbName, newDBName);
        this.runTest(5, dbName, newDBName);
        this.runTest(7, dbName, newDBName);
        this.runTest(6, dbName, newDBName);
    }

    protected void runTest(int whichTest, String dbName, String newDBName) {
        try {
            switch (whichTest) {
                case 2: {
                    this.lookTwo(dbName);
                    break;
                }
                case 3: {
                    this.lookThree(dbName);
                    break;
                }
                case 4: {
                    this.lookFour(dbName);
                    break;
                }
                case 5: {
                    this.lookFive(dbName);
                    break;
                }
                case 6: {
                    this.lookSix(dbName);
                    break;
                }
                case 7: {
                    this.lookSeven(dbName);
                    break;
                }
            }
            this.dumpFileToSysOut("dblook.log");
            this.createDBFromDDL(newDBName, dbName + ".sql");
            this.dumpSysCatalogs(newDBName);
            this.deleteDB(newDBName);
            this.deleteFile(new File(dbName + ".sql"));
        }
        catch (SQLException e) {
            System.out.println("FAILED: Test # : " + whichTest);
            e.printStackTrace(System.out);
            for (e = e.getNextException(); e != null; e = e.getNextException()) {
                e.printStackTrace(System.out);
            }
        }
        catch (Exception e) {
            System.out.println("FAILED: Test # : " + whichTest);
            e.printStackTrace(System.out);
        }
    }

    private void lookOne(String dbName) throws Exception {
        this.printAsHeader("\nDumping full schema for '" + dbName + "'\nto file '" + dbName + ".sql':\n");
        String[] args = new String[]{"-o", dbName + ".sql", "-td", ""};
        this.go(dbName, args);
    }

    private void lookTwo(String dbName) throws Exception {
        this.printAsHeader("\nDumping DDL for all objects with schema\n'BAR', excluding views:\n");
        String[] args = new String[]{"-o", dbName + ".sql", "-td", "", "-z", "bar", "-noview"};
        this.go(dbName, args);
    }

    private void lookThree(String dbName) throws Exception {
        this.printAsHeader("\nDumping DDL for all objects, using\nNetwork Server:\n");
        String hostName = TestUtil.getHostName();
        jdbcProtocol = TestUtil.getJdbcUrlPrefix(hostName, 1527);
        String sourceDBUrl = TestUtil.isJCCFramework() ? jdbcProtocol + "\"" + dbPath + separator + dbName + "\":user=app;password=apppw;" : jdbcProtocol + dbPath + separator + dbName + ";user=app;password=apppw";
        try {
            DriverManager.getConnection("jdbc:derby:" + dbName + ";shutdown=true;user=app;password=apppw");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            new dblook(new String[]{"-d", sourceDBUrl, "-o", dbName + ".sql", "-td", ""});
        }
        catch (Exception e) {
            System.out.println("FAILED: ");
            e.printStackTrace(System.out);
        }
    }

    private void lookFour(String dbName) throws Exception {
        this.printAsHeader("\nDumping DDL for all objects with schema 'BAR'\nthat are related to tables 'T3', 'tWithKeys',\nand 'MULTI WORD NAME':\n");
        String[] args = new String[]{"-o", dbName + ".sql", "-td", "", "-z", "BAR", "-t", "t3", "\"tWithKeys\"", "Multi word name"};
        this.go(dbName, args);
    }

    private void lookFive(String dbName) throws Exception {
        this.printAsHeader("\nDumping DDL for all objects related to 'T1'\nand 'TWITHKEYS':\n");
        String[] args = new String[]{"-o", dbName + ".sql", "-td", "", "-t", "t1", "tWithKeys"};
        this.go(dbName, args);
    }

    private void lookSix(String dbName) throws Exception {
        this.printAsHeader("\nDumping DDL w/ invalid url, and writing\nerror to the log:\n");
        new dblook(new String[]{"-o", dbName + ".sql", "-d", dbName});
    }

    private void lookSeven(String dbName) throws Exception {
        this.printAsHeader("\nDumping DDL for all objects with schema\n'\"Quoted\"Schema\"':\n");
        String[] args = new String[]{"-o", dbName + ".sql", "-td", "", "-z", "\"\"Quoted\"Schema\"\""};
        this.go(dbName, args);
    }

    private void go(String dbName, String[] args) {
        jdbcProtocol = "jdbc:derby:";
        String sourceDBUrl = jdbcProtocol + dbPath + separator + dbName + ";user=app;password=apppw";
        String[] fullArgs = new String[args.length + 2];
        fullArgs[0] = "-d";
        fullArgs[1] = sourceDBUrl;
        for (int i = 2; i < fullArgs.length; ++i) {
            fullArgs[i] = args[i - 2];
        }
        try {
            new dblook(fullArgs);
        }
        catch (Exception e) {
            System.out.println("FAILED: to run dblook: ");
            e.printStackTrace(System.out);
        }
    }

    private void runMessageCheckTest(String dbName) throws Exception {
        System.out.println("\n************\nMsg Test 1\n************\n");
        this.lookOne(dbName);
        this.dumpFileToSysOut(dbName + ".sql");
        this.dumpFileToSysOut("dblook.log");
        System.out.println("\n************\nMsg Test 2\n************\n");
        this.go(dbName, new String[]{"-t", "t1", "-z", "bar", "-o", dbName + ".sql"});
        this.dumpFileToSysOut(dbName + ".sql");
        this.dumpFileToSysOut("dblook.log");
        System.out.println("\n************\nMsg Test 3\n************\n");
        try {
            new dblook(new String[]{"-verbose"});
        }
        catch (Exception e) {
            System.out.println("FAILED: to run dblook: ");
            e.printStackTrace(System.out);
        }
        System.out.println("\n************\nMsg Test 4\n************\n");
        this.go(dbName, new String[]{"-td", " #"});
        System.out.println("\n************\nMsg Test 5\n************\n");
        String jarPath = new File(dbPath + separator + dbName).getAbsolutePath();
        try {
            Connection conn = DriverManager.getConnection("jdbc:derby:" + jarPath + ";shutdown=true,user=app;password=apppw");
            conn.close();
        }
        catch (SQLException se) {
            // empty catch block
        }
        jarPath = jarPath + separator + "jar";
        this.deleteFile(new File(jarPath));
        this.go(dbName, new String[]{"-verbose", "-o", dbName + ".sql"});
        this.dumpFileToSysOut("dblook.log");
        try {
            this.deleteFile(new File(dbName + ".sql"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpSysCatalogs(String dbName) throws Exception {
        System.out.println("\nDumping system tables for '" + dbName + "'\n");
        dblook_test.writeOut("\n----------------=================---------------");
        dblook_test.writeOut("System Tables for: " + dbName);
        dblook_test.writeOut("----------------=================---------------\n");
        Connection conn = DriverManager.getConnection("jdbc:derby:" + dbName + ";user=app;password=apppw");
        conn.setAutoCommit(false);
        Statement stmt = conn.createStatement();
        stmt.executeUpdate("SET SCHEMA SYS");
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery("VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.database.collation')");
            rs.next();
            String collation = rs.getString(1);
            if (collation == null || !collation.equals(expectedCollation)) {
                throw new SQLException("Collation doesn't match with the expected type " + expectedCollation);
            }
        }
        catch (Exception e) {
            System.out.println("FAILED: incorrect database collation\n");
            System.out.println(e.getMessage());
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        HashMap idToNameMap = this.loadIdMappings(stmt, conn);
        dblook_test.writeOut("\n========== SYSALIASES ==========\n");
        rs = stmt.executeQuery("select schemaid, sys.sysaliases.* from sys.sysaliases");
        this.dumpResultSet(rs, idToNameMap, null);
        dblook_test.writeOut("\n========== SYSCHECKS ==========\n");
        rs = stmt.executeQuery("select c.schemaid, ck.* from sys.syschecks ck, sys.sysconstraints c where ck.constraintid = c.constraintid");
        this.dumpResultSet(rs, idToNameMap, null);
        dblook_test.writeOut("\n========== SYSCOLUMNS ==========\n");
        dblook_test.writeOut("--- Columns for Tables ---");
        rs = stmt.executeQuery("select t.schemaid, c.* from sys.syscolumns c, sys.systables t where c.referenceid = t.tableid");
        this.dumpResultSet(rs, idToNameMap, null);
        dblook_test.writeOut("\n--- Columns for Statements ---");
        rs = stmt.executeQuery("select s.schemaid, c.* from sys.syscolumns c, sys.sysstatements s where c.referenceid = s.stmtid");
        this.dumpResultSet(rs, idToNameMap, null);
        dblook_test.writeOut("\n========== SYSCONGLOMERATES ==========\n");
        rs = stmt.executeQuery("select schemaid, sys.sysconglomerates.* from sys.sysconglomerates");
        this.dumpResultSet(rs, idToNameMap, null);
        dblook_test.writeOut("\n========== SYSCONSTRAINTS ==========\n");
        rs = stmt.executeQuery("select schemaid, sys.sysconstraints.* from sys.sysconstraints");
        this.dumpResultSet(rs, idToNameMap, null);
        dblook_test.writeOut("\n========== SYSDEPENDS ==========\n");
        rs = stmt.executeQuery("select dependentid, sys.sysdepends.* from sys.sysdepends");
        this.dumpResultSet(rs, idToNameMap, conn);
        dblook_test.writeOut("\n========== SYSFILES ==========\n");
        rs = stmt.executeQuery("select schemaid, sys.sysfiles.* from sys.sysfiles");
        this.dumpResultSet(rs, idToNameMap, null);
        dblook_test.writeOut("\n========== SYSFOREIGNKEYS ==========\n");
        rs = stmt.executeQuery("select c.schemaid, fk.* from sys.sysforeignkeys fk, sys.sysconstraints c where fk.constraintid = c.constraintid");
        this.dumpResultSet(rs, idToNameMap, null);
        dblook_test.writeOut("\n========== SYSKEYS ==========\n");
        rs = stmt.executeQuery("select c.schemaid, k.* from sys.syskeys k, sys.sysconstraints c where k.constraintid = c.constraintid");
        this.dumpResultSet(rs, idToNameMap, null);
        dblook_test.writeOut("\n========== SYSSCHEMAS ==========\n");
        rs = stmt.executeQuery("select schemaid, sys.sysschemas.* from sys.sysschemas");
        this.dumpResultSet(rs, idToNameMap, null);
        dblook_test.writeOut("\n========== SYSSTATEMENTS ==========\n");
        rs = stmt.executeQuery("select schemaid, sys.sysstatements.* from sys.sysstatements");
        this.dumpResultSet(rs, idToNameMap, null);
        dblook_test.writeOut("\n========== SYSTABLES ==========\n");
        rs = stmt.executeQuery("select schemaid, sys.systables.* from sys.systables");
        this.dumpResultSet(rs, idToNameMap, null);
        dblook_test.writeOut("\n========== SYSTRIGGERS ==========\n");
        rs = stmt.executeQuery("select schemaid, sys.systriggers.* from sys.systriggers");
        this.dumpResultSet(rs, idToNameMap, null);
        dblook_test.writeOut("\n========== SYSVIEWS ==========\n");
        rs = stmt.executeQuery("select compilationschemaid, sys.sysviews.* from sys.sysviews");
        this.dumpResultSet(rs, idToNameMap, null);
        dblook_test.writeOut("\n========== SYSROLES ==========\n");
        rs = stmt.executeQuery("select 'dummyFirstCol', roleid || '_' || grantee || '_' || grantor as rgd, roleid, grantee, grantor, withadminoption, isdef from sys.sysroles");
        this.dumpResultSet(rs, idToNameMap, null);
        stmt.close();
        rs.close();
        conn.commit();
        conn.close();
    }

    private boolean isIgnorableSchema(String schemaName) {
        boolean ret = false;
        int i = ignorableSchemaNames.length - 1;
        while (i >= 0 && !(ret = ignorableSchemaNames[i--].equalsIgnoreCase(schemaName))) {
        }
        return ret;
    }

    private void dumpResultSet(ResultSet rs, HashMap idToNameMap, Connection conn) throws Exception {
        StringBuffer uniqueName = new StringBuffer();
        TreeMap orderedRows = new TreeMap();
        ArrayList<String> rowValues = new ArrayList<String>();
        ArrayList<String> duplicateRowIds = new ArrayList<String>();
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        while (rs.next()) {
            for (int i = 1; i <= cols; ++i) {
                String colName = rsmd.getColumnName(i);
                String value = rs.getString(i);
                String mappedName = (String)idToNameMap.get(value);
                if (colName.indexOf("SCHEMAID") != -1 && mappedName != null && (mappedName.indexOf("SYS") != -1 || this.isIgnorableSchema(mappedName))) {
                    rowValues = null;
                    break;
                }
                if (colName.equals("JAVACLASSNAME") && value != null && value.indexOf("org.apache.derby") != -1 && value.indexOf(".util.") == -1) {
                    rowValues = null;
                    break;
                }
                if (i == 1) continue;
                String uniquePiece = colName.equals("RGD") ? value : this.dumpColumnData(colName, value, mappedName, rowValues);
                if (colName.equals("DEPENDENTID")) {
                    String hiddenInfo = this.getDependsData(rs, conn, idToNameMap);
                    if (hiddenInfo.indexOf("SYS_OBJECT") != -1) {
                        rowValues = null;
                        break;
                    }
                    uniqueName.append(hiddenInfo);
                    rowValues.add(hiddenInfo);
                }
                if (uniquePiece != null) {
                    uniqueName.append(uniquePiece);
                }
                if (!colName.equals("STMTNAME") || value.indexOf("TRIGGERACTN") == -1) continue;
                uniqueName.append(rs.getString(6));
            }
            if (rowValues != null) {
                if (duplicateRowIds.contains(uniqueName.toString())) {
                    this.handleDuplicateRow(rowValues, null, orderedRows);
                } else {
                    ArrayList oldRow = orderedRows.put(uniqueName.toString(), rowValues);
                    if (oldRow != null) {
                        duplicateRowIds.add(uniqueName.toString());
                        orderedRows.remove(uniqueName.toString());
                        this.handleDuplicateRow(rowValues, oldRow, orderedRows);
                    }
                }
            }
            uniqueName = new StringBuffer();
            rowValues = new ArrayList();
        }
        Set objectNames = orderedRows.keySet();
        Iterator itr = objectNames.iterator();
        while (itr.hasNext()) {
            String row = (String)itr.next();
            ArrayList colData = (ArrayList)orderedRows.get(row);
            for (int i = 0; i < colData.size(); ++i) {
                dblook_test.writeOut((String)colData.get(i));
            }
            dblook_test.writeOut("----");
        }
        orderedRows = null;
        rs.close();
    }

    /*
     * Enabled aggressive block sorting
     */
    private String dumpColumnData(String colName, String value, String mappedName, ArrayList rowVals) {
        if (mappedName == null) {
            if (colName.equals("CONGLOMERATENUMBER") || colName.equals("GENERATIONID")) {
                rowVals.add("<systemnumber>");
                return null;
            }
            if (colName.equals("AUTOINCREMENTVALUE")) {
                rowVals.add("<autoincval>");
                return null;
            }
            if (colName.equals("VALID")) {
                rowVals.add("<validityflag>");
                return null;
            }
            if (value == null) {
                rowVals.add(value);
                return null;
            }
            if (this.looksLikeSysGenName(value)) {
                if (this.columnHoldsObjectName(colName)) {
                    rowVals.add("<systemname>");
                    return null;
                }
                rowVals.add(value);
                return value;
            }
            if (this.looksLikeSysGenId(value)) {
                rowVals.add("<systemid>");
                return null;
            }
            rowVals.add(value);
            if (!this.columnHoldsObjectName(colName)) return null;
            return value;
        }
        if (!this.isSystemGenerated(mappedName)) {
            rowVals.add(mappedName);
            return mappedName;
        }
        rowVals.add("<systemname>");
        return null;
    }

    private void handleDuplicateRow(ArrayList newRow, ArrayList oldRow, TreeMap orderedRows) {
        StringBuffer newRowId = new StringBuffer();
        for (int i = 0; i < newRow.size(); ++i) {
            newRowId.append((String)newRow.get(i));
        }
        ArrayList obj = orderedRows.put(newRowId.toString(), newRow);
        if (obj != null) {
            orderedRows.put(newRowId.toString() + duplicateCounter++, newRow);
        }
        if (oldRow != null) {
            StringBuffer oldRowId = new StringBuffer();
            for (int i = 0; i < oldRow.size(); ++i) {
                oldRowId.append((String)oldRow.get(i));
            }
            obj = orderedRows.put(oldRowId.toString(), oldRow);
            if (obj != null) {
                orderedRows.put(oldRowId.toString() + duplicateCounter++, oldRow);
            }
        }
    }

    private void createDBFromDDL(String newDBName, String scriptName) throws Exception {
        System.out.println("\n\nCreating database '" + newDBName + "' from ddl script '" + scriptName + "'");
        Connection conn = DriverManager.getConnection("jdbc:derby:" + newDBName + ";create=true;user=app;password=apppw" + territoryBased);
        Statement stmt = conn.createStatement();
        BufferedReader ddlScript = new BufferedReader(new FileReader(scriptName));
        String sqlCmd = ddlScript.readLine();
        while (sqlCmd != null) {
            if (sqlCmd.indexOf("--") != 0 && sqlCmd.trim().length() != 0) {
                if (sqlCmd.charAt(sqlCmd.length() - 1) == '#' || sqlCmd.charAt(sqlCmd.length() - 1) == ';') {
                    sqlCmd = sqlCmd.substring(0, sqlCmd.length() - 1);
                }
                try {
                    stmt.execute(sqlCmd);
                }
                catch (Exception e) {
                    System.out.println("FAILED: to execute cmd from DDL script:\n" + sqlCmd + "\n");
                    System.out.println(e.getMessage());
                }
            }
            sqlCmd = ddlScript.readLine();
        }
        ddlScript.close();
        stmt.close();
        conn.close();
    }

    private static void writeOut(String str) {
        System.out.println(str);
    }

    private HashMap loadIdMappings(Statement stmt, Connection conn) throws Exception {
        HashMap<String, String> idToNameMap = new HashMap<String, String>();
        ResultSet rs = stmt.executeQuery("select tableid, tablename from sys.systables");
        while (rs.next()) {
            idToNameMap.put(rs.getString(1), rs.getString(2));
        }
        rs = stmt.executeQuery("select schemaid, schemaname from sys.sysschemas");
        while (rs.next()) {
            idToNameMap.put(rs.getString(1), rs.getString(2));
        }
        rs = stmt.executeQuery("select constraintid, constraintname from sys.sysconstraints");
        while (rs.next()) {
            idToNameMap.put(rs.getString(1), rs.getString(2));
        }
        return idToNameMap;
    }

    private String getDependsData(ResultSet rs, Connection conn, HashMap idToNameMap) throws Exception {
        DependableFinder dep = (DependableFinder)rs.getObject(3);
        DependableFinder prov = (DependableFinder)rs.getObject(5);
        String depType = dep.getSQLObjectType();
        String provType = prov.getSQLObjectType();
        Statement dependsStmt = conn.createStatement();
        StringBuffer dependsData = new StringBuffer();
        dependsData.append(this.getHiddenDependsData(depType, rs.getString(2), dependsStmt, idToNameMap));
        dependsData.append(" -> ");
        dependsData.append(this.getHiddenDependsData(provType, rs.getString(4), dependsStmt, idToNameMap));
        return dependsData.toString();
    }

    private String getHiddenDependsData(String type, String id, Statement pStmt, HashMap idToNameMap) throws Exception {
        ResultSet rs = null;
        if (type.equals("Constraint")) {
            rs = pStmt.executeQuery("select schemaid, constraintname from sys.sysconstraints where constraintid = '" + id + "'");
        } else if (type.equals("StoredPreparedStatement")) {
            rs = pStmt.executeQuery("select schemaid, stmtname from sys.sysstatements where stmtid = '" + id + "'");
        } else if (type.equals("Trigger")) {
            rs = pStmt.executeQuery("select schemaid, triggername from sys.systriggers where triggerid = '" + id + "'");
        } else if (type.equals("View") || type.equals("Table") || type.equals("ColumnsInTable")) {
            rs = pStmt.executeQuery("select schemaid, tablename from sys.systables where tableid = '" + id + "'");
        } else if (type.equals("Conglomerate")) {
            rs = pStmt.executeQuery("select schemaid, conglomeratename from sys.sysconglomerates where conglomerateid = '" + id + "'");
        } else {
            System.out.println("WARNING: Unexpected dependent type: " + type);
            return "";
        }
        if (rs.next()) {
            String schema = (String)idToNameMap.get(rs.getString(1));
            if (this.isIgnorableSchema(schema)) {
                return "SYS_OBJECT";
            }
            StringBuffer result = new StringBuffer();
            result.append("<");
            result.append(type);
            result.append(">");
            result.append(schema);
            result.append(".");
            if (this.isSystemGenerated(rs.getString(2))) {
                result.append("<sysname>");
            } else {
                result.append(rs.getString(2));
            }
            return result.toString();
        }
        return "";
    }

    private void deleteDB(String dbName) throws Exception {
        String deletePath = new File(dbPath + separator + dbName).getAbsolutePath();
        try {
            Connection conn = DriverManager.getConnection("jdbc:derby:" + deletePath + ";shutdown=true;user=app;password=apppw");
            conn.close();
        }
        catch (SQLException se) {
            // empty catch block
        }
        File f = new File(deletePath);
        if (!f.exists()) {
            return;
        }
        File[] files = f.listFiles();
        for (int i = 0; i < files.length; ++i) {
            this.deleteFile(files[i]);
        }
        if (!f.delete()) {
            System.out.println("ERROR: deleting: " + f.getName());
        }
        this.deleteFile(new File(System.getProperty("user.dir") + separator + "CSJARS"));
        System.out.println("Database '" + dbName + "' deleted.");
    }

    private void deleteFile(File aFile) throws Exception {
        if (!aFile.exists()) {
            return;
        }
        if (aFile.delete()) {
            return;
        }
        File[] files = aFile.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                this.deleteFile(files[i]);
            }
        }
        if (!aFile.delete()) {
            System.out.println("ERROR: deleting: " + aFile.getName());
        }
    }

    protected static void renameDbLookLog(String nameOfTest) {
        File dbLookTestLog = new File("dblook.log");
        if (dbLookTestLog.exists()) {
            int i = 0;
            String renamedLogName = nameOfTest + i + ".log";
            File renamedLog = new File(renamedLogName);
            while (renamedLog.exists()) {
                renamedLogName = nameOfTest + ++i + ".log";
                renamedLog = new File(renamedLogName);
            }
            if (!dbLookTestLog.renameTo(renamedLog)) {
                System.out.println("Failed to rename dblook.org to " + renamedLogName);
            }
        }
    }

    private void dumpFileToSysOut(String fName) {
        try {
            BufferedReader dumpFile = new BufferedReader(new FileReader(fName));
            String line = dumpFile.readLine();
            if (line != null) {
                System.out.println("File " + fName + " was NOT " + "empty.  Contents are:\n" + "############## Begin File Contents ################\n");
                do {
                    System.out.println(line);
                } while ((line = dumpFile.readLine()) != null);
                System.out.println("############## End File Contents ################");
            } else {
                System.out.println("File " + fName + " was empty.");
            }
            dumpFile.close();
        }
        catch (Exception e) {
            System.out.println("FAILED: to dump file '" + fName + "'");
            e.printStackTrace(System.out);
        }
    }

    private boolean isSystemGenerated(String str) {
        return this.looksLikeSysGenName(str) || this.looksLikeSysGenId(str);
    }

    private boolean looksLikeSysGenName(String val) {
        return val != null && (val.trim().indexOf("SQL") == 0 || val.trim().indexOf("TRIGGERACTN_") == 0 && val.indexOf("-") != -1);
    }

    private boolean looksLikeSysGenId(String val) {
        return val != null && val.indexOf("-") != -1;
    }

    private boolean columnHoldsObjectName(String colName) {
        return colName.equals("ALIAS") || colName.indexOf("NAME") != -1;
    }

    private void printAsHeader(String str) {
        dblook_test.writeOut("--\n*******************************************");
        dblook_test.writeOut(str);
        dblook_test.writeOut("*******************************************\n");
    }

    static {
        duplicateCounter = 0;
        sysNameCount = 0;
        territoryBased = "";
        expectedCollation = "UCS_BASIC";
        ignorableSchemaNames = new String[]{"SYSIBM", "SYS", "SYSVISUAL", "SYSCAT", "SYSFUN", "SYSPROC", "SYSSTAT", "NULLID", "SYSCS_ADMIN", "SYSCS_DIAG", "SYSCS_UTIL", "SQLJ"};
    }
}

