/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ImportExportTest
extends BaseJDBCTestCase {
    public ImportExportTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ImportExportTest");
        if (JDBC.vmSupportsJSR169()) {
            return new TestSuite();
        }
        suite.addTest(ImportExportTest.baseSuite("ImportExportTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(ImportExportTest.baseSuite("ImportExportTest:client")));
        return suite;
    }

    public static Test baseSuite(String name) {
        TestSuite suite = new TestSuite(ImportExportTest.class, name);
        SupportFilesSetup test = new SupportFilesSetup((Test)suite, new String[]{"functionTests/testData/ImportExport/TwoLineBadEOF.dat"});
        return new CleanDatabaseTestSetup((Test)test){

            protected void decorateSQL(Statement s) throws SQLException {
                s.execute("CREATE TABLE T1 (COLUMN1 VARCHAR(5) , COLUMN2 VARCHAR(8) , COLUMN3 SMALLINT , COLUMN4 CHAR(11) , COLUMN5 DATE , COLUMN6 DECIMAL(5,1) , COLUMN7 DOUBLE PRECISION , COLUMN8 INT , COLUMN9 BIGINT , COLUMN10 NUMERIC , COLUMN11 REAL , COLUMN12 SMALLINT , COLUMN13 TIME , COLUMN14 TIMESTAMP , COLUMN15 SMALLINT , COLUMN16 VARCHAR(1))");
                s.execute("CREATE TABLE T2 (COLUMN1 VARCHAR(5) , COLUMN2 VARCHAR(8) , COLUMN3 SMALLINT, COLUMN4 CHAR(11) , COLUMN5 DATE , COLUMN6 DECIMAL(5,1) , COLUMN7 DOUBLE PRECISION , COLUMN8 INT , COLUMN9 BIGINT , COLUMN10 NUMERIC , COLUMN11 REAL , COLUMN12 SMALLINT , COLUMN13 TIME , COLUMN14 TIMESTAMP , COLUMN15 SMALLINT , COLUMN16 VARCHAR(1))");
                s.execute("create table T4 (   Account int,    Name   char(30), Jobdesc char(40), Company varchar(35), Address1 varchar(40), Address2 varchar(40), City    varchar(20), State   char(5), Zip char(10), Country char(10), Phone1  char(20), Phone2  char(20), email   char(30), web     char(30), Fname   char(30), Lname   char(30), Comment char(30), AccDate char(30), Payment decimal(8,2), Balance decimal(8,2))");
            }
        };
    }

    public void testImportFromNonExistantFile() {
        try {
            this.doImport("Z", null, "T1", null, null, null, 0);
            ImportExportTest.fail();
        }
        catch (SQLException e) {
            ImportExportTest.assertSQLState("XIE04", e);
        }
    }

    public void testNullDataFile() {
        try {
            this.doImport(null, null, "T1", null, null, null, 0);
            ImportExportTest.fail();
        }
        catch (SQLException e) {
            ImportExportTest.assertSQLState("XIE05", e);
        }
    }

    public void testEmptyTable() throws SQLException {
        this.doImportAndExport(null, "T1", null, null, null);
    }

    public void testEmptyTableWithDelimitedFormat() throws SQLException {
        this.doImportAndExport(null, "T1", null, null, "8859_1");
    }

    public void testEmptyTableWithFieldCharDelimiters() throws SQLException {
        this.doImportAndExport(null, "T1", "\t", "|", "8859_1");
    }

    public void testWithDefaultOptions() throws Exception {
        this.resetTables();
        this.doImportAndExport(null, "T1", null, null, null);
    }

    public void testWithCodeset() throws Exception {
        this.resetTables();
        this.doImportAndExport(null, "T1", null, null, "8859_1");
    }

    public void testDelimiterAndCodeset() throws Exception {
        this.resetTables();
        this.doImportAndExport(null, "T1", "\t", "|", "8859_1");
    }

    public void testSpecialDelimitersAndCodeset() throws Exception {
        this.resetTables();
        this.doImportAndExport(null, "T1", "%", "&", "Cp1252");
    }

    public void testSpecialDelimitersAndUTF16() throws Exception {
        this.resetTables();
        this.doImportAndExport(null, "T1", "%", "&", "UTF-16");
    }

    public void testInvalidEncoding() throws Exception {
        this.resetTables();
        try {
            this.doImportAndExport(null, "T1", "^", "#", "INAVALID ENCODING");
            ImportExportTest.fail();
        }
        catch (SQLException e) {
            ImportExportTest.assertSQLState("XIE0I", e);
        }
    }

    public void testEarlyEndOfFile() throws Exception {
        try {
            this.doImportFromFile("extin/TwoLineBadEOF.dat", null, "T4", null, null, "US-ASCII", 0);
            ImportExportTest.fail();
        }
        catch (SQLException e) {
            ImportExportTest.assertSQLState("XIE0E", e);
        }
    }

    public void testImportWithSameNameInDifferentSchema() throws Exception {
        this.resetTables();
        this.doExport(null, "T1", null, null, null);
        Statement s = this.createStatement();
        s.executeUpdate("create table otherschema.t2(x int)");
        this.doImport("T1", null, "T2", null, null, null, 0);
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from app.t2"), "4");
        this.setAutoCommit(false);
        JDBC.dropSchema(this.getConnection().getMetaData(), "OTHERSCHEMA");
    }

    public void testQuotesInArguments() throws Exception {
        this.resetTables();
        String schema = "s'\"";
        String table = "t'\"";
        String escapedName = JDBC.escape("s'\"", "t'\"");
        Statement s = this.createStatement();
        s.execute("create table " + escapedName + " as select * from T1 with no data");
        s.execute("insert into " + escapedName + " select * from t1");
        String colDel = "'";
        String charDel = "\"";
        String encoding = "US-ASCII";
        String fileName = SupportFilesSetup.getReadWrite("please don't fail.dat").getPath();
        this.doExportToFile(fileName, "s'\"", "t'\"", "'", "\"", "US-ASCII");
        int rowsInTable = s.executeUpdate("delete from " + escapedName);
        this.doImportFromFile(fileName, "s'\"", "t'\"", "'", "\"", "US-ASCII", 0);
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from " + escapedName), Integer.toString(rowsInTable));
        JDBC.assertEmpty(s.executeQuery("select * from " + escapedName + " except all select * from T1"));
    }

    private void doImport(String fromTable, String toSchema, String toTable, String colDel, String charDel, String codeset, int replace) throws SQLException {
        String fileName = fromTable == null ? null : SupportFilesSetup.getReadWrite(fromTable + ".dat").getPath();
        this.doImportFromFile(fileName, toSchema, toTable, colDel, charDel, codeset, replace);
    }

    private void doImportFromFile(String fileName, String toSchema, String toTable, String colDel, String charDel, String codeset, int replace) throws SQLException {
        String impsql = "call SYSCS_UTIL.SYSCS_IMPORT_TABLE (? , ? , ? , ?, ? , ?, ?)";
        PreparedStatement ps = this.prepareStatement(impsql);
        ps.setString(1, toSchema);
        ps.setString(2, toTable);
        ps.setString(3, fileName);
        ps.setString(4, colDel);
        ps.setString(5, charDel);
        ps.setString(6, codeset);
        ps.setInt(7, replace);
        ps.execute();
        ps.close();
    }

    private void doImportAndExport(String fromSchema, String fromTable, String colDel, String charDel, String codeset) throws SQLException {
        this.doExport(fromSchema, fromTable, colDel, charDel, codeset);
        this.doImportAndVerify(fromSchema, fromTable, colDel, charDel, codeset, 0);
        this.doImportAndVerify(fromSchema, fromTable, colDel, charDel, codeset, 1);
    }

    private void doExport(String fromSchema, String fromTable, String colDel, String charDel, String codeset) throws SQLException {
        String fileName = fromTable == null ? null : SupportFilesSetup.getReadWrite(fromTable + ".dat").getPath();
        this.doExportToFile(fileName, fromSchema, fromTable, colDel, charDel, codeset);
    }

    private void doExportToFile(String fileName, String fromSchema, String fromTable, String colDel, String charDel, String codeset) throws SQLException {
        if (fileName != null) {
            SupportFilesSetup.deleteFile(fileName);
        }
        String expsql = "call SYSCS_UTIL.SYSCS_EXPORT_TABLE (? , ? , ? , ?, ? , ?)";
        PreparedStatement ps = this.prepareStatement(expsql);
        ps.setString(1, fromSchema);
        ps.setString(2, fromTable);
        ps.setString(3, fileName);
        ps.setString(4, colDel);
        ps.setString(5, charDel);
        ps.setString(6, codeset);
        ps.execute();
        ps.close();
    }

    private void doImportAndVerify(String fromSchema, String fromTable, String colDel, String charDel, String codeset, int replace) throws SQLException {
        this.doImport(fromTable, null, "T2", colDel, charDel, codeset, replace);
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM " + (fromSchema == null ? JDBC.escape(fromTable) : JDBC.escape(fromSchema, fromTable)));
        rs.next();
        int numberOfRowsInT1 = rs.getInt(1);
        rs.close();
        rs = stmt.executeQuery("SELECT COUNT(*) FROM t2");
        rs.next();
        int numberOfRowsInT2 = rs.getInt(1);
        rs.close();
        stmt.close();
        ImportExportTest.assertEquals((int)numberOfRowsInT1, (int)numberOfRowsInT2);
        this.doExport(null, "T2", colDel, charDel, codeset);
        ImportExportTest.assertEquals(SupportFilesSetup.getReadWrite(fromTable + ".dat"), SupportFilesSetup.getReadWrite("T2.dat"));
    }

    private void resetTables() throws Exception {
        this.runSQLCommands("delete from t1");
        this.runSQLCommands("delete from t2");
        this.runSQLCommands("INSERT INTO T1 VALUES (null,'aa',1,'a',DATE('1998-06-30'),1,1,1,1,1,1,1,TIME('12:00:00'),TIMESTAMP('1998-06-30 12:00:00.0'),1,'a')");
        this.runSQLCommands("INSERT INTO T1 VALUES (null,'bb',1,'b',DATE('1998-06-30'),2,2,2,2,2,2,2,TIME('12:00:00'),TIMESTAMP('1998-06-30 12:00:00.0'),2,'b')");
        this.runSQLCommands("INSERT INTO T1 VALUES (null,'cc',1,'c',DATE('1998-06-30'),3,3,3,3,3,3,3,TIME('12:00:00'),TIMESTAMP('1998-06-30 12:00:00.0'),3,'c')");
        this.runSQLCommands("INSERT INTO T1 VALUES (null,'dd',1,'d',DATE('1998-06-30'),4,4,4,4,4,4,4,TIME('12:00:00'),TIMESTAMP('1998-06-30 12:00:00.0'),4,'d')");
    }
}

