/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.Formatters;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClobReclamationTest
extends BaseJDBCTestCase {
    private static final int NUM_THREADS = 2;
    private static int expectedNumAllocated = 5;

    public ClobReclamationTest(String name) {
        super(name);
    }

    public void testMultiThreadedUpdate(final boolean lockTable, boolean updateSingleRow) throws SQLException, InterruptedException {
        int i;
        Connection conn = this.getConnection();
        final String updateString = Formatters.repeatChar("a", 33000);
        Thread[] threads = new Thread[2];
        for (i = 0; i < 2; ++i) {
            final int key = updateSingleRow ? 1 : i + 1;
            threads[i] = new Thread(){

                public void run() {
                    try {
                        Connection conn = ClobReclamationTest.this.openDefaultConnection();
                        conn.setAutoCommit(false);
                        ClobReclamationTest.fiveHundredUpdates(conn, updateString, key, lockTable);
                    }
                    catch (SQLException e) {
                        Assert.fail((String)e.getMessage());
                    }
                }
            };
        }
        for (i = 0; i < 2; ++i) {
            threads[i].start();
        }
        for (i = 0; i < 2; ++i) {
            threads[i].join();
        }
        this.checkNumAllocatedPages("CLOBTAB", expectedNumAllocated);
    }

    private void checkNumAllocatedPages(String table, int expectedAlloc) throws SQLException {
        PreparedStatement ps = this.prepareStatement("SELECT NUMALLOCATEDPAGES FROM  new org.apache.derby.diag.SpaceTable('APP',?) t WHERE CONGLOMERATENAME = ?");
        ps.setString(1, table);
        ps.setString(2, table);
        ResultSet rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, new String[][]{{"" + expectedAlloc}});
    }

    private void checkNumFreePages(String table, int expectedFree) throws SQLException {
        PreparedStatement ps = this.prepareStatement("SELECT NUMFREEPAGES FROM  new org.apache.derby.diag.SpaceTable('APP',?) t WHERE CONGLOMERATENAME = ?");
        ps.setString(1, table);
        ps.setString(2, table);
        ResultSet rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, new String[][]{{"" + expectedFree}});
    }

    private static void fiveHundredUpdates(Connection conn, String updateString, int key, boolean lockTable) throws SQLException {
        PreparedStatement ps = conn.prepareStatement("UPDATE CLOBTAB SET C = ? WHERE I = ?");
        for (int i = 0; i < 500; ++i) {
            if (lockTable) {
                Statement s = conn.createStatement();
                s.executeUpdate("LOCK TABLE CLOBTAB IN EXCLUSIVE MODE");
            }
            ps.setString(1, updateString);
            ps.setInt(2, key);
            ps.executeUpdate();
            conn.commit();
        }
    }

    public void testMultiThreadedUpdateRowLocking() throws SQLException, InterruptedException {
        this.testMultiThreadedUpdate(false, false);
    }

    public void xtestMultiThreadedUpdateTableLocking() throws SQLException, InterruptedException {
        this.testMultiThreadedUpdate(true, false);
    }

    public void xtestMultiThreadUpdateSingleRow() throws SQLException, InterruptedException {
        this.testMultiThreadedUpdate(false, true);
    }

    public void xtestReclamationOnRollback() throws SQLException {
        this.setAutoCommit(false);
        String insertString = Formatters.repeatChar("a", 33000);
        PreparedStatement ps = this.prepareStatement("INSERT INTO CLOBTAB2 VALUES(?,?)");
        for (int i = 0; i < 500; ++i) {
            ps.setInt(1, i);
            ps.setString(2, insertString);
            ps.executeUpdate();
            this.rollback();
        }
        this.checkNumAllocatedPages("CLOBTAB2", 1);
    }

    public void testBlobLinkedListReclamationOnRollback() throws SQLException {
        this.setAutoCommit(false);
        int clob_length = 200000;
        String insertString = Formatters.repeatChar("a", 200000);
        PreparedStatement ps = this.prepareStatement("INSERT INTO CLOBTAB3 VALUES(?,?)");
        int numrows = 500;
        for (int i = 0; i < numrows; ++i) {
            ps.setInt(1, i);
            ps.setString(2, insertString);
            ps.executeUpdate();
            this.rollback();
        }
        ps.close();
        this.checkNumAllocatedPages("CLOBTAB3", numrows * 2 + 1);
        this.checkNumFreePages("CLOBTAB3", clob_length / 32000 + 1 - 1);
        this.commit();
        CallableStatement call_compress = this.prepareCall("CALL SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?, ?, 1, 1, 1)");
        call_compress.setString(1, "APP");
        call_compress.setString(2, "CLOBTAB3");
        call_compress.executeUpdate();
        this.checkNumAllocatedPages("CLOBTAB3", 1);
        this.checkNumFreePages("CLOBTAB3", 0);
        this.commit();
    }

    public static Test suite() {
        Properties sysProps = new Properties();
        sysProps.put("derby.debug.true", "DaemonTrace");
        Test suite = TestConfiguration.embeddedSuite(ClobReclamationTest.class);
        return new CleanDatabaseTestSetup((Test)new SystemPropertyTestSetup(suite, sysProps, true)){

            protected void decorateSQL(Statement s) throws SQLException {
                Connection conn = s.getConnection();
                s.executeUpdate("CREATE TABLE CLOBTAB (I INT  PRIMARY KEY NOT NULL, c CLOB)");
                PreparedStatement ps = conn.prepareStatement("INSERT INTO CLOBTAB VALUES(?,?)");
                String insertString = "hello";
                for (int i = 1; i <= 2; ++i) {
                    ps.setInt(1, i);
                    ps.setString(2, insertString);
                    ps.executeUpdate();
                }
                s.executeUpdate("CREATE TABLE CLOBTAB2 (I INT, C CLOB)");
                s.executeUpdate("CREATE TABLE CLOBTAB3 (I INT, C CLOB)");
            }
        };
    }
}

