/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;

class Utils {
    boolean printDebug = false;
    private static final String FS = File.separator;

    Utils() {
    }

    void cleanDir(String dir, boolean deleteRootDirectory) throws Exception {
        try {
            File rootDir = new File(dir);
            if (!rootDir.isDirectory()) {
                throw new IOException("Given path is not a directory: " + dir);
            }
            this.DEBUG("cleanDir: " + dir);
            this.rmFiles(rootDir, deleteRootDirectory);
        }
        catch (Exception ex) {
            this.DEBUG("Got exception " + ex.getMessage());
            throw new Exception("Exception deleting files " + ex);
        }
    }

    void rmFiles(File dir, boolean rmdir) throws Exception {
        String currDir = dir.getAbsolutePath();
        if (dir.isDirectory()) {
            String[] filelist = dir.list();
            for (int i = 0; i < filelist.length; ++i) {
                File f = new File(currDir + FS + filelist[i]);
                if (f.isDirectory()) {
                    this.rmFiles(f, true);
                    continue;
                }
                boolean deleted = f.delete();
                if (deleted) continue;
                this.DEBUG("file NOT deleted " + f.getAbsolutePath());
            }
            if (rmdir) {
                this.DEBUG("deleting directory " + dir.getAbsolutePath());
                boolean deleted = dir.delete();
                if (!deleted) {
                    this.DEBUG("dir NOT deleted " + dir.getAbsolutePath());
                }
            }
        } else {
            this.DEBUG("deleting file " + dir.getAbsolutePath());
            boolean deleted = dir.delete();
            if (!deleted) {
                this.DEBUG("file NOT deleted " + dir.getAbsolutePath());
            }
        }
    }

    void copyDir(String sourcePath, String destPath) throws IOException {
        this.DEBUG("copyDir from " + sourcePath + " to " + destPath);
        this.copyFiles(sourcePath, destPath);
    }

    void copyFiles(String srcPath, String destPath) throws IOException {
        File src = new File(srcPath);
        File dest = new File(destPath);
        if (src.isDirectory()) {
            this.DEBUG("Make dir: " + dest.getAbsolutePath());
            dest.mkdirs();
            String[] list = src.list();
            for (int i = 0; i < list.length; ++i) {
                String srcFile = src.getAbsolutePath() + FS + list[i];
                String destFile = dest.getAbsolutePath() + FS + list[i];
                this.copyFiles(srcFile, destFile);
            }
        } else {
            this.copy(src, dest);
        }
    }

    private void copy(File source, File dest) throws IOException {
        int c;
        FileInputStream src = new FileInputStream(source);
        FileOutputStream dst = new FileOutputStream(dest);
        while ((c = src.read()) >= 0) {
            dst.write(c);
        }
        src.close();
        dst.close();
    }

    private void NIOcopy(File source, File dest) throws IOException {
        FileChannel sourceCh = new FileInputStream(source).getChannel();
        FileChannel targetCh = new FileOutputStream(dest).getChannel();
        sourceCh.transferTo(0L, sourceCh.size(), targetCh);
        sourceCh.close();
        targetCh.close();
    }

    void writeToFile(String text, String outFile) throws IOException {
        this.DEBUG("writeToFile " + outFile);
        FileWriter out = new FileWriter(outFile);
        out.write(text);
        out.close();
    }

    void mkDirs(String dirPath) {
        File dir = new File(dirPath);
        dir.mkdirs();
    }

    void DEBUG(String s) {
        if (this.printDebug) {
            System.out.println(s);
        }
    }

    void DEBUG(String s, PrintWriter out) {
        if (this.printDebug) {
            out.println(s);
        }
    }

    void sleep(long sleepTime, String ID) throws InterruptedException {
        this.DEBUG(ID + ": sleep " + sleepTime + "ms.");
        Thread.sleep(sleepTime);
    }
}

