/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ClientRunner;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.TestConfiguration;

public class TestPreStartedSlaveServer
extends ClientRunner {
    public TestPreStartedSlaveServer(String testcaseName) {
        super(testcaseName);
    }

    public static Test suite() throws Exception {
        System.out.println("**** TestPreStartedSlaveServer.suite()");
        TestPreStartedSlaveServer.initEnvironment();
        TestSuite suite = new TestSuite("TestPreStartedSlaveServer");
        suite.addTest(TestPreStartedSlaveServer.suite(slaveServerHost, slaveServerPort));
        System.out.println("*** Done suite.addTest(TestPreStartedSlaveServer.suite())");
        return suite;
    }

    public static Test suite(String serverHost, int serverPort) {
        System.out.println("*** TestPreStartedSlaveServer.suite(serverHost,serverPort)");
        Test t = TestConfiguration.existingServerSuite(TestPreStartedSlaveServer.class, false, serverHost, serverPort);
        System.out.println("*** Done TestConfiguration.existingServerSuite(TestPreStartedSlaveServer.class,false,serverHost,serverPort)");
        return t;
    }

    public void testStartSlaveConnect_Illegal() throws SQLException, IOException, InterruptedException {
        System.out.println("**** TestPreStartedSlaveServer.testStartSlaveConnect_Illegal() " + this.getTestConfiguration().getJDBCClient().getJDBCDriverName());
        Connection conn = null;
        String db = slaveDatabasePath + "/" + ReplicationRun.slaveDbSubPath + "/" + replicatedDb;
        String connectionURL = "jdbc:derby://" + slaveServerHost + ":" + slaveServerPort + "/" + db + ";startSlave=true" + ";slavehost=" + slaveServerHost + ";slaveport=" + slaveServerPort;
        System.out.println(connectionURL);
        try {
            conn = DriverManager.getConnection(connectionURL);
        }
        catch (SQLException se) {
            int ec = se.getErrorCode();
            String ss = se.getSQLState();
            String msg = ec + " " + ss + " " + se.getMessage();
            System.out.println("testStartSlaveConnect_Illegal: " + msg);
            TestPreStartedSlaveServer.assertSQLState("Unexpected SQLException: " + msg, "08001", se);
            return;
        }
        TestPreStartedSlaveServer.assertTrue((String)("Expected SQLException: '40000 08001 " + db + "'"), (boolean)false);
    }

    public void verifyTestStartSlaveConnect_Illegal() throws SQLException, IOException, InterruptedException {
    }
}

