/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ClientRunner;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.TestConfiguration;

public class TestPostStartedMasterAndSlave_Failover
extends ClientRunner {
    private static ReplicationRun repRun = new ReplicationRun("TestPostStartedMasterAndSlave_Failover");

    public TestPostStartedMasterAndSlave_Failover(String testcaseName) {
        super(testcaseName);
    }

    public static Test suite() throws Exception {
        System.out.println("**** TestPostStartedMasterAndSlave_Failover.suite()");
        TestPostStartedMasterAndSlave_Failover.initEnvironment();
        TestSuite suite = new TestSuite("TestPostStartedMasterAndSlave_Failover");
        suite.addTest(TestPostStartedMasterAndSlave_Failover.suite(slaveServerHost, slaveServerPort));
        System.out.println("*** Done suite.addTest(TestPostStartedMasterAndSlave_Failover.suite())");
        return suite;
    }

    public static Test suite(String serverHost, int serverPort) {
        System.out.println("*** TestPostStartedMasterAndSlave_Failover.suite(serverHost,serverPort)");
        Test t = TestConfiguration.existingServerSuite(TestPostStartedMasterAndSlave_Failover.class, false, serverHost, serverPort);
        System.out.println("*** Done TestConfiguration.existingServerSuite(TestPostStartedMasterAndSlave_Failover.class,false,serverHost,serverPort)");
        return t;
    }

    public void testFailOver() throws SQLException, IOException, InterruptedException {
        String msg;
        String ss;
        int ec;
        System.out.println("**** TestPostStartedMasterAndSlave_Failover.testFailOver() " + this.getTestConfiguration().getJDBCClient().getJDBCDriverName());
        Connection conn = null;
        String db = slaveDatabasePath + "/" + ReplicationRun.slaveDbSubPath + "/" + replicatedDb;
        String connectionURL = "jdbc:derby://" + slaveServerHost + ":" + slaveServerPort + "/" + db + ";failover=true";
        System.out.println(connectionURL);
        try {
            conn = DriverManager.getConnection(connectionURL);
            System.out.println("Successfully connected as: " + connectionURL);
            TestPostStartedMasterAndSlave_Failover.assertTrue((String)("Successfully connected as: " + connectionURL), (boolean)false);
        }
        catch (SQLException se) {
            ec = se.getErrorCode();
            ss = se.getSQLState();
            msg = "As expected: Failover on slave should fail: " + ec + " " + ss + " " + se.getMessage();
            System.out.println(msg);
        }
        db = masterDatabasePath + "/" + ReplicationRun.masterDbSubPath + "/" + replicatedDb;
        connectionURL = "jdbc:derby://" + masterServerHost + ":" + masterServerPort + "/" + db + ";failover=true";
        System.out.println(connectionURL);
        try {
            conn = DriverManager.getConnection(connectionURL);
            System.out.println("Unexpectedly connected as: " + connectionURL);
            TestPostStartedMasterAndSlave_Failover.assertTrue((String)("Unexpectedly connected as: " + connectionURL), (boolean)false);
        }
        catch (SQLException se) {
            ec = se.getErrorCode();
            ss = se.getSQLState();
            msg = ec + " " + ss + " " + se.getMessage();
            TestPostStartedMasterAndSlave_Failover.assertSQLState(msg, "XRE20", se);
            System.out.println("Failover on master succeeded: " + connectionURL + " " + msg);
        }
    }

    public void verify() throws SQLException, IOException, InterruptedException {
    }
}

