/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derby.jdbc.ClientDataSource;
import org.apache.derbyTesting.functionTests.tests.replicationTests.Utils;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ReplicationRun
extends BaseTestCase {
    static final String REPLICATIONTEST_PROPFILE = "replicationtest.properties";
    static final String REPLICATION_MASTER_TIMED_OUT = "XRE06";
    static final String REPLICATION_SLAVE_STARTED_OK = "XRE08";
    static final String REPLICATION_DB_NOT_BOOTED = "XRE11";
    static final String SLAVE_OPERATION_DENIED_WHILE_CONNECTED = "XRE41";
    static final String REPLICATION_SLAVE_SHUTDOWN_OK = "XRE42";
    static String testUser = null;
    static String userDir = null;
    static String dataEncryption = null;
    static String masterServerHost = "localhost";
    static int masterServerPort = 1527;
    static String slaveServerHost = "localhost";
    static int slaveServerPort = 3527;
    static String testClientHost = "localhost";
    static int slaveReplPort = 6666;
    static String masterDatabasePath = null;
    static String slaveDatabasePath = null;
    static String replicatedDb = "test";
    static String bootLoad = "";
    static String freezeDB = "";
    static String unFreezeDB = "";
    static boolean runUnReplicated = false;
    static boolean simpleLoad = true;
    static int simpleLoadTuples = 1000;
    static int tuplesToInsertPerf = 10000;
    static int commitFreq = 0;
    static String masterDbSubPath = "db_master";
    static String slaveDbSubPath = "db_slave";
    static final String DB_UID = "";
    static final String DB_PASSWD = "";
    static String replicationTest = "";
    static String replicationVerify = "";
    static String sqlLoadInit = "";
    static final String networkServerControl = "org.apache.derby.drda.NetworkServerControl";
    static String specialTestingJar = null;
    static String jvmVersion = null;
    static String masterJvmVersion = null;
    static String slaveJvmVersion = null;
    static String derbyVersion = null;
    static String derbyMasterVersion = null;
    static String derbySlaveVersion = null;
    static String junit_jar = null;
    static String test_jars = null;
    static final String FS = File.separator;
    static final String PS = File.pathSeparator;
    static final String JVMloc = BaseTestCase.getJavaExecutableName();
    static boolean showSysinfo = false;
    static long PINGSERVER_SLEEP_TIME_MILLIS = 500L;
    static long sleepTime = 5000L;
    static final String DRIVER_CLASS_NAME = "org.apache.derby.jdbc.ClientDriver";
    static final String DB_PROTOCOL = "jdbc:derby";
    static final String ALL_INTERFACES = "0.0.0.0";
    static String LF = null;
    static final String remoteShell = "/usr/bin/ssh -x";
    Utils util = new Utils();
    State state = new State();
    static boolean localEnv = false;
    static String derbyProperties = null;
    NetworkServerControl masterServer;
    NetworkServerControl slaveServer;
    String classPath = null;
    private Connection masterConn = null;
    private Connection slaveConn = null;
    private volatile Exception startSlaveException = null;
    static Load masterPreRepl;
    static Load masterPostRepl;
    static Load slavePreSlave;
    static Load masterPostSlave;
    static Load slavePostSlave;

    public ReplicationRun(String testcaseName) {
        super(testcaseName);
        LF = System.getProperties().getProperty("line.separator");
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.stopServer(jvmVersion, derbyVersion, slaveServerHost, slaveServerPort);
        this.stopServer(jvmVersion, derbyVersion, masterServerHost, masterServerPort);
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        try {
            super.runBare();
        }
        catch (Throwable running) {
            PrintWriter stackOut = null;
            try {
                String failPath = PrivilegedFileOpsForTests.getAbsolutePath(this.getFailureFolder());
                stackOut = new PrintWriter(PrivilegedFileOpsForTests.getFileOutputStream(new File(failPath, "error-stacktrace.out"), true));
                String[] replPaths = new String[]{masterDbSubPath, slaveDbSubPath};
                for (int i = 0; i < 2; ++i) {
                    File origLog = new File(replPaths[i], "derby.log");
                    File newLog = new File(failPath, replPaths[i] + "-" + "derby.log");
                    PrivilegedFileOpsForTests.copy(origLog, newLog);
                    String dbName = TestConfiguration.getCurrent().getDefaultDatabaseName();
                    File dbDir = new File(replPaths[i], dbName);
                    File newDbDir = new File(failPath, replPaths[i] + "-" + dbName);
                    PrivilegedFileOpsForTests.copy(dbDir, newDbDir);
                }
            }
            catch (IOException ioe) {
                BaseTestCase.printStackTrace(ioe);
                if (stackOut != null) {
                    stackOut.println("Copying db_slave/db_master's derby.log or database failed:");
                    ioe.printStackTrace(stackOut);
                    stackOut.println();
                }
            }
            finally {
                if (stackOut != null) {
                    stackOut.close();
                }
                throw running;
            }
        }
    }

    String useEncryption(boolean create) {
        String encryptionString = "";
        if (dataEncryption != null) {
            if (create) {
                encryptionString = ";dataEncryption=true";
            }
            encryptionString = encryptionString + ";" + dataEncryption;
        }
        return encryptionString;
    }

    void connectPing(String fullDbPath, String serverHost, int serverPort, String testClientHost) throws Exception {
        String serverURL = "jdbc:derby://" + serverHost + ":" + serverPort + "/";
        String dbURL = serverURL + fullDbPath + this.useEncryption(false);
        Connection conn = null;
        String lastmsg = null;
        long sleeptime = 200L;
        boolean done = false;
        int count = 0;
        while (!done) {
            try {
                Class.forName(DRIVER_CLASS_NAME);
                conn = DriverManager.getConnection(dbURL);
                done = true;
                this.util.DEBUG("Got connection after " + count + " * " + sleeptime + " ms.");
                conn.close();
            }
            catch (SQLException se) {
                int errCode = se.getErrorCode();
                lastmsg = se.getMessage();
                String sState = se.getSQLState();
                String expectedState = "08004";
                lastmsg = errCode + " " + sState + " " + lastmsg + ". Expected: " + expectedState;
                this.util.DEBUG("Got SQLException: " + lastmsg);
                if (errCode == -1 && sState.equalsIgnoreCase(expectedState)) {
                    this.util.DEBUG("Failover not complete.");
                    Thread.sleep(sleeptime);
                }
                se.printStackTrace();
                ReplicationRun.assertTrue((String)("Connect failed. " + lastmsg), (boolean)false);
                return;
            }
            ReplicationRun.assertTrue((String)"Failover did not succeed.", (count++ < 600 ? 1 : 0) != 0);
        }
    }

    String showCurrentState(String ID, long waitTime, String fullDbPath, String serverHost, int serverPort) throws Exception {
        int errCode = 0;
        String sState = "CONNECTED";
        String msg = null;
        Thread.sleep(waitTime);
        try {
            ClientDataSource ds = new ClientDataSource();
            ds.setDatabaseName(fullDbPath);
            ds.setServerName(serverHost);
            ds.setPortNumber(serverPort);
            ds.setConnectionAttributes(this.useEncryption(false));
            Connection conn = ds.getConnection();
            conn.close();
        }
        catch (SQLException se) {
            errCode = se.getErrorCode();
            msg = se.getMessage();
            sState = se.getSQLState();
        }
        this.util.DEBUG(ID + ": [" + serverHost + ":" + serverPort + "/" + fullDbPath + "] " + errCode + " " + sState + " " + msg);
        return sState;
    }

    void waitForConnect(long sleepTime, int tries, String fullDbPath, String serverHost, int serverPort) throws Exception {
        int count = 0;
        String msg = null;
        while (count++ <= tries) {
            try {
                ClientDataSource ds = new ClientDataSource();
                ds.setDatabaseName(fullDbPath);
                ds.setServerName(serverHost);
                ds.setPortNumber(serverPort);
                ds.setConnectionAttributes(this.useEncryption(false));
                Connection conn = ds.getConnection();
                this.util.DEBUG("Got connection after " + (count - 1) + " * " + sleepTime + " ms.");
                conn.close();
                return;
            }
            catch (SQLException se) {
                msg = se.getErrorCode() + "' '" + se.getSQLState() + "' '" + se.getMessage();
                this.util.DEBUG(count + " got '" + msg + "'.");
                Thread.sleep(sleepTime);
            }
        }
        ReplicationRun.assertTrue((String)(msg + ": Could NOT connect in " + tries + "*" + sleepTime + "ms."), (boolean)false);
    }

    void waitForSQLState(String expectedState, long sleepTime, int tries, String fullDbPath, String serverHost, int serverPort) throws Exception {
        int count = 0;
        String msg = null;
        while (count++ <= tries) {
            try {
                ClientDataSource ds = new ClientDataSource();
                ds.setDatabaseName(fullDbPath);
                ds.setServerName(serverHost);
                ds.setPortNumber(serverPort);
                ds.setConnectionAttributes(this.useEncryption(false));
                Connection conn = ds.getConnection();
                conn.close();
                ReplicationRun.assertTrue((String)("Expected SQLState'" + expectedState + "', but got connection!"), (boolean)false);
            }
            catch (SQLException se) {
                int errCode = se.getErrorCode();
                msg = se.getMessage();
                String sState = se.getSQLState();
                msg = "'" + errCode + "' '" + sState + "' '" + msg + "'";
                this.util.DEBUG(count + ": SQLState expected '" + expectedState + "'," + " got " + msg);
                if (sState.equals(expectedState)) {
                    this.util.DEBUG("Reached SQLState '" + expectedState + "' in " + (count - 1) + "*" + sleepTime + "ms.");
                    return;
                }
                Thread.sleep(sleepTime);
            }
        }
        ReplicationRun.assertTrue((String)(msg + ": SQLState '" + expectedState + "' was not reached in " + tries + "*" + sleepTime + "ms."), (boolean)false);
    }

    void shutdownDb(String jvmVersion, String serverHost, int serverPort, String dbPath, String replicatedDb, String clientHost) throws Exception {
        String serverURL = "jdbc:derby://" + serverHost + ":" + serverPort + "/";
        String dbURL = serverURL + dbPath + FS + replicatedDb + this.useEncryption(false);
        this.util.DEBUG("**** DriverManager.getConnection(\"" + dbURL + ";shutdown=true\");");
        try {
            Class.forName(DRIVER_CLASS_NAME);
            DriverManager.getConnection(dbURL + ";shutdown=true");
        }
        catch (SQLException se) {
            // empty catch block
        }
    }

    void startServerMonitor(String slaveHost) {
        this.util.DEBUG("startServerMonitor(" + slaveHost + ") NOT YET IMPLEMENTED.");
    }

    void runTest(String replicationTest, String clientVM, String testClientHost, String serverHost, int serverPort, String dbName) throws Exception {
        this.util.DEBUG("runTest(" + replicationTest + ", " + clientVM + ", " + testClientHost + ", " + serverHost + ", " + serverPort + ", " + dbName + ") ");
        if (replicationTest == null) {
            this.util.DEBUG("No replicationTest specified. Exitting.");
            return;
        }
        if (simpleLoad) {
            this._testInsertUpdateDeleteOnMaster(serverHost, serverPort, dbName, simpleLoadTuples);
            return;
        }
        String URL2 = this.masterURL(dbName);
        String ijClassPath = derbyVersion + FS + "derbyclient.jar" + PS + derbyVersion + FS + "derbyTesting.jar" + PS + derbyVersion + FS + "derbytools.jar";
        String testingClassPath = derbyVersion + FS + "derbyclient.jar" + PS + derbyVersion + FS + "derbynet.jar" + PS + test_jars;
        String clientJvm = BaseTestCase.getJavaExecutableName();
        String command = null;
        this.util.DEBUG("replicationTest: " + replicationTest);
        if (replicationTest.indexOf(".sql") >= 0) {
            command = clientJvm + " -Dij.driver=" + DRIVER_CLASS_NAME + " -Dij.connection.startTestClient=" + URL2 + " -classpath " + ijClassPath + " org.apache.derby.tools.ij" + " " + replicationTest;
        } else {
            if (testClientHost.equals("localhost")) {
                testingClassPath = this.classPath;
            }
            command = clientJvm + " -Dderby.tests.trace=true" + " -Dtest.serverHost=" + serverHost + " -Dtest.serverPort=" + serverPort + " -Dtest.inserts=" + tuplesToInsertPerf + " -Dtest.commitFreq=" + commitFreq + " -classpath " + testingClassPath + " junit.textui.TestRunner" + " " + replicationTest;
        }
        long startTime = System.currentTimeMillis();
        String results = null;
        if (testClientHost.equalsIgnoreCase("localhost")) {
            this.runUserCommandLocally(command, userDir + FS + masterDbSubPath, "runTest ");
        } else {
            command = "cd " + userDir + ";" + command;
            results = this.runUserCommandRemotely(command, testClientHost, testUser, "runTest ");
        }
        this.util.DEBUG("Time: " + (double)(System.currentTimeMillis() - startTime) / 1000.0);
    }

    void runTestOnSlave(String replicationTest, String clientVM, String testClientHost, String serverHost, int serverPort, String dbName) throws Exception {
        this.util.DEBUG("runTestOnSlave(" + replicationTest + ", " + clientVM + ", " + testClientHost + ", " + serverHost + ", " + serverPort + ", " + dbName + ") ");
        String URL2 = this.slaveURL(dbName);
        String ijClassPath = derbyVersion + FS + "derbyclient.jar" + PS + derbyVersion + FS + "derbyTesting.jar" + PS + derbyVersion + FS + "derbytools.jar";
        String testingClassPath = derbyVersion + FS + "derbyclient.jar" + PS + derbyVersion + FS + "derbynet.jar" + PS + test_jars;
        String clientJvm = BaseTestCase.getJavaExecutableName();
        String command = null;
        if (replicationTest == null) {
            this.util.DEBUG("No replicationTest specified. Exitting.");
            return;
        }
        if (serverHost.equals("localhost")) {
            ijClassPath = this.classPath;
            testingClassPath = this.classPath;
        }
        this.util.DEBUG("replicationTest: " + replicationTest);
        if (replicationTest.indexOf(".sql") >= 0) {
            command = clientJvm + " -Dij.driver=" + DRIVER_CLASS_NAME + " -Dij.connection.startTestClient=" + URL2 + " -classpath " + ijClassPath + " org.apache.derby.tools.ij" + " " + replicationTest;
        } else {
            if (testClientHost.equals("localhost")) {
                testingClassPath = this.classPath;
            }
            command = clientJvm + " -Dderby.tests.trace=true" + " -Dtest.serverHost=" + serverHost + " -Dtest.serverPort=" + serverPort + " -Dtest.inserts=" + tuplesToInsertPerf + " -Dtest.commitFreq=" + commitFreq + " -classpath " + testingClassPath + " junit.textui.TestRunner" + " " + replicationTest;
        }
        long startTime = System.currentTimeMillis();
        String results = null;
        if (testClientHost.equalsIgnoreCase("localhost")) {
            this.runUserCommandLocally(command, userDir + FS + slaveDbSubPath, "runTestOnSlave ");
        } else {
            command = "cd " + userDir + ";" + command;
            results = this.runUserCommandRemotely(command, testClientHost, testUser, "runTestOnSlave ");
        }
        this.util.DEBUG("Time: " + (double)(System.currentTimeMillis() - startTime) / 1000.0);
    }

    private void runLoad(String load, String clientVM, String testClientHost, String masterHost, int masterPort, String dbSubPath) throws Exception {
        this.util.DEBUG("runLoad(" + load + ", " + clientVM + ", " + testClientHost + ", " + masterHost + ", " + masterPort + ", " + dbSubPath + ") ");
        String URL2 = this.masterLoadURL(dbSubPath);
        String ijClassPath = derbyVersion + FS + "derbyclient.jar" + PS + derbyVersion + FS + "derbyTesting.jar" + PS + derbyVersion + FS + "derbytools.jar";
        String testingClassPath = derbyVersion + FS + "derbyclient.jar" + PS + derbyVersion + FS + "derbynet.jar" + PS + test_jars;
        String clientJvm = BaseTestCase.getJavaExecutableName();
        String command = null;
        if (masterHost.equals("localhost")) {
            ijClassPath = this.classPath;
            testingClassPath = this.classPath;
        }
        this.util.DEBUG("load: " + load);
        command = load.indexOf(".sql") >= 0 ? clientJvm + " -Dij.driver=" + DRIVER_CLASS_NAME + " -Dij.connection.startTestClient=" + URL2 + " -classpath " + ijClassPath + " org.apache.derby.tools.ij" + " " + load : clientJvm + " -Dderby.tests.trace=true" + " -classpath " + testingClassPath + " junit.textui.TestRunner" + " " + load;
        if (testClientHost.equalsIgnoreCase("localhost")) {
            this.runUserCommandInThread(command, testUser, dbSubPath, "runLoad[" + dbSubPath + "] ");
        } else {
            this.runUserCommandInThreadRemotely(command, testClientHost, testUser, dbSubPath, "runLoad[" + dbSubPath + "] ");
        }
    }

    private void runStateTest(String stateTest, String clientVM, String testClientHost, String masterHost, int masterPort, String dbSubPath) throws Exception {
        this.util.DEBUG("runStateTest(" + stateTest + ", " + clientVM + ", " + testClientHost + ", " + masterHost + ", " + masterPort + ", " + dbSubPath + ") ");
        String URL2 = this.masterLoadURL(dbSubPath);
        String ijClassPath = derbyVersion + FS + "derbyclient.jar" + PS + derbyVersion + FS + "derbyTesting.jar" + PS + derbyVersion + FS + "derbytools.jar";
        String testingClassPath = derbyVersion + FS + "derbyclient.jar" + PS + derbyVersion + FS + "derbynet.jar" + PS + test_jars;
        String clientJvm = BaseTestCase.getJavaExecutableName();
        String command = null;
        if (masterHost.equals("localhost")) {
            ijClassPath = this.classPath;
            testingClassPath = this.classPath;
        }
        this.util.DEBUG("stateTest: " + stateTest);
        command = stateTest.indexOf(".sql") >= 0 ? clientJvm + " -Dij.driver=" + DRIVER_CLASS_NAME + " -Dij.connection.startTestClient=" + URL2 + " -classpath " + ijClassPath + " org.apache.derby.tools.ij" + " " + stateTest : "cd " + userDir + ";" + clientJvm + " -Dderby.tests.trace=true" + " -classpath " + testingClassPath + " junit.textui.TestRunner" + " " + stateTest;
        this.runUserCommandRemotely(command, testClientHost, testUser, "runStateTest ");
    }

    void bootMasterDatabase(String clientVM, String dbSubPath, String dbName, String masterHost, int masterServerPort, String load) throws Exception {
        Connection conn;
        String URL2 = this.masterURL(dbName) + ";create=true" + this.useEncryption(true);
        String ijClassPath = derbyVersion + FS + "derbyclient.jar" + PS + derbyVersion + FS + "derbytools.jar";
        if (masterHost.equals("localhost")) {
            ijClassPath = this.classPath;
        }
        String clientJvm = BaseTestCase.getJavaExecutableName();
        String results = null;
        if (masterHost.equalsIgnoreCase("localhost") || localEnv) {
            this.util.DEBUG("bootMasterDatabase getConnection(" + URL2 + ")");
            Class.forName(DRIVER_CLASS_NAME);
            conn = DriverManager.getConnection(URL2);
            conn.close();
        } else {
            String command = clientJvm + " -Dij.driver=" + DRIVER_CLASS_NAME + " -Dij.connection.createMaster=\"" + URL2 + "\"" + " -classpath " + ijClassPath + " org.apache.derby.tools.ij" + " " + "exit.sql";
            results = this.runUserCommandRemotely(command, testClientHost, testUser, "bootMasterDatabase ");
        }
        this.util.DEBUG(results);
        this.util.DEBUG("************************** DERBY-???? Preliminary needs to freeze db before copying to slave and setting replication mode.");
        if (masterServerHost.equalsIgnoreCase("localhost") || localEnv) {
            URL2 = this.masterURL(dbName);
            Class.forName(DRIVER_CLASS_NAME);
            this.util.DEBUG("bootMasterDatabase getConnection(" + URL2 + ")");
            conn = DriverManager.getConnection(URL2);
            Statement s = conn.createStatement();
            s.execute("call syscs_util.syscs_freeze_database()");
            conn.close();
        } else {
            this.runTest(freezeDB, clientVM, testClientHost, masterServerHost, masterServerPort, dbName);
        }
        if (load != null) {
            this.runLoad(load, clientVM, testClientHost, masterServerHost, masterServerPort, dbSubPath + FS + dbName);
        }
        this.util.DEBUG("bootMasterDatabase done.");
    }

    void startMaster(String clientVM, String dbName, String masterHost, int masterServerPort, String slaveClientInterface, int slaveServerPort, String slaveReplInterface, int slaveReplPort) throws Exception {
        if (masterHost.equalsIgnoreCase("localhost")) {
            this.startMaster_direct(dbName, masterHost, masterServerPort, slaveReplInterface, slaveReplPort);
        } else {
            this.startMaster_ij(dbName, masterHost, masterServerPort, slaveReplInterface, slaveReplPort, testClientHost);
        }
    }

    private void startMaster_CLI(String clientVM, String dbName, String masterHost, int masterServerPort, String slaveClientInterface, int slaveServerPort, String slaveReplInterface, int slaveReplPort) throws Exception {
        String masterClassPath = derbyMasterVersion + FS + "derbynet.jar";
        String clientJvm = BaseTestCase.getJavaExecutableName();
        if (masterHost.equals("localhost")) {
            masterClassPath = this.classPath;
        }
        String command = clientJvm + " -classpath " + masterClassPath + " " + networkServerControl + " startreplication" + " " + dbName + " -slavehost " + slaveReplInterface + " -slaveport " + slaveReplPort + " -h " + slaveClientInterface + " -p " + masterServerPort + " -noSecurityManager";
        this.util.DEBUG("Executing '" + command + "' on " + masterHost);
        this.runUserCommandInThreadRemotely(command, masterHost, testUser, masterDbSubPath + FS + dbName, "startMaster_CLI ");
    }

    private void startMaster_ij(String dbName, String masterHost, int masterServerPort, String slaveReplInterface, int slaveReplPort, String testClientHost) throws Exception {
        String masterClassPath = derbyMasterVersion + FS + "derbynet.jar";
        if (masterHost.equals("localhost")) {
            masterClassPath = this.classPath;
        }
        String URL2 = this.masterURL(dbName) + ";startMaster=true;slaveHost=" + slaveReplInterface + ";slavePort=" + slaveReplPort;
        String ijClassPath = derbyVersion + FS + "derbyclient.jar" + PS + derbyVersion + FS + "derbytools.jar";
        if (masterHost.equals("localhost")) {
            ijClassPath = this.classPath;
        }
        String clientJvm = BaseTestCase.getJavaExecutableName();
        String command = clientJvm + " -Dij.driver=" + DRIVER_CLASS_NAME + " -Dij.connection.startMaster=\"" + URL2 + "\"" + " -classpath " + ijClassPath + " org.apache.derby.tools.ij" + " " + "/home/os136789/Replication/testing/exit.sql";
        String results = this.runUserCommandRemotely(command, testClientHost, testUser, "startMaster_ij ");
        this.util.DEBUG(results);
    }

    private void startMaster_direct(String dbName, String masterHost, int masterServerPort, String slaveReplInterface, int slaveReplPort) throws Exception {
        String URL2 = this.masterURL(dbName) + ";startMaster=true;slaveHost=" + slaveReplInterface + ";slavePort=" + slaveReplPort;
        this.util.DEBUG("startMaster_direct getConnection(" + URL2 + ")");
        Connection conn = null;
        boolean done = false;
        int count = 0;
        while (!done) {
            try {
                ClientDataSource ds = new ClientDataSource();
                ds.setDatabaseName(masterDatabasePath + FS + masterDbSubPath + FS + dbName);
                ds.setServerName(masterHost);
                ds.setPortNumber(masterServerPort);
                ds.setConnectionAttributes("startMaster=true;slaveHost=" + slaveReplInterface + ";slavePort=" + slaveReplPort + this.useEncryption(false));
                conn = ds.getConnection();
                done = true;
                conn.close();
                this.util.DEBUG("startMaster_direct connected in " + count + " * 100ms.");
            }
            catch (SQLException se) {
                int errCode = se.getErrorCode();
                String msg = se.getMessage();
                String sState = se.getSQLState();
                String expectedState = "XRE04";
                this.util.DEBUG("startMaster Got SQLException: " + errCode + " " + sState + " " + msg + ". Expected " + expectedState);
                if (errCode == -1 && sState.equalsIgnoreCase(expectedState)) {
                    this.util.DEBUG("Not ready to startMaster. Beware: Will also report '... got a fatal error for database '...../<dbname>' in master derby.log.");
                    Thread.sleep(100L);
                }
                if (REPLICATION_MASTER_TIMED_OUT.equals(sState)) {
                    this.util.DEBUG("Master already started?");
                }
                this.util.DEBUG("startMaster_direct Got: " + this.state + " Expected " + expectedState);
                throw se;
            }
            ReplicationRun.assertTrue((String)"startMaster did not succeed.", (count++ < 1200 ? 1 : 0) != 0);
        }
        this.util.DEBUG("startMaster_direct exit.");
    }

    protected Connection getMasterConnection() {
        if (this.masterConn == null) {
            String url = this.masterURL(replicatedDb);
            try {
                this.masterConn = DriverManager.getConnection(url);
            }
            catch (SQLException sqle) {
                ReplicationRun.fail((String)"Could not connect to master database");
            }
        }
        return this.masterConn;
    }

    protected Connection getSlaveConnection() {
        if (this.slaveConn == null) {
            String url = this.slaveURL(replicatedDb);
            try {
                this.slaveConn = DriverManager.getConnection(url);
            }
            catch (SQLException sqle) {
                ReplicationRun.fail((String)"Could not connect to slave database");
            }
        }
        return this.slaveConn;
    }

    protected void executeOnMaster(String sql) throws SQLException {
        Statement s = this.getMasterConnection().createStatement();
        s.execute(sql);
        s.close();
    }

    protected void executeOnSlave(String sql) throws SQLException {
        Statement s = this.getSlaveConnection().createStatement();
        s.execute(sql);
        s.close();
    }

    void startSlave(String clientVM, String dbName, String slaveClientInterface, int slaveServerPort, String slaveReplInterface, int slaveReplPort, String testClientHost) throws Exception {
        if (testClientHost.equalsIgnoreCase("localhost")) {
            this.startSlave_direct(dbName, slaveClientInterface, slaveServerPort, slaveReplInterface, slaveReplPort);
        } else {
            this.startSlave_ij(jvmVersion, dbName, slaveClientInterface, slaveServerPort, slaveReplInterface, slaveReplPort, testClientHost);
        }
    }

    private void startSlave_CLI(String clientVM, String dbName, String slaveClientInterface, int slaveServerPort, String slaveReplInterface, int slaveReplPort) throws InterruptedException {
        String slaveClassPath = derbySlaveVersion + FS + "derbynet.jar";
        if (slaveClientInterface.equals("localhost")) {
            slaveClassPath = this.classPath;
        }
        String clientJvm = BaseTestCase.getJavaExecutableName();
        String command = clientJvm + " -classpath " + slaveClassPath + " " + networkServerControl + " startslave" + " " + dbName + " -slavehost " + slaveReplInterface + " -slaveport " + slaveReplPort + " -h " + slaveClientInterface + " -p " + slaveServerPort + " -noSecurityManager";
        this.util.DEBUG("Executing  '" + command + "' on " + slaveClientInterface);
        this.runUserCommandInThreadRemotely(command, slaveClientInterface, testUser, slaveDbSubPath + FS + dbName, "startSlave_CLI ");
    }

    private void startSlave_ij(String jvmVersion, String dbName, String slaveHost, int slaveServerPort, String slaveReplInterface, int slaveReplPort, String testClientHost) throws Exception {
        String slaveClassPath = derbySlaveVersion + FS + "derbynet.jar";
        if (slaveHost.equals("localhost")) {
            slaveClassPath = this.classPath;
        }
        String URL2 = this.slaveURL(dbName) + ";startSlave=true;slaveHost=" + slaveReplInterface + ";slavePort=" + slaveReplPort;
        String ijClassPath = derbyVersion + FS + "derbyclient.jar" + PS + derbyVersion + FS + "derbytools.jar";
        if (slaveHost.equals("localhost")) {
            ijClassPath = this.classPath;
        }
        String clientJvm = BaseTestCase.getJavaExecutableName();
        String command = clientJvm + " -Dij.driver=" + DRIVER_CLASS_NAME + " -Dij.connection.startSlave=\"" + URL2 + "\"" + " -classpath " + ijClassPath + " org.apache.derby.tools.ij" + " " + "/home/os136789/Replication/testing/exit.sql";
        this.runUserCommandInThreadRemotely(command, testClientHost, testUser, slaveDbSubPath + FS + dbName, "startSlave_ij ");
    }

    private void startSlave_direct(String dbName, String slaveHost, int slaveServerPort, String slaveReplInterface, int slaveReplPort) throws Exception {
        String URL2 = this.slaveURL(dbName) + ";startSlave=true;slaveHost=" + slaveReplInterface + ";slavePort=" + slaveReplPort;
        this.util.DEBUG("startSlave_direct getConnection(" + URL2 + ")");
        final String fDbPath = slaveDatabasePath + FS + slaveDbSubPath + FS + dbName;
        final String fSlaveHost = slaveHost;
        final int fSlaveServerPort = slaveServerPort;
        final String fConnAttrs = "startSlave=true;slaveHost=" + slaveReplInterface + ";slavePort=" + slaveReplPort + this.useEncryption(false);
        Thread connThread = new Thread(new Runnable(){

            public void run() {
                ReplicationRun.this.startSlaveException = null;
                Connection conn = null;
                String expectedState = ReplicationRun.REPLICATION_SLAVE_STARTED_OK;
                try {
                    ClientDataSource ds = new ClientDataSource();
                    ds.setDatabaseName(fDbPath);
                    ds.setServerName(fSlaveHost);
                    ds.setPortNumber(fSlaveServerPort);
                    ds.setConnectionAttributes(fConnAttrs);
                    conn = ds.getConnection();
                    conn.close();
                }
                catch (SQLException se) {
                    ReplicationRun.this.startSlaveException = se;
                }
                catch (Exception ex) {
                    ReplicationRun.this.startSlaveException = ex;
                }
            }
        });
        connThread.start();
        this.util.DEBUG("startSlave_direct exit.");
    }

    void failOver(String jvmVersion, String dbPath, String dbSubPath, String dbName, String host, int serverPort, String testClientHost) throws Exception {
        if (host.equalsIgnoreCase("localhost")) {
            this.failOver_direct(dbPath, dbSubPath, dbName, host, serverPort);
        } else {
            this.failOver_ij(jvmVersion, dbPath, dbSubPath, dbName, host, serverPort, testClientHost);
        }
    }

    private void failOver_ij(String jvmVersion, String dbPath, String dbSubPath, String dbName, String host, int serverPort, String testClientHost) throws Exception {
        String masterClassPath = derbyMasterVersion + FS + "derbynet.jar";
        String URL2 = this.masterURL(dbName) + ";failover=true";
        String ijClassPath = derbyVersion + FS + "derbyclient.jar" + PS + derbyVersion + FS + "derbytools.jar";
        if (host.equals("localhost")) {
            ijClassPath = this.classPath;
        }
        String clientJvm = BaseTestCase.getJavaExecutableName();
        String command = clientJvm + " -Dij.driver=" + DRIVER_CLASS_NAME + " -Dij.connection.failover=\"" + URL2 + "\"" + " -classpath " + ijClassPath + " org.apache.derby.tools.ij" + " " + "/home/os136789/Replication/testing/exit.sql";
        String results = this.runUserCommandRemotely(command, testClientHost, testUser, "failOver_ij ");
        this.util.DEBUG(results);
    }

    private void failOver_direct(String dbPath, String dbSubPath, String dbName, String host, int serverPort) throws Exception {
        String URL2 = this.masterURL(dbName) + ";failover=true";
        this.util.DEBUG("failOver_direct getConnection(" + URL2 + ")");
        Connection conn = null;
        try {
            Class.forName(DRIVER_CLASS_NAME);
            conn = DriverManager.getConnection(URL2);
        }
        catch (SQLException se) {
            int errCode = se.getErrorCode();
            String msg = se.getMessage();
            String sState = se.getSQLState();
            String expectedState = "XRE20";
            msg = "failOver_direct Got SQLException: " + errCode + " " + sState + " " + msg + ". Expected: " + expectedState;
            this.util.DEBUG(msg);
            BaseJDBCTestCase.assertSQLState(expectedState, se);
        }
    }

    private void stopMaster(String dbName) {
        this.util.DEBUG("Simulating '... stopreplication/stopmaster -db " + dbName + " NB! Doing nothing now!");
    }

    private void stopMaster_ij(String jvmVersion, String dbName, String masterHost, int masterServerPort, String testClientHost) throws Exception {
        String masterClassPath = derbyMasterVersion + FS + "derbynet.jar";
        if (masterHost.equals("localhost")) {
            masterClassPath = this.classPath;
        }
        String URL2 = this.masterURL(dbName) + ";stopMaster=true";
        String ijClassPath = derbyVersion + FS + "derbyclient.jar" + PS + derbyVersion + FS + "derbytools.jar";
        if (masterHost.equals("localhost")) {
            ijClassPath = this.classPath;
        }
        String clientJvm = BaseTestCase.getJavaExecutableName();
        String command = clientJvm + " -Dij.driver=" + DRIVER_CLASS_NAME + " -Dij.connection.stopMaster=\"" + URL2 + "\"" + " -classpath " + ijClassPath + " org.apache.derby.tools.ij" + " " + "/home/os136789/Replication/testing/exit.sql";
        String results = this.runUserCommandRemotely(command, testClientHost, testUser, "stopMaster_ij ");
        this.util.DEBUG(results);
    }

    int xFindServerPID(String serverHost, int serverPort) throws InterruptedException {
        if (this.masterServer != null) {
            return 0;
        }
        if (serverHost.equalsIgnoreCase("localhost")) {
            return 0;
        }
        int pid = -1;
        String p1 = "ps auxwww";
        String p2 = " | grep " + serverPort;
        String p3 = " | grep '.NetworkServerControl start -h '";
        String p4 = "";
        String p5 = " | grep -v grep";
        String p6 = " | grep -v ssh";
        String p7 = " | grep -v tcsh";
        String p8 = " | gawk '{ print $2 }'";
        String p9 = " | head -1";
        String command = p1 + p2 + p3 + p4 + p5 + p6 + p7 + ";";
        String result = this.runUserCommandRemotely(command, serverHost, testUser);
        this.util.DEBUG("xFindServerPID: '" + result + "'");
        command = p1 + p2 + p3 + p4 + p5 + p6 + p7 + p8 + p9 + ";";
        result = this.runUserCommandRemotely(command, serverHost, testUser);
        if (result == null) {
            this.util.DEBUG("xFindServerPID: Server process not found");
            return -1;
        }
        this.util.DEBUG("xFindServerPID: '" + result + "'");
        pid = Integer.parseInt(result.trim());
        this.util.DEBUG("xFindServerPID: " + pid);
        return pid;
    }

    void xStopServer(String serverHost, int serverPID) throws InterruptedException {
        if (serverPID == -1 || serverPID == 0) {
            this.util.DEBUG("Illegal PID");
            return;
        }
        String command = "kill " + serverPID;
        this.runUserCommandRemotely(command, serverHost, testUser, "xStopServer");
    }

    void verifySlave() throws Exception {
        this.util.DEBUG("BEGIN verifySlave " + slaveServerHost + ":" + slaveServerPort + "/" + slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb);
        if (replicationTest != null && simpleLoad) {
            this._verifyDatabase(slaveServerHost, slaveServerPort, slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb, simpleLoadTuples);
        }
        ClientDataSource ds = new ClientDataSource();
        ds.setDatabaseName(slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb);
        ds.setServerName(slaveServerHost);
        ds.setPortNumber(slaveServerPort);
        ds.setConnectionAttributes(this.useEncryption(false));
        Connection conn = ds.getConnection();
        this.simpleVerify(conn);
        conn.close();
        this.util.DEBUG("END   verifySlave");
    }

    void verifyMaster() throws Exception {
        this.util.DEBUG("BEGIN verifyMaster " + masterServerHost + ":" + masterServerPort + "/" + masterDatabasePath + FS + masterDbSubPath + FS + replicatedDb);
        if (replicationTest != null && simpleLoad) {
            this._verifyDatabase(masterServerHost, masterServerPort, masterDatabasePath + FS + masterDbSubPath + FS + replicatedDb, simpleLoadTuples);
        }
        ClientDataSource ds = new ClientDataSource();
        ds.setDatabaseName(masterDatabasePath + FS + masterDbSubPath + FS + replicatedDb);
        ds.setServerName(masterServerHost);
        ds.setPortNumber(masterServerPort);
        ds.setConnectionAttributes(this.useEncryption(false));
        Connection conn = ds.getConnection();
        this.simpleVerify(conn);
        conn.close();
        this.util.DEBUG("END   verifyMaster");
    }

    private void simpleVerify(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("select SCHEMAID, TABLENAME from sys.systables");
        while (rs.next()) {
            this.util.DEBUG(rs.getString(1) + " " + rs.getString(2));
        }
    }

    private void runSlaveVerificationCLient(String jvmVersion, String testClientHost, String dbName, String serverHost, int serverPort) throws Exception {
        this.util.DEBUG("runSlaveVerificationCLient");
        this.runTestOnSlave(replicationVerify, jvmVersion, testClientHost, serverHost, serverPort, dbName);
    }

    private void runMasterVerificationCLient(String jvmVersion, String testClientHost, String dbName, String serverHost, int serverPort) throws Exception {
        this.util.DEBUG("runMasterVerificationCLient");
        this.runTest(replicationVerify, jvmVersion, testClientHost, serverHost, serverPort, dbName);
    }

    String runUserCommand(String command, String testUser) {
        this.util.DEBUG("Execute '" + command + "'");
        String output = "";
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(command);
            output = this.processOutput(proc);
            int exitVal = proc.waitFor();
            this.util.DEBUG("ExitValue: " + exitVal);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return output;
    }

    private String runUserCommand(String command, String testUser, String id) {
        String ID = "runUserCommand " + id + " ";
        this.util.DEBUG("Execute '" + command + "'");
        String output = "";
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(command);
            output = this.processOutput(ID, proc);
            int exitVal = proc.waitFor();
            this.util.DEBUG("ExitValue: " + exitVal);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return output;
    }

    private void runUserCommandLocally(String command, String user_dir, String ID) {
        String shellCmd;
        this.util.DEBUG("");
        String debugId = "runUserCommandLocally " + ID + " ";
        this.util.DEBUG("+++ runUserCommandLocally " + command + " / " + user_dir);
        String tmp = "";
        this.util.DEBUG(debugId + command);
        String fullCmd = command;
        String[] envElements = null;
        String localCommand = shellCmd = fullCmd;
        this.util.DEBUG(debugId + "localCommand: " + localCommand);
        try {
            Process proc = Runtime.getRuntime().exec(localCommand, envElements, null);
            this.processDEBUGOutput(debugId + "pDo ", proc);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.util.DEBUG(debugId + "--- runUserCommandLocally ");
        this.util.DEBUG("");
    }

    private String runUserCommandRemotely(String command, String host, String testUser) throws InterruptedException {
        this.util.DEBUG("Execute '" + command + "' on '" + host + "'" + " as " + testUser);
        String localCommand = "/usr/bin/ssh -x -l " + testUser + " " + host + " " + command;
        return this.runUserCommand(localCommand, testUser);
    }

    private String runUserCommandRemotely(String command, String host, String testUser, String id) throws InterruptedException {
        String ID = "runUserCommandRemotely " + id + " ";
        this.util.DEBUG(ID + "Execute '" + command + "' on '" + host + "'" + " as " + testUser);
        String localCommand = "/usr/bin/ssh -x -l " + testUser + " " + host + " " + command;
        return this.runUserCommand(localCommand, testUser, ID);
    }

    private void runUserCommandInThread(String command, String testUser, String dbDir, String id) throws InterruptedException {
        this.util.DEBUG("");
        final String ID = "runUserCommandInThread " + id + " ";
        this.util.DEBUG(ID + "Execute '" + command + "'");
        this.util.DEBUG("+++ " + ID);
        String localCommand = command;
        this.util.DEBUG("runUserCommand: " + command);
        String[] commandElements = new String[]{command};
        final String[] envElements = new String[]{"CLASS_PATH=", "PATH=" + FS + "home" + FS + testUser + FS + "bin:$PATH"};
        String workingDirName = System.getProperty("user.dir");
        this.util.DEBUG("user.dir: " + workingDirName);
        String tmp = "";
        for (int i = 0; i < commandElements.length; ++i) {
            tmp = tmp + commandElements[i];
        }
        this.util.DEBUG("commandElements: " + tmp);
        final String fullCmd = tmp;
        tmp = "";
        for (int i = 0; i < envElements.length; ++i) {
            tmp = tmp + envElements[i] + " ";
        }
        this.util.DEBUG(ID + "envElements: " + tmp);
        final File workingDir = new File(workingDirName + FS + dbDir);
        this.util.DEBUG(ID + "workingDir: " + workingDirName + FS + dbDir);
        this.util.DEBUG(ID + "proc = Runtime.getRuntime().exec(commandElements,envElements,workingDir);");
        Thread cmdThread = new Thread(new Runnable(){

            public void run() {
                Process proc = null;
                try {
                    ReplicationRun.this.util.DEBUG(ID + "************** In run().");
                    proc = Runtime.getRuntime().exec(fullCmd, envElements, workingDir);
                    ReplicationRun.this.util.DEBUG(ID + "************** Done exec().");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.util.DEBUG(ID + "************** Do .start().");
        cmdThread.start();
        cmdThread.join();
        this.util.DEBUG(ID + "************** Done .join().");
        this.util.DEBUG(ID + "--- ");
        this.util.DEBUG("");
    }

    private void runUserCommandInThreadRemotely(String command, String host, String testUser, String dbDir, String id) throws InterruptedException {
        this.util.DEBUG("");
        final String ID = id + " runUserCommandInThreadRemotely ";
        this.util.DEBUG(ID + "+++ ");
        this.util.DEBUG(ID + "Execute '" + command + "' on '" + host + "'");
        this.util.DEBUG(ID + command + " @ " + host + " as " + testUser);
        final String[] envElements = new String[]{"CLASS_PATH=", "PATH=" + FS + "home" + FS + testUser + FS + "bin:$PATH"};
        String workingDirName = System.getProperty("user.dir");
        this.util.DEBUG(ID + "user.dir: " + workingDirName);
        String tmp = "";
        this.util.DEBUG(ID + "commandElements: " + tmp);
        String fullCmd = command;
        tmp = "";
        for (int i = 0; i < envElements.length; ++i) {
            tmp = tmp + envElements[i] + " ";
        }
        this.util.DEBUG(ID + "envElements: " + tmp);
        final File workingDir = new File(workingDirName + FS + dbDir);
        this.util.DEBUG(ID + "workingDir: " + workingDirName + FS + dbDir);
        this.util.DEBUG(ID + "Running command on non-local host " + host);
        String[] shEnvElements = new String[]{"setenv CLASS_PATH ", "setenv PATH " + FS + "home" + FS + testUser + FS + "bin:${PATH}"};
        String shellEnv = "";
        for (int i = 0; i < shEnvElements.length; ++i) {
            shellEnv = shellEnv + shEnvElements[i] + ";";
        }
        this.util.DEBUG(ID + "shellEnv: " + shellEnv);
        String shellCmd = "cd " + workingDirName + FS + dbDir + ";pwd;" + shellEnv + ";" + fullCmd;
        this.util.DEBUG(ID + "shellCmd: " + shellCmd);
        final String localCommand = "/usr/bin/ssh -x -l " + testUser + " -n " + host + " " + shellCmd;
        this.util.DEBUG(ID + "localCommand: " + localCommand);
        Thread serverThread = new Thread(new Runnable(){

            public void run() {
                Process proc = null;
                try {
                    ReplicationRun.this.util.DEBUG(ID + "************** In run().");
                    proc = Runtime.getRuntime().exec(localCommand, envElements, workingDir);
                    ReplicationRun.this.util.DEBUG(ID + "************** Done exec().");
                    ReplicationRun.this.processDEBUGOutput(ID, proc);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.util.DEBUG(ID + "************** Do .start(). ");
        serverThread.start();
        this.util.DEBUG(ID + "--- ");
        this.util.DEBUG("");
    }

    void initEnvironment() throws IOException {
        this.util.printDebug = System.getProperty("derby.tests.repltrace", "false").equalsIgnoreCase("true");
        this.util.DEBUG("printDebug: " + this.util.printDebug);
        this.util.DEBUG("*** ReplicationRun.initEnvironment -----------------------------------------");
        this.util.DEBUG("*** Properties -----------------------------------------");
        userDir = System.getProperty("user.dir");
        this.util.DEBUG("user.dir:          " + userDir);
        this.util.DEBUG("derby.system.home: " + System.getProperty("derby.system.home"));
        showSysinfo = true;
        this.util.DEBUG("showSysinfo: " + showSysinfo);
        testUser = null;
        this.util.DEBUG("testUser: " + testUser);
        masterServerHost = "localhost";
        this.util.DEBUG("masterServerHost: " + masterServerHost);
        masterServerPort = 1527;
        this.util.DEBUG("masterServerPort: " + masterServerPort);
        slaveServerHost = "localhost";
        this.util.DEBUG("slaveServerHost: " + slaveServerHost);
        slaveServerPort = 4527;
        this.util.DEBUG("slaveServerPort: " + slaveServerPort);
        slaveReplPort = 8888;
        this.util.DEBUG("slaveReplPort: " + slaveReplPort);
        testClientHost = "localhost";
        this.util.DEBUG("testClientHost: " + testClientHost);
        masterDatabasePath = userDir;
        this.util.DEBUG("masterDatabasePath: " + masterDatabasePath);
        slaveDatabasePath = userDir;
        this.util.DEBUG("slaveDatabasePath: " + slaveDatabasePath);
        replicatedDb = "wombat";
        this.util.DEBUG("replicatedDb: " + replicatedDb);
        bootLoad = null;
        this.util.DEBUG("bootLoad: " + bootLoad);
        freezeDB = null;
        this.util.DEBUG("freezeDB: " + freezeDB);
        unFreezeDB = null;
        this.util.DEBUG("unFreezeDB: " + unFreezeDB);
        simpleLoad = System.getProperty("derby.tests.replSimpleLoad", "true").equalsIgnoreCase("true");
        this.util.DEBUG("simpleLoad: " + simpleLoad);
        sqlLoadInit = null;
        this.util.DEBUG("sqlLoadInit: " + sqlLoadInit);
        specialTestingJar = null;
        this.util.DEBUG("specialTestingJar: " + specialTestingJar);
        jvmVersion = System.getProperty("java.home") + FS + "lib";
        this.util.DEBUG("jvmVersion: " + jvmVersion);
        masterJvmVersion = null;
        if (masterJvmVersion == null) {
            masterJvmVersion = jvmVersion;
        }
        this.util.DEBUG("masterJvmVersion: " + masterJvmVersion);
        slaveJvmVersion = null;
        if (slaveJvmVersion == null) {
            slaveJvmVersion = jvmVersion;
        }
        this.util.DEBUG("slaveJvmVersion: " + slaveJvmVersion);
        this.classPath = System.getProperty("java.class.path");
        this.util.DEBUG("classPath: " + this.classPath);
        this.util.DEBUG("derbyVersion: " + derbyVersion);
        derbyMasterVersion = null;
        if (derbyMasterVersion == null) {
            derbyMasterVersion = derbyVersion;
        }
        this.util.DEBUG("derbyMasterVersion: " + derbyMasterVersion);
        derbySlaveVersion = null;
        if (derbySlaveVersion == null) {
            derbySlaveVersion = derbyVersion;
        }
        this.util.DEBUG("derbySlaveVersion: " + derbySlaveVersion);
        String derbyTestingJar = derbyVersion + FS + "derbyTesting.jar";
        if (specialTestingJar != null) {
            derbyTestingJar = specialTestingJar;
        }
        this.util.DEBUG("derbyTestingJar: " + derbyTestingJar);
        junit_jar = derbyVersion + FS + "junit.jar";
        this.util.DEBUG("junit_jar: " + junit_jar);
        test_jars = derbyTestingJar + PS + junit_jar;
        this.util.DEBUG("test_jars: " + test_jars);
        sleepTime = 15000L;
        this.util.DEBUG("sleepTime: " + sleepTime);
        runUnReplicated = false;
        this.util.DEBUG("runUnReplicated: " + runUnReplicated);
        localEnv = false;
        this.util.DEBUG("localEnv: " + localEnv);
        derbyProperties = "derby.infolog.append=true" + LF + "derby.drda.logConnections=true" + LF + "derby.drda.traceAll=true" + LF;
        this.util.DEBUG("--------------------------------------------------------");
        masterPreRepl = null;
        masterPostRepl = null;
        slavePreSlave = null;
        masterPostSlave = null;
        slavePostSlave = null;
        this.util.DEBUG("--------------------------------------------------------");
        tuplesToInsertPerf = 10000;
        commitFreq = 1000;
        this.util.DEBUG("--------------------------------------------------------");
        this.util.DEBUG("--------------------------------------------------------");
    }

    void initMaster(String host, String dbName) throws Exception {
        this.util.DEBUG("initMaster");
        String results = null;
        if (host.equalsIgnoreCase("localhost") || localEnv) {
            String dir = masterDatabasePath + FS + masterDbSubPath;
            this.util.mkDirs(dir);
            this.util.cleanDir(dir, false);
            dir = slaveDatabasePath + FS + slaveDbSubPath;
            this.util.mkDirs(dir);
            this.util.cleanDir(dir, false);
        } else {
            String command = "cd " + masterDatabasePath + FS + masterDbSubPath + ";" + " rm -rf " + dbName + " derby.log ij_master;" + " rm Server*.trace;" + " ls -al;" + " cd " + slaveDatabasePath + FS + slaveDbSubPath + ";" + " rm -rf " + dbName + " derby.log ij_slave;" + " rm Server*.trace;" + " ls -al;";
            results = this.runUserCommandRemotely(command, host, testUser, "initMaster ");
        }
        this.util.DEBUG(results);
    }

    private void removeSlaveDBfiles(String host, String dbName) throws InterruptedException {
        String command = "cd " + slaveDatabasePath + FS + slaveDbSubPath + ";" + " rm -f " + dbName + FS + "seg0" + FS + "* ;" + " ls -al test test/seg0";
        String results = this.runUserCommandRemotely(command, host, testUser, "removeSlaveDBfiles ");
        this.util.DEBUG(results);
    }

    void initSlave(String host, String clientVM, String dbName) throws Exception {
        this.util.DEBUG("initSlave");
        String command = "cd " + slaveDatabasePath + FS + slaveDbSubPath + ";" + " rm -rf " + dbName + " ij_slave;" + " cp -r " + masterDatabasePath + FS + masterDbSubPath + FS + dbName + "/ .;" + " ls -al";
        String results = null;
        if (host.equalsIgnoreCase("localhost") || localEnv) {
            String slaveDir = slaveDatabasePath + FS + slaveDbSubPath;
            String slaveDb = slaveDatabasePath + FS + slaveDbSubPath + FS + dbName;
            String masterDb = masterDatabasePath + FS + masterDbSubPath + FS + dbName;
            this.util.copyDir(masterDb, slaveDb);
        } else {
            results = this.runUserCommandRemotely(command, host, testUser, "initSlave ");
        }
        this.util.DEBUG(results);
    }

    void restartServer(String serverVM, String serverVersion, String serverHost, String interfacesToListenOn, int serverPort, String dbSubDirPath) throws Exception {
        this.stopServer(serverVM, serverVersion, serverHost, serverPort);
        this.startServer(serverVM, serverVersion, serverHost, interfacesToListenOn, serverPort, dbSubDirPath);
    }

    NetworkServerControl startServer(String serverVM, String serverVersion, String serverHost, String interfacesToListenOn, int serverPort, String dbSubDirPath) throws Exception {
        this.util.DEBUG("");
        final String debugId = "startServer@" + serverHost + ":" + serverPort + " ";
        this.util.DEBUG(debugId + "+++ StartServer " + serverVM + " / " + serverVersion);
        String serverClassPath = serverVersion + FS + "derby.jar" + PS + serverVersion + FS + "derbynet.jar";
        if (serverHost.equals("localhost")) {
            serverClassPath = this.classPath;
        }
        String command = "start";
        String securityOption = "";
        securityOption = "-noSecurityManager";
        String workingDirName = userDir + FS + dbSubDirPath;
        String[] commandElements = new String[]{BaseTestCase.getJavaExecutableName(), " -Dderby.system.home=" + workingDirName, " -Dderby.infolog.append=true", " -cp ", serverClassPath, " org.apache.derby.drda.NetworkServerControl", " " + command, " -h ", interfacesToListenOn, " -p ", serverPort + "", " " + securityOption};
        String[] envElements = new String[]{"CLASS_PATH=" + serverClassPath, "PATH=" + serverVM + FS + ".." + FS + "bin"};
        if (serverHost.equals("localhost")) {
            envElements = null;
        }
        String tmp = "";
        for (int i = 0; i < commandElements.length; ++i) {
            tmp = tmp + commandElements[i];
        }
        this.util.DEBUG(debugId + "commandElements: " + tmp);
        String fullCmd = tmp;
        tmp = "";
        if (envElements != null) {
            for (int i = 0; i < envElements.length; ++i) {
                tmp = tmp + envElements[i] + " ";
            }
        }
        this.util.DEBUG(debugId + "envElements:    " + tmp);
        File workingDir = new File(workingDirName);
        if (serverHost.equalsIgnoreCase("localhost") || localEnv) {
            // empty if block
        }
        String shellCmd = null;
        if (serverHost.equalsIgnoreCase("localhost")) {
            this.util.DEBUG(debugId + "Starting server on localhost " + serverHost);
            shellCmd = fullCmd;
        } else {
            this.util.DEBUG(debugId + "Starting server on non-local host " + serverHost);
            String[] shEnvElements = new String[]{"setenv CLASS_PATH " + serverClassPath, "setenv PATH " + serverVM + FS + ".." + FS + "bin:${PATH}"};
            String shellEnv = "";
            for (int i = 0; i < shEnvElements.length; ++i) {
                shellEnv = shellEnv + shEnvElements[i] + ";";
            }
            this.util.DEBUG(debugId + "shellEnv: " + shellEnv);
            shellCmd = "cd " + workingDirName + ";pwd;" + shellEnv + ";" + fullCmd;
            this.util.DEBUG(debugId + "shellCmd: " + shellCmd);
            shellCmd = "/usr/bin/ssh -x -l " + testUser + " -n " + serverHost + " " + shellCmd;
        }
        final String localCommand = shellCmd;
        this.util.DEBUG(debugId + "localCommand: " + localCommand);
        final String[] fEnvElements = envElements;
        Thread serverThread = new Thread(new Runnable(){

            public void run() {
                Process proc = null;
                try {
                    ReplicationRun.this.util.DEBUG(debugId + "************** In run().");
                    proc = Runtime.getRuntime().exec(localCommand, fEnvElements, null);
                    ReplicationRun.this.util.DEBUG(debugId + "************** Done exec().");
                    ReplicationRun.this.processDEBUGOutput(debugId + "pDo ", proc);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.util.DEBUG(debugId + "************** Do .start().");
        serverThread.start();
        this.pingServer(serverHost, serverPort, 150);
        this.util.DEBUG(debugId + "--- StartServer ");
        this.util.DEBUG("");
        return null;
    }

    private NetworkServerControl startServer_direct(String serverHost, String interfacesToListenOn, int serverPort, String fullDbDirPath, String securityOption) throws Exception {
        this.util.DEBUG("startServer_direct " + serverHost + " " + interfacesToListenOn + " " + serverPort + " " + fullDbDirPath);
        ReplicationRun.assertTrue((String)("Attempt to start server on non-localhost: " + serverHost), (boolean)serverHost.equalsIgnoreCase("localhost"));
        System.setProperty("derby.system.home", fullDbDirPath);
        System.setProperty("user.dir", fullDbDirPath);
        NetworkServerControl server = new NetworkServerControl(InetAddress.getByName(interfacesToListenOn), serverPort);
        server.start(null);
        this.pingServer(serverHost, serverPort, 150);
        Properties sp = server.getCurrentProperties();
        sp.setProperty("noSecurityManager", securityOption.equalsIgnoreCase("-noSecurityManager") ? "true" : "false");
        return server;
    }

    void killMaster(String masterServerHost, int masterServerPort) throws InterruptedException {
        this.util.DEBUG("killMaster: " + masterServerHost + ":" + masterServerPort);
        if (masterServerHost.equals("localhost")) {
            this.stopServer(masterJvmVersion, derbyMasterVersion, masterServerHost, masterServerPort);
        } else {
            int pid = this.xFindServerPID(masterServerHost, masterServerPort);
            this.xStopServer(masterServerHost, pid);
        }
    }

    void killSlave(String slaveServerHost, int slaveServerPort) throws InterruptedException {
        this.util.DEBUG("killSlave: " + slaveServerHost + ":" + slaveServerPort);
        if (slaveServerHost.equals("localhost")) {
            this.stopServer(slaveJvmVersion, derbySlaveVersion, slaveServerHost, slaveServerPort);
        } else {
            int pid = this.xFindServerPID(slaveServerHost, slaveServerPort);
            this.xStopServer(slaveServerHost, pid);
        }
    }

    void destroySlaveDB(String slaveServerHost) throws InterruptedException {
        this.removeSlaveDBfiles(slaveServerHost, replicatedDb);
    }

    void stopServer(String serverVM, String serverVersion, String serverHost, int serverPort) {
        this.util.DEBUG("");
        String debugId = "stopServer@" + serverHost + ":" + serverPort + " ";
        this.util.DEBUG("+++ stopServer " + serverVM + " / " + serverVersion + " " + debugId);
        String serverJvm = BaseTestCase.getJavaExecutableName();
        String serverClassPath = serverVersion + FS + "derby.jar" + PS + serverVersion + FS + "derbynet.jar";
        if (serverHost.equals("localhost")) {
            serverClassPath = this.classPath;
        }
        String command = "shutdown";
        int port = serverPort;
        String[] commandElements = new String[]{serverJvm, " -Dderby.infolog.append=true", " -cp ", serverClassPath, " org.apache.derby.drda.NetworkServerControl", " " + command, " -h " + serverHost, " -p ", serverPort + ""};
        String[] envElements = new String[]{"CLASS_PATH=" + serverClassPath, "PATH=" + serverVM + FS + ".." + FS + "bin"};
        if (serverHost.equals("localhost")) {
            envElements = null;
        }
        String workingDirName = System.getProperty("user.dir");
        this.util.DEBUG(debugId + "user.dir: " + workingDirName);
        String tmp = "";
        for (int i = 0; i < commandElements.length; ++i) {
            tmp = tmp + commandElements[i];
        }
        this.util.DEBUG(debugId + "commandElements: " + tmp);
        String fullCmd = tmp;
        tmp = "";
        if (envElements != null) {
            for (int i = 0; i < envElements.length; ++i) {
                tmp = tmp + envElements[i] + " ";
            }
        }
        this.util.DEBUG(debugId + "envElements: " + tmp);
        File workingDir = new File(workingDirName);
        String shellCmd = null;
        if (serverHost.equalsIgnoreCase("localhost")) {
            this.util.DEBUG(debugId + "Stopping server on localhost " + serverHost);
            shellCmd = fullCmd;
        } else {
            this.util.DEBUG(debugId + "Stopping server on non-local host " + serverHost);
            String[] shEnvElements = new String[]{"setenv CLASS_PATH " + serverClassPath, "setenv PATH " + serverVM + FS + ".." + FS + "bin:${PATH}"};
            String shellEnv = "";
            for (int i = 0; i < shEnvElements.length; ++i) {
                shellEnv = shellEnv + shEnvElements[i] + ";";
            }
            this.util.DEBUG(debugId + "shellEnv: " + shellEnv);
            shellCmd = "pwd;" + shellEnv + ";" + fullCmd;
            this.util.DEBUG(debugId + "shellCmd: " + shellCmd);
            shellCmd = "/usr/bin/ssh -x -l " + testUser + " -n " + serverHost + " " + shellCmd;
        }
        String localCommand = shellCmd;
        this.util.DEBUG(debugId + "localCommand: " + localCommand);
        try {
            Process proc = Runtime.getRuntime().exec(localCommand, envElements, workingDir);
            this.processDEBUGOutput(debugId + "pDo ", proc);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.util.DEBUG(debugId + "--- stopServer ");
        this.util.DEBUG("");
    }

    private void processOutput(String id, Process proc, PrintWriter out) throws Exception {
        InputStream serveInputStream = proc.getInputStream();
        InputStream serveErrorStream = proc.getErrorStream();
        InputStreamReader isr = new InputStreamReader(serveInputStream);
        InputStreamReader esr = new InputStreamReader(serveErrorStream);
        BufferedReader bir = new BufferedReader(isr);
        BufferedReader ber = new BufferedReader(esr);
        String line = null;
        this.util.DEBUG(id + "---- out:", out);
        while ((line = bir.readLine()) != null) {
            out.println(id + line);
        }
        this.util.DEBUG(id + "---- err:", out);
        while ((line = ber.readLine()) != null) {
            out.println(id + line);
        }
        this.util.DEBUG(id + "----     ", out);
    }

    private String processOutput(Process proc) throws Exception {
        InputStream serveInputStream = proc.getInputStream();
        InputStream serveErrorStream = proc.getErrorStream();
        InputStreamReader isr = new InputStreamReader(serveInputStream);
        InputStreamReader esr = new InputStreamReader(serveErrorStream);
        BufferedReader bir = new BufferedReader(isr);
        BufferedReader ber = new BufferedReader(esr);
        String line = null;
        String result = null;
        this.util.DEBUG("---- out:");
        while ((line = bir.readLine()) != null) {
            this.util.DEBUG(line);
            if (result == null) {
                result = line;
                continue;
            }
            result = result + LF + line;
        }
        this.util.DEBUG("---- err:");
        while ((line = ber.readLine()) != null) {
            this.util.DEBUG(line);
            if (result == null) {
                result = line;
                continue;
            }
            result = result + LF + line;
        }
        this.util.DEBUG("----     ");
        return result;
    }

    private String processOutput(String id, Process proc) throws Exception {
        InputStream serveInputStream = proc.getInputStream();
        InputStream serveErrorStream = proc.getErrorStream();
        InputStreamReader isr = new InputStreamReader(serveInputStream);
        InputStreamReader esr = new InputStreamReader(serveErrorStream);
        BufferedReader bir = new BufferedReader(isr);
        BufferedReader ber = new BufferedReader(esr);
        String line = null;
        String result = null;
        this.util.DEBUG(id + "---- out:");
        while ((line = bir.readLine()) != null) {
            this.util.DEBUG(id + line);
            result = result + LF + line;
        }
        this.util.DEBUG(id + "---- err:");
        while ((line = ber.readLine()) != null) {
            this.util.DEBUG(id + line);
            result = result + LF + line;
        }
        this.util.DEBUG(id + "----     ");
        return result;
    }

    private void processDEBUGOutput(String id, Process proc) throws Exception {
        InputStream serveInputStream = proc.getInputStream();
        InputStream serveErrorStream = proc.getErrorStream();
        InputStreamReader isr = new InputStreamReader(serveInputStream);
        InputStreamReader esr = new InputStreamReader(serveErrorStream);
        BufferedReader bir = new BufferedReader(isr);
        BufferedReader ber = new BufferedReader(esr);
        String line = null;
        this.util.DEBUG(id + "---- out:");
        while ((line = bir.readLine()) != null) {
            this.util.DEBUG(id + line);
        }
        this.util.DEBUG(id + "---- err:");
        while ((line = ber.readLine()) != null) {
            this.util.DEBUG(id + line);
        }
        this.util.DEBUG(id + "----     ");
    }

    private void processDEBUGOutput(String id, Process proc, PrintWriter out) throws Exception {
        InputStream serveInputStream = proc.getInputStream();
        InputStream serveErrorStream = proc.getErrorStream();
        InputStreamReader isr = new InputStreamReader(serveInputStream);
        InputStreamReader esr = new InputStreamReader(serveErrorStream);
        BufferedReader bir = new BufferedReader(isr);
        BufferedReader ber = new BufferedReader(esr);
        String line = null;
        this.util.DEBUG(id + "---- out:", out);
        while ((line = bir.readLine()) != null) {
            out.println(id + line);
        }
        this.util.DEBUG(id + "---- err:", out);
        while ((line = ber.readLine()) != null) {
            out.println(id + line);
        }
        this.util.DEBUG(id + "----     ", out);
    }

    private void pingServer(String hostName, int port, int iterations) throws Exception {
        this.util.DEBUG("+++ pingServer");
        this.ping(new NetworkServerControl(InetAddress.getByName(hostName), port), iterations);
        this.util.DEBUG("--- pingServer");
    }

    private void ping(NetworkServerControl controller, int iterations) throws Exception {
        Exception finalException = null;
        for (int i = 0; i < iterations; ++i) {
            try {
                controller.ping();
                this.util.DEBUG("Server came up in less than " + i + " * " + PINGSERVER_SLEEP_TIME_MILLIS + "ms.");
                return;
            }
            catch (Exception e) {
                finalException = e;
                Thread.sleep(PINGSERVER_SLEEP_TIME_MILLIS);
                continue;
            }
        }
        String msg = "Could not ping in " + iterations + " * " + PINGSERVER_SLEEP_TIME_MILLIS + "ms.: " + finalException.getMessage();
        this.util.DEBUG(msg);
        finalException.printStackTrace();
        throw new Exception(msg);
    }

    void startOptionalLoad(Load load, String dbSubPath, String serverHost, int serverPort) throws Exception {
        this.startLoad(load.load, dbSubPath, load.database, load.existingDB, load.clientHost, serverHost, serverPort);
    }

    void startLoad(String load, String dbSubPath, String database, boolean existingDB, String testClientHost, String serverHost, int serverPort) throws Exception {
        this.util.DEBUG("run load " + load + " on client " + testClientHost + " against server " + serverHost + ":" + serverPort + " using DB  " + database + "[" + existingDB + "]");
        if (load == null) {
            this.util.DEBUG("No load supplied!");
            return;
        }
        if (!existingDB) {
            String URL2 = this.masterURL(database) + ";create=true";
            String ijClassPath = derbyVersion + FS + "derbyclient.jar" + PS + derbyVersion + FS + "derbyTesting.jar" + PS + derbyVersion + FS + "derbytools.jar";
            if (serverHost.equals("localhost")) {
                ijClassPath = this.classPath;
            }
            String clientJvm = BaseTestCase.getJavaExecutableName();
            String command = "rm -rf /" + masterDatabasePath + FS + dbSubPath + FS + database + ";" + clientJvm + " -Dij.driver=" + DRIVER_CLASS_NAME + " -Dij.connection.create" + database + "=\"" + URL2 + "\"" + " -classpath " + ijClassPath + " org.apache.derby.tools.ij" + " " + sqlLoadInit;
            String results = this.runUserCommandRemotely(command, testClientHost, testUser, "Create_" + database);
        }
        this.runLoad(load, jvmVersion, testClientHost, serverHost, serverPort, dbSubPath + FS + database);
    }

    void makeReadyForReplication() throws Exception {
        this.cleanAllTestHosts();
        this.initEnvironment();
        this.initMaster(masterServerHost, replicatedDb);
        this.masterServer = this.startServer(masterJvmVersion, derbyMasterVersion, masterServerHost, ALL_INTERFACES, masterServerPort, masterDbSubPath);
        this.slaveServer = this.startServer(slaveJvmVersion, derbySlaveVersion, slaveServerHost, ALL_INTERFACES, slaveServerPort, slaveDbSubPath);
        this.startServerMonitor(slaveServerHost);
        this.bootMasterDatabase(jvmVersion, masterDatabasePath + FS + masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, null);
        this.initSlave(slaveServerHost, jvmVersion, replicatedDb);
        this.startSlave(jvmVersion, replicatedDb, slaveServerHost, slaveServerPort, slaveServerHost, slaveReplPort, testClientHost);
        this.startMaster(jvmVersion, replicatedDb, masterServerHost, masterServerPort, masterServerHost, slaveServerPort, slaveServerHost, slaveReplPort);
    }

    void cleanAllTestHosts() {
        this.util.DEBUG("************************** cleanAllTestHosts() Not yet implemented");
    }

    protected void assertSqlStateSlaveConn(String expected) throws Exception {
        boolean verified = false;
        for (int i = 0; i < 10; ++i) {
            if (this.startSlaveException != null) {
                if (this.startSlaveException instanceof SQLException) {
                    BaseJDBCTestCase.assertSQLState("Unexpexted SQL State", expected, (SQLException)this.startSlaveException);
                    verified = true;
                    break;
                }
                throw this.startSlaveException;
            }
            Thread.sleep(500L);
        }
        if (!verified) {
            ReplicationRun.fail((String)("Attempt to start slave hangs. Expected SQL state " + expected));
        }
    }

    void assertException(SQLException se, String expectedSqlState) {
        if (se == null) {
            this.util.DEBUG("Got 'null' exception, expected '" + expectedSqlState + "'");
            ReplicationRun.assertTrue((String)("Expected exception: " + expectedSqlState + " got: 'null' exception"), (expectedSqlState == null ? 1 : 0) != 0);
            return;
        }
        int ec = se.getErrorCode();
        String ss = se.getSQLState();
        String msg = "Got " + ec + " " + ss + " " + se.getMessage() + ". Expected " + expectedSqlState;
        this.util.DEBUG(msg);
        if (expectedSqlState != null) {
            ReplicationRun.assertTrue((String)msg, (boolean)ss.equals(expectedSqlState));
        } else {
            ReplicationRun.assertTrue((String)msg, (boolean)false);
        }
    }

    void _testInsertUpdateDeleteOnMaster(String serverHost, int serverPort, String dbPath, int _noTuplesToInsert) throws SQLException {
        this.util.DEBUG("_testInsertUpdateDeleteOnMaster: " + serverHost + ":" + serverPort + "/" + dbPath + " " + _noTuplesToInsert);
        ClientDataSource ds = new ClientDataSource();
        ds.setDatabaseName(dbPath);
        ds.setServerName(serverHost);
        ds.setPortNumber(serverPort);
        ds.setConnectionAttributes(this.useEncryption(false));
        Connection conn = ds.getConnection();
        PreparedStatement ps = conn.prepareStatement("create table t(i integer primary key, s varchar(64))");
        ps.execute();
        ps = conn.prepareStatement("insert into t values (?,?)");
        for (int i = 0; i < _noTuplesToInsert; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "dilldall" + i);
            ps.execute();
            if (i % 10000 != 0) continue;
            conn.commit();
        }
        this._verify(conn, _noTuplesToInsert);
        conn.close();
    }

    void _verifyDatabase(String serverHost, int serverPort, String dbPath, int _noTuplesInserted) throws SQLException {
        this.util.DEBUG("_verifyDatabase: " + serverHost + ":" + serverPort + "/" + dbPath);
        ClientDataSource ds = new ClientDataSource();
        ds.setDatabaseName(dbPath);
        ds.setServerName(serverHost);
        ds.setPortNumber(serverPort);
        ds.setConnectionAttributes(this.useEncryption(false));
        Connection conn = ds.getConnection();
        this._verify(conn, _noTuplesInserted);
        conn.close();
    }

    void _verify(Connection conn, int _noTuplesInserted) throws SQLException {
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("select count(*) from t");
        rs.next();
        int count = rs.getInt(1);
        rs = s.executeQuery("select max(i) from t");
        rs.next();
        int max = rs.getInt(1);
        this.util.DEBUG("_verify: " + count + "/" + _noTuplesInserted + " " + max + "/" + (_noTuplesInserted - 1));
        ReplicationRun.assertEquals((String)("Expected " + _noTuplesInserted + " tuples, got " + count + "."), (int)_noTuplesInserted, (int)count);
        ReplicationRun.assertEquals((String)("Expected " + (_noTuplesInserted - 1) + " max, got " + max + "."), (int)(_noTuplesInserted - 1), (int)max);
    }

    Connection getConnection(String serverHost, int serverPort, String databasePath, String dbSubPath, String replicatedDb) throws SQLException {
        String db = databasePath + FS + dbSubPath + FS + replicatedDb;
        String connectionURL = "jdbc:derby://" + serverHost + ":" + serverPort + "/" + db;
        this.util.DEBUG(connectionURL);
        return DriverManager.getConnection(connectionURL);
    }

    String masterURL(String dbName) {
        return "jdbc:derby://" + masterServerHost + ":" + masterServerPort + "/" + masterDatabasePath + FS + masterDbSubPath + FS + dbName + this.useEncryption(false);
    }

    String masterLoadURL(String dbSubPath) {
        return "jdbc:derby://" + masterServerHost + ":" + masterServerPort + "/" + masterDatabasePath + FS + dbSubPath + this.useEncryption(false);
    }

    String slaveURL(String dbName) {
        return "jdbc:derby://" + slaveServerHost + ":" + slaveServerPort + "/" + slaveDatabasePath + FS + slaveDbSubPath + FS + dbName + this.useEncryption(false);
    }

    SQLException stopSlave(String slaveServerHost, int slaveServerPort, String slaveDatabasePath, String replicatedDb, boolean masterServerAlive) throws Exception {
        return this.stopSlave(slaveServerHost, slaveServerPort, slaveDatabasePath, slaveDbSubPath, replicatedDb, masterServerAlive);
    }

    SQLException stopSlave(String slaveServerHost, int slaveServerPort, String slaveDatabasePath, String subPath, String replicatedDb, boolean masterServerAlive) throws Exception {
        this.util.DEBUG("stopSlave");
        String dbPath = slaveDatabasePath + FS + subPath + FS + replicatedDb;
        String connectionURL = "jdbc:derby://" + slaveServerHost + ":" + slaveServerPort + "/" + dbPath + ";stopSlave=true" + this.useEncryption(false);
        if (masterServerAlive) {
            try {
                Connection conn = DriverManager.getConnection(connectionURL);
                conn.close();
                return null;
            }
            catch (SQLException se) {
                return se;
            }
        }
        SQLException gotEx = null;
        int tries = 20;
        while (tries-- > 0) {
            gotEx = null;
            try {
                DriverManager.getConnection(connectionURL);
                ReplicationRun.fail((String)"Unexpectedly connected");
            }
            catch (SQLException se) {
                if (se.getSQLState().equals(SLAVE_OPERATION_DENIED_WHILE_CONNECTED)) {
                    gotEx = se;
                    this.util.DEBUG("got SLAVE_OPERATION_DENIED_WHILE_CONNECTED, sleep");
                    Thread.sleep(1000L);
                    continue;
                }
                if (se.getSQLState().equals(REPLICATION_SLAVE_SHUTDOWN_OK)) {
                    gotEx = se;
                    this.util.DEBUG("got REPLICATION_SLAVE_SHUTDOWN_OK, sleep..");
                    Thread.sleep(1000L);
                    continue;
                }
                if (se.getSQLState().equals(REPLICATION_DB_NOT_BOOTED)) {
                    this.util.DEBUG("Got REPLICATION_DB_NOT_BOOTED as expected");
                    break;
                }
                gotEx = se;
                break;
            }
        }
        if (gotEx != null) {
            throw gotEx;
        }
        return null;
    }

    class Load {
        String load = null;
        String database = null;
        boolean existingDB = false;
        String clientHost = null;

        Load(String load, String database, boolean existingDB, String clientHost) {
            this.load = load;
            this.database = database;
            this.existingDB = existingDB;
            this.clientHost = clientHost;
        }

        Load(String id, Properties testRunProperties) {
            ReplicationRun.this.util.DEBUG("Load(): " + id);
            String pid = "test." + id;
            if (testRunProperties.getProperty(pid, "false").equalsIgnoreCase("false")) {
                ReplicationRun.this.util.DEBUG(pid + " Not defined or set to false!");
            } else {
                pid = "test." + id + ".load";
                this.load = testRunProperties.getProperty(pid, "org.apache.derbyTesting.functionTests.tests.replicationTests.DefaultLoad");
                ReplicationRun.this.util.DEBUG(pid + ": " + this.load);
                pid = "test." + id + ".database";
                this.database = testRunProperties.getProperty(pid, id);
                ReplicationRun.this.util.DEBUG(pid + ": " + this.database);
                pid = "test." + id + ".existingDB";
                this.existingDB = testRunProperties.getProperty(pid, "false").equalsIgnoreCase("true");
                ReplicationRun.this.util.DEBUG(pid + ": " + this.existingDB);
                pid = "test." + id + ".clientHost";
                this.clientHost = testRunProperties.getProperty(pid, testClientHost);
                ReplicationRun.this.util.DEBUG(pid + ": " + this.clientHost);
            }
        }
    }

    class State {
        String testPreStartedMasterServer = null;
        boolean testPreStartedMasterServerReturn = false;
        String testPreStartedSlaveServer = null;
        boolean testPreStartedSlaveServerReturn = false;
        String testPreStartedMaster = null;
        boolean testPreStartedMasterReturn = false;
        String testPreInitSlave = null;
        boolean testPreInitSlaveReturn = false;
        String testPreStartedSlave = null;
        boolean testPreStartedSlaveReturn = false;
        String testPostStartedMasterAndSlave = null;
        boolean testPostStartedMasterAndSlaveReturn = false;
        String testPreStoppedMaster = null;
        boolean testPreStoppedMasterReturn = false;
        String testPreStoppedMasterServer = null;
        boolean testPreStoppedMasterServerReturn = false;
        String testPreStoppedSlave = null;
        boolean testPreStoppedSlaveReturn = false;
        String testPreStoppedSlaveServer = null;
        boolean testPreStoppedSlaveServerReturn = false;
        String testPostStoppedSlave = null;
        boolean testPostStoppedSlaveReturn = false;
        String testPostStoppedSlaveServer = null;
        boolean testPostStoppedSlaveServerReturn = false;

        State() {
        }

        void initEnvironment(Properties cp) {
            this.testPreStartedMasterServer = cp.getProperty("test.PreStartedMasterServer", null);
            this.testPreStartedMasterServerReturn = cp.getProperty("test.PreStartedMasterServer.return", "false").equalsIgnoreCase("true");
            ReplicationRun.this.util.DEBUG("testPreStartedMasterServer:" + this.testPreStartedMasterServer + FS + this.testPreStartedMasterServerReturn);
            this.testPreStartedSlaveServer = cp.getProperty("test.PreStartedSlaveServer", null);
            this.testPreStartedSlaveServerReturn = cp.getProperty("test.PreStartedSlaveServer.return", "false").equalsIgnoreCase("true");
            ReplicationRun.this.util.DEBUG("testPreStartedSlaveServer:" + this.testPreStartedSlaveServer + FS + this.testPreStartedSlaveServerReturn);
            this.testPreInitSlave = cp.getProperty("test.PreInitSlave", null);
            this.testPreInitSlaveReturn = cp.getProperty("test.PreInitSlave.return", "false").equalsIgnoreCase("true");
            ReplicationRun.this.util.DEBUG("testPreInitSlave:" + this.testPreInitSlave + FS + this.testPreInitSlaveReturn);
            this.testPreStartedMaster = cp.getProperty("test.PreStartedMaster", null);
            this.testPreStartedMasterReturn = cp.getProperty("test.PreStartedMaster.return", "false").equalsIgnoreCase("true");
            ReplicationRun.this.util.DEBUG("testPreStartedMaster:" + this.testPreStartedMaster + FS + this.testPreStartedMasterReturn);
            this.testPreStartedSlave = cp.getProperty("test.PreStartedSlave", null);
            this.testPreStartedSlaveReturn = cp.getProperty("test.PreStartedSlave.return", "false").equalsIgnoreCase("true");
            ReplicationRun.this.util.DEBUG("testPreStartedSlave:" + this.testPreStartedSlave + FS + this.testPreStartedSlaveReturn);
            this.testPostStartedMasterAndSlave = cp.getProperty("test.PostStartedMasterAndSlave", null);
            this.testPostStartedMasterAndSlaveReturn = cp.getProperty("test.PostStartedMasterAndSlave.return", "false").equalsIgnoreCase("true");
            ReplicationRun.this.util.DEBUG("testPostStartedMasterAndSlave:" + this.testPostStartedMasterAndSlave + FS + this.testPostStartedMasterAndSlaveReturn);
            this.testPreStoppedMaster = cp.getProperty("test.PreStoppedMaster", null);
            this.testPreStoppedMasterReturn = cp.getProperty("test.PreStoppedMaster.return", "false").equalsIgnoreCase("true");
            ReplicationRun.this.util.DEBUG("testPreStoppedMaster:" + this.testPreStoppedMaster + FS + this.testPreStoppedMasterReturn);
            this.testPreStoppedMasterServer = cp.getProperty("test.PreStoppedMasterServer", null);
            this.testPreStoppedMasterServerReturn = cp.getProperty("test.PreStoppedMasterServer.return", "false").equalsIgnoreCase("true");
            ReplicationRun.this.util.DEBUG("testPreStoppedMasterServer:" + this.testPreStoppedMasterServer + FS + this.testPreStoppedMasterServerReturn);
            this.testPreStoppedSlave = cp.getProperty("test.PreStoppedSlave", null);
            this.testPreStoppedSlaveReturn = cp.getProperty("test.PreStoppedSlave.return", "false").equalsIgnoreCase("true");
            ReplicationRun.this.util.DEBUG("testPreStoppedSlave:" + this.testPreStoppedSlave + FS + this.testPreStoppedSlaveReturn);
            this.testPostStoppedSlave = cp.getProperty("test.PostStoppedSlave", null);
            this.testPostStoppedSlaveReturn = cp.getProperty("test.PostStoppedSlave.return", "false").equalsIgnoreCase("true");
            ReplicationRun.this.util.DEBUG("testPostStoppedSlave:" + this.testPostStoppedSlave + FS + this.testPostStoppedSlaveReturn);
            this.testPostStoppedSlaveServer = cp.getProperty("test.PostStoppedSlaveServer", null);
            this.testPostStoppedSlaveServerReturn = cp.getProperty("test.PostStoppedSlaveServer.return", "false").equalsIgnoreCase("true");
            ReplicationRun.this.util.DEBUG("testPostStoppedSlaveServer:" + this.testPostStoppedSlaveServer + FS + this.testPostStoppedSlaveServerReturn);
        }

        boolean testPreStartedMasterServer() throws Exception {
            ReplicationRun.this.util.DEBUG("****** BEGIN testPreStartedMasterServer");
            if (this.testPreStartedMasterServer != null) {
                ReplicationRun.this.runStateTest(this.testPreStartedMasterServer, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
            }
            if (this.testPreStartedMasterServerReturn) {
                this.cleanupAndShutdown();
            }
            ReplicationRun.this.util.DEBUG("****** END   testPreStartedMasterServer");
            return this.testPreStartedMasterServerReturn;
        }

        boolean testPreStartedSlaveServer() throws Exception {
            ReplicationRun.this.util.DEBUG("****** BEGIN testPreStartedSlaveServer");
            if (this.testPreStartedSlaveServer != null) {
                ReplicationRun.this.runStateTest(this.testPreStartedSlaveServer, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
            }
            if (this.testPreStartedSlaveServerReturn) {
                this.cleanupAndShutdown();
            }
            ReplicationRun.this.util.DEBUG("****** END   testPreStartedSlaveServer");
            return this.testPreStartedSlaveServerReturn;
        }

        boolean testPreStartedMaster() throws Exception {
            ReplicationRun.this.util.DEBUG("****** BEGIN testPreStartedMaster");
            if (this.testPreStartedMaster != null) {
                ReplicationRun.this.runStateTest(this.testPreStartedMaster, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
            }
            if (this.testPreStartedMasterReturn) {
                this.cleanupAndShutdown();
            }
            ReplicationRun.this.util.DEBUG("****** END   testPreStartedMaster");
            return this.testPreStartedMasterReturn;
        }

        boolean testPreInitSlave() throws Exception {
            ReplicationRun.this.util.DEBUG("****** BEGIN testPreInitSlave");
            if (this.testPreInitSlave != null) {
                ReplicationRun.this.runStateTest(this.testPreInitSlave, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
            }
            if (this.testPreInitSlaveReturn) {
                this.cleanupAndShutdown();
            }
            ReplicationRun.this.util.DEBUG("****** END   testPreInitSlave");
            return this.testPreInitSlaveReturn;
        }

        boolean testPreStartedSlave() throws Exception {
            ReplicationRun.this.util.DEBUG("****** BEGIN testPreStartedSlave");
            if (this.testPreStartedSlave != null) {
                ReplicationRun.this.runStateTest(this.testPreStartedSlave, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
            }
            if (this.testPreStartedSlaveReturn) {
                this.cleanupAndShutdown();
            }
            ReplicationRun.this.util.DEBUG("****** END   testPreStartedSlave");
            return this.testPreStartedSlaveReturn;
        }

        boolean testPostStartedMasterAndSlave() throws Exception {
            ReplicationRun.this.util.DEBUG("****** BEGIN testPostStartedMasterAndSlave");
            if (this.testPostStartedMasterAndSlave != null) {
                ReplicationRun.this.runStateTest(this.testPostStartedMasterAndSlave, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
            }
            if (this.testPostStartedMasterAndSlaveReturn) {
                this.cleanupAndShutdown();
            }
            ReplicationRun.this.util.DEBUG("****** END   testPostStartedMasterAndSlave");
            return this.testPostStartedMasterAndSlaveReturn;
        }

        boolean testPreStoppedMaster() throws Exception {
            ReplicationRun.this.util.DEBUG("****** BEGIN testPreStoppedMaster");
            if (this.testPreStoppedMaster != null) {
                ReplicationRun.this.runStateTest(this.testPreStoppedMaster, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
            }
            if (this.testPreStoppedMasterReturn) {
                this.cleanupAndShutdown();
            }
            ReplicationRun.this.util.DEBUG("****** END   testPreStoppedMaster");
            return this.testPreStoppedMasterReturn;
        }

        boolean testPreStoppedMasterServer() throws Exception {
            ReplicationRun.this.util.DEBUG("****** BEGIN testPreStoppedMasterServer");
            if (this.testPreStoppedMasterServer != null) {
                ReplicationRun.this.runStateTest(this.testPreStoppedMasterServer, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
            }
            if (this.testPreStoppedMasterServerReturn) {
                this.cleanupAndShutdown();
            }
            ReplicationRun.this.util.DEBUG("****** END   testPreStoppedMasterServer");
            return this.testPreStoppedMasterServerReturn;
        }

        boolean testPreStoppedSlave() throws Exception {
            ReplicationRun.this.util.DEBUG("****** BEGIN testPreStoppedSlave");
            if (this.testPreStoppedSlave != null) {
                ReplicationRun.this.runStateTest(this.testPreStoppedSlave, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
            }
            if (this.testPreStoppedSlaveReturn) {
                this.cleanupAndShutdown();
            }
            ReplicationRun.this.util.DEBUG("****** END   testPreStoppedSlave");
            return this.testPreStoppedSlaveReturn;
        }

        boolean testPreStoppedSlaveServer() throws Exception {
            ReplicationRun.this.util.DEBUG("****** BEGIN testPreStoppedSlaveServer");
            if (this.testPreStoppedSlaveServer != null) {
                ReplicationRun.this.runStateTest(this.testPreStoppedSlaveServer, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
            }
            if (this.testPreStoppedSlaveServerReturn) {
                this.cleanupAndShutdown();
            }
            ReplicationRun.this.util.DEBUG("****** END   testPreStoppedSlaveServer");
            return this.testPreStoppedSlaveServerReturn;
        }

        boolean testPostStoppedSlaveServer() throws Exception {
            ReplicationRun.this.util.DEBUG("****** BEGIN testPostStoppedSlaveServer");
            if (this.testPostStoppedSlaveServer != null) {
                ReplicationRun.this.runStateTest(this.testPostStoppedSlaveServer, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
            }
            if (this.testPostStoppedSlaveServerReturn) {
                this.cleanupAndShutdown();
            }
            ReplicationRun.this.util.DEBUG("****** END   testPostStoppedSlaveServer");
            return this.testPostStoppedSlaveServerReturn;
        }

        private void cleanupAndShutdown() {
            ReplicationRun.this.stopServer(jvmVersion, derbyVersion, masterServerHost, masterServerPort);
            ReplicationRun.this.stopServer(jvmVersion, derbyVersion, slaveServerHost, slaveServerPort);
        }
    }
}

