/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLWarning;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.XML;

public final class XMLTypeAndOpsTest
extends BaseJDBCTestCase {
    public XMLTypeAndOpsTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("XML Type and Operators Suite\n");
        if (!XML.classpathMeetsXMLReqs()) {
            return suite;
        }
        suite.addTest(TestConfiguration.defaultSuite(XMLTypeAndOpsTest.class, false));
        return new XMLTestSetup(suite);
    }

    public void testXMLColCreation() throws Exception {
        Statement st = this.createStatement();
        XMLTypeAndOpsTest.assertStatementError("42894", st, "create table fail1 (i int, x xml default 'oops')");
        XMLTypeAndOpsTest.assertStatementError("42894", st, "create table fail2 (i int, x xml default 8)");
        XMLTypeAndOpsTest.assertStatementError("42818", st, "create table fail3 (i int, x xml check (x != 0))");
        st.executeUpdate("create table tc1 (i int, x xml)");
        st.executeUpdate("create table tc2 (i int, x xml not null)");
        st.executeUpdate("create table tc3 (i int, x xml default null)");
        st.executeUpdate("create table tc4 (x2 xml not null)");
        st.executeUpdate("alter table tc4 add column x1 xml");
        st.executeUpdate("drop table tc1");
        st.executeUpdate("drop table tc2");
        st.executeUpdate("drop table tc3");
        st.executeUpdate("drop table tc4");
        st.close();
    }

    public void testIllegalNullInserts() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("create table tc2 (i int, x xml not null)");
        XMLTypeAndOpsTest.assertStatementError("23502", st, "insert into tc2 values (1, null)");
        XMLTypeAndOpsTest.assertStatementError("23502", st, "insert into tc2 values (2, cast (null as xml))");
        st.executeUpdate("drop table tc2");
        st.close();
    }

    public void testXMLColsWithNonXMLVals() throws Exception {
        Statement st = this.createStatement();
        XMLTypeAndOpsTest.assertStatementError("42821", st, "insert into t1 values (3, 'hmm')");
        XMLTypeAndOpsTest.assertStatementError("42821", st, "insert into t1 values (1, 2)");
        XMLTypeAndOpsTest.assertStatementError("42821", st, " insert into t1 values (1, 123.456)");
        XMLTypeAndOpsTest.assertStatementError("42821", st, "insert into t1 values (1, x'01')");
        XMLTypeAndOpsTest.assertStatementError("42821", st, "insert into t1 values (1, x'ab')");
        XMLTypeAndOpsTest.assertStatementError("42821", st, "insert into t1 values (1, current date)");
        XMLTypeAndOpsTest.assertStatementError("42821", st, " insert into t1 values (1, current time)");
        XMLTypeAndOpsTest.assertStatementError("42821", st, " insert into t1 values (1, current timestamp)");
        XMLTypeAndOpsTest.assertStatementError("42821", st, " insert into t1 values (1, ('hmm' || 'andstuff'))");
        st.close();
    }

    public void testNonXMLColsWithXMLVals() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("create table nonXTable (si smallint, i int, bi bigint, vcb varchar (32) for bit data, nu numeric(10,2), f float, d double, vc varchar(20), da date, ti time, ts timestamp, cl clob, bl blob)");
        XMLTypeAndOpsTest.assertStatementError("42821", st, "insert into nonXTable (si) values (cast (null as xml))");
        XMLTypeAndOpsTest.assertStatementError("42821", st, "insert into nonXTable (i) values (cast (null as xml))");
        XMLTypeAndOpsTest.assertStatementError("42821", st, "insert into nonXTable (bi) values (cast (null as xml))");
        XMLTypeAndOpsTest.assertStatementError("42821", st, "insert into nonXTable (vcb) values (cast (null as xml))");
        XMLTypeAndOpsTest.assertStatementError("42821", st, "insert into nonXTable (nu) values (cast (null as xml))");
        XMLTypeAndOpsTest.assertStatementError("42821", st, "insert into nonXTable (f) values (cast (null as xml))");
        XMLTypeAndOpsTest.assertStatementError("42821", st, "insert into nonXTable (d) values (cast (null as xml))");
        XMLTypeAndOpsTest.assertStatementError("42821", st, "insert into nonXTable (vc) values (cast (null as xml))");
        XMLTypeAndOpsTest.assertStatementError("42821", st, "insert into nonXTable (da) values (cast (null as xml))");
        XMLTypeAndOpsTest.assertStatementError("42821", st, "insert into nonXTable (ti) values (cast (null as xml))");
        XMLTypeAndOpsTest.assertStatementError("42821", st, "insert into nonXTable (ts) values (cast (null as xml))");
        XMLTypeAndOpsTest.assertStatementError("42821", st, "insert into nonXTable (cl) values (cast (null as xml))");
        XMLTypeAndOpsTest.assertStatementError("42821", st, "insert into nonXTable (bl) values (cast (null as xml))");
        XMLTypeAndOpsTest.assertStatementError("42821", st, "insert into nonXTable (cl) values (xmlparse(document '</simp>' preserve whitespace))");
        st.executeUpdate("drop table nonXTable");
        st.close();
    }

    public void testXMLCasting() throws Exception {
        Statement st = this.createStatement();
        XMLTypeAndOpsTest.assertStatementError("42846", st, "insert into t1 values (1, cast ('hmm' as xml))");
        XMLTypeAndOpsTest.assertStatementError("42846", st, "insert into t1 values (1, cast (2 as xml))");
        XMLTypeAndOpsTest.assertStatementError("42846", st, "insert into t1 values (1, cast (123.456 as xml))");
        XMLTypeAndOpsTest.assertStatementError("42846", st, "insert into t1 values (1, cast (x'01' as xml))");
        XMLTypeAndOpsTest.assertStatementError("42846", st, "insert into t1 values (1, cast (x'ab' as xml))");
        XMLTypeAndOpsTest.assertStatementError("42846", st, "insert into t1 values (1, cast (current date as xml))");
        XMLTypeAndOpsTest.assertStatementError("42846", st, "insert into t1 values (1, cast (current time as xml))");
        XMLTypeAndOpsTest.assertStatementError("42846", st, "insert into t1 values (1, cast (current timestamp as xml))");
        XMLTypeAndOpsTest.assertStatementError("42846", st, "insert into t1 values (1, cast (('hmm' || 'andstuff') as xml))");
        st.executeUpdate("create table nonXTable (i int, cl clob)");
        XMLTypeAndOpsTest.assertStatementError("42846", st, "insert into nonXTable (cl) values (cast ((xmlparse(document '</simp>' preserve whitespace)) as clob))");
        XMLTypeAndOpsTest.assertStatementError("42846", st, "insert into nonXTable (i) values (cast ((xmlparse(document '</simp>' preserve whitespace)) as int))");
        st.executeUpdate("drop table nonXTable");
        st.close();
    }

    public void testXMLInNonXMLOps() throws Exception {
        Statement st = this.createStatement();
        XMLTypeAndOpsTest.assertStatementError("42Y95", st, "select i + x from t1");
        XMLTypeAndOpsTest.assertStatementError("42Y95", st, "select i * x from t1");
        XMLTypeAndOpsTest.assertStatementError("42Y95", st, "select i / x from t1");
        XMLTypeAndOpsTest.assertStatementError("42Y95", st, "select i - x from t1");
        XMLTypeAndOpsTest.assertStatementError("42X37", st, "select -x from t1");
        XMLTypeAndOpsTest.assertStatementError("42846", st, "select 'hi' || x from t1");
        XMLTypeAndOpsTest.assertStatementError("42X25", st, "select substr(x, 0) from t1");
        XMLTypeAndOpsTest.assertStatementError("42Y22", st, "select max(x) from t1");
        XMLTypeAndOpsTest.assertStatementError("42Y22", st, "select min(x) from t1");
        XMLTypeAndOpsTest.assertStatementError("42X25", st, "select length(x) from t1");
        XMLTypeAndOpsTest.assertStatementError("42884", st, "select i from t1 where x like 'hmm'");
        st.close();
    }

    public void testXMLComparisons() throws Exception {
        Statement st = this.createStatement();
        XMLTypeAndOpsTest.assertStatementError("42818", st, "select i from t1 where x = 'hmm'");
        XMLTypeAndOpsTest.assertStatementError("42818", st, "select i from t1 where x > 0");
        XMLTypeAndOpsTest.assertStatementError("42818", st, "select i from t1 where x < x");
        XMLTypeAndOpsTest.assertStatementError("42818", st, "select i from t1 where x <> 'some char'");
        st.close();
    }

    public void testIllegalOps() throws Exception {
        Statement st = this.createStatement();
        XMLTypeAndOpsTest.assertStatementError("X0X67", st, "create index oops_ix on t1(x)");
        XMLTypeAndOpsTest.assertStatementError("X0X67", st, "select i from t1 where x is null order by x");
        CallableStatement cSt = this.prepareCall("CALL SYSCS_UTIL.SYSCS_EXPORT_TABLE (  null, 'T1', 'extinout/xmlexport.del', null, null, null)");
        XMLTypeAndOpsTest.assertStatementError("42Z71", cSt);
        cSt = this.prepareCall(" CALL SYSCS_UTIL.SYSCS_EXPORT_QUERY(  'select x from t1', 'extinout/xmlexport.del', null, null, null)");
        XMLTypeAndOpsTest.assertStatementError("42Z71", cSt);
        cSt = this.prepareCall(" CALL SYSCS_UTIL.SYSCS_IMPORT_TABLE (  null, 'T1', 'extinout/shouldntmatter.del', null, null, null, 0)");
        XMLTypeAndOpsTest.assertStatementError("XIE0B", cSt);
        cSt = this.prepareCall(" CALL SYSCS_UTIL.SYSCS_IMPORT_DATA (  NULL, 'T1', null, '2', 'extinout/shouldntmatter.del', null, null, null,0)");
        XMLTypeAndOpsTest.assertStatementError("XIE0B", cSt);
        cSt.close();
        XMLTypeAndOpsTest.assertStatementError("42962", st, "create procedure hmmproc (in i int, in x xml)  parameter style java language java external name 'hi.there'");
        XMLTypeAndOpsTest.assertStatementError("42962", st, " create function hmmfunc (i int, x xml) returns int  parameter style java language java external name 'hi.there'");
        XMLTypeAndOpsTest.assertStatementError("42962", st, "declare global temporary table SESSION.xglobal (myx XML)  not logged on commit preserve rows");
        st.close();
    }

    public void testTriggerSetXML() throws Exception {
        Statement st = this.createStatement();
        XMLTypeAndOpsTest.assertStatementError("42821", st, "create trigger tr2 after insert on t1 for each row mode db2sql update t1 set x = 'hmm'");
        st.executeUpdate("create trigger tr1 after insert on t1 for each row mode db2sql update t1 set x = null");
        st.executeUpdate(" drop trigger tr1");
        st.close();
    }

    public void testXMLParse() throws Exception {
        Statement st = this.createStatement();
        XMLTypeAndOpsTest.assertStatementError("42Z74", st, "insert into t1 values (1, xmlparse(document '<hmm/>' strip whitespace))");
        XMLTypeAndOpsTest.assertStatementError("42Z72", st, " insert into t1 values (1, xmlparse(document '<hmm/>'))");
        XMLTypeAndOpsTest.assertStatementError("42Z72", st, " insert into t1 values (1, xmlparse('<hmm/>' preserve whitespace))");
        XMLTypeAndOpsTest.assertStatementError("42Z74", st, " insert into t1 values (1, xmlparse(content '<hmm/>' preserve whitespace))");
        XMLTypeAndOpsTest.assertStatementError("42X25", st, " select xmlparse(document xmlparse(document '<hein/>' preserve whitespace) preserve whitespace) from t1");
        XMLTypeAndOpsTest.assertStatementError("42X19", st, " select i from t1 where xmlparse(document '<hein/>' preserve whitespace)");
        XMLTypeAndOpsTest.assertStatementError("2200M", st, " insert into t1 values (1, xmlparse(document '<oops>' preserve whitespace))");
        this.assertCompileError("42Z79", "insert into t1(x) values XMLPARSE(document ? preserve whitespace)");
        this.assertCompileError("42894", "create table fail1 (i int, x xml default xmlparse(document '<my>default col</my>' preserve whitespace))");
        ResultSet rs = st.executeQuery(" select i from t1 where xmlparse(document '<hein/>' preserve whitespace) is not null");
        String[] expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"1"}, {"2"}, {"4"}, {"3"}, {"5"}, {"6"}, {"7"}, {"8"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery(" select i from t1 where xmlparse(document '<hein/>' preserve whitespace) is not null order by i");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"6"}, {"7"}, {"8"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.execute("create table paramInsert(x xml)");
        PreparedStatement pSt = this.prepareStatement("insert into paramInsert values XMLPARSE(document cast (? as CLOB) preserve whitespace)");
        pSt.setString(1, "<ay>caramba</ay>");
        XMLTypeAndOpsTest.assertUpdateCount(pSt, 1);
        pSt.close();
        rs = st.executeQuery("select xmlserialize(x as clob) from t1");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"<update2> document was inserted as part of an UPDATE </update2>"}, {null}, {null}, {null}, {"<hmm/>"}, {"<half> <masted> bass </masted> boosted. </half>"}, {"<umm> decl check </umm>"}, {"<lets> <try> this out </try> </lets>"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select xmlserialize(x as clob) from paramInsert");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"<ay>caramba</ay>"}};
        st.executeUpdate("drop table paramInsert");
        st.close();
    }

    public void testIsNull() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = st.executeQuery("select i from t1 where x is not null");
        String[] expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"1"}, {"5"}, {"6"}, {"7"}, {"8"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery(" select i from t1 where x is null");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"2"}, {"4"}, {"3"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.close();
    }

    public void testTopLevelSelect() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("create table vcTab (vc varchar(100))");
        XMLTypeAndOpsTest.assertStatementError("42Z71", st, "select x from t1");
        XMLTypeAndOpsTest.assertStatementError("42Z71", st, "select * from t1");
        XMLTypeAndOpsTest.assertStatementError("42Z71", st, " select xmlparse(document vc preserve whitespace) from vcTab");
        XMLTypeAndOpsTest.assertStatementError("42Z71", st, " values xmlparse(document '<bye/>' preserve whitespace)");
        XMLTypeAndOpsTest.assertStatementError("42Z71", st, " values xmlparse(document '<hel' || 'lo/>' preserve whitespace)");
        st.executeUpdate("drop table vcTab");
        st.close();
    }

    public void testXMLSerialize() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("create table vcTab (vc varchar(100))");
        XMLTypeAndOpsTest.assertUpdateCount(st, 1, "insert into vcTab values ('<hmm/>')");
        XMLTypeAndOpsTest.assertUpdateCount(st, 1, "insert into vcTab values 'no good'");
        XMLTypeAndOpsTest.assertStatementError("42Z72", st, "select xmlserialize(x) from t1");
        XMLTypeAndOpsTest.assertStatementError("42X01", st, "select xmlserialize(x as) from t1");
        XMLTypeAndOpsTest.assertStatementError("42Z73", st, " select xmlserialize(x as int) from t1");
        XMLTypeAndOpsTest.assertStatementError("42Z73", st, " select xmlserialize(x as varchar(20) for bit data) from t1");
        XMLTypeAndOpsTest.assertStatementError("42X04", st, " select xmlserialize(y as char(10)) from t1");
        XMLTypeAndOpsTest.assertStatementError("42X25", st, " select xmlserialize(xmlserialize(x as clob) as clob) from t1");
        XMLTypeAndOpsTest.assertStatementError("42X25", st, " values xmlserialize('<okay> dokie </okay>' as clob)");
        ResultSet rs = st.executeQuery("select xmlserialize(x as clob) from t1");
        String[] expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"<update2> document was inserted as part of an UPDATE </update2>"}, {null}, {null}, {null}, {"<hmm/>"}, {"<half> <masted> bass </masted> boosted. </half>"}, {"<umm> decl check </umm>"}, {"<lets> <try> this out </try> </lets>"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select xmlserialize(x1 as clob), xmlserialize(x2 as clob) from t2");
        expColNames = new String[]{"1", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, "<notnull/>"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select xmlserialize(x as char(100)) from t1");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"<update2> document was inserted as part of an UPDATE </update2>"}, {null}, {null}, {null}, {"<hmm/>"}, {"<half> <masted> bass </masted> boosted. </half>"}, {"<umm> decl check </umm>"}, {"<lets> <try> this out </try> </lets>"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select xmlserialize(x as varchar(300)) from t1");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"<update2> document was inserted as part of an UPDATE </update2>"}, {null}, {null}, {null}, {"<hmm/>"}, {"<half> <masted> bass </masted> boosted. </half>"}, {"<umm> decl check </umm>"}, {"<lets> <try> this out </try> </lets>"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        XMLTypeAndOpsTest.assertStatementError("2200M", st, "select xmlserialize(xmlparse(document vc preserve whitespace) as char(10)) from vcTab");
        XMLTypeAndOpsTest.assertStatementError("22001", st, " select xmlserialize(x as char) from t1");
        XMLTypeAndOpsTest.assertStatementError("22001", st, " select xmlserialize(x as clob(10)) from t1");
        XMLTypeAndOpsTest.assertStatementError("22001", st, " select xmlserialize(x as char(1)) from t1");
        XMLTypeAndOpsTest.assertStatementError("22001", st, " select length(xmlserialize(x as char(1))) from t1");
        XMLTypeAndOpsTest.assertStatementError("22001", st, " select xmlserialize(x as varchar(1)) from t1");
        XMLTypeAndOpsTest.assertStatementError("22001", st, " select length(xmlserialize(x as varchar(1))) from t1");
        rs = st.executeQuery("select xmlserialize(x as char(100)) from t1");
        ResultSetMetaData rsmd = rs.getMetaData();
        XMLTypeAndOpsTest.assertEquals((String)"Incorrect XMLSERIALIZE result type:", (int)1, (int)rsmd.getColumnType(1));
        rs = st.executeQuery("select xmlserialize(x as varchar(100)) from t1");
        rsmd = rs.getMetaData();
        XMLTypeAndOpsTest.assertEquals((String)"Incorrect XMLSERIALIZE result type:", (int)12, (int)rsmd.getColumnType(1));
        rs = st.executeQuery("select xmlserialize(x as long varchar) from t1");
        rsmd = rs.getMetaData();
        XMLTypeAndOpsTest.assertEquals((String)"Incorrect XMLSERIALIZE result type:", (int)-1, (int)rsmd.getColumnType(1));
        rs = st.executeQuery("select xmlserialize(x as clob(100)) from t1");
        rsmd = rs.getMetaData();
        XMLTypeAndOpsTest.assertEquals((String)"Incorrect XMLSERIALIZE result type:", (int)2005, (int)rsmd.getColumnType(1));
        rs.close();
        st.executeUpdate("drop table vcTab");
        st.close();
    }

    public void testXMLParseSerializeCombos() throws Exception {
        Statement st = this.createStatement();
        XMLTypeAndOpsTest.assertStatementError("2200M", st, "select xmlserialize(xmlparse(document '<hmm>' preserve whitespace) as clob) from t1");
        XMLTypeAndOpsTest.assertStatementError("42X25", st, " select xmlserialize(xmlparse(document x preserve whitespace) as char(100)) from t1");
        ResultSet rs = st.executeQuery("select xmlserialize(xmlparse(document '<hmm/>' preserve whitespace) as clob) from t1 where i = 1");
        String[] expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"<hmm/>"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select xmlserialize(xmlparse(document xmlserialize(x as clob) preserve whitespace) as clob) from t1");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"<update2> document was inserted as part of an UPDATE </update2>"}, {null}, {null}, {null}, {"<hmm/>"}, {"<half> <masted> bass </masted> boosted. </half>"}, {"<umm> decl check </umm>"}, {"<lets> <try> this out </try> </lets>"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("values xmlserialize(xmlparse(document '<okay> dokie </okay>' preserve whitespace) as clob)");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"<okay> dokie </okay>"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select i from t1 where xmlparse(document xmlserialize(x as clob) preserve whitespace) is not null order by i");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"5"}, {"6"}, {"7"}, {"8"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.close();
    }

    public void testXMLExists() throws Exception {
        Statement st = this.createStatement();
        XMLTypeAndOpsTest.assertStatementError("42X01", st, "select i from t1 where xmlexists(x)");
        XMLTypeAndOpsTest.assertStatementError("42X01", st, "select i from t1 where xmlexists(i)");
        XMLTypeAndOpsTest.assertStatementError("42X01", st, "select i from t1 where xmlexists('//*')");
        XMLTypeAndOpsTest.assertStatementError("42X01", st, "select i from t1 where xmlexists('//*' x)");
        XMLTypeAndOpsTest.assertStatementError("42X01", st, "select i from t1 where xmlexists('//*' passing x)");
        XMLTypeAndOpsTest.assertStatementError("42Z74", st, "select i from t1 where xmlexists('//*' passing by value x)");
        XMLTypeAndOpsTest.assertStatementError("42Z77", st, "select i from t1 where xmlexists('//*' passing by ref i)");
        XMLTypeAndOpsTest.assertStatementError("42Z75", st, "select i from t1 where xmlexists(i passing by ref x)");
        XMLTypeAndOpsTest.assertStatementError("42Z76", st, "select i from t1 where xmlexists(i passing by ref x, x)");
        ResultSet rs = st.executeQuery("select i from t1 where xmlexists('//*' passing by ref x)");
        String[] expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"1"}, {"5"}, {"6"}, {"7"}, {"8"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select i from t1 where xmlexists('//person' passing by ref x)");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        rs = st.executeQuery("select i from t1 where xmlexists('//lets' passing by ref x)");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"8"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select xmlexists('//lets' passing by ref x) from t1");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"false"}, {null}, {null}, {null}, {"false"}, {"false"}, {"false"}, {"true"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select xmlexists('//try[text()='' this out '']' passing by ref x) from t1");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"false"}, {null}, {null}, {null}, {"false"}, {"false"}, {"false"}, {"true"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select xmlexists('//let' passing by ref x) from t1");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"false"}, {null}, {null}, {null}, {"false"}, {"false"}, {"false"}, {"false"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select xmlexists('//try[text()='' this in '']' passing by ref x) from t1");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"false"}, {null}, {null}, {null}, {"false"}, {"false"}, {"false"}, {"false"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select i, xmlexists('//let' passing by ref x) from t1");
        expColNames = new String[]{"I", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "false"}, {"2", null}, {"4", null}, {"3", null}, {"5", "false"}, {"6", "false"}, {"7", "false"}, {"8", "false"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select i, xmlexists('//lets' passing by ref x) from t1");
        expColNames = new String[]{"I", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "false"}, {"2", null}, {"4", null}, {"3", null}, {"5", "false"}, {"6", "false"}, {"7", "false"}, {"8", "true"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("values xmlexists('//let' passing by ref xmlparse(document '<lets> try this </lets>' preserve whitespace))");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"false"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("values xmlexists('//lets' passing by ref xmlparse(document '<lets> try this </lets>' preserve whitespace))");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"true"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("values xmlexists('//lets/@doit' passing by ref xmlparse(document '<lets doit=\"true\"> try this </lets>' preserve whitespace))");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"true"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("values xmlexists('//lets/@dot' passing by ref xmlparse(document '<lets doit=\"true\"> try this </lets>' preserve whitespace))");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"false"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select xmlserialize(x1 as clob) from t2 where xmlexists('//*' passing by ref x1)");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        rs = st.executeQuery("select xmlserialize(x2 as clob) from t2 where xmlexists('//*' passing by ref x2)");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"<notnull/>"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select xmlserialize(x1 as clob), xmlexists('//*' passing by ref xmlparse(document '<badboy/>' preserve whitespace)) from t2");
        expColNames = new String[]{"1", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, "true"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select xmlserialize(x1 as clob), xmlexists('//goodboy' passing by ref xmlparse(document '<badboy/>' preserve whitespace)) from t2");
        expColNames = new String[]{"1", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, "false"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("create table xqExists2 (i int, x1 xml, x2 xml not null)");
        XMLTypeAndOpsTest.assertUpdateCount(st, 1, " insert into xqExists2 values (1, null, xmlparse(document '<ok/>' preserve whitespace))");
        rs = st.executeQuery("select i, xmlserialize(x1 as char(10)), xmlserialize (x2 as char(10)) from xqExists2");
        expColNames = new String[]{"I", "2", "3"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", null, "<ok/>"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select i from xqExists2 where xmlexists('/ok' passing by ref x1) and xmlexists('/ok' passing by ref x2)");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        rs = st.executeQuery("select i from xqExists2 where xmlexists('/ok' passing by ref x1) or xmlexists('/ok' passing by ref x2)");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("create table xqExists1 (i int, x xml check (xmlexists('//should' passing by ref x)))");
        XMLTypeAndOpsTest.assertUpdateCount(st, 1, " insert into xqExists1 values (1, xmlparse(document '<should/>' preserve whitespace))");
        XMLTypeAndOpsTest.assertStatementError("23513", st, " insert into xqExists1 values (1, xmlparse(document '<shouldnt/>' preserve whitespace))");
        rs = st.executeQuery("select xmlserialize(x as char(20)) from xqExists1");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"<should/>"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("create table xqExists3 (i int, x xml)");
        XMLTypeAndOpsTest.assertUpdateCount(st, 1, " insert into xqExists3 values (1, xmlparse(document '<a:hi xmlns:a=\"http://www.hi.there\"/>' preserve whitespace))");
        XMLTypeAndOpsTest.assertUpdateCount(st, 1, " insert into xqExists3 values (2, xmlparse(document '<b:hi xmlns:b=\"http://www.hi.there\"/>' preserve whitespace))");
        XMLTypeAndOpsTest.assertUpdateCount(st, 1, " insert into xqExists3 values (3, xmlparse(document '<a:bye xmlns:a=\"http://www.good.bye\"/>' preserve whitespace))");
        XMLTypeAndOpsTest.assertUpdateCount(st, 1, " insert into xqExists3 values (4, xmlparse(document '<b:bye xmlns:b=\"http://www.hi.there\"/>' preserve whitespace))");
        XMLTypeAndOpsTest.assertUpdateCount(st, 1, " insert into xqExists3 values (5, xmlparse(document '<hi/>' preserve whitespace))");
        rs = st.executeQuery("select xmlexists('//child::*[name()=\"none\"]' passing by ref x) from xqExists3");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"false"}, {"false"}, {"false"}, {"false"}, {"false"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select xmlexists('//child::*[name()=''hi'']' passing by ref x) from xqExists3");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"false"}, {"false"}, {"false"}, {"false"}, {"true"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select xmlexists('//child::*[local-name()=''hi'']' passing by ref x) from xqExists3");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"true"}, {"true"}, {"false"}, {"false"}, {"true"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select xmlexists('//child::*[local-name()=''bye'']' passing by ref x) from xqExists3");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"false"}, {"false"}, {"true"}, {"true"}, {"false"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select xmlexists('//*[namespace::*[string()=''http://www.hi.there'']]' passing by ref x) from xqExists3");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"true"}, {"true"}, {"false"}, {"true"}, {"false"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select xmlexists('//*[namespace::*[string()=''http://www.good.bye'']]' passing by ref x) from xqExists3");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"false"}, {"false"}, {"true"}, {"false"}, {"false"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select xmlexists('//child::*[local-name()=''hi'' and namespace::*[string()=''http://www.hi.there'']]' passing by ref x) from xqExists3");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"true"}, {"true"}, {"false"}, {"false"}, {"false"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select xmlexists('//child::*[local-name()=''bye'' and namespace::*[string()=''http://www.good.bye'']]' passing by ref x) from xqExists3");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"false"}, {"false"}, {"true"}, {"false"}, {"false"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select xmlexists('//child::*[local-name()=''bye'' and namespace::*[string()=''http://www.hi.there'']]' passing by ref x) from xqExists3");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"false"}, {"false"}, {"false"}, {"true"}, {"false"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("drop table xqExists1");
        st.executeUpdate("drop table xqExists2");
        st.executeUpdate("drop table xqExists3");
        st.close();
    }

    public void testXMLQuery() throws Exception {
        Statement st = this.createStatement();
        XMLTypeAndOpsTest.assertStatementError("42X01", st, "select i, xmlquery('//*') from t1");
        XMLTypeAndOpsTest.assertStatementError("42X01", st, " select i, xmlquery('//*' passing) from t1");
        XMLTypeAndOpsTest.assertStatementError("42X01", st, " select i, xmlquery('//*' passing by ref x) from t1");
        XMLTypeAndOpsTest.assertStatementError("42X01", st, " select i, xmlquery('//*' passing by ref x returning sequence) from t1");
        XMLTypeAndOpsTest.assertStatementError("42X01", st, " select i, xmlquery(passing by ref x empty on empty) from t1");
        XMLTypeAndOpsTest.assertStatementError("42X01", st, " select i, xmlquery(xmlquery('//*' returning sequence empty on empty) as char(75)) from t1");
        XMLTypeAndOpsTest.assertStatementError("42Z74", st, "select i, xmlquery('//*' passing by ref x returning sequence null on empty) from t1");
        XMLTypeAndOpsTest.assertStatementError("42Z74", st, " select i, xmlquery('//*' passing by ref x returning content empty on empty) from t1");
        XMLTypeAndOpsTest.assertStatementError("42Z71", st, "select i, xmlquery('//*' passing by ref x empty on empty) from t1");
        XMLTypeAndOpsTest.assertStatementError("42Z77", st, "select i, xmlquery('//*' passing by ref i empty on empty) from t1");
        XMLTypeAndOpsTest.assertStatementError("42Z77", st, " select i, xmlquery('//*' passing by ref 'hello' empty on empty) from t1");
        XMLTypeAndOpsTest.assertStatementError("42Z77", st, " select i, xmlquery('//*' passing by ref cast ('hello' as clob) empty on empty) from t1");
        XMLTypeAndOpsTest.assertStatementError("10000", st, "select i,  xmlserialize(    xmlquery('data(//@*)' passing by ref x returning sequence empty on empty)  as char(70))from t1");
        ResultSet rs = st.executeQuery("select i,  xmlserialize(    xmlquery('2+2' passing by ref x returning sequence empty on empty)  as char(70))from t1");
        String[] expColNames = new String[]{"I", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"1", "4"}, {"2", null}, {"4", null}, {"3", null}, {"5", "4"}, {"6", "4"}, {"7", "4"}, {"8", "4"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select i,  xmlserialize(    xmlquery('./notthere' passing by ref x returning sequence empty on empty)  as char(70))from t1");
        expColNames = new String[]{"I", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", ""}, {"2", null}, {"4", null}, {"3", null}, {"5", ""}, {"6", ""}, {"7", ""}, {"8", ""}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select i,  xmlserialize(    xmlquery('//*' passing by ref x empty on empty)  as char(70))from t1");
        expColNames = new String[]{"I", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "<update2> document was inserted as part of an UPDATE </update2>"}, {"2", null}, {"4", null}, {"3", null}, {"5", "<hmm/>"}, {"6", "<half> <masted> bass </masted> boosted. </half><masted> bass </masted>"}, {"7", "<umm> decl check </umm>"}, {"8", "<lets> <try> this out </try> </lets><try> this out </try>"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select i,  xmlserialize(    xmlquery('//*[text() = \" bass \"]' passing by ref x empty on empty)  as char(70))from t1");
        expColNames = new String[]{"I", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", ""}, {"2", null}, {"4", null}, {"3", null}, {"5", ""}, {"6", "<masted> bass </masted>"}, {"7", ""}, {"8", ""}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select i,  xmlserialize(    xmlquery('//lets' passing by ref x empty on empty)  as char(70))from t1");
        expColNames = new String[]{"I", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", ""}, {"2", null}, {"4", null}, {"3", null}, {"5", ""}, {"6", ""}, {"7", ""}, {"8", "<lets> <try> this out </try> </lets>"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select i,  xmlserialize(    xmlquery('//text()' passing by ref x empty on empty)  as char(70))from t1");
        expColNames = new String[]{"I", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "document was inserted as part of an UPDATE"}, {"2", null}, {"4", null}, {"3", null}, {"5", ""}, {"6", "bass  boosted."}, {"7", "decl check"}, {"8", "this out"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select i,  xmlserialize(    xmlquery('//try[text()='' this out '']' passing by ref x empty on empty)  as char(70))from t1");
        expColNames = new String[]{"I", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", ""}, {"2", null}, {"4", null}, {"3", null}, {"5", ""}, {"6", ""}, {"7", ""}, {"8", "<try> this out </try>"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select i,  xmlserialize(    xmlquery('//try[text()='' this in '']' passing by ref x empty on empty)  as char(70))from t1");
        expColNames = new String[]{"I", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", ""}, {"2", null}, {"4", null}, {"3", null}, {"5", ""}, {"6", ""}, {"7", ""}, {"8", ""}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select i,  xmlserialize(    xmlquery('2+.//try' passing by ref x returning sequence empty on empty)  as char(70))from t1");
        expColNames = new String[]{"I", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "NaN"}, {"2", null}, {"4", null}, {"3", null}, {"5", "NaN"}, {"6", "NaN"}, {"7", "NaN"}, {"8", "NaN"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("values ('x', xmlserialize(  xmlquery('//let' passing by ref    xmlparse(document '<lets> try this </lets>' preserve whitespace)  empty on empty)as char(30)))");
        expColNames = new String[]{"1", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"x", ""}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("values xmlserialize(  xmlquery('//lets' passing by ref    xmlparse(document '<lets> try this </lets>' preserve whitespace)  empty on empty)as char(30))");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"<lets> try this </lets>"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.close();
    }

    public void testXMLQueryInsert() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("create table xqInsert1 (i int, x xml not null)");
        XMLTypeAndOpsTest.assertUpdateCount(st, 1, " insert into xqInsert1 values (1, xmlparse(document '<should> work as planned </should>' preserve whitespace))");
        st.executeUpdate("create table xqInsert2 (i int, x xml default null)");
        XMLTypeAndOpsTest.assertUpdateCount(st, 1, "insert into xqInsert2 values (  9,  xmlparse(document '<here><is><my height=\"4.4\">attribute</my></is></here>' preserve whitespace))");
        XMLTypeAndOpsTest.assertUpdateCount(st, 1, " insert into xqInsert2 values (  0,  xmlparse(document '<there><goes><my weight=\"180\">attribute</my></goes></there>' preserve whitespace))");
        ResultSet rs = st.executeQuery("select i, xmlserialize(x as char(75)) from xqInsert1");
        String[] expColNames = new String[]{"I", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"1", "<should> work as planned </should>"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select i, xmlserialize(x as char(75)) from xqInsert2");
        expColNames = new String[]{"I", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"9", "<here><is><my height=\"4.4\">attribute</my></is></here>"}, {"0", "<there><goes><my weight=\"180\">attribute</my></goes></there>"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        XMLTypeAndOpsTest.assertStatementError("2200L", st, "insert into xqInsert1 (i, x) values (  20,   (select    xmlquery('./notthere' passing by ref x returning sequence empty on empty)    from xqInsert2 where i = 9  ))");
        XMLTypeAndOpsTest.assertStatementError("2200L", st, " insert into xqInsert1 (i, x) values (  21,  (select    xmlquery('//@*' passing by ref x returning sequence empty on empty)    from xqInsert2 where i = 9  ))");
        XMLTypeAndOpsTest.assertStatementError("2200L", st, " insert into xqInsert1 (i, x) values (  22,  (select    xmlquery('. + 2' passing by ref x returning sequence empty on empty)    from xqInsert2 where i = 9  ))");
        XMLTypeAndOpsTest.assertStatementError("2200L", st, " insert into xqInsert1 (i, x) values (  23,  (select    xmlquery('//*' passing by ref x returning sequence empty on empty)    from xqInsert2 where i = 9  ))");
        XMLTypeAndOpsTest.assertStatementError("2200L", st, " insert into xqInsert1 (i, x) values (  24,  (select    xmlquery('//*[//@*]' passing by ref x returning sequence empty on empty)    from xqInsert2 where i = 9  ))");
        XMLTypeAndOpsTest.assertStatementError("2200L", st, " insert into xqInsert1 (i, x) values (  25,  (select    xmlquery('//is' passing by ref x returning sequence empty on empty)    from xqInsert2 where i = 9  ))");
        XMLTypeAndOpsTest.assertStatementError("2200L", st, " insert into xqInsert1 (i, x) values (  26,  (select    xmlquery('//*[@*]' passing by ref x returning sequence empty on empty)    from xqInsert2 where i = 9  ))");
        XMLTypeAndOpsTest.assertUpdateCount(st, 1, "insert into xqInsert1 (i, x) values (  27,  (select    xmlquery('.' passing by ref x returning sequence empty on empty)    from xqInsert2 where i = 9  ))");
        XMLTypeAndOpsTest.assertUpdateCount(st, 1, " insert into xqInsert1 (i, x) values (  28,  (select    xmlquery('/here/..' passing by ref x returning sequence empty on empty)    from xqInsert2 where i = 9  ))");
        rs = st.executeQuery("select i, xmlserialize(x as char(75)) from xqInsert1");
        expColNames = new String[]{"I", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "<should> work as planned </should>"}, {"27", "<here><is><my height=\"4.4\">attribute</my></is></here>"}, {"28", "<here><is><my height=\"4.4\">attribute</my></is></here>"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        XMLTypeAndOpsTest.assertUpdateCount(st, 1, "insert into xqInsert2 (i, x) values (  29,  (select    xmlquery('2+2' passing by ref x returning sequence empty on empty)    from xqInsert2 where i = 100  ))");
        XMLTypeAndOpsTest.assertUpdateCount(st, 1, " insert into xqInsert2 (i, x) values (  30,  (select    xmlquery('.' passing by ref x returning sequence empty on empty)    from xqInsert2 where i = 100  ))");
        rs = st.executeQuery("select i, xmlserialize(x as char(75)) from xqInsert2");
        expColNames = new String[]{"I", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"9", "<here><is><my height=\"4.4\">attribute</my></is></here>"}, {"0", "<there><goes><my weight=\"180\">attribute</my></goes></there>"}, {"29", null}, {"30", null}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("drop table xqInsert1");
        st.executeUpdate("drop table xqInsert2");
        st.close();
    }

    public void testXMLQueryUpdate() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("create table xqUpdate (i int, x xml default null)");
        XMLTypeAndOpsTest.assertUpdateCount(st, 2, "insert into xqUpdate (i) values 29, 30");
        XMLTypeAndOpsTest.assertUpdateCount(st, 1, "insert into xqUpdate values (  9,  xmlparse(document '<here><is><my height=\"4.4\">attribute</my></is></here>' preserve whitespace))");
        XMLTypeAndOpsTest.assertUpdateCount(st, 1, "update xqUpdate  set x =     xmlquery('.' passing by ref      xmlparse(document '<none><here/></none>' preserve whitespace)    returning sequence empty on empty)where i = 29");
        XMLTypeAndOpsTest.assertUpdateCount(st, 1, " update xqUpdate  set x =     xmlquery('self::node()[//@height]' passing by ref      (select        xmlquery('.' passing by ref x empty on empty)        from xqUpdate        where i = 9      )    empty on empty)where i = 30");
        XMLTypeAndOpsTest.assertStatementError("2200L", st, "update xqUpdate  set x = xmlquery('.//*' passing by ref x empty on empty)where i = 29");
        XMLTypeAndOpsTest.assertStatementError("2200L", st, " update xqUpdate  set x = xmlquery('./notthere' passing by ref x empty on empty)where i = 30");
        XMLTypeAndOpsTest.assertStatementError("2200L", st, " update xqUpdate  set x =    xmlquery('//*[@weight]' passing by ref      (select        xmlquery('.' passing by ref x empty on empty)        from xqUpdate        where i = 9      )    empty on empty)where i = 30");
        XMLTypeAndOpsTest.assertStatementError("2200L", st, " update xqUpdate  set x =    xmlquery('//*/@height' passing by ref      (select        xmlquery('.' passing by ref x empty on empty)        from xqUpdate        where i = 9      )    empty on empty)where i = 30");
        XMLTypeAndOpsTest.assertUpdateCount(st, 0, "update xqUpdate  set x = xmlquery('//*' passing by ref x empty on empty)where i = 100");
        XMLTypeAndOpsTest.assertUpdateCount(st, 0, " update xqUpdate  set x = xmlquery('4+4' passing by ref x empty on empty)where i = 100");
        ResultSet rs = st.executeQuery("select i, xmlserialize(x as char(75)) from xqUpdate");
        String[] expColNames = new String[]{"I", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"29", "<none><here/></none>"}, {"30", "<here><is><my height=\"4.4\">attribute</my></is></here>"}, {"9", "<here><is><my height=\"4.4\">attribute</my></is></here>"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("drop table xqUpdate");
        st.close();
    }

    public void testNestedXMLQuery() throws Exception {
        Statement st = this.createStatement();
        XMLTypeAndOpsTest.assertStatementError("2200V", st, "select i,  xmlserialize(    xmlquery('//lets/@*' passing by ref      xmlquery('/okay/text()' passing by ref        xmlparse(document '<okay><lets boki=\"inigo\"/></okay>' preserve whitespace)      empty on empty)    empty on empty)  as char(100))from t1 where i > 5");
        XMLTypeAndOpsTest.assertStatementError("2200V", st, " select i,  xmlserialize(    xmlquery('.' passing by ref      xmlquery('//lets' passing by ref        xmlparse(document '<okay><lets boki=\"inigo\"/></okay>' preserve whitespace)      empty on empty)    empty on empty)  as char(100))from t1 where i > 5");
        XMLTypeAndOpsTest.assertStatementError("2200V", st, " select i,  xmlexists('.' passing by ref    xmlquery('/okay' passing by ref      xmlparse(document '<okay><lets boki=\"inigo\"/></okay>' preserve whitespace)    empty on empty)  )from t1 where i > 5");
        ResultSet rs = st.executeQuery("select i,  xmlserialize(    xmlquery('/not' passing by ref      xmlquery('.' passing by ref        xmlparse(document '<okay><lets boki=\"inigo\"/></okay>' preserve whitespace)      empty on empty)    empty on empty)  as char(100))from t1 where i > 5");
        String[] expColNames = new String[]{"I", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"6", ""}, {"7", ""}, {"8", ""}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select i,  xmlserialize(    xmlquery('//lets' passing by ref      xmlquery('.' passing by ref        xmlparse(document '<okay><lets boki=\"inigo\"/></okay>' preserve whitespace)      empty on empty)    empty on empty)  as char(100))from t1 where i > 5");
        expColNames = new String[]{"I", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"6", "<lets boki=\"inigo\"/>"}, {"7", "<lets boki=\"inigo\"/>"}, {"8", "<lets boki=\"inigo\"/>"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select i,  xmlserialize(    xmlquery('string(//@boki)' passing by ref      xmlquery('/okay/..' passing by ref        xmlparse(document '<okay><lets boki=\"inigo\"/></okay>' preserve whitespace)      empty on empty)    empty on empty)  as char(100))from t1 where i > 5");
        expColNames = new String[]{"I", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"6", "inigo"}, {"7", "inigo"}, {"8", "inigo"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select i,  xmlserialize(    xmlquery('/half/masted/text()' passing by ref      xmlquery('.' passing by ref x empty on empty)    empty on empty)  as char(100))from t1 where i = 6");
        expColNames = new String[]{"I", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"6", "bass"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select i,  xmlexists('/half/masted/text()' passing by ref    xmlquery('.' passing by ref x empty on empty)  )from t1 where i = 6");
        expColNames = new String[]{"I", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"6", "true"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.close();
    }

    public void testAttrSerialization() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("create table attserTable (i int, x xml)");
        XMLTypeAndOpsTest.assertUpdateCount(st, 1, "insert into attserTable values (0, null)");
        XMLTypeAndOpsTest.assertUpdateCount(st, 1, "insert into attserTable values (10,  xmlparse(document    '<threeatts first=\"1\" second=\"two\" third=\"le 3 trois\"/>'    preserve whitespace  ))");
        ResultSet rs = st.executeQuery("select i, xmlserialize(x as char(75)) from attserTable");
        String[] expColNames = new String[]{"I", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"0", null}, {"10", "<threeatts first=\"1\" second=\"two\" third=\"le 3 trois\"/>"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        XMLTypeAndOpsTest.assertStatementError("2200W", st, "select  xmlserialize(    xmlquery(      '//@*' passing by ref x empty on empty    )  as char(50)) from attserTable where xmlexists('//@*' passing by ref x)");
        rs = st.executeQuery("select  xmlserialize(    xmlquery(      'string(//@*)'      passing by ref x empty on empty    )  as char(50)) from attserTable where xmlexists('//@*' passing by ref x)");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select  max(    cast(      xmlserialize(        xmlquery('count(//@*)' passing by ref x empty on empty)      as char(50))    as int)  ) from attserTable");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"3"}};
        JDBC.assertFullResultSet(rs, expRS, true, false);
        if (XMLTypeAndOpsTest.usingEmbedded()) {
            SQLWarning sqlWarn = rs.getWarnings();
            if (sqlWarn == null) {
                sqlWarn = st.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = this.getConnection().getWarnings();
            }
            XMLTypeAndOpsTest.assertTrue((String)"Expected warning but found none.", (sqlWarn != null ? 1 : 0) != 0);
            XMLTypeAndOpsTest.assertSQLState("01003", sqlWarn);
        }
        rs.close();
        rs = st.executeQuery("select  xmlserialize(    xmlquery(      'concat(string(//@*[1]), \" \",        string(//@*[2]), \" \",        string(//@*[3]))'      passing by ref x empty on empty    )  as char(50)) from attserTable where xmlexists('//@*' passing by ref x)");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1 two le 3 trois"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("drop table attserTable");
        st.close();
    }

    public void testTriggerSPSWithXML() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("create table trigSPS1 (i int, x xml)");
        st.executeUpdate("create table trigSPS2 (i int, x xml)");
        XMLTypeAndOpsTest.assertUpdateCount(st, 1, " insert into trigSPS1 values (1, xmlparse(document '<name> john </name>' preserve whitespace))");
        st.executeUpdate("create trigger tx after insert on trigSPS1 for each statement mode db2sql insert into trigSPS2 values (1, xmlparse(document '<name> jane </name>' preserve whitespace))");
        XMLTypeAndOpsTest.assertUpdateCount(st, 1, " insert into trigSPS1 values (2, xmlparse(document '<name> ally </name>' preserve whitespace))");
        ResultSet rs = st.executeQuery("select i, xmlserialize(x as varchar(20)) from trigSPS1");
        String[] expColNames = new String[]{"I", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"1", "<name> john </name>"}, {"2", "<name> ally </name>"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select i, xmlserialize(x as varchar(20)) from trigSPS2");
        expColNames = new String[]{"I", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "<name> jane </name>"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        XMLTypeAndOpsTest.assertUpdateCount(st, 2, "insert into trigSPS1 select * from trigSPS1");
        rs = st.executeQuery("select i, xmlserialize(x as varchar(20)) from trigSPS1");
        expColNames = new String[]{"I", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "<name> john </name>"}, {"2", "<name> ally </name>"}, {"1", "<name> john </name>"}, {"2", "<name> ally </name>"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select i, xmlserialize(x as varchar(20)) from trigSPS2");
        expColNames = new String[]{"I", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "<name> jane </name>"}, {"1", "<name> jane </name>"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("drop trigger tx");
        XMLTypeAndOpsTest.assertUpdateCount(st, 4, "delete from trigSPS1");
        XMLTypeAndOpsTest.assertUpdateCount(st, 2, "delete from trigSPS2");
        XMLTypeAndOpsTest.assertUpdateCount(st, 1, " insert into trigSPS1 values (1, xmlparse(document '<name> john </name>' preserve whitespace))");
        st.executeUpdate("create trigger tx after insert on trigSPS1 for each statement mode db2sql insert into trigSPS2 values (1, (select xmlquery('.' passing by ref x returning sequence empty on empty) from trigSPS1 where i = 1))");
        XMLTypeAndOpsTest.assertUpdateCount(st, 1, " insert into trigSPS1 values (2, xmlparse(document '<name> ally </name>' preserve whitespace))");
        rs = st.executeQuery("select i, xmlserialize(x as varchar(20)) from trigSPS1");
        expColNames = new String[]{"I", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "<name> john </name>"}, {"2", "<name> ally </name>"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select i, xmlserialize(x as varchar(20)) from trigSPS2");
        expColNames = new String[]{"I", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "<name> john </name>"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("drop trigger tx");
        st.executeUpdate("drop table trigSPS1");
        st.executeUpdate("drop table trigSPS2");
        st.close();
    }

    private static class XMLTestSetup
    extends BaseJDBCTestSetup {
        public XMLTestSetup(TestSuite tSuite) {
            super((Test)tSuite);
        }

        public void setUp() throws Exception {
            Connection c = this.getConnection();
            Statement s = c.createStatement();
            s.executeUpdate("create table t1 (i int, x xml)");
            s.executeUpdate("create table t2 (x2 xml not null)");
            s.executeUpdate("alter table t2 add column x1 xml");
            BaseJDBCTestCase.assertUpdateCount(s, 1, "insert into t1 values (1, null)");
            BaseJDBCTestCase.assertUpdateCount(s, 1, "insert into t1 values (2, cast (null as xml))");
            BaseJDBCTestCase.assertUpdateCount(s, 1, "insert into t1 (i) values (4)");
            BaseJDBCTestCase.assertUpdateCount(s, 1, "insert into t1 values (3, default)");
            BaseJDBCTestCase.assertUpdateCount(s, 1, "insert into t1 values (5, xmlparse(document '<hmm/>' preserve whitespace))");
            BaseJDBCTestCase.assertUpdateCount(s, 1, " insert into t1 values (6, xmlparse(document '<half> <masted> bass </masted> boosted. </half>' preserve whitespace))");
            BaseJDBCTestCase.assertUpdateCount(s, 1, " insert into t2 (x1, x2) values (null, xmlparse(document '<notnull/>' preserve whitespace))");
            BaseJDBCTestCase.assertUpdateCount(s, 1, " insert into t1 values (7, xmlparse(document '<?xml version=\"1.0\" encoding= \"UTF-8\"?><umm> decl check </umm>' preserve whitespace))");
            BaseJDBCTestCase.assertUpdateCount(s, 1, "insert into t1 values (8, xmlparse(document '<lets> <try> this out </try> </lets>' preserve whitespace))");
            BaseJDBCTestCase.assertUpdateCount(s, 1, " update t1 set x = xmlparse(document '<update> document was inserted as part of an UPDATE </update>' preserve whitespace) where i = 1");
            BaseJDBCTestCase.assertUpdateCount(s, 1, " update t1 set x = xmlparse(document '<update2> document was inserted as part of an UPDATE </update2>' preserve whitespace) where xmlexists('/update' passing by ref x)");
            s.close();
            c.close();
            s = null;
            c = null;
        }

        public void tearDown() throws Exception {
            Connection c = this.getConnection();
            Statement s = c.createStatement();
            s.executeUpdate("drop table t1");
            s.executeUpdate("drop table t2");
            s.close();
            c.close();
            s = null;
            c = null;
            super.tearDown();
        }
    }
}

