/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BigDecimalHandler;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ParameterMappingTest
extends BaseJDBCTestCase {
    private static boolean HAVE_BIG_DECIMAL = !JDBC.vmSupportsJSR169();
    private static int[] jdbcTypes = new int[]{-6, 5, 4, -5, 7, 6, 8, 3, 2, -7, 0, 1, 12, -1, 0, -3, 0, 91, 92, 93, 2005, 2004};
    private static String[] SQLTypes = new String[]{null, "SMALLINT", "INTEGER", "BIGINT", "REAL", "FLOAT", "DOUBLE", "DECIMAL(10,5)", null, null, null, "CHAR(60)", "VARCHAR(60)", "LONG VARCHAR", "CHAR(60) FOR BIT DATA", "VARCHAR(60) FOR BIT DATA", "LONG VARCHAR FOR BIT DATA", "DATE", "TIME", "TIMESTAMP", "CLOB(1k)", "BLOB(1k)"};
    private static String[] validString = new String[]{null, "98", "98", "98", "98", "98", "98", "98", null, null, null, "98", "98", "98", "0x4", "0x4", "0x4", "2004-02-14", "00:00:00", "2004-02-14 00:00:00", "98", "0x4"};
    private static Class[] B3_GET_OBJECT = HAVE_BIG_DECIMAL ? new Class[]{Integer.class, Integer.class, Integer.class, Long.class, Float.class, Double.class, Double.class, BigDecimal.class, BigDecimal.class, Boolean.class, Boolean.class, String.class, String.class, String.class, [B.class, [B.class, [B.class, Date.class, Time.class, Timestamp.class, Clob.class, Blob.class} : new Class[]{Integer.class, Integer.class, Integer.class, Long.class, Float.class, Double.class, Double.class, String.class, String.class, Boolean.class, Boolean.class, String.class, String.class, String.class, [B.class, [B.class, [B.class, Date.class, Time.class, Timestamp.class, Clob.class, Blob.class};
    private static final boolean _ = false;
    private static final boolean X = true;
    public static final boolean[][] B6 = new boolean[][]{{true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, true, false, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, true, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}};
    public static boolean[][] B2_MOD = new boolean[][]{{true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, true, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, true, false, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, true, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, true, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, true}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}};
    public static boolean[][] B5 = new boolean[][]{{true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, true, true, true, true, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, true, false, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, true, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, true, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}};
    public static final boolean[][] allowRegisterOut = new boolean[][]{{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, true, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, true, false, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, true, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, true, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}};

    public ParameterMappingTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        Connection conn = this.getConnection();
        conn.setAutoCommit(false);
        Statement scb = conn.createStatement();
        scb.execute("CREATE TABLE PM.LOB_GET(ID INT, B BLOB, C CLOB)");
        PreparedStatement pscb = conn.prepareStatement("INSERT INTO PM.LOB_GET VALUES (?, ?, ?)");
        pscb.setInt(1, 0);
        pscb.setNull(2, 2004);
        pscb.setNull(3, 2005);
        pscb.executeUpdate();
        pscb.setInt(1, 1);
        byte[] data = new byte[]{4, 3, 114, 67, 0, 55};
        pscb.setBinaryStream(2, (InputStream)new ByteArrayInputStream(data), 6);
        pscb.setCharacterStream(3, (Reader)new StringReader("72"), 2);
        pscb.executeUpdate();
        scb.close();
        pscb.close();
        conn.commit();
    }

    public void testDerby2073() throws Exception {
        if (!JDBC.vmSupportsJDBC2()) {
            return;
        }
        Statement s = this.createStatement();
        s.executeUpdate("CREATE TABLE DERBY_2073_TAB (dc DECIMAL(10,2), db double, r real, i int)");
        PreparedStatement ps = this.prepareStatement("INSERT INTO DERBY_2073_TAB VALUES(?,?,?,?)");
        BigDecimal value = new BigDecimal("123.45");
        ps.setBigDecimal(1, value);
        ps.setBigDecimal(2, value);
        ps.setBigDecimal(3, value);
        ps.setBigDecimal(4, value);
        ps.executeUpdate();
        ps.setBigDecimal(1, null);
        ps.setBigDecimal(2, null);
        ps.setBigDecimal(3, null);
        ps.setBigDecimal(4, null);
        ps.executeUpdate();
        value = JDBC.vmSupportsJDBC4() ? new BigDecimal(new BigInteger("2"), -3) : new BigDecimal("2000");
        ps.setBigDecimal(1, value);
        ps.setBigDecimal(2, value);
        ps.setBigDecimal(3, value);
        ps.setBigDecimal(4, value);
        ps.executeUpdate();
        value = new BigDecimal("123.45");
        ps.setObject(1, (Object)value, 3, 2);
        ps.setObject(2, (Object)value, 3, 2);
        ps.setObject(3, (Object)value, 3, 2);
        ps.setObject(4, (Object)value, 3, 2);
        ps.executeUpdate();
        ps.setObject(1, (Object)value, 3, 0);
        ps.setObject(2, (Object)value, 3, 0);
        ps.setObject(3, (Object)value, 3, 0);
        ps.setObject(4, (Object)value, 3, 0);
        ps.executeUpdate();
        ps.setObject(1, (Object)value, 3);
        ps.setObject(2, (Object)value, 3);
        ps.setObject(3, (Object)value, 3);
        ps.setObject(4, (Object)value, 3);
        ps.executeUpdate();
        ps.setObject(1, value);
        ps.setObject(2, value);
        ps.setObject(3, value);
        ps.setObject(4, value);
        ps.executeUpdate();
        value = JDBC.vmSupportsJDBC4() ? new BigDecimal(new BigInteger("2"), -3) : new BigDecimal("2000");
        ps.setObject(1, value);
        ps.setObject(2, value);
        ps.setObject(3, value);
        ps.setObject(4, value);
        ps.executeUpdate();
        ResultSet rs = s.executeQuery("SELECT * FROM DERBY_2073_TAB");
        String[][] expectedResults = new String[][]{{"123.45", "123.45", "123.45", "123"}, {null, null, null, null}, {"2000.00", "2000.0", "2000.0", "2000"}, {"123.45", "123.45", "123.45", "123"}, {"123.00", "123.0", "123.0", "123"}, {"123.00", "123.0", "123.0", "123"}, {"123.45", "123.45", "123.45", "123"}, {"2000.00", "2000.0", "2000.0", "2000"}};
        if (ParameterMappingTest.usingDerbyNetClient()) {
            JDBC.assertFullResultSet(rs, expectedResults);
        }
        s.executeUpdate("DROP TABLE DERBY_2073_TAB");
    }

    public void testParameterMapping() throws Exception {
        Connection conn = this.getConnection();
        for (int type = 0; type < SQLTypes.length; ++type) {
            String sqlType = SQLTypes[type];
            if (sqlType == null || jdbcTypes[type] == 0) continue;
            Statement s = conn.createStatement();
            try {
                s.execute("DROP TABLE PM.TYPE_AS");
            }
            catch (SQLException seq) {
                // empty catch block
            }
            s.execute("CREATE TABLE PM.TYPE_AS(VAL " + SQLTypes[type] + ")");
            PreparedStatement psi = conn.prepareStatement("INSERT INTO PM.TYPE_AS(VAL) VALUES(?)");
            psi.setNull(1, jdbcTypes[type]);
            psi.executeUpdate();
            PreparedStatement psq = conn.prepareStatement("SELECT VAL FROM PM.TYPE_AS");
            ResultSet rs = psq.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            ParameterMappingTest.assertEquivalentDataType(jdbcTypes[type], rsmd.getColumnType(1));
            rs.close();
            ParameterMappingTest.getXXX(psq, type, true);
            s.execute("DELETE FROM PM.TYPE_AS");
            if (ParameterMappingTest.setValidValue(psi, 1, jdbcTypes[type])) {
                psi.executeUpdate();
                ParameterMappingTest.getXXX(psq, type, false);
            }
            ParameterMappingTest.setXXX(s, psi, psq, type);
            psi.close();
            psq.close();
            s.execute("DROP TABLE PM.TYPE_AS");
            conn.commit();
            try {
                s.execute("DROP PROCEDURE PMP.TYPE_AS");
            }
            catch (SQLException seq) {
                // empty catch block
            }
            String procSQL = "CREATE PROCEDURE PMP.TYPE_AS(IN P1 " + SQLTypes[type] + ", INOUT P2 " + SQLTypes[type] + ", OUT P3 " + SQLTypes[type] + ") LANGUAGE JAVA PARAMETER STYLE JAVA NO SQL " + " EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.jdbcapi.ParameterMappingTest.pmap'";
            try {
                if (!HAVE_BIG_DECIMAL && SQLTypes[type].equals("DECIMAL(10,5)")) continue;
                s.execute(procSQL);
            }
            catch (SQLException sqle) {
                if ("42962".equals(sqle.getSQLState())) continue;
                ParameterMappingTest.fail((String)(sqle.getSQLState() + ":" + sqle.getMessage()));
                continue;
            }
            for (int opt = 0; opt < jdbcTypes.length; ++opt) {
                int jopt = jdbcTypes[opt];
                if (jopt == 0) continue;
                CallableStatement csp = conn.prepareCall("CALL PMP.TYPE_AS(?, ?, ?)");
                boolean bothRegistered = true;
                try {
                    csp.registerOutParameter(2, jopt);
                }
                catch (SQLException sqle) {
                    ParameterMappingTest.assertFalse((String)("INOUT " + sqlType + " registerOutParameter(" + JDBC.sqlNameFromJdbc(jopt) + ") failed"), (boolean)allowRegisterOut[type][opt]);
                    if (!"XCL25".equals(sqle.getSQLState())) {
                        ParameterMappingTest.fail((String)("-- " + sqle.getSQLState()));
                    }
                    bothRegistered = false;
                }
                try {
                    csp.registerOutParameter(3, jopt);
                }
                catch (SQLException sqle) {
                    if (!"XCL25".equals(sqle.getSQLState())) {
                        ParameterMappingTest.fail((String)("-- " + sqle.getSQLState()));
                    }
                    ParameterMappingTest.assertFalse((String)("OUT " + sqlType + " registerOutParameter(" + JDBC.sqlNameFromJdbc(jopt) + "failed"), (boolean)allowRegisterOut[type][opt]);
                    bothRegistered = false;
                }
                if (bothRegistered) {
                    try {
                        if (ParameterMappingTest.setValidValue(csp, 1, jdbcTypes[type]) && ParameterMappingTest.setValidValue(csp, 2, jopt)) {
                            csp.execute();
                            ParameterMappingTest.getOutValue(csp, 2, jopt, type);
                            ParameterMappingTest.getOutValue(csp, 3, jopt, type);
                        }
                    }
                    catch (SQLException sqle) {
                        boolean expectedConversionError = "22018".equals(sqle.getSQLState()) || "22007".equals(sqle.getSQLState()) || "22005".equals(sqle.getSQLState());
                        ParameterMappingTest.assertTrue((String)("FAIL: Unexpected exception" + sqle.getSQLState() + ":" + sqle.getMessage()), (boolean)expectedConversionError);
                    }
                }
                csp.close();
            }
            s.execute("DROP PROCEDURE PMP.TYPE_AS");
            s.close();
            conn.commit();
        }
    }

    protected void tearDown() throws Exception {
        Connection conn = this.getConnection();
        Statement scb = conn.createStatement();
        scb.execute("DROP TABLE PM.LOB_GET");
        scb.close();
        this.commit();
    }

    private static void getXXX(PreparedStatement ps, int type, boolean isNull) throws SQLException, IOException {
        boolean worked;
        int jdbcType;
        boolean worked2;
        boolean wn;
        boolean worked3;
        boolean wn2;
        ResultSet rs = ps.executeQuery();
        rs.next();
        SQLException sqleResult = null;
        try {
            byte b = rs.getByte(1);
            wn2 = rs.wasNull();
            if (isNull) {
                ParameterMappingTest.assertTrue((boolean)wn2);
            } else {
                ParameterMappingTest.assertFalse((boolean)wn2);
                ParameterMappingTest.assertEquals((int)32, (int)b);
            }
            worked3 = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked3 = false;
        }
        rs.close();
        ParameterMappingTest.judge_getXXX(worked3, sqleResult, 0, type);
        rs = ps.executeQuery();
        rs.next();
        sqleResult = null;
        try {
            short s = rs.getShort(1);
            wn2 = rs.wasNull();
            if (isNull) {
                ParameterMappingTest.assertTrue((boolean)wn2);
            } else {
                ParameterMappingTest.assertFalse((boolean)wn2);
                ParameterMappingTest.assertEquals((int)32, (int)s);
            }
            worked3 = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked3 = false;
        }
        rs.close();
        ParameterMappingTest.judge_getXXX(worked3, sqleResult, 1, type);
        rs = ps.executeQuery();
        rs.next();
        sqleResult = null;
        try {
            int i = rs.getInt(1);
            wn2 = rs.wasNull();
            if (isNull) {
                ParameterMappingTest.assertTrue((boolean)wn2);
            } else {
                ParameterMappingTest.assertFalse((boolean)isNull);
                ParameterMappingTest.assertEquals((int)32, (int)i);
            }
            worked3 = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked3 = false;
        }
        rs.close();
        ParameterMappingTest.judge_getXXX(worked3, sqleResult, 2, type);
        rs = ps.executeQuery();
        rs.next();
        sqleResult = null;
        try {
            long l = rs.getLong(1);
            wn = rs.wasNull();
            if (isNull) {
                ParameterMappingTest.assertTrue((boolean)wn);
            } else {
                ParameterMappingTest.assertEquals((long)32L, (long)l);
                ParameterMappingTest.assertFalse((boolean)wn);
            }
            worked3 = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked3 = false;
        }
        rs.close();
        ParameterMappingTest.judge_getXXX(worked3, sqleResult, 3, type);
        rs = ps.executeQuery();
        rs.next();
        sqleResult = null;
        try {
            float f = rs.getFloat(1);
            wn2 = rs.wasNull();
            if (isNull) {
                ParameterMappingTest.assertTrue((boolean)wn2);
            } else {
                ParameterMappingTest.assertFalse((boolean)wn2);
                ParameterMappingTest.assertEquals((double)32.0, (double)f, (double)1.0E-6);
            }
            worked3 = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked3 = false;
        }
        rs.close();
        ParameterMappingTest.judge_getXXX(worked3, sqleResult, 4, type);
        rs = ps.executeQuery();
        rs.next();
        SQLException sqleResult2 = null;
        try {
            double d = rs.getDouble(1);
            wn = rs.wasNull();
            if (isNull) {
                ParameterMappingTest.assertTrue((boolean)wn);
            } else {
                ParameterMappingTest.assertFalse((boolean)wn);
                ParameterMappingTest.assertEquals((double)32.0, (double)d, (double)1.0E-5);
            }
            worked2 = true;
        }
        catch (SQLException sqle) {
            sqleResult2 = sqle;
            worked2 = false;
        }
        rs.close();
        ParameterMappingTest.judge_getXXX(worked2, sqleResult2, 5, type);
        if (HAVE_BIG_DECIMAL) {
            rs = ps.executeQuery();
            rs.next();
            sqleResult = null;
            try {
                BigDecimal bd = rs.getBigDecimal(1);
                wn2 = rs.wasNull();
                if (isNull) {
                    ParameterMappingTest.assertTrue((boolean)wn2);
                    ParameterMappingTest.assertNull((Object)bd);
                } else {
                    ParameterMappingTest.assertFalse((boolean)wn2);
                    ParameterMappingTest.assertEquals((String)"BigDecimal comparison failed", (int)0, (int)new BigDecimal("32.0").compareTo(bd));
                }
                worked = true;
            }
            catch (SQLException sqle) {
                sqleResult = sqle;
                worked = false;
            }
            rs.close();
            ParameterMappingTest.judge_getXXX(worked, sqleResult, 6, type);
        }
        rs = ps.executeQuery();
        rs.next();
        sqleResult = null;
        try {
            boolean b = rs.getBoolean(1);
            wn2 = rs.wasNull();
            if (isNull) {
                ParameterMappingTest.assertTrue((boolean)wn2);
            } else {
                ParameterMappingTest.assertFalse((boolean)wn2);
                ParameterMappingTest.assertTrue((boolean)b);
            }
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        rs.close();
        ParameterMappingTest.judge_getXXX(worked, sqleResult, 7, type);
        rs = ps.executeQuery();
        rs.next();
        sqleResult = null;
        try {
            String s = rs.getString(1);
            wn2 = rs.wasNull();
            if (isNull) {
                ParameterMappingTest.assertNull((Object)s);
                ParameterMappingTest.assertTrue((boolean)wn2);
            } else {
                s = s.trim();
                jdbcType = jdbcTypes[type];
                switch (jdbcType) {
                    case -5: 
                    case -1: 
                    case 1: 
                    case 4: 
                    case 5: 
                    case 12: {
                        ParameterMappingTest.assertEquals((String)"32", (String)s);
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        ParameterMappingTest.assertEquals((String)"32.0", (String)s);
                        break;
                    }
                    case 2: 
                    case 3: {
                        ParameterMappingTest.assertEquals((String)"32.00000", (String)s);
                        break;
                    }
                    case -3: 
                    case -2: {
                        ParameterMappingTest.assertEquals((String)"0403fdc373", (String)s);
                        break;
                    }
                    case 91: {
                        ParameterMappingTest.assertEquals((String)"2004-02-14", (String)s);
                        break;
                    }
                    case 92: {
                        ParameterMappingTest.assertEquals((String)"17:14:24", (String)s);
                        break;
                    }
                    case 93: {
                        if (ParameterMappingTest.usingEmbedded()) {
                            ParameterMappingTest.assertEquals((String)"2004-02-14 17:14:24.097625551", (String)s);
                            break;
                        }
                        ParameterMappingTest.assertEquals((String)"2004-02-14 17:14:24.097625", (String)s);
                        break;
                    }
                    case 2005: {
                        ParameterMappingTest.assertEquals((String)"67", (String)s);
                        break;
                    }
                    case 2004: {
                        ParameterMappingTest.assertEquals((String)"8243cafe0032", (String)s);
                    }
                }
                ParameterMappingTest.assertFalse((boolean)wn2);
            }
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        rs.close();
        ParameterMappingTest.judge_getXXX(worked, sqleResult, 8, type);
        rs = ps.executeQuery();
        rs.next();
        sqleResult = null;
        try {
            byte[] data = rs.getBytes(1);
            wn2 = rs.wasNull();
            if (isNull) {
                ParameterMappingTest.assertNull((Object)data);
                ParameterMappingTest.assertTrue((boolean)wn2);
            } else {
                jdbcType = jdbcTypes[type];
                switch (jdbcType) {
                    case -4: 
                    case -3: 
                    case -2: {
                        ParameterMappingTest.assertEquals((String)"0x4,0x3", (String)ParameterMappingTest.showFirstTwo(data));
                        break;
                    }
                    case 2004: {
                        ParameterMappingTest.assertEquals((String)"0x82,0x43", (String)ParameterMappingTest.showFirstTwo(data));
                    }
                }
                ParameterMappingTest.assertNotNull((Object)data);
                ParameterMappingTest.assertFalse((boolean)wn2);
            }
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        rs.close();
        ParameterMappingTest.judge_getXXX(worked, sqleResult, 9, type);
        sqleResult = null;
        ResultSet rs2 = null;
        try {
            rs2 = ps.executeQuery();
            rs2.next();
            Date d = rs2.getDate(1);
            wn2 = rs2.wasNull();
            if (isNull) {
                ParameterMappingTest.assertNull((Object)d);
                ParameterMappingTest.assertTrue((boolean)wn2);
            } else {
                ParameterMappingTest.assertEquals((String)"2004-02-14", (String)d.toString());
                ParameterMappingTest.assertNotNull((Object)d);
                ParameterMappingTest.assertFalse((boolean)wn2);
            }
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = "22007".equals(sqle.getSQLState());
        }
        catch (Throwable t) {
            worked = false;
        }
        if (rs2 != null) {
            rs2.close();
        }
        ParameterMappingTest.judge_getXXX(worked, sqleResult, 10, type);
        sqleResult = null;
        rs2 = null;
        try {
            rs2 = ps.executeQuery();
            rs2.next();
            Time t = rs2.getTime(1);
            wn2 = rs2.wasNull();
            if (isNull) {
                ParameterMappingTest.assertNull((Object)t);
                ParameterMappingTest.assertTrue((boolean)wn2);
            } else {
                ParameterMappingTest.assertFalse((boolean)wn2);
                ParameterMappingTest.assertEquals((String)"17:14:24", (String)t.toString());
            }
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = "22007".equals(sqle.getSQLState());
        }
        catch (Throwable t) {
            worked = false;
        }
        if (rs2 != null) {
            rs2.close();
        }
        ParameterMappingTest.judge_getXXX(worked, sqleResult, 11, type);
        sqleResult = null;
        rs2 = null;
        try {
            rs2 = ps.executeQuery();
            rs2.next();
            Timestamp ts = rs2.getTimestamp(1);
            wn2 = rs2.wasNull();
            if (isNull) {
                ParameterMappingTest.assertNull((Object)ts);
                ParameterMappingTest.assertTrue((boolean)wn2);
            } else {
                if (type == 91 || type == 93) {
                    ParameterMappingTest.assertEquals((String)"2004-02-14 00:00:00.0", (String)ts.toString());
                }
                ParameterMappingTest.assertFalse((boolean)rs2.wasNull());
            }
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = "22007".equals(sqle.getSQLState());
        }
        catch (Throwable t) {
            worked = false;
        }
        if (rs2 != null) {
            rs2.close();
        }
        ParameterMappingTest.judge_getXXX(worked, sqleResult, 12, type);
        rs = ps.executeQuery();
        rs.next();
        sqleResult = null;
        try {
            InputStream is = rs.getAsciiStream(1);
            wn2 = rs.wasNull();
            if (isNull) {
                ParameterMappingTest.assertTrue((boolean)wn2);
                ParameterMappingTest.assertNull((Object)is);
            } else {
                ParameterMappingTest.assertFalse((boolean)wn2);
                if (B6[13][type]) {
                    ParameterMappingTest.assertNotNull((Object)ParameterMappingTest.showFirstTwo(is));
                }
            }
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        boolean judge = B6[13][type] || ParameterMappingTest.specificCheck(rs, worked, sqleResult, isNull);
        rs.close();
        if (judge) {
            ParameterMappingTest.judge_getXXX(worked, sqleResult, 13, type);
        }
        rs = ps.executeQuery();
        rs.next();
        sqleResult = null;
        try {
            InputStream is = rs.getBinaryStream(1);
            if (isNull) {
                ParameterMappingTest.assertTrue((boolean)rs.wasNull());
                ParameterMappingTest.assertNull((Object)is);
            } else if (B6[14][type]) {
                ParameterMappingTest.assertNotNull((Object)ParameterMappingTest.showFirstTwo(is));
            }
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        judge = B6[14][type] || ParameterMappingTest.specificCheck(rs, worked, sqleResult, isNull);
        rs.close();
        if (judge) {
            ParameterMappingTest.judge_getXXX(worked, sqleResult, 14, type);
        }
        rs = ps.executeQuery();
        rs.next();
        sqleResult = null;
        try {
            Reader r = rs.getCharacterStream(1);
            wn2 = rs.wasNull();
            if (isNull) {
                ParameterMappingTest.assertNull((Object)r);
                ParameterMappingTest.assertTrue((boolean)wn2);
            } else if (B6[15][type]) {
                ParameterMappingTest.assertFalse((boolean)wn2);
                ParameterMappingTest.assertNotNull((Object)ParameterMappingTest.showFirstTwo(r));
            }
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        judge = B6[15][type] || ParameterMappingTest.specificCheck(rs, worked, sqleResult, isNull);
        rs.close();
        if (judge) {
            ParameterMappingTest.judge_getXXX(worked, sqleResult, 15, type);
        }
        rs = ps.executeQuery();
        rs.next();
        sqleResult = null;
        try {
            Clob clob = rs.getClob(1);
            wn2 = rs.wasNull();
            if (isNull) {
                ParameterMappingTest.assertNull((Object)clob);
                ParameterMappingTest.assertTrue((boolean)wn2);
            } else if (B6[16][type]) {
                ParameterMappingTest.assertFalse((boolean)wn2);
                ParameterMappingTest.assertNotNull((Object)clob.getSubString(1L, 10));
            }
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        judge = B6[16][type] || ParameterMappingTest.specificCheck(rs, worked, sqleResult, isNull);
        rs.close();
        if (judge) {
            ParameterMappingTest.judge_getXXX(worked, sqleResult, 16, type);
        }
        rs = ps.executeQuery();
        rs.next();
        sqleResult = null;
        try {
            Blob blob = rs.getBlob(1);
            wn2 = rs.wasNull();
            if (isNull) {
                ParameterMappingTest.assertTrue((boolean)wn2);
                ParameterMappingTest.assertNull((Object)blob);
            } else if (B6[17][type]) {
                ParameterMappingTest.assertNotNull((Object)ParameterMappingTest.showFirstTwo(blob.getBinaryStream()));
            }
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        judge = B6[17][type] || ParameterMappingTest.specificCheck(rs, worked, sqleResult, isNull);
        rs.close();
        if (judge) {
            ParameterMappingTest.judge_getXXX(worked, sqleResult, 17, type);
        }
        rs = ps.executeQuery();
        rs.next();
        sqleResult = null;
        try {
            InputStream is = rs.getUnicodeStream(1);
            wn2 = rs.wasNull();
            if (isNull) {
                ParameterMappingTest.assertTrue((boolean)wn2);
                ParameterMappingTest.assertNull((Object)is);
            } else {
                ParameterMappingTest.assertFalse((boolean)wn2);
                ParameterMappingTest.assertNotNull((Object)is);
            }
            worked = true;
        }
        catch (NoSuchMethodError e) {
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        rs.close();
        if (JDBC.vmSupportsJDBC2()) {
            ParameterMappingTest.judge_getXXX(worked, sqleResult, 18, type);
        }
        rs = ps.executeQuery();
        rs.next();
        sqleResult = null;
        try {
            if (!SQLTypes[type].equals("DECIMAL(10,5)") || HAVE_BIG_DECIMAL) {
                Object o = rs.getObject(1);
                wn2 = rs.wasNull();
                Class cgo = B3_GET_OBJECT[type];
                if (cgo.equals([B.class)) {
                    String cname = "byte[]";
                } else {
                    String cname = cgo.getName();
                }
                if (isNull) {
                    ParameterMappingTest.assertTrue((boolean)wn2);
                    ParameterMappingTest.assertNull((Object)o);
                    worked = true;
                } else if (cgo.isInstance(o)) {
                    worked = true;
                } else {
                    worked = false;
                    ParameterMappingTest.fail((String)("FAIL NOT :" + cgo.getName() + " is " + o.getClass().getName()));
                }
            } else {
                worked = true;
            }
            ParameterMappingTest.assertTrue((boolean)worked);
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
        }
        rs.close();
    }

    private static boolean specificCheck(ResultSet rs, boolean worked, SQLException sqleResult, boolean isNull) throws SQLException {
        boolean judge = true;
        if (worked && isNull && rs.wasNull()) {
            if (ParameterMappingTest.usingDerbyNetClient()) {
                judge = false;
            }
        } else if (!worked && isNull && ParameterMappingTest.usingDerbyNetClient() && "22005".equals(sqleResult.getSQLState())) {
            judge = false;
        }
        return judge;
    }

    private static void judge_getXXX(boolean worked, SQLException sqleResult, int whichCall, int type) {
        boolean validSQLState = false;
        if (B6[whichCall][type] && !worked) {
            ParameterMappingTest.fail((String)(" JDBC FAIL " + SQLTypes[type] + " " + sqleResult));
        } else if (!worked) {
            String sqlState = sqleResult.getSQLState();
            if ("0A000".equals(sqlState)) {
                validSQLState = true;
            }
            if ("0A000".equals(sqlState)) {
                validSQLState = true;
            }
            if ("22005".equals(sqlState)) {
                validSQLState = true;
            } else if (sqlState == null && sqleResult.getMessage().indexOf("Wrong result column type for requested conversion") != -1) {
                validSQLState = true;
            }
            ParameterMappingTest.assertTrue((String)("FAIL: Expected conversion error but got " + sqleResult), (boolean)validSQLState);
        }
    }

    private static void judge_setXXX(boolean worked, SQLException sqleResult, int whichCall, int type) {
        String msg;
        if (worked && B2_MOD[whichCall][type]) {
            msg = " JDBC MATCH(OK)";
        } else if (worked) {
            msg = " CLOUD EXT (OK)";
        } else if (sqleResult != null && "0A000".equals(sqleResult.getSQLState())) {
            msg = " Not Implemented (OK)";
        } else if (B2_MOD[whichCall][type]) {
            if (sqleResult != null) {
                ParameterMappingTest.showException(sqleResult);
            }
            msg = " JDBC FAIL " + SQLTypes[type];
        } else {
            msg = ParameterMappingTest.checkForInvalidConversion(sqleResult);
            if (msg == null) {
                return;
            }
        }
        if (msg.startsWith("JDBC FAIL")) {
            ParameterMappingTest.fail((String)(" JDBC FAIL " + SQLTypes[type]));
        }
    }

    private static void judge_setObject(boolean worked, SQLException sqleResult, int b5o, int type) {
        String msg;
        if (worked && B5[b5o][type]) {
            msg = " JDBC MATCH(OK)";
        } else if (worked) {
            msg = " CLOUD EXT (OK)";
        } else if ("0A000".equals(sqleResult.getSQLState())) {
            msg = " Not Implemented (OK)";
        } else if (B5[b5o][type]) {
            if (sqleResult != null) {
                ParameterMappingTest.showException(sqleResult);
            }
            msg = " JDBC FAIL " + SQLTypes[type];
        } else {
            msg = ParameterMappingTest.checkForInvalidConversion(sqleResult);
            if (msg == null) {
                return;
            }
        }
        if (msg.startsWith("JDBC FAIL")) {
            ParameterMappingTest.fail((String)(" JDBC FAIL " + SQLTypes[type]));
        }
    }

    private static String checkForInvalidConversion(SQLException sqle) {
        if (sqle == null) {
            return null;
        }
        boolean unknownException = true;
        for (SQLException e = sqle; e != null && unknownException; e = e.getNextException()) {
            if (!"22005".equals(e.getSQLState()) && !"XCL12".equals(e.getSQLState()) && e.getMessage().indexOf("Illegal Conv") == -1) continue;
            unknownException = false;
            if (!"0A000".equals(e.getSQLState()) || e.getMessage().indexOf("setUnicodeStream") == -1) break;
            unknownException = false;
            break;
        }
        if (unknownException) {
            ParameterMappingTest.showException(sqle);
        }
        return " JDBC MATCH (INVALID)";
    }

    private static void setXXX(Statement s, PreparedStatement psi, PreparedStatement psq, int type) throws SQLException, IOException {
        Object tester;
        ResultSet rsc;
        byte[] data;
        boolean worked;
        s.execute("DELETE FROM PM.TYPE_AS");
        SQLException sqleResult = null;
        try {
            psi.setByte(1, (byte)98);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setByte");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 0, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setByte(1, (byte)98);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setByte");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 0, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setShort(1, (short)98);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setShort");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 1, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setShort(1, (short)98);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setShort");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 1, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setInt(1, 98);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setInt");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 2, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setInt(1, 98);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setInt");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 2, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setLong(1, 98L);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setLong");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 3, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setLong(1, 98L);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setLong");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 3, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setFloat(1, 98.4f);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setFloat");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 4, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setFloat(1, 98.4f);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setFloat");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 4, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setDouble(1, 98.5);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setDouble");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 5, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setDouble(1, 98.5);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setDouble");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 5, type);
        if (HAVE_BIG_DECIMAL) {
            s.execute("DELETE FROM PM.TYPE_AS");
            sqleResult = null;
            try {
                psi.setBigDecimal(1, new BigDecimal(98.0));
                psi.executeUpdate();
                ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBigDecimal");
                worked = true;
            }
            catch (SQLException sqle) {
                sqleResult = sqle;
                worked = false;
            }
            ParameterMappingTest.judge_setXXX(worked, sqleResult, 6, type);
            s.execute("DELETE FROM PM.TYPE_AS");
            sqleResult = null;
            try {
                psi.setBigDecimal(1, new BigDecimal(98.0));
                psi.addBatch();
                psi.executeBatch();
                ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBigDecimal");
                worked = true;
            }
            catch (SQLException sqle) {
                sqleResult = sqle;
                worked = false;
            }
            ParameterMappingTest.judge_setXXX(worked, sqleResult, 6, type);
            s.execute("DELETE FROM PM.TYPE_AS");
            sqleResult = null;
            try {
                psi.setBigDecimal(1, null);
                psi.executeUpdate();
                ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBigDecimal");
                worked = true;
            }
            catch (SQLException sqle) {
                sqleResult = sqle;
                worked = false;
            }
            ParameterMappingTest.judge_setXXX(worked, sqleResult, 6, type);
            s.execute("DELETE FROM PM.TYPE_AS");
            sqleResult = null;
            try {
                psi.setBigDecimal(1, null);
                psi.addBatch();
                psi.executeBatch();
                ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBigDecimal");
                worked = true;
            }
            catch (SQLException sqle) {
                sqleResult = sqle;
                worked = false;
            }
            ParameterMappingTest.judge_setXXX(worked, sqleResult, 6, type);
        }
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setBoolean(1, true);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBoolean");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 7, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setBoolean(1, true);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBoolean");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 7, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setString(1, validString[type]);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setString");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        catch (Throwable t) {
            worked = false;
            sqleResult = null;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 8, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setString(1, validString[type]);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setString");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        catch (Throwable t) {
            worked = false;
            sqleResult = null;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 8, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setString(1, null);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setString");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        catch (Throwable t) {
            worked = false;
            sqleResult = null;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 8, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setString(1, null);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setString");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        catch (Throwable t) {
            worked = false;
            sqleResult = null;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 8, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        ParameterMappingTest.testSetStringInvalidValue(type, psi);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            data = new byte[]{4, 3, -3, -61, 115};
            psi.setBytes(1, data);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBytes");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 9, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            data = new byte[]{4, 3, -3, -61, 115};
            psi.setBytes(1, data);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBytes");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 9, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setBytes(1, null);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBytes");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 9, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setBytes(1, null);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBytes");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 9, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setDate(1, Date.valueOf("2004-02-14"));
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setDate");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 10, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setDate(1, Date.valueOf("2004-02-14"));
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setDate");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 10, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setDate(1, null);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setDate");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 10, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setDate(1, null);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setDate");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 10, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setTime(1, Time.valueOf("00:00:00"));
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setTime");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 11, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setTime(1, Time.valueOf("00:00:00"));
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setTime");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 11, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setTime(1, null);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setTime");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 11, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setTime(1, null);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setTime");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 11, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setTimestamp(1, Timestamp.valueOf("2004-02-14 00:00:00.0"));
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setTimestamp");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 12, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setTimestamp(1, Timestamp.valueOf("2004-02-14 00:00:00.0"));
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setTimestamp");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 12, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setTimestamp(1, null);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setTimestamp");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 12, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setTimestamp(1, null);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setTimestamp");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 12, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            data = new byte[]{101, 103, 48, 49, 50, 100};
            psi.setAsciiStream(1, (InputStream)new ByteArrayInputStream(data), 6);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setAsciiStream");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 13, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            data = new byte[]{101, 103, 48, 49, 50, 100};
            psi.setAsciiStream(1, (InputStream)new ByteArrayInputStream(data), 6);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setAsciiStream");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 13, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setAsciiStream(1, (InputStream)null, 0);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setAsciiStream");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 13, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setAsciiStream(1, (InputStream)null, 0);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setAsciiStream");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 13, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            data = new byte[]{4, 3, -54, -2, 0, 50};
            psi.setBinaryStream(1, (InputStream)new ByteArrayInputStream(data), 6);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBinaryStream");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 14, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            data = new byte[]{4, 3, -54, -2, 0, 50};
            psi.setBinaryStream(1, (InputStream)new ByteArrayInputStream(data), 6);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "getBinaryStream");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 14, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setBinaryStream(1, (InputStream)null, 0);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBinaryStream");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 14, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setBinaryStream(1, (InputStream)null, 0);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBinaryStream");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 14, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setCharacterStream(1, (Reader)new StringReader("89"), 2);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setCharacterStream");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 15, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setCharacterStream(1, (Reader)new StringReader("89"), 2);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setCharacterStream");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 15, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setCharacterStream(1, (Reader)null, 0);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setCharacterStream");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 15, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setCharacterStream(1, (Reader)null, 0);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setCharacterStream");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 15, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            rsc = s.executeQuery("SELECT C FROM PM.LOB_GET WHERE ID = 1");
            rsc.next();
            tester = rsc.getClob(1);
            rsc.close();
            psi.setClob(1, (Clob)tester);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setClob");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 16, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            rsc = s.executeQuery("SELECT C FROM PM.LOB_GET WHERE ID = 1");
            rsc.next();
            tester = rsc.getClob(1);
            rsc.close();
            psi.setClob(1, (Clob)tester);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setClob");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 16, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setClob(1, (Clob)null);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setClob");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 16, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setClob(1, (Clob)null);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setClob");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 16, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            rsc = s.executeQuery("SELECT B FROM PM.LOB_GET WHERE ID = 1");
            rsc.next();
            tester = rsc.getBlob(1);
            rsc.close();
            psi.setBlob(1, (Blob)tester);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBlob");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 17, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            rsc = s.executeQuery("SELECT B FROM PM.LOB_GET WHERE ID = 1");
            rsc.next();
            tester = rsc.getBlob(1);
            rsc.close();
            psi.setBlob(1, (Blob)tester);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBlob");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 17, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setBlob(1, (Blob)null);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBlob");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 17, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setBlob(1, (Blob)null);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBlob");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 17, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            data = new byte[]{4, 3, -54, -2, 0, 50};
            try {
                psi.setUnicodeStream(1, new ByteArrayInputStream(data), 6);
            }
            catch (NoSuchMethodError e) {
                // empty catch block
            }
            if (JDBC.vmSupportsJDBC2()) {
                psi.executeUpdate();
                ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setUnicodeStream");
            }
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        if (JDBC.vmSupportsJDBC2()) {
            ParameterMappingTest.judge_setXXX(worked, sqleResult, 14, type);
        }
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setObject(1, null);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setObject");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        if (worked) {
            ParameterMappingTest.fail((String)"FAIL: setObject(null) not valid");
        }
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setObject(1, null);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setObject");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        if (worked) {
            ParameterMappingTest.fail((String)"FAIL: setObject(1,null) did not throw exception");
        }
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, validString[type], "java.lang.String", 0);
        if (HAVE_BIG_DECIMAL) {
            ParameterMappingTest.setXXX_setObject(s, psi, psq, type, BigDecimal.valueOf(98L), "java.math.BigDecimal", 1);
        }
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, Boolean.TRUE, "java.lang.Boolean", 2);
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, new Byte(98), "java.lang.Byte", 1);
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, new Short(98), "java.lang.Short", 2);
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, new Integer(98), "java.lang.Integer", 3);
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, new Long(98L), "java.lang.Long", 4);
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, new Float(98.0f), "java.lang.Float", 5);
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, new Double(98.0), "java.lang.Double", 6);
        byte[] data2 = new byte[]{4, 3};
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, data2, "byte[]", 7);
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, Date.valueOf("2004-02-14"), "java.sql.Date", 8);
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, Time.valueOf("00:00:00"), "java.sql.Time", 9);
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, Timestamp.valueOf("2004-02-14 00:00:00.0"), "java.sql.Timestamp", 10);
        s.getConnection().commit();
        ResultSet rsc2 = s.executeQuery("SELECT B FROM PM.LOB_GET WHERE ID = 1");
        rsc2.next();
        Object tester2 = rsc2.getBlob(1);
        rsc2.close();
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, tester2, "java.sql.Blob", 11);
        rsc2 = s.executeQuery("SELECT C FROM PM.LOB_GET WHERE ID = 1");
        rsc2.next();
        tester2 = rsc2.getClob(1);
        rsc2.close();
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, tester2, "java.sql.Clob", 12);
    }

    private static void setXXX_setObject(Statement s, PreparedStatement psi, PreparedStatement psq, int type, Object value, String className, int b5o) throws SQLException, IOException {
        boolean worked;
        s.execute("DELETE FROM PM.TYPE_AS");
        SQLException sqleResult = null;
        try {
            psi.setObject(1, value);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setObject(" + className + ")");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setObject(worked, sqleResult, b5o, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setObject(1, value);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setObject(" + className + ")");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        catch (Throwable t) {
            ParameterMappingTest.fail((String)("FAIL " + t.getMessage()));
            return;
        }
        ParameterMappingTest.judge_setObject(worked, sqleResult, b5o, type);
    }

    private static void unexpectedException(SQLException sqle) {
        ParameterMappingTest.fail((String)"FAIL unexpected exception - ");
        ParameterMappingTest.showException(sqle);
        sqle.printStackTrace(System.out);
    }

    private static void showException(SQLException sqle) {
        do {
            String msg;
            String state;
            if ((state = sqle.getSQLState()) == null) {
                state = "?????";
            }
            if ((msg = sqle.getMessage()) == null) {
                msg = "?? no message ??";
            }
            sqle.printStackTrace();
            ParameterMappingTest.fail((String)(" (" + state + "):" + msg));
        } while ((sqle = sqle.getNextException()) != null);
    }

    private static boolean setValidValue(PreparedStatement ps, int param, int jdbcType) throws SQLException {
        switch (jdbcType) {
            case -7: {
                ps.setBoolean(param, true);
                return true;
            }
            case -6: {
                ps.setByte(param, (byte)32);
                return true;
            }
            case 5: {
                ps.setShort(param, (short)32);
                return true;
            }
            case 4: {
                ps.setInt(param, 32);
                return true;
            }
            case -5: {
                ps.setLong(param, 32L);
                return true;
            }
            case 7: {
                ps.setFloat(param, 32.0f);
                return true;
            }
            case 6: 
            case 8: {
                ps.setDouble(param, 32.0);
                return true;
            }
            case 3: {
                BigDecimalHandler.setBigDecimalString(ps, param, "32.0");
                return true;
            }
            case -1: 
            case 1: 
            case 12: {
                ps.setString(param, "32");
                return true;
            }
            case -3: 
            case -2: {
                byte[] data = new byte[]{4, 3, -3, -61, 115};
                ps.setBytes(param, data);
                return true;
            }
            case 91: {
                ps.setDate(param, Date.valueOf("2004-02-14"));
                return true;
            }
            case 92: {
                ps.setTime(param, Time.valueOf("17:14:24"));
                return true;
            }
            case 93: {
                ps.setTimestamp(param, Timestamp.valueOf("2004-02-14 17:14:24.097625551"));
                return true;
            }
            case 2005: {
                ps.setCharacterStream(param, (Reader)new StringReader("67"), 2);
                return true;
            }
            case 2004: {
                byte[] data = new byte[]{-126, 67, -54, -2, 0, 50};
                ps.setBinaryStream(param, (InputStream)new ByteArrayInputStream(data), 6);
                return true;
            }
        }
        return false;
    }

    private static boolean getValidValue(PreparedStatement ps, int jdbcType, String method) throws SQLException, IOException {
        ResultSet rs = ps.executeQuery();
        rs.next();
        switch (jdbcType) {
            case 5: {
                short val = rs.getShort(1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertEquals((int)0, (int)val);
                } else if (ParameterMappingTest.isBooleanMethod(method)) {
                    ParameterMappingTest.assertEquals((int)1, (int)val);
                } else {
                    ParameterMappingTest.assertEquals((int)98, (int)val);
                }
                return true;
            }
            case 4: {
                int val = rs.getInt(1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertEquals((int)0, (int)val);
                } else if (ParameterMappingTest.isBooleanMethod(method)) {
                    ParameterMappingTest.assertEquals((int)1, (int)val);
                } else {
                    ParameterMappingTest.assertEquals((int)98, (int)val);
                }
                return true;
            }
            case -5: {
                long val = rs.getLong(1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertEquals((long)0L, (long)val);
                } else if (ParameterMappingTest.isBooleanMethod(method)) {
                    ParameterMappingTest.assertEquals((long)1L, (long)val);
                } else {
                    ParameterMappingTest.assertEquals((long)98L, (long)val);
                }
                return true;
            }
            case 7: {
                float val = rs.getFloat(1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertEquals((double)0.0, (double)val, (double)0.001);
                } else if (ParameterMappingTest.isBooleanMethod(method)) {
                    ParameterMappingTest.assertEquals((double)1.0, (double)val, (double)0.001);
                } else if (method.equals("setFloat")) {
                    ParameterMappingTest.assertEquals((double)98.4, (double)val, (double)0.001);
                } else if (method.equals("setDouble")) {
                    ParameterMappingTest.assertEquals((double)98.5, (double)val, (double)0.001);
                } else {
                    ParameterMappingTest.assertEquals((double)98.0, (double)val, (double)0.001);
                }
                return true;
            }
            case 6: 
            case 8: {
                double val = rs.getDouble(1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertEquals((double)0.0, (double)val, (double)0.001);
                } else if (ParameterMappingTest.isBooleanMethod(method)) {
                    ParameterMappingTest.assertEquals((double)1.0, (double)val, (double)0.001);
                } else if (method.equals("setFloat")) {
                    ParameterMappingTest.assertEquals((double)98.4, (double)val, (double)0.001);
                } else if (method.equals("setDouble")) {
                    ParameterMappingTest.assertEquals((double)98.5, (double)val, (double)0.001);
                } else {
                    ParameterMappingTest.assertEquals((double)98.0, (double)val, (double)0.001);
                }
                return true;
            }
            case 3: {
                String val = BigDecimalHandler.getBigDecimalString(rs, 1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertNull((Object)val);
                } else if (ParameterMappingTest.isBooleanMethod(method)) {
                    ParameterMappingTest.assertEquals((String)"1.00000", (String)val);
                } else if (method.equals("setFloat")) {
                    ParameterMappingTest.assertEquals((String)"98.40000", (String)val);
                } else if (method.equals("setDouble")) {
                    ParameterMappingTest.assertEquals((String)"98.50000", (String)val);
                } else {
                    ParameterMappingTest.assertEquals((String)"98.00000", (String)val);
                }
                return true;
            }
            case -1: 
            case 1: 
            case 12: {
                String s = rs.getString(1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertNull((Object)s);
                } else {
                    if (s.startsWith("com.ibm.db2.jcc.") || s.startsWith("org.apache.derby.client")) {
                        s = "<OBJECT.toString()>";
                    }
                    boolean hasNonAscii = false;
                    for (int si = 0; si < s.length(); ++si) {
                        char c = s.charAt(si);
                        if (c >= ' ' && c < '\u007f') continue;
                        hasNonAscii = true;
                        break;
                    }
                    if (hasNonAscii) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("EncodedString: >");
                        for (int si = 0; si < s.length(); ++si) {
                            sb.append(' ');
                            sb.append((int)s.charAt(si));
                        }
                        sb.append(" <");
                        s = sb.toString();
                    }
                    ParameterMappingTest.checkValidStringValue(method, s);
                }
                return true;
            }
            case -3: 
            case -2: {
                byte[] data = rs.getBytes(1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertNull((Object)data);
                } else {
                    ParameterMappingTest.assertEquals((String)"0x4,0x3", (String)ParameterMappingTest.showFirstTwo(data));
                }
                return true;
            }
            case -4: {
                InputStream is = rs.getBinaryStream(1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertNull((Object)is);
                } else {
                    ParameterMappingTest.assertEquals((String)"0x4,0x3", (String)ParameterMappingTest.showFirstTwo(is));
                }
                return true;
            }
            case 91: {
                Date d = rs.getDate(1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertNull((Object)d);
                } else {
                    ParameterMappingTest.assertEquals((Object)Date.valueOf("2004-02-14"), (Object)d);
                }
                return true;
            }
            case 92: {
                Time t = rs.getTime(1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertNull((Object)t);
                } else {
                    ParameterMappingTest.assertEquals((Object)Time.valueOf("00:00:00"), (Object)t);
                }
                return true;
            }
            case 93: {
                Timestamp ts = rs.getTimestamp(1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertNull((Object)rs.getTimestamp(1));
                } else {
                    ParameterMappingTest.assertEquals((Object)Timestamp.valueOf("2004-02-14 00:00:00.0"), (Object)ts);
                }
                return true;
            }
            case 2005: {
                Clob clob = rs.getClob(1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertNull((Object)clob);
                } else {
                    char[] charray = new char[20];
                    int numchar = clob.getCharacterStream().read(charray);
                    String s = new String(charray, 0, numchar);
                    if ("setString".equals(method)) {
                        ParameterMappingTest.assertEquals((String)"98", (String)s);
                    } else if ("setAsciiStream".equals(method)) {
                        ParameterMappingTest.assertEquals((String)"eg012d", (String)s);
                    } else if ("setCharacterStream".equals(method)) {
                        ParameterMappingTest.assertEquals((String)"89", (String)s);
                    } else if ("setClob".equals(method)) {
                        ParameterMappingTest.assertEquals((String)"72", (String)s);
                    } else if ("setObject(java.lang.String)".equals(method)) {
                        ParameterMappingTest.assertEquals((String)"98", (String)s);
                    } else if ("setObject(java.lang.Clob)".equals(method)) {
                        ParameterMappingTest.assertEquals((String)"72", (String)s);
                    }
                }
                return true;
            }
            case 2004: {
                Blob blob = rs.getBlob(1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertNull((Object)blob);
                } else {
                    ParameterMappingTest.assertEquals((String)"0x4,0x3", (String)ParameterMappingTest.showFirstTwo(blob.getBinaryStream()));
                }
                return true;
            }
        }
        ParameterMappingTest.fail((String)("FAIL JDBC TYPE IN getValidValue " + JDBC.sqlNameFromJdbc(jdbcType)));
        return false;
    }

    private static void checkValidStringValue(String method, String s) {
        s = s.trim();
        if ("setBoolean".equals(method) || "setObject(java.lang.Boolean)".equals(method)) {
            ParameterMappingTest.assertEquals((String)"1", (String)s);
        } else if ("setBytes".equals(method) || "setObject(byte[])".equals(method)) {
            ParameterMappingTest.assertEquals((String)"EncodedString: > 1027 ", (String)s.substring(0, 22));
        } else if ("setFloat".equals(method)) {
            ParameterMappingTest.assertEquals((String)"98.4", (String)s);
        } else if ("setDouble".equals(method)) {
            ParameterMappingTest.assertEquals((String)"98.5", (String)s);
        } else if ("setDate".equals(method) || "setObject(java.sql.Date)".equals(method)) {
            ParameterMappingTest.assertEquals((String)"2004-02-14", (String)s);
        } else if ("setTime".equals(method) || "setObject(java.sql.Time)".equals(method)) {
            ParameterMappingTest.assertEquals((String)"00:00:00", (String)s);
        } else if ("setTimestamp".equals(method) || "setObject(java.sql.Timestamp)".equals(method)) {
            ParameterMappingTest.assertEquals((String)"2004-02-14 00:00:00.0", (String)s);
        } else if ("setAsciiStream".equals(method)) {
            ParameterMappingTest.assertEquals((String)"eg012d", (String)s);
        } else if ("setCharacterStream".equals(method)) {
            ParameterMappingTest.assertEquals((String)"89", (String)s);
        } else if ("setObject(java.lang.Float)".equals(method) || "setObject(java.lang.Double)".equals(method)) {
            ParameterMappingTest.assertEquals((String)"98.0", (String)s);
        } else {
            ParameterMappingTest.assertEquals((String)"98", (String)s.trim());
        }
    }

    private static boolean isBooleanMethod(String method) {
        return method.equals("setBoolean") || method.equals("setObject(java.lang.Boolean)");
    }

    private static boolean getOutValue(CallableStatement cs, int param, int regJdbcType, int paramType) throws SQLException, IOException {
        int paramJdbcType = jdbcTypes[paramType];
        switch (regJdbcType) {
            case -7: {
                boolean val = cs.getBoolean(param);
                boolean wn = cs.wasNull();
                if (!wn) {
                    ParameterMappingTest.assertTrue((boolean)val);
                }
                return true;
            }
            case -6: {
                byte val = cs.getByte(param);
                boolean wn = cs.wasNull();
                if (!wn) {
                    ParameterMappingTest.checkProcedureOutput(param, paramType, val);
                }
                return true;
            }
            case 5: {
                short val = cs.getShort(param);
                boolean wn = cs.wasNull();
                if (!wn) {
                    ParameterMappingTest.checkProcedureOutput(param, paramType, val);
                }
                return true;
            }
            case 4: {
                int val = cs.getInt(param);
                boolean wn = cs.wasNull();
                if (!wn) {
                    ParameterMappingTest.checkProcedureOutput(param, paramType, val);
                }
                return true;
            }
            case -5: {
                long val = cs.getLong(param);
                boolean wn = cs.wasNull();
                if (!wn) {
                    ParameterMappingTest.checkProcedureOutput(param, paramType, val);
                }
                return true;
            }
            case 7: {
                float val = cs.getFloat(param);
                boolean wn = cs.wasNull();
                if (!wn) {
                    ParameterMappingTest.checkProcedureOutput(param, paramType, val);
                }
                return true;
            }
            case 6: 
            case 8: {
                double val = cs.getDouble(param);
                boolean wn = cs.wasNull();
                if (!wn) {
                    ParameterMappingTest.checkProcedureOutput(param, paramType, val);
                }
                return true;
            }
            case 3: {
                String val = BigDecimalHandler.getBigDecimalString(cs, param, regJdbcType);
                boolean wn = cs.wasNull();
                if (!wn) {
                    ParameterMappingTest.checkProcedureOutput(param, paramType, val);
                }
                return true;
            }
            case -1: 
            case 1: 
            case 12: {
                String val = cs.getString(param);
                boolean wn = cs.wasNull();
                if (!wn) {
                    ParameterMappingTest.checkProcedureOutput(param, paramType, val.trim());
                }
                return true;
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] data = cs.getBytes(param);
                boolean wn = cs.wasNull();
                if (!wn) {
                    ParameterMappingTest.checkProcedureOutput(param, paramType, data);
                }
                return true;
            }
            case 91: {
                Date val = cs.getDate(param);
                boolean wn = cs.wasNull();
                if (!wn) {
                    ParameterMappingTest.checkProcedureOutput(param, paramType, val);
                }
                return true;
            }
            case 92: {
                Time val = cs.getTime(param);
                boolean wn = cs.wasNull();
                if (!wn) {
                    ParameterMappingTest.checkProcedureOutput(param, paramType, val);
                }
                return true;
            }
            case 93: {
                Timestamp val = cs.getTimestamp(param);
                boolean wn = cs.wasNull();
                if (!wn) {
                    ParameterMappingTest.checkProcedureOutput(param, paramType, val);
                }
                return true;
            }
            case 2005: {
                Clob clob = cs.getClob(param);
                boolean wn = cs.wasNull();
                return true;
            }
            case 2004: {
                Blob blob = cs.getBlob(param);
                boolean wn = cs.wasNull();
                return true;
            }
        }
        ParameterMappingTest.fail((String)("FAIL JDBC TYPE IN getOutValue " + JDBC.sqlNameFromJdbc(regJdbcType)));
        return false;
    }

    private static void checkProcedureOutput(int param, int paramType, byte val) {
        ParameterMappingTest.checkProcedureOutput(param, paramType, (long)val);
    }

    private static void checkProcedureOutput(int param, int paramType, short val) {
        ParameterMappingTest.checkProcedureOutput(param, paramType, (long)val);
    }

    private static void checkProcedureOutput(int param, int paramType, int val) {
        ParameterMappingTest.checkProcedureOutput(param, paramType, (long)val);
    }

    private static void checkProcedureOutput(int param, int paramType, long val) {
        switch (jdbcTypes[paramType]) {
            case 5: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((long)38L, (long)val);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((long)77L, (long)val);
                break;
            }
            case 4: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((long)41L, (long)val);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((long)88L, (long)val);
                break;
            }
            case -5: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((long)40L, (long)val);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((long)99L, (long)val);
                break;
            }
            case 6: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((long)35L, (long)val);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((long)66L, (long)val);
                break;
            }
            case 7: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((long)41L, (long)val);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((long)88L, (long)val);
                break;
            }
            case 3: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((long)34L, (long)val);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((long)84L, (long)val);
                break;
            }
            case 8: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((long)35L, (long)val);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((long)66L, (long)val);
            }
        }
    }

    private static void checkProcedureOutput(int param, int paramType, float val) {
        ParameterMappingTest.checkProcedureOutput(param, paramType, (double)val);
    }

    private static void checkProcedureOutput(int param, int paramType, double val) {
        switch (jdbcTypes[paramType]) {
            case 5: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((double)38.0, (double)val, (double)1.0E-5);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((double)77.0, (double)val, (double)1.0E-5);
                break;
            }
            case 4: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((double)41.0, (double)val, (double)1.0E-5);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((double)88.0, (double)val, (double)1.0E-5);
                break;
            }
            case -5: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((double)40.0, (double)val, (double)1.0E-5);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((double)99.0, (double)val, (double)1.0E-5);
                break;
            }
            case 6: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((double)35.9, (double)val, (double)1.0E-5);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((double)66.8, (double)val, (double)1.0E-5);
                break;
            }
            case 7: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((double)41.9, (double)val, (double)1.0E-5);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((double)88.8, (double)val, (double)1.0E-5);
                break;
            }
            case 3: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((double)34.29999, (double)val, (double)1.0E-4);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((double)84.09999, (double)val, (double)1.0E-4);
                break;
            }
            case 8: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((double)35.9, (double)val, (double)1.0E-5);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((double)66.8, (double)val, (double)1.0E-5);
            }
        }
    }

    private static void checkProcedureOutput(int param, int paramType, String val) {
        switch (jdbcTypes[paramType]) {
            case 5: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((String)"38", (String)val);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((String)"77", (String)val);
                break;
            }
            case 4: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((String)"41", (String)val);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((String)"88", (String)val);
                break;
            }
            case -5: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((String)"40", (String)val);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((String)"99", (String)val);
                break;
            }
            case 6: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((String)"35.9", (String)val);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((String)"66.8", (String)val);
                break;
            }
            case 7: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((String)"41.9", (String)val);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((String)"88.8", (String)val);
                break;
            }
            case 3: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((String)"34.29999", (String)val);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((String)"84.09999", (String)val);
                break;
            }
            case 8: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((String)"35.9", (String)val);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((String)"66.8", (String)val);
            }
        }
    }

    private static void checkProcedureOutput(int param, int paramType, byte[] val) {
        if (param == 2) {
            ParameterMappingTest.assertEquals((String)"0x4,0x3", (String)ParameterMappingTest.showFirstTwo(val));
        } else if (param == 3) {
            ParameterMappingTest.assertEquals((String)"0x9,0xfe", (String)ParameterMappingTest.showFirstTwo(val));
        }
    }

    private static void checkProcedureOutput(int param, int paramType, Date val) {
        switch (jdbcTypes[paramType]) {
            case 91: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((String)"2004-03-08", (String)val.toString());
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((String)"2005-03-08", (String)val.toString());
                break;
            }
            case 93: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((String)"2004-03-12", (String)val.toString());
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((String)"2004-04-12", (String)val.toString());
            }
        }
    }

    private static void checkProcedureOutput(int param, int paramType, Time val) {
        switch (jdbcTypes[paramType]) {
            case 92: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((String)"19:44:42", (String)val.toString());
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((String)"20:44:42", (String)val.toString());
                break;
            }
            case 93: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((String)"21:14:24", (String)val.toString());
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((String)"04:25:26", (String)val.toString());
            }
        }
    }

    private static void checkProcedureOutput(int param, int paramType, Timestamp val) {
        switch (jdbcTypes[paramType]) {
            case 91: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((String)"2004-03-08 00:00:00.0", (String)val.toString());
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((String)"2005-03-08 00:00:00.0", (String)val.toString());
                break;
            }
            case 92: {
                ParameterMappingTest.assertNotNull((Object)val);
                break;
            }
            case 93: {
                if (param == 2) {
                    if (ParameterMappingTest.usingEmbedded()) {
                        ParameterMappingTest.assertEquals((String)"2004-03-12 21:14:24.938222433", (String)val.toString());
                        break;
                    }
                    ParameterMappingTest.assertEquals((String)"2004-03-12 21:14:24.938222", (String)val.toString());
                    break;
                }
                if (param != 3) break;
                if (ParameterMappingTest.usingEmbedded()) {
                    ParameterMappingTest.assertEquals((String)"2004-04-12 04:25:26.462983731", (String)val.toString());
                    break;
                }
                ParameterMappingTest.assertEquals((String)"2004-04-12 04:25:26.462983", (String)val.toString());
            }
        }
    }

    static void dumpSQLExceptions(SQLException se) {
        while (se != null) {
            System.out.println("SQLSTATE(" + se.getSQLState() + "): " + se.toString());
            se = se.getNextException();
        }
    }

    private static void testSetStringInvalidValue(int type, PreparedStatement psi) {
        switch (jdbcTypes[type]) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return;
            }
        }
        String sqlType = SQLTypes[type];
        try {
            psi.setString(1, "Invalid Value");
            psi.executeUpdate();
            String error = "FAIL - setString(1,\"Invalld Value\") for type " + sqlType + " did not throw an exception as expected";
        }
        catch (SQLException sqle) {
            if (!("22018".equals(sqle.getSQLState()) || "XCL12".equals(sqle.getSQLState()) || "22007".equals(sqle.getSQLState()) || "22005".equals(sqle.getSQLState()) || sqle.getMessage().indexOf("Invalid data conversion") != -1 || sqle.getMessage().indexOf("Illegal Conversion") != -1)) {
                ParameterMappingTest.fail((String)("FAIL:" + sqle.getMessage()));
            }
        }
        catch (Exception e) {
            ParameterMappingTest.fail((String)("FAIL: Unexpected Exception " + e.getMessage()));
        }
    }

    private static String showFirstTwo(Reader in) throws IOException {
        int b1 = in.read();
        int b2 = in.read();
        in.close();
        return "0x" + Integer.toHexString(b1) + "," + "0x" + Integer.toHexString(b2);
    }

    private static String showFirstTwo(InputStream in) throws IOException {
        int b1 = in.read();
        int b2 = in.read();
        in.close();
        return "0x" + Integer.toHexString(b1) + "," + "0x" + Integer.toHexString(b2);
    }

    private static String showFirstTwo(byte[] data) {
        byte b1 = data[0];
        byte b2 = data[1];
        return "0x" + Integer.toHexString(b1 & 0xFF) + "," + "0x" + Integer.toHexString(b2 & 0xFF);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJDBC2()) {
            return TestConfiguration.defaultSuite(ParameterMappingTest.class);
        }
        return new TestSuite("ParameterMapping");
    }

    public static void pmap(short in, short[] inout, short[] out) {
        inout[0] = (short)(inout[0] + 6);
        out[0] = 77;
    }

    public static void pmap(int in, int[] inout, int[] out) {
        inout[0] = inout[0] + 9;
        out[0] = 88;
    }

    public static void pmap(long in, long[] inout, long[] out) {
        inout[0] = inout[0] + 8L;
        out[0] = 99L;
    }

    public static void pmap(float in, float[] inout, float[] out) {
        inout[0] = inout[0] + 9.9f;
        out[0] = 88.8f;
    }

    public static void pmap(double in, double[] inout, double[] out) {
        inout[0] = inout[0] + 3.9;
        out[0] = 66.8;
    }

    public static void pmap(byte[] in, byte[][] inout, byte[][] out) {
        inout[0][2] = 86;
        out[0] = new byte[4];
        out[0][0] = 9;
        out[0][1] = -2;
        out[0][2] = -19;
        out[0][3] = 2;
    }

    public static void pmap(Date in, Date[] inout, Date[] out) {
        inout[0] = Date.valueOf("2004-03-08");
        out[0] = Date.valueOf("2005-03-08");
    }

    public static void pmap(Time in, Time[] inout, Time[] out) {
        inout[0] = Time.valueOf("19:44:42");
        out[0] = Time.valueOf("20:44:42");
    }

    public static void pmap(Timestamp in, Timestamp[] inout, Timestamp[] out) {
        inout[0] = Timestamp.valueOf("2004-03-12 21:14:24.938222433");
        out[0] = Timestamp.valueOf("2004-04-12 04:25:26.462983731");
    }

    public static void pmap(String in, String[] inout, String[] out) {
        inout[0] = inout[0].trim().concat("P2-PMAP");
        out[0] = "P3-PMAP";
    }

    public static void pmap(BigDecimal in, BigDecimal[] inout, BigDecimal[] out) {
        inout[0] = inout[0].add(new BigDecimal(2.3));
        out[0] = new BigDecimal(84.1);
    }
}

