/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DboPowersTest
extends BaseJDBCTestCase {
    private final int _authLevel;
    private final String _dbo;
    private final String _dboPassword;
    private static final int NOAUTHENTICATION = 0;
    private static final int AUTHENTICATION = 1;
    private static final int SQLAUTHORIZATION = 2;
    private static final String[] secLevelNames = new String[]{"noAuthentication", "authentication", "authentication + sqlAuthorization"};
    static final String[][] users = new String[][]{{"APP", "U1"}, {"TEST_DBO", "U1"}};
    static final String pwSuffix = "pwSuffix";
    static final String[] encryptionTests = new String[]{"testEncrypt", "testReEncrypt"};

    public DboPowersTest(String name, int authLevel) {
        super(name);
        this._authLevel = authLevel;
        this._dbo = null;
        this._dboPassword = null;
    }

    public DboPowersTest(String name, int authLevel, String dbo, String dboPassword) {
        super(name);
        this._authLevel = authLevel;
        this._dbo = dbo;
        this._dboPassword = dboPassword;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("DboPowersTest");
        suite.addTest(DboPowersTest.dboShutdownSuite("suite: shutdown powers, embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(DboPowersTest.dboShutdownSuite("suite: shutdown powers, client")));
        if (!JDBC.vmSupportsJSR169()) {
            suite.addTest(DboPowersTest.dboEncryptionSuite("suite: encryption powers, embedded"));
            suite.addTest(TestConfiguration.clientServerDecorator(DboPowersTest.dboEncryptionSuite("suite: encryption powers, client")));
        }
        suite.addTest(DboPowersTest.dboHardUpgradeSuite("suite: hard upgrade powers, embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(DboPowersTest.dboHardUpgradeSuite("suite: hard upgrade powers, client")));
        return suite;
    }

    private static Test dboShutdownSuite(String framework) {
        Test[] tests = new Test[3];
        TestSuite noauthSuite = new TestSuite("suite: security level=" + secLevelNames[0]);
        noauthSuite.addTest((Test)new DboPowersTest("testShutDown", 0));
        tests[0] = noauthSuite;
        for (int autLev = 1; autLev <= 2; ++autLev) {
            tests[autLev] = DboPowersTest.wrapShutdownUserTests(autLev);
        }
        TestSuite suite = new TestSuite("dboPowers:" + framework);
        suite.addTest(tests[0]);
        suite.addTest(tests[1]);
        suite.addTest(TestConfiguration.sqlAuthorizationDecorator(tests[2]));
        return suite;
    }

    private static Test wrapShutdownUserTests(int autLev) {
        TestSuite usersSuite = new TestSuite("usersSuite: security level=" + secLevelNames[autLev]);
        for (int userNo = 0; userNo < users.length; ++userNo) {
            usersSuite.addTest(TestConfiguration.changeUserDecorator((Test)new DboPowersTest("testShutDown", autLev), users[autLev - 1][userNo], users[autLev - 1][userNo].concat(pwSuffix)));
        }
        return DatabasePropertyTestSetup.builtinAuthentication((Test)usersSuite, users[autLev - 1], pwSuffix);
    }

    public void testShutDown() throws SQLException {
        DboPowersTest.println("testShutDown: auth=" + this._authLevel + " user=" + this.getTestConfiguration().getUserName());
        this.getConnection().close();
        String user = this.getTestConfiguration().getUserName();
        String password = this.getTestConfiguration().getUserPassword();
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "shutdown=true");
        JDBCDataSource.setBeanProperty(ds, "user", user);
        JDBCDataSource.setBeanProperty(ds, "password", password);
        try {
            ds.getConnection();
            DboPowersTest.fail((String)"shutdown failed: no exception");
        }
        catch (SQLException e) {
            if ("08006".equals(e.getSQLState())) {
                JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "");
                ds.getConnection().close();
            }
            this.vetShutdownException(user, e);
        }
    }

    private void vetShutdownException(String user, SQLException e) {
        switch (this._authLevel) {
            case 0: {
                DboPowersTest.assertSQLState("database shutdown, no authentication", "08006", e);
                break;
            }
            case 1: {
                DboPowersTest.assertSQLState("database shutdown, authentication", "08006", e);
                break;
            }
            case 2: {
                if ("TEST_DBO".equals(user)) {
                    DboPowersTest.assertSQLState("database shutdown, SQL authorization, db owner", "08006", e);
                    break;
                }
                DboPowersTest.assertSQLState("database shutdown restriction, SQL authorization, not db owner", "08004", e);
                break;
            }
            default: {
                DboPowersTest.fail((String)("test error: invalid authLevel: " + this._authLevel));
            }
        }
    }

    private static Test dboEncryptionSuite(String framework) {
        Test[] tests = new Test[3];
        TestSuite noauthSuite = new TestSuite("suite: security level=" + secLevelNames[0]);
        for (int tNo = 0; tNo < encryptionTests.length; ++tNo) {
            noauthSuite.addTest((Test)TestConfiguration.singleUseDatabaseDecoratorNoShutdown((Test)new DboPowersTest(encryptionTests[tNo], 0, "foo", "bar")));
        }
        tests[0] = noauthSuite;
        for (int autLev = 1; autLev <= 2; ++autLev) {
            tests[autLev] = DboPowersTest.wrapEncryptionUserTests(autLev);
        }
        TestSuite suite = new TestSuite("dboPowers:" + framework);
        suite.addTest(tests[0]);
        suite.addTest(tests[1]);
        suite.addTest(tests[2]);
        return suite;
    }

    private static Test wrapEncryptionUserTests(int autLev) {
        TestSuite usersSuite = new TestSuite("usersSuite: security level=" + secLevelNames[autLev]);
        for (int userNo = 0; userNo < users.length; ++userNo) {
            for (int tNo = 0; tNo < encryptionTests.length; ++tNo) {
                Object test = TestConfiguration.changeUserDecorator((Test)new DboPowersTest(encryptionTests[tNo], autLev, users[autLev - 1][0], users[autLev - 1][0].concat(pwSuffix)), users[autLev - 1][userNo], users[autLev - 1][userNo].concat(pwSuffix));
                test = DatabasePropertyTestSetup.builtinAuthenticationNoTeardown(test, users[autLev - 1], pwSuffix);
                test = autLev == 1 ? TestConfiguration.singleUseDatabaseDecoratorNoShutdown(test) : TestConfiguration.sqlAuthorizationDecoratorSingleUse(test);
                usersSuite.addTest(test);
            }
        }
        return usersSuite;
    }

    public void testEncrypt() throws SQLException {
        DboPowersTest.println("testEncrypt: auth=" + this._authLevel + " user=" + this.getTestConfiguration().getUserName());
        this.getConnection().close();
        this.bringDbDown();
        String user = this.getTestConfiguration().getUserName();
        String password = this.getTestConfiguration().getUserPassword();
        String bootPassword = "12345678";
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "dataEncryption=true;bootPassword=" + bootPassword);
        JDBCDataSource.setBeanProperty(ds, "user", user);
        JDBCDataSource.setBeanProperty(ds, "password", password);
        Connection con = null;
        try {
            con = ds.getConnection();
            this.vetEncryptionAttempt(user, null);
        }
        catch (SQLException e) {
            this.vetEncryptionAttempt(user, e);
            this.bringDbDown();
            return;
        }
        try {
            this.derby3038(con);
        }
        catch (SQLException e) {
            DboPowersTest.fail((String)("derby3038 regression: " + e));
        }
        this.bringDbDown();
        this.bringDbUp(bootPassword);
        this.bringDbDown();
    }

    public void testReEncrypt() throws SQLException {
        DboPowersTest.println("testReEncrypt: auth=" + this._authLevel + " user=" + this.getTestConfiguration().getUserName());
        this.getConnection().close();
        this.bringDbDown();
        String bootPassword = "12345678";
        this.doEncrypt(bootPassword);
        this.bringDbDown();
        String user = this.getTestConfiguration().getUserName();
        String password = this.getTestConfiguration().getUserPassword();
        String newBootPassword = "87654321";
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "bootPassword=" + bootPassword + ";newBootPassword=" + newBootPassword);
        JDBCDataSource.setBeanProperty(ds, "user", user);
        JDBCDataSource.setBeanProperty(ds, "password", password);
        try {
            ds.getConnection();
            this.vetEncryptionAttempt(user, null);
        }
        catch (SQLException e) {
            this.vetEncryptionAttempt(user, e);
            this.bringDbDown();
            return;
        }
        this.bringDbDown();
        this.bringDbUp(newBootPassword);
        this.bringDbDown();
    }

    private void doEncrypt(String bootPassword) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "dataEncryption=true;bootPassword=" + bootPassword);
        JDBCDataSource.setBeanProperty(ds, "user", this._dbo);
        JDBCDataSource.setBeanProperty(ds, "password", this._dboPassword);
        ds.getConnection();
    }

    private void bringDbDown() {
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "shutdown=true");
        JDBCDataSource.setBeanProperty(ds, "user", this._dbo);
        JDBCDataSource.setBeanProperty(ds, "password", this._dboPassword);
        try {
            ds.getConnection();
            DboPowersTest.fail((String)"shutdown failed: expected exception");
        }
        catch (SQLException e) {
            DboPowersTest.assertSQLState("database shutdown", "08006", e);
        }
    }

    private void bringDbUp(String bootPassword) throws SQLException {
        String user = this.getTestConfiguration().getUserName();
        String password = this.getTestConfiguration().getUserPassword();
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "bootPassword=" + bootPassword);
        JDBCDataSource.setBeanProperty(ds, "user", user);
        JDBCDataSource.setBeanProperty(ds, "password", password);
        ds.getConnection().close();
    }

    private void vetEncryptionAttempt(String user, SQLException e) {
        this.vetAttempt(user, e, "08004", "(re)encryption");
    }

    private static Test dboHardUpgradeSuite(String framework) {
        Test[] tests = new Test[3];
        TestSuite noauthSuite = new TestSuite("suite: security level=" + secLevelNames[0]);
        noauthSuite.addTest((Test)new DboPowersTest("testHardUpgrade", 0, "foo", "bar"));
        tests[0] = noauthSuite;
        for (int autLev = 1; autLev <= 2; ++autLev) {
            tests[autLev] = DboPowersTest.wrapHardUpgradeUserTests(autLev);
        }
        TestSuite suite = new TestSuite("dboPowers:" + framework);
        suite.addTest((Test)TestConfiguration.singleUseDatabaseDecorator(tests[0]));
        suite.addTest((Test)TestConfiguration.singleUseDatabaseDecorator(tests[1]));
        suite.addTest(TestConfiguration.sqlAuthorizationDecorator(tests[2]));
        return suite;
    }

    private static Test wrapHardUpgradeUserTests(int autLev) {
        TestSuite usersSuite = new TestSuite("usersSuite: security level=" + secLevelNames[autLev]);
        for (int userNo = 0; userNo < users.length; ++userNo) {
            usersSuite.addTest(TestConfiguration.changeUserDecorator((Test)new DboPowersTest("testHardUpgrade", autLev, users[autLev - 1][0], users[autLev - 1][0].concat(pwSuffix)), users[autLev - 1][userNo], users[autLev - 1][userNo].concat(pwSuffix)));
        }
        return DatabasePropertyTestSetup.builtinAuthentication((Test)usersSuite, users[autLev - 1], pwSuffix);
    }

    public void testHardUpgrade() throws SQLException {
        DboPowersTest.println("testHardUpgrade: auth=" + this._authLevel + " user=" + this.getTestConfiguration().getUserName());
        this.getConnection().close();
        this.bringDbDown();
        String user = this.getTestConfiguration().getUserName();
        String password = this.getTestConfiguration().getUserPassword();
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "upgrade=true");
        JDBCDataSource.setBeanProperty(ds, "user", user);
        JDBCDataSource.setBeanProperty(ds, "password", password);
        try {
            ds.getConnection();
            this.vetHardUpgradeAttempt(user, null);
        }
        catch (SQLException e) {
            this.vetHardUpgradeAttempt(user, e);
        }
        this.bringDbDown();
    }

    private void vetHardUpgradeAttempt(String user, SQLException e) {
        this.vetAttempt(user, e, "08004", "hard upgrade");
    }

    private void vetAttempt(String user, SQLException e, String state, String operation) {
        switch (this._authLevel) {
            case 0: {
                DboPowersTest.assertEquals((String)(operation + ", no authentication"), null, (Object)e);
                break;
            }
            case 1: {
                DboPowersTest.assertEquals((String)(operation + ", authentication"), null, (Object)e);
                break;
            }
            case 2: {
                if ("TEST_DBO".equals(user)) {
                    DboPowersTest.assertEquals((String)(operation + ", SQL authorization, db owner"), null, (Object)e);
                    break;
                }
                DboPowersTest.assertSQLState(operation + ", SQL authorization, not db owner", state, e);
                break;
            }
            default: {
                DboPowersTest.fail((String)("test error: invalid authLevel: " + this._authLevel));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void derby3038(Connection con) throws SQLException {
        Statement s = con.createStatement();
        try {
            s.executeUpdate("CREATE PROCEDURE DERBY3038PROC () LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + DboPowersTest.class.getName() + ".derby3038Proc' " + "READS SQL DATA");
            s.executeUpdate("CALL DERBY3038PROC()");
        }
        finally {
            s.close();
        }
    }

    public static void derby3038Proc() throws SQLException {
        Connection con = DriverManager.getConnection("jdbc:default:connection");
        con.close();
    }
}

