/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.IOException;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class StreamTruncationTest
extends BaseJDBCTestCase {
    public static final int CONV_BUFFER_SIZE = 32768;
    public static final int CLOB = 2;
    public static final int VARCHAR = 3;
    public static final int LONGVARCHAR = 4;
    public static final int CHAR = 5;
    public static final String TABLE_SMALL = "TRUNCATE_SMALL";
    public static final String TABLE_LARGE = "TRUNCATE_LARGE";
    public static final int SMALL_SIZE = 16384;
    public static final int LARGE_SIZE = 65536;
    public static final int LARGE_VARCHAR_SIZE = 32672;
    public static final int CHAR_SIZE = 138;
    private static AtomicInteger ID = new AtomicInteger(1);

    public StreamTruncationTest(String name) {
        super(name);
    }

    public void setUp() throws SQLException {
        this.setAutoCommit(false);
    }

    public void testCharWithLength() throws IOException, SQLException {
        this.charSmall(false);
    }

    public void testCharWithoutLength() throws IOException, SQLException {
        this.charSmall(true);
    }

    public void testSmallVarcharWithLength() throws IOException, SQLException {
        this.generalTypeSmall(3, false);
    }

    public void testSmallVarcharWithoutLength() throws IOException, SQLException {
        this.generalTypeSmall(3, true);
    }

    public void testLargeVarcharWithLength() throws IOException, SQLException {
        this.generalTypeLarge(3, false);
    }

    public void testLargeVarcharWithoutLength() throws IOException, SQLException {
        this.generalTypeLarge(3, true);
    }

    public void testLongVarcharWithLength() throws IOException, SQLException {
        this.generalTypeSmall(4, false);
    }

    public void testLongVarcharWithoutLength() throws IOException, SQLException {
        this.generalTypeSmall(4, true);
    }

    public void testSmallClobWithLength() throws IOException, SQLException {
        this.generalTypeSmall(2, false);
    }

    public void testSmallClobWithoutLength() throws IOException, SQLException {
        this.generalTypeSmall(2, true);
    }

    public void testLargeClobWithLength() throws IOException, SQLException {
        this.generalTypeLarge(2, false);
    }

    public void testLargeClobWithoutLength() throws IOException, SQLException {
        this.generalTypeLarge(2, true);
    }

    private void generalTypeLarge(int colIndex, boolean lengthless) throws IOException, SQLException {
        this.insertLarge(colIndex, lengthless, 65536, 0);
        this.insertLarge(colIndex, lengthless, 65437, 15);
        this.insertLarge(colIndex, lengthless, 65725, 189);
        this.insertLarge(colIndex, lengthless, 65536, 250);
        this.insertLarge(colIndex, lengthless, 65716, 0);
        this.insertLarge(colIndex, lengthless, 65716, 17);
    }

    private void generalTypeSmall(int colIndex, boolean lengthless) throws IOException, SQLException {
        this.insertSmall(colIndex, lengthless, 16384, 0);
        this.insertSmall(colIndex, lengthless, 16285, 15);
        this.insertSmall(colIndex, lengthless, 16573, 189);
        this.insertSmall(colIndex, lengthless, 16384, 250);
        this.insertSmall(colIndex, lengthless, 16564, 0);
        this.insertSmall(colIndex, lengthless, 16564, 17);
    }

    private void charSmall(boolean lengthless) throws IOException, SQLException {
        this.insertSmall(5, lengthless, 138, 0);
        this.insertSmall(5, lengthless, 128, 4);
        this.insertSmall(5, lengthless, 327, 189);
        this.insertSmall(5, lengthless, 138, 20);
        this.insertSmall(5, lengthless, 318, 0);
        this.insertSmall(5, lengthless, 318, 17);
    }

    private int insertSmall(int colIndex, boolean lengthless, int totalLength, int blanks) throws IOException, SQLException {
        int id = ID.getAndAdd(1);
        PreparedStatement ps = this.prepareStatement("insert into TRUNCATE_SMALL values (?,?,?,?,?)");
        ps.setInt(1, id);
        ps.setNull(2, 2005);
        ps.setNull(3, 12);
        ps.setNull(4, -1);
        ps.setNull(5, 1);
        int colWidth = 16384;
        if (colIndex == 4) {
            colWidth = 32700;
        }
        int expectedLength = Math.min(totalLength, colWidth);
        if (colIndex == 5) {
            expectedLength = 138;
            colWidth = 138;
        }
        StreamTruncationTest.println("totalLength=" + totalLength + ", blanks=" + blanks + ", colWidth=" + colWidth + ", expectedLength=" + expectedLength);
        LoopingAlphabetReader source = new LoopingAlphabetReader(totalLength, CharAlphabet.modernLatinLowercase(), blanks);
        if (lengthless) {
            ps.setCharacterStream(colIndex, source);
        } else {
            ps.setCharacterStream(colIndex, (Reader)source, totalLength);
        }
        try {
            StreamTruncationTest.assertEquals((int)1, (int)ps.executeUpdate());
            if (totalLength > expectedLength) {
                StreamTruncationTest.assertTrue((totalLength - blanks <= expectedLength ? 1 : 0) != 0);
            }
            StreamTruncationTest.assertEquals((int)expectedLength, (int)this.getStreamLength(TABLE_SMALL, colIndex, id));
        }
        catch (SQLException sqle) {
            if (colIndex == 4) {
                StreamTruncationTest.assertTrue((totalLength > expectedLength ? 1 : 0) != 0);
            } else {
                StreamTruncationTest.assertTrue((totalLength - blanks > expectedLength ? 1 : 0) != 0);
            }
            String expectedState = "XSDA4";
            if (colIndex == 5 || colIndex == 3) {
                expectedState = lengthless ? "XJ001" : (!StreamTruncationTest.usingEmbedded() ? "XJ001" : "22001");
            }
            StreamTruncationTest.assertSQLState(expectedState, sqle);
        }
        return id;
    }

    private int insertLarge(int colIndex, boolean lengthless, int totalLength, int blanks) throws IOException, SQLException {
        StreamTruncationTest.assertTrue((colIndex != 5 && colIndex != 4 ? 1 : 0) != 0);
        int id = ID.getAndAdd(1);
        PreparedStatement ps = this.prepareStatement("insert into TRUNCATE_LARGE values (?,?,?)");
        ps.setInt(1, id);
        ps.setNull(2, 2005);
        ps.setNull(3, 12);
        int colWidth = colIndex == 3 ? 32672 : 65536;
        int expectedLength = Math.min(totalLength, colWidth);
        StreamTruncationTest.println("totalLength=" + totalLength + ", blanks=" + blanks + ", colWidth=" + colWidth + ", expectedLength=" + expectedLength);
        LoopingAlphabetReader source = new LoopingAlphabetReader(totalLength, CharAlphabet.modernLatinLowercase(), blanks);
        if (lengthless) {
            ps.setCharacterStream(colIndex, source);
        } else {
            ps.setCharacterStream(colIndex, (Reader)source, totalLength);
        }
        try {
            StreamTruncationTest.assertEquals((int)1, (int)ps.executeUpdate());
            if (totalLength > expectedLength) {
                StreamTruncationTest.assertTrue((totalLength - blanks <= expectedLength ? 1 : 0) != 0);
            }
            StreamTruncationTest.assertEquals((int)expectedLength, (int)this.getStreamLength(TABLE_LARGE, colIndex, id));
        }
        catch (SQLException sqle) {
            StreamTruncationTest.assertTrue((totalLength - blanks > expectedLength ? 1 : 0) != 0);
            String expectedState = "XSDA4";
            if (colIndex == 3) {
                expectedState = lengthless ? "XJ001" : (!StreamTruncationTest.usingEmbedded() ? "XJ001" : "22001");
            }
            StreamTruncationTest.assertSQLState(expectedState, sqle);
        }
        return id;
    }

    private int getStreamLength(String table, int colIndex, int id) throws IOException, SQLException {
        int read;
        Statement sFetch = this.createStatement();
        ResultSet rs = sFetch.executeQuery("select * from " + table + " where id = " + id);
        StreamTruncationTest.assertTrue((boolean)rs.next());
        Reader dbSource = rs.getCharacterStream(colIndex);
        int observedLen = 0;
        char[] buf = new char[1024];
        while ((read = dbSource.read(buf)) != -1) {
            observedLen += read;
        }
        rs.close();
        return observedLen;
    }

    public static Test suite() {
        return new CleanDatabaseTestSetup(TestConfiguration.defaultSuite(StreamTruncationTest.class, false)){

            protected void decorateSQL(Statement stmt) throws SQLException {
                stmt.executeUpdate("create table TRUNCATE_SMALL (ID int primary key, CLOBDATA clob(16384),VCHARDATA varchar(16384),LVCHARDATA long varchar,CHARDATA char(138))");
                stmt.executeUpdate("create table TRUNCATE_LARGE (ID int primary key, CLOBDATA clob(65536),VCHARDATA varchar(32672))");
                stmt.close();
            }
        };
    }
}

