/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derby.iapi.services.io.DerbyIOException;
import org.apache.derby.impl.jdbc.EmbedSQLException;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class PreparedStatementTest
extends BaseJDBCTestCase {
    private static final String BLOBTBL = "BlobTestTable";
    private static final String CLOBTBL = "ClobTestTable";
    private static final String LONGVARCHAR = "LongVarcharTestTable";
    private static int globalKey = 1;
    private static final byte[] BYTES = new byte[]{101, 102, 103, 104, 105, 105, 104, 103, 102, 101};
    private int key;
    private PreparedStatement ps = null;
    private PreparedStatement psFetchBlob = null;
    private PreparedStatement psInsertBlob = null;
    private PreparedStatement psFetchClob = null;
    private PreparedStatement psInsertClob = null;
    private PreparedStatement psInsertLongVarchar = null;
    private Statement s = null;

    public PreparedStatementTest(String name) {
        super(name);
    }

    public void setUp() throws SQLException {
        this.key = PreparedStatementTest.requestKey();
        this.s = this.createStatement();
        this.ps = this.prepareStatement("select count(*) from sys.systables");
        this.psFetchBlob = this.prepareStatement("SELECT dBlob FROM BlobTestTable WHERE sno = ?");
        this.psInsertBlob = this.prepareStatement("INSERT INTO BlobTestTable VALUES (?, ?)");
        this.psFetchClob = this.prepareStatement("SELECT dClob FROM ClobTestTable WHERE sno = ?");
        this.psInsertClob = this.prepareStatement("INSERT INTO ClobTestTable VALUES (?, ?)");
        this.psInsertLongVarchar = this.prepareStatement("INSERT INTO LongVarcharTestTable VALUES (?, ?)");
    }

    public void tearDown() throws Exception {
        this.s.close();
        this.ps.close();
        this.s = null;
        this.ps = null;
        this.psFetchBlob.close();
        this.psFetchClob.close();
        this.psInsertBlob.close();
        this.psInsertClob.close();
        this.psInsertLongVarchar.close();
        this.psFetchBlob = null;
        this.psFetchClob = null;
        this.psInsertBlob = null;
        this.psInsertClob = null;
        this.psInsertLongVarchar = null;
        super.tearDown();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("PreparedStatementTest suite");
        suite.addTest(PreparedStatementTest.baseSuite("PreparedStatementTest:embedded"));
        suite.addTest((Test)TestConfiguration.connectionXADecorator(PreparedStatementTest.baseSuite("PreparedStatementTest:embedded XADataSource")));
        suite.addTest(TestConfiguration.clientServerDecorator(PreparedStatementTest.baseSuite("PreparedStatementTest:client")));
        suite.addTest(TestConfiguration.clientServerDecorator((Test)TestConfiguration.connectionXADecorator(PreparedStatementTest.baseSuite("PreparedStatementTest:client XXXXADataSource"))));
        return suite;
    }

    private static Test baseSuite(String name) {
        TestSuite suite = new TestSuite(name);
        suite.addTestSuite(PreparedStatementTest.class);
        return new CleanDatabaseTestSetup((Test)suite){

            protected void decorateSQL(Statement stmt) throws SQLException {
                stmt.execute("create table BlobTestTable (sno int, dBlob BLOB(1M))");
                stmt.execute("create table ClobTestTable (sno int, dClob CLOB(1M))");
                stmt.execute("create table LongVarcharTestTable (sno int, dLongVarchar LONG VARCHAR)");
            }
        };
    }

    public void testSetRowId() throws SQLException {
        try {
            RowId rowid = null;
            this.ps.setRowId(0, rowid);
            PreparedStatementTest.fail((String)"setRowId should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetNString() throws SQLException {
        try {
            String str = null;
            this.ps.setNString(0, str);
            PreparedStatementTest.fail((String)"setNString should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetNCharacterStream() throws SQLException {
        try {
            Reader r = null;
            this.ps.setNCharacterStream(0, r, 0L);
            PreparedStatementTest.fail((String)"setNCharacterStream should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetNCharacterStreamLengthlessNotImplemented() throws SQLException {
        try {
            this.ps.setNCharacterStream(1, new StringReader("A string"));
            PreparedStatementTest.fail((String)"setNCharacterStream(int,Reader) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetNClobLengthlessNotImplemented() throws SQLException {
        try {
            this.ps.setNClob(1, new StringReader("A string"));
            PreparedStatementTest.fail((String)"setNClob(int,Reader) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetNClob1() throws SQLException {
        try {
            NClob nclob = null;
            this.ps.setNClob(0, nclob);
            PreparedStatementTest.fail((String)"setNClob should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetNClob2() throws SQLException {
        try {
            Reader reader = null;
            this.ps.setNClob(0, reader, 0L);
            PreparedStatementTest.fail((String)"setNClob should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetSQLXML() throws SQLException {
        try {
            SQLXML sqlxml = null;
            this.ps.setSQLXML(0, sqlxml);
            PreparedStatementTest.fail((String)"setNClob should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testIsWrapperForStatement() throws SQLException {
        PreparedStatementTest.assertTrue((boolean)this.ps.isWrapperFor(Statement.class));
    }

    public void testIsWrapperForPreparedStatement() throws SQLException {
        PreparedStatementTest.assertTrue((boolean)this.ps.isWrapperFor(PreparedStatement.class));
    }

    public void testIsNotWrapperForCallableStatement() throws SQLException {
        PreparedStatementTest.assertFalse((boolean)this.ps.isWrapperFor(CallableStatement.class));
    }

    public void testIsNotWrapperForResultSet() throws SQLException {
        PreparedStatementTest.assertFalse((boolean)this.ps.isWrapperFor(ResultSet.class));
    }

    public void testUnwrapStatement() throws SQLException {
        Statement stmt = this.ps.unwrap(Statement.class);
        PreparedStatementTest.assertSame((String)"Unwrap returned wrong object.", (Object)this.ps, (Object)stmt);
    }

    public void testUnwrapPreparedStatement() throws SQLException {
        PreparedStatement ps2 = this.ps.unwrap(PreparedStatement.class);
        PreparedStatementTest.assertSame((String)"Unwrap returned wrong object.", (Object)this.ps, (Object)ps2);
    }

    public void testUnwrapCallableStatement() {
        try {
            CallableStatement cs = this.ps.unwrap(CallableStatement.class);
            PreparedStatementTest.fail((String)"Unwrap didn't fail.");
        }
        catch (SQLException e) {
            PreparedStatementTest.assertSQLState("XJ128", e);
        }
    }

    public void testUnwrapResultSet() {
        try {
            ResultSet rs = this.ps.unwrap(ResultSet.class);
            PreparedStatementTest.fail((String)"Unwrap didn't fail.");
        }
        catch (SQLException e) {
            PreparedStatementTest.assertSQLState("XJ128", e);
        }
    }

    public void testSetClob() throws IOException, SQLException {
        this.getConnection().setAutoCommit(false);
        String str = "Test data for the Clob object";
        StringReader is = new StringReader("Test data for the Clob object");
        is.reset();
        this.psInsertClob.setInt(1, this.key);
        this.psInsertClob.setClob(2, is, str.length());
        this.psInsertClob.executeUpdate();
        this.psFetchClob.setInt(1, this.key);
        ResultSet rs = this.psFetchClob.executeQuery();
        rs.next();
        Clob clobToBeInserted = rs.getClob(1);
        rs.close();
        int secondKey = PreparedStatementTest.requestKey();
        this.psInsertClob.setInt(1, secondKey);
        this.psInsertClob.setClob(2, clobToBeInserted);
        this.psInsertClob.execute();
        this.psInsertClob.close();
        this.psFetchClob.setInt(1, secondKey);
        rs = this.psFetchClob.executeQuery();
        rs.next();
        Clob clobRetrieved = rs.getClob(1);
        PreparedStatementTest.assertEquals(clobToBeInserted, clobRetrieved);
    }

    public void testSetClobLengthless() throws IOException, SQLException {
        this.getConnection().setAutoCommit(false);
        Clob insertClob = this.getConnection().createClob();
        OutputStream os = insertClob.setAsciiStream(1L);
        os.write(BYTES);
        this.psInsertClob.setInt(1, this.key);
        this.psInsertClob.setClob(2, insertClob);
        this.psInsertClob.execute();
        this.psFetchClob.setInt(1, this.key);
        ResultSet rs = this.psFetchClob.executeQuery();
        PreparedStatementTest.assertTrue((String)"No results retrieved", (boolean)rs.next());
        Clob clobRetrieved = rs.getClob(1);
        PreparedStatementTest.assertEquals(insertClob, clobRetrieved);
    }

    public void testSetBlob() throws IOException, SQLException {
        this.getConnection().setAutoCommit(false);
        ByteArrayInputStream is = new ByteArrayInputStream(BYTES);
        ((InputStream)is).reset();
        this.psInsertBlob.setInt(1, this.key);
        this.psInsertBlob.setBlob(2, is, BYTES.length);
        this.psInsertBlob.executeUpdate();
        this.psFetchBlob.setInt(1, this.key);
        ResultSet rs = this.psFetchBlob.executeQuery();
        rs.next();
        Blob blobToBeInserted = rs.getBlob(1);
        rs.close();
        int secondKey = PreparedStatementTest.requestKey();
        this.psInsertBlob.setInt(1, secondKey);
        this.psInsertBlob.setBlob(2, blobToBeInserted);
        this.psInsertBlob.execute();
        this.psInsertBlob.close();
        this.psFetchBlob.setInt(1, secondKey);
        rs = this.psFetchBlob.executeQuery();
        rs.next();
        Blob blobRetrieved = rs.getBlob(1);
        PreparedStatementTest.assertEquals(blobToBeInserted, blobRetrieved);
    }

    public void testSetBlobLengthless() throws IOException, SQLException {
        this.getConnection().setAutoCommit(false);
        Blob insertBlob = this.getConnection().createBlob();
        OutputStream os = insertBlob.setBinaryStream(1L);
        os.write(BYTES);
        int secondKey = PreparedStatementTest.requestKey();
        this.psInsertBlob.setInt(1, secondKey);
        this.psInsertBlob.setBlob(2, insertBlob);
        this.psInsertBlob.execute();
        os.close();
        this.psInsertBlob.close();
        this.psFetchBlob.setInt(1, secondKey);
        ResultSet rs = this.psFetchBlob.executeQuery();
        PreparedStatementTest.assertTrue((String)"No results retrieved", (boolean)rs.next());
        Blob blobRetrieved = rs.getBlob(1);
        PreparedStatementTest.assertEquals(insertBlob, blobRetrieved);
    }

    public void testSetPoolable() throws SQLException {
        this.ps.setPoolable(false);
        PreparedStatementTest.assertFalse((String)"Expected a non-poolable statement", (boolean)this.ps.isPoolable());
        this.ps.setPoolable(true);
        PreparedStatementTest.assertTrue((String)"Expected a non-poolable statement", (boolean)this.ps.isPoolable());
    }

    public void testSetPoolableOnClosed() throws SQLException {
        block2: {
            try {
                this.ps.close();
                this.ps.setPoolable(false);
                PreparedStatementTest.fail((String)"Expected an exception on closed statement");
            }
            catch (SQLException sqle) {
                if (sqle.getSQLState().equals("XJ012") || sqle.getSQLState().equals("XCL31")) break block2;
                PreparedStatementTest.fail((String)("Unexpected SQLException " + sqle));
            }
        }
    }

    public void testIsPoolable() throws SQLException {
        PreparedStatementTest.assertTrue((String)"Expected a poolable statement", (boolean)this.ps.isPoolable());
    }

    public void testIsPoolableOnClosed() throws SQLException {
        block2: {
            try {
                this.ps.close();
                boolean p = this.ps.isPoolable();
                PreparedStatementTest.fail((String)"Should throw exception on closed statement");
            }
            catch (SQLException sqle) {
                if (sqle.getSQLState().equals("XJ012") || sqle.getSQLState().equals("XCL31")) break block2;
                PreparedStatementTest.fail((String)("Unexpected SQLException " + sqle));
            }
        }
    }

    public void testSetCharacterStream() throws Exception {
        String str = "Test data for the Clob object";
        StringReader is = new StringReader("Test data for the Clob object");
        is.reset();
        this.psInsertClob.setInt(1, this.key);
        this.psInsertClob.setCharacterStream(2, (Reader)is, str.length());
        this.psInsertClob.executeUpdate();
        this.psFetchClob.setInt(1, this.key);
        ResultSet rs = this.psFetchClob.executeQuery();
        rs.next();
        Clob clobRetrieved = rs.getClob(1);
        String str_out = clobRetrieved.getSubString(1L, (int)clobRetrieved.length());
        PreparedStatementTest.assertEquals((String)"Error in inserting data into the Clob object", (String)str, (String)str_out);
        this.psInsertClob.close();
        rs.close();
    }

    public void testSetCharacterStreamLengthless() throws IOException, SQLException {
        String testString = "Test string for setCharacterStream\u1a00";
        StringReader reader = new StringReader(testString);
        this.psInsertClob.setInt(1, this.key);
        this.psInsertClob.setCharacterStream(2, reader);
        this.psInsertClob.execute();
        ((Reader)reader).close();
        this.psFetchClob.setInt(1, this.key);
        ResultSet rs = this.psFetchClob.executeQuery();
        PreparedStatementTest.assertTrue((String)"No results retrieved", (boolean)rs.next());
        Clob clobRetrieved = rs.getClob(1);
        PreparedStatementTest.assertEquals((String)"Mismatch test data in/out", (String)testString, (String)clobRetrieved.getSubString(1L, testString.length()));
    }

    public void testSetAsciiStream() throws Exception {
        byte[] bytes1 = new byte[10];
        ByteArrayInputStream is = new ByteArrayInputStream(BYTES);
        ((InputStream)is).reset();
        this.psInsertClob.setInt(1, this.key);
        this.psInsertClob.setAsciiStream(2, (InputStream)is, BYTES.length);
        this.psInsertClob.executeUpdate();
        this.psFetchClob.setInt(1, this.key);
        ResultSet rs = this.psFetchClob.executeQuery();
        rs.next();
        Clob ClobRetrieved = rs.getClob(1);
        try {
            InputStream is_ret = ClobRetrieved.getAsciiStream();
            is_ret.read(bytes1);
        }
        catch (IOException ioe) {
            PreparedStatementTest.fail((String)"IOException while reading the Clob from the database");
        }
        for (int i = 0; i < BYTES.length; ++i) {
            PreparedStatementTest.assertEquals((String)"Error in inserting data into the Clob", (byte)BYTES[i], (byte)bytes1[i]);
        }
        this.psInsertClob.close();
        rs.close();
    }

    public void testSetAsciiStreamLengthless() throws IOException, SQLException {
        ByteArrayInputStream is = new ByteArrayInputStream(BYTES);
        this.psInsertClob.setInt(1, this.key);
        this.psInsertClob.setAsciiStream(2, is);
        this.psInsertClob.execute();
        ((InputStream)is).close();
        this.psFetchClob.setInt(1, this.key);
        ResultSet rs = this.psFetchClob.executeQuery();
        PreparedStatementTest.assertTrue((String)"No results retrieved", (boolean)rs.next());
        Clob clobRetrieved = rs.getClob(1);
        byte[] dbBytes = new byte[10];
        InputStream isRetrieved = clobRetrieved.getAsciiStream();
        PreparedStatementTest.assertEquals((String)"Unexpected number of bytes read", (int)BYTES.length, (int)isRetrieved.read(dbBytes));
        PreparedStatementTest.assertEquals((String)"Stream should be exhausted", (int)-1, (int)isRetrieved.read());
        for (int i = 0; i < BYTES.length; ++i) {
            PreparedStatementTest.assertEquals((String)"Byte mismatch in/out", (byte)BYTES[i], (byte)dbBytes[i]);
        }
        isRetrieved.close();
        this.psInsertClob.close();
    }

    public void testSetBinaryStream() throws Exception {
        byte[] bytes1 = new byte[10];
        ByteArrayInputStream is = new ByteArrayInputStream(BYTES);
        ((InputStream)is).reset();
        this.psInsertBlob.setInt(1, this.key);
        this.psInsertBlob.setBinaryStream(2, (InputStream)is, BYTES.length);
        this.psInsertBlob.executeUpdate();
        this.psFetchBlob.setInt(1, this.key);
        ResultSet rs = this.psFetchBlob.executeQuery();
        rs.next();
        Blob blobRetrieved = rs.getBlob(1);
        try {
            InputStream is_ret = blobRetrieved.getBinaryStream();
            is_ret.read(bytes1);
        }
        catch (IOException ioe) {
            PreparedStatementTest.fail((String)"IOException while reading the Clob from the database");
        }
        rs.close();
        for (int i = 0; i < BYTES.length; ++i) {
            PreparedStatementTest.assertEquals((String)"Error in inserting data into the Blob", (byte)BYTES[i], (byte)bytes1[i]);
        }
        this.psInsertBlob.close();
    }

    public void testSetBinaryStreamLengthless() throws IOException, SQLException {
        ByteArrayInputStream is = new ByteArrayInputStream(BYTES);
        this.psInsertBlob.setInt(1, this.key);
        this.psInsertBlob.setBinaryStream(2, is);
        this.psInsertBlob.execute();
        ((InputStream)is).close();
        this.psFetchBlob.setInt(1, this.key);
        ResultSet rs = this.psFetchBlob.executeQuery();
        PreparedStatementTest.assertTrue((String)"No results retrieved", (boolean)rs.next());
        Blob blobRetrieved = rs.getBlob(1);
        byte[] dbBytes = new byte[10];
        InputStream isRetrieved = blobRetrieved.getBinaryStream();
        PreparedStatementTest.assertEquals((String)"Unexpected number of bytes read", (int)BYTES.length, (int)isRetrieved.read(dbBytes));
        PreparedStatementTest.assertEquals((String)"Stream should be exhausted", (int)-1, (int)isRetrieved.read());
        for (int i = 0; i < BYTES.length; ++i) {
            PreparedStatementTest.assertEquals((String)"Byte mismatch in/out", (byte)BYTES[i], (byte)dbBytes[i]);
        }
        isRetrieved.close();
        this.psInsertBlob.close();
    }

    public void testSetBinaryStreamLengthLess1KOnBlob() throws IOException, SQLException {
        int length = 1024;
        this.setBinaryStreamOnBlob(this.key, length, -1, 0, true);
        this.psFetchBlob.setInt(1, this.key);
        ResultSet rs = this.psFetchBlob.executeQuery();
        PreparedStatementTest.assertTrue((String)"Empty resultset", (boolean)rs.next());
        PreparedStatementTest.assertEquals(new LoopingAlphabetStream(length), rs.getBinaryStream(1));
        PreparedStatementTest.assertFalse((String)"Resultset should have been exhausted", (boolean)rs.next());
        rs.close();
    }

    public void testSetBinaryStreamLengthLess32KOnBlob() throws IOException, SQLException {
        int length = 32768;
        this.setBinaryStreamOnBlob(this.key, length, -1, 0, true);
        this.psFetchBlob.setInt(1, this.key);
        ResultSet rs = this.psFetchBlob.executeQuery();
        PreparedStatementTest.assertTrue((String)"Empty resultset", (boolean)rs.next());
        PreparedStatementTest.assertEquals(new LoopingAlphabetStream(length), rs.getBinaryStream(1));
        PreparedStatementTest.assertFalse((String)"Resultset should have been exhausted", (boolean)rs.next());
        rs.close();
    }

    public void testSetBinaryStreamLengthLess65KOnBlob() throws IOException, SQLException {
        int length = 66560;
        this.setBinaryStreamOnBlob(this.key, length, -1, 0, true);
        this.psFetchBlob.setInt(1, this.key);
        ResultSet rs = this.psFetchBlob.executeQuery();
        PreparedStatementTest.assertTrue((String)"Empty resultset", (boolean)rs.next());
        LoopingAlphabetStream s1 = new LoopingAlphabetStream(length);
        PreparedStatementTest.assertEquals(new LoopingAlphabetStream(length), rs.getBinaryStream(1));
        PreparedStatementTest.assertFalse((String)"Resultset should have been exhausted", (boolean)rs.next());
        rs.close();
    }

    public void testSetBinaryStreamLengthLessOnBlobTooLong() {
        int length = 0x100200;
        try {
            this.setBinaryStreamOnBlob(this.key, length, -1, 0, true);
        }
        catch (SQLException sqle) {
            if (PreparedStatementTest.usingEmbedded() || PreparedStatementTest.usingDerbyNetClient()) {
                PreparedStatementTest.assertSQLState("XSDA4", sqle);
            }
            PreparedStatementTest.assertSQLState("22001", sqle);
        }
    }

    public void testExceptionPathOnePage_bs() throws SQLException {
        int length = 11;
        try {
            this.setBinaryStreamOnBlob(this.key, length - 1, length, 0, false);
            PreparedStatementTest.fail((String)"Inserted a BLOB with fewer bytes than specified");
        }
        catch (SQLException sqle) {
            if (PreparedStatementTest.usingEmbedded()) {
                PreparedStatementTest.assertSQLState("XSDA4", sqle);
            }
            PreparedStatementTest.assertSQLState("XN017", sqle);
        }
    }

    public void testExceptionPathMultiplePages_bs() throws SQLException {
        int length = 0x100000;
        try {
            this.setBinaryStreamOnBlob(this.key, length - 1, length, 0, false);
            PreparedStatementTest.fail((String)"Inserted a BLOB with fewer bytes than specified");
        }
        catch (SQLException sqle) {
            if (PreparedStatementTest.usingEmbedded()) {
                PreparedStatementTest.assertSQLState("XSDA4", sqle);
            }
            PreparedStatementTest.assertSQLState("XN017", sqle);
        }
    }

    public void testBlobExceptionDoesNotRollbackOtherStatements() throws IOException, SQLException {
        ResultSet rs;
        int i;
        this.getConnection().setAutoCommit(false);
        int[] keys = new int[]{this.key, PreparedStatementTest.requestKey(), PreparedStatementTest.requestKey()};
        for (int i2 = 0; i2 < keys.length; ++i2) {
            this.psInsertBlob.setInt(1, keys[i2]);
            this.psInsertBlob.setNull(2, 2004);
            PreparedStatementTest.assertEquals((int)1, (int)this.psInsertBlob.executeUpdate());
        }
        int failedKey = PreparedStatementTest.requestKey();
        int length = 0x100000;
        try {
            this.setBinaryStreamOnBlob(failedKey, length - 1, length, 0, false);
            PreparedStatementTest.fail((String)"Inserted a BLOB with less data than specified");
        }
        catch (SQLException sqle) {
            if (PreparedStatementTest.usingEmbedded()) {
                PreparedStatementTest.assertSQLState("XSDA4", sqle);
            }
            PreparedStatementTest.assertSQLState("XN017", sqle);
        }
        for (i = 0; i < keys.length; ++i) {
            this.psFetchBlob.setInt(1, keys[i]);
            rs = this.psFetchBlob.executeQuery();
            PreparedStatementTest.assertTrue((boolean)rs.next());
            PreparedStatementTest.assertFalse((boolean)rs.next());
            rs.close();
        }
        this.psFetchBlob.setInt(1, failedKey);
        rs = this.psFetchBlob.executeQuery();
        if (!PreparedStatementTest.usingEmbedded()) {
            PreparedStatementTest.assertTrue((boolean)rs.next());
            InputStream is = rs.getBinaryStream(1);
            int lastByte = -1;
            int b = 99;
            while (b > -1) {
                lastByte = b;
                b = is.read();
            }
            PreparedStatementTest.assertEquals((String)"Last padded byte is not 0", (int)0, (int)lastByte);
        }
        PreparedStatementTest.assertFalse((boolean)rs.next());
        rs.close();
        this.rollback();
        for (i = 0; i < keys.length; ++i) {
            this.psFetchBlob.setInt(1, keys[i]);
            rs = this.psFetchBlob.executeQuery();
            PreparedStatementTest.assertFalse((boolean)rs.next());
            rs.close();
        }
        this.psFetchBlob.setInt(1, failedKey);
        rs = this.psFetchBlob.executeQuery();
        PreparedStatementTest.assertFalse((boolean)rs.next());
    }

    public void testSetAsciiStreamLengthLess1KOnClob() throws IOException, SQLException {
        int length = 1024;
        this.setAsciiStream(this.psInsertClob, this.key, length, -1, 0, true);
        this.psFetchClob.setInt(1, this.key);
        ResultSet rs = this.psFetchClob.executeQuery();
        PreparedStatementTest.assertTrue((String)"Empty resultset", (boolean)rs.next());
        PreparedStatementTest.assertEquals(new LoopingAlphabetStream(length), rs.getAsciiStream(1));
        PreparedStatementTest.assertFalse((String)"Resultset should have been exhausted", (boolean)rs.next());
        rs.close();
    }

    public void testSetAsciiStreamLengthLess32KOnClob() throws IOException, SQLException {
        int length = 32768;
        this.setAsciiStream(this.psInsertClob, this.key, length, -1, 0, true);
        this.psFetchClob.setInt(1, this.key);
        ResultSet rs = this.psFetchClob.executeQuery();
        PreparedStatementTest.assertTrue((String)"Empty resultset", (boolean)rs.next());
        PreparedStatementTest.assertEquals(new LoopingAlphabetStream(length), rs.getAsciiStream(1));
        PreparedStatementTest.assertFalse((String)"Resultset should have been exhausted", (boolean)rs.next());
        rs.close();
    }

    public void testSetAsciiStreamLengthLess65KOnClob() throws IOException, SQLException {
        int length = 66560;
        this.setAsciiStream(this.psInsertClob, this.key, length, -1, 0, true);
        this.psFetchClob.setInt(1, this.key);
        ResultSet rs = this.psFetchClob.executeQuery();
        PreparedStatementTest.assertTrue((String)"Empty resultset", (boolean)rs.next());
        PreparedStatementTest.assertEquals(new LoopingAlphabetStream(length), rs.getAsciiStream(1));
        PreparedStatementTest.assertFalse((String)"Resultset should have been exhausted", (boolean)rs.next());
        rs.close();
    }

    public void testSetAsciiStreamLengthLessOnClobTooLong() {
        int length = 0x100200;
        try {
            this.setAsciiStream(this.psInsertClob, this.key, length, -1, 0, true);
        }
        catch (SQLException sqle) {
            if (PreparedStatementTest.usingEmbedded() || PreparedStatementTest.usingDerbyNetClient()) {
                PreparedStatementTest.assertSQLState("XSDA4", sqle);
            }
            PreparedStatementTest.assertSQLState("22001", sqle);
        }
    }

    public void testSetAsciiStreamLengthLessOnClobTooLongTruncate() throws SQLException {
        int trailingBlanks = 512;
        int length = 0x100000 + trailingBlanks;
        this.setAsciiStream(this.psInsertClob, this.key, length, -1, trailingBlanks, true);
    }

    public void testSetAsciiStreamLengthlessOnLongVarCharTooLong() {
        int length = 33212;
        try {
            this.setAsciiStream(this.psInsertLongVarchar, this.key, length, -1, 0, true);
            PreparedStatementTest.fail((String)"Inserted a LONG VARCHAR that is too long");
        }
        catch (SQLException sqle) {
            if (PreparedStatementTest.usingEmbedded()) {
                this.assertInternalDerbyIOExceptionState("XCL30", "22001", sqle);
            }
            if (PreparedStatementTest.usingDerbyNetClient()) {
                PreparedStatementTest.assertSQLState("XCL30", sqle);
            }
            PreparedStatementTest.assertSQLState("22001", sqle);
        }
    }

    public void testSetAsciiStreamLengthlessOnLongVarCharDontTruncate() {
        int trailingBlanks = 2000;
        int length = 32000 + trailingBlanks;
        try {
            this.setAsciiStream(this.psInsertLongVarchar, this.key, length, -1, trailingBlanks, true);
            PreparedStatementTest.fail((String)"Truncation is not allowed for LONG VARCHAR");
        }
        catch (SQLException sqle) {
            if (PreparedStatementTest.usingEmbedded()) {
                this.assertInternalDerbyIOExceptionState("XCL30", "22001", sqle);
            }
            if (PreparedStatementTest.usingDerbyNetClient()) {
                PreparedStatementTest.assertSQLState("XCL30", sqle);
            }
            PreparedStatementTest.assertSQLState("22001", sqle);
        }
    }

    private void setBinaryStreamOnBlob(int id, int actualLength, int specifiedLength, int trailingBlanks, boolean lengthLess) throws SQLException {
        this.psInsertBlob.setInt(1, id);
        if (lengthLess) {
            this.psInsertBlob.setBinaryStream(2, new LoopingAlphabetStream((long)actualLength, trailingBlanks));
        } else {
            this.psInsertBlob.setBinaryStream(2, (InputStream)new LoopingAlphabetStream((long)actualLength, trailingBlanks), specifiedLength);
        }
        PreparedStatementTest.assertEquals((String)"Insert with setBinaryStream failed", (int)1, (int)this.psInsertBlob.executeUpdate());
    }

    private void setAsciiStream(PreparedStatement ps, int id, int actualLength, int specifiedLength, int trailingBlanks, boolean lengthLess) throws SQLException {
        ps.setInt(1, id);
        if (lengthLess) {
            ps.setAsciiStream(2, new LoopingAlphabetStream((long)actualLength, trailingBlanks));
        } else {
            ps.setAsciiStream(2, (InputStream)new LoopingAlphabetStream((long)actualLength, trailingBlanks), specifiedLength);
        }
        PreparedStatementTest.assertEquals((String)"Insert with setAsciiStream failed", (int)1, (int)ps.executeUpdate());
    }

    private static int requestKey() {
        return globalKey++;
    }

    private void assertInternalDerbyIOExceptionState(String preSQLState, String expectedInternal, SQLException sqle) {
        PreparedStatementTest.assertSQLState("Outer/public SQL state incorrect", preSQLState, sqle);
        Throwable cause = this.getLastSQLException(sqle).getCause();
        PreparedStatementTest.assertTrue((String)"Exception not an EmbedSQLException", (boolean)(cause instanceof EmbedSQLException));
        cause = cause.getCause();
        PreparedStatementTest.assertTrue((String)"Exception not a DerbyIOException", (boolean)(cause instanceof DerbyIOException));
        DerbyIOException dioe = (DerbyIOException)cause;
        PreparedStatementTest.assertEquals((String)"Incorrect internal SQL state", (String)expectedInternal, (String)dioe.getSQLState());
    }
}

