/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ServerPropertiesTest
extends BaseJDBCTestCase {
    private static String POLICY_FILE_NAME = "functionTests/tests/derbynet/ServerPropertiesTest.policy";
    private static String TARGET_POLICY_FILE_NAME = "server.policy";
    private int[] portsSoFar;

    public ServerPropertiesTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ServerPropertiesTest");
        if (!Derby.hasServer()) {
            return suite;
        }
        if (JDBC.vmSupportsJSR169()) {
            return suite;
        }
        suite.addTest(ServerPropertiesTest.decorateTest("ttestSetPortPriority", new String[0], new String[0], false));
        String[] badServerProperties = new String[]{"derby.drda.logConnections=", "derby.drda.traceAll=", "derby.drda.traceDirectory=", "derby.drda.keepAlive=", "derby.drda.timeSlice=", "derby.drda.host=", "derby.drda.portNumber=", "derby.drda.minThreads=", "derby.drda.maxThreads=", "derby.drda.startNetworkServer=", "derby.drda.debug="};
        if (TestConfiguration.loadingFromJars()) {
            suite.addTest(ServerPropertiesTest.decorateTest("ttestDefaultProperties", badServerProperties, new String[0], true));
        }
        if (!Locale.getDefault().getLanguage().equals("en")) {
            return suite;
        }
        Test test = TestConfiguration.clientServerSuite(ServerPropertiesTest.class);
        test = ServerPropertiesTest.decorateWithPolicy(test);
        suite.addTest(test);
        return suite;
    }

    public void tearDown() throws Exception {
        super.tearDown();
        POLICY_FILE_NAME = null;
        TARGET_POLICY_FILE_NAME = null;
        if (this.portsSoFar != null) {
            for (int i = 0; i < this.portsSoFar.length; ++i) {
                try {
                    this.shutdownServer(this.portsSoFar[i], true);
                    continue;
                }
                catch (SQLException e) {
                    ServerPropertiesTest.fail((String)("could not shutdown server at port " + this.portsSoFar[i]));
                }
            }
            this.portsSoFar = null;
        }
    }

    private static Test decorateTest(String testName, String[] startupProperties, String[] startupArgs, boolean startServer) {
        ServerPropertiesTest spt = new ServerPropertiesTest(testName);
        String[] startupProps = startupProperties == null ? new String[]{} : startupProperties;
        if (startupArgs == null) {
            startupArgs = new String[]{};
        }
        NetworkServerTestSetup networkServerTestSetup = startServer ? new NetworkServerTestSetup((Test)spt, startupProps, startupArgs, true) : new NetworkServerTestSetup((Test)spt, true, false);
        Test test = ServerPropertiesTest.decorateWithPolicy((Test)networkServerTestSetup);
        test = TestConfiguration.defaultServerDecorator(test);
        return test;
    }

    private String makeServerPolicyName() {
        try {
            String userDir = ServerPropertiesTest.getSystemProperty("user.dir");
            String fileName = userDir + File.separator + "extinout" + File.separator + TARGET_POLICY_FILE_NAME;
            File file = new File(fileName);
            String urlString = file.toURL().toExternalForm();
            return urlString;
        }
        catch (Exception e) {
            System.out.println("Unexpected exception caught by makeServerPolicyName(): " + e);
            return null;
        }
    }

    private static Test decorateWithPolicy(Test test) {
        String serverPolicyName = new ServerPropertiesTest("test").makeServerPolicyName();
        test = new SecurityManagerSetup((Test)test, serverPolicyName);
        test = new SupportFilesSetup((Test)test, null, new String[]{POLICY_FILE_NAME}, null, new String[]{TARGET_POLICY_FILE_NAME});
        return test;
    }

    private static void verifyProperties(String[] expectedValues) {
        int i;
        Properties p;
        try {
            p = NetworkServerTestSetup.getNetworkServerControl().getCurrentProperties();
        }
        catch (Exception e) {
            p = null;
            e.printStackTrace();
            ServerPropertiesTest.fail((String)"unexpected exception getting properties from server");
        }
        Enumeration<?> e = p.propertyNames();
        for (i = 0; i < expectedValues.length; ++i) {
            ServerPropertiesTest.println("expV: " + expectedValues[i]);
        }
        ServerPropertiesTest.assertEquals((int)expectedValues.length, (int)p.size());
        for (i = 0; i < p.size(); ++i) {
            String propName = (String)e.nextElement();
            ServerPropertiesTest.println("propName: " + propName);
            String propval = (String)p.get(propName);
            ServerPropertiesTest.assertEquals((String)expectedValues[i], (String)propval);
        }
        p = null;
    }

    public int getAlternativePort() throws SQLException {
        Exception failException = null;
        int possiblePort = TestConfiguration.getCurrent().getPort();
        possiblePort = possiblePort <= 0 ? 1528 : ++possiblePort;
        try {
            boolean portOK = false;
            while (!portOK) {
                NetworkServerControl networkServer = new NetworkServerControl(InetAddress.getByName("localhost"), possiblePort);
                boolean started = false;
                try {
                    networkServer.ping();
                    started = true;
                }
                catch (Exception e) {
                    failException = e;
                }
                if (!started) {
                    portOK = true;
                    continue;
                }
                ++possiblePort;
            }
        }
        catch (Exception e) {
            SQLException se = new SQLException("Error pinging network server");
            se.initCause(failException);
            throw se;
        }
        return possiblePort;
    }

    private boolean canPingServer(int port, boolean expectServerUp) throws SQLException {
        boolean serverUp = false;
        try {
            serverUp = NetworkServerTestSetup.pingForServerUp(NetworkServerTestSetup.getNetworkServerControl(port), null, expectServerUp);
        }
        catch (Exception e) {
            ServerPropertiesTest.fail((String)"unexpected Exception while pinging");
        }
        return serverUp;
    }

    private String shutdownServer(int port, boolean specifyPort) throws SQLException {
        try {
            if (specifyPort) {
                NetworkServerControl nsctrl = NetworkServerTestSetup.getNetworkServerControl(port);
                nsctrl.shutdown();
            } else {
                NetworkServerControl nsctrl = NetworkServerTestSetup.getNetworkServerControlDefault();
                nsctrl.shutdown();
            }
        }
        catch (Exception e) {
            return "failed to shutdown server with API parameter (" + e + ")";
        }
        if (this.canPingServer(port, false)) {
            return "Can still ping server";
        }
        return null;
    }

    public String startServer(int port, boolean specifyPort) throws SQLException {
        try {
            if (specifyPort) {
                NetworkServerControl nsctrl = NetworkServerTestSetup.getNetworkServerControl(port);
                nsctrl.start(null);
                NetworkServerTestSetup.waitForServerStart(nsctrl);
            } else {
                NetworkServerControl nsctrl = NetworkServerTestSetup.getNetworkServerControlDefault();
                nsctrl.start(null);
                NetworkServerTestSetup.waitForServerStart(nsctrl);
            }
        }
        catch (Exception e) {
            return "failed to start server with port " + port;
        }
        if (!this.canPingServer(port, true)) {
            return "Cannot ping server started with port set to " + port;
        }
        return null;
    }

    public void checkWhetherNeedToShutdown(int[] ports, String failReason) {
        this.portsSoFar = ports;
        if (failReason != null) {
            ServerPropertiesTest.fail((String)failReason);
        }
    }

    private void assertSuccessfulCmd(String expectedString, String[] Cmd) throws InterruptedException, IOException {
        this.assertExecJavaCmdAsExpected(new String[]{expectedString}, Cmd, 0);
    }

    public void ttestSetPortPriority() throws SQLException, InterruptedException, IOException {
        NetworkServerTestSetup.setWaitTime(0L);
        if (this.canPingServer(1527, false)) {
            this.shutdownServer(1527, false);
        }
        NetworkServerTestSetup.setDefaultWaitTime();
        String actionResult = this.startServer(1527, false);
        this.checkWhetherNeedToShutdown(new int[]{1527}, actionResult);
        int firstAlternatePort = this.getAlternativePort();
        final Properties derbyProperties = new Properties();
        derbyProperties.put("derby.drda.portNumber", new Integer(firstAlternatePort).toString());
        final String derbyHome = ServerPropertiesTest.getSystemProperty("derby.system.home");
        Boolean b = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                boolean fail = false;
                try {
                    FileOutputStream propFile = new FileOutputStream(derbyHome + File.separator + "derby.properties");
                    derbyProperties.store(propFile, "testing derby.properties");
                    propFile.close();
                }
                catch (IOException ioe) {
                    fail = true;
                }
                return new Boolean(fail);
            }
        });
        if (b.booleanValue()) {
            this.checkWhetherNeedToShutdown(new int[]{1527}, "failed to write derby.properties");
        }
        TestConfiguration.getCurrent().shutdownEngine();
        actionResult = this.startServer(firstAlternatePort, false);
        this.checkWhetherNeedToShutdown(new int[]{1527, firstAlternatePort}, actionResult);
        int secondAlternatePort = this.getAlternativePort();
        ServerPropertiesTest.setSystemProperty("derby.drda.portNumber", new Integer(secondAlternatePort).toString());
        actionResult = this.startServer(secondAlternatePort, false);
        this.checkWhetherNeedToShutdown(new int[]{1527, firstAlternatePort, secondAlternatePort}, actionResult);
        int thirdAlternatePort = this.getAlternativePort();
        actionResult = this.startServer(thirdAlternatePort, true);
        this.checkWhetherNeedToShutdown(new int[]{1527, firstAlternatePort, secondAlternatePort, thirdAlternatePort}, actionResult);
        int fourthAlternatePort = this.getAlternativePort();
        String[] commandArray = new String[]{"-Dderby.system.home=" + derbyHome, "org.apache.derby.drda.NetworkServerControl", "-p", String.valueOf(fourthAlternatePort).toString(), "-noSecurityManager", "start"};
        this.execJavaCmd(commandArray);
        if (!this.canPingServer(fourthAlternatePort, true)) {
            actionResult = "Can not ping server specified with -p";
        }
        this.checkWhetherNeedToShutdown(new int[]{1527, firstAlternatePort, secondAlternatePort, thirdAlternatePort, fourthAlternatePort}, actionResult);
        commandArray = new String[]{"-Dderby.system.home=" + derbyHome, "org.apache.derby.drda.NetworkServerControl", "-p", String.valueOf(fourthAlternatePort).toString(), "-noSecurityManager", "shutdown"};
        this.execJavaCmd(commandArray);
        if (this.canPingServer(fourthAlternatePort, false)) {
            actionResult = "Can still ping server specified with -p";
        }
        this.checkWhetherNeedToShutdown(new int[]{1527, firstAlternatePort, secondAlternatePort, thirdAlternatePort, fourthAlternatePort}, actionResult);
        actionResult = this.shutdownServer(thirdAlternatePort, true);
        this.checkWhetherNeedToShutdown(new int[]{1527, firstAlternatePort, secondAlternatePort, thirdAlternatePort}, actionResult);
        actionResult = this.shutdownServer(secondAlternatePort, false);
        this.checkWhetherNeedToShutdown(new int[]{1527, firstAlternatePort, secondAlternatePort}, actionResult);
        ServerPropertiesTest.removeSystemProperty("derby.drda.portNumber");
        actionResult = this.shutdownServer(firstAlternatePort, false);
        this.checkWhetherNeedToShutdown(new int[]{1527, firstAlternatePort}, actionResult);
        Boolean ret = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new File(derbyHome + File.separator + "derby.properties").delete();
            }
        });
        if (!ret.booleanValue()) {
            this.checkWhetherNeedToShutdown(new int[]{1527, firstAlternatePort}, "unable to remove derby.properties");
        }
        TestConfiguration.getCurrent().shutdownEngine();
        actionResult = this.shutdownServer(1527, false);
        this.checkWhetherNeedToShutdown(new int[]{1527}, actionResult);
    }

    public void ttestDefaultProperties() throws SQLException {
        ServerPropertiesTest.verifyProperties(new String[]{"0", "off", "true", "0", String.valueOf(TestConfiguration.getCurrent().getPort()), "false", "0", "false", String.valueOf(TestConfiguration.getCurrent().getHostName()), "false"});
    }

    public void testToggleTrace() throws SQLException, IOException, InterruptedException {
        String[] expectedTraceOff = new String[]{ServerPropertiesTest.getSystemProperty("derby.system.home"), "0", "off", "true", "0", String.valueOf(TestConfiguration.getCurrent().getPort()), "false", "0", "false", "127.0.0.1", "false"};
        String[] expectedTraceOn = new String[]{ServerPropertiesTest.getSystemProperty("derby.system.home"), "0", "off", "true", "0", String.valueOf(TestConfiguration.getCurrent().getPort()), "false", "0", "false", "127.0.0.1", "true"};
        ServerPropertiesTest.verifyProperties(expectedTraceOff);
        String[] traceCmd = new String[]{"org.apache.derby.drda.NetworkServerControl", "trace", "on"};
        this.assertSuccessfulCmd("Trace turned on for all sessions.", traceCmd);
        ServerPropertiesTest.verifyProperties(expectedTraceOn);
        traceCmd = new String[]{"org.apache.derby.drda.NetworkServerControl", "trace", "off"};
        this.assertSuccessfulCmd("Trace turned off for all sessions", traceCmd);
        ServerPropertiesTest.verifyProperties(expectedTraceOff);
    }

    public void testToggleLogConnections() throws SQLException, IOException, InterruptedException {
        String[] expectedLogConnectionsOff = new String[]{ServerPropertiesTest.getSystemProperty("derby.system.home"), "0", "off", "true", "0", String.valueOf(TestConfiguration.getCurrent().getPort()), "false", "0", "false", "127.0.0.1", "false"};
        String[] expectedLogConnectionsOn = new String[]{ServerPropertiesTest.getSystemProperty("derby.system.home"), "0", "off", "true", "0", String.valueOf(TestConfiguration.getCurrent().getPort()), "true", "0", "false", "127.0.0.1", "false"};
        ServerPropertiesTest.verifyProperties(expectedLogConnectionsOff);
        String[] cmd = new String[]{"org.apache.derby.drda.NetworkServerControl", "logconnections", "on"};
        this.assertSuccessfulCmd("Log Connections changed to on.", cmd);
        ServerPropertiesTest.verifyProperties(expectedLogConnectionsOn);
        cmd = new String[]{"org.apache.derby.drda.NetworkServerControl", "logconnections", "off"};
        this.assertSuccessfulCmd("Log Connections changed to off.", cmd);
        ServerPropertiesTest.verifyProperties(expectedLogConnectionsOff);
    }
}

