/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.raw;

import com.sleepycat.persist.raw.RawType;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeSet;

public class RawObject {
    private static final String INDENT = "  ";
    private RawType type;
    private Map<String, Object> values;
    private Object[] elements;
    private String enumConstant;
    private RawObject superObject;

    public RawObject(RawType rawType, Map<String, Object> map, RawObject rawObject) {
        if (rawType == null || map == null) {
            throw new NullPointerException();
        }
        this.type = rawType;
        this.values = map;
        this.superObject = rawObject;
    }

    public RawObject(RawType rawType, Object[] objectArray) {
        if (rawType == null || objectArray == null) {
            throw new NullPointerException();
        }
        this.type = rawType;
        this.elements = objectArray;
    }

    public RawObject(RawType rawType, String string) {
        if (rawType == null || string == null) {
            throw new NullPointerException();
        }
        this.type = rawType;
        this.enumConstant = string;
    }

    public RawType getType() {
        return this.type;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public Object[] getElements() {
        return this.elements;
    }

    public String getEnum() {
        return this.enumConstant;
    }

    public RawObject getSuper() {
        return this.superObject;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RawObject)) {
            return false;
        }
        RawObject rawObject = (RawObject)object;
        if (this.type != rawObject.type) {
            return false;
        }
        if (!Arrays.deepEquals(this.elements, rawObject.elements)) {
            return false;
        }
        if (this.enumConstant != null ? !this.enumConstant.equals(rawObject.enumConstant) : rawObject.enumConstant != null) {
            return false;
        }
        if (this.values != null ? !this.values.equals(rawObject.values) : rawObject.values != null) {
            return false;
        }
        return !(this.superObject != null ? !this.superObject.equals(rawObject.superObject) : rawObject.superObject != null);
    }

    public int hashCode() {
        return System.identityHashCode(this.type) + Arrays.deepHashCode(this.elements) + (this.enumConstant != null ? this.enumConstant.hashCode() : 0) + (this.values != null ? this.values.hashCode() : 0) + (this.superObject != null ? this.superObject.hashCode() : 0);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(500);
        this.formatRawObject(stringBuffer, "", null, false);
        return stringBuffer.toString();
    }

    private void formatRawObject(StringBuffer stringBuffer, String string, String string2, boolean bl) {
        if (this.type.isEnum()) {
            stringBuffer.append(string);
            stringBuffer.append("<Enum");
            RawObject.formatId(stringBuffer, string2);
            stringBuffer.append(" class=\"");
            stringBuffer.append(this.type.getClassName());
            stringBuffer.append("\" typeId=\"");
            stringBuffer.append(this.type.getId());
            stringBuffer.append("\">");
            stringBuffer.append(this.enumConstant);
            stringBuffer.append("</Enum>\n");
        } else {
            String string3;
            String string4 = string + INDENT;
            stringBuffer.append(string);
            if (this.type.isArray()) {
                stringBuffer.append("<Array");
                string3 = "</Array>";
            } else if (bl) {
                stringBuffer.append("<Super");
                string3 = "</Super>";
            } else {
                stringBuffer.append("<Object");
                string3 = "</Object>";
            }
            RawObject.formatId(stringBuffer, string2);
            if (this.type.isArray()) {
                stringBuffer.append(" length=\"");
                stringBuffer.append(this.elements.length);
                stringBuffer.append('\"');
            }
            stringBuffer.append(" class=\"");
            stringBuffer.append(this.type.getClassName());
            stringBuffer.append("\" typeId=\"");
            stringBuffer.append(this.type.getId());
            stringBuffer.append("\">\n");
            if (this.superObject != null) {
                this.superObject.formatRawObject(stringBuffer, string4, null, true);
            }
            if (this.type.isArray()) {
                for (int i = 0; i < this.elements.length; ++i) {
                    RawObject.formatValue(stringBuffer, string4, String.valueOf(i), this.elements[i]);
                }
            } else {
                TreeSet<String> treeSet = new TreeSet<String>(this.values.keySet());
                for (String string5 : treeSet) {
                    RawObject.formatValue(stringBuffer, string4, string5, this.values.get(string5));
                }
            }
            stringBuffer.append(string);
            stringBuffer.append(string3);
            stringBuffer.append("\n");
        }
    }

    private static void formatValue(StringBuffer stringBuffer, String string, String string2, Object object) {
        if (object == null) {
            stringBuffer.append(string);
            stringBuffer.append("<Null");
            RawObject.formatId(stringBuffer, string2);
            stringBuffer.append("/>\n");
        } else if (object instanceof RawObject) {
            ((RawObject)object).formatRawObject(stringBuffer, string, string2, false);
        } else {
            stringBuffer.append(string);
            stringBuffer.append("<Value");
            RawObject.formatId(stringBuffer, string2);
            stringBuffer.append(" class=\"");
            stringBuffer.append(object.getClass().getName());
            stringBuffer.append("\">");
            stringBuffer.append(object.toString());
            stringBuffer.append("</Value>\n");
        }
    }

    private static void formatId(StringBuffer stringBuffer, String string) {
        if (string != null) {
            if (Character.isDigit(string.charAt(0))) {
                stringBuffer.append(" index=\"");
            } else {
                stringBuffer.append(" field=\"");
            }
            stringBuffer.append(string);
            stringBuffer.append('\"');
        }
    }
}

