/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

class VisitedObjects {
    static final int PRI_KEY_VISITED_OFFSET = 0x7FFFFFFE;
    static final int PROHIBIT_REF_OFFSET = 0x7FFFFFFD;
    static final Object PROHIBIT_REF_OBJECT = new Object();
    static final String PROHIBIT_NESTED_REF_MSG = "Cannot embed a reference to a proxied object in the proxy; for example, a collection may not be an element of the collection because collections are proxied";
    private static final int INIT_LEN = 50;
    private Object[] objects = new Object[50];
    private int[] offsets = new int[50];
    private int nextIndex = 0;

    VisitedObjects() {
    }

    int add(Object object, int n) {
        int n2 = this.nextIndex++;
        if (this.nextIndex > this.objects.length) {
            this.growVisitedArrays();
        }
        this.objects[n2] = object;
        this.offsets[n2] = n;
        return n2;
    }

    void setObject(int n, Object object) {
        this.objects[n] = object;
    }

    void setOffset(int n, int n2) {
        this.offsets[n] = n2;
    }

    int getOffset(Object object) {
        for (int i = 0; i < this.nextIndex; ++i) {
            if (this.objects[i] != object) continue;
            return this.offsets[i];
        }
        return -1;
    }

    Object getObject(int n) {
        for (int i = 0; i < this.nextIndex; ++i) {
            if (this.offsets[i] != n) continue;
            return this.objects[i];
        }
        return null;
    }

    void replaceObject(Object object, Object object2) {
        for (int i = this.nextIndex - 1; i >= 0; --i) {
            if (this.objects[i] != object) continue;
            this.objects[i] = object2;
            return;
        }
        assert (false);
    }

    private void growVisitedArrays() {
        int n = this.objects.length;
        int n2 = n * 2;
        Object[] objectArray = new Object[n2];
        int[] nArray = new int[n2];
        System.arraycopy(this.objects, 0, objectArray, 0, n);
        System.arraycopy(this.offsets, 0, nArray, 0, n);
        this.objects = objectArray;
        this.offsets = nArray;
    }
}

