/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.evolve;

import com.sleepycat.persist.evolve.Conversion;
import com.sleepycat.persist.evolve.Converter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class EntityConverter
extends Converter {
    private static final long serialVersionUID = -988428985370593743L;
    private Set<String> deletedKeys;

    public EntityConverter(String string, int n, Conversion conversion, Set<String> set) {
        super(string, n, null, conversion);
        this.deletedKeys = set != null ? new HashSet<String>(set) : Collections.emptySet();
    }

    public Set<String> getDeletedKeys() {
        return Collections.unmodifiableSet(this.deletedKeys);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof EntityConverter) {
            EntityConverter entityConverter = (EntityConverter)object;
            return this.deletedKeys.equals(entityConverter.deletedKeys) && super.equals(object);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.deletedKeys.hashCode() + super.hashCode();
    }

    @Override
    public String toString() {
        return "[EntityConverter " + super.toString() + " DeletedKeys: " + this.deletedKeys + ']';
    }
}

