/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.collections.BaseIterator;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.StoredCollection;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.OperationStatus;
import java.util.Set;

public class StoredValueSet<E>
extends StoredCollection<E>
implements Set<E> {
    public StoredValueSet(Database database, EntryBinding<E> entryBinding, boolean bl) {
        super(new DataView(database, null, entryBinding, null, bl, null));
    }

    public StoredValueSet(Database database, EntityBinding<E> entityBinding, boolean bl) {
        super(new DataView(database, null, null, entityBinding, bl, null));
    }

    StoredValueSet(DataView dataView) {
        super(dataView);
    }

    @Override
    public boolean add(E e) {
        if (this.view.isSecondary()) {
            throw new UnsupportedOperationException("add() not allowed with index");
        }
        if (this.view.range.isSingleKey()) {
            if (!this.view.dupsAllowed) {
                throw new UnsupportedOperationException("duplicates required");
            }
            DataCursor dataCursor = null;
            boolean bl = this.beginAutoCommit();
            try {
                dataCursor = new DataCursor(this.view, true);
                dataCursor.useRangeKey();
                OperationStatus operationStatus = dataCursor.putNoDupData(null, e, null, true);
                this.closeCursor(dataCursor);
                this.commitAutoCommit(bl);
                return operationStatus == OperationStatus.SUCCESS;
            }
            catch (Exception exception) {
                this.closeCursor(dataCursor);
                throw this.handleException(exception, bl);
            }
        }
        if (this.view.entityBinding == null) {
            throw new UnsupportedOperationException("add() requires entity binding");
        }
        return this.add(null, e);
    }

    @Override
    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    @Override
    public boolean remove(Object object) {
        return this.removeValue(object);
    }

    @Override
    E makeIteratorData(BaseIterator baseIterator, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3) {
        return (E)this.view.makeValue(databaseEntry2, databaseEntry3);
    }

    @Override
    boolean hasValues() {
        return true;
    }
}

