/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.web;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.basex.io.serial.SerializerMode;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.http.HTTPText;
import org.basex.util.options.NumberOption;
import org.basex.util.options.Option;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;

public abstract class WebFn
extends StandardFunc {
    final String createUrl(QueryContext qc) throws QueryException {
        byte[] href = this.toToken(this.arg(0), qc);
        XQMap params = this.toEmptyMap(this.arg(1), qc);
        byte[] anchor = this.toZeroToken(this.arg(2), qc);
        TokenBuilder url = WebFn.createUrl(href, params, '&', this.info);
        if (anchor.length > 0) {
            url.add(35).add(Token.encodeUri(anchor, Token.UriEncoder.URI));
        }
        return url.toString();
    }

    public static TokenBuilder createUrl(byte[] href, XQMap params, char sep, InputInfo info) throws QueryException {
        TokenBuilder url = new TokenBuilder().add(href);
        AtomicInteger c = new AtomicInteger();
        params.forEach((key, value) -> {
            byte[] name = key.string(info);
            for (Item item : value) {
                url.add(c.getAndIncrement() == 0 ? 63 : (int)sep).add(Token.encodeUri(name, Token.UriEncoder.URI));
                url.add(61).add(Token.encodeUri(item.string(info), Token.UriEncoder.URI));
            }
        });
        return url;
    }

    final FNode createResponse(ResponseOptions response, HashMap<String, String> headers, HashMap<String, String> attributes) throws QueryException {
        FBuilder rrest = FElem.build(HTTPText.Q_REST_RESPONSE).declareNS();
        FBuilder hresp = FElem.build(HTTPText.Q_HTTP_RESPONSE).declareNS();
        for (Option<?> o : response) {
            if (!response.contains(o)) continue;
            hresp.add(new QNm(o.name()), response.get(o));
        }
        headers.forEach((name, value) -> {
            if (!value.isEmpty()) {
                hresp.add(FElem.build(HTTPText.Q_HTTP_HEADER).add(HTTPText.Q_NAME, name).add(HTTPText.Q_VALUE, value));
            }
        });
        rrest.add(hresp);
        if (attributes != null) {
            SerializerOptions sopts = SerializerMode.DEFAULT.get();
            for (String entry : attributes.keySet()) {
                if (sopts.option(entry) != null) continue;
                throw QueryError.UNKNOWNOPTION_X.get(this.info, entry);
            }
            FBuilder param = FElem.build(SerializerOptions.Q_ROOT).declareNS();
            attributes.forEach((name, value) -> {
                if (!value.isEmpty()) {
                    QNm qnm = new QNm(QueryText.OUTPUT_PREFIX, (String)name, QueryText.OUTPUT_URI);
                    param.add(FElem.build(qnm).add(HTTPText.Q_VALUE, value));
                }
            });
            rrest.add(param);
        }
        return rrest.finish();
    }

    public static class ResponseOptions
    extends Options {
        public static final NumberOption STATUS = new NumberOption("status");
        public static final StringOption MESSAGE = new StringOption("message");
    }
}

