/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import java.io.IOException;
import org.basex.core.Stores;
import org.basex.data.Data;
import org.basex.index.resource.ResourceType;
import org.basex.io.IOFile;
import org.basex.io.in.DataInput;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.db.DbAccessFn;
import org.basex.query.value.Value;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.Types;

public class DbGetValue
extends DbAccessFn {
    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.value(ResourceType.VALUE, qc);
    }

    final Value value(ResourceType type, QueryContext qc) throws QueryException {
        Data data = this.toData(qc);
        String path = this.toDbPathOrNull(this.arg(1), qc);
        if (data.inMemory()) {
            throw QueryError.DB_MAINMEM_X.get(this.info, data.meta.name);
        }
        try {
            if (path != null) {
                IOFile bin = data.meta.file(path, type);
                if (!bin.exists() || bin.isDir()) {
                    throw QueryError.WHICHRES_X.get(this.info, path);
                }
                return this.resource(bin, qc);
            }
            MapBuilder mb = new MapBuilder();
            IOFile bin = data.meta.dir(type);
            for (String pth : data.resources.paths("", type)) {
                mb.put(pth, this.resource(type.filePath(bin, pth), qc));
            }
            return mb.map();
        }
        catch (IOException ex) {
            throw QueryError.IOERR_X.get(this.info, ex);
        }
    }

    Value resource(IOFile path, QueryContext qc) throws IOException, QueryException {
        try (DataInput in = new DataInput(path);){
            Value value = Stores.read(in, qc);
            return value;
        }
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        if (!this.defined(1)) {
            this.exprType.assign(MapType.get(AtomType.STRING, Types.ITEM_ZM).seqType());
        }
        return this;
    }
}

