/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.core.MainOptions;
import org.basex.http.web.WebModule;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.ann.Ann;
import org.basex.query.expr.Expr;
import org.basex.query.func.StaticFunc;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.Token;
import org.basex.util.XMLToken;
import org.basex.util.list.StringList;

public abstract class WebFunction
implements Comparable<WebFunction> {
    private static final Pattern TEMPLATE = Pattern.compile("\\s*\\{\\s*\\$(.+?)\\s*}\\s*");
    public final StaticFunc function;
    public final WebModule module;
    public final SerializerOptions sopts;
    public final ArrayList<WebParam> headerParams = new ArrayList();

    protected WebFunction(StaticFunc function, WebModule module, QueryContext qc) {
        this.function = function;
        this.module = module;
        this.sopts = qc.parameters();
    }

    public abstract boolean parseAnnotations(MainOptions var1) throws QueryException, IOException;

    protected abstract QueryException error(String var1, Object ... var2);

    protected final QNm checkVariable(String tmp, boolean ... declared) throws QueryException {
        Matcher matcher = TEMPLATE.matcher(tmp);
        if (!matcher.find()) {
            throw this.error("Invalid path template: \"%\".", tmp);
        }
        byte[] qname = Token.token((String)matcher.group(1));
        if (!XMLToken.isQName((byte[])qname)) {
            throw this.error("Invalid variable name: $%.", new Object[]{qname});
        }
        return this.checkVariable(new QNm(qname), declared);
    }

    protected final boolean checkParsed(boolean found, AnnList anns, boolean[] declared) throws QueryException {
        if (found) {
            int as = anns.size();
            if (as == 0) {
                throw this.error("Path annotation missing.", new Object[0]);
            }
            if (as > 1) {
                StringList names = new StringList((long)anns.size());
                for (Ann ann : anns) {
                    names.add((Object)("%" + Token.string((byte[])ann.definition.name.prefixId(QueryText.XQ_URI))));
                }
                throw this.error("Conflicting annotations: %.", String.join((CharSequence)", ", (CharSequence[])names.finish()));
            }
            int dl = declared.length;
            for (int d = 0; d < dl; ++d) {
                if (declared[d]) continue;
                throw this.error("No binding defined for $%.", new Object[]{this.function.params[d].name.string()});
            }
        }
        return found;
    }

    protected final QNm checkVariable(QNm name, boolean[] declared) throws QueryException {
        if (name.hasPrefix()) {
            name.uri(this.function.sc.ns.uri(name.prefix()));
        }
        int p = -1;
        Var[] params = this.function.params;
        int pl = params.length;
        while (++p < pl && !params[p].name.eq(name)) {
        }
        if (p == params.length) {
            throw this.error("Parameter $% missing in function declaration.", new Object[]{name.string()});
        }
        if (declared[p]) {
            throw this.error("$% is specified more than once.", new Object[]{name.string()});
        }
        declared[p] = true;
        return name;
    }

    protected final void bind(QNm name, Expr[] args, Value value, QueryContext qc, String input) throws QueryException {
        if (value == null) {
            return;
        }
        Var[] params = this.function.params;
        int pl = params.length;
        for (int p = 0; p < pl; ++p) {
            Var var = params[p];
            if (!var.name.eq(name)) continue;
            SeqType st = var.declaredType();
            Value value2 = args[p] = value.seqType().instanceOf(st) ? value : st.cast(value, false, qc, null);
            if (args[p] != null) break;
            throw this.error("% must be of type %, supplied: %.", input, st, value);
        }
    }

    protected static String toString(Item item) {
        return ((Str)item).toJava();
    }

    public String toString() {
        return Token.string((byte[])this.function.name.prefixString());
    }

    public record WebParam(QNm var, String name, Value value) {
    }
}

