/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.websocket.server;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.eclipse.jetty.ee9.nested.ContextHandler;
import org.eclipse.jetty.ee9.nested.HttpChannel;
import org.eclipse.jetty.ee9.servlet.ServletContextHandler;
import org.eclipse.jetty.ee9.websocket.api.Session;
import org.eclipse.jetty.ee9.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.ee9.websocket.api.WebSocketContainer;
import org.eclipse.jetty.ee9.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.ee9.websocket.api.WebSocketSessionListener;
import org.eclipse.jetty.ee9.websocket.common.SessionTracker;
import org.eclipse.jetty.ee9.websocket.server.JettyServerUpgradeRequest;
import org.eclipse.jetty.ee9.websocket.server.JettyServerUpgradeResponse;
import org.eclipse.jetty.ee9.websocket.server.JettyWebSocketCreator;
import org.eclipse.jetty.ee9.websocket.server.internal.DelegatedServerUpgradeRequest;
import org.eclipse.jetty.ee9.websocket.server.internal.DelegatedServerUpgradeResponse;
import org.eclipse.jetty.ee9.websocket.server.internal.JettyServerFrameHandlerFactory;
import org.eclipse.jetty.ee9.websocket.servlet.WebSocketUpgradeFilter;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.websocket.core.Configuration;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.exception.WebSocketException;
import org.eclipse.jetty.websocket.core.server.FrameHandlerFactory;
import org.eclipse.jetty.websocket.core.server.Handshaker;
import org.eclipse.jetty.websocket.core.server.WebSocketCreator;
import org.eclipse.jetty.websocket.core.server.WebSocketMappings;
import org.eclipse.jetty.websocket.core.server.WebSocketNegotiator;
import org.eclipse.jetty.websocket.core.server.WebSocketServerComponents;
import org.eclipse.jetty.websocket.core.util.ReflectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketServerContainer
extends ContainerLifeCycle
implements WebSocketContainer,
WebSocketPolicy,
LifeCycle.Listener {
    public static final String JETTY_WEBSOCKET_CONTAINER_ATTRIBUTE = WebSocketContainer.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(JettyWebSocketServerContainer.class);
    private final ServletContextHandler contextHandler;
    private final WebSocketMappings webSocketMappings;
    private final WebSocketComponents components;
    private final JettyServerFrameHandlerFactory frameHandlerFactory;
    private final Executor executor;
    private final Configuration.ConfigurationCustomizer customizer = new Configuration.ConfigurationCustomizer();
    private final List<WebSocketSessionListener> sessionListeners = new ArrayList<WebSocketSessionListener>();
    private final SessionTracker sessionTracker = new SessionTracker();

    public static JettyWebSocketServerContainer getContainer(ServletContext servletContext) {
        return (JettyWebSocketServerContainer)((Object)servletContext.getAttribute(JETTY_WEBSOCKET_CONTAINER_ATTRIBUTE));
    }

    public static JettyWebSocketServerContainer ensureContainer(ServletContext servletContext) {
        final ServletContextHandler contextHandler = ServletContextHandler.getServletContextHandler((ServletContext)servletContext, (String)"Jakarta Websocket");
        if (contextHandler.getServer() == null) {
            throw new IllegalStateException("Server has not been set on the ServletContextHandler");
        }
        JettyWebSocketServerContainer containerFromServletContext = JettyWebSocketServerContainer.getContainer(servletContext);
        if (containerFromServletContext != null) {
            return containerFromServletContext;
        }
        Executor executor = (Executor)servletContext.getAttribute("org.eclipse.jetty.server.Executor");
        if (executor == null) {
            executor = contextHandler.getServer().getThreadPool();
        }
        WebSocketMappings mappings = WebSocketMappings.ensureMappings((ContextHandler)contextHandler.getCoreContextHandler());
        WebSocketComponents components = WebSocketServerComponents.getWebSocketComponents((ContextHandler)contextHandler.getCoreContextHandler());
        final JettyWebSocketServerContainer container = new JettyWebSocketServerContainer(contextHandler, mappings, components, executor);
        contextHandler.addManaged((LifeCycle)container);
        contextHandler.addEventListener((EventListener)((Object)container));
        contextHandler.addEventListener((EventListener)new LifeCycle.Listener(){

            public void lifeCycleStopping(LifeCycle event) {
                contextHandler.getServletContext().removeAttribute(JETTY_WEBSOCKET_CONTAINER_ATTRIBUTE);
                contextHandler.removeBean((Object)container);
                contextHandler.removeEventListener((EventListener)((Object)container));
                contextHandler.removeEventListener((EventListener)((Object)this));
            }

            public String toString() {
                return String.format("%sCleanupListener", JettyWebSocketServerContainer.class.getSimpleName());
            }
        });
        servletContext.setAttribute(JETTY_WEBSOCKET_CONTAINER_ATTRIBUTE, (Object)container);
        return container;
    }

    JettyWebSocketServerContainer(ServletContextHandler contextHandler, WebSocketMappings webSocketMappings, WebSocketComponents components, Executor executor) {
        this.contextHandler = contextHandler;
        this.webSocketMappings = webSocketMappings;
        this.components = components;
        this.executor = executor;
        this.frameHandlerFactory = new JettyServerFrameHandlerFactory(this, components);
        this.installBean((Object)this.frameHandlerFactory);
        this.addSessionListener((WebSocketSessionListener)this.sessionTracker);
        this.installBean(this.sessionTracker);
    }

    public void addMapping(String pathSpec, JettyWebSocketCreator creator) {
        PathSpec ps = WebSocketMappings.parsePathSpec((String)pathSpec);
        if (this.webSocketMappings.getWebSocketNegotiator(ps) != null) {
            throw new WebSocketException("Duplicate WebSocket Mapping for PathSpec");
        }
        WebSocketUpgradeFilter.ensureFilter((ServletContext)this.contextHandler.getServletContext());
        WebSocketCreator coreCreator = (req, resp, cb) -> {
            try {
                Object webSocket = creator.createWebSocket(new DelegatedServerUpgradeRequest(req), new DelegatedServerUpgradeResponse(resp));
                if (webSocket == null) {
                    cb.succeeded();
                }
                return webSocket;
            }
            catch (Throwable t) {
                if (LOG.isDebugEnabled()) {
                    LOG.atDebug().setCause(t).log("Could not create WebSocket endpoint");
                }
                cb.failed(t);
                return null;
            }
        };
        this.webSocketMappings.addMapping(ps, coreCreator, (FrameHandlerFactory)this.frameHandlerFactory, (Configuration.Customizer)this.customizer);
    }

    public void addMapping(String pathSpec, Class<?> endpointClass) {
        if (!ReflectUtils.isDefaultConstructable(endpointClass)) {
            throw new IllegalArgumentException("Cannot access default constructor for the class: " + endpointClass.getName());
        }
        this.addMapping(pathSpec, (JettyServerUpgradeRequest req, JettyServerUpgradeResponse resp) -> {
            try {
                return endpointClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new org.eclipse.jetty.ee9.websocket.api.exceptions.WebSocketException("Unable to create instance of " + endpointClass.getName(), (Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upgrade(JettyWebSocketCreator creator, HttpServletRequest request, HttpServletResponse response) throws IOException {
        WebSocketCreator coreCreator = (req, resp, cb) -> {
            try {
                Object webSocket = creator.createWebSocket(new DelegatedServerUpgradeRequest(req), new DelegatedServerUpgradeResponse(resp));
                if (webSocket == null) {
                    cb.succeeded();
                }
                return webSocket;
            }
            catch (Throwable t) {
                if (LOG.isDebugEnabled()) {
                    LOG.atDebug().setCause(t).log("Could not create WebSocket endpoint");
                }
                cb.failed(t);
                return null;
            }
        };
        WebSocketNegotiator negotiator = WebSocketNegotiator.from((WebSocketCreator)coreCreator, (FrameHandlerFactory)this.frameHandlerFactory);
        Handshaker handshaker = this.webSocketMappings.getHandshaker();
        HttpChannel httpChannel = (HttpChannel)request.getAttribute(HttpChannel.class.getName());
        ContextHandler.CoreContextRequest baseRequest = httpChannel.getCoreRequest();
        Response baseResponse = httpChannel.getCoreResponse();
        FutureCallback callback = new FutureCallback();
        try {
            baseRequest.setAttribute("org.eclipse.jetty.websocket.wrappedRequest", (Object)request);
            baseRequest.setAttribute("org.eclipse.jetty.websocket.wrappedResponse", (Object)response);
            if (handshaker.upgradeRequest(negotiator, (Request)baseRequest, baseResponse, (Callback)callback, this.components, (Configuration.Customizer)this.customizer)) {
                callback.block();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            baseRequest.removeAttribute("org.eclipse.jetty.websocket.wrappedRequest");
            baseRequest.removeAttribute("org.eclipse.jetty.websocket.wrappedResponse");
        }
        return false;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void addSessionListener(WebSocketSessionListener listener) {
        this.sessionListeners.add(listener);
    }

    public boolean removeSessionListener(WebSocketSessionListener listener) {
        return this.sessionListeners.remove(listener);
    }

    public void notifySessionListeners(Consumer<WebSocketSessionListener> consumer) {
        for (WebSocketSessionListener listener : this.sessionListeners) {
            try {
                consumer.accept(listener);
            }
            catch (Throwable x) {
                LOG.info("Exception while invoking listener {}", (Object)listener, (Object)x);
            }
        }
    }

    public Collection<Session> getOpenSessions() {
        return this.sessionTracker.getSessions();
    }

    public WebSocketBehavior getBehavior() {
        return WebSocketBehavior.SERVER;
    }

    public Duration getIdleTimeout() {
        return this.customizer.getIdleTimeout();
    }

    public int getInputBufferSize() {
        return this.customizer.getInputBufferSize();
    }

    public int getOutputBufferSize() {
        return this.customizer.getOutputBufferSize();
    }

    public long getMaxBinaryMessageSize() {
        return this.customizer.getMaxBinaryMessageSize();
    }

    public long getMaxTextMessageSize() {
        return this.customizer.getMaxTextMessageSize();
    }

    public long getMaxFrameSize() {
        return this.customizer.getMaxFrameSize();
    }

    public boolean isAutoFragment() {
        return this.customizer.isAutoFragment();
    }

    public void setIdleTimeout(Duration duration) {
        this.customizer.setIdleTimeout(duration);
    }

    public void setInputBufferSize(int size) {
        this.customizer.setInputBufferSize(size);
    }

    public void setOutputBufferSize(int size) {
        this.customizer.setOutputBufferSize(size);
    }

    public void setMaxBinaryMessageSize(long size) {
        this.customizer.setMaxBinaryMessageSize(size);
    }

    public void setMaxTextMessageSize(long size) {
        this.customizer.setMaxTextMessageSize(size);
    }

    public void setMaxFrameSize(long maxFrameSize) {
        this.customizer.setMaxFrameSize(maxFrameSize);
    }

    public void setAutoFragment(boolean autoFragment) {
        this.customizer.setAutoFragment(autoFragment);
    }

    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)((Object)this), (Object[])new Object[]{this.customizer});
    }
}

