/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.appbundler;

import com.oracle.appbundler.AppBundlerTask;
import com.oracle.appbundler.Argument;
import com.oracle.appbundler.JMod;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;

public class JLink {
    private String runtime = null;
    private ArrayList<String> jmods = new ArrayList();
    private ArrayList<String> arguments = new ArrayList();
    private ExecTask exec = new ExecTask();

    public JLink() {
        this.exec.init();
    }

    public String getRuntime() {
        return this.runtime;
    }

    public void setRuntime(String runtime) {
        this.runtime = runtime;
    }

    public void setTask(AppBundlerTask task) {
        this.exec.bindToOwner((Task)task);
    }

    public File getDir() {
        File dir = new File(this.runtime);
        try {
            return dir.getCanonicalFile();
        }
        catch (IOException e) {
            return dir;
        }
    }

    public void addConfiguredJMod(JMod jmod) throws BuildException {
        String name = jmod.getName();
        if (name == null) {
            throw new BuildException("Name is required.");
        }
        this.jmods.add(name);
    }

    public void addConfiguredArgument(Argument argument) throws BuildException {
        String value = argument.getValue();
        if (value == null) {
            throw new BuildException("Value is required.");
        }
        this.arguments.add(value);
    }

    public void copyTo(File targetDir) throws IOException {
        File runtimeHomeDirectory = this.getDir();
        File runtimeContentsDirectory = runtimeHomeDirectory.getParentFile();
        File runtimeDirectory = runtimeContentsDirectory.getParentFile();
        File pluginDirectory = new File(targetDir, runtimeDirectory.getName());
        pluginDirectory.mkdir();
        File pluginContentsDirectory = new File(pluginDirectory, runtimeContentsDirectory.getName());
        pluginContentsDirectory.mkdir();
        File runtimeMacOSDirectory = new File(runtimeContentsDirectory, "MacOS");
        AppBundlerTask.copy(runtimeMacOSDirectory, new File(pluginContentsDirectory, runtimeMacOSDirectory.getName()));
        File runtimeInfoPlistFile = new File(runtimeContentsDirectory, "Info.plist");
        AppBundlerTask.copy(runtimeInfoPlistFile, new File(pluginContentsDirectory, runtimeInfoPlistFile.getName()));
        File pluginHomeDirectory = new File(pluginContentsDirectory, runtimeHomeDirectory.getName());
        this.exec.setExecutable(runtimeHomeDirectory.getAbsolutePath() + "/bin/jlink");
        this.exec.setFailIfExecutionFails(true);
        this.exec.setFailonerror(true);
        for (String s : this.arguments) {
            this.exec.createArg().setValue(s);
        }
        this.exec.createArg().setValue("--no-man-pages");
        this.exec.createArg().setValue("--no-header-files");
        this.exec.createArg().setValue("--strip-native-commands");
        this.exec.createArg().setValue("--add-modules");
        this.exec.createArg().setValue(String.join((CharSequence)",", this.jmods));
        this.exec.createArg().setValue("--output");
        this.exec.createArg().setValue(pluginHomeDirectory.getAbsolutePath());
        this.exec.execute();
    }

    public String toString() {
        return this.runtime;
    }
}

