/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.table.value;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.table.ResEntry;
import brut.androlib.res.table.value.ResBag;
import brut.androlib.res.table.value.ResItem;
import brut.androlib.res.table.value.ResReference;
import brut.androlib.res.xml.ResStringEncoder;
import brut.common.Log;
import java.io.IOException;
import java.util.Arrays;
import org.xmlpull.v1.XmlSerializer;

public class ResPlural
extends ResBag {
    private static final String TAG = ResPlural.class.getName();
    private static final int ATTR_OTHER = 0x1000004;
    private static final int ATTR_ZERO = 0x1000005;
    private static final int ATTR_ONE = 0x1000006;
    private static final int ATTR_TWO = 0x1000007;
    private static final int ATTR_FEW = 0x1000008;
    private static final int ATTR_MANY = 0x1000009;
    private final ResBag.RawItem[] mItems;

    public ResPlural(ResReference parent, ResBag.RawItem[] items) {
        super(parent);
        assert (items != null);
        this.mItems = items;
    }

    public static ResPlural parse(ResReference parent, ResBag.RawItem[] rawItems) {
        return new ResPlural(parent, rawItems);
    }

    @Override
    public void serializeToValuesXml(XmlSerializer serial, ResEntry entry) throws AndrolibException, IOException {
        String tagName = "plurals";
        serial.startTag(null, tagName);
        serial.attribute(null, "name", entry.getName());
        block8: for (ResBag.RawItem item : this.mItems) {
            String quantity;
            int key = item.getKey();
            switch (key) {
                case 0x1000004: {
                    quantity = "other";
                    break;
                }
                case 0x1000005: {
                    quantity = "zero";
                    break;
                }
                case 0x1000006: {
                    quantity = "one";
                    break;
                }
                case 0x1000007: {
                    quantity = "two";
                    break;
                }
                case 0x1000008: {
                    quantity = "few";
                    break;
                }
                case 0x1000009: {
                    quantity = "many";
                    break;
                }
                default: {
                    Log.w(TAG, "Invalid plurals key: 0x%08x", key);
                    continue block8;
                }
            }
            ResItem value = item.getValue();
            String body = value.toXmlTextValue();
            if (!body.isEmpty()) {
                body = ResStringEncoder.normalizeFormatSpecifiers(body);
            }
            serial.startTag(null, "item");
            serial.attribute(null, "quantity", quantity);
            serial.text(body);
            serial.endTag(null, "item");
        }
        serial.endTag(null, tagName);
    }

    public String toString() {
        return String.format("ResPlural{items=%s}", Arrays.toString(this.mItems));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResPlural) {
            ResPlural other = (ResPlural)obj;
            return Arrays.equals(this.mItems, other.mItems);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.mItems);
    }
}

