/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.table;

import brut.androlib.res.table.ResConfig;
import brut.androlib.res.table.ResPackage;
import brut.androlib.res.table.ResTypeSpec;
import java.util.Objects;

public class ResType {
    private final ResTypeSpec mSpec;
    private final ResConfig mConfig;

    public ResType(ResTypeSpec spec, ResConfig config) {
        assert (spec != null && config != null);
        this.mSpec = spec;
        this.mConfig = config;
    }

    public ResPackage getPackage() {
        return this.mSpec.getPackage();
    }

    public ResTypeSpec getSpec() {
        return this.mSpec;
    }

    public int getId() {
        return this.mSpec.getId();
    }

    public String getName() {
        return this.mSpec.getName();
    }

    public boolean isBagType() {
        return this.mSpec.isBagType();
    }

    public ResConfig getConfig() {
        return this.mConfig;
    }

    public String toString() {
        return String.format("ResType{spec=%s, config=%s}", this.mSpec, this.mConfig);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResType) {
            ResType other = (ResType)obj;
            return this.mSpec.equals(other.mSpec) && this.mConfig.equals(other.mConfig);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mSpec, this.mConfig);
    }
}

