/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.table;

import brut.androlib.res.table.ResEntrySpec;
import brut.androlib.res.table.ResId;
import brut.androlib.res.table.ResPackage;
import brut.androlib.res.table.ResType;
import brut.androlib.res.table.value.ResValue;
import java.util.Objects;

public class ResEntry {
    private final ResType mType;
    private final ResEntrySpec mSpec;
    private ResValue mValue;

    public ResEntry(ResType type, ResEntrySpec spec, ResValue value) {
        assert (type != null && spec != null && type.getSpec() == spec.getTypeSpec() && value != null);
        this.mType = type;
        this.mSpec = spec;
        this.mValue = value;
    }

    public ResPackage getPackage() {
        return this.mType.getPackage();
    }

    public ResType getType() {
        return this.mType;
    }

    public ResEntrySpec getSpec() {
        return this.mSpec;
    }

    public int getId() {
        return this.mSpec.getId();
    }

    public ResId getResId() {
        return this.mSpec.getResId();
    }

    public String getName() {
        return this.mSpec.getName();
    }

    public ResValue getValue() {
        return this.mValue;
    }

    public void setValue(ResValue value) {
        this.mValue = value;
    }

    public String toString() {
        return String.format("ResEntry{type=%s, spec=%s, value=%s}", this.mType, this.mSpec, this.mValue);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResEntry) {
            ResEntry other = (ResEntry)obj;
            return this.mType.equals(other.mType) && this.mSpec.equals(other.mSpec);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mType, this.mSpec);
    }
}

