/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.res.data.ResChunkHeader;
import brut.util.BinaryDataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;

public class ResChunkPullParser {
    private static final long OFFSET_ENDED = -1L;
    private final BinaryDataInputStream mIn;
    private final long mOffset;
    private final int mSize;
    private long mChunkOffset;
    private ResChunkHeader mChunkHeader;

    public ResChunkPullParser(BinaryDataInputStream in) {
        this(in, Integer.MAX_VALUE);
    }

    public ResChunkPullParser(BinaryDataInputStream in, int size) {
        assert (in.order() == ByteOrder.LITTLE_ENDIAN);
        this.mIn = in;
        this.mOffset = in.position();
        this.mSize = size;
    }

    public BinaryDataInputStream stream() {
        return this.mIn;
    }

    public boolean isChunk() {
        return this.mChunkHeader != null;
    }

    public long chunkStart() {
        if (this.mChunkHeader == null) {
            throw new IllegalStateException();
        }
        return this.mChunkOffset;
    }

    public int chunkType() {
        if (this.mChunkHeader == null) {
            throw new IllegalStateException();
        }
        return this.mChunkHeader.type;
    }

    public String chunkName() {
        if (this.mChunkHeader == null) {
            throw new IllegalStateException();
        }
        return ResChunkHeader.nameOf(this.mChunkHeader.type);
    }

    public int chunkSize() {
        if (this.mChunkHeader == null) {
            throw new IllegalStateException();
        }
        return this.mChunkHeader.size;
    }

    public long chunkEnd() {
        if (this.mChunkHeader == null) {
            throw new IllegalStateException();
        }
        return this.mChunkOffset + (long)this.mChunkHeader.size;
    }

    public int headerSize() {
        if (this.mChunkHeader == null) {
            throw new IllegalStateException();
        }
        return this.mChunkHeader.headerSize;
    }

    public long headerEnd() {
        if (this.mChunkHeader == null) {
            throw new IllegalStateException();
        }
        return this.mChunkOffset + (long)this.mChunkHeader.headerSize;
    }

    public int dataSize() {
        if (this.mChunkHeader == null) {
            throw new IllegalStateException();
        }
        return this.mChunkHeader.size - this.mChunkHeader.headerSize;
    }

    public boolean next() throws IOException {
        if (this.mChunkOffset == -1L) {
            return false;
        }
        if (this.mChunkHeader != null) {
            this.skipChunk();
            this.mChunkHeader = null;
        }
        if (this.mIn.position() >= this.mOffset + (long)this.mSize) {
            this.mChunkOffset = -1L;
            return false;
        }
        try {
            this.mChunkOffset = this.mIn.position();
            ResChunkHeader chunkHeader = ResChunkHeader.read(this.mIn);
            if (chunkHeader.headerSize < 8 || chunkHeader.size < chunkHeader.headerSize) {
                throw new IOException(String.format("Invalid chunk header: type=0x%04x, headerSize=%s, size=%s", chunkHeader.type, chunkHeader.headerSize, chunkHeader.size));
            }
            this.mChunkHeader = chunkHeader;
            return true;
        }
        catch (EOFException ignored) {
            this.mChunkOffset = -1L;
            return false;
        }
        catch (IOException ex) {
            throw new IOException("Error while reading chunk header.", ex);
        }
    }

    public int skipChunk() throws IOException {
        if (this.mChunkHeader == null) {
            throw new IllegalStateException();
        }
        try {
            long position = this.mIn.position();
            long chunkEnd = this.chunkEnd();
            if (position == chunkEnd) {
                return 0;
            }
            if (position > chunkEnd) {
                throw new IOException("Stream advanced past chunk end.");
            }
            return this.mIn.skipBytes((int)(chunkEnd - position));
        }
        catch (EOFException ignored) {
            throw new EOFException("Unexpected EOF while skipping chunk.");
        }
        catch (IOException ex) {
            throw new IOException("Error while skipping chunk.", ex);
        }
    }

    public int skipHeader() throws IOException {
        if (this.mChunkHeader == null) {
            throw new IllegalStateException();
        }
        try {
            long position = this.mIn.position();
            long headerEnd = this.headerEnd();
            if (position == headerEnd) {
                return 0;
            }
            if (position > headerEnd) {
                throw new IOException("Stream advanced past chunk header end.");
            }
            return this.mIn.skipBytes((int)(headerEnd - position));
        }
        catch (EOFException ignored) {
            throw new EOFException("Unexpected EOF while skipping chunk header.");
        }
        catch (IOException ex) {
            throw new IOException("Error while skipping chunk header.", ex);
        }
    }
}

