/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.smali;

import brut.androlib.exceptions.AndrolibException;
import brut.util.OS;
import com.android.tools.smali.baksmali.Baksmali;
import com.android.tools.smali.baksmali.BaksmaliOptions;
import com.android.tools.smali.dexlib2.analysis.InlineMethodResolver;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedOdexFile;
import com.android.tools.smali.dexlib2.dexbacked.ZipDexContainer;
import com.android.tools.smali.dexlib2.iface.MultiDexContainer;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class SmaliDecoder {
    private final ZipDexContainer mDexContainer;
    private final boolean mDebugMode;
    private final Set<String> mDexFiles;
    private final AtomicInteger mInferredApiLevel;

    public SmaliDecoder(File apkFile, boolean debugMode) throws AndrolibException {
        this.mDexContainer = new ZipDexContainer(apkFile, null);
        try {
            this.mDexContainer.getEntry("");
        }
        catch (IOException ex) {
            throw new AndrolibException("Could not open apk file: " + apkFile, ex);
        }
        this.mDebugMode = debugMode;
        this.mDexFiles = ConcurrentHashMap.newKeySet();
        this.mInferredApiLevel = new AtomicInteger();
    }

    public Set<String> getDexFiles() {
        return this.mDexFiles;
    }

    public int getInferredApiLevel() {
        return this.mInferredApiLevel.get();
    }

    public void decode(String dexName, File outDir) throws AndrolibException {
        try {
            MultiDexContainer.DexEntry<DexBackedDexFile> dexEntry = this.mDexContainer.getEntry(dexName);
            if (dexEntry == null) {
                throw new AndrolibException("Could not find file: " + dexName);
            }
            TreeMap<Integer, DexBackedDexFile> dexFiles = new TreeMap<Integer, DexBackedDexFile>();
            dexFiles.put(1, dexEntry.getDexFile());
            for (String string : this.mDexContainer.getDexEntryNames()) {
                int dexNum;
                String prefix;
                if (string.equals(dexName) || !string.startsWith(prefix = dexName + "/")) continue;
                try {
                    dexNum = Integer.parseInt(string.substring(prefix.length()));
                }
                catch (NumberFormatException ignored) {
                    continue;
                }
                if (dexNum <= 1) continue;
                dexFiles.put(dexNum, this.mDexContainer.getEntry(string).getDexFile());
            }
            for (Map.Entry entry : dexFiles.entrySet()) {
                int dexNum = (Integer)entry.getKey();
                DexBackedDexFile dexFile = (DexBackedDexFile)entry.getValue();
                if (dexFile.supportsOptimizedOpcodes()) {
                    throw new AndrolibException("Cannot disassemble an odex file without deodexing it: " + dexName);
                }
                String dirName = "smali";
                if (dexNum > 1 || !dexName.equals("classes.dex")) {
                    dirName = dirName + "_" + dexName.substring(0, dexName.lastIndexOf(46)).replace('/', '@');
                    if (dexNum > 1) {
                        dirName = dirName + dexNum;
                    }
                }
                this.decodeFile(dexFile, new File(outDir, dirName));
            }
            this.mDexFiles.add(dexName);
        }
        catch (IOException ex) {
            throw new AndrolibException("Could not baksmali file: " + dexName, ex);
        }
    }

    private void decodeFile(DexBackedDexFile dexFile, File smaliDir) {
        int jobs = Math.min(Runtime.getRuntime().availableProcessors(), 6);
        BaksmaliOptions options = new BaksmaliOptions();
        options.parameterRegisters = true;
        options.localsDirective = true;
        options.sequentialLabels = true;
        options.debugInfo = this.mDebugMode;
        options.codeOffsets = false;
        options.accessorComments = false;
        options.allowOdex = false;
        options.deodex = false;
        options.implicitReferences = false;
        options.normalizeVirtualMethods = false;
        options.registerInfo = 0;
        if (dexFile instanceof DexBackedOdexFile) {
            options.inlineResolver = InlineMethodResolver.createInlineMethodResolver(((DexBackedOdexFile)dexFile).getOdexVersion());
        }
        OS.mkdir(smaliDir);
        Baksmali.disassembleDexFile(dexFile, smaliDir, jobs, options);
        int apiLevel = dexFile.getOpcodes().api;
        this.mInferredApiLevel.updateAndGet(cur -> cur == 0 || cur > apiLevel ? apiLevel : cur);
    }
}

