/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.table.value;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.table.ResEntry;
import brut.androlib.res.table.value.ResValue;
import brut.androlib.res.xml.ValuesXmlSerializable;
import java.io.IOException;
import java.util.Objects;
import org.xmlpull.v1.XmlSerializer;

public class ResCustom
extends ResValue
implements ValuesXmlSerializable {
    public static final ResCustom ID = new ResCustom("id");
    private final String mType;
    private final Object mValue;
    private final boolean mAsItem;

    public ResCustom(String type) {
        this(type, null, false);
    }

    public ResCustom(String type, boolean asItem) {
        this(type, null, asItem);
    }

    public ResCustom(String type, Object value) {
        this(type, value, false);
    }

    public ResCustom(String type, Object value, boolean asItem) {
        assert (type != null);
        this.mType = type;
        this.mValue = value;
        this.mAsItem = asItem;
    }

    @Override
    public void serializeToValuesXml(XmlSerializer serial, ResEntry entry) throws AndrolibException, IOException {
        String tagName = this.mAsItem ? "item" : this.mType;
        serial.startTag(null, tagName);
        if (this.mAsItem) {
            serial.attribute(null, "type", this.mType);
        }
        serial.attribute(null, "name", entry.getName());
        if (this.mValue != null) {
            serial.text(this.mValue.toString());
        }
        serial.endTag(null, tagName);
    }

    public String toString() {
        return String.format("ResCustom{type=%s, value=%s, asItem=%s}", this.mType, this.mValue, this.mAsItem);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResCustom) {
            ResCustom other = (ResCustom)obj;
            return this.mType.equals(other.mType) && Objects.equals(this.mValue, other.mValue) && this.mAsItem == other.mAsItem;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mType, this.mValue, this.mAsItem);
    }
}

