/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res;

import brut.androlib.Config;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.meta.ApkInfo;
import brut.androlib.meta.ResourcesInfo;
import brut.androlib.meta.SdkInfo;
import brut.androlib.meta.UsesFramework;
import brut.androlib.meta.VersionInfo;
import brut.androlib.res.AaptManager;
import brut.androlib.res.Framework;
import brut.common.BrutException;
import brut.common.Log;
import brut.util.OS;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AaptInvoker {
    private static final String TAG = AaptInvoker.class.getName();
    private final ApkInfo mApkInfo;
    private final Config mConfig;

    public AaptInvoker(ApkInfo apkInfo, Config config) {
        this.mApkInfo = apkInfo;
        this.mConfig = config;
    }

    public void invoke(File outApk, File manifest, File resDir) throws AndrolibException {
        SdkInfo sdkInfo = this.mApkInfo.getSdkInfo();
        VersionInfo versionInfo = this.mApkInfo.getVersionInfo();
        ResourcesInfo resourcesInfo = this.mApkInfo.getResourcesInfo();
        String aaptPath = this.mConfig.getAaptBinary();
        if (aaptPath == null || aaptPath.isEmpty()) {
            try {
                aaptPath = AaptManager.getBinaryFile().getPath();
            }
            catch (AndrolibException ex) {
                aaptPath = AaptManager.getBinaryName();
                Log.w(TAG, aaptPath + ": " + ex.getMessage() + " (defaulting to $PATH binary)");
            }
        }
        ArrayList<String> cmd = new ArrayList<String>();
        File resZip = null;
        if (resDir != null) {
            resZip = new File(resDir.getParent(), "build/resources.zip");
            OS.rmfile(resZip);
            cmd.add(aaptPath);
            cmd.add("compile");
            cmd.add("--dir");
            cmd.add(resDir.getPath());
            cmd.add("--legacy");
            cmd.add("-o");
            cmd.add(resZip.getPath());
            if (this.mConfig.isVerbose()) {
                cmd.add("-v");
            }
            if (this.mConfig.isNoCrunch()) {
                cmd.add("--no-crunch");
            }
            try {
                OS.exec(cmd.toArray(new String[0]));
                Log.d(TAG, "aapt2 compile command ran: " + ((Object)cmd).toString());
            }
            catch (BrutException ex) {
                throw new AndrolibException(ex);
            }
            cmd.clear();
        }
        if (manifest == null) {
            return;
        }
        cmd.add(aaptPath);
        cmd.add("link");
        cmd.add("-o");
        cmd.add(outApk.getPath());
        cmd.add("--manifest");
        cmd.add(manifest.getPath());
        if (sdkInfo.getMinSdkVersion() != null) {
            cmd.add("--min-sdk-version");
            cmd.add(sdkInfo.getMinSdkVersion());
        }
        if (sdkInfo.getTargetSdkVersion() != null) {
            cmd.add("--target-sdk-version");
            cmd.add(sdkInfo.getTargetSdkVersion());
        }
        if (versionInfo.getVersionCode() >= 0) {
            cmd.add("--version-code");
            cmd.add(Integer.toString(versionInfo.getVersionCode()));
        }
        if (versionInfo.getVersionName() != null) {
            cmd.add("--version-name");
            cmd.add(versionInfo.getVersionName());
        }
        if (resourcesInfo.getPackageId() >= 0) {
            int pkgId = resourcesInfo.getPackageId();
            if (pkgId == 0) {
                cmd.add("--shared-lib");
            } else if (pkgId > 1) {
                cmd.add("--package-id");
                cmd.add(Integer.toString(pkgId));
                if (pkgId < 127) {
                    cmd.add("--allow-reserved-package-id");
                }
            }
        }
        if (resourcesInfo.getPackageName() != null) {
            cmd.add("--rename-resources-package");
            cmd.add(resourcesInfo.getPackageName());
        }
        if (resourcesInfo.isSparseEntries()) {
            cmd.add("--enable-sparse-encoding");
        }
        if (resourcesInfo.isCompactEntries()) {
            cmd.add("--enable-compact-entries");
        }
        if (resourcesInfo.isKeepRawValues()) {
            cmd.add("--keep-raw-values");
        }
        if (!this.mApkInfo.getFeatureFlags().isEmpty()) {
            ArrayList<String> featureFlags = new ArrayList<String>();
            for (Map.Entry<String, Boolean> entry : this.mApkInfo.getFeatureFlags().entrySet()) {
                featureFlags.add(entry.getKey() + "=" + entry.getValue());
            }
            cmd.add("--feature-flags");
            cmd.add(String.join((CharSequence)",", featureFlags));
        }
        cmd.add("--no-auto-version");
        cmd.add("--no-version-vectors");
        cmd.add("--no-version-transitions");
        cmd.add("--no-resource-deduping");
        cmd.add("--no-compile-sdk-metadata");
        cmd.add("--warn-manifest-validation");
        for (File includeFile : this.getIncludeFiles()) {
            cmd.add("-I");
            cmd.add(includeFile.getPath());
        }
        if (this.mConfig.isVerbose()) {
            cmd.add("-v");
        }
        if (resZip != null) {
            cmd.add(resZip.getPath());
        }
        try {
            OS.exec(cmd.toArray(new String[0]));
            Log.d(TAG, "aapt2 link command ran: " + ((Object)cmd).toString());
        }
        catch (BrutException ex) {
            throw new AndrolibException(ex);
        }
    }

    private List<File> getIncludeFiles() throws AndrolibException {
        List<String> usesLibrary;
        ArrayList<File> files = new ArrayList<File>();
        UsesFramework usesFramework = this.mApkInfo.getUsesFramework();
        List<Integer> frameworkIds = usesFramework.getIds();
        if (!frameworkIds.isEmpty()) {
            Framework framework = new Framework(this.mConfig);
            String tag = usesFramework.getTag();
            for (Integer id : frameworkIds) {
                files.add(framework.getApkFile(id, tag));
            }
        }
        if (!(usesLibrary = this.mApkInfo.getUsesLibrary()).isEmpty()) {
            String[] libFiles = this.mConfig.getLibraryFiles();
            for (String name : usesLibrary) {
                File libFile = null;
                if (libFiles != null) {
                    for (String libEntry : libFiles) {
                        String[] parts = libEntry.split(":", 2);
                        if (parts.length != 2 || !name.equals(parts[0])) continue;
                        libFile = new File(parts[1]);
                        break;
                    }
                }
                if (libFile != null) {
                    files.add(libFile);
                    continue;
                }
                Log.w(TAG, "Shared library was not provided: " + name);
            }
        }
        return files;
    }
}

