/*
 * Decompiled with CFR 0.152.
 */
package brut.util;

public final class TextUtils {
    private static final int SINGLE_PRECISION_BIAS = 127;
    private static final int SINGLE_PRECISION_EXP_MIN = -126;
    private static final int SINGLE_PRECISION_EXP_MAX = 127;
    private static final int FLOAT_NEGATIVE_MASK = Integer.MIN_VALUE;
    private static final int MANTISSA_EXPONENT_ADJUST_VALUE = 0xFFFFFF;
    private static final int DENORMAL_EXPONENT_ADJUST_VALUE = 0xFFFFFE;
    private static final long SCALAR_SHIFT_1 = 0x1000000000000000L;
    private static final long SCALAR_SHIFT_2 = 0x2000000000000000L;
    private static final long SCALAR_SHIFT_3 = 0x4000000000000000L;
    private static final long SCALAR_SHIFT_4 = Long.MIN_VALUE;
    private static final long DEC_SIGNIFICAND_LEADING_BIT = 0x800000000000000L;
    private static final int DEC_SIGNIFICAND_DOWN_SHIFT = 36;
    private static final long ROUND_VALUE = 0x800000000L;
    private static final long[] POSITIVE_SIGNIFICANDS = new long[]{0x800000000000000L, 0xA00000000000000L, 0xC80000000000000L, 0xFA0000000000000L, 703687441776640000L, 879609302220800000L, 1099511627776000000L, 687194767360000000L, 858993459200000000L, 1073741824000000000L, 671088640000000000L, 838860800000000000L, 1048576000000000000L, 655360000000000000L, 819200000000000000L, 1024000000000000000L, 640000000000000000L, 800000000000000000L, 1000000000000000000L, 625000000000000000L, 781250000000000000L, 976562500000000000L, 610351562500000000L, 762939453125000000L, 953674316406250000L, 596046447753906250L, 745058059692382812L, 931322574615478515L, 582076609134674072L, 727595761418342590L, 909494701772928237L, 1136868377216160297L, 710542735760100185L, 888178419700125232L, 1110223024625156540L, 693889390390722837L, 867361737988403547L, 1084202172485504434L, 677626357803440271L};
    private static final int[] POSITIVE_SHIFTS = new int[]{0, 3, 6, 9, 13, 16, 19, 23, 26, 29, 33, 36, 39, 43, 46, 49, 53, 56, 59, 63, 66, 69, 73, 76, 79, 83, 86, 89, 93, 96, 99, 102, 106, 109, 112, 116, 119, 122, 126};
    private static final long[] NEGATIVE_SIGNIFICANDS = new long[]{0xCCCCCCCCCCCCCCCL, 737869762948382064L, 590295810358705651L, 944473296573929042L, 755578637259143234L, 604462909807314587L, 967140655691703339L, 773712524553362671L, 618970019642690137L, 990352031428304219L, 792281625142643375L, 633825300114114700L, 1014120480182583521L, 811296384146066816L, 649037107316853453L, 1038459371706965525L, 830767497365572420L, 664613997892457936L, 1063382396627932698L, 850705917302346158L, 680564733841876926L, 1088903574147003083L, 871122859317602466L, 696898287454081973L, 1115037259926531157L, 892029807941224925L, 713623846352979940L, 1141798154164767904L, 913438523331814323L, 730750818665451459L, 584600654932361167L, 935361047891777867L, 748288838313422294L, 598631070650737835L, 957809713041180536L, 766247770432944429L, 612998216346355543L, 980797146154168869L, 784637716923335095L, 627710173538668076L, 1004336277661868922L, 803469022129495137L, 642775217703596110L, 1028440348325753776L, 822752278660603021L, 658201822928482416L, 1053122916685571866L};
    private static final int[] NEGATIVE_SHIFTS = new int[]{-4, -7, -10, -14, -17, -20, -24, -27, -30, -34, -37, -40, -44, -47, -50, -54, -57, -60, -64, -67, -70, -74, -77, -80, -84, -87, -90, -94, -97, -100, -103, -107, -110, -113, -117, -120, -123, -127, -130, -133, -137, -140, -143, -147, -150, -153, -157};

    private TextUtils() {
    }

    public static String matchSuffix(CharSequence text, String ... suffixes) {
        int len = text.length();
        if (len == 0 || suffixes.length == 0) {
            return null;
        }
        for (String suffix : suffixes) {
            int suffixLen = suffix.length();
            if (suffixLen == 0 || suffixLen > len) continue;
            boolean matched = true;
            for (int i = 0; i < suffixLen; ++i) {
                if (text.charAt(len - suffixLen + i) == suffix.charAt(i)) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return suffix;
        }
        return null;
    }

    public static boolean isPrintableChar(char ch) {
        return ch >= ' ' && ch <= '~' || ch >= '\u00a0' && ch <= '\ud7ff' || ch >= '\ue000' && ch <= '\ufdcf' || ch >= '\ufdf0' && ch <= '\ufffd';
    }

    public static int parseHex(int codePoint) {
        if (codePoint >= 48 && codePoint <= 57) {
            return codePoint - 48;
        }
        if (codePoint >= 65 && codePoint <= 70) {
            return codePoint - 65 + 10;
        }
        if (codePoint >= 97 && codePoint <= 102) {
            return codePoint - 97 + 10;
        }
        return -1;
    }

    public static int parseColor(CharSequence text) throws NumberFormatException {
        return TextUtils.parseColor(text, 0, text.length());
    }

    public static int parseColor(CharSequence text, int start, int end) throws NumberFormatException {
        if (start > end || end > text.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (start == end) {
            throw new NumberFormatException();
        }
        int i = start;
        if (text.charAt(i) != '#' || ++i == end) {
            throw new NumberFormatException();
        }
        int value = 0;
        switch (end - start) {
            case 4: {
                while (i < end) {
                    int hex = TextUtils.parseHex(text.charAt(i));
                    if (hex == -1) {
                        throw new NumberFormatException();
                    }
                    value = value << 8 | (hex | hex << 4);
                    ++i;
                }
                value |= 0xFF000000;
                break;
            }
            case 5: {
                while (i < end) {
                    int hex = TextUtils.parseHex(text.charAt(i));
                    if (hex == -1) {
                        throw new NumberFormatException();
                    }
                    value = value << 8 | (hex | hex << 4);
                    ++i;
                }
                break;
            }
            case 7: {
                while (i < end) {
                    int hex = TextUtils.parseHex(text.charAt(i));
                    if (hex == -1) {
                        throw new NumberFormatException();
                    }
                    value = value << 4 | hex;
                    ++i;
                }
                value |= 0xFF000000;
                break;
            }
            case 9: {
                while (i < end) {
                    int hex = TextUtils.parseHex(text.charAt(i));
                    if (hex == -1) {
                        throw new NumberFormatException();
                    }
                    value = value << 4 | hex;
                    ++i;
                }
                break;
            }
            default: {
                throw new NumberFormatException();
            }
        }
        return value;
    }

    public static int parseInt(CharSequence text) throws NumberFormatException {
        return TextUtils.parseInt(text, 0, text.length());
    }

    public static int parseInt(CharSequence text, int start, int end) throws NumberFormatException {
        boolean negative;
        if (start > end || end > text.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (start == end) {
            throw new NumberFormatException();
        }
        int i = start;
        boolean bl = negative = text.charAt(i) == '-';
        if ((negative || text.charAt(i) == '+') && ++i == end) {
            throw new NumberFormatException();
        }
        if (i + 1 < end && text.charAt(i) == '0' && (text.charAt(i + 1) == 'x' || text.charAt(i + 1) == 'X')) {
            if (negative || (i += 2) == end) {
                throw new NumberFormatException();
            }
            return TextUtils.parseIntHex(text, i, end);
        }
        return TextUtils.parseIntDec(text, i, end, negative);
    }

    private static int parseIntDec(CharSequence text, int start, int end, boolean negative) throws NumberFormatException {
        long value = 0L;
        for (int i = start; i < end; ++i) {
            char ch = text.charAt(i);
            if (ch < '0' || ch > '9') {
                throw new NumberFormatException();
            }
            value = value * 10L + (long)(ch - 48);
            if (!(negative ? -value < Integer.MIN_VALUE : value > Integer.MAX_VALUE)) continue;
            throw new NumberFormatException();
        }
        return (int)(negative ? -value : value);
    }

    private static int parseIntHex(CharSequence text, int start, int end) throws NumberFormatException {
        long value = 0L;
        for (int i = start; i < end; ++i) {
            int hex = TextUtils.parseHex(text.charAt(i));
            if (hex == -1) {
                throw new NumberFormatException();
            }
            if ((value = (value << 4) + (long)hex) <= 0xFFFFFFFFL) continue;
            throw new NumberFormatException();
        }
        return (int)value;
    }

    public static float parseFloat(CharSequence text) throws NumberFormatException {
        return TextUtils.parseFloat(text, 0, text.length());
    }

    public static float parseFloat(CharSequence text, int start, int end) throws NumberFormatException {
        boolean negative;
        if (start > end || end > text.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (start == end) {
            throw new NumberFormatException();
        }
        int i = 0;
        boolean bl = negative = text.charAt(i) == '-';
        if ((negative || text.charAt(i) == '+') && ++i == end) {
            throw new NumberFormatException();
        }
        if (i + 1 < end && text.charAt(i) == '0' && (text.charAt(i + 1) == 'x' || text.charAt(i + 1) == 'X')) {
            if ((i += 2) == end) {
                throw new NumberFormatException();
            }
            return TextUtils.parseFloatHex(text, i, end, negative);
        }
        return TextUtils.parseFloatDec(text, i, end, negative);
    }

    private static float parseFloatDec(CharSequence text, int start, int end, boolean negative) throws NumberFormatException {
        int i;
        int significandBegin = i = start;
        boolean significandStart = false;
        boolean validSignificand = false;
        boolean subInteger = false;
        int mostSignificantExponent = 0;
        while (i < end && text.charAt(i) != 'e' && text.charAt(i) != 'E') {
            if (text.charAt(i) == '.') {
                if (subInteger) {
                    throw new NumberFormatException();
                }
                subInteger = true;
                ++i;
                continue;
            }
            if (significandStart && !subInteger) {
                ++mostSignificantExponent;
            } else if (!significandStart && subInteger) {
                --mostSignificantExponent;
            }
            if (text.charAt(i) < '0' || text.charAt(i) > '9') {
                throw new NumberFormatException();
            }
            validSignificand = true;
            if (text.charAt(i) != '0' && !significandStart) {
                significandStart = true;
                significandBegin = i;
            }
            ++i;
        }
        if (!validSignificand) {
            throw new NumberFormatException();
        }
        int significandEnd = i;
        int declaredExponent = 0;
        if (i < end) {
            boolean negativeExponent;
            if (i == end - 1) {
                throw new NumberFormatException();
            }
            boolean bl = negativeExponent = text.charAt(++i) == '-';
            if (negativeExponent || text.charAt(i) == '+') {
                ++i;
            }
            while (i < end) {
                if (text.charAt(i) < '0' || text.charAt(i) > '9') {
                    throw new NumberFormatException();
                }
                int currentValue = text.charAt(i) - 48;
                declaredExponent = declaredExponent * 10 + currentValue;
                ++i;
            }
            if (negativeExponent) {
                declaredExponent = -declaredExponent;
            }
        }
        if (!significandStart) {
            return negative ? -0.0f : 0.0f;
        }
        i = significandBegin;
        long significandValue = TextUtils.getValueByExponent(mostSignificantExponent += declaredExponent);
        if (significandValue == 0L) {
            throw new NumberFormatException();
        }
        int baseBinaryShift = TextUtils.getShiftByExponent(mostSignificantExponent);
        int significandScalarShift = TextUtils.getScalarShiftByValue(significandValue *= (long)(text.charAt(i) - 48));
        significandValue >>>= significandScalarShift;
        baseBinaryShift += significandScalarShift;
        int currentExponent = mostSignificantExponent - 1;
        ++i;
        while (i < significandEnd) {
            if (text.charAt(i) < '1' || text.charAt(i) > '9') {
                if (text.charAt(i) == '0') {
                    --currentExponent;
                }
                ++i;
                continue;
            }
            long scalarValue = text.charAt(i) - 48;
            long currentValue = TextUtils.getValueByExponent(currentExponent) * scalarValue;
            int relativeDownShift = baseBinaryShift - TextUtils.getShiftByExponent(currentExponent);
            int scalarShift = TextUtils.getScalarShiftByValue(currentValue);
            currentValue >>>= scalarShift;
            if ((relativeDownShift -= scalarShift) > 59) break;
            if (((significandValue += currentValue >>> relativeDownShift) & 0x1000000000000000L) != 0L) {
                significandValue >>>= 1;
                ++baseBinaryShift;
            }
            --currentExponent;
            ++i;
        }
        if (((significandValue += 0x800000000L) & 0x1000000000000000L) != 0L) {
            significandValue >>>= 1;
            ++baseBinaryShift;
        }
        if (baseBinaryShift < -126 || baseBinaryShift > 127) {
            throw new NumberFormatException();
        }
        int mantissa = (int)((significandValue & 0xF7FFFFFFFFFFFFFFL) >>> 36);
        int biasedExp = baseBinaryShift + 127;
        return Float.intBitsToFloat((negative ? Integer.MIN_VALUE : 0) | mantissa | biasedExp << 23);
    }

    private static float parseFloatHex(CharSequence text, int start, int end, boolean negative) throws NumberFormatException {
        int exponent;
        int i = start;
        int currentMantissa = 0;
        int currentSkew = 0;
        int mantissaBits = 0;
        boolean mantissaStart = false;
        boolean subInteger = false;
        boolean validMantissa = false;
        while (i < end && text.charAt(i) != 'p') {
            int indexValue = TextUtils.parseHex(text.charAt(i));
            if (indexValue == -1) {
                if (text.charAt(i) != '.' || subInteger) {
                    throw new NumberFormatException();
                }
                subInteger = true;
                ++i;
                continue;
            }
            validMantissa = true;
            if (!mantissaStart && indexValue != 0) {
                mantissaStart = true;
                currentMantissa = indexValue;
                if (indexValue >= 8) {
                    --currentSkew;
                    mantissaBits = 3;
                } else if (indexValue >= 4) {
                    currentSkew -= 2;
                    mantissaBits = 2;
                } else if (indexValue >= 2) {
                    currentSkew -= 3;
                    mantissaBits = 1;
                } else {
                    currentSkew -= 4;
                    mantissaBits = 0;
                }
            } else if (mantissaStart && mantissaBits < 24) {
                currentMantissa = (currentMantissa << 4) + indexValue;
                mantissaBits += 4;
            }
            if (mantissaStart && !subInteger) {
                currentSkew += 4;
            } else if (!mantissaStart && subInteger) {
                currentSkew -= 4;
            }
            ++i;
        }
        if (!validMantissa) {
            throw new NumberFormatException();
        }
        int declaredExponent = 0;
        if (i < end) {
            boolean negativeExponent;
            if (i == end - 1) {
                throw new NumberFormatException();
            }
            boolean bl = negativeExponent = text.charAt(++i) == '-';
            if (negativeExponent || text.charAt(i) == '+') {
                ++i;
            }
            while (i < end) {
                if (text.charAt(i) < '0' || text.charAt(i) > '9') {
                    throw new NumberFormatException();
                }
                int currentValue = text.charAt(i) - 48;
                declaredExponent = declaredExponent * 10 + currentValue;
                ++i;
            }
            if (negativeExponent) {
                declaredExponent = -declaredExponent;
            }
        }
        currentMantissa = 24 - mantissaBits < 0 ? (currentMantissa >>>= mantissaBits - 24) : (currentMantissa <<= 24 - mantissaBits);
        if ((currentMantissa &= 0xFFFFFF) == 0xFFFFFF || currentMantissa == 0xFFFFFE && declaredExponent + currentSkew + 1 == -126) {
            currentMantissa = 0;
            exponent = declaredExponent + currentSkew + 1;
        } else {
            currentMantissa = currentMantissa + 1 >>> 1;
            exponent = declaredExponent + currentSkew;
        }
        if (!mantissaStart) {
            return negative ? -0.0f : 0.0f;
        }
        if (exponent < -126 || exponent > 127) {
            throw new NumberFormatException();
        }
        int biasedExp = exponent + 127;
        return Float.intBitsToFloat((negative ? Integer.MIN_VALUE : 0) | currentMantissa | biasedExp << 23);
    }

    private static long getValueByExponent(int exponent) {
        if (exponent < POSITIVE_SIGNIFICANDS.length) {
            if (exponent >= 0) {
                return POSITIVE_SIGNIFICANDS[exponent];
            }
            if (exponent >= -NEGATIVE_SIGNIFICANDS.length) {
                return NEGATIVE_SIGNIFICANDS[-exponent - 1];
            }
        }
        return 0L;
    }

    private static int getShiftByExponent(int exponent) {
        if (exponent < POSITIVE_SIGNIFICANDS.length) {
            if (exponent >= 0) {
                return POSITIVE_SHIFTS[exponent];
            }
            if (exponent >= -NEGATIVE_SIGNIFICANDS.length) {
                return NEGATIVE_SHIFTS[-exponent - 1];
            }
        }
        return 0;
    }

    private static int getScalarShiftByValue(long valueToNormalize) {
        if ((valueToNormalize & Long.MIN_VALUE) != 0L) {
            return 4;
        }
        if ((valueToNormalize & 0x4000000000000000L) != 0L) {
            return 3;
        }
        if ((valueToNormalize & 0x2000000000000000L) != 0L) {
            return 2;
        }
        if ((valueToNormalize & 0x1000000000000000L) != 0L) {
            return 1;
        }
        return 0;
    }
}

