/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.table.value;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.table.ResEntry;
import brut.androlib.res.table.value.ResItem;
import brut.common.Log;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.xmlpull.v1.XmlSerializer;

public class ResPrimitive
extends ResItem {
    private static final String TAG = ResPrimitive.class.getName();
    private static final int COMPLEX_UNIT_MASK = 15;
    private static final int COMPLEX_RADIX_SHIFT = 4;
    private static final int COMPLEX_RADIX_MASK = 3;
    private static final int COMPLEX_MANTISSA_SHIFT = 8;
    private static final int COMPLEX_MANTISSA_MASK = 0xFFFFFF;
    private static final float MANTISSA_MULT = 0.00390625f;
    private static final float[] RADIX_MULTS = new float[]{0.00390625f, 3.0517578E-5f, 1.1920929E-7f, 4.656613E-10f};
    private static final int COMPLEX_UNIT_PX = 0;
    private static final int COMPLEX_UNIT_DIP = 1;
    private static final int COMPLEX_UNIT_SP = 2;
    private static final int COMPLEX_UNIT_PT = 3;
    private static final int COMPLEX_UNIT_IN = 4;
    private static final int COMPLEX_UNIT_MM = 5;
    private static final int COMPLEX_UNIT_FRACTION = 0;
    private static final int COMPLEX_UNIT_FRACTION_PARENT = 1;
    public static final ResPrimitive NULL = new ResPrimitive(0, 0);
    public static final ResPrimitive EMPTY = new ResPrimitive(0, 1);
    public static final ResPrimitive FALSE = new ResPrimitive(18, 0);
    public static final ResPrimitive TRUE = new ResPrimitive(18, -1);
    private final int mData;

    public ResPrimitive(int type, int data) {
        super(type);
        this.mData = data;
    }

    public int getData() {
        return this.mData;
    }

    @Override
    public String toXmlTextValue() {
        switch (this.mType) {
            case 0: {
                return this.mData == 1 ? "@empty" : "@null";
            }
            case 4: {
                return ResPrimitive.floatToString(Float.intBitsToFloat(this.mData));
            }
            case 5: {
                String value = ResPrimitive.floatToString(ResPrimitive.complexToFloat(this.mData));
                int unitType = this.mData & 0xF;
                switch (unitType) {
                    case 0: {
                        value = value + "px";
                        break;
                    }
                    case 1: {
                        value = value + "dp";
                        break;
                    }
                    case 2: {
                        value = value + "sp";
                        break;
                    }
                    case 3: {
                        value = value + "pt";
                        break;
                    }
                    case 4: {
                        value = value + "in";
                        break;
                    }
                    case 5: {
                        value = value + "mm";
                        break;
                    }
                    default: {
                        Log.w(TAG, "Unexpected value unit: " + unitType);
                        value = value + "??";
                    }
                }
                return value;
            }
            case 6: {
                String value = ResPrimitive.floatToString(ResPrimitive.complexToFloat(this.mData) * 100.0f);
                int unitType = this.mData & 0xF;
                switch (unitType) {
                    case 0: {
                        value = value + "%";
                        break;
                    }
                    case 1: {
                        value = value + "%p";
                        break;
                    }
                    default: {
                        Log.w(TAG, "Unexpected value unit: " + unitType);
                        value = value + "??";
                    }
                }
                return value;
            }
            case 18: {
                return this.mData != 0 ? "true" : "false";
            }
        }
        if (this.mType >= 28 && this.mType <= 31) {
            switch (this.mType) {
                default: {
                    return String.format("#%08x", this.mData);
                }
                case 29: {
                    return String.format("#%06x", this.mData & 0xFFFFFF);
                }
                case 30: {
                    return String.format("#%x%x%x%x", this.mData >>> 28 & 0xF, this.mData >>> 20 & 0xF, this.mData >>> 12 & 0xF, this.mData >>> 4 & 0xF);
                }
                case 31: 
            }
            return String.format("#%x%x%x", this.mData >>> 20 & 0xF, this.mData >>> 12 & 0xF, this.mData >>> 4 & 0xF);
        }
        if (this.mType >= 16 && this.mType <= 31) {
            switch (this.mType) {
                default: {
                    return Integer.toString(this.mData);
                }
                case 17: 
            }
            return String.format("0x%x", this.mData);
        }
        Log.w(TAG, "Unexpected value type: 0x%02x", this.mType);
        return "";
    }

    private static String floatToString(float value) {
        if (value == (float)((long)value)) {
            return String.format(Locale.ROOT, "%.1f", Float.valueOf(value));
        }
        return Float.toString(value);
    }

    private static float complexToFloat(int complex) {
        return (float)(complex & 0xFFFFFF00) * RADIX_MULTS[complex >> 4 & 3];
    }

    @Override
    public void serializeToValuesXml(XmlSerializer serial, ResEntry entry) throws AndrolibException, IOException {
        String typeName = entry.getType().getName();
        Set stdFormats = (Set)STANDARD_TYPE_FORMATS.get(typeName);
        String format = stdFormats != null ? this.getFormat() : null;
        boolean asItem = format != null && !stdFormats.contains(format);
        String tagName = asItem ? "item" : typeName;
        serial.startTag(null, tagName);
        if (asItem) {
            serial.attribute(null, "type", typeName);
        }
        serial.attribute(null, "name", entry.getName());
        if (asItem) {
            serial.attribute(null, "format", format);
        }
        serial.text(this.toXmlTextValue());
        serial.endTag(null, tagName);
    }

    public String toString() {
        return String.format("ResPrimitive{type=0x%02x, data=0x%08x}", this.mType, this.mData);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResPrimitive) {
            ResPrimitive other = (ResPrimitive)obj;
            return this.mType == other.mType && this.mData == other.mData;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mType, this.mData);
    }
}

