/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.table.value;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.table.ResEntry;
import brut.androlib.res.table.ResEntrySpec;
import brut.androlib.res.table.ResId;
import brut.androlib.res.table.ResPackage;
import brut.androlib.res.table.value.ResAttribute;
import brut.androlib.res.table.value.ResCustom;
import brut.androlib.res.table.value.ResItem;
import brut.androlib.res.table.value.ResPrimitive;
import brut.androlib.res.table.value.ResReference;
import brut.common.Log;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.xmlpull.v1.XmlSerializer;

public class ResEnum
extends ResAttribute {
    private static final String TAG = ResEnum.class.getName();
    private final ResAttribute.Symbol[] mSymbols;
    private Map<Integer, ResAttribute.Symbol[]> mSymbolsCache;
    private Map<Integer, String> mFormatsCache;

    public ResEnum(ResReference parent, int type, int min, int max, int l10n, ResAttribute.Symbol[] symbols) {
        super(parent, type, min, max, l10n);
        assert (parent != null && symbols != null);
        this.mSymbols = symbols;
    }

    @Override
    public void resolveKeys() throws AndrolibException {
        ResPackage pkg = this.mParent.getPackage();
        boolean skipUnresolved = pkg.getTable().getConfig().isDecodeResolveLazy();
        for (ResAttribute.Symbol symbol : this.mSymbols) {
            ResReference key = symbol.getKey();
            if (key.resolve() != null) continue;
            ResId keyId = key.getResId();
            if (skipUnresolved || keyId.pkgId() != pkg.getId()) {
                Log.w(TAG, "Unresolved enum reference: key=%s, value=%s", key, symbol.getValue());
                continue;
            }
            pkg.addEntrySpec(keyId.typeId(), keyId.entryId(), "APKTOOL_DUMMY_" + keyId);
            pkg.addEntry(keyId.typeId(), keyId.entryId(), ResCustom.ID);
        }
    }

    @Override
    protected ResAttribute.Symbol[] getSymbolsForValue(ResItem value) {
        if (!this.isSymbolValueType(value)) {
            return null;
        }
        int data = ((ResPrimitive)value).getData();
        return this.getSymbols(data);
    }

    private boolean isSymbolValueType(ResItem value) {
        if (!(value instanceof ResPrimitive)) {
            return false;
        }
        int type = value.getType();
        return type == 16 || type == 17;
    }

    private ResAttribute.Symbol[] getSymbols(int data) {
        if (this.mSymbolsCache == null) {
            this.mSymbolsCache = new HashMap<Integer, ResAttribute.Symbol[]>();
        } else if (this.mSymbolsCache.containsKey(data)) {
            return this.mSymbolsCache.get(data);
        }
        ResAttribute.Symbol[] symbols = new ResAttribute.Symbol[this.mSymbols.length];
        int symbolsCount = 0;
        for (ResAttribute.Symbol symbol : this.mSymbols) {
            if (symbol.getValue().getData() != data) continue;
            symbols[symbolsCount++] = symbol;
        }
        if (symbolsCount == 0) {
            symbols = null;
        } else if (symbolsCount < symbols.length) {
            symbols = Arrays.copyOf(symbols, symbolsCount);
        }
        this.mSymbolsCache.put(data, symbols);
        return symbols;
    }

    @Override
    protected String formatValueFromSymbols(ResItem value) throws AndrolibException {
        if (!this.isSymbolValueType(value)) {
            return null;
        }
        int data = ((ResPrimitive)value).getData();
        if (this.mFormatsCache == null) {
            this.mFormatsCache = new HashMap<Integer, String>();
        } else if (this.mFormatsCache.containsKey(data)) {
            return this.mFormatsCache.get(data);
        }
        ResAttribute.Symbol[] symbols = this.getSymbols(data);
        String formatted = null;
        if (symbols != null) {
            for (ResAttribute.Symbol symbol : symbols) {
                ResEntrySpec keySpec = symbol.getKey().resolve();
                if (keySpec == null) continue;
                formatted = keySpec.getName();
                if (data != -1 || !formatted.equals("fill_parent")) break;
            }
        }
        this.mFormatsCache.put(data, formatted);
        return formatted;
    }

    @Override
    protected void serializeSymbolsToValuesXml(XmlSerializer serial, ResEntry entry) throws AndrolibException, IOException {
        for (ResAttribute.Symbol symbol : this.mSymbols) {
            ResEntrySpec keySpec = symbol.getKey().resolve();
            if (keySpec == null) continue;
            serial.startTag(null, "enum");
            serial.attribute(null, "name", keySpec.getName());
            serial.attribute(null, "value", symbol.getValue().toXmlAttributeValue());
            serial.endTag(null, "enum");
        }
    }

    @Override
    public String toString() {
        return String.format("ResEnum{parent=%s, type=0x%04x, min=%s, max=%s, l10n=%s, symbols=%s}", this.mParent, this.mType, this.mMin, this.mMax, this.mL10n, Arrays.toString(this.mSymbols));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResEnum) {
            ResEnum other = (ResEnum)obj;
            return this.mParent.equals(other.mParent) && this.mType == other.mType && this.mMin == other.mMin && this.mMax == other.mMax && this.mL10n == other.mL10n && Arrays.equals(this.mSymbols, other.mSymbols);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mParent, this.mType, this.mMin, this.mMax, this.mL10n, Arrays.hashCode(this.mSymbols));
    }
}

