/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.table.value;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.table.ResEntry;
import brut.androlib.res.table.ResEntrySpec;
import brut.androlib.res.table.value.ResBag;
import brut.androlib.res.table.value.ResItem;
import brut.androlib.res.table.value.ResReference;
import java.io.IOException;
import java.util.Arrays;
import org.xmlpull.v1.XmlSerializer;

public class ResArray
extends ResBag {
    private final ResItem[] mItems;

    public ResArray(ResReference parent, ResItem[] items) {
        super(parent);
        assert (items != null);
        this.mItems = items;
    }

    public static ResArray parse(ResReference parent, ResBag.RawItem[] rawItems) {
        ResItem[] items = new ResItem[rawItems.length];
        for (int i = 0; i < rawItems.length; ++i) {
            items[i] = rawItems[i].getValue();
        }
        return new ResArray(parent, items);
    }

    @Override
    public void serializeToValuesXml(XmlSerializer serial, ResEntry entry) throws AndrolibException, IOException {
        ResItem[] format = this.resolveFormat();
        String tagName = "array";
        if (format != null) {
            switch (format) {
                case "string": 
                case "integer": {
                    tagName = (String)format + "-" + tagName;
                }
            }
        }
        serial.startTag(null, tagName);
        serial.attribute(null, "name", entry.getName());
        for (ResItem value : this.mItems) {
            serial.startTag(null, "item");
            serial.text(value.toXmlTextValue());
            serial.endTag(null, "item");
        }
        serial.endTag(null, tagName);
    }

    private String resolveFormat() {
        String format = null;
        for (ResItem value : this.mItems) {
            String itemFormat = null;
            if (value instanceof ResReference) {
                try {
                    ResEntrySpec spec = ((ResReference)value).resolve();
                    if (spec != null) {
                        itemFormat = spec.getTypeSpec().getName();
                    }
                }
                catch (AndrolibException androlibException) {}
            } else {
                itemFormat = value.getFormat();
            }
            if (itemFormat == null) continue;
            if (format == null) {
                format = itemFormat;
                continue;
            }
            if (format.equals(itemFormat)) continue;
            format = null;
            break;
        }
        return format;
    }

    public String toString() {
        return String.format("ResArray{items=%s}", Arrays.toString(this.mItems));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResArray) {
            ResArray other = (ResArray)obj;
            return Arrays.equals(this.mItems, other.mItems);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.mItems);
    }
}

